// Copyright (C) 2015 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
es6id: 25.1.3.27
description: Length of String.prototype[ @@iterator ]
info: >
    ES6 Section 17:
    Every built-in Function object, including constructors, has a length
    property whose value is an integer. Unless otherwise specified, this value
    is equal to the largest number of named arguments shown in the subclause
    headings for the function description, including optional parameters.

    [...]

    Unless otherwise specified, the length property of a built-in Function
    object has the attributes { [[Writable]]: false, [[Enumerable]]: false,
    [[Configurable]]: true }.
features: [Symbol.iterator]
includes: [propertyHelper.js]
---*/

assert.sameValue(String.prototype[Symbol.iterator].length, 0);

verifyNotEnumerable(String.prototype[Symbol.iterator], 'length');
verifyNotWritable(String.prototype[Symbol.iterator], 'length');
verifyConfigurable(String.prototype[Symbol.iterator], 'length');
