// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 25.4.1.5.1
description: The [[Prototype]] of GetCapabilitiesExecutor functions
info: >
  17 ECMAScript Standard Built-in Objects:
    Unless otherwise specified every built-in function and every built-in
    constructor has the Function prototype object, which is the initial
    value of the expression Function.prototype (19.2.3), as the value of
    its [[Prototype]] internal slot.
---*/

var executorFunction;
function NotPromise(executor) {
  executorFunction = executor;
  executor(function(){}, function(){});
}
Promise.resolve.call(NotPromise);

assert.sameValue(Object.getPrototypeOf(executorFunction), Function.prototype);
