//@ defaultRunNoisyTest

var jsStrictMode = false;
var ENGINE_UNKNOWN = 0;
var ENGINE_SPIDERMONKEY_TRUNK = 1;
var ENGINE_SPIDERMONKEY_MOZILLA45 = 3;
var ENGINE_JAVASCRIPTCORE = 4;var engine = ENGINE_UNKNOWN;
var jsshell = (typeof window == "undefined");
var xpcshell = jsshell && (typeof Components == "object");
var dump;
var dumpln;
var printImportant;
if (jsshell) {
  dumpln = print;
  printImportant = function(s) { dumpln("***"); dumpln(s); };
  if (typeof verifyprebarriers == "function") {
    
    
    
    if (typeof wasmIsSupported == "function") {
      engine = ENGINE_SPIDERMONKEY_TRUNK;
    } else {
      engine = ENGINE_SPIDERMONKEY_MOZILLA45;
    }    
    readline = function(){};    
    version(180);
  } else if (typeof XPCNativeWrapper == "function") {
    
    engine = ENGINE_SPIDERMONKEY_TRUNK;
  } else if (typeof debug == "function") {
    engine = ENGINE_JAVASCRIPTCORE;
  }
} else {
  if (navigator.userAgent.indexOf("WebKit") != -1) {
    
    engine = ENGINE_JAVASCRIPTCORE;
    
    dump = function(s) { console.log(s); };
  } else if (navigator.userAgent.indexOf("Gecko") != -1) {
    engine = ENGINE_SPIDERMONKEY_TRUNK;
  } else if (typeof dump != "function") {
    
    dump = function() { };
  }
  dumpln = function(s) { dump(s + "\n"); };  printImportant = function(s) {
    dumpln(s);
    var p = document.createElement("pre");
    p.appendChild(document.createTextNode(s));
    document.body.appendChild(p);
  };
}if (typeof gc == "undefined")
  this.gc = function(){};
var gcIsQuiet = !(gc()); 
var HOTLOOP = 60;
function loopCount() { return rnd(rnd(HOTLOOP * 3)); }
function loopModulo() { return (rnd(2) ? rnd(rnd(HOTLOOP * 2)) : rnd(5)) + 2; }function simpleSource(s)
{
  function hexify(c)
  {
    var code = c.charCodeAt(0);
    var hex = code.toString(16);
    while (hex.length < 4)
      hex = "0" + hex;
    return "\\u" + hex;
  }  if (typeof s == "string")
    return ("\"" +
      s.replace(/\\/g, "\\\\")
       .replace(/\"/g, "\\\"")
       .replace(/\0/g, "\\0")
       .replace(/\n/g, "\\n")
       .replace(/[^ -~]/g, hexify) + 
      "\"");
  else
    return "" + s; 
}var haveRealUneval = (typeof uneval == "function");
if (!haveRealUneval)
  uneval = simpleSource;if (engine == ENGINE_UNKNOWN)
  printImportant("Targeting an unknown JavaScript engine!");
else if (engine == ENGINE_SPIDERMONKEY_TRUNK)
  printImportant("Targeting SpiderMonkey / Gecko (trunk).");
else if (engine == ENGINE_SPIDERMONKEY_MOZILLA45)
  printImportant("Targeting SpiderMonkey / Gecko (ESR45 branch).");
else if (engine == ENGINE_JAVASCRIPTCORE)
  printImportant("Targeting JavaScriptCore / WebKit.");
function whatToTestSpidermonkeyTrunk(code)
{
  /* jshint laxcomma: true */
  
  var codeL = code.replace(/\s/g, " ");  return {    allowParse: true,    allowExec: unlikelyToHang(code)
      && (jsshell || code.indexOf("nogeckoex") == -1)
    ,    allowIter: true,    
    
    expectConsistentOutput: true
       && (gcIsQuiet || code.indexOf("gc") == -1)
       && code.indexOf("/*NODIFF*/") == -1                
       && code.indexOf(".script") == -1                   
       && code.indexOf(".parameterNames") == -1           
       && code.indexOf(".environment") == -1              
       && code.indexOf(".onNewGlobalObject") == -1        
       && code.indexOf(".takeCensus") == -1               
       && code.indexOf(".findScripts") == -1              
       && code.indexOf("Date") == -1                      
       && code.indexOf("backtrace") == -1                 
       && code.indexOf("drainAllocationsLog") == -1       
       && code.indexOf("dumpObject") == -1                
       && code.indexOf("dumpHeap") == -1                  
       && code.indexOf("dumpStringRepresentation") == -1  
       && code.indexOf("evalInWorker") == -1              
       && code.indexOf("getBacktrace") == -1              
       && code.indexOf("getLcovInfo") == -1
       && code.indexOf("load") == -1                      
       && code.indexOf("offThreadCompileScript") == -1    
       && code.indexOf("oomAfterAllocations") == -1
       && code.indexOf("oomAtAllocation") == -1
       && code.indexOf("printProfilerEvents") == -1       
       && code.indexOf("validategc") == -1
       && code.indexOf("inIon") == -1                     
       && code.indexOf("inJit") == -1                     
       && code.indexOf("random") == -1
       && code.indexOf("timeout") == -1                   
    ,    expectConsistentOutputAcrossIter: true
    
       && code.indexOf("options") == -1             
    ,    expectConsistentOutputAcrossJITs: true
    
       && code.indexOf("'strict") == -1                 
       && code.indexOf("disassemble") == -1             
       && code.indexOf(".length") == -1                 
       && code.indexOf(".splice") == -1                 
       && !( codeL.match(/\/.*[\u0000\u0080-\uffff]/))    };
}function whatToTestSpidermonkeyMozilla45(code)
{
  /* jshint laxcomma: true */
  
  var codeL = code.replace(/\s/g, " ");  return {    allowParse: true,    allowExec: unlikelyToHang(code)
      && (jsshell || code.indexOf("nogeckoex") == -1)
    ,    allowIter: true,    
    
    expectConsistentOutput: true
       && (gcIsQuiet || code.indexOf("gc") == -1)
       && code.indexOf("/*NODIFF*/") == -1                
       && code.indexOf(".script") == -1                   
       && code.indexOf(".parameterNames") == -1           
       && code.indexOf(".environment") == -1              
       && code.indexOf(".onNewGlobalObject") == -1        
       && code.indexOf(".takeCensus") == -1               
       && code.indexOf(".findScripts") == -1              
       && code.indexOf("Date") == -1                      
       && code.indexOf("backtrace") == -1                 
       && code.indexOf("drainAllocationsLog") == -1       
       && code.indexOf("dumpObject") == -1                
       && code.indexOf("dumpHeap") == -1                  
       && code.indexOf("dumpStringRepresentation") == -1  
       && code.indexOf("evalInWorker") == -1              
       && code.indexOf("getBacktrace") == -1              
       && code.indexOf("getLcovInfo") == -1
       && code.indexOf("load") == -1                      
       && code.indexOf("offThreadCompileScript") == -1    
       && code.indexOf("oomAfterAllocations") == -1
       && code.indexOf("oomAtAllocation") == -1
       && code.indexOf("printProfilerEvents") == -1       
       && code.indexOf("validategc") == -1
       && code.indexOf("inIon") == -1                     
       && code.indexOf("inJit") == -1                     
       && code.indexOf("random") == -1
       && code.indexOf("timeout") == -1                   
    ,    expectConsistentOutputAcrossIter: true
    
       && code.indexOf("options") == -1             
    ,    expectConsistentOutputAcrossJITs: true
    
        && code.indexOf("'strict") == -1                 
        && code.indexOf("disassemble") == -1             
        && code.indexOf(".length") == -1                 
        && code.indexOf("preventExtensions") == -1       
        && code.indexOf("Math.round") == -1              
        && code.indexOf("with") == -1                    
        && code.indexOf("Number.MAX_VALUE") == -1        
        && code.indexOf("arguments") == -1               
        && code.indexOf(".splice") == -1                 
        && !( codeL.match(/\/.*[\u0000\u0080-\uffff]/))    };
}function whatToTestJavaScriptCore(code)
{
  return {    allowParse: true,
    allowExec: unlikelyToHang(code),
    allowIter: false, 
    expectConsistentOutput: false,
    expectConsistentOutputAcrossIter: false,
    expectConsistentOutputAcrossJITs: false  };
}function whatToTestGeneric(code)
{
  return {
    allowParse: true,
    allowExec: unlikelyToHang(code),
    allowIter: (typeof Iterator == "function"),
    expectConsistentOutput: false,
    expectConsistentOutputAcrossIter: false,
    expectConsistentOutputAcrossJITs: false
  };
}var whatToTest;
if (engine == ENGINE_SPIDERMONKEY_TRUNK)
  whatToTest = whatToTestSpidermonkeyTrunk;
else if (engine == ENGINE_SPIDERMONKEY_MOZILLA45)
  whatToTest = whatToTestSpidermonkeyMozilla45;
else if (engine == ENGINE_JAVASCRIPTCORE)
  whatToTest = whatToTestJavaScriptCore;
else
  whatToTest = whatToTestGeneric;
function unlikelyToHang(code)
{
  var codeL = code.replace(/\s/g, " ");  
  return true
    && code.indexOf("infloop") == -1
    && !( codeL.match( /for.*in.*uneval/ )) 
    && !( codeL.match( /for.*for.*for/ )) 
    && !( codeL.match( /for.*for.*gc/ ))
    ;
}
function confused(s)
{
  if (jsshell) {
    
    print("jsfunfuzz broke its own scripting environment: " + s);
    quit();
  }
}function foundABug(summary, details)
{
  
  
  printImportant("Found" + " a bug: " + summary);
  if (details) {
    printImportant(details);
  }
  if (jsshell) {
    dumpln("jsfunfuzz stopping due to finding a bug.");
    quit();
  }
}function errorToString(e)
{
  try {
    return ("" + e);
  } catch (e2) {
    return "Can't toString the error!!";
  }
}function errorstack()
{
  print("EEE");
  try {
    void ([].qwerty.qwerty);
  } catch(e) { print(e.stack); }
}
var Random = {
  twister: null,  init: function (seed) {
    if (seed == null || seed === undefined) {
      seed = new Date().getTime();
    }
    this.twister = new MersenneTwister19937();
    this.twister.seed(seed);
  },
  number: function (limit) {
    if (limit == 0) {
      return limit;
    }
    if (limit == null || limit === undefined) {
      limit = 0xffffffff;
    }
    return (Random.twister.int32() >>> 0) % limit;
  },
  float: function () {
    return (Random.twister.int32() >>> 0) * (1.0/4294967295.0);
  },
  range: function (start, limit) {
    if (isNaN(start) || isNaN(limit)) {
      Utils.traceback();
      throw new TypeError("Random.range() received a non number type: '" + start + "', '" + limit + "')");
    }
    return Random.number(limit - start + 1) + start;
  },
  index: function (list, emptyr) {
    if (!(list instanceof Array || (typeof list != "string" && "length" in list))) {
      Utils.traceback();
      throw new TypeError("Random.index() received a non array type: '" + list + "'");
    }
    if (!list.length)
      return emptyr;
    return list[this.number(list.length)];
  },
  key: function (obj) {
    var list = [];
    for (var i in obj) {
      list.push(i);
    }
    return this.index(list);
  },
  bool: function () {
    return this.index([true, false]);
  },
  pick: function (obj) {
    if (typeof obj == "function") {
      return obj();
    }
    if (obj instanceof Array) {
      return this.pick(this.index(obj));
    }
    return obj;
  },
  chance: function (limit) {
    if (limit == null || limit === undefined) {
      limit = 2;
    }
    if (isNaN(limit)) {
      Utils.traceback();
      throw new TypeError("Random.chance() received a non number type: '" + limit + "'");
    }
    return this.number(limit) == 1;
  },
  choose: function (list, flat) {
    if (!(list instanceof Array)) {
      Utils.traceback();
      throw new TypeError("Random.choose() received a non-array type: '" + list + "'");
    }
    var total = 0;
    for (var i = 0; i < list.length; i++) {
      total += list[i][0];
    }
    var n = this.number(total);
    for (var i = 0; i < list.length; i++) {
      if (n <= list[i][0]) {
        if (flat == true) {
          return list[i][1];
        } else {
          return this.pick([list[i][1]]);
        }
      }
      n = n - list[i][0];
    }
    if (flat == true) {
      return list[0][1];
    }
    return this.pick([list[0][1]]);
  },
  weighted: function (wa) {
    
    var a = [];
    for (var i = 0; i < wa.length; ++i) {
      for (var j = 0; j < wa[i].w; ++j) {
        a.push(wa[i].v);
      }
    }
    return a;
  },
  use: function (obj) {
    return Random.bool() ? obj : "";
  },
  shuffle: function (arr) {
    var len = arr.length;
    var i = len;
    while (i--) {
      var p = Random.number(i + 1);
      var t = arr[i];
      arr[i] = arr[p];
      arr[p] = t;
    }
  },
  shuffled: function (arr) {
    var newArray = arr.slice();
    Random.shuffle(newArray);
    return newArray;
  },
  subset: function(a) {
    
    
    var subset = [];
    for (var i = 0; i < a.length; ++i) {
      if (rnd(2)) {
        subset.push(a[i]);
      }
    }
    return subset;
  },};function rnd(n) { return Random.number(n); }
/*
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
   Any feedback is very welcome.
   http:
   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)
*/
function MersenneTwister19937()
{
  const N = 624;
  const M = 397;
  const MAG01 = new Int32Array([0, 0x9908b0df]);  var mt = new Int32Array(N);   /* the array for the state vector */
  var mti = 625;  this.seed = function (s) {
    mt[0] = s | 0;
    for (mti=1; mti<N; mti++) {
      mt[mti] = Math.imul(1812433253, mt[mti-1] ^ (mt[mti-1] >>> 30)) + mti;
    }
  };  this.export_state = function() { return [mt, mti]; };
  this.import_state = function(s) { mt = s[0]; mti = s[1]; };
  this.export_mta = function() { return mt; };
  this.import_mta = function(_mta) { mt = _mta; };
  this.export_mti = function() { return mti; };
  this.import_mti = function(_mti) { mti = _mti; };  function mag01(y)
  {
    return MAG01[y & 0x1];
  }  this.int32 = function () {
    var y;
    var kk;    if (mti >= N) { /* generate N words at one time */
      for (kk=0;kk<N-M;kk++) {
        y = ((mt[kk]&0x80000000)|(mt[kk+1]&0x7fffffff));
        mt[kk] = (mt[kk+M] ^ (y >>> 1) ^ mag01(y));
      }
      for (;kk<N-1;kk++) {
        y = ((mt[kk]&0x80000000)|(mt[kk+1]&0x7fffffff));
        mt[kk] = (mt[kk+(M-N)] ^ (y >>> 1) ^ mag01(y));
      }
      y = ((mt[N-1]&0x80000000)|(mt[0]&0x7fffffff));
      mt[N-1] = (mt[M-1] ^ (y >>> 1) ^ mag01(y));
      mti = 0;
    }    y = mt[mti++];    /* Tempering */
    y = y ^ (y >>> 11);
    y = y ^ ((y << 7) & 0x9d2c5680);
    y = y ^ ((y << 15) & 0xefc60000);
    y = y ^ (y >>> 18);    return y;
  };
}
function fuzzTestingFunctionsCtor(browser, fGlobal, fObject)
{
  var prefix = browser ? "fuzzPriv." : "";  function numberOfAllocs() { return Math.floor(Math.exp(rnd(rnd(6000)) / 1000)); }
  function gcSliceSize() { return Math.floor(Math.pow(2, Random.float() * 32)); }
  function maybeCommaShrinking() { return rnd(5) ? "" : ", 'shrinking'"; }  function enableGCZeal()
  {
    var level = rnd(15);
    if (browser && level == 9) level = 0; 
    var period = numberOfAllocs();
    return prefix + "gczeal" + "(" + level + ", " + period + ");";
  }  function callSetGCCallback() {
    
    var phases = Random.index(["both", "begin", "end"]);
    var actionAndOptions = rnd(2) ? 'action: "majorGC", depth: ' + rnd(17) : 'action: "minorGC"';
    var arg = "{ " + actionAndOptions + ", phases: \"" + phases + "\" }";
    return prefix + "setGCCallback(" + arg + ");";
  }  function tryCatch(statement)
  {
    return "try { " + statement + " } catch(e) { }";
  }  function setGcparam() {
    switch(rnd(2)) {
      case 0:  return _set("sliceTimeBudget", rnd(100));
      default: return _set("markStackLimit", rnd(2) ? (1 + rnd(30)) : 4294967295); 
    }    function _set(name, value) {
      
      return tryCatch(prefix + "gcparam" + "('" + name + "', " + value + ");");
    }
  }  
  
  var sharedTestingFunctions = [
    
    { w: 10, v: function(d, b) { return "void " + prefix + "gc" + "("                                            + ");"; } },
    { w: 10, v: function(d, b) { return "void " + prefix + "gc" + "(" + "'compartment'" + maybeCommaShrinking() + ");"; } },
    { w: 5,  v: function(d, b) { return "void " + prefix + "gc" + "(" + fGlobal(d, b)   + maybeCommaShrinking() + ");"; } },    
    { w: 20, v: function(d, b) { return prefix + "minorgc" + "(false);"; } },
    { w: 20, v: function(d, b) { return prefix + "minorgc" + "(true);"; } },    
    
    { w: 20, v: function(d, b) { return tryCatch(prefix + "startgc" + "(" + gcSliceSize() + maybeCommaShrinking() + ");"); } },
    { w: 20, v: function(d, b) { return prefix + "gcslice" + "(" + gcSliceSize() + ");"; } },
    { w: 10, v: function(d, b) { return prefix + "abortgc" + "(" + ");"; } },    
    { w: 10, v: function(d, b) { return prefix + "selectforgc" + "(" + fObject(d, b) + ");"; } },    
    { w: 10, v: function(d, b) { return "void " + prefix + "schedulegc" + "(" + fGlobal(d, b) + ");"; } },    
    { w: 10, v: function(d, b) { return "void " + prefix + "schedulegc" + "(" + numberOfAllocs() + ");"; } },    
    { w: 10, v: setGcparam },    
    
    
    { w: 10, v: function(d, b) { return prefix + "verifyprebarriers" + "();"; } },    
    
    { w: 1,  v: function(d, b) { return "void " + prefix + "hasChild(" + fObject(d, b) + ", " + fObject(d, b) + ");"; } },    
    { w: 5,  v: function(d, b) { return prefix + "validategc" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "validategc" + "(true);"; } },
    { w: 5,  v: function(d, b) { return prefix + "fullcompartmentchecks" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "fullcompartmentchecks" + "(true);"; } },
    { w: 5,  v: function(d, b) { return prefix + "setIonCheckGraphCoherency" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "setIonCheckGraphCoherency" + "(true);"; } },
    { w: 1,  v: function(d, b) { return prefix + "enableOsiPointRegisterChecks" + "();"; } },    
    { w: 1,  v: function(d, b) { return prefix + "assertJitStackInvariants" + "();"; } },    
    { w: 1,  v: function(d, b) { return prefix + "setJitCompilerOption" + "('baseline.warmup.trigger', " + rnd(20) + ");"; } },
    { w: 1,  v: function(d, b) { return prefix + "setJitCompilerOption" + "('ion.warmup.trigger', " + rnd(40) + ");"; } },    
    { w: 1,  v: function(d, b) { return prefix + "setJitCompilerOption" + "('ion.forceinlineCaches\', " + rnd(2) + ");"; } },    
    
    { w: 1,  v: function(d, b) { return tryCatch(prefix + "setJitCompilerOption" + "('ion.enable', " + rnd(2) + ");"); } },
    { w: 1,  v: function(d, b) { return tryCatch(prefix + "setJitCompilerOption" + "('baseline.enable', " + rnd(2) + ");"); } },    
    { w: 1,  v: function(d, b) { return prefix + "enableSPSProfiling" + "();"; } },
    { w: 1,  v: function(d, b) { return prefix + "enableSPSProfilingWithSlowAssertions" + "();"; } },
    { w: 5,  v: function(d, b) { return prefix + "disableSPSProfiling" + "();"; } },
    { w: 1,  v: function(d, b) { return "void " + prefix + "readSPSProfilingStack" + "();"; } },    
    { w: 5,  v: function(d, b) { return prefix + "deterministicgc" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "deterministicgc" + "(true);"; } },    
    { w: 5,  v: function(d, b) { return prefix + "gcPreserveCode" + "();"; } },    
    { w: 1,  v: function(d, b) { return "void " + prefix + "getLcovInfo" + "();"; } },
    { w: 1,  v: function(d, b) { return "void " + prefix + "getLcovInfo" + "(" + fGlobal(d, b) + ");"; } },
  ];  
  
  var shellOnlyTestingFunctions = [
    
    { w: 5,  v: function(d, b) { return prefix + "bailout" + "();"; } },    
    
    { w: 1,  v: function(d, b) { return tryCatch("(void" + prefix + "disableSingleStepProfiling" + "()" + ")"); } },
    { w: 1,  v: function(d, b) { return tryCatch("(" + prefix + "enableSingleStepProfiling" + "()" + ")"); } },    
    { w: 10, v: function(d, b) { return "void " + prefix + "relazifyFunctions" + "();"; } },
    { w: 10, v: function(d, b) { return "void " + prefix + "relazifyFunctions" + "('compartment');"; } },
    { w: 5,  v: function(d, b) { return "void " + prefix + "relazifyFunctions" + "(" + fGlobal(d, b) + ");"; } },    
    
    { w: 1,  v: function(d, b) { return (typeof oomAfterAllocations == "function" && rnd(1000) === 0) ? prefix + "oomAfterAllocations" + "(" + (numberOfAllocs() - 1) + ");" : "void 0;"; } },
    
    { w: 1,  v: function(d, b) { return (typeof oomAtAllocation == "function" && rnd(100) === 0) ? prefix + "oomAtAllocation" + "(" + (numberOfAllocs() - 1) + ");" : "void 0;"; } },
    
    { w: 1,  v: function(d, b) { return (typeof resetOOMFailure == "function") ? "void " + prefix + "resetOOMFailure" + "(" + ");" : "void 0;"; } },    
    
    { w: 1,  v: function(d, b) { return (rnd(100) === 0) ? (enableGCZeal()) : "void 0;"; } },    { w: 10, v: callSetGCCallback },
  ];  var testingFunctions = Random.weighted(browser ? sharedTestingFunctions : sharedTestingFunctions.concat(shellOnlyTestingFunctions));  return { testingFunctions: testingFunctions, enableGCZeal: enableGCZeal };
}
/*
        It might be more interesting to use Object.getOwnPropertyDescriptor to find out if
        a thing is exposed as a getter (like Debugger.prototype.enabled).  But there are exceptions:        <Jesse> why is Array.prototype.length not a getter? http:
        <jorendorff> backward compatibility
        <jorendorff> ES3 already allowed programs to create objects with arbitrary __proto__
        <jorendorff> .length was specified to work as a data property; accessor properties inherit differently, especially when setting
        <jorendorff> maybe only when setting, come to think of it
        <jorendorff> I guess it could've been made an accessor property without breaking anything important. I didn't realize it at the time.
*/var constructors = []; 
var builtinFunctions = []; 
var builtinProperties = []; 
var allMethodNames = []; 
var allPropertyNames = []; var builtinObjectNames = []; 
var builtinObjects = {}; (function exploreBuiltins(glob, debugMode) {  function exploreDeeper(a, an)
  {
    if (!a)
      return;
    var hns = Object.getOwnPropertyNames(a);
    var propertyNames = [];
    for (var j = 0; j < hns.length; ++j) {
      var hn = hns[j];
      propertyNames.push(hn);
      allPropertyNames.push(hn);      var fullName = an + "." + hn;
      builtinProperties.push(fullName);      var h;
      try {
        h = a[hn];
      } catch(e) {
        if (debugMode) {
          dumpln("Threw: " + fullName);
        }
        h = null;
      }      if (typeof h == "function" && hn != "constructor") {
        allMethodNames.push(hn);
        builtinFunctions.push(fullName);
      }
    }
    builtinObjects[an] = propertyNames;
    builtinObjectNames.push(an);
  }  function exploreConstructors()
  {
    var gns = Object.getOwnPropertyNames(glob);
    for (var i = 0; i < gns.length; ++i) {
      var gn = gns[i];
      
      
      if (0x40 < gn.charCodeAt(0) && gn.charCodeAt(0) < 0x60 && gn != "PerfMeasurement" && !(jsshell && gn == "Worker")) {
        var g = glob[gn];
        if (typeof g == "function" && g.toString().indexOf("[native code]") != -1) {
          constructors.push(gn);
          builtinProperties.push(gn);
          builtinFunctions.push(gn);
          exploreDeeper(g, gn);
          exploreDeeper(g.prototype, gn + ".prototype");
        }
      }
    }
  }  exploreConstructors();  exploreDeeper(Math, "Math");
  exploreDeeper(JSON, "JSON");
  exploreDeeper(Proxy, "Proxy");  if (debugMode) {
    for (let x of constructors) print("^^^^^ " + x);
    for (let x of builtinProperties) print("***** " + x);
    for (let x of builtinFunctions) print("===== " + x);
    for (let x of allMethodNames) print("!!!!! " + x);
    for (let x of allPropertyNames) print("&&&&& " + x);
    print(uneval(builtinObjects));
    quit();
  }})(this, false);function cat(toks)
{
  if (rnd(1700) === 0)
    return totallyRandom(2, ["x"]);  var torture = (rnd(1700) === 57);
  if (torture)
    dumpln("Torture!!!");  var s = maybeLineBreak();
  for (var i = 0; i < toks.length; ++i) {    
    
    
    
    
    if (typeof(toks[i]) != "string") {
      dumpln("Strange item in the array passed to cat: typeof toks[" + i + "] == " + typeof(toks[i]));
      dumpln(cat.caller);
      dumpln(cat.caller.caller);
    }    if (!(torture && rnd(12) === 0))
      s += toks[i];    s += maybeLineBreak();    if (torture) switch(rnd(120)) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        s += maybeSpace() + totallyRandom(2, ["x"]) + maybeSpace();
        break;
      case 5:
        s = "(" + s + ")"; 
        break;
      case 6:
        s = ""; 
        break;
      case 7:
        return s; 
      case 8:
        s += UNTERMINATED_COMMENT;
        break;
      case 9:
        s += UNTERMINATED_STRING_LITERAL;
        break;
      case 10:
        if (rnd(2))
          s += "(";
        s += UNTERMINATED_REGEXP_LITERAL;
        break;
      default:
    }  }  return s;
}
/*
function catNice(toks)
{
  var s = ""
  var i;
  for (i=0; i<toks.length; ++i) {
    if(typeof(toks[i]) != "string")
      confused("Strange toks[i]: " + toks[i]);    s += toks[i];
  }  return s;
}
*/
var UNTERMINATED_COMMENT = "/*"; /* this comment is here so my text editor won't get confused */
var UNTERMINATED_STRING_LITERAL = "'";
var UNTERMINATED_REGEXP_LITERAL = "/";function maybeLineBreak()
{
  if (rnd(900) === 3)
    return Random.index(["\r", "\n", "//h\n", "/*\n*/"]);
  else if (rnd(400) === 3)
    return rnd(2) ? "\u000C" : "\t"; 
  else
    return "";
}function maybeSpace()
{
  if (rnd(2) === 0)
    return " ";
  else
    return "";
}function stripSemicolon(c)
{
  var len = c.length;
  if (c.charAt(len - 1) == ";")
    return c.substr(0, len - 1);
  else
    return c;
}var TOTALLY_RANDOM = 1000;var allMakers = getListOfMakers(this);function totallyRandom(d, b) {
  d = d + (rnd(5) - 2);   var maker = Random.index(allMakers);
  var val = maker(d, b);
  if (typeof val != "string") {
    print(maker.name);
    print(maker);
    throw "We generated something that isn't a string!";
  }
  return val;
}function getListOfMakers(glob)
{
  var r = [];
  for (var f in glob) {
    if (f.indexOf("make") == 0 && typeof glob[f] == "function" && f != "makeFinalizeObserver" && f != "makeFakePromise") {
      r.push(glob[f]);
    }
  }
  return r;
}
/*
function testEachMaker()
{
  for (var f of allMakers) {
    dumpln("");
    dumpln(f.name);
    dumpln("==========");
    dumpln("");
    for (var i = 0; i < 100; ++i) {
      try {
        var r = f(8, ["A", "B"]);
        if (typeof r != "string")
          throw ("Got a " + typeof r);
        dumpln(r);
      } catch(e) {
        dumpln("");
        dumpln(uneval(e));
        dumpln(e.stack);
        dumpln("");
        throw "testEachMaker found a bug in jsfunfuzz";
      }
    }
    dumpln("");
  }
}
*/
/***************************
 * GENERATE ASM.JS MODULES *
 ***************************/
function asmJSInterior(foreignFunctions, sanePlease)
{
  function mess()
  {
    if (!sanePlease && rnd(600) === 0)
      return makeStatement(8, ["x"]) + "\n";
    if (!sanePlease && rnd(600) === 0)
      return totallyRandom(8, ["x"]);
    return "";
  }  var globalEnv = {stdlibImported: {}, stdlibImports: "", heapImported: {}, heapImports: "", foreignFunctions: foreignFunctions, sanePlease: !!sanePlease};
  var asmFunDecl = asmJsFunction(globalEnv, "f", rnd(2) ? "signed" : "double", [rnd(2) ? "i0" : "d0", rnd(2) ? "i1" : "d1"]);
  var interior = mess() + globalEnv.stdlibImports +
                 mess() + importForeign(foreignFunctions) +
                 mess() + globalEnv.heapImports +
                 mess() + asmFunDecl +
                 mess() + "  return f;" +
                 mess();
  return interior;
}function importForeign(foreignFunctions)
{
  var s = "";
  for (let h of foreignFunctions) {
    s += "  var " + h + " = foreign." + h + ";\n";
  }
  return s;
}function asmJsFunction(globalEnv, name, ret, args)
{
  var s = "  function " + name + "(" + args.join(", ") + ")\n";
  s += "  {\n";
  s += parameterTypeAnnotations(args);  
  var locals = args;
  while (rnd(2)) {
    var isDouble = rnd(2);
    var local = (isDouble ? "d" : "i") + locals.length;
    s += "    var " + local + " = " + (isDouble ? doubleLiteral() : "0") + ";\n";
    locals.push(local);
  }  var env = {globalEnv: globalEnv, locals: locals, ret: ret};  
  if (locals.length) {
    while (rnd(5)) {
      s += asmStatement("    ", env, 6);
    }
  }  
  if (ret != "void" || rnd(2))
  s += asmReturnStatement("    ", env);  s += "  }\n";  return s;
}function asmStatement(indent, env, d)
{
  if (!env.globalEnv.sanePlease && rnd(100) === 0)
    return makeStatement(3, ["x"]);  if (rnd(5) === 0 && d > 0) {
    return indent + "{\n" + asmStatement(indent + "  ", env, d - 1) + indent + "}\n";
  }
  if (rnd(20) === 0 && d > 3) {
    return asmSwitchStatement(indent, env, d);
  }
  if (rnd(10) === 0) {
    return asmReturnStatement(indent, env);
  }
  if (rnd(50) === 0 && env.globalEnv.foreignFunctions.length) {
    return asmVoidCallStatement(indent, env);
  }
  if (rnd(100) === 0)
    return ";";
  return asmAssignmentStatement(indent, env);
}function asmVoidCallStatement(indent, env)
{
  return indent + asmFfiCall(8, env) + ";\n";
}function asmAssignmentStatement(indent, env)
{
  if (rnd(5) === 0 || !env.locals.length) {
    if (rnd(2)) {
      return indent + intishMemberExpr(8, env) + " = " + intishExpr(10, env) + ";\n";
    } else {
      return indent + doublishMemberExpr(8, env) + " = " + doublishExpr(10, env) + ";\n";
    }
  }  var local = Random.index(env.locals);
    if (local.charAt(0) == "d") {
    return indent + local + " = " + doubleExpr(10, env) + ";\n";
  } else {
    return indent + local + " = " + intExpr(10, env) + ";\n";
  }
}function asmReturnStatement(indent, env)
{
  var ret = rnd(2) ? env.ret : Random.index(["double", "signed", "void"]);
  if (env.ret == "double")
    return indent + "return +" + doublishExpr(10, env) + ";\n";
  else if (env.ret == "signed")
    return indent + "return (" + intishExpr(10, env) + ")|0;\n";
  else 
    return indent + "return;\n";
}function asmSwitchStatement(indent, env, d)
{
  var s = indent + "switch (" + signedExpr(4, env) + ") {\n";
  while (rnd(3)) {
    s += indent + "  case " + (rnd(5)-3) + ":\n";
    s += asmStatement(indent + "    ", env, d - 2);
    if (rnd(4))
      s += indent + "    break;\n";
  }
  if (rnd(2)) {
    s += indent + "  default:\n";
    s += asmStatement(indent + "    ", env, d - 2);
  }
  s += indent + "}\n";
  return s;
}function parameterTypeAnnotations(args)
{
  var s = "";
  for (var a = 0; a < args.length; ++a) {
    var arg = args[a];
    if (arg.charAt(0) == "i")
      s += "    " + arg + " = " + arg + "|0;\n";
    else
      s += "    " + arg + " = " + "+" + arg + ";\n";
  }
  return s;
}
var additive = ["+", "-"];
var intExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return intLiteralRange(-0x8000000, 0xffffffff); }},
    {w: 1,  v: function(d, e) { return intExpr(d - 3, e) + " ? " + intExpr(d - 3, e) + " : " + intExpr(d - 3, e); }},
    {w: 1,  v: function(d, e) { return "!" + intExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 1, e); }},
    {w: 10, v: function(d, e) { return intVar(e); }}, 
    {w: 1,  v: function(d, e) { return e.globalEnv.foreignFunctions.length ? asmFfiCall(d, e) + "|0" : "1"; }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 2, e) + Random.index([" < ", " <= ", " > ", " >= ", " == ", " != "]) + signedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 2, e) + Random.index([" < ", " <= ", " > ", " >= ", " == ", " != "]) + unsignedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doubleExpr(d - 2, e) + Random.index([" < ", " <= ", " > ", " >= ", " == ", " != "]) + doubleExpr(d - 2, e); }},
]));var intishExpr = autoExpr(Random.weighted([
    {w: 10, v: function(d, e) { return intExpr(d, e); }},
    {w: 1,  v: function(d, e) { return intishMemberExpr(d, e); }},
    
    {w: 10, v: function(d, e) { return intExpr(d - 1, e) + Random.index(additive) + intExpr(d - 1, e); }},
    {w: 5,  v: function(d, e) { return intExpr(d - 2, e) + Random.index(additive) + intExpr(d - 2, e) + Random.index(additive) + intExpr(d - 2, e); }},
    
    {w: 2,  v: function(d, e) { return intExpr(d - 1, e) + "*" + intLiteralRange(-0xfffff, 0xfffff); }},
    {w: 2,  v: function(d, e) { return intLiteralRange(-0xfffff, 0xfffff) + "*" + intExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "-" + intExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 2, e) + " / " + signedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 2, e) + " / " + unsignedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 2, e) + " % " + signedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 2, e) + " % " + unsignedExpr(d - 2, e); }},
]));var signedExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return intLiteralRange(-0x8000000, 0x7fffffff); }},
    {w: 1,  v: function(d, e) { return "~" + intishExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "~~" + doubleExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return intishExpr(d - 1, e) + "|0"; }}, 
    {w: 1,  v: function(d, e) { return ensureMathImport(e, "imul") + "(" + intExpr(d - 2, e) + ", " + intExpr(d - 2, e) + ")|0"; }},
    {w: 1,  v: function(d, e) { return ensureMathImport(e, "abs") + "(" + signedExpr(d - 1, e) + ")|0"; }},
    {w: 5,  v: function(d, e) { return intishExpr(d - 2, e) + Random.index([" | ", " & ", " ^ ", " << ", " >> "]) + intishExpr(d - 2, e); }},
]));var unsignedExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return intLiteralRange(0, 0xffffffff); }},
    {w: 1,  v: function(d, e) { return intishExpr(d - 2, e) + ">>>" + intishExpr(d - 2, e); }},
]));var doublishExpr = autoExpr(Random.weighted([
    {w: 10, v: function(d, e) { return doubleExpr(d, e); }},
    {w: 1,  v: function(d, e) { return doublishMemberExpr(d, e); }},
    
]));var doubleExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return doubleLiteral(); }},
    {w: 20, v: function(d, e) { return doubleVar(e); }},
    {w: 1,  v: function(d, e) { return e.globalEnv.foreignFunctions.length ? "+" + asmFfiCall(d, e) : "1.0"; }},
    {w: 1,  v: function(d, e) { return "+(1.0/0.0)"; }},
    {w: 1,  v: function(d, e) { return "+(0.0/0.0)"; }},
    {w: 1,  v: function(d, e) { return "+(-1.0/0.0)"; }},
    
    {w: 1,  v: function(d, e) { return "+" + signedExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "+" + unsignedExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "+" + doublishExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "-" + doublishExpr(d - 1, e); }},
    
    {w: 1,  v: function(d, e) { return doubleExpr(d - 2, e) + " + " + doubleExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " - " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " * " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " / " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " % " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return intExpr(d - 3, e) + " ? " + doubleExpr(d - 3, e) + " : " + doubleExpr(d - 3, e); }},
    
    {w: 1,  v: function(d, e) { return "+" + ensureMathImport(e, Random.index(["acos", "asin", "atan", "cos", "sin", "tan", "ceil", "floor", "exp", "log", "sqrt"])) + "(" + doublishExpr(d - 1, e) + ")"; }},
    {w: 1,  v: function(d, e) { return "+" + ensureMathImport(e, "abs") + "(" + doublishExpr(d - 1, e) + ")"; }},
    {w: 1,  v: function(d, e) { return "+" + ensureMathImport(e, Random.index(["atan2", "pow"])) + "(" + doublishExpr(d - 2, e) + ", " + doublishExpr(d - 2, e) + ")"; }},
    {w: 1,  v: function(d, e) { return ensureImport(e, "Infinity"); }},
    {w: 1,  v: function(d, e) { return ensureImport(e, "NaN"); }},
]));var externExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return doubleExpr(d, e); } },
    {w: 1,  v: function(d, e) { return signedExpr(d, e); } },
]));var intishMemberExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return ensureView(e, Random.index(["Int8Array",  "Uint8Array" ])) + "[" + asmIndex(d, e, 0) + "]"; }},
    {w: 1,  v: function(d, e) { return ensureView(e, Random.index(["Int16Array", "Uint16Array"])) + "[" + asmIndex(d, e, 1) + "]"; }},
    {w: 1,  v: function(d, e) { return ensureView(e, Random.index(["Int32Array", "Uint32Array"])) + "[" + asmIndex(d, e, 2) + "]"; }},
]), true);var doublishMemberExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return ensureView(e, "Float32Array") + "[" + asmIndex(d, e, 2) + "]"; }},
    {w: 1,  v: function(d, e) { return ensureView(e, "Float64Array") + "[" + asmIndex(d, e, 3) + "]"; }},
]), true);function asmIndex(d, e, logSize)
{
  if (rnd(2) || d < 2)
    return Random.index(["0", "1", "2", "4096"]);  return intishExpr(d - 2, e) + " >> " + logSize;
}function asmFfiCall(d, e)
{
  var argList = "";
  while (rnd(6)) {
    if (argList)
      argList += ", ";
    d -= 1;
    argList += externExpr(d, e);
  }  return "/*FFI*/" + Random.index(e.globalEnv.foreignFunctions) + "(" + argList + ")";
}
function ensureView(e, t)
{
  var varName = t + "View";
  if (!(varName in e.globalEnv.heapImported)) {
    e.globalEnv.heapImports += "  var " + varName + " = new stdlib." + t + "(heap);\n";
    e.globalEnv.heapImported[varName] = true;
  }
  return varName;
}function ensureMathImport(e, f)
{
  return ensureImport(e, f, "Math.");
}function ensureImport(e, f, prefix)
{
  if (!(f in e.globalEnv.stdlibImported)) {
    e.globalEnv.stdlibImports += "  var " + f + " = stdlib." + (prefix||"") + f + ";\n";
    e.globalEnv.stdlibImported[f] = true;
  }
  return f;
}
var anyAsmExpr = [intExpr, intishExpr, signedExpr, doublishExpr, doubleExpr, intishMemberExpr, doublishMemberExpr];function autoExpr(funs, avoidSubst)
{
  return function(d, e) {
    var f = d < 1 ? funs[0] :
            rnd(50) === 0 && !e.globalEnv.sanePlease ? function(_d, _e) { return makeExpr(5, ["x"]); } :
            rnd(50) === 0 && !avoidSubst ? Random.index(anyAsmExpr) :
            Random.index(funs);
    return "(" + f(d, e) + ")";
  };
}function intVar(e)
{
  var locals = e.locals;
  if (!locals.length)
    return intLiteralRange(-0x8000000, 0xffffffff);
  var local = Random.index(locals);
  if (local.charAt(0) == "i")
    return local;
  return intLiteralRange(-0x8000000, 0xffffffff);
}function doubleVar(e)
{
  var locals = e.locals;
  if (!locals.length)
    return doubleLiteral();
  var local = Random.index(locals);
  if (local.charAt(0) == "d")
    return local;
  return doubleLiteral();
}
function doubleLiteral()
{
  return Random.index(["-", ""]) + positiveDoubleLiteral();
}function positiveDoubleLiteral()
{
  if (rnd(3) === 0) {
    Random.index(["0.0", "1.0", "1.2345e60"]);
  }  
  var value = Math.pow(2, rnd(100) - 10);  
  if (rnd(3)) {
    value += 1;
  } else if (value > 1 && rnd(2)) {
    value -= 1;
  }  var str = value + "";
  if (str.indexOf(".") == -1) {
    return str + ".0";
  }
  
  return str;
}function fuzzyRange(min, max)
{
  if (rnd(10000) === 0)
    return min - 1;
  if (rnd(10000) === 0)
    return max + 1;
  if (rnd(10) === 0)
    return min;
  if (rnd(10) === 0)
    return max;  
  if (max > min + 0x100000000 && rnd(3) === 0)
    return min + 0x100000000 + rnd(max - (min + 0x100000000) + 1);
  return min + rnd(max - min + 1);
}function intLiteralRange(min, max)
{
  var val = fuzzyRange(min, max);
  var sign = val < 0 ? "-" : "";
  return sign + "0x" + Math.abs(val).toString(16);
}
const NUM_MATH_FUNCTIONS = 6;var binaryMathOps = [
  " * ", /* NODIFF " / " */, " % ",  
  " + ", " - ",
  " ** ",
  " << ", " >> ", " >>> ",
  " < ", " > ", " <= ", " >= ",
  " == ", " != ",
  " === ", " !== ",
  " & ", " | ", " ^ ", " && ", " || ",
  " , ",
];var leftUnaryMathOps = [
  " ! ", " + ", " - ", " ~ ",
];var unaryMathFunctions = [
  "abs",
  "acos",
  "acosh",
  "asin",
  "asinh",
  "atan",
  "atanh",
  "cbrt",
  "ceil",
  "cos",
  "cosh",
  "exp",
  "expm1",
  
  "fround",
  "log",
  "log2",
  "log10",
  "log1p",
  
  "round",
  "sign",
  "sin",
  "sinh",
  "sqrt",
  "tan",
  "tanh",
  "trunc",
];
var binaryMathFunctions = [
  "atan2",
  "hypot", 
  "imul",
  "max", 
  "min", 
  "pow",
];function makeMathFunction(d, b, i)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var ivars = ["x", "y"];
  if (rnd(10) == 0) {
    
    ivars = ivars.concat(b);
  }
  return "(function(x, y) { " + directivePrologue() + "return " + makeMathExpr(d, ivars, i) + "; })";
}function makeMathExpr(d, b, i)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  if (d < rnd(5)) {
    if (rnd(4)) {
      return Random.index(b);
    }
    return Random.index(numericVals);
  }  if (rnd(500) == 0 && d > 0)
    return makeExpr(d - 1, b);  function r() { return makeMathExpr(d - 1, b, i); }  
  
  var commonCoercion = rnd(10);
  function mc(expr) {
    switch(rnd(3) ? commonCoercion : rnd(10)) {
      case 0: return "(" + " + " + expr + ")";     
      case 1: return "Math.fround(" + expr + ")";  
      case 2: return "(" + expr + " | 0)";         
      case 3: return "(" + expr + " >>> 0)";       
      default: return expr;
    }
  }  if (i > 0 && rnd(10) == 0) {
    
    return mc("mathy" + rnd(i) + "(" + mc(r()) + ", " + mc(r()) + ")");
  }  if (rnd(20) == 0) {
    return mc("(" + mc(r()) + " ? " + mc(r()) + " : " + mc(r()) + ")");
  }  switch(rnd(4)) {
    case 0:  return mc("(" + mc(r()) + Random.index(binaryMathOps) + mc(r()) + ")");
    case 1:  return mc("(" + Random.index(leftUnaryMathOps) + mc(r()) + ")");
    case 2:  return mc("Math." + Random.index(unaryMathFunctions) + "(" + mc(r()) + ")");
    default: return mc("Math." + Random.index(binaryMathFunctions) + "(" + mc(r()) + ", " + mc(r()) + ")");
  }
}/****************************
 * GRAMMAR-BASED GENERATION *
 ****************************/
function makeScript(d, ignoredB)
{
  return directivePrologue() + makeScriptBody(d, ignoredB);
}function makeScriptBody(d, ignoredB)
{
  if (rnd(3) == 0) {
    return makeMathyFunAndTest(d, ["x"]);
  }
  return makeStatement(d, ["x"]);
}function makeScriptForEval(d, b)
{
  switch (rnd(4)) {
    case 0:  return makeExpr(d - 1, b);
    case 1:  return makeStatement(d - 1, b);
    case 2:  return makeUseRegressionTest(d, b);
    default: return makeScript(d - 3, b);
  }
}function makeStatement(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(2))
    return makeBuilderStatement(d, b);  if (d < 6 && rnd(3) === 0)
    return makePrintStatement(d, b);  if (d < rnd(8)) 
    return makeLittleStatement(d, b);  d = rnd(d);   return (Random.index(statementMakers))(d, b);
}var varBinder = ["var ", "let ", "const ", ""];
var varBinderFor = ["var ", "let ", ""]; 
function forLoopHead(d, b, v, reps)
{
  var sInit = Random.index(varBinderFor) + v + " = 0";
  var sCond = v + " < " + reps;
  var sNext = "++" + v;  while (rnd(10) === 0)
    sInit += ", " + makeLetHeadItem(d - 2, b);
  while (rnd(10) === 0)
    sInit += ", " + makeExpr(d - 2, b);   while (rnd(20) === 0)
    sCond = sCond + " && (" + makeExpr(d - 2, b) + ")";
  while (rnd(20) === 0)
    sCond = "(" + makeExpr(d - 2, b) + ") && " + sCond;  while (rnd(20) === 0)
    sNext = sNext + ", " + makeExpr(d - 2, b);
  while (rnd(20) === 0)
    sNext = makeExpr(d - 2, b) + ", " + sNext;  return "for (" + sInit + "; " + sCond + "; " + sNext + ")";
}function makeOpaqueIdiomaticLoop(d, b)
{
  var reps = loopCount();
  var vHidden = uniqueVarName();
  return "/*oLoop*/" + forLoopHead(d, b, vHidden, reps) + " { " +
      makeStatement(d - 2, b) +
      " } ";
}function makeTransparentIdiomaticLoop(d, b)
{
  var reps = loopCount();
  var vHidden = uniqueVarName();
  var vVisible = makeNewId(d, b);
  return "/*vLoop*/" + forLoopHead(d, b, vHidden, reps) +
    " { " +
      Random.index(varBinder) + vVisible + " = " + vHidden + "; " +
      makeStatement(d - 2, b.concat([vVisible])) +
    " } ";
}function makeBranchUnstableLoop(d, b)
{
  var reps = loopCount();
  var v = uniqueVarName();
  var mod = loopModulo();
  var target = rnd(mod);
  return "/*bLoop*/" + forLoopHead(d, b, v, reps) + " { " +
    "if (" + v + " % " + mod + " == " + target + ") { " + makeStatement(d - 2, b) + " } " +
    "else { " + makeStatement(d - 2, b) + " } " +
    " } ";
}function makeTypeUnstableLoop(d, b) {
  var a = makeMixedTypeArray(d, b);
  var v = makeNewId(d, b);
  var bv = b.concat([v]);
  return "/*tLoop*/for (let " + v + " of " + a + ") { " + makeStatement(d - 2, bv) + " }";
}
function makeFunOnCallChain(d, b) {
  var s = "arguments.callee";
  while (rnd(2))
    s += ".caller";
  return s;
}
var statementMakers = Random.weighted([  
  { w: 15, v: function(d, b) { return cat([makeStatement(d - 1, b),       makeStatement(d - 1, b)      ]); } },
  { w: 15, v: function(d, b) { return cat([makeStatement(d - 1, b), "\n", makeStatement(d - 1, b), "\n"]); } },  
  { w: 1, v: function(d, b) { return cat([stripSemicolon(makeStatement(d, b)), "\n", makeStatement(d, b)]); } },
  { w: 1, v: function(d, b) { return cat([stripSemicolon(makeStatement(d, b)), "\n"                   ]); } },
  { w: 1, v: function(d, b) { return stripSemicolon(makeStatement(d, b)); } },   
  { w: 4, v: function(d, b) { var v = makeNewId(d, b); return cat([Random.index(varBinder), v, " = ", makeExpr(d, b), ";", makeStatement(d - 1, b.concat([v]))]); } },
  { w: 4, v: function(d, b) { var v = makeNewId(d, b); return cat([makeStatement(d - 1, b.concat([v])), Random.index(varBinder), v, " = ", makeExpr(d, b), ";"]); } },  
  { w: 10, v: function(d, b) { return cat([Random.index(varBinder), makeLetHead(d, b), ";", makeStatement(d - 1, b)]); } },  
  { w: 2, v: function(d, b) { return cat(["{", makeStatement(d, b), " }"]); } },
  { w: 2, v: function(d, b) { return cat(["{", makeStatement(d - 1, b), makeStatement(d - 1, b), " }"]); } },  
  { w: 2, v: function(d, b) {                          return cat([maybeLabel(), "with", "(", makeExpr(d, b), ")",                    makeStatementOrBlock(d, b)]);             } },
  { w: 2, v: function(d, b) { var v = makeNewId(d, b); return cat([maybeLabel(), "with", "(", "{", v, ": ", makeExpr(d, b), "}", ")", makeStatementOrBlock(d, b.concat([v]))]); } },  
  
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", makeExpr(d, b), "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                                                    "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v, " = ", makeExpr(d, b),                             "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeDestructuringLValue(d, b), " = ", makeExpr(d, b), "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b)]); } },  
  { w: 6, v: makeTransparentIdiomaticLoop },
  { w: 6, v: makeOpaqueIdiomaticLoop },
  { w: 6, v: makeBranchUnstableLoop },
  { w: 8, v: makeTypeUnstableLoop },  
  
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeForInLHS(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                  " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeForInLHS(d, b), " in ", "(", "(", makeFunction(d, b), ")", "(", makeExpr(d, b), ")", ")", ")", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                  " in ", "(", "(", makeFunction(d, b), ")", "(", makeExpr(d, b), ")", ")", ")", makeStatementOrBlock(d, b.concat([v]))]); } },
  
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), " for ", " each", "(", Random.index(varBinderFor), makeLValue(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), " for ", " each", "(", Random.index(varBinderFor), v,                " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), " for ", "(", Random.index(varBinderFor), makeLValue(d, b), " of ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), " for ", "(", Random.index(varBinderFor), v,                " of ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },  
  
  
  
  
  
  { w: 1, v: function(d, b) {                                               return cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeId(d, b),         " = ", makeExpr(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b);                      return cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                    " = ", makeExpr(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b), w = makeNewId(d, b); return cat([maybeLabel(), "for", "(", Random.index(varBinderFor), "[", v, ", ", w, "]", " = ", makeExpr(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v, w]))]); } },  
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "while((", makeExpr(d, b), ") && 0)" /*don't split this, it's needed to avoid marking as infloop*/, makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { return "/*infloop*/" + cat([maybeLabel(), "while", "(", makeExpr(d, b), ")", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "do ", makeStatementOrBlock(d, b), " while((", makeExpr(d, b), ") && 0)" /*don't split this, it's needed to avoid marking as infloop*/, ";"]); } },
  { w: 1, v: function(d, b) { return "/*infloop*/" + cat([maybeLabel(), "do ", makeStatementOrBlock(d, b), " while", "(", makeExpr(d, b), ");"]); } },  
  { w: 3, v: function(d, b) { return cat([maybeLabel(), "switch", "(", makeExpr(d, b), ")", " { ", makeSwitchBody(d, b), " }"]); } },  
  { w: 2, v: function(d, b) { var v = makeNewId(d, b); return cat(["let ", "(", v, ")", " { ", makeStatement(d, b.concat([v])), " }"]); } },  
  { w: 2, v: function(d, b) { return cat(["let ", "(", makeLetHead(d, b), ")", " { ", makeStatement(d, b), " }"]); } },  
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", makeStatementOrBlock(d - 1, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", makeStatementOrBlock(d - 1, b)]); } },  
  
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", "{", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", makeStatementOrBlock(d - 1, b), "}"]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", "{", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b), "}", " else ", makeStatementOrBlock(d - 1, b)]); } },  
  { w: 5, v: function(d, b) { return cat([makeExpr(d, b), ";"]); } },
  { w: 5, v: function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); } },  
  { w: 6, v: function(d, b) { return makeExceptionyStatement(d - 1, b) + makeExceptionyStatement(d - 1, b); } },
  { w: 7, v: function(d, b) { return makeExceptionyStatement(d, b); } },  
  { w: 1, v: function(d, b) { return cat(["L", ": ", makeStatementOrBlock(d, b)]); } },  
  { w: 10, v: function(d, b) { return cat([makeStatement(d-2, b), "function ", makeId(d, b), "(", makeFormalArgList(d, b), ")", makeFunctionBody(d - 1, b), makeStatement(d-2, b)]); } },  
  { w: 8, v: makeNamedFunctionAndUse },  
  
  
  { w: 1, v: function(d, b) { if (rnd(200)==0) return "/*DUPTRY" + rnd(10000) + "*/" + makeStatement(d - 1, b); return ";"; } },  { w: 1, v: function(d, b) { return makeShapeyConstructorLoop(d, b); } },  
  { w: 1, v: function(d, b) { var x = makeId(d, b); return x + " = linkedList(" + x + ", " + (rnd(100) * rnd(100)) + ");";  } },  
  { w: 1, v: function(d, b) { return directivePrologue() + makeStatement(d - 1, b); } },  
  { w: 3, v: function(d, b) { return makeTestingFunctionCall(d, b); } },
  { w: 3, v: function(d, b) { return makeTestingFunctionCall(d - 1, b) + " " + makeStatement(d - 1, b); } },  
  { w: 8, v: makeTypedArrayStatements },  
  { w: 8, v: makePrintStatement },  { w: 20, v: makeRegexUseBlock },  { w: 1, v: makeRegisterStompBody },  { w: 20, v: makeUseRegressionTest },  
  
  
]);if (typeof oomTest == "function" && engine != ENGINE_SPIDERMONKEY_MOZILLA45) {
  statementMakers = statementMakers.concat([
    function(d, b) { return "oomTest(" + makeFunction(d, b-1) + ")"; },
  ]);
}
function makeUseRegressionTest(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (typeof regressionTestList != "object") {
    return "/* no regression tests found */";
  }  var maintest = regressionTestsRoot + Random.index(regressionTestList);
  var files = regressionTestDependencies(maintest);  var s = "";  if (rnd(5) == 0) {
    
    
    s += "assertEq = function(x, y) { if (x != y) { print(0); } }; ";
  }  for (var i = 0; i < files.length; ++i) {
    var file = files[i];    if (regressionTestIsEvil(read(file))) {
      continue;
    }    switch (rnd(2)) {
      case 0:
        
        s += "/* regression-test-inline */ " + inlineRegressionTest(file);
        break;
      default:
        
        s += "/* regression-test-load */ " + "load(" + simpleSource(file) + ");";
        break;
      
    }
  }
  return s;
}function regressionTestIsEvil(contents)
{
  if (contents.indexOf("SIMD") != -1) {
    
    return true;
  }
  if (contents.indexOf("print = ") != -1) {
    
    return true;
  }
  return false;
}function inlineRegressionTest(filename)
{
    const s = "/* " + filename + " */ " + read(filename) + "\n";  const noDiffTestingFunctions = [
    
    "gcparam",
    "startgc",
    "setJitCompilerOption",
    "disableSingleStepProfiling",
    "enableSingleStepProfiling",
    
    "isAsmJSCompilationAvailable",
    "isSimdAvailable", 
    "hasChild",
    "PerfMeasurement",
  ];  for (var f of noDiffTestingFunctions) {
    if (s.indexOf(f) != -1) {
      return "/*NODIFF*/ " + s;
    }
  }  return s;
}
function regressionTestDependencies(maintest)
{
  var files = [];  if (rnd(3)) {
    
    for (var i = regressionTestsRoot.length; i < maintest.length; ++i) {
      if (maintest.charAt(i) == "/" || maintest.charAt(i) == "\\") {
        var shelljs = maintest.substr(0, i + 1) + "shell.js";
        if (regressionTestList.indexOf(shelljs) != -1) {
          files.push(shelljs);
        }
      }
    }    
    if (maintest.indexOf("jit-test") != -1) {
      files.push(libdir + "prologue.js");
    }
  }  files.push(maintest);
  return files;
}
function linkedList(x, n)
{
  for (var i = 0; i < n; ++i)
    x = {a: x};
  return x;
}function makeNamedFunctionAndUse(d, b) {
  
  var funcName = uniqueVarName();
  var formalArgList = makeFormalArgList(d, b);
  var bv = formalArgList.length == 1 ? b.concat(formalArgList) : b;
  var declStatement = cat(["/*hhh*/function ", funcName, "(", formalArgList, ")", "{", makeStatement(d - 1, bv), "}"]);
  var useStatement;
  if (rnd(2)) {
    
    useStatement = cat([funcName, "(", makeActualArgList(d, b), ")", ";"]);
  } else {
    
    useStatement = "/*iii*/" + makeStatement(d - 1, b.concat([funcName]));
  }
  if (rnd(2)) {
    return declStatement + useStatement;
  } else {
    return useStatement + declStatement;
  }
}function makePrintStatement(d, b)
{
  if (rnd(2) && b.length)
    return "print(" + Random.index(b) + ");";
  else
    return "print(" + makeExpr(d, b) + ");";
}
function maybeLabel()
{
  if (rnd(4) === 1)
    return cat([Random.index(["L", "M"]), ":"]);
  else
    return "";
}
function uniqueVarName()
{
  
  var i, s = "";
  for (i = 0; i < 6; ++i)
    s += String.fromCharCode(97 + rnd(26)); 
  return s;
}function makeSwitchBody(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var haveSomething = false;
  var haveDefault = false;
  var output = "";  do {    if (!haveSomething || rnd(2)) {
            if (!haveDefault && rnd(2)) {
        output += "default: ";
        haveDefault = true;
      }
      else {
        
        
        output += "case " + (rnd(2) ? rnd(10) : makeExpr(d, b)) + ": ";
      }      haveSomething = true;
    }    
    if (rnd(2))
      output += makeStatement(d, b);    
    if (rnd(2))
      output += "break; ";    if (rnd(2))
      --d;  } while (d && rnd(5));  return output;
}function makeLittleStatement(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if (rnd(4) === 1)
    return makeStatement(d, b);  return (Random.index(littleStatementMakers))(d, b);
}var littleStatementMakers =
[
  
  function(d, b) { return cat([";"]); }, 
  function(d, b) { return cat(["{", "}"]); }, 
  function(d, b) { return cat([""]); },  
  function(d, b) { return cat(["throw ", makeExpr(d, b), ";"]); },  
  function(d, b) { return cat([Random.index(["continue", "break"]), " ", Random.index(["L", "M", "", ""]), ";"]); },  
  
  function(d, b) { return makeFunction(d, b); },  
  function(d, b) { return cat(["return ", makeExpr(d, b), ";"]); },
  function(d, b) { return "return;"; }, 
  function(d, b) { return cat(["yield ", makeExpr(d, b), ";"]); }, 
  function(d, b) { return "yield;"; },  
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
];
function makeStatementOrBlock(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return (Random.index(statementBlockMakers))(d - 1, b);
}var statementBlockMakers = [
  function(d, b) { return makeStatement(d, b); },
  function(d, b) { return makeStatement(d, b); },
  function(d, b) { return cat(["{", makeStatement(d, b), " }"]); },
  function(d, b) { return cat(["{", makeStatement(d - 1, b), makeStatement(d - 1, b), " }"]); },
];
function makeExceptionyStatement(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;
  if (d < 1)
    return makeLittleStatement(d, b);  return (Random.index(exceptionyStatementMakers))(d, b);
}var exceptionProperties = ["constructor", "message", "name", "fileName", "lineNumber", "stack"];var exceptionyStatementMakers = [
  function(d, b) { return makeTryBlock(d, b); },  function(d, b) { return makeStatement(d, b); },
  function(d, b) { return makeLittleStatement(d, b); },  function(d, b) { return "return;"; }, 
  function(d, b) { return cat(["return ", makeExpr(d, b), ";"]); },
  function(d, b) { return cat(["yield ", makeExpr(d, b), ";"]); },
  function(d, b) { return cat(["throw ", makeId(d, b), ";"]); },
  function(d, b) { return "throw StopIteration;"; },
  function(d, b) { return "this.zzz.zzz;"; }, 
  function(d, b) { return b[b.length - 1] + "." + Random.index(exceptionProperties) + ";"; },
  function(d, b) { return makeId(d, b) + "." + Random.index(exceptionProperties) + ";"; },
  function(d, b) { return cat([makeId(d, b), " = ", makeId(d, b), ";"]); },
  function(d, b) { return cat([makeLValue(d, b), " = ", makeId(d, b), ";"]); },  
  
  function(d, b) { var v = makeNewId(d, b); return "for(let " + v + " in []);"; },
  function(d, b) { var v = makeNewId(d, b); return "for(let " + v + " in " + makeIterable(d, b) + ") " + makeExceptionyStatement(d, b.concat([v])); },
  function(d, b) { var v = makeNewId(d, b); return "for(let " + v + " of " + makeIterable(d, b) + ") " + makeExceptionyStatement(d, b.concat([v])); },  
  
  function(d, b) { return "with({}) "   + makeExceptionyStatement(d, b);         },
  function(d, b) { return "with({}) { " + makeExceptionyStatement(d, b) + " } "; },
  function(d, b) { var v = makeNewId(d, b); return "let(" + v + ") { " + makeExceptionyStatement(d, b.concat([v])) + "}"; },
  function(d, b) { var v = makeNewId(d, b); return "let(" + v + ") ((function(){" + makeExceptionyStatement(d, b.concat([v])) + "})());"; },
  function(d, b) { return "let(" + makeLetHead(d, b) + ") { " + makeExceptionyStatement(d, b) + "}"; },
  function(d, b) { return "let(" + makeLetHead(d, b) + ") ((function(){" + makeExceptionyStatement(d, b) + "})());"; },  
/*
  
  function(d, b) { return "(function () { try { yield " + makeExpr(d, b) + " } finally { " + makeStatement(d, b) + " } })().next()"; },  function(d, b) { return "(function () { try { yield " + makeExpr(d, b) + " } finally { " + makeStatement(d, b) + " } })()"; },
  function(d, b) { return "(function () { try { yield " + makeExpr(d, b) + " } finally { " + makeStatement(d, b) + " } })"; },
  function(d, b) {
    return "function gen() { try { yield 1; } finally { " + makeStatement(d, b) + " } } var i = gen(); i.next(); i = null;";
  }*/
];function makeTryBlock(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  
  
    d = d - rnd(3);
  var s = cat(["try", " { ", makeExceptionyStatement(d, b), " } "]);  var numCatches = 0;  while(rnd(3) === 0) {
    
    ++numCatches;
    var catchId = makeId(d, b);
    var catchBlock = makeExceptionyStatement(d, b.concat([catchId]));
    if (rnd(2))
      s += cat(["catch", "(", catchId, " if ",                 makeExpr(d, b),                    ")", " { ", catchBlock, " } "]);
    else
      s += cat(["catch", "(", catchId, " if ", "(function(){", makeExceptionyStatement(d, b), "})())", " { ", catchBlock, " } "]);
  }  if (rnd(2)) {
    
    ++numCatches;
    var catchId = makeId(d, b);
    var catchBlock = makeExceptionyStatement(d, b.concat([catchId]));
    s +=   cat(["catch", "(", catchId,                                                          ")", " { ", catchBlock, " } "]);
  }  if (numCatches == 0 || rnd(2) === 1) {
    
    s += cat(["finally", " { ", makeExceptionyStatement(d, b), " } "]);
  }  return s;
}
function makeExpr(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d <= 0 || (rnd(7) === 1))
    return makeTerm(d - 1, b);  if (rnd(6) === 1 && b.length)
    return Random.index(b);  if (rnd(10) === 1)
    return makeImmediateRecursiveCall(d, b);  d = rnd(d);   var expr = (Random.index(exprMakers))(d, b);  if (rnd(4) === 1)
    return "(" + expr + ")";
  else
    return expr;
}var binaryOps = [
  
  " * ", " / ", " % ", " + ", " - ", " << ", " >> ", " >>> ", " < ", " > ", " <= ", " >= ", " instanceof ", " in ", " == ", " != ", " === ", " !== ",
  " & ", " | ", " ^ ", " && ", " || ", " = ", " *= ", " /= ", " %= ", " += ", " -= ", " <<= ", " >>= ", " >>>= ", " &= ", " ^= ", " |= ", " , ", " ** ", " **= "
];var leftUnaryOps = [
  "!", "+", "-", "~",
  "void ", "typeof ", "delete ",
  "new ", 
  "yield " 
];var incDecOps = [
  "++", "--",
];
var specialProperties = [
  "__iterator__", "__count__",
  "__parent__", "__proto__", "constructor", "prototype",
  "wrappedJSObject",
  "arguments", "caller", "callee",
  "toString", "toSource", "valueOf",
  "call", "apply", 
  "length",
  "0", "1",
];
/*
function addPropertyName(p)
{
  p = "" + p;
  if (
      p != "floor" &&
      p != "random" &&
      p != "parent" && 
      true) {
    print("Adding: " + p);
    allPropertyNames.push(p);
  }
}
*/var exprMakers =
[
  
  function(d, b) { return cat([makeLValue(d, b), Random.index(incDecOps)]); },
  function(d, b) { return cat([Random.index(incDecOps), makeLValue(d, b)]); },  
  function(d, b) { return cat([Random.index(leftUnaryOps), makeExpr(d, b)]); },  
  function(d, b) { var id = makeId(d, b); return cat(["/*UUV1*/", "(", id, ".", Random.index(allMethodNames), " = ", makeFunction(d, b), ")"]); },
  function(d, b) { var id = makeId(d, b); return cat(["/*UUV2*/", "(", id, ".", Random.index(allMethodNames), " = ", id, ".", Random.index(allMethodNames), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", Random.index(allMethodNames), "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "valueOf", "(", uneval("number"), ")"]); },  
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeId(d, b),   Random.index(binaryOps), makeId(d, b)]); },
  function(d, b) { return cat([makeId(d, b),   Random.index(binaryOps), makeId(d, b)]); },
  function(d, b) { return cat([makeId(d, b),   Random.index(binaryOps), makeId(d, b)]); },  
  function(d, b) { return cat([makeExpr(d, b), " ? ", makeExpr(d, b), " : ", makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), " ? ", makeExpr(d, b), " : ", makeExpr(d, b)]); },  
  function(d, b) { return cat(["yield ", makeExpr(d, b)]); },
  function(d, b) { return cat(["(", "yield ", makeExpr(d, b), ")"]); },  
  
  
  
  function(d, b) { return cat([makeArrayLiteral(d, b), ".", Random.index(["map", "filter", "some", "sort"]) ]); },
  function(d, b) { return cat([makeArrayLiteral(d, b), ".", Random.index(["map", "filter", "some", "sort"]), "(", makeFunction(d, b), ", ", makeExpr(d, b), ")"]); },
  function(d, b) { return cat([makeArrayLiteral(d, b), ".", Random.index(["map", "filter", "some", "sort"]), "(", makeFunction(d, b), ")"]); },  
  function(d, b) { return cat(["'fafafa'", ".", "replace", "(", "/", "a", "/", "g", ", ", makeFunction(d, b), ")"]); },  
  function(d, b) { return cat(["[", makeExpr(d, b), "]"]); },
  function(d, b) { return cat(["(", "{", makeId(d, b), ": ", makeExpr(d, b), "}", ")"]); },  
  function(d, b) { return makeFunction(d, b); },
  function(d, b) { return makeFunction(d, b) + ".prototype"; },
  function(d, b) { return cat(["(", makeFunction(d, b), ")", "(", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return cat([     makeExpr(d, b),          "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat(["(", makeExpr(d, b),     ")", "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat([     makeFunction(d, b),      "(", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return cat(["(", makeFunction(d, b), ")", ".", "call", "(", makeExpr(d, b), ", ", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return cat(["new ",      makeExpr(d, b),          "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat(["new ", "(", makeExpr(d, b), ")",     "(", makeActualArgList(d, b), ")"]); },  function(d, b) { return cat(["new ",      makeFunction(d, b),      "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat(["new ", "(", makeFunction(d, b), ")", "(", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return stripSemicolon(makeLittleStatement(d, b)); },
  function(d, b) { return ""; },  
  function(d, b) { var v = makeNewId(d, b); return cat(["let ", "(", v,                            ") ", makeExpr(d - 1, b.concat([v]))]); },
  function(d, b) { var v = makeNewId(d, b); return cat(["let ", "(", v, " = ", makeExpr(d - 1, b), ") ", makeExpr(d - 1, b.concat([v]))]); },
  function(d, b) {                          return cat(["let ", "(", makeLetHead(d, b),            ") ", makeExpr(d, b)]); },  
  function(d, b) { return cat([" /* Comment */", makeExpr(d, b)]); },
  function(d, b) { return cat(["\n", makeExpr(d, b)]); }, 
  function(d, b) { return cat([makeExpr(d, b), "\n"]); },  
  function(d, b) { return cat([makeLValue(d, b)]); },  
  function(d, b) { return cat([     makeLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat([     makeLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat(["(", makeLValue(d, b),      " = ", makeExpr(d, b), ")"]); },
  function(d, b) { return cat(["(", makeLValue(d, b), ")", " = ", makeExpr(d, b)     ]); },  
  function(d, b) { return cat([     makeDestructuringLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat([     makeDestructuringLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat(["(", makeDestructuringLValue(d, b),      " = ", makeExpr(d, b), ")"]); },
  function(d, b) { return cat(["(", makeDestructuringLValue(d, b), ")", " = ", makeExpr(d, b)     ]); },  
  function(d, b) { return cat([makeDestructuringLValue(d, b), " = ", makeDestructuringLValue(d, b)]); },  
  function(d, b) { return cat([makeLValue(d, b), Random.index(["|=", "%=", "+=", "-="]), makeExpr(d, b)]); },  
  function(d, b) { return cat([makeExpr(d, b), ".", "watch", "(", makePropertyName(d, b), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "unwatch", "(", makePropertyName(d, b), ")"]); },  
  function(d, b) { return cat(["Object.defineProperty", "(", makeId(d, b), ", ", makePropertyName(d, b), ", ", makePropertyDescriptor(d, b), ")"]); },  
  function(d, b) { return cat([makeExpr(d, b), ".", "__defineGetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "__defineSetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat(["this", ".", "__defineGetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat(["this", ".", "__defineSetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },  
  function(d, b) { return cat(["(", "{", makeObjLiteralPart(d, b), " }", ")"]); },
  function(d, b) { return cat(["(", "{", makeObjLiteralPart(d, b), ", ", makeObjLiteralPart(d, b), " }", ")"]); },  
  function(d, b) { return "(p={}, (p.z = " + makeExpr(d, b) + ")())"; },  
  
  
  function(d, b) { return cat([makeExpr(d, b), ".", "throw", "(", makeExpr(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "yoyo",   "(", makeExpr(d, b), ")"]); },  
  
  function(d, b) { return makeExpr(d, b) + ".eval(" + uneval(makeScriptForEval(d, b)) + ")"; },
  function(d, b) { return "eval(" + uneval(makeScriptForEval(d, b)) + ")"; },
  function(d, b) { return "eval(" + uneval(makeScriptForEval(d, b)) + ", " + makeExpr(d, b) + ")"; },  
  function(d, b) { return "(uneval(" + makeExpr(d, b) + "))"; },  
  function(d, b) { return "new " + Random.index(constructors) + "(" + makeActualArgList(d, b) + ")"; },
  function(d, b) { return          Random.index(constructors) + "(" + makeActualArgList(d, b) + ")"; },  
  function (d, b) { return "Math." + Random.index(unaryMathFunctions) + "(" + makeExpr(d, b)   + ")"; },
  function (d, b) { return "Math." + Random.index(unaryMathFunctions) + "(" + makeNumber(d, b) + ")"; },  
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeExpr(d, b)   + ", " + makeExpr(d, b)   + ")"; },
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeExpr(d, b)   + ", " + makeNumber(d, b) + ")"; },
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeNumber(d, b) + ", " + makeExpr(d, b)   + ")"; },
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeNumber(d, b) + ", " + makeNumber(d, b) + ")"; },  
  function(d, b) { return makeId(d, b) + " = " + "Proxy.create(" + makeProxyHandler(d, b) + ", " + makeExpr(d, b) + ")"; },
  function(d, b) { return makeId(d, b) + " = " + "Proxy.createFunction(" + makeProxyHandler(d, b) + ", " + makeFunction(d, b) + ")"; },
  function(d, b) { return makeId(d, b) + " = " + "Proxy.createFunction(" + makeProxyHandler(d, b) + ", " + makeFunction(d, b) + ", " + makeFunction(d, b) + ")"; },  function(d, b) { return cat(["delete", " ", makeId(d, b), ".", makeId(d, b)]); },  
  function(d, b) { return "(void options('strict_mode'))"; },  
  function(d, b) { return "(void options('strict'))"; },  
  function(d, b) { return "(void version(" + Random.index([170, 180, 185]) + "))"; },  
  
  
  function(d, b) { return "(void shapeOf(" + makeExpr(d, b) + "))"; },
  function(d, b) { return "intern(" + makeExpr(d, b) + ")"; },
  function(d, b) { return "allocationMarker()"; },
  function(d, b) { return "timeout(1800)"; }, 
  function(d, b) { return "(makeFinalizeObserver('tenured'))"; },
  function(d, b) { return "(makeFinalizeObserver('nursery'))"; },  makeRegexUseExpr,
  makeShapeyValue,
  makeIterable,
  function(d, b) { return makeMathExpr(d + rnd(3), b); },
];
var fuzzTestingFunctions = fuzzTestingFunctionsCtor(!jsshell, fuzzTestingFunctionArg, fuzzTestingFunctionArg);
function fuzzTestingFunctionArg(d, b) { return "this"; }function makeTestingFunctionCall(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var callStatement = Random.index(fuzzTestingFunctions.testingFunctions)(d, b);  
  
  var callBlock = "{ void 0; " + callStatement + " }";  if (jsshell && rnd(5) === 0) {
    
    
    
    
    
    
    
    
    
    
    
    
    var cond = (rnd(2) ? "!" : "") + "isAsmJSCompilationAvailable()";
    return "{ if (" + cond + ") " + callBlock + " void 0; }";
  }  return callBlock;
}
if (typeof evalcx == "function") {
  exprMakers = exprMakers.concat([
    function(d, b) { return makeGlobal(d, b); },
    function(d, b) { return "evalcx(" + uneval(makeScriptForEval(d, b)) + ", " + makeExpr(d, b) + ")"; },
    function(d, b) { return "evalcx(" + uneval(makeScriptForEval(d, b)) + ", " + makeGlobal(d, b) + ")"; },
  ]);
}
if (typeof XPCNativeWrapper == "function") {
  exprMakers = exprMakers.extend([
    function(d, b) { return "new XPCNativeWrapper(" + makeExpr(d, b) + ")"; },
    function(d, b) { return "new XPCSafeJSObjectWrapper(" + makeExpr(d, b) + ")"; },
  ]);
}function makeNewGlobalArg(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  var propStrs = [];
  if (rnd(2))
    propStrs.push("sameZoneAs: " + makeExpr(d - 1, b));
  if (rnd(2))
    propStrs.push("cloneSingletons: " + makeBoolean(d - 1, b));
  if (rnd(2))
    propStrs.push("disableLazyParsing: " + makeBoolean(d - 1, b));
  return "{ " + propStrs.join(", ") + " }";
}function makeGlobal(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(10))
    return "this";  var gs;
  switch(rnd(4)) {
    case 0:  gs = "evalcx('')"; break;
    case 1:  gs = "evalcx('lazy')"; break;
    default: gs = "newGlobal(" + makeNewGlobalArg(d - 1, b) + ")"; break;
  }  if (rnd(2))
    gs = "fillShellSandbox(" + gs + ")";  return gs;
}if (xpcshell) {
  exprMakers = exprMakers.concat([
    function(d, b) { var n = rnd(4); return "newGeckoSandbox(" + n + ")"; },
    function(d, b) { var n = rnd(4); return "s" + n + " = newGeckoSandbox(" + n + ")"; },
    
    function(d, b) { var n = rnd(4); return "evalInSandbox(" + uneval(makeStatement(d, b)) + ", newGeckoSandbox(" + n + "))"; },
    function(d, b) { var n = rnd(4); return "evalInSandbox(" + uneval(makeStatement(d, b)) + ", s" + n + ")"; },
    function(d, b) { return "evalInSandbox(" + uneval(makeStatement(d, b)) + ", " + makeExpr(d, b) + ")"; },
    function(d, b) { return "(Components.classes ? quit() : gc()); }"; },
  ]);
}
function makeShapeyConstructor(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);
  var argName = uniqueVarName();
  var t = rnd(4) ? "this" : argName;
  var funText = "function shapeyConstructor(" + argName + "){" + directivePrologue();
  var bp = b.concat([argName]);  var nPropNames = rnd(6) + 1;
  var propNames = [];
  for (var i = 0; i < nPropNames; ++i) {
    propNames[i] = makePropertyName(d, b);
  }  var nStatements = rnd(11);
  for (var i = 0; i < nStatements; ++i) {
    var propName = Random.index(propNames);
    var tprop = t + "[" + propName + "]";
    if (rnd(5) === 0) {
      funText += "if (" + (rnd(2) ? argName : makeExpr(d, bp)) + ") ";
    }
    switch(rnd(8)) {
      case 0:  funText += "delete " + tprop + ";"; break;
      case 1:  funText += "Object.defineProperty(" + t + ", " + (rnd(2) ? propName : makePropertyName(d, b)) + ", " + makePropertyDescriptor(d, bp) + ");"; break;
      case 2:  funText += "{ " + makeStatement(d, bp) + " } "; break;
      case 3:  funText += tprop + " = " + makeExpr(d, bp)        + ";"; break;
      case 4:  funText += tprop + " = " + makeFunction(d, bp)    + ";"; break;
      case 5:  funText += "for (var ytq" + uniqueVarName() + " in " + t + ") { }"; break;
      case 6:  funText += "Object." + Random.index(["preventExtensions","seal","freeze"]) + "(" + t + ");"; break;
      default: funText += tprop + " = " + makeShapeyValue(d, bp) + ";"; break;
    }
  }
  funText += "return " + t + "; }";
  return funText;
}
var propertyNameMakers = Random.weighted([
  { w: 1,  v: function(d, b) { return makeExpr(d - 1, b); } },
  { w: 1,  v: function(d, b) { return maybeNeg() + rnd(20); } },
  { w: 1,  v: function(d, b) { return '"' + maybeNeg() + rnd(20) + '"'; } },
  { w: 1,  v: function(d, b) { return "new String(" + '"' + maybeNeg() + rnd(20) + '"' + ")"; } },
  { w: 5,  v: function(d, b) { return simpleSource(Random.index(specialProperties)); } },
  { w: 1,  v: function(d, b) { return simpleSource(makeId(d - 1, b)); } },
  { w: 5,  v: function(d, b) { return simpleSource(Random.index(allMethodNames)); } },
]);function maybeNeg() { return rnd(5) ? "" : "-"; }function makePropertyName(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return (Random.index(propertyNameMakers))(d, b);
}function makeShapeyConstructorLoop(d, b)
{
  var a = makeIterable(d, b);
  var v = makeNewId(d, b);
  var v2 = uniqueVarName(d, b);
  var bvv = b.concat([v, v2]);
  return makeShapeyConstructor(d - 1, b) +
    "/*tLoopC*/for (let " + v + " of " + a + ") { " +
     "try{" +
       "let " + v2 + " = " + Random.index(["new ", ""]) + "shapeyConstructor(" + v + "); print('EETT'); " +
       
       makeStatement(d - 2, bvv) +
     "}catch(e){print('TTEE ' + e); }" +
  " }";
}
function makePropertyDescriptor(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var s = "({";  switch(rnd(3)) {
  case 0:
    
    if (rnd(2)) s += "value: " + makeExpr(d, b) + ", ";
    if (rnd(2)) s += "writable: " + makeBoolean(d, b) + ", ";
    break;
  case 1:
    
    if (rnd(2)) s += "get: " + makeFunction(d, b) + ", ";
    if (rnd(2)) s += "set: " + makeFunction(d, b) + ", ";
    break;
  default:
  }  if (rnd(2)) s += "configurable: " + makeBoolean(d, b) + ", ";
  if (rnd(2)) s += "enumerable: " + makeBoolean(d, b) + ", ";  
  if (s.length > 2)
    s = s.substr(0, s.length - 2);  s += "})";
  return s;
}function makeBoolean(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);
  switch(rnd(4)) {
    case 0:   return "true";
    case 1:   return "false";
    case 2:   return makeExpr(d - 2, b);
    default:  var m = loopModulo(); return "(" + Random.index(b) + " % " + m + Random.index([" == ", " != "]) + rnd(m) + ")";
  }
}
function makeObjLiteralPart(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(8))
  {
    
    
    
    case 2: return cat([" get ", makeObjLiteralName(d, b), maybeName(d, b), "(", makeFormalArgList(d - 1, b), ")", makeFunctionBody(d, b)]);
    case 3: return cat([" set ", makeObjLiteralName(d, b), maybeName(d, b), "(", makeFormalArgList(d - 1, b), ")", makeFunctionBody(d, b)]);    case 4: return "/*toXFun*/" + cat([Random.index(["toString", "toSource", "valueOf"]), ": ", makeToXFunction(d - 1, b)]);    default: return cat([makeObjLiteralName(d, b), ": ", makeExpr(d, b)]);
  }
}function makeToXFunction(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(4)) {
    case 0:  return "function() { return " + makeExpr(d, b) + "; }";
    case 1:  return "function() { return this; }";
    case 2:  return makeEvilCallback(d, b);
    default: return makeFunction(d, b);
  }
}
function makeObjLiteralName(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(6))
  {
    case 0:  return simpleSource(makeNumber(d, b)); 
    case 1:  return makeNumber(d, b);
    case 2:  return Random.index(allPropertyNames);
    case 3:  return Random.index(specialProperties);
    default: return makeId(d, b);
  }
}
function makeFunction(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if(rnd(5) === 1)
    return makeExpr(d, b);  if (rnd(4) === 1)
    return Random.index(builtinFunctions);  return (Random.index(functionMakers))(d, b);
}
function maybeName(d, b)
{
  if (rnd(2) === 0)
    return " " + makeId(d, b) + " ";
  else
    return "";
}function directivePrologue()
{
  var s = "";
  if (rnd(3) === 0)
    s += '"use strict"; ';
  if (rnd(30) === 0)
    s += '"use asm"; ';
  return s;
}function makeFunctionBody(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(5)) {
    case 0:  return cat([" { ", directivePrologue(), makeStatement(d - 1, b),   " } "]);
    case 1:  return cat([" { ", directivePrologue(), "return ", makeExpr(d, b), " } "]);
    case 2:  return cat([" { ", directivePrologue(), "yield ",  makeExpr(d, b), " } "]);
    case 3:  return '"use asm"; ' + asmJSInterior([]);
    default: return makeExpr(d, b); 
  }
}
var functionMakers = [
    makeFunOnCallChain,
  makeMathFunction,
  makeMathyFunRef,  
  function(d, b) { var v = makeNewId(d, b); return cat(["function", " ", maybeName(d, b), "(", v,                       ")", makeFunctionBody(d, b.concat([v]))]); },
  function(d, b) {                          return cat(["function", " ", maybeName(d, b), "(", makeFormalArgList(d, b), ")", makeFunctionBody(d, b)]); },  
  function(d, b) { var v = makeNewId(d, b); return cat([     v,                            " => ", makeFunctionBody(d, b.concat([v]))]); },  
  function(d, b) {                          return cat(["(", makeFormalArgList(d, b), ")", " => ", makeFunctionBody(d, b)]); },  
  function(d, b) { return "function(q) { " + directivePrologue() + "return q; }"; },
  function(d, b) { return "q => q"; },  
  function(d, b) { return "function(y) { " + directivePrologue() + makeStatement(d, b.concat(["y"])) + " }"; },  
  function(d, b) { return "function(y) { " + directivePrologue() + "return " + makeExpr(d, b.concat(["y"])) + " }"; },  
  function(d, b) { return "function(y) { " + directivePrologue() + "yield y; " + makeStatement(d, b.concat(["y"])) + "; yield y; }"; },  
  function(d, b) { return "(1 for (x in []))"; },  
  function(d, b) { return "/*wrap1*/(function(){ " + directivePrologue() + makeStatement(d, b) + "return " + makeFunction(d, b) + "})()"; },  
  function(d, b) { var v1 = uniqueVarName(); var v2 = uniqueVarName(); return "/*wrap2*/(function(){ " + directivePrologue() + "var " + v1 + " = " + makeExpr(d, b) + "; var " + v2 + " = " + makeFunction(d, b.concat([v1])) + "; return " + v2 + ";})()"; },  
  function(d, b) { var v1 = uniqueVarName(); var v2 = uniqueVarName(); return "/*wrap3*/(function(){ " + directivePrologue() + "var " + v1 + " = " + makeExpr(d, b) + "; (" + makeFunction(d, b.concat([v1])) + ")(); })"; },  
  function(d, b) { return "(" + makeFunction(d-1, b) + ").apply"; },
  function(d, b) { return "(" + makeFunction(d-1, b) + ").call"; },  
  function(d, b) { return "(" + makeFunction(d-1, b) + ").bind"; },
  function(d, b) { return "(" + makeFunction(d-1, b) + ").bind(" + makeActualArgList(d, b) + ")"; },  
  function(d, b) { return cat([makeExpr(d, b), ".", Random.index(allMethodNames)]); },  
  function(d, b) { return "eval"; }, 
  function(d, b) { return "(let (e=eval) e)"; },
  function(d, b) { return "new Function"; }, 
  function(d, b) { return "(new Function(" + uneval(makeStatement(d, b)) + "))"; },
  function(d, b) { return "Function"; }, 
  function(d, b) { return "decodeURI"; },
  function(d, b) { return "decodeURIComponent"; },
  function(d, b) { return "encodeURI"; },
  function(d, b) { return "encodeURIComponent"; },
  function(d, b) { return "neuter"; },
  function(d, b) { return "objectEmulatingUndefined"; }, 
  function(d, b) { return makeProxyHandlerFactory(d, b); },
  function(d, b) { return makeShapeyConstructor(d, b); },
  function(d, b) { return Random.index(typedArrayConstructors); },
  function(d, b) { return Random.index(constructors); },
];if (typeof XPCNativeWrapper == "function") {
  functionMakers = functionMakers.concat([
    function(d, b) { return "XPCNativeWrapper"; },
    function(d, b) { return "XPCSafeJSObjectWrapper"; },
  ]);
}if (typeof oomTest == "function" && engine != ENGINE_SPIDERMONKEY_MOZILLA45) {
  functionMakers = functionMakers.concat([
    function(d, b) { return "oomTest"; }
  ]);
}var typedArrayConstructors = [
  "Int8Array",
  "Uint8Array",
  "Int16Array",
  "Uint16Array",
  "Int32Array",
  "Uint32Array",
  "Float32Array",
  "Float64Array",
  "Uint8ClampedArray"
];function makeTypedArrayStatements(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 0) return "";  var numViews = rnd(d) + 1;
  var numExtraStatements = rnd(d) + 1;
  var buffer = uniqueVarName();
  var bufferSize = (1 + rnd(2)) * (1 + rnd(2)) * (1 + rnd(2)) * rnd(5);
  var statements = "var " + buffer + " = new " + arrayBufferType() + "(" + bufferSize + "); ";
  var bv = b.concat([buffer]);
  for (var j = 0; j < numViews; ++j) {
    var view = buffer + "_" + j;
    var type = Random.index(typedArrayConstructors);
    statements += "var " + view + " = new " + type + "(" + buffer + "); ";
    bv.push(view);
    var view_0 = view + "[0]";
    bv.push(view_0);
    if (rnd(3) === 0)
      statements += "print(" + view_0 + "); ";
    if (rnd(3))
      statements += view_0 + " = " + makeNumber(d - 2, b) + "; ";
    bv.push(view + "[" + rnd(11) + "]");
  }
  for (var j = 0; j < numExtraStatements; ++j) {
    statements += makeStatement(d - numExtraStatements, bv);
  }
  return statements;
}function makeNumber(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var signStr = rnd(2) ? "-" : "";  switch(rnd(70)) {
    case 0:  return makeExpr(d - 2, b);
    case 1:  return signStr + "0";
    case 2:  return signStr + (rnd(1000) / 1000);
    case 3:  return signStr + (rnd(0xffffffff) / 2);
    case 4:  return signStr + rnd(0xffffffff);
    case 5:  return Random.index(["0.1", ".2", "3", "1.3", "4.", "5.0000000000000000000000", "1.2e3", "1e81", "1e+81", "1e-81", "1e4", "0", "-0", "(-0)", "-1", "(-1)", "0x99", "033", "3.141592653589793", "3/0", "-3/0", "0/0", "0x2D413CCC", "0x5a827999", "0xB504F332", "(0x50505050 >> 1)", "0x80000000"]);
    case 6:  return signStr + (Math.pow(2, rnd(66)) + (rnd(3) - 1));
    default: return signStr + rnd(30);
  }
}
function makeLetHead(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var items = (d > 0 || rnd(2) === 0) ? rnd(10) + 1 : 1;
  var result = "";  for (var i = 0; i < items; ++i) {
    if (i > 0)
      result += ", ";
    result += makeLetHeadItem(d - i, b);
  }  return result;
}function makeLetHeadItem(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if (d < 0 || rnd(2) === 0)
    return rnd(2) ? uniqueVarName() : makeId(d, b);
  else if (rnd(5) === 0)
    return makeDestructuringLValue(d, b) + " = " + makeExpr(d, b);
  else
    return makeId(d, b) + " = " + makeExpr(d, b);
}
function makeActualArgList(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var nArgs = rnd(3);  if (nArgs == 0)
    return "";  var argList = makeExpr(d, b);  for (var i = 1; i < nArgs; ++i)
    argList += ", " + makeExpr(d - i, b);  return argList;
}function makeFormalArgList(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var argList = [];  var nArgs = rnd(5) ? rnd(3) : rnd(100);
  for (var i = 0; i < nArgs; ++i) {
    argList.push(makeFormalArg(d - i, b));
  }  if (rnd(5) === 0) {
    
    argList.push("..." + makeId(d, b));
  }  return argList.join(", ");
}function makeFormalArg(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(8) === 1)
    return makeDestructuringLValue(d, b);  return makeId(d, b) + (rnd(5) ? "" : " = " + makeExpr(d, b));
}
function makeNewId(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return Random.index(["a", "b", "c", "d", "e", "w", "x", "y", "z"]);
}function makeId(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(3) === 1 && b.length)
    return Random.index(b);  switch(rnd(200))
  {
  case 0:
    return makeTerm(d, b);
  case 1:
    return makeExpr(d, b);
  case 2: case 3: case 4: case 5:
    return makeLValue(d, b);
  case 6: case 7:
    return makeDestructuringLValue(d, b);
  case 8: case 9: case 10:
    
    
    return Random.index(["get", "set", "getter", "setter", "delete", "let", "yield", "of"]);
  case 11: case 12: case 13:
    return "this." + makeId(d, b);
  case 14: case 15: case 16:
    return makeObjLiteralName(d - 1, b);
  case 17: case 18:
    return makeId(d - 1, b);
  case 19:
    return " "; 
  case 20:
    return "this";
  }  return Random.index(["a", "b", "c", "d", "e", "w", "x", "y", "z",
                 "window", "eval", "\u3056", "NaN",                  ]);    
  
}
function makeComprehension(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 0)
    return "";  switch(rnd(7)) {
  case 0:
    return "";
  case 1:
    return cat([" for ",          "(", makeForInLHS(d, b), " in ", makeExpr(d - 2, b),     ")"]) + makeComprehension(d - 1, b);
  
  case 2:
    return cat([" for ", "each ", "(", makeId(d, b),       " in ", makeExpr(d - 2, b),     ")"]) + makeComprehension(d - 1, b);
  case 3:
    return cat([" for ", "each ", "(", makeId(d, b),       " in ", makeIterable(d - 2, b), ")"]) + makeComprehension(d - 1, b);
  case 4:
    return cat([" for ",          "(", makeId(d, b),       " of ", makeExpr(d - 2, b),     ")"]) + makeComprehension(d - 1, b);
  case 5:
    return cat([" for ",          "(", makeId(d, b),       " of ", makeIterable(d - 2, b), ")"]) + makeComprehension(d - 1, b);
  default:
    return cat([" if ", "(", makeExpr(d - 2, b), ")"]); 
  }
}function makeForInLHS(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);
  return makeLValue(d, b);
}
function makeLValue(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d <= 0 || (rnd(2) === 1))
    return makeId(d - 1, b);  d = rnd(d);   return (Random.index(lvalueMakers))(d, b);
}
var lvalueMakers = [
  
  function(d, b) { return cat([makeId(d, b)]); },  
  function(d, b) { return cat(["(", makeLValue(d, b), ")"]); },  
  function(d, b) { return makeDestructuringLValue(d, b); },
  function(d, b) { return "(" + makeDestructuringLValue(d, b) + ")"; },  
  function(d, b) { return cat([makeId(d, b), "(", makeExpr(d, b), ")"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", "(", makeExpr(d, b), ")"]); },  
  function(d, b) { return Random.index(builtinProperties); },
  function(d, b) { return Random.index(builtinObjectNames); },  
  function(d, b) { return "arguments"; },
  function(d, b) { return cat(["arguments", "[", makePropertyName(d, b), "]"]); },
  function(d, b) { return makeFunOnCallChain(d, b) + ".arguments"; },   
  function(d, b) { return cat([makeExpr(d, b),  ".", makeId(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b),  ".", "__proto__"]); },
  function(d, b) { return cat([makeExpr(d, b), "[", makePropertyName(d, b), "]"]); },  
  function(d, b) { return "this.zzz.zzz"; },  
  function(d, b) { return makeExpr(d, b); },
];
function makeDestructuringLValue(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if (d < 0 || rnd(4) === 1)
    return makeId(d, b);  if (rnd(6) === 1)
    return makeLValue(d, b);  return (Random.index(destructuringLValueMakers))(d, b);
}var destructuringLValueMakers = [
  
  function(d, b)
  {
    var len = rnd(d, b);
    if (len == 0)
      return "[]";    var Ti = [];
    Ti.push("[");
    Ti.push(maybeMakeDestructuringLValue(d, b));
    for (var i = 1; i < len; ++i) {
      Ti.push(", ");
      Ti.push(maybeMakeDestructuringLValue(d, b));
    }    Ti.push("]");    return cat(Ti);
  },  
  function(d, b)
  {
    var len = rnd(d, b);
    if (len == 0)
      return "{}";
    var Ti = [];
    Ti.push("{");
    for (var i = 0; i < len; ++i) {
      if (i > 0)
        Ti.push(", ");
      Ti.push(makeId(d, b));
      if (rnd(3)) {
        Ti.push(": ");
        Ti.push(makeDestructuringLValue(d, b));
      } 
    }
    Ti.push("}");    return cat(Ti);
  }
];
function maybeMakeDestructuringLValue(d, b)
{
  if (rnd(2) === 0)
    return "";  return makeDestructuringLValue(d, b);
}function makeTerm(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return (Random.index(termMakers))(d, b);
}var termMakers = [
  
  function(d, b) { return makeId(d, b); },  
  function(d, b) { return Random.index([
    
    "[]", "[1]", "[[]]", "[[1]]", "[,]", "[,,]", "[1,,]",
    
    "{}", "({})", "({a1:1})",
    
    "[z1]", "[z1,,]", "[,,z1]",
    
    "({a2:z2})",
    "function(id) { return id }",
    "function ([y]) { }",
    "(function ([y]) { })()",    "arguments",
    "Math",
    "this",
    "length",    '"\u03A0"', 
    ]);
  },
  makeNumber,
  function(d, b) { return Random.index([ "true", "false", "undefined", "null"]); },
  function(d, b) { return Random.index([ "this", "window" ]); },
  function(d, b) { return Random.index([" \"\" ", " '' "]); },
  randomUnitStringLiteral, 
  function(d, b) { return Random.index([" /x/ ", " /x/g "]); },
  makeRegex,
];function randomUnitStringLiteral()
{
  var s = "\"\\u";
  for (var i = 0; i < 4; ++i) {
    s += "0123456789ABCDEF".charAt(rnd(16));
  }
  s += "\"";
  return s;
}
function maybeMakeTerm(d, b)
{
  if (rnd(2))
    return makeTerm(d - 1, b);
  else
    return "";
}
function makeCrazyToken()
{
  if (rnd(3) === 0) {
    return String.fromCharCode(32 + rnd(128 - 32));
  }
  if (rnd(6) === 0) {
    return String.fromCharCode(rnd(65536));
  }  return Random.index([    
   "//", UNTERMINATED_COMMENT, (UNTERMINATED_COMMENT + "\n"), "/*\n*/", 
  "[", "]",
  "{", "}",
  "(", ")",  
  "!", "@", "%", "^", "*", "**", "|", ":", "?", "'", "\"", ",", ".", "/",
  "~", "_", "+", "=", "-", "++", "--", "+=", "%=", "|=", "-=",
  "...", "=>",  
  " in ", " instanceof ", " let ", " new ", " get ", " for ", " if ", " else ", " else if ", " try ", " catch ", " finally ", " export ", " import ", " void ", " with ",
  " default ", " goto ", " case ", " switch ", " do ", " /*infloop*/while ", " return ", " yield ", " break ", " continue ", " typeof ", " var ", " const ",  
  " package ",  
  " enum ", 
  " debugger ", 
  " super ",   " this ", 
  " null ", 
  " undefined ", 
  "\n", 
  "\r",
  "\u2028", 
  "\u2029", 
  "<" + "!" + "--", 
  "--" + ">", 
  "",
  "\0", 
  ]);
}
function makeShapeyValue(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(10) === 0)
    return makeExpr(d, b);  var a = [
    
    [
    "0", "1", "2", "3", "0.1", ".2", "1.3", "4.", "5.0000000000000000000000",
    "1.2e3", "1e81", "1e+81", "1e-81", "1e4", "-0", "(-0)",
    "-1", "(-1)", "0x99", "033", "3/0", "-3/0", "0/0",
    "Math.PI",
    "0x2D413CCC", "0x5a827999", "0xB504F332", "-0x2D413CCC", "-0x5a827999", "-0xB504F332", "0x50505050", "(0x50505050 >> 1)",
    
    "0x10000000", "0x20000000", "0x3FFFFFFE", "0x3FFFFFFF", "0x40000000", "0x40000001", "0x80000000", "-0x80000000",
    ],    
    [ "(1/0)", "(-1/0)", "(0/0)" ],    
    [" \"\" ", " '' ", " 'A' ", " '\\0' ", ' "use strict" '],    
    [ " /x/ ", " /x/g "],    
    [ "true", "false" ],    
    [ "(void 0)", "null" ],    
    [ "[]", "[1]", "[(void 0)]", "{}", "{x:3}", "({})", "({x:3})" ],    
    [ "NaN", "Infinity", "-Infinity", "undefined"],    
    [ "new Boolean(true)", "new Boolean(false)" ],    
    [ "new Number(1)", "new Number(1.5)" ],    
    [ "new String('')", "new String('q')" ],    
    [ "function(){}" ],
    [ "{}", "[]", "[1]", "['z']", "[undefined]", "this", "eval", "arguments", "arguments.caller", "arguments.callee" ],
    [ "objectEmulatingUndefined()" ],    
    [ b.length ? Random.index(b) : "x" ]
  ];  return Random.index(Random.index(a));
}function mixedTypeArrayElem(d, b)
{
  while (true) {
    var s = makeShapeyValue(d - 3, b);
    if (s.length < 60)
      return s;
  }
}function makeMixedTypeArray(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  var q = rnd(4) + 2;
  var picks = [];
  for (var j = 0; j < q; ++j) {
    picks.push(mixedTypeArrayElem(d, b));
  }  
  var c = [];
  var count = loopCount();
  for (var j = 0; j < count; ++j) {
    var elem = Random.index(picks);
    
    
    var repeat = count === 0 ? rnd(4)===0 : rnd(50)===0;
    var repeats = repeat ? rnd(30) : 1;
    for (var k = 0; k < repeats; ++k) {
      c.push(elem);
    }
  }  return "/*MARR*/" + "[" + c.join(", ") + "]";
}function makeArrayLiteral(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(2) === 0)
    return makeMixedTypeArray(d, b);  var elems = [];
  while (rnd(5)) elems.push(makeArrayLiteralElem(d, b));
  return "/*FARR*/" + "[" + elems.join(", ") + "]";
}function makeArrayLiteralElem(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch (rnd(5)) {
    case 0:  return "..." + makeIterable(d - 1, b); 
    case 1:  return ""; 
    default: return makeExpr(d - 1, b);
  }
}function makeIterable(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 1)
    return "[]";  return (Random.index(iterableExprMakers))(d, b);
}var iterableExprMakers = Random.weighted([
  
  { w: 1, v: function(d, b) { return "new Array(" + makeNumber(d, b) + ")"; } },
  { w: 8, v: makeArrayLiteral },  
  { w: 1, v: function(d, b) { return cat(["[", makeExpr(d, b), makeComprehension(d, b), "]"]); } },  
  { w: 1, v: function(d, b) { return cat([     makeExpr(d, b), makeComprehension(d, b)     ]); } },
  { w: 1, v: function(d, b) { return cat(["(", makeExpr(d, b), makeComprehension(d, b), ")"]); } },  
  { w: 1, v: function(d, b) { return "(function() { " + directivePrologue() + "yield " + makeExpr(d - 1, b) + "; } })()"; } },
  
  { w: 1, v: function(d, b) { return "/*PTHR*/(function() { " + directivePrologue() + "for (var i of " + makeIterable(d - 1, b) + ") { yield i; } })()"; } },  { w: 1, v: makeFunction },
  { w: 1, v: makeExpr },
]);function strTimes(s, n)
{
  if (n == 0) return "";
  if (n == 1) return s;
  var s2 = s + s;
  var r = n % 2;
  var d = (n - r) / 2;
  var m = strTimes(s2, d);
  return r ? m + s : m;
}
function makeAsmJSModule(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var interior = asmJSInterior([]);
  return '(function(stdlib, foreign, heap){ "use asm"; ' + interior + ' })';
}function makeAsmJSFunction(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var interior = asmJSInterior(["ff"]);
  return '(function(stdlib, foreign, heap){ "use asm"; ' + interior + ' })(this, {ff: ' + makeFunction(d - 2, b) + '}, new ' + arrayBufferType() + '(4096))';
}var proxyHandlerProperties = {
  getOwnPropertyDescriptor: {
    empty:    "function(){}",
    forward:  "function(name) { var desc = Object.getOwnPropertyDescriptor(x); desc.configurable = true; return desc; }",
    throwing: "function(name) { return {get: function() { throw 4; }, set: function() { throw 5; }}; }",
  },
  getPropertyDescriptor: {
    empty:    "function(){}",
    forward:  "function(name) { var desc = Object.getPropertyDescriptor(x); desc.configurable = true; return desc; }",
    throwing: "function(name) { return {get: function() { throw 4; }, set: function() { throw 5; }}; }",
  },
  defineProperty: {
    empty:    "function(){}",
    forward:  "function(name, desc) { Object.defineProperty(x, name, desc); }"
  },
  getOwnPropertyNames: {
    empty:    "function() { return []; }",
    forward:  "function() { return Object.getOwnPropertyNames(x); }"
  },
  delete: {
    empty:    "function() { return true; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(name) { return delete x[name]; }"
  },
  fix: {
    empty:    "function() { return []; }",
    yes:      "function() { return []; }",
    no:       "function() { }",
    forward:  "function() { if (Object.isFrozen(x)) { return Object.getOwnProperties(x); } }"
  },
  has: {
    empty:    "function() { return false; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(name) { return name in x; }"
  },
  hasOwn: {
    empty:    "function() { return false; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(name) { return Object.prototype.hasOwnProperty.call(x, name); }"
  },
  get: {
    empty:    "function() { return undefined }",
    forward:  "function(receiver, name) { return x[name]; }",
    bind:     "function(receiver, name) { var prop = x[name]; return (typeof prop) === 'function' ? prop.bind(x) : prop; }"
  },
  set: {
    empty:    "function() { return true; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(receiver, name, val) { x[name] = val; return true; }"
  },
  iterate: {
    empty:    "function() { return (function() { throw StopIteration; }); }",
    forward:  "function() { return (function() { for (var name in x) { yield name; } })(); }"
  },
  enumerate: {
    empty:    "function() { return []; }",
    forward:  "function() { var result = []; for (var name in x) { result.push(name); }; return result; }"
  },
  keys: {
    empty:    "function() { return []; }",
    forward:  "function() { return Object.keys(x); }"
  }
};function makeProxyHandlerFactory(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 1)
    return "({/*TOODEEP*/})";  try { 
    var preferred = Random.index(["empty", "forward", "yes", "no", "bind", "throwing"]);
    var fallback = Random.index(["empty", "forward"]);
    var fidelity = rnd(10);    var handlerFactoryText = "(function handlerFactory(x) {";
    handlerFactoryText += "return {";    if (rnd(2)) {
      
      bp = b.concat(['x']);
    } else {
      
      handlerFactoryText = handlerFactoryText.replace(/x/, "");
      bp = b;
    }    for (var p in proxyHandlerProperties) {
      var funText;
      if (proxyHandlerProperties[p][preferred] && rnd(10) <= fidelity) {
        funText = proxyMunge(proxyHandlerProperties[p][preferred], p);
      } else {
        switch(rnd(7)) {
        case 0:  funText = makeFunction(d - 3, bp); break;
        case 1:  funText = "undefined"; break;
        case 2:  funText = "function() { throw 3; }"; break;
        default: funText = proxyMunge(proxyHandlerProperties[p][fallback], p);
        }
      }
      handlerFactoryText += p + ": " + funText + ", ";
    }    handlerFactoryText += "}; })";    return handlerFactoryText;
  } catch(e) {
    return "({/* :( */})";
  }
}function proxyMunge(funText, p)
{
  
  return funText;
}function makeProxyHandler(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return makeProxyHandlerFactory(d, b) + "(" + makeExpr(d - 3, b) + ")";
}
/*
David Anderson suggested creating the following recursive structures:
  - recurse down an array of mixed types, car cdr kinda thing
  - multiple recursive calls in a function, like binary search left/right, sometimes calls neither and sometimes calls both  the recursion support in spidermonkey only works with self-recursion.
  that is, two functions that call each other recursively will not be traced.  two trees are formed, going down and going up.
  type instability matters on both sides.
  so the values returned from the function calls matter.  so far, what i've thought of means recursing from the top of a function and if..else.
  but i'd probably also want to recurse from other points, e.g. loops.  special code for tail recursion likely coming soon, but possibly as a separate patch, because it requires changes to the interpreter.
*/
var recursiveFunctions = [
  {
    
    text: "(function too_much_recursion(depth) { @; if (depth > 0) { @; too_much_recursion(depth - 1); @ } else { @ } @ })",
    vars: ["depth"],
    args: function(d, b) { return singleRecursionDepth(d, b); },
    test: function(f) { try { f(5000); } catch(e) { } return true; }
  },
  {
    text: "(function factorial(N) { @; if (N == 0) { @; return 1; } @; return N * factorial(N - 1); @ })",
    vars: ["N"],
    args: function(d, b) { return singleRecursionDepth(d, b); },
    test: function(f) { return f(10) == 3628800; }
  },
  {
    text: "(function factorial_tail(N, Acc) { @; if (N == 0) { @; return Acc; } @; return factorial_tail(N - 1, Acc * N); @ })",
    vars: ["N", "Acc"],
    args: function(d, b) { return singleRecursionDepth(d, b) + ", 1"; },
    test: function(f) { return f(10, 1) == 3628800; }
  },
  {
    
    text: "(function fibonacci(N) { @; if (N <= 1) { @; return 1; } @; return fibonacci(N - 1) + fibonacci(N - 2); @ })",
    vars: ["N"],
    args: function(d, b) { return "" + rnd(8); },
    test: function(f) { return f(6) == 13; }
  },
  {
    
    text: "(function a_indexing(array, start) { @; if (array.length == start) { @; return EXPR1; } var thisitem = array[start]; var recval = a_indexing(array, start + 1); STATEMENT1 })",
    vars: ["array", "start", "thisitem", "recval"],
    args: function(d, b) { return makeMixedTypeArray(d-1, b) + ", 0"; },
    testSub: function(text) { return text.replace(/EXPR1/, "0").replace(/STATEMENT1/, "return thisitem + recval;"); },
    randSub: function(text, varMap, d, b) {
        var expr1 =      makeExpr(d, b.concat([varMap["array"], varMap["start"]]));
        var statement1 = rnd(2) ?
                                   makeStatement(d, b.concat([varMap["thisitem"], varMap["recval"]]))        :
                            "return " + makeExpr(d, b.concat([varMap["thisitem"], varMap["recval"]])) + ";";        return (text.replace(/EXPR1/,      expr1)
                    .replace(/STATEMENT1/, statement1)
        ); },
    test: function(f) { return f([1,2,3,"4",5,6,7], 0) == "123418"; }
  },
  {
    
    text: "(function sum_indexing(array, start) { @; return array.length == start ? 0 : array[start] + sum_indexing(array, start + 1); })",
    vars: ["array", "start"],
    args: function(d, b) { return makeMixedTypeArray(d-1, b) + ", 0"; },
    test: function(f) { return f([1,2,3,"4",5,6,7], 0) == "123418"; }
  },
  {
    text: "(function sum_slicing(array) { @; return array.length == 0 ? 0 : array[0] + sum_slicing(array.slice(1)); })",
    vars: ["array"],
    args: function(d, b) { return makeMixedTypeArray(d-1, b); },
    test: function(f) { return f([1,2,3,"4",5,6,7]) == "123418"; }
  }
];function singleRecursionDepth(d, b)
{
  if (rnd(2) === 0) {
    return "" + rnd(4);
  }
  if (rnd(10) === 0) {
    return makeExpr(d - 2, b);
  }
  return "" + rnd(100000);
}(function testAllRecursiveFunctions() {
  for (var i = 0; i < recursiveFunctions.length; ++i) {
    var a = recursiveFunctions[i];
    var text = a.text;
    if (a.testSub) text = a.testSub(text);
    var f = eval(text.replace(/@/g, ""));
    if (!a.test(f))
      throw "Failed test of: " + a.text;
  }
})();function makeImmediateRecursiveCall(d, b, cheat1, cheat2)
{
  if (rnd(10) !== 0)
    return "(4277)";  var a = (cheat1 == null) ? Random.index(recursiveFunctions) : recursiveFunctions[cheat1];
  var s = a.text;
  var varMap = {};
  for (var i = 0; i < a.vars.length; ++i) {
    var prettyName = a.vars[i];
    varMap[prettyName] = uniqueVarName();
    s = s.replace(new RegExp(prettyName, "g"), varMap[prettyName]);
  }
  var actualArgs = cheat2 == null ? a.args(d, b) : cheat2;
  s = s + "(" + actualArgs + ")";
  s = s.replace(/@/g, function() { if (rnd(4) === 0) return makeStatement(d-2, b); return ""; });
  if (a.randSub) s = a.randSub(s, varMap, d, b);
  s = "(" + s + ")";
  return s;
}/*********************************
 * GENERATING REGEXPS AND INPUTS *
 *********************************/var POTENTIAL_MATCHES = 10;
var backrefHack = [];
for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
  backrefHack[i] = "";
}function regexNumberOfMatches()
{
  if (rnd(10))
    return rnd(5);
  return Math.pow(2, rnd(40)) + rnd(3) - 1;
}function regexPattern(depth, parentWasQuantifier)
{
  if (depth == 0 || (rnd(depth) == 0))
    return regexTerm();  var dr = depth - 1;  var index = rnd(regexMakers.length);
  if (parentWasQuantifier && rnd(30)) index = rnd(regexMakers.length - 1) + 1; 
  return (Random.index(regexMakers[index]))(dr);
}var regexMakers =
[
  [
    
    function(dr) { return regexQuantified(dr, "+", 1, rnd(10)); },
    function(dr) { return regexQuantified(dr, "*", 0, rnd(10)); },
    function(dr) { return regexQuantified(dr, "?", 0, 1); },
    function(dr) { return regexQuantified(dr, "+?", 1, 1); },
    function(dr) { return regexQuantified(dr, "*?", 0, 1); },
    function(dr) { var x = regexNumberOfMatches(); return regexQuantified(dr, "{" + x + "}", x, x); },
    function(dr) { var x = regexNumberOfMatches(); return regexQuantified(dr, "{" + x + ",}", x, x + rnd(10)); },
    function(dr) { var min = regexNumberOfMatches(); var max = min + regexNumberOfMatches(); return regexQuantified(dr, "{" + min + "," + max + "}", min, max); }
  ],
  [
    
    function(dr) { return regexConcatenation(dr); },
    function(dr) { return regexDisjunction(dr); }
  ],
  [
    
    function(dr) { return ["\\" + (rnd(3) + 1), backrefHack.slice(0)]; }, 
    function(dr) { return regexGrouped("(", dr, ")");   }, 
    function(dr) { return regexGrouped("(?:", dr, ")"); }, 
    function(dr) { return regexGrouped("(?=", dr, ")"); }, 
    function(dr) { return regexGrouped("(?!", dr, ")"); }  
  ]
];
function quantifierHelper(pm, min, max, pms)
{
  var repeats = Math.min(min + rnd(max - min + 5) - 2, 10);
  var returnValue = "";
  for (var i = 0; i < repeats; i++)
  {
    if (rnd(100) < 80)
      returnValue = returnValue + pm;
    else
      returnValue = returnValue + Random.index(pms);
  }
  return returnValue;
}function regexQuantified(dr, operator, min, max)
{
  var [re, pms] = regexPattern(dr, true);
  var newpms = [];
  for (var i = 0; i < POTENTIAL_MATCHES; i++)
    newpms[i] = quantifierHelper(pms[i], min, max, pms);
  return [re + operator, newpms];
}
function regexConcatenation(dr)
{
  var [re1, strings1] = regexPattern(dr, false);
  var [re2, strings2] = regexPattern(dr, false);
  var newStrings = [];  for (var i = 0; i < POTENTIAL_MATCHES; i++)
  {
    var chance = rnd(100);
    if (chance < 10)
      newStrings[i] = "";
    else if (chance < 20)
      newStrings[i] = strings1[i];
    else if (chance < 30)
      newStrings[i] = strings2[i];
    else if (chance < 65)
      newStrings[i] = strings1[i] + strings2[i];
    else
      newStrings[i] = Random.index(strings1) + Random.index(strings2);
  }  return [re1 + re2, newStrings];
}function regexDisjunction(dr)
{
  var [re1, strings1] = regexPattern(dr, false);
  var [re2, strings2] = regexPattern(dr, false);
  var newStrings = [];  for (var i = 0; i < POTENTIAL_MATCHES; i++)
  {
    var chance = rnd(100);
    if (chance < 10)
      newStrings[i] = "";
    else if (chance < 20)
      newStrings[i] = Random.index(strings1) + Random.index(strings2);
    else if (chance < 60)
      newStrings[i] = strings1[i];
    else
      newStrings[i] = strings2[i];
  }
  return [re1 + "|" + re2, newStrings];
}function regexGrouped(prefix, dr, postfix)
{
  var [re, strings] = regexPattern(dr, false);
  var newStrings = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    newStrings[i] = rnd(5) ? strings[i] : "";
    if (prefix == "(" && strings[i].length < 40 && rnd(3) === 0) {
      backrefHack[i] = strings[i];
    }
  }
  return [prefix + re + postfix, newStrings];
}
var letters =
["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
 "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"];var hexDigits = [
  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
  "a", "b", "c", "d", "e", "f",
  "A", "B", "C", "D", "E", "F"
];function regexTerm()
{
  var [re, oneString] = regexTermPair();
  var strings = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    strings[i] = rnd(5) ? oneString : regexTermPair()[1];
  }
  return [re, strings];
}function regexCharCode()
{
  return rnd(2) ? rnd(256) : rnd(65536);
}
var regexCharacterMakers = Random.weighted([
  
  { w:20, v: function() { var cc = regexCharCode(); return [       String.fromCharCode(cc), cc]; } }, 
  { w: 4, v: function() { var cc = regexCharCode(); return ["\\" + String.fromCharCode(cc), cc]; } }, 
  { w: 1, v: function() { return ["\\0",  0]; } },  
  { w: 1, v: function() { return ["\\B", 66]; } },  
  { w: 1, v: function() { return ["\\b",  8]; } },    
  { w: 1, v: function() { return ["\\t",  9]; } },  
  { w: 1, v: function() { return ["\\n", 10]; } },  
  { w: 1, v: function() { return ["\\v", 11]; } },  
  { w: 1, v: function() { return ["\\f", 12]; } },  
  { w: 1, v: function() { return ["\\r", 13]; } },  
  { w: 5, v: function() { var controlCharacterCode = rnd(26) + 1; return ["\\c" + String.fromCharCode(64 + controlCharacterCode), controlCharacterCode]; } },
  
  { w: 5, v: function() { var twoHex = Random.index(hexDigits) + Random.index(hexDigits); return ["\\x" + twoHex, parseInt(twoHex, 16)]; } },
  { w: 5, v: function() { var twoHex = Random.index(hexDigits) + Random.index(hexDigits); return ["\\u00" + twoHex, parseInt(twoHex, 16)]; } },
  { w: 5, v: function() { var fourHex = Random.index(hexDigits) + Random.index(hexDigits) + Random.index(hexDigits) + Random.index(hexDigits); return ["\\u" + fourHex, parseInt(fourHex, 16)]; } },
]);function regexCharacter()
{
  var [matcher, charcode] = Random.index(regexCharacterMakers)();
  switch(rnd(10)) {
    case 0:  return [matcher, charcode + 32]; 
    case 1:  return [matcher, charcode - 32]; 
    case 2:  return [matcher, regexCharCode()]; 
    default: return [matcher, charcode];
  }
}
var regexBuiltInCharClasses = [
    "\\d", "\\D", 
    "\\s", "\\S", 
    "\\w", "\\W", 
];
function regexOneCharStringsWith(frequentChars) {
  var matches = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    matches.push(rnd(8) ? Random.index(frequentChars) : String.fromCharCode(regexCharCode()));
  }
  return matches;
}
function regexShortStringsWith(frequentChars) {
  var matches = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    var s = "";
    while (rnd(3)) {
      s += rnd(4) ? Random.index(frequentChars) : String.fromCharCode(regexCharCode());
    }
    matches.push(s);
  }
  return matches;
}var regexTermMakers =
  [
    function() { return regexCharacterClass(); },
    function() { var [re, cc] = regexCharacter();   return [re, regexOneCharStringsWith([String.fromCharCode(cc)])]; },
    function() { return [Random.index(regexBuiltInCharClasses), regexOneCharStringsWith(["0", "a", "_"])]; },
    function() { return ["[^]",                                 regexOneCharStringsWith(["\n"])];     },
    function() { return [".",                                   regexOneCharStringsWith(["\n"])];     },
    function() { return [Random.index(["^", "$"]),              regexShortStringsWith(["\n"])];     },            
    function() { return [Random.index(["\\b", "\\B"]),          regexShortStringsWith([" ", "\n", "a", "1"])]; }, 
  ];function regexTerm()
{
  return Random.index(regexTermMakers)();
}function regexCharacterClass()
{
  var ranges = rnd(5);
  var inRange = rnd(2);
  var charBucket = [String.fromCharCode(regexCharCode())];   var re = "[";
  if (!inRange) {
    re += "^";
  }  var lo, hi;  for (var i = 0; i < ranges; ++i) {
    if (rnd(100) == 0) {
      
      re += "-";
      if (rnd(2)) {
        re += String.fromCharCode(regexCharCode());
      }
    }    if (rnd(3) == 1) {
      
      re += Random.index(regexBuiltInCharClasses);
      charBucket.push("a");
      charBucket.push("0");
      charBucket.push("_");
    } else if (rnd(2)) {
      
      var a = regexCharacter();
      var b = regexCharacter();
      if ((a[1] <= b[1]) == !!rnd(10)) {
        [lo, hi] = [a, b];
      } else {
        [lo, hi] = [b, a];
      }      re += lo[0] + "-" + hi[0];
      charBucket.push(String.fromCharCode(lo[1] + rnd(3) - 1));
      charBucket.push(String.fromCharCode(hi[1] + rnd(3) - 1));
      charBucket.push(String.fromCharCode(lo[1] + rnd(Math.max(hi[1] - lo[1], 1)))); 
    } else {
      
      var a = regexCharacter();
      re += a[0];
      charBucket.push(String.fromCharCode(a[1]));
    }
  }  re += "]";
  return [re, pickN(charBucket, POTENTIAL_MATCHES)];
}function pickN(bucket, picks)
{
  var picked = [];
  for (var i = 0; i < picks; ++i) {
    picked.push(Random.index(bucket));
  }
  return picked;
}function makeRegisterStompFunction(d, b, pure)
{
  var args = [];
  var nArgs = (rnd(10) ? rnd(20) : rnd(100)) + 1;
  for (var i = 0; i < nArgs; ++i) {
    args.push("a" + i);
  }  var bv = b.concat(args);  return (
    "(function(" + args.join(", ") + ") { " +
      makeRegisterStompBody(d, bv, pure) +
      "return " + Random.index(bv) + "; " +
    "})"
  );
}function makeRegisterStompBody(d, b, pure)
{
  var bv = b.slice(0);
  var lastRVar = 0;
  var s = "";  function value()
  {
    return rnd(3) && bv.length ? Random.index(bv) : "" + rnd(10);
  }  function expr()
  {
    return value() + Random.index([" + ", " - ", " / ", " * ", " % ", " | ", " & ", " ^ "]) + value();
  }  while (rnd(100)) {
    if (bv.length == 0 || rnd(4)) {
      var newVar = "r" + lastRVar;
      ++lastRVar;
      s += "var " + newVar + " = " + expr() + "; ";
      bv.push(newVar);
    } else if (rnd(5) === 0 && !pure) {
      s += "print(" + Random.index(bv) + "); ";
    } else {
      s += Random.index(bv) + " = " + expr() + "; ";
    }
  }  return s;
}
/***********************
 * TEST BUILT-IN TYPES *
 ***********************/var makeBuilderStatement;
var makeEvilCallback;(function setUpBuilderStuff() {
  var ARRAY_SIZE = 20;
  var OBJECTS_PER_TYPE = 3;
  var smallPowersOfTwo = [1, 2, 4, 8]; 
  function bufsize() { return rnd(ARRAY_SIZE) * Random.index(smallPowersOfTwo); }
  function arrayIndex(d, b) {
    switch(rnd(8)) {
      case 0:  return m("v");
      case 1:  return makeExpr(d - 1, b);
      case 2:  return "({valueOf: function() { " + makeStatement(d, b) + "return " + rnd(ARRAY_SIZE) + "; }})";
      default: return "" + rnd(ARRAY_SIZE);
    }
  }  
  function m(t)
  {
    if (!t)
      t = "aosmevbtihgfp";
    t = t.charAt(rnd(t.length));
    var name = t + rnd(OBJECTS_PER_TYPE);
    switch(rnd(16)) {
      case 0:  return m("o") + "." + name;
      case 1:  return m("g") + "." + name;
      case 2:  return "this." + name;
      default: return name;
    }
  }  function val(d, b)
  {
    if (rnd(10))
      return m();
    return makeExpr(d, b);
  }  
  function assign(d, b, t, rhs)
  {
    switch(rnd(18)) {
    
    case 0:  return (
      "Object.defineProperty(" +
        (rnd(8)?"this":m("og")) + ", " +
        simpleSource(m(t)) + ", " +
        "{ " + propertyDescriptorPrefix(d-1, b) + " get: function() { " + (rnd(8)?"":makeBuilderStatement(d-1,b)) + " return " + rhs + "; } }" +
      ");"
    );
    case 1:  return Random.index(varBinder) + m(t) + " = " + rhs + ";";
    default: return m(t) + " = " + rhs + ";";
    }
  }  function makeCounterClosure(d, b)
  {
    
    var v = uniqueVarName();
    var infrequently = infrequentCondition(v, 10);
    return (
      "(function mcc_() { " +
        "var " + v + " = 0; " +
        "return function() { " +
          "++" + v + "; " +
            (rnd(3) ?
              "if (" + infrequently + ") { dumpln('hit!'); " + makeBuilderStatements(d, b) + " } " +
              "else { dumpln('miss!'); " + makeBuilderStatements(d, b) + " } "
            : m("f") + "(" + infrequently + ");"
            ) +
        "};" +
      "})()");
  }  function fdecl(d, b)
  {
    var argName = m();
    var bv = b.concat([argName]);
    return "function " + m("f") + "(" + argName + ") " + makeFunctionBody(d, bv);
  }  function makeBuilderStatements(d, b)
  {
    var s = "";
    var extras = rnd(4);
    for (var i = 0; i < extras; ++i) {
      s += "try { " + makeBuilderStatement(d - 2, b) +  " } catch(e" + i + ") { } ";
    }
    s += makeBuilderStatement(d - 1, b);
    return s;
  }  var builderFunctionMakers = Random.weighted([
    { w: 9,  v: function(d, b) { return "(function() { " + makeBuilderStatements(d, b) + " return " + m() + "; })"; } },
    { w: 1,  v: function(d, b) { return "(function() { " + makeBuilderStatements(d, b) + " throw " + m() + "; })"; } },
    { w: 1,  v: function(d, b) { return "(function(j) { " + m("f") + "(j); })"; } }, 
    
    { w: 4,  v: function(d, b) { return "(function(j) { if (j) { " + makeBuilderStatements(d, b) + " } else { " + makeBuilderStatements(d, b) + " } })"; } },
    { w: 4,  v: function(d, b) { return "(function() { for (var j=0;j<" + loopCount() + ";++j) { " + m("f") + "(j%"+(2+rnd(4))+"=="+rnd(2)+"); } })"; } },
    { w: 1,  v: function(d, b) { return Random.index(builtinFunctions) + ".bind(" + m() + ")"; } },
    { w: 5,  v: function(d, b) { return m("f"); } },
    { w: 3,  v: makeCounterClosure },
    { w: 2,  v: makeFunction },
    { w: 1,  v: makeAsmJSModule },
    { w: 1,  v: makeAsmJSFunction },
    { w: 1,  v: makeRegisterStompFunction },
  ]);
  makeEvilCallback = function(d, b) {
    return (Random.index(builderFunctionMakers))(d - 1, b);
  };  var handlerTraps = ["getOwnPropertyDescriptor", "getPropertyDescriptor", "defineProperty", "getOwnPropertyNames", "delete", "fix", "has", "hasOwn", "get", "set", "iterate", "enumerate", "keys"];  function forwardingHandler(d, b) {
    return (
      "({"+
        "getOwnPropertyDescriptor: function(name) { Z; var desc = Object.getOwnPropertyDescriptor(X); desc.configurable = true; return desc; }, " +
        "getPropertyDescriptor: function(name) { Z; var desc = Object.getPropertyDescriptor(X); desc.configurable = true; return desc; }, " +
        "defineProperty: function(name, desc) { Z; Object.defineProperty(X, name, desc); }, " +
        "getOwnPropertyNames: function() { Z; return Object.getOwnPropertyNames(X); }, " +
        "delete: function(name) { Z; return delete X[name]; }, " +
        "fix: function() { Z; if (Object.isFrozen(X)) { return Object.getOwnProperties(X); } }, " +
        "has: function(name) { Z; return name in X; }, " +
        "hasOwn: function(name) { Z; return Object.prototype.hasOwnProperty.call(X, name); }, " +
        "get: function(receiver, name) { Z; return X[name]; }, " +
        "set: function(receiver, name, val) { Z; X[name] = val; return true; }, " +
        "iterate: function() { Z; return (function() { for (var name in X) { yield name; } })(); }, " +
        "enumerate: function() { Z; var result = []; for (var name in X) { result.push(name); }; return result; }, " +
        "keys: function() { Z; return Object.keys(X); } " +
      "})"
    )
    .replace(/X/g, m())
    .replace(/Z/g, function() {
      switch(rnd(20)){
        case 0:  return "return " + m();
        case 1:  return "throw " + m();
        default: return makeBuilderStatement(d - 2, b);
      }
    });
  }  function propertyDescriptorPrefix(d, b)
  {
    return "configurable: " + makeBoolean(d, b) + ", " + "enumerable: " + makeBoolean(d, b) + ", ";
  }  function strToEval(d, b)
  {
    switch(rnd(5)) {
      case 0:  return simpleSource(fdecl(d, b));
      case 1:  return simpleSource(makeBuilderStatement(d, b));
      default: return simpleSource(makeScriptForEval(d, b));
    }
  }  function evaluateFlags(d, b)
  {
    
    return ("({ global: " + m("g") +
      ", fileName: " + Random.index(["'evaluate.js'", "null"]) +
      ", lineNumber: 42, newContext: " + makeBoolean(d, b) +
      ", isRunOnce: " + makeBoolean(d, b) +
      ", noScriptRval: " + makeBoolean(d, b) +
      ", catchTermination: " + makeBoolean(d, b) +
      ", saveFrameChain: " + ("bug 881999" && rnd(10000) ? "false" : makeBoolean(d, b)) +
      ((rnd(5) == 0) ? (
        ((rnd(2) == 0) ? (", element: " + m("o")) : "") +
        ((rnd(2) == 0) ? (", elementProperty: " + m("s")) : "") +
        ((rnd(2) == 0) ? (", sourceMapURL: " + m("s")) : "") +
        ((rnd(2) == 0) ? (", sourcePolicy: " + Random.index(["'NO_SOURCE'", "'LAZY_SOURCE'", "'SAVE_SOURCE'"])) : "")
        ) : ""
      ) +
    " })");
  }  var initializedEverything = false;
  function initializeEverything(d, b)
  {
    if (initializedEverything)
      return ";";
    initializedEverything = true;    var s = "";
    for (var i = 0; i < OBJECTS_PER_TYPE; ++i) {
      s += "a" + i + " = []; ";
      s += "o" + i + " = {}; ";
      s += "s" + i + " = ''; ";
      s += "r" + i + " = /x/; ";
      s += "g" + i + " = " + makeGlobal(d, b) + "; ";
      s += "f" + i + " = function(){}; ";
      s += "m" + i + " = new WeakMap; ";
      s += "e" + i + " = new Set; ";
      s += "v" + i + " = null; ";
      s += "b" + i + " = new ArrayBuffer(64); ";
      s += "t" + i + " = new Uint8ClampedArray; ";
      
    }
    return s;
  }  
  
  
  
  function method(d, b, clazz, obj, meth, arglist)
  {
    
    if (rnd(10) == 0)
      arglist = [];    
    while (rnd(2))
      arglist.push(val(d, b));    
    switch (rnd(4)) {
      case 0:  return clazz + ".prototype." + meth + ".apply(" + obj + ", [" + arglist.join(", ") + "])";
      case 1:  return clazz + ".prototype." + meth + ".call(" + [obj].concat(arglist).join(", ") + ")";
      default: return obj + "." + meth + "(" + arglist.join(", ") + ")";
    }
  }  function severalargs(f)
  {
    var arglist = [];
    arglist.push(f());
    while (rnd(2)) {
      arglist.push(f());
    }
    return arglist;
  }  var builderStatementMakers = Random.weighted([
    
    { w: 1,  v: function(d, b) { return assign(d, b, "a", "[]"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", "new Array"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", makeIterable(d, b)); } },
    { w: 1,  v: function(d, b) { return m("a") + ".length = " + arrayIndex(d, b) + ";"; } },
    { w: 8,  v: function(d, b) { return assign(d, b, "v", m("at") + ".length"); } },
    { w: 4,  v: function(d, b) { return m("at") + "[" + arrayIndex(d, b) + "]" + " = " + val(d, b) + ";"; } },
    { w: 4,  v: function(d, b) { return val(d, b) + " = " + m("at") + "[" + arrayIndex(d, b) + "]" + ";"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", makeFunOnCallChain(d, b) + ".arguments"); } }, 
    { w: 1,  v: function(d, b) { return assign(d, b, "a", "arguments"); } },     
    { w: 3,  v: function(d, b) { return m("at") + "[" + arrayIndex(d, b) + "]" + ";"; } },
    { w: 3,  v: function(d, b) { return m("at") + "[" + arrayIndex(d, b) + "] = " + makeExpr(d, b) + ";"; } },
    { w: 1,  v: function(d, b) { return "/*ADP-1*/Object.defineProperty(" + m("a") + ", " + arrayIndex(d, b) + ", " + makePropertyDescriptor(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "/*ADP-2*/Object.defineProperty(" + m("a") + ", " + arrayIndex(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "get: " + makeEvilCallback(d,b) + ", set: " + makeEvilCallback(d, b) + " });"; } },
    { w: 1,  v: function(d, b) { return "/*ADP-3*/Object.defineProperty(" + m("a") + ", " + arrayIndex(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "writable: " + makeBoolean(d,b) + ", value: " + val(d, b) + " });"; } },    
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "push", severalargs(() => val(d, b))) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "pop", []) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "unshift", severalargs(() => val(d, b))) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "shift", []) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "reverse", []) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "sort", [makeEvilCallback(d, b)]) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "splice", [arrayIndex(d, b) - arrayIndex(d, b), arrayIndex(d, b)]) + ";"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "s", method(d, b, "Array", m("a"), "join", [m("s")])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "concat", severalargs(() => m("at")))); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "slice", [arrayIndex(d, b) - arrayIndex(d, b), arrayIndex(d, b) - arrayIndex(d, b)])); } },    
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "forEach", [makeEvilCallback(d, b)]) + ";"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "map", [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "filter", [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), "some", [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), "every", [makeEvilCallback(d, b)])); } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), Random.index(["reduce, reduceRight"]), [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), Random.index(["reduce, reduceRight"]), [makeEvilCallback(d, b), val(d, b)])); } },    
    
    
    
        
    { w: 1,  v: function(d, b) { return assign(d, b, "o", "{}"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "o", "new Object"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "o", "Object.create(" + val(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return "selectforgc(" + m("o") + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "s", "''"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "s", "new String"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "s", "new String(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "s", m("s") + ".charAt(" + arrayIndex(d, b) + ")"); } },
    { w: 5,  v: function(d, b) { return m("s") + " += 'x';"; } },
    { w: 5,  v: function(d, b) { return m("s") + " += " + m("s") + ";"; } },
        
    { w: 1,  v: function(d, b) { return assign(d, b, "m", "new Map"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "m", "new Map(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "m", "new WeakMap"); } },
    { w: 5,  v: function(d, b) { return m("m") + ".has(" + val(d, b) + ");"; } },
    { w: 4,  v: function(d, b) { return m("m") + ".get(" + val(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, null, m("m") + ".get(" + val(d, b) + ")"); } },
    { w: 5,  v: function(d, b) { return m("m") + ".set(" + val(d, b) + ", " + val(d, b) + ");"; } },
    { w: 3,  v: function(d, b) { return m("m") + ".delete(" + val(d, b) + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "e", "new Set"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "e", "new Set(" + m() + ")"); } },
    { w: 5,  v: function(d, b) { return m("e") + ".has(" + val(d, b) + ");"; } },
    { w: 5,  v: function(d, b) { return m("e") + ".add(" + val(d, b) + ");"; } },
    { w: 3,  v: function(d, b) { return m("e") + ".delete(" + val(d, b) + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "b", "new " + arrayBufferType() + "(" + bufsize() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "b", m("t") + ".buffer"); } },
    { w: 1,  v: function(d, b) { return "neuter(" + m("b") + ", " + (rnd(2) ? '"same-data"' : '"change-data"') + ");"; } },    
    
    { w: 1,  v: function(d, b) { return assign(d, b, "t", "new " + Random.index(typedArrayConstructors) + "(" + arrayIndex(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return assign(d, b, "t", "new " + Random.index(typedArrayConstructors) + "(" + m("abt") + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "t", "new " + Random.index(typedArrayConstructors) + "(" + m("b") + ", " + bufsize() + ", " + arrayIndex(d, b) + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "t", m("t") + ".subarray(" + arrayIndex(d, b) + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "t", m("t") + ".subarray(" + arrayIndex(d, b) + ", " + arrayIndex(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return m("t") + ".set(" + m("at") + ", " + arrayIndex(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m("tb") + ".byteLength"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m("t") + ".byteOffset"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m("t") + ".BYTES_PER_ELEMENT"); } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "h", "{}"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "h", forwardingHandler(d, b)); } },
    { w: 1,  v: function(d, b) { return "delete " + m("h") + "." + Random.index(handlerTraps) + ";"; } },
    { w: 4,  v: function(d, b) { return m("h") + "." + Random.index(handlerTraps) + " = " + makeEvilCallback(d, b) + ";"; } },
    { w: 4,  v: function(d, b) { return m("h") + "." + Random.index(handlerTraps) + " = " + m("f") + ";"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, null, "Proxy.create(" + m("h") + ", " + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "f", "Proxy.createFunction(" + m("h") + ", " + m("f") + ", " + m("f") + ")"); } },    
    
    
    { w: 1,  v: function(d, b) { return assign(d, b, "r", makeRegex(d, b)); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", m("r") + ".exec(" + m("s") + ")"); } },
    { w: 3,  v: function(d, b) { return makeRegexUseBlock(d, b, m("r")); } },
    { w: 3,  v: function(d, b) { return makeRegexUseBlock(d, b, m("r"), m("s")); } },
    { w: 3,  v: function(d, b) { return assign(d, b, "v", m("r") + "." + Random.index(builtinObjects["RegExp.prototype"])); } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "g", makeGlobal(d, b)); } },
    { w: 5,  v: function(d, b) { return assign(d, b, "v", m("g") + ".eval(" + strToEval(d, b) + ")"); } },
    { w: 5,  v: function(d, b) { return assign(d, b, "v", "evalcx(" + strToEval(d, b) + ", " + m("g") + ")"); } },
    { w: 5,  v: function(d, b) { return assign(d, b, "v", "evaluate(" + strToEval(d, b) + ", " + evaluateFlags(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return "(void schedulegc(" + m("g") + "));"; } },    
    { w: 3,  v: function(d, b) { return "/*MXX1*/" + assign(d, b, "o", m("g") + "." + Random.index(builtinProperties)); } },
    { w: 3,  v: function(d, b) { return "/*MXX2*/" + m("g") + "." + Random.index(builtinProperties) + " = " + m() + ";"; } },
    { w: 3,  v: function(d, b) { var prop = Random.index(builtinProperties); return "/*MXX3*/" + m("g") + "." + prop + " = " + m("g") + "." + prop + ";"; } },    
    
    { w: 1,  v: function(d, b) { return assign(d, b, "f", makeEvilCallback(d, b)); } },
    { w: 1,  v: fdecl },
    { w: 2,  v: function(d, b) { return m("f") + "(" + m() + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "i", "new Iterator(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "i", "new Iterator(" + m() + ", true)"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "i", m("ema") + "." + Random.index(["entries", "keys", "values", "iterator"])); } },
    { w: 3,  v: function(d, b) { return m("i") + ".next();"; } },
    { w: 3,  v: function(d, b) { return m("i") + ".send(" + m() + ");"; } },
        
    { w: 2,  v: function(d, b) { return assign(d, b, "v", Random.index(["4", "4.2", "NaN", "0", "-0", "Infinity", "-Infinity"])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", "new Number(" + Random.index(["4", "4.2", "NaN", "0", "-0", "Infinity", "-Infinity"]) + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", "new Number(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", makeBoolean(d, b)); } },
    { w: 2,  v: function(d, b) { return assign(d, b, "v", Random.index(["undefined", "null", "true", "false"])); } },    
    { w: 1,  v: function(d, b) { return "/*ODP-1*/Object.defineProperty(" + m() + ", " + makePropertyName(d, b) + ", " + makePropertyDescriptor(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "/*ODP-2*/Object.defineProperty(" + m() + ", " + makePropertyName(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "get: " + makeEvilCallback(d,b) + ", set: " + makeEvilCallback(d, b) + " });"; } },
    { w: 1,  v: function(d, b) { return "/*ODP-3*/Object.defineProperty(" + m() + ", " + makePropertyName(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "writable: " + makeBoolean(d,b) + ", value: " + val(d, b) + " });"; } },
    { w: 1,  v: function(d, b) { return "Object.prototype.watch.call(" + m() + ", " + makePropertyName(d, b) + ", " + makeEvilCallback(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "Object.prototype.unwatch.call(" + m() + ", " + makePropertyName(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "delete " + m() + "[" + makePropertyName(d, b) + "];"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m() + "[" + makePropertyName(d, b) + "]"); } },
    { w: 1,  v: function(d, b) { return m() + "[" + makePropertyName(d, b) + "] = " + val(d, b) + ";"; } },    
    { w: 5,  v: function(d, b) { return "print(" + m() + ");"; } },
    { w: 5,  v: function(d, b) { return "print(uneval(" + m() + "));"; } },
    { w: 5,  v: function(d, b) { return m() + ".toString = " + makeEvilCallback(d, b) + ";"; } },
    { w: 5,  v: function(d, b) { return m() + ".toSource = " + makeEvilCallback(d, b) + ";"; } },
    { w: 5,  v: function(d, b) { return m() + ".valueOf = " + makeEvilCallback(d, b) + ";"; } },
    { w: 2,  v: function(d, b) { return m() + ".__iterator__ = " + makeEvilCallback(d, b) + ";"; } },
    { w: 1,  v: function(d, b) { return m() + " = " + m() + ";"; } },
    { w: 1,  v: function(d, b) { return m() + " = " + m("g") + ".objectEmulatingUndefined();"; } },
    { w: 1,  v: function(d, b) { return m("o") + " = " + m() + ".__proto__;"; } },
    { w: 5,  v: function(d, b) { return m() + ".__proto__ = " + m() + ";"; } },
    { w: 10, v: function(d, b) { return "for (var p in " + m() + ") { " + makeBuilderStatements(d, b) + " }"; } },
    { w: 10, v: function(d, b) { return "for (var v of " + m() + ") { " + makeBuilderStatements(d, b) + " }"; } },
    { w: 10, v: function(d, b) { return m() + " + " + m() + ";"; } }, 
    { w: 10, v: function(d, b) { return m() + " + '';"; } }, 
    { w: 10, v: function(d, b) { return m("v") + " = (" + m() + " instanceof " + m() + ");"; } },
    { w: 10, v: function(d, b) { return m("v") + " = Object.prototype.isPrototypeOf.call(" + m() + ", " + m() + ");"; } },
    { w: 2,  v: function(d, b) { return "Object." + Random.index(["preventExtensions", "seal", "freeze"]) + "(" + m() + ");"; } },    
    { w: 1,  v: function(d, b) { return m() + " = x;"; } },
    { w: 1,  v: function(d, b) { return "x = " + m() + ";"; } },
    { w: 5,  v: makeStatement },    { w: 5,  v: initializeEverything },
  ]);
  makeBuilderStatement = function(d, b) {
    return (Random.index(builderStatementMakers))(d - 1, b);
  };
})();
function infrequentCondition(v, n)
{
  switch (rnd(20)) {
    case 0: return true;
    case 1: return false;
    case 2: return v + " > " + rnd(n);
    default: var mod = rnd(n) + 2; var target = rnd(mod); return "/*ICCD*/" + v + " % " + mod + (rnd(8) ? " == " : " != ") + target;
  }
}var arrayBufferType = "SharedArrayBuffer" in this ?
  function() { return rnd(2) ? "SharedArrayBuffer" : "ArrayBuffer"; } :
  function() { return "ArrayBuffer"; };/***************************
 * TEST ASM.JS CORRECTNESS *
 ***************************/
var compareAsm = (function() {  function isSameNumber(a, b)
  {
    if (!(typeof a == "number" && typeof b == "number"))
      return false;    
    if (a === 0 && b === 0)
      return 1/a === 1/b;    
    return a === b || (a !== a && b !== b);
  }  var asmvals = [
    1, Math.PI, 42,
    
    0, -0, 0/0, 1/0, -1/0,
    
     0x07fffffff,  0x080000000,  0x080000001,
    -0x07fffffff, -0x080000000, -0x080000001,
     0x0ffffffff,  0x100000000,  0x100000001,
    -0x0ffffffff, -0x100000000,  0x100000001,
    
    Number.MIN_VALUE, -Number.MIN_VALUE,
    Number.MAX_VALUE, -Number.MAX_VALUE,
  ];
  var asmvalsLen = asmvals.length;  function compareUnaryFunctions(f, g)
  {
    for (var i = 0; i < asmvalsLen; ++i) {
      var x = asmvals[i];
      var fr = f(x);
      var gr = g(x);
      if (!isSameNumber(fr, gr)) {
        foundABug("asm mismatch", "(" + uneval(x) + ") -> " + uneval(fr) + " vs "  + uneval(gr));
      }
    }
  }  function compareBinaryFunctions(f, g)
  {
    for (var i = 0; i < asmvalsLen; ++i) {
      var x = asmvals[i];
      for (var j = 0; j < asmvalsLen; ++j) {
        var y = asmvals[j];
        var fr = f(x, y);
        var gr = g(x, y);
        if (!isSameNumber(fr, gr)) {
          foundABug("asm mismatch", "(" + uneval(x) + ", " + uneval(y) + ") -> " + uneval(fr) + " vs "  + uneval(gr));
        }
      }
    }
  }  return {compareUnaryFunctions: compareUnaryFunctions, compareBinaryFunctions: compareBinaryFunctions};
})();function nanBitsMayBeVisible(s)
{
  
  return (s.indexOf("Uint") != -1 || s.indexOf("Int") != -1) + (s.indexOf("Float32Array") != -1) + (s.indexOf("Float64Array") != -1) > 1;
}var pureForeign = {
  identity:  function(x) { return x; },
  quadruple: function(x) { return x * 4; },
  half:      function(x) { return x / 2; },
  
  asString:  function(x) { return uneval(x); },
  asValueOf: function(x) { return { valueOf: function() { return x; } }; },
  
  sum:       function()  { var s = 0; for (var i = 0; i < arguments.length; ++i) s += arguments[i]; return s; },
  
  stomp:     function()  { },
};for (var f in unaryMathFunctions) {
  pureForeign["Math_" + unaryMathFunctions[f]] = Math[unaryMathFunctions[f]];
}for (var f in binaryMathFunctions) {
  pureForeign["Math_" + binaryMathFunctions[f]] = Math[binaryMathFunctions[f]];
}var pureMathNames = Object.keys(pureForeign);function generateAsmDifferential()
{
  var foreignFunctions = rnd(10) ? [] : pureMathNames;
  return asmJSInterior(foreignFunctions, true);
}function testAsmDifferential(stdlib, interior)
{
  if (nanBitsMayBeVisible(interior)) {
    dumpln("Skipping correctness test for asm module that could expose low bits of NaN");
    return;
  }  var asmJs = "(function(stdlib, foreign, heap) { 'use asm'; " + interior + " })";
  var asmModule = eval(asmJs);  if (isAsmJSModule(asmModule)) {
    var asmHeap = new ArrayBuffer(4096);
    (new Int32Array(asmHeap))[0] = 0x12345678;
    var asmFun = asmModule(stdlib, pureForeign, asmHeap);    var normalHeap = new ArrayBuffer(4096);
    (new Int32Array(normalHeap))[0] = 0x12345678;
    var normalJs = "(function(stdlib, foreign, heap) { " + interior + " })";
    var normalModule = eval(normalJs);
    var normalFun = normalModule(stdlib, pureForeign, normalHeap);    compareAsm.compareBinaryFunctions(asmFun, normalFun);
  }
}
function startAsmDifferential()
{
  var asmFuzzSeed = 223617089; //Math.floor(Math.random() * Math.pow(2,28));
 // dumpln("asmFuzzSeed: " + asmFuzzSeed);
  Random.init(asmFuzzSeed);  while (true) {    var stompStr = makeRegisterStompFunction(8, [], true);
    print(stompStr);
    pureForeign.stomp = eval(stompStr);    for (var i = 0; i < 100; ++i) {
      var interior = generateAsmDifferential();
      print(interior);
      testAsmDifferential(this, interior);
    }
    gc();
  }
}var numericVals = [
  "1", "Math.PI", "42",
  
  "0", "-0", "0/0", "1/0", "-1/0",
  
   "0x07fffffff",  "0x080000000",  "0x080000001",
  "-0x07fffffff", "-0x080000000", "-0x080000001",
   "0x0ffffffff",  "0x100000000",  "0x100000001",
  "-0x0ffffffff", "-0x100000000",  "0x100000001",
  
  "Number.MIN_VALUE", "-Number.MIN_VALUE",
  "Number.MAX_VALUE", "-Number.MAX_VALUE",
];var confusableVals = [
  "0",
  "0.1",
  "-0",
  "''",
  "'0'",
  "'\\0'",
  "[]",
  "[0]",
  "/0/",
  "'/0/'",
  "1",
  "({toString:function(){return '0';}})",
  "({valueOf:function(){return 0;}})",
  "({valueOf:function(){return '0';}})",
  "false",
  "true",
  "undefined",
  "null",
  "(function(){return 0;})",
  "NaN",
  "(new Boolean(false))",
  "(new Boolean(true))",
  "(new String(''))",
  "(new Number(0))",
  "(new Number(-0))",
  "objectEmulatingUndefined()",
];function hashStr(s)
{
  var hash = 0;
  var L = s.length;
  for (var i = 0; i < L; i++) {
    var c = s.charCodeAt(i);
    hash = (Math.imul(hash, 31) + c) | 0;
  }
  return hash;
}function testMathyFunction(f, inputs)
{
  var results = [];
  if (f) {
    for (var j = 0; j < inputs.length; ++j) {
      for (var k = 0; k < inputs.length; ++k) {
        try {
          results.push(f(inputs[j], inputs[k]));
        } catch(e) {
          results.push(errorToString(e));
        }
      }
    }
  }
  /* Use uneval to distinguish -0, 0, "0", etc. */
  /* Use hashStr to shorten the output and keep compareJIT files small. */
  print(hashStr(uneval(results)));
}function mathInitFCM()
{
  
  var cookie = "/*F" + "CM*/";  print(cookie + hashStr.toString().replace(/\n/g, " "));
  print(cookie + testMathyFunction.toString().replace(/\n/g, " "));
}function makeMathyFunAndTest(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var i = rnd(NUM_MATH_FUNCTIONS);
  var s = "";  if (rnd(5)) {
    if (rnd(8)) {
      s += "mathy" + i + " = " + makeMathFunction(6, b, i) + "; ";
    } else {
      s += "mathy" + i + " = " + makeAsmJSFunction(6, b) + "; ";
    }
  }  if (rnd(5)) {
    var inputsStr;
    switch(rnd(8)) {
      case 0:  inputsStr = makeMixedTypeArray(d - 1, b); break;
      case 1:  inputsStr = "[" + Random.shuffled(confusableVals).join(", ") + "]"; break;
      default: inputsStr = "[" + Random.shuffled(numericVals).join(", ") + "]"; break;
    }    s += "testMathyFunction(mathy" + i + ", " + inputsStr + "); ";
  }  return s;
}function makeMathyFunRef(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return "mathy" + rnd(NUM_MATH_FUNCTIONS);
}/*******************************
 * EXECUTION CONSISTENCY TESTS *
 *******************************/function sandboxResult(code, zone)
{
  
  var result;
  var resultStr = "";
  try {
    
    
    var sandbox = newGlobal({sameZoneAs: zone});    result = evalcx(code, sandbox);
    if (typeof result != "object") {
      
      resultStr = "" + result;
    }
  } catch(e) {
    result = "Error: " + errorToString(e);
  }
  
  return resultStr;
}function nestingConsistencyTest(code)
{
  
  
  function nestExpr(e) { return "(function() { return " + code + "; })()"; }
  var codeNestedOnce = nestExpr(code);
  var codeNestedDeep = code;
  var depth = (count % 7) + 14; 
  for (var i = 0; i < depth; ++i) {
    codeNestedDeep = nestExpr(codeNestedDeep);
  }  
  var resultO = sandboxResult(codeNestedOnce, null); var resultD = sandboxResult(codeNestedDeep, null);  
    if (resultO != resultD) {
    foundABug("NestTest mismatch",
      "resultO: " + resultO + "\n" +
      "resultD: " + resultD);
  }
}
function optionalTests(f, code, wtt)
{
  if (count % 100 == 1) {
    tryHalves(code);
  }  if (count % 100 == 2 && engine == ENGINE_SPIDERMONKEY_TRUNK) {
    try {
      Reflect.parse(code);
    } catch(e) {
    }
  }  if (count % 100 == 3 && f && typeof disassemble == "function") {
    
    
    disassemble("-r", f);
  }  if (0 && f && wtt.allowExec && engine == ENGINE_SPIDERMONKEY_TRUNK) {
    simpleDVGTest(code);
    tryEnsureSanity();
  }  if (count % 100 == 6 && f && wtt.allowExec && wtt.expectConsistentOutput && wtt.expectConsistentOutputAcrossIter
    && engine == ENGINE_SPIDERMONKEY_TRUNK && getBuildConfiguration()['more-deterministic']) {
    nestingConsistencyTest(code);
  }
}
function simpleDVGTest(code)
{
  var fullCode = "(function() { try { \n" + code + "\n; throw 1; } catch(exx) { this.nnn.nnn } })()";  try {
    eval(fullCode);
  } catch(e) {
    if (e.message != "this.nnn is undefined" && e.message.indexOf("redeclaration of") == -1) {
      
      foundABug("Wrong error " + "message", e);
    }
  }
}
function tryHalves(code)
{
      var f, firstHalf, secondHalf;  try {    firstHalf = code.substr(0, code.length / 2);
    if (verbose)
      dumpln("First half: " + firstHalf);
    f = new Function(firstHalf);
    void ("" + f);
  }
  catch(e) {
    if (verbose)
      dumpln("First half compilation error: " + e);
  }  try {
    secondHalf = code.substr(code.length / 2, code.length);
    if (verbose)
      dumpln("Second half: " + secondHalf);
    f = new Function(secondHalf);
    void ("" + f);
  }
  catch(e) {
    if (verbose)
      dumpln("Second half compilation error: " + e);
  }
}/*****************
 * USING REGEXPS *
 *****************/function randomRegexFlags() {
  var s = "";
  if (rnd(2))
    s += "g";
  if (rnd(2))
    s += "y";
  if (rnd(2))
    s += "i";
  if (rnd(2))
    s += "m";
  return s;
}function toRegexSource(rexpat)
{
  return (rnd(2) === 0 && rexpat.charAt(0) != "*") ?
    "/" + rexpat + "/" + randomRegexFlags() :
    "new RegExp(" + simpleSource(rexpat) + ", " + simpleSource(randomRegexFlags()) + ")";
}function makeRegexUseBlock(d, b, rexExpr, strExpr)
{
  var rexpair = regexPattern(10, false);
  var rexpat = rexpair[0];
  var str = rexpair[1][rnd(POTENTIAL_MATCHES)];  if (!rexExpr) rexExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : toRegexSource(rexpat);
  if (!strExpr) strExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : simpleSource(str);  var bv = b.concat(["s", "r"]);  return ("/*RXUB*/var r = " + rexExpr + "; " +
          "var s = " + strExpr + "; " +
          "print(" +
            Random.index([
              "r.exec(s)",
              "uneval(r.exec(s))",
              "r.test(s)",
              "s.match(r)",
              "uneval(s.match(r))",
              "s.search(r)",
              "s.replace(r, " + makeReplacement(d, bv) + (rnd(3) ? "" : ", " + simpleSource(randomRegexFlags())) + ")",
              "s.split(r)"
            ]) +
          "); " +
          (rnd(3) ? "" : "print(r.lastIndex); ")
          );
}function makeRegexUseExpr(d, b)
{
  var rexpair = regexPattern(8, false);
  var rexpat = rexpair[0];
  var str = rexpair[1][rnd(POTENTIAL_MATCHES)];  var rexExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : toRegexSource(rexpat);
  var strExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : simpleSource(str);  return "/*RXUE*/" + rexExpr + ".exec(" + strExpr + ")";
}function makeRegex(d, b)
{
  var rexpair = regexPattern(8, false);
  var rexpat = rexpair[0];
  var rexExpr = toRegexSource(rexpat);
  return rexExpr;
}function makeReplacement(d, b)
{
  switch(rnd(3)) {
    case 0:  return Random.index(["''", "'x'", "'\\u0341'"]);
    case 1:  return makeExpr(d, b);
    default: return makeFunction(d, b);
  }
}function start(glob)
{
  var fuzzSeed = 223617089;//Math.floor(Math.random() * Math.pow(2,28));
  dumpln("fuzzSeed: " + fuzzSeed);
  Random.init(fuzzSeed);  
  
  
  var cookie = "/*F";
  cookie += "RC*/";  
  var dumpEachSeed = false;  if (dumpEachSeed) {
    dumpln(cookie + "Random.init(0);");
  }  mathInitFCM();  count = 0;  if (jsshell) {
    
    var MAX_TOTAL_TIME = (glob.maxRunTime) || (Infinity);
    var startTime = new Date();
    var lastTime;    do {
      testOne();
      var elapsed1 = new Date() - lastTime;
      if (elapsed1 > 1000) {
        print("That took " + elapsed1 + "ms!");
      }
      lastTime = new Date();
    } while(lastTime - startTime < MAX_TOTAL_TIME);
  } else {
    setTimeout(testStuffForAWhile, 200);
  }  function testStuffForAWhile()
  {
    for (var j = 0; j < 100; ++j)
      testOne();    if (count % 10000 < 100)
      printImportant("Iterations: " + count);    setTimeout(testStuffForAWhile, 30);
  }  function testOne()
  {
    ++count;    
    
    var depth = 14;    if (dumpEachSeed) {
      
      var MTA = uneval(Random.twister.export_mta());
      var MTI = Random.twister.export_mti();
      if (MTA != Random.lastDumpedMTA) {
        dumpln(cookie + "Random.twister.import_mta(" + MTA + ");");
        Random.lastDumpedMTA = MTA;
      }
      dumpln(cookie + "Random.twister.import_mti(" + MTI + "); void (makeScript(" + depth + "));");
    }    var code = makeScript(depth);    if (count == 1 && engine == ENGINE_SPIDERMONKEY_TRUNK && rnd(5)) {
      code = "tryRunning = useSpidermonkeyShellSandbox(" + rnd(4) + ");";
      
    }  
  
  
  
  
    dumpln(cookie + "count=" + count + "; tryItOut(" + uneval(code) + ");");    tryItOut(code);
  }
}
function failsToCompileInTry(code) {
  
  try {
    var codeInTry = "try { " + code + " } catch(e) { }";
    void new Function(codeInTry);
    return false;
  } catch(e) {
    return true;
  }
}/*********************
 * SANDBOXED RUNNING *
 *********************/var tryRunning = xpcshell ? useGeckoSandbox() : tryRunningDirectly;
function fillShellSandbox(sandbox)
{
  var safeFuns = [
    "print",
    "schedulegc", "selectforgc", "gczeal", "gc", "gcslice",
    "verifyprebarriers", "gcPreserveCode",
    "minorgc", "abortgc",
    "evalcx", "newGlobal", "evaluate",
    "dumpln", "fillShellSandbox",
    "testMathyFunction", "hashStr",
    "isAsmJSCompilationAvailable",
  ];  for (var i = 0; i < safeFuns.length; ++i) {
    var fn = safeFuns[i];
    if (sandbox[fn]) {
      
    } else if (this[fn]) { 
      sandbox[fn] = this[fn].bind(this);
    } else {
      
    }
  }  return sandbox;
}function useSpidermonkeyShellSandbox(sandboxType)
{
  var primarySandbox;  switch (sandboxType) {
    case 0:  primarySandbox = evalcx('');
    case 1:  primarySandbox = evalcx('lazy');
    case 2:  primarySandbox = newGlobal({sameZoneAs: {}}); 
    default: primarySandbox = newGlobal(); 
  }  fillShellSandbox(primarySandbox);  return function(f, code, wtt) {
    try {
      evalcx(code, primarySandbox);
    } catch(e) {
      dumpln("Running in sandbox threw " + errorToString(e));
    }
  };
}
function newGeckoSandbox(n)
{
  var t = (typeof n == "number") ? n : 1;
  var s = Components.utils.Sandbox("http://x" + t + ".example.com/");  
  s.newGeckoSandbox = newGeckoSandbox;
  s.evalInSandbox = function(str, sbx) {
    return Components.utils.evalInSandbox(str, sbx);
  };
  s.print = function(str) { print(str); };  return s;
}function useGeckoSandbox() {
  var primarySandbox = newGeckoSandbox(0);  return function(f, code, wtt) {
    try {
      Components.utils.evalInSandbox(code, primarySandbox);
    } catch(e) {
      
    }
  };
}
/***********************
 * UNSANDBOXED RUNNING *
 ***********************/function directEvalC(s) { var c; /* evil closureizer */ return eval(s); } function newFun(s) { return new Function(s); }function tryRunningDirectly(f, code, wtt)
{
  if (count % 23 == 3) {
    dumpln("Plain eval!");
    try { eval(code); } catch(e) { }
    tryEnsureSanity();
    return;
  }  if (count % 23 == 4) {
    dumpln("About to recompile, using eval hack.");
    f = directEvalC("(function(){" + code + "});");
  }  try {
    if (verbose)
      dumpln("About to run it!");
    var rv = f();
    if (verbose)
      dumpln("It ran!");
    if (wtt.allowIter && rv && typeof rv == "object") {
      tryIteration(rv);
    }
  } catch(runError) {
    if(verbose)
      dumpln("Running threw!  About to toString to error.");
    var err = errorToString(runError);
    dumpln("Running threw: " + err);
  }  tryEnsureSanity();
}var realEval = eval;
var realMath = Math;
var realFunction = Function;
var realGC = gc;
var realUneval = uneval;
var realToString = toString;
var realToSource = this.toSource; 
function tryEnsureSanity()
{
  
  
  try {
    if (typeof resetOOMFailure == "function")
      resetOOMFailure();
  } catch(e) { }  try {
    
    
    if (typeof gczeal == "function")
      gczeal(0);
  } catch(e) { }  
  try { eval(""); } catch(e) { dumpln("That really shouldn't have thrown: " + errorToString(e)); }  if (!this) {
    
    return;
  }  try {
    
    delete this.unwatch;    
    if ('unwatch' in this) {
      this.unwatch("eval");
      this.unwatch("Function");
      this.unwatch("gc");
      this.unwatch("uneval");
      this.unwatch("toSource");
      this.unwatch("toString");
    }    if ('__defineSetter__' in this) {
      
      if (!jsStrictMode)
        delete this.eval;
      delete this.Math;
      delete this.Function;
      delete this.gc;
      delete this.uneval;
      delete this.toSource;
      delete this.toString;
    }    this.Math = realMath;
    this.eval = realEval;
    this.Function = realFunction;
    this.gc = realGC;
    this.uneval = realUneval;
    this.toSource = realToSource;
    this.toString = realToString;
  } catch(e) {
    confused("tryEnsureSanity failed: " + errorToString(e));
  }  
  if (this.eval != realEval)
    confused("Fuzz script replaced |eval|");
  if (Function != realFunction)
    confused("Fuzz script replaced |Function|");
}function tryIteration(rv)
{
  try {
    if (Iterator(rv) !== rv)
      return; 
  }
  catch(e) {
    
    dumpln("Error while trying to determine whether it's an iterator!");
    dumpln("The error was: " + e);
    return;
  }  dumpln("It's an iterator!");
  try {
    var iterCount = 0;
    for (var iterValue of rv)
      ++iterCount;
    dumpln("Iterating succeeded, iterCount == " + iterCount);
  } catch (iterError) {
    dumpln("Iterating threw!");
    dumpln("Iterating threw: " + errorToString(iterError));
  }
}function tryItOut(code)
{
  
  if (typeof gczeal == "function")
    gczeal(0);  
  if (count % 1000 == 0) {
    dumpln("Paranoid GC (count=" + count + ")!");
    realGC();
  }  var wtt = whatToTest(code);  if (!wtt.allowParse)
    return;  code = code.replace(/\/\*DUPTRY\d+\*\//, function(k) { var n = parseInt(k.substr(8), 10); dumpln(n); return strTimes("try{}catch(e){}", n); });

  if (jsStrictMode)
    code = "'use strict'; " + code;   var f;
  try {
    f = new Function(code);
  } catch(compileError) {
    dumpln("Compiling threw: " + errorToString(compileError));
  }  if (f && wtt.allowExec && wtt.expectConsistentOutput && wtt.expectConsistentOutputAcrossJITs) {
    if (code.indexOf("\n") == -1 && code.indexOf("\r") == -1 && code.indexOf("\f") == -1 && code.indexOf("\0") == -1 &&
        code.indexOf("\u2028") == -1 && code.indexOf("\u2029") == -1 &&
        code.indexOf("<--") == -1 && code.indexOf("-->") == -1 && code.indexOf("//") == -1) {
      
      var cookie1 = "/*F";
      var cookie2 = "CM*/";
      var nCode = code;
      
      
      
      
      if (nCode.indexOf("return") != -1 || nCode.indexOf("yield") != -1 || nCode.indexOf("const") != -1 || failsToCompileInTry(nCode))
        nCode = "(function(){" + nCode + "})()";
      dumpln(cookie1 + cookie2 + " try { " + nCode + " } catch(e) { }");
    }
  }  if (tryRunning != tryRunningDirectly) {
    optionalTests(f, code, wtt);
  }  if (wtt.allowExec && f) {
    tryRunning(f, code, wtt);
  }  if (verbose)
    dumpln("Done trying out that function!");  dumpln("");
}
var count = 0;
var verbose = false;

/*FRC*/Random.init(0);
/*FCM*/function hashStr(s) {   var hash = 0;   var L = s.length;   for (var i = 0; i < L; i++) {     var c = s.charCodeAt(i);     hash = (Math.imul(hash, 31) + c) | 0;   }   return hash; }
/*FCM*/function testMathyFunction(f, inputs) {   var results = [];   if (f) {     for (var j = 0; j < inputs.length; ++j) {       for (var k = 0; k < inputs.length; ++k) {         try {           results.push(f(inputs[j], inputs[k]));         } catch(e) {           results.push(errorToString(e));         }       }     }   }   /* Use uneval to distinguish -0, 0, "0", etc. */   /* Use hashStr to shorten the output and keep compareJIT files small. */   print(hashStr(uneval(results))); }
/*FRC*/Random.twister.import_mta(223617089,-1791327578,-226799946,716696172,1073170592,248334117,1074978463,518414941,1746113465,869187489,1048953743,-313086346,667054389,851379958,953247004,226287643,-1427120713,976967034,-2005073100,-1635505567,831042595,1682623716,-814980241,518784435,772803255,1091643724,2012905595,1609300541,1218958792,538896746,1359073520,1361012788,94075401,-1931151698,1829461502,1086491838,390905471,213000000,801084518,1942626917,-69003876,-1836933404,349947624,679453107,935892683,509813060,-1564113918,-2020535249,-1455158543,39410960,192890754,1930020989,1787458848,1094049594,-1923832451,695157330,1268845714,1648992568,-1562174281,-219533148,-218132193,1799371849,-1231925082,-1185049357,-180896683,18961455,1769758157,-858313281,-2004703376,1933972031,-1575329604,-547366595,-2067471426,1236366709,822766350,-1043809583,-1813375194,1941529985,-1510569010,1302942667,-1003804414,150976182,748977184,-2009982733,-441200535,1163916327,1838000468,-2049618976,1576067714,1859549448,-1667067417,1702501556,-2021838651,-1125138976,1617026184,962614124,127514108,-1947424563,-866230003,-1299265303,2118649883,-1888019289,-1126851969,-983705416,-400583377,528377541,-46073565,-2856437,-507241068,-1990820864,-1282801864,563985489,-12999323,420206511,-236863619,-1577256151,1298537323,-1512404153,1319362479,1058889245,1824433897,1591869953,1883032186,1035253250,-541007546,-997601866,1164379623,-1256756675,1976672859,336410627,-934955855,1511099581,375464624,45277173,1176467759,981888429,58055369,924050134,-619248392,-929281390,-7863103,-1803308265,-731978537,1135721523,271843914,-2117828157,1413380791,-817115039,1713088830,1261796720,1716713259,1059520041,126171077,-456495534,-920789105,-2109792553,-566614107,-374113509,-1101567722,792996227,-2035254193,2017542146,1628757201,1091989171,-839586082,427918038,989275412,-102410869,150505296,-39374023,1811366028,703786316,451496872,1763688949,-1241572878,1209445471,-238923834,-1464015254,-693334086,84784560,-1938563292,-1909694285,672653195,1490654606,-372602589,-534103463,-1705430980,431175473,982843409,105455730,-1739272264,-1565098207,436135055,1036629036,-818699746,199981876,121794632,-582691539,1585428972,-1268830136,-1536448518,-1289421407,751389977,224185512,1740285716,1033971990,-148112260,-1980525078,-1045738152,-1770506056,-1193284556,54204449,2065772249,-1106177011,14807489,1271638780,1321655209,1637454369,799655802,-1777205763,1543482743,-1511156117,85559627,312036982,1320360814,2053192364,-411190237,1126717827,1633674030,-978204304,706217541,-1095211232,400548690,188322371,-2133749671,1332455378,-1928453589,1912237082,1415846549,130265427,-1486921297,-1147003086,-470352158,50329784,-1742759540,143037435,1378268669,1787668835,-751352158,-1006499970,1530518091,598391341,-2093446723,1597935704,-1923246821,2053453020,558047537,-1600761258,2108256294,-974184602,-2031652643,1053810688,652435718,902528613,816835553,-1177912882,212089478,29806057,83881721,-2069132726,1285953398,-128519678,-1948842891,-1871088892,-1415407504,-36100083,1568558234,-166712004,-1924034063,-370237194,-1040474431,1602844067,-795010044,439144158,-1636537166,183046797,113035199,-1181153670,-350370184,55845544,693474666,-375411211,701647154,562078687,-1634992351,918185206,-498369482,1857249042,1210756777,-152645261,-382365092,-1039099992,-1151116635,138880018,-354623926,-1139292930,-1599105890,1007754943,1198414223,-1755818949,1417329843,1145419121,1940489832,1403992486,-779280611,-1272556015,-172678725,1804191445,143582946,-2111960471,-698720137,-2106449147,1962381829,1357693143,779393970,355577983,1535613537,1723681063,-589483194,110635138,-79458668,-485027362,-1447800195,1237550184,-1495371845,-107276724,1766397307,-1263942541,741472999,2135858550,-829829049,-1632661463,-1533549235,-758267774,-155648707,1798576335,-1032451936,-475683670,1108830473,-643188347,1323886908,-480203920,-1526124353,417358066,-1559903524,1654698233,1591905084,915379574,1004281588,857000875,-35660065,-543512011,1821773496,-1742483096,-1558619586,-1309755623,1491644949,-374933677,208233472,135820657,714526727,654627638,-2006369342,-994159563,-1885200188,-605362795,128179110,-1111785481,237410851,950832202,-1054018386,-228057410,-290306289,-1783663301,881050109,1152839506,-1853564863,-1359335694,1952642612,-129990290,-55482745,527832987,-1518975825,1864675018,-426730847,-331631243,-437993702,-483211414,-1885413637,-741328180,-263652293,1632467881,475443930,1877031829,-1110788360,-709100489,-1030859238,-722838924,404775307,667345008,-2103280182,1340320131,-719948826,-584824842,-41582009,-1203844493,-2144118475,-1283349676,-236423024,692272802,1383754126,1135750672,2120894299,-1416408535,-347770977,-664566219,361814776,-1541595773,-1899123055,865569964,-574190198,1809000892,1808834113,-2118209295,-1751982959,1895871154,1540181331,-878811889,-320517262,-403882420,2132467171,-276464157,-517502182,1471759256,645107225,1901163162,-776721435,1658677629,-1322124372,-232101017,1576068150,1806465654,1440154039,-1044900717,1083256470,626471514,-1110505142,1335767857,-1189157958,1796559203,967085942,-2098413221,810543851,1689023366,512611603,-863945392,-1978425711,1402944722,-484119533,-1806322651,-1001786311,712402617,-121730603,667543879,359729629,1961569036,-1540558083,213866360,1905572918,-1041714542,374672917,-1834300118,-1052419414,612382608,1229061556,-2084440242,-1678623006,1649979463,-1656945786,2022705405,881224022,-792684839,-2069090322,1560819209,-211838186,1212771896,-528220307,-1681414569,-1239736709,1028704432,689266532,1899440233,708483838,1795364397,172576084,-694585315,-1129942064,1147475413,492573344,-575997155,2057970388,1100397832,-2099157107,1816290412,-118819325,-1403449341,-2068128919,-2129537476,2070066812,990242392,-570361152,1005210616,-1176522014,1880847467,-754472482,1022905150,619437956,-1740057309,-827211499,1007678911,-1995952787,-2104273442,-2045272608,872234559,1358055409,-811215929,622621292,-1905724747,810333005,2102523004,-1198039955,792191208,-1900026458,2065063891,-1076284934,-365530887,415653572,911624567,-744706793,-2130968823,1547011197,-194534637,412542840,1773177985,89649322,2015555389,-227311400,1636043668,1348358391,759404861,-178774975,-1867482565,-359154769,1929386255,64250554,1454800791,-1520329116,-636348811,476185798,1352915543,-1059640280,-1800113614,-1684226260,-378991261,742041886,527943957,-529427319,-1659668813,1309249303,418528241,-918773415,951768263,587559881,-1298382444,702097526,-1668407593,-2040190637,1983686720,566242545,259372642,1824090360,153267596,-127768948,-912392260,-1418977363,812001630,-1912364438,1244708189,1477768098,1679514790,535949115,-2112424032,-1157404860,-175753479,-1439335170,-2115949111,-1545226635,-913854894,252191061,224306666,780644788,-980520345,2099685336,855792642,-1086758608,-419095263,92910290,1539567939,-2127002764,-1713371655,-1502432909,-1840481022,303190894,-1612526891);
/*FRC*/Random.twister.import_mti(624); void (makeScript(14));
/*FRC*/count=1; tryItOut("mathy4 = (function(x, y) { return ( + Math.max((Math.hypot(( + ( - ( + ((( + ( ! ( + -0x07fffffff))) ? (( ! (x === y)) | 0) : (( ! x) >>> 0)) | 0)))), ( + Math.atan2(( ~ (y >>> 0)), Math.hypot((0/0 % x), Math.fround(( + ((Math.PI | 0) / (Math.atan2(x, y) | 0)))))))) | 0), ( + (Math.trunc(Math.expm1(( + mathy1(Math.fround(Math.atan2(y, ( + ((x >>> 0) ^ x)))), (y | 0))))) >>> 0)))); }); testMathyFunction(mathy4, [0x100000001, -Number.MIN_VALUE, -Number.MAX_VALUE, 0x0ffffffff, 0x080000000, 1, 0x080000001, 1/0, -0, 0, Number.MIN_VALUE, 0x100000001, -0x07fffffff, 0x07fffffff, Number.MAX_VALUE, -0x080000001, 0/0, 42, 0x100000000, -1/0, Math.PI, -0x080000000, -0x100000000, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mta(-374372807,-157058656,-2037657606,-273459093,-14456604,-1520997046,-107300252,281792507,1431573304,1153697538,-499053233,-758519346,1050239755,-1630875836,-799708847,1500065250,-2143687349,-105184291,1853124508,1107276795,-2119908058,1331100152,-12743516,-595928054,1664793270,-593512519,493756392,-820607621,-932384128,1024471680,-1936545383,352887626,904263675,-1421663371,1269985251,-109153887,-2014855343,-2142431582,-772992161,1715259293,-2099303811,-1500993530,1792695882,-34199975,-525013695,-263894757,-1921418928,-338084930,813554706,-737441756,-1034863204,-2072723140,-760183558,-1034811817,1058790239,1879541758,-258161649,-924315630,1545742856,1572368666,-1556701750,-1571304471,-1363989563,-633871997,1534385043,-1644596014,-607169146,1523353259,740983952,-1692487985,-1523031917,-1589207604,1770372672,-590560834,-1818588402,-1320451514,-954340520,126503994,-1959316938,-2043058564,1220578339,1741062694,1559825972,-41658626,1762494438,-142373376,644518496,666471669,-1263875126,212584142,283491869,126561083,652727821,1152812818,-865026193,-2023688944,-1040788816,209197903,-2012824941,112151487,91527387,1903780763,1610491116,-1005443796,-1484739628,-1919789392,-1914596361,2058044318,-1842199011,-446526388,-1918665950,-1144491827,136814613,-615363147,-2006945725,2103106279,-408448752,112437515,719261650,736966850,929589219,1132254017,635419993,-236942749,1504619811,1113882830,-208113238,820496428,-1342806048,-1715358461,1816699810,-981381043,-1537332582,856629541,114873303,514179163,678743892,2105132429,-1410599282,-1009729325,1562483681,-1016368647,-2055103814,-1332912824,-1227026218,2108188706,-977598660,-858462875,-810758591,-1293445746,-1328707908,1230407210,-1298216928,-1582048411,745577639,-293387147,-2073984557,1518093345,-1232581853,1747127840,497331093,-102986176,-1799348549,-744330450,-596591792,-135517915,-688258283,1202200850,-244492588,-795197918,-823435053,286695698,-47936910,-634871599,1773638850,-1552049969,-1120436650,1198321347,1576080333,-431457509,1124988469,-2096443379,882831670,1691440407,-777553612,1848241111,1733126867,-1382344543,-1616212242,-1974514033,-1100011761,-197661079,294743156,1260435959,1289162774,-71082328,2117543413,-1001143461,709472634,-600411753,-1968540846,-1753684495,1656044274,741129393,-1664720085,-2137613958,-1317012468,-891233710,-891473515,-7716753,286429853,-1416624410,-1956733133,-134219381,-529815783,-1018332461,-1698290227,-1460829555,1963283200,-243346250,-801273175,1522333454,-1867734334,-2127872828,-1350770604,-1197195872,1736333003,-654280786,-730096360,1250917383,-252744709,-1261659827,969086132,1627046551,2004753426,-891571470,1010381071,1367060698,1210089912,-1270979837,-1021591331,-1582426592,404148670,-1942609523,619772671,-563116611,-307112043,-1472240009,760740423,195678558,1420243395,-72462665,-1291780203,-2100795974,-1306255595,1103483591,760945579,-230289014,939470073,-274792630,-198913163,1489231712,2056486476,112786046,-1666700731,-1749086692,-2682442,430468574,-1528992477,210327025,-1042456744,1012391844,-1199968103,-660064920,205332327,1589836383,-284975430,502351291,-259813049,726006597,882773081,391468381,1024581777,-5836202,345254283,-965412600,1098183207,-692551946,-469902659,-1172709008,2012252070,262012682,338793954,1300372169,26326224,487537291,-330890938,405112600,54347178,488601454,-1111192982,1461950083,-177729457,-227310467,1501670981,-614401927,1094277628,-226553797,-178120476,-1345527630,1185823897,1356416210,-564915501,-1750815439,-459139294,1467542472,-530082437,346213740,-1618174256,-725461271,-1668864433,788776626,907945380,-691232919,-1612155985,1020118908,-1392943117,723124600,842364890,1650451366,-1248219709,1783771701,-378301308,126227701,107399352,2141092991,1715396266,1119041166,-2073084298,-1234437911,218969470,1126380090,339491494,99835729,-366930509,199494530,1514138263,-815045704,-157237412,1118554567,-1068441637,-1843231325,236236983,-501575484,-658562929,-2138627458,-2105114696,1906748632,1157858631,62485802,-976567072,1888736395,313796847,2046321227,-1132056866,1586962267,1846217637,454371809,1584397214,163725926,-1559284525,-1293316809,-2030046489,-2106976418,942221168,-1937955950,892508842,1859550066,1426112527,-1844923785,-662186950,-1038020609,1029459511,1193857522,2015835016,658675676,1063131481,1737871503,-973287689,1938824487,85053500,1472408024,-2139193792,2092629658,-1463989385,-2086729383,-1593614953,271368049,2029960308,470303920,864464346,1738329519,226866650,-1546509014,-1262903289,1018575040,-1942137311,-1776978385,-1863737291,902811603,-1708642039,-80985913,12306476,-2138629329,1754058055,1186697899,-745562331,-962913465,-1600753352,950818995,1794748159,-353729692,1996638051,-1835195675,829075614,1619123206,1462783881,1422136517,-827120729,1280736311,1506093167,807836884,423719389,1673405083,-1302297845,2117281763,1129169463,1734358820,-664364608,1843085597,1496709029,-1862770028,-1466836193,284643870,-1874510912,-992479699,421056727,-928680065,-1163824542,-27995943,-1258487297,480235600,24151862,121028992,-877924733,-895739459,-1270295232,-329246170,1481539875,621892367,-125562139,-1236182600,-124941519,-1435014311,2000367218,-1809711569,-571343510,1803617803,1921809645,-482698371,1074110990,-2119758134,344179137,2114053028,-1840581647,-1505152026,1307998946,1819111384,-614852610,1629669440,-1952644305,-762924480,327534863,167503217,-207164883,2047226760,129636278,-88452426,-1115460671,1624263399,-1211104819,-553763406,1613997511,-965157827,2106383042,227811914,-664652283,64512186,1660926972,-1393336533,2033914243,421548568,-229916266,-366528496,-1347073686,-1362057041,-796933776,976225545,-1601660916,1078260219,-546460462,-1930679662,-1336554690,-469157383,429671976,950536150,-91157906,172088472,304024614,993126530,276250421,494824865,-66441119,-976955991,1180279431,289974888,-2009879264,1133828671,-1876108157,1759819302,-1288032622,445276341,462870457,-263664933,1285900551,-1477697070,837822775,-2021599776,1852948204,1528237114,-1069589179,-469899791,-1275366146,-7664250,-122599985,-739266126,1457635981,742506523,-160003607,-1056155835,1979186751,-744292333,-1860357661,-1370314842,-1912355271,185382838,312338028,79574375,-436515212,1255615099,-690579145,-366631504,-1625898969,1742008311,-253707878,-1763708604,1114260236,1128019741,-226857010,878161074,1336501832,-1477490139,-430424596,203603480,1507342317,1603323335,-1792359871,1046259855,122890372,-1283305276,659507832,1345661364,-1714879820,-697635965,-420932756,-1623613135,2024218890,1277321799,1999179706,619224211,2104046733,-2135482984,978968709,-1565150036,1126579534,1500392107,-170742761,-1895478014,-2132532380,269464997,-2090767218,1705546962,1874233393,1613243605,-1221698231,-1644516374,-154442402,101413967,-997303030,706713325,-51947490,112484452,1053014493,549628353,-1927287104,-2026367074,-948349607,93163910,-2110022661,1246729766,899465243,-508271936,359062764,1289498196);
/*FRC*/Random.twister.import_mti(311); void (makeScript(14));
/*FRC*/count=2; tryItOut("mathy3 = (function(x, y) { \"use asm\"; return Math.fround(Math.abs(Math.tan(Math.fround((Math.fround(y) == Math.fround(( + Math.fround(Math.atan2(-0x0ffffffff, Math.fround(Number.MAX_VALUE)))))))))); }); testMathyFunction(mathy3, /*MARR*/[x, new Number(1), x,  '\\0' ,  '\\0' , new String(''), new String(''), x,  '\\0' , new String(''),  '\\0' , new Number(1), false, x, new String(''), false, new String(''), new Number(1), false, false, new String(''), false, new String(''), new Number(1),  '\\0' , new Number(1),  '\\0' , false, new Number(1), new Number(1),  '\\0' , new Number(1), x, new Number(1), x, new String(''), x, new String(''), new Number(1), false, new Number(1), false, x,  '\\0' , new String(''), new Number(1), false, false, new Number(1), new String(''), x, new Number(1),  '\\0' , false, false,  '\\0' , false, false, false, x, false, false, new String(''), x]); ");
/*FRC*/Random.twister.import_mti(548); void (makeScript(14));
/*FRC*/count=3; tryItOut("mathy0 = (function(x, y) { return Math.fround(Math.hypot(Math.fround(( + ( - y))), Math.fround(Math.exp(( + Math.fround(( ! Math.fround(-0x0ffffffff)))))))); }); testMathyFunction(mathy0, /*MARR*/[timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), timeout(1800), timeout(1800), timeout(1800), timeout(1800), timeout(1800), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), timeout(1800), objectEmulatingUndefined(), timeout(1800), objectEmulatingUndefined(), timeout(1800), timeout(1800), objectEmulatingUndefined()]); ");
/*FRC*/Random.twister.import_mta(1803355041,1002134409,-220637094,1276582312,892828426,1900603624,1925149192,-1642878565,517225281,605380697,-9338168,1454219631,984262769,1795831166,-1751591370,-1716548010,1699883550,532085385,-11732087,-748814922,-1590663237,-1626818710,1452357302,459600804,1571678311,968181911,740216967,1432144350,1040827718,-932074598,507528544,1296656517,-1057006254,-1525371071,-1785654053,-1011212630,597207498,1134475899,-1809451790,-617945130,874799911,-1391741211,-903290130,-1335414310,1909618374,-299014217,1696321473,-931408439,-288214465,2016431641,-1969285151,-738643937,108356397,1920490639,614208431,-1607051794,1665321353,-1514472569,-465559248,-1512858715,608390925,-1776311266,-788393199,204918771,-1196563503,-1788206606,1578735827,1630432314,10885527,375750140,992102637,105817037,-849544286,164161417,-654127127,1997354093,1036305849,-1747883286,-447381288,-1331786708,1603153611,-182021916,1608573759,-14958372,-381192896,1085308991,-2094033964,-369913912,1012125935,-1765771161,1618442228,939012120,1116408174,148958885,-1655814342,13159583,424436037,-528009388,-674547894,1137756855,-1569955416,1291889034,-1896198723,721110121,1609136448,766752946,-1754097185,1067768507,-597561719,-1766949663,-19100240,2106849497,-186292226,39134252,1800009534,-2088369226,1045978531,217301441,761174967,2016250176,-1292433945,-1711775147,-1698095764,-441919109,1011625414,-976877388,-1648938561,1369608567,-996097994,-31982351,-128138554,-1039939122,-1469344149,694089638,-1932513209,262975507,1476171970,1498460736,1594683748,-966241256,1061019075,749826993,55681694,-1689135826,-1658203680,-1859717280,15323115,107975216,-1969456267,243728851,1223328526,-281416199,148703784,-1161363277,2112492278,1243955669,1516516713,206525303,2132619430,-2058943623,944796231,915665398,587603948,-1192311649,148570621,1835233650,67174270,-933883152,-23925163,-1139326022,196568980,-857199881,-1068807163,997370921,794375837,-1195146553,-157517402,-299364652,-172210027,1839499652,-1496223658,1562136607,417483408,261945058,-1104581504,862390018,1504696076,-1455664101,1125562025,-1097334190,-1355733588,1071757696,-1737461577,1526905990,-1118391604,-599080288,429188574,369288691,-293756225,-1333291586,1571917605,-239157731,-1626252510,336260548,635689071,923366967,89672188,1263039836,2067217154,659201231,331577148,405381708,-924263689,366623565,-31822382,-358081564,-306390952,-140687552,-1081639483,913252562,1758718465,-1972516198,182061124,1646440497,-1108968432,-3061930,1616647555,21024045,-940288683,1403411832,-1887836719,1775694160,-667076228,1224768513,-1149341470,-641723623,212383796,-614350316,-709222351,-1037043520,1004355182,-611074327,112995919,-1373444162,-1450604408,278700188,508231250,1855138375,-1696833595,-439738744,-1078238176,-1658509454,2026994250,-335253550,-1397321630,-1314064308,-246242465,-591961149,2055608096,602244151,-915062543,-1462195203,-1058643051,-1262220233,138493301,-338789335,-1744907975,-1086167703,1917299906,-356102846,-296952312,-186237355,-2105967357,-1173491539,2115115065,-648807070,-1346348005,735473565,525565282,-2060266018,-522565890,-1558424776,-1612370747,-1342149229,-2038397181,502458620,-1903188770,-860548468,-887925594,-1426435902,200814710,-1296750304,715365449,1590772411,-157204064,914725172,1517796976,985459256,146872442,-742474089,-78537705,2059302673,-1757657460,-938696124,594126345,-2050413530,279557358,624894649,-1564417859,-1514189396,-680041803,1600507126,-1838520712,-243361723,-2108687828,-1788302707,-594469167,1873885340,-997086285,-1782568298,1600196092,-2042538520,-1297730572,-810489779,-1092496150,1488922732,375245323,-1149838779,2083477593,222178179,-958730836,1800450818,-143130089,-1807614589,-1721543589,-276921892,-1208490074,-51703157,-1079069582,-1302069951,600096049,1633151597,410459329,-1841272923,1224852480,-1723212253,1603811484,-911779255,1638217321,602522206,900803445,-498154174,-188006186,1759514919,299958344,-2048655382,-2033931619,1138077882,-1008766117,-1970342885,-937448132,478319855,-1437060631,1237290925,-1357673166,-251542423,1391095863,269099020,676352642,-1948350424,1529717610,1197381708,-803996465,1560108115,5309433,-804964832,971783274,-77442090,2134180893,1688133685,1121925011,-1169390286,1773218092,1719119021,535697561,-105214763,797268961,-2086230557,-699183174,563017714,-1827712909,149176029,322833983,-1990792678,277948035,924577857,1829350621,935868846,-1024718673,-645391640,-1850443231,698084464,-1456828334,902306170,-1334635852,1789547354,-1079606708,2007830675,-1628240087,-1929452853,-352164258,-25917290,-1439942070,-1260322448,325660049,-203830812,1155350318,-8774352,-88136442,872683287,1853357364,1608458658,1275912973,1092730257,641862640,1559049636,65875715,-471814615,245182681,721125322,203006894,-1337208738,-1612785755,-2057258842,-1386654094,-1013355834,351962973,1072708572,-137580003,2105184762,497420807,861548674,-1563184405,-442612296,217975945,1778623857,-1959449678,897798960,1817121321,-911460252,745363481,-1117896821,-62249066,-595504611,-49909460,-1647296523,630607979,2052461983,-497620984,2104983761,304664797,1580205477,368252522,1999974157,1215925724,-1153245564,786942746,-1684819769,1929790344,1723793224,-1359912741,2059458743,798773582,-1905838219,1035449268,-64527692,-738416284,-1844023329,-306953390,-468235518,-2058930446,2088551482,744077867,1367959190,-1582007801,2036014331,515419500,247219662,1102593617,1107743660,-608496914,-514826423,1375380200,-382157736,-1182239668,-948041953,-1423278817,-550304778,2073501983,1743537437,-1231169119,1194850546,-1405066902,-132450130,-441021675,2003607002,1092773765,-258077960,1513528090,-1336673620,-160007974,-559258980,-151075617,-1035892790,-790556313,-161754735,-270877042,49788517,-1355948703,-1148144884,-916011852,1370286415,-848346305,-1605115924,840482572,215535338,729572183,1783579273,248261634,-1902030395,474030785,-1213563638,619051412,-269246286,919155280,1664107769,-1501616292,-1605386813,1928219371,729643013,428399202,-609075117,-357749682,968953065,105308229,921303594,451443268,-44893737,2144325269,1364556852,2137643163,1869085892,261520319,-933979704,-17792610,1969335151,-1771470353,-198751594,-1758226720,1159462483,-514642085,1340114071,94127864,-1886930069,-1216026071,-560228876,183850512,452561622,997997620,1067692005,415199848,976083702,-547847889,-360934475,2137491573,-231151722,-439408954,907591479,-74453728,-1486035478,1090160125,486899986,2011052788,-173006037,-1790848771,-1081285666,899118567,-208983327,-1744934279,233053040,1239679329,1798819247,-530899393,863596176,-1514830458,-1951288234,-866373975,459256536,-1773014463,-777827704,774444602,-1367148738,2031719573,-1150049775,-1247869405,72398514,-1097602355,1620580630,1984691867,1472365859,623746207,-1719176024,1892903146,688565377,-1069896148,753358281,1665679153,186264913,1841558990,-1862738195,-1181951110,1512196341,292939627,-1044406830);
/*FRC*/Random.twister.import_mti(66); void (makeScript(14));
/*FRC*/count=4; tryItOut("\"use strict\"; /* no regression tests found */");
/*FRC*/Random.twister.import_mti(75); void (makeScript(14));
/*FRC*/count=5; tryItOut("print(uneval(t0));");
/*FRC*/Random.twister.import_mti(84); void (makeScript(14));
/*FRC*/count=6; tryItOut("\"use strict\"; \"use asm\"; /*ADP-3*/Object.defineProperty(a1, 0, { configurable: false, enumerable: false, writable: false, value: g2.o1 });");
/*FRC*/Random.twister.import_mti(113); void (makeScript(14));
/*FRC*/count=7; tryItOut("t0 = t0.subarray(o0.v0);");
/*FRC*/Random.twister.import_mti(133); void (makeScript(14));
/*FRC*/count=8; tryItOut("\"use strict\"; t1 + '';");
/*FRC*/Random.twister.import_mti(142); void (makeScript(14));
/*FRC*/count=9; tryItOut("\"use strict\"; mathy0 = (function(x, y) { return Math.fround(Math.asinh(( + ( - (( ! (y | 0)) | 0))))); }); testMathyFunction(mathy0, [0x100000000, -0x07fffffff, 1/0, -0x0ffffffff, -Number.MAX_VALUE, -1/0, 0/0, 0x100000001, -Number.MIN_VALUE, 0x080000000, -0x100000000, 0x080000001, 42, -0x080000001, -0, 0x0ffffffff, Math.PI, 0x100000001, 0x07fffffff, 1, Number.MAX_VALUE, Number.MIN_VALUE, -0x080000000, 0]); ");
/*FRC*/Random.twister.import_mti(213); void (makeScript(14));
/*FRC*/count=10; tryItOut("\"use strict\"; for (var v of o0) { try { for (var v of t2) { o2.m1.has(i2); } } catch(e0) { } v1 = a1.length; }");
/*FRC*/Random.twister.import_mti(247); void (makeScript(14));
/*FRC*/count=11; tryItOut("\"use strict\"; v0 = t1.length;");
/*FRC*/Random.twister.import_mti(260); void (makeScript(14));
/*FRC*/count=12; tryItOut(" /x/ ;function eval(x, x, ...c)\"use asm\";   function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    var i2 = 0;\n    var d3 = -1048577.0;\n    return +((d3));\n  }\n  return f;print(window);");
/*FRC*/Random.twister.import_mti(374); void (makeScript(14));
/*FRC*/count=13; tryItOut("mathy4 = (function(x, y) { return Math.fround(Math.hypot(( ~ (Math.max((Math.atan2(0x080000000, ( ~ 1)) >>> 0), ((Math.abs((Math.fround((y & Math.min(x, 1/0))) >>> 0)) >>> 0) >>> 0)) >>> 0)), ( + Math.abs(( + mathy0(0x080000000, ( + Math.acos(x)))))))); }); testMathyFunction(mathy4, [42, 0x100000001, 1/0, 0x080000001, 0/0, -0x080000001, 0x0ffffffff, 0x080000000, -Number.MAX_VALUE, -0x0ffffffff, -1/0, Math.PI, -0x07fffffff, 0, 1, -0, -0x100000000, 0x100000000, -0x080000000, -Number.MIN_VALUE, 0x100000001, Number.MIN_VALUE, Number.MAX_VALUE, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(568); void (makeScript(14));
/*FRC*/count=14; tryItOut("\"use strict\"; f0.valueOf = (function(j) { if (j) { try { Array.prototype.unshift.call(a2, i2); } catch(e0) { } try { a2.forEach((function(j) { if (j) { v2 = (a2 instanceof this.s2); } else { try { t2.set(g0.a1, ({valueOf: function() { print(x);return 7; }})); } catch(e0) { } t1 = t0.subarray(({valueOf: function() { i2 = a0[13];return 10; }}), 9); } })); } catch(e1) { } try { a2 = this.a1.filter(f2); } catch(e2) { } v0 = Array.prototype.reduce, reduceRight.call(a2, (function() { try { v0 = g2.eval(\"/* no regression tests found */\"); } catch(e0) { } a2.reverse(); throw e1; }), i1, (x > (4277) in null += intern(-23))); } else { try { v2 = g1.eval(\"a0.shift();\"); } catch(e0) { } t1.valueOf = (function() { try { Array.prototype.forEach.call(a0, (function(j) { if (j) { try { i1.toSource = (function() { try { s1.valueOf = new RegExp(\"(?=(?=$){1,})[\\u00dcS-\\u2865\\\\r-\\ufccd\\\\d]{1,5}*?(?![^]|\\\\x98.*?){1,}|(?![^])*|\\\\cO*?|.{2,}\", \"y\"); } catch(e0) { } try { a2 = m2.get(p2); } catch(e1) { } try { for (var v of g0) { g2.a1.splice(-2, ({valueOf: function() { a0 = []; o0 = {}; s0 = ''; r0 = /x/; g0 = this; f0 = function(){}; m0 = new WeakMap; e0 = new Set; v0 = null; b0 = new ArrayBuffer(64); t0 = new Uint8ClampedArray; a1 = []; o1 = {}; s1 = ''; r1 = /x/; g1 = this; f1 = function(){}; m1 = new WeakMap; e1 = new Set; v1 = null; b1 = new ArrayBuffer(64); t1 = new Uint8ClampedArray; a2 = []; o2 = {}; s2 = ''; r2 = /x/; g2 = this; f2 = function(){}; m2 = new WeakMap; e2 = new Set; v2 = null; b2 = new ArrayBuffer(64); t2 = new Uint8ClampedArray; return 19; }}), e0); } } catch(e2) { } /*ODP-3*/Object.defineProperty(e2, new String(\"12\"), { configurable: [,,z1], enumerable: \u3056, writable: (x % 6 != 2), value: g1 }); return h0; }); } catch(e0) { } try { this.a0.shift(); } catch(e1) { } m1 = new Map(m0); } else { try { /*ADP-2*/Object.defineProperty(a1, ({valueOf: function() { for (var p in o1.t2) { try { t1.__proto__ = v0; } catch(e0) { } try { print(uneval(b0)); } catch(e1) { } try { a1.shift(o2.g0.t1, g0.o2.f0); } catch(e2) { } b0.__proto__ = i1; }return 18; }}), { configurable: false, enumerable: (x % 4 != 3), get: (function() { try { e2.has(a0); } catch(e0) { } try { this.h1.iterate = f0; } catch(e1) { } this.v2 = evaluate(\"function f2(v0)  { yield  /x/  } \", ({ global: g1, fileName: null, lineNumber: 42, newContext: false, isRunOnce: (x % 14 != 2), noScriptRval: true, catchTermination: (x % 72 == 5), saveFrameChain: false, elementProperty: s2, sourcePolicy: 'NO_SOURCE' })); return g0; }), set: (function(j) { f0(j); }) }); } catch(e0) { } try { o2.e2.has(Math.log1p([1])); } catch(e1) { } h0.toString = (function() { ; return b1; }); } })); } catch(e0) { } try { this.o2.toString = (function() { g2.g1.h0.keys = f2; return t0; }); } catch(e1) { } o1.t0 = new Int8Array(t1); return m1; }); } });");
/*FRC*/Random.twister.import_mta(-1609623406,-1816006741,1525127882,-435062879,112673345,-1425326761,-1216899178,632794832,1324997219,402394703,-301867953,1048226808,23769868,252081618,1624915572,-503095224,-102233389,106197084,-1916687040,1611175375,-1525594154,1559383167,1376949213,1183754743,-1539188959,-1146559207,-196163314,-1851141322,-2091221404,-1994873972,128783934,1892984941,-105241525,-1860939296,-599969506,-1546618349,2061927116,1349950285,763750951,-1762816206,668133249,235721309,1229463752,-914652237,1164592865,-791881967,-1959550581,-1065090612,143797799,-1494764924,-107209883,-125509722,656381457,1822713044,663418716,-1190588146,-1523100586,-340431433,76662717,1489433741,-1866159092,-255328138,201644273,1045441348,-1155097340,-1716969851,26177030,25109791,1712411190,-693285480,263189361,-1510065286,-1275052128,858587050,-1411960753,-431377560,513519391,403869800,1904681466,381997809,-914715584,-1654368954,527412193,549839645,-982444305,629459340,-1147304051,-2112144990,-1758593258,-483921516,-636240112,-492885850,890929427,-1013078999,-152237284,113465819,779156379,265832819,-319696413,1530521531,-596029382,745223579,-432694815,-1805966924,-2109963180,9969874,-688615268,-1017637736,-468368061,310762686,1476068120,-1642859521,425803189,-1202538698,-2040228544,837334272,-372791791,-1615119344,1956906283,-983942678,1515803570,-882579050,-1315345545,-300400607,695785728,720613127,609677725,1077097581,-1306414641,-1170506586,2027618258,1828731597,-865941706,870825489,1853356989,-1451972654,-287737737,1237071396,2147020990,1168830986,-674382153,-878179739,-647013810,-294773349,-1120704178,-1809256595,2082286321,1949466415,1791482698,-1169075239,-373208236,-446786193,1065666859,357122098,254082950,899963769,-1396473907,359298597,1886343369,1416035287,-252291956,1200061251,-797531510,1191089296,1139979873,1253190952,1123121286,-932603063,243462760,-971900457,-703311867,1119750381,-1261455233,1515091584,-1429387605,-779722909,-214685218,2036700246,1628914138,-1925141871,230351515,-518728597,-726415251,-1181286769,1007173231,1112322634,-350570633,2070011571,-1591920814,-977052021,-580832585,-1589666764,1154059855,388527339,1092037151,-1522108745,-227928134,306007024,876752108,-1491332118,2011649035,196672513,-1106755932,-988269608,1228325972,1538269330,127473025,-585084780,1859488190,1441446861,1943339879,325086982,-640037958,851339922,-1035699304,1880363915,1133499954,-1666116425,588473597,-1176064182,-889525249,1819667654,-119958005,1210709569,-1819615354,1938201750,-1253291134,627340129,580117294,1888184837,957828375,304450706,559248753,-1307534794,-95430796,-1917023777,1145993985,-507861244,1432321703,664084745,781614737,894936960,2102725491,96129643,1821575059,-897243596,874767439,1259124569,679341354,-1529597873,-2087912850,-1210590175,1841110632,-1092874696,-1980022894,750277448,-113179168,-1692464451,1104986004,-711308001,95608693,578364459,-531474419,-281834740,-627814694,1259102606,-1342173691,551438753,-895442989,1048836676,1605235033,168780467,682859728,352147419,-2044882853,-192888704,592246884,-281051846,234909794,-146681286,823245083,-1885480698,-1711442537,510509199,1206089299,-1963625836,-10308703,964589748,-932308274,1470473386,1598581234,-683302587,314060570,2130855543,-1991936618,1403465385,-1939957784,-2108024853,-1331843116,-542581404,1594795987,1774219696,-1264619898,1297053084,-905067923,1143825479,-1953821057,711832152,684806120,1020763783,58079250,1961361500,1690953773,-392388660,843576175,-197709011,-928037556,1543517588,1796041917,-1093597793,2013906045,814618256,-501558489,-1442495342,400806830,-2025243324,229101980,-1016767925,-486362142,419998423,-862320747,-374756613,626442629,-734367271,1160845160,-809923619,1137743310,-1048168590,1990192846,-1736068062,402660600,-412121991,-1857689312,1883671351,1575387362,-2069105295,888325275,346233748,1781781772,-451779106,-274098117,771084627,1373483521,-1499923182,2716233,1560177346,1745136542,119369447,1971207567,-929244420,1339275068,-1275333139,511312098,1341132894,-1612474033,1182122218,-489853935,-1065625800,-1558370198,-1116966999,-1282657618,1647984947,647552100,1025415163,-43641694,877699300,1566944593,-1556474227,1502064646,980350460,1127824016,-69296704,817796807,-847267907,-1636790427,1062380388,-965233055,-256213007,-949403132,-1097618977,-509118739,-1096038209,1802160638,-1350802722,-1869143334,451608193,-960031023,1907197612,1641792791,1983213186,1045695538,1360030751,1127944038,774569616,1635715774,-1714702561,1850067219,-937928411,-1257861697,-1500633895,-73285523,756256206,-944276787,272242523,1521505950,1688229841,-1773270299,-1585523402,-1042605786,1001313015,-1003252678,-2009763070,-742357552,1378520421,-1454889297,-1792474283,-40976423,-963616575,-773547523,-1115793490,1274776110,-1855726379,791856470,-1116280109,-242372463,1684069938,965369832,-443737125,881825183,-43887899,-647741572,-807698801,-77759177,1274227950,-177416187,40614857,571293071,820031064,577017851,-861009918,2013707134,-338960485,-103534037,-1214166683,-1378985093,-528867991,-103813255,-1721161617,615448452,952628876,1327803763,668153827,-317684381,273344680,-1097824289,-334427155,-2113077692,1602183896,1761202961,-1810440641,-1749677472,-1071050623,309053351,1849160906,1560787359,613027469,-33445786,-18291577,1303632682,-1400798375,19551557,683023314,1266182490,977354195,-1530620877,-1559860160,-608065095,-1783011661,125728983,-1157224706,-235416125,1125512410,562014071,-2136977989,1756323451,-2093099683,-2027461734,867471160,-945096289,860202354,-389394963,421032394,1153961160,481328383,-42540235,-1100251418,327056859,-1105672586,-1969993560,1223397391,808087637,-170782671,422349512,-518400605,1253215668,627604995,-657638199,1377381637,-1200782742,769021278,316144171,-1351036699,-1611281340,1498673414,1398319030,48546060,49210713,1979368286,661010247,1948753304,1214964924,-1326557883,521938166,-110669836,-570464998,-295013687,1405104456,-446270674,676861204,-2145913480,-1048626784,2001453979,1878795986,-2038837928,-1823723323,933456765,-1293475283,496712265,1326444373,1652259843,-107437630,-366914051,-1548428727,1630256945,-331028145,1170016359,1368295411,1548594278,508839897,157797141,-822840337,-978918437,-303812383,-1832083707,-473406686,451458317,-1613947984,-746983668,910529468,-1149776567,581102288,-1836497537,1968529095,-913774109,851124878,344213712,-1950728966,884783274,-1458952071,1621500001,-1182388121,2037847263,-2051138020,1412213180,1408078324,-1246791857,-401730742,1286503130,1021573522,1753269904,556057753,1001768098,-1186229878,1263367275,-1158496182,-1635213352,-1487440346,-1509507497,1167745581,1950721268,-1456670895,-50329719,1461251797,175392982,-1577039376,-1501611462,-816119023,-968500495,1894860403,-954718966,-408934494,588103936,237243204,198191293,2061844679,1919691208,-488738828,495355010,5240619,-276673526,-1802668246,-1921339989,973625449,-1765762408);
/*FRC*/Random.twister.import_mti(102); void (makeScript(14));
/*FRC*/count=15; tryItOut("e2.has(b1);");
/*FRC*/Random.twister.import_mti(115); void (makeScript(14));
/*FRC*/count=16; tryItOut("(new XPCSafeJSObjectWrapper(allocationMarker()));");
/*FRC*/Random.twister.import_mti(149); void (makeScript(14));
/*FRC*/count=17; tryItOut("\"use strict\"; mathy0 = (function(x, y) { return ( - Math.pow((Math.fround(y) !== 0x0ffffffff), ((Math.expm1(Math.atan2(( + Math.ceil(1)), 0/0)) | 0) | 0))); }); testMathyFunction(mathy0, [Number.MIN_VALUE, 0x080000000, -0, -0x080000000, 0x07fffffff, 42, -0x100000000, -Number.MAX_VALUE, 0x080000001, Math.PI, -Number.MIN_VALUE, 0/0, -1/0, 0x0ffffffff, 1/0, Number.MAX_VALUE, 0, -0x07fffffff, 1, -0x080000001, 0x100000001, 0x100000001, -0x0ffffffff, 0x100000000]); ");
/*FRC*/Random.twister.import_mti(267); void (makeScript(14));
/*FRC*/count=18; tryItOut("Object.prototype.unwatch.call(g2, \"\\u3056\");");
/*FRC*/Random.twister.import_mti(282); void (makeScript(14));
/*FRC*/count=19; tryItOut("m1.delete(e0);");
/*FRC*/Random.twister.import_mti(295); void (makeScript(14));
/*FRC*/count=20; tryItOut("mathy3 = (function(x, y) { return mathy1(( ! Math.hypot(Math.imul(( ! x), Math.fround(( ~ Math.fround((Math.fround(x) & Math.fround(Math.pow(x, x))))))), (( + ( ! Math.tan(x))) | 0))), (mathy2(((Math.fround(Math.min(Math.fround(Math.fround(( ! Math.fround(x)))), (Math.PI >>> 0))) ** ( - mathy0(Math.imul(y, y), y))) | 0), ( - ((x <= -0x100000000) * ( + x)))) | 0)); }); ");
/*FRC*/Random.twister.import_mti(581); void (makeScript(14));
/*FRC*/count=21; tryItOut("v0 = o2.t0.BYTES_PER_ELEMENT;");
/*FRC*/Random.twister.import_mti(597); void (makeScript(14));
/*FRC*/count=22; tryItOut("e1 + g2;");
/*FRC*/Random.twister.import_mti(609); void (makeScript(14));
/*FRC*/count=23; tryItOut("\"use strict\"; v0 = Array.prototype.some.apply(g1.a0, [(function() { try { t1 = this.t0.subarray(({valueOf: function() { e0 + '';return 13; }})); } catch(e0) { } try { g1.g0 = x; } catch(e1) { } o2.toString = (function() { try { t0 = this.t1; } catch(e0) { } (void schedulegc(g2)); return o0.s2; }); return h1; }), v2, e2]);");
/*FRC*/Random.twister.import_mta(-1589263962,212338802,-600480371,-469295667,-576896405,411092141,2096179704,-552904880,188547303,-1068656661,-1759179559,-1246505927,-1592975824,-875765929,470957546,575393659,1393569653,1548779582,-1918063127,-2067355378,1443840982,1910169623,-2115946797,1327222645,1290383697,-1444421289,452879614,-387638883,-777694573,-1101515578,1743946792,1949383431,-168525986,635769505,1501778179,1380025392,205854634,2118645085,1863719339,-211051273,2072232490,271287803,1087841251,584690899,2125833688,667688237,733031432,674070473,286810763,-942964510,1285734795,-387716052,-84133272,1807990992,-145795300,-1420847104,1534283617,1989019770,1427232752,-240273025,-519231404,-73129181,670032686,1387783153,-233895810,-1378405792,-1979856136,-1919406396,-951603935,1557378851,1300266853,855231681,-847207958,458564248,-1290942155,-1003577097,1648278782,1707354466,-1226778838,-625152442,-1336226268,-1693663739,636207624,-1164284179,2054455060,-809625021,2068619522,-279811144,-761949046,-1228376527,-453578016,-990148479,62932021,-1971236787,-1719867160,-1353749915,507828701,-941685163,2007602783,-1457796217,-58088150,1840809392,2036872616,-1445720121,1498702243,1873953926,2099017395,376762699,-148270919,948173911,672763734,1596745389,1422052244,1930967797,-1389999439,-1261967073,-1362867285,-1444397058,130376438,-1243507440,2007718350,2041153294,-1009597039,1181456043,587839417,349570133,-532489233,-750727282,1610186591,2122554032,-630034713,22500572,-1260588465,-430331459,-1537997140,-243783662,-1648798490,-503112379,-859894836,-517054772,431670979,1156560947,1848134506,-1612280569,-1537800974,-1996881035,627589648,-1506812576,-1283231154,-972585081,-163790815,-1983562977,1759501338,-32842239,1778108574,752735600,-1298778884,1299968500,-158939821,1777708469,-1501126376,913249948,1779990877,1980078080,-520096433,-862155614,804315774,-1534518762,-1595344583,1842316141,724458405,-1255473316,-699337207,-1362298534,1665325585,214911528,-1254480952,36733539,-1960006329,1416625512,-1656856000,1515945104,-1520046087,2123014031,1481723386,691795320,-1332414918,1130564189,1313237205,532036302,473019584,-946893206,-98808774,-1733828279,-1340190938,-1065444777,39047571,-1596729796,-1928948179,1168927996,986869896,1520336255,382319896,-843606661,-791144512,-841165622,618946716,-714437329,360896259,1874408061,-805966478,1545446318,-1639509949,-964552082,-1039173606,803463261,-1669328327,-1302052250,1855946349,514566868,1807512289,-1523872527,312346613,-1656219415,-189144096,548306344,1568281591,-1341378511,-1377497681,1505129433,-317334652,1413433356,25725366,30851650,14525280,-267219528,-258947991,1686242133,1064432738,793678247,-781775721,-1146091380,-1180821871,-61793181,2031227684,1320546065,944259709,1110553923,-88586001,-1071166492,-1913089606,976698981,-1232476597,1577319223,-1095159751,-318386077,1792999751,119331810,-940266153,774217787,-1378799509,-257765926,634929590,1628385479,465683866,-299979146,973867256,-941933284,1332377817,-167154800,-1093227179,1793878960,-1262877153,-1313385222,1382883209,1086201529,-262914433,195230138,-750582479,998004282,1812802643,582573320,2104608920,-511032169,1945415984,-1280819457,-1391295195,-986045133,-1871253130,139188183,-534936692,-1152180237,190751108,-1923125197,2101545295,-1050089771,-2064249847,365865103,1563271795,990855900,800397888,-1455260042,-1568073159,-567218921,-1629869154,707649738,-1886767254,-1540199984,477086105,609279489,-2131857725,-786940963,-68135515,-1150818198,1279345393,-1228786132,-657953541,1215886433,1117502097,-422832428,-1832494331,830026148,-95565780,1437937674,-998532873,830111377,295818877,-1928790821,-1204527100,-970094915,1141402213,-1829260866,-592982859,528809223,-1465875334,-1765680546,406906862,1398175793,1399766204,415417832,-643348458,-444285407,1441537115,-2143876134,850752921,-994791324,-1078978342,1119007560,1260434913,755939667,-1986408739,-1829773722,127564508,962515476,-46138641,1811622544,-469394148,2043003135,622410146,-751490607,1722606484,-345438499,-696246211,188754078,-2126906064,1691421979,-2129414832,1211388662,-2091827400,938365501,2012421441,-1222939968,259913815,467355713,-66613998,70849593,1318206494,-1694558174,-1796062751,1229144402,-1008365343,-1465109726,-1821720975,1688650641,315793478,1286975164,-2002771310,-986578918,-265391444,-2084336908,-1336357760,-1790275152,-618480179,1740337939,1895093641,444842638,353976379,-2100622863,-1909438435,-914690032,525107082,1121934754,467285344,-2054838633,-1747064525,1694955793,-378838747,1588958272,-1877680605,1102954256,671308136,-494780349,-131183094,-1647518347,-398749334,-597041800,1326010453,2094807123,55597006,-670726617,-591570744,-637661746,811822138,-1879084517,1934616393,1791588638,-1074992061,-886534999,69293736,1932818447,1544473550,-2025753237,1248792956,-987101173,-1487216074,155711735,-998830257,213555042,-73123325,-218820611,946279926,648640094,1243248170,1061080804,1784229725,-426684299,115080696,-477722173,-2088990480,1855806026,832915451,291195434,-495556155,-1835692395,1496944218,1208634060,-1945479375,-1086151610,1214034762,-1089310768,-1959270036,-1352838898,-1204291092,1993357145,-1954400644,2121763648,1089544395,2081641920,682874700,-230354015,88941820,-1456521176,2041451892,-1883034003,-914619686,-977756964,643533176,-350127057,-1249947882,1863613494,1247344350,-1694169964,1764621909,-508167295,1453321666,857524564,-34495555,2003221727,-316547419,-1003807864,8768170,-1837717762,2001090676,-682420454,1598908269,217696532,-1345115124,67854661,860797193,433557558,-46437345,1879644653,-672231399,1474821946,1419200201,66358019,611333377,692520967,-540793392,-60014483,1114373200,1063449684,439117041,-934558721,1317448429,622387149,-128978550,-64273735,-306694820,-1690440626,65775774,851046253,-1379852714,-1386586158,347916297,-984457216,32646003,-1525763780,-1823362886,-2034472857,1599043434,-783009307,379471664,-512391705,1242554475,1972361533,384034710,-725457847,-787234463,-1689269899,1506457976,2076135832,-1241591680,140952646,-1969098496,-1025467560,822688559,742988912,-1723056262,-964585267,-1179833813,212419852,-655945258,-1098182139,1994311735,167482146,-401911666,-768935594,256697579,1658144157,-463520715,1197092053,1185883395,1772410495,-2027253144,1552429412,1904095854,-2105179704,1631053914,79522099,276502970,-786994651,2037937226,-420640355,1223726880,1325247388,2001790214,68446782,2075426441,-2108566992,-588388188,-2034207,32341582,-839690778,-98907257,1360932871,-1251863364,2027757405,-550935147,1595601582,379243215,-1650706955,-1736505359,-1670720139,124787994,-788888533,-35275319,-1942578040,-1925596998,-2099039456,-61605030,243485351,16986194,1603410150,-910129857,1784115382,-1284956939,580223751,-1960828505,-524636768,891298577,364946916,-799733187,752497198,-66841346,-1052687018,-855586635,695699402,-1567901771,-1855715752,-1207003879,-1258796702,300126146,1169924328);
/*FRC*/Random.twister.import_mti(66); void (makeScript(14));
/*FRC*/count=24; tryItOut("mathy2 = (function(x, y) { \"use strict\"; return (mathy0(Math.fround(( ~ Math.fround((x ? Number.MIN_VALUE : -Number.MAX_VALUE)))), ((0x0ffffffff | 0) >>> (Math.imul(x, -0) | 0))) || Math.fround(Math.imul(( + (( + Math.fround((( + ( + Math.tan(( + x)))) % (mathy1(Math.tanh(x), x) | 0)))) <= Math.pow(Math.log10(-0), ( + (( + x) - ( + 1/0)))))), Math.fround((Math.hypot((((0x100000001 >>> 0) != (y >>> 0)) >>> 0), ( ! x)) >> x))))); }); ");
/*FRC*/Random.twister.import_mti(354); void (makeScript(14));
/*FRC*/count=25; tryItOut("mathy3 = (function(x, y) { return mathy0(Math.atan(( + (Math.fround((Math.fround((x >>> 0)) >>> 0)) << x))), Math.max((Math.abs(( + Math.imul(Math.fround(x), y))) ** Math.atan2(Math.atan2((y && 0x080000000), (x >>> 0)), ( + Math.exp(( + (((Math.log2(-0) | 0) % (x | 0)) | 0)))))), ( ! (Math.ceil((-0x07fffffff >>> 0)) >>> 0)))); }); ");
/*FRC*/Random.twister.import_mti(582); void (makeScript(14));
/*FRC*/count=26; tryItOut("mathy3 = (function(x, y) { return Math.atan2(( ~ ((mathy2((x >>> 0), (( - mathy1(0x080000001, x)) >>> 0)) >>> 0) != (( ~ Math.min(0, y)) | 0))), (( + (Math.atan2((Math.fround(0x080000001) > Math.fround(y)), (y | 0)) ? (y || x) : (Math.acosh(Math.fround(( ! Math.fround(Math.max(y, -0x100000000))))) | 0))) | 0)); }); testMathyFunction(mathy3, [0x100000001, Number.MAX_VALUE, 0, -0x07fffffff, Math.PI, 1, 0x100000000, 1/0, -0, 0x07fffffff, -0x0ffffffff, 0x080000001, 0x0ffffffff, 0x080000000, -0x080000001, -Number.MIN_VALUE, -Number.MAX_VALUE, -0x080000000, -0x100000000, -1/0, Number.MIN_VALUE, 42, 0x100000001, 0/0]); ");
/*FRC*/Random.twister.import_mta(-996209208,958548484,577883689,-393580960,-1751675093,631415196,-1442837185,1263262111,-601324997,1005672342,-1654337917,-1064152773,-1118609308,1711949725,1789859617,1219422575,-1276863126,2011526977,-1643476481,604959166,-583403385,-1700234120,645976386,1673605311,1409633722,2099011141,579161610,-2104099105,904225661,-870994345,1748541941,1054566663,-1194442368,-372780144,-1369327757,1280154281,1661026938,165240380,-1443199405,-1179193766,-1649941184,1120344877,2056350027,121489178,-1404581865,1606606894,-1306476065,-69357881,-982216700,-108909086,-671645739,-33385020,461158946,167963765,1157400106,382172842,-1445819736,1941005730,-371972436,-57883877,1536689416,464208605,255930103,-1305449133,-105461698,-53928816,807149627,1898532915,-1994989554,-12996698,-60357761,242452409,-1074822419,-2050789191,1378918540,145836811,-1121895716,-770938545,-1461261313,2121723498,1068471282,-410341870,-346948705,929220948,634567018,344698580,-702755235,1070933895,-244301165,-1886725427,-1944860608,902384736,1482883953,1278983902,1557766931,-1586699195,1840522479,-1114563427,-2122540024,-778568039,1926701981,268084189,-1808455926,144305169,1204829102,1885871007,-975882432,-167035318,-960641545,813494954,-1613132914,-173719526,1558769096,-839882281,-66473980,-733548037,-1665147904,224664470,1072174405,-2087035539,-1056997058,1431955275,1627428804,-1956133987,-1579524712,82363262,-990234603,-498546823,-99373736,-1245469473,-442164398,272070978,1821903974,224752700,-1444401684,1480781123,159169434,743466381,85522011,-1019857880,1874659471,-435690284,229916457,199310081,-1496653571,-414518904,460401398,-748664793,954984516,-752882720,-240963296,-316419721,1619805970,-850342300,449294260,-1045689432,-667489537,-728425919,-469109465,-79167486,-1994558952,-1555557222,1507297693,1294497357,554986116,290935868,2078301044,1314283051,-1285079027,-35541149,-1743716762,-1827200127,1406866846,-120404883,-680472783,1675978158,1056798835,-730959524,617239848,2043663398,1765397622,-267503190,1679568168,-255504807,-344125603,430376275,894066711,1144082226,1589980512,-1149579556,1528485992,-1574485112,-1975405867,1318448476,1688979457,1079926759,-1945944469,-654580013,-1305693611,-527661683,946934504,-2040699338,1026574658,-1807748934,1751982274,1399914524,-332403026,436821601,-998024873,-1802245556,1285247696,487266649,-2080661353,1411882780,-616962795,1193128958,1978143517,306387735,-837513156,1641431322,-1561661075,1925973136,113818355,-1034787607,-458262602,-1504299290,-994768849,191183808,-856571081,352003051,-2104112538,-1756115984,625590461,-1435575153,1933745987,1030246608,-793188637,-2099497806,1312663863,216553200,1003635675,-1352094538,-1349593215,-814902024,-910741482,455481374,-1675715648,2037214255,-88352374,1618778527,-1479401646,-699855296,-1961553151,-1529780535,1830790705,-645770495,-811875418,-758495359,-255784507,925788522,-1852394115,-57829464,-440225259,1860280503,1054214407,-184778193,-1705283372,1662675443,2042867429,-1124954306,1917579970,789740487,119097939,1109327556,1116344644,1683374052,-1135390401,1734233490,-1547911463,-1267557164,459162353,2051301990,-1089803202,-802631120,-210908670,643159265,119103837,329481651,-964290071,1062203185,1989235317,-1139173124,1668158550,-675998653,-929721466,1382373077,752241470,1274634905,334767831,-1472917555,-1855828094,-1703109297,-22966945,-229888237,-2028299990,-1356599222,745527938,-393165855,1823109581,1915649057,-957979547,-1054727321,1228430049,691331066,615791761,68994097,1925058594,878093783,112150282,-2012701140,344401420,1644119813,-877233088,-696166325,2082771722,279234537,1310404651,785191839,-169553828,1866048231,31601870,-1333039829,-1499277885,-779782787,-1117007003,-1969375744,-2132836755,-1234250288,-104586514,1882933699,641369624,267849462,-732072938,1559090707,792609700,1613764904,-490535735,2087152401,-623506627,-54214539,-1039127378,-501784330,407349876,1668117949,-1749724623,-938384426,1344926847,-148273277,-1599775371,533626284,-1579595891,1537248557,501414156,165692674,-953134113,93400307,-1490281133,1846908691,620264725,-1354432170,275549793,2021436425,1940907383,628288639,141849316,530773579,-564107279,584229135,-1987939874,-663339075,-1727604747,-897957805,720886463,-782255396,-221262561,-530979730,-1714356209,-250983602,-492187168,33288157,126697109,-712145731,-75342486,-627932817,1125629804,551768271,1703713604,1174432439,-139830391,477964891,-641897796,-627190399,-131135942,-333759435,1072020747,-1988668059,378871302,-130348104,-1865357790,1880981916,1485627047,-1754650536,-834020554,1096263842,705012110,-1605814891,471622186,1521677199,388837444,-467722575,577432507,1016757788,-559327691,1823243536,-308323748,886207659,470840070,2053224892,651160302,322383013,244841168,224045180,-387140410,-1081958475,-945679675,2142268975,-758210051,-398328050,-42389896,-540530068,1198728243,-30089728,1484969100,-640928660,-1207761934,-1921421632,-920799964,-480987883,92449205,-2028820015,-889208324,1285354379,1981038963,-1473655038,794828454,1409046640,1264218568,-423914557,-1998914536,1624388619,-37719032,794387381,-553059421,-713425443,-35131118,-145913459,853670928,797681789,256021945,-316127745,-604359444,-1251984724,-2050015241,-123692371,464593473,-1449779914,-857434281,-43140903,-1581043621,-1371969426,-1454119805,-2138969660,1884298782,-1529596601,-884726997,1462855876,-711620646,1041165040,-1634198932,-1518315712,1742402504,1165301053,-548075102,1828025277,1701219705,1848260835,1744801603,-219930983,603567068,-1601418109,-1559051539,-260707945,262520953,252723844,-5457716,680268934,970565640,884756505,-1652886897,-566291946,-812013542,1735608485,-1686600255,-112032524,-1742232950,-90054356,-665649486,5064923,-242782501,580632601,1474384682,-562750291,80247100,-8347675,1766871705,-905607247,-1162717357,-657811489,1076500899,-1861863702,1139704638,-866796878,110199398,-798975384,1264557984,1742438918,-1052246310,929510410,361592578,635242077,350975798,1045124305,1076864530,2012145826,1428613243,-953980350,-1641279468,404830641,-1682490436,241719690,-1865024819,1347886049,-689308108,-1401101073,707844622,-1042188261,103603788,-548604316,417955642,226884358,723571656,120910139,658992608,-2092288167,-668283550,-1048888359,1903790375,1453421109,-1801385296,-597624629,-311503906,1401059713,-900829895,-2034544807,1528413919,-511804994,-19991190,1724031797,-482375186,1982946854,-2053783662,-683414250,-286734043,-1272176285,112078687,-1173072085,-89636131,390415768,875426938,-1884869452,-1641615577,302473464,-760416618,-460057634,-547330599,-1023274194,-379695342,1458590268,957167001,226891994,-79955469,150334157,812382776,1669895601,1475942740,155078523,271863521,94271481,-1171843453,-378569752,-608180178,1139669214,-1238041223,-1479341456,-1851069979,488703333,1430268984,-1883220592,-1656780911,1049470777,-2131843618,199653517,37650619,1203969440);
/*FRC*/Random.twister.import_mti(224); void (makeScript(14));
/*FRC*/count=27; tryItOut("/*ADP-1*/Object.defineProperty(a0, v1, ({set: URIError.prototype.toString, enumerable: false}));");
/*FRC*/Random.twister.import_mti(249); void (makeScript(14));
/*FRC*/count=28; tryItOut("mathy3 = (function(x, y) { return ( + Math.acos(( + (Math.sinh(((( ~ ( - x)) ? (x >>> 0) : ((Math.min((x >>> 0), y) >>> 0) | 0)) >>> 0)) >>> 0)))); }); testMathyFunction(mathy3, [0x100000001, -Number.MIN_VALUE, -Number.MAX_VALUE, 1, -0x080000001, 0x0ffffffff, -0, -0x100000000, 1/0, 0/0, 42, Number.MAX_VALUE, -0x0ffffffff, Number.MIN_VALUE, Math.PI, 0, 0x080000001, 0x100000000, -0x07fffffff, 0x100000001, 0x07fffffff, -1/0, 0x080000000, -0x080000000]); ");
/*FRC*/Random.twister.import_mti(372); void (makeScript(14));
/*FRC*/count=29; tryItOut("\"use strict\"; Array.prototype.unshift.apply(g2.a2, [x, a1]);");
/*FRC*/Random.twister.import_mti(398); void (makeScript(14));
/*FRC*/count=30; tryItOut("\"use strict\"; (void schedulegc(g2));");
/*FRC*/Random.twister.import_mti(407); void (makeScript(14));
/*FRC*/count=31; tryItOut("for(let w of /*PTHR*/(function() { for (var i of w =>  { throw this; } ) { yield i; } })()) let(e, w, tcuxgb, e, e, fwtyhu, w, weiysc) ((function(){let(eval = undefined, urnzgz, w) { (this);}})());");
/*FRC*/Random.twister.import_mti(587); void (makeScript(14));
/*FRC*/count=32; tryItOut("\"use asm\"; g1.i0.next();");
/*FRC*/Random.twister.import_mti(599); void (makeScript(14));
/*FRC*/count=33; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(608); void (makeScript(14));
/*FRC*/count=34; tryItOut("\"use strict\"; a0[18] = (b) = eval =  /x/ ;");
/*FRC*/Random.twister.import_mta(445730741,2140802114,674766187,192814582,-2008251057,1948758138,280387621,-1996927799,-728760658,-2127574632,24810490,-830908912,-1710222707,-187439640,708176944,-675572349,-1548901411,-1140304466,-229749430,-1417138506,401001907,1148016869,1291269681,141053286,-1692605983,-806620880,-185716064,778394429,-1949297825,-251358429,-66798112,984140334,1741997421,-1062235722,-227224073,-647227909,-1150406485,1247273267,594221314,-1675799715,271237703,1496918530,-598291999,-933728025,-1848267241,-660994884,1026184144,-625390608,-239568847,1005500945,-1672085513,1211954340,454782772,-394165527,1207913694,1660748839,-772702765,462032368,-1263367902,647394124,1919320690,376626108,-524111235,-2128932841,1363013117,504257377,1961223451,-110329579,-1999544738,-707080848,-239412354,-1984044016,918637948,-1293785942,674246646,-1688231271,145628885,-691345567,-693278205,-751608146,-827789360,1298365771,-175633212,-1145391050,-1966850386,-1034499601,1647711835,1794421437,-1979927171,-1818467334,1693076672,731982603,-2086827985,-792816994,-859056192,814197514,-348828372,634962813,-1612089488,-2019774894,1813118888,702750809,2110261844,-2131042502,1363760263,760175577,1947590049,100330216,1890741715,909471183,1315893268,-217152405,1640994338,-1315082216,-1806139257,-718836799,-1075803841,517675255,1650753349,-1204994515,-202830943,-1056496327,-1105161976,118259174,-1677624046,-1078077975,397167750,341410869,166520065,-933176582,-1865340034,1986404240,-1749775116,1461360072,964459724,36691883,1598036081,-790932398,1178638354,798083650,73713248,-899688375,-1188746494,-1635338345,1307454485,228012905,-950633362,156441689,-290676814,-419592060,-138911275,-336521163,683687608,-575263465,1887510069,603601812,1597954320,-1052995518,-1136297958,1117939520,-1897333719,-318108885,-1306955521,1001055882,262101797,448217178,1030334611,1485954491,646143159,1030878740,-2044570838,-45318017,2030119458,534643865,577817430,1278763487,-1400080393,159159371,-577137747,-900587695,1590018016,-1859018886,-681883179,1763936483,43573088,1833257457,-1774942470,701282799,-1482084283,-1759170839,106357852,-402285105,-387065318,897301496,-1423900716,1302714748,299978856,528387116,709681463,-1251555738,1440669991,1737822520,127524999,-1894946414,558721731,108793199,-1216050594,-324008672,1131919965,1987700617,-1844229238,584218135,-2088979354,1865132667,543367457,365446184,939144996,-1230986757,1841964520,-583146415,-156870696,122907191,-2035538542,-222749179,1489855486,-110316429,40992832,-1511973135,-1393611416,695400536,1087895566,1138808270,-132616478,-266363045,-1773312863,1708866816,-1069427775,-9635906,-938640024,519144383,-479743053,-453363921,-1341300737,-948552746,-241477215,-62848854,1312172158,716906870,-1386502923,1595816344,1665976902,1201592510,76280459,459886951,-1683176862,-333581684,23658556,493652445,1631583899,-166252788,-1092003230,429734946,924087679,1024296183,-383708933,1850122600,1956173691,-1245469206,1195404701,-1519177600,1188691419,189905889,-107643938,477059954,-393063422,1989763185,1212259544,344133700,302365390,-809697645,-710691878,1484405441,183070015,-1471702830,-777496737,775326035,-1236304566,-936559015,-790782725,1115859864,-1625826199,545974230,-1394843233,279915736,156670624,-1631945791,1764674787,1632139466,78631721,2121296573,1725209298,-832022138,2071004623,1260606016,-2124734652,-2137356478,2121502593,569731049,-310578300,1341361705,1109596506,2001773313,-691231214,-379275060,-235773830,-1331446420,280986062,1740500805,799368221,-908190935,2034860483,-384767520,-1026574352,-1792605015,-1266544554,569139130,166893378,1457756038,-948485643,2100891699,28825968,-1693413703,-595242568,-1280801588,1085551080,-1445633478,1828849447,848093539,303796309,1926419758,-1234765981,-1099548020,576270359,-1468028691,784536675,-905097730,1595292538,1200275168,644740572,-550992033,1980222877,-803035096,386129896,-2055318207,1884370398,-118444063,1794943460,1502295323,964763974,508600301,-1547541631,931987530,115342634,-439320255,186348276,-857856412,-1047285484,-1894758347,-570599198,1746656493,1001410892,-315527567,-2044267127,-1016314596,-1618290781,1486101653,782002396,-210151110,516077364,-45357667,562281953,-1124973643,190179066,-1085173952,-1324326283,1772439746,975651559,-4451111,889146394,685203306,-2006674421,1918793104,-285822926,1558345509,-773274365,340070677,-2022083696,620744241,712680845,1440718716,-342335866,1583827019,-1556263142,1786124717,-1798336986,-1764549458,-162555251,380488945,-381722700,1645581913,1654037711,1706832635,233741728,-2093590979,-1595894790,-374931120,594864113,230718590,1124246088,550510360,724993270,494724113,1005840372,657390918,-601946458,608491700,-2007622984,1186534480,-150587467,13770223,-1985987156,356200608,-1061817750,1297953763,174097128,-216507780,39393294,-324019018,1295409953,2043516576,1345439099,1277315943,959340062,1811658461,-266594661,155516794,899616260,762295261,-1647145472,-472660628,234870559,-87034984,-310881294,1438748435,-1944112439,-1992157812,-2094562970,79332866,-1434353900,-956803866,1052483166,549562799,-1771080911,-1095619768,499286951,-1854045344,-1875056802,2110671280,1265018127,-571456119,-1647958400,712275589,421133603,-1696200319,1047539693,1377918849,-1197451989,-1431969100,276982921,-919949291,1529456005,-477835923,1736399088,-37510794,1995718079,1274363254,-1458546060,-1314564268,1264392066,1157172379,-2034254154,-963931094,-2127255447,-551345896,467536196,-306767133,84512531,388310069,-2111885953,823437943,-44228762,910689505,1896956211,2006433982,1086659079,250179274,1290430016,1108769346,929412042,1831188786,1123454047,1159505248,1386203945,-94589937,-1250046257,-1124801630,-1683177686,1054661595,-389040379,-2027108342,-1499655599,1261610558,947029228,-2071046800,-582874163,-1057077153,-1960996467,-1614207268,-957660429,445006928,1829343001,-1038885257,-1465202058,467419217,303605482,-841020183,339743788,1223008987,-55144208,-591848055,1867096699,-773475469,-1957377731,-1557904084,1143757412,1622371351,482752302,1955732509,-1373321947,1403910729,1677998470,-1611206836,-287662830,1558903365,-283403436,-2074005805,1386179329,1304651501,-1647152326,-921356196,691686542,1394050840,829999433,18309526,-885404592,-206576615,-1064641301,-1137282501,1229911606,1424906744,1488332018,-1829989856,274225805,-1416473398,1999995455,1493864297,893478426,1201146218,-1422260421,365494305,-287333430,-1641160301,1005457295,-1331491180,-578179503,-572673801,1441938721,-1177249348,811505168,-792446362,-1395445443,575474111,-1097584757,925578023,-292470366,-1454211221,56882675,-1103201441,-336436708,582203823,505282725,-2017514817,-262609262,90236022,1861144152,-1882185573,1720479422,-1516730753,-934937023,1720324845,-559451345,855813142,978111994,-335903030,673457844,509565446,792163746,1609819932,-1274013997,-293477667,-2145780804,1241462145,933535685,322528405);
/*FRC*/Random.twister.import_mti(48); void (makeScript(14));
/*FRC*/count=35; tryItOut("a1 = Array.prototype.filter.apply(a2, [g2.f0, this.e0, s2]);");
/*FRC*/Random.twister.import_mti(81); void (makeScript(14));
/*FRC*/count=36; tryItOut("testMathyFunction(mathy5, /*MARR*/[ /x/g , 033, 033, 033, 033,  /x/g ,  '\\0' ,  '\\0' ,  '\\0' , 033,  /x/g ,  '\\0' ,  /x/g , this,  /x/g , 033, this, this,  '\\0' , 033,  /x/g , objectEmulatingUndefined()]); ");
/*FRC*/Random.twister.import_mti(162); void (makeScript(14));
/*FRC*/count=37; tryItOut("mathy1 = (function(x, y) { return mathy0((mathy0((((Math.hypot(( + (( + mathy0(x, y)) | (0x100000001 >>> 0))), (0 << ( + ( - ( + x))))) | 0) ? (Math.atan(((Math.atan2(((x ^ (Math.log10((x | 0)) >>> 0)) | 0), (Math.round(Math.ceil(0x100000001)) >>> 0)) | 0) | 0)) | 0) : Math.fround(( + (( + ( - (x >>> 0))) >> ( + 0x07fffffff))))) | 0), (( - (( - (Math.fround(((y | 0) > (0x080000000 | 0))) >>> 0)) >>> 0)) >>> 0)) >>> 0), ( ! (Math.log10((x >>> 0)) >>> 0))); }); testMathyFunction(mathy1, [-1/0, 0x080000000, 0x100000000, 0, 0x07fffffff, 1, -0x080000000, 0x100000001, Number.MIN_VALUE, 42, -0, -0x080000001, 0/0, 1/0, -0x0ffffffff, Math.PI, 0x100000001, -Number.MAX_VALUE, 0x0ffffffff, 0x080000001, -0x07fffffff, -0x100000000, -Number.MIN_VALUE, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(482); void (makeScript(14));
/*FRC*/count=38; tryItOut("\"use strict\"; /*RXUB*/var r = /(?:\\3{3,}(?!\\B)+{1}){1}/y; var s = \"\"; print(r.exec(s)); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mta(456312848,-1485956121,1348505991,1991683326,611618934,846122967,-150860010,-24612495,-700123038,-1225600144,831612921,1027597869,410805421,931949271,-680965915,-986645359,-583893782,-641223329,-1134356981,-242273801,-1224843053,-59668081,618936747,-1078967079,2055806089,1099234980,-384507897,1090502614,-976346630,-162249656,468545863,1575282140,545641780,1771235208,-528119166,67787488,-1317112923,466947689,1679704845,-750466574,-1070380617,-99240178,-2065097204,-2116836689,544164153,1740339190,1185354533,298359388,-843378003,-1564655328,1232193935,-1872807526,1318827207,1845522800,1387905364,1552440772,402950635,-1773767080,-636933078,-1173045153,260303836,65574645,528313394,-819079041,-1228000064,890581347,453827357,1504324744,-74390056,-387872031,957397944,268829617,-998148132,-908185221,-1093462250,-1002028394,680250094,-869389773,1001976022,-537648445,1427958990,709257963,-1795691506,508279506,463935813,-1888689406,1370573047,-352135202,37424267,-614106092,1031631374,-744791222,749094356,-522562218,-1631043153,-1263661313,348647545,338342652,-1367781942,1929474247,-1696856890,-1124390827,829015530,217122298,-1176036910,-770498756,1969927626,-510354383,-1929680654,1809653322,-493254488,1199732955,1978335550,-1848476477,-1232625569,-1805172887,741970091,491209138,971689067,2068875813,-950535784,-1210056831,-995428615,-1466061608,-1914373099,1940169391,397027253,1086114194,-456252126,-1015741390,-453367532,-852425591,1896550068,1907863935,1510769021,503477905,867297912,1899555555,-635967032,376600348,-188547552,-1608252047,183695005,-1867119442,1311152664,-1459620086,2122677215,1937380797,332245077,-32327909,-1738399528,-96150919,-461480931,-2058615229,-1911819642,-1052380774,2088022628,-1321654439,-449831565,-857496118,-1571892313,1574337434,-1799337191,-1208135229,1582049077,-1228624417,-1269350508,1097913044,-317251821,-1013189250,1536721627,902718247,-1039537301,1234059609,771232272,-1625894487,1982115376,-1057883338,-1523896290,1512290794,1325450967,1503597326,-128945009,-275526534,830993844,821316850,2102256316,1465222828,256350044,383340303,350152580,1143503645,-1971722342,-1186771241,1151329537,-1234925633,949253425,1656717798,-1277092776,-259770945,-1913326653,1899373184,624233830,-676330213,495557847,-342187075,1933108966,-1772248151,769942400,1871039355,1845038507,-906255246,-2011728113,1469993824,971410946,565302888,1772250856,1589720128,-1446438671,1415863886,-2058165544,-1220148198,248896768,-327202237,-331227289,1989959653,-1732158670,1296391844,-203986997,1879797120,1464256025,410560263,-748048219,623644057,-1939476495,1869390173,-918247249,1436014925,-347105491,-1329132117,-587611745,375871429,-1500782214,1022845157,-1478019830,-612892108,-455958196,962265718,-1812032189,356670600,-1669388154,-507226861,-717691192,-457014986,921781904,-2055560732,1642770553,-1300611371,1726968410,2146531333,626817433,1644626146,-2088490940,484854535,1828085469,-950364049,-911926521,983289766,-391368882,2123190334,494129024,480638166,697096783,1928214820,-208889157,-375661375,-1459828478,1081283816,780793356,608857386,-1690968881,-825899244,1219203501,-371715429,1481998894,-1053912433,1191899052,-18508418,1655292729,-1979829543,-1620530284,967357648,2101520143,531076685,-805330505,370094966,-666519932,-1571822861,-1237940688,-135578955,-286646856,1516447022,-505943114,673596748,-1939641966,-578189367,1443242472,1671599372,-726196960,-1243193181,-1125426291,817973836,-69288092,692615370,-1286403736,1248119916,1907571561,-1280872225,1853677057,-922077718,-732814938,-5268905,1731542132,1317468242,1155308833,-1434450325,1483782916,544150755,1534005395,833759570,-1737362823,-677007090,-1949868710,355511614,-176280276,1668471742,-342630876,1922887773,2129334860,-137311664,-823565947,2124646539,424696768,-498030011,943843149,1449251286,1486214485,-731839626,21171441,648126696,-2138244916,-966454303,-401393456,1870839130,-439603523,-1850707504,1991781984,-130369097,1527905184,-102592597,712061274,1499693032,-1243445522,1983664898,1465383377,-1159843518,-923606055,-1707322799,1294031832,388685371,1059455817,-1807921149,-917908092,-1471635247,-2043106520,75734075,-944891002,-687637694,1575589992,766980658,37590854,-878640645,-554879430,-1108069503,-974421192,1630211295,1781866361,-130976342,1237177391,167424451,-825070837,1765244716,1102915218,95153610,-1839535487,-290740517,149725881,-676503358,522300569,-138034136,-1078635101,1013364125,1931832736,2084792611,-1952942751,1191464327,-2005012659,2074044685,-1315084035,1343457847,1145398744,930134884,-1469589709,759016257,595985924,-940223365,272199984,895465120,1413510289,-1612536351,787844096,1499862779,-1510737636,379319906,815656380,-1211494140,-1814511721,796874950,-1470653272,568660912,-1657954997,1037264354,339511955,1980278674,-1345220969,1825107847,1506944288,-1838510876,-182620382,956769645,-393755124,628203789,-1924874791,-928719494,442715133,-1291411469,-606390401,-1950636584,-961550676,-786266544,-786910321,-1694632290,-2055984973,130445961,165958754,-1304123528,844508801,1107720595,2063895924,-1942716534,-1404802671,509273782,808826105,514677155,1562974461,-1554914174,-836753037,1614947271,-1583888930,-395775430,-255464584,845380420,1325643307,585238117,-1992090263,379981577,1074834898,1295429149,1549385158,564430037,1275615071,1162799848,-1147440801,-2087182727,-1753178002,1919377248,656659375,1089663576,-646760848,-2133068001,2141421842,-1251689930,-1463088925,-2075517019,-1790381560,857757720,-334007557,-2055935520,-584642254,388126204,-1329427573,1376553725,-766493538,295105758,1191682957,150783276,88166411,-2138634966,-128509043,-254253219,-883539925,-401418395,1695052887,-2068006892,-1600133969,796892332,1335422955,839368905,2050937045,-1224433928,2050934098,-741940287,340269518,803996605,1530426883,1789984297,-1206933029,345443358,387974918,1314626789,-1876485464,-667546455,158275390,1594520221,-599415897,-1634265290,144441617,-2102389771,-946506665,359849606,-1733160532,1878121769,469167866,329586267,452359691,1612694934,1783335739,1514730475,259119020,1429676215,1098747892,867292072,1576913814,1878881966,-78171307,-1423436340,-1906627845,-1768371228,-1288753888,-547718371,1018916530,1959459159,1677290357,-837863412,-1841057138,-2019111706,818103186,-1437721954,1423221879,889932217,-349772971,-379225388,1135147955,-1173904235,1642918941,467910652,91071581,202984334,361308974,-545461963,-1180893876,557029797,-1981679974,-2123085417,266129683,-1461692945,-452410507,1918794322,1895916251,2055450287,-1106090238,-787128629,2017662990,-4570360,1469963579,-1785196034,-1858251957,1256141383,1550597131,1598973193,849315153,-32188319,1177808384,-254182230,1239669712,783265591,-1502363182,-15214407,569161810,1756774258,-462068342,-657594939,1423331258,1042746403,-148973399,1579577086,637747789,1305661629,-2021704035,28433228,-128137259,276829628,2118100046,91604657);
/*FRC*/Random.twister.import_mti(236); void (makeScript(14));
/*FRC*/count=39; tryItOut("\"use strict\"; /*infloop*/for(let window in ((ArrayBuffer(((((d) =>  { g1.v1 = evalcx(\"g1 + '';\", g0); } ).bind(this)).call(new (this)(\"\\u717A\"), x|= \"\" ))))(x ? (--this.zzz.zzz) : \"\\u47DB\"))){i1.send(t1);Object.defineProperty(o0, \"v2\", { configurable: false, enumerable: false,  get: function() {  return Array.prototype.some.call(a1, new Function, o1.m0); } }); }");
/*FRC*/Random.twister.import_mti(585); void (makeScript(14));
/*FRC*/count=40; tryItOut("\"use strict\"; s2 = a1.join(o1.s0);");
/*FRC*/Random.twister.import_mti(607); void (makeScript(14));
/*FRC*/count=41; tryItOut("let ljoebw;this.t1 = new Int8Array(a1);");
/*FRC*/Random.twister.import_mta(1561517550,-300329851,-862023081,-1383129704,-1134992727,1218734635,-1710235324,-524678832,477963327,1237183598,-66573628,615246452,-757264509,-151424651,-857704973,-956372666,-657014479,-457228834,641367135,-766578298,-764427592,-1623533413,422721362,-893799781,2040818089,141638080,1994664329,310050113,-857722080,1193719787,26028584,-1206553038,355229812,-1385211894,2144749714,-1786051682,-1561685895,81141710,1164610430,-1597820636,-278898845,-1217798108,-521779995,565760591,380377846,924812436,-1069510572,-1514769804,-497533085,644572007,-2087438059,954895376,-433930520,-129739995,-1262888836,276749465,216353189,1692451447,1984329608,1972886383,-621116874,1958361965,850010986,-148671503,-572993832,-1531221592,846745575,1625385489,1311346989,-1834453841,-246836544,-2083029456,361716312,-1347657485,1346394639,457593692,-1644321885,-727751422,-1605062985,715054005,-1055052873,1445088193,1853970876,-657233118,1123588969,1246455291,-1239845482,1335203572,1607852394,2040359592,1765753853,-1893722982,-1330192972,-1446047462,1983581590,2074099712,-1906358565,-2106305299,-743944028,-512135016,1107414293,-2053901369,291165953,-1406072990,990184803,-1461361029,-1202451943,24778740,2098350601,873305183,2051967384,-1029530862,1631185379,152903899,992606222,-1441002275,-1977673523,627192389,-1948292767,1815286567,-253718570,-2124211338,-481671020,-1513878649,857473609,-2037007669,263350132,1767859346,185236528,-898450095,-351846779,1873117276,-276237179,606726857,1312786238,280486402,-23152845,-246524093,-710005576,855473665,1269473682,467976134,489282769,-6202208,2072913580,-37952566,-1290752934,-1978133762,-971100476,645569367,-1100861944,-465155715,-1902537911,108558007,1393765221,600281764,-295086627,281513267,-849754327,1182069751,-126618071,541571187,497836835,-896152073,-157278361,970126527,-1363717786,1036029400,-429181351,-1006128608,698457042,-321330915,-926623286,-35984803,2145821407,951757995,-1702930162,863595538,1995596553,-1142589463,550945289,-1331058250,-1464529144,-513865834,961134556,-1220081724,-1428256063,142547645,981746359,-278417225,-918358269,1950191894,-1087719141,1163208029,1395633611,-1123970487,-823819269,1315787543,1959967742,1322228341,843326215,1324792504,-308357285,-447480859,1389443424,1068473715,1660886433,521267728,-2140800427,159905752,-605418880,-51399926,58267330,-125427061,-938144015,1611103438,289904131,2062738446,873742809,615133985,376558256,-1072312291,-1366896974,393517241,-221869423,1918831063,1675061731,-34480428,-1776491963,2117419396,951844548,216336932,-2093294536,87402083,235202849,-1579695945,-1166102505,1353142669,-440345474,631857043,616720968,-542800562,26077675,-886744140,-1996276540,1414737145,-1897697091,1117272262,-711199009,386769681,592652493,322443981,2047899995,765233857,281521587,622713795,-955049890,1929024261,518355695,-1635062681,-1670588293,2115263664,1123063490,228134856,-1099701466,-1196378590,-40970505,-617201468,-936425413,-295722203,803874852,-1688025330,241735686,1619946966,1215507659,-1239000094,1179838739,-1798258157,718256773,1924194384,-1624854353,1239720053,-1113955061,1624213682,-578864145,365101150,1256526288,849793909,-380792098,2099148448,-1409865319,2054237568,845156945,-1936773149,736555946,1644907119,1518810377,-1437412904,1630163893,1660572804,-1029836188,1621864404,1330999802,-1681123478,592647737,-883442109,458199347,-347691737,-1780888753,-1443085147,-2135699964,2132264155,519002526,-1347358430,715649218,-33240063,-112827880,-2029413342,-1415246225,-627061401,1326476526,94475180,1558395945,892975252,238872327,-1081078490,1749436982,-155257469,-1656035474,-2073387294,-941367323,2129046478,-495111964,-2098520945,1891858987,1222354203,-733258578,1161494718,-112525766,-1622808066,-280734655,931255790,37546272,1329028020,240310958,1050489620,1174639260,692697457,-1842099454,-485739278,1610494632,1192599073,-246094746,-1537425163,562519162,1884711680,1869042005,-2037398699,-899909802,-1162843096,144201021,1422836809,1806289795,1279130372,-333361182,685763979,-420747274,758779006,-1988534268,-1682805334,1823949950,522898542,814744445,-267585074,1364290620,-439803129,1308305142,-795418052,-224538524,-1886955286,-1163901291,1013297272,-466273349,-1935895487,-111494269,1632368714,2053916962,94743777,-1112387507,-1546787207,-1106349471,-696349650,990315098,1049793785,-744624534,991287258,-271515071,-12976831,-684063991,236372932,987824204,1182012431,-1617712923,112972641,-906757618,-339467152,1596093360,-1592736088,1101585522,-1969766940,-85501404,-1267538790,2026988219,-1155692093,-1299382177,1922628143,-171414553,2053799316,-490441927,-397377765,-252797185,1104564549,-162764424,-693406427,1434999701,-1539943190,426784278,644869459,503591776,2046863649,-1145419500,-1043870474,78368442,-333485515,-260231924,-1400051515,11710890,-1587233519,962892131,926610884,859194066,1472192706,72684147,-981564638,-92726488,-1057920327,1635246541,1965433318,-1467706571,1593976746,1510630390,695479831,-1464565684,1730495442,-455897752,1446987226,-968962670,87668862,184497633,1276139567,1243141432,-1894349950,931781817,232950966,1091544012,467171352,-863961425,873040039,-1416496045,2045713495,-1844124138,931813134,-601186540,323636950,-1866231907,-174874570,-1466022720,226489902,-1696405384,-987962837,255590325,-1811765821,-36084704,-1932310423,197737653,-1803803673,-1091332789,-1328200893,-1485760544,1025594955,388715219,1931401096,1671235887,-1221939213,-2103022392,1730953625,-1394223147,1098490045,-789320208,-1895731940,-1870620553,1633366660,-18013811,-52852726,-1867603835,-1318608289,1928553157,2047184310,-1467997436,1094317505,-1915857953,921940251,396188756,-2086513832,1696144675,1468618228,-48945637,266400044,1643340540,1333752056,1013247708,1640169293,-319423634,-300695849,100802067,-467323001,682742411,-921832985,-561065607,1195834542,1860149729,1743035814,2111453138,-1402605505,-1542639940,1218411288,833420672,2054276336,900639640,313938248,1094758249,660375487,1860106227,1832249794,-1224311063,126384941,1857225805,1219004216,-1238191320,2086534099,752963904,549585612,-2006010255,-857382077,-1557463195,1131397836,-819528944,-1636546187,-2008865121,-1138718787,562483451,-667451570,1876703517,-1653963287,115893965,-1590992909,-1973230415,472299173,-1274232339,-1364776875,998631134,-158459992,-1164553855,-1342351283,616064655,160279027,-452947659,1429906239,-240952732,-1382376768,1842199800,628598583,-1444610284,-1316910845,200759677,567322163,-1012969215,-1458547569,-259546175,1956706306,-1111497538,-1878998043,386059279,338540980,670434433,1492089214,1742029910,-611718492,-1450881483,-1328058102,1443767585,843619132,-576348846,688573214,1590265208,-509333363,1761870953,-363455812,138325953,-703624834,2045957756,-1825465250,-414134652,-655649367,1790352286,935018932,472661752,616127984,-1767480952,-1641950865,1993514535,-327009203,-1599634339,-1051169610);
/*FRC*/Random.twister.import_mti(26); void (makeScript(14));
/*FRC*/count=42; tryItOut("mathy2 = (function(x, y) { return (Math.trunc(((Math.hypot((Math.sin(Math.log1p(x)) >= (Math.fround(Math.tanh(Math.fround(x))) | 0)), Math.fround((Math.fround(mathy1(Math.min((mathy1(x, (y >>> 0)) >>> 0), y), (( ~ (y >>> 0)) >>> 0))) ? Math.fround(( ! Math.fround(Math.log1p(y)))) : Math.fround((( + ( ! ( + x))) >> (mathy0((-0 >>> 0), (( + Math.ceil(0x080000001)) | 0)) >>> 0)))))) || y) | 0)) | 0); }); testMathyFunction(mathy2, [[0], '0', /0/, (new Boolean(false)), '/0/', (new Boolean(true)), NaN, -0, '', ({valueOf:function(){return '0';}}), ({valueOf:function(){return 0;}}), (new Number(0)), [], true, 0, null, '\\0', (new String('')), undefined, 1, ({toString:function(){return '0';}}), false, (new Number(-0)), objectEmulatingUndefined(), 0.1, (function(){return 0;})]); ");
/*FRC*/Random.twister.import_mti(308); void (makeScript(14));
/*FRC*/count=43; tryItOut("mathy0 = (function(x, y) { return ( + (Math.asin((Math.expm1(((Math.log(Math.pow(Math.fround(x), 0x080000001)) >> (Math.log10((Math.sign((-1/0 >>> 0)) >>> 0)) % ((Math.fround(x) === Math.fround(-0x07fffffff)) , (y >>> 0)))) >>> 0)) >>> 0)) >>> 0)); }); testMathyFunction(mathy0, [-Number.MAX_VALUE, 0x080000000, 42, Number.MAX_VALUE, Number.MIN_VALUE, -1/0, -0x07fffffff, 0, 0/0, -Number.MIN_VALUE, 0x0ffffffff, 0x080000001, 1/0, -0x080000001, -0x0ffffffff, 0x100000000, 1, 0x100000001, -0x100000000, 0x07fffffff, -0x080000000, 0x100000001, -0, Math.PI]); ");
/*FRC*/Random.twister.import_mti(482); void (makeScript(14));
/*FRC*/count=44; tryItOut("mathy4 = (function(stdlib, foreign, heap){ \"use asm\";   var NaN = stdlib.NaN;\n  var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    d1 = (NaN);\n    return +((((Float64ArrayView[4096])) - ((Infinity))));\n  }\n  return f; })(this, {ff: Math.log1p}, new ArrayBuffer(4096)); testMathyFunction(mathy4, [(new Boolean(false)), undefined, ({valueOf:function(){return 0;}}), ({valueOf:function(){return '0';}}), (new Number(0)), -0, [0], (new String('')), null, '/0/', 0.1, (function(){return 0;}), /0/, '', ({toString:function(){return '0';}}), '0', objectEmulatingUndefined(), 1, (new Number(-0)), [], 0, true, false, NaN, '\\0', (new Boolean(true))]); ");
/*FRC*/Random.twister.import_mti(573); void (makeScript(14));
/*FRC*/count=45; tryItOut("mathy0 = (function(x, y) { \"use strict\"; return Math.sin(Math.fround((/* no regression tests found */ >>> 0))); }); testMathyFunction(mathy0, [0x100000000, -Number.MAX_VALUE, Number.MAX_VALUE, 0x080000001, -Number.MIN_VALUE, 42, 1, 0x080000000, 1/0, 0x07fffffff, 0x100000001, -0x080000001, 0x100000001, Number.MIN_VALUE, -0x0ffffffff, -0x080000000, 0/0, 0x0ffffffff, -0, -0x07fffffff, Math.PI, -1/0, 0, -0x100000000]); ");
/*FRC*/Random.twister.import_mta(1363011548,679344893,1490111752,-37420601,-1154575931,-1835771833,1994840009,516282574,-820325817,1629906642,-213568622,-238097556,1759753601,94359554,-686976967,-1917668612,-918415572,2023263919,1539277548,-1660974405,-1392533242,-1369610096,1409554057,355736308,1173278117,1412877667,1184807770,1945649669,1588445120,431399682,979719754,1418855258,1823933732,-1001296547,-889041607,-858376615,-1368103470,-758617933,-1125289897,-301323580,-87012093,-803273778,-17945540,945835945,1278222984,611670617,-1750746600,308130886,181169109,-105558632,693331950,-1684681663,-1171734809,5672904,-129765244,936285249,-866282954,-537872724,-168027982,-347894647,-429124329,329917524,-292990712,620016212,-582273194,-138589291,-1533376159,-15475835,-1954221424,-1272694833,1977759679,-514436737,-147743503,1664908238,975797920,1272774170,2030435415,1507944473,970226995,286810564,-10067183,-1381874522,-378185798,-145816866,674211809,-422191381,-350649581,606325760,-1464691021,325354602,-1220196082,-13993670,1774640838,1815532568,1322186632,-38135139,1863857498,-344832870,395377109,1424851328,-625415807,22427311,-1726353747,1409985049,-333368986,1003459678,-1134263312,925840734,845797551,1339303433,1532280895,1091856170,-591407757,-1873104936,-1158346838,-879075091,1209793189,-100787892,-1197970248,-983211536,1330740375,274089654,-2070559260,-52273369,-75459849,-1423128364,-625210210,59187211,1477761520,-1002767082,-1092668983,1883380708,-1940211435,1237344894,1874816167,-610411372,1305111361,-824559392,-1997966137,343518537,2005113619,-1573718737,761724696,1015528511,428013146,928424414,674881725,-737580661,-843217319,1904350025,-1551690919,1752615507,-1503039401,-1671400403,824298398,642952256,495850757,479112238,-1185084440,1779937499,1465853331,530425809,6476185,-1008832617,500610510,2022150574,-1014316283,-1395307202,-1020754205,-558749352,-1287489804,-798053112,1229122980,-578943122,1943793954,-1213596410,-163451324,-2033588268,-1921539368,744702190,1299085284,-1510351392,-583722741,828990230,1054090453,1703086763,1823913090,-1883387655,-1888760137,1043765855,-754017276,1981435795,-1895638413,220234372,394836510,-377963219,-367812384,496982398,-427817829,-402660086,-51202056,105026887,1534475303,1063696785,-1265113766,1976738653,646069782,-940324723,-1519924383,1156645161,-1809726663,1233265824,1933846756,-2064588325,-483253703,1996207450,-443357266,-374076499,-1125717765,387241888,-1648687839,-1041955119,1284713964,-692491344,212142201,138707059,-6257700,-2093275615,1466391103,1150071402,-71858987,-1162608679,1225145257,-387181690,-1759082422,187513491,-1870823733,-1046127187,974320762,2055372965,709694117,247714835,-1474289882,-1916565170,-1950767092,-976844179,-38562088,523954870,2094205383,-593153488,-2053068979,-504479273,-605013796,-671752868,-125952197,2099524591,-104637857,-1407231006,-1025522250,-1148593722,-1151646971,-361101736,-904220227,-1320315839,-1903152222,1528998899,-2087646554,131029441,1043882627,-1457833938,902900782,184839819,338848946,714382498,156146103,-252858493,1792384078,-449049997,-1563575191,749950575,-39030995,2139517662,1202278424,2078981918,-1794034045,-795963302,1796756972,-758457224,1831149316,1652192539,1506550932,1567854241,1760718011,-244715340,1461636717,1070586059,-1592959197,-1669353798,-802456771,-696293949,325692452,495175261,1178269103,-1314601068,-448657433,-310704779,-1112308856,746731113,1616172587,-1456688968,298602604,660081454,-250763654,-1102414990,-2111235361,-737040449,1356876411,2074050278,191704918,240052401,1860574670,-105391805,-416889129,-250677754,-189119991,1672731854,-155563106,-1809999306,1130592734,1675669888,729415678,-585127660,-474830138,1561169466,-1974839540,407664376,759801430,1743896354,246846421,840257420,-879082193,-1142197446,-335426249,1328715762,-424640314,-1684429322,1221135767,1179162902,1641045199,-345318224,1180705000,-1020600124,1611274353,-1971346781,1001133451,-156253819,1584770147,-604960158,756690416,1360929620,-89149307,-1016907335,-41737962,2077936816,62750458,-1147369668,1122282358,1933519633,-269761542,1530748199,856873480,-1732098245,256957753,1083266723,2145732823,-1421863646,1506370135,-624034965,800417318,1647436738,-1034769391,-1707874660,-116107585,-131336165,1814777867,-2073350279,-238168460,-795951766,-680270798,-965912458,-1461638784,1079325923,-20550899,-364628944,-245389613,1841870620,942040871,1104660399,-1754936086,1412590978,1733082550,-451242609,1845273705,-759688381,-215222804,-488203520,1022043066,767171037,-1598946542,-1605979111,1800409435,-608950953,-519733611,-1392999310,1878590769,747064219,1124312213,2070156615,-1690648383,1853695443,-188540167,749637282,455456608,434060789,260338443,-1439162480,1841341308,-202330552,-1572179704,1185618093,1602576362,-155057657,-623532392,1589422224,146607152,-448883788,-850661506,1369127767,1377787458,1793001869,-1355869766,2014321631,1413805259,-1733400006,281284142,1431677122,763873107,284294244,-1369172732,1637227543,1527499876,419383391,2077630874,-842447512,-400259892,1954036982,101740117,1740680954,95642385,1812615477,-278441401,1441453769,232553672,-1325748435,-867606111,-2057683982,-1181813719,-1500685229,-348329241,-1591055315,-704208183,-1515395194,-1939624698,1826283977,1710439085,681323431,-1709520601,-1999514767,443056157,90535897,1157381986,-2037207765,-1572526332,623867098,1059715790,78561228,2062272696,-387725067,769793442,1485285387,-2000486523,643172330,-641774379,-1027457854,-313407022,-1321059914,1353668783,497605334,1283774469,-981823402,1513686496,-1355761234,-1904120954,-1148551981,612854659,1119665620,296849588,-370377041,-2045626143,-666449624,-1180969140,-1629513559,-782255626,-2137232478,-116492670,-895009578,629804429,1765119466,2060203741,1992301525,1484799949,1633956826,-774981761,2063917301,929400230,494609063,1810968047,-450464697,2116073482,-396520064,-2108257977,-609281010,1648446901,-273345322,1221430245,2021828843,-1810607424,186320288,771957642,1218789649,887916658,743363065,-494185634,-764688944,-1588333649,-1522786897,706390829,1979663450,512857205,-245993865,-512755872,1770367470,-1664492112,1042777331,-173376688,1693451350,-1244518939,-162472850,436689429,712602212,1897279901,1689058141,-1879997229,-147511825,-294871036,-762359470,-452025343,1217697030,1974491087,-1312604584,1953864742,586356953,1433385231,-2086826481,-611910352,-900160374,419380720,2125565402,-1779978844,384615949,30196199,794716673,929543643,-2105102334,1376905636,-1780664913,-1667319348,467980730,-1187822152,-480455863,-1429070435,-785078238,-1316332570,-938010135,1598592942,-603889199,1996073077,-19345971,-1062600770,-44073098,1505041213,1362593406,-3837779,1991090411,1930908658,-1036004147,1461382812,524634926,-1321983453,-2048049791,-239913420,528693065,1897289074,-2070504517,-883745360,-647627954,-734923122,-1548609212,-1773310837,480744641,1158519497,939840546,224690503,1354273993);
/*FRC*/Random.twister.import_mti(9); void (makeScript(14));
/*FRC*/count=46; tryItOut("mathy0 = (function(x, y) { \"use strict\"; return ( + ( ! (Math.max(((0x07fffffff || (( - ((Math.log((x >>> 0)) >>> 0) | 0)) | 0)) >>> 0), (Math.atan2((0x100000001 >>> 0), x) | 0)) ^ (( + Math.imul(( + Math.tanh(-0x080000001)), ( + Number.MAX_VALUE))) < (Math.pow(Math.fround(Math.atanh(Math.fround((( + y) ? ( + x) : (x | 0))))), (Math.ceil(y) >>> 0)) ? ( + ( + -1/0)) : Math.atan2(Math.fround(Math.max(Math.fround(x), Math.fround(y))), y)))))); }); testMathyFunction(mathy0, [-Number.MIN_VALUE, 1/0, 0x07fffffff, -0x07fffffff, Number.MIN_VALUE, -0x080000001, 0x0ffffffff, 42, 1, Math.PI, 0, 0x080000000, -Number.MAX_VALUE, 0x080000001, 0x100000001, 0/0, -0x100000000, Number.MAX_VALUE, -1/0, -0x0ffffffff, -0x080000000, 0x100000001, 0x100000000, -0]); ");
/*FRC*/Random.twister.import_mti(290); void (makeScript(14));
/*FRC*/count=47; tryItOut("mathy0 = (function(x, y) { return (Math.log2(( ! (( + Math.log(( + Math.fround(( + (Math.atan2(x, (Math.pow(x, Math.fround(y)) >>> 0)) >>> 0)))))) >>> 0))) | 0); }); ");
/*FRC*/Random.twister.import_mti(375); void (makeScript(14));
/*FRC*/count=48; tryItOut("\"use strict\"; b1 = new ArrayBuffer(28);let b = /*UUV1*/(x.setSeconds = -10);\nf2 = this.t1[11];\n");
/*FRC*/Random.twister.import_mti(483); void (makeScript(14));
/*FRC*/count=49; tryItOut("var jeepbl = new ArrayBuffer(6); var jeepbl_0 = new Int8Array(jeepbl); print(jeepbl_0[0]); jeepbl_0[0] = -29; print(jeepbl);");
/*FRC*/Random.twister.import_mti(517); void (makeScript(14));
/*FRC*/count=50; tryItOut("var b = \"\\uE67F\";s0 += 'x';function b(d, b) { \"use strict\"; return new XPCSafeJSObjectWrapper(x) } /*RXUB*/var r = o0.r1; var s = \"\"; print(r.exec(s)); ");
/*FRC*/Random.twister.import_mta(-857634290,-1156748690,-203924034,-1546435189,894962035,-1886945454,-572850396,1303260176,-1837782935,88717939,1432185963,1305176333,-1568056296,-639735400,-1653769175,-2052819709,1237087226,1109836871,-1141883367,360477718,743088399,1748007770,1692870825,1329384692,-1614980916,946531021,-1188320216,550677739,-1495052783,1894910041,-642142235,-1810762854,-41214244,-1559443031,161589748,-1913678735,-1362088938,-809302844,-1841592618,690714912,966048432,761808988,-1343775098,-1992883970,-215874004,1603676615,-780095463,-1934980325,1770982926,2033087652,-2076988773,1786313384,566057971,1730819110,-636439904,1576593537,-1573839298,-1831171947,-1731114387,-332475391,773176528,855100309,1047529503,-1044198932,-1220754468,-963016537,1450963504,-1987372823,1178636490,1517772585,254723123,162305088,-793488950,-888005223,-2143119221,703194098,-652024550,-535710485,537926469,1017202800,-570363614,1859267520,2126706358,-1981588403,753988225,1321293394,2000589530,-1300758200,1293745657,1632201791,-1753811864,1493267137,1855767047,-1348107199,-2122073477,-1372367240,-142926193,1066468839,-1691027082,-453272400,-1005883042,-654270580,913798533,1814666579,-220761215,-1867306370,-534911364,-1531234549,-60940785,-1525464972,-916042438,826630791,-1871995196,-454994791,1645877248,744158331,-1134336252,-1522384674,-1474982866,-618003687,1629402801,2022102063,-1850112871,-1136081303,888297392,-1131368144,-1546665937,460319070,1063672876,-1382677036,-1660454475,-519744417,-1933728577,746688459,-161353148,-1649620790,-925366106,-1783529127,-1414082928,920465302,-2096443416,2024823814,-806473775,942535519,937787670,1872696287,1634189770,1585807452,1156949204,-1563192738,-1731423828,-1800561535,644801726,-1174465873,2058158030,184969197,811651812,-385548636,-1997312796,125110259,1620492121,-2093055482,-1835076240,1073572730,1492071306,926700942,-1587575952,384848810,-1110030850,-1129341061,547603330,286335261,-1619247633,228091063,958916186,776949293,-1057391131,-1656935332,-1670839043,1044907522,1817010986,1651872254,1314420614,-2018614446,-2070454389,20770714,475063457,-1934836192,1406060639,-1256589362,-102676820,666540126,-1513319925,-1592377198,2088781419,-998012010,-2032618154,-184539844,-1342270636,142668681,619788209,1947881842,2078577505,1140779408,-1294571761,-326864986,-866323342,-1196685667,961537158,-1006452769,2072271230,-2003421615,513670579,421697527,1694428644,1138697893,1766076082,204003602,-1829793634,1139066049,1514679027,-268109187,939204889,-1705529814,-1523702588,850706601,-2010269946,1046124494,-1723124901,1460350731,1736575672,-925653896,-1141803375,-1773552895,-1859124858,54765523,-57432966,139728470,-377316992,782722453,1203188558,-1988267078,-1018842716,207661052,-1177734738,-987105931,1524695373,-1960078029,1180885570,-1086338096,-1497146176,-230341470,1401947235,1545343850,-951581245,51008481,654157224,-1193915074,-908779655,959319937,-701379963,-173784587,1279389326,-375900729,995811810,-1812790395,-205232865,-1082115282,971363403,-183564143,364742500,-113561483,1255958422,1278168093,768928773,484818985,-759643838,1281213552,-1523982016,-2040275782,417926473,-104588628,1611511566,833697184,-90324808,-312647525,-984892867,1485255506,-1698545209,311827029,1987296867,441271646,-30576387,-1526979111,258229331,-808546428,340297844,-30160526,-73689474,-1728018472,1557876328,978801283,825983032,847992374,262440590,2127157889,-202841189,1998727912,2051306396,908385920,-1706075686,343286204,300182507,-1356681366,1098408520,-1134270437,1552339788,-1832885309,-953239994,1508887776,175560767,1796762063,-692834949,338595668,1313401728,-1603674951,-1359654485,-1514484303,-386873524,600541818,1118194137,-2096224542,-30020253,-449262086,-392360841,-352662236,-1762943003,1463137295,676316481,749603980,-1189810940,-1928180156,1271119746,-1891948697,-393309659,1434040890,-133279854,-922867703,1295235703,-225864467,-1646414325,-570430633,547868862,1729198645,-1187989181,-917226814,-2140241691,-880119987,-913685003,685952034,-734485560,-2002754865,-532566382,-922306597,-2004892985,-893084885,-1773532479,-1258344939,-1943649718,-697875755,-1388027875,-381329579,-690026415,-945957506,1260751565,-1323719392,381542196,-820632897,-1514836640,-1638989207,-186195487,-1624349618,-300209345,-545404354,1916393927,-267024418,1865570630,187649344,-536334787,-957455952,-958447148,-24856877,1109282710,1090052294,1611925540,953009842,88919155,722544119,2064127964,-1394973900,-1508008273,-690944847,-1642334381,-1184069869,-330407460,-1038314208,-1315063245,2081710755,-1419871443,-1560752140,863813926,1830637598,1463856547,-224078106,65514290,-347624758,295914930,1836357139,-913524120,111521704,-146733117,1897045467,1365550515,403848204,-535024908,-652295446,829990061,1976831797,-1907921413,1411792020,-510175156,-541281213,-2082849810,-939363734,-1976348857,1609175865,902271659,1384904287,619774536,151680366,-64869689,-673962146,1334318008,556149157,646057331,488948712,1268529907,1299849329,432489641,444516139,253803226,-1731906551,340812317,-62917280,1147570613,55293102,1693153398,-61666321,1742617661,357199725,1706320058,-1747042334,-2110373734,62891125,1257835439,743265099,-454460573,-1423837470,1088484723,827215903,1589040191,-202963,709637454,-250598204,107819071,-764987890,1650430647,1929358353,1778339729,1911430098,-966920928,-1771399615,1369303436,963205327,-1165946152,-190776539,-1806214364,-2134850476,1089414447,-785899117,-1162660302,-1903298729,-225305116,-2056486410,-417257483,-927283005,-69507590,-1426629703,-611944354,666953062,1538724042,1788107206,-668447073,435405916,1828952730,-1376704230,731730738,-1024941594,-1779990984,1019239592,-405386965,-1842209725,-1391241910,-1177779844,1037348153,1360000990,638374048,-769845806,-1205471125,1264967620,-1806812108,-1098141901,725896993,268061351,1770449150,1466675286,849022244,600511085,242849859,-384273340,1599920177,-410218357,1226002666,243701430,-764686782,1884183292,1940479056,-1924216801,-1456721429,194129874,537753417,1883098087,-716076301,-1792566716,1498865099,187388687,1662021325,-1674140966,-893653461,-1509697845,1626102691,1076626776,1718791711,-1809814525,-675098726,1796302177,1491330125,-1767025652,-1775067184,1605780850,1315307659,1986887361,141094668,-505557017,1047665830,-1010817122,1222919695,449082940,-1779183256,838431121,122297300,1530003069,-843067934,-1781714678,-1378715060,21767311,-841920000,-1758568231,260126862,-1186398062,-373882902,999019377,-937991485,-379161545,1483490629,-2017126125,1695589631,-928972524,1611054004,740298883,-1583553590,-793055436,935831296,-101826282,66530850,1850877615,1879282924,-854548542,-1746214674,588068112,-284813759,-305167804,1397212554,792098509,1996584966,-835184082,-1846695938,1970552879,1154501201,-1765625819,162849093,1253241726,1800829660,177985438,1738387687,-1978608262,-1757975278,351356750,702532716,-107990483,1559923415,-5310376,-1986446327,591137140);
/*FRC*/Random.twister.import_mti(104); void (makeScript(14));
/*FRC*/count=51; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return Math.imul(Math.tan((Math.fround(Math.fround((( ~ Math.fround(( + (y * Number.MIN_VALUE)))) - x))) >>> 0)), (((((Math.fround(mathy0(Math.fround(((Math.fround(Math.sqrt(x)) && (0x0ffffffff | 0)) | 0)), Math.fround(Math.expm1(0)))) >> Math.hypot((x ? Math.fround(( - Math.fround(Math.atan2(Math.fround(y), y)))) : (x >>> 0)), (x ? (y >>> 0) : ( + y)))) >>> 0) > ((Math.log((( ~ y) | 0)) | 0) >>> 0)) >>> 0) >>> 0)); }); testMathyFunction(mathy1, [Math.PI, 42, -0x0ffffffff, Number.MIN_VALUE, -0x080000000, -0x07fffffff, 0x100000001, -1/0, 1, 0x080000000, -0x100000000, -Number.MIN_VALUE, -0x080000001, Number.MAX_VALUE, 0x100000000, -0, 0, 0x0ffffffff, 0/0, 0x080000001, 0x100000001, 0x07fffffff, 1/0, -Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(414); void (makeScript(14));
/*FRC*/count=52; tryItOut("{o0.v1 = (p0 instanceof p1); }");
/*FRC*/Random.twister.import_mti(447); void (makeScript(14));
/*FRC*/count=53; tryItOut("var b = ((uneval(new Int16Array(undefined, 9))));yield  '' ;");
/*FRC*/Random.twister.import_mti(536); void (makeScript(14));
/*FRC*/count=54; tryItOut("v0 = Object.prototype.isPrototypeOf.call(h1, o1);");
/*FRC*/Random.twister.import_mti(551); void (makeScript(14));
/*FRC*/count=55; tryItOut("mathy3 = (function(x, y) { return (Math.min((Math.fround((Math.fround((( ! (Math.max(1/0, x) | 0)) | 0)) , ( - (x | 0)))) | 0), (( ~ ( + mathy0(( ~ Math.hypot(( + y), 0x100000000)), ((Math.hypot((x >>> 0), (Math.sqrt(y) | 0)) >>> 0) - (y >>> 0))))) | 0)) | 0); }); testMathyFunction(mathy3, /*MARR*/[(1/0), (1/0), (1/0), new Boolean(false), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), new Boolean(false), (1/0), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), new Boolean(true), new Boolean(true), new Boolean(true), (1/0), new Boolean(true), new Boolean(false), (1/0), new Boolean(false), new Boolean(true), (1/0), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), new Boolean(false), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), new Boolean(false), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), (1/0), (/*RXUE*//(?!(?!(?:[\\D\\D]^?)\\b|.s{3,}*))/gi.exec(\"\")), new Boolean(true), new Boolean(false), (1/0), (1/0)]); ");
/*FRC*/Random.twister.import_mta(784003549,657847885,-1880119002,-1053784078,-496478595,1201686731,1245848974,389578270,129705211,1024053606,-289997024,517642539,139036289,1595450847,-1871574883,1127893298,876661777,1423195247,-1696656680,-622548576,399077281,-1205374637,2068080377,-45997533,-1129201163,1343950590,1599760572,-1112011474,1895329021,125793234,-931172148,-1906326693,1620716453,-107833163,1764822605,110722690,1475253302,32265229,2069158834,-411723434,2059844774,701723831,1066650250,11158953,867767365,811243308,-270219189,1889658241,2137175308,1501951518,-1324317636,736678377,-499136112,-1398846939,-294068349,1018539295,-1884686152,230548482,-1679003283,-825528793,46703261,1167196916,253089129,-1442731106,-783574387,-1340668815,-1366744289,1948849472,990789207,-1347991665,1834603165,1882025284,423246317,-1523886866,-204781795,1627493869,-6604339,1970636931,-203360356,1240395074,117769350,-753150673,-1655722494,-1587049005,909095013,663725215,1040986833,-1763128581,1891690640,-1921775358,297694333,-133779389,361902376,-1715317401,1652892413,-1997196049,-1459069722,-1191481433,948409620,823071040,-1741212443,334991250,-2006525462,-1933746070,-46619872,759499958,-986684747,1133936024,2020709443,-599594099,1523583341,-1283221881,1696002514,377881816,834159887,-1482611880,-324015005,1259316912,-597266428,-985691887,-487708051,823827173,1329696349,1340876388,709471340,763970226,1253497367,-648022392,-1762154329,-681098176,1813446779,-734925483,1107333193,-1583249468,-1036033493,-601105470,1545817334,-1945404667,1297016944,1175719448,-983478491,1115659514,-1453185074,1468724695,57415812,619639892,515492123,-2023505280,-1536346392,1936064572,1064162840,1765631693,-1114379526,-205146287,798962036,1861493048,1882706027,-1621725622,-2047217640,-381673603,-554387464,1915248790,1435084641,-1423475618,-150035700,-1850650056,734084823,-1379775052,2057697059,1526370382,-1693895395,387205154,-84505363,-1740807195,-959446534,-19256749,-2140522893,2120029089,195434564,-633687211,-1285619802,1752381439,1686805921,1050335567,-2147022319,-608932455,564816928,-473802860,-1155084935,-1129692078,-1128014778,674693980,-481233282,-934681277,-1016804918,-1001557561,-1700480860,11080555,962077237,-987184400,1562404063,2086829124,-2044903163,-1529445147,-910208782,-356803411,1722732133,3579245,-1471542497,1462127176,957231456,2020499107,1220778251,-976392588,1760035188,1547238527,1770322278,-1689556146,-434337949,-1431665142,2083082766,-748607336,300996582,596523706,-402915298,699374390,-1629286061,-813248978,1288227956,906978691,1388932970,-217766734,1278312487,-2128599471,-573809732,615776002,110478459,-1802103622,-1321985861,2021113241,883565718,-358257843,-249677941,168127315,2115300403,-1680410354,1589834800,-1334451461,-2130034038,2073747971,-1623861403,-1924236036,1710537394,1177434810,1899523991,-443339091,-9918528,-1829643767,-1727816230,-623110861,1940632731,-863830658,-1497985503,-1492518287,-1389465042,3289728,2124410316,847265896,-209952967,796969488,-1147261662,320266904,144054841,1416861131,-1377920557,-46408833,-1780215805,-1736384555,-861170537,-1386561794,973893490,-525278102,-1388876524,-1325812001,104949210,758505065,-84965052,1511929873,-682131439,-811912117,382417574,427665290,-1871511195,-1449778917,1560547677,1505335513,531811502,1061461408,1643923928,-1041460817,-1126056054,-1140379279,-135780442,1377001852,1125130513,-393770955,-860086910,566438211,-477920820,1707870445,-1323314702,149310415,-1628200729,-2045104614,1447538693,1996667015,-2045001114,-1986408989,-1712949355,1919770332,1965660348,1335693334,-1162782750,29585119,464080944,293736637,-1325393293,-65048742,-1833125668,-1253090120,2010781182,-1872376178,1924489287,-90389667,-1944308159,-5821657,41722448,521327331,1326595588,-1808306167,1794965608,660842461,-1531965641,1947600805,1204098578,-2062008326,-1050912658,1060659866,-976905792,1403102993,2007247262,1323050362,241691529,-1695447284,1276700511,-635868277,-861861604,1857572370,-1843936232,-946704189,1410606792,860720433,85176481,1640916694,-1332885695,-1930701161,-2069996197,782089294,-1679532260,457196362,29628103,-1720522737,-560344222,-1235151012,-1343358883,899630586,-1531476583,-2118864888,1232793979,1301139732,1939625494,660676685,-676874671,-51921481,-62172360,-1956137,-1235270118,-1057891040,-1699514277,1470373405,1951528295,1918614712,-1662606552,1975439447,-1571124551,817837526,-1735258544,-778235280,-1677640013,-836083246,-642731388,1197615465,-1470078538,1418889106,1904883333,-590079594,1449890109,381615394,1508056875,-1077966591,440694806,1782406993,-858418490,1866092104,268879197,2030502809,2055208074,-392259941,1194754726,-1325780617,820097504,1715275971,-570600770,1609534213,-1594448598,353412706,1757096579,-391555099,1702791867,332156457,-907620139,-1593109583,-242780739,1208178662,2069617447,1601428376,1778515766,1913105936,-1287153374,550722311,1443705404,65004976,-2041361896,431551944,626364064,826475413,-89994728,-626033301,1945912429,1551044305,1440771643,-1103884669,1782235261,1990463614,-1366778081,883256537,1670696601,300872857,571342476,-614500372,-205060745,-1571061837,1501642367,2057231835,-1157039721,-317041588,888529842,533686711,-883169795,-1991665591,-941919843,1217410910,-1212152136,393598204,601543523,1897165543,-1263051347,942740488,-1389970243,-536001570,725422815,-1083833486,1045964875,-1344559701,-1385519611,-1368395186,1545976449,-1587754818,-1634372834,700341048,726274895,-1178614609,-686785793,-1713409271,-1657219833,-1763554583,-797252542,-1336751057,-1134796632,-1275645566,-177568893,383587478,-47520907,-873395065,50290735,-1571141297,-951708130,-2085659377,-83290714,1421701728,2112199989,600753245,555070099,58729231,189503157,-937560225,764998428,-656876433,-732424832,-1825458222,1372903527,995352454,-127454025,594877253,1644106196,-313310865,1444939666,-9614849,1368431009,879159712,349658408,-270754319,2121446611,1979546621,468669330,-590594233,-75433449,1519105784,-1415576313,1996787209,1742473218,-207541142,1242630029,-1019574866,-587823234,637773866,733516493,-54069062,372927610,-654428743,-1139757298,-243847992,-729835987,-1639472984,1535321414,1448925841,-1377141218,576209385,-500860051,-447562826,-2027267722,1466258958,-1897552971,1438274229,1684881537,-181236984,1617560968,-1351307252,1886045178,618771575,650686404,-143369683,-149754217,-370616227,-1315275027,-2124551581,-1247186783,-659106145,-1993563319,-1763221794,339172040,-1350421526,1969246534,-1710073237,433549611,-2045137648,2046901924,-1506944117,324069894,-402300913,1909630262,192437151,-189033689,1359273948,-1721652706,-936178731,361770794,2135537811,-1927187036,1604129989,-1285519194,421705603,1621481526,-102713752,-2111959240,1491349161,2032865502,603583464,-662773355,-1521472200,1793216220,83372914,-1868905394,852269820,1647434851,-836992614,1610503290,550475877,-1934337578,-832902098,-1674864283,-988983319,1728058131,1455933025);
/*FRC*/Random.twister.import_mti(462); void (makeScript(14));
/*FRC*/count=56; tryItOut("for (var v of b0) { try { h1.keys = f0; } catch(e0) { } try { g2.a0.pop(x); } catch(e1) { } try { v1 = g0.t0.length; } catch(e2) { } h1 = {}; }\nf2 = m1.get(f1);\n");
/*FRC*/Random.twister.import_mti(557); void (makeScript(14));
/*FRC*/count=57; tryItOut("mathy4 = (function(x, y) { return ((Math.fround(Math.log2(-1/0)) || Math.fround(Math.log(-0x080000001))) >= (( + ( + x)) ? Math.fround(( + Math.min(( ! ((Math.pow(( + x), ( + y)) >>> 0) >>> 0)), ( + (0/0 <= (Math.sqrt(-1/0) >>> 0)))))) : (Math.fround(y) > ( + (( + ( + (y ? ( + Math.fround(Math.fround(Math.fround(0x080000000)))) : Math.fround(y)))) < ( + (Math.fround(y) !== y))))))); }); testMathyFunction(mathy4, [Number.MIN_VALUE, 42, 0x080000001, Number.MAX_VALUE, -0x100000000, -0x080000001, -0x07fffffff, -Number.MIN_VALUE, 0/0, 0x080000000, 1, 0x100000000, Math.PI, -0x0ffffffff, -Number.MAX_VALUE, 0x07fffffff, 0, 1/0, -0, 0x100000001, -1/0, 0x100000001, -0x080000000, 0x0ffffffff]); ");
/*FRC*/Random.twister.import_mta(1527732617,-1678317024,-1364057557,831269221,-1111835181,-1925090447,1594800285,-346090457,-1034882779,1630596781,-1059389080,-993039180,154889009,-1955214201,195066824,1341998097,-598155104,493440049,343234377,-1466696827,1837473517,-1550057211,391352505,-139337275,238063548,-229611808,1093897618,1099047819,380575627,1283756773,915277463,-1942278218,-1240616276,611772204,-1572360976,-630177882,-771896001,1190246142,1825118003,392339813,-1661804,-1399948185,-1181824756,-690419519,468889126,682204898,-119490601,451204134,495057050,-500529146,374580544,1122214053,-1825301732,-1143688923,2036754643,1844329505,813359743,980817782,-892835051,-1141362936,858256867,-1131436825,-832593373,40532206,1666731348,-1748164817,9066363,1065834083,1673611092,-615400925,668589845,1590577620,-1680068034,657875660,-1592242825,285551233,-188243870,439003309,367199302,-1221206034,-2001449408,-478057540,699807208,-383616462,900293090,-1202290180,1034383369,-720711091,-1462372657,-1913507744,72818752,-732140662,-1135099564,-1023397138,617475591,-2087431028,1554674693,-1048895603,-1905933751,1164562159,-106361882,-1200681891,-173440585,-1946758637,1082102477,1186620144,-1439026613,-1479599407,359894102,858169975,57026195,-1987941041,1610510348,-63893651,807294449,-833948547,1711796311,628666039,864715528,-974694667,425533890,1794138737,-1261984544,1156582993,764903135,1144318307,266002433,-1282640552,-2032082097,-1188874384,1283264394,-1449631398,615918146,-322937630,-2117505008,274928296,-353339744,2101880746,-3786677,1077472602,1001683077,-1089399072,-2050407363,1718223936,-506046912,-599436321,-1064606482,-1900012534,1605412916,873363905,1364261635,150182151,940859086,-337692748,-972211116,1970065095,-1846765683,427810122,-1141611024,-1030740510,1531736482,1374230530,-255785575,-55768848,532545298,1108184065,1130067055,-2143876145,-665861329,-186241063,-453077987,-736545453,-235424422,1168158521,286392283,774849905,265216338,-1270254897,893911830,-335147150,898104767,576806214,279085734,-1925419233,1532016121,632645462,-1410109023,-582179000,-666071239,610324615,-231319003,586715449,355017329,274776531,-262777949,-1175859339,-2007439690,482675675,-358126931,-502747750,1098417841,388457977,-1795234200,-675340065,-176699126,-1963323429,1626556417,255048296,863439757,1705773166,-2033816474,1696046543,-2018076158,513166950,-1276320366,-1537689347,1063858011,-2009649395,-1689664865,569048445,159321129,-1001639387,-543297165,-1344956054,-1847950734,-243717275,822387062,1030438835,435808318,-2015980130,135183164,1118489887,349819014,837326147,-1190728794,1477616583,1803281648,21609962,570163879,326007162,657443326,-366489390,-1812512409,2052728422,276967606,2064919889,698464807,755023784,1197064411,-2118005804,-1323900997,2093667045,-783844419,-525923706,-364706814,1763396715,-1661677762,2047854714,2019399152,1456527422,37198227,1746164543,284979777,-2023033816,115912638,1401348565,237142353,1599093719,-78767761,-1539186787,-1621984883,-2035215387,-1684478760,1996966881,-42890938,-830783420,929191731,-384901164,340721626,-835572571,-1953709296,805166681,-1399171183,1935298706,-1243330403,-138432585,1342145503,-2122021580,1112182301,-2059780240,248818475,-227967687,1510915965,-150933750,-1974261040,1813520643,-990645005,388496377,-416239140,-978522629,-532854101,-622043484,2014091839,1279721525,-1218323352,1941768839,2128411536,-1183478106,141549333,825875729,878309130,-1546124978,-77883663,-812902188,2005090001,-1411901444,1345742414,-777213099,-1385511708,-2034037494,-456213787,966084086,1518162748,1367268381,1353885452,267222959,996571458,-1325967480,-490167807,-1908110520,-2084293292,-1607626191,-486755455,1966905780,1091846045,1414389118,-1515750439,619657617,445736340,713093176,1988652124,-1152458059,759777136,1172667230,670347594,1394913087,-1703188552,1002433826,-1708654298,-1894404049,1671306476,-1280558140,1229728485,-253877391,126382146,-525310015,-830533511,1165421958,1398401508,1320958246,1819159205,440932511,545530307,1807623647,-1573553090,612476473,393622397,910579467,-223267003,472121217,-203702120,-1902460943,-2022320015,242559007,-737165577,-723264985,1960059333,-1394265247,775254413,31094213,1634146125,1960204195,-1843945277,-272024047,-7962882,-522467587,-1561801870,-1893892784,-1556895789,1407274997,-981412180,298757766,-1579526923,-880901652,-664235740,-737754105,-1675057439,871807899,-1291057734,-1657803752,-1088877742,86101760,1147537080,-1375515953,-1708950012,-948602025,-413568541,-2139176203,-1531565799,1568718509,556429416,2100984986,1378369650,989373392,2026346075,-445419140,-1993921771,-1850926218,-1551025827,1297742465,-1166609043,-559351044,1326889512,-1742490589,1447909610,1207062323,1330951863,-1429245133,-2016808398,688209629,506599896,347915019,-285498328,-1000991411,545937316,108524566,1555029862,-1620729609,-1401519981,-1397751012,528071870,-1329250146,-393952743,767813643,161357336,-1508333677,-709496041,-376856896,1937573266,1818588849,700919540,2110739091,-903142566,-1085776346,-30328576,-1321517139,371810061,419972218,1862629097,-197991710,-103966139,1288619078,-61506059,-269014812,2009372620,2072441726,-2055111298,-1685419041,931900457,1762806134,504511945,190985194,816760623,-1589353655,-1937623548,-1005920558,-572964400,1049440570,214725386,500253197,-15463617,744988920,-402772383,1397304547,758657373,-1891108753,1182710881,1300045852,1019967139,-1672361159,45983392,-194502114,-2040403826,-642360563,-1926648196,-1821152434,1700792661,-1048819239,-548762844,2015696326,1013563818,1525434403,848000728,-283813893,1630227372,2012083413,384643837,-167228989,1168336745,190851540,-71990685,1013326091,1870073583,-749537190,1015205444,344389523,811524504,1694015979,-1141791024,-1410571375,-358022967,795344980,-1532355458,-200508391,-1199117423,-1944014315,1662187995,301840036,-1059116428,1919366315,-492700142,1364211422,-800389210,1932218969,236659162,-324595007,1551631981,-1199481514,1095956117,-927624464,-161706271,-1954345528,-1975167701,1045243377,-2102558912,566115677,-1197444777,-1345090344,-1931284491,74777787,700795513,-1551508283,1087287291,1453845473,47286815,-197288690,1180703587,735983677,-763047958,-1586913478,512635571,-546414952,-1483193093,244935494,511081493,1789159248,1027254334,247270817,808880209,1043140754,-413669737,-982157602,-1093110834,1539237905,-501634868,1509165481,2051435455,-1107231337,-119565141,56067969,-417383804,2100844769,1957820971,463214643,1182415630,777615030,-995990468,633757606,-1220405177,1483567960,-150292273,23070066,1275316695,466019954,-883465666,-1200021296,-1164995817,-179602870,2019329356,-1631216606,-605240575,-463645972,-401374957,903554649,1503630570,312539618,270961713,-732899496,645808447,-412710995,-306893912,-137683751,-1178760317,184063388,-1475134051,-859009554,-628215016,-1009059257,1994643601,1992763544,821073607,853551218,1718458344,682081018);
/*FRC*/Random.twister.import_mti(213); void (makeScript(14));
/*FRC*/count=58; tryItOut("\"use asm\"; h1 + b0;");
/*FRC*/Random.twister.import_mti(225); void (makeScript(14));
/*FRC*/count=59; tryItOut("\"use strict\"; mathy3 = (function(x, y) { return (Math.tan(Math.asin(Math.fround(( + (Math.atanh((x | 0)) | 0))))) > Math.pow(mathy1(0x100000000, Math.fround(y)), Math.max(x, (y == y)))); }); testMathyFunction(mathy3, [-Number.MIN_VALUE, 0x07fffffff, 0/0, Math.PI, 0x080000001, -0, -0x100000000, 0x080000000, -0x07fffffff, 0x100000001, Number.MIN_VALUE, 0, 1/0, 0x100000001, 42, -Number.MAX_VALUE, 1, 0x100000000, -1/0, Number.MAX_VALUE, -0x080000001, -0x080000000, -0x0ffffffff, 0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(398); void (makeScript(14));
/*FRC*/count=60; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return Math.fround(Math.abs(Math.fround(mathy0((x / ( + Math.max(y, (( + x) << y)))), (((Math.hypot(( + ( ~ x)), y) === 0x100000000) | 0) <= Math.log(( - ( + x)))))))); }); ");
/*FRC*/Random.twister.import_mti(581); void (makeScript(14));
/*FRC*/count=61; tryItOut("\"use strict\"; \"use asm\"; mathy5 = (function(x, y) { \"use strict\"; return ((( + ( ! (( ! (Math.fround(x) >> Math.fround(y))) === (((y | 0) | x) | 0)))) + ((( ~ Math.fround(Math.max(Math.fround(Math.cos((( + (( + Math.sin(( + mathy4(y, x)))) >>> 0)) >>> 0))), Math.fround(((y >= Math.log10(-1/0)) | 0))))) >>> 0) | 0)) | 0); }); testMathyFunction(mathy5, [(new Boolean(true)), '', true, (new String('')), false, NaN, 0, (new Boolean(false)), [0], (function(){return 0;}), '\\0', /0/, '/0/', undefined, (new Number(-0)), -0, 1, ({valueOf:function(){return 0;}}), (new Number(0)), null, ({valueOf:function(){return '0';}}), 0.1, objectEmulatingUndefined(), ({toString:function(){return '0';}}), '0', []]); ");
/*FRC*/Random.twister.import_mta(1041092235,2103288944,1558268021,952952164,-628504985,-1293293015,44331011,1644410441,786808030,-952831657,-501648209,2032348254,-1053628367,1694125452,-1010012595,2080649250,-314264297,-336229088,1748122721,1726829756,426486571,1898725854,-276186436,-43076941,-410990196,797932769,568988985,-1005426704,-122112354,-853867229,-1395464984,-590402716,2067680587,252825504,2038750424,521007720,-1490104782,-1880724254,-1798433669,1667009836,1344941595,-256777195,1590966179,1384180653,-1533964305,1308371245,1622245912,123658837,-1760697456,-1633934921,1374748237,2061961244,-1467506948,-864245182,-768541604,1260315322,-1569499747,1113439317,-322492375,-692972253,-1639504170,-1860036825,-1257775467,-933118737,-568263922,622388887,1765552906,1176777830,-819552592,1332027947,-1259491531,979744054,982087696,-1751733331,-622324107,181212958,1968801728,-2039237593,-544198363,-1719441680,1330480356,1477929470,692092692,-1514095666,810344454,539305658,-523963110,-530941211,-910237601,72690753,1733498329,1658885641,-36580786,-908861060,-173930408,1899782739,1610834964,1393819527,1758412006,1505004710,71532328,1016527648,-1529426928,-983648237,2041674075,-1096884446,637168204,731024775,-143256271,-1906929301,1807863739,710696815,-1401938243,984750148,-2108953622,-2055453157,1491476446,625446848,-1350702026,2096132473,-930602996,-1584237408,1352455270,1701449593,-1803893702,978312353,-305510731,1660824297,-793695827,86801950,87131657,-1836826795,1141316314,-1572518374,425836426,-449626890,227492236,-1460630240,-1933876116,-659649808,-1492527578,-1698765740,-1149202224,-961043007,2091455736,-369039524,2033003508,-311088294,-1565413022,151043081,849539204,-1863794542,832216929,1254347859,1077611385,-785361694,437781828,522959079,-1787457537,734405554,53130300,1944911353,-549512382,1364249914,1734355015,524111379,-1752539522,-346477219,-1981824925,-699575569,-38197289,1221415676,-973735983,1993845157,1265263801,-1187052697,-661462615,-1195529913,1878461968,-1181932097,-1355787468,-259074568,-1665072943,331337895,1877142346,-129961436,1966754711,-1286288307,-446583254,1689385457,-307058715,618543520,-917134482,1445536193,-996388329,137345676,-861088960,1728866231,-914524643,1127964816,1741715561,1914959480,1813167250,-1588123772,942204382,23238092,843250541,-651386381,544669141,323336706,1070836064,631573566,-1473404770,-196912799,1022357624,2130816241,-1746160955,2092919821,87114639,1194919379,2029278090,-2145021705,556655661,2015221758,-749466337,1055901523,-1357212164,854669972,2125917887,417732075,-2137967820,-790286812,857018455,505873872,-1761454219,458772134,-946851934,1810875683,1888751843,-760935218,1374266853,322928161,19473169,-452612788,1333209943,-437628499,1886194536,-1546650727,1909236788,772433342,436431646,1445708941,1608317346,1422628664,697790746,-155004671,-1340284642,-1862521328,-140032133,-483577507,-1575791904,-386771673,481855612,-463824403,1059957975,181920780,-704897000,-192572813,999930628,-2005550150,-1999580544,-379716221,-1351140350,1577666235,1617117815,1437890774,-1441051043,467108256,-990466415,-314441868,42661297,1567975243,850643699,562675980,-1601512623,305158425,-697280583,1718276359,-1816196961,1801796575,1750971052,707728495,513315090,739616354,-1457482696,1951912982,-1644269816,-2022311973,-1044679916,-744526438,-85949185,1072098229,-1243207717,1860790772,1722122683,-520205075,-2059820637,-1837966415,-645711959,862750865,-1272136855,-722887775,1206069968,34462381,-172592869,-1582967944,-1249130188,837187499,562106508,381566947,-1793506425,-660823610,-1064584062,1213872018,-840044401,1971060807,1104095074,-332423433,2075442820,-449521990,205570516,-1849192380,-1006595080,-1669806755,28599096,2091718658,1160363388,1720286577,1058809715,-1758189421,-1105339967,-722515886,-1483801676,1260144507,-1780651904,-1572839446,556763112,-979623777,2131762280,559143440,2092700315,1775526295,-1691845178,-1374781804,-877745706,780538190,1737951453,748516091,-1243995194,-348602537,912915082,-1876222028,1239719622,479592339,1673064163,503893261,1518670250,123338075,1302833995,-2106756964,418532070,-1508161505,875742092,-903723952,504133270,1104351583,-2038786714,-55510883,151866031,-1742625768,-375369891,-801608761,1071414069,1708866107,-162600122,-1006507450,1816698138,-876882166,-2095781156,-33591276,431463033,-293227806,2055343845,-71428372,408092545,1589846988,381599741,-465623798,106603760,-1703316872,877088293,1767466981,926291679,-1786552661,1108321331,-2058156482,1622864922,1684272999,122042993,-1940637467,757264106,1190579059,-449010740,-799985563,-2115144461,955943807,744977482,628919188,-612731841,1298557191,964517055,-1558769917,-1657352126,-1484095691,-570560271,2011143577,-816551466,607420784,-1079387703,1661710462,838989534,257243082,-96391243,1644679359,-636003336,237048422,-2046829914,-253732362,1945963952,-409895231,-333317842,-777707093,-1326913493,-1826308663,-155480293,-152892709,872270515,21680451,790600560,902722391,-537735576,-163472206,1632364608,-805172868,-211544675,-1398083098,341981142,773535903,-352559275,-688165462,2017486835,807426384,1822677716,-1133353916,1445772444,1918152284,107543038,-1826307282,666262170,-1758950102,-525028167,-836175841,1816187094,908857450,-1043688208,522192092,1900870947,476402331,-1043606188,-111260446,49825604,-2090805515,107935663,1065896303,240607992,227584404,-980180653,629037422,2144469092,1575377708,-563181342,2082298000,-16484011,-1821837530,-1120131116,-803139727,834875273,-411724014,-1789954208,-1320952617,-361246091,2032597275,-80321548,-628167797,-1188443371,1451788080,1330473802,-111937830,1489335201,-1771980003,-424517290,238677241,999892276,-2010042213,-182380015,-1953466285,-1072571403,1973772740,-422472328,-221994583,2074191432,-1149920761,-1755751739,1488300575,1483546126,691715878,-614353208,-628158011,-539115201,-2068391726,104952475,1317012072,6509854,-2110508722,1026155022,783647808,791422522,1301115132,-256683303,-1513759361,1204575305,698116945,1737224543,-1260554604,-130950694,-1529243400,1096284559,1247839394,61772612,1298245985,-1064277713,880940973,-953727640,-642821454,-701411216,-2121530390,1775467131,620930593,-1049403431,307182206,-1278219759,-881790566,1004645793,-753257559,1406881497,562131820,157425308,1057893686,-872824805,221100064,698809364,-894348953,1452776253,270750606,812553364,-616851096,-1487203324,-1713674223,-1317596536,-1465393020,1234887227,1761535004,-1170166392,1151997274,1001507232,-1752493608,-1176792956,-1262467466,-65165800,-345410946,1545993514,-592332073,334216756,2133762229,1533373747,-1981230561,-121057863,1692141632,-1451653618,-1060367661,-1207112410,-217250112,-2110377300,-1430954221,-169835412,-1743340440,-1307979852,597155613,2055444686,1225191137,-2026503032,865640024,-2122473336,-515263733,-1377988099,-296488112,85638632,-70334738,-706337106,-67963559,-489815339,727987317,1251016369,-1867454361);
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=62; tryItOut("mathy5 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  function f(i0, i1)\n  {\n    i0 = i0|0;\n    i1 = i1|0;\n    i1 = (i1);\n    return (((i0)-(i0)))|0;\n    i0 = (i0);\n    return ((((((!(i0))+(i0)) & ((i1)+((((0xffe6e0ca)) & ((-0xad98fe))) > (((0xd1487576) % (0xffffffff))|0))+(i1))) < (/*RXUE*/new RegExp(\"(?!(\\\\r|(?:[^]))(?:(?=[^\\\\S]){1,1})|\\\\B{3})\", \"yim\").exec(\"\\uffedKK\")))))|0;\n  }\n  return f; })(this, {ff: XPCSafeJSObjectWrapper}, new ArrayBuffer(4096)); ");
/*FRC*/Random.twister.import_mta(-627968206,-1323126763,-2044788534,-2146755127,-1457184210,-278094335,1032467792,1434286684,1069665866,-2000748910,418537800,-1093140810,-30859741,-1781765869,955568994,1251363224,-1515456779,1828510236,193732897,-1176891136,501918587,-323049119,-1428586367,1253914745,1842872748,348875265,-2054992691,-1583240258,-2007322665,-1724048478,1246958786,1530810291,1686329262,247699634,13881086,-371832660,636806862,158916890,2140099824,887258484,1370495779,-2053134658,1473887176,1734446598,777225698,-2135938777,159611964,-46301485,547728095,-1039334070,1010390349,995906574,1408247414,-1226133434,-1815155217,-377818543,673474441,1544499542,1593527208,1531028669,-8223789,695664832,734200578,391125620,-73098556,1480442705,-1621066121,1908405188,-1930522730,-2062115141,-837412427,988997266,99313699,348655452,-1957792880,1458311990,-1407354202,923417789,1407301540,384450385,812574308,-714347810,-339865339,1524512583,-1821227608,906792226,-693254974,-209673720,-692940949,1865587552,-1928944971,1094379843,957328274,-1530950450,-1651779226,-821703841,602519610,-1990477401,-50640606,870486045,-113317246,-2027679384,1256468481,262659591,1718195850,-1446291758,1448025495,463106386,-2002026662,-1549452216,1970629042,-671757280,-885475521,-409496413,-712016085,1474964187,-1701644421,-492835830,1826680880,-464139277,627858324,-1902117045,1501107914,1906099285,2136654984,951372096,-1329459276,-381863417,1806467113,1089586451,1254473392,-1109504942,-1785431073,1257352542,2082053139,1185215960,-1773373474,2071220280,1122156856,2091437353,13763286,-1384965455,1603714880,966317621,479992063,454911141,-2107120839,-1452736149,2035381795,1476821453,1108665579,-1033147349,-251071593,2038783052,471481820,-1976875062,1328692766,1166223184,-730918349,1749426277,-2047055870,-286469512,2061982947,427249389,1575413324,807699102,1069422040,-1908662729,-743478588,-290046552,1533576264,1879804716,-280044499,-1793360233,1327915019,-1546233034,-713738254,1200952220,1593162600,-255640162,-509869331,1713316415,2020653064,2120980382,1423875342,1507145884,-1006058589,1224810165,2094751231,369783721,-424715610,-659064913,427119169,-412916482,-1733924975,901633940,-1784667215,-422353182,-394960297,1378369874,1573778300,-1619994553,-798523119,-468148279,-205763546,35651525,522960693,1020480089,-1850449559,-1377821948,826628354,1855277185,-1439698290,-649986892,-1794049793,327207221,102675922,911048933,1422377318,962630701,1658109514,477652071,-939778394,1382855813,-316971261,1562227791,-909609683,2093101234,609815103,-2041079472,-394687781,1772559066,-528540439,-1358713291,416374031,470407579,1682025692,-1179592218,-1752860463,265649166,89876188,-1586957771,2014617406,1528353665,-956218859,1941611669,825580563,1695349089,-71590978,-1479002866,-123704608,1110867325,1051632029,-1857489856,63468513,-799744168,-784134998,-1467480160,-1281333310,898301662,-474873090,1318030016,1123267717,-479559558,202576668,1433486588,-676854638,209503905,-2119861405,330420872,-1966620648,2045254627,1992047269,-1598394920,-672709960,-1398751954,-1880701542,-2025147686,1308404660,-1950487439,22590268,329234505,-104983849,-1586906370,-1944081147,-322187093,-1317241631,1867888451,-976409104,535681620,-1689313124,-186068403,1312231520,-1947192213,194255311,-2112767982,1604638089,-1362386881,1396527199,-510420349,-768357799,146133154,563652556,105319076,-1635931628,-2005542998,-958668202,-978858641,366288457,1755380846,-1448981944,-259796800,-1375547221,1971211408,-1554887756,-1938330639,-1362554774,-1647957261,-747813267,-1433683314,-923673555,-36829401,-1423388522,-1676152670,1793919323,-602088813,-1661079623,-2065386048,-1245808075,214192363,121902629,74047350,2130674851,378874891,634191187,-1438670364,166277679,-202126636,1164404918,222227200,-1914687350,-2042101007,-1418937927,-1870904517,-1279278081,1014444996,1603496803,1524913568,-1640623549,-30429352,-595704767,1926167147,1874064906,-720020641,-1099025760,-1049643880,-810038095,1344843603,1363845926,-828340582,1122247300,418108272,-773408050,1050194032,-310868383,1872775661,-435387557,-1089902676,-1404722433,334469683,-1281506587,1183152441,1040991885,-849225614,277362971,2053913744,-1084863140,-1617235613,-830751193,483419366,-2003707536,-620973927,567175688,1947552701,662950515,-1572119362,1302055904,-998892180,-1877775758,-1355538176,775264156,-1179692575,234588648,-358622521,-1587703855,1106806245,-592859347,407230000,2100769296,744868832,952073658,-843719749,807355580,762991924,1161597059,782811493,1543141106,2067246858,-113406318,786550653,-1005042952,1715522792,-1460334479,502712581,-1938494507,1793648602,78919267,1377488998,655160307,-1664922431,1876972448,-700641360,-9414447,1649830678,70523121,-807446852,3277290,-619598009,-285933448,-915965314,-474872788,1469344547,-367745211,840962761,2076427114,-1823765446,-711968769,1220272090,-1001044162,-599847399,681303230,1416379445,-1021696242,-464797056,-734743209,-1808689952,-1597158317,1968927730,-1617433325,-402294382,692878044,-1648454877,1964814577,695390012,714557505,1852314068,139638208,1141839278,47885327,89628623,-1223458147,780185701,36760505,257421970,-2137354552,-1800338386,105323929,1451248529,-1426279264,-1857653315,-1526456495,-1323226498,1756146848,298849899,714930959,1511347696,820128924,-666533814,1050237708,2144502335,166735845,-638076695,1452821296,-697778730,-1371516054,140576692,1731580521,-598015284,1618782038,1841623284,-1654379470,-1432772759,482688879,-1992943752,-43716154,1078746232,537598209,-1067418712,-1203681961,-1701878976,1159831946,-360942782,1492088884,1249546447,-334565054,1784290833,-1223420132,-198002125,-2119707368,-1964563844,2138963037,-1848426593,1910241337,1390690614,-1282065483,1020096725,1698654902,-1473779168,344076870,870826820,256002487,-651164558,2000936386,1938971278,-1168703572,2123205435,366781118,617978393,1257159883,-72307106,554109840,-1639186277,-1989161203,-1739648175,-755167409,37948756,1315324944,150164475,996773536,1424772688,-122107417,161416132,-1776693061,-757990265,-810883441,718146165,-1883506465,-920218225,1115054920,308827358,1600015275,1233038319,-1328843830,-135968895,-1004358603,1482651607,-2024951004,-1091237610,1296974409,-32456332,1932350662,-516646052,448399599,-116644452,-483167390,1104570360,314178971,823418968,-1059135775,-1077950541,741104471,1107082942,879139331,1201938729,2004457748,-845440959,734702479,-2067411707,647825961,-1837746232,-513136303,-1554095004,-1556431307,-764467103,1542268863,229075812,-1799314015,1022030216,1834969679,-1074510757,-1983324732,-1534240389,-918574744,1387693341,586530428,1227453692,1635884563,-1491009054,-1075068785,1644834846,-1259906286,1368596557,-1237441594,-978972822,-745427113,-1753261571,-736937033,-1244654313,1735882550,576022604,769197201,658309687,1273443812,-2105691199,-1285561148,-761383802,-1831648649,1153860811,1566481298,-443271075,639987746,488456278,-794279671,-1310632780);
/*FRC*/Random.twister.import_mti(98); void (makeScript(14));
/*FRC*/count=63; tryItOut("\"use strict\"; print(m0);");
/*FRC*/Random.twister.import_mti(107); void (makeScript(14));
/*FRC*/count=64; tryItOut("mathy3 = (function(x, y) { return ( + mathy0(( + (Math.hypot((Math.pow(x, (Math.imul((( ! -0) | 0), ( + Math.PI)) >>> 0)) >>> 0), (y * y)) !== ( + Math.atan2(( + ( + Math.atanh(y))), ( + ( ! ( + (y >= ( ~ Math.fround(x)))))))))), ( + ( + mathy0(( + Math.fround((Math.fround(((Math.min((( - 0x0ffffffff) | 0), (Math.min(mathy1(y, (x >>> 0)), y) >>> 0)) | 0) ^ (Math.min((Math.imul(Math.imul((-0 | 0), x), x) >>> 0), Number.MIN_VALUE) >>> 0))) == Math.fround(mathy0(y, ( ~ ( ~ 1/0))))))), (Math.tanh((Math.ceil(x) >>> 0)) >>> 0)))))); }); testMathyFunction(mathy3, /*MARR*/[new String('q'), new String('q'), x, x, new String('q'), x, 0x10000000, new String('q'), 0x10000000, new Number(1.5), new String('q'), new String('q'), new String('q'), x, new Number(1.5), new Number(1.5), x, 0x10000000, new String('q'), new String('q'), new String('q'), new String('q'), new Number(1.5), 0x10000000, 0x10000000, new Number(1.5), new Number(1.5), 0x10000000, new String('q'), new String('q'), new String('q'), new String('q'), new Number(1.5), new String('q'), 0x10000000, new String('q'), 0x10000000, new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), x, new Number(1.5), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), 0x10000000, new String('q'), new String('q'), new String('q')]); ");
/*FRC*/Random.twister.import_mta(-639877403,1043903093,-177670693,1814949037,587932772,1859804692,130344986,1524397990,720879148,394479190,1683771473,522301788,-49329365,-1738396855,1124853796,589847508,1804117003,280644506,1980100442,-750136575,-45272055,-345472148,1620402210,1493980022,1162873455,1689865832,847691465,-653131835,-2092835987,1696304011,1871067201,-592139345,-838420953,-472128685,1669287797,-1192307678,916218436,1141139730,-1992641920,1681951409,1249119365,-1346790694,-275789542,1068637775,-851666823,-2015651568,1138609462,493801703,-1254681019,1742296618,1760909813,-1234174424,-210755151,-106709772,1879792340,-1207553046,125130647,99282325,-624921771,-1365555978,280270286,389754254,251630325,-1967009793,-610868974,-1803000739,2005404528,-2031236861,1328741292,-129719908,200882392,822194286,-1692241389,-1599920487,-631823387,2124550643,-748832534,57417949,-932644217,685072302,-219122395,-766581935,-1951061693,4787505,-2098069896,2110695761,-1347883822,1544659968,2146978308,-121752596,634308274,2096853663,2140878483,-744374143,1410583065,1295115122,345209716,-2095491753,-2135579479,479489088,-2081262820,1144778120,72629404,1981115087,-23472085,-1430239712,1203218534,-396669201,998801461,-844192827,-540517341,2100510296,1612994802,-1934429417,1663998509,-442879141,598456115,-974830675,-1745934861,931743612,912303450,2017376547,-1843326543,820980723,-982884142,1864555032,-1643874478,1451757415,-939665043,817790438,976927792,-1725156869,-1631029007,-2046593722,-1122076041,-2109082398,-436913331,-208900141,-1524638945,1309623675,-2025689476,1419956480,-785869419,1878947143,-1659305655,237146616,527289581,705359169,-1614415284,934886005,1897632581,-1543853476,1856699128,1364415813,1282082826,-682464059,-719006679,1998425587,-1250633926,-2051832027,-914137046,-1456120601,1805899485,1574840288,-114894317,90505731,1729796696,-1964718592,915241260,2131607487,152151502,1852899368,1815791655,-759702643,1343722277,1591476730,611231975,1476609184,-168163698,-1039394266,1858268357,447043117,-1388053497,-888838186,-1883965398,406220603,803674084,-58181217,-1616190865,-1483273998,-910558592,-1192397904,-1941572060,1553161939,-28069199,1525090415,568276588,-808992888,540890197,1332176813,831642910,1322299608,-1995518171,-851870463,-1986760848,547572867,1120344729,1111699260,-1047571329,-1934518474,462553480,1918930545,1324717590,-27670479,-134883726,1223192333,5489516,-1724119945,1462160975,-1548149422,-739113433,2124453057,363516608,-1985973380,-358929746,1833225024,-813675283,1391987493,1024687837,408715369,419324352,-1975772465,-1605158447,-760940990,-841995340,416770114,190524069,-1231659802,1489702747,-6096827,299819660,1057073083,-1750302005,-788482594,-261117681,-141037172,2026315630,-1064240682,-1199269397,482694482,-1591747305,-1022367106,1813853256,-362137626,-247754647,-337617608,828344411,911608736,-2039360320,-2115752,-2070141389,-619829784,-1990487009,1888873418,1857866604,-1561415479,-1149871810,-743570965,-429821026,-353621738,-632380575,1869231604,-1752780804,674131050,1262390896,-222006136,612110151,235605039,716814543,-1277396945,1768214543,-706944160,-390926699,-663604790,-360205025,460783098,1077489544,844235574,1489879204,56099515,1773999622,-1131583198,142134967,-1421166776,-2015030006,-1175969353,1982447964,-76603352,-1732194832,1798514656,-453390648,-895782909,2105644193,-597463584,1196870408,-1425732692,-754054714,554846942,-434201242,-1620833177,2013848913,1291331314,124882713,-1107179256,-2094882521,681361969,794138186,-714025637,700362712,-2098501542,877556685,25666130,54139683,-118665466,874481857,1472455594,1592145568,1076231897,-1689160414,-1627486383,1948353908,1492036261,948068602,-866556400,-45834723,-428561923,-195606865,-1115953032,2074889176,1725186231,1453212336,-1349487058,883728921,-478353901,-1679893937,556671133,452685228,-1603068764,120155791,1695974222,-796858855,-223110185,-593442968,-1053069822,910153003,959352810,-1046308208,312470947,-1099140426,-4560461,-1971938050,-1779620080,-586830630,1245825186,492108794,252783213,294385325,1214779356,-2074235706,1374602296,-1783334652,454529744,680689089,-836673345,389870345,-2140218142,-511905253,-1892746103,-309159889,1793201728,-1524253226,478952718,1951431108,1609403855,1714955180,-742837558,-1484224109,-2121607917,-22066073,1018764563,-671006769,-1076158745,-1457365057,-1363350161,1930441773,-2117001627,858739879,931806406,2017715672,1885697786,1835370127,135803259,1214327648,-1611116423,-698379059,-670614025,-6828637,1381772172,-723713716,-1890591365,-1205534302,46579917,-809125018,-1328164143,-1979954574,83380609,-1902485311,1127691174,797205775,-71966732,2005784843,417541638,734805476,-1160934709,-400026410,1612993696,-68747055,1189829922,711134695,-120074957,1073477711,630623245,-524552904,2133261100,1273424161,844103519,-387155749,968401431,-2055751262,448297033,1298622196,-696728075,986549837,-213833448,-752562681,-1639393095,-652958549,1160855665,178399240,1091366830,511150642,152945161,2046667998,1136875538,1707869135,960111677,979045054,-2137290984,295658999,584206400,485236399,1438707383,528257291,186019265,-53551375,-2099236536,1307209042,77641948,-290837062,1546010044,-1987043103,-2076573857,1719093862,-192818634,-308653266,-1594519643,820483447,-28086127,1710103486,-236088475,1603885901,-1703430671,-1059847213,1719640558,1919322234,753110315,-772655554,-190679656,-303276654,-2014739962,-1127115615,-1177099260,-1502233739,-977002019,-1282920489,1869369281,-891546430,526823701,573408340,-183075015,487609803,659108458,1324452912,310081510,-500255752,825471809,1355650537,699873923,-1867550114,235184228,1234378458,191035868,839179617,-1057291635,-180614269,1783789055,390854571,603721509,-1518434176,-1764664653,-2016234127,-62587925,-2145317648,1795341962,488723818,-1842438993,-531539405,1485185138,-146594004,755110249,1246616946,-1695966127,2116694747,595082942,1614007412,-1053966482,34936133,1706828289,1720582618,-1574610123,-87144214,287766949,-654537555,-779594286,421486782,-1217666200,2138083906,1433748073,145983549,-1247965655,1163569710,746205476,-1254494027,-1509958555,-1258097171,-1728598864,-1048312870,-1953622897,1743178271,1091881625,-54318146,688990901,-621626573,-2050031842,-577709180,-336067126,2120118427,-268853985,1766270248,-72204435,-1014843060,417671057,-1678475050,558342438,532045915,-876311657,-25373421,449237970,-74940365,891118367,-1869325264,-22398226,-921588987,895269264,340547601,756322489,-1580265097,634493190,320845282,-1713257928,-2129668928,2043359054,-12396484,15804819,1828500898,764793616,1115571401,1397303708,1779600095,853659720,1071661126,203678442,-490874025,297571695,1570365608,512996651,-1459442668,-694286771,229017896,-72070317,-713311221,1137424734,1267686389,-30966799,-389689520,785276291,-942477399,-156339706,337228310,-97458258,-1607316156,-1035164554,-652102593,-959841526);
/*FRC*/Random.twister.import_mti(4); void (makeScript(14));
/*FRC*/count=65; tryItOut("mathy2 = (function(x, y) { return ( ~ ( + Math.hypot((((mathy1(x, y) >>> 0) >> (Math.log2(( + mathy0(( + x), ( + x)))) >>> 0)) >>> 0), Math.fround(Math.max((((0x100000000 | 0) ? (y | 0) : (-Number.MIN_VALUE | 0)) | 0), ( + y)))))); }); testMathyFunction(mathy2, [Math.PI, 0/0, -1/0, -0x080000000, Number.MAX_VALUE, 1/0, 0, 0x100000001, 0x100000001, Number.MIN_VALUE, -Number.MAX_VALUE, -0x07fffffff, 42, 1, -Number.MIN_VALUE, 0x080000000, 0x0ffffffff, -0x0ffffffff, 0x080000001, -0x080000001, -0, 0x100000000, -0x100000000, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(158); void (makeScript(14));
/*FRC*/count=66; tryItOut("/*RXUB*/var r = r2; var s = \"\\n\"; print(uneval(r.exec(s))); \n/* no regression tests found */\n");
/*FRC*/Random.twister.import_mti(251); void (makeScript(14));
/*FRC*/count=67; tryItOut("\"use strict\"; print(x);");
/*FRC*/Random.twister.import_mti(264); void (makeScript(14));
/*FRC*/count=68; tryItOut("{new RegExp(\"[\\\\xD5-\\\\uc07B\\\\d](\\\\B)|\\\\d{3,}(?:$\\\\b+)+?\\\\2[^]{1}\", \"yim\");print(t1); }g2.__proto__ = this.s1;");
/*FRC*/Random.twister.import_mta(-241248989,-604033046,-1619316621,2095060157,1064640113,1266900845,-1298764886,-1021031461,-741957924,1420907860,1573712674,1934758918,1517713408,-643762768,324201767,1661557180,-1198983396,-1291928097,-1269559074,1765034522,914584080,1607390494,-684460465,-869438237,717195570,-1417162145,256755190,813713855,-1952374342,1428991022,-239486934,-731322837,271748165,-682823894,971105820,-1141521382,1562693541,1333506145,-647558440,1423887942,778334074,-223322833,-597047375,-219047401,-1785394819,1529047254,1694429620,1354233338,-307989588,1952888974,1577500517,-367884273,1037906388,1718757208,354343932,-1555056694,-666984953,-777745734,1853326918,1912684633,-1962536481,-1880613806,-1095098528,1898409510,-2037617594,1689818291,-1855440481,-1688755417,-1094557306,135721278,471884011,2050204780,-1786831313,2108883404,1650476921,1339659795,742355591,1353096882,-190898062,-1869144262,243053030,-1187233856,683779362,1591846001,2107134342,-687835718,142046190,1301982584,280794333,-2095753881,1406630920,1261008388,926012057,1339081074,-1622272579,-1405352241,1564490665,1792691548,556169697,-886756020,2105231313,537369114,1460959873,-1152120575,1915294074,757749763,-1084334002,652362557,-1897115012,-1507783897,1462674863,-1598202329,-1856673488,-1592990957,-1599647570,-86395353,2063668100,667101605,831968833,209429766,-2031361173,895922311,1471053717,-1519942376,-1948936473,-1893517479,-1722938906,-1479079677,-898522532,-45349845,-854030256,556772235,1845734346,-1916120938,-607295968,-1780998238,-1011435128,-1414229724,1059237132,28582523,267209345,-686621745,1288884553,1833597073,1446490457,1313004036,1569035181,385719704,1975504525,-554308801,1149769543,2145842497,71078996,1668230699,-1629767783,1185098366,1199155779,-1346855312,1126621181,-1522158641,1176242723,-1958768210,1878776169,1499002472,-223667349,-377489889,-2135122914,-2032769262,1299606218,2060886652,-658432757,-967642652,1273062004,847364097,931866476,281764986,222692214,625697564,-1430092156,269816750,-1902327781,1948372719,1352650996,-682745819,733593004,-555605769,-1844439680,-1030645255,2128549056,-988550089,2040996062,1430081264,1856036238,657374535,-1917838426,-273857782,655554135,-1511346345,-1825648615,1521920582,1948348912,-140681838,-847913449,2066380798,-981797772,1524033220,815596273,-464061880,1489731248,-456414000,1990652330,719077923,1569726356,-1367255246,-1095287289,1269217859,1806813461,442374312,1058198314,925064293,284592313,516742006,-18817520,-713041901,-1259421226,1743331990,918376007,1981799058,1322901249,-1828454253,-520705787,-162254266,584131660,-729907600,-1890582534,1331936081,1341815591,-1465793456,-712255237,312019270,1596495538,-2121524067,193528659,1505203012,-919255783,-935878807,1232877297,-204894662,296517559,1588897819,-1381328420,1555108630,-1632450132,-287785699,1164994339,1241929032,1309125118,-226405814,-1417200249,-881578109,-1161036322,-465265460,-1010880001,1786423827,-956016422,-2065947065,-1543405972,1565841077,-2017048156,675686110,-2059108115,-1638506877,255090403,1096922764,1775620030,647152848,-362049978,-766323747,1794376903,-798496500,1285314280,-129033111,-814305489,880145495,-1675627449,1315639682,1797800386,-1486818931,390901200,-1973119901,1868683959,1538833346,1897778967,-761613542,1588265763,-975797976,899768618,1346373139,262813596,-1492911797,-2114582254,-2052571658,1642602723,1335105283,1159994212,-1659362159,-1071760811,1031012181,1871087916,-842176683,2023601928,-416799019,-939486914,-789671006,-2133033793,118906872,816156437,117976036,1247593001,-199337056,1326649435,131836147,-1874157236,-1639493866,1094433929,240476849,1916756735,1892941120,-160405139,755284027,237759628,1852317959,185002763,1492426655,-858740964,1842299380,-123928805,720928835,182439587,-1172682648,-1228613628,1677308285,1383036401,-1343828356,-295925452,1022058647,474098516,1551361267,133034272,-421086138,1161230380,-444205741,-272727976,1532580780,-1153413386,-358551788,755712549,-769216245,-939905139,725149109,-952319202,-1253068723,-252118029,-853752715,892646605,-1360009595,629155221,230923490,-1075471917,1174990283,549564921,-613007514,-262481276,-1894556938,382399465,-1677129889,6956452,-1421218929,177733217,380521151,757674156,-1527542917,-262316986,1952824213,-2040264939,-1981142037,2089314713,-1606214449,1282125816,-621545903,-1614951996,1060275307,657010807,1614558935,523655423,-1914081210,1628683295,-455020569,-27243879,-463793684,-1350211485,331068124,-2042626919,-10389041,-801092296,1275187338,2033911400,-1527625539,-1433497459,210587685,254144668,207314975,528513344,-689033031,434441702,-526740353,-1534560796,-143809914,1760010506,-1938914860,727657028,-1739193004,1807955632,1392966716,-705133305,936763566,969082071,-132626468,1392380884,192975599,-253132505,-181989656,625318738,-1939421506,1685697848,-172625406,555699460,1948069243,-24588584,2065935598,481658135,2061060606,1913007823,-1691672887,-864893909,-896519776,-860664702,363306173,1045081249,-237298935,1224313288,-2012211271,1174965919,-1655439489,-209029037,1408522846,-1823882465,825338657,-415426970,-1246782524,1737931252,435750816,-740278930,-392846208,-372122380,-1283527086,281629992,1753055343,-274791869,-1773558788,-2103190476,-1173430230,-227051918,1068572518,985397559,-791214637,-124411764,-547515389,-45127045,1752618197,2062276410,-1139616235,960071103,1999957443,2113414144,-2088884584,-1322969777,-868363497,-1481613873,81742704,915527697,221656511,2134279798,1691212120,-1276493430,-1566030907,-16920949,-1806548281,1037423040,-659241767,1388654521,1319963046,800030499,-612575302,331594402,-610631956,1572127890,1154215879,-1085453221,-339795902,834963641,471149096,-149020645,-2000751396,1262582701,-2048792870,43131694,2111741687,-1982290364,-1409538704,900759088,515605851,-1336418707,993119135,-1067452261,-427152806,-884938382,-1168663932,1243710877,1154403930,-605525516,-1556499754,-1935393842,-267920273,501555426,-1216040111,1713096330,1272625125,1865563024,-1251494581,24469423,900368950,1876063505,2083143498,482204240,904170248,1202473547,-767400806,-2078417096,-219679653,-2005248124,-1028656116,-979223460,-1313429290,1017654040,-1766692736,-238353757,-456115876,-672467820,895975124,-1787512294,2023836250,791166587,-1772842279,1594131110,-319273423,351155768,-1033418096,-953672172,867051863,2057104747,-475608737,1816702980,-1970164826,-526577177,-505730186,-1417292369,-503707414,637793283,-403395008,604786395,1186999211,-1341213732,-1104814350,1571047816,1310005225,2043685174,-827123217,-1178644143,-1333849709,-1309060142,177592531,2006958739,335445828,453604714,131205992,1873574149,-1933556663,-1039739070,-274007385,-1996313725,-1097027939,1306524983,782685680,1023967685,504801387,-454428346,1811575864,2170381,65548956,360736570,984291888,804333260,149589553,1848410833,-158701325,-1583034542,-709816113,36370364,1999640277,18506988,-357682625,-292713021,-2133563823);
/*FRC*/Random.twister.import_mti(360); void (makeScript(14));
/*FRC*/count=69; tryItOut("/*tLoop*/for (let z of /*MARR*/[x, Infinity, new Boolean(false)]) { o2.__proto__ = v1;\nv2 = (this.s2 instanceof o1);\n }");
/*FRC*/Random.twister.import_mti(449); void (makeScript(14));
/*FRC*/count=70; tryItOut("function shapeyConstructor(dzsrwk){delete this[\"toTimeString\"];Object.seal(this);Object.seal(this);return this; }/*tLoopC*/for (let c of []) { try{let enukze = new shapeyConstructor(c); print('EETT'); Array.prototype.splice.call(this.a2, NaN, 2);}catch(e){print('TTEE ' + e); } }");
/*FRC*/Random.twister.import_mti(532); void (makeScript(14));
/*FRC*/count=71; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return Math.ceil(( + ( - ( + Math.log1p(y))))); }); testMathyFunction(mathy5, [undefined, (new String('')), ({valueOf:function(){return 0;}}), '', (function(){return 0;}), (new Boolean(false)), 0, true, [0], /0/, 1, -0, 0.1, '\\0', null, (new Number(-0)), '0', NaN, [], false, (new Boolean(true)), objectEmulatingUndefined(), '/0/', (new Number(0)), ({valueOf:function(){return '0';}}), ({toString:function(){return '0';}})]); ");
/*FRC*/Random.twister.import_mti(607); void (makeScript(14));
/*FRC*/count=72; tryItOut("mathy5 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Int16ArrayView = new stdlib.Int16Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    d1 = (-((+(0.0/0.0))));\n    (Int16ArrayView[((0xcd471a43) / ((((-2251799813685249.0) > (-8589934593.0))-((4277) - /*UUV2*/(y.setUint16 = y.bold)))>>>((0xf9c6e270)-(0x4de7be6e)))) >> 1]) = (-0xfffff*(i0));\n    i0 = (0x49e6b04);\n    return ((((((i0)) ^ ((((0x35da02ab)) | ((0xfbeb17c0))) % (((0xf9cb7227)) >> ((0xffc00ad7))))) >= ((((0xa9e7b1b1) == (((-0x8000000))>>>((-0x8000000))))) << ((-0x8000000)*0x46e3d)))-(!(0xfeaca2ba))-((0xb4b8c2d2) > (0x3cf6ebd5))))|0;\n  }\n  return f; })(this, {ff: /*wrap2*/(function(){ var nubfin = x; var ykxoqh = XPCNativeWrapper; return ykxoqh;})()}, new ArrayBuffer(4096)); testMathyFunction(mathy5, /*MARR*/[eval, NaN,  '\\0' , eval,  '\\0' ,  '\\0' ,  'A' ,  'A' , eval, NaN]); ");
/*FRC*/Random.twister.import_mta(-1994426350,685073023,52669293,691492740,-1351438923,-1619736244,133950717,-1180499370,643398176,1474134009,-1654963522,-2018136947,542976765,-544983344,1038077121,63177422,379182729,1137640841,-1811893902,-1077293844,-661993463,-629740814,1936754554,2113990365,345857188,744870987,-766613444,-802679334,1564718777,18864322,186942486,-2081424087,539420026,-1407618519,-388109083,-757117857,852733521,1221210196,-1613064927,908950201,-733105357,162831839,-1689005766,-814239370,390659477,1081693717,-1284447180,-90112515,-1331466777,2058920943,-1180276635,1621374027,-1025374043,1115087926,-1716007844,-1289785021,-176047582,-2068726928,-201569619,264403759,1992664328,-1201661482,-851694377,1691389911,-223478490,1113362814,1010222540,-1229919177,-143288627,-2016291454,1432638041,2083011979,-393207014,714821463,82484220,2103476206,400707647,16017678,-1734571442,-1079248769,-1010594845,-1456490262,-569461198,1143472121,-1751978808,2097298504,1375320959,-324084047,469515508,-657544373,-374773739,622855260,590818249,-1606524400,-1038055929,-2002900099,1369505782,980536741,-2026187421,424205756,-2075029558,-1890100129,1544974470,735160068,-1053780616,805326596,285558523,347444124,293751712,-1356126566,-845287413,-135792445,573694228,1637294318,-126795292,-1969313319,39309521,-897408942,-2082720679,-1729142204,-1100646805,990325073,-1185945604,-380500580,-1071469016,-51324258,-237830207,-1519965771,19175568,-1379095206,1942552478,2099269752,1110173201,-1240540444,-371868409,-310417654,-1512205059,1114928740,777392819,-119155947,-111445283,-1873550357,449460700,-1285146660,311158580,-669512680,2002055558,-1083535927,-2087268792,-1126108873,1958325989,-2046585582,1515770769,505363607,-1577164493,2132171170,-1502943250,-1003228103,488112568,198031213,-514854517,958376191,432735712,891914096,-1793719926,1870033012,-717250224,968865731,-778889457,-1585051550,-1588710814,-1562857682,-1276741240,1633255133,-339510430,1793831359,-1741415896,-168013147,-1445879135,901972349,48389954,239869049,1432030861,1909493773,-256275697,-116999908,1181065937,583779304,-174829267,84130137,-466764137,-1896923242,987824111,-1222550015,2101573974,-1122104985,-1744594896,-879317575,1787387467,1438433789,-1223759232,1035241622,-1841315496,-1413492295,-738730497,-862335856,479045844,1366113949,745766403,-1615167085,-409147914,787026375,346593541,-741127962,-965675058,-2094959975,96830053,1906699076,1947432478,819411921,-623411852,1029347508,-2071508477,1533871111,-1722113164,1826331199,-1143239912,930817869,-1201679639,-363835600,1377652391,-31834221,-1253312908,1079776000,1192914721,-1733494932,1133354449,1855331868,-822532050,264855972,1179289665,-518783561,790612844,-1425290022,-1092846878,1773542101,-2043868175,156518157,1814302240,1705364372,274229078,465844338,-1040106982,704572274,-181715074,2051039814,945779175,-940594678,2136824375,2101549973,-566543281,269141189,1055566217,290554428,-1817406552,-841340393,-1047551684,-676423711,1570213552,16327059,424947432,-908434885,1623821651,-2019949589,-370565227,-2053723452,-1969653026,1440013017,1217904845,-1532222511,-413541667,1728326420,1882012599,1653010654,-477875279,-966235572,-2055556298,1029960672,609936184,595882323,1225577014,1395370610,1796327667,-898894718,-1805931357,-1381685672,922314324,1387350423,-157191695,-1469372525,1750028716,-317310126,-1012742992,896556429,-1754215527,1637558203,2015016714,-201273483,381795231,-1572835914,-289711028,-208493481,360019353,-2002831873,-1356467891,-1700377695,-615858503,1435482590,523184524,-575270085,987432630,-905587039,-943878922,-1472884371,-1538012126,657315011,555819804,643894179,1088270493,1526957760,-2048063656,1572556834,-2056081388,929895797,1649554278,-1262189326,1667225188,1375381381,-353706761,2035518742,-1989982065,1213090755,-1653747993,1970902091,234856646,-1912790541,802955490,-1114403077,141850482,-606823446,1117278186,-1208095228,-1856212152,-328017734,-801677761,-827750051,500647168,-1992468345,-1313566083,1639286686,1973531165,144797729,318354927,1716485700,-871680519,-442584922,-33284764,2141259499,1784620497,-1818078721,-1629673361,1789299318,-1617845917,-1522976595,677822137,-1012671334,810333231,-1459953398,341573778,1288457159,-1787934219,-640626928,-1674824521,1011897531,432951571,-95124053,-2098951723,-2022037897,-1922112760,1444274434,-206015078,529148270,-966730816,1135361520,1061883872,940734943,184471374,1198958577,-789239848,2100067686,679782323,1909732849,-1940669049,-267109196,-1812153632,-1790172779,-1095592452,-827480101,-788396876,1388967619,-285896483,-8800337,1266225567,177677346,-1953613560,-1479513121,2125817882,-1872859630,-1999077508,1867475661,-1156948821,144892430,-1801619591,737634924,-1870897682,-278893313,1773199891,-562958486,-1585680066,860074260,-785623347,-2125131690,-894783537,1857122888,1807206300,2096945281,1018996721,-656899430,1400424368,-2080707759,-289412071,1719357558,398216482,-84651857,351138708,306892895,-485735088,1559927803,-1665161745,-520384793,-965886204,1666602212,-75836065,1528170478,1585515106,687047609,734014079,1636025748,-1530006927,-964646258,1285591248,1860858262,-320461524,929395627,925460789,-2036497734,-1560342196,-393365057,-1439224759,1850615158,-166937393,-941112869,913216870,41437109,-1204325061,275701350,-1828474550,-134782284,-151526713,-9121401,-1359007577,817843582,-657283976,111371239,-967788218,-1094229937,-2108341567,350986871,1382375805,-1129646754,-1899878340,-1405628269,-4405573,-663059975,535955164,-1142826710,-740773841,1203684872,2089332872,-1868322224,-1597208776,1731629275,-1473724135,-1015502961,2014963119,642622084,532767981,1643629615,316390197,-1312305356,1821140426,1090753379,-2110320606,2043854399,1066598541,1695806127,-2073850121,1306558740,114669770,835319787,1547601648,360248138,1765110600,-1881265466,569662650,-1828649656,-180294959,-1806228547,-814654337,-296292278,1693222118,-786246018,-2138015405,921184123,1992959490,1707890906,514164379,-652066428,1881787949,-859346287,-1840615196,29653786,-1531751420,-720088175,1333656666,-1510884234,-191422090,2027284778,712940627,-2088720588,-916296853,-964505076,2146861224,2138388112,758661091,-1590656749,694917742,-300385006,118026056,-1882657511,1262334040,-322003836,652639553,215848759,-24234942,-1600272405,1482696798,-352893051,-2003701833,959121549,-576569285,2078013636,-2001341408,-962979634,-847373504,-994169478,-1423335521,-2003761868,-2079868636,1515382010,1444576688,-936376367,-1849989596,1929732548,926901164,-1923315994,-538657866,-1334400406,-912897993,1241848838,-1173544206,1858888815,-329150716,-209672239,2085094239,-998135412,214614788,-2210866,-2072295430,1108886653,1669324604,-679350019,-722422174,-1212136430,1056507360,640220209,959541723,209090092,-668674466,-1762916566,554031523,238469749,1730769516,754612322,624403153,-574847839,-1513760326,-1297281468,-1122331941,-957486666,-269249488,-788170274,-512689624,1316057927);
/*FRC*/Random.twister.import_mti(387); void (makeScript(14));
/*FRC*/count=73; tryItOut("Object.defineProperty(this, \"v2\", { configurable: (/*FARR*/[.../*FARR*/[...(function() { \"use strict\"; yield  '' ; } })(), /*FARR*/[].sort, (p={}, (p.z = \"\\u2CCC\")()), .../*FARR*/[ /x/ ], Math.atan2(-6, 20), (y = e), ], (/*RXUE*//\\1{4,}(?=[\\\u708a-\\u7B00\\xBF-\u0098\\D]|\\B{1,4}|\\ueB01{4,7}){0,0}/.exec(\"\\uffed\\uffed\\uffed1a1\\u0340_\\n\\uffed\\uffed\\uffed\\uffed\\uffed\")), (void shapeOf(x %= y)), .../*MARR*/[ /x/ , function(){}, 0xB504F332, function(){},  /x/ , 0xB504F332, function(){}, 0xB504F332,  \"use strict\" ,  /x/ , function(){}, function(){},  \"use strict\" ,  \"use strict\" , 0xB504F332, function(){},  /x/ ,  \"use strict\" ,  /x/ ,  \"use strict\" , 0xB504F332, 0xB504F332, 0xB504F332,  /x/ , 0xB504F332, 0xB504F332, function(){},  \"use strict\" ,  /x/ ,  /x/ , 0xB504F332,  /x/ , function(){},  \"use strict\" , 0xB504F332,  /x/ ,  \"use strict\" , function(){}, function(){}, function(){}, function(){}, function(){},  /x/ ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" , function(){}, 0xB504F332, function(){},  /x/ ,  /x/ , function(){}, 0xB504F332,  /x/ , function(){},  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  /x/ , 0xB504F332, 0xB504F332, function(){},  /x/ ,  \"use strict\" , 0xB504F332,  \"use strict\" , function(){},  \"use strict\" ,  \"use strict\" ,  /x/ ,  \"use strict\" , function(){},  \"use strict\" , 0xB504F332, 0xB504F332, 0xB504F332, 0xB504F332, function(){},  \"use strict\" , 0xB504F332,  /x/ , 0xB504F332,  \"use strict\" ,  /x/ ,  \"use strict\" ,  \"use strict\" , 0xB504F332, function(){}, 0xB504F332, function(){}, 0xB504F332, function(){}, function(){}, function(){},  /x/ ,  /x/ ,  \"use strict\" , function(){}, function(){},  \"use strict\" ,  \"use strict\" ,  /x/ ,  /x/ ,  \"use strict\" ,  \"use strict\" , function(){}, 0xB504F332, function(){},  /x/ , function(){}, function(){},  /x/ ,  \"use strict\" ], .../*MARR*/[(1/0), -Infinity, (1/0), (1/0), (1/0), (1/0), (1/0), (1/0), (1/0), (1/0), {x:3}, {x:3}, (1/0), {x:3}, (1/0), false, (1/0), (1/0), false, (1/0), false, {x:3}, false, -Infinity, -Infinity, false, false, {x:3}, (1/0), {x:3}, {x:3}, {x:3}, -Infinity, {x:3}, {x:3}, -Infinity, (1/0), false, -Infinity, {x:3}], (4277)].map(/*wrap1*/(function(){ ((\"\\u29FF\" > this));return \"\\u0052\" == \"\\uBED6\"})(), new RegExp(\"(?!.)\", \"m\"))), enumerable: false,  get: function() {  return t0.length; } });");
/*FRC*/Random.twister.import_mta(1860113017,-1691416942,1323255009,-1885417511,601129803,1406110078,217767883,-2132423295,-653689493,507065261,-349955624,1615037193,1095305123,783792260,614057037,-1359073727,-1100473165,-1156609826,-176443353,-1687167423,1389733024,-2015210472,-1917168400,-1020153052,-1109898740,224589493,-1382071092,1229675082,-325654409,-2110086722,1342508548,334369644,1635028983,-339801500,1224021393,-930812387,-1811667333,1238350880,-378914684,605453368,500566657,-508725631,257651852,-2018566287,-1703742741,401069134,1954811606,1830054218,-2026185921,-66899331,691284103,-809201961,876488829,-1021492811,-636954039,-575581832,632793637,1615280414,1626672235,245462914,1073462778,293327351,-215270096,-2118064,-1014248139,-565431325,1862645422,-872443670,-15372831,-1800909223,1136603263,-1892230972,-1920856426,1799783532,1696665700,-1155591662,-915030572,-400967157,-1077517412,841531442,305001363,35467959,-1398698516,1177972780,34550270,-1536174162,690649632,-1163964840,-1189049309,1662687024,1879498911,-1086293447,1047490760,-1263975975,-271116507,1161141829,805820591,227773597,1606016022,-944067610,1878757168,1020744724,-2071090356,-548343206,-1615156981,-159389441,-1856663834,-1709107007,-1870949320,437847826,-776456987,-2086532742,-1360715688,112144791,677033545,2131709857,-77011795,161833074,-259204794,-232057275,305152645,-1726944024,-406841855,-1071360615,716297952,1658648972,-2124629361,2142405643,-155676182,-916156726,1207238060,-721081651,1373021329,1927663420,-515400047,-1708927846,-806105150,-1161998428,1661647106,463638551,591735360,-1856645954,-792519947,1902180127,-81215859,1699946868,1705716073,1783648445,-2054717939,693113494,1774869563,1504519363,512033034,-391243950,-546599128,1129657284,1015956138,-1224461054,1809182630,-444708818,-1459903251,818253455,1733417059,-1009325073,2146789970,1654419300,152195718,-568824590,-1909345933,-1391734577,-2124231068,-1491036165,2052611176,1817348725,1049529554,-696668187,979399335,900576821,-299359794,-1305264770,-418705931,-363435246,-1371018618,-885539004,992994439,-2084699745,-1713670791,-1613106042,1379527597,-1405449261,912950753,-273829661,-1643523494,-350426020,-333045285,417156323,1811855229,1690827350,-531173309,-1250441363,-1428998637,74121638,1827975006,-306956019,138682118,577780205,1143386545,2056313825,-2116331046,-1593441893,-52739500,-1544866113,58189041,-1529917421,862668060,-1177721698,-562225976,-191803790,911360612,-2083081663,64368325,-1038430160,737745868,-518142695,-2068291092,1299416350,1777323586,-378171342,-1745361402,247935921,619948592,949025304,2028966934,716825064,1985959198,61591650,-558880296,1573708260,1137741731,16827280,2050855227,-607313754,-663405595,-934874447,-1977953127,-564746261,668786851,-1442547462,2120166316,-739695728,158667015,-914697885,1910081834,-1595553941,2083462675,1383391782,187059987,996544847,-1882199904,-824189370,152062949,163877122,-385482810,207051431,1725775598,-1748196792,301375937,-1492369981,-1780947762,1335895403,1169568068,-1877854750,-146336676,1060888251,884813638,-845130440,-1200455007,-1477394318,595488430,681840173,-2105869958,1534907014,477878287,-769732708,974426795,-1628160975,-1603888340,-1891900548,-859800712,-585441139,2004166728,828842799,877456076,1856075390,502517149,378999659,-498286184,706625302,-1541368402,-319063846,654690902,-1883608732,709816797,-1481919397,1145990741,1119869635,-744220411,-1890777906,2072259318,391311144,-772215721,2017443938,1322524029,-1613212698,-2061632765,1653567873,-555467360,1184112157,514124128,-1039171552,1693886658,1541457774,-619923864,402332585,1048125344,845020532,1318044429,-378398150,1057597739,1791076697,413119788,-1573593756,-1971694842,-469184539,588399971,-1199377491,-1800857385,-837979521,351280200,-1205303205,1137844713,-1383981151,-1959665596,-953605759,920668556,1263014086,-1803298520,-789253830,-1962506880,-198670990,1224455830,365379317,-1586544174,1472804881,-2093200282,-1105078997,-51480582,-584637632,1732862054,-1024105100,-266733558,-579911431,-1370730577,333978870,2087712997,770106690,-1866976892,-326680594,1238650538,1592117512,753203619,-1318175062,-216877889,-1425005777,2072223680,-1000839902,833422179,1498428423,-1011246370,-776767609,1185746337,1402112793,-1835503335,-2041735953,1558088442,116217710,-739607499,25221806,646284473,543689334,-537653440,-1876294907,-792501689,1815417619,1031802387,-687089577,-453308112,-694634364,-910006810,-947894431,1745974553,14450533,960000291,335028170,-1063113448,-1003796408,337957223,1575280555,-2135533221,-1497703562,1983692348,206220870,-1334980667,803044044,-1960944694,-178541849,746896899,1204438194,279793301,-1636358667,-1776680468,-689186098,-1033155666,-844608864,-259221836,627368036,-1918183200,-1062106627,-1026854246,-596698342,309653780,1051947664,-492155628,-697210306,1631923297,731531315,-1260578945,-1793214994,-884849542,-2097196783,327128695,-432326585,-1763549541,-638256033,-2109895699,163549045,-1099095462,-1119033778,-1431809468,579071024,-1401476562,1429983002,-2051449018,-1312409151,682311817,-1018169353,-765407027,1731614117,284993407,-780294716,398677632,-1581725436,22007702,-963189796,-1013195381,1457829129,-1102568447,-869498618,899592977,-746355112,1257965877,773681539,-1208863482,1719458055,-820119507,-1172337483,-1132202962,-1335304406,-622600630,-129657547,-1146360366,1684527836,604665593,-1592843838,-1524845052,2052105118,-1604239592,1033701356,1799724958,-284343722,-412135494,-1436683026,-1902724813,-1276724563,631537381,-1874671869,276388014,-2088241691,-1304308955,581838871,-1425877472,290330822,-172426693,-1248830756,-1152870132,-1690491469,-452710912,-1888701832,2015589348,-1049236017,-63774990,1387777790,-1164106504,1533137734,1919354408,1644425650,1805050845,-14054459,-1803260791,1109049326,1967712892,1358998148,1314966032,-1872228597,-345775493,2142238875,-220593690,-1982101343,-988642942,912201554,-438961169,-1993872454,2071747267,-1303157029,419482202,1414898390,86447831,-2138357192,1721609671,488012215,537308961,441889292,1408713706,-210876174,-735340515,410890412,947163059,-196515820,-787753584,882191046,268073093,307151161,1483967361,-2089626675,-1666590348,-1101399153,-1521512290,1227760044,-311048931,-313765922,761329926,-711842461,1456515575,1052388999,1051233837,210972715,-1069218854,-43443452,1941339688,33141136,-112879195,-1593092450,-1009557610,1510747588,880704781,-80433755,-960366520,1874353272,1060587916,-446951224,-449682682,1131666554,-76068607,1396383660,-385522786,1611673736,1865903859,-1720960798,1993107186,-1391159826,-1796494333,332500704,278716858,1250097780,7838337,397079698,1758821332,-731246928,-1544074942,-448809477,-1986022354,-559353498,-1439088779,-1252604630,721573922,447789384,-1853586366,1411229255,-72441553,-1789629463,1698962993,624040901,-149622878,664633782,1484939868,477023518,1150493882,728047965,1141477214,-808091188,827223052,-520066996,1496870983,1251748051);
/*FRC*/Random.twister.import_mti(352); void (makeScript(14));
/*FRC*/count=74; tryItOut("e1.has(a2);");
/*FRC*/Random.twister.import_mti(365); void (makeScript(14));
/*FRC*/count=75; tryItOut("\"use strict\"; testMathyFunction(mathy4, ['/0/', undefined, [0], (new Boolean(true)), '\\0', objectEmulatingUndefined(), ({toString:function(){return '0';}}), ({valueOf:function(){return '0';}}), (new Number(0)), 1, '0', /0/, '', (new Number(-0)), (new String('')), 0, true, NaN, ({valueOf:function(){return 0;}}), (function(){return 0;}), null, [], -0, false, (new Boolean(false)), 0.1]); ");
/*FRC*/Random.twister.import_mti(399); void (makeScript(14));
/*FRC*/count=76; tryItOut("const x = x;/*RXUB*/var r = g2.r0; var s = (4277); print(s.replace(r, '\\u0341')); ");
/*FRC*/Random.twister.import_mta(-619758643,933590857,1497862226,-1594653597,691780570,-1504858599,-1971172907,892216178,306143553,565632395,-1261588752,958032469,-1310652620,-42406715,-2109929031,1985048899,1918549667,1756050182,568653080,1173253203,1144745662,1450206445,-1049497,-923392790,156373323,-727389752,-1458706555,1607422544,1685696699,-441950238,-918126517,1803126206,-374301144,-284767485,-2080787135,832630518,-1298746322,1441804323,2039576111,591307488,1019461233,-1930428868,404778614,-951164963,-1379347872,-1398777360,-276903686,413685421,-290019692,1945077446,61215226,1774188197,-1710883787,1484519381,1004758950,1315584651,-2115656370,-2116454813,-1004581834,-845345232,-159183487,694761959,-1366134036,-284294971,1469472810,1993151681,-479646807,622451620,-2051529990,1184828641,-877138588,1935651930,-1507802002,2020311303,865269898,-750195732,-1955023651,-1862350365,-485757780,748535096,678360750,-860677956,-1688294109,-1163102931,1984966923,1889487849,-1136621842,1619280074,199092230,23789448,-1154119121,879896570,1817268837,160199927,1372556051,262006203,740805692,175673582,-1281387792,1736744758,-1645453329,-1341716861,1292259642,2111255162,-210150298,-1122878136,1636329059,-210414832,-701389254,1422951597,-826427707,793895880,455787995,1897346313,-197600783,505538161,531850111,1243703947,-2111911345,-1148816832,-207487567,2121062230,-1157618179,537919756,1617876546,-674879608,1991900625,-801133938,454934526,-1860141264,978431256,888234773,254669004,1283359864,-1003093513,478526754,-284311287,1753585371,-1064543742,344294391,-2011060121,-1745579934,-55659801,-2070265672,1761551030,-131438719,1599000691,1340118980,1289075175,-1785130639,1100434090,-565619435,12722543,1615838993,1944344795,1177856724,-1729050292,-381473113,-1931026536,1748693559,-2008787404,1205180915,1437567734,1385843759,-455339311,1381597364,297146622,-524753333,-1021417325,-2131467032,938598438,244994076,-1361558411,-436019252,322908595,132896282,-640530943,57306602,-1574096102,743231085,445868529,1746189519,-2134388886,564994458,-609981334,781337442,483911151,420554391,-284834370,-1391813412,934432844,969445343,-660937792,2079329329,-961046450,-1133835557,2028013407,-1454091649,-736516101,-1531686910,-1772122525,-1785913619,1257052578,-843203667,1452825935,287496050,286660613,737146063,-751105702,-269933208,-1663005241,589161352,507212607,1022475455,970238346,-1742052922,1574250127,61555566,-2071124767,-1670348025,174606661,301269688,1716769695,1930583290,-2017875261,1842321254,2116477130,-1863006002,-372351410,1262372170,-1128531601,357331409,-1290707219,-1314004134,888916803,1030190509,1330687353,204298750,966396829,368541558,-794919786,1997481108,-1954891580,-1369480144,-1635200980,-352176746,1357664302,991230824,2139419941,576570427,1967389828,1908331998,1574877858,1309857875,1995776835,-119396371,1628694426,-828279781,202795677,875563781,-337345662,-1216656734,-293342342,-2114442407,1578524935,-1469934064,-1448080162,1982843926,1916230742,989558484,-817412820,-697608114,1781859954,-182427815,1048083505,730289947,538437375,1377380013,-454737556,-1690795896,902143638,-1395246210,1734696261,1172790468,397138084,-1809055328,-1979646066,-1864159171,-554894978,-718739768,1857364365,1303385420,1100853246,1956150712,-1218780466,-1264696778,328209258,-643323981,86116407,-173924027,2142680501,-4378437,1502970142,1884762920,682202205,1406226673,1799044959,1437393877,-954568920,715811799,-961309412,-936210582,2138268186,1741081520,-1999943467,615511766,-81248167,-1268253025,360048618,506070532,612112192,2085212199,-580331344,857424876,324431444,231785385,1396544043,1533033381,477061872,1095338924,1825397960,-1237027355,1444866661,-1458965491,1983683097,91069070,-1428255411,-2067416863,-1437788358,-473209360,-18970106,-1314903597,-457324946,1153648569,1871012584,-2007030053,-738456867,-1239236751,75011567,-545390922,-1275384151,1893299883,623512415,1999100898,371716292,1701479427,-4985200,1240800555,361484719,1998654665,-1144941349,169383679,1433514841,1211272612,2121720954,-925875520,1657150464,-322203854,-1199147802,1943305961,-1674747923,-2004957130,883607241,579805075,1842128213,-1928623991,540654509,1615562693,798514697,-90433696,-795981246,-476000120,-1675964292,-157316047,-365591280,1008423261,687513440,34481335,1474403528,2052427094,-2088239758,364188461,-1119110686,-1770082520,1379252927,-1318854645,-340248406,1393611477,-195902605,1138249254,2137280673,-1767130627,236444159,-108834675,1635764686,1899490166,-1682566809,-2084506237,994693492,-69627788,663254713,1520057175,2038234628,425248778,-88849605,542059104,-1896890747,-1494464551,-1342460422,-1818762442,277209430,-1484636775,-625004661,10963973,-68804019,-758330485,1575232547,-147179730,-71658656,64446760,-756808987,1741519813,2048549485,-121880854,-1490395127,1348284986,-1519911009,-113135622,-76874785,-829683493,-1763405757,-340969960,1842917174,-2050796634,-562285557,-1682721332,-1026101216,1597792359,1085600928,1885881992,428850039,-2056977056,-1406911655,-1283723183,677086186,435586807,-1582440633,768416271,1039311667,-118426195,-1586395176,1952197768,506201155,-1214909597,-27806811,-1078548158,1944141813,324638145,1590618040,1997507713,542731310,-2056140113,20244938,-295035673,-15495699,566562610,2053745582,405935009,-1802195045,740427,1008809277,-34035488,-395987188,865975448,-1282857516,472315153,1795066099,-565818291,-2130842743,-1657514841,-724119250,-2141876927,1754889113,1651147635,-419029176,973860865,-1573896967,258940001,506789018,2142530914,-1115204806,-1649626637,1901034101,2108926585,-2037447509,-1771612564,-594617932,1238640484,358907206,427569724,750566331,182799064,-107157501,-1288471398,-1578972956,1915697231,1941214197,-1107319018,750602939,2067389120,1545087226,-1872066618,631436652,-14069112,1064889121,1011812548,675763658,490730868,-1533887726,-227029962,885311221,-870381085,-739224765,666589810,2139501246,1551979676,720358091,754316064,1605436270,-159873707,1793954486,-1590630112,488166063,137706632,-128375095,-1874390804,604942862,1291451784,637748548,1134384173,-1556835409,-1503192245,-1788798320,493452945,-1656457539,1321773759,635345786,-1015083367,-1058909686,11441894,449336931,-2074313155,-2093466350,746748548,461672491,-1972398377,-1652561806,-2029669102,-1319309029,1092074083,340192502,242011427,-447139783,1355515012,313547132,1729653195,-1465790326,-1402959249,1115127503,1471363804,379467231,-1298864997,217517013,-885956769,972883311,-1156000247,2073497784,-1062754398,479386632,-2045979257,31083220,1983419559,-309248006,-67804769,-417401477,-1930639092,1507948977,-841548980,1676255764,1885674718,1306224416,-1579644368,-677320164,1975031740,1830017889,660216872,161117340,1951509002,805459363,2008051643,2098082060,-775949631,1876267398,79408718,205079096,1973948053,-152064729,-1585235235,845140939,-437481500,-1493263602,-1482608061,220546237,1597445523);
/*FRC*/Random.twister.import_mti(489); void (makeScript(14));
/*FRC*/count=77; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return Math.acosh(Math.imul(Math.pow(Math.fround(Math.imul(Math.pow((( ~ (y | 0)) | 0), ((((-Number.MAX_VALUE == y) >>> 0) & ((y ? x : y) >>> 0)) >>> 0)), (Math.fround(mathy4(-0x080000000, Math.fround(((y | 0) == 0x07fffffff)))) >>> 0))), ( + Math.atan(( + y)))), mathy0(Math.fround(((dlivgj % y) ? ((( + x) / Math.PI) >>> 0) : (Math.log2(x) >>> 0))), ( + x)))); }); ");
/*FRC*/Random.twister.import_mta(-1848976978,-655291558,-894878520,737774924,478535214,-765571638,-1558953676,-244790863,-119261844,-2117024225,1178955894,599347950,476927689,-6405446,-1195756759,-648474230,755847561,-364496457,-1682920298,-1393423910,350012784,151315222,-135466685,-853255892,-1915729539,389115030,1866523949,1355958991,-535239558,-1605380903,-2105084431,-815604620,-312691594,168847514,1058868414,1666267258,189568548,48917441,1103258442,571379832,-13217564,-1216688924,1948489706,-1073677965,-1107485984,443009867,1352648751,-383293631,-498829649,-1023018787,-219468822,-725697947,-2057499203,75368612,995666170,-1395201538,1788869567,1247028721,2134376943,1139075416,-529451485,716937797,377439504,-893732915,-701360585,-1232068280,-451338575,-57957672,1173463021,1446693191,1794527212,1306428815,-1842152227,965742699,-1395277991,-578813061,1058916553,-1902740549,2005651886,1851707641,1047240703,1077103061,-1001011710,-570319513,1556069835,-163187589,1138728189,-1234710057,479431381,-294847173,-2072027216,803074660,16440835,1698276472,513003331,2123013511,1733741316,-20326864,1237958554,902734801,-832294913,2025313287,1096807519,-2076443383,-1020940457,-1736181349,1141441521,-308815946,1694999781,1658368521,511497856,-2114343052,-1191241625,-1884788836,-587396801,1867376995,254507264,971316508,803996015,-1821581838,-1026962243,-1472862054,724687430,1815036891,-1148611582,-940131493,-684292145,1928738014,887043932,1970242374,-1638927327,-1560001676,-733442550,-1881704751,-2107779214,2105410328,-890166848,1606426559,-1882511944,-1208504793,1729084177,-1192301886,-1271552759,512885741,70085183,-340325815,801470314,1195068133,58927243,1153767259,-86644771,-9771732,-357418118,63835933,-2055385567,-1726382538,-255829731,-617145999,-1545772165,570208352,966619839,-365586575,-1326776274,-1313935404,-311378329,-1948044947,-2049525378,-486337347,-904551261,-964224927,-2142724836,1060660222,840357253,-992885520,228140590,1354277862,293515889,61260017,-1472807390,1021367469,23225559,1108646266,124103185,994837482,-438450902,-1684780547,1588690123,243263408,-308438937,541997214,1162563730,819965416,1660707648,578914035,-1325031147,149490826,1985476735,337286745,-558440179,-1949954465,504939749,111095493,-810323497,-1080034984,-1454775927,1176721089,-112730876,1150181324,1353617052,-555580768,635395022,-1508418333,-255852229,1642358217,-576011742,-1741180386,91099129,-1753784169,-1567031351,718485850,-1451639935,-1736537381,-597319271,1009450672,-783877648,842413272,1464693236,-449972599,-1116853761,1308389536,-128514693,-1677344377,-1970750361,1616974922,1993589688,1178915599,-2017039648,-1014971033,692251989,874670210,-2078682896,-1123586229,-1904827502,1648966047,-1614339204,-205093759,-1317505938,-1307177155,-2128432684,-850587903,-168086589,-1556147156,-1456426912,-852310957,-173282842,-1869539401,504880651,1569026144,1282566441,-659622473,1370344907,1214051587,-1163551479,-45148552,383459529,354051365,1494840947,-970064177,-1442351218,1400911228,-1422568108,-924345895,-1174449096,-1767160088,1709997075,1799828751,1929501524,-1063679140,-1725760991,-541080842,303371547,-773671289,-1910159460,1632245741,1078076705,976780840,-1835155047,-1895347556,1076881697,-131242743,-329073301,-151207480,-1931731052,-21729322,-1497070653,205100632,-471750079,-1318061272,-301521422,1960908504,-1622787863,-1071677482,-441738513,-1304317384,1047946012,-618725666,-578809396,501655659,-1938895647,-418640756,-1172776238,587599046,-978939485,-558725048,-466605380,-1206969818,760722091,-825906107,550039910,314889635,-1038746444,807904027,654785649,1862138926,1630078779,-111163824,-2122969380,-1068261753,1477644753,2000247355,101807908,824339130,353350466,-1507852766,-283043087,-379563364,-1179459930,1264213277,-266592884,-946840220,1316012970,-1364989432,-1809515936,954845300,-1530773842,-551897890,1366635157,436024981,-2020927551,-339411507,-1924446127,806625650,-60467542,-601522259,-649345536,184991764,-2002928372,226667561,27030991,1352725688,1406373233,837664257,1499940298,-171289603,2074623711,-22533192,-2121111106,994869602,1477207401,590068256,1521313782,-948913788,1677210975,-2144627425,-659145090,-896055934,-303537050,1947301894,-1037767012,-2097865125,1914595161,-881842657,2069760241,-2049270891,473039104,-1214239541,-1175252252,309181659,-685813286,-1322713449,1652348573,-204119402,-1059297543,1975833854,1656378471,-1077298954,906478036,594103418,1590969581,-1800647414,1452058833,-744850930,-177095809,1640060566,993867082,1021642318,-469229901,1556515949,2146980160,-844553838,-1895190882,-647775704,-1757925896,-85725815,1582854784,1944254458,-365909075,313951855,2031377523,717132779,-1471665952,1163036175,-776857001,-760456826,-462142653,692863939,-1336207928,1673891157,1198825041,2143928442,1433531493,223109216,2055031220,869948895,748734161,-619331188,-1572711075,-1050503426,1482287185,582678981,338886341,-1421437511,-1697244211,-212294365,-626083215,-1007450151,-599410250,-1994145327,-1605719649,1235930365,1050180608,509367427,-226264017,56668161,1893598509,883979907,-2112729736,2141643837,963971982,-634355829,441385486,-523407034,-997811615,1642398701,-1671720506,-910507408,-1534717251,-1417764052,529013204,-1638263419,-101094377,-547530855,1576745517,1475936839,-487290716,-1139383293,1482470926,1723454673,2050097878,774412833,-204566493,-2120666528,-916469253,131288289,-1969309129,-536502897,1854235470,-1998878512,-1613860977,-791743074,611147783,-73454118,-1121479613,1788508631,35698192,571988269,-1925248109,-1540412647,-146952344,-1489175131,1098231502,-2075954698,-862564116,-380704290,-1951784854,-144337157,-1152003772,413608888,-581128295,24357534,1681437313,-444276225,1671544933,-1033067029,1863870052,-520286204,-422398334,590653673,-882889560,-1563423767,-159306699,-199886475,866991900,626355982,-1354203318,-98267369,2055138402,-1928370848,-1188783667,650201418,222725654,-830014878,-2000464921,-498923373,866517541,1153371,-243862244,-1782555803,-2127364429,-1328523016,-836043560,867496756,-1139440542,-2005692144,-2031737805,1926211681,884484967,-787194346,-1998472750,-1349139079,-1530478252,731482739,786680263,383550813,1044347655,1258052716,-812749400,1717591585,1903501769,-2124207956,1027174883,-1363344264,-1088327714,762848876,-681236823,-1096554059,-2079160339,-1881797640,1461749734,-1643672549,-1495851462,258348653,-1216383332,1479351851,-1283870033,-1814298748,620496933,1970817001,466467868,1847786650,1550302527,104395573,-1214849180,1298894692,-1996064782,2086141331,1894983529,496690037,-1411161059,428499104,1474210161,1298178338,442117032,1796580316,2101011940,-1376491154,96520070,727299836,-12437525,1159038671,-1865953273,-1285141648,-1337258404,1114192137,1740404242,-957754158,-1193424034,-216531625,1772134685,1171853431,873321002,1809369539,-1241646100,-1074809864,-1313797298,1969239958,2028065574,-1571057753,-1054661276,-1818023042,-1088619264,-1121958170,156926688,1055042819);
/*FRC*/Random.twister.import_mti(143); void (makeScript(14));
/*FRC*/count=78; tryItOut("\"use strict\"; var sbhqed = new ArrayBuffer(8); var sbhqed_0 = new Uint16Array(sbhqed); sbhqed_0[0] = 14; var sbhqed_1 = new Uint32Array(sbhqed); sbhqed_1[0] = -0; var sbhqed_2 = new Uint8ClampedArray(sbhqed); print(sbhqed_2[0]); sbhqed_2[0] = 22; var sbhqed_3 = new Int8Array(sbhqed); print(sbhqed_3[0]); sbhqed_3[0] = 18; var sbhqed_4 = new Uint16Array(sbhqed); print(sbhqed_4[0]); sbhqed_4[0] = 10; m0.delete(g2);e2.__proto__ = o2.h2;i2.next();");
/*FRC*/Random.twister.import_mti(231); void (makeScript(14));
/*FRC*/count=79; tryItOut("f0 + s0;");
/*FRC*/Random.twister.import_mti(243); void (makeScript(14));
/*FRC*/count=80; tryItOut("\"use strict\"; testMathyFunction(mathy2, [0x080000000, 42, Number.MAX_VALUE, 0x100000001, -0x0ffffffff, Number.MIN_VALUE, 0, 0x080000001, Math.PI, -0x07fffffff, 1/0, -Number.MAX_VALUE, -0x100000000, -Number.MIN_VALUE, 1, -0x080000001, -0, 0x0ffffffff, 0x100000001, 0/0, -1/0, 0x07fffffff, -0x080000000, 0x100000000]); ");
/*FRC*/Random.twister.import_mti(275); void (makeScript(14));
/*FRC*/count=81; tryItOut("\"use strict\"; mathy2 = (function(x, y) { return (( ! ((1/0 >>> 0) != y)) / Math.round(Math.fround((Math.fround(y) == (y | 0))))); }); testMathyFunction(mathy2, /*MARR*/[0x10000000,  /x/ ,  /x/ , null,  /x/ , 0x10000000,  /x/ ,  /x/ ,  /x/ ,  /x/ , 0x10000000, 0x10000000, 0x10000000, null,  /x/ , null, null, null, 0x10000000, null,  /x/ , 0x10000000, 0x10000000, 0x10000000, 0x10000000, null,  /x/ ,  /x/ , null, null, null,  /x/ , 0x10000000,  /x/ , null, 0x10000000,  /x/ ,  /x/ ,  /x/ ,  /x/ , 0x10000000,  /x/ , 0x10000000, null,  /x/ , null,  /x/ ,  /x/ ,  /x/ ,  /x/ ,  /x/ , 0x10000000, 0x10000000, null, null, null,  /x/ , 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, null,  /x/ , 0x10000000,  /x/ , null, null, 0x10000000, null, null,  /x/ , 0x10000000, null,  /x/ ,  /x/ , null, 0x10000000, null,  /x/ , 0x10000000]); ");
/*FRC*/Random.twister.import_mti(541); void (makeScript(14));
/*FRC*/count=82; tryItOut("mathy4 = (function(x, y) { return ( + Math.imul(( + Math.fround(mathy3(Math.fround(Math.pow(Math.fround((((x >>> 0) !== ((Math.imul((x >>> 0), y) >>> 0) >>> 0)) >>> 0)), Math.fround(Math.max(( + (Math.fround(( ! Math.asinh(x))) ^ x)), (x >>> 0))))), Math.fround(mathy0(Math.fround(Math.acosh(Math.min(Math.min(x, x), (( + x) || (y >= y))))), ((y ? Math.acos((Math.fround(Math.cbrt(Math.fround(x))) >>> 0)) : Math.tanh(((( - (x >>> 0)) >>> 0) >>> 0))) | 0)))))), ( + Math.max(Math.fround(( - x)), Math.fround(( ~ Math.min((mathy1((x >>> 0), x) | 0), ( - x)))))))); }); testMathyFunction(mathy4, [({valueOf:function(){return 0;}}), true, 0.1, (new Boolean(false)), '\\0', (new Boolean(true)), (new Number(0)), NaN, (function(){return 0;}), '/0/', (new Number(-0)), [0], ({toString:function(){return '0';}}), [], 1, 0, objectEmulatingUndefined(), /0/, '', false, null, undefined, (new String('')), '0', -0, ({valueOf:function(){return '0';}})]); ");
/*FRC*/Random.twister.import_mta(1326565847,998300297,-1051685972,1489913798,-88777493,-1527014427,-2139258223,1196371964,-452602466,-2027247992,1293559066,-389657861,-228196145,1247545301,-1244712211,1488336355,1455964557,327165131,630977303,-1604400875,372570084,-605383667,1278001021,2007547009,248131652,2132465694,1674431550,-730320514,-530376336,1745936367,74769263,836420714,985789495,1258254906,1021639773,2145059494,-1415063328,205649780,-904754768,-1646691025,-1696599924,575153060,-1682819677,1254912949,2138947779,730943237,1589880412,847524345,997837672,-1523569597,2054433852,2079104926,194365615,590620797,137830524,516174127,-1086189018,-699747067,356647471,723674806,-1275881024,843753734,1717933234,-396445238,-1148886558,788702694,530633345,1739321071,2075072012,-1845676725,345592116,-1885743259,1536863599,1989870436,680912635,-1686278506,-910520507,-1724817293,305249440,-564016850,-542588700,1478025687,-668933043,77200921,598964354,834189146,-2048387883,1574948738,1312510925,750439574,-550145566,112963665,-497932382,-1305725063,1574097862,-1903365695,1442747087,1724148189,-1577568230,856009907,1098674629,1318774168,1009366014,-1175467590,1359625700,932864459,-544931323,1612792519,1593933600,-1268008444,408681474,405508981,1185388880,-1823570239,187344273,1681161445,-560059547,-504965620,-380928259,515825667,1999527076,-1627864693,231676635,-347740620,249959431,-1052849116,1546548577,-1255676700,-1064087884,-330193235,-594721574,-754917688,-131972355,1281912239,-1338377234,-1380203769,346797971,876843257,-1025311081,469342283,-1984483836,1109433576,1720838609,1429535000,-1620588849,-336117801,853968061,506396841,-911895789,-1864734634,-1365169024,-38230929,2004513320,1064359579,1729443176,-812952170,-498091718,-153519515,436339804,1246258216,-898489018,687907294,-642490554,-762733041,1917070353,-37080223,-974054163,728187943,1156109658,-1003042461,-800441849,-685548037,-1133547933,-535065299,658130846,650682235,-1057567092,-1486688834,1419977997,-1119516015,1416760148,-2122851893,1938095471,1854496682,-755341548,1103548894,1247050940,650119966,745595356,1381404448,99956097,-1700964931,-1849552122,-699086556,152315751,-1200003256,-133146577,-882301507,1897914014,-742124245,-1323396799,1100169183,450525795,1567330332,1233080527,-1930895138,539891439,1340813660,-375876222,-365795655,2031412217,-2000154273,-1406954932,450409275,667095244,1849838799,761049964,2046149749,537504571,-178930119,2003597845,907625847,-843688922,-1749057032,-465871734,586955290,-1786976616,-2001834505,1568596697,1685305806,-1882974246,653898247,-724889152,-1156291763,-43649372,-421076754,2145547492,-2135694481,-220758342,-261429065,-1915289425,-218864860,-1332078093,1496043571,-211036588,2099759392,1616739924,1453698830,608478034,-1344694717,641152663,1515350132,-2138371352,421017805,87558778,912279210,1188194271,-1153079516,-2071654802,-887119347,-136726428,-1195474426,24938906,2042820699,-1614514887,2140570198,667366039,-807646389,1267218714,-1909940471,-1212739706,595749599,1623518321,-1254283126,-1641079903,49882818,-2055411219,-1343364621,338919141,-610798851,-1832008735,1327858610,-144078330,107720809,-883521007,-2063314372,1822540792,1257037199,-1756058787,-1990427944,-1826563794,-34902488,1347981837,-708172865,565650883,-749243405,-917845793,1671087053,-169255927,-852426300,378846351,-1018651821,-1034045558,-1769881909,-1262608612,2096215110,161099204,1083643467,731834257,-2060678876,1427830906,-1737981812,1591866238,-135265909,30950033,-2120730041,-1831818645,-1890514607,-1764660641,-1017587208,1933006379,-681968351,-1175318570,-60644979,1516997365,-515686540,-903556305,-1266857486,-334563238,1059129452,-1585513241,1536025669,613785306,824000418,345074569,64491635,1221469269,542503620,2078522823,564131973,-2078313531,1094244513,943757535,-855690190,-1905554333,418994024,-1958163562,-303863909,1913786290,-765325780,-1286605171,819248978,908378925,814454369,-257653522,-992112590,865615974,1162596066,-78601068,1220752538,-845806992,-1668654837,240540198,-260630493,186090789,-2111059384,1180686586,1018801263,1404387832,1271355946,1988928986,2006150335,1927955847,1589484418,2070192744,-1085169376,-355281835,-1884070962,634035101,-1753353893,-2084539061,-2085453361,1416538243,-1403602502,1946279135,1190890798,-1703540070,-503476821,-392401334,830637271,-345821372,-1960661070,-2027398882,1839498753,881039452,535508400,-712872098,1713940654,-579503234,1310821076,-908677078,-997577986,1445475376,-580365271,-1190105447,-5268853,1244560504,1804477428,-1482471166,872426016,37257918,-1721339416,-1514170427,628639228,523333859,-2141190955,-2113569592,-1602770073,382381207,-2048522378,771046140,-1195009389,-785429621,321046865,113751171,1764906106,992895838,195849910,2121785314,-1452658546,1540202540,1950479381,202211054,-1351170728,1650577818,565252083,-1971114554,-1942968562,10345826,1060265457,-1770829512,-207573515,-1897484671,-654090613,-2130397370,1311471584,684518926,-1102995963,-876309546,-755340762,26811238,1148342850,-96152891,874206417,201254505,1551352933,-2102887665,-1820421603,-1830208227,-1712549689,-1955406866,103680843,253546951,1909439495,-462519721,966575931,-1512720095,-1038939067,1691474233,1433280295,-1349661920,77527965,-808191780,1361525254,-1851380272,1214969941,93179124,456013820,-733047365,543486502,1507107325,-123773352,-327069691,-627733989,1380915516,-205013047,-814586267,557203324,-791021367,-901609146,1141730998,1482624967,-1814884766,651651487,1205802754,-736162804,1161280090,-869672910,-384523054,8272662,-1222864783,-127650857,1985892909,-1062602280,1297586769,1234802247,-1748736223,627778802,261904125,1551721369,-1381928887,596564732,1027256342,455995594,2056410509,-465702884,1104060019,-1232023686,898358019,-1307527992,919105498,2019670605,-1040333708,-554764422,-2021641063,-1999230408,-877218956,-754040650,-1876410378,-989924223,-1312635910,1775699504,-1797750576,-918447095,-644388295,321232159,1455690825,-1937033220,-1073697552,972328210,-1372948463,533889184,-979242289,1219168429,1866362302,361090867,-338495757,927435458,429633346,-342790276,816239723,-736960823,1931857157,1278467699,-1862047804,-875966834,-719743069,13425884,1530687507,-486435084,641973662,1258413158,1432617797,-93059106,-435374399,-1595781394,1718943097,-275828682,-684478861,1797986242,306483163,-1781254355,-303601502,201105950,-1542547367,-1184580737,1909890311,-1096210301,130400543,-2128630419,-1432395996,-344986788,-1570220160,924547999,-1570209548,1512146943,-553191937,1097793697,-800102053,-1129202111,-691582798,104501489,-1214178394,2026023432,709073112,290791995,1584103764,-802877712,-1945035001,-478077605,118406714,591471942,1198361979,-653463716,-1396199001,2040823346,2013183791,1847104794,945207595,1315455382,11693444,1862213929,420238546,-1028747459,-1689414048,-722696231,-1180175397,-1947025930,-1024247283,-660199522,859088242,1882118444,-1718430738,1795308394);
/*FRC*/Random.twister.import_mti(319); void (makeScript(14));
/*FRC*/count=83; tryItOut("print((4277));");
/*FRC*/Random.twister.import_mti(333); void (makeScript(14));
/*FRC*/count=84; tryItOut("\"use strict\"; /*vLoop*/for (zmgrvg = 0, (function ([y]) { } |= \"\\u5ECC\"); zmgrvg < 3; ++zmgrvg) { let y = zmgrvg; a2 = []; } function x(x) { return (function  d (eval)\"use asm\";   var abs = stdlib.Math.abs;\n  var imul = stdlib.Math.imul;\n  var Int32ArrayView = new stdlib.Int32Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    {\n      d1 = (((d1)) / ((+abs(((d1))))));\n    }\n    (Int32ArrayView[0]) = (-(1));\n    d1 = (+(((0xb40674c1))|0));\n    d1 = (+(1.0/0.0));\n    i0 = (i0);\n    return (((((imul((0xf972d07d), (i0))|0)) ? (i0) : (0xbb3d49b7))+(i0)-(0x51b2a9be)))|0;\n  }\n  return f;)((p={}, (p.z = (yield (\"\\uFDDB\" ? -16 : -0)))())) } this.g2.m2.get(e2);");
/*FRC*/Random.twister.import_mta(-488606411,-35832152,575056183,1837411968,268392403,-1893841497,-1093680169,-1953332138,-1136997937,748908277,-958024106,1201207738,-936994539,-2116572393,1815468998,399706076,-1246697658,-1795933769,155701376,-920713414,344609214,-371964938,658172393,714089182,-2025261412,-523653740,958321134,1995847739,-2077062318,-1608736202,323030147,-98593498,-1944745581,-591958307,1269593414,434016926,-380223774,1198036290,-162201157,-940780160,-585845028,-1806928020,-1017326348,818223494,2137045672,-1584955985,1498019496,-1665641742,-977546978,1442248720,-2085105206,1460062046,1516818119,92441432,-770115062,-437920810,-969490804,-665364575,1239873342,-1689143313,-899955042,-1579419836,-1379677150,-693081313,1370446264,-1715206056,-619512913,-642184879,-1469387455,-275181125,1557616424,-1877721263,1847828117,584026242,153111766,839258017,-2068366624,-658574464,1733958850,1784261766,-299173944,1633048386,-81740299,1208819132,-532478475,2004740784,-1267044902,-329646075,-442836606,-521609580,-77375605,-504304872,173810213,719587157,-971913224,1613035482,-1933709906,1461914383,345336458,-58641817,-345724162,-150962899,478797771,-543584637,2057417709,-1064016912,699525220,1658267073,1403800389,-605447904,-1334420073,751802965,-858615770,1899795038,-2003020719,-1954736773,1809750988,-1757455828,845820098,2052698145,551821152,-362486095,-2018359342,-390867706,1493097567,920800795,-998439672,-406219837,1744193969,-1510993639,-1165086766,1966190167,1002599049,-1445052915,-1509795988,1199958982,1248388266,1643029933,-942546459,1377796939,-308577912,1782638791,326037918,949037993,-215896172,98173006,-558614490,-756804376,1575549720,-1132306253,-795645910,1646696022,1830925550,53235423,-203983870,33690008,-1369975906,-603822614,-286393190,-266304256,1414302771,2011586480,323873068,-966190263,-320047863,-1366016532,919541010,-998712212,468818560,-1755754331,487992852,269265309,-2110889589,1104784404,532203599,-845410332,1481495745,1465367040,1053740776,468687021,656045241,-418443401,-1235549512,-2082313042,-1953725517,-2025690658,612072976,-1269764070,1930084463,1156898784,-718726496,-1733402408,-677651757,189131742,436609877,1386317678,-2072082423,1389131671,-1581279119,-1611892437,702816704,410292969,-852175531,-1162238334,624252201,-1905117485,-17205262,-1744045210,-1783235151,-1837335028,-210490006,1850175501,-1710446380,324265442,-1059670127,262278500,1734139352,306311970,2001659930,1528397326,167161746,-467136482,-1820727454,1093208887,558941217,-1825791838,-1235370674,358069382,-807083441,631546586,-1477392548,630906675,1268565214,-1065535355,-119409631,-1010043971,-1242419299,-1081210613,-1499120322,398829981,-122840443,-1385142304,-498180326,-1945826196,-362291929,963211178,-498216771,111673367,1731213320,-316030339,129570532,-2029161496,894239021,998429907,1841699694,1045629026,-1111617116,1359186868,110687487,-134654559,-2132267042,185741707,-1137222036,2143073441,950260841,2092836911,2030715130,-1194284463,173049911,-1735961801,-133391306,-703955889,-1155929622,-1890137177,-574307949,1577915703,-1693927370,1353113191,-473592065,-1979277336,1645234817,-374587639,1071166269,2056604507,-1697284417,1068897986,657418743,1492722671,-445265368,-464281419,-1471816693,-1601462175,707373400,314694033,1763311735,1439119857,123519106,-13940237,-158548045,-1134465011,-1704757772,1745786643,-531734501,-555207314,-1496962653,1670842912,-753232004,1659712735,1673532368,-1850883640,1144610298,-1892418486,-712156502,1839135821,1973333497,905591912,1044966115,688083579,-2141419548,-355517969,-1740617446,-1696022509,-2028136509,2021693451,1736610997,-393235518,-1497393506,-1654401325,-1466894053,-1791094425,727174270,1760263296,-669320159,-1158550145,-97280729,-289150544,-876388286,344929195,-1526147384,1473616155,-2002235695,229943521,-1392341150,-1243353822,-616304232,936269065,-1784630477,1508710585,-1017781849,1193086027,-1327920465,-622588650,-1213254156,-64010369,-2052629542,1044015490,-2024409496,-2027520616,290468890,487158705,2123604567,-517375361,-424225016,-1762945305,1627078793,-1526854248,-716446301,-1002317452,1336100306,673751923,-1706021591,1398553992,713346447,-486119150,-850606984,-1316412947,-77869740,461280571,-258941404,-1245102444,-604127513,15241372,338251077,1298107694,-8412291,-472450601,433517322,537049878,-1238389500,654081678,-2080879472,-1351067258,1095683635,747559228,-879933772,825273647,-464714510,866948011,1998351607,-1497024098,597473643,1957483095,2048955695,-1647488174,-1316436070,1541009620,774408535,885772344,-1123083673,-1220066329,-1890495398,1079769230,-704754912,-1293191490,761807535,839417355,-1916290420,121961524,-1705155741,-2124331091,-1909483960,-342280625,-2110237927,504750743,1716870570,-1138185762,-1707454864,383766065,214010542,-1596848829,428993623,590604894,-1714858881,-1882611905,299617344,-1863029934,-731632245,-1287994405,-388567510,-1858794424,-208993337,514674702,-97840386,668894843,1968457938,1663606557,-583990829,1813309049,-1923799795,-743085359,1662001686,-2055594596,1344911893,715816613,-1570445717,1471704855,-183280885,2005723405,-261871729,237349161,442666495,1718037533,1646566753,516808297,2051594825,759648625,-272326816,332252870,516937900,-175588726,1463992701,-846323383,1375400617,-358693291,-74068766,1710677618,-524363389,-1265177370,-683734277,-2135957236,130907135,-2104622157,-904823376,-728130246,-236395377,-131500270,-1486730721,831284069,1848866088,-567154377,-895777891,826954584,-1227019201,1525009275,-1830867881,1758156058,-1097613522,-1937322401,-1774886460,966725901,1785488019,1071863898,2119821787,1688978881,-312302181,1898909104,-659354223,-53030624,1587166746,-1342129210,726804005,-2075646284,841019047,-2089880594,1793580001,479868366,-14956792,1804108117,-1182533115,1900912309,-1208372120,1239736909,984629836,-577476079,-1153409809,-1822956023,-706326442,-763926001,-1820762740,-1196490266,-1442597258,-1398117941,-1640008453,651793087,-1300804977,-777344725,-1746380234,607718274,-741754173,1536218749,578272285,-834214847,-928577311,165141564,-1161231043,750603330,-1318257522,-1802658117,-1356826707,1179045161,-880719952,-2028420376,1470032932,-1371658884,-125357676,1528070677,-715620599,-1614723928,1500231674,-1959058706,-1619983540,1233726554,-738596257,567118845,1157502172,1329207467,1611792640,2050566455,2015437568,1026062416,637617771,-1380956727,1915749382,514805696,-1671957031,582361083,-1052694315,1781783295,1130589055,-488596890,-1986481455,-728535014,-54565742,-1771981294,1933446840,-1478754758,-457817282,-809720283,645469568,-1915391151,1291742784,2066468186,-660645732,-1066784305,1441003702,1620477304,3810315,1162875509,-1147927558,1761841810,-223937615,2012394010,-1659939261,875603288,1739368994,1382494572,-2100988903,1591628461,668774487,342915975,-483873435,-201750252,1535708822,1416640570,-746829787,1945429046,1661280373,2072600905,-1020573111,416586890,345617834,-951832765,1152495770,1278578359);
/*FRC*/Random.twister.import_mti(154); void (makeScript(14));
/*FRC*/count=85; tryItOut("this.o0.__proto__ = g1;");
/*FRC*/Random.twister.import_mti(166); void (makeScript(14));
/*FRC*/count=86; tryItOut("\"use strict\"; s2 = '';");
/*FRC*/Random.twister.import_mti(176); void (makeScript(14));
/*FRC*/count=87; tryItOut("mathy2 = (function(x, y) { \"use strict\"; return ( + Math.sin(( + ((Math.min(( + ( - (y + x))), (mathy1(Math.sin(x), y) >>> 0)) | 0) || Math.max(y, Math.fround(mathy1(Math.fround(Math.asinh(y)), Math.fround(Math.tan((Math.max((Math.fround(mathy1(Math.fround(y), Math.fround(y))) >>> 0), (-Number.MAX_VALUE >>> 0)) >>> 0)))))))))); }); testMathyFunction(mathy2, [-Number.MAX_VALUE, Number.MIN_VALUE, 0x0ffffffff, 0x100000000, -0x0ffffffff, Math.PI, 0, -0x07fffffff, Number.MAX_VALUE, 1/0, 0x080000001, -Number.MIN_VALUE, -0x080000000, -0x080000001, 0x100000001, -0x100000000, 42, 0/0, 0x080000000, 0x07fffffff, 0x100000001, -0, -1/0, 1]); ");
/*FRC*/Random.twister.import_mti(389); void (makeScript(14));
/*FRC*/count=88; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"[^]\", \"gym\"); var s = \"\\n\"; print(s.split(r)); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mti(440); void (makeScript(14));
/*FRC*/count=89; tryItOut("\"use strict\"; mathy0 = (function(x, y) { \"use strict\"; return (Math.hypot((Math.log((Math.hypot(x, y) | 0)) ** (( + (Math.fround(Math.pow(Math.fround(Math.fround(Math.imul(Math.fround((( ~ (y | 0)) >>> 0)), Math.fround(x)))), Math.fround(Math.fround(Math.atan2(Math.fround(x), Math.fround(-Number.MAX_VALUE)))))) ** x)) >>> 0)), (( - ( + (Math.sqrt(( + Math.fround(Math.asin(Math.fround(Math.max((Math.trunc(0x100000001) | 0), Math.fround(y))))))) | 0))) >>> 0)) , (Math.pow(( - Math.fround(Math.atanh(Math.fround(( ~ Math.fround(y)))))), ( + Math.fround(Math.imul((y >>> 0), Math.fround((((( + Math.sign(( + -Number.MIN_VALUE))) | 0) << (y | 0)) | 0)))))) | 0)); }); testMathyFunction(mathy0, [-Number.MAX_VALUE, 0x080000001, 0x100000000, -0x0ffffffff, 42, -0x07fffffff, -0x100000000, 1/0, 0/0, 0x100000001, 0x0ffffffff, -Number.MIN_VALUE, -1/0, Number.MIN_VALUE, Math.PI, 0x07fffffff, 0x100000001, 1, 0x080000000, -0x080000000, 0, -0, Number.MAX_VALUE, -0x080000001]); ");
/*FRC*/Random.twister.import_mta(1296174335,-1086879565,-1878561058,-1117019555,-366264229,-1135623141,-670822023,1990005666,-1803487375,224023164,1460120805,1369650,1856251571,-112477767,1269988192,-819578749,1637472954,1774955247,378011030,-947744173,867098063,1355327304,-1809230142,-1920209658,-1677860731,-558416914,-1134145963,1682708483,-332990267,1251113198,735052962,-742129992,1468072690,2085082868,802988817,-1386067186,-327297634,-1275462590,-217972334,-1158777115,-115541907,-1988590512,-917012341,-868524397,-1754898938,-1768953430,696430338,394895453,164881173,-588584650,127370710,963244721,-780914819,1243373331,-142020489,858973523,-544643670,-963142156,-1021836225,-1874937788,660673199,-1501183586,-59429767,1924473123,1787111473,-1767550871,-350623202,-1217061834,-1014797965,-2119224076,-2100336207,-254367943,-454066485,1406330646,1300600390,1403088857,-2034122859,-2009546109,1356466225,-676617625,-1002584249,1940382942,-458657838,-1360770598,-114231573,-802403491,1002188263,-2094692274,-2007164840,1138446597,1098127081,-1307192091,1380670018,-376217503,1096296629,-1333536024,-1468203485,-1735026414,-813466378,-886969775,1846427670,1098465022,-1889835373,-1909191750,531196322,713104873,-859248642,1572614374,1557905696,427856773,867806421,2029221385,-929107223,-1240154926,1493048534,1204790081,-1997447432,869450624,-1195483903,-278280008,-944618798,-94709268,85226550,1116629656,-878873185,412008648,930616111,1370736872,413621850,-2002696257,837225979,395367447,893955647,-117269056,-815227864,-1156905298,-1893306186,144116386,565041233,-1591351566,-938356930,-629226996,-556731530,468151255,-1934891930,-402844430,1621481032,-734168911,-1410020156,-651868005,-442575472,-1716474406,-556246375,-227869263,-971388380,1085605355,-1069607031,-1879978023,587514005,645302735,-1540199568,1355629420,822550421,1880066327,516108972,-2002886442,66184651,151443868,-576847834,781784586,-348664538,-532765926,1573170778,-1328180589,-1954659781,-2028052807,889492160,-2093968723,-1236704398,1271177814,-1061360229,407824931,-1559122895,1431716823,-1758313227,-1367155814,-1941320161,-1816928688,-2053008950,-836579730,-2081712567,-725858250,-931690818,-654979275,1383796461,1135127623,805610203,-600538031,-1234695886,1422406891,-798823458,67557775,878658003,959767034,-373089876,-495718982,2016762091,-1266752475,458821226,-75537748,-1326097804,718988349,1574537590,1514882674,-1272410202,1747411066,1565573547,-388285400,1584945969,1744730044,1235052870,-1969767944,-515331634,-1657182363,-825065710,530542141,111039732,-205992697,-303703586,-2080436880,1991146779,-807067084,91875462,1031560118,-1905239389,1467043936,-879368666,72692346,-755072477,-872785106,-1342993847,982865133,-1994080587,-1918728970,897523002,-1096178409,501097095,3588555,-11209047,-671752784,-1911728910,1481887948,1518264664,-1970977822,2070256690,-218501097,571718964,-1315647998,1899488439,401937693,-1597604114,835128359,1270129025,1764003701,346970250,-813227537,1066308370,624692393,473144596,-1252929904,1043779691,-890590477,1210858662,-563577068,-511206887,72859406,766588634,-1350700426,2087370053,963951330,-406654904,829167926,-1754206175,1273719338,-1723033963,1233584155,625645932,366737339,1302634779,828338851,-1141358132,1066531997,114101374,1184652026,77475857,-1070790350,657596626,1619101367,938389472,-1445018575,-1092805568,-458615148,1020622190,1286216603,-101496941,2035762063,1070958807,-170013009,2071004218,-2034908881,-1451378689,-1812571202,1072399780,-1736717372,-1713858950,242343414,-833468185,1096439067,1585117389,510361295,1039118519,-1679944821,1439376946,45417638,-1395506957,-1663256647,479769063,-1555133372,-1829861742,-621772628,-1170098694,-1431525523,-286172279,685349298,719176766,960131329,-892355953,557696945,-1978594725,1438803294,1774606461,1316969319,490624464,-447699404,-247637541,728151111,446166075,2131755742,14479126,-2073034306,805071891,-1874137243,-7220312,1974189762,246348841,453879150,-885884557,2035226614,-2145592048,-1828073525,1352568864,-1137444948,1769372930,1716740141,451415150,-771712417,-1023079864,-1346343465,1466049386,1257264445,1917416723,14758526,-696377221,100906100,368138392,-698799506,227717849,-573130110,-1017892208,707671349,-1306610177,1426447449,1713030012,1720219368,1729233901,1877981456,913822788,-1088045582,62094379,821770717,666084820,-412293782,-1629942712,641156753,-929677356,-273120673,-297275648,1236355970,-212058155,-1795014096,327895911,795261043,-1980172528,1841361165,-287544633,945133318,1369524810,1194578039,-622462193,-457636324,897302416,-1110613659,-134782779,1140154263,331305354,-2092807028,-1920946060,399349543,218389311,-1889514086,875685069,-1972398146,-1783960109,53349390,-1038036802,-76206582,-2035326164,-704500087,-1922601999,-509671641,682431701,2083455820,1017090810,819510987,-1140534900,-396122000,1005237150,-996266655,1648386585,-1122715574,354283125,-1992489255,-1564437608,1744496066,1078444921,-370644217,-1996704673,-700495073,2051390543,-1866417979,-1618712149,1070469831,-1815944784,-1901816034,23874131,1315226756,1630652713,-678109693,301942399,-1858068826,-1756922521,644523212,-1054929013,1874410461,-1946277347,-451097197,-2112047027,-1600887265,5310888,2072866516,846013581,-997534543,317617890,1611973878,1926082290,1443048119,-1916884029,2090492240,402923594,-2137985928,315290340,510468842,-1732952438,-1007714388,-847219317,-1148292761,-700738448,-1746942854,-2015934365,-1208889200,830580441,-1765245366,1006466189,-1343638042,1364829732,58344067,1780095328,1965842569,254644906,-468533968,-1046883527,1201921579,-1358238415,-2113350456,-672500562,-918844590,1193267826,-2003833019,694961365,1540445164,1238333808,1498698009,1211136492,-919485373,462875996,1915306655,-577535274,1043401745,-566263016,489805386,-1150903549,432410935,2012187877,-476397958,-1339898516,1562216395,1508753897,-144592250,-1191340441,1775545941,-2080923743,803491121,-1288488433,-1075405489,67119845,814033185,-727104274,428988993,1731625055,-1210520715,642779451,1686348501,1251619816,1245608614,386200378,1187808906,-853212851,-210289730,1643496896,1879803370,1094280658,-954386719,-1950112505,1624975661,1473019281,558500297,-1794104584,-688624121,-1355729382,-1588995537,1276972959,-1708555826,-254540768,-391073567,-1616348357,-1172829477,-237616870,1440139773,1357604687,-1758050758,1786786831,-2010817576,607196071,-1917534712,-1220297220,-1183528029,1751211038,-1757058701,-1589992874,576010783,534906575,1894862432,1346207335,-1297252817,1789061355,-230163313,1843342342,60955360,600964827,252267042,1539737216,916955168,725433959,-1443564013,-1618268309,-831028816,-246354728,1870886126,1952512823,1982197116,2113596793,-2105654426,-1941866302,1044703176,-186310092,1530804291,-599151428,955800843,-969584315,-830069487,527741538,181830822,1171760397,-2034155383,-958410775,-1422304050,-1808320090,-1624330193,-1425626321,-1802119523,-1667374609,-1429280871,1353381339,1374575008);
/*FRC*/Random.twister.import_mti(130); void (makeScript(14));
/*FRC*/count=90; tryItOut("\"use strict\"; print(x);function x(x = [,], y = \"\\uF092\", a, e, x, x =  /x/ , eval, x, x, c, e, w, d, y, x, w, x, NaN, e, NaN, x) { \"use strict\"; print(\u3056); } print(new RegExp(\"\\\\d+?\", \"y\"));");
/*FRC*/Random.twister.import_mti(422); void (makeScript(14));
/*FRC*/count=91; tryItOut("v0 = (b2 instanceof e1);");
/*FRC*/Random.twister.import_mti(437); void (makeScript(14));
/*FRC*/count=92; tryItOut("\"use strict\"; mathy3 = (function(x, y) { return ((Math.log1p(( + (Math.fround(y) , ( + x)))) | 0) ? Math.fround(Math.fround((((Math.ceil((x >>> (x >>> 0))) ? y : Math.min(( + x), ( - Math.hypot(0, y)))) | 0) <= ( + mathy2(( + ( + Math.fround(mathy2(( - -0x080000001), 0x0ffffffff)))), ( + y)))))) : ((( - 0) << (( ! (y >>> 0)) | 0)) | 0)); }); testMathyFunction(mathy3, [0, '/0/', (new Number(-0)), null, objectEmulatingUndefined(), [], /0/, ({valueOf:function(){return '0';}}), (new Boolean(true)), [0], ({valueOf:function(){return 0;}}), undefined, (new Boolean(false)), ({toString:function(){return '0';}}), '', true, (new Number(0)), (function(){return 0;}), -0, '\\0', (new String('')), false, 0.1, NaN, '0', 1]); ");
/*FRC*/Random.twister.import_mta(-819839228,-1151366982,1388258241,-6923371,-397808991,2096254835,378435804,2106892704,2130230840,-483775257,1194959726,1958697097,1091856927,1352827424,56020475,-2026140264,-300402113,419213121,965457274,1298099788,1068090499,118550622,-911885543,-523787184,-449574327,1385265702,-402607920,1832590339,-1640230275,-1824038531,-1846827,-425203064,-541266851,-1504971390,1788749515,1252096053,1763983594,-981085883,740041693,-563314825,-2145226935,-1612508541,1107404764,1588511094,-1032130036,-167656423,-180976333,-576290260,-946004068,-885557580,1401094808,-872998098,1824925587,1028170063,-10497871,-1140436123,-303080988,-102172525,108763302,-1417023327,-992592180,-154312548,1897021160,990730656,-1271874521,-1265370492,872658374,1932996219,-1513400343,1517534282,1106740572,-349305326,308551007,347074478,1951585154,-2004477449,-1124067992,-2086135243,-455193765,1990785215,88707903,709924771,-673003371,-145082034,-277629029,1550031014,-1031947381,-1985021529,1131112762,1871261659,400400087,-286071486,439406719,-937098660,-1903586498,-154420413,-475825809,915937375,-1964172,488454507,1435566070,-1853320900,-1559709459,-1907529752,-873734144,-1989239090,-321467205,-108555202,1559458383,-942951225,771679390,-1809085058,14355845,632321819,-474271642,1279841936,-1864850045,-1631489277,94217923,-1102404673,1125933287,-1665812221,1014424326,127963411,1434546515,-178571859,-884778482,-1133417919,-1069181749,-1743325237,1705076818,995193255,1431691445,-465317451,1919012454,-190840236,-72542178,-1914800622,538434136,-1331584143,1957608263,140442084,1663299137,537262856,394078380,986241228,-114788831,1123980632,-1286172136,-1075156091,-1079022253,-1752082349,-1875489811,573931712,1045365963,852794908,-1104445922,-1622758140,-1418068495,-2029447360,-1097674831,783943951,4632187,1132238537,-1637437019,673465882,-332145617,-1318618328,-313228834,-1001543799,633968752,1040789602,374620076,-1237867059,1386398811,2125683399,354699137,-328790971,-594109816,-784885236,1114287293,700105873,-772363477,-1921805206,665854893,-1894700617,-76246777,678567950,-1789486152,-1256040451,1778138875,1206533508,-92594841,-1410092759,-1904523556,-1439178795,518391012,-994104334,1025190682,-647915209,-1266112266,-146281727,1790942593,1226531247,-213404229,1767072872,-1116527355,-1186355967,1719765269,-2077032058,-190996534,-388393474,-475822552,90240433,2126853275,-227052281,-1297293667,820728494,-1731827952,-1325822715,-1704629037,-610074680,1124193776,-67838362,2081022040,1407573921,-247820292,-1177496597,-90173950,-1327452781,-664483185,-1426776350,1649173160,-2000755374,371984784,1530023211,-1593788966,-145861984,289568030,-1880809500,-1797220215,-1630788994,-1041575965,-1264077662,-1633628907,-294906650,-733168010,-1727328504,1827282566,-1901915808,-1930539978,-938771739,1473502167,-1783464247,-850438953,-818557721,-1953692036,510694225,1951781081,-807414998,1738589006,-699611436,-415527088,1668508847,2068771181,1943759444,1442499068,-1908694589,-2058619445,-2079162570,-489478960,-1502811041,-650773613,486406368,-1618125397,-783973135,-594964593,-1262555931,-682801569,1596415927,1711189460,1844385918,-638327184,2017567345,69453889,350147600,946650019,2064440990,2003462418,1827544590,-36890831,-1219085800,-1747068935,-1354490607,1394715362,-162379904,-214183986,1510003372,1724503253,1292538751,1727718628,708340021,937141477,418449022,1711999789,1648115695,-716263625,2029064482,-1341995029,441754549,-1096739695,-1333365431,1348369732,-1903038282,-829024420,-45417066,-1775454839,-1578610066,2026892026,-1647331077,1556265798,-462684121,-141477616,1824713161,-503385252,682028888,213548873,484949183,-51326614,-30907888,1108575361,630979867,-587050473,-105369948,2081561697,-526639145,241035200,-1308700308,-20267055,-1389325980,-1685624201,-316401010,2128643466,1900984753,1383766527,-1847661567,-2117950768,1131550572,-1634879012,-226466352,-1769122178,709466247,-1886459188,1427936453,-1309165322,2094274733,-458130384,1705969370,-337828195,1025157285,-94754205,115011815,1585513117,-153543127,1037470690,1100308348,2118722885,522169074,-1272028251,-1022368745,544563767,-1521842098,2043216630,-204416403,1775370351,1821866923,-1862191420,-570067941,1536094742,271688141,-775954893,222455157,26256744,346738487,-1464766068,-1337845805,-1734620743,1715716475,-1345379010,329219217,1892344956,-787859583,-499690099,-931609659,1605602008,-1703446946,-1600847288,-2056308923,1955074426,-963040576,948717867,1449050067,-1856269666,-1153252803,-1337079866,-196722771,1806090984,-166665755,1541818271,-1957989149,178099207,-985455856,2011379363,-223659582,701695560,-745094270,1741434033,-159996997,1079647049,963338206,-1362855178,1571193066,-341780014,1073114299,-1190806281,2118949516,728252076,1798548945,511760461,-1478383820,1997332489,-318210874,-399012910,-1552855613,-847744711,997511386,1064609769,481631769,-162280997,807780813,-1728657918,799374679,-2121660442,193433598,-1659381774,1169198560,1122932821,2119107115,1254757237,-1781837318,1025206234,1978175616,347575342,679746058,-1629310551,1395677769,35811917,160684399,-1571483215,-1327010620,-611600588,-1347731830,-1243193318,1039601675,482903222,-918251033,1185389620,-725083043,-1559587564,1104473466,267021861,-673712540,-563710307,-315987697,721562252,-214041672,-252829240,-2131993581,-935129895,515285669,-1702563908,-1055536238,-1362988239,1950714982,-625009859,524819169,-2077216489,-1119627360,-1917571428,653520099,1746359178,-1078395916,1680847015,1029053166,378417245,-1337525893,663551917,-448402043,-1805274425,552706768,-433805526,285252588,-1874727275,-1216563752,-803002036,-1262309530,-1033365302,-1472184479,1074246024,-48997688,-840746462,540800183,-1454471442,1973931277,-619655410,1503897721,-1426183975,-757934403,-103886531,325462695,2058331477,-237052849,-945874755,-1423266440,-1383685738,-751336194,1991920188,-1551065336,-941977920,-1356276758,-703885255,-426105099,-1530412649,239471258,-105171603,-1705613924,-812319158,338879585,845328428,-1702967034,634949891,-337965400,-665468731,-1649488876,-2104618709,-950674813,-462150364,741890470,-597048622,-686978055,-700136858,1024954624,-1044133103,-1101729442,-1790310268,-159858666,207283660,361439116,-331898669,570713351,-189993405,74980977,231536504,-662607230,1979344094,-2044616868,1590904133,721053967,-423675501,-1834471598,1968968797,-1721065229,-1761299707,-631014354,-2034187678,-356706349,1613390262,-972028075,-496257705,427252084,1835283445,14792474,-58058907,149469338,-981186494,-1657622370,1019979221,1924818385,22959606,1935819229,-309670343,-1321163762,-865626966,-1467743697,2015652394,-863627831,-1261543840,-2092060813,-1638367504,-566442859,-219153442,804437006,867502159,-1418483746,714266853,1974084680,-716882025,1806550606,-217463006,1311439961,297897316,324146133,707397448,1660722834,870280988,-439043603,-989817767,-1136590540,38300688,896603557,68616406,-1360117526,-1300211058,-2029773366);
/*FRC*/Random.twister.import_mti(97); void (makeScript(14));
/*FRC*/count=93; tryItOut("\"use strict\"; ");
/*FRC*/Random.twister.import_mti(104); void (makeScript(14));
/*FRC*/count=94; tryItOut("\"use strict\"; testMathyFunction(mathy2, [({valueOf:function(){return 0;}}), [0], '\\0', null, ({valueOf:function(){return '0';}}), (new Boolean(false)), (new Number(-0)), (function(){return 0;}), '', '0', undefined, true, (new Number(0)), 0, (new String('')), (new Boolean(true)), NaN, ({toString:function(){return '0';}}), [], objectEmulatingUndefined(), -0, false, 0.1, '/0/', /0/, 1]); ");
/*FRC*/Random.twister.import_mti(138); void (makeScript(14));
/*FRC*/count=95; tryItOut("g1.toSource = DataView.prototype.getUint8.bind(s0);");
/*FRC*/Random.twister.import_mti(152); void (makeScript(14));
/*FRC*/count=96; tryItOut("testMathyFunction(mathy3, [-0x100000000, 1, -Number.MIN_VALUE, 0/0, -1/0, 0x100000000, 0, Number.MIN_VALUE, -0x080000001, 0x0ffffffff, 0x080000001, 0x100000001, -0, Number.MAX_VALUE, -Number.MAX_VALUE, -0x0ffffffff, 0x07fffffff, -0x080000000, 1/0, 0x080000000, Math.PI, 42, 0x100000001, -0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=97; tryItOut("\"use strict\"; v0 = Infinity;");
/*FRC*/Random.twister.import_mti(195); void (makeScript(14));
/*FRC*/count=98; tryItOut("\"use strict\"; ;");
/*FRC*/Random.twister.import_mti(204); void (makeScript(14));
/*FRC*/count=99; tryItOut("mathy4 = (function(x, y) { return ((Math.pow(((Math.sqrt((Math.cbrt((y ? -Number.MAX_VALUE : (((Math.imul((y >>> 0), (-Number.MIN_VALUE >>> 0)) >>> 0) >>> 0) == -0x080000000))) | 0)) | 0) | 0), (( + ( + x)) | 0)) | 0) , (( + Math.fround(Math.abs((y >>> 0)))) , (( - Math.imul(0x080000000, y)) >>> 0))); }); ");
/*FRC*/Random.twister.import_mti(400); void (makeScript(14));
/*FRC*/count=100; tryItOut("mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var imul = stdlib.Math.imul;\n  var Infinity = stdlib.Infinity;\n  var abs = stdlib.Math.abs;\n  var NaN = stdlib.NaN;\n  var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Int8ArrayView = new stdlib.Int8Array(heap);\n  var Int32ArrayView = new stdlib.Int32Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    var d2 = 281474976710657.0;\n    var d3 = -68719476737.0;\n    (Float64ArrayView[4096]) = ((d2));\n    d1 = (d1);\n    d1 = (d1);\n    {\n      i0 = ((0x6feb0a2b) < (((0x8c67ddda)-(i0)) ^ ((0x446a260b)-(0x666bdbc5)-((((0xdbe431f7)-(-0x54e2f4)) & ((0xf9422eaa)))))));\n    }\n    d3 = ((((0x6c86808b))) % ((+/*FFI*/ff(((imul((-0x8000000), (i0))|0)), ((~((Int8ArrayView[(((0xaa2849d) >= (0xce320c9e))-(0xbb38443f)) >> 0])))), ((d2)), ((((+(((0xffffffff)) >> ((0x9c73a48b))))) * ((d1))))))));\n    return (((!((+((Infinity))) != (+abs(((+/*FFI*/ff(((abs((((0xfac5b5a4) / (0x918e0c76)) >> (0xfffff*((0x422c3430)))))|0)), ((d3)))))))))))|0;\n    return ((-0x745b9*(0xfded4be3)))|0;\n    return ((((((i0)-(i0))>>>(((0x624ecfd) > (0xe71dcaea))+((((-65537.0)) - ((2.0))) == ((0x1040f1a8) ? (9.0) : (274877906944.0)))+((abs((((-0x8000000)) << ((0x5af2b22))))|0)))))-(i0)))|0;\n    (Int8ArrayView[((0x18e955a9)-(!(0xd8c34671))) >> 0]) = ((-0x8000000));\n    d2 = (+(((0xf960cf32)+(i0))>>>((Int32ArrayView[((i0)+(0x15d7467c)) >> 2]))));\n    d2 = (+(0.0/0.0));\n;    {\n      {\n        switch ((((!(0xfffbdbbb))*0x9b2ef) | ((0x1340f942)-(0x53d71945)-(0xfe0afcba)))) {\n          case 1:\n            d2 = (d3);\n            break;\n          case 1:\n            d3 = (NaN);\n            break;\n        }\n      }\n    }\n    return ((true.search(x)))|0;\n  }\n  return f; })(this, {ff:  /x/ }, new ArrayBuffer(4096)); testMathyFunction(mathy0, [0x0ffffffff, -0x080000001, 0x100000000, Math.PI, 0x080000001, -0x080000000, Number.MAX_VALUE, -Number.MAX_VALUE, 0, 0x100000001, -0x07fffffff, 0x100000001, Number.MIN_VALUE, 42, 0/0, 0x07fffffff, -0x0ffffffff, -1/0, 1, 1/0, -0, -0x100000000, 0x080000000, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mta(-658443496,-2065747899,1616558037,-710931292,-1322309451,-1709396240,-2054647059,-1892575014,1557895425,138023775,1430781310,-496713137,-1558563341,-1841413595,-958470692,-1712874653,668851901,890690805,-180783964,-519012817,-167847020,-41912806,1225297398,1163317005,888028665,-543129158,-798797211,789775638,-1360553235,-846109031,408967317,-397009220,-188457483,-1689566285,1364226051,-593122393,414913982,41865224,-1924505666,-429055854,-900978809,-1756161483,527606134,-1177829628,-844288124,1645868448,1700056808,-19310532,539702970,724506905,1538559932,-1516130205,308785538,-1682161827,-1293743635,1648376028,-847718756,-572555782,-537128250,1615424811,1928685857,-623112507,-1386102764,1486576120,-169688120,-270025991,-1654376471,-1759141987,-1535293502,1717329562,-513859756,1932536676,1266883245,901973988,1251756608,-2132378583,905368778,-1067073538,291583800,1799510152,214738717,2059065420,1696316930,1949664430,-1356593215,385097259,-1449508758,-1156927584,-1316733485,383143587,-1975868159,1503983228,48328141,794008085,1574278794,-1929986865,-15555042,696202215,1740690705,222593110,-310270693,1558797934,1742147876,-2083432662,1438110859,2132949015,-876642361,659693748,238011866,-1802016123,-1571423778,-1721596011,1992610202,-63004143,1176477695,942302448,-1546664877,14068912,-544323207,1383639157,1166064355,-1477074754,-1983982863,-915952349,1383855686,-1572948550,1813686407,1420614444,104091588,74120725,657233668,1954074181,67208175,-1355057398,-590731297,-653177448,1219047827,-1448028095,453903611,751506230,270375059,-1694763053,-1971571582,778437973,-155229490,2110343946,-53377352,-1692051417,27811742,581641042,-17283760,226121723,-2045293671,1349251292,612228622,-556370914,-235427876,1509836451,-1241756746,-904187189,-606164012,1964787505,-1699569988,1654064718,1349139836,-1562531408,-2144151786,55583793,2098199623,204966269,905900350,-308992443,280710507,-2063219025,1060879695,77471770,1968720595,-393507034,-2111382827,-1743288521,1271256514,1402490909,1607373633,-1481338116,-1637772514,406384441,1557244061,-819001954,1588276159,-784528777,1364163347,-1519686758,-1080874602,-1430819497,2102655803,-2095802664,-1965320234,648675239,2034133389,-292943333,1642523180,1913585903,1673118877,1380225500,1532694074,-1274795502,1860158849,-1059410768,2008261771,-1358172046,532745393,-2099772362,-1785579938,-1213487114,-1285482103,-361441063,982071237,1069309076,614518704,289051375,-779059504,1674086120,143358614,2048127226,504635365,-1977803408,1122288864,-1517226983,1168627283,-1788845491,-2133163051,-1073145375,-1639719847,-828467675,1000345232,1281082348,1939683855,501663729,-443134531,1885522280,-581414118,1059271410,-1011597006,-242939672,1109448326,-1625347169,-1382680149,-2087988009,-86901078,260025325,-1201945952,-972070707,1282477569,801917137,-780053574,-350152237,463577070,-1153302490,-809896151,-2028716974,-1335025447,583907243,873770287,-1139483177,999515426,-1481163968,2021146796,299986365,-715512402,1847276318,1945467380,943678098,744950224,-207957790,259205787,-681098846,-394731596,-1457873844,1396354919,546891624,-1387547806,-1642399019,-2023204549,1449230947,-676325390,1522728904,1573847652,1228955048,-324337214,177208147,53495028,654612715,558695598,-185277800,-1408451491,-572481499,190592972,1261651425,-859975164,2029938911,-1177058399,-931583763,-1935737066,-1610882685,1752371414,-1563504516,389730329,-1916439497,-1365755575,-482114411,-1250029867,-955565725,297592432,-825144380,-978333333,1671092168,1176659860,-161656708,-833905954,1820340334,-2073220391,639437314,1671395572,-806494288,2100053067,-124429718,-1707086122,-738603602,603811686,-1613339717,135534968,-499233441,66989893,750698792,-1911251072,1224816186,-1939340749,1144526569,-805646553,-1576020866,-1968394410,963632442,-1719301897,335165555,-1859032465,-1620109295,868328387,1254516237,-558525866,-1023903282,88854975,1438417696,1371033351,1960932604,-1278318683,879555036,1992129912,-1949649771,-1275254072,-1608243711,1969143718,1786910286,2071294547,373453922,-1988462593,-1121835386,591709775,-1828578914,1651815687,1129198918,1019429234,-1973689419,-584476957,288372304,879121709,153666812,-727635584,-1824572325,-1670760510,935335007,-1883082055,615877818,1300996954,-441508070,-1730675307,1622745013,540172969,-868665013,-1512355418,-1562907518,-753226415,-1200019611,1609136269,-269806982,241934110,759528803,-678911488,1337653635,-824593627,-705308383,924985753,932606976,-1070075429,763275568,195043375,-134890591,974604058,-1086437678,-818586957,-2088179299,-2062220428,2090383504,560821208,137898937,-421239713,-1270510280,1930357621,-1469397400,-1176583051,-1460595475,-1000067806,1216583634,1172770906,257030514,1502589665,1821013723,1109093420,-139577643,1644155765,-2127100858,1690349503,792775635,2092186668,-1855238718,-1654602531,-251574368,945409953,-1109370749,1136808975,-1712761505,2037492098,-1281090950,-1346953434,872602684,1566841444,-1663093947,-1223318747,1845348277,1764568597,1443285371,1088927930,340776434,-1637937035,-727896853,1426090466,-574726230,144784933,150518738,-1736790141,-209319997,-1723135648,1632845469,-1951859914,2113501268,-1605616675,-2033876057,-1022462055,-1931667056,1607025743,1565116159,-630262822,-1273275113,1887612871,-132846355,-1173018357,-2102989234,-704563909,1165161491,274497856,1093892575,1330031896,535354109,-1862017056,-1342790993,1844362633,1420386173,-642394238,-155764841,-390270715,2032874,-1547132883,-796127826,-1189333449,-365434787,-1865768481,529853095,-978225917,-1597042616,1749529594,527784517,-1155883756,-1638175474,-1931928754,-2140583150,-209990657,839820034,-307214329,-850891866,-1601120335,-510016470,-1619736345,-1021881211,-1189500527,1883727331,-1130809013,1625073009,-85057326,-421552971,-138461849,-2062391589,1427324000,1456177372,-2005535079,1570727687,581470110,-1209993446,1765287771,-633682751,-1611840232,2123597781,1975403046,-1558691646,-437398223,-1292895632,-1058126087,-917354900,810698362,-1404086589,-902537760,-631759314,-79901552,814580182,760066498,-1636966434,218041826,-1133410228,983309501,-1436955728,-728531167,146610631,-1855580368,-993717988,-1480645947,-795153772,-1463439963,1708137856,-1793856387,-1492682290,708103939,-1600067397,-141918513,-1997347780,1698792315,-157994916,1193859399,966516058,779767846,553354048,1882966675,2049126918,-2042111787,1136362290,-228678138,1889649394,-1500488389,-1365204339,2029570747,-310985781,419901338,-33364446,1955704689,344186056,1880665489,1417632089,-984355622,1955612925,7447606,1978766685,-902068609,-726096496,1323443813,-280379990,1885902670,1599533914,743023525,940808759,-1679797728,1945075210,2085433632,-1537316084,1187604567,-1263246891,479270675,417396013,-1444270465,801118422,1108801400,-1236889304,-626507191,1164666344,1963894319,-1916600783,1372016892,970839335,1742460258,1582543701,-50893800,-1841390759,1003036008,1575155942,-123981297,1462481497,1858564998,-1142367348);
/*FRC*/Random.twister.import_mti(601); void (makeScript(14));
/*FRC*/count=101; tryItOut("L:with(new encodeURI())this;");
/*FRC*/Random.twister.import_mta(-1797402242,670849040,-14295181,-155382500,2056790904,469436530,1793484125,-54174608,1793065681,280279461,386176810,129036437,1402959952,-428183142,-1453079042,-343200679,-1950616292,-596058611,1573192432,166823615,-693437083,-581270898,324191156,1192985345,1733547791,-1260516937,1490582521,-671822008,-1823836856,-1759252295,-1014679157,-2104144560,1436161344,-1788860575,-1743081761,820623091,-1873533498,-1681528062,-2110269463,-998806339,1866556742,209388724,-2062775587,531054144,-1029119830,-1659013038,191787042,225542457,272633622,-1697651461,-433737893,538900180,-1026529782,-2137092973,1701824924,-1193051333,-1166896618,989749377,882006496,-1462551958,-1130492817,-825602167,-1614042305,-1548064636,-1884794050,1544704029,-1352464571,-227370948,-169104150,-207488973,-180024286,-486508090,1202210061,-14625030,761320412,712623522,-668585198,-224021865,-1224228342,1232066154,2016385077,584146497,2066332552,-1042538969,-845519561,-2050031659,-227281537,-1406921793,-2033530637,1168127453,-1704637271,1891956540,-1900119745,-1927124120,1342169878,-963287752,662749553,975338376,423013004,1786320721,-826556545,1538014056,513667536,1221183374,952287706,806229106,-742368440,-194238190,-1588746593,-1130711832,418486451,-604848260,1183720957,1702082503,-553490691,838269799,808203195,173452584,-1863827052,1093062012,-182104854,711517376,2024341653,1009698627,1205131777,1735397893,2009664145,565354620,752695503,2058251481,2030965564,82129968,1762540624,-2100043498,-812587506,414317863,1061103247,341963867,-549990409,-1588315412,943332853,-1895151711,342076507,-1067221513,1315513427,321221278,1257751314,1277895213,-1390143003,98582037,1978421394,1318087218,1619583401,-2091321289,-340907245,-549129941,627931418,-1304721282,-1714080710,-117655145,1149364873,661487709,-773100644,-541106063,-1717817116,626583792,775262875,-525887557,-1500993221,881141945,-1892048707,-1586569991,-508993138,1087551149,1106547519,1375351728,1155794273,2123071630,2074333641,488251482,1571955482,-1343695131,-304566436,1000433406,-1047061621,-948385536,1944640406,856607194,-989430503,-237065888,1732518032,-1779297612,418096100,-1455199449,-289147194,889543845,-1794458538,-1981929540,-1772212251,-351066314,-740274526,-728144975,-1921244190,1801776970,-1363774244,-218741492,948806517,1262177509,944103663,-1795243521,-1221946573,-1872668314,515814931,-1246324172,1643127426,-1786020927,637795181,1972089530,-809088259,-734047376,-472197075,1066180643,1626013851,1855884578,1378172129,263524854,807932255,1862699656,-1270556183,641740358,263270707,-1397654133,-440601665,926310933,-622281338,-903467255,-2024838526,-1127808725,2139198497,2100515293,-1175721757,-2001083033,-1823889363,-357851553,1258289949,-1845014790,-784540661,-1413348816,65922983,259990244,-1122729032,-1738284848,976264448,1880674852,996995966,-560284993,-1971130198,1028747968,-1054911623,-1801177613,1561218155,454576279,-1209308985,-845310121,-2011269470,-32770113,1435462332,1173125009,2071371067,-1124714969,62426889,-728013758,-1529868253,-706783824,650256872,1685872844,-834491683,380651575,810714464,-730480709,1453015334,-1076668962,1255869141,-1851090449,1470046053,443930834,-1938615106,-1966371698,310706943,-1638692539,691049518,-1626418839,1718100305,1617815988,92961009,-1337608436,1328605724,-753146592,108526966,-1035258878,34927187,1798286423,-57899588,-1407206535,-473769303,1704073945,-695870290,-1234488242,-898093868,-1197601731,995177033,-2059135473,-1566156233,162311445,-571901861,-1512309959,2123275747,-46104122,109375243,360733836,-567480727,2117099372,-513570080,-1071754357,107534013,1411997159,59109766,-1622865716,-850412950,1519910252,-522300930,-533371225,642872550,-724953976,-1863536113,1047598937,1200492355,-1509666817,-1963633341,64516694,969169242,1254625881,-519874687,-1581500845,-588672513,1342185642,-45265243,-629176895,1259657255,-1559996267,384861907,-167752355,1560324219,-148469348,2072303762,394495603,-431782324,552633944,-838887441,329343875,-1215108559,1797451768,328255254,-1567969873,1257301784,396172303,-1462421981,-804718679,-1364370174,167906530,1548106994,-1175101443,1539140022,-909354661,1220493395,-2022404827,-713617177,1004096371,-1938239294,-27170774,-788382102,-848561474,-309100890,-267503857,1534048123,281327025,1206425069,376196698,1980134940,560893419,445334300,1868577917,313352653,1761631508,1863162325,-1924335557,-900668249,828230128,1385988278,590398877,1528401069,-119022835,121988904,-667114071,-595989119,648573508,42271539,-1558167908,1998852852,-1353568538,1173174966,-786324889,1517054979,-644720282,1764495174,629782652,-437532076,-1566313867,1484924957,2061088117,-855465778,-869237013,850239516,549836281,647212046,-1219257869,1238142083,974591943,-738008686,1712637154,-439600516,-1863554358,-96214035,-281710140,867954485,-43927584,319184225,1338182123,94192406,1644585682,-1402693879,908832017,-813034017,145880671,-487810105,222571440,1003028597,1313144824,-1920502719,1083759814,1689872347,-1006500860,-51169444,1520969134,1104782685,1763505700,574387119,-1702570451,1283116725,-1457948913,-560509564,-549666787,-1260743901,241289139,1722642471,-2029117646,996007189,1325922843,1058387655,-1098985024,699301899,-1414128607,923109459,356448337,-359566057,-236597787,-187766734,-1254440168,569568480,496225164,-421261435,871177358,275340087,1702698673,-1911722591,-305809224,1995906791,-1336376266,1528285922,1057458190,-1512337024,1301863782,303608654,-2065528180,-1825656291,-1062824091,-325992957,2006669044,1110014399,-1185063255,-1695358153,1622060111,608748869,788004861,1337399734,-1618865732,-1294890392,-1612998111,-820004917,-1670783367,1764328306,-1843692686,-77669636,188168388,1672310505,804393622,1949628352,-874005950,1150243547,216121185,1258826202,-1732758686,1199748176,1583655379,-924082515,-337420796,1985930941,1306677471,-1922113694,-967596881,-1114399976,138182894,1021700065,804933389,-759031944,-1840181271,934352771,1581980857,-395831016,-549962625,1374318078,-883973958,-1427303210,955325202,-478657056,-1027452534,11319636,762175782,-1553570992,-372211336,-1568875771,-859834624,1013196973,-823158901,-307427828,1590623371,152322443,751601312,1768792613,-996344994,-1867290986,2068104045,87789431,-1122839745,-1161191086,-1647805104,329626614,-1731130164,2010745690,2066221876,-1067321398,-439958788,676381139,1997394151,338125912,-1369436763,213366191,1517490462,-922665396,-1103048932,-43554824,-629129595,-1531667968,-991268831,-1011870983,-842578444,-1336862222,193436113,25083184,-303471365,-1792117894,851750079,943089058,670652206,1426688621,-1554156526,1945482215,1650500706,-1411749253,-1580110526,1251924334,-1610646779,302794604,1485485831,1815693080,-1384928386,-448651074,626962321,-1344386998,1310498158,1877473480,864820997,-1792872451,1946517340,-1605556433,1216200720,-243699560,1198509480,1100038158,-1209284587,-1684196121,1483612182,-1866951171,-2143417320);
/*FRC*/Random.twister.import_mti(57); void (makeScript(14));
/*FRC*/count=102; tryItOut("v0 = (f1 instanceof h2);\n/*hhh*/function gliibk(a, x = x, d, x = ++eval, d, NaN, x = /(\\S?)/m, x, x, w = /[^]+?[^].(?=.)**?b|\\3?(?:(?=\\1)){3}/yim, x, e, x, e, y, x, NaN, NaN, let, x, e, c, d, \u3056 = new RegExp(\"(\\\\D?\\\\1(.)\\\\\\uf18d|\\\\v?){137438953473,137438953475}\", \"im\"), b = \"\\uE264\", x, NaN, getter, d, w, x, b = true, x = \"\\u09D5\", x, x, b, x = window, x, x = /(?:(\u4591))/m, y, x, a, x, d, z =  '' , x, eval, \"\\uFAF7\" =  /x/ , c, x, x, eval, x, x, e, z, x){(x);}gliibk();\n");
/*FRC*/Random.twister.import_mta(1109655004,2057468122,-1125128093,-429556663,1108257475,-870636384,-411240284,1633680058,2082769053,-1240567625,-2140662617,1065043291,1354776003,-339052220,-606951614,2144479480,-1440983952,1992533354,1963869869,766319046,631906406,-918461262,890293275,-1543744997,317998204,1733167195,1204083106,929708510,-1431178876,2057357282,-1539170251,2108725986,-1092490945,1031526099,999940141,1757146134,1360968928,226636847,-589524272,616634581,-106837723,509635596,-580560767,-1588590782,462569197,-906286486,-1814555365,345052127,1466915345,1905988068,136152123,-1001419817,-100696861,691772649,-1474249545,-1432920803,-90579164,1924482966,-2071653497,545263623,-1032642133,1981942805,-749748068,1772235237,307155468,-2000581369,1780359945,-279663963,488850746,-1201996757,1752064982,729834812,-659235446,1095174745,-2117331624,2042765804,-157399684,-1079790213,-1659644408,65944278,1968727324,247257993,-2144893681,-495543129,-1452548582,1191638437,-2103905366,641617355,-1098843506,2115161256,-1419341960,-1339711734,-1487355296,-142743974,-1312217102,572365533,-652882314,1650448535,1179298523,-2081815437,-1596315383,956262602,2011858879,1366008619,-872236296,-2096024008,659866123,1766091544,895817221,-1536285412,-1379383243,-389641875,-228854928,216104170,371536197,970541572,-1541139611,-2064989239,-1997063059,-2033831830,-2073422619,-2121395964,-835941708,549841723,-872097856,1210224357,1874968520,-1231336507,-1162921392,1490370119,-910032891,426833076,2130540005,925199208,429439085,-141758978,1370334530,808698934,1654908968,-1231346461,-350780064,2093336941,1385752185,-1067825349,338736223,1993657500,44607046,-427499577,200526879,1160040450,814915431,305253608,1471686808,949618924,-587589650,-120191471,-501503788,1313988735,-998183437,1895898422,1006328497,-1981666135,1101721244,-1394001776,1193311644,799883575,-2004020241,-1761772161,-1560368034,-689060250,-2102505060,1608116250,-277896024,-1390503268,-2022918242,778384217,838156104,-1138807769,-415381822,-940031328,680806819,1918928701,-1038328956,1117890532,1890994121,-380233416,-1637032967,-1945101385,1356908656,1082594638,-1980729574,-764399729,-796430561,1635240426,719151438,1844359358,-1280114204,1952208933,-744432916,-393700226,-797710322,215098915,970322970,1174846318,1308594157,768343418,-1137990609,1168266318,341109741,-454708209,54359783,28386964,782862087,-1281159530,-870227843,-986794297,2132236594,-394389117,1700642682,1550395984,645613644,2065278139,1051492327,1612849322,-274344470,-110937603,1292036421,-2001196678,-2131362385,1902481721,-1459407021,1993873541,-376566263,410596813,460418878,454210795,-644729132,1709047566,-356852538,-271794162,73578933,992764707,381340943,1953656846,1379151865,-315788062,668295641,-1209467677,-433445303,1624885732,869474547,-1273080139,738913706,1803379767,-30974573,74337703,466457572,-762806081,-441855346,-1396224621,1422742587,2102273296,1540862876,399262575,-1564473617,1786253413,-881913101,739866447,-1108846201,399721184,-122498119,1811643750,-1412734690,-6208754,-568793775,-811199697,1923773173,133369880,1678671465,-1123227618,-1363398065,1763954007,-1667559373,-775098938,1326659377,-1802890745,2060560460,-2077733265,1611401400,-1800823132,-777362073,1466202190,-1098183038,673390051,-277628456,689574384,529289429,-1022325690,-562107322,1753000669,18961486,1925995483,923043787,1124032883,967008743,-664678048,-1227493553,-1061153231,-404830837,409644764,726829895,-1079466597,-792489765,-1923479160,-954234041,1237249558,925552849,-1935230198,1323897597,1624135009,-1739836641,942303796,-1695376282,1447658002,-838909408,-235851642,613941142,700753446,-1218669859,2770836,-576479754,1189935989,-2117159058,-565652866,1422136643,61908706,1246689843,245296778,-44317287,-1010978848,-1462166859,1341021505,1164525884,-439829410,696632004,-708858456,-135349731,701389655,876736015,-404898930,-1693618998,980583835,295519287,-596938770,1373468370,787963016,-101820817,-1118117841,-1568306022,-267351349,-998273757,-644900470,1113155096,719723008,-822613951,-92313183,609977511,221710706,1490345852,-561873230,-673476180,-737923050,-763238059,964731270,180915297,-308003075,52956717,169841856,-2017208973,1135831326,-2013464513,-619411374,-1452238214,-99806241,1324586276,1631407282,-1498330298,-958391666,1332588909,-507464127,-1338875130,-2114182796,1926146867,-15149306,1587838991,1362724678,-1426223236,-2057263782,79635200,1477655966,-363712828,1299861402,-1462523687,-651653833,-531842496,-20800652,1232999323,-440482252,852752289,-1199421949,-1121420970,1215474293,614670416,-351044685,-1879121536,-1942136704,2057080675,1682916502,-1324304537,1193303065,1971058932,1999753627,-1932932838,-1317754537,-120987535,-593261271,-1256556888,105665580,-426240752,-368791561,1196439355,-996446137,-425312558,-1745204721,-1410525687,1490001156,171791748,-1099919550,-1253637156,1076412648,-52077933,-853764913,796470150,320146073,1647412730,-1559599501,-900429501,-1155270676,786555488,980382658,-372504108,-773993913,1732713652,-24512262,1177074008,-1450203679,1518187390,-1599637019,900430242,1851325463,-2033318909,239326009,688622843,1858422692,993233746,1614734258,327223325,-1537880780,-46309585,-1598863552,-883331573,-1509887026,590234503,-1000832497,-1047450955,-468724620,493647651,-1533501192,-1631473875,-1833042009,1331353344,-71723326,2092843612,30517708,-1787052061,-1464988880,288140120,-1414364145,854525005,-1026200688,-862969620,213554828,1838929639,-1050389060,-1912471862,1669773745,-1049928063,2055977048,1907023439,-1118512874,1330040058,-895482736,-1651888989,1987810699,615114401,1983219183,-2034448002,-609418297,1264741556,924398366,-1001494117,1350076839,165847181,-227269507,-545383333,-36482470,-286766011,-1089032563,-645633883,401027328,1543409181,-196486978,-627750367,-1029559382,-1066061111,1954326884,48749197,2086124317,-290917474,-1027231480,1814811700,1641139720,-912043050,-1292463716,338720915,-861735913,-633502903,-650327081,1142551994,-857887404,824903232,-1861567536,-1503728650,-676665323,-1957846739,578181020,-1350477132,-854997500,215677315,1362257693,1669344493,1029727514,1025633112,-1193417922,-300195580,1942767970,-130218106,-1723585245,1898369922,676130387,1788770745,713328568,-1025519986,-2095302072,271160343,-286078370,1453662585,304840231,-1623851928,11074235,-2102101122,-710021217,-838933125,416471987,-339500575,1310352796,-596851417,257284348,-212005314,-351376908,116169032,304955261,1607456350,732229434,2094986918,-1373767056,1050860201,551250489,-438594452,-675701058,-2035774219,-1597693662,-496147965,1732561208,-613502474,-1118482262,1424630920,824618164,-1080053029,-458753299,1714141085,-64869783,1358798297,-680490494,-1865767017,-1360359492,-2058941867,-1844076696,-956044836,1639573856,853539739,860929960,-1072169897,52325682,665126551,-1204166717,-926544320,882844197,759392458,-1061258771,422567456,-151847303,-1705618144,-873696878);
/*FRC*/Random.twister.import_mti(442); void (makeScript(14));
/*FRC*/count=103; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return Math.trunc((Math.fround(( + Math.fround(y))) >>> ( + (Math.ceil(((((Math.abs(( + x)) >>> 0) === (y >>> 0)) >>> 0) >>> 0)) >>> 0)))); }); testMathyFunction(mathy1, [1/0, -0x0ffffffff, 42, -Number.MAX_VALUE, 0/0, Number.MAX_VALUE, 0, 0x100000000, 0x07fffffff, -0x080000000, Number.MIN_VALUE, 0x100000001, -0, -1/0, 1, Math.PI, -0x07fffffff, 0x080000000, -Number.MIN_VALUE, 0x0ffffffff, -0x100000000, 0x080000001, -0x080000001, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(566); void (makeScript(14));
/*FRC*/count=104; tryItOut("mathy3 = (function(x, y) { return (Math.fround(( + ( + Math.sinh(( ! ( + Math.fround((Math.fround(0/0) ? Math.fround(y) : Math.fround(x))))))))) > (Math.exp(Math.atan2(( + Math.trunc(x)), ( + ( ~ (x | 0))))) | 0)); }); testMathyFunction(mathy3, [-0x0ffffffff, -Number.MIN_VALUE, 0x100000001, Math.PI, Number.MIN_VALUE, -1/0, -0, 0x0ffffffff, 42, -0x080000000, 0x100000000, -0x100000000, 0/0, 1/0, -0x07fffffff, -Number.MAX_VALUE, 0x080000001, Number.MAX_VALUE, 0x07fffffff, 0x100000001, -0x080000001, 0x080000000, 1, 0]); ");
/*FRC*/Random.twister.import_mta(-1204709065,-2084542482,-1305922715,308136826,1803017674,-613559157,-1450741654,1196838609,2093814768,-1874679529,587977798,-2084873825,-1922598239,-792646921,932953609,833423976,-1871533818,745632265,-1695820701,1749655376,1089468111,1922064821,-808008245,1006754506,-576821911,-1356094005,-1430145608,-309258061,-1577849128,1043584621,2022971741,1625313616,766637121,-1013680142,-255424948,-836149086,137617607,-2054987935,-1817730639,-1343946295,-247416508,50143043,276874057,673510714,-371129862,-6450732,-1068158039,-795961299,-1681396095,1465056129,819928,-887690034,-134607511,1691674448,496948246,436990758,-2016191695,-580747196,1623661885,-498297996,1119801136,470587884,-2088675270,-1880527611,-1825856155,-989057632,-1066950103,1973561807,-451203720,1739995638,-1315569750,-781766166,1494774451,-876649305,-622730440,409035065,42068077,-1894202959,-1510422241,666912173,986611171,131784053,2056126763,468662285,20077775,2113026953,-876199946,-1975795036,-676893340,77589732,-207598710,1631806845,-1184130883,-1804291307,-994251971,1091645916,692259112,875305848,-75822249,135199450,653528125,-749261489,216643676,1766297990,-1960271988,1462304121,1121558535,-1491870340,1677891425,1230003643,919009198,844076300,1902742891,1448362470,1284779173,-2097669664,688518470,34419378,-1095742865,903214824,-3037681,-1097716225,-561155006,2113725949,156249875,-311061051,1088896663,-1658671135,-2128705896,-1089574320,821018951,1222572467,-648608580,-101762851,1511504119,-1586134665,-1427147897,627149959,1323816633,-1347010055,1045864382,-195217831,1979203094,-499389264,-1436492386,-1492469547,2111846185,1472002045,14958493,784377304,-1005510544,654765519,1300194155,1308436250,-670837043,1277968178,1191027678,1431545634,189581305,2093488641,79530920,301180108,1043886619,151930743,-1537566724,1603401638,1365914664,1096204856,-2054936211,401738167,2110229034,-1467863492,1445443573,-1056825167,462931692,-721126689,-1613365889,-1738718592,770065612,288248105,-1351799875,-766303236,-1973503482,-1480652173,646329313,-1980691587,-190557634,346985118,-1906413353,979034404,-789852895,345019196,-1493009845,-1815724974,-1775076995,-72031503,-2073930251,-222372736,-921624939,1020514447,-297332870,-1552594730,-945510566,-639844172,-356002604,-673120495,-1247698907,65561278,93381988,1573978617,-1832055774,1231002240,2020109867,-842531974,-925936620,-1080274738,-1372991188,1426839850,-1777513749,-604263834,-1877262169,-1424103450,-256939592,788346069,323736152,1709150557,-810523345,1631835967,1652170669,1067456531,-264669209,-960992751,240778930,-1539323915,-740842373,1342441626,-492022128,374782501,-195217000,1449039524,1415556025,-1513199535,194261615,543165989,451397752,1342821456,-357215746,-1426959052,50103623,1329063277,-1090109105,-1952771140,60663567,215657390,917409471,-1407899862,-1904269587,172027930,-1349826746,-555749757,-46963334,-584228990,1556607434,-2141498513,1773660044,790140951,1625361073,1992041816,1226096179,-1244587446,1574521737,-66801291,-2142425005,911339998,777331045,2073716516,1420522381,-1425863373,-711943999,967615633,-1991397084,-1965298480,1928168901,2035445878,1311717784,498059547,2035287196,850971500,374888126,1918687830,-463777502,-1938939356,135598990,-136413499,556736823,1943385549,1178501077,-559249015,1011995739,1502140564,1808923029,1483411458,-1609146017,-2024216511,-1557649151,1738182247,-559350166,-802574343,1273989659,-164629417,-1657546209,-262462339,996097869,826362506,-287001169,1429910995,46969185,232550955,-936575214,742732269,-933132785,-909794034,708178133,264022072,1288995643,-1456409444,485272009,-1538067060,-1824387451,574125735,-1824957213,-1949318085,940348486,-1313662343,-1496609267,-668116313,1310665470,-1855740483,1402028796,-1139953426,-1465131111,1847626811,-1340323889,2110460964,684909670,1548724158,-130389092,2096751063,-1921191880,-1827945945,-1177741329,-1734984233,-1019207118,671712766,-1973878363,618732912,2024516248,1638729482,-1445065719,576746226,-1792478184,993725435,-1274639241,345782136,-1051293560,-2050841547,-1456618176,305983488,-618919680,504755904,-2009467717,1512610283,-70588394,-510869050,-127510436,-663189420,735014840,1593342486,1189042496,-678842453,544695091,-1933861904,-1474165246,562325836,1707934075,403989082,532158278,-100408383,-1206169805,1713456024,1240487885,1144353466,1612553253,-1489976080,1774846363,-1862603053,1430412058,1066933162,-2071219981,1661902999,-1480652932,-1762221473,546868379,-269246369,-415494342,-799932962,603009587,1863082162,1461366818,-724924755,1519316886,886547401,628098683,-1285872898,1387282142,1779992505,142426991,1365976653,-301462033,-1648392655,827745344,-1873371664,973473413,1628312850,99068619,-1818483263,2146826905,-586480142,1333768178,1023675416,1654245448,-1718301763,85289673,2036308990,1871686716,9326502,1122584152,-932278836,692845300,-552438851,843121090,-1619803689,790521181,-1624173615,-578397492,1781513877,-2039852656,-949243497,-1238737401,-1001820846,-551853783,1625840642,1520135456,-1398523517,-326322928,256165394,-1225059266,-1427322058,1755096261,-1808380820,2048302774,1583010521,1734781768,-13266119,642370556,1687489865,1148481598,-1278626575,-174601231,-147835467,1935701954,-763864732,-349362808,326464635,-654983410,-717091319,1568388369,1768826374,1540185264,1680919695,822501583,1223798673,-1392643124,499796419,1578628482,-417525014,1376656475,1028413315,-62395830,982507964,-972679127,-965559264,262845129,669119956,-1636316833,-257318484,-929773978,-66808719,-491856386,-403810770,318894998,-107444245,-1716576962,-537448446,152141595,-691078018,-848128595,-318994562,-1856539297,-910032425,-2006547334,-740894463,-1113756678,-1880638866,1280401985,-131809213,-1260438065,294770095,-945964380,-1125981089,-839216486,-714263304,310681624,-1089710482,-1533747909,-1540716094,-22301243,1552253018,956942470,-704410811,-1213198523,-2013691670,1054983849,230191868,1869636909,-1074136224,62464355,-12640062,-701107497,1674230893,969152354,-1110720428,-1478004474,-563949272,1558665701,-538160568,1254216431,386157073,2018780767,-2097326468,286038709,1380218519,-1252129533,1809914187,-575352515,-1352889018,-141373207,-341166814,115409869,-1807017915,-1527686747,-2019268278,-1717352573,-1627172822,-1508196206,-1580506465,739295010,-1489952339,-1216593479,-1320781200,-1911205068,-685431292,-1993442632,1423117235,469029657,977412724,-727634343,-2140958480,-317650643,-2143916394,-1206408545,-1514214774,825453293,1187303883,1990457906,1871171970,-1425705167,-1480245714,1357366436,1851423442,1157539817,694716758,-161431383,-2070241861,1284921429,-1318511804,109486234,251567369,-1317809086,299336455,1184195629,152053359,-205468331,-90010452,160251336,-1653314379,-1635557345,1140234205,-60330176,675629840,942421656,-590458993,1503352003,-1788730158,2132262143,-596097005,-1520016811,1599202216,-43843949,747270965,88148755,618736395,-183708134,-1873664162);
/*FRC*/Random.twister.import_mti(100); void (makeScript(14));
/*FRC*/count=105; tryItOut("this.h0.iterate = f1;");
/*FRC*/Random.twister.import_mti(114); void (makeScript(14));
/*FRC*/count=106; tryItOut("testMathyFunction(mathy2, ['/0/', (new String('')), 0.1, [], (new Boolean(true)), objectEmulatingUndefined(), ({toString:function(){return '0';}}), -0, undefined, '', (new Number(0)), [0], 0, ({valueOf:function(){return 0;}}), null, (new Boolean(false)), (new Number(-0)), '\\0', '0', (function(){return 0;}), true, NaN, false, 1, ({valueOf:function(){return '0';}}), /0/]); ");
/*FRC*/Random.twister.import_mti(148); void (makeScript(14));
/*FRC*/count=107; tryItOut("p2.toSource = (function() { try { s2 = m2.get(i2); } catch(e0) { } try { t0 = t2.subarray(13); } catch(e1) { } try { for (var p in b2) { try { Object.defineProperty(this, \"v0\", { configurable: (Array.from)(window), enumerable: false,  get: function() {  return g0.eval(\"o0 = e0.__proto__;\"); } }); } catch(e0) { } try { h2.delete = f0; } catch(e1) { } try { m0.get(o0.h2); } catch(e2) { } m2.delete(f0); } } catch(e2) { } g0.g0.a1 = Array.prototype.slice.call(a2, 5, NaN); return g1; });");
/*FRC*/Random.twister.import_mti(398); void (makeScript(14));
/*FRC*/count=108; tryItOut("mathy5 = (function(x, y) { \"use strict\"; return ( + (( + Math.log(( + ( + Math.atanh(Math.min(y, (Math.hypot(x, 1/0) | 0))))))) | 0)); }); testMathyFunction(mathy5, [0x100000000, 0x0ffffffff, 0/0, -0x100000000, -0, 0x080000000, 0x080000001, -Number.MIN_VALUE, -0x080000001, 0x100000001, 1/0, -0x07fffffff, Number.MAX_VALUE, 0x100000001, -0x080000000, -Number.MAX_VALUE, -0x0ffffffff, 42, Number.MIN_VALUE, Math.PI, 1, -1/0, 0x07fffffff, 0]); ");
/*FRC*/Random.twister.import_mti(502); void (makeScript(14));
/*FRC*/count=109; tryItOut("Object.defineProperty(this, \"v1\", { configurable: false, enumerable: false,  get: function() { /*RXUB*/var r = r0; var s = \"\\u4591\"; print(s.search(r));  return t2.byteOffset; } });");
/*FRC*/Random.twister.import_mta(2121803869,1150785950,706757930,-1845171815,575207621,1952134318,357578728,-648378686,1098389898,1920260112,-136741726,-2002666067,631415561,-1739882419,738273021,759780088,2087398181,-959618000,507267089,-1325266729,-248797624,1357635541,-1010865324,-2037258709,1590427594,1869012057,-1899091564,1428053415,1435336232,-625522968,-310694566,-1062214387,483276769,452627310,-25134100,-670815627,-493452143,-1084961733,-831225955,977869562,270054066,-1207751793,-889190112,112296255,-524482243,-700691370,1853812504,158145875,-1735494774,-2039738116,-488585232,1423960172,-1239212294,-774632670,1844290961,-1065717657,-1038779999,99060561,1046646696,-677088346,-1528133696,1767639256,1254771249,-1433666341,1021101065,-1638020477,485242625,348413248,390992306,1555992555,-612750332,1262199,1273444153,504399454,121657639,1936023905,-1913543556,318860126,531274752,-652985537,-208930717,-8196870,-254812074,-1466433929,-285212022,-1994462153,1490528401,902054704,-1521294184,1809725854,-723167774,2046465739,-373487383,1028709736,-1493556018,453719645,1039661160,985857067,-1263608639,1122398375,1286058505,-1529216560,-749887763,378911824,184830344,566984162,-864100676,-501709708,1802396284,-703467910,-170177032,820708149,-488103644,925115127,-760556047,-384200359,-1897848009,-905840727,-1563542729,306142743,-674204785,-1462042491,1528047230,1348089292,2061455045,-335573108,680898881,-467952009,-72499990,1070917049,-505263012,362957528,872196084,1135829985,239857806,-224473163,-973077408,-787792210,824863555,1553100476,1545145137,-1396052516,1389840949,1827961261,2001087713,1075829325,1823742473,-979503372,-930348892,1758020311,-577795031,-941414603,-1543256591,-1543126772,877816078,-1776233236,1095289562,1092223518,137375897,-171174595,-481040572,-2131391969,163875617,-1227091365,-395537767,-1323934313,-1079496394,1037067515,1933235867,317946423,-1284491597,1164389020,147839735,-1008816062,1689234356,1607218392,419277555,1292366207,-1411532225,1511983960,-381026034,-1472310226,1256282992,1918632880,944693227,1264665586,210999428,-393973114,850043152,444080510,-309495888,-630306466,666461435,-1762710648,-843429647,760830604,-37358597,-1323931712,1980253148,832907047,1598306658,-761165841,2100945757,871796295,-68622024,806923672,-1151943181,189091706,714366102,-1746541042,660167325,1499195530,245806765,1548459154,-2097125400,244300885,-1587129,-317085355,-1316643552,1952674521,182390875,-2060105137,-486778496,216326719,-1895410822,1272730706,2046524446,-699558060,-1035000504,-1959506426,1750101070,1701054364,-11769973,-441232118,-1319599473,1882075842,-1604897315,-839393170,-477169921,-1769617910,329516218,-255619307,-1536039627,1897451289,-288780776,728162542,-461692339,693982260,-294085188,1161100076,-1017352203,-2045928302,1762363790,210886164,1125436978,-1950720639,-1617477915,-88174855,919118483,1649902940,1953244335,-1864137975,1092694813,-1773308073,835727599,1728858650,18286678,-1382392460,-1561614678,1021582395,-1581553318,965943755,-1928022855,-530788491,882912961,735279763,182789818,287325007,-1862202629,-1299855768,-1799750326,-1919690836,-53262244,-452795027,-1841766653,46829030,-822602224,-1345934177,1349674483,2028462752,-323162679,2027310542,1018840382,-713877691,-1272563847,-1386635641,-354190352,475690742,752299581,-418940116,841289311,-1908156073,-1446926946,1164771363,-104555342,822010677,671636508,259296689,1570612750,660520326,1236458646,732376563,-1849800334,-156417383,-967726842,1027345655,-197611436,-252499349,-1227833630,1418033969,1504841711,1793617019,483746369,-2104162006,777684581,1674590458,1355745889,-1676802668,1825475164,1138327619,-897913198,1459749803,-1608892415,101951845,386308600,207746819,1202228347,-1676415866,787340098,800423479,-650324939,1403799241,-1745085621,-1702342396,-467262346,-1630335239,-179626461,-781317229,2018922825,-1627775658,-2061919240,461332444,-1074049677,-1263435444,-1234497329,-940021338,251815484,1812331143,1150448545,963173880,-2027530557,-1925183894,-1194273783,-424984540,182639723,1706854883,361502396,1905725361,-473753924,-809303881,-1729591929,1252219114,819575470,277296679,-1449020706,-1653885064,1203077084,-18866039,1966030911,1831912631,-1571287820,1615030799,-958209974,-358155592,1292907315,132922170,1371886594,643231746,-203084845,-1271656424,-1798919418,1097526356,-1567735825,1380286756,-1398430899,429652758,222263266,675110421,-1377252856,454056265,296571314,-1377084122,-247639000,1801694574,623841168,1663931385,1838758657,-1027122913,458467239,665201851,-247504245,-1275171831,1389154957,1707837419,1149272453,-1348685704,-1413152121,1132577176,230242969,2131908315,-1631296144,162659180,501108741,1715377729,567330303,-1862660529,522233310,956034715,-870088221,1282738041,-1506518202,543878275,213344359,-1936626707,184707241,199294906,-1278041880,1945937895,-270900853,1468413516,-889533274,1300751769,-1742764702,-1859853023,17221312,-1297041944,-1898046771,-926773369,-418251546,343497163,2089864254,-1572084246,-997787572,264054422,-1846545315,-650989737,-566088803,-2062119181,1870602666,-2109265712,1402375353,-2098473173,-692302975,-210513885,1723192853,-1045115168,376024237,-261664355,307438864,-574497068,1478812587,-1688265508,-69932532,-939393590,-621485073,432928747,1904470063,-289750611,756894218,-394262218,-1310607101,1433024468,1549257151,-1331903452,-919599220,-960029599,-436658622,1246744970,-844860457,-81096746,-176936633,-284305068,1962717424,-1759224794,-707883614,-962476647,-605100324,-789837915,1248070364,-996913806,1167604831,2021105758,1143530130,-681235992,977749360,1857089778,-990149161,1159395130,1887070104,-1193276831,367081778,-856265986,1161384145,836245487,182221921,-1827320885,-1457014616,-814600037,-1079013570,1514605683,-1077572295,-43751563,-1293961808,564241842,1313813015,-896908288,-1991918847,782363164,1011526698,1796281059,110215254,1069338425,908253771,-2034704811,277377025,-2058779040,415313383,-1147103966,-1018510566,-1923333437,-397892941,-1784540795,1376609379,54766713,-553319601,1253631818,-972034330,-57627617,1805043525,-849633340,851411646,-1375914949,-1893202816,-417476064,-878689481,-1911598345,906795730,268623787,-1003536554,1802132492,1170316736,-1025537306,1138777878,346418226,1442770198,2028307667,-1524277698,462046262,185564145,-789138735,-249904634,-1599006422,1840397311,1639565168,-867231063,-888244550,-557066962,1788456881,1533307031,2063083747,-428936183,2012878182,2106765724,877894437,1539707462,-937920282,1787445999,-279595887,-1167246589,61290274,-232848241,-1462104864,-1090947103,-355497399,1763934739,-1602205967,1370816236,-2142146650,-1690293834,-1969506201,-1928882737,155804843,-533008082,57925944,1767024140,-1553579793,-1782366330,-1670661292,878825351,-621479162,1573481888,-1193989747,224209235,-1220134238,-1855822636,945728038,-610475572,863986832,-1910020847,958794425,-650271618,-1776039872,1370679481,-351546605);
/*FRC*/Random.twister.import_mti(566); void (makeScript(14));
/*FRC*/count=110; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"(?!(?!\\\\b))\", \"gym\"); var s = \"\"; print(r.test(s)); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mta(175543002,-1191647075,-1961190054,-645817073,-1748580495,-74100772,1204743695,1167262549,1511522289,1450542416,530528022,-796244228,-1299489726,1043808554,-1520777867,-168691776,1185756659,-1835657902,773129420,-749678173,-1292067155,744918835,-1521347311,-241067371,-1492507233,448349391,-1783035827,186022635,-1113477829,1771910003,-1046172478,457976524,1091060430,-1720424784,-715110042,-453733648,1244904751,-181344328,1455715015,-1143014991,-151682305,-1973787365,-1915337204,1672280295,647611314,-283053330,211475287,222428933,-242827882,-5342923,-1565688911,-67079269,2090032218,-1821462999,461270278,1015346243,-733588511,-1898007671,-220162428,-1942525827,-239564129,-753748883,235562594,-1796186526,349012661,29548766,-116261245,1829953228,1994602954,1003797167,694567033,-1364717997,-758538757,-1030979609,1004870835,-47433678,-2122233755,-719213073,-1404085589,-1857116991,-1854162992,1434106401,633554642,-966674362,-1997672176,-1456165592,-1434524228,-610699840,-1289224018,-812927821,-1346754000,1618102140,-1518149278,-435602656,998306469,1778863300,323850988,1452364573,1054493973,1689620231,-1031731379,-1161136779,-1881238694,1075452059,1754406575,1645710796,-1503040558,1341158478,1169688527,-1105845461,-2073573761,1091467018,2054859717,-1514347755,561123981,-1690209899,-841982748,-1028402907,1124226079,466039216,35061766,-769287167,1919555221,463641220,-929324877,2141052367,-1968907690,865725538,208176643,-1179345617,1685114736,632618960,-742386740,28588049,-1610934212,1428347003,-297975550,-787090049,-1426017986,-1346037600,-1379638324,858379999,573492938,1256391708,749030524,-44049992,562910979,-1153236195,-1479215362,1908447277,107581274,-1600154270,-1621524670,1754707513,-1494393267,-276012563,-946810065,1454435236,769779894,1202022768,-915363205,432392729,-385030658,-1459657645,56366322,473188237,-750424432,-177523068,-392918761,630584760,2033832312,-1772083627,-249959696,-2092099620,-1890122938,-121348519,-567111920,1084847977,-1509821674,-361835095,1049003430,1041548591,1138108731,1665215267,1380627615,2077982174,1155686,43205326,-987469735,1548548407,-2107469762,1891187105,147890918,231378984,-25779802,420691651,-1304118871,304587773,559572413,2115428957,805903502,2094295239,174608283,-1326194349,1363489383,1687756552,1188120197,2081982535,-1466649624,1600594455,-1329180911,-1439030258,-187615921,1548312148,1721386872,-1415152209,1489133271,-912217532,-613964907,1207687486,-1460833944,-10925615,-430126215,-557937213,-204610967,1833916086,-1070786375,1800470654,-43855970,-13456515,-348938559,828916843,-1991449255,-2039865449,1032067636,-751512128,814642535,-145687370,-1681349127,-78029281,-1621215617,1852475184,343220371,1909060351,-953850587,-2061490891,-2013365319,-2050961293,1325200037,502567476,-1297656612,-745545384,485600197,-1271697580,-1748769548,1801618070,-1916091184,63458644,711452770,-499720122,135075819,754475063,1994037636,-1949100665,-961101131,1448081132,-1391208693,-1484762710,1293999065,-1660161375,-1502750499,-1189402319,101066123,-809337624,-2120158573,-185323829,1849087053,858082835,-1522364241,919577343,-710457857,1696057640,-687000022,72518847,-809765510,-711156340,1121750765,8980665,-278837955,-1587765159,-392464251,177250346,-1301029981,973755872,-1565089456,59933746,1979285972,-1509595208,-1658080315,315861515,1554326419,1862651516,110233852,-1117583812,341208234,-1203014491,268194502,-1078631209,1188422882,18491545,1253744224,-2144152151,1265286331,-917098177,470795108,-1993058172,788173145,-187534015,-1825027525,273897034,1249230274,-1394412710,1800259665,-580361983,1736003424,-1883932422,1790086605,-1259978141,36570507,-1427905517,-1298945647,-510161296,-1206457951,-1377163474,-792183024,-10161875,-1340091032,-753849378,-807634738,-806588160,1432514734,-1283149833,-704292585,-1077719329,349365894,-1599116335,-361200474,-415983491,-581397846,820435817,1444754794,1315878613,633675113,1218044654,1348851889,1273607453,381604019,-550418817,956338476,1230735474,1192508196,1520157415,645363817,843358184,2059600209,-1580811680,235286439,-1675237230,-842996133,-145605418,800237673,885625131,1813312116,895323756,-168372063,-1005696752,-675792714,-436822118,252659686,-1904903880,-2118143007,-2053362072,-1696654159,940604009,1430713913,84099767,1418596721,1770688333,1138737685,-1552961411,-934669703,-1961640998,1964410655,1545539561,-1180251377,-301255962,-1467749779,1875752060,1122023982,-103857623,-1783056049,-137778862,-1921677074,-861599528,-399045046,163962441,1376111097,-366483798,-1261476947,-499046239,-1548309000,-1574671098,-801763596,-1151774085,358423282,164518341,1032591867,498515373,-700931565,129142878,1225944478,1771125115,-1291532996,1000631177,-2091772923,1858746194,-77355569,-1894749024,-2082055260,426926648,2043553741,-837406069,-69658079,-1705459186,2045310874,-1317149796,-1080966853,505663243,-1040629976,-777235684,-1551754169,1788184009,2050801632,406928823,-788991824,83893804,-1164825054,-614101221,745362923,-669733530,-811892938,-1852924337,714196477,1372738120,-1631525110,189491855,615603419,-1668542956,810274819,2039419866,504841437,-808284373,864390414,-623104334,-678782010,1240777584,1516389902,-696802057,1082812506,-512761447,2087091345,-1160835037,-517940272,1938602641,1345231705,-281692563,-1281277379,-467013159,-405805629,-586561637,-561613634,551596276,1932320900,-380451050,-106728517,1486579523,-2028926845,-1210605857,1366108124,-1788330504,-61474515,-1127703859,1574820095,-940273190,1574437817,551004343,1819623852,-1017127501,-1689186424,-37581957,-201741113,-1548450854,-549012929,857044725,75314794,506978971,1413667170,-308644301,-529564473,-1644320077,573159872,875556301,1417160356,-558235646,-1878319741,-1141728919,1609369803,-1219707110,-21260596,882486752,-575613307,-69633144,1396856555,-875124736,-2092939848,1082252954,1166237445,1115714950,-1014630446,98232535,1001771391,-1773162160,572500816,-558835175,-1122916377,-1816280370,483025416,723517421,1603552279,-1505338051,445614370,-335429238,295517799,-1737449439,-1852963100,-1338000056,-149704550,-1497993537,-1974518600,840042766,1386105795,552422688,-63204886,-1771430775,1793678279,1495812322,1005206297,-1870383558,-1809670026,-1695144127,-1937382819,-1321725797,-181008588,-1696554013,1986746728,-582035503,-2111220965,-907182711,49759808,-1366804460,-275004854,-83670106,-1871476631,1431812397,-2102156512,-1304594371,-593314706,-492326402,-367390085,-1879386190,862251101,1856798847,-926365616,996006288,-79857140,-716373884,-403053851,-2094393734,457726326,-2039461135,1714002328,-1128854914,1302974363,-476094863,359496501,-1524983507,-142963963,1645395122,-393413177,-1281390516,-386822938,-974413770,-2051556980,-485397584,1833766706,1173280805,-1069505390,1116202237,-1461300245,-197416351,-1116578192,-1964977585,513826790,473899803,900061790,1846653683,-87031243,1448153134,1317539417,1502106912,386853833,1215762316,1116105648,-306666752);
/*FRC*/Random.twister.import_mti(48); void (makeScript(14));
/*FRC*/count=111; tryItOut("mathy5 = (function(x, y) { return mathy2(Math.trunc(Math.pow(x, (((Math.imul((x >>> 0), (((-0 >>> 0) < (y >>> 0)) >>> 0)) >>> 0) === (( + (y / Math.fround(Math.cosh(Math.fround(y))))) >>> 0)) >>> 0))), Math.fround(Math.log2(Math.fround(Math.atan2(( ! ((0x080000000 | y) | 0)), Math.atanh(( + Math.imul((x % (-0x080000000 + x)), Math.fround(Math.min(x, x)))))))))); }); testMathyFunction(mathy5, [0x100000001, -0x080000001, Number.MIN_VALUE, -1/0, -0x0ffffffff, 1/0, 0, Math.PI, 0x080000000, -Number.MIN_VALUE, 0x080000001, -0x07fffffff, 0x100000001, 0x100000000, 0x0ffffffff, -0x080000000, -0, 1, -0x100000000, 0/0, 42, -Number.MAX_VALUE, Number.MAX_VALUE, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(331); void (makeScript(14));
/*FRC*/count=112; tryItOut("s0 += s1;var rvobde = new ArrayBuffer(4); var rvobde_0 = new Uint16Array(rvobde); var rvobde_1 = new Uint8Array(rvobde); rvobde_1[0] = -14; undefined;print(throw ({a1:1}));function(q) { return q; }this.v1.__proto__ = g0;");
/*FRC*/Random.twister.import_mti(455); void (makeScript(14));
/*FRC*/count=113; tryItOut("s2 += 'x';");
/*FRC*/Random.twister.import_mti(464); void (makeScript(14));
/*FRC*/count=114; tryItOut("const y, d = (4277);M:if((x % 63 == 20)) print(window); else {(window);return; }");
/*FRC*/Random.twister.import_mti(602); void (makeScript(14));
/*FRC*/count=115; tryItOut("mathy3 = (function(x, y) { return mathy2((Math.fround(((((Math.hypot((Math.ceil(x) >>> 0), y) != Math.imul(Math.PI, (Math.round((1/0 | 0)) | 0))) | 0) === (( + Math.min(((( + Math.atan2(x, y)) | 0) ^ y), ( + ((x >>> 0) + 0x100000001)))) | 0)) * ( + ( + ( + Math.atan2(Math.trunc(Math.fround(x)), ( + Math.fround((Math.fround(y) < Math.fround(x)))))))))) | 0), (( + Math.fround((( - (y >>> 0)) >>> 0))) >>> 0)); }); testMathyFunction(mathy3, [Number.MIN_VALUE, -Number.MIN_VALUE, 0x07fffffff, 0x080000001, 0x100000000, 0x100000001, -0x080000001, 0/0, Math.PI, -1/0, -Number.MAX_VALUE, 0x100000001, -0, 42, Number.MAX_VALUE, -0x07fffffff, 0, 0x080000000, 0x0ffffffff, -0x080000000, -0x100000000, 1/0, 1, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mta(-356945683,124646531,201800817,1196649000,-1979511108,2006601526,2003057069,1546928493,587144417,1573540466,-1033714220,-309670516,-1118140364,672366493,-656632090,711468242,-1307420462,1113036948,-1183940149,-33888654,-762492181,1570314308,-429199925,-2086678642,-1111151677,550564293,-416815581,76182087,-2096357836,-609094738,-1028228666,-1553827133,365449568,327025534,-1133741069,130577513,-1597984302,-1954382298,899297179,1575202971,-1039774375,-2028856274,963813296,-1328611938,1560673470,-1518771564,-2014743830,-398741893,-471887255,1925980965,1013777929,1378155462,1219185325,-2111551051,381965489,-1715839790,-1883915437,-407851960,-732402066,-983193269,1812849917,2001658674,1945582827,-847694504,-818675900,-1778007408,-1403698732,-319092957,-854184200,-673589523,1479217921,-1327098248,421621429,-1197719017,-2074538950,954781501,-2146116423,-1627289901,1050301650,-82011691,396106774,-181516630,-29811784,-1695511498,1954211424,638816858,-2069987850,-1606978580,-1504309819,-791929445,-940655263,1135368045,-429088664,949825696,-1983169361,1417351561,1974765707,-608332308,-1954160661,-734170411,120739798,-591509979,80164841,1589121871,-1832958660,-864940074,1424837842,-1079409326,-1741405231,-1887860094,-1927459402,1146788346,371944422,-342359975,-1601706536,848300246,652957775,1753384787,-1240399439,1592166600,123126213,512109913,961077410,1626715651,488580528,1443904448,-1843765711,477935206,-984407854,935016637,1348078190,-362414540,-603438080,877157729,1708551602,352390097,791842937,-393085064,-1000386914,1244156910,-343694243,1317217138,-2093490381,215822108,-760337066,-665639623,484020592,-1033601637,1373061505,-198740169,-1225153522,-974945511,-548281651,-656387014,-836514551,117131426,-47027877,2082058140,2063268954,-2040865029,1164862441,-1599810935,1468081591,-852760540,640320386,-594235268,-531285855,-1691767492,-1887163123,-1095386201,1540742780,2054927160,-282151942,-1473231895,510252117,-9777183,-1408519610,-1850516821,1577230902,-2082341187,1688560566,1392096825,659747580,-2092367155,1396784784,-926934685,974420215,1084751615,576965824,-423056646,1652439669,522192901,-2137718043,1494403403,1765156288,-847043696,864304976,-1664550604,51992796,-276953790,-982501362,1957718741,854509626,425436426,-140038222,1071098385,1142267724,2030524102,-1286211087,1093350341,396031738,1267104147,-1709243061,-1908441652,104553543,-339099566,955217465,-1054950581,233594476,-291063167,-1326119911,-1532044486,-1344298210,-136271326,1053861079,-73902285,-1743772865,-737667294,-503574046,-527023154,-2031093566,397266127,-1381502942,698758327,1974348685,-474966387,1717709865,378415095,154063452,1811751892,1596341253,1273935472,-1954255502,143153823,-1714472239,1670974664,638729876,754680678,1399017822,-13023323,-363315422,1790267134,986269295,-1396304807,1899705100,-2048295844,-1705650940,-679113225,-1837561120,-926520758,-1677032518,-2029963471,-1691791755,1519607895,-526023344,-1172605759,237213774,1033801834,278877601,-213073151,1967905241,-2029101404,-2103943968,1580317564,189336001,231491728,-229231373,-1211826559,-1874093466,-76523379,-256922335,1027788708,1117497938,-1469562386,-1921064306,742300103,1546231240,-1028262212,-1092090943,-1632489354,-2010028723,1325572682,-889132960,-1123151492,-1389214406,-135598574,-992254671,-1883866564,1619489698,-1367650397,-1893817047,-2028992444,643386403,-901780756,439127134,2036628913,2110692193,1962339943,1823203897,-614181752,65099325,-2000221982,-1682949606,-895902652,-1532141650,1747187126,1940756452,393881763,193330248,-1017741687,787237133,1701144664,-473460266,101199675,-597218927,1741957586,1464263483,-550640180,1355220211,-997829634,779342967,1471971635,-1702421439,1015632730,1494437147,-1069831835,-420405395,-353144367,598516090,2090488753,1800595325,1385036172,-193388698,1820470028,-505576860,-1020443678,-1267436503,1778026640,-537006030,306608663,-557163082,-1762321445,1918683831,589300406,-1602167753,1459943508,-2127877283,215630584,-825738739,-8234606,-2146628403,-270180007,203637797,-1956929522,-126705080,441772434,1144694695,342583215,891960601,1306934232,-1884203178,-458992532,-1023548913,-1087746561,-1604101869,973823450,-2032387846,-243398659,-1025949819,109480930,-1708244210,440726414,-1006910135,1318691480,-409944552,-910867395,731326850,-41340356,672905832,-1431528364,-2002635319,-978751278,1804830551,1703865849,-332647345,1120757988,-917282407,2057667435,-543907085,1023041410,-741042368,1490227234,-1724363891,-670026397,1280902480,-301402603,-1225650712,-1479908673,-1160670538,1988731904,-765774770,995768810,207880321,1891300750,-582458686,-1515360030,1897612531,-798303325,1559838762,-1541655510,-187505367,1890862942,156870283,-1423604339,-340925795,-1482671388,-1460260078,-2071783972,940137417,-1761514749,-1487401840,323162749,1929104150,954328193,1639556872,1972742579,-1758305121,929458542,592465949,1389804471,1652363255,992281527,2128735830,278072929,-2086751139,279267709,438095315,2144017971,-2002481783,-938337147,640636378,-225380618,-747536873,-1754246982,145035962,1789661008,-288340796,1203937308,728384802,1000661651,-1756904451,745336074,-824278572,229073354,1920222799,606073179,-640794256,1063454760,-497944989,1824515045,-1930993071,-379627719,-2091392673,-1760705561,-2106988401,-1816444769,337973142,12025116,-1657201172,1435139120,-55161821,1219314510,-1321197609,2139937798,583044745,150552190,170202618,-189001644,-1917507123,2081096252,-1644192274,390322672,-1713292244,-104388275,-1258425106,648410487,1273732359,954424861,1625795526,1651259996,267123345,-35462143,-850509003,-261574714,567787283,-1167395113,1421202251,428909469,-357258718,328169138,729221079,-1488784932,56859078,-1926978602,105122519,1209415547,-2062258181,-143872469,357463226,2094019581,-1058886472,1570496144,-771638766,-2055518227,-269052559,-615617281,-1891928736,-1361289536,1559612656,-1567943613,-1055378876,1260607990,-818634654,-1169229747,1026035456,583979837,1474501537,-1255947031,49059491,-688390517,-57049983,1969975362,-49080967,996840598,1332082183,1879843845,151386377,1808521041,1013738719,1400898792,377391531,-495263388,-1242982583,-1153761785,-205930051,-734352992,-859551517,1684177996,-2083577268,1171086768,-48370744,596135553,339953739,-1648053287,1566354150,-72304600,-2124128854,707347549,1170859398,-2085290429,285445855,820835983,814624683,-1255299655,-1444117423,-1314083323,1662362344,852485204,-787976190,-1293545914,-1921060266,-2065385441,178918556,-1128950181,1719452346,607943584,-1105767761,-844554122,1976956158,2134345961,-1795152591,128906586,-1298925963,-1752913182,-1611752474,-677394364,1022322049,587176298,-1117024182,-1232788356,-572547612,-491223595,1266935810,-260391069,1250024240,-486969908,-20068029,391502372,-112093599,-1656558991,-1830716576,-1463774741,1587701103,826655917,1401510810,-1938093139,-1048308669,921600570,-378709438,-115588500,1102408255,-848363113,1947285860,621242672);
/*FRC*/Random.twister.import_mti(296); void (makeScript(14));
/*FRC*/count=116; tryItOut("h2 = a2[6];");
/*FRC*/Random.twister.import_mti(311); void (makeScript(14));
/*FRC*/count=117; tryItOut("\"use strict\"; lexlcp((4277), -24);/*hhh*/function lexlcp(w, ...x){Object.defineProperty(o1, \"v2\", { configurable: (x % 5 == 0), enumerable: (x % 33 != 30),  get: function() {  return a1.length; } });}");
/*FRC*/Random.twister.import_mti(424); void (makeScript(14));
/*FRC*/count=118; tryItOut("\"use strict\"; mathy0 = (function(x, y) { return (Math.tan(( + ( ~ ( + (( + 0x080000000) * x))))) >>> 0); }); ");
/*FRC*/Random.twister.import_mti(485); void (makeScript(14));
/*FRC*/count=119; tryItOut(" for  each(e\u000c in ) e;");
/*FRC*/Random.twister.import_mti(548); void (makeScript(14));
/*FRC*/count=120; tryItOut("let (x = (void options('strict_mode')), x, 6 = (String.prototype.fixed).call((new w.unwatch(\"__parent__\")((void shapeOf(({})\n)))), timeout(1800)), x = (d = Proxy.createFunction((function handlerFactory() {return {getOwnPropertyDescriptor:  '' , getPropertyDescriptor: function() { throw 3; }, defineProperty: undefined, getOwnPropertyNames: function() { return []; }, delete: function() { return true; }, fix: undefined, has: undefined, hasOwn: function() { return false; }, get: function(y) { yield y; (-24);; yield y; }, set: undefined, iterate: function() { return (function() { throw StopIteration; }); }, enumerate: undefined, keys: function() { return []; }, }; })(/(?=\\B)(?!\\d{2,5}[^]|(.)*){2,5}/ym), String.prototype.lastIndexOf)), x, c) { /* no regression tests found */ }");
/*FRC*/Random.twister.import_mta(-1046889875,596272881,1277471943,1674704696,503629691,-1542844829,-1177577541,144175369,969691377,707108944,-1376965222,2099854891,-445273447,1464653045,-1409277286,-29524451,120660454,-1858392679,796861448,558283099,1311733686,360220271,-1455206900,1545855760,1948435829,-2030621405,-651963915,1904671676,1233511499,2047590233,-1529018233,969655383,-1179144086,309526423,-178029399,-765392654,-316946551,-1847647394,-563527913,231507434,-2050821666,-127030365,1947507559,1101675833,634822055,-1386750627,1706632701,-62876459,-122204416,-847796034,-484452932,1804038416,1926359777,1488170848,1187163242,-654462154,-484587035,-315034823,-564446084,-1728110876,343069171,1720943358,-980045103,-379817801,1206620179,493805632,1992902552,1977806940,839150390,1093304402,1745262360,688870864,809452201,1070124812,-55391486,-1558370998,1636218113,475804139,-1396759865,347925769,2045518214,-2113138855,297264686,-1736851010,1894808587,-1352665782,-2021780972,2108768795,-218562124,903665162,-1552579861,856998747,-1741945777,-1377815064,932212968,-745379715,529765708,86755699,662956976,733995122,-70911056,872398897,379739090,-885100906,-1045689835,-972385507,-330708525,-466977636,1795614507,424278126,912704169,1349182736,1907804896,398181683,-1465886771,-374973323,-125020697,-845102456,1352215410,304421280,1074128269,1448562077,-2127240980,-1580237079,-33531642,-745982477,-481018406,-281961382,1961022636,770174967,-1170083474,1587112286,-13115111,-1671472070,-1495400369,-889831909,1418175753,1056947118,1090239443,715282921,-1902046015,1967905961,1541461124,-564532263,-70998477,-597947241,-2087295029,1479405755,-225038402,1255081539,-789014711,983928017,1178301446,-1684757157,135626004,404641383,-1605219389,1942818983,2098780504,-945027630,-855197365,1557800732,1241406670,1293440802,-532026159,1902929840,1210555988,1229097307,806482249,225765870,-793700900,2075558478,222891293,-623523110,400082799,-859867375,-2050825252,-609392802,971006221,2079716294,1439416301,65781495,658795306,1555668013,-992198816,-592723233,-1444699621,-1523018142,-534535148,1793938980,-928994073,2104661041,507838966,-513827279,1053610834,-67295349,1221667951,-752301428,349727445,1071722667,1915699917,-412988860,-251449134,-267385626,-1299828954,1462785618,714542819,-1919898274,1432446454,746768761,-280609014,2055063613,1480477961,889501198,-2002675601,1192694910,1791248205,923846387,-1646204972,1310852488,2116242040,1173618588,1973343165,757891612,-2005866387,1816748064,-1448904871,16473163,-1802445483,1310789524,2033651948,623403515,1533820597,-810485880,-2064286427,990525154,-1713297884,-986968519,1000389837,1369180228,580573800,-2012153306,621462779,1403825064,740233998,1693150333,1791837900,-1089499673,487022673,-898466376,-604562038,1651927726,461723399,1950664958,-1423482949,-1925257090,2022224336,-1348850775,-2002853576,1573410253,-974944015,1728480755,-1260911505,1194324484,-1822317091,530240164,1058585425,-362735981,904615897,866710554,-322419808,-1780946890,-1648168061,1400295682,-734743138,1314645780,1526812432,1387521839,-1440467288,-1096085895,926132667,168375713,1358870533,752489954,-1296457250,387052094,-2047627591,-283485963,110608349,-1908800404,-2010428274,1691485395,-565974893,21779589,-98233127,-1635190415,-208933393,1962468460,1924144621,916370078,1288373335,-1558729129,-1521164683,-993975378,-1925340714,1274802464,1577214668,505937084,-502718548,1355004831,-750286327,1540459404,1219993734,269468668,496101332,449191654,-1476109223,-1603929638,-1660816226,-1048836118,-2027249304,1200604946,-1576858709,-1955202555,916969395,879872437,349183945,-148754631,2130390225,-1784955095,369012931,1679465650,840736348,1403608104,1995557436,-852793049,-713779361,353665474,1503651712,-1048084799,899741745,-686841967,-1578658628,1399695528,-1081393566,624711349,-1405005473,-168980019,724891361,-818192059,-1433012845,-1748350143,-225454850,-264601277,909778434,-1655190298,-433170135,97591469,-607844405,-1313643666,-1618582724,-2066070516,1793140142,496061258,9975629,888145663,-1688922953,166710810,1055604222,137294986,995054314,1480405788,-110587906,727675758,806447397,846844790,-1477643757,1295487965,1674972008,-846129214,-680677636,-1417171728,-1167467046,1624354228,-416296679,2043113779,1111389564,-1087496582,-623766001,797988350,-1533979368,303435133,-675041104,-531139859,-1871981793,1954255030,-2070452478,-2036278271,1209110570,-2115333153,37724249,505243932,350214787,683334732,-491023130,-1925343093,337399968,154751571,1113091099,-1560976640,266520154,648969920,-1995524462,572972177,123648128,-1817365194,810273915,-135511228,161045341,849710025,-1086710347,1294540464,1483398304,1309161746,-1996152006,1523782497,1034989657,-261256554,1252557507,-1437488836,1737209597,502672740,690140560,-949008460,274923185,-1691347347,-468377897,1490299738,-1707030213,2114545477,-47823451,1424426001,1326839277,-773961740,1812193009,-823301249,852724054,534958288,1829642580,718285381,-123078591,1680638094,702649822,-1686465521,-634541220,310038262,-537490096,1639749619,-832970956,1444513278,-1434961970,-1292461660,701831437,1873151081,-73482810,1391590433,-245002386,-1175468868,2058687166,300303203,1801486814,-126089969,1130432068,1227632915,-1305574260,357914920,-1374877321,1765899292,1737166354,1842662703,-638087569,-1754432414,-726061223,-1589821415,1063058726,618971202,257299113,1836072728,1796483853,-139329906,-345798526,975307197,710865651,685875416,-608416016,601461908,-1255816887,1496396718,-1281324109,1738771693,-2090443392,424808443,-599328597,-1888924316,-1699284735,-1200639673,-1317769034,-447167981,1083913712,-1859317951,1523425099,2004445971,-212965722,-964768939,1504940642,399307035,969842464,1675924728,399719229,705173476,-79586877,-1053767401,-596302118,998064898,197675584,45630048,117584277,1005474419,-1930115181,148718568,-347918906,-1488754872,-1007345401,-1987858058,-1181216802,1523062483,2106104809,-1052744077,-1705325669,1259182469,230047738,-1973200927,-308009894,-61655109,1958220825,-60105153,-609007849,-117426990,1049332461,-1962094556,-1486546898,1734422173,-824085649,1588677146,-999247385,1256677666,374444865,-95602182,-554995481,2070177805,-1512225874,920107226,-2057732787,128308836,-1892195044,-278111049,-1177812130,466789068,-1067127787,-1457964615,-1205107102,359088982,-1351687466,-339551599,952143159,1524937864,209603635,343821735,1146574156,-30129253,-2114012931,-325541469,-1804249891,619245855,-1186955862,-1258581604,1531587833,371087024,1980948915,840250258,-844124124,-1038736951,-32985611,524659704,873866513,-1526953428,-843939767,-201809210,-860667574,1904133458,1753099540,1219954444,-2143921806,1383161136,-472924810,1601239640,-840697554,1766389623,1823286220,1051339378,-612463881,-1441756868,-1326301343,1363029897,-1310464972,-1469499571,-894584191,1935624121,-593433039,783548346,891539469,1073959703,-1382290556,2102594283);
/*FRC*/Random.twister.import_mti(5); void (makeScript(14));
/*FRC*/count=121; tryItOut("for(var [d, b] = (RangeError((/*FARR*/[.../*PTHR*/(function() { for (var i of new Array(-27)) { yield i; } })()].map(function  x (x = ((makeFinalizeObserver('tenured'))),  '' ) { ; } )), (void shapeOf( '' )))) in ((c) = /[]/gim)) for (var v of h2) { v2 = t0.byteLength; }");
/*FRC*/Random.twister.import_mti(255); void (makeScript(14));
/*FRC*/count=122; tryItOut("if(false) v0 = (h0 instanceof s1); else  if (this) {f0 + '';/*hhh*/function fjczxq(){i2.toString = (x = -0);}fjczxq(); } else {const d = x;/*infloop*/while(this){v0 = t1.length;print(\"\\u3D82\"); }/*MXX3*/g1.Date.prototype.toTimeString = g0.Date.prototype.toTimeString; }");
/*FRC*/Random.twister.import_mti(544); void (makeScript(14));
/*FRC*/count=123; tryItOut("e1.has(f0);");
/*FRC*/Random.twister.import_mti(557); void (makeScript(14));
/*FRC*/count=124; tryItOut("{ void 0; gcslice(8374855); }\nh1.get = (function(stdlib, foreign, heap){ \"use asm\";   var NaN = stdlib.NaN;\n  var sin = stdlib.Math.sin;\n  var tan = stdlib.Math.tan;\n  var imul = stdlib.Math.imul;\n  var Uint8ArrayView = new stdlib.Uint8Array(heap);\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Int8ArrayView = new stdlib.Int8Array(heap);\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    var i2 = 0;\n    var i3 = 0;\n    var d4 = -8796093022208.0;\n    (Uint8ArrayView[((0xc2a9187)+(0xb73e94f9)-(i1)) >> 0]) = ((~((((-0x63820*((0x6a1a3b10) != (0xa6c94178))) & (0x745a1*(i2))) < ((Float64ArrayView[1])))+(i3))) % (((i1)) & (((0xfb0da467) ? (i1) : (i1))+((0x73224b56)))));\n    i1 = (!(((((((0x7343045b) / (0x36fb2e2c))>>>((0x3f2505c1) / (0x5c2ad074))) <= (((0xef4edddf)+(1))>>>((-0x8000000))))) & ((((0xffffffff) / (0x4e76277e)) & (0xfffff*(0x772b9f67))) % (0xacd57f6)))));\n    d0 = (-7.555786372591432e+22);\n    i3 = (0xe233ab3d);\n    i2 = (i1);\n    d4 = (NaN);\n    i3 = (i3);\n    i1 = ((-0xf55f07));\n    d4 = (36893488147419103000.0);\n    (Int8ArrayView[(((-147573952589676410000.0))) >> 0]) = ((i1));\n    i2 = (0x8a9cfd5);\n    {\n      i1 = (((+sin(((+tan(((-1.0))))))) != (d0)) ? ((imul((i1), (i1))|0)) : (0xf83f9f7c));\n    }\n    return ((Math.atan2(\n\"\\uAFDA\", (void options('strict')))))|0;\n  }\n  return f; });\n");
/*FRC*/Random.twister.import_mta(1315790758,-150243690,-1342019517,-1808436421,-1794056462,-785342079,-168193001,1733626945,-1741731677,48940653,-291144295,-370538104,1348188581,434296599,-1061654255,-896129439,-1280050558,1356933764,436656452,391935904,1683533996,490273883,1555331649,472109008,-681953026,-1376549755,919291084,886006208,-18973678,-1227455291,897636450,1450400502,2053137960,-1003308938,1959176477,-962074997,-1887381989,-429993499,-573156200,-420190664,-1108717996,2034381911,-942356218,1992670121,-616277408,-1530800180,1995881793,274233713,-1470709984,1130128264,1780574296,-848403205,109706741,-607605132,1213356309,-1050164749,1961778508,-1258277534,1577402756,214390134,1391810188,1973139075,-1145107078,1350913816,-1136531068,313637569,1431796807,-493057955,1919204360,-983120670,-1385664940,-73268427,235021541,1429857375,-1443719254,-1431639013,-569730759,1031382320,-972841101,-1829037644,-246428817,793836805,1642606064,948371637,-2134735161,-1761204653,1189958091,102792700,2114628423,-2015075581,-1376588182,-32859659,-1589517190,-1330925322,-1964800676,1704409173,-1283656514,-931284184,906388653,-2000208751,-1715051671,-1192122790,1111276454,2058938453,-480250198,862629021,-42175702,1983724107,-1261744784,860856637,-848449381,2017480832,66608391,-678099854,-1700596234,369163402,-1599165935,838797275,517897675,-2134581959,-775453975,390679371,-471394225,-2076068544,838656817,-1377880009,1290112303,1907957782,-1924987580,438487330,1419962076,711428032,1190325749,556047678,1529923738,817775452,-1761842015,15557352,-695104776,-472866474,585971960,-1213554215,-47588170,-379790276,2101731701,895985504,156073785,1307771846,388545,1791474796,1029325413,496382190,533606998,-479222108,-228149903,1203824209,-1101041002,-84091573,1764844491,-371556549,-1809831308,-99328384,1575502748,217122073,1315015426,-1588940185,-1173609962,238497127,-371840960,-1852536400,1711924203,1606998596,-2072781612,1791972618,-1439676415,-309357768,-2045482690,-46658194,1730039147,-1080876262,-1937563133,1475698905,1231043922,-1550801075,465956883,1502360847,1987361326,-917393504,-1047709042,-434976171,-240145289,2033213768,-1682813867,-1832265331,1725956819,57183005,919719614,-411918172,570729126,1840091632,-1068922908,-1271736029,158779169,826096263,590294053,209022684,1421413279,-1988161651,-801558981,-96409941,-1921080394,-642075241,606630261,1176958495,-912588029,479767576,-742458321,-1089234978,-814205559,-172220483,1369880695,2137470768,941997748,-1475144476,908583687,541253879,-1541008367,-584220205,-1877216932,-1936072651,531231513,565080439,-152511931,780900954,986715952,-1797268559,-109809234,712872736,-1054601814,1092015249,501918212,188064691,-482315339,-1514376443,-73651099,794851874,-1848442484,-1277972389,939639431,827323524,1830353543,1133519778,-1747853062,-1169138738,1917851135,-2103827206,940777934,1909434622,-1583365937,-1046932849,783895120,-140370955,-1523572855,523809834,-1449936713,1532148207,1254907310,2115458407,1620463194,-240064298,1009373106,212702078,-847593651,1559029646,2004191995,-2049566552,-217243456,2134078220,187912984,-1005020681,1204061307,-114969144,-687158526,1840418211,-24589187,-973855225,-498939437,-2001323587,1921430709,-5592259,-1142620754,174632210,-887152548,-246593804,886064186,-1834354144,-1088768300,221827197,-521315718,-1318119919,-574979157,1649428559,-926253620,-1735112238,1485069728,-385700331,-1645680662,-1068809031,-566652907,-784115669,1433388403,-1533454716,-1627273299,1210425889,188969615,-218090060,-673800210,-479063003,-1632331264,-489376562,-747875457,48934998,-1188727416,1898426296,1263398701,-1519985770,710843346,2142455262,724879633,-1848945896,1219864076,-95307388,448660105,-972777932,-912245241,1199158784,2043011548,-509459621,-1047830721,-1071607360,1696234341,-900644952,2142644446,-1083493088,-93741986,-1846123077,1664787712,492128582,-1445180618,799363673,1454121023,1220217166,1288357961,402162222,2131936869,1734121743,-1044190805,-532097562,1925068407,154262635,1665777464,775969357,1047979769,263768024,-2086809272,1110683772,-1490598309,1033414151,-1279403108,-527534653,-985512526,1106355850,1623727831,-2008188044,1422912125,-1963252713,-1789606563,212944849,996064015,1954080040,-1230212900,-1353557092,933769355,348138181,521655565,1210997109,-162697210,1614909868,-1378061185,1335945488,-588074120,1702908762,1214888910,1798404934,1946871100,-341992511,1271682927,33631230,-969596044,1550105639,1707204996,962008479,-103613154,-1219910835,581857780,756049211,570899180,883401937,1183830361,244407935,-1329096659,524462938,-1852314728,1977345646,-1064880837,10513516,-572199945,745255174,-110488461,489157200,-195209515,1255500931,611096468,844324643,320051659,-1512813995,1436243131,1008039514,-1592128067,-474239872,1069952053,935229165,801295622,-2055158760,502248548,993726863,-1775570170,425097204,1068938986,-2085362824,-1252145976,1998145834,880250850,1018667912,23958206,-1777209054,-95586347,1730259165,-217607475,-1652952501,-637184861,584526312,-1258874321,-919551553,-1810831704,-1075791884,1699683091,948247683,1252176776,-472596062,2012272264,-147707031,973367642,-994365619,-636625425,-107558371,501298895,1622156123,-1697762595,-688901286,9093469,-1708347577,-1828793740,-2000403510,-109503281,-1240467741,1173310090,1591573902,-328010262,572692242,-236526081,-2130431348,1259090985,1740463965,1673382111,1060927812,-148828925,-2110001399,-864361294,-796795960,-618593237,632582417,1327655299,1729264342,805019437,-485745119,-1658294015,-1125041484,-428546601,-859205235,-1991421780,-1067563407,-1033716198,660532383,-1173611664,1401514819,800868385,663297667,1757119159,593802360,-821655307,-953155794,1069806450,-1902444318,442036719,1851915045,-833035967,688247023,527214304,1874287714,148738720,1525339991,-820552799,-1157721100,207941965,2053436015,898666487,1120424125,641657275,-43259089,-885654922,-1602847236,-1379699026,-1054547963,875036431,2046127422,1760287693,-2125852575,1477913241,-1713711024,-736315122,2106679458,337714870,880944445,1146080229,1785039188,-1638617433,354494166,124573764,-359138913,-1684043735,-181017019,-901874021,-1855032322,448853327,-1189826450,-1393700891,-1094144352,518733149,139502430,-1653650855,1376006270,78339378,2120110930,253550047,-1653776752,-1916157786,-601834064,131404715,597945327,-170355573,-304157387,2099230764,-1504554172,807867138,921427440,-1131232171,1955039897,-290875300,-1791154968,-121871840,-1407132460,-1407168161,-580724866,-1170924248,-2045538092,37680947,-1052213442,927646596,413220587,-138713117,1704015725,227632512,606397452,803660561,1282157415,-1720572768,-1558452969,961463331,1425475677,-1407780622,1423230660,-473724273,-1531765786,1661549309,498026392,-1714147764,-2131041990,-1341698395,-2095069905,1103654491,-563709342,-1178993042,-289635812,-1384269099,1367480800,-1358431725,1806333119,853126279,-873405673,-768056814,1657213182,205303403,1828387004);
/*FRC*/Random.twister.import_mti(555); void (makeScript(14));
/*FRC*/count=125; tryItOut("for(let [c, b] = false in null) {; }");
/*FRC*/Random.twister.import_mta(964989109,121415562,-1888045723,793349885,-926419584,438732746,1575720370,-1213110918,-177359150,-1940048641,1079156757,-1213547180,-1687648981,160632954,-486471499,-934406439,497775404,-846964327,185489340,-272059487,-1140883468,1312332172,322311608,-537900374,-2061230562,2131310066,674557891,746366914,1740093672,257636490,388815649,-1674953047,-1046286149,-592590748,-1914358409,-250997036,1873222709,1929682472,1212228243,-924855252,-50340608,475845225,1641647731,-1728058888,628728524,-704355939,-1382862865,356961582,-138428186,-815938567,-660723073,692837608,-1331845775,656722166,-1687389746,-830458743,-743384306,-82688406,-1182589617,1278586965,-1690274019,1467823413,-1953077714,1775247946,660752086,-1985517658,1828576188,-1556118549,-618289044,1263862245,-2073456098,1153929328,1701081514,343116424,1450273173,1693658679,-696741550,1131439017,-9274823,-1539301406,-1870810157,-595139822,-1486248041,1754207811,1401917818,-1317917677,1689084323,-978309725,-1513687014,-1579648458,1681265452,-1663428977,-1999371341,-1638873467,-831037980,1453069276,53258050,-303030876,2120691894,1220800618,-527832679,-2023049212,1755141496,-1193104391,14917856,-52656241,-985087643,-1603682872,-1826223358,-1878908749,1537816259,-263250709,145634881,-2108165618,-1943043733,-1231284571,1332491216,-1941995563,-150264474,1068732650,-72759915,-1214801384,764905154,-919907353,-720503917,812461545,-2111699969,180712431,930453246,532806809,1476105053,-1672532066,-302406224,-424829381,-1205248942,1068888097,-2125311631,527383155,136134037,966608817,60289106,646169794,-311118258,867629419,1730327314,-1987112459,310093022,-582644262,1594251106,435240778,468336289,143376751,-618648883,2074370638,266151346,-720255024,1964551556,-145689483,351354668,-419570977,-1010662944,1881087123,-1759473395,-1168142376,-609625710,1504529465,-1605536450,1006094847,-710469048,1740997004,-205205358,99417537,1455702378,2043150420,-1692851031,1041599667,-657566221,-627014296,690113661,1675355531,-2039117270,-904296715,503170961,743844598,435058316,-1759900600,-104202066,-621576081,1813136673,-471756329,-1110421606,-1550101135,-926063886,499373653,-47332804,385450719,396211294,2128917058,2059068319,-1185487022,1611282777,-453175444,-715053631,613015103,1391358378,1352122271,956574975,-1843585729,-108559342,-546603113,1966017326,2065417920,956567295,-66232571,-1876284306,158216358,-1321907725,1405685966,-1303075103,1591482103,1410985767,785085405,-537302683,270738254,-336670630,-2027481924,-1687910262,1904830491,-663165105,1504377910,-1500117351,1790650493,1298352871,1082367530,618018941,-1982362107,-647758481,1623238336,1311336387,-1784819671,-1795067524,1269399984,60333956,-110242367,-1707842424,65525626,791272275,2130128488,1453286350,-1129129948,-29860997,-1899172253,572594197,-938191389,758232511,1002317839,935128309,-1628730471,1710098225,-1761716845,2121561409,1182108268,-1097446207,-496602959,-2019200512,1831275588,1859964480,-860554707,612673026,1070426538,-1633083321,-1697886795,-1200483750,253844045,397263226,-1908846458,-1329300865,-586710029,-1840308020,1249335187,464917010,-253158321,559006343,1979452911,14738870,1370147193,-1855579052,2064358808,-241119116,-698083079,753169603,49141496,-251542308,915798433,-1435795717,-2069302522,-1799235324,-1273020637,-2055689305,-1833860960,-61661584,1913935731,683215582,-1170555006,-285637508,-1316615732,1567427937,1718209286,758120408,1423373809,2059648257,-2063089037,1281904092,-133928901,-63948935,-835864595,1231667451,728522284,-307213080,2020252371,-551182674,-756685024,772785152,-1081942005,-12357521,726170975,1998213765,1813724622,-1886449272,214402686,-2050328773,-726396549,-539046763,948989625,-1009424696,-1346044948,970699201,-1570494077,-1872800757,-483673300,-1484821030,-202074876,-1456894923,844692991,1573715415,-2036959258,823735369,-280502258,2035123179,-1614207486,-310978752,1784688488,999386366,614715410,-1604087881,-1902357772,1877317226,-1213450055,31420788,-597853652,1753547714,1041932273,946443213,-2137212459,2121720397,-2105135513,-27679635,440999324,-808694020,-1881828201,1397631534,-833745754,-1918260145,-518725313,1093709582,-1935375085,-962515843,-1622289415,850899963,-1066003805,739069824,-855536344,1182360173,-476317731,1246717968,802653999,-1763896823,1277430528,399468571,-1185298255,-929061259,-6486923,1815474586,-1706555488,-1758350144,692683040,1724191859,-790740696,-220851443,1680126376,-60081596,-1477420506,-54923830,-1986433783,1428162346,941740299,-528447684,1010487897,1415158037,-1667843240,1677164379,287671104,-302514305,1082206956,-1700546983,-605519867,-1244378796,409859452,-318198695,1810594119,-509488949,-283407882,-1764188783,-2028156828,-184145993,-1988101859,-1487119233,-376467624,-1793015508,327844612,-1503767146,1158616873,1381490067,2012477133,378021159,-225247855,-1816116115,1794396251,2059548540,1672146075,-2021524592,-1978537057,389407074,-1316781908,1489102943,1450880468,-1270582714,-191719778,-109102553,737375211,1095284666,1755180434,2058863804,-781386786,779695073,869784089,-589249880,-2084085923,1532053676,916136355,-502121663,2043940048,847423868,762159943,-2063371503,-1714336645,1020096859,24041677,550606877,-623554571,1836266173,-750056014,1199961759,-895621653,-1124571706,879281803,-1814272285,-939449970,-539122198,-2082809291,-2003415899,-776003724,-1855441026,-1620395963,-2122991813,-948555409,1324028616,407439128,775251848,1242463755,699726054,960296478,1588474159,-534138615,1681540578,-216519075,1639314672,1956373107,1704998316,-53167604,-167327318,1989975671,1151243798,-1379764281,768312973,479835139,-1061459955,-1226611818,-514111885,-1613089246,376173176,1593908239,1457998088,1162007676,-718024491,1334054923,468598865,592586675,892762313,-177271412,-2098715947,350774260,-640173316,1274745213,270923467,112745603,719132705,1984223858,-710340037,1294202853,-369000068,-1206370517,1209846033,-1636416967,1519615385,-2142067999,-847557346,-1883203438,-1981108645,644223323,-2033395606,-165627870,1298404780,-230255146,509516422,2073209700,855247288,-594283892,2124852016,-87510837,1544594422,55902205,1677673632,-1552770819,1888577017,1089554085,1403244846,1404524874,-795066156,1214372198,1368553094,-1048524719,-1863593403,-1487048719,-1395489077,-692341672,-1925454348,2107462864,2066599980,181237423,-574669894,591602113,-1782620604,1762311624,-198045962,-32747234,2088915857,-635298962,553565468,1204772334,1924382328,1870337991,-533907125,855578878,-190451501,-641156558,-50772557,857760256,-1421692837,-1698918173,1801228988,2025738381,-1869325215,1889690938,-1518880528,-1015718740,1196480195,-1763575584,2101164119,-1683828682,-1954643363,-371598698,-553842464,774701532,-1852149707,1046324445,-2146737602,-318351347,361160544,-1080695393,-861353236,378771239,1485424161,1500217276,618989552,-1723587123,1434731057,1224458473,1131267361,86622355,-349466657,136794922,523566462,-485495562);
/*FRC*/Random.twister.import_mti(2); void (makeScript(14));
/*FRC*/count=126; tryItOut("\"use asm\"; t0 + '';");
/*FRC*/Random.twister.import_mti(11); void (makeScript(14));
/*FRC*/count=127; tryItOut("\"use strict\"; mathy2 = (function(x, y) { return ( ! ( ~ Math.fround((Math.fround(x) ? Math.fround(Math.fround((Math.fround(x) | Math.fround(Math.tan((Math.min(x, Math.fround(0x100000000)) | 0)))))) : Math.fround(mathy1(( + Math.hypot(-0x100000000, Math.fround(Math.min(Math.fround(x), Math.fround(mathy0(y, 1)))))), mathy0(( + Math.acos(( + 1/0))), Math.fround(x)))))))); }); testMathyFunction(mathy2, /*MARR*/[]); ");
/*FRC*/Random.twister.import_mti(218); void (makeScript(14));
/*FRC*/count=128; tryItOut("e0 = new Set;");
/*FRC*/Random.twister.import_mti(228); void (makeScript(14));
/*FRC*/count=129; tryItOut("t2 = new Uint32Array(b1, 6, 6);");
/*FRC*/Random.twister.import_mti(246); void (makeScript(14));
/*FRC*/count=130; tryItOut("\"use strict\"; switch((({x: Object.defineProperty(NaN, \"constructor\", ({get: Math.random, set: neuter, configurable: (x % 3 == 0)}))}))) { default: a1[19]; }");
/*FRC*/Random.twister.import_mti(373); void (makeScript(14));
/*FRC*/count=131; tryItOut("g0.v2 = t1.length;");
/*FRC*/Random.twister.import_mti(389); void (makeScript(14));
/*FRC*/count=132; tryItOut("\"use strict\"; h0 = t0[9];");
/*FRC*/Random.twister.import_mti(404); void (makeScript(14));
/*FRC*/count=133; tryItOut("return;");
/*FRC*/Random.twister.import_mti(414); void (makeScript(14));
/*FRC*/count=134; tryItOut("Object.defineProperty(this, \"v2\", { configurable: false, enumerable: new RegExp(\"(?=8{0})|\\\\3+|\\\\d\", \"yim\"),  get: function() {  return a1.every((function() { for (var j=0;j<26;++j) { o0.f2(j%2==1); } }), b0, p0, (eval || b) << (Uint32Array.length), a0); } });");
/*FRC*/Random.twister.import_mta(-750775571,1818622304,-1433876983,-670515068,-354215485,-766761197,-1841176652,798415939,-418907221,430008297,670010611,-2132448417,-664849563,-880849954,-334874381,-1558034711,-11815169,-551248505,1963223306,-399771986,2138159546,-460085627,1142119442,-1556881468,-1868623089,466246319,-1860002939,-958530621,-1898814120,901939504,2123505875,1828260270,2111596342,2040823794,1032461379,-1131617450,1316075993,-1415576399,-688056441,-306205971,-1110275664,-752467814,1876236391,-717411594,941321102,-655047094,-81729989,1662912556,-1461912329,1090770854,-1606977302,2017024064,2019628944,1291750237,-1764407543,326084923,-1394222869,-340783719,-859458836,1212697081,1903260952,1587182523,1114845318,-240969686,2097659651,1157383330,-1510288787,-393107673,1702067286,1056553044,1661800693,308519112,-789804367,-549243224,2017077878,1824112182,841835744,441051141,1716046202,1122635733,-1505603577,358729470,1855316427,-1588493288,1343142306,2050373488,616177227,-745092298,-1751511948,1022368606,-1892893568,-212347250,-1674662506,1318016532,1383268336,1597530766,-690896933,453631417,-679881112,-923160349,925810289,300850960,2041405231,-1233708582,-772117137,-1087224197,-34166493,1683522316,-846195579,879182771,399269180,1006955916,-1628319963,-915111406,-1656248446,827412704,-631907511,-1363787162,274585726,-1087237564,2023353023,1677573032,1223824544,1902538691,-707377697,1104022492,-1752098731,194985396,-1873800688,-1742184112,2019773885,-1554661149,-1484945369,-1240125611,2127198180,-776121994,1221160927,-946515060,93630950,-860834505,-1669235981,-1085213316,-424288975,-1252163101,1810857991,72992707,-589016261,1910354231,2003449025,-1509448137,1105109732,-901902711,-2028305940,1543385391,702290965,426971746,30560792,988412527,-360244459,843223518,-1297061924,1107605645,357441162,1011259983,878632594,-2134021926,1672362961,-2046751761,-1520864098,-1260810819,-1503421713,1347416217,908686981,1228609841,-448702649,550552674,73072508,967546903,1458115332,2142803588,640051403,-150409717,1373915285,2118419774,1693848035,-1664599780,-963745770,463757980,1899020806,-1575918978,-68847513,-819723998,1297468182,1439331234,-1429593795,-1688566194,1339046939,19036640,-539087099,-1369605456,-1533054122,-1903879576,1357811702,-1576420728,1486534022,1534570048,-1104461924,-312888772,-924800055,-90380375,-796148883,-1878234944,412875458,-2067931941,1378127732,-652488185,814741467,-1530403745,1864539753,-427817603,-963196456,-174472884,1295536436,-555948046,1270143348,1384560955,46393380,1718931861,11569019,550204826,878568549,1431964783,-233969658,421688149,-1300911202,314488259,1774269577,-1712091187,321074068,-1830843429,-1364489466,-305760463,110894294,-1303280453,-1630046662,-73911172,-682597990,1413351517,-87373161,-1576550032,2103253034,1485254618,-1496792959,1588785541,1107975963,201630717,-1547701213,-1787980908,-24210504,-1678840503,1520351940,-1144419588,1421306833,228786393,-583826797,-510431065,1391290148,-275719503,-859769777,-108447589,22265075,1679975075,107797427,-252311930,1677893743,1773564183,-1232558464,-384767860,-2079702186,1975131801,-310200923,1601509013,-1332142317,-1399477712,1517148666,-998851386,902661941,1235295522,-1398749416,-1928742344,-254413994,1166499181,-2034366291,700964303,-1429872988,789811412,-33646822,-1195772423,1530618008,-1362819703,1061268942,1818668825,1906631159,1162979038,1116400867,-1846083819,1910434390,-1328173077,-1509815079,-889417836,987420158,909811532,-549669966,-1012222680,763928607,1780899030,692466760,-1175151884,376056632,-1279499583,670934404,91561456,-638475692,813217587,-677030967,1979469813,-17551868,820590261,1468881967,-499067795,1160094136,656260090,2054341112,-602138041,867892986,141917370,-1134696531,-957659162,1301360666,-850495032,-1332819824,1356583239,-243949888,1840977277,-1375897195,-774245755,-2003705277,-1657300075,1813588137,1045004032,72775799,-937495648,1402987477,514355025,1288770766,-408757979,452382163,948761863,-1921286667,-750843450,806408306,-67760419,1224457539,-1359303130,1608447072,-474950897,-2120991751,-1150853747,1639092200,-1894594522,-1837463632,-1271666945,-304412797,-1132723012,-293125279,-1926098400,1890189076,-2121413690,1930278663,-786684372,2105472955,-739762692,-1313449645,1693836816,-1274377945,2028020430,1414567006,543122190,-945755126,-402031249,-629102422,1111762527,-1914082550,674685361,-760886401,255020664,-1665749719,1174414262,576563277,136113063,449000482,-1692556894,-48971207,1858796777,-1129070515,1722372250,-1196601481,-1795025762,-113003609,-1189656601,1993753758,-888840573,-58151830,1389822949,-279408063,735766188,-299394880,1416208020,601427294,-460483668,575125337,2024726314,-657137028,-1403281633,-594201167,360231397,-627393252,-301001792,-952083478,1136764221,1501987267,-390468720,-108599815,744988112,1293450283,403192096,384728923,-303390509,953265746,458950410,1488820683,431914949,-1042673071,-974671061,-1879395659,1962977098,-1664528846,589423636,963168358,1838942953,-359526085,1995389738,2050016468,-856178421,-426275770,784393775,-132093205,1509244979,-685822879,1510753657,1707636029,-1422590176,-1660889921,-230146594,1276352815,-733135898,190863202,667678679,1503944724,-382913193,-1678507422,1679637930,1205761622,-1993583751,-1761420345,1781287225,-972598857,313772767,-2140999137,2072729100,913145407,180241572,-625389824,2047713121,1876835324,-1711596836,-1748341051,1300498688,130417958,1080891298,289242070,1802250971,1217337596,552617429,1326742848,-1139143113,1523349885,864265765,1514684325,2104475494,313588066,1179511652,-429917653,2036716825,2119467602,1029654415,785100626,69707331,278400388,-72554961,438146280,1897823614,-422062344,-2040733824,-1217681928,945772527,94902590,1934000109,2133908395,1589815576,1672735797,-2043804710,-739858251,1826938016,585984871,-681747369,-1779996496,-1935830004,-1811946444,1151607113,-2141910636,-1081329484,130379478,-2053118907,703876676,-1061180842,-1927494691,-416861684,-67033282,-598024313,-1195710151,1262136009,1392842301,1718188299,-2076324026,253177828,-1644848249,1487859740,-1592134326,-1208355921,-1462077422,-430247527,-45239468,531901479,-1986452168,2120004792,-879003448,1835762130,1127044937,1388051131,1708445360,-490232057,-1026327651,1933317143,-1380540982,185385696,-1283402848,-1927798650,-860497201,-542506211,-1525533374,-1490889033,-1520653215,-1299651272,-500059366,-1957645890,324563639,1411983097,-335979177,1791376617,-1340255123,-439404364,-1092790950,-1179875995,1416144926,1779396595,-1968228154,-1128712064,799078003,1029043229,195901119,-828609905,-1679695470,-1825577087,-622988325,-1693297578,-2073938858,1978444612,-1176334620,829224562,-930027017,-2114337007,-635137330,-512985135,1202432375,1929905688,1050131189,935172107,1428840428,-673039323,-1229677220,21420776,1414831376,1176639398,-1242185417,879394253,1434201540,1648294629,-640125239,561257530,1814382628,-583027264,1052030979,1813910656);
/*FRC*/Random.twister.import_mti(68); void (makeScript(14));
/*FRC*/count=135; tryItOut("\"use strict\"; a2.forEach((function() { try { v0 = new Number(s1); } catch(e0) { } try { Array.prototype.pop.call(a0, ); } catch(e1) { } o2.toString = (function(stdlib, foreign, heap){ \"use asm\";   function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    {\n      {\n        i2 = (i2);\n      }\n    }\n    i2 = (-0x8000000);\n    return (((i2)-((i2) ? (0x85b7ca80) : (1))))|0;\n  }\n  return f; }); return g2.m2; }), g2);");
/*FRC*/Random.twister.import_mti(204); void (makeScript(14));
/*FRC*/count=136; tryItOut("testMathyFunction(mathy5, [-1/0, 1, Number.MAX_VALUE, -0x080000000, 0x07fffffff, 1/0, 0x100000001, -Number.MIN_VALUE, 42, Number.MIN_VALUE, 0/0, -0, 0x0ffffffff, 0x100000000, -0x100000000, 0x100000001, Math.PI, -0x07fffffff, 0x080000001, -Number.MAX_VALUE, -0x0ffffffff, 0x080000000, -0x080000001, 0]); ");
/*FRC*/Random.twister.import_mti(236); void (makeScript(14));
/*FRC*/count=137; tryItOut("print(uneval(m2));");
/*FRC*/Random.twister.import_mti(245); void (makeScript(14));
/*FRC*/count=138; tryItOut("mathy3 = (function(x, y) { \"use strict\"; return Math.fround(( - Math.fround(Math.asin(( + ( ~ (y ? mathy1(Math.fround(y), ( + Math.round(y))) : ( + Math.atan2((((y >>> 0) , -0x080000000) >>> 0), Math.hypot(0x080000001, -0x080000000)))))))))); }); testMathyFunction(mathy3, [-0x07fffffff, 0x080000000, Number.MAX_VALUE, 0x07fffffff, -Number.MAX_VALUE, 0x100000000, 0x080000001, 1/0, 0x0ffffffff, Number.MIN_VALUE, -0, -0x100000000, Math.PI, 0x100000001, -0x0ffffffff, -1/0, 0, -0x080000000, 0/0, 0x100000001, -Number.MIN_VALUE, -0x080000001, 1, 42]); ");
/*FRC*/Random.twister.import_mti(412); void (makeScript(14));
/*FRC*/count=139; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"[^](?=\\ufe5b|.?|(^|[^\\\\cD-\\u32aa\\\\w][^])\\u0097+?)\", \"gyi\"); var s = \"\\n\"; print(uneval(s.match(r))); ");
/*FRC*/Random.twister.import_mta(808640262,-1374585962,1679330277,-155580388,1798505204,-1271648797,-1610014185,372804935,-1284418639,844249553,209195502,207919818,-592911864,-1713641416,60607784,438683594,-1538392583,-1780832572,533667323,-1851833315,-14090999,1104192343,-183206834,-218067455,-1404878174,1229791073,1446892065,-1677981923,1335488893,2094734762,-663513321,-106010511,2131991236,-565493955,-151020997,129403338,-1598083241,-1083291849,-136356727,1208433539,-2072412002,-701263170,835031665,78654476,902044896,625136019,-1268205763,43809809,360795289,-1932332473,1597851700,89670574,-756285544,2028995168,-1504682136,-179660674,539457304,-2131405520,-739479028,-1063727001,-273625807,-165235678,1658702188,-2109531549,-1991582351,385158486,520642194,1051338500,-885921844,-1544654905,788146099,-388328045,-2037600765,-404154535,1380049585,1590215718,486545316,-1540964486,-766378484,1278134635,1476602272,773894693,1797493760,1584014062,933584668,1374482682,1405549306,605240774,-947710093,-1873006459,875553351,1238455277,657112232,939787310,1156586396,-84969522,-193193002,1688770164,1097754265,-1739352422,997517741,-6938387,1716794251,-481984758,-2133034874,28057189,189371551,-1047250737,-26978679,623739340,438685829,-2031592759,-1625905370,1421756201,699847950,1391823747,-788005197,-12236345,667311821,-521380674,1119396409,1531564539,-8835546,-800031227,-423033292,1093047360,690700922,717578863,-1689686785,1893629617,71287970,1497993464,-2035939780,-13618586,-1756196849,-89560602,-1504359037,1799231159,2146385938,1515507323,-1198569294,374569337,536653737,1413847525,-803276297,-461402241,-2020667057,645948921,-2061743072,-48575755,-457619577,-493570628,1125014503,624740039,-354191192,-39544232,-1681366577,634525805,662568023,-758953178,-1788777141,1233803276,-711981245,2147197433,-492760214,705484458,-382459585,-15063163,-932662047,2042211848,2084005909,1319752018,1648312154,247082558,-146099066,-1485712417,928356844,-918209896,-1265829124,-1723599347,-156901085,436455874,1441037942,460254275,-341105606,-577085103,-193022933,1827719453,2064113356,1851077674,-617924591,1225397240,397462988,-2017421570,-2093930072,1694584640,-1816208527,1815762054,-868423410,-701657603,850273904,-778712801,543697718,-1528974540,-1404956623,-986641152,-1748980017,-1160557492,-1756445421,-807741540,2143005803,426222221,1286890135,-542713114,-1262255308,-1793337822,-850832042,1533820636,-1641885780,909592872,418519619,-1086038445,236613571,167715998,1836341634,1070943249,-970142571,-1453183900,-1099644581,-415315704,1159708404,1379268343,1638769814,-1187776552,-965777543,513374506,-1482469656,1172932644,-1677463560,-1946343541,1982882687,1087554371,-1710901944,-349813020,-401163014,1952918838,1653141740,1531259037,282280943,-1950683045,-549250580,640651837,-1088628868,-298824333,83289660,-951141453,913167456,-1489707317,760327690,308070310,-1011877309,95198988,-1737508487,388914881,1454329787,-1633030373,-423107068,2064730726,872398380,-396034857,-1347834494,-1342520858,490328784,1600214997,-1353714619,247799769,-128285183,490236319,-426902467,2099385749,-1908262411,655646782,-1560261274,1292999653,-1563554989,268566857,-465019146,-102715715,-1331533506,448213191,2038957066,320694776,-618769554,174764480,1763962734,-171004863,1723475428,1130862591,1722853256,-651396892,1221783562,-207936875,2086672201,-1521626870,903180335,-1430353113,-850612671,-1844797677,1264514543,911146751,1165454664,406521541,809085550,-1677059542,285217709,-752874153,-1935245825,2132473819,-922234286,1960078954,985565910,1745406646,1004248200,1185284845,-2023882415,2115269019,1496300831,-1984235675,1472133636,80143191,-255089929,-1109059462,-1230330983,1385491426,-978418030,2034374016,1180181055,2095925384,-1605409235,-950942866,-1512366251,286005870,-1121930782,1592914598,245432410,-91873485,931078571,-1380153678,1148022395,1683661506,-195098667,370034433,-679865545,256100381,-2145599966,1329248969,-175065875,-1685403001,819336219,-558993915,1539540439,1781005937,-304857355,-910542925,-1007759377,-1506939599,-1628450718,-933884090,299507050,1455549553,-1756046779,1073466089,-1170109151,1774452768,1612279017,-45567062,-35901674,70724827,-904223062,-1531342619,214485049,724624606,-1881249456,415602051,1503824138,223721080,-1024656735,-1229907122,-1534699932,-1194306794,-2016345591,-464148753,-417392979,1500410975,-1199341383,1597723306,448380883,-200209172,-743500706,1868473675,53804783,281568581,1226579316,-1341863659,-1173253419,835906968,-742196158,319588399,-545203474,781147193,-1478167587,-1779469809,771313788,1524256212,958249547,1276383916,73530208,-892879170,2068634158,-543447361,-1147668117,-1352968042,-1440468976,1694298486,-1081164629,-512641152,-1591081955,1359874949,696101726,-1784423672,-1870575876,1233768978,-1828535320,675553285,-1227403044,87116385,1613182762,601062210,348791048,-102621523,1248941531,220609219,1860222824,331136211,569142649,-1874433867,1739045666,71728752,277015544,-1571039359,1921562891,1349270504,-2136597429,-1251538250,1728769964,460080369,315414990,-140994533,-1506057068,-901697833,-1398175672,300400121,1740466117,1487024800,1875842519,-642530231,17853631,1524781941,-313726665,-671107975,-1725376463,-872839215,-369511339,-1342100016,-1218724642,-1428661269,1542170091,1182453820,1542076731,1025693884,-345018591,699023804,591447260,25348510,-1412869211,-4445769,1956561702,-1068697392,630854877,-1863252846,-1148126349,1927857093,400129326,-1051862876,-65733214,-946785715,1756208922,461701775,-1857216939,341945953,2085069415,90749327,-343980662,-948910296,-1700824441,-236442732,-432441749,-2045886665,-2083871754,-301037806,1973331290,-1851400145,1395420809,-1073902582,1019721109,-1300863583,-1172520978,-552019712,1014775156,1942951339,159232045,-1713894421,-2084781551,-289136504,-238974709,742593488,-1620921630,19726864,146899694,2085262211,-91501232,1983366980,830065114,-1716090525,-1303033288,-1797774114,1172137977,997719767,-283190823,-177443283,1621098385,-1584781204,2031878413,-1900504484,949051433,1593159502,411244132,707948659,-1426291778,1874239617,-1400648962,-101132037,-1463363753,1575169923,-158028487,1920157280,1920148414,1213577612,229660152,-2076130111,-83916610,1037011843,-1714114732,1350790362,963324408,-1181806595,-2116168915,1518945005,-405689537,-274093245,-1805113054,-989337931,-1547539025,1181218854,-401285523,-1798707201,-683245215,1487608225,-93984342,1450969566,2107921479,-546171761,-1964750684,-1616584478,931515809,897681528,-2131561915,-1793372623,-310004576,1896486261,2013049387,-1910620378,1991421486,1787402576,-2048973459,1407911745,741849555,-1952080585,1733145040,117524741,-1339010185,218834318,351680669,117525362,1035153367,1280953103,644869183,643688399,-1714861549,-729536514,1483143415,1938343810,776256939,1092528869,1972147575,-1908916090,281517755,842369458,-1259362062,-787631425,2012327615,2127653991,1765038314,44093520);
/*FRC*/Random.twister.import_mti(268); void (makeScript(14));
/*FRC*/count=140; tryItOut("\"use strict\"; testMathyFunction(mathy5, [0x100000001, 1, 0x080000000, 0, -0x080000001, -0x080000000, -0, -Number.MAX_VALUE, -Number.MIN_VALUE, Number.MAX_VALUE, 42, 0x100000000, Number.MIN_VALUE, 0/0, Math.PI, 0x0ffffffff, -0x100000000, 0x07fffffff, 0x080000001, 0x100000001, -0x07fffffff, -1/0, 1/0, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(300); void (makeScript(14));
/*FRC*/count=141; tryItOut("g1.i0.send(a0);let y = x;");
/*FRC*/Random.twister.import_mti(343); void (makeScript(14));
/*FRC*/count=142; tryItOut("a2 = arguments;const a = this;");
/*FRC*/Random.twister.import_mti(381); void (makeScript(14));
/*FRC*/count=143; tryItOut("/*MXX2*/g1.EvalError.name = v1;");
/*FRC*/Random.twister.import_mti(394); void (makeScript(14));
/*FRC*/count=144; tryItOut("L:with((let (z) [1,,] << x))v0.toSource = (function() { g2[\"__iterator__\"] = o0.g2; return g1.m1; });");
/*FRC*/Random.twister.import_mti(521); void (makeScript(14));
/*FRC*/count=145; tryItOut("mathy4 = (function(x, y) { \"use strict\"; return ( ! (mathy3((( - y) >>> 0), (Math.expm1((Math.pow(y, ( + -0x100000000)) | 0)) | 0)) | 0)); }); ");
/*FRC*/Random.twister.import_mti(609); void (makeScript(14));
/*FRC*/count=146; tryItOut("\"use strict\"; a2.__iterator__ = (function mcc_() { var wlzses = 0; return function() { ++wlzses; if (/*ICCD*/wlzses % 5 == 0) { dumpln('hit!'); try { v1 = g1.eval(\" '' \"); } catch(e0) { } try { m2.set(({}), window); } catch(e1) { } Object.defineProperty(this, \"g2.v0\", { configurable: true, enumerable: false,  get: function() {  return evaluate(\";\", ({ global: g2, fileName: null, lineNumber: 42, newContext: false, isRunOnce: (x % 27 == 18), noScriptRval: false, catchTermination:  '' , saveFrameChain: false })); } }); } else { dumpln('miss!'); try { p2 = b0; } catch(e0) { } try { t1.set(a2, this); } catch(e1) { } v2 + ''; } };})();o2.i2 = new Iterator(g0.h2, true);");
/*FRC*/Random.twister.import_mta(-484855513,950788467,1409524037,1991081877,-1814379669,-2146419552,1645231977,983665618,-235716177,-704711499,356435274,-237720598,1650632741,-433416887,-1728212502,-1495851425,272047798,-269319063,-573374339,-486722245,858218442,1103553545,1058230624,-306816966,1391814649,405957087,-267763161,1095431370,-551798443,337346377,-1261334686,1458857532,596571209,1928739646,173184759,441836700,-285494463,1412451911,-130390145,1645999973,1221243421,-719300369,-71694165,1351834539,-2037390635,-304327639,-872795644,-1306231830,254255433,137961272,116023207,972493876,-568076623,1637914303,717846487,-793401401,-1256349650,251451050,-500655075,-65269879,-1936997878,-682262494,1382552377,1896109615,1520253778,1748584588,1207378210,1247274545,290210677,-815411271,-142104221,922881769,1023643402,1761647030,-459414078,-411451513,-1575849363,-562871336,1439141761,2011836731,-933086735,1853616955,303548875,-255999825,22821313,178502049,327899005,285239491,781877546,-1216249126,2108482041,906971785,-1930230139,-1712785731,1335851042,1843884229,-1290169442,1168866865,-877070080,-1407231213,-1119444442,2070918991,633541092,1009360420,-592050590,2010332954,2125622160,2091245852,-1551963278,1914908406,477274764,-868093851,492377177,1631965149,567776561,-492363505,1498912822,-164877780,-2113909762,1112038957,1806991650,62958183,-2098226570,2048471863,-112508469,-1758895316,1655578976,1701679019,-853238697,-1652731725,764004972,194150896,64129712,673854856,191067063,-77865020,1965109991,-1918703055,553317180,1503314848,-380177740,2045263570,1178997248,-778554443,1253924620,-1546438283,1156585599,975128121,-1183810837,-204012168,1534601901,1383276178,-467635395,-1712163158,-2027252265,2083149679,-1778216086,2082661325,1527964659,-1580522044,747672970,-1099897210,1656071394,-877723381,1758060758,877006612,-1241067577,-1000881321,-984360711,651089912,2111679044,-691129198,-386614180,-1345490079,263700357,-127360679,1657103722,-1303207149,1096854566,891076911,363527488,-795355503,-1027354848,1215415898,683119864,1775477358,1892955315,168174279,44765805,879746706,-241285171,-430058938,1927962122,912533247,-56715130,-429558967,479507219,-1547611670,-1577750176,1969269483,979880295,930718795,359633055,2132405168,1871946510,-971055323,1516825940,-283312767,733257921,-1061516587,-1276737962,647744391,-78165363,34027885,956640403,1222645504,749254027,2057171617,-719068142,-2051660987,-1264642492,1793732556,-705552144,1095467646,-130843984,-752185729,1444005474,623599957,1261733367,915177023,-960547791,-1559490272,-1668692148,-1741734902,1978480455,-501029157,-1224068953,457126582,757238000,-2140001979,1598768183,-1778431154,-750502611,1681670347,-1782508814,-325617653,1448546730,-1572450590,-585945861,1353899414,665395707,1299909703,-165478471,-1301204679,-68871732,-2077568155,-1635147533,-495363993,1608123887,-1689142857,807433400,-1620182380,-926254301,1554293827,-1033107179,-1957063555,529748566,1362455819,2015008347,-1402020246,124664664,-938275907,1533300508,1163229433,1817068761,-1442688362,-542270680,-1398533786,-563171807,1074428564,841655968,994660708,792058602,1030886744,-537565487,-804474010,434432008,-723847531,50768030,1856770364,2022367955,1997673189,755765356,1936119445,-373817138,1645302151,2011083929,-991954265,462697115,1500182287,-909789149,61169337,-169912574,1643149989,1378137748,-1435932546,-1477980563,885388249,-330023781,816611183,1705571090,423685366,78034100,-1039929740,-1583817033,-239005942,1359235560,1496254672,1281719740,-1850981394,-1377004570,1383249510,-675495572,700326889,-1549142493,2116523856,835358846,-694558940,-536578501,-2068942784,1658524185,518776689,513362667,1550133465,322524,425347762,1280674482,-1789025979,-1343680046,-692311252,700695274,1061670336,-1914709924,1577523227,1382520170,1085762548,1419124084,-1869969728,837679878,566798659,-1474912152,1275000975,1233139709,1654685297,-1678220784,1860466430,1236305199,-320180034,-1110637011,-147064700,-2077132177,-1534993390,109999298,-1914772017,1203547254,1871518477,1035060227,-1581515775,-880773067,-723202051,393045534,-829085373,-684639899,-302768428,79372268,-945918624,683942858,2121628152,-1725471169,994879486,-1939209019,-2134531713,-1455411855,-1160521745,2055747825,-479449476,-90986397,2127806136,-501690611,-1202350791,546136739,-2108761249,-1040611868,860864324,-1412797950,1359460303,482759054,336207979,946460392,1885762548,1050800412,725201215,2036495628,-1497031457,-356788769,1753338375,-443402777,980062263,517523538,1211696657,-1685139582,2118859974,1153336452,-179152567,738995089,10219485,285999565,-1942476070,1352184262,-1238822304,1640598196,-1450409842,-1810166798,-1705288295,-747009494,1751696305,-2064703498,785980616,1034439119,1563374561,467468985,1712505594,187990008,1090733370,881649774,463944532,-783075468,-1182558510,-2090699762,124211391,-1650682669,242578215,-667485770,-1521077272,-340363740,-1494206077,-2020270979,-1126276168,-489720621,901696682,1769840522,1634255946,-1986458844,630501812,-1315572750,1112729872,-1807187219,-1784510853,1596208788,-891485336,1238651433,-549768070,-831258741,434440851,-1360109491,-190706064,873181216,-253394829,1728586157,114876906,-1731709956,2016770055,-1265111325,234540997,1847776200,703483601,1938797960,-1823175239,1407868953,1520302326,-425455129,-364545118,-2064926806,308656638,78642275,630547580,-1149778465,-68825591,-1760200483,202028613,-1126664834,-914311294,-1409320913,1637428359,-1409989390,206330326,950333426,-1765800787,455830610,-61919504,-555117343,1509025308,-910544638,199923380,-732953428,880453067,-1710893616,1943009115,1280185069,1442482247,-1398254192,795599178,-806193821,-561020387,1424585882,1577645929,18906556,649395305,-671274769,-1329956699,-427662401,829346073,359875011,-1774796605,-1828818097,337996778,435975687,-844793516,-1534548057,-929386070,451647751,1251496569,1069194256,-20092047,2125062582,397557688,-1273024293,-886100191,-83989697,-303957085,-758711742,1142845166,-157466076,-1807464157,1985339255,1076164238,498977544,-1198337479,-1130277127,-1040374765,-867500213,1858219351,-1981894578,-1819773379,-1348436972,-650254364,-1601917818,1677932773,-2050804274,1676054196,-1685430841,216972406,1897659615,1356865102,278042212,1980713115,586168965,-2094815318,-778327874,-940847923,-1517528162,-1701964958,595892199,-107691363,1139197408,-1018819735,-728394420,-1792781123,549518432,-296047359,-737032983,-561363390,557188751,-1954884832,-164973438,616353744,616492867,-218914753,1158440567,-1535599352,-1965950372,1021705057,1523177381,-1504254358,1363595134,1150489603,1212068281,1691074294,1411202334,1445044225,-1418621933,-1748454531,-1004615463,-1357576962,-1051644768,320348415,-1318394682,428216595,-360205696,1551622613,-2095598546,-190654725,1525402577,1499288071,2043649787,863219855,-1588637216,989509338,1942008543,587850340,-1792034392,-1622129033,1347936231,-1270728254);
/*FRC*/Random.twister.import_mti(128); void (makeScript(14));
/*FRC*/count=147; tryItOut("for (var p in e0) { try { t2 = new Float64Array(a2); } catch(e0) { } try { i1 + b0; } catch(e1) { } a2 = []; }");
/*FRC*/Random.twister.import_mti(159); void (makeScript(14));
/*FRC*/count=148; tryItOut("\"use strict\"; mathy1 = (function(x, y) { \"use strict\"; return Math.hypot(Math.max(( + (( + (1 + ( ~ x))) != ( + ((((x | 0) && (0x100000001 | 0)) | 0) == x)))), Math.fround(Math.fround(Math.imul(Math.fround(-0x0ffffffff), Math.fround(x))))), (Math.min(( + Math.min(y, (( - (x >>> 0)) >>> 0))), (( + (( ! y) | 0)) !== x)) >>> 0)); }); testMathyFunction(mathy1, [Number.MIN_VALUE, -1/0, -0x100000000, -0x07fffffff, 0x080000001, 0x07fffffff, -0x080000000, 0x100000001, 1, 0/0, Number.MAX_VALUE, 42, Math.PI, 0x100000000, -Number.MIN_VALUE, 0x0ffffffff, 0, -Number.MAX_VALUE, -0x0ffffffff, 0x080000000, -0x080000001, -0, 0x100000001, 1/0]); ");
/*FRC*/Random.twister.import_mti(402); void (makeScript(14));
/*FRC*/count=149; tryItOut("\"use strict\"; mathy2 = (function(x, y) { \"use strict\"; return ((( ! Math.atanh(( - ( + 1/0)))) == (( + ((Math.min(-0x07fffffff, 0x07fffffff) >>> 0) === -Number.MIN_VALUE)) + ( + ( + 0x080000000)))) ? (Math.fround(( + Math.hypot(( - (Math.ceil((Math.pow(( + -1/0), y) | 0)) | 0)), (Math.pow(((y % x) | 0), ( ~ x)) | 0)))) | Math.fround(( - (Math.log(mathy1((mathy1(42, y) >>> 0), x)) >>> 0)))) : ((((( ! ( + Math.fround(y))) >> y) * (Math.pow(let (y = __iterator__) arguments, (( + y) >>> 0)) | 0)) | 0) | 0)); }); ");
/*FRC*/Random.twister.import_mta(-782802931,-1956596075,-768049951,-1371266954,1798418287,-1855792537,-1147807434,1263191511,-1686759294,-1358080190,41993666,-153015137,-500892566,-672135305,-1272446154,212143071,1537452962,-605217936,-387070561,1218424360,903079937,1326520694,-2131607939,-1849980521,1016923326,890673726,-84006916,1711220319,-1150432054,-1635264441,1168322518,-1251507404,1683238526,-2013464291,1798844596,-1522461049,-1307323706,-1852216562,-207458247,1816059557,169544314,1740095620,-165261899,131323238,-510400020,-1110712140,-62648803,892147295,-1561545185,501777265,-1608128094,1423322964,-597280982,-451832642,-801462410,-753411277,1659558625,428412195,-1521197557,-770874392,-33012118,-1357344809,1800902816,1687867264,-349728708,-309825766,-1513731756,1061220648,1243109747,-692005810,845952984,2039080488,844672305,-1434009315,-1837033701,2090231562,1656974889,-1647729449,-1961630061,-826926673,2103559419,-1008126941,-70539138,1057144280,1981552557,338078923,-2081604288,333626614,1045800209,1554580988,2045434770,140790592,-638157372,-619198097,1719385919,-1301040672,-1706810560,-1909901198,-1018477440,1711783649,1920954325,164291744,-497294878,-256731184,572029329,-152894262,901277242,-974163691,1298870960,-1807973226,-857227338,-1679153122,-61808778,625684439,-2026847982,-1554400904,-442919157,367612261,-1507563360,888814893,-1101260411,-695540268,1421758945,1127183237,2063229071,1680101747,1032370121,761564603,-1013746836,1329107761,-932431444,-1520311553,-594564242,-2041409533,2000010651,-601705028,1628745398,785684520,998202984,-2135668351,-1210372024,-639802817,1545949862,-1214753340,-855686517,233701060,272849632,-203074851,969897010,-385257855,-1851040400,398057400,-1929109690,383190399,-1981827521,-2099250693,1955706628,455195954,-908561146,-154343869,2067483558,-191240257,-549863698,-269570644,382581756,-217043997,-1413263558,-348927289,627581799,471789479,-1471889949,-1511917936,151373218,2069836931,1068692241,1390814546,2041914315,592876531,1086380833,-566170644,610733866,1101077488,-1973268948,-1068888427,-362571915,-2141934583,393310876,1853328747,1049305241,-2055635846,-2116204260,1014581618,641875624,-1264667105,-689966566,-1920254221,-1212789089,29128654,-1490292311,-872028715,-427828212,-945666674,1772967385,-1665639020,768568368,-1456816525,26462945,226741279,-1437739702,-392583187,-742177777,1311024921,-2072982084,110990008,-791487109,-709418549,-48555128,1398697202,-392162830,-83830078,1334812988,1496949415,1135354715,-1456077584,1875751319,996097238,1071593911,1841664553,154024277,1752127014,-4052762,628444361,-579517342,1483469386,-481098139,1509666830,-493695463,336691642,1875937506,344583854,-586177840,1149414783,-407659675,1363354331,883824554,-2084156086,1505528153,-1034760541,659060669,170794591,772718443,-1635464259,-182013315,-2029212902,-1092419790,1830923372,1991492779,-1287217666,566751024,1011094562,-2008415145,-1772765702,1377563769,170747539,1295847919,-1133782766,-575874817,-1356926584,1904258993,-1248767975,-1160585113,-1943941534,107605015,1399561390,539770644,-851805301,1270516674,1444548205,886247966,-982293382,-122340340,-945796605,-844181089,-736569002,1905218704,-374986225,1634248829,-1081404891,-1739684023,-837134058,-971278803,-39741430,1295234191,-1860548301,-683611852,-385895456,1839700418,-424763830,-868995728,-1884110337,1918688926,-1469137766,-1788417401,1272001891,-1996680984,1105768826,232542364,-767333783,45595467,-920661513,866306979,1951354359,891771889,1244259012,1795308403,1456964069,1883144596,1608017228,11692727,-1895812041,-1305570724,1302716297,2141458635,311978126,-247794726,-609350465,1296781683,-1686772713,1268636800,171890737,1724896439,-1269011397,1104748665,901387220,-918399924,1799485417,127591659,-1693239457,-256623224,-1464779261,988334391,-2116080324,1431471530,-861250114,900916383,-1938856422,1019182669,-425008122,1600520618,1085604309,-1076314339,-952972370,-864231788,812943041,1511438020,2118353188,2035133294,260180581,-553902403,127903366,-736985590,879921146,1137014660,46856333,-2145737359,-1129378634,157353822,1259584653,715633950,395567529,165310906,1047490278,2065166766,1377752342,-802528147,1840080343,-701246851,70278832,1243581511,305769979,-809671393,1148653656,1186898643,-1864557661,714582540,765006312,-1985660641,-750805761,834379260,376946528,2009166044,1982953742,-1430784959,-1104774597,448307711,722144160,-1894559923,-1267706217,-1647128726,374684972,-137667389,50579863,-661906462,-1780450821,-836842961,-352227059,444404520,722168579,-55236569,-2019218963,-1083207434,-935537353,603271282,-662710389,-147666342,-1358589792,-2090505961,-376368641,661504066,1453784050,-1604782504,-1663928349,1504583904,-569734262,-327113015,-1520665006,-1687589967,1638090804,1883073697,-45390758,-1347339031,676680652,-1985274642,466992854,5263797,-2098966800,-1269273468,-1837990392,-1801470055,330708746,-659579916,-53894752,-2028193729,-2000674662,-1724989204,845295379,-1519391970,-1478448246,65455346,1997728926,-1719507243,1795240965,1771398156,655736910,216852129,-1711093508,-1145657916,-1873792084,1822077,546823593,2012637303,492980607,-1946057320,1827491552,1849722498,903172338,-1242325432,931332825,1206836618,-338197861,-1269748217,-1209184252,1546885751,1856889021,1336760596,512732537,-1702041508,-554483784,-1278593082,1601964625,-231860533,-57203481,605253779,-303265211,-1584648256,-1519076096,-658619399,1523058918,1230525959,1282920134,1861041490,-2117460697,1437597582,-933856634,-382149277,1842534472,670687888,-146319794,-1308206822,-267020616,1066626976,82913173,-1999687471,1636993428,-1792021417,970062070,630992648,1201309093,1951776511,-604308649,-2085803533,-813768962,535387102,186389040,159897934,-1730233961,1145608189,1961710213,1022628999,-1485163121,1353027936,1156708618,2062312286,-1110437702,-1396954177,1505928876,-1453294251,-1190117998,-870063025,1092327131,-141185920,-1759486240,-410602467,1921556551,-644188747,-2119134215,897644216,-673886493,-1682505479,1547970256,673633715,1347197537,-2047011413,-1843601680,2143952395,241995571,172092916,1970702847,-1269564065,-2138447951,-51261702,-170546179,191006590,446394233,-135587867,467634883,-516426596,1680756304,-978375839,-720060859,1942834671,1757879036,1127348430,265531353,958145485,2026147861,-1457459754,1378164072,2065857413,127182949,-2115152881,-42459213,699250571,1565269181,1577144685,892128012,-1825596588,-273104595,1763126769,1065126975,1597089248,-1819998884,2080303284,39383343,1574727053,1437325763,-1477523898,798817774,642697598,112036522,-978274846,880213628,-1350271101,1640128737,-263027117,-1750049507,636894930,601157429,-1938354631,-140015752,-2131608457,724414686,975693736,-1231338451,-726335984,1386937892,-940436051,-83968929,-1287499667,1194686660,1938079745,-555024581,-1740699596,743065277,1401877607,555496716,1259004941,-685139604,1739950140,-1608505195,1753672159,-342098221,824842049,2125483924);
/*FRC*/Random.twister.import_mti(210); void (makeScript(14));
/*FRC*/count=150; tryItOut("\"use strict\"; /*hhh*/function rkerhw(){return;}/*iii*/print(x);");
/*FRC*/Random.twister.import_mti(262); void (makeScript(14));
/*FRC*/count=151; tryItOut("let(x = (4277), x, w, c = new (Function.prototype.call)(((function factorial(inhfyo) { ; if (inhfyo == 0) { ; return 1; } ; return inhfyo * factorial(inhfyo - 1);  })(26940)), (Object.defineProperty(x, new String(\"17\"), ({set: x, configurable: (x % 25 == 8), enumerable: (x % 3 != 1)})))), y = (void version(185)), x = ((undefined.yoyo(( /* Comment */\"\\uA843\"))) ? new XPCSafeJSObjectWrapper({}\n.valueOf(\"number\")) : 'fafafa'.replace(/a/g, function(y) { yield y; print(-28);; yield y; })), jblgre) ((function(){let(y) { let(c) ((function(){(4277);})());}})());");
/*FRC*/Random.twister.import_mta(1757986050,1841709509,1098329367,458963883,-1833298821,-2058946695,1766697935,-1012545938,-1131947348,1530753481,-1988932205,-1918413294,1968544393,-444886675,392617991,237299107,-175547853,441227338,-884324428,8662472,-837182140,-1105432669,-2022469658,-32082937,-2040972548,1691431710,905816186,-248102740,1930896046,-105317286,2064681390,35093406,1740482571,-634575693,-1543673776,-794626675,1394150225,-527836810,1844679037,-1319769671,-1582719414,914631068,1348459961,-395940094,-1574153734,1614188526,1264458602,290466620,-442573196,-1250091057,-846480352,768991079,93988545,-241224338,-1685952189,-2115454557,-1294338560,-2024900229,-217810680,-994933007,1591002264,1974468909,316324457,1113956457,1806073586,-555572942,860698228,-767288604,515193557,-322599516,189264333,-943047731,1738298058,1679365461,-911842431,-195387972,-113147383,-1825826174,-522448527,2100607742,1712264566,-835722247,16602301,1344843202,1871495773,635825715,-1541548994,665734551,-1960820738,-464835024,1593453894,1705208037,-1191929170,-2066197998,-1728854569,411954734,-1891440961,-2002944221,-2015774745,-2016483931,-207477730,-2094290453,-2008228528,-141040713,1065395696,-770505780,-630357567,-207981297,869251773,1139798227,175083946,176017732,274193507,-2143991430,-1630404030,-198369148,-656405923,446033182,1537939422,-1032967200,531112047,-811365208,535116946,-187690504,-269786772,-48199579,845866680,-1921674743,-1487511573,-1923718781,1923644466,-1570491912,-1690669563,352830098,-1187969986,-1760763066,1709370451,-1004152191,417466342,1852665500,573787939,-173692502,1200098354,-682507223,381314307,-1914914597,853985089,590193682,-1545566036,1117012812,1051354659,-1294863620,1391128017,1628874042,766699487,1898601724,386642400,-754504346,-105821891,-1666559665,-949351088,-1439435754,-1562122093,950767633,-934821934,382754643,-482149787,-224361823,-272410855,604636152,14018080,1067489620,-1556905221,121412952,-737473254,-1937795407,-705698405,-412513246,437042938,-1055122239,-815248171,1814432487,-967754838,-1291264379,1252516743,809914874,-1402239163,-611234530,1461151742,-419405112,1906334039,896521770,-2048237190,-1361097489,-340012582,1834477587,555506438,2060439128,1757028136,1456066772,1074122226,1638470666,-100947534,-703231377,-1498390728,-471420409,693244669,-1047391051,-1074881267,924518261,82075404,-1317390669,75215256,-1025171869,758767361,-424507920,1172664516,1742666910,1553750125,751645843,1656617184,-546625202,-1262802195,-2039971381,-164339528,-1211286715,-782616993,-178843273,1509026518,2123774308,-790024944,-1140804022,-378335652,-1041459166,-1353179543,348523903,288731412,-1097135646,-2015125179,1540508641,506623757,-1112040086,-7486447,-270642714,464502511,1050457031,-1197082042,78976581,570675283,159146124,1750900998,1707266845,660039315,1787615203,-2019125606,-783912924,-535055707,737377846,473264527,-91219201,-1861748146,1408770739,1287452187,-326159495,-21219841,-1708306979,-421883523,1080129869,-1253822129,-1807868587,-1367963597,2014320430,1233338809,1531446496,-1362778586,-2143052907,125347878,-673041105,258764122,2042673351,189243568,1683861843,-337324792,-903979960,714464419,448306665,1115668284,-1946470429,314387878,-387993184,1018522732,-1808329622,1332163956,1491944174,-1506032876,1751578164,-544028031,1834870645,421260269,514997637,1882082072,438150685,146454482,-46200195,-203931073,-432916161,-853688555,-1101236212,1940437981,-1071349325,-217596954,-333979782,15802193,143948120,-1781711430,-1287684300,-878240618,-945051454,-81018335,-505162880,2063731977,1042906477,297917033,-1210081454,2084751779,2020913025,326936433,-1771255202,524055852,572753876,1957782901,-966490861,-926021082,-20141081,523386404,-1458931689,-680600669,1916112750,-953287014,-735377369,-2133139484,-193249129,-763883941,456247501,480402963,-1661200345,-247768605,1880826042,1995553949,-1727933501,-1756793809,-1982525914,1007844314,526499290,-1303096677,-1678734756,329241710,-992033869,-508828997,-1322036992,1329496431,-1730953220,258027487,-51966412,-1703781158,1548911689,-756285435,929076652,1734666657,1130706159,-932809894,724671956,-1529621936,-2080684632,-856447450,301060429,9202708,-2102587169,583374046,-331550847,53292310,-1746598295,-531865102,1111516390,-976509550,1684759917,1815949295,-1615346770,-1593300058,-1727835907,62074006,1142224173,-791948655,924195397,-417003663,1900167264,-415590292,1312588181,1955203010,31366213,-541734580,-129171221,1602689683,736637011,199328891,1462908782,1301354911,1748658201,-1224986930,-1712917551,1310590145,459111358,-2056189216,-671948184,-1944877746,-1884462166,180378344,571914614,507292627,-1782179242,2042546113,-2022915670,1112714710,-833308483,677507441,-1140450769,639136974,-518796419,1594664487,925599513,-2109791351,-1570385585,-1374917268,-1334670600,-1059048499,-440226993,2116171889,-677171169,-123654858,674004066,-1132343629,-138447935,-1563257411,158470322,-1478009912,1311485410,2134729046,592353945,-454926591,561162584,1793108758,-1023487298,-1538794654,1311045072,-128551671,69908532,918429874,166493041,893642817,1266715320,1448414274,-1453794139,1655745039,638972501,-1536056933,-1659212191,-1726252462,1036327368,290778360,1018029005,-1272383004,-323042549,-1866271930,-1619831092,-1829081050,793093245,1711669072,834255589,-1821088022,-2025267927,-1915751089,1286053388,2126022105,-1327651515,2034835638,-379395924,-1745609076,748904850,1975764432,2076862642,1969392949,-1804875208,-1106874210,189681427,914888041,-1497841657,-1348618638,-143285058,1760370,374011497,-1070061579,866815633,-259334305,-1796739374,-1962227372,497187550,-1023063350,-1469722864,-794264537,859500846,-1381944521,1700884812,523670769,1186747291,513596407,-376318329,1268885565,-1144531216,511884914,657849796,2056633963,-1689390405,1989082729,281309057,29144099,-1801230952,1111106380,-1892218400,-476521041,863003026,-1230035699,420718830,108976579,2027435280,1737261359,694730881,1925617181,668240709,-2110403566,-1913993897,-1178958665,238749616,-97447860,759866188,1502961540,-32820005,1112549280,-131906695,-412802454,1874410772,1413347955,972261916,-332289822,-1316905892,1116454880,799510370,1345626364,-814858214,904293102,673192974,-894490983,1051378243,938155812,1390967450,-681609285,-742553487,-1120303469,608391929,1857660026,1267078275,-58361909,-780389111,726836902,1194541450,1787643196,2137420087,2010448778,2060079624,258210022,327854378,379797364,-810867007,64242196,-1535552905,1996726157,-228818536,-419614729,1545201104,-1685751127,767128878,-1495502582,347657156,-1246034714,1942877171,-441447427,899675848,-880282710,1465205913,1357012584,2107800756,-697459257,-773827086,-1816870012,1792414492,-336039987,-1741410601,139133297,-1014712833,-192955893,1082569005,-197284956,-1982586488,-1421412628,-588061437,-1892034264,495315327,-1298686901,1885989000,-854830664,1031804577,-1680648717,649640974,1310353322,-748763411);
/*FRC*/Random.twister.import_mti(3); void (makeScript(14));
/*FRC*/count=152; tryItOut("mathy1 = (function(stdlib, foreign, heap){ \"use asm\";   var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    return +((Infinity));\n    {\n      (Float64ArrayView[0]) = ((Float64ArrayView[((0x8b4f8e8e)-(0xa65faf60)) >> 3]));\n    }\n    return +((((d1)) / (((-1.25) + (d1)))));\n  }\n  return f; })(this, {ff: String.prototype.charCodeAt}, new ArrayBuffer(4096)); testMathyFunction(mathy1, [1/0, 0/0, 0x07fffffff, -0x080000000, -0x0ffffffff, 0x100000001, -0, 0, -0x07fffffff, 0x080000000, Math.PI, -Number.MIN_VALUE, 0x100000001, 0x0ffffffff, 1, 42, -0x080000001, Number.MAX_VALUE, 0x100000000, -0x100000000, -1/0, Number.MIN_VALUE, -Number.MAX_VALUE, 0x080000001]); ");
/*FRC*/Random.twister.import_mti(149); void (makeScript(14));
/*FRC*/count=153; tryItOut("a0.sort((function() { try { t1.__proto__ = f1; } catch(e0) { } try { Array.prototype.reverse.call(a2, o0.g1.e2, b2, a1); } catch(e1) { } try { a0 = arguments.callee.caller.caller.arguments; } catch(e2) { } selectforgc(o1); return o0; }), g1.o1);");
/*FRC*/Random.twister.import_mti(221); void (makeScript(14));
/*FRC*/count=154; tryItOut("\"use strict\"; mathy4 = (function(x, y) { return Math.log2(( + ( - ((( + (( + Math.min(( + y), 0x100000001)) | ( + y))) < Math.fround(((Math.pow(Math.hypot(( + y), ( + Math.max(-0x080000000, y))), (0x0ffffffff >>> 0)) | 0) * Math.fround(Math.pow(y, Math.abs(mathy2(x, 0x0ffffffff))))))) >>> 0)))); }); testMathyFunction(mathy4, [1, 0/0, 0x100000001, -0x100000000, -Number.MIN_VALUE, 0, -0x0ffffffff, Number.MIN_VALUE, 42, -Number.MAX_VALUE, 0x07fffffff, -0, Math.PI, -0x07fffffff, 1/0, 0x0ffffffff, Number.MAX_VALUE, -0x080000000, -1/0, 0x100000000, 0x100000001, -0x080000001, 0x080000001, 0x080000000]); ");
/*FRC*/Random.twister.import_mti(436); void (makeScript(14));
/*FRC*/count=155; tryItOut("h1.keys = f1;");
/*FRC*/Random.twister.import_mti(449); void (makeScript(14));
/*FRC*/count=156; tryItOut("{ void 0; verifyprebarriers(); } print(w = Proxy.create(({/*TOODEEP*/})( \"\" ), ({})));");
/*FRC*/Random.twister.import_mti(485); void (makeScript(14));
/*FRC*/count=157; tryItOut("/*MXX3*/g0.g1.Int16Array.BYTES_PER_ELEMENT = g2.Int16Array.BYTES_PER_ELEMENT;");
/*FRC*/Random.twister.import_mti(501); void (makeScript(14));
/*FRC*/count=158; tryItOut("\"use strict\"; testMathyFunction(mathy2, [0x080000001, 1/0, 0x100000001, 0x080000000, 0, Number.MIN_VALUE, 0x100000001, -Number.MIN_VALUE, 0x07fffffff, -0, Number.MAX_VALUE, -Number.MAX_VALUE, -1/0, 0x100000000, -0x080000001, -0x100000000, Math.PI, -0x0ffffffff, 0x0ffffffff, 1, -0x07fffffff, 42, -0x080000000, 0/0]); ");
/*FRC*/Random.twister.import_mti(533); void (makeScript(14));
/*FRC*/count=159; tryItOut("\"use strict\"; mathy4 = (function(x, y) { return Math.max(( - ((Math.log2((Math.log1p((y | 0)) | 0)) * x) || ((Math.fround(Math.fround(Math.pow(((( + x) >>> x) >>> 0), (y >>> 0)))) >>> 0) === (( + (Math.fround((x > y)) >> 0x100000001)) >>> 0)))), (Math.max(( + Math.imul(Math.fround((0x0ffffffff <= Math.fround(y))), x)), (Math.pow(0x080000000, Math.atan(( + mathy3(mathy2(y, 0/0), x)))) | 0)) | 0)); }); testMathyFunction(mathy4, [Number.MIN_VALUE, 1, -0x080000001, -Number.MAX_VALUE, -0x0ffffffff, 0x07fffffff, 0, 0x100000001, Math.PI, 0/0, -0, 0x080000000, Number.MAX_VALUE, 1/0, -0x07fffffff, 0x0ffffffff, -Number.MIN_VALUE, -0x080000000, 0x080000001, 0x100000000, -1/0, -0x100000000, 42, 0x100000001]); ");
/*FRC*/Random.twister.import_mta(-505998936,-851893866,-1787055793,1340109742,602327944,-1305903189,171627364,1436707117,-1549516971,-803205239,787071760,1432245077,844336056,-1666857955,-2058896976,649926438,-1697337779,-1447647596,-806390450,768382026,-468697480,1569025056,1942327434,982670015,-184264667,1487698411,-154167061,1374314534,-2133171198,1536176153,-535267662,-170212611,-2093636193,-742287455,1396448086,1585993755,-2143918525,789662636,1684074316,787937108,-1931402031,1233548085,471813091,-308812210,-2019281866,-2021812216,31065388,-1792527118,-1919053094,435732294,-324221451,2133327038,431829999,-1104597144,453131952,-47505310,-1802798670,-2116793971,-8696941,1507083006,-1438856392,-1524234838,-205854125,1669739323,-2044097476,991310133,255328039,1914932270,-1418154829,1169175147,-2027375375,1654310301,-1750476360,166951163,-1768714795,1969914525,-689611891,2073872449,1373632770,1426224619,-1884881978,1241676907,-1352889400,587277502,-950150710,1823895494,2046964561,2094612297,-1689815116,-125237201,-2022021825,1773766791,967197115,-1609310463,-668123857,548385566,-704102307,-328434107,2086076938,-699620227,803782804,1144828634,-192301203,-1611107059,446893943,78950240,1948411018,1273341141,-1520618904,-969768417,-1386534990,1099637449,857757075,-490196458,527950094,-363978496,200713492,860442648,-928595081,-1652750123,-1676275548,1366302779,492696888,224399069,2094335574,800820533,-1888086438,-887149815,1258349958,997072213,-1643835108,923622002,2046001371,-1439193326,1385552205,-309911755,-1010669425,738034396,509507535,-86539949,486956944,-504247797,1061853084,1810826985,-1847727358,977978163,1021079877,1214585810,-1623124611,-1005738898,-515130873,387507293,1597140873,-605275837,23503970,-407605230,-1744696593,-1487164511,-117827814,864134740,-1703429615,-39899528,-310549287,-292750992,-322282187,-1623010615,-1297052907,968256744,-2118612595,-1118603901,999497299,-433531432,135813679,-696192698,239816334,-659692364,881297307,663427649,-958345336,-1989569217,-1781405788,743138611,-754551113,-352813464,-678949316,-1930874519,-911084296,478686322,-1042501380,119911299,1185812165,-1720694252,-471964794,-754869785,-82077934,-1523242651,1319769311,-772995991,519773858,-343599789,1736560284,1814006449,-1885337252,-2060078501,958118958,1578465829,-753423975,755470740,1521556914,171519735,1110515321,-1237163321,-117666109,1000994043,-1165139088,-910930290,-283272372,947865025,-1830042647,-2083954629,1608285231,240743441,-407050597,-523672145,-464088717,-1077949350,821952137,-1926241085,-227394268,-1123080249,299903115,1465863334,-757124166,-996250481,-2033590451,-1421940769,-814904456,-200236179,-1581267334,-1539178271,-2105668952,1669983079,1364344789,1309393381,804278184,-742553491,-157372489,1813603982,1497062502,1206632457,-1854176274,2141674419,-186473787,-182660186,961108020,1776225679,241798914,1997176490,1369079645,-877242184,590689831,-328544124,-238587528,1717619811,-82879075,-1912269011,-674301139,256609449,-1701720768,-768819419,-1851789863,980231221,-1428579720,381212223,1275152871,-836647223,-1425992434,-1424297128,-623964158,471786423,353322782,787502132,-1742467514,1489577788,360757158,-565930995,-987665968,-480092693,-1857430150,-1377805211,1771944206,-509995386,392204354,472522413,101775156,498694444,-1441369842,313389528,-187995264,-1346438092,-1644881110,-1831938500,-755124356,906086989,-1853004799,-1369860521,170674669,1870272247,-216494995,-690006469,1426770691,506324669,1761366890,1894034828,625377491,-23791105,-1688413106,1676096752,424173895,-584058912,638570856,1237672132,994081975,824284243,1230936410,-320741011,-579157678,1618409986,1429041456,1473885448,633505627,2126776932,-489010612,1002142616,-966252543,1474490214,-1087879768,-1899112193,-1298786811,1934441057,33366658,-280799492,1054766521,-1666237758,-1539314476,691265369,-445605752,1046904373,-990349051,-806223888,1233816014,584858555,537613272,257200072,-2031653337,47124401,-2146841517,2010665118,1872032498,-2023460685,-1503758100,-1943142787,-738944977,-1896134942,-589533145,-1373583598,-1587033211,-1212376161,1498144931,460959281,1048037379,-2085354966,2075615719,1520804438,-1718271061,-1626922121,1548983518,-1339461528,-1207033022,514128130,1226181288,1900057755,-2037104031,-1159210970,1281796552,1475096626,1012549507,-889999422,672544473,-1398476142,1435382585,1571226786,1572958004,405452914,1092046040,-1306147397,1128629654,30809522,2144283429,667074185,867090924,-125799656,1414614082,-1468009095,202506742,2032202648,612110828,-1901072189,-105862140,755090440,-413744201,-718238900,-418365347,-1883752865,1532927399,-2068013688,372174648,-793187341,-1819064513,101298361,-793249486,-1707949575,454542820,-2087560008,1457961377,1308042437,1107574834,-1861276336,-293406238,397879367,1292888611,1847429784,103563097,711917728,-957451028,-1129795243,-1193277913,1046579426,-497787658,2142558533,-645988924,1928108401,-1928509737,-51497304,1600820016,-1384811710,191274408,-190454928,1591746749,-758336752,-1045033744,-1233814334,-659704142,-1780583214,-818235175,-382915203,552708768,-1840681868,1923025402,-101337701,1228583426,1855535765,557624874,1147005802,596976770,-315458733,-90141691,-1965785900,-455628194,1262895911,-1587801921,1737569803,-1677450485,-1075603548,-1565326225,1782162382,-968905308,-1732136805,-1525971464,722331837,-1823531872,-1625445881,-390500366,1926045529,1136332540,442527771,-1645746063,433378511,-779098915,1384023869,1817520511,-1542691374,1386905723,1434599750,-2061542283,-849406343,-1449759366,-778927136,-1472139298,332216669,-698015320,-313747817,-2074988128,-293310044,-439628233,-78793369,1210844223,-464270894,2003643555,402401026,712613786,-2095887103,1678904607,1399305460,1319241335,1838266811,-1341933795,652011063,-234821532,-1289551960,-2004592849,-463521569,-1932263885,868260800,419185428,-1781106138,-1473939260,1966196002,-881400075,1352832293,2055740986,196786239,-1841984289,-1595754075,-490289560,1400076220,1547543366,1410346250,-1043319607,-1389780498,939077204,408815861,-1473140647,-1214876788,-974512574,2019586711,2016863875,1438466141,1041890894,-2007617199,769151325,2135313707,-1272893629,-1136714078,2007317939,2100765006,1886295301,2133963308,1792279651,1585801695,-35214746,-576870509,2123813419,227495594,2115742744,1963091347,-1201396798,916582591,1401482338,-1718321533,1830391961,-241778809,178945948,-801752554,-1730283919,-15533888,-225126668,1312519613,723087150,727370850,-1316377481,-955429075,-1980033451,1652601674,1324748882,-2048731690,-379026853,848590183,-621722390,-1063608150,-995676416,-972950956,1322159668,179797668,-311205637,2089294198,-371475294,369551159,-1117438864,-913760293,844466351,-800120215,-362009863,-257483801,1698420700,1696797477,-1502735582,-1440651406,-2012513070,-1131767885,-32651038,432394942,-1600261524,2076617495,490335138,-1470805981,-728758570,1929911269,-1703952595,-920619758,1266083445,1713012493,42079762,867044674);
/*FRC*/Random.twister.import_mti(226); void (makeScript(14));
/*FRC*/count=160; tryItOut("for (var p in o1.g1) { try { Object.seal(v1); } catch(e0) { } try { h1.get = this.f1; } catch(e1) { } e2.add(f1); }");
/*FRC*/Random.twister.import_mti(260); void (makeScript(14));
/*FRC*/count=161; tryItOut("\"use strict\"; Object.prototype.watch.call(i1, \"toExponential\", f0);");
/*FRC*/Random.twister.import_mti(276); void (makeScript(14));
/*FRC*/count=162; tryItOut("\"use strict\"; o2.i0.next();");
/*FRC*/Random.twister.import_mti(288); void (makeScript(14));
/*FRC*/count=163; tryItOut("mathy3 = (function(x, y) { return ( - Math.fround((Math.fround(Math.cbrt((Math.fround(( + -0x100000000)) * Math.fround(Math.hypot(1, x))))) , ((((Math.acosh(x) <= (( + Math.min(( + y), x)) >>> 0)) | 0) ? x : y) / Math.fround(((( - Math.fround(mathy2(x, (y | 0)))) >>> 0) <= (Math.atan2(x, Math.fround(Math.atanh(x))) >>> 0))))))); }); ");
/*FRC*/Random.twister.import_mti(533); void (makeScript(14));
/*FRC*/count=164; tryItOut("testMathyFunction(mathy5, [0x080000000, -0x100000000, Number.MIN_VALUE, -0x07fffffff, Number.MAX_VALUE, -0x080000001, 42, 1/0, -0x080000000, -0x0ffffffff, 0x100000000, 0x0ffffffff, -1/0, -0, -Number.MAX_VALUE, 0/0, 0, -Number.MIN_VALUE, 0x07fffffff, 1, 0x080000001, 0x100000001, Math.PI, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(565); void (makeScript(14));
/*FRC*/count=165; tryItOut("for (var p in e2) { t1 = new Float64Array(a0); }");
/*FRC*/Random.twister.import_mti(584); void (makeScript(14));
/*FRC*/count=166; tryItOut("v1 = Object.prototype.isPrototypeOf.call(g2, e1);");
/*FRC*/Random.twister.import_mti(599); void (makeScript(14));
/*FRC*/count=167; tryItOut("");
/*FRC*/Random.twister.import_mti(606); void (makeScript(14));
/*FRC*/count=168; tryItOut("h0 = ({getOwnPropertyDescriptor: function(name) { selectforgc(o2);; var desc = Object.getOwnPropertyDescriptor(h1); desc.configurable = true; return desc; }, getPropertyDescriptor: function(name) { /*MXX1*/o0 = this.o0.g1.Set.prototype.keys;; var desc = Object.getPropertyDescriptor(h1); desc.configurable = true; return desc; }, defineProperty: function(name, desc) { v0.toString = (function() { try { /*ODP-3*/Object.defineProperty(i0, \"valueOf\", { configurable: (x % 28 == 6), enumerable: false, writable: true, value: o1 }); } catch(e0) { } try { a2.sort(f1); } catch(e1) { } this.o1.v0 = Object.prototype.isPrototypeOf.call(o2, f1); return e2; });; Object.defineProperty(h1, name, desc); }, getOwnPropertyNames: function() { m1.set(p2, i2);; return Object.getOwnPropertyNames(h1); }, delete: function(name) { i1 = new Iterator(i0, true);; return delete h1[name]; }, fix: function() { a2[v2] =  \"\" ;; if (Object.isFrozen(h1)) { return Object.getOwnProperties(h1); } }, has: function(name) { /*MXX1*/o0.o2.o0.o2.o2.o2.o2 = g1.DataView.prototype.setUint8;; return name in h1; }, hasOwn: function(name) { e1.has(this.o1.b0);; return Object.prototype.hasOwnProperty.call(h1, name); }, get: function(receiver, name) { v1 = b1.byteLength;; return h1[name]; }, set: function(receiver, name, val) { ;; h1[name] = val; return true; }, iterate: function() { v0 = Object.prototype.isPrototypeOf.call(f2, h2);; return (function() { for (var name in h1) { yield name; } })(); }, enumerate: function() { for (var v of s0) { for (var p in m0) { o2.h2.keys = this.f2; } }; var result = []; for (var name in h1) { result.push(name); }; return result; }, keys: function() { return a2; return Object.keys(h1); } });");
/*FRC*/Random.twister.import_mta(1732939129,-1401273507,1077053278,576562216,2023521298,290203120,463892784,-2067222909,-2009578365,1929965668,1023961526,-526816808,-1168402727,-1510662289,-2039611169,1936893860,-614243051,1017718528,-765798483,606531588,-1099276829,-1435398278,-2109199047,1933403647,1869368787,-1183270578,-345543509,1451985824,-1187541994,1913158507,1928002801,907058162,-413183160,613541768,-665774518,-1623212889,2112333174,-186776758,-1412183297,664282256,-1012268633,1968392664,1233070690,-1699944481,827479413,-840940479,-159765295,430201437,-511103775,-1539813491,-1959387857,-885651051,-841472860,-1942547544,-1998525197,-1830286741,1279058123,697281999,-2050552830,904908604,-1059426655,-1840591860,289283289,1244558364,-1441099056,-1078992538,2102144381,-1356742140,383963833,1614571170,1653714629,-284998014,-1766371451,857564810,-2077440102,780025362,1529168731,-1973618450,-642766364,-1041444793,1690844785,-1297760228,2056092386,-1327370171,-381248028,1286653573,-710332382,1310242086,-13876013,1196583473,-201285549,1414821087,-612378526,-1723136201,-195314595,-525987702,-1162031429,-80421520,2138174616,-27128528,-208872819,185369783,-986074364,37492428,-283721433,-1102904347,1383994129,-144353533,22824119,511809510,496953449,-134891851,647511561,1707241245,-1238082175,568942485,1254300920,-201730285,-1171813106,-32981169,-680769803,-55700744,748308505,-1225862140,1787448986,-1956055778,-817381733,2105291223,292144211,-1490554806,783771675,1854379591,1169770156,-1966456253,-1536063622,1792804935,-182683445,1960922448,-149944374,314477710,-35620656,-1636466937,30839365,1058528213,-596387405,794239012,-1817903515,1396843555,442933408,-1852077217,-2026274132,-2004321963,1017683247,1835729772,1285322018,1630051051,1989835693,198719038,620229220,-463603502,33432848,-2057173296,700650855,311112739,187989544,-1094310018,1364490462,-405841919,-1297911923,2091195444,95787603,-1903398486,-1294727648,708589534,-574599715,-907998066,1526401001,-1146252875,581862016,-1199823578,-2129233925,-1684872022,1579610966,-632444055,410085190,-316412887,751084915,1847085100,1601748168,1396127206,1043091565,-1424067287,806542470,-1188371319,227792441,-1332530044,-1152824241,-1576079446,-800972032,-1709483028,-1191079248,-1162528546,303789609,1859671736,1716334500,1525632746,-1507536083,1214470405,-113822591,511585473,671672014,1836944236,2018958609,-481592998,2099246585,-686604342,-1091454680,-1924875639,1891191009,578193438,-315879118,817462463,541882138,-1605034477,969251104,-1007396471,-1406054404,510890987,1811243105,-1849023548,166855291,1374938575,-368336024,-1043714487,1214213555,-275873473,-1878519539,1842842251,733010295,-77294707,1295604227,936357866,-847251575,-862240063,-1937812503,807219369,1378501443,-1830292528,277667745,-1963594546,-1780057863,-870994834,-1007234915,-1211907919,-76759624,-1107080297,1233994814,-1020300416,332117934,801994884,312774602,-1598902538,1963420233,-647447705,718551043,1497106358,-113946085,-823990521,-2058508651,-1732744111,1586677018,608081993,531931009,1232222461,-1480848922,-1274435994,-239782367,-430861010,473024657,-950040789,-1689306702,-2064454704,-24339979,1190968088,-1616554218,-413681430,-581545706,-2004975588,1571967713,1710276702,2061729631,-508896527,682778351,2118407911,-1577222510,65661502,694853198,1492392709,-1193527144,-665992688,2054819220,-313385948,-327783445,-890551932,1148748570,95337933,1868131299,-1001600872,1086512094,-1996443716,654291908,-583486383,1958907971,1577238676,-396723962,-1300092172,916582473,1638670383,2059636527,-2005389098,-1112950955,1894986457,1631480444,-1642888682,1414307097,298619953,-1906741199,-652582379,551575091,1322270838,1029575678,-562306047,-476135895,-398280754,-1668013904,516449891,-1058026682,-572697676,391879514,644263752,1382270051,1884542850,801030900,417131154,1047038048,-2002796214,942878858,1813564072,-1688802048,1214188798,1049131270,2056251254,-1933397254,1430042967,-1525479728,-2006609243,-590620667,427626850,-197321023,378960602,1439960482,1417903026,765569846,41611271,603008729,1051415255,-798461538,139278430,180426944,-2014984549,1053678272,950065567,33943823,107409263,-2050423481,1951362767,-1987103893,-616656115,-942012972,404985979,-859571714,-690035507,1012627192,279523145,539897383,-1546493574,-1054593229,-855798109,-1825538151,-636699612,1012446834,634702258,-1294763193,1910496946,1742014979,-754864826,2085491437,-1554333922,73768497,-1425840426,377228882,-1209472004,1154893549,485623570,-2025985927,814778998,639856024,-36822535,-854456658,-192601518,-1328156977,-219023433,871843801,-664577153,1816528616,342870868,-496766784,-286440659,1897012650,407445535,1832596650,1075328203,-1319494952,1228054592,503172375,-247463143,-1835217596,-834605503,1751522338,-1382796313,1507234804,-61636393,1339608762,-2058098341,-1891651216,1011844941,1095690416,421710005,-1951443183,1424598003,53839165,-493754803,-1453054818,-784011088,-1677851864,889849397,405043622,458535347,434054455,1083666786,-76570510,1435714169,-1994693664,1386521423,-202525302,999142705,-1729194498,1891468934,-201224227,-1902708119,1871578076,1489058470,-845122422,-2117958836,-1035597827,-806867030,-1106334233,1062375212,-882622810,1155092233,643524891,460714675,1877801851,-1703186005,-402972105,865274227,1604158556,-949765627,10217711,-900636979,1631954285,-1892677055,1584231652,1750123328,1461189458,-2077166775,-97541572,-1553216133,1350917559,-635089367,-881948274,-628504351,1945970453,1655852286,826662116,-779710424,-261018207,179483381,-187648968,881200981,-1495481495,-443215562,-1018454348,441999845,50331458,-516982191,-176790590,2045845308,-1894975407,-340765128,-562188985,1956962630,-823893360,1661985522,666823710,-591709776,-1349123174,1138953069,-1204050651,-168245849,-1788642729,2124165460,1510582238,622116804,1377773078,-322009862,-1563090815,-959853007,470541929,-785226506,1446948164,-731187798,-858304064,507119831,-1376423098,1859914365,-1559709383,-1625351809,-1951636314,792594281,-886737871,1699356149,-381086926,1414856552,-2070632005,-539997007,1001267239,-1566226318,-305096018,-1361382899,951587932,-682313113,1339235168,1820548663,-410914126,-2116049810,1900583264,-1858297584,1748099121,-579998950,528798936,2060974458,403685686,-1958582,2119487906,191466171,-465639480,2074587730,-443459556,-1069893017,-1189149298,2067642286,-1601905599,-313164947,328316616,-501447046,-1236662529,721735313,1864532295,219075614,-1347244514,2028354853,-114963712,-72298452,462191497,427945779,-690687818,2024583127,885926887,1341275318,1635387693,1150708163,1005645189,2144956732,1980314853,1043121809,1441662431,545211640,-982718803,-1037597305,-1219899772,1777836260,-1793829917,-82651003,1890036288,-722662331,1295199170,-2000271465,294854603,1130205833,1548469782,811652881,1194951726,-809968926,1105173101,-109544206,981467401,-1469589189,1095037755,1314961570,-606449173,1720975626,-891900953,-689707890);
/*FRC*/Random.twister.import_mti(195); void (makeScript(14));
/*FRC*/count=169; tryItOut("mathy0 = (function(x, y) { return ((Math.trunc(( - (x >>> 0))) >>> ( + (Math.fround(x) | (( ~ (y | 0)) | 0)))) + (Math.max((((Math.fround(Math.fround(Math.round(y))) ? Math.fround(( ! Math.fround(Math.imul(( ~ x), ( + ( ~ (( ~ x) | 0))))))) : (x >>> 0)) | 0) | 0), (((-Number.MIN_VALUE ** (( + (Math.log10(x) | 0)) >>> 0)) && (Math.hypot(Math.PI, Math.pow(x, Math.hypot(Math.fround(x), (((y | 0) >= (x >>> 0)) | 0)))) | 0)) | 0)) | 0)); }); testMathyFunction(mathy0, [42, 0x100000001, 0, Number.MAX_VALUE, -1/0, -0x080000001, Number.MIN_VALUE, 1/0, -0x080000000, 0x080000001, -0, 0x080000000, -0x07fffffff, 0x0ffffffff, -Number.MAX_VALUE, -0x0ffffffff, -0x100000000, -Number.MIN_VALUE, 1, 0/0, Math.PI, 0x100000000, 0x100000001, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(529); void (makeScript(14));
/*FRC*/count=170; tryItOut("v2 = new Number(-0);");
/*FRC*/Random.twister.import_mti(540); void (makeScript(14));
/*FRC*/count=171; tryItOut("v2 = g2.eval(\"((({/*toXFun*/valueOf: (function() { try { t0[3] = h2; } catch(e0) { } try { t1 = t2.subarray(16); } catch(e1) { } try { i0.next(); } catch(e2) { } v2 = t1.BYTES_PER_ELEMENT; return s2; }),  set x(x, ...e) { \\\"use strict\\\"; return ((function too_much_recursion(gpvirz) { ; if (gpvirz > 0) { ; too_much_recursion(gpvirz - 1); ; } else {  }  })(54457)) }  })))((4277), x)\");");
/*FRC*/Random.twister.import_mta(745483887,1685904798,-1171409726,707932251,-1085343484,1225096821,-2019630964,1512667879,1226109508,950491459,-847080171,154631453,1064770874,1793744511,-1958173595,-2024913524,-2043164417,-597434911,1182577494,1683386094,-1143634800,-1455506455,-119594433,-1014652260,1554278508,1575033938,578250128,23464732,290229875,853607395,-716659784,1539945862,-2310109,1979586769,717549147,824908801,-1086527234,1138681040,1870894341,-107784004,1670081625,-1357856224,-1061723965,-1030480040,1567192242,1263632937,77491521,842147207,-31551188,-994588690,-406387290,2134062949,109902006,639067860,-2047871085,1980605274,-546585225,-250727541,1635406511,562762353,966320256,630600046,-1417559961,2055424692,118934037,705614571,-1772985778,272621182,-647941,374262362,148057197,423045563,492305484,609028822,1279978938,-612963831,-1621815844,-1960626491,-898772593,-1259263045,-567191029,2111657374,1260983856,367455135,1885395420,1958341877,257726931,-242652700,2123462286,1495745226,1346979787,2100998534,260603245,676063103,-1428504412,-1213468521,522723910,1325213352,-289958224,281014328,-700694415,-699634246,1972896819,140448549,599531547,863774691,-1193116997,-614896186,-294669918,1655809833,-620530503,1162368906,1079628137,1550791512,-1118241197,-343544596,-1006913116,2058168985,985126600,1562939455,1035207185,2004759030,-292573275,-534356710,2066238427,-1532835764,-1029564432,-1012697888,-10650401,1820730451,1753396685,1054295359,1298134280,67530489,940327254,1867636090,1682615935,-1770164061,662916154,-1644657327,1227691555,1380949339,-1447208356,2081695799,853642727,2039733471,-1526899290,-1985480213,1310013889,2016600433,2146026503,713843942,-1737526341,519450317,2127054797,-308898199,1768899880,-168162432,-1276028921,834112488,-1819434376,-1512514979,1293992404,438234060,1706355397,1889926489,1426915733,-1106389317,1966802081,2146212414,2095155847,-1124377844,-1792761464,251106239,533541353,1425141610,1770718056,1120335752,-31288087,1875480029,1724759236,3274988,-1189039755,-477487683,-679511058,911157606,-860031942,875570669,807040448,1355442271,-198498916,1824998820,-898630099,-1095019794,1558180737,-10683523,786302697,505947493,1931570023,158256263,2099632279,359263590,-179589413,-2073077418,1149241233,521046698,103531736,-717979425,47885050,1496799397,-1099398623,-1263484516,1928867364,-1144222667,468273396,406935738,269629305,-1601466686,-398247683,202770832,1765005243,1365428406,-951941260,-2026332805,-563700463,-1664218087,13802916,-2137182592,1822018684,1742472480,-1681690013,-1974785872,-1326917234,2059003530,-186217817,-1743238627,-683397927,1095911793,-1383234556,-1058864924,1896712586,889188222,2014008371,1493225940,493221226,-161406424,1831180038,1788566431,-1404809842,723824284,-1517325141,-1537756931,-1626845995,1606499148,-949019128,1971989612,326548003,-1666353041,1278151108,-158431290,1705463722,-917509216,-2070417043,1935557664,1866524427,-904819497,132815840,-1205530676,2051294423,-1342307762,1233380259,-876901459,-153080184,390097330,1748432564,533510883,-1214313095,819417393,-980138961,1261134959,1684935484,1671498678,359923414,-793153796,-2103054338,265386532,1706316415,-834045649,393105729,267964183,-748775661,-901294659,-1943779001,-2035491577,1372269409,-347909156,-1556318457,347942945,1964099763,1617623686,316933316,-1552324464,-1107080501,-43430831,285006076,1690948769,-1764274185,-1102039068,2036138560,408342482,-1569586840,-1828118238,1538821311,997303632,-1463255906,-1127661963,-252059134,-199217021,2030479853,-934013416,-918892852,-1706691174,-1197330020,-335094763,-552346513,1888722551,-449154579,524607415,-249279103,1798770124,-1100328454,-881078320,1197308932,-156734749,221638184,-837266431,207556339,-1867597548,1450901550,-262110329,1682364569,-1433952471,-403990107,-590348908,2128792124,1722699405,1797584235,807367825,324122505,-238316762,-580800863,2101940902,1463034936,-802450280,513346925,137371650,540585186,-879457678,1973188690,1739977689,776459040,786207949,-144435802,-323319348,270559511,263681269,-639755906,1280154179,-927609143,-153372868,-112397273,-1427388993,-475522121,1058107354,1787362899,-740683605,-1935337432,470075117,-7006204,-1106342076,-325981068,551943345,2093658386,-529472796,-468501699,1248591681,-826147738,1125985643,-924941233,319593197,150245141,-438966343,139072000,-1100725,-1752367080,-1844134648,1849804209,-1478757056,-1451562905,-568678751,352577089,-458317248,1518922979,-216184949,445559475,-315416027,-937021954,4505491,2054384069,2017654477,66737849,395077853,-2089405434,-1163921586,1040695367,19631520,-1095468778,-1935529143,-102013580,-51223432,130021460,1148387053,-1681544355,-1188540227,-1082092490,980356549,-146404488,152491654,-1700051894,-1717508319,592325090,594305228,-2068853032,1102322784,303821734,578674338,-860976096,581409142,1204592826,-362128283,327995340,1331387067,1893933282,1575827181,1661353223,-464452562,-1732976234,-53152257,1898541063,-84584627,1962511512,-622121759,1821699425,958678881,1146307783,1626244739,528664163,952829266,1409869147,-953165728,1457093593,-768167710,-654767173,795844600,648437412,1803706920,-1622521998,1421842137,-811861979,-231845791,-843933614,-1281673208,1649682978,-2016364862,-1436913671,-2088071264,-1851931839,2093625347,410496836,1990340284,-1051619661,-1470520198,1101155788,956123018,129872148,825809114,1043583396,-1796386386,2102787179,-517950038,-2028859249,-1883847586,-79123800,524842386,-1863956520,-1686871336,1940909035,1944828351,149961944,2089222115,1703600425,160643566,-873973042,-1226771752,-1723310906,-1087408690,936635377,-85925941,377036970,-481978198,-1427431841,-1512579402,2119600989,1986733168,-535501321,1084575884,-150865282,1447818590,699631537,1604142259,-102578771,2094004366,-104264642,-1976310772,584741468,-1116477396,-1710838463,-974567633,-1948230933,-719578007,-681822588,1989636124,-1294180331,-2144471468,1345749509,-237900285,-825101390,-408669381,1570673225,-417167752,-790881419,-1670580985,-689749567,1807418880,46179844,-1109849823,-653872607,-1076722789,1411398723,-453100622,1587819001,-1191554593,-539328077,-688224076,1605045632,-1988099791,1672043844,1400508733,-439535011,144643688,-876374434,20057779,-236365148,1937073698,202558614,1684304842,-1917625682,1452176535,1402106565,-1151067294,-1588517309,-139979581,-1995684892,585903631,17905580,-780401623,1027687601,1945657053,2077128873,1089303351,894450389,571205869,1978157076,-185196039,1583140148,1593180169,-2098522899,-1389857268,153455254,1590796783,1475939826,-1798263030,811322475,2077373395,-900511276,2068479225,-421259968,1123170222,1391507363,-1207108363,1273675688,-116758659,928762934,-185152248,-1350897648,-1727230491,593828944,1028707150,-1740405462,1391415833,1632123315,-946865878,1840747056,925270415,2141262610,211170324,-1640511825,-245479849,-1025131544,-1129346518,-1935330098,737076532,-110801073,-1585520039);
/*FRC*/Random.twister.import_mti(133); void (makeScript(14));
/*FRC*/count=172; tryItOut("\"use strict\"; mathy4 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    var i2 = 0;\n    d0 = (-9.44473296573929e+21);\n    return +((0.0009765625));\n  }\n  return f; })(this, {ff: (1 for (x in []))}, new ArrayBuffer(4096)); testMathyFunction(mathy4, [42, -Number.MAX_VALUE, -1/0, 0x080000001, Number.MAX_VALUE, 1/0, -Number.MIN_VALUE, 0x100000000, -0x080000000, -0x080000001, Number.MIN_VALUE, -0x07fffffff, -0x0ffffffff, 0/0, 0x080000000, 1, 0x0ffffffff, Math.PI, 0, 0x07fffffff, -0x100000000, 0x100000001, -0, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(221); void (makeScript(14));
/*FRC*/count=173; tryItOut("mathy0 = (function(x, y) { return Math.fround(Math.atan2(Math.fround(Math.log2(( - (( ! (( + (x | 0)) | 0)) >>> 0)))), (Math.pow((((Math.sin((Math.max((Number.MAX_VALUE | 0), ( + y)) | 0)) | 0) << Math.fround(( ! y))) | 0), ((Math.tanh((( + x) | 0)) | 0) | 0)) | 0))); }); testMathyFunction(mathy0, [/0/, '', -0, NaN, ({valueOf:function(){return 0;}}), (new Boolean(true)), ({valueOf:function(){return '0';}}), true, [0], 1, 0.1, ({toString:function(){return '0';}}), objectEmulatingUndefined(), 0, (function(){return 0;}), false, '\\0', (new Boolean(false)), (new Number(0)), undefined, null, [], (new String('')), '0', '/0/', (new Number(-0))]); ");
/*FRC*/Random.twister.import_mti(402); void (makeScript(14));
/*FRC*/count=174; tryItOut("\"use strict\"; testMathyFunction(mathy4, [1, 0x0ffffffff, Number.MIN_VALUE, Math.PI, 0x080000001, -0x080000000, Number.MAX_VALUE, 0x100000001, 0/0, -1/0, 0x07fffffff, 42, 0x100000001, -Number.MIN_VALUE, -0x0ffffffff, 0x100000000, -0x080000001, -0x07fffffff, -0x100000000, 1/0, 0x080000000, -Number.MAX_VALUE, 0, -0]); ");
/*FRC*/Random.twister.import_mti(434); void (makeScript(14));
/*FRC*/count=175; tryItOut("\"use strict\"; m1.has(o0);");
/*FRC*/Random.twister.import_mti(447); void (makeScript(14));
/*FRC*/count=176; tryItOut("\"use strict\"; /*vLoop*/for (cjecnn = 0; cjecnn < 0; ++cjecnn) { let c = cjecnn; for (var p in t1) { this.i1 = new Iterator(g2, true); } } ");
/*FRC*/Random.twister.import_mti(488); void (makeScript(14));
/*FRC*/count=177; tryItOut("mathy1 = (function(x, y) { return ((Math.atan((Math.fround(x) == Math.atan2(((( + (0x100000000 >>> 0)) | 0) >>> 0), Math.fround(y)))) >> (( ~ Math.log1p(( + x))) ? ((Math.min(( + Math.cosh(( + (x + ( + x))))), x) >>> 0) >>> 0) : (Math.hypot(( + ((( + mathy0(0x07fffffff, (y >>> 0))) >>> 0) == ( + x))), y) >>> 0))) ? ( + (Math.imul((Math.pow((Math.fround(Math.sign(Math.fround(( + ( + ( + Math.exp(x))))))) >>> 0), x) >>> 0), ((( - Math.asinh(y)) | 0) === Math.PI)) >>> 0)) : ( + Math.min(Math.min((mathy0(x, 42) ** ((((Math.cos((( ~ x) >>> 0)) | 0) | 0) >= ( + y)) | 0)), (mathy0((Math.fround(Math.atanh(Math.fround(-0x080000000))) >>> 0), y) >>> 0)), mathy0(Math.fround(-0), ( ~ x))))); }); testMathyFunction(mathy1, /*MARR*/[new Boolean(false), new Boolean(false), (void 0), new Boolean(false), (void 0), (void 0), new Boolean(false), (void 0), new Boolean(false), new Boolean(false), (void 0), new Boolean(false), (void 0), new Boolean(false), new Boolean(false), (void 0), new Boolean(false), (void 0), (void 0), new Boolean(false), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), new Boolean(false), new Boolean(false), (void 0), (void 0), (void 0), new Boolean(false), new Boolean(false), (void 0), (void 0), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), new Boolean(false), new Boolean(false), new Boolean(false), (void 0), (void 0), (void 0), (void 0), (void 0), new Boolean(false), (void 0), (void 0), (void 0), (void 0), (void 0), new Boolean(false), new Boolean(false), (void 0), new Boolean(false), new Boolean(false), (void 0), (void 0), new Boolean(false), (void 0), (void 0), new Boolean(false), new Boolean(false), new Boolean(false)]); ");
/*FRC*/Random.twister.import_mta(-1780114545,-1267977722,302714451,178559683,421834149,1497865381,117525031,1040501649,1751662171,2012207019,-573066814,1707665240,-734041811,-1621707692,1412123163,1499816102,1302767969,1564056044,855685847,-1554072738,1094043234,478954676,-1657752266,1777192034,1786933444,-1963058795,-1181002445,774792144,-1172882197,-572368220,1693584453,1011717252,2052545430,-1356534256,-1561240045,-1691239769,542862856,-1127052805,515142396,610503379,892336230,-1096835068,-1960815671,2100852117,-201643152,-341530979,-570649359,1544123793,-2046105639,-346594491,440786578,1919880284,-369171417,-284768370,-1578238644,-634798331,-659820933,-1377378993,-383533212,55490083,704650725,-658459209,-1167164102,-866472436,1580820808,-741328228,1735422151,-2141855738,547686149,36397467,-1054035237,-1053817341,-536292086,-342364529,120126931,771665100,1531551103,1449408481,1090169506,1737350811,35953356,1038296156,-447091796,-111025571,185459423,-553340422,3797880,2029324883,497777087,-1893743970,-1435498131,-476483070,1812854474,-1837141795,1298894026,-1260602485,943122118,-1480749952,-752117052,-1044808948,416124770,-348877282,-509491538,-312720901,-1994024256,1318172492,-615758789,-293633001,1467946629,-2091196046,-1740311538,-1352828735,-848166650,760205737,-803919680,531322767,-1842019869,-45150573,-147216308,1892895657,1844768165,-2013470532,797862462,494817439,1855888552,-1734867002,-337486212,-998474516,1379420890,927942520,1133139311,-1387290513,1310170058,-883288529,1094688417,435259381,303824602,66528280,1713708148,860866684,1468747081,1228947303,2106044,1352953177,967682999,-996282606,-1235203542,-54359493,415811910,2147148029,-1433095704,-1054919359,848141323,-121068864,389655092,-1418910937,-335049356,-1621421732,-782515003,1785695352,-1734423348,-2091033929,93348750,1611748323,-1603780416,1114073777,-176472672,-276300263,1536310997,717958962,1223940369,419439105,1696031330,935267944,-573512842,-1110850992,59725259,-1492595449,1066431000,237476563,1944101547,-27881268,-1474245322,1592756002,2032958558,1404449289,937853904,1179776980,-275020551,-1191279069,-615787298,-1256536737,25954456,-1600240403,846619243,-29589568,-305229378,1791708344,-420107675,1098795476,1212596509,-245510127,-96776098,-1331557185,-158522840,877538906,1197751736,-300440211,748654952,-1521357409,1728623488,-515927496,-704535332,750558665,-877701769,-55166637,660817646,-1836564557,1251815644,866557357,-638639604,-515573678,1715172424,2057226905,-58633241,-1190395491,-1590659815,-475431503,-2021511018,-2032007235,1333857947,1095811426,605777888,-1535459413,-352297408,-1698522904,-1907473460,-888048704,96036650,-1397117464,-2060893205,-249147171,1977944140,1125405652,1711868152,1167225172,253470286,1461182629,1226707962,385859516,-1563515709,-1139874191,-450984909,-1708336585,1424717286,715444517,1253856844,48597159,118151015,142933059,-1954341952,2041714298,-492922697,-1896633006,13827919,1564557068,946933045,-788174126,-1453285085,1994986183,-1041432420,-2004141004,-1610313148,-370675797,-890791873,80597434,708082434,-1584968614,-1896739148,-607523399,-556383659,-1420557785,-227211141,-1711728252,-368156579,1123100292,-1117603221,-121666150,1177838307,180979308,812758029,-2128347852,160359616,-1768073816,-1242281496,-399274919,-780318380,1655498333,-251299008,-377825432,-97822009,-1054742423,-901596613,322433281,-49779346,-761676410,950388073,2122980332,835208117,-194974952,-1327140148,-2550689,-1027841198,341691703,-1080482378,1708624062,1812425216,1341910340,-944539378,143692204,-547517936,289051652,1540842846,-826820562,1190982500,2025722605,387163144,-1185474179,-1632696072,-23794093,-1998477805,-359979838,-322096414,-1646873809,1350246088,-2007490269,-1962033672,-210144231,241535453,643423637,-1593528606,988304589,1909238085,-314284803,1460705546,1537434150,-237747906,-44792130,-1088870097,-667546191,1675286988,1157926580,-1332884086,1034315797,-1067160339,1109662891,310706753,960784710,127789404,1496609370,1161620630,2056098930,1873593107,-1023182194,-1658573123,1254756555,-866011774,-354870542,841868537,-443619216,-1663484071,-781117773,-1693099777,439125468,1277637297,1587168594,-1460653228,-1788985878,-1642564893,1153788465,833809479,693957309,-1688907179,117874741,1667653155,-163890442,-1830180334,637091380,1406379806,-1729981221,-873262880,-464696896,-459784117,-1094861396,-1500667747,-1246073646,958846354,-2059002371,-284835442,-1231150691,99114824,698099160,491770186,-675234739,144305354,1535337703,-686983739,-674126186,1535073141,819287733,-870251629,2023188061,251251118,-236072148,1187262724,-255739790,1739006808,-1480694172,-882641053,1112798386,464489284,-1499724006,1000400705,-1307649115,-1359709563,-581521447,99951255,1158898488,612701022,-1415822161,-1592509223,-186989244,1418993770,1315554411,-14071236,180934520,-201187036,1156506589,1291979989,-1614298310,-1843822517,-203504378,1263014650,-1880561486,-1600078428,113721367,-725330035,947071696,1161225003,474460676,-823923658,331584904,1016500978,437348261,1255575087,290186104,-1702394604,-57815831,1657220434,-696294701,-1922963494,510946114,-847948012,-1659016034,-19905836,169624723,1609487963,1005326118,288999474,322716773,450482128,388177385,1182411317,-1019338387,382904181,-1730657659,-242083998,-1359645855,-2023755473,1556018101,-838858742,876237568,920285920,1231195846,444196042,403914677,49435796,1814123818,1226984623,941563951,-920072323,2104928795,316999109,805449433,-1665180738,1237312521,-703299897,-980082960,801174298,197743119,-315722916,-283933352,1606265046,1720735073,-32442691,1276332947,2142319235,-1779772928,-1695101326,1040725899,-887949601,204313900,2042934460,341866575,-1729286692,2108989404,1642888387,-1113536758,937815986,-1401473335,-386225681,-1995386889,-1389724065,-2146406278,2081755723,621714751,310821920,651413357,849827458,-1578327687,1752975631,2104421819,-1836104020,-910805836,-546677710,1453374060,515523162,1193446199,-867674269,869981751,-1016920213,1306539401,269093822,1835481346,-937436917,842567873,-831430466,742728942,591759837,-1383215747,1271013406,-1340538014,331568823,2026250952,614443322,-277109158,1310807570,588221410,-1362841610,-919799347,1145504937,1754248090,-236809678,-1929061453,-1052029444,146547850,-736733439,298133343,660232572,-1200846149,261676611,328644856,-1814182402,-245572888,1289892981,2024881064,2026017280,-952806073,-59078672,858611775,-1247073092,-91207449,-514343800,2108384475,-1892165219,-1612655627,262162780,28191197,-856820646,1146111466,-915722997,1543600215,-299124227,-381152920,242521169,23064153,-2064125017,749327447,1417664534,-18872533,-1079966019,394974378,1692476374,-11711652,1087425479,-810877749,1517093782,1033055954,-651957394,855244371,616651936,364746555,1956694766,-1388764261,598877246,-977210218,2034566959,-1434333932,-1172665131,-1563764180,-347418826,53983205,2081271073,-354637686);
/*FRC*/Random.twister.import_mti(527); void (makeScript(14));
/*FRC*/count=178; tryItOut("\"use strict\"; let lntqwn, x = ({ get anchor(window, x, ...x)\"use asm\";   var NaN = stdlib.NaN;\n  var Int8ArrayView = new stdlib.Int8Array(heap);\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    var i2 = 0;\n    var d3 = 17179869185.0;\n    var i4 = 0;\n    var i5 = 0;\n    i5 = (((((((i5)+((0x0) <= (0xffffffff)))>>>(((0x6951beb5) <= (0x65a9f590))*0x5632d)))) ^ (-0x6571c*(i5))) > (((i4)+(0x2cfe10eb)+(((NaN)))) << (((((0xffffffff))>>>((0xffffffff))) > (timeout(1800)))+(i1)+((~~((0xfcd68839) ? (-32769.0) : (-274877906944.0))) == (((0xde8e173c)) << ((0xf9c6f58e)))))));\n    {\n      (Int8ArrayView[2]) = ((0xf8a23311));\n    }\n    return ((((((+((-0xfffff*((void version(170)))) >> (((((0xfbf33c5a))>>>((-0x8000000))))+(0xcbd28a91)+(-0x6b96677)))))))-(i1)))|0;\n  }\n  return f; }), x = this.__defineSetter__(\"a\", a => \u3056 instanceof y), x, d =  /x/g , w, get, wbpwvf;for (var v of h2) { try { Array.prototype.push.call(a1, (4277), f1); } catch(e0) { } s2 += s0; }");
/*FRC*/Random.twister.import_mta(-546306818,1057551992,717544483,-1871529659,-1674093739,-2016951162,1372219738,-1515896008,-109297683,-102322908,-1523198662,-395813060,2138967199,1060902465,1411765774,-1323160127,-546234406,-968041296,-512825891,121487465,-1443347394,-973361672,916787843,787395366,988527375,-26870521,-451286451,720852015,-1280867701,-293301142,1530243450,430882453,-1139919961,1768170255,541763784,79271790,-922210231,-1334611134,-2114870578,-292168425,1537291231,-1852140050,2018724143,-1411115533,520365719,-1128339363,2028266149,984448663,-362528406,-1712932668,21277950,-389996057,1808060867,-1642786160,-404751659,-909388528,-706037283,1044861341,-907802442,378485561,1239754477,1072698319,-1336789547,-495103106,933000716,667279272,-1657299811,931819913,-1845410687,-428851223,-1032012552,1631429303,-64515,-1069219354,31214479,-220834731,1896122946,917500452,840310039,-260023804,-1341857457,-1242364679,-1190743484,311314874,465046525,1992723292,-334447824,-1918572342,530374394,-826089219,502131755,1059370954,-1473763170,-1348663016,-32487679,1325299366,601680025,-181758244,694376847,-1703757450,-267429377,1594888269,-462437843,-1447248324,-2007277826,-351061484,-2002311243,212323616,1304312618,865290372,1531764415,-61878543,-240685184,-484941121,-621769164,-371817326,-204517415,-479069702,-1663726889,-836846898,-1101088940,1612896941,1002483289,-541726789,-2057516012,-656715423,-500281844,352925478,1051278979,-1437901240,-1451448443,1437375335,491330225,-1846856064,-392257890,-1685931583,-934435144,-327626232,1325882962,-1401465823,-91610021,-866630083,-2105518012,1186816623,1873723904,1262104235,-1978741568,-2072265304,-1798483872,-616875958,-708702575,-485755129,-1846961123,6223108,1017586222,1707118605,929802854,-717554809,-1706270618,1114517620,-72771994,-334717391,1613553891,1416832201,-1867205091,-882963230,1674548320,898294345,500806419,1768360790,-2075294080,366078029,-1548546673,561033208,1299339728,1259528132,2077232308,321523065,-425048546,-667257974,-132244191,-1469390485,1549444014,-1992486253,1245962556,-89850528,1585684273,569551678,1519853627,1644536627,-1037304915,-1943277546,-854075581,156806369,1662994359,-1731399390,-1674725580,-1543048772,1642121907,970728438,-1928360832,694317113,1069134251,-991455319,1303233415,1196637450,1364076853,379519859,1141553883,703158870,218949582,-1306314496,-38862744,-1742846268,-219268275,655452569,1031113885,1190968400,1159400095,1437767209,-635195075,-922274063,109907903,1275254298,-960952332,-1247991950,33597069,-1666114379,-445561479,-737350735,-1327834636,-1908740955,217197452,608847482,-389804212,-1101324789,-1670507324,-404134225,-30111288,-1528685131,-559444240,785863208,-1868037077,-327836762,-460987366,-421316870,-1245806364,-1921561149,-830180826,-1093996483,-371101503,-781432375,712712387,-1888726850,-1498575774,-1762022995,1996415206,-1044876778,-2065403797,-1177567673,364718130,-2012392372,1136673223,275382065,-1630278460,79795339,-971544450,-1776692335,1944497234,1487260001,-274625559,1325821877,1363521367,-2069914011,2026608202,-8487701,-1994055959,1178446756,472737764,-1649983434,1387766620,133025335,-2059970094,971323692,1598014175,1314776412,1792080372,-1275615421,982831353,828530444,-487805468,1935344748,747337084,-942819223,-627374214,-88088533,237960216,-84016808,360761603,467803713,970802445,-34232755,574954506,1333837045,1608723687,-145993860,-809150478,837316682,-1883016843,-512488670,-194350262,2061908564,-1511989992,-203675157,-11588459,698313722,-381741473,1043615916,2070740764,-2021200490,-419413222,-738462290,1772464817,1084395819,1350381429,585796491,533824791,-1084695165,-1185753157,957850107,-587649955,-29505649,1022415708,-526735151,-1853657746,137946582,-752401833,-2055820658,1986760932,-517654287,660928518,2065590857,1182533171,-1740176548,-828356375,-1539331512,-1330316911,2027590428,-1791923030,1244512959,-46685983,-1659229487,520148404,1528088741,-317486676,-1360851076,-1226216725,-1431153877,2033623626,1071082746,-1397883719,1178619848,-1174207354,534184249,269839026,1765246099,-652486312,982804216,-23121403,1441036087,-1223861783,-1154687328,103574597,890627399,-1422483711,-2135602742,-1852561729,63342399,409072320,272128737,-1913111419,-1476052005,-1085574968,-1613744728,-299407620,-751258257,278048622,-767539735,2037736579,97872019,643137577,2079336167,-1811819980,-1451100943,1868026912,1095424474,-221465225,-204511673,-678016932,-515431893,901692692,1138078069,-101043907,1067252433,-1478291499,1411664931,-1278041919,212402244,688454382,-482176328,1820201314,1295975915,-1034808074,1038190515,429029127,692367767,1910149121,1049800899,-318633393,-1061154079,437694316,-1480096568,415444015,1381972649,1403328143,-1173165273,458592874,-1622342353,-1515920719,-163897576,-1098189557,669504434,-110137376,1859816491,1408985295,2114693705,-761881753,-1299885701,-1111435107,766210194,-504290233,-1756745168,551886272,1831195215,-1667781500,-160329338,160105281,1638953079,-953880589,570227108,98770142,-655208819,563946623,-1100787387,-1810567927,-399341581,860011802,-1044820131,1007545619,1245894753,1802531803,-830561082,-254433212,-486132306,1005581369,1221284410,-1189864922,-700749079,-1102987067,-1648041021,2129438093,1588609503,1584699027,1742693249,403954782,-1236436585,1891170642,860240009,641433804,226174150,-713983682,-1111444206,-1303843122,2076316291,1421434131,-2053285343,-1881205550,-1473986886,218788996,-27486554,-136701213,246013689,-2050477256,-934754911,1808699722,-1042013202,980370969,-1203637660,-739608979,1741854457,-216638263,387269153,1430185604,791008616,-1187201358,-1157804422,-1756223178,533513317,-1042193107,968266338,2146694074,1675466881,-580556380,1722183450,-852629331,-1821745593,800210057,-1189193155,-60280873,-1040281260,441282381,352749706,-1162356714,-382941726,1903296280,482585363,-1853666008,546238028,1946895918,-814512046,-398492937,1453625265,-1818798810,-1603241493,1522019708,-2137108392,1542323814,1262938148,-1174149744,492433010,203719664,-146134710,523040635,1412975109,-31414253,1549029187,-777748511,1873426219,1547019215,205830846,1487802522,-2137770767,512334575,228479370,-1998254418,-566068046,680551434,-879002714,61017014,-941891113,-723685092,-1452137353,-676185904,-1283267415,-1054295861,-983036997,818879361,885642424,-31416373,-1732716083,-1853071584,-951145962,-594426052,1338856308,1149374152,-1454365270,-255862589,-2096438503,1568942609,97862634,-1084990455,-1648863256,1228803534,679098106,2085259790,1055295204,-1509373749,-1965357420,610823485,129901276,-388035123,-1106770285,496208935,120136623,-1556930293,1709996809,-1699205693,-1657621022,492072426,-1057726524,2127597330,-1723461910,-1089213340,1760883587,-1122285179,1968665355,250727816,-1586902734,1752265773,-1389633896,201740010,-730397813,1554814077,1095482737,-257933406,-1663084597,278236697,-498043236,714427377,-509299281,1897045980,-933645713,1948552607,-1653295352);
/*FRC*/Random.twister.import_mti(487); void (makeScript(14));
/*FRC*/count=179; tryItOut("testMathyFunction(mathy3, /*MARR*/[[1], [1], function(){}, new Number(1.5), new Number(1.5), false, new Number(1.5), function(){}, false, function(){}, new Number(1.5), function(){}, new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), false, false, new Number(1.5), [1], false, false, new Number(1.5), [1], new Number(1.5), [1], new Number(1.5), false, new Number(1.5), new Number(1.5), false, new Number(1.5), new Number(1.5), new Number(1.5), [1], function(){}, new Number(1.5), function(){}, function(){}, false, function(){}, function(){}, [1], [1], new Number(1.5), function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, [1], [1], new Number(1.5), new Number(1.5), new Number(1.5), [1], [1], [1], false, [1], false, function(){}, new Number(1.5), function(){}, [1], false, [1], false, new Number(1.5), [1], new Number(1.5), false, [1], function(){}, false, function(){}, function(){}, [1], new Number(1.5), function(){}, false, false, function(){}, false, false, new Number(1.5), false, new Number(1.5), new Number(1.5), new Number(1.5), [1], new Number(1.5), function(){}, function(){}, function(){}, [1], [1], function(){}, false, new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), function(){}, [1], false, false, false, false, false, false, false, [1], new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), function(){}, [1], new Number(1.5), new Number(1.5), [1], false, function(){}, [1], false, new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), new Number(1.5), [1], function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, function(){}, false, function(){}, new Number(1.5), [1], new Number(1.5), function(){}, [1], function(){}, false, new Number(1.5), [1], function(){}, new Number(1.5), function(){}, new Number(1.5), function(){}, new Number(1.5), function(){}, [1], new Number(1.5), [1], false, new Number(1.5), false, function(){}, new Number(1.5)]); ");
/*FRC*/Random.twister.import_mta(-1404363397,1543280274,1886834262,-491937695,3560246,-1860237936,760109901,1112908028,685185713,-515356068,2023567322,-809546626,1708403015,1181547109,-861494316,-1377133797,1590159851,-265439946,-204283524,1697034782,1550804543,794309585,-675853454,-1637105100,33409684,-213423658,-1641275295,-746690795,-850353902,1993295575,177400506,581651389,461487680,-1364221585,633018373,1155778331,920860042,319011240,-1874201571,642691671,-1169679476,1491193045,-1588475212,930842579,270399169,-979379123,-377758245,-1448768463,-1165832732,1227445566,-858238885,734934989,787902700,-284929685,-1139301371,-765409202,2018003284,-1327044270,981314224,-1900503373,1196029541,-1121171674,998011358,817776861,-576959726,1732695765,567000501,-1410865498,-1560543983,-668318630,1068305261,414642660,-35232976,-1492504427,-19670230,653710258,2089327251,-1743756790,-1911729003,-1313720022,-256439766,2058934766,1144782875,1101384735,-2036076356,-2076134570,1024485094,460796526,1005886080,1478578712,-1212750497,421421259,-1450044886,299534780,1775691178,221181867,-220361009,-1502114478,-857899179,-614442439,1321290397,2027235236,856476135,-1220807754,1654447915,-2006596223,1769354232,-1612471513,-1556813256,603780790,-1193045054,-1187851539,-785247262,311145632,389470920,1032486551,387879911,441425177,-194706656,1889363747,1342670772,2021705764,1999426134,1491274055,-530345755,-878641392,-1549246863,-147992442,166069303,1547021877,-749726944,-475563095,-947514606,-1670367816,-2106760306,-139360646,-699658001,1027310165,263015063,-1080009580,-1268614171,-79443534,-418386022,1005839088,1272942272,439062811,369464529,-1270480861,835310438,575522934,-2027455369,-1916150498,1282129980,1191018893,729599016,87838684,-1106535274,-977060195,-1082825592,356822841,613778529,-356660456,1961542508,1167039181,-857890298,-1504316704,810493266,1456263581,-237269488,854186177,-416706495,1995549139,-939487695,-1221233720,-490224140,-512114330,-548346601,2010590663,-984802193,364406412,1312236403,866745286,-1740408196,-629822313,-1595266728,-1082690935,948134757,-938890548,-1762859102,504726978,-858849633,-605342141,-635779981,1079516873,-1301381630,1401247677,1428839281,1254880397,2030201586,-1673532541,1351302433,-1686108704,2072978639,-2129732082,-1158705041,247220257,-88882459,102147127,1638129184,142065263,-1200073294,380040217,-517669382,-327556205,519505816,-618732820,1647698777,1260718642,789490688,-1534269864,534469947,-254051087,-945430878,1380850726,-1835589162,-1406374394,170166669,1207635736,-1460513899,672899756,1018717932,1179600624,-2093341011,422337771,-2072994010,1725960403,196364756,126315326,80147067,176680511,285692785,1576669470,-607103288,746920934,-2091110837,-1458724594,-1164598240,992829228,-382338288,978273229,1876252175,-842470870,-185515639,-847583664,17433372,-1238380191,1444118492,-773299632,-414964671,1365191257,-1431762103,-581728199,-706770852,965395432,-932461774,-1287503838,-196416704,-1011135067,-306472774,260685727,-907018026,-1581805131,1591255968,-1793190146,252838555,1729688143,708280556,-1026628695,622696406,1202561346,1979319983,-1098118932,-1903012648,-824239900,-1748493316,253089354,239861197,-2096419130,-1516410720,168437548,1226033899,-874909268,-576144834,1283866120,1336977004,-437484771,-447396618,-328868045,-1940959717,2013294953,16274284,-1343138513,-1740751593,-898515905,-1548335692,-370147476,-381288177,1851654735,167959679,1040791998,1020711221,-1806459344,1688606588,-608223117,1337493395,-1771855504,121338446,-1979671855,450696704,-636341337,2015851371,-2079555539,-1267265567,1139517866,772438088,1513950465,1573159975,-1956605537,-1118419066,-2072449258,1361944750,1021621893,555753782,565675343,-603991604,330300364,1632084977,-1009362000,279510602,-2105511967,-1240714917,-1392482034,833224505,-381286580,1213220925,892849975,217067181,1520382433,-2069980764,-792743175,-1889096464,-1344013761,2132945821,-1792959833,-1604561096,-879099491,-1872480385,-1345633787,-62075436,1222139281,-11529636,-1620254259,559068729,-565795402,-1867976509,589342267,-487952408,304435768,146359030,1703015345,1717931424,-1849620419,-1716923545,-1701418098,-199449402,-536121114,-89769162,-1961392873,484262065,-744526175,-1946702657,1960408140,1255429384,-921161752,894948597,-147049665,-1519633134,-1054374145,1902104462,-20401241,-511755935,-958575844,1805498439,1206177602,1986641264,1370842228,-771302595,-1931299729,-1621456871,-1830825797,265755565,1194487221,666832081,1437192738,-2066892023,1168964816,1408034478,1521704452,34091674,-293834035,1709350589,-2117917917,2022637967,-1388124103,1168327384,923344765,-1739297412,1665616743,579047404,-1760455739,1404820653,1728534730,-475891146,-437231383,-825609791,883467207,177330635,-1689125722,-526546324,-1111298411,-755157033,-2041043041,-522600725,1246152285,-1608793652,-773840052,-935483891,2140178723,1081298000,1221910278,-1478690165,1317374328,1954855700,1820210459,807256817,-222061185,224161468,-1522427363,-1608187869,-984330035,-415265857,1532035894,706049659,-651800618,-1427440578,-246215400,-1848658467,-71950150,-93939169,797618079,1041436296,-65385724,392366596,-817167593,602063395,407699304,-124589164,-684784692,-1978609632,1034859729,-1697281066,896456157,65708049,-1231271409,-1190964424,-1855354951,-1159401642,2093520489,-881493943,-565576426,-1818575655,1479439483,1388734719,-448306806,1244561311,-1599361496,88962308,-332648181,-495074454,926561778,-405365685,-896542034,1315869229,-2119326747,-481731502,696552297,329860781,957188927,1263954454,-27575013,1201407793,630026713,1888098555,917102517,-1615838060,1857323853,-1857850449,-872282906,-497597987,-1318343419,1715037307,-1183142098,2085020103,-1311393468,1404481850,1800193595,-1886536979,-1372623393,-1423525626,159825223,1174764109,1391151719,-1854217748,-1645364358,2064431717,-2071009137,675743311,989720699,-2008510202,1965633715,942361400,-1434587353,551514950,-2078664783,1846618723,1744053068,464145836,567747581,-620795639,1655985796,-535145258,-1725543183,628569261,-1591501160,2099383727,-1425565393,886020333,-818605485,-2110857870,-1742731348,-626457843,-129628704,1559373252,1505100656,-465457210,-383879805,-1581952315,284960117,-2046691663,1263442360,-335140949,-1339634268,-748275385,-1730457781,946532018,-775437483,-1729854019,269799009,2018817335,2037371049,-1964944825,639151011,1389454989,783362505,1312236340,1707722010,137524138,2024540455,-1391895606,-109005498,-604130989,-993832481,-542696736,-1371442568,-1330118281,1983912302,230022875,879531037,-1665929053,-1942650880,407508512,1198097935,-1178826957,1786466226,-103030941,-1662131000,723036480,684702549,-1313134625,-423521042,-1774883589,-1416277260,226081272,2099457835,1756662861,463840885,-1020556744,1724360310,1649187584,215446141,2049646322,-1039585772,1318149464,-1657003325,373333445,-1608664995,-807368471,758983750,1862770964,320141225,-88037718,-1787606176,1594834928,489416031);
/*FRC*/Random.twister.import_mti(193); void (makeScript(14));
/*FRC*/count=180; tryItOut("var xrleeg = new ArrayBuffer(6); var xrleeg_0 = new Int16Array(xrleeg); xrleeg_0[0] = 12; var xrleeg_1 = new Float64Array(xrleeg); var xrleeg_2 = new Uint8ClampedArray(xrleeg); xrleeg_2[0] = -22; var xrleeg_3 = new Int32Array(xrleeg); print(xrleeg_3[0]); /*hhh*/function qktuch(){v2 = evalcx(\"/* no regression tests found */\", g0);}/*iii*//*MXX3*/g2.Math.sin = g2.Math.sin;o0.b1.valueOf = (function() { for (var j=0;j<8;++j) { f1(j%3==1); } });print(xrleeg_2);;yield;");
/*FRC*/Random.twister.import_mti(336); void (makeScript(14));
/*FRC*/count=181; tryItOut("\"use strict\"; /* no regression tests found */");
/*FRC*/Random.twister.import_mti(345); void (makeScript(14));
/*FRC*/count=182; tryItOut("v1 = t0.length;");
/*FRC*/Random.twister.import_mti(358); void (makeScript(14));
/*FRC*/count=183; tryItOut("{ void 0; void gc(this); } function f0(e2) \"use asm\";   function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    var i2 = 0;\n    var d3 = 18014398509481984.0;\n    var d4 = -0.5;\n    var i5 = 0;\n    return +((-70368744177665.0));\n  }\n  return f;");
/*FRC*/Random.twister.import_mti(426); void (makeScript(14));
/*FRC*/count=184; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return (mathy0(Math.min((Math.max(( + Math.fround(Math.sqrt(Math.fround((( + x) ? ( + (Math.asinh((y | 0)) | 0)) : ( + x)))))), ( + Math.tan(x))) | 0), (Math.log1p((Math.pow(y, x) >>> 0)) | 0)), mathy0((((( + ( ~ ( + ((Math.imul(-0x07fffffff, ( ~ x)) << Math.atan2(Number.MAX_VALUE, 0x100000000)) | 0)))) | 0) >= (0x100000001 | 0)) | 0), Math.fround(Math.tanh(Math.tanh((y | 0)))))) >>> 0); }); testMathyFunction(mathy1, [Number.MAX_VALUE, 1/0, 0x080000000, 42, 0x080000001, -0x0ffffffff, 0x100000000, Number.MIN_VALUE, -0x100000000, -0x07fffffff, -0, 0x100000001, -1/0, 0, 0/0, -Number.MIN_VALUE, -Number.MAX_VALUE, 1, Math.PI, 0x0ffffffff, -0x080000001, 0x07fffffff, 0x100000001, -0x080000000]); ");
/*FRC*/Random.twister.import_mta(-518193370,-1486753998,981577812,1338782262,1337847677,-401567320,1954742876,162432654,1963514366,799174979,2104293435,-370501914,1413660448,1135726423,1312743025,-1897642587,-1789644126,1011495526,1167738482,795569852,-303832496,156772949,-668699937,323303911,1587866657,901569241,357032892,-1469947576,-691556237,265858198,319613351,-312650420,865963773,422054666,1025602765,-72866770,1137121929,825723677,466602680,-719737909,-1964449898,1356572938,-1973310416,920301876,-180168831,-1724783322,-1583070244,1834787843,-1772668960,-1304889778,1773023524,-1218561963,1809762471,540862818,845244177,1446073041,-1051378817,-137090714,1862791838,1801715248,-450886871,-1478974736,-1361233106,282929921,380735665,-1634835455,-625414076,-342389644,1952046405,1045225213,-613123266,-1260133960,-148693948,-440637885,1712700420,-1532600953,-1164674294,1728924077,-911172820,-1027642813,26540702,1885587611,1737731014,-1865726841,437136848,206461836,-386074435,1473524447,-1933899996,-2019641484,967553457,-155923841,2144825644,-750915938,1427116452,-301406827,-761895604,472863527,-583264598,-306097348,90642669,-874987974,-439958336,-1344612229,-1195957306,70320391,-1605320967,-836095608,1061877782,-1926055346,160685391,-1966192596,-131172523,1839335711,1052188858,-289335061,637191959,1770270890,-1979005579,-1483835081,-1838216755,-1867460563,-1124103877,-281279776,926627311,1504083467,-428125383,-1493759839,865898314,32444383,-769196688,-343172977,990980719,2032007935,-777704422,-755905554,1133471300,-254853129,2015628550,-661405567,1551288100,-1451712828,1062053884,-973761610,221983907,-1216524774,570961494,633791516,-1172210412,-1370188279,-1982726948,-467976852,576092085,-820550375,-86498802,1140321167,-1570820895,-1141170814,984912576,720838698,631423225,-59468025,-259922943,-899090776,-485739308,-1958630418,716543834,8858042,297508842,846789954,-228283817,-983809296,586508621,-75321155,1453607696,-1536056103,-867037195,-174514724,789968476,-1239330100,1635300548,-1591154956,229823442,-1953978881,40917060,451812237,-1975146722,-70356314,961207183,-1294331573,-1064189981,1756766789,1964064699,24979745,-1214014194,169941588,-703199957,-983897574,200974806,-631929073,621787557,1433666919,-431555607,1380586515,1975764539,-1456936875,-1491022353,1483039581,-2036938339,-552099615,-1264816987,1390339581,-471649429,894475582,-276406430,-1501357013,-1196513318,29871045,-1302606991,419796651,-1940380959,215305797,2050226618,-208980415,-1016759197,-2095723543,1054237395,1819108915,-211009948,618496802,1827377486,-685224716,1032720130,1991986639,-472498632,1892875540,744604892,-435736103,1973539110,-976640441,1833748440,1675031829,-660158378,234001752,1758257889,416322658,1929232682,-646373416,-847824020,1992714503,899763442,-1110115270,1392617969,1438835250,712849703,-1110569059,657235390,-106542248,486174911,-1077822586,-292978743,1473163491,-1486010918,1743977232,1754704652,1642774296,768392646,-63630389,-1911044582,-1365660581,-16135887,-1708226991,-1816203687,2133193294,-942117381,-2092107882,173487941,992017103,-1802966796,-936674513,1065020692,1965575549,828300963,-1968097663,-1335967165,-248857433,1793485139,-1209092231,-488787610,324824708,892457943,2019937710,-120751355,-43998350,1080655141,116621118,-780762693,73100524,1374382547,-144755214,1800174603,-1291709872,1486238535,-347121200,335197723,605760372,748215227,-1650645890,1869042756,-521112701,-1696429153,1750935150,-1197913238,371723179,1558569575,-819545597,462834371,1959082673,1119183731,-1697875898,1211309655,-1776081269,-1879232192,-980199064,-1472633480,1792468070,1903799084,1540111150,-1981494863,-1924131689,681587686,-1473825955,-1914539137,-1917888993,-2013410194,-1763600079,-1395026026,1103602282,310824707,975232807,992099736,-9736199,-631104691,-656780330,-367564818,360342268,331960600,-1876933345,1642576270,-78848189,566578976,-777875202,-901905529,-1235912539,1513273520,-492428246,-821944830,-1409246310,384763544,79242049,-1348257082,402966489,-36529867,-1831620870,945282101,1230060274,-1853789795,1479173727,45144003,209674540,1411229559,-655921713,-97092643,1476820021,1438866543,-948805489,1926751325,1589111899,1423719139,-22736587,-1250173121,-541980534,1736178811,1643935300,426620098,1744997449,-747875446,1561143102,1511554571,423020654,-1459203290,264919080,-1464611761,293685730,677223296,-1582284117,-318695510,616652420,356194930,-65645500,1091778232,-596410969,-1901769272,1463575214,-1756404812,115574027,-1686569522,1618783625,253652813,-431281069,308380849,-415274916,-1790451890,-392952206,2034388423,895544625,1517356071,-774866923,-97100936,-2050727630,855541060,-2039308267,-506356993,679193876,101059366,-1749352980,-671254180,1430355091,-1835154702,372297949,-2006010109,-1666733679,1426275236,-1221776119,815100667,2072029764,970413231,-1801074035,1991543422,1762000625,1376934274,-708574488,162838137,967374461,-1582385755,-185205713,-1834095750,1161957935,-143141124,-1868264262,-1641826342,1332180865,-1350112254,1805851852,348446911,579032149,1493603199,-1999606626,434482148,579307590,1219913805,-1469596870,-830485440,-459795182,-366915987,1239983340,-1369561183,675590088,-1542905950,-708047427,-833794199,-265223626,-1701445190,779905206,147156187,-1878700857,-1851092244,-1995227127,-756022607,-2084288702,-1596102448,-1709785721,-1888633000,-617409874,-369910708,1583139389,283055068,-1615356292,206809626,227457824,45422151,-1767288123,-130752971,1550324719,838854304,516674963,722983195,-626852806,1007396867,1769495838,-185861507,1721094489,17868947,93263119,-713946186,86106620,-1372948132,-681968347,-1265292512,-615850943,-1777573610,1467286143,-373268475,54342094,457204923,2081676495,-582784844,1621266260,-1515314222,1120368380,1293792926,1221856723,1208328835,905473110,-1626036108,-1665115605,1932098832,1869100168,1352547030,1149474523,1735990940,1133842360,-1088515981,-1030160811,-1368967720,1655861906,1762874018,781553604,419892524,-2003541759,-1011639028,-1755920146,-541625009,-66061109,-129087751,-2116411430,610156976,153383150,-634182307,2074148889,-1179624552,-968853606,1175315934,1129938127,-1236553424,1077334028,1546041074,-1297581983,-847216767,585748597,-709087027,2001100818,1132760651,-252911409,-265489633,-939770622,-350091064,-1644111908,1523857266,1176109745,316585688,1517773943,-1691728185,886227074,-1564170350,1711177819,1578265359,927064773,-1386034595,1053322225,1295802517,903951808,-1249469162,240561766,-685730003,-1992468182,-2021140080,955413064,1579026393,-1309175259,678419746,-1115607181,1013751083,878982899,375166011,1463583587,-2129654695,-708279225,-1417173064,673480063,231527759,327123091,1626032069,-544927068,-898789442,1967783935,-1916354034,-2074242369,1087439211,1517187842,1090052430,2116360814,-7066121,21278135,-737457201,-1528788320,1336434253,-1635417172,-1622633693,-1781293286,1530457170,1205470328,908919003,-577804231);
/*FRC*/Random.twister.import_mti(91); void (makeScript(14));
/*FRC*/count=185; tryItOut("\"use strict\"; mathy5 = (function(x, y) { \"use strict\"; return mathy3((mathy0((Math.sinh((Math.atan2(Math.fround(Math.abs(Math.fround(x))), ( - x)) >>> 0)) | 0), (( + ( ! ( + (Math.sinh(Math.fround(0x100000000)) | 0)))) | 0)) | 0), ( + Math.acosh(( + mathy0(y, Math.fround(Math.log1p(Math.PI))))))); }); testMathyFunction(mathy5, [0x100000001, 1/0, 0/0, 42, 0, -0x080000000, 0x0ffffffff, 0x100000001, Number.MIN_VALUE, 0x080000001, 0x100000000, 1, 0x07fffffff, -1/0, -Number.MAX_VALUE, -0x080000001, -0, -Number.MIN_VALUE, -0x0ffffffff, -0x100000000, Math.PI, 0x080000000, -0x07fffffff, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(262); void (makeScript(14));
/*FRC*/count=186; tryItOut("\"use strict\"; s2 + '';");
/*FRC*/Random.twister.import_mti(271); void (makeScript(14));
/*FRC*/count=187; tryItOut("h0.get = g2.f0;");
/*FRC*/Random.twister.import_mti(288); void (makeScript(14));
/*FRC*/count=188; tryItOut("mathy3 = (function(x, y) { return Math.atan2(mathy1(( + Math.max((( - (-0x080000000 >>> 0)) >>> 0), (mathy1(-Number.MAX_VALUE, ( - (y > y))) >>> 0))), ( ! (Math.hypot(( + ( - -0x100000000)), ( + y)) | 0))), (mathy1(( + ( ~ (x / x))), ( + ((mathy2(( - (0x07fffffff >>> 0)), Math.pow(( + (x >= ( + ((x * x) >>> 0)))), x)) >>> 0) || ((x ? 1 : ( + ( + ( - (y | 0))))) | 0)))) >>> 0)); }); testMathyFunction(mathy3, [true, 0.1, (new Number(-0)), '\\0', [0], 1, [], 0, -0, (new Number(0)), /0/, '0', null, '', (new String('')), (new Boolean(false)), ({valueOf:function(){return 0;}}), (new Boolean(true)), '/0/', objectEmulatingUndefined(), ({toString:function(){return '0';}}), NaN, (function(){return 0;}), undefined, false, ({valueOf:function(){return '0';}})]); ");
/*FRC*/Random.twister.import_mta(2003937565,1216070232,-605008545,-3837479,-394578573,-186331930,1407918569,-1379201205,-2009461387,1019621644,1418323706,1698640093,1587247911,-1401529514,2034629201,-538065377,-1229906111,1536126718,584407663,1820390671,208985568,1328337608,1433292062,-2069609589,94666150,-344823007,1011522992,-194157632,-799626329,1198767440,1676662325,1381741907,447010136,267828666,-1586250874,-1377302977,918444120,1030920103,-939208834,2091072356,-53993976,1938054246,845719147,-239369571,-1721962373,1499895703,-703720285,-1434112427,-1377204472,-428149784,-941244710,462422640,-2135230453,505132173,-42504650,371507554,273221759,1665604080,389196621,-224517580,-616808986,1317746291,-203313895,-622456630,1042823653,-1557941150,-1856777432,151326736,-809075891,-2082203074,1916100372,-543649408,1041927747,-1119383189,2070584362,-941867969,-990741313,740106573,1750223161,-782176349,673846427,-516303022,313087454,-304447944,-1674473407,572224473,701610782,-273801250,496210311,-721257509,1038437276,1941443212,605047919,1748835989,950374608,-1853887341,-1955132765,526511605,1747680269,-257104462,-11623641,1323879011,-1482849796,-1464833122,-1115299579,-2010101968,1654263243,-1965590595,62438619,1944790820,-767633101,1368039509,882075665,-1990725301,-115523883,573944657,939469211,-2024950050,-1227075445,226253965,-1309517923,1658410896,895055756,-1886872394,-49315319,-500122688,-7644967,-958730287,88042779,1513751464,-2086320112,-1809965250,-519709829,1336641681,720235087,-556194991,1677185393,-764071077,-671931891,120074544,975814822,1185013458,-1435588390,472299394,-1930924061,-1900846492,-286486843,-446760845,1341711361,1622589406,2066345560,303083096,-987626934,-992195937,1051931266,-836058255,514126350,-351143856,1431126041,-671127983,362447677,751320414,1205709601,-1539691865,853980645,383665638,-256936942,-118407958,-557825117,1259924796,-55642460,-1834601717,-489428432,2039255888,-783874364,1678504418,1310609004,-179413828,2129537341,783167853,668307903,-340024396,-1576760879,201608375,-1583445799,-1331409255,1941018421,311249461,156819792,2127017662,-710814795,-39966501,675395178,868094885,-124673447,-1905315999,1456030718,1403110608,-484511685,1251958868,1719285291,28076691,-670447703,-1373272435,-1629272986,-1435266579,717165525,1345215407,-2083872944,1317028995,1949978782,-400021503,12991901,2000408319,-1267981148,-1547469286,-659556214,1412308648,1902833962,-796065822,1105695825,-1571721218,891204837,-1551703364,-1621601965,-263290515,1924230143,1321711151,437584841,-310016520,-732866653,-1229180174,1454496478,1644183285,-710774335,-1643450597,-1764943553,777588329,-556575967,675092683,76910851,1427545722,-1726706509,467656430,1474766031,464239354,1077705443,1791967318,-1387833708,1337912167,-1706148458,-181659263,-1047324104,-1334005252,1937954001,-2084510344,2074122492,-1264951627,1304127632,-186066333,-48671468,-1295705749,-569279561,49614302,227002411,-555576931,-609156514,-1144783611,-1111475564,-723193300,631533930,1233860488,653553328,1827312257,-350005858,1909107829,1658994256,-845034848,-426963144,-553152895,-1115217172,2094051768,-1972049155,-781264511,-2099579012,-79089861,1885456727,-1437407915,119865649,1886516269,-422250979,-1689897800,-577509925,1752161637,175943567,2121632591,-1043747768,-1010279646,-466154631,-759955303,-1530488765,-1909901994,-226783017,336041837,1041282295,-417950661,-542212708,1603911353,1212767820,-959405874,-1712001777,-2139277836,-267925805,-1632896270,1362489856,-917502919,1986549340,-2051585286,2128490159,-654216293,-98288369,2136672368,-206159833,-546588641,1779081158,1352116635,-582289371,1655994144,-1857523465,-204630001,631980783,1652320357,1475304672,560262140,1487866874,1439987472,319354385,1114967661,-711819495,688027357,803927656,220496812,1314429626,1123326572,-839874656,-1086785529,-1671115043,-1056863398,-965244690,1706807324,-1487285047,18363157,538097485,-1835924351,-141951548,1656644122,205147749,-925709476,256523841,-153860584,-1700701278,-1928587766,-1750010836,-1496019020,-153244126,1178281500,-231361856,-1569121384,1084124740,426298302,-1453477446,1761338066,2075716769,1560645677,1609529579,-1348753680,-689571540,-934329354,-1270180323,110583050,-1425715494,-737772448,-19597229,303179887,1175981739,2096851420,-1183189554,-1583477529,542333289,1398702770,-471923021,-1078467811,1579082007,-461260334,1898032480,-1472149386,427311742,-164398179,-1397941975,-2108001940,-826434212,-1776967648,261472437,1169817526,792145638,1934776282,-946284682,-1185802554,1100383554,1916599126,1067186329,-348297346,-991015520,-1776811767,-1858761614,-1117203556,-819512725,-1464140279,-1082386366,1899951304,-1450183824,292675577,-632096277,1439319661,1484569126,-1998566251,-1187549502,1865733970,-742608350,1161178359,2038358682,-194848332,686667702,-335734153,1844317837,103384536,-572911334,257955233,1168271270,701436252,1574555531,1774112583,639612411,1366299271,-1218686880,943457431,723863082,2052882223,-368891485,2047831816,1564076451,-2003097774,-2053173493,-505697409,-963728166,-1348535639,-370297929,-1734114735,-1476397359,-337486297,1983112040,-1298294815,-330898030,2060783318,1252875295,1358229550,2082426671,378609362,-1493686149,1731894232,1674010613,447489042,1284869793,-581534639,-70953238,-443408414,-1841300548,1782483985,-1261553120,-1845645744,1686069216,875826045,-296129489,257513178,1119652724,1171579262,-80538275,-1154449383,-1274919685,1178812491,-1867967389,-392882194,702425269,-1018236658,766420755,826500806,-105542607,-492235340,2100762887,-2054610095,-2035758350,1923330312,-368732627,1213938571,-1892599202,-241683562,765706444,-405948548,-2005045433,-1049437578,601679969,791836577,-1160267812,-456569899,223591405,696563051,2143111,-201070604,-98201658,-81969516,-720540845,-1216950767,1686748516,-834406286,346081000,-1650215439,-452977955,-1937144536,895504100,-1043914855,902631601,-1198044143,525491150,-2002917520,784369648,2093020957,-778410196,-1787335783,490714539,-1847719851,-721379707,-1478035336,777996931,-1824012801,-983939817,753995383,-577549332,1312104318,-1685899101,-277975573,-1135901742,151809321,-399268061,-965795651,45031206,-1084544114,1938887904,-630993424,-1442828160,-465963943,1523047413,-530187264,-190138456,-233423039,562761964,-1610384515,1711414579,1115745745,-1222561237,1194836438,-154691448,1500320796,-447637434,-1928946412,720796584,1886784950,-418147935,685769016,-948652494,-1618724904,-2006802847,-313871537,630535465,-1096633044,-1941149751,1284100745,-1431470276,749136017,218066887,-1014555971,555526354,836980840,-989753926,1611876354,284158710,-652289865,-360433342,-56728986,-1511953230,-464111911,-843915077,-158176298,-2141638750,-1278001421,736300246,-1297484006,-575593334,1382383280,-114211359,-559380236,755017048,-522540913,-1521381416,175431926,-202487369,-561002864,1545356132,896794621,-178377584,864196414,-949175314,-213934638,529517749,-70769105);
/*FRC*/Random.twister.import_mti(6); void (makeScript(14));
/*FRC*/count=189; tryItOut("/*RXUB*/var r = /(?:((?!(?!(?:[^\\w])^))|\\t*)+)?/gim; var s = \"\"; print(s.replace(r, Object.defineProperty(d, \"callee\", ({configurable: true})), \"gym\")); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mti(370); void (makeScript(14));
/*FRC*/count=190; tryItOut("o1 = new Object;");
/*FRC*/Random.twister.import_mti(380); void (makeScript(14));
/*FRC*/count=191; tryItOut("\"use strict\"; \"use asm\"; mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var d2 = 137438953472.0;\n    (Float32ArrayView[((((((0x8d3abf7c)) | ((0x92c188e8))) > (((0xfa60441a)) & ((0xffffffff)))) ? (0xfdebd1a9) : (0x7e451207))) >> 2]) = ((d2));\n    return (((0x8a1546f)-(0x48c654a1)))|0;\n  }\n  return f; })(this, {ff: \"\\u2BBD\"}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [-0x07fffffff, 0x100000001, -1/0, 1, 0x080000000, -0x080000001, -0x0ffffffff, -0, 0x080000001, 0x100000001, -0x080000000, 0x0ffffffff, 1/0, -0x100000000, 0x100000000, -Number.MIN_VALUE, Number.MAX_VALUE, -Number.MAX_VALUE, 0/0, Number.MIN_VALUE, 42, Math.PI, 0, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(554); void (makeScript(14));
/*FRC*/count=192; tryItOut("\"use strict\"; /*RXUB*/var r = this.r1; var s = s1; print(r.test(s)); ");
/*FRC*/Random.twister.import_mta(-770794831,408784729,1689287007,596162362,-328743341,-9903970,-900413236,-232613757,758206300,-304339957,314916471,-137132018,1678235389,-634276498,1573074094,113144543,-69224842,425169306,304093636,-920824677,-1892903059,-1781842227,-362519086,-346174045,-1111467338,-2072529101,1878849421,-1453367510,-346451395,298333447,-552485596,-554772338,1120760362,1774665561,1000237684,1941085082,1816977787,1240230194,2021136490,-474079714,1990343570,-979467188,-2011537203,-2004940951,-1677380525,-1810886795,-1657129614,-509045788,1258388835,1222089031,932478487,1935074681,-1408629359,1669488312,-1014413341,347290603,-797431929,1411336611,-1764627533,-2072793788,1726917047,117936258,-2037295550,-1339076795,-1559474736,-1527837690,1045923550,-196685466,285670705,84271269,962418194,1627250565,-527309902,510792160,-1605727534,-1209794527,307256360,1457832617,1412094188,1596080430,1520592824,-40202033,-1492086452,-1284561121,-63897010,-89017952,948853045,-1786907800,-161649588,-1514033005,-2098427553,1057149459,-346718242,-1929651189,2032292216,-177398469,368490283,-2135709238,152376351,521825661,483770458,1861868025,-774826338,1096977071,918262416,37756951,-734515062,1474680044,-932339708,-1649140598,369121161,188509072,1557238284,-967129132,-417325354,941659086,-412118854,-818601097,-164484110,-2116999018,-2056303556,-527879168,-52858673,847387272,-965831695,-2109431337,874921797,-818429766,-1329679323,-455950635,-964261193,-588639354,1058695950,-1179429559,250834278,-140442711,951045634,-600725975,1062530949,-863074433,-1238924048,134799814,-540191852,1249647019,-524334774,-1071530690,2027948313,1001293768,480924056,-536363840,1195198546,-1189987962,336132219,-485352813,-1223574450,-1486758364,-202908523,-251588619,229386361,-1605048927,-871902369,283530703,1865175509,-1698942504,-351609101,-855831135,-1905352396,-672955934,-980480541,1481991777,-1831123829,-968308941,1005684862,-563864598,728296685,-1033978000,-1214139574,-863379479,-30824993,1844570529,490590434,259932677,1083089244,27618002,739255516,-985313684,787259625,-1998579871,1944717782,427107897,-882815965,1491055858,1129358256,-2074293983,-270764281,-1369101243,1237559914,-1201135052,-1135515491,1085379208,1698752496,283983801,709641536,-2101132664,983766015,1275991703,46965755,705053566,1289840004,-408154939,-8791441,542829552,2084429652,926332682,-1321527422,-922324067,1617162146,-883216094,-154551967,-1511573101,609961986,920241725,574875232,298328984,303066555,-2111083,1168330215,1175235466,782192037,-1752145327,2027335235,-2025903300,1465929531,2039300339,607084497,-10521828,603460576,-1532745928,986035380,-12210525,-256181677,-935214552,1263639976,1227134158,344083687,-1422486422,-59050832,-1718666201,1797061537,-415007975,147026364,-586557526,-599134259,-1892340422,-1463865962,-1769349565,-1836209534,-1177810580,2106721632,1010948256,-1448279245,-845256848,851975541,-209209935,-6975197,362846533,660033603,675423960,-1343423142,-624404360,-1397056339,-1887501557,997062378,-1465147459,4551937,2054185547,1845984279,1154677131,-2049076506,-221670169,501876324,1606124098,-452139020,-1860871111,-1330417951,2011807687,139620145,-1133209104,-1506289077,754163091,-41134823,1422725090,1238389355,-1570676282,1383375902,836905749,1692519732,-766614671,-1867550954,737812300,1499892555,1082126950,1693416264,-1806649716,-60344213,1006495266,-1444532563,2122762398,-554516312,1927436052,-212746779,490361336,-1243329319,1343529013,685588907,-1922480286,-1491462674,1686843095,-1970611455,256889222,-212445133,-638467660,63992299,1626601672,837864920,-1095182126,1849710317,-1921431298,-1911053023,436995894,-380367294,491535584,317871593,-126896777,2098196324,1491168211,629549923,-1514022694,-961159135,1260710200,-1060600318,-1072934005,425385720,-1047014550,161607595,554236995,-514724549,-430667701,-1839932402,1987914356,-351882275,1332705416,302322504,1340260775,-1100418633,799744968,-1061430405,405480776,-411029366,1917503199,-13279668,1160451952,-1530182541,1136728339,-1087621849,105789157,-1649276237,-697781294,79463449,-882668727,1040312514,1147899845,2007746039,-836827725,744707248,2010688782,-2078270149,-2079280253,-94791933,25845526,-1995365213,1366519992,2002811596,1239640863,-813909221,286315166,1771262733,86429492,961090710,-942972333,1550807177,487399079,-21114552,-151095420,-1010571815,-1993134884,-96179344,1569028288,-2023358587,1554990800,-1787900934,-173360024,-528334677,-1606802375,-182389756,-572141980,827908802,2113311299,912277422,-968102449,876337517,1315373580,390200887,1719035600,-699105617,-1921964996,-736040478,-1797308414,541118102,1469536776,1441568258,1543355181,1569243052,1711142777,621851809,-523575300,925628705,1285471969,-344024803,385037325,-1192087982,1859504164,-520606861,-315419550,689078674,1644981513,957658826,-576132676,884826974,-874936242,-1696505738,993820064,2025245185,2077083538,239961014,-480568716,29472475,-2007864308,1272869305,-1781030290,361082929,-908633375,372944117,652483466,-1999935999,-1017043807,1120474022,-1306401292,1808184560,746176143,-104121380,1376529688,-2110393225,-1616507600,-1931583697,-1648188420,-200465974,2060345009,-1143173180,-474316147,1148356295,-1413465240,479533725,-2120720443,-347720746,570623615,190090702,312765612,-1778974590,-1367982019,203921499,110832478,-786074322,-1277956296,-1691977261,-654098671,-120510349,1789170065,934770570,-1550571621,-2016592314,846345638,872931778,-393694443,820221371,171871133,-1415785822,1261019377,347284092,2017039251,-772126919,-1404105016,-2024452271,1772085560,1008656448,-754158976,-1053864103,-1059323624,1057156985,770319131,528799542,-1378306801,-1668961550,-671940072,834565018,1060057943,384986729,-2137091334,692293800,-1168222435,1624421905,540048044,381933356,783396416,1167526230,2066207399,1841225176,64400441,-107688587,-1493089329,286498907,-1278339700,1068701082,-24744619,-638712881,-163581122,-1588506105,617011183,-1931614963,1181528900,65526793,-419802059,499258690,1556055994,-1409607373,-1539080457,1750425145,1738503357,927877022,1576382466,-1115849085,-1662931306,1149761619,790092158,-1831543495,-136368303,926802382,-1135340030,-161974765,-426178356,-933409929,123385008,-1193098068,1967366933,751359419,750542439,-211013873,1112584136,-1550339232,574165692,-1390323356,990454664,1737208521,-1272262417,-563114352,953525249,571288296,-927143740,11363172,-818090841,-1605424929,1974131708,821721438,529881152,-412648237,-220819692,-1122958776,1614961008,-35640591,-196800486,1529917735,-1649609734,1984402148,-1782186040,1676635990,1912510648,-1255359878,1827757723,-1354226570,-2005269131,-1252642728,1817166689,-1220967768,-774792368,-1656469490,-1803483834,1756946510,746665612,1042756802,568338528,-528052345,-1647018761,1412080357,-915618039,1784753276,1464284452,1148857714,1723885249,1154241848,-586445633,-1889420947,353153884,769625876,172726007);
/*FRC*/Random.twister.import_mti(21); void (makeScript(14));
/*FRC*/count=193; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return (Math.hypot((( + mathy2((Math.asin((( + y) & (0 >>> 0))) | 0), ( + ( ! x)))) | 0), ( + mathy3(( + (((mathy2(Math.trunc(y), x) | 0) ? (x >>> 0) : ((Math.log(((Math.cos((x | 0)) | 0) | 0)) | 0) | 0)) | 0)), ((mathy1(((x < y) >>> 0), ((Math.tanh((Math.hypot(y, Math.sin(Math.asin(x))) | 0)) | 0) >>> 0)) >>> 0) >>> 0)))) | 0); }); testMathyFunction(mathy5, [undefined, [0], false, 1, 0.1, null, NaN, ({valueOf:function(){return '0';}}), ({valueOf:function(){return 0;}}), [], (function(){return 0;}), '0', objectEmulatingUndefined(), (new String('')), 0, (new Number(0)), (new Boolean(false)), true, (new Number(-0)), '', -0, '/0/', (new Boolean(true)), '\\0', /0/, ({toString:function(){return '0';}})]); ");
/*FRC*/Random.twister.import_mti(286); void (makeScript(14));
/*FRC*/count=194; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return ((( + Math.min(mathy4(( + Math.sqrt(( + Math.asinh(x)))), (( + Math.fround(Math.fround(( ~ x)))) >> Math.fround(Math.tanh(Math.cosh(-0x080000000))))), ( ~ (((Math.log(( + 0x100000001)) >>> 0) ^ x) || Math.cbrt(x))))) >= mathy0(( ~ ((1/0 | 0) & x)), (Math.cosh((((( + (x >>> 0)) >>> 0) >>> y) | 0)) ** ( + Math.atan2(( + (x < mathy3(x, Math.fround(( ~ Math.fround(-0x100000000)))))), (Math.atan2(Math.fround(Math.imul(Math.fround(y), Math.fround(x))), x) ^ x)))))) | 0); }); testMathyFunction(mathy5, [0x100000001, -1/0, -0x07fffffff, -0x080000000, -0x100000000, Math.PI, -0x0ffffffff, -0x080000001, -0, 0, 0x0ffffffff, 0/0, 0x100000000, 0x100000001, Number.MIN_VALUE, Number.MAX_VALUE, 0x07fffffff, 0x080000000, -Number.MAX_VALUE, 1, 0x080000001, 42, -Number.MIN_VALUE, 1/0]); ");
/*FRC*/Random.twister.import_mta(-2002579533,741700597,1298865485,978688012,-1977693145,-2052578099,1076091047,-1548201046,1912827070,-516764378,1176458820,-580164593,-346867848,1524253498,-735016004,716055820,719171101,-549162419,821509806,180228747,1194487739,1433599103,-1154413562,185383769,-2133929877,-1283558219,1901222124,-910897824,824604064,413345715,602526374,-1978130424,-1156048002,-1522721944,1460438505,1339484945,-909827845,355372455,1406362118,1111862019,-9983078,-373759001,384744229,1307265664,-398669115,908841144,186224224,-221934120,1580754440,-2096940785,686927471,-992754770,-468284110,-1387683041,445020107,-1492250647,-706539644,447423239,-2124877309,-1464404062,-1314771531,1754144721,-312038926,-1471341260,8104731,-585222376,-1517984381,1565888872,105440113,-391935293,-742915668,-1953202659,-1400665475,1415037870,1765444519,1438463113,870485582,-1051500640,227682024,637910546,-1251896300,-964736988,1858691949,1916737916,2076439438,342550891,-1184033140,-536293387,317413255,548396035,-1406318521,35506277,2095151425,-77850886,-1848898588,-403436920,-388929552,-312365205,-1665462788,-1510591857,-446825262,1012640051,-2122291685,-894988687,879210012,-1387702508,40700750,405286978,-1646887739,321377346,-985516848,292169343,247939313,1813305437,-238486296,-1355652433,694231932,1252484707,2143790876,1413859447,-254146310,-836265968,-484484519,-621981898,-132474216,-707233711,153767453,-2067733605,-1874445038,-1745541028,1839441402,-1508247310,584079796,1449793256,286663815,1675948699,1234570910,525124818,1232076894,-96300929,1623369484,-1556394809,-1168502962,867727532,-2031449430,-121986799,1097385054,-1515310593,-1807703913,197917200,2065066110,-465400964,-176943724,-420110172,-816758396,-1535334714,-828379557,1292532186,2130570590,-935937858,1831832634,1489432102,-339275744,617649361,-131300673,-2780106,515007460,-687348843,-643932792,1661549973,-1199801202,-26249377,218832713,1637720013,438729776,1012624236,1265012676,947121312,-685383666,747881113,1443592473,552219594,-806463026,-1236845903,1460174026,-24864267,-2098339025,-1634568136,1734651095,27858054,204309257,-599229655,1868809301,-1244251525,1402393863,312887249,-1980633390,-1529910329,296112636,-2020816510,-40930920,-1167194410,-1994677199,1896810872,-750749451,794256266,-992822545,-1154155828,1046459387,-1911767642,2091664244,3791720,981169125,-132447162,1616901606,605771060,-322871400,-2012397549,-1665394382,374835571,-459000576,1441637896,-705716877,526466927,-1276385463,-704210632,692962098,115612094,-1091177982,-1475806541,969543058,2024168293,543569003,-885209200,-1676154332,603940174,-211755334,461212702,2076246913,168229518,1056612910,-1315420824,238841707,-1181468495,-891340680,1321878774,-546227129,-1414225228,-2363092,-11488040,629690508,2011338578,-186326488,621661735,469275294,2019598561,1145381637,1562431510,-1808217000,918956600,-1007540016,-1755300980,-283279082,789010613,-956927526,-646939912,1449441391,-393095881,-2065903653,-642038356,-1822655526,-1249234512,-1149849671,-768375745,1458900002,-265066276,946009365,706701084,616544514,-1427927552,-2104204738,671089713,1988890922,347211819,-128496581,477721924,-1232290982,2075226191,-1476435513,1252537249,-1037329723,-1113902351,-869365765,-859883636,-592694211,876086763,1485573028,-1678789081,-563514949,423132935,1952987805,1531786755,1603629007,-723934556,-1666339663,-2140569247,1497815645,-1709640640,-1089576018,-831976128,1017262464,-130456259,-446166610,873137798,-423859132,1097227632,-874316873,811635992,1169825958,-599595641,-1750796768,1227654094,-678562068,-265748196,-230833406,1922274901,-1555392784,996056733,1901963944,-1255513798,-2080272383,-1542048713,141966704,2095774972,-1387252364,371055019,29833263,1058042911,1962431203,782435312,-1793441465,-1117416556,-1879471334,-189176714,-1020548963,-697835170,-1100530547,-1175427331,-1256649430,1335145320,-1118112910,-250080452,1797367901,-1894349287,-753569153,689135728,-606029064,1583594943,1177824066,491452050,889167184,-1703201183,-1693659443,-821517102,-983339137,-559827496,-1854486122,-1147906593,528628156,-447022289,-2004545647,607639694,1186829079,391736838,-1639815304,257433301,-791997682,-1624108256,-1534614281,1760833306,-1907615496,-186549022,428188566,1881735945,92410005,-750980089,-895099100,1904936561,-500437040,486021307,-1285641379,-948803045,-2069188620,-430235177,-1818331653,-1531156432,231440885,583414675,-1875323849,129792692,457753081,-210768710,-179385937,838268358,1451297682,-1886809745,-1956627609,1295738574,-1698204174,217777575,-1854620745,-979356914,-843076963,818900135,-668276186,225761318,1271313543,1544414274,-142354899,1167429460,18896690,2102561489,-1185936206,40961117,-1800797127,-751100493,952837677,1362660809,1746873359,-1788693736,107343210,2050284947,1506732475,-1873020378,322600087,584444062,-1596405384,653456091,634724175,1997259742,-1517995370,-989061063,436057853,-337142205,-1180644055,1163162240,310296437,407092483,1594259263,103151028,-1568529728,1644036588,-982215427,-1272921875,-27509967,-544113711,-1323825079,1277777898,-141413123,478390661,-1573203684,67477696,1814848470,738673138,1436343776,29856612,-295082743,588572108,1498264817,-183657257,-1401674491,496829929,-686892085,-1429068372,1673367892,-93210677,-167607666,796119245,-1177483373,738172634,641751944,862595081,562648957,-1864454349,-1465254079,1901652158,-627256785,-668364011,530749598,-1392828875,1983791718,-587890373,1950127021,-1759657363,1954947110,-1861048694,623322379,-1727665436,278808742,176372986,-2079063205,-1940448427,-2063820736,644711733,60382812,-585060751,-896692596,1142793565,-1476549277,2035186353,-1688804749,-1240098494,2004939848,-296516969,-47294149,898557484,1256684252,-1769319791,968665504,625962028,-593032486,-674373717,593547979,2051510031,1064628139,-390717609,-2116314684,-777327368,-1849350341,-1911288003,-851531678,-1015798148,639764244,-1397134491,-519631393,1991146098,84072040,-1547406375,-1693500257,2106808181,-1635869629,-1470273819,1866047149,1192740849,-79062340,-1466417307,1988488966,-1945905681,1742101455,1346107762,-1101408681,158765044,1696103146,858278067,-642139670,717445711,-1426036165,1713707991,-681922479,-179296236,1061660324,-1323215070,-172705538,-1901338067,-1337529357,-733547077,1334531092,-2066638601,-327607606,-1721161816,-1455557198,1776730406,1434073590,-783221819,2089944098,-1541433250,1808451338,-49528128,1334760880,-1576104723,-171709465,-882356528,651807824,1901835342,654899765,415017574,1835784746,-1828243209,-530989460,1872504449,-1042358993,-1103059443,-733787588,-528384451,-2090133117,85222529,170583229,-1625219670,-117282069,471239483,-126468247,-2049006036,1739641725,-1637271799,-713911933,-790899504,2125771868,-1856011623,-468621102,-1328655222,-1479832147,-157290184,1854023516,-1080735462,1512611043,-1072236183,-1232037116,-1858567743,1895767195,1511179165,-1394771847,-2056146319,949031828,-1869433101);
/*FRC*/Random.twister.import_mti(93); void (makeScript(14));
/*FRC*/count=195; tryItOut("var whnyeu = new ArrayBuffer(16); var whnyeu_0 = new Float32Array(whnyeu); print(whnyeu_0[0]); o0 = t0.__proto__;;(c);([1,,]);m2.valueOf = () => window;Object.prototype.watch.call(p2, \"defineProperty\", (function() { o1 = v2.__proto__; return o0; }));print(x);");
/*FRC*/Random.twister.import_mti(262); void (makeScript(14));
/*FRC*/count=196; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(271); void (makeScript(14));
/*FRC*/count=197; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return Math.hypot(( + Math.hypot(Math.fround((Math.fround(( + (( + ((x >>> 0) || Math.fround(( + Math.atan2(1, ( + x)))))) >>> (( + ( + ( + ( ~ y)))) | 0)))) + Math.fround((((x >>> 0) > (( + mathy1(x, ( + Math.max(x, (1/0 > -Number.MIN_VALUE))))) | 0)) >>> 0)))), ( + (( + Math.max((( + x) - Number.MAX_VALUE), ((( ~ (( - (x | 0)) | 0)) == Math.max(x, 0/0)) >>> 0))) | ( + mathy0((Math.atan((Math.fround(((Math.max(x, x) >>> 0) != Math.fround(x))) | 0)) | 0), ( + y))))))), ( + (Math.min(((mathy1(( + (( + Math.sinh(( + -Number.MAX_VALUE))) || Math.hypot(x, (-0x080000000 | 0)))), (( + Math.fround((((-1/0 ^ (x | 0)) >>> 0) & x))) >>> 0)) >>> 0) >>> 0), Math.fround((mathy2(Math.min((x >>> 0), (Math.atan2(x, y) >>> 0)), (mathy2(( ~ (y >>> 0)), ( + y)) | 0)) | 0))) | 0))); }); ");
/*FRC*/Random.twister.import_mta(-304858442,797305422,446084786,-2024859851,682839555,207066403,539679763,796966349,-1089406980,-395341755,-91855850,-277942706,1637229626,-1150484887,-1862852216,1104792908,-2040142498,-2142145167,-1859952196,-245943419,-272880990,-367308754,-1726258649,-1739616296,-1109065644,-1040637756,648766189,-868663575,1180843701,692047742,1412734413,898834864,-939770196,-185917631,-992536380,-467351271,1136921642,986959252,-1694528064,-1620370251,-886688777,-139791870,1375626910,143912747,-1642477467,477196749,-763012945,-692257235,-572694824,-552675171,975854804,755839398,-913730332,1992927738,-344869177,-1350233281,1618862513,1744368367,-1949696000,1891741260,-1587091235,-1054777340,1218783007,2064626766,713734988,-1478073912,1118669126,-810541945,-1398872358,-2018155041,-2725347,-1778073328,-1624867584,31576073,-1370804366,-822108948,-1971615108,628392480,-378312510,-323860348,1280079071,1472005882,316674660,463577679,-1604850589,1027595323,2043836438,2027218013,-133712288,1434633939,3131384,-1193634591,-1856694968,1054361492,-1357937537,5513301,2024121607,987473624,1524698898,1468652386,1579191970,-1990800524,-153597155,-567815083,-1695305505,-976609817,712613140,-1803890463,-1800190896,-399731484,-1784674627,966178244,-699619776,-1548575737,2021923018,590374390,1376289145,-1026717003,-2036026680,1921679009,-241590631,-784616365,1211747255,-1599453290,606688092,-16956134,-516993507,2002252066,-1555264647,-150320327,-1029304191,-1062401055,-1524562871,1555892990,1804529646,48824411,-1558247156,-977334800,-762871150,1969456622,726754661,-970835144,609184547,-1660167914,1292404402,260963458,-859279407,677476904,-310525331,1259264825,-1105031087,493640965,591472928,-638486891,1531501719,-1688257256,1437430878,-423145659,249038352,-577262554,1246129348,-491177919,1043387043,-1705421020,-825516743,-1158838004,1008771896,-594950857,1019927470,1404398163,1659802503,871638449,816797841,-1540437078,2009822352,1892253204,-848753259,1459680293,1801374157,-641217703,-310813915,1752824151,1613078890,-1639459454,1830990581,-22573800,1041401938,-843965311,409477157,-227169423,606844348,249621657,-327185565,823986035,773535034,-793002667,737049345,-877121155,114425920,1961712753,-1038737727,612829228,1687228295,1222554572,-764078103,-590266667,-1007465873,324401313,-673347069,14849510,-1857851603,1612997119,-1933322583,-672893090,-460170334,1491241104,1654348236,343314554,305499407,-2067627644,-70364475,-1023384835,-1934955275,740309762,-294453523,1815605773,-1813988820,-223427657,-494327864,1181986939,571771480,-1584864023,701101803,1847666945,2122256234,-2036295519,-1513007542,1584289033,-361917687,2129360173,-1549738787,1323411170,-1004838453,-485852830,-416000246,663965504,-1534237985,-1873685964,-1783428542,-874558879,-1547778959,-2020118208,175601416,727133090,1761730118,-45604888,128952181,1579744225,1861235884,-435868988,-1084554617,-1285957553,716166556,1623143623,1449914600,1757765928,841697009,272688325,-1686679340,407919475,1381431283,1521102694,-329252083,-1174413634,-291157437,417633421,-905876717,678789205,947713702,-2000443909,-1144972483,-801653166,1020569589,-983632013,700729421,-1869849171,-1810782540,730982625,1031653643,-256353630,-1127571991,-711636882,-1044776434,-1242356857,212119213,-2133269752,323620371,166355487,1133530700,1008390289,-1253049385,411641930,-460108354,1562766587,-62328241,483964211,-507628892,332088584,814317658,1286671012,-1095393266,-756815692,1731878776,1250709044,409455333,1157528420,229805151,586340267,267605757,-628658600,1515062899,-2067169527,2017501403,29049990,-627385043,1262765162,-1825692429,1720605686,-1815872535,768619458,354713233,-557273497,-71343207,1020364718,1182567659,223897752,1856773684,919904019,784806972,1170814524,-50309683,1064885575,1500305357,-1433016856,-1442940390,1084202065,-1216676608,-1424680948,-1225658905,1452585486,-668578296,-927909971,1618917065,296568829,601768218,-1900227067,20129081,-507771616,-838307672,-1084306719,-930602735,-1090504617,1701663282,1487277676,-1427122404,-1707284903,-1314840610,1687189947,1837626992,-117089228,-821021359,-144769050,69290881,-1008116627,-154810979,-988263446,77058729,1969877749,1763068552,610739548,-1551775516,394923356,977472579,-832254773,1448183193,1804265858,1012572097,2069076780,902661315,-1097386030,1625871094,-1935750461,1355327800,-320394982,-1898450641,-483939445,-606158011,-201701053,1881807083,-1543272270,-1650901513,-1805344616,674366711,-433485732,-909341619,-1209637727,-1084590018,-535109156,-1223898277,-241742738,-57160699,-1829382300,1070107540,302513473,-1962381166,-1534866759,-596420272,-2031948171,1814702899,-319840006,-1766001980,850604899,143364004,-1196176958,992808827,-1010883703,-981882294,1863399449,775311776,665057586,-322146854,1738200043,-721632314,325502203,37686510,-944640321,-896312236,446779477,1537310736,-1644082206,745199517,828649475,-199624850,-1488744569,1994172730,-2113772950,300675034,1296423301,-1072523225,-1645478507,1558133748,1438647372,-1355865436,1975916395,74370688,588092211,543628174,-2133516039,1992392948,953458277,740555105,1214856833,-1868351400,-1893779270,1586339003,1146196306,794888139,370062970,-311437226,187286422,885803849,1438353968,1929010582,-715937163,878819598,-290305275,91099864,643757927,-764887507,425155276,-1410691207,-523385561,1815083182,-889985014,646221758,-625545884,320426897,-259371320,1009575818,1370551471,-674413435,-1250096671,-96259903,1214797538,415872896,1357673102,349351425,437900192,1609281819,2002956927,1725752267,-1394932125,-757406008,-875707331,-1611831374,1564094944,1942341514,825719123,899167189,-1468570093,-1638646830,1376006761,1051536441,1938701046,1901501431,403600485,1660273461,-535508679,-952959368,-269844637,1193114765,-1004767465,619942992,-1778857703,-1531323029,58557102,1422894829,1688590485,-963928309,-2113136241,1017118661,-1353059899,-1819496354,137692308,1755084849,839445358,-1000635497,1782222494,891483089,-250764922,-2018882151,-151800468,-25352125,806764801,-273254202,1957798270,1166947440,-1330799797,-1395358800,-26936529,1157628796,-401153960,-874983188,-1074595834,-1427683826,525041195,-943059210,-1484679578,-1537164691,-1541623605,608250943,1017565332,-754636463,-1350051054,-973122287,1224908342,-559330664,-1958946648,1942769299,233975060,-563706501,-2092734751,-247508628,-919339247,-1189424093,-1022063006,1746047854,-1075764016,1086243076,-2087193627,1947820181,1890756402,-1240396766,-1950357252,-303935469,-121791043,802547269,-1197146585,1371970504,-594899846,-1634800203,-1060212222,1937041816,1763451840,-1089275100,-241552143,-157953311,714715387,542968484,-1592597270,-2130309253,471145724,1394892977,-148493641,486807709,374083750,-1245686577,-779518835,1340942105,-257000886,-1255459753,554735159,1950371087,-934911633,-1034922169,1854261569,1862518765,-2120225692,949951442,-542202405,928465149,-761300763,1919303725,-1389044194);
/*FRC*/Random.twister.import_mti(186); void (makeScript(14));
/*FRC*/count=198; tryItOut("\"use strict\"; szpmpv(({x: (4277),  get __proto__ a (\u3056, x)--(x) }));/*hhh*/function szpmpv(...NaN){v2 = g0.eval(\"function f1(a2)  { \\\"use strict\\\"; const y = a.getOwnPropertyDescriptors(window,  /x/ );print(this); } \");}");
/*FRC*/Random.twister.import_mti(472); void (makeScript(14));
/*FRC*/count=199; tryItOut("mathy3 = (function(x, y) { return (Math.imul((mathy1((Math.max(Math.imul(y, ( - ( - ( - (y >>> 0))))), (Math.max(x, Math.max(( + 1), (( ! x) >>> 0))) | 0)) >>> 0), Math.fround(( + Math.imul(((x > x) | (( ! (0x080000000 >>> 0)) >>> 0)), x)))) | 0), (mathy0(Math.fround(Math.fround(Math.tan(Math.fround((Math.log2((Math.fround(Math.ceil(Math.fround(x))) | 0)) | 0))))), Math.fround(Math.fround(Math.fround(( + ( + (( + -0x080000000) != ( + -Number.MAX_VALUE)))))))) | 0)) | 0); }); testMathyFunction(mathy3, [0x100000000, 42, 1, 0x100000001, -Number.MAX_VALUE, -1/0, Number.MAX_VALUE, -0x07fffffff, -0x0ffffffff, 0x0ffffffff, 0, -0, 0x080000001, 0x100000001, 1/0, 0x080000000, -0x100000000, Math.PI, -0x080000001, -Number.MIN_VALUE, 0/0, 0x07fffffff, Number.MIN_VALUE, -0x080000000]); ");
/*FRC*/Random.twister.import_mta(-1539785628,2103526322,1051505655,1355295273,189258454,-1590699487,1759602277,-700123213,1524178012,-1038529995,-1750231301,-943204026,1965654917,-1259578175,-233229886,1023047995,-886573274,-1013333940,1159783332,-1414706175,-202422686,-1179702529,-1597479146,-934382866,1380950785,-1026126323,128444009,-1055612674,-685718474,1986745459,1977133249,231231222,-992033203,-1901600328,-1937766472,-1256274477,235872817,255904270,286052410,906556784,1635002708,861844319,54529192,-1167162512,-430688198,1146350566,1427456078,405931606,1955446523,1291764144,1539522902,-455716267,-426825368,-261140408,-1693827828,1176068771,-550314301,25939584,1533887509,-1445142721,-532311813,-1952734300,89343042,963028167,1536822885,-235537157,835683878,146993110,-1635544222,-914193894,1561122546,-1560484138,-758015155,602529008,851723334,935827624,-2014712987,14159215,-1729401017,-96429976,226522138,-619137249,-1919993036,583649687,660249573,1355203749,1871784699,445076622,696205010,319729773,1978643559,1954966830,249354085,1497511525,1818208532,1595495069,1426425230,901328905,2066259775,1002629456,515028506,-1114692534,-2122717046,-1297249413,1463203919,-2014959550,1492655250,-709573222,690781074,-1608682485,1845240753,515793141,1621530831,-501860425,1134297234,-1901994918,-874492045,839172755,-129762326,-1020150618,293708751,975612796,-4236120,352965923,-77408870,-848526463,-296537720,739715080,-504358931,-1399579022,-1644433990,219393520,-330130192,156796978,925221175,-2113719080,1793753708,31439224,1220094361,1224442362,1227592450,-32639329,-7844595,-517075264,-248165587,1091678068,1680276501,1073752367,-2009170883,-1013461881,1729299734,-1116465376,1268052154,-1314071064,-440828204,-1592890685,362409851,-309639930,830515256,-1561773932,265665177,1651532771,-1456465063,-634629508,1641026578,-1927972659,415992150,-1684391738,-103769152,1993782148,198081199,-225226236,535120065,-1518125261,-1155016213,1317234553,1002124764,364707866,1996479249,-2019127773,1389717668,1890324913,-1934354140,-1686075088,1340170686,-384284661,879646307,954134750,1485830362,2109750427,651966644,-17699162,487374620,-1987872984,1905990775,-1081383737,-708277343,-58983676,1390684694,1318481246,2027566317,-1961017928,-2055357172,825504848,-344640695,-1412074151,662988344,-1344115389,1446861397,610882438,949222573,-796623726,-1688452635,-949872250,1298256511,1158537705,-1031984814,1380065567,1826916739,-1947443632,2031578565,-406659721,-1983989670,-1721331884,1032597820,2073435451,1298861850,-713281664,-2024789168,799471323,-653989758,-961834628,255327870,1474224592,1276906300,137475961,874958958,999550880,565891855,-34513612,-744714320,1226584568,1300186506,-1195516765,-1873778708,-831593964,-477780709,-1187593405,1162362640,1746908657,-1954166194,393484421,-679666724,858196298,-5198070,234858323,-1065903780,1117827735,1053481876,41678801,1308867904,-640160394,474607471,624613957,992115354,-1861106787,-1491060787,1825538366,-427938247,-1285306482,-1757702973,1231849827,413926585,-1152428624,-850854705,-930759763,-2117291707,1207777797,2042572919,577180713,-1737191583,1550376489,-37836347,316164666,-1866116983,291870543,1696373648,1744028833,-1278767371,-1036076439,1403781360,994505570,839179751,-292200017,145661522,1311646900,1417610186,2093281748,637091393,1367266937,1873627349,9298585,-1067590134,549790365,-675485911,-1472956907,-1281017108,365212727,-46124467,-1831474381,1270365645,1422373977,1971381183,-89489578,955803964,-1230059486,-1686148249,-350310458,1506138626,-84712317,-1037158082,-1988671066,1606742238,-515875897,1343951420,-340312679,1216726187,-1906574543,-345555541,316892957,79785111,-1277052580,-644945003,-489756104,-753339946,511341704,578784093,2057288111,1012595691,-953285898,614656459,-165487701,-1679085906,-1625329026,-884753308,-469858966,-1766117216,-739121693,1366094459,-743670868,-396755414,307576353,1555206304,-4452091,-1304300587,945894830,-1672864542,-83896850,-877365153,287194279,-808442682,1167288366,-1370475538,2141022690,-708216181,275359350,-1548022280,2145937466,-1030793083,17360762,-1702792909,707616306,-101863011,-2041795068,579603674,1400710582,1613464866,1402478674,-1354267250,1515459784,-93725882,1636845610,523549817,-407265944,-665964089,-1230678265,-1623132926,-1942239193,2101082122,-649825758,1164675010,162807950,-1150882752,-962019042,1929469404,221727421,-1776080902,-355219963,-527264163,-937335067,-273584257,1983277903,2107089751,-967458011,-683244907,693298958,-139723059,-1873035818,141014918,1811369977,-755342718,268772468,2031289972,837447210,-208165539,917918834,-1480983682,-910057998,-930726181,1448265342,1238523462,1977539493,-1546485722,290897091,1152178719,811138867,-1609154163,1874926653,-1731411679,-1290040351,-604902022,-1056222550,2070849531,647749711,355609283,863302783,-265204877,356727973,-544941725,1415682804,1188606296,2003642824,-1885038859,-1189904945,1396903978,605126254,877003341,-1072262903,809472866,-405723744,-1283027598,706453614,-1736595887,1331456090,1576163014,-1755076969,-1228614024,-1570494216,1137274513,-2144423407,-354234801,1145935632,1337862948,-1033326868,431695625,-1358766027,-151648759,-450141285,210292787,-837693199,-1839195717,-1456649945,2110752753,-1179289188,392648222,134166140,-499614051,1001989511,1541387747,1535175871,-632726778,-1985522851,679891798,-1825186173,1878770725,-296828285,977195189,269864581,1745299454,-1364722190,-426971542,-552906203,-182064916,-1421546483,1153022073,1965017574,-1100009890,566688913,-338337661,-1295334013,875193950,-1541042261,879487340,-835059044,694166261,1079890866,-1544284065,464528980,-782508545,-1298877396,-489495599,379287114,681740852,-994089292,-218345908,464904112,1799122474,808812492,-709133300,-930950274,1435757307,1524061306,-572854041,-1624547936,1031417987,-1768530456,-98268436,-706726001,-662479231,119181623,-1369347424,-1636122874,-332467105,518239787,213959040,1181041497,-406279044,-937298694,1816224922,-1352829524,-2116835872,-556905022,2007849085,-1398515964,-1857650823,2063777850,2074941945,-1807451930,1867351278,1027928416,-716493845,905411146,-1269939814,502687660,1492579579,-930989360,1092856878,-805731970,2028425702,312921429,-56786318,1670567329,1236900097,-645361398,505345716,319708839,-2102366558,-1001619875,-254030559,768662732,1203139025,-1277422382,510642749,1396632174,-1300520238,627424204,-866326076,-2012832088,-1969850612,-1078554571,-941276516,-1454803516,2109653456,1941144628,531213295,89537442,-1807420565,-1489802974,1809198611,2015360491,536498403,-1401745849,619165590,-1137545110,-1641168227,550306090,-850620456,-1968180127,983837767,543557375,-934928262,-1844016035,-236552142,-1214170701,1488857089,749674294,-1416095151,77068309,1506243855,-592865651,775513772,2070325151,193910639,1734372990,1651612760,-743265501,-645168112,421792299,-1083465028,2043018465,1995427251,-1824862955,464332210,-1002473016);
/*FRC*/Random.twister.import_mti(167); void (makeScript(14));
/*FRC*/count=200; tryItOut("mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var imul = stdlib.Math.imul;\n  var atan = stdlib.Math.atan;\n  var NaN = stdlib.NaN;\n  var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    var d3 = 2199023255551.0;\n    var d4 = -2097153.0;\n    return ((((((0x5b582bfa)+(0xb23a768f)) >> ((0xa637a8a2)+(i2))) != (0x64e4748e))-((imul(((0xc230779d) <= (((0x558bdade)+(0xf87f8f79)-(-0x8000000))>>>((-0x8000000)+(0x86306af7)))), (!(-0x8000000)))|0) == (~~(((+(~(((0x5bf96c0c))*-0x956db)))) * ((d0)))))))|0;\n    d4 = (+atan((((i2) ? (d0) : (((((0x0)) ? (d4) : (d3))) * (((0xfe20904f) ? (d3) : (+(-1.0/0.0)))))))));\n    d1 = (d1);\n    (Float64ArrayView[((i2)+(0xfa1433b2)-(0xc65f7f46)) >> 3]) = ((NaN));\n    (Float32ArrayView[((0x47f3ceb9)) >> 2]) = ((d1));\n    {\n      d4 = (((Float64ArrayView[2])) % ((x =  /x/g )));\n    }\n    return (((-0x8000000)-((((-0x8000000))>>>((((void version(170))))+(0x166aeef9)+((0x7fffffff) >= (((0x947ec52d)) << ((-0x8000000)))))) <= (0x70b08d38))))|0;\n  }\n  return f; })(this, {ff: Int32Array}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [42, -0x080000001, 0x100000001, 1/0, Number.MIN_VALUE, -Number.MIN_VALUE, Math.PI, 0x0ffffffff, Number.MAX_VALUE, -1/0, 0, 0x080000000, 0x100000001, 0x07fffffff, -Number.MAX_VALUE, 0x080000001, -0x100000000, 0/0, -0x07fffffff, -0x080000000, 0x100000000, 1, -0, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mta(-1805424676,1724678009,2035139374,-367885804,-5687680,-1863343942,1954482211,-1171649349,-1856572725,628458863,-206024331,-335821157,-393621178,-1409877405,-680482762,1551957479,1344704012,-1861757809,-1167572307,-565290929,203339858,-1730015920,846593801,-1174585575,-843240324,2030683085,836562108,792508420,-765073963,66233650,1764047686,598414040,-196576451,-1649283418,42762396,-1520335300,557548872,498352862,678465223,-1064607783,-1780165163,-568008905,1230429004,905096517,356834363,-1523697966,-1257603356,-267550840,40771254,430416614,1802832124,1131939798,-1612280444,-33319948,-803233312,787249647,261721882,-380877805,444955095,1609477850,-408291030,23121072,93671597,1579645346,-440411726,391768119,-972433145,385543864,-876371656,-1737462416,-195751696,-51860150,-1612366199,-1962787944,-1295088269,-416038244,1624362996,-2112204446,2061466184,-1527233392,-1891774761,488122489,-1813202773,1357686315,952926672,-2042202380,-1636404028,2068077388,2126588522,-1715357095,710342674,-161350509,453924383,-794608928,1770998708,-542692821,680576214,-534427847,1761525070,-1321831085,1057058484,-1419143994,1922347233,-960918874,-1479107702,1477961509,-455057327,2113281852,-916727448,1275246936,-1914198287,2013274439,446111528,-2095258728,298555495,-732291758,79017762,-824331335,2049769955,-1158410478,757475954,-362491304,453937456,1747091510,-1519803035,-1426888669,-920598108,-1802859606,-1059302703,-1260815311,-1821777545,-290844423,1136055598,754662116,-1619319446,-1722043031,504130199,-1315641965,1645773732,-1017289219,1848622954,-1970408765,-540380468,1614917801,-1102669192,-592013656,363656012,206696888,-2084464986,136616818,-1963035786,176684211,630366100,-1483238271,-59179020,1737099000,724813103,3580135,-638146918,-1614691907,1741226064,-176690027,2142299243,-1938454405,-66004712,98327978,-733639319,1660336980,1751451493,509600554,-49948833,639752606,-1508248694,-2094191109,1301616561,62017747,1507879523,269287301,-1078047742,-1523163754,693642927,-1932756066,-227093331,-1609174461,80601374,-1098819010,1876753499,871257986,-1564568272,-2027229391,-1739874703,626028957,2094943871,-29397497,717098235,-687127911,-1039168024,-144713834,126236549,1747527025,-1893635395,2015032001,2029788375,1693714689,1593083438,-1574653138,962117581,-1431816716,1050392309,785994968,752207452,-1922964190,-1088906674,-780058804,-1058478156,716194758,-1756770770,-854890426,-700152821,1007190573,-1278356401,-72024431,896973643,673830189,939094871,1025024575,-293507576,-674532748,-1474841397,1439676271,-1991816534,-1204631105,-1157574574,1383140797,658139096,-1958372612,951874239,2053998637,-721197055,-2126014818,-814161249,-238089485,-640244887,403619322,-164584059,1386356991,467503409,1857726426,904226679,934746670,1800373124,-435969646,546981736,235191097,-255075470,-228710021,-72725338,1983927948,-1147250193,-750148195,-1319495651,-710883340,787766209,1017821189,-1942744113,-488102402,-1226006714,1070821910,-2020262672,-1681677838,-934520533,-2145751368,-1198941174,1252438108,222761601,-612305205,-481194181,-828235752,-884785891,181697259,155143231,2009613789,1736465650,-1628203135,955662187,671822879,-182453163,1732415119,-109633189,1816350933,1132724243,1706362782,-1189353409,-2107730386,837680354,-503570211,-1508764262,2141273871,1298101929,825961020,307001867,-1830786442,777642765,-771289921,1325980343,588113726,1997712980,680879918,-847614657,1865946770,-477639464,-1694220080,-1156363937,-1039515558,1611874141,-1435095290,-330371654,1186206995,1376845325,2048477824,-1810325965,107819995,1980741399,1084050888,1291217194,-1783304252,789788692,-742768450,2064684951,-369314187,-548841976,1377394335,695243321,-1922295622,852174200,1097640985,-398076592,180513755,1536630844,-774972654,553991826,1547570992,-1680497555,1628727568,-1088229108,829462963,1241795900,-593960048,-1011683442,1864529445,-1207914503,-1959727819,203804798,151552145,-927329923,-822518624,-911829306,1874554247,1059962485,1683933005,1311936243,-2007810915,-426442344,-1377802483,-106940760,1942291800,-1129754144,-698309641,-905346690,1266842250,894902192,465105513,-1617903190,1156248865,636445539,-1277930441,568888155,-1654804047,1739454167,413561399,-681594732,1793724695,1414973516,-568562413,-1033061445,-1772692453,1087673713,425000021,-640297596,486877066,-2001754052,-509366472,1720204581,-1379589241,-43667755,1668584600,-230772489,340012206,-616965581,1221194986,1631496323,-363432251,-1181744738,-1421108234,1151699970,493028283,-316963971,1835793772,541027517,-619977236,-401121159,944005668,-1502319317,-820011478,1756724667,-1318950769,-473292344,1694511555,1316557474,1480024412,1574482698,995577064,111717415,2035372088,1987778768,-1903843428,-2034164816,441432818,-1197504530,352643690,74555476,-1169464052,677508054,-1429661069,706412308,-1618238573,-42960299,-1709237710,-414111656,-1670069534,-365450328,1580342289,-281981442,-18332101,-553396367,1433351666,-2062845322,-338551298,-933467071,1823866354,2099512602,-1563488096,1521915410,-1065859733,1165103584,-210378761,83731219,1907051837,556605544,1467549610,811058741,15037002,-1435382390,-311864860,-186365720,930143194,1792710540,271858265,1338987092,166600555,-711939658,299882146,1316527153,1349395006,1833254116,-1645090586,-211601358,-542578262,1389061906,230615787,-740318648,-1534528807,1657566949,358555243,-663779566,2139717994,1112273408,-2057729054,-1024247539,1571958004,-903372344,-156833863,776135463,1303966629,89954021,-1734169633,1378381669,1689147829,1081588902,-493048027,-1044592810,1467147831,-56756347,787033758,-292763199,1135706605,1191995841,-1197862369,780279755,-1881039419,-708957020,749173361,173311813,-1939743885,714629463,-857139634,1952050995,1767489045,32796193,1255845277,-1355465709,-2046282674,-1368814067,1638382852,1961497083,810365919,-1027374812,-419076716,1214616114,963204701,-1657121988,-1609101241,-176911116,1903349396,-1833994659,-23184639,187231471,-1784185195,-1934951930,-67462225,-1385339205,-2100485188,-1138490236,1038443225,993359118,-154222034,1882945267,-474063804,416238443,-979201475,442953965,1456556519,-615523310,-1704922442,-134521386,461455744,-838830390,-1556414725,-1035826966,389960448,1705886389,-1893770969,1839785116,-1488278006,-1706167209,1523521389,719344867,-1067423523,181821782,554052698,2029675385,1763550413,418376836,1396284501,-1909834122,-442721428,723597681,-45378433,1306727920,1876390192,1571568243,-1234865771,-148857158,1601893358,1829793878,-1408796897,935818204,-1563350747,760510135,1885378870,584143089,-1412174493,1843150189,1790378097,-2046418078,-324024686,-1747111835,-250758836,-1836891703,-1145843305,-1796668464,1562125178,1896642609,-725667964,-1962262998,-345421024,-1008386334,1656011468,-575247730,55212826,2057801219,1587765459,-1511593180,1911315293,-1450895077,-1257236596,-929066432,-1759872670,71950743,-990418141,1028715986,-1330430964,1097541756,-1206975719);
/*FRC*/Random.twister.import_mti(88); void (makeScript(14));
/*FRC*/count=201; tryItOut("o0.o1.o2.m0.set(m0, o2);\nfor(let [y, a] =  /x/  in (\u3056) = window) {(true); }\n");
/*FRC*/Random.twister.import_mti(249); void (makeScript(14));
/*FRC*/count=202; tryItOut("mathy5 = (function(x, y) { return (Math.max((( ~ Math.sin(Math.trunc(( - y)))) | 0), (mathy1((mathy0(Math.fround(((Math.fround(mathy4(Math.fround(y), (y >>> 0))) | 0) ^ (( ~ -0x080000000) | 0))), (((( + 1) & x) ? ( + x) : x) >>> 0)) >>> 0), ((Math.atan2(( + Math.fround(( + ( + ( + Math.fround(Math.min(Math.fround(y), Math.fround(y)))))))), ( + (Math.log1p(( - -0x080000001)) && (mathy1(( ~ y), x) | 0)))) >>> 0) >>> 0)) | 0)) | 0); }); testMathyFunction(mathy5, [0x080000001, 0x100000001, 42, 0x0ffffffff, -0x100000000, -0x080000001, -0x07fffffff, Math.PI, Number.MAX_VALUE, -1/0, 0, 0x080000000, 0/0, 0x07fffffff, -0x0ffffffff, -0x080000000, -Number.MIN_VALUE, 0x100000000, 0x100000001, Number.MIN_VALUE, 1/0, -Number.MAX_VALUE, -0, 1]); ");
/*FRC*/Random.twister.import_mti(580); void (makeScript(14));
/*FRC*/count=203; tryItOut("x = ({\u3056: /(?=\\2)[^]/i}), x, x = true,  , x;v0 = t1.byteLength;");
/*FRC*/Random.twister.import_mta(-30759987,-408994908,2109781472,518665155,-1574852968,1520907600,794176884,-1794751048,-690916909,1305418520,-2120306946,1417380894,402139138,-2085669790,-821253112,-1905841619,1586807986,-1400247246,1196291191,-1513783839,1769027435,-1907663367,-574534129,990258484,-556065327,507959929,1859062842,-968795419,-813894395,-1303149037,194655134,464718511,1541152057,1161289754,-1459902958,2029793650,-1542243556,-1490417496,650558624,780836960,1812317558,-2080750082,528819359,2040362346,1285883768,-1246465396,-2031158785,-1640703958,1505551489,-1330512376,-898753003,-944821629,330576904,355194346,1823579272,1568297375,1842796477,-1858593324,-595425126,925458310,823864165,-1158727455,2020260731,42478316,-767478130,276664790,-1508628808,-788162444,2068376930,284172276,1849715964,-1724547633,1282343591,369056720,1648769004,1041267659,1365445263,271221184,-1886532946,771059590,137121097,-1036678248,-54523615,-809901408,-1481913949,771181703,1761424333,-418442713,-362681191,392203785,660718964,377266909,1977856388,-1092615150,1081983603,2047508812,-459087642,1898170434,422650281,229169215,1897567190,-1607117815,-1044354442,-1839756653,-1569610374,1474656114,1343365376,-903797387,632347969,-654898586,1569895011,600412255,-1905267703,72568904,109737176,1208900820,839365232,-830058119,-778890809,583727626,1550571321,1282615993,2127293830,612982398,1249456256,-889591073,736295121,-1920169908,-215401192,310362432,156818743,700381349,789891887,-1836596855,1974630956,595200352,-256897918,-475842673,1178089760,2084516698,166278955,-481311904,315814692,-1303499897,-325687064,-151880414,1003330053,987086429,-1294168169,1967411016,1073025730,168166561,1331816610,1683656471,622086811,1474203226,57872922,-620753253,-848752255,-1109068062,9025646,613566976,-2012469278,463842873,-839813134,-561868041,-701369440,930596666,1440802552,-1922429037,-1821342702,433756307,-107476360,-2026350466,-238273413,-1390974614,-1036561592,-1846208393,-1224231513,-427451655,-80893520,-1378824327,-1495975730,533383932,-1457136502,432427080,1183701039,2085567182,1989849176,-487977925,1769054516,-1976311465,-696803606,-293149101,425655536,215743385,286845882,1556973695,1102308597,155530724,336097523,938868605,281109960,-1147977529,1276017389,-1264019704,-1041549954,1297044879,-66723508,-711991860,1678002269,-2110117975,1804264636,450100697,201015600,-1371403213,392818558,1538255809,1914496581,1215416504,1942533877,-939914003,1240150378,-1079706458,926408140,1982570360,-739591645,858376567,342905036,2036535477,-604248125,-6173007,-1432943791,1019944600,-1868265274,327678035,-370053167,840411681,349720401,-380835438,1648361924,988761443,-1033866032,-58448209,1557154962,-743735248,-1835520500,-359975921,-1785671442,-395931699,134739453,-1902756251,-2142488774,1454039427,644284039,-1297493162,-915165867,-1889685578,-350263106,-1703304728,803701728,1720269613,-6169169,989954596,-698475945,2108748547,1902319979,1875860238,-837053177,-492062507,965755446,283232637,-790156638,424001632,721163152,-1323527229,-673124860,919023684,466462505,-1910299960,-1211676709,1601286897,-888460672,-1465550633,473249540,2131084911,-578770914,-1800926441,1439047764,-1063253075,810723619,1472492110,1364384449,-18687799,2029205701,675407791,-165138260,-773363849,-2119636783,-599683203,479162091,-1402833227,-1910813365,-1343236341,28078687,-1274765948,968875025,-1214657783,-1247182639,-855380147,-2110012728,1663753683,1290955946,-2114184004,-231471708,-1673094588,-315476897,-1755247955,728762269,-421048766,1692282144,-495802073,1514416040,-1025911693,2079965088,1320730019,611711072,-1785042750,230932460,-1369128590,1649644803,801201337,1364425519,158839740,1939850150,294795241,77500244,1884889725,187629014,-554863808,709646288,-1838672335,948201564,764857078,255241599,-191809703,210144194,1035116798,-1561681548,-71103835,-132540357,208394431,1467292232,-1766375248,-353360356,-1745193349,-55916708,-1882803502,-2103890980,-1861927799,262598424,116980448,-326989255,-1939859498,-1706969821,1483510224,-1912089986,1827534740,-2037449179,142179580,647684716,-480376771,227522413,-1338860693,-1170791271,2065726181,-488495281,-718579338,-1621258907,1691234536,-2010695869,255798973,-505935860,-78774504,153342025,873196518,675690519,744706732,1779489221,-1940130820,1802795429,666753471,1365816299,831230997,1187876214,-168358308,-951576124,669309396,2109629158,1343221478,723243971,-1392231244,-122510191,-1603955383,105654645,411223238,-1875876785,1916448561,-2141897329,1272330285,1139342318,588733120,2118754141,-1411394003,-34161066,125804732,157459461,1313679461,-1507307015,-124008593,-215138265,-2097014212,812864389,707094482,1536121777,47409453,1147332765,138916612,2104986184,318354914,-1497959871,406749958,952412910,-1796846860,-612223847,464874681,-1736421163,397204593,-872397096,512831848,-322813170,1013180367,1212063729,-505367527,823685432,1889098622,1033422407,-1896992758,-1314852332,2004431847,-1362922250,1517065925,-820048622,-1319914797,-1818519981,-821677670,-658635020,-882018313,-736277148,733237396,1018800061,-2053345789,1697861793,-1820111963,1773127628,565511319,2019443809,1168615662,-1492061687,-391634933,-1268003330,-488328619,-73625297,-1539657602,-462176132,-333361929,-2018313448,1633830516,289536975,-1448876514,-1645860816,-838306518,554626236,-448500004,-258380029,-902131266,-1730845671,-677990471,139472215,-625865397,-648396505,410508059,-1033618930,-356130106,-90784194,1040650858,1240736976,430677093,-1197003216,-1338423031,-336329820,-1917167475,-429390708,2041461307,-837336979,-1589435626,191273752,2039412961,-1047933748,-1579926318,1744729392,-2145926023,-532833527,298068074,-1294172112,-1226676462,1829004408,-1449120020,-341732257,-541002729,-1108950290,-1227927780,1485977901,1431668878,1355370055,-1597429693,-1346159177,2025695218,702442820,-2138676011,1726803959,2065052709,-859964722,-1444882464,1373529686,1765099129,1591271640,-999374901,-2015420197,-2092142808,-1063613086,-1406793754,1539087351,-257388840,-1408865350,-899347397,-684171168,-1313785782,1504399590,-1904218367,1891221599,1449021865,59294968,1602770571,-665139198,717456521,1727074000,57856374,1683911993,-91411798,-1745834000,88846824,37183724,-793721440,-2076829420,-2024380552,1742075889,1864853371,-2098528228,-1645090497,-2146391985,54614845,1141197228,194221305,1333587272,1853000979,1550741573,-1628958013,998268967,-525617234,344803493,-1855952575,-129560692,-903676041,13482370,-646278606,426055876,-1073453924,1053341307,1692570270,8475064,1973885770,-197156553,-1929067569,448402653,1416156872,1895800922,-153882025,663703593,1207645829,-558069034,465152094,1367338279,-1486407590,-1600127770,-22081004,362048910,-1493433852,1318720304,1166245842,1293221806,466658779,-705333609,-1517550523,1995135338,241111269,-942223539,-1336395343,-1664164623,264292610,701630995,645405000,1895317263,559282429);
/*FRC*/Random.twister.import_mti(128); void (makeScript(14));
/*FRC*/count=204; tryItOut("mathy1 = (function(x, y) { return (Math.atan2((Math.pow((Math.sinh(( + (x & ( - x)))) | 0), Math.fround((Math.fround(Math.log1p(y)) ? Math.fround((mathy0((Math.max((Math.PI | 0), ( + ( + ( + 0x080000001)))) >>> 0), (y >>> 0)) >>> 0)) : Math.fround(( + ( + ( + (Math.tanh(y) | 0)))))))) | 0), ((((( - x) | 0) * (Math.fround(( ~ Math.fround((((( + ( + ( + y))) | 0) * (y | 0)) | 0)))) | 0)) | 0) | 0)) | 0); }); testMathyFunction(mathy1, [1, 0x100000001, 0x080000000, 1/0, -0x080000001, 0x080000001, -0x07fffffff, 0x0ffffffff, Number.MIN_VALUE, 0x100000001, -Number.MIN_VALUE, 0, -0x100000000, -0, -0x0ffffffff, Number.MAX_VALUE, -Number.MAX_VALUE, -0x080000000, 42, 0x07fffffff, -1/0, Math.PI, 0x100000000, 0/0]); ");
/*FRC*/Random.twister.import_mti(394); void (makeScript(14));
/*FRC*/count=205; tryItOut("v0.__proto__ = g1;");
/*FRC*/Random.twister.import_mti(406); void (makeScript(14));
/*FRC*/count=206; tryItOut("mathy3 = (function(x, y) { return Math.pow(( ! (Math.min(Math.fround(0x100000001), (Math.fround(Math.hypot(Math.fround(x), Math.fround(( - -0x080000000)))) | 0)) | 0)), Math.hypot(Math.cos((1/0 >>> 0)), Math.fround(( + ( - ( + ((y >>> 0) ? ((( ~ (mathy2(x, x) >>> 0)) >>> 0) >>> 0) : (( + ( + mathy2(( + x), (x >>> 0)))) >>> 0)))))))); }); testMathyFunction(mathy3, [Number.MIN_VALUE, 1/0, -0x07fffffff, 0x100000001, 0x100000000, 0x080000001, 42, 0x080000000, -0, 1, 0x100000001, 0x0ffffffff, 0, Number.MAX_VALUE, -Number.MIN_VALUE, -0x0ffffffff, -1/0, -0x080000001, 0/0, -0x100000000, -0x080000000, -Number.MAX_VALUE, 0x07fffffff, Math.PI]); ");
/*FRC*/Random.twister.import_mti(622); void (makeScript(14));
/*FRC*/count=207; tryItOut("mathy3 = (function(x, y) { return mathy2((( ~ ( + Math.round(Math.acos(y)))) | 0), (( + Math.asin(( + ( + ( ~ ( + ((Math.log((x | 0)) | 0) >>> y))))))) | 0)); }); testMathyFunction(mathy3, [1, 42, -0x080000001, 1/0, 0/0, 0x100000000, 0, -0x100000000, Number.MIN_VALUE, 0x0ffffffff, 0x080000000, Math.PI, -0x080000000, 0x080000001, -Number.MAX_VALUE, 0x100000001, -0x0ffffffff, Number.MAX_VALUE, 0x07fffffff, -0x07fffffff, 0x100000001, -Number.MIN_VALUE, -0, -1/0]); ");
/*FRC*/Random.twister.import_mta(1412121606,56506390,-965589032,973799567,-1067997668,-283528661,-1427720299,-198434493,2120567114,-1862323408,403139902,-1951848050,1241621020,611233258,-47415543,285474052,-1113907148,123270322,-1936347501,-455962769,-799001018,1371555361,-1525099019,1162378768,1428801503,118805912,-1878164865,-1522953748,-1024320773,28307794,-1667856756,-913230837,811746799,-1295310520,1681955775,718092128,-948744544,-1998492983,217070729,-1367166354,374472334,449471560,576687069,-896483150,649715337,-1841212463,-1359292404,-993086553,1757521018,-1045988974,1949373844,-126162928,2112674066,-1734624590,-304541995,1627182611,-1177568199,-35991010,-1802330535,1497047961,1326603096,824221702,720389602,362364154,-844978456,1983464445,-83785825,336310653,701303661,1333686815,-801790250,1479525253,-497578525,-2058824184,1692680047,1243980983,-1406144354,-474667733,-1159988428,447507811,1081639864,-165064832,-830531762,1463516222,33252278,-1938242171,1338726160,480323984,411199077,-1956280669,1168133640,849474965,-977137854,543953089,628267965,-264942979,-1839986969,1862704693,-1579430230,1903783227,-1866889538,-666428661,1612332191,-1160982247,-431430860,-832498676,-977921954,96968210,-1925667291,-56134922,-245202927,1605798423,-469920522,1689997148,-1542395373,-113360335,-1349537783,1126021132,-410576361,-633782469,378604399,-725327204,-846963928,-1730520402,180030124,-1804864102,1402195112,694014155,-369702685,845669363,-177575041,-1487095796,281883854,473289441,1789603989,-186254193,1094319352,851606214,1462427604,-1020998766,-171352453,-826910391,56871476,-1227769578,-681625225,-1621957078,1959452969,744529070,-1329124449,-926750463,767199941,2115740855,626661461,-79997491,2108757636,36785653,-352263911,669446173,1949433848,649450215,289141878,1616406216,777473385,-1324870647,-217954228,1764727100,-1962203587,-1362728344,418107502,778941944,-1161651219,-1104739040,-563231488,1644037805,1439362952,622780424,-631134179,-1913157820,-2076643152,569943197,1359529376,1760230464,-1353788720,2074336,-578600603,1107907396,-200973808,998302126,1896293616,1843251294,1544889576,1442019598,-1968615064,1278095296,-356362663,-55323414,980072239,-1553246600,1355435066,-470603524,1948368182,804250317,-1019599303,565380991,32367578,831158168,1489510978,-1633874880,-1805058830,-23135873,1055498511,996106606,-773705247,1223253814,-1778838755,-1639874264,290668922,-689071465,711455929,1731863784,179146520,-130333628,269662033,1917445365,493737716,-1073360191,-506876775,1578331232,-1494810477,1921451238,-590129400,202676075,-1317257881,-1565199370,619146677,-745189763,1358714623,-1956382135,-1089512121,992060158,-1609450620,-602127007,-162963828,-739047811,781005994,-975586923,144680375,-1700241871,-1124355816,2014552020,-619982339,353360962,-179759738,439793123,-1133676473,1061387406,1174480521,-384224557,-2068978433,1737589791,411503617,-1030175305,2001598066,1968501588,1865524119,-1387724573,-1721425943,-1470855982,-224982787,2123868870,1541969107,248138712,-555502623,-1148923452,1162365593,53597048,-1698373200,-522225953,-9733772,-1090008544,1848365845,-933454955,-1381573977,-137025605,1532002806,-1168979370,-1972922675,636570482,-2005396209,-338583124,1048249821,2080602967,-801071290,510700322,-1725697419,316216123,-1098550917,166290017,-1358449436,890800713,175201677,-1159649003,-2066022419,1978759534,-105419799,2131535331,-1738000328,-2086341873,161483001,-1889339862,-1079598584,662853091,-1937323045,919688642,1384277170,-149697387,1507701546,-1995375335,30560948,-1213392430,-2007108467,1213237353,1213272219,-274147017,-783126469,-1277087078,2075416922,-698853048,-814384206,-2009381183,874827674,1474948732,-891630126,-59115123,-1811532487,-1887968881,1568887575,-185204998,1891644343,-1227112674,-192416613,-128786883,-269146294,823940713,-530738305,-1580965898,-991924412,132406229,808277777,679487466,1206322734,553748360,-1624222270,652992422,-72852695,-1750881459,1971632794,-1272512879,1993774743,1461601090,524922769,-974994090,-1294600348,-1794009418,1593061934,1344878315,-1252904872,1871090102,-1970608329,271497986,511053271,143675934,507714368,-1327905862,-923266813,415140071,-1571338822,-81986392,209501379,-1203686613,632058444,1297945218,2140648057,916044258,1038288366,-115715284,813988785,-1120196533,1718984502,-1025130140,1004423177,1119789414,-387783703,-1469194106,-1807880890,2068831372,2107627794,-2078430562,-1776225709,1390976062,2004621559,-1332015841,-333145485,5180536,-2118720217,354972232,-1041415206,-936711240,-1811328887,-1900368089,294914944,2075082260,-823261043,-1963049669,2017407472,-323041747,-738988877,-704004917,-1330238874,1782006180,229581534,737365828,-375298301,-1901745624,990532145,-336361301,-405737090,1251637266,647182396,1231679430,1840006908,495957677,1006195426,-1409185583,1246694083,18900039,742401944,417956451,1947728346,-410840986,-1882186738,686746682,934898683,1239382502,-291424472,-1381816507,1615674605,1383986706,445607272,124980522,-2039013560,987910269,27573111,822925167,965768365,-893910039,-1908863038,-1226968646,1506721569,908615270,963802152,-814320326,1130126192,606844185,45205725,438882216,435320457,714175071,826336699,-1401112461,998895496,-901002014,-1748704854,2057717129,1974487189,-14496620,144882926,1252236485,31338317,-1145437794,2100465526,-320205287,232868832,-1488641577,-1945863668,1372579372,-1789762788,-978867595,1992913869,-2098698690,-1603817978,1308868240,-668208768,-466730762,-145289753,-697492843,-347417557,1203438539,-807510141,-1424379341,1683049821,914114783,-420577606,617083225,-1333860524,-1160235784,449316495,1324299635,-1732868612,-564535233,1859548504,-1303970643,-223289757,-1828071723,2122348795,-17160397,-16664870,-761037011,-1964265085,-1900806607,1159138476,1818385980,947115900,266954375,-2138749281,1643027168,1229347248,513698607,598387616,1856256201,-781003869,-538339698,737988115,-259585261,775348460,650934421,878516496,1698792122,1713660535,-322204310,1623348785,-1504405098,-817394695,266241783,1965738971,1783521924,-277510665,-460825346,-697839818,-1459273621,1569669436,-795471289,86878464,1469660507,439430099,-66192166,-1987957126,-1627175463,1789885225,-2128438742,-1092869767,-1793227441,-1490058401,530079645,-1218523834,-1709016944,406895740,-168659819,799185533,922076082,-374060248,-1033947223,1023747413,-480372256,-1445614205,-2028806164,-1090740652,-2094037278,290741343,1283342671,-1219273767,-2020877073,1807377449,904029787,-1734625400,979639029,1998352652,-651869069,-141325287,-1298833480,-1346233581,-35433878,-1885083693,1627884265,1169357522,-1292552422,-1303383306,-726067940,-1301972605,824008235,-49997931,2035242831,185406666,-233260087,-2075429470,1186368004,-1421921751,1122073556,1872538987,1495125422,-1569104944,-1911484806,852812241,1274140420,589041894,-594130865,63008099,-323905874,90097127,1694717503,-1152259038,893993502,-219312083,1468693265);
/*FRC*/Random.twister.import_mti(134); void (makeScript(14));
/*FRC*/count=208; tryItOut("\"use strict\"; \"use asm\"; v0 = evalcx(\"r1 = new RegExp(\\\"(?=\\\\\\\\B)+?\\\", \\\"gim\\\");\", o2.g0);");
/*FRC*/Random.twister.import_mti(259); void (makeScript(14));
/*FRC*/count=209; tryItOut("for(let e in new Array(17)) for(let x in []);return ((void options('strict_mode')));");
/*FRC*/Random.twister.import_mti(300); void (makeScript(14));
/*FRC*/count=210; tryItOut("\"use strict\"; this.a1 = (function() { yield (4277); } })();");
/*FRC*/Random.twister.import_mti(319); void (makeScript(14));
/*FRC*/count=211; tryItOut("\"use strict\"; g0 = a1[v1];");
/*FRC*/Random.twister.import_mti(336); void (makeScript(14));
/*FRC*/count=212; tryItOut("mathy3 = (function(x, y) { return Math.min((Math.tanh((Math.fround(( ~ Math.fround((mathy1(((x ? 0/0 : y) | 0), ((x >= Math.sinh(x)) | 0)) | 0)))) | 0)) | 0), (mathy2(Math.fround(( - Math.fround(mathy1(Math.fround(mathy2(-Number.MIN_VALUE, (x * ( + y)))), (Math.atanh((mathy2(x, x) | 0)) >>> 0))))), (((((Math.fround(Math.imul(Math.fround(y), Math.fround(x))) | 0) <= (0x100000001 | 0)) >>> 0) != y) >>> 0)) | 0)); }); testMathyFunction(mathy3, [-Number.MAX_VALUE, Number.MIN_VALUE, 0/0, -0, 0x080000001, -0x0ffffffff, 0x07fffffff, 1/0, -1/0, -0x080000001, Number.MAX_VALUE, -0x100000000, 0x080000000, 0x100000001, 0x100000001, 0, 42, -0x080000000, 1, -0x07fffffff, Math.PI, 0x0ffffffff, 0x100000000, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mti(614); void (makeScript(14));
/*FRC*/count=213; tryItOut("mathy4 = (function(x, y) { return Math.fround(Math.max(Math.fround(( + ( ! ( + (Math.pow((y | 0), (Math.min(mathy1(-1/0, y), 0) | 0)) | 0))))), (Math.fround(Math.min(Math.fround(( ~ (x ? Math.fround(mathy0(Math.fround(0x07fffffff), Math.fround(y))) : Math.log(x)))), Math.fround((((y >>> 0) != (( + Math.hypot((Math.sqrt(Math.fround(((Math.fround(x) || (x | 0)) | 0))) | 0), ( + x))) >>> 0)) >>> 0)))) + (Math.atanh((mathy2(( + 0x0ffffffff), (Math.min(y, y) | 0)) >>> 0)) >>> 0)))); }); testMathyFunction(mathy4, [-0, -0x100000000, 0/0, 0x100000001, -0x080000001, Math.PI, 1, 0x100000001, -0x080000000, 0x100000000, -Number.MAX_VALUE, -0x0ffffffff, 0x0ffffffff, -Number.MIN_VALUE, -1/0, Number.MAX_VALUE, -0x07fffffff, Number.MIN_VALUE, 0x080000000, 1/0, 0, 0x080000001, 0x07fffffff, 42]); ");
/*FRC*/Random.twister.import_mta(-2051885419,-1256599105,-1763332954,1465371641,1579115733,543125862,-481186810,-24886910,492301264,-1913719483,-838959233,-251035257,-1668417070,-1240824613,858701974,-802973545,-917354654,-411216282,132067653,-1144785008,669069060,993194051,143883948,-1103924754,679028104,2024762083,-600218914,-1015287917,-1423675390,-375672264,-1218817336,-408245740,1342996322,-2038121476,149499165,406910386,1903791466,-1790991272,375471472,1734924511,361541703,-63927061,-1026854849,1166295957,-1194920691,1623459837,-1297051414,-1698568939,-1921999988,441824807,1849721370,1685651937,188665971,1771251965,-745239637,-2075404876,1340194400,-355366050,1059922682,-1448074642,-1370644039,1287036368,1021624347,530786140,761422875,-405526432,-148447880,-1889534540,-1533065608,837330402,-544332990,-1721527403,-287779977,-789364512,1985064550,-2116871707,-1837865021,685618447,729565946,681508146,1907833605,1726063850,-802701439,2110733997,1943985156,1778704488,-1458195169,424540641,-847931998,-142457832,1174397024,1411937388,1272372865,735466247,-284054671,134824492,178634547,-407180622,936975575,-485091468,-1299169647,651948307,796355168,393559239,1363985113,-2076872043,1713651280,803865753,-997487229,-76417448,-1203978073,-1454878841,-1409005679,-438914930,1473342826,1015002808,-226030893,-733264593,183371889,759268274,-121549213,-332817385,-1025584282,4884986,1717019889,1371156776,-2108735939,762745393,-1579820090,-352592688,1295005481,1808544199,-105488026,2100296502,2090063894,1264595055,-370788752,94605062,123608412,-676264206,-1693311295,664110957,-140291615,-1838843307,-369235325,740969394,435079328,-197005621,-1759009061,547385418,1116552826,1573024707,227564114,592956030,1216742498,-1448777389,-1654458998,539612207,1985979766,-2128620479,-1355843907,-460559038,11411697,-950205089,-511030831,1000513694,1224436393,-81058447,-1928027540,-1675017899,-1428031995,1083472125,-553488325,-1018086164,-791656531,-1992474236,-1515857342,-339094053,1323711869,-1770455932,-1218774846,116602167,208769599,10111924,-426805939,1371067681,1747064460,-1609030160,210435802,1494672248,-203622156,-221829971,-729659304,61571296,-2084915169,1268649115,1890722261,769121487,-2096323740,-933286803,1514558629,183556672,-120820405,-34347400,1636461699,661194219,-44679703,-830534693,-1594800540,1833128561,1598999395,-563804860,1030316597,831349377,-1053700370,2055029100,-108025200,-282633627,-284468677,110602991,-794020724,-731959664,-986770278,-1243150504,-1941759071,453113534,948161825,264865283,-866495540,-1198782686,-2007682925,-542520647,1896155293,673884675,1313232483,-333352848,290961598,191979779,-1399238408,-1937431536,1091311284,1208643536,550677366,-1642799817,1553545843,-627551423,798976087,2040330120,1195065257,-1138874739,-189489201,316518219,-1396932403,1527213602,-1663413804,288117657,1142922126,1812205672,225106116,-985183811,1052797432,1934612004,585796632,-538317698,445879542,-1009057189,860002998,-170949402,-2089068152,1983351433,1122068089,247438370,1023831839,1226573177,-1688662871,-2146243756,-214778473,301285024,1006298353,-450655962,-726280728,474961447,1722414774,575274651,-134680971,-485074621,-79132713,863575009,962481414,-86904278,-1196807640,88222648,-1460896271,1656722589,1597752566,584404506,-334191603,-938608336,1525114478,1927859566,1418421429,-1389076145,-81025710,933716712,-833399007,659052262,-263965590,-1401974874,1632690175,-1879773563,-1224301437,-325777098,829180553,-2141943994,-1144213644,-1583657929,1778551371,85379386,1342109829,-1762618344,-688478228,1378980835,-1495949720,-83609615,-1102416897,1241723002,-935707696,-718634168,-70327636,1969556909,1015139321,1948361776,1661025932,-1255173101,-245807999,860001495,-1056241371,1498704291,-1306161144,1330580739,16215887,539754191,-34001581,1537307571,-2069271852,1755201491,-138731897,2044679476,-127299614,-517123983,281692734,1775210000,47177467,647209846,-5245112,-619215221,1776292679,-1353462595,1078136934,1863976561,1608423837,637084580,32045876,-2036584601,-1262508884,502728048,-1603121623,123723141,1870846700,1636886485,-1775414438,-421763293,877046383,-459640578,555096679,-2046032890,1563299358,-1648635708,-655730039,1598448500,100221759,-297439871,-1293306462,-2087487619,480574905,-1223350159,109768891,-602556122,-973173264,-1001802710,-436054548,1291028730,1871991005,48602122,-2037593289,-1277473051,-1641573350,2029600755,702559970,2109000863,1108609724,1070250571,-920991816,1014372366,-1587680001,1846582416,-227702440,1683415129,-660155781,1153144831,1028510910,1492173268,-1915782301,339578484,256898617,-59000740,-1424323134,-1417155129,-2015591297,-766125769,374482754,778222401,214751631,-1270892526,-2128172987,-253436965,-1391325084,1225771195,776220067,-837136843,1782353393,2088158706,-1470008996,24709207,1474791719,-1227795032,-130079841,1699035022,-307982985,2055302194,1710888092,1139133388,1586691487,-824233724,553548056,103117970,799625702,-571768264,-672749563,-971728066,1906220985,362411717,-1701892650,-1119664216,-1281542360,-1958292435,-471662593,2109399004,-994187894,1841050249,261197982,803765211,1731992099,-1995969521,107284183,963173219,12922336,-1062939466,-952335562,2098617522,-1154401466,393956006,1053016410,-1940915006,1175294402,57303518,4675632,1834170550,251703172,-769276042,-193275407,-634719196,-1685687379,35497608,82043774,130279754,1050422360,-592682815,1916527931,1926847259,-1192742090,914779190,-1312021984,-773739366,133282163,1876329282,-1931297869,-66651801,-1036257820,-702121618,-886402615,-1473367052,1266262823,-351416771,1285104860,-275359895,1532797760,-655452394,-362080537,297978906,-1570623470,396898715,865731318,486542197,-1794328409,1188992619,176749923,1691828790,-619486081,-899155033,1418640259,1124216648,-1138143866,1969141661,-1191529408,2118404790,-458274778,1163800933,57593332,1251638364,1481877935,44400887,-2046598224,-1486928868,637600563,2071876471,-1118556200,488383847,-621752445,-670707378,-1820406899,1164434007,2138881939,-912302215,808581240,-515077471,-457917849,-1111146377,-1615101175,-938328330,1246203405,-52648065,-121168376,1546264294,-349405915,-1089473135,-1544806498,-790706510,1957751077,-1519935761,1722410603,1002845681,-444199994,-626757754,340088299,-33173962,-323057770,-835808594,995172118,-920450873,-1551476552,1126385825,1496396579,978942105,978729666,-1491615544,-1598385408,-1050094386,-688382360,-2140224568,-60883490,326792579,1491993977,1705887875,1802072344,2077042912,-629140329,-1121980594,2092141688,-822000030,-127039918,1785128858,-193171237,-2102709440,505759240,916792215,197946715,1444372292,660240617,-1815309958,20278150,613453826,638118205,520860879,-18836026,1417507650,1043783326,-1421892267,-1026847914,-1546315702,-996413376,-590987890,-1829911565,386201800,1800809950,488016798,-233734275,1034258368,-411397318,1916577484,1480670469,653439998,1092010930,100040591);
/*FRC*/Random.twister.import_mti(280); void (makeScript(14));
/*FRC*/count=214; tryItOut("\"use asm\"; mathy0 = (function(x, y) { \"use strict\"; return (Math.cosh(Math.acos(Math.atan2(Math.min((( + (y | 0)) | 0), x), x))) | 0); }); ");
/*FRC*/Random.twister.import_mti(356); void (makeScript(14));
/*FRC*/count=215; tryItOut("mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var imul = stdlib.Math.imul;\n  var atan2 = stdlib.Math.atan2;\n  var log = stdlib.Math.log;\n  var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    {\n      (Float64ArrayView[(-(/*FFI*/ff(((((/*FFI*/ff(((((0x9cc07477)) ^ ((0x8dcd5065)))), ((-1.9342813113834067e+25)), ((-4.835703278458517e+24)), ((262145.0)), ((1.0)), ((-9223372036854776000.0)), ((-4.835703278458517e+24)), ((32767.0)), ((1.125)), ((-8589934593.0)), ((0.001953125)), ((-3.022314549036573e+23)), ((-36028797018963970.0)), ((-134217729.0)))|0)-(!(0xf7d826f3)))|0)), ((~~(+(imul((0xf95ae075), (0xc48dced7))|0)))), ((d0)), ((d0)))|0)) >> 3]) = ((17592186044417.0));\n    }\n    {\n      i1 = (((((0x2d997940) != (((0x67256ef7)-(0xfb16356d)+(0xfd175ac2)) >> (((-72057594037927940.0) >= (32769.0))-((((0x196a5873)) | ((0xc3a02854)))))))) ^ ((((!(0xffffffff)) ? (+(0x1e190b90)) : (1.00390625)) != (d0))-(((((p={}, (p.z = x = false)())))>>>((0xf9dec822)))))));\n    }\n    d0 = (+/*FFI*/ff((((i1) ? (-1.015625) : (+(-1.0/0.0)))), ((((Float32ArrayView[2])) / ((+(1.0/0.0))))), ((((i1)+(0xe9da5321)-(0xffffffff)) ^ ((((0x8d4f3*(0xfbe57a6b))>>>((-0x8000000))))))), ((+atan2(((d0)), ((((+atan2(((281474976710657.0)), ((-1.2089258196146292e+24))))) * ((d0))))))), ((+log(((Float64ArrayView[(((-1.0625) <= (4097.0))-(i1)) >> 3]))))), ((+(((i1)) << ((!(-0x8000000)))))), ((((0xfd853198)-(0x6a425921)) | (-0x84e6a*(0xfc087f94)))), ((((0xd74e76e2)) ^ ((-0x8000000)))), ((+atan2(((1.1805916207174113e+21)), ((-1125899906842624.0)))))));\n    i1 = (0xb458e11a);\n    i1 = (i1);\n    d0 = (1.0);\n    return ((((~((0x954694c7))))-(0x84322f5d)))|0;\n  }\n  return f; })(this, {ff: XPCSafeJSObjectWrapper}, new ArrayBuffer(4096)); ");
/*FRC*/Random.twister.import_mta(-1149409293,1653792945,-1894278724,-200079351,803537656,-122547781,1127495887,-269084393,-235972883,228197944,-2049273787,-1763692910,-2034866867,1692054773,-370557632,-379168558,1736648007,-710353340,-509983852,-118875584,789980473,-2087371991,-850632256,1114551686,-1958887697,584083680,1284177668,-726364092,-2077687097,-155240192,987405745,1178735122,-849865781,-1220498528,1884733227,-1864517655,199678587,483858335,476940568,1811008355,-1034567388,365528503,-2125726425,-527311163,-1433437971,1204467178,448230225,1715877086,-771285154,411635947,1994371607,1265725667,1809170335,-1050907981,1471945759,-41946394,-2010414585,-334780843,-1616984806,768385020,467767604,1137128792,1651351847,-2144857524,469921771,481260703,-827845931,1412081131,1637648786,788675649,354266531,693656146,359660738,-1072042891,-1902479733,-286178716,1093244570,1404286143,388308807,-1584106131,1579412163,-1105477477,902490367,-845826061,-282557424,369367549,-676074841,576268719,2080557894,1550048360,-155690249,-824690012,-29703609,375936593,1921174816,764824934,-499328573,-988444729,1583188216,1285690404,912503089,-713015084,1150572498,2055487610,859585121,946584591,1710259374,-137080126,-1842435003,-1639287860,356646922,627148272,1663669341,-913668441,160950983,-1815005376,-299034307,1232276544,1350457266,-1344214387,-1949614878,-1166275124,-1975337126,-22161116,1809790940,604398151,-1158853030,-1475323485,188327134,457171821,-374302375,1068891463,873300423,1712997796,-1105385441,-1292863352,-443645025,632163741,1353109518,1775603815,-673294834,2016008108,138403003,2122878483,326303630,1938545603,1790384323,-492135478,-1323519356,-973986470,170707273,-1720472032,-642130999,1845791804,1896260361,-1233754931,-1791605714,-805064802,646492014,1836258335,-1567035373,-1376827006,532786335,-1889242532,1712809406,1492323917,2117684705,1389298909,689561155,549899339,929832463,-1915185196,-1467246927,1390857137,129886307,199482882,-692772181,-1003645789,-1406419318,-82317471,454688394,1237870504,-2145130990,1444018087,-491868212,1828654655,1973541499,757862005,1464228188,-479303443,1567935943,385001556,-1898674670,1622698626,-1767812856,1429065966,222850552,530782138,-880671362,-1574954,1399796324,-2110456173,-315268538,-386339560,-1372806616,-2119481578,-516128259,-1365756172,-1143706971,-2003235856,-2079512585,91720339,572201429,-469559497,-1577542344,-1372973381,-106961627,-2049232868,-950669770,-632855237,1468665992,-2048059017,684664160,-2023227382,1802651809,-1000368643,-1692791727,-1655681515,1054139168,1379250474,47144330,-831572375,1974465637,-48258271,-639196881,-1186690382,-1859516826,-1818871751,-794641254,-433033705,1088389917,-108992261,2137294486,-1866004319,1642874683,794642272,-1004248700,-1786574286,76716208,773758712,-1844915460,74141270,1330896881,1122490350,86640983,-1507406080,-1061342924,1013969363,-35060205,-1841813705,-1897447246,1629747495,-1087815210,1185878016,-1540217235,1171047491,1360398608,-2081919520,-136646612,959708868,-405925676,755302333,-95680631,-1911339558,642728308,848752970,1349750715,-232099664,2044769392,26170731,376664447,1692985156,1968422260,719275490,76036651,2066888238,-310861101,122599351,2125450317,1043903539,-1031207024,-1854086708,-185070066,-516558674,1161822950,-828478645,1258602713,2020482708,271334629,-1507656121,1334537229,-217078750,-1256000752,-16216619,1548236,788989298,-140266818,-1216137757,552142598,-146732447,-1143000216,781586827,372136542,-1974092515,-342081685,-1878311236,1592310005,1213175402,-979341144,-1790864975,-428331137,1642594836,-920852927,605114595,-1609293830,2051052816,641160576,1266991207,909801181,-1008991503,1083478626,45917479,-1141586215,-2074841551,930982006,732141576,1810429890,206620686,-607210578,-94727387,1083689247,-1369191247,1728659014,-327570345,-1540054154,-223647698,-753975273,-1207960813,1407325483,-1037591995,-901112276,-206542722,927970300,-2059749890,1553148473,-423551582,-1784760852,-1986981526,-1859105120,-2098561578,1961284726,-1092004475,683073508,-1076801079,1800769317,-644397115,-1284321670,-534824072,-773253991,53048598,-1796338339,-799466906,1103553468,-1556830929,-508782135,-544492149,-886059720,-11447086,-154099814,1112394377,-1070691805,678590936,1857515436,1114409517,1384221561,-54171668,1132054668,-1066944789,-808741993,1824556649,-383928799,-925500145,1501675592,-461924187,-1842736272,1711936590,-978132115,597427582,705315140,-1987996689,-737466805,590384063,1440272901,1595106315,-1289364757,-1793230298,271855506,-1371396248,-1298326392,-1635447731,2053740365,2101453474,652331269,-351366728,319935067,46866365,799354577,-2020458713,-422513648,-973236813,-293500931,164597008,1328680167,-724334331,-19281272,-1660220084,40411988,-582642582,1009871190,19108961,-691826719,-1172563322,1478456290,1405613489,-1242522592,1589857205,-96759753,735564179,2016885898,283513755,-973999407,398021416,-1991930311,-1444882007,-2033612203,-796834107,-189619161,-1519258539,-421047064,-922166685,346835895,1714806346,-1694616023,-1026254907,1107006684,-701682688,753458884,546418511,565813234,1919368234,1944268307,1936727265,617598058,1259353554,371909975,-792712598,-966654900,591512198,-2029271390,1660689205,-612717070,2123212694,695908609,-1490900635,-1808385315,78722216,414646947,-1786215106,762949101,-1402600490,804433404,-773750690,-416801724,-1026768757,1066272118,-492367809,627484552,1861354224,-1052253067,-1554163635,502015515,-1126942851,758911502,-1947835018,-1274860479,1755520298,-566742360,-2032932314,1175962378,114425778,-637248480,-621076424,-1642551669,910106069,1558834139,340714960,771235552,-95532333,738820425,1684186493,-133960208,491076432,-323321013,2130071135,-47625123,-488439261,206771496,1980237168,1833413824,129491728,-1061886198,1532273701,758743130,1467587321,122436559,578525430,1569019434,1312557815,-700278260,235288,1733492081,51785236,2091427708,1034650616,322219143,1044582634,549955597,263185526,1117059372,-963014841,1911480553,1294651517,768352735,116409545,-505322523,787651908,1386971477,816668196,98639215,892834200,-2089307261,-596143874,341154403,-1968579635,-1928623504,1741453586,-1414307416,-1547413969,-1995974001,1369998643,12567574,96382357,1190244299,-1195184664,861024021,-1382944667,-1655842190,490686100,335214605,919212570,350271704,295995960,1989108925,-836477578,-1535894665,62872747,-1567363038,-1590292200,-1282995814,1231080723,1435451360,-370370470,1293895996,-1607856800,-1267235558,628683828,-597325199,180294218,-1721108812,1417682125,-891149820,-933034089,-1732059547,-60789378,1648695916,1292341995,673372852,508264950,-641772837,22828671,-1317212882,1805671816,1225187123,-195065893,-1787826829,-372510507,-824530692,-1588899960,2040067581,217749388,739218666,-2097161633,-1220076664,1993530979,-823332060,1875614966,840058249,-626982980,-1312051607,-324407787,-150027942,-1298042199,-33973418,1090838603);
/*FRC*/Random.twister.import_mti(549); void (makeScript(14));
/*FRC*/count=216; tryItOut("\"use strict\"; ");
/*FRC*/Random.twister.import_mti(556); void (makeScript(14));
/*FRC*/count=217; tryItOut("mathy0 = (function(x, y) { return Math.imul(Math.fround(( ~ Math.fround((Math.imul(((((( + x) | 0) && (x | 0)) | 0) | 0), (Math.log10(-0x0ffffffff) | 0)) | 0)))), ( + ( - Math.atan2(y, x)))); }); testMathyFunction(mathy0, [-0x0ffffffff, 0x100000001, -0x080000001, Number.MAX_VALUE, -0x100000000, -0x080000000, -0x07fffffff, -0, Number.MIN_VALUE, 0x07fffffff, -Number.MAX_VALUE, 0/0, 1, Math.PI, 0x100000000, 0x080000001, -Number.MIN_VALUE, 0, -1/0, 0x080000000, 42, 0x0ffffffff, 0x100000001, 1/0]); ");
/*FRC*/Random.twister.import_mta(-874658311,763465114,1786816308,-2080790729,-2040450115,-1387626819,-236922785,1390068034,-741312198,-1949182097,-449695711,1758371569,1977673448,1318930925,166891211,-869733511,-1042612582,1675424657,2126385821,-517567342,525341292,-2139699984,-1530212496,1914169429,1487386976,1769436005,-24526553,633731892,-430665268,-972202669,-26960541,-2087333780,1518584241,937451691,729444781,-2065388032,-995832159,-1144629076,-231530789,-619614043,-130309225,-509971770,-106542042,163511928,1952188893,488015694,-1698446394,-1345714694,97353327,1456852467,432143611,1241857016,1890476005,-428149401,1485449017,1206077429,769258544,238351953,-2134154242,555226718,24262115,-1987575874,1920152844,-1528125127,-466676111,-1701612065,-1207052296,652517790,1581876373,1441030722,938340271,-1917044541,-604480048,88024680,167052964,1240363596,401851365,111936929,-1921794367,-290568419,328062380,-292263603,329541872,1483141108,65748095,1442404808,183035011,26173653,-862519797,-2026751444,161357730,659699081,1902232506,615334027,-1440804402,-2060792272,1885607498,-617748419,1324488504,1543592687,-1407989172,610134243,999546767,1519579599,1606831840,-1394566948,232076468,-1930031834,1533795382,1733893861,-385972181,-2070545480,-642820367,633382988,346923248,44351242,441436287,-719951996,1813759930,1236699993,724960150,677835629,2028015490,-1252295452,-799070759,810493815,-1703344393,1120987552,-1225991777,-262821287,-1997650805,1431104048,856602058,-514532959,1517163088,-1754835348,-160156183,996656256,-1818138618,187204362,1941639072,-545019986,1624602769,2019008302,-303592125,-2120278687,933562668,-1183892825,1275826153,-1900718802,1007978804,-264945580,1110824838,586961624,1581519431,1590605940,-492303358,-565191225,-931314750,603433342,-181144850,1609546783,1444592669,1941206729,-1328571796,-521815580,145612633,-1093242645,620373663,536044970,466816382,-558398582,-961427683,-1908999114,341140793,-992131785,893003768,-228473806,-415491132,-283177113,-2049826100,-1281951085,-1151302113,1691904006,110866330,-288942882,800373381,-1613452876,-1916309347,735534157,29771360,-1643924035,618408332,-1045263744,-1560940576,-1637422951,-206444893,1199839443,854878464,1100301190,-2040967584,-1356471304,1965039859,-429212614,729153027,-1601163502,-1558995807,1368221950,-1383631571,366250968,2063088158,-241317432,-1477202744,2096355958,1289904605,1384143301,876562029,-1387920321,-1679778124,1507282381,1096729560,-441697063,-283251184,465524181,159778952,696004001,-1767606370,-1799900055,77288719,1810303473,1036422364,1706981712,181215218,68892695,242779163,-1689945591,1527937964,-1922863508,-2099373787,-1937270855,-346714801,1983958400,1564729334,673476056,1953648673,1554784863,-1410922101,1561943604,-1753642100,-1378966002,807554942,-435755449,1208260754,1695839571,920034484,-2046162602,20059493,1503178421,1400992552,502292968,-562483993,888066374,-407689728,1337290056,1076398674,-625468845,-622508459,-2083071103,-1123840604,-901692340,-969657991,-797787450,1511990691,-907779204,-1233027745,-1258550931,1874916779,1697752771,-741727854,-492873851,-737245499,1646524803,1384965380,-1231726086,867036486,796885576,-71828134,-1490197734,261297528,1396160196,-329983521,-1638723210,-368472696,-626141557,-1734138652,-1564257242,1775463688,-1494007550,128317247,624253705,1018754169,1399095084,-1352498055,1475873795,288327448,-1230870626,744975667,1140413999,1279024290,1313599812,-1775937554,150737232,-908380263,-433173527,1233846155,988418734,-1558843111,726542326,-184922738,-1688902438,1415135617,395956785,1311430302,1617828279,-1509055819,1575599608,-523531773,772162045,-1665443516,1540986558,-1027337341,-617308845,2009210651,1449910415,-1725447902,1855956951,1634826978,-988163588,1622147829,552338081,-1409679669,1730756563,-1383015938,1213569476,-1404841069,-1667967122,-1958623729,-607143460,-1870819696,499384468,-863811365,-1946616793,852655496,1832395572,1907386225,-64781463,-1264770324,-1065983013,339334363,1232986097,1730724796,238386594,294080087,450249380,-1901799491,-904392901,2066161334,-2109262541,-1642652379,-206909728,276501021,-1929053027,151912233,-562301673,1336037565,698116469,-249692345,1199359737,135992783,-81124792,1992650292,1763681681,-420459075,1390442849,-533893583,-1446926460,-1697856812,199134202,-1333309452,-73607214,-1898563439,-602965432,1272366441,1102632673,-841778484,-1624512522,1312646933,248917468,1132460706,901571815,1185286454,-1481523996,1918650349,-1247774126,-1192265439,-1356461043,-130147117,-593711992,1708969066,1599929702,1517861207,-1931215929,-616539134,-13311113,129603253,52254506,-1323896063,1924021352,1710608315,-896247123,-2058007544,476338508,755473604,-1931672601,151101045,1941977258,1865910707,-666764597,918329623,-951494692,-1151028871,1199196146,276522261,-1175727439,-1478197765,160566761,-650652722,1189323867,1625714906,470017407,925856738,-783804898,-1619491378,-296537192,1544427394,2024897656,-1838741704,841836972,404807991,1011055380,681949936,-1645108413,-786508132,-161890832,-1079958935,1391409773,-492343671,756695845,1552803653,-1439418332,-1532262728,471818798,-1093836576,-921716264,-1526498471,-504423677,-584616198,-388993506,-1640599355,1895729423,1466088979,-104350594,-701118926,2029298746,524403808,36354562,-1492458351,-6936233,-264902740,536727148,1306834300,1161990806,2120538572,1593120734,-238840203,20062444,713646224,1741843970,-62337601,810386898,-925383127,381059925,-548722456,434921642,-142125804,-1843424016,-1993821857,-1522544388,-753253089,1998392243,-1533414560,1619369669,1995126616,-658722663,1863767083,-986304798,1185989171,453179070,-921035806,1854739452,-130562990,-1661461444,-921954888,1546382251,1330926292,1236967404,1748219004,-621342785,-1651973890,-900465139,772748358,-1908415287,276244869,-209862608,-1211200135,694639658,-1692143955,395950463,325432480,96684574,1450384137,796644518,-1468553630,-1124758609,1557716570,-984139653,1234961279,-1217451144,-1296538068,673511218,1504940808,-966500421,-1600487403,183365684,2084006228,1151811067,-2096903224,-811499543,218241789,-694567040,240505288,1966071643,-1045045055,-1504817349,1574993268,-1990006384,-1825370762,525291035,719875861,2006842640,-843315558,592946712,1929302307,-1580147273,1255774481,773255116,1853071851,990654994,2085369566,-1478457966,1082645720,235720978,-1148782123,1081310059,51947350,-2127268223,1298073624,-1790915562,1983916657,404087416,1506701081,390054895,-331971111,-291053471,-1832248895,-1560043204,203577044,1805400294,-42089701,888561493,-403738192,1540163664,-1272432252,168137600,1036799129,-1979289473,-57733605,-1515451473,1419929469,296978878,-1414800429,-232157189,-1967449529,581089569,-1433301428,1870021041,-1416657524,-1828609003,1868754519,-252213304,-896064367,-1148263435,1268807786,-1111835834,2084259201,814145007,-691230708,1329291130,861093277,810657220,-2115969174,-1288718489,1721837324,-220515018);
/*FRC*/Random.twister.import_mti(76); void (makeScript(14));
/*FRC*/count=218; tryItOut("v0 = a1.length;");
/*FRC*/Random.twister.import_mti(89); void (makeScript(14));
/*FRC*/count=219; tryItOut("mathy3 = (function(x, y) { return Math.log((( ! Math.fround(Math.cos(Math.fround((Math.pow(/*FARR*/[].some, ( ! Number.MAX_VALUE)) | 0))))) | 0)); }); testMathyFunction(mathy3, [0x0ffffffff, -0x080000000, Number.MIN_VALUE, -Number.MIN_VALUE, -0x080000001, Math.PI, -0x100000000, 1, 0x080000000, 0x100000001, 0x100000000, Number.MAX_VALUE, -Number.MAX_VALUE, -0x07fffffff, -1/0, -0x0ffffffff, 42, 0x07fffffff, 0/0, 1/0, 0, -0, 0x100000001, 0x080000001]); ");
/*FRC*/Random.twister.import_mti(209); void (makeScript(14));
/*FRC*/count=220; tryItOut("/*ADP-2*/Object.defineProperty(a0, 17, { configurable: ((1).call(null, ).window = (y)( /x/g , \"\\uDF59\")), enumerable: (x % 6 != 3), get: Promise.prototype.catch.bind(this.i1), set: (function mcc_() { var xgcezs = 0; return function() { ++xgcezs; if (xgcezs > 9) { dumpln('hit!'); try { v0 = this.b1.byteLength; } catch(e0) { } try { Object.preventExtensions(p1); } catch(e1) { } v1 = evaluate(\"\\\"use strict\\\"; mathy4 = (function(x, y) { return (mathy1(Math.log10(( ! (Math.acosh(y) > Math.imul(0x07fffffff, y)))), Math.fround(( - Math.fround(Math.hypot((y >>> 0), Math.fround((Math.fround(x) || Math.fround(y)))))))) ? Math.fround(( ! Math.tanh(1))) : ((x ? mathy0((Math.cos(x) | 0), ( ! ( + ( ~ (((y >>> 0) ? Math.fround(y) : y) >>> 0))))) : Math.abs(x)) <= Math.fround((((Math.atan2((Math.hypot((Math.atan(x) >>> 0), (y >>> 0)) >>> 0), ( ~ x)) >>> 0) >> ( ~ (x | 0))) >>> 0)))); }); testMathyFunction(mathy4, [-0x0ffffffff, -0x100000000, 0/0, -0x080000000, 1, 0x080000001, Number.MAX_VALUE, -0, -Number.MIN_VALUE, 0x07fffffff, 1/0, -0x080000001, 0, 0x080000000, Math.PI, 0x100000001, 0x100000001, -1/0, -Number.MAX_VALUE, -0x07fffffff, Number.MIN_VALUE, 42, 0x100000000, 0x0ffffffff]); \", ({ global: g0, fileName: 'evaluate.js', lineNumber: 42, newContext: (x % 4 == 1), isRunOnce: true, noScriptRval: true, catchTermination: true, saveFrameChain: false })); } else { dumpln('miss!'); try { Array.prototype.sort.call(a1, (function(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33, a34, a35, a36, a37, a38, a39, a40, a41, a42, a43, a44, a45, a46, a47, a48, a49, a50, a51, a52, a53, a54, a55, a56, a57, a58, a59, a60, a61, a62, a63, a64) { var r0 = a54 * 8; var r1 = a37 | 2; var r2 = a26 ^ a22; var r3 = a8 + a55; a39 = 0 + a60; var r4 = 2 % 1; var r5 = a25 % a3; var r6 = 1 & a53; var r7 = a45 / a17; var r8 = r6 & 8; var r9 = a53 - a51; var r10 = a4 & 3; var r11 = 9 / a5; print(r1); var r12 = 5 * a28; var r13 = a45 - r8; print(a51); print(a54); var r14 = 9 ^ 3; r10 = a30 ^ a49; var r15 = 5 + r11; var r16 = a40 ^ a4; var r17 = 2 - a57; var r18 = a25 % a1; var r19 = r9 ^ r3; r6 = 1 ^ r0; var r20 = 7 | 2; var r21 = r8 % r3; var r22 = r0 * 2; var r23 = 2 - a37; var r24 = r4 % a35; var r25 = r7 * 0; var r26 = a31 & x; print(a38); var r27 = a33 + r21; var r28 = 5 | a22; var r29 = 9 + a41; r10 = 7 - a8; var r30 = a40 * 7; print(a15); var r31 = 0 % 6; var r32 = a27 & 0; var r33 = a35 ^ a10; var r34 = a38 - 1; var r35 = r25 * a39; var r36 = a6 / r22; r11 = 7 % a25; var r37 = a38 * 6; var r38 = r25 / a28; var r39 = a45 & a22; var r40 = r16 * 8; var r41 = 4 % a30; a50 = 2 ^ r23; var r42 = 0 * a1; r38 = r22 % 8; var r43 = 9 - r6; var r44 = 9 ^ a10; var r45 = a29 / 7; a15 = a55 / 8; var r46 = a1 / a31; var r47 = a38 * r20; print(a2); var r48 = 3 % 6; a27 = 1 ^ 0; var r49 = a22 | 8; var r50 = 3 | r6; var r51 = r40 * 4; var r52 = 8 + 8; a42 = r23 + r33; var r53 = a54 % 9; var r54 = a1 & a46; a50 = a35 % a62; var r55 = r39 & a1; return a2; })); } catch(e0) { } try { i1.send(m1); } catch(e1) { } Array.prototype.pop.apply(a0, [a0]); } };})() });");
/*FRC*/Random.twister.import_mta(251124250,-1973005267,351231958,1836820868,-979981010,212200102,-188794909,1593214720,-2089605803,-536258958,150681658,886268778,612445606,-1677366598,-920500487,-1885357040,728750252,-1939864917,1211415390,215794904,-727195333,102417784,1107752013,960803369,-556735259,1032389831,-379974843,431060770,-640569717,-1622745808,1360192143,-163149922,-36396168,639680397,1187267434,751563491,2053935751,-971886436,1461105879,2006824173,212755239,519341997,102072372,-1415334484,-1803665434,2051889698,535170674,1761223112,-1886262137,-1528658146,1833078400,298266531,120118927,1096278627,1978625124,-67974681,-122537987,840778753,-702789624,1757581053,-1830956580,-238223774,-467232027,685337913,1806581145,-1359023605,-1761572161,635782957,-2129074279,1112787304,-900251815,1007753413,-1379773430,-1499976132,-2034198883,1800588449,1189237293,-1760632159,93621871,-55588092,1743014264,-1009997931,750244238,-1876236715,923841399,-2052019148,1667790773,-779672094,2002964179,1876792360,-1460235806,1937673151,1601466514,-447346622,1454394098,-1976597458,-1753355765,1932219710,839976572,-2023944073,-1102039748,1910805419,-518339029,1892030754,1742987566,-1106324542,63794678,-1299166320,126066530,73153579,-1776916319,1732176119,-644618171,-1472454727,-1569916734,1794987534,-1970392037,-370050016,-538274149,301880380,-944912677,-1341361693,-1223757504,-1229198633,139770381,-817846578,1302331259,1145375686,384272955,-1066997164,-270459014,-565139101,-1062492843,-270270430,867204570,1301798453,-874971311,-871885982,-2110986082,-1238086827,1021191584,356926069,536491334,-820185191,1042027187,-923344017,-579897360,229312330,-1504199614,1413141826,-426126793,2072615860,357810999,1892674547,2141729707,-1217571944,-1170398089,-776904080,-1099719364,1078578685,-1075679791,1568512251,-837874943,-361940766,1531168354,471558251,-1393487921,1861014386,709345866,1044142173,-1126325653,1910972564,-1987036092,-1539667875,442323776,-1387136876,696283048,682727976,-1905332282,1339470342,1635819857,-163097673,712069250,-1317256593,751363603,-704740670,160614802,1364371830,-148561670,234484240,1432987283,-1519400252,1871927011,-854990728,-647693092,-2143966978,-1529367383,-943708452,597253715,-286033526,1477344180,46084430,1797548344,-1599603166,-1280010878,252719856,-1185781494,265013005,-700752318,-1595780220,1006952721,1443648290,-2043864472,945022977,-1245890948,-768965339,-1967286703,1376435442,-1250665765,-2050277958,-1071969012,480613700,1410717661,-1635185757,311977026,1868061670,156482710,-90364854,1253770260,-624467642,466024394,1489946133,-1261326743,1868636943,-925269370,-1979964224,-725409341,-775918869,-351822802,-1545795217,1268953802,1207270647,1290196376,1614258118,181543112,-1725619945,1883769139,-467919687,-1504614060,1132486127,330185757,-1900787814,-2043941877,-1244831143,-1466562139,-944413017,510376027,924065405,-1887142045,302988110,491290228,1085915509,1321578244,-1699422841,464423691,-58805270,63576344,-1456723569,261332669,2014170476,1732853416,369305072,-1631914633,-1532630868,2062012898,-1717667435,1653556621,-589951780,-1166852578,-2066168698,1181778705,-1027892089,-1556346443,-326132060,-188116183,-1034128739,1607112158,230863443,1878118038,-1536688105,913586772,551867866,484474726,1865378703,975112574,2118131711,1421708696,-1233445150,646705321,1239410110,374613310,80754338,-2025548126,187866661,1604404724,-1216334729,1581398628,1753570499,111812218,604248084,1611652154,-367278956,29618387,1251139529,1838886889,714240142,1146807623,1968664122,-1905395253,-504181815,-590524477,-929319479,-1718507815,-1468487119,890645373,1518625872,-1216410609,-1555309168,-713613762,-554773736,-473915647,654153699,1311524944,1975468404,-586867313,-1171341122,-984034921,-859066300,1064463559,-1779599925,-1383266278,-18334177,-818862482,-251143868,1687769180,1321571048,503796979,1764246974,1591700314,803745219,613394108,-2009886961,262835666,1154183034,-1807192242,-799488922,242979297,-1270134837,144892507,-1635454163,-177884144,-919610488,1914275650,1180049667,732485871,1863388981,-782063580,-1261366374,937116367,-233598870,1996673033,-1045822201,1765536044,-636404995,1016523586,1820369637,-127068320,-832626118,1707805519,-962103559,1221845315,-1494469085,-1949116168,1437242115,1111915661,-934197822,-1581728070,1417357336,434894309,-740216763,612818045,-1989059518,-2051101559,-1947341966,17857620,1480546967,617111326,657473829,1345543965,1353059567,1469321405,666417344,1783038677,-276410047,-185903782,-23934885,-982994685,1865151192,6913647,1217145462,1317716336,250851971,-2009930403,-1228037073,1717768763,-1913776878,-1077755843,1556153273,388342803,1405125520,431739383,-1129588401,1335799880,-1434679665,-974130175,-1613488956,1875888726,-884343439,1906388654,695612098,328686,157268986,1331655502,-987762659,1263022544,2037814181,-1388548150,-255496985,478198435,1904278880,-2090449335,863698820,623457497,360512765,1948358871,-489757632,1681724835,1953334876,-1111026465,494668533,-1249757520,-2130758272,1559258365,1892012742,-1009587960,1957440596,-700395849,670476173,-323203968,-1297448206,-83071013,1823828342,1069486899,-1795766051,-423996069,-1745893326,-1769973465,-323055466,-1870745326,1223091152,-2014701057,727030650,1340394054,-1788945785,1223274671,1971001154,1040944550,515621298,-844510790,-1244589891,-154976970,-1761312246,1345168294,-16100085,1538308779,1991945409,-297613192,-751079898,-1048749488,-588596602,767449277,2036439145,1257726354,1394233809,576722719,2008773522,1045907740,-622809297,-581418178,-673131229,1113375652,-346430114,-120585758,1822932089,1349183075,-837868845,-1939412824,2062853788,-219533905,-590557464,-890162541,160687748,-2050401091,2058103046,-1999553341,-336239134,441192965,-1883145718,-1725611945,956162953,1720821870,2033858337,963095671,-1325224259,1494428738,1433612021,-384091870,1054887012,114342127,-1182496425,-705229974,-1263019995,-341178074,-511812235,419893704,-1911067317,1689605,590048070,561797045,-1733434443,-1631437056,-1287890449,1752110214,1919943481,-399088880,-719700747,-1447551331,-1326422110,1965375104,-1679807593,1385986699,373071519,1164515617,-2063226349,60049086,1521686594,1043084638,757163622,-310095785,-1764017596,334922193,-161471342,-524742250,1339656152,-2129733452,-1326099284,1602770221,952929794,-1840443404,-260648299,300114654,-1788216683,103026577,-2076204756,-1258683171,743764537,521278316,-255946167,-1951676037,-2046095782,-2095139139,-1436525714,-405150469,-1465515493,-857109809,1572804485,-747598340,391479111,1783341494,2070191137,-959254224,-292980862,416486152,-130969819,1333378633,1890130161,-10599383,309896489,947043368,-1191651074,-1287263986,-259046990,-319561775,-93606498,-1401277612,-893052415,1645158605,754059777,-662629825,1275200469,1373473458,1205304446,351380716,15475433,-363771950,-138674182,1465330902,-1501998701,-1036828313,1012194781,-715569652,-346902816,-1982951362,1672720915);
/*FRC*/Random.twister.import_mti(110); void (makeScript(14));
/*FRC*/count=221; tryItOut("this.zzz.zzz;");
/*FRC*/Random.twister.import_mti(120); void (makeScript(14));
/*FRC*/count=222; tryItOut("/*RXUB*/var r = new RegExp(\"\\\\1\", \"gym\"); var s = \"\"; print(uneval(r.exec(s))); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mti(173); void (makeScript(14));
/*FRC*/count=223; tryItOut("\"use strict\"; print(x);");
/*FRC*/Random.twister.import_mti(183); void (makeScript(14));
/*FRC*/count=224; tryItOut("");
/*FRC*/Random.twister.import_mti(190); void (makeScript(14));
/*FRC*/count=225; tryItOut("\"use asm\"; mathy2 = (function(x, y) { return ( + (( + (( + ( + (Math.sign(y) | 0))) | 0)) + ( + (((Math.max(Math.fround((x < (y ^ y))), (y * (Math.fround(((y >>> 0) > Math.fround(x))) >>> 0))) >>> 0) <= (Math.max((Math.atan2(x, Math.hypot(x, 42)) >>> 0), Math.min(( + ( ~ y)), 0x080000001)) >>> 0)) >>> 0)))); }); testMathyFunction(mathy2, [0, [0], (new Boolean(false)), '\\0', (new String('')), '/0/', true, NaN, '', (new Boolean(true)), 0.1, ({valueOf:function(){return 0;}}), undefined, /0/, '0', -0, null, [], objectEmulatingUndefined(), false, ({toString:function(){return '0';}}), (new Number(0)), (new Number(-0)), (function(){return 0;}), ({valueOf:function(){return '0';}}), 1]); ");
/*FRC*/Random.twister.import_mti(444); void (makeScript(14));
/*FRC*/count=226; tryItOut("\"use strict\"; s0 += s2;");
/*FRC*/Random.twister.import_mti(456); void (makeScript(14));
/*FRC*/count=227; tryItOut("mathy1 = (function(x, y) { \"use strict\"; \"use asm\"; return Math.fround((Math.fround(Math.ceil((mathy0(((y >>> 0) ? ((x !== y) | 0) : 1/0), Math.fround(Math.asinh(y))) >>> 0))) - Math.fround((Math.sign((Math.pow(((y / ( + Math.atanh(x))) >>> 0), Math.imul(( ! mathy0(x, Math.fround(x))), (((Math.cos(( + y)) | 0) * (((x & (y >>> 0)) >>> 0) | 0)) | 0))) | 0)) | 0)))); }); testMathyFunction(mathy1, [0/0, 0, 0x100000001, -0, 0x0ffffffff, -1/0, -0x100000000, 1/0, -0x080000001, Math.PI, 0x100000000, 0x080000000, -0x0ffffffff, -0x07fffffff, 0x07fffffff, 0x100000001, 42, -Number.MIN_VALUE, Number.MIN_VALUE, -Number.MAX_VALUE, Number.MAX_VALUE, -0x080000000, 1, 0x080000001]); ");
/*FRC*/Random.twister.import_mta(-1156850708,440725750,1713100845,1969178154,1642745235,-921687557,-2130898239,1817868079,-1902746782,-2129318626,1967276909,304736444,1183751979,-1290579245,1228696715,-578483957,703927717,41504660,-1954515074,211386495,533487877,-1355911446,-697669029,-1344597158,2070408179,-499448523,-425444066,1880069019,-797478308,-1639052338,-261439810,256605970,-479273509,593961563,-2043481516,-345929006,-434706349,-1177822364,-609158900,845409926,1723310062,529169081,1683040182,-916891206,1314673301,718943200,553774105,-354296245,-1329616945,312234723,-444161710,660327239,-1528870117,-1888124798,604955052,-1180577828,-1329348583,-388182772,-1715086347,-550623655,1594939580,128430381,2144240817,1473495496,-490561364,-315103565,1594678164,2134808136,-154784634,715355732,733916203,-2036360425,464188622,1568858734,-940290571,-174238833,131144456,-1825880249,1261236928,1308207386,-1504370009,-1678630531,617403208,876860498,-1780689904,-1198446429,-674641926,-1190564579,1096050389,-96894839,864852774,-288923111,-297681241,1189510596,2088131198,-1740561336,714079054,996709409,-316847242,1635734402,991581733,1960677620,-1350313550,1907176243,-195130177,-1187596519,1978636721,329984466,1428786201,509963303,-1872534984,1194027346,299528683,-1681436942,2095926659,428275311,240424726,2116863825,-1559605252,-1601027657,1322250788,-1029555977,-89610691,-1145879113,1587176518,-962534635,-1826608290,-882353792,1967152095,-1628719457,-926898166,-7480678,-831092410,-1943063161,192186336,1464780369,-2022026044,1477535111,1275459646,1584847573,-1333724509,780225814,640362662,1489274502,240097415,114863998,883261596,-81937103,-1090038188,66864985,-852186504,-427528252,982478513,-197078143,227161939,-2122368059,-304276693,1554876448,-1549840797,-1193954455,-627631420,1401644296,-470964683,2119656160,1634017400,1875453614,951053921,-1808975471,920897629,-655477561,1077878344,-1769664042,996353636,1556990846,-2084501793,1390688325,-1872270280,-1278381250,1270852410,-1227164901,1385532237,-560766662,129867698,1282569579,-2137056753,-1559199694,-2146478432,-142927182,457436813,1624043114,98736677,-2071283176,1574988829,-1436512418,-1366055939,-743409277,-1680761781,-2017615425,1204855860,-1822852621,321338766,232818868,-1465178129,-358636593,-1224255286,-262476972,612826823,-2023252875,-1699466301,-1526341478,133440400,-610820341,-1994176758,1258492300,-1211462093,-928522469,1776909456,1776540256,-1252105945,928688720,-399795407,1899043414,-1441208109,-1676315603,-587300077,-1922609547,1593647158,-564766234,925319253,737715144,-1070557697,-494261640,665323683,-1533947006,681862479,2113880924,1895671988,12684666,-623911724,593479246,165764215,1867449927,-308361496,748422593,-1746702400,1789707064,-1482735876,1290065327,1474752706,1186317450,-1467928425,-1585795799,567608518,736594195,-1965191145,105520814,483177519,1855992272,1179443893,-305470751,-1707904450,-1588582954,2134070478,852040969,-2014018927,-1705642624,-1073919330,-1200168849,596417551,1475721442,-1034368190,-670459663,2022229942,1550976232,2133217886,1492170198,1022841997,-1195426211,1698146564,1592769100,924909086,-325560919,-807010162,1404025170,284837021,-165637862,1086836655,1760051191,-1935998471,620009883,1201777445,-323838177,1135141803,1107517227,-652859032,-593958326,832502053,-504109920,-1569691192,276883025,1609234751,-1000995164,688696386,671201778,300150179,604893170,-525092956,-1526714982,-1980748425,348863829,21902872,1278581926,80803736,2014109905,-1405069990,-93215575,-1064159340,-1380788452,121026338,422554009,-1146939393,-1447675443,1433780623,-385065425,371893769,1873444270,819641674,1369561402,464189816,1198204653,-1143257059,-750212969,-2081876061,-1033525335,1320962445,-1366469619,2013312005,1456661636,-724212888,1193080294,2109464866,460709556,1627724493,2081963832,1498287653,889279834,-1811520664,1637894025,1281269449,-386960029,648164079,424616623,-456829784,-1727783687,-1555809357,-1418386448,499557797,362375672,1774654419,-1262202034,-390539197,1920484417,-311597553,195463276,-158248254,1689562156,69096216,1919281947,394822947,-995954563,-518441766,2060607505,-1294433569,1794045245,1414880412,-2093883932,1691604548,651796224,1558144103,-940691761,2118023247,1214470959,1923269275,1442223538,2021993153,-213708482,-756537499,1332367593,-478982667,681998548,2062535873,-1162688797,708825879,2015875147,557458437,612886482,1384031370,-248643303,668903294,-1985896731,1326552862,803878762,-63987654,-367868267,1435281356,-1341963420,-1051784585,-878082907,-86674431,553189130,-771547915,495900798,1635705594,1781952354,-242479045,-576045492,-1750802583,-1753679629,-1385497648,-936037319,759026470,-916653095,1602652699,1613682324,-933777443,808927519,804599700,1811393241,425431509,-1465276904,-298811854,-1867980435,1272816517,1092806191,584344952,-1943403482,1148184118,-792932834,-480779845,295228657,314469966,1012311168,1527845306,-890175452,1485088832,1581800233,225208702,1874895233,-1501057037,-1327893621,-596971795,730726834,-1257920746,2132038834,-1543483444,-2062575663,-519356207,-160517185,-1142985983,-1020883055,-758421703,-1368171511,-292775955,-1700252986,1261857123,143081624,1426099717,1105069310,188512175,2003008200,2033633404,-1341060381,-116711772,1524848244,1985568270,1222850065,1239950419,-1906977718,1654298024,1521785437,1617283094,-489995836,-1597537036,-400795227,-856303761,1903003273,-2074651150,-91365610,-819627883,-1327183793,-1754177054,-1567673768,718302647,935719374,-2085922394,1017591937,-477274198,-1393235235,720454335,430351972,1776219719,55464623,-1213473995,-1916102813,112205803,587521360,597027074,-1755490282,-2097270051,865478936,392579600,-1961469412,-1955166823,-576200431,487755014,1488304164,588522654,-1841579055,700767748,1893742492,-409537436,1554861964,1561398731,1561816836,1380107013,-1761741479,1341177955,-980806249,1100804816,1140271607,-346888897,1681320240,-843419241,-1406124224,990063584,1358199210,90081526,-1996968675,-647242333,1269950488,-1197835015,-663232743,1514214890,-192346596,1580693945,-891156301,1096260168,-1053718337,1028562137,-1523364843,2065342911,-1382639034,-199223176,1896914453,2096649499,79487959,1375442398,336711913,-1742391883,1394272148,-111823392,1054916934,-916351007,2022168671,245911250,572127521,1534767847,1956472536,-96073951,703900578,-274435411,-2091599566,924747212,1467208153,-1367175606,1138202495,1236831384,-92313971,1514841474,1011007273,-868994738,1235253521,1714328098,-491073507,-498183451,1082086701,1717984306,-576911208,-691881330,-838590825,2095199149,-1158096058,-1046160543,-89506589,-751183940,-1322313752,345379382,-48207154,1722682478,-344295848,313087460,-1155267669,-33289429,854511598,-625761569,-1261419298,1218419472,-881442417,-1217730022,1514932162,1981623181,1929246903,1782427797,-406813556,884453140,-1999053922,-1567465278,-2097226579,2106595538,9662481,227444539,1709009946,-866742780,1341868412);
/*FRC*/Random.twister.import_mti(96); void (makeScript(14));
/*FRC*/count=228; tryItOut("\"use strict\"; for (var p in g2) { /*RXUB*/var r = r2; var s = s1; print(r.test(s));  }");
/*FRC*/Random.twister.import_mta(-1140033182,-1914963017,-1290912272,-420740856,-1838509240,626628997,87510493,1388811901,-259402261,585538334,-1027772165,1083870027,-1602623812,798333551,-1438323676,-1400055561,1795868840,-196334716,49172140,21651252,-2131767418,1599569442,-1613185644,-913926656,1632225692,752129172,-2128498810,-529787149,2131772664,1472227531,743576912,-1310437401,1611827178,-316078312,-451402748,-1579260045,499583901,1326193150,-719588507,1999907265,1181827997,-780176800,892631084,-325519397,691780976,-761702551,1720279006,-1714173064,-1911635321,1068448215,-1520044803,769702561,-144493622,-1905418693,928966236,1953298373,192557620,1911165673,1938830370,-1904006001,1823857654,489724294,-389058699,-475383953,1105207183,-2129987033,-1523090974,1884651296,1574370226,-640194353,-610698838,1189678536,1503792127,-1010540967,1406604283,-1159490784,-897694456,332343150,1847583388,-1010170401,1520727083,821885964,1083535476,1787535902,663446858,-886872311,764436468,894915802,-713427438,-577693599,1424416453,554506009,-745015635,-1454748451,-1364221828,2140639248,-1283912959,-1255801827,1276678464,1728627815,-1768283481,1026600550,-126316766,-889651001,-958547460,1414833970,-2078342262,-1255380680,-1254171748,732190750,-188158785,320584439,1047891553,-266839026,517837300,-1940074990,2075734630,211266296,-1846269920,1148444044,711071605,-845660731,-1271847528,-1998862777,-420114727,344004708,950223812,-1310040523,8429257,730895462,-1169360678,648525427,-1662516245,-1360484657,-694601017,-838378507,1496333660,486660095,-423123937,-2078915208,-541586538,-897693200,1741925211,649396325,-618952538,1075041700,1343187035,28627603,303340480,1741541236,-1301037219,-117335202,102470922,-1529410871,874624891,465970482,524704261,-197180683,-1042380100,1018173628,2111070829,819680880,741431012,-907598372,151278097,1279184910,-342231992,-858711517,-1754901603,996490691,2145381939,-1476946925,127028765,2001486109,1932400079,1059926992,244672582,-883074089,-1045275091,-1174734367,-717826544,429156955,-2089601725,1433603222,405289224,640235890,-1727570620,921113980,1880695320,-39869953,-539470444,557464671,-617326280,-1297919348,1244157784,356820379,545021155,-1328446042,562764750,1560644849,-70242668,-336384186,121444192,1227553153,-1022790143,894420119,-1470779125,249629665,-430787437,191204056,2142584533,-201635425,1070436100,-185541557,-1884903451,516493021,-751736388,-1223676072,-747270474,261037445,-93957754,-241902492,-678331688,-84314515,-1167688705,-1557651937,1624270223,2123852183,-1742230957,169789392,-1750526924,1488332742,923889732,-932327515,1815623635,-923336271,579231139,-270885231,288712812,1031927896,-2126861933,-1668575408,1674209992,1627094856,-2128983528,287429074,-30374596,-1424181273,2081266791,311465216,3371083,832785407,-1607475006,491247442,-1555490396,-394351056,1620078627,-1770203947,503942728,755711733,-1115613709,-1702785437,565336360,-2026505718,36102974,-1964681686,-1308104407,-1900036795,-91902447,337124749,429165436,1434443435,-56601315,1494906609,-1247047277,159242270,-1158146522,-671211393,43476871,-319599419,556336176,1353573915,498805612,-1710251867,1257921124,-1963236566,603947947,-202314795,-700291692,1377241656,1291569215,-1187193211,956556653,-1984139946,504957445,-1676593153,-382821729,-1969140402,-1751003585,-278935617,-504406773,122766810,-1360834599,1535574790,30003351,1581660494,-1857416430,-2024484273,-476982663,1077046136,1284598861,635641478,1848485822,1001420121,-781765039,-1255084584,-1958186001,394102100,-1265470710,1464782221,1687806180,1562243172,-770109480,1634003162,-2098150710,1417007077,1339566330,-1689297381,-2020766257,2090703859,978707539,505512690,-1402026951,2051643283,996307937,1345728833,13445724,-559784693,1888862212,11042544,-39668908,-1218991027,-1303326322,-837384789,370606165,-1678304876,-1381282153,-1790580530,1625765803,2120780848,494200783,-728292211,-1056201017,-267784510,-464465971,-680821564,559685786,396870124,1019584468,1908203285,1323054128,2032613663,-1949032509,1652069437,1868268009,-456618605,606863402,1299511768,1898414353,392114486,-1026260814,1535080726,-1402200091,2049295893,2899041,1618833634,1956708596,85245361,1140735206,-536077838,435033985,-1804048663,826109931,-1173585990,-845231510,832711121,-1039302633,-714771384,1686661658,-2008154021,1303836274,-988607675,-383416076,1644975765,-560797238,-1101463080,-1694855792,741391756,976219070,1612350866,1622760104,1295631826,-752033723,1683176352,-748881307,941452233,1160153964,827645135,1239946718,863636454,464806057,681003125,322047683,952755590,1479674458,-1564213901,791375193,-1989334916,-601352548,-1918193493,252026815,-1125932406,626249425,-1654703150,1908577782,913408004,-235476670,1853183649,-5768118,1881483385,-1737082392,1072633628,-1932130465,-1187019849,150211058,-2073737336,591130071,-1760133417,574591800,915585059,-354710005,-1574031560,1001492175,-1082966628,20754963,-708593143,-1587020390,1882011296,821073278,548191601,-1354860876,-1595627404,-593349562,1926251113,-1525149024,1907014372,-400478512,1397625195,-1607610159,-948145401,106746238,-2106143494,-2052908846,-568993331,-342278435,-1564631119,493812263,497820315,-1489358284,1599147766,-503624986,-39860918,2085649128,-988009925,375757872,-1041154415,364543781,1904097951,-2047756786,-1877146423,740456368,-215295010,91763261,-1612567733,2009245518,471999665,1347277182,1125849446,1543199387,1779100121,-697146586,-834247366,-1861767475,-1278065158,1239716314,-884801084,-613754820,-706438404,1504480665,1363648225,-1045041287,930532566,-695196816,1621666060,-964931881,324899590,-413278002,-111235711,157741719,369626724,-1618702933,-1773557641,2099258237,1836500264,-542492729,-943163429,-1040029937,404334397,-2125675189,180920159,-404043120,-1449575361,-1298497411,1493650370,416745277,1766923985,1418886571,-2128534429,-1079877122,37916057,698120094,-1105438589,140388078,-859076894,-1355878758,-515992062,-582578903,-1188285885,1077668490,-345495267,-830264822,-1136149340,-1888194858,2103148524,-1425788462,-734413266,-287393523,-1556734377,-695408975,916254680,2007999993,-119484682,-1242222544,-391335256,1679151,-1351596256,-274873512,-1353724330,2007822648,-1866195255,624555824,-2032531250,-1250071119,127470901,1453723972,-1004525144,988204444,1502150683,-475137636,478828551,-1883449038,1301824179,692470183,-1159067214,1839633326,1144746471,-631271511,1884402958,1405012934,-418267552,231826069,-683178276,2134811669,-915162825,-292496475,267825613,1601330009,633170295,-2027059573,1823323850,2131032478,-1769907066,9773885,1303440372,367227436,996968458,701432913,-1316780411,1858224698,-449268457,-21006561,-433682133,956962581,-1057988284,1602002910,665973102,1556056554,1113285260,-111254264,-1824830734,444216126,1636344575,37907351,-1739171939,-787932793,901864059,1345969874,863959579,1548878738,1995078582,1357045912,-122048824,-643521178,-2063814367);
/*FRC*/Random.twister.import_mti(256); void (makeScript(14));
/*FRC*/count=229; tryItOut("mathy2 = (function(x, y) { \"use strict\"; return ( + (( + ( + Math.imul(Math.atanh(Math.tanh(((Math.pow(-0x100000000, Math.fround(y)) >>> 0) | 0))), ( + Math.fround(Math.atan2(Math.fround(y), Math.sign((x ** -Number.MIN_VALUE)))))))) - ( + mathy1(( + (( + (mathy1((( - ( + Math.asinh(( - Number.MIN_VALUE)))) | 0), (-0x080000001 | 0)) | 0)) ** (( + (( + Math.hypot((x ** 42), (( ~ (x | 0)) | 0))) === Math.fround((((x >>> 0) ? (Math.max((Math.pow((y | 0), x) | 0), (Math.imul(( + y), (y | 0)) | 0)) >>> 0) : (y >>> 0)) >>> 0)))) | 0))), ((Math.atanh(( ~ x)) << ( ~ Math.acos(( + Math.round(( + y)))))) >>> 0))))); }); testMathyFunction(mathy2, /*MARR*/[undefined, function(){}, function(){}, function(){}, undefined, function(){}, undefined, function(){}, function(){}, undefined, function(){}, function(){}, undefined, undefined, function(){}, function(){}, function(){}, function(){}, function(){}, undefined, function(){}, undefined, function(){}, undefined, undefined, function(){}, function(){}, function(){}, function(){}, undefined, undefined, undefined, function(){}, function(){}, undefined, function(){}, undefined, function(){}, function(){}, function(){}, undefined, undefined, function(){}, undefined, function(){}, undefined, undefined, function(){}, function(){}, undefined, function(){}, undefined, undefined, function(){}, function(){}, undefined, undefined, function(){}, function(){}, undefined, undefined, undefined, function(){}, function(){}, function(){}, function(){}, undefined, function(){}, function(){}, undefined, function(){}, function(){}, function(){}, function(){}, function(){}, undefined, function(){}, function(){}, function(){}, undefined, undefined, undefined, function(){}, undefined, undefined, function(){}, undefined, function(){}, function(){}, undefined, undefined, function(){}, undefined, undefined, undefined, function(){}, undefined, function(){}, function(){}, function(){}, undefined, undefined, function(){}, undefined, undefined, function(){}, undefined, function(){}, function(){}, undefined, function(){}, function(){}, undefined, function(){}, function(){}, undefined, undefined, undefined, function(){}, undefined, function(){}, function(){}, undefined, function(){}, function(){}, function(){}, function(){}, undefined, function(){}, function(){}, function(){}, undefined, function(){}, function(){}, undefined, undefined, undefined, undefined, function(){}, function(){}, undefined, undefined, function(){}, undefined, function(){}, undefined, function(){}, function(){}]); ");
/*FRC*/Random.twister.import_mta(-204083064,1672017222,325879062,697045772,-2036483633,1220540020,-734511039,1913692239,1768826438,-42957874,-938399307,1507124864,-38242802,244717243,-405170991,1723296407,49279044,423963916,-1570319639,794593946,-423192723,-742111146,-378930261,2141289329,-1433802560,633542930,1952546932,239777674,-2070346562,-404757526,-275791475,-1884373057,1186049013,-352703510,-167209862,1530737230,-1632006328,-1150205793,1727521719,-1727267642,-1079392281,2024124206,-1713999087,-1102688077,308950099,1224024352,-1281697760,-550280305,320640573,719173435,-1076503761,188812443,-23936333,-191822438,64643913,-652268196,-751961150,-1664087887,-270295940,-1636056277,1574329768,222484404,799135855,-6001050,469434678,-684153821,-1505794467,-982367484,392076041,1889683186,2128127103,316901140,-407138043,286815172,-521270054,426727532,-1929660020,560622974,2031914145,-505350673,1761625241,-1514467788,-1520904762,1072153877,1337186437,1404050887,-2058780378,1568562247,-337504162,-1556738365,-896196043,-348647150,-1482195096,-2128235752,-1316115150,296983442,1883769643,803789178,1641009960,1227848112,-1954755121,1703987720,-1389121955,-1562692729,1566351183,-727735627,977182096,-1662835943,1183825673,1144071758,702267429,-1890286216,772022371,-789953199,-1872244866,16562766,1799163988,-682613801,-1510893283,1312545898,-1478686464,-615229561,-676475741,228113699,-472272883,-1362419297,-654650361,-1046480762,2090423522,1236533702,1266306949,685691092,-868323807,-606578142,1075266982,1690712128,1531174338,88443978,-1556761410,-1298495262,-602728773,-1428516872,1631197680,-485560743,-598845834,1048275492,-460740998,-1576109006,-404792940,1861211772,-541666312,-1786696652,-1107305885,-1263022437,-184296337,593407469,1270588173,1626790513,-249017474,1216299697,-1222482578,1639209546,-1271428057,-122458393,-1597677367,-2135844971,-117886725,-2078439339,10094486,-1677620646,-746947891,963407437,-1104885674,790848266,1376705371,772601220,105649286,-1804137369,-2117157432,-1329273695,-1517080324,-888151624,-1918355413,29720081,-1001186715,1941768887,-1845480567,-694400343,-1473130003,815690131,-332871801,-1430803945,905715596,437310002,86752916,-1985757805,1440229671,1160183755,-1931018579,338105115,-998633178,761055626,1487239432,1177779392,629791679,-1272414385,512250987,-178424504,1644377090,-93477281,-491882852,-1497849206,810259464,-996028397,-1209756338,735764297,-1008844751,-1196171556,-351378330,1829434897,1270125609,932888318,-1835110305,-1797689928,807735576,818161534,582989109,1724814718,648517294,414715660,1171718383,-1659567635,-176053895,992799607,-815558584,-1591363512,1402305625,-2138333821,1192499884,1680708120,1087623443,-1774411339,1456133427,40031560,1372964325,-1652649865,-472227402,29944193,-628358442,1886974801,-25661871,-1164044127,1801515707,1707412646,2054545554,1842973808,1978218847,-1601501527,2330650,-1048997421,1051876356,-1496205074,1487392587,-542441769,-1107039350,-1493391364,1197249211,1541644336,-1415507657,-1793313105,233901881,-1254969854,-1116689785,810000438,-1685221504,241212718,-668330021,1737938995,-1540351450,-1375321941,1171211848,218625791,1292914129,-1236216080,-1716668124,655682934,1049298462,922185570,1682526888,-1865118545,2050142715,-562936993,-739863928,1882936192,1383229476,-87988583,905109589,-1409223745,-62598124,239374175,1387319593,1855396841,1957485039,353886488,239694297,1907983656,994192407,-2118115974,-979223672,437834559,756435542,2024082266,-681535564,888318673,132524715,927895926,-393687959,-790881360,429377291,-1779724518,-1347728598,-1736365346,1627516927,1898998350,-589656489,1176749909,-578787742,1370668023,-2099857618,689040555,-1379142914,-765244020,817093027,-1098443585,770739046,1189685799,-228018156,1368465447,-1895777792,282425801,306783144,-917526599,-16824252,-1187110751,-626282723,1781304969,77146125,1319510538,-463466081,1075777435,-1092902982,441766833,-691022082,869925694,-1440069916,741819567,1114104112,1427669103,-1995960447,-347048903,2118350450,-587859304,-1930247551,-169431575,-1373013412,-249318229,-1809779698,2106091244,-1586161821,1079007657,-1900981550,1399908699,-631162383,2107050133,-1842297789,-577775122,-177391493,-28717685,-1517870899,1744855420,662916400,882236229,1045991984,762627640,-1590723002,1227242410,583923861,-983150493,-56890696,-756222178,1127373722,-732453709,1757350912,-676314082,-617543495,1307001182,-904276836,-831680750,157363332,-1904712446,163545571,-493872218,1545955412,-1226122901,1366362460,-1554122626,828783129,-2123941357,-760028085,427473056,-1937347852,1422044635,1876555892,-1105643868,1593115855,1722603422,875095469,-2109944631,1969898141,-344563572,73466743,-829757149,-2029248390,758735836,1579040713,-1273132532,-99284844,-72749309,-867766935,1419666940,432338766,-1159042865,1908346443,1525829778,-143665524,-1432980938,1760438763,-1280196864,620318276,-1674648622,-1783183473,1932845814,878920071,440969703,190493447,-1145202005,354184513,1405935254,-1094430567,-2063512827,-995411582,1584663355,-794511723,808696933,505137164,313983430,-401098906,-859219880,1738770609,-1229993530,974621962,-1917707231,1462232177,-1085189144,1222500996,-1867786400,-202165366,1397671945,-107731250,1714909248,2091726829,805173393,653800885,-1461145682,-1204238826,156863899,-774938943,-58673834,1805134362,1030867299,1548771657,-1581168301,-81778422,235432696,932357166,671447205,-520872608,-1975041642,182222045,1939799768,-1198928822,1871219763,-15366911,598661718,2118262994,-971735767,-1147951,-131073750,77189549,77786596,1811727965,-1329226184,2117388712,1646035055,775426480,-1751193023,1268885172,-1737191460,100921805,-606422053,1685893652,2117408837,296718306,-2007585502,-870587312,-1673473552,1171320814,-476290175,35568687,-535562304,-1107329728,-1841850171,-1774009480,-1601055980,27315208,1325750814,-1747145295,224518614,-1229001222,1617093152,-1827570298,1248223918,1474053721,1825921882,-245410181,839503299,-544834879,1292615443,-736514293,-1340013903,1792111747,1079778752,1239625344,-49621888,-1161771865,-135255214,1568157934,1575323821,-1009820366,-1008824868,1296043317,-2044717489,846568961,75766058,1175099495,-182954366,2125859712,-702707102,1124725303,1647256123,-1108733736,-297366175,-1674765214,-650399562,1937847539,-764158770,-1525069541,597679974,503462757,-115268387,1190834471,1459633937,2002356816,1917477338,-172807642,1346856596,943183132,-1761281447,702286977,154130283,410632272,1287496753,-1853478677,-1406714819,-1947506602,1069126386,1619423325,-455277080,-1432149507,-1284456882,-22674518,2003524381,-671366831,-1630450408,1614684905,748299668,-1046926796,-103779377,-119274737,1010184865,-1752367905,1472036630,-34084532,-1697417324,-309250756,-1948720072,1227739194,455901108,2097708604,1936034735,-2068306024,956758866,-603610949,-750664567,109989249,-729348655,1381710540,1830509139,-282945176,1087274060,-336817286,-1209837046,-1768838895,-1275908904);
/*FRC*/Random.twister.import_mti(337); void (makeScript(14));
/*FRC*/count=230; tryItOut("print(x);var y = -11;");
/*FRC*/Random.twister.import_mti(377); void (makeScript(14));
/*FRC*/count=231; tryItOut("/*infloop*/for((/*MARR*/[new String('q'), true, arguments, a, this, this, new String('q'), true, new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), new String('q'), a, arguments, this, a, this, arguments, this, new String('q'), a, a, new String('q'), a, this, this, a, a, arguments, arguments, new String('q'), a, a, true, arguments, a, true, new String('q')].some(new RegExp(\"[^\\\\s\\\\\\u001d\\\\S\\\\v-\\\\u00CA]+?\", \"\")))(new XPCNativeWrapper(window)) in ( '' )) return;");
/*FRC*/Random.twister.import_mta(-1078331983,14118415,-1698796412,-1812337189,-2033196900,-281937749,1458190739,1707481727,-1645889127,-865722852,-309507757,-328278196,-952564958,643960899,-1097750449,1856897110,-1296326622,-691085980,822252243,-1639768380,-337712926,-1730801769,229535211,287700759,-1670683222,-1120083904,706492441,1548926358,-940409863,349853837,628490243,907446348,1642295305,1656798579,-680201752,2128857583,-1639825406,488413064,-1508668331,-1372423481,-807180137,-1323645165,1510308692,1166765433,1464758886,766389655,-321279745,-606320442,937161193,-1812058103,-1889212412,411402527,-11941432,474921209,1929092501,-1187886220,-413988638,1776944690,-998092660,-2030265934,-899140734,-377760679,-1988231435,2011827601,1059520239,-1657739392,-571968918,-1703272481,-1459948519,1436012906,1514081155,1396792979,784026018,1289367936,1665815719,545646963,-128083695,499003545,-1600043085,1011338322,-295882164,959725817,-74802378,-494846508,286390127,-108729959,-104860668,40085505,-526987493,481705125,-2406113,1494205289,856434516,-531686701,659636730,1580806219,878360299,1319487814,-494681615,1666756073,-1964532690,-1962363300,-859323144,-1671808731,58916797,590055264,-177888964,-730366229,-1249478298,-968558983,-1612788384,-938913501,1789340076,743396779,1045120354,607193032,989203478,132880385,-77774907,1446931310,390002845,-255792479,1071061390,354096537,1549449429,1664555428,-1067569321,2146199161,1809799933,728316588,420383164,162097717,227462961,-216342699,2013625998,2055055544,1853332863,-523924444,1799653810,679952707,409401583,-1534811149,414106946,83255224,526493906,2074607037,-1408374119,-919639955,-2138587028,1923307794,388308663,70779100,9296462,-1362537507,1317531750,-1902051496,-1376271155,2124332504,137316101,1697069367,-1496864953,-1072003845,-2021775977,1954549859,924251764,2035889344,37602371,869021496,-596436509,1437385890,-434022241,17850190,-1364159144,-151688107,1074152915,1954512915,-512141514,-1252756286,-1859279845,1795050850,-226293115,-167731125,-792340292,-1554448963,-1402236491,26116592,1583458742,1190867071,-16901404,-811949247,680419388,-262328773,-1099376809,-63709984,-357419765,606037277,625639970,-12194464,-8315706,-475782489,-1350691062,-726220917,523209921,473997791,-727584658,733705126,-1602368208,-1668239555,803637192,947579764,1215311601,623752248,-935472263,-548770497,-169663447,1692545148,-1894241305,1930002354,990563846,-292962297,1993737516,2137330072,178440848,-1275192330,-1350481483,516342612,-2137758105,-1393934618,210463113,559766572,75226610,1694990591,732904911,1901851063,894748251,1831319402,1428905986,-1912126459,-562555328,2119719796,-1267404730,1291612681,1872718578,56226319,1098458496,1089446408,1202707163,-963057271,2044905184,-1415910884,-714978408,1892920360,-1881250285,388417616,1790868398,1678661513,-1651021050,1701300238,-1885147014,1052401163,1906860292,573548178,-935459237,-1052527161,1315095670,1555396055,-2084328737,1127960787,1654418587,-2047521769,1595030136,-1862363142,1972239756,-518033601,-1662253487,-2100933925,2034101455,-1652759273,-695332459,-1649513748,-2084179111,-847574110,-1575346164,-1417292688,979398793,-607661181,-1652085245,-129197354,2014913233,1835800279,-1042572063,1456846763,-450015680,-187611528,1041374284,1795896556,-627107734,605905289,-1922323997,-1628728855,-493286229,-1072396145,705567231,1718718754,627241485,604561767,1017627375,-1936969848,-315582023,-318652899,-556550023,983678133,989137966,1665421710,432332986,1306139120,1960325501,706222661,1408894180,1691976385,-1408266308,-824637734,1721828716,-2093006561,-1262708173,-867962176,-1836498739,-1953708103,1183379670,-635290233,-177496093,-1026317389,-1520386592,-1549933425,1846237991,-1934482068,931452597,-1738633120,426466584,1669576824,-1847576920,1093984576,-509171897,-827626681,-336236646,1612258076,1903000171,-1140440947,164093363,549115475,-1053176674,2000507818,987371579,-716501979,-1325435663,1257024101,-1729246652,-2071839069,-452337418,1924101128,-580902375,-1485525231,-1719251309,962797649,22865582,559215541,1447260725,-1848327295,1571045368,536243243,-196699190,-1420196619,-1671116504,1008547943,-1477933926,1664740494,-1802563832,-588366322,1882730594,323779798,764087968,1370208638,-1743086524,-1117750290,437100557,-2143220848,-560160295,-662023653,-1452474508,-421066662,-945589531,1128886388,1384191695,-156372800,1430230935,-109055059,848954155,-1567502627,103574991,1936188790,-943890042,773124601,-167617415,-1983786088,-1527084803,1352010184,-213557068,47368319,-1161954277,-695800378,1345395599,-1685623409,511842978,-1475110130,1974295472,2112018669,1468823034,-885788243,-974774659,1698752051,1115560110,-1456200394,1921242355,-1823658727,-448059290,-2104780660,125330937,1347801441,-1090941579,332265318,-1740823193,896976788,113400815,-1681250698,-908356058,-1030151198,564278516,437029331,725272017,468582497,-1496310716,1994011701,-254880688,331203259,-136379848,-393459591,-948981940,-256074305,-1527970619,1761039953,1171041972,517710368,-539513415,-1885765023,-1515078139,947958330,1194979328,-291329675,2119197724,1990523722,-292925576,-942701380,1921982110,826642752,-2041401419,-1484681339,-1896378449,-2000755935,1072155177,-926858789,-1917862248,-888303739,1419507167,464763344,456957851,-938616481,-707088201,-1599185259,-144443322,956229224,-1630610394,388919083,587883253,-2040645359,-395459453,-1076298038,2073689792,-1378947147,467720702,-730144642,797917953,-387926487,224532732,-1125991754,-113647976,-2073828948,-102584190,-2074713487,-1833967352,-646238595,-109207517,-470392187,717273651,1847714839,263921896,-1285635377,-1852560126,1506589536,2040456848,-802916090,228059277,850900856,-538147566,-74785749,-1234374098,452023590,-978675768,433877545,1725713483,-1143803680,616708805,1966308848,994303334,-1706066322,60804230,529354724,-665100030,-104433066,-1339688545,596027196,54698101,-1752931842,308432074,-1660888819,1283488182,1543181318,311218507,1842863907,-71725774,-694876496,1131044718,1026914298,1935635376,-1330584591,1373638636,1028005011,-752617912,-1914167003,-1355399116,-1727417559,422050535,1955522028,-838730155,679787553,-1325339400,970192150,-248710986,233297447,1791787633,-1147816564,1303778016,538826006,-533725897,-682820589,-1318617593,-756070070,843864011,132750277,-458439695,466833163,2082718736,-799429966,1497115633,1270148984,-735710265,366753597,-1305470048,215972353,-358479680,921106451,1780313826,557109339,-2047376220,-585597329,-614533158,1279420423,1086453500,288948792,-20123594,-422228154,-606192384,-1280723239,1849447737,-1084959842,-2019962549,2104011490,-99162861,289155730,1816800634,246024088,1472432108,-1726779332,777017156,-498625130,-1727902702,347003007,517620492,319762878,-250491786,-1706651768,-505215417,-1392000881,1894340875,80951238,1807835180,-1069456878,1231164844,-265142703,590237266,1735876466,-1386455611,-2021657664,-1601804863,-196196052);
/*FRC*/Random.twister.import_mti(58); void (makeScript(14));
/*FRC*/count=232; tryItOut("\"use strict\"; mathy4 = (function(x, y) { return ( + (( + ( ! x)) == Math.fround(( - ((x ^ mathy1(0, (y >>> 0))) ? (( ! mathy1(0x100000001, ( ! 0))) >>> 0) : x))))); }); testMathyFunction(mathy4, [1, 0x080000001, Number.MIN_VALUE, -Number.MAX_VALUE, 0x100000000, 0x0ffffffff, 0x100000001, -1/0, -0x0ffffffff, Number.MAX_VALUE, -0x080000000, 0/0, -0, 1/0, 0x080000000, Math.PI, 0x100000001, 42, 0x07fffffff, -Number.MIN_VALUE, -0x07fffffff, 0, -0x080000001, -0x100000000]); ");
/*FRC*/Random.twister.import_mti(231); void (makeScript(14));
/*FRC*/count=233; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return ( + ( + (( + mathy0(Math.fround((y == (Math.hypot(x, x) | 0))), -0x0ffffffff)) & ( + Math.tanh((Math.atan2(y, Math.min(Math.fround(Math.cos(( ~ x))), ( ~ y))) | 0)))))); }); testMathyFunction(mathy5, /*MARR*/[undefined, undefined, x, x, objectEmulatingUndefined(), new Number(1), new Number(1), objectEmulatingUndefined(), undefined, undefined, x, x, x, objectEmulatingUndefined(), new Number(1), x, new Number(1), x, objectEmulatingUndefined(), x, undefined, objectEmulatingUndefined(), new Number(1), new Number(1), x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, x, new Number(1), x, x, new Number(1), objectEmulatingUndefined(), new Number(1), undefined, x, objectEmulatingUndefined(), undefined, new Number(1), new Number(1), objectEmulatingUndefined(), new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), new Number(1), x, new Number(1), undefined, new Number(1), new Number(1), objectEmulatingUndefined(), undefined, x, new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), undefined, new Number(1), undefined, undefined, x, objectEmulatingUndefined(), undefined, new Number(1), new Number(1), x, objectEmulatingUndefined(), undefined, x, objectEmulatingUndefined(), undefined, x, objectEmulatingUndefined(), x, x, x, x, x, x, x, x, x, new Number(1), new Number(1), x, x, new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), undefined, x, x, objectEmulatingUndefined(), new Number(1), x, objectEmulatingUndefined(), undefined, new Number(1), undefined, new Number(1), objectEmulatingUndefined(), undefined, objectEmulatingUndefined(), new Number(1), undefined, objectEmulatingUndefined(), new Number(1), x, objectEmulatingUndefined(), undefined, x, new Number(1), undefined, x, undefined, new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), x, x, objectEmulatingUndefined(), undefined, undefined, undefined, undefined, undefined, new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), undefined, undefined, x, objectEmulatingUndefined(), x, undefined, undefined, x, new Number(1), x, undefined, undefined, objectEmulatingUndefined(), new Number(1), undefined, objectEmulatingUndefined(), objectEmulatingUndefined(), undefined, new Number(1), new Number(1), objectEmulatingUndefined(), undefined, undefined, new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), x, undefined]); ");
/*FRC*/Random.twister.import_mta(2079508741,192109453,-1550605500,-2066050616,-1065042573,75493487,573206136,855696622,916784838,478901442,1961207769,-652116598,482301240,-697204873,-321884764,132106931,-1015745092,-1272667642,1925404559,576913803,508577465,439982167,-186995353,1280027259,-139832042,-1098549216,-1117490222,1606067525,1374553109,-1932798681,1264489799,385910190,-1146808064,-1282974317,-753953860,165903342,-716935758,1138417875,210284126,-547671968,-611755387,1178105979,-1608317438,-1921571465,-117075423,1605021936,2119427800,893012499,2021384354,-2132944050,636939759,-1689657311,-1076315406,-440807263,37914522,-1401017912,-76775048,-2014276029,2080308963,571337153,51901318,-1545196615,-1806086819,1745977552,-916981892,477833131,-445632912,1260873062,-850761936,987806385,941030583,683306744,-290694885,620897300,1112001507,-239236728,-865857213,-1838904163,-1775353994,-487315055,1698483766,-895044131,1237219458,1330550606,-1293636808,1607833847,1583832526,1093538769,1753960519,-579016048,1480703710,40290900,2102779336,2082989052,1593089747,-1907887274,-1682940395,1366331071,1824982919,-57573739,-1043187361,-187956364,241074736,565473058,-228351691,275933869,-1659704387,1433934939,1232341292,-562345038,-1530879186,214790726,1594581772,313674300,548353180,-1030257895,1635229940,315284755,1911447697,1463638873,-1196116058,959955084,676842227,-1813522832,1151922466,-2107344366,2092039565,-1351036633,171561650,-723769892,1679458195,803876568,-2096924599,2134908722,-1430604382,-1135529302,-1386078433,958545263,-693107592,-2018042397,-425902587,-1209077869,-722589332,1289390855,-1712440837,-61786589,1294984984,295956442,1142403098,1102694860,-1879826101,-1351570157,392538648,2120483540,1943968320,32681196,1472979661,740294565,-1840719534,2068290506,-186506107,-1334108059,1490881890,1446865370,481382262,2017046473,-827660401,106316329,-1204212965,-1739306149,1197585506,-202077859,-106870274,-2060954074,1936644708,1770029162,287233305,96178453,1621299596,309931581,-287859973,-2101287778,-29215214,-1524623641,1643352227,-1429778305,1735218831,-467535192,-1299740296,344377058,-1340135942,955788098,-1731419850,932157274,2024715400,2090406952,-2131352274,-128360664,-1783493778,-1381372266,-495991416,-1160422459,-1719474264,2106818523,-858863121,1047441884,889680599,-823062538,143896005,-1544887125,26864546,1275565333,1827342792,35267724,-545859407,-294781913,2102888479,1984169775,1846358734,839456570,-813648227,645868314,2122863241,1670662592,-937651606,969205293,-1573169569,-1530933986,467531163,-1582412355,793895272,1281069899,-1512392597,-1584874102,93536091,472954567,-2105514465,467250425,-1509076944,109391131,688387756,-618669859,-1619295381,-473405572,-1806470398,-937686467,-1742223984,1654728137,267709785,-1637119829,874675311,1766708928,-183100408,-2009379323,-189448610,1596305814,-25677536,1284500858,-782951820,-2089735806,-1567584550,1847074894,-263581230,-1300951159,-192353561,-1805530130,667822294,1943002135,-573935953,-810935490,-2063044982,-2084344601,-164776016,-1456646865,-313401439,-1645369830,392894746,-675719686,-711010985,1731392385,-2096867984,1397725084,-105069584,1062472163,857460573,-1405757123,1579918506,-434908623,207130637,767308786,-1703679014,-71217060,1712555159,-1166466986,2124611344,-536483067,-236537174,-1481926503,-20506925,115896209,-603926388,-1907853373,-1031454439,1205721242,426265841,292908766,-458080683,-1968426443,623827468,-1075899295,-1961428533,-1348588241,1853337648,1384459667,1740840745,-873465818,1366841197,1908194476,-1459438613,1800542742,457924753,765729893,382788358,1491510227,928085983,-1131735234,543141270,-1567211212,1087745384,-303825634,-640348636,-1596719163,-659281867,1931474673,1394675437,-1950428503,-766246014,-394981982,1024241274,1476098136,1915239068,-1988831264,1019905637,344790841,1657163933,-800035461,-801715264,1700784544,-1335747718,147532988,-394690651,-1060287008,835275999,-1111034070,1392915658,105854864,261458514,379490280,1455264988,884726170,-1242367899,2138120756,2045252189,-1379111864,-1333726102,1687752125,374721788,-2008079879,555575641,-288529271,-2139162206,-673424017,995564239,1591453013,1614748061,1313879966,802084555,-135775878,-1495886984,27274568,1454497387,2144588898,1598198043,-2084208108,742357613,1678653793,-1911946728,-1605084353,-1022843832,-1576794929,932827616,-1392937778,1131370409,1027447963,-1545532640,2021431889,269753578,-1652608422,-901284890,-629147331,1261084165,-781761401,761293222,-630513224,1844483569,1493279190,-904332579,1786893353,-377253251,257035018,837488895,783457778,-1093755400,498858839,1138238977,-1723747451,-1474851093,1273272859,-749672316,-1175212703,588613057,-1729630674,-331926917,-229396195,-1189309586,1325828429,478918393,1679537133,-214720394,211076548,656940049,1453806791,864789223,1374337476,-1346527737,1480767423,937693341,-1928578667,-654825990,2139293674,-528511415,-418270567,1052487077,1186466051,-1693805620,230352232,-748689094,83788832,-888393491,1550714323,1828296912,2130703465,-419391550,1777023362,-117468157,943787419,267889112,1350161254,1997139694,-1835032617,-1032880172,2094313492,76709479,413237530,-787358748,2021533496,-606933932,-268655769,1719126255,-643015641,524685409,1729509682,-976890155,212941442,-542148167,-65993251,1463031614,1335066700,892511732,-93228517,1520748879,2084093947,-989717055,323380158,325292575,-1399200492,211742343,-278863323,1143296113,1048903821,521004098,-1304828263,-1978624331,1532151706,838741185,-1589954834,344562393,-866148850,1987463942,328980350,1105122482,557396583,871752910,280398190,1461617730,-1655389226,198487601,-1077205448,2069736223,645891945,638571103,485330388,1224214519,85843389,-1419020126,781048809,-128271815,806714656,-433575892,-1384502998,-2132762962,1661145507,-316517326,-1339466519,-1469235349,-756373934,2047562426,488283292,-544529315,1512874492,1277159525,1348037268,-2030194041,-2098068850,-1487816650,-1251999114,272386863,-1228259502,-992694665,264413063,1277138542,1584178929,1254045953,965234843,-166264262,-2137833265,-1263617445,1288716427,-131566290,-1018450262,1654772005,-1990641622,1908537841,954194922,-25183297,2017710387,840476370,1975254979,-1122425597,-1100013243,1662065786,-96583511,2031099007,334433374,-2130532089,-48089792,-855177883,-646517829,1570095290,47932525,1017234016,-1756301894,-175498553,1663861500,-1229372703,-1451616598,-676585117,-584549435,45515062,80214958,877932504,1375598232,-238307208,1648030143,-373880012,1994223522,1009211526,-1969979266,203130263,336006365,1829767163,1586916905,2066965618,-862874490,-151292792,-2061587697,-1504480832,-1235488993,-796303709,280418617,1381113163,924267071,2138307925,1666183362,616031642,-1447316738,136820119,1849243728,854627238,-1229217049,1280234124,-851220937,1718067842,-1142246898,-2139821514,-1481003362,51751736,1712256713,-1623008393,-859190892,2122474875,1789561119,39567047,-186267465);
/*FRC*/Random.twister.import_mti(97); void (makeScript(14));
/*FRC*/count=234; tryItOut("e1.delete(this.h2);");
/*FRC*/Random.twister.import_mti(110); void (makeScript(14));
/*FRC*/count=235; tryItOut(";");
/*FRC*/Random.twister.import_mti(116); void (makeScript(14));
/*FRC*/count=236; tryItOut("\"use strict\"; M:if((x % 3 == 1)) {( '' );t1.set(t2, ({valueOf: function() { for (var v of e0) { v2 = evaluate(\"function f2(i1)  { yield new RegExp(\\\"(?:^|\\\\\\\\b)|(?=\\\\\\\\W[^])|(.)\\\\\\\\u0016\\\\\\\\1|(?=(?:[^])[^]|(?!\\\\\\\\v{0,}))|(?!^)\\\", \\\"yim\\\") } \", ({ global: g1, fileName: 'evaluate.js', lineNumber: 42, newContext: true, isRunOnce: (x % 3 != 0), noScriptRval: false, catchTermination: true, saveFrameChain: false, element: o0, elementProperty: o1.s0, sourceMapURL: o0.s1, sourcePolicy: 'NO_SOURCE' })); }return 3; }})); } else  if (Math.atan2(/(?!(?:[^]+?))|[\\u0073-\\u00CD\\u0031\\f\\s](?=\\cV)(?=\\s)((?![^])\\D?)/y, 20)) {null; }");
/*FRC*/Random.twister.import_mta(828438299,7585847,2095724621,680332070,-350605807,-238728848,1817709511,415410120,-1308905427,-1232096388,-1150821180,1687133581,-1268032661,-254345835,-1924410601,-1351337026,1612611943,-186099835,-293145139,1847784449,-2024118551,2146134013,-1960647958,2129003447,-695515114,-651544828,1900696231,-208348135,-1382440582,195822256,2094052450,-1137859972,-2085342492,1447929671,-461782686,-1064692550,-1642206095,-299872321,-2111254939,903939639,3289946,727484016,1551580313,-1927830985,1021956429,-2146558791,-556381775,776844637,-1689991657,1854132241,-1009779417,-1779638668,77331533,1368630844,-1852085624,-1489577784,-725497361,136837009,-1952681861,1389306675,-35671298,-72253263,2128936320,867233080,-1192298830,1691218401,-1361811839,-299694872,1058535921,-472947578,-466930507,1268789275,-226132465,1374646711,1630196967,-1400984896,720109649,-332152248,105904432,48366508,-956208427,2012563766,1663645313,1169027613,-1444897060,1787865045,-791857594,275662500,4286303,-1651626454,653701786,897194278,-1037902594,-1864699692,1353307114,1557151780,879938138,173901290,-741573284,-1618537962,-24424026,1656199726,1159218300,-618810943,990503631,1069275963,1630373796,-318538584,-834061153,201563050,1404946448,1353847802,1413459575,-1229480581,-347607087,-680758054,1837791560,-941281062,1708555344,-974955919,-1649047913,85529622,-2093713949,-1678581126,-199345422,-2085618740,1871354416,150841050,668406817,-287855139,-334628653,1096440502,-893935791,-13916479,-1143075131,-570500853,-1403463426,-1942579092,992019563,1613370893,-131419968,-1034690071,277103393,1939927077,-393048266,-286048228,-798149785,1941182550,6284195,-211582257,1132253087,-1578406396,-145994042,675188753,11437121,-1998587671,565809336,1904877357,-1893952256,-1774631084,-944175027,-1981941374,-623408790,-669482121,-1336035117,794435572,1862560734,-843414881,-1745519758,-1622968866,-712851135,-612259268,-1747559849,-1099756609,712975265,551726991,-829959847,-441633820,2019513605,-268090137,608861588,-2045679668,1617550841,288035504,-1693892554,-1505358017,-1226803194,-1650966279,-934232630,290183303,-1178485956,526786361,1099536081,889817,-25643617,1519357420,-617515307,265369421,945178936,195143755,1298537934,1309619998,-973454612,-137021680,-219069150,-468415311,-1509948067,-1787490780,170163377,-928711201,1067299910,1066344237,1084172254,265338472,797294865,1408255102,-1698142877,1082161179,-1626221539,1042941761,-249823820,-9425175,-875285072,1673644350,-1523909542,-802296353,-1971625104,-1052714522,-1096396706,-1556083682,-1319154757,71966433,1691928561,1551988048,-431203548,1982889812,-603696634,480535362,1887396369,-840341979,-1582915302,-1174161061,1891402379,1329939723,1129666545,1555684027,245621839,-1268884520,-1543474153,-586039041,1081159082,944502510,2135745020,1123200543,1563920654,-290685850,1748286640,-227223386,1806621948,-546975728,-629348492,1375510575,-1515468075,921815745,-1138470323,-1278515313,-1936511081,1470916328,-1022476342,854934540,1844841076,-1008253998,-716636844,-365522439,1300068220,468988991,-968757373,1711251389,-1896815226,-5454597,-493595047,-1080992992,670114449,-582170087,-25032010,-643631979,287073389,-458866099,-1905863272,863431586,1396743677,-1385854456,-51058898,411271374,-866529507,-333879793,874677135,-318644896,-1069673487,388835816,-618219590,228726164,-1998256230,-1109010376,715289992,2058720704,-884657970,-1400620168,929018869,-56026349,-1571434655,-992127932,1787352372,-585003714,-256936991,745623680,896248807,560327509,1063772628,142130861,384530259,628369345,150035889,874152059,1635250738,1960134298,-189876586,609721137,-865429233,1364933017,1085802635,426792955,-1887540226,-811820076,-2136813745,25604347,529956793,-1255691371,-1029440327,-733606056,-2024400178,-20899402,-1981695641,-380045636,-1109040793,780269261,649339587,-1979518083,-1731247546,458614107,-904102025,-1101624787,-1474251604,1486994637,-296603953,1794627853,-1106309870,1537911353,1382345714,-1714778490,-353565735,1292346339,1264812733,116829732,-1099270785,-1853679908,-402958135,-1202950931,-635442452,1158091059,-731932487,-441164982,1004322160,-1443408997,-1108568256,143384813,1122944416,987337948,-956328431,-987761188,934959894,566868192,-189254546,-1768219173,1895338432,976611672,-1128529455,-1962442552,-1367128274,-1488123463,1390063076,1228462326,-1706253527,529814287,79127907,519694481,1209537565,-12855997,484459186,-310344528,-991737071,1323502469,728117192,-608969665,-1492628087,849139200,835537933,961884745,-1589617763,-601923087,1884537586,-44484740,-769566555,2101779347,1012813210,1026627265,-136111978,1108300370,-976227007,789824389,-1629370903,-1278461243,-1247902623,-1167739786,-1264968607,-1620179727,-1216804456,-110130469,821724016,1933679580,1521156721,33497596,409778204,2036793809,497277577,-123848121,-1778133597,-617132350,818936960,1218548754,1027905811,1917710359,1506992174,991384910,185143508,2043176350,-469937560,-1778186791,-1697661337,748762685,-1263961734,-629710687,-1848948820,460585486,1922899309,-1922759631,-132058327,548320444,-1685982748,-823106187,1643695153,-941459631,-1514158380,-2003813710,-1382848559,1408560443,-1049431745,-1439059213,2132197311,1874396461,-454878110,248293882,1826734867,-2069209658,1805636601,1812957166,-2039592041,1828587358,-1398398422,-1969209195,-1249493657,239989801,-1513808494,1082817525,1400068012,1920561733,1731300936,-1939861548,984746157,1502119340,1762992492,33312390,467381733,-458785965,-1331905188,-515649236,-118612345,284813111,-1248406338,-2067527601,186875997,-1284986919,395040728,-253865925,1958100507,-635561990,919129829,-1920946346,-727923088,-535970883,-897871747,-588486578,1481514636,-320815751,910554304,-1749753863,1735325579,-2115577939,31351238,1351183846,1821655890,1470479202,1502146116,243105229,1134645444,1290180412,1894473640,660888008,-408828338,-127340443,668415135,361230900,-1231869982,-1229802514,-276160399,-1555073475,1587037555,718867859,1676659608,-393779495,401477814,1384647405,-993257714,-1322342794,1197032547,1254773099,86012266,956345249,-41070829,-2020688143,-1651614570,-580729905,-1059599396,-317473227,721799373,1935490481,114971987,554340640,-624618226,-1262967903,334354644,821038944,-1030893903,1934300922,-177151495,711717243,-1169002874,596487376,-1536188599,1269889387,1550624662,-1087500187,-34290600,917860100,-1529162080,-404757929,2056349041,63679566,-116707068,-1747941782,1945662510,1022837466,2109396716,1248347882,2047647277,-621294986,-449501605,799444294,-333555884,534227505,1805431101,102387090,111139145,1307174049,-1849791312,-482262463,1747078374,-2113818917,-1333637109,-1347234564,440214658,-1301326663,-1871009254,1610997423,1844542101,-94035952,1660476144,689184967,1941778658,-1760855797,-1054291769,-428342415,906567506,652188716,-411278717,97692800,-1853659176,-1423249134,-2089190942,2037704156,588700672,-1677219619,-83711795,-912203953);
/*FRC*/Random.twister.import_mti(152); void (makeScript(14));
/*FRC*/count=237; tryItOut("for (var v of o2) { o0.g1.o0.v2 = r0.multiline; }h0.__proto__ = h1;");
/*FRC*/Random.twister.import_mti(202); void (makeScript(14));
/*FRC*/count=238; tryItOut("mathy5 = (function(x, y) { return Math.fround(Math.log(mathy4((( ! Math.min(y, Math.fround(( - y)))) >>> 0), ( + (Math.fround(((Math.hypot((y < y), x) | 0) , (y | 0))) ^ Math.round(y)))))); }); testMathyFunction(mathy5, [0x080000000, -0x07fffffff, 0, 0x080000001, 0x0ffffffff, 0/0, -0x080000001, -0x080000000, -Number.MIN_VALUE, Number.MIN_VALUE, Number.MAX_VALUE, -0x0ffffffff, Math.PI, 42, 0x100000001, -0x100000000, 0x100000000, 0x07fffffff, 1, -1/0, 0x100000001, 1/0, -Number.MAX_VALUE, -0]); ");
/*FRC*/Random.twister.import_mti(385); void (makeScript(14));
/*FRC*/count=239; tryItOut("mathy5 = (function(x, y) { return (( + (( ~ y) ? Math.fround(((((Math.sin((y >>> 0)) >>> 0) >>> 0) << (Math.tan((mathy3(y, ((( ~ ( + x)) >>> 0) >>> 0)) >>> 0)) >>> 0)) >>> 0)) : 0x080000001)) ? Math.log2(( + ( ! (-Number.MAX_VALUE | 0)))) : Math.sinh(mathy2((((( + (x >>> 0)) >>> 0) , Math.fround(((( + x) + (-Number.MIN_VALUE >>> 0)) >>> 0))) >>> 0), ((Math.fround(Math.sinh((y >>> 0))) - Math.fround((((Math.ceil(Math.fround((Math.hypot((y >>> 0), (y >>> 0)) >>> 0))) >>> 0) || (y >>> 0)) >>> 0))) >>> 0)))); }); ");
/*FRC*/Random.twister.import_mta(1711965575,-1147277749,-104464093,1751575750,906080061,-1002267916,-674066469,654124352,1775964094,1820238447,-770028464,578635511,1031581668,-1342268506,-1427952989,992389321,-566624114,-770340957,-752296930,1833343805,-1527623309,-1067547596,-915901823,-1247518238,-547806905,1412636141,447179429,-497627940,-625474135,-1995353175,-411477019,1897961986,-2123368288,1754784448,1639590817,-831848709,-1753245999,-977334940,996542851,-1776628722,-828830214,-2013605357,-685574698,-96943766,-347976044,-1347324887,-180797633,-1616657664,-1753137847,1527913508,-587896093,1099624606,73983267,-1134244802,-1981018939,1654854532,-966217447,-295987825,2097816951,-959501738,-998325189,-453800156,-685239319,2106570600,747388798,735921483,-8275770,1796221942,1645436792,711973818,1457592865,-547573657,-1639576279,1300154062,418643098,-1600162844,-1296843550,683159393,1837008440,1021726242,386180037,70912437,830343492,-1586073079,-502458596,-1918662991,146626727,-899984164,2092852560,877319941,-1763900601,463693522,300285382,21088409,798256788,31639752,-511067738,-1720024078,-1367320537,-2018789804,1638017568,-1759840640,809656432,-810565147,901642907,656217098,-966791569,-1969614709,-1675634129,521546477,-1512462677,1737204116,1650378207,651220810,-1218817501,780870184,-820894444,1152305896,743293470,-1329822689,-1016439386,-1723012120,493886683,379280939,376587908,776840028,168013472,-918394357,-494538483,-1612377314,1204384915,1542633785,519410650,-483359966,-495964562,-524334179,-257294376,722604699,173198820,1653415187,-755479112,-1297786153,1214230036,598169389,636594915,905068130,-923489699,-562166419,-361553709,-40458630,703929507,-2043975568,1251558950,80850537,1074106212,-1878326400,1289617788,747340365,943824411,-66166358,1709469153,-1213279813,1102860997,-758401950,1734148250,-183501986,-862001302,-1098228672,1707756436,1234943737,1313700302,1988887229,-1920873365,-1873049959,911734653,1136630827,1147401974,1107152125,1188425979,682908603,12787624,272068391,-1622864078,2122110005,-153291366,650832623,-1649617335,505725128,190486250,-103416891,-115527163,1439837411,-2032545022,-844604627,1801292644,-1307585796,-1828073512,-1919596500,2140743355,1318142465,-1526319788,-1837141635,-732409996,1665500691,1500357182,1517426795,717183421,-1309936622,1195372064,1026949331,-1344594034,1408410381,-1864161729,1340250256,-813686450,-1570398916,-543747842,1912354898,-1009836033,-1458661118,1301960377,-426548422,143917379,830710317,1830416109,-1103160971,-1459571780,962178472,-365041596,945886241,-1286909079,-1654293478,-368959396,-453729719,1575295722,1205413565,573346766,1932348807,-1652472518,1840250729,1811412948,1270209337,-2054374765,1721244585,1698814497,1299291878,2003416785,1878711207,937350292,-1454316460,-1451124075,-520138311,-331154883,876391970,-721358097,-1365091343,-1339342854,-1834076773,1586655754,-330200294,-1721695736,-362316268,203074372,275058472,89263740,-467194217,-36896902,-283241953,-562008043,-505810708,-607428477,-2115620802,1134726154,-1819835263,189884864,766081623,-1327144155,-611510240,-1487658436,-332759344,-475242066,1125920082,-720517545,-1188449214,461528858,-1400068194,1838463919,-2092060937,-1119290635,1736502728,1799189100,1391873257,1738310956,1084616599,-2079053778,-1593135520,485438730,-1342790906,-1798691693,-1277864204,196070404,478248791,-26370056,-404584922,367191425,1222385247,1789154206,-710685984,-1553582877,-111387093,-1021781973,-1756791418,-1556922322,-371043960,-1671168868,-16580484,-1108307344,-1989217363,-2036889253,-2087127376,-1963758682,-1293651821,-2098776022,-785235777,-1559224129,-1797848212,1284033299,-559950216,1723849363,-1994992406,1512004295,839044964,1087592928,520501527,1397880873,182211884,-1668460552,1568729128,229156408,569755832,1504730001,1789017679,1512528246,149431672,-1964605103,-1507892320,750079358,-1894908795,1307486618,-1586064449,-793203742,1113726162,-619328027,-1541273320,623982162,-41781372,1798895325,1861943658,1461190266,-225729815,482075148,1590255599,-473686897,1989965240,1674811893,-525872801,-1482449990,-1074284338,1227776657,-75967849,1367177864,2015360091,-1207883920,-1778195971,53691844,-888913405,-520459244,-1820170380,-458976610,289696685,339046937,2052691283,1112423858,883050908,831616737,-1088999892,-1181900338,849727094,2097210808,684786743,-162015207,-210509359,600662534,1473111300,687741143,-657526459,-284236665,4020375,1078739173,1996020028,1847767940,602202265,-143736085,-1896914707,414427133,-952375774,-1391037888,-1989442887,-416256256,-412291509,1087393675,113568023,-1050601479,-2088505212,-1716192393,816519841,-1731046676,1123186810,-1689027074,279019817,222754448,-1466271349,-281212729,1347186999,1529543307,606446199,-1423034445,-42240788,-1411400557,1610972819,1673139949,1432092208,-3594148,-1117387738,346839534,-1791577042,1353557938,-138616370,2007132420,390716009,-271790012,-479637159,-1074907237,-636249964,1293421213,-231622965,2064100145,-1711982251,701188347,314621438,-978279774,637291835,-209263502,155618773,-1495031953,254091535,1748389503,-1098142821,1662385791,66516635,1577920830,255523200,59849700,-303197959,-2082501691,607161722,-1581541681,-1921771308,-446568080,-1208142686,570314580,-902198409,1327804421,-1683034126,1509759056,-1377746560,-550508549,-1076720768,1017626924,797529169,-367860503,-941458394,1475335892,-1718447060,848968806,1829418286,-362705680,1563473537,-962380606,948976626,278603883,-1850251183,1333535713,-1518165548,-1614808439,1006620553,816690088,-1056961828,1519158470,-1623458565,322660274,1083474476,-1932598635,1404488951,-159247395,1698231697,-353752709,-1981676906,-1441644461,691584694,-681607067,2007322716,66341373,917914063,295662036,1475817967,-25479487,735199887,2058549786,1373021317,1802973734,-1462739188,1060937817,1027579240,-1987712872,-1396733113,-1603831280,947859235,-105007174,881767784,-316571844,246118000,327501736,-2073431175,487375137,1428334213,1966630973,-219202073,973241909,-389789579,1504633889,-1106905317,-1483451577,1196720286,889416647,-2079870482,101716927,759004400,1747689268,-870312351,646680967,-1015298735,2069261481,-2147311702,2117728383,-52805403,-1718379398,2004734016,-246010261,153466250,125714087,-350244946,1937366609,1060999131,-1849843638,276926843,1882398416,-762370838,-1770851803,1947273917,-1904763499,-199433347,-45755358,1054352942,1709882737,-1448170499,-1600961128,-331533472,160063463,-1561724942,-1168529291,468475172,-659139343,-818542316,1132520529,-1132077688,-1520901046,716491174,-2010498520,1325593806,1972458353,-107690610,1599837136,-1350783518,1465887025,1027556578,1668330789,-1875582382,801545765,-182471375,373160830,1259213001,571350411,1326080385,-1364134020,-1780940826,-1664693487,770435688,-388720375,-1143805682,-560531205,1788213576,-1401364422,322642000,1884067894,1975604820,2101640382,-1209309976,-1882614977,843451398,-1060732491,-864551826,622210621,84088475);
/*FRC*/Random.twister.import_mti(70); void (makeScript(14));
/*FRC*/count=240; tryItOut("/*ODP-1*/Object.defineProperty(t1, \"toSource\", ({get: Date.prototype.getSeconds, configurable: false}));");
/*FRC*/Random.twister.import_mti(94); void (makeScript(14));
/*FRC*/count=241; tryItOut("i0 = Proxy.create(h1, g0);");
/*FRC*/Random.twister.import_mti(110); void (makeScript(14));
/*FRC*/count=242; tryItOut("\"use strict\"; /*bLoop*/for (let yczlqi = 0; yczlqi < 15; ++yczlqi) { if (yczlqi % 5 == 2) { Object.defineProperty(o0, \"v2\", { configurable: (x % 6 == 4), enumerable: (x % 12 != 0),  get: function() {  return o2.t1.length; } }); } else { (/(?=(?=(?:$)*)|(?![^][^]{2,}))/gyi); }  } ");
/*FRC*/Random.twister.import_mta(-2063917203,-1515720533,46903135,-332737339,29732323,93271513,-577637811,744366114,1745618890,-2078583704,1096651037,-108119822,-258759784,-1935054331,-1033957972,-293857346,1937867658,-266300040,-553588768,329501322,584923744,1727001697,1249096152,-69019924,1535854498,2070285642,1634146137,-1350678400,-106579076,1100622494,-2048181779,-1419231037,340692979,-898649118,-345624174,763253739,-541490540,-803738128,-1640246743,937501007,759773208,473109487,1784003292,-1704069362,767122322,1551505627,-1782417132,-1613749018,-1615284007,-864702817,-114278118,-1292399947,217242593,407770143,1420674297,1236929569,-412878899,1097743627,742568996,-1828610883,-856527863,-1853274284,2100374831,1212888705,-2082673670,1012000647,-1738177278,-1294588807,822567079,331590400,1003679800,860512059,-784181307,763867417,-629788027,377319028,1459243165,1866619724,-1282251119,1302660806,617037701,605603214,-1506091638,-1693159577,406523809,-1967535528,-1128317374,1287982798,-299405709,2013773196,283182568,-833502687,-1590136991,122756897,-1857680331,2142830386,-381689811,1375168069,2016023715,1081910968,-896700004,44938494,568634582,-789763552,1394214953,921281917,-1879870355,562384405,-1279569864,1628326641,-98053540,37065315,978375955,1442453931,551600456,612195191,1424041147,129601755,-694041793,-1613883374,1735669627,-1392360280,-1013728433,1615728996,-1074360670,977106697,-2137646926,1640997057,-481492280,1519087750,-1936800928,-154698153,85390585,-1676056565,-402889887,1808906308,1223183083,405120979,-43214637,1547980513,850731091,1580050751,1612665660,-765558385,-1526929366,451327670,-1318898953,-651015311,-87235885,-874369743,774424776,224869415,1463841162,109663797,-880917359,490302487,256896595,-82737235,-1025675216,1919490645,-173930430,142653398,541093819,1959837418,-778546687,355904996,1618518523,-480737920,-1387987240,1461035575,1891734891,163226831,-1523287762,1280628468,1288412599,-546033831,-2026999665,-544672301,620508927,-1594701236,2100180012,103340158,1155476791,-2127048008,-780035956,1332252426,-2145097360,1177399076,426217653,1088343447,-648712440,-1958292567,-1327601273,4167363,-527225616,383743036,-373945868,-1315206477,-2088807107,1911795599,1073998387,1173010847,498452199,982198881,-12604381,-1369898614,1476369288,-852557716,306925392,-1960098602,-585495759,2041428681,-601643706,-111744932,1000814550,-1011652539,1808088185,-928798954,558242517,-2105415875,-2069703307,1384850241,-1282445873,1866647068,1247854603,1905686499,1504690255,-1310332081,1621084772,-2107197900,-1567069496,1959050701,-285354974,-1285325000,-1766194269,2031767085,612713076,1335702400,374437785,-983017358,813381446,1502732346,70822581,-668344763,-694658549,2109508695,-1118431354,959598634,1917290059,-2017735603,311807727,-1264416157,561535579,-756031759,1630000551,-1582291839,-1849327476,-358481688,-1656715954,1493044983,-1084486424,-1385470928,625792127,-586119766,2064435812,-522343020,-647587681,-620646195,1826614169,-1632060862,-627118319,1281891735,-860788156,-798306828,269232402,516077972,-1582095729,-1432727548,-991775267,2099571510,2042626742,-417097971,355390976,-1432168384,1462267588,-1014998740,196082457,190751148,-498519632,1219466265,-130506710,-1340954260,-2062835565,-1703964395,-497847479,2138110498,70843011,-390114642,1788933185,-1802128953,-1160790419,-448725639,1703685479,-2063365502,-769334084,-2034217122,1735713718,-327379669,-1044489660,1589510464,-793718364,1235398582,-28777828,-225525748,860131056,-1327552693,-1514638203,-895323750,-1885488775,-465446222,-953444425,-801796064,-1909887054,566182061,463267827,-2023308811,1865633156,551169034,103210635,-706498198,-907260526,1936958681,-1604187863,1062418598,619406467,-1107429436,265174757,-51150528,315586111,-1887418364,-106711469,234057203,537479627,-929377076,1421222155,-2131008128,20993679,25387958,615628200,-1412436290,25108237,192206991,1747743621,-770800741,1594792707,265931129,1844899891,-1492829091,1451892732,1263207935,712341283,1326898681,278889112,-536267058,-1317077085,-1363323634,62886534,-819289660,-90607445,144830072,2002373501,-1191412846,-923830633,-252014571,1706613423,-1968057127,-2111627637,1551532423,-590497490,-1001228199,-1565709245,-363242936,124274905,-1903172100,-459665221,-1642356521,725351790,-886932834,-2048883438,-2107427992,-1805517091,-2139167998,1053843302,-317776561,1446465021,1137392708,-1912357213,-907082298,851888209,-1843060500,-995223961,-294368227,17510384,1384059822,-65730878,1920405471,2102377423,246809516,-325705852,-1111508435,459085548,1748607919,245987144,1442227220,-2022665557,353286595,564654506,-721628681,1511957474,-1233317169,-1921377575,235214924,-403571592,1563149422,981592919,266403387,256775673,-1931180891,-1394559479,-1251967666,270980473,-1059375091,-253099111,497661823,-944481669,2048760969,-1326107599,-1496629325,-352196830,-339358364,300609583,-44524348,-1363500017,-1807644184,1756613804,-976388206,393464648,1229963735,1542159806,-1856553826,-1531686818,1940107826,-1405255210,-740901081,1870646039,-846439036,69980966,1243227432,-331909537,-1040498499,-1258421256,-1754096047,-689686898,-60672183,495285565,-1618736095,-2083367912,1120650238,40860267,1422363935,1681763105,671265494,1886124974,-777479250,801304810,-2066168471,-665679475,1288056441,980324500,-1921410832,-1323376414,181419725,-1384550761,-930570561,-601400705,-1469037770,-1351686808,-1676832119,-249333303,-1274417003,1287881053,-2051380405,-232981122,263312644,536274902,1955148365,-1103577300,-1210536590,-620932299,-2060658275,-266302238,-1889277817,-300847312,66755518,1091475987,1755255231,970320509,-1245605312,-1279276970,-1484151059,-781160338,-807732507,1104398612,56640499,-1179809404,1148983823,-2075261567,-983442137,32590833,-1330628224,-1912095085,616928186,1643066518,16387791,669525970,982731081,1369609865,-2045680208,-1090017331,1394381561,-1034538566,-605665432,503055933,-1325779975,1608873654,1646976645,-20893844,347692641,-456639661,194453587,1954843486,-108652660,-747280636,640774585,-928929427,1436352633,-220240694,-214018003,1865231311,1147410350,-1727393062,-12623496,-2023256544,-1993932444,-2017477465,1257181366,-1369614006,1750067832,937524764,987080357,182251377,-1000391820,996901110,118550208,767293730,718731607,-1496851855,731021214,-286041998,-1103480866,731649453,706005786,-543721833,-1430406936,-1940093289,1962418020,-573475058,-592281567,436216694,-1408755872,-1611092727,-363003484,1749208563,-1791085884,-1186475367,69627353,504455468,778070583,681027486,-1285579777,-591178743,-556583349,-1190984705,-250022207,-776666187,1378458342,12296017,-1179503440,461050325,-2081322200,1282746542,-306748235,876369094,-1787075275,378994292,195456121,-1834513043,265277464,-1213190449,-248806277,-70969000,-223977306,-679071489,320713077,-238890572,-1153254579,-1718189796,1250789277,-648157951,-2017743005,-1959468168,-1649087940,-666761258,360088010);
/*FRC*/Random.twister.import_mti(10); void (makeScript(14));
/*FRC*/count=243; tryItOut("\"use strict\"; a1.toString = (function mcc_() { var pzcuny = 0; return function() { ++pzcuny; this.f0(/*ICCD*/pzcuny % 4 == 1);};})();");
/*FRC*/Random.twister.import_mti(34); void (makeScript(14));
/*FRC*/count=244; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return mathy0(Math.expm1(Math.tanh(Math.exp((( + (1/0 >>> 0)) >>> 0)))), (Math.asinh((Math.asinh(mathy0(Math.pow(x, (Math.tanh(1/0) | 0)), 1)) >>> 0)) >>> 0)); }); ");
/*FRC*/Random.twister.import_mti(165); void (makeScript(14));
/*FRC*/count=245; tryItOut("mathy0 = (function(x, y) { return (( + ( ! ( + (y | 0)))) || Math.fround(Math.fround(Math.hypot(Math.fround((Math.min(( + (((Number.MAX_VALUE | 0) === (y | 0)) | 0)), ( + ( + ((Math.cbrt(y) >>> 0) >= (( ! (Math.asin(( + x)) >>> 0)) | 0))))) >>> 0)), Math.fround(Math.fround(Math.pow(Math.fround(( - Math.fround(y))), Math.fround(y)))))))); }); ");
/*FRC*/Random.twister.import_mti(339); void (makeScript(14));
/*FRC*/count=246; tryItOut("let x = Object.defineProperty(e, \"toLowerCase\", ({configurable: (x % 5 == 4)})), jucorz, qoajnj, a, b, kgiizm, e = \"\\u1160\", c = undefined;var jyoojr = new ArrayBuffer(4); var jyoojr_0 = new Int16Array(jyoojr); jyoojr_0[0] = -0; var jyoojr_1 = new Uint32Array(jyoojr); ( /x/g );s0 += 'x';");
/*FRC*/Random.twister.import_mti(544); void (makeScript(14));
/*FRC*/count=247; tryItOut("/*iii*//* no regression tests found *//*hhh*/function mvgmpl(a, x, ...c){p1 + this.s0;\nfor (var v of h1) { try { s0 += 'x'; } catch(e0) { } try { s1 += s0; } catch(e1) { } f1(i1); }\n}");
/*FRC*/Random.twister.import_mta(36982092,-357847263,1027144273,491024457,1975215662,-1228184055,72352703,-938277593,1887086059,-2065054818,846274517,-1797271992,1659092976,2054328378,520595568,2003416717,1843850920,-386866853,1558142086,818506906,2122554136,2133293838,-1953728071,-524306168,867573481,1313523467,1251270702,1179858665,1865280372,-1800193584,1079514139,2144289071,-1873304385,1704316336,258777383,-550059309,1973567879,295764912,-1192903439,-1504597955,836372123,-567592372,-420268317,1194745318,1248665718,-1537501051,-609641573,-1100537825,989796354,1810623429,-1992510382,-2070241135,75007566,401212157,-831126275,109365999,711528829,2036240645,1560552197,-77965827,48137858,195514391,2094426914,-1257212411,1347607885,-623447025,1006736810,-603032143,-1771710047,-1640289276,-1033478980,-1278811818,-1693653684,-804388164,1664878060,-1038192833,-435571192,-1358728323,-502643190,1396287120,1590316222,695467601,1509629852,1678497773,260889569,-215551562,-1360389672,1916558745,-730620432,-1491179620,573424454,951582374,1856622554,-580372584,-93973294,1602993591,-29174023,-1158980264,1421304081,-1686239262,-158435571,-904985250,-1386591091,10827817,220170982,1893754329,-902787989,1490235919,-2129624040,80085843,1842604974,933171712,343677671,-1056960310,1156376449,-223614058,-1716241599,200661188,194713094,1862053603,-740229261,-114284919,-1063833294,-1845691966,-523003679,1638152399,-384471440,374253238,1473704202,1474688825,1685744196,1686400366,-1005021661,681619669,-1374774454,-1602186345,635457743,-128218624,-1795143382,2123567002,-1566098911,-725118259,-1146040245,653983563,-1258992425,1389121184,-744430370,751790299,-1453021634,-1513422674,1820686049,1150096138,-567800725,633176141,682321836,432589270,765948525,-422509377,-1429000893,-1802740373,739226003,-1094059746,12450256,-1156024658,-1899729530,-1839243052,918334464,2065270350,-665544557,128950299,-1236820698,-60201755,-670016348,-1796117591,-1666814871,84475407,1550938846,1193946423,1686207042,-1555665640,-542708706,-1587083982,-1399587268,-147300017,-1914091999,1750137163,-165092010,754756124,-1119765555,851170984,-221531332,-370138238,1783160897,-326450575,-1782805419,-1915222267,819823431,151132660,-1277624834,-1179460969,38787232,-1935064455,129806023,-354267552,-1164188560,1606654210,-1276320509,1605589468,238276114,1696741418,-367936093,-1717437332,-1920929707,-1508474189,1249338459,996941340,927752958,946433025,587921420,1120885625,-1161779486,1502798649,-266679187,923546530,1014456594,1839028014,-1802713934,1920706686,-342297541,1819594549,-30499216,1120242751,-277161579,-704269647,764842734,1647838417,-1557702050,-1605299002,-1234443663,987636819,1455054887,-2079109643,-1032459920,-1616743566,254154671,1114920773,1817199759,-559355678,-437113353,1540238865,1676037350,-100498661,-30041940,-1559250398,-813460362,667888434,-505267804,251156156,-1967589749,-1879465269,857767848,-993887289,-239173626,136586421,567268730,1298022497,1390002308,-558021752,-780703891,313848244,-1207245838,1815450964,-865141121,-1817211118,-1324974891,-1288816230,1051116487,1917148771,-100084470,949520149,-1116505692,-2065600515,332768975,1107109407,1486798227,-2116325802,-17496789,872029786,-151508284,1086995255,-317119821,-1948271141,250186842,-736060207,-1548351328,225514559,-1436252845,775853635,545556842,1600359077,1000787167,-1997364352,-1063277954,-1894005674,-329034542,-1850722351,-66102054,1041588636,1177353969,1906538318,14319670,816360111,-1973317200,-146252128,-212107549,531044205,-1034985647,-51663067,1251415039,-1808485154,-1250754680,-1116560629,-1772311234,1787041247,542150013,590268371,-1961684505,1821747351,-520167957,-911447484,-535536998,-2077868371,793377162,1095601909,1177405933,1610558389,985646067,-1111695250,811546114,-240815855,519116524,-840895557,-689536528,1793563419,193489412,-768373346,1849499448,-1044897369,-321400362,421531243,223225178,1305285116,-777270819,530223918,-2002062635,-131778100,-579872312,255813050,-668377266,1210752365,-1776062730,-1505666554,-1870395152,-464019519,-1358618489,-723550103,1493589880,1189294763,-1869126159,420775210,981779074,1233798979,-1279674763,947140950,-1331744152,1904056740,1392439474,1122216566,-1079205895,376842901,1351691625,-233311457,512703272,-958215441,819225611,-11611148,-1323474908,1862267674,-499542,-746211743,-81328337,-777240011,1037065900,-995116511,1526470764,1180563229,1666720504,1982613969,-176425837,592439112,2059664760,-601621615,741832664,1652289983,-1491527161,-1020389510,-1541575474,-370285604,1722837243,-516065974,1512833095,-1967260283,1118546753,1821908188,-9222622,-1382923496,-2117267828,-1614486835,1808144954,-1241686542,-1417130409,-1505463703,-481434318,-1265252813,-1745168842,762791901,650651674,-852020357,-702972706,-693668700,1401381561,1541821795,-2011172254,155089121,-1145755833,-1891506987,-1353771220,-1617867214,-331146530,1551710365,-1732588335,-2078112125,1900862184,1125483688,445633480,1756569000,-10482867,-1758128067,1362722166,-1572805566,1323166395,711565817,-1652639646,2050724326,1421706940,-1450369624,1232723361,1362990464,-1154442050,-1257908119,78925126,1189382569,-2063487062,1961709599,916169225,-142423939,1539032492,-830116403,930626469,1768131647,-1952241127,924052088,1788877458,1001471226,1171012233,282319342,-1532655118,2127627436,-54636701,-1497700131,2137986459,1077384162,-628894542,385426500,1522562855,-586185665,1492638544,-759598189,130954066,249032823,-1812880945,1489087429,176597731,1562555247,2112973425,-831833861,1230546701,1283259063,-1213511355,-1266763762,1293339534,-972108979,-221023163,-2027340271,-553490845,2146078955,578309685,-458449521,1311575124,2070781688,-1088885838,947345689,425983856,-500973079,-926112894,1842845915,-1150130821,887699348,-1819827941,-790436916,-2042473204,-1824419093,-1811635321,-1181706566,-1434484168,-1856146703,1550530685,-47337498,2020891171,-508251485,-488052766,999679763,281386738,-1812076671,-1777811967,2035050823,-1560844127,-1414124224,-328496551,-1339829217,-880061082,-1696477855,-709419154,2132228920,254648262,1945674138,1956849687,1542249136,-1623152420,-1697012653,354133347,1675840109,1740457825,1371832171,165814476,-137334450,-1114923144,-68885100,4480288,-1288749331,1667371855,462948758,1551326421,744636258,836709402,-1170969627,-1536405794,696826581,-1828853676,438320121,2146303638,-1119133296,-2022878742,-1323570004,-1144771051,-1036031407,-294519132,1078867169,1539906124,123678598,1790186492,1703093491,-222682962,415531099,-735779959,-685641768,-971892567,-2107065031,652617510,1743589931,305574971,1787564455,895175638,-1462473091,804782040,163715718,97361778,-298714441,1215464151,-712826334,-1750647853,-360638453,-490169375,431329160,-566743915,804776336,1368507033,-767456559,327844349,1668134788,-1078854980,-1038103381,801684369,-1979971330,-1437196701,-1288495068,801883504,1317094768,192488795,2018127632,-1971990721,920460167,216446968,1648493662);
/*FRC*/Random.twister.import_mti(44); void (makeScript(14));
/*FRC*/count=248; tryItOut("/*MXX2*/o1.g1.Date.prototype.getMinutes = h2;");
/*FRC*/Random.twister.import_mti(60); void (makeScript(14));
/*FRC*/count=249; tryItOut("mathy4 = (function(x, y) { return ( + (mathy0(( + y), ( ! ( + ( - Math.hypot((y | 0), y))))) / Math.fround(( + Math.ceil(( + ( - ( + mathy2((Math.tan((Math.min(x, x) | 0)) >>> 0), (1/0 | x)))))))))); }); testMathyFunction(mathy4, [Number.MIN_VALUE, -0x100000000, -0x0ffffffff, 42, -0x07fffffff, 0, 0x100000000, 0x100000001, Number.MAX_VALUE, 0x100000001, 0x0ffffffff, Math.PI, -Number.MAX_VALUE, -0x080000001, 0/0, -1/0, 0x07fffffff, 1, -0x080000000, 0x080000001, -0, 1/0, -Number.MIN_VALUE, 0x080000000]); ");
/*FRC*/Random.twister.import_mti(258); void (makeScript(14));
/*FRC*/count=250; tryItOut("\"use strict\"; print(window(3.throw(/(3)[^]{2,5}(?!(\\0)+?)*/yi)) = \"\\u4C01\");");
/*FRC*/Random.twister.import_mta(-630116706,854538596,-1260032077,1075727983,1582233674,-149436712,-545602573,1177352237,-1051003211,1680692219,-478018312,398571267,-603701929,1437586559,671192604,1951980565,-1041703762,-1860376479,-1242106539,-1098071296,-1604886710,-150432199,-979205770,1801187836,409575731,-972581595,246738328,-1603525748,657382197,-538144056,1809326899,1194991198,-1536322948,-851868939,-311065387,1808163454,32438585,1053772256,1164017684,1856677054,-1333472492,103952752,1072043630,-1114874646,252181022,-2054117382,-2060540808,1206935497,-1001498475,-67219100,1282472106,319110737,817714659,-252815334,-266111919,289570819,-543397445,-482924575,220759945,135700192,-840528556,-2057590481,914707380,-174746817,-226016399,-620665473,-1008543208,-459145722,-1197515137,982051826,-1754915482,2063485187,23367009,-96655121,-1894486728,430227862,-180865637,885594508,2035223206,-1950306387,-211793061,-800866131,230142964,-509491020,2040851257,-1913202594,-152061353,1895414239,-1904166927,165755635,-824013632,815453375,543419323,-289231962,-1374894655,-1397788352,5709251,-1901958618,-1009501430,-1424544684,695957528,2014240732,1831113925,1268322045,1735805310,1321435823,1917327305,-544594833,-1535041123,345095138,-10283889,-585387528,1542297245,1147545773,19049682,-860794353,-1478939253,-855562111,-1012826251,193636893,-780561393,-204719742,-1742954707,1864575395,2056994387,-1601301313,-222837279,-2120942915,598161842,1851133279,-814769839,-1016028691,753687062,-168842681,-220389881,-616757686,-1345314175,-595027308,101052042,715933038,1490900217,683365027,2052463461,1224295378,-209196495,-60330751,-1334296694,463457497,555557325,-1679219784,2041205557,693902902,1359991978,21894837,1862741638,-395948408,-73118229,-981268814,614395684,1921316718,-461367013,1075487176,-1365047878,603989388,1387772412,120130261,300874821,-2063740788,1626016567,-1085308851,-827017096,-17447418,-917487886,-1464436611,1724362312,-1453987707,193350376,-1987800268,-744727331,-2120054613,285062776,226551122,-439635970,-1253572557,-2002524023,-911322619,1320867157,1401720496,-1904474996,-8928969,-158290696,-892672039,-928988212,-1042267442,-1251433734,-197313878,-1403690361,907772199,-871119086,1156215586,1903029076,-1834719893,-521009902,-890582549,-2057251702,1647729087,1986798438,-652096612,493286789,-40784745,-1634634521,-868071160,-1452390910,1132656718,-542522459,879659758,213913121,-1143774619,190594375,850105857,-1153399757,-1434651726,600585921,-1806794826,1290256,111203745,461361249,1991631964,-572658143,-1947066229,-1200342865,-251976609,85831519,-1984853372,-298300774,-792110182,872798616,566183199,-744090123,1850850715,-827407782,1228628644,998892972,527656870,690909980,450258893,-1848068239,1269234030,65483246,-195975419,-816709458,1735617893,-1753200588,1769285539,-208947691,400541671,-1735345770,-141760343,-1714520092,-33706584,1984958409,-1783970602,-1227046661,285807492,-2123835121,1812815958,1106511226,1094176893,1332234666,602105751,-879323584,-1338493442,-867737485,1151675085,510083844,34965929,1540640394,1903465007,-700330748,772073777,731275067,549525481,-1464556589,1792772013,-472215350,-346376765,1374392781,-157640650,2083914859,-1727958478,695401741,-1242331812,1746508744,-1841701304,991020230,883272713,-190902260,-2027660845,-867746674,-2051056687,-29066961,-279201785,1579754429,-2096521230,-451300677,122201291,-724951197,1233028348,-393053430,232453103,1627204924,2090083297,-162334962,373995001,-1507687754,917481606,-291742274,849458656,981503696,2061145215,695421692,-450718882,1088801648,-1988629598,104708368,1599406886,1146439872,-2146654670,483977982,489601416,-1870487180,819115451,-143788790,-933870624,1769800042,550924475,173001685,-1488154738,2093070767,345316843,-73473617,1783753770,550121309,-1575151479,-468128178,-1262489367,-1302459887,-1491960604,643075688,-1631875712,1237688669,-884577694,-280797912,1877609556,-41523621,1292948822,701087618,-478464266,1047355268,670952813,-1496381628,-1163978113,807303541,1633288733,804252287,1787216182,-1865061148,-912369954,1680937014,1729395236,-181088084,1934852564,-1604488790,-1472747842,1663107083,140663188,-1164380541,-9130986,-76563549,-531631423,-1588764699,541111058,1377803040,986107697,-98275512,2081447734,100339427,-612619954,-1328494041,1245198066,-706825143,207591082,-1133091046,2089873523,1054579677,1363614283,491852922,1828844270,-1353566814,-198066098,531576170,819729828,23109765,-2130544844,-401368951,-2121078086,-179013307,-89312550,1025400823,299179778,689851950,1895730678,-1942421,1896052292,88452924,-828734518,698155150,-2089573915,-801879776,74208312,197839653,-993111965,931096940,-408417892,-106393066,-545795297,-75933120,442586427,-101195975,272172177,2115064709,-2123420229,-1079913200,-222429158,126454057,1254194707,-1302787186,-391054968,997483929,1010536629,-1734669360,-1492144431,367282362,25683909,-1886720847,-1377531842,-533091648,-740541816,-1151565421,-576031933,410132373,246213665,2075991378,824251199,1651731080,543797294,-1553143221,-1511229712,863074484,1195870716,868974223,-323445425,867648330,-1237272509,-2089381378,-1099172061,-803488862,203059031,-461237148,-1487880065,1157272218,478051925,118421936,708188906,1137644953,297137431,-1959189165,1745196992,-1389975084,1899983398,1232006738,-557163444,1554208197,754463450,1073977961,-172649908,1302963390,901191264,197758002,640458947,-463374663,488848545,-611022530,-435945315,-16057121,-1295209741,-1663718893,1229685309,-368612871,-1429469772,-22347852,-33142279,-662067586,-1386361500,-1752601979,1584749249,-2057693399,1283512593,494393493,-1221011958,-1343710210,-278171790,1128523240,898482188,427418756,-125336055,-1015682568,-1179017889,-578620230,725135694,1116841954,-400874022,1752033108,-1583296240,1451380852,997855343,-1154905054,460776673,1183404425,794644556,1204542628,-310673982,-1749096492,113701052,-1395654528,1625390981,1476519247,-1883219761,-1114801871,-1818796611,-1036852330,-856093439,1227109658,-385183139,190702893,-1713788412,1462565159,651370130,826732968,-1822381794,563019339,-1393841537,-289436596,1084512422,-1142645099,1109206338,1625082690,-794783772,-1337091566,534006898,-979744981,-565305377,921136906,312499672,593365667,787979968,-648417186,-220195451,-1102495479,524079126,-1128748991,-1481750853,-332265793,1991552452,1594194195,1366061370,1737762607,1679895675,-924189279,-635874090,-1004327182,-992250356,-1736825436,-1697415527,-1997815526,-999496945,-4127954,-172223273,274801589,-1609722953,-854279663,893538196,-404470057,-953249016,-847291491,1725423503,-922470496,134553880,1502744773,1921408156,1149213284,-1957823196,1152949840,210522134,-1467000610,1253042736,1348962166,1904259012,301361360,1304913534,-1027499589,885555807,2028886857,-908545779,-2098874020,-415946593,1836618826,1231722043,813334818,541339738,-1091121809,950583329,1617303652,812221237);
/*FRC*/Random.twister.import_mti(28); void (makeScript(14));
/*FRC*/count=251; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"(?:\\\\1(\\\\B(?:^)[\\\\n-\\uc8dc\\\\W\\\\w]|(?=6)\\\\d*?(?![^]){1,})+)\", \"y\"); var s = \"\\u31af\"; print(uneval(r.exec(s))); ");
/*FRC*/Random.twister.import_mta(880176732,740831908,221665190,814238031,190314184,-137006685,2065480701,1370903308,1787622296,-996836551,675633540,-1978338941,-502643230,1025410336,-740666589,-552193476,-1601850709,-961125047,-1847795126,2042015531,1644124710,-1293612645,1908518086,-1628001437,2126850606,1881481120,-140634022,859262803,-259941765,396229382,972839444,-339667449,-273844940,-1851580112,-192144252,643701075,-304503574,624511267,2106862668,-1441046012,-1414930128,612855470,587054784,-552012065,-1513620180,1467161222,-76056322,883257380,-803495796,-2046699883,1129715071,973773757,-438476978,-110422686,-553313025,-847537840,-642633712,-1108371053,610467678,-2053133087,2118718136,1748226414,-460984132,-746557464,405839663,1380331078,-1005566144,1177652766,-482376998,-609700591,-395445495,2100879883,54977751,57713670,1353457310,-1533389918,1884460588,2137559242,-1923280354,1803661345,-1725118647,-335712210,1106220668,-1397478639,-667864989,-1092863951,-846438678,-565481138,676184042,1792598750,-185414432,-2098149072,290321680,711959686,1265927169,45594368,-514509426,-1629429414,-414761767,-932702689,1967975891,1167954756,369635861,-854467829,1081030769,2024086853,462450572,1556171412,339576624,602090929,571277805,-376855804,201552515,-1350972009,1346074282,-1985494030,-905583469,-509482015,608855000,1925288736,-1067482722,142871539,-979266240,-422279148,1632935770,-2009156229,2019695761,122801325,-1789286881,93778005,-473561912,285179010,-1935526480,-1481776264,-2132410649,1499350603,1753398774,-271386683,1974951218,-311951380,43336001,430883932,-1209271212,1660528209,734137182,286796511,1036895470,-2099526380,-1808974888,-1292803998,847057289,432086013,181342875,369977608,-1730638533,174398054,577100799,-374609657,2069847797,-879462640,-1330782464,-1491330865,1305763508,-322855979,1154624106,-1491557897,283030942,-903659545,-1470566855,-1107055518,-1919224186,-622764432,-764453641,-807698587,705430054,-1443814453,1920394334,-1346115678,-2001369680,803929107,1658937042,-99866018,431350800,427453033,956624849,1714421713,-1290454591,-1881816228,585085771,-2071374510,164747236,1949385299,-1057115440,-1751061652,1331483329,684083019,86762308,-344541164,77784606,-239943158,-1738562702,703271500,-1896118090,114290721,1667129636,2140049379,538752472,2134151875,-311456604,-2044228134,396462912,1161907153,738597465,1948108982,1862256424,-410588026,1295626464,1581455136,1734890304,-372218228,475328482,-124507491,711135105,-16837273,-1561322962,-187613045,187920667,-2087704173,-254176706,-939197650,-771920961,-791572040,-217205535,201367216,970129089,814620500,1296197993,-1734417503,1681170321,-983751473,1501770866,-836853259,-793804305,-1273853147,1389749872,3672365,476435356,1611449041,298150598,375958673,1950854414,1963265588,-1651032914,1465086863,-506454913,-53885264,-179093619,1964729830,-1790983981,227394063,-1686748325,921357350,1859817617,1952807090,1396701448,1567502065,327695077,-1944205851,-1401000518,121042400,-2029720544,1525480906,-1406582977,-196814468,-1398340561,-34502711,666054493,1752626173,-201302022,1763622924,1879256649,1381498313,555674201,-396396427,1363833773,-710965401,-1093476102,-1722113966,1689479287,691289829,-914772666,1815892683,1532674402,-1718049501,-982783803,-646968612,20064551,-1907464882,-1494220996,-445880161,-304756518,-1498398817,-1524720549,-1680408658,-1513852304,1043377520,255783519,-1385825588,874035462,1905328354,200706622,-484946972,1827787282,-560128079,-2061720307,520327477,864565294,-374174840,647312336,99897454,419360041,721838521,101466833,-1572083450,-1320525623,-982673223,-932297466,991991980,1258999680,508125871,208679177,2077868788,479083701,1865346873,-710753770,-2012032507,809855606,-983208475,2060164398,-1463504245,-632210558,-648621605,27393897,-1207331916,586589002,-462563825,558411090,-1820997974,131714355,944502065,-1015562971,385167822,-3427503,-542531741,1641653766,-2118288930,875260718,-1125078262,-1710671125,-1614432750,1676336792,1105359490,-251922534,-427952106,-627992738,2111695680,-1985424253,1888340314,707066190,-1921936382,458254011,1005368203,1157888384,-715787212,-2031425058,275378246,-850708887,-691897209,-252816830,-1017049674,1177366657,-1311293269,-1911632607,527952987,-1750874468,-525702821,-433429577,1909263052,-1040186442,-30165937,-1427222400,1525225959,1079535889,-1766078289,2072511005,-1494195196,-2004658923,-1707873193,-1594245545,-1648835006,-675973705,-1279991109,-1452271535,-1619552059,-284519681,1796671949,1388078462,-1519992330,-219765281,221954823,553987218,-1610780357,514737395,-1313345953,-1466400071,1980838668,473445759,1640756084,906455119,1544578973,751793026,350447223,454181765,2046798415,499507524,2032028478,629856328,1034746929,-117497637,687575467,-1619995101,1015974828,114397166,-86982253,-1017340651,-196933277,-226496226,-753727149,-1034669228,541826993,-1097683199,604889973,2119020475,-738953625,145838911,393512480,-2143388728,-655220748,256484323,-11358060,1621218216,-1624337273,1967749579,973784159,-1817906812,2020038596,-1695367082,-2008688667,-210610874,1944107897,-1554751288,1611226980,-1297681494,217653654,1588308207,205079104,442016699,1807892032,79589653,-1294808926,589628624,1364368040,354616408,-1534400113,-237074299,-1924052816,1651140465,1658124772,228243239,-1189065849,2016828841,378078786,-357179427,1280983654,1338092736,-202698100,391530815,-1634564798,-1124848488,-975004910,-1543743939,2130034071,-1218142624,-184159147,1282613315,2065434732,-90471391,722462723,260767504,-746831643,307187039,-1058810096,-1419812485,-176215360,-1639649726,1873142961,-1772741541,-407866660,1238079180,1995089830,-1612001332,820740441,-816224415,-1301409096,1007801225,84515979,-320847723,-1481058533,966789740,2048004755,-1382729778,-1319298193,-912235948,1785921821,184278438,-1149552339,836741680,1469698241,-1323395143,-2030341623,-1385479857,-300220006,2102646062,425128479,1142814161,-2129593474,-277242790,-868710791,870012389,233350105,568928750,-510738560,-1299289916,-282166681,-446800246,-737411172,379445031,6133245,582366518,-809267925,758549734,-971659537,-1522551574,1284815507,1512966669,2070194721,907617629,1414986752,875816141,-1488211969,-1727967223,-1898875501,-2126316311,-1193091080,-769744251,1449616641,1220282518,477965273,-1765230128,-2030756970,1926627382,-840494902,-1623752467,-1748852476,-1144783305,-1390711173,-1823222829,2114712362,2079955877,-1646648280,-1111219099,769963220,1440511565,1885244323,1204709970,-437666948,2081623206,-1294794851,-924054650,259594829,-1126375460,1886061802,508207812,1981794706,-1695639998,245818014,-915209074,-1366172154,45063621,1731998898,-789378394,-457791754,372234317,-653485562,-1282045537,-656567815,-73311660,1322648809,-1758137452,912699683,-602202709,853302247,1565425922,-1487356135,-1688261028,-1262728813,1133399949,-1294790639,1254818250,-970211463,1407653984,1270550063,667686209,-1833409989);
/*FRC*/Random.twister.import_mti(69); void (makeScript(14));
/*FRC*/count=252; tryItOut("mathy1 = (function(x, y) { return (( ~ (Math.hypot(( + Math.pow(( + Math.tan(x)), Math.fround(Math.fround(Math.imul(Math.fround(-0x07fffffff), (Math.pow(y, y) | 0)))))), ( ~ (false | 0))) >>> 0)) >>> 0); }); ");
/*FRC*/Random.twister.import_mti(185); void (makeScript(14));
/*FRC*/count=253; tryItOut("for (var p in v0) { o1.f1(i0); }");
/*FRC*/Random.twister.import_mti(205); void (makeScript(14));
/*FRC*/count=254; tryItOut("/*vLoop*/for (hkvxud = 0; hkvxud < 47; ++hkvxud) { let y = hkvxud; s1 = Array.prototype.join.call(a1, s2); } ");
/*FRC*/Random.twister.import_mti(247); void (makeScript(14));
/*FRC*/count=255; tryItOut("/*oLoop*/for (let yjozlf = 0; yjozlf < 39; x, ++yjozlf) { m2.set(p2, null ? (( ''  *= new RegExp(\"[^]\", \"gy\")) >>> [[[]]]) : (void options('strict_mode'))); } ");
/*FRC*/Random.twister.import_mti(412); void (makeScript(14));
/*FRC*/count=256; tryItOut("mathy2 = (function(x, y) { return Math.exp(( - ((((x | 0) ? ((x ? (Math.log10((x | 0)) | 0) : Math.min(y, y)) | 0) : ((x === (( + Math.tanh(( + x))) >>> 0)) | 0)) | 0) ^ (( + ( + Math.cbrt(Math.fround(0/0)))) ** ( + ( ~ x)))))); }); testMathyFunction(mathy2, [0x080000001, 0x07fffffff, 0x0ffffffff, -0x07fffffff, -0x080000000, 0x080000000, Number.MIN_VALUE, -0, 1, -0x080000001, Math.PI, -Number.MAX_VALUE, -1/0, 0x100000001, Number.MAX_VALUE, 42, 0x100000000, 0x100000001, -Number.MIN_VALUE, -0x0ffffffff, -0x100000000, 0/0, 1/0, 0]); ");
/*FRC*/Random.twister.import_mti(615); void (makeScript(14));
/*FRC*/count=257; tryItOut("mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var imul = stdlib.Math.imul;\n  var ff = foreign.ff;\n  var Int16ArrayView = new stdlib.Int16Array(heap);\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  var Uint32ArrayView = new stdlib.Uint32Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    i0 = (i0);\n    i0 = (i0);\n    {\n      d1 = (-1125899906842625.0);\n    }\n    return (((i0)))|0;\n    i0 = ((((0xe0bf64a9)) >> (((abs(((((((0x4502dbf1)) << ((0x257c10a7))))) >> (x **= x)))|0) == (((0x5f7101e8) % (0x76a9d24c)) >> ((0xffffffff)-(0xffffffff)-(0x8cd3d3c3)))))) >= (imul((i0), ((((0xfb5b0c17))>>>((Int16ArrayView[((0x374eb0d9)-(0xffc6a0d3)) >> 1])))))|0));\n    i0 = (false);\n    i0 = (0x337119a9);\n    d1 = (d1);\n    return (((i0)*0x54b88))|0;\n    {\n      return ((((((0x9dbae297)+(i0)+((+(((0xffffffff)) ^ ((0x252cf2ef)))) >= ((-262145.0) + (-536870913.0)))) | ((0xb796031e)+(i0)+((((0xae8223e2))>>>((0x93c3ba51))) != (0xcd82534d)))) > (((i0)) ^ ((0xffffffff))))))|0;\n    }\n    (Float32ArrayView[(((0x271fb9d) == (((Int16ArrayView[0]))>>>((Uint32ArrayView[4096]))))+(0xd6b6aa93)) >> 2]) = (((!(0xffffffff))));\n    switch ((abs((((i0)) & ((i0))))|0)) {\n      case 1:\n        d1 = (-33554431.0);\n      case -3:\n        i0 = (0xc9f3c6b0);\n        break;\n    }\n    d1 = (((-2251799813685249.0)) / ((d1)));\n    return ((((imul((i0), (0xfb59756b))|0))))|0;\n  }\n  return f; })(this, {ff: arguments.callee.caller}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [Math.PI, -0x100000000, Number.MAX_VALUE, 1/0, 1, 0x0ffffffff, 0x100000001, 0x100000001, 0/0, -Number.MAX_VALUE, -Number.MIN_VALUE, 0x100000000, 0x07fffffff, -0x080000001, 0, 0x080000001, 0x080000000, -0x0ffffffff, -1/0, -0x080000000, -0x07fffffff, Number.MIN_VALUE, -0, 42]); ");
/*FRC*/Random.twister.import_mta(-347561513,1716645192,986048841,916522274,-1419970625,-1302239743,-1702859213,2066778769,167245516,-1407051595,-1568159838,409258213,270364004,1334538205,-1554067674,830417808,-892607936,-1119817587,651851651,952565085,-189123195,-475324327,-1575971409,1584611723,2045747545,1016518877,318810985,609233747,939562270,-1826043687,-2121332115,565875154,-2140112036,-1001397233,-2146990019,602638470,553347243,-1885038772,-1323028648,5829760,-37650834,58534847,1696180787,1202751553,-2033564860,385549691,-1669342038,484940521,-66738203,-693471709,-672247156,564151122,1528404549,1908536099,-1632136527,-660430056,-93796059,1621114770,-1108169539,1845892030,-1554564576,-986145824,561956236,-2865742,-753928887,-948415555,303978714,1896887051,-674090012,1287551811,1672656035,-654474797,-1715048628,-1298089173,1165419102,455256421,529972611,1178597053,253526489,330807456,1498711056,-1130654332,-1460383033,-357046939,679663771,2146170152,-253585260,-2123555021,1306228897,-735731187,-1710177482,-882927949,-1923209102,1484178585,-881536728,-818766523,-1796180947,-1443769039,-513346081,-1003862336,285854535,-1620545573,-599565866,-1923591332,-2119636063,278767713,-794728123,-74715436,-1809333111,2022470943,160180220,927905494,1504772179,-1757843101,1280826380,1361957726,-1066827307,1270701950,-977448435,272171197,-935697558,1563560691,-1539857075,-1697163499,-401079432,-181626944,-1181487697,734549153,794473987,2025263411,-1039455773,-1586285227,207361871,-1290841809,1799374992,1903606990,86191871,1451221643,-527678328,1977752280,-1320112224,195412648,-372376153,-264549824,454412948,-537555279,1023222909,957649141,1337676533,-1772215979,-571295704,-1608274462,-1671853307,-2142637563,1501256931,-1258736879,-1342295732,2124503973,662773901,-695211080,-1511418001,2085276077,-533419077,-192110957,-1268454977,-1586307045,1517877601,1486435854,-1580827722,-1546765329,978002937,194648226,-589538181,204805807,547336309,-30061947,-413662621,-2023173360,1609395680,910197404,-1339516544,427158096,25719017,1278776275,1086891097,1498952856,980896108,331392673,-623303791,-1252989950,81746710,103371638,-1669878818,-1672856784,23221817,815951891,-144875056,1352243373,-1853277747,457606975,708876201,-424349112,-568989472,-1101981803,-1350887885,563550361,2140768905,1430508116,-92149585,-1173902476,-415497208,-1725481119,-536256782,1785796223,1687879138,-1557932699,259218283,-1515956032,181742152,-688056163,-268414400,-297104170,-1429453574,-779663032,1644876653,-1739588754,1063182705,326132993,282117845,-17401199,1313686831,-291001685,-1421354625,579677344,-1782154692,-1726758326,1544672021,-22735511,132039986,-1629063353,-703114492,-1456725188,540566558,1869771125,-1279726007,-46767183,-714607488,64956679,-1685386653,1334810039,1332640371,1355907585,-304584210,846468246,1290332033,-1057716711,189379499,821321598,-2097223379,-548297627,824259446,-2063566628,-1232163595,99614433,-1218077270,880424530,-1293451213,-1248217844,-791475608,630865290,669296890,-635405063,-1400026118,-1076255605,1597073291,1339691902,-1512730457,-210082643,819416509,-787121405,1238089165,-2064899038,-1634813000,1514735449,2126815001,1883738355,92311141,470715301,-629754121,769115793,-1919430199,-776278933,-850001233,1406693036,-123566599,1996123416,590281537,-2123391004,-96616779,1616842196,1877224753,-1945187635,1070392588,1268946458,-1599065435,2143266159,1965340184,1938192932,1012396220,799656514,-1174649693,-326070381,1134000484,-1772774100,-288579383,-1742144197,-764043756,2018249978,-1450258114,498338525,715571017,-2147407558,735457211,592182731,32681329,440189472,1258345775,-1915465666,-1500629719,-1223878217,-199003992,-978541730,-1317900290,755245977,2101110221,1608409465,-1232309468,1146625176,-1526910928,-2121013543,952227417,-2097898811,1414221895,2078567892,1037819559,2114933589,-650466721,505157360,98014873,-283814641,-544957656,473064049,742122836,1817959484,-275364263,-1183811532,1564618918,-1101167913,1779954678,1714162846,1005016358,1985377151,-989727401,1698134411,1128271232,-952962868,1595725472,-434397369,322691966,1757294549,-1719748296,-2122563041,-1989216080,-699692800,1618715350,1574594085,968348020,726584776,-11655814,-2139013614,936721427,1688210303,1488817422,-1005291103,-34577620,-170051697,1349483478,1720022791,316716264,-406939853,-365685149,-640118552,140636230,475648707,-343518621,1442763257,1727692474,-145329908,-1745639678,911576311,-739352333,-506935403,1349169120,-288029176,-1573610983,-559033569,-17616807,1568372007,1426289045,382993761,-1109256274,1787701912,1679849823,1076331579,-225129564,-556389146,633119124,-232864970,793655403,771660226,1904347305,502680950,1442923150,-985333319,-1681104979,-1865927627,885996790,236128099,709726542,-1046980847,1204907101,659754935,-83630416,-1785428089,-46942906,-1694909074,-1339183282,-1883956040,1161516717,-1338244769,2045358892,554341549,1354756958,517732637,2089372551,2050732427,-228330806,900027856,1061423721,969180112,758411472,-995490749,9573574,996321933,1962713373,-775131135,-552481593,-1613380788,-477499507,-1973210664,253846022,-1056542165,316228760,-282310619,-1466583261,1117013877,-2067916399,-1707643606,-1953001966,623611194,-813489322,-1192881535,-819905262,1536339825,1504462057,-1155654112,-1376624631,482282245,-1838227837,-532928110,-1675545554,-833746155,737213998,-1882059654,-1461796787,-15302563,-1353879430,1816130068,1031042306,1355988876,1830965043,661193449,-826491097,1587541659,1995143126,1698335184,653989367,-958172984,-287455108,1187246271,-1171497829,1639469145,1117531306,2026891199,-1627419147,1481400293,1768652790,-176952811,-1722998462,1628744702,1009940557,205241148,125448431,599796979,1843643061,-1605175735,1326892823,-304834183,23201893,-408204023,1618362447,-570418180,207909970,-672375368,264592943,1486298451,1074602514,1184010009,581462626,-106112548,-1177880553,1290670677,-879291363,-889506144,-75344935,437869738,1368289038,1010902307,-101703105,1736989384,-599719259,-1239230011,-1383833636,-517513750,-1288442736,516168572,1559959008,1191346108,959562446,-768365423,1689725384,-1773100038,576823276,260015352,-922522976,-897724197,1153648725,-938549044,1919178515,2142088554,628965071,-1783408342,892109976,-1734785809,-1028942586,-1512237936,469970471,797738841,-370479906,-614684749,1915259230,776861503,-406194705,2012971852,-1603612687,-1145551130,793062164,-576594401,1390797521,-1638548747,963123340,2069605926,-408839096,1640857580,1678203413,944464386,-412113551,90046220,611811175,-731591381,45188686,-755982288,2134856135,-817687904,973397596,-1190590986,1558901350,821884851,-1776174878,2144376787,-1929757986,-161544533,1876584701,1977986459,-1558516035,102417512,-644565024,-1588328926,49923046,-724927097,1638212051,-486826797,1096215322,-148594253,1082584124,-1519196903,193911574,1888131581,-1063440473,-1088914433,-2046356351,280196847,1464036935,-900292978);
/*FRC*/Random.twister.import_mti(66); void (makeScript(14));
/*FRC*/count=258; tryItOut("g1.valueOf = (function(j) { if (j) { try { s0 = s2.charAt(v0); } catch(e0) { } s1 = a1.join(s2); } else { i0.next(); } });function x(c = /*FARR*/[...[], , \"\u03a0\", [1], ...[]].some, b = ( /x/g .__defineSetter__(\"x\",  /x/ )), x = this, x = x, w, x, z, window, x, get) { \"use strict\"; Array.prototype.pop.apply(a0, [m1]); } s2 += s2;");
/*FRC*/Random.twister.import_mti(347); void (makeScript(14));
/*FRC*/count=259; tryItOut("Array.prototype.shift.call(a2);\nlet (w = -19, e, ijlwik, b, z = let (b = x) window, NaN, \u3056 = (let (z, x, window, lfrepi, x, x, adbpuo, vepibm, x) window), x = new XPCNativeWrapper(x = \"\\u497E\")) { e2.has(o0); }\n");
/*FRC*/Random.twister.import_mta(-2072082520,328852345,755306086,1598598131,569427018,-2078136282,172356511,-1496358529,1370779546,-1347366008,-2008964726,1561184039,-1474756016,-1404211139,842121040,1095075967,-2020651870,955334842,1539170967,-2031547511,449045445,-414268829,-607155752,-729978662,-1699376697,-964057115,1315284175,-2016668382,5562502,-318764769,1590579082,712355040,985077193,-1629874020,1990642676,1920393786,-1840853983,-1516133654,-623524050,-1899163527,1459829176,-289459349,183301536,2056032910,-209738033,1585454347,-912227146,-612161366,-2006566331,-1718297716,1702196345,-1950320748,-1741895010,-1150875305,-1459923505,-458309493,1261614404,-217233508,-1496352290,-826650153,-45510980,-1288270517,-1249307903,-5363587,1001581354,1540778229,1319952767,-2088980783,-1111242229,745534239,792796444,-948651596,-445423504,-1388817799,746583788,1508037388,-511318800,-953502502,-1295662480,-2124930559,49463751,1595688767,208628735,1365829820,-239341183,327266916,1449931580,1463536834,1275912580,-498789919,-1869051502,2077974843,-1511953121,1217931175,-637993836,499922414,-1821397796,-1622098458,120564400,-143179637,1348466682,-2130942825,7330065,1676712340,-1325517642,-205248297,84545749,1306845038,-1123887691,1840081928,-288050818,748491188,-209673328,1511626315,615338643,-1102692134,1176404812,-701113492,1900463816,1795946146,440741087,-1972278756,868767324,343556595,-1533652964,-911920550,453035831,-2124368399,-37477099,-134216132,-1893489300,-40972006,2032386452,-865412001,1951747122,1343108029,2026665786,-876318307,1625838022,1227241694,2039727223,1411279923,529924072,-1848907793,13676098,1794276669,1688577359,233239861,-1931232503,839010804,387164493,-300566637,186639692,-1862125722,354716333,1973323594,-383280651,1137396281,-516283129,-1891683523,790836421,-612978159,-1662823684,-431490353,1543674360,-1055373065,-1261051928,-766990115,1832040888,-668070140,708938504,1586262588,72260667,-76553797,-2006981982,225264641,877652676,-811828991,-1600649304,928081876,-1860490441,-886478214,557925315,-2147157377,1475851370,-90556162,-249193373,-798786814,1659047939,-1526724358,105469623,709667464,-1706962765,-620225139,1403594982,1150411055,1040674345,-1412894107,1839396534,-792589971,61247127,-114602862,-1175409466,1112473880,1067203128,-920773274,1598309553,122858037,1528369618,-1442138652,1959733581,1929211039,955926119,1407737634,1784858302,-1612188048,-436826669,99383576,386193800,1938747958,128966550,-1778709030,-673456293,1846201832,479497048,-1847284192,1525030097,354309149,-1242927378,-752149458,-250360199,-312764374,-714817930,10931841,-364478374,-1498138929,166390243,-877739245,-881439653,-1022186542,-119840349,1647152479,-269221862,123439961,-547176003,823007447,1577988053,-1911630293,427931751,1701839934,1696405765,-1403411152,-1615614546,-249993264,1052698353,-587691636,-176544096,-960918589,-589967859,1646759026,-1671813902,-1259786927,-1450594923,-1980497164,-6506045,1521399784,-738080001,1063959692,-1133367890,421437917,-829154259,-1522990286,-1738244207,1060145068,-59891435,58999497,2032228613,-1542036872,977435338,1707189415,-1190061242,-407107565,277017592,-312980969,1378238266,1023905331,1505076442,1232758040,2094391004,709511994,243003031,-1005495646,842686371,-336260260,-134113187,895223668,752368877,-883461479,-1218756770,1267320375,842500032,1939440746,2083756033,1758809469,570283698,-2007524996,-1197793517,483998105,1221108254,-1986397839,-1104666710,-1871688397,413891826,-1207774329,-2111372672,624307854,-1637673060,-2074091251,-1408641910,700088932,1217966906,354114454,-1788773420,178145979,-1840325386,-1146654472,-241342316,-1710203471,1114790035,2055102789,19318843,-397999287,1011780036,-1566797076,-83665139,-1505432537,260137540,-55957146,-178499065,921237603,-1033147402,-679458193,-2085325264,-1040458560,1882898969,-992795848,604372442,-2119805108,619933764,1544166344,-1016348652,-1299471690,-7807932,-1245489980,-573011477,-1822081722,2116450184,-98018153,-828844203,1691380487,1850299711,-807598522,-1147322457,1500279290,-396555781,258357910,-484227166,806237640,-112604410,321561460,1216181823,1147654682,30915005,345535524,-1174178056,-1875356749,665136912,682933232,-1370150758,-906114150,979010054,964316202,-828634299,-1746950045,-1607638751,-1995597588,628439137,643002033,1906395479,1894902034,-1968459077,405955035,1446777161,404637190,566194430,1582270181,-477808766,1639471241,-1666317160,-1263461219,310588078,-529877678,973588229,-61008105,969023569,1189687131,-1058771560,580002594,1498142741,1068517396,-180097229,-51431398,1132546620,-932185679,-1089966735,809320649,-1676711583,-924386723,1018422889,998794296,-705479882,2024376737,-12857044,-353767136,2057590944,935684301,1321417219,377505328,1089460165,1125165623,-923912676,35506528,450686586,568172050,1244558466,51365493,-305120328,-1889914172,-202646289,1141809137,-630872661,1111310097,159562273,1119525071,-1577512702,775233773,693917918,-2130351491,-1994830798,-1052645581,-715686122,1558020411,358435769,-107938688,-1527718718,1131034706,-1665008248,434080096,-1469447994,-1829499019,-1188214965,-1557519850,137011714,-995589459,871125110,1344401484,-1912005305,-1122982230,817384386,-936013391,-1038077242,-1192075468,-976224336,-338641538,-1820206789,-697288516,-1306054301,-182270309,-599281159,-777832519,255251077,1799789030,-619606095,941487705,540703538,-1955367376,339244408,-2099241357,-1669303657,101726931,55063391,1103779471,-1393951622,-277581548,234354788,906434442,980359609,-1174734829,1599097778,477815043,-689692833,-585091264,-1494548023,-279564512,1362689365,251118897,-965680782,-172520473,-1758044692,-1751941375,-347760759,-929851502,-1242617707,-162728609,-1067733277,-2108289656,-2052540583,-675128710,1858882809,-620114085,-990568798,-1103912332,514468264,-231595227,2115259631,-1755468201,-238538396,593736433,1330636932,-1176611627,-1750403960,-1656820637,-316014036,1548912160,1372952524,1611634073,246537023,467189354,-474718121,-1350349441,2048593850,-723178130,1436909691,-939859500,-885134157,-2106302854,171687354,1409307229,-1526055679,-415568080,28711750,-1015147776,-1139232124,-719528508,1713767683,-1189393306,1584992547,-518237331,-678308356,-1208441220,-1471857031,-1584063167,855703183,1859430599,-1371233490,576026059,-1205466352,-157409895,589736297,-90164577,1339398016,-623474639,-1087446370,-1388827907,-595954625,1934747086,-338541544,856785315,615108371,-1556295678,-2006023209,-301447217,-477920592,-718443939,-435294826,1680323890,645829761,-444966317,2095566860,-87688064,1880367586,248123847,684176326,-1105123188,747288371,-1757629899,-1839437710,1131260494,-1568200404,128623826,-155236434,1424421465,868365729,-1356797807,1807342020,-2103479446,-1722300277,2066113525,-1978154442,658910067,1068160725,-1064954708,731347178,1161186943,-1377653534,879109340,-776202957,871208375,-558437125,-1942541354,-917549650,-1827244286,2070202786,-1581616042);
/*FRC*/Random.twister.import_mti(10); void (makeScript(14));
/*FRC*/count=260; tryItOut("/*RXUB*/var r = r0; var s = \"\"; print(r.exec(s)); ");
/*FRC*/Random.twister.import_mti(195); void (makeScript(14));
/*FRC*/count=261; tryItOut("mathy3 = (function(x, y) { \"use strict\"; return Math.asinh((Math.expm1(( + Math.exp(mathy1(x, y)))) >>> 0)); }); testMathyFunction(mathy3, [1, 0/0, 0x100000001, 0, 1/0, 0x07fffffff, 0x080000001, Number.MIN_VALUE, -1/0, -0, 0x100000000, 0x080000000, 42, Math.PI, -0x080000001, -Number.MIN_VALUE, -0x07fffffff, -Number.MAX_VALUE, Number.MAX_VALUE, -0x100000000, -0x080000000, -0x0ffffffff, 0x0ffffffff, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(283); void (makeScript(14));
/*FRC*/count=262; tryItOut("g1.v1 = g2.a2.length;");
/*FRC*/Random.twister.import_mti(302); void (makeScript(14));
/*FRC*/count=263; tryItOut("/*oLoop*/for (ttbtkr = 0; ttbtkr < 71; ++ttbtkr) { /*ADP-1*/Object.defineProperty(this.a1, 15, ({get: ({a2:z2})})); } ");
/*FRC*/Random.twister.import_mti(345); void (makeScript(14));
/*FRC*/count=264; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return Math.atan2(Math.atan2((mathy0((Math.abs((( ! x) | 0)) | 0), ((Math.fround(( - Math.fround(y))) % Math.imul(Math.fround((Math.fround(( + x)) % ( + y))), ((Math.max(( + -0x080000000), x) >>> 0) | 0))) | 0)) | 0), Math.ceil(Math.fround(Math.imul((( + x) | 0), 1/0)))), Math.sinh((Math.abs((mathy0(Math.hypot((Math.asinh((0x0ffffffff | 0)) | 0), y), Math.asin(0x100000001)) >>> 0)) >>> 0))); }); ");
/*FRC*/Random.twister.import_mta(-1317266966,-1976794197,35518907,41635979,-495214271,-433222123,1982994295,1360533404,1362183839,-2067481251,-719556498,1296521533,-258064171,-1403309925,1162169594,1078389869,-1810408980,199109861,-1438550574,1214654556,1648962483,1364468357,1370935381,27345674,-2098861428,16888724,-384828495,982395107,-1739727715,564403654,62558272,-994251266,1283303033,-1279437850,992393341,-1963509579,1930252135,658806549,-580780394,-2041469084,554507182,-1231182273,2034816694,2060633619,-1267367605,760412282,796593306,2093137151,1660898603,-1024568771,-2065346121,-988862083,100324167,404907310,-1216196191,1891897627,-1072275634,-141074387,-1119903642,-496682282,-649298150,1806055833,1949019028,-453758242,399091379,-1233886622,1545495834,-200997460,-1625376484,-1716939831,-1632961936,1107426298,127993938,-1809856080,-1811728718,-183693880,-2008684781,-891078653,265591139,1784078687,1134843355,1131984089,-115915801,-1360815462,579223764,-265841105,327159864,104598512,593055263,1551118769,1711611441,393770183,-78341665,800345365,254561400,-1520555500,-1596182553,1314925884,-1800141040,1379983940,546077319,-2039539739,763538889,-828701436,1036686324,2103884156,-911982441,-693033136,2015458101,-249906739,-1543961795,-1359606748,1670841595,1612418591,-676284417,-689936077,-581560087,-1191654009,-1210845479,293769705,-755306636,925394903,1211916157,-692177236,-622773415,-903677204,1804257538,-1711345990,-346182327,-1235622958,1571084924,870189134,115575333,-310357359,741426530,-783533647,-524808655,564248367,1151109622,-1418688037,-1461765972,-327245917,1047400023,980637851,2023007023,-16784893,1476471697,1413775848,-613057920,-1732585021,-100517557,-528101465,-272894845,-768807217,-105819995,293850785,770820103,-810309793,1737254183,-1864352866,1437579962,-1713341310,1574169540,-968592763,403802597,1768558971,-1627894666,-656539662,239235657,-318321004,-640146297,-1207347285,1579119261,200959697,90741486,-1526130692,335455906,-1942587413,687429156,2052546908,1451570334,-318644691,976625122,-476751390,-750429264,35257438,-1122183204,242537800,1990701391,-61698299,-262402281,-389052278,239682201,432059793,-1249226353,-1362316275,852353377,1515965544,643106396,1250402278,2146962439,-25198769,1720525918,-378447182,1885994218,-982997210,897650004,1177899309,-1751504488,2050551026,-615488155,258101722,246547682,177976714,-814354540,-1067151652,130052851,-1503608794,228679111,-764675336,957354842,743682953,-80589534,-955971582,-1679548398,-1893763307,842919559,-1417072995,-474411588,-476271016,1960221854,-2000028038,1064720778,1125209946,-1689600988,-1932754255,941321227,699393692,751701204,368787675,1145390827,1925139703,-1696360162,581863917,-900624303,474927847,-697699434,-1216264353,1676419226,-97457144,395153810,-851690405,2039283836,794310678,351431717,-487534643,-605001480,-187119719,-1246811193,1112585216,1891726737,-152379800,-837994033,-1781816487,1242811617,1852418870,-639305438,1060375929,1662666254,-955619201,676218762,1632570972,1925888940,-2008765233,-1542967996,-949530250,-790273279,-641438510,1860652017,426925796,-218836488,-3987363,-547322673,-1459273517,1880889323,-1847234037,-958920614,-416903052,2122521604,-367072256,-956522609,-673433155,-2087785524,-1189733909,-1364523498,276436917,621451866,-989370913,-1093818306,515558322,-1378677883,856836717,1483676585,-1732572086,-825690947,-896424395,-1120744116,1740637396,-558040898,-1509733326,2144537820,1859387053,1965969203,1385402744,1420238007,745063889,-2024574488,805434484,1134900725,-552026046,624550110,94171538,2031730582,-1443151460,330536256,-327503014,-2042594237,-658643439,576231320,-1273399029,1672492159,1676531478,1814622218,757948366,479977884,1071759895,-816861826,1080007393,1821032650,1117958400,-1831658505,-1771402009,-1239578797,1011075386,-1701749733,-439285708,290568783,-2138876074,422406707,1770635127,-1879316489,-1524279941,-1866248050,-1670496984,-800296935,-1806788979,306543942,-1545600759,-658600686,-1462792091,-898707022,-386438546,-1107689140,1302215187,1712497252,1963797031,-210267329,-1803821777,-1511272935,-2091383401,406892950,-512241874,-189540335,1157665005,-2058348306,-2002260728,-1931443141,-316101370,-2072302998,-1298745984,-829306662,1207428568,-1016812977,-454047672,-1959433431,-1405204024,448871449,-193483058,-1583839221,-1047625146,324399799,-1442369122,1701130872,-1909984247,1861389407,1065413000,80892431,-678484277,2069457210,392096714,1003437176,-1050424909,36646056,-703134123,910839961,143352040,723415245,-483891125,-220595673,-1717609820,-1646082577,-1299841362,-1087983527,2073055675,-815610381,-509037280,19481332,923618556,-183780714,615571202,-56835682,-1978156775,-608678755,1335872817,-659437359,-1740887166,1103609086,-964208838,1191156363,1123696464,-1468023294,2097646551,-712611793,278279957,-558234936,-1586351036,1033237904,1001208781,-194138371,-1165465880,-225600803,1388053083,2016506468,389872242,1752359055,420442536,1273102105,2107422019,-704909105,-1852181847,811825216,138556689,-1277753003,1615167718,-902024524,-304483464,-1351390488,1625529597,1488668959,-85439760,310658641,-547361499,932213560,1642939440,29302458,-1295895896,1265832846,471425802,-810732304,-67927939,2128062071,-1464438903,1772522584,111259604,-591832319,-1544091404,430522266,-525928015,1021646680,-1491150367,452687077,-1603134686,670467134,-873638559,-245269375,-5041797,-634909722,-1484129275,753562590,1453428927,740702401,1550267100,433296316,-1625357040,607618748,-416974323,1124050089,1206280787,-159724030,-1062206244,-422267025,1853169023,-1328789786,561098100,1203191445,1306475336,-90100792,-1183842546,755115778,868941780,-850621670,-1276955778,1942730875,1073573876,-1509058896,-1520437385,-2113945283,680659244,1666215631,-504077155,-435173167,-503442750,-1335118088,-1022882574,1470169643,-970346356,-704404971,-1972043833,-1225404200,330981869,1328335524,-1201801813,-1531386587,-1781004630,-825262393,1089250814,-1410395385,-687764440,-1608849203,136562926,2028013519,-1484952491,261469499,2076522350,1899748169,112782120,1813010867,-1363915135,1979811338,969060917,-2008791012,1304415234,-2030772808,1817955869,-1003470814,-731074602,497016930,142139009,940672040,-1593647127,-454073935,-602722812,-1853675861,-663880471,-2005036837,1889125698,-1595601133,1514733468,842147191,-772322157,-2011152899,-989450924,709209493,-429641585,-114580047,751061055,-1458974855,78098593,-1262797446,1308402106,1919069712,-1584549567,1741722492,1631816589,-772547696,1384740749,58330515,-1273153100,-711617490,-974122563,-739016145,1920039815,1780334177,1010464889,116208874,-322569696,-487665488,151201024,-1566401209,-806585402,-1233430242,96056033,104802719,-113481511,-328788813,1373142768,1443706021,-879089215,-1923333954,1169781242,-995311074,-553724068,397270568,204499560,-1371226976,273560141,24180802,-1526320107,-333667211,29529263,-944975992,323020942,794678179,1550606074);
/*FRC*/Random.twister.import_mti(2); void (makeScript(14));
/*FRC*/count=265; tryItOut("\"use strict\"; Array.prototype.forEach.call(a1, (function(j) { if (j) { try { i2.next(); } catch(e0) { } Array.prototype.sort.apply(o0.a1, []); } else { try { neuter(b0, \"same-data\"); } catch(e0) { } v2 = Object.prototype.isPrototypeOf.call(b0, h0); } }), s2);\n/\\2|(\\B|($)|$\\s)/yim;\n");
/*FRC*/Random.twister.import_mti(521); void (makeScript(14));
/*FRC*/count=266; tryItOut("p1 + '';");
/*FRC*/Random.twister.import_mti(530); void (makeScript(14));
/*FRC*/count=267; tryItOut("new XPCNativeWrapper( ''  ? new RegExp(\"\\\\b([\\\\d3-\\\\u0080\\\\S\\u9783-\\uff8b][\\u4932-\\\\u00A1\\\\x0b-h]{1,})?(?!\\\\1)|\\\\2\", \"\") : length);");
/*FRC*/Random.twister.import_mta(194107329,-1554045640,-1888750768,-1812308985,729661030,-532768820,-23392869,-2015739127,-1813934439,1099974906,478376970,1402890898,1455059510,-12557422,195967047,-1255334737,-1485310186,-633176294,-2053398258,-1459263502,-2035290783,1155031651,610303623,-34720552,-896048941,1983316378,-1949275745,1302304320,-923916959,1075508446,-455532091,-1177945752,1529124515,1826902755,-512448686,889749315,-1707291584,-267715197,-497358858,1829992519,-1175758835,-2000042586,518632766,1908402855,68517478,1871508521,-1336601390,-1073350971,-1586435991,-1868830947,-2045538014,235809203,-1651982274,-1297424305,-383218365,-1814288654,-2105114577,-1801198969,-1662292461,-1009429147,-1942474514,1655610581,-929934433,-1066916393,-999957484,1503609269,1542440678,1311785524,1730038675,69627574,2098831095,-864177959,-235117403,886455598,-768546451,-1265840370,-86473974,39561071,265603204,-1586256472,1477579522,-1721366924,-261155668,1270371471,23683306,1849068578,-923578215,2042981201,1216461180,1881289761,893220537,-2008510482,-1737292054,732962557,1321740246,-793430896,-131132530,778929460,-1912272081,-877582027,-572958338,968042553,-402815394,-1204683115,1355170241,219600498,1244217052,-1565575216,-329590927,844438153,-300615396,-977201760,-1697675260,2140954682,1100724024,-2073557808,-91637272,1693244675,1955991388,-1467828601,-368145896,-565775954,-894730293,309847458,-2064683084,-978398599,-805864529,-1157143472,-1660599963,-1194209493,-1818493984,747414805,-1133315974,422864917,166943148,1307333346,1543530978,-327075268,-866364980,-8351919,943092518,1713725241,-1944923012,-576461177,17444235,-90337236,1374123930,1551984137,-739428586,-2011564599,1207835021,-1730884460,-908298867,1838436497,-1669948531,151292260,-762663571,788447854,-602099175,2001222975,76079296,1459122634,455628404,837752220,1907267174,-1627455344,-1274871024,1448352032,1176150536,1426173327,-1622874986,-1003148058,1292029732,-1969983350,-679303510,1673199300,2037889957,-1386803549,300939409,-2108992202,-1422921880,-375377013,2083917131,465568712,-528396434,2036267154,645521705,1940435944,-173506352,-497239353,-1065681423,196707773,1343814570,1346247223,-1138781858,-1435238898,286760525,365410244,-913951277,1142580844,-1355535752,-773583000,-78326113,-833640597,655221106,1560260405,1127116944,-408289153,751044745,-491931960,-1943338708,-1979366705,1089776447,-485083692,-1093889998,-851093618,520096379,1906090652,964415281,1576595951,707222798,-779779356,1648365742,-1973493887,-842538021,-280259521,-794789525,2051887391,-762220012,-184500961,-1751211206,1959170723,-1045021599,-214019191,1488237198,1457817667,1430764468,182743648,-1066698208,-309304932,1595372854,115340488,2104682630,458723297,225289910,-1364240187,1808626818,-145097428,2042631271,1873196622,1115200042,-1236147987,1637555601,413265746,-437304967,-1525280483,-1552013363,654705913,-656301208,-95642444,1469136343,528124778,-421192144,1715313391,-952227816,-827810969,-1417556444,-2006549750,843333958,1255053051,1092119945,1030759344,-223997295,-498007440,-1548329346,1342892342,-59125388,1751680005,45549249,-1527600958,1413727422,529563643,1582708292,1669348101,89779037,-7902658,-1337582241,-210125076,1470229205,853847175,848202198,-2052937230,-1675821665,213534189,-1626998479,1973094078,-1079153530,578767592,-2095000320,2115850680,-195581753,1729090662,-1194243797,78924171,-31734614,1364045346,-762075198,2001497949,-899178387,-1887006014,-438756602,-1560873044,1199522974,2074635805,-151406234,1260913032,673369627,-1914217316,-1480265777,-890243451,696149556,1917122589,-1001876386,-1309222610,407952537,1412269521,1055353570,-1930095950,-1162402717,254618814,-1983441634,1725053380,461404565,1147457042,609707524,-872611378,-881694938,-665740935,-460305120,179221792,-1381919082,-2086812594,-632692659,1858709306,369383705,-1523162460,-1463608020,1066438622,1938464458,1415462127,-638713920,-863057933,-1952854803,1054471036,1747492809,-735576122,808025968,-3883671,-505160200,-649752413,1833950498,1460558090,-1305739468,1862875344,1326391280,1827612812,750113049,-204790539,-1098781395,-1070429001,-317193968,-497323684,18180229,1397717997,416452749,211142100,-24272054,96701624,-1046505900,-1365995040,242197117,617381493,2071162176,236496934,2028070538,141860042,1299442264,-850652134,910110953,-880140304,619482451,52170586,14961227,1517483488,1234464228,-579126320,-405893579,-488091637,-811968253,1357205784,858596492,-1768607490,-776352463,-1151720650,-1458389289,-1654099928,718787020,1263248036,-1519411495,-1412440221,1115880607,639281053,-1650564976,-1732234481,58517880,-1254350422,-103146311,-83943238,1507977788,1851169637,-1942129052,1221265359,1421125705,-1538798854,1507435013,-1452938324,1733938673,1430476770,-258404160,-278197858,700764767,-1798937158,-1917057952,1819505140,-1223484835,1913582145,1718852593,789931661,-683576901,-1598368114,322995238,-2100025088,-958715209,-1305359645,2098928200,-2054979486,-96593007,-1714285130,4311919,980528270,393704918,1294260142,-1620487092,-172072911,211921059,-2060925088,477742014,583776106,1236449243,301772694,1167660484,58493714,1712466523,1436038377,327510836,-1512901657,-476262375,2025975630,-500267991,-1693349022,-1778120454,2042552474,-1375760593,-593925667,-1499301546,890538922,-956466615,470421894,1020673218,-1242687684,144237251,-1240202394,434637682,1120282962,-1042858853,-1242192229,813748841,31720504,-1390218262,1778299535,1208877953,-875044410,-1054402065,-107344518,586970835,-902618163,-264956147,2049247880,1562911198,415562233,207830032,-1143964403,11681676,1185611489,1317476769,1072141093,-129673403,46323519,108331025,2029024201,980525754,-441153601,-528884284,-1556031993,954135944,-1906918764,1722656785,-1708257682,743451491,1980999976,2084916364,-953146803,337576135,1299537228,23827118,1898558677,-1573937532,-1355988821,-1210428337,-1622725511,-2121137279,894371559,463580535,754755710,389692834,1184405809,-469347114,752672703,-421063717,-502827098,-249665304,675009316,1992989247,-1984457888,-1900336888,147092425,1153261850,1384031537,-139652648,-1066749872,-685162705,455782981,-1157049856,486492915,-423410343,-193407918,-1843793119,-1781541110,-279189777,-251692654,711809296,-174176882,1052987237,373563284,-1608680488,1844083318,1737149166,766522610,846123736,122769004,206221712,-634503412,252496444,1298038571,-252044514,-33109591,-1895476128,-1011850883,-1435461842,-1297572891,-1223189757,465622647,2106493663,416322232,260617840,2035706862,-1018491783,126162741,-1392582389,1121619708,-1892076084,-485920737,-335895441,801327980,-978724379,-805927563,-2068636105,1698824044,-2052240193,1512621066,-2003103166,-2100972387,-1459404441,297179596,1831842752,1938930905,307312095,1220641314,1175504520,1495600207,1634190216,859244958,242002430,1515303944,476298723,914836680,1073853733,-873828426,-621414958,590491023,332562855,-953010966,-213052243,2064569610);
/*FRC*/Random.twister.import_mti(320); void (makeScript(14));
/*FRC*/count=268; tryItOut("\"use strict\"; e2.add(p2);");
/*FRC*/Random.twister.import_mti(346); void (makeScript(14));
/*FRC*/count=269; tryItOut("const this.v0 = evaluate(\"((function fibonacci(qtmxtq) { ; if (qtmxtq <= 1) { ; return 1; } ; return fibonacci(qtmxtq - 1) + fibonacci(qtmxtq - 2);  })(7))\", ({ global: g1.g0.g1, fileName: 'evaluate.js', lineNumber: 42, newContext: (x % 2 != 1), isRunOnce: /*FARR*/[((void options('strict'))), , , .../*MARR*/[x, false, false, false, x, x, false, false, false, false, false, false, x, x, x, false, 1.2e3, x, 1.2e3, x, x, false, false, false, false, false, 1.2e3, 1.2e3, false, false, false, 1.2e3, false, 1.2e3, x, x, x, false, false], (Object.defineProperty(window, \"findIndex\", ({set: \"\\uDF11\", configurable:  '' , enumerable: \"\\uCECE\"}))),  /x/ , (arguments && -28), .../*FARR*/[], , (4277), x, .../*MARR*/[x,  \"use strict\" ,  \"use strict\" ,  \"use strict\" , x,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" ,  \"use strict\" , true, x, true, x, x,  \"use strict\" , true, x, x, x]].sort(q => q), noScriptRval: (x % 3 != 1), catchTermination: true, saveFrameChain: false }));");
/*FRC*/Random.twister.import_mta(-213400937,-2010144597,-2146381884,1720974271,-1500873960,939326243,1639953005,2045430084,-39824299,613837769,1652856813,-1909282878,-1804603734,-1638051741,-1518036715,-836396261,-169800574,1102133759,-507604397,595942102,26976596,-757504608,1352761609,1887336146,869304066,-934007719,-1031274022,-458882966,-915893821,-868356660,161983318,67365710,1074892848,427721206,1464527556,-2136841664,-1921073174,-968988250,-1651507523,-477198552,1802601566,-1741313244,23958274,290077461,739959755,-554589986,1262190942,-1263804765,1422312243,-1187523840,1205711280,243641200,-97751946,-85228632,80397527,1193452676,652681645,-606294155,2110446861,1516624841,-896251425,-185389365,-390066782,665582542,-155477225,1273350440,1920996851,-1190986206,-1480473412,1142468541,-940079107,64489124,-1048930827,638897299,603490077,-795619670,79432373,-1589109484,632117630,-1426820152,280564412,1155643028,1228574116,137122486,-2129705609,-1533471775,-1490277339,-443031515,351013972,-1290348054,96486351,-518295393,-1523708626,1869221994,-477267058,-1120890840,-1364406304,-1124711525,920848264,-1629897806,-1074516405,1859576561,-573262228,-49763281,-1118104012,631677154,1476224265,-1583168826,-3821890,-816895029,1612865007,1259521043,121521108,448559398,-411007529,-1656946384,1212024921,43381286,52384008,329968925,-183667015,-804445095,1059609593,2117270358,1022360494,-353628721,284618596,-689863997,-1270226017,-337484940,1617142526,-1444730766,1255516332,-2056540329,330903446,899783046,448542048,1897141572,-1605341626,-1206031035,-2033794820,-521242139,366883898,680775410,359996210,507060722,1056936123,-1488080253,-708822542,-1102390013,1578419067,172727233,799549639,1075495478,1604908791,189084777,1266691012,1371909258,383023634,-1872919743,-1095503889,-489697835,-402066596,314184227,-85867066,1690488557,2104365828,-2096092452,-563995538,1747499173,1336582785,1424995658,35354153,1737220805,-1410121618,-1430280399,-1023588187,553998217,-14458062,-627924012,778618983,1298342228,-1085761023,-2024325964,1735371326,-138753388,553962316,895284760,-1854896558,981385822,-615422668,-2064474914,-204655816,-1858667165,-1238331624,981064598,622891150,2019718099,-1376012733,-1826026741,229898456,1628411695,-1543002272,-618798341,900912088,-2003535569,-1150605012,-1572534437,1120364477,1413789001,-1798597734,-1084087352,1756239525,1040288657,1435869785,-656139236,1654646086,-1713968476,-2123135776,1427250082,-483873084,-1412039291,-1089080688,-331759467,698306090,34969799,-1625240230,-636519523,1806126843,-874537383,-2047344079,525981175,-680828360,233171754,-879739462,-687634033,568611577,1118907133,-117795060,-68922319,-1657624057,-1690440362,1518791732,-212344871,-806476478,-1806161902,405382208,-462218312,-452313465,1906166812,-228706693,-636110571,-1006314512,1769411001,791001147,31404794,112615279,634878690,2032510228,-1294877180,381928515,1681417692,1790189544,-1360942106,945984714,-934340177,-1480738131,844342525,609898630,-1192684263,267528909,-1941874084,-1344724506,450932321,-592532936,1794780041,1410015709,-544308721,486342417,-1878159831,1814760586,736223221,-269874727,-1119656740,-467723670,-1126079619,601425087,944508010,1955186775,-242792119,628797239,566056199,-1800381695,-469083724,-1009812099,-1206422785,354880201,-966267523,2094444152,1650061641,1435707040,-1499950249,197221040,1001515232,-907097595,216304287,1213920441,-1400737195,52625397,1003880487,1498884448,-491722952,4559920,-1672417130,-2147229471,-1711940730,-1243252828,-819297033,493107970,-242139596,-817832773,-1045876319,-439616321,2072777075,266875308,697348857,-1734135061,2074545317,692090030,-650691357,-1906200371,697539105,127191019,1171707403,-2074328543,-1703109331,980375464,308968319,239443587,300845215,1534237441,330089774,-363212115,-634088438,269402996,1467932574,1281534706,-859293220,1663732465,333358105,-2122504080,-534008569,-1249840015,-1108733857,-51217120,-329425881,1292406047,278023170,1548308732,1014122045,-1360231470,179097612,1109722606,1027324568,1197703426,788674069,418402272,1083082421,436178785,1666331826,1505654364,-856219729,-1365889829,-1415682014,-1593356183,-360257449,-55895201,2128283729,1560400689,-241743578,-881570349,1645297751,206135418,2012272769,1442833135,812486462,-1225029300,2091173700,-955596243,594937130,322180494,1671123004,1241232413,1503929846,-1381124300,881716139,-2141970305,-1318109473,1016929734,462283887,1824619194,1512511017,-149768534,259827473,1873899421,-1438086188,-13143418,-1512589356,-2121499078,1191269521,223535013,1772132982,584213452,1622851568,801302221,1955936465,1191268867,-1214148566,718365107,-170686454,1817955931,90336227,677002987,-792399533,1825605125,1197465700,-1182228230,905932984,381293536,1777172112,-780218330,1936511464,-22167083,971642077,1112198820,-386524518,-624511280,644062104,-281065329,554587318,1064017681,-1343191075,418662834,470968418,-1692980587,1701067255,435884409,973142956,-1225970750,-1263646597,-894719166,640410636,-507373568,1081649620,-660924371,630959908,-625326612,942270723,396853820,-173545254,207335075,1636931656,1690772260,673638243,-917445679,272388063,-2021350506,892164300,-692770585,293922889,-1886867564,1075401226,1662790691,1266194667,-1090953619,1601975164,1066976479,-332060646,-1058884981,423631438,1920798730,1674689922,549201491,-1084919299,-433776272,-1200784129,-1306280936,5422518,-1982886844,-675565833,-1962255611,-1040602910,-1266540782,1875587355,-1908243004,-985109537,-973369251,560347682,422286975,-1444364306,-1644158920,-1661487618,-794303450,-364896814,1500904258,-1177099156,1214535017,-166118307,-1903077682,-221063036,378640348,-1809582968,1950988449,2142666363,1063735584,-1630032768,-57651586,-363197863,448037267,-1433207481,1587214413,281562561,-1632773031,361939870,1744537544,1841389882,-1396186685,-1753826216,1882437044,-771691601,-132195508,1563864161,446357152,1137175144,382111250,824300958,-189735129,-215216046,-1816961813,2026545220,-934471420,577641761,-1657925066,-222764256,306187724,1060801423,1101454451,-191474601,-1583584887,391631863,-1357776754,309090476,-18372769,852107416,26961548,-112968223,-1815029914,1623520101,1374430952,1386376035,2132407500,1110791500,-1856072985,711060036,1688159812,1031863284,121017062,1111880301,268722712,-327382427,-148665460,1468573290,-388411180,1948231549,717483479,614998209,-351394696,-733649945,544690218,1996720431,1761790907,1530759312,-533392005,1254938151,741964277,-454793697,-424116872,563823496,1807849330,1169792776,-709381560,-1416207382,2028180387,-1557392435,-1099074352,-1028738907,301124356,-1033871140,-1578926678,-1428445702,1945371315,1821261829,-1570921295,-901987649,-568629534,-853411583,-705198025,-394514793,-678725969,1023050174,1852529742,1388951056,491083066,566421346,1743216928,2114103392,109261553,2119102311,-1425344988,-652590063,2050834307,1292078525,1225425198,553611755);
/*FRC*/Random.twister.import_mti(141); void (makeScript(14));
/*FRC*/count=270; tryItOut("var eval = (this.x <= 28.toString());/* no regression tests found */");
/*FRC*/Random.twister.import_mti(243); void (makeScript(14));
/*FRC*/count=271; tryItOut("i0.send(h0);");
/*FRC*/Random.twister.import_mti(255); void (makeScript(14));
/*FRC*/count=272; tryItOut("/*ODP-2*/Object.defineProperty(g0.o1, \"0\", { configurable: true, enumerable: true, get: (function(j) { if (j) { try { e2.has(a1); } catch(e0) { } try { v1 = null; } catch(e1) { } p0.valueOf = (function(j) { if (j) { (void schedulegc(g1)); } else { e2.has((Math.atan(window))); } }); } else { try { p2 + o0; } catch(e0) { } this.m0.has(s1); } }), set: (function() { for (var j=0;j<1;++j) { f1(j%4==1); } }) });M:with({e: window})this.h2.enumerate = Date.prototype.toLocaleTimeString.bind(p0);");
/*FRC*/Random.twister.import_mti(417); void (makeScript(14));
/*FRC*/count=273; tryItOut("\"use asm\"; e0 = new Set;");
/*FRC*/Random.twister.import_mti(427); void (makeScript(14));
/*FRC*/count=274; tryItOut("\"use strict\"; this.i1.next();");
/*FRC*/Random.twister.import_mti(436); void (makeScript(14));
/*FRC*/count=275; tryItOut("\"use strict\"; mathy3 = (function(x, y) { \"use strict\"; return ( + ( - (Math.sqrt(y) == Math.fround(mathy1(Math.fround(x), Math.fround(( + Math.hypot(( + Math.fround((Math.fround(Math.fround(mathy0(Math.fround(y), Math.fround((( ! (y | 0)) | 0))))) ? Math.fround(( - x)) : Math.fround(y)))), ( ~ ( ! x)))))))))); }); ");
/*FRC*/Random.twister.import_mti(590); void (makeScript(14));
/*FRC*/count=276; tryItOut("mathy2 = (function(x, y) { return Math.log1p(Math.hypot(( + Math.tanh(mathy1((Math.fround((x >>> 0)) >>> 0), Math.fround(Math.fround((0x080000001 && ( + ( ! ( + y))))))))), ( + ( ! ( + Math.abs(( + Math.fround(((( + (x && Math.fround(Math.max(( + y), x)))) >>> 0) === x))))))))); }); ");
/*FRC*/Random.twister.import_mta(1819303509,2090170916,-238245521,2139375414,-1731077273,1590026051,864666547,-932579992,1628114671,1467845039,-1563499467,-876902033,-1859695489,-963107856,-1749358812,1478681997,-1721068592,-2045436101,626496954,1204585129,-1630723334,-611773976,-840125597,1974701530,-1203712752,1226718726,-1567100570,-1855160773,557913730,-44337839,939427103,917691384,1699888747,-86268604,1933435080,-1206739424,1526013966,-1786412763,-1724819186,-1350667009,712592906,-1349943026,-1331430941,-1334944213,-2138548302,2104068381,-1622198292,1753021395,2046808183,2048248225,1027747348,-1946477063,-908359249,298220022,96122446,1807300617,-190951759,1064748660,-1851657697,1727582684,-614936903,1674020077,-1502472899,-1374759945,73628892,-997222142,883398770,-1699741297,-348608290,1031262391,1958828958,1862324930,-611959073,125590725,1750119775,-1203070554,1541183073,-332401966,1241909912,2009353601,-834276528,-461376423,492188437,-336461202,-1466596179,-366837602,1419129136,-1403838630,-1578758134,1774923040,-1445481178,-614954285,-1609652542,-1160976702,-1620975370,-472614686,-1464295415,-718076416,-903563770,50935719,-821691515,935447881,1315199270,-1062360286,-836442737,1649534589,-91128655,647441437,1199161686,-1585591487,1251536523,-1928431836,-7543785,-1134991896,-625118192,-1990325166,2130478952,1055455652,235563729,1595819517,458500266,-601350992,-1786019604,1089275290,-1128858631,-690574357,-1477791200,-1529362728,405819520,-587845444,-2088294303,358179298,1237159131,-1312666489,1206280354,398771216,2068701386,116308273,-198716445,-1210859687,441687167,-648263946,1820542781,-1023961955,762482136,458844852,2014743230,2023756085,-115911215,-1213985519,1757096296,792775989,928690924,432878378,-1899597241,-618155331,438892253,183589765,1751272606,1434554446,-2002016944,635985734,-2097687891,1114183215,-1453554971,-1343644827,736755498,195971187,-795076743,-1175751815,1748117704,-2013173293,1186057176,-489018437,-1679833811,279921753,-1114260378,357719118,1239511339,624095380,-218827955,-1495552523,883431285,448077476,1625353690,-1330155299,1348644139,612448988,-1176828112,-888090654,1675759079,304549614,-1809165978,-1901070908,-156594655,1785977828,102079227,831004462,305300991,1462450024,1810832276,-1277120998,1583211608,690842463,-238236595,-1560537,35058125,644900323,2114655098,-544062982,-1211285645,987024674,-1158482775,-576111171,2126231582,1812637593,757699120,660513616,344696241,924280211,-1297309318,-192934036,906892420,787650710,-721293055,1184556931,-722436870,-2136258057,-1066269225,708319400,-1457513198,-1285264773,406268630,373415278,987791728,-1460562100,-282219506,-1632391245,792794024,1186376099,-1962486437,-84307650,-125715778,-23232143,-868676814,1766016922,1978994549,1967164774,-1555564570,1842026625,-2119048817,-633167640,-1532164603,739089828,-1853626554,-1156412950,-273627104,191649685,802817274,-1220842347,-926443606,1181216572,-1352512557,113535595,682278189,1407661191,1868502622,945055305,720747357,1850891354,-1236339963,-681261247,-1458475278,-1323801872,-2079760696,-890048442,-858113927,-365633213,452291122,-1077014550,-1656871213,-1421409667,890800743,-2037267580,-133249259,1497743519,2061424617,2014616141,-1039363946,1841820281,668518827,-1758207613,-1232423464,-867658221,1605568559,950246757,-2025023786,178916514,-953902407,-246436465,-1925667407,766515207,-1517130282,-433896516,861210434,-148652005,-124926860,383532149,1620853909,838707109,-626363918,-390639947,-469042987,-1918930529,-525733223,-82531368,-1755914364,-412768089,-477096503,1587968064,1125174989,1955376758,119193732,-1353926433,1492381603,1602068396,-405667542,-609893934,-2108496921,-1873006177,225236717,1424373413,-642630233,1639443838,-224275884,441346690,826295841,-726494955,485589940,1262295368,-1248917633,1989750169,-465287593,922478290,358061675,674971560,2038061331,-204874483,1288699491,-1791683372,-1443863610,2138976542,288035611,-644641616,1274140692,-407066928,-725674307,-1381793761,-1838616029,1590414642,-191617919,1727324757,156834140,1492918347,-2006510876,-127929325,245124316,-1885017328,-386573137,1079802899,2105846677,-483316886,1318477477,-1315073451,-1796483647,508192929,1371617766,-550277073,395012518,-873978662,-238214178,-1998404998,2044161570,-1444956299,315071514,1931446328,735310828,841381017,1951620563,-1955735446,1940176433,346679348,-2093250146,1027548336,-924840583,1237235609,2018794697,914138667,483339067,1892775557,1455493232,-1604936072,-837179634,323337079,7739812,914016360,2010721150,-1305293744,1548990306,-1425422216,778392479,1904860220,-2132136155,-561287534,-2017257877,55779054,-792721417,-1350431263,684641003,2064582292,353792234,2072977803,-619113582,-378181338,304607004,251057538,232034100,1622282852,-2028596910,1994558539,1352336299,1469226104,974490262,590583455,302737582,325601298,-1935438794,425339883,1783883641,1011846142,1398394508,851549383,1644401576,-1179994203,-857469068,-2122408494,706156613,-1445317477,937401230,1398522149,2112318096,-438239999,648459113,1639268403,-765026715,-315676895,-282829578,-1561076724,-1984455146,-955101864,646517066,142807266,636113954,1385000249,1336227971,746799715,471860677,961868279,724784581,-12194444,-1634654092,1690283516,-705184976,-209645412,452891864,629351766,1540459660,2026375189,-1763529265,-1651274240,501564261,416629936,1034977739,-1667087208,-833464011,1993071350,-149802418,-870297208,-1263368040,1945097870,1714994714,1928049316,-1123410731,1753109692,-1007099015,-788479060,1054949707,601065701,-1013933898,-435061010,-10242033,-329601829,-1076691281,-1604270632,-153119883,-405802919,499786011,-629764684,-768709057,2119188873,-1937753664,455256986,-6926467,1701674873,2004831245,-1136347223,-2115876982,-209045059,460468223,1087338785,1562640428,-907192612,1919614122,-1263446734,1011530815,1213192839,-1158351965,-182354069,-1648829169,-644022160,296789331,1041786898,-692046545,-202472579,239916730,-1010000935,1215016844,175861592,-1798168937,-1070828457,1168166864,-297862270,-2109154744,-562636446,1643142591,1514916655,-35265868,-1965667626,-1506805934,278019267,-428174199,-24605485,102272992,-417353108,2114940925,-876967852,2033645810,630900121,-457198645,-432093247,1085097944,1661348856,1333698464,51373315,-898437905,527092423,-216575839,-1114818957,-642787212,-1613397103,1564456423,557530625,-885236535,-183296217,2023062962,2034822239,1713313272,-104084525,-570997418,-1130183143,-200455944,-488381834,466779420,1537940120,114885583,-516633441,235302134,-1049301192,1143483857,595771512,221712830,1830710250,1891716394,1369634484,2012939165,-1609811667,1634487421,762647872,-1235420777,-1369116893,517079688,483243846,-497239775,1053592215,548093040,-461890206,652116814,50341974,-694189403,1323483141,-2135200643,476395143,1677654921,404767612,220668073,-300256140,759308038,1713489187,-517178653,1731044992,-2101980495,-328905234,-1060520013,-681262276);
/*FRC*/Random.twister.import_mti(140); void (makeScript(14));
/*FRC*/count=277; tryItOut("this.m0.get(v0);");
/*FRC*/Random.twister.import_mti(153); void (makeScript(14));
/*FRC*/count=278; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return Math.round(( + (Math.asinh((( - Math.fround(Math.fround(Math.fround(y)))) | 0)) | 0))); }); testMathyFunction(mathy5, [-0x080000000, Number.MAX_VALUE, 42, Number.MIN_VALUE, Math.PI, -0x0ffffffff, -1/0, -Number.MAX_VALUE, 0x100000001, -0x080000001, -0x07fffffff, -0, -Number.MIN_VALUE, 1, 0x080000001, 0x07fffffff, -0x100000000, 0x100000001, 0x0ffffffff, 0, 0x100000000, 0x080000000, 0/0, 1/0]); ");
/*FRC*/Random.twister.import_mti(237); void (makeScript(14));
/*FRC*/count=279; tryItOut("/*ODP-3*/Object.defineProperty(g2, function(){}, { configurable: x, enumerable: true, writable: true, value: m1 });");
/*FRC*/Random.twister.import_mti(274); void (makeScript(14));
/*FRC*/count=280; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return Math.abs(Math.pow((mathy0((Math.sqrt(((y ** ((((y >>> 0) ? (y | 0) : (-0x080000001 >>> 0)) >>> 0) >>> 0)) >>> 0)) >>> 0), mathy0(x, (Math.max(-0x080000000, (y >>> 0)) | 0))) | 0), Math.asin((x >>> 0)))); }); testMathyFunction(mathy1, [Number.MIN_VALUE, -1/0, -0x0ffffffff, 1, 1/0, -0x07fffffff, 0x100000001, -0, Math.PI, -0x080000000, 42, 0x0ffffffff, -0x100000000, 0x100000000, -Number.MAX_VALUE, 0/0, 0x07fffffff, 0x080000001, 0, -Number.MIN_VALUE, Number.MAX_VALUE, 0x080000000, -0x080000001, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(447); void (makeScript(14));
/*FRC*/count=281; tryItOut("mathy4 = (function(x, y) { \"use strict\"; return Math.fround(Math.trunc((( + Math.round((Math.fround(Math.expm1(Math.fround((Math.log1p(x) | 0)))) | 0))) === Math.pow(x, ( ! ( + (Math.atanh(x) % 0x07fffffff))))))); }); testMathyFunction(mathy4, [0x080000000, 0x100000001, 1/0, 0x100000001, -0x07fffffff, 0x0ffffffff, Number.MIN_VALUE, Math.PI, 0x07fffffff, -0x100000000, -Number.MAX_VALUE, -0x0ffffffff, 0x100000000, -Number.MIN_VALUE, -0x080000001, 0/0, 0x080000001, 0, 42, -1/0, 1, Number.MAX_VALUE, -0, -0x080000000]); ");
/*FRC*/Random.twister.import_mti(601); void (makeScript(14));
/*FRC*/count=282; tryItOut("var cqzieb = new ArrayBuffer(2); var cqzieb_0 = new Uint16Array(cqzieb); print(cqzieb_0[0]); var cqzieb_1 = new Uint8ClampedArray(cqzieb); cqzieb_1[0] = 2; g0.a0 = arguments;print(b0);");
/*FRC*/Random.twister.import_mta(137763641,-1121857709,252925214,-1012839140,1446822150,1322645000,930169283,-369414644,-2066957216,-4789829,1323808824,-1916231294,-934946432,1706565645,-2070929883,-1939904819,76108240,-714548042,-1178734747,-542730614,-1035565803,-684711035,30851193,154539618,520109704,-900535519,952887012,1116169309,-1454120971,-819757724,2079031192,750239416,1267687145,688255951,1268503400,1466899089,-1325799726,1586742313,-572538190,-643880141,245295980,-1425364137,-42986444,320726357,-713168746,1839466590,1419541139,1762875280,628935133,884346703,892275384,-902107258,465108446,2134520247,1228198362,-2048842514,1041113865,1136580533,-1638707249,1535150965,1243131557,59122775,152933500,1689825060,717544547,2142869531,-958538463,976841964,-349168921,641771530,248813718,-1611072907,636711881,867287556,2023416111,554778847,-979965451,2147324308,-2023115959,2096330020,-1811987738,1094780058,-1469411529,-794349076,1841562879,1476106579,-1970549963,-1633595088,36588646,-470161187,948216894,-457843719,780772847,696798817,50433749,1885273102,48748476,-1494566790,160229536,-2140468138,-516170082,-459099099,-968381569,24738327,75165498,462614568,1780736777,-714902562,1853465894,-510728575,-588138970,887139563,545059709,-505510968,1603120563,-2132276023,2048459691,-378353222,180561288,-1941416993,-576833563,1371008905,549059564,-629682929,999207926,564110778,-421874082,1884460159,1714733785,1648351052,-1081225318,544123837,1484035820,1917031682,905579034,-345586358,1771138874,-1386770540,19788970,-1672818324,651512867,2073759190,2019495622,320440636,-476950824,-1102864617,2066637095,-999078008,-1735295624,-1984399872,75406483,-1115509212,477406550,2014387573,169076050,-771472303,2070916977,1245596082,-512081805,2103650906,2003757626,2093804098,503512073,-854870411,-1376102763,445276213,-1613729307,2067027852,-627588188,-2029108027,545600069,-1158201960,934291091,-1982273618,-261870350,-705264902,-1078316800,-982682120,1808897045,-965878655,867085814,514588211,-1309128373,-998425067,1672538823,-353658026,1240172534,439648343,-2068010130,-419439910,-932747185,1312621922,1691695770,-278206863,405243416,-356306808,1231485219,-404033091,-1952865639,1419493815,881148493,-646837317,603646547,-1086532495,-97443958,979333400,-1258551111,531543501,-877576801,-466572248,1584025287,1391347758,-1187058172,-1658766,-1284975212,1969894033,193925844,-1637203282,1821996642,873746363,476168853,-1171558239,1884613323,826153710,371232496,-357465650,238671640,-251156211,-398605561,461593495,52152574,438785133,1173690559,704708987,-41687638,-212178329,703041213,424096236,932922764,1422787570,415557778,-120536198,1780029098,1653986377,-1580630149,441440256,-452538311,-739934490,954015514,-1744404383,1679246870,-732033707,-1672206861,805967175,521019560,-561267739,329115249,1812364773,-1373456339,804033852,1245054033,-987609506,-1929011333,1034160283,-295113035,-361739875,1555933384,-2098428387,-1675393670,2136989033,-509135318,-2114625553,891828518,379114999,208285619,-635869890,-660287695,2018885537,-706877325,-869310872,-1282342826,-1968167882,-2035694292,-620629924,-1240168667,976524516,-25004404,1797187310,-328372812,-2080817034,-165023942,1904313999,-2137693235,806152681,-1084222847,-392801908,1662365275,-1269930731,2119670893,-93875762,-60719400,1783879620,1375789313,-1673762220,-580599482,-80785037,-1365910591,985256051,-1061722217,-2059421746,1039410793,-2033596342,-2009296573,1675068070,-483719972,1233462180,155421777,-800842235,-1947801639,-1777765802,332274010,9236119,-17821506,-141127502,-1990953044,979757109,-306582337,958013362,897850421,435777750,-1308438118,-1314176714,1799947927,1400048163,-1740355937,-271501591,1390354132,-1836484612,293478479,-1548500963,60466651,-190366137,-610926688,-373655487,-43035026,-1351173666,748948870,586250251,1529701859,1950468623,-1513564800,-1441559900,223765474,-2094900652,1133299479,-1788610216,-1377392740,1873872468,1326140708,-80333709,-1741597449,827754164,1578132912,1839392328,1215350082,1180947140,-1684495132,-878226773,-2101509376,-543822893,578886793,500289877,1065740002,-1470940392,308200199,-1334713973,1059684040,1337665600,-1737049015,1687303353,1012956232,1995985475,1608724276,839672188,1941015982,-191645307,-42426167,-732957684,2038040183,-19393586,-950058385,-1402498470,1142289005,581486470,-2031895393,2142592287,87598863,-1209395449,462894597,483438251,-1712084846,-1754726539,89976734,-1082049070,-565177908,1346175402,-545998167,1569158727,187636239,2143440987,-54931445,-87208566,-2052183009,-1828537316,1537019680,903092298,674655477,84458981,1941603880,1851654895,1269155435,900403153,-1636203493,7671469,-527328388,-1921784573,1690486917,923683556,990641473,-1832920231,-1795843507,-415507775,-1295119736,-1107706642,370840004,-840893564,831850754,-229962332,1288277457,-1869477566,2140065486,-2107040704,-256386660,1845302638,-556463033,-1600501089,-1175329495,1200492370,177086700,1319591811,-1698245455,-595892325,1130598664,-1107154699,513313346,-1615860356,1257944465,1203767285,2041475777,380735514,775981322,-277426245,1125411876,-1757568477,-1777459198,-1601964111,-781399082,-1806306641,-948816448,626098832,281674423,-1959615773,1670336590,-1468425643,-1054544819,355850588,1030370484,-160522194,-1701328299,1269707934,1012971295,-1730228078,-790980183,-306415052,392401054,-1783914230,1241300472,275726365,-1126847207,-1105608586,80859593,1776635904,-1638964285,-464950869,-361961525,1515951360,-138499644,-1066435983,-218242920,-745449986,-105041083,-896802757,-1977022510,985904724,-1833240750,36718625,-518776654,1133414294,1821422637,-2132158004,-1768905327,282529860,-779445369,1547001941,-332132891,-1399042447,1664412791,580405274,-923891008,-1375247397,351945351,-967480108,-221316331,-1539817317,157366409,-98216605,436182692,733323392,110974972,-2083519625,-2093982115,1863084814,466657298,-374099812,-2108216000,-1534939055,-2147352478,-1365927427,2144813758,-353569109,1422458727,-1576048136,650006293,-525135279,1684622157,-1256974717,-748529859,1088021235,-775077847,1422256677,299525636,-900190116,166342915,196537246,482827160,1226793036,-1841519931,425048224,1539084809,186623355,1659903967,-1074067121,2002678967,-286336900,1144300096,-1308804928,1685974011,1867336161,574967632,738366860,1613715358,1106888917,1291290258,1357820767,-2023899397,1747119903,-777216199,-885819605,1833589111,2001782686,-229397649,241564057,-1196002284,931305124,-970731324,134773599,-611564561,1663955648,546825864,1485565295,1529729981,1880122327,1857202590,963483125,1118437090,1795364321,-919641741,-1599614819,-739568101,1894573990,-1506418501,-1166528696,1981748255,796713200,2106009329,-887489042,1695686802,-1910043195,-2004778338,-961140267,-449426720,-616152907,-125593541,1659076674,-482161098,802884084,1421885824,1858195393,-537837286,-599364630,1419403633,2140132249,336018561,-668263860);
/*FRC*/Random.twister.import_mti(26); void (makeScript(14));
/*FRC*/count=283; tryItOut("\"use strict\"; let(sypblf, x, qmzoph, x, sbkbzg, z, x, x) ((function(){{}})());");
/*FRC*/Random.twister.import_mti(102); void (makeScript(14));
/*FRC*/count=284; tryItOut("mathy0 = (function(x, y) { \"use asm\"; return (Math.log((Math.fround(Math.hypot(Math.imul(Math.pow(Math.fround(Math.cos((Math.atan(x) >>> 0))), (y >> Math.atan2(y, -0x0ffffffff))), ( + ( + (( + y) % ( + y))))), Math.fround(Math.atan2(( + Math.acosh((Math.sqrt((x >>> 0)) >>> 0))), ( + ((((((Math.trunc(((((-Number.MIN_VALUE >>> 0) >> Math.fround(x)) >>> 0) | 0)) | 0) % (Math.log1p(y) | 0)) | 0) >>> 0) ? ( + y) : (Math.sinh(-0x07fffffff) >>> 0)) >>> 0)))))) >>> 0)) >>> 0); }); testMathyFunction(mathy0, [Number.MIN_VALUE, 0x100000001, 0x080000000, -0x080000000, 0x080000001, 0, 0x0ffffffff, 1/0, -0, 1, 0x100000000, -0x0ffffffff, 0x100000001, -0x100000000, Number.MAX_VALUE, -Number.MAX_VALUE, -0x07fffffff, Math.PI, -1/0, -0x080000001, 42, -Number.MIN_VALUE, 0x07fffffff, 0/0]); ");
/*FRC*/Random.twister.import_mti(375); void (makeScript(14));
/*FRC*/count=285; tryItOut("\"use strict\"; this.f2(i2);");
/*FRC*/Random.twister.import_mti(387); void (makeScript(14));
/*FRC*/count=286; tryItOut("\"use strict\"; /*oLoop*/for (let bahnza = 0, vzgnjl; bahnza < 105; ++bahnza) { /*tLoop*/for (let w of /*MARR*/[Infinity, (-1/0), objectEmulatingUndefined(), objectEmulatingUndefined(),  /x/ , (-1/0), function(){}, objectEmulatingUndefined(), objectEmulatingUndefined(), Infinity, Infinity,  /x/ , function(){}, Infinity, function(){}, (-1/0), Infinity, Infinity, objectEmulatingUndefined(), function(){}, function(){}, (-1/0), Infinity, function(){}, (-1/0),  /x/ , objectEmulatingUndefined(), objectEmulatingUndefined(), (-1/0), function(){},  /x/ ,  /x/ , function(){},  /x/ ,  /x/ ,  /x/ ,  /x/ , objectEmulatingUndefined(),  /x/ , (-1/0), objectEmulatingUndefined(), objectEmulatingUndefined(),  /x/ , (-1/0), (-1/0),  /x/ , objectEmulatingUndefined(), (-1/0), Infinity, (-1/0), objectEmulatingUndefined(), (-1/0),  /x/ , Infinity, Infinity, objectEmulatingUndefined(), (-1/0), Infinity, (-1/0), (-1/0), function(){}, Infinity]) { o1.g2.toSource = (function(j) { if (j) { try { t0 + s1; } catch(e0) { } o1.g2.v0 = this.t2.length; } else { try { this.f2 = Proxy.createFunction(h1, this.f2, g0.f0); } catch(e0) { } try { Array.prototype.unshift.call(g0.a1, this.p0); } catch(e1) { } m1.set(o1.g1, -22); } }); } } ");
/*FRC*/Random.twister.import_mta(812793969,1545510026,1023412261,-219297775,-1342045071,-2014511200,-1954764076,-1674162180,-1225865816,-1207474507,1533224582,1863186127,-1810435966,1744400326,636112435,-940931849,-1179200953,-1639233459,1510429455,-803365216,-141026056,-1436985653,1791298014,1143331119,-1987392866,-1038321815,-1203893156,1831912537,-354264143,423065417,559257016,-2017139990,523604577,-1321700359,1434773334,-1431111199,1270410789,955609245,942137026,1994030260,2126964944,846301131,1075071799,1429224069,-189065105,1139889162,1500823206,1432606838,600440295,-1553571723,1653831825,1196580355,-399313017,-1101218724,-561252884,-2056507309,114684912,-2001101446,1801918489,-151104996,-552884991,2099296511,619562888,-1574283292,1235399529,-109956501,-903801771,983473582,-207379532,-704215139,44121930,209927419,1015636882,-1248869633,45265491,-666069909,-678997345,1536722230,1800168398,882218439,-1764875677,397032721,603827304,-745929281,707505380,1285016812,-1561537876,1450489517,1029694907,364834791,-1153622722,1922682673,869619609,-1671846276,1372204551,-1623422947,-147049066,-1364552805,1517163307,-2027731317,724996284,148276728,170219562,-75479848,-951936977,640697993,275910587,-444193343,-1409315906,-1888697439,-2131336900,-442073780,-1341745112,1616823191,-1985239297,898542221,1754006664,-1454006495,867227457,-1795995814,-750055679,-659392714,439629187,1228741500,-694501879,-1046241222,1159314043,-1552684742,-885342523,104429929,-494254719,715594890,-1158559242,-1714594992,1522469291,1863849871,-15173802,-1027483883,-1431840537,1247811244,-1822941418,1140377053,-480234955,1694619659,1680217772,-1037971623,-1031097963,673314289,-238539389,139831723,1578677729,-1611197822,-238693312,349410477,2052235947,-313174428,782880583,-1250768002,934212961,-1450453032,657706369,-843752238,-1265447266,-1392147382,1807124874,-507577190,-1821051974,1769948050,1802676861,-1388854778,1916196653,-527045434,686745179,404570599,721586600,321560082,844630435,1807598638,-769871488,-2005153342,1567504621,-323039987,-1939412917,444821203,990917682,-599541777,-1550817712,-998406797,2071434802,649545495,70479985,318602181,-164221304,389943473,1165097875,-1828100656,-1819255308,-1636982927,-1740225051,1248161930,353789343,455005165,-159761087,-617779330,-413689916,-177626980,-106755383,-1051260703,-1191072774,-1825589458,-1487918638,-1809910372,-1186631188,-1132322774,956033314,-45870767,1842782485,-1794214649,-1395024138,-1007153131,-354629810,1054049440,-992385379,1602889225,1255609214,1394333453,2040561173,-580644563,-1999142498,1015934042,1727451896,200292593,199544770,-1245882367,2090060304,2065019433,-1264255421,1085178944,1164638006,-1737194293,1536233083,1357301094,1873337868,811261221,-747854771,-242447412,-1175510573,-1409903755,1062381092,416197333,-150835366,1588095160,51498261,-1212605432,-612521612,975444054,-1237517980,-1353942671,-801986444,-1557782378,-1817620266,-1978755020,1835552115,-444323424,-725228404,1450773158,-291205275,819407469,-724117088,1892143138,-1933433427,-1372650244,-776630738,-968287840,2020567785,-694998368,1178865530,-780845961,558231863,-1308985428,-83579321,-1646323846,-387135363,-992542531,-710682872,1411785567,-2089737877,-381873189,1021057220,1610166293,1138893948,-790580656,947713600,1285139914,1322628456,455197766,1428751816,-461225565,833680412,1119476990,-1062852323,-1296403956,-699227839,-1187696068,-1090020016,-1525793039,-255734495,798826871,1429595894,-468775037,-789651046,-146975590,1031540159,-1820766014,850798463,-1594453172,-1533784006,1741086221,966620698,2050120500,85418472,1857168984,-453525436,-1282011584,1787877214,-172337749,-609334958,-1459868039,69877139,321138919,-1554652093,737061819,-1769901241,-2057790421,191237738,-1030748972,-2044168097,1363263940,1836527005,1757641242,-1023021973,-463382225,-665115022,373010367,-17906738,1709363586,478366592,1742015791,2073699054,147873603,473226798,-1875800072,-1070428912,-1109956305,-1446898282,-1647710965,1910635075,-988814573,-1909148052,1877070674,-1050273782,1974942579,1506370731,-618654217,-504349065,-1486124395,-1229254874,-771301738,-1254457109,724044974,-220102530,2078598621,-704097579,313352393,-1458457109,-1369664793,797457803,-886351078,1958131713,-269096348,-1230566061,1436759345,-195860774,393283984,372483939,-803596838,-1012126242,-1031373211,-220637899,1312153462,-80327321,-1867202461,-253059239,151887146,-1884463678,-253343451,801798490,-1493828368,2012547916,605499922,-895381886,1772944999,216662267,1567621445,61031675,1689148427,2142290494,-1041169099,1247237631,724742289,1743112214,-523267358,-1782388255,-832642624,-560494250,-161214313,-1120163526,1039020901,-1126512019,1257012578,-1797052538,-750417599,1245401689,-1546088374,1104993583,1932497272,1373787640,-1852101664,-1958113634,621297848,834155201,-1104113024,-1416266005,-1297202645,-408455901,-506777733,-1442172420,1480351717,-1671958211,-964553077,-1112101366,1084229100,-1950704666,-608921623,1548476567,1764351165,-1606477892,-274999496,-2138530882,1353890842,-1463868133,728161274,-720211032,921451316,-759961709,1956801417,-2040176769,-1020699833,11071740,482642759,453938947,488242178,-377236505,-6033854,-1981296825,769430237,1263979843,942150811,38667310,-20615288,-1395966837,-1565848470,2092496441,1081468714,-512983077,568835198,603585218,591477423,998208247,-2077678011,-1143573439,706237823,1291461964,-41078485,-1516656140,-1261635960,840511559,348862085,-721258481,-1240984248,-780762720,1122690482,-1118499156,43666527,1576722669,-284586686,-1980179003,-172173855,-941117949,878946131,973363554,1031530752,-1947012726,1327068371,157657272,298843502,-801295257,1413760142,-1649673316,984361578,-1933801313,1684941332,-1556864086,744724294,645628988,-733028832,1320490008,1737842972,518763362,-351705124,1874008992,-1363511235,-801811244,-2003752621,1083726797,2102344526,1466109118,-1008172317,710591336,247611056,-827127877,-1292907175,-1848121665,-1310041215,-455816832,355788487,709718946,-1358610235,1531158288,-837762349,-2105613250,-119427030,161983163,1336427843,-465279597,-920326821,-2091509102,-1258720989,-1646763115,-333778106,-1766189458,-1217560832,-262070172,-707926882,-1938579873,-1807950802,1603202231,394468760,-1217803815,1056033911,61712467,-373193490,-169383702,-466474625,1237278116,-2042533697,-965906891,-769176637,-228584471,-397636163,-1345324278,-661323641,-727893774,-2044386270,-1966290305,-901456467,-197045239,-208059830,-1415975881,1611917432,1676485948,-1248252004,-972511655,1391464993,402878051,989472580,511126066,-785519794,-1057325797,-313049686,2048955587,-693540168,584446128,-1745883049,2123359417,145064077,-495758273,35437484,59938318,1545212503,1334933357,1259769659,-1176313185,-2008867284,-291002899,104835144,1911479385,-219689956,-1343188732,-2033695830,-472213227,-210052191,-1586768389,-234009915,-1788085601,-658934283,-530741175,-724636182,-23595626,61808446,-1346190279,480670557,-588004349,-285480515);
/*FRC*/Random.twister.import_mti(41); void (makeScript(14));
/*FRC*/count=287; tryItOut("v1 = (a2 instanceof v2);");
/*FRC*/Random.twister.import_mti(56); void (makeScript(14));
/*FRC*/count=288; tryItOut("\"use strict\"; mathy1 = (function(x, y) { \"use strict\"; return Math.max(( ! Math.pow((Math.imul(y, Math.ceil(x)) >>> 0), Math.fround(Math.fround((Math.atan2(((( ! 1/0) > y) >>> 0), ((x > (x === -0)) >>> 0)) >>> 0))))), (Math.pow((( ! ((yield this.__defineSetter__(\"x\", \"\\uBA63\")))) | 0), (((( + Math.exp((( + Math.log2(( + y))) >>> 0))) === ((Math.fround(Math.imul((Math.round((y | 0)) >>> 0), ( + x))) ** y) >>> 0)) >>> 0) | 0)) | 0)); }); testMathyFunction(mathy1, [-Number.MIN_VALUE, -0x080000000, -0x07fffffff, 1/0, Math.PI, 1, 0x100000001, Number.MAX_VALUE, -0x080000001, -1/0, 0x100000001, 0x100000000, Number.MIN_VALUE, -0x0ffffffff, 0x07fffffff, 42, 0/0, -0, 0x0ffffffff, -Number.MAX_VALUE, 0, 0x080000001, -0x100000000, 0x080000000]); ");
/*FRC*/Random.twister.import_mti(415); void (makeScript(14));
/*FRC*/count=289; tryItOut("testMathyFunction(mathy5, [-0x0ffffffff, 42, 1, -0x080000001, Number.MAX_VALUE, 0x080000000, 0, -Number.MAX_VALUE, Number.MIN_VALUE, -0x100000000, -Number.MIN_VALUE, 0x07fffffff, 0x080000001, 0/0, 0x100000001, Math.PI, 0x0ffffffff, -1/0, -0x080000000, 0x100000001, 1/0, 0x100000000, -0, -0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(447); void (makeScript(14));
/*FRC*/count=290; tryItOut("mathy5 = (function(x, y) { \"use strict\"; return (Math.fround(Math.asinh(Math.fround(Math.max(( + Math.PI), Math.imul(y, x))))) && Math.fround((Math.atan2(( ! ( + (( + 0x080000000) + (y * y)))), Math.hypot(Math.fround(-0x080000000), Math.fround(Math.tanh(y)))) ? ( + ( + (( + (Math.atan2(-0x080000000, (x | 0)) | 0)) ? Math.fround(Math.hypot(x, (Math.pow(y, x) >>> 0))) : ( + mathy4(x, y))))) : (Math.trunc((( ~ Math.fround(mathy4(((Math.round(x) | 0) >>> 0), (( - ( + ( ! ( + x)))) >>> 0)))) | 0)) | 0)))); }); testMathyFunction(mathy5, /*MARR*/[function(){}, arguments.callee, function(){}, arguments.callee, function(){}, arguments.callee, objectEmulatingUndefined(), arguments.callee, objectEmulatingUndefined(), objectEmulatingUndefined()]); ");
/*FRC*/Random.twister.import_mta(-1996836171,-260194431,-2073467195,195574885,710574519,1230263697,325789371,1490298415,-1582997618,302076285,1870614157,1079782846,1489897330,-333946928,1513250886,1343303709,410252601,714903566,-563421241,-956848314,-238409505,-910668158,-235527894,-1876540727,725811754,371479671,1279804089,-307937240,-1497589245,1095278372,-1837540715,1574696817,-1533228645,1534738794,845242031,1463925030,937183930,-72050110,-626650847,-1788263020,-670290721,626353273,1964161814,518230754,559460329,-1493121867,-251298862,-727208261,-510501800,1216224043,1429883110,765022370,261939764,-939859987,-254250228,-1770485168,850457993,1040767808,1339900551,1894268192,615626727,316543800,231841973,-422091160,-1196927512,362539282,-1561550699,-1338630499,-539532852,168186598,-1486800327,470463975,2097823272,1956304253,394655360,-1905004631,767141297,-724939204,-1566194110,-1315546324,-241396488,713139395,887395397,-289168845,206811913,1569475610,264231586,574548982,656093604,797425368,-191929918,1440768796,-1205549450,547038844,-730066589,-959769497,-859327155,-1446684249,1972412120,-597453413,-237529315,-1024130538,161711423,-1062361686,-143951205,449005192,-455944468,1553624423,-814666655,-1874459399,647461416,-978798712,-745800834,291629887,-1482567795,-1754127890,-1581127671,-424976573,-566788723,-1105714361,197941895,-889644676,-812127646,-571018117,-831805408,733034806,-1725375026,-1139952528,-1487194331,-13721951,-1766126426,924985235,1109693208,988033969,476804673,-1369711340,1233256660,680498476,1879371153,601979945,1475449588,-201640235,630758921,-1334972568,1090119513,-236305746,-2102390940,1168688013,335972689,894628029,-1157433246,-449148491,1065060815,849082340,-2117610446,1044215576,-814448351,1319916592,-2131150910,-1793082712,827962353,-316625258,1752370770,1987505302,-652281181,-1134751433,-1869772618,-452020155,-1864726084,645838204,-496124512,1059049499,2102042001,-1169244194,-788508786,1421446396,-1275345355,-1547529537,-1904658100,67041440,1557042195,1956784333,-1269108786,2120564517,45106356,-1748986511,-1446617017,1706599802,-1331088368,-2056903979,1096541811,-69113249,1069581613,-1047471659,-550643632,1797119562,1104252720,-1415285100,1838627016,1911608879,-1768201595,-1582876559,831301096,1010482319,832724853,1547425572,1910516355,-1306038256,1336439775,575064240,-1192708398,-212719118,-662088769,-1079546492,1422943190,1317549486,1635958937,-1022937628,541969696,-1791759378,-1951977542,1173616135,-178078491,-1968616058,-1406982140,2032880598,1497453044,-862883206,-1371846228,-1223553095,-1755803454,799598166,-897431218,1830994867,-61452316,587174000,1918243677,1305097494,-714154236,-1408356208,-999604893,1843793728,-785060272,-1462954048,1381684712,462815217,168058403,-1369211955,1557637943,-898165113,-9275755,-1279044481,234412659,569808387,-1330164733,-1113397583,-1880747197,-94368081,206104378,-314023440,511511920,-572667703,1703128566,1572780284,-1870127343,1962731084,1409966205,-228114417,1563855976,-361031393,1240731804,1233283326,-1004255131,339377785,-1164309,-2102371355,-104057393,-1668284254,895773556,-350878264,-1995090864,497461229,1830533841,1482759693,-854361552,-680697107,-1652685806,2061482885,-1540736019,740340363,-827900096,-459919672,869744631,-2054784479,-1113129794,-180100312,-1588608280,-4636617,1029069720,-1001284999,768076923,-442231041,-756451657,1916431129,524673435,1137545229,2135980872,-620337277,-2121362467,1553196168,-1789065090,-874183415,1412490363,-806585918,843424336,1968249273,-982753023,-398337329,1761169030,-1162905982,398603600,-435687103,-1627385017,-1181753630,168870829,407353969,286601848,717895947,1383049914,-2130589759,206717096,1696822247,-1050167230,-1587424807,2110942989,359506065,-119086053,-1994105799,-238482811,1795276180,-94767241,-879993676,1164396270,-1632204306,-1806026878,-797517747,351933711,906054640,1469679106,-1047689867,-705809529,-1368199512,-330154626,-842410235,1809969706,1185118939,1151459319,-777955440,1087557178,1654103837,-650699049,-1450740533,449013552,-1603096784,-499982151,727280130,1256330082,-1805360546,-1502662526,484990518,1419193689,-218792212,565461525,254829902,-1953613279,-624285877,281500976,1481708733,-759137145,-48185415,-1052582493,-1142003873,1971712976,1566958159,1721851613,-517005011,1834235205,-784488012,-1975893715,-857696194,-1490797448,946013648,-119808094,-1755634089,74787848,-952126191,889473796,-1718142970,756304146,1478122192,1469083698,1316880172,-485933951,723702935,144510053,-1314826157,-1173435675,-1595044301,-130826150,-2019030075,1308816980,-782663525,-252713583,-963795732,-2021515794,-298524531,1117359032,-969002086,-1634249490,900798190,825929130,590922147,2062653039,-1204334216,-1842102744,1164317236,2034058207,-750803510,-215803859,-1336406953,589493711,-44019489,-1671149842,-1690623795,1539987314,447572769,-682600547,801898131,152801896,-2041445190,-537432206,1359818277,-1168454011,-1766883315,1855679333,810698494,-486670222,-874290587,766158858,2016779959,-551935877,-2035674672,576542284,-384822558,801699681,872502988,1334710981,-687019844,-1195240662,1577958928,1672363442,1369380552,1563322193,-1347599327,-2110993241,1775044986,689080834,-984858764,1384429700,509198538,-107441675,-1257365973,1001327716,-1548037871,-24074766,1294685782,1121925903,2076540721,685733762,-920956788,-302904221,-1765122395,443338491,-584398919,-1610189333,-867381306,2116373101,-1376484952,-2032549267,221834534,1019988517,-1910335417,-1397133124,-469786412,-974944594,-2134748587,162382640,-1290832062,-1967453304,-651795244,176655097,-99138770,2083803475,-42016365,-1804075499,-2072886888,-2127288433,-2017416802,1089516248,-229814719,710281991,-594973723,-2124633778,-1908161012,1358484629,-1016024607,535429637,-1043142927,-787309274,1141813799,198440672,-709077292,671336286,1477140433,-1054941808,384294343,2091740119,2028637647,-490403417,1824015797,-1304085142,-827940325,-2110780142,221912968,143959103,-1800918516,-770051019,-117651466,1977996479,353343076,-1281580585,-274806830,-879916089,1850139415,366681277,693257167,2044427980,-1071205307,-1878357790,-732096400,-499555998,1914721183,1923172414,-836481656,1624528668,-1532990402,-1967109875,-1896999781,-1554832125,1505352884,-1786702930,119659384,-25426703,-1673966903,319576249,200740160,-1692751702,442584668,648194741,310426475,1811200370,-32199685,-1822143908,-929775377,-903113223,-1263428391,-1203690416,422212931,-562357612,-576409632,-687521589,-1846734375,-1227635948,-777463783,-857979854,1340693283,1241606842,541233285,-550704610,-19161714,-1960437140,-1286072095,-1180294410,-1397927455,155062983,241052226,1575355360,1432249950,1173407512,-1619768964,-1280077300,242744241,-1628723107,-23314663,458145945,1933550196,-1001170505,-1766157023,-125155702,-1654648955,-1110425792,-1357118209,18953360,-1091995435,610902929,1662793174,-1501040949,-663763277,2041875023,1982991713,1073786662,-1291551018,692777232,-395206015);
/*FRC*/Random.twister.import_mti(192); void (makeScript(14));
/*FRC*/count=291; tryItOut("mathy3 = (function(x, y) { return ((Math.hypot((Math.expm1(Math.acosh(x)) >>> 0), ( - ((x + (Math.imul(x, x) >>> 0)) >>> 0))) >>> ( ! ( + (Math.fround(Math.pow(x, (x | 0))) - -Number.MIN_VALUE)))) + ( + Math.log10((( + Math.hypot(Math.fround(Math.asin(Math.fround(x))), Math.fround((Math.fround(( + x)) === (0/0 | 0))))) | 0)))); }); testMathyFunction(mathy3, [0x080000000, 42, 0x100000001, 0x0ffffffff, -0x0ffffffff, -Number.MIN_VALUE, -0x07fffffff, Number.MIN_VALUE, 1, 0x080000001, 0, -0x080000000, 1/0, 0x100000001, Number.MAX_VALUE, Math.PI, 0x07fffffff, -Number.MAX_VALUE, 0/0, -0x100000000, -0, -0x080000001, -1/0, 0x100000000]); ");
/*FRC*/Random.twister.import_mti(462); void (makeScript(14));
/*FRC*/count=292; tryItOut("mathy1 = (function(x, y) { return (((Math.min((Math.fround(Math.asin(((( - y) >>> 0) >= ( + (( + ( + (x >= -Number.MAX_VALUE))) && ( + Math.fround(mathy0((x | 0), Math.fround(-0x07fffffff))))))))) >>> 0), (((Math.abs((( ! (Math.fround(( - ((x >>> 0) << 0x080000001))) | 0)) | 0)) >= ( + (( ! ( ~ ( + ( + Math.acosh(( + y)))))) >>> 0))) >>> 0) >>> 0)) >>> 0) | ( + (( + Math.trunc(( + (Math.sign((x >>> 0)) >>> 0)))) & ( + Math.log10(((Math.exp(( + ( + Math.imul(Math.fround((( ~ y) | 0)), ( + y))))) || (Math.atan2(((0x100000001 >>> 0) < y), x) >>> 0)) >>> 0)))))) | 0); }); testMathyFunction(mathy1, [objectEmulatingUndefined(), -0, ({valueOf:function(){return 0;}}), [0], undefined, '/0/', (new Number(0)), (function(){return 0;}), '', '0', 0, ({toString:function(){return '0';}}), ({valueOf:function(){return '0';}}), /0/, false, null, (new Boolean(true)), NaN, true, (new String('')), [], '\\0', 0.1, 1, (new Boolean(false)), (new Number(-0))]); ");
/*FRC*/Random.twister.import_mta(2023839513,-165131601,-2067336131,-608862154,-203463365,1941184259,-1639942305,407872418,1638481970,347725180,-2134664980,-732642333,-1314642899,589022839,1616488522,1709092818,-742134549,834650834,-1924189394,-1552666872,-1562241829,-429112197,-458586283,1687891135,-1323148473,-975370260,-1897533076,1483031542,633494950,-385262006,618327725,2019937343,-572183326,-1558517177,-692024244,-2020973645,-1495175700,-1349390531,1343867371,576647469,-462816144,865259491,-1994142261,1448314969,-611976032,-1026002068,1710548879,508708169,-848954444,-933026815,-584070604,711252240,-1027587682,-1485432323,-845785864,-502424489,-166428862,-1859197187,209012828,-992052759,-563879648,656569263,1835404580,1073354566,458416705,-716142652,1858010032,-305693631,751706121,-1549097023,306304344,1812047760,-1122231637,-228955467,725571872,-193237405,-1981811185,-1346222381,367033280,974221683,-1215488625,-1415213697,1735536970,852714808,-1207142232,498279338,-868896190,-1282675399,-611381078,1147337356,-955994074,-1697930922,1567981080,-1879215541,1951376043,1406278341,773176536,-1087649342,939206727,-397494175,-764021175,1466071496,-110053887,-398817429,-1216946070,1314732581,171665407,717740282,1431958331,-763389285,-1525353894,691359591,603261697,-1601283042,-1758430446,1219816853,1679743346,-1494492532,91492509,-1023107175,-458331569,-1227266025,-1275234107,1827021552,-2140878257,613919161,101549545,196867805,-260562360,938536324,-1166856487,-1009303509,-389878606,628635285,-645182319,-420409992,427676958,-1449237976,475014343,-102679217,1477045315,-1105122460,221864400,1256776356,-680794491,-1965716363,-1785056754,-2033129270,-1426879666,1683620605,733167680,1455422682,-854531198,-488993925,759097363,-871122831,-1452120176,1621675261,-298864278,1264853034,-1199684656,-680877526,1652730623,537320992,-1073224900,-1237663574,2008458804,1533090919,1489524734,-1439926662,-588900722,-2129701726,262661252,57974453,-1807192699,328276377,8206703,-1927870113,-179380087,254729862,-1166814726,-1000968845,1000243373,-698522991,50719678,2067284968,-1552643420,-729227718,-1806501226,-1281087140,-2068146827,432281687,1192968635,-458164668,-958990396,-1722882706,-1182831957,2146799267,-1347489398,-811400579,-1668986183,490116588,409053156,845811049,543821859,1058213315,-410024175,-443397719,1646052908,-668532002,-283934248,231104394,-1028409017,-675803477,-2007491032,-1461132285,-1620385241,1951352065,1770373153,-481003242,597593455,-636656414,862366626,370228004,-812524739,99244522,-835118148,800912335,883555756,-815088548,-1939737827,-694271588,-1674719739,-1603579731,1227910042,-1047856829,844941303,-1435175058,-2108433493,1251543619,1441317335,1220796258,834151474,-1158773217,-1518498315,289778912,760029745,1434546591,1516208103,35327168,-1536018849,1859552929,1278147634,263645106,-1615036303,-80091944,221374914,1660853552,1321336007,-1831097766,352108284,-1543415113,-1454030899,934138555,-705717221,-485209846,-2107252235,-1963804092,-1616383053,-304495227,1922219046,1621059661,298712207,-1022670171,-972892060,680219020,-2043993008,-2019688562,535813108,-2041910346,1890450132,1645427023,1463133070,-794967462,1670440788,1120553557,549000436,1434340361,-398812619,1245024900,1303445538,-609104539,1318783499,812484079,-1754886699,2087305597,1165932293,1290467476,-685647245,1928813641,1501614357,-616344924,342813488,527808029,388775434,709379684,-1902448019,1849877694,-974356677,1843180917,-836151453,1260173898,977608523,-1793629334,271307066,1613861109,-1454725324,-1283975323,-2019812841,378823856,636893748,-1564009513,253097396,-233476655,704685093,1064415611,1680020539,-79551724,-823514377,-1084647851,1134792263,-1748681653,-2015010282,-304422746,-1183205267,-266194455,266667096,1157154759,1555403181,-2016329627,-985107900,-175908763,1206888802,775144115,1473775221,-704533819,-670811551,-815617714,253172338,1073926617,1004492196,-162671376,-612633884,1945992444,-1310524561,1260420460,522208844,-635811388,1804877690,1565643526,-390906833,-1796538615,-154641696,-244574819,-63776983,958475638,-204272544,188642306,-262863745,-1099282525,1938972114,515471184,-1924284718,156606401,1925008304,-493869610,-780519300,-1680093476,-1322839079,884555148,639961099,1476137467,2074737033,53114913,-919081804,26024727,1677391088,1684788121,-1323635147,823178435,2084003016,-60158739,1688200030,898379824,-503941584,38433404,-1494750599,-1972620793,-1392346678,611310749,608854307,1019495194,-553073907,-1657073790,214898089,826357028,-967792320,-966118953,512415822,1553988487,1744376323,-495277655,410947998,-524975021,983178915,-182567094,-1866780527,-873382142,1125946144,1602623342,1814308426,1655082028,-2058007086,-261704257,491161529,171499706,-432222056,2082240112,-602791144,-789025316,-1781361191,1851274068,-343528070,-1972720472,1909214438,-792961731,382356808,-341948180,250568151,-1387786498,641083750,209570229,2058851546,1898964810,1818650238,1492828184,531462395,1967905130,2132745062,-2048718016,1430533068,-1631621093,828526747,14012627,901535913,-1973009391,-454244350,-805242232,-1181180268,-1376071460,-2002461751,-22026003,1330965388,-364768901,-560827437,-1764057430,1748964857,1017814421,1206861575,-1803756521,2036414933,-123073593,-1718586185,1376088264,857004724,-499625281,-1494154361,-1340240482,1247489767,-1545647396,-572819393,1266833363,1285830619,-1002806296,81328851,-1461982930,-2078152050,-828838123,-493016028,775449088,-1447809465,-2085411771,-1830053536,-527162718,1402676145,-613346773,-195133916,936327650,202136103,-846821076,-33494222,554713106,-1891855974,1427663749,-979050686,-964855572,-978665607,282436536,-1036177744,-1693051182,1741801335,591311859,99330387,-775041439,-305224666,1053240296,-204189405,624447153,549332137,1265824123,447983237,-1016631686,-916136374,1710348749,-1634621784,1887428423,-678778255,-236264167,873971873,223114629,-517056561,1446262915,1825917344,332927149,1679225272,904410622,295884430,768806371,1100706168,-1165754497,-489160573,-320494586,-1910877791,984586677,1054443101,-1150179983,-1349546419,1844674117,-924215313,2114536709,302904513,324010042,409180095,340344757,-384690933,310558382,1629891783,-1962759143,-82193903,-1926894655,-1370878694,525273802,657859666,-546596645,1090732391,1362675192,-891164853,1326553025,1707816207,1914041819,-2010044527,510272347,725842541,605634626,204658685,1396148314,-1784718425,350410990,-1734376704,703717982,-1576844081,-359982363,-1157848641,2035180629,619074698,1318357543,-730322021,-953857760,-343461426,-1285859370,835234098,-1595816366,-159435431,776254940,202465571,-559544945,-1797950324,1365917278,285430766,-728467500,-681127226,-457167039,81169029,97904879,-1572593690,168169437,-420689981,1516251982,-2142984474,625075753,-844313983,-1985513732,-2014242910,-1463380505,1441122674,995207567,-1003493563,-1713002192,1585166978,1151317197,739118939,-1252847944,-1350954013,1136652586);
/*FRC*/Random.twister.import_mti(244); void (makeScript(14));
/*FRC*/count=293; tryItOut("while(( /x/g ) && 0){v0 = evalcx(\"v1 = evaluate(\\\"undefined\\\", ({ global: g0, fileName: 'evaluate.js', lineNumber: 42, newContext: false, isRunOnce: (x % 29 == 25), noScriptRval: (x % 10 == 0), catchTermination: false, saveFrameChain: false, elementProperty: s1, sourceMapURL: s2 }));\", g2);print(x); }");
/*FRC*/Random.twister.import_mti(348); void (makeScript(14));
/*FRC*/count=294; tryItOut("mathy2 = (function(x, y) { return Math.atan2((( ~ (((Math.atan2((Math.sinh((x ? 0x080000000 : y)) >>> 0), (Math.atan2((0x0ffffffff | 0), (x >>> 0)) >>> 0)) >>> 0) - ((( ! (Math.max(Math.fround(x), Math.fround(x)) <= ( ! 0x07fffffff))) >>> 0) | 0)) | 0)) | 0), mathy1((Math.imul((Math.imul(Math.PI, (x ? y : (((0x080000000 | 0) <= (x | 0)) | 0))) >>> 0), Math.sinh(Math.atanh(y))) >>> 0), ((Math.imul(x, y) | 0) === Math.imul((Math.abs((0x080000001 >>> 0)) | 0), (y ^ x))))); }); ");
/*FRC*/Random.twister.import_mta(678471567,1986638603,1236606086,-995269791,-602473404,1226852477,-786637229,1008448944,991812506,-969841354,893968633,-548373881,-1810192285,1473627686,-795476416,-1466443980,-1200986822,1010665268,-1532745522,1489144355,567258592,-1472110507,-1262276114,-306332874,4722650,-1037585052,-1672211388,262646122,1052528543,760813329,-651812688,-220154519,410888224,-21834753,-1265257902,-1191797876,1152052201,-2134370100,1486591348,620671856,727687106,-1820980243,1600748045,200595254,1829892099,-1857726526,-418482895,1255447460,-1513889081,1899666913,544847330,1585396649,1330689889,865016240,1991315183,1248358202,-783674510,1938226311,822200378,-1948436334,446264192,-1892968442,-1308107905,470096438,-737694961,940283476,1168711556,301847304,503807381,555745109,178933341,-1066827123,1952012690,754881861,1537149993,1148665711,-1662196866,2045044564,1714969305,608124319,2093480958,971126338,-1162414016,-1042463637,89900550,1790897914,83305899,1763668614,-890596248,-1482444131,-2080555074,-1943563480,-1328651270,1251692493,861051384,-2048833780,-16660925,-1855060147,1985937092,74200543,1551762694,-1447251464,546536006,-1514431737,-550081057,321491642,1081837560,1979749888,1984562558,-1759459756,-582503212,1255087087,-1957611299,743045886,-563317274,937739754,-1028119769,914103479,-2041719557,411817179,-413382043,-532142060,1023533059,-2088141955,136579705,1399499873,-115043716,-1498564724,730311045,1404800450,151647699,1081521912,-956768752,1424179544,625786431,543925039,118956473,-1288285436,-1877992570,-458321808,851679313,117948816,-1611166163,1348813598,814207715,-992524122,2043145680,1805665274,1347687632,-1168757139,1185710120,-295573970,-1771261849,-577097705,-1403949859,1289397367,-48895724,-570044994,1999679163,2098793775,-524813044,324024241,-1658420015,-1907753852,1146251935,1559066440,1809032759,1835494040,1143930565,-1533875188,261504400,572049229,-358151586,454926732,-827711672,-1300933115,-1147505614,-274917530,346089241,-2002341030,-272540024,1549300617,-1680350263,-478039792,-686343407,-1421417235,319425352,1859070401,390504073,254661118,315618772,1359094220,-2130498316,1386468048,-330910491,868757715,-927546798,465967590,545207406,1134518543,535917736,489914396,1420411327,1583049224,1648433535,-1374029358,-300647196,-750093072,638946994,-1855650001,478348427,940952218,-678080093,-1988049515,1155249186,1363990126,1273595832,-131098179,184259844,216535341,-1260184767,130608979,1335306591,-1831972326,-140107187,-2006540739,-1922484206,841242969,1373433125,-1769122345,-1344126033,185117593,-2145562380,-1249580130,-2049541682,-80017218,-754246015,-311837197,588533625,669415511,1941186967,-934679463,753411300,1943802655,1956598084,722077961,-351632845,-1779916084,-1454578123,1072863774,64899257,643789251,-973289795,176350371,1916492550,2015673214,472275337,1733193228,-74620860,1375991646,1975176827,2033687915,2049491470,-145386181,-247317431,-2136877743,1636298322,-41625916,2089966064,639640606,-1565273137,-50348389,700990031,-2079385341,512832354,-1495895825,854876710,1871599640,1566199410,923159051,-1685178936,1563156264,1646693911,-1602068264,-873764494,559759936,946515529,-1215525307,-365866684,-1797301394,-1462416293,709009109,-1187650436,-686626383,-155090071,-1515153720,124420895,-1204677701,538614902,-1047428665,23018519,296253873,-758819650,-1753547653,1824572518,-125988048,1394495424,-952535876,-704324569,78308142,-1538057906,-2123236996,1614110543,1289932086,-1072756189,-565196814,1729563120,1497072234,-949116560,-1573552416,-1024429319,1960338210,635650363,856237198,400453423,-582499322,969745493,-1576820574,1863895565,-666235462,928101885,-1664820012,1707401961,-2049971439,-1759953365,834176850,743708008,1779813597,-802223358,-369819137,-813652461,-1113874089,-1175088020,1885114562,-2072741622,1934063892,2134540412,-1596471460,1497493543,552487633,-1196453627,1704588043,714347039,2027773716,-1019377350,605522595,2125900064,2093214318,1860067195,1806299352,-2019652093,1579717455,-1042998978,-536413454,-274283073,-1443258954,-1590580623,-1813927247,-1053666658,-432103228,1597634742,908135818,427112345,1083787272,1525174545,954796270,-138688253,-2026391269,-1271039768,477529277,1869383733,143466694,-733534024,-644997298,130805994,1187894467,-702262212,1630681801,-758063857,-1556272459,695487021,907909936,1177251664,1529388335,742544294,-833242330,2024555984,1494679925,-383280676,1636469264,92241921,2015809041,-51850812,1693797945,-146960908,931705785,1922767726,-1601949009,-350273899,824433175,1270109467,-1691847714,34903579,-682642234,1413494372,-971786722,1792364159,1933687876,2126588539,-1223606319,1676711110,-286518772,-755770669,522006865,517630395,325147682,1032935991,838362404,1968158450,-2025309300,695694242,1468141506,-349393018,-1762501993,1646060209,1836099606,-1532353703,-1023665473,783404517,-2071050992,381063568,2038464079,1775969739,2111485063,-732759631,-1675257434,911080856,-1955817742,87649011,624242873,77159112,908049119,285525643,247440537,-1373647986,598378788,-24303469,-215085851,1576387575,1564970447,1406906167,-495186936,1460842716,625645495,-1509625178,-838634150,-1598323134,-917829941,1535062669,-917501743,-696146397,-1587553344,1107865965,-226431127,1039940428,1664931625,1744592081,-299243,934335661,840551037,-162824299,-849219532,1513720458,-951937985,1931713179,-1180855037,-1404620789,83122281,774613099,-134584846,797226950,-1204293383,-252984320,-1857892523,1228205838,113075938,2110241007,1035816451,-633538035,1455962070,-729335542,420445103,1431500274,270929287,212919406,-1501060847,2137824215,-1164926320,278975553,-2000233101,672500222,1343622404,-1867311697,1317928026,-386982991,1255393546,1598803177,562228944,-1762437449,761562081,-157196660,-1837896628,1312869105,136466507,1493519559,-1831372399,543966100,-1034130280,-1912147028,2069548934,1701335269,1521115318,1754868665,1628780316,-573739453,-556419232,-1957964544,-2069978638,87602716,-2007896111,982523701,504009260,437304311,-512525823,-578035699,161666697,1304719645,2139883985,-1831571073,-1242756220,983639187,-2098785233,1315695363,-1806918129,-347930635,-964465487,1153690473,-740955094,1130273259,853664868,-899125644,-2071843838,-2029650976,-706935548,1116319265,1817659512,393575104,1684900939,496626533,619034491,-1503579728,148731107,1632360757,-534029475,-1991507087,-897127125,1788815014,-1260367739,828441124,-1566768985,-1802476871,122382650,-1044903850,1824883557,-1031725150,-571803031,138105928,-228780316,126171300,-1724822105,-260695589,227667916,-19151016,1043442239,632953001,-1957107496,-1903443989,1471697217,476788320,1925603066,-1410207881,-2121554804,-1559540666,-426129680,1530662442,507751382,1900450074,1867438918,-1020959987,1805253927,-1654807504,1144224571,-1952043281,-1126780795,-443392303,1775214194,-271581651,1179228012,-1923419767,-920332254,1098979955,-487069048,-1349893197,-174283064);
/*FRC*/Random.twister.import_mti(76); void (makeScript(14));
/*FRC*/count=295; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return (mathy2((((( + Math.fround((( ! ( + Math.imul(( + x), ( + x)))) + mathy4((y >>> 0), 0x07fffffff)))) >= ( + ((Math.expm1((-0x080000001 | 0)) | 0) - ( + Math.hypot(( + -0x080000000), ( + Math.sinh(Math.PI))))))) >>> 0) <= ( + ( + Math.sin(Math.asin(Math.fround((((y | 0) ? x : (Math.min((x | 0), x) | 0)) | 0))))))), mathy0(Math.fround(( ! (((Math.pow((x | 0), (-Number.MAX_VALUE | 0)) | 0) + x) | 0))), ( + ( + (0x0ffffffff & Math.atan2(Math.fround((y < Math.fround(x))), Math.min(y, x))))))) | 0); }); testMathyFunction(mathy5, [-0x0ffffffff, 0x080000000, -Number.MIN_VALUE, -0x080000000, -0, 1, -0x080000001, Math.PI, 0x100000001, 0x100000000, 42, 0x080000001, -0x100000000, 1/0, Number.MIN_VALUE, 0x07fffffff, -0x07fffffff, 0, 0/0, 0x100000001, -Number.MAX_VALUE, Number.MAX_VALUE, 0x0ffffffff, -1/0]); ");
/*FRC*/Random.twister.import_mti(464); void (makeScript(14));
/*FRC*/count=296; tryItOut("mathy4 = (function(x, y) { return mathy0(( + Math.fround(Math.pow((Math.sinh(Math.atanh((y >>> 0))) >>> 0), (Math.hypot((((Math.hypot(x, (y | 0)) | 0) | 0) >>> Math.min(Math.min(y, Math.max(Math.fround(y), Math.fround(x))), Math.imul(x, x))), x) | 0)))), Math.hypot(Math.atan2((( - y) == ( ! x)), ((( - (x & x)) >>> 0) != x)), ( + mathy2(( + ( + mathy0(Math.fround(x), Math.fround(Math.cos(mathy0(x, x)))))), ( + y))))); }); testMathyFunction(mathy4, /*MARR*/[(-1/0),  /x/g ,  \"\" ,  /x/g ,  /x/g , (-1/0),  /x/g ,  \"\" ,  \"\" , (-1/0),  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  \"\" , (-1/0),  /x/g , (-1/0),  \"\" , (-1/0), (-1/0),  \"\" ,  /x/g ,  /x/g ,  /x/g ,  /x/g ]); ");
/*FRC*/Random.twister.import_mta(-81041361,-839051361,-623604865,1802829347,-2051122448,1299058226,989369569,-357343175,344981794,-1321739315,371506995,941283963,1523136772,1677634107,-815556540,1579263110,-1991149732,1175593475,863650768,2050136207,-26624847,614511244,-1043340726,601133867,-805320514,-1663446799,1489954276,-1735590229,-1664784523,285362799,-780103857,963732194,555344556,1933421195,200884740,275868333,-1768532239,240199691,2131751342,-1325011784,1380954006,-670187460,-2123092341,-1187587762,1898108334,-2091602036,414251349,1606137869,2108712841,644949865,1029422073,-1147567716,1022540897,-1496748704,321621314,966905650,-294360571,-1231081581,641996141,-1279159981,-189021978,-1644257641,323289300,-523187601,-1099315422,1975926558,766803507,806354099,1199847983,1021710771,1886877522,559128132,1177023148,1648791784,443348136,1283375314,-1905091389,-1746360577,-399771335,1503633710,-485854156,720087181,-872425321,-1259955050,-130119863,-1052071808,-204657284,1448530095,1933900946,-306597932,1122472445,1984731542,197096139,908983098,-1161342081,375625726,1090354220,840667244,-1652306734,1408809580,694359807,-1972025554,-585282934,571785018,1352381170,1970222606,723928711,932570833,-1390951877,298795453,1191157688,-1946093328,-555606004,119780109,199520241,686273763,-1933884706,1925267731,-1616997448,-168994556,1369897690,1367021161,-1247244672,733735791,583928483,1926398927,1534364557,-1781651238,-1156923536,-1109390942,-496551964,-1384473436,288059178,-288964827,-745078274,-233174086,2022579870,-1782226048,-1400701096,1260562935,-2028125894,-1815363115,-530362786,-1143257445,1013003903,1727221023,-727491588,-173938075,-1920896672,781332745,1220344518,1089116563,1109959504,-176086494,2105734859,1893801865,-78743344,164763767,1627871993,1956124143,58017581,-725259428,1975851558,826928100,-1426810970,736401444,-479285176,-107585124,2115911294,1354654728,-328638670,684355146,1768646589,-2127282668,-923832514,1015472940,-1746546450,1511309346,-824855418,494897634,1136974238,-1518189793,-748824529,1712541678,-874468461,-2009264654,-1029003430,1344987193,-629402986,22851234,-623114750,117747422,-262101809,1599992694,-847427718,-629102991,1943185100,897942174,866117760,-2123168321,1495372111,-1355323808,1575742462,64606999,-1769514907,-738102732,-1891829624,137808243,-1879467874,-1508924544,1933852171,1910995715,-1236193486,-13599199,1821708300,-1370297037,432655492,-1594911661,-156031429,1823916882,-1666887654,865719801,-1069289169,-1554334838,1070339401,-381755462,897989307,1254993506,1605569963,338500215,-1208476880,-2052001142,397179901,2014554118,-1758534554,-467845443,1586214379,-559536048,-1293855089,-98853616,-556602168,-1726510538,-20505130,-1289822210,-895510952,-1611156970,818334185,868712308,2069495683,1495824073,-1443652843,1946753855,1083183743,1641236583,-1533107436,199162734,581270889,-330940563,1349556557,-2100546226,-693185311,921510659,-1294790417,2000680970,-687246724,265029255,-1882748966,738624366,-887238093,153450419,1581364956,-1127332778,408654802,1475895524,-707252059,617240218,297143141,334929088,957486150,825599621,-933461260,-1154450794,702611294,-1954423108,-432959821,-1552289130,823092910,-2119997372,-678350048,-567863770,754529754,-1562168036,-2025325799,-807661736,1658304471,-1657156737,-1174951759,544881001,-1735135624,-1618944904,-208003857,856579831,-1630859728,-132972816,-1412010137,-2119901479,2047023984,285256440,1757337882,-640265168,-195141592,288135217,-415511013,1254234290,963720022,13596778,-1054576927,1632715077,659957478,-204473496,1279380139,826164029,266798521,-769983644,481849967,1483599399,1123641917,-941112538,-1504689677,532488363,745984336,-1150192807,-293571751,-106796723,1867097464,-1153578865,-1110632692,1860704825,1643301072,539673562,-1058614407,1461626311,1355414658,-1904116133,191036825,-1610361978,-444155222,-1542540778,-670792738,821556957,-1065377227,-1366510733,1320954949,2062176016,1590517076,-2075005984,-2088633195,1275111558,-1733401400,-1947428620,416958045,-209875615,-2112260413,-1772761954,-1053184677,1695718079,-1680159632,-410752907,-522939977,-1879068155,-1597259682,-1445782164,1186982171,1625277355,-371888622,794043710,-201237157,312624818,-1747358958,-325691499,-238570943,1470194327,472256558,-1196719963,-1279507767,1242919143,-1660307372,-1290430091,475221721,-1200123921,709305980,-1981734898,-1619499412,-179332709,-558056433,38280342,-448965523,-654666788,1477389122,-220457118,607119811,-157612068,-671812369,-1401219564,-1730664159,-141018831,-1808457622,-1354500597,1679498955,1871659645,1804039681,333598785,-1550133359,-1467302808,1931688758,907937142,956067968,2092180448,-2054913559,-2120683860,1747712624,1024203468,201756166,-440982834,1010117775,-1268779708,-1718667475,1669745206,-1399620698,156258863,672716022,-1559162970,108064672,1731868943,1049533816,77871597,1584995840,-1122736090,1939888523,-49649670,1526264281,-1049611722,162989999,-1427636093,-285386624,-1382688521,1761642539,1194415548,-1207173766,-1039180725,559797818,-1371093293,2003418409,579460988,454617840,-100849347,-189616934,1074416148,840664242,-1488380743,1227730434,-56116216,1873855929,1300876472,-1180200195,-490957394,129412778,711312721,615988865,210730520,-474926562,848526897,1069512061,1849218127,-1689148353,-777035468,-2264676,1797472668,-200454434,-490922646,123973757,-914201007,-1317600850,-1036254981,1770014003,-1621380713,1505667493,1488171019,219156986,-451851508,-231952215,-1350791044,-563752462,-346165155,794308639,1828109979,-1896652691,-363365627,-676700227,840437591,-2106102292,-9352612,-1244536698,401504594,-1715602281,-542316174,746452941,419715083,643540208,2112502689,-1551181762,2002826427,-1002500933,-1670358103,-456487743,1631348107,-823762610,-1098371490,1834599475,-1139321761,-2031748738,-1660984720,2118533,209567245,-1340525186,-928657486,-1095833036,-1265015495,1319319860,897029789,-716714325,110250596,-1322367657,-840098674,2120905032,756757402,-1684470583,-1228784858,-1945313530,595292510,1170690468,-1385046414,-1451330123,921251384,-1131898146,-1732464969,1426149215,-601668917,1808320255,-876665041,1247920556,-494586063,-884796929,-1370446568,1034864033,1564017816,911726270,-724488838,-1576959637,-877378461,-1142718644,751523976,-774682099,1166110915,1489223173,1783133616,-1961577184,1461884436,-597373275,1140417626,1407677685,-1563450916,153014007,942148557,1480946780,-1387589491,-1282445760,-1731255513,650806271,-1644384826,961543053,2115066239,1799068301,-1564380348,-1141021331,-592195860,-1295903866,1528355343,1726847853,1663748849,-795001992,-28029193,-1560084609,269447419,-500687847,1050279581,2099980922,-1359062162,-1867501039,-900747649,538579437,-1202665423,1545127494,-1717609906,495162201,-1350949985,-617530826,1230877464,-1150997285,310952502,1136299495,795338081,-1921607558,1992828899,-940419508,-1296301808,-615300007,-1243419033,-311210977,1722833802,-1003197217,275852553,2022068210,27283621);
/*FRC*/Random.twister.import_mti(248); void (makeScript(14));
/*FRC*/count=297; tryItOut("yagqvp;h2.getOwnPropertyNames = f0;");
/*FRC*/Random.twister.import_mti(289); void (makeScript(14));
/*FRC*/count=298; tryItOut("\"use strict\"; a2 = this.r0.exec(s1);");
/*FRC*/Random.twister.import_mti(305); void (makeScript(14));
/*FRC*/count=299; tryItOut("\"use strict\"; a1.valueOf = (arguments.callee.caller.caller).call;");
/*FRC*/Random.twister.import_mti(326); void (makeScript(14));
/*FRC*/count=300; tryItOut("M:if(x = Proxy.create((function handlerFactory() {return {getOwnPropertyDescriptor: function(){}, getPropertyDescriptor: function(){}, defineProperty: function() { throw 3; }, getOwnPropertyNames: function() { return []; }, delete: function() { return true; }, fix: mathy0, has: function() { throw 3; }, hasOwn: function() { return false; }, get: function() { return undefined }, set: function(receiver, name, val) { x[name] = val; return true; }, iterate: function() { return (function() { for (var name in x) { yield name; } })(); }, enumerate: function() { var result = []; for (var name in x) { result.push(name); }; return result; }, keys: function() { return []; }, }; })(\"\\u704B\"), ({/*toXFun*/valueOf: (function() { for (var j=0;j<6;++j) { f2(j%2==1); } }) })\u000c)) { if ((eval).call(x, x)) let (kztsay, c = return e) { /*hhh*/function ptmedt({}){ /x/g ;}ptmedt((new RegExp(\"([^\\\\S\\\\D])|\\\\D.(\\\\1)+|\\u9fbd\", \"im\") >= true)); }} else {m1.toString = (function mcc_() { var psngcf = 0; return function() { ++psngcf; if (/*ICCD*/psngcf % 7 == 3) { dumpln('hit!'); Object.defineProperty(this, \"g0.v1\", { configurable:  /x/ , enumerable: Math.pow( /x/g , x),  get: function() {  return false; } }); } else { dumpln('miss!'); try { m1.delete(s1); } catch(e0) { } try { v1 = g2.eval(\"v2.valueOf = (function() { for (var j=0;j<19;++j) { f0(j%3==0); } });\"); } catch(e1) { } (void schedulegc(g1)); } };})();r0 = /^/gm; }");
/*FRC*/Random.twister.import_mta(655141068,-1402085854,510580908,653313211,-1876164411,1400901184,2758359,-762304080,1980457992,1177538348,709241833,1233093193,-948394049,1278655011,2096267778,-1489867713,1384848822,1788746462,-1844446738,-1631576569,786725542,-1520209716,1232738278,1339301423,-362266005,1617034484,1895427396,-346083350,1708548268,675790933,1061092167,-1138783504,-1446627403,769947124,841026095,-1808567289,-1189470763,17393071,472305585,928958923,-1861056456,-1441595887,-1584329891,577346318,-1059428880,-588788774,473787482,1227742107,665189276,-291117816,1526568306,2138706837,-781456645,1757941915,-1298783926,-648333068,-523306902,-785231719,2031440203,-1896919895,-1744980608,2075722968,237619537,370232723,-2042322041,-530429313,-863600066,57491253,1707552168,1066210563,986450547,128239575,1034696300,-293124022,346824280,-1584493629,-1127991313,1984751740,-1117736541,-833074298,-1487002363,1224348234,-1194437855,-495697146,-1457049071,-929982704,807393395,1344420730,-1450744195,-1580871292,1670773952,-1849223104,-33048943,1984408009,-464692349,-31756316,-229623701,563730038,84599725,55204813,-278013806,-1188758792,1662144714,-1438993259,-976826021,961180442,-1792263451,373206357,239335795,251803665,520365171,1227535606,-1485614344,1064328985,-98836971,-1033720364,2081967103,-351943395,466274569,-1506468829,255661493,2005762931,1891766583,243944688,1017025352,-1265457508,110799456,-308516154,-1772762269,-811765306,-500946069,104238753,-1692632624,-1131655596,2141147065,-848737768,-955273906,673910500,-779954242,-1743281068,1714383635,-63080407,-409050420,-2097186236,117491746,-2094016437,-718181419,-95935890,1459422956,1902064188,1700708061,1255970647,-243288514,-1381496298,1140656170,-152818281,1940986364,-1809459198,-25313616,-1360673289,-21784364,-656208776,-753880687,-1365691233,2033783962,-530312663,961167373,667722042,1108821940,-1121969479,55025969,1910099364,1130593104,932234090,-57880502,49030784,1428319196,2133831199,-470494084,-1838349681,319206007,-697508041,-285930959,-2051596645,974118790,175032608,1406972807,-1765577690,-1675781699,-1616113529,412781920,-942310955,209990474,-165439291,169651472,-622089191,181252532,-68687783,-1490498403,-2001513982,-1184503714,-28981266,1387001643,-1303311104,-766480085,461814274,1150062120,444555030,-58854817,1000052204,-391725498,-1605518526,-199733767,904922593,-1589239001,-1047364040,-4760299,631469454,-991469383,-721294252,1965470788,1415185495,924649039,47896228,619594452,-1152523664,616990612,-1847746874,1064559558,93508916,1680391678,1123192292,1871305283,196961508,966133297,-2142892510,1769790212,-365023119,879905985,-1475227173,12418872,59837673,-21167168,935646874,627426261,1399074245,-2027707971,-1975503432,285211511,-997496141,-1395121297,1395194763,-914298856,1656143054,-1364176291,-309563705,-2022936772,-837941442,-1116106665,1536814362,-275098454,-1304415609,-273905662,-1835096853,-538454477,465898588,1633519740,764727806,2005464343,-1900949453,1007597861,-1929925607,-149161048,-1344682793,457765078,-1233760527,-413226136,1182048081,-18321400,-179983487,894447056,-429498651,-593766486,182357996,-2138134062,563274268,-1908475765,-63624176,346722251,1481987004,123787037,1559228116,-2020848173,619047178,-1795593643,-1607186129,-155666072,914750799,1214556651,-580286268,772331502,466196800,-578292549,1881649283,-1349109809,-1067369445,-958914822,-1828632184,1678850130,-1025416395,871022529,62023107,-1376740535,749158872,1346733903,270393810,1214628345,1883172787,-1474238988,19915547,-137348984,2058774912,-686419370,621064579,-1800957510,-1115756948,549042782,625821876,1878186610,1965635682,780844518,730748968,-594282653,-494344103,-1834419763,1353020149,-511801902,805126171,1497355547,503876507,-839402203,-763420588,1546297894,-1600027156,-83612450,1762235484,-198032088,1665094746,-1224816446,-906661646,-1060854378,-1027066443,-1981316844,704382154,-273375434,1318946294,-1449319035,-294446833,1136706267,1316612641,473577531,-1482996729,-2042385321,1050397500,-1012206748,-596659834,1927094449,-1890741481,583668212,-1208253725,-703138574,-44594064,709396801,-505684772,-1377685263,-168486754,940446053,1857162068,-1516303294,278192065,1601178498,1307443261,1941527834,-1285060537,1747439790,-252091750,1852291474,697470823,1573944144,-2043469137,-1435917160,914696108,63663675,-820203819,1726525297,-377397923,-782412969,1866478736,1220003349,-2005123218,215826564,243145442,1423027594,-2142842989,-1645542824,-1444002743,1556367701,-133984819,2024001238,1111359982,357467748,-1295383407,1579915028,709701148,-1915982179,-2140954115,-1577713289,-2091877045,-2028401021,2022821490,-391801437,203418131,-399491714,-840984788,-506981637,1927800788,-110069991,-1356049011,602234406,1185389904,-1546024237,-1855453445,-1324149158,1540079764,-2128219329,-750682785,621912575,142484060,-1631024961,7112138,357047546,2090143791,1307496102,-2000031403,-362731222,695178355,-157727094,1763920633,-1403708755,1739844946,-1930361582,-967693153,-1442247218,692777708,875281031,1160426923,1704456254,2099609511,-933317785,186584386,904837856,-683224014,-1501370242,-324558171,-1688175962,2007571348,606831532,-1947316057,97956837,-815424817,-142223011,-1548564044,-42928323,327402365,-493386462,1863402425,-1323644291,-1763802112,578188606,322535673,-545308871,-166997366,362471013,1789197690,1487630122,1219392602,-288848448,-384672681,-2134337791,263348361,-987697963,-1328202038,-144489299,-1342627668,-2098774420,-369494530,1653792110,-825022940,1291000685,-165655202,-798924295,1101004949,-41848232,1921574396,698543080,836647729,1624192859,645791656,1100739562,-849429579,-395942546,999923536,-157122793,1699941940,363048458,869908332,118572179,-389773861,-605227996,-989941396,1788500018,1306653512,1057105654,-290184233,1389828758,389274865,506301063,1230588788,-1736777007,1848419121,862885297,772384187,-1500007844,-1175640482,-2054369211,-254473495,-1719632218,1978454082,1376771436,-1894567013,975154913,-1645081270,1265202894,1445039254,-1519908809,1537798788,-1237912927,456977192,-966702392,-1306070400,-1924228412,1745791386,-363416352,-412719023,198298360,1960390957,1598140127,-427635316,-681784634,-2124265275,-1259518947,592047124,-1418888629,1410853391,450460355,1555402635,1973010577,2060282536,-1283222919,-321804157,-1312402174,646183802,-334159515,-669974778,-325948221,-281444382,479875518,178869430,-868850858,1279839245,-1879304022,1126294191,1610431572,1835739116,-2144665991,446810904,-1157810183,-1237039790,252088736,-1374866965,-658940776,186858500,224442660,-624845214,1225383046,476021961,-1601917100,122051877,24701840,-481480344,1694173211,-1007791150,-113592903,-272144362,-536368572,-939028135,1949959757,-607507152,78274854,-882070730,1037879848,1855757459,311804340,1302237876,1892454383,-1452185181,1170924867,1171829320,1172114025,-1193678709,506235022,1521191048,1884931536,-1025833167);
/*FRC*/Random.twister.import_mti(515); void (makeScript(14));
/*FRC*/count=301; tryItOut("testMathyFunction(mathy5, [0, -0x100000000, 0x0ffffffff, 1, 0x100000000, -Number.MIN_VALUE, 0x100000001, 1/0, Math.PI, -0x080000001, Number.MIN_VALUE, 0x080000000, -0x07fffffff, -Number.MAX_VALUE, 0x080000001, -0x0ffffffff, Number.MAX_VALUE, 0/0, -0x080000000, -0, 0x07fffffff, 42, -1/0, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(547); void (makeScript(14));
/*FRC*/count=302; tryItOut("mathy5 = (function(x, y) { return Math.hypot(Math.fround(Math.pow(Math.max((( ! y) | 0), Math.pow(Math.hypot(x, y), ( + mathy2(( + y), ( + (mathy2(((mathy2((y | 0), (0x080000001 | 0)) | 0) | 0), (y | 0)) | 0)))))), Math.fround(mathy2(Math.fround(((Math.PI | Math.fround((Math.fround(y) >> Math.fround(0x100000001)))) ? ( + Math.min((x >>> 0), ( + y))) : (( ~ y) >>> 0))), Math.fround(x))))), Math.fround(Math.atanh((((Math.min(x, ((( + Math.fround(y)) >>> 0) ? Math.cbrt(y) : x)) >>> 0) + (y >>> 0)) >>> 0)))); }); ");
/*FRC*/Random.twister.import_mta(2037832577,125872707,34401772,-1648103367,1740512706,-842262978,-1458644149,-420564900,-1963351073,-789582722,1169488950,-1038668330,-1121063904,725075813,945521233,929962447,520233843,-2067033494,1443569185,-159106012,-1847474899,-475789968,-965512774,1150878793,2083460201,-800273444,-126877479,-1826413907,-3360991,2145892965,-1323069195,-301009629,274048938,599899931,41487399,1956030575,-2109226340,373171256,1374071141,764995043,-998249077,1460190670,1364740173,891629058,317126082,66091147,894938183,-105655068,507340535,-1679324109,-812190740,501767951,-1965075008,-1782966857,-1426083611,-630296069,-656708993,-777411843,-615144672,778644222,16383435,1447225104,-1726014636,-1346085892,1048527314,-1061050015,874089952,-1450972046,-244899382,-1606076854,288654227,453028051,-131711254,-1110190479,712850570,974806037,1755690819,1697606956,138241658,2076010528,-224162523,-1491473295,1644405114,316937966,-1841096446,-727874941,1119215815,-715100981,407674008,-1627227232,-504246153,1724120214,-308738894,1846473163,-807892680,390326343,-13251689,426442597,1901357255,1428435239,-1841210536,1031418632,2050336715,730511755,486881560,1847582709,-1600191607,-1215584370,-1353213978,-163211843,48801235,1377983126,200156390,1281571515,1521011130,296151607,-908501915,-1051821487,-1177845342,-645431658,1242231997,2055556192,-1011116268,1960120726,1470668806,2085581766,-663087436,-2131406856,1895654418,-164155411,-1823818501,-1779114439,812287003,-710311246,146604215,-988781317,-302472916,-1387414630,-1126246205,1939831792,-755311479,566291466,-831746375,2040515312,91050416,-1191611397,721788321,-837383359,1661430682,496049424,-1487269796,-18968105,-453838965,-324002095,-898363506,-1819396066,-311131056,1961825696,-1163697399,538469045,-1963766864,668738257,1327915605,-932065712,-1972152865,1858136722,1207024274,1003673881,-617795064,-1389190954,1109494906,-1842204719,-149305034,-1887421145,1744169018,-964422517,2123339990,-580385027,1057443450,-871253926,-1198027790,574903953,-1751387233,-755239063,1175881279,-283388600,1711968767,1462534776,-864062588,-156208823,212224359,1229228037,202657110,-1648948720,-1084335401,1208377854,2117786257,-2087384553,1476799944,-63546501,2019868370,-249192230,-93997080,-1797554095,-1909649709,-612568403,-487012451,1194451892,-1781900369,1080645998,-1947406191,-407963899,144447769,-1267242140,240493455,-196681759,525281395,-877162644,-1007575159,1062846305,-151191364,-950322799,-1179352103,207333860,1192065456,574260762,-902444974,651111010,88719577,806925075,-1128614197,-915259332,-938302388,751659148,-422725811,-28848547,2096645273,-2038076791,1326937572,-42773572,-1275596338,117769137,1821143682,-1799851450,879834199,-862814688,-1281087752,1083607113,1491665142,152555730,-1274689197,1492082789,-1592289861,1981847848,2095949073,-1132822337,417380858,1989666817,-2084437074,664309247,-471263609,1974421542,-1529787707,1958517082,1541186070,1632136539,995265820,1723017183,-916921080,-1772641280,-1437185839,1768622102,-854316481,2029245484,2072003395,1838297923,1641378628,-253572120,-29214192,-797490392,1065454106,-994944208,-1627310579,-660849002,-2124360717,1161981882,1349762294,-744224015,2053656270,61325317,-2118931306,-1531848732,-1833738780,-1485993963,1620146234,-1975812738,1645180978,-1408342087,901016753,-1356704483,-1338565935,-1648986616,-620678005,-429515653,-1676196866,1800497415,842910948,-2136272628,526511412,-1560392123,-1976199984,498328697,-2100419985,-207645761,-579953630,-1518940997,1041611942,-169762163,-1084441148,-697231114,324388107,-464289773,-590806951,-177863862,1205177427,554218984,1199740285,-1514654111,133082937,1836120376,1045271967,-1438354826,-2041373946,1891880880,1188146731,-1612131057,951289199,-1216348287,-1003573372,-1273148757,626829969,884840617,32909505,-1269085686,-1245007745,-2083347658,-1474767685,1366659292,511702041,-1546009121,-1933984877,324755596,682717603,-274704081,-407139069,-46447089,403051445,1805806921,734043126,-1484838695,1600950382,-762026429,-1705148059,-869410658,-1015389351,1555626052,-315555164,-2086677389,-1556767324,-1519913792,120851656,-918444593,-2011914859,-453233402,-1259600114,-1509370889,717756602,-1248487811,798772968,-884280758,1397730832,-207052541,322260194,-1721275385,1284744429,-846151744,-1378249255,-1541704168,-1110637735,437432345,-1825350266,312365597,-800715481,-1383244299,-1776629912,713763708,-627918178,-9248849,-1777586074,-1317574284,-2000736170,1302150911,1605354397,813308410,278369286,-932324849,1763233379,-993629031,56317542,-1656966995,1385580030,688082357,-96648634,-102492562,-1911168423,93111264,772865843,-702382343,890007356,-1588709544,1118851014,-1958329240,787065448,-1747557581,-85526019,-38361445,849920354,697700801,-763990414,1921106526,1164391411,-693860866,-1231482137,2070056669,-1214648892,1581923215,1146505280,494928913,-1483164192,37230436,322261932,681755868,1764398996,1786756326,101250442,-121815860,-759125310,2044673333,-1266495688,-1077149360,-159772812,302645079,1990197100,1227400654,-1655521176,931281094,-1753039841,27090855,-1929525603,-756680388,124650133,-1249066126,287092688,826833354,-44964029,1560458290,1636617008,1746147555,-1178632695,-1908003085,-983492964,-742260970,475737921,-2098207639,-1374250678,-647178985,1115198162,-448859188,-931458874,396409592,220557421,-1356301572,-1993802238,884280943,1388368428,-1264172722,-904326389,981855704,-1417754435,524913776,752223807,-1184517985,917830925,2048987690,307223840,-1206809665,-1321322734,1428649400,1383804601,1009527324,-2127862599,1161886319,349585853,1963198128,1896179375,1462571362,-1018577668,525104111,2065020469,-349043526,-2058292930,590961831,938207392,1520593907,-901196473,-521642920,-1362283977,-330967420,-959541422,-402755075,-2120388175,2131782465,610917450,191165817,1050622238,-1549133523,-1953566553,620944230,1940428623,1539231372,1751809657,-1889756464,933755432,-369945575,1640572071,1403114087,-670554524,-1556972954,-2093822613,1187595712,-43608806,-1193662651,-1905915152,-1247213470,-1741300785,1028617291,-1678807710,811950191,-1119815341,-1704047301,-2124327033,1929303587,-877448929,40529921,115088936,-1320761207,1580310526,1441001724,1946019531,1160579543,560413114,-898653231,1827377367,-1395160879,2984091,1743453971,-1988362241,-1516907662,-606208969,1494549056,-417679433,449351698,-270869323,1197036037,652816173,1345510598,-1500680316,-1432188360,-327698859,793738742,389552295,-934997207,-879831559,-2128880554,653428933,-1346981675,-61011344,418371774,1553616489,-167694551,-1984149860,-976601141,1909995381,-1984566041,347645640,-1283995122,2144103053,126384384,-119063173,1667344711,-989127441,1366945037,-773101572,1523305880,1218375182,-863372015,-424680238,286957187,-702614376,1306208758,924947089,1171866679,-346032486,213345009,699101718,1176551719,956229949,685074541,-1745217913,-1622128288,-2133288527,-1372183168,-1829889989,1059153793);
/*FRC*/Random.twister.import_mti(247); void (makeScript(14));
/*FRC*/count=303; tryItOut("\"use strict\"; /* no regression tests found */function x(x, e, this.e = a >>> z, x = (window.unwatch(\"replace\")), \u3056, eval, x, x, d, x, w = \"\\u5137\", eval, x, NaN, NaN = -22, c, e = 22, d, x = /(?:\\s|(?:\\b?))|[\\W\\d\\S\\D]^|((?!\\w))|(?=[\\x63-\u0bbc-\\w\\\u2bc2-\\u00dC]).{2}|\\W/yi, window, c, eval, eval, x, x = 15, window, b, x, x =  \"\" , x = 15, NaN, eval = this, let, window = function ([y]) { }, x, eval, b, eval, w, eval = window, x, a, y, w, x =  /x/g , x, x, y, x, c, b, c, NaN, this.x, x) { return null } /*MXX2*/o0.o2.o1.o1.g1.WeakMap.prototype.get = b1;");
/*FRC*/Random.twister.import_mta(1963413310,850201618,1731894179,513537786,-2042248139,-383337271,-555757252,-1806056496,-564162759,1934348759,1304652455,-1040980436,77610681,-1402718853,-1265882818,-105285220,176403026,1567374862,-65887915,1542430528,231817426,-29703840,844990347,453568991,173664178,646564601,-83354549,-1831946747,-845128735,1962528963,-1039699880,-2120101594,-65092906,1253366061,-446770141,470826467,-1197048149,-1668214255,-249105749,-1768180759,2048896893,-551963756,-900623893,-444877372,-1490868122,1671178053,40346773,-1691961746,-211742029,679356111,-1865969398,2076326582,642685211,-649993864,-979770243,1444051997,445880952,1283756162,448039131,-195333175,-1717643140,612593977,1926351370,1826596933,1204732351,-737741472,886689102,861912525,1270706467,1108371836,-902284693,654497248,-1786829314,-1547990502,217896761,1045894597,-1649626944,-1788107214,-610651023,625656441,-245879487,-1219301664,760291536,-644736990,-418069908,249681110,2002901566,-1044888400,1684039669,-1305618070,636113119,-914321226,-1642947254,885485492,-58219183,1072818246,98660148,191200340,428320207,-69756912,2096798939,1236671371,-776907464,2087049383,-1569425662,-1471763820,1067967462,2032087738,-1243040425,-27699165,-2086177881,790809197,538339190,1772224427,1436785036,-1387264538,1230378805,-119446478,-1079554443,-612413039,451390539,-511640235,223118635,-740663360,-1763619660,1545257200,-1708764930,-1219536487,1667435644,2017826717,-1105573196,1865325354,1972495007,-1548504495,1037436512,1341610316,-1043889594,485334349,-1338046444,-1431244742,1438807313,-1167697866,-1863937070,-352271787,706266426,572844205,1641562191,288229941,-10730872,316140042,-710682632,1912613780,16784000,-392850071,-1741413764,-1938219782,-1460797149,753892194,-2106727437,-1967891438,1557049643,-93168803,-873981338,1981364422,950446463,-349288451,-817275561,-435285620,342123021,246263787,-811848710,74803962,1893177753,2110084009,837751527,-1007038306,-860662887,-851647314,-656784181,-2266828,-1434045060,760598470,-611470664,-99757687,-1804442401,-2122733665,-454736737,1261485500,1469025048,-654209709,-546083191,-409490789,69109803,-1393991673,1123080751,1352135719,-960812693,-1312748544,-2001838109,-52593099,2095133184,1343674582,1604154791,-1299240319,-829919631,388992627,41340969,1759402411,-454844424,-251760395,-1288937752,1069463172,128140647,1338099504,-820325664,-448016156,-1405809032,-1565399216,1155059650,-858364184,-688885219,1865583277,-1860301353,-222484881,-210024726,-1400797072,-1710981556,1040193757,-1153410613,-1310809048,1495450905,1030627770,77568320,313733248,786836574,1335059735,845738391,1014591091,1557224288,37534782,-1567010531,1592849632,2095657876,665535249,1860327753,1716501834,1580065117,1687052054,1269979477,2050342251,242828317,-1959396278,-811996592,-1231622830,1616432415,-988207763,1472577007,860087620,-1460987282,-270757312,-1392520281,-2085844063,1390009094,910789017,1670020441,-1681988578,-1076910128,-845355474,-178439683,-1121433784,-493632761,-1403312679,447431856,2106067773,-1250897990,-170112557,-638072414,-64163028,-1155123899,-1284764444,-1054945490,1800087105,-1078148506,-1967670859,683878755,94546714,-1616939411,-1781901943,-1083916126,936734413,-687235987,-569278566,-1092195177,-1381066467,1296856138,-851632786,1572295701,1454012194,-1169145490,1664470223,1796546409,-127329656,24046661,1743787786,850744663,866693794,-867740802,-371292542,62809036,-1649193208,-1148007065,-1345707597,2050799540,499875663,715531529,610857678,1610632973,-2019065009,-1720542274,387429551,2056719868,-1983024753,-867824319,341175936,1405358237,-647361096,1248718192,-2053458805,315737472,-587942465,-1319470052,-796115779,2065613589,1737414756,-1740861728,539037026,-1803789168,-1655362751,-100885275,1975456706,2083086661,1571991592,-585104748,-67336724,25053221,-1566943719,1643117693,756819775,-1059014843,1019137489,-1242975594,-978884328,-1778916798,1402252358,1142860486,413024323,164475698,-502568413,1614854363,-299486015,180762241,-143125049,-183513664,2092331140,-878814476,829090247,1654399421,572364117,-2035807400,-1311065041,-615077268,1917972996,181049312,1879383004,576713082,1670708481,-1959197374,-1402342834,2085402966,591643279,1221366680,358983766,-1881714490,1673531829,-298528222,-959503514,-1497240562,-915028478,-835421373,1147697044,1879771308,-1581207427,-1699488666,1782493080,1897650248,319361384,837589456,-202801679,-54738890,88387484,-270311750,-1397248983,648443282,-1365689987,434847731,-1207119172,-296766342,-1642840422,1986872823,-1412117495,-614007330,-87361624,574028044,1558731835,1791215176,-2046250216,1072214130,-1167534274,-346624902,1631777957,-1749578489,543682557,1779564206,-1995505484,1313974065,381168081,-1211256545,1118548432,365502621,1203683700,-2125814763,-535080993,1180724003,349814566,1872061288,-1842392911,-2063927454,1325846411,277064781,-1610433205,653406041,309716024,-260063451,62879506,1330326043,938175569,-1462831333,-1877540461,2115159993,1908377606,1770510893,600023375,-571064014,300381651,2086910038,1582171028,-1316420940,1780648117,840084512,1028472010,-90637624,17001853,-846221690,-1660695548,1436571755,-680347525,-549254773,-1015945560,-975934311,1413592710,-1206283982,-2007289948,245348312,1630597738,-465054535,-411730541,-1723075739,1054918497,-1667476711,1833161798,1078629140,-1285050895,-1726976150,-522653617,-66753291,-285169072,1666029641,761707057,-487649853,1590495659,1082632536,1527899716,-172685853,-1810134679,-1890020762,-363827462,1262727925,-1435451581,853875192,508051889,-757146550,-966281278,-475786377,-457321912,-2146042315,1351974434,-318301146,444977289,2110089453,1918399323,1466523728,1453871633,1151526373,-1939774241,-1096168290,1603404952,-630531839,-1062413174,-1306167965,1045300992,-456455549,-1542821853,-1659760709,-545912953,-1537221075,-682961946,-2062460862,-179029575,-2090164201,2105553777,-1337635254,446401412,-1351867081,2099703439,-1487264552,110543014,18467813,-1474279086,1631967221,-1252280905,351819906,1977267831,1323911529,-772121577,-99009704,-383938366,-574162063,1591256213,-1873041185,1338639777,1535769372,-26015516,1479582277,1644872322,-1837216773,1557063604,-1043696411,564839101,1931807155,793881296,1209622460,-1482278850,-647524578,-1423458424,-847391689,-548467090,442843156,535084859,1088515086,1391104317,-953399128,482072579,1670507790,377181823,323286954,-886546469,-1545764850,553726050,-1616178446,-1685623670,2101939504,1308696147,-548190467,-1507536104,-1056110552,-803349030,-147088971,1807683883,1605965767,1912704721,675112747,1376042523,-720297562,1063629414,-4356350,-75217290,-2107964189,-1621299093,2011060846,-1007256738,899848624,664598867,1953712596,-1803977218,889232915,1522717787,1418176422,1122758603,7384680,-779414120,1798392922,-1706144914,1359974313,-1749535692,-2021792812,634120694,-2104309848,298658462,-1927518301,-2136748387,-411663562,474652892,-662305751,1265581647);
/*FRC*/Random.twister.import_mti(186); void (makeScript(14));
/*FRC*/count=304; tryItOut("v2 + g2;v1 = t1[16];function window(z, NaN)\"use asm\";   function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    {\n      switch ((((i2)) >> ((0x24c63a12) / (-0x678dfd)))) {\n        case -3:\n          i2 = ((function ([y]) { })());\n          break;\n        case 0:\n          d1 = (d1);\n          break;\n        case -1:\n          d1 = (d0);\n          break;\n        case -1:\n          d0 = (68719476736.0);\n          break;\n      }\n    }\n    d1 = (d0);\n    i2 = (-0x8000000);\n    d0 = (((-1.00390625)) / ((d1)));\n    return (((i2)+(0xf6f85f12)))|0;\n  }\n  return f;window;");
/*FRC*/Random.twister.import_mti(489); void (makeScript(14));
/*FRC*/count=305; tryItOut("/*vLoop*/for (pmgvch = 0; pmgvch < 85; ++pmgvch) { z = pmgvch; t2 + ''; } ");
/*FRC*/Random.twister.import_mti(521); void (makeScript(14));
/*FRC*/count=306; tryItOut("testMathyFunction(mathy4, [-0x07fffffff, 1, -0x080000001, -1/0, 0x07fffffff, -0x0ffffffff, 0x080000001, 42, 0, 0x100000000, -Number.MIN_VALUE, 0x100000001, -Number.MAX_VALUE, Math.PI, 0/0, Number.MIN_VALUE, 0x100000001, Number.MAX_VALUE, -0x100000000, 0x080000000, 0x0ffffffff, 1/0, -0, -0x080000000]); ");
/*FRC*/Random.twister.import_mti(553); void (makeScript(14));
/*FRC*/count=307; tryItOut("\"use strict\"; v1 = a0.reduce, reduceRight((function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var imul = stdlib.Math.imul;\n  var Infinity = stdlib.Infinity;\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    {\n      d0 = (-140737488355329.0);\n    }\n    switch (((((abs((0x630ac9f0))|0))) | (((0xffffffff) ? (0x548b4f0c) : (0xfd44b476))))) {\n      case -1:\n        (Float32ArrayView[(w) >> 2]) = ((d0));\n        break;\n      case -2:\n        d0 = (d0);\n        break;\n      case -3:\n        i1 = (((((((0xfd6876fc) ? (0xc44b2494) : (0xffffffff))-((0x0) <= (0x3d3e3544))) | ((imul((0x250ebfa1), (0x58e1811e))|0) % (((0xfdb87ff6))|0))) / (x == w))>>>((0x324d0e82)-(i1))));\n        break;\n      case 0:\n        d0 = (Infinity);\n        break;\n    }\n    return ((0x66bbb*(i1)))|0;\n  }\n  return f; }));function \u3056(w = delete x.x, x) { print((4277)); } a1.reverse(a2);");
/*FRC*/Random.twister.import_mta(-356516872,1445543224,168383713,1976110207,1093419666,1237949708,-457844587,-271824720,1486981768,1369879030,-1091711604,-1388975500,619603563,-2128549567,-2045359258,1735860261,1918780220,-842914243,-335577928,956305435,-2055882866,728801120,-171036523,-1835303202,-1439974818,-828555180,1499523945,-1316406754,-171150993,-1764882125,41638211,1808155126,-1142153923,720207579,924574193,-1019485015,-1013348623,-1911641374,1080703386,1627230211,1619662401,-324807577,-759208023,1969470314,-88914107,1749343664,237775909,-1343024227,-86192151,-1599258722,-302637880,-197313557,1562343610,-1841063732,-775802978,-792753138,933576082,-399422236,-43316561,-45715830,-1586790154,192563493,-1842718665,1081551560,721426381,-1746712543,497328701,-378122203,-159740731,1666688097,-1863283624,-815006106,94139275,1735346801,242750873,4845496,730145139,276987486,752397424,955208986,1699328017,-902511759,1099618391,868282914,-199800934,-1566539147,-1073425897,389935056,-166312219,-1464860423,161935978,-1377418394,78560881,-406009041,82383463,-146427271,-1851181245,445902942,-675568910,-1405727673,396558937,440251236,-109961923,-1008408629,-1840979320,-1132993916,-667792619,65606721,-1229888788,903615786,-736361120,1842240342,-545244079,2109254806,1073762530,-1191092576,-1341008186,2020793211,-1423631217,236044283,1768166143,1837860649,396568800,-1346655015,-905508773,-1878972476,500767636,-705800173,1918937335,-1709409000,-2101119956,548069767,-179217786,-290566790,1029711650,-1886395372,-1437036298,-1085955886,1406056635,-219135566,-1257020087,691445276,1507025986,1106524703,-37719298,-418522735,1080420818,-977855972,-1602853433,-149483379,668512607,-1864653409,-494370870,395569698,-1202747751,-1789980149,880639795,171969245,429181373,916823215,-2053414964,382796928,1415394995,-851264548,188328735,667652458,-668944562,507991534,1091660100,1034638825,1574832710,-511569891,-184514506,1188262148,1028075596,-1665076195,1894065192,-434019056,-1262032063,-157377872,2007750529,-1301427282,2139698321,-1367830656,-1749713597,875123821,-1011053114,-355807836,1704307628,25861678,-2122550087,-2067864819,-42103283,-800212253,-481823529,1866728908,1736782950,585242668,484592051,-64250397,-1218995200,-1055371166,1136221889,-873587113,-184316235,-331312865,958325236,124867055,-1145742082,219252946,489993353,-1700152316,-160696832,1287398698,-387210468,118818965,-958347364,-451836875,60873346,1893879417,-10690793,479973783,1626729845,-1630855101,1242195172,-1786496241,-1922596098,1847027650,247885612,-7305550,1803426978,1130597938,1083180364,-205074758,1359825636,-660782436,-695028208,-1870307268,-1406421909,-1398112710,-296185039,-1201483092,-307613326,-601366713,-18483048,1575042249,189218704,967060475,-1889341174,1811554884,-1761509125,-840478858,-1781123331,-1337705159,168630391,119938887,-1888486511,370070644,472385750,1956332593,-231502892,1584860274,1092063418,1800669314,-2083399443,529394290,104063764,-2094253472,-1304954941,989738741,-1169778343,-1209604835,-813143823,345263096,1276479403,-1775817928,-558152184,695056053,-1383383655,1032855341,2129574707,-837005651,216850443,-87287300,-354412183,1806434630,783021201,-19275609,-912765284,547759838,796890373,-310668967,1480373360,2063767576,-806822254,27891216,1208131568,-1915179793,670673118,-1457632032,1532741429,-674770076,867296317,-1411958009,156641039,184223183,1275074139,613843447,-991075083,-2058678725,-47361500,-1995891648,894274829,1281323084,84514487,1595855292,845902209,1159708597,2137336302,971323535,2049098551,-71130088,-1116781255,558075858,908523138,-1299360694,938714845,1590419609,-1387308700,-1579211981,850020682,1992504285,-1884254538,-735310747,1408865008,-1131459420,-495046571,837483469,387044023,2023504940,1398928514,1854951848,-989914026,1772503563,-264814424,1121604206,-2120803141,-803407486,-1428401890,223867307,-848816043,-2130904710,-104107545,1071009527,1084868845,1988522350,840005846,1810602142,-1900983496,691728665,1276835654,1206370754,-237708202,-1885880948,2130207982,-74966854,2062957511,-1236836123,-388796204,880292212,953991965,-123389682,-552643457,1363808623,1836438595,-1511331994,-1591481942,1509879284,410186759,-957467130,488717833,-1079759110,2108140046,57087522,1764203374,1257521082,1377796014,2072629938,1961181002,1817752293,1152013117,1180714284,1389676198,-525509782,398712154,1508320684,-1655219250,595618397,-1558165549,-1024383125,-1988094001,1846807173,310696060,-1525150962,-98104242,-1008651908,-1181448707,-1785346651,1049566581,305810046,-753011628,-961674811,-2091529553,-153260318,-372337624,979497877,482276785,-187235708,1830234496,1873737809,427228610,-699462784,1807975830,-1717217503,-1330201573,-1643372061,-1652669173,616283281,-490262312,-636175340,585828711,255527931,-433303924,248795200,-1754379928,-104323249,-207986744,-1937911184,329273982,1008357747,1166464822,1239206993,1187689244,2018370126,1743553218,-1899032112,-1579057553,425528340,608441748,-851529540,371343419,1693533309,1149186361,-1286185259,1093690888,369290870,327774775,1920420530,1573195863,2111600680,709871835,2009767335,-1776507746,625617658,573869278,1518502001,-854422162,364516770,-767424017,-240715285,-1744156523,-1180032140,1836664316,-1603508973,-753523219,1523562599,-1383927509,4659624,-1152998059,-1242333321,822041374,1183133634,-297609281,1751514420,1636729180,-192515027,-81745418,1514978794,-1474742152,1632912406,1188887456,537127619,-863461863,1100982823,-167506659,1319018086,-1227957877,-483125851,566916378,-421067052,2007470105,-1529921841,-461782500,129567181,1093077412,-1693928566,-371570762,-654000230,1849214943,660099107,1217429547,1371134788,-191626250,1912541918,-1861164309,2108003011,1089489051,-278552725,-1302555943,-212762130,-1341186858,409561488,-149281524,-2094677959,-427965156,1701905663,1253892323,-2082068511,806320643,731071256,-426049851,-2014804661,-312425897,1605174327,1742594468,1567175128,-1856296302,344393985,179074628,2133958988,-272983128,-1149926692,-286568600,1332210733,831616980,-2003901303,-813573606,-351819897,86971927,-1867794249,511314848,-1019865217,-2088225525,-1480313857,816616259,346215369,1745023666,-1842315956,1634461365,-1413734040,-939585414,1061836159,-384003232,499673745,1582136570,1512272573,-295251090,1930510981,-554849815,-412534782,-1091363115,-1040206289,-789624434,-2009766034,1820354224,-80572135,1574398362,-1027763924,-851488961,-2022705281,-2116128511,-167191732,630462690,1385692354,65369715,1814312765,-974272173,-87110534,-403720587,2093145884,1067274846,1416688701,-1539653239,1160312902,-880458786,821445242,-488703586,1127476778,-648149855,-2049042265,-611525351,1464627369,-1344906855,1655379580,-308857082,842082260,2123591996,488204605,-1755208650,138349603,239088533,-1733759899,1093150112,295800388,694953545,1974230174,616441770,-617820109,-1623649603,560957245,-1366815996,-1568116847,-1520956844,-1475828174);
/*FRC*/Random.twister.import_mti(347); void (makeScript(14));
/*FRC*/count=308; tryItOut("/*RXUB*/var r = /((?:(?=.|.*?))*)(?!(?=\\1))|[^]/y; var s = \"\"; print(r.test(s)); function e(NaN = Object.defineProperty(z, this, ({enumerable: false})))\"use asm\";   function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    d1 = (d0);\n    return (((1)))|0;\n  }\n  return f;print(uneval(v0));");
/*FRC*/Random.twister.import_mta(1217721537,1059872124,1629294987,-1458162042,1257292803,-1177123607,-755093674,-1770534646,-349017721,-1495112901,-1022414689,-168780129,-1952281087,-1877552665,740106504,-1166349519,1228197155,-1674499468,-1488057,503590518,-1586541260,-822574827,652429118,1281564909,-1325290582,-1636089603,-2124297682,1398289523,1281594789,1162566005,291019882,1715048089,376091558,-1603385024,-1213314704,518536491,1238566193,-145009243,1354653585,1524098103,589596828,-470331019,1185647814,-505953205,1040097929,-657189423,-155395233,-2088086039,-560361953,-686133237,-95739586,1254861257,-1004569382,2126731252,212763258,531476464,-2024867673,-1500687488,1755437363,1128051276,-1362960641,-841446253,501738828,-1496878110,-449607320,1103512927,-1996901833,-1073644957,-1306402146,-982856894,1913645713,159678709,1528425484,104788614,-1181821784,-508336742,-1473422788,-981830699,1186468586,103717372,-1135228721,1116436897,-1408039322,183826643,-1898062297,390598251,603654876,-1014164751,970376334,-1074540349,1287625817,1934022559,-876965538,-1650408884,-2102820064,492090727,215372296,-572924828,-2121463654,1679288440,-299185129,-2072261797,505267694,1048961373,-84619379,292050761,-549113038,1518319826,-1041843937,-1009498874,-1344040399,-655333080,1501824616,1754310746,1295610900,-1399002987,-1798385732,495639667,-1549402655,-313855685,1084812320,-1181940055,2105861981,1275340836,1349122674,-1175017274,819617007,105193912,1753168499,199056117,1253828605,178771776,1556374949,-1205146284,-2144372927,-1202943444,1037406,-1758327514,1678840065,1390029033,1075594767,642106469,-960295780,-782589225,1375461067,-1898333311,1841062179,-123537944,1779293200,90518122,2053293463,1953180146,-614314586,-1688897485,278474405,1086208589,1005356622,-1519499454,-1762087615,1791974740,-648478964,-766653133,-1927447418,460027178,749706698,-989017913,1391181926,2126891096,-570529642,-1064708531,-623314348,-1536299534,-2080341888,-1605335309,1452768510,-1466049638,-1155148314,-1343511601,-2139235263,-1089850747,-611617541,737371560,-1873563457,1393327999,890552741,71982593,670210576,1898947493,1826715690,1549485008,563678499,5882284,-1913867598,-684320534,601028315,-1745331270,1415181392,1560074200,-1746191276,-1183500386,599770651,562699038,958506835,939895452,-1201370887,-212260509,-132444588,-263349895,1958339517,-385770585,273528639,-330014922,1851858614,976609819,1110104304,1649952366,-98435967,1757170440,-724186243,-2112292610,208242727,910906584,-1224562749,-879937162,826458825,-471086293,-553445933,1341637463,14949925,346169306,-2002259553,1790494373,-2143951948,-1166505436,-1170642876,-2139409777,-291450075,202529397,-1549426302,1703311174,-869812047,1523071409,1298248781,910569839,1808336079,-95759217,-1679914156,-1495386703,-1157263305,-1268041828,714114902,1658978315,1599205054,1567618762,-909931761,-757278542,239874895,525113345,-981689250,796096076,-816459911,-1759149779,725760362,-785163880,-1197629284,1403498011,1531050247,-482884702,662764240,-1031769931,590087706,-1020123602,-1835126739,1237231701,-2003189643,-1312543461,446962574,1971719981,-1928653184,1650495900,-1060781955,-741326176,583770894,1798718668,-748989661,-419654748,-447155520,-904988239,-1651793924,-1823434991,158469009,-1993485488,2085030227,-1358045826,-2133479061,-1776243354,1519267306,569589502,487302789,-1346584759,769465140,2036242025,1833978054,1972304228,1494172141,-105862888,-1922209320,120310378,-1725542813,-762990732,1315993331,1299425406,828880461,-1200131752,-335381969,-1175729007,74760134,1930234030,-155387129,1872969754,-1606315968,1159106915,1307931278,398797129,-996182463,1132227371,-763713301,-124952411,1302129181,1195958603,-1662203796,-47413034,-495525468,-1229325750,1144528512,701567466,36276287,1029950389,-457279682,1882520617,1608024206,1866922559,1095203151,-1395298328,2095576388,979813219,-2059104774,365348015,1714310819,-1036493912,209343641,-1249578402,2132098914,-1987704762,1023809807,1903658520,1042847418,1306739297,-953016557,2060000774,-1680273995,-1195042454,-7908118,2138301993,-1426718341,-2141012931,-789501884,880148069,2088361183,1134943693,-318226864,-1485519829,2138309609,-1039254563,-363362725,983312581,1771717776,-279769269,1461465841,217735805,-2071498930,1850407842,1091416412,260000761,-2146150241,-1074326890,1460384781,-483762007,2104042654,910222791,945510332,96861849,-178625166,420097739,1379293838,-749353615,138499004,1379952994,1545457304,1506294712,1314009966,1607798976,-1173234147,-969518143,-837076111,1170157152,1825071240,499403422,586039447,-1176679787,-1454125246,-306801619,2133125488,1393938436,-1256723792,-71912915,1714471570,1460836835,-1366946469,-2124952493,-65954518,1446196240,35799285,-1794499966,-1963821066,1079815694,1914722569,316431991,1283474708,-245591233,-1500471362,-1955418177,-1271725757,-206820640,362887681,225758297,-1354796385,1503501824,1800521552,1285715245,-2016201492,1632600446,1585362761,-908608032,1876673504,489538709,-826900748,508265197,282332294,1696282369,1627204503,-1971983734,1665684638,-1080351017,1157018732,-1876420639,765049475,1062062443,1414986417,203077382,412447784,-1321780725,-757192718,-4549302,-1201952110,-2060654795,794525079,2081295513,-1156319845,-1737744168,1788027093,494249521,1937004249,1801267581,1387354461,885807229,-196560056,-1371839197,-1592586385,120472369,2116903211,1743409167,-1494342104,1049326561,-1140387128,-1192441691,1112877241,-614902971,-410016986,137118906,1480203302,131161935,-1436496937,-112505002,-2072474479,-1511053622,705874616,1942568087,-264133308,1883588862,-1026455571,-89841285,1796217122,976723804,2013419240,-102353573,249744977,785453901,1500830318,-1618259004,1139452270,-384740648,-1643963701,1960325994,768901135,620432238,1038805115,-917179870,-259714137,608208696,-482776650,-1151818771,1320877477,699453284,-901575586,-1587714517,927407206,-321775894,1821849573,-954890373,-1351480546,-1229484007,258907100,-1098671862,698307206,-1853105366,30317355,1260801489,1928034520,112917401,-439504842,-1686643301,1196460632,482083884,-297612747,-1854138870,-2094521594,2078190484,-733217305,46692190,-1353280983,475257883,-1986608629,321147285,1809103262,2040369988,1313923053,1968278505,-386754462,-2121700967,1880383530,1890998064,-29518723,755971650,-1988443596,-745726327,-1867190860,-374938459,485647934,-2026486022,1428292640,345002371,2122084564,-217792862,-1319682820,147192430,-479816898,-202554407,1866185022,-1494042819,-226335264,1875645822,1480358009,-1496146596,-486938336,2093763429,128874555,1898341968,-962300188,-532021819,-868012824,568578400,-487145442,-181171797,1812914008,1293328400,574368472,1487899871,2090039463,-1950687814,815838038,1689524808,1271505915,1599201043,-1236558687,1750436463,-1686215108,-1892172459,-1285698196,-551217079,-1708946156,-528463281,-1222126156,-625666058,-637776154,1865824075,-2099364607,-288395715,-864383528,-501325584,-783898148,10117028,-2024696216,-184313597);
/*FRC*/Random.twister.import_mti(192); void (makeScript(14));
/*FRC*/count=309; tryItOut("print(x);");
/*FRC*/Random.twister.import_mti(202); void (makeScript(14));
/*FRC*/count=310; tryItOut("\"use strict\"; v1 = (t0 instanceof a2);");
/*FRC*/Random.twister.import_mti(217); void (makeScript(14));
/*FRC*/count=311; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"[\\\\W\\\\W]?\", \"i\"); var s = \"\\uc696\"; print(uneval(s.match(r))); ");
/*FRC*/Random.twister.import_mti(317); void (makeScript(14));
/*FRC*/count=312; tryItOut("mathy4 = (function(x, y) { \"use strict\"; return Math.fround((( + (( + (Math.log10((0x080000000 >>> 0)) >>> 0)) >= ( + Math.hypot(( + (( ~ y) >>> 0)), Math.fround(( ! ( + ( ~ ( + y))))))))) - Math.acos(Math.log10(((((Math.cosh(x) | 0) | 0) + (x | 0)) | 0))))); }); testMathyFunction(mathy4, [1, 42, 0/0, -0x0ffffffff, 0x100000000, -Number.MAX_VALUE, -0x080000001, -0x07fffffff, -0x080000000, Math.PI, -1/0, -Number.MIN_VALUE, 0x0ffffffff, -0, -0x100000000, 0x080000001, 0, 0x07fffffff, 0x080000000, 1/0, Number.MIN_VALUE, Number.MAX_VALUE, 0x100000001, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(506); void (makeScript(14));
/*FRC*/count=313; tryItOut("\"use strict\"; /*vLoop*/for (let nxpncs = 0; nxpncs < 32; ++nxpncs) { const d = nxpncs; print(/*UUV1*/(x.sin = (OSRExit).bind())); } ");
/*FRC*/Random.twister.import_mti(578); void (makeScript(14));
/*FRC*/count=314; tryItOut("\"use asm\"; with({c: x})a1.pop(v0);");
/*FRC*/Random.twister.import_mta(1305888732,-174328190,1296244987,-1306336848,-633937301,-747714122,-1928480956,579518317,-1882804446,-1807267816,-30100210,-29903032,1759417017,-10657850,1770213738,-2101985474,1561150782,1407975372,-1263229674,1988584456,-1452906058,-34099516,1047457018,-460240641,-2147081039,1116906978,1705947236,902499835,-68046229,2056001340,-1194841628,1203051719,-513034337,-45630714,1561199093,164770564,1359556845,-453597930,-1189638499,-1095944495,-244414875,134480179,-448714793,1076155767,-735233207,-1138202055,286926795,-1717586896,-274183089,-1282150805,-500767018,853258987,444243195,1722444458,-2052899470,-102262766,-321024233,-1448155094,-1313452345,-1544526557,-1062649859,447024151,528027383,1779216540,1222420603,1336561206,112367780,-515154979,-409369964,-816564224,-507184068,-1767963747,-1686939237,1985235585,1839994108,660798407,-1863802808,837636136,937104515,1936388080,1450600748,-1222996900,-614690937,-531939609,-1253644315,-1223449786,-2042279354,-521375601,1042124827,-1123920310,2079492181,-1034753143,1190929820,426696118,-797723357,-1408507181,-676880028,-994178852,-672869642,-2079384468,-1459852827,-1085323341,-166786929,1721979124,723106304,1152549051,1460159285,-1040598344,-1744037928,-1071925354,1118382041,901175642,-1413281815,1702237028,1717016141,-731611883,-1558844020,-1525756384,-883506388,1572773483,1285210537,391106774,37917482,-888302449,-1482426482,-1881185523,714235832,1735664056,1035697038,-1961730233,-377356982,-604129816,-620695087,1986855009,-359541489,1332310515,-1256546407,-1029739815,569278337,-1194850061,-1056170180,1368063638,-148956627,339275660,85176452,-1467610602,552435416,-1690033091,-1815179457,655487250,1105936237,-101000396,-697664616,2115155364,-1526435358,-1805614804,26440244,-1180672031,217726446,1660723307,-2055217745,-1367595487,-868429044,1715711695,-885488756,-1756859314,309187182,-1484392833,717309296,-36138850,-1148186020,1592927870,1310111068,1047116383,14597198,602839591,1039785882,1751212547,-834120717,397121948,-1508577011,-31796802,1450981469,1895871981,-186545503,1271215473,122551377,-729197259,1390537357,-1905635723,1896515206,-1068355651,-1949109840,77784922,706739389,-1998964170,-615652793,1744519538,296500191,-353666806,1214939472,-116712495,-1749546764,-1248180235,-2079310298,935601361,-1098931344,1428151712,-975308957,1246760316,-1189244210,-999472585,1530354075,-1154031252,-777229960,322935595,-1360317838,1788746631,775572276,1575111117,-169163695,1324576486,-2015822773,284129383,-1469642002,1910025310,200329335,-726861807,-3475089,-803706645,1584804413,-634645583,-1907192668,-804191386,-71330059,1637774959,1262933501,-270113329,-1930130197,-674890178,187823041,-700761197,10327894,-236882042,-138009260,-111419204,-1126117873,1844187506,-1480444662,1797697361,1290336293,-1347496978,1814388359,-666385092,1554342306,635378451,-333255709,-1703516213,269264865,1607065852,803064655,145694016,558604232,222814371,338543300,230671041,-1892231424,-1565590771,-1337161290,-1260968742,1639827040,74093440,1107267276,-1939966162,1484067426,-1560657528,274225442,-459051626,1139538469,-1559180262,256003066,-725160715,-864241036,1551406681,-623861256,-1021691993,1610590500,-1905463293,-905578688,-1027032096,1855609140,-1342727155,1479319689,-539954994,-1436873362,-1965124511,-542267521,1984536481,407497958,-845294591,-739004054,1527001247,497387381,627552353,221578404,1903009903,822020805,-1007812926,-564634650,627835937,-957158696,889031708,-1423434774,1766639502,621880856,2082983928,-2071670243,-643545847,-1249686652,1457319356,-487774760,-158790556,1054983848,1826663067,1007193494,1741764188,1631657185,1463462964,98797513,-126260039,406131871,1512229586,535723422,890522741,-720293299,1073944,1201857171,1895177286,-727443567,-2077276242,-874651996,-537093579,-1039217951,-580511954,557129550,-906721839,-1907012381,-427469273,911473922,-579401287,-774902368,-668374977,-1961072850,-317070368,1607459508,581906643,887836328,1393574428,-1499907349,1340393428,705662164,-1789755526,-1445449160,963194875,463897624,1234627491,2079999774,1714962828,-380591953,-1046805243,-561365690,-475987537,277456679,-858911446,1593999488,-1492931209,-1984903576,-1284663606,1720670933,-735458241,154650741,-2055034548,181900303,-1735266652,-430188886,-25733321,-899604256,-70561824,743760925,-804161326,-39198372,-241848011,1120261108,997654313,388473880,1860299950,-721902545,-1784744688,1914059682,1765780715,293810751,-2065767521,-637730024,-1006832899,180286771,-131308617,424262867,778789273,2080162859,47570940,-1630318812,-1955332583,1649401203,499517705,811252988,570002372,1022079579,-12504844,435255627,-170246363,1874558290,-1308201960,-2107689097,-1640703556,131405429,-1313560700,2056120046,1848288218,1487790737,-990886101,1764466933,1191251544,1309815201,1839697583,-894629037,1263206131,647938684,-1934266010,2067056766,1490994157,-879681069,1738244611,936658395,-653864062,-50312942,157381710,-1949353884,-41893358,-445233735,783210847,366316834,-641523551,-149057558,1770754625,1169179454,806262001,1454783617,-313131078,-601798606,-2112342352,1367486140,-1831828212,507722954,392888500,880322186,1112638207,1892305069,-1884243501,-1710412801,-321079325,1716720705,1467268839,1442694365,212914814,-293433965,-1645844306,-1523340001,-2056663219,1966162601,-902078771,1924816356,1339191990,-476966340,-232693113,1594405702,-399604894,-345114239,1545214684,1287208733,223777243,-1750597669,-1743448080,1897555306,1409425815,-262576024,-448402198,339413582,1503466690,2085107711,-106955291,1745114956,771563251,-1075737050,744059478,1096337380,-1651364398,762377571,603465421,-620542697,-1383469373,1760575285,215587906,-1183437294,-803382788,-1676577356,1308111778,-429735183,-1882169288,-36184175,1773147218,460591591,1410253667,-1643711533,-91479728,-1074815893,1139434197,-67838092,1018206791,-511294467,1243382522,-415971150,1250052426,1848405226,1680909190,-886566057,129476268,-1711828458,-7907660,-1364705009,-1714502671,-1107322468,1186554676,1920585198,715982808,-1860547060,-199796217,724809846,1371565044,-1209190453,-1337835677,-1144916919,-1580508084,-1219776951,1420509230,1811178902,-1144825632,1540954514,743200942,-2081501503,1743015307,223307757,1929857196,1452800057,1126138761,-2143804451,-1661050549,1777632547,-2052788805,-597182136,-1465923343,1311149872,504047396,-260646272,-687943011,-1561875696,132166813,1032394890,-1504562881,1381532542,-228764194,-1694504609,-354849193,835092093,1167571512,-1266755727,1011267113,2004350204,157136806,2088644935,-805723060,1771620171,719184919,-1442340951,234694834,1085477252,-129059389,1959031733,2043359690,-428052622,1222246028,-23855090,-470883934,295957025,194885863,1582293794,1798334923,180003402,1352216259,1930991031,1204179589,1910078300,-1110950800,-1825710900,-1499527277,358147226,-1271707070,1048477459,-1684756560,-2137358003,711362330,2067517691,344944428,-1922526992,-1307342911);
/*FRC*/Random.twister.import_mti(9); void (makeScript(14));
/*FRC*/count=315; tryItOut("/*vLoop*/for (yajvya = 0; yajvya < 78; ++yajvya) { var b = yajvya; print(b); } ");
/*FRC*/Random.twister.import_mti(45); void (makeScript(14));
/*FRC*/count=316; tryItOut("mathy4 = (function(x, y) { \"use strict\"; return (((Math.trunc((Math.fround(( ~ Math.fround(Math.hypot((( ! (y >>> 0)) >>> 0), ( + Math.log10(y)))))) | 0)) | 0) >>> 0) === (Math.log10(((y >= mathy1((x !== x), 0)) + (((0/0 | 0) == (( + ((x | 0) == ( ~ x))) | 0)) | 0))) | 0)); }); testMathyFunction(mathy4, [-0x07fffffff, 0x100000000, 42, -1/0, -0x080000001, 0x0ffffffff, 0x080000001, 0x07fffffff, -Number.MAX_VALUE, Number.MIN_VALUE, 0/0, -0x080000000, -0x0ffffffff, 1, 1/0, 0x080000000, Number.MAX_VALUE, Math.PI, -0, 0x100000001, 0, 0x100000001, -Number.MIN_VALUE, -0x100000000]); ");
/*FRC*/Random.twister.import_mti(277); void (makeScript(14));
/*FRC*/count=317; tryItOut("\"use strict\"; arguments.callee.caller.caller.caller.caller.caller.caller.caller.arguments = window;d.stack;");
/*FRC*/Random.twister.import_mti(322); void (makeScript(14));
/*FRC*/count=318; tryItOut("mathy1 = (function(x, y) { return ( ~ (Math.acos(Math.fround((mathy0((Math.hypot(Math.atan2(( + ( + (( + y) , ( + Math.pow(0x080000001, x))))), Math.fround(x)), (((x | 0) || -0x07fffffff) | 0)) | 0), (( + Math.atan2(( + x), ( + Math.fround(( - Math.fround(y)))))) >>> 0)) >>> 0))) | 0)); }); testMathyFunction(mathy1, [-0x0ffffffff, 0x100000001, 1, -0x080000000, 0x080000001, -0x07fffffff, 1/0, Math.PI, 0x0ffffffff, 0x100000000, -1/0, -Number.MAX_VALUE, 42, Number.MAX_VALUE, Number.MIN_VALUE, 0x080000000, 0, 0x07fffffff, 0x100000001, -0x080000001, -Number.MIN_VALUE, -0x100000000, -0, 0/0]); ");
/*FRC*/Random.twister.import_mti(503); void (makeScript(14));
/*FRC*/count=319; tryItOut("s2 += s0;/*RXUB*/var r = r2; var s = s1; print(s.replace(r, c, \"gm\")); ");
/*FRC*/Random.twister.import_mta(-1353511343,-1916855552,1882119219,-443485227,-311851196,-1619273542,196156820,224240290,-1307588677,1716774484,1366342205,-1768211032,1031499807,-367859823,-1977032314,214532076,875820783,704704119,1522153920,676890240,-2118457450,1187385142,1587161989,-1229922347,-749781271,-1333235899,500821918,-1557823585,-856511462,1726607900,-1795646106,-250574463,-1168926040,-1633414960,1139283930,-6416120,1608309796,254704834,-1928014524,-954125935,1371521312,-795022518,-1580983927,2022640808,-1601763392,-430840095,-708245094,333242346,-912247900,-86226161,1038461880,1900264219,503049226,386143131,-1523520344,410777790,1029498452,-2073832318,-117565761,-1343614048,957335918,1251311510,-1222742274,-320550306,-1257922025,488272024,-1094312571,1203005376,637247231,2635443,1576503490,1320957933,251535996,1350901311,-573738021,1569297657,1413905002,1818736397,-1538056362,-1912039031,-1629189789,-2120763979,588673377,-1324245303,341549845,-1599031521,459270687,-1727083628,-156260281,261885300,-465838137,801582547,31588096,647402901,1461212742,449426904,912074233,-1683291885,-1488821540,-649228701,-1624111164,-1639513241,-1966189153,2106100300,-1767051663,225255267,212184842,224316424,-39848423,-718481840,958614112,1474983484,-550312079,-1026341684,-1075637737,-386082604,-2103820564,-105245662,-1171272632,1495732986,-2072541101,-50948604,-717328694,1218832928,-1964391878,-883958769,-919195252,-1590550100,-546570839,-1892408879,1364082867,353274826,-1474121195,1265930986,-1270988436,-307653639,-1669880267,47684680,-2099572214,-109994616,-1757271553,204438726,-741166025,-1082768930,1392141887,571437698,-1106795239,1106622796,-1482710386,-1831954657,1832715886,-589821433,-817142351,-1455174472,-335864614,-142469293,-780935423,763984737,330676234,-1066514534,-495256735,-437213369,-1915934157,684926507,950235787,530649358,-908736407,-715619995,-1575868156,876383245,-354550140,-76749850,782476545,1313460503,-1762338072,-292932275,2076627779,483078710,1278572627,-1215573805,-648062496,-1603391601,1406517239,965188816,372458544,-1419235190,-153378691,1141281512,-1568988724,267564991,-1334046553,966216095,-1918314527,-442529334,783350028,1588190805,2113964043,-781337420,-851769018,284242717,-599388931,-1381995768,-1961071191,-1130619107,553927445,245113753,1628591671,-441866164,236482421,372534061,-1415102713,-2020898395,1516053043,420433888,1834959162,-2074589707,1255717519,38125824,63626875,-1652314652,-51572541,444485559,-82211850,1862817164,1818441987,295191572,21842710,1237238329,2092670890,-2044889614,1368279762,-1438596842,-143435511,-278501839,-459658934,245636506,-928488340,-1912451945,-42351945,-504678112,1476905607,-899274195,876201007,1339089989,1454186025,-1648169448,1588497977,-1839465197,-1436686271,-504961208,-1587038686,1012212085,-1666478629,1938513743,683819721,1676372276,-1294307034,1173782089,-554403329,884330448,-1695310224,1397610558,1614109062,1439317318,-1862718083,-1970291004,259980488,161056251,-1963493081,-786761031,2059027816,-2139570010,-528556682,-1175224149,44171054,-2121523403,-930218556,-988223883,1623973142,1515899383,-1536174786,-1022447214,-280034483,271890088,2095480718,-1761492435,836033406,1544368846,737223270,-1068285340,1645720711,1075528332,854722815,-336880846,-1680630481,-752484961,-503035460,1372815025,-243634894,1728576201,-1542474065,1243021502,-701301738,1390213176,-841361435,623127275,-1342282008,-238508912,1244202874,7275533,-345024313,30387936,-736701224,165116179,-1491260312,1843753366,-96035025,-1090881019,1151949581,815230444,1574048679,141079826,-1246670774,676946738,-1471964611,250240115,-221194119,80442623,997393892,1608281871,1352265509,-1722036034,-1896904314,-1088059661,1297546628,1195784079,-313010061,-1971719817,368956907,-1159985117,874887433,1206699960,-2041588925,-771706549,1145628181,1678629606,-1284699850,-547457326,1262854663,-1109813222,-1111888160,-815271507,-1111282177,-1496203050,695011610,-987866371,-1497628449,-620073703,1929177120,-1121618817,1105046871,-523085712,672511195,-1851464647,-1089185466,-1088015995,-898777778,987941239,-169193829,-1130911084,1471050198,-2085223053,73954327,-779688615,-881008856,-481836614,-881304454,-2022564901,1875139783,316158292,-1417504738,932734466,-70590463,-1570884524,-876978139,1988438138,-1114906518,760756656,-839378130,-216409443,-921612690,1505860465,-1693262267,-1035593115,-500664526,291949516,2129917573,-1814633643,1459324236,-1083536191,-718401529,-99984540,377289964,-1483663099,-1177177294,-1718020379,968282304,2108263210,-1593524111,1555830885,-449391869,-31712682,1015252177,-285803005,1425692426,621168702,810692549,1703681245,-1703745838,-92968632,-56836154,-157822360,296989323,-1528646674,-910692490,-1333921231,669278960,1763200362,382793794,1719733516,-1625515983,-1627002086,-1589160943,-582196415,419719146,492244555,275698590,-700622024,854349964,-425917947,-204849602,-272772344,-1462031308,878222854,1190492967,103629385,-482095891,392069824,-735996985,-235713177,-622758653,401473270,-61522453,596994697,-927909730,-823643851,-1330148817,1067380427,-347284914,-1615704489,-435280713,-1413761233,85040576,-762038487,908213559,1544836670,2134627606,-1945505881,620806403,-568787248,-43906071,-447001448,-1684371673,-253265873,-592918204,1640795665,979021873,1123526569,-2143273268,-436821207,1415734804,420170711,-2081199960,-581031803,1910587384,843724256,1522057918,631746849,-856809460,-219277644,432060094,-395042872,965091024,928139516,2067493774,-1058341888,-36409128,-577311160,633310859,-1803749680,906346253,491862077,-677337570,-400449994,-875433828,-1350887560,-760321458,283559786,214103596,37727240,374896777,1616734343,-15765805,2145149348,988883743,-2117536831,-2017758600,-2047546480,885213349,-1505709869,1491356252,232281113,-1369182921,620443478,-1456537852,-864025976,-1604909259,230958990,790184387,-441935793,933092509,-87039600,389839656,325246876,-1307347002,1188220529,2142023511,624150687,-736067641,-1964435434,1787545737,-1641952609,2025058938,-221530071,1576626137,288393014,410474518,-550750051,-918480260,1901664945,2025639188,1794047430,1690303588,-953488718,422238351,1453295917,1241138008,-932824934,1939949220,289442479,-2035932507,-15355577,-4110700,1950579010,1561227533,-133224539,554094113,1511417261,-1968467169,-514026277,-586865959,2087947093,-1770388617,-501293890,94805059,1434529346,939012186,-728387745,-162964670,1773431183,1253426978,-393836805,-405436447,629922744,471959250,1229394526,-1182027860,-420870869,-953251242,-976132191,499295981,857679437,-103242276,-365677172,-1613946039,377538462,-2139999631,1687176815,-405079499,992113680,-1603168888,447059687,2139204886,-463491605,736272353,1788415458,-1550051606,184967706,-1921777761,-1020895825,-1128650132,-2111009213,-1128129684,-148401625,927046801,198153336,-19691195,273989143,217241852,1065846503,-939414029,-459522230,-781731597,-1336753806);
/*FRC*/Random.twister.import_mti(31); void (makeScript(14));
/*FRC*/count=320; tryItOut("\"use strict\"; mathy5 = (function(x, y) { \"use strict\"; return ( + (( + (( - (( + mathy1(( + ( - (y | 0))), ( + ( - Math.fround(Math.atan2((-Number.MAX_VALUE >>> 0), y)))))) >>> 0)) >>> 0)) > ( + Math.pow((Math.log2(Math.fround(mathy3(( ! Math.fround((Math.fround(-0) / x))), ( - x)))) ? (( + (-Number.MIN_VALUE | 0)) | 0) : y), Math.fround((((x , y) >>> 0) || Math.fround(y))))))); }); testMathyFunction(mathy5, ['\\0', objectEmulatingUndefined(), ({valueOf:function(){return '0';}}), undefined, (new Number(-0)), [], 0.1, (new Number(0)), /0/, 1, (new String('')), (new Boolean(true)), ({valueOf:function(){return 0;}}), '0', (new Boolean(false)), NaN, (function(){return 0;}), -0, null, 0, true, [0], ({toString:function(){return '0';}}), false, '', '/0/']); ");
/*FRC*/Random.twister.import_mti(291); void (makeScript(14));
/*FRC*/count=321; tryItOut("\"use strict\"; b = linkedList(b, 1350);");
/*FRC*/Random.twister.import_mti(305); void (makeScript(14));
/*FRC*/count=322; tryItOut("print( \"\" );");
/*FRC*/Random.twister.import_mti(318); void (makeScript(14));
/*FRC*/count=323; tryItOut("mathy5 = (function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var pow = stdlib.Math.pow;\n  var NaN = stdlib.NaN;\n  var imul = stdlib.Math.imul;\n  var ff = foreign.ff;\n  var Int8ArrayView = new stdlib.Int8Array(heap);\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  var Int32ArrayView = new stdlib.Int32Array(heap);\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Uint16ArrayView = new stdlib.Uint16Array(heap);\n  var Int16ArrayView = new stdlib.Int16Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    var i3 = 0;\n    var d4 = -2.3611832414348226e+21;\n    i2 = ((129.0) < (d1));\n    d4 = (d4);\n    i3 = (0xe0db760a);\n    d4 = (-8796093022207.0);\n    (Int8ArrayView[((i2)-((~~(+(1.0/0.0))) <= (abs((((0x7df2d48f)) | ((0x7d780bc4))))|0))) >> 0]) = ((0xa15c5a1c) % (0xffffffff));\n    d4 = ((9.671406556917033e+24) + (-18446744073709552000.0));\n    {\n      d1 = ((+(0xbd1a78f3)) + (((4277).\u3056 = allocationMarker())));\n    }\n    switch ((0x5d45394f)) {\n      case 0:\n;        break;\n      default:\n        d4 = (+pow(((d1)), ((Float32ArrayView[((i3)) >> 2]))));\n    }\n    return (((0x9fb5b184)))|0;\n    {\n      d0 = (1.5474250491067253e+26);\n    }\n    (Int32ArrayView[0]) = ((0xfd7f975a)-((((d0))) ? (0xdf27ffc4) : ((0x2ce3f157))));\n    d4 = (d1);\n    d4 = (d0);\n    d1 = (-1.5111572745182865e+23);\n    d4 = (-((0.0625)));\n    i2 = (0x54bc094f);\n    {\n;    }\n    (Float64ArrayView[(0x5541*(!(0x5e937a0f))) >> 3]) = ((137438953473.0));\n    i3 = ((((0xff766960))>>>(((-20)>>>(((((0x3c9ca020)) >> ((0xe688c21f))))-(0x7eb4cef8))) / ((((0xa50850ab) == (((0xf861c288))>>>((0xffffffff)))))>>>((((0xffffffff))>>>((0x841c0a2))) % (0x6f355352))))));\n    (Uint16ArrayView[4096]) = (((((i3) ? (((d0)) / ((+/*FFI*/ff(((17179869185.0)))))) : ((new ({x: this})(x))))) << (((+/*FFI*/ff(((NaN)), ((~((0x143dd4ec)-(0x81e042ce)))), ((5.0)), ((1.125)), ((-73786976294838210000.0)), ((-65537.0)))) > (-((+(0x38e38e4f))))))) / ( /x/  <<= new RegExp(\"\\\\3+?|(?!(?=^)+|\\uc5ed\\\\D|\\\\d)|(?=\\\\b)(?=\\\\B|[^])(?:\\\\uD446){4,6}{2,}\", \"yim\")));\n    i2 = (0x16be6e4c);\n    /*FFI*/ff(((imul(((i3) ? (!(/*FFI*/ff(((-147573952589676410000.0)), ((17179869185.0)), ((-2147483649.0)), ((-15.0)), ((70368744177665.0)))|0)) : (0x9e66503b)), ((~~((1.888946593147858e+22) + (-137438953473.0))) <= ((-0x73b66*(0xac0f5f4d)) >> ((0xfeaf282a)-(0x5d177067)))))|0)), ((~((0xc9e77919)))));\n    i2 = (-0x8000000);\n    (Int8ArrayView[((0xfad5bc35)-(0xffffffff)) >> 0]) = (/*UUV2*/(z.toString = z.forEach));\n    (Int16ArrayView[4096]) = ((0xf9f83d8b));\n    d0 = (+(0.0/0.0));\n    switch ((~((((-0x8000000)) ^ ((0x145ebd16))) % (((0xfa7b72a5)) >> ((-0x8000000)))))) {\n      default:\n        return (((-0x8000000)))|0;\n    }\n    i2 = (i2);\n    return (((0xb5ceadf2)-(0xe7f1b524)))|0;\n  }\n  return f; })(this, {ff: \n(yield)}, new ArrayBuffer(4096)); testMathyFunction(mathy5, ['/0/', 0.1, undefined, false, ({toString:function(){return '0';}}), '0', (function(){return 0;}), (new String('')), ({valueOf:function(){return '0';}}), (new Number(0)), -0, ({valueOf:function(){return 0;}}), null, [], '\\0', objectEmulatingUndefined(), '', /0/, (new Boolean(false)), true, 1, 0, (new Number(-0)), [0], NaN, (new Boolean(true))]); ");
/*FRC*/Random.twister.import_mta(1354524648,-1141057456,-1481617964,-866207045,-157353650,-167702911,832335138,-117496460,-923334185,1869269988,1045914034,394282424,356948257,-1191921826,472025239,-535014051,1095872966,300444625,1537734614,-1583230494,444724439,881285895,685521648,379291847,1624483900,938757746,-861713847,837781276,-244653249,1668935051,-1507750277,-1509352869,-1687375263,734117961,1174653936,-1138281763,867977840,-2136388532,2079558965,-1044643158,-1834525884,-1490449565,-1086257421,-1561897286,-1019245872,202469032,2003809414,-371889942,1030598427,-653094322,1991511992,1132809864,1202984913,-1956776800,-1418434766,1010411285,1814286798,1321196352,995537303,-271692249,-1946542389,-614193141,-509804753,1735207020,1123437995,-1031162646,-312999493,1470103933,-219218402,476841913,-1270714179,-1736660014,-1069712913,1410197866,772362504,1094425036,2052459149,-2011732307,-91475174,350445058,205963906,-401406594,-1682479252,-2112000931,925091421,-1384095156,353568269,-1540273408,-874638770,855959874,1949521039,1512987434,1870906872,1299184804,940437366,2029046776,-1786880256,-1764081237,707187829,-1295054802,1108520744,-1229023779,1422638024,403769413,1449357908,-1305532581,2073422270,-1989390820,-668760859,-883266827,1190866403,-1016726560,1254686497,-1804810684,-2060710462,1965388656,-2012013085,-1987951754,457741664,-500242056,509137904,765224833,663182494,-1771336475,1764490396,-72008059,-645862135,-142202546,-1543264099,-711206275,1417894243,-1526291908,-791516470,-589421027,-369474959,-1283709343,470073209,-1739783596,-1322146174,1290703934,1178901085,2060925580,-667564523,-1567047549,-1756773586,-1440906344,507251258,-180149930,368775674,-180186405,1725873762,1017856366,1398149891,-1914068703,-239698956,-941914593,-1993402888,-949712131,1510405499,-475980889,-307614059,1764221866,-529169866,-1893885946,1478197922,-944838136,-513925672,140342921,1553257019,-1282449124,-467749925,-128516970,1904251423,-323455956,1761434913,-2003312457,2045971980,-133709713,362311296,980109938,361399076,-1131402436,-1259314853,1442689782,-325300840,-764515116,-722901300,2132318044,1452096102,-1161544271,857091175,-1390777867,1127797081,-1176698650,-1230071002,477001503,1789337435,-36104104,-811796046,-452657101,-358626518,951154808,1256411009,-2075850050,-1876086094,-163920658,-1304358331,1817236013,-285352714,943536963,9508374,549406102,940432154,480078008,1231934239,1166356504,-345324146,-1738331864,2098488035,-730893320,-95558749,-749455629,488660948,399230188,1920347319,1818570815,-1603427038,-321559398,-835108343,-1215023449,136362572,-1161414916,-1735338194,1616878887,-1194964626,1355923809,1577980534,1884329728,-1933063254,250704900,118479731,1024850435,-1079843138,-1915798184,-509097486,1081334747,1036733221,286062022,-502143739,1306010784,-571742750,1497594419,-1766797838,2119615471,2089685243,577699658,2136510228,1986190260,-837530069,837394603,1228366637,-1064249425,412715109,-2124113392,-1957719301,-1356098770,-452900478,-54393034,-917227310,-84452293,-2053303719,514708326,-209945261,-1337377568,-1400919666,875900868,50127275,1935037691,1758669721,-1968132889,64942279,-1913842929,-1189925727,-789793995,-710132542,-33951370,656308119,-1553494638,1876166774,416937874,270169417,-1344453849,-1057829663,2081420896,598523986,-1561553286,-2090663793,328013986,-2109978306,-637424692,-1399085967,680605730,910548495,327171987,-1612391292,-2027995644,1318882000,-1066497663,683568833,189300459,1946539812,-2027954793,188256962,-1256484234,-893436833,-830071749,-596630295,80347819,-310993558,-1171695247,1891763977,-2033387991,968569628,-1920992731,1503654353,-843097388,-293885528,-763556497,-775068136,-1045525373,-11344126,-4200809,-1833870748,-1081911892,326709794,1561617682,-1983577916,-757996521,-1169723135,1132406648,499998039,1179935163,-168985169,-1845988352,-1882740009,-1834796457,644725120,-93104485,-59179195,1111875057,-566011259,-1189556938,1739429295,87632927,1003700147,-489216979,-1510904300,-1443956461,-1888786191,-1932512212,1043025424,-621272196,-2001699838,-50699298,999937535,2129405159,683653960,-1528241315,2001071106,-579872014,1496982865,1285296925,-946986546,1256495523,-938580098,-1668499745,-1381883715,-75955998,-760321387,2077311800,40760502,273290846,2135192470,1467464548,-1108912816,-111828170,-1513695351,-1986038012,73718866,-769163128,-1767433410,-1300443666,-111649774,-160263344,312968650,-397527865,-926066288,-375313126,1358604985,2086224122,55815845,-732627938,1235663919,-1533689853,1693242077,-1338071180,-453915950,-876434856,-1805060469,-1442112482,-647138490,1194653026,-279360175,-1552813813,-320540386,1182789770,2042070123,-656554147,-2081640391,-1329327778,1939895780,923236832,1604130722,893124592,-1964339179,686558531,-631829588,217482866,849714720,352265456,1758916959,-1538087799,1787663983,-1901405831,816437764,-1253142653,523381761,702720726,-470185653,283390173,1685900150,-1141961586,1879592614,-235637775,739921162,440121310,-814592291,-995088159,988492679,-1067188828,751377323,1479769943,-466634665,-178912009,-263676429,302258214,-1170114439,922691474,-707732581,1603001672,-1443586968,-1396696880,1935037194,518232649,-1651277648,-1354060715,1088228713,-1236524373,-1946484466,-34490079,-895227397,-945938225,-601289988,701596388,-1969652072,1937113435,-1093035903,1120763842,-280114683,1870143501,-909598837,1970239426,1346014915,-1703591320,-1961972850,1839754056,234585522,1928470421,417872186,-2017533655,2112919336,-1061578995,61287526,406061986,1395985283,174189120,-333521768,806327230,1343505354,-1774554693,768293369,-1585670071,-1450668572,-187409917,371967256,1495883760,938949423,1501661858,1768064071,-1235025723,12707318,179574230,1806721187,1674869259,1005261040,-953408216,-910457938,26590444,189298717,-2055735383,-1253902445,923337683,-2031792245,2046825428,440074274,412886650,-789554526,-925787681,995561454,1597788271,-339479666,600457978,986279443,-1907476695,1164156312,-1558858084,-1042115995,1113287693,1539279187,1636048575,-1246935589,370889125,744104776,2083457322,-1760883229,261877071,-1657766560,-1568118789,-462957047,-646355043,1897063962,-705426303,828222478,1270071404,-237352630,-1933469833,162554469,689159065,908889514,1322762500,-24738579,-492657005,1958207560,-353710533,1536407801,-1414570345,-1937166172,-1754489602,-1597922630,-1672122553,-1733244979,2083484771,-1584766672,-1122406997,-717647575,-2091586871,1982485645,-187472174,-878646181,1263111994,721468669,1859728065,1385386772,-331179231,2000801803,1778636767,-1123313031,-1809178719,682997774,-306155675,783368955,-1948939798,-1893339470,237216956,360525710,630337548,-915996756,-320635127,2058538864,-302716213,-714272968,-795402641,-1878677087,668880793,2058514767,1682474139,-656627256,1158707032,-414501997,2042748589,-483041512,-1864562028,97308473,-1379202385,-2070906167,-1522048613,2056068242,213646605,1485778016,1475920268,1170335264,-309439139,1719844536,-1600951708);
/*FRC*/Random.twister.import_mti(9); void (makeScript(14));
/*FRC*/count=324; tryItOut("testMathyFunction(mathy2, [Math.PI, 0/0, 0x0ffffffff, Number.MIN_VALUE, -0x07fffffff, 0x100000000, -0x100000000, Number.MAX_VALUE, 0x100000001, 0x080000000, -0x080000001, -1/0, -Number.MAX_VALUE, -0x080000000, 42, -0, -0x0ffffffff, 0, 0x080000001, 0x07fffffff, 1, 1/0, 0x100000001, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mti(41); void (makeScript(14));
/*FRC*/count=325; tryItOut("var qbamrs = new ArrayBuffer(8); var qbamrs_0 = new Float64Array(qbamrs); print(qbamrs_0[0]); qbamrs_0[0] = 1; var qbamrs_1 = new Float32Array(qbamrs); g2.a0 = Array.prototype.filter.call(a0, Int8Array);print([z1,,]);print(\"\\u3FBD\");e0.add(g2.m2);e0.__proto__ = g0;v2 = (i2 instanceof m1);this.i1 = a2.keys;print(qbamrs_1[0]); /x/g ;");
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=326; tryItOut("s2 += g2.s1;");
/*FRC*/Random.twister.import_mti(199); void (makeScript(14));
/*FRC*/count=327; tryItOut("\"use strict\"; t1[9];");
/*FRC*/Random.twister.import_mti(210); void (makeScript(14));
/*FRC*/count=328; tryItOut("\"use strict\"; o2.s0 += 'x';");
/*FRC*/Random.twister.import_mti(222); void (makeScript(14));
/*FRC*/count=329; tryItOut("v1 = null;");
/*FRC*/Random.twister.import_mti(233); void (makeScript(14));
/*FRC*/count=330; tryItOut("/*bLoop*/for (ntucyp = 0, igyzxs; ntucyp < 113 && (\"\\u6720\"); ++ntucyp) { if (ntucyp % 47 == 46) { \"\\uEBBD\"; } else { ( /x/ \u000c.yoyo( \"\" )); }  } ");
/*FRC*/Random.twister.import_mti(354); void (makeScript(14));
/*FRC*/count=331; tryItOut("mathy5 = (function(x, y) { \"use strict\"; \"use asm\"; return (Math.imul(Math.fround((Math.fround(( + Math.log(( + -0x080000001)))) || Math.fround(( + Math.atan2(( + x), ( + Math.exp(Math.fround((Math.fround((mathy3((x | 0), (-0x100000000 | 0)) | 0)) && Math.fround((Math.fround(y) + Math.fround(x)))))))))))), (Math.fround(Math.sign(Math.fround(( + (( + ((Math.fround((( ~ x) >>> 0)) ? {} : Math.atanh(x)) | 0)) ** ( + y)))))) | 0)) | 0); }); testMathyFunction(mathy5, /*MARR*/[0, (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), 0, 0, (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, 0, (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, (timeout(1800)) ** (4277), 0, 0, 0, 0, 0, 0, (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, 0, (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), 0, (timeout(1800)) ** (4277), 0, 0, (timeout(1800)) ** (4277), (timeout(1800)) ** (4277), 0, 0, 0, 0, 0, (timeout(1800)) ** (4277)]); ");
/*FRC*/Random.twister.import_mta(-195083982,52595795,-2088850056,2015154690,912051073,292063934,-1729473863,-1717573911,-947142010,-69567989,-1073575804,130222788,-1234090063,242517970,-298684653,-1879992910,848131132,-1053357323,1454315643,-1375744289,1536612865,-1753043647,578905570,1137287674,754802393,-524025255,1842101374,727142741,-1067955367,1347386446,-956646528,-434407473,-669551605,1272386727,592022840,861123415,-1895923873,-732386239,-1785688362,1449230755,-478224456,626113261,1100454784,98766366,-35144742,1270846693,-987838588,-341562792,917700345,-1272428287,-445476955,-2143713104,-976418828,2037590066,-1624826878,-767668048,-771102377,1961588199,-1125412886,1723123651,-1035631800,1008080083,742214014,294062690,-1920679259,-1661803768,-331666904,-1528496193,2020876118,-1007385112,-93161662,1928138022,-1745400428,-576241281,-419173335,2013970277,-1261272723,-136354027,956804698,-1191511616,1992621437,-1567196749,-1216469252,189910138,1672431332,-2084848358,-2006063128,-287202647,875175913,-1360369878,1608856064,791272390,-1593237637,1643536531,-54398223,152568806,-900623448,-1624321690,319188567,-1927836916,-1302828657,980524590,54150470,117080275,560184123,-733841093,-261980915,-483215435,-1517495723,-847110911,2016638802,-1794225400,-1135254553,1113056023,1881582702,-156148083,655711152,1984911936,-163884652,-2036864426,-1907146765,411817554,390758660,-1042871843,-1814352818,1932364240,29558643,-785226573,-346457189,599344844,-632108863,1396587147,-1470368834,104227433,-478355179,-305954448,-2107066877,503008985,-983368573,2076733332,2133913931,-290596218,-1446982111,-32922548,1125486697,1665410645,1183750529,-571046626,-1406003971,-295755183,-1126316212,1422159703,1183123410,164223968,789675857,1976182514,-1324796467,97616680,605661819,-429013520,1568688716,102124721,156830983,-1836366404,-1049242729,68742820,936166816,-321822405,-1301746151,1737415062,-347610443,1091132266,-1442228911,1975966082,-513002265,-579606986,403848515,-1611291031,-1637789712,2096043295,-358911156,147876905,565663297,491690545,133039275,954720370,-1815162737,1543982392,-295077416,2106080405,464493444,-803118979,-248582378,1978011496,1558839994,595513792,818882704,1924354903,-837287734,-1138156999,-1329872075,-959719313,-271159404,-1652844959,-1416987624,1345163356,-922839472,1305255732,-1587631643,-661380413,1431295379,-78782946,2005887729,1586169416,-1306553704,813280766,-503669189,1662188391,-1888429977,-1633460836,-65448277,371131274,1545413626,-437108572,1119124893,1991535657,-688269271,172708073,-1042274337,-949030818,1702873468,2048172054,-128977678,-2071366130,1761588870,-393425987,-1007537781,-966693551,1086042310,754850519,-1980315124,-236774324,-921302242,1113493701,939939783,-784200394,-1518750660,-208234404,-244400367,208967443,-1235178436,665139232,115856241,-897350436,979382000,-783149,1803424148,2029530186,669456197,1703179586,-224931921,-166856235,870448735,1381041917,-2083691050,-418371049,671121976,-2016099375,-1054694353,-1705926029,1253435309,1565603244,328927893,-1826548925,-1312899654,-1362870541,344708003,1209248438,476671516,489344840,-426962582,1520843405,591444469,-1193281738,169315676,1986790654,1996947722,-1246787725,813362970,-1120353531,-1621026002,1962218506,-487253960,-34780671,-1248676734,-1597165618,-1976432199,-76786723,535681216,1488072563,-1980768914,1697231857,-389934989,-1155469521,-1269762025,1581902642,29691359,-1147962686,1044051481,-1921200786,-1848208786,640880517,-1724484575,1950009624,279583851,-1021657790,1971836576,1767799989,-348797023,1080077344,-73880744,-1608750209,-1766896085,1066851231,-1175356404,1681635971,2099363172,-625026429,-1011980112,2090022599,-533871801,1748702729,-1954294803,-1176574948,-843545284,-1586603465,1038245845,-1139245299,-189671244,733707667,-126524651,-740777370,-1102224243,-100778492,-1508477004,-1525838508,581366212,1768419470,-526284683,-1587307367,-1654952122,2030392902,-390484224,-2061358987,2035369594,-1180578671,-297366886,82824294,357965981,-145861450,726299607,-1490755820,-1816219489,1185737763,-1148851083,-784522969,-256594203,76678986,-1072023553,1549102166,1095703837,1624408206,-1623270821,1653189182,179859118,1676391548,-1813798368,1283605209,690802379,1202978185,32297167,280184474,1584528192,-1342529691,2038125235,-269323936,-1566409102,531768421,788892917,1107984536,-877321397,-1109787234,2132911884,2124351301,1107217287,-703708463,324947739,439486262,2133195543,849883868,1609344909,481810991,1446098664,-210967310,-2014644781,-333862247,420364339,967293142,1574298150,1291972578,2127880320,-1454763300,-262690776,-440621056,1060681085,1270483762,-923897884,-1018072249,-2008848174,-1996565020,1852158872,1931774315,971189816,-1397567419,-1077025495,-483162852,-95266560,-1444344795,-860599785,1119201252,375026938,1204029424,-831501249,-1867875502,-832346070,2010058554,-865765464,-38034967,708277935,1169231690,1132232719,-904153653,-1853152039,-1208502082,1846485128,834752470,1710487859,946110391,909049176,-1821303056,1357074384,-374664855,-1793597811,936715791,1128881402,1170746172,-1676581993,-694217618,366038706,-323634490,-756450714,290758403,2130032198,-851709485,147622820,-1176664403,-1362052259,-871675253,370372611,894390076,-1197920131,1444074169,-2052404156,-1607136400,321202222,1997194126,1829906674,416217569,-921593607,-1156895637,-1338753219,-1955210930,-221336089,788087891,237771246,555395484,-973747625,-18623694,1826240926,1293530571,-351961692,-1038158875,-351654970,-1735215322,-2098972943,-147994013,-1034523732,1656735304,-817578578,-596236618,446164920,-444925112,1302766381,1604202799,1686570318,-1634057388,837421593,1261757334,-660665808,1663060750,-1115292195,-1496904238,-561084124,1794279794,-1774610969,1420242637,-34464397,63805439,-280600831,559731502,1063353143,803775384,-573757916,-2026927704,-148750112,932574609,-1512942781,-733717863,-742446311,-584848972,-356135342,809304001,-1067040647,1668596499,-1441160820,-943517708,1968819127,620881432,-1879461883,451438099,-1505767147,109514191,-49464873,-418717554,-1214563635,-441583343,-2010370302,279179395,1437100142,-299483866,-1939575552,-513824245,1105353397,1171036609,97952231,511633757,-250455084,-79985262,1330706059,768090436,1367803786,-1209830120,219385333,-920439946,818372761,-1292549914,1611477996,-1474973112,83535130,1797109684,518075626,-1227667668,1653181278,-785217137,-1312475851,45880044,-1693831184,1636018612,480350683,1680949665,726008266,1343811568,378024414,216977984,-1461282986,-1831117442,609479609,2131800016,147609721,1575919933,1128671446,-65594580,-1775438983,-99993310,375070540,-458667991,-1288936691,1008106149,-819968716,-175612473,-1815439914,-609088863,-1458822289,934423128,-407982005,88250927,624674341,-1421739559,-178579181,1877693644,-409724369,-1567259152,1612661992,2044916681,-736549769,1380123324,-580923711,-403524229,-1775919784,1572951068,-783246028,851416283,-968362013,1769074562);
/*FRC*/Random.twister.import_mti(213); void (makeScript(14));
/*FRC*/count=332; tryItOut("a1[({valueOf: function() { { void 0; try { gcparam('markStackLimit', 4294967295); } catch(e) { } } s1 = x;return 18; }})] = e1;");
/*FRC*/Random.twister.import_mti(244); void (makeScript(14));
/*FRC*/count=333; tryItOut("/*hhh*/function axwmvj([, ]){v1 = (b2 instanceof e2);}axwmvj();");
/*FRC*/Random.twister.import_mti(335); void (makeScript(14));
/*FRC*/count=334; tryItOut("\"use strict\"; o1.g2.v1 = t1.byteOffset;");
/*FRC*/Random.twister.import_mti(354); void (makeScript(14));
/*FRC*/count=335; tryItOut("\"use strict\"; L/*\n*/:if((x % 6 == 1)) {/*RXUB*/var r = r2; var s = s0; print(r.exec(s)); v0 = Object.prototype.isPrototypeOf.call(v2, f2); } else  if ((void shapeOf(15))) for (var p in g0.f2) { try { e0.delete(g1); } catch(e0) { } try { m1.has(h1); } catch(e1) { } for (var p in t1) { try { Array.prototype.push.call(a1, f0, o0); } catch(e0) { } try { h1.__iterator__ = (function(j) { if (j) { try { Object.prototype.watch.call(i0, /(?!\\d)+?|^(?:^\u357d)?|\\\ud218|\\3/gi, f1); } catch(e0) { } try { v1 = evaluate(\"null\", ({ global: g2, fileName: 'evaluate.js', lineNumber: 42, newContext: (x % 4 == 2), isRunOnce: (x % 4 != 3), noScriptRval: true, catchTermination: false, saveFrameChain: false })); } catch(e1) { } try { m0.get(i1); } catch(e2) { } t2.set(t0, 4); } else { try { f0.valueOf = f0; } catch(e0) { } /*RXUB*/var r = this.r1; var s = s2; print(r.test(s));  } }); } catch(e1) { } try { o2 = new Object; } catch(e2) { } Array.prototype.push.call(g1.a0, \"\\uDCEE\", this.a2, p1); } } else {/*MXX1*/o0 = g1.Set.prototype.keys;d =>  { yield  /x/  }  }x = (new function  w (x) { Object.prototype.watch.call(h1, \"1\", /*wrap2*/(function(){ var nhujew = NaN; var teqsgj = XPCSafeJSObjectWrapper; return teqsgj;})()); } ())\n;");
/*FRC*/Random.twister.import_mta(-1252968070,-390448618,-1071347340,-253950609,688139742,-842668278,1581500497,513850551,695022254,-471910402,-1176123266,2110003174,2095199827,1852511362,883882224,968260348,-1610229690,1041335526,-289916110,1356726051,1265107809,-541857962,447075134,131150427,-1543374986,-739262496,1431299620,1738526581,1894654187,2056526995,1521800454,849306278,1295897712,-1071425027,-1775259619,-441578149,-710033389,729839247,-1737819257,-1159939710,1720596887,1699472103,-693639103,1472386010,1146149103,801780111,-10474437,1921155463,-219546678,-1461027414,-156724614,1901304097,-1070412429,-77653092,-613876960,-1656686247,1336749749,-1525617022,-862289942,-1242385787,-225551873,882126986,1984309737,-912244218,1620915336,-2048789774,-2009657483,-515350391,-590300080,1115346487,1593090017,1020733998,-1157906515,-585135468,1449732501,854099361,-1155123337,-353761480,287009561,300534723,-1086553145,-1895449957,1101852143,-285837651,1244729524,2137678758,-605607978,-1085959508,643902860,-1203107025,958917181,-1290541009,-999182306,-1448768666,-542938080,-1554227984,-2073532875,1350080064,-787967886,1769399592,-1569429812,-18121374,-873851431,-898223505,-1893419614,1522111495,-861165851,-472115796,-1201916413,-1551632526,-968122422,742136510,-1175062694,1395319179,1879297592,352815832,1588836459,-1382909548,709157268,1509245709,-245340958,-1588618298,-1368702132,-26539657,-1134899564,-364085760,-2095011979,618779490,1314756671,-1336393144,1356415249,-649653908,1665188384,-1468247401,-898140776,1513418872,180794574,1952999263,1372899816,-556097708,1739424746,-203601882,-1426971357,442216687,1661672758,1098840094,902806599,-166364483,-1836489718,-2145849854,821586276,1425158412,472130619,-1160558584,-971904358,1944344609,1148737565,-1713822882,830418275,-647181103,-1895808359,1620967355,1078623181,216400985,-630874429,-1004797269,569927169,1202395761,1437986729,-453906306,-1993571430,-1544747731,-226798415,-396770972,-1549567996,717899209,-2013492798,-692067219,-484707406,-1413776370,-188923560,-1831039353,1181448845,263448743,-496294623,93819174,-1806571398,-882553151,-1866500594,468078762,-188449132,-1285657837,-1708599466,1231596142,860258829,373401155,1773095000,663053527,-896925682,1895046742,-1470952839,571692073,-2065513818,-1303929078,1201561774,-447292755,-2026068506,318696933,-745479559,-1240305706,636342115,-841768256,1949084935,-1656205237,-938217172,-580919621,-1836984837,-770998368,270586828,-1790232418,388818487,-1399818686,-1694804593,-157307724,-770075416,37648722,1044218336,-516975788,-1191384499,1252523677,209319103,-1501030382,1568942803,-242226905,881637752,-574846696,-385468507,-1054724139,-1668635997,1003156040,1724307244,1873854620,-735175500,-1448248880,1221801441,1271480276,-83002235,-1363245895,2052607791,-1352465625,-1893400457,-205476530,-737565885,138889925,-767422727,555103257,1177818008,1047318594,1376823278,267719581,-1503320227,-666800577,2100591642,1934756214,-1817351600,-1095992007,1000742795,1337506994,-1411029227,-1084382745,-1084336764,2011948173,258133270,1000301855,1282759844,-288064722,-256245430,-1372280362,-93490396,905677677,1753164558,139099692,-713749245,-132479597,2046388428,78827539,1955540098,-1025933632,1387323083,2074331980,-1479142841,1030183360,-19616626,-1672875723,1116896903,1321425372,-1422065754,2063728937,9242941,490442438,-542093355,97819442,-627612298,-124930257,4758102,1605930518,2070064205,2060884656,497430904,-318144997,-1337245714,1443491725,-207137865,-375723691,2044923505,-1468317693,-913772571,1784175345,-880742807,-1110341927,-708693095,-163417732,2133886522,1682627829,1117165192,-1940141744,-1813195799,-1406499257,659103736,-1266688887,1790086865,-46649246,80895895,-1924067358,-2092353409,-1170197282,1779200128,-1622851655,-57347605,479373694,-239372187,-847663602,1473933006,-1902990854,-34628239,-871731011,-1292981439,-785132317,1597293658,-960336893,2017118339,1429001388,416653259,-297231490,-262359498,-2053304681,-157790768,998349736,2134094967,386350563,-1707659752,870228117,630177265,-39683726,-1431530724,-1795609655,442481577,-639032413,-264605379,1939125253,1326954479,827115523,800159396,-106502120,485742039,-1781447213,-1242093759,-1101000142,-1006553682,-540038744,212041708,471337616,1224310542,-510458920,-2006851801,1461308031,1751684416,-301214329,-1359755545,-474485009,-868173413,1812801177,-1579834988,1150895816,2044611718,-804903626,1286574800,1787049576,544518725,-1805206429,1959504478,394498520,-272448458,-1588040367,-1386155924,-1219701334,-1607203171,1190542824,1274160290,-1335603038,428440674,768363076,-627593790,-498935536,-1899556271,-1757833158,-1246313346,-1175301325,61069911,1664880039,1596770080,1564552049,-562454056,920803616,-1759237752,1643517520,1811992379,313514668,354056649,240666533,396805453,-418387082,-1228850733,222795022,-45078921,106345066,2141509689,712737807,-1862377126,-1942041458,447242380,1613421361,870899852,37536834,-1855014925,263333926,281550049,2139042348,-412210858,879142036,591407732,493547928,-470120349,-422417621,-2138786769,-500163738,2125698993,-431597737,1238994191,1766560121,1092723173,1333062978,-1751455770,-1000104057,-1995249868,-1706958990,2026219734,-1031859001,-2022752279,-1183174550,-1849747313,-2080100679,-330252840,2096362080,1119446187,-597445520,-1912133045,1829020945,-2036112414,-2081245232,1442608650,-1509541842,-545256929,1454757749,-144624312,1987582465,-97307012,-179697038,-1137700376,441260633,-565837550,1146154550,707089793,-1180362182,337474445,1424940272,-2069147093,-100935420,46490426,1219615230,-969818393,-1920456920,-1070733065,2072952367,-2073438480,277521269,-220878536,-1468741593,-1411850183,639319806,-822242971,463613164,-1574649775,68199191,-297505873,-1486588010,435710762,1179067460,-1421178624,510976531,282579593,1744111190,-1639530844,-1625291597,329700607,-1215736767,-1497209897,-791425657,-10970183,-1593177201,-575807115,-351967755,-1521642059,201647566,595752812,-155168233,-1435132282,1178754752,-774091991,1302779570,1294325582,-1567050023,-664597154,1570435652,1203533897,-117700230,-268282206,1662646745,1119421826,1786002536,-1721864849,-1040084450,1511644912,1102502673,1935187729,-1840645725,695825097,-1327588049,-39043796,-303241202,2041163956,406039277,-1132720926,-346533811,-532597969,1740501163,-2076703336,1611420038,-1889103392,381551954,1668820396,-1800103442,-701789835,834838199,1641821476,328662262,-794578148,98833912,-2007490303,906120765,1072646412,891034107,-1000993084,1150672368,1096316126,862740200,1262325706,563952648,-446486013,-2093860537,-632146735,-70536077,1909941444,-973878406,-722376032,-1391975807,-63988130,631465568,-124191312,-1723189745,-1699771474,1668071286,1786387419,1686092582,-91123517,783552087,1023008662,373943346,-1503440321,-1809733855,1048854299,-337869681,-908893049,-394692328,178479206,-94122828,-1603987998,-1276637130,1687537978,-693140048,-1044675087,-963049238,2065832686,369561197);
/*FRC*/Random.twister.import_mti(246); void (makeScript(14));
/*FRC*/count=336; tryItOut("\"use strict\"; /*infloop*/L:for(b = true(window, ({})); (NaN =  /x/g ); Symbol( /x/ ,  /x/ )) {new Function }var bhxjvo = new ArrayBuffer(2); var bhxjvo_0 = new Float64Array(bhxjvo); print(bhxjvo_0[0]); print(bhxjvo);");
/*FRC*/Random.twister.import_mti(459); void (makeScript(14));
/*FRC*/count=337; tryItOut("mathy2 = (function(x, y) { \"use strict\"; return Math.max(Math.hypot(((( + y) + ( ! (-1/0 | 0))) | 0), (Math.fround(Math.pow(( + ( ! Math.fround(Math.atan(y)))), ( + Math.max((y >>> 0), (Math.abs(Math.sign(( + 0x080000001))) >>> 0))))) << Math.fround(Math.round(x)))), ( ! ( + mathy1(( + Number.MIN_VALUE), ( + ( + ( ! -0x07fffffff))))))); }); ");
/*FRC*/Random.twister.import_mta(517548899,1080489727,1962970635,541703345,828465757,434868417,922780629,-1177130693,-2036117931,-54074718,940848667,-326398124,-2024678685,64880666,823621434,-896187935,-1119216797,-1181020216,1717557108,151680273,-1775525736,1324430280,-103013291,1294744731,884405377,-1260498230,-1675293115,911968546,-978016058,1096459704,199257087,864326641,-1220453500,-977687140,214981892,1159686405,-1047585130,1752034155,1530457771,-1779731411,-2116631133,581248421,-404773533,-1584874460,-288918743,-1789901234,-495635362,-1474672106,1539774195,1805407708,-1629598109,1585446704,1237920090,1324636132,-893239829,488943590,-195421078,-422999078,566358779,-1627649135,-1140044014,-336451292,1302048890,829373345,1300501563,1250545795,768548636,-411387620,1651770550,-826845191,-602635824,52056288,-671746784,1669545114,75029686,1758140092,159838716,-1824759304,1302323534,143776631,-1282488189,2138940874,763444313,820313680,-1716319747,-227304972,152509987,-1538153586,-212488375,1068004285,1976258234,-569849369,1319100394,-1315457278,369016910,-249964988,-778481382,1016675252,542486116,-1785634483,-2037487691,-29828855,-1266520042,-2119965642,2044485108,2138082138,174109945,1095728430,1095456972,-1846516003,-26557064,-1222501484,-695795996,-151226759,287435136,343256251,316252125,-1150936219,311846607,558389595,383838631,-58775386,-129378697,1325053379,315832662,1188978113,-850334462,-1384077249,-1348111003,1470526336,-59751119,-1896285527,742167067,-1198105671,-2044781111,-1607544878,-1355258178,191370136,-642966083,-643604621,2142042835,497936743,-1719419366,2090883541,-2111321386,1535927202,-6750267,251185740,-1192198533,-1468112368,1231085919,-710695104,1998428268,-94988254,586878673,-517127647,1297763006,-1292912257,670510868,-135142566,1503187501,1149349909,1922521853,-845951222,-483058841,1971883837,1367698858,1402172452,1438976148,-1062321067,-1460509745,1867746151,1653794272,849973678,1490619349,-707408492,-1013588898,273796349,1179337457,-1426254928,-712842652,1919233176,-1462564175,-1747817661,2010632552,-830539015,-1204827569,151506905,2124379837,1902096512,-516245154,-1468579416,-410620816,1526318344,1776539533,1157677288,1329187278,-239834457,-713937494,1896786877,-308118357,-85353245,-1066796662,-111100935,-925932801,702826792,-1274512117,1246843168,1975335356,-150501128,815807826,1165866083,59588571,1519241101,477879053,429604517,-2122529080,1119029632,-255438597,1929106982,-1516229865,-1327443166,-1377807382,-1464381563,-2021247933,1681709598,647022535,-609227110,-1136805522,-365640565,856535224,-961820693,-1205545843,1833361257,-1761071689,1797842264,90129815,-279324779,-1318128016,-1271746187,872833108,453015904,-1639711479,1076572492,-1669361630,-1026434583,-950171758,1913599952,-1069022588,658904241,885811772,-944073217,1777682295,739031526,-2612239,-424763126,1584188825,585644040,-1384731936,1031502069,814852700,1917477641,2092330430,-933647426,-1372363480,-1612492367,-1305007500,221038326,-469547639,-1200582751,1131806397,-378137182,295126046,-1001416180,-1620019327,597300822,1015415095,-471271439,-1651864999,2113322205,1255237874,2037386165,-132030992,-2002343924,2107134732,461792442,-1081035535,1281134760,-702296958,-948434554,1876727617,1928217212,-1650091834,-712077184,-1071966734,2011855717,708765618,1163572625,226989955,1629839893,560558339,691236365,-1920631308,1235401943,-1126160653,-383383625,905614895,-1117925313,-789468648,1973724078,-1024935607,963121401,532045185,-319936060,694465360,244934756,-745738726,-922515119,434682452,-1116309767,-894005316,1785103187,1513359585,-254666146,984932124,-257198257,1519162033,-718608311,2098169746,1490257825,-1086325753,-1564622112,2044202155,-758343655,477062977,877486220,123357662,422055250,-110407893,2001990153,-1874812546,2060246759,322762822,-182001222,1147900900,-756448336,-791084043,2038074250,1175891576,492569321,1684856725,-2018425236,1912213630,-1249987047,1984339883,-722906227,174505556,1524707285,477353095,556205335,2020719404,231764974,-1627393173,-93442256,-669239645,227176630,1818197629,-1632013678,-43056198,654366002,-49378037,-1778421372,1734285230,686401009,-1659316102,2063817988,-145855735,727743368,-1169919084,827074458,-195388054,109556054,-773536819,-1872620046,1080814751,331572660,1509734726,-1746304639,-1403848771,-1916815633,580775065,-203437139,398732377,1835682793,2073061055,865255932,-169058463,566266418,-60267127,418853071,963139906,1865968078,477187043,-1792695192,1274521128,-1889930912,-913961660,-260313035,1784087753,-468208512,-2127278495,1520174985,-1084254607,1715794872,1117455300,608441474,-1263654458,971236522,14808996,-938471456,-313401233,1189021537,510782584,1152113930,-2125504113,2054879976,2019116779,2116546704,1691160558,1387408371,-890810814,178736841,1866957743,329834223,158992405,-748165761,2066938400,954142207,56807972,1322848157,-208659766,93301579,411393156,281226734,90840467,1638592084,1296322352,-1776861252,-355237528,-1136638256,-1509804215,796115117,-1906483372,-2478833,-1430789335,1517077097,1075798015,-823540000,1795604360,29144224,1258072520,-1664786876,-1877894588,1104557581,-1569114068,-854842853,201690057,-289845377,1203593557,1335148945,-1692297521,-363344178,-1129832231,2131330328,1547628008,507717502,-926091546,933092301,-2042376681,51084402,1057990129,152081953,352123503,1708939069,-1059289641,-1871760930,1205763532,1854513832,-1503371526,1402301751,-1435378523,573144887,-2093884244,1630610285,660318350,2136890435,-997367005,35082016,-852559523,-1417204814,-2104784488,1718498085,-950666850,1051912783,849680020,-1528799547,-1329305583,-2043303887,712873162,1180116381,-982008198,-175995909,-1064925714,297415161,535735139,-1696597737,-463758428,2054804417,-1529052246,214352221,-428600405,-818394464,-1586312733,-85639918,-946426002,-940697929,-1874578423,-942830592,-524362987,2052799889,-1524056334,2001624310,-1356565168,607890841,523586027,-2050267813,377851086,1930308610,1606122400,958707238,1688912503,1163212287,1616122182,1767531233,-176321044,1642696965,1441938122,-336982659,1599905127,-812413303,-1848454319,1471688804,1232644632,-98013722,1158063175,-1329885655,-642483735,-1041636719,-733235481,84727025,1205730736,38887728,-655755147,-294494058,-201439784,-76067353,123067082,-1745622642,831773774,578875024,-8606387,-1233721471,318798900,-533259929,1890711025,1850177526,1605240853,-112689206,1169740205,1846392056,922225211,1416468681,-1230783115,717915195,1129775265,971838306,837393171,-741826830,-717103214,1792956892,511919574,-1594391359,796103947,103271213,1362481933,-2089235307,1976657410,-1052576813,1079171676,705221241,1499462218,825058632,1228701847,1393431479,-449655684,-1539793825,979947907,2120451242,-710946279,397307039,1015342954,-1114968573,1744820536,481102197,-1428658213,-60785332,-733233420,1356269572,-662173323,-300851586,237424540,100756424,-1583745515,1669888527);
/*FRC*/Random.twister.import_mti(64); void (makeScript(14));
/*FRC*/count=338; tryItOut("/*RXUB*/var r = r2; var s = s2; print(s.search(r)); ");
/*FRC*/Random.twister.import_mti(618); void (makeScript(14));
/*FRC*/count=339; tryItOut("print(uneval(i0));");
/*FRC*/Random.twister.import_mta(-1728364142,1608553043,-1847894456,-1194305357,-87748239,-1627800874,281419818,-1850822179,-247824335,210019990,-969001057,-1325967001,-1510427507,-1715472900,-421652570,2029136671,982086748,833939582,-1177968939,-1078199926,1587248462,-1526246063,932094322,1845635824,1555049988,-915678331,528882075,-1550502420,450340916,-459160629,-18019913,2137891372,812580157,-1936760640,-1323283820,1333791972,-23684219,-1108422753,1083895734,-1563350994,-259706894,-1450856374,505237903,502993793,1327990892,1774175915,1154353381,-243194315,1415890106,-618407714,-114769884,-835250747,-1690669790,443259235,1642174302,-1267707551,-1933645598,1667213963,-870680706,504985718,-1156525454,231434165,-2147247697,-181005558,545851098,-2030692918,1919642243,-750568841,1935620408,1645202209,-1355520241,1816632261,1045782492,-1726089068,-567130736,-1200924633,1989653988,988880207,-2096924134,1208164984,1210255656,160162020,460915546,-1428254256,1881758427,-914373215,2012514042,545186476,1454618847,2101074577,-662342012,-1054101233,1264498358,-527516542,447058965,-335711199,1065205431,930185148,-325166022,516087846,-469527685,-1754283690,-346629719,-26892446,1507227272,1533875005,504714456,302037746,890297716,-806286675,-576412165,1094642616,-1541296514,-1914221894,1722869113,1357052639,-1795060588,-810735397,326329701,1982029736,1145456530,1106303054,-223138973,-283275520,1969214623,-2015707294,892197330,156017923,-1405276297,930391630,431571339,799548103,-15163246,2133819593,660159263,-122141169,1636803669,-1427408918,1880259133,-262454920,-456103826,1400546477,-562288109,1706632988,680723502,-963584389,774244295,1879900686,903258125,-1471481158,-1053040931,617763153,-222772584,1504175334,-31055445,802524999,2052522374,385692621,-1958510716,745578528,2057407044,1946725190,600126324,-1353727780,-509766031,-265597280,-943990140,-652426862,1109974802,-903586830,2035457250,14331582,1003759175,1243125880,-1667497653,1925878299,823611334,-895687594,2067398190,896497959,-2139428474,-925244374,-1125371514,1293148815,-363178646,1941760141,-146681080,-451933408,21154594,24430524,-2014101978,-1501369942,128105304,-1283842353,-2106071883,149909996,-1477095775,999081432,1660365204,-636950392,624856445,543565465,-810533030,-1540293654,1709130204,-902820147,908507943,-538160990,-1615112157,1647890218,-975835580,1297218859,-1545584762,-1414415821,676315534,1732360796,2113179061,196345721,-2061658529,1603476384,145187221,-1904729984,591546723,-722639518,1948190407,735651113,1314884930,-958030555,-1275969335,-933394924,42797977,1071631336,1901225405,-2109045202,-465910927,1788711461,-1574896253,-1635169113,1944498434,-293721,-1807759028,1895258621,417838009,884390989,-908807083,-630760164,-960732574,2126478348,1873604566,770217068,-724053808,-1321058976,-546470026,-1184712516,-792566423,-320242137,-170532913,-396993337,-1193759095,673589267,748872091,-1887732661,1806489915,-1450235631,1796724632,427915916,-465089707,1535917545,1823819589,-424731122,692066640,132917859,1268255661,-1837202438,-1605620450,-751864578,1943999481,786773463,700775284,-1101866661,-1076155290,1576090022,-266140313,-227360412,1855756502,1255841241,2016882722,-1878969293,1853318006,1860526800,-868142540,777767609,-332309110,308732026,834582298,1715489505,-643161802,822025233,-975332848,-1209444478,344784717,-655295638,1169340051,-235989438,-680874421,1089896914,-811238728,542891044,1935257907,-1559892191,1868704115,-419773244,-16199357,591847250,657610398,2138427346,-2135773466,-1804522578,1184381612,772141416,213208564,-1363730246,-745244402,1646776633,-1775471420,416327101,-1386273571,-1702604622,571388505,1841403765,-1355069934,-1137524734,-352063506,-919971929,136710836,918419867,-1016787964,2014950065,-1549819293,-1409155391,1770624278,1865324890,1785825794,-147569306,-421926653,-501787584,178133613,1733103790,-698979867,1502475382,-322622410,228777120,74273969,-687462696,-1171211238,-384929699,-2096332421,-1903682793,-1506602861,-1021281020,2043132222,-1322356107,-2054205033,-1802956837,-332509263,-550144548,-16254927,-1704465997,16436788,2046024777,793157598,1530695673,1273805916,548039674,227323020,-1753668266,-33896578,-602282217,2087994012,-929723347,451165261,1339879570,1743029694,-2090186986,521961751,-1480776921,-1098067905,-1249885883,-1411399442,-343706137,262706645,863449218,1603722123,1669028100,-1059741332,-506052483,-1698423061,-563208455,-710310394,660605670,2105846943,195826789,2019049519,1424792786,-852484890,536541324,-732286494,1817828157,-86884758,1702798953,-1185590892,1828531853,10391889,-703835414,-147717791,454418369,1569011177,-2021407244,-2104824230,-402457680,1226648992,-1924197751,716873577,1046105785,1186052268,-942458306,-451211072,391645834,-1875409985,-356280197,2020338769,-881577772,1525469541,-1416425486,1867977410,-501078733,-413140726,-1000044714,-214578630,-1708641565,1887362889,604860364,1864379563,-431410269,996575315,-1547718201,1419281534,2110693665,-799538200,-380902888,442250731,1932634477,-851672207,-2113090551,853232846,183853033,-282499740,1997427805,1057067448,1412182361,-1943525108,-1406005677,-1820444164,-1289985643,1627909493,-1393769415,1370461127,1860815161,-835352086,-1937782783,1100831530,243799270,-1511809136,-391965546,1906241459,1271567525,-282146475,1325303556,-255360167,1508042065,618808179,1135913089,1192224102,1286811131,-1604205528,-617115537,526580039,1066454758,2142861839,-409172042,1637033557,1787771342,-267297819,-135618798,-47471849,-671398389,-1482376802,-1763715807,1378860986,182308705,2017536695,-2082025007,360624390,1787664563,-1516393878,-391217245,1681964444,-354032125,-405660745,-761734566,297480262,249551393,-1693501958,-288828084,73824359,475704996,-1965999121,-567315487,-248505656,1174660224,1979368746,-133209292,456316008,-1168017791,-905926763,351744203,-737177214,-35970536,1020646781,1462168042,-1974978503,-1057450781,-1947998271,1496805010,-1145643434,941324116,-1702692576,1086297251,-93806633,1414856871,-1729825422,387472957,-758100355,-1173592048,2106414067,1818306505,-2097658103,-99372136,276191009,41263225,167495947,-1299177016,633639758,1456784929,466691961,-673431950,-1807886622,1544957374,1740380837,-923987658,-939333825,-1118157231,1099221456,-1164300568,-1666538339,-533377274,-1476916730,826309425,2121199122,-859345797,889685625,-1353066727,1258580012,-338800566,1349430101,1619647792,1697237907,387052607,983828188,-2045124237,1681414755,946459263,627278495,1001370100,-1837198682,667905477,-356240771,325539575,-1002348901,-1966148740,502955364,580859371,1160650901,1318429032,47398694,2048032053,-1067838081,1332736752,-684698086,1732460921,943511902,-1340449768,670473298,-815554240,386734567,-1203201406,-140226952,-1457298018,-1660717566,2040985099,78086344,1826844043,820188994,854086413,-877625373,-1040572524,-2081885723,-1159454288,1149214653,411417669,1618734304,1225910969,152751525,-1766212062);
/*FRC*/Random.twister.import_mti(3); void (makeScript(14));
/*FRC*/count=340; tryItOut("\"use strict\"; v0 = (h0 instanceof t1);");
/*FRC*/Random.twister.import_mti(18); void (makeScript(14));
/*FRC*/count=341; tryItOut("mathy0 = (function(x, y) { return (Math.atan((( + (( - x) < Math.fround(Math.atan2(Math.fround(y), x)))) + ((x >= (y + ( - x))) <= y))) | Math.hypot((((y < (x >>> 0)) < (y % Math.fround(Math.pow((-Number.MIN_VALUE >>> 0), ((Math.imul(0x0ffffffff, y) >>> 0) >>> 0))))) | 0), (((z = Proxy.createFunction((function handlerFactory() {return {getOwnPropertyDescriptor: function() { throw 3; }, getPropertyDescriptor: function(name) { var desc = Object.getPropertyDescriptor(x); desc.configurable = true; return desc; }, defineProperty: function(name, desc) { Object.defineProperty(x, name, desc); }, getOwnPropertyNames: function() { return Object.getOwnPropertyNames(x); }, delete: function(name) { return delete x[name]; }, fix: function() { if (Object.isFrozen(x)) { return Object.getOwnProperties(x); } }, has: function(name) { return name in x; }, hasOwn: function(name) { return Object.prototype.hasOwnProperty.call(x, name); }, get: function(receiver, name) { return x[name]; }, set: function(receiver, name, val) { x[name] = val; return true; }, iterate: function() { return (function() { for (var name in x) { yield name; } })(); }, enumerate: function() { var result = []; for (var name in x) { result.push(name); }; return result; }, keys: function() { return Object.keys(x); }, }; })( /x/ ), decodeURIComponent) >>> 0) ? ((( ~ (y | 0)) + Math.tan(( + y))) >>> 0) : (( ! x) >>> 0)) >>> 0))); }); ");
/*FRC*/Random.twister.import_mti(359); void (makeScript(14));
/*FRC*/count=342; tryItOut("\"use asm\"; /*bLoop*/for (var vybjpe = 0; ((Int8Array(/((?!\\B^|[^]{1}){2}|(?:(?!\\B))|(?![\\d\\S\\0-\\u00fF\\n-\\v])|\\u002e+?.|\\s{1,3}+)/yi))) && vybjpe < 100; ++vybjpe) { if (vybjpe % 8 == 3) { g2.m0 = new Map; } else { i0 = new Iterator(o1.i2); }  } ");
/*FRC*/Random.twister.import_mta(680978191,-582735582,-503277984,-1712417544,1154533646,809193530,-986483485,749071393,1505274823,1850579698,-1389705391,824628467,698440855,-902145465,-1987277859,500837247,-824826155,1927184084,1153966852,852003662,201908099,-649216285,-553390392,1732590242,821186452,-59694213,798020687,198864054,1821076228,56960196,1760484252,285756926,-326883301,553371931,-1397475674,-55628680,1819072738,253388057,-213208796,-1625461005,-1868144781,624153122,232590332,1475156863,-1982186426,-732981242,1199640678,1364519438,-1909563992,671933548,-2082628836,-1648020103,1031183990,715980356,-268357374,-1956382976,1789634963,349599601,1174004690,-224326563,-1461495976,-1509364304,783759580,-596858271,-1354169162,1933786210,62213233,413692393,82022774,-549646177,-2117946364,-786487804,-2131676085,780433890,-877328342,-559397534,1825778414,1881100990,801834393,-885043775,1245411190,-42269964,1284353465,-973185343,-33293682,1022731803,1552702637,305178776,2091044344,857752069,-972183874,437657940,-673457673,-1245094784,-965135615,916927585,-330161972,-882602742,-1734724072,212713724,-580373110,-1098095695,1978604752,346690035,928573584,443816810,1670235594,-1089092400,1449019946,-1818599490,-1971678241,-171783032,-1804894457,-68423131,-1079634031,-1852836944,269939198,-724076022,659226992,-1460529114,-19456058,1365327782,831333120,-1772249158,-69059451,1101281409,667915487,1159102705,1330471916,1104904600,1929872292,56198452,-1313236655,15471977,1705772859,1647084852,1279448423,1521963927,3594216,-387265257,-1341491670,1281243649,646550313,-1934788763,-1386708513,483130689,-2113214185,-26299606,2017745556,2070747320,829565935,690632301,1856393738,-1344247551,2087868084,418321293,-995954920,510695611,-2115735966,-1452469312,1712486429,1985905439,-548736680,566533336,-984620799,576267410,-703312351,-37827820,-987274497,-615431049,825044078,-91468306,-372563897,-1572784637,1328819915,1401933775,-830463391,770856002,-482946692,1695858512,1937573418,1691491871,2040045803,1360359638,-658565402,516123419,1227338852,-757074121,661982747,-381833874,1076240930,-2020605129,175852740,-976666655,1726516509,-807651558,324256644,866692076,1461062001,198042398,-967552669,-253212233,895171724,1255373232,202042273,-437423842,-527070959,-1042807511,-917177065,-716261030,1451437012,-1930204735,-1250518067,1350590479,1598271653,-1760435897,-1371988882,1345717267,-1372351932,515109360,-1109904912,-1932129325,854789876,-2088968356,-973747982,775228164,751026287,-395872332,-1184175576,978232179,-2046725876,-445560049,824054573,774284676,-1058826772,-778017319,-1207858050,-723935280,-1747736961,1673443377,726222438,486007518,-1635138170,1932839968,535679066,664146485,1301755208,1004447848,-809896747,-177731936,1071916050,1598327855,-1597997275,-554084828,-458857606,-1888930756,-297354632,-1383449593,-602674904,1675487241,-1102133279,1080748772,1902118959,434582318,64673887,1482794065,1809039576,1072974862,375676197,1501366100,-854344047,891193679,-579806725,396822249,952324209,1858692235,-1502163368,-1757419866,467986699,1654327365,1146380951,1360528238,-228943950,501605880,-1464628926,2044885955,1672029851,-539433245,-1854251816,144155078,306839522,-1722701197,980438111,459937788,-1300175802,674660845,508177992,-1557366516,-1964274235,1405090610,50070615,811918268,-429928893,-1636905708,274993751,135903429,-1693277229,-358670544,1978746299,-1573647905,-159171421,412033776,1834404274,1326807010,764039025,2096863883,2031671250,-1522418712,219470304,-780042483,-1567437603,-1347219578,-558076894,-414967122,503607051,389878953,1106241701,359128185,291772628,1651687385,1253274098,1121525607,-404127642,664715408,1027836098,2012007464,1990080057,46002737,986350391,-525355636,-864239992,-1969302896,-1441410813,-93145696,-1512255446,-83051367,-1688956815,1291099115,1034405277,133149979,-796069398,1625040386,1780952045,2060962514,-1466365952,-1748790386,-1617478452,-1189692622,1657387958,-849721906,-2123129716,-1100800209,-1319063034,-1554169248,892201337,-423781585,1020365073,-260632272,-374381318,824892614,943423558,-2001805327,211732668,-2066956463,-170778239,112802091,-1939252244,1330121377,-1805107036,-1159922445,-2012343992,1333793899,425340934,304357196,-1801012745,1202370210,1789232061,872257642,-1701344973,26610541,947848345,1938570267,333744144,-159474025,341662709,290315605,762248148,1543106413,-1455667043,1308739287,1050643694,-368001533,2046394790,-401069038,1645160452,-920925811,-1976507887,1309939999,-1889141260,1697777697,-1100785841,1106833041,902120046,-1414134773,106801160,-1866521552,-352563308,23287055,-208568593,1861605908,1516635770,-1430424970,1241096345,806035410,272709363,630948113,1080157787,1464279139,478229845,-798590341,1869177306,-126602292,-266012953,-1757544336,1774298991,-1157955182,-1216546063,790220489,1492107375,1413563574,1116133353,-237300177,1027459145,1786964120,-656315345,-998256517,-1185148481,-1779159036,-126616865,-422206242,602716981,2053323157,-163848737,1974363656,1947560095,-1895933798,-658425470,-1719551536,1450173308,923404203,-516484494,-1990424302,287761868,1368050203,1537690899,1712119619,-842863502,206799507,-1010780671,-28874733,1953547859,219946898,1405589630,-1403981234,-2026679579,1629888672,-1843968734,-1634773663,-1430434216,733605443,1714139835,-954101303,808981022,-25798548,1494828271,178922836,2081787770,412797497,1940171071,-1734267942,748728265,-1562720910,596962264,-1941003892,-855547948,1169555946,-1961206501,-1543216820,-1451696608,2019097727,-1889739042,1920731378,-1031333875,-1263002771,2053138856,1774499781,-824095845,-1363812461,945057347,-1165553775,-2088585161,-1523313729,243667301,-1198347657,-772427343,219836912,-24598295,1792144006,-95397837,9252554,661497446,-15102350,-1408333198,-498938531,1885295030,-1595128572,760375870,-979476938,469210953,2054382208,1729771450,-862105240,1686245260,-2033595144,-1231903590,2024814891,1533244241,1388299159,-340979076,1629795083,-1651382237,-1645553520,570273411,-1630089484,175741139,-1788851525,-1400330559,1939953554,931229541,1128872056,-32765366,1290151596,-1520449690,-720385082,1049215808,1534784421,209299718,-530199425,1722783740,450904870,-532982937,1568795690,1788992348,-1581001560,1923569074,1765180980,554121419,-213137023,905303154,1772004064,1960242931,-1067523012,-823421764,1785427204,2091939187,-1774481269,-1787822117,-841026940,-86481308,-2127317501,-1338574,589330832,-1978381452,-1767344737,1945746703,-828173737,501309034,979075870,-83597679,-6452044,723150922,-1900918292,-1040757861,1035474562,1417060213,1351278234,1453139390,329493323,1644679058,276866067,-1665035939,-1507233880,554232203,1592223680,1399605216,-272996456,-296923588,-963663287,-1436819535,453636194,-1117972138,-1932053930,-942264325,-696972141,1392547744,1114325278,1558453173,-1018659944,-423210266,601456224,1274993428,-1982296584,437322308,-533907316);
/*FRC*/Random.twister.import_mti(513); void (makeScript(14));
/*FRC*/count=343; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return (Math.log1p((Math.fround(Math.min(Math.fround(((Math.fround(Math.ceil(Math.fround(Math.fround((42 ? Math.fround(y) : 0x100000000))))) || -0) >>> 0)), Math.fround(Math.min((1/0 | 0), ((mathy0((y >>> mathy0(y, -0x07fffffff)), y) !== (Math.abs((y | 0)) | 0)) | 0))))) | 0)) | 0); }); testMathyFunction(mathy1, [Number.MAX_VALUE, 0x100000001, 0/0, 0x07fffffff, 1, 0x080000001, -0x100000000, -0x080000001, 0x080000000, 0x100000000, -0x0ffffffff, Number.MIN_VALUE, -0x080000000, 42, -1/0, 0, Math.PI, 0x0ffffffff, -Number.MAX_VALUE, -0x07fffffff, 0x100000001, -0, 1/0, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mta(1968962556,-667155539,49712299,1559750761,-234023394,-1033336056,658664157,-673460936,-29555468,95236454,-1886403655,45998944,-651717155,1672323710,-1776464911,-1951997477,-757515423,607762826,-1982111337,1978699914,-1261618527,-1676637813,492259141,1109336496,227365652,-2026276255,904276361,637830001,606671731,1947634581,1606616732,-1278504569,420687401,2033416841,-2044484112,-2045601130,163283491,1348796413,1820132916,1713857943,2105550808,1577141649,-423659050,1181469130,-1677927892,1593655418,1109958047,-537509125,-1871076787,-1196237775,1109269095,-1496795676,-209462276,468460468,1070776853,442939849,-422711953,1458149750,782659179,-1934585298,-897200376,20217618,-2144017852,-1231843287,-251848925,-1980435669,-992591312,1507231144,-795154477,-1927039376,1692144017,447782139,-1459268382,1370112582,1648901411,632163593,-1805690095,165568758,-575588705,-150274407,-1607281637,1441998939,-1873907204,422203388,5501467,-2022273897,-143782880,1732780563,-1976388471,1595104293,1435622035,-1052642021,-1035631206,-694909290,1619128221,364772286,-369301751,-2125708072,65069460,-1515304994,1649074251,-745582520,-351976359,-1796167018,2135295303,-213779736,-1422722811,290409661,1611241498,315929259,-732644905,-345415393,1585071708,1163461408,-302781849,1183672730,-1829169294,-2108673783,425950691,-2115819766,39939413,-493434445,195289367,-1013708549,113451757,652341442,1505836538,1475993664,-2147383864,349285356,-1003316052,-1708922050,-1559373589,-859536136,-41217038,-609495584,849008108,-1232482450,-707924097,57034820,-1382519224,1642162999,-25511834,1379211283,1250399983,-1175426345,-505309343,1985721753,-1462319385,758711273,-29557637,13780576,-843989977,-2144001776,-644276299,-2029080342,54474564,1048310897,265058885,-428333609,1111637295,1225453392,1241648458,1536430904,212696675,-660386669,-551767774,-1992535022,-1651075888,2039590652,-837947530,-669453170,-1581872834,-1975236279,1888596740,1889744211,1016225573,1294671309,-458109149,-1395557170,1723813204,1595705038,-1447489944,-743172031,-179733310,-1366847162,651116251,-1186231587,-96615200,2113032059,-1600441766,-1103511309,1148298139,-1050239461,-1453567391,-2007061927,611074932,-420140270,1433153301,-322978352,-220250289,950686164,904468683,63722578,-1797269721,-934634020,-1492920949,-1362196044,-2061681867,-2062754858,1509863030,1776820872,-364810054,200569307,509047338,-1865768500,661044805,1142513282,221428198,1107821389,472633006,-1077946980,577180110,688144237,-557709190,-1787276628,-736197802,703500008,471065291,32912429,-1220018895,864726871,-713303606,120823851,637751051,-1573010741,1874984590,1567531097,-362147929,-863815954,1842762513,-1722177230,-230914101,-584068276,-1359347633,-1357841613,1746912446,169439252,-425424165,1118131532,-189409416,-2065310631,-398077581,1203050548,1638930799,1393184335,-1143265975,835383816,1529730396,-1623393018,419827707,664473912,-1964965119,-1856086317,-446915318,1502930520,2044543888,-272975467,1925170747,1497241153,-2048115278,743179790,-1943637039,-952007304,1905934433,-2092776095,-215142558,-1763385795,244154649,1218533992,861938179,117410252,1419004725,-225170994,-1290791864,-2038804999,978604416,-2110201500,1165996017,-1995432523,590607823,885883347,-2076051243,-577359853,-1798998655,-541069065,-1665824010,-1197381716,1936679266,829679126,1234711448,-932222243,1788439427,1164305125,-1797649333,1227937705,-2109378303,1136838169,-572416917,1913085810,1433263748,922261186,-1594083482,2023988039,-1069719671,-1229004960,1303609809,320583267,1888090690,168055595,-2125659819,266328460,1713370857,1073111123,333086291,-1172331239,907352381,1794698273,2076098427,-832766816,747935226,1286784372,-1601267040,-1248641692,716778153,-1035062311,-1971127444,1345931411,-616645671,943986968,1469032,569487929,1001665354,-1072201881,1725882266,-842955516,2123487776,-2051391676,2020189153,602249698,-1275454470,-1428682812,462034347,1301133818,471345543,-808838226,1213920885,-1252638345,-1131492903,-474736979,184400816,-1522840847,-1979353904,-251358833,484422182,313367336,995999964,-649077707,963904852,-496535483,-815085772,214495921,580814240,33568638,-1408263725,-1360893167,-745163162,-200745943,-994801466,-1984514941,2130549754,-718010442,-1910718644,-1872438432,1571729184,-1550447804,-7935518,-704558743,-1865852359,-818593831,-77939222,90126955,2056565511,205171719,412224103,-1960711878,-848959083,1134263271,638625594,-1090957495,642033303,208499671,1152328538,1301662503,-257013292,950079220,1389609118,1628287918,-1265815039,796923152,708894678,-273949195,575939484,1709304543,-1324083003,-1891376342,-1538566877,5979634,-918344199,1765974182,-734517472,1420309234,-1873074768,-1253807918,1831885637,-330011417,1578409278,1704400186,-1986929610,1113434150,1073106356,1975852171,-2083152412,1256961763,-1280112259,1202452114,1267240045,-327024994,1137213651,1376430993,-1441707501,-641653039,-1517562496,-1843480435,-1087502752,-929824282,150084431,-115703010,-858454029,-359007093,-1925377160,2094487114,-273718872,1998358470,781296293,1886617098,1295444165,-596636529,-1324934051,-438284045,1134421154,1854946797,334501657,-618993448,-144670937,-863274594,329402232,-717309746,2138222052,286020669,-610149243,-2028352400,-1187479020,-1299260141,2055888964,-273733558,-1796583645,-1578405804,1211210663,1113110769,-47357937,967577696,1815175801,1314863073,882892962,1697059553,175712453,-1176704069,734758101,1169810490,-2144125846,-1265178394,1605613214,526249082,-1922975392,-298166167,188491495,-783265118,-915879698,-1954014018,-1098940159,-909017928,1075214344,-1910694986,990786816,-1326083061,-2030893698,-163404291,-2102083877,-1940019215,956731598,1834724389,54241309,-878298745,-994715236,-483177638,-59185930,-2028771063,1955272374,-1745409050,-501549270,-1027460936,932587142,-459660755,-1462287058,633754749,331139341,-1653913373,-178857059,1494511710,1663781457,-426046579,1247031765,-653515956,-1500353965,1767413020,-1034940826,1622890426,-547192936,926708648,911669007,164313111,-1177176038,-1853358745,-2136792095,-1077601795,1943337186,59049528,779830704,1494873036,1501917957,24485344,-795328262,1766979741,-565369556,2105699320,1734781504,1606639108,1103291623,161186764,-615265423,535414535,-760227443,-204385867,1688341385,1387632483,-1729540857,1525448785,356442953,-1730677524,-533197447,27989444,-1191952506,-641642426,397363166,-1411978029,1158340768,-829019960,1934191642,1686101042,471696690,420613181,496406974,-1464952787,185563267,-226597140,-23472350,-1367918553,-621441877,-544718603,-161630855,-450058444,1282510953,-2006040647,-250956936,305829771,1925061951,-26664707,-1652551577,-1242104367,1360298154,1703108041,-2121148175,-98331242,-1009389595,-1282265128,1945751928,-1294416643,-1733230713,-1867369497,-703643061,-1488123902,1369718226,-1777950158,-147527194,666101564,-292486635,-2009492327,1421051227,1600904845,148302587,1436191557,-1153993348,-1211624341);
/*FRC*/Random.twister.import_mti(97); void (makeScript(14));
/*FRC*/count=344; tryItOut("this.f0(p2);");
/*FRC*/Random.twister.import_mti(109); void (makeScript(14));
/*FRC*/count=345; tryItOut("m1.set(i0, e2);");
/*FRC*/Random.twister.import_mti(126); void (makeScript(14));
/*FRC*/count=346; tryItOut("a0.forEach((function() { try { v2 = Object.prototype.isPrototypeOf.call(p1, i0); } catch(e0) { } for (var p in t1) { try { this.v2 = evalcx(\"function f0(s2)  { continue ; } \", g0); } catch(e0) { } try { o1.__proto__ = o1.o2.e0; } catch(e1) { } o0 + t2; } return g0; }));");
/*FRC*/Random.twister.import_mti(229); void (makeScript(14));
/*FRC*/count=347; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(238); void (makeScript(14));
/*FRC*/count=348; tryItOut("testMathyFunction(mathy4, [-Number.MIN_VALUE, 0/0, -0x0ffffffff, 42, -0x080000000, -0x080000001, 0x100000000, 1/0, -0x07fffffff, 0x080000001, -1/0, 0x0ffffffff, 0x07fffffff, Number.MAX_VALUE, 0x100000001, 0, 0x080000000, Math.PI, 1, 0x100000001, -0, -Number.MAX_VALUE, Number.MIN_VALUE, -0x100000000]); ");
/*FRC*/Random.twister.import_mti(270); void (makeScript(14));
/*FRC*/count=349; tryItOut("\"use strict\"; \"use asm\"; mathy3 = (function(x, y) { return ((Math.log10((( + (( + ( + ( ! -0x0ffffffff))) | 0)) | 0)) | 0) ? Math.exp(Math.fround(( ~ (-0x080000001 | 0)))) : ((( - Math.log2(Math.atan2(x, x))) | 0) ? (Math.fround(( ~ (( ! x) >>> 0))) | 0) : (Math.exp(mathy1(((x != y) != (Math.exp((y >>> 0)) >>> 0)), ( ! (Math.tan((y >>> 0)) >>> 0)))) | 0))); }); testMathyFunction(mathy3, [Number.MIN_VALUE, 0/0, 0x100000000, 0x0ffffffff, -0x07fffffff, Math.PI, -Number.MAX_VALUE, 0x080000001, 0x100000001, 0x07fffffff, 0x080000000, Number.MAX_VALUE, -Number.MIN_VALUE, 0x100000001, -0, 0, -1/0, -0x0ffffffff, -0x100000000, 42, 1/0, -0x080000000, 1, -0x080000001]); ");
/*FRC*/Random.twister.import_mti(561); void (makeScript(14));
/*FRC*/count=350; tryItOut("L: for (var v of h2) { v0 = a2.length; }");
/*FRC*/Random.twister.import_mti(596); void (makeScript(14));
/*FRC*/count=351; tryItOut("mathy0 = (function(x, y) { return Math.hypot((Math.min((-0x0ffffffff & x), x) && Math.sinh(Math.hypot(y, (( ! x) | 0)))), ( + Math.cosh(Math.fround(Math.min(((y + (Math.cosh((Math.fround(x) <= x)) | 0)) | 0), (Math.min(Math.fround(x), Math.fround(y)) | 0)))))); }); testMathyFunction(mathy0, [Math.PI, 0/0, 0x080000000, 0x080000001, 0x100000001, -Number.MAX_VALUE, Number.MAX_VALUE, Number.MIN_VALUE, -0x0ffffffff, 0x100000000, 0x100000001, -0x07fffffff, -0x080000000, -0x080000001, 1/0, 0x07fffffff, 0, 0x0ffffffff, -1/0, -0x100000000, -Number.MIN_VALUE, 1, -0, 42]); ");
/*FRC*/Random.twister.import_mta(-158479634,-27045456,160041890,524430744,1834563155,-1912166677,1719152059,-1884238930,2054657607,-870542947,542327326,18237488,1582744623,-1203320079,862985671,-768602381,939341338,753998033,-172250257,656767148,-681850392,518012548,1213018238,-755069270,-834912483,1403027883,1062115765,-433298909,1331141106,1911889520,-444961498,1544616957,-406018627,1021812556,919359936,1577118762,-70157886,-2054321561,-307170170,1967693697,1518988425,1888959544,826232692,-1477499131,-1228962068,496446352,619522351,1847224217,231071521,-252336477,-360785428,-1256920563,-1485836975,199017133,-387138959,1170286528,476597117,-1597364913,1982543645,678694721,-1662373114,-1323471489,664873016,-1561600020,-1285360473,1905997313,-1208899060,1176878097,-1977965914,-121307281,1097746028,1810892693,2044294430,1938649803,214333995,706715459,-161354392,-849720364,220391385,1576769009,1377457318,1075225433,248356623,1678518749,-1558190348,394683497,-1527540169,-1467086279,-1817834452,-1179028141,7643625,1256801816,787720049,1769700219,-1102572231,-230328891,1610337814,-862860886,-51545210,-485366243,-124257658,635623965,-1041217035,1490301821,-260996660,-1937263531,1605504311,185268493,546798977,902949194,452896173,-309748235,-1359927711,-1762142942,236787944,172434340,327586268,286054322,-473769761,608232067,793820431,-1470998814,792043332,947115651,-776812327,460765307,-815345139,-1462270006,1873707403,832931675,-797262468,1037600567,1064710690,502186920,-1957764739,320428835,-1035418373,1434201395,686534974,-727959230,-1992076546,-530635861,-953266306,-1977774937,-1942241885,1345176437,1940035444,230748237,1884367062,-708692480,1139549448,-1851053188,419652420,-1405006848,1123206549,-1861756072,-278613382,1084467409,-675886644,-1622211576,2068195756,1690559042,609323600,1141752991,-1431252591,-1121877732,-1219527748,711541217,779960349,-1074808132,920713750,1172678614,1157456023,-1737435909,-1594736718,1068867787,1717333631,-1124134768,-37858636,911558154,-518493265,1737878318,-1800576819,1723415379,1313981598,-671498740,755232156,1980865267,361755022,-288076273,1751345281,566619577,1714667303,1006316694,940262087,508015059,-1156273616,45356077,610617699,-1831259577,-1573124073,511454429,-1273964552,-1032594458,27661095,1259897579,-1387998900,408142496,-250330573,520521283,-2043882055,-1383053350,1279310805,-651887778,-1356310300,-1692413393,-1274409613,-240274155,-1614850491,-528161470,-1746502057,92278204,-756977180,666365638,522625555,-784845609,-482389217,1636600660,1737554809,-1960753691,-544224532,1206180534,1419232801,-328123679,128358932,228026624,2074308974,-1938885358,1733808967,-1313514120,-1259725208,-748228867,-1129846955,-108493086,-495856233,-2118891216,573161638,2097232986,2142409762,1914166210,159699033,588670843,813305265,-1768020515,1453454811,-877479031,688940916,-924022904,1401849214,843518623,791287760,-1431019361,-1884851300,-1988151481,-381159093,-782346930,-610438252,-1159807157,-989820985,868831661,-238476286,698617819,2117593388,-987186752,-155994634,1951615120,579828066,875604415,-1857796295,668421263,144901707,1538142004,2089497383,1172324697,2063577964,721493981,694714355,1734169633,748540794,-282041856,562409434,675985426,-2041012521,1687920659,-1326254923,-1002412067,-1533784903,953808605,1934226590,1561685202,-827164806,-528318667,-1851400466,1694784402,818581727,-1794576506,-152552