//@ defaultRunNoisyTest

var jsStrictMode = false;
var ENGINE_UNKNOWN = 0;
var ENGINE_SPIDERMONKEY_TRUNK = 1;
var ENGINE_SPIDERMONKEY_MOZILLA45 = 3;
var ENGINE_JAVASCRIPTCORE = 4;var engine = ENGINE_UNKNOWN;
var jsshell = (typeof window == "undefined");
var xpcshell = jsshell && (typeof Components == "object");
var dump;
var dumpln;
var printImportant;
if (jsshell) {
  dumpln = print;
  printImportant = function(s) { dumpln("***"); dumpln(s); };
  if (typeof verifyprebarriers == "function") {
    
    
    
    if (typeof wasmIsSupported == "function") {
      engine = ENGINE_SPIDERMONKEY_TRUNK;
    } else {
      engine = ENGINE_SPIDERMONKEY_MOZILLA45;
    }    
    readline = function(){};    
    version(180);
  } else if (typeof XPCNativeWrapper == "function") {
    
    engine = ENGINE_SPIDERMONKEY_TRUNK;
  } else if (typeof debug == "function") {
    engine = ENGINE_JAVASCRIPTCORE;
  }
} else {
  if (navigator.userAgent.indexOf("WebKit") != -1) {
    
    engine = ENGINE_JAVASCRIPTCORE;
    
    dump = function(s) { console.log(s); };
  } else if (navigator.userAgent.indexOf("Gecko") != -1) {
    engine = ENGINE_SPIDERMONKEY_TRUNK;
  } else if (typeof dump != "function") {
    
    dump = function() { };
  }
  dumpln = function(s) { dump(s + "\n"); };  printImportant = function(s) {
    dumpln(s);
    var p = document.createElement("pre");
    p.appendChild(document.createTextNode(s));
    document.body.appendChild(p);
  };
}if (typeof gc == "undefined")
  this.gc = function(){};
var gcIsQuiet = !(gc()); 
var HOTLOOP = 60;
function loopCount() { return rnd(rnd(HOTLOOP * 3)); }
function loopModulo() { return (rnd(2) ? rnd(rnd(HOTLOOP * 2)) : rnd(5)) + 2; }function simpleSource(s)
{
  function hexify(c)
  {
    var code = c.charCodeAt(0);
    var hex = code.toString(16);
    while (hex.length < 4)
      hex = "0" + hex;
    return "\\u" + hex;
  }  if (typeof s == "string")
    return ("\"" +
      s.replace(/\\/g, "\\\\")
       .replace(/\"/g, "\\\"")
       .replace(/\0/g, "\\0")
       .replace(/\n/g, "\\n")
       .replace(/[^ -~]/g, hexify) + 
      "\"");
  else
    return "" + s; 
}var haveRealUneval = (typeof uneval == "function");
if (!haveRealUneval)
  uneval = simpleSource;if (engine == ENGINE_UNKNOWN)
  printImportant("Targeting an unknown JavaScript engine!");
else if (engine == ENGINE_SPIDERMONKEY_TRUNK)
  printImportant("Targeting SpiderMonkey / Gecko (trunk).");
else if (engine == ENGINE_SPIDERMONKEY_MOZILLA45)
  printImportant("Targeting SpiderMonkey / Gecko (ESR45 branch).");
else if (engine == ENGINE_JAVASCRIPTCORE)
  printImportant("Targeting JavaScriptCore / WebKit.");
function whatToTestSpidermonkeyTrunk(code)
{
  /* jshint laxcomma: true */
  
  var codeL = code.replace(/\s/g, " ");  return {    allowParse: true,    allowExec: unlikelyToHang(code)
      && (jsshell || code.indexOf("nogeckoex") == -1)
    ,    allowIter: true,    
    
    expectConsistentOutput: true
       && (gcIsQuiet || code.indexOf("gc") == -1)
       && code.indexOf("/*NODIFF*/") == -1                
       && code.indexOf(".script") == -1                   
       && code.indexOf(".parameterNames") == -1           
       && code.indexOf(".environment") == -1              
       && code.indexOf(".onNewGlobalObject") == -1        
       && code.indexOf(".takeCensus") == -1               
       && code.indexOf(".findScripts") == -1              
       && code.indexOf("Date") == -1                      
       && code.indexOf("backtrace") == -1                 
       && code.indexOf("drainAllocationsLog") == -1       
       && code.indexOf("dumpObject") == -1                
       && code.indexOf("dumpHeap") == -1                  
       && code.indexOf("dumpStringRepresentation") == -1  
       && code.indexOf("evalInWorker") == -1              
       && code.indexOf("getBacktrace") == -1              
       && code.indexOf("getLcovInfo") == -1
       && code.indexOf("load") == -1                      
       && code.indexOf("offThreadCompileScript") == -1    
       && code.indexOf("oomAfterAllocations") == -1
       && code.indexOf("oomAtAllocation") == -1
       && code.indexOf("printProfilerEvents") == -1       
       && code.indexOf("validategc") == -1
       && code.indexOf("inIon") == -1                     
       && code.indexOf("inJit") == -1                     
       && code.indexOf("random") == -1
       && code.indexOf("timeout") == -1                   
    ,    expectConsistentOutputAcrossIter: true
    
       && code.indexOf("options") == -1             
    ,    expectConsistentOutputAcrossJITs: true
    
       && code.indexOf("'strict") == -1                 
       && code.indexOf("disassemble") == -1             
       && code.indexOf(".length") == -1                 
       && code.indexOf(".splice") == -1                 
       && !( codeL.match(/\/.*[\u0000\u0080-\uffff]/))    };
}function whatToTestSpidermonkeyMozilla45(code)
{
  /* jshint laxcomma: true */
  
  var codeL = code.replace(/\s/g, " ");  return {    allowParse: true,    allowExec: unlikelyToHang(code)
      && (jsshell || code.indexOf("nogeckoex") == -1)
    ,    allowIter: true,    
    
    expectConsistentOutput: true
       && (gcIsQuiet || code.indexOf("gc") == -1)
       && code.indexOf("/*NODIFF*/") == -1                
       && code.indexOf(".script") == -1                   
       && code.indexOf(".parameterNames") == -1           
       && code.indexOf(".environment") == -1              
       && code.indexOf(".onNewGlobalObject") == -1        
       && code.indexOf(".takeCensus") == -1               
       && code.indexOf(".findScripts") == -1              
       && code.indexOf("Date") == -1                      
       && code.indexOf("backtrace") == -1                 
       && code.indexOf("drainAllocationsLog") == -1       
       && code.indexOf("dumpObject") == -1                
       && code.indexOf("dumpHeap") == -1                  
       && code.indexOf("dumpStringRepresentation") == -1  
       && code.indexOf("evalInWorker") == -1              
       && code.indexOf("getBacktrace") == -1              
       && code.indexOf("getLcovInfo") == -1
       && code.indexOf("load") == -1                      
       && code.indexOf("offThreadCompileScript") == -1    
       && code.indexOf("oomAfterAllocations") == -1
       && code.indexOf("oomAtAllocation") == -1
       && code.indexOf("printProfilerEvents") == -1       
       && code.indexOf("validategc") == -1
       && code.indexOf("inIon") == -1                     
       && code.indexOf("inJit") == -1                     
       && code.indexOf("random") == -1
       && code.indexOf("timeout") == -1                   
    ,    expectConsistentOutputAcrossIter: true
    
       && code.indexOf("options") == -1             
    ,    expectConsistentOutputAcrossJITs: true
    
        && code.indexOf("'strict") == -1                 
        && code.indexOf("disassemble") == -1             
        && code.indexOf(".length") == -1                 
        && code.indexOf("preventExtensions") == -1       
        && code.indexOf("Math.round") == -1              
        && code.indexOf("with") == -1                    
        && code.indexOf("Number.MAX_VALUE") == -1        
        && code.indexOf("arguments") == -1               
        && code.indexOf(".splice") == -1                 
        && !( codeL.match(/\/.*[\u0000\u0080-\uffff]/))    };
}function whatToTestJavaScriptCore(code)
{
  return {    allowParse: true,
    allowExec: unlikelyToHang(code),
    allowIter: false, 
    expectConsistentOutput: false,
    expectConsistentOutputAcrossIter: false,
    expectConsistentOutputAcrossJITs: false  };
}function whatToTestGeneric(code)
{
  return {
    allowParse: true,
    allowExec: unlikelyToHang(code),
    allowIter: (typeof Iterator == "function"),
    expectConsistentOutput: false,
    expectConsistentOutputAcrossIter: false,
    expectConsistentOutputAcrossJITs: false
  };
}var whatToTest;
if (engine == ENGINE_SPIDERMONKEY_TRUNK)
  whatToTest = whatToTestSpidermonkeyTrunk;
else if (engine == ENGINE_SPIDERMONKEY_MOZILLA45)
  whatToTest = whatToTestSpidermonkeyMozilla45;
else if (engine == ENGINE_JAVASCRIPTCORE)
  whatToTest = whatToTestJavaScriptCore;
else
  whatToTest = whatToTestGeneric;
function unlikelyToHang(code)
{
  var codeL = code.replace(/\s/g, " ");  
  return true
    && code.indexOf("infloop") == -1
    && !( codeL.match( /for.*in.*uneval/ )) 
    && !( codeL.match( /for.*for.*for/ )) 
    && !( codeL.match( /for.*for.*gc/ ))
    ;
}
function confused(s)
{
  if (jsshell) {
    
    print("jsfunfuzz broke its own scripting environment: " + s);
    quit();
  }
}function foundABug(summary, details)
{
  
  
  printImportant("Found" + " a bug: " + summary);
  if (details) {
    printImportant(details);
  }
  if (jsshell) {
    dumpln("jsfunfuzz stopping due to finding a bug.");
    quit();
  }
}function errorToString(e)
{
  try {
    return ("" + e);
  } catch (e2) {
    return "Can't toString the error!!";
  }
}function errorstack()
{
  print("EEE");
  try {
    void ([].qwerty.qwerty);
  } catch(e) { print(e.stack); }
}
var Random = {
  twister: null,  init: function (seed) {
    if (seed == null || seed === undefined) {
      seed = new Date().getTime();
    }
    this.twister = new MersenneTwister19937();
    this.twister.seed(seed);
  },
  number: function (limit) {
    if (limit == 0) {
      return limit;
    }
    if (limit == null || limit === undefined) {
      limit = 0xffffffff;
    }
    return (Random.twister.int32() >>> 0) % limit;
  },
  float: function () {
    return (Random.twister.int32() >>> 0) * (1.0/4294967295.0);
  },
  range: function (start, limit) {
    if (isNaN(start) || isNaN(limit)) {
      Utils.traceback();
      throw new TypeError("Random.range() received a non number type: '" + start + "', '" + limit + "')");
    }
    return Random.number(limit - start + 1) + start;
  },
  index: function (list, emptyr) {
    if (!(list instanceof Array || (typeof list != "string" && "length" in list))) {
      Utils.traceback();
      throw new TypeError("Random.index() received a non array type: '" + list + "'");
    }
    if (!list.length)
      return emptyr;
    return list[this.number(list.length)];
  },
  key: function (obj) {
    var list = [];
    for (var i in obj) {
      list.push(i);
    }
    return this.index(list);
  },
  bool: function () {
    return this.index([true, false]);
  },
  pick: function (obj) {
    if (typeof obj == "function") {
      return obj();
    }
    if (obj instanceof Array) {
      return this.pick(this.index(obj));
    }
    return obj;
  },
  chance: function (limit) {
    if (limit == null || limit === undefined) {
      limit = 2;
    }
    if (isNaN(limit)) {
      Utils.traceback();
      throw new TypeError("Random.chance() received a non number type: '" + limit + "'");
    }
    return this.number(limit) == 1;
  },
  choose: function (list, flat) {
    if (!(list instanceof Array)) {
      Utils.traceback();
      throw new TypeError("Random.choose() received a non-array type: '" + list + "'");
    }
    var total = 0;
    for (var i = 0; i < list.length; i++) {
      total += list[i][0];
    }
    var n = this.number(total);
    for (var i = 0; i < list.length; i++) {
      if (n <= list[i][0]) {
        if (flat == true) {
          return list[i][1];
        } else {
          return this.pick([list[i][1]]);
        }
      }
      n = n - list[i][0];
    }
    if (flat == true) {
      return list[0][1];
    }
    return this.pick([list[0][1]]);
  },
  weighted: function (wa) {
    
    var a = [];
    for (var i = 0; i < wa.length; ++i) {
      for (var j = 0; j < wa[i].w; ++j) {
        a.push(wa[i].v);
      }
    }
    return a;
  },
  use: function (obj) {
    return Random.bool() ? obj : "";
  },
  shuffle: function (arr) {
    var len = arr.length;
    var i = len;
    while (i--) {
      var p = Random.number(i + 1);
      var t = arr[i];
      arr[i] = arr[p];
      arr[p] = t;
    }
  },
  shuffled: function (arr) {
    var newArray = arr.slice();
    Random.shuffle(newArray);
    return newArray;
  },
  subset: function(a) {
    
    
    var subset = [];
    for (var i = 0; i < a.length; ++i) {
      if (rnd(2)) {
        subset.push(a[i]);
      }
    }
    return subset;
  },};function rnd(n) { return Random.number(n); }
/*
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
   Any feedback is very welcome.
   http:
   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)
*/
function MersenneTwister19937()
{
  const N = 624;
  const M = 397;
  const MAG01 = new Int32Array([0, 0x9908b0df]);  var mt = new Int32Array(N);   /* the array for the state vector */
  var mti = 625;  this.seed = function (s) {
    mt[0] = s | 0;
    for (mti=1; mti<N; mti++) {
      mt[mti] = Math.imul(1812433253, mt[mti-1] ^ (mt[mti-1] >>> 30)) + mti;
    }
  };  this.export_state = function() { return [mt, mti]; };
  this.import_state = function(s) { mt = s[0]; mti = s[1]; };
  this.export_mta = function() { return mt; };
  this.import_mta = function(_mta) { mt = _mta; };
  this.export_mti = function() { return mti; };
  this.import_mti = function(_mti) { mti = _mti; };  function mag01(y)
  {
    return MAG01[y & 0x1];
  }  this.int32 = function () {
    var y;
    var kk;    if (mti >= N) { /* generate N words at one time */
      for (kk=0;kk<N-M;kk++) {
        y = ((mt[kk]&0x80000000)|(mt[kk+1]&0x7fffffff));
        mt[kk] = (mt[kk+M] ^ (y >>> 1) ^ mag01(y));
      }
      for (;kk<N-1;kk++) {
        y = ((mt[kk]&0x80000000)|(mt[kk+1]&0x7fffffff));
        mt[kk] = (mt[kk+(M-N)] ^ (y >>> 1) ^ mag01(y));
      }
      y = ((mt[N-1]&0x80000000)|(mt[0]&0x7fffffff));
      mt[N-1] = (mt[M-1] ^ (y >>> 1) ^ mag01(y));
      mti = 0;
    }    y = mt[mti++];    /* Tempering */
    y = y ^ (y >>> 11);
    y = y ^ ((y << 7) & 0x9d2c5680);
    y = y ^ ((y << 15) & 0xefc60000);
    y = y ^ (y >>> 18);    return y;
  };
}
function fuzzTestingFunctionsCtor(browser, fGlobal, fObject)
{
  var prefix = browser ? "fuzzPriv." : "";  function numberOfAllocs() { return Math.floor(Math.exp(rnd(rnd(6000)) / 1000)); }
  function gcSliceSize() { return Math.floor(Math.pow(2, Random.float() * 32)); }
  function maybeCommaShrinking() { return rnd(5) ? "" : ", 'shrinking'"; }  function enableGCZeal()
  {
    var level = rnd(15);
    if (browser && level == 9) level = 0; 
    var period = numberOfAllocs();
    return prefix + "gczeal" + "(" + level + ", " + period + ");";
  }  function callSetGCCallback() {
    
    var phases = Random.index(["both", "begin", "end"]);
    var actionAndOptions = rnd(2) ? 'action: "majorGC", depth: ' + rnd(17) : 'action: "minorGC"';
    var arg = "{ " + actionAndOptions + ", phases: \"" + phases + "\" }";
    return prefix + "setGCCallback(" + arg + ");";
  }  function tryCatch(statement)
  {
    return "try { " + statement + " } catch(e) { }";
  }  function setGcparam() {
    switch(rnd(2)) {
      case 0:  return _set("sliceTimeBudget", rnd(100));
      default: return _set("markStackLimit", rnd(2) ? (1 + rnd(30)) : 4294967295); 
    }    function _set(name, value) {
      
      return tryCatch(prefix + "gcparam" + "('" + name + "', " + value + ");");
    }
  }  
  
  var sharedTestingFunctions = [
    
    { w: 10, v: function(d, b) { return "void " + prefix + "gc" + "("                                            + ");"; } },
    { w: 10, v: function(d, b) { return "void " + prefix + "gc" + "(" + "'compartment'" + maybeCommaShrinking() + ");"; } },
    { w: 5,  v: function(d, b) { return "void " + prefix + "gc" + "(" + fGlobal(d, b)   + maybeCommaShrinking() + ");"; } },    
    { w: 20, v: function(d, b) { return prefix + "minorgc" + "(false);"; } },
    { w: 20, v: function(d, b) { return prefix + "minorgc" + "(true);"; } },    
    
    { w: 20, v: function(d, b) { return tryCatch(prefix + "startgc" + "(" + gcSliceSize() + maybeCommaShrinking() + ");"); } },
    { w: 20, v: function(d, b) { return prefix + "gcslice" + "(" + gcSliceSize() + ");"; } },
    { w: 10, v: function(d, b) { return prefix + "abortgc" + "(" + ");"; } },    
    { w: 10, v: function(d, b) { return prefix + "selectforgc" + "(" + fObject(d, b) + ");"; } },    
    { w: 10, v: function(d, b) { return "void " + prefix + "schedulegc" + "(" + fGlobal(d, b) + ");"; } },    
    { w: 10, v: function(d, b) { return "void " + prefix + "schedulegc" + "(" + numberOfAllocs() + ");"; } },    
    { w: 10, v: setGcparam },    
    
    
    { w: 10, v: function(d, b) { return prefix + "verifyprebarriers" + "();"; } },    
    
    { w: 1,  v: function(d, b) { return "void " + prefix + "hasChild(" + fObject(d, b) + ", " + fObject(d, b) + ");"; } },    
    { w: 5,  v: function(d, b) { return prefix + "validategc" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "validategc" + "(true);"; } },
    { w: 5,  v: function(d, b) { return prefix + "fullcompartmentchecks" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "fullcompartmentchecks" + "(true);"; } },
    { w: 5,  v: function(d, b) { return prefix + "setIonCheckGraphCoherency" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "setIonCheckGraphCoherency" + "(true);"; } },
    { w: 1,  v: function(d, b) { return prefix + "enableOsiPointRegisterChecks" + "();"; } },    
    { w: 1,  v: function(d, b) { return prefix + "assertJitStackInvariants" + "();"; } },    
    { w: 1,  v: function(d, b) { return prefix + "setJitCompilerOption" + "('baseline.warmup.trigger', " + rnd(20) + ");"; } },
    { w: 1,  v: function(d, b) { return prefix + "setJitCompilerOption" + "('ion.warmup.trigger', " + rnd(40) + ");"; } },    
    { w: 1,  v: function(d, b) { return prefix + "setJitCompilerOption" + "('ion.forceinlineCaches\', " + rnd(2) + ");"; } },    
    
    { w: 1,  v: function(d, b) { return tryCatch(prefix + "setJitCompilerOption" + "('ion.enable', " + rnd(2) + ");"); } },
    { w: 1,  v: function(d, b) { return tryCatch(prefix + "setJitCompilerOption" + "('baseline.enable', " + rnd(2) + ");"); } },    
    { w: 1,  v: function(d, b) { return prefix + "enableSPSProfiling" + "();"; } },
    { w: 1,  v: function(d, b) { return prefix + "enableSPSProfilingWithSlowAssertions" + "();"; } },
    { w: 5,  v: function(d, b) { return prefix + "disableSPSProfiling" + "();"; } },
    { w: 1,  v: function(d, b) { return "void " + prefix + "readSPSProfilingStack" + "();"; } },    
    { w: 5,  v: function(d, b) { return prefix + "deterministicgc" + "(false);"; } },
    { w: 1,  v: function(d, b) { return prefix + "deterministicgc" + "(true);"; } },    
    { w: 5,  v: function(d, b) { return prefix + "gcPreserveCode" + "();"; } },    
    { w: 1,  v: function(d, b) { return "void " + prefix + "getLcovInfo" + "();"; } },
    { w: 1,  v: function(d, b) { return "void " + prefix + "getLcovInfo" + "(" + fGlobal(d, b) + ");"; } },
  ];  
  
  var shellOnlyTestingFunctions = [
    
    { w: 5,  v: function(d, b) { return prefix + "bailout" + "();"; } },    
    
    { w: 1,  v: function(d, b) { return tryCatch("(void" + prefix + "disableSingleStepProfiling" + "()" + ")"); } },
    { w: 1,  v: function(d, b) { return tryCatch("(" + prefix + "enableSingleStepProfiling" + "()" + ")"); } },    
    { w: 10, v: function(d, b) { return "void " + prefix + "relazifyFunctions" + "();"; } },
    { w: 10, v: function(d, b) { return "void " + prefix + "relazifyFunctions" + "('compartment');"; } },
    { w: 5,  v: function(d, b) { return "void " + prefix + "relazifyFunctions" + "(" + fGlobal(d, b) + ");"; } },    
    
    { w: 1,  v: function(d, b) { return (typeof oomAfterAllocations == "function" && rnd(1000) === 0) ? prefix + "oomAfterAllocations" + "(" + (numberOfAllocs() - 1) + ");" : "void 0;"; } },
    
    { w: 1,  v: function(d, b) { return (typeof oomAtAllocation == "function" && rnd(100) === 0) ? prefix + "oomAtAllocation" + "(" + (numberOfAllocs() - 1) + ");" : "void 0;"; } },
    
    { w: 1,  v: function(d, b) { return (typeof resetOOMFailure == "function") ? "void " + prefix + "resetOOMFailure" + "(" + ");" : "void 0;"; } },    
    
    { w: 1,  v: function(d, b) { return (rnd(100) === 0) ? (enableGCZeal()) : "void 0;"; } },    { w: 10, v: callSetGCCallback },
  ];  var testingFunctions = Random.weighted(browser ? sharedTestingFunctions : sharedTestingFunctions.concat(shellOnlyTestingFunctions));  return { testingFunctions: testingFunctions, enableGCZeal: enableGCZeal };
}
/*
        It might be more interesting to use Object.getOwnPropertyDescriptor to find out if
        a thing is exposed as a getter (like Debugger.prototype.enabled).  But there are exceptions:        <Jesse> why is Array.prototype.length not a getter? http:
        <jorendorff> backward compatibility
        <jorendorff> ES3 already allowed programs to create objects with arbitrary __proto__
        <jorendorff> .length was specified to work as a data property; accessor properties inherit differently, especially when setting
        <jorendorff> maybe only when setting, come to think of it
        <jorendorff> I guess it could've been made an accessor property without breaking anything important. I didn't realize it at the time.
*/var constructors = []; 
var builtinFunctions = []; 
var builtinProperties = []; 
var allMethodNames = []; 
var allPropertyNames = []; var builtinObjectNames = []; 
var builtinObjects = {}; (function exploreBuiltins(glob, debugMode) {  function exploreDeeper(a, an)
  {
    if (!a)
      return;
    var hns = Object.getOwnPropertyNames(a);
    var propertyNames = [];
    for (var j = 0; j < hns.length; ++j) {
      var hn = hns[j];
      propertyNames.push(hn);
      allPropertyNames.push(hn);      var fullName = an + "." + hn;
      builtinProperties.push(fullName);      var h;
      try {
        h = a[hn];
      } catch(e) {
        if (debugMode) {
          dumpln("Threw: " + fullName);
        }
        h = null;
      }      if (typeof h == "function" && hn != "constructor") {
        allMethodNames.push(hn);
        builtinFunctions.push(fullName);
      }
    }
    builtinObjects[an] = propertyNames;
    builtinObjectNames.push(an);
  }  function exploreConstructors()
  {
    var gns = Object.getOwnPropertyNames(glob);
    for (var i = 0; i < gns.length; ++i) {
      var gn = gns[i];
      
      
      if (0x40 < gn.charCodeAt(0) && gn.charCodeAt(0) < 0x60 && gn != "PerfMeasurement" && !(jsshell && gn == "Worker")) {
        var g = glob[gn];
        if (typeof g == "function" && g.toString().indexOf("[native code]") != -1) {
          constructors.push(gn);
          builtinProperties.push(gn);
          builtinFunctions.push(gn);
          exploreDeeper(g, gn);
          exploreDeeper(g.prototype, gn + ".prototype");
        }
      }
    }
  }  exploreConstructors();  exploreDeeper(Math, "Math");
  exploreDeeper(JSON, "JSON");
  exploreDeeper(Proxy, "Proxy");  if (debugMode) {
    for (let x of constructors) print("^^^^^ " + x);
    for (let x of builtinProperties) print("***** " + x);
    for (let x of builtinFunctions) print("===== " + x);
    for (let x of allMethodNames) print("!!!!! " + x);
    for (let x of allPropertyNames) print("&&&&& " + x);
    print(uneval(builtinObjects));
    quit();
  }})(this, false);function cat(toks)
{
  if (rnd(1700) === 0)
    return totallyRandom(2, ["x"]);  var torture = (rnd(1700) === 57);
  if (torture)
    dumpln("Torture!!!");  var s = maybeLineBreak();
  for (var i = 0; i < toks.length; ++i) {    
    
    
    
    
    if (typeof(toks[i]) != "string") {
      dumpln("Strange item in the array passed to cat: typeof toks[" + i + "] == " + typeof(toks[i]));
      dumpln(cat.caller);
      dumpln(cat.caller.caller);
    }    if (!(torture && rnd(12) === 0))
      s += toks[i];    s += maybeLineBreak();    if (torture) switch(rnd(120)) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        s += maybeSpace() + totallyRandom(2, ["x"]) + maybeSpace();
        break;
      case 5:
        s = "(" + s + ")"; 
        break;
      case 6:
        s = ""; 
        break;
      case 7:
        return s; 
      case 8:
        s += UNTERMINATED_COMMENT;
        break;
      case 9:
        s += UNTERMINATED_STRING_LITERAL;
        break;
      case 10:
        if (rnd(2))
          s += "(";
        s += UNTERMINATED_REGEXP_LITERAL;
        break;
      default:
    }  }  return s;
}
/*
function catNice(toks)
{
  var s = ""
  var i;
  for (i=0; i<toks.length; ++i) {
    if(typeof(toks[i]) != "string")
      confused("Strange toks[i]: " + toks[i]);    s += toks[i];
  }  return s;
}
*/
var UNTERMINATED_COMMENT = "/*"; /* this comment is here so my text editor won't get confused */
var UNTERMINATED_STRING_LITERAL = "'";
var UNTERMINATED_REGEXP_LITERAL = "/";function maybeLineBreak()
{
  if (rnd(900) === 3)
    return Random.index(["\r", "\n", "//h\n", "/*\n*/"]);
  else if (rnd(400) === 3)
    return rnd(2) ? "\u000C" : "\t"; 
  else
    return "";
}function maybeSpace()
{
  if (rnd(2) === 0)
    return " ";
  else
    return "";
}function stripSemicolon(c)
{
  var len = c.length;
  if (c.charAt(len - 1) == ";")
    return c.substr(0, len - 1);
  else
    return c;
}var TOTALLY_RANDOM = 1000;var allMakers = getListOfMakers(this);function totallyRandom(d, b) {
  d = d + (rnd(5) - 2);   var maker = Random.index(allMakers);
  var val = maker(d, b);
  if (typeof val != "string") {
    print(maker.name);
    print(maker);
    throw "We generated something that isn't a string!";
  }
  return val;
}function getListOfMakers(glob)
{
  var r = [];
  for (var f in glob) {
    if (f.indexOf("make") == 0 && typeof glob[f] == "function" && f != "makeFinalizeObserver" && f != "makeFakePromise") {
      r.push(glob[f]);
    }
  }
  return r;
}
/*
function testEachMaker()
{
  for (var f of allMakers) {
    dumpln("");
    dumpln(f.name);
    dumpln("==========");
    dumpln("");
    for (var i = 0; i < 100; ++i) {
      try {
        var r = f(8, ["A", "B"]);
        if (typeof r != "string")
          throw ("Got a " + typeof r);
        dumpln(r);
      } catch(e) {
        dumpln("");
        dumpln(uneval(e));
        dumpln(e.stack);
        dumpln("");
        throw "testEachMaker found a bug in jsfunfuzz";
      }
    }
    dumpln("");
  }
}
*/
/***************************
 * GENERATE ASM.JS MODULES *
 ***************************/
function asmJSInterior(foreignFunctions, sanePlease)
{
  function mess()
  {
    if (!sanePlease && rnd(600) === 0)
      return makeStatement(8, ["x"]) + "\n";
    if (!sanePlease && rnd(600) === 0)
      return totallyRandom(8, ["x"]);
    return "";
  }  var globalEnv = {stdlibImported: {}, stdlibImports: "", heapImported: {}, heapImports: "", foreignFunctions: foreignFunctions, sanePlease: !!sanePlease};
  var asmFunDecl = asmJsFunction(globalEnv, "f", rnd(2) ? "signed" : "double", [rnd(2) ? "i0" : "d0", rnd(2) ? "i1" : "d1"]);
  var interior = mess() + globalEnv.stdlibImports +
                 mess() + importForeign(foreignFunctions) +
                 mess() + globalEnv.heapImports +
                 mess() + asmFunDecl +
                 mess() + "  return f;" +
                 mess();
  return interior;
}function importForeign(foreignFunctions)
{
  var s = "";
  for (let h of foreignFunctions) {
    s += "  var " + h + " = foreign." + h + ";\n";
  }
  return s;
}function asmJsFunction(globalEnv, name, ret, args)
{
  var s = "  function " + name + "(" + args.join(", ") + ")\n";
  s += "  {\n";
  s += parameterTypeAnnotations(args);  
  var locals = args;
  while (rnd(2)) {
    var isDouble = rnd(2);
    var local = (isDouble ? "d" : "i") + locals.length;
    s += "    var " + local + " = " + (isDouble ? doubleLiteral() : "0") + ";\n";
    locals.push(local);
  }  var env = {globalEnv: globalEnv, locals: locals, ret: ret};  
  if (locals.length) {
    while (rnd(5)) {
      s += asmStatement("    ", env, 6);
    }
  }  
  if (ret != "void" || rnd(2))
  s += asmReturnStatement("    ", env);  s += "  }\n";  return s;
}function asmStatement(indent, env, d)
{
  if (!env.globalEnv.sanePlease && rnd(100) === 0)
    return makeStatement(3, ["x"]);  if (rnd(5) === 0 && d > 0) {
    return indent + "{\n" + asmStatement(indent + "  ", env, d - 1) + indent + "}\n";
  }
  if (rnd(20) === 0 && d > 3) {
    return asmSwitchStatement(indent, env, d);
  }
  if (rnd(10) === 0) {
    return asmReturnStatement(indent, env);
  }
  if (rnd(50) === 0 && env.globalEnv.foreignFunctions.length) {
    return asmVoidCallStatement(indent, env);
  }
  if (rnd(100) === 0)
    return ";";
  return asmAssignmentStatement(indent, env);
}function asmVoidCallStatement(indent, env)
{
  return indent + asmFfiCall(8, env) + ";\n";
}function asmAssignmentStatement(indent, env)
{
  if (rnd(5) === 0 || !env.locals.length) {
    if (rnd(2)) {
      return indent + intishMemberExpr(8, env) + " = " + intishExpr(10, env) + ";\n";
    } else {
      return indent + doublishMemberExpr(8, env) + " = " + doublishExpr(10, env) + ";\n";
    }
  }  var local = Random.index(env.locals);
    if (local.charAt(0) == "d") {
    return indent + local + " = " + doubleExpr(10, env) + ";\n";
  } else {
    return indent + local + " = " + intExpr(10, env) + ";\n";
  }
}function asmReturnStatement(indent, env)
{
  var ret = rnd(2) ? env.ret : Random.index(["double", "signed", "void"]);
  if (env.ret == "double")
    return indent + "return +" + doublishExpr(10, env) + ";\n";
  else if (env.ret == "signed")
    return indent + "return (" + intishExpr(10, env) + ")|0;\n";
  else 
    return indent + "return;\n";
}function asmSwitchStatement(indent, env, d)
{
  var s = indent + "switch (" + signedExpr(4, env) + ") {\n";
  while (rnd(3)) {
    s += indent + "  case " + (rnd(5)-3) + ":\n";
    s += asmStatement(indent + "    ", env, d - 2);
    if (rnd(4))
      s += indent + "    break;\n";
  }
  if (rnd(2)) {
    s += indent + "  default:\n";
    s += asmStatement(indent + "    ", env, d - 2);
  }
  s += indent + "}\n";
  return s;
}function parameterTypeAnnotations(args)
{
  var s = "";
  for (var a = 0; a < args.length; ++a) {
    var arg = args[a];
    if (arg.charAt(0) == "i")
      s += "    " + arg + " = " + arg + "|0;\n";
    else
      s += "    " + arg + " = " + "+" + arg + ";\n";
  }
  return s;
}
var additive = ["+", "-"];
var intExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return intLiteralRange(-0x8000000, 0xffffffff); }},
    {w: 1,  v: function(d, e) { return intExpr(d - 3, e) + " ? " + intExpr(d - 3, e) + " : " + intExpr(d - 3, e); }},
    {w: 1,  v: function(d, e) { return "!" + intExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 1, e); }},
    {w: 10, v: function(d, e) { return intVar(e); }}, 
    {w: 1,  v: function(d, e) { return e.globalEnv.foreignFunctions.length ? asmFfiCall(d, e) + "|0" : "1"; }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 2, e) + Random.index([" < ", " <= ", " > ", " >= ", " == ", " != "]) + signedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 2, e) + Random.index([" < ", " <= ", " > ", " >= ", " == ", " != "]) + unsignedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doubleExpr(d - 2, e) + Random.index([" < ", " <= ", " > ", " >= ", " == ", " != "]) + doubleExpr(d - 2, e); }},
]));var intishExpr = autoExpr(Random.weighted([
    {w: 10, v: function(d, e) { return intExpr(d, e); }},
    {w: 1,  v: function(d, e) { return intishMemberExpr(d, e); }},
    
    {w: 10, v: function(d, e) { return intExpr(d - 1, e) + Random.index(additive) + intExpr(d - 1, e); }},
    {w: 5,  v: function(d, e) { return intExpr(d - 2, e) + Random.index(additive) + intExpr(d - 2, e) + Random.index(additive) + intExpr(d - 2, e); }},
    
    {w: 2,  v: function(d, e) { return intExpr(d - 1, e) + "*" + intLiteralRange(-0xfffff, 0xfffff); }},
    {w: 2,  v: function(d, e) { return intLiteralRange(-0xfffff, 0xfffff) + "*" + intExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "-" + intExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 2, e) + " / " + signedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 2, e) + " / " + unsignedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return signedExpr(d - 2, e) + " % " + signedExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return unsignedExpr(d - 2, e) + " % " + unsignedExpr(d - 2, e); }},
]));var signedExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return intLiteralRange(-0x8000000, 0x7fffffff); }},
    {w: 1,  v: function(d, e) { return "~" + intishExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "~~" + doubleExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return intishExpr(d - 1, e) + "|0"; }}, 
    {w: 1,  v: function(d, e) { return ensureMathImport(e, "imul") + "(" + intExpr(d - 2, e) + ", " + intExpr(d - 2, e) + ")|0"; }},
    {w: 1,  v: function(d, e) { return ensureMathImport(e, "abs") + "(" + signedExpr(d - 1, e) + ")|0"; }},
    {w: 5,  v: function(d, e) { return intishExpr(d - 2, e) + Random.index([" | ", " & ", " ^ ", " << ", " >> "]) + intishExpr(d - 2, e); }},
]));var unsignedExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return intLiteralRange(0, 0xffffffff); }},
    {w: 1,  v: function(d, e) { return intishExpr(d - 2, e) + ">>>" + intishExpr(d - 2, e); }},
]));var doublishExpr = autoExpr(Random.weighted([
    {w: 10, v: function(d, e) { return doubleExpr(d, e); }},
    {w: 1,  v: function(d, e) { return doublishMemberExpr(d, e); }},
    
]));var doubleExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return doubleLiteral(); }},
    {w: 20, v: function(d, e) { return doubleVar(e); }},
    {w: 1,  v: function(d, e) { return e.globalEnv.foreignFunctions.length ? "+" + asmFfiCall(d, e) : "1.0"; }},
    {w: 1,  v: function(d, e) { return "+(1.0/0.0)"; }},
    {w: 1,  v: function(d, e) { return "+(0.0/0.0)"; }},
    {w: 1,  v: function(d, e) { return "+(-1.0/0.0)"; }},
    
    {w: 1,  v: function(d, e) { return "+" + signedExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "+" + unsignedExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "+" + doublishExpr(d - 1, e); }},
    {w: 1,  v: function(d, e) { return "-" + doublishExpr(d - 1, e); }},
    
    {w: 1,  v: function(d, e) { return doubleExpr(d - 2, e) + " + " + doubleExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " - " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " * " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " / " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return doublishExpr(d - 2, e) + " % " + doublishExpr(d - 2, e); }},
    {w: 1,  v: function(d, e) { return intExpr(d - 3, e) + " ? " + doubleExpr(d - 3, e) + " : " + doubleExpr(d - 3, e); }},
    
    {w: 1,  v: function(d, e) { return "+" + ensureMathImport(e, Random.index(["acos", "asin", "atan", "cos", "sin", "tan", "ceil", "floor", "exp", "log", "sqrt"])) + "(" + doublishExpr(d - 1, e) + ")"; }},
    {w: 1,  v: function(d, e) { return "+" + ensureMathImport(e, "abs") + "(" + doublishExpr(d - 1, e) + ")"; }},
    {w: 1,  v: function(d, e) { return "+" + ensureMathImport(e, Random.index(["atan2", "pow"])) + "(" + doublishExpr(d - 2, e) + ", " + doublishExpr(d - 2, e) + ")"; }},
    {w: 1,  v: function(d, e) { return ensureImport(e, "Infinity"); }},
    {w: 1,  v: function(d, e) { return ensureImport(e, "NaN"); }},
]));var externExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return doubleExpr(d, e); } },
    {w: 1,  v: function(d, e) { return signedExpr(d, e); } },
]));var intishMemberExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return ensureView(e, Random.index(["Int8Array",  "Uint8Array" ])) + "[" + asmIndex(d, e, 0) + "]"; }},
    {w: 1,  v: function(d, e) { return ensureView(e, Random.index(["Int16Array", "Uint16Array"])) + "[" + asmIndex(d, e, 1) + "]"; }},
    {w: 1,  v: function(d, e) { return ensureView(e, Random.index(["Int32Array", "Uint32Array"])) + "[" + asmIndex(d, e, 2) + "]"; }},
]), true);var doublishMemberExpr = autoExpr(Random.weighted([
    {w: 1,  v: function(d, e) { return ensureView(e, "Float32Array") + "[" + asmIndex(d, e, 2) + "]"; }},
    {w: 1,  v: function(d, e) { return ensureView(e, "Float64Array") + "[" + asmIndex(d, e, 3) + "]"; }},
]), true);function asmIndex(d, e, logSize)
{
  if (rnd(2) || d < 2)
    return Random.index(["0", "1", "2", "4096"]);  return intishExpr(d - 2, e) + " >> " + logSize;
}function asmFfiCall(d, e)
{
  var argList = "";
  while (rnd(6)) {
    if (argList)
      argList += ", ";
    d -= 1;
    argList += externExpr(d, e);
  }  return "/*FFI*/" + Random.index(e.globalEnv.foreignFunctions) + "(" + argList + ")";
}
function ensureView(e, t)
{
  var varName = t + "View";
  if (!(varName in e.globalEnv.heapImported)) {
    e.globalEnv.heapImports += "  var " + varName + " = new stdlib." + t + "(heap);\n";
    e.globalEnv.heapImported[varName] = true;
  }
  return varName;
}function ensureMathImport(e, f)
{
  return ensureImport(e, f, "Math.");
}function ensureImport(e, f, prefix)
{
  if (!(f in e.globalEnv.stdlibImported)) {
    e.globalEnv.stdlibImports += "  var " + f + " = stdlib." + (prefix||"") + f + ";\n";
    e.globalEnv.stdlibImported[f] = true;
  }
  return f;
}
var anyAsmExpr = [intExpr, intishExpr, signedExpr, doublishExpr, doubleExpr, intishMemberExpr, doublishMemberExpr];function autoExpr(funs, avoidSubst)
{
  return function(d, e) {
    var f = d < 1 ? funs[0] :
            rnd(50) === 0 && !e.globalEnv.sanePlease ? function(_d, _e) { return makeExpr(5, ["x"]); } :
            rnd(50) === 0 && !avoidSubst ? Random.index(anyAsmExpr) :
            Random.index(funs);
    return "(" + f(d, e) + ")";
  };
}function intVar(e)
{
  var locals = e.locals;
  if (!locals.length)
    return intLiteralRange(-0x8000000, 0xffffffff);
  var local = Random.index(locals);
  if (local.charAt(0) == "i")
    return local;
  return intLiteralRange(-0x8000000, 0xffffffff);
}function doubleVar(e)
{
  var locals = e.locals;
  if (!locals.length)
    return doubleLiteral();
  var local = Random.index(locals);
  if (local.charAt(0) == "d")
    return local;
  return doubleLiteral();
}
function doubleLiteral()
{
  return Random.index(["-", ""]) + positiveDoubleLiteral();
}function positiveDoubleLiteral()
{
  if (rnd(3) === 0) {
    Random.index(["0.0", "1.0", "1.2345e60"]);
  }  
  var value = Math.pow(2, rnd(100) - 10);  
  if (rnd(3)) {
    value += 1;
  } else if (value > 1 && rnd(2)) {
    value -= 1;
  }  var str = value + "";
  if (str.indexOf(".") == -1) {
    return str + ".0";
  }
  
  return str;
}function fuzzyRange(min, max)
{
  if (rnd(10000) === 0)
    return min - 1;
  if (rnd(10000) === 0)
    return max + 1;
  if (rnd(10) === 0)
    return min;
  if (rnd(10) === 0)
    return max;  
  if (max > min + 0x100000000 && rnd(3) === 0)
    return min + 0x100000000 + rnd(max - (min + 0x100000000) + 1);
  return min + rnd(max - min + 1);
}function intLiteralRange(min, max)
{
  var val = fuzzyRange(min, max);
  var sign = val < 0 ? "-" : "";
  return sign + "0x" + Math.abs(val).toString(16);
}
const NUM_MATH_FUNCTIONS = 6;var binaryMathOps = [
  " * ", /* NODIFF " / " */, " % ",  
  " + ", " - ",
  " ** ",
  " << ", " >> ", " >>> ",
  " < ", " > ", " <= ", " >= ",
  " == ", " != ",
  " === ", " !== ",
  " & ", " | ", " ^ ", " && ", " || ",
  " , ",
];var leftUnaryMathOps = [
  " ! ", " + ", " - ", " ~ ",
];var unaryMathFunctions = [
  "abs",
  "acos",
  "acosh",
  "asin",
  "asinh",
  "atan",
  "atanh",
  "cbrt",
  "ceil",
  "cos",
  "cosh",
  "exp",
  "expm1",
  
  "fround",
  "log",
  "log2",
  "log10",
  "log1p",
  
  "round",
  "sign",
  "sin",
  "sinh",
  "sqrt",
  "tan",
  "tanh",
  "trunc",
];
var binaryMathFunctions = [
  "atan2",
  "hypot", 
  "imul",
  "max", 
  "min", 
  "pow",
];function makeMathFunction(d, b, i)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var ivars = ["x", "y"];
  if (rnd(10) == 0) {
    
    ivars = ivars.concat(b);
  }
  return "(function(x, y) { " + directivePrologue() + "return " + makeMathExpr(d, ivars, i) + "; })";
}function makeMathExpr(d, b, i)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  if (d < rnd(5)) {
    if (rnd(4)) {
      return Random.index(b);
    }
    return Random.index(numericVals);
  }  if (rnd(500) == 0 && d > 0)
    return makeExpr(d - 1, b);  function r() { return makeMathExpr(d - 1, b, i); }  
  
  var commonCoercion = rnd(10);
  function mc(expr) {
    switch(rnd(3) ? commonCoercion : rnd(10)) {
      case 0: return "(" + " + " + expr + ")";     
      case 1: return "Math.fround(" + expr + ")";  
      case 2: return "(" + expr + " | 0)";         
      case 3: return "(" + expr + " >>> 0)";       
      default: return expr;
    }
  }  if (i > 0 && rnd(10) == 0) {
    
    return mc("mathy" + rnd(i) + "(" + mc(r()) + ", " + mc(r()) + ")");
  }  if (rnd(20) == 0) {
    return mc("(" + mc(r()) + " ? " + mc(r()) + " : " + mc(r()) + ")");
  }  switch(rnd(4)) {
    case 0:  return mc("(" + mc(r()) + Random.index(binaryMathOps) + mc(r()) + ")");
    case 1:  return mc("(" + Random.index(leftUnaryMathOps) + mc(r()) + ")");
    case 2:  return mc("Math." + Random.index(unaryMathFunctions) + "(" + mc(r()) + ")");
    default: return mc("Math." + Random.index(binaryMathFunctions) + "(" + mc(r()) + ", " + mc(r()) + ")");
  }
}/****************************
 * GRAMMAR-BASED GENERATION *
 ****************************/
function makeScript(d, ignoredB)
{
  return directivePrologue() + makeScriptBody(d, ignoredB);
}function makeScriptBody(d, ignoredB)
{
  if (rnd(3) == 0) {
    return makeMathyFunAndTest(d, ["x"]);
  }
  return makeStatement(d, ["x"]);
}function makeScriptForEval(d, b)
{
  switch (rnd(4)) {
    case 0:  return makeExpr(d - 1, b);
    case 1:  return makeStatement(d - 1, b);
    case 2:  return makeUseRegressionTest(d, b);
    default: return makeScript(d - 3, b);
  }
}function makeStatement(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(2))
    return makeBuilderStatement(d, b);  if (d < 6 && rnd(3) === 0)
    return makePrintStatement(d, b);  if (d < rnd(8)) 
    return makeLittleStatement(d, b);  d = rnd(d);   return (Random.index(statementMakers))(d, b);
}var varBinder = ["var ", "let ", "const ", ""];
var varBinderFor = ["var ", "let ", ""]; 
function forLoopHead(d, b, v, reps)
{
  var sInit = Random.index(varBinderFor) + v + " = 0";
  var sCond = v + " < " + reps;
  var sNext = "++" + v;  while (rnd(10) === 0)
    sInit += ", " + makeLetHeadItem(d - 2, b);
  while (rnd(10) === 0)
    sInit += ", " + makeExpr(d - 2, b);   while (rnd(20) === 0)
    sCond = sCond + " && (" + makeExpr(d - 2, b) + ")";
  while (rnd(20) === 0)
    sCond = "(" + makeExpr(d - 2, b) + ") && " + sCond;  while (rnd(20) === 0)
    sNext = sNext + ", " + makeExpr(d - 2, b);
  while (rnd(20) === 0)
    sNext = makeExpr(d - 2, b) + ", " + sNext;  return "for (" + sInit + "; " + sCond + "; " + sNext + ")";
}function makeOpaqueIdiomaticLoop(d, b)
{
  var reps = loopCount();
  var vHidden = uniqueVarName();
  return "/*oLoop*/" + forLoopHead(d, b, vHidden, reps) + " { " +
      makeStatement(d - 2, b) +
      " } ";
}function makeTransparentIdiomaticLoop(d, b)
{
  var reps = loopCount();
  var vHidden = uniqueVarName();
  var vVisible = makeNewId(d, b);
  return "/*vLoop*/" + forLoopHead(d, b, vHidden, reps) +
    " { " +
      Random.index(varBinder) + vVisible + " = " + vHidden + "; " +
      makeStatement(d - 2, b.concat([vVisible])) +
    " } ";
}function makeBranchUnstableLoop(d, b)
{
  var reps = loopCount();
  var v = uniqueVarName();
  var mod = loopModulo();
  var target = rnd(mod);
  return "/*bLoop*/" + forLoopHead(d, b, v, reps) + " { " +
    "if (" + v + " % " + mod + " == " + target + ") { " + makeStatement(d - 2, b) + " } " +
    "else { " + makeStatement(d - 2, b) + " } " +
    " } ";
}function makeTypeUnstableLoop(d, b) {
  var a = makeMixedTypeArray(d, b);
  var v = makeNewId(d, b);
  var bv = b.concat([v]);
  return "/*tLoop*/for (let " + v + " of " + a + ") { " + makeStatement(d - 2, bv) + " }";
}
function makeFunOnCallChain(d, b) {
  var s = "arguments.callee";
  while (rnd(2))
    s += ".caller";
  return s;
}
var statementMakers = Random.weighted([  
  { w: 15, v: function(d, b) { return cat([makeStatement(d - 1, b),       makeStatement(d - 1, b)      ]); } },
  { w: 15, v: function(d, b) { return cat([makeStatement(d - 1, b), "\n", makeStatement(d - 1, b), "\n"]); } },  
  { w: 1, v: function(d, b) { return cat([stripSemicolon(makeStatement(d, b)), "\n", makeStatement(d, b)]); } },
  { w: 1, v: function(d, b) { return cat([stripSemicolon(makeStatement(d, b)), "\n"                   ]); } },
  { w: 1, v: function(d, b) { return stripSemicolon(makeStatement(d, b)); } },   
  { w: 4, v: function(d, b) { var v = makeNewId(d, b); return cat([Random.index(varBinder), v, " = ", makeExpr(d, b), ";", makeStatement(d - 1, b.concat([v]))]); } },
  { w: 4, v: function(d, b) { var v = makeNewId(d, b); return cat([makeStatement(d - 1, b.concat([v])), Random.index(varBinder), v, " = ", makeExpr(d, b), ";"]); } },  
  { w: 10, v: function(d, b) { return cat([Random.index(varBinder), makeLetHead(d, b), ";", makeStatement(d - 1, b)]); } },  
  { w: 2, v: function(d, b) { return cat(["{", makeStatement(d, b), " }"]); } },
  { w: 2, v: function(d, b) { return cat(["{", makeStatement(d - 1, b), makeStatement(d - 1, b), " }"]); } },  
  { w: 2, v: function(d, b) {                          return cat([maybeLabel(), "with", "(", makeExpr(d, b), ")",                    makeStatementOrBlock(d, b)]);             } },
  { w: 2, v: function(d, b) { var v = makeNewId(d, b); return cat([maybeLabel(), "with", "(", "{", v, ": ", makeExpr(d, b), "}", ")", makeStatementOrBlock(d, b.concat([v]))]); } },  
  
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", makeExpr(d, b), "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                                                    "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v, " = ", makeExpr(d, b),                             "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeDestructuringLValue(d, b), " = ", makeExpr(d, b), "; ", makeExpr(d, b), "; ", makeExpr(d, b), ") ", makeStatementOrBlock(d, b)]); } },  
  { w: 6, v: makeTransparentIdiomaticLoop },
  { w: 6, v: makeOpaqueIdiomaticLoop },
  { w: 6, v: makeBranchUnstableLoop },
  { w: 8, v: makeTypeUnstableLoop },  
  
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeForInLHS(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                  " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeForInLHS(d, b), " in ", "(", "(", makeFunction(d, b), ")", "(", makeExpr(d, b), ")", ")", ")", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                  " in ", "(", "(", makeFunction(d, b), ")", "(", makeExpr(d, b), ")", ")", ")", makeStatementOrBlock(d, b.concat([v]))]); } },
  
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), " for ", " each", "(", Random.index(varBinderFor), makeLValue(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), " for ", " each", "(", Random.index(varBinderFor), v,                " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  
  { w: 1, v: function(d, b) {                          return "/*infloop*/" + cat([maybeLabel(), " for ", "(", Random.index(varBinderFor), makeLValue(d, b), " of ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b); return                 cat([maybeLabel(), " for ", "(", Random.index(varBinderFor), v,                " of ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },  
  
  
  
  
  
  { w: 1, v: function(d, b) {                                               return cat([maybeLabel(), "for", "(", Random.index(varBinderFor), makeId(d, b),         " = ", makeExpr(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b);                      return cat([maybeLabel(), "for", "(", Random.index(varBinderFor), v,                    " = ", makeExpr(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v]))]); } },
  { w: 1, v: function(d, b) { var v = makeNewId(d, b), w = makeNewId(d, b); return cat([maybeLabel(), "for", "(", Random.index(varBinderFor), "[", v, ", ", w, "]", " = ", makeExpr(d, b), " in ", makeExpr(d - 2, b), ") ", makeStatementOrBlock(d, b.concat([v, w]))]); } },  
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "while((", makeExpr(d, b), ") && 0)" /*don't split this, it's needed to avoid marking as infloop*/, makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { return "/*infloop*/" + cat([maybeLabel(), "while", "(", makeExpr(d, b), ")", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "do ", makeStatementOrBlock(d, b), " while((", makeExpr(d, b), ") && 0)" /*don't split this, it's needed to avoid marking as infloop*/, ";"]); } },
  { w: 1, v: function(d, b) { return "/*infloop*/" + cat([maybeLabel(), "do ", makeStatementOrBlock(d, b), " while", "(", makeExpr(d, b), ");"]); } },  
  { w: 3, v: function(d, b) { return cat([maybeLabel(), "switch", "(", makeExpr(d, b), ")", " { ", makeSwitchBody(d, b), " }"]); } },  
  { w: 2, v: function(d, b) { var v = makeNewId(d, b); return cat(["let ", "(", v, ")", " { ", makeStatement(d, b.concat([v])), " }"]); } },  
  { w: 2, v: function(d, b) { return cat(["let ", "(", makeLetHead(d, b), ")", " { ", makeStatement(d, b), " }"]); } },  
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", makeStatementOrBlock(d - 1, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b)]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", makeStatementOrBlock(d - 1, b)]); } },  
  
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", "{", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b), " else ", makeStatementOrBlock(d - 1, b), "}"]); } },
  { w: 1, v: function(d, b) { return cat([maybeLabel(), "if(", makeBoolean(d, b), ") ", "{", " if ", "(", makeExpr(d, b), ") ", makeStatementOrBlock(d - 1, b), "}", " else ", makeStatementOrBlock(d - 1, b)]); } },  
  { w: 5, v: function(d, b) { return cat([makeExpr(d, b), ";"]); } },
  { w: 5, v: function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); } },  
  { w: 6, v: function(d, b) { return makeExceptionyStatement(d - 1, b) + makeExceptionyStatement(d - 1, b); } },
  { w: 7, v: function(d, b) { return makeExceptionyStatement(d, b); } },  
  { w: 1, v: function(d, b) { return cat(["L", ": ", makeStatementOrBlock(d, b)]); } },  
  { w: 10, v: function(d, b) { return cat([makeStatement(d-2, b), "function ", makeId(d, b), "(", makeFormalArgList(d, b), ")", makeFunctionBody(d - 1, b), makeStatement(d-2, b)]); } },  
  { w: 8, v: makeNamedFunctionAndUse },  
  
  
  { w: 1, v: function(d, b) { if (rnd(200)==0) return "/*DUPTRY" + rnd(10000) + "*/" + makeStatement(d - 1, b); return ";"; } },  { w: 1, v: function(d, b) { return makeShapeyConstructorLoop(d, b); } },  
  { w: 1, v: function(d, b) { var x = makeId(d, b); return x + " = linkedList(" + x + ", " + (rnd(100) * rnd(100)) + ");";  } },  
  { w: 1, v: function(d, b) { return directivePrologue() + makeStatement(d - 1, b); } },  
  { w: 3, v: function(d, b) { return makeTestingFunctionCall(d, b); } },
  { w: 3, v: function(d, b) { return makeTestingFunctionCall(d - 1, b) + " " + makeStatement(d - 1, b); } },  
  { w: 8, v: makeTypedArrayStatements },  
  { w: 8, v: makePrintStatement },  { w: 20, v: makeRegexUseBlock },  { w: 1, v: makeRegisterStompBody },  { w: 20, v: makeUseRegressionTest },  
  
  
]);if (typeof oomTest == "function" && engine != ENGINE_SPIDERMONKEY_MOZILLA45) {
  statementMakers = statementMakers.concat([
    function(d, b) { return "oomTest(" + makeFunction(d, b-1) + ")"; },
  ]);
}
function makeUseRegressionTest(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (typeof regressionTestList != "object") {
    return "/* no regression tests found */";
  }  var maintest = regressionTestsRoot + Random.index(regressionTestList);
  var files = regressionTestDependencies(maintest);  var s = "";  if (rnd(5) == 0) {
    
    
    s += "assertEq = function(x, y) { if (x != y) { print(0); } }; ";
  }  for (var i = 0; i < files.length; ++i) {
    var file = files[i];    if (regressionTestIsEvil(read(file))) {
      continue;
    }    switch (rnd(2)) {
      case 0:
        
        s += "/* regression-test-inline */ " + inlineRegressionTest(file);
        break;
      default:
        
        s += "/* regression-test-load */ " + "load(" + simpleSource(file) + ");";
        break;
      
    }
  }
  return s;
}function regressionTestIsEvil(contents)
{
  if (contents.indexOf("SIMD") != -1) {
    
    return true;
  }
  if (contents.indexOf("print = ") != -1) {
    
    return true;
  }
  return false;
}function inlineRegressionTest(filename)
{
    const s = "/* " + filename + " */ " + read(filename) + "\n";  const noDiffTestingFunctions = [
    
    "gcparam",
    "startgc",
    "setJitCompilerOption",
    "disableSingleStepProfiling",
    "enableSingleStepProfiling",
    
    "isAsmJSCompilationAvailable",
    "isSimdAvailable", 
    "hasChild",
    "PerfMeasurement",
  ];  for (var f of noDiffTestingFunctions) {
    if (s.indexOf(f) != -1) {
      return "/*NODIFF*/ " + s;
    }
  }  return s;
}
function regressionTestDependencies(maintest)
{
  var files = [];  if (rnd(3)) {
    
    for (var i = regressionTestsRoot.length; i < maintest.length; ++i) {
      if (maintest.charAt(i) == "/" || maintest.charAt(i) == "\\") {
        var shelljs = maintest.substr(0, i + 1) + "shell.js";
        if (regressionTestList.indexOf(shelljs) != -1) {
          files.push(shelljs);
        }
      }
    }    
    if (maintest.indexOf("jit-test") != -1) {
      files.push(libdir + "prologue.js");
    }
  }  files.push(maintest);
  return files;
}
function linkedList(x, n)
{
  for (var i = 0; i < n; ++i)
    x = {a: x};
  return x;
}function makeNamedFunctionAndUse(d, b) {
  
  var funcName = uniqueVarName();
  var formalArgList = makeFormalArgList(d, b);
  var bv = formalArgList.length == 1 ? b.concat(formalArgList) : b;
  var declStatement = cat(["/*hhh*/function ", funcName, "(", formalArgList, ")", "{", makeStatement(d - 1, bv), "}"]);
  var useStatement;
  if (rnd(2)) {
    
    useStatement = cat([funcName, "(", makeActualArgList(d, b), ")", ";"]);
  } else {
    
    useStatement = "/*iii*/" + makeStatement(d - 1, b.concat([funcName]));
  }
  if (rnd(2)) {
    return declStatement + useStatement;
  } else {
    return useStatement + declStatement;
  }
}function makePrintStatement(d, b)
{
  if (rnd(2) && b.length)
    return "print(" + Random.index(b) + ");";
  else
    return "print(" + makeExpr(d, b) + ");";
}
function maybeLabel()
{
  if (rnd(4) === 1)
    return cat([Random.index(["L", "M"]), ":"]);
  else
    return "";
}
function uniqueVarName()
{
  
  var i, s = "";
  for (i = 0; i < 6; ++i)
    s += String.fromCharCode(97 + rnd(26)); 
  return s;
}function makeSwitchBody(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var haveSomething = false;
  var haveDefault = false;
  var output = "";  do {    if (!haveSomething || rnd(2)) {
            if (!haveDefault && rnd(2)) {
        output += "default: ";
        haveDefault = true;
      }
      else {
        
        
        output += "case " + (rnd(2) ? rnd(10) : makeExpr(d, b)) + ": ";
      }      haveSomething = true;
    }    
    if (rnd(2))
      output += makeStatement(d, b);    
    if (rnd(2))
      output += "break; ";    if (rnd(2))
      --d;  } while (d && rnd(5));  return output;
}function makeLittleStatement(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if (rnd(4) === 1)
    return makeStatement(d, b);  return (Random.index(littleStatementMakers))(d, b);
}var littleStatementMakers =
[
  
  function(d, b) { return cat([";"]); }, 
  function(d, b) { return cat(["{", "}"]); }, 
  function(d, b) { return cat([""]); },  
  function(d, b) { return cat(["throw ", makeExpr(d, b), ";"]); },  
  function(d, b) { return cat([Random.index(["continue", "break"]), " ", Random.index(["L", "M", "", ""]), ";"]); },  
  
  function(d, b) { return makeFunction(d, b); },  
  function(d, b) { return cat(["return ", makeExpr(d, b), ";"]); },
  function(d, b) { return "return;"; }, 
  function(d, b) { return cat(["yield ", makeExpr(d, b), ";"]); }, 
  function(d, b) { return "yield;"; },  
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat([makeExpr(d, b), ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", ";"]); },
];
function makeStatementOrBlock(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return (Random.index(statementBlockMakers))(d - 1, b);
}var statementBlockMakers = [
  function(d, b) { return makeStatement(d, b); },
  function(d, b) { return makeStatement(d, b); },
  function(d, b) { return cat(["{", makeStatement(d, b), " }"]); },
  function(d, b) { return cat(["{", makeStatement(d - 1, b), makeStatement(d - 1, b), " }"]); },
];
function makeExceptionyStatement(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;
  if (d < 1)
    return makeLittleStatement(d, b);  return (Random.index(exceptionyStatementMakers))(d, b);
}var exceptionProperties = ["constructor", "message", "name", "fileName", "lineNumber", "stack"];var exceptionyStatementMakers = [
  function(d, b) { return makeTryBlock(d, b); },  function(d, b) { return makeStatement(d, b); },
  function(d, b) { return makeLittleStatement(d, b); },  function(d, b) { return "return;"; }, 
  function(d, b) { return cat(["return ", makeExpr(d, b), ";"]); },
  function(d, b) { return cat(["yield ", makeExpr(d, b), ";"]); },
  function(d, b) { return cat(["throw ", makeId(d, b), ";"]); },
  function(d, b) { return "throw StopIteration;"; },
  function(d, b) { return "this.zzz.zzz;"; }, 
  function(d, b) { return b[b.length - 1] + "." + Random.index(exceptionProperties) + ";"; },
  function(d, b) { return makeId(d, b) + "." + Random.index(exceptionProperties) + ";"; },
  function(d, b) { return cat([makeId(d, b), " = ", makeId(d, b), ";"]); },
  function(d, b) { return cat([makeLValue(d, b), " = ", makeId(d, b), ";"]); },  
  
  function(d, b) { var v = makeNewId(d, b); return "for(let " + v + " in []);"; },
  function(d, b) { var v = makeNewId(d, b); return "for(let " + v + " in " + makeIterable(d, b) + ") " + makeExceptionyStatement(d, b.concat([v])); },
  function(d, b) { var v = makeNewId(d, b); return "for(let " + v + " of " + makeIterable(d, b) + ") " + makeExceptionyStatement(d, b.concat([v])); },  
  
  function(d, b) { return "with({}) "   + makeExceptionyStatement(d, b);         },
  function(d, b) { return "with({}) { " + makeExceptionyStatement(d, b) + " } "; },
  function(d, b) { var v = makeNewId(d, b); return "let(" + v + ") { " + makeExceptionyStatement(d, b.concat([v])) + "}"; },
  function(d, b) { var v = makeNewId(d, b); return "let(" + v + ") ((function(){" + makeExceptionyStatement(d, b.concat([v])) + "})());"; },
  function(d, b) { return "let(" + makeLetHead(d, b) + ") { " + makeExceptionyStatement(d, b) + "}"; },
  function(d, b) { return "let(" + makeLetHead(d, b) + ") ((function(){" + makeExceptionyStatement(d, b) + "})());"; },  
/*
  
  function(d, b) { return "(function () { try { yield " + makeExpr(d, b) + " } finally { " + makeStatement(d, b) + " } })().next()"; },  function(d, b) { return "(function () { try { yield " + makeExpr(d, b) + " } finally { " + makeStatement(d, b) + " } })()"; },
  function(d, b) { return "(function () { try { yield " + makeExpr(d, b) + " } finally { " + makeStatement(d, b) + " } })"; },
  function(d, b) {
    return "function gen() { try { yield 1; } finally { " + makeStatement(d, b) + " } } var i = gen(); i.next(); i = null;";
  }*/
];function makeTryBlock(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  
  
    d = d - rnd(3);
  var s = cat(["try", " { ", makeExceptionyStatement(d, b), " } "]);  var numCatches = 0;  while(rnd(3) === 0) {
    
    ++numCatches;
    var catchId = makeId(d, b);
    var catchBlock = makeExceptionyStatement(d, b.concat([catchId]));
    if (rnd(2))
      s += cat(["catch", "(", catchId, " if ",                 makeExpr(d, b),                    ")", " { ", catchBlock, " } "]);
    else
      s += cat(["catch", "(", catchId, " if ", "(function(){", makeExceptionyStatement(d, b), "})())", " { ", catchBlock, " } "]);
  }  if (rnd(2)) {
    
    ++numCatches;
    var catchId = makeId(d, b);
    var catchBlock = makeExceptionyStatement(d, b.concat([catchId]));
    s +=   cat(["catch", "(", catchId,                                                          ")", " { ", catchBlock, " } "]);
  }  if (numCatches == 0 || rnd(2) === 1) {
    
    s += cat(["finally", " { ", makeExceptionyStatement(d, b), " } "]);
  }  return s;
}
function makeExpr(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d <= 0 || (rnd(7) === 1))
    return makeTerm(d - 1, b);  if (rnd(6) === 1 && b.length)
    return Random.index(b);  if (rnd(10) === 1)
    return makeImmediateRecursiveCall(d, b);  d = rnd(d);   var expr = (Random.index(exprMakers))(d, b);  if (rnd(4) === 1)
    return "(" + expr + ")";
  else
    return expr;
}var binaryOps = [
  
  " * ", " / ", " % ", " + ", " - ", " << ", " >> ", " >>> ", " < ", " > ", " <= ", " >= ", " instanceof ", " in ", " == ", " != ", " === ", " !== ",
  " & ", " | ", " ^ ", " && ", " || ", " = ", " *= ", " /= ", " %= ", " += ", " -= ", " <<= ", " >>= ", " >>>= ", " &= ", " ^= ", " |= ", " , ", " ** ", " **= "
];var leftUnaryOps = [
  "!", "+", "-", "~",
  "void ", "typeof ", "delete ",
  "new ", 
  "yield " 
];var incDecOps = [
  "++", "--",
];
var specialProperties = [
  "__iterator__", "__count__",
  "__parent__", "__proto__", "constructor", "prototype",
  "wrappedJSObject",
  "arguments", "caller", "callee",
  "toString", "toSource", "valueOf",
  "call", "apply", 
  "length",
  "0", "1",
];
/*
function addPropertyName(p)
{
  p = "" + p;
  if (
      p != "floor" &&
      p != "random" &&
      p != "parent" && 
      true) {
    print("Adding: " + p);
    allPropertyNames.push(p);
  }
}
*/var exprMakers =
[
  
  function(d, b) { return cat([makeLValue(d, b), Random.index(incDecOps)]); },
  function(d, b) { return cat([Random.index(incDecOps), makeLValue(d, b)]); },  
  function(d, b) { return cat([Random.index(leftUnaryOps), makeExpr(d, b)]); },  
  function(d, b) { var id = makeId(d, b); return cat(["/*UUV1*/", "(", id, ".", Random.index(allMethodNames), " = ", makeFunction(d, b), ")"]); },
  function(d, b) { var id = makeId(d, b); return cat(["/*UUV2*/", "(", id, ".", Random.index(allMethodNames), " = ", id, ".", Random.index(allMethodNames), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", Random.index(allMethodNames), "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "valueOf", "(", uneval("number"), ")"]); },  
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), Random.index(binaryOps), makeExpr(d, b)]); },
  function(d, b) { return cat([makeId(d, b),   Random.index(binaryOps), makeId(d, b)]); },
  function(d, b) { return cat([makeId(d, b),   Random.index(binaryOps), makeId(d, b)]); },
  function(d, b) { return cat([makeId(d, b),   Random.index(binaryOps), makeId(d, b)]); },  
  function(d, b) { return cat([makeExpr(d, b), " ? ", makeExpr(d, b), " : ", makeExpr(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b), " ? ", makeExpr(d, b), " : ", makeExpr(d, b)]); },  
  function(d, b) { return cat(["yield ", makeExpr(d, b)]); },
  function(d, b) { return cat(["(", "yield ", makeExpr(d, b), ")"]); },  
  
  
  
  function(d, b) { return cat([makeArrayLiteral(d, b), ".", Random.index(["map", "filter", "some", "sort"]) ]); },
  function(d, b) { return cat([makeArrayLiteral(d, b), ".", Random.index(["map", "filter", "some", "sort"]), "(", makeFunction(d, b), ", ", makeExpr(d, b), ")"]); },
  function(d, b) { return cat([makeArrayLiteral(d, b), ".", Random.index(["map", "filter", "some", "sort"]), "(", makeFunction(d, b), ")"]); },  
  function(d, b) { return cat(["'fafafa'", ".", "replace", "(", "/", "a", "/", "g", ", ", makeFunction(d, b), ")"]); },  
  function(d, b) { return cat(["[", makeExpr(d, b), "]"]); },
  function(d, b) { return cat(["(", "{", makeId(d, b), ": ", makeExpr(d, b), "}", ")"]); },  
  function(d, b) { return makeFunction(d, b); },
  function(d, b) { return makeFunction(d, b) + ".prototype"; },
  function(d, b) { return cat(["(", makeFunction(d, b), ")", "(", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return cat([     makeExpr(d, b),          "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat(["(", makeExpr(d, b),     ")", "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat([     makeFunction(d, b),      "(", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return cat(["(", makeFunction(d, b), ")", ".", "call", "(", makeExpr(d, b), ", ", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return cat(["new ",      makeExpr(d, b),          "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat(["new ", "(", makeExpr(d, b), ")",     "(", makeActualArgList(d, b), ")"]); },  function(d, b) { return cat(["new ",      makeFunction(d, b),      "(", makeActualArgList(d, b), ")"]); },
  function(d, b) { return cat(["new ", "(", makeFunction(d, b), ")", "(", makeActualArgList(d, b), ")"]); },  
  function(d, b) { return stripSemicolon(makeLittleStatement(d, b)); },
  function(d, b) { return ""; },  
  function(d, b) { var v = makeNewId(d, b); return cat(["let ", "(", v,                            ") ", makeExpr(d - 1, b.concat([v]))]); },
  function(d, b) { var v = makeNewId(d, b); return cat(["let ", "(", v, " = ", makeExpr(d - 1, b), ") ", makeExpr(d - 1, b.concat([v]))]); },
  function(d, b) {                          return cat(["let ", "(", makeLetHead(d, b),            ") ", makeExpr(d, b)]); },  
  function(d, b) { return cat([" /* Comment */", makeExpr(d, b)]); },
  function(d, b) { return cat(["\n", makeExpr(d, b)]); }, 
  function(d, b) { return cat([makeExpr(d, b), "\n"]); },  
  function(d, b) { return cat([makeLValue(d, b)]); },  
  function(d, b) { return cat([     makeLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat([     makeLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat(["(", makeLValue(d, b),      " = ", makeExpr(d, b), ")"]); },
  function(d, b) { return cat(["(", makeLValue(d, b), ")", " = ", makeExpr(d, b)     ]); },  
  function(d, b) { return cat([     makeDestructuringLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat([     makeDestructuringLValue(d, b),      " = ", makeExpr(d, b)     ]); },
  function(d, b) { return cat(["(", makeDestructuringLValue(d, b),      " = ", makeExpr(d, b), ")"]); },
  function(d, b) { return cat(["(", makeDestructuringLValue(d, b), ")", " = ", makeExpr(d, b)     ]); },  
  function(d, b) { return cat([makeDestructuringLValue(d, b), " = ", makeDestructuringLValue(d, b)]); },  
  function(d, b) { return cat([makeLValue(d, b), Random.index(["|=", "%=", "+=", "-="]), makeExpr(d, b)]); },  
  function(d, b) { return cat([makeExpr(d, b), ".", "watch", "(", makePropertyName(d, b), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "unwatch", "(", makePropertyName(d, b), ")"]); },  
  function(d, b) { return cat(["Object.defineProperty", "(", makeId(d, b), ", ", makePropertyName(d, b), ", ", makePropertyDescriptor(d, b), ")"]); },  
  function(d, b) { return cat([makeExpr(d, b), ".", "__defineGetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "__defineSetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat(["this", ".", "__defineGetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },
  function(d, b) { return cat(["this", ".", "__defineSetter__", "(", uneval(makeId(d, b)), ", ", makeFunction(d, b), ")"]); },  
  function(d, b) { return cat(["(", "{", makeObjLiteralPart(d, b), " }", ")"]); },
  function(d, b) { return cat(["(", "{", makeObjLiteralPart(d, b), ", ", makeObjLiteralPart(d, b), " }", ")"]); },  
  function(d, b) { return "(p={}, (p.z = " + makeExpr(d, b) + ")())"; },  
  
  
  function(d, b) { return cat([makeExpr(d, b), ".", "throw", "(", makeExpr(d, b), ")"]); },
  function(d, b) { return cat([makeExpr(d, b), ".", "yoyo",   "(", makeExpr(d, b), ")"]); },  
  
  function(d, b) { return makeExpr(d, b) + ".eval(" + uneval(makeScriptForEval(d, b)) + ")"; },
  function(d, b) { return "eval(" + uneval(makeScriptForEval(d, b)) + ")"; },
  function(d, b) { return "eval(" + uneval(makeScriptForEval(d, b)) + ", " + makeExpr(d, b) + ")"; },  
  function(d, b) { return "(uneval(" + makeExpr(d, b) + "))"; },  
  function(d, b) { return "new " + Random.index(constructors) + "(" + makeActualArgList(d, b) + ")"; },
  function(d, b) { return          Random.index(constructors) + "(" + makeActualArgList(d, b) + ")"; },  
  function (d, b) { return "Math." + Random.index(unaryMathFunctions) + "(" + makeExpr(d, b)   + ")"; },
  function (d, b) { return "Math." + Random.index(unaryMathFunctions) + "(" + makeNumber(d, b) + ")"; },  
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeExpr(d, b)   + ", " + makeExpr(d, b)   + ")"; },
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeExpr(d, b)   + ", " + makeNumber(d, b) + ")"; },
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeNumber(d, b) + ", " + makeExpr(d, b)   + ")"; },
  function (d, b) { return "Math." + Random.index(binaryMathFunctions) + "(" + makeNumber(d, b) + ", " + makeNumber(d, b) + ")"; },  
  function(d, b) { return makeId(d, b) + " = " + "Proxy.create(" + makeProxyHandler(d, b) + ", " + makeExpr(d, b) + ")"; },
  function(d, b) { return makeId(d, b) + " = " + "Proxy.createFunction(" + makeProxyHandler(d, b) + ", " + makeFunction(d, b) + ")"; },
  function(d, b) { return makeId(d, b) + " = " + "Proxy.createFunction(" + makeProxyHandler(d, b) + ", " + makeFunction(d, b) + ", " + makeFunction(d, b) + ")"; },  function(d, b) { return cat(["delete", " ", makeId(d, b), ".", makeId(d, b)]); },  
  function(d, b) { return "(void options('strict_mode'))"; },  
  function(d, b) { return "(void options('strict'))"; },  
  function(d, b) { return "(void version(" + Random.index([170, 180, 185]) + "))"; },  
  
  
  function(d, b) { return "(void shapeOf(" + makeExpr(d, b) + "))"; },
  function(d, b) { return "intern(" + makeExpr(d, b) + ")"; },
  function(d, b) { return "allocationMarker()"; },
  function(d, b) { return "timeout(1800)"; }, 
  function(d, b) { return "(makeFinalizeObserver('tenured'))"; },
  function(d, b) { return "(makeFinalizeObserver('nursery'))"; },  makeRegexUseExpr,
  makeShapeyValue,
  makeIterable,
  function(d, b) { return makeMathExpr(d + rnd(3), b); },
];
var fuzzTestingFunctions = fuzzTestingFunctionsCtor(!jsshell, fuzzTestingFunctionArg, fuzzTestingFunctionArg);
function fuzzTestingFunctionArg(d, b) { return "this"; }function makeTestingFunctionCall(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var callStatement = Random.index(fuzzTestingFunctions.testingFunctions)(d, b);  
  
  var callBlock = "{ void 0; " + callStatement + " }";  if (jsshell && rnd(5) === 0) {
    
    
    
    
    
    
    
    
    
    
    
    
    var cond = (rnd(2) ? "!" : "") + "isAsmJSCompilationAvailable()";
    return "{ if (" + cond + ") " + callBlock + " void 0; }";
  }  return callBlock;
}
if (typeof evalcx == "function") {
  exprMakers = exprMakers.concat([
    function(d, b) { return makeGlobal(d, b); },
    function(d, b) { return "evalcx(" + uneval(makeScriptForEval(d, b)) + ", " + makeExpr(d, b) + ")"; },
    function(d, b) { return "evalcx(" + uneval(makeScriptForEval(d, b)) + ", " + makeGlobal(d, b) + ")"; },
  ]);
}
if (typeof XPCNativeWrapper == "function") {
  exprMakers = exprMakers.extend([
    function(d, b) { return "new XPCNativeWrapper(" + makeExpr(d, b) + ")"; },
    function(d, b) { return "new XPCSafeJSObjectWrapper(" + makeExpr(d, b) + ")"; },
  ]);
}function makeNewGlobalArg(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  var propStrs = [];
  if (rnd(2))
    propStrs.push("sameZoneAs: " + makeExpr(d - 1, b));
  if (rnd(2))
    propStrs.push("cloneSingletons: " + makeBoolean(d - 1, b));
  if (rnd(2))
    propStrs.push("disableLazyParsing: " + makeBoolean(d - 1, b));
  return "{ " + propStrs.join(", ") + " }";
}function makeGlobal(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(10))
    return "this";  var gs;
  switch(rnd(4)) {
    case 0:  gs = "evalcx('')"; break;
    case 1:  gs = "evalcx('lazy')"; break;
    default: gs = "newGlobal(" + makeNewGlobalArg(d - 1, b) + ")"; break;
  }  if (rnd(2))
    gs = "fillShellSandbox(" + gs + ")";  return gs;
}if (xpcshell) {
  exprMakers = exprMakers.concat([
    function(d, b) { var n = rnd(4); return "newGeckoSandbox(" + n + ")"; },
    function(d, b) { var n = rnd(4); return "s" + n + " = newGeckoSandbox(" + n + ")"; },
    
    function(d, b) { var n = rnd(4); return "evalInSandbox(" + uneval(makeStatement(d, b)) + ", newGeckoSandbox(" + n + "))"; },
    function(d, b) { var n = rnd(4); return "evalInSandbox(" + uneval(makeStatement(d, b)) + ", s" + n + ")"; },
    function(d, b) { return "evalInSandbox(" + uneval(makeStatement(d, b)) + ", " + makeExpr(d, b) + ")"; },
    function(d, b) { return "(Components.classes ? quit() : gc()); }"; },
  ]);
}
function makeShapeyConstructor(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);
  var argName = uniqueVarName();
  var t = rnd(4) ? "this" : argName;
  var funText = "function shapeyConstructor(" + argName + "){" + directivePrologue();
  var bp = b.concat([argName]);  var nPropNames = rnd(6) + 1;
  var propNames = [];
  for (var i = 0; i < nPropNames; ++i) {
    propNames[i] = makePropertyName(d, b);
  }  var nStatements = rnd(11);
  for (var i = 0; i < nStatements; ++i) {
    var propName = Random.index(propNames);
    var tprop = t + "[" + propName + "]";
    if (rnd(5) === 0) {
      funText += "if (" + (rnd(2) ? argName : makeExpr(d, bp)) + ") ";
    }
    switch(rnd(8)) {
      case 0:  funText += "delete " + tprop + ";"; break;
      case 1:  funText += "Object.defineProperty(" + t + ", " + (rnd(2) ? propName : makePropertyName(d, b)) + ", " + makePropertyDescriptor(d, bp) + ");"; break;
      case 2:  funText += "{ " + makeStatement(d, bp) + " } "; break;
      case 3:  funText += tprop + " = " + makeExpr(d, bp)        + ";"; break;
      case 4:  funText += tprop + " = " + makeFunction(d, bp)    + ";"; break;
      case 5:  funText += "for (var ytq" + uniqueVarName() + " in " + t + ") { }"; break;
      case 6:  funText += "Object." + Random.index(["preventExtensions","seal","freeze"]) + "(" + t + ");"; break;
      default: funText += tprop + " = " + makeShapeyValue(d, bp) + ";"; break;
    }
  }
  funText += "return " + t + "; }";
  return funText;
}
var propertyNameMakers = Random.weighted([
  { w: 1,  v: function(d, b) { return makeExpr(d - 1, b); } },
  { w: 1,  v: function(d, b) { return maybeNeg() + rnd(20); } },
  { w: 1,  v: function(d, b) { return '"' + maybeNeg() + rnd(20) + '"'; } },
  { w: 1,  v: function(d, b) { return "new String(" + '"' + maybeNeg() + rnd(20) + '"' + ")"; } },
  { w: 5,  v: function(d, b) { return simpleSource(Random.index(specialProperties)); } },
  { w: 1,  v: function(d, b) { return simpleSource(makeId(d - 1, b)); } },
  { w: 5,  v: function(d, b) { return simpleSource(Random.index(allMethodNames)); } },
]);function maybeNeg() { return rnd(5) ? "" : "-"; }function makePropertyName(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return (Random.index(propertyNameMakers))(d, b);
}function makeShapeyConstructorLoop(d, b)
{
  var a = makeIterable(d, b);
  var v = makeNewId(d, b);
  var v2 = uniqueVarName(d, b);
  var bvv = b.concat([v, v2]);
  return makeShapeyConstructor(d - 1, b) +
    "/*tLoopC*/for (let " + v + " of " + a + ") { " +
     "try{" +
       "let " + v2 + " = " + Random.index(["new ", ""]) + "shapeyConstructor(" + v + "); print('EETT'); " +
       
       makeStatement(d - 2, bvv) +
     "}catch(e){print('TTEE ' + e); }" +
  " }";
}
function makePropertyDescriptor(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var s = "({";  switch(rnd(3)) {
  case 0:
    
    if (rnd(2)) s += "value: " + makeExpr(d, b) + ", ";
    if (rnd(2)) s += "writable: " + makeBoolean(d, b) + ", ";
    break;
  case 1:
    
    if (rnd(2)) s += "get: " + makeFunction(d, b) + ", ";
    if (rnd(2)) s += "set: " + makeFunction(d, b) + ", ";
    break;
  default:
  }  if (rnd(2)) s += "configurable: " + makeBoolean(d, b) + ", ";
  if (rnd(2)) s += "enumerable: " + makeBoolean(d, b) + ", ";  
  if (s.length > 2)
    s = s.substr(0, s.length - 2);  s += "})";
  return s;
}function makeBoolean(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);
  switch(rnd(4)) {
    case 0:   return "true";
    case 1:   return "false";
    case 2:   return makeExpr(d - 2, b);
    default:  var m = loopModulo(); return "(" + Random.index(b) + " % " + m + Random.index([" == ", " != "]) + rnd(m) + ")";
  }
}
function makeObjLiteralPart(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(8))
  {
    
    
    
    case 2: return cat([" get ", makeObjLiteralName(d, b), maybeName(d, b), "(", makeFormalArgList(d - 1, b), ")", makeFunctionBody(d, b)]);
    case 3: return cat([" set ", makeObjLiteralName(d, b), maybeName(d, b), "(", makeFormalArgList(d - 1, b), ")", makeFunctionBody(d, b)]);    case 4: return "/*toXFun*/" + cat([Random.index(["toString", "toSource", "valueOf"]), ": ", makeToXFunction(d - 1, b)]);    default: return cat([makeObjLiteralName(d, b), ": ", makeExpr(d, b)]);
  }
}function makeToXFunction(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(4)) {
    case 0:  return "function() { return " + makeExpr(d, b) + "; }";
    case 1:  return "function() { return this; }";
    case 2:  return makeEvilCallback(d, b);
    default: return makeFunction(d, b);
  }
}
function makeObjLiteralName(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(6))
  {
    case 0:  return simpleSource(makeNumber(d, b)); 
    case 1:  return makeNumber(d, b);
    case 2:  return Random.index(allPropertyNames);
    case 3:  return Random.index(specialProperties);
    default: return makeId(d, b);
  }
}
function makeFunction(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if(rnd(5) === 1)
    return makeExpr(d, b);  if (rnd(4) === 1)
    return Random.index(builtinFunctions);  return (Random.index(functionMakers))(d, b);
}
function maybeName(d, b)
{
  if (rnd(2) === 0)
    return " " + makeId(d, b) + " ";
  else
    return "";
}function directivePrologue()
{
  var s = "";
  if (rnd(3) === 0)
    s += '"use strict"; ';
  if (rnd(30) === 0)
    s += '"use asm"; ';
  return s;
}function makeFunctionBody(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch(rnd(5)) {
    case 0:  return cat([" { ", directivePrologue(), makeStatement(d - 1, b),   " } "]);
    case 1:  return cat([" { ", directivePrologue(), "return ", makeExpr(d, b), " } "]);
    case 2:  return cat([" { ", directivePrologue(), "yield ",  makeExpr(d, b), " } "]);
    case 3:  return '"use asm"; ' + asmJSInterior([]);
    default: return makeExpr(d, b); 
  }
}
var functionMakers = [
    makeFunOnCallChain,
  makeMathFunction,
  makeMathyFunRef,  
  function(d, b) { var v = makeNewId(d, b); return cat(["function", " ", maybeName(d, b), "(", v,                       ")", makeFunctionBody(d, b.concat([v]))]); },
  function(d, b) {                          return cat(["function", " ", maybeName(d, b), "(", makeFormalArgList(d, b), ")", makeFunctionBody(d, b)]); },  
  function(d, b) { var v = makeNewId(d, b); return cat([     v,                            " => ", makeFunctionBody(d, b.concat([v]))]); },  
  function(d, b) {                          return cat(["(", makeFormalArgList(d, b), ")", " => ", makeFunctionBody(d, b)]); },  
  function(d, b) { return "function(q) { " + directivePrologue() + "return q; }"; },
  function(d, b) { return "q => q"; },  
  function(d, b) { return "function(y) { " + directivePrologue() + makeStatement(d, b.concat(["y"])) + " }"; },  
  function(d, b) { return "function(y) { " + directivePrologue() + "return " + makeExpr(d, b.concat(["y"])) + " }"; },  
  function(d, b) { return "function(y) { " + directivePrologue() + "yield y; " + makeStatement(d, b.concat(["y"])) + "; yield y; }"; },  
  function(d, b) { return "(1 for (x in []))"; },  
  function(d, b) { return "/*wrap1*/(function(){ " + directivePrologue() + makeStatement(d, b) + "return " + makeFunction(d, b) + "})()"; },  
  function(d, b) { var v1 = uniqueVarName(); var v2 = uniqueVarName(); return "/*wrap2*/(function(){ " + directivePrologue() + "var " + v1 + " = " + makeExpr(d, b) + "; var " + v2 + " = " + makeFunction(d, b.concat([v1])) + "; return " + v2 + ";})()"; },  
  function(d, b) { var v1 = uniqueVarName(); var v2 = uniqueVarName(); return "/*wrap3*/(function(){ " + directivePrologue() + "var " + v1 + " = " + makeExpr(d, b) + "; (" + makeFunction(d, b.concat([v1])) + ")(); })"; },  
  function(d, b) { return "(" + makeFunction(d-1, b) + ").apply"; },
  function(d, b) { return "(" + makeFunction(d-1, b) + ").call"; },  
  function(d, b) { return "(" + makeFunction(d-1, b) + ").bind"; },
  function(d, b) { return "(" + makeFunction(d-1, b) + ").bind(" + makeActualArgList(d, b) + ")"; },  
  function(d, b) { return cat([makeExpr(d, b), ".", Random.index(allMethodNames)]); },  
  function(d, b) { return "eval"; }, 
  function(d, b) { return "(let (e=eval) e)"; },
  function(d, b) { return "new Function"; }, 
  function(d, b) { return "(new Function(" + uneval(makeStatement(d, b)) + "))"; },
  function(d, b) { return "Function"; }, 
  function(d, b) { return "decodeURI"; },
  function(d, b) { return "decodeURIComponent"; },
  function(d, b) { return "encodeURI"; },
  function(d, b) { return "encodeURIComponent"; },
  function(d, b) { return "neuter"; },
  function(d, b) { return "objectEmulatingUndefined"; }, 
  function(d, b) { return makeProxyHandlerFactory(d, b); },
  function(d, b) { return makeShapeyConstructor(d, b); },
  function(d, b) { return Random.index(typedArrayConstructors); },
  function(d, b) { return Random.index(constructors); },
];if (typeof XPCNativeWrapper == "function") {
  functionMakers = functionMakers.concat([
    function(d, b) { return "XPCNativeWrapper"; },
    function(d, b) { return "XPCSafeJSObjectWrapper"; },
  ]);
}if (typeof oomTest == "function" && engine != ENGINE_SPIDERMONKEY_MOZILLA45) {
  functionMakers = functionMakers.concat([
    function(d, b) { return "oomTest"; }
  ]);
}var typedArrayConstructors = [
  "Int8Array",
  "Uint8Array",
  "Int16Array",
  "Uint16Array",
  "Int32Array",
  "Uint32Array",
  "Float32Array",
  "Float64Array",
  "Uint8ClampedArray"
];function makeTypedArrayStatements(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 0) return "";  var numViews = rnd(d) + 1;
  var numExtraStatements = rnd(d) + 1;
  var buffer = uniqueVarName();
  var bufferSize = (1 + rnd(2)) * (1 + rnd(2)) * (1 + rnd(2)) * rnd(5);
  var statements = "var " + buffer + " = new " + arrayBufferType() + "(" + bufferSize + "); ";
  var bv = b.concat([buffer]);
  for (var j = 0; j < numViews; ++j) {
    var view = buffer + "_" + j;
    var type = Random.index(typedArrayConstructors);
    statements += "var " + view + " = new " + type + "(" + buffer + "); ";
    bv.push(view);
    var view_0 = view + "[0]";
    bv.push(view_0);
    if (rnd(3) === 0)
      statements += "print(" + view_0 + "); ";
    if (rnd(3))
      statements += view_0 + " = " + makeNumber(d - 2, b) + "; ";
    bv.push(view + "[" + rnd(11) + "]");
  }
  for (var j = 0; j < numExtraStatements; ++j) {
    statements += makeStatement(d - numExtraStatements, bv);
  }
  return statements;
}function makeNumber(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var signStr = rnd(2) ? "-" : "";  switch(rnd(70)) {
    case 0:  return makeExpr(d - 2, b);
    case 1:  return signStr + "0";
    case 2:  return signStr + (rnd(1000) / 1000);
    case 3:  return signStr + (rnd(0xffffffff) / 2);
    case 4:  return signStr + rnd(0xffffffff);
    case 5:  return Random.index(["0.1", ".2", "3", "1.3", "4.", "5.0000000000000000000000", "1.2e3", "1e81", "1e+81", "1e-81", "1e4", "0", "-0", "(-0)", "-1", "(-1)", "0x99", "033", "3.141592653589793", "3/0", "-3/0", "0/0", "0x2D413CCC", "0x5a827999", "0xB504F332", "(0x50505050 >> 1)", "0x80000000"]);
    case 6:  return signStr + (Math.pow(2, rnd(66)) + (rnd(3) - 1));
    default: return signStr + rnd(30);
  }
}
function makeLetHead(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var items = (d > 0 || rnd(2) === 0) ? rnd(10) + 1 : 1;
  var result = "";  for (var i = 0; i < items; ++i) {
    if (i > 0)
      result += ", ";
    result += makeLetHeadItem(d - i, b);
  }  return result;
}function makeLetHeadItem(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if (d < 0 || rnd(2) === 0)
    return rnd(2) ? uniqueVarName() : makeId(d, b);
  else if (rnd(5) === 0)
    return makeDestructuringLValue(d, b) + " = " + makeExpr(d, b);
  else
    return makeId(d, b) + " = " + makeExpr(d, b);
}
function makeActualArgList(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var nArgs = rnd(3);  if (nArgs == 0)
    return "";  var argList = makeExpr(d, b);  for (var i = 1; i < nArgs; ++i)
    argList += ", " + makeExpr(d - i, b);  return argList;
}function makeFormalArgList(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var argList = [];  var nArgs = rnd(5) ? rnd(3) : rnd(100);
  for (var i = 0; i < nArgs; ++i) {
    argList.push(makeFormalArg(d - i, b));
  }  if (rnd(5) === 0) {
    
    argList.push("..." + makeId(d, b));
  }  return argList.join(", ");
}function makeFormalArg(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(8) === 1)
    return makeDestructuringLValue(d, b);  return makeId(d, b) + (rnd(5) ? "" : " = " + makeExpr(d, b));
}
function makeNewId(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return Random.index(["a", "b", "c", "d", "e", "w", "x", "y", "z"]);
}function makeId(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(3) === 1 && b.length)
    return Random.index(b);  switch(rnd(200))
  {
  case 0:
    return makeTerm(d, b);
  case 1:
    return makeExpr(d, b);
  case 2: case 3: case 4: case 5:
    return makeLValue(d, b);
  case 6: case 7:
    return makeDestructuringLValue(d, b);
  case 8: case 9: case 10:
    
    
    return Random.index(["get", "set", "getter", "setter", "delete", "let", "yield", "of"]);
  case 11: case 12: case 13:
    return "this." + makeId(d, b);
  case 14: case 15: case 16:
    return makeObjLiteralName(d - 1, b);
  case 17: case 18:
    return makeId(d - 1, b);
  case 19:
    return " "; 
  case 20:
    return "this";
  }  return Random.index(["a", "b", "c", "d", "e", "w", "x", "y", "z",
                 "window", "eval", "\u3056", "NaN",                  ]);    
  
}
function makeComprehension(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 0)
    return "";  switch(rnd(7)) {
  case 0:
    return "";
  case 1:
    return cat([" for ",          "(", makeForInLHS(d, b), " in ", makeExpr(d - 2, b),     ")"]) + makeComprehension(d - 1, b);
  
  case 2:
    return cat([" for ", "each ", "(", makeId(d, b),       " in ", makeExpr(d - 2, b),     ")"]) + makeComprehension(d - 1, b);
  case 3:
    return cat([" for ", "each ", "(", makeId(d, b),       " in ", makeIterable(d - 2, b), ")"]) + makeComprehension(d - 1, b);
  case 4:
    return cat([" for ",          "(", makeId(d, b),       " of ", makeExpr(d - 2, b),     ")"]) + makeComprehension(d - 1, b);
  case 5:
    return cat([" for ",          "(", makeId(d, b),       " of ", makeIterable(d - 2, b), ")"]) + makeComprehension(d - 1, b);
  default:
    return cat([" if ", "(", makeExpr(d - 2, b), ")"]); 
  }
}function makeForInLHS(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);
  return makeLValue(d, b);
}
function makeLValue(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d <= 0 || (rnd(2) === 1))
    return makeId(d - 1, b);  d = rnd(d);   return (Random.index(lvalueMakers))(d, b);
}
var lvalueMakers = [
  
  function(d, b) { return cat([makeId(d, b)]); },  
  function(d, b) { return cat(["(", makeLValue(d, b), ")"]); },  
  function(d, b) { return makeDestructuringLValue(d, b); },
  function(d, b) { return "(" + makeDestructuringLValue(d, b) + ")"; },  
  function(d, b) { return cat([makeId(d, b), "(", makeExpr(d, b), ")"]); },
  function(d, b) { return cat(["(", makeExpr(d, b), ")", "(", makeExpr(d, b), ")"]); },  
  function(d, b) { return Random.index(builtinProperties); },
  function(d, b) { return Random.index(builtinObjectNames); },  
  function(d, b) { return "arguments"; },
  function(d, b) { return cat(["arguments", "[", makePropertyName(d, b), "]"]); },
  function(d, b) { return makeFunOnCallChain(d, b) + ".arguments"; },   
  function(d, b) { return cat([makeExpr(d, b),  ".", makeId(d, b)]); },
  function(d, b) { return cat([makeExpr(d, b),  ".", "__proto__"]); },
  function(d, b) { return cat([makeExpr(d, b), "[", makePropertyName(d, b), "]"]); },  
  function(d, b) { return "this.zzz.zzz"; },  
  function(d, b) { return makeExpr(d, b); },
];
function makeDestructuringLValue(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  d = d - 1;  if (d < 0 || rnd(4) === 1)
    return makeId(d, b);  if (rnd(6) === 1)
    return makeLValue(d, b);  return (Random.index(destructuringLValueMakers))(d, b);
}var destructuringLValueMakers = [
  
  function(d, b)
  {
    var len = rnd(d, b);
    if (len == 0)
      return "[]";    var Ti = [];
    Ti.push("[");
    Ti.push(maybeMakeDestructuringLValue(d, b));
    for (var i = 1; i < len; ++i) {
      Ti.push(", ");
      Ti.push(maybeMakeDestructuringLValue(d, b));
    }    Ti.push("]");    return cat(Ti);
  },  
  function(d, b)
  {
    var len = rnd(d, b);
    if (len == 0)
      return "{}";
    var Ti = [];
    Ti.push("{");
    for (var i = 0; i < len; ++i) {
      if (i > 0)
        Ti.push(", ");
      Ti.push(makeId(d, b));
      if (rnd(3)) {
        Ti.push(": ");
        Ti.push(makeDestructuringLValue(d, b));
      } 
    }
    Ti.push("}");    return cat(Ti);
  }
];
function maybeMakeDestructuringLValue(d, b)
{
  if (rnd(2) === 0)
    return "";  return makeDestructuringLValue(d, b);
}function makeTerm(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return (Random.index(termMakers))(d, b);
}var termMakers = [
  
  function(d, b) { return makeId(d, b); },  
  function(d, b) { return Random.index([
    
    "[]", "[1]", "[[]]", "[[1]]", "[,]", "[,,]", "[1,,]",
    
    "{}", "({})", "({a1:1})",
    
    "[z1]", "[z1,,]", "[,,z1]",
    
    "({a2:z2})",
    "function(id) { return id }",
    "function ([y]) { }",
    "(function ([y]) { })()",    "arguments",
    "Math",
    "this",
    "length",    '"\u03A0"', 
    ]);
  },
  makeNumber,
  function(d, b) { return Random.index([ "true", "false", "undefined", "null"]); },
  function(d, b) { return Random.index([ "this", "window" ]); },
  function(d, b) { return Random.index([" \"\" ", " '' "]); },
  randomUnitStringLiteral, 
  function(d, b) { return Random.index([" /x/ ", " /x/g "]); },
  makeRegex,
];function randomUnitStringLiteral()
{
  var s = "\"\\u";
  for (var i = 0; i < 4; ++i) {
    s += "0123456789ABCDEF".charAt(rnd(16));
  }
  s += "\"";
  return s;
}
function maybeMakeTerm(d, b)
{
  if (rnd(2))
    return makeTerm(d - 1, b);
  else
    return "";
}
function makeCrazyToken()
{
  if (rnd(3) === 0) {
    return String.fromCharCode(32 + rnd(128 - 32));
  }
  if (rnd(6) === 0) {
    return String.fromCharCode(rnd(65536));
  }  return Random.index([    
   "//", UNTERMINATED_COMMENT, (UNTERMINATED_COMMENT + "\n"), "/*\n*/", 
  "[", "]",
  "{", "}",
  "(", ")",  
  "!", "@", "%", "^", "*", "**", "|", ":", "?", "'", "\"", ",", ".", "/",
  "~", "_", "+", "=", "-", "++", "--", "+=", "%=", "|=", "-=",
  "...", "=>",  
  " in ", " instanceof ", " let ", " new ", " get ", " for ", " if ", " else ", " else if ", " try ", " catch ", " finally ", " export ", " import ", " void ", " with ",
  " default ", " goto ", " case ", " switch ", " do ", " /*infloop*/while ", " return ", " yield ", " break ", " continue ", " typeof ", " var ", " const ",  
  " package ",  
  " enum ", 
  " debugger ", 
  " super ",   " this ", 
  " null ", 
  " undefined ", 
  "\n", 
  "\r",
  "\u2028", 
  "\u2029", 
  "<" + "!" + "--", 
  "--" + ">", 
  "",
  "\0", 
  ]);
}
function makeShapeyValue(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(10) === 0)
    return makeExpr(d, b);  var a = [
    
    [
    "0", "1", "2", "3", "0.1", ".2", "1.3", "4.", "5.0000000000000000000000",
    "1.2e3", "1e81", "1e+81", "1e-81", "1e4", "-0", "(-0)",
    "-1", "(-1)", "0x99", "033", "3/0", "-3/0", "0/0",
    "Math.PI",
    "0x2D413CCC", "0x5a827999", "0xB504F332", "-0x2D413CCC", "-0x5a827999", "-0xB504F332", "0x50505050", "(0x50505050 >> 1)",
    
    "0x10000000", "0x20000000", "0x3FFFFFFE", "0x3FFFFFFF", "0x40000000", "0x40000001", "0x80000000", "-0x80000000",
    ],    
    [ "(1/0)", "(-1/0)", "(0/0)" ],    
    [" \"\" ", " '' ", " 'A' ", " '\\0' ", ' "use strict" '],    
    [ " /x/ ", " /x/g "],    
    [ "true", "false" ],    
    [ "(void 0)", "null" ],    
    [ "[]", "[1]", "[(void 0)]", "{}", "{x:3}", "({})", "({x:3})" ],    
    [ "NaN", "Infinity", "-Infinity", "undefined"],    
    [ "new Boolean(true)", "new Boolean(false)" ],    
    [ "new Number(1)", "new Number(1.5)" ],    
    [ "new String('')", "new String('q')" ],    
    [ "function(){}" ],
    [ "{}", "[]", "[1]", "['z']", "[undefined]", "this", "eval", "arguments", "arguments.caller", "arguments.callee" ],
    [ "objectEmulatingUndefined()" ],    
    [ b.length ? Random.index(b) : "x" ]
  ];  return Random.index(Random.index(a));
}function mixedTypeArrayElem(d, b)
{
  while (true) {
    var s = makeShapeyValue(d - 3, b);
    if (s.length < 60)
      return s;
  }
}function makeMixedTypeArray(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  
  var q = rnd(4) + 2;
  var picks = [];
  for (var j = 0; j < q; ++j) {
    picks.push(mixedTypeArrayElem(d, b));
  }  
  var c = [];
  var count = loopCount();
  for (var j = 0; j < count; ++j) {
    var elem = Random.index(picks);
    
    
    var repeat = count === 0 ? rnd(4)===0 : rnd(50)===0;
    var repeats = repeat ? rnd(30) : 1;
    for (var k = 0; k < repeats; ++k) {
      c.push(elem);
    }
  }  return "/*MARR*/" + "[" + c.join(", ") + "]";
}function makeArrayLiteral(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (rnd(2) === 0)
    return makeMixedTypeArray(d, b);  var elems = [];
  while (rnd(5)) elems.push(makeArrayLiteralElem(d, b));
  return "/*FARR*/" + "[" + elems.join(", ") + "]";
}function makeArrayLiteralElem(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  switch (rnd(5)) {
    case 0:  return "..." + makeIterable(d - 1, b); 
    case 1:  return ""; 
    default: return makeExpr(d - 1, b);
  }
}function makeIterable(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 1)
    return "[]";  return (Random.index(iterableExprMakers))(d, b);
}var iterableExprMakers = Random.weighted([
  
  { w: 1, v: function(d, b) { return "new Array(" + makeNumber(d, b) + ")"; } },
  { w: 8, v: makeArrayLiteral },  
  { w: 1, v: function(d, b) { return cat(["[", makeExpr(d, b), makeComprehension(d, b), "]"]); } },  
  { w: 1, v: function(d, b) { return cat([     makeExpr(d, b), makeComprehension(d, b)     ]); } },
  { w: 1, v: function(d, b) { return cat(["(", makeExpr(d, b), makeComprehension(d, b), ")"]); } },  
  { w: 1, v: function(d, b) { return "(function() { " + directivePrologue() + "yield " + makeExpr(d - 1, b) + "; } })()"; } },
  
  { w: 1, v: function(d, b) { return "/*PTHR*/(function() { " + directivePrologue() + "for (var i of " + makeIterable(d - 1, b) + ") { yield i; } })()"; } },  { w: 1, v: makeFunction },
  { w: 1, v: makeExpr },
]);function strTimes(s, n)
{
  if (n == 0) return "";
  if (n == 1) return s;
  var s2 = s + s;
  var r = n % 2;
  var d = (n - r) / 2;
  var m = strTimes(s2, d);
  return r ? m + s : m;
}
function makeAsmJSModule(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var interior = asmJSInterior([]);
  return '(function(stdlib, foreign, heap){ "use asm"; ' + interior + ' })';
}function makeAsmJSFunction(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var interior = asmJSInterior(["ff"]);
  return '(function(stdlib, foreign, heap){ "use asm"; ' + interior + ' })(this, {ff: ' + makeFunction(d - 2, b) + '}, new ' + arrayBufferType() + '(4096))';
}var proxyHandlerProperties = {
  getOwnPropertyDescriptor: {
    empty:    "function(){}",
    forward:  "function(name) { var desc = Object.getOwnPropertyDescriptor(x); desc.configurable = true; return desc; }",
    throwing: "function(name) { return {get: function() { throw 4; }, set: function() { throw 5; }}; }",
  },
  getPropertyDescriptor: {
    empty:    "function(){}",
    forward:  "function(name) { var desc = Object.getPropertyDescriptor(x); desc.configurable = true; return desc; }",
    throwing: "function(name) { return {get: function() { throw 4; }, set: function() { throw 5; }}; }",
  },
  defineProperty: {
    empty:    "function(){}",
    forward:  "function(name, desc) { Object.defineProperty(x, name, desc); }"
  },
  getOwnPropertyNames: {
    empty:    "function() { return []; }",
    forward:  "function() { return Object.getOwnPropertyNames(x); }"
  },
  delete: {
    empty:    "function() { return true; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(name) { return delete x[name]; }"
  },
  fix: {
    empty:    "function() { return []; }",
    yes:      "function() { return []; }",
    no:       "function() { }",
    forward:  "function() { if (Object.isFrozen(x)) { return Object.getOwnProperties(x); } }"
  },
  has: {
    empty:    "function() { return false; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(name) { return name in x; }"
  },
  hasOwn: {
    empty:    "function() { return false; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(name) { return Object.prototype.hasOwnProperty.call(x, name); }"
  },
  get: {
    empty:    "function() { return undefined }",
    forward:  "function(receiver, name) { return x[name]; }",
    bind:     "function(receiver, name) { var prop = x[name]; return (typeof prop) === 'function' ? prop.bind(x) : prop; }"
  },
  set: {
    empty:    "function() { return true; }",
    yes:      "function() { return true; }",
    no:       "function() { return false; }",
    forward:  "function(receiver, name, val) { x[name] = val; return true; }"
  },
  iterate: {
    empty:    "function() { return (function() { throw StopIteration; }); }",
    forward:  "function() { return (function() { for (var name in x) { yield name; } })(); }"
  },
  enumerate: {
    empty:    "function() { return []; }",
    forward:  "function() { var result = []; for (var name in x) { result.push(name); }; return result; }"
  },
  keys: {
    empty:    "function() { return []; }",
    forward:  "function() { return Object.keys(x); }"
  }
};function makeProxyHandlerFactory(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  if (d < 1)
    return "({/*TOODEEP*/})";  try { 
    var preferred = Random.index(["empty", "forward", "yes", "no", "bind", "throwing"]);
    var fallback = Random.index(["empty", "forward"]);
    var fidelity = rnd(10);    var handlerFactoryText = "(function handlerFactory(x) {";
    handlerFactoryText += "return {";    if (rnd(2)) {
      
      bp = b.concat(['x']);
    } else {
      
      handlerFactoryText = handlerFactoryText.replace(/x/, "");
      bp = b;
    }    for (var p in proxyHandlerProperties) {
      var funText;
      if (proxyHandlerProperties[p][preferred] && rnd(10) <= fidelity) {
        funText = proxyMunge(proxyHandlerProperties[p][preferred], p);
      } else {
        switch(rnd(7)) {
        case 0:  funText = makeFunction(d - 3, bp); break;
        case 1:  funText = "undefined"; break;
        case 2:  funText = "function() { throw 3; }"; break;
        default: funText = proxyMunge(proxyHandlerProperties[p][fallback], p);
        }
      }
      handlerFactoryText += p + ": " + funText + ", ";
    }    handlerFactoryText += "}; })";    return handlerFactoryText;
  } catch(e) {
    return "({/* :( */})";
  }
}function proxyMunge(funText, p)
{
  
  return funText;
}function makeProxyHandler(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return makeProxyHandlerFactory(d, b) + "(" + makeExpr(d - 3, b) + ")";
}
/*
David Anderson suggested creating the following recursive structures:
  - recurse down an array of mixed types, car cdr kinda thing
  - multiple recursive calls in a function, like binary search left/right, sometimes calls neither and sometimes calls both  the recursion support in spidermonkey only works with self-recursion.
  that is, two functions that call each other recursively will not be traced.  two trees are formed, going down and going up.
  type instability matters on both sides.
  so the values returned from the function calls matter.  so far, what i've thought of means recursing from the top of a function and if..else.
  but i'd probably also want to recurse from other points, e.g. loops.  special code for tail recursion likely coming soon, but possibly as a separate patch, because it requires changes to the interpreter.
*/
var recursiveFunctions = [
  {
    
    text: "(function too_much_recursion(depth) { @; if (depth > 0) { @; too_much_recursion(depth - 1); @ } else { @ } @ })",
    vars: ["depth"],
    args: function(d, b) { return singleRecursionDepth(d, b); },
    test: function(f) { try { f(5000); } catch(e) { } return true; }
  },
  {
    text: "(function factorial(N) { @; if (N == 0) { @; return 1; } @; return N * factorial(N - 1); @ })",
    vars: ["N"],
    args: function(d, b) { return singleRecursionDepth(d, b); },
    test: function(f) { return f(10) == 3628800; }
  },
  {
    text: "(function factorial_tail(N, Acc) { @; if (N == 0) { @; return Acc; } @; return factorial_tail(N - 1, Acc * N); @ })",
    vars: ["N", "Acc"],
    args: function(d, b) { return singleRecursionDepth(d, b) + ", 1"; },
    test: function(f) { return f(10, 1) == 3628800; }
  },
  {
    
    text: "(function fibonacci(N) { @; if (N <= 1) { @; return 1; } @; return fibonacci(N - 1) + fibonacci(N - 2); @ })",
    vars: ["N"],
    args: function(d, b) { return "" + rnd(8); },
    test: function(f) { return f(6) == 13; }
  },
  {
    
    text: "(function a_indexing(array, start) { @; if (array.length == start) { @; return EXPR1; } var thisitem = array[start]; var recval = a_indexing(array, start + 1); STATEMENT1 })",
    vars: ["array", "start", "thisitem", "recval"],
    args: function(d, b) { return makeMixedTypeArray(d-1, b) + ", 0"; },
    testSub: function(text) { return text.replace(/EXPR1/, "0").replace(/STATEMENT1/, "return thisitem + recval;"); },
    randSub: function(text, varMap, d, b) {
        var expr1 =      makeExpr(d, b.concat([varMap["array"], varMap["start"]]));
        var statement1 = rnd(2) ?
                                   makeStatement(d, b.concat([varMap["thisitem"], varMap["recval"]]))        :
                            "return " + makeExpr(d, b.concat([varMap["thisitem"], varMap["recval"]])) + ";";        return (text.replace(/EXPR1/,      expr1)
                    .replace(/STATEMENT1/, statement1)
        ); },
    test: function(f) { return f([1,2,3,"4",5,6,7], 0) == "123418"; }
  },
  {
    
    text: "(function sum_indexing(array, start) { @; return array.length == start ? 0 : array[start] + sum_indexing(array, start + 1); })",
    vars: ["array", "start"],
    args: function(d, b) { return makeMixedTypeArray(d-1, b) + ", 0"; },
    test: function(f) { return f([1,2,3,"4",5,6,7], 0) == "123418"; }
  },
  {
    text: "(function sum_slicing(array) { @; return array.length == 0 ? 0 : array[0] + sum_slicing(array.slice(1)); })",
    vars: ["array"],
    args: function(d, b) { return makeMixedTypeArray(d-1, b); },
    test: function(f) { return f([1,2,3,"4",5,6,7]) == "123418"; }
  }
];function singleRecursionDepth(d, b)
{
  if (rnd(2) === 0) {
    return "" + rnd(4);
  }
  if (rnd(10) === 0) {
    return makeExpr(d - 2, b);
  }
  return "" + rnd(100000);
}(function testAllRecursiveFunctions() {
  for (var i = 0; i < recursiveFunctions.length; ++i) {
    var a = recursiveFunctions[i];
    var text = a.text;
    if (a.testSub) text = a.testSub(text);
    var f = eval(text.replace(/@/g, ""));
    if (!a.test(f))
      throw "Failed test of: " + a.text;
  }
})();function makeImmediateRecursiveCall(d, b, cheat1, cheat2)
{
  if (rnd(10) !== 0)
    return "(4277)";  var a = (cheat1 == null) ? Random.index(recursiveFunctions) : recursiveFunctions[cheat1];
  var s = a.text;
  var varMap = {};
  for (var i = 0; i < a.vars.length; ++i) {
    var prettyName = a.vars[i];
    varMap[prettyName] = uniqueVarName();
    s = s.replace(new RegExp(prettyName, "g"), varMap[prettyName]);
  }
  var actualArgs = cheat2 == null ? a.args(d, b) : cheat2;
  s = s + "(" + actualArgs + ")";
  s = s.replace(/@/g, function() { if (rnd(4) === 0) return makeStatement(d-2, b); return ""; });
  if (a.randSub) s = a.randSub(s, varMap, d, b);
  s = "(" + s + ")";
  return s;
}/*********************************
 * GENERATING REGEXPS AND INPUTS *
 *********************************/var POTENTIAL_MATCHES = 10;
var backrefHack = [];
for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
  backrefHack[i] = "";
}function regexNumberOfMatches()
{
  if (rnd(10))
    return rnd(5);
  return Math.pow(2, rnd(40)) + rnd(3) - 1;
}function regexPattern(depth, parentWasQuantifier)
{
  if (depth == 0 || (rnd(depth) == 0))
    return regexTerm();  var dr = depth - 1;  var index = rnd(regexMakers.length);
  if (parentWasQuantifier && rnd(30)) index = rnd(regexMakers.length - 1) + 1; 
  return (Random.index(regexMakers[index]))(dr);
}var regexMakers =
[
  [
    
    function(dr) { return regexQuantified(dr, "+", 1, rnd(10)); },
    function(dr) { return regexQuantified(dr, "*", 0, rnd(10)); },
    function(dr) { return regexQuantified(dr, "?", 0, 1); },
    function(dr) { return regexQuantified(dr, "+?", 1, 1); },
    function(dr) { return regexQuantified(dr, "*?", 0, 1); },
    function(dr) { var x = regexNumberOfMatches(); return regexQuantified(dr, "{" + x + "}", x, x); },
    function(dr) { var x = regexNumberOfMatches(); return regexQuantified(dr, "{" + x + ",}", x, x + rnd(10)); },
    function(dr) { var min = regexNumberOfMatches(); var max = min + regexNumberOfMatches(); return regexQuantified(dr, "{" + min + "," + max + "}", min, max); }
  ],
  [
    
    function(dr) { return regexConcatenation(dr); },
    function(dr) { return regexDisjunction(dr); }
  ],
  [
    
    function(dr) { return ["\\" + (rnd(3) + 1), backrefHack.slice(0)]; }, 
    function(dr) { return regexGrouped("(", dr, ")");   }, 
    function(dr) { return regexGrouped("(?:", dr, ")"); }, 
    function(dr) { return regexGrouped("(?=", dr, ")"); }, 
    function(dr) { return regexGrouped("(?!", dr, ")"); }  
  ]
];
function quantifierHelper(pm, min, max, pms)
{
  var repeats = Math.min(min + rnd(max - min + 5) - 2, 10);
  var returnValue = "";
  for (var i = 0; i < repeats; i++)
  {
    if (rnd(100) < 80)
      returnValue = returnValue + pm;
    else
      returnValue = returnValue + Random.index(pms);
  }
  return returnValue;
}function regexQuantified(dr, operator, min, max)
{
  var [re, pms] = regexPattern(dr, true);
  var newpms = [];
  for (var i = 0; i < POTENTIAL_MATCHES; i++)
    newpms[i] = quantifierHelper(pms[i], min, max, pms);
  return [re + operator, newpms];
}
function regexConcatenation(dr)
{
  var [re1, strings1] = regexPattern(dr, false);
  var [re2, strings2] = regexPattern(dr, false);
  var newStrings = [];  for (var i = 0; i < POTENTIAL_MATCHES; i++)
  {
    var chance = rnd(100);
    if (chance < 10)
      newStrings[i] = "";
    else if (chance < 20)
      newStrings[i] = strings1[i];
    else if (chance < 30)
      newStrings[i] = strings2[i];
    else if (chance < 65)
      newStrings[i] = strings1[i] + strings2[i];
    else
      newStrings[i] = Random.index(strings1) + Random.index(strings2);
  }  return [re1 + re2, newStrings];
}function regexDisjunction(dr)
{
  var [re1, strings1] = regexPattern(dr, false);
  var [re2, strings2] = regexPattern(dr, false);
  var newStrings = [];  for (var i = 0; i < POTENTIAL_MATCHES; i++)
  {
    var chance = rnd(100);
    if (chance < 10)
      newStrings[i] = "";
    else if (chance < 20)
      newStrings[i] = Random.index(strings1) + Random.index(strings2);
    else if (chance < 60)
      newStrings[i] = strings1[i];
    else
      newStrings[i] = strings2[i];
  }
  return [re1 + "|" + re2, newStrings];
}function regexGrouped(prefix, dr, postfix)
{
  var [re, strings] = regexPattern(dr, false);
  var newStrings = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    newStrings[i] = rnd(5) ? strings[i] : "";
    if (prefix == "(" && strings[i].length < 40 && rnd(3) === 0) {
      backrefHack[i] = strings[i];
    }
  }
  return [prefix + re + postfix, newStrings];
}
var letters =
["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
 "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"];var hexDigits = [
  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
  "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
  "a", "b", "c", "d", "e", "f",
  "A", "B", "C", "D", "E", "F"
];function regexTerm()
{
  var [re, oneString] = regexTermPair();
  var strings = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    strings[i] = rnd(5) ? oneString : regexTermPair()[1];
  }
  return [re, strings];
}function regexCharCode()
{
  return rnd(2) ? rnd(256) : rnd(65536);
}
var regexCharacterMakers = Random.weighted([
  
  { w:20, v: function() { var cc = regexCharCode(); return [       String.fromCharCode(cc), cc]; } }, 
  { w: 4, v: function() { var cc = regexCharCode(); return ["\\" + String.fromCharCode(cc), cc]; } }, 
  { w: 1, v: function() { return ["\\0",  0]; } },  
  { w: 1, v: function() { return ["\\B", 66]; } },  
  { w: 1, v: function() { return ["\\b",  8]; } },    
  { w: 1, v: function() { return ["\\t",  9]; } },  
  { w: 1, v: function() { return ["\\n", 10]; } },  
  { w: 1, v: function() { return ["\\v", 11]; } },  
  { w: 1, v: function() { return ["\\f", 12]; } },  
  { w: 1, v: function() { return ["\\r", 13]; } },  
  { w: 5, v: function() { var controlCharacterCode = rnd(26) + 1; return ["\\c" + String.fromCharCode(64 + controlCharacterCode), controlCharacterCode]; } },
  
  { w: 5, v: function() { var twoHex = Random.index(hexDigits) + Random.index(hexDigits); return ["\\x" + twoHex, parseInt(twoHex, 16)]; } },
  { w: 5, v: function() { var twoHex = Random.index(hexDigits) + Random.index(hexDigits); return ["\\u00" + twoHex, parseInt(twoHex, 16)]; } },
  { w: 5, v: function() { var fourHex = Random.index(hexDigits) + Random.index(hexDigits) + Random.index(hexDigits) + Random.index(hexDigits); return ["\\u" + fourHex, parseInt(fourHex, 16)]; } },
]);function regexCharacter()
{
  var [matcher, charcode] = Random.index(regexCharacterMakers)();
  switch(rnd(10)) {
    case 0:  return [matcher, charcode + 32]; 
    case 1:  return [matcher, charcode - 32]; 
    case 2:  return [matcher, regexCharCode()]; 
    default: return [matcher, charcode];
  }
}
var regexBuiltInCharClasses = [
    "\\d", "\\D", 
    "\\s", "\\S", 
    "\\w", "\\W", 
];
function regexOneCharStringsWith(frequentChars) {
  var matches = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    matches.push(rnd(8) ? Random.index(frequentChars) : String.fromCharCode(regexCharCode()));
  }
  return matches;
}
function regexShortStringsWith(frequentChars) {
  var matches = [];
  for (var i = 0; i < POTENTIAL_MATCHES; ++i) {
    var s = "";
    while (rnd(3)) {
      s += rnd(4) ? Random.index(frequentChars) : String.fromCharCode(regexCharCode());
    }
    matches.push(s);
  }
  return matches;
}var regexTermMakers =
  [
    function() { return regexCharacterClass(); },
    function() { var [re, cc] = regexCharacter();   return [re, regexOneCharStringsWith([String.fromCharCode(cc)])]; },
    function() { return [Random.index(regexBuiltInCharClasses), regexOneCharStringsWith(["0", "a", "_"])]; },
    function() { return ["[^]",                                 regexOneCharStringsWith(["\n"])];     },
    function() { return [".",                                   regexOneCharStringsWith(["\n"])];     },
    function() { return [Random.index(["^", "$"]),              regexShortStringsWith(["\n"])];     },            
    function() { return [Random.index(["\\b", "\\B"]),          regexShortStringsWith([" ", "\n", "a", "1"])]; }, 
  ];function regexTerm()
{
  return Random.index(regexTermMakers)();
}function regexCharacterClass()
{
  var ranges = rnd(5);
  var inRange = rnd(2);
  var charBucket = [String.fromCharCode(regexCharCode())];   var re = "[";
  if (!inRange) {
    re += "^";
  }  var lo, hi;  for (var i = 0; i < ranges; ++i) {
    if (rnd(100) == 0) {
      
      re += "-";
      if (rnd(2)) {
        re += String.fromCharCode(regexCharCode());
      }
    }    if (rnd(3) == 1) {
      
      re += Random.index(regexBuiltInCharClasses);
      charBucket.push("a");
      charBucket.push("0");
      charBucket.push("_");
    } else if (rnd(2)) {
      
      var a = regexCharacter();
      var b = regexCharacter();
      if ((a[1] <= b[1]) == !!rnd(10)) {
        [lo, hi] = [a, b];
      } else {
        [lo, hi] = [b, a];
      }      re += lo[0] + "-" + hi[0];
      charBucket.push(String.fromCharCode(lo[1] + rnd(3) - 1));
      charBucket.push(String.fromCharCode(hi[1] + rnd(3) - 1));
      charBucket.push(String.fromCharCode(lo[1] + rnd(Math.max(hi[1] - lo[1], 1)))); 
    } else {
      
      var a = regexCharacter();
      re += a[0];
      charBucket.push(String.fromCharCode(a[1]));
    }
  }  re += "]";
  return [re, pickN(charBucket, POTENTIAL_MATCHES)];
}function pickN(bucket, picks)
{
  var picked = [];
  for (var i = 0; i < picks; ++i) {
    picked.push(Random.index(bucket));
  }
  return picked;
}function makeRegisterStompFunction(d, b, pure)
{
  var args = [];
  var nArgs = (rnd(10) ? rnd(20) : rnd(100)) + 1;
  for (var i = 0; i < nArgs; ++i) {
    args.push("a" + i);
  }  var bv = b.concat(args);  return (
    "(function(" + args.join(", ") + ") { " +
      makeRegisterStompBody(d, bv, pure) +
      "return " + Random.index(bv) + "; " +
    "})"
  );
}function makeRegisterStompBody(d, b, pure)
{
  var bv = b.slice(0);
  var lastRVar = 0;
  var s = "";  function value()
  {
    return rnd(3) && bv.length ? Random.index(bv) : "" + rnd(10);
  }  function expr()
  {
    return value() + Random.index([" + ", " - ", " / ", " * ", " % ", " | ", " & ", " ^ "]) + value();
  }  while (rnd(100)) {
    if (bv.length == 0 || rnd(4)) {
      var newVar = "r" + lastRVar;
      ++lastRVar;
      s += "var " + newVar + " = " + expr() + "; ";
      bv.push(newVar);
    } else if (rnd(5) === 0 && !pure) {
      s += "print(" + Random.index(bv) + "); ";
    } else {
      s += Random.index(bv) + " = " + expr() + "; ";
    }
  }  return s;
}
/***********************
 * TEST BUILT-IN TYPES *
 ***********************/var makeBuilderStatement;
var makeEvilCallback;(function setUpBuilderStuff() {
  var ARRAY_SIZE = 20;
  var OBJECTS_PER_TYPE = 3;
  var smallPowersOfTwo = [1, 2, 4, 8]; 
  function bufsize() { return rnd(ARRAY_SIZE) * Random.index(smallPowersOfTwo); }
  function arrayIndex(d, b) {
    switch(rnd(8)) {
      case 0:  return m("v");
      case 1:  return makeExpr(d - 1, b);
      case 2:  return "({valueOf: function() { " + makeStatement(d, b) + "return " + rnd(ARRAY_SIZE) + "; }})";
      default: return "" + rnd(ARRAY_SIZE);
    }
  }  
  function m(t)
  {
    if (!t)
      t = "aosmevbtihgfp";
    t = t.charAt(rnd(t.length));
    var name = t + rnd(OBJECTS_PER_TYPE);
    switch(rnd(16)) {
      case 0:  return m("o") + "." + name;
      case 1:  return m("g") + "." + name;
      case 2:  return "this." + name;
      default: return name;
    }
  }  function val(d, b)
  {
    if (rnd(10))
      return m();
    return makeExpr(d, b);
  }  
  function assign(d, b, t, rhs)
  {
    switch(rnd(18)) {
    
    case 0:  return (
      "Object.defineProperty(" +
        (rnd(8)?"this":m("og")) + ", " +
        simpleSource(m(t)) + ", " +
        "{ " + propertyDescriptorPrefix(d-1, b) + " get: function() { " + (rnd(8)?"":makeBuilderStatement(d-1,b)) + " return " + rhs + "; } }" +
      ");"
    );
    case 1:  return Random.index(varBinder) + m(t) + " = " + rhs + ";";
    default: return m(t) + " = " + rhs + ";";
    }
  }  function makeCounterClosure(d, b)
  {
    
    var v = uniqueVarName();
    var infrequently = infrequentCondition(v, 10);
    return (
      "(function mcc_() { " +
        "var " + v + " = 0; " +
        "return function() { " +
          "++" + v + "; " +
            (rnd(3) ?
              "if (" + infrequently + ") { dumpln('hit!'); " + makeBuilderStatements(d, b) + " } " +
              "else { dumpln('miss!'); " + makeBuilderStatements(d, b) + " } "
            : m("f") + "(" + infrequently + ");"
            ) +
        "};" +
      "})()");
  }  function fdecl(d, b)
  {
    var argName = m();
    var bv = b.concat([argName]);
    return "function " + m("f") + "(" + argName + ") " + makeFunctionBody(d, bv);
  }  function makeBuilderStatements(d, b)
  {
    var s = "";
    var extras = rnd(4);
    for (var i = 0; i < extras; ++i) {
      s += "try { " + makeBuilderStatement(d - 2, b) +  " } catch(e" + i + ") { } ";
    }
    s += makeBuilderStatement(d - 1, b);
    return s;
  }  var builderFunctionMakers = Random.weighted([
    { w: 9,  v: function(d, b) { return "(function() { " + makeBuilderStatements(d, b) + " return " + m() + "; })"; } },
    { w: 1,  v: function(d, b) { return "(function() { " + makeBuilderStatements(d, b) + " throw " + m() + "; })"; } },
    { w: 1,  v: function(d, b) { return "(function(j) { " + m("f") + "(j); })"; } }, 
    
    { w: 4,  v: function(d, b) { return "(function(j) { if (j) { " + makeBuilderStatements(d, b) + " } else { " + makeBuilderStatements(d, b) + " } })"; } },
    { w: 4,  v: function(d, b) { return "(function() { for (var j=0;j<" + loopCount() + ";++j) { " + m("f") + "(j%"+(2+rnd(4))+"=="+rnd(2)+"); } })"; } },
    { w: 1,  v: function(d, b) { return Random.index(builtinFunctions) + ".bind(" + m() + ")"; } },
    { w: 5,  v: function(d, b) { return m("f"); } },
    { w: 3,  v: makeCounterClosure },
    { w: 2,  v: makeFunction },
    { w: 1,  v: makeAsmJSModule },
    { w: 1,  v: makeAsmJSFunction },
    { w: 1,  v: makeRegisterStompFunction },
  ]);
  makeEvilCallback = function(d, b) {
    return (Random.index(builderFunctionMakers))(d - 1, b);
  };  var handlerTraps = ["getOwnPropertyDescriptor", "getPropertyDescriptor", "defineProperty", "getOwnPropertyNames", "delete", "fix", "has", "hasOwn", "get", "set", "iterate", "enumerate", "keys"];  function forwardingHandler(d, b) {
    return (
      "({"+
        "getOwnPropertyDescriptor: function(name) { Z; var desc = Object.getOwnPropertyDescriptor(X); desc.configurable = true; return desc; }, " +
        "getPropertyDescriptor: function(name) { Z; var desc = Object.getPropertyDescriptor(X); desc.configurable = true; return desc; }, " +
        "defineProperty: function(name, desc) { Z; Object.defineProperty(X, name, desc); }, " +
        "getOwnPropertyNames: function() { Z; return Object.getOwnPropertyNames(X); }, " +
        "delete: function(name) { Z; return delete X[name]; }, " +
        "fix: function() { Z; if (Object.isFrozen(X)) { return Object.getOwnProperties(X); } }, " +
        "has: function(name) { Z; return name in X; }, " +
        "hasOwn: function(name) { Z; return Object.prototype.hasOwnProperty.call(X, name); }, " +
        "get: function(receiver, name) { Z; return X[name]; }, " +
        "set: function(receiver, name, val) { Z; X[name] = val; return true; }, " +
        "iterate: function() { Z; return (function() { for (var name in X) { yield name; } })(); }, " +
        "enumerate: function() { Z; var result = []; for (var name in X) { result.push(name); }; return result; }, " +
        "keys: function() { Z; return Object.keys(X); } " +
      "})"
    )
    .replace(/X/g, m())
    .replace(/Z/g, function() {
      switch(rnd(20)){
        case 0:  return "return " + m();
        case 1:  return "throw " + m();
        default: return makeBuilderStatement(d - 2, b);
      }
    });
  }  function propertyDescriptorPrefix(d, b)
  {
    return "configurable: " + makeBoolean(d, b) + ", " + "enumerable: " + makeBoolean(d, b) + ", ";
  }  function strToEval(d, b)
  {
    switch(rnd(5)) {
      case 0:  return simpleSource(fdecl(d, b));
      case 1:  return simpleSource(makeBuilderStatement(d, b));
      default: return simpleSource(makeScriptForEval(d, b));
    }
  }  function evaluateFlags(d, b)
  {
    
    return ("({ global: " + m("g") +
      ", fileName: " + Random.index(["'evaluate.js'", "null"]) +
      ", lineNumber: 42, newContext: " + makeBoolean(d, b) +
      ", isRunOnce: " + makeBoolean(d, b) +
      ", noScriptRval: " + makeBoolean(d, b) +
      ", catchTermination: " + makeBoolean(d, b) +
      ", saveFrameChain: " + ("bug 881999" && rnd(10000) ? "false" : makeBoolean(d, b)) +
      ((rnd(5) == 0) ? (
        ((rnd(2) == 0) ? (", element: " + m("o")) : "") +
        ((rnd(2) == 0) ? (", elementProperty: " + m("s")) : "") +
        ((rnd(2) == 0) ? (", sourceMapURL: " + m("s")) : "") +
        ((rnd(2) == 0) ? (", sourcePolicy: " + Random.index(["'NO_SOURCE'", "'LAZY_SOURCE'", "'SAVE_SOURCE'"])) : "")
        ) : ""
      ) +
    " })");
  }  var initializedEverything = false;
  function initializeEverything(d, b)
  {
    if (initializedEverything)
      return ";";
    initializedEverything = true;    var s = "";
    for (var i = 0; i < OBJECTS_PER_TYPE; ++i) {
      s += "a" + i + " = []; ";
      s += "o" + i + " = {}; ";
      s += "s" + i + " = ''; ";
      s += "r" + i + " = /x/; ";
      s += "g" + i + " = " + makeGlobal(d, b) + "; ";
      s += "f" + i + " = function(){}; ";
      s += "m" + i + " = new WeakMap; ";
      s += "e" + i + " = new Set; ";
      s += "v" + i + " = null; ";
      s += "b" + i + " = new ArrayBuffer(64); ";
      s += "t" + i + " = new Uint8ClampedArray; ";
      
    }
    return s;
  }  
  
  
  
  function method(d, b, clazz, obj, meth, arglist)
  {
    
    if (rnd(10) == 0)
      arglist = [];    
    while (rnd(2))
      arglist.push(val(d, b));    
    switch (rnd(4)) {
      case 0:  return clazz + ".prototype." + meth + ".apply(" + obj + ", [" + arglist.join(", ") + "])";
      case 1:  return clazz + ".prototype." + meth + ".call(" + [obj].concat(arglist).join(", ") + ")";
      default: return obj + "." + meth + "(" + arglist.join(", ") + ")";
    }
  }  function severalargs(f)
  {
    var arglist = [];
    arglist.push(f());
    while (rnd(2)) {
      arglist.push(f());
    }
    return arglist;
  }  var builderStatementMakers = Random.weighted([
    
    { w: 1,  v: function(d, b) { return assign(d, b, "a", "[]"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", "new Array"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", makeIterable(d, b)); } },
    { w: 1,  v: function(d, b) { return m("a") + ".length = " + arrayIndex(d, b) + ";"; } },
    { w: 8,  v: function(d, b) { return assign(d, b, "v", m("at") + ".length"); } },
    { w: 4,  v: function(d, b) { return m("at") + "[" + arrayIndex(d, b) + "]" + " = " + val(d, b) + ";"; } },
    { w: 4,  v: function(d, b) { return val(d, b) + " = " + m("at") + "[" + arrayIndex(d, b) + "]" + ";"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", makeFunOnCallChain(d, b) + ".arguments"); } }, 
    { w: 1,  v: function(d, b) { return assign(d, b, "a", "arguments"); } },     
    { w: 3,  v: function(d, b) { return m("at") + "[" + arrayIndex(d, b) + "]" + ";"; } },
    { w: 3,  v: function(d, b) { return m("at") + "[" + arrayIndex(d, b) + "] = " + makeExpr(d, b) + ";"; } },
    { w: 1,  v: function(d, b) { return "/*ADP-1*/Object.defineProperty(" + m("a") + ", " + arrayIndex(d, b) + ", " + makePropertyDescriptor(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "/*ADP-2*/Object.defineProperty(" + m("a") + ", " + arrayIndex(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "get: " + makeEvilCallback(d,b) + ", set: " + makeEvilCallback(d, b) + " });"; } },
    { w: 1,  v: function(d, b) { return "/*ADP-3*/Object.defineProperty(" + m("a") + ", " + arrayIndex(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "writable: " + makeBoolean(d,b) + ", value: " + val(d, b) + " });"; } },    
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "push", severalargs(() => val(d, b))) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "pop", []) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "unshift", severalargs(() => val(d, b))) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "shift", []) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "reverse", []) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "sort", [makeEvilCallback(d, b)]) + ";"; } },
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "splice", [arrayIndex(d, b) - arrayIndex(d, b), arrayIndex(d, b)]) + ";"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "s", method(d, b, "Array", m("a"), "join", [m("s")])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "concat", severalargs(() => m("at")))); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "slice", [arrayIndex(d, b) - arrayIndex(d, b), arrayIndex(d, b) - arrayIndex(d, b)])); } },    
    { w: 5,  v: function(d, b) { return method(d, b, "Array", m("a"), "forEach", [makeEvilCallback(d, b)]) + ";"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "map", [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", method(d, b, "Array", m("a"), "filter", [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), "some", [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), "every", [makeEvilCallback(d, b)])); } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), Random.index(["reduce, reduceRight"]), [makeEvilCallback(d, b)])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", method(d, b, "Array", m("a"), Random.index(["reduce, reduceRight"]), [makeEvilCallback(d, b), val(d, b)])); } },    
    
    
    
        
    { w: 1,  v: function(d, b) { return assign(d, b, "o", "{}"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "o", "new Object"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "o", "Object.create(" + val(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return "selectforgc(" + m("o") + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "s", "''"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "s", "new String"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "s", "new String(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "s", m("s") + ".charAt(" + arrayIndex(d, b) + ")"); } },
    { w: 5,  v: function(d, b) { return m("s") + " += 'x';"; } },
    { w: 5,  v: function(d, b) { return m("s") + " += " + m("s") + ";"; } },
        
    { w: 1,  v: function(d, b) { return assign(d, b, "m", "new Map"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "m", "new Map(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "m", "new WeakMap"); } },
    { w: 5,  v: function(d, b) { return m("m") + ".has(" + val(d, b) + ");"; } },
    { w: 4,  v: function(d, b) { return m("m") + ".get(" + val(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, null, m("m") + ".get(" + val(d, b) + ")"); } },
    { w: 5,  v: function(d, b) { return m("m") + ".set(" + val(d, b) + ", " + val(d, b) + ");"; } },
    { w: 3,  v: function(d, b) { return m("m") + ".delete(" + val(d, b) + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "e", "new Set"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "e", "new Set(" + m() + ")"); } },
    { w: 5,  v: function(d, b) { return m("e") + ".has(" + val(d, b) + ");"; } },
    { w: 5,  v: function(d, b) { return m("e") + ".add(" + val(d, b) + ");"; } },
    { w: 3,  v: function(d, b) { return m("e") + ".delete(" + val(d, b) + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "b", "new " + arrayBufferType() + "(" + bufsize() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "b", m("t") + ".buffer"); } },
    { w: 1,  v: function(d, b) { return "neuter(" + m("b") + ", " + (rnd(2) ? '"same-data"' : '"change-data"') + ");"; } },    
    
    { w: 1,  v: function(d, b) { return assign(d, b, "t", "new " + Random.index(typedArrayConstructors) + "(" + arrayIndex(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return assign(d, b, "t", "new " + Random.index(typedArrayConstructors) + "(" + m("abt") + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "t", "new " + Random.index(typedArrayConstructors) + "(" + m("b") + ", " + bufsize() + ", " + arrayIndex(d, b) + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "t", m("t") + ".subarray(" + arrayIndex(d, b) + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "t", m("t") + ".subarray(" + arrayIndex(d, b) + ", " + arrayIndex(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return m("t") + ".set(" + m("at") + ", " + arrayIndex(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m("tb") + ".byteLength"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m("t") + ".byteOffset"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m("t") + ".BYTES_PER_ELEMENT"); } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "h", "{}"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "h", forwardingHandler(d, b)); } },
    { w: 1,  v: function(d, b) { return "delete " + m("h") + "." + Random.index(handlerTraps) + ";"; } },
    { w: 4,  v: function(d, b) { return m("h") + "." + Random.index(handlerTraps) + " = " + makeEvilCallback(d, b) + ";"; } },
    { w: 4,  v: function(d, b) { return m("h") + "." + Random.index(handlerTraps) + " = " + m("f") + ";"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, null, "Proxy.create(" + m("h") + ", " + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "f", "Proxy.createFunction(" + m("h") + ", " + m("f") + ", " + m("f") + ")"); } },    
    
    
    { w: 1,  v: function(d, b) { return assign(d, b, "r", makeRegex(d, b)); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "a", m("r") + ".exec(" + m("s") + ")"); } },
    { w: 3,  v: function(d, b) { return makeRegexUseBlock(d, b, m("r")); } },
    { w: 3,  v: function(d, b) { return makeRegexUseBlock(d, b, m("r"), m("s")); } },
    { w: 3,  v: function(d, b) { return assign(d, b, "v", m("r") + "." + Random.index(builtinObjects["RegExp.prototype"])); } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "g", makeGlobal(d, b)); } },
    { w: 5,  v: function(d, b) { return assign(d, b, "v", m("g") + ".eval(" + strToEval(d, b) + ")"); } },
    { w: 5,  v: function(d, b) { return assign(d, b, "v", "evalcx(" + strToEval(d, b) + ", " + m("g") + ")"); } },
    { w: 5,  v: function(d, b) { return assign(d, b, "v", "evaluate(" + strToEval(d, b) + ", " + evaluateFlags(d, b) + ")"); } },
    { w: 3,  v: function(d, b) { return "(void schedulegc(" + m("g") + "));"; } },    
    { w: 3,  v: function(d, b) { return "/*MXX1*/" + assign(d, b, "o", m("g") + "." + Random.index(builtinProperties)); } },
    { w: 3,  v: function(d, b) { return "/*MXX2*/" + m("g") + "." + Random.index(builtinProperties) + " = " + m() + ";"; } },
    { w: 3,  v: function(d, b) { var prop = Random.index(builtinProperties); return "/*MXX3*/" + m("g") + "." + prop + " = " + m("g") + "." + prop + ";"; } },    
    
    { w: 1,  v: function(d, b) { return assign(d, b, "f", makeEvilCallback(d, b)); } },
    { w: 1,  v: fdecl },
    { w: 2,  v: function(d, b) { return m("f") + "(" + m() + ");"; } },    
    { w: 1,  v: function(d, b) { return assign(d, b, "i", "new Iterator(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "i", "new Iterator(" + m() + ", true)"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "i", m("ema") + "." + Random.index(["entries", "keys", "values", "iterator"])); } },
    { w: 3,  v: function(d, b) { return m("i") + ".next();"; } },
    { w: 3,  v: function(d, b) { return m("i") + ".send(" + m() + ");"; } },
        
    { w: 2,  v: function(d, b) { return assign(d, b, "v", Random.index(["4", "4.2", "NaN", "0", "-0", "Infinity", "-Infinity"])); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", "new Number(" + Random.index(["4", "4.2", "NaN", "0", "-0", "Infinity", "-Infinity"]) + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", "new Number(" + m() + ")"); } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", makeBoolean(d, b)); } },
    { w: 2,  v: function(d, b) { return assign(d, b, "v", Random.index(["undefined", "null", "true", "false"])); } },    
    { w: 1,  v: function(d, b) { return "/*ODP-1*/Object.defineProperty(" + m() + ", " + makePropertyName(d, b) + ", " + makePropertyDescriptor(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "/*ODP-2*/Object.defineProperty(" + m() + ", " + makePropertyName(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "get: " + makeEvilCallback(d,b) + ", set: " + makeEvilCallback(d, b) + " });"; } },
    { w: 1,  v: function(d, b) { return "/*ODP-3*/Object.defineProperty(" + m() + ", " + makePropertyName(d, b) + ", { " + propertyDescriptorPrefix(d, b) + "writable: " + makeBoolean(d,b) + ", value: " + val(d, b) + " });"; } },
    { w: 1,  v: function(d, b) { return "Object.prototype.watch.call(" + m() + ", " + makePropertyName(d, b) + ", " + makeEvilCallback(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "Object.prototype.unwatch.call(" + m() + ", " + makePropertyName(d, b) + ");"; } },
    { w: 1,  v: function(d, b) { return "delete " + m() + "[" + makePropertyName(d, b) + "];"; } },
    { w: 1,  v: function(d, b) { return assign(d, b, "v", m() + "[" + makePropertyName(d, b) + "]"); } },
    { w: 1,  v: function(d, b) { return m() + "[" + makePropertyName(d, b) + "] = " + val(d, b) + ";"; } },    
    { w: 5,  v: function(d, b) { return "print(" + m() + ");"; } },
    { w: 5,  v: function(d, b) { return "print(uneval(" + m() + "));"; } },
    { w: 5,  v: function(d, b) { return m() + ".toString = " + makeEvilCallback(d, b) + ";"; } },
    { w: 5,  v: function(d, b) { return m() + ".toSource = " + makeEvilCallback(d, b) + ";"; } },
    { w: 5,  v: function(d, b) { return m() + ".valueOf = " + makeEvilCallback(d, b) + ";"; } },
    { w: 2,  v: function(d, b) { return m() + ".__iterator__ = " + makeEvilCallback(d, b) + ";"; } },
    { w: 1,  v: function(d, b) { return m() + " = " + m() + ";"; } },
    { w: 1,  v: function(d, b) { return m() + " = " + m("g") + ".objectEmulatingUndefined();"; } },
    { w: 1,  v: function(d, b) { return m("o") + " = " + m() + ".__proto__;"; } },
    { w: 5,  v: function(d, b) { return m() + ".__proto__ = " + m() + ";"; } },
    { w: 10, v: function(d, b) { return "for (var p in " + m() + ") { " + makeBuilderStatements(d, b) + " }"; } },
    { w: 10, v: function(d, b) { return "for (var v of " + m() + ") { " + makeBuilderStatements(d, b) + " }"; } },
    { w: 10, v: function(d, b) { return m() + " + " + m() + ";"; } }, 
    { w: 10, v: function(d, b) { return m() + " + '';"; } }, 
    { w: 10, v: function(d, b) { return m("v") + " = (" + m() + " instanceof " + m() + ");"; } },
    { w: 10, v: function(d, b) { return m("v") + " = Object.prototype.isPrototypeOf.call(" + m() + ", " + m() + ");"; } },
    { w: 2,  v: function(d, b) { return "Object." + Random.index(["preventExtensions", "seal", "freeze"]) + "(" + m() + ");"; } },    
    { w: 1,  v: function(d, b) { return m() + " = x;"; } },
    { w: 1,  v: function(d, b) { return "x = " + m() + ";"; } },
    { w: 5,  v: makeStatement },    { w: 5,  v: initializeEverything },
  ]);
  makeBuilderStatement = function(d, b) {
    return (Random.index(builderStatementMakers))(d - 1, b);
  };
})();
function infrequentCondition(v, n)
{
  switch (rnd(20)) {
    case 0: return true;
    case 1: return false;
    case 2: return v + " > " + rnd(n);
    default: var mod = rnd(n) + 2; var target = rnd(mod); return "/*ICCD*/" + v + " % " + mod + (rnd(8) ? " == " : " != ") + target;
  }
}var arrayBufferType = "SharedArrayBuffer" in this ?
  function() { return rnd(2) ? "SharedArrayBuffer" : "ArrayBuffer"; } :
  function() { return "ArrayBuffer"; };/***************************
 * TEST ASM.JS CORRECTNESS *
 ***************************/
var compareAsm = (function() {  function isSameNumber(a, b)
  {
    if (!(typeof a == "number" && typeof b == "number"))
      return false;    
    if (a === 0 && b === 0)
      return 1/a === 1/b;    
    return a === b || (a !== a && b !== b);
  }  var asmvals = [
    1, Math.PI, 42,
    
    0, -0, 0/0, 1/0, -1/0,
    
     0x07fffffff,  0x080000000,  0x080000001,
    -0x07fffffff, -0x080000000, -0x080000001,
     0x0ffffffff,  0x100000000,  0x100000001,
    -0x0ffffffff, -0x100000000,  0x100000001,
    
    Number.MIN_VALUE, -Number.MIN_VALUE,
    Number.MAX_VALUE, -Number.MAX_VALUE,
  ];
  var asmvalsLen = asmvals.length;  function compareUnaryFunctions(f, g)
  {
    for (var i = 0; i < asmvalsLen; ++i) {
      var x = asmvals[i];
      var fr = f(x);
      var gr = g(x);
      if (!isSameNumber(fr, gr)) {
        foundABug("asm mismatch", "(" + uneval(x) + ") -> " + uneval(fr) + " vs "  + uneval(gr));
      }
    }
  }  function compareBinaryFunctions(f, g)
  {
    for (var i = 0; i < asmvalsLen; ++i) {
      var x = asmvals[i];
      for (var j = 0; j < asmvalsLen; ++j) {
        var y = asmvals[j];
        var fr = f(x, y);
        var gr = g(x, y);
        if (!isSameNumber(fr, gr)) {
          foundABug("asm mismatch", "(" + uneval(x) + ", " + uneval(y) + ") -> " + uneval(fr) + " vs "  + uneval(gr));
        }
      }
    }
  }  return {compareUnaryFunctions: compareUnaryFunctions, compareBinaryFunctions: compareBinaryFunctions};
})();function nanBitsMayBeVisible(s)
{
  
  return (s.indexOf("Uint") != -1 || s.indexOf("Int") != -1) + (s.indexOf("Float32Array") != -1) + (s.indexOf("Float64Array") != -1) > 1;
}var pureForeign = {
  identity:  function(x) { return x; },
  quadruple: function(x) { return x * 4; },
  half:      function(x) { return x / 2; },
  
  asString:  function(x) { return uneval(x); },
  asValueOf: function(x) { return { valueOf: function() { return x; } }; },
  
  sum:       function()  { var s = 0; for (var i = 0; i < arguments.length; ++i) s += arguments[i]; return s; },
  
  stomp:     function()  { },
};for (var f in unaryMathFunctions) {
  pureForeign["Math_" + unaryMathFunctions[f]] = Math[unaryMathFunctions[f]];
}for (var f in binaryMathFunctions) {
  pureForeign["Math_" + binaryMathFunctions[f]] = Math[binaryMathFunctions[f]];
}var pureMathNames = Object.keys(pureForeign);function generateAsmDifferential()
{
  var foreignFunctions = rnd(10) ? [] : pureMathNames;
  return asmJSInterior(foreignFunctions, true);
}function testAsmDifferential(stdlib, interior)
{
  if (nanBitsMayBeVisible(interior)) {
    dumpln("Skipping correctness test for asm module that could expose low bits of NaN");
    return;
  }  var asmJs = "(function(stdlib, foreign, heap) { 'use asm'; " + interior + " })";
  var asmModule = eval(asmJs);  if (isAsmJSModule(asmModule)) {
    var asmHeap = new ArrayBuffer(4096);
    (new Int32Array(asmHeap))[0] = 0x12345678;
    var asmFun = asmModule(stdlib, pureForeign, asmHeap);    var normalHeap = new ArrayBuffer(4096);
    (new Int32Array(normalHeap))[0] = 0x12345678;
    var normalJs = "(function(stdlib, foreign, heap) { " + interior + " })";
    var normalModule = eval(normalJs);
    var normalFun = normalModule(stdlib, pureForeign, normalHeap);    compareAsm.compareBinaryFunctions(asmFun, normalFun);
  }
}
function startAsmDifferential()
{
  var asmFuzzSeed = 110798809; //Math.floor(Math.random() * Math.pow(2,28));
 // dumpln("asmFuzzSeed: " + asmFuzzSeed);
  Random.init(asmFuzzSeed);  while (true) {    var stompStr = makeRegisterStompFunction(8, [], true);
    print(stompStr);
    pureForeign.stomp = eval(stompStr);    for (var i = 0; i < 100; ++i) {
      var interior = generateAsmDifferential();
      print(interior);
      testAsmDifferential(this, interior);
    }
    gc();
  }
}var numericVals = [
  "1", "Math.PI", "42",
  
  "0", "-0", "0/0", "1/0", "-1/0",
  
   "0x07fffffff",  "0x080000000",  "0x080000001",
  "-0x07fffffff", "-0x080000000", "-0x080000001",
   "0x0ffffffff",  "0x100000000",  "0x100000001",
  "-0x0ffffffff", "-0x100000000",  "0x100000001",
  
  "Number.MIN_VALUE", "-Number.MIN_VALUE",
  "Number.MAX_VALUE", "-Number.MAX_VALUE",
];var confusableVals = [
  "0",
  "0.1",
  "-0",
  "''",
  "'0'",
  "'\\0'",
  "[]",
  "[0]",
  "/0/",
  "'/0/'",
  "1",
  "({toString:function(){return '0';}})",
  "({valueOf:function(){return 0;}})",
  "({valueOf:function(){return '0';}})",
  "false",
  "true",
  "undefined",
  "null",
  "(function(){return 0;})",
  "NaN",
  "(new Boolean(false))",
  "(new Boolean(true))",
  "(new String(''))",
  "(new Number(0))",
  "(new Number(-0))",
  "objectEmulatingUndefined()",
];function hashStr(s)
{
  var hash = 0;
  var L = s.length;
  for (var i = 0; i < L; i++) {
    var c = s.charCodeAt(i);
    hash = (Math.imul(hash, 31) + c) | 0;
  }
  return hash;
}function testMathyFunction(f, inputs)
{
  var results = [];
  if (f) {
    for (var j = 0; j < inputs.length; ++j) {
      for (var k = 0; k < inputs.length; ++k) {
        try {
          results.push(f(inputs[j], inputs[k]));
        } catch(e) {
          results.push(errorToString(e));
        }
      }
    }
  }
  /* Use uneval to distinguish -0, 0, "0", etc. */
  /* Use hashStr to shorten the output and keep compareJIT files small. */
  print(hashStr(uneval(results)));
}function mathInitFCM()
{
  
  var cookie = "/*F" + "CM*/";  print(cookie + hashStr.toString().replace(/\n/g, " "));
  print(cookie + testMathyFunction.toString().replace(/\n/g, " "));
}function makeMathyFunAndTest(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  var i = rnd(NUM_MATH_FUNCTIONS);
  var s = "";  if (rnd(5)) {
    if (rnd(8)) {
      s += "mathy" + i + " = " + makeMathFunction(6, b, i) + "; ";
    } else {
      s += "mathy" + i + " = " + makeAsmJSFunction(6, b) + "; ";
    }
  }  if (rnd(5)) {
    var inputsStr;
    switch(rnd(8)) {
      case 0:  inputsStr = makeMixedTypeArray(d - 1, b); break;
      case 1:  inputsStr = "[" + Random.shuffled(confusableVals).join(", ") + "]"; break;
      default: inputsStr = "[" + Random.shuffled(numericVals).join(", ") + "]"; break;
    }    s += "testMathyFunction(mathy" + i + ", " + inputsStr + "); ";
  }  return s;
}function makeMathyFunRef(d, b)
{
  if (rnd(TOTALLY_RANDOM) == 2) return totallyRandom(d, b);  return "mathy" + rnd(NUM_MATH_FUNCTIONS);
}/*******************************
 * EXECUTION CONSISTENCY TESTS *
 *******************************/function sandboxResult(code, zone)
{
  
  var result;
  var resultStr = "";
  try {
    
    
    var sandbox = newGlobal({sameZoneAs: zone});    result = evalcx(code, sandbox);
    if (typeof result != "object") {
      
      resultStr = "" + result;
    }
  } catch(e) {
    result = "Error: " + errorToString(e);
  }
  
  return resultStr;
}function nestingConsistencyTest(code)
{
  
  
  function nestExpr(e) { return "(function() { return " + code + "; })()"; }
  var codeNestedOnce = nestExpr(code);
  var codeNestedDeep = code;
  var depth = (count % 7) + 14; 
  for (var i = 0; i < depth; ++i) {
    codeNestedDeep = nestExpr(codeNestedDeep);
  }  
  var resultO = sandboxResult(codeNestedOnce, null); var resultD = sandboxResult(codeNestedDeep, null);  
    if (resultO != resultD) {
    foundABug("NestTest mismatch",
      "resultO: " + resultO + "\n" +
      "resultD: " + resultD);
  }
}
function optionalTests(f, code, wtt)
{
  if (count % 100 == 1) {
    tryHalves(code);
  }  if (count % 100 == 2 && engine == ENGINE_SPIDERMONKEY_TRUNK) {
    try {
      Reflect.parse(code);
    } catch(e) {
    }
  }  if (count % 100 == 3 && f && typeof disassemble == "function") {
    
    
    disassemble("-r", f);
  }  if (0 && f && wtt.allowExec && engine == ENGINE_SPIDERMONKEY_TRUNK) {
    simpleDVGTest(code);
    tryEnsureSanity();
  }  if (count % 100 == 6 && f && wtt.allowExec && wtt.expectConsistentOutput && wtt.expectConsistentOutputAcrossIter
    && engine == ENGINE_SPIDERMONKEY_TRUNK && getBuildConfiguration()['more-deterministic']) {
    nestingConsistencyTest(code);
  }
}
function simpleDVGTest(code)
{
  var fullCode = "(function() { try { \n" + code + "\n; throw 1; } catch(exx) { this.nnn.nnn } })()";  try {
    eval(fullCode);
  } catch(e) {
    if (e.message != "this.nnn is undefined" && e.message.indexOf("redeclaration of") == -1) {
      
      foundABug("Wrong error " + "message", e);
    }
  }
}
function tryHalves(code)
{
      var f, firstHalf, secondHalf;  try {    firstHalf = code.substr(0, code.length / 2);
    if (verbose)
      dumpln("First half: " + firstHalf);
    f = new Function(firstHalf);
    void ("" + f);
  }
  catch(e) {
    if (verbose)
      dumpln("First half compilation error: " + e);
  }  try {
    secondHalf = code.substr(code.length / 2, code.length);
    if (verbose)
      dumpln("Second half: " + secondHalf);
    f = new Function(secondHalf);
    void ("" + f);
  }
  catch(e) {
    if (verbose)
      dumpln("Second half compilation error: " + e);
  }
}/*****************
 * USING REGEXPS *
 *****************/function randomRegexFlags() {
  var s = "";
  if (rnd(2))
    s += "g";
  if (rnd(2))
    s += "y";
  if (rnd(2))
    s += "i";
  if (rnd(2))
    s += "m";
  return s;
}function toRegexSource(rexpat)
{
  return (rnd(2) === 0 && rexpat.charAt(0) != "*") ?
    "/" + rexpat + "/" + randomRegexFlags() :
    "new RegExp(" + simpleSource(rexpat) + ", " + simpleSource(randomRegexFlags()) + ")";
}function makeRegexUseBlock(d, b, rexExpr, strExpr)
{
  var rexpair = regexPattern(10, false);
  var rexpat = rexpair[0];
  var str = rexpair[1][rnd(POTENTIAL_MATCHES)];  if (!rexExpr) rexExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : toRegexSource(rexpat);
  if (!strExpr) strExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : simpleSource(str);  var bv = b.concat(["s", "r"]);  return ("/*RXUB*/var r = " + rexExpr + "; " +
          "var s = " + strExpr + "; " +
          "print(" +
            Random.index([
              "r.exec(s)",
              "uneval(r.exec(s))",
              "r.test(s)",
              "s.match(r)",
              "uneval(s.match(r))",
              "s.search(r)",
              "s.replace(r, " + makeReplacement(d, bv) + (rnd(3) ? "" : ", " + simpleSource(randomRegexFlags())) + ")",
              "s.split(r)"
            ]) +
          "); " +
          (rnd(3) ? "" : "print(r.lastIndex); ")
          );
}function makeRegexUseExpr(d, b)
{
  var rexpair = regexPattern(8, false);
  var rexpat = rexpair[0];
  var str = rexpair[1][rnd(POTENTIAL_MATCHES)];  var rexExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : toRegexSource(rexpat);
  var strExpr = rnd(10) === 0 ? makeExpr(d - 1, b) : simpleSource(str);  return "/*RXUE*/" + rexExpr + ".exec(" + strExpr + ")";
}function makeRegex(d, b)
{
  var rexpair = regexPattern(8, false);
  var rexpat = rexpair[0];
  var rexExpr = toRegexSource(rexpat);
  return rexExpr;
}function makeReplacement(d, b)
{
  switch(rnd(3)) {
    case 0:  return Random.index(["''", "'x'", "'\\u0341'"]);
    case 1:  return makeExpr(d, b);
    default: return makeFunction(d, b);
  }
}function start(glob)
{
  var fuzzSeed = 110798809;//Math.floor(Math.random() * Math.pow(2,28));
  dumpln("fuzzSeed: " + fuzzSeed);
  Random.init(fuzzSeed);  
  
  
  var cookie = "/*F";
  cookie += "RC*/";  
  var dumpEachSeed = false;  if (dumpEachSeed) {
    dumpln(cookie + "Random.init(0);");
  }  mathInitFCM();  count = 0;  if (jsshell) {
    
    var MAX_TOTAL_TIME = (glob.maxRunTime) || (Infinity);
    var startTime = new Date();
    var lastTime;    do {
      testOne();
      var elapsed1 = new Date() - lastTime;
      if (elapsed1 > 1000) {
        print("That took " + elapsed1 + "ms!");
      }
      lastTime = new Date();
    } while(lastTime - startTime < MAX_TOTAL_TIME);
  } else {
    setTimeout(testStuffForAWhile, 200);
  }  function testStuffForAWhile()
  {
    for (var j = 0; j < 100; ++j)
      testOne();    if (count % 10000 < 100)
      printImportant("Iterations: " + count);    setTimeout(testStuffForAWhile, 30);
  }  function testOne()
  {
    ++count;    
    
    var depth = 14;    if (dumpEachSeed) {
      
      var MTA = uneval(Random.twister.export_mta());
      var MTI = Random.twister.export_mti();
      if (MTA != Random.lastDumpedMTA) {
        dumpln(cookie + "Random.twister.import_mta(" + MTA + ");");
        Random.lastDumpedMTA = MTA;
      }
      dumpln(cookie + "Random.twister.import_mti(" + MTI + "); void (makeScript(" + depth + "));");
    }    var code = makeScript(depth);    if (count == 1 && engine == ENGINE_SPIDERMONKEY_TRUNK && rnd(5)) {
      code = "tryRunning = useSpidermonkeyShellSandbox(" + rnd(4) + ");";
      
    }  
  
  
  
  
    dumpln(cookie + "count=" + count + "; tryItOut(" + uneval(code) + ");");    tryItOut(code);
  }
}
function failsToCompileInTry(code) {
  
  try {
    var codeInTry = "try { " + code + " } catch(e) { }";
    void new Function(codeInTry);
    return false;
  } catch(e) {
    return true;
  }
}/*********************
 * SANDBOXED RUNNING *
 *********************/var tryRunning = xpcshell ? useGeckoSandbox() : tryRunningDirectly;
function fillShellSandbox(sandbox)
{
  var safeFuns = [
    "print",
    "schedulegc", "selectforgc", "gczeal", "gc", "gcslice",
    "verifyprebarriers", "gcPreserveCode",
    "minorgc", "abortgc",
    "evalcx", "newGlobal", "evaluate",
    "dumpln", "fillShellSandbox",
    "testMathyFunction", "hashStr",
    "isAsmJSCompilationAvailable",
  ];  for (var i = 0; i < safeFuns.length; ++i) {
    var fn = safeFuns[i];
    if (sandbox[fn]) {
      
    } else if (this[fn]) { 
      sandbox[fn] = this[fn].bind(this);
    } else {
      
    }
  }  return sandbox;
}function useSpidermonkeyShellSandbox(sandboxType)
{
  var primarySandbox;  switch (sandboxType) {
    case 0:  primarySandbox = evalcx('');
    case 1:  primarySandbox = evalcx('lazy');
    case 2:  primarySandbox = newGlobal({sameZoneAs: {}}); 
    default: primarySandbox = newGlobal(); 
  }  fillShellSandbox(primarySandbox);  return function(f, code, wtt) {
    try {
      evalcx(code, primarySandbox);
    } catch(e) {
      dumpln("Running in sandbox threw " + errorToString(e));
    }
  };
}
function newGeckoSandbox(n)
{
  var t = (typeof n == "number") ? n : 1;
  var s = Components.utils.Sandbox("http://x" + t + ".example.com/");  
  s.newGeckoSandbox = newGeckoSandbox;
  s.evalInSandbox = function(str, sbx) {
    return Components.utils.evalInSandbox(str, sbx);
  };
  s.print = function(str) { print(str); };  return s;
}function useGeckoSandbox() {
  var primarySandbox = newGeckoSandbox(0);  return function(f, code, wtt) {
    try {
      Components.utils.evalInSandbox(code, primarySandbox);
    } catch(e) {
      
    }
  };
}
/***********************
 * UNSANDBOXED RUNNING *
 ***********************/function directEvalC(s) { var c; /* evil closureizer */ return eval(s); } function newFun(s) { return new Function(s); }function tryRunningDirectly(f, code, wtt)
{
  if (count % 23 == 3) {
    dumpln("Plain eval!");
    try { eval(code); } catch(e) { }
    tryEnsureSanity();
    return;
  }  if (count % 23 == 4) {
    dumpln("About to recompile, using eval hack.");
    f = directEvalC("(function(){" + code + "});");
  }  try {
    if (verbose)
      dumpln("About to run it!");
    var rv = f();
    if (verbose)
      dumpln("It ran!");
    if (wtt.allowIter && rv && typeof rv == "object") {
      tryIteration(rv);
    }
  } catch(runError) {
    if(verbose)
      dumpln("Running threw!  About to toString to error.");
    var err = errorToString(runError);
    dumpln("Running threw: " + err);
  }  tryEnsureSanity();
}var realEval = eval;
var realMath = Math;
var realFunction = Function;
var realGC = gc;
var realUneval = uneval;
var realToString = toString;
var realToSource = this.toSource; 
function tryEnsureSanity()
{
  
  
  try {
    if (typeof resetOOMFailure == "function")
      resetOOMFailure();
  } catch(e) { }  try {
    
    
    if (typeof gczeal == "function")
      gczeal(0);
  } catch(e) { }  
  try { eval(""); } catch(e) { dumpln("That really shouldn't have thrown: " + errorToString(e)); }  if (!this) {
    
    return;
  }  try {
    
    delete this.unwatch;    
    if ('unwatch' in this) {
      this.unwatch("eval");
      this.unwatch("Function");
      this.unwatch("gc");
      this.unwatch("uneval");
      this.unwatch("toSource");
      this.unwatch("toString");
    }    if ('__defineSetter__' in this) {
      
      if (!jsStrictMode)
        delete this.eval;
      delete this.Math;
      delete this.Function;
      delete this.gc;
      delete this.uneval;
      delete this.toSource;
      delete this.toString;
    }    this.Math = realMath;
    this.eval = realEval;
    this.Function = realFunction;
    this.gc = realGC;
    this.uneval = realUneval;
    this.toSource = realToSource;
    this.toString = realToString;
  } catch(e) {
    confused("tryEnsureSanity failed: " + errorToString(e));
  }  
  if (this.eval != realEval)
    confused("Fuzz script replaced |eval|");
  if (Function != realFunction)
    confused("Fuzz script replaced |Function|");
}function tryIteration(rv)
{
  try {
    if (Iterator(rv) !== rv)
      return; 
  }
  catch(e) {
    
    dumpln("Error while trying to determine whether it's an iterator!");
    dumpln("The error was: " + e);
    return;
  }  dumpln("It's an iterator!");
  try {
    var iterCount = 0;
    for (var iterValue of rv)
      ++iterCount;
    dumpln("Iterating succeeded, iterCount == " + iterCount);
  } catch (iterError) {
    dumpln("Iterating threw!");
    dumpln("Iterating threw: " + errorToString(iterError));
  }
}function tryItOut(code)
{
  
  if (typeof gczeal == "function")
    gczeal(0);  
  if (count % 1000 == 0) {
    dumpln("Paranoid GC (count=" + count + ")!");
    realGC();
  }  var wtt = whatToTest(code);  if (!wtt.allowParse)
    return;  code = code.replace(/\/\*DUPTRY\d+\*\//, function(k) { var n = parseInt(k.substr(8), 10); dumpln(n); return strTimes("try{}catch(e){}", n); });

  if (jsStrictMode)
    code = "'use strict'; " + code;   var f;
  try {
    f = new Function(code);
  } catch(compileError) {
    dumpln("Compiling threw: " + errorToString(compileError));
  }  if (f && wtt.allowExec && wtt.expectConsistentOutput && wtt.expectConsistentOutputAcrossJITs) {
    if (code.indexOf("\n") == -1 && code.indexOf("\r") == -1 && code.indexOf("\f") == -1 && code.indexOf("\0") == -1 &&
        code.indexOf("\u2028") == -1 && code.indexOf("\u2029") == -1 &&
        code.indexOf("<--") == -1 && code.indexOf("-->") == -1 && code.indexOf("//") == -1) {
      
      var cookie1 = "/*F";
      var cookie2 = "CM*/";
      var nCode = code;
      
      
      
      
      if (nCode.indexOf("return") != -1 || nCode.indexOf("yield") != -1 || nCode.indexOf("const") != -1 || failsToCompileInTry(nCode))
        nCode = "(function(){" + nCode + "})()";
      dumpln(cookie1 + cookie2 + " try { " + nCode + " } catch(e) { }");
    }
  }  if (tryRunning != tryRunningDirectly) {
    optionalTests(f, code, wtt);
  }  if (wtt.allowExec && f) {
    tryRunning(f, code, wtt);
  }  if (verbose)
    dumpln("Done trying out that function!");  dumpln("");
}
var count = 0;
var verbose = false;

/*FRC*/Random.init(0);
/*FCM*/function hashStr(s) {   var hash = 0;   var L = s.length;   for (var i = 0; i < L; i++) {     var c = s.charCodeAt(i);     hash = (Math.imul(hash, 31) + c) | 0;   }   return hash; }
/*FCM*/function testMathyFunction(f, inputs) {   var results = [];   if (f) {     for (var j = 0; j < inputs.length; ++j) {       for (var k = 0; k < inputs.length; ++k) {         try {           results.push(f(inputs[j], inputs[k]));         } catch(e) {           results.push(errorToString(e));         }       }     }   }   /* Use uneval to distinguish -0, 0, "0", etc. */   /* Use hashStr to shorten the output and keep compareJIT files small. */   print(hashStr(uneval(results))); }
/*FRC*/Random.twister.import_mta(110798809,-2117707362,-1669736818,-575237825,1969514672,-1787099430,538659646,2092621181,-1801142796,-933128169,-512773138,-1613311604,-1463309550,-557707939,-1052208092,-1711517070,1236956736,-2019528522,1669909270,-1152880858,-519430840,-1548242516,693188540,-1711105725,-1009696835,584897551,251965701,1656259604,705583461,1396920822,1378715025,794804719,286878315,1709653848,1016176447,-1033532674,-1839449355,-357404008,-1644615091,656078930,1053153922,2005714803,224703012,990612575,1682323623,-1198575701,178142939,-66125930,1371837177,435991561,894097599,-1782662514,1340638576,1211965130,-1322989235,1751626594,1537130823,-335890729,-1249012258,1326636039,-698743654,1781051802,-396950171,1778562941,-1683505108,-666275737,-455418954,-941651028,582730575,-624798352,680214949,-325766304,1527923031,-997929673,648137166,1064688785,1350606465,-317650739,-888096876,-923189790,1234817813,-1858995403,447319045,821422924,1795522896,-526950838,-47430621,-271843081,-1096092516,246223023,-1325515675,-42863618,1634904109,-143661639,1093414080,-5770876,1278511523,1238368075,-1582017900,-697246831,-1727675650,428001745,-1085179685,-289419516,1957195051,-586904581,360378690,-1251245707,-638336161,-1740877895,1754499125,-544960269,1466801952,1850700150,1464955749,1637812967,-186752206,19487690,1375097128,-1413744988,514926070,-1158766457,-206601741,-564677589,1964735556,1799091382,1235123121,2106064111,-1618728858,-209882123,658990736,1123977043,-267106850,-1234315850,-2002869110,-1403276753,-306028215,-1262027589,-993020281,2084284063,637881058,962035127,365725889,942161332,1355918484,-1406675878,717348682,-234769723,-826179918,1106949482,1290589901,133688083,1126296087,1363222855,1516934968,-443929832,307328323,1253646092,-503171649,566546379,-127492425,844558757,-1692294213,-1158506080,559697806,-1528798805,409532755,-1541617306,-656541412,1035854052,1333771934,79842406,-95110422,-2083295334,1447780262,1937644690,-636423761,1169712525,116129006,1475881113,-1094099796,-120803493,-1644214674,1868207443,367250450,-1215093293,1627505967,75131361,404500353,1360119714,-1186005235,-1340954454,-264867064,-1302771944,234616836,-734069161,-683586584,365999996,-1578254158,-1548011977,-1605254991,-918171032,-1424734207,-1784740614,-466768220,-1290909776,1457425416,-16969380,-1782795701,-1160091490,1181401694,1320978254,-67917313,-1023546047,653585888,1930345015,636509734,893483991,620555181,1604555036,2012989005,-1886918439,507056709,321790744,1470345560,-1829987842,463773006,893570729,-1231881583,-1910863900,41661604,1324747163,225129642,-752827909,-1048428606,919105808,-1190777796,-1429298333,1553751859,-352235095,1608463106,-294601696,1344140737,1553315251,-1255476690,-1530980271,-240253771,1663517381,-1533789108,-790394433,1117713446,2054173534,-715449225,-1504162111,1314025197,-1672081381,-1186939939,-231901444,-1248367971,-1423628098,-711348432,-758551772,1440753257,-1026240497,-2120187452,506472999,1252032877,1888083111,1040376970,2067268991,-428041788,-974836846,347195973,-213468342,-1071581729,-107496225,-1494007840,576071487,1303852017,1604513479,-59102410,-2017105406,480039706,-192007075,-1397557198,-222454771,1773408420,561372984,41814584,1455030585,1787917370,-197955734,919152273,2096550234,-2132325107,317157138,-247630526,-1312420658,-1987036762,943424223,-1331889625,584023750,-971048116,-237015462,-1885131955,-2135531940,-1660581304,-365483419,507400562,-1706416849,-1923038985,824327904,-297226344,434388064,-2114243814,1008402867,-1166706725,1080715994,-1389863771,-418189790,-1160864443,-2036331196,-1456884768,1374022509,1520873184,-1417647862,-1592346258,1495659747,-2043375502,1192815993,-2110592606,-2139304597,1695104185,388722149,-13309529,-1805323517,-1561957963,-1417960060,-502856400,-1762502286,-242599292,-762554472,-176323459,-841042675,1126428126,1284649300,-1486424861,-1026423008,950242603,-549472684,-585596751,-194508391,1432696098,307409712,-1563073710,-410648589,1298492180,-1729856082,-1726307774,404112551,-1072204213,-209308719,-395586236,815736174,-942431278,-1075741726,1113637070,-1862018534,1558439144,701039198,-953926008,1351749962,300873483,1523145676,-1842549161,395871744,-1729962120,1332770459,-1123207620,1273992689,-2041341652,1412894371,1861974376,-82896660,-1546273077,166516686,2022728648,1557983440,-1581130503,2140898188,-1499701977,-1853059552,-546158862,-324798562,494843771,1535916050,-1260827637,-2085957094,997965062,1663290093,1630231724,258942674,979285100,887028783,-365451489,-1842943071,-1293274139,-880928070,-1944285803,573222188,-1648959498,648802527,-271163241,1833914369,-1038446178,62093712,-1798502544,-1174539365,2109537791,-647027495,1032336806,-1426259421,-690191957,838471919,-717121805,-1657340327,-850522479,-1013587131,531440202,1320035039,-680619708,391074226,-119439638,-1572813666,-586608834,879077828,1750196232,-445565374,58339931,-2002414946,1460426052,1650627314,439158425,645561624,1189950516,-1241974874,-46368398,1139827796,232526921,-1733422194,-34102274,-245294700,-1725830825,-846033586,-510986713,1149788667,739472234,-1403632485,-1796345049,1526905956,564748965,1008810470,509734796,44658699,1847335207,848643023,81168765,916661540,289008904,-1494495747,1111408241,733680647,-558389349,-598902575,1173819060,-1807045564,-1248759942,592458805,-1542981689,-585093224,678018311,-1492036444,-2001912480,-1478448243,2086418511,-593103189,2098346542,-2070078094,1959628568,-1940072506,-1502280130,-937061481,-1948684464,748277575,-2020816911,-852430898,792613585,1839171430,-952660843,1933623073,-659322476,177740168,-1503404898,-289831037,758511480,469883985,1037715183,-73603770,-1669635275,-1354263120,-1506258120,2002313697,1410465632,-1268011962,864509142,-1762645903,-1316322717,-1475191990,17796462,64269421,103374345,-270275434,-224717357,244051227,2127888563,608602695,-876245231,-1610607063,-351091705,-714507355,257138832,-254055709,-555545484,-58680312,1519154541,-1439358541,768935405,984755610,-1175885348,-808414031,-977539498,-167541082,1022717495,-1672418094,878231600,-1490189039,-122573407,1265841421,-282371104,-679690828,700369497,-1493272508,-491983930,-2033683486,507025802,-1589284963,-361094425,51890721,1718970931,1099278825,-419351880,247208184,-933587958,1563704000,-1068271271,-699003721,-441755334,-873941324,798558059,71643760,1482348650,-2003458190,-843710100,1838938632,1503099083,-303250447,115593914,-557994077,-1322062750,540451875,878346003,-1824895036,18641252,-224181573,-1943679776,2008861043,-546865596,-296103090,1587516589,1547286057,542656534,1107441917,440621500,733742461,-1031204445,367171187,-2045908813,1574603050,-556981427,-1913278947,1391807379,-1456081677,16096879,-71701722,-650930955,650866027,1304260757,-1861705533,-1481263227,1654237604,1642872187,896568709,1271334109,1495443761,-1752731050,-722792053,-1479035632,863966339,649213209,-1570220472,2103289758,1040202536,332906806,1526670013);
/*FRC*/Random.twister.import_mti(624); void (makeScript(14));
/*FRC*/count=1; tryItOut("\"use strict\"; v2 = false;");
/*FRC*/Random.twister.import_mta(-2092302635,1967609409,-1796197715,463038708,97691071,1783828979,-1819598258,-530187803,1864275829,-1034032622,-2070580612,-662743012,-733799587,-49113628,1784011238,-1962189897,1855940698,-1277234155,504843779,-465040940,-400151731,689202721,1298585767,-983033177,1654380795,1213622774,10900197,1498286750,-1265150302,2102426758,1295168365,-1909905504,2086518131,1345252868,914199757,684184399,-686162478,184363719,1743312365,1999834441,1203758372,97020745,204006510,-64489016,-416434696,-966088405,410845907,-1224225385,537795965,2123474418,1227831571,1781028593,-1129276181,2087548807,-2058174427,770062635,1634166522,-1152631608,-1173766361,121532711,-649978794,969851210,-1223993595,746226355,-921882358,1812759127,1632024029,-1505146785,536111479,-912549520,15318164,-440894084,497097657,292444822,-1391900016,1879005188,1942834280,545215870,-264883531,1213543983,-1296008848,1885045018,-983901634,501972399,-1755645055,1865658286,1225661225,587809281,50056739,-60451645,-98179955,-1652790319,786666949,-958197666,-134845611,1959500638,-1854504899,-1755910469,1056977625,1673311150,-1202302127,1100447783,69163171,1005522910,-1122833238,-320953281,1829042150,-658201080,-921220270,-795135446,1297489376,-137515867,-1738527477,345528917,-559950771,1853804281,-184614493,461141058,-2094148829,-19787624,745389014,-506397368,-168311129,2091180075,-629270835,1331468500,-1455381581,1897337984,-990870686,-1738130343,410510687,-753342744,-1906339458,1260188373,1073611563,822774799,1072386698,-1578950927,1293959715,1054318748,-1089395810,705142115,-742094229,-304924644,-535794549,1771405714,1012434287,1396211561,-942612572,1204778520,-780111781,1471356468,1725210056,76251589,-1808044600,848093624,-1550517148,-1238289526,1756346535,1329716579,-1020001748,-219346127,486335801,-1213262465,-2050713358,493246588,1329225331,-1405254185,-2004288315,-1038842251,-913731449,313743902,1168934333,863991737,-1322604229,2042022244,-1773176815,1524795068,1595434850,428309740,1003702481,-3322027,-829202859,1051433242,301690354,-392944852,1771488916,421751807,1597254306,1523101981,-1236236517,646229289,85267877,1722135572,-250218743,1910766664,1632919235,-763366918,-583549513,1328396340,964190238,307214226,-952488864,551787713,-256714965,1805310059,-993565816,182811919,2074499364,780669370,-1235819676,54842277,-1695551525,848710539,-1778425791,1497312206,-628448251,485603167,-80029435,86173417,-1380691920,-257553180,-1409333308,1452048178,930510807,1577422737,-648612554,17314626,843716019,-707925761,-1511334682,57098218,-624180783,-213238353,-1157512851,1939702123,238160764,1943268666,1962360855,-1146322212,-903164940,-1689021479,1011429809,1946816845,2022295778,-3605370,215160937,-93571733,-663940575,740926132,-128974072,-784407009,-2106393015,-24652468,-831671732,1900002195,71747576,-1896761604,-608455681,378628843,961174422,-981125338,-1868231785,-1748386512,-588411125,-609213052,-696298555,1488885601,-1587750615,1058449548,-1630180351,880664581,-3541874,-513423133,1388618535,1937212045,-1229846862,-151252940,-588148403,-2104653456,1066386054,-887314008,-1901489190,926816995,1528447505,-824985739,394567355,-662890166,-1952747255,-2109477608,375600390,190911133,1383590650,-130178172,-281346090,661312470,-1854365929,1143054407,548211916,-1662527883,1074390517,-1912195274,386985769,-1391171311,1613003344,-1095436399,-1538911294,-35696183,-462019758,451021466,1165648607,-1602311091,599896478,1240695460,-468946425,-2033597167,-1672437330,1975089664,-285926208,-359896136,-2051860740,-1553812827,-2060329417,-1138370739,-2104042946,1871408750,-1775830784,-1152640152,-1156364732,84290674,-489039436,1453244969,2118361618,-879348758,201224022,23908183,-2061049624,1012244344,-1129021412,-526045111,2111730073,1026139820,-1852234592,-1787889844,1026911464,160831885,-1615129848,-382415460,-833673630,41104928,-1617406920,-1328772004,1182122316,-1205202406,-1679991898,-1572718872,-1810627954,1425716350,102462564,928815748,-1411949598,1271654793,1766137528,469926755,-32267520,739254852,911625617,-782183958,1055071308,-262761169,-2053492551,1911531473,1156656244,-1404681573,418659433,-878596072,-1182794358,-821630139,-1421057005,1711100254,-140986805,-1555639940,252407246,1802933214,-221816723,1424460099,1630512395,1255955599,-1927230729,-1766163595,-9874833,-360858741,1798808499,-1735543535,-2114217506,200075807,-2084442248,-1808511484,-1171648585,1966681067,885581008,-1408896243,-86964308,979114817,-1963375693,-1620718001,2084073905,-455754044,-1361569341,-1069010514,-185151062,-1088885402,121322483,1218154075,1492834103,1431480602,-1623263217,1367755067,-1824813158,1540427638,-355236390,57870083,-1340717856,-755227291,99368457,580389408,-1209009847,1991176507,-1408231902,-326277950,1799631896,-859674530,985315876,-1438391273,1356311021,1334749472,472943259,1860389526,118889194,-244726407,61276914,31544274,1241650498,-100909537,101567628,-2052790852,1692062915,844294859,-51313373,-721119685,775746552,-487705693,952944950,815480570,-96160928,608414726,1525578349,1989449130,1860592088,1394065500,-312827556,-1271843157,-339637839,-1607157968,-208536574,-275467146,-1594027954,-1028244112,288278008,-1000415658,-119592047,-824529936,149352497,1848155955,-263625911,-2103073380,-460781455,1935362100,-1079053869,1330548757,-317751522,-1975833348,-1144562038,-480220416,967572854,-1523405080,350217298,1126997018,-1012179771,-1012955000,1792263204,-1727973213,351564536,1286701282,1042735238,1875591326,165243711,608574100,-724234422,-745525180,-1540766681,1106595176,-1658588781,-534184690,1643400899,1528038117,-1086063661,-390413373,-1665178768,-575292858,-711271732,1897053601,-723099306,1313288400,1242414509,1247183079,-699744067,1457845169,-1820068748,-932448991,-808692273,260031968,-114846332,924495761,-821406277,-1673036901,1441754558,-1400359127,2109356603,1354317665,208759999,257293418,-1057703531,1342740907,1909289423,731124091,129702999,1502533169,1587435210,1092372149,854737399,595490243,-1998474376,-964902474,-14219177,195394255,373113313,-1306084596,-925045633,1223035844,-1352995985,-205475875,753883039,-650463803,853941369,1462167528,-578455107,1223416946,-279665150,1304640334,-1933033578,802366803,1878446647,1007152283,-831116804,-832492415,-2058261741,-1290124557,1057701780,-1112258411,-1859902219,1542351966,2136728713,712515506,1187650747,-1925263553,-1272622802,-956227063,2044685970,-984592870,-1313393160,-615292140,35333994,-771300098,-1238605800,698927942,1081111331,1569726827,-52460990,2036939443,-1542770750,-214822946,-1597599707,-1910868577,43592204,-1527949110,-1631858246,871633344,-1373782016,-1266468510,567543869,-1048165503,-159562357,1290700591,90959151,345664646,-193875488,1028316502,-771095122,-1493843028,-389651005,1311533788,-511808252,1793858592,-1180605291,-557117313,1443709419,1966667836,-79064913,362377340,-2020759419,-2012186299,-1080308834,460169421);
/*FRC*/Random.twister.import_mti(11); void (makeScript(14));
/*FRC*/count=2; tryItOut("d.fileName;for(let w in []);");
/*FRC*/Random.twister.import_mti(30); void (makeScript(14));
/*FRC*/count=3; tryItOut("v2 = (t0 instanceof h0);");
/*FRC*/Random.twister.import_mti(45); void (makeScript(14));
/*FRC*/count=4; tryItOut("delete h2.delete;");
/*FRC*/Random.twister.import_mti(55); void (makeScript(14));
/*FRC*/count=5; tryItOut("for (var p in i2) { try { t2[({valueOf: function() { for (var p in this.s0) { try { s2 + ''; } catch(e0) { } try { g1.f0 = Proxy.createFunction(h2, f1, f1); } catch(e1) { } try { o2 = new Object; } catch(e2) { } g0.g2.toString = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Int16ArrayView = new stdlib.Int16Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    d0 = (((Float64ArrayView[1])) - ((d0)));\n    d0 = (((+(1.0/0.0))) - ((d1)));\n    d0 = (+((d1)));\n    d0 = (((((Int16ArrayView[1])) ? (d1) : (d0))) / ((-((+(1.0/0.0))))));\n    return (((0xfbec617b)))|0;\n  }\n  return f; })(this, {ff: (new Function(\"break ;\"))}, new ArrayBuffer(4096)); }return 3; }})] = f2; } catch(e0) { } try { b1 + ''; } catch(e1) { } b0.__proto__ = g0.p1; }");
/*FRC*/Random.twister.import_mti(306); void (makeScript(14));
/*FRC*/count=6; tryItOut("mathy0 = (function(x, y) { \"use strict\"; return (Math.tan((( + Math.hypot((( ! (x >>> 0)) >>> 0), ( + (((1/0 , ( ! ( ~ (((y >>> 0) , (x >>> 0)) >>> 0)))) != Math.fround(( ! (-0x100000000 >>> 0)))) >>> 0)))) >>> 0)) >>> 0); }); testMathyFunction(mathy0, [Math.PI, 0x100000001, 42, -0, -0x080000000, 0x080000001, Number.MIN_VALUE, 0x07fffffff, 0, -0x0ffffffff, 0x100000001, 0x100000000, 0x0ffffffff, 1, Number.MAX_VALUE, 0/0, -0x100000000, -0x07fffffff, -Number.MIN_VALUE, -1/0, 0x080000000, 1/0, -0x080000001, -Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(455); void (makeScript(14));
/*FRC*/count=7; tryItOut("v2 = t2.length;");
/*FRC*/Random.twister.import_mti(468); void (makeScript(14));
/*FRC*/count=8; tryItOut("/*tLoop*/for (let y of /*MARR*/[objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), x, objectEmulatingUndefined(), x, x, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), x, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), x, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), x, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), x, x]) { a0 = []; o0 = {}; s0 = ''; r0 = /x/; g0 = this; f0 = function(){}; m0 = new WeakMap; e0 = new Set; v0 = null; b0 = new ArrayBuffer(64); t0 = new Uint8ClampedArray; a1 = []; o1 = {}; s1 = ''; r1 = /x/; g1 = this; f1 = function(){}; m1 = new WeakMap; e1 = new Set; v1 = null; b1 = new ArrayBuffer(64); t1 = new Uint8ClampedArray; a2 = []; o2 = {}; s2 = ''; r2 = /x/; g2 = this; f2 = function(){}; m2 = new WeakMap; e2 = new Set; v2 = null; b2 = new ArrayBuffer(64); t2 = new Uint8ClampedArray;  }");
/*FRC*/Random.twister.import_mti(568); void (makeScript(14));
/*FRC*/count=9; tryItOut("this.g1.__iterator__ = f1;");
/*FRC*/Random.twister.import_mti(581); void (makeScript(14));
/*FRC*/count=10; tryItOut("\"use strict\"; { void 0; minorgc(true); } v2 = (a0 instanceof a0);");
/*FRC*/Random.twister.import_mti(604); void (makeScript(14));
/*FRC*/count=11; tryItOut("/*RXUB*/var r = r0; var s = this.g1.s2; print(r.test(s)); ");
/*FRC*/Random.twister.import_mta(720571367,-499935320,821277334,1185504420,-86019936,1088519831,-1455287935,-1596332719,-1596445226,115053470,-1049421029,-119876578,966280241,-1223946877,230037579,-274001515,748579377,-1062963396,843137396,1033466185,-939054746,981722761,1041845992,-829141445,510037491,-968933917,856221717,1398205430,1169932475,-1047680931,155254074,-645173839,-437663138,-969900085,-510832448,-98179439,1558336700,-252122529,1378983186,2074358320,1071811999,1501347054,1602042824,1177523993,1210640352,343286995,1074993343,-610770581,463291903,-1882090241,1321435419,-584501565,-1442375844,1657009556,-11835597,-1646019017,2045742794,-1694946341,1441584468,-579079825,1993647188,-741121057,-655178722,543784959,1231392123,-62638976,1826782240,2046813250,1612516089,-1027997191,-409343436,971701791,-667196157,-809011458,-1376850512,687928475,1603965697,397141727,908368912,2036065255,2069830904,-728270073,-2041290309,2074714680,2046793268,-2090995793,1128030393,-688769388,1920199805,720161871,897898739,1480814842,-224139216,1701961977,102902201,1987667367,821323616,-1118924910,-988790529,637110052,-24897900,332087031,-524125265,-1129416665,-1913090478,-1216078434,158765700,-1005554368,162707529,-444399619,-91282228,-1695832031,147053126,2007755335,-778948786,-741771769,1446958148,-1996326542,525947427,-815295477,1688054158,27873863,-1117266111,777189918,1879204110,648561338,-1817886977,1403642382,991167014,1629718658,1405600194,-856812356,-34010377,1321464776,33187238,-1336891207,1707238421,922251575,1186881977,84123802,-1360515571,-684266013,372335070,596583352,2015396315,-1922927637,-605213662,-1844229429,1617975133,-673493932,1496092590,-1403346423,122880562,-201715183,-2020687589,-511534604,-403486278,-547822003,1570506102,1446834445,-1168854457,-790830191,907216246,-1360261186,-2087980051,1984025246,1886186782,-1324929939,-566505057,347261432,-105997636,1320865036,2112411871,588123868,-548442546,1281007744,2049495711,122339615,-1439627668,-360536942,-977954947,-45531211,-169077204,408584393,-2043232549,163206847,610586502,87505560,1613481583,1173985503,-1566428105,-472651541,-1044286260,-1702852450,-863191300,2068519811,189420143,-1187035020,-670961232,1907044099,734211906,-931648336,-800703193,-705163709,-1473353877,448804906,127375911,-2013592975,-2065845523,-1003336614,-1092905300,-1927109781,-663924510,-854701371,-1343470278,732556900,-1959020350,-1010209381,-1592066776,361339903,149147396,559466360,1165287964,836884756,10039043,-1899391785,848423310,1739160232,-1758204071,-1632219429,479039786,705387582,-769733174,-1424067105,-59704787,-485117217,320279185,-513758731,-718218419,1395058180,475550062,-50187449,213905717,1947252068,94834542,1498200826,-804472821,-179476416,346111798,1201259452,673710309,-328653095,-896941723,1276154930,-1520963354,1111008532,1513266535,1174127565,748438123,-2144231225,-1907753518,367832373,1669893430,387703871,-1083397780,2003688609,99662819,-1985043699,1978704719,-537507970,-1120206551,862969805,-1997516625,936089861,-884802715,-746058393,1648763050,-893866404,-338196239,990256243,400776854,1127724062,1211586124,-1594628687,-856275393,-505636358,-434073659,-1183231345,559023788,-1304378310,426469102,1985991770,1267624522,-830356423,1418274703,1842732421,-224115923,-1889584197,588785283,-325636190,589112957,-1297120103,1845653705,-317316301,-663677478,992184937,1174220655,-898703129,471647246,-1122317369,763933642,-1313884254,975447793,-1477596143,1776993291,-294137529,-501991626,1238290785,-800062007,-1829815202,2030810525,655148313,-1059241913,2000787553,1321536937,-306299135,1711268761,556016821,-1253694576,498694828,763328424,1942320967,1784045969,1192627339,-1661665150,-1822747175,-1887072931,1944675067,-295632911,-277888216,2086606446,-1895744975,1685067930,1905719353,226216250,623538159,-1879958759,2084124666,-1998623389,-1398207635,732384904,-582488298,664241851,-1920157376,-1961215802,-1756624895,-1154496662,56237601,1225558513,-2033400320,1409200447,1711150457,-2094230657,-1864094629,1838570150,-2013846576,-1183775879,-918322503,-517024513,1261941747,426324512,2019027354,-592509968,1047151417,-932326072,1288655210,-579627212,1569229492,1306909399,-1540773769,-2055493918,-1010699974,1773056351,1754987296,-11531357,-458733904,-726474854,-1888532779,-2079526926,-1105872173,823987028,-509779922,1337457598,-1903801207,-356075519,1584462598,194897284,1392959036,1560892915,1915821096,1310772033,1391391745,1642333813,634842854,1950236088,846134222,-45653965,-1234656347,-1921627500,-2037420811,1117564699,-1543755982,1892633586,2112577380,-644448864,-521208663,-741169034,-403133491,-595920447,1985343472,-748363429,-1341790201,-1674692096,963212003,1089838334,1898272148,1741082511,-1893159499,358396551,-1019982197,889184160,490540281,708562565,-1860116370,345307722,1908453566,-1224226611,1412935180,1201207379,2089092695,-824758264,243688929,1424271087,-993468983,-187504338,1483283411,1082424831,-9102436,-1397691221,-891512932,-640197457,86489151,-39033671,542668145,-1446740532,647889437,726280928,1382853811,-511059721,1634298706,1178508125,-925579107,87351817,-1539961252,1883566039,-931701950,500430159,1058212553,-1509082593,-1675773079,-1691664755,-1750464353,-69209834,1563433006,1688830922,1179989124,1031187187,684393102,-600972565,-458098980,-2064543896,1804529974,-220623047,-926874649,-1249921807,1346959976,1620047327,-1227383319,-616980023,-253628202,970934274,2061253304,-995060244,-111258936,823168831,275593803,-750729019,1925946120,1839648390,1678473097,1272954036,983232247,795086368,1285061878,228009856,-1417421220,-852963456,-861525030,-902966912,875297263,-1243699648,-1452742673,-756854129,-2090202823,-1228210997,870758275,-1676527357,-2013304313,907198567,-1617181192,1923848513,-1045059818,1062979576,-1456502928,199917956,-1488708763,-1412320286,241553814,-495522064,-203605154,-634694188,1865259226,1725143052,1060814806,909476738,393750075,1224426710,-27108571,969367078,-955897168,17042535,2120594982,1094612487,1149356691,-444112837,348839481,-871331008,390619656,24169229,-1627019552,1464593128,2123156051,1009069905,1882210014,2087297099,-117868236,1646256880,383125035,398602600,-1863021403,1578073702,-2020223479,1513042486,1133927533,-1755371929,-89562894,1728124323,-313913134,542625475,1010458063,-597375530,1519701569,40865122,-2136178773,-1868804838,-1511656843,1511568442,-1509009081,1550822512,276601471,707479546,-568267794,379525664,-767489396,1331660133,-1760672631,1002855096,2082333963,-772792695,362060689,-662755156,1509602367,639118138,-1791998345,273574588,-70522477,498471390,-1750639297,-975606940,1217334203,-1426709201,-307448977,766440569,200632234,1144054742,436249987,-1965476986,-632855814,-1321533436,-1844870333,-5451013,-438050491,-965167901,755658109,-1017922990,-1919754850,608516402,-880127071,400847228,-2117524353,-2038255834,38841582,-1890034546,-940781400);
/*FRC*/Random.twister.import_mti(173); void (makeScript(14));
/*FRC*/count=12; tryItOut("\"use strict\"; \"use asm\"; /*hhh*/function haftzw(){;}haftzw(intern( /x/g ), false);");
/*FRC*/Random.twister.import_mti(247); void (makeScript(14));
/*FRC*/count=13; tryItOut("L: print(g0);");
/*FRC*/Random.twister.import_mti(273); void (makeScript(14));
/*FRC*/count=14; tryItOut("mathy5 = (function(x, y) { return ( + ( ~ Math.fround((( + ( ! (( + (( + ( ~ -Number.MAX_VALUE)) / ( - y))) >>> 0))) * Math.fround((Math.fround(Math.max(((((x | 0) ^ -1/0) | 0) >> (x | 0)), Math.fround(Math.fround(((y >>> 0) ? Math.fround(y) : Math.fround(( + (y >= Math.expm1(x))))))))) % Math.fround((Math.fround(( + ( ! ( + Math.fround(( - y)))))) , Math.fround(Math.fround((Math.fround(y) ? Math.fround(( - -1/0)) : Math.fround(y)))))))))))); }); testMathyFunction(mathy5, [Math.PI, 0x080000000, 0x07fffffff, -Number.MIN_VALUE, 0x100000001, -0x0ffffffff, -0x07fffffff, -Number.MAX_VALUE, 0x080000001, -0x100000000, -0x080000001, Number.MIN_VALUE, 0x100000001, 0/0, -0x080000000, Number.MAX_VALUE, 1/0, -0, 42, 0x0ffffffff, 1, 0x100000000, -1/0, 0]); ");
/*FRC*/Random.twister.import_mti(563); void (makeScript(14));
/*FRC*/count=15; tryItOut("/*infloop*/L:while(((function factorial_tail(zbwhpo, yogoku) { ; if (zbwhpo == 0) { t1.set(t2, ({valueOf: function() { ((Object.defineProperty(w, \"c\", ({configurable: false}))));return 11; }}));; return yogoku; } ; return factorial_tail(zbwhpo - 1, yogoku * zbwhpo);  })(75476, 1)))x.lineNumber;yield;");
/*FRC*/Random.twister.import_mta(1646204392,91262136,1365619322,1934586641,-1416168555,-330449302,-323834735,609364819,1896034817,1156996449,-905590358,1219680339,67230443,-1655761951,220274471,-1081553355,1572431098,-2135499494,1730868434,-137282363,598861910,-1015652683,-937985998,90118013,169002537,1554185941,281151256,-81736580,-924110491,593932562,988130226,1739085736,958710193,1144616896,-114864274,1145758939,810821022,2106340547,1276291494,838745821,2022305915,1747346871,-962953980,-356301832,-1649031337,-303719825,1879858595,538245902,-964075149,-1091760723,1223241762,-105683195,-1145213610,2138726377,-757147653,-2124700708,-1272164285,-1020127386,-1859433867,1344305354,-494031485,-1913603336,-1470798734,-75174593,-151596323,1933958169,-1731593091,-649930124,1881336673,1847525461,-85015271,320354369,-67239914,-841201579,1512227341,1293551689,-806528098,2143014338,-470780504,14230671,-1685581870,101671657,-1721423936,-1207024526,-215435714,172953530,-474474323,1431237136,-600429424,-482006663,-1695144556,-496478767,458338421,-1547244543,-655869772,-590698916,-403106559,-896524385,1116862937,-335363185,-1574521684,-993049714,-1554711739,220461981,1633214520,1809794914,1854948950,-800666757,4854141,-1334878746,417025813,-1907606365,-1762214893,-1659391513,1501883443,-1174652755,-2014628480,1617880325,-1923232423,-295899708,505639931,-1314283752,-927811337,1252698566,-756971957,-1350440872,-1057261961,375423127,-1747591388,-2110631165,672324552,92461908,-1799568710,-623483129,-301106087,-1925571879,-1118947438,-1939733631,368703094,-964173041,217160971,1927278281,-691946644,-1541604267,-505659636,751362070,-1803493591,213384010,1059551251,-1601778537,-1737653293,1121536532,1072701239,-1920714054,239961769,1339853708,-2037056217,312976112,1257222509,-432207092,-407845060,1288418259,-2021487750,-2034092209,-55230650,1645823161,-1038255484,1632271991,-1326447602,1540774141,-1978173868,-2018831757,767384225,-205294863,1018797569,-1502391054,436318203,-2054894036,-794517444,-1580544165,1101166146,647604070,-983995708,-1338464184,66416750,78478819,-790980672,-431827315,754595897,-1281363844,-1795382879,-1324309265,1490345950,-1103530030,-1118336735,-1162497326,-1984961971,2085524068,437702349,139953791,-1281668249,888325416,-1149518779,1743365701,-1597198470,-1217558091,-1862248883,-1621718401,2014938030,-709560112,98468752,-586307467,1837504254,-1470435226,-1338567049,-1008375678,-706319505,-1814117178,1583259838,540335792,-618254307,895352946,-1724266251,533104760,-1673734566,-703551415,-197628420,-259108197,-752674038,522418927,1716182286,-2103861904,550122586,193093976,-858766621,-1585443946,-313607868,966071507,555854673,170783324,986102429,-763996318,-2055170937,1600840525,-1408204697,-702277624,-1921546011,1776383949,-524632213,1158400159,-1436338994,-161573308,984265932,40501099,-1707303178,2096811785,-1735139285,-1247593896,-21481708,2113945432,-1748528763,-924644875,-691034597,803369256,-1624085940,-673037176,-1407066236,-1686564605,1205683720,17780047,712776897,12935135,789112370,-861564722,-791130782,-1213566682,-1682875773,-1542830971,1027135971,-1337146851,1591838182,-154829603,137028059,1264567171,-1277404261,2066988360,-1785437870,-1306218795,-1798252315,-455026939,-1062533358,-751704072,-854749478,1803935589,1990231145,-797410776,-1330107049,845833863,626241424,863511543,1300445894,-1272231242,-493246193,-1546268301,-1155352535,1476809408,-1125719005,-712610347,-2121615403,-811499995,-1596350557,926029209,-2135856787,239454839,-75650452,-1388562677,514519318,735483823,-1423979522,-19080604,692600402,1636706376,1046665907,1502814986,1699197120,-1452885814,1704485130,-1199200924,-1978401064,-1242873711,-1379274527,-847552465,-782437896,1625998871,14938440,-562010356,1351834692,-1226604494,-100934345,-388417756,60791840,733798526,406844526,-2125016803,-336371155,330067978,-1874823623,-2092665451,2130029169,-1654579277,1678335565,404944329,-1454918408,-2055837164,-993119160,-901628783,1519905996,-1784926225,115652692,1682647802,1898044772,1989379385,1547746347,-880469311,-1885760919,-800471275,992907916,-445757525,-1907587089,-629857668,-1741223784,-812925196,-353013419,-1330236019,1792037887,295613321,-834500147,664264295,-909824272,2102250566,-328941017,-476942631,2073163292,540297257,1626571176,548855456,948050105,-1514753851,-1966481819,-552857904,-1240692904,-1687240039,-61681118,779523675,242353140,-1254164788,1918187491,1033596018,-1095525273,-1817866274,1136441390,-1790759452,-1265097855,538882343,-1665944629,1997512954,1677078102,119100168,-53042749,1025478038,-1580811311,2073220503,978899537,-65951472,255662086,1158900738,1500190021,1674145182,-902147305,-395436116,2134061838,-213871583,2131344252,-1445647310,1155283118,-1325590059,-1765056390,1614652155,-1939844430,-519810155,-260075290,752482535,-1073874558,-615896216,-1481190880,-91039977,-1079037994,-1088794778,2051513217,1257082618,1980854857,55440863,2022291129,-1349574664,1726151152,-418107746,529421182,343340695,1345342396,1826281085,-1000479560,1004688601,523510318,-522562790,986309450,-964292998,-1357013911,-813268566,-231921447,-1696741077,-1226787383,390234936,-1281684296,207912560,497990002,-155131607,-1934833689,-1329031347,91240969,1360902942,-1917364259,-771786516,-1195633633,-1088206592,1254878607,1728666317,1366182360,494761316,-2079953622,2027058040,2007926768,978905525,-2121073115,1529121420,-578336916,1475837220,-60604045,1666445758,-1332481634,-1977613798,311192692,-1117118278,-1420988948,1839278276,172440825,-143289675,2020245707,481262466,-1412934460,182925416,1222661994,-949335438,-1847177379,-1652897469,-1312052309,1538047523,-702556176,1006071078,903360757,314946299,-2031943509,1134903811,-1550972661,1475981288,1927235019,64058555,1041748697,44750846,-587463420,760279717,1264520430,688744341,-990922352,-179475051,-1195320342,1891333729,1951058748,2092453310,-842672359,-1886649371,-733799138,-2008320977,1201343787,-1476647454,1194511895,-1510533698,1771627368,-63295312,347144385,1497096065,829886820,1122640304,376726173,-1251872300,-121943956,-1927836066,-1250366624,-1325864181,1846344504,1439117255,-2230532,-497182793,-1853970523,-1029438992,-2064049666,-82047072,663286619,-1507268523,1544132258,-1101312309,-98001460,1844734035,1715730917,-1036746840,-877186997,326362937,-562282675,-893596770,-1398178234,906860165,1964246754,-356211556,-1963786496,-670150476,1220426864,335147116,393118671,171870325,-1995175895,-1135470843,-1436147741,-1887323816,-480069161,-1540317535,118734196,1527223560,-1018337120,-1060019457,-1521387474,1887381629,1047588865,-1667921932,1138316529,1930012626,1099105213,-1063809280,1219378236,-86262486,851741686,1720111901,1600707813,-1525704420,342098012,-329582554,-1281409927,-861292749,275676475,-1258733019,866000807,-1655754818,-875755436,-1698206970,-281323327,422299024,-478159350,-655670532,1673631711,-33636378,42131577,-1089239631,1868480556,165555635,-691495272,56278295);
/*FRC*/Random.twister.import_mti(86); void (makeScript(14));
/*FRC*/count=16; tryItOut("/*hhh*/function nkpcxw(){f0(s2);\nswitch( '' ) { default: print(Math.tanh(new XPCSafeJSObjectWrapper( /x/g )));break;  }\n}/*iii*/a1.shift(e0, f1, t0);");
/*FRC*/Random.twister.import_mti(236); void (makeScript(14));
/*FRC*/count=17; tryItOut("\"use strict\"; /*RXUB*/var r = r1; var s = g1.s0; print(uneval(r.exec(s))); ");
/*FRC*/Random.twister.import_mta(1059269166,-1778301606,856327817,-813730501,-479857967,1539949846,-348187567,1027250708,-864272747,1190447747,-95907842,1742666857,-1431259975,2120123549,-44170670,1417961516,-62208099,2091410031,-403488065,146006382,-612699621,-1372459250,868820173,-483204923,1142512532,2003351792,-1807398388,-1180626749,-514965156,-1950763613,1407813935,167412405,-1021777803,-856934575,-671860139,-1479021747,2089058774,-2118154509,2070247590,451110708,302108002,1493869827,1066151686,-1581047491,-323516361,-1719195465,-1081777537,-592512618,560601239,2080033647,-1314392630,233766167,-1972418218,1949974426,2068809015,-601179440,-2126292823,-346753361,-1365888481,122944119,-1988174634,-1509451040,2115440491,1418947704,-135733781,653738585,1623528266,-55084003,1489490396,684922292,1615608754,948910594,-1359269909,2041480708,1853541399,-1622492720,-1057050655,2066995035,-1100122027,1554665009,-948800305,-2001404214,617959745,238738671,2139057768,692470444,830731140,-207859420,-1084401337,-1323805767,-1955632247,1681103227,46908613,2130210862,-753962092,1102665651,-1847486508,-234393398,1484538797,695851677,2127092293,1667930553,-713132679,2018256758,-226104893,-1498518410,743513121,1759908810,1134235856,58376357,-1512455256,-408166877,-985212201,1932117613,-967577974,-528772149,-1094292043,-310832200,1962869337,-401679365,444471410,565045664,1208329798,-81297644,2127401913,1033548404,662019329,-1289079688,-1465192641,541304536,2121867284,-946096572,2079293625,978129901,1474218396,423368418,2026214653,231617836,532436198,-1226269390,1549629195,1070718327,-1841491596,1100549858,344871355,-2059616810,-214299535,2116043962,73160906,1615239766,-778809855,-386120580,1392849562,569607543,-978070927,188508649,-1946693496,948334999,-939357658,1414566085,1497727331,1606996767,1681057203,-2072903057,-2047837488,1196246183,731508812,-741395892,-409961576,-612924313,274854520,1669293001,-1763401950,-1304397507,-100856091,1593481250,-624150622,552365166,-636213474,2009053422,426924998,-1413956277,-464633055,-342054956,350205814,-888147401,1310278968,-932834889,1120431414,272337071,22118487,-918874175,1868796820,-103578546,-1043374435,-1643768568,221179616,-712977404,1572142304,-932501168,-1599938626,-1234049781,-1938116384,1326353240,1739713817,-974349403,989400518,-812384850,-428618917,1384201459,58140352,1163728088,-1990043763,182334384,-80355513,482401705,1355065331,-1940877739,-923718236,-681951474,-1487814689,-1760119588,-252657267,1631628033,-69285560,-1395349402,-501930875,1454548907,1083721970,3139598,-835470461,-1291785988,1577645498,1415546367,1845141471,-1160027593,-2093551563,1943071369,1657275719,786127144,1466281772,647428302,-1573281451,1934243697,398093931,943732242,-448009641,1915690353,1438432158,653835946,-1742885913,424411634,-279644262,-1722088073,1591003032,1947140502,-781703025,750097061,1996135705,1374916712,831849332,630937991,-265890855,1931326704,-363944777,762681188,-833134742,1911516774,-1064979589,-1279618631,950615565,-80479442,-1076502320,-672578354,-2021932795,-172358391,-1325966862,1983064548,-1933562682,-450917467,-699387605,-1504557819,1619913678,27641275,-1764939765,-1537473866,-951509566,1511915643,1300185533,507677922,1024171908,-1855055226,-901964492,-1029840479,-729071351,-1718388824,-387017176,1927670906,-1204053210,-2009419128,1673208671,-2042714033,1470685622,73876266,389086779,957790875,-1352546300,515874810,1986851079,-307155377,-861182212,-433100287,-143911096,205334194,1007352446,-267902516,1039902897,-1629450634,459142217,1450171372,1312777226,1429646866,1836107318,-1555935308,-424399697,716206888,893061167,1002513705,-1600681682,445791702,-2013714498,-1708420801,1339277218,740353157,1202069580,735231730,403374268,1076665836,-1815657039,-2071391033,1727510098,-900983619,2044218266,1379363964,-1532023875,-438859366,816075246,-66290283,-1240082778,-1559643713,1849603375,1785612741,2132903806,1158842149,1325636335,-975103655,-1283128848,1024162878,-172088519,1132424715,-1744019026,-520738986,-1510593699,-1509823210,-52271495,1110121888,492244536,-2106358749,1391152201,-567896776,643617176,-117679666,1148131279,526030161,-270029407,-1166693133,-1434073670,-176760455,-1772445089,-62921898,-919469372,-1199888001,-2110849758,-1148317604,685579975,1296774821,-545032072,-2060853618,810472567,1060415007,1355666428,-69659711,-1988182187,748745142,-917485270,129126582,-977653154,-1775203180,716022822,-147143883,-1193152561,985247738,-1744998290,1302159000,1533787155,-336646091,1949503850,-1106134024,-180913280,1839574550,257785280,-1862570367,-184080705,159893819,-353392714,-143304885,568278624,-1119610621,-1123280873,284822035,1501265537,-1102347485,-1964211439,1866527415,1425467441,382815453,561858802,-1500317977,1610316830,-196773741,-2140485644,2018447832,-1471574511,1763861718,735192826,-1180410704,218897216,-413377569,1613484965,727866998,-1838122624,1585034436,185029205,599120651,-1076192998,-2026503141,1147794586,-1891001855,947089213,-757189679,-1514589774,-196814753,-1665564181,-1083058912,1978769558,-1910622695,1743562971,774741808,1734786230,-1670373503,536790115,1949768067,-51815153,-1914590068,-776459582,-1114188181,-273178031,-1932197129,236463425,1038793316,464882439,-756230981,1741787794,421964879,-660406072,2097913714,675677208,-1709269646,1696938062,-729566110,494911858,-954922923,429737168,-5534919,1196305463,-775713409,542795959,702348219,1619744906,-1184832029,1839768749,-1075310015,1537540870,1383887305,-748873757,632832961,-1108530056,760026223,-1103075558,-1683633307,-195272201,1451251316,571462007,1897544952,-2098346454,-1479555266,-1193001674,1437899150,909651111,-84616380,-109063067,503487569,-811543230,1731071992,-1023538439,-881059826,521660189,326475014,1590612747,-275604669,1326703284,-151216703,2050847165,-1265697827,-1817122923,-2111897928,-1234791337,-598640628,1492130146,1032417081,-649442846,-302659471,719890538,1441800144,205788453,44073139,-743688681,536565315,1404712222,-271081478,759707242,-1372029969,-356984538,1101401223,-664057511,1105297913,-1759830346,960043414,-421689042,1386102088,1264858288,922996642,1273131984,2001175760,1179591417,1784365148,-1869678301,-369234705,470713989,851964228,-1009622925,-309367711,180912422,-455595962,-1868702033,636611272,-505974520,815991153,138571552,1129466091,1733639730,-506047427,-1982815808,1425756118,-168786525,615131038,1058950490,-205782556,-1387269480,-1290127280,47340425,-1480952101,250734294,-267591862,277395130,-736585879,-1172344917,-895164999,29426615,600236930,-1471467796,67534046,2075119177,-1533132999,-1573370973,918311511,-481604691,2134807651,1387757727,-221001374,232610271,-1512723057,-1940336416,1782770521,170570303,1197812765,2135683739,167099848,-1227047264,-406292216,-152197665,-968359304,31380589,-298018947,-379813904,-660164793,30145004,-2004610273,2102944198,-19800253,-1320724560,-499906970,-552091934,-634673335);
/*FRC*/Random.twister.import_mti(147); void (makeScript(14));
/*FRC*/count=18; tryItOut("f0(o1.f2);");
/*FRC*/Random.twister.import_mti(162); void (makeScript(14));
/*FRC*/count=19; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return (Math.atan2(Math.fround(Math.hypot(Math.hypot(mathy0((x | 0), Math.PI), (( + 0x080000001) >>> 0)), Math.fround((-0 >>> Math.fround((Math.acos((y >>> 0)) >>> 0)))))), Math.fround(mathy0(( + (x % y)), x))) ? Math.fround(( ! Math.imul(mathy0((Math.cbrt((Math.fround(Math.log2(Math.fround(x))) | 0)) | 0), (x <= 0x07fffffff)), ( - x)))) : (( + ((( - Math.acos(Math.max(Math.fround(( - Math.fround(y))), Math.PI))) | 0) >>> 0)) >>> 0)); }); testMathyFunction(mathy1, [0x07fffffff, 42, 1/0, -0x100000000, -0, 0x100000001, 1, -0x0ffffffff, 0, -Number.MIN_VALUE, -0x080000001, Math.PI, 0x080000000, Number.MIN_VALUE, -Number.MAX_VALUE, 0x080000001, 0x100000001, -0x080000000, 0x0ffffffff, -1/0, 0/0, 0x100000000, -0x07fffffff, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(505); void (makeScript(14));
/*FRC*/count=20; tryItOut("/*oLoop*/for (let pgihmz = 0; pgihmz < 167; ++pgihmz) { /* no regression tests found */ } ");
/*FRC*/Random.twister.import_mti(534); void (makeScript(14));
/*FRC*/count=21; tryItOut("h0 = {};");
/*FRC*/Random.twister.import_mti(544); void (makeScript(14));
/*FRC*/count=22; tryItOut("\"use strict\"; /* no regression tests found */");
/*FRC*/Random.twister.import_mti(553); void (makeScript(14));
/*FRC*/count=23; tryItOut("\"use strict\"; mathy4 = (function(x, y) { \"use asm\"; return ( ! ( + (Math.max((( + ( ! ( - (y >>> 0)))) >>> 0), (((y | 0) | ((Math.fround(Math.log(Math.fround(x))) % y) | 0)) | 0)) >>> 0))); }); testMathyFunction(mathy4, [Number.MAX_VALUE, Math.PI, -Number.MAX_VALUE, 0/0, -1/0, -Number.MIN_VALUE, 1, -0x080000001, Number.MIN_VALUE, 0x100000001, -0x080000000, -0x100000000, 0x080000000, 1/0, 0x100000001, 0x07fffffff, -0x0ffffffff, -0, 0x080000001, 0, -0x07fffffff, 0x0ffffffff, 42, 0x100000000]); ");
/*FRC*/Random.twister.import_mta(-1657786823,-366979139,1234028919,1348183672,1465732465,996821657,318772114,-463662202,295560619,1226266261,1425437971,2036830467,-1954390905,837975273,-88514921,1378547118,-287618861,1075754550,-1288919044,-1788151886,-363008380,2111847086,-1200895314,997708619,-2046828709,-2133973481,-1432827383,609339551,-905632045,-780059462,996607842,-411059973,188470244,1922591233,-1297328991,-703869190,-252373136,1449171625,-1261048022,67960305,1389476225,2146288678,-1567916489,2099449156,-1951231936,-842181707,1306699712,1986471310,600035699,1555697279,1354126421,1027918742,-1463604196,18236406,-632191689,1158716768,1406344872,-1145960122,1421835261,1666434736,2100187712,-2124051492,-1237734979,-1123935671,-1102837648,-863251286,716350045,-1109671380,-1442882383,-544096376,-1869438986,-2140339605,1094580582,-1249878573,-582383533,-1633258051,-38275267,1587350589,-1974073163,-1829269856,-565911017,-1371070415,1251371722,583038534,-743036669,22854930,-966417493,-2115489717,273093756,-52073044,-1026717735,-119141833,-2044928524,1143938407,1178339655,1398130924,729794988,644581098,-1475600816,461500805,-2047809428,234351993,-410789666,1410737609,98000975,-315625544,1164522781,-1558163902,1064966067,-1442259742,-1083587008,-845942509,443058349,-631889120,-147331733,164320071,294815268,562641674,1718863148,1378413348,61041110,2060189736,-771676983,-1451385929,-399391493,-259059742,-1390681631,1592598741,-767611436,-1990589347,-6511826,-1139840543,-1180215792,-224056020,-513031424,-1887251765,1394017606,60440406,433376810,613039437,-1726281689,1520745892,-1894049653,-1106792856,-1398397692,170749889,1052126938,-632986308,1908591826,651790697,1296513960,-1889595293,-613462228,-256545449,-342537335,1310301076,-1307833148,1649305578,-1719944991,623151437,1594963391,-1222687613,-1443479380,-2127930085,388071149,520386816,-851463840,-480910493,-784164828,-1444444108,-1743517622,53485745,-2089106262,-2103244385,-1901389780,-1531528687,76380641,-654666196,1601567721,866607289,2137583518,1180722135,-959157318,1220378674,456474399,1778205770,1295476558,1911324705,1158538209,599727967,1999758982,1987103357,523182501,1369715069,1258649178,1027127609,-1906420421,-857588269,311019263,-1290132366,-1123101127,344643823,-1789621042,-1492312180,506155138,-786147837,1300960654,-535042227,-1221786949,2129682939,727398308,728049081,-1566089008,1384118947,287366259,-1330366645,1897685128,-1926960862,-1291079488,-882141476,-1022408335,-1675054625,393820700,-1935133932,-1268886955,924163199,679101507,-1115944384,-365452358,-140729239,165401094,945371052,-2008205127,-1124733790,1614287426,-921817746,-1443392754,-56965265,1846164887,-1607431407,582549646,1923956450,-1299751223,2081345337,1547611455,411165192,1970653653,-1065176245,1855743483,762163074,2010239922,-1303010154,1433080947,-973952571,508971092,2075755083,517162295,-1726809807,-813272881,334582366,-111315427,330796434,-1350232958,1557853684,14307611,-1812053857,2096843458,-342109981,-1086833627,1742164462,1085993171,-732405720,-1506151982,-1755842659,-1783457835,2075688330,665033357,1456882230,-691814757,1524859990,-885534293,-1441304368,-590688414,-1044563342,-375650275,924579100,-1756072366,-1030143423,-1908093523,-1464048001,-1246423286,-614824214,885888165,-637554170,-250447368,-578283611,-1495053899,-1936764315,-999269585,-1444358122,798472491,-1231161208,-1667902424,1864841471,-618733137,-1645810505,-576175779,2088381003,26675145,751032756,-924879975,-1476386137,1195519563,-664740204,-1175707475,-676171525,-208328041,376163618,-741218367,-1593610255,1857309294,1887726172,1123348278,-1053987036,1932771198,731458200,-1620454450,-1782895365,1086256018,-461419775,-2146738807,1648279454,1647783205,1723475259,-1228336837,863999981,-1977708012,797103175,383765423,1762874244,1719179681,-1948532570,550561145,-1697799387,1398996935,1042410971,-182033103,1487504005,-1304400856,1008127617,88215434,-677312700,1259273391,328375369,-451601242,-1946309332,-673203646,1548419693,1152937531,-1247713593,-2099364217,714630769,-595450816,-1267824987,1653584262,394217782,-1128575101,1768300252,1974990648,-600477625,-2105965937,1469652540,-1668770378,-1873983275,511116186,612380175,-982887158,-1620911528,-247406136,-1074377138,897599799,-1434307304,333353914,2137666424,-572306329,-1229323043,1739613706,-1640042661,831366995,-2121225902,634283044,-896101992,1230242267,-375941643,-1601385672,-207650549,-486551938,-851256743,-1582960140,1174569874,-536879518,-2057986021,-1032317603,-1339025609,1946533609,627864412,749714757,99832414,817018076,-1048914598,-641169491,-121758561,-1271525368,2017506453,-1822516389,367164625,-1542085887,-1329636782,-1492811861,-1432736198,-678870989,-1753512179,-745508675,1026396668,1585589090,37184134,962326494,-755800010,-1214196615,-715002060,-617965728,-1828247723,-1514838936,1482819315,-53884651,-240447717,-732496693,-1035571543,1054083714,-1415619568,1027809473,-1918122618,946235921,1861299205,1471634416,-784381299,1439165187,104746544,743381224,1168483013,1870852068,1661608575,1756198639,1384289288,595304851,13190920,-527799311,979930205,-1352038221,1589307991,535220412,-951841766,-1879114968,-1054112145,995695749,-2133238688,2136128181,-54680847,1817732048,643115925,-865069637,802579574,-1927674640,1495550385,-1106805518,2059364343,543351099,88297365,-1743487321,466941130,2138086704,1385753148,-580585720,-461577229,687574865,111408203,-1642619044,-921118120,-1777381444,1079637515,-635024373,1829294232,600361124,-866291220,542065116,-1580291559,-1468437754,1603978078,8533317,1159688694,-65545049,498978737,1127572470,651524504,87138729,-1968070656,809093265,1227061031,-1754456718,964531599,397722757,-833854788,1150087904,790873073,-1490596282,1489473276,-1593399044,64671312,1973123988,1396991487,2072595513,352612857,1590155924,1983089312,-847237831,105619931,-943692784,1139783066,827457483,-1338969895,-2133496808,-1905609318,-1222712481,1115880208,-467477811,-1320571875,-97074614,-519935722,-1611928230,300299646,1450464188,-860861378,778684007,1185431268,-275530495,-665032550,-39853254,1574604537,432764152,1732703598,-626226955,1455589014,272296176,625406573,-1600746283,-772718628,159976873,1459924500,2069710652,-623465021,-1988811820,-206745176,18056142,1532546460,2105155875,640971563,-1471518749,1650044465,863654924,326793824,858667492,394964775,1415334448,1456903999,184324426,-1378923899,97046131,1407579846,-1909712020,-1821417036,-1723394053,-1569853491,-1275346295,-1617174241,-279971578,-2134939343,1241233604,1530269571,997922736,-928533706,-160581430,-967776643,-1673992587,1957682829,-1422883032,-585440719,983730857,841675295,1861286541,1131317638,464465613,1482386410,-928388228,1501019338,634977417,1475192922,-1156804438,787355239,-647624292,-241110646,474886724,67409550,413990844,320756210,1801783335,1902664613,484052994,1533170887,1828114150,301443587,-1735551290,-821619639,126018160,896494013);
/*FRC*/Random.twister.import_mti(63); void (makeScript(14));
/*FRC*/count=24; tryItOut("{M:if((x % 40 == 6)) {for (var v of i0) { try { Object.freeze(m0); } catch(e0) { } try { b0 = new ArrayBuffer(96); } catch(e1) { } try { Array.prototype.forEach.apply(a0, [(function() { try { o1.a0.shift(b0, m2, g2.a2); } catch(e0) { } m0.get(m1); return a0; }), t1, m2, h1, v2, o0]); } catch(e2) { } v2 = false; } } else  if (Map((4277), (x(7, window)))) (let (e) -23); else /*ADP-3*/Object.defineProperty(a0, v2, { configurable: false, enumerable: true, writable: (x % 45 != 16), value: f0 });let (z) { s0 += s0; } }");
/*FRC*/Random.twister.import_mti(417); void (makeScript(14));
/*FRC*/count=25; tryItOut("mathy1 = (function(x, y) { return Math.exp(Math.fround(( + Math.fround((mathy0(( + Math.min(Math.fround(Math.imul(x, y)), x)), (( + x) / (mathy0(x, -Number.MIN_VALUE) ** (Math.sqrt((y | 0)) | 0)))) >>> 0))))); }); testMathyFunction(mathy1, [Number.MIN_VALUE, 0x100000000, -0x0ffffffff, -0x100000000, 1/0, 0x0ffffffff, -0x07fffffff, -0x080000000, 42, Math.PI, 0x100000001, 0x080000000, -Number.MIN_VALUE, -Number.MAX_VALUE, -0x080000001, 0x080000001, 0/0, -0, 0x100000001, Number.MAX_VALUE, 1, 0, -1/0, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(584); void (makeScript(14));
/*FRC*/count=26; tryItOut("\"use strict\"; testMathyFunction(mathy2, [Number.MIN_VALUE, 0x07fffffff, -0x080000001, 0x100000001, 0x0ffffffff, 1, -0, 0, 0/0, -0x080000000, Math.PI, -0x0ffffffff, -0x07fffffff, -Number.MIN_VALUE, 0x080000001, 0x080000000, -Number.MAX_VALUE, Number.MAX_VALUE, 1/0, -1/0, 0x100000001, 42, 0x100000000, -0x100000000]); ");
/*FRC*/Random.twister.import_mti(616); void (makeScript(14));
/*FRC*/count=27; tryItOut("\"use strict\"; /*ADP-2*/Object.defineProperty(a2, 14, { configurable: true, enumerable: (x % 4 == 2), get: this.f1, set: (function mcc_() { var zhyqas = 0; return function() { ++zhyqas; if (/*ICCD*/zhyqas % 9 != 5) { dumpln('hit!'); try { print(uneval(i1)); } catch(e0) { } try { i0.send(g1); } catch(e1) { } v2 = g0.t0.BYTES_PER_ELEMENT; } else { dumpln('miss!'); v1 = t2.byteLength; } };})() });");
/*FRC*/Random.twister.import_mta(559563096,1550558608,1848594606,1834600453,31995272,-872932204,-2111922444,-1513882397,-1729140535,-1612957933,-1605883392,-1401214400,9133041,2107414585,-1851038136,441648318,407891854,-1966552923,1599538952,-784608189,-833665275,-1154442500,1848211264,1283333953,1309943001,534029670,-166869652,-494401324,1794637019,1692953711,2017723540,-230867573,1965386475,1534332399,-134037464,-573575216,-1436877960,-425509248,715505980,1681297620,-38761286,-1231485626,-720446798,949643489,1917181059,1586969073,1438826178,-547486826,1718287725,-460033546,412888059,942575334,86934334,-610099808,25324751,1095039419,1331400875,-802378574,828417104,-568507695,987384243,1836969138,-1724688468,1086641284,-1593711025,1135549145,-540645511,-156368382,-284064860,924579150,629379867,214343523,-1516391005,1004298573,-108138889,1791578033,-1352499344,572835959,868524199,-699916049,-882348206,-44086334,179621865,-811386514,305575093,1734252034,1031817993,1624769903,953238173,1719266415,744714140,-721346234,-1152989081,1613822071,1151481070,913779826,-546786663,877219572,1963385348,-1434378448,-2140568259,860084522,-1239624755,1744100447,724187245,-1198962265,927293113,-1014752593,-1615475087,1871522737,-1226686607,1129441787,341214239,-181958929,329350080,1279635954,1072127604,-1809929008,1909717870,-1596515305,1052560964,-980199121,-1628301061,-1768350053,1833170440,-1857905989,-2142393835,-459293741,-605154518,-1207028345,-2065649227,1837257923,-916298161,-262107752,1352887328,-560635396,1129309371,-389497384,973341284,1874065030,-1940899900,24039872,1323688522,2572606,279857921,825413898,1804242042,-1754080408,1379409137,-616792338,-1015171561,1954337646,-2045447398,913219054,835603292,154988178,1415692696,891543674,443272101,-1089919063,-712786806,799434602,55260049,1542270077,-64000728,663509886,-1275425550,366701873,1925691185,-465542202,-1161228618,851916377,-886878608,1954264562,-589741328,-1894627809,2058083369,-61940639,756304390,981252540,-371361806,-1387909455,-147742291,232077483,-1768731160,-1788841682,1046811088,1421981737,141055553,1919110023,-116991390,-1377552451,2038242135,-739310617,1103366718,35617847,-1948880709,2071778440,-996675576,-47361686,-513331529,1683668202,283641408,1421510284,-373166028,-1368628805,-260898893,-414790389,-1315100552,-1365177480,-1571539868,-936003084,26721284,-1915294558,-2057945612,1612894200,361508195,853594183,350064843,-464190363,-1937851145,659182568,396604297,1537871667,226847401,-1967689586,735145117,1413582981,-1095940229,717404589,1903514579,-1664739061,-1786582331,-234711083,-2126189996,-871063218,2023351419,1313178644,627826455,1373100982,1154090824,299923955,-44248067,-1353184818,-2037892703,-52079811,1752317241,537511207,-1383707331,1438752409,1431620874,-1112990145,-1541062309,-1188634298,1180465454,-57217377,-244735960,-2037412820,-1144679260,-796696262,313510694,-272610711,-1281190614,859792170,1985261072,1423467613,-923547526,992223863,-982340175,1817907716,313940213,559490154,-1942719776,-2045557257,-1568522925,-323780364,-805351187,-1426766743,1432308941,-1178739916,-1901517368,1877412734,563766402,-1566759814,-1952360900,986357625,643388206,-453992518,-1607766190,-1008083927,761894897,1651481794,1867563994,-1487971451,23247119,627611553,-397087581,-558690733,1479734120,1801378281,546479369,-1211693981,-2074975471,468041592,-169931021,-1005047594,830309653,1386962025,-348215528,-1210857734,44800226,-392228017,1265563976,-125899904,-1844867635,-669817079,759958270,-1669124957,478684769,-870519472,1483918681,1708671861,383884256,-1494127322,562420664,2058488803,2035562898,-533267212,-1737175947,1863437782,384533392,-2093408736,316468197,-1255577861,53698950,-1699051653,-1589317299,612723321,2010660921,-1100842992,-255170884,-624838237,-668217153,-815886008,302443234,-767002327,1435200906,664598608,43028144,-1672274114,-1119249095,-1848887168,25388096,-1295571898,-1587450555,-1342058997,1327694958,1068775031,-296069249,285592019,1008995967,2128772608,497717873,839400568,-478734013,-1118759558,453048808,-1232352168,-1233331908,-1764650030,1810615840,518652378,-534985281,615583159,473595056,1888302708,-1802693694,-1143093517,730330185,1172072286,590317410,2015429249,915011374,-476522636,-143240501,1773402272,689889499,340647932,795751363,1370227075,2124833969,26074394,-1974525605,-474158738,-182706837,62410766,468303413,-367266228,1371961232,-455302847,-1344678624,619575425,1308818779,-1717455998,-285678129,-1572133765,948244627,-242995812,-1912912868,48059044,-394099141,-863484436,1883806651,-1362957150,-2026359138,-2090191074,708634286,864867688,-123133792,-1951331439,22704318,-1325104449,1552528585,-1533582070,2053596619,-667285529,-732633743,599782484,250235760,2105363952,-2077121031,-1155841536,1532351005,1461627878,110885465,1119807170,1451920627,-46255835,-570812420,-968975173,-1962733983,1080932387,-833427163,1045921947,-2089302562,-415836779,-414571651,-1705430909,-1668271531,543343739,-215503149,-1596235519,-1544144246,-1553724277,1411724033,400605788,-285323428,-3594411,1788075263,-1703837029,-778006056,-960784448,898224806,-1136796954,1311320612,-1010158958,-159270383,853948064,-1681761050,1114401279,-122471435,-2147140647,159369018,2003927872,-1000421885,616533375,-832009844,-1068088698,-264018854,-1684205629,-1872063400,1760428714,396373945,1008523103,483837654,-1261544694,-1274082282,1504210168,384041395,129565680,1169886054,1739639362,1928780971,-1730910060,-1295267932,-1857152974,60191659,-1946160504,64396433,725036140,1371869936,-2095543128,-2540488,1416573158,-1347578775,-1807017894,69521528,-2061522063,-1437503130,-1287080417,-2051336924,-370725044,-1269576098,902493197,-2003609404,-1331152084,-2113619199,396634683,-758833438,-878914279,885380006,771839045,510743281,1469860576,77491809,2077409632,178848548,-1590504909,920112336,-1002908387,1557194165,928567171,-1520874146,-1704699732,-1828242760,-1775909315,-950865295,1298034255,-1603532304,1616171158,-567882337,1547034145,-79202181,-2087885663,-257091346,1648875516,1006181107,1419212581,1450916290,-1564512443,-846188947,697872320,-249970166,-266875097,-1999740134,1169750654,1150524124,725950478,928708638,1449556495,-855650769,1136304225,-1223237195,116478211,-1365777613,-84557033,1447436247,-378057542,-746814317,-1044591539,1569945092,942198778,1613464169,1358243119,-1468797491,-646162090,-1247681443,-1168142193,-662992806,-735551646,2063164287,1637104862,1724157531,948238573,-421318096,-1968731363,-1516863795,563709351,1521592219,1721519636,-936837223,878959270,1577994979,244890236,1091440031,1915038903,382491138,-979696711,1063077145,1958994438,144488514,946768142,473360401,527031641,-1876225314,906083356,-1952195406,261915564,15825476,2024730124,-509961165,-81777387,1614599257,-2052795369,-1242479887,553860034,-451568833,1222443970,-1870743356,-2046170568,490197909,-1227002797,-2147003377,189046425);
/*FRC*/Random.twister.import_mti(60); void (makeScript(14));
/*FRC*/count=28; tryItOut("function shapeyConstructor(lxjsxp){\"use strict\"; if (lxjsxp) for (var ytqhjcatr in this) { }delete this[new String(\"15\")];return this; }/*tLoopC*/for (let c of /*FARR*/[ /* Comment */return, ,  '' ()]) { try{let rxesbp = new shapeyConstructor(c); print('EETT'); v2 = r0.exec;}catch(e){print('TTEE ' + e); } }");
/*FRC*/Random.twister.import_mti(218); void (makeScript(14));
/*FRC*/count=29; tryItOut("/*oLoop*/for (let rwvsug = 0; rwvsug < 74; ++rwvsug) { /*oLoop*/for (var phsvdz = 0; phsvdz < 81; ++phsvdz) { print(x); }  } ");
/*FRC*/Random.twister.import_mti(266); void (makeScript(14));
/*FRC*/count=30; tryItOut("mathy3 = (function(x, y) { \"use strict\"; return mathy2(( + Math.log1p(Math.min(-0x080000001, Math.cosh(Math.fround(( ! ( + y))))))), Math.acos(( + Math.atanh(mathy0(( + x), Math.max(x, Math.min(x, ( + x)))))))); }); testMathyFunction(mathy3, [Number.MAX_VALUE, 0x100000001, 42, 1/0, 0/0, 1, -0x100000000, 0x100000000, 0x07fffffff, -Number.MAX_VALUE, 0x100000001, -0x080000001, 0x0ffffffff, -0x080000000, -0x0ffffffff, 0x080000001, -1/0, -Number.MIN_VALUE, 0, -0, -0x07fffffff, Number.MIN_VALUE, 0x080000000, Math.PI]); ");
/*FRC*/Random.twister.import_mti(437); void (makeScript(14));
/*FRC*/count=31; tryItOut("\"use strict\"; m0.delete(f1);");
/*FRC*/Random.twister.import_mti(450); void (makeScript(14));
/*FRC*/count=32; tryItOut("const ylqtev, x = ({14: y ? false : /(?:\\3|(?:[\\xAa-\ufc89]){3})(?![^])(\\ubCDa|\u3159(?=\\B)*){0,16777215}{0,}/gm,  set length x ()[] = x = this }), e = (({x: ((void version(180)))})), xswdgu, x =  /x/g , fxhnwq, z = {} =  /x/g , x = /(?:.)*?(?:(?!.))|\\D+?|[\\W]{4,4}?/yi;let (x, gjuuzw, yjozhb, pjspoc, zhyknm, NaN, c, window, jjvadx, x) { ; }");
/*FRC*/Random.twister.import_mta(-1415642179,2016917786,-67429418,1627508825,-969999465,-1585284107,74303810,-1786077851,-1404039416,-1437493964,-1067841212,-268425491,1335929466,-835931013,-1270919307,-1362568150,-63351324,1662321840,-863918224,-136759997,-706120842,966063503,275422910,1983341312,-1310218951,-95436716,1159690081,922466031,1386382631,-277058933,-964993255,1836064045,10359114,185580460,-590956590,-995104585,-546604212,-773315881,-415913391,1848063758,-942843611,-74393906,777041682,1629004805,1195988358,2100118029,-1446356224,-423979287,-1602069570,-316578051,-2093270490,340752055,506502690,-567758817,-321623983,-2115712659,-1808478448,-1065644062,-930416179,681387865,1040885333,-488044969,-339711768,-141711872,-1611611971,1967848848,1950852976,-1731548572,2042169417,-926199180,877431870,-579015055,2032421737,131870588,1144075143,-71063087,493541369,-1194762749,-1752739944,-1200377788,-1884998009,-1089159430,-1977785535,1981958312,-1413802341,1598031919,1888065850,-1957612696,-836164192,215017157,881703536,-123365105,-1614339120,-1947199379,1660640288,969808168,-1316367413,392368717,1959164504,1727054372,-1550967159,-2058501620,-504053045,-1692981984,-414288685,2012130051,203362200,-1685667051,1525545276,917977694,344741052,1483810454,1760923341,1153117551,-956216873,-1211248312,-1113597309,-1647052337,-245818765,676273626,36160016,1626264663,1922937178,369609086,1199739596,1086765088,1693106336,-485268108,1209478686,2016402050,-2125820157,-883912977,1729428534,187250813,451911589,219640052,889233495,159578517,1961647613,-582816907,1737461736,-1476962913,1039185234,-1875896429,-279066659,1300278855,-1804242214,1805906128,-937781731,-7365277,1417874541,-1016560081,-616492676,158705993,956396526,753189794,2041013705,-584947294,439418046,2018581073,1234834781,356908582,-505087149,500669357,2027692815,64341720,-2077589632,524539838,-1845932852,-779365425,1791694678,-1630604650,-616990340,1501961980,-1418709374,-1718489963,1020854869,-1548591292,-1981628164,1621751764,-490556359,-1869083230,-1684507011,-919368385,-2013760422,1508929521,-2137670171,-1329440413,-1649599143,-2048409234,2032890399,-676323828,-1383357520,179354972,-555977354,-1834781528,-887426115,-258699596,-122969346,-173242116,1144412605,-125516537,530740303,-1590266036,1214765808,818580039,1808689311,-909502793,1594523385,-636318594,1342887261,-1405146903,-877607423,809309534,1640864112,244282809,1841796922,1051726636,1907529285,756107923,1649054308,-700615153,165175649,-315128366,-262663196,-1665855072,2097179163,-1094509990,223530831,-1479007735,1215154658,-1314070755,-386449418,-1281121932,74894173,1385782299,-1135352128,-25898188,1790427347,-1367357895,-584107214,953568231,-1699113414,583349014,-704981570,990299248,1581122231,852177376,-1349899163,-1793042297,1288504127,-1402358185,2017058416,-2068041270,-1442173251,-567106194,-2141592955,501944549,-1271618857,1274165577,-1810762547,-1221248824,-887269024,-281168041,579778370,-246308876,-1177670383,2121109545,722216009,1938970231,1493365439,403703734,1375065502,2135625273,1786240213,-1614999068,249390726,-2108164850,-399226289,817776840,-621346882,1943154832,-1498041973,-263684043,-1726041380,502498129,-1121671980,1903276708,-1203843160,1179080215,-211041329,-1693030703,-483666288,-197025837,1534107110,-448970036,-1476326839,-216675968,59888960,-806888247,-982464153,766451736,-175793712,238471307,-1822690878,-1706582017,617110254,-195486079,412131751,1703604300,-1336810768,-1114574582,1039794600,1188197172,913805305,-728569077,518179103,-676996268,744564067,-1178573846,1761960055,-798315222,1893140529,-410693105,-1841699037,27182480,625387096,27983863,-535438426,379480720,1762048827,556880896,-1200093942,2055870446,-1039058553,1013335106,421168534,1202555747,-182260419,1962175656,-1059075542,-519643849,-860964158,-1649095137,761008270,1327233705,-405727856,-564009952,1339334195,937208619,-1329859502,-1315671920,-1551919062,1893357751,381526286,-1164034397,-783809621,-331840884,1339108392,-68912453,214891312,2023135061,240053739,-1537292269,2143082832,-2131006723,790752946,1102354294,1948692172,-2063717989,-1494932031,-1380662276,-677608130,1359109308,1231831141,1388754818,1471547272,793556381,1852819441,-1552511918,307542214,208918352,1761480946,-725962699,1668502942,-1862133294,-666011700,-1618602743,-1372806707,-655118264,1543392635,-1907459475,1486664271,984784742,-1470125575,-1896940263,1753009488,1141831356,-1460138876,510723154,903239632,908821740,-716771223,666072899,-1556725301,-1792777143,959266135,1174971494,-2082878025,1231729948,1967079749,-793523157,-457140070,-576658235,-1895682104,-1648057859,-319021547,146843107,1172278624,-114579917,-1104391441,-158380796,-651321943,960127033,374644057,-1342185176,-1379060538,-1711990526,1128993897,1868203235,961015805,1663296386,1191782719,-971267455,-1606127308,-1198655168,-659610070,1293711423,-44466384,1069515229,716526092,-500324099,213680827,1271260949,1324762891,-541521896,-771376211,-1634917595,-1625625749,-182666594,1157747109,-1300831770,1611056850,1505771903,-1340043158,-766961537,-1914981242,723118224,-1303978015,-1876124155,-1341715148,59595523,-1613085311,598452559,1752600432,-1665553595,-799502948,-231475605,2141153592,1531279980,124654837,2127127648,-787329377,-1837986189,-2039262955,-1870014991,-1250756745,1549039775,-704839633,1501360161,-713321409,1970854743,-1935702963,2068270230,1919954115,1528432147,161696073,1256323920,1419822548,1145793272,-816671735,-1747109646,-880321608,-746847779,-341008992,-1183896980,-1691748218,735407902,1396183354,2112577831,-1774447602,1252649487,1055249940,289083444,-1573777864,-2138802981,-307465564,-25246217,-1917145832,-1147338050,539528280,2022038097,-1968295940,79112594,-1962450907,-1954261834,645504911,1357282294,1808336011,-347717583,-1504240772,-852641572,-317555871,-1774198228,921095415,-642514286,345094237,-2090929525,-1500913062,-1164852642,-852216719,-1638905816,-1287225034,141961595,1811767979,-1060668154,-1039769283,-683684782,-1330184813,-1111386345,584851275,2118025968,722129732,876679994,922199203,940354678,1397841279,382937868,-2079080693,1403531992,885461910,669170155,-1879223743,-829010844,-1297418178,378813136,1965739027,-2113215540,-1191846089,-1836258389,-732537019,-155267270,499931551,1150161652,1838779174,-1692121753,1353643910,-1588005172,-1335520170,550457961,806998697,-982849301,784927152,-954680496,-1161604169,50161691,-1651776621,-1174049159,1975030396,-2119497784,1910487897,952022015,296739474,-821374731,2107897856,-1347242007,1027395007,1385049080,-1654044429,-116967806,772237952,1243928330,1747683061,-1924138953,-1154209353,589135297,-945091420,1409834957,1953650962,-627852069,116662382,-1175097546,353952373,-770706844,-815576162,-527456572,-612544531,392041162,769887373,-945807273,-1809532817,-1865481016,-490715982,-1994824578,1549478909,-25555447,-436513438,1012261155,-904052902,1122420131,-391122196,-400680792,-1057831443,-457442223);
/*FRC*/Random.twister.import_mti(567); void (makeScript(14));
/*FRC*/count=33; tryItOut("testMathyFunction(mathy0, /*MARR*/[false, 0x80000000, 0x80000000, false, Infinity, new Number(1), Infinity, 0x80000000, 0x80000000, new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), false]); ");
/*FRC*/Random.twister.import_mti(622); void (makeScript(14));
/*FRC*/count=34; tryItOut("\"use strict\"; if(yield) for (var v of f2) { try { a0 + ''; } catch(e0) { } try { o0 = v2.__proto__; } catch(e1) { } v0 = (t0 instanceof g1.s1); } else {print(uneval(i2));(void schedulegc(o0.g0)); }");
/*FRC*/Random.twister.import_mta(940911153,-1794801297,-134652767,-1882613052,-1963575,-1754262328,-1266775762,-182565297,-1072910637,1493187061,-1493170225,-469133174,-143368194,-1238870496,-2015911362,-1696845208,-1406507363,-1455227792,2132839299,-2046253138,-855478277,1307230783,-1037035597,1071067308,-1951879890,581605062,-1152447599,-1509069035,21587122,1475881877,1984276299,1124342988,1792891189,388281364,-1736661242,683447449,937886517,1255544003,-811703609,1648441959,819204952,-1435425607,-1774492928,152172751,1169406244,408530747,-1584390978,515336916,807472057,-1818745154,1302472865,-1878875014,1124094542,-1436330670,1804350863,706519386,972916366,1299012691,521091852,198596467,-2090476700,-945362027,-336966395,1727520181,2032674251,-1510369735,802094205,-1918714997,-1193540993,-1971401853,1166356876,-1710883757,1487629778,-1132577303,-635436969,112170428,387879341,-844040487,-860877357,1806228715,64890850,167444816,577623157,1504620461,-2083491937,-1260697392,2129646882,358923795,-2072328786,333812849,-272922872,457397308,-1732520431,-1104201191,-1959119770,1246429826,29702180,-774922100,-1978184834,333858589,1769180696,-1161117568,811660215,2090049208,-1470754991,954880472,-2047819423,-817565018,-1679824396,-404072198,-767142212,550034081,13116630,-1700751252,593703669,1298756194,-749312598,1789091267,-542909861,661290631,-107372286,1384635430,-532306802,-2053746150,-313596724,-546890959,-1481224042,1391287288,-442241069,-1925427453,2147353891,-721183679,638447295,1498106748,-1730416558,818831810,-1782586002,-930874230,2003744867,-1312708919,1573705282,-296835270,751905793,-864400262,-2114558708,556821033,1100016466,-1947050126,-557592040,-1609012330,-1368401724,-374130763,-1910876509,675785313,831576122,707154042,-536381259,-5077407,-1280047321,-923830686,-2002248481,286200385,1164940962,1899036189,-145478570,534341215,187693355,1701129536,1793662047,634092589,-1371566201,-570873624,1275878679,631359976,279621246,-374523835,-691956494,-30264375,1923716081,904005968,-230070104,-1585702499,2084204936,841187700,-850512680,-1997697857,241388699,-1434597773,-314484898,-660487057,2035688702,-877881045,-1134598100,23679035,58027358,-1800515596,-184172691,-949880632,1506490815,1018728613,-247296623,-1565797398,-905410691,1657261334,949525194,-1174968603,1877101024,971949117,-846798597,712021404,-1740032415,-785162414,-1614894344,-1530759977,243273419,-735867089,-1774096920,-41234432,1912216479,-723641264,-1908151557,402243381,1954350922,-1870398690,-1505456008,662323263,-69570180,-407569079,534847668,-1815103408,236406165,-1952868814,-828259214,1867340895,1163548829,-567976525,641355887,1263753081,1782500169,-1713126809,1934344972,-1970575069,-876696605,-2032726974,-188637624,-919127545,-1620230306,1137690902,-1636671837,1029580531,-1326752936,-139181546,552898083,2000858128,-921420382,-663935697,-2147151048,-178829569,-1074417481,-102952052,1287530608,-34468938,-970260499,1721784468,1920916281,175228048,-2072034644,-1134906973,179355485,598911616,85588756,1833522155,-1091266312,228803083,292151846,2001713402,-1833706439,-1599029927,-933396450,1853566353,-745911014,-505520747,-886025825,1970462688,-1701040860,27093350,1936625185,-1619346256,1032712257,1264000061,-1300996606,146656899,1188161807,1115075214,-1086579987,1976842116,-202100925,72211244,620667624,-1558464066,-357978651,-522007361,-658751194,515074380,429623801,-1630265180,-930290828,-694237202,993950070,977609997,124180264,-584224949,-1749913270,-52649471,-1507493047,1375932926,943159771,545498470,128148937,1966200565,-1776653172,1784217761,-528409766,-774800534,-1862221244,-1733027758,-1975809991,1501127627,-242879032,-1645535499,1812673720,-1268118060,1169119791,1039199613,-1854418809,-1756189889,1563700628,1910477053,1521675509,547865027,1932215848,1161064340,-1698978382,-2047316499,-735702968,-330608493,1213893783,125525700,-798934676,-132620633,-581146030,-1125046055,1040353205,-1394049007,-693439370,336551641,-81785275,404132663,1912148419,1617597223,-66539511,116668024,-1142311660,-362706490,1375140139,553537338,-1860440718,1742700836,1966670632,-424997314,-1700778620,-365418605,1236354167,-64062529,-1567554381,-182922788,783712647,5278691,-133664356,-953152832,780026313,99602499,-1720469313,-1849765254,-147617144,-544031551,505728057,1186397414,2104937061,-1315438400,-283151372,34784686,41953772,-2046255864,-1155865837,517438199,130811763,-1169978939,-1832801599,1458009855,1051986846,-1560189291,595342139,1582433480,766030130,-1221083771,384195427,1789738668,-976665837,-542285323,-2089625666,-1087473515,2134199810,1239571327,2107057746,37218443,97068609,1538908750,1848769261,2051142020,2049898169,-152366251,1362874167,1730625822,-794949540,254649308,1883380772,166705018,202252612,1336131676,1398160599,-2112569718,66193274,1069576570,1705523357,-1580108818,-705291940,-1494906375,400830307,-1964768258,215748726,-774439095,1758055546,674430642,-766094324,-2114947434,43007261,1489383313,1836573306,-1879744697,-1984394259,-699927791,-1835872161,-473286327,395887017,1494022903,-968668136,-1908630854,1518823919,-1767750936,-1216134911,-742405502,385366475,302061527,-603508220,34770311,2045938061,210007952,-1490430955,1359024454,-1179402638,1161824728,419876321,1163667211,-1836870863,1573098951,-897799581,52259728,33721049,-1824394013,-1795788444,1448300379,-1513192604,540390790,1104344361,573351116,-592581084,1726892698,-539509046,2022376758,760136941,398292709,-87591775,-240579460,-521329515,1193558814,1985486095,746976137,-894151769,-1242918145,-234944557,236652844,2144481504,-2085954779,2046441451,-1098139316,-2008219723,-1789453418,-1139745590,-1692133453,-801603049,-1614071078,1137114543,-270168340,-625436949,-138834087,1663312326,513305752,-1542037948,368731313,618688224,1354602370,1053542034,831519207,681040485,-138490343,1002205220,-1175626552,-1112920688,657386433,1369132376,1077463394,1139246278,1685775102,-151160467,-1019872969,1373291300,-969598658,449123359,1607781936,-1010572423,-1281355029,1210292323,-1169941675,1015411549,-1224508503,2119713651,219874262,59578829,-85814639,1529386816,267836347,-49568,-747703258,305364643,1377313566,-1662095597,-1451660292,1680132318,-1232288430,1185909472,1184451735,-1256873403,1811474439,-448462191,853907254,806075045,723094531,-1940162945,465566777,1044752711,-2092788592,-809038533,-1942776429,-552773098,1202485370,1007835460,-1484774548,-1138447555,-538580282,700410161,-562232001,-1434286468,-2047741371,-1765312484,-1234188349,1227720411,1807000751,2054663481,-320208812,-814489021,-51672434,-1085209602,1435060598,-1353085157,1458341242,363303175,-1600585459,1585006881,181097536,-522925020,1897252182,-601937682,1225204808,1880578177,213804725,-1935735899,-1584974000,-1086885705,1248416855,-640069602,-2041337647,-1692528898,-385750760,-528266435,260792532,1991917710,-904795047,-93775968,920113306,-234385060,1114321210,-176016384,-1026678092);
/*FRC*/Random.twister.import_mti(99); void (makeScript(14));
/*FRC*/count=35; tryItOut("var z = /((?=\\cK|[^\\S\\W].|[^]{1,5}){4,5})/ym;a2.push(i1, e1, o0);");
/*FRC*/Random.twister.import_mti(477); void (makeScript(14));
/*FRC*/count=36; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(486); void (makeScript(14));
/*FRC*/count=37; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(495); void (makeScript(14));
/*FRC*/count=38; tryItOut("let(y) { let(z) ((function(){;})());}");
/*FRC*/Random.twister.import_mti(521); void (makeScript(14));
/*FRC*/count=39; tryItOut("v2 = Object.prototype.isPrototypeOf.call(v1, g1.g2);");
/*FRC*/Random.twister.import_mti(539); void (makeScript(14));
/*FRC*/count=40; tryItOut("\"use strict\"; /*RXUB*/var r = /\\B/; var s = \"\\n\\n\"; print(s.match(r)); ");
/*FRC*/Random.twister.import_mta(701102509,1882567758,285457309,-665993307,-390501135,2034464684,-1110075600,-727296380,1119818144,-1670453157,413790953,-1099731732,-2068231451,-1063713119,-230661727,-1339503213,490939719,-1693461684,20167516,-96427677,-1539034226,-702463509,631925202,2147131438,-1480697802,-711656928,-1389803957,-1875199483,-1109850423,-764903586,678279452,-1603781375,1144101462,1600679764,1329742873,-2130102721,-2086417468,-613435103,1241079298,-845410064,718646138,1559863011,1466191686,772132068,1156749323,2013381157,1734953944,1397645583,-2009307703,-45508206,1355251116,217566045,-1698368018,1702240757,-1018584132,-1905519848,1551116223,404708399,-974167663,-940465750,1961320367,-1233453134,2094079213,304079675,1481355585,-669518038,-1915159859,425821156,-567977831,456134987,-1735509658,-881040644,-701055123,1303056006,102220550,-1954466328,-91427656,1842554119,-1323349139,-879511150,132180792,-1975726020,647893994,202831476,205450035,-625382923,-1282450864,1139775486,-220799445,-344969824,726655108,1250092317,-1097586459,1758715614,1922627492,-98178893,-649143238,-1511620310,-1746939825,1122097667,836801481,193764003,-1952227933,2094837924,1382949312,-467476337,-469196170,873841425,-847342287,-512764693,1547421209,-1133195615,-1770759291,411151282,-1182825493,1785581434,62689490,1818348313,1023672517,1609101639,2010874507,-1808495613,1462848956,1380392070,-1509512507,1829826265,1492735003,-2091999917,673732935,-582237590,174334519,2007263760,193678975,1576449393,408942979,1228437105,3873979,339907971,1121819276,1060939781,-250459485,-710593856,2045372429,-2093428225,2050004768,1760292298,-1078119188,1407457873,-418427294,695185169,-523622189,-578256317,935982974,1138817885,451277702,1458844389,901711817,-756953617,913283119,1102238115,2029408771,1184039823,387713667,2097519819,-1870835865,696970767,1498054311,1228487777,-1190618625,-1105408583,1172641911,1935009835,158275789,907083384,782022765,-1532508350,1780628648,1062282033,1566407890,87485712,1849073533,-1036413959,-957076868,253260637,50557887,1958449390,164077987,-530066509,1127716139,898012324,-680896283,609753391,894834838,-825666324,-155406988,1557884055,909751570,1521787675,-776438281,-1274124528,-238229256,-1569342912,2074653387,-57114303,-186202373,-1410462690,-856099191,-807626717,1501965435,431171658,-920741639,-253221429,-2130649373,127002532,894099353,-801196022,-1748729576,24573485,635727612,-1466759892,417694492,-1068002299,1050029333,-1591355040,-1998675462,-932246338,672984271,1715038711,2043832422,-822040184,-578718532,-1880518968,-1746048676,108006305,1656506498,-2002089656,550499128,-1262606446,730479872,-48452765,1557398255,244810895,-213693518,1730407011,1721564816,1317348595,-1683536408,846572544,294052429,1038075006,69239077,1858908152,-298472408,-1985783654,1694799949,-35942571,835415294,-291516008,-595151673,577670766,1636919951,-1252029648,-229041547,596907655,-564700311,1271332692,179960062,-159038453,1293994915,1441313484,-2119576114,1535693943,-1478962177,1876802251,1760148850,409811722,874084321,887733667,-490541750,-1291725981,-1936605216,1071201196,-187335448,1362768173,1490151580,1699780190,-934477838,-1289152688,182042995,1709913068,-817253211,-500435687,-114512275,189679460,1670092838,2128084967,1494678749,-1963890670,-621691357,980080960,-1529686010,1783227285,-992444082,1867094171,1656304981,-715572521,-1596138907,1518327683,236384869,623736958,-1148653298,1206375318,1038059562,2039830315,720248577,2009453081,-80609517,-1315511617,-384647496,-1248256349,-2064126383,1121483273,-1832037114,-1848722152,-373519101,1271571596,-1219110087,153250093,-596531962,-39401473,1726592590,-1448002552,1674716910,1975253738,-424401327,-1545305093,1082698826,-395706180,892313247,-1344145263,974888056,-1272819406,-1315354285,1773115638,-2092117105,-1071516079,1549098533,1609244221,1898976143,966752405,-1791543243,1611618752,-496230898,866922016,1346470624,-1934561606,138951470,-1416619511,-560360612,-1400396124,512536141,95101705,1007202962,-238497551,71152158,1246784565,1288923287,-879834313,-420432417,884604623,1865183977,-2015328828,-806068022,2013070954,694710975,693943934,-1336976833,-590475235,-1106213085,-100767931,-669015133,-1890279674,506158040,1311163021,606085968,-529182996,1659482064,-549091346,1583285231,1620292473,1007484444,-1858249839,713990283,-1647329295,-1621478971,602286745,976599428,-1785889336,-2127633525,372579586,-1097269779,-433450705,-1953577690,2096522289,-1111339732,-1893277252,811627078,-707097045,887591900,-2024980061,-913834040,2090456254,-918418034,923546250,2020906793,-656689452,408577411,2038043980,427352557,-1857432811,1823763865,120191536,1867041816,511095100,488796917,-375819291,-1325810515,-137627558,-2052826514,-888464257,-40706556,-1256209082,-1274137437,1730435608,-550231596,863838421,-741778327,467943319,-174447564,-949037352,-1234032417,1093548452,-1004026029,-1091589346,1099877734,-39534419,502833723,777941537,1587907449,-482158532,1393463351,1486846218,545431749,-86491964,-742939565,1525927530,-2011241259,701132948,-2068271172,1428453635,1873800928,-1329011528,413315708,248277562,1824510350,-1904490215,-77688661,-699901894,1712786476,-275082101,92532367,-216586049,-182220887,200162479,-979577284,-1380972637,2085712310,-1675004778,-26942122,-1538354022,2072137704,2011421183,-1379838570,-2010470731,-7764994,-221232171,1360636707,1316664810,-921040469,2113325276,-1321067222,2050773478,856848746,-473441685,-1793628796,-284920325,-626852905,1039879362,-1737151017,1177542857,684736093,1459660034,-2135890361,-773006133,732717317,1072439887,-106275160,-761671291,-347897686,96570684,517975104,-1606801772,1386369320,1008206936,1375559715,2068566416,1789330848,-582837369,836663198,-346253027,588287141,2096003951,-15158325,-732585680,673628097,-2026928591,647788324,-100151602,-1596578134,-334157854,1331035178,1128986422,-412857432,44750348,-1561486393,1727763447,104330465,1877134302,1745728654,-2060007095,-1186075007,-671652881,-202412180,1014740578,857730996,255209438,-1290494136,473551464,-425622626,-10936666,255680538,-700247501,578674335,1732564151,539916450,1259217488,-1457884671,352047649,-1292411231,8774558,-805311362,1698056108,1326466855,-350052899,-1323775193,-1272777966,593858127,-1522624616,1626677233,934489391,1745801918,2108155341,523275335,869528366,1010639360,1866022701,710895907,1378737524,268283043,800791113,-2053497760,83935710,1463854919,1126926112,1773095223,587718894,5588012,-1161836530,870196003,-1028000916,-1883433546,1536504801,546621582,-1032380475,-1594324598,1965804931,-1107439978,-1726454106,-2105200668,-6420776,259515585,124249800,1306471514,290211488,1134138264,559396398,-1455555347,512535335,1936229874,851964887,-1811438022,1773085743,-1795835296,-1952400751,-1736427644,1694639016,-594283126,1094219212,-900287524,328034341,-50714772,-1516557371,1115765699,-136710771);
/*FRC*/Random.twister.import_mti(74); void (makeScript(14));
/*FRC*/count=41; tryItOut("v0 = (this.o2 instanceof this.t1);");
/*FRC*/Random.twister.import_mti(89); void (makeScript(14));
/*FRC*/count=42; tryItOut("/*vLoop*/for (var dkgovy = 0; dkgovy < 19; d = Proxy.createFunction((function handlerFactory(x) {return {getOwnPropertyDescriptor: function(name) { var desc = Object.getOwnPropertyDescriptor(x); desc.configurable = true; return desc; }, getPropertyDescriptor: function() { throw 3; }, defineProperty: function() { throw 3; }, getOwnPropertyNames: function() { return Object.getOwnPropertyNames(x); }, delete: function() { return true; }, fix: function() { return []; }, has: function() { throw 3; }, hasOwn: function(name) { return Object.prototype.hasOwnProperty.call(x, name); }, get: function(receiver, name) { return x[name]; }, set: function() { throw 3; }, iterate: undefined, enumerate: undefined, keys: undefined, }; })(\"\\uE152\"), Proxy, (function(x, y) { return Math.fround(Math.atan2(Math.fround(-Number.MIN_VALUE), Math.fround((( ~ (y | 0)) | 0)))); })), ++dkgovy) { const y = dkgovy; e1.has(h0); } ");
/*FRC*/Random.twister.import_mti(205); void (makeScript(14));
/*FRC*/count=43; tryItOut("mathy3 = (function(stdlib, foreign, heap){ \"use asm\";   var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    var d2 = 8589934593.0;\n    var d3 = 8193.0;\n    var i4 = 0;\n    {\n      {\n        i4 = ((((0xf8f244b9))>>>((0xfd606b75)-(0x183be8e3))));\n      }\n    }\n    return (((i4)+(i0)))|0;\n    return ((((((Float64ArrayView[2])) % ((Infinity))) != ((-35184372088833.0) + (18014398509481984.0)))))|0;\n  }\n  return f; })(this, {ff: Function}, new ArrayBuffer(4096)); ");
/*FRC*/Random.twister.import_mti(369); void (makeScript(14));
/*FRC*/count=44; tryItOut("\"use strict\"; print((4277));v2 = new Number(g0);");
/*FRC*/Random.twister.import_mti(404); void (makeScript(14));
/*FRC*/count=45; tryItOut("/*bLoop*/for (hvnzsv = 0, y << window, ([] = b); hvnzsv < 117 && (({\u3056: (x = function ([y]) { })})); ++hvnzsv) { if (hvnzsv % 4 == 1) { v0 = t1.length; } else { m0 + this.v1; }  } ");
/*FRC*/Random.twister.import_mti(562); void (makeScript(14));
/*FRC*/count=46; tryItOut("mathy3 = (function(x, y) { return (mathy1(Math.fround(Math.fround(Math.tanh((Math.fround(Math.pow(Math.fround((Math.asin(Math.fround(Math.expm1(Math.fround(x)))) >>> y)), Math.fround((Math.imul((x >>> 0), x) >>> 0)))) | 0)))), (Math.min((mathy1(( + (Math.fround(Math.imul(Math.fround(x), Math.fround(x))) ? x : x)), Math.min(x, Math.min((mathy2(y, 0x080000000) >>> 0), (y >>> 0)))) >>> 0), ((Math.pow(( ! (mathy0((y >>> 0), ( + ( ! ( + x)))) | 0)), Math.imul(x, x)) | 0) >>> 0)) >>> 0)) | 0); }); testMathyFunction(mathy3, /*MARR*/[new String('q'), new String('q'),  /x/g ,  /x/g ,  'A' ,  'A' , new String('q'), /*RXUE*//^/gy.exec((({6:  ''  }))), new String('q'),  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' , new String('q'),  /x/g , new String('q'),  'A' , [(void 0)], [(void 0)],  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))), /*RXUE*//^/gy.exec((({6:  ''  }))),  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' ,  /x/g , new String('q'), /*RXUE*//^/gy.exec((({6:  ''  }))), /*RXUE*//^/gy.exec((({6:  ''  }))), new String('q'),  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))), new String('q'), new String('q'),  'A' , /*RXUE*//^/gy.exec((({6:  ''  }))), new String('q'), new String('q'), [(void 0)],  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))), [(void 0)],  'A' , /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' , [(void 0)],  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))),  /x/g ,  /x/g ,  'A' ,  'A' ,  'A' , /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' , /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' ,  'A' , [(void 0)], new String('q'),  'A' ,  /x/g ,  /x/g ,  'A' , [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)], [(void 0)],  /x/g , [(void 0)], [(void 0)], new String('q'),  'A' , [(void 0)], [(void 0)],  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))), [(void 0)], /*RXUE*//^/gy.exec((({6:  ''  }))), [(void 0)], [(void 0)],  /x/g , /*RXUE*//^/gy.exec((({6:  ''  }))), [(void 0)],  'A' ,  'A' , [(void 0)],  /x/g , [(void 0)], new String('q'), new String('q'), new String('q'), /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' , [(void 0)], /*RXUE*//^/gy.exec((({6:  ''  }))), /*RXUE*//^/gy.exec((({6:  ''  }))),  'A' ,  /x/g ,  'A' , /*RXUE*//^/gy.exec((({6:  ''  }))), new String('q'), [(void 0)],  /x/g , new String('q'),  /x/g , new String('q'),  /x/g ,  /x/g , [(void 0)],  'A' , [(void 0)], /*RXUE*//^/gy.exec((({6:  ''  }))),  /x/g ,  /x/g ,  'A' , new String('q'), /*RXUE*//^/gy.exec((({6:  ''  }))),  /x/g , new String('q'),  /x/g , /*RXUE*//^/gy.exec((({6:  ''  })))]); ");
/*FRC*/Random.twister.import_mta(-1382570001,279416474,-1558482417,1405942602,-1702122759,-1788604738,379932531,-593639940,404301134,-449037331,-891078563,-273447311,2114548268,699367367,-1115356504,518729714,982244140,955075207,2096322234,1249410116,-1956510362,1269683460,-1363901694,2137735554,1843627808,-1596661790,-815571743,-624541362,-2136126390,-456171485,2130138629,-407070907,-457233451,1127959767,747892358,-169881279,-1818544553,-1144484139,364062893,-2036102700,-1399832519,-567802985,-798216022,218354693,-467244951,-141335873,239086406,-593997987,-2097148828,1973099757,-1322440880,1405612430,150042649,1923760617,531198086,-676330555,1876894220,1749591108,957030079,1801845725,855052109,1675137301,-987547583,-628980065,-1664934099,-951681083,1115466696,-626668259,1525379427,-149320680,-1275696828,-1811619003,-1991306296,109580044,-153636277,-2006584843,-468771085,1142670165,-931538070,1067516970,-1724441464,-1389630301,-1572474976,-459961682,-1011360294,-200869698,-371364534,1609194548,-2023205627,79584097,-231508037,1331211526,161425331,-2012322056,-567929504,1605703543,-1321952514,1206926716,394012709,1532625644,-1590316724,78394329,943831195,31927997,-65444454,-223037572,317623708,-1810130110,-699172635,247401851,1437271562,963714487,1233213669,-1687626390,-720584407,1400641857,-1826598645,-696790882,-843638292,-935168966,1313893721,1514590528,-1031858338,-1457821416,-1821459236,1248635161,1291476806,-449174595,-1450547452,-89729312,-1042940986,1008415050,1541852549,-630017996,-18973487,2121364778,-1853674478,-2088544639,-529696982,-1481219729,87052990,-1913524137,497160553,-1001020143,-477981430,-332270310,-863958123,9980037,-1031190391,444152830,-336256106,-1119520735,1201787863,38771161,1680980894,-1582633564,-683900257,-502201238,-220202402,208268255,-1363483847,544336703,-1492148956,1590295314,-1459912588,-88225621,1454814002,882128647,1914971409,-660622677,94163794,-45472952,750473747,-431473065,1878263404,1780584979,-1250700695,311663721,1839352229,-2075355582,-365321129,1820834205,-247491784,487789920,1063061929,-894711991,-367993306,-1858325635,969190076,-1293363071,1906013254,695545704,-438478566,-186432756,-1393543819,998773255,1982201495,288098222,791477771,-988038422,-937247866,1717159518,1490744999,-334743709,1385226439,-1297356863,-274023826,-1236126342,764289547,347734094,-1046243,-1428137380,1896808453,397048105,1102084138,-552076564,1377005912,-1972240134,1900781886,-1864289276,-132444399,202708361,52397205,-1198164079,-1045647974,-1886913157,1573777833,-1853975588,925358686,-841234351,339229742,-780329385,1330953137,670788402,-657948328,1216273618,-10278876,-1624889635,1211458335,-1989426300,-1209266849,-2077972623,-193828324,163947620,-2035849183,1897985102,323136068,447333535,1430402875,900494159,1208817278,1526288692,-469404753,619290648,2099459643,-666305995,-746551057,-1984119623,-1232351118,1300180557,1502906703,-860368029,1025338077,632826684,-567545473,284153042,619289358,1393071415,-186885391,-793191859,-103870751,1858253129,427101957,976549375,-793849128,264011,-152603933,-2142481931,-1823495968,1320789993,759618623,633589490,640002956,1136121410,1524690795,489513286,854683765,-292331733,1361905891,2072990412,849333452,2036201668,-2099159945,1941530587,2093384241,-278347822,-228509679,1199965834,-919498779,-1691975733,-358330855,-725880084,1724484967,1281045638,-138416415,18810503,-879337676,120903013,-1078112100,-1082026201,-2023333019,-581428785,1371857908,1705169429,-50330137,603462227,-981624095,-2034620185,-1935895928,-756260796,1886055203,-683622429,391268859,1558342816,571830074,-1780583066,-2034006363,-1894947889,-478682887,1261790140,356495545,-1913620755,-932623863,-1195626901,1558276704,-1239994688,982125861,-1774945894,-1215737568,344757977,-2122713613,348706143,665572666,193890323,795843433,982844961,2126466043,-272575423,-545137195,1374436251,-652425736,-1571245093,331005449,1692048950,-480095008,-307332461,1986423611,-1365691800,1784209944,-1918358916,1102025071,-522574440,-543314547,-744622819,1067700292,1594651582,460960811,-280971122,1319485423,-1287874366,-945428493,-2072468113,-1748011473,1094550037,339089338,1134974281,-317291729,771084504,1488124764,-1297698087,1172690522,723785330,531708989,-986934473,-768892132,-2085933642,600516648,1486737937,-1993309604,-1190534614,-815798779,1689542894,1834133388,-2146231537,-59796844,1866398163,-765916081,-603778488,-1236226615,-1426088902,206931487,708011263,-1924001580,-1416432385,1426123959,898789510,933847432,-1337299527,-165041773,-1778619172,1667235647,469503854,-1859265012,1327637869,-1118705641,-320788318,-1906978265,-466635665,-1193707971,177200905,-143147500,-1688972423,884165273,-507742414,-1125642621,-296185726,-1090631993,-1963944271,-1697318722,638818725,-1232874048,-1851831735,-1053177139,-1070552444,1994659279,-1654506272,-1069502630,-985851129,-917032656,-1287740235,2000512507,-89445540,-2141180061,852760555,766038131,-1497415428,516341195,1312914034,1035237783,-208634799,-1797600492,1222987047,-1293163751,-1390505121,-66620183,-1440737045,-1723928549,375679984,585601545,2021870785,1067391342,-1801856922,1327032783,-918765341,18051726,-1399678059,-498077799,-991458487,719412715,800796036,-1454997276,1698569002,-1377871162,831308122,-713459823,728403936,1001965828,926901461,148773753,-1715186597,-2045707208,1807981808,89463216,-1404810992,1776037260,1192211772,1782740152,-468632251,-1303595251,633103432,1487274959,-945631798,-1207662280,1851926988,-1115545835,8755141,-1908048852,1828530389,-1797393934,-1810521868,297052030,1241387300,-235218447,976876222,112390157,-1348827212,-1090650124,1491541098,1730349164,692747692,1403700488,867289087,52519786,-2096664389,-751388701,1686014515,-869879856,1785788163,-704969579,1247914746,-725161293,-633181429,-2059243702,1065015086,-585534131,-1702906761,-1507485524,-1160815284,-1565433571,23294834,1845382941,-1005728971,1078619521,1139286536,-314463167,632166963,-2005863736,-1285506782,1187761588,-1804950421,-1756245187,-2064141743,2110112098,-588092101,-2128527608,-1793663700,-1661957776,1127885548,-1460916048,1355610614,-288664218,-366792534,1064611810,-1764443404,-1433767193,1861380390,-1740621197,-1790136522,-843938014,-275334090,-903410243,-496895700,445567217,-82913175,-869990381,2134058712,101965077,1745603284,-1776684265,330087525,-1403663830,-1174442603,595394486,1621220091,1096088328,1403443611,2029704481,1206559606,747474464,293056569,643497689,1372239772,-868501245,-608600193,-1088765409,1785872398,-1862807941,-2125975519,-1048126418,-1740429482,660593714,803845123,-415282045,1258680558,215871120,1348163748,-5198959,-2031652863,-71850493,1232876688,1116631409,853115287,1258321433,-858109213,1029573583,-719014411,1692948373,2085721251,-1420861626,364048160,687059455,-665747924,1601421345,1871393770,706528197,-1485211495,-644491060,-361447445,-1267047389,1395635258,1272331826,69713834,-841305142,496660327);
/*FRC*/Random.twister.import_mti(610); void (makeScript(14));
/*FRC*/count=47; tryItOut("/*RXUB*/var r = /./gm; var s = (/*UUV2*/(x.isPrototypeOf = x.getSeconds)); print(r.test(s)); ");
/*FRC*/Random.twister.import_mta(-1806641915,1054188561,-1021714017,-1743199300,1619092384,1594361778,-2049174015,420249104,-1643848273,-875541127,1587224158,-1993535355,404972512,2107473515,1418303639,-1939328102,-899927823,-2094513334,-908257664,-1947938668,-2114363667,-1350355012,1966768072,-1048150652,-1958855544,-905292746,-1931520107,-54613850,87527500,1485659418,539389388,1904467339,-561606895,-1597365629,846729782,301785401,81550641,-1523240634,-1640761334,251674521,857844243,-1587467931,1823997544,-601431792,409610972,-952091968,-2054127462,1814615617,1165655637,105918051,664961717,-1597737660,1406004346,-1693551785,-97125350,-989564385,-1724202627,2039106409,110777818,424527714,-1098869851,-1719746826,-1932869807,-386521561,1848792923,774290475,2103875250,-177308960,-1759617639,-1145775301,401426996,1850135567,1828661762,187033886,-1207676145,1188062560,-896954321,-247096796,1958350325,925058880,-123592101,1509747881,-342978292,-406121771,297853103,1908125461,-1011783926,-211765295,-1671944109,-900497478,-2084738106,797676555,565925684,934611327,829486766,-1600207801,228210546,791985112,757634739,-1629510518,-1214021146,301309280,233736053,800593331,816073370,-1198678209,808730399,-191628128,1909305814,-1809285903,-581492114,-622127935,620630809,-1608247997,-1022919808,-1816528080,-398681868,-1242744043,6271022,839264675,1196662691,-188444870,518790774,-1653492515,645697368,-1556135703,-1796245969,-1982052657,-416489721,-959486641,-456997399,373995264,744106856,-1952857686,-1154125408,1217133448,-1692321385,-1653139500,-276981157,-890709097,747696598,-1861061153,793298492,-426731080,-219199268,-2104626057,95877542,963455891,-668319533,-1458956101,-2070927837,1379166596,-924613179,-590116695,-84523400,-840802702,-404997951,-739930168,-1311888362,370539312,1551690358,-566933072,-2131607105,-564474489,104312230,1909819752,2018276149,1816109636,-898347182,1155380412,1454300016,1498213057,-1182788719,-609236708,367465539,-1597135267,-1327455216,-292720891,1367380666,-1796294699,-1465790617,336742332,1610496649,-1594045742,-308812569,-1187785200,170907166,-470247615,-368141167,-398822312,-1779259499,-211259229,-500005168,-399542697,-349893153,1160053527,1133769529,-2109529782,1926661585,-1683884462,-171207890,1322413455,-428695554,-1295076915,-1299922264,1020603182,-1745661858,-225334763,-545671726,-1038556220,690076045,1254125467,-2022743189,137072106,-136674470,913995917,1790063511,1387860826,-1358306661,1016131483,896959984,754783926,-697450707,721447167,-622005816,976550849,354756233,-809289686,-2127499034,-1996095608,699325512,-1641836889,1291170347,-1447536979,2100498553,-1581954627,491515592,-1551294706,-1919356601,-622996080,-1501061876,783330713,-930422360,1342649406,-71812755,-1065598046,532185604,844166575,744341188,1362949367,-319105762,540292480,-1736539078,726039639,1234330979,-167811868,-2057587815,2070119925,-1909130638,1799650153,530152429,-167897209,52491431,-1295968943,-314385617,-1941490291,-1081293347,-1874380876,1345713308,-1990669881,844040555,-1915216511,1129509088,-1379407370,-1256037061,-419334149,-545343930,1845843653,1586501231,-597282118,-1980787666,-383309348,-455108290,759301655,1998388170,-2031461057,-1223895000,1327408907,-1531373680,-1786422985,-732374459,-162903617,-822952167,-636655755,-1025891063,1999008078,-663234434,-1434632935,-1159898315,-2136621615,1635258472,1382557027,1627258659,1751046016,683846072,1366368879,-307126995,-411268587,-1623943195,825561185,275754733,2032308565,-631081280,1681511718,999557671,669931004,268884758,-973921662,1191027753,-1064922502,-2061638063,-472817012,-1896877545,479232239,635142507,-146676418,1079092658,1594933573,1953443006,-1636175882,-1337418214,-845652159,2111518933,1581550127,-275223616,-1249900645,-1624096708,-2037150978,161869682,-1119200961,1934151475,-791506659,259395558,1719920031,833554650,-1509382900,-1662061732,-1315192426,87695912,845315210,1431657967,-156671869,-1856892942,-1520542625,1711524697,85416517,-779879301,-1846627099,278831678,-712682752,-1141583002,1307776953,-1202867751,-990850635,-1292816885,2076831889,-45578288,-758472962,-2004076098,-711817958,1034189776,536888084,2065401250,263058043,-2118733336,2007609755,-986921,-1463198835,-764444617,-1441698072,-918453360,1814456505,1987880758,-1899370161,-1842341613,-534005758,-1554799897,1491381080,-2102282075,2119500386,-1409221136,815726176,-388713424,108771967,-2102890894,2052094378,719076760,-1802617525,204678364,1721917505,1472121788,323886121,1812753661,1130914452,-196847802,1247027838,365113814,1253944177,1592553938,-1218873911,-1392325275,-452916255,1202353273,-1919970614,-1786248432,875349341,52764336,1352051796,791097336,-645309990,1015934772,678697036,1979398286,-2064694105,-177247989,-1264511379,1204882901,-1197346959,-2066542206,-46959330,1661576246,1259378449,1556971116,1971972710,-64965531,-1084628353,965664408,1300898069,-1973973730,1710842185,897456196,786572340,-166149209,-445715599,1105638180,2036468897,464540322,-1297872412,-1942120383,-1677665625,-696615245,1519497371,-172817743,-231855070,64717952,1420245044,-1036531088,-1579833965,996841496,1396326044,-1544242530,-2085104575,472094995,1573017487,751362587,1706538580,564568299,1795130150,963459931,-601251366,580401579,-313027570,-1732631793,-1408464621,1743106655,830593606,-743705022,1906141309,-1243697294,-612959706,1588048431,1262021051,-472039316,-239753889,1491361643,-1156202450,-1069263596,-541617996,-1491065437,-1233435233,-1861192780,-1321164877,-76144277,944077448,1225608329,1461144202,1714351474,941748626,-942486021,193504095,-1992760988,349681948,-1172468060,1160740511,2043155743,32434581,-1340752753,-1166143464,-41806070,-854918214,-1382918857,1988905599,509695421,1201615622,-1540795699,-2102771592,2041942633,1739450576,-1820681022,2107210399,774169135,-2139417940,681253593,1878249991,2118801405,-372271261,-574483593,-1456992199,316251354,-821401486,-749698363,-772853849,1887777643,1108999122,748894163,-1693651327,1753566448,1930053687,-367037505,146943873,-1085621039,1165421206,-1868573762,1352025234,-1887941612,142991505,-1592031476,-1855193591,-1950933385,-1182115676,1770068154,2053232282,-64243644,-1944310754,678032854,-515407528,-723535763,-695083637,-1168965286,-2118119724,796161721,1003991911,286251888,1613263082,-116778606,-1817923289,-1991263147,-515078553,819184,425519859,-1552620662,1611757313,256964782,-1136357672,20979076,-1605371801,295120177,1125358335,1729759296,460832833,-1917122671,-652826873,-238856923,386280875,-455633694,-2115111460,204078031,-617104015,30573586,-337485888,1242348395,409352341,508233958,-81366888,-85511508,777837737,266964421,-646506482,1153325404,-1017901627,-1882619281,1027488315,-926145483,945243631,458469800,957553442,221320294,-588895181,654253865,-82981098,-1562290599,1686194652,-672259593,794129370,-766466101,-293907261,-1838682808,1865776958,1493771389,-851465431,73950634,-1538967657,-1382678842,-1174607931);
/*FRC*/Random.twister.import_mti(65); void (makeScript(14));
/*FRC*/count=48; tryItOut("\"use strict\"; ;");
/*FRC*/Random.twister.import_mti(71); void (makeScript(14));
/*FRC*/count=49; tryItOut("\"use strict\"; var xbwmej = new ArrayBuffer(2); var xbwmej_0 = new Int8Array(xbwmej); print(xbwmej_0[0]); xbwmej_0[0] = 28; var xbwmej_1 = new Float64Array(xbwmej); var xbwmej_2 = new Float32Array(xbwmej); print(xbwmej_2[0]);  '' ;");
/*FRC*/Random.twister.import_mti(140); void (makeScript(14));
/*FRC*/count=50; tryItOut("mathy3 = (function(x, y) { return ( ~ (Math.fround(Math.atan(Math.fround(x))) || ( - ( + mathy0(( + ( - ( + Math.sign(x)))), ( + y)))))); }); ");
/*FRC*/Random.twister.import_mti(241); void (makeScript(14));
/*FRC*/count=51; tryItOut("\"use strict\"; a1.splice(NaN, 18);");
/*FRC*/Random.twister.import_mti(263); void (makeScript(14));
/*FRC*/count=52; tryItOut("\"use strict\"; with({}) (\"\\uA639\");throw StopIteration;function w() { \"use strict\"; yield (this.zzz.zzz = \"\\u0D27\") } o0.e0.add(g1);");
/*FRC*/Random.twister.import_mti(395); void (makeScript(14));
/*FRC*/count=53; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return Math.imul(Math.fround(( ! Math.fround(( + ( + (Math.fround((( ! Math.fround(x)) | 0)) >= ( + Math.imul(Math.min(x, (y >>> 0)), Math.max(( + y), ( + y)))))))))), Math.cos(Math.fround(Math.imul(Math.max(Math.min(-0x100000000, ( + Math.max(y, ( + x)))), (Math.fround((( ~ (x >>> 0)) >>> 0)) - x)), (( - x) !== (Math.trunc(Math.fround(y)) | 0)))))); }); ");
/*FRC*/Random.twister.import_mta(1391222684,-1263049524,716050847,670988908,1019879408,-135604446,267279772,1649314126,-1229671395,2056175353,-685534228,318619682,278886947,508473841,-483061204,-1148396322,-870599825,-244938672,1910418711,-623836903,123156362,1438257180,-112564456,2031284592,1299264087,-1432607845,-89124620,-1208704723,-1729644320,1472346931,426291563,848881365,878630016,976596269,-622438574,-945037269,1729327813,-1288091552,1641106796,-1189692594,-1003354760,-66293206,1273631169,2034961706,222443860,-1261403158,175255694,-95208239,-482170033,-1855347929,-1564069050,-438604164,143610835,-1419738946,-1592051381,539415248,400800073,9875053,1476516741,1149186941,-311756056,-469272721,-1102471856,1306862060,229390987,579916362,1735748351,-28345336,-1587188970,1783629297,-992716290,252882522,-642034347,-1483562765,-1908431170,620125127,-726776831,-2068839302,705722854,1995593648,-2073317642,-2145785868,832291731,-1890618713,-353530130,-1039797271,286084712,-1883178083,-566460429,-2120556297,293268078,-1208119751,883519999,-1985476381,940002639,-1111803182,803153764,-963528945,1484298447,1040133505,1893416738,1479360158,-2057561767,-1855273943,-1852193188,2064589300,2137424079,19844596,-1829607630,-557961800,1308830375,922070617,1141916100,-871241481,1062254567,1786714567,-2074010029,-469333286,44164214,-1022038681,1573891917,-603155463,-366407634,2098898307,149684743,-68939503,-1307229761,-1798010719,329291035,917225820,-502445127,83134830,-892958553,-1899349483,-1247096221,-467853441,211972152,-1038792159,1735406485,1053635611,-494157305,-1111813983,998925149,-969074497,-1657233294,-767250579,-718773884,979754146,-989307885,2052793538,-126760245,919497802,1324035119,351943558,479263139,382539003,-437326854,1888412637,-1437762368,-85865130,-108299949,1663209818,2011551944,1819254890,54360019,-1272884683,1446486472,-600818117,-238392455,-1575431699,1424114648,-2050701593,1955270269,1888475508,-377547536,1461758630,1376422277,1770018009,858788690,-590382499,152746273,-772954661,185181480,1652049213,-2054206449,-1261126102,-1074604332,148400757,-168767504,-539485990,998979071,1892403066,117265460,-1500082853,-470021695,-1500888667,-100147139,444907675,596387712,1963738194,655793686,2005341859,54257148,-695475397,1666494380,-1019900902,-669573062,1961847617,1478453952,-1062635393,1619962657,-1136648637,-1088943645,-1727260684,-1498102459,2076149987,101317239,1557980761,691770321,-1998803024,2035020901,-348697804,28782473,689839438,1616378536,1041227101,-1642234928,309602287,-264922360,2121891771,-1310257696,-1011321286,2050903211,-394304129,-342057649,-133086343,1800024446,149379984,2140351210,1138537637,-803317790,-948935944,-745584959,1758404358,-1856460415,1040378901,1525795601,293202152,-466822472,-818475625,688450480,1095659594,1714924911,1198625434,-1928653985,1128452595,-1283765994,510839890,-567120962,-1566910039,-1715333583,41852382,1204017756,-2001031283,1813144185,-1491099811,-248176492,-1406599370,1638442518,-1950014037,-424692939,1827356964,-1573685487,-907300148,282802163,-1929514900,2137241754,344361134,-873957599,1282972100,-537717680,-747309612,-275816188,745391276,-1695862739,59226001,-1158098905,-13209312,936209195,1299005613,-1345800724,-203565608,-694234833,-1626290012,-2049162065,-1923184855,-1503253598,11683003,-699875219,-1459135135,397279901,659155440,282669063,-1060171555,889202066,-2051012689,-1673223579,1392072155,1099685659,-1599822790,718703314,-941836914,-1340532358,-1781531740,-1674063517,-700509576,-1553763914,-351500123,-1749104892,-282119672,-129975899,-428342117,1794886266,-1539680498,-47102576,944785942,-1954546180,1257023869,1460783461,-579316140,1856920406,1987898089,-853158852,1219147055,-1025081626,-580171988,-1644697401,181525790,-1319620071,-1531144574,2104496294,2028711956,-1070179369,-1665754562,-150808484,1289133528,-1680274004,525516377,-985813572,1502285318,-549018339,1078265342,809734113,1478235340,257398108,-1570120711,-413914127,-1438508378,775299310,-1757617900,1899692310,814004816,527288186,-858630174,653853366,1507094653,1470659428,-1496457512,-680373716,1700290229,-700630731,-1598725469,1285219983,-705480336,-658918224,1677235367,-1221117477,139377167,1673976638,709619175,-69091579,665758264,-2002694013,905861036,10174428,1659641196,-1768711942,1641747934,470290539,1642440240,874569562,928460235,1846820821,1466144497,-1592261906,-458984011,827817879,318493110,798836248,1599368099,-534747201,1181848145,1989450732,1747493414,212485606,970034105,1620647738,644645320,1397338080,-998214843,-1980731374,2136131308,-1307347121,-180955300,-876169212,-194887512,-141340944,739811843,1544514455,1488692142,-1297317507,-654207610,1039487785,431547495,-639829134,-647229003,-262929611,1702827735,153005100,1925134311,1779112044,1295126682,-101615319,2131741399,-1303696735,81266060,2137315370,1705340334,1471422008,-1515780671,-1904409106,78648393,-1879028348,1727701989,-110800682,618904192,-1852921022,-1503819622,1010800312,-209543153,-581012004,-1014576337,1192807244,-537871984,942128117,-785482192,-1214571091,-330153492,-366646924,1808011748,816594816,1015406873,1341708385,-467210068,977043642,-163001792,1990423862,1436580496,-379276779,466348747,1583666433,1141704921,-250865597,-1341414687,163120587,-839310951,787548534,870824969,754257241,-1871919961,-68856168,-1125797015,-1567575165,1174525564,66595909,-1106230988,-851373581,1398453311,-1068789810,256631686,1225937035,-2002664941,-79879655,1287337487,-2019337613,1388302511,-1747591838,1548641559,-1339580332,-1498478685,-2088735166,232124577,2002976764,-628161846,-1921430341,1256855993,289903048,-1590550571,-1242462199,542047040,-836546228,215165484,541601298,837077406,-1100787428,-769715520,2126230725,-1502217331,337238088,1485050087,-1624423950,1218017564,598728437,4960387,-1386397739,564230409,1687938466,1589824752,13426121,-528891462,825243601,-733344520,-1530070458,320702803,-965242300,902396259,2699518,-2033089582,448074385,917829581,-143356177,-1804060484,-1099681743,-1528866884,910608434,-2026699646,1049787859,613647937,-1162008375,507201063,-1727349693,-1021011534,2120113177,-548731113,2052024785,-1535728244,792201294,864541691,916254083,60252095,-867574717,-899574946,-310411431,-1586306034,-636799662,1828150508,1293051246,1031155550,-313690702,-779343342,1974899041,-257252341,1391778484,-612826258,-1770130763,352226299,-519408730,-322199235,-722053887,-1349075722,-1382025328,-289501423,1893891571,-717233792,-357244856,-248877610,598708083,835863327,91592112,-480040432,1508506487,702318277,1682393137,719053362,1760231507,1234052113,1239667378,-1268640357,404214942,-1837721753,308581554,1708594805,-1495562609,-1163992817,348600222,1700679949,-1657779423,831946830,438848947,1087982448,1203696450,-1302028296,893822081,649296832,-1880223904,1429989071,377428399,-2119369285,-2000664448,740297984,-599147035,-137167475,559068808,1478578265);
/*FRC*/Random.twister.import_mti(36); void (makeScript(14));
/*FRC*/count=54; tryItOut("mathy1 = (function(x, y) { return Math.fround(Math.hypot(( + ( - (Math.imul(( - Math.fround(Math.exp(Math.fround(y)))), Math.cosh(( + ( + ( ~ ( + Math.fround(( + x)))))))) | 0))), Math.fround(Math.expm1(Math.exp(mathy0(x, ( ! ( + (( ! Math.fround(x)) ? x : -Number.MAX_VALUE))))))))); }); testMathyFunction(mathy1, [-0, 0x07fffffff, -1/0, 1, -0x0ffffffff, -Number.MAX_VALUE, Number.MAX_VALUE, -0x07fffffff, -Number.MIN_VALUE, 0x080000001, Math.PI, -0x080000001, 0x080000000, 0x0ffffffff, -0x100000000, 0, 0x100000001, Number.MIN_VALUE, 1/0, 0x100000000, 42, 0/0, -0x080000000, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(252); void (makeScript(14));
/*FRC*/count=55; tryItOut("h1 = t1[2];");
/*FRC*/Random.twister.import_mti(267); void (makeScript(14));
/*FRC*/count=56; tryItOut("\"use strict\"; o1.p1 + b2;");
/*FRC*/Random.twister.import_mti(282); void (makeScript(14));
/*FRC*/count=57; tryItOut("{ void 0; minorgc(true); }");
/*FRC*/Random.twister.import_mti(293); void (makeScript(14));
/*FRC*/count=58; tryItOut("\"use strict\"; a1.reverse();");
/*FRC*/Random.twister.import_mti(305); void (makeScript(14));
/*FRC*/count=59; tryItOut("testMathyFunction(mathy3, /*MARR*/[(new Promise.all(window)),  /x/g , -Infinity, (void 0),  /x/g , (new Promise.all(window)), -Infinity, (new Promise.all(window)), (new Promise.all(window)), [], (void 0), (void 0), [], [], [], [], [], [], [], [], [], [], (void 0), -Infinity, [], (new Promise.all(window)), -Infinity, -Infinity, [], [], (new Promise.all(window)), -Infinity, -Infinity,  /x/g , (void 0),  /x/g , (new Promise.all(window)), [],  /x/g , [], (new Promise.all(window)), (void 0), (void 0), (new Promise.all(window)), (new Promise.all(window)), -Infinity, (void 0), -Infinity, -Infinity, (void 0), [], (new Promise.all(window)), (new Promise.all(window)), (void 0),  /x/g , (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0),  /x/g ,  /x/g ,  /x/g , (new Promise.all(window)), (void 0), [],  /x/g , (void 0), (void 0), -Infinity, -Infinity, (void 0), (void 0), [], [], [], [], [], [], (void 0), (void 0), [],  /x/g , -Infinity,  /x/g , (void 0),  /x/g , [], -Infinity,  /x/g , [], -Infinity, [],  /x/g , (void 0), [],  /x/g , -Infinity,  /x/g , (new Promise.all(window)), -Infinity, (new Promise.all(window)),  /x/g , [], -Infinity,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g ,  /x/g , [],  /x/g , [], [], -Infinity, (void 0),  /x/g , -Infinity, (new Promise.all(window)), -Infinity, [], -Infinity, -Infinity, [], -Infinity]); ");
/*FRC*/Random.twister.import_mti(598); void (makeScript(14));
/*FRC*/count=60; tryItOut("\"use strict\"; /*bLoop*/for (let iymcoc = 0; iymcoc < 69; ++iymcoc) { if (iymcoc % 3 == 1) { (3); } else { break ; }  } ");
/*FRC*/Random.twister.import_mta(144729040,-473760248,1286297237,-29005753,2105866688,828618018,1494214273,-1896304841,-576822246,1258870476,1863475673,-1039228370,1387240290,-1200948988,580167811,1293295143,-1920625804,706829904,1073901819,-1271343819,113617421,1621776411,607312662,219981961,1430729876,1085102931,-615906258,-1783683326,730184947,1709763423,-449063582,322029164,-156413522,1199059909,-1209053104,326135956,1720938215,-1029469161,408115243,494787222,463688891,-1421236729,-1727888556,-1998841532,517494204,-717662781,-1025798830,298628526,-178267188,-1058163999,-726646876,-512716914,-432873392,349919654,-1818910137,-706631881,1186160249,-1926240536,1780045649,-2127666983,123292292,-1258182692,221675794,-1351445990,768444476,-448078399,-620671320,1787704625,443054183,1422481865,304688573,1555146848,-787871123,427492958,-1887529499,1112771228,-229400356,1555118392,-159380927,751099405,1944801267,-315597745,247713067,-1902931473,1156577858,-367651657,-655811731,-168909981,1742045584,-2047056700,-777206788,51873774,-1835575512,-1944500493,-1770233990,-1395478101,-151298729,1922541259,-716638544,-1346878733,1884879448,729881639,1997722984,-884175508,1884446811,-774303932,-635935696,-2080342238,632622949,-280054716,591427622,-1745245973,-1622229020,142850656,-1595664880,-1150283292,1139248371,-13393113,1788728492,-1990929476,293274286,1628262495,-1090391303,39055406,-329006773,-475148555,-752270324,2105918855,989108647,-862588767,481855559,-1129895611,1041525871,-219288001,1061958552,-492977574,-1423991652,751254353,-1280879695,-1469816542,1090829149,-562523168,-1935488179,-1175920938,1683152853,-723517197,-101860883,-1916119324,-98658589,-1683871639,2146742372,79695361,340155364,239759437,1363845904,1286154724,1040500262,1869207473,-653901017,-889912264,1108775766,225313255,899714954,1423955829,1232702107,-2040221763,375540684,1004974129,-1527544635,660817026,-1499661070,234898003,-372521304,1091115801,-1690635944,-486986071,1991350749,-1880753380,-1550744054,1016045545,1563804431,-1854765163,128069303,911270216,-1261121532,790304409,140207205,-800290896,-1631166021,-412965549,163029154,101400490,1763761250,-1323348152,-477030712,-2142500624,-24038752,2032997267,1929905720,1516805561,380186133,428484192,540792357,1674494820,1145950328,-892332398,1507976304,952664830,-603824659,1954524782,-1229045840,-592643683,207569034,-1913904833,1454631766,-1354045083,-1848264653,41645655,1364570391,-204319934,-1271441375,1360228251,950993831,-329105231,1910350844,777784160,-2011958415,817540692,100069642,1415106661,-1617341606,-1718390966,-1672169662,-1245112071,1811463764,-1472496475,1333492484,1356592300,2062043299,2057351315,-606943112,-765740228,963744164,471955307,-332883835,-193845844,-1132191423,886294353,-1640403441,1891020494,767266988,-11250948,1662358046,1153908062,1829175076,842537080,718376310,-903683907,-613148057,591719017,105348394,-1810973314,-1910138995,-1986859260,1210381158,1623836769,1265214733,1802962864,933463053,1935534609,-22431274,-1765187861,-1311994715,331261556,397561240,-1964111999,-894503242,1749857515,-2025012372,-909415816,2103518028,-464383291,-2083043999,-758221136,1441041919,-294809699,-21669815,-977842226,180336469,450026468,-694388490,-544583564,-1430079085,15195168,-1255553414,1230728630,-1919366325,-1610220204,-1858423281,64338940,182448806,505068857,-79908307,-1462521323,-950433232,564849580,-592395201,-903475039,-43905454,1537771586,-1384264920,484669183,-1594758811,268059395,-1628362145,912537931,1769115721,-1703698306,1954553578,2009053989,1714287713,-486426041,-1093690836,-2006712417,784303040,-789116850,1405527698,-1025987019,87897869,4585667,1769621703,1455458885,746906892,-76850365,-357180236,-230274087,-1440326965,-1562062347,-978852950,-503924809,888562282,435653412,-181707525,946266333,-1722225205,1735479930,1609907279,870700144,231266140,162140328,1651602129,1833612900,-811350893,-729641310,-172386140,-799654784,-1716191758,1269012528,-1220978225,1183444196,-357584105,821743653,-990582357,-127722041,-1725582416,-1737265661,-1157460402,717066827,903613541,1052043016,1891295064,-1692984243,-31876021,-1783536715,1698606184,2022554321,1183696305,1310187003,-1997715411,-1329711943,1570579793,-871187570,374735410,1044994504,1579145479,-766537894,-1172795689,-719705156,1033687807,800120871,-696454833,-411359826,886952986,116279995,-792970700,1699777489,773762137,-1320001538,-1197291683,1087587752,-1153867026,-1603224402,-689078342,1894038318,168136223,-1814230633,800710413,1955665151,708447976,1129977534,1241088574,886430588,1434484023,1840789607,-1434605596,-451950909,677790861,-1095195210,710340221,-377607165,-576748149,610471811,362334748,-763408615,-1936479338,-1842694275,-1310743027,304510979,-1176695476,356407827,1163381545,-507651021,744440614,-640892417,2057601080,-474992136,1185749177,-1654378324,1467468706,1264697981,1455201220,1588841876,1161758792,-1385754536,1342876439,1502799030,-1594058993,-366439555,-237334717,1442855241,346658297,307349082,27547560,1292410452,405639500,-952905981,577892499,-359929888,-328112200,-2080200574,847468714,-720608581,-1708653325,308624217,1811911052,28963384,1349553627,1986535853,112656006,-1890890757,-1490074664,1302733947,897532931,1632637819,-1960319166,-918426956,-263340011,-1563842849,1852473456,518469970,-2084744139,-1522133446,1362686790,-1306186869,-718618585,618406465,-740228951,644004557,-743748419,866389783,348831442,-1397566795,-1617108039,-776947477,-1692377288,1011444412,-2072876987,-423990788,1553362405,-267601020,-866324741,738407014,-1482062108,354082868,-1808725784,-1880159352,1079694669,-1097771113,-1267372187,-1530466873,-1800936538,1170250486,-157291694,-511381305,-1397176658,-320152088,-1864329475,-1668246318,1791027416,-1521215126,1688953006,1039571423,-797571800,37676158,1776152847,-1552464674,750050692,-1817105251,774266340,984357146,-2097761175,-1790970093,-248733734,-7664355,164240591,-42559955,1488996779,2033185471,-1632518714,37953229,1170628445,1489207960,1678480021,844231760,-1712709057,-1295937316,-50411302,-495202086,890546571,725775570,-370035898,-929555181,1717189402,-1209425243,-790364941,1386296106,-2138135071,-348352807,-838625979,-1817658382,-1638165780,84071367,-1560331810,-953958302,-727744637,-483471075,-11689960,38852787,1899077165,385393812,-1724186105,-266174319,1255003085,-1916570166,-527294126,1028517519,-423137047,-1862080370,981592095,-1720959141,987068917,348132994,-87438272,-319910442,859221723,2145791657,-949453388,-401245745,21710125,822650063,1971711610,839821175,-1927373030,377470648,-1754124132,288220476,-1114809062,1018246423,186967841,-1221863918,1045583952,-279191568,-1127581047,216948350,-441432670,528342370,-394955618,-914246825,-327279050,898202515,662378036,-1649132648,-1055509830,-1108375193,646932484,-1347686665,-1234293211,-1843604209,-1318378706,-2081310153,-468745054,-2146082448,-800550110,709795249);
/*FRC*/Random.twister.import_mti(50); void (makeScript(14));
/*FRC*/count=61; tryItOut("let w = (--e), [] = (4277), x = \"\\uBFE6\", y, kjvsee;/*ODP-1*/Object.defineProperty(v0, \"length\", ({writable: (x % 6 == 3), enumerable: false}));");
/*FRC*/Random.twister.import_mti(165); void (makeScript(14));
/*FRC*/count=62; tryItOut("v0 = Object.prototype.isPrototypeOf.call(b1, o0);");
/*FRC*/Random.twister.import_mti(180); void (makeScript(14));
/*FRC*/count=63; tryItOut("x;");
/*FRC*/Random.twister.import_mti(200); void (makeScript(14));
/*FRC*/count=64; tryItOut("\"use strict\"; mathy2 = (function(x, y) { return ( + Math.min(((( ! Math.fround(( ~ ((Number.MAX_VALUE + y) | 0)))) | 0) && (( + ((Math.pow(Math.acosh((mathy0((42 >>> 0), x) >>> 0)), (( + (Math.fround(x) !== x)) | 0)) | 0) | 0)) | 0)), (( + y) && (Math.max(0x080000001, (( + ( ~ ( + y))) >>> 0)) >>> 0)))); }); testMathyFunction(mathy2, [Number.MIN_VALUE, 42, 0/0, -0x100000000, -0x080000000, Math.PI, 0x080000001, -Number.MAX_VALUE, Number.MAX_VALUE, -0x0ffffffff, 0, 0x080000000, -0x080000001, 0x100000001, 1, -0, -0x07fffffff, 0x100000000, -1/0, 1/0, 0x100000001, 0x07fffffff, -Number.MIN_VALUE, 0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(432); void (makeScript(14));
/*FRC*/count=65; tryItOut("Array.prototype.shift.apply(a2, []);");
/*FRC*/Random.twister.import_mti(444); void (makeScript(14));
/*FRC*/count=66; tryItOut("m2.get(this.v1);");
/*FRC*/Random.twister.import_mti(457); void (makeScript(14));
/*FRC*/count=67; tryItOut("\"use asm\"; /* no regression tests found */");
/*FRC*/Random.twister.import_mti(466); void (makeScript(14));
/*FRC*/count=68; tryItOut("testMathyFunction(mathy0, [-Number.MAX_VALUE, Number.MIN_VALUE, Math.PI, -0x07fffffff, 0x07fffffff, -Number.MIN_VALUE, Number.MAX_VALUE, -1/0, 1, 0, 42, -0x080000000, 0/0, 1/0, -0x0ffffffff, 0x100000000, 0x080000001, 0x080000000, 0x0ffffffff, -0, -0x080000001, 0x100000001, 0x100000001, -0x100000000]); ");
/*FRC*/Random.twister.import_mti(498); void (makeScript(14));
/*FRC*/count=69; tryItOut("mathy5 = (function(x, y) { \"use strict\"; return Math.fround(( ! Math.fround(( ~ y)))); }); ");
/*FRC*/Random.twister.import_mti(547); void (makeScript(14));
/*FRC*/count=70; tryItOut("\"use strict\"; t2.valueOf = (function(stdlib, foreign, heap){ \"use asm\";   function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    return (((0xffffffff)*0x9118f))|0;\n    return ((((((0xfc5890f7)*0xfffff)|0))))|0;\n  }\n  return f; });");
/*FRC*/Random.twister.import_mti(624); void (makeScript(14));
/*FRC*/count=71; tryItOut("o2.toSource = (function() { try { m2.has(v0); } catch(e0) { } v0.toSource = (function() { try { /*RXUB*/var r = r1; var s = this.s1; print(s.replace(r, (function(x, y) { \"use strict\"; return ( + (Math.asinh(( + y)) << ( + (Math.imul(Math.atanh(Math.fround((Math.fround(Math.atan2(( + Math.PI), Math.fround(-0x100000000))) >>> Math.fround(Math.max(Math.min(x, 0x100000001), Math.pow(Math.fround(y), 0x07fffffff)))))), Math.log((( ~ (x | 0)) | 0))) >>> 0)))); })));  } catch(e0) { } try { this.v0 = a1.length; } catch(e1) { } v0 = null; return this.e0; }); throw v2; });");
/*FRC*/Random.twister.import_mta(-2135744262,1207950536,-419872428,-973398514,-1195284929,1667382309,-292529046,1691008018,-161914127,-2127012034,1435911656,1131266905,1601137212,-2118424928,-1957272400,1396880525,950572879,326381382,1713052806,-234086060,400898404,944735222,1996015768,-147054655,-1656941835,943573003,-1733763944,1079625008,970355213,-2092806980,1539218229,-2104777317,-276106450,1587569409,-1476008839,-2044836726,1637201707,-1350198030,-317793101,-764149189,298341232,469142024,252694239,433107226,-316155990,609406689,-444511601,1789216497,-1595110119,-895186723,-1701784390,-2101084309,476943770,-2073299963,-508975842,-67811253,1268739360,-198604229,1588350896,1641895377,-267701234,-1427495119,-1816403569,1684380852,2124528772,-139943001,-30764770,-3990176,-1294602749,-1066619942,1479603613,-1220850833,-1007236908,966310389,747626805,207000685,252219367,695161533,103495021,1353766707,223950887,-1341925830,-2136587910,-506812140,155561150,-1538994641,1373293285,-1497366289,639766563,-1153998505,1743354170,-622794967,-325051215,1609863535,1674787519,2112486861,838064977,-1316740000,-224527590,-60942999,1785878320,1730086737,-710214350,763194889,82818500,-895109892,1461378981,1608728453,-1203220054,301656414,744829757,-70111081,-528011017,-2066356050,410554884,241475060,1192595851,-638178056,-398412746,-664987734,891194402,-330784389,-461512323,-879611692,-718745990,-1176328402,-436947358,-307294973,473238609,-69195400,350882016,-400237812,-1697489190,-581915227,-1536092610,-1532800620,819994730,-1995373112,-1455118660,-1588943654,1444133711,1105750207,1589080486,-1360560024,-340053442,-2114584900,1958010658,2112739729,1712862263,-2096852760,2031314693,1060603001,-1250952149,-1051401522,-288585247,2035832841,425064866,1701342655,937144630,-511316918,1954758389,-724315520,550494359,602924926,-1623706426,-372368328,1138239653,1609436478,-1331727524,-335290783,-598193851,1171553657,-277571129,-1801028949,408332058,-1466060804,-1976465340,-1319443881,-100494940,1364533681,11738011,-531083365,-2109452289,549392887,-633000687,1743572653,-993473010,-446877991,-1788883745,-2085376539,-351214054,903555868,696714091,72181022,1915265807,-229243318,-203323474,-1359596672,-1525605569,802257615,812918311,-2110669588,-2033404000,477409388,-902572871,-801470287,277487361,1387912075,1698826837,-215323834,1054834502,-1437483405,-1434985517,1277354911,320471029,284450428,1708819091,-1758658480,-1774008490,1971139306,1671287325,875827746,751315632,-1662954148,-1757715264,1296685637,1913899675,-2109187969,-186973147,-382342919,-1993168469,-152355426,-1601306490,-1687420096,-371215713,-1847271565,-1454004888,-236269210,-415945777,1921388032,-392774850,-672224158,-1000685593,-1749783598,1766669712,-1588478727,829256227,-2114896196,1075106961,1613037774,-929679681,-323494918,442390180,-1372871926,1497745676,750695606,1062964285,-1358158119,1243701360,-324448837,1420246462,1981783904,-1026084088,92786328,115984413,1370668778,-405831197,-1827593815,-1152331809,811274804,-876826960,751378727,1837997531,-296195005,-153422354,-977537470,663380599,-1724467956,-433698217,1658651708,793398712,961197937,-1835896045,-1201300736,1511521578,-1191292085,50786870,744251259,-1484567869,-1191846412,195081358,-1295495022,-1210364489,-457280989,-1687245893,756104057,-1871817360,-1985667515,-154036591,-963038841,-1348642890,-2011625220,-1053295176,1822706431,2042242923,-1317279827,-1398050884,1944600334,-573074917,-1776769810,917742260,-2143950637,2058444657,-945098987,1694149781,-1953240872,-1240551064,497645135,2016905828,1186879070,-142803821,1018492841,-1596935459,1722555057,-1711300537,-1686198189,1144713900,-1310426007,-30061585,2015324558,-1625973772,313378626,1847110018,574632447,-1077368138,1951648784,-645910149,1320600296,304208787,-1157889598,-2010239684,-1142584154,-882942651,-760129615,-1437694523,1588763342,-1045430894,872081292,-392320721,1280174282,-46699546,1810996460,-744234881,-1624737232,-2054941885,1357869736,-1640897184,-1770122024,-1956631170,915224462,472216936,520344116,1100640168,2087909810,1545601558,-188358245,1830608160,-705360478,1588730683,1726619146,979680913,230640836,1378222009,103516438,-660360154,-598317520,1023921866,-462588980,-27250950,1118428764,-413286647,-1511552776,1719465197,-1353538050,1280289298,-203471230,-1962346092,-1287264427,1510150732,-1829164817,1347581353,-984162613,1941014970,1803957695,-1269893111,1050187183,-190123618,419535412,633200557,-219666256,-996268804,1931483335,-789581205,373030804,566023747,886492925,-233497839,363732207,-1040890684,-1497854240,987102281,1770890069,-935828927,-772399620,248675687,1482972742,-1661993154,657662459,-1737716286,-566201999,-814460416,2028258817,1113657625,-1247260059,2129385697,1693874406,-3475951,748331137,1369841978,1030742763,-1247613270,-1675856598,1708415121,1842896669,1667351415,-1625540906,-40340720,1432656535,384429970,-2127981007,1669006677,830897105,105371216,-1797822521,-1142656501,523516942,-1721644149,-2106055325,-969097639,-1080799085,-1781942671,-1746317548,1808635247,2114257469,953749281,1022053555,-596632823,-16115081,-1259705889,-103830317,685933250,1036189753,1105129984,-1666552402,-248108934,1443225085,-793072119,-338836355,1229175104,-1748165109,1752156464,-352702642,150013339,889094530,-447624218,-1590000572,-1471585410,-1079806329,-473675949,-2104996767,-58152937,836350127,-1398500948,-859415311,1684703014,-86421253,647012354,-461755585,-1228593100,-927830943,-1965680867,-802223842,-1604169152,-1436569985,-852126473,543247138,1124476618,1023355037,349142245,-1834263943,-1202064016,-452053348,-1892252072,764601859,-557764408,520327214,-459464920,-327660843,-232689331,-658406720,-628763013,1633159299,1362402295,1431998817,1512649103,1996206434,-155347043,2126561506,-1604166617,-980484640,1666027027,-1286231761,1812875590,1032330536,-1742816214,-1601439661,1447630614,-124880572,-1789983631,1497634643,-1087176279,19687558,1471599100,1900466436,-732183353,683607569,864546158,971734103,1478285162,-1051017216,-339005863,-805841664,-1833233680,603132072,1154072097,105442825,931380787,889067657,689294784,-1809290370,-1679252249,-355287606,428001758,-1253852150,-659233284,1736092096,-1802920387,1629282697,1534696123,557146356,-104208189,-1363724711,398601249,717700709,-1507255623,1837566879,1658641732,700338933,-1332093204,1590324377,866690854,1444994300,1481842731,-1310266053,-195780588,1123459460,80518285,964636470,-28363874,398584922,-1790414479,-1193216669,647509059,1587675858,814068563,-1462496348,-611370058,-980916447,-1634783092,2069403797,-58909994,1521438107,-1074118969,1722140014,-1654390980,1081390518,-1581632418,-1493271074,371894221,218944401,830891758,533608893,-1709094641,266333211,-1412194947,-900033355,-1084115160,-1855803374,1714128366,1975615479,-1584875470,751088463,874525422,-665891434,1033412849,-1740851839,1124070071,149414974,497464079,28724203,730629383,-596987496,-222860376,-185376285);
/*FRC*/Random.twister.import_mti(255); void (makeScript(14));
/*FRC*/count=72; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(264); void (makeScript(14));
/*FRC*/count=73; tryItOut("m2 = new Map(a0);");
/*FRC*/Random.twister.import_mti(277); void (makeScript(14));
/*FRC*/count=74; tryItOut("mathy3 = (function(x, y) { return (mathy0((Math.max(Math.log1p(( + Math.pow(( + mathy1(-0x100000000, y)), ( + y)))), (x - 0x080000001)) | 0), (Math.sign((( ~ Math.hypot(Math.fround(Math.min(( + y), ( + y))), Math.atanh(Math.fround(Math.PI)))) | 0)) >>> 0)) >>> 0); }); testMathyFunction(mathy3, [-Number.MIN_VALUE, -0, 0x100000000, 0x100000001, Math.PI, -1/0, 1, 0x080000001, -0x080000000, 1/0, -0x080000001, -0x07fffffff, 0x100000001, 0, 0x0ffffffff, 0/0, 42, -0x0ffffffff, Number.MIN_VALUE, 0x07fffffff, -0x100000000, -Number.MAX_VALUE, 0x080000000, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(470); void (makeScript(14));
/*FRC*/count=75; tryItOut("Math.imul(-6, -0) = o2.a2[v1];");
/*FRC*/Random.twister.import_mti(506); void (makeScript(14));
/*FRC*/count=76; tryItOut("\"use strict\"; mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Int8ArrayView = new stdlib.Int8Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    switch ((((i2)) ^ ((0x4490480) / (0x697c9915)))) {\n      case 0:\n        (Int8ArrayView[(((new Function(x, \"\\uC2BA\" ^= window)) ? (i2) : (i2))-(i2)) >> 0]) = (-0xab140*(!(i2)));\n        break;\n      case -3:\n        d1 = (d1);\n      case 1:\n        return +((1.0625));\n      case -2:\n        return +((((-73786976294838210000.0)) / ((d1))));\n    }\n    return +(((0xffcd1825) ? (-3.022314549036573e+23) : (262145.0)));\n  }\n  return f; })(this, {ff: String.prototype.trim}, new ArrayBuffer(4096)); testMathyFunction(mathy0, /*MARR*/['fafafa'.replace(/a/g, function(y) { return this(-3) }), 'fafafa'.replace(/a/g, function(y) { return this(-3) }),  \"\" , 'fafafa'.replace(/a/g, function(y) { return this(-3) }),  \"\" ,  \"\" , 'fafafa'.replace(/a/g, function(y) { return this(-3) }), 'fafafa'.replace(/a/g, function(y) { return this(-3) }), 'fafafa'.replace(/a/g, function(y) { return this(-3) }),  \"\" , 'fafafa'.replace(/a/g, function(y) { return this(-3) })]); ");
/*FRC*/Random.twister.import_mta(2063496272,381779719,-1877629001,32909116,-1684425206,-408429474,1683923357,-2087135260,1951064418,-1730266651,-1391440484,-297602598,-1503314512,2139016721,-1725675060,1298438457,-666105249,1038086948,1633832684,-685939828,991223808,-1559172722,2094452302,417491877,-1108176165,1312128853,-712724227,-83341000,1700224696,186452820,-1260928365,644044973,-885562444,950578249,-552380561,-1944701989,2048561508,-1930551823,1865320212,-1250141528,1486872467,-2006534110,-1916678468,1441328768,-89674626,-1383087160,2022536288,848987224,-479278913,-735469098,1511090697,-2012580716,615062094,-451058434,1931172846,235021311,-585533441,1468999929,-1794287996,-462061298,863484208,1681861063,-1946328439,397565056,-1625300683,1053538959,-481565922,827617188,909346832,631923736,1767428373,683203882,1376383534,-417298059,1977210279,-1770130761,-1186883581,2135744911,275406594,938299314,-1482515046,-1550358546,-227731221,-1205174712,-1158453401,1564558337,1185868889,-1368178712,2118799503,1432624287,1342367860,1503499955,1044419593,574044829,2010335015,563285815,-1298285489,-1266980486,-951652023,910101842,-1770513430,1041891964,1562205602,-1171378286,-1067651870,2108905813,-1687434978,-1025173475,1476322433,1806120553,1218044481,459954665,-1700039017,-1766219911,1718240889,-340335635,2040629021,772369300,450181815,-1405955700,-773054336,1263803462,-1605900918,165275950,-274400584,519311991,-766039178,1326222045,-1652822801,473699174,-862186302,-668587236,-1360727714,-318010698,1400750156,264683977,1976456160,-2131126375,2014991484,-1048149994,-2145912617,2001170361,-701956044,-1642678458,-1894962594,-387875487,-2079503169,-288549659,130721405,-771572370,-1301452182,-1431665910,-192800231,1971736776,259399953,354956559,520043018,-1017561753,1471700965,2009117080,1265961161,-1843996113,818058059,-162139488,-632276923,-282687316,87046394,-1100569833,-2104601488,-1778890439,-765666154,506143440,-1919819501,2139354283,1114508034,491512841,1883450575,-1990858554,-1286307453,-1650613857,-1873037276,644195518,-560540546,560092966,1377706730,83645252,-1258019487,-484252189,1879405961,-1375254341,-1620708689,323224038,2038311450,1549925262,1669615294,-972358384,836689070,1457767036,-1902856178,545822610,-1478057048,1431108637,1127648167,-1919468435,-287584966,1265432144,-1081364223,8005768,-204496618,-535951221,490921972,-1441212200,-1965506841,822933271,616471665,-1614429320,-740700738,1991885658,-494785292,-365319322,318631215,197305943,264692037,1611741031,600239205,1387675194,1826618627,-1717877091,-78431324,1300513725,2055453171,-874596791,-1441669634,-1984313331,1382156418,551564246,-534032042,1199728804,-1761478950,-1842454481,344561696,1644275424,113159376,-1393912681,-1266705017,-1596176606,-672793390,-1038730601,-1828558359,-1047173682,1857652312,-253904503,1495314128,-1188670341,-313062557,-470669191,-2053920537,-775458133,-1992339793,-1587217045,61301753,-25637141,-824847209,-530135627,-1539882364,-977144006,1711045283,-1673590621,-800378568,-1474323996,-1702572340,1432998476,61556022,65015447,1346862969,698567003,-659358896,-1341456387,-110823798,856439954,1622183833,-480587080,1378938495,-1340962454,-755453565,-728879201,1800609388,-1178686322,944097085,-835897138,248935625,1576728369,-711183551,938739228,-19643705,1040491176,-126854171,-1959220606,-755174090,96950773,-1557394165,356658043,2032625431,479476585,-17194362,1178593500,1310281781,272753736,-392481383,-1456158287,557333246,1587771392,-409173164,-1378153780,-1413821564,625805371,-2101864601,1813589318,2059582876,-1661576545,-446303850,-21778794,-875711824,661314739,1624018316,-1520728033,-1211792455,1885998786,1108719291,1385664600,-210187213,-145704925,-174329483,-2070963131,-1194525163,-499757853,217863965,-662585513,101996808,-558079991,-884254422,-1697818620,468121834,-1248955104,1095771891,973259902,-170941878,2091533512,762505251,-1629728647,2082547544,1602075224,1365258095,161321480,662385545,-1838997921,1459820810,-1993604483,-2090815269,-1594471446,-494246996,1940977560,838843664,1541296875,596891531,244595436,-344193337,1984316821,1144152252,1377038243,-1731653340,1058497885,-336283158,-1470327124,-2132400131,1497973016,-533461880,-849511145,-872518620,1579447618,662017204,-448730184,42035184,2027482883,-88695258,305931055,-1217727763,645169647,40042119,-1042081472,1307979034,-1551303528,1139614380,-2044726239,2015516959,-1193595713,-646413277,1502249887,660551304,-270601363,-1625602025,-216972568,1448483779,-107612367,171327335,324451540,1312956215,-1331619258,1966728142,452237957,-1934870957,-284515563,1812422074,1801825037,-820983104,2121435670,1687578777,-1823230898,-445871743,516162330,-1189402543,-608405779,1171678461,-677150719,1687748111,679048153,-271747315,-1892306123,-755778121,1508375794,-1013381384,87642541,-460822271,389275749,267662307,-1929144162,330626335,372647997,864330527,1651346578,-1329104352,664631129,212254788,388187236,958651741,2000321006,839715080,-387251492,-855621951,-601191774,736465133,-819423731,-189001733,-373568948,518410267,1281591039,-1425408423,-1174520381,775016703,-27222881,240187598,1921872258,783615233,-1733278357,-1249364347,643043585,2126525134,1881687168,-252733126,1921599560,-1718123728,1762635669,-1163720733,-447932127,-1836353355,-953755562,122449490,-2041375442,680603494,-1100199420,2025995507,-83541067,479835870,-140055692,1973643785,-629727570,173103147,1489369059,53037060,313946054,-2005843654,-200905820,166105306,-1704067065,-871387854,-238542243,795393397,166445153,-986394705,1602731918,1902581209,400309333,-429749627,-137206988,-7653398,-886408930,-600266457,-2136438816,-1892019240,-1501907555,1505115636,1667910823,1730926576,-548456844,-2101119937,-1709982676,-1320331073,-2014320123,1060997569,1026704535,-1219075500,-1999411612,549497916,-193002000,1115022964,-1176994115,964715863,1887649772,-521629683,-4827364,1543638826,-719140232,2124185694,-46398839,-585705569,-245841106,751421253,221663563,2114852864,191997095,-903815092,-488160516,1957986415,970225832,-164238691,-133442982,528606724,-235989130,-190342359,523325468,1375961686,739109219,-1074112998,-610275001,64444962,-782644870,-1156493245,1204597169,-406189991,1350022603,1255978934,1780832474,1851613966,-2032112994,927631943,930756522,1399585196,-754469284,1822482071,36875129,-1633805474,-193919431,-1141308868,-1880755648,500241418,-1239673158,-2107389982,1124515479,345853045,-1026775288,-857384858,-314599049,-1120788682,-699830148,-1656353873,-291033856,1530579109,-1379009558,-1760294131,264319099,-1350482695,-1520011209,2110183515,-439486119,377233230,1424980627,23908684,1255469597,-1600537526,-214463843,1051933357,352203685,-2018637878,1825929961,829982610,-1806780496,378875211,1415599683,1185473692,306527209,-1213069701,-525957295,1041991140,1890456138,-1285395472,-99240189,-980358305,-634534846,979069362,-819736336,-1473598227,24767691,1537879185,-1542996469);
/*FRC*/Random.twister.import_mti(260); void (makeScript(14));
/*FRC*/count=77; tryItOut("\"use strict\"; s2 += s0;");
/*FRC*/Random.twister.import_mti(272); void (makeScript(14));
/*FRC*/count=78; tryItOut("s0 += 'x';");
/*FRC*/Random.twister.import_mti(281); void (makeScript(14));
/*FRC*/count=79; tryItOut("t0.toString = Function;");
/*FRC*/Random.twister.import_mti(295); void (makeScript(14));
/*FRC*/count=80; tryItOut("\"use strict\"; switch((x & !window).eval(\"/*RXUB*/var r = (w) = function ([y]) { }; var s = \\\"\\\"; print(s.search(r)); print(r.lastIndex); \")) { default: case Math.max((1 for (x in [])).prototype,   = Proxy.createFunction((function handlerFactory(x) {return {getOwnPropertyDescriptor: function(){}, getPropertyDescriptor: undefined, defineProperty: function(){}, getOwnPropertyNames: function() { throw 3; }, delete: function() { return true; }, fix: function() { throw 3; }, has: function() { return false; }, hasOwn: function() { return false; }, get: function(receiver, name) { var prop = x[name]; return (typeof prop) === 'function' ? prop.bind(x) : prop; }, set: function() { return true; }, iterate: function() { return (function() { throw StopIteration; }); }, enumerate: x.__defineGetter__(\"x\",  /x/g ), keys: function() { return []; }, }; })((Date.prototype.setUTCHours.prototype)), Set.prototype.has, EvalError)): { void 0; selectforgc(this); } L: {new RegExp(\"(?=(?:.)|[\\ub500]|\\\\2)+?\", \"gy\"); }L:for(var [b, y] = allocationMarker() in (x = (let (x) new RegExp(\"\\\\w|\\u00cf{1,1}\\\\u00d4*{3,4}|((?!.|\\\\B))[^].|(^){2,}|\\u5801\\\\b\", \"im\")))) p2.toSource = (function(j) { if (j) { try { Array.prototype.push.apply(a1, [this.i1, g2.o1.o0, t1, e2, o0, g2.a0]); } catch(e0) { } try { for (var p in f2) { try { for (var v of p2) { for (var p in e1) { try { this.m0.__iterator__ = (function() { try { this.o2.o2 = {}; } catch(e0) { } e2.has(this.h0); return p0; }); } catch(e0) { } try { g2.v1 = t2.length; } catch(e1) { } try { e1 = new Set; } catch(e2) { } /*ADP-2*/Object.defineProperty(this.a1, undefined, { configurable: (b % 3 != 1), enumerable: (x % 41 == 3), get: (function(j) { if (j) { try { neuter(this.b1, \"change-data\"); } catch(e0) { } try { Array.prototype.push.call(a0, p2); } catch(e1) { } s1 += s0; } else { try { v0 = evaluate(\"Array.prototype.push.apply(a2, [g0.i2, v2]);\", ({ global: g2, fileName: null, lineNumber: 42, newContext: 14, isRunOnce: true, noScriptRval: false, catchTermination: false, saveFrameChain: false })); } catch(e0) { } try { v0 = evalcx(\"/* no regression tests found */\", g1); } catch(e1) { } try { a1 + ''; } catch(e2) { } a2 = arguments.callee.caller.arguments; } }), set: (function(a0, a1, a2, a3, a4, a5) { a0 = y * a2; var r0 = x - 8; var r1 = 0 * 4; var r2 = 5 * a4; var r3 = b - 2; var r4 = r2 / a1; x = r2 | 3; var r5 = a0 + a5; print(r5); var r6 = a2 / 0; var r7 = 7 | r3; print(a3); var r8 = r3 ^ 2; var r9 = r8 / 5; var r10 = a0 ^ a3; var r11 = r9 % 5; var r12 = a2 ^ a4; var r13 = r7 * x; r1 = 5 | r9; r10 = y + 1; var r14 = 6 % r13; a0 = 0 & 4; var r15 = r0 ^ 5; var r16 = 8 ^ 6; var r17 = r9 | r15; var r18 = r10 * 3; var r19 = r10 + r7; var r20 = r18 - 0; print(r7); var r21 = r18 / r20; var r22 = r9 | 7; var r23 = r0 / r14; var r24 = r10 & r22; var r25 = a1 % r19; var r26 = r5 ^ 0; var r27 = r11 & a4; b = r18 + r24; print(r19); var r28 = x / r0; r23 = r14 & r1; r5 = r6 + r16; r2 = r13 - r4; print(r9); var r29 = 4 % b; var r30 = r6 & a1; var r31 = r19 + r4; var r32 = 6 * 3; print(r30); var r33 = a5 * r2; var r34 = r2 / r1; var r35 = r21 % r18; var r36 = r6 | 0; var r37 = 2 / 4; var r38 = 8 - r14; var r39 = r0 | 2; var r40 = a4 & 1; var r41 = 6 / r3; var r42 = 2 | r17; r37 = r1 * 2; a3 = r28 ^ 7; r36 = 2 + 6; return a0; }) }); } } } catch(e0) { } try { e1.add(o1); } catch(e1) { } v0.toString = (function() { try { o1.a1.toString = (function mcc_() { var rygucy = 0; return function() { ++rygucy; f2(/*ICCD*/rygucy % 5 == 4);};})(); } catch(e0) { } selectforgc(o2); return e0; }); } } catch(e1) { } print(uneval(a1)); } else { try { ; } catch(e0) { } try { yield true; } catch(e1) { } h2.set = (function() { v1 = g1.eval(\"e2.has(({}));\"); return m0; }); } }); }");
/*FRC*/Random.twister.import_mta(753880819,2095493107,733378296,-1189658423,14917518,-1697913217,-1465733855,357516502,-895453516,2070878127,-1757709838,-1221583562,273976399,2113852790,522182860,763066342,858451626,-1927266352,-1567057720,1410538780,769087901,2091227017,1991876320,877884412,162483622,586401991,1873704025,1285479098,101468237,768866437,303168869,-88171152,-1601277491,-945023921,2007883323,1811149253,-831249346,2144653978,1735391840,-1626208137,-448163916,31387676,-1724970748,-1183305188,-243862583,-557378255,32347343,31617887,678404837,523454476,78218784,-2056288418,1122428500,-1517042351,-927315315,611706152,-1914370844,2010801236,-955098747,1136476609,1633821714,-1445539058,1803682662,-915274476,1292367614,363349789,107842596,-1756404961,965221458,1967532139,1295399377,1339484276,1140239683,2122269127,247946673,-1912123874,1769202683,-1878945881,1119370002,1547278404,-1825386089,825909815,1965687700,1766399520,1482855218,1406350758,743116596,-1685542839,-585482153,-1518352218,1809921184,-1727141616,2012462583,1003194699,1106023253,1249180109,2111527063,-545689375,-439173407,1729574044,907027233,1909873451,177125025,496976268,-1245317762,-1793171006,1481897994,1087334321,1370936047,478943051,-658502527,-154519704,-1279000542,740246156,711785329,-1884470637,-2139016464,-469793702,682929400,-214387485,914925932,-131646944,566364373,-1176758726,339588919,2133723310,-182238581,-399926886,-1850994730,-1503850429,-639945597,1857527496,1978667149,-754055315,2002570806,-95279474,1936054922,2074639827,-55856874,1850062535,2065434911,-1670109188,836337434,-68236175,-713294550,-596876232,361657857,-1914034434,256057212,-1994207109,390336748,-1121218324,1624002068,1121402517,-1335885654,-1037751123,1808834702,780806790,-1660398289,211601181,1284146585,-1364495019,1391150001,-1178914367,-2052906884,-188645382,1962348314,864212471,436944576,-1975681796,-1826317045,-1059561063,775873687,1215569570,273783008,1591831822,-1021821510,101449487,601522410,87590959,310558062,-1064653412,830721851,1441753434,171146969,-973961710,-567498587,1971690917,-2132739440,-69712727,-2125589192,-276631576,887049144,285249631,957791704,-478564935,2112200657,582873149,1267395572,85643984,-1390795492,1629541771,-966257073,1038374948,2079351066,1349599624,1046415082,-2035473030,1357119603,566799260,-1876355037,1308892930,1331858576,-1620799862,-1540660394,-1316802641,1592064012,795722430,-1049919343,-808581471,-1258092151,353603943,1282862322,1182567189,-324654685,799432730,-86874111,464299932,942263768,-870318806,-668054011,-1968938032,1971137744,-1037533825,1614837959,416855019,-1349590691,-1676602598,-78020614,1162917391,-1881382409,2101279927,-1042284425,1838411195,508333747,-1895388530,996874189,-1756779742,2137508928,-810654288,182231741,-351643630,-1616883139,24051393,162066168,1774444108,615323641,-1883716104,1128799117,-1425450279,683963640,-419201005,-224715309,-967812669,-147536664,126536858,1921047168,-610352909,1345349336,760386481,-1334309256,638031962,-744054518,1084184969,-1191251239,-564650675,-1060727494,-1409878567,-290947969,1213938800,-1684864498,130235535,-1302672554,788277781,147037147,2060464189,827585710,-727407742,796768723,213888287,735736742,-541193435,259551878,748222414,-1091327889,-1408760762,363218374,-1937098670,-948251490,-1577210876,-1149800086,134416126,-953010829,-811203512,167606099,10480215,-410883022,1440023504,316158024,-421298134,1387599942,-1162109380,1667045245,1261987644,1796356379,84716864,-699335169,758897682,-1901526817,-205936294,2005434953,-419876424,714681677,18578791,681236435,1759471644,-190621307,376637142,-232143056,-171137458,2112349581,1651779094,1161925728,1935108893,1856393778,-364987635,411742490,1001507032,-834397206,343009840,-807477124,1139481589,1897847339,353571901,-479540943,-243255296,1478491597,-994851152,771415530,1978755540,-1381852668,-1721642346,549349035,801524451,-50773248,94321470,-1940885571,1009005409,-426255138,-371689827,599769379,-1885498829,191699078,-2077287906,-376432072,1252155752,622091289,-733025078,127118024,-1459907905,1221527021,1683944402,-1360961360,-877383389,359536385,1719260145,1057324404,-2094765252,1328124190,-403413553,-276501299,1846762938,956611503,-567335738,-317652892,1265920492,79298287,-1188728812,-1333582423,-1863621585,-1686018741,854650642,-1040787409,543348453,2063655296,-1685481712,1170107895,-568659870,-1811080073,-1309316631,1108112742,-199824422,-1500145889,-322318162,-2041203879,-2037154754,-1746695953,155500664,-2067588451,139839659,471744317,256257756,1418934516,-1204950370,1790758830,-1255562881,-711746886,2037594791,-413733841,581924420,-519834870,-1849219170,-2114727666,-1550456720,588996955,-1473338348,198201283,-1736707536,1074507848,-1895871842,138222781,-209078496,190568816,62797007,1863493016,150071823,1401678128,-914886876,-1871495188,966309327,-1291608878,662911544,56719768,1940928721,1947988048,-605993049,-1258800831,-1395491168,19842070,1989299260,1337480296,-2010719766,-1330289189,197181969,-711196102,-221331974,813442822,-1550233158,238760619,-2106593888,808308462,1431197120,-35616344,-58334286,1966906463,-682258972,-1315333987,1906209985,925565559,-673505969,1873814049,-323270887,-734907922,-511403861,-847339807,-1872446708,-1930882134,-1450099531,-608710255,-1542158763,-1716156689,-92539096,1827347915,1208920611,-520000772,1918938538,-1131719740,-385157571,422174886,-876873845,1642876893,-2090473614,-24947834,1447758408,552650821,655337188,468188775,1913076931,1309355033,1597980379,-1129370638,-1559223144,-570205575,1247832092,-1928601626,-140630340,77254033,1747110732,2093050234,-590909632,1075985140,995479087,570298358,-1197421987,-1607844280,-330775179,1586899652,1699376505,1453716398,-446538516,-1655762710,187325395,-574945628,854657812,783423175,-1986671659,40387274,1537647158,1145377123,-1126818488,-1963190246,-1256222719,-49006241,1986787696,1451751508,-1179944809,127666619,363628939,471645096,-1431451390,-1709980846,918655359,-429607597,-975184086,624908315,1229027538,242750166,-144469366,-819286903,-100012812,-978392814,1842841380,594062094,-1767719763,803533545,-2015673323,1391040287,-345821892,-537453591,-1723730538,1232795809,1758570427,1203822341,603427254,-1110002210,-80471120,-1755069907,-790351251,-1877748344,1726070048,1981137640,-1928108489,-278887805,-1310506139,-166136277,972355856,400395373,-1908423431,-764210829,755447366,-1977162542,1530486336,-1039364113,1993142401,1387333376,-1647451125,175600842,-962689148,-1726456432,-478138553,1402999858,-906353040,-894392303,-1067738967,-1710971304,-333163569,-367815214,1305030027,-1261990792,-1111831906,1390482129,-644435140,1030130582,1832443827,2103592420,374363018,-1536654262,1322643959,525056628,-1583573738,-1273463195,1158012534,-2065373527,-1534252893,-336715165,933455791,-290086275,-1881315294,1582126978,-1148258063,-285073416,-1484869147,1560385264,-893289903);
/*FRC*/Random.twister.import_mti(188); void (makeScript(14));
/*FRC*/count=81; tryItOut("o0.toString = f2;");
/*FRC*/Random.twister.import_mti(201); void (makeScript(14));
/*FRC*/count=82; tryItOut("\"use strict\"; s2 += 'x';");
/*FRC*/Random.twister.import_mti(210); void (makeScript(14));
/*FRC*/count=83; tryItOut("M:with({x: (yield \"\u03a0\")})var vmqcba = new ArrayBuffer(24); var vmqcba_0 = new Int16Array(vmqcba); print(vmqcba_0[0]); var vmqcba_1 = new Int32Array(vmqcba); vmqcba_1[0] = -12; var vmqcba_2 = new Int8Array(vmqcba); Array.prototype.forEach.apply(a1, [f0, b1, b1, g2.e2]);e2 + '';(void schedulegc(g0));");
/*FRC*/Random.twister.import_mti(356); void (makeScript(14));
/*FRC*/count=84; tryItOut("/*RXUB*/var r = /(?!\\s*){8191,8191}(?=y){2}\\w?|.|\\d*?{1,1}[\\s\ub06d\\S\\D]|(?:.)\\B|(?!\\d[^\\w\u00f9\\x59-\\cM]){4,7}|((?:.))|(?!.)+?(?:\\s)*?|(\\b)+?/g; var s = \"a\"; print(r.test(s)); ");
/*FRC*/Random.twister.import_mta(1668100032,-976408674,-1142168243,1946922856,1573360456,850918836,2034635152,-710267942,2124833659,-1437047480,-2031359669,-707968077,3635928,-2073983417,-335407556,928670870,-1113544514,1741012239,-405780393,-2139753724,-319711288,-832363341,-378817535,1259593856,-1356253739,-412757673,-603837749,1631175987,1067560270,-1573838848,436110162,1939106556,-1842886291,-1603717475,993765928,-2068542310,2008396694,-2024263824,2145805737,352519299,798768183,379908283,134186513,70312498,-399260638,-1486201321,1823263221,362774775,-932792920,-1250965650,1826990555,-459392993,-434473033,692372156,-204160815,-996766918,56579918,-2146023064,1720311877,1377102483,-456672433,144293655,2040115792,-543160562,2012873248,-441186321,622594640,1051042667,1753244025,-71722967,-394267936,-216486443,1962555007,-233152088,179009052,1394159438,-1200427743,-1231765107,-208274035,-2077561127,-1927546571,-717443733,2038661201,217223143,-2031691447,1073680648,-405886168,-1377877145,1060137194,637579358,1897039035,-45384938,330734388,-1059067595,1284681903,1700955939,2031139140,-1740281503,-1957846511,770270552,-694362916,-1084456807,-1214131525,-747548483,-1608752807,832870496,582409398,194932306,-942882156,-1926753642,-570597442,-399073674,-416902128,-1574206014,-1419937190,-1287256485,11685872,1770922332,-1995473133,-1389225871,1569057369,1448168067,-1055849985,781759742,1848645784,-584065708,-1255367767,282818251,-1512790204,1476022900,1026184138,-1872354533,-1164971590,719773101,-1867251487,-1613298132,-1330637108,1451069579,-2146416026,-1091072871,497545073,-1337782986,-1291524518,1197013892,-1527916136,1217248953,-1137254334,1964826228,-405447148,-1563388367,-748864015,1982474791,368308619,-926975414,478284568,1702304457,-652701337,475765606,1846336871,1747839457,1984035354,282983049,1944152882,1617210659,888838158,754002009,-358068014,921338418,1196876638,1218268910,1407855612,-820398844,-164902281,-279824469,92195717,-1797405106,-160068145,40822008,2015161461,-8408684,571291972,832157319,1741272470,-1326614782,-2035528150,880737267,1890582431,-1261667673,1778558757,-9550443,1118032937,-985369731,-923470237,724433284,-411656401,18880839,-606113421,1494875045,-1027345182,-940490559,-1616963118,553518386,1317879387,76097384,1580597223,1408886539,2096461645,-971982700,489691100,1177137863,-1185946434,-1902714920,-912981728,-678708648,-1435803052,1360664732,1960891794,1107848282,104538868,-1583586331,-1731848971,793841403,-1557180126,1818170251,909087622,1662388749,1727936304,1887552271,1014065158,1098158134,2036936769,1949297872,-870567337,-75623973,2060671142,-1902801559,-35627577,147053130,-2115284311,-482555160,1298703485,610869810,1662248430,982643495,1779119979,-818257462,-1866948406,135770068,622560113,-2126313239,-1247009490,-731840524,1055529120,-1695012983,930163942,1906810087,1442680855,454726067,1672843249,723148902,654272215,-921456289,-950824095,-519234501,231245434,890378895,1707300512,-13226532,-1323297382,119950067,942492239,550992736,-1862966754,1798102583,261248105,-1253495399,209448518,1860025689,-590121031,185643228,-1848322807,-1882430993,1799126369,1726073917,-917577055,1942376994,-134320055,-695135765,-938679116,161837630,-1623754521,-1698715439,-1852193558,-1008012635,-1195665854,-173062681,-513954445,1592023866,-1523353802,-148907764,-1701919600,629362536,-592646663,-490729873,692113865,-1998792538,764808364,-1540198126,-1446383656,770637925,1365812394,809975153,132046925,-305136260,1034432596,-372519941,-1025500797,-384296589,-1417264621,1711377422,-1185517652,753078288,-1967695084,1185935542,2057521637,2066382063,-1046874993,465905243,-463901029,-65391720,803606342,1884291088,327858529,-203843102,-992199640,-774271707,1309822159,1937252696,-22724246,-1118408373,958739492,189406370,1522522271,116028906,895717805,-624250490,-1428138177,-698932354,-1191741659,426604626,275634937,374659536,946593447,1047653679,1049808094,1687680774,-1054235851,-1593150944,724167923,1414349318,-1792120080,1256463540,-857163007,1870212646,2021414519,-997281887,1271962574,-1603411588,-908223536,-767278003,-1181498682,-2142170375,13043004,-1738299645,280088881,-2047784565,1021931479,9079283,1618618571,1085821510,429157575,541704077,1589677607,788074387,2109699856,379040740,974547776,154828297,-302307905,445179065,1975897956,-676107965,1672361456,-1272733623,1947472839,1932312957,1977223331,-2061921608,-1627950747,1295533842,-616373669,-2144190114,-868485911,1025718576,2049071168,1426306310,-436836793,-1672904506,2044862546,-1240761522,2164548,195473891,-1655029887,402748043,1681168278,2108821192,-1299161399,1270085022,-1543445404,1377315380,1005989374,-650735968,23359818,-1909182041,-1724539466,-91075648,1020520388,1112924266,-1495672341,1709425341,512284872,-1703797227,1057646826,1950428960,-777502214,366456919,1994293767,-2016350276,-717139515,-1821169591,-1791649663,-808945320,1434517622,129332590,-1642274646,999421551,921791000,542189528,1013128499,402819708,1956696678,619442810,1979358796,-1308635067,-696609058,1411631919,-1797164664,881873920,-389787604,669280452,1715352570,1938023401,1332550659,-7535055,1057056732,1009137203,1098506794,-585950853,40039940,-101163552,1369740314,1394656074,16975711,-462627385,1455645693,1904968494,168470741,-1214633563,-977269759,-1711592291,-339954218,1069430740,1742862321,128039861,383539107,-598065213,1835336091,-1107062000,-691252881,1566918041,-786573400,-1295323678,-497631480,1556147514,635542465,1184983012,-1041128025,1601926635,1041284609,-1884399823,-828311589,1728551664,1378677390,-2004332863,-665849329,-1097430324,1612881206,1047861612,-1008972180,-959995682,-769104788,464687951,243494871,-58051714,-1822281218,-2075669255,-1254588828,-956788683,-912165179,-872756876,1920125945,303686062,1873329319,743441004,300765837,2096739719,1768893000,-1120934150,-1323515707,-338549762,-877413607,-888258607,-432798824,-2033948525,-528964812,-1663838362,1048882875,-1622061704,963287362,516631864,-1294737901,1168114802,452716163,-312975691,-343658287,2040213355,-1242507098,-1101164024,-453920204,1578591978,-389930152,140586746,1966634523,-107782931,-1365057164,-444314666,366017777,740924679,130955201,1729407457,-422968377,-630506784,1370611516,-1276832646,1839810437,159611485,-2094898830,-1684804982,-1227355424,-1132034119,2012100415,-1871046347,-133358858,-1018223051,-838966798,-2142088435,-1190552116,-590231120,-172945037,-337540412,-1456742339,-119233957,-243734908,1544385305,-960545241,-2118024454,-1664489762,511872531,2102703410,-1918267472,395367544,-1276666351,-426679312,-1988444155,-30688550,-1883955653,-30079676,-247531012,98137500,518525558,174584440,1658237431,-1198665875,1045180940,1129294908,1226509877,1377902358,1506865104,-1542915023,-1925259893,1303199869,2046593313,410193296,155281509,-1201636811,-366866338,-579170803,-83100753,1329209328,-1868403568,-1645726354,-1311362026,957261455,1147969347);
/*FRC*/Random.twister.import_mti(406); void (makeScript(14));
/*FRC*/count=85; tryItOut("(x);");
/*FRC*/Random.twister.import_mti(433); void (makeScript(14));
/*FRC*/count=86; tryItOut("v2 = Array.prototype.some.call(a1, (function(j) { f0(j); }), i2, g2);");
/*FRC*/Random.twister.import_mti(463); void (makeScript(14));
/*FRC*/count=87; tryItOut("mathy4 = (function(x, y) { return (mathy1(Math.fround(( + (Math.max(Math.min(x, 0x07fffffff), 0x0ffffffff) >>> 0))), mathy3((( - (x | 0)) == (y | 0)), ( + Math.exp(Math.log1p(-0x080000000))))) | 0); }); testMathyFunction(mathy4, [Math.PI, -0x100000000, 1, 0x100000001, Number.MIN_VALUE, 0x100000001, -Number.MIN_VALUE, -0x080000000, 0x0ffffffff, -0x080000001, Number.MAX_VALUE, 0/0, -0x07fffffff, 0x080000001, -0x0ffffffff, 0, -Number.MAX_VALUE, 42, 0x100000000, 0x080000000, 1/0, -1/0, 0x07fffffff, -0]); ");
/*FRC*/Random.twister.import_mti(624); void (makeScript(14));
/*FRC*/count=88; tryItOut("a2.shift();");
/*FRC*/Random.twister.import_mta(-1476459145,1510617884,926781606,-173986817,-1721122940,-258409439,402009309,-1669736158,1076856738,1066082877,1873252800,972660030,758319282,1981811802,1342931880,-2088080418,-219472685,-824966302,1032386378,-991390419,-1249192168,1237159611,932305524,-1251342389,864868052,-160574224,1738564577,-2031793391,-343221312,1881974381,2074072340,918719874,-1394611924,1125453276,-1742186408,1154527521,2012035224,928236529,-2040626487,-132633405,361375550,1337336338,-1855235760,-1590920560,91612812,-1159736237,-1804466742,-1171277186,1629885912,-645198294,-1961456888,-697919945,1285614370,-733871407,1184937959,877999595,-1309346575,1010226723,-467595591,1066015984,-371967148,-737638140,137653059,499331818,-665759551,501422379,2044159835,-1840650305,-1728951560,893786970,1033371470,-518562332,-1057657548,351350548,2058114285,-2077048560,640552414,-1241436700,-1432992611,-711990128,1141690319,537492726,109763505,1908894125,1614921552,1409720933,-934892839,1229218774,-816158740,-857410791,-2136592741,-1625875211,-469630500,777797408,426974892,-555818070,-907351723,-112199146,274060616,-356529207,-1713535624,-53942397,2132692912,128350120,1070978752,1131912405,-1924695576,-72772795,-134052985,249311977,1248745047,-1336998812,-1747819969,-2021205695,-619110211,1322928175,-934468656,250429096,1272344606,1123171223,1960347051,1881229029,-1665756405,1164625845,1015942916,-1405730388,-46855722,50790703,386178237,2012873645,739526568,-329566184,665452023,1524698038,-2065318713,-1100216066,1962020873,-529496569,1520476661,-379590180,-2022650909,1625877103,2103922938,-1599786273,-1192334351,81827490,-1747570289,-663838757,-1308896084,1163327105,1547712452,1996550702,2051595215,-1501354284,-1546513599,-1061384585,-1212247714,11288344,1218056185,787481084,-1118842724,1044283992,-835825745,-55095360,1427840531,1692792661,-393194141,1308767786,768466218,-1428720500,-1138806776,1422221060,1378299059,-1403395550,-1709901294,440364238,-2106043319,1761126167,-1074951225,-401669778,1561698860,-967455816,-208195259,-360855768,1003712381,1344776596,-547094891,716627306,662573295,1687206933,-1524103310,-2144960804,-666930318,-1121768656,1786716781,1383492502,2097057032,-548781909,1967459972,-1308980819,-1589511323,-1147708818,481067458,-1133134508,-769461587,536855572,491023942,232237010,-217618551,1317465417,513507388,-1060995935,-419757913,412676439,292652399,570648409,675634760,-1149375665,1675923827,135345320,900451341,1588442977,2139444618,-2030043987,425034191,175226135,-450572773,-1178095244,2058386183,-1836992423,-810099305,644814448,338641939,1788838030,37465929,-1479075426,2078986008,-161839029,1214773322,-762320301,1679072579,1635938655,130687634,1592145849,-381078649,1976870703,-2132589881,1041213055,-803948016,1833421027,-547719119,1828313732,1645836267,1008268690,658388413,1484563220,-458662293,-749886925,592428465,648604312,-23829076,1653154103,-1386311709,822705061,-1261273495,-1262540391,-947701203,1293561331,-1792165964,343231656,-1320696032,219109251,1447103383,179543841,964926573,656139003,2012045401,1014464523,-1813066151,-582864519,179077881,-1439286904,-1641192662,207304062,1171652402,1188464194,-842390310,-1915598578,-1864749029,-1633196049,-913025443,-1868713292,-450965338,629845114,1905718675,1901341854,1513371335,789464277,-1701269150,-1917710468,1177585824,-839740722,1817868024,-343484955,-1301331529,-60996917,-946414567,283654179,-269071333,775850468,-252950582,-89751639,1658936539,-1768770829,-458672396,925031410,559959935,1282260813,-333980942,-123128310,2016261928,472429350,-1115087887,1840512376,1574073534,-1450074160,1045817403,855212778,-2100953521,686639123,1066301344,-1357366609,2056998948,-282499076,172877064,100865343,929047109,1966929634,2011991070,-884934611,-2111580400,1867414573,1303343834,1274305497,596141675,-2018579618,702130728,-1314156826,1016593100,227069608,1312861021,-1179430776,705038308,-495161415,827128492,-1365705224,662649533,-527957746,-964847333,759089295,1066599916,999903640,-909074451,-775648275,1530880264,1061743634,-110552734,-476183029,-1866303338,565096857,2038762364,-124917393,-1847986692,1183214024,1134463937,1988613016,-602209625,-176843906,1465703181,-276144781,800016845,364569741,1321777505,-1990120746,199747306,1435581017,-1285190105,314241692,-361611045,-187914211,1315326910,617350379,-402876498,194178143,-291707317,-1909954140,-1470382640,1785477221,844725389,-426840767,-331300211,1694609593,1152315478,-1083606935,1115258260,337512507,-1507081971,568635909,-581929441,-1282952473,1990602502,-1401503646,-2060476402,-310790818,342874638,-1489072300,21579482,-1222085312,-383095866,-976984691,-1850184608,718084808,-865811558,811877331,-1576835765,724368742,-1865385576,723887951,1349389295,334032294,675545729,-1918384424,635392900,898649787,-566964442,1365284437,1299094167,-315385855,275994714,896105528,2138885627,2075198804,567926254,659238429,2143133863,2023498879,406431556,-1298992565,1387065951,1171602617,-1802893936,598265577,-1954093590,-1910930060,1256121404,1891681219,-926313895,-69929599,1973232146,657481198,-900283995,-1132097129,18426457,610958582,1900094349,1759185247,1695471153,623240769,1568563119,1863870623,2004243996,1891631351,-555058925,1921663974,113928168,1276731045,-276665106,615698158,-1190331371,398929152,1674047096,-1916371302,-1029386735,1993327973,1684540685,-856322653,967385872,217775556,-1791806684,-2049940425,1751911764,-973528595,-622895356,1283147538,1850383873,752735672,-490715518,927410431,-1815032636,-1474707291,2033209945,278258986,-1168673468,-2101204607,1664927085,-469794622,-1032274481,725788111,-917116441,-147238628,-661992442,-610469882,2022940669,-2072298459,1459167149,-901378263,1691590442,877420000,-178203122,86967685,747003053,-548791521,1736191400,-875942050,-2005258551,-1372642234,-1826227199,-2018093027,-1206156495,-1869931605,386497234,-1049280389,641189469,-1213559421,1585566608,700230553,563490648,-1403450517,-171710155,-494927091,-196955958,1893496170,-1736031113,-844437560,-1448568793,-152062303,-1484259570,173369906,1931673683,-1981281699,696478213,-28901524,206602617,1761908865,1077651201,1361391848,-1477364145,-1520313185,94035584,-789126888,-2112030068,1653934742,535928578,-658755240,-386532589,1987951783,-2037838488,-649080224,-1476030674,-1353655910,-624826468,1603201808,2130823323,1327930065,1753880511,1611871274,1675635312,-1383034053,-867985942,-409254107,117870155,1240500718,1503065259,-1658317455,-1603747725,-2011600268,-76071079,20537205,1028494912,-2112293423,1363145786,678940912,-486720305,-2038643697,1028405705,-270992844,1496436071,996782514,-134619052,-1796600640,-286948884,-959390552,698469022,-37956423,1223730363,2118931590,-1016976741,-1532786934,-903005545,-1323914880,748150425,132014114,-935772492,912065506,1739324083,499627778,272753941,704332870,748499619,-1459057383,1400501844,722666963,890672858,581734324);
/*FRC*/Random.twister.import_mti(12); void (makeScript(14));
/*FRC*/count=89; tryItOut("m1 = g2.objectEmulatingUndefined();");
/*FRC*/Random.twister.import_mti(24); void (makeScript(14));
/*FRC*/count=90; tryItOut("\"use asm\"; function shapeyConstructor(hlqplw){this[new String(\"0\")] = false;{  } this[\"__proto__\"] = decodeURIComponent;for (var ytqjyvoku in this) { }if (hlqplw) delete this[new String(\"0\")];delete this[\"__proto__\"];return this; }/*tLoopC*/for (let y of []) { try{let ridevm = new shapeyConstructor(y); print('EETT'); print(\"\\uCD37\");}catch(e){print('TTEE ' + e); } }/*MXX1*/o1 = g1.Object.getOwnPropertyNames;");
/*FRC*/Random.twister.import_mti(159); void (makeScript(14));
/*FRC*/count=91; tryItOut("g1.v0 = evaluate(\"mathy3 = (function(x, y) { return Math.max(Math.tan(( + (( + Math.imul(Math.imul(Math.sign(Math.hypot(x, y)), y), ((Number.MIN_VALUE ? (x >>> 0) : y) != y))) ? Math.asinh(Math.fround(( ~ (y ^ Math.fround(Math.atanh(Number.MAX_VALUE)))))) : ( + (( - ((Math.fround(y) < Math.fround((( + (1 | 0)) | 0))) >>> 0)) >>> 0))))), ( - Math.fround(Math.min(((y != 0x100000000) | 0), ( + Math.ceil(( + (x !== x)))))))); }); \", ({ global: g2.g1, fileName: 'evaluate.js', lineNumber: 42, newContext: (x % 5 == 0), isRunOnce: false, noScriptRval: (x % 4 != 3), catchTermination: (x % 5 == 4), saveFrameChain: false }));");
/*FRC*/Random.twister.import_mti(514); void (makeScript(14));
/*FRC*/count=92; tryItOut("let (kewlld, x = (4277), x, fzzwyp, d, b, w) { for (var v of this.i1) { try { b0 = new ArrayBuffer(0); } catch(e0) { } try { s0 += s2; } catch(e1) { } s1.__iterator__ = f0; } }");
/*FRC*/Random.twister.import_mti(623); void (makeScript(14));
/*FRC*/count=93; tryItOut("this.m2.set((/*RXUE*/new RegExp(\"($^.[\\\\cA\\\\S]+?+)|(?=(\\\\d))[^Z-\\\\u4FcE\\u88b3\\u4181-\\u253c]\\\\b{3}+?*|[\\\\u97e7-\\\\u0030\\\\D]*?|\\\\b\\\\3\\\\b$*?\", \"im\").exec(\"\")) >>> undefined, b2);");
/*FRC*/Random.twister.import_mta(669690132,166902584,-551139478,1046564141,-488620304,958633207,189868210,1947878076,1342001389,-1709429514,486409236,-1476391330,-2035858341,1510843138,1373487743,93457209,2115630793,-1368804064,1312502119,-687339743,214832774,1351415396,-1335208452,-1600937745,-1389881997,146260031,1244914293,-295075936,818609016,69309365,1838540494,-1989483582,-1931819908,-1169912675,-724275068,-1084496399,793530194,-1694894849,2087562221,1187697374,428924881,135468223,1158617175,-1089207926,1942180604,1805176784,-1969044500,3895680,990547860,-1434366418,1971692862,-1815875486,1314108934,-951413895,1859304971,-49959697,-1295254512,-1931793525,-1543842056,-1903741900,-582298424,-920514363,545925664,1119645094,1668592435,-1489997834,1440837545,-311249226,-303302468,2077269453,-950583825,-1955942655,1477363760,1723018679,432697675,-2000998440,581580577,395814638,550418894,567719314,707572756,1879230785,1621120936,-1610302292,1013259047,-1976063665,1315400495,1583242239,972577276,-1084131821,-1256419682,-755509647,-637991570,-1158703038,548554859,-1443474568,-600089988,1331513488,881538040,1324008303,-1651591601,1276639068,-129706508,2059698766,-956680813,1572941816,-1476040044,644692598,-1656036777,1722924468,1387868824,468782006,-1357703827,349334343,-1866540950,710643836,825722796,1552797531,795270465,496494179,2089942253,-47866669,-1189282601,512255371,-1546132972,-1439746198,621245628,-795838375,819527521,1567520067,-792747328,-884692687,747344527,1596356592,-2061531023,-2004546608,651483093,-1072554960,1493569399,-85694440,1911413306,-770140899,377073736,-1744176509,287672078,-1062720503,867311312,1219197704,-864639682,706751591,2027402509,620405930,-326956627,1654586292,-967856187,1719913351,821571077,66954342,779226093,-1685954505,-145629387,-1438195587,-1297947227,-275957987,1251754758,1437185473,-693986593,36093137,-2011469588,1506947370,-626200307,-785375756,1607081341,-196719753,-438849617,1348535939,-1675783987,672449455,1404182667,1362051359,-2022582390,-422753807,178789679,535726117,-1880573535,902348619,-1339030778,-2029682698,1829939342,-2110029007,1052299425,216756705,-1681937532,-1097800479,-1438456066,988879747,1857030669,-1799964653,-9224398,-1594504889,709943594,1969073040,-937259888,-408085312,1414476019,540284313,2052070401,626957726,1046782722,-775226730,126716325,-740392739,468149641,-1314044642,78604867,-994286234,-2072585348,340475947,-1072843030,196732495,1008636493,1847729583,77724544,1608769181,-322286915,1498035284,110133039,-500828707,-851935011,1070546062,1976335229,-211192416,-192193047,328446455,1133077895,-1894048071,797006966,557670348,-1714771196,-1122863350,220647776,-1589516163,-817531617,-206182553,1979496367,16422460,-1502467900,40566703,1759697756,-278191912,-60007134,-244315827,-2114220382,-288915910,131518413,504496658,-1587747666,-1640525045,-1342255347,870085591,1610371230,571351353,2088443157,753811989,-38831506,1081785466,653654967,1894708866,918373839,-316458407,-638896943,1209762526,-1923434006,1367312071,-497020781,1447708313,-1029037808,-1926790601,1603960555,1941393210,-259737134,150889714,1375554721,-1818413985,-936688544,-1096842430,2010449923,-501184790,-483672208,2065050112,1313181537,1483410616,-302869242,1462265846,-297279215,239474162,933336524,1672575605,828260988,1659243225,-1111379735,-1873177732,-1671312048,-311069281,966336497,1110880834,-167971218,1342408420,1999621175,-1569277926,1381420177,1250064933,-97837387,1112359598,1128641079,-820601634,-1990696673,1638361638,478885559,898717817,357178898,-1857598894,-1494445221,1550300933,-184444305,-1238720126,-1279090244,-1927394902,-820402221,358838131,-1988514985,-2092300108,207453892,1058266451,972947004,-14267150,1660423501,1094148335,-192411620,-1908169654,-867323575,-1600318983,-692866834,-1872912779,-689388528,-1713424201,-519008471,250239213,1148204532,924333501,-1985361591,-79694540,-807631286,601433062,-207182786,1785532616,-1582294595,1461657305,-1705138318,1683246302,-1744889159,104955257,672095330,1013609739,-1866336813,1358343073,-62516868,-374161848,1620865603,-2058831787,2082547774,-1128375404,1502210612,-810425391,361749841,753959752,1268370265,-1656871852,247587373,1288712579,-416794344,920170820,1356034491,-1901101006,546178955,-813733739,1772967528,1110227270,394354993,-807838115,-1836731897,1034166984,-1000541755,-903804299,-1061953526,189777139,-648136632,1519187513,-1172676227,1642849398,-333096487,1276882997,-388049413,2074921778,655372749,-1460496119,-1800761509,677154120,-1841950616,-112273027,-681804181,438942134,-303938315,1972939873,-1225004016,1411984302,-656135731,736396881,-540448254,1988114176,-315644262,1033249695,-1080721373,663513617,1050448308,-781005173,305376590,1920797209,-1347933515,1564338635,-900901008,-1624885965,-753265369,-1346829580,-1551230219,263972911,-80533438,-2081201287,-223552714,-1030733189,-30374963,-151223876,-828180883,141933497,513982289,-907867151,-1521703428,-1320617504,851410179,-1163205700,1184092708,-2146825372,349841116,-1095732940,-531356366,-494178584,994688817,-1364858231,1710843433,1518774525,-23360876,-1542951586,-970854210,-860965170,-802072280,1959108478,-579040289,223338826,201349112,354833259,623325410,1271108870,1334421661,1367521336,-836354718,-525798144,732267081,-983405649,-1244008723,-1831932090,-283756223,106325577,-61075317,1536731314,67087882,-1974182733,-1986656075,-1749758465,-1362136111,1000949050,1509660819,821007844,-227285795,234727344,-1742176594,692487919,33237862,10393875,-1744589094,-1229650363,-2076762435,-1257827504,-699836801,1802903233,1235210786,-174653058,276993040,-1165703362,-1040663083,1391075889,425980767,1481182258,1137211811,1234853710,1031177181,-1003419715,-1529172100,-159693705,-1109799768,-60378786,742286531,1720225214,1517919166,-1990990845,1980934751,2131481014,-1551581108,236303154,-452944096,-1805506647,-559206906,1459183073,1466879274,-1103792188,1648967618,2005980148,-2007218859,1294488799,-662894646,789054666,1153606237,758440461,521545626,1465283339,1173733762,1768569890,-910844651,1830384229,-547456422,-160961373,1789104786,-2138012160,-251055480,446926677,-1728666701,701224980,-1725799852,1861827080,-428012752,-59974270,921812363,809645600,-1410087684,397052658,320565698,765656878,471516793,-1508971010,-1508990579,498608824,578006501,-1698135713,2042626241,-593781834,1684665969,-87695246,1392814450,-1293787918,-829285911,1633396174,1072075257,39228853,1413912338,1063792606,2079229350,1048974940,1675163423,-903044556,1750648224,-2103902228,854573193,-1391889060,-1545999947,-1592633707,1260777740,97143214,193448029,-1120699981,714925941,-249816285,-2133664600,-1035426154,-1295068033,-323253863,1686857668,-723847753,-762568857,249254356,2028384467,-1099111600,586572200,-1218292671,991735086,1174093096,1724731072,2033222067,-1258163870,809762027,1044528787,1407790298,49254326,177053500,-2059044615,-1968476990);
/*FRC*/Random.twister.import_mti(578); void (makeScript(14));
/*FRC*/count=94; tryItOut("return;for(let d in /*FARR*/[...[]]) ( /x/ );");
/*FRC*/Random.twister.import_mti(621); void (makeScript(14));
/*FRC*/count=95; tryItOut("try {  } catch(y if (function(){print(x);})()) { print(29); } catch(eval if (function(){return  /x/ ;})()) { (\"\\uC714\"); } catch(window if  '' ) { this; } catch(x if (function(){(window);})()) { (-24); } ");
/*FRC*/Random.twister.import_mta(1584769957,-1786166584,-1479282113,-581613919,-1987917167,-311017054,1101130348,-1712969372,-1510174862,-623538863,1012697703,1215103642,-1807218436,1723477899,-2115498763,1273368398,1655469809,1223607420,-425355039,-1635573106,61013347,-939769604,-1077848152,582163708,-523930785,59032006,280548801,1727654920,1248507790,620322345,1992850424,-372946805,-1726537894,-1608028366,1501787924,-2068041074,1003309140,1152679900,752779584,1861482357,519199225,1227089858,-585481538,-2016335181,-1020205484,-873228389,1214776185,52951195,-593253146,-544311453,-1196883503,1435936256,465631,-1460519426,662728140,1304418516,1641370670,-1314304434,-1513556750,1441584469,1396462132,901542713,2077793838,1445553106,-1215276379,903477173,-99095147,-1497062026,-1876598457,1742710263,-772667883,1611084768,-1082690193,-1328891752,1335755498,-2016148526,1514761039,-566140539,-263999543,1051973699,1684783056,-2054568647,-2100514544,673973261,-1706753487,40310211,-306236014,520323828,216815461,-753381382,1741133336,-1036783258,1725860123,-1867903879,605338712,-1670493725,1783825400,-2106726574,-1757718649,-1774927714,1721066173,-1541290976,-875083934,1044559019,-605584212,-1035214027,943752186,-567143466,-2033197148,970853724,-1216593179,1333364668,-2121554099,289185642,224707596,1532213877,-19658692,-1278386782,1408386131,60482005,1373715137,2019492380,707408708,1037407689,866063883,150610400,940796144,-1216977616,-927704120,-1948577492,-222341259,709748408,-1141826479,1160534753,314300425,-1660152289,-1640203812,-1748858714,1256384504,-257251256,-47403378,-1824399378,-1174124204,206594522,-1805105962,1187981554,1929629327,1674482461,-1519215922,1826027340,2137268272,1880575571,-2027384455,-796068433,1792660252,1887278421,459103590,382146202,-1123919664,2072132881,-1563231511,639945021,312669907,1405066248,-2086773729,430586188,-810458043,387368372,1095493563,-1471934944,-828972284,1357062124,-1097613348,-913257747,1810936513,-288982920,295258814,-726116629,1264250914,1354515127,1485588693,315533217,-140226301,-1592099338,-1044743473,1281267345,2095747109,224907745,-1500289253,-1517539440,1431415323,1703350370,1155022147,1741599734,1769556034,227105900,843168323,882667157,-860348974,1588574408,-2019709829,244162877,-2100652733,1946022926,1264196741,384723616,-32192682,2075735621,-62945028,138570602,-1103322779,-1407339832,-1498791457,-106339242,-1791203598,2032648336,-1764348446,1187747253,-1511734709,839256219,-1638251805,1007862611,-451906741,-1383982537,1713931542,520484785,582035187,-1579066604,-898704241,71139166,-454951823,1792005306,1035413894,-110237584,123934439,-230940343,-901045577,817487845,384055583,-757374900,-284005526,2135033509,-1422635998,-2124767751,1217630050,-174289789,1186917766,936612045,-263597936,-1040746183,-1023170427,-1606896626,1961328347,-900005128,1777396993,1522845145,-219535501,-1203786591,690209215,-1226229995,673763185,-21608127,197370715,85652835,612966881,-1498624956,1451527220,-1666954303,-423966159,686254089,-472060964,-979518815,977593383,-531579921,-250975480,-34161554,1377959,1315737211,1816986013,944064054,-326299769,-1770620093,-579210716,96531998,-286879761,1193984044,1694275104,581537164,1211590201,-973936319,2048714126,-2123821018,1582154830,1413262786,-504909937,-1946834015,-821057518,-916642005,-931363245,949951940,-119115482,28238914,1751517634,-1618127768,-10864476,-893528834,1454512945,-957028076,-1800234700,1928292231,-1805284928,1045970356,1665250452,1427463254,948489371,-783755467,-1546913047,-259342948,1106505093,1820034578,-1744197296,-295025366,1800741566,-908362224,-646400109,-824572071,-792992693,-1743715957,2006500166,1449337366,2145890545,-1647756338,1154137411,616463588,-509528657,1857776093,-2142433804,-1925691669,140006809,2124795702,-663050423,1715281019,-1971993200,-1784649164,1714057510,-1166888168,-572031620,1943609403,-86267875,-1208588481,1078619987,1416713518,1494659091,29375215,-1035932332,1097131977,2036084383,-7240500,1483194583,688267730,-1627106174,113014328,439458885,257176554,1722903977,1958866758,-2072774804,342501232,149762843,-1005265589,302992400,-122900020,-132159035,-1597206280,1974915769,431411133,1649010022,-1593024007,-814225843,-1262711307,-1948209907,-608642274,1999263052,-770511236,-1469050353,-908790812,1519673778,807074478,-1732192564,-1024942321,225283436,951620642,-441316183,-1343712192,-877029614,1843723167,1544209891,1251173221,538373591,294233071,915776040,-963155741,-1827660319,-1692802425,1506388656,-1744369840,76678163,1368867041,-144606272,84074217,-334585555,1849944170,-1348833154,1737975341,1735607350,334086946,1769397351,2058690330,516361186,1917840910,-1609755930,-272942964,-951592517,756019865,-2060601073,-2052994187,-23491301,155257342,-115612409,-1477689605,-1520017848,-1142970679,1093856218,920222451,-1519619443,-1046078243,-793548279,-949302018,1415389994,1085976806,-2099829624,1801825563,-1542083181,9421461,-80568174,-146632523,1789031531,1577929917,558346893,-2040948135,-1383653499,742758008,6147883,1385903210,-794497952,247641032,-1972946235,253099962,-561762277,49999052,-1419125025,1685319352,-1804895698,-1571582429,1255870554,-1588409297,-1803775767,-384679786,-321282097,-1180183469,-1531226246,-161485837,-581054305,1638789943,1200089677,1016308075,2051996721,15200044,-379599955,-1704668508,276332803,-824814181,923308416,-216665994,605893159,-186616518,1681645877,-431503802,-1553798180,-1103700019,493698961,-2068290736,-531488868,1519432547,1359984745,-431530110,-1314876321,-270713679,131041628,-514335834,-1160564153,52850920,289735633,618327990,1957105348,604785557,621225385,360309170,1712052868,1220590420,702836743,1443496929,1676144523,-481335535,-1715880307,442118535,667417509,619709402,-10860407,-1856354576,1735977757,-858037680,374663551,755912162,-153563152,-641800587,2140521565,-899268938,-761837751,120823489,1845054023,-722641359,-710447332,664175824,-46366482,160697153,-1921778377,-1201993179,1776041937,-668445339,-628646513,923000662,1676369519,-2127488472,-1002462323,-64908336,-2080403457,-1213819779,206635940,503639031,-913097456,-1577308457,444821548,1170736461,-856363647,2064249452,555728658,1289303401,-469805809,-2034576551,1017079796,-195504175,627977380,-1983859435,-1679214212,-1621260678,1839380937,309675856,685836583,38052797,30186052,-2084388455,-1807778109,920336027,1320931330,-1822819164,-1366865594,-1106521224,618432457,-538097616,-1713127190,-396122403,1590751270,1152085068,-523071518,-259847289,202404040,-349686190,133171662,-632369954,433097028,-1370150484,-1119849261,-505344022,378471335,-1809422358,1132843341,-565604491,1495927938,-1200224367,-1041710157,-1244067751,-152847442,269244036,308915197,1060722977,-204397281,781927867,-997807434,642868632,1353413763,-167885672,-349606544,1777518290,-1786115416,-2109723011,63033765,-1958468870,290193999,-456799374,-1431413794,1343462321,682708478,-1439129362);
/*FRC*/Random.twister.import_mti(283); void (makeScript(14));
/*FRC*/count=96; tryItOut("print( /x/g );\ng0.v1 = g1.t0.BYTES_PER_ELEMENT;\nfunction \u3056(c, window) { yield (Promise.reject).call((a => \"use asm\";   var tan = stdlib.Math.tan;\n  var atan2 = stdlib.Math.atan2;\n  var pow = stdlib.Math.pow;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    var d3 = 33.0;\n    return (((-0x76c2b9b)*-0x32dfe))|0;\n    (Float64ArrayView[0]) = ((+tan(((-2199023255553.0)))));\n    return ((0x6f6c7*((0x28858e28) ? (i2) : ((d1) == (-((+atan2(((+pow(((281474976710657.0)), ((-147573952589676410000.0))))), ((d1))))))))))|0;\n  }\n  return f;)(Math.pow(yield ({x:  \"\" }).valueOf(\"number\"), (/*FARR*/[, ...[]])), \"\\uDA9F\".valueOf(\"number\")), (4277), ([] = x +  \"\" ).watch((4277), Proxy)) } { void 0; gcPreserveCode(); }");
/*FRC*/Random.twister.import_mta(1079493121,-352869353,-433344416,-346261569,-1339275214,-205461289,-1746209227,188214537,1818587431,-1011551745,1973535148,-45776962,-279479821,1978800008,196145101,130350041,1138754579,-852936551,1554535013,-1313926647,1498103652,1093115958,588669040,157752214,-1367779217,1444086660,510854301,-1608981816,248894654,-973229849,-1532289692,-1248826710,-134248094,-911743550,-1182679154,483676144,344147229,-1291636179,1876383672,1187182122,-470073569,2060452469,-1705339552,-481339486,-1751853559,1495866608,-1743483385,-714901791,26024923,-1342290852,885399485,-1202942147,-1843362650,-28890781,177895954,817325372,1246729037,-2109696487,-46372419,-1543957537,-1933347079,-479690996,703487269,698958674,-1483233859,812137531,-248390504,-1681846234,1270197771,630006588,-1726883482,1785370023,-507344865,-1015785969,-172627430,695326183,-679087318,-1498509962,-87884395,1216029657,-1691632273,-1472619739,1467637885,-2074955580,384659365,30870345,-1131138804,-1151096502,-580103481,400042553,-950124811,1225072526,795568430,1332175293,327677822,-1787060640,1537622218,-2087017611,-1386397747,1541576158,-36839775,1646537453,662581548,-1759449071,-83152467,1298481708,197387869,935387414,2028162363,-1481526268,1925522028,-3753475,6223073,794169857,-492081660,1552804757,-1163277888,1766337659,-2103447118,-1774201318,417301204,-363900629,381172939,-406859577,-928615776,173890823,917864314,-1836916204,-1672253725,-1614618824,-1623142934,1449621950,-55770258,-39053668,1130620385,-1699130382,1819787395,-1739721966,834756453,-203052432,-235149870,886971259,-1644141176,-793526300,1415858991,-1016985097,702473081,-695800086,-1974802314,-1135763481,379945867,-1764885561,-280354305,-1124084578,13259938,388882079,1319865856,-764034583,-1614783429,-1451330887,-2033983192,1940299449,-1352327843,-1537672924,-1198666889,-1682035111,-1035216945,574913150,-1954578070,183093323,2047133862,933811913,-8096236,-314805253,-1264452187,-587998308,-2054181583,722905107,571436320,466214387,778317943,-2046419049,-1889503541,1614171474,390356298,-106100501,-619695005,1788054704,-1572529073,-5237478,-638861725,-1131108432,-374762203,762064229,-1466857574,1030232365,1655146623,819137870,-76432498,-649873489,519988,-1052248324,-1047986794,2102230318,-1095877367,-907421691,-187138695,745959299,2065198228,1976026482,2023070943,249248390,1518720947,439699450,-1989303088,-532513919,-1818247977,510712658,1112251119,-1780203509,1279652748,-1161000139,722237110,-642115243,-962998090,-1595838888,-1161294492,-1134027623,-1461118024,1297350279,-1640260126,-1359487759,-814342929,1297337753,-1423880846,-1874308957,48279250,-405049860,-735522920,-1730261946,-1822710779,506120668,-564066822,665437090,1861209607,1073161382,860777136,1634719532,-1194021771,-610335507,1501249937,1291999197,1933476600,-209468734,343027963,-1364690984,15390312,1764904292,938230271,987979269,1878290877,1701371644,-2024700514,-1613798094,-1605020657,76878242,-778542315,162458328,-1213528402,-1414209394,411646509,1404966085,-267783720,-527320189,-1416091434,-661706665,297841598,-1679282260,-1536283610,1030665146,745841693,1680245504,1918311987,-466328475,-506071537,-817749331,-1297230567,835745082,1486470003,1423978466,689818433,-927905894,443968218,1489681280,1194554665,741505538,-668270474,1680288400,908401477,-575557492,-2086460370,-1048121605,649560019,-1473712264,-1007655159,143868114,1795250003,-780996107,1212586041,1565041821,-612454882,659404271,727557474,970516382,181367311,360783724,1872590071,1051687144,2134432903,594525574,944915240,1714251297,-1315561112,-1374508068,2113867782,1544060215,-1897749052,-2046705918,1226161126,-2121967221,-1715180042,6741971,1597668446,-1575236523,-644487897,2026228673,2015700910,-1344161665,-1064018330,-1251272806,-985649949,-409891636,375250575,-910364333,1953592823,-328446196,1994127064,-1128602107,683463275,-275399747,-846759344,2099616374,-1816792913,395643344,1798840623,972409203,-1609949858,1786486110,1122265431,-215013073,-1091424896,-680289508,-1659680249,-970471800,-1574107983,871933139,-1177503288,1820707968,-1881357055,-687357056,-320477438,-1318891758,-1828437621,-905102598,1129658859,-1150412091,901980100,-401162126,1436224994,867354534,-786188015,2069855748,1042590113,-2086979624,-1231046629,-225809182,-1317859346,-1968993714,-1948622367,-371991573,-1207651531,324828668,-867539847,-1483269050,-843139218,1014125380,-1230452442,-217641326,-1503348767,-456218880,1467971413,1679901578,142055936,-378832791,655698875,-112271370,-1442132644,366251415,1569701948,544183938,387430759,9004405,325978914,-391539080,1667722529,267829923,-1024812393,-695714926,-2051845961,-105964458,1521594659,1379589016,-219721538,-113646553,-351578069,490065372,-1646054576,-1518162584,196696414,-1824795982,-1180033387,-566802204,1267586467,2137453792,-710029006,-1974900401,376611597,314248522,780559093,1542342135,-158391896,40878790,957164052,-1375277922,-52878377,-1374547963,602560138,-974218731,552138438,-456701525,-1885810071,1606387708,-1985153939,-1835369644,-83278467,886191621,181993818,678507824,-276125033,1137328991,1063926469,-1592463259,1483286381,1737303807,1853537076,119420723,-329815027,2084559677,-604925142,-1942180281,-980515196,-1723230569,-701927966,-1987760311,-433146042,486236850,-605228165,-186904424,3161743,-1576373594,1306548432,1341552699,-1759342621,-873660508,1396865017,-587660870,163626278,1044710483,-1552219707,1357884041,-1651288934,-797156415,-254412596,1612124158,982336793,1987312734,1163054601,1534000771,1662384406,879286308,-1593670665,976361953,-891134068,731067612,283556537,803540525,936526691,527518047,1078386346,-5400849,1446630730,1227796757,1743593978,1736030848,-436871898,-764217730,1184378383,-1883742246,-2145622814,-255676533,2124876456,-1794002615,984964339,-481859698,-1846482571,-790148684,-125653033,1944074069,454529348,-1992070609,458682559,-1457270649,1532494522,1436489508,212878474,-671623555,-1737649840,915931433,-1840173182,-552150150,1650001973,-1573753369,353997432,-1802889746,1086304512,-1479562329,-508278937,2121974522,-265837819,-1788887072,1742998632,817801232,-404435122,831546331,-75151820,1503290479,1054962656,825456558,-634190176,24498084,20911970,-1960643723,-450027116,902937360,-531662014,793621085,-1135496142,1211635887,2142989773,381391789,1364533568,-1486456247,772367518,1367744217,-1256843177,2147448520,-1332719103,115444075,1389575790,-549187366,-89363871,72374588,463503189,-1872536913,-1959614398,82596147,-960810490,-49665689,-95093389,-772075867,-787656098,1703251463,1124606758,1805617348,1721171829,1997970808,1630254309,-2140085949,877722629,1794674829,166268425,941941820,-211275385,-1509983515,1854069821,-176476238,-34089564,-211751862,678939848,-1887853761,-1184623212,-1022685533,-2039279733,-1145697606,1384852911,1395800556,-328086890,1772749517,557750341,-1726133866,1452695873,-639233647,695075635,1334548729);
/*FRC*/Random.twister.import_mti(227); void (makeScript(14));
/*FRC*/count=97; tryItOut("/*ODP-1*/Object.defineProperty(o0, 7, ({configurable: w, enumerable: (yield  \"\"  /  '' )}));");
/*FRC*/Random.twister.import_mti(303); void (makeScript(14));
/*FRC*/count=98; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return (mathy0((Math.max(((Math.imul(((((mathy0(y, y) | 0) >>> 0) || (x >>> 0)) >>> 0), (( + (x < x)) >>> 0)) >>> 0) - (((0x100000001 | 0) >= (y | 0)) | 0)), Math.tanh(x)) >>> 0), Math.fround(Math.cosh(Math.fround(x)))) * ( - Math.ceil(mathy0((( ~ (x >>> 0)) | 0), -0)))); }); testMathyFunction(mathy1, [0x080000001, -0, -0x100000000, 0x100000000, 1/0, 0, 42, Number.MAX_VALUE, 0x07fffffff, -1/0, 0x080000000, 0x100000001, Math.PI, -Number.MIN_VALUE, -Number.MAX_VALUE, Number.MIN_VALUE, 0x100000001, 0x0ffffffff, 1, 0/0, -0x07fffffff, -0x0ffffffff, -0x080000000, -0x080000001]); ");
/*FRC*/Random.twister.import_mti(547); void (makeScript(14));
/*FRC*/count=99; tryItOut("\"use strict\"; mathy2 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  function f(i0, i1)\n  {\n    i0 = i0|0;\n    i1 = i1|0;\n    return (((i0)))|0;\n  }\n  return f; })(this, {ff: (function handlerFactory(x) {return {getOwnPropertyDescriptor: function(){}, getPropertyDescriptor: function() { throw 3; }, defineProperty: function(){}, getOwnPropertyNames: function() { throw 3; }, delete: function() { return true; }, fix: function() { return []; }, has: function() { return true; }, hasOwn: function() { return true; }, get: function() { return undefined }, set: function() { return true; }, iterate: function() { throw 3; }, enumerate: function() { return []; }, keys: function() { throw 3; }, }; })}, new ArrayBuffer(4096)); testMathyFunction(mathy2, ['0', (new Boolean(true)), false, objectEmulatingUndefined(), (new Number(0)), (new String('')), /0/, true, ({valueOf:function(){return 0;}}), '/0/', (new Number(-0)), ({toString:function(){return '0';}}), 0.1, NaN, [], 0, '', '\\0', undefined, null, -0, [0], ({valueOf:function(){return '0';}}), (new Boolean(false)), 1, (function(){return 0;})]); ");
/*FRC*/Random.twister.import_mta(1601465414,-713986095,141044736,258560844,-2067167426,-628469307,905461298,-2010176521,1100748758,-791007862,729166408,-1288909798,1519820102,-1949860258,-1704744890,-1416185356,1463139051,-1808010036,-1909851272,-1370553051,-165942391,-1808244593,-48459363,-729436725,959666778,1691771439,-382364349,-1402883468,-1497127568,-810107422,-11888579,1883676143,-135782317,-445988526,-1872924900,-658192398,-1057495,-1572439314,-1456991654,-1098412963,-153371473,598419525,709488166,609090163,1861962942,-1408246328,1572857649,622272229,-1175637461,-528356981,1086352724,1777906837,49049029,-891949216,1206138210,897813780,179470471,480231804,-64614603,-709883143,1506085558,578106586,1461641974,-1247192892,1613258407,1626458401,711831276,-1834427154,366519981,-522223426,-1878908623,1914202106,1955476895,-1084984439,1425657019,-34892681,-623744526,38238547,-506575999,1332845843,969436629,-226115986,-1608308028,-1617010723,-703247040,-1989634203,-1772279039,-1526927803,236823673,-1285090685,1523026836,-1261521582,-296441208,-1806651611,-624847631,-1660495703,-120394085,-181704160,461551281,-490958458,-1284220118,1890247040,-1494216461,1167043582,1551939831,1443568765,812860503,-1247826693,1010684975,1320211029,-1181047426,-1721691131,1896754992,1735156296,-1100942336,2058994970,-1965745054,-457562625,-1720902285,184020837,597116816,1380502104,1511388983,452211704,1228386069,569369422,-368699772,1188163291,-1626986968,-1222457054,416517002,625021171,-141205151,-470830448,-1535149698,-1268035036,1505357485,-849847321,-301661371,-527408199,-167789493,-1655628474,-1219558264,-1855742595,445372867,-654421221,-1077321061,94029115,1625412747,871249533,-334196794,512361253,-887073361,662775353,-1574897792,-1062139826,-2120076304,762173686,-1808929300,2105574260,-773289939,1418279121,1398387510,-999210490,1609913478,486570668,1693681199,-437208073,-214833497,-2125213599,-890977516,1081693895,-114484593,-1844613299,-920676473,-171572519,-1660552689,-1542345017,-351065874,1051392741,-1662372225,-1939098156,-1352714637,-250723132,-1584501354,-283060805,-450192137,51943098,2067028926,860249576,-1556055361,394823486,507881672,-985296493,-1573309874,-346859578,1945505379,1529750194,-2101348752,556286847,-1596777923,1419018958,341716506,-1883856814,-975652639,269271012,1791819259,1393486455,-812069621,1488300820,-200445687,-1673685042,-2107440958,-1110259716,706905020,1454661951,-191994093,-358199289,-1060591306,-1974258864,-305858680,1958257438,751367651,903514394,-1986615619,1946813825,-2001262998,184607130,718282829,125166321,-1055257109,2054830486,623577046,543725707,1493416825,15483071,-482894988,1096963460,-12326343,-1976303717,-992863568,-1252840773,-129869787,-112530121,-1950325089,-1752248800,-1627853133,1937313132,1627345446,145326474,1795962618,11279142,1561822030,973356513,-1154119272,-424227260,-80766128,2108950557,-197164494,1494919250,-673272276,-1812615725,-1759283861,919455729,-536022465,418157327,-95356623,-317833224,1987139586,-16399377,-1801830194,1459598418,1162850518,141816666,-799524335,-250778636,-311034275,318208839,927984968,-1914794220,-121196832,-406386012,-1634660359,-481244321,-499752715,1014519142,-1923600284,-327063600,134554411,-627525751,-1846412535,756247498,1284805857,-1862490969,-2068717073,969746070,-1832118794,303569996,1556135868,895461256,1184871467,-1632975987,-369105973,572713641,1175378234,1296455927,-20949706,-991719146,1160338687,-1919124021,1429222901,-1011113999,-1786452822,171057881,-1371774477,-1596215587,-1406095625,-61647608,-1518769263,-226653412,1045343466,-1039498171,-904950457,-2043844968,1109910628,485745747,-1581494777,-671185191,-379519590,-367909368,-1665895224,1931314904,-569488760,-978254309,1358297540,3098616,-1068974411,-640644531,-1009475640,-1968797282,346334254,1816570776,-949023380,1776621126,-762576263,-503257569,-1918751560,-289300870,-58022055,1020676639,1684471491,-639244387,1780836262,1184020172,-1021068611,-1895618425,-1038153843,-1599533058,-2049035077,-1460897887,-2007597282,1946053794,-679956128,-1851270102,229423441,-219324511,-1764588039,1796828692,-153944954,-1052903671,-908969228,-905885223,-1107767706,1198214833,-2128250746,973101929,132470340,-2032596681,122904822,2058959352,1513003323,607785871,-1048800350,1139105570,1411968647,-862688741,953239123,218957826,-1184340485,-1772922253,-1914733320,-522660251,1321989263,36494744,-1144417707,-396000716,-120563928,14559291,840828231,194646522,-1608659320,-853255545,1484459570,1468522253,-1732853444,-1105834432,-314045199,-1305618847,-1671659883,1037851167,1749173921,-1472632825,-613147001,227646136,-1645525196,-1018583510,1476542497,2022793787,1801390357,-367673210,-329712545,-1689609711,247928074,-1619324247,364168284,-1941016616,1944655307,-451955054,1560898455,-779906673,-525532128,957801199,801097108,1075451234,-1893536241,497626194,1374170545,2051469484,683804138,-1188786154,-52091233,916723382,1102518128,334120487,614983898,-1858239885,833408645,-1112503061,-539773164,-234083320,1510296292,340290644,1028077611,1815819275,-933148089,800891104,323844201,1876420735,-2103990042,-1550407061,-1444261786,-1405118448,-1440586977,-737491218,-605684030,1348529376,1831117530,-383069403,1782959431,-1702552729,753309347,-522923922,1246030171,-303057648,1023720501,-738092220,1925679558,-1306748574,296297077,1005039398,-2064142045,699170486,-2092912234,193335411,1405651136,-1327506271,-550462812,1600888337,1653262408,-1712660698,-939828530,-1738142119,1759974640,2115955554,-700988969,-841969703,1270484081,-1525629883,1288427584,-859422222,-865972363,-181856809,-1530596966,2081297374,-1676850034,-1246856154,460233572,-656031307,1092186380,-175250084,1590633226,-775884792,264538150,-1079845129,-2051531537,-230587149,-582707100,-771765896,-864383792,868684213,58510556,1088683849,141464913,1128059283,2053879958,-1182181240,-710472451,1259633801,50579013,1029450571,-1346653643,732092519,1737085797,-124225677,1980812023,153064535,1339608448,1545118260,-1406078388,2107691119,-2111593227,-458184497,-1432443862,-865110409,1992044548,1286338813,-1925125535,-1621766729,-2002429003,-1174566029,-1636683120,1909818307,-583834271,-1669403363,574293041,-166706070,-225731105,-1313998952,866607370,-560873159,1495846782,576940302,1523030640,-261160172,394191804,-570669615,2008167702,-1301175785,-32255343,-272261684,-480339011,-2054639562,1405835692,237080652,-1858198242,2110406278,-424788363,1292853748,-163057680,-1904483767,79338066,1476081096,507131151,-2021239892,2077726648,-1501319752,1331811277,1819586936,-2113184977,-1073866673,2054007798,740862146,-954033213,1016154780,1351753896,1599051307,1477261175,183694377,1718989120,537196989,1534672047,563728538,-235448636,-374568827,-1134256402,2041088548,50941917,236289887,-1165069617,-1647404696,-1150785364,-1910908515,-1857065146,-929275813,613684468,-1890549584,2072964042,71860229,-329878866,-1131907856,-1210620529,1987453715,1453915799,-680894197);
/*FRC*/Random.twister.import_mti(6); void (makeScript(14));
/*FRC*/count=100; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(15); void (makeScript(14));
/*FRC*/count=101; tryItOut("mathy4 = (function(x, y) { return (mathy1((((Math.min((y >>> 0), (x < x)) ? (Math.atan2((Math.fround((Math.fround(Math.ceil(x)) - Math.fround(y))) >>> 0), (x >>> 0)) >>> 0) : Math.fround(Math.pow(Math.fround(( ~ Math.min(-1/0, x))), x))) * mathy1((((Math.fround(Math.trunc(x)) >>> 0) ^ ((( + y) | 0) >>> 0)) >>> 0), x)) >>> 0), ((Math.max(((Math.cosh((Math.sinh(x) >>> 0)) >>> 0) >>> 0), ( - (Math.imul((x >>> 0), ( + Math.min(x, (Math.asinh((x | 0)) | 0)))) >>> 0))) >>> 0) >>> 0)) >>> 0); }); testMathyFunction(mathy4, /*MARR*/[this, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Infinity, Math, Infinity, this,  /x/g ,  /x/g , Math, this, Infinity, this, this, Math, Infinity, this, Math, this, Infinity, Infinity, this,  /x/g , Infinity,  /x/g , Infinity, Math, Math, this, Math,  /x/g ]); ");
/*FRC*/Random.twister.import_mti(576); void (makeScript(14));
/*FRC*/count=102; tryItOut("{ void 0; minorgc(true); }");
/*FRC*/Random.twister.import_mti(587); void (makeScript(14));
/*FRC*/count=103; tryItOut("this.e0 = new Set;");
/*FRC*/Random.twister.import_mti(597); void (makeScript(14));
/*FRC*/count=104; tryItOut("\"use strict\"; Array.prototype.push.call(a1, o1, e0);");
/*FRC*/Random.twister.import_mti(619); void (makeScript(14));
/*FRC*/count=105; tryItOut("x;");
/*FRC*/Random.twister.import_mta(-1284624628,1982468935,204388444,-1569125097,963232442,42406187,-895943127,-126301481,-1770301307,-1192028715,-1413762964,-250138570,943711536,628331138,-34458371,702968621,126640350,-620774776,224826471,-1173945030,-1417289053,-1931874044,425699004,-1329507982,808000473,-1554681996,-917779565,1188370148,-342544087,-1790646006,69486778,-668831,-1556680410,-1467763794,1433698582,-918512673,288958485,-608770270,-605922653,-1282587847,-1298410415,1038545657,839572976,-879198016,547616850,-1235200969,-1737918070,-1587953392,2020984425,1372387375,272918142,1202532649,-681124936,972509269,243903198,-1592342345,1651823797,1870331138,-596896445,2142240050,2129490450,-1457989219,-1186855415,1089916906,89115743,-1089162135,-580999015,134290763,1611607231,-1137900899,-1876500264,-922065065,472355452,-544030687,1193912970,657317282,902084966,-1796526806,716301586,-148172813,-1956755883,1102624535,-316657641,-268626045,-200243749,1365677257,-1057958002,-1915819485,811918655,-1303158930,1158464696,362847500,1254766699,865280105,1340986066,-1920543902,76242546,50211408,-57751782,301998564,-582628219,-960798490,-1375628275,2066392017,1193552694,636871534,-3574404,1528501830,201237971,128174555,224263016,966682260,-969157512,1107253514,-1399057787,179176983,1425505495,1342579337,775078814,-863028308,-119821228,2021181332,1052575817,-1091589239,1343491822,1030594067,-1185114591,1978182530,-501728231,-1714501320,-1061403601,-1581136342,1286337027,-41677174,1905750389,-1839360788,1195174495,-1743062134,-530639532,-1406164102,313535639,-141070328,-1407603186,1450113227,1372008861,1819452856,397059125,-540775778,-866888932,-1152733822,1226341626,876462525,1932896432,-1889384112,294455268,-1646101351,-892862106,674099911,-1999632944,1131899158,1122097967,436975761,-56008646,919758141,753095768,-239670856,1537207856,-135356368,73211198,314594460,1262860715,1536028425,1070308021,517595297,1717764485,-2076109708,-987629584,-457723543,-1147669717,1909691797,188398366,954254358,-151207893,1417522329,-1184632886,-173552725,-972416783,1179499111,-1088388276,-943104435,665907943,-1926656181,72638553,728838865,1501627169,668019757,285629381,1372445584,-1764554933,-781448522,1622717774,1817880141,668969364,-1600270336,1772064616,1570347238,1495485793,44058804,368205742,-1610135674,1074508984,-71306578,-1020790122,-294049422,1011571165,838921232,617085063,1156595823,-898033384,225218574,2115293578,1664792704,-1503317891,705988110,-1787064052,1391685026,-1830153786,1057918965,-325561632,-1247080842,-549187108,737952081,-1950618191,2131858250,1627806295,-1478453953,-666747113,219346351,755400484,1515645032,-422398208,417048624,-867453591,-614145202,-1858544232,-619555871,-1011121268,-1678095440,-2004012607,752467393,-1332257567,513989246,660586843,-724496545,898527686,-1778189183,1922457051,1044089251,-1820811448,-1999002064,2020726168,-2014475396,187615480,-1204297259,247996026,2143459044,-989176635,-912033712,-1687378991,2017983895,-1595450647,33824825,-1302745702,692966493,-639666966,-1748530792,-2118126253,199463130,1094874787,-1425699640,1242879239,-657875459,1236671943,-1972939760,826726321,-624947855,166678234,-1545120936,492581510,1756515154,377453071,-1173539088,778196709,101640369,1424461312,1768498756,-182383429,-1102659834,-744115053,-1503594314,1238307128,-1428231248,-281798615,381933051,725660046,366071689,-1789212808,1891784949,-562153171,514890290,1462266020,-1093470322,-1921567366,1323718568,1152093586,-9174373,-864356886,-1900494417,1822316674,367881758,-1952525676,-1276992338,-829398994,1704504384,-1785763674,1968722118,-520629673,-1443515832,-1280150558,-530862487,44327101,1747127922,-567947076,-1749841506,1527559610,-1294841258,-230474718,1823978636,2093818459,-1939241361,2010909894,-1892969421,2119994676,-457585356,-1206984359,1759761858,-1141902191,529944359,-1088728508,-1786329097,185985176,621198653,505726325,29752224,-1419669730,438243072,-912634169,459009709,1824476453,142658956,-2072299301,1512778181,-628196615,-1730017752,946136197,842983287,-643623824,702108372,234961747,-923749516,-1436095240,255547054,-1764773313,389552246,466417653,-811141058,556702150,179424385,157375809,-953527054,74969160,825445941,-66006264,2043987706,-1754302699,1303385638,1173482775,-950183667,-936729225,-1169760698,-541671728,-762437952,-257915020,-546072635,-2082709206,2016753322,-878186402,-884864041,1581311988,801471985,-515670723,173967004,915032877,-914712722,-1145268663,1413170572,-1311912326,-602131317,-16361018,1540707236,-647387067,1305563222,-1284569353,-922764437,669608306,1244205955,1653170063,-1961376078,-1205637368,-344936791,-2306298,518162852,-1318840922,1541159403,1475013756,1982807409,-471084545,-1758154662,-577511851,1468607364,1696469416,2118151586,2106888791,-944076103,1282727581,-1542522455,-1658568752,1416279629,-416433499,610130182,-1255464407,479253093,-1560444964,915672298,-714722935,195546757,-1967364444,301795840,440184452,-882404081,540061732,315669958,-35240072,802292794,1758519173,2083937803,457722518,-569391697,-482368325,-548485758,688807746,-1390421241,-840567224,-1246707594,1696760799,462696009,-137678555,184082812,-1936616100,53497575,-351368327,1829902826,-303724183,70348105,-1308981742,-235997918,903344496,1632337156,55643629,-1137923819,-2147012604,875440397,1254704231,1534204347,-1084434644,-52375014,2120538599,1228190140,-1961302801,1758684575,1829525030,2059113474,1087234901,1998130417,910397283,1740182838,-205057174,-964512055,610730176,1298152191,-892211607,-1950544857,-373260169,-1883679980,1362407113,217398033,511696077,714632577,-502304941,651267138,-1568199660,1990497186,1545196245,-767823758,1137648126,1946058420,5091310,1883389031,2061897461,802959499,-1082677302,-908561289,-771752366,-938159888,-1568533694,545161778,1524790829,-783924539,762859210,1642164716,-635827945,-2121471773,-1332394769,2002391772,-314236415,-107847699,817679144,1093669250,1493839718,359552991,-1514753264,300212103,4917631,-1222316568,837127438,-214524563,-1018218470,1455738769,1981075912,-2119599770,-2072322690,572418761,-1569745257,685957264,-1828876163,1409224146,-1198697051,1534578744,-563913167,-1296976125,-2038285031,1987016834,-1964651556,-1174647300,-616487237,118765776,207218619,-1847765679,-121021739,-1761906635,-1501719249,-773108337,1878203876,-1284446690,1634947172,356842913,-218007795,808853344,-80479034,1551468636,708337988,1031021894,433858262,-1267628773,135936113,-1845029860,1052415280,477504915,-1663265475,-1481068798,-1896459703,-2097342021,1819689529,-236321756,-1619646178,-1156640713,1417771455,-1722010536,-2043569489,578526391,133492795,590830743,578292899,2132596401,1986365843,-1846719888,1495817090,-2143782416,2144600705,-1583028386,-1479501077,-540491594,-1326016812,398190445,-1057679019,-1242705774,560606875,-375552121,-1932909384,843285868,1027618451,830516926,-897009936,-1844385832);
/*FRC*/Random.twister.import_mti(15); void (makeScript(14));
/*FRC*/count=106; tryItOut("mathy3 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    var i2 = 0;\n    i2 = (i0);\n    i0 = ((d1) >= (d1));\n    return (((0x3bb7a622)*0x5c028))|0;\n  }\n  return f; })(this, {ff: /*wrap2*/(function(){ \"use strict\"; var cepheb = 'fafafa'.replace(/a/g, Array.prototype.unshift); var nicvji = (Set.prototype.add).apply; return nicvji;})()}, new ArrayBuffer(4096)); testMathyFunction(mathy3, [0x100000001, -Number.MAX_VALUE, 1, -0, -0x0ffffffff, -Number.MIN_VALUE, -0x080000001, 0, -0x07fffffff, -0x100000000, Number.MAX_VALUE, 0x100000000, Math.PI, 42, 0x0ffffffff, 0x080000000, 0x07fffffff, -0x080000000, -1/0, Number.MIN_VALUE, 0x080000001, 0/0, 0x100000001, 1/0]); ");
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=107; tryItOut("{ void 0; void relazifyFunctions('compartment'); }");
/*FRC*/Random.twister.import_mti(195); void (makeScript(14));
/*FRC*/count=108; tryItOut("\"use strict\"; mathy0 = (function(x, y) { \"use strict\"; return Math.fround((Math.fround((Math.acosh((Math.expm1(( ! (( + ( - ( + x))) | 0))) | 0)) | 0)) - Math.fround(Math.acos(( ~ (Math.fround(( ~ Math.fround(Math.imul(x, x)))) > (Math.fround(Math.pow(( + x), Math.fround(x))) >> x))))))); }); testMathyFunction(mathy0, ['', '\\0', objectEmulatingUndefined(), ({valueOf:function(){return 0;}}), false, NaN, '0', '/0/', undefined, (function(){return 0;}), null, 0, ({toString:function(){return '0';}}), (new Number(-0)), (new Number(0)), (new String('')), ({valueOf:function(){return '0';}}), [], true, -0, /0/, (new Boolean(true)), 0.1, [0], (new Boolean(false)), 1]); ");
/*FRC*/Random.twister.import_mti(377); void (makeScript(14));
/*FRC*/count=109; tryItOut("\"use strict\"; m1.has(m1);");
/*FRC*/Random.twister.import_mti(390); void (makeScript(14));
/*FRC*/count=110; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(399); void (makeScript(14));
/*FRC*/count=111; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"(?:\\\\3)\", \"m\"); var s = \"\"; print(s.match(r)); ");
/*FRC*/Random.twister.import_mti(437); void (makeScript(14));
/*FRC*/count=112; tryItOut("mathy4 = (function(x, y) { return Math.fround((Math.fround(( + (( + Math.min(Math.fround(Math.fround(mathy0(((( + ((Math.hypot(y, (Number.MAX_VALUE | 0)) | 0) >>> 0)) >>> 0) >>> 0), 0x0ffffffff))), Math.acos(Math.hypot(mathy2(Math.fround(Math.exp(Math.fround(y))), y), (x | 0))))) === ( + (( ~ (Math.max((( ! Math.fround(y)) | 0), x) | 0)) | 0))))) / Math.fround(( ~ Math.fround(( ! Math.fround(Math.imul((Math.atan2((y >>> 0), (x >>> 0)) >>> 0), Math.atan2(( + ( + ( + y))), Math.fround((( + -0x100000000) || (Math.trunc(x) >>> 0)))))))))))); }); testMathyFunction(mathy4, [-1/0, 0x100000000, -0x07fffffff, -Number.MAX_VALUE, 0/0, 1, Math.PI, 0x100000001, Number.MIN_VALUE, 0x100000001, -0x0ffffffff, 0x080000001, 0x0ffffffff, -0x080000001, -Number.MIN_VALUE, 0x07fffffff, -0x100000000, 42, 0, 1/0, 0x080000000, Number.MAX_VALUE, -0x080000000, -0]); ");
/*FRC*/Random.twister.import_mta(694137515,1482144730,-1477358683,-1107846048,-1844068650,-1966177050,743326426,1770621652,-1857388615,-468707764,-1533563760,-1558598818,1231854309,2123891428,-2144675553,-1331087720,-444570065,-128805986,1462407454,-1371333119,-847561168,-192103338,-217053680,1052832309,256392734,1288257712,951497369,-81214409,1015892468,-1577454174,835118389,-1945590074,63500883,262426915,-1008168814,-1409239422,-362677976,-1198701805,1690364138,1566663975,-1819181074,-30878627,26319206,-444932608,-1633138527,-288767207,1715006562,810836578,-1169620403,-2103552613,-1423760821,831505240,244616698,661939531,-1689032382,366255613,409959099,-538024453,65118354,608105375,1401625022,647370592,-1087004041,-1298069070,731722220,977408731,1756954124,-869423777,-1668669480,-1076346551,-143302136,-1031644062,-1242456536,-2003149252,2122643259,-150481446,239401948,-459115365,1400095236,-378510715,-1734371760,-1396071111,1390055947,1661452854,-980036682,1789996960,-2070029195,2120619372,-439779923,484621243,1139081018,930433029,-401455756,1257946959,2088304051,42486892,1986402777,134540526,783877572,1148012023,-1512110406,-361792999,-1442980920,-381420558,-1723335280,-702268727,-499853257,-842838785,-1775472861,416358777,911695563,-1055750801,1177428167,767661449,-1426382730,-278209439,1664111081,1423327281,1438245730,2082503108,209608621,-55559666,-1448913520,-679632707,1315310497,1415120285,-1293908687,176602513,1822025390,-1548426011,-2119786032,-769325292,1596159657,1004077426,-2002640235,1241743647,2069327641,-1653954389,-1350201776,-521376324,2063313286,252115041,-414082203,341678849,668831067,-1835603014,-1731798873,1473225856,-1366045780,-1480391065,-707616880,1334707600,-2045223474,-860070260,-1243093926,-955541980,-436426452,-1768582507,843364697,16058605,-814039889,-533205460,1892693314,-1863084235,1320422494,-416662332,-2113200668,-1720735708,242487966,-1326216271,622006794,2116298576,10432698,205825330,-741619787,224650780,1478725237,-1515185874,-190478412,-157537662,742817131,1497705484,-1353716017,914986657,-558927796,-472802703,1314908407,394951127,1760234469,-194356068,-2081795351,1207834062,721979061,993944326,136134514,-33693948,-653465108,219617892,-742845076,618472216,913954721,-1780593051,842364087,1933260687,234590436,-1746855220,2118972139,2090640964,-2115049037,959283678,-1108901721,508035018,-694651929,1627227866,-959924546,1000200776,-1395951739,-439773735,-212100971,509625950,-671032377,116395097,1732888171,939392533,1492719727,-1006780909,1419710717,521378779,42089697,-934067381,1895894039,247527633,-179942077,-2050629842,-479104876,1684263149,999414852,-1307274494,-1909268630,2047197541,854972156,1057469300,-585414849,-1390671645,215157425,922177752,-474072103,271914511,1005113961,1918048447,1905368842,-2047906196,-5670976,1651608186,1763773096,-590424122,669811116,947563153,-932940322,2146441375,206738589,-2038434578,689174199,-1392118251,-2022963103,-548571561,967891215,1194303193,453220937,-1997896499,1030782659,-2021351828,593992168,1255626263,2075633326,1671317563,-948986378,311077317,604833084,-225028186,-1843913878,1719719806,283588597,-641424964,1803998108,1192626175,902650419,488964349,315568841,755150767,-1347972406,-442193343,-1605511588,1120614668,-124176771,1058154842,-520413494,128911518,-1850597319,-787081548,-1644876828,-1877586960,628002808,467968795,2000823168,1507762616,135921184,782776857,-476977120,2035197529,2087631345,-2094118645,230818932,-1496835396,-657152770,-2081159336,-1028232269,900453243,1032060682,-304272322,319548696,456183204,1883511372,2090970506,1923662989,-2016781264,278371539,-66699445,55188978,1906793289,-581796661,-1235937842,-1644298746,-1884126486,-727029292,-284298958,1854602047,-1858502855,1580136071,1036002980,-1285755057,-707434772,-583648517,-1505783398,547859152,-783898123,-1427902840,334755471,796649770,-332815908,1559645948,-662906428,1421604941,-1487912258,1200175633,-782470894,1997644652,787593117,-697998894,-1005168101,-809228977,1022209846,108167691,-1100108412,494758863,-2091645848,-1275018026,-453802768,729719259,-1302139623,1405104214,-1246567269,-653596799,203953026,1880938655,-33257649,999510264,1214939631,1813721065,-1004296726,1294813513,-1947234850,-1142819495,2000921209,-263349882,-1984626931,-1168960332,845635275,-1122729713,520841770,-105605035,920932324,295389177,-1008390799,-445303951,732424881,1280982661,1244881392,-254924425,-1456062725,1231808124,1367757564,702459307,-1661635186,-810697752,-331128695,26902552,1405440392,883918302,452168242,1348550282,1578124264,514258715,497769550,-1416216375,-1062791939,-236863547,-537139859,-1420889531,1424417078,1951344596,279917985,152793902,-218521646,-1358416893,2068073804,1866955573,-1044871084,-31794265,12221539,1276838238,-1439078128,758443855,-2122437254,-141333937,-813894053,-904893913,393866538,1281954633,1426412076,-1212326089,-675935920,1624759357,527490974,957530692,-167400505,1453245278,-719418235,-1169459711,928095865,1049993462,1711946707,-1810580466,-100675616,-1207958527,254155178,2119962947,-1718194539,1634179600,-1581161758,172130930,-2054976592,1052487894,-804770444,651572473,752875303,1064939995,884808786,-409525032,1905570396,-610991082,-1557561638,-303606109,-79464240,1757572254,1627597521,1123460669,-382621405,49383993,-1079316542,-1586614749,-716367804,1753181124,943909434,1175110556,777955826,1533689921,-1865001419,1797191422,529915300,-1873265644,1040337172,2110341360,-1147556255,1962087490,585110524,1923313526,1866727075,943469516,-1626874365,-1778294565,-1772136886,608362929,922581581,-1913092974,-1304798331,2127745465,974593052,904401247,27566591,-1567168403,-595424727,1846280134,1412090572,618282919,317318462,-1943338685,198976879,1799488219,-1074395719,-1087392792,-1872311980,1528316194,-1313204373,1469073799,634104816,1623033609,-884405119,-1595477242,-1855243348,-1037408331,-1241501400,578005206,-1481383937,-882268880,-1144025676,1507241624,1357622850,277991995,521756156,1999816096,1106874526,-1738116692,-1706775244,-1791480558,1545888519,532151081,671188476,467955991,846820595,-1264179151,-90718439,-742708104,-2132679630,-1778796126,-2046556161,471642965,1802199820,1980071568,1202999381,-192594261,-774337478,-1275865140,-1708992323,-759995567,-1056262779,-1406780205,1446048506,127954473,385892531,1472366466,1465787426,-922821894,-631617862,-2141636480,-1879842189,-1271746964,1634709663,-1237312022,1101514991,-1175826403,1265052026,1382810432,-1441525877,670186899,-1992807606,1394997261,1487068942,1865545911,-671015952,1713082758,-229705204,-1147074950,-71577511,545045556,-667505189,-1093863627,-1982837282,2106038815,1140338499,-2068116202,-131568111,1484938440,-1716968210,1083974871,9372200,-1002465006,-1412433706,-1690435983,1895893235,413647394,-1472802068,1533131876,52504769,1754379906,1957242525,-1295181514,-1076786679,1875217746,-1774982033,-618300882,-1070503927,1655675229,-2114103537);
/*FRC*/Random.twister.import_mti(139); void (makeScript(14));
/*FRC*/count=113; tryItOut("mathy1 = (function(x, y) { return Math.fround(Math.asinh(Math.fround(Math.asin((Math.round((x >>> 0)) >>> 0))))); }); ");
/*FRC*/Random.twister.import_mti(186); void (makeScript(14));
/*FRC*/count=114; tryItOut("print(x);");
/*FRC*/Random.twister.import_mti(196); void (makeScript(14));
/*FRC*/count=115; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(205); void (makeScript(14));
/*FRC*/count=116; tryItOut("Object.defineProperty(this, \"v1\", { configurable: true, enumerable: (x % 36 == 31),  get: function() { a1 = Array.prototype.slice.apply(a1, [NaN, NaN, a2]); return a1.length; } });");
/*FRC*/Random.twister.import_mta(1712897053,2050899066,-137498421,6371607,350294159,2147060934,-1473138460,1577071851,-1639224401,1406228048,38372391,-921601933,633310016,-914562342,105175204,-177310509,1635915137,-1073543098,1317940002,-1755569955,-1514292410,-758714035,-1836177165,1944795355,919311865,-1941398851,1449479446,-246509319,1807267741,-1364412048,-943924425,653660753,-1637817299,1844398359,-63360431,1476662235,1144011820,-2047664582,2026173463,-1009199664,-245024805,211935226,1740127532,1642187704,970610691,332114444,123399855,-1119947843,776090069,-1710759260,-1915130583,-1123995396,-1109189629,859575383,-1243036174,19640716,1325419970,-101657528,-2077110086,1469685148,-1965202139,-403309580,-124656069,1603017348,27931138,182964176,1863732996,1754479381,-365205668,1153630431,1442591331,-1116738612,903454018,1038077780,-1733651401,-1429918899,1343943234,24874396,-860640436,247033109,643681120,-225152029,-1909911847,-2086352904,-1609199724,-214354655,1198645388,-303641195,-114866960,2056798172,308560616,1595397188,-471846180,929886738,1061580578,-537723709,-1080305642,1672451744,-1713503784,1615653931,-2088963216,1824710184,-341433350,-626876909,1682308081,-867156619,-921408275,1608909788,1733983206,-51261949,-2087260556,-805850653,-1907565596,-1209305002,843011270,-2036635667,-414623221,235326998,754571740,320642634,897857640,1066641427,1296065848,1091831527,591592261,-614419611,1844574588,1641855696,-1390843555,544135137,-1571057909,1451227277,-1937261803,1601422880,1242120568,-2033143931,806239093,-1666489832,-877020310,615217755,-832544083,-1171148970,-868278109,-36391982,1219683651,1292741920,-240943244,-2106472252,-1764929301,1969140961,1338410804,417882096,1411865525,-296363492,-1726843893,-1589282578,1386454439,1439913425,527840086,-1565958691,460362778,242050097,-691721456,-1814087548,-498232744,-218736322,-694874961,-1786156514,1081852034,-22039082,1763893586,133166708,287445546,-416295801,300930860,2112335135,-930985427,-99878054,-188877006,2065244166,1305290393,955210322,-2081705120,-1765939141,-1551412067,-1404352540,953779135,-1970337602,-1290992380,-1948753498,996005353,-474150094,-979490189,1645547071,-860875378,-685280628,-1120903829,161494658,-1973928873,1022929978,439867955,-1114271589,-479394725,-2109291164,-203889801,-1095985822,-1478002740,-647765807,1545192135,1136978334,-454293709,695826269,25152414,1002674557,-168280120,-737364103,-389197070,-2009806313,999884210,130401290,1705065722,-982917448,348496826,1850820294,2026309599,-1847025156,394013245,-28241230,-954258176,373671455,-1643514464,-1219852559,1025205073,-645330770,-1254527934,-2088532595,1255874513,1162931090,756754462,1019568190,-687916192,-1312699420,988332157,-1092411386,-612851670,-430340591,1179523845,557933229,1927794125,-1438193802,1897697261,1226780185,-42967168,1660274754,-550896870,944699211,731471079,-477175336,-1073303871,21044924,1859171168,834173397,-678537202,-1634826045,1935480270,-1122752433,2034739811,1709984288,-1847841469,-1610042734,1646494862,1751749879,-1347898920,981548536,368666495,234225454,1246365337,-1612714057,-2075518161,-185658954,1081901032,613674711,768205138,985867276,1131636584,132107644,-1073500867,447892638,1752964348,-280875170,-1269366917,1368185132,1803703126,-900569883,924463032,-632887239,118785168,-1003646304,-706420586,2065893552,1976887980,-904014901,1044367903,1807475586,764730688,-926985124,-2132426554,395657072,389779472,689365758,456872866,-420180562,-530761601,723235571,-1407398343,24429046,-1186634050,212188525,1777943131,-1436171184,989107392,124019204,-509466106,533138063,1615509688,1218281326,-951631023,-1025901175,-853949613,1544006976,-2121788172,716899570,-1953924096,-1555998713,677444421,-1994934618,1835385152,1971922408,-786980175,250223772,-587085024,-978519708,-712724704,-1222996125,-1079170509,2038967960,-1007823406,574213373,159873277,591086150,1831496197,-803752004,-926379462,-1757555541,1232241241,-695093013,-1373717264,-1989591070,-1384356513,1919752557,17109435,-801591134,-1712948921,-407355827,-1660854228,-1850091263,1456650275,47678111,973629701,-1512097656,2114285888,-1119934884,186229985,1353032676,612055996,-888866665,-933018423,-524050401,989433093,-1413918770,-341697293,1575632504,1139546381,1787122020,-2013160824,1113569548,1653752423,-1661836222,1105776932,1930942437,-928178314,1938325883,1242333017,1025975752,1498558361,-10588385,-608828114,-934460106,-897820202,1972887828,-806552071,-1677184730,1939675096,-1353410599,354614209,-1267681474,1392216258,1469768822,899063627,-1411699675,-1179268657,903651279,-1566643773,-1273359612,1943286303,1391815225,2100110287,-135128044,-1982956631,-4605543,-213244880,-935482343,-295977627,1941764021,1946292260,619917586,472180752,-63830209,1690312309,-983530252,-1755680276,1011491855,-1106017313,1160147508,668281635,-1608956149,142089995,1540374088,66838091,-2086021926,1343790549,479944969,-608905034,-196856880,708751147,1356227613,-1270730089,-1584646363,130654555,193950657,-1000543248,1926060504,-317241844,-764110622,-1178460569,1631163774,-2088353398,-289785688,-1482016896,2017075816,-615985802,-362499031,-1417178313,-2135378574,-902324002,-1414578132,647753239,-449533684,-921988406,388121206,-277373077,881048484,-1678230919,841952586,-2000140518,-896258548,131498808,-1452475858,1456101880,886044750,139674720,-1424601352,611287638,144457001,-190728927,1958428222,-1876785799,459261983,1047697159,-543013372,-1047548855,1304016310,969953184,54403138,1956398046,-1467114760,245497116,2117967208,-18691287,2107683178,1907267293,-556750984,-1887178025,1287013584,1607103146,1647035180,-370892872,-1014970472,-1119285513,-1517673029,-846540345,880187531,768256026,1264976433,331791873,-144626558,866422070,419385033,-679515345,873826978,-2107572145,1519783721,1536381779,-170651508,-691517608,2092078029,-946913745,631739183,-2102899171,-970831590,817625878,2091714859,1114508156,-447671714,1249049002,2077280092,23279071,-1971647904,-378002608,-607888721,199719612,-1607469329,1280743276,-203853769,-71353295,-14020848,-1100675410,-1374806892,-2024773470,1660522177,-75209252,160902788,149785975,-1917083776,416501417,438250022,1773280454,-1165317188,-1872126969,683889546,-877847014,1905856675,1561225767,-1657487305,-1945841675,504105991,1710384609,1205423339,1462004194,-26874655,-1665819278,-1680718002,346361285,-2084484718,-53965541,1402875851,-897307946,1980392688,701293332,1295321835,-225558506,1615102969,1519587313,1693389542,-1913312697,1575364998,1581020906,-1349165761,-63423142,-353652348,-559987893,-1059986671,1970045426,116188729,-1211865939,-60382656,-516481433,-1714549616,97222946,155460202,-1246157773,1211766232,-942642464,824567421,-528211701,417743244,-27348059,1060393748,-1134425378,1337980956,2124298258,-441367366,-624452173,1457166630,1068386259,1485725119,-1242062274,-1085285921,-510015597,664715854,-1003020013,-1324526616,1722315847,833809407);
/*FRC*/Random.twister.import_mti(370); void (makeScript(14));
/*FRC*/count=117; tryItOut("o1 = {};");
/*FRC*/Random.twister.import_mti(380); void (makeScript(14));
/*FRC*/count=118; tryItOut("mathy5 = (function(x, y) { \"use strict\"; return Math.max(Math.max(Math.pow(( + Math.max(x, Math.fround(y))), Math.fround(( + ( - (( ~ x) | 0))))), (Math.pow((Math.acosh(y) >>> 0), (((Math.log10(x) , Math.atan2(Math.fround(Math.sin(Math.fround(y))), ( + Math.pow(( + ( + Math.PI)), ( + y))))) | 0) >>> 0)) >>> 0)), Math.round((Math.max(((y + -0x100000000) >>> 0), Math.sinh((mathy0((-0x080000001 | 0), (x | 0)) | 0))) >>> 0))); }); testMathyFunction(mathy5, [-0x080000000, 0x0ffffffff, 0x07fffffff, -Number.MAX_VALUE, 0x080000000, -0x080000001, -0x100000000, -1/0, Number.MIN_VALUE, 0, 0x100000000, -Number.MIN_VALUE, 0x080000001, Math.PI, 0/0, -0, -0x0ffffffff, -0x07fffffff, 0x100000001, 0x100000001, 1, 42, Number.MAX_VALUE, 1/0]); ");
/*FRC*/Random.twister.import_mta(-179152117,1754403180,-1397764800,1553253729,-1544227003,1736822698,1499217267,-2096103735,-577233898,-891815410,-367335280,1732860651,-1889182392,-90724963,-1771891335,1264014300,-1810131161,345188238,-1068250488,804519532,127521901,1501683471,524588331,1898405395,1460752792,-2056709138,-770502890,-1730741451,866479530,-420334252,910278344,-218571588,715100320,810440731,-918512323,-1676960311,1205861673,-1027612169,-2114638365,-373148615,494981557,807911645,-1286000378,-704839413,360625167,1091641150,1943272145,-468252898,1574278479,1806054620,-15945893,-1070555259,-887502539,-559380215,844661022,-896048915,-292752698,-69536198,183851952,534791111,-1656699566,1122661442,402403114,-610413449,-283683903,-1676888907,771332135,-14019728,1355182236,-1788000263,-75277078,-1813554069,164472284,2049598895,-118907171,-202030248,848489348,-1366191428,348137561,351823496,154039040,-1999212981,1964874674,1482261418,1266836663,1205301776,-1486361796,-2009983143,167190992,-1726962675,886317629,260214377,-2079047923,-567501864,-79135992,1713218475,1927932690,2020819762,1101225010,253723812,140309116,-885925164,-1980150084,-1702568966,1643120925,1912697982,591742270,1818709849,-983853838,-1473255294,1030991798,-93363451,-25192048,-1802142812,-1372349534,-949570112,207971642,96097007,-17865817,694587650,-1640093153,-237020749,-1919469298,180931890,-298916284,762032109,-986034716,1498170153,-1249031966,1336559989,-678371402,501424968,-1449416182,364862378,-422711754,-2090752487,-352017582,799941663,-1332884818,-1084509098,-681321013,376374238,-1523711162,-155797310,-2035736449,1955014870,-1293839275,701572251,479061439,-1719253708,-1569049748,877360551,1439917007,772140806,1496683251,-122358917,1046119863,392713986,-1841089513,604657355,615819643,-1156904561,1630326728,-1165240522,149044284,-1353950033,-672107208,-331796556,559666924,291706184,1143912401,1605722359,1425716861,-733841692,1009328414,-1444112372,-20663233,-2036959614,772980680,1969883461,1786628569,674839204,-1620881879,977623687,912334859,-1611170063,1638438585,-730617659,403315029,-1701172031,-1639196506,134191292,48858692,-121157236,-1421714857,-1292099688,1111293304,736152153,-1575291811,1965310881,504132610,-311053360,1214726360,1432216919,392978281,-1809592058,-996366646,394293431,956577091,1428160739,-226469787,-1126306031,-883522435,1147283446,381661145,-1365166902,-1949807374,1650640138,1533853626,-2027471805,-1644480893,-1409608114,280387885,1633423907,-1174863082,-1273048698,244998822,-1763848821,-1162329412,-1549060208,-1640417594,1685190194,1262570493,62950226,1539738832,570237729,-394293305,-57181025,2032921332,-1541750536,-1569243025,1377813912,1411826655,-106445006,-21539751,981235669,-1503920155,-1478327724,1285729460,-20815358,-861898304,1772715608,-200015921,-41422181,1576611919,-1084132602,-684374600,-817211017,-1302834206,502778128,-1315253202,-494423750,1245997431,1047623630,1161643279,1683900429,-617344727,-1939441717,1612945812,-1035406527,2025946031,44756195,475103682,-534251087,-487720823,-503830820,-46042152,606147091,-1169746082,-1423444287,1441386173,616329655,-671681813,-818593422,-130740092,-1275314703,1387881864,-1451308244,1967875053,-723525560,-1285834527,-623478166,539833880,1987350523,1258411955,323760852,-1216639319,-1854853983,-294201293,858247306,-970179435,1056885517,-970411367,609781028,-1966196590,1421002810,1597176112,45333256,-1671618764,2021667427,1797506429,-1566291881,-1957553226,677461247,-930580574,357929615,1179306596,-1725942833,447769665,-647072403,-576804134,-879137269,-1326016973,1120712526,1547566213,-83342011,-142882113,-136797430,-1523446668,-1992473402,-807839357,1681176349,-1163302750,-293763005,1760334858,-1276545966,-1830061450,-1930375631,-1122341557,-788562944,-163379434,-990786510,98779822,-893697796,2038318499,-551974578,-512571485,66397886,-532481904,571129043,583210732,-1974816935,-133785,948681751,-351522941,-494791014,186570372,405167558,-35840223,806457864,1034093563,859202122,1773472224,-1518070972,-25528256,1122772576,658032070,1399806358,75538330,-634602522,-399954964,1512915664,1557526820,-1596192373,-1789138929,-508233980,1894720996,1712211249,563597888,-1190470295,1089531962,-506777942,-839492663,978995443,1984400260,973252091,712205546,1145094633,461918882,1165639795,1514612564,-1259556017,-1310732725,1649529387,1251911908,1283511419,1967503315,554736442,629051517,-368805794,-1706660233,1172810482,659448639,761100544,-1666306787,1198488489,1588034430,-373410141,-1529078679,1521555985,-106715713,-1104747467,-973441165,-2125840535,1677831430,-1080805267,-1587338549,1134843309,-517213009,2068616284,97595231,1164391482,1378538653,2017326442,966349520,-1408729003,-768216863,-177943577,-809111126,63600686,-1838135409,-1855115687,-156178404,1316914052,-1635490835,-466580967,2026381255,1786054559,-1123482244,978483784,-752408659,996524930,-729600734,1205840824,-754890789,-666560978,1323931406,1192711921,926162801,848827605,406503119,-1888313328,-584802825,-881599158,-431945932,-1149541767,-722064444,-840159994,409790214,1726295366,-268803687,-1760692844,1637972376,-1922801752,-1455367031,-1284592352,-1769958274,-957183734,428795043,-90850123,-1545200928,1782839738,1668014448,-1572873112,-1029139118,256503080,-361488619,-1480239812,1942913663,-264610305,-401811993,265220452,573037901,1953312759,-1256733080,591503745,-917463616,933965682,-849964488,-1282732148,1487777045,1507156703,1707169836,-512085818,-1742685513,661874458,-44679691,-558321948,2088416342,-1114736013,-816862707,1009037629,-2019359564,-760984947,355791749,-1900717950,-890792691,-1840908007,-277752907,674966231,201768424,-288340855,256347190,-1034778025,-1831969427,748234102,1101592563,32292265,-2133016773,-1206581536,-2110310224,-4141371,698759826,-601903867,1981863320,1421473787,-117659198,1584442180,1576005504,-1636479214,-2096713362,-1409729236,1712996629,973833701,1062983846,98841860,2109585235,530568405,1448007135,-828266776,-1585547433,-1365033964,-1246651829,-1566710621,-424332217,1166208790,-1905689817,-1640587637,602741172,-1925929763,101130252,-1052538143,-36339067,572185908,-86559207,-1846869481,-1804070632,518334303,810884824,-1619007569,263827661,-547155514,612082838,1306635603,1526626541,384560996,1780181674,-573492249,1657506461,1270451223,-2024643749,-1440451682,-554095225,102642161,-214793852,-989794821,1494191787,908420966,903387891,-960834196,-777958092,1598888100,-789209111,-1796410504,1993689349,-758963116,-1093432248,1136598358,1178843784,-1611523942,1558467091,-2066990919,-661461597,-1512945841,761006262,-317480842,-1765032530,-1429410947,1586451429,-553526302,-993983641,-1229726337,539931877,-643463746,712861175,-2018493619,-426707741,1589769557,-2045455708,-222738496,142797486,-2110982782,1366288744,-1397950500,-250650647,24347581,-2083185597,-1283230654,-417082776,181202461,987200479,-1597890024,-850325157,-689689975);
/*FRC*/Random.twister.import_mti(77); void (makeScript(14));
/*FRC*/count=119; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return ( + (Math.fround(Math.hypot(Math.fround(( - Math.pow(x, ( + Math.fround(Math.ceil(Math.fround(x))))))), Math.fround(( + Math.tan((( + mathy0(Math.log(( + 1)), Math.fround(y))) >>> y)))))) , ( + (( ! ((mathy0(( + ( + y)), ( + ( ~ Math.fround((y - 1/0))))) | 0) >>> 0)) | 0)))); }); testMathyFunction(mathy1, [0x100000001, 0x080000001, -Number.MIN_VALUE, 0x080000000, Number.MAX_VALUE, 0x100000000, -0x0ffffffff, 42, -0x07fffffff, -0x080000001, 0, 1/0, 0/0, -0x080000000, Number.MIN_VALUE, -1/0, Math.PI, -0x100000000, 0x100000001, -Number.MAX_VALUE, -0, 0x0ffffffff, 1, 0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(303); void (makeScript(14));
/*FRC*/count=120; tryItOut("Array.prototype.splice.call(g0.o0.a0, NaN, 18, a1);");
/*FRC*/Random.twister.import_mti(482); void (makeScript(14));
/*FRC*/count=121; tryItOut("this.a0 = new Array(-8);");
/*FRC*/Random.twister.import_mti(498); void (makeScript(14));
/*FRC*/count=122; tryItOut("\"use strict\"; /*tLoop*/for (let c of /*MARR*/[NaN, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), NaN, new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), new Number(1), objectEmulatingUndefined(), objectEmulatingUndefined(), NaN, new Number(1), new Number(1), objectEmulatingUndefined()]) { let (x = (let (y =  /x/ ) c), e, atdcrh, d, z, wmibjs) { t1[2] = p1; } }");
/*FRC*/Random.twister.import_mta(1431933836,858355421,491170353,313828618,908414247,-1830236839,-1244514629,-228449514,570721966,732565302,51522313,-1553026355,-1091405824,731553756,-611496485,1459555391,-888951634,1143490626,-395458725,1000831010,-160691467,2004946661,-623408246,777619347,1205057997,992170774,-1386334161,1615586309,-1619944705,-1995100283,-870799943,-1702217222,-2098862852,802732494,1180717154,207070807,-165035104,1198933443,165224666,-1358903358,-345090258,-1532649985,-911980014,9489781,468536349,1952604309,1976838199,618872227,-308933568,-395874180,-1106794004,-877638860,-993730418,1092025920,858890425,-1436359532,-1231116713,-1556370708,763622213,-631879315,-1399253209,328396947,-769427550,24737958,1073946385,-1370159788,-1292806640,-1054612281,550551043,-348046837,369727456,1567110733,1585987261,110781777,330913814,975344818,-1250486986,297808289,87416428,-287103339,984011462,155209638,-602498006,1422219107,740640876,831793363,-1451453308,-236169600,-1228848296,171064321,-1453139815,1448361313,-593673632,621383825,-1278016555,1555410341,-582774433,-1192160082,553428296,-109558581,-81771634,948310792,-255060082,650059356,86248194,-1778276821,2107596286,932788732,-626873149,-1805761834,914028612,-1873928323,1651611397,1528787001,-1922883991,1232420523,1502024703,884038753,2016046583,-675327453,-536108625,-971562052,-42901383,-1256174702,813541868,188423264,699481166,1827041769,-1436261474,-751516135,276904672,1226979973,-726998329,-1335867787,1933663999,328732860,-187422923,656227825,1514794799,-1895503511,1420318010,1155126396,-1241843063,2065848247,-723474305,902422718,1870513713,1912305223,1229049228,-548117871,1562088583,-1878255476,-1707715746,-1282057814,1678852995,1005613185,699332277,1795038413,1525062061,522909050,-1704455353,1086552380,-2110125004,1271443155,1372426062,1334025738,1006451337,173249435,509240768,-788233827,1795371843,-776052356,1637398373,-649661484,-1093517416,949208903,1163201200,-1539580320,1723685254,-180757864,574224948,-1553887944,43043056,1402564078,-910289149,959013994,668833733,-1546062480,1183220459,-235511781,4247816,1194817962,-1550730148,-1873948697,-575522955,-1181967585,690655932,-1520844217,243872121,-1714583633,-1669975403,985461641,1822923158,1451203596,-1130220036,1113646976,191696186,-1342713975,875072483,1188587534,-1717063166,2058821701,-1870113733,-1697280611,-1787007001,344706833,-576875175,-591855564,-1679250109,1411397597,-427884699,913330721,-1553311789,640416340,-87209253,-1977868280,1149402259,134591186,1660742933,1381642578,1619811859,-1970448378,-1828157200,-1741590317,2073297497,-1892421230,-857144922,2139610739,-1318858063,1992386792,1117093136,1754701035,1781329830,760264285,-2145467529,1648920694,1750481160,-1875026769,1222655972,-1131956374,1519204543,-455936267,-588768636,1521094871,2147179910,-185911261,2008593377,-1791718328,-730735246,-1708618005,1587241299,-1169501178,326049200,1304416760,-330182374,-1119119215,1882934520,-1686135836,478762112,751585050,-1731392549,365268220,-579261294,-1649777492,1411329741,-1825131092,595544490,-1557913021,120258699,926463759,-901745084,-2117965549,-839367635,-897307115,1674380491,1155481985,-823579397,1328813582,972882103,310778637,1813136787,269845533,208138870,242814230,-930742867,-1570387576,988880004,-130397402,83615240,-459894744,-1058164728,-1448758907,1745802784,-1341126273,2073646524,715956980,-272958703,881352028,-334961080,1888472651,-593509481,1770800567,-55835021,-1925664939,575549208,-1780210070,-1616210631,2100452966,-471091448,-1303242995,-640837813,1923151891,1037301250,1784012738,477987539,-1035341624,-2104224434,-1447475788,2081993067,237505424,-844237555,410042195,2016924373,166270971,778929109,-1814621704,1261344017,-234914242,-130965123,424678542,963089952,-812466370,1814601429,-1137671695,457021638,-1852064007,-1773813380,-802497049,236637450,-334435569,688762081,-695475328,-831098188,-2059429040,497515172,-269809444,-551032582,-1217985105,288027521,1400099813,-1443137712,1201396239,22681886,-1947657451,1181429441,1238732236,-1498200670,1458051831,1775208847,-1041338497,372569823,-91597587,-1129360220,-1126661399,18943429,825646974,1968959702,1305509287,360826599,-95540413,-2089758977,-1679630664,-2759641,311243639,-285737233,1340025816,-1543363247,-1750320618,-76092966,-1357275234,-927578197,-1876240204,-1482438720,515010299,-1256502919,-1108341002,-1047737344,-525022302,-457417389,-1246547839,-1145755987,880656088,775781319,-771052319,1585763179,1240392761,1492021526,-379632417,1462874351,-1488344336,-1786597589,843816037,-528168191,1440563526,622483865,-1891654831,153942546,-1445094528,982594436,946969388,-1291954694,1840246244,-2054004310,904281044,710226610,-23365162,2054640259,-74134976,2069483422,-57210226,-2017346561,-939900430,627025474,-1658352621,1156004442,-784059169,-353740002,-2027736900,664673633,538146610,-949523364,-1086457482,2003049165,1830127211,-1331983581,-56858940,-291296134,1693204482,-1238046572,914339947,563259996,223851775,-274346323,933429001,-860835023,143128823,883697617,750398864,-1174417755,1039993059,-742946279,189054613,-1987977658,21094205,640714979,-98330482,364391533,-1755660386,-858459538,1004528342,1483819648,-1314180145,1935107650,151155617,-677795269,-455966543,-278585868,-1167931041,1170696405,837206184,491612261,-136313857,1473584903,1832079573,1570565207,-254176366,-1040377518,2016421967,-477146176,-432964635,-128069560,-558793460,-1913224974,-1524391556,-926537623,-1154811227,1133514856,-420458000,-1844838118,601246027,1521519853,1473162391,1668030517,-252870473,-1535209982,-78611758,-418186404,619720513,1289178279,-872736039,1692712078,611238608,-50416523,512144018,427328693,-2145268847,-1955007226,-176903471,1277101933,1300000302,-393094485,-1672027932,358789077,1105294920,1265500164,948275945,-1951480438,-300267576,-1499523572,697142935,-437479447,-1851996695,-1365126951,-266922174,913983454,1272876350,-431450882,1857034663,1323079363,890998023,-630640289,-509717790,1570923748,1979236293,536029677,2111289924,1682040983,-2009392239,-315483486,2127586820,-738416019,-73403570,-1824219566,653737629,2017752160,908376551,-665704224,-712541599,-1899496357,-1495025044,643342104,2085638558,741308302,-10937928,-91584116,-851700696,-1364181598,-787815503,1934019050,-158785625,-383600578,-313934118,1268520670,-1344503362,732044229,-74073472,-150841156,-1427549881,-170489546,-1499016146,-359065854,-1395325553,-1516408480,1027996839,-1643735163,1313027493,850156878,-1965381100,1214436930,-165642040,277329814,-1289032497,-2110513484,-266518023,1617021644,581588824,226535966,-528748558,-720717540,1204250056,2122964105,-935401624,501521825,-1183976718,-687812386,-4125623,203841846,-2139445331,-490832552,-1147891344,328944054,-2042623397,1502171190,1166883450,1310542615,1670698788,-153606721,-1155027297,1279532901,599837424,248741879,1253798155,1334487917,-1423964730);
/*FRC*/Random.twister.import_mti(55); void (makeScript(14));
/*FRC*/count=123; tryItOut("\"use strict\"; Array.prototype.sort.apply(a0, [(function() { try { this.o0.v2 = Object.prototype.isPrototypeOf.call(f2, g0.o2); } catch(e0) { } g0.g0.__proto__ = t2; return e0; }), i1, this.o1]);");
/*FRC*/Random.twister.import_mti(108); void (makeScript(14));
/*FRC*/count=124; tryItOut("s0 += g2.s2;");
/*FRC*/Random.twister.import_mti(123); void (makeScript(14));
/*FRC*/count=125; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"\\\\3:|(?!\\\\B|(?:\\ud641{3,4}|\\\\S))?+\", \"g\"); var s = \"\"; print(uneval(r.exec(s))); ");
/*FRC*/Random.twister.import_mti(543); void (makeScript(14));
/*FRC*/count=126; tryItOut("\"use strict\"; o0.t2[15];");
/*FRC*/Random.twister.import_mti(557); void (makeScript(14));
/*FRC*/count=127; tryItOut("ofmjoe((void version(170)), /*RXUE*//$./gm.exec(\"\\u0081\\n\"));/*hhh*/function ofmjoe(\u3056 = window >> x, window, c, b, \u3056, {}, w, x, x, w, e, window = \"\\uEC05\", w =  \"\" , z, e, NaN, x, z, d, x, x, window, NaN, x, x, \u3056 = 24, x, x = ({a2:z2}), eval, w = [,,], w, c, x, c = this, x, x, c, d){a2.sort((function mcc_() { var gejhro = 0; return function() { ++gejhro; if (/*ICCD*/gejhro % 3 == 2) { dumpln('hit!'); try { e1 = new Set(b0); } catch(e0) { } a0.valueOf = (function() { for (var j=0;j<11;++j) { f1(j%2==0); } }); } else { dumpln('miss!'); try { i0.send(this.m2); } catch(e0) { } try { t2[4]; } catch(e1) { } try { print(x); } catch(e2) { } for (var p in b1) { try { Array.prototype.shift.apply(a2, [m0]); } catch(e0) { } v2 = Object.prototype.isPrototypeOf.call(o1, m1); } } };})());}");
/*FRC*/Random.twister.import_mta(1613283347,1930934420,-1125555708,967782625,-1543411541,-304295867,-1422148246,260476988,1547428770,-1066412979,1642114406,138972399,-226171618,558676249,-1069765979,-989520554,935945575,-2010903829,-756277440,-1424863305,1259711533,402323009,-162142150,136264131,1883128943,171298146,-590644983,-1125822702,588865227,-2056015744,-1227761987,975912416,-1417980311,-1527671858,1490625030,508250002,1737760301,1074506295,-960211138,-1621266295,1283018396,1129068648,-111959721,1402567309,470055395,-729367031,-429086619,-2041541373,-2001740038,-1314850676,20211096,-732522285,1458882379,-1593652513,409388725,769797465,1715415679,58325580,-1130074978,-68674403,-58989306,-1863420556,2101458096,1790883150,476986431,-788957874,-120021631,-279943363,1451996500,1589438365,551949415,2056805871,-1583718239,1370351243,-1397065322,1777134809,-655696978,-721206003,1252762404,-1305054057,-1094521204,1808541376,-1030956090,190827603,1981982537,1131107653,365263765,117198331,751320397,1279575489,-1978497504,-842927376,767361906,2025644413,702749441,979368066,-111465685,-1732740403,513697823,1040200111,-1162651532,-1435759907,1888077413,1478658412,-976826531,497258186,-350151607,271018172,-1317053511,-1137735810,-1243639776,-1528350726,2138837530,-77757595,-639832742,1228246357,-1646875523,-1134230895,855036511,1651873038,-1770046705,-1414592626,401361895,-1330704803,-1714721068,28979698,-291832221,1583100363,-937993926,-1007789830,1401154133,365090736,-390783630,88377417,-1739534921,230912924,982595941,-2108292970,-715896491,-1944273309,1289548697,-852927656,-780003837,1762776511,-1149590851,-216778973,-737299399,995348267,-881509421,-1815834101,-2143479849,-1607912691,656067281,956087155,2138012625,513496535,-1971290076,-868251543,967951194,1282314652,-1243166977,-1881474495,1510956506,247355583,1536269979,-1462150635,1668833450,-173556884,2092360761,1111037148,-103427313,-1702747513,-634755507,-1236555790,671673766,1765184390,-1111396722,1492956934,-1056352308,-1507940954,-1151756325,-1264652978,-1888853287,1464773724,-264128582,796592733,749307423,1682794031,-273631881,1921791434,-1455352127,1504315500,655284196,-413786893,1994658207,-694069270,2075725829,-1104289105,-1220271024,-625802357,606938857,-480676393,1828236238,1624819319,-1458662232,408034108,933144041,337389040,-592627634,16103479,1680443216,1945298842,1878452065,-1070739814,1426939148,-296801723,735165024,-1696486039,-1869841387,1559227090,2031564624,-990280621,1893021658,-1430427067,263545103,-1262279173,-1356669777,-933362106,1513791549,363331026,1021943010,-310039341,952948979,1341721753,136276213,978281329,648317867,-530975519,1932015771,-741450858,-1945155661,-181740170,1252390567,-1362185213,-117420336,-423164988,973361471,795194335,163130868,35374266,-1551961498,508184877,-26708522,-482945078,530080732,-1043482652,-1880492380,-588695548,-298333622,1564366367,-1177224755,292465886,949268334,1371338400,-2019109216,-1093013182,-1830634117,37610716,1428823013,1815975013,427539699,850980778,-1705800609,359370716,-1882466347,-653231569,960125298,-609659646,1455584139,1943338089,2028686985,-409840516,-777483636,-1898899259,-1205933485,47729212,-1670244454,2039338370,10864685,-767547738,-71514209,442352900,-674892859,1167250312,-1100839943,200489750,1654768142,1654389603,1221793275,-1041450843,-1669886314,-658697594,-387163975,-1524207248,-1068166025,-461476237,-395158983,-2000249432,-1971097286,1976273618,-426680745,-780397393,-1660964304,1155689497,202268366,-99236082,853404402,-1142465116,232802729,-665618424,-1729876565,923459584,259331939,1852660381,-1180925271,1607754424,1792840565,1572319262,-1384640747,-816346052,-1928174054,1624610536,-2141211160,1696558460,432857152,1306567150,-2066728863,1355804737,-397460035,1674565898,-594223878,918557423,-836403854,-800563170,765488434,2043949793,-1821881566,-781034102,78627542,-631100088,-1679097955,-17803378,1126562906,-1605811407,1772729765,-1484477113,22375154,-2111954102,-1519153507,-62347558,-8268399,-1728200392,-1858122039,-1062461734,-1497577872,-972166268,2120221639,-516716671,1960238136,59825587,-849588458,-450033425,879806088,227901956,600367252,-237452360,740563975,334840955,67540595,-5628559,1963840559,-1718798051,-824869709,619958156,-1412424315,-1296539347,129535127,-933383662,-665438834,-1487089968,1185625317,138444155,2122898871,-520260407,-1419789289,477135417,845377805,310594937,1498614296,519587268,-327845730,-1507925862,-650414807,1267447780,-452758075,-310481081,196720406,1237974899,-1489356746,1554220435,-1755065679,1493918437,1167436542,-1490281972,-86374568,-1423521666,1717762058,-200700157,1167246842,1047657753,-1853756927,1949114698,-1940764160,1855162716,-2124390844,1400323534,-411474261,1501675814,-585961328,-1240414482,52815502,-73316471,-1882624534,1441609924,-1514762432,-1445456447,1130635369,-1360119489,1677417475,1279611215,-1615646175,-1212686155,1103976879,-1433088210,-458252789,-404887000,781830867,1645036314,114223289,1612473076,891158757,-1586547066,1981475488,275920360,353716962,-647757046,66775834,-1189164177,712185981,-2011189984,-1823218932,215975894,-471385040,-1397457147,-582469466,-1594057102,-664599463,-362463612,-1463473123,1721586663,789814587,-2136211983,2068744907,-2000669443,-1006353576,2114691854,-970846006,1486223059,112798073,1774612795,1104045802,-310748032,1851567953,942616656,-460983859,-1899411741,-1204882713,-2012000211,-75587085,1153058634,1055148070,-1050831143,-330817028,1871255952,-962582191,887231441,1598405789,1350483070,-94667824,771980022,-1484494520,662009616,2020477611,1795497587,-1509857173,625675813,-1197188330,-947365883,1533503951,-1545939765,-1662617171,526975158,1302008693,164029727,-527073131,1159312046,837993233,79426806,1021571603,2055581263,196715514,1843094732,721649714,1192673804,-405696824,1292138302,-1226728639,-818412144,359884050,1125294994,1960878939,235752644,-1669995054,-1286637098,-1389765833,-1180222651,-1684326690,1492624873,1392075507,683907648,875382120,1658809532,1507928115,-1540567333,-2062778234,-1496838851,1162233119,-293789446,1214436098,-1081871734,329425722,-264319616,-1784197847,1459530053,-542286798,-2125391003,1016889811,1400449256,866405342,-747373980,1530348979,266034055,1917594930,-107643737,911342165,-1089002644,-1841162227,-1523075057,-1802752541,-1162600083,-1494433933,1215194717,1849324094,1605498399,-323452726,2133782152,371078452,-519980282,-1381810791,912881627,1865117993,996609301,1613685707,-1755409937,2083981639,-1138384838,-114953264,-1682915664,-1544715940,-646146814,1077008482,-408499926,655096743,240182945,-261706707,1914079543,866986570,-1478945896,-2033272309,-1841522669,696971696,-198041957,-311543103,1201960040,-182619520,1108715240,1721761400,72542851,-1001950811,-2028414872,-1092912514,-954944098,-1870726128,-1178691133,-107488896,2050135950,1674029376,-1182692472,429922307,-521547117,1554545811,361912702,165707994,-612392485);
/*FRC*/Random.twister.import_mti(538); void (makeScript(14));
/*FRC*/count=128; tryItOut("mathy4 = (function(x, y) { return (Math.max(Math.sqrt(x), ( ~ (( + ((y ** x) | 0)) | 0))) ? ((Math.tanh((mathy2(-0x080000001, ( + ((y | 0) === ((Math.log2((( ! Number.MAX_VALUE) >>> 0)) >>> 0) | 0)))) | 0)) | 0) > ( + ( - ( + -Number.MIN_VALUE)))) : Math.sinh(Math.fround((mathy0(((( ! x) >>> 0) >>> 0), ( + ( ~ x))) >>> 0)))); }); testMathyFunction(mathy4, /*MARR*/[new Boolean(false), objectEmulatingUndefined(), new Boolean(false), undefined, undefined, undefined, new Boolean(false), undefined, (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), (0x50505050 >> 1), new Boolean(false), objectEmulatingUndefined(), new Boolean(false), (0x50505050 >> 1), objectEmulatingUndefined(), (0x50505050 >> 1), undefined, objectEmulatingUndefined(), undefined, new Boolean(false), (0x50505050 >> 1), new Boolean(false), (0x50505050 >> 1), (0x50505050 >> 1), new Boolean(false), objectEmulatingUndefined(), objectEmulatingUndefined(), new Boolean(false), undefined, (0x50505050 >> 1), (0x50505050 >> 1), objectEmulatingUndefined(), (0x50505050 >> 1), undefined, objectEmulatingUndefined(), objectEmulatingUndefined(), new Boolean(false), objectEmulatingUndefined(), undefined, objectEmulatingUndefined(), undefined, (0x50505050 >> 1), objectEmulatingUndefined(), new Boolean(false), undefined, new Boolean(false), (0x50505050 >> 1), new Boolean(false), objectEmulatingUndefined(), new Boolean(false), objectEmulatingUndefined(), undefined, (0x50505050 >> 1), (0x50505050 >> 1), objectEmulatingUndefined(), (0x50505050 >> 1), objectEmulatingUndefined(), objectEmulatingUndefined(), undefined, objectEmulatingUndefined(), new Boolean(false), (0x50505050 >> 1), objectEmulatingUndefined(), undefined, undefined, objectEmulatingUndefined(), (0x50505050 >> 1), new Boolean(false), (0x50505050 >> 1), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined()]); ");
/*FRC*/Random.twister.import_mta(721981747,1193786138,-618173077,1736277012,1241004135,-1935234148,206110714,-887192556,1413559742,2068439461,-723187237,-1636283719,-1794283072,779433788,998894670,-2022070126,976662438,-1817442056,1739022202,-1696555325,1727808764,2126000615,-478752473,815167721,1899481083,994002523,820063957,1239695870,1372513678,622411050,76832726,1369959291,-462942455,1867085709,-192617408,621531683,-320840448,-2032884513,2138971482,626558759,-1891097333,-967164809,-1132372778,146390543,83627886,-1410089662,1890859376,-1594330762,-1089628562,1845753887,-785465428,-188990525,-376064188,-534391968,781619445,-603074752,298764494,189234349,1033420187,2110200217,-244715051,1423163941,-1119815801,74206668,614677873,109298223,1108671556,-1240604148,380263779,1360576181,1310826668,553692306,-1757212547,961454576,1834302274,1463543580,2068391588,-1588489526,-31970918,-1723635828,762570163,671040666,-1251924019,-472414831,1439123197,-38362556,-1571182990,1810456500,836998364,-1121472009,-286021291,-1382014902,-504592597,-1289915015,-596481384,1240270006,-1159883735,283618689,-1293239335,1109135527,-1673524785,454502461,34750016,477085241,1772400757,-722062256,588687917,666269032,2069679514,-498363642,-1778662408,618225858,125609382,-267907328,-486836541,-629607020,-822291320,551967077,1948481577,-1547309495,1366062897,-300062913,-69559874,1197216912,755399733,-2058989604,-1322227146,-1009114539,754146115,1177083572,-975606200,556395435,-1732749463,-507480737,1223488778,406178239,-1302038115,1586188098,1721881771,1694367693,2120419397,-1557079763,-985415616,-1332173591,-2107783182,-1427160336,1619892625,968797616,1982002407,-1672446421,660670883,-2098788683,989143020,-1256346099,1719392180,-1863905989,-1444291154,-2089435745,-1486466133,-1083747725,-1919097577,1587799347,1294231268,-269010399,-2101393838,66067815,-1018781423,-788383594,-1643403006,933249365,1904089491,1620160026,-510528876,-219625056,2096443294,1893385593,869248412,-868472020,740408411,-759542266,-1152463455,1931394090,1573790197,1460382452,-170772252,-277704677,1014010407,-756554973,-983319841,1955448943,-144328058,-1335170386,1944005540,-1572118414,-856268065,-1008745606,-2008111319,-1413169659,-2042120147,-122484255,259856812,-256708628,995642359,1024310244,-1206185211,1873402090,1303013008,-615780697,-1687696852,1418411472,1034656078,1790227146,-1492238555,-732048136,1765511267,-980016864,768016296,685332309,340091623,1598829288,49674622,1640661998,1824511854,-2105901877,-1761903780,-948347310,-1085234440,-551718414,1307854323,-984374502,-927507806,-1936268095,844274959,-1857029281,1328645491,-568606540,-764564726,880387401,-1214290062,1241676486,1423989127,-942430270,152453708,1186367694,-523269862,-1548892358,341506035,1646318086,2142622650,-221665260,-423891808,1308884240,1252273598,2133663547,1761778188,372907740,1265475880,1938799347,-1506774869,1636483888,670966242,-389106697,232106355,-281856432,-642229122,-1358433480,1682339145,1020631078,1766606490,691286640,300272090,-1864533602,-515474772,-296132027,1433992382,-477054249,1138184862,591869622,1415509288,1290313951,-739444386,1178785203,40760317,-725021384,1244354995,866235990,16905048,1748215068,2113130870,1503011991,1229107022,-1773570996,1682615275,-1003680409,-202080377,670743652,-111283237,-213869938,-1728167905,-646392010,1427122355,-2144622655,94953380,-2106909632,1248204076,321500249,-585094824,1748131118,1562018291,522270777,308363033,465084389,114238615,-1537308395,1457765427,1754096037,-1596711131,822820190,-2121687986,882254113,-392690311,1119900150,-405595865,1058760098,2131598557,512508604,1825032360,334806682,2092756515,1151012173,1812297037,1770744449,-1501986066,804313613,21374367,-532913803,321182713,953478649,1430162503,691456987,845199016,-974534534,-1302542949,-1741889007,-2063273782,2107071928,-881016692,322672218,-1020497509,791107247,941899607,1284801048,208297627,1558970427,1225835561,1817833018,1193791249,241703385,1594734790,2121272702,-1380018749,-1719934287,2019804882,-516285787,1032698496,-2137430633,-848524078,67659353,1005586219,-470947893,1527156801,-664427338,-1406827534,1902766555,22203500,-1187493317,211971273,-1133841851,607828178,-646232796,550732380,-1743136462,-1029772547,621372339,1126251990,2108859711,-1689678982,-508035120,218989147,-1216787383,1927263299,619944022,-1434052644,266457029,103991637,506634587,-1477880010,1574411423,1877839096,-676639013,-1578649107,-1990187563,354360971,-1740200031,596356176,1778214864,1867907424,-1462513222,-2075668932,-814253966,-1568232615,-686232165,-52126435,1092456843,-2022406372,-1236089126,-679362767,-1783834501,911910141,-501780869,-664932137,-891336737,-1265236012,-1996584949,-1031855902,754170791,-1804342926,569663972,-1413837669,2060105904,-1714050817,-23056,90129544,1601249584,380589208,1675455175,-621506160,-715225200,-711021902,836703978,378442877,-1865053077,-790870345,-963018638,1530372673,-637454511,1850381157,-1734722051,1371845268,-281516093,-1831999608,-302641652,-817871706,-1244002423,-206606217,201928830,1087665778,75916867,-2003226031,2080074889,-685754188,2126650219,290017257,-1127631015,1678240368,1118197121,1060169092,-1718976682,764788462,-2020131826,-538196247,73432224,1053126043,1985533535,488964993,1554308063,126608290,2096089283,-471304878,1782783691,1234186619,-2027651717,170755828,-534255343,-1377588899,1664071943,-1131684871,-1018576444,-1970040750,312970592,1452625379,-1348711296,-658276368,-568405698,-5496559,-538564597,17525839,751334450,-941832987,-226210296,-1109141043,-263763660,1327138097,-908110220,-387317381,1208801443,-1239139326,660077926,-827912439,-719945740,-1686270621,-168927018,-1370852346,-1471970355,180321355,-66977759,1540087532,-834935144,839062452,1637251606,-222249215,-428490850,74571106,-894094145,-1782406895,445005152,-1092299266,531208762,-1583155704,-1496301866,-2056406494,1146939333,1250822322,314340380,-1377210285,282532508,-363701742,-1575665985,265900741,484017699,-1791934645,-484730635,-476858857,-497918106,-77100257,2049052190,61387100,-1935053576,1560389811,-1375582022,117703522,-1395225962,-319052095,1125213873,-900430857,-1141236203,1831311673,1977045154,1077057459,1391104232,-1323972847,945828614,1174302713,-788228596,660569167,-2062077794,-492460285,-517074810,29059091,2015505149,1695769056,-1306932779,-884533656,-48201495,1823269150,-937202943,531073836,-134409916,-1901557462,-1560848688,-665373074,-535886573,-16902638,-1607140499,276482500,597639470,866669094,-62368403,-171595728,410725091,-756449744,-150931572,515483160,1817668123,-469003747,572953102,-268341753,-2123792997,141776992,-119473366,-763865527,-286432813,-622170097,908907913,-580902607,393562094,1113227450,-1678210479,-610945786,-1644996670,1183005052,186532830,-1201317631,-410884166,-1666272233,1022252795,-1413903987,-1492711267,-1919958592,1574607178,86565754,46303544,-1434074775,1801826160);
/*FRC*/Random.twister.import_mti(318); void (makeScript(14));
/*FRC*/count=129; tryItOut("\"use strict\"; a1[x] = o1;");
/*FRC*/Random.twister.import_mti(336); void (makeScript(14));
/*FRC*/count=130; tryItOut("mathy1 = (function(stdlib, foreign, heap){ \"use asm\";   var Infinity = stdlib.Infinity;\n  var abs = stdlib.Math.abs;\n  var ff = foreign.ff;\n  var Int16ArrayView = new stdlib.Int16Array(heap);\n  var Int32ArrayView = new stdlib.Int32Array(heap);\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  var Uint32ArrayView = new stdlib.Uint32Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    var d3 = -1.25;\n    d0 = (((y)) * ((d0)));\n    (Int16ArrayView[((i2)*-0xfffff) >> 1]) = ((((0xd2288*(i2)) >> (((d0) == (c))+(0x4f4eb3fc))))+(0x768edee7));\n    switch ((((0x356fca67) % (0x65736dbd)) >> (0x8d957*(!(-0x8000000))))) {\n      default:\n        (Int32ArrayView[1]) = ((((d1) < (d1)) ? (0xfeeb16ba) : (/*FFI*/ff()|0))+(0xa08596c7)-(0xc9d16671));\n    }\n    (Float32ArrayView[0]) = ((+((274877906945.0))));\n    (Uint32ArrayView[0]) = ((0x348d8582));\n    d0 = (Infinity);\n    return ((-(/*FFI*/ff(((abs(((0xc2fe3*((67108863.0) == (d0))) >> (((abs((-0x8000000))|0) <= (((0xfefc22a6))|0))+(0xffffffff)-(i2))))|0)), (((\n16))), (((((((!(0xdbb443bb))) ^ ((0xfe1b1dae)-(0xf487cef5)+(0x1dbd0330))))-(0x602cf21c))|0)))|0)))|0;\n  }\n  return f; })(this, {ff: Array.prototype.findIndex}, new ArrayBuffer(4096)); ");
/*FRC*/Random.twister.import_mta(2118402322,-612988270,-1542065967,471012609,-1892454373,1396400502,-1110841941,1235957391,-850319395,-601082542,2129085497,-826180900,-1739725844,-1086169730,-727434798,-1577071922,1221301751,-190371679,573192548,-1526751921,871919703,-1628865359,592765648,2043585525,1313362989,904798305,-1408456460,-359116251,1048519986,-1774598503,-1875958650,8797120,-1805208663,-1550329121,879950910,858745352,-2062302336,1762679349,-394684021,1146631114,796600692,-1948384039,-326403790,351310794,-2060692790,-1467590129,-689588023,78735734,872971137,1188940979,2077003971,621701430,-1624600973,1552817965,-1007621716,-2019090239,695273728,1953209957,-1411249043,-513262009,-135841906,254933325,969755247,1551439571,-460633437,809710027,-1479588257,-1235586018,-215827964,404764114,-1995822817,-1086552561,-617583370,-381592760,805146414,56753865,1727012666,1646860108,268789785,-935681628,1863346830,1615877739,-2103415588,-1166335270,-1174459303,1526814157,-1781315893,-1257086157,-457912029,1392164748,-1785081375,1668113176,-769554685,950827183,-882192677,1554318651,258324257,2144455714,669028487,-1776035721,-129281805,-959063099,1706762699,272183592,-633580772,-2019991304,-637244224,-716937290,2032734496,-52830722,1966820615,-853975590,-317556620,1929938653,-1731061220,-919331262,1631068064,-1448710016,1961379802,-1435150933,1614669272,1341022059,37253214,2102079940,-455698320,1558833273,844141898,1521728623,965890618,-1677172006,-701112528,888565091,1329116326,-518274905,-783371323,-894139229,2113524669,129051353,-1147054683,1282109167,713417462,1836626661,-576887672,-736109390,-1234421363,182307328,-24311362,1501446579,-318602796,-921664174,349331325,8070981,763637603,1949952184,1034796244,-1206958058,-1683814239,15670013,2101413875,-1293853843,-2087841052,1721803969,-65422041,-263560136,-527397526,-44724306,-1182430649,1750771918,1204789483,1125260053,-781793397,829657433,22433325,459929135,326900662,-761216858,-616655489,-1548447764,-511816702,-620208861,-1905111215,960964879,-1988983894,-490853860,247397825,969863134,273660451,-339499916,-1060039226,135958373,-1535303622,-1943388702,157194970,765132672,-1762716111,-1013562029,-1598192186,1042349780,-948459999,-1212161327,-1188033939,-858272444,-429513000,1467838228,-1724281434,-62962873,-2105437691,-1865169881,2100353286,1552895005,-1365060812,1360665163,-136462914,-1424604782,701846350,-293198123,1793490127,260355515,323506063,-1430031054,-1746777750,-1143985545,-974186512,1314217684,1635657233,-181563371,82515849,-2118724812,-102802657,-1068606080,-1018112066,1326616131,-1030476794,1129945037,1722210005,-1536691624,521688873,1697183616,-1413462081,724926448,-1666478433,-1875961612,-2103144791,2024558970,-1519269060,-250613182,-1779436468,203594122,-1483888453,1342772352,516906365,1796883186,-1821368541,-1735531022,-511353525,466220454,922135359,440380428,1883462232,-2019974312,251147259,-342845352,79098144,-372249153,1049863081,55710704,1513291737,467470905,-1622925855,-461791777,480128773,-175149156,1185045490,-1134967146,-1401846590,1440993998,1467897832,1373891159,-1703769722,-1227033892,-1498954453,1540268173,-1379686819,-714337018,1840989518,-1419577919,-713954103,-920723659,-1158521895,493624776,1465756917,262582153,-1956837465,1195231555,-442029524,1451553590,1635809429,1551743439,-746525292,682674288,1885091959,1831461116,39088361,63116716,-222986817,1049984181,-1138520269,-661284184,-154633560,311968655,783277559,596643533,-802774632,1739204621,408707902,1842769518,176103715,-1789059130,-1607548073,2137339232,1506562132,1636561559,53000170,-1444165232,1889004924,293827795,-1613134022,1595774781,2106650044,-894358606,-1108069193,-922709397,1231666465,1135595216,2085808083,-1447834621,2042305501,-961758213,1082820840,-199089376,1375494880,1492437006,472571797,599418821,-680665508,1364600732,-471294330,-660378166,-2123021085,-2027757782,1526821064,2079000546,-342402885,-1882175615,1822378866,-2096560787,37019369,-105708717,198077404,-1058058600,883851552,-1384165204,1663121710,591335165,-1628100403,-585690164,-1754796772,-1368043076,-981012001,689347703,-131264791,-528549772,-345928142,-31166584,-588589967,844826479,1311591599,1187971860,751207895,2112745037,2016740385,-974489227,1937983760,-1171024310,-1489045315,1894105678,-1036344187,1543529238,-468405702,478074841,-499931117,-170686844,598595731,596926002,-28620612,1413155696,-1259248251,-426769929,-2085714197,-928177660,-959359974,-1057283028,1200300969,-1963244713,-1756742652,-690664270,-815680002,-867063729,1593611574,1094280921,272296974,-373030000,-1068984380,334887341,-1326790887,840530561,-607890553,1717093019,606681600,-59190674,-771887952,-861661733,518107529,-1048439369,-246311976,-850505064,-414854621,904264959,-1313697508,1938047608,679656940,-610914334,-746073121,-1982449591,943047067,1347064270,908070869,-999455123,167088446,1704085343,980694904,-659308342,-1916082452,-1636491984,-1148412212,-43665694,1065802515,-16773088,356821321,-1937120204,950950354,115213378,919085838,-466346131,-944616693,-642424794,1527111294,1578434121,-1410889512,-385601444,-1523570009,-150289922,587962667,1830527505,-579637857,-1269287555,670056539,-899591704,-1813739789,1952046338,983330602,589024558,1395337650,41272659,-1149745990,-1538762390,-143245250,792422356,-2026668728,783333185,35089296,-1533829583,-1294814735,-116404402,-224346032,-150075525,-432192582,1269955538,-1564254488,-1225464050,-33436673,1391598673,1818065775,-1125359730,-316231965,1187584793,-232937530,-1502020184,-1932703592,-2124740661,-998612468,1391752837,1896643060,-1174149238,-1393740071,-2124376185,-445182865,419230320,826646391,2037764147,-1348786835,983465805,1716225272,153543219,1847029754,-686312273,980545156,240919855,1064145538,724953336,872879756,-1482701667,-355018314,-1301702462,289318783,-856520853,1734608237,1619870579,1044512663,1088597496,-119155055,-671974938,936068795,870287301,-1862395930,-1008642143,-627414001,-263470006,-1259045629,1136037602,-1892723544,-258144022,486490589,-289123213,-397666103,-1577411591,2033287964,-1371261742,1988810442,1084929627,-1082094373,-1612542269,-385648812,603682334,-1679283992,-1844735489,-262503453,82169777,-529147361,-924062090,530569043,-945463056,-2127460603,-1290005211,-1004067916,-1462703178,-2068501661,-2010552778,-34771537,782462821,-1547815952,-1295100568,-1227958473,-1782649335,1706715285,-827948683,-1126410360,475346013,714124426,-2017672308,1725920727,333463675,1243334660,1242151435,-394484796,303710927,1740887281,1313625400,2018145538,1247118902,1488942395,-777389119,1916016158,1013617869,-10086213,1687090691,-257256859,-1139498279,-603027999,458560969,274362302,681008297,-263856780,-107615000,225812707,233555338,-384230470,369090210,-1961635180,281204142,-1078151259,570746082,52752787,358960721,-1686112076,1757464099,-688528568,-1527494413,-1690383839,557426990,586488494,1912674519,562683080,-1949088500);
/*FRC*/Random.twister.import_mti(224); void (makeScript(14));
/*FRC*/count=131; tryItOut("/*infloop*/while(x){do { void 0; void relazifyFunctions(this); } while(('fafafa'.replace(/a/g, new Function)) && 0);e1.delete(b0); }");
/*FRC*/Random.twister.import_mti(352); void (makeScript(14));
/*FRC*/count=132; tryItOut("mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    return +((256.0));\n  }\n  return f; })(this, {ff: XPCNativeWrapper}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [1, 0x080000000, 0x100000000, 0x080000001, Math.PI, 0x0ffffffff, 0, 0/0, 1/0, 0x100000001, 0x07fffffff, Number.MIN_VALUE, 42, Number.MAX_VALUE, 0x100000001, -0x080000000, -Number.MAX_VALUE, -0x07fffffff, -Number.MIN_VALUE, -0x100000000, -0x080000001, -0x0ffffffff, -0, -1/0]); ");
/*FRC*/Random.twister.import_mti(422); void (makeScript(14));
/*FRC*/count=133; tryItOut("\"use strict\"; v1 = (f1 instanceof e1);");
/*FRC*/Random.twister.import_mti(437); void (makeScript(14));
/*FRC*/count=134; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(446); void (makeScript(14));
/*FRC*/count=135; tryItOut("mathy5 = (function(x, y) { \"use strict\"; return (Math.fround(Math.atan(( + (((Math.fround(Math.atanh(Math.hypot((( + Math.tan(y)) & (x >>> 0)), 0/0))) >>> 0) === ( + Math.log2(x))) | 0)))) , (Math.fround((x >> Math.fround(Math.fround(((Math.log1p(Math.atan2(x, y)) != x) | 0))))) + Math.fround(Math.min((Math.log1p(mathy1(( + (( + x) ** ( + x))), Math.asinh(y))) | 0), ( + ( ~ (Math.fround((-Number.MIN_VALUE >>> Math.fround(y))) | 0))))))); }); ");
/*FRC*/Random.twister.import_mta(-886356802,1219284572,531372123,1480613064,-1452895081,-1066966621,1999005903,686432053,-1195157989,689612605,-349104863,316302528,513296486,2053697767,-1187256585,1025895904,-1330717406,-503325781,-1183972103,456186739,-266023908,1971538792,1503081291,1875998329,1331410228,149415411,767986810,-1368522431,1599734027,-1353564064,1973870879,579434519,-1152966712,1924908019,-1040082202,-787598817,1683400076,-1795048063,845580331,563977071,1485452510,2142252455,803868346,954342941,368598290,2142276183,-600987253,947917779,1191436388,-1687673939,-309910341,-2082906449,2076597117,425078020,-603642627,1651550094,1191796864,1263271394,805949402,553010617,-2138787280,772382000,1580207082,243089193,908323268,-1444640037,909547550,-1528680291,-129486956,-1166154741,217555504,-25382776,16347302,1835182269,-1146912107,1616061999,862015221,712130665,-2141910600,-2130807431,-2044986306,-2040313050,1938630188,-941601437,1343980552,557032011,982404616,435296286,-1636607811,1979259797,973556318,316353974,1940548486,1119624269,-1515704813,-219738080,-2096842337,1742624383,-724547587,389070688,1545248917,1729652898,-1991794849,-379303038,288933625,470699924,-794700719,-797327799,-1089701512,115481139,1047551133,1204593485,-1711725694,-1544411037,1577349228,383224616,502651507,342051863,1529196197,1248795752,-1331447227,1047636653,361787418,107764404,1357086846,-201420013,104396330,234327650,-1024018938,209644277,-1543584483,433956292,-379060876,155860908,731941736,-801169478,-1458593162,338038251,1021071369,-807887500,1610558951,-1707421881,700014779,1293023409,-1242305046,599377154,460571765,-556967901,-982329008,-1437590403,930158511,-113217116,2058764807,-1588178255,-2082133304,1037714395,-91993153,1010834382,309562518,-1315075439,-289592050,1198634067,-1328620438,1876398566,-1190156505,1157362425,-953073342,2127053598,273766115,890173561,1234705989,1682897510,-1172364115,-1442824661,-1684130501,1113140567,-1000035841,352669332,975839035,1659748607,-637661179,774499679,-152840574,-1198998552,252131220,-617306678,2145937457,-2011944665,-820005470,1979532524,140069833,1021655151,1553529334,-893366532,694839735,577426685,1669000103,1171618676,-1504069708,893003660,-629193605,-1354918259,1894490691,482781549,-813675051,671982761,687128100,1944964192,-1163603109,-28806624,-461741224,-1325593525,1162474855,-346677758,-1940961449,-278954197,-1951423405,198406060,2107735226,-1660631043,1611984151,-104250919,1175651908,-1958561415,-778084350,-84613165,-1962398570,785144302,680255644,2114220932,-1497257162,-2010348908,952310426,-578964614,987358745,1850199376,462347517,1742308897,1195432760,-1983561738,847215773,1633751420,1098106205,-1575601988,-1720180086,-208011553,1562482614,2062198942,495436072,-805819094,1516001024,-538244486,1151407882,-1005809152,-477430894,-584457141,-1571973530,1300712499,558213563,1697887978,1198755807,-2141527434,2095150111,-1575500665,-1800883079,-2039003368,-1250185556,-836728079,-1803267177,-122836505,36022739,1990815979,1637640476,-1978307606,1383201460,1824312208,714171993,-524394376,-659085375,-1315108553,-306590307,1407993612,147238157,836026919,-940427299,-1011250847,-579757316,1156919043,1623167956,-325685937,-1868113870,-1434068280,1400037029,82119944,-811579130,1367384833,223053875,624415994,-1440426832,-1579164606,1542871235,595659326,1639099641,-1825357579,-332378388,122453758,-323700691,-41959062,1445452350,-36538360,1327561434,2013844676,-873593198,916488087,790179625,38041843,2136446070,-216491222,1835644678,1598833580,-344893991,-1539541530,-434965272,-78688479,-166241079,-616790944,-508115935,1657984587,1111555451,1320498651,351056488,-326850378,1037674748,2004883303,1571350679,1524188233,-1128466671,1580538089,2111681245,-251194638,-1886892956,-921063559,-1644034027,910374237,2093506521,1792139750,641641101,1762765035,2111882552,2014365822,999938373,-64971524,756940812,1886868371,-1787053045,451176877,-1448092797,-434507533,967443080,-1288651292,536188922,1513101311,1487415323,1065191119,2058191885,2003805831,-1730005590,-1540037161,1471754659,-1935190256,1026458763,-1069339917,1554772678,-334618990,518548299,2070728664,-1992843785,-1206196837,1589524061,-542871352,447471316,-98267584,549685502,806586174,1144191721,-1436127733,-543311078,-591956973,-1874432160,417315004,356405924,1909586865,1429331424,-132848356,349554342,-1826532098,-548517795,-1857557009,1600356,-646476128,-897733571,1632834608,-567526365,-1883129859,2121263309,1570424260,-1647467513,-1233102178,-1749160212,-16867195,-1939162592,1864596598,197585347,-23741598,1209017528,2079665342,-1613130370,441308873,47796568,879103918,899347662,-15597140,-1683788039,466756171,594694712,1291054714,-155162324,-1029305099,-687884367,1688927413,822984348,1061885157,-168949678,-303632842,1539867783,951870574,1165361609,-1602180153,456957755,1483992795,-955253145,-894815199,-1603931725,-697701579,1969337565,-1150639636,-1568354323,-1279391380,-7490621,440674989,-2010268840,-889491067,1374050490,1910094284,1108797949,1158221731,-939082625,-1288540326,-55665990,-212615402,-1493642363,-229336493,-1044206457,-1405101331,-1526911936,-1917826102,-1393191166,-494563525,458096637,1547563720,-1281630677,-1326598573,1806412969,1084077547,684622891,1715265847,-1738170688,1506142628,297525509,1168810690,1330507207,602608565,-1582431252,-618793394,-1358364847,1381697638,15420163,1444028587,-618622479,-1695997633,1382447728,999209233,-1744738081,1524648194,877442978,-1383432076,-1416505549,1145245087,-1358150703,60905498,2053628023,1794623054,1908226133,-437301782,956734308,855904553,-35426289,1813230329,-161603638,-2046587036,-174895778,-187173471,1579305127,-361091839,-160021109,1032283286,1924189959,-1894772365,-1088475468,1232164323,-1910349927,-1161091619,146042720,-589534381,-1706678384,1084122841,143772964,-572647465,66084034,-993462418,-120947706,786259310,-2018832957,-456412194,92789349,-1570611994,-2047370707,-1940753276,433296309,-864441146,1324284898,-126992616,-1406213611,-1837553459,988636681,301037192,1215191493,-1875624260,492936724,1624900186,766949535,-2104039581,-1967046801,-331165611,-1293963669,-1553658795,-1781570852,-1109463112,-1997447283,-350293110,1414702879,-2076664886,-1704985084,-558930229,173894962,-1500538957,-1257004567,1752582764,121677844,-1881337363,1864638441,-1096317795,-1190779331,-840225256,-682993522,596569852,-1355619697,785485568,-66246,-948368840,-527449231,-1334421495,-1494743945,-1651406239,907829579,-1824303057,-1810458760,600878459,2132464868,-302046631,-1901999120,62361346,-263037890,1046055208,1333472777,-152778674,1269151395,-903776604,350294216,1418118425,1632436249,650806769,128334252,1451621721,-1091631266,1781709696,-1789157479,522336158,-1304042345,-1508547597,1628566863,-592956673,970750460,-769505472,836741085,-1153655100,-743625702,-1045854357,558706470,1145786551,1478285736,68233410,-1765214600,-1159992830);
/*FRC*/Random.twister.import_mti(129); void (makeScript(14));
/*FRC*/count=136; tryItOut("switch(x ? window : window) { default: g2 + b1;case x: break;  }");
/*FRC*/Random.twister.import_mti(227); void (makeScript(14));
/*FRC*/count=137; tryItOut("\"use strict\"; h0 + '';");
/*FRC*/Random.twister.import_mti(236); void (makeScript(14));
/*FRC*/count=138; tryItOut("delete\u0009 w.x;");
/*FRC*/Random.twister.import_mti(281); void (makeScript(14));
/*FRC*/count=139; tryItOut("\"use strict\"; Object.freeze(p2);");
/*FRC*/Random.twister.import_mti(291); void (makeScript(14));
/*FRC*/count=140; tryItOut("\"use strict\"; this.i2 + '';");
/*FRC*/Random.twister.import_mti(300); void (makeScript(14));
/*FRC*/count=141; tryItOut("\"use strict\"; p1.__proto__ = i2;");
/*FRC*/Random.twister.import_mti(312); void (makeScript(14));
/*FRC*/count=142; tryItOut("\"use strict\"; testMathyFunction(mathy1, [-0x07fffffff, 0/0, 0x0ffffffff, 0x07fffffff, 0x080000001, 0x100000001, -0x100000000, -0x080000000, -0x080000001, Number.MAX_VALUE, Math.PI, 0x080000000, 0x100000001, -1/0, -0x0ffffffff, -0, 0x100000000, 42, Number.MIN_VALUE, -Number.MIN_VALUE, 1/0, -Number.MAX_VALUE, 1, 0]); ");
/*FRC*/Random.twister.import_mti(344); void (makeScript(14));
/*FRC*/count=143; tryItOut("if(false) {L: {print(x); } } else  if (eval = x) {v1 = new Number(p2);this.a2.push(p0, t0, g2); } else fbvduf, x = x, x, itnmku, b, hbtxke, jssbst, x, whgkls, tpezdx;print(m0);");
/*FRC*/Random.twister.import_mti(615); void (makeScript(14));
/*FRC*/count=144; tryItOut("\"use strict\"; mathy5 = (function(x, y) { \"use strict\"; return (mathy1(Math.fround(( ! (Math.max(Math.fround(x), Math.sinh(Math.fround(x))) ? -0 : (0x100000001 ^ (Math.pow((42 >>> 0), y) >>> 0))))), (Math.asinh(((( + ( + 0x0ffffffff)) && Math.fround(Math.expm1(Math.log2(0x07fffffff)))) && Math.pow(y, Math.log10(-0x07fffffff)))) | 0)) | 0); }); ");
/*FRC*/Random.twister.import_mta(-183399743,-1765353578,-178806588,1204180649,-1738009538,1018673307,45877432,-83430625,-1877006715,828218952,-1218306,-1728984353,1522690089,167770500,833718918,328304466,392357480,-1917872613,-1352273448,-1479806096,1619817341,-1223002078,-1702493107,305606228,1651065738,-1925175100,-1779592652,-707272094,1532677706,354134396,1256849441,-883148715,-2063618669,269317103,-825967307,-2017109356,2121170985,-1678544819,-1317398266,1764957094,105909707,214538342,-586526454,-839659282,1819984341,393975209,320950787,1457538287,802554085,1297083759,1801066212,459681442,384777263,1059559929,-1144839614,1919084794,1417430845,1511132688,-864379488,-935008921,-466181694,-743006385,1835372637,-1108793497,2142138337,-1696997240,658928252,-656852086,1233520912,-359774694,-574892161,1529956270,-209447351,927117246,1506579867,-351028468,-861133568,686031095,-1085576364,-613916449,452217911,1753051667,-11389780,658517955,-1434815921,-1125571352,-672859583,960095184,-1313917581,501804588,1602205296,-487218126,582983622,-642064986,1123889409,1082885327,-1341664542,-2027150205,-434970684,479475622,2010069454,849820833,1997766107,-1410124844,1693507972,-1058708830,349905425,1719707608,-377639697,2077486750,-688041088,-90010101,1324493706,-1701743256,-4444107,-909109951,2034449365,1122771462,414247586,-202792198,1226863866,-1244195143,1246197945,-1504469082,440196235,1269306485,-634934174,-1153598317,-1616272516,-2140790923,-1859074763,927179384,-2140280648,-317048398,113431219,-752034568,936379892,-2099166530,-2054286756,1929427969,407348216,-737701065,1945755713,1410796823,-1447895655,949989616,605500419,1481902753,-573454231,-1965137203,-1399585170,-114159672,-377906211,1816407547,1165194833,780905071,-1302143566,-1142527968,581138882,-493751205,1198425422,-1869205064,-1661650055,-773995437,2135806569,-1178116443,-1580513468,-1686276452,620780368,148315668,1515272031,-2092463459,1138081319,-1142704725,1183032041,37536285,-2023126702,1398269900,-1947156900,449141330,-523384464,-997255557,-1690478644,-1492363077,-1645475092,1075085488,9645613,1368636314,-373425575,154305091,-1532329581,1364633631,-929102553,1125928948,-1953868381,1491573042,481506450,1549268435,-1401300088,-7166911,79105341,-174296778,-1007869584,-544893396,-339417222,333211326,1869814633,984997420,353796752,-412701131,-564919964,1240051451,-1816236814,-1103174085,839859637,-452781302,-1748242282,252647808,750144997,984607310,1682282328,1111796740,-656229164,819161513,-530322444,-749936589,-306329867,-514557297,-1446711724,-432573089,63969251,-1006003853,302604582,-958903445,-869984841,80803876,-1682313849,-598932126,-1676454620,-1695193416,961507642,-2013210377,43686668,1541338925,1835784619,-1040893437,-1698781377,1850708969,-1863946569,-139972659,1036168041,3786767,-1354341948,-467079171,575381656,175900025,-355418182,-1019190237,-104471776,1045355171,270533332,700233701,264636424,-1389204790,-657927231,-339227056,-1758728703,-719678241,-375915446,84948284,1873795140,1555363163,309403740,2048503641,1623073063,-1550449898,2098257235,-1643563557,-627041562,-113546690,1456585343,648594459,-209700554,-292688884,-1564050817,-1564323618,859226681,-731289560,2096437559,624360516,-391394813,-1893748628,-1733597684,9852671,689035989,-701792810,-132797337,-928400089,199141775,125274871,646064801,-266505416,2072161193,-1162608010,1799503752,270108573,-1512603542,1911005480,1452559895,-1732097599,457459105,-1886555898,2125573116,1499520266,-1592561802,-1912275128,610575289,701197811,-850164252,-1911585291,-1952127147,838093685,-1541106816,1376046169,-357407053,264310027,-185209764,-806881364,-1930094957,2103780591,-1649318001,974927354,1647172046,-1559763323,-756763357,1848338360,-1916677579,1897609777,-1038022798,154537400,1729434123,699761888,200884016,-567302938,2005193461,-1834545349,1583990352,2010125926,-1981844858,-830266172,-1740385832,1286855821,-358937245,1234354872,1866987674,309788258,1784829907,-840579983,786168970,-812178619,1493861010,-1281460639,1436200768,-1819379923,543039778,-1979774839,-1206747595,-359429130,-766232385,-1268378917,-314693455,-941153030,244891577,-227823239,1709337933,1078113869,1339793631,1522773407,-689948756,-1540590409,1364617947,353546798,914516464,158535705,937291770,1299031119,365100685,256750334,-587600410,-1771433429,1883081044,1440038041,-2050151381,-341728233,-1829905181,-743452767,-646162372,442303213,-1342419507,-1075586842,-884326477,-258143193,-590042820,1633078763,2107278638,471784576,1099265821,-1424802298,586741478,-586675492,-794958208,17288914,2136890625,1687895153,1818832325,-430886682,-585311752,-1513739969,1264955336,-766345408,2090159906,1599296000,-1945749304,218766734,2049835758,-1759908066,130618084,-155163078,516014003,-613679554,1495837825,-785128621,1697583525,-1684018699,652995611,-1364905301,1848527625,180551206,-52893367,691086110,1113804020,-80382541,390028879,1953733159,314198390,-453207348,1668345592,-2104754586,-1771173491,-587964040,-861511244,-2003777623,-341820203,1438515924,1524125057,349110452,-1079098638,2106022590,-1113569544,-662849477,653964957,902624043,-876108403,-909673561,-1701502841,-899047771,1925124602,-304005605,-1507974765,-2107652922,-1700750117,-2118729952,2025017385,399594997,-1000778835,-1663786537,-1689593057,-1407718604,585931118,300427256,1825953528,849125742,1743978078,610037965,-1435639792,1622734462,-1940948439,-1531381005,-37709915,1727345968,704480925,1304483697,-2034767151,-1928481328,-1008741147,626501388,-29818068,-517912205,493115734,-1236639560,1331842174,-1050145326,-1855871517,563319009,511937936,2102989374,372900765,1845409178,1705575337,-1991663719,233743875,1423961843,251131521,-788180957,-1968514461,-593113493,-1145682910,-1222353575,1924115010,112392479,-990153522,1833692517,1632499872,-1254703185,837697172,261508893,-1332727357,1736049856,-763819889,132617642,-304436031,-241235530,1652317810,2115820935,1624674139,-1922616354,-554994813,-828031836,-1447975067,432461325,1700250246,1846324899,1580260337,-535125918,557045431,1886132697,-2045404501,-988534689,26823256,737640208,-901312713,920275419,-521611778,882019254,123584857,-971855875,596267827,1086421142,1335053375,-1861469538,-1592022176,-1614067167,-1737202686,-923835220,-78364361,27289433,2098014350,1689601537,-1219248951,-446463973,1484052087,-1307610828,-195913673,902621719,639066392,122598174,-1712594108,-1480806587,789535121,64248836,-2002690461,-1522840962,-977892467,-1469786199,1565317305,1691399990,125289767,1720183008,476665746,315247288,-766136148,410455869,-690762723,111630830,-773722159,781079345,-1854494327,-1488019243,1957492393,-1489596566,2013676382,1714516379,-234293186,1353458544,802877535,1162168511,-339906696,-780392369,-552553720,-553507960,-1104168519,1798558468,1685882863,-735732292,315882908,-1255179285,1874223425,547036871,-285727715,-1446821633,-374787978,-1719031841,-1899873632,989605251);
/*FRC*/Random.twister.import_mti(215); void (makeScript(14));
/*FRC*/count=145; tryItOut("/*hhh*/function xbewqi(x = ((p={}, (p.z = delete x.c)()))){v1 = (a1 instanceof a1);}/*iii*/v2 = g1.t1.byteLength;");
/*FRC*/Random.twister.import_mti(322); void (makeScript(14));
/*FRC*/count=146; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return (((((Math.expm1((Math.max(-0x0ffffffff, x) | x)) >>> 0) >>> (Math.pow((Math.fround((Math.fround(x) | x)) >>> 0), ((( + Math.atan2((mathy0((x | 0), (x | 0)) | 0), x)) / x) | 0)) | 0)) || (Math.imul(Math.imul(Math.max((mathy0(( + y), (x | 0)) | 0), ( + (-Number.MAX_VALUE | 0))), Math.min(( + Math.atan2(( + x), mathy0(y, Math.PI))), (x >>> 0))), Math.log10((y | 0))) >>> 0)) ^ ( + Math.fround(((mathy0(Math.fround(y), (Math.atan2(-0x100000000, ( - y)) >>> 0)) >>> 0) && Math.fround(Math.fround(( ~ Math.fround(y)))))))) | 0); }); testMathyFunction(mathy1, [Number.MIN_VALUE, 0x080000000, -0x080000000, 0x0ffffffff, 0/0, 1, 0x07fffffff, Number.MAX_VALUE, -1/0, 0x100000001, -0x080000001, -0x07fffffff, 0x080000001, -0x0ffffffff, -Number.MAX_VALUE, 42, 0, 1/0, Math.PI, -0, -Number.MIN_VALUE, 0x100000000, -0x100000000, 0x100000001]); ");
/*FRC*/Random.twister.import_mta(1363044646,-715678289,1158169453,-948030036,936272053,-578114208,-975371077,-1398954317,1152390052,2121515874,2120444854,-695111123,-638061026,-934992957,147787131,1961831989,-79411293,1004262697,-1246443170,877809817,-1102375634,-1624367823,-1689655190,1302458087,1509115490,-957287982,1742859455,394487243,-1651229792,-1145789909,1248250575,-977872475,174454550,-415087932,-1831776743,-2096045714,258924812,2119622808,-633553032,-200344269,212218389,-765607476,1338559337,-1386832703,1770000312,-2019080303,-972355441,-1671824933,1532222628,1457382794,-1892095689,68233029,1517231451,-783814507,-241060908,1486270356,2025260508,2095383377,-370818344,-843771373,-1923832378,1377451529,1602329431,-1071304270,950010735,-1738236749,-441719198,-27909105,-13714008,-2056631654,-2139513396,114596456,-637627623,793667273,-1270914394,518341289,-626268847,-604183033,1751654759,1329090011,18997986,491094840,-616529722,-522166528,1827156762,-1794624607,2025881893,733137526,776765800,-1544511215,-1782437654,-1398843322,1244158947,-779374910,-192043575,-1632369760,1469257550,-1328104697,1797111007,-975265845,1635411964,-1075488924,-1548486318,1025129660,-518341501,1107592244,315867917,-1288312008,11593073,1027910237,-1985527232,47191660,-2080299731,-348647738,-1455467380,-346104908,-260882144,-2030915790,-447668458,-551125409,885483226,-1903909183,362493644,284011092,-778610816,1281240721,1906356537,2117791530,-693243784,1627448198,1021040124,-766509869,1902807411,934507847,-670472246,966024328,2137816280,571573877,1844436225,-758603137,2108573152,1229318042,-1429872551,-393864043,843282139,-718016209,1429738989,-1764523428,-1408526240,-799041124,-1181929541,-332581015,-992093902,1911948480,-1198052301,-103171289,1768013734,1443659192,1850928399,1077744020,1217028170,-1730059940,1625974888,1203106443,438326700,-929970272,-2058231838,-1445696353,97249363,-919796738,-65129584,1337053957,1637542417,-1573013540,706322661,-135897954,1550260721,602881590,1244405303,-1450375172,1559467175,1653731959,-916799354,-967353579,-986641882,1559735364,-2136143260,-258304694,-1186904376,-1943390927,-1759245264,-1590794786,1933864258,1318595234,1946469284,-662022572,-1316744232,-941817323,-934301234,1243979720,-1652516786,358245905,-923515780,233058531,803160772,1555678549,1308019814,626110743,-268521606,-2070450230,746606573,-691042959,420864074,2116065212,1504861825,798588836,-1818095236,-1652528207,-1468494132,1570024173,28920005,-1031177609,1755464948,-644299380,1764189977,1628727557,-748773349,98311692,1061459935,-1645676477,2087864778,2127220774,1743665162,986136255,-285877599,-798730824,274022867,812302628,-1679048335,-2058334589,1431175015,1233273085,-1073158788,1425611689,-2111178505,1642277406,-629331534,791712426,2113059336,1553992961,-726287809,1313896064,770455283,918830323,-1951017048,-1459854211,1125916901,914635615,60359723,41285244,1788127721,-1791866339,-1786129397,-100517837,196413360,144832679,126551939,2020461616,-1865032878,2015307595,436491955,1622712214,597893346,1868343491,-1919748016,-1127021870,-1059991624,-496442300,2022478426,-1475383109,1528504903,-933122225,802183570,-1327724484,763636542,695603995,-410933753,1780914562,1082212395,-220410231,-2018842236,1962258537,1093076755,1747696599,-716989724,439147332,2016814294,1553889748,-1670910004,1404515990,390127445,1358333869,62866322,-1358234987,1257805078,2055463250,936090959,-1285327562,-2010376441,266998473,-416880765,330360548,-1179099868,1749628574,1823520210,-445226901,773695287,-1284773352,1922050659,-1762486122,276380583,-425726967,1858000211,-71134008,1849593181,1365723889,-1574083555,-1106748310,1482651084,878967370,1611933249,-804499356,-896546903,-492230333,-1004513052,-1621574476,-591296614,-1464352263,1179324592,780344567,-1913674,-1396454636,-1001846329,314153093,380213360,-1973027778,-456231572,807985049,-372951901,1505418784,-272829235,2110939630,681005005,1174621556,1996591131,2056547150,-553995935,1807100857,1821171118,502253626,-1217069400,-1295765398,-1453598783,792947785,-1075399954,-1460776252,-1484691580,-1920145056,-1971429848,1163019486,-1955229976,-335046184,1963891020,-1094610028,804940197,317651152,1681325964,-1828899731,657702381,897473664,2071944663,-1546250037,1684571124,1921992795,-374202560,-38067562,1201391851,1727436473,1255987350,418688194,-195568616,-2117176474,608806260,1429176652,1493908368,1769325645,487273047,1927849385,272646006,-1657322217,1132167440,1148449915,507873972,1655331686,769675382,-203025050,-1140549377,227536852,1276507929,-1592511546,-2032878468,1670812793,-139296093,798043225,-1011741383,-674289100,1203868017,-224994348,-2012784002,219073235,1630634914,1913118656,-1643161453,-1936518481,-867043942,-1951713092,1900391637,1273558856,955226382,1030267619,-1133153899,-1002407223,-931233424,-2020898124,-1425303395,31537697,-2114580263,-1947956330,-2108222210,941901360,-625828422,-1960492679,-1935146392,-1694550585,-1342298409,-641664592,1557222878,-746128164,-1393341749,250704942,81270407,-2046834260,197879919,1731868164,263954006,546551462,-483699428,1654811318,-1946370844,-1382296677,-1188431883,1377745080,764369076,-1005100721,-866730327,-491501172,715678033,-1622515855,145597086,340794318,337790009,1735974972,-217894853,1633235131,-128814434,-1453365416,179042459,-2050754936,1185179004,461823375,797600836,-1202935673,601550020,1445646573,1188577376,-1665791520,-920568870,-1921232156,-431435643,411019162,1173021524,-1847180793,1311187535,-9675474,717627318,-1345758524,-1853410515,1421244952,2073931722,1142032093,1340649002,1546295934,1964145277,-812643984,-591106725,-359062709,-1628427658,-255388852,1439551580,-265307572,62640026,-1275633503,-1728312363,1004305385,-1652765080,492462650,809914618,-16958299,-291210183,1666891124,-2021196358,-437950796,-1715522484,549534620,-1034031483,489113586,537539830,-1485509683,319114616,-1403345619,-674922930,1002879535,-595247282,-1633129923,-1244599079,2119245337,1756925083,720798958,-967099075,-1961640857,-968371952,-627021579,-713346982,-410190669,307582507,-393062423,1836072038,1354079883,-211528831,-761929193,967246074,1581967266,187567914,948647022,67747659,-1869419382,335758849,-556453759,-662024917,-1711140327,876887180,-2011534619,-80802078,946018270,1903116938,2026734839,-2049896664,2101584397,1199225798,830198307,197009439,-175610700,1233861098,-138033696,865043990,-449788671,-1821623971,557050074,2084065260,-1244704733,345958475,-1932368638,-1213288379,693399010,1507749922,-163606558,783039562,-1186966175,-1147071178,-2140074089,-93299960,227009599,-339870157,377036979,1136881703,466467379,-1879202709,1747666275,-6496659,151894243,349281158,385750458,2058938728,-355256452,693575917,317524561,-993462152,351732819,-866711281,-1569198089,118923737,1116007528,-676729784,250754597,-446063725,-1542498071,-1850633346,1512275657,1277649862,1352482127,-2132548996,510273216,-1392287149,898893508);
/*FRC*/Random.twister.import_mti(117); void (makeScript(14));
/*FRC*/count=147; tryItOut("\"use strict\"; mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  var Uint8ArrayView = new stdlib.Uint8Array(heap);\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  function f(i0, i1)\n  {\n    i0 = i0|0;\n    i1 = i1|0;\n    var i2 = 0;\n    (Uint8ArrayView[1]) = ((i2));\n    i1 = ((~~(4095.0)));\n    return (((i2)+((~((i2))))-(/*FFI*/ff(((-1.1805916207174113e+21)), ((((-((((+abs(((8193.0))))) - ((67108865.0)))))) * ((Float64ArrayView[(((~~(-0.5)))) >> 3])))), ((Infinity)))|0)))|0;\n  }\n  return f; })(this, {ff: decodeURIComponent}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [0, 0x100000000, -1/0, -0x100000000, -0x080000001, 0x07fffffff, 1/0, 0/0, 1, Number.MIN_VALUE, 0x0ffffffff, 0x080000000, -0x080000000, 42, Number.MAX_VALUE, -0, 0x080000001, Math.PI, -Number.MIN_VALUE, 0x100000001, -0x07fffffff, -0x0ffffffff, 0x100000001, -Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(331); void (makeScript(14));
/*FRC*/count=148; tryItOut("mathy3 = (function(x, y) { return Math.asin(Math.log10((((Math.hypot(Math.atan((( + Math.fround(Math.log2(y))) >>> 0)), y) | 0) % (y | 0)) | 0))); }); testMathyFunction(mathy3, [0x07fffffff, -0x080000000, -1/0, 0x100000001, 0/0, 1, 42, Math.PI, -0x100000000, -Number.MAX_VALUE, 0x0ffffffff, 0x080000001, 0x100000000, -0x0ffffffff, -0, -Number.MIN_VALUE, -0x080000001, 0x080000000, 0, 1/0, Number.MAX_VALUE, -0x07fffffff, Number.MIN_VALUE, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(456); void (makeScript(14));
/*FRC*/count=149; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return Math.cosh((( + Math.atan2(( + ( ~ ( + x))), ( + Math.max(x, 0x07fffffff)))) ? mathy4(y, 1/0) : (((((( + ( ! ( + Math.abs(x)))) ? (Math.atan2((Math.hypot(x, y) >>> 0), (y >>> 0)) >>> 0) : Math.fround(y)) | 0) === ( - Math.trunc(( + -0x080000001)))) | 0) << (( - ( + mathy0(y, 0x100000000))) >> Math.atan2(1/0, 0))))); }); testMathyFunction(mathy5, [-0x080000001, 0, 0x07fffffff, 0x0ffffffff, -0x07fffffff, Math.PI, 0x100000001, -Number.MIN_VALUE, 0x100000000, 1, Number.MAX_VALUE, 0x080000000, Number.MIN_VALUE, 0x100000001, 0x080000001, 0/0, -0x0ffffffff, -1/0, -0x080000000, 1/0, -Number.MAX_VALUE, -0x100000000, -0, 42]); ");
/*FRC*/Random.twister.import_mta(-1051993183,-338907617,-1098358847,-2121006699,1790354123,-442255306,-1377027872,1337481636,-857738025,-2093667036,-1076894179,552471574,1547571960,1539017246,-1058425924,1394086317,-344689134,-647468650,351187623,1491344358,604595603,-979128757,-220820097,1304961171,1367320361,1962352147,509218965,-1029969846,1333385590,-1921091219,-264557755,2111660677,248087425,1813341766,-2050487682,-1882590730,-1197409544,-2045393119,-487656345,1588443404,-1563792528,2092679573,-1215842161,-1368221082,301879918,1990538992,1306229237,-1034434427,-223474827,-1035628134,143056801,416052409,-1084605253,2080952173,-374038938,932244097,-1069545613,994672442,-549351568,-1518270465,-1834498707,1026867600,-1920382142,2087798429,-953924034,1599777669,573883287,-1279139715,-1610519359,1788129207,-601877947,-1118151731,-620783499,238941546,-1325207113,1197371980,-1783631001,359584498,399241578,171641322,-1956563180,1795433759,1811345935,1509848521,734003592,-961405815,1140045270,1375600852,340191671,-2084556881,-617349433,441732523,817524987,-1499168401,-558087209,636398056,2114957426,-968855290,338601470,-516292397,1262801322,709120867,446634115,-429047628,1026087012,-445437148,-703922964,93630268,1832109754,-1708946602,-1313924998,-825888235,-2051818193,1462003164,-967307909,-523916475,2024090736,-271302173,-339612214,1780867991,1622662938,-1536563361,1798072414,-1353886086,448971043,946330639,534531081,-385149255,1839674929,1046994440,391882107,-222775010,780906321,-71184981,1728877675,-483196638,380115416,439333510,-834797575,376417899,240416547,1244757454,1717043954,107928226,1764827325,653232755,-320520803,1146133019,-2135057625,-1463936156,-1079265824,-1861566696,-1435574153,-1125898692,-1146189074,2141114617,328010418,-1440188141,-1332976576,809924132,-760905681,-1459652321,550525827,961812058,-1403877067,-1182277357,-176058034,-1434319236,1549468936,-69331232,-2087453872,-289440239,543492557,-944095054,-830780677,-1095760435,-432907525,-1886307886,-235518209,1679639505,-1988910786,1486172079,1340886390,1980132696,-492195040,-1208470153,1360602951,92197702,690103717,1698576978,-371759218,-1039981673,-1489167674,-1066255654,566415125,-1283459105,-325119642,669296832,2128573911,-2126649268,-1148270924,-605619117,-688451507,54409956,-1582676017,1547931483,1634950952,514357072,1353104820,192966481,-1499957708,-2132936406,-1654152151,-1295565242,1430803386,-562502410,-650464478,-1319772939,1405992256,140871619,-496012499,947274172,2085707657,1836638511,-1209490787,497320577,2004486594,1205936273,2083545825,-1062110428,-1091475066,1497480910,1640535990,60712303,663384952,503178465,-1694478922,724743802,-78734456,-1349493356,-428729665,-521289470,-1603523418,1936210614,-1449526119,969942654,259805875,451950743,1929058324,1099227327,719330259,-561967985,-157437771,461437761,267217579,-1207993893,255120413,1761548687,2095552955,-1567922262,-8064105,1443123364,1807768880,-42305248,458066861,2015610745,1654349588,-1432320295,-1715674385,596452105,-1641097811,3129887,-670838194,1259472349,-1673639444,-1832457047,-1284381768,1958778508,-1782350789,1272913223,-1053775851,-1101221201,805219999,-1769860372,-1225079192,1971973292,-795718850,737138087,-1655564789,-832815232,-1627181450,2126476648,-230177103,143986405,-19427873,-1675985238,1155240797,-770447965,-729694074,1213679360,-1085405597,-1327673218,-908869671,-254559764,674177627,-1792635118,327857009,1451199560,-1241932636,-1049808623,270927547,924593946,-1298757690,1974202175,-95584194,-633304333,-1703552349,997415721,288162272,-510763529,216254388,820746657,403694476,-1877457405,2012964001,-1674533073,-1103221018,661351244,813018694,-1281508484,-831821690,-1050178705,221187930,-1273311074,1245245798,55772535,1467014005,-762671070,1082969265,-1170023564,21332054,1031027015,814864344,1945231432,-353976324,-1717119108,-1422312316,-849480300,-927692721,-973430041,-777754995,-1753098726,459700917,-1118554917,-733928674,-606937506,-759923957,555600812,-61907709,892456965,-1566321250,-1431711916,765069273,156975279,1314429924,-1644344261,1353308891,1265326135,681074593,1675806086,1886197326,330722331,965690297,571521424,1294460531,-1297685279,952643981,1966791625,-1951035048,249167427,872913542,-912602348,-539900917,659817746,-722081704,1246310634,-1707766361,-137630620,-1534775426,452703631,2041786345,-25797745,-1827659339,-654046074,120607877,-875156228,1537406187,-1951144725,2032954437,1104726341,2089486928,-1051095135,-1880807298,-255692096,-1235078303,922532447,584758331,913435245,1210005068,210113352,-1631217733,1081623214,2033718148,-372731644,1855538780,-741712446,1551194040,-1378563407,495777313,-1750738153,-109980358,-1211247741,1816055383,-1967658069,1647391902,-1619717278,-1530293272,-1476851149,1549409789,1371871320,-132728993,-980088969,528894465,-1375853639,-951035233,-917175033,1316104858,-407634869,-590357966,-1338053900,1851600421,320623246,168808138,399315094,-575299539,1034229679,564591021,756967063,2131688363,-415898603,1871119865,1795532405,775526787,1890043625,1470692290,1302710383,-1310699905,-1156630540,-1769674788,-1537942381,1787902259,827186978,-1493244775,1680056893,1516802748,923933695,960348915,-1574646800,-356135707,863354469,1087654568,152097883,-797700356,861236220,1314884411,-1364831098,1130699771,1236412781,1246417559,-514292073,-1632755747,1577065673,98738546,744027181,1722031487,410453078,-466268456,363342602,440107881,1228221594,1820453116,-447305131,1201007086,939020495,-1119605829,1215810470,1238769157,-1545600440,-1154584146,-555685,1694976226,1069532173,-1257314287,1142646218,-1736132618,-625252096,867996897,-1412022213,-2041876599,1847806290,376509027,1670148957,-1318100601,-567530486,1698882746,-2056176010,1747587341,1901699253,252849106,-242960276,2053619135,-1308092423,-864361628,-50473792,-1669314982,-997926147,-1025146311,-154361633,1073263159,-1573846786,876106788,107855356,1132071635,-798329406,-1335905381,414018102,-736726170,-1442633478,-342015498,-776638642,-2114753638,-1863313389,814630005,1247265129,-1775058942,1737826259,1356604013,-1403429205,-1062610827,1155294193,-1086507566,1919705908,-2139800296,624050588,790764809,-478364263,100635619,992411340,359543484,1460474140,689919283,934245911,1600294552,1875343920,2011488902,1113869093,1575729837,586735029,-1128177527,-1404668152,1228263954,-1910299895,-1572588148,-218169457,1724721099,403317822,-1788651894,-273137285,342806228,-937312689,-1153628582,379505635,-1887901521,-27573478,436341853,-1424407770,-1332131222,-9216251,1939470400,1352804957,-695205265,-493956062,1338600637,-398405097,-544918031,-1234289333,-1895835672,-693384793,-835190603,870813306,695186253,1887146695,-2016444577,-177532636,-448467394,-1445859996,-576009035,-1960530210,27888688,89269304,102134566,-14606724,-1808229593,831123633,1019539663,-329390399,-287131084,1604361738,1328575991,-1822306165,-1775165466,-2001119885,-1860423778,-502289948);
/*FRC*/Random.twister.import_mti(142); void (makeScript(14));
/*FRC*/count=150; tryItOut("g2.m1.get(g1.o2);");
/*FRC*/Random.twister.import_mti(161); void (makeScript(14));
/*FRC*/count=151; tryItOut("\"use strict\"; /*vLoop*/for (ufzczq = 0, {} = (yield (4277)), z; (new (makeFinalizeObserver('tenured'))(\u3056 || NaN)) && ufzczq < 82; ++ufzczq) { c = ufzczq; t1 = new Int8Array(t0); } ");
/*FRC*/Random.twister.import_mti(292); void (makeScript(14));
/*FRC*/count=152; tryItOut("\"use strict\"; \"use asm\"; s1 += s0;");
/*FRC*/Random.twister.import_mti(304); void (makeScript(14));
/*FRC*/count=153; tryItOut("\"use strict\"; b;e = x;");
/*FRC*/Random.twister.import_mti(354); void (makeScript(14));
/*FRC*/count=154; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return (Math.sinh(Math.cbrt((((((Math.fround((y & (y >>> 0))) | 0) ** ((Math.cos((x >>> 0)) >>> 0) | 0)) | 0) >>> 0) << (y % x)))) + (Math.sign((y ** 0x100000001)) >>> 0)); }); testMathyFunction(mathy5, [0, -Number.MIN_VALUE, -0, 42, 0x0ffffffff, 0x100000000, Number.MAX_VALUE, -Number.MAX_VALUE, -0x080000001, 1, -0x080000000, -1/0, 0x080000001, -0x07fffffff, -0x100000000, 0/0, 0x080000000, -0x0ffffffff, 0x07fffffff, Number.MIN_VALUE, 1/0, Math.PI, 0x100000001, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(533); void (makeScript(14));
/*FRC*/count=155; tryItOut("return Math.cbrt(/[^\\s\\n-\\\uce18]/y);M:for(e in new RegExp(\"(?!$){3}\", \"gyi\")) {Array.prototype.unshift.call(g1.a0, v1,  \"\" , o0.a0); }");
/*FRC*/Random.twister.import_mta(1734148923,-1084165254,-1743095472,-1864832022,-209169478,-653052914,-1759617518,151353813,2003184845,-466225174,1711729766,1711292208,559666759,-1095676315,-1325598041,1283598477,-2055428657,-1108955184,-4698063,-679914066,369995083,-34668479,1749646209,1220982385,348056661,-98863422,-1409671282,93181989,12754699,1172092565,1075776430,-1036620574,1741663099,-84757920,-2106458228,1138112381,2013032694,791646323,-1509697151,1595350818,15117406,1577367210,-418928697,648152850,676252150,-1242905873,-1343339509,1038751048,1552408418,-51566942,-1200559084,-106212055,3748732,1532840650,-1446681622,-1760482587,755202420,2013805690,-2039612593,1639652374,-443197636,-1874836867,1130680066,1224940076,-941082049,787232141,-456400164,-1822387197,-615449349,-1910146290,1702975177,515026944,1953187024,-1050836308,1790963069,1135298448,2044854917,1169847182,-1413754765,1188397169,-1523020995,-424076465,1420758188,-1957814503,-464412078,1679522713,78115911,-175122053,-2137021602,279183716,-1047872256,-1687286837,-1016079118,-1697154616,-1214120287,2022846935,349726796,-145524412,-505251056,745830096,801807142,795430192,-859757311,999498960,218517919,-569665945,114373204,-1373809493,-676680533,1802180828,1438386670,1570374081,95517628,-1403673599,-1964632544,-851576897,1892596772,279056991,1768652642,1483865728,-93985851,2055479293,-433974447,-1374786063,926107937,1520203199,1366355779,1935371677,-608750087,1346429019,-812581808,-239741632,114906868,-558453042,938753389,137233983,-578966399,239729848,-896397860,1244985384,-1894017507,-659472241,-763231713,744704795,445607413,-1611371932,-1317585733,258260302,868880993,252311709,-455343833,211163281,447639791,-487952219,-1800684649,-1984710591,-1456550454,2003054377,-1151367541,-1247419605,-162401636,-603017310,1269242417,-1505844874,-228313535,631391807,981891342,432627714,2139832405,472008453,-860892574,1979405488,-1885644975,-1224685648,1215533360,1213573166,-1254726810,-2025933717,-217303799,-1847949803,452617843,865658991,-215840541,-1972772918,-731225721,2130496467,-52155719,-1751404976,-1719247345,-2072839763,125468177,537359651,815478576,528078138,1647943442,965141518,-1145928073,2044870597,-1225733779,-751258446,575670097,1011562572,1920504584,-1598939019,-2024610379,-1216950069,-96523636,-854085404,890858003,-823724113,-884321717,-703402245,1546763035,1823628027,-803378169,-123354442,-265572844,1428303471,1902614015,1188934525,60538580,-401577236,1020596419,349044343,1600365804,-1432278145,1492617587,-1068662124,-1623699736,-949826157,-59231091,-1016326047,1104459366,-2065995858,-1628226694,2061896214,-1314083625,1537319330,835195386,-882218041,-825774364,-523571980,892745174,146336604,-519127825,1628359095,1124727098,795877697,1143324865,-466499913,-24215319,-151485232,785628093,889461252,-2021993449,-565164582,-391411059,-412846164,-747380937,-2130353553,-1846502862,-1215180524,2104167405,-1554905601,-1976122608,-1756465653,-749736815,-718246410,-1765107727,1897430478,-4368702,72294609,1231778014,-1578016515,-310258749,88026814,-2037551644,731505366,88894293,-1180051543,-1652841662,1731363962,-1672469613,1987975744,46975532,-1373315376,-1388034534,1916071142,-143761987,216356921,912040088,1740859832,-206700000,1118344428,-580015274,540378506,1042561280,264353418,2056852352,-221972674,-1724700013,-1755413938,1002609510,-1258478729,1328100359,2071345428,1844069973,-1077656209,520565528,-2051752146,-1866463084,-48569935,-2017051431,964768856,27733213,1420689104,-736814033,-920896016,849450479,-2061615320,464127431,-1146744985,-376004087,-164795709,1615043084,-1090687901,2143404918,938494981,916951182,-1410035390,-1037545032,1267848754,-1006174680,1674398439,918316751,1696231886,1110331597,-1393369239,1086024827,1158921111,736561277,-1834025524,-188414053,1170072538,1550940641,1022877984,1054803018,121050941,-2123235759,402165960,-439449860,-477576028,-583082227,995131084,514982578,736475299,13501837,1757405710,841321885,394837051,-1948104348,-130970018,-1786046793,-95297165,-1715475846,1003376750,-158735124,39782674,-381672884,-357267144,-1129263671,-1623163658,-1896073556,250380125,-1891663903,-156845448,-1399052890,-519648885,-755869841,11386284,-970517201,1649142093,-635847992,-2091632154,306231132,793636999,-834661095,-1542232797,142329274,-294240998,867438,585406020,1226850428,-535370861,1008891516,-1957524737,-2131556945,691098783,-870350643,-1310797191,245674175,260113679,808751438,1997523465,1162369435,2070536139,334152700,1056308565,903602635,1699279841,-363463011,-386504635,1243120465,-1951889001,-1099005775,-138611245,193997866,-793463330,-1294129033,1277418925,-577270748,-1926346522,-1512726268,-894821320,1985525364,-460062567,432832884,-713705104,346666080,-679774088,1534071569,1369010282,948007368,10467100,817201848,1377861470,1681373525,-1523728558,-1911710847,-1307075370,1698460604,-719680670,-213693699,1207553757,-1829235353,-121873930,-916836119,-1525386274,1115826233,-769776928,-1203266158,-780674830,200964308,1931736210,2140657276,515954952,-1696246167,-1220917405,139380471,-1382770144,-1669494721,344259049,-1845531689,-1667701367,-652206974,-1268891556,-629666241,581826633,544768793,358355074,-1791479378,-919290991,950303817,-47281032,941820674,-1130365469,1507877598,1118001533,1599895364,-125041524,-1022581569,-2054454098,1366593299,1123103981,-346032761,-513181605,-875464726,98954073,-1827977383,1261174675,150069258,-369346585,364572339,1424312723,-1324644315,724117548,1625849066,-1574277611,-490974557,1005114543,656814628,1846417172,1731370075,-1966131681,1187272278,-979725830,894060395,1196860505,270737619,241179261,-558853327,-2089563600,-1053636395,-538627001,1888252893,443803108,-1388234564,836089201,1593914766,395668512,-1029427249,-1152328988,1582002154,1885608493,-192189653,-2099027389,279582606,1606927191,-2042232271,1641984372,-1211368055,-140738127,1396900853,-1395839161,-208473996,889981611,-793433261,-452024209,-1782557162,-952137452,-386824050,-1058488776,-393302341,-552829906,601752262,-2084097018,171581602,-487171806,1086361152,-167233312,-1894032551,1618543744,-328971091,-245859027,-1622760938,-313464416,-1234702812,-929085210,1612144316,1233249390,-518897357,420290947,1392102614,2044469646,348670500,-146406926,-848861806,-1399912218,-997341624,-1872761198,-609959295,223568679,-595579336,-726587536,187827490,-1950329580,-114556758,-1342578282,1586539356,-2136974304,-384324638,-2147039686,1422399790,-725109892,2100511645,1785276584,-247880858,-231819964,1231563695,667658079,-1961456798,1733553403,-1763276358,4443851,-1067407512,-1371551304,417979700,1118076236,-961299509,54747093,-1344731423,365981841,-1944898838,-566340935,-1242677447,623870442,1161816771,-2030841033,1625488209,-653098149,-1127958824,-1051440624,-293488640,1227546017,188032668,2131400864,-2119798241,-1096960438,-1302540578,37277583,1027799541,1957454259,-95068659,1783969005);
/*FRC*/Random.twister.import_mti(224); void (makeScript(14));
/*FRC*/count=156; tryItOut("/*bLoop*/for (svdqzb = 0; svdqzb < 27; ++svdqzb) { if (svdqzb % 6 == 2) { s2 += 'x';/* no regression tests found */ } else { var cllduf = new ArrayBuffer(0); var cllduf_0 = new Int32Array(cllduf); print(cllduf_0[0]); cllduf_0[0] = -23; var cllduf_1 = new Uint8Array(cllduf); cllduf_1[0] = 0; var cllduf_2 = new Int32Array(cllduf); cllduf_2[0] = -11; /*bLoop*/for (var xqtrgb = 0; xqtrgb < 68; ++xqtrgb) { if (xqtrgb % 5 == 1) { print(p1); } else { (29); }  } print(/*FARR*/[...[]].some(encodeURIComponent, cllduf_0)); }  } ");
/*FRC*/Random.twister.import_mti(424); void (makeScript(14));
/*FRC*/count=157; tryItOut("/*bLoop*/for (let vcfwam = 0; vcfwam < 7; ++vcfwam) { if (vcfwam % 6 == 1) { v1 = evaluate(\"g0.i0.valueOf = f1;\", ({ global: g0, fileName: 'evaluate.js', lineNumber: 42, newContext: false, isRunOnce: (x % 26 != 9), noScriptRval: (x % 5 != 2), catchTermination: (x % 2 == 0), saveFrameChain: false })); } else { print(( - Math.min((( ~ 0x100000001) >>> 0), (Math.atan2(x, (x | 0)) | 0)))); }  } ");
/*FRC*/Random.twister.import_mti(565); void (makeScript(14));
/*FRC*/count=158; tryItOut("\"use strict\"; h1.delete = f1;");
/*FRC*/Random.twister.import_mti(578); void (makeScript(14));
/*FRC*/count=159; tryItOut("let (e) { { void 0; void relazifyFunctions('compartment'); } s2 += g1.s1; }");
/*FRC*/Random.twister.import_mta(914435362,-2146255771,-105732212,2002819426,1661509384,2075901511,-1434073540,-403439838,1232282686,1625929167,234218189,-1132545481,-484908020,723727121,398445788,-777100951,-715399553,1487542390,-1677697276,-643937712,2001437985,1609639272,-246925750,1321224913,-1339821177,-265769277,291782901,-281982674,1601366796,969082019,-194081023,-28913406,-368959160,440986839,-1451566325,58673587,-1912549382,-1162027353,1034678479,1682239354,-1976572921,612825277,-515465377,1897600839,1458002634,1035786279,420267129,-1128531242,-959788377,-1788721437,1086941589,43954567,-5208187,-1398461337,66583903,1568392302,1328016047,-441869564,1847416579,-1473249801,1712510594,1778164086,-1995106506,645998079,-621128720,-1550148935,1277173591,763417120,-213058085,833623428,771006537,441262449,905105876,2037348303,-387901351,-1654796844,-537676353,-1258925084,1191021828,-764110945,-1460182011,889975058,1680063455,-1323010666,1854835133,-902838801,-516003697,-1425005528,-1455720215,-351000214,-782606749,-222516960,104874871,-903237755,213753811,534174357,1867314481,-1040534099,2098402116,1997353337,-1247885171,1574203644,1713456839,-1196578252,-670864136,609879409,80293013,-1273384740,-1339089516,529810332,-258796442,318479629,-2126350174,-1681680351,2095415600,-1185573177,1320979895,1144638572,910891684,159086977,-710997424,-182940423,-644158969,3488640,253120740,-268719980,-792650692,1079525640,1942725297,929196454,656222711,-987059893,1317398035,1966691296,1786983025,-453679766,-336998117,-690227558,1343649471,1311789186,274643191,1703536582,134650950,2092863147,-820868342,691896377,-1732369783,-1556890839,491485335,-1587769106,1035330997,-727775512,1584771181,1548105293,-1113036673,-1192023480,333634150,467784076,780839146,-850454678,-1499979977,-1664326789,1520350421,19458764,-757812669,1337651281,1966641551,-1308271919,1616876207,-349139805,-697130306,1514724671,-874541750,-1080227303,695842608,-971300981,237424026,-339955847,1512416961,760841036,792536446,-32940046,-980110395,438971390,1718620940,-206390099,-1626708908,-1460085691,-1319574367,730606769,2066071306,1361424439,678907330,-1173732117,2073075452,305625694,-440770058,1108374273,-945581087,-792105405,1552015722,-7343537,-1978466512,1970848996,-681334741,-250828884,-1196062005,1986673391,-1688974622,-1181584583,1962022037,-1745709565,1984110329,230862852,-1123636405,-1768657142,-1162642871,-1433510724,-982715967,-2140426891,-1969913028,1967060576,-1856602005,317926275,-118209325,254159467,1249113511,2031946326,2058054259,512101653,-1881266803,65193019,2044071312,-436446335,-1702823383,-928136566,221865246,353495600,12795659,-2072300674,1531331947,1294259767,-705555257,2094280919,-1322922894,-1115380839,1462692399,-867052130,-186550548,386385633,901515449,2118295174,-357915711,-1949197791,-2145817661,-1305502059,1248935797,81776709,667734250,-1560646575,1098908765,1321725474,-1948320877,-887378318,1746097533,-855329192,249354625,1480728352,1544210010,-560450498,-1439418384,1918034597,-1270032250,-154886841,-31167095,-980648875,-1062291576,-613946144,-2025657716,-1324526044,-549687718,-1797825463,642042190,1312919481,-222563220,952071182,-785020028,-995276669,-1232683595,-1841608838,358650147,-483568928,-1026633521,1654049532,2107248869,-329326245,911265473,280504713,590306030,-530320318,851457768,-1258269206,506195120,560963427,-1991422098,-385868047,1419642359,-411763319,936488581,742637461,1453438353,-1268439282,-1762697277,2028293694,-2126062784,439961121,-1885718638,285353035,-265046348,-761401013,1324488937,-511803896,-37167317,527251511,1200403267,49541887,-167925852,-1362296630,1210988637,120942107,-580566739,-100658196,-860614435,-2036355283,-2037086149,137397549,-1864000265,163975812,-1451560935,230247491,-1835735353,-1617972702,-611621078,-108232296,1514290428,690264193,-1813495104,1278166439,-1092303715,-344086151,1911642578,-125726787,-1303144462,-543679131,-861786746,-358346584,54368417,-1492688922,1474709385,1265943201,153195727,-1186067979,13968652,-1489624026,-1958945107,1800570057,253744139,620669393,282305370,-816428419,857649360,-2006151076,-146600120,103361958,-664738283,1258646084,1222067444,-842760483,-1798711234,-462517723,-1268026828,-1868253925,-111593797,1522696648,-1789945584,-1868426567,105780516,-492438038,-1409843722,446180066,274375150,-163278211,-424070841,724150961,782544753,-1188126553,648058419,1769329159,-1683028772,361063882,559233089,828637079,1687439952,-1249226360,1325461571,1406191423,-1423192775,-1395104444,1436915421,1773599828,-145117437,-1703615877,1869498553,1497208019,1244534387,-191827276,64386654,-1153197074,-1371738562,113019856,-56794984,695881342,2002940994,-1634321716,-380451950,-1958358181,-93080837,383073114,-734900621,2124564071,1572109521,-886894385,-247235550,-1594930281,1601832256,809969303,-1425757040,-1426298486,-822519704,81602343,659551669,1571798762,1818245307,717733925,-690982841,952719722,-756968294,1927030783,1546774288,-847950174,2051590138,-1123452743,918016034,1975000729,1987929810,-288263784,-602694021,1391588905,354978091,-1361020592,917936042,192413469,535363729,1638493023,1329515038,-185104181,1277525893,-764234696,1200283254,-546436080,-2126062144,1954497161,-2095848027,188706734,1259772848,-1743698045,-1352738176,437400347,1107598528,304365889,-921413514,1907072149,174044220,-422152855,-312222537,1109682975,2030053666,-787671250,-1302683340,-1884943466,1726809438,-1144614149,2122228302,-1890472628,232164150,1820260399,1451602923,1113763454,-1230096339,-1478508140,-1044146483,1421185915,1508071301,-1546871645,-106257379,1156544998,195998935,1311067884,183493032,-1877725175,267938465,187310297,-834314510,813367989,-912999823,-1608113685,1406741789,987761636,-387455760,2056550391,1061070734,314550032,1298422930,-1793209461,-926865289,1803178281,1451795766,-1460959441,-974189232,-1664703829,-1012306076,2045017675,1718499725,760708557,620382211,-2038199309,-942908547,474062490,-671423612,-493380732,412160290,1812544706,1975482422,-562743567,283229768,-1255233819,-471409190,781344713,-629513608,592298584,1867627127,-390715958,-480805706,-1168181585,-664439782,320720719,1668991592,-1385238925,-557784613,1698005147,1393659699,-1343721904,887002602,-1702774299,845484669,-808893744,1543424048,-254671389,-677362325,793884341,640516308,1946299360,1132202809,-697221039,1238331181,-1032665912,-1132373582,515443836,-120479315,-958905853,-1617199496,-1496964847,-1060648682,-458454608,-1842099278,1870304826,845387779,-191024697,866347653,90071229,1301766788,-2142266768,-1300507789,791644095,1944145165,1554468288,-301697829,-1991254550,1355124585,2041003239,-708205263,-563511456,-1122831417,-1960252489,-1621901784,794729856,2116014945,1561509699,623199337,-1489277481,979936448,-502315760,1832897718,64259690,-585059910,841806886,1171714503,1232389761,777012581,1628503394,-2005456201,-1970884440,1426885134,1038090402);
/*FRC*/Random.twister.import_mti(2); void (makeScript(14));
/*FRC*/count=160; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(11); void (makeScript(14));
/*FRC*/count=161; tryItOut("mathy4 = (function(x, y) { \"use strict\"; return Math.pow(Math.fround(Math.atanh(Math.fround(( + Math.ceil((y >>> 0)))))), (( - ( + Math.hypot((( + Math.imul(Math.fround(x), Math.fround(Math.fround((Math.fround(x) || Math.fround(y)))))) >= ((function(x, y) { return (( ! (Math.fround((y ? Math.fround(x) : Math.fround(x))) >>> 0)) >>> 0); }) % Math.sign((y | 0)))), Math.atanh(0x080000001)))) | 0)); }); testMathyFunction(mathy4, [-Number.MAX_VALUE, Math.PI, -0x0ffffffff, 0x100000000, 0x100000001, -1/0, 0x100000001, 0/0, 1, -0x07fffffff, -0x100000000, -0x080000000, 0x080000001, 1/0, Number.MIN_VALUE, -Number.MIN_VALUE, -0, 42, 0, 0x0ffffffff, -0x080000001, Number.MAX_VALUE, 0x07fffffff, 0x080000000]); ");
/*FRC*/Random.twister.import_mti(234); void (makeScript(14));
/*FRC*/count=162; tryItOut("\"use strict\"; v0 = r0.sticky;");
/*FRC*/Random.twister.import_mti(248); void (makeScript(14));
/*FRC*/count=163; tryItOut("\"use strict\"; /* no regression tests found */");
/*FRC*/Random.twister.import_mti(257); void (makeScript(14));
/*FRC*/count=164; tryItOut("t2 = new Float32Array(({valueOf: function() { { void 0; verifyprebarriers(); } b2.toString = (function(stdlib, foreign, heap){ \"use asm\";   var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Uint16ArrayView = new stdlib.Uint16Array(heap);\n  function f(i0, i1)\n  {\n    i0 = i0|0;\n    i1 = i1|0;\n    (Float64ArrayView[0]) = ((-8796093022209.0));\n    {\n      (Uint16ArrayView[((1)) >> 1]) = ((((i1)) >> ((i1)+(i0)+(i0))) / (((-147573952589676410000.0))));\n    }\n    i0 = (i0);\n    {\n      i1 = (1);\n    }\n    return ((( /x/g  ? intern(/(?:(?!\\1+?)+?)/g) : this || /\\\u00d4{2}|[^]|\\2?(?:(?:\\b|([^]))?){3,7}/)))|0;\n  }\n  return f; })\nreturn 12; }}));");
/*FRC*/Random.twister.import_mta(-260817686,-411674854,1848977787,282163141,-1783197589,1909893454,-965497319,733569628,-89346809,886672512,737118336,606725339,-1523591933,-58308243,732652048,-1664411815,896047336,1143880177,-1738549348,-512031727,-1799681702,-1768360677,-120316313,2105813380,-932795968,-1495735065,-1458659749,-2031372780,246211029,1498170788,1777751003,-1590468905,-1433501485,-805199477,328467657,-163374113,1689883675,-1733865992,40194346,924577356,1639425291,1733469976,-447210405,205281488,-629579226,-101782952,882523470,750626251,-344929596,730697871,-358887453,-85912563,36661326,-1564767862,-1816880498,-2010344022,1198314267,-1736737396,1674461116,-1357187782,1712301714,295830192,1688755056,466337362,-1011744098,-521027611,2003370575,-275774420,-1406172663,-1009279106,1180472415,1567864476,2060519208,742318387,986817635,1977782181,1363428956,677928242,673430675,1647171677,1083689874,-383913488,179731338,660319351,-843788611,-473419612,-1285658755,553046044,934182826,-2002405684,-1470938178,1752313936,867855499,-1178895768,757419886,-791648247,916735813,1935606420,-823078836,-717068430,747148800,481700753,-1148644210,-1379786575,-1617944292,-1030786800,-1178581811,-1581438249,186996776,870792932,-1638911819,172940793,1157450950,1904912953,-1903666331,806594806,308798595,-760137949,1033055732,2031527989,-647692985,488775980,982444599,951422972,625111898,621073036,-181277937,1747732976,1892378106,-603029230,326525781,1000689286,-1504048293,1876969091,1268698366,-1970118177,1178240640,-705051773,-1583635534,1458288601,780496249,-738611801,1170238478,1058559143,-1583395839,-521610835,384064442,-951274788,-1518276974,607428575,81648829,742918801,-1805227615,-393396585,-1261457170,-1431957115,-1213325719,-819978129,901399802,-1455524564,2046848785,713493358,1705113085,-478976307,1362994855,-1756729870,445359186,-616403979,1666823262,818387311,83811235,-229669938,-375946394,1922128716,-838396678,74411508,2057807666,-1110111086,-723647122,-1423979763,566076293,51595408,-1949476868,-1398573058,102223768,-1891435716,702043981,1402407229,-1548472131,267470726,1158109443,664325220,-2125204969,811544058,-1990973601,-2136546424,-684781856,-919063518,-1379186114,-2142993298,796955666,365752561,52125333,1735442939,-1494274890,2017494653,1763001887,-1829135527,-358673213,-1653708300,-807189347,-955483190,-1579534891,-1109179974,-1455066475,-1452359347,1452517428,647920005,-351169981,10235993,871087537,-1074547313,-1318987652,755349505,1411192130,-381829118,24020361,1411987724,1899880783,-254637214,-936860409,-1453484381,-635423663,305882066,1341096729,-1137696888,1045526936,-1299798054,638877028,1367623529,1125946025,-1738876756,2074722285,771391185,-2082154270,1790972500,-950800674,-288640468,1142138548,2063772388,1118136007,1681606911,2050529576,1879743333,1190447489,-224604496,-1037361831,2047884206,692508704,1397109282,-144550246,-1888237089,-1815163674,-1984393606,-1104865580,-603747019,456843740,1337116198,1209974023,-1337849949,-333604515,-1067512219,461640740,-763315371,-680318146,-1960341248,1178494719,-1455768923,-1570259169,1840340835,1910019953,-1063846359,906289833,2117151021,-1004222581,1263860350,1413800356,-1539028841,1488953613,-1223646402,710743842,1004395046,-1850025317,-793986334,1085785182,1846498742,1384332133,1472936232,1833061565,598809692,918473670,1975800379,-60952373,1440932331,-975117675,-614199625,-929098170,-2106086385,1714724581,-1192357475,1030307824,533451139,-1615161413,-1275262243,-186465325,811820131,1496060982,-1874159388,-1741391830,-842280928,-1996208788,-892760028,107889869,-1939165637,-349287628,-200408162,-2111510761,-778618127,-2044449725,204670151,-792581817,1623366061,415766105,1669509135,2091767966,-1705040244,1996765094,333838438,-711275769,-725643398,1045263144,-481433360,1289087034,2135358205,1596705724,879168660,-2046182855,1595813846,-241941169,1115047646,-1644300035,2087434403,-742363935,-1822360116,494813604,-1470293643,-812831007,-510791602,-2028495095,1002598883,-363859290,200564344,-1727433780,-1699981047,962081080,1058863464,-576957458,653049044,1834629190,474952806,992877705,-633418843,-1543745666,-1545824145,-1563555842,-2115285784,-1679945618,1320759458,-948437156,-833367877,970446021,1366006636,-943238815,-1123429663,511285740,1990020712,-1737716775,805032426,1741364767,1837933834,1096392492,-1150710053,1540753525,-1798225099,1591577465,-1459531880,-1653227341,153704909,-1198706389,1614131097,-215477160,-62049838,514475312,-2077265972,221634514,1480807213,-42731089,-764946380,935868090,694759586,2022815260,-391619813,987005322,-1782059861,1776250983,-497087598,307268209,303640092,1690732940,-1088601509,1692535493,-1293607554,-1880228114,-1551470807,361917776,1241129884,-886171197,-1668217868,-208313571,-1261842398,-605423293,-565275993,-1321233559,111690943,332576973,-14859637,-938451663,-1465915223,476731526,729120720,-1825268017,108912151,621121920,-453828408,2063258928,-1033807858,-520449159,502484537,-1723264290,-867845247,-1433815934,256310611,1256816529,978335456,1665237440,-2042847571,10666153,1538543949,-1104303605,-2122612860,-1903678333,-653020274,367794936,432938135,301323104,-653364615,2025659765,551157138,-1209147740,990564621,-825397430,459643631,794797443,-489118970,2076942642,331140084,-1358756938,1671899303,-199108480,1588770067,-1848121872,1138430879,1493124315,764560349,-2113224962,365350065,2076228021,-1370552832,-928986092,-524792247,223573976,-1055242253,-609526893,1574020167,-528151826,-95103955,-1854713700,1849832852,-1817121105,-496144483,567460407,1653223459,63532942,-1545370578,-884144554,1052267947,1252259861,1957652389,1368676082,-386898138,-492009058,-486119182,-1973302277,-377091005,1835002045,-1470396580,-1436506420,506389850,-543207166,-1910142628,-638359190,1711663639,-41353044,-1343545471,-1149329053,1174806054,-1362333932,1414090094,-1565543503,-1651947655,-1340576239,1876905612,1422327950,1139442328,406772009,-1663433852,-154214704,378818098,1853889601,-739107030,-2047241028,-834830392,-2041491516,291293970,332757833,-372828473,59395867,-1539738544,-1687195384,-1462884055,-1204699938,-1702496913,808044566,-300524262,17919369,-1214690953,-2087927007,648735093,-1957631681,-1471651553,1953924903,650285675,236407457,-1220669881,872503566,-1201295585,1977498964,-862592702,770540405,1606625360,1162342157,-409108737,-2041111453,2078719344,2116505010,-1345001066,220905696,949852404,-2045826691,-1676815395,1493917083,2099094831,-636789331,-2037069000,-1775191213,120513495,-1736156705,714536763,-1873551623,-1077755250,-1702128591,-110270370,-243037592,2103723447,146741812,-1018121484,1491655315,-901485598,2145772809,269495609,-857200673,1699729090,1568115180,-730345606,420904546,1634772531,2043822021,-1303525842,-604070568,-1695350015,-1945210775,1759936439,2004290909,-1224944892,1995287545,-601303517,-801212779,-814150335,-1948127126,-958059023,-778953887,878431870,-1208922167,-1521492282);
/*FRC*/Random.twister.import_mti(524); void (makeScript(14));
/*FRC*/count=165; tryItOut("/*RXUB*/var r = r2; var s = \"_\"; print(s.split(r)); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mti(566); void (makeScript(14));
/*FRC*/count=166; tryItOut("t0 = new Uint32Array(b2);");
/*FRC*/Random.twister.import_mti(580); void (makeScript(14));
/*FRC*/count=167; tryItOut("v1 = evaluate(\"/*vLoop*/for (let nbfqcl = 0; nbfqcl < 30; ++nbfqcl) { const x = nbfqcl; o2.g2.o0.m0 = new WeakMap; } \", ({ global: g2, fileName: 'evaluate.js', lineNumber: 42, newContext: (x % 4 == 1), isRunOnce: true, noScriptRval: true, catchTermination: true, saveFrameChain: false }));");
/*FRC*/Random.twister.import_mta(2056417856,1453266249,-246045532,1627122866,-2069469835,-1533336861,-772546846,-1452590706,36672877,-393986577,1501272710,-1135121180,-836590389,759432980,2143641704,1616956926,785924236,1710267305,199899461,1477250780,-1067588530,-2119944608,-1042327911,1087462949,2021777362,1113719068,-520899549,-875778715,1700528462,1725792497,352328768,1071289259,1170321464,187386872,2087169943,1517021627,184279619,1390415960,-460278355,1640185707,-1690911963,-1211177356,1835750328,-1106759716,2055908155,2135461671,1805992690,1329770578,246358166,1287636055,-108301088,-664885511,-585597116,-481035835,1263581062,-1336432957,913147942,312909342,-1850612688,1940198368,1399148565,-1938192461,-1935761235,-1353634356,811850915,-145741056,772152961,-555048261,-1192903226,-2103711867,241182428,-1970971344,-1273163445,1252855204,-1197707806,134055597,-152269409,-153956444,-1146972411,-1891047809,1462358111,-1317345979,-736635913,772092529,842992589,-1739012166,2112433107,-1713536725,294918103,803805290,-629793240,1215646350,-60427395,1539428463,1887093544,435276014,1685988621,-939695416,-1862932588,-952689764,-116289405,-1904974616,763678490,1847251641,63801515,-970851017,1781899674,-1897944510,659278553,-595373936,-1467958906,1944776849,1228767973,2095060211,-1156596599,442141029,1507206925,865500743,232285081,534407344,1354757580,1540396230,-1837150558,-883797817,1955038033,1578714612,-604161159,-2095377506,1744920239,2122313313,1234954797,680134339,1936839911,-1781069714,-207696196,937051086,-266415226,1223887088,1856465079,2021972147,-1503647682,207628870,1433830822,205423203,658613185,-853319143,855282300,1091898368,584444407,-1729359462,722846151,139785479,1166018237,-497654615,1457409394,-218728451,277806578,1540116468,-1559858207,1736721526,870935746,545825566,16343718,-2048858965,761767058,1129486472,60263266,1168999201,957272951,-290856870,-172875611,1495679686,646678006,1648649584,-1515534331,-1157312518,1695300409,340283141,1666432207,-990076419,957627580,-2081848701,-899913694,436255319,2059196593,401589972,911736697,518132690,1087782932,588203393,962236681,166893357,-403876749,120141633,-1187112550,-1709961960,435707814,1583005483,-2089619261,254316698,1504355141,-413074788,-1163854565,-543182460,-2140717789,-252339652,1141092873,-179223332,801608393,-2027213484,-775160885,303773549,-1006459940,1101298172,-1520848946,473880903,1018912537,-630337017,91127504,1354963090,1233676121,-749659052,158286126,-73625152,12922495,1850654162,-1889844672,-620481992,1861636344,206128888,-1386375364,1891553154,-309947638,1863102385,-1217186230,1560750497,-238588414,175219764,228458383,1990483264,560556866,-1692856511,-275430839,791293181,277910147,675532330,795400138,-1571539180,-1138400494,2038781221,-339457403,1167954758,-479200143,1518428220,-226309571,-1656668355,466984230,27488336,377064122,2121309045,-711319608,897632740,515354246,1441360169,-1511430627,-1458715325,1176132728,640767353,921130362,-2106773559,1194268721,927506729,-822058414,1890157,181500114,-189226186,-1054201382,833625008,932100503,2096923683,1511011854,-1990560243,373785226,-1921557700,1997333281,-1147955998,-124811404,-1506660276,-1745758676,-642766020,-1296056097,-1581907663,-1626966415,1314782382,-370341792,145526955,-1451328751,-1580617635,-1688349922,-1354599256,-381184922,532292952,-201046393,1293175818,40400928,-538108890,1467711655,-1120194574,872766804,-1969009649,-1192727953,-1528106801,1487860235,-1634665755,1491370949,1023548876,667702296,-1771298243,781230750,-1192767029,1051007101,-1438297711,-2033438932,300482711,-1107664121,1223632064,921974331,587937405,1365595732,-1662162074,-2022494544,-1767820456,1860703727,1415794133,-2081408764,1556730122,-713970525,457534682,431306540,370883441,1296490635,-580564844,-1125038908,1984152275,698742797,-1747710374,1884651355,-243439692,988526505,92865027,745487433,-999356930,396966674,-1790829653,238891003,-1764787968,247010886,-1827105418,-329019667,1180052916,-802347182,-15042726,-477831275,-1397568742,1467839556,1080639808,737314521,-1865599971,38252661,-773244099,-1205250194,1992262782,96837361,1671270787,31500916,1866129856,-5207605,145636969,-160060027,-2140972032,-891049697,-332049123,897199698,1605513476,1619192000,909674194,813280387,-1727769838,374272411,542485808,22844185,-645656457,-801994291,-168690175,1361913069,-289635343,859176035,1895565551,-1338759723,522162138,476249497,-352327011,-1189906404,597087440,-1587456436,-991760185,-1378923033,1659906017,-1755505966,-166415572,-1218697467,668375156,-2080079778,-609159275,802002459,-1862879757,704893583,188339663,-1888188705,211083726,509327870,-20388115,1390381651,1395747086,2057809637,1072516349,1096814944,-1184325100,-1123806579,1314697573,699418632,1106265160,715720892,-723362128,1406620998,-758707058,1248618975,-1610688632,128026757,1418746980,-1684920792,-1210358002,776423715,1103508865,-77758976,-333740109,-2026762415,1160572470,746287435,1546361711,624385974,-1128717976,1936107170,-1090813280,1091751345,-1213235085,-1197744511,725873382,805531712,868890004,59078262,-41600202,-924281035,-113408078,-1073861161,-389299734,1724425097,983532560,1603589912,-923535892,-74428075,-1640501091,422551465,1384974163,-1416998162,-1415257399,-1856081495,-774592827,-1278445296,-343667063,-1570481876,1207294095,310423052,449888857,-766990633,-1299093825,1767315573,-1312130622,-590062049,1478366570,-328402417,1362393867,1592633279,1985534223,-1038905424,2120154420,-179555069,-671096903,-545872328,115454870,-1471053917,188075797,-448175839,-1534285071,-136019526,-1948781246,-542931154,1926897015,-1121827426,1729218117,-51089595,-1422608893,1448616476,388547573,-1306528798,-1027504822,-1767417455,-1653577634,-425409121,-201342268,-1537754758,-685144010,-967725132,1841929087,-1026900146,-1942231916,-983117281,1629027681,-931776965,889241936,989588300,671873127,-31957654,-1033085716,-1286197712,1331835452,-1041667306,379638928,-1928069286,441595989,-108116735,466363431,1974237253,-1221699229,998709633,-161663540,-1426363421,1930600697,1730868698,-623578813,-979154177,-437352692,2145651277,-277598176,-1580260839,-1985247461,1454419715,466873072,1536013064,-1914968413,-569723841,502475915,-564238602,-1888419804,-1635841142,1666853254,810666960,-2101833234,-226173764,123339677,-595210893,-209271069,-366522142,1330043266,-426306689,2088687577,432524921,-1235216344,325147855,-500947712,851737059,-1171246606,-712696676,-592839888,1233605698,2032734941,-1978276106,1091336433,-1594157539,935961938,-805011659,800895344,-1479290044,799869891,-1318752921,-147100189,-188018996,1590891829,-406904259,-1162265151,289044194,794521218,1157695101,-1287932166,-1591812689,1402208952,-1723482345,-1491277901,944006210,-361388359,-1295401472,-1036919119,759623504,-771241568,773359836,-413566450,-555639985,1152150316,603862608,569586850,-1344530114,-740477994,-1139053422,1316799811);
/*FRC*/Random.twister.import_mti(26); void (makeScript(14));
/*FRC*/count=168; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"[\\u00da\\\\s\\\\\\u00d1][^](?!(\\\\D)+?\\\\1+?)(?=.)+?\", \"gm\"); var s = \"\"; print(s.search(r)); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mti(472); void (makeScript(14));
/*FRC*/count=169; tryItOut("(void schedulegc(g0));");
/*FRC*/Random.twister.import_mti(481); void (makeScript(14));
/*FRC*/count=170; tryItOut("/*infloop*/for(var x in ((Object.isFrozen)(((XPCSafeJSObjectWrapper)(Object.defineProperty(x, \"toString\", ({configurable: true})),  \"\" ))))){m0.set(this.p2, s0); }");
/*FRC*/Random.twister.import_mta(-1027919212,-2002847865,1868724611,-2026274820,565889843,-773154963,1998800919,2038311973,1772642031,-1049460572,2094764435,1766127720,-1598639962,-2000775375,401014411,-1821859816,1883245214,-1288684954,-1125109091,170729640,1273745151,1989385548,-168493565,572216855,-537270685,-72425315,-1344303261,134852162,-1786037158,1272979264,1066228510,-1612395887,1271469209,-1903481060,-171114422,-1227077310,-40741220,-124272817,992879588,-553679726,-1004952398,1897144665,1268009866,2145370986,293048386,462809178,1718054312,-66392501,1397544263,-1141394143,-1341452907,1123503849,-1265969326,1084163189,1033519830,676356785,-1213674065,1237991337,-830666365,136431188,-1267236384,-280719159,1684185970,-1027856136,-970117450,115550378,1329620528,-477301964,814646007,569946343,1071458952,-1668092062,-1381665986,-404854876,1153532692,-1152292423,702832769,1867753907,1963467049,1673668953,1348560056,1087316020,630073198,577989653,1272560466,-176387270,-1892240877,59383267,-1520047478,1147934561,-705635195,2079201150,-1393144446,-732849253,1573691260,-170261018,1436969067,-1972798342,499478778,281824669,-1866076723,-1984642635,-1461425643,817826601,-1322417839,-1873563156,-1545371696,1028248585,-1516872438,-1948001299,-1842883104,11809843,-1066828573,2021327326,2131837550,-474250939,-1746187255,771453681,-852709102,-1091001481,-1332207043,-275029298,257841784,1193068557,-131781940,1923580631,742658736,801284294,705471355,2023987158,-329953569,1757834391,1072383335,1127517202,1944508800,-971557719,-1508517740,487402164,-366416198,-757498103,1351664051,-1482113655,-2059023941,1931879486,-1537923596,751907195,-1750802589,-1276813915,-97829631,1719221215,-298816859,-589150629,1928819656,-1362334650,1167920173,933459124,-1030613030,692366134,-93739744,1329863010,194493311,1542521435,371401769,-2001115530,1012555983,-543841465,883913067,468767470,1410259371,-746558627,-299126643,-507437497,913846565,1465391534,-1375428322,27917729,-597012769,1312193991,-955762696,1162727463,782002614,1984915678,908904692,-1768774300,-1312304488,1470518271,-740756775,1777103944,-240779070,263200429,-587365448,168103163,-313160147,-862227464,1656141820,-349176681,-1719081847,701801945,-1330698834,1092022193,1835231355,602401903,-713628413,-939435860,1461822364,-1106743386,-1986849644,1878369300,1342280722,1755902509,1998179546,440743340,-1968727481,-1603966489,354812621,-1441533949,1715048572,1823455156,-818350521,1663899708,1829037318,1732875975,473791554,1991655134,-453350081,-1145647694,603905119,-1245701400,-1900391173,2043458077,-10086339,393839286,1063546986,1822085938,-1896544214,1363929582,-2075503938,-484581749,1377228488,-1342044921,473604174,-115019920,1576339129,-520031488,-1492001421,-1421584008,453458722,368672630,-1822849279,1495165854,1087741876,2001119364,-1762766717,261511842,-543063805,-664669495,1261545320,884055619,970209268,1627659133,-733262866,-90777847,86002953,1986942285,890891569,1478692312,1424989937,-546697713,-383121822,-1324648627,-42786015,922198379,-1030540493,1661981121,-967393328,869908906,-483411719,851763585,-444482521,-1719481259,-583364692,1991869331,787205935,1428557024,1409545688,-1304769991,1530453618,-7378186,-2086894249,-1539968062,191862975,279356753,1640879869,2075582976,1053952958,-1120333920,-401287146,1920189191,-885795530,-653870835,-1476168440,-406122360,-572829764,684743825,1084565408,-2017635931,2103426720,174311954,-594135316,-520969594,-384916307,-1098485112,1664894615,2051818286,487265029,-1232879482,-699222368,-2101834294,-23769276,1789686115,1484489612,514492650,606483826,-766252745,-299962854,-1615340744,-1740544388,-1200142617,-2017299450,-346161843,2079298181,1599159161,594192345,-1575263406,1395473548,371604356,-968790656,-1627566474,-1833887404,2143468665,1456055700,560586764,26398963,439419088,638678492,739163744,-2042228563,1961183542,1951879952,-2141096829,1697336050,-1276004539,-519159843,-229493358,614800454,1833969752,1898962285,57424246,200112717,402511566,1018804159,-1691613547,-1873915612,-844406090,1027181076,1725504777,1136088536,-2000967338,374640840,-648977908,142206465,1069505107,-2078848667,-1756067239,-2072498875,1560004923,-1155099596,1275202744,-1663834021,-1903290472,1105098263,522197764,410676278,-221027398,844687455,2069742526,1137062123,-642223251,1272698051,-1887052422,1031003794,-850684682,1013312664,-986623038,-1247403063,-1801676987,1928781813,1866011320,-1370564182,-1589510346,-80782273,-225633008,1348638665,-858069511,-1253067397,149365204,-1388481784,624092383,222638408,-192255063,-981866146,-1278897481,-1552508694,490113291,-123756946,1034901850,-1826339691,1112502280,1280277532,-495430958,1794617425,-1831747062,-1028175856,1037271844,-1356156040,-1877005026,1570946747,-1427516958,-574553086,-1045511929,-386303352,1114974146,-1803992834,-528957897,1184244307,-1405153246,1733794281,-1379813305,806165406,-2022799021,-74917280,-619899261,335043100,1536634748,-2085960526,363413808,29060903,-500044420,-799741009,245814169,1760210538,-1656144274,-1530196766,-629208488,924805646,1275005796,745360238,-412639203,245143676,1051118417,1381519017,1938420591,768944695,1119745162,-1753727362,-1199949869,-1387411697,871418818,-581102202,-1187668276,924040081,1921950328,453667342,247599701,-651968819,1123946250,-1459845085,422814524,-1685315809,-941851627,-177994182,-689842683,1275142970,-81967908,-185492029,-730395887,2044798876,589943870,-1768301124,-1440841519,-2013472745,-2090365391,-100150912,1978030377,-1606061931,1250208828,1140598862,-1832357827,1971812512,1337146429,-1080195436,1845149599,-124312563,-1730283484,1999575840,-1974435920,2045211185,-1012159133,-1673932690,-1986443182,-1716197570,1060103382,547756828,1110910851,-1628460973,1372035392,-359806995,-516601169,1767457843,870713920,270673435,1576721508,1389720256,-915306575,879636813,814222566,813856610,355524298,-1119129568,-1062815206,-1512238979,2141784341,-427065389,620014008,1842533132,-60652697,-1415395122,-276342016,1789386365,-957098808,-1365057054,-1093296136,874274024,312052415,-1181346004,853559914,-1976725056,1810823521,-1429716844,-536928046,-1599821135,149183459,-1475493080,1370376111,1705653685,1972540248,-424409035,1445546753,-1061914377,-714650343,1978287560,2080509943,1369357206,-1988171707,-279946571,-1969619780,2124346510,797690826,-70495971,-1227323755,-84225154,1392696749,1269682849,738535885,-1814916603,-507771661,-1689159529,-1248635830,-2099010107,560247795,-280351381,1315410440,50648512,367818572,-1494220601,250054966,-294430103,-1244885906,-1060580292,558161505,-1703593458,785408950,-1475925961,-1039313996,1781444472,1815156654,791697481,-1565603904,-68455316,-863342060,-2131149544,1072701092,1164317254,1923172924,633867748,158959375,1141429406,503071798,-1290635129,1092530998,180567101,1694212087,1381902190,348812421,-367735190,-1113347653,-304879380,747423162,-575533401,730587143,-1394619863,-341076608,1789543739,1403733695);
/*FRC*/Random.twister.import_mti(11); void (makeScript(14));
/*FRC*/count=171; tryItOut("var tzbfwi = new ArrayBuffer(8); var tzbfwi_0 = new Uint32Array(tzbfwi); var tzbfwi_1 = new Uint8Array(tzbfwi); tzbfwi_1[0] = 1; h1.valueOf = (function(stdlib, foreign, heap){ \"use asm\";   var NaN = stdlib.NaN;\n  var acos = stdlib.Math.acos;\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    {\n      d0 = (NaN);\n    }\n    d1 = (d1);\n    d0 = (+(0.0/0.0));\n    d0 = (+acos(((d1))));\n    return +((Float32ArrayView[4096]));\n  }\n  return f; });print(tzbfwi_1[1]);");
/*FRC*/Random.twister.import_mti(143); void (makeScript(14));
/*FRC*/count=172; tryItOut("a1 = new Array;");
/*FRC*/Random.twister.import_mti(153); void (makeScript(14));
/*FRC*/count=173; tryItOut("");
/*FRC*/Random.twister.import_mti(160); void (makeScript(14));
/*FRC*/count=174; tryItOut("\"use strict\"; e1 = new Set;");
/*FRC*/Random.twister.import_mti(170); void (makeScript(14));
/*FRC*/count=175; tryItOut("print(g1.t0);");
/*FRC*/Random.twister.import_mti(182); void (makeScript(14));
/*FRC*/count=176; tryItOut("\"use strict\"; testMathyFunction(mathy0, [-0x0ffffffff, -Number.MIN_VALUE, -Number.MAX_VALUE, 0, -0x100000000, -0x080000000, Number.MIN_VALUE, 1/0, -0x07fffffff, 0x080000000, 42, Number.MAX_VALUE, 0x100000001, 0x100000000, 0x080000001, -1/0, 0x0ffffffff, Math.PI, 0x07fffffff, 0/0, -0, -0x080000001, 1, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(214); void (makeScript(14));
/*FRC*/count=177; tryItOut("for([a, e] = \"\u03a0\" in ((void version(170)))) const o0.a2 = arguments;");
/*FRC*/Random.twister.import_mti(288); void (makeScript(14));
/*FRC*/count=178; tryItOut("\"use strict\"; /*infloop*/M:for(a = new RegExp(\"\\\\1(?=^)\", \"gy\").setMinutes(\"\\u9A5C\"); 140737488355328 |= 2; Object.prototype.__lookupSetter__.prototype) {i0.next();s0.valueOf = (function() { try { g2.toString = (function() { for (var v of s0) { try { t2 = new Float64Array(t2); } catch(e0) { } /*RXUB*/var r = r2; var s = s2; print(s.match(r));  } return o0.v0; }); } catch(e0) { } try { /*MXX2*/g2.Uint16Array.prototype = g0; } catch(e1) { } try { Array.prototype.reverse.apply(a0, []); } catch(e2) { } a2.splice(NaN, a); return t0; }); }");
/*FRC*/Random.twister.import_mta(-1321258439,2016847535,-1180802847,739167898,-74311224,927147688,-2064062427,-536204848,698409012,-699501994,529661139,777424067,1129318028,-210506719,430225744,639935029,-609572481,-56080244,-834036369,-1649836826,2017451299,191376927,477316714,4796775,-449014123,-2034159133,-1819947442,1082210943,56178353,318539455,-852808514,200965621,217132687,1607880281,529579216,856567728,1804603599,-2088790506,204183349,-699543019,-617382691,-1447672450,359785429,1186285389,-245167037,851709101,1523237473,-1880031122,901451376,1046520165,1376434957,1980209451,-960569598,-1741505419,-148989859,1168374929,374362564,237187731,-1476109283,-1438961525,-1722396639,1282266226,741675510,-693649964,1676068776,848851988,-2105955242,1013024729,-740257307,-101921842,-1720599188,1953786065,-622426912,1433827456,-1783043117,1651173020,-303346572,618573591,-685056221,438587089,2009833209,2036443568,-2140812252,1264105034,2141097989,-65982947,291874487,-2073103641,1213684833,188597886,-462880183,-82596943,1073534486,46245550,251492152,-340966899,228528265,-1452678958,100116193,-1462660748,-822771682,-1759125102,293813267,-1146791147,34611695,-2095326610,-793657680,117344848,2068947851,-1244269623,-923928256,2030213129,-1974977314,-2131667106,-112545695,-1669221509,-1009606018,-231613856,-685912037,564775873,-2084393701,492693032,1772561052,1547644949,62540966,-679695462,1419080614,-553647166,1771391896,-395389744,1709734761,1359385214,124371558,70828057,-1979944786,-1275380092,109007879,-1239048414,-2121124376,2114215835,-501298986,-519554596,-1499356666,-1813129314,-1267734670,-1122675465,1615566868,1418620603,-1564704502,247461372,-1695412434,958545333,488028821,1245007156,684724317,613618433,155128979,-1507709764,1513751996,811821074,1487403578,1984458008,-1678120432,1837501447,257469522,-1434644419,1712181759,-1832027800,770323632,-1439431287,1318736630,-1025115463,1841960247,724304658,-169843662,1922107315,7982921,-1861976538,1700907299,2137919752,-1588860355,1368042424,296719863,-1246784159,1337069573,-683834250,460803206,-758793540,1735911877,1215138882,-966179821,-22292494,-335966403,581000866,21777304,-769333482,-1952664105,-1950831069,-897992440,640231036,1669763009,-1732839972,1101799058,-1612867079,-2003130348,-21347259,-818624566,-2075067814,1345990997,938463310,1524576004,2073417140,1088950555,-2094501205,482239205,-1309615442,-790001214,1727489602,-685359841,-1697370955,1248714948,274180015,-1511794371,-1330109510,-1419603270,-1756192686,-2009737190,985357524,-1559402380,-2059582224,40870332,-104239990,-650086937,-1125939401,1816083811,953141878,856374094,-2003656273,-994157448,1457008178,-709749571,-1253606499,1093912346,931435521,2134757916,-589608152,812690113,-1599197446,1315171697,-1230265013,-344372038,435793757,944640785,-68256711,1220199162,1673724116,-611796569,-914821818,2107442250,2011119220,2123859141,-488639253,810673204,-1458505034,-1688190736,366536961,321810248,-250190260,1596379509,-1797690849,1911956153,1279911655,1562171162,-1766453837,-1827429504,-1394740679,-1079157833,-2064768853,2058996350,361730262,1311799546,-1319307760,-631053423,-1949915918,-1508752905,902067120,-2101418526,-837957581,-188304005,-449364757,52695878,-1590082720,-1650884436,-1507063725,514055779,1671504049,-167976774,-1502372532,2065294108,279268624,-1071691635,-663694896,-75848574,81756142,-141941284,-1781256040,1370217209,-765853485,-1319611061,1586007440,154941004,-246655641,1060601621,-152284662,-430012560,1307673491,-1023456592,1262455583,1486521708,215695352,-838476468,1375993775,827013854,488702515,2072253572,-684873517,933555382,-455583336,992012600,366137811,-317581000,1579529417,1096873197,2126682716,-1523388253,1150598262,84772497,1880314254,-1888868883,1208276742,1592017287,1608762985,-739968738,-1796344437,771033833,1724416415,935355105,1093479436,1621580760,1070026396,-1356824134,-2074227503,1209350077,-1963351688,-1985786000,-1080638093,53792476,-456880349,-80058072,53585394,50218399,-531209777,-376683920,1059985666,-523563958,935682822,-265022981,1975838133,-1876788392,-1148316303,1069430458,1465216151,548830543,-331604397,908982299,1521105117,-1840492013,-1870104976,-124402696,930083432,1169237733,818326737,1174894691,2074548206,709298114,1038873506,-428488469,-350711643,-394144398,1220828490,-1091047237,-830697085,1356542182,1635872542,-2348516,-412283190,1537145127,-1556160180,-32493320,-23223468,-807991423,-736450645,-481996379,-1553730785,1313520676,1185320541,-496132713,-65550233,1975656783,-1291387911,438601232,-1534896946,1621095814,-1576687012,-1298962263,-286635838,798821923,-381550243,-350826425,64126872,1395333687,1356684807,1192305620,-1767382969,595951977,-1064869083,-579135689,2068135158,-154287009,-1651699242,-893788803,-1126755344,-2127144795,-2099290060,974869491,-251351411,-896841466,-651368611,23443617,369314326,178503527,1526390418,-1605059539,-540812475,-720386071,2064268200,-514518734,-711007023,-1693596834,-1587236718,-2102224594,1440427286,-567222476,-1394623680,590139453,-194796008,-633780482,-1238657794,982049490,1730478620,-1022756153,699261997,-1250533516,-187390003,2017908095,-610136340,-854592718,-583103598,-1578320124,2055670443,1147175715,1788093609,227383916,1948143611,2122622788,1831126736,370416066,-466434350,23930820,653634770,2039297631,1581673288,853608878,-227693365,-1286380199,-1707558875,156719584,-522385699,1928057530,-967105396,353494191,730523884,-776592480,-1527973606,1388627473,948482497,1745894909,-1059757838,-1098617370,88013605,-1855724590,-372867481,141609144,1022672521,-100692175,711535132,951589830,593256126,1216024909,-211765893,511301379,304784156,-482611610,-565520677,377080170,950329014,1525094549,-1705099452,1802114625,1709622029,-1764953882,-1146024315,729281798,751204392,207196267,-399446084,-709601048,-61380903,692275068,-2012459927,-1194472465,1306756473,-866227232,163100263,-2077516779,1115717488,792777483,451167096,-851535710,-744207901,1013100941,-1941125081,103995818,-1098030021,-421370311,1415904601,1968096819,-1405690299,-1286032092,-2062545766,1201430595,-1853478570,-921582788,-172673630,1121217187,1998805986,1294629441,1534091491,2137698461,-1868627460,501129354,-1859266319,-1794548330,-680293146,1849881788,-337061340,20430889,2026610251,519877729,1036905632,78986854,750549155,107322410,1430426258,-376263855,-382630939,-594336931,954352774,1424793491,-1528475880,1414809302,-629465583,1823282118,316638786,-336050877,-1518534214,928773993,-1176166607,1449758450,21468854,16434789,-962147377,-1155949002,-67065169,2086549108,-1448900564,-1738834147,-1597027557,-1806587852,-1830202530,-400905126,1210465332,-1412529549,6671440,1392020182,-1487561625,492207323,-1552264922,-1075038238,1898556563,-996135529,916216109,-1716025607,328194579,601030657,-1000084311,-2146356778,199273577,-773605784,-795347619,1344477406,-895225688,1635091161,-1710632732);
/*FRC*/Random.twister.import_mti(134); void (makeScript(14));
/*FRC*/count=179; tryItOut("mathy3 = (function(x, y) { \"use asm\"; return Math.fround((((( + ( ~ ( + (( ! ( + x)) >>> 0)))) >>> 0) | ((Math.max(x, (( ~ x) >>> 0)) ^ x) ? Number.MIN_VALUE : Math.fround(Math.cos(Math.fround((( ~ (x | 0)) | 0)))))) ? Math.fround(Math.fround(((( + x) ? y : ( + Math.fround(( + y)))) * x))) : Math.fround(((Math.min((-0x080000001 == /*MARR*/[new Number(1.5), new String(''), new Number(1.5), new Number(1.5),  'A' , new Number(1.5),  'A' ,  'A' , (1/0),  'A' , new Number(1.5), new String(''), (1/0),  'A' , new Number(1.5), new String(''), (1/0), new String(''), new String(''), (1/0), new Number(1.5), new Number(1.5), (1/0), new Number(1.5), new Number(1.5), new String(''), new Number(1.5), new String(''), new Number(1.5),  'A' , (1/0), new Number(1.5), (1/0), (1/0), new String(''),  'A' , new Number(1.5), (1/0), new Number(1.5), new String(''),  'A' , (1/0), new String(''),  'A' , new Number(1.5), new Number(1.5), new String(''), new String(''), new Number(1.5), new String(''), new Number(1.5), new String(''), new Number(1.5), new Number(1.5), (1/0),  'A' , new Number(1.5),  'A' , (1/0), new Number(1.5), (1/0), new Number(1.5), (1/0), new String(''), new Number(1.5), new Number(1.5)]), y) + ( + ( ! ( + Math.atan2(Math.fround(-0x080000001), x))))) | 0)))); }); testMathyFunction(mathy3, [1, Number.MAX_VALUE, 0x07fffffff, 0/0, -Number.MAX_VALUE, -Number.MIN_VALUE, -0x080000000, Math.PI, -0x100000000, 42, 0x100000001, 0x100000000, -0x0ffffffff, 0, -0, 0x080000001, -1/0, 0x080000000, 0x0ffffffff, Number.MIN_VALUE, -0x080000001, 0x100000001, 1/0, -0x07fffffff]); ");
/*FRC*/Random.twister.import_mti(612); void (makeScript(14));
/*FRC*/count=180; tryItOut("print(x)\nprint(new RegExp(\"\\\\3\", \"yi\"));");
/*FRC*/Random.twister.import_mta(1177354948,2077732951,-1466252263,-232912027,-1883556609,2016515432,-748230665,446352446,1837217654,883807009,1916026585,1416241673,330808630,1459018424,781825291,-733867546,-598634982,1287591617,-1606486351,-896905107,1979623053,-449875086,-1694607372,-121773662,-1967819223,248759539,1877986727,-1155421458,1358008485,-68255384,-1481592109,1774052295,728663589,-982416619,-1521482712,771153949,-2090816705,-452581194,1126889304,1041909687,-1913141790,-757728876,-1403954833,-1424324199,-1701812197,339307970,-667198606,-1882046255,-46998587,1364786283,2006292635,-1202541345,1953848951,1614112223,-1375575167,-719783978,851874518,-1373221140,947293826,261807665,-803373369,747792937,1282858230,-1292199661,820108839,-1270183585,871159038,-927060654,-1487639797,-2118701692,1040977701,-1935671948,272381675,-676051435,463558631,997735510,-1082546001,-870746102,-1187098265,-1258723743,-662564342,23052758,1129969655,-548745598,-112833383,-480548310,1767007591,1315994550,-1616487654,-1570019301,73163738,756398513,-952371237,309288755,-2024474315,242293563,-1336407693,-1992841794,752908667,258670066,-1958244293,1867334448,-2115705232,1231242234,-397700272,1613240288,2139880353,1566567979,-1450482905,1557063526,-959077787,1298075426,-1290264876,-69976084,-983381378,-2100117671,-1487782933,-453013064,-243758199,-1039204665,-722416560,1605994255,-755897384,-1760438603,-1878041784,1094536405,54950345,2022913447,-603486764,1044960643,-724291610,720873039,320380090,-1137445960,337517115,376009020,313162230,-991787295,-1534402462,508540768,1784700822,-1636939359,-1705860564,1716863540,1271845507,1981224352,230876089,-138664260,322635687,2016919972,1773105216,618354865,-1609913856,-889399118,449253385,1418131882,-425450500,801728637,1863512043,1635354460,1616139887,1922450837,2136258336,443741859,488366128,2131166646,-569036718,951578340,1744463935,1719331154,-1062087736,-250540507,677113129,1044712575,-855880795,-1622029487,1572908417,36372255,-695825567,1430152860,1344737626,-986454601,658126199,-1434059253,-236594134,555136389,1002265372,21692798,-2125740133,-1922570817,-961481528,-1164052045,1343699431,6087593,-273369020,1742697474,550784353,425913072,-88663278,814778402,-1399574027,-192436355,68104061,-1403520944,-1368150327,-866852458,1112387965,-1544740189,-1130204096,809102169,-1632584708,110137264,-374004455,334998586,778318970,-238861800,1626630450,-1857507759,268519980,-450379340,-1698443423,1511713321,-1999903616,93475203,-2130009983,628059860,-950763890,1470871294,961090095,-374532921,-822428384,2048114387,-1085741524,1014090137,117254405,1946430161,-1444138199,275452133,1057371408,-1603926089,-1789012055,1308644998,1451813689,-472946924,1657975637,1628312334,-623032560,-1949835030,1735528712,-280825431,759793363,261803902,-1439938000,196259034,-1967117692,-465732439,-1621952565,-646041354,1381137661,-1926368104,1830209983,-42404302,964599110,-825193657,920841449,1253949692,110195857,2070683015,1102183492,1302526188,339135029,-1273101418,-2039817276,-1850570062,1085540626,1005373121,-1977131807,180977060,-1298832204,1399677450,2023431895,1513857686,-1862556241,-121175310,-188451020,959052915,-241923337,863409317,-956218237,233100629,-1570359133,2116886129,2119450025,-441087216,1617300949,-1649796266,-762387678,1132527275,-2066916356,-1455742350,-1148440835,1713112486,2031584161,-2068006335,-2030870458,1222839492,81581783,421955696,1847297822,1204284625,2128893166,1070941132,-668122321,444409567,-1317008736,-1093009854,1593580875,672211308,729294413,-533128835,-496627653,-1611570086,-1712772355,-1919286479,1000980744,1999769376,1023856958,-690494297,-55796986,-1217533204,-1082578623,1374902777,1598642894,-199609553,1058385936,839192752,1690783649,1483210828,693986465,90345160,1294822407,-326060303,1370289475,1755319872,1318281640,1938819622,-493328191,-459054660,1079648321,-983454971,1278705666,1829597257,1145150569,1201135217,-1101994047,-1650597190,-1792924979,-1454826638,1802466486,-1955656022,353399680,1624783619,1241415101,584056787,-1627375774,93870144,-39488155,1651597882,1520563142,-980567695,-721992544,-1029874437,-654202282,-807620757,1138854413,-2095735183,812907164,367366588,2137825669,467306925,1268203013,-1597235993,1767207517,-209215459,826053036,-987710655,-1912766511,336903382,385116976,-114819166,-465301827,1970698307,1338487353,-503634596,1258383745,-1824676749,2011535860,-1078342732,-1906319473,-692527562,-851382411,609637288,1474855425,988148627,-1200551698,2126050677,-1304612240,-1278299870,1169696916,1781036671,-1195092884,-2119555351,806641835,-67346537,1983784223,1334702165,550393294,707996724,-76233089,-527825885,-1321534347,-868472402,-175885058,-400671478,-1607865411,218243158,1295128153,251290373,-1170133098,-128224996,-230919768,2011181636,-1925492340,-2042058661,40355130,-639119165,-978900952,1191892851,227617467,1978419829,1049281395,-1488528717,120201061,-1820640743,-322063483,548127413,383779587,-683331890,178827872,-913135593,1870645000,-1374499045,1929425780,264939087,1838835186,1414902096,-1296507208,-1816212407,1233207261,130329488,-240153776,474351295,-1754871320,1288169801,1035605907,1501678729,-822525314,-978614229,-1437900020,-307225993,1334691231,1679064675,-1039563732,-442559310,-1118469246,1819811305,-581201216,1845433649,484448535,266494400,613521790,-1817137581,1141053971,1609823672,225107003,385470477,608945961,342040802,-564829068,-352395314,-619315407,507116857,416005233,-151279802,-31394376,-323923355,1841842325,1265958086,1871302363,-1898239443,2086208862,76311886,-1130485414,802171814,1610475690,-1362532009,1120095573,-978442578,-92059404,1188036337,-237874308,-983990265,-821811263,-1163366846,790952958,1937405974,13355767,1323008860,-707342552,1966228954,560315533,903739222,-1949751486,1303026632,2006485365,-300451960,1310204353,-282227389,-82668723,-1132865911,2068170786,-1596172874,-1791498456,-1614698494,2019997640,-525115836,1253428589,1484462271,-821045278,521448246,-2058096109,-224827787,949484672,-1266311544,-617877729,-1999112821,1865074304,-1144370519,-579247593,1664068099,-2057758822,1596006550,233346545,-983280464,-314160810,1127290617,64842306,432325072,1505548551,296094347,1703178120,1972444891,1505547971,333854207,1838968158,-254921622,-1609567950,-614758680,-227131231,1408658032,-403275058,1302441917,1496400751,1331269046,154341521,-1222966992,-1726969530,-11960556,2139084741,778813186,-207429210,-939102686,-1796071013,970371251,-67658833,-1446363171,244658669,2116334841,1618735192,-796152240,-1735120149,-1030948743,-493830712,-2088079777,1990239788,-1887109993,216181795,-1629515590,-1947601580,-1391657861,-1412451983,-821134357,-1020823463,420462583,-1622675632,-1462816969,174563646,341911028,1095793265,-770845623,834747476,-1527782897,368043671,85741326,-1355941283,1459418075,635377993,-860498551,-2076888526,668352086,-995435256,-1565321166,-1640412159,351475862);
/*FRC*/Random.twister.import_mti(27); void (makeScript(14));
/*FRC*/count=181; tryItOut("mathy4 = (function(x, y) { return ( + ( + (x ? (mathy2((Math.expm1((Math.fround(mathy1(Math.fround(-1/0), Number.MAX_VALUE)) >>> 0)) >>> 0), x) ** (((Math.log2(y) | 0) ? y : ((Math.imul(Math.fround((Math.fround(0x100000001) << Math.fround(x))), (Math.fround((( + x) , Math.fround(0x0ffffffff))) >>> 0)) >>> 0) | 0)) | 0)) : Math.sqrt(( + -0x0ffffffff))))); }); testMathyFunction(mathy4, [-0x080000000, 0x0ffffffff, 0x080000001, -0x0ffffffff, 0x080000000, 0, 42, -1/0, -Number.MIN_VALUE, 0x100000001, -0x07fffffff, -0x100000000, Number.MIN_VALUE, Math.PI, -0x080000001, 0/0, Number.MAX_VALUE, -0, -Number.MAX_VALUE, 0x100000000, 1, 1/0, 0x07fffffff, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(250); void (makeScript(14));
/*FRC*/count=182; tryItOut("v0 = r1.unicode;");
/*FRC*/Random.twister.import_mti(264); void (makeScript(14));
/*FRC*/count=183; tryItOut("\"use strict\"; p1 = t0[o0.v1];");
/*FRC*/Random.twister.import_mti(284); void (makeScript(14));
/*FRC*/count=184; tryItOut("testMathyFunction(mathy2, [0.1, /0/, null, objectEmulatingUndefined(), '0', '/0/', [], (new Boolean(true)), ({valueOf:function(){return '0';}}), -0, '\\0', 1, (function(){return 0;}), 0, true, (new Boolean(false)), '', ({valueOf:function(){return 0;}}), (new Number(0)), undefined, (new Number(-0)), false, ({toString:function(){return '0';}}), (new String('')), [0], NaN]); ");
/*FRC*/Random.twister.import_mti(318); void (makeScript(14));
/*FRC*/count=185; tryItOut("a2.reverse();");
/*FRC*/Random.twister.import_mti(330); void (makeScript(14));
/*FRC*/count=186; tryItOut("t1 = t0.subarray(17);function x(eval, ...z) { yield -13 } /*ADP-2*/Object.defineProperty(a2, 2, { configurable: true, enumerable: false, get: Map.prototype.values.bind(e2), set: (function() { for (var j=0;j<30;++j) { f0(j%4==0); } }) });");
/*FRC*/Random.twister.import_mti(447); void (makeScript(14));
/*FRC*/count=187; tryItOut("{v1 = Object.prototype.isPrototypeOf.call(m1, t0); }");
/*FRC*/Random.twister.import_mti(477); void (makeScript(14));
/*FRC*/count=188; tryItOut("a1.forEach(s0, v0, f2);");
/*FRC*/Random.twister.import_mti(556); void (makeScript(14));
/*FRC*/count=189; tryItOut("mathy0 = (function(x, y) { return ( ~ ((Math.sqrt(( + ( + (Math.fround(( - x)) >>> y)))) || Math.min(y, (Math.fround(Math.log10(Math.fround(x))) >>> 0))) || Math.fround(( + Math.fround(Math.trunc(((((y | 0) & (1 | 0)) | 0) | 0))))))); }); ");
/*FRC*/Random.twister.import_mta(458924864,52039004,918514523,328582613,1481546012,-413974235,2007537036,-1900948651,-35214278,305110467,15929593,1281619471,1095965475,914374198,-1416942054,1581033382,78341160,-14029160,-1279235908,-1019627945,413439373,-1240732283,-1663765262,1835595710,308116232,1534812914,-175183747,1364824880,821387490,-2015166481,-483646919,922672219,1139474505,-1600883780,-1206652267,360953036,-187974656,1676852886,1608664007,-1017328935,778054585,-1028573485,-1184252314,-355842143,-312841134,725070556,1301981870,190607032,-787542945,-1272807535,1382336638,-375739004,1619044903,-512342505,-996231952,711195167,416907577,832643763,-896504169,62836996,1560234370,1874481574,-2018420794,819451036,-1620315441,-829381737,1754857440,-149384503,425351755,150467891,-1008437615,2069743782,1600293282,-1688871245,2041077832,1153294500,-2087475017,2025987054,-1358160378,-1323656251,760280538,-1539026381,541525633,-1053159443,-501408954,-1448961921,2026621027,45740470,-557525793,1717958340,-1679733531,1690316614,985776264,1102525300,-1073102725,-1712388073,-1302301287,827881946,-352047972,-245157801,1020419422,1870380515,-362116144,1216138486,1956144830,441672789,-1737003924,-768546330,-1062331676,-123654984,-1560174273,-485537890,992338183,-1822214589,490237812,94735083,-925391202,-829419803,-1955219542,1790160095,-1206915068,-55690556,-1481499041,1768034601,-867442205,325233529,-387206716,1503349663,674999702,1685206578,593424059,-224469744,-1570754731,-1472039456,-1410798296,-1671242797,616061869,706988025,-1349220876,2139480742,-834368336,-2111404300,1816005164,968633229,-913118043,-1484898941,-1889825322,197057555,-1261693607,1543339680,816797230,-847497449,106022490,1362243393,1969380419,1052410895,193482833,1137151612,1938675031,-1426067030,-1182313531,1712751255,-2053652219,1795792784,1242733568,1991659242,1337836173,-949360226,-1007468349,-2141775658,987476261,1062405866,-706978672,1484789699,-1694369078,-1361468048,-683392282,-1149704706,-578538882,-1325202965,1155022096,-1242923615,-1574833960,-1957687373,25527359,-1993569259,963850252,1650116797,1987149277,1842170761,-1167918849,-1854350220,1236103003,-1353812279,-1318894984,1811032999,-1891951833,1274751909,-674449274,-2086665210,2106913755,1357304373,-1155071917,1711199946,-1457255648,990449720,-1846436231,-1055468176,1775987268,88079552,1462329900,-327002078,-1678376364,653469289,-1676786941,1704317454,-1800361735,-416456885,1685000961,-239710682,951062594,-2142191502,-65558968,1562852759,-268128424,-1114410170,2133246953,-1628005752,-1362872352,1371682251,-141251997,1206577674,543364406,-304172591,767260386,1880622449,-1022188178,527436401,-984070901,-1829421016,1367348597,432532313,1876628524,-322269859,-810621153,-1632711884,-2032515550,1797102857,413279630,1400407876,1789235201,122379792,513946783,-252773057,-1169187397,-430658600,-346167404,319663256,812131863,-1402416055,-1641543515,-458441674,-1411169872,917666475,1185701608,-979220144,1742894277,246994331,-463451483,712666019,-255506838,-1368456784,1676605317,767602215,-1885160185,1293161200,-247021245,1261337124,-2144592767,-976906861,-865364132,1441519352,1442872166,1656470179,-197301163,1800575795,-1022547063,-428385508,-1337947181,260766536,-691410053,961109188,-62233057,-2120005163,-103964830,1880959962,-264291655,-1048388753,801135007,-1683214845,-396632992,-601157305,-538243749,-1058400108,481533324,879412658,-1115037699,442316373,514790532,523578614,-556749301,1459816974,2106899407,1611386163,1574243991,682781349,1919772274,391507740,-841739481,-755337142,240091481,368436698,1177205072,-273378019,180452938,-175684605,1124102875,1115951325,885868693,752791471,-1181888299,1530711001,-1185493731,-939674524,-885890626,1808076267,-728421218,782738352,-507641606,-2068060197,1008983524,-320428790,838176203,-274852278,-145224714,590426901,417471489,1093292283,1192648601,-1045832098,-957605422,2003017480,-1449003874,1858827003,391494338,-73266129,819379083,1458132192,-148284859,-387443051,19323070,371155753,336434405,725106716,1760553945,139366297,247288763,-485198509,971565715,105228412,-1040566993,-1525532274,1503189737,2007234575,-1824742412,-319428585,1359984254,-1777224141,1503249182,-1164777081,-665021971,-1732225614,-1636703010,1393956999,-127966461,-1401169312,-520769599,-1292016035,1518697798,1857910404,-2001071250,-184945213,1179376708,-1288321390,1476365176,-1207858119,-1618215668,-453185987,1410296305,712285173,178994711,704449301,715385958,-881015151,1563176859,-996496570,-387688070,637806938,435615297,-1102849298,1385016344,-1064893259,769266433,-614165924,-594247608,1712740154,2027216275,516959007,2016767674,-2009554498,-917478882,-878618617,536687906,1176985126,226114446,1750926197,500532571,1622434832,751528635,-1036437369,504287208,-1346788378,-517606198,-792560412,1961725390,185138768,-5101658,-924235858,1333579207,498848562,-1403454481,1184103534,-182386723,2078196196,779095758,-166223265,-636167871,2112113010,1032922278,-1951906356,-752424251,-1987774750,595497150,1240199440,-1260633568,-1214752580,-2129272016,173835602,1141424066,414503070,989135441,638063126,-1888272118,1153900152,-1430758166,-500898764,1764242658,77964531,-166242627,-1860876740,1204290227,-290839287,-329170579,-663713821,-2077678814,907013358,-1131430653,-35836843,12218096,216725536,1614682825,1095147629,-911388412,1960851798,-2122714047,-1153075876,-1504099272,-1325221217,-1848388655,1600196343,-525978392,-742313969,-18900237,418516505,-504837002,193781296,264246720,1577652696,805971065,499283242,797350016,-1846695510,452724515,-558353130,-985498032,2017790708,-418216252,-1322634458,-1350264481,1860784856,-1725969793,179818346,906406930,-1801496970,-540383465,690871927,686242534,-64844561,1137737257,1978665094,-1689406850,-64418621,382232126,1392234204,-158768981,-775620192,892491901,215622937,455035612,-1572214454,-796642737,1445490200,2072646067,-1044741095,704944503,-486718739,-1442836362,-111720966,411656085,-432672231,-2142253354,27193559,854631905,-2031083230,-902388474,-1170116505,1444408769,-100958067,-43352060,1149645469,-2145122986,-1791130515,-684364197,899896944,-1173083266,891551156,540856135,207293577,-890798525,-1953170727,1681755094,2128919040,-79779893,-497345999,381729157,-1313212317,-384424785,-602911381,-2061660110,34524332,273051979,1120410270,77460942,-2056051562,1520947299,194911034,-1106419244,542851823,1616265353,-1871674291,180897258,-1004266800,1044505769,-1809463677,-1694172207,694907500,1324547126,823861394,1046131713,-1051774641,-747205377,430421309,-796718999,1978466477,2111749063,-426701731,153772065,-2079404155,1788671852,-1787317618,-1993575131,1806151431,964331315,1588347350,1535021431,480908161,-1331528835,1643912202,684592969,-963544332,-664184481,731914391,-1359610393,1852564016,1082896239,-782089923,-772854625,-895448457,-1491932440,1679733440,-496219509,-2115265113,-227016590,-1842959188);
/*FRC*/Random.twister.import_mti(83); void (makeScript(14));
/*FRC*/count=190; tryItOut("/*MXX3*/this.g1.DataView.prototype.getFloat32 = g1.DataView.prototype.getFloat32;");
/*FRC*/Random.twister.import_mti(96); void (makeScript(14));
/*FRC*/count=191; tryItOut("mathy2 = (function(x, y) { \"use asm\"; return Math.tan(Math.fround((Math.atan((( + (( + y) - ( + ( ! y)))) >>> 0)) >>> 0))); }); testMathyFunction(mathy2, [1, 0x100000001, -0x080000001, -0x100000000, -1/0, 0x100000001, -0x0ffffffff, Math.PI, 0x0ffffffff, 1/0, 0x080000001, -Number.MIN_VALUE, 0x07fffffff, 0x080000000, 0/0, Number.MAX_VALUE, -0x080000000, -0, 0x100000000, -Number.MAX_VALUE, Number.MIN_VALUE, -0x07fffffff, 0, 42]); ");
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=192; tryItOut("t0[({valueOf: function() { delete o1.v2[\"hypot\"];return 11; }})] = Math.imul([1,,], ((function sum_indexing(qfjzrl, jwmsqf) { ; return qfjzrl.length == jwmsqf ? 0 : qfjzrl[jwmsqf] + sum_indexing(qfjzrl, jwmsqf + 1); })(/*MARR*/[ /x/g , objectEmulatingUndefined(),  /x/g ,  /x/g , objectEmulatingUndefined(), /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi,  /x/g , new Boolean(true), objectEmulatingUndefined(),  /x/g , objectEmulatingUndefined(),  /x/g ,  /x/g , new Boolean(true), /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi, objectEmulatingUndefined(),  /x/g , objectEmulatingUndefined(), new Boolean(true),  /x/g ,  /x/g , objectEmulatingUndefined(),  /x/g ,  /x/g , /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi, objectEmulatingUndefined(),  /x/g , new Boolean(true), /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi, /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi,  /x/g , /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi, new Boolean(true), /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi, /(\\u791b|(?:.)|.*[^]|\\B*|(?=$\\b|[^]+?))/yi, objectEmulatingUndefined()], 0)));");
/*FRC*/Random.twister.import_mta(-445519725,-698848125,-1162425920,646738585,-2091115688,1366795936,1428987876,601848198,344315256,1905615321,-1724030334,-1604859121,-1526479371,1195916053,-1348905114,797942037,-454007536,-2055949290,-1635631922,-1383192694,-1663210238,912200899,-24323487,-1065427046,-434312834,-1137511997,780900286,352357375,-224080803,-179624808,-1564230942,-1808377280,-764214951,-619739523,-445089408,-616551734,-1589959761,-1038869262,-1280431133,831160997,1891200024,331879156,-237617091,-621425210,319300864,-739399030,2121332408,-1610663874,890121544,-1289306754,1227431856,-723926678,572249624,-1318473539,1170062130,-1239752451,-936128362,144491956,-163106754,-1351989263,1031908737,1204818977,1088371408,-1404548119,-666307838,-79741190,-431757373,2132656400,2136452722,-774717579,2030780576,-643427732,95885754,991703703,-856369829,1956652521,-1542354412,-1817236447,-141946413,-366491666,1995945363,-913220241,-1249947895,288397162,-1935713139,750781930,1975304589,924004081,-931688898,849433237,-1016943300,-1934412907,2142934861,1504338954,104727771,1055330528,1079915252,-731194824,-365562172,1370045295,-256081930,88039825,2046563153,365603807,97299295,382185749,-1214234139,-1525320926,68525224,798680708,-1062366999,1797183747,-28280538,-679215675,-1855079744,309165917,1793057243,-1703887678,-981681977,887145188,-2106224243,-1996373543,-1740001075,610333264,747694496,582860508,-1489052724,-493570464,-469900615,-1114267649,898976657,-752357975,-160902214,-2056239909,-2129546450,-1327592262,1302583098,1036966797,-1656769602,-1927129554,-1203501440,1855347331,1675843328,1032718427,-886481207,1969054474,1512570868,1230511989,-675295433,1312835286,1179462617,-1102945495,-183003678,597531560,325613237,1274672812,339775822,450523402,542901601,-436742534,-430375651,1361325598,-32492271,1093977558,1170185589,1172895314,-1041240322,-298735301,-242060280,762531042,-1011233250,-1342980486,-146376814,499551278,363120678,1866454205,-657500567,879085916,-904451312,-597590180,-1549349664,826718437,1288713035,-754829526,1505422341,1660452015,1006637570,959772128,-2038077577,-892653418,2041007784,-1014713485,1340127988,-1949880893,-178909135,1310078245,-1994906208,1446569860,-1488908706,-286742253,896865856,-301480038,-410461717,-1648463691,908273435,-1467287344,1042754414,798172245,506850785,-1690908053,1472016411,1697975907,216029471,1332135937,1500170640,1034230084,-2064253622,-1414228432,-373725650,-1917377346,-896996786,-652658228,-1819960108,-630317785,-551410684,350474585,-1654791704,-1307315357,665962169,410266670,1165559708,-1821535805,-24097129,66135189,-2099524639,890013647,-1490693058,580514008,-382899429,1422622608,-761037210,-1737171600,-2132650140,439330368,-903622260,-571531297,1091066321,-1869840443,534992737,1389798078,-1009028974,1883587566,491601795,-358291012,1714085395,-2029371497,-1127353644,603920694,453673147,74429908,-1453729690,-1333143208,420587328,-2106782501,-523945894,1498915166,-1344382793,-612238955,-537028614,-910892280,-1916646114,-67637731,1543851334,-525788956,-109760186,-1801061066,-693010324,-801660625,791919484,1143872950,-610509887,1857914497,508530035,1797641827,-465749774,1321800997,-598611329,-56010569,1403269,-223117390,-252910197,2137354450,585509583,-1700452238,118707453,-566197263,672883229,-1209803600,1299756466,1905981322,-872346901,973726505,349514147,-364362542,-1986375944,1883655922,1040313371,2040545233,-972305644,52406483,2058424941,727560629,-2050141268,-1033964007,-1170035844,-247382777,957064475,2088768624,-439480400,-1584011458,1397790439,623597683,-1875514703,87985617,2007091430,314408822,-370965538,1943169891,-1973909863,-63812636,-514031892,-2140177138,1966697255,-767987398,1241466120,777980647,2026452828,-260927340,-1337222607,-1606314028,-504320192,1352649978,631403640,292807712,1390450071,1342506520,-1921164730,955649694,-1445646602,-79709148,1607548372,943723503,-858736770,-1399585107,1179451560,580784035,-1763625585,-1760995732,1046173244,-1225015323,393692560,304073091,-1522357068,-522415607,-1595855714,57256636,631299160,2109260566,1840549565,-636027576,1862735004,1055753058,-679202862,1404677646,-1507173471,-1086843896,-599773936,713149014,973317941,3239371,1878897009,1548780762,-1149613520,-1318612976,1290247226,-919707042,629265803,-1961212994,1719309660,-95601498,-1572827160,647656279,1550980379,-1441780926,1798955000,-1101559154,-972715229,817285689,599868255,1796954182,-1875854981,16072213,-745994454,793899387,371760383,-1100675155,-1889309711,911542047,778524050,630646087,1783170479,-1772137126,1330263425,1380602406,1245699709,602388833,1554748870,1170078197,-946281556,726174715,1998532895,-1163359584,1829083702,-1884997529,-81864991,816020524,-558720229,-1172827198,1444145926,-1466974689,-1973247674,1186061694,-1058290014,1146219913,706173821,569179698,-12424772,-1458837977,1810425850,-2084269001,741291574,-84801887,1078622646,-1815217619,163051456,498842193,-213581817,-733972451,-590537942,1662933353,-1632868778,-1902285733,806758865,-2026651400,-371204291,1731933985,1566207623,1736267901,-1623721588,2061664096,284503454,-2057147548,1466894579,-1300628917,1401651906,-1648791190,-812573386,1889560039,-788627858,2047796962,-1267596261,622576101,685763825,52217920,-880047694,-1733543617,-1255111605,-2088351766,1982873598,-1269136840,1393494357,1123841681,-42327236,628733995,2120065944,1210458791,-974759868,2025357649,1177677564,692239668,1921328131,111298044,-1943660915,-1624621428,-1639475571,-669147878,-424645660,214953981,-183053176,1271267590,-396374991,755204616,-1141250115,-1273970876,-1407900587,482015262,482018341,358000561,432615405,-1949771629,780022230,-12685573,1149681182,716990763,825689939,342291702,1437239578,135031360,1167946897,792785904,2109284044,1282893794,-146971489,-1973984617,-553541536,-1897322157,-285256231,-1047613563,724375436,-442531749,-2124647458,760739582,-913064927,-234155905,-774492552,-1827945681,2142505518,-1342370440,-2125465498,-974474041,463027885,976374099,-231133802,1544615832,-1196942180,399329679,73439143,770037477,-564071966,-1876432870,-693567688,-2060202220,1215091790,-186018207,692295097,55464421,1662483839,1562865938,1554886845,120041164,-313840582,-311908814,-965069024,-1432233151,1906760826,1573402809,1463878078,-1551997095,295217836,-1266025470,806873455,1353609072,1388090451,2032534184,1027146499,-1227645412,840609164,-151868081,-1452220138,-1984653941,-1903817787,-2140847581,-1316725699,1114372280,-1011028134,421668903,-1367986260,-1856852145,-1414471173,1441880596,889714760,296228981,-526935499,-2109263516,-671549977,-1339486606,1092168277,441020202,878074405,169518495,-1084044974,597666023,-1871825693,1761072500,-1109626039,-1151718828,1892639694,-493746678,2132294048,1313232448,2109681796,-1030368746,-1105489082,-1664306461,983815167,-1752845364,102091074,-238421348,1419061815,-196312959,1944933710,302374849,-146481960,766889909);
/*FRC*/Random.twister.import_mti(344); void (makeScript(14));
/*FRC*/count=193; tryItOut("e1.has(b2);");
/*FRC*/Random.twister.import_mti(357); void (makeScript(14));
/*FRC*/count=194; tryItOut("mathy1 = (function(x, y) { return Math.imul(Math.fround(Math.fround(Math.pow(((( ~ (x | 0)) | 0) | 0), mathy0(Math.fround((x === Math.min(( + y), (( ! (x | 0)) | 0)))), (((y > (x | 0)) | 0) | Math.asin(x)))))), Math.fround(Math.pow(Math.sqrt(Math.fround(Math.max(y, Math.fround(y)))), ( + Math.trunc(( + Math.fround(Math.imul(Math.fround(y), Math.fround(Math.sqrt(( ~ 0x07fffffff))))))))))); }); testMathyFunction(mathy1, [Number.MAX_VALUE, 0x0ffffffff, 42, -0, -0x07fffffff, -0x080000001, 0x100000000, 0x080000000, 0/0, -Number.MIN_VALUE, Number.MIN_VALUE, 0x080000001, 1, 0x100000001, -0x0ffffffff, -0x080000000, 1/0, 0, -1/0, -0x100000000, -Number.MAX_VALUE, 0x100000001, 0x07fffffff, Math.PI]); ");
/*FRC*/Random.twister.import_mta(-1030599513,2124031935,-1588211243,-1851869993,1750003013,-115390248,1052659128,476739139,531040158,-2080515408,-9022905,-437385289,-549828590,2105912860,1485845775,2100430601,284166189,92192794,1965075108,314909511,-2019900597,1641430595,1266148406,68240800,2109293214,977293801,472763719,1531183120,1241968224,-1881979286,-268222750,-1507665035,1543556606,-119628410,722585627,159311786,626779120,-355926445,-534704193,-954277968,-1594888355,-905218245,-289508652,1705714870,-754658332,1064436458,-1674418638,1395712356,69788910,-1747873825,-30631768,-1916735450,-492686872,-59589681,211332346,1410318746,-1015176670,-755218654,-1450793978,-1701705576,-576855374,-1084726044,-170988981,2094093343,-117574631,-1119466547,-839443773,1814058491,744005135,-1290486426,1551068369,-1843006797,-24621194,184606313,-968662066,987179515,-742134129,692466052,-306193720,1464069725,1044797826,-1249433435,-54343283,-867690548,345797732,1588392741,-1476878452,1516659847,-2004993230,-464056614,-1477859260,-1595665019,93818673,-393046351,433180044,-1408692233,-1256238192,-346198545,700559474,-554806241,-682037270,1356885503,-668212170,1940990273,-1083643299,958494608,-426113323,-299898367,192383836,-1511687026,-103711761,652284798,2030147246,1724443830,788554122,-387842516,662976330,-897455121,1310102916,-845614845,-712754573,-1867441112,2104527576,1810983452,1563015308,-459142791,-81970777,938992099,1227576947,758989006,1897261454,1343848017,1043272425,-1043027383,1966649507,-1354606660,1977929062,-548800601,-711268296,597035374,1103007974,-1329703962,1109721141,-1492836074,1084029142,-550841748,-508278531,176114648,1894607588,-1102138732,-1412671570,-1528087789,-1041685042,1175745725,-1597033406,1112317161,-108744988,-1603983402,833993432,-1993100498,901080605,-89318678,1740491815,1453085279,-811803365,-426917793,1152499459,158328446,191995592,1990059697,-192432028,1782288741,-93668843,986025340,-29805071,-405565512,588572166,405968523,-656203342,1674169340,928596450,370165868,-1607102946,2069089560,672255147,-1350281924,1592885832,1509354558,2085073004,-760903432,697845289,-868172671,-921011158,-693878641,-273960392,-467957531,-379895130,-1000836408,1582688804,463708533,759860455,-560298481,-573756134,2105272832,937088143,-813850284,-432605311,734934374,801767358,-2112271588,1224749540,-530536976,-251821409,1359631436,-599302476,-1134465565,-921241093,1316970728,-782360173,1666301029,-1656396166,492299357,7552717,477906764,-1048803406,-102093780,-306936101,138551076,1923101096,-2081861093,18926825,-1911653679,569338445,-1495590761,-538671749,204860801,-760143140,1390958357,-1886668673,-160696543,834650276,417406653,807785513,903995627,-226361558,-1934870893,-2087998342,1365497892,1220374300,1788501119,2083775575,-367563392,252847415,-164621679,-1043747068,341841674,-567489807,1687080544,-1542127201,1219240397,-1600491222,1738087355,-1858023144,1429831645,-2040320260,1858507579,869700517,-820960096,-1362032961,-1470147493,-2124913817,-1123650233,254185112,-527892847,425861119,1869620440,1724051351,-1447738090,-1344798979,1449438423,304400464,-1699226980,-124413324,-245154213,747666799,514253286,2110657564,77588143,-2046698691,347088977,56880246,1887850913,-1340809228,393609314,-636967716,-513957922,-1461365954,986658312,-1427601034,1098939100,-821256414,1428244416,267586450,-1760638477,1365579517,1807195162,-224706198,490978312,1828736019,1486024804,1089372105,377150898,-1500825354,-86390222,-1144108325,1307793760,-636025630,-1794199652,-265361894,-180915043,1661962839,-2000451573,2006907328,-1898989597,-503066028,489714077,1041224049,1266424953,788088845,-1467622592,864458694,1560080145,272486157,-2107268015,1614340013,923996402,-1646512956,956040744,1992415380,167362830,243731147,1037130678,-531100612,-1745040034,-494704413,1218984103,-1847331252,-1049711352,-315702726,311956530,-287714508,2067915571,736148208,-1740916237,-1078962451,-615285653,1723460600,775438992,-764669572,1972678689,1372847703,1738139385,1176809063,630479657,-1627577607,-951417324,491415781,-294885529,-1649070782,900106875,-1200365401,1801383743,-1225390741,1806292466,1440956892,516783212,-351381569,801453291,1039875369,1864322473,1748776656,-1116597926,452941025,-1611177735,-2064509191,-92413758,-1933667599,1183329459,-947157831,916294611,-1663444181,2024630089,-209332738,825053439,373564217,-243537018,-1211223182,2087692564,1605778758,1803179639,-474504535,-671238556,695453658,-1324869466,-1643600510,106570901,-1578370900,543877931,-1647080944,203013142,1887201205,-692296012,-2036237265,-488186455,-787644335,1376942735,1769194717,173291519,15485347,1805472890,-873462305,-1725333725,2059510793,232560905,-1677079330,-402385034,1185917076,1178827108,1406527967,-1728283207,505611455,397359070,878569295,1781918432,993544831,275303264,1335101648,1022640665,2022334260,-1494607484,-176429117,-1134402961,747577386,-1915944421,-643166945,1911820623,-1871105868,-215749649,-170887114,254086630,-1036369474,8332165,-93074352,5495194,-489212821,-989481420,694111994,247148591,-209762975,697695362,-1536545499,760984029,-1946050437,-1149967427,1546973088,-398248220,389248269,432078739,1709600204,-1290508549,-26955578,2145827213,-1927130445,-1504810845,-2076347292,-1959944730,727285642,120322984,-264622948,-6483646,1313249542,-9126246,-539722816,-519955651,-644517908,-2031735363,-1376202310,-2088597932,1933067553,822801350,1449680163,427332965,559123581,-436344772,-1558189523,-578210995,1999639418,-1143797469,-656050748,-1576937377,-1240907883,-1651090178,897088378,-1446982302,-404211431,948096048,-976793648,-2016874631,106628618,-1347779937,1475656185,1322459744,-1829739092,-61003926,246193364,-1395351632,280370545,-1197087007,1730553945,-1899474798,827175827,2023663180,1031708234,-949648626,-458026370,1151308613,-1202741823,-1701178140,-18467022,1331507837,-1046138228,-324765646,-1950702342,-1703913898,-842076864,316295428,1332508376,4817914,-309905650,1917785983,2127060548,-2100110320,603660972,-968684884,1205910404,1796611350,2060267312,1279259302,-1060078586,483034716,-866758551,-2043299725,-1102312846,-207180942,-741112748,-2038806931,-2045353015,-2066153657,1601124471,647518480,-187566264,50709565,-78951027,-451978503,-1894733141,1566660683,-2125577603,1179344797,664118711,559630420,-1079248154,1389728277,1950038515,376948498,-637050362,-1272736516,-1326845366,-1168006209,-1500309207,-173338675,1090627645,2121975852,-1167687625,1197972565,-73275812,-984152406,-1540008103,-1660731787,224480243,1554469443,-1270290484,935223100,-2039931226,-272719159,-1233592226,1680935095,948059630,995130730,-145027793,-1454939710,-1553026722,-992154766,1790351062,1827200708,1919427009,1167887566,1582714540,397421056,-1705952646,606129315,-1094874638,-603988134,756222316,1223150545,1296758101,-2071896040,242841245,1872494319,-612132906,-1972142247,-1591275584,770067797,1051311235,261072382);
/*FRC*/Random.twister.import_mti(6); void (makeScript(14));
/*FRC*/count=195; tryItOut("Array.prototype.sort.call(a0, f0, g0.i1);");
/*FRC*/Random.twister.import_mti(30); void (makeScript(14));
/*FRC*/count=196; tryItOut("mathy0 = (function(x, y) { return Math.max(( + ((Math.atan2((( + Math.imul(( + y), x)) >>> 0), (( ! 0x080000001) >>> 0)) >>> 0) >>> ((x >> ( + ( ~ ((x !== y) - Math.max((x | 0), Math.fround((y + (x >>> 0)))))))) | 0))), Math.max(Math.atan(((1 | ((Math.cos(y) | 0) | 0)) | 0)), Math.atan2((y | 0), ( + Math.max((x >>> 0), (Math.expm1((Math.exp((0x07fffffff | 0)) | 0)) >>> 0)))))); }); testMathyFunction(mathy0, [-0x07fffffff, 0x100000001, 0x0ffffffff, 0x080000001, -0, Math.PI, 0x100000001, -0x080000001, 42, 0x07fffffff, 0x100000000, 0x080000000, -1/0, -0x0ffffffff, Number.MIN_VALUE, 0/0, 1, Number.MAX_VALUE, -0x100000000, -Number.MAX_VALUE, -0x080000000, -Number.MIN_VALUE, 1/0, 0]); ");
/*FRC*/Random.twister.import_mti(325); void (makeScript(14));
/*FRC*/count=197; tryItOut("mathy1 = (function(x, y) { return ( - Math.fround(Math.imul(( + mathy0(mathy0(x, ( + Math.hypot(( + x), ( + y)))), ((((((x >>> 0) == (Math.atan2((x | 0), (y | 0)) >>> 0)) >>> 0) >>> 0) << (x >>> 0)) >>> 0))), ( + (( + (Math.fround(0/0) === x)) >>> mathy0(Math.fround((Math.asinh(x) > (Math.cos(( + -Number.MAX_VALUE)) | 0))), 0x100000001)))))); }); testMathyFunction(mathy1, [0x100000000, Number.MIN_VALUE, -0x100000000, -0x07fffffff, 1, -Number.MAX_VALUE, Math.PI, 42, -Number.MIN_VALUE, 0, -0x0ffffffff, 0x100000001, -0, 1/0, -0x080000000, 0x080000001, -1/0, 0x07fffffff, Number.MAX_VALUE, -0x080000001, 0x080000000, 0/0, 0x100000001, 0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(588); void (makeScript(14));
/*FRC*/count=198; tryItOut("m2.set(v2, m1);");
/*FRC*/Random.twister.import_mti(605); void (makeScript(14));
/*FRC*/count=199; tryItOut("\"use strict\"; t0 = new Int32Array(v2);");
/*FRC*/Random.twister.import_mti(620); void (makeScript(14));
/*FRC*/count=200; tryItOut("mathy4 = (function(x, y) { return (( ! mathy0(Math.hypot(-Number.MIN_VALUE, ( ! Math.fround(-0x07fffffff))), ( + Math.atan2((Math.atan((y | 0)) | 0), Math.min(( - 0x100000000), Math.exp(x)))))) != (mathy3(( + Math.fround(Math.tanh(( ! ( + -0x080000000))))), ( + Math.fround(Math.min(Math.fround(((Math.pow(y, Math.fround(y)) % (( ! ( + (y ? y : Math.fround(x)))) >>> 0)) | 0)), Math.fround(((Math.log1p((( + (( + y) <= ( + y))) | 0)) | 0) >= (x % y))))))) >>> 0)); }); testMathyFunction(mathy4, [42, -0x080000001, 0x07fffffff, 0x100000001, 0/0, Number.MAX_VALUE, -0x080000000, Number.MIN_VALUE, 1/0, 1, -0x07fffffff, -1/0, 0x100000000, Math.PI, 0x080000001, -Number.MAX_VALUE, 0x0ffffffff, 0x080000000, 0x100000001, 0, -0x100000000, -0x0ffffffff, -Number.MIN_VALUE, -0]); ");
/*FRC*/Random.twister.import_mta(-1708520940,-703306381,-1161970493,244868308,-344845816,1982652678,641045336,-1847908787,128240077,1196974416,-879405009,-229724647,1926982424,-985870867,1898829295,399624422,-530989660,-341977853,-1032299533,-206170713,-474507263,626506680,1771435690,-181623664,486663944,-304090507,545167617,-1190478866,-269634493,1051604965,-1940216831,1037405984,-1533856902,-761048979,319833099,653268663,-967236330,-769622657,1944560824,-2031399007,-1057404581,265643614,-734032929,-587624911,-472161510,580260659,-464162135,-608272536,-485202305,-277906208,-1245473796,-2071895870,-401284898,-2072635453,712557384,-607314623,1764620811,-1240177048,-2008239496,1200734115,1360462429,277905563,-822745518,18638838,-353360668,1945279941,1416395167,-753921928,-238458793,-536710214,-1982155243,446843511,1872541968,-582680287,-1148871249,1036719403,-219320223,-1293772544,2038749719,880431947,-2065637595,391379077,-1715922268,67674932,1227519959,-869780474,356096417,-576032139,-187847984,-32766568,1257782345,-1459932570,-1672804287,444644325,-1770741183,2078025141,157019668,-134270444,1811327389,480011407,1252757251,-185563169,1121057824,817232484,-1056512202,-1623340849,1204259005,-1571554121,712012407,539443960,-726112570,987483485,-1664158524,1081379132,2057559414,-1053655543,1075143234,1772606998,319838190,-478367593,-251827979,429813045,-1154423396,534343637,-741928401,-638012858,93766432,1496189336,1375810338,-2134546170,731781907,2029588121,-155199610,573692418,-83536916,-246889911,752622938,-1492936356,1125207475,1874017963,404138505,362612683,1640859636,512107055,-1387809498,-903236083,-2088980672,2140540662,1949385820,791348455,-2025660432,-1608192287,-423097123,-600716728,2115716824,-2104599296,-1550567271,-1962321608,-2099011590,1170497560,-1181846990,-1246138693,-1797340960,1243031834,-380922675,1778387,-507991610,-1968675377,-14214196,-1156735409,-1436669968,-2086123422,2084146922,432001217,557602249,632376048,-2090451832,-159976737,-976785150,-1421520197,-1318484087,-1232478682,-2013075135,-872284489,1773724338,-719437549,1805445706,-981320086,-335166762,1777452178,573296874,1777104358,-1359101221,-1013104944,-591713391,-221986827,-1919771731,-648932020,-253204270,-1221604542,-1927967054,-1715627102,-671443774,562785222,-480101416,-2136646199,957334647,1703730718,1150298432,987125342,662731000,2066172906,1285940869,-1868683608,482859380,-795818674,802716581,-51555005,1814105845,14402976,-1204241378,1119008879,-2075304705,-2120659943,1360223043,-780447951,1269738092,-1552280896,1323859105,1663396456,-1869092509,579672049,-62268014,-791715526,1321820242,788289699,-1222313467,1431844047,276030806,704940874,1346695788,-264794332,-1809217460,-652656079,885227157,-2084729394,-1693976139,-941019249,-1995299496,-830163874,-1071181232,-1015003828,1338985442,1083854467,-214257557,1509122532,1290358997,123245585,-1064620263,-1260516369,946302319,464530567,-714860154,-982994328,1011582013,-217817675,-1587290639,244939483,-1024295764,228264627,460457037,-1538775978,-1948590940,837602697,-335123196,1232970091,-71967125,2065751133,1992001142,-519666442,-1993475443,1446121074,980693683,-1502776221,-1186523493,-1230260106,-589890517,-887136484,-1010817940,-817622935,-1604845575,-218477794,944348660,2036870129,-1547772009,-1514421816,-1117394754,-1666256210,2053273369,1209726593,-1210735935,-1132717978,-1354448627,56052672,-2026285299,1086945954,2061208911,728254963,991592631,549885343,255184365,1517284268,-1320890081,-774501357,-1152131387,-641324895,-1265937834,854544196,1265121527,1959034293,-2014720193,-306454879,-441233765,2019166014,544193029,-302386694,-1607804308,-991978534,-525178241,454211523,-2017247949,1343271023,117942840,-1361881164,-1176865586,614361109,2086224364,-271021428,1042755034,42320254,1587291367,1250941800,-1966335834,-1470339348,-1795458406,467774664,-2083789293,-2039871000,1355966252,-1940124666,-76468589,-969453737,1290657376,-1018799991,-1383135374,559793886,-1747367858,44569517,-1690573226,1197381746,-1997170271,1092596736,2055888642,-1163248391,-995698090,-1799567074,-1047675449,1456225448,-699993559,-453195912,-232659601,791938892,-1073914636,-1450373202,1894822080,-658579620,-507433395,12054971,245627114,-757721163,-1031224603,-1435739017,343760291,2028307258,-164124327,1572103773,-1081555298,54722737,2013207437,62561706,-1354159519,-796295630,-1048233357,1938950277,-1307209716,-1530920331,-986035515,-2054866605,790483846,-722800799,1916865523,1971697188,1026901667,-865964471,743657546,-718107308,1652070385,-1082113407,-259719123,691300932,-413151763,-1277105030,1030070040,-1710056771,897823730,1102352487,-170692686,-1152039708,1545789403,302870763,369176990,953370954,1830962094,-2087289406,-1387258121,-1816150888,-1810991120,1039649410,214635937,31696450,710733865,1615100064,-1245730631,-1113894505,1840823214,1666854184,-1113274483,465917794,1750222632,-1357863493,1470605120,1249921377,1333720220,-637153803,488631611,1679660719,-532512632,-1026523131,85999260,-1521452000,1487826180,1814740331,-1856855044,-473071482,-1040660006,440916956,-42974560,807467788,1984424368,2004122591,527042827,-775880528,-363947614,-650211883,1635364797,-1025315057,-1075035044,1656210570,1890913414,-350498769,1071820328,-1420105965,1234307392,-652655737,-2105548420,-591488355,-854505078,-130415586,-1135686163,686557025,2132808142,-1664053877,-1334125403,539223843,-584895984,-1770567740,-182499131,-655098080,53826916,1733855176,1356613637,-1242893604,-1040537173,1776588856,-111848542,-1184205551,-1988477187,1996537519,1816164518,1238823857,2133320694,-1229303623,1570621402,290026040,660716101,1415061918,1005208469,-905938552,-655360030,-930685296,-2130385581,-1338039219,-930796605,-1686064575,-579530556,311663115,1243501510,1254906634,-174169257,-102239006,1160214743,-1123970894,-2046230449,-818126463,1743358931,-11728602,89652467,-928597672,1121595783,-1885972405,1963292633,-1025243792,233918857,473758703,1644522865,481082331,551703650,972445290,-1170157364,-1910440387,-792763877,-357675117,-85479945,-679800940,124010959,1980673903,1390118118,-1484656324,-1545691761,1519441520,-1572312104,2135539516,-1809144765,-909961146,518654003,984738628,-1065977665,1903956439,1130142951,1030705564,1985545589,494363351,-820939338,-1562794906,408983158,-1484211141,-123150737,-732018973,1512210242,-1793464875,1480466233,938366652,282742593,-1362602224,-595868778,145137161,1214541062,825234136,636123246,-1251624287,-59032417,699725750,-605636565,-1442202784,1610846456,1344929061,-1864910953,1464700039,-163271170,1622027492,-512421017,-946711291,2053843109,-1699623448,-1109653460,-905450274,-111871539,1350882087,2073540525,-297139109,-874284521,95157163,-288706498,1107136114,578402268,562618300,-653393227,-811573288,1635027705,186882394,354053271,-1598149137,-523291798,2428139,17019069,-1446309860,-1384132094,-2104958582,213414209,-1860780653,-1133928720,877264530,-1559768950,-936423473);
/*FRC*/Random.twister.import_mti(341); void (makeScript(14));
/*FRC*/count=201; tryItOut("(-27);");
/*FRC*/Random.twister.import_mti(368); void (makeScript(14));
/*FRC*/count=202; tryItOut("mathy2 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Int32ArrayView = new stdlib.Int32Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var i2 = 0;\n    var i3 = 0;\n    switch (((((-562949953421313.0) > (-4503599627370497.0))-((0xf863bd47) ? (0xfacdb955) : (0xffffffff)))|0)) {\n    }\n    {\n      i3 = (i3);\n    }\n    d0 = (134217729.0);\n    (Int32ArrayView[0]) = (((d0) == (+(0xaa618eb1)))+(i3)-(17));\n    return +((( \"\" ) ? (new (x)(/((\\B+?.)){1,8193}[]\\D*?^|[^]|(?![\\0-\\x42]|(?:^)\\3)/gim, x)\n) : (((d1)) - ((d1)))));\n    return +((-((((d1)) % (((d1) + (x)))))));\n  }\n  return f; })(this, {ff: (objectEmulatingUndefined).call}, new ArrayBuffer(4096)); testMathyFunction(mathy2, [-0x07fffffff, 0, -0x100000000, 0x07fffffff, -0x080000001, -0, 0/0, Math.PI, 0x0ffffffff, 0x100000001, -Number.MIN_VALUE, -0x080000000, 0x080000001, -0x0ffffffff, -1/0, 1/0, 0x080000000, 42, Number.MAX_VALUE, 1, 0x100000001, -Number.MAX_VALUE, Number.MIN_VALUE, 0x100000000]); ");
/*FRC*/Random.twister.import_mta(-140421747,1201185026,437402088,1965755804,750491410,-2137821146,-1197587357,-280075453,-630355473,1623678251,381822733,2082498522,983750705,1415286560,-2111502199,-1739857887,-187503930,1718135957,-911207972,-392711924,-522814719,1702483304,639683150,-1730469283,-630459184,1927334792,-1050152399,1066359052,1191856335,-794075812,-1938398473,-1320238745,-691013419,-1083557319,342825994,323593706,264374355,-1811441628,1079639722,808703873,-340246347,1016873560,-493690345,2136497294,1148189522,1489248701,-1826990235,-1782556640,-2066344397,155935970,-640383606,-1173376386,575445906,-828953490,-214708424,-1957323738,-75404751,-1264909763,454041643,1246093612,1157886107,-1980202676,1559508651,-1819037096,559963893,549483583,501752827,-1231127608,722515249,-794030167,1698528787,1891722455,-1700237559,-699706797,90070171,424984622,-719758689,-319994071,-618749480,-1194279654,2133829141,-774795885,60747253,-175868671,-1617606109,679115565,-323222196,-439145689,2060967574,-407387003,-594350385,866781614,607560486,1641368811,-157873038,761374853,904240282,922065751,1521400881,-1653794531,1155169262,-888938260,-1393876450,-1433211233,-329907154,-211234697,941871989,-205249567,-846223898,415732064,565753512,1827342557,1901241162,-1196622062,931570834,-1803206846,-1263502853,-723816990,1176768767,221410554,497223569,-546405582,-1531368335,-1760049485,-215090331,-98918165,-1579799863,-873582429,-602061510,367078089,1639029037,328846175,-1232670540,-1289565060,-168937872,-231828536,-426440222,-109695038,-361695075,-1114039985,-1208414511,810262332,1079266282,-195447736,846293031,366600001,1292898443,2004636641,916609122,-1804996947,-1056629262,-841927207,-2030269304,-611845201,-1640781352,486264049,-285682833,206622841,1321353691,-359718140,-879507267,-937251964,1069618434,-1459120640,-512741926,1414095112,1502868291,1932625640,-1117918013,-1491559835,1058288953,-1624523963,560092246,-1404913989,-1714134411,332518801,2375432,-784866792,402562760,1058607895,-1202518901,-938540701,-1626376905,-1397805345,-39290016,2091591367,-1278920506,-1019495397,-1951870312,-1064344349,791882998,1860875454,2103497683,-2066506457,640897443,1038581566,2075460870,-1395069292,1117103097,1192545194,1030794945,-1205411810,-146279562,1701703501,1944331581,-787464862,-1727157940,-25694290,-265187835,1258651868,-1747007679,-383842792,1202405136,-1552395995,372486758,338212152,-358819284,1349114404,-1612173926,-354412918,-30945403,-934095567,1741429623,-1503800028,-563085074,-1873947954,-797239687,-1697787509,-1612522129,499721472,762354091,262113499,82460213,501840066,1279585164,1441409520,-771439096,414670607,-1201097304,-54050619,-195208728,1732972624,-1030420582,200191488,480157602,1665579833,-1104382778,1040970894,-667602830,981482000,-1598885646,231428152,-198500552,1338286227,180444812,265158451,613152931,-494600595,1913040345,2025925181,102886677,1853664649,1444868977,-861256841,-867653084,-736419501,-678426029,-369605766,-2080488763,-1197088668,-976772245,381611732,-1054838013,1309106402,393532261,1925410095,-1918554734,-1191181362,855230434,-939413887,-521389785,-934625956,-706488266,1305246848,-9879759,-1767440741,1778773496,315105698,1872540176,893626832,1007753916,-2045856160,-973575778,-1379617038,1505647185,2101337694,1624199784,-1056275708,-2032134937,1361818079,-2025466669,-931840413,1412090369,1341729468,1209191737,796692599,1993822662,-1160000611,-336818694,1952176739,-1473031443,-1768701667,-656583857,1558418536,1698819561,316276312,1185288449,-416573184,-1101748317,-1415321405,-441229423,-1440079123,-637850067,1682488125,-1864243497,1896545814,452283901,1745800490,934920273,1655811715,1112389326,1834039473,144892869,1747486927,-822627349,-559759554,813485546,-1823132440,597038220,2111557732,1740643375,165048408,2132475294,1631469455,481805721,-352187925,-276057271,1790381148,599775693,2052994971,366667068,-1927739961,-525544559,2013094528,-242238366,-1795475092,633771065,-173251892,-1418780894,998916732,-1138478599,1124597356,-2066104579,-822573538,94855723,1547411380,1755086813,-1953155436,-713383635,144119421,-1325403824,96392935,-457881639,-1668716941,2143391484,850823660,-527660066,1692755248,851178618,-834590816,-853820298,2004254113,-1831267206,1674887599,-158090075,-708392556,-492783966,-807104100,-481895429,-15612489,1859326364,-285841602,1737397796,-690579802,1064840663,1601416428,521301810,1958054549,-279380125,1423407966,-49232226,-822343414,-944734708,-1825828599,-2027168690,276224265,981890454,2003267789,-1200992027,1856788501,-823133463,968119288,1437571089,2099530918,355424414,-1516458928,-1965141952,1529697925,-1294855744,-515069338,359653379,-1391782694,1631273803,-460962595,1478215432,-1425015092,-1618482935,-332035736,947580024,1266118268,-1812586725,1168398426,-1813781705,-2117864520,-471106453,-1280850759,-1325376289,-7744782,-582964529,1949545777,-186856538,1529038407,-179425908,-938335132,1554645856,-76966926,-154886244,1706055586,-1710220336,1454812549,2046802414,484676302,-855981073,-1307084205,-386054875,1804640193,126075780,1685211908,1743080767,-723308534,453333716,1284319366,935266992,1023131271,2033792538,-578476505,-1081660465,1108943684,-304241917,-1642528374,-2034866026,2091557915,-1456477821,1244987163,177904060,-1031805776,-1665166971,1735183157,480985212,2035331205,955624872,1526986923,272794699,-180974419,616388726,-948814161,-167596660,-1497621557,-1781209413,1580407133,859372118,-293683670,-956032355,-1947884939,476719034,1306015132,545934561,-123664174,-2102480016,-1058644701,2104858188,-1852701522,411209746,-984228774,1117978079,-393237476,-1921002315,-55141430,-537481725,1926675845,-2061207378,1207420445,1817011226,1650810817,-1903373131,37955409,1293415953,1961033663,481155247,-158818100,820919175,1356696344,1584304042,376962367,1223481664,585681537,-1499809017,-1725260754,-309073443,1240318322,1676273229,-1486478915,370348596,-209728637,-1373666350,1185196246,219077062,1132503614,-415315254,1582674086,-1635666338,-1878136638,1468700298,-1229965519,288145193,977958369,4545578,393312631,-33220988,313771850,1013673445,-577901159,1905288786,-742300724,1480834478,-1143423754,-256352952,-439797000,1682746819,-1196339027,-219201849,1115355687,1923035300,497149441,1394006364,360235274,-1630368699,677801687,-737817620,-646010131,621413019,-1620477914,-399355707,-1164493880,-692933617,-752711804,885719733,264388779,-2135462867,159329753,-1146364756,-1586733445,-467820284,-1805140688,687877287,1791946769,1914661652,-1962326203,-516478266,373747257,226700155,-1076208456,-989332842,370168487,471914514,1223619482,-1958916431,-1555075791,1275981517,2016901572,-1884681125,-569671518,1044133269,-1676945086,1120564719,-1103551953,724387462,4697382,-1745786222,1481646053,264482666,551406380,-1693563580,-1593972989,2042924258,1904747321,-1989942814,-507092725,-1905636762,-531386765,-933578818,1304300916,1429269182,-37063381);
/*FRC*/Random.twister.import_mti(199); void (makeScript(14));
/*FRC*/count=203; tryItOut("\"use strict\"; mathy0 = (function(x, y) { return (Math.min(((((Math.asin((y - -0x0ffffffff)) * ( ~ 0x100000000)) , ((Math.pow((x | 0), (Math.exp(x) >>> 0)) | 0) | 0)) | 0) | 0), (Math.hypot(Math.fround(Math.max((( - (Math.max((( + Math.min((y >>> 0), ( + ( + (( + y) == ( + 0x07fffffff)))))) >>> 0), Math.fround(y)) >>> 0)) >>> 0), x)), (Math.ceil(0x100000000) >>> 0)) | 0)) | 0); }); ");
/*FRC*/Random.twister.import_mti(414); void (makeScript(14));
/*FRC*/count=204; tryItOut("\"use strict\"; testMathyFunction(mathy0, [-0x080000000, -1/0, -Number.MAX_VALUE, -0x0ffffffff, -0x080000001, 0x100000001, 0x100000001, 0/0, 42, 1/0, 0x100000000, Number.MIN_VALUE, -0, -0x07fffffff, 0, 0x07fffffff, 0x080000001, -Number.MIN_VALUE, Math.PI, 0x0ffffffff, -0x100000000, 1, 0x080000000, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(446); void (makeScript(14));
/*FRC*/count=205; tryItOut("\"use strict\"; var gjfacg = new ArrayBuffer(16); var gjfacg_0 = new Float64Array(gjfacg); gjfacg_0[0] = -13; selectforgc(o1);");
/*FRC*/Random.twister.import_mti(479); void (makeScript(14));
/*FRC*/count=206; tryItOut("\"use strict\"; print(delete c.x);");
/*FRC*/Random.twister.import_mti(516); void (makeScript(14));
/*FRC*/count=207; tryItOut("print(x)\n");
/*FRC*/Random.twister.import_mti(537); void (makeScript(14));
/*FRC*/count=208; tryItOut("\"use strict\"; print( /x/ );");
/*FRC*/Random.twister.import_mti(550); void (makeScript(14));
/*FRC*/count=209; tryItOut("var jmsfbs = new ArrayBuffer(12); var jmsfbs_0 = new Int8Array(jmsfbs); print(jmsfbs_0[0]); jmsfbs_0[0] = 28; /*RXUB*/var r = this.r2; var s = \"\"; print(s.search(r)); t0 = new Uint8Array(b1, 11, 14);print(false);");
/*FRC*/Random.twister.import_mta(393861652,-497949801,1849884048,-347271913,-826953447,49802466,2105774199,1930799206,-115488957,-1460676913,1232552736,1010011170,1149345669,1458949746,-325512393,801566066,-1759991245,838291568,-774409002,1673387295,697416753,-1581091609,1948879767,2019170923,-730107618,-662697332,-1153308581,-493464656,-2091233182,1085565101,765090052,-904552243,-1916091457,-641625826,1275103919,218781633,-1950335062,-2084076738,850829222,500485210,-1580731426,1963027227,195009398,-689228273,-297146810,1707849441,-2098067340,-2016823130,-1077141117,-634462887,951553693,-885631463,1912421298,6708850,1497980125,674416168,1901218706,1014883823,1320316759,-1140159722,1619921826,-1869093195,-584390362,-759313039,-974806458,-1606177902,666141539,-1246110627,1826328876,1410409497,-479125008,2038506584,1815353468,1561458180,1879098380,447476755,-1521816496,1729481040,-1642612163,2048979536,-695419613,-999520679,-627426598,-298338202,-1774815774,639403757,517450209,1507243837,1839295538,21195316,-9887972,-2016430296,-137293833,141786223,566680247,-571026224,160947969,-1472870019,-630847027,1122464022,-585041756,-723836289,212310707,190747739,1898896458,-576992905,1707048309,610610988,-1528011604,-1650225183,1405857659,-413139034,1853932044,-555275545,1303730620,-1356994504,134801712,1956015125,81403180,-623983354,1532345894,-671482296,604762954,-797935894,-1260885070,-1752356335,-360163919,652377053,-250548422,256558926,166644062,-154103417,276604748,421461365,-562993063,1700370117,-1882923934,1110396739,-2124376914,-805638543,463826336,-954929345,1685678722,1588703890,65648573,-401986032,335982110,176001816,-1451871640,1623708371,-393129148,-1115991872,-428307902,1936898313,184073022,-538656966,216120111,-433443428,-1902170764,209258953,-2116522182,1001137986,-1405969491,-2108217302,677268131,-950109734,607724917,-726622238,-537117465,1481647622,-1090845782,-2068520505,1448558959,-253197442,1334387249,-400535743,-1844655420,-1655839893,1436991184,-1310052305,-221417275,1446536809,-970978711,-981475044,1177648583,-33604249,1827853282,1825850859,-1820200257,629603695,-1132716774,1183839216,-1926786955,-946719883,-1591090393,-119703531,8136173,-463292111,1801754191,210610446,-1084482242,934156150,-1819722051,793816602,-159146477,1924849971,-483381611,-1545993678,-608443839,-1177905671,1959276074,-198904550,-790329432,1155167833,717853104,-1371527086,-926348783,1982896687,83372156,1870182143,484948812,1686435586,-209894175,-1486702647,93905939,-1543122595,698625329,-1048574852,-1397395177,-504233574,1972009381,1439178460,201543811,1537336753,1507900574,-803232697,2109524375,1430460916,-614949729,1051669361,626017882,-841772806,1781643890,-1722292766,-1721975501,-826192203,1018701656,93004808,-58562065,1685124078,1052750455,-294715774,644540954,-1105115363,2088246518,135732460,-385964220,-846086345,1870497036,399672810,2012706565,-33078328,-1302870363,-303797576,1891803976,-1065997744,1764290023,2033214051,693345065,-260769252,-1649131163,1473343256,46663312,272683289,664846062,-1189169334,-2035360578,1640721772,1983787398,-1736206338,1682112732,867741894,1322580072,-672242475,-299488643,1001429419,-1251042361,1463833258,-1976159651,-1021156232,-776300991,-1491495287,-157159189,-765256044,-1960430734,1555839000,1955882395,956930908,-2011411352,-157400374,-1608263190,-2095246893,1029136717,407583251,-375180876,-1518595362,-28989631,-1552221218,659151799,1468736371,1014425655,1666215066,1215122649,-1249906742,1354385425,-671427475,852928180,961281042,1259795350,469766368,-999367226,-734790274,920271249,-1729127243,-793725322,1309941740,1994397571,1609869395,2089502177,763445716,-1526810404,-327737993,1887911375,-607382433,1261727923,-53345703,-1811343979,33596733,-642639980,-999785276,-636742965,1916282739,109725472,-1621378269,-669001665,-367561641,-1349172440,-746397153,1943950682,786858452,1341408470,1569108645,-327967919,-766538880,1822418795,989533689,899479080,1549354703,-1424641863,-1754919057,2023555651,1159006200,36033994,1411374504,1815249049,740694943,-902793925,-401568279,441963742,2080805418,-2056885954,-1464097650,1061563894,1810262368,321312750,-1724876921,313876555,-238245511,-1705262320,-2131405703,-1849608442,60043523,923168562,-1365191262,-1932965546,-3181019,1804288263,1769189912,-584288954,-614788253,-1255400523,1536754097,-332057975,-494042303,-83277420,-797635714,-83733613,274713796,-287351704,1759453728,-1751742469,743513399,952039194,-778492701,1283342128,1223001115,324090006,2012276840,-1201210692,2019510210,-1717188384,-168951536,-1016259788,1717927853,2115638211,-688989537,-786897166,-1525344774,908699331,1587073195,-786974440,1220342365,1402399396,1819395689,-236632489,-1112550892,2056744378,-480154878,303407176,58360303,1300398647,1719328599,844830959,197992575,1661030577,439581937,-972129152,-2090808430,389390173,-359996805,-1337760347,275679094,-901170592,-1499722847,1266963414,2140825522,497065262,300922532,-1764290273,-813524970,-1458340178,-1158859461,1678171307,-992854148,759233347,-1351315243,-741661672,-546279451,2142865113,1099037161,2112319986,1111439814,1466616795,1092637338,-494323144,496220583,1604559571,-1967773948,-2099310529,694849081,2114586416,348387629,852722151,972385158,615831120,735384050,-1899092309,820646473,1271797279,974142670,178785175,-313397748,-1417352603,-1163916417,1998590143,343725002,-578537264,-1542081401,135692217,-1412711538,-623168083,-1974984999,478956469,656277050,1608284333,-1608643194,-870023563,-589096739,-1364528810,2087898550,411685710,1809970919,-1682679449,2130121358,1435286370,-1450611965,-421996005,-1833900286,-740598053,1279706175,756889348,-671049616,-1819638124,723534146,-1888914979,901085578,1616620408,1189399241,-1671575825,937319927,-99755240,-1542359897,-829458856,1356990779,-1317712189,39428404,-1173680931,1340251611,-403967638,-1783946572,-1829725678,-1565869906,97208256,-1454741848,-1071075403,567195476,1984655980,266964306,209368265,1194170358,-42394709,998179668,1437237034,-481801729,-1117358531,1261723011,-1901060988,-76786044,-1653989669,-1310244932,790747814,-1468496545,1744088586,448907604,1108932136,81226565,1600511144,1339055842,1764165118,-1862790541,603576723,1920723169,1795834246,-1115522757,146589112,1339285865,156498800,-267454659,-2020621606,-855116110,-1863383248,890126466,-1218647629,1573168624,-1173118499,-1330420513,-1341189794,-693681633,-2144234346,-240749305,468784226,512833513,1892207457,-132886364,-264860136,-1843788493,199891986,134649632,-1757495237,-1645416280,1274213364,246513106,-31030765,-1004529358,-865602524,-2034121895,-1263954835,2053648007,-1801447316,-1583637756,82028849,-718242309,-1758094554,-354882973,2010679473,-808624045,-2133425430,-1707507121,-155939282,820492423,-1093783500,-2125566988,918107515,392759158,-927001765,-643988041,850432825,-233226618,-1296538025,-2011666090,-2074966533,-779010869,2006483252,-1329676647);
/*FRC*/Random.twister.import_mti(559); void (makeScript(14));
/*FRC*/count=210; tryItOut("\"use strict\"; var inhkje = new ArrayBuffer(2); var inhkje_0 = new Uint8ClampedArray(inhkje); inhkje_0[0] = -11; var inhkje_1 = new Float64Array(inhkje); inhkje_1[0] = -17; var inhkje_2 = new Float64Array(inhkje); print(inhkje_2[0]); var inhkje_3 = new Int8Array(inhkje); inhkje_3[0] = -15; var inhkje_4 = new Float64Array(inhkje); print(inhkje_4[0]); inhkje_4[0] = -7; var inhkje_5 = new Uint8Array(inhkje); print(inhkje_5[0]); var inhkje_6 = new Float64Array(inhkje); var inhkje_7 = new Float32Array(inhkje); print(inhkje_7[0]); var inhkje_8 = new Int32Array(inhkje); inhkje_8[0] = 1125899906842624; var inhkje_9 = new Uint32Array(inhkje); print(inhkje_9[0]); inhkje_9[0] = 18; /* no regression tests found */");
/*FRC*/Random.twister.import_mta(-1199600176,-1711398240,-999222156,1774514088,1831529286,-1619554306,-401346352,-369595314,-2053447773,2011863302,1776889465,53380513,1394974971,920777124,-1576175703,1374289650,1050597269,1458678184,1043891407,1557694517,754753366,-717892649,-71471807,-81133161,620558107,-1757499818,490401713,-1337430426,1157453469,1817854264,1600326587,-839356088,1872382304,-1299548225,-101235608,935003962,1244586464,978984802,349772508,-689076881,1625870016,318395110,1492634019,-949512570,-75240231,-886030758,-445065230,-1922370616,-1954170431,-655103297,-1384370825,-299266874,-810436817,482304031,-1359718865,1555036514,1139047764,-1827570633,-1317939874,-1551097399,1311976544,288158282,-1311264882,521511121,304016399,-1648870731,-1024193429,-1796934994,-1366058124,1847276075,-159992536,-1262150655,132281659,1175086390,-2137082885,544667599,1249873710,-1296581743,1455778010,1015072997,-875241030,646122354,1292624125,1102262630,660020645,1038585418,256106558,1106290342,350054096,-500123810,-403542253,-352958307,1996141926,1395714089,-1531743055,-1051781910,-1441813925,-1410872172,-1049774835,-491519449,797325629,1911655632,-522897596,538885483,-601578877,1885558530,1824883992,1207601460,2119179308,372620665,-1591797551,-1533329443,-96607853,1271372762,-812749716,-678497780,-2006726761,-1929085109,416422665,233927787,1830303213,-833077430,535193218,-1604194623,1994346864,583265375,-1701084150,-1979893410,1174192787,-1090754446,-310221369,-1344953652,2944209,616603361,1225704211,36252145,1364554198,-1063721502,-549752653,999933116,-1251259886,2118517128,1752518335,1703243946,259658844,531179557,-428441485,-1445105911,-1570831307,-1158105818,-1512964380,-296330246,1364644839,710772537,-2020943166,-1198734526,701816730,89612434,-605855874,1602874165,302402883,-432604937,-774666650,-287421411,1372902412,-1608621085,-1747306806,-28677356,603714154,372144805,727463681,1974260402,-176965875,1847797495,-1743333379,-27620143,-1972706150,-792658251,827247639,1348540899,615760372,975774077,-1827043959,-505341346,-1184491131,112304784,1467400846,1627309976,1506921307,366219935,1799450328,145078494,1731025357,-2106674504,-338202361,655368250,1863972213,551358428,-2138630178,-1425564942,566175036,74201069,-164377591,-1498753305,895860157,1067793587,-1154094214,-2096248498,169908848,-88959489,-1607731006,-1631138310,-880659596,-1414858516,-1771143203,-875233108,-176555330,-893188251,1999203863,1019432607,-1067760377,302937336,1117880941,1603684141,1520133306,-1170069645,-1870742361,1999472004,-385408403,666671225,1126228166,-232524840,732941817,-991711585,1493110450,1649150903,1565201916,-582102807,-982405946,1099793366,268974553,-686445936,1564609539,-348636717,-1466319315,1617205091,1578965553,-1951065218,-1492276704,2112488613,-870482218,2009694742,287751431,1661395402,-1270620144,1887569215,-1818612100,685623613,-971951171,-848739779,-1920346533,970201061,1095316070,844083268,442567242,-112861968,1937572993,-313937013,717238248,-1893377586,-1399906038,-85463151,1511581193,-156727163,-1847220115,-925706338,-1474929655,-1771883084,-496482503,-1114622143,90388604,-1986123237,-296715305,-1375741771,1472299069,852371554,-936638308,-769620591,1891483766,1073894513,-711861430,-263805787,-192301569,-2023287342,-88412510,231807334,1923088261,-226979044,-813023900,1475582414,-1634968320,1195225986,-1252271591,2125338612,-536235266,-1326511195,1832760586,24689854,-1806816748,-902290375,1880819499,-1704391914,660109743,-32082711,-217744305,1303786890,-23770793,-1032251688,-453623571,1422777221,958994070,1725356198,1412459119,-1034423968,-856833182,1662324243,1413932753,-1999951086,1731275834,-223712470,-819100913,1030720699,-997331470,-1873343074,-526698297,-1386469831,-834838728,-1916398821,-961609281,238245929,-1412220740,-859090948,1093377858,2103745367,1627878847,1327020701,-46615109,351739712,-651460704,941376745,397018956,-638702585,1273244063,1977403232,227017597,1597159815,165182410,1627393348,2104366500,-445981393,105520413,1209805302,673629989,-29064891,1334008050,1663826673,-694603113,-129982339,1078282397,1791392288,836281069,1356399271,710548629,-270144636,1011737621,1913455823,454447429,-386130068,925122841,431376484,-224448665,-1677071013,-1344493165,1873836849,-474453153,925781794,1798320697,1016100832,311673241,307051363,437943322,-20513385,1213207196,-362900992,-1770983765,-948802692,1577163975,473143605,29574050,1739605039,-1593632589,-2075546512,1335799423,-329909502,1840942183,954617948,1805217239,947961002,1174831772,-1614061063,-1693050154,-657419233,-326390375,-244089936,-763291128,828225570,1197381730,-1453519514,-1092525996,1336313153,2134408009,-1038351275,-2011139119,-823925119,2114643670,-36921085,-1699270797,1756755224,-1663449147,1241136589,211749267,-1254063851,-1555358637,331215869,387762153,690463792,-1157435338,1924761523,847973400,178991481,-476202153,-1286937875,26457507,-1866738859,-183618372,2046369920,875861453,1379433815,1976514803,371735866,-1679266449,-1315915216,-1741997875,1607889369,-106988239,-2132627359,-787734700,-1510698123,1273741299,358380800,-436456836,-364717184,1121723130,1812957408,176995557,1940442480,1154912340,-932249319,447241555,1648824219,2018604442,687394305,2090738336,1279750425,-1637903481,962726314,-1130906274,1894958342,1791073393,-1921382381,1437472460,2022254077,-1260736417,1895995132,585343192,-388812843,107686049,1351244120,741460514,-1255401361,-295497737,-852517041,-355785747,-979662840,-45697720,-707092467,2019321215,-69576287,-2065790646,1448873902,1515242281,87503873,-1213636903,-2100297288,464466154,135043819,-188201792,-175757362,1991637211,-119611307,-2113956723,503628663,1734215875,1452277933,-1996867244,1083184586,-92765750,1119324386,849427073,-913352589,1281826654,-1644341874,-56054492,-215095237,-1286323322,1267141589,-1458935812,-1384536651,233317080,-64776432,804998051,-1561587426,-1538639631,-1809755633,1369433876,-1351904478,-842210672,-282137200,-1174421267,-2131999579,-1549142717,-640662566,-451239510,959365782,1055623366,-475115857,695988423,-292247260,1042630520,60852028,1331888912,-1088973721,1853221561,1967824325,329789039,1216594542,-717077413,-71433744,-1407503011,209301988,811747633,-719448060,714451579,-1973207580,858215280,-1039729657,-1354984600,-401286703,-1438075739,157031642,669235990,-475942471,570091621,2033833354,-710533648,-2127759601,-901294791,1471335687,943040091,102540206,-476255157,-1394289134,1664651733,1908620486,-1325023486,949689261,-513173825,-1797403169,116019618,1306509023,-115589204,-375871196,20706920,-1330984827,573108494,-2095500684,-1896161860,998813403,1363749,-249333550,1551197606,2010589574,-1637236447,-101538366,1444028314,2001666156,-845006436,-1983551376,1567785415,-1329876599,790056651,569131325,1016777881,-697889973,-917109276,-758957862,725722144,-632356882,-1161115332,-1821253442,463387834,-306401743,1176863983,37640751);
/*FRC*/Random.twister.import_mti(27); void (makeScript(14));
/*FRC*/count=211; tryItOut("v1 = i0[\"constructor\"];");
/*FRC*/Random.twister.import_mti(43); void (makeScript(14));
/*FRC*/count=212; tryItOut("this.t1 = new Uint32Array(b2, 2, 5);");
/*FRC*/Random.twister.import_mti(61); void (makeScript(14));
/*FRC*/count=213; tryItOut("\"use strict\"; i1.toString = (function() { for (var j=0;j<110;++j) { f0(j%5==1); } });");
/*FRC*/Random.twister.import_mti(78); void (makeScript(14));
/*FRC*/count=214; tryItOut("a2.shift(p2, this.p2);");
/*FRC*/Random.twister.import_mti(100); void (makeScript(14));
/*FRC*/count=215; tryItOut("/*infloop*/while( '' ){print(arguments);Object.preventExtensions(h0); }");
/*FRC*/Random.twister.import_mti(161); void (makeScript(14));
/*FRC*/count=216; tryItOut("x, c, ogaybn, qawboa, x = (p={}, (p.z = true)()) = x ^ eval, x;s1 += 'x';");
/*FRC*/Random.twister.import_mti(287); void (makeScript(14));
/*FRC*/count=217; tryItOut("\"use strict\"; /*RXUB*/var r = /(?!\\3((?=[\\x9F-\\B\\u000B-\\\u696f\\W\u00fe]*?){2,}){4,}\\1?*?)/gyi; var s = \"\"; print(uneval(r.exec(s))); ");
/*FRC*/Random.twister.import_mta(1355581541,1677445528,324154363,-1751749360,-1947047025,999773719,-1733702363,-1233169559,1125326047,-966440396,-1608560987,-157490626,-2068080341,320344541,-1339790490,1791784588,-636768412,1419110576,-2043065113,1361106889,449795154,1513580075,-1422183083,-1269911525,-914140290,1605743830,-691547726,-2055406265,-874413665,739121777,1313459644,-350952587,-910706995,1885645735,-291700088,-2040763229,244382796,493898375,-1688611240,-881420458,2076487360,-2013767658,689502778,123010532,-690815552,1932516954,-703681871,700733571,-1937218304,-75353175,623688500,-1960881221,-1048625686,362477223,-540588415,-1176959385,-816414947,-1591240802,1210847322,-1240102556,-1386026416,1392535604,-1008855625,1979446436,2107012613,-1162963952,645788087,1573220703,-1649548102,2146290368,184893382,-1068378351,1094860032,-518611784,-506788551,1503782199,-871097330,-180541462,-1104487161,-1719808637,598950079,-716383024,-1381789536,-552785727,1719329496,-1283768256,1375389103,680334256,-640977798,-325406729,-1124479543,1464635537,96263332,1697777008,-1383590598,650397215,-1872204222,83418897,1032327617,-1231566530,-1021141047,-1263267096,-1621368380,-313908553,2097586048,-2117362603,-1590868702,612843260,-1709247352,2102360183,1052969215,-1834764083,-1656934984,-1506237765,1975761521,-1167631401,-1994747945,1570472975,-547348704,1442589667,1704695623,2102528448,1085743052,923318246,362025854,-236622047,-1210878828,1218613776,1425620972,1187243456,-90999597,-722017169,2001430719,-1837851915,988820793,-1931444198,-1267916546,-1492455534,-223907460,-679917671,-1878135468,349034349,-1305543440,-1542127763,1326212887,1328107852,-188168755,-154355197,-1093528516,2073235381,-1715501863,-813261228,-1886980993,1285975665,-481167930,983532916,2011245964,1046053328,-1102084309,1162465829,1370344788,-990710162,-501340363,1485316919,1545181482,1635299614,-179959698,1658497605,1343844746,597309495,-758992760,167370748,-414892162,-1293918153,92555022,1691327016,-2007950833,336186148,806669089,-669076029,-743510682,-1464740800,1995189889,640110678,-272890022,1216606354,1102864138,82176624,-1418091971,-725016109,-1869672016,-1401664101,1290332035,369047536,-1173309127,-1346388979,-1597747349,577469153,-694485235,-567980254,-1598683662,-1576691202,998155134,-1613821017,-250804480,-2081213284,-1200340635,318919330,-752944564,-1648900611,-962195827,951294077,-445723137,-47660550,1141293419,1176908230,705574950,734659120,1437216586,-1838893444,-1823881838,43170005,632452087,919801575,1771375959,-1760400797,2041092333,-45635188,-1456654981,851592088,-1366846212,1194147244,-2131873401,-187282820,508683885,1840682529,1909133983,-1029203770,-1772477483,364328216,949142677,1200479672,-967255366,391102637,-1112599586,809464096,1425693302,1229553986,-1110780762,-1925871042,-810913520,1478016290,1849082931,-857333318,1681215239,-1037265247,-513257936,-196483907,346616500,377220415,-1249505142,-835085381,-1619282815,60848489,567452927,2079319239,1692073548,782547252,-2140474127,2136959679,-483411213,584465947,-780981561,133484120,1303196492,1099693019,-1330402957,-854579081,1289746628,-2083610156,-2007149707,837274549,1982749410,1035866076,-1203731537,1815745556,1175288691,-717485461,-368446765,-384370670,-1798302167,-1629873115,-115532039,1528858342,455998956,1038789543,1188135758,1824530804,-1415046154,1308889984,-2104998535,1651398890,653717197,-66009743,876745447,-927725694,-1715366948,697587125,693665299,1285989354,-767972022,-1394708784,360237803,-1318007977,1314261365,2139709454,-1918491493,1468685664,-1541223028,422074351,1448700195,513315026,133152431,-165769229,-327489337,-1901866378,-1292739401,-1329985068,-1914624131,1640337564,720720949,1598056825,-908060006,1214802334,-350118593,-50308332,-1566260955,-996394753,1286775814,-1999326746,-1067645627,357987792,501065379,546407895,-484480610,2029319458,528983107,1225664663,-1202414741,1264721002,-2097737414,-378620050,-888468335,673170933,-30179828,1343554057,1984160610,-1004241407,2135636519,-1385769234,-1233482226,-1209276812,717910119,-743666553,261595701,1088641256,844212088,1764227525,565111421,868883801,359714529,-1020667518,2027660430,870745880,1455589563,709987393,1340932099,1529156746,-1017267610,801231635,-1683347453,766972368,-733018061,-550131460,1708041793,316616424,1526852053,-1041457849,1423760128,-283961032,-18617053,942772324,1415051294,662097892,23306235,-1508831434,-1265941390,-769453735,-1557574348,1858864120,-255543793,-79453970,1390765993,1736764643,142271242,-1664037611,-1000412266,-257053656,1046271075,996615146,-750278010,15819081,809127242,687657486,1548432993,-1999180276,-1066948768,-805330534,1387249636,-360944904,-1376156411,1728589838,1371996050,-540984320,-2054841665,46782571,-1434470994,936531663,1609578439,-1539729560,476576754,966801910,1394965949,720540238,126976186,-828407209,2112075515,-538736511,-1527861218,1302896779,1032126547,-1647858843,-680302413,1351164536,1463194224,-692529805,577779720,816245044,159819336,-1320225377,1847284735,-1131929106,1643242064,-596666710,608059747,-1045742895,-114246915,1383791578,1300432684,-1307563847,-2114508868,2134898448,1538347601,-309986254,-76284290,-1271829505,-1467480757,-322020637,-274273622,-93298569,-1707403406,-2082471282,-1894483597,-1025694870,368608663,-1551824375,-179509059,1673662455,-944961036,81907541,1772749723,-414144521,-1163010593,-266756516,1495843720,-829041093,1044300179,-1549863525,1302800211,1900184485,-62978543,-843086378,421667011,444179688,-582919699,1699509905,-608504144,-1589576106,1241004492,1700002700,-1670912889,-814666497,14940935,-43765498,1344198109,1992022692,-116542925,1779376071,-1803547840,-1344724869,-340468040,317142801,-562387811,1114662873,-1250688882,-684346826,-2008204189,344472502,588579011,-1624338090,1440623649,1702472574,-579539099,528196237,-1878322111,-1087559672,-2119143035,-998484971,1551864674,-402392125,-312029698,-9454016,464264794,-250716074,1042390052,1337855835,993121570,399441379,1973484637,-576421739,-577180998,1021008288,589168965,-1831608072,-11154712,1771537712,778175357,155962015,524866380,543047463,1889400095,38317380,755903563,573504351,-1795430173,1044952463,471502948,-437223868,427602315,1222217437,1659331996,660863197,-130955802,-80254819,2090333731,455929266,1708551633,208793544,1375239101,237796136,-2008420908,720022899,1147674599,894741179,-1869552689,1149206824,-1179399626,132477640,-362748231,1674431083,2121117436,380077625,1760861290,1858157795,23151368,-688438873,2113962206,-183523617,135039428,373583793,-1486825451,1326078209,-1044476811,1665523711,1756061951,1725138083,-150537493,-1938679380,-71801365,383850077,135074779,-1057040140,1453907616,618926030,1619170492,-443767128,1797482283,1813764159,-1394443829,449585033,1456158909,-494178094,-1595663470,1068165927,-1467154134,24906000,-1036753201,-1551464003,1904828475,429434435,-2002769885,-75895469,1040618238,98939039);
/*FRC*/Random.twister.import_mti(93); void (makeScript(14));
/*FRC*/count=218; tryItOut("\"use strict\"; v1 = Object.prototype.isPrototypeOf.call(this.i1, o1);");
/*FRC*/Random.twister.import_mti(108); void (makeScript(14));
/*FRC*/count=219; tryItOut("\"use strict\"; L:if(true) { if (x)  /x/g ; else print(((void shapeOf(Math.hypot(767346516, 3)))) > (void shapeOf(this)));}");
/*FRC*/Random.twister.import_mti(240); void (makeScript(14));
/*FRC*/count=220; tryItOut("\"use strict\"; t2.set(this.a0, 15);");
/*FRC*/Random.twister.import_mti(254); void (makeScript(14));
/*FRC*/count=221; tryItOut("mathy5 = (function(x, y) { return ( ! (Math.fround(Math.hypot(mathy1(x, x), Math.fround(Math.pow(Math.sinh(-Number.MIN_VALUE), (mathy3(((42 >>> 0) === (x >>> 0)), y) >>> 0))))) ** Math.log(Math.exp((x ? Math.pow(0x080000001, x) : x))))); }); testMathyFunction(mathy5, [-0x0ffffffff, 0x07fffffff, 1, Math.PI, -0, 0/0, 42, 0, 0x080000000, -1/0, 0x0ffffffff, -0x080000001, 1/0, -Number.MAX_VALUE, 0x100000000, -0x100000000, Number.MIN_VALUE, 0x080000001, -Number.MIN_VALUE, Number.MAX_VALUE, 0x100000001, -0x07fffffff, 0x100000001, -0x080000000]); ");
/*FRC*/Random.twister.import_mti(463); void (makeScript(14));
/*FRC*/count=222; tryItOut("\"use asm\"; for (var p in t2) { try { b2.toSource = (function(j) { if (j) { try { a0.splice(NaN, (makeFinalizeObserver('tenured'))); } catch(e0) { } try { a0.pop(e2, g0.s0, g1, g2, h2, o2.t1, a1); } catch(e1) { } try { v1 = r0.multiline; } catch(e2) { } m2.delete(s1); } else { try { for (var v of m2) { try { v2 = (f1 instanceof f0); } catch(e0) { } try { s0 += 'x'; } catch(e1) { } try { this.a0 = /*MARR*/[\"\\u3FE8\", (0/0), new Boolean(true), (0/0), \"\\u3FE8\", (0/0), new Boolean(true), new Boolean(true), false, \"\\u3FE8\", (0/0), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), \"\\u3FE8\", \"\\u3FE8\", \"\\u3FE8\", new Boolean(true), new Boolean(true), (0/0), \"\\u3FE8\", false, (0/0), new Boolean(true), (0/0), \"\\u3FE8\", (0/0), \"\\u3FE8\", new Boolean(true), (0/0), new Boolean(true), \"\\u3FE8\", new Boolean(true), (0/0), false, false, false, \"\\u3FE8\", (0/0), (0/0), false, \"\\u3FE8\", (0/0), new Boolean(true), false, \"\\u3FE8\", new Boolean(true), false, new Boolean(true), \"\\u3FE8\", \"\\u3FE8\", new Boolean(true), (0/0), false, (0/0), new Boolean(true), false, false, new Boolean(true), false, (0/0), false, \"\\u3FE8\", \"\\u3FE8\", \"\\u3FE8\", new Boolean(true), false, false, (0/0), (0/0), false, false, \"\\u3FE8\", (0/0), \"\\u3FE8\", \"\\u3FE8\", false, new Boolean(true), false, (0/0), \"\\u3FE8\", false, (0/0), \"\\u3FE8\", false, (0/0), (0/0), false, (0/0), false, (0/0), \"\\u3FE8\", \"\\u3FE8\", \"\\u3FE8\", (0/0), (0/0), new Boolean(true), (0/0), false, (0/0), (0/0), (0/0), (0/0), (0/0), (0/0), (0/0), (0/0), (0/0), (0/0), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), false]; } catch(e2) { } t1 = t0.subarray(10); } } catch(e0) { } a1.sort(); } }); } catch(e0) { } try { m2 = new WeakMap; } catch(e1) { } try { a1.valueOf = g1.f2; } catch(e2) { } /*RXUB*/var r = r0; var s = \"\\n\\n\"; print(r.test(s)); print(r.lastIndex);  }");
/*FRC*/Random.twister.import_mta(-613499925,646913379,-1539432816,-1931015363,-1052600831,1916551326,619903903,-1705897910,-983554636,1127462290,-169335904,265711889,-1197721361,-1470824762,1270293563,575631686,1936630257,1859666120,-1296494483,-2036906052,-33446563,-78970708,-571151250,-804885420,1118519236,1274010424,1308074405,-2136451936,-492595008,-2061555405,-2078981706,-6858827,-48005394,-877188086,1104510923,1978092710,-2010548377,-784113344,625046036,-2132477538,-1539493078,1129684058,502634452,657704875,375418221,1338147015,231533729,743402711,-383216837,1090947533,20787778,720951187,547031366,1374896965,1522989087,2147462048,-2142421216,-1949979377,1885582129,1135374357,-2060785921,1774400091,-1728029956,610360753,966210002,1260082004,1717416220,-1682691606,-1149368021,-1839755848,644331710,870130098,1320226349,-36265055,656197573,-1232114637,-1228189097,868527056,-1350982678,941500906,-495022313,1227814002,1099077419,-874038958,600778017,480239271,1147538223,1019771045,1413400670,2003131097,1534296519,-1639483022,2062418916,-1583385925,-1296359043,832862669,882812413,-1943870436,1795224757,1061051135,1615628774,1726557599,576945715,-1876434140,2070779204,-2072076530,-1531888835,1286268818,200389474,-1165085195,1398452233,1492922074,658653119,2116832616,1383815427,688636310,1146053630,-1907791580,1170711957,-1706253372,862042366,-353036452,-1431645375,1064186085,-1188234369,1001861632,1966888056,-1992751361,-1424553,-1247645174,648285371,360955016,-1744682420,346015226,-1885928281,741560363,-268448385,1879975446,2015309094,1956455689,699858734,-735572210,-1128485943,-1005245386,-980641811,316988818,1758873453,-137525766,1671884560,-445845849,1757609581,437596664,1831267792,-899112071,-848233350,-2045771788,-927406508,1983448268,-450938692,-1766380026,882644175,2086799572,1193371510,-2079763130,685939367,1021129895,611639574,785885622,-500218206,278696216,-1043757050,-91868364,871832312,-78731505,1565594984,1180872741,-1777426348,848745030,1696848059,934068859,-566465521,-1115605909,1026518718,-1251939253,-1935902123,1672028869,641564847,1779873615,2128051602,-1853646824,-1874262073,869700003,-196155367,-775543624,1012728945,-1967032521,788748637,-1501484461,1904973019,73901140,1453340329,-1093573520,1998584257,-2091406129,524853493,274095116,2090212119,271680795,-315024059,1416191349,1872587807,-496327050,2138862182,1414048549,127209086,1750559648,-1168609925,30576814,-1027255661,2032982438,1868688965,1938296035,2129874834,-375434987,-554809407,-1819869140,833328772,1294502740,-1862467053,-1175127163,1594802971,-1584419620,687503700,-688360114,1847690380,-915136290,2068378162,-1293228285,-762207752,767171997,-2063147295,246215515,1502080632,-1465767704,1235317151,1213255212,1795713492,-2032937812,476265650,-33419529,-511585276,-755152829,1362455132,815518149,-1701289827,1004537756,760936267,757372135,1577326462,-1306019210,818102781,551322774,730754920,102749254,-1102792205,-448644581,1574663753,-228962309,-1718820688,1821120614,-1756276508,822476890,22774280,899601356,1058300667,1079649458,-1477052866,655064563,1828462298,-968806918,449105524,1635391196,978326329,1544091014,-526609336,115105837,1186717779,1459747695,-1220380966,871045968,1719470787,-1214453389,-80380565,1332274571,-1486656085,-1301694390,-2076766826,1974804370,-1688558853,-680935412,570127765,-672080467,389880717,1243295263,1370955577,1177531907,1585438352,1131013605,607183594,-1366978148,-384455801,-1418434987,-1483496948,-1388639795,1027200541,993610230,930180722,-457235842,-993956588,-1939375339,767294311,-2092113403,1552518008,868528257,-407241525,-227741017,507448879,-2055689730,521765034,-1135536864,-582097353,-1349895611,-991028785,463640349,-841220947,1462940584,1740489499,131656497,-915025306,-681257954,-2055949872,1054037060,-1597044034,533435639,1447216953,1282121906,180722160,-493922463,1705793269,1386715601,-78242819,-1981316114,-1219981648,413547614,1251604291,193538997,1944920093,-850997012,-434073233,276790177,-1131125999,1820550799,1401482531,230090194,-71327543,1914895745,800216909,211747806,2077461361,337883248,975597805,-1834493131,1274689140,-980144340,1129053823,-2006394739,-2082509229,-1627665180,646448776,1986221105,-123223697,-2143568873,1230573073,-1199984613,1679532026,1555442932,-1683476802,-745610760,167597331,-593215871,371952661,-1452608258,-64795377,-274347270,77471337,36396523,1959007036,328054832,1462715426,122577281,-1086491659,-251139701,144526470,-996203491,-2003245799,-827120783,-964620189,-257907050,-1659960288,-443491321,443835542,1348033253,-1802050193,-690941694,-841648719,1690508038,1589005738,93621043,1045274107,-1282368890,1818004706,1290523515,-2061314169,-1404088406,-1856916413,-458701687,-893180444,-1978847937,-1222185024,-1612687330,270629530,-623166764,-704878524,-1567558455,15901067,-414305466,-555921381,307008051,2006464164,1879311191,196939744,-1885087118,678975786,1639083160,-507579486,-899266383,-1731187967,-1712306429,-1481809640,367176130,2077625201,-1526667723,576208904,1680154576,-1321958596,1884540569,2014125001,-743609604,2009951691,-1312096351,-1748426591,-2101691404,450693923,1997557194,-1248110952,671510590,221668829,-1997033804,-170131621,1056680999,-1435161809,541871927,-1446416613,-1261389104,781375203,1333745064,999425860,-867925515,1943699013,1252034812,-979324396,899440669,544900435,-1734386759,-1118767659,203845210,1628260107,-35923092,-2134466915,724676291,339517075,-109213430,-1746207835,-1566143225,-374194153,1632450388,-47251449,727494026,656485653,-625240001,-1692105674,1599304297,744807333,-404856551,-321059697,-1146684654,-164616686,543349318,-1247434482,-898405531,2137150450,-1435569263,-353088422,941118345,-572726354,-1359001088,-1692522376,-1844344069,1816272511,-2090244069,-598224380,1285631329,-267290794,-760837974,-108324439,-580486849,-1888660466,-1543646374,716171822,-191798891,1331153916,-1591742459,-1653068341,1924396890,1167416191,-1947310474,1730305937,2078712434,-2025353635,1085806779,-1137542301,1199648702,-523447595,1917993483,1289973144,-934811059,-2031761781,-1526032354,753988517,2041891366,-1072929444,-1700499968,523707212,-669484940,1641401970,-1080087409,-2002139951,-1108407122,-1398744362,-476264650,-1413055590,-503425187,1335355019,-2014583517,1441689873,-46915800,172849887,823058650,543852777,854534993,136693735,-2128807449,378053951,-1472109911,1659455017,1377519849,-1634541422,38077688,-1397296465,-1846007898,1006194026,-827337819,1385349416,2037558763,-1828180801,-306831327,1222430458,710995169,447387286,1459754950,-1663178422,-109144733,-1269546513,120150390,-1393429825,942761599,-773181979,2084468377,1143915077,-1229323404,547415598,1809367359,-2049548997,-40862133,-922935675,-1523039252,1337134263,27411258,1628835010,-184696911,-909056651,484466346,-1832043571,1879546275,-1453505691,-710854630,564728049,1654259021,1937078186,-1544444808,1013259150,1732345893,-1097045020,-1065615850);
/*FRC*/Random.twister.import_mti(314); void (makeScript(14));
/*FRC*/count=223; tryItOut("\"use strict\"; mathy4 = (function(x, y) { return Math.fround((Math.fround(( ! (Math.asinh(Math.fround((Math.fround(y) ^ Math.fround(Math.log2(y))))) | 0))) < Math.fround((mathy0(( + (( + (Math.max((( ! y) | 0), (y | 0)) | 0)) < y)), ((( + (Math.min(0x07fffffff, (mathy1((y | 0), (y | 0)) | 0)) ? x : y)) < ((( ~ (Math.fround((Math.fround(x) <= (((x >>> 0) ? (y >>> 0) : (-1/0 >>> 0)) >>> 0))) | 0)) | 0) >>> 0)) >>> 0)) >>> 0)))); }); testMathyFunction(mathy4, [Number.MIN_VALUE, -0x100000000, -0, 0x07fffffff, 0x080000000, -0x07fffffff, 42, 0x080000001, 0x100000000, 1/0, 0x100000001, -1/0, 0, -0x0ffffffff, -0x080000000, -Number.MIN_VALUE, -0x080000001, 1, Number.MAX_VALUE, 0x0ffffffff, 0/0, Math.PI, -Number.MAX_VALUE, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(582); void (makeScript(14));
/*FRC*/count=224; tryItOut("/*tLoop*/for (let b of /*MARR*/[(1/0), x, (1/0), (1/0), x,  \"\" , x, x, (1/0),  \"\" , x, new Boolean(false), x,  \"\" , x, new Boolean(false), x, new Boolean(false), new Boolean(false), (1/0), (1/0), new Boolean(false), new Boolean(false), x, new Boolean(false),  \"\" , (1/0), (1/0), x, x, new Boolean(false), (1/0), (1/0), x,  \"\" , new Boolean(false), new Boolean(false), (1/0), (1/0), new Boolean(false), new Boolean(false), (1/0), (1/0),  \"\" , x, x, x, x, x, x, x, x, x, x, (1/0), new Boolean(false), x, new Boolean(false), x, x, new Boolean(false), (1/0), x, (1/0), (1/0), (1/0),  \"\" , x,  \"\" , (1/0), (1/0), new Boolean(false), x, (1/0), (1/0), x, new Boolean(false), new Boolean(false), new Boolean(false),  \"\" , (1/0), (1/0),  \"\" ,  \"\" , (1/0), new Boolean(false), (1/0), (1/0), (1/0), (1/0), (1/0), (1/0),  \"\" ,  \"\" , (1/0), (1/0), (1/0), (1/0), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false),  \"\" , new Boolean(false), new Boolean(false),  \"\" , x, new Boolean(false), new Boolean(false), x,  \"\" , x, x, new Boolean(false), new Boolean(false), x, x, x, new Boolean(false), new Boolean(false),  \"\" ]) { var pdmouq = new ArrayBuffer(0); var pdmouq_0 = new Uint8ClampedArray(pdmouq); var pdmouq_1 = new Int16Array(pdmouq); pdmouq_1[0] = 5; /*ODP-1*/Object.defineProperty(o1, \"setUTCMonth\", ({set: encodeURI}));e1.add(b0); }");
/*FRC*/Random.twister.import_mta(-641563042,1160792938,-667593536,1184139306,-2011575868,-2081652330,-910808008,-366413885,-1356138056,-59440717,776154817,407480456,-1313168540,-425245100,1098834502,875103560,-507694746,1300319576,663271640,-1195495461,2016480101,1354230732,-611078996,218698496,1763458791,986822538,-1407490566,-536840157,1060102351,-2000059073,1825453626,-910733129,-96743909,-373066336,-534209401,1222665000,-902740887,1381111937,-415477879,-1933325938,1944476702,2036530510,-90877859,-1719301751,826944206,-1214865499,-291673556,1277299424,871218312,-1739673056,361012245,-1209997893,-1542211393,-809646175,-1694551067,578740120,-1194362488,1343089275,-930265524,-477046679,1044661006,2068660405,2062737830,-1962756024,-1489563042,703845293,2060081471,1898767058,1630385890,1577433474,-1860616595,1267452050,-1726460632,1626601490,-1576842767,1805940463,-315429064,959317782,326123869,-1817841648,-1462502452,-904690417,1867715669,223318107,-1562689647,-1690226661,536074036,-1756392966,-1365478423,-709085385,-218601515,-38690961,-1560893631,-731267342,950469939,346888580,-1531445495,87722642,-405099788,-855030540,-2128573542,-1357372717,-760714835,-426619244,1567374830,-415959324,-2121592112,-383394498,1072255287,110481097,203214123,1057752590,-177910319,-816361556,-1091890342,-925631067,1060955931,641171899,-1546052638,-1028721657,-1486159531,-1608530176,1171701942,1506352996,293254241,-896574102,1328724746,527861981,-2018033606,1161290380,-1455682274,648989448,-1092713624,-778765968,1846470863,865041323,179627089,2040188396,682116141,1945706502,1374856693,1074883430,582127264,1207730250,250823031,1303331260,1236566262,1026562576,1677274561,1804339554,-1476394782,442729805,-980931771,-1498145951,-643591686,2070630502,-1559954926,1398428204,-188433524,1273986665,-2082600764,-1892652691,-510104171,1723827734,1721269713,1571657216,-1870646792,1694093888,-1250273372,715767516,1280178496,2039547285,-1774139383,1720536403,992284970,495973653,-250999926,-915400021,-792356597,679765578,-980603374,-232700432,306241884,-457195361,645132824,-662392416,-713996653,-1402760586,-445125587,-1712259642,-360508177,-1182444987,1071711642,1543232429,1695981095,2061327774,-1922990976,1295812621,973255765,1672644206,1666630817,-1498837382,773416396,-166984053,1676930873,580247663,1820331033,1734942968,1443126665,-512423321,815206401,514340337,1204902652,-904240566,684452730,384417199,820957684,288840435,-1455991607,-1894689012,-1034597405,1275908195,238468141,-904230735,780271667,-431382362,-420496452,1219803016,-2134735241,783975826,1448304196,-597363346,-1466909903,-1096356226,-829233236,-762412895,2080948973,1191968317,-677636455,707886283,955879206,1841108346,544739644,476395894,1772694094,302812210,-1143487091,906007868,-155296664,-1420605778,-42006530,25594825,-1147867209,945808747,-1108313107,-1333122123,122912659,1137458565,-794522228,995286586,-106088469,-168842445,1273989387,1276880975,-1174686381,282674290,753295020,1059073094,254079357,-247595985,-1056536156,837282762,-1386613181,1746922382,1812928697,538396567,1388559366,603624312,-1799326906,-378413179,-16724785,517966502,209364315,-2004798548,-1972671822,1926760122,1360565505,635795555,582536477,-792407016,163871790,1134894132,-682683977,-260874443,672677623,590753833,618608203,96264143,541010068,1357727549,-771545573,1888842984,-677293761,1558302843,-2093912888,1011854869,723104317,-1161065799,-581874239,-2100203191,-1040378962,-250417513,1423180834,-664302363,-1965869823,-1255881520,-404511224,-1869033121,579506746,1831070253,1288142639,1457766543,-1807224549,241414579,-452705506,835558716,-810217461,-827569201,-1322211261,621161065,677372777,-1508671018,871173557,1047419993,-2101574422,-1791033243,-1670313074,681976856,1421765633,-1210116807,-1874926194,-1366518267,507414273,-1927990184,152034,-1497639142,1793191784,1286970096,272939831,-512393833,490397331,1256125241,-2032385211,-210309004,-2084917800,659120363,1670679290,1126495606,-140917241,966525503,1054735080,-557699455,894699842,-1369209622,-1719467021,-1501962412,1974903273,-183250798,1241559902,-1498872311,-676864753,1796102733,1868912170,-1323708650,-1609775479,-1155651017,619835152,-79428698,-1202020470,1624472365,2141287861,604481069,-27313996,-787925521,2097235030,-116347693,573050517,1579684498,946521842,864361280,1913322601,-2122224759,712995709,1271369235,-52114326,-1894228422,594502340,1742363473,-482441846,282509612,-2029647543,2137765737,-1496787004,743360985,924924876,713925093,1356084481,-1962234878,434215724,1601884951,1436278066,-1255133072,-1276364511,714296468,-570286091,-903034120,36833408,1823304397,-1605558522,1238320107,-460946737,-24165061,754645579,1556158078,-1503634794,1600333479,-1078157266,952480577,-380001675,1711921281,-614360095,151903003,-355128620,-1242436605,1422801243,-1604172453,828109729,190516051,-1079868283,1108335884,-842297485,2096613359,640715747,3254309,-317927820,2086138262,1524745298,-1853621393,117277826,-1428879030,1100106612,2142117943,-732221618,-25822686,-1449795557,634174284,124530924,-1262659458,1569274465,2054986686,-281724,452252386,-385440188,1724213665,319342114,1208980648,776645521,-618872748,-1412926538,-1404423052,-716460494,-465228516,1214566746,1972772387,297746408,-344498230,343520907,496666627,618057655,-1723550019,-73833030,885361051,634205878,-1057770074,98503336,2032836310,96416652,549898362,964676749,-654739811,1889889482,1795586142,-662523346,-1053307272,1334228972,-1464090207,-1533826326,1268690929,-2051893494,-523520936,-1631657371,-483015244,-1963931708,-1113223522,2116677361,-271032241,-1186942298,-439216056,-487682101,1942719650,79624891,-15643489,-1210277983,2146886870,1922751843,1865931041,12886458,-420625458,-619112218,-1184565067,254507354,269518172,1248162940,-1055782336,-234400881,1737065107,18067088,-2024484084,-740985603,-1341475647,-714696538,1418054386,1159091640,-1864650915,-1086539390,935908054,-1088282512,1532388447,138826261,-742028980,-1146676422,599649460,1426412810,-1047392060,766743718,-118439520,1067886114,-2085112286,1782162844,-1270758475,1127319219,-1432366408,499228934,-1084229838,1214999895,1819081460,2079435838,2114948610,-673324467,1712205944,-677787864,2088748912,264389163,1871610841,373042060,-2003803727,-1353161388,419631397,787723122,-2094738387,345241716,-766594142,731109009,-2103575389,-55538085,520997758,-1604845589,-1838606565,35840234,-618600976,1294575993,-353120948,-2097641791,-216519558,-1393076807,-1812487814,-1247492976,864596387,-180148894,993721831,1272217220,1520538587,-437423121,-87627671,805557106,-67299981,1103007130,1824001266,1884511223,1060447549,503127894,1005541579,1558095309,-645410675,-1445453232,1183557902,1610767024,1328182228,-2022586070,62913233,-1619453254,-311465617,404476125,-1349640200,888704671,-239665579,-1681828551,1269843900,-1871070795,1951268538,-512753954,-475334248,-282746575,1334714859);
/*FRC*/Random.twister.import_mti(273); void (makeScript(14));
/*FRC*/count=225; tryItOut("v0 = true;");
/*FRC*/Random.twister.import_mti(284); void (makeScript(14));
/*FRC*/count=226; tryItOut("for(c = 16 in new RegExp(\"^((?:(?![^]+)))|(\\\\u00cD)*|[^p-\\\\r\\\\w\\\\r-\\\\xD4]*[\\u00e3-\\u9622]{0,}[^\\\\D\\u4fdd]+{1}\", \"gym\")) (10);with({}) return;return;");
/*FRC*/Random.twister.import_mta(88243940,-819712022,1939637561,-2096435797,1050539938,-1038892584,-1068367129,1622427408,-843083293,-1627581762,-2026997690,20761246,740913213,891595793,-1356549420,-2093833838,1280567864,-842644583,1333489098,-417186323,1157013291,-1920677552,256625259,1224748387,-471359746,989284534,-1245078864,1627331118,-1039182617,-908346573,-2062111803,223147431,317219409,847078781,1836968591,1455765567,1171280028,-27742656,-435969636,1219026350,938112500,467704948,-1748653801,-1787913708,-30131998,1367228149,1713417557,-184938448,1886431366,-1993655673,326842733,-839063550,1409505861,-1780129191,781275131,-935554166,259768256,-1915534531,-854825049,1481511275,269699323,1626360498,2147338138,-1402979669,-687502357,1298872836,1582504136,597564755,1728923753,-1076984712,-1093065699,-1488693982,-600586115,1564654101,144680628,2130552518,687938984,-2129678439,-492460094,1074809709,-509871525,-898108094,116117071,1945914029,-529686199,1781849388,-883655333,-879131773,-1963182702,-439635783,-954812654,-250859534,-1295144476,-1241620852,1632695452,1406270837,-2085975247,2087445142,-834706469,-469504217,-2061889977,1978536707,-1820159214,-267846510,-793788730,-902476116,-919117823,-1193937227,1973041140,642147564,-95151281,1096063484,341846900,1540059926,40895122,1900698867,-169503532,1668698258,-1754786819,-898002481,-1226694578,-1175291715,-1786743033,-1633774667,894905321,771500537,1470234353,-237177966,85095381,361605151,-737954168,-860211895,-658454407,996760606,-733296648,-649816241,-1407792725,845163339,238306005,248758869,2069811692,421467461,-264517271,634784606,90852458,1910445425,-552985140,-2058898791,-852048623,732341843,1468974171,-772472607,2115206874,803229262,-685081973,205773839,-688726492,1913204881,-1869351649,2048829532,-1600189845,1041851480,357692275,2111654175,1386810480,125983447,502426361,209780830,-574308641,-1988191756,-1128062160,-1126471767,1768604251,151089377,1166146039,320262996,2133672233,232452609,1263532123,-2104399646,-344345117,1258459204,1886893408,504385653,-961440356,1900582231,-1523980991,1195643760,-552607847,1508769336,-163403682,-1431066705,-1882218258,-531136184,1741634836,-480391761,89136304,-1274398329,-903588284,-383951083,2146225103,660597009,-1657039193,-183740395,-1280501725,-208268514,-365739791,466795595,-281436958,-1589550481,-646522381,-1533451180,649251828,-887296249,2131953511,7125031,1042088542,-1184132060,-1237428781,1675837463,-1262575790,241850236,-934802883,791039512,-795989557,-1672315665,735345199,-1674867456,-1736872669,1488267803,-1388800228,-203613467,-1656703257,-1491373775,-1862551649,716390474,611343743,904446933,-852704220,810923950,66725548,-1088898486,-1929364183,2022145823,-994048640,-879214637,-1138591885,2141827359,-668112377,1911835028,-1865689000,1730501114,-3142948,842602393,-1582121173,414079985,1899304238,-1387991805,1357224634,-1221179013,-780009413,-1853710635,-373269305,-1071301910,-1238102919,-261058870,1463339917,-1452229227,-1166617924,-146346555,-845320207,1905292060,628214578,-919629354,2113471268,1494316677,-1730776261,421200078,541898527,-1299477251,-628447478,-1314607735,-864286116,1246628505,-188792736,2089328120,-743170683,-1740136790,1217536190,991951245,-1917668175,1705685999,-1403378367,-1822967956,-1425164904,-328572013,605576000,-1362710441,372917859,1815800751,621281377,-1169703180,-1987707356,681159628,1176553548,1847709187,-998424850,373025892,303562041,1712670616,-1837265607,-1979210920,-552621183,389371652,-1861492245,-116529514,881813705,-1772880369,1586850363,229025452,126291476,-226771762,-1914137229,-1322734914,613231624,1894603521,442333727,1149954745,-1100630296,514183801,-486458247,273778883,1275777119,-932633996,1799538264,1000518195,1914009312,1224973712,-1011637313,1551849907,-1786410805,-731385395,2009122527,-1243300827,1881914143,-501685175,-333226825,667471114,272660137,1108715665,586767094,-1355695468,1413960131,377268253,997258040,886585000,874500772,1992811860,159155337,-944884467,-1929315455,-1897872551,-831171270,2044721293,1633469665,-303586562,878324252,509511747,-1824315746,48273201,-916875609,853075839,1767109370,369413719,1103107933,-1622265191,369403776,195267486,949226920,-657754913,-1528091257,-402266415,-36702681,-1468892145,-678832601,1485783690,1426759957,-1129682670,668723704,-1252246120,-468366332,-1633811183,-1150735103,595594444,1259155267,-1938616387,597361795,-1923325451,-189790401,-203327968,-272884854,1457885717,-600242329,1690164431,-2120969684,-97693180,-2028716317,-1484162955,-38319856,1522162681,76040269,105855443,604058397,320887396,575829516,-1642669095,-155976831,-429643811,1465693829,612651350,102273802,-1464143634,-851622256,375403003,1119033867,-705034669,746010218,-766989782,-850152050,696511368,679609671,-2033742519,812012992,425520259,-1830080967,782030317,1038374681,1605315438,-979465518,-1721779054,745520175,-184290743,-1719870230,144401764,-952079121,-1689339910,-232125057,-138388205,453039065,-1467928697,-1980109092,-89932180,-479690242,-434750723,-825372506,-1680902827,1122731556,1525988083,-823961798,-1564643547,-362735552,-1535580995,-1059503035,770981486,300878209,1124147507,500946820,1444814711,-381837200,-408557008,178645393,-1594725075,1750827037,-1258428281,1242701562,186188189,-432947894,463998812,-225463685,-2112047103,-246193269,-1286331280,953647394,869961850,-1848532376,1379533692,-1487590074,1412781730,620139844,-1852642654,-173668667,-1703586450,-1863620106,821792891,606465434,-398522423,193006306,-817617804,32876848,-215610657,-1196068084,948003014,130265546,2127180956,-1207992266,2095902284,-1067286311,854937648,-935236648,1462487006,-322036727,911851375,57929619,1945224171,919913189,1223716963,141105258,-532793150,-1609531542,-338716180,-1688209982,-1908469850,-857512269,-1005370792,1141555649,380866859,1871741481,-706082112,2068468811,-482954633,1121668789,1688986256,-12277390,-1679597009,1306494223,226946305,-1833515672,257299692,-1545246722,-2099501540,1189847390,-1148630162,-641405196,1649844890,-1439981857,21379370,209550781,1922817242,1901325771,1970857717,-1536736286,1785592971,1866637464,-413107093,1924962243,-2086838025,564270456,1374125440,1666617599,1741042635,-1235828276,-173320302,-1788001536,2030789414,-733799017,-1809870571,-1980341762,-2097393294,1291660036,1032403685,-1664883212,-1125457784,2053024455,192129861,1749952693,-1721550461,-1842768957,1676159619,-2103326612,-1411697248,587550395,-486276985,1297358997,-76756825,1060910569,1403971265,123919619,-1214158544,1249185141,-341874056,-846757441,-895300151,160196117,1817953189,-1163349467,-207855533,884773192,1752730499,-1270168258,1739423057,-1828990227,-156764828,713386496,1122547368,1759928089,143991024,-10597067,-1487681262,819112806,-227312774,1204648039,42765974,1330138486,-1770105211,494511847,-214699077,-796647866,1965105153,-457639348,-1948331410,1381330944,-1516810492,1924968343,557464561);
/*FRC*/Random.twister.import_mti(454); void (makeScript(14));
/*FRC*/count=227; tryItOut("h0.getOwnPropertyNames = (function() { try { i1 = new Iterator(g0.m1); } catch(e0) { } /*RXUB*/var r = r1; var s = s0; print(uneval(r.exec(s)));  return s1; });");
/*FRC*/Random.twister.import_mta(-1429309952,343340412,1802285098,-1326260133,2011984633,622376651,350748487,1044638210,-1252795557,-998047040,-417915590,1923826129,-652165842,320475431,1205233946,1109968385,-1395930249,1173340393,881817072,230687947,-525974667,-1980636305,-1727203528,938171509,-171879243,-673608760,1713356012,-88342361,673147669,-134950057,233201702,1563374713,-1447695895,-2026618657,883794313,311328142,644922275,-504693001,1254669114,638676451,1381983572,1467281030,-739708520,1400217694,78929388,862206623,853962108,-1082640212,114530918,580854038,-784455406,-402010588,997928564,1203370494,-557975639,-1529520610,2046241724,826495914,1860226367,-739601786,1787600810,-249711369,763740847,418082154,-1026721345,-269432799,-1523351528,-1151263382,1558602511,-608176811,96220646,506262673,269223909,250231499,-1618166194,2094730953,762482580,994102555,-233204492,1341452472,2123625981,687007107,585772424,1483539440,-967947546,-2072703152,-820059804,-726681439,-1177064449,-992053553,749945179,2106606006,-881998364,-2062648181,714414859,137796785,1322148144,-1707938648,53887109,-804995810,750492970,137683129,-1960676202,-790451089,1570490256,-95375083,-1146585319,-852321332,1875893306,1681931681,1381965006,-1032749470,2060353109,-302637760,-1745608247,964765177,38464418,-1536656444,-1262221221,1394083917,634369091,1943598134,1032347881,1492963561,29993861,2117806356,-50513007,-1618261772,-2055342597,1167153517,717201595,-1910341464,-1098769288,1761488201,-1862198808,809991544,1541130069,-741534534,-1813529356,-1357271650,-1697567087,49296277,-801692749,1147045739,443445513,-163454958,-1174549751,1438141576,-845292836,-1095585969,-1016468363,240800422,1653129682,385535608,-1253793197,1144770442,124540156,-469901933,-23972647,-1461378926,250335148,-252257895,-1071634533,-1627240460,1868745254,43828899,2135679753,1672081959,-794763793,-677908378,1167676025,-1589576970,-1610534326,655075792,-1251899102,-591349108,-1802083686,-723426233,-1741976078,2124282349,107569825,-1164307748,1037806917,6128757,44628723,-959946006,-1731280609,-1984730374,1062738397,1011058988,2079328824,227728642,-1682658596,-1100996811,1644469185,1260677197,-279547975,-541419257,505052934,-767409040,-488648748,601865906,-2078023292,1378217507,-1888682773,-963347801,-1777772462,1601868136,-1052958440,183341331,-182486216,1670106780,1324727334,-1588835573,-1682808230,1346817113,-1966367593,-546423599,466281327,-891596305,840174527,1502891917,-598870686,-484780998,1924579756,-1101127073,791674225,2147119182,-517680978,2112945060,1343544822,-1606117035,-274874740,-980249513,1796885031,1046693179,1199559669,-1048477912,713136646,-656560520,211176450,-1738619055,-1486632623,-1901344329,-1188335649,-208208234,-350458725,1438140073,-250886235,-1855382764,1148842120,-903261733,399356123,-271690842,803446144,277209474,2019431689,1704242555,-541286373,1484544299,1459470186,-649773259,1922883835,-463336128,-1714243182,-1201902045,-1415478282,258214922,-1243666245,741275327,733845968,369932405,401863284,1276833006,184038193,-1817177308,1846714737,1477493314,1749334149,1446936049,-2040324123,-1199312249,1492839309,1135119244,1325866326,-567119070,-1614193197,247828469,1973090542,-1303107544,-214531006,1307106240,-1503980649,-256550188,1415355516,250236591,1439964577,-676747768,-1321651815,-1686063350,331998641,-615628452,681040687,241363890,-1789355323,-802747517,82380426,-292504642,469255759,-1294181429,493802076,817967097,-806378286,1586733390,-1473688598,2056810308,1459566871,-621722471,2067993312,-928103698,-1137466644,-177610387,1352845806,478738228,994898423,-1760539307,1799977117,864634462,-563168934,598366837,29546705,-493478048,-563863505,-838263755,1240166922,1455777610,1086452585,-359760434,893805156,-385611025,516773241,1964831353,-1166292172,-480803086,208451903,1541215967,16543432,-1259913272,-874868575,754240914,1331957155,-220023877,-334639675,-515554803,-2048437344,-1619911511,2129832903,-1224125920,889006833,1628098919,-1232667590,-163859595,-710921759,-226683398,-448870971,-909465094,960387424,-1821327906,-628569902,1838372927,-2076556277,784828532,1682651110,1405048,-1021844197,-2036365028,-1151112576,-551294303,-1154000874,-1443502130,-68121137,1386998175,-1995816622,-174059728,-1883603754,1293931660,-1229974501,1560689488,-363280555,-1305837159,1229321635,-1411453831,1398587589,-1010449289,-57096922,409333617,1211199555,-1496719047,-659537434,-673235057,-713961467,41269838,932635700,-1805898868,-1443377851,1118380636,-1269697272,2024982057,1322225663,-1500038724,-1703761853,-1985948766,-816295976,-1981285863,531675081,-586591038,-696702435,-1990794843,533788073,-1732713639,-1438816446,77215881,-1726168977,1460097635,1817127665,1210180659,-77196955,-2072636141,1998474102,157963256,-934373288,-681585141,1395833913,108298129,-1858319551,1187494475,624559268,-674218415,790892757,-2117414162,46465776,-687076305,336297707,811801151,-1832294612,-69774065,674484153,-425930100,-723752815,-1733230068,-1639249140,50495827,1415417854,1212749090,-1424655813,-2142170180,-914221566,2003138155,1746050584,-1699925332,245782230,-1837213478,1754880524,-696195094,2030657390,611086788,1792676124,940088378,-343133623,2067369286,131747838,1410211598,1893775882,-1911200794,-918784328,-1038935808,-591586118,-466183830,305118468,-160648767,-1234943586,1938316561,157854143,1891025981,210349253,-870959432,845607546,1149695432,-779335068,-1857596602,-1453807625,-777581207,2032735937,-1179421381,-1569505487,-266359350,193782917,1799834952,-1231614523,1269386226,274357389,152693716,-1395324566,1978491242,644265316,-780318666,256169449,-1572623863,-753528472,-141208234,-2121472796,-675915200,2126651912,497781886,-1279981797,1907258587,-2109000631,-1556169737,940513078,-336270986,-1213539065,-1423597574,1826877315,-1361457762,1173937730,536461394,-1317686678,-144408757,1943906488,-789394262,1010244346,-1426403716,81660491,-82938670,1901821409,312681723,-176729667,211575203,1907309815,-1399163779,1129776377,-993313648,196296201,-622704985,-1705879540,-462086943,-236737405,496166102,1457332936,1116825631,-256460370,216900027,1034470335,-1960868957,-1420867846,-1900039194,190440629,-1453252495,1216198234,-984661815,-1260603396,56480650,708892377,-202846851,965281179,1908232859,-1468390826,2025046267,-221192236,-1273349682,-1121782090,-397714301,-949193822,-1378629043,559813590,466020767,-1006082036,1312090517,-1492178581,612883015,1238364817,2051404597,1003276325,-1201405460,131502495,-1371212625,2061133311,1253362271,-1007417783,711672289,237290433,955270672,1727002871,-1117605715,1941323048,-2133426058,-1062752991,-1642125676,-1004960253,-197235121,2068220618,-1772793829,-1477717432,370734547,-613844263,496029267,-94633145,-1550198660,1804751906,1944341950,-186234757,-1474405779,-551006447,1627682743,-40406446,-2112173962,1370661190,2065270917,-298744498,980842693,-787586059,483271218,-1846525354,1565936451);
/*FRC*/Random.twister.import_mti(360); void (makeScript(14));
/*FRC*/count=228; tryItOut("mathy0 = (function(x, y) { \"use strict\"; return ( + ( - ( + ( ~ ( + (((Math.fround(x) ? (((y >>> 0) > Math.fround(x)) >>> 0) : (-0 >>> 0)) >>> 0) << ( + ( + (( + Math.acos(Math.log1p(x))) >> ( + Math.sinh((x | 0)))))))))))); }); testMathyFunction(mathy0, [-0x0ffffffff, 1/0, 0x100000001, 0x100000000, -0x080000001, -0x080000000, 1, Math.PI, Number.MIN_VALUE, 42, -Number.MAX_VALUE, 0x080000001, Number.MAX_VALUE, -0x07fffffff, 0/0, 0x100000001, -Number.MIN_VALUE, -1/0, 0x07fffffff, -0, 0, 0x080000000, 0x0ffffffff, -0x100000000]); ");
/*FRC*/Random.twister.import_mti(512); void (makeScript(14));
/*FRC*/count=229; tryItOut("a0.shift();");
/*FRC*/Random.twister.import_mti(524); void (makeScript(14));
/*FRC*/count=230; tryItOut("\"use strict\"; /*bLoop*/for (smaddw = 0; smaddw < 11; ++smaddw) { if (smaddw % 2 == 0) { for(let w of /*FARR*/[, {}, ...[], true, null, /\\1\\1[^]/ym, \"\\u1B91\", [1,,], ...[], y, , window, ({a1:1}), ...[], undefined, ...[],  \"\" ]) print(x); } else { e2.delete(v0); }  } ");
/*FRC*/Random.twister.import_mta(-319644793,-318367245,1454309245,932141478,-1980673548,-1527927992,-1954685299,710316087,552117052,-941982827,-1729112546,1650446696,1980924400,-1181115186,834404477,1077222076,1914219186,100076849,1122100856,2132982648,1420206285,1398181429,1514536380,164986311,1870069101,-367845863,-212737297,-1589104732,-355254969,-1114300042,870924272,-87290019,-738671800,185661507,-568792884,-654159561,-1349930955,-195553572,-859325339,202749454,-60143342,114321433,-395312447,10431494,1471586751,225986645,803145321,-777999841,-359086716,11328304,-1835518562,-1990066261,-1150419213,673005575,1365782108,681974304,1357430007,91073659,-1448846593,-1127982633,-689759025,-1478963312,-1764195303,-1228383530,2089716757,973117952,-1959761569,-1905074634,-1866777679,671353839,-1374267731,2055373156,-448519940,136057049,-1284822859,1717173696,180204980,-265241406,-1511431844,2063357595,1766284148,56273856,-631623623,-1790745363,833804985,1860688141,-2081838926,-915756571,930200832,-46669304,2051986707,-197482346,1254677980,1696242349,1286927342,1582179929,-1263926417,2061545388,-669125819,1573988880,-162165301,-1291438194,-1160729318,2123874117,-1388772479,1745454649,326380684,1367432057,2052449849,644569998,-2089085640,930717341,-1049732106,1400784095,310278243,2145867737,262123932,1893708777,-2127904734,161767095,-1697463828,-1077700707,1585590749,776386586,-1808266384,-879377772,-518231580,-1639017376,-465970117,1025692392,-260751585,748463748,1032153809,884446734,-220630848,-1338287810,-756482417,950576027,1160770100,555185706,-722679626,-1061413391,1472038679,-681014110,-1323879,-834311342,-1338089245,-1130580638,572849049,157280870,1522519429,1738097185,1240207139,1931237464,1861240446,1042213313,602529205,1292823625,-624090193,1277952867,135461986,-1318775480,-1966185677,-1016212753,-1692729340,-1930586238,1530168497,-1999512653,443984552,1404976053,1746124160,-1563408655,-408949466,-1483591129,-2044001851,-1926806801,1588316337,1833686319,-41900618,1580493187,1400496379,1625968406,-1113479006,-778879177,1495384640,-291301259,-54676335,-1049481810,-1335545799,1193435363,1283302622,-835824857,-330039644,-433176834,-2073378071,-934510604,1270303985,1018888875,-1443388850,-1312273717,-806290995,-972523839,69478785,-436714400,1813503383,-319848863,2040905063,-67638699,-1041320443,-1059864869,-765706446,1290308145,-95758108,-1187022506,1496681630,1128608133,-1749296896,695907130,1048563806,-1850731450,-824500324,-1072201729,1274745560,-1470823645,-1695972414,1601113137,1655403364,-597625904,-1812044767,2124714374,-1096440365,-29389134,1596740028,1744325441,-1401978251,-1704986087,-417676287,-844162275,1311835732,811182065,750669753,-83536886,-1637331272,-1215976062,2084336250,-1368956694,-1930024717,-181668928,467796927,947455480,-1245092363,-1114073633,-571197494,-1533006801,-1458905243,1341425436,374851348,-2059411678,268079895,-125428483,-1095051514,1046358126,-348956777,-480187140,830378258,-1726513762,1269280779,2139975056,-909139047,-38875607,-1835941661,1548703877,729103906,-1280594130,-663182451,77145571,748993041,1068685571,997618060,559202782,-313259621,-1541543099,158490598,2003513948,712283626,2135442633,1655582450,-332504904,-1091380348,-280771016,-801360074,-156519167,1113208682,-518117535,269437374,593069502,64018667,1870823102,927128289,900227835,633024631,2116580861,1634240537,-1726396407,19630556,-409083367,1303644996,-1112291188,-2093205766,-1796384489,338379726,373622992,28182954,-1745023673,-1272537529,-2063167148,1229451419,133127267,-798127647,349244586,-2035885372,619026201,1342856643,805620555,-396346919,884080596,1142262079,-647835290,2077993579,590967213,1339863285,1526965065,-1778009860,2004981129,2061756636,-1019367598,321676649,-640146422,-1695339723,385892757,-252146372,256089593,239899808,-794731044,-1002862503,-2125138106,332906835,1714895203,-373690028,-533166125,-1908453096,2067160397,574608205,-1544568780,1224682219,38287623,648444920,855841464,-2062450968,650515660,-693960853,16898287,-922364989,964635826,1548613478,431021700,682567877,-1180128033,796721457,-861399603,-2146744168,-842115222,-833629330,146612913,-2919956,2140491481,-3756055,119824782,862171590,-1390610149,-2092884920,1786078935,1154412121,1681187806,729875983,1486723453,581902027,-1539952873,1903748443,2003052861,1334449164,1807601849,872924518,628680226,1575722196,-1486445994,-640517130,72064371,1345808873,338671099,-425136384,-1646234657,-2029430999,-1822908724,203375617,-408395982,-1150961080,-317286437,1939985352,1771064412,-1790748954,1049486764,861427110,711810986,-269056049,1112610280,-1702780690,-1700958507,1534759508,-1186116347,1030460005,300683777,986146330,-459773610,-2120007571,223091235,1794896029,-1266688906,-1027776707,537093549,392110010,-1668926636,1994256758,-399300584,27035567,-747391913,1915949356,482772871,1275978566,-1154983524,196202398,-1976007884,-1032057787,-1629525354,-845567646,-210860195,-1560380160,1035836171,-1940914439,81696606,1893528405,-1329118147,2068547232,-299270490,-1672971762,-146837728,-1675715988,-1968379169,-211216412,411007703,1858561836,-668782733,-1323333140,-1684116554,-543611905,2069630682,744352236,-2140084670,-2036755799,-1652201145,-1652383227,1145843583,-1452420839,-395832401,-1809678528,1975291362,1247955277,-52511881,531004896,-2033838331,1147974264,884357989,-291023395,-1994677847,-1556822914,1456073258,-624597479,-1770196428,1996325325,647476403,314301079,-723342675,482768860,-2087280820,126008181,352411908,-938645363,282261214,966524284,-1169121093,-1222157628,-837671112,2121241942,1066918051,386694424,-438522969,-1451383803,-2065759953,-539541010,1236544916,481304444,1427473646,1906148086,-495182432,233957898,652210559,668216092,-1942242131,-1018052166,-2138576586,-1265833828,-9040224,875914097,1630320586,1618910871,804783060,-686625407,1549132843,1448154024,1064502628,-1939591369,-632538074,-635774864,-1408170645,770370094,546254587,1269553433,-1242272406,-1728019919,-116573431,-1248292081,1761063324,830407384,74374301,-321035572,831844223,1511554753,-1379382368,-1666870327,1750139156,-277173431,1874651353,-1472819494,296888898,-1640167275,-1484789522,-1367256758,736259032,-525552654,-865344766,909081676,-154455185,1673623859,-689940613,2014199192,-1899087330,-229568201,-913251626,1431208222,1356722171,1032602434,-1483755128,1320526527,1131989176,-220398221,-876755630,506086342,78673266,-1333985103,-1613718822,130386289,-871236058,511326705,-62553112,-1121333200,1635056840,-1701527236,1850756240,-851654464,1461650172,621219770,-164447294,-1643563507,1366570577,-1178342172,-702126210,-2086173049,2064595782,786026642,-1276340725,-1700840861,-1406756664,-1382972177,1266328154,-790317448,-1757085510,-53471963,-158845351,1401372680,-407536965,-1456243145,-585264808,-1323888007,476358626,-449098964,430028280,-740270688,2022889131,-1349624828,-2054667197,1797257019,1427357183,1355101992,1990428394);
/*FRC*/Random.twister.import_mti(142); void (makeScript(14));
/*FRC*/count=231; tryItOut("\"use strict\"; /*MXX3*/g0.RegExp.$_ = g2.RegExp.$_;\n((function a_indexing(yvqyvj, tsxpnb) { ; if (yvqyvj.length == tsxpnb) { Object.defineProperty(this, \"v2\", { configurable:  '' , enumerable: (x % 2 == 1),  get: function() {  return t1.length; } });; return tsxpnb; } var yzitur = yvqyvj[tsxpnb]; var ljpqnd = a_indexing(yvqyvj, tsxpnb + 1); yield  /x/ ; })(/*MARR*/[new Boolean(false), false, false, false, new Boolean(false), new Boolean(false), new Boolean(false), false, new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), false, false, false, new Boolean(false), new Boolean(false), false, new Boolean(false)], 0));\n");
/*FRC*/Random.twister.import_mti(322); void (makeScript(14));
/*FRC*/count=232; tryItOut("\"use strict\"; this.v1 = g2.eval(\"function f1(a2) \\\"\\\\uABBB\\\" &= ({})\");");
/*FRC*/Random.twister.import_mti(373); void (makeScript(14));
/*FRC*/count=233; tryItOut("a0.sort((function mcc_() { var czrqrp = 0; return function() { ++czrqrp; if (/*ICCD*/czrqrp % 3 == 1) { dumpln('hit!'); try { this.e0.add(t2); } catch(e0) { } try { m2 + t0; } catch(e1) { } try { v0 = evaluate(\"g2.a1 = g0.objectEmulatingUndefined();\", ({ global: g1, fileName: 'evaluate.js', lineNumber: 42, newContext: false, isRunOnce: true, noScriptRval: (x % 2 == 1), catchTermination: (w = 6).call((4277), x, ((function ([y]) { })())( /x/ )\u0009), saveFrameChain: false })); } catch(e2) { } t0 = new Int8Array(b0); } else { dumpln('miss!'); try { print(b2); } catch(e0) { } v2 = a0.every(Date.prototype.setHours.bind(b1)); } };})(), m0, f2);");
/*FRC*/Random.twister.import_mti(598); void (makeScript(14));
/*FRC*/count=234; tryItOut("\"use strict\"; a2.splice(-6, v0);");
/*FRC*/Random.twister.import_mti(618); void (makeScript(14));
/*FRC*/count=235; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return Math.atan((Math.sin(((( + (mathy0((y >>> 0), (x >>> 0)) >>> 0)) ? Math.max((mathy0(x, ( - x)) | 0), -0x080000001) : Math.fround(Math.asin(Math.fround(y)))) + (( + Math.asinh(x)) ? ((y != (x >>> 0)) >>> 0) : mathy0((mathy0(-0x080000000, (x | 0)) | 0), x)))) >>> 0)); }); testMathyFunction(mathy1, [Number.MIN_VALUE, Number.MAX_VALUE, -0x080000001, Math.PI, 0x100000001, 0x080000000, 42, 0x100000000, 1/0, 0x100000001, 0x07fffffff, -Number.MIN_VALUE, 0x080000001, -Number.MAX_VALUE, -0x080000000, 0/0, -0x07fffffff, -0x100000000, 0x0ffffffff, -0, -0x0ffffffff, 1, -1/0, 0]); ");
/*FRC*/Random.twister.import_mta(-339730091,-1570199928,266869032,-498055174,-812210565,1539246256,1601922568,476779935,1565381159,-149794489,-1673953425,1219007280,1968996923,1419109895,513239282,173277439,-1315018259,-830049037,2109753428,702169175,708745488,1985506442,615465785,-1814537204,-1108529710,-630773838,-1271103868,1841458705,1401326232,856649573,269576967,-1421787495,-58480301,944991196,1762634512,-1206806093,-1843453066,-17307326,-1787203760,1275475365,-962198700,-516074759,-77082721,-1184747618,361502657,1285242798,789024582,-1193948256,-1288115515,-1414371377,-536488959,1223799135,-908556414,1483269243,-1533785811,-902338556,1972836420,294840238,810939156,1852286164,-650081001,554558775,1125865404,-1987538439,-987536781,764349852,-593034067,248254200,-1235829774,-1570868635,-47077648,-1271168297,1082380788,490702464,929091999,-1405940797,-797946418,-959000594,-1849026960,2126636279,-42733929,-1417423581,1433343404,-2051182597,-1697814724,-279740028,1957053828,-125035778,1750211374,1055571023,-1402886529,328855331,-1928181446,887202656,1657604446,-1617181004,-18429798,-1299910136,2078929932,1781472951,1230105881,1693690865,1544802246,951282651,589190395,2010481424,-1906311744,-1288814885,-152500640,-1463800167,1181449918,-10458091,-1190936796,-1937271918,-202465315,1985108536,1125872779,224692763,-83529989,717048810,1255327676,890792331,-1750813381,-1097798364,-1698893846,1153128323,772537850,-1955938219,1902733984,1981858513,169588585,-778365409,623431267,-1257728169,-2108583751,711333864,1766712441,259855156,805606894,1641921858,1285739341,1809248613,-759595688,1399178652,265618485,-261586314,1512080940,617066463,893065804,-296802084,118250095,559621255,1373580600,-670922634,-373609242,550162655,-1371673415,710093213,1482774912,-1433915525,860938620,1019425460,886422186,2074278990,-1329727314,-1756132428,1266682493,892692684,1041864475,-967258121,1106276721,646018957,-1709423049,-409898113,2014617632,-1192692168,-321547536,-870535256,1034895692,-1365376156,885347065,-1364339488,1846654366,1800759377,1648935619,-114535578,-1661168321,2081683699,-1678934938,-1129704621,-800074276,-1156237422,604511619,-29696495,-1844149192,1658462378,-702478373,-1388823101,399176388,2102872766,-2130464519,-171740019,-2129611717,1973183607,56203047,1212934787,-276174929,689659301,1847881480,-1778513220,167035806,1856121978,-1154824688,-978732936,1706539333,-1161101575,1222246015,-100359421,293191643,-1265773970,-2121148021,-898378392,145388813,644560602,-1548973256,1636863642,1486094082,993502106,-583340469,-1984791778,-1655734109,-1610576219,-246702641,-800843795,-934520756,-1211629320,147680278,-81658811,-913510377,-99936968,1763134466,1369657262,1368839742,-813674288,-642399098,-1565266702,1397733815,-20502512,1784999542,-1488764644,1411163708,-753453513,289374586,2041684457,171453855,1487759634,831553780,-823881133,235569208,-1545682224,1736212459,-979455996,-912134195,-895456257,-226732147,1772226442,1941996397,2068406855,115508530,724016945,1313682179,3573968,1431234617,-634163617,1670506894,1013057298,761510801,-37819193,1482412464,1719284624,-1821466362,-533895458,-243076822,1621971633,-1220643563,16966765,1483773064,-2043027243,1454114347,721767463,1809185702,-1542555194,-2079805709,-1801412494,526437415,783705944,-1784722118,2140699487,937886581,-883492592,-1155330911,-1629739700,968302360,-1864005344,1813024317,-149941294,1612185777,-1125255702,2029898103,528135243,-1902122093,-1709546519,2108012536,-1212302728,-1173401004,-1778822212,-1542085983,492819024,1508993398,-1908333480,-6563789,-742353056,512824270,1407083689,-388231710,-1058308020,1184790020,-1380677389,-328752136,-487250077,-1942353248,672958597,-1793197813,-1288828498,-1833899662,645366795,-2077475684,-1843766277,770243584,-2122319430,1378807217,-188164723,1577252054,-1206976392,1305407928,736509581,-2136053884,2114862870,-603153731,-793043529,1510175581,313243283,1431091097,-746792880,323382281,1647990620,1872842637,143853597,-2097668999,-1754201847,1820380159,1071368583,1993966001,1198202826,61176950,-1118064301,-469672974,-2112560374,-729134244,-1833117420,897773097,1760750978,759079921,1707687642,-1039812500,-1815020185,-1378019301,515736204,-1361188651,276800284,875596738,1389685525,315662640,586538849,-1625991684,-801216966,563841071,-756800754,-1636198667,319860908,-680221491,-1430382051,-2047870811,1702216727,646330855,1391504096,494252433,-253528742,-1247928913,-1454886473,812251727,-1567048853,-247154338,869433391,-3637199,1612553320,1092483158,1293269789,-1704594738,1689263853,873699975,2078599184,-333775693,839869959,490435079,-1767003119,1760302310,-1108173578,1052451279,-474651538,1875142606,-1888012491,1352012801,267917106,1922465805,-1145062827,1734911109,2035658680,1019901572,-1967178778,2078244317,2016898972,2085781135,911152295,-1716897967,389932958,43383200,804401725,1932918964,-17686049,-1061815838,-1652486216,-173716558,773139150,448483442,1074168155,1935388468,515806760,-2011390265,-1446200200,-1493162981,-569816984,1451504073,381141509,1084757002,-1825201283,1441578670,-453309615,1966572305,-970445223,1700606091,-1866228550,-100190941,-32944842,-2037384408,-543030047,-97294823,-1286392439,-2039919662,-2040580125,883881904,1410047189,1334793722,425625111,-2078707999,-698516977,2403448,466589900,1232899434,1930025030,-85848956,-1537001554,-2060973799,1611326155,-1518311610,-1168079893,-387925046,-2062938158,1339939458,1509208665,2044300918,-1138791325,1751730220,-1458999800,1909052101,-1142128213,1666114654,1384172989,-2078906286,249382235,-1120240189,480650021,-1163835492,652576029,1448610251,-1779584147,-1122171944,-58392079,-2064158700,-2425196,1244106950,-1880050578,809298621,512254349,207530165,1162220453,-1274010962,175971195,-464679587,-565257539,-350509278,-596456128,505429181,1017688750,1751415477,-2056862358,1014283226,-1878293131,-2124044290,-1500661668,-37513421,18735621,940581304,921531814,899863112,-1004497628,92308222,1528240724,2140425906,-1100919136,-1010408778,-1565469896,247893293,-1837427769,-593685200,-302651703,-1734016632,683778312,-1477961750,-1339754827,-1123508198,-54048113,-2009950867,-796376431,-32801660,-1155069091,-1224469873,-1133751463,1311340804,-838187219,289611974,2052646196,-1810948247,-131390896,-1786951948,-842480572,-440956719,948546878,1169068719,1086641527,-1412900676,-1281585096,173693649,550021602,466673087,-1827030178,-756865266,-617266214,1564736510,-1884896258,-176937149,-982269906,1545115304,825599893,2015983225,-1884128025,-531028159,1243525023,1414809849,1683621484,2087862827,-710322257,1290345124,-119493248,-385363787,206649536,-281328457,586024544,-401861032,-109474273,869954238,231066308,-160584630,-2052111577,1428095697,1237144216,-231536401,1576217542,-133765481,-549343500,1283135437,1586916383,-1643366965,319172025,-1640695310,-1215711195,-162436314,-1061975345,1903331555,1768469479,-688608713,249864819,1772186005,-1315106332);
/*FRC*/Random.twister.import_mti(251); void (makeScript(14));
/*FRC*/count=236; tryItOut("a1.push(b1, f2);");
/*FRC*/Random.twister.import_mti(299); void (makeScript(14));
/*FRC*/count=237; tryItOut("mathy4 = (function(x, y) { return Math.fround(( ~ (( - (((((y | 0) + (y | 0)) | 0) >>> 0) >>> Math.cbrt(( + (( + Math.atan2(x, y)) % (y >>> 0)))))) | 0))); }); testMathyFunction(mathy4, /*MARR*/[false, new String('q'), false, false, new String('q'), new String('q'), new String('q'), false, false, new String('q'), new String('q'), false, false, false, false, false, false, false, false, new String('q'), new String('q'), false, false, new String('q'), new String('q'), false, new String('q'), new String('q'), new String('q'), false, false, new String('q'), new String('q'), new String('q'), false, new String('q')]); ");
/*FRC*/Random.twister.import_mti(500); void (makeScript(14));
/*FRC*/count=238; tryItOut("mathy5 = (function(x, y) { \"use strict\"; return (( + Math.min(Math.fround((( ~ (-0x07fffffff | 0)) !== (Math.asin(Math.log2(Math.acosh(Math.fround(( + (0/0 >>> 0)))))) >>> 0))), ( + Math.atan2(( + (( ! x) ** x)), ( + Math.min(Math.fround(mathy3(Math.fround(x), Math.fround(mathy1(Math.pow(y, y), (x >>> 0))))), x)))))) ** (Math.max((mathy4((Math.sqrt((0x100000000 >>> 0)) | 0), mathy1(x, x)) != Math.hypot((Math.pow((y < 0x100000000), ( + x)) | 0), (x | 0))), Math.trunc(Math.pow(((x >>> 0) * x), y))) | 0)); }); testMathyFunction(mathy5, [-0x080000001, -0x0ffffffff, 0x0ffffffff, 1, Math.PI, 0x080000001, 1/0, -0, -Number.MAX_VALUE, 0x07fffffff, 0x100000001, 0x100000000, 0/0, 42, -0x080000000, -1/0, 0x100000001, Number.MIN_VALUE, -0x07fffffff, 0x080000000, -0x100000000, 0, Number.MAX_VALUE, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mta(-1579735522,-227929797,-1738534326,-827713107,-817414349,-554104230,-1527793089,1214700029,-1029962732,-1777731778,692187781,969081612,-671982287,995634942,-406431568,1843230874,-867898207,1675318829,457719013,2113099886,-2032227661,-1243336564,-363247000,825422119,-498817812,176696131,-535719707,1532347713,993049912,-160914983,-167935957,-612166926,-694776312,1331210325,-46722150,895348532,1228201990,-753499911,-399094381,566687754,-966513762,-1752344668,-1572653552,326845149,-1144221585,-500790255,847236894,-634415665,-1932066205,-1705904661,-472973736,-1393500922,1559264922,742568018,-1156383638,743423467,511619538,1484975488,-1543081705,-532395782,762661141,1421486287,1541723770,-1631309459,-972809612,1297876906,-1183888822,-1650153775,394628364,-2069121695,1883653181,-433544408,-2000620381,-1240060000,-619009557,666333981,2050351584,-855874087,808794283,-1483346964,-687422846,600508348,-387981468,-1216037094,-741673108,-8705061,1548545972,-777426223,1008561427,1742264362,1439582364,1230306847,59007977,1220479705,-1278046407,387591265,-263514356,205334723,401849903,-554786291,-101603174,-1440772175,-1953742743,901637985,659350189,-1114719876,-428201297,757893883,1485116670,-567755641,1513981732,-663310458,-1181141155,-1428656137,-187065998,-2001084377,-2127391649,-1462456553,270054992,-1854324368,-1980129439,1989633823,-2130269137,-1505373993,656922206,153469504,-1609211301,282120165,662574301,-1603153743,567197349,1257861136,620839720,635695024,1412360689,-1782684837,827587644,765499583,-187806843,-1160160377,-134950343,1456009246,-673993618,1562660979,-1702587901,1675021883,420508919,-973039594,-623742297,1110154336,-1587248236,-1895333514,-1675251058,-908773783,900371007,103076846,480863872,-767831996,929803327,-290692559,-1576154621,1413719121,-203736822,152951953,837886190,1757915784,-491678154,326712742,2011960160,474415286,-1295931865,-777518741,-1442522089,-675116884,-1343689948,2083558313,1187446326,1158118681,-2074690836,294207149,-865883734,709566769,587515657,1566111485,-102372963,-1955697432,-701174989,1977600074,1223673233,-2004955729,395588694,-1621559577,-1034954309,897056823,-1530640390,-17749610,930350014,-1562203689,855285151,1991388180,-1056502535,831323290,448728315,-1417803278,-1326936230,1487007554,1210735914,1645032789,1128421318,-1228314336,1789017595,-443316833,-1114279224,-1482130512,-621042756,1667791403,-1223897881,1333827264,-1378922222,798046012,-1517657989,-1406205254,2052925578,-954011733,2116871486,1172870676,-1408843735,373481956,-1229771596,1338991300,128118304,787104011,802402675,-1060530663,327342465,-2030390753,848411075,-728810927,1153862032,-1552286928,327780649,-821218385,1243435250,-1600254238,847421524,-337162015,1116785766,-202580600,-1505390590,-2141775498,-2119050525,-1428462511,-1353168024,2080716533,1996714440,603520322,1209161775,-1292320713,-898862182,1008730402,1838674007,15684771,-922392044,-1459455201,-1480096964,1222556922,-2056586762,-988452601,454437091,476913486,325060277,140727468,1446480865,1136081881,-1004628410,57569140,1032205143,-1880942976,-1613904690,1430728217,1549009725,-1009548033,-988699540,-1662436473,-2129973399,-2009187501,2052065359,-550765857,-667927037,1846422441,-1933374066,487128530,118249363,1876401286,-1962961539,491400081,1651456017,-222464680,-1014767712,1280950828,-109560570,-2017384857,801486733,-1791683039,-143365072,-651065300,-1176301287,846239462,-1249972922,1989712498,1669414449,-1390924656,-458885401,21710494,-1688878321,-148960100,695677186,2033646631,1316252723,-448708817,559890793,-57014562,-1476546838,-1004203523,1816717541,1958511917,1362908843,-1883080346,1114483935,-846117575,-121957380,-1261785353,-468075093,-1356702186,-417335263,1519585968,237838757,214563108,-657894565,1233580378,162837998,-1680284903,-1799462885,-405410685,607060110,273646994,-293708037,1056400096,-2017306341,1963959646,907590465,-1802945203,547073640,1891558528,567141451,-1985608764,1026614368,-1178992570,-1740029877,-901147128,-1559839828,-162883082,-1240732482,813777415,-1442451255,-2033260932,-70047230,-1649281129,529964180,337275813,1767712434,353596196,1362252118,940746945,383800954,355749493,225795366,788711201,-952610568,-2042759313,2042098492,1019396775,-1906930559,321113214,-1171987623,-22095625,-941722698,1949938086,499907591,1097456563,-984981184,-368153501,-2089420708,1761229338,973170902,-530678921,607566363,1896224815,470067567,1798869487,1602643398,-682969205,-1127128223,-534114575,889828141,-1529329977,-1374989316,-1051635507,-1055154536,-1610237291,1621787381,1457530651,1264676660,1101128431,-410931555,1016713186,-1769503788,-775875474,-1367194416,-1246893476,-1412748430,1434975525,-116579825,-1757940889,641057826,-666468606,1243151304,-547211333,886268265,-27786550,-1754939844,399048898,-628173362,-570952099,697550490,1107864342,943243489,1396260257,1138894255,-573600199,-378995604,-1607924123,878899020,-1169070882,-158636366,-1805482360,550403112,948740039,-121021306,-1328182696,-1473885281,-1939452667,-675559479,-1940731348,-2033155963,-599428125,-457549901,-466509961,-1795758344,-998925847,-928491452,-141954097,-100789116,1909867607,576096510,-1596487101,1675153707,1354575040,355080321,273296170,328429655,356846249,2118165301,-644559927,30068816,-430455234,-1917790960,-1525703594,-1822455694,-1842787030,775204130,-1398815333,-889897736,1523739532,1992306973,-1105449345,2124744395,175709462,-1256342192,-169235153,772111857,-739039446,1549405182,1686544459,1105959181,1790008012,-1406809777,292237980,-704297250,-777910817,-1796433260,-649185912,-921428699,-1885173907,471695337,-1052555998,-1307763138,506444599,-1136723019,-1610454001,-1693359696,1075702504,510835530,-445125430,1686127570,-1036505260,-1304946997,669875199,-349757357,1921090562,32438822,1558658044,52327110,-816466540,-267511827,-1648786867,-581652407,-1177882887,-729286071,-936588085,1286821884,-344163092,-1035521281,-1556973507,274783348,-138499015,1527977816,1548425576,-1305965632,-2058958916,1343434498,1161704774,1730819488,1194965914,-1765490788,36105463,-1323176021,850086556,1031851355,-109445401,592315493,-1319562612,-2047863622,775547113,1264143383,-2132339385,179297354,-1615876226,180829630,-1397215800,-1844564852,1947256650,646355864,1150517983,1781373702,857352172,365045701,-1301590938,582105469,-2124805051,-1105484641,-133522119,2871651,2057208059,930856783,-290207076,412419251,1488537278,-1822794574,-1020719850,302449815,1338093343,137650385,-1741885565,661360362,1902994228,911110424,270806799,-999843136,289045876,-2091034353,-864977509,-1161908036,374895239,-610702345,-1325167088,1164798101,1566256542,-257489676,148858889,1055935907,769032287,-823435463,-17666927,198995565,1730765904,-389782900,-591646552,1398937053,1902360504,-1520416082,740968803,774209268,-926675121,-1225400981,1726171540,-1204244981,620467694,1202881871,822549912,-1233069060,-1747358525,-124718203,1960651028);
/*FRC*/Random.twister.import_mti(293); void (makeScript(14));
/*FRC*/count=239; tryItOut("mathy4 = (function(x, y) { \"use strict\"; return mathy1(Math.atan2(Math.fround((Math.hypot(( + 0x080000001), (((0x100000001 | 0) >= ((((((x >>> 0) || Math.fround(y)) >>> 0) >>> 0) | (y >>> 0)) >>> 0)) | 0)) >> Math.fround(Math.imul(( - y), y)))), (Math.cbrt(( + x)) >>> 0)), (( ! ((Math.log(x) | 0) >>> 0)) >>> 0)); }); ");
/*FRC*/Random.twister.import_mti(479); void (makeScript(14));
/*FRC*/count=240; tryItOut("\"use strict\"; mathy5 = (function(stdlib, foreign, heap){ \"use asm\";   var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    d0 = (Infinity);\n    return (((0x75180971)-(0xfcfb2d88)))|0;\n  }\n  return f; })(this, {ff: encodeURIComponent}, new ArrayBuffer(4096)); testMathyFunction(mathy5, [-0, 0x100000001, Number.MAX_VALUE, 1/0, -Number.MIN_VALUE, -Number.MAX_VALUE, Math.PI, 42, -0x080000000, 0, 0x100000000, -0x100000000, Number.MIN_VALUE, -0x0ffffffff, 0/0, 0x080000000, -0x07fffffff, 0x07fffffff, 1, 0x100000001, -1/0, 0x0ffffffff, 0x080000001, -0x080000001]); ");
/*FRC*/Random.twister.import_mti(571); void (makeScript(14));
/*FRC*/count=241; tryItOut("testMathyFunction(mathy5, /*MARR*/[]); ");
/*FRC*/Random.twister.import_mta(-1858363283,1345626186,-1788531226,-1590867328,-1204407642,2007895713,487707344,340242727,-270746280,1671633505,-575614645,1944715487,-39211542,1397337773,537828182,-196367941,-1455097562,1932329008,39871445,216032850,-1959588824,-609295900,1950097936,-1695975164,-1983162277,1343052450,1670750488,1001233086,2054856497,-1443984638,-1297891646,1603806829,16574015,-1442957327,1298659160,-32201267,1836320510,-998223732,317445907,453694766,419403379,314818215,226140040,1837499524,1211297970,1834813635,240000742,703092572,1078119586,1361642244,1861546308,-1766759477,-1493904783,-1246808662,1128866607,-662397152,-1609319188,232458449,-1402513506,721961958,1466186703,-1190883899,1377776000,-1414900354,-1859653606,-448155231,-1509120032,1771327096,998957100,-2097986582,1672052052,-935144945,1262566650,-417950595,-543816712,1129993157,1726106106,-1059521318,-174246968,-432819119,-185983096,-1489999936,-907341145,1204934292,1244324009,-1529656542,-351375813,-1312409781,-1913634198,1413620357,-1210330426,769080443,1220450460,-1360753998,24543685,1686077560,-1148156683,-753207611,-590431467,-790815486,-580106853,181130805,309610160,507665181,-947295946,589412525,1077703375,811595158,2002758590,-552346196,840232180,2046480580,1818684203,-511857399,-1656116700,-941407814,672467870,747378938,-897282068,1875667364,-978421585,1923925659,-1196696394,1383928073,1484118748,-1977846988,506815161,2058988892,344578762,347824068,-1665771791,-972596259,-623035629,-5467173,2024537502,-1695626015,753566909,-1290843799,869970213,-1176383845,925852007,-1715380745,1927044954,-1000745252,-1377967484,-223691004,1681520529,1654994448,1664295623,-1584157087,1965591079,1938953244,77321484,-527172187,-1303676037,-1952143366,119800011,-1981535529,783914112,-1029600876,1820773769,858431803,1899918175,-1963541253,1081283086,400445571,221191180,1373344438,1027188663,-1784003575,1136131084,-289871959,-356825069,-370159347,521823282,591965816,-1055551832,894493241,1065346325,1050988646,-1802213639,466653161,1955448503,-1208139642,175544683,-98130537,-490533978,-1709908739,-329599684,2105830195,-2038373213,1011402434,-762393168,-1858110734,-1291196080,-519786141,-1641965901,468489703,-1973774310,-52011466,94196691,1693463126,492858608,1719929358,1099331582,-352423508,1459373796,712852878,2085474496,77450414,2004697784,229158073,582453856,-937583760,-996752215,-1398036392,-1358674897,-1609402910,824955402,871706345,1928074419,983306506,-1952523630,-912873117,-1255331895,2006655822,1073502694,-1973275081,936579368,-1766565130,793828058,920083136,-826116750,-841478449,-1909303049,798806374,-789825642,-1076652669,1649868103,761649569,-305690715,1157641007,-469455158,-268064500,-539617121,1663567334,890636438,-669924311,-1685754529,-1377009730,1452047347,-563642897,-1224249081,1477712380,710009887,-948239367,697981894,-678066417,25700092,-1354780981,813772159,1776632402,865937565,1050134368,-1594945807,274639848,-527904398,-864275747,485830912,-1648219123,1773645522,-98466403,-712104464,742479301,1751081190,-947296810,1457031236,554832675,1696220184,299262768,223233802,566358297,267956796,2040437639,-791894617,1212670822,-1651175850,-1569418223,1460349134,1417590599,-449959017,195652364,-761102366,981196161,-1103500433,-1816802053,-1146226362,40407684,-1368509671,2013078137,1040103313,293365985,-792172534,492339170,-1405077300,811862939,-1089732830,-296392405,-595842311,1629699424,1365098716,-1586451707,-461969299,2141994851,-901140219,-649340181,-237900727,166286336,-2038492365,-2129032969,-1867937315,1384666800,-1620723623,1421623384,1884030092,1834492063,-683925071,626139947,-1257520010,1848233806,-584074055,747439932,1957730214,-1430569472,1561751758,-381580365,-646504130,-2022115962,490317929,1757196764,1972989018,1310599926,755042084,2046987225,615242291,1689456718,817354964,1598547197,137040948,984560073,-1053737104,137891304,-1304231564,-1747247037,2120920254,1242671354,140926951,1234847243,-1557950247,-1956747579,-2071339232,598608833,1537662269,-1595880442,-261604777,1311974436,1848739215,2028220205,180672762,1181928451,-825200818,-2059089361,2007718843,1867111596,-248012299,1703513172,790265134,1454678619,-1450942604,2017471634,1744448553,745049572,-1036697147,-2093039176,1874589299,1297526107,-1195552441,-76840107,-1969816515,1402684415,1727609365,30010912,1671646606,271558759,-117694510,-165000603,874641601,-725804956,1110187905,-981959952,1531066903,-663067299,-900392481,43640801,-1103859323,1752845547,-955987745,-199644747,-757407108,-1647298798,92660692,801517297,1140778047,1208708151,-1000850676,-417762090,358932740,-775829813,1721644012,-2023008247,1660171455,377997448,865597455,-851741534,936356454,-279517698,1247802676,-956542024,1541157683,1456649198,761301615,1824595225,487406173,37070249,192483333,-111607697,-1274420575,-813375312,-1169695878,1443099734,16885917,-1633176817,-1316808137,-733874314,-366791002,1632431134,-1229205035,1317583600,1660343334,1183141762,380452670,1207465202,833767000,-442717829,2101886745,-595162578,2107909522,1697360294,-840620309,-1432987312,789858295,-221424971,-830520430,-1043893271,917561469,-1968036595,87773121,2119842618,1294280378,1959110206,1672453255,2046753242,-689254179,1978884286,-348510410,-581105705,-9719403,522436554,-1754014854,-534960234,-682406930,1328249443,-1441647041,-1947012201,1368596719,-405662394,-1442635712,705688535,-1978063846,-40425798,393106677,-826143986,-1156232430,1500884267,-115040325,-1813027464,-713575101,1119161789,200816557,-1611110214,1088835329,-1780621653,424711871,-2116122769,28553650,1008519943,-943124876,-1973843441,-389515327,1114637028,428895987,-537528318,2063340803,-271241281,-2090302533,-1759538316,-1635730841,1236601697,1927915789,-766180623,336085119,-1078537716,-1273031119,1520583279,-709041283,1506597858,-1307515430,-826934678,-329073061,-1231961100,686178708,1416302956,-118126758,-147091176,1283624936,-1309302443,1325838804,1212777788,-472659749,-1937801236,1563633088,-102978603,-86571226,-88886393,-772631900,132600889,-666096199,392257455,-147056356,1472858804,1276168478,850661073,-1555274700,1805137765,-1138157225,-262395309,1644042481,-1739840922,986780120,1035436512,-793551451,1314209026,1375795715,-329126723,-1628051856,-1898968236,1904809967,-1110917061,-675570677,-352033356,-1626376806,-38370723,-1057693460,-1308444756,1746796979,-580311374,385061526,-929296087,1772915555,1648899040,691226387,-478663671,-552636444,1540593810,1898772369,-1207654315,440713629,-1497755072,1798518139,-1023360667,1607516692,-1388879351,-1676169800,-621444949,543549477,-243606417,1759468236,-159126220,1478741748,-237253195,-525718436,1330298550,-2080896317,-201524537,1696600179,-1645842894,371078342,-1757178344,349787704,-796564334,1277384150,2024360201,-264496605,2060390189,-2011551841,260185063,31885576,-601307027,424304876,2028150896,-1026838823,498915023,-1941643537,-1514891224);
/*FRC*/Random.twister.import_mti(17); void (makeScript(14));
/*FRC*/count=242; tryItOut("mathy0 = (function(x, y) { return (( + (Math.log10(Math.max((y && y), Math.fround(-0x080000001))) / ( + (( + (Math.sin((-0x080000001 | 0)) | 0)) | 0)))) != ((( ~ (((Math.fround((( + (y >>> 0)) | 0)) ? Math.fround(y) : Math.fround(( ~ ((y >>> 0) >> y)))) | 0) | 0)) | 0) | 0)); }); testMathyFunction(mathy0, [0x080000000, -0x07fffffff, 0x07fffffff, 1, -Number.MAX_VALUE, 42, Math.PI, Number.MIN_VALUE, 0x100000000, -0, -0x0ffffffff, -1/0, 0x100000001, -0x080000001, 1/0, Number.MAX_VALUE, 0x0ffffffff, 0, 0x100000001, -0x080000000, -Number.MIN_VALUE, 0/0, -0x100000000, 0x080000001]); ");
/*FRC*/Random.twister.import_mti(218); void (makeScript(14));
/*FRC*/count=243; tryItOut("if((x % 5 == 2)) { if (\"\\uB47D\" = (4277)) {String.prototype.padEnd }} else print(x);");
/*FRC*/Random.twister.import_mti(330); void (makeScript(14));
/*FRC*/count=244; tryItOut("mathy3 = (function(x, y) { return Math.min(Math.fround((mathy2(((( ! (y >>> 0)) >>> 0) | 0), (( ~ ( + ( ! ( + Math.fround(Math.min(Math.fround(((0x100000001 ^ ((x % x) >>> 0)) >>> 0)), Math.fround(y))))))) | 0)) | 0)), Math.imul(Math.exp(Math.fround((x && x))), mathy0(0x100000001, (Math.fround((Math.fround(x) != Math.fround(((x || (x >>> 0)) >>> 0)))) >>> 0)))); }); testMathyFunction(mathy3, [0x080000000, Math.PI, 42, Number.MIN_VALUE, -0x100000000, -0x0ffffffff, -0x07fffffff, 1, -1/0, 1/0, 0, -0x080000001, -0x080000000, 0x07fffffff, -0, -Number.MIN_VALUE, 0x100000000, 0/0, 0x100000001, -Number.MAX_VALUE, Number.MAX_VALUE, 0x0ffffffff, 0x080000001, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(569); void (makeScript(14));
/*FRC*/count=245; tryItOut("f0.__proto__ = h2;function x()yield xArray.prototype.unshift.apply(a2, [o0, m1, m0]);");
/*FRC*/Random.twister.import_mta(-1129887679,1218349426,-1779507280,123282244,983945938,-992087881,-1850568787,-1982189783,-2136772348,1892946085,350492933,-334613367,1836863643,360885887,-1930736909,391944364,832433199,1549843001,-513193985,285042448,-1139362247,478159588,-1977621365,-1088870323,2122409433,39659651,-789726723,-1812310751,-73293697,319695445,809037905,-1028984589,-618325815,1272148419,-893124832,1807169826,544574959,-620475565,-186881288,561944903,1609404220,-1124428610,1623258644,622383300,822183857,-1230760636,-1061823272,-905817865,1238920604,-2118014601,-589775926,-1467740735,475190615,-301916554,1807367010,1639684142,981048780,1803261142,-1996313635,-820082518,-526295141,-1528119765,-1086098449,1736949754,425802426,-1653010334,-1257417515,729124971,-1949596424,1961881963,-1015815454,679852231,-565814049,207920507,-2124717849,-442764256,1436491475,-1846231342,927755552,-2061582767,1287359530,1787749110,-2081043236,1800309605,1564663794,1184739837,1243175149,392888794,352040155,-1309751005,-437461707,-1371117484,-354065437,-824335160,-50476238,1070971319,-1443862890,239825646,-75371527,583608145,-1629989256,46273781,164754923,1663237018,1564848674,-1606017273,-1712226908,974939245,328541649,-1631356914,-1230708115,1207153291,-339319617,1463073761,-1140565793,787910860,-107797566,-1507146675,-520509530,626996975,-1444161293,1857832790,576928426,942845201,-1162286186,1645025202,1744737473,-537391592,1402041344,625180285,884926299,402952973,1347369670,1421066075,-1072379965,931689947,2008319347,-1939380315,873330375,-1919307336,-576611560,-1698830474,-1370254206,199087234,-2138442665,298011697,-874436465,2036577048,-1910098986,1003542645,782783905,-177081446,-24427335,-1942109060,2003197228,2044122254,-161312047,-344599785,-787681639,-1900687638,416399908,-1689872216,-1580961982,-1333078878,-592271972,1419211781,-997448218,425821556,487430543,273869289,328991536,1005488349,117128685,-796768381,-334310047,-528603208,1906472559,-290896922,-1036300671,-2051993291,477947394,-891103001,2042008483,-184501383,1197723165,-1368462793,-1882110413,117550351,1607347475,-2146696429,-123834079,1114919843,-1952482276,106182332,1153272423,1242551870,235633287,625517608,-1895173260,-1290189830,-990120929,1452537996,-1030109006,-1066854493,2050328160,-393860687,-423471104,1527183379,-1616344987,765498778,144666779,92443400,-192173782,-1218410659,788307237,1052149995,717632988,-795881830,-1888469940,-1583860850,-1050230552,478481829,-2061450210,22384098,1718699880,-1816464868,965555180,-414269227,1136960521,-1035554083,473075236,499443819,993609487,1336087305,-569096294,-1462408497,-1238013253,-54012039,1672767622,-1030282346,-301332681,-1092018794,1868450858,-948023105,771012810,-69057612,-1510132261,1759293513,1249254715,2018601389,153232997,-1140167291,1851204733,1557003053,693068802,-1351840356,-1580443379,1895621423,1279104841,443367081,2132922602,1241897905,1962728082,-1458914744,-1825890649,-996670911,-565694218,295114684,722678375,337322365,-2130664747,1539741001,2039222137,-191206229,-372841956,582232510,138416185,-296379962,-1603322791,452327122,1743345189,1816552060,-998480590,-1961394240,257451365,-2016924426,120353405,-1960522756,400381271,350017275,575867516,808453451,1498173053,857280957,-72890679,-702711717,903591977,1296845745,-898393820,1504819144,-1647175212,-1455467294,-1422406703,1136591541,1355680704,684298929,1799141915,-1148376695,438271046,-1420088142,-486642120,-1234101477,-1606213997,-164286288,-490316688,-182717920,-182820061,2145117299,2009210096,1001986002,-1483108464,1783080897,1435212187,-1848220464,-1578118530,1226263550,-379025893,-2074233789,1977021266,-1102144664,895776772,1730017777,-1256488953,-142981693,-1749806741,2133767502,-578878771,1630570118,1940777573,-787819886,1882959514,-1434133683,-1962973697,1926135300,-1804383126,-123581492,-1812695986,-1375841559,-354193555,50046226,2083433445,-1550226644,-1326958772,416006814,-84878747,-827659476,-1735987801,-1138253848,-995946320,302765398,-1670641052,1959729538,670569432,-1769461625,-344001097,-1709341473,685971185,-658245787,546058664,-1992580315,-797507254,1649731925,644325991,1785874602,195523890,-1716843199,-1987954297,980056603,-1991121453,1417601650,-1710652786,-814461679,944354386,414701879,1423324517,1415247589,1778958239,-997061403,1803782536,196100759,-1334959182,-312278181,-980938519,-118347249,-75755367,-568994512,973891035,-343753681,424850853,-229470151,1706542578,271640913,943350935,-139395470,60609868,2024905265,1723168048,1964087100,-2079669394,997483081,2079005918,-7074595,325315827,-1375904843,1955403620,360471953,837046441,-1949210409,-657895560,1676531356,219665144,-998324545,1821535343,1441574836,316921559,-366605842,-1872270810,807230809,2113577339,1294024026,1862347248,-306467951,1888766906,2054578397,-22886149,1554303466,1247995330,1438424358,1854105891,1828965819,557575685,-281698079,1419146064,1607970447,-1607878507,220554361,-958632202,-266491141,1070049892,-1904845951,581547931,2124964932,947656318,-568222529,-921860670,1024898752,-254581234,-1547129458,1217381571,-172239829,-271775092,-1188305325,1363043300,1952819802,1620473120,-1205764167,-38126069,-929524630,-2071212407,-947834186,-75420590,-1618386821,-2128874517,-1872746944,-1619360899,-1395952338,935376456,43764696,-872087986,100565386,-1571752253,-1521561662,1939686536,1343060389,1125509516,423364457,-698189923,2049786599,885934316,-1505542089,-1905541169,-828261586,824861707,2077413364,1482728704,-660580327,-330754180,502532572,1413128468,-2131257306,1736192801,1013324188,-1152132394,1218037984,1767066778,-2087994525,-959347958,-1970938598,226386702,1371333268,-1527938111,-349249733,690621430,-544177281,-1062534586,-1047152453,-384900204,-2110820827,-2146290452,-1975460195,750942395,950074638,574941619,-2045937336,564799040,-746853431,1055607549,1928066598,-227035880,-12260581,1770686979,1823787117,1398037053,226360815,981420540,2107385004,-1887441364,1243560586,-263281427,-824537997,1406391685,-1615994909,290102076,-1646056847,-1524564304,-1024673037,-385808166,-1677229282,27435675,1938029844,293917543,-1337335708,-1512841069,1853143663,1702564277,-1675538443,-1301771685,1745678568,2043033857,71998986,-1873749182,666688693,-803802161,-1845104139,643334956,-1839083187,1457914448,-2098278336,-553195113,-981934286,-1793224715,-200721380,-1583149030,2129904712,-2092252752,-1583700442,-1078125223,-1846518133,-1833078052,1031349274,-1333828539,-1787335273,-1555880091,957884080,959281949,277463201,22469750,1895636998,-867710481,1209037522,421210460,-1519049877,1852830805,-505851332,2037787021,1424202958,-1300605505,-1134107088,-1011761328,1446163529,232200177,-1823227764,2036187389,1645904225,882461954,-1033961552,1608460670,-798676590,-415826088,1582833337,-1108619924,-171931477,-1338654292,-150135665,442216905,1802554636,-1129539970,-53799996,-787311773,2112190298,790950327,1683410737,-1932551900,-44601052);
/*FRC*/Random.twister.import_mti(34); void (makeScript(14));
/*FRC*/count=246; tryItOut("\"use strict\"; v1 = this.g1.t2.length;");
/*FRC*/Random.twister.import_mti(50); void (makeScript(14));
/*FRC*/count=247; tryItOut("Object.preventExtensions(this.i2);");
/*FRC*/Random.twister.import_mti(60); void (makeScript(14));
/*FRC*/count=248; tryItOut("var b = d.toLocaleString(z);(window);");
/*FRC*/Random.twister.import_mti(150); void (makeScript(14));
/*FRC*/count=249; tryItOut("t0 = t2.subarray(/*UUV1*/(x.call = Math.random));");
/*FRC*/Random.twister.import_mti(199); void (makeScript(14));
/*FRC*/count=250; tryItOut("\"use strict\"; /*infloop*/M:for({x: NaN} in ((c =>  { p0.toSource = Number.prototype.toLocaleString; } )(true))){print(x); }");
/*FRC*/Random.twister.import_mti(358); void (makeScript(14));
/*FRC*/count=251; tryItOut("i2 = m1.keys;");
/*FRC*/Random.twister.import_mti(372); void (makeScript(14));
/*FRC*/count=252; tryItOut("g1.e2.delete(a2);");
/*FRC*/Random.twister.import_mti(388); void (makeScript(14));
/*FRC*/count=253; tryItOut("\"use strict\"; selectforgc(o1);print(/*FARR*/[false, \"\\uF05F\", ...[], new RegExp(\"(((?=\\\\B|\\\\W*)+))\", \"gyi\"), this, \"\\u86AF\"].filter(Math.sign));");
/*FRC*/Random.twister.import_mta(-1882326890,329636477,-1308753509,2028285083,-1420385835,-370437218,710236473,1137536462,-1714216260,-170931859,-635552345,1807506428,-1463974487,-459929224,-1271250805,-1834636741,449164918,-583990204,1560473113,-1226327190,-980321883,1154354658,-1519783323,-346042165,1549328929,-571735986,-2061945349,-163858889,984198171,292790993,-2009033217,-1990156864,-1312803484,1247860320,-1738524928,-106545774,-822282837,-2066940537,-1793903210,1704206940,1270994809,518197801,2140120537,-1598841598,-194532797,885824828,-1545718229,-993685925,-1798504419,-1464847597,1029119172,-387551216,-1183394630,1467263530,1316333651,625006744,-342075692,1417961715,1520038549,428570908,1756709444,-1910059541,-2038953002,-478308399,-1214812574,-1833928367,-1193815376,1702082396,1532901331,-603730054,97712342,849367097,414960852,1646537982,-314271125,1927072861,-1734706903,-992168467,927767257,1369272413,937212579,-838985696,-380537625,-1930323654,520660963,-812034015,1538849096,-798981314,-1731996889,1033677272,755922637,-659273278,-1053978029,-267036074,138663722,634541888,1022850691,-56041437,281836398,-484099008,-979520647,-908399810,-1318656533,1239345712,-1253202240,-139762684,-1935717879,-107909459,-1930819740,76235491,1886696576,-1584012914,-1557262405,602349425,-1135241379,367237655,361582982,-1328033387,171086611,1693695794,-177123954,-1859933767,256981194,832441712,1235646167,-2001530100,-1443791292,1214422080,1490215976,-1111717489,-404680833,-632280965,1276478569,-796370627,-1367850401,-242833317,-1840840990,-110034368,2068905072,-508615776,121751857,-1486393684,-1959500238,-895508623,1313130788,-1380794460,-514657283,-1573656741,101475862,1734185685,-1497400621,-403722216,899489578,1782054385,-1935504861,132782372,-2100894917,-1795828186,-612652928,-33526967,1706015932,690228896,1544549467,-32929396,-721430936,-229580484,-558550193,-1311310028,54531430,1596457928,101786865,1165215678,1949387820,2048677274,-2076823616,1081777138,1235707323,2069878319,2051710563,-243044776,763986471,2003733458,-1628321415,1254503316,457746515,2107847843,-477085464,-1883054773,-1987612169,-468626375,-1999652600,-913803295,188377484,-1571988304,-2139961228,-261948983,-209911768,2129842231,225393971,1225727855,-684778890,-486712567,-1358000313,1892537537,1041785995,171764989,-1768862281,-1572488721,-1802586755,-1030217236,-760979434,-579654707,-1662980664,1939682081,1939045377,-1521034430,-548734014,1575202799,1002230987,-601885174,729884105,-746393236,1028633003,471618051,1837872703,-804716334,1475912081,1999051341,-1416743988,-1620343,-284170127,801288845,1462938309,90143476,-1901107082,1539385150,312775182,-1413215772,1257753143,1185953517,-1142782029,-1013619042,672281275,1279257107,-524278370,-1762343893,1535202193,2040711143,-504493589,955273608,1817335510,-1300512576,1786924295,-1849784326,-510791431,-213438398,-268082279,928444036,492745291,-1907303151,-160789657,-1575069111,-316448586,509725223,2139638904,-97047059,761244034,-952041835,-1914293688,-435731348,1415079801,1370037536,-1752622154,-683849947,-1784702332,166050014,-1617231888,-194497993,-1516467335,327864183,1633131284,1816894154,1623943032,892916921,1465939592,-2146993292,471407842,-1168943056,490739273,-1756262680,1651320235,37353859,305414480,470581515,-1753891922,-1732551912,1672305277,552285252,1584958429,374521918,918259343,567791452,-1978925608,-1325564727,1236323434,-1680181493,-715959226,2060649600,-665612679,-1741798405,1321313384,-702441355,-1266433927,719050608,-1427277266,2068206185,-612766914,384792757,-982990293,-756984421,473839977,-1148277960,758736168,1811980220,-1742518820,-1116698436,939742910,-1082733872,-688019830,-338372119,-480729577,919131676,354350650,1582166627,-2046413814,995964637,1947402656,-794103443,-1995405113,-617359114,-1347567096,1612879229,1820632341,531953587,-863570829,1137223988,-1425791335,419973863,-799114448,-1471226393,542292198,299003249,-992546237,226599849,792193494,-1919344092,-475052421,-2052028633,-1823096112,1109623131,-1427122692,-1115403341,1674185927,2129736934,762802416,-1238775849,1422289101,1460130277,988942305,-485497193,582834948,-998266680,-1735681039,-461289116,938397988,-607794678,-1553981689,991901925,-1915698911,949608045,-1803195482,-796504054,-1833351840,832915798,667950475,2004305808,1161944548,275675256,-1242259660,1144579458,296794366,791899843,388056292,973310940,-556001876,-951150764,-203297536,-743387396,-447594627,116043477,-351497747,19115348,2074272971,141102877,-569398296,1225794811,-888429114,797762448,-1277425111,-1560000746,-335248091,-873337099,-229299802,-1713976486,477381468,142469500,2029080717,-458547532,-1199661905,229736688,427462448,1865633436,-627790317,1661229980,1273091264,1163692064,-2012675812,1893399060,-999438940,-1735517249,-552029738,1179795798,-1374720948,818452757,-870851302,-1312831588,-398037121,2095932504,1929018831,360032789,-586198130,433604009,330677466,1448515415,-2105955060,416474032,1025086376,1952641275,1303473267,-183248199,591945761,1907735808,1712422482,863921008,699154733,-1813544757,-1375530930,306232015,-1944590265,550776707,-1061013246,-433038972,1643377171,586131614,786171623,-1390254611,586972376,1622134824,-1604976699,1439868050,-1695290639,960851124,-557525237,-1925930256,801602928,-1173466417,968733796,1246767601,-259751931,-492665159,-1021714405,-1740418371,1112095823,-779118753,-1564451345,-1352189606,1783549117,-334647535,674712205,857608078,2033260464,-1105867102,-941733353,24115970,1914200646,-71124490,-1459797886,2118465523,1372770611,2101326585,-921809941,-2009696273,1839815854,-1422698051,1822777177,-957068548,1455956474,669559443,1150675840,-340453817,-643363845,66417523,919046676,2085395905,1133589682,1774675843,1330546981,576995293,-569301486,-581055022,6094732,526352296,-1682053188,863521117,-1872858753,-1744462212,791100205,260070403,-948106738,1741031430,531605536,-116239957,74201379,-932384584,1142757078,-538150545,-48111938,-269596991,675573395,1147312740,-1140488098,-498583632,-322996338,-1981180826,-292449005,-1310177722,-1662872556,-974661381,-2108729934,-1124877244,1948544910,1405224266,1396860244,-1816760645,678354421,381768568,-1613586019,1186138696,887986457,490118043,-1801769754,923139378,-346587400,658456630,1083353364,-496793105,-633032490,1495664156,43973348,-1090334160,1706060221,-1671988098,1018252048,-1432271295,1237654004,378029379,2042511997,1762394504,1332674428,1172435134,-567106115,-409023813,-787140228,1714506538,352114600,-1812026133,2052919640,365199828,-645106982,1866963049,-180152948,-1018676731,-2033881399,-1317679916,2104893314,-1161325087,-1120103025,1130726572,913195571,124297430,-316102366,-767000187,1941977701,-1188251258,439371581,-499165794,279661220,-417459190,648212361,-1941134378,-766657060,2144009565,-1778812664,-1855670817,634789630,-1415392245,979201120,-533642864,1371657582,-1715761952,-1860150117,-658777794,-1176162362,-1274605237);
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=254; tryItOut("\"use strict\"; mathy5 = (function(x, y) { \"use strict\"; return Math.sign(Math.atan2(Math.hypot(-0x080000001, (x << Math.max(y, x))), (Math.fround(Math.min(( ~ y), ( + ((-1/0 >>> 0) * ( + x))))) | 0))); }); ");
/*FRC*/Random.twister.import_mti(315); void (makeScript(14));
/*FRC*/count=255; tryItOut("testMathyFunction(mathy4, [1, 42, 0x100000000, 0x100000001, 1/0, Math.PI, 0x07fffffff, -0x080000001, -Number.MIN_VALUE, Number.MIN_VALUE, 0/0, -0x100000000, -Number.MAX_VALUE, 0x080000001, 0x100000001, -0, 0x080000000, 0x0ffffffff, -1/0, -0x080000000, -0x07fffffff, 0, -0x0ffffffff, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(347); void (makeScript(14));
/*FRC*/count=256; tryItOut("mathy5 = (function(x, y) { return (Math.fround(mathy3(Math.fround(( + Math.hypot(( + Math.sin(y)), ( + ((( ~ ( ~ y)) != (Math.fround((Math.fround(x) + Math.fround((mathy2(y, x) | 0)))) && y)) | 0))))), Math.fround(Math.imul((((y ** ((Math.round((x >>> 0)) >>> 0) >>> 0)) ** y) | 0), y)))) == Math.fround(Math.sign(Math.fround((Math.log2(x) << (x < ( - (( - (x | 0)) | 0)))))))); }); testMathyFunction(mathy5, [-0x080000000, 1/0, 0x100000001, 1, 0x100000000, -Number.MAX_VALUE, -0, 0/0, -1/0, 0x0ffffffff, -Number.MIN_VALUE, Number.MIN_VALUE, 42, 0, Number.MAX_VALUE, -0x080000001, -0x0ffffffff, -0x100000000, Math.PI, -0x07fffffff, 0x100000001, 0x07fffffff, 0x080000001, 0x080000000]); ");
/*FRC*/Random.twister.import_mta(57316125,1688571759,-477067193,1739551192,1976984731,-1216284536,697285114,-756663626,-1426100078,1057754058,1515376238,1049262114,-783334486,789648831,464227127,-1086852451,-1219606152,-335706993,319698121,-2093917056,-2033444795,868406594,-518596534,-295809281,1103449787,17859633,-2129579944,-1883393518,-722605673,354548540,879408372,-1668423914,-37850993,-752309674,981557151,1350149702,-341420279,-2036447279,-1015687502,1420702748,-359375469,-734715908,86795412,1043609200,1136528183,-1689118960,-1388519259,1360502237,-712881434,1672617418,1074907379,285869614,-1633054804,-1652947753,1662374220,1407145272,-1070275626,-1645737800,-1625146299,-1705397908,-1940165403,-819204692,-933079884,-1693872589,912315891,1033378635,1347842864,-1703170607,-2094824880,1611989171,-520664853,-1408755281,1690350317,895031067,-651969979,1266768704,1985104089,-311852861,197679678,-1151641110,1823417825,488934057,-1529198044,362087221,646401650,798310635,-104868160,2007565475,-240554570,-440318204,-1068004368,-777440389,1259643557,1024523301,-1392712446,1085096329,-1506591796,981360625,-900716586,1396386273,447234668,-1872162023,433113057,-743925621,-203176467,-1293006475,1324572212,718298347,498686802,1861385146,924998228,-1945478014,592324896,1585803402,-804516185,1006707415,-47200812,-1618948636,1539225626,1979068386,-201499682,-1715881353,-980235414,-1115196360,453441070,-817538914,1464403837,-1137245333,533949028,-975238067,-73336607,947878117,-695561145,-778356272,416920921,1297040978,-1261145704,968190190,-281286465,663325433,-60952169,1843289482,-1205476093,-618140468,-191797150,85900975,1106827028,-1382570472,458113011,381000098,-1240465161,-662578649,283177571,-344090048,272042456,-886463466,-640907864,1171458485,-255207933,-318406717,1377897752,-2082286613,573726557,-18561070,1311608236,486889344,2144616364,20095911,-839415797,1078235761,2074076611,948329714,-2113079043,1739292253,-60149369,-2123740910,235281801,-303503846,776598127,-1234029647,1388004449,-652301537,545450356,1251885387,1078452277,-522383096,-1193765552,-919085172,2029958696,1044041180,-402126085,-1676589540,2120300081,-1250266698,577893950,-8655139,1459885072,-490131004,122202761,-1767171916,-1424778761,-119425713,-435750295,1798056888,1314801444,-511693727,1896273326,-914379428,-2089597592,2046393007,279916851,1758632301,1821018777,1921823491,1835110652,-94632727,1721619191,-1593785276,-2052247794,-157987237,-907003610,-1771127452,247272766,1055733595,-255895209,1259458513,379333810,380472059,-2107728652,220187808,-1454991295,-951615194,-1255193102,785911233,-1090082519,-1548928619,720244536,-1507746902,-2066033781,1438036140,1323017968,-693493067,2144075,-2027005001,965695045,-406442530,652775340,791915631,1874525574,-683674847,-144462177,-1383278361,164612044,1759475963,-165795277,904390788,1317702782,-1546822386,44892481,528713187,456079277,1276178372,-2042498166,-731745995,579691000,-1780874637,-301532279,-1402518345,-1489584694,-167188489,383826144,1215989484,1774453853,-403493401,367346098,-632343266,-2138131442,-1948828272,-1043869366,-1375583706,-1419785806,1399874288,-800354373,-343615342,-1645497086,-785468876,-2022695564,1542706974,-998036776,542930622,52281901,1065022811,-1432949999,1542237927,-702152611,1811783601,1885379217,1455668698,-1490978384,-426393227,632484021,-601471831,-1963502085,311045868,2039221145,1633808413,-969745494,-644984318,-935650421,-1011181552,-1483898928,-439476591,2063117139,-322343977,-1828545208,-602564567,935218049,2079021626,567355753,-1677521202,551004601,-94349418,1991052887,-1440573150,1690704815,-1773040503,1283476617,1909887273,2089537330,-244046795,-1999834235,-110313744,79691931,1307591729,-294226086,665901954,-542133293,-358437144,-510414599,1956169764,-1214477589,2135354610,-1428952623,1113853746,-26961538,-684450935,-1602569650,-606968250,1419142235,-1782868199,744944223,-1603977264,277690773,1087566742,-1157918087,-150177402,504364801,-1307960951,-1067054953,-1006797127,374451414,-265026587,1916263457,-1569732128,-1146536998,475032582,-1794977068,2016167608,-984539618,-377796479,-115853144,568071493,2002655773,437239686,-2139798755,-738819921,-768428785,703647928,499484110,446842800,-2093043131,1500228456,-1812266819,1395407794,2120788605,-764856079,-449690625,1222328962,-503406294,719979298,1886765164,1170026462,299630,1354380666,1653991437,-1274577269,698152207,-1874965854,-486819001,780271828,658155767,1488188221,475430467,553764989,275268792,197927052,-508280199,-765595222,-2003007340,-813163719,-1234303250,963474662,-1405717339,-152914690,-855037134,-577851727,208618118,759166067,-624327068,1927049641,-2098997512,-1775037976,-1896234221,1928658544,-1066961452,55323143,-288987714,-1994032347,766380111,-1987403134,134548243,1499066626,552390708,1460484899,-1851765102,1851310600,126863491,-1327841525,-77529928,1108157278,-1486348024,1689996945,1216348061,1738605681,-311839332,-1692277030,1437370105,1981824960,904913127,-971926031,104327643,-1011358082,1387200105,-1690125061,-2041120191,-715189037,-583589608,910548157,237315640,-1790027405,1572872451,1459085567,-1294275110,-1534542700,699931011,-710611481,1709267128,-939922995,-1136430852,-1806568724,-611521043,-1880781537,-1587774298,1896558868,-1422117417,862201780,1797216006,1445551682,1171598180,-246708450,-1107926662,238159051,-2077715468,-2032004522,-193019485,-293414976,-1332878668,-700702156,1436542979,-1160153006,-882338204,-664079316,-714211342,-687158614,-1853482932,-213377653,270716113,-1493081946,-269619377,-733245065,987801295,1664217061,1457400095,1876208509,-1465050898,-1432108617,620668848,-1995096974,-6137588,630241945,863425012,-2037878776,1979730955,-1497856211,-166145024,2049760917,-1469654641,739594532,1372853170,-357002025,1413681459,-604441725,-1421276224,-515435791,448885476,1773819129,2019385259,101479858,-1346027350,-2061467157,-1223969050,-1565349929,1163364417,-1539551039,1869667946,-1230244652,759499695,1789392966,-939568221,1694134140,-1645383665,-446880113,-1730063846,-637652521,589265177,1872782179,1744327276,1643119456,-1541830220,213858704,-2084332665,1298606341,109185803,-2118151508,2058762389,-362139869,-1842503407,196251606,1862222818,244160232,376617640,-606222298,1949268889,-1644711,1117510336,-1934497646,403426090,-1227622503,1623688682,1090743760,1280291085,-1606664970,1533806710,-996657484,1235153976,-247335494,-1589798947,198282721,-2104113265,-1499669612,-1441454572,-764343609,-2079007725,342987989,587071267,-1119322053,-920699309,983012795,513769230,1217812199,1522754621,1640184929,1156221548,-340140779,-62440297,46654470,-2000057641,2066196846,577258798,1103777420,-366784613,1620963056,-815735700,102901326,418347639,1435508892,690834869,1231517022,1598945923,-86122925,-1245579837,1955862265,64213697,-1210495872,-1006462888,-1127213286,452109290,412429019,1231088046,-778302212,1021827557,1046970350,1997293297,-249492386);
/*FRC*/Random.twister.import_mti(33); void (makeScript(14));
/*FRC*/count=257; tryItOut(";");
/*FRC*/Random.twister.import_mti(39); void (makeScript(14));
/*FRC*/count=258; tryItOut("testMathyFunction(mathy0, [1, 0x100000000, -0x100000000, -0x0ffffffff, -0x080000001, -Number.MAX_VALUE, Number.MIN_VALUE, -Number.MIN_VALUE, -0, 42, -1/0, 0x080000001, 0/0, 0x07fffffff, Number.MAX_VALUE, 1/0, -0x080000000, 0x0ffffffff, Math.PI, 0x080000000, -0x07fffffff, 0x100000001, 0x100000001, 0]); ");
/*FRC*/Random.twister.import_mti(71); void (makeScript(14));
/*FRC*/count=259; tryItOut("o1.v2 = (g2 instanceof o0);");
/*FRC*/Random.twister.import_mti(89); void (makeScript(14));
/*FRC*/count=260; tryItOut("/*ADP-3*/Object.defineProperty(a0, x, { configurable: false, enumerable: true, writable: (x % 5 != 0), value: t1 });");
/*FRC*/Random.twister.import_mti(118); void (makeScript(14));
/*FRC*/count=261; tryItOut("/*infloop*/for(let w; x; (Math.pow((/(?!(?:\\b.|.|\uaf06))|(?!(?:\\W)+?)(?!(?!\\s{3,3})[^\u0012]|(^)(?!\\W)|\\W*?|[^])/gi <= function ([y]) { }), 6))) Object.defineProperty(this, \"v2\", { configurable: true, enumerable: (w % 2 == 0),  get: function() {  return a2.length; } });");
/*FRC*/Random.twister.import_mta(996425162,1245401019,1565898808,-2066142619,1131646841,1217503934,141743398,1159199985,1414145385,-862116530,-854012485,-1606735551,17310009,582185898,-1073857161,-141471719,437569126,495354249,-602537743,-704512389,1960746706,-364713407,-1661213175,2064236922,263447343,-1905173697,891955065,857289152,1239209881,-185385020,-2023517010,-898006825,-534841431,-867363837,1902453281,-1942533265,-1924487148,-266689077,68147206,-1412606315,-624938763,-1175007502,1561802854,532649036,1762805017,-2014757104,-1776125376,-945254161,-352786369,-324218273,2124758231,985343793,295970629,2008875389,-363311902,1924435842,-709445465,1355764924,-1737241499,34744245,1372596843,1779698786,1103244981,-1611072731,-785162875,-1695427518,817748643,1747572907,1017568609,-862827502,150296005,1462475093,401983934,1846902800,-366665537,58583061,-558415446,-287827768,784960321,-2076150487,-1045189687,1471680118,579450459,-1363818941,-2131749791,-1191741292,1681793240,-861243528,-1671269310,-794417332,668994390,-1457714802,1029289631,-585702171,557114423,-965451244,322786701,-1263662169,64829860,494333415,909990389,973945952,1687645677,-635833114,-1555137664,833062405,-474729001,-1502497465,-1646592918,1064274586,-1894772173,-1375384164,181535452,-2106038664,1098928572,1217900257,-377953825,-1681422323,1087883620,-1852279712,-104776512,857568775,-1266995509,432040484,-61186100,1508194465,1716790171,1428735958,-765632000,-1668967676,-1019512545,495499862,-303227645,1651498133,-2078997250,1597878413,-119085898,-1041917206,2087158135,-1973206085,474535555,1122308605,157915418,-408566722,1054525703,-1206044272,-818552101,-139405761,1694150578,-436673848,-1799856468,1969307738,956429488,-875028629,1760819982,1784957407,2053023401,-606444725,98574365,-79878243,-1823779076,-1494295405,838857985,1902410878,-715168794,1271227471,1719076437,-43471334,1973096821,-1127446252,-1433347616,-121026229,-1411489247,-344844015,-527886209,-2056800659,-227785287,-2018329136,1936743613,1365804338,-1101633359,-757812427,450579438,322856657,-501251517,-663185733,1894415123,1585620023,-1571428651,1679002609,1956591285,-123251511,1378577980,201039650,-948536368,795377764,-623032841,652990732,160589916,1145632499,-1637891306,-933001019,878467920,-854823927,-917157857,-1209813317,580776160,1498863811,-1335612140,-1200462349,-469333705,-268431600,1519597325,-2089730627,-793598894,-376075419,-1487327582,-2032922657,1586626792,2114633593,1403155561,238969649,1474439054,-1649359471,-1025038119,2084720808,1669298684,978023344,213166571,-788642617,-411374858,434384256,-2030758783,-1896271507,-1916153628,20783861,-544348005,377296033,-891260649,644215361,-1863396817,1726404109,1829686557,-539239013,778409830,-1889384665,1485871251,1124327441,1490395918,2118287769,-1262019114,1263796425,588666781,-1758625089,1776993666,1855558054,-451571389,1597875409,1555100409,1954667680,-364551199,1917180900,2131673898,-603186968,1677661229,-368831203,1693860881,-1990496752,1543114198,375874582,998430522,-990316568,756554044,-590292327,-359724448,-1430277576,-1454945129,507958386,1840907810,1141621660,503656453,1534409696,125232075,-1690082778,945294758,-607403297,1877724218,1938931463,976893757,-649822340,424489303,1567660242,1846490094,-2103023022,-2065717332,-1650581258,-403467521,459663645,-1117140688,-601620165,-653389157,911620765,1245249379,2071590073,1197494297,231794324,-393782232,1017550547,912605822,1901005235,1163557332,1686434071,396066208,767520380,1000868787,1588978013,-313292207,-1375719619,-1491300631,-197471588,-534327506,-1016409149,-748343675,-128522107,646872380,-57299137,-1131080276,142130796,-1681940827,-1174821648,-1498436706,2015808274,-1906895678,-728822150,-173418362,721786204,1245634030,1725004432,-733402738,-2011891850,-35975167,-840886901,698722680,-699749024,1767191830,283808835,-59685053,176340530,-1597502124,2067851067,166917580,756315097,2039234922,-501130632,783219477,72494431,478687007,973131147,-444680747,-1496986776,-1015190088,1678137905,1309299837,-1523418789,-1882346263,1994844189,-160079641,1054890380,-1353710238,1977976142,776175171,-1669499690,-1256528301,1443361674,121841335,-1796520470,-1325364588,-1705337781,2016437122,-1583997619,-1485976865,-133772401,66212870,-597540024,1810255852,-294538947,-1622112548,-1548482967,-207889150,163910967,1404758929,-715314479,1670938354,-835370356,2120458624,-1201808595,-1261196219,1122350236,-1350022879,558597765,1579372624,2007668609,217047692,-94869531,-2108379754,-626864802,944143847,-99078917,739774070,1106004121,1334369442,1829505230,-1559638844,376368778,-1454554192,-463321194,-343621353,1509684615,415358146,1398441280,1088559062,419572358,1444085596,-85000419,-29000496,1056004739,-1714226242,1367373806,-861480572,-380211706,-509569912,-652009467,91069429,709744553,779794887,715880842,957844137,-1716062357,-1861837121,1227302793,1747200554,1837493059,1129167234,-1846676372,-884671310,-1387465909,1159372953,-799198011,-1270998762,-1913560132,-1133824338,850978610,-387203574,-1185106941,-907261690,1647262055,315890246,-530023958,-1974750746,1897772255,1015706061,-1801148919,1400470719,307844229,-1515728243,-1206854325,-1668172168,-825267631,751710075,-1715467468,18983883,2127276341,-135798867,-737791321,447869899,1834616973,1431711416,-1775400860,1945224006,2112710432,1228681221,1811844216,770218125,102908237,679268145,83231651,530566586,427960127,1864984525,448432152,-1338416386,155839444,-2122223544,741689399,1777848330,-1964778655,99079237,-713256894,936742796,-379520380,1950391732,1491643952,73226073,-1122909984,-769686410,1069897210,1082219941,1641290883,-1867131277,516786993,-1744348638,-632251524,1369387414,350725690,-1752211310,-1224611035,-1890658322,833042574,-249273754,-1658451032,911385420,-780459444,1949636945,-1433195635,-1229950018,407885370,-551404574,-823348530,-305214793,297608208,-1289218163,-1128061722,-2033811925,-1623248099,670264505,-103843978,1142748560,-5414694,385468073,-2140834440,-971420188,2010686142,-1421719191,634684930,14200403,-1797216289,-993864916,-232125452,-2060103925,1267487641,133024984,-1127757722,-62232983,1489418553,-1538975454,1268907762,-64953573,-1848636817,2136997990,-2056369770,-111023511,381080981,-1912711633,728969358,1619627737,-1739797477,175488101,-1917267212,-312433821,-1769291487,-967527653,81998125,849776409,-1732362913,841106671,1767798373,-1482649324,-1850693932,2119835155,747033184,303132612,-173267517,-681420822,-1795268527,-1112785591,419011107,1652994410,-869084609,-649739875,-94153028,215701428,-1380390433,-634210744,291393139,2139335567,842821846,141971961,1064787156,-1130867824,419688769,642319602,552814721,-671459635,612337520,-1332573179,-173116025,-2061129758,298026817,1549833337,-1072030152,1059125483,-217639341,-174254211,-44971280,-35910172,-1092449033,-1668861819,1997184838,-40686417,-1528618273,-788071045,-588434905,-2134024958,-379473248);
/*FRC*/Random.twister.import_mti(465); void (makeScript(14));
/*FRC*/count=262; tryItOut("v1 = r2.flags;");
/*FRC*/Random.twister.import_mti(479); void (makeScript(14));
/*FRC*/count=263; tryItOut("mathy1 = (function(x, y) { return (Math.tanh(( + (Math.pow((mathy0(( ! ( + (((y >>> 0) % ((y === x) >>> 0)) >>> 0))), Math.fround(( + Math.fround(x)))) >>> 0), ((Math.log1p(Math.fround((y > Math.fround(Math.max(y, x))))) ** Math.acosh((Math.fround((Math.fround((( + (x >>> 0)) >>> 0)) ? Math.fround(x) : Math.fround(y))) >>> 0))) >>> 0)) >>> 0))) | 0); }); ");
/*FRC*/Random.twister.import_mta(-17783906,-2128440003,-1171283096,-1500371149,1407338206,148277279,1104881986,830017533,-51617799,-943543323,856492164,-174805451,1354101068,-914394426,-1882451939,-301748233,-2119885167,508490519,376047732,-1846833538,-170774408,-810246375,786327037,-567060834,-2026752058,-1785766849,-480090115,1134798787,76072289,-631033367,-1380710566,631313039,376984792,1750343,1177564525,1137233919,-884460141,1820153284,-1505402337,-847306228,-984772590,-7535988,1190718895,-978995079,1852929227,140280994,1798376644,657471602,1108486843,-1556050387,1409816450,635746923,791106525,-1991831329,1273143539,1530417798,-784654755,1557995499,-1171350942,-1556824148,-714965029,866260579,-404129390,-853839920,-639874008,-1842405071,-1085994993,586943714,-1638270142,1105439813,2085754404,657771428,-1362441412,-1388606645,-1501696544,-658735240,-1553318205,-723679564,-160267578,-1400419453,-34500769,-71456588,-205572898,-1874031894,931475506,1610057953,544701169,1716385040,1822756869,1282394129,218932216,-1467151267,-1388754251,2041290810,712235742,1360489041,-1351942853,672746712,491789645,-2014197664,-931525006,-1667855963,-999554825,635936884,-1724654099,-1399849619,1998695068,-1661797821,1618120887,-570301341,920042061,-706947299,535934989,-121146628,1729363155,-64228954,-1072901405,-136018912,-1077030635,-206681714,-249482414,1913734620,-775536966,142576810,612437699,-568870845,-2147006362,-1616985410,1443700664,666318770,-2144800795,1110504681,-108889467,-1323133454,1247104127,-1162539920,-3277208,-1060627235,1710646900,-1825559026,1205295355,307038756,-1279813785,8165816,1809202806,1439697115,-956015166,1923479946,-1508059461,-1902183302,-2003129383,-1716144813,-144118541,1939091807,285039702,1483572706,-333236157,2143140339,-281551389,-1249556379,1538249977,-1097381319,-1109624919,-741450854,-363014291,667772378,365389699,-2092124484,-2044032879,1597886613,1758774926,562504364,2050719094,790138875,-547857724,-761783014,-613981257,-762127762,1105868028,562238867,1641172881,859290596,-1139715625,-1172955590,10018369,908057276,582451861,898531068,-201789692,-1044276497,1768540292,-1336904061,-6383315,794847836,-99833363,1851040876,1110156021,2068488097,-1995392144,123318386,-1035065239,-424247752,-1500678246,-605351902,-502652157,-2034979139,-1847829554,-1465869681,815789985,1848529830,1774420169,-1474183392,1487548473,1467591362,516252478,-1506705364,657685952,-1835725424,418341780,744405614,-383967743,-698204312,859041992,696113608,-1563682189,-1317871108,-196867208,1638025140,810878849,-913123821,-362794509,-913277887,-693985162,121618736,-386978216,1243749227,368349546,-1888124720,1068427210,-1043715964,587507999,541312588,1491530213,-694692574,-2131271589,-483724062,694341289,-642194945,1771925258,884861718,579986981,263302359,118566335,-1751710404,1961848592,-1358250721,754275166,451202809,534904031,-1169009161,2033735861,2042057976,1842267019,599723866,-1065881707,1295446216,-908946172,-1464822023,-188829561,1530496562,-405159027,956135509,-1086564047,511085044,1919934830,-1883685841,-328997868,1658131603,132209573,-1188201728,-1526887121,-783195703,1452925845,-1927866226,-399487397,-841253761,66375920,1366807706,520104413,843534822,-475847751,-287582753,-1820584936,-47522855,1815288985,1957200610,-1789269996,1659302588,-802259994,1531277998,1863853786,443097742,2080912891,433235472,-768215554,-1036964654,1809625141,-423416224,1511169202,-787347404,990266046,1011388130,1227374559,-1532243977,-803228319,-1023121934,-2107150512,-947235757,-762288877,-584438494,-2129233660,-624296637,-1271615796,-64109659,-1889850472,1125816219,-1009936554,1554870783,-1066771491,-1757686472,1509213693,-1642571892,-959940016,234178271,-915394323,1164836416,-311862997,485633674,-1848202074,-132874030,121587942,868296815,-686905578,-1264170904,1721335518,419283563,-1225845097,-515557896,-1766226274,-717274020,-2013461095,407318134,-284748417,1314424115,79652046,-1052657432,-1547705944,731842000,290591069,-1740845991,1512638517,-195504482,824475650,555980995,582211596,-943429928,-868220216,1350523466,1757399171,1033803929,239215571,-1470890624,1054077214,1571651142,2026920831,-23292943,1522205312,-192767464,276171562,1037482307,-1767906233,1359246933,1985782854,-1714413643,-779234894,-1600151923,2102918030,576862840,1669165181,218739390,1617460781,-1685002220,14140572,1794553667,107670517,1162604140,1045367515,-434613567,-399879887,1428870494,-1916439324,-651187326,1992072759,-1706216068,-1077691199,-2067678512,-2054704335,937314474,-1966526601,-1680523386,-1936713123,287062051,2099817977,907092813,1203723575,523386704,875876595,1695098597,-1711459293,-537947450,601980703,-788146621,-903124163,1024007325,-1120239041,-2047228241,1872333701,-467843925,-1843574469,-698532386,779235583,968121894,177927606,535410674,-1108007350,-1256422870,-67266356,-1203208375,1438293051,1824007468,-122425412,1063501823,-1362658790,1116799897,1564198122,-479558905,-1653042989,-1291709814,-1868919114,1829137311,1881254481,-1766210186,1960053538,-1867370501,-1984074792,960432802,-106501402,-1354372864,672536305,1374627919,-1805311253,408625368,-637140490,-1641035533,1249205930,1910914294,1067789683,-328528259,748930006,-2122410785,1895477607,571227986,270622062,-47020141,1981633894,1127643222,1068183332,1533609862,826744647,-1165523614,-1570225408,-82603127,890449254,-1581022183,-2120777737,271456770,798750391,-677094516,1961496820,1976726260,1729886896,-1061726287,-2111511540,-47612671,885640086,793111162,1904725523,-1137507253,206374167,-988014613,839048940,-381027811,-1859003297,-2056509905,1027063406,-1096202840,282051998,900716233,121574542,1520062084,-532720336,-2130717040,-945246366,137584825,-1811967529,1487356458,1788136865,-617540982,-1605840885,-933935682,-711505153,-1893654290,-118904837,-838741557,784406945,-4233705,1009986505,-2131233954,1387769990,-57372958,1202926691,140409396,346424707,-1590839626,-635136549,941418106,-289097639,-378400459,1014641758,707041581,-548954456,1555439882,-1846663437,453216422,1425192803,-1326379899,-1539364648,1518628446,638018640,-1212004192,-498194538,1752606835,-1234076712,-772858937,964529798,1735563919,1188782288,642041294,-1666223289,594558907,-542729014,1451731749,282355207,1143287448,-1982007208,1306837579,-20387416,-393762424,-510855136,757878340,1876910113,-423458419,-1918211045,1995867199,1289928213,-2056663532,-1645799626,1641593423,235161414,-435182947,-309975283,1863208763,305543199,1684099027,-18122722,538003944,657266073,-1350346716,-1989575232,2001284056,-1359520525,1336574760,375648574,1787389904,1231118881,-175353696,572864243,269355547,2111485439,771191655,-723752231,-903495482,-1398583223,-604310435,391974916,1390729435,-331363780,564600484,1896446281,-1329305364,962274371,843836115,-566789131,62520700,-467940132,-1271506720,1988951325,-945203035,1357498788,-245626114,-1651990897,1175209332,838547260,1094146836);
/*FRC*/Random.twister.import_mti(62); void (makeScript(14));
/*FRC*/count=264; tryItOut("mathy3 = (function(x, y) { \"use strict\"; return (((( ! (Math.asin((Math.hypot(( + (Math.pow(x, ((Math.fround(Math.pow((y | 0), y)) | ( + x)) >>> 0)) >>> 0)), Math.atan2(y, Math.log10(y))) | 0)) >>> 0)) >>> 0) !== (( + Math.atan2(Math.imul(Math.fround(Number.MAX_VALUE), ((((( + ( - Math.log(y))) | 0) !== Math.fround(mathy1(Math.fround(mathy1(y, 0x100000000)), Math.fround(x)))) | 0) | 0)), ( + Math.round((Math.sin((mathy0((( + Math.asin(x)) >>> 0), x) | 0)) | 0))))) >>> 0)) >>> 0); }); testMathyFunction(mathy3, [0x100000001, -0x100000000, 0/0, -0x0ffffffff, 0x080000001, -1/0, 0x0ffffffff, 0x080000000, 0x100000000, -Number.MAX_VALUE, Number.MAX_VALUE, 42, -0x080000000, -0x07fffffff, Math.PI, -0, Number.MIN_VALUE, 1, 1/0, 0x100000001, -0x080000001, 0x07fffffff, -Number.MIN_VALUE, 0]); ");
/*FRC*/Random.twister.import_mti(388); void (makeScript(14));
/*FRC*/count=265; tryItOut("\"use strict\"; for(let [d, b] = ((function sum_indexing(iaiuhl, vwcglw) { /*RXUB*/var r = /(?!(?!\\2)+){16,17}/ym; var s = \"\\u00cd\\u00cd\\u00cd\\u00cd\\u00cd\\u00cd\\u00cd\\u00cd\\u00cd\"; print(s.search(r)); print(r.lastIndex); ; return iaiuhl.length == vwcglw ? 0 : iaiuhl[vwcglw] + sum_indexing(iaiuhl, vwcglw + 1); })(/*MARR*/[{}, (allocationMarker()), 0x5a827999, (allocationMarker()), (allocationMarker()), 0x5a827999, {}, {}, (allocationMarker()), 0x5a827999, 0x5a827999, (allocationMarker()), 0x5a827999], 0)) in x) {\u0009/*MXX1*/o0 = g0.String.prototype.normalize; }");
/*FRC*/Random.twister.import_mta(1065461888,-1254260603,-1620347368,-466331765,1145855826,1448151702,469303901,415048674,2116575229,-603900045,-1810059409,-493627439,-1083537691,1384030860,-15376633,-1527606674,-532747751,1284135181,398981231,1323157711,-1680090698,1469756930,-252298871,1618502908,46844035,580053020,-976191581,645288016,834727556,960727080,801471795,-1725865129,1331222434,-1805477226,-2124904186,-1237950560,1775705360,937371546,-744287444,-1722068795,-946930161,-1345430989,-681424433,377742598,994966958,-1688208264,1359552416,-449158808,1807905998,-142828782,955842400,503420807,-257076433,-1931982089,-1155142603,-985582381,1741951185,-1800788247,1755665780,169829844,1872515822,467839544,929210279,-125106945,-935067489,481047854,-816722302,1163502347,-2011211253,25962081,-955473,1002874440,1324081573,600065943,1313997038,-660802864,-1755560759,220468229,-1937937080,-665102252,649581532,1217955112,-224280553,-106243303,1306584870,-1138745151,-1830453615,785205034,-1357820203,689809227,1525312893,-1149368975,151495401,1914836959,1899254342,211364430,-1457136787,-1553369617,750587466,364562730,1802563654,-143411789,-1745893423,-1483505467,637973620,-358545135,303950801,-737786134,144770886,-760469401,-2042032744,-774932393,1727657978,180231046,-1091948989,1051096780,1942037161,1427229058,561014509,302273544,-1573277596,-2002006186,-1939176469,1591704897,958549008,-1192623160,-2117160812,1170708093,-328925746,-1523585820,2028419573,-142721765,-1543125989,-1148116349,352648204,1799420599,1480656903,-1461737759,830796157,338142459,-531327961,-1129754830,1780143601,-357793389,-279538248,-1301542894,1649505379,-554406687,-138513736,2038091243,-1890188248,-994336010,1459675344,-365917763,1145072258,426268454,926513121,-1745956696,-1531408798,-1308345741,-1610100723,1531574348,1251414646,864044963,90249672,-2092997351,1166243270,1405160655,-1150117154,-895317265,-129746722,-594458981,-1549223578,1081298243,-1886484736,2031185183,532670728,739746923,211874818,872841249,2017683389,-1996202126,-1157321344,885192946,1946264165,-1704638070,2124837037,-954789988,-637979584,1402597851,782488506,1873707401,553197302,184137946,947966238,-1367437157,-836462369,1307131801,-1239381863,-1710583272,1666528519,781979186,1073937270,1020382087,276244295,-464683602,379718085,-702915829,1710485768,1104591495,901234996,-2074816118,-1686585971,909743580,559098565,-1917926123,183729076,-1469285098,-1575418409,-620051774,-1399306479,158347712,-438114790,367403881,515192202,1272525440,837187790,-1096574049,150756179,1934876222,435476852,790433641,365881870,797873521,-458973560,1959925576,-608438501,-875832182,-1032404077,2011194037,1113538986,1248761642,-1883670273,961407723,1025450876,-629264412,-83293969,-283808205,1304707977,2025224772,-22543800,-1739919741,693725826,-1079523285,-1459896832,1740261163,-1388748917,-1187171453,486603123,-1429451993,-1464258326,783767580,-1477847027,-790341115,1363435518,-146122322,1410050918,618206867,-1034774230,2105940182,-738858509,-1109696023,-731596670,1748954903,2079215520,502499012,522101124,-1577000339,43461127,1004217703,2105035468,1231138080,-1010124652,-1966831837,1800349705,694107404,581210009,-116066593,46203595,-1615085916,384720591,-2114319725,-80615395,541126673,2131616378,-2102153727,1895784255,-672770468,1449402143,2036855496,787535568,-379671860,-730488360,-1102660042,1815904876,1620805005,-348467356,1270783365,1611759922,-1356668600,-410084248,-260290538,930969573,1675760894,1330607571,-299697795,-741327427,-1431638229,-706014240,1233952363,-2041685599,724436256,-343442621,-293056863,1542229757,224118241,-488324854,-766677641,-1125228753,1646073328,-1465931005,1164085596,894638753,-1347599496,-1229932086,-1491264756,-1663746270,-1901962293,-1379583938,627463049,-1974059154,-1787986488,1693799160,9280966,-1066952600,-1559274119,1655099124,-379227349,-499880584,1453109752,318564986,-1750501776,1187967374,-2087648525,1701267977,-1111814886,-253727220,-381255292,1651043304,1343877342,-2118301236,1301724173,-489060855,1226368001,-1958898291,1470427161,2081950174,1292091577,997110689,-197954361,-24805549,-1338020553,-1665485007,-953030397,2024969670,-1696336904,1127973095,-949157443,1129860744,-985161172,465175112,2137929889,-1937184733,1610587960,1588178737,-636259419,-1556797617,145873132,1573724435,-475292225,1044919209,1158347654,793546343,-541151005,1902443513,1029549932,1621496656,358195353,-1241240524,-1521876204,753178754,1842903236,1949824929,-648640585,1853323523,-680813243,1877582964,-466665255,-990986063,1682182257,-448506820,-744668090,409299187,-999198999,-930213836,1525411046,-132787594,-1151993484,5851370,-402583130,-1150033116,-996289441,1777511946,1236363551,-1776456687,1491402116,822902930,-1286397627,1169330397,-1909238826,537650324,356146588,-340154793,140024544,-1936451042,403520878,-2063976964,-966639626,-1308048612,-1490990509,-259982596,909154248,1978594310,611228097,13732938,1974336865,-2104767609,-455802806,-419711792,1157268461,515555794,1692348443,-628583006,1966656802,-499376434,875507232,619784894,-721984813,-1629344879,-2030777436,1671628061,-911761805,-1563606034,-1098819506,-214383887,1152181749,-656583340,336502849,-740725350,1858900115,676066626,890211787,2112871666,-2146983332,-829533672,1376900123,1426258311,2130918708,-2062996430,2020428546,1529262384,-227399501,-296536584,1962561711,-248889726,-1815760137,-2128714015,-758368112,341729638,-1805376171,1773617410,274083320,282482673,242175661,863757230,1671024380,-90756564,215735207,106814147,-1922705420,-980245818,-1434578608,-968022772,1099267763,-1118551879,1257294024,-1207664932,2129117323,1680640610,-204140020,-893686677,144408504,-196199025,-1303119955,-1790486582,-1367092028,-1306314783,-540899819,-439310260,150142397,1741709414,-1703837352,2092693051,-1097374928,1899058568,-1854588380,2031881063,1202392723,-686494275,782535478,-1167490260,-10014606,1879924438,522204502,397471416,-830771775,1116952845,-1179417017,2087105631,417249457,230229115,-558836107,-1549583058,1621219027,735762870,-2014017652,617523524,-1790055543,818880880,-1700763512,62630471,1087648529,-56297251,-1101396407,2029818095,-1618743481,1899984663,1069589119,-1915607458,444617924,1575364149,668088854,-2062578624,-1740946674,1901627953,-1834922774,1361413965,-91208834,-1006937366,-904768969,-1427871265,532291258,1098690489,-572579551,-338586591,-1396185373,-1082631168,369019353,1034295265,-1459268905,1830720945,-176888103,377690668,-812264957,-1186060944,-386477573,1205361868,-989202644,909257185,1823119535,785229205,-2146669294,1658864625,-1046476783,2009458921,-210462713,1698480405,1499501939,1070359643,802960002,-1574762144,-1209299651,1846950153,143984869,1998052623,1967631254,-1785451138,-1170862541,1728842967,1227737821,-539829618,-390421996,-1680896741,-1858551519,1386935452,-1081872574,1501004082,1446827899,2107965177,-125799937,-1128754599,1771659367,499516134,2137442064);
/*FRC*/Random.twister.import_mti(122); void (makeScript(14));
/*FRC*/count=266; tryItOut("if((x % 4 == 0)) { if /*\n*/((void shapeOf(b))) {((false.__defineGetter__(\"x\", (1 for (x in [])))) ? (/*FARR*/[].sort(Date.prototype.getSeconds)) : let (a) this); for  each(d in x) {Object.defineProperty(this, \"m1\", { configurable: /((?!\\S)[\\b\u00b9\\d]*?|[^]\\W{137438953473})/g, enumerable: false,  get: function() {  return new Map; } }); }\no2 = {};\n } else {print(uneval(p2)); }}");
/*FRC*/Random.twister.import_mta(-1764765692,-105801928,1314428942,1321383723,1190198671,-524040624,-720890298,-932452830,1617147427,-1125170404,208542702,39007004,226181431,1137068896,-2115760783,-244142816,993850032,1516592348,-460474274,-168280403,-795303307,-1591024399,-1740823592,589182906,-707485615,-770563836,445268279,-1896015021,1145387408,-1075409196,650846257,572455692,-2080235875,1621598231,1310814796,-1622005537,330762541,-1522166904,-844618285,2117466660,143499824,1085364004,-329205552,-316275669,1000303092,493517782,385067381,1966126637,1309913320,-554191817,1927117654,1202040216,-1684138423,-635402473,-1619584339,812264725,-429560183,-1771129740,824220874,322896841,-653903921,475780253,599390468,-1635142259,-2014214940,-2056936273,1160067348,1849679659,-1654503910,2116898908,1240331109,1839476119,-433716345,258143541,423752867,-1354150327,1604130945,-927931204,1044150321,106500201,1531936672,626097382,-1649371567,1037484707,1969915916,1042889327,597488442,2141858103,1581502861,895737984,1450937079,-908787507,880647781,1361930273,370850015,-1655960936,-959232891,1696949387,1766107753,-818982385,-1368739423,-727545356,1201973065,-1768818436,103163143,374038587,1803967942,-117128422,-89232348,-81725424,-1895248769,391147935,-158720049,1288096661,1472742622,1420172292,-1730473108,486003811,-1484652864,-1556090925,-1684577858,988633446,-23727166,2067875438,-2046525252,1012706929,1165760721,1191390063,-1008546730,-1670961342,-451108671,471777135,-362501464,-252969686,1406139894,-987403766,-1840818439,-696637735,1566576483,-340679743,-404282914,-1872531848,-1266661209,2048020135,-2021207428,1266890688,-690794372,1342562538,1648447910,593865552,-149931278,1531924760,917544073,1637588742,1281366146,2117137394,-1246925283,715184094,1602831009,-1204539442,1382309465,-1466323099,-1706506294,1599515345,-1085982651,-405915997,684946870,1826735966,1861794114,755473186,231756012,-1842411943,857949257,-1390204321,-96855830,1319328573,1390166987,-310252000,801904172,441540353,293398112,1612988705,-211538258,-837356452,-129613284,-254242139,-333556275,-709705904,405969353,1351202065,1809188663,642688666,1775649986,848153882,238785920,-1661288639,1046226690,-170058630,-1099837173,-1918964919,1311674986,533535200,-1464047714,856697372,-2050149398,-1135637196,-1164929601,99493259,-861649398,-1890595356,-1206098186,-1279728946,305201203,1450442547,2003136577,-558485311,-2062614614,-1699821912,-771322333,-1775037851,310693787,1331006964,729534612,-1277032292,1282799911,87375489,-113264128,1270435186,-1072138201,1117975732,-1069252544,1276610696,1846295607,-413509374,-1308430970,-726205071,-653611687,-195179784,-525618535,743760354,1727070453,523239889,886892682,632513294,2002406190,101622,460994923,796013422,-1653483053,-1486281988,-164368348,-2122836720,1422489038,1324850743,1680377881,-875485558,2054203338,-247206825,-1368363456,-799111448,939265049,-992137579,1848161538,2064983762,-1629438113,-1481772960,-179191374,698674853,1047681871,1553136886,717423616,1370305973,-260195198,721718949,2076800335,1100800042,1459582430,-1432461686,-1019179020,-1524485329,-24096377,-1097709849,-335487397,181029458,-2101269774,-1183159335,-1229076359,23987829,327551951,-238655812,125567003,1667350581,1280142456,2057553961,-160515852,2081773914,1440643954,-1143518155,1360516339,-245470993,1003331667,1937450063,-261484206,696474039,1643484837,195108739,-91296140,1799864121,851446850,-294135707,1172891304,-1210285279,265826320,-1657538292,-776739498,-1365016692,-113367094,1015939847,874250023,-1370357142,79325873,-1160661599,1929420055,841855780,-92260700,1479985900,1057051755,1762995945,-1515453684,-891043305,-199181230,-2054743928,27115911,819855651,-1433776484,-1262160971,628712746,-638955424,-588519292,-207552392,108033393,632483234,1424020199,-1192698024,-730281472,-690841158,243656345,-359835902,1369637274,-135559425,1888877910,-446433157,-1533239337,-1362686710,1507765730,-1147995312,-389781632,-1809263307,873613056,-356905394,254284787,-72643027,950118613,248589536,614526474,1668025228,1413018434,1666762961,863134916,1388988369,-1157281565,1356020027,-1324125282,-1433789793,1567889686,-1697373942,-1713661103,-1766056522,2045542414,2070781357,-953928823,-752034740,298794094,66128218,-1633558829,-1759813159,-59980872,-443908593,4510053,1550085825,2111035154,837537705,1360649741,-915818347,1917784296,1588310250,-1096549455,382879478,-1064695853,1699809288,-1680927171,1495880677,-83843015,-1125167211,1597804637,1480115222,-1320267854,-368888089,-1961952826,-1043987280,-1478994305,763119290,1273533710,-2007409193,-1194899165,607678706,220416427,737846082,307113545,879736144,-909404182,2059584133,556448529,-1403379243,-1716559176,-1493724862,222284596,-1241552165,416591883,-122055212,965543122,689524766,-127680444,-1126524752,1239989052,-824615692,-327232993,-518518920,2032203576,1785822541,225162455,1301416514,1435094270,-2056898161,963676359,1246485311,-463891904,1643714035,-1272939299,606515325,411377742,1630647286,2141804560,-937314969,296671842,-765399688,-237898494,373106007,258862426,-2032857498,1518413540,-479966095,-1946791594,966687998,251857117,-859498445,-10813155,1327347256,-245434041,553194027,-1506011852,1236116823,155096,2084376679,-546149956,788010447,-1729577882,-189307331,-45174639,2035952982,-288998735,318837477,681885186,1122351243,564758003,2012737007,-1187472736,2110995626,1474792672,452138371,1933455406,260252792,965928937,-320065435,409471451,54120025,-2080923142,-1327146562,1461706319,-1833636383,2117830157,418375625,-1202262100,-782375587,-806995218,-549277542,1129931701,-863628106,-2022125599,274061489,1317533070,569279722,2036015312,-65117284,1445981207,-744546080,120558953,1972655165,-1106244044,2141543499,2006648965,289141558,1667164354,759615926,-1284648665,-1265540705,1266900857,-1991285166,606691796,-312553276,1446035854,435370446,70321448,-245982936,-713901818,-897511397,1806085017,-1563227048,582709158,-1878261006,727917289,-2141029439,1207641146,-321697007,1064583361,1719446405,1039943537,1558051337,-1216249371,-1412040469,-1957750157,1574631957,-1642890985,-629691197,-2332267,1144719448,1275798519,-221663363,-926469398,-1234804158,590814248,-1475508036,-119975374,-992112403,-793053675,762420221,-823582265,1737349124,-642550682,-1734715689,-147468283,1842228483,1630910965,-496657322,635835564,236924826,605835980,-145865095,1760158159,1260086736,225824441,312418548,89170574,-1268550344,2036010263,1476290918,-935397928,-851855396,1425437349,-1227896128,248978025,-858226899,-625688741,-1227704343,-1008061427,-656100207,-411910729,1038862865,1195188346,-1610418386,1752657118,-1284000435,127276455,995673353,-1407203203,1931908785,-1082250645,766149949,1857194493,1042698537,2007783504,1246668929,1183822230,-1791378954,-95712850,1828655612,-294472285,-636938063,-1801238647,-1773328386,615364729,2091651483,1629016930,-1245441101);
/*FRC*/Random.twister.import_mti(175); void (makeScript(14));
/*FRC*/count=267; tryItOut("\"use strict\"; e1 + '';");
/*FRC*/Random.twister.import_mti(184); void (makeScript(14));
/*FRC*/count=268; tryItOut("\"use strict\"; var spujcw = new ArrayBuffer(3); var spujcw_0 = new Int16Array(spujcw); var spujcw_1 = new Int16Array(spujcw); var spujcw_2 = new Uint8Array(spujcw); spujcw_2[0] = -17; var spujcw_3 = new Int8Array(spujcw); print(spujcw_3[0]); spujcw_3[0] = 1; var spujcw_4 = new Uint32Array(spujcw); spujcw_4[0] = -29; var spujcw_5 = new Uint16Array(spujcw); spujcw_5[0] = -9; var spujcw_6 = new Float64Array(spujcw); spujcw_6[0] = -15; var spujcw_7 = new Int16Array(spujcw); print(spujcw_7[0]); spujcw_7[0] = 11; var spujcw_8 = new Uint32Array(spujcw); print(spujcw_8[0]); spujcw_8[0] = -2; var spujcw_9 = new Uint8Array(spujcw); spujcw_9[0] = -29; var spujcw_10 = new Uint16Array(spujcw); print(spujcw_10[0]); spujcw_10[0] = -2; v2 = evalcx(\"print(o2);\", g2);b0 + '';this;/*ADP-1*/Object.defineProperty(o0.a2, true, ({configurable: true, enumerable: (spujcw_5 % 3 == 0)}));print(spujcw_0[5]);m2.has(a1);{ if (!isAsmJSCompilationAvailable()) { void 0; abortgc(); } void 0; } print(spujcw_6[0]);/*iii*/e1.add(h2);/*hhh*/function kfpunh(c, e, z, spujcw_9[3], name, d, a, window, spujcw_5[0], spujcw_2[0], spujcw_5[0], w, y = window, b, this.b =  /x/g , y, z =  /x/g , spujcw_9[0], z, spujcw_1[0], c, y, d, c, x, spujcw_1, z, spujcw_10[0] = \"\\uD983\", b, spujcw_3[6], e = \"\\u547E\"){m1.set(o1, t2);}print(spujcw_2);a2[spujcw_2[1]];return -4;");
/*FRC*/Random.twister.import_mta(1779076458,-1482273836,-617028798,566220837,1766371533,-1853578470,-656753532,-1241121901,1179608472,-143048123,-349524119,347859330,-534437632,1042472984,1438978090,376892502,-1519651911,-1971219188,-942874757,-60315570,-496541211,1582350245,1709223565,2049537821,332124679,-177788075,841751715,-74580368,-1190865368,-950866957,-1527769251,-2082664550,300086528,513654260,-1078397778,682685453,-1367846540,-1238099702,-1312579098,-398982393,-1052726038,1326492496,-2048209017,1352925229,1126643625,-940005221,653709894,511266995,-63393285,-1657327637,1110164287,552060710,-801225943,-835314233,-1609820765,-711762037,-2095648931,1228837895,1123540035,1146773050,-1055359034,514920920,278488191,427418774,954085113,-379269668,-1752620108,28453840,-1277972451,1118128240,-523825108,1531267163,-29304722,865361850,-956190036,-154902201,1483039289,426042747,-1260638940,-1253112906,-434120626,1788758886,-1095107368,-730628425,-1793245427,963299231,-466084657,-1753162262,1833311663,185462532,-1070527469,-1798180083,-1418915508,-516170594,19210548,-1007422092,125186815,-1245516752,-1113139327,1305102837,-625730236,-1379582668,-1711533665,-1541397423,-1966938357,-1919565489,-304118576,-1297019652,-1563243374,-1646938795,505846950,624259289,-281145948,1701042145,196971240,1966516582,728578418,1173295991,453535702,1256465846,685963406,-2124744747,33947516,1956202715,-702737199,-655862667,-1747979042,-1835223284,-89984450,-1610235962,1581812026,286995584,-1792332207,1071071093,996248779,-736485749,56834715,583667304,1716613412,408238966,-354239644,-504104150,1947047294,681593815,-442245087,1821543428,-2066629788,240445458,2010021421,108288520,830100101,902922110,-1692911768,-1384180174,1656914924,500006598,-1893218516,1225816090,1478565823,-1137591292,2139998224,-2048700145,1086687221,-1516425003,1122116402,-1397692183,-223513790,-406410572,1005737580,-939456079,-141366281,422209181,386102055,-1977033616,-1818808254,-783079217,-727356602,1912610746,-1707134779,748823036,1582618166,1364981400,739254270,1901522871,-201598599,-363382601,-558224752,-1404374740,-424541391,1692223132,-568400751,1612533956,-1349964723,164286633,1538101330,-2053460774,-1942210092,98200663,119763434,-2140801918,839730913,1399002037,-108338656,1787950379,-313494569,-1009324121,-525900013,-1974604936,880898115,-479192816,1953952858,-1096632005,-1944641937,-719957841,-65208258,67685955,-663823710,171998816,-1091688431,1043882673,-39592373,-2128695357,-1883495504,-610274251,-415351292,1569132130,-803687158,-754056794,-956878450,-82140318,1202986081,-951706103,-1574334565,-2116302265,1163277812,-1279097877,-1923635399,41404154,1116838259,1247089061,-1464709073,1336632431,78601681,-1631136210,-1971235977,1400468241,-337726983,1977040339,233058011,519657119,982875541,2041538784,1259623569,-1724848016,-563778251,-1002666547,1727769863,-204988291,-336442130,-753646637,-1510237599,-928207313,356149092,939572740,-438116038,-882163393,635618442,1198600594,1633277227,-1869918841,-512087512,2065295848,192044822,-2112169922,1052188838,-683209964,-2005401426,596346053,-344035730,914283317,142052971,1325714001,-1862894942,-2106164700,-1937043148,-2136897376,-1645875745,1372834558,642916998,-902835027,-1312705453,519608517,1295882519,-1396801586,2142799741,-1724084828,-968466763,289688202,-85799693,984529048,-1826521790,-13321723,990739779,-241755724,-2051220891,-1986307554,1508142325,-8397201,-995289205,-598896756,1452642296,-755947771,938687257,-1931350428,-1060019668,299437642,-868065704,1127498591,-2080837064,1882756299,1700509329,-508698784,-622514970,976628141,-640054970,992922987,-532124066,-933094206,1371303136,-471052362,-421287915,1392817943,217215233,-124083298,1910228473,-261194233,-1323262619,1884514532,1558573285,890144707,2008719664,-1195027644,1765983946,1095851122,780558250,-985521083,2141359671,1077114947,598180981,2051998167,-551549895,492563429,-1886661904,-81747409,-1890202972,-1899970050,1931044227,71412410,608580519,1270323063,-1693824836,-29759362,-747468549,288574878,326896558,1280116869,-1326321727,-212104954,1369335837,-259554864,-641636459,-47556114,-1595985516,-362039313,54458519,-1574239398,1294619859,1301025410,-1854996105,562208371,-991332332,707075547,473299563,427792538,-1684703191,639073891,1476146140,-1499000707,853137072,2116840572,610297822,-211387157,286033020,-1953825994,-929860927,-1112859797,-2090325302,1323260097,1803739801,-2081666842,2142553437,924832897,371998682,573805495,1578925489,-2103961828,-1062532528,466856661,834204864,-420183010,669568234,-703622146,2004035203,466697950,-27866795,2032867131,1897928509,1311851370,2049608300,-1955797064,-308084428,-768574203,180292847,-1058305912,1453434102,1102877808,59961648,-412111301,1866455391,-1521721271,2115853604,-782134283,-1648647169,-2074920307,-1390328574,-608786029,-1812194644,149327814,311605058,329938139,-203467378,-690362815,-1615633829,501100062,-1234361568,-1933385423,-674473833,2126205178,1241859874,-2080459881,-351851058,-655715828,-526425074,-1731209157,-96569574,-1105212657,688685334,1073933004,-1003710150,-815194903,694246560,11345247,-284312172,333353864,-1122108868,-1540052702,769379001,152411219,-2032181851,397498187,1662563418,-1971290725,-194032643,-999848665,-1146910741,26243304,-39168674,-583363326,84049483,-444597994,1236849117,-902352332,2085022039,-282599647,1362847317,-143785538,-1375871610,-1912054767,1558025265,749043571,1069624376,1612915217,1679157714,-253857608,-538614175,1621231062,-923147944,335377872,-347394105,-312005425,392534789,580671344,652298597,-276095527,1277877384,333082475,272486766,-758949564,-1641638186,-1212841883,-1837025199,-1339653796,-1095845522,1878698763,2015124110,-53651219,1777159788,-1362513079,-131955137,-268915318,-1541175723,1310192412,-1885346433,1190659833,-771470694,103535504,1040780209,-1053438552,-912534937,1343561092,-43088557,-2019272463,-1322248566,861745270,53995197,678883992,-853276256,130562091,-621336964,-79029582,366502747,-1557336015,-1095230691,183553767,-385702334,68051295,-950085360,-409745732,760189898,105517312,-841751432,1339589906,-820139051,112126539,-1434478354,-290370108,1132472535,-2105527968,137856566,1567227669,-325294144,230124768,185075374,1081431728,-1075636795,-493236007,1187539905,1533221635,1837156592,-1949262313,-1363215828,-2028719217,-193926546,760317025,1195175822,833203475,-656371148,844907521,953571597,272205171,-227593643,-1912759325,-1796113566,-1766042665,801021449,5851467,757812377,1752809777,-446821090,219264272,-1369980201,-416357156,-1909660754,1208763672,102851473,-1154513383,930796551,-94373976,-315940231,-723220485,1792597398,-637713765,646959361,-1037238222,-1390941947,400073885,-295736270,1790479413,-1405188720,669242947,-1521452027,-1194155806,747348632,718927627,-791111549,-1662501698,-1977593605,-147229499,-1203704044,-632100705,752108324,-132179088,1044488813,-160600961);
/*FRC*/Random.twister.import_mti(114); void (makeScript(14));
/*FRC*/count=269; tryItOut("\"use strict\"; g0.s0.toString = (let (e=eval) e);");
/*FRC*/Random.twister.import_mti(131); void (makeScript(14));
/*FRC*/count=270; tryItOut("\"use strict\"; mathy2 = (function(x, y) { return Math.tanh(( ! Math.imul(Math.asin(x), (y == (Math.round(( + (Math.cbrt((((x === y) | 0) | 0)) | 0))) | 0))))); }); testMathyFunction(mathy2, [-Number.MIN_VALUE, -0x080000001, 0x07fffffff, -Number.MAX_VALUE, 1/0, 0x100000001, -0x07fffffff, Number.MAX_VALUE, -0x0ffffffff, 0x100000000, Math.PI, 0x080000000, 0, 0x0ffffffff, Number.MIN_VALUE, 0x100000001, 0/0, -0x100000000, 1, -1/0, 0x080000001, -0, 42, -0x080000000]); ");
/*FRC*/Random.twister.import_mti(272); void (makeScript(14));
/*FRC*/count=271; tryItOut("\"use strict\"; /*RXUB*/var r = new RegExp(\"(?=$\\\\W[^]?$\\\\s{4,}^|[^\\u00ee\\\\w\\u113e]*[^](?![\\\\w\\\\0-\\\\u0059\\\\W\\\\n])$+|\\\\2\\\\B{4,})\", \"im\"); var s = (4277); print(r.exec(s)); print(r.lastIndex); ");
/*FRC*/Random.twister.import_mta(557322397,1122688773,1092236460,974977556,1082374166,-1087932090,633492186,1534689042,-2000748921,200061840,49870605,22474484,1038333602,-837851652,-49765575,-1727263895,-34716432,603878786,-551363892,2033469783,-729568704,-1600872816,-1735736971,1263806619,-2048070154,-1764654888,-1113000346,954218999,1202557247,244003985,1855878125,-699843564,-1371389883,2061009169,1786810826,2068931786,846441768,1490401621,-818400272,-1482670901,-518026247,-1835511101,287665041,-2044424621,-1821674670,195478410,1014217770,1030664129,653399449,-53981673,-1354896511,-2137579054,1242759005,648795051,1670762278,1753613702,-1009531949,-160841027,-220369497,-1757024590,1611764559,680999908,941578090,-657721556,-1741654342,-538710186,-193656079,-1721274258,-1514563514,249652899,894419155,-209298221,-496146372,-1276334846,395947870,-517846514,936325743,-1817150489,-416730967,144556282,1312265134,-191806171,921854250,1774819453,-1530961273,-1384075089,1608201636,-1849985984,-876336766,-1857071313,-163281688,-135647898,-1227973622,-45827128,606359905,690209158,1778485568,540343017,1318023443,-1187209653,473159289,-1794061060,-1544452406,-1152348425,1101901756,868320627,1453357201,-376569413,-945546022,2082459335,-951271074,-1887130353,1003027671,-1487359749,-1848765641,1446461072,-1096551776,-1748841775,2051526575,-1746415343,452163681,-1708454468,1922940461,1449494700,-845571625,468369244,-222663750,-389054167,1244856143,1135414039,919380981,1444795636,2076376505,-745978523,-1990415681,-427822068,830913240,-868846167,1858136376,-596607109,-1908078503,-875067667,499560549,-1079270461,-146263647,1851020235,1677724955,487160534,1907202620,601953707,1229151944,-1627440245,1107641472,1487416685,-546792737,69666821,-1692467685,1657647675,816366088,-1040554303,-566543802,-1094439982,-2047614255,-912909554,1507842322,1011962334,167493332,1772598150,1532395944,-1810367803,-1032204255,-1130987114,912127777,-74043418,571482518,-1695675709,1468930644,-727743770,-1819095833,-294455715,1401704175,-1400937725,-376250314,1041051247,-1617176098,-1648381402,-13766131,1000648515,1692327776,-478920050,-1734040459,871255891,-286045924,-1276630660,-1405197113,-1998656666,1496906804,535268496,566072611,1118740686,-1627998229,-1289090084,121497885,-381905412,777333133,-1707430861,1099517363,874008355,1293908561,1907216434,522781768,-1343374369,574518494,-614289038,444051063,-104360528,740988554,-1172884868,-1649972016,-1470359600,1320808479,1762328520,240405781,1623095570,-1463181820,-1276198643,-220475674,-2047262458,1520306791,-1404351124,33293083,290562596,1734781876,-500957906,616484291,-29853276,1057727145,-986420748,1527568537,-1660902026,-1388668915,1574343085,-664732169,-2014819520,-284602174,-1570847137,-204899230,1851269549,-1257377810,-129616071,-187139785,2147008005,1246923005,473618516,1347691122,1940579439,-1103133810,-1674519994,-1498227270,956633287,294564958,-120861898,-1803159713,-272244945,1794901008,-414557704,-993690407,-1391546152,-1681999296,-750150026,-1292986113,746680382,-118054864,1629395822,853036263,360458284,-1854698440,-1280348649,703638573,-1654919527,-301253801,-972115761,-536846233,-1025690359,-745696340,-1033256862,7661532,-844971207,1770650062,86398133,1141359617,1483984817,469951753,902615089,533268990,-1892373581,-1156908673,119273020,159059735,1751160971,2094425105,1263979564,-467171494,1162816596,-992559060,707326782,-1207912976,-318570367,-904700526,-1159872743,-696463719,1428587062,-809029426,618994200,-69232440,-1107585902,-16424699,1534314273,355229932,-787729021,-351232860,-2139745405,-1824354216,72432842,2004953479,-1756450559,-270765866,462818943,706414933,1731882896,324008323,2005680861,408609201,-778644800,844549341,1294940578,1258963562,-1839730493,-1133745946,-1486952885,-665392194,-736733504,932470861,-642050196,-932080600,-1056317414,1362420866,-847483804,1043445918,-1957334507,-1858439117,-1645615429,-1494461547,-962543097,714192576,-1162050904,1659171941,94790799,-2102595724,950533714,1753873502,1088181387,1790205337,907939713,-1633656409,-1221324369,100921107,1528082067,321024123,-461109493,1680213088,104224701,1693640950,159144200,-1202380417,29048538,-1937014329,2110153988,2125928541,2052131166,-357128577,-1116710696,-430058084,-240342501,258373423,1806055447,-1578072079,1612081935,1166240042,1246768759,1974361835,571619416,-2110626773,-1039102009,-4326524,1986123909,470083226,1678676505,-929197895,77917032,-985158773,-1342111187,852310209,-1481290539,239185499,-2113469782,1986831380,-1000934322,-1656196862,206865165,-1498262324,2108756387,-287126084,-283838453,309528545,-1546880926,684581987,918436023,-1175451380,238238610,909826991,-1742866105,1837814642,193967258,42831600,1331184918,-912336513,-204022238,167217810,-1537913087,1263654776,1680856682,738178923,-1782055014,-622875299,1695863471,58314201,1859722285,-651540007,-273966093,-1041954299,2103329300,1520994746,-1312466852,1997967989,-185254034,-1383985179,2098035699,-578202295,399198085,1408757297,-916927471,1537006146,-1897687364,-764182521,1391093174,-921066947,-1672850018,719056702,-1282906498,2114010559,2140068848,-2013691896,-1142347513,-1140658925,1335349647,-371684997,-1486395327,1019625200,-1758966688,360283839,1583598756,-1118936231,424695149,1390514120,248679183,-1253177720,-1962711551,571355441,-1000584107,-1908599716,-156948849,-1502633958,-900201439,-588663725,1615315872,1291439609,1031112354,628153028,-153795330,-226596989,1155671419,1833796312,1182797153,-215878737,-1234759753,125040655,-235332337,1665072419,1124193878,-1605957949,-218071033,1442357947,-189100638,1916415749,-1809320061,-191632841,-1630905598,-1833342590,76522961,1970330967,-1055707120,903007195,502943801,443203796,-1230389370,1251192458,977104017,615808927,-1402596463,-82400319,2102761824,1747991103,795578951,-1354667377,-1546965063,-594557750,-940971421,71718501,357020802,-1031043310,644843301,1919426998,1115716700,1568575942,-639167680,1615833269,-837571058,-1924324802,1892115475,-1510351917,-8183914,143405261,-1127704809,-1483525460,-837886775,76924967,-53067896,928032895,-2082648035,-330691835,1293621268,-1659361289,-2104439494,542606371,-709836636,418699160,965089666,445298252,279731787,-848639515,-107785193,1573925147,-1858776511,594686750,-707251296,1621675755,-1456943343,-94261828,2071357980,1521973476,689587065,-1300216685,-1760959942,1288396012,590410764,-1457209122,519025055,76463602,1947304395,244221373,-1041969741,-1269714819,255787306,-401958813,-1718662136,-1147285983,-254990303,-1907555739,-1615573701,-1962593556,-30055185,-87795348,121075277,-283122377,-1790936313,-1291808693,-971580846,351712795,1957649154,-1741745685,-729118203,-815494963,-744762308,-1948502757,836628534,151709156,2111078546,61893998,-216330014,-1338239299,1694472086,1746582599,1070127409,-264800745,1451662931,-337389292,-209258170,854247899,576100098,-1276690689,951628022,546424461,-711959029);
/*FRC*/Random.twister.import_mti(133); void (makeScript(14));
/*FRC*/count=272; tryItOut("\"use asm\"; v1 = Object.prototype.isPrototypeOf.call(o0, v0);\ng0.h2.set = Math.ceil;\n");
/*FRC*/Random.twister.import_mti(180); void (makeScript(14));
/*FRC*/count=273; tryItOut("var dsrypx = new ArrayBuffer(2); var dsrypx_0 = new Int32Array(dsrypx); var dsrypx_1 = new Int8Array(dsrypx); v1 = a2.every(f2, o1.i0);print(x);");
/*FRC*/Random.twister.import_mti(242); void (makeScript(14));
/*FRC*/count=274; tryItOut("o0.m2.set(b1, g1.m1);");
/*FRC*/Random.twister.import_mti(265); void (makeScript(14));
/*FRC*/count=275; tryItOut("e0.add(v1);");
/*FRC*/Random.twister.import_mti(278); void (makeScript(14));
/*FRC*/count=276; tryItOut("\"use strict\"; \"use asm\"; h1.toSource = (function(j) { if (j) { try { v2 = new Number(f0); } catch(e0) { } Object.defineProperty(this, \"g1.o2.v2\", { configurable: false, enumerable: window,  get: function() {  return undefined; } }); } else { try { a0[0] = e0; } catch(e0) { } try { s0 = ''; } catch(e1) { } try { /*MXX1*/this.o0 = g2.DataView.prototype.byteOffset; } catch(e2) { } (void schedulegc(g0)); } });");
/*FRC*/Random.twister.import_mti(349); void (makeScript(14));
/*FRC*/count=277; tryItOut(";function b(d, y) { v1 = (i0 instanceof h1); } ;");
/*FRC*/Random.twister.import_mti(439); void (makeScript(14));
/*FRC*/count=278; tryItOut("mathy3 = (function(x, y) { return (((((Math.min((x < Math.imul(Math.fround(( - (x >>> 0))), x)), (( + 0x0ffffffff) | 0)) | 0) >>> 0) ? ((( ! ( + x)) >>> 0) + (Math.fround(Math.asin(Math.fround(x))) >>> -0)) : Math.fround(Math.tanh(Math.fround(Math.acosh(y))))) >= ((Math.fround(Math.round((((y >>> 0) - x) | 0))) && Math.fround((x ? ((( + mathy1(x, ( + ((Math.PI ? x : (y >>> 0)) > x)))) >>> 0) | Math.imul((( ~ (y | 0)) | 0), ( + Math.cos(( + 0x07fffffff))))) : (Math.imul((Math.fround((x + y)) | 0), (x | 0)) | 0)))) >>> 0)) | 0); }); ");
/*FRC*/Random.twister.import_mta(-596423356,-401569041,430610018,-452561024,-1349337458,1613500844,-1979059364,-1827249721,-940483742,-300388531,-990018764,-2084984237,726872563,1094628751,-1472224056,-1877610556,-1091845430,1038248583,1180625942,42742083,1727297535,1824381289,-225337600,885828948,-747292373,861841473,-822667074,-1202456912,-787124351,1742295126,-655212504,-941745553,1077002070,2115084189,1502045199,851862015,547722223,-45894491,-1345553387,-352405254,-1096972909,145771726,1974561797,-2007977044,948773841,1150375855,914014051,-43571098,1402579130,1662274298,1028057882,562600504,-1651106161,1648167330,-48509230,-478311564,1826604861,840271371,424186607,538565445,-2013149076,919880843,-1611817496,840500962,276769883,1691071919,-145059536,-287432400,-1846554111,1786239437,128775927,1307609838,-824304927,1588963600,1861413283,2141276849,-1988044735,-1199724733,1251765106,-1839870113,675509324,2037842340,1773154484,90838464,963497479,-914212152,-1031422463,-1190420334,-1310140184,937136013,1182830609,2115474625,-2005460710,962920428,1349764536,1481459320,-812465974,1299119097,871493709,-798841876,-76448911,851852870,-2019483150,-1064185571,1944646241,-408932820,1500855712,300425576,1931518015,-684356968,1073790298,1448453942,-1909764749,-1533058029,-1442271400,713241227,-820804210,-29255716,609413073,-1629314459,925428303,-990769066,-2024482873,1154668533,815843022,1366101986,-1039867380,1397794295,454367981,1591813615,-320405479,-1599104922,-1517574417,523068050,1431338275,715881690,-40634793,706667866,1859623970,-1100637114,854646183,1520880339,-166066899,1196782556,295798444,-1551595873,-1303631236,-1622802510,1190586051,540305219,1788940946,1448217151,914486900,1526134453,-1778373431,161474597,1795073272,939779367,1816478491,2011777723,1726221419,-1048840197,1952928716,-1585109652,-407110408,1496182385,-1511617662,249131978,1188789789,-1734568412,-144470054,944236275,1186823663,197093423,-1117391161,-649639495,-1119476919,-1677030848,-855556099,1508530038,-1848069951,1883753961,-1306548701,21195090,-1891953504,1389361572,-874125740,-630851629,-1472893617,1858546884,808632151,-1187731733,-968861307,1142075472,-1168502436,-1772607626,147107845,1724489593,-1273549984,628325217,-1618747460,-832507318,1076957692,1443706354,1084189891,917020363,1352614770,878393580,151722031,111044544,-215290462,1387222785,-559265701,1678733657,1478253902,1041233666,583221263,-1092304769,44602811,364351940,-956070238,-1396154482,302623627,-1484525059,-129539921,1509695998,-1754464632,674560168,-30069671,-1067702480,-307321198,-1675498668,1363013435,1096688994,-1408606955,24918761,-863872073,812867495,-1925580568,-456733398,-1227010682,487025388,-740177308,-915445077,-171591305,1069175335,-324497078,2087878664,-1986629078,301273924,-768064887,1867828618,1027851371,-421721721,411972696,-838160826,700530037,-1951715595,39068371,1224140153,1114929670,-1966264449,-601080137,1440453095,-823748519,1420194470,-1132863338,-213722957,1628734453,-1244753755,-569373773,83260361,874387992,-1239537201,-136758160,1528852134,-1546957522,-256504365,-1238508117,1939551227,-1741496038,336809534,454795567,85528299,1394697786,1500700929,-1614804474,-54184821,-1387274738,619106103,-2027400731,-2022248960,-416977560,-121760305,1884079158,1432493665,704258771,-1709588061,-523733388,1774032950,2065616646,1558260238,486988955,-1410615209,-311828772,1453076874,2111635392,1296751237,-1122930953,-1685657817,1878611163,512644704,-1678723132,-9801115,-403281189,1466095797,-1016406846,1276551271,-812040481,-33597624,-531151118,433229204,442882077,1834673366,-540994650,1142933542,77665292,2004111108,22743438,386821612,1650409644,-422759834,-815052980,-1722356975,931118521,1453687050,1192673830,506890537,-1661836084,-503301972,-829141133,1758080929,106871101,-1423224934,-1631229999,1288213904,-1201892265,1747990016,1481644419,1455512321,-1825663881,-86089765,-1422533058,-1756612244,1309598883,-210776064,-986011785,-307136605,-50567345,-1848682304,-1504970744,-117251280,-1465070651,1808496219,-393454254,-1260463244,182942672,-1570155195,-236160631,-2079783139,-582555427,601420503,-1489327589,929958428,-543661857,-642017537,1591170497,-856543645,1803194000,-1697507948,72276697,-449919481,-398389769,-1270534224,-1797764621,-441077700,-1628778525,1143322878,2103136287,-675754906,-1332987584,2141879858,-1590879923,-633833920,-320786601,1222184272,865300471,1244002137,2048234311,-48883467,-893953562,2097928824,1402298124,1668170939,-1660351723,-1237881353,2076257617,-545486784,-1352319824,-1589212091,-426552996,-1203080578,-1135790722,466933115,-880555038,1700474785,-326074304,751483857,-30590174,1146455181,-787153876,-861964059,-1818231493,159545213,1097186802,164689664,1553470576,-612885771,1162011925,630848064,1679482567,-865597527,1011572998,-1527241469,-539369116,-1849733604,-1459988215,1186429329,-1133368793,659586438,446713939,1967659411,653089580,-1069499926,-2069995576,-849272170,-231105310,1892654297,2116373651,-1560613812,438773546,-1786180210,1586358944,1734184532,1094830707,1135693208,-1904669185,-1195159283,-2048534421,-1221213893,2123974810,-1342792431,-981459275,193699297,-827324481,551357578,779995605,-390180098,378752220,5621220,-430011143,1919563780,-367343538,-975677778,-502041264,-1825476242,-847507301,439872206,-730702977,2052935237,75967007,1270473813,841882761,-558016637,-74920155,-1121946384,1447831080,1355552612,-1314419456,1008450985,-1365101691,-130000587,-286341943,484551070,830074807,-1146761427,339390205,914867709,628529378,-1120589402,1452726547,70114802,1635592311,1138682483,1672300237,1433180271,1023286906,-781298213,-816042999,-1196720293,630232803,-1866419448,-829982270,-1829410196,-409867448,-939128501,-1594832480,209379061,139286295,61245527,-2045453953,-581146122,-606115939,-1487788213,1391781536,-1903193071,-1824399912,-1607117589,1447227471,1011031826,1641335578,-732049913,2010910628,1399043875,1639535397,1413352050,-1131466720,694142404,-1747786,268757746,-2136212050,985186914,-804379679,-1868348012,-1306951972,349923859,-1013692276,586654226,-2127260347,-179802816,198666460,1212526722,89632443,-847092030,1571565398,1294033474,198009133,1863981962,2006166940,1893110625,2090332613,-1063315989,-952657675,380623785,886739193,1974383462,1872556027,-1281058387,359733935,721749327,648994553,512619847,122446989,-566674911,2041072646,1287813612,-2135018735,-1855337842,1507733473,897199167,783740778,-1926329278,-1259319147,1748458393,-1586048601,943337600,1889631247,2019936741,802190706,-315731277,-1915128589,-1779535388,1850593421,-1537197676,1908529177,828670323,-419272140,238355215,428826454,841323057,-1004273727,555914342,-1334412063,-2110652525,-1810049416,1879047266,-1539811875,93777006,-593277322,693614198,-969218949,970827535,1666804859,1073333303,-1234286840,1219148949,-1367625531,1894903154,1853961651,567686893,-2040254917,1705082062,-82210166,1571473749);
/*FRC*/Random.twister.import_mti(210); void (makeScript(14));
/*FRC*/count=279; tryItOut("s1 = '';");
/*FRC*/Random.twister.import_mti(220); void (makeScript(14));
/*FRC*/count=280; tryItOut("var ocetuz = new ArrayBuffer(6); var ocetuz_0 = new Uint16Array(ocetuz); ocetuz_0[0] = -7; var ocetuz_1 = new Float64Array(ocetuz); print(ocetuz_1[0]); var ocetuz_2 = new Int16Array(ocetuz); print(ocetuz_2[0]); ocetuz_2[0] = 6; var ocetuz_3 = new Uint8ClampedArray(ocetuz); print(ocetuz_3[0]); g0.v1 = Object.prototype.isPrototypeOf.call(p2, m0);Object.defineProperty(this, \"i1\", { configurable: (ocetuz_0[9] % 6 == 3), enumerable: true,  get: function() {  return this.m0.keys; } });function x(/*UUV1*/(x.toString = eval))(w = /\\1+?/gyim)(4277)/*vLoop*/for (var ptfjap = 0; ptfjap < 109; ++ptfjap) { let c = ptfjap; for (var p in o0) { try { Array.prototype.push.call(a0, g2, s1); } catch(e0) { } try { p2 = m2.get(x); } catch(e1) { } a2.reverse(); } } ");
/*FRC*/Random.twister.import_mti(510); void (makeScript(14));
/*FRC*/count=281; tryItOut("\"use strict\"; i2[\"arguments\"] = b2;");
/*FRC*/Random.twister.import_mti(526); void (makeScript(14));
/*FRC*/count=282; tryItOut("\"use strict\"; return x <= ({y: [x], NaN: ({b: \"\u03a0\", \"-22\":  \"\"  }) });");
/*FRC*/Random.twister.import_mta(-1490746639,918607990,-812309707,-1652685151,220058286,1452385954,-1276263289,-17717596,1479797390,432008395,128511414,1673794710,416376413,-225672392,-264206948,-482814949,-601009945,-391332375,-48920609,1189219168,-2086869062,-949619550,506712615,1638322278,205036570,-1260097180,1437305893,-1326990611,2050776875,1893807204,564111133,626670270,-2087090863,-774775777,1275299721,-1257170898,55660430,288845745,-457174431,1857825567,49242102,530722042,595076176,-538021532,-838335845,-1529301950,-17617447,-313357419,-51705877,-325392017,1611387333,-370740469,-740005731,615170115,-466106316,-1310017055,-413139570,-722652197,-894103323,-1971721783,2057421719,-1978460513,-298237366,-273781144,77330201,-30583251,2095353209,525295200,-856797005,-1264385423,-834267255,-1460342413,1863258476,1211058423,-726520445,2010256561,15611344,-2023931671,51586590,-1721914691,646736412,-525712603,2028487845,-2126938685,1870199089,-899386538,-2110224438,-1552112815,2143618025,-335225089,-154178085,-1248067187,1621738079,-2036608679,-731448823,-920148820,-480353091,-1316378802,-1818976549,-259349606,1877269214,648415259,1148547575,-1234562820,939379428,231192231,1261107911,-1019894259,2130074915,1560166615,-96172480,1363229295,1944878477,1888797007,1552521874,-384910587,-304766590,749742207,1585440934,1651248216,772003550,-756052949,-121154702,-1639663080,-169153017,-86174053,1475528047,-965289207,955758137,1010494731,-261973800,-1651534873,1943383643,-764132012,-1056411542,-803388336,107791758,1456643380,1259127889,2097147436,-1660678030,1575020287,1940804380,-2005188872,-1301138958,-1993853217,-553534899,1214954850,-1647711891,-154877499,-1865017390,-1703645569,1094428357,-1713385881,-1786579889,807992519,1217078414,-226083324,-270698560,-1581787193,-693153624,228590714,1611923927,256511929,889278988,-708518604,1371759180,-1900044504,2044786804,338503702,1989138955,-1356393337,-1210973817,-1592486587,-349773500,-1058552330,-1875083519,-2044697817,540496471,291167150,1883413669,-640070609,1977325718,690709818,-464949104,-1862097985,-1676865361,1818548191,1331275490,-240086149,-34133425,-705107601,-1893266789,-1863025571,-557686177,-1289275312,235685623,1808420265,-86668260,-389839382,1761966634,2039994280,421726408,2103769471,-1551995940,-1741038248,-1742969883,160557744,1823526786,-1649597684,-171313359,1795086980,-1034371579,-365638948,651844750,-349143901,-1182591785,1848818954,1114731639,-1912966252,647348917,-1098035031,-1423999284,1666133683,157248561,-256905778,162575617,20390914,1458490350,-1186828164,-747703541,-57960980,1983820819,1021336274,658967311,-411404406,-661720121,20189634,296186371,1136640158,-1139853746,-642752338,512217489,1070021763,779691045,-884879494,953895780,-2024284497,-1885373184,-1373158468,369931939,-1953378576,511853944,434935305,-1746735666,-1210814130,-331607103,-105052501,-1742079779,-1566328750,1304427391,-1155717107,1190420482,-1121275011,2070173410,-84090326,-1911162983,-345133357,-1672620937,-713518762,77461599,-737734761,652152954,-2061519903,-2134721338,-317808260,231300953,-1575645233,153344553,-537061360,1856202588,1890756732,711888459,-825274733,1633481604,-984279578,1830011731,738602128,1097384411,1957026407,-1407903384,1997095341,461040661,79884130,-1393106545,1092350213,547836543,-1105056589,-601211544,1384150767,1717558768,1127871249,-80775099,1985665726,-334276564,1040013822,653293344,-1593021000,878805097,-1776525801,-1904322829,1652597459,752483003,1758134904,1371897812,1584426376,319241747,1208697451,-882660823,276980006,-898459757,1079813848,-7678265,-859902610,-746175651,-1849420579,-886012904,1867079193,757153517,1968886177,-2062775857,1346922818,-664505360,-1986161468,-395876728,1568488496,-890391396,-197282778,541140537,-1917916437,-1644599744,-961644845,-56943416,1002414773,1255432887,-614919598,376706904,-1692177728,1619497332,1750641046,2049123626,-1603272424,-1317336531,-1443035167,-4115703,-1016965795,-739580411,387193760,-714588281,552620639,-1359661876,207005015,1022381986,841673511,213774478,243235257,-188484527,2096798825,-2031299154,-2080008275,1084225356,954717216,-761318447,1774533373,-1111505214,1806365522,1236624939,-445951846,-1759681355,-1709933706,843062715,2024456811,1779067679,-1678790488,-2141395430,966828270,-1012593736,1896499320,645685833,944905591,1889480864,-1130402187,-1193744876,-1095023304,-355264128,-115212464,-1472765083,-762469513,145008674,-762729100,-544114567,-1024700734,1750620020,128993876,1144218883,-991988704,1055170446,670040829,275954386,110243896,1963875333,-1167070673,1172339165,-1177750178,-2017333040,2031216322,1054703180,-1025394722,786078710,-1481804659,1874030832,235219997,1861137201,784242702,1864513065,-728136156,1551317071,-1834174337,1801136776,-1306077324,-1034401164,-44311713,323845894,-135228585,1095650750,-1580903463,1744711451,1928876797,961995847,1442850547,1234728650,900526360,-888135594,-70501581,142748737,997046790,1821707559,-2138057693,-1343215985,-435360423,1770760308,1712953697,-1023333660,-1340546841,552567502,-925172274,2083219493,143962081,1041876398,158470238,-1307335547,-594561910,1001851301,1725841607,1364891527,-1617877450,2011228641,-146370528,-644185508,-1264572622,1190273153,460603394,-1448221651,1238561228,-825268712,1881785746,-482560293,-1522717757,1874319629,-2050400088,-1523002116,402477909,25324112,149996684,-1490207533,-217060407,-1966754848,1433157119,2081965574,-928134881,1476538168,-1793358759,-1265879323,262254749,1874327962,1331180502,1463010167,371635246,-895640764,-727921620,-2029429480,695506978,1441359002,-1525199648,296448807,391959828,1849852450,-1878670969,-1242585330,-508660251,-961603817,102715237,-1943035696,517682935,-787638038,286303499,-1416624702,825950780,-271403687,-2122829707,1785519001,1477567134,-1950723457,1239228719,544036452,-1786063996,-1684902843,-1804200696,1561885848,-876274232,-981693086,-1745002498,-1924910416,-1893437843,-1961662335,707139705,-1028408075,-1316160344,713217962,747373676,899113801,-523575557,371314498,1242268029,-1687271491,-357986705,1106882607,1407217134,989368440,-1168022871,-392415953,1210393823,-1224398916,-1511615565,1239019320,-1311818076,1121442916,-1094361343,-248803283,2133277645,819637998,317987373,-1893572293,1233669183,-823464555,-1903697637,225711842,1313430472,1243890859,1992606571,-1376655159,-797253586,1833779101,1788883291,-1119726026,-103794653,552357073,-1882947067,600156120,-1507820136,-1351990848,1018276764,779176014,1515798025,1258882016,1949315423,-2050357646,-1189278091,-1547092783,-485210876,2027803605,-493639657,474965363,355182722,-46109681,-1251090252,1511499509,1280858343,-1191334425,1770421486,961835214,1015826541,-1279607740,62590231,-1835749717,470417028,-656470719,470923904,738269520,-803231235,1577702384,687399160,-1084952022,-661510084,-1940412691,-1471608076,1076554702,-556328282,897369564,585253334,-865338529,-681586491,251407141,581784258);
/*FRC*/Random.twister.import_mti(113); void (makeScript(14));
/*FRC*/count=283; tryItOut("mathy1 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    return +((d0));\n  }\n  return f; })(this, {ff: Map.prototype.has}, new ArrayBuffer(4096)); testMathyFunction(mathy1, [42, -0, -0x0ffffffff, Number.MAX_VALUE, 0, -0x07fffffff, 0x080000001, 0x100000000, Number.MIN_VALUE, -0x100000000, 1, 0/0, 0x100000001, -0x080000001, -1/0, Math.PI, 1/0, 0x100000001, 0x07fffffff, -0x080000000, -Number.MAX_VALUE, -Number.MIN_VALUE, 0x080000000, 0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(177); void (makeScript(14));
/*FRC*/count=284; tryItOut("\"use asm\"; testMathyFunction(mathy2, [0.1, [0], -0, undefined, [], objectEmulatingUndefined(), false, NaN, '/0/', ({valueOf:function(){return 0;}}), true, (new Number(0)), 1, (new Boolean(true)), '\\0', 0, ({toString:function(){return '0';}}), (function(){return 0;}), '', /0/, ({valueOf:function(){return '0';}}), (new String('')), null, (new Boolean(false)), (new Number(-0)), '0']); ");
/*FRC*/Random.twister.import_mti(211); void (makeScript(14));
/*FRC*/count=285; tryItOut("e0 + '';");
/*FRC*/Random.twister.import_mti(220); void (makeScript(14));
/*FRC*/count=286; tryItOut("var qhrpwr = new ArrayBuffer(16); var qhrpwr_0 = new Uint16Array(qhrpwr); print(qhrpwr_0[0]); qhrpwr_0[0] = -21; var qhrpwr_1 = new Uint8Array(qhrpwr); qhrpwr_1[0] = 13; var qhrpwr_2 = new Int16Array(qhrpwr); qhrpwr_2[0] = 3; var qhrpwr_3 = new Int16Array(qhrpwr); qhrpwr_3[0] = -12; /*RXUB*/var r = g1.r1; var s = s1; print(uneval(s.match(r))); print(r.lastIndex); yield; /x/g ;continue M;s2 + '';s2 += s1;h0 = ({getOwnPropertyDescriptor: function(name) { this.b0.toString = (function(a0, a1, a2, a3, a4, a5, a6, a7) { var r0 = 2 | 6; var r1 = 5 + a1; var r2 = qhrpwr_0 ^ 2; x = 1 - qhrpwr_0[0]; var r3 = a6 % 7; r0 = 9 % r0; var r4 = 5 | qhrpwr_2[3]; qhrpwr_3[0] = qhrpwr_2 | 4; var r5 = 8 - qhrpwr_1[3]; var r6 = 1 & 4; var r7 = 8 - a0; var r8 = 7 / r2; qhrpwr_2[3] = qhrpwr_1[3] * 5; var r9 = a7 ^ a2; var r10 = 0 % qhrpwr_2[0]; var r11 = r10 - qhrpwr_0[1]; var r12 = a7 % 7; var r13 = r10 / qhrpwr_1; var r14 = r7 % qhrpwr_1[0]; qhrpwr_0[0] = r13 ^ r14; var r15 = r9 * a1; var r16 = a0 % r9; var r17 = a4 * r9; var r18 = r17 & r2; var r19 = r12 + 9; var r20 = qhrpwr_1 & 3; var r21 = 6 | 1; var r22 = qhrpwr_2[0] - 9; var r23 = r19 + r20; a5 = 1 * r2; var r24 = r3 + a0; var r25 = r18 | qhrpwr_3; return qhrpwr_2[3]; });; var desc = Object.getOwnPropertyDescriptor(t1); desc.configurable = true; return desc; }, getPropertyDescriptor: function(name) { for (var v of o0.h1) { Array.prototype.reverse.apply(a1, []); }; var desc = Object.getPropertyDescriptor(t1); desc.configurable = true; return desc; }, defineProperty: function(name, desc) { /*MXX1*/o2 = this.g1.g0.Promise.resolve;; Object.defineProperty(t1, name, desc); }, getOwnPropertyNames: function() { i0 = new Iterator(t2, true);; return Object.getOwnPropertyNames(t1); }, delete: function(name) { Array.prototype.reverse.call(a2, f1);; return delete t1[name]; }, fix: function() { v2 = Object.prototype.isPrototypeOf.call(f0, o0);; if (Object.isFrozen(t1)) { return Object.getOwnProperties(t1); } }, has: function(name) { a2.push(this.g1.e2, b0);; return name in t1; }, hasOwn: function(name) { a0[12] = v1;; return Object.prototype.hasOwnProperty.call(t1, name); }, get: function(receiver, name) { b0 + p0;; return t1[name]; }, set: function(receiver, name, val) { v2 = t0.length;; t1[name] = val; return true; }, iterate: function() { print(qhrpwr_0[1]);; return (function() { for (var name in t1) { yield name; } })(); }, enumerate: function() { (void schedulegc(g2));; var result = []; for (var name in t1) { result.push(name); }; return result; }, keys: function() { this.o0.v1 = b0.byteLength;; return Object.keys(t1); } });v1 = Object.prototype.isPrototypeOf.call(b2, this.s0);for (var v of this.v1) { try { /*MXX1*/o1 = g0.EvalError; } catch(e0) { } try { v1 = g2.a2.length; } catch(e1) { } try { h1 = ({getOwnPropertyDescriptor: function(name) { a0 = [];; var desc = Object.getOwnPropertyDescriptor(o0); desc.configurable = true; return desc; }, getPropertyDescriptor: function(name) { throw s0; var desc = Object.getPropertyDescriptor(o0); desc.configurable = true; return desc; }, defineProperty: function(name, desc) { h2 + '';; Object.defineProperty(o0, name, desc); }, getOwnPropertyNames: function() { throw h1; return Object.getOwnPropertyNames(o0); }, delete: function(name) { this.g0.v0 = new Number(4);; return delete o0[name]; }, fix: function() { i1 = a1.keys;; if (Object.isFrozen(o0)) { return Object.getOwnProperties(o0); } }, has: function(name) { v2 = t0.length;; return name in o0; }, hasOwn: function(name) { v1 = r0.sticky;; return Object.prototype.hasOwnProperty.call(o0, name); }, get: function(receiver, name) { p0.__proto__ = t0;; return o0[name]; }, set: function(receiver, name, val) { v2 = (g1 instanceof s0);; o0[name] = val; return true; }, iterate: function() { i2.__proto__ = s1;; return (function() { for (var name in o0) { yield name; } })(); }, enumerate: function() { /*MXX1*/o2 = g1.Math.atanh;; var result = []; for (var name in o0) { result.push(name); }; return result; }, keys: function() { Object.defineProperty(this, \"t1\", { configurable:  \"\" , enumerable: false,  get: function() {  return new Uint16Array(t0); } });; return Object.keys(o0); } }); } catch(e2) { } v1 = evalcx(\"(eval);\", g1); }");
/*FRC*/Random.twister.import_mta(1186709801,2048302511,1158282594,1422803228,-1334432869,-1008215701,532478571,2126179487,698342982,3934118,-1449646614,93014877,-1901728158,-1459317535,-1766373686,383301388,-962405215,488460873,1276068108,-890704259,1642161915,-1137504891,-1470079956,-2087891332,468074374,469037276,-875728596,-1676482792,1558651702,-20241008,-436651305,-862189845,682670556,-56118284,-917748227,-142799307,-1949363097,-739796030,-882112480,-1512866329,1638981334,-2082575660,-1711041446,-44408712,777538992,-1807383861,-600445140,1137004093,1127886847,-594190618,-1175654214,90018501,-1824484259,-398804144,265775518,-359410205,-988320694,1434990713,-655648301,-1149154711,98352021,811134175,1115438583,946082149,-249405329,-476828610,1645555191,2137860420,1120941118,1198165680,439741127,-1707089224,1841143008,853431332,98101545,-766050742,1551641409,1967616272,-964986525,-925462711,-2016337892,402403596,-425727781,1873096522,1767375081,-1095998131,-635715362,43550273,-738654257,1157245975,-847694514,1350794159,904750994,1771591178,2047079643,1694196886,-1571383153,1328350813,-525911892,-1482913576,1493627998,2033559355,-1692852749,1543054723,-952719093,-830087122,2124672261,-1420392216,778375046,1658099965,-1430327421,2071653000,-1058335282,-1140328858,476768303,-590890253,1088906639,900876117,2027387919,1888489659,1826855900,-910866672,-279811175,-1808190938,1859694184,293752899,-194776766,397125087,38610804,293036536,1028062257,160950061,2076000095,-780526491,1764481108,-482132786,666070189,-1872285202,-2038144873,-107572000,-13668918,-1078597438,-1049652182,-966078519,-1934377697,664536120,1197029075,-1037160212,540545614,-994039414,785756302,498476613,1401956271,-954165995,-1514814107,1311027094,-174396357,923566795,-1482580155,-297303637,-1605184303,1291034888,-520472633,2093460272,-1391023134,-2030929884,386278668,881210742,-1679211952,1230867443,1942260198,672457149,1155246533,-992456143,1646072544,101771309,-712386761,744077944,771819442,-1447431032,2111261235,-293567148,-1380978916,1036133807,1981856658,-1778402405,586675358,-521289847,124981350,-1937782992,362204650,272248224,895178179,-824568156,-2035417177,2018434626,1978738976,-432405382,1796631416,1453036892,1989497746,-1630782900,1167857133,384781307,-891516364,-680188108,-1190948684,1379901512,647584514,-1794032154,454224140,1605983620,772360787,-893142789,236021,-1152712743,1293768062,828194850,1629554272,65710084,-941957186,1345164414,1866809661,-23247673,2037033975,-1866003038,-741988232,-1966036646,-1713453408,916770958,-2011215263,303402756,-1160376508,-880828556,1821970764,1464512156,64522002,-67204772,-865464637,-1101072084,-1419992940,1437946338,999009232,1029430864,1042018601,-941631265,548284197,906843913,-561285603,123404337,924771754,-2037903286,166637948,-1549649458,1155892563,1154750332,1296916871,-190940996,-1835735927,1952134919,670806159,-1544528595,597516666,-1604102459,-1691400945,-1904739445,-254741803,10191284,193885011,-666080132,-418516486,892041749,1732999734,1233221657,-1624256916,1173831406,-454820161,-1047074895,-1319803618,-1566304139,-36210166,-1849739109,1786723639,-98765822,-1321763609,115031728,1948080279,-1443129351,1141848368,-560336185,1333142958,125605003,161057558,700780121,-861135229,87641600,1836723657,891234918,-2022208497,1260813060,475737880,748888292,971040813,882902965,-1758196722,252547896,913463972,-877147594,919161748,779428994,829471988,-1976736654,334928026,-1385931456,-1109968063,-1188375085,-1996789538,2062751267,670027410,-915533942,-1691213812,-30333587,-299586196,1276245532,-10017143,1587105942,2003218349,-385130186,321273614,410544969,380616872,-1846830935,592846543,-350722974,-369604833,-472730927,1989574443,1993419010,-1518710519,-911131334,-1763090360,1130619109,1933280229,1764235079,-650861617,-111156938,135515805,-1507487978,-1341081370,982406434,1943073947,1954969588,-1039562229,-89120087,-1080918527,-279903913,1769308260,1191427452,861222319,-1613224943,2025275833,-1760255466,-229977962,-361855160,-872455390,1244591451,1109331664,1107828611,-607463271,-117351174,-1058905609,-904758638,-1494996303,-486917326,-660169184,-459068588,2002971920,702961585,-211168455,-2053341074,212996691,870761325,543248456,501341875,468447977,-1893517501,1314840343,400436016,537996103,796657438,-1745741775,676405885,1109774158,-1454660912,-917520489,-1269573762,-770367090,-1173575617,-706786408,1481766464,1069708889,1037883412,-624131626,-23679522,-1571387458,-225233261,-1330311078,-907066581,-434262600,-1592315588,-1347750362,-572223879,2008450540,1793156454,1554134235,-2138997,-2101508925,777047047,-336780103,1023700921,-999950312,-1407016241,870388963,-641028746,606942201,1953730808,-1928579400,-115195311,-918261610,574298565,1249134426,1911707877,-2069936004,915949639,1848362080,-231603186,-478693511,-787680442,1599972991,-52905967,1127954186,1329212185,-1037330438,1509289467,832979611,-239450371,-1848195071,464302341,258592075,-1951813351,-1713824401,813607708,-1444442768,-792870314,-331484272,-1379967257,-1819853610,-811960876,696134154,768378006,-1528966990,730408129,1900880840,-556728588,32306978,1482354517,-1195159819,488910322,847717978,-921888813,1497713946,1869213242,1606195338,1877618630,1974080290,-638050534,1174487775,-1023469994,849873593,-1417196359,-1951536200,-1641097669,1504195693,394541010,-2025302481,-180137477,-289531774,-502752804,-1085485517,1740048275,1935733102,629350229,159991449,789430733,2029549156,1600091904,-2002455925,-931310733,261757686,655365148,1346832085,1249942789,1809099609,-1723700317,997515501,232307403,1731448129,1172164249,1928918068,513339018,-2044951426,2126163371,362827574,-1824441532,-701494726,471215184,-872122351,-843647544,506838585,748217414,1820320007,27146592,181100967,1107835473,-1453483674,-14522374,1526432710,539956054,-1383105874,1856051562,2133665773,-1023245765,825445363,936632807,1123100561,2074021414,1429728750,1686515281,-240045941,-367359332,647693265,-2053730642,11435664,852760547,-1316814550,-1653354485,995312524,-225647088,211853823,443971022,-275263136,1792080606,-1831779486,-1410381967,1773339463,-486008757,1927221576,-1313078336,302559855,1605635605,837758244,-709835896,-397190061,233912532,1357601508,1760083066,-555328373,-315449645,-1030063443,835826215,-298269992,1671304044,-1366337187,1113605852,-1856741288,533237537,-2019360145,-1649332928,1157774872,1051605668,1727468430,-1800338707,1351575436,16725440,-449000078,-1302574080,-2034001701,-1447097052,-1030732783,-1218212188,1277488542,1277520657,-1789910021,-1798443827,1546022087,-534272364,-2083215556,621010989,468586995,-1120665965,196581826,-297489466,1746493835,-1547545045,-1385260178,2058504421,1485857275,1185650650,-768101991,1142593448,1665622126,19400900,288923214,-2074754282,156294909,-1035020418,-844822864,-310932582,-1299706534,1722377381,-516569227,-450506471,-1718472317,1749053893);
/*FRC*/Random.twister.import_mti(481); void (makeScript(14));
/*FRC*/count=287; tryItOut("mathy1 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Int32ArrayView = new stdlib.Int32Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    var d2 = 4096.0;\n    var d3 = 1125899906842625.0;\n    var d4 = 4611686018427388000.0;\n    var d5 = 36893488147419103000.0;\n    var i6 = 0;\n    var d7 = 3.777893186295716e+22;\n    var i8 = 0;\n    (Int32ArrayView[((let (y) (eval(\"\\\"\\\\u5F83\\\"\")))+((4503599627370496.0) != (8388609.0))) >> 2]) = ((i8)+(0xfa82cdfd)+((0x0)));\n    return (((0x9aa2b8f)))|0;\n;    return ((((0x784210dc) <= (~~(+(-1.0/0.0))))))|0;\n  }\n  return f; })(this, {ff: (function handlerFactory() {return {getOwnPropertyDescriptor: (let (e=eval) e), getPropertyDescriptor: function(){}, defineProperty: function(){}, getOwnPropertyNames: function() { return []; }, delete: function() { return false; }, fix: function() { }, has: function() { return false; }, hasOwn: function() { return false; }, get: function() { return undefined }, set: function() { return false; }, iterate: function(y) { yield y; print(s2);; yield y; }, enumerate: function() { return []; }, keys: function() { return []; }, }; })}, new ArrayBuffer(4096)); ");
/*FRC*/Random.twister.import_mta(504321591,-144984791,1916196558,-1091447989,-987265922,203050044,1489201998,-1231460195,-225626816,-1535573329,304240218,-514893175,1822280595,-453946045,-1769417217,-839951517,-1117291363,2057671773,1134795626,1799718753,-1455293926,-1076032849,2093140103,-1986598949,-1579623775,369601653,-1748771078,1247715938,1259733552,1727535884,107278843,-1659097992,476627007,-1210395269,-1824231648,1483764368,1600882086,194887792,970132002,-1817192430,-790378964,308046930,-2106226643,337056210,-602907997,-1406050196,-1591739846,-1993087557,-537859698,-853495716,-1073035080,-1614727238,-4920143,-567105120,-1673531086,-882099371,594636469,1497403302,1769425676,1214370243,1321120612,-1857518546,-1460257541,88363098,1514353374,-1722874388,-513381802,545582397,2079303693,751897417,272358574,1146742826,-798868031,-1029600943,1178767647,-1467335179,1430886222,-811655348,614197345,99209937,-1996419376,-1729147381,-598353124,638147347,410014786,883282946,-809450451,935093527,238483247,-939359707,323065044,-1514504710,1400581270,-680936484,402566430,-2119517695,-778833348,1219226162,210842476,-467171164,1844391985,-1692523312,-740018686,-355147121,767716626,-1920078588,-1930874921,1816553262,-1514518934,-345765281,945863645,1385004755,1083905465,1361133750,-909000691,-321172178,277915697,1934820578,-1118399278,-92948993,-378776000,-258720982,1719958869,454276659,-1873305186,821729542,-1865066399,-1468331300,-140912890,-581939967,-1108586465,156849630,-552294521,196660167,-224191396,-69055110,1071675664,-1732532475,122963030,715152139,995940912,-1861813602,271015335,-104174207,-698839886,-1173727962,331550613,-509671411,-1089223474,1815714763,1700742637,-1134558473,-1594978405,608535309,230862101,823428512,1768011467,-479495110,220424257,-1140929537,-674901180,-1149429421,567794573,660895957,-1765146726,-1546629419,397550191,1562377164,-1789998756,-419161992,1613782738,2046762640,-1967838240,-1623831640,-107030619,490930713,340564960,-2041257087,185890149,1614813097,-1427017750,332777878,-112748372,1575439943,122056703,32808387,-1451140389,-1501215423,-1268535400,-871825874,-1583211532,1094016559,-1878096394,-1770347886,805438512,-1347897493,-1479479568,699226491,-882217926,-1197601035,711326987,-534205478,793570225,786029784,-2046936996,882420177,-891451889,-1105053969,1882904086,353965437,1769421080,1547412591,-126616822,-1169286069,-2054830089,2008429809,-1661246713,968908237,-1011121284,-297244305,-2057223771,471997723,-1058048487,76030545,-314157112,-261020225,757605736,1390425447,-1408639634,-281951455,-134540087,-666074148,1772454790,781181928,-1656995885,-211716407,-1719253503,-316677660,-1100995041,959683545,-1909719630,-1957887977,-750603189,996291798,-1069365011,-1963182041,-380920774,520942027,1702378088,1733147218,-1965887490,-449871329,131510418,1824107660,1748281820,-189267412,1555507026,-702139552,2117666596,-1768052569,1059736370,-1031086179,-783718099,-1946904578,-709980822,-659307625,-740157240,1277972314,1048205932,-235704112,-678814713,-273291336,301558975,-1366811380,-339182900,1955177998,887321435,-1734313417,1469811551,-2124459596,266700082,1879629686,-161332908,-488480743,439161086,-898541672,-980112672,750333948,655150482,-817025492,-1611486528,1586493269,346370591,1580783048,1645759037,-732295626,912170618,-1970754954,566941096,-565204403,-722462429,-1011198506,735219440,1590923593,-2011572528,1067631923,540161994,-765088998,-1881809846,-991066778,589293866,1368070159,571996834,136571218,-232669407,1246446400,745781739,11957149,-2129823169,518143120,830052789,1626143656,-408796913,1999163815,669467257,-1372924827,-794675137,612118454,237674923,-659302826,2066324996,-446573910,-1207836875,1629338759,-2069393767,1207552288,-804479266,-1277877370,911597646,200254877,-1449656293,1766109472,1095235154,-1526576887,268235897,1616364355,-379096460,-1318843853,-1378676293,-966477881,558927305,677106756,-727041907,1444206526,1188772520,-2094852300,-19819585,1028553239,-1614940407,977778564,3316428,-1954122729,-1898639650,1512032385,1688497527,643547966,-1834163179,-1884223837,-309963549,-379658877,-1664921400,472000821,-881375041,2140160133,-1815175769,-995970490,-507379508,-974971730,-22134080,2143237741,-1531030940,502400305,-1494427098,-40042656,2113034052,-217794795,-1341006233,1590031928,-1396499748,-1289328822,-364619468,-1210378179,-1217028163,-367178373,120983667,-62629477,587922616,182450974,366470576,207396883,-2116540510,-721905842,1644713206,1164433471,1712703511,1397685576,-1648425245,-637552330,1130254600,-1366105153,-1440892508,2090675465,881078128,517533801,6446043,1815469350,36186354,224147831,-2034247380,-1304659462,1499677482,-252035426,-2092047920,1825490899,328503559,-840140954,1560780546,1321715008,675125223,175556636,-1893187467,-2018403230,-153338579,-37198785,-2026162968,-1735803531,2107600094,-1613669640,-77641544,-1712430961,81508632,-1534063606,-2109443373,488698517,-1743401364,307779491,982942002,467474399,-2130807480,353060977,1555527647,-105541264,-1741699948,1530322080,-1657328949,-439729403,-1996686901,-1555824180,-827670121,2076928991,-498876073,-1516589513,-603387469,-646955632,1480205969,990458298,2007076128,-1754763617,918764321,-1075834170,215401419,-274955096,-1123471420,-744581717,871431750,-1620038696,1177694585,1250843261,1776587932,1107313998,-1163495602,-1645739211,-8775227,-971260774,898575170,157682533,-409344951,-108749580,676981899,-386330214,4040843,1214422777,1446876078,-274848774,1669592282,-1558146058,214264246,-1874390660,-63050314,-1596825846,314630993,1193975743,-517987584,-263080974,121935757,-49619680,985204263,916061992,2135205939,-177470613,79136275,285030245,-1009661382,-1366511619,1655847380,-1744420539,-1449765688,1239467267,1220773238,-1148030397,1593297272,-25867727,1817617345,586175177,-182871669,1287066699,-833084442,-1036540812,-1259677341,-1924354599,-430284661,1233699830,-1119648481,-1740499747,-274060279,-1521603907,1873158801,-2100313680,612785473,-397227115,183021061,-1300856727,-903219090,884095358,-687396025,-593175559,665079704,-299796075,1842856271,-798381633,37792968,781181896,1658177282,1030949187,-1930390708,2001021199,-1066543178,-1423607828,1404265855,-1594472025,1271258435,1770426479,16864586,-126274644,-2019459653,-2144436524,-461481429,1373474194,-1465591572,1985713982,-724746049,-2118916088,23584813,-506641832,1737031036,923410515,-2000936601,1137808069,923584790,-405687990,-985340393,782010734,-2091086380,-867175162,1684036631,1171557307,1855467798,-126744549,-801655995,-389580783,-452604458,-150680491,-181041785,1706517161,-1079847447,-1402206339,584555850,138209518,-1682741597,-1901296546,1219630438,2127207869,1279994252,-1217049221,565348355,1273938658,1558904192,346897015,2147438309,-1756403183,-49743102,1970149475,-248621410,1840316870,2145557895,-904816252,-979524985,-1291821159,1569135280,518507736,25629992,-755517331,292344230,-1257904260);
/*FRC*/Random.twister.import_mti(119); void (makeScript(14));
/*FRC*/count=288; tryItOut("\"use strict\"; testMathyFunction(mathy5, [-0, -Number.MIN_VALUE, 1, -0x0ffffffff, 0x100000001, -0x100000000, Math.PI, Number.MAX_VALUE, 1/0, 0x080000001, 0, -0x080000000, 0x100000000, -0x080000001, 0x07fffffff, Number.MIN_VALUE, 0/0, 0x100000001, -Number.MAX_VALUE, 0x080000000, 0x0ffffffff, -0x07fffffff, 42, -1/0]); ");
/*FRC*/Random.twister.import_mti(151); void (makeScript(14));
/*FRC*/count=289; tryItOut("for (var p in b1) { try { Array.prototype.forEach.apply(a2, [f2, (new Object.prototype.hasOwnProperty(new RegExp(\"((?:[^\\\\d])*?)(?!(?=.){4,})?+?|$\", \"gyi\"))), g2, (4277)]); } catch(e0) { } try { print(t2); } catch(e1) { } f2 = Proxy.createFunction(h1, f2, f0); }a1[({valueOf: function() { print(x);\nreturn;\nreturn 5; }})] = ({NaN: (p={}, (p.z = this.x)())});");
/*FRC*/Random.twister.import_mta(-1468362411,1825345239,-1976764055,-481565283,-1829392048,1315561809,-953951058,525554359,-1736782656,-726782514,1884333229,-1407712226,98761153,2018599812,-2090717081,-213966367,-92108136,565417582,-1063276983,378066431,-876999425,1641418160,805288648,-1870160219,586242171,-2001989971,165779170,908038175,-24085792,-952281312,1078580092,-16693465,-2003627394,-964003867,-343300822,-647364610,-133790713,-1680690695,-1856089732,367955912,-687903535,1668103281,-739907482,-1277483882,-225919940,-758411314,-1062096745,-135415125,1959268237,1519641966,1413319682,1714205647,2048007329,313036614,84622341,1352647441,2006358899,-1450406067,1492261691,-1348231047,-1411365925,64581429,963199986,-815638472,-1455608639,-1397080936,272301009,-54181304,-1268185919,2143052663,-1253795190,-2013620962,1203267249,-151045221,1657875085,-676469661,-196011507,-122307927,76313199,1119008273,-1611575897,130971922,-2012456936,-1231135377,-2017793740,1100139276,80559822,-1415782390,-1267729752,-1371984349,-346447351,1105492672,-1018311564,1271070212,-775982298,1056205488,-1949575453,1707830636,-1858906204,-482721423,-1647836396,-1781533001,1286643346,1143068120,1106012477,1046217780,-2039316379,362394808,296773840,-8262890,-2032668514,-972975568,-570645712,-1185425718,1720750578,311504637,-1759171188,2082042813,2083793765,-585072664,833280150,-1568077053,789780869,1457265079,-1509423438,-46874834,1993201575,-1898614264,-1156087276,161921846,-2036658533,40385151,1368946917,-552866139,880403787,-491538025,219641728,-1409282526,689354727,1913147273,-1974682369,-174242995,1304382858,1640294492,-277632262,448843643,-1653273177,-2003908320,867215043,-1945936463,1763297329,-1532479907,457431270,-1649849699,906338584,-814895944,214349662,1399429043,-206373841,-1416675820,1871924122,-1706018714,709674258,1084301966,-1587148838,-741280606,-688468406,-1928980203,-206802200,-1805224638,1830945498,-1375843044,968930026,822778802,1444600283,188853725,2079294279,-1156942063,-1641899176,-1648060782,171669006,196019520,271230646,1609523511,-1217497264,244617318,101050233,1045531611,600896684,1044987116,31463379,-667881026,-1543886504,-1123758130,2044208959,-1495403777,-1469481269,-1709710348,1764471000,-286403824,942193923,1428005796,-1715443150,1246562632,-1114736246,-265463212,1902962387,1504699144,-664078205,1750163724,-1548199777,1137095520,1398854891,650291238,-1749175612,1717262274,-1470521345,1581210681,607985132,505787018,1679417803,-453504669,-978621137,925122252,868719213,1207485202,92097808,-1099005982,-2107842664,1759101906,-1888639885,-433622893,1496191141,1354068888,-1353460,1303469855,-1574838980,-1234696323,1770617133,49743640,-1526770864,1942739613,-1366410358,1135304241,-37406046,-1271242668,-1073340987,-117042741,1383125145,714526007,2065231733,1629093938,-1091512085,1039909388,205754633,-1865684663,-332509552,1062555886,1833378731,-687458329,2127014132,438673763,-1668041727,-1831746894,1854136557,-122725096,1945675877,-910016025,1536459801,556291770,-1006512310,595376828,-980451000,-1252684303,-1918277204,-139393281,-808752982,-1493632654,1719868181,1038147128,715972861,1043995823,-1192868926,981472012,-1934351231,976768587,-100714617,-1201265390,612366371,1989154450,959255373,979830033,-2086250884,-1203868144,-689420973,-280605700,2063087180,-442372002,836104423,-1261905153,-1759374992,926445045,1640799256,-262278811,1047292143,345336202,1803576220,-669277310,1706605473,-645682035,122905015,-1766779803,1166229413,-1529523839,-826719830,996054658,929736498,1926737865,244671624,1123659889,2075427792,2070340478,-597118276,19973888,-338249855,1617623908,-1325115734,64348958,-1181344356,824463760,1989229709,-2065418632,-673551704,489289718,1986351144,968239039,-1502905643,-570621767,1526657057,1345852386,-839545254,1177774811,-1726432602,1238624111,-717610301,1216844383,479906350,-28581740,1488183359,-424415298,1123152789,357935659,-1774267151,1436568307,-1891305070,1568144148,-838256926,273499584,1598808509,1367422339,1136682097,1930650148,380955912,-1504841244,-1087508547,-1186433742,-1395098617,1703355985,406494547,64939502,-1227011047,1405140602,-67084314,228258731,-354447357,1129424549,-286075930,374270289,1115626932,152891860,1247344858,628345867,-1314663672,1916771580,-203195162,850568131,-991050488,2045953780,-1010627645,1601104264,-2109465009,1674868955,1071047360,207976108,707560711,-1574368076,-1861646131,1741287426,853061066,959226171,1534513173,656339872,-1325731555,-772941933,-1834153547,167094518,-247772663,1804885642,-2047949760,1160018532,-1196865684,-1389600536,-1729079155,-1623426485,139158856,583327957,-1578135416,46136133,-2127639229,-817133363,-2055614335,947836887,1236410825,950765207,-1126049721,128483161,-913428048,-1254177233,1344718762,123534039,160810873,1609095107,398579860,854686887,-1931244179,-1499115796,1740229744,-568853309,-1774636040,286066791,881503779,1335311218,-1312580009,-1538033463,-1910782153,964058485,-1966896710,1684462447,930416004,1928881695,201258612,2144368679,711175490,-1829869398,1435758271,1596593058,964412212,1899000935,46822819,-251182895,-1687120804,149384458,554254807,1463058091,-1410556000,1381613501,-1874100088,1721138719,1815860222,1911417520,1952783461,-1555976896,1157470814,-1711381786,-155319257,-1470007046,-1764142890,1340777787,1075454613,-1549540532,-368610487,-352965324,-205113596,-1226187983,-1561401981,-947691184,-1413187171,-1276907922,777595310,1166397595,803749137,1167927610,-815772443,37310984,-665712612,502673602,688643588,-1172364911,1930794297,367476799,264794865,-1120307156,-1885741306,358716339,-1736599582,-1562957607,648815020,-1945762757,-1652249147,1672818708,-1409927071,-1386430052,-193549974,-2002375827,762164591,1890898503,-1956068148,491573750,-1096381201,-321015104,504134615,969647212,1731646023,-646165930,452119204,385474836,-707589947,1415564574,-392787002,-1947657086,-1801875298,-1178264897,-1044589765,-2057452217,330565123,-1956439498,-656126891,-870776888,999342448,-1711286152,619094378,-1414677091,1627884093,-2048818610,-2054327574,1564951364,-320750492,-1806183512,-900036738,-1656167208,376911588,-625191936,-405024998,-1216602356,-511719610,-1717504441,1689709158,-2042609939,228041332,724579542,-1327362274,1994783373,92978793,2092135639,-1645592621,-1312199189,953603371,-643309012,1025417540,712419878,151655275,209805834,2019636083,1868477584,2093367394,-974831533,508794371,1501009694,649949838,1838421797,49155652,-1897218184,995099031,624011318,-1414549310,1745353014,-189759151,-1294791412,-1636274445,1681263587,1153902353,1556061601,1385919673,704751148,-1430678224,1230066678,130060697,571232151,345439317,-1738975915,-1409872470,-856030011,-1042042681,656615224,867797024,1812620148,-1706894288,-324014217,-1210267172,-819482999,-1853874158,-881567831,1147806496,1645493012,1559890486,939879007,-1612286309,-326659305,1822924471,1058367572,-1139402171,1654320596,-1196687606,1547464888);
/*FRC*/Random.twister.import_mti(204); void (makeScript(14));
/*FRC*/count=290; tryItOut("\"use strict\"; testMathyFunction(mathy1, [0x0ffffffff, -0, Math.PI, 1/0, -Number.MIN_VALUE, -0x080000000, Number.MAX_VALUE, Number.MIN_VALUE, 0x100000001, 0x100000000, -0x07fffffff, -0x080000001, 0x080000000, 0, -1/0, 0x080000001, -0x100000000, 0/0, 0x07fffffff, -Number.MAX_VALUE, 42, -0x0ffffffff, 1, 0x100000001]); ");
/*FRC*/Random.twister.import_mti(236); void (makeScript(14));
/*FRC*/count=291; tryItOut("");
/*FRC*/Random.twister.import_mti(243); void (makeScript(14));
/*FRC*/count=292; tryItOut("var nsntbk = new ArrayBuffer(4); var nsntbk_0 = new Int8Array(nsntbk); nsntbk_0[0] = -8; var nsntbk_1 = new Uint32Array(nsntbk); print(nsntbk_1[0]); nsntbk_1[0] = -22; v1 =  /x/g ;");
/*FRC*/Random.twister.import_mti(293); void (makeScript(14));
/*FRC*/count=293; tryItOut("a2.pop();");
/*FRC*/Random.twister.import_mti(329); void (makeScript(14));
/*FRC*/count=294; tryItOut("mathy1 = (function(x, y) { \"use strict\"; return Math.sign(Math.hypot(Math.imul(y, Math.asin(Math.fround(( ~ Math.fround(Math.acosh(x)))))), Math.hypot(((y >= Math.acosh(Number.MAX_VALUE)) | 0), (Math.acosh(Math.fround(((Math.max(Math.ceil(y), (Math.atan2(y, y) >>> 0)) >>> 0) >>> Math.fround(y)))) | 0)))); }); testMathyFunction(mathy1, /*MARR*/[new Boolean(true), new String(''), new String(''), new String(''), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true), new String(''), new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true)]); ");
/*FRC*/Random.twister.import_mti(582); void (makeScript(14));
/*FRC*/count=295; tryItOut("mathy4 = (function(x, y) { return Math.fround(mathy3(( + mathy1(( + Math.hypot(( + (Math.pow(x, Math.fround(1)) >>> 0)), Math.trunc(Math.hypot((-0 | 0), x)))), ( + ( + Math.max(Math.fround(( + ( + mathy0((x | 0), (((-0x07fffffff << 0x100000001) % mathy1(42, x)) | 0))))), Math.fround((( + (((( + x) ? Math.fround(x) : ( + Math.atanh(0x0ffffffff))) >>> 0) >>> (Math.fround(Math.fround(Math.tan(Math.fround(x)))) % y))) > ( + 0x100000001)))))))), Math.fround(Math.fround(Math.imul(Math.fround((Math.imul(Math.fround(Math.abs(( + Math.fround(x)))), 0x100000000) * Math.cbrt(Math.tan(y)))), Math.fround((mathy0((( ! ( ~ x)) >>> 0), (x >>> 0)) << mathy0(( - x), x)))))))); }); ");
/*FRC*/Random.twister.import_mta(-2002319434,-1362730591,-780016854,302778557,-652037161,-1821696182,122474007,-1634701355,1671609873,270248064,2107137157,1578567807,2030881702,537980800,1304117447,-441377343,-807030404,-1324612941,-259507467,490350120,1918172573,-1764683737,1577121600,1292487779,-1524604834,222489272,-1163067833,-2086017737,1681315017,-1448421362,330749283,342838933,-49188358,2085688812,861677628,-221631928,-435121020,-1001609773,-330168056,-707867961,917099044,-1077164085,1222679084,1305407549,653458581,1217656515,1185748291,1836544046,339718082,-1596108869,-830983593,-1821066485,2074878396,-1871456087,-828954256,-2002759644,522231763,-1595780099,-772574399,-175943162,-1445694686,511628378,-692687667,1457959651,1589277510,-266564384,1767301007,1758506271,-1265680679,-1964388915,627782800,-1762701191,-744831070,-1677379076,295694254,-1478645881,2091650925,770739663,271618861,2705114,202217906,1142689433,1642364196,-1445328941,-1975564110,-241129373,-1557681356,-119990057,160908958,1197480006,-753806578,268423060,543469465,121078914,451353698,1401755467,1893524670,-791960626,-178020187,1743773582,1777363477,357423728,938978003,-1237911888,-1575519690,363343851,1605192175,-1868192886,-1659380398,1707596259,-284766941,-210043811,1058986865,-658607976,1025304125,-1818708,1872896620,-1971384318,1579478451,-742545273,-1795103576,1881649394,1589317316,218658958,1196555259,-2057795253,-568921262,1199115182,1378532495,1335246679,-1939644162,1498548075,1029987087,1471009508,294942379,-2026411781,-1822571946,-566760145,728730925,1154130677,803139249,1565484981,-1457673130,325022743,2143644415,-155861967,-1046026530,1163759956,-1035051709,23455907,520845401,-2013566195,177533257,1299572328,-49642916,-1581738827,130049034,1101924750,-865638067,327110571,-1956109602,1488044285,190883217,-1605301005,520978652,1861343564,-1556559742,-465828185,-67479734,1313330246,-816266078,1644099633,854845439,-1156591783,-1876360133,-593608177,-338477113,869731790,-1962472678,1531849988,1553995198,782770645,-613738655,425276908,-912197813,-1587920140,-1559110396,-1169700204,1998808896,1833450087,-1630833197,-813335969,984902660,-1591507887,-690367487,-1616413949,1728731094,-567521956,2116532862,-1025736761,142777925,410437964,-41954831,-1255132817,-1259558417,542995313,200595132,-2038152002,404935666,311836832,-1924352313,123999094,-599328102,-1705051792,-1202062264,-917611520,-1811733033,1323599040,924300058,887240353,1207118713,-1753573121,1686599474,1023240108,1097239645,-1173005950,1124290377,-913741702,-626360248,1329562060,-132710357,750586714,-1154374010,951673489,1631613061,1924288655,-769188895,-1873522484,1600949235,1802723854,-1057115631,1526488322,493617670,-251188179,-351194471,159614152,-122577390,-2107366130,445826659,-92000219,2105855098,592493812,1405029310,629507612,314876236,304214913,-167743367,-1138887575,-1494948423,-2106415744,-397707902,-1541586205,-1146959087,140104749,-132445345,212266469,1747409643,-1033166601,-1352668010,1793094025,477146467,70597681,-1959690012,7971221,-1884863602,1943673751,-207539454,607194882,-1920674793,-135077603,375809569,-756807535,-706717278,-2139996852,1693893639,1946441821,-1448066929,1659060204,624353043,1395152308,-757235532,1600739448,-1409041432,-1691726343,527665377,-906811905,-1204210206,-460751812,360943065,-1744056550,1586610137,561619362,117174250,-1164801083,666515722,636527331,740595483,-405179203,-237672448,-1153073888,998915390,1911973823,2059579516,-998568991,-1518972010,304223495,-419201155,-732208822,-1215584397,499052145,981792061,886261052,320173259,-599847007,-1593909636,-303985680,637873665,1966826715,1306522296,-1783135158,-1270551156,-906342558,1530713104,1688199675,360054922,388681959,-1842222752,460391916,-614009428,434379868,581924138,831568750,33914052,-600341550,1999923698,1349093540,-325560115,1615963240,1132349229,-1496627247,-1633018556,-716824228,1988107501,-642478181,700642852,1965959166,129015223,986587391,-392549003,-2054366744,1847878646,449708079,-1810788343,1438877015,-2104240202,-469040143,-1358855934,-1161097017,1553995074,729528965,2059348778,1103447308,695235899,1841405440,-1107430695,-180931408,-750113580,1043658371,-2089479193,800623908,-960188238,-438604840,-660120885,1043454585,-2113935184,-300839991,1871064273,864098272,923186233,-1823860119,1219723329,15135164,1757635098,791034590,-181894915,712385523,1034103879,-701197753,-463464333,-2042609878,-1467959671,291294314,761272601,999099330,1999493557,714219201,780403265,1582790558,1278876903,-952126249,1338967448,483421138,2009911054,-415993952,841812513,1741991684,-1256229094,122987437,824708838,-520080229,1679056741,1795716154,452593815,-529396950,82887215,1524671142,21736463,1620180368,-2100296456,1623032466,63760977,-1089714779,-1607631363,-1802657579,-707337272,1811822026,-1533735394,-967823557,-689297510,1594563924,-1114282807,967869372,40849595,1241937555,-1957225819,846624711,-539366455,1548331451,923671343,1635257352,-1709315232,1415011068,-1285394985,-1329461047,-434347605,-971546158,-290518240,1618643493,-1925833747,-158733144,2093667348,-389259087,-1071587579,-942582735,1617969101,1464421303,-2127499810,-153068562,1644865626,-1101644565,-525862259,-1989148746,92059067,451292382,-699098765,1375628808,75092583,-998150673,847334738,-1078721851,1358860422,1797765838,-799166778,1048556135,-539212607,1779329448,-612150601,-1083711147,534190705,895378758,714555568,1185127922,1304052961,1141792485,-1936705386,-1143340140,-286830178,-51194080,-1748095759,366807363,518331779,-932467699,-1604164975,-6293261,-330159183,-556612415,1761170399,-1045659620,-1556180837,1494480205,-690201214,516788402,-1453327052,1712204519,-1011751408,545439093,495861071,1418098204,688357656,2047686364,-2016436273,-1243590371,-447938348,-180334416,-269120330,-1503479452,-232511083,1792735802,1686974435,1287071653,2138617413,-563290040,-27856737,-50977595,-496436826,78642933,-582417724,1715625350,2097777539,682746057,1218799088,1291658839,282252320,-1513765368,-1158102808,-2114225855,1469384613,1604957826,2054633296,1479471033,-245291615,-753714703,-1235254154,1455082914,-1595691225,1065650059,262089699,-225493834,-597535479,1129173919,-2031768478,-1900286111,-1334060461,97273430,-627244090,503656422,892857674,2082481544,615247485,-1618426450,-629722409,-770948972,1741083372,-755271428,-609504098,-1788920589,-1972335522,-1913347069,2055510545,2012683215,-557723609,-312326608,1740043237,308757974,1322114148,1271586050,-588947602,-1206852528,-237128447,796570462,-493552808,852942133,-250883865,-1168290918,-563889860,-968299183,-1552601711,-369302049,-723427463,2089546734,-1833685827,1141152357,-1499027668,-896079676,137479993,-1907065345,-1058551232,-1658137508,457182275,-1872278846,-1031585422,-473237216,-551840189,1106979274,-1232399856,-1577238613,2080465725,-1477902395,527189398,-272572441,1584090164,-377651336,1147673519,972074908);
/*FRC*/Random.twister.import_mti(415); void (makeScript(14));
/*FRC*/count=296; tryItOut("\"use strict\"; o1.o0.h1 = a2[8];");
/*FRC*/Random.twister.import_mti(436); void (makeScript(14));
/*FRC*/count=297; tryItOut("b2 + '';");
/*FRC*/Random.twister.import_mti(445); void (makeScript(14));
/*FRC*/count=298; tryItOut("m1.get(o2);");
/*FRC*/Random.twister.import_mti(458); void (makeScript(14));
/*FRC*/count=299; tryItOut("mathy4 = (function(x, y) { return (Math.tan(( + (Math.min((( ~ (( - ( + mathy3(((Math.fround(( + x)) >>> 0) | 0), ( + 0/0)))) | 0)) | 0), mathy2((Math.min((mathy1(x, y) | 0), (y >>> 0)) >>> 0), -0x0ffffffff)) ^ ( + ( ~ (( + Math.hypot((Math.fround(Math.cosh(Math.fround((Math.max(1/0, (y | 0)) * y)))) | 0), Math.fround((Math.fround(Math.atan2(Math.fround(( - x)), Math.fround(x))) ^ mathy2(x, x))))) | 0)))))) | 0); }); testMathyFunction(mathy4, [0x080000001, -0x07fffffff, 0x100000001, 0x100000001, -Number.MAX_VALUE, 0x0ffffffff, Number.MIN_VALUE, -0x0ffffffff, 0x07fffffff, -1/0, -0, -0x100000000, 1, 1/0, -0x080000001, 0x080000000, 0, -0x080000000, Number.MAX_VALUE, Math.PI, 42, 0x100000000, 0/0, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mta(408883784,-1935611418,1447988139,488202173,1491682255,-137441587,-1379037961,-1611385246,580897409,-1992254244,-397130882,1891399988,-684211433,-266726108,-1224714771,272504752,649780774,-748574844,692698128,356366603,-1791714463,1579709766,1586258549,1988390730,766050662,-1633368213,950946158,-270329708,1312149153,-778537375,-206640635,-1135035387,513083492,442695247,-2039918463,-752535617,1872970467,-1543510196,-1743658890,-4069620,1086159873,-1298503028,-521874027,937732700,-2064529406,-1204720955,2092813956,-2125935292,-1156554555,569197117,-1929689887,1255672817,-263630717,-44662824,268923630,1710920417,968593896,401434836,-1126774575,-1169870159,793108488,1063624020,82969862,1402465719,-792582463,763559965,1790030433,-482406274,-1959453298,-746227818,1688158989,197643147,-262889451,-1469575846,59350186,-501087534,-1793664282,1195663418,1374342501,41885374,2139609724,41120704,844214771,367080671,-1962975712,-2117174436,-618950957,-1692932210,1237214603,-234112208,-124254561,-1762787998,918923015,669306497,-160586104,1976841918,1818988290,1864980507,-936514477,1125635147,-162252264,356337991,247886363,1341038744,464980775,381449913,-137549514,-1562786536,892967151,-965573231,555306733,1706642940,1967967489,291151427,557813604,-561058814,1664197350,900407318,-1873487383,1460555547,748007013,106563194,2089355931,1030738669,776250727,-1975092867,-1761815193,1609065006,413210128,-199910934,-1619310256,-482889029,1734463191,-289784369,1157620970,-1208479308,182805133,785879023,-1077797040,1403962691,-772972925,1770479016,-132716003,-296787888,-290502512,1879156559,-949285214,47668886,1480670671,-1055388842,-983780389,-1506410709,2123635853,-807115633,449299316,-171985293,1986906469,534293342,-281833343,170605196,132082711,1088075550,-898767559,-916231156,-1178401849,-1578648046,-287640102,-1486870429,2032584133,312184603,-1781012145,-1529172643,453481181,191561749,625725772,-1960313392,-1961820645,-567791341,-117953935,-1541372287,61342774,-835083906,995852601,1662589789,-1110481078,910040423,1329897628,895250372,-463048466,1250448728,1188751776,-1400405245,-1495023191,284205447,-468856725,-2104558836,-1790218956,-1586469885,2116969069,2117915244,-439910023,1935017822,-1088726138,1372244117,-1927113982,-1554199438,-908801381,1142992576,-2027987537,1598628348,-560407065,895709454,-582470022,-1632649386,-2022844640,202552439,646540202,-1392456803,579114020,-957331874,895288165,1831861775,-239178703,-405751099,-193473607,-1126101804,489954209,1963610732,-348182272,-213009567,1263000080,1165070476,849006426,73729130,1067822842,-1836779602,-1049971526,518698584,1158006835,1849797312,-1654375515,-1179233042,-1313525383,-902105163,-1751095840,353465113,1410313100,1098205327,-94184053,541983816,1730949424,74876089,-1939471259,835459528,2147176843,-331528638,379468938,970205190,-43913531,1789964965,-781914143,1118864854,234974582,-895060077,2091131233,889912796,1207748520,387091018,1591927447,2010395643,-1393130341,-2123822992,1627720400,2070835011,1638756432,-2101282492,1945486780,322018869,-1473655904,577950540,1294781263,2063031871,633572423,-758627532,-1259867099,822499401,-885740217,-1529462946,384939918,765248860,1008943499,-960234699,-115435970,-1140799794,1590571614,-685144193,-1581135480,-1219087042,130165766,102027046,-1194009205,16018271,1717827567,-959723933,-860585580,-554682825,-1466231745,124612220,1607585104,1872015212,-1273841697,-1214380514,989548147,-1985960168,1259232722,-482907414,-1742337131,978675193,1094335109,-1299223226,1032678431,1726983218,-1027407439,1008001084,433692131,36162444,-528296199,-793001148,535202658,1424229597,722700073,1982423343,-1107609957,-42587789,809770420,1008823391,-1949694105,212481083,692798418,1679521684,160613364,540881158,-258658837,413898271,497017924,1058030928,656842031,-1809695444,-1942547123,870057017,1473036867,-871621682,1066700399,-1038242187,1702851025,-2106464236,1887058250,842985269,-1577984433,276037420,2060815623,-671114191,1141990336,195856726,-975520056,-398270511,-1748763137,-1078111198,-449695691,-985038968,-827473194,1663025874,1189177423,1084049169,2018297038,837036965,118145224,1575914231,-236340807,1576420564,-1123430045,-274932018,867167120,1989295421,-237445531,33044022,334213500,-2058058028,-797504779,926717382,-921692974,-1918717238,-1233869955,1296434555,1800636741,-16784583,-1601603865,2129614249,-403000632,-699434682,1137010208,-1426887393,-1763608527,697213470,1382649516,1991416718,-1962197682,-1128416614,1957612490,1555825653,1836134068,-2044133171,94644919,-1889888941,112605254,-18232477,-1876249519,1582231251,84879761,1306615492,628399002,1886938367,-1296564583,1312537852,-1946143408,-410843979,1316236452,-458259707,50906647,670408305,-683386216,1144823075,1880272071,-1556104321,836744229,-1789535584,-1519810882,-1242706390,1525088164,1519006913,-1032323448,525520802,-1340522527,-1171630553,1832075425,-1805594337,836510300,-1210925523,1569978379,-55535231,-1912924229,1959679373,2106112111,-147678293,369222277,-1670861680,444092076,-724277447,1043687128,1291822416,-1458862867,-960663129,1751444841,676993923,-1404656804,1167965916,355567415,-329158776,1066793540,1492024544,-1903359890,1276547042,409101686,-433235990,696942475,1633059943,-1694104992,1047304089,-2103167740,-468104154,73385135,1473611496,705310638,-1602703819,1288903890,1235810113,-1408503088,126341638,1478473589,457887022,-369641110,-1015958578,-1912249743,1102371811,1258261376,697387608,162355307,2115576380,1385118734,-142658354,-967636582,-1466633785,1678226914,-1663803205,-447722358,1163776656,44340034,-2051329059,-1888086970,246260358,-1649505427,-1605891393,-620102171,-353608113,1839190331,-2126636554,132120146,681607431,-70950821,1676798214,2146983583,745058868,-1383485657,-700772397,-462984820,-405239789,1937355323,328923813,-1079556014,-1059644398,-369248697,714557700,964924554,-642815764,-600694311,1903512626,481657263,329171649,986597029,514456715,920028396,1130837954,-237663762,-983929887,-476026490,-1275590264,-1654934009,11990967,-739218639,1669014462,-862598117,1123442648,1769647453,1778102709,376516702,-2128499124,1839438470,-601219726,-1903740865,-1098260310,589524508,-244236222,2126991220,-1501264252,1135125448,869315959,1510696272,-2100329451,804869073,77988959,1907209813,1853656370,376305966,1257457504,1199903626,-921742494,-332470553,-1283047532,1862215414,-1979918685,-1263760019,-1884505860,-1958589697,1461507960,400261556,-1887211016,1283165444,-1691097256,-2143107682,1968905836,-875604205,1683482212,-1251182052,-118349471,1167168085,763368994,683654584,1037426101,492452645,-692859186,-1147684100,1797232472,1420779463,-635792501,-1010039593,-1852154727,325267194,1772185501,-407929937,1391348521,125256109,123577755,1627759315,145635444,1285728734,931072948,-1111467269,-2035927527,592080358,-650050201,2046343879,-1871760307,-502811401,-1398341693);
/*FRC*/Random.twister.import_mti(149); void (makeScript(14));
/*FRC*/count=300; tryItOut("i0.send(e2);");
/*FRC*/Random.twister.import_mti(161); void (makeScript(14));
/*FRC*/count=301; tryItOut("s0 + '';");
/*FRC*/Random.twister.import_mti(170); void (makeScript(14));
/*FRC*/count=302; tryItOut("{/*oLoop*/for (let lpgtey = 0; lpgtey < 4; ++lpgtey) { window;( \"\" ); }  }");
/*FRC*/Random.twister.import_mti(252); void (makeScript(14));
/*FRC*/count=303; tryItOut("\"use strict\"; /*bLoop*/for (var blddpe = 0, b; blddpe < 103; ++blddpe) { if (blddpe % 24 == 1) { /*MXX2*/this.g2.Uint8Array.prototype.constructor = t0; } else { m1.set(timeout(1800), x); }  } /*RXUB*/var r = /(?:(?:(^{0}\\3){2}))/gyi; var s = \"\\ue544\\ue544\\ue544\"; print(s.search(r)); ");
/*FRC*/Random.twister.import_mta(2025791834,366299074,1103849031,-155617512,136100518,1494158997,1718925615,-1708205261,1913837024,-14607119,-991721984,-969041250,615582055,-1342589795,-835319019,385435044,-1494595951,1376970318,1837082425,62409022,828036208,-1287542668,1990420833,866130729,-433932395,-287253970,2043293878,1913807583,1447530330,-1364465287,596340184,1279410725,-1278455415,1299726855,-1264142813,-1630814871,-1296021287,2111259678,-357226202,1547667553,-1398736020,-1281612367,24666607,-1072751991,-633157089,-834152285,-1165086587,-1447837668,1570685150,-1364643597,1270221578,-54533995,-2112117139,-973558068,-549737438,1632989339,-54251583,-1855834574,1480754455,1306181288,-882464365,1011639387,-63118508,409085778,158613878,-1003191162,432378812,-371446373,744424727,-25782674,1888107154,-1632167279,215644749,-817248709,2097647243,1391003653,-2054199305,-1736988186,1617496888,-1530532002,1062547065,42229026,2011260566,18901951,389200710,-561031144,-302817806,-1325097272,1890396889,1229930816,1290874039,-1703554007,-1850729807,-759076306,-1180981103,-1204771344,-282540239,-136196746,-787345246,847725927,-1383123392,-857426468,-796367742,1384135894,985823812,1608589689,-843546057,650391586,-9691001,-887061269,-1217948381,752402969,-1626841736,-1926148897,-1894810434,-1433326442,-264647100,-54719216,1941016228,-2002937409,730694202,1552504265,-464605009,-237847309,-1337770411,2147448139,-1177600316,-398990716,-573422362,1019483795,-83258585,1428103142,1854059050,-1954397134,829112798,-436628205,1472995268,-1009570191,-2119524788,-1387553231,1734175765,-1613921420,1770933411,1098981540,-1569762118,-765456705,-2077113174,1451771838,-1821111261,1727881013,-895174403,900912552,-578707162,-2114572895,-517917634,-1958414032,1712841754,-1193260863,-1003212022,-146498478,-62437635,851016316,-633842004,-422944992,-1585275061,162149785,1815880298,-1506577931,-1550466523,-907534040,1235903076,-76404128,-1743047542,1661492979,1810854874,-890423556,-1125126346,-1561217427,35102973,-1376066308,-1801785557,-1436920139,561572818,-1437909304,1304102544,-1394599247,1303568538,636008899,-356033708,1863776724,343447046,1245418901,-1540620688,1623265273,621845474,-3552122,826450879,-1550969924,312377108,-2091594277,1149165082,47683302,660478555,-1123617923,984740193,-1454536107,-1207253781,1498094303,-29438873,-1524109098,856743706,-922001262,498701442,1153542717,-665038977,1916868358,-2027491995,501277644,336013467,2120641430,691632577,-2103579871,866248922,-1697913916,-836783577,898959864,-1776036107,1293989338,-176477523,610831183,-738082978,290577675,1530760352,2040950354,-1821597468,312971197,-1336653859,2137641670,-249737218,-1291082646,-215834902,266609526,-353595743,-314936223,-2121076963,1199076095,-1173725786,-1788671382,-479810992,1161130489,-1466701398,2031682936,-1241065782,-549508948,1141686782,487100703,-1304298118,-2077021595,-1609389144,41326246,740294892,-1280966504,579876479,1436215478,1733442288,-917812494,1471597892,450444024,293506195,-1911843971,-2135187791,-1430237321,1794662365,-1973909331,-1462518594,610542080,1043943222,1604513498,-1383691981,1032155925,1636544780,1423104734,1211191553,1069507852,1357490889,-456105109,531734791,-2145488300,713164533,2066084686,-1576310249,1979386473,-1707808799,1990363795,1530945275,2092949971,-1512207119,862661777,-1648526078,-1984388009,372982603,-683752029,-393978901,-472570051,1845953058,-1389612552,-411871136,280873169,894306964,-186610266,1525639344,-750277472,-631305324,-2005634277,-2137052227,-1514758196,-1922219165,-177962710,-2093849974,1451105377,-508117961,32675990,-432351762,2060237087,-151902032,2019281665,1524278469,-495160335,2141063021,1544099785,-258196322,-1120448042,-1202551521,-1785033491,-1579403566,1669436395,343748137,-1547553590,517306835,-1681834878,-1657809828,776821396,2144098118,-17417114,-483053640,-114659092,-2104719575,-190924733,-1670387958,1453351249,-673926892,1988217277,-939978066,1383610099,-384887154,-1511040957,-1126968874,1928973535,489087088,-891239306,963984117,1399058494,-533737032,1965113504,788197702,1396953196,-225102816,-1932737328,-43434832,249081288,806273485,404181058,1797660136,-1206409523,-680336717,-1863226297,-788354415,1800983806,1531574210,1510865224,-164085050,-1191788042,688215921,-940360713,-132361254,-842929228,-168894664,225735512,1764176031,-21996347,-1608841659,1672511018,-167671813,-1063430633,4468918,1792657801,798440227,2052537088,-1873439037,-101087334,-277260125,-1181253859,-1641388045,-1780799392,-1716978774,127024730,-207341135,-288519474,487384976,398490760,811011697,-1771986156,843440327,250215609,-2087392083,1004188067,-1724301726,-1879592431,1825258231,-1231965251,-1040872103,-1522281359,-1730931976,927119639,1229398329,1973709126,671857798,-1661858354,-2010781439,217855767,1175457075,-1682958371,567994165,2045619750,1407317903,-1400238280,-3074109,1583587528,2101791277,1015180230,191417836,1498964048,-1235448630,1756888554,-1898431588,1290353077,-58227617,-554158821,634197822,-329985064,2040822237,1775460047,-1761282830,1143707496,1125442450,-1203302917,-1760950260,-1961161678,925765539,-693043703,-2081397154,2119591567,-1618857309,-1502144909,497487272,1653423290,-2059725906,-1394056248,596843782,-307623274,-1959709808,-1918640730,1953421578,2009584316,1019279494,-286938272,-2096395542,-1446907096,185967467,1830913090,-187307048,1359599145,-1807976742,-735546605,972022042,-1239985472,1102413733,-1725469815,-1107073521,376171210,874656081,-1185400041,815372252,1925777540,236036052,-1935634311,-1324940701,-1443102538,-1853893360,164748048,1192902801,-623876529,-1291410814,1284598131,1024198546,-1395343214,-1504683484,640727855,327420829,-538008472,-158084980,-1536826140,145685651,-260638395,-2138997073,1768815068,-159579374,115436261,67370730,1019246705,1620497289,-729007689,-1901406491,-672253897,-644884409,2097747136,427649498,166258530,-1219146838,91369495,-1231125569,1925630055,-2114222706,274921555,1745317576,-1575191908,1680301081,-561972419,1159455290,-1053537822,-1446516486,-1200230582,1578310371,-54691936,-1399290386,1419184470,-1892821147,1363556720,1884227913,1501070140,465016563,1531432641,-709975292,1373781226,-487807785,156224046,1914444144,785846366,-495738493,-373083631,-1390269236,-557870744,1891881129,1974042573,589487790,869321595,61754967,1406913899,-1256789916,-569230157,-909608193,-402402513,-598486180,-1588719892,-803663374,1936729254,258178715,-1599397265,-344518093,78111943,363752077,900105006,-832490497,-1220669172,1966634019,2065377010,-948357158,2035570746,701398792,1556138734,118141842,877448264,-1238208509,156585429,-1710436415,-382279060,-1992625203,-1481937792,860796709,921550998,-845648543,1680735631,620008797,703338533,-1164096915,318267583,-136971687,1558663118,1216959677,-1279899784,1565874661,1368797804,-912853106,-742421545,382465666,-288379587,619443990,-239193930,-703050682,334850631,1369603310,-397452782,-1518205257,1405660046);
/*FRC*/Random.twister.import_mti(2); void (makeScript(14));
/*FRC*/count=304; tryItOut("mathy5 = (function(x, y) { return (mathy0(Math.expm1(( + (((Math.fround((( ~ x) != Math.fround(y))) >>> 0) ? ((Math.imul((Math.fround((Math.fround(Math.pow(y, y)) | 0)) | 0), ( ~ y)) ? (((( + (Math.atan(1/0) >>> 0)) >>> 0) !== (x | 0)) >>> 0) : Math.fround(Math.atan2((( + ( - x)) >>> 0), (x | 0)))) >>> 0) : ((Math.hypot((y >>> x), (0x0ffffffff | 0)) | 0) >>> 0)) >>> 0))), (( + Math.max((( + Math.atan2(Math.fround((x / Math.pow(Math.atan2(y, y), x))), y)) >>> 0), y)) & Math.tanh(Math.fround(( ! Math.fround(y)))))) | 0); }); testMathyFunction(mathy5, [0x100000001, 0x07fffffff, 0x0ffffffff, Number.MAX_VALUE, -Number.MAX_VALUE, -0, -0x080000001, 0x080000000, -0x100000000, 0x080000001, 1, -0x080000000, -0x07fffffff, -0x0ffffffff, 0x100000001, 42, Number.MIN_VALUE, 0, -1/0, -Number.MIN_VALUE, 0/0, 1/0, Math.PI, 0x100000000]); ");
/*FRC*/Random.twister.import_mti(410); void (makeScript(14));
/*FRC*/count=305; tryItOut("/*ODP-3*/Object.defineProperty(b2, \"1\", { configurable: false, enumerable: false, writable: true, value: i0 });\n(-5);\n");
/*FRC*/Random.twister.import_mti(476); void (makeScript(14));
/*FRC*/count=306; tryItOut("a1.pop(h1, a1, h2);");
/*FRC*/Random.twister.import_mti(503); void (makeScript(14));
/*FRC*/count=307; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return (( ! (Math.imul(Math.hypot(Math.fround(Math.fround(x)), (y ? ((mathy0((-0x080000001 >>> 0), (y | 0)) | 0) ? (y << Math.fround(mathy2((0x0ffffffff >>> 0), (x >>> 0)))) : y) : x)), ((((Math.log10(( - x)) | 0) >>> 0) ** (Math.max((((x | 0) % ( + y)) | 0), ( ~ y)) | 0)) | 0)) >>> 0)) >>> 0); }); testMathyFunction(mathy5, [({valueOf:function(){return 0;}}), (new Number(-0)), '0', (new Boolean(false)), (new Boolean(true)), NaN, null, [0], (function(){return 0;}), ({valueOf:function(){return '0';}}), [], undefined, '\\0', -0, (new String('')), 0, '/0/', (new Number(0)), 0.1, ({toString:function(){return '0';}}), 1, objectEmulatingUndefined(), false, '', /0/, true]); ");
/*FRC*/Random.twister.import_mta(1891473633,699962687,-1029358570,-1418263056,202918024,874023867,29685030,-526282406,-1593179907,-1848247631,-1915533439,-698559492,-1724639719,-834356444,-585301562,-1204260016,1742770078,740528110,973509948,-2120985510,-1772657109,-1903018344,910757622,1810654796,-768362138,-466548061,-1757202265,1650779796,-67556059,2043546218,601594883,147550490,-213342517,-984881411,1306360246,-508398714,117836841,1723556636,1537047511,-377394571,-1633353009,-1527625211,-2054334883,-12511172,-1485620002,1913857111,1013849572,-535340045,-1028321005,-1721990694,2041542030,-37194537,-1901558594,372879308,-2140055971,812536781,211455089,-1237511738,-1633004881,733080602,1278578368,154172937,-1702761056,-2025175323,1548494028,-748618883,194097249,-763346948,1572239245,-42070297,985357919,-50949889,1392925012,1824146442,1038084475,-274605522,1006372431,1291091226,-58237745,1168747785,-1467753031,820318240,-189202110,-11749765,2119072293,-490350557,-1935000457,-659438423,-1833897376,-20621023,219492674,1876155272,2131451869,-236497466,-448763409,-570080101,154791487,1721276293,1290502677,-1480550077,-812754344,-113514671,1620166011,1518042547,1814578732,215110470,536047970,-1682790642,1347170872,1693130858,-380343556,469771553,8303320,-1324060973,-248679761,1890720689,-1909948467,-111560195,-198474276,-1547976177,-1314033442,-1356065182,-585001257,-1581253508,846934989,-1840428665,-1544173195,-1217988044,-1167872170,-1108275050,1667721361,-2146168129,11735566,-299162800,-650989007,-367162772,-1467752524,684859886,1840317787,-1904125236,-781829497,-1462471500,-504047184,-1192213849,1213028554,470546614,-1745267585,1009398560,-1092545005,863452100,194991012,1586485722,-2138364621,1797721324,518369881,-1499115255,-728061867,-2131313326,1928168455,-1791554863,2005642592,-814773547,-1700389503,1693176758,56769403,1188938140,-4687896,-337604765,1462033391,1736146789,1851971675,-115641823,916366101,-62930158,-847951791,-2111560505,1765696773,135950675,1703761624,-601441839,1821293034,-1144297510,293764003,1936976325,-1159840087,-1464319054,1019411762,1079761289,210786840,-851084071,-985587153,1004240944,-1247216179,360906339,195570187,2006683907,412238859,-750522293,1905538142,-351953728,-1497323533,-1175909673,-1318712841,164111630,-377255814,-503756809,-599710315,478846081,1080793300,-1369598508,2019753863,106274556,148775609,-395063675,683063791,1393373667,-1655702991,-2050960880,-771974922,-1451230423,1777890809,-1882671061,512793509,-1348135646,-1299849490,932928786,895021411,-754401944,-494641081,-391781447,2060934058,562466520,147569810,141731156,821749339,539530188,-295627822,-1252138882,-1881603639,-526034580,-1984517473,1902376521,1471019455,-1105114929,-694745522,654556143,-886714001,-404475133,1962948283,570489379,392226032,-919547389,-1951490315,-180004776,-169337148,-489041000,-1562431609,1943194071,1240480329,-447174979,-593959247,-2053254570,-880867363,883888465,1109313125,809901429,-454166775,252900441,989803364,1557670362,858361688,1258791919,-298331938,1745339323,-1306178829,-576080248,-1232210249,-161185336,973241730,-1100129224,1011925667,1029787138,800186699,-1108940342,492671148,1215967987,733926704,-2139341467,883066798,311224436,1690268430,-933304349,825822955,-1086771261,1977057226,-699399894,1036200048,879091934,555905547,-2129442770,-567437820,-795511727,121895279,1291814750,1516398054,-1891700481,-1795163714,-1306208013,177559283,-1714506470,-688955349,325189615,1073172849,1441601910,-1972729009,1292821262,-2072569420,1284243463,-1645976217,-690441959,-1323427443,-698547432,980134091,843119207,-2084715814,-124886872,267784292,692709681,1312283754,1491065652,81843544,-1458981764,-552098321,1327327755,1937432100,-1015409165,1963604495,1060529866,299940704,1323915510,-432880743,-825534196,1338574210,-5052399,-2050195061,744846999,1090268913,-6651045,1567921685,-154415523,1140303997,294107802,1652154913,-1754119630,2090460874,-469088323,1569015334,1844713641,-1520144252,-989773909,-946152625,-383427859,-1869796804,-1073830121,24365528,1425776459,-924370780,-1345149729,-273145264,1627064713,-1258558842,2111723070,-1727489265,1699255801,-312855076,1332278148,1188778427,641443909,1938367870,-1147730864,928803863,-747656898,475298861,-1466662472,-434747256,135981979,-745720963,-636451344,1765741672,1403203196,355724451,-1586870183,-1080305080,-1080397901,1199889272,-639109471,1515250405,-12540955,-2048413204,-668287077,972868675,459852663,-926306057,636098768,1272147582,-984089889,-1421837130,571001378,-1339336290,-1868477372,2017671247,2062843413,918818097,-1543488581,-2067910265,836905,330700046,707530635,-1180964559,1281002430,-567565180,1203905399,-1254982313,-1522965432,-376322840,1704061469,-444818905,2077942700,1721737603,191283121,-1659331009,543574847,-586182428,1824091789,181377821,-1500797974,-1049868880,-540464562,404007711,225068111,-991953235,865664906,660000534,-1708922881,2059206165,1991764486,1594577275,991886950,-1176317497,-79030380,38013594,-1190681449,1435408038,349339818,1445169994,-1459526591,-1389861472,-1203180380,-1814675197,1228115901,-296671540,-1506586667,-367286230,-1598909178,-2078573021,-1924888546,-1227790200,-662756324,1203172098,305487991,-118446564,-1398773045,484463281,-716853972,-795416909,881193934,1994392503,-874347110,-6287326,-1312527591,80282515,-645719,298146510,-30875894,1759076535,-1339935420,1891869606,445769065,-827840717,1214689194,-1324631035,441585035,153262391,-471516957,-1874195270,-76283254,136718721,2073454032,267341415,1420968009,-597213117,-341435470,585741038,-1475611266,-535895679,1764380816,1954394480,-1399162958,311827510,1425541389,-271311944,-1073586630,-381026674,-218703176,-188038773,261883431,-923472423,1723763835,1328966404,-1736779792,209159111,-1416977305,615493102,-938707828,1256286910,765249254,-2048443489,-980995119,186965125,-2063333265,-1399565390,1520412449,1577532425,-1594077478,-1557469763,-510769120,797341787,-1268608714,872143646,1796515084,165146323,2087433953,1934645470,-767861949,650609836,58342922,-1099190879,271658486,-85900666,-1363618963,-2031374888,-1452633256,-1870692643,-1484197168,1844317222,2000277714,1337217819,-1395542714,1155571115,-1987660919,541237951,-1844214097,1621498570,1687901528,-1076448344,-1992348524,-32764260,-54937685,952825738,-1306163166,314290521,-337287131,2093117921,686859784,-2044555000,-1009935993,2140598197,-1354460741,-891488218,-240752712,-1918827611,-1029582870,-1080733893,-1106129688,1350142928,-2032604311,-1179970634,-746724149,-951763046,-1828162571,-1512521421,-2090712826,-1990620802,1558835099,-615918103,841870185,858701769,1951662539,1722332789,650911072,-1906910239,1713950637,-1030336695,-1029880750,-162584379,-781490035,-706436169,-1978632554,-894137726,-336175104,-2141218674,-1025690801,-120742225,-1729574852,1954538417,994766819,1803302439,2118109824,1905806757,-1756699585,-1950498118,-1941083908,-1341938842,-83452342);
/*FRC*/Random.twister.import_mti(134); void (makeScript(14));
/*FRC*/count=308; tryItOut("mathy1 = (function(x, y) { return Math.fround(( ~ Math.fround(( + (Math.hypot((Math.asinh((y !== ( + -0))) | 0), (( + Math.expm1(y)) >>> 0)) * (mathy0((y | 0), (Math.min(( + x), ( + ((( + (0x080000000 > ( + x))) | ( + ((y | 0) - (y | 0)))) | 0))) | 0)) | 0)))))); }); testMathyFunction(mathy1, [-0x080000000, 0, 0x100000000, -0x07fffffff, 0x100000001, Number.MIN_VALUE, Math.PI, 0x100000001, -0x0ffffffff, 1/0, 0x07fffffff, -0x100000000, -1/0, -Number.MIN_VALUE, 1, 0x0ffffffff, -0x080000001, 0x080000000, -Number.MAX_VALUE, 42, 0/0, Number.MAX_VALUE, -0, 0x080000001]); ");
/*FRC*/Random.twister.import_mti(347); void (makeScript(14));
/*FRC*/count=309; tryItOut("/*oLoop*/for (var tyivhk = 0; tyivhk < 22; ++tyivhk) { o0.o1.h2.getOwnPropertyNames = f0; } ");
/*FRC*/Random.twister.import_mti(386); void (makeScript(14));
/*FRC*/count=310; tryItOut("window;");
/*FRC*/Random.twister.import_mti(407); void (makeScript(14));
/*FRC*/count=311; tryItOut("\"use strict\"; mathy1 = (function(x, y) { \"use strict\"; return ( ! (( - (Math.max(( + (y || ( + Math.trunc((y >>> 0))))), (mathy0((-0x080000001 | 0), (( + Math.asinh(x)) | 0)) | 0)) >>> 0)) >>> 0)); }); testMathyFunction(mathy1, [1, (new Boolean(false)), 0, undefined, '', '0', [], [0], ({valueOf:function(){return 0;}}), true, '/0/', (function(){return 0;}), (new Number(0)), (new Boolean(true)), false, null, 0.1, (new String('')), '\\0', (new Number(-0)), /0/, -0, ({toString:function(){return '0';}}), objectEmulatingUndefined(), NaN, ({valueOf:function(){return '0';}})]); ");
/*FRC*/Random.twister.import_mti(540); void (makeScript(14));
/*FRC*/count=312; tryItOut("let (w = ((void version(180))), d, eval = \"\\uD4BF\", x, x) { o2.t2 = t1.subarray(16, 7); }");
/*FRC*/Random.twister.import_mta(1922324901,-1531629593,-1919861405,2146494471,-1737736587,-936654236,364564605,-2107711777,347453272,1956736937,1227269084,1706680909,-142405162,382580908,652756925,1161054974,-1307444148,-1715635431,13037316,-1047193916,1835339975,-490770870,2041362584,-147687369,-1395517703,1738232283,-737470718,1298522789,427224872,1838802169,2143247137,-969719239,-255067120,-67755292,280982268,126101039,1608834819,-1106667991,188982799,389444616,347651987,-1009078034,1925892177,-1754898238,-744891010,962707940,857799385,-2098280893,974760683,601680828,-1661831982,-21589096,-1336491918,-1686892181,2016951726,-892641215,265029705,-2139221310,-52850100,-1959615808,634938239,-1634289709,-1818354672,-2139671382,378241716,920371397,-1980593416,1942549818,720584626,1921283960,2131549372,775282600,610812530,2132271742,-1687124004,-669589175,-213937247,2011035659,-816212587,-72786508,-1819275894,-973303677,1466597627,-488206754,1469872487,-828836822,192449921,562108807,1447569675,910768903,762841261,1747269634,1888814409,1520646189,-329769191,-726212873,1235338238,792165743,1906114292,1877017773,-1643960665,-424731643,-528003505,-361536683,-305188335,756025951,-1512921351,-2010580835,1533001893,1087865870,2073220605,313083226,-713388357,239735344,559145789,2002088375,391296665,-1897987227,-951494657,-1876798026,824739658,-1196552016,-928699954,-868046082,1000648827,-329385589,-1816196714,399555861,1935953581,1834761992,1552255569,1266505090,-1307469369,1493547637,798056983,172413907,-191537619,217765839,-422648506,-566372921,-536302740,1124186054,-1369164672,1844527798,1919830714,-509328834,-1943125293,-1598046342,1522639848,-1145830285,1064747291,1672241344,-617917157,277988395,590383875,1664784936,-403460999,-1919910150,-458562203,879855019,309248243,-1866783820,-67937710,-1191505955,-1317181855,1601839422,-2006736330,1296854656,596255737,1345704558,1497153124,-91416865,-1942328917,-318134866,872401561,-1856638020,-1242222978,-1260111260,1960211888,164737856,-1298062762,454391080,1360470917,164015150,-1761743309,-504090206,120885491,1446094556,963831258,1107505790,-1903156013,1150939555,1086438427,956589289,564607320,471341988,-331307167,-1551642682,128918793,-112829201,-1314376577,-1491926447,1646792679,-1164501028,-1881351031,901672284,366000845,-696589137,-968514969,819817643,-1992640024,1473456897,1187461021,1292661926,1918049121,1868747624,-636968652,478261194,-151149912,-2037859324,-523033014,-1478971224,-2137493842,-755028531,-679426443,866609928,-763182850,-1696671399,1240428260,-252014410,1865658219,-1677074372,-871196466,-1798368369,-1840605383,595934897,772775830,-1748855833,367742715,709948486,-143330473,-1808397379,-1020502458,-648380565,1395922481,-1134774420,728743834,-1897022651,1790419844,1914489568,1252172265,1879959900,490339831,-1359013792,1007225705,-787363788,-1921503027,-1034946854,1838653880,126828439,-1187460145,-335003187,-992272808,-404550418,1059203148,-1606554284,-910704901,164046369,-306797565,1801326589,736952810,-461228783,-731213594,-1287983233,-331735801,-128458385,1492036440,-1041020397,-511689340,2004226556,-2050705814,-152535596,-734522204,1096990751,1028373348,-385419052,302255277,2139693224,-1747926039,-1581144681,1028716420,-685787874,-1336940549,-216451811,1491137967,1947380618,1756792599,-157985434,784104383,1266583920,-1906972535,1104792500,-26664218,-569466542,-381013845,-2061080246,1001619730,1339168300,-920925682,-1525317583,845070710,-781229824,-462522223,-1757054727,1191602176,1416865233,-922252325,-1165849919,-1706962863,-1324172976,831371681,677739427,1419645723,1216291475,1399868731,912783046,-498253590,-1189558126,-893324897,-487119645,-17319573,457986105,-745140347,-1670395413,815612603,-1194168963,1598863211,1935837261,903735585,2137743272,1764736694,1186423292,-779831968,-860076413,1105529073,2118119512,921150660,-962954081,449005377,810962223,-998148173,-1819217484,-404432750,-302777613,-1126355436,497479102,-1028750461,1312272915,-1326089592,1221870783,-1264605220,1742206729,-860802937,-1272137023,-1081104203,-1027770092,282867575,-1747666364,-1435204643,-1273380413,320760233,-404572190,168343581,-1165797315,-955529544,-526074902,832659598,112350116,2120737512,428725199,958795956,-200145462,2003884788,-1795651523,1351990248,1415891972,1501153107,1727089351,-1184189302,1751260380,826710830,-290419899,-1715493320,-341717110,-122215153,-676666796,-157469885,466577042,261159373,1238155093,2041934026,-1902927299,-1012858924,-1877173951,256341972,561400811,1490409041,-1431007591,1397084938,-1271001219,-1380703237,345462900,1794940064,-597477137,-1891666793,816443229,-836926108,190144660,582268028,1876192857,-1007827571,-1573472468,1317316992,-1735899883,1212385815,-1407592251,-2069156551,468669537,1000926550,-173215705,1940687516,-1587866373,-622171451,-1983920228,-985713318,-1493991233,1597634956,1547197624,-932267527,-39815148,348130147,1643674858,-75788216,1046376161,668621513,1081129674,-1693990089,1697316470,-629294238,-1044747293,1467240281,-1119384282,969812829,-107805349,391568294,528178228,-1394678044,-1076871371,1637390141,-80082008,1591608506,-414760148,1943827506,-183857064,-782182424,1317272255,1181705800,-1800434986,69471065,-11268792,369294033,-2075357258,-1761713670,-634618852,-726711646,-925953408,1475184685,896707064,-1310233585,-967455519,135051883,1961600526,-301619279,1612460105,-631313288,368472171,-1815118340,124020873,-2009393640,1163292805,868399860,-1564748792,147309050,-2121090906,1954359140,816644124,1452621077,-1257105914,1473488362,1666285592,-957750618,-1118911376,-330163248,-1310627001,-1251581349,-608246468,1631267365,-862996367,1167903117,-472770184,560197378,1240417315,-1870817912,-244720457,-1588620444,715261402,1268142965,449561094,-618471706,1870436039,2144655345,179774296,1343525324,231092808,-530893291,-1253615953,-1330274233,1389311508,-632062116,-1474098369,709476893,1598103152,-1789374937,-215071981,1058353724,131090172,-1088108374,1805855993,-454741114,2039299879,813175638,2125349999,-463030097,-1704703603,-1153460796,477410910,-116772949,217913570,-432954678,401327607,483027775,-2109259126,1705217966,-1799731463,-2105270021,1947363533,-190841280,93276001,-2037925598,448785925,208583267,1087262686,-1969240111,1084747455,939335175,1255927407,-1740688222,894092659,1604691437,30530835,1615217230,-1500741410,1783079772,905374784,1047789699,-67076028,-1090734803,-1578169440,-347880856,943516063,-1935467258,2048866646,1118702538,-1433254293,-732727432,-333384877,-1201535483,-683853807,-1218740692,123068609,-174220734,-81564662,901856774,-1536135844,1472921391,720071910,389771769,-1186823604,-192628398,-1809095374,1352634164,2135445955,-2115364413,-745651149,-149989571,-1919089684,1552279684,1551652341,-2115422774,928978611,1822335301,-1241791392,403744794,-1169258924,-497250839,366747462,1467873692,-1870525149,2082294149,-597604507,-1383629836,-1598622532,-1440109199,383758158);
/*FRC*/Random.twister.import_mti(9); void (makeScript(14));
/*FRC*/count=313; tryItOut("e1.__proto__ = i2;");
/*FRC*/Random.twister.import_mti(21); void (makeScript(14));
/*FRC*/count=314; tryItOut("\"use strict\"; /*tLoop*/for (let y of /*MARR*/[({x:3}), new Number(1), new String('q'), new String('q'), new String('q'), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), ({x:3}), new String('q'), new String('q')]) { a0 = Array.prototype.filter.apply(a1, [f1]);\nselectforgc(o0);\n }");
/*FRC*/Random.twister.import_mti(114); void (makeScript(14));
/*FRC*/count=315; tryItOut("/*iii*/v2 = g1.eval(\"delete eval.x\");/*hhh*/function ousclg(w, x){for (var v of a2) { o2.a0.toString = (function() { try { Array.prototype.forEach.call(g2.a0, (function() { g1.o1.s1 = g2.objectEmulatingUndefined(); return g0; }), h0); } catch(e0) { } try { h1.fix = f0; } catch(e1) { } v2 = t1.length; return p0; }); }}function ((4277))((\n([])) , Math.min(x, -24))([[, {a: {x: [, ], x: {y: [], \u3056: {z: {}, x: [], z: []}, x, x: e}, x: x}, a: {x, z, x}, eval, x: [], x: x, d}, y, ], , ], x) { \u000creturn x } function f1(s2)  { return (4277) } ");
/*FRC*/Random.twister.import_mta(-1868742210,-800008285,-1354990711,-326377681,-360298737,276113205,138102513,1159572600,-2110894880,2084997055,23121760,1753504737,-10955989,667463930,906853643,1945395846,162870716,-816053483,274949183,564641240,973789105,1583540272,-851058019,210533934,1223929630,1686184449,1731331224,1157168515,64854630,578564214,-1577171550,1137513310,-2007506603,1005794274,999405363,1813034395,263437399,429282946,-1385645381,-865266022,2111112399,671313166,-166508427,2097997276,1028168728,2078498299,-1507738337,-471974045,1369362196,-1786840738,443660218,-2108236965,352899977,728256910,19566041,-417292378,-106165190,1765413504,1524763988,1731880836,697553923,676829493,-1157524995,362530272,1696732049,1998926158,-1930499387,-1004976079,2009186563,2045315094,-2085264126,370158176,-1059062665,465221951,1901023181,1986599157,952774854,1779120311,-1256473510,505777896,-830189210,1130011821,-148468786,-87411193,1403509787,850481582,-371979179,1752320034,-1747296969,477874549,863433864,695805027,-250651572,-1662646873,1374161836,1813454853,251770574,1286821918,-1638583659,-1063510375,1598892251,-1097289198,-1889500819,688311153,1926132096,1739847795,1828562902,1103180502,-69916869,-973410300,-975496484,-165069297,-1527312288,-1463636413,-347255769,48004635,1863249370,1541638212,1655910145,318902480,110938718,-1083160063,157139896,-1156694253,-1517195454,432739591,-551101411,1088528796,-2081863381,134206896,2003934421,1515389792,1571383002,-1534475319,-1016412346,907694574,744200235,208814239,-238674752,-819946212,170129178,-204002874,259366524,156186123,1316775280,997796121,-902064592,-698399696,-1733950280,1069154297,1026238594,1387051160,-961833155,-1806000543,-1277554786,-816649907,-764249724,1775886998,-1222501689,1688219366,231921339,-75623413,-540354252,-841434740,796090177,-1901193526,637655551,-1087324380,1656817496,-1264489584,-1861943613,-2135940633,2002063300,-1599006755,-1373210368,817706083,1870983538,1142897243,-118990364,-1481890810,-328879820,1522590581,1021296520,517298880,182788487,-1740835988,-2121624315,-924187243,-853448084,639804595,746156063,238227710,-2099289494,-447871250,-181444136,-1695949463,-172913985,-1927946892,-1891569074,-689448167,1942205371,479727230,-1990137124,-1904651857,630679405,302707834,1639679675,220542673,1291519334,1478014064,-1365413718,998383323,299445472,-859857878,-2109035052,890566784,-200388175,-652059459,1452818756,655649465,-1016179337,1011973842,739664220,1599055889,-110804680,-2090283762,-1028099267,-194316596,-399663112,1101864163,-493932751,-1936782488,-1021698515,-669598286,-1915255809,-1792441557,-290488685,-761407294,2108432834,1575623263,-186972677,1469796904,-2041451028,-114848133,-781035357,1171569650,-1076244315,1330710131,1735167296,1897661110,881494656,-546840262,1946070577,-1606536717,1819285913,-597085473,1130089243,-684354178,-654164918,230896749,-721443877,1509701663,534852588,1344448625,159948840,1354487065,294008149,-771299823,-995829201,-471480192,-700100725,1467864171,-1149855077,1228145475,117276427,1038719672,747629704,1790028152,-101854299,401246396,1344040804,1798735755,513363830,-418786936,1572433642,-1964459043,1493104592,-1150089944,-507512031,-441849281,1041506159,-1542631245,-1751049441,2039881933,-32498188,-627953065,1118020261,1306781698,867135192,1593686252,2069257445,1316740798,426657884,-714631092,681053202,-389907245,969704958,-368462751,-1999049622,-1375081611,-763525497,-1197977460,-535077619,-1973995435,-616355307,709961733,-667796278,-413225857,1911584971,817967171,299632809,-491801858,-786431597,-1078910836,1468048253,-1351380256,-1676641584,-1557798709,1458278588,1762913543,-39300174,-1039284579,-1332958119,-1380207020,-996100937,226217041,1698891005,1178427027,-912485925,-1872703685,-1952899395,-1014032745,-41226875,-1762338435,1694265448,2042690915,-1454924224,-755640031,1045683273,-1307195202,-221886519,-698154229,-163948383,-2125968617,238212931,1001830453,-101925786,1863000465,-1489923616,1206302004,1315604626,2084237274,-184239023,-359334738,1831664661,547403684,-993345474,-971962837,819165688,-537781641,985558522,-1838118495,-1087359528,-1447135892,-1509090875,-1065962241,1021367851,35183094,-949821024,-633823385,-1370252156,-933076252,1546001804,-1170693008,1139508372,43403697,-825214118,291998974,-1890641307,-949381981,1669876977,1672252509,-75566833,-1017971801,-723137010,-2138624474,-112797479,264516346,1029623442,1267709857,1055946268,-805959958,-507787236,673663640,-844320911,1300890131,738120597,-2050533199,-640199660,-217243990,1419704058,1067151319,788914116,1595776913,162939620,-365975330,1669862649,1025714721,-1596877043,975253619,-1269473928,-1838336744,262491964,144244587,34701769,1411240973,35176950,1847051536,-1085880654,-256462958,131885837,-773135664,1456805812,52698134,-950778287,594016672,1980013100,329424009,1163010769,-1028548210,-62676385,-1074305552,-214728913,2129382410,-115736104,-1038938112,1434523010,-296711994,-981140484,-559614417,1106013826,1015735369,648675196,-1995235602,-69773098,-29168502,-2024950874,189518960,-1324216644,-1401611152,-340452316,-197543450,-1347630329,-2044783257,752129346,1587253990,1472061236,801222792,1748063372,1415061595,-83768928,-1710397346,683836924,-712085004,724995891,-1785529975,1805997642,-1250849704,625325973,-1359985701,-1706302732,-1032160610,896506404,1853144359,80092564,-790265164,-679890698,-790484777,-1570787198,100691606,1098859125,1307263189,1349683530,1807263463,-900700641,1994847354,-110312573,-1112760962,1725240423,-1744671800,395534715,1892971235,-65953852,-281776774,124705766,276362856,-1465523109,-1411728515,1524599607,1311291639,1526121286,1434952750,1800725849,140066402,-299759675,1568432708,-389280964,327512092,1253813007,826523704,2093855073,-702917358,-596563085,-343504528,-1907821686,-218296796,932848614,1451221835,-2090669058,-717088371,-87615628,-1153655842,140373381,1715870944,-371091681,-1756723137,1120980438,-535879868,1565949888,-131640154,738765501,1886963357,-26493924,-2052196824,-1453000880,-729948223,1992277042,583326156,810737882,1179485395,-1097694775,626091178,1009123651,1146804850,1076126834,1822715804,-1294139800,-18116829,375030080,800276919,-1914924613,1491593088,-199193647,-407553247,-94889605,-981267574,1405951325,1027832980,1517242561,-844510046,-2051892974,299868614,1664846659,796208862,-319448829,-131779072,-488485522,-2023250179,326485787,-261368286,-62400580,795202214,-1208538145,-1815803942,-2146178841,1644700221,-1250911773,365377412,-1499943067,-808816272,-1761260885,936141590,848855306,908529526,-748375976,-1572441637,-1017947311,1090269523,-664454344,-679480766,252898642,1072735739,817440313,-563098262,1154897920,-1457515038,1829635394,-1364785567,180705634,-211681807,-1597684160,266588313,531696283,653708657,1535738717,-1527650645,1444946669,-2071045908,-728457424,-1380102923,-1828093447,419014761,-873924223,-251103226);
/*FRC*/Random.twister.import_mti(247); void (makeScript(14));
/*FRC*/count=316; tryItOut("{/* no regression tests found *//*iii*//*oLoop*/for (aamxqs = 0; aamxqs < 2; ++aamxqs) { print(x); } /*hhh*/function uhembh(x = x, x, e, a, x, b, a, x, \u3056 = -3, x =  '' , e =  '' , c = window, x, x, x,  , e, window, x = b, a = true, w, x, a, \"\\u3BE5\" = /(?:(\\1))/g, x, length, let = \"\\u7AB3\", d, x, e, x, c, x, c, window, z, this.d, d, w = /(?=\\w$\\b+(?!\\xD1)?|\\x22|.+?.[^\uf8a6\\S\\D])|(?:\\b)|(?:([^]+?)(?!^)|.)?/gy, b, x, NaN, x, e, \u3056, window, e, x, a, get, a, x, \u3056, c = /(?:\\3)*/gi, window, NaN, x, eval = -11, x, a, a = /[\\u0027-\ucbfb\\W]/, \"19\", w, x, x =  /x/ , z, x =  \"\" , x = 23, window, x, \u3056, c, x, y, x){print(((function too_much_recursion(rqbfhf) { v1 = this.a2.some((function(a0, a1, a2) { var r0 = x * x; x = 3 * a0; var r1 = 0 & a1; var r2 = r1 - 4; print(r2); a0 = 3 / 2; var r3 = 9 & r1; var r4 = a2 & 8; a1 = 3 & x; var r5 = 3 + a0; var r6 = r5 + a0; print(r1); var r7 = r1 % 1; print(r4); var r8 = r4 & r3; var r9 = r0 / a2; var r10 = r6 & 0; var r11 = r1 & x; var r12 = 8 ^ x; r7 = r8 | r12; var r13 = r3 * r5; a2 = r8 % x; r10 = r8 % r4; print(r10); var r14 = r8 * a0; var r15 = r1 + r2; var r16 = r2 % 7; var r17 = r8 + r12; var r18 = 2 | 6; r18 = r0 * r3; var r19 = 0 | r0; r9 = r6 | r17; r6 = 5 % r0; var r20 = r0 ^ 4; var r21 = r10 + a2; var r22 = r7 ^ r20; var r23 = r21 * r0; var r24 = 8 | 0; var r25 = r3 % a0; var r26 = r14 % r13; var r27 = r22 * r4; var r28 = a1 | r16; var r29 = r9 / 8; var r30 = 4 + r14; var r31 = 2 | 1; r12 = r18 | r18; print(r28); var r32 = 8 + r8; var r33 = r32 - r26; a0 = r8 % r8; var r34 = r6 / r26; var r35 = r24 - 4; var r36 = r35 + 0; var r37 = r7 % a0; var r38 = 7 * r13; var r39 = r25 | r37; r12 = 5 % r31; var r40 = r9 / 4; var r41 = 3 % r29; a0 = r17 * r19; var r42 = 6 - r14; r3 = r37 & r38; var r43 = r42 + r40; r13 = 6 | 2; var r44 = r23 & r9; print(r25); r10 = a0 * r5; var r45 = r10 + 7; var r46 = 6 & r21; var r47 = r41 & r13; a0 = r28 ^ r32; return a0; }));; if (rqbfhf > 0) { ; too_much_recursion(rqbfhf - 1);  } else {  }  })(77566)));} }");
/*FRC*/Random.twister.import_mta(1324766070,-1616826562,-1454134840,109172222,1265817350,1207227995,-2089358670,-1592695409,230160086,-1026551479,1959883312,1777261028,-1394420397,952743009,-1187763624,-2135344069,-652812061,2017314807,1083105885,-1678034177,-632174604,-2123219379,-1258736303,248611587,-1671907910,836737014,-834577851,695306352,1241112939,1808492571,1275082499,-1892347478,532807776,387036058,-665337511,1986624271,752614088,775785440,1967432594,-819512101,5564321,1397609708,-2109933737,1677411052,-34700881,-154776284,-1592389139,369222867,-1110494027,-87618161,-1227019433,172566768,1671124636,1136660671,-1388413007,7608477,-1706578291,-1079159562,2031316331,1070894695,610728837,1345795599,1629670719,-1304020922,-1062457847,2051521230,-745248519,-1071345381,-337883982,-727861958,1466403549,1968628338,1790809727,-1649641905,-1389127418,1742418990,1975698352,1760902061,410744499,-1314475408,-445537397,-2083136336,-1428800626,1622773972,1803304156,-971927774,-1119404269,522401439,788815579,1337804081,-2041374953,-759223511,135095266,1092456278,-1875355489,2040160990,597412531,1453797888,1205746335,141509502,-1998663332,591546997,1680635334,1519442209,1392186105,978641827,-764645219,-157821006,-940709791,-1987944468,-904074618,1649119221,541004354,-327326547,-507249152,1166128278,951278850,783908223,-1669621303,-1381110841,-485910506,2107819731,92507606,-447119956,-484370743,-1368451769,1939005981,-906018927,-373111043,-1446394384,-1888967348,-1767200781,-1589763731,-288206849,1627302765,1358332844,1374181308,-562955110,-123910802,-1285705674,-789702828,-1919542535,-1260899527,-1826794827,-444781825,-2079460057,-1012906554,-671397090,-238842975,-53355637,-1237316001,-1145040181,6740038,-1674651253,1239575705,168427491,1496177236,1954945698,-243966237,-668610037,-1214740452,-1384963299,1081455547,1626310888,-69092860,-310551564,-229451554,-229153573,-1151154819,-831005046,1748907587,1284300188,-557022650,1453839564,-1753119778,1928751537,956426297,-2137506387,-370514555,1830237198,-1838443004,-154201440,856043200,-153727199,1700167721,872389312,-1884454271,1851879212,-1609705905,-1244667252,-861243710,-897979586,-2015739815,661867192,-598423297,1122113149,1401032799,1509073140,-1448732110,-590945883,2083200392,1382506045,1807641112,-306139097,1703610597,2006447366,157058088,1705026031,-1472137504,971467504,1305564420,-1709354725,1725216473,-1209058226,1113009516,-1923830829,327409570,259596794,1822437471,1631412172,428484042,1088861735,995433295,1236958088,1797941620,1779285825,-806295396,-1799134036,899902942,2103443868,-442262521,1985346751,2045607,-1827905652,1842960539,-845251317,-859495855,1770443486,-876052479,-2116002499,790850295,-1216140938,-1444240293,-320590782,-463507860,1426225589,1218722678,2089507093,-665207865,10727739,-342325039,-1743333993,-182742014,1215451212,1309092568,561011907,-1563798752,-2015393856,-1355087269,1564964866,1920874143,1362585066,1563454316,-1221220387,31127957,1676798614,-1650147961,1543441739,-1837310455,-2020299731,1270762183,1062389207,1118996963,-484589162,-696429622,484741194,-951410193,-2133719386,1724907666,-634766225,294499276,1965781331,-1284544870,15484993,-997836037,-1101450929,-690104452,959947517,964887284,-855557814,-1047795359,-886521154,1944644559,240596328,1837602704,-1701308232,1270452239,-223195554,318058927,364061432,-283673067,-2080181807,1695128887,-945673006,-2004163865,291527235,1253725340,-35843212,1848363795,-1605954805,570567218,-1009825385,1968985488,-810532925,1463499373,-1264258773,1485046863,-613438332,86408634,181786320,592963953,145443655,1570108915,1701709709,-1176508432,-683556177,-1975116924,185595209,1888578042,-932011965,-119268081,799299355,-1116480249,625979382,1883693166,358832845,859874082,1318011245,654684363,37971721,731786347,-322314406,-1767425015,-939254546,-1372569269,1186296074,1513758793,479551748,489020450,2065246411,319389655,123443624,-1798819621,-546383334,-105334376,2095129590,-1395871406,935256044,1975366546,-1845468018,-652775938,532848660,-365240282,1307014816,-772700455,-1131194811,-1447187636,618140701,116415519,-1637628354,-720490222,1383141305,-762367759,545992613,586988107,1836560389,223328960,59759225,-255117173,-1298859390,-1729984549,436233615,-109337064,-754195899,1975470181,-2399727,380005094,-514190256,-939459486,-1327483680,-320486623,-306043741,1958794600,-2009974296,1243031391,-962723367,-2059402973,-2115688120,-401000505,477288753,-263349826,-595433232,2028164432,986071631,-1169155798,-848357047,-1508932752,1411963793,-2135191575,1277120462,-1311751514,-137065400,-46744460,1208637341,-1909011021,-2063458023,-1036204820,1047974839,1061005986,868840999,-1571500994,-1679218200,-1708183155,1333452990,-2143582154,-337518867,1430878594,-2017085937,658997482,1163306831,51191574,1271516492,-1428030392,-765473392,-663344845,752261623,-826300610,757423524,1966985432,1389731292,-1328480132,848685022,-782526631,-843061575,-206561782,-1000885327,6666285,-1121872561,2064423129,-1523234685,789827080,2015769558,-954531994,883325740,22051858,-1859246163,1940323379,-672697167,-23078537,1760918117,-451720665,1030560422,551250410,-548132018,1305737315,1249641058,-544004039,1639405761,-231665876,391366482,-62686862,-486789060,-1459963835,1456717476,1106795577,838535721,986322103,-1576778548,-773940843,1506365247,391579660,-1746464494,2013415326,598231166,-1952078055,-1513923144,-1789035276,-492795590,789891405,299756680,-1881141300,-2075439635,-52022818,946441234,2072225220,-341426930,-327306841,1709458067,-1007837090,1281047622,-1478531187,-693285146,267829953,1959147116,1391226329,-1277644736,-1166974624,44497874,-2062732374,-881575831,259516543,1337397849,1282643671,-1549145327,-570647108,-28737903,-119425464,812650737,-1030277441,-180784384,-1452786246,-427205022,-291733750,-979905814,208736852,191299319,-145842277,525784394,-745564922,2091930439,-1364838214,251321397,2093206600,-2116349360,-1754198377,-531914823,-1413797710,1165592701,-988441085,532622061,-612027355,-1472729063,268668834,-1363922415,1438718542,555654195,-279803338,-14028277,1772811765,21839125,-1011965929,-817292242,1836231405,809009907,1379213024,1213760137,-1323704577,-2022271415,-2043243929,166749715,-649177219,-1265783553,-2000295820,-1083535427,-2118747399,-1702384012,1621500338,-1569653947,-1362076953,-1562139968,-1779446253,1065451753,-1295074799,1928950234,97266575,979069812,1951005818,1189241792,701087291,1671821395,-1868550050,463391669,-2058834093,60243058,748368228,428521379,-843088977,-1047328533,1714942956,-1899610316,772317754,-660523567,-401641881,1514652568,1504490086,46595760,21025188,567812143,713955632,-1239932491,1763531743,-1507395590,-563092694,2057995987,-1210365014,650242493,960172651,1552587168,717059198,1005362340,795962281,-761188214,-516535816,1533737727,669352774,1825370032,-1612343000,431688834,1837853405,535369071,-1385258296,-1799121176,487690772,-1573181288);
/*FRC*/Random.twister.import_mti(139); void (makeScript(14));
/*FRC*/count=317; tryItOut("mathy5 = (function(x, y) { return ((Math.log10(( + Math.fround(Math.min(x, (Math.max((((x | 0) || y) >>> 0), Math.hypot(x, (( ~ (-0x07fffffff >>> 0)) >>> 0))) >>> 0))))) | 0) !== (Math.acos(((((( - Math.round(Math.fround(x))) >>> 0) >> (mathy4((Math.fround(( + (y << Math.fround((Math.fround(x) & Math.fround(x)))))) | 0), Math.fround(Math.sign(( + y)))) >>> 0)) >>> 0) >>> 0)) | 0)); }); testMathyFunction(mathy5, [-Number.MAX_VALUE, 0x080000001, -1/0, 0/0, 0x100000000, 0x0ffffffff, -0x0ffffffff, 42, -0, 0x07fffffff, -0x080000001, 1/0, Number.MIN_VALUE, 0x100000001, Math.PI, 0, 0x100000001, 0x080000000, -0x07fffffff, Number.MAX_VALUE, -Number.MIN_VALUE, -0x100000000, -0x080000000, 1]); ");
/*FRC*/Random.twister.import_mti(397); void (makeScript(14));
/*FRC*/count=318; tryItOut("\"use strict\"; /*ODP-3*/Object.defineProperty(h1, \"toString\", { configurable: false, enumerable: (4277) >>= x.throw(x), writable: Object.defineProperty(x, \"sign\", ({value: -3, configurable: true, enumerable: true})), value: g0 });");
/*FRC*/Random.twister.import_mti(541); void (makeScript(14));
/*FRC*/count=319; tryItOut("s1 += 'x';");
/*FRC*/Random.twister.import_mti(550); void (makeScript(14));
/*FRC*/count=320; tryItOut("mathy3 = (function(x, y) { return ((( + Math.log2((((((mathy0(x, ( + Math.atan2(Math.fround(x), Math.abs(x)))) | 0) | 0) >= (Math.pow(y, y) | 0)) | 0) >>> 0))) | 0) << ( - ( + (( + (( + Math.trunc((x === (y >>> 0)))) | ( + Number.MAX_VALUE))) ? ( + Math.sin((Math.imul(-0x080000001, Number.MIN_VALUE) && ((( ~ (x >>> 0)) >>> 0) + y)))) : (( + ((( + (x | 0)) | 0) ? ( + Math.max(x, (y === y))) : ( + y))) | 0))))); }); testMathyFunction(mathy3, [0/0, -Number.MAX_VALUE, 1/0, 0x100000001, Number.MIN_VALUE, 0x080000000, 0x0ffffffff, 1, 0, 0x100000001, -0, 0x080000001, -0x0ffffffff, 0x100000000, -0x080000001, Math.PI, -0x07fffffff, -1/0, 42, -0x100000000, -0x080000000, 0x07fffffff, Number.MAX_VALUE, -Number.MIN_VALUE]); ");
/*FRC*/Random.twister.import_mta(-1909080361,-1129258205,1597125582,-705367491,1718661890,2035818505,-213499817,-57941439,1963958578,-597214616,1625274211,264394143,-1988942559,-1387636854,780182154,146111706,-1390672711,930679874,301403321,-1357633770,-406356914,-62291755,-307689607,-1401383197,-1022959085,604449904,465708166,1037027420,1192024639,-364784932,-2141241638,1755742426,1323204226,-1238479003,-1443512300,-1131675348,-985593760,-489391878,-1840400571,396190769,75741138,-315941972,589839530,388952180,1240908108,416821104,532128783,1952396431,540837289,-1039950503,-133889737,1254175639,501084163,-1601945329,-1592488121,1395759359,1802555735,-456033672,399298625,-123915986,1727291241,1460014903,1909876294,474869244,1078904769,-1877349047,642700060,943578682,540203263,757620104,1528572408,1583838412,-2138223446,-1428507151,-1861113301,-1843668579,-73296979,-724740161,690508561,-780503635,-470898028,-2068478894,697665365,585700962,-1259350397,-1079416632,-181312530,86980779,454381567,259803040,318221425,1796372668,827534115,519344988,-125404030,1948476504,322573586,-1050408876,-275669839,-401417975,-1387407498,-235169091,-132390903,397041198,1385140200,-1077392816,260955573,-1475204810,-149315658,-545319901,-359953161,-1793934709,1682062048,2140542847,762824722,1344944214,771614065,1254744455,831994797,-1989838269,-676740281,-1068044204,-946483754,1106249217,683041822,241024731,2019622397,-510082571,1602362383,-1325740739,-854903188,437794159,-1831746457,1204936147,646028771,1412949910,-1360794595,-348148704,-1176156254,-1010031848,-1699072546,108085056,-818334872,808653189,1933163093,1909697857,-985032802,-1272418495,-964771543,762985926,1002523569,697932246,-1772953329,1045898884,1397052160,1105479623,175869858,-209256114,-1119691949,-355099919,1221048088,2131032933,965190247,-457274753,-1036844795,-236157925,1598655759,1158654104,-37994191,-1917744564,-2076797557,-2118771772,-911193946,-1641082884,-537787154,927399634,-339877933,-399398510,1288761715,2105292664,1032186512,1883941211,-1043960036,2063843477,39913173,462872268,1957137380,-1516934500,1131235045,-1410711346,-1531970188,-1127062753,-578839960,-1725270374,551063088,1489426071,1992201186,1300217727,-173195587,2136301408,-1847377938,525413436,435210617,-2100269198,-1645408903,-624844482,-781031685,-1543819046,2050120901,533969129,-930315790,-1059086387,538641027,1314585887,1292096956,-1460165079,1557555714,-2000868426,1548894294,-1826583603,-1597970610,-383166555,993274027,-1728342414,953022871,988407386,-396715314,-723253192,-2113870867,-185905902,936819901,-8939378,1893601231,480402629,1129081883,-1973059387,-1465625849,-600619076,-700789794,1206526085,-1232354511,-478330760,2126998267,-550259825,-990871481,900010242,140065603,1390612850,621865111,1097724878,2038123767,-1182062574,1077806166,1019326954,-1266723102,1449784239,-1448210116,1321865000,101006555,-286665454,-1632240240,-2022836830,1042178589,480560245,-752054863,93804889,-479571381,-1800050679,938081637,-536893162,-1852890560,-240700062,693555131,1955139050,976059562,-1701747327,-2106941942,-1955790466,-19096193,1427843557,51988857,-1197261814,-1974531072,-801407755,586502656,2091006975,1024348303,2050350611,1904645010,-2011487703,2044300451,-1598946567,-1758300163,277682388,896651878,-588865497,342981287,-1955724816,1421796784,772686719,1909685702,2057163887,-1312108556,653021697,91605569,209025375,-275448809,234094530,228506888,2023002700,-1710882186,-834536373,24758262,128208391,-2039090975,-295699193,583766498,1348768428,1853395924,-1175425212,-2086042080,1329870500,-543369407,265676522,869030364,-1431137933,882742130,-1794808949,1288337987,492920401,-646920836,-717303372,-311452245,934194562,1001075855,-289812953,1630536778,1610736717,222018000,-393896950,1240660178,-13834551,875050529,-470977269,697522434,-2055038122,-2026911039,-650433194,1691538670,1461306082,1113443029,-1143288660,1642779606,79470897,-1612165106,1239696550,-349855029,-136974427,320341800,-27626856,137399769,329051632,851729606,521379758,746502109,-314863100,145267145,13282062,155245663,-1514263583,-1073535354,-1015639310,-1197569460,1296005732,463144860,-1059513271,-1246404571,-1699977429,1892934807,1126896189,-362830692,1878556684,-1318517190,-374564017,1432486041,-166597088,-629632807,751290665,661971221,-688000216,190261489,-1202492495,-168453905,-1555386753,-12052309,638906751,-851239192,1764933303,1451739011,-241793927,-261211260,-1551651258,-1288868054,-157953210,395220457,534196427,-1906251153,-1529832005,373624508,-651276721,15304369,2096781551,-426031651,-357278238,2115816143,577971347,1842977226,-1154406363,1010723027,-866780041,-723590546,-188242391,1065068232,1990416377,-1584930602,-1626766724,-440453960,-1035927653,-1527591100,410404594,-1489729068,-2002914467,-1276229642,608289469,1821953278,1567461210,1229002299,-233674338,-373993181,947094205,386928368,-56185137,1461773738,621700359,1939751601,-2056770401,347664821,1145969661,1656439611,1824378799,-1528262759,457213476,1622858700,-386751289,1165732657,1658531115,1175472021,-778968871,302355811,-614524413,1108660630,1394727150,-1513122462,1464147945,-116570483,1627123485,-1371980742,-1886174041,-1462459439,1088869954,-1370641519,159739066,1590480464,-1314019968,-753523527,-1585622509,1349505448,-2002997022,1281834834,1268088912,926038371,-931236563,1203623824,896823919,472621556,1286308513,-1615228529,1345792489,-1887239194,971924987,-947269028,-1386244770,1503895376,-559185751,-1587120498,-656435863,872757376,-1334185361,-1752519871,-1548628830,534751897,-455168747,-1594720585,840177721,-1837016738,-1545327153,340284428,27250860,1142001889,1425819872,1860715782,-1648088652,-193036632,1408245329,-1676029564,234244278,1227594382,-1046829277,-634471559,-1014601440,1674164197,1111485923,-1104328366,1380578189,399887956,-166651230,1638214106,1477752645,-1647489773,-1499868247,-124154684,991177829,211349623,1025821571,-455180095,1480796497,-2094995795,562330024,412539362,-1246499525,-893974828,-831244496,1611486416,1210784965,-639406998,1506924239,1600923294,1853115397,-689301263,1732458389,1752262909,-595739531,732324053,495393794,673288720,-850516509,-942496342,56835216,147739234,1488979658,-186594526,2143928501,671365414,-1193047575,759313271,2104011017,1622495607,-2020448898,-1369622615,-405315081,623183264,-1443056427,-50453573,482439129,-1005152020,1593191123,1953035010,-810441449,318799962,1773849593,-797215692,71612280,137353887,-43500935,1645741227,-1395717600,127616562,2066445359,352318058,1707085275,-1437878887,-1049513935,-2145881144,612286714,27907158,165721229,744131369,-716953058,1098003191,1427675004,1579942297,1957492233,612691967,-1369913872,1355031338,-179905155,1835949805,-16703837,1913572958,1071186737,-1057225974,637084773,44835712,-913682054,446807793,679882113,-1709148823,-1533399744,783241689,-482162293,-383032053,-1312763487,923362611,324104540);
/*FRC*/Random.twister.import_mti(277); void (makeScript(14));
/*FRC*/count=321; tryItOut("\"use strict\"; mathy2 = (function(stdlib, foreign, heap){ \"use asm\";   var atan2 = stdlib.Math.atan2;\n  var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  var Uint16ArrayView = new stdlib.Uint16Array(heap);\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    i0 = (!(i0));\n    d1 = (+(((/*FFI*/ff(((~~(+atan2(((+(1.0/0.0))), ((d1)))))), ((4194304.0)), ((-9.0)), ((0.00390625)), ((((0xc5fbfdcd)) & ((0xef21fd55)))), ((d1)))|0))>>>(((0x0)))));\n    {\n      i0 = (((0x33f940b0)) == ((((((8388609.0) + (1.0625)) > (1048576.0)) ? (i0) : (i0)))>>>((0xffffffff)-(-0x8000000))));\n    }\n    switch ((~~(d1))) {\n      case 0:\n        {\n          (Uint16ArrayView[2]) = ((((0xf41f3e5a)+(-0x8000000))>>>(((8193.0) < (Infinity))+((0x70d5b2b) <= (0x3c867b25)))) % (((((0xea5ac1bd) ? (0x59d0de92) : (0xfffd87c1)) ? (0xfa7e1620) : (!(0xfd6b3a8d)))+((((-0x8000000))>>>((-0x8000000))) == (((0xf91c4610))>>>((0xfd9af4ec))))+((0x6d2adccb)))>>>((i0)+(0xeca62a1a))));\n        }\n        break;\n      case 1:\n        return ((((((((makeFinalizeObserver('nursery')))))+(((((((0x6ecee47a)) << ((0x1835f188))))) ^ ((i0)+(i0)))))|0) / (~((((0x16393*((((0xffffffff))>>>((0x667e75ce))) == (((0x4e80b358))>>>((-0x8000000)))))|0))+(0xfe82748e)))))|0;\n      default:\n        i0 = (!(0xfa14e3a2));\n    }\n    d1 = (d1);\n    return (((i0)+((((0xffffffff)-((0x6cecdfb3) ? (0xffffffff) : (0x5a443346))+(i0))>>>((((0x8ca30721))>>>((-0x8000000))) / (0x6b004213))) <= (0x12936003))+((0x471200f8) >= ((((0xfa28f67d) ? (0xffffffff) : (0x36fb3c29))-((0xbcdc9b6) >= (0x6ba296f7))+(0x83cd288d))>>>((!(i0))*0x8e3a0)))))|0;\n    {\n      i0 = (i0);\n    }\n    i0 = (i0);\n    return (((i0)*0xfffff))|0;\n  }\n  return f; })(this, {ff: 'fafafa'.replace(/a/g, decodeURI) instanceof  /x/g .__defineGetter__(\"x\", XPCNativeWrapper)}, new ArrayBuffer(4096)); testMathyFunction(mathy2, [(new Number(-0)), '/0/', 1, '0', (new Number(0)), '\\0', ({valueOf:function(){return '0';}}), [0], [], (new String('')), null, ({valueOf:function(){return 0;}}), /0/, (new Boolean(true)), true, 0, 0.1, objectEmulatingUndefined(), undefined, (new Boolean(false)), false, -0, '', (function(){return 0;}), ({toString:function(){return '0';}}), NaN]); ");
/*FRC*/Random.twister.import_mta(-1369276423,958324324,1113869752,-2091490811,103222941,327614430,299406009,1829324144,837070335,1728545025,976816043,-1946931981,-1886689910,1470748660,2023810690,1763571550,-1324819517,-269484980,905525016,507127789,1545427088,-740140112,56690649,743777208,-1497092079,848999563,1749332951,453590294,-1440126190,-1517245483,-1240219658,-2086801403,-1704341089,-204576290,-690228277,-783367226,1428946624,-1128880253,-1884582499,1258343890,-997727160,-1205776522,870644359,871067222,-255149705,-1041004686,-2044112993,-91705158,1029788396,-239943183,-1205456151,-178451483,-436772873,1835694309,-338625916,-871758920,-627435013,-1751813170,1586869692,-1402808066,1662670749,720283200,-713429763,-80018775,-1037721963,-152503060,1264316660,1880922669,1987035609,-2085148474,-1600061759,-1466825340,-1937556379,2144194139,-645910357,-1173047463,1120124544,512409070,281597978,563643618,-892964149,-2119873497,1524697953,-1269996803,-1750417079,1025861223,-286564635,-2002143532,1259708785,264959848,1706956215,237119144,915680341,-70587363,-682743950,1346278873,-31882109,1336281097,903760178,1654903611,1368166382,1922034586,-396041291,915959149,-80050115,2117869746,639437986,-384985467,1431508737,-133881176,-769770186,909151633,-230689920,2018746639,-1244580449,2072526031,-274964915,500890765,-1874049720,-1141388302,-1582178551,-1176216174,980867839,2006091242,-602308015,454395763,-74636376,-518229876,2003094755,119583468,-1945101011,229449727,1551469983,1926361834,286252974,-2099136858,1220222355,-1205066992,967129309,-830604222,1656546824,1057636438,1956828454,1780706081,1872056655,1118412575,-1959289926,601144353,258787372,-612093031,2058911982,1154209961,946382039,1104396669,1703358281,781952772,608476325,-276279450,556554308,-1548648922,-1511394819,-1929038962,-208145622,217185151,-1640549785,-559394946,-1704698459,-1969970384,1001417775,-1146705043,-951490404,-897248262,-1463753207,1255933911,-228602948,1344830605,1759099664,997609610,1615343983,1789527626,1855734117,870561748,-1925997716,1212368769,160421918,846995309,-274559177,-1700391162,-1187370425,1439479944,-1135938177,2051030878,693450390,-98045311,1947888549,-1152959943,-1681281126,-1569195049,1984568125,615191774,-1695761408,-729618796,1416667333,-1982711814,432809622,-717919139,-5939811,-1261060713,1671934422,1227365908,107372954,-1156841536,-2114138783,-427955756,-1467332690,1824986753,-841694047,1955110618,-1205937992,-901773618,1225143885,-365038253,-281083214,742730015,-1397480820,52701268,2032366912,1986707152,1131116781,-2138594503,-1125274046,-415188571,-2065735325,-1451879317,-248302131,-54643549,152969951,1361338948,1896451182,231093453,639072200,-1630805216,-544432570,1249389375,-1254263603,-1461904794,927706964,-677536764,-212557225,-1496051331,814790577,-958713286,754609278,1920669862,-382372834,-1090624628,-1024086975,739873092,-1259791732,-718065833,-1334275313,282882586,1175720227,-441120569,1735769072,655758439,-1739405047,108767781,-1747018755,2065918887,1262023911,1030319733,-71892601,-1690308150,1858646693,2085887465,-1274789554,1581304969,114831304,2104707988,1899751136,-1359512444,1025445149,-1948208901,818732782,-652595932,141592360,1540955732,-1209301109,815635059,1919595274,280237492,-1095864186,1373837767,-949519647,-1520448427,-2046810050,-889222119,647861476,-1268088186,-611609421,-1050323119,1886006918,-646845569,-2118602338,-1106635058,1734441731,-871814065,-1108409087,1474431578,1248144391,-686415182,-1476398661,1960384074,1720645768,443574656,670613054,1384275037,316281098,2000744261,-1670842545,1636367373,399795884,-402675603,-1007161233,1871741067,-248917471,-1360985584,-449317779,-992182005,1543964087,344323639,636188275,-1564465606,1197064521,634066212,1359831121,-729554466,41042836,-1765371927,-556965196,1993186896,-747227499,-1151995188,521908518,1255346423,-680895143,-740772482,-1838629661,-2108649654,1786766268,-1393759302,-2143066316,-193393745,-2047978785,-604066471,-440207903,-979624263,847259315,-2123793492,2065662994,141423053,-1922533007,-947063134,-1900942830,-453393178,-837244475,-15451912,-1260526215,346244709,194519640,869930089,607527469,-2030430092,-1699708198,-859911967,265990355,-1680227718,-61415064,222787225,909083003,2100538452,-1018865028,-671273930,-729761674,-719806217,1826237037,794505640,-1501836774,791992205,-1982792072,2110082767,369469598,2093539631,1083599696,487711579,1446462697,1963080578,1799807257,-789054517,454938868,-1412858839,727881006,-1172946629,-1382713296,-26151801,-1580533688,633259579,-2038685652,1414523115,-281617623,-1546991057,1193685404,161766031,311899536,-1881741662,-782459835,2069721545,-983404102,1127892897,424448330,732412097,421404954,-1962254351,-302826775,76906849,-595338292,-929703006,-1732655635,1206576175,1419017867,1077609837,505232860,-907461662,-1704756678,-569406956,1881221851,-340493868,2117766721,-1972057575,1093013100,-1021692549,-414673699,1829983526,-281790390,1800016061,1903148015,-514644209,1164681819,1682175393,1642424845,-1662431382,-1370109208,-2104094713,-569403238,-110367752,826794890,1827132460,1407681659,-439023192,-2132346852,-472580228,236194696,-1399836346,-1202641643,1712657011,-754506175,-344615169,-21460991,1369635665,247111010,-1705307163,-1341405018,-943190569,506168786,-1687991677,-1566947060,1453533208,-485363182,-1368670192,-817065233,-1964269610,1028450916,-857703237,-1824202549,574448276,606079868,-1212607748,-719065032,1708193805,-1290091928,195327064,-1857329940,-924716466,-216215474,-841218115,-99147185,-1711992424,1823574052,760243220,811079583,-1481032415,-1135173334,-1119556127,-1766167887,1291584974,2109514690,-902062513,-2071373580,174796702,-2063424479,1257497018,703238867,108818410,488782351,-1820439860,-1990690499,-2039128471,1903632676,1447173035,-369860631,-663626168,1433634124,-1913991404,-235470520,1448017929,23620091,1281721061,186715738,203876580,502484370,519862650,965788624,-871986244,958400568,628606600,119551630,1177436406,1422353648,-1029410095,333647314,378032864,-1486006467,185141259,-1486747675,1030488645,-646809192,773147624,-1960716520,-1159437811,1355400840,254570714,1632833162,-449242327,290365502,-2032228680,-2056446141,1482697862,954594642,530256866,1143764671,1398529498,-1598922481,-1633367755,1933510021,-1423942672,-1794130602,283855295,-1674666380,-2115718075,916658297,-127135708,-1648683068,-178187985,631967944,-1470315166,1015082270,603956113,20528793,-1468080850,-1235529709,418451279,2084700346,231098219,-738485335,1900905898,636776804,1902148903,-1551546369,21304162,1044160101,-826420234,-1228495717,-825474066,1659687521,1006112818,1040274282,-232158212,425091031,-1842834882,631559087,301614586,-611145191,1740153158,947002395,334069441,-1412478697,1328080468,-69755629,-482649095,470355675,-707352138,-237139894,-1199422006,-1575970889,845365361,2105131309,1200612939,-714302763,-73880892,-1121961696,-2112198378,347692021,-670118966);
/*FRC*/Random.twister.import_mti(609); void (makeScript(14));
/*FRC*/count=322; tryItOut("mathy5 = (function(stdlib, foreign, heap){ \"use asm\";   var ff = foreign.ff;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  function f(i0, i1)\n  {\n    i0 = i0|0;\n    i1 = i1|0;\n    var d2 = -129.0;\n    var d3 = 4398046511105.0;\n    i0 = ((((d3))));\n    i0 = (i0);\n    i0 = (i0);\n    i0 = (i0);\n    return +((+((Float64ArrayView[((0x2bce92da)-(0xffffffff)) >> 3]))));\n  }\n  return f; })(this, {ff: new XPCSafeJSObjectWrapper(window)}, new ArrayBuffer(4096)); testMathyFunction(mathy5, [-0x0ffffffff, 0x0ffffffff, 0x100000001, -0, -0x080000001, 0x07fffffff, 1/0, 1, 42, 0, 0x080000000, Number.MAX_VALUE, -Number.MAX_VALUE, -0x100000000, 0x100000000, -Number.MIN_VALUE, Number.MIN_VALUE, -0x07fffffff, -1/0, 0x100000001, Math.PI, -0x080000000, 0x080000001, 0/0]); ");
/*FRC*/Random.twister.import_mta(697128112,1249167301,1213495830,-1056512155,-1576401978,-1165595475,-1936530557,745512464,1425769688,635358018,-1186176867,-1044802839,1067123473,-748246936,-1757138560,-961876830,2119410857,1215016476,432227723,-11390963,1387027473,500843145,1427166845,-1826211427,-337489317,-1271609298,-2037464710,-119042208,-816487340,-2020998089,273912703,1283825149,1041092800,-1494141007,681337998,1955119804,1320868092,1153305643,-1148195587,1382209791,-1213931921,-1094695971,-1820230350,-531897848,-1545341246,1028948941,274140539,-1316712132,-895762278,-1267461564,49615394,-1365721729,-1946257140,1410144079,-85176650,1511028426,-916674080,-1320861116,-279279737,-641566565,2039514892,-531381542,20985891,2029815689,-1734311670,1807348722,227986575,443446566,1741587984,442493438,-1086548931,569485036,-1219711837,-1150143000,1582954646,-781576218,-930262240,374335967,-1951463182,519159990,-1887879468,392808317,759546289,496059028,1299291194,-1825442359,-2001426479,1875280044,634919200,-1879592584,-1331166808,1465997005,-1052950820,-658648623,-88895893,927929970,909788821,-369888041,1703239423,-758028872,-1598888875,-1047836383,-283843971,-1798446242,-660132488,-1353177221,281712252,1696289262,1895732378,347323737,137062488,-1114201804,-280342586,115510833,-1371582718,-2027156182,-778460813,352589995,-830099659,1082664550,-628658016,-1253770108,1837848926,1592798750,217296174,1756697752,-43714734,323868646,1440700799,-1637296206,-1816412731,-1139443638,894308753,359965253,529310249,-993657402,-804218316,-50715511,38353065,1987986826,1504403677,1855327843,1857910686,-1121905238,-1361826384,-1560896800,-1007950140,-1596693517,-1985565866,-1540474385,-1787291805,236795308,50672236,-83697165,409051992,-361107449,-755155814,1104710684,-1761207893,1318147938,518174017,1093536967,-1058316670,-767598765,1007680101,1955135234,-605120339,-1209040051,805027481,-156563176,1974059074,1363565999,2105673585,260898215,158375613,-1445475764,-388351638,-1937262432,-1660303801,-1832485517,974026875,127988527,1431817777,-1298351076,-1731743706,-761530370,1083526376,376323669,464247278,-1562789116,205546120,-1221600076,-1520542979,-583459992,1243020853,-81628330,117378778,-2134806752,699243101,863440234,-1737951050,-362365078,-1765701181,1765982436,-1570225397,1028174856,-1529163950,1235338480,930968011,-1459848742,1387076020,572607356,-1878675693,1212951820,985502249,1312774853,-1027208537,-1105200149,1464025878,-2131596588,-342250435,-1561126004,884117140,-1418057626,-1014465220,673767765,-482634590,-1859102695,-750803322,371371319,732826472,2037187496,2000016967,1828964794,-885508962,-1988352664,223148640,-2117556566,1582446672,747682037,-603760136,-125665629,983452130,-37376496,470098735,1114018337,-727908849,-1307656731,-675743000,-1806680710,-1337220992,-1113627548,-1928772483,-1307280523,-1483161946,925303467,-779694955,170335801,-1089160567,-13031016,-291565892,-1835082560,-547686912,1023411460,-834816313,783169702,-2007515854,625156942,1515800273,789952414,1744299501,120637150,1892383528,-29629194,379989783,-795221955,1113375967,26805702,-1876879179,-1285322116,1131849997,1030453479,-957833624,-1858419049,-1647815466,-1419590637,-198248527,-76680170,555073340,947216806,1889963347,-2013808311,-1707028530,-1221738208,-775347245,617517583,-433545427,-328049073,1002760111,1132582437,1120415391,644673493,1692029574,-2007954449,1229644472,1628898732,-1577195954,1216744587,2090386000,-1853888659,907695053,-2021206984,-379748628,-1141646443,1660859500,908346943,1069428617,-1178269395,-171339344,1442968996,829497096,-245777091,-1648856421,-825684355,120783949,-1004992720,-2052987728,1260498620,988658043,404738169,126331034,1398417054,-1103612826,-361839097,2013191036,-1049586579,1056066998,1225935250,805131807,-2144534884,2105819417,512550039,-628689844,-1642825248,-1452990449,2084057414,694451417,180067854,-194200799,414492800,1216764867,1288838836,-1954471536,647720674,-407228011,-1103719600,1705928753,1408441923,-1130248804,1220662168,-2008356228,-2144326066,-1492941161,-1756860611,-1903769862,-62006124,167008758,-1697832258,-1110499954,1802593970,1036300097,633834617,-1584687398,-1900828759,1602467676,1464026080,-1446848302,-346855465,-776585665,-2128985586,-979683367,969084518,-2121832932,-1195548511,-1302565704,2019802178,1497157558,232738892,-1883449378,-1006427714,903170283,923610666,-740016310,-73028347,544195135,-1645695950,-869657383,-654180335,-533393259,806153995,-2090798228,1556206634,768891406,-1106213518,1790407228,-840123805,1494331057,959473773,-191907963,-71036038,2054253012,-78337816,1329687142,1239340576,293948676,-368236781,1182774079,787569237,1337610171,-1443360168,1373796311,1184493240,1739582577,-384949391,1535319887,132937659,1463673019,1295821471,278625698,629343833,-799542643,-1385767451,431761913,-370445745,648413690,-698002311,-1658436304,-1262948789,-1106010449,-258562011,-255228050,-804165480,951513174,-178514302,1387414378,-151245250,693324172,270847439,165302659,-1656190131,-1525772333,-1801283512,-261400183,-1942202129,-310006299,-1952688317,542197537,-1688897142,1267173244,927377993,485078532,-1942867622,-1623966261,-932390859,1808441164,-287761489,-1071463595,978824487,157004756,1036191571,1776326461,1140901756,-1198906347,-1685504794,649570427,-2030707090,-16668298,-2117903991,-357923732,1940372949,-144591714,-113325164,-2007004119,19663919,1530507123,-1392197833,-454713114,-2079394144,2038304793,-958949580,2027044648,-963115855,1256112513,-237382379,-626683825,-1101371607,1676623698,296690175,295236820,-235945928,1961872057,1217232770,389228050,-1878441640,1743193889,-1359001260,259454340,20055415,2019487528,1566669991,-196921782,271953248,-1470303258,1672960617,-221064848,-55495811,-498631091,136125889,903742531,934432997,-619368956,-1150230155,574354821,-1630330999,509439636,-1569168499,-54810744,1196992946,545233831,1780741199,-2026948782,1434616656,1192509554,-43130286,1514008527,2131286295,-1301756138,477749685,1071406479,-1599277051,-1330122011,-398414035,-358059291,-1257792348,2122037456,-646926980,17518672,887223428,891501796,-170094113,-916507120,932872968,1871526523,-855198545,1213136352,-514619899,1949287994,469062195,1553444719,86425574,-1010620182,-22062300,388644904,-563773525,1552049258,1702529204,1364322972,1939017251,-948564374,417319087,-1574800910,-407327763,-1618999026,2075260093,513146047,-1439904338,-1874605673,-787319728,1491955747,1235499334,-202679910,-644140600,568131642,-715451078,727047318,-1369703122,-377922092,8452444,-1064130561,555055482,-1340700986,1290609768,-1691615901,-511016935,-2026820953,-1563446213,1382392652,-395890571,752076134,1783713746,-2041674412,-347975025,614404931,754148864,2075093096,1566124651,-426888924,1635273103,-782888123,1451970990,-1839844230,-894261091,606248615,-1858325326,-840548181,671647639,2127323716,-2039761570,1254193992,-1921768486,-1163355762,-214180070,-1309685289,-1729315199);
/*FRC*/Random.twister.import_mti(158); void (makeScript(14));
/*FRC*/count=323; tryItOut(" for (let c of arguments.callee.caller.caller(x = e, window)) {v0 = r1.constructor;f0.toString = (function() { for (var j=0;j<38;++j) { g1.f0(j%4==1); } }); }");
/*FRC*/Random.twister.import_mti(291); void (makeScript(14));
/*FRC*/count=324; tryItOut("v2 = g2.eval(\"v1 = evaluate(\\\"mathy0 = (function(stdlib, foreign, heap){ \\\\\\\"use asm\\\\\\\";   var abs = stdlib.Math.abs;\\\\n  var ff = foreign.ff;\\\\n  var Float64ArrayView = new stdlib.Float64Array(heap);\\\\n  function f(i0, i1)\\\\n  {\\\\n    i0 = i0|0;\\\\n    i1 = i1|0;\\\\n    (Float64ArrayView[4096]) = ((-2199023255553.0));\\\\n    i0 = (x);\\\\n    i1 = (/*FFI*/ff(((~~(73786976294838210000.0))), (((-0x8ad0f*(i0)) << ((i1)+((0x51b51d67))))), ((abs((abs((((i0))|0))|0))|0)), ((0x252629d5)), ((1024.0)))|0);\\\\n    i1 = ((~~(+(1.0/0.0))));\\\\n    i0 = (i0);\\\\n    i1 = (i0);\\\\n    return +((+(1.0/0.0)));\\\\n  }\\\\n  return f; })(this, {ff: Math.cbrt(((void options('strict_mode'))))}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [0/0, -0x080000001, -0x07fffffff, -Number.MIN_VALUE, 0x080000000, 1/0, Math.PI, -0, 0x07fffffff, 0x080000001, 0x100000001, Number.MIN_VALUE, 42, 0x100000001, -0x100000000, -Number.MAX_VALUE, -1/0, -0x080000000, 0, 0x0ffffffff, Number.MAX_VALUE, 1, -0x0ffffffff, 0x100000000]); \\\", ({ global: g2, fileName: 'evaluate.js', lineNumber: 42, newContext: [(makeFinalizeObserver('tenured'))], isRunOnce: false, noScriptRval: true, catchTermination: true, saveFrameChain: false }));\");");
/*FRC*/Random.twister.import_mta(1697698604,-1004589666,-1987629978,-765070705,-1735765341,-225076464,-400078214,1087025232,-553394238,-591450592,-1058795066,843744978,-763934898,835940628,-1744707911,-1453324051,1844117806,-2073272546,1286377418,-1239339544,-1189819442,-63269798,962838089,-1122243035,478382767,619220172,-1786911551,1009364325,-584989313,-2044945957,-227093314,261985730,-1343017634,-2078687030,-1759331141,1054950791,1388102789,-1570158757,643598553,536648408,1926266746,-137158602,-2135729887,-1590133745,397646241,-1449802188,-308388324,939500327,-1396300004,1747566749,-1637866577,1277521157,1850126389,-1736923000,-106257619,-725283463,-727778867,52453113,2121653201,1553532071,-1417897753,-1842402382,-1842325166,280622721,-101791581,16247635,-983833946,1479400516,-470356144,1186216340,1789886033,-1946856102,1618615719,114060150,1823853711,-590574203,1235646678,593505282,-913490379,-121817572,1400834792,1694553195,2104433823,-774276477,1773044143,1426943774,1993297017,1238737891,-1426102389,-1129209806,1991699737,1507889015,864145155,-1669117758,-1656778872,-926199276,1546166177,829394927,-1758276107,-1430323801,-396216912,-15059659,-1148636777,414997509,-2044076832,1599499564,-1568347729,1603816812,1034823463,191054248,536434157,268159179,-2028434592,-480472629,1403235317,1503171456,-1338120477,1285076533,-1661657010,-821770723,1388274563,1125886188,415909866,-580061037,-1893045447,478776876,-680135558,-1380289804,-1387526060,745458101,424809879,-472898640,-107932238,300013209,2011200947,790367592,437797065,-2112765116,1144519634,129353639,-1304799653,142796352,-1103334704,-404888515,-1187257763,-1956806265,2087001474,984149371,309264724,-759174338,1945071186,883008978,1364546041,-2056263748,-1683043372,116630582,-1377111391,-624606742,-2045039180,-497669051,-1570052977,2095185966,-181297008,80504071,-991222619,-1546273631,479858386,-1837691911,1580141624,730139325,-1036480469,1623178509,-2045704541,1066569331,-212644149,-336783941,1039280365,-921063613,2051490760,1414284661,1271577880,-347199516,1357539144,-1081572983,-1328100809,1100457550,1197783759,645935201,-1086906196,-1353094000,454498054,188037726,1334441166,1276463363,1903959491,-665552370,-504744055,1257199446,-1150012786,1582423831,-1655410752,-21253800,519057312,242357262,-1243215733,921859306,1210287224,-115777454,1227298438,-1881620994,1885924401,1079800851,850216744,369118641,1957016864,-1672926421,1463515544,-1505238752,678540029,-1844968315,-686671720,278412290,-1731643415,-613636336,1042751343,-2140011642,1232872018,212795503,369544154,-1672468014,-288132261,974653791,-1005289523,-843362251,74752740,-1717198094,-597983883,-1345516050,-1123390857,-59315278,-728039782,-984679864,-1753030683,-1159651226,1012377297,-1425390,1982776261,-758597958,-1240298777,1632005641,-472622057,-1022388146,-454426199,-961430638,-21848849,1827279850,1510450712,1962162469,1879113998,-658724352,-849957206,-124794949,1616987909,-324358343,-180462840,578246208,1297943423,-957059891,-530973703,708844296,-1566564512,802563125,-1769458609,1069939016,-2034506778,1424029100,1759855230,259530538,362063931,-1762306964,533046308,-622924775,89186029,-1703226458,-812020689,-1653993258,556793516,-67745927,-1911186591,862695204,-1974822150,-1261523132,1533086659,884458384,-1824381540,1240076313,-1450858900,-1371161255,859639447,-669599177,-1930253245,1591272908,1106032813,755173770,334212820,-646722286,100040838,1832086464,-189294846,-1083538010,-770043745,486555353,-1845743093,128980559,-875614173,740868240,962303099,206710209,853570981,725172359,1025975939,1256916506,916940277,-2034651816,325258359,-706598995,-819057927,1813797330,1780313558,-1203051046,823217994,-1724528941,-1284915472,-646216687,-433539195,1658257916,803890529,-1861267907,267237253,1624382259,1964135263,2128662995,378711920,2106050107,847556246,290434813,-900134630,-243167540,255982764,-1518216492,-83494967,-1964311567,1338259805,2107661423,-224314532,1184074899,-1667238325,117634905,-2018456964,-38510452,1375322558,-1117188569,-38761943,1566254004,-63492850,13489961,181622520,-321005412,2100974873,970364335,1815515870,-1442961104,1426907788,329565740,285822091,109997373,1042212874,-2109947502,1949074645,-1433371958,-644980593,-1687324454,-1012554567,-188431107,-1493917749,-1434105233,-457603997,-1514893472,518230257,919843898,525005330,-317113600,1192221436,-710582510,-1669112352,-1590511989,-569591190,724215998,-1582204329,-2019459307,1374839910,-440835124,-186296574,1219072499,1994867373,-1882774449,-774061668,-393882107,-1767100839,768791458,-2111646211,-680100092,1702415710,1336286285,-1970400457,1157646828,556364133,-1513979900,533279602,-1099923462,1868152415,-610051292,1977342825,354617585,-804135852,165835276,-507037049,-1793470191,1970438827,-1345100231,-1043740125,1613802664,-1693483758,460358789,1260616369,129250334,1284274692,-1234594887,-1591766818,1254720671,2114517501,687787275,-1494802326,1046632493,-1657145793,2094536251,51565245,1257742470,-2026583685,1397145823,-1858213068,-551943308,1600429870,-1498004353,-798385391,-551102315,-1845848809,-1961840411,-1196168028,-899636017,-878557032,-756675362,1687911991,-1447152941,27865318,1142143746,945131006,-801691792,1118292286,981083300,-1730067496,-1189477372,-1305551263,-1132615897,-776840819,-913154468,-1196461550,-1769923039,601159291,-547693594,-1171333544,597027364,-1250646750,-292306562,-75573663,41144701,-1698967216,685839993,-605811679,470309009,1458445758,156863255,-2087515115,-1190694009,13758342,-1850842032,-1147192536,-1435736822,388088873,1979146700,461588105,-1927122705,1558467840,-2111934159,403159936,1378865913,258270728,602592176,1835459221,1064388040,-765459178,-608700964,1975061821,407279124,480669208,1715377304,-294809317,162342916,908015593,1995152577,-267975691,1532456833,-544526590,-424996570,644955200,1298193747,-1145377042,96850255,-222187724,1115366148,1203914786,811699949,-406504389,-236927042,-876628076,-310119287,1751041443,1425837703,-1805716988,1353677734,-359075578,663992718,1990921922,1181108243,552235903,1919278477,826915525,666286321,-384958934,1376321277,-579539748,-1112727147,1785318693,-1425452023,-977458673,269127371,750320668,-2041436126,-1683580640,-1836569979,-1507055229,-1380083823,-722661642,1101748052,-1548613017,658850507,-1072485123,1453937770,-1417181861,126064521,-1756159214,2101651985,-174070660,1545291674,-459806693,-563566408,-855056132,243007239,-1372002478,1982961040,292406411,-1571833023,1816004110,-919267328,271518158,-217291626,-1108075486,-390585698,-303844710,-440678070,992850304,1755997024,-385865734,-800885900,615690846,336102591,-1796358838,979333229,-1663660327,1445699622,-15900748,-632392203,284679741,63527998,899212408,1198234695,1126493906,1747835378,-265760755,-896614780,143990892,1844273223,-1575268298,457315561,1756920948,562405843,904294037,2049593270,-341628179,442209851,-1405570913,1568410068,1951160596,-1399532548);
/*FRC*/Random.twister.import_mti(4); void (makeScript(14));
/*FRC*/count=325; tryItOut("e0 + '';");
/*FRC*/Random.twister.import_mti(13); void (makeScript(14));
/*FRC*/count=326; tryItOut("this.zzz.zzz = x;x.name;");
/*FRC*/Random.twister.import_mti(49); void (makeScript(14));
/*FRC*/count=327; tryItOut("let c = \"\\u8D82\";print(-20);");
/*FRC*/Random.twister.import_mti(94); void (makeScript(14));
/*FRC*/count=328; tryItOut("\"use strict\"; \"use asm\"; mathy0 = (function(x, y) { return Math.fround(((( + Math.imul(Math.min(Math.fround(Math.hypot(0x100000000, ( ! x))), ((( + Math.fround(x)) >>> 0) ^ y)), y)) & Math.tanh((((Math.max((x >>> 0), (x >>> 0)) >> 1/0) | 0) ? (((y ^ ((y !== x) | 0)) , (x | 0)) | 0) : 0x07fffffff))) / Math.fround(( - (Math.fround(Math.hypot(Math.fround(0x07fffffff), Math.fround(x))) | 0))))); }); testMathyFunction(mathy0, [0/0, -0x080000001, 0x080000001, -0x07fffffff, -0x100000000, 0x07fffffff, -0, -1/0, 42, 0x080000000, -Number.MIN_VALUE, Number.MAX_VALUE, 1, -Number.MAX_VALUE, -0x080000000, -0x0ffffffff, 0x0ffffffff, 0x100000001, Number.MIN_VALUE, 0x100000001, 0x100000000, 1/0, Math.PI, 0]); ");
/*FRC*/Random.twister.import_mti(374); void (makeScript(14));
/*FRC*/count=329; tryItOut("function this.g0.f1(f1)  { \"use strict\"; e2.has(b0); } ");
/*FRC*/Random.twister.import_mti(415); void (makeScript(14));
/*FRC*/count=330; tryItOut("mathy2 = (function(x, y) { \"use strict\"; return ((( ! Math.abs(Math.atan2((Math.atan2(y, Math.max(y, Math.cbrt(x))) >>> 0), ((((y >>> 0) / -0x0ffffffff) >>> 0) >>> 0)))) & (Math.hypot(( ! (Math.fround((mathy0((y >>> 0), -Number.MAX_VALUE) >>> 0)) / ( + mathy0((0x100000001 >>> 0), ( ! Math.fround(y)))))), mathy1((Math.log1p((( ~ (-Number.MAX_VALUE >>> 0)) >>> 0)) >>> 0), 0x100000001)) >>> 0)) | 0); }); ");
/*FRC*/Random.twister.import_mta(153435761,-445453212,2006660749,-2067792408,-1661751740,-2131299777,684509659,1499901260,-510086305,-1313945217,-1314876052,-1080586754,1966828328,388663934,449760173,328027593,1301296066,-321366830,1578163992,2107839618,-606090711,-630170487,972372023,-1206858793,-908649150,-429024810,-767594852,1737068084,-739996098,-1728294696,-757654544,1653281796,-304118180,324019361,-1505182028,727297935,-1823696905,-2130342398,139098482,1977894329,-1920990302,2018413713,-2091054521,-1395030542,1010052625,-802680988,-57329311,-1956977231,-1849407830,-1792379979,-1242716453,689906110,1601868955,1960839805,745551127,-1406971113,2117000156,1985725990,1751312921,491547067,-1039719108,-240402419,456453968,1851628566,194333096,1177980772,-978789135,810698574,659138504,-1811250679,-707949091,-1416464590,958140703,934483264,242545177,-688004598,-1379028698,1820096072,-1244871342,-787417242,1024050379,-2073310997,1858000504,1475423824,152264107,387691457,1399955536,1997133179,1546322276,2028476163,-1659248355,1529633663,306838768,410114682,1832657437,1955590938,951583919,-1841285725,1576643164,-810671632,1290391375,-739382211,-1599996143,412592377,-494320007,-726757112,-304982137,-1613227828,1470001709,-1718551519,-1122007286,1860871973,-673726990,582574131,-142885860,-189837677,-419267119,316472895,-1733015735,507154437,673250418,981079068,-1051373481,781878966,353609879,-198060737,-1334433700,1893152874,-2107700906,773543162,875413655,-1912003091,-1820100457,-449133020,670009433,1942072448,-253221348,-1448850819,2001840005,-397713839,280886695,-1958687892,-1169606297,789426423,-80361070,144277507,-1036349839,702411733,1530538002,1220414956,1038510616,1487922697,1354698019,-1868330698,-19598450,-443284310,-966003460,-2035237675,-131520458,-461029756,-131913675,-1589753496,1239853273,491850510,1700788510,-1700787809,-778542473,-861565829,-1416661174,2013778999,-1073857997,830977749,-1052614545,938620072,-1850044397,846086357,-509665052,-1716237825,1833319133,-387072400,1004334325,-967977738,-251828853,-804384433,-1031509914,-695931978,1132310767,263494040,-1532964130,-260073567,-316489807,-903395075,1522130196,-1701113922,1149263463,16616673,-1254827809,956869401,-500638741,-1706587478,1157802177,-743532279,1360177697,2096556846,-2127081600,887495681,1061547031,1359703867,1082639032,-1575475179,-787786972,-377588839,1485187203,851966716,-87997171,-913904390,140633209,-1517808171,-1316416690,1584362201,845566391,2127495622,2012071347,1780715511,1564805143,284313661,868999956,36068252,-346359667,-1711652865,1086015896,670114173,2133060346,1794545833,1437891637,381533498,-431468664,1982664840,-1045628889,527832165,1972238170,-939060096,1325260282,-1967959947,-751995685,-1139864027,1422348255,433995653,870046546,-1860720925,-644413456,581610825,-2060106721,879661108,301762497,-18391758,999226517,-354968713,1322598660,-1955278583,-165709917,1332784617,-2080094004,-372000141,-801233630,-1209250798,-812203264,1688489601,762216725,-1844640265,1647978295,-1367833367,-1882524736,-3618670,-517300377,-1514739819,-1835631584,640631321,577080200,278414985,-1064842066,-137303362,-1591854396,-2132103916,955174477,955585871,-1178600744,470112339,-1474422881,504472109,876268468,-13796202,1550675628,-871772609,-844103779,864777470,1512107130,358333001,512858870,-429000735,1491036070,-1215684976,-1065589041,-1539807668,1086689473,-147356399,-410434938,122818378,-606172616,-1631883544,-2139520541,-1729760143,-842332103,-274823010,555595059,-644973690,-406211268,492923664,-675787805,-1781342354,1023695223,-278454216,2010326454,-402574773,565810858,-1553592321,-1180693223,2045213092,-808935728,-131508044,-1928987825,-1153591039,555475935,130989210,-290219982,-647761854,136309728,1675750423,-947185053,1951802498,-2067679227,-63771740,1399070033,-29349222,-2089576034,-1114061884,1727682403,1870660132,683342198,635378540,-219722863,-336001818,1407798231,-1993951758,-1969860868,353911468,-191717495,938845609,-254601813,-75524024,1653010920,-1069580910,493632858,-822890341,1892290870,1916275961,-567954913,-148346892,245576036,-1940754424,1005757551,-1850492716,21750549,1404475627,-1282247276,1144347671,1235250469,-554133331,1307040620,-1519350341,-585812645,101617933,117364235,202968006,1257941309,326982360,-1235257036,777670802,-1168665739,1178849744,735942286,114824288,-1334663658,-1613116281,87320545,-997643649,764575848,908998599,-346048128,-1447341476,86934862,-339199086,-818792205,1139028333,123693831,94919187,94889389,-377337082,-1868251865,1759821738,-1145753907,-1338503479,1751078223,-550368853,1832172910,758962867,-492906589,-1564072440,-719358208,-1273122076,-1219845588,-1486552308,-1822115770,-1656998155,2113507871,1271133815,1237570301,-1498195637,1565498058,-1459683345,216972666,-1934561015,-531173732,-2082676336,1389458740,1723989946,539250966,-2122015925,353501449,-24451934,-1078973274,-374155976,264204339,-1611288647,1122807319,688442063,2064949914,-1460369963,-1905995402,2138255401,95325773,855066496,-1700668707,-1023959485,-188905719,984548057,1165678418,484622282,-607534139,452120246,59088582,-1091472399,-1687546740,-1499670533,1411697929,-578404648,929925085,350098373,-717617454,1116568598,-700558729,322087732,2067361129,-1525230650,2098663595,1871471195,1130338604,292932626,218611898,-668849357,1705272614,189191504,-1985036915,-549902470,853984022,1133029804,1175251690,1122353516,-1736691330,-1351399917,1954008871,1224676343,1919370510,-1879165757,1819507881,1889606785,-952420494,-1331530244,-1803340785,453238875,1615937594,-1890011673,1035038674,-560619040,-1775232070,634910860,23932753,1866206523,-395818918,-2010236849,-315533318,-616892404,886464069,-1209217580,790237727,102789069,1523004975,-1237458785,1565524521,-43622519,950716704,-496343012,1088355437,152597082,-1427938241,55373185,1032302489,1639952444,-692613358,-476232994,620761573,-365969917,-1882724658,-2108253876,-392477231,922310710,768448884,-1974011679,-256751198,-125341510,-1135127463,440939090,1672867664,1857305692,-1118096119,1444161118,520172489,159557218,527167385,1500074968,803148382,-846872345,803869988,1115039937,-1461023202,-644554530,-83866459,-1059670049,1802583196,-351975487,-937900147,-2067456183,-1179231256,-2133959156,-1454637651,2122988738,520261303,134924919,654020799,1489865944,434818893,-1178834016,-745185271,-843508815,11818616,1312721160,-68529104,-436520904,-1864249810,-1034479283,17422477,-58110469,830656172,-1132127378,242456546,-1373037638,-1893496569,343353509,-1293772489,1090184602,-89751253,1145701067,437892419,-1937970384,1680119156,81129409,1215658209,-1399761956,-89757497,1053641935,-1483140402,1658923605,1171386888,1399594777,1682302545,1819651077,-1855561406,2081025410,1665781327,1119110717,-1545139398,1542914342,-942350221,-2113714418,-1483722588,967578848,2069296651,-2029735129,-755142750,1063669382,-244856723,1058163563,-758955135,-267866225);
/*FRC*/Random.twister.import_mti(51); void (makeScript(14));
/*FRC*/count=331; tryItOut("for (var v of g0) { try { a2 = r0.exec(s2); } catch(e0) { } try { a0.unshift(g1.b0, this.p2, /*UUV1*/(y.keyFor = function  NaN (w = length)2), h2, h2); } catch(e1) { } b2.toString = (function() { try { e2.add(b0); } catch(e0) { } try { Object.defineProperty(this, \"a2\", { configurable: let (z) new RegExp(\".|[^]+?(\\\\W|\\\\u652F){1,}|(?=\\\\B{1,2}|\\\\cE)?{1}([]|\\\\b\\u5486\\\\D?.)?\", \"ym\").__defineGetter__(\"x\", encodeURIComponent), enumerable: window = (4277),  get: function() { this.v0 = Infinity; return /*MARR*/[Infinity, false, false, objectEmulatingUndefined(), false, Infinity, objectEmulatingUndefined(), new String(''), false, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), 1.2e3, objectEmulatingUndefined(), new String(''), 1.2e3, false, false, objectEmulatingUndefined(), objectEmulatingUndefined(), new String(''), false, Infinity, new String(''), 1.2e3, false, new String(''), 1.2e3, new String(''), objectEmulatingUndefined(), 1.2e3, objectEmulatingUndefined(), 1.2e3, Infinity, new String(''), new String(''), objectEmulatingUndefined(), 1.2e3, Infinity, 1.2e3, 1.2e3, false, 1.2e3, new String(''), 1.2e3, 1.2e3, 1.2e3, new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), new String(''), Infinity, objectEmulatingUndefined(), new String(''), Infinity, false, 1.2e3, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), 1.2e3, objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), objectEmulatingUndefined(), false, objectEmulatingUndefined(), new String(''), 1.2e3, new String(''), false, Infinity, new String(''), 1.2e3, 1.2e3, false, Infinity, 1.2e3, Infinity, new String(''), Infinity, false, Infinity, objectEmulatingUndefined(), new String(''), Infinity, Infinity]; } }); } catch(e1) { } try { v0 = (p2 instanceof s2); } catch(e2) { } a2 = arguments.callee.caller.arguments; return a1; }); }");
/*FRC*/Random.twister.import_mta(1638630609,-562172115,604536093,-1534667909,523538700,-1258071256,210367273,-1880092167,371225451,-1981693643,-74250103,-313139596,-1603798162,-1323018372,1571259407,1258947567,-1931779996,-1706849422,-865764721,-2085971566,-1969935770,-1656873689,-1496705590,-1585592211,-374100029,-1603728770,-1006527181,-368616344,2101603432,-1956751009,121196048,-1166054256,1227101941,-2125429118,-372381416,976381827,1509635800,-856424749,1041873127,1383891780,-571638161,1681701746,-514434953,1401232058,-1784819277,-306777268,-189375410,1335020894,-1368642422,136451775,-1556492659,-1195911285,-723030904,21065747,-773297827,1337520989,2123354231,-471478419,-1930496906,1650397399,-1486206503,-1883909899,-1396030944,-855094569,555975526,38766779,800280237,-1625749241,-596297319,-1436865493,689581484,174338911,1154973821,-713563859,2001222073,-610706864,1474669822,-497559492,-1566043849,273174141,1616084840,1513985699,-1366505449,-1354496368,1067717517,-768328257,-608050632,-1574818204,634917192,-535422754,-1511490761,-587041738,333092969,1869248537,1336424128,-354133698,-1161777713,-117500427,570699117,-2122049888,187887278,1978313188,1513587003,-538560880,-164789287,-735544343,-761355072,1050740598,1608182114,1383998182,1032523493,-917814315,-132313410,218767714,817500006,-638772137,1624416344,-2110121806,-1823253913,962584672,621316131,24285799,-1770377311,1357026925,1918381701,-962148357,-826675555,-53378874,-1156719129,-483007314,1001198246,-1204525056,-1011577734,1991441277,-648541742,-886750588,790777186,1748624000,1571699700,1748958958,256452605,23706878,270330705,-1701761231,-180996789,1793809449,1358833128,377506393,-725075401,-412735880,-1258723891,-730781133,-58305984,-278403987,-1146166376,646872495,-1548343798,513356788,-1974733377,2038782938,-1417777920,-220836273,1374217243,-1408484457,1889807008,-1951008574,82953997,151617274,-86814207,587157841,-197051310,-1524376377,-376096428,-551242146,-1125963585,279529070,-1748357373,-446236234,1298547942,-1026831321,-294900022,-922617004,-169928580,-1735310557,-585370218,-1259495807,-330622610,-146692793,-1794832130,122053559,-1186026342,47646174,879153828,-497381442,-337183177,-704582553,-754873833,926832528,-1770315958,866104324,1759260354,-661386803,1799239677,36577299,679550142,-1756027580,-408483102,1193601722,1372519196,157927783,-266387057,1770645463,-1041247414,-818271788,1792288455,1813458627,-1134644187,-1233265144,-1246298939,922253743,-391899087,1588085696,-985426182,1974915454,187865901,-842944299,-1800347938,-1768641902,-1147049185,-573344572,2065391667,136517929,-616452177,1584094556,1834055165,-602386405,388157808,-438939226,-1047634200,-1517599828,199793828,-305389835,132781911,927605292,-369055597,883088618,-467193073,-1977469357,-204116173,-1422626639,529897001,-107639734,-538047722,1756696608,-876719057,-1573991033,1243140197,-440877552,-145504345,-1601067985,2035511142,-415148745,1871904131,1064960282,1149454352,1489427275,-1090618017,171494872,-582104798,-635607910,279236367,1192885606,-1194313179,223366074,377353139,1310618664,1049034456,1861984877,1604015771,-1403239381,2012336584,436283742,-1998416170,1358228518,570573417,-715695893,-2092201463,-2025610485,224252569,690893011,1844362114,-134841012,-604871230,546413796,-1361783400,1861142349,343699047,-1387010139,-906944206,1832077835,1824668982,145357527,1471193761,-329507829,20919478,404604913,1134272687,986837265,-700301210,556523565,-1672265018,340297592,-2010270192,450063828,-1465234862,-213078514,-1572733873,288889776,-1352470637,636741404,-1295354730,1656084990,-849251342,651301443,-1314371360,1079919361,189831253,466945327,2098187556,1550980856,1353439334,1207887431,506526713,-1765961239,-1650076048,609729634,263736106,559893652,-1530762753,-1403522899,-261277365,-653435610,335301605,1385222171,-551936371,-1344733467,653339509,-955321527,-581818790,538511517,136414681,1013151704,1169298348,-31879556,509176938,-986180764,1431568510,105756023,-2011839332,1028411722,940457994,-1648801925,-791560033,-1556269686,-1479129769,1579796917,-1788490557,1444055320,940949893,1419173164,1288248834,1502050202,-290567385,622082562,-1472124428,-1895086319,326734496,2134360824,1579467892,-1176822880,-1107564327,131065371,-1381016470,337562977,1189466743,2010735988,1940926173,144917948,335510032,755334274,-396474434,2146397416,1086201341,1729230585,799895011,774809336,482897872,143544369,1559922189,-143086467,94711128,-248314698,-2000177193,1956850899,1286062965,142647149,1342235391,1972787173,-758859758,1014498593,-437825009,-490111855,185051860,1016674356,501598277,-840322436,104308853,1654541090,-791237464,-2076168741,1897212738,-1930944740,1477076833,-1419179062,-1808179499,-894574760,183174517,1811156946,586943200,-299910776,720818673,1774976692,1268335867,-1676380534,-467809720,567960009,678830850,-457388593,730739039,1632393834,1724065477,-1244400431,-1916333205,1547317927,-1888389113,-826723624,-1873255217,989176409,-2081385422,1938819481,-240934740,-1953444600,-991475624,999207022,-1443003942,1078849536,-1485380260,1530056713,-2032318878,791932772,1783854602,-1428980632,-156915559,-562016637,1136951758,1039053365,1814153733,412072102,1152141565,801548578,127521678,1242468188,-5970230,-724706965,-633156563,7069436,1015239995,-1141826866,164759125,-1564950742,1407638240,79799657,-923603854,-1682148556,-1884109707,-1429857077,-701257099,-1509421207,-1739308354,1686764305,-1670752444,-1014486132,-796291203,-1680331564,355140460,1209280013,-923611877,968997571,1417752930,-488339878,47363941,1480041766,317233851,559409308,921595369,-268661590,401985089,802072175,866946172,2037796190,-969494698,-1373701096,-1414780770,-1235491948,-44049347,-826347331,1309846042,131937669,1326002478,450171580,-1979180794,1146594638,-632702727,1594163195,-201904390,1376509776,-931998874,1956118853,-880487056,-1919488577,-1390615150,-1027441041,218245363,-453072721,1797265717,-853229525,1269361312,141388385,-2059588053,766411252,-1020487188,-1181802125,-1090374470,211526038,933551989,107638129,-2121495745,959458543,-581483896,-184454808,-784717690,2112780149,-248103371,787062344,-1602349769,156982396,552324636,1353420752,296180362,546690187,-1124912582,512921845,-536543559,-1261167351,919598375,-2016564953,-1121471746,1530479188,-1555278843,-1753086273,-1044705046,1691923694,-209825799,718291490,1005722927,940334185,726330613,-168052594,-2020167658,-1795109654,-1562813130,1794668226,26839232,1907823263,350333064,1218792089,-2088209832,-1618677052,-881462793,-1229743527,1696626781,723966028,1688673961,-58233426,-925331083,1246619657,573647119,-106552211,634962215,-941621748,25844074,-1747475153,408267539,704095689,1772637506,1920721292,-388990532,709238098,1784648073,-1988424391,-1094236551,-418295064,-1548748394,1475239650,-1188067091,-1080870167,-1134620884,450697449,-110022645,-386583945,-976355491,2039418230,242903756,-183165593);
/*FRC*/Random.twister.import_mti(156); void (makeScript(14));
/*FRC*/count=332; tryItOut("\"use strict\"; mathy0 = (function(x, y) { \"use strict\"; return (( + (((x >>> 0) / ( + -0x0ffffffff)) >>> 0)) != ( + Math.pow(( + Math.fround(Math.min(Math.fround((( + ((Math.pow(Math.fround(y), Math.fround(-0x0ffffffff)) >>> 0) ? ( + 0x07fffffff) : ( + Math.hypot((Math.atan2((x | 0), -0x080000000) | 0), y)))) < -Number.MAX_VALUE)), Math.fround((Math.fround(Math.atan2(Math.log1p(x), (-0x0ffffffff | 0))) ? Math.fround(((((Math.fround(-0x0ffffffff) | (y >>> 0)) >>> 0) ^ ( + ( ~ 1/0))) | 0)) : Math.fround(x)))))), (Math.asin(x) & y)))); }); ");
/*FRC*/Random.twister.import_mti(427); void (makeScript(14));
/*FRC*/count=333; tryItOut("\"use strict\"; mathy5 = (function(x, y) { return Math.hypot(Math.fround(((Math.max(x, x) % 1/0) >>> Math.fround((Math.atan2(( ! (Math.fround(Math.sinh(Math.fround(y))) | 0)), (y >> (Math.cosh(mathy1(y, y)) >>> 0))) | 0)))), (((Math.min((((Math.max(x, x) <= Math.fround(x)) > Math.sign(( + Math.tanh(( ! x))))) | 0), (Math.fround(Math.trunc(Math.fround((Math.max((-0x100000000 | 0), (y | 0)) | 0)))) | 0)) | 0) && (((Math.fround(Math.fround(mathy1(Math.fround((mathy4((-1/0 | 0), (mathy2(Math.fround(x), Math.fround(-1/0)) >>> 0)) | 0)), Math.fround(x)))) != (Math.imul((Math.min(x, ((mathy1((0x080000000 | 0), ((y !== Number.MIN_VALUE) | 0)) | 0) | 0)) >>> 0), (( + ( ~ -Number.MAX_VALUE)) >>> 0)) >>> 0)) >>> 0) | 0)) | 0)); }); testMathyFunction(mathy5, /*MARR*/[x, x, objectEmulatingUndefined(), objectEmulatingUndefined(), x, objectEmulatingUndefined(), x, objectEmulatingUndefined()]); ");
/*FRC*/Random.twister.import_mta(-1095231624,-1745483684,2083747103,1245668830,-340612830,1468792476,-363621136,-1631630817,-1787244760,-1262365084,54311135,-2097723995,1693068959,305930455,1581567417,225057510,1907948941,-488651299,-1942159691,1132279110,-1257638546,-2085378483,1307998514,-1664856964,-589522397,-1560143577,-563436034,-359094047,1443513128,1232577149,1993062810,-546918075,-289932599,1578116477,-1378189910,1734664087,593836348,572106468,149168235,-1618465558,-1767731082,-2110935621,143578935,-184189245,-1022849673,-140755636,1005802504,-1740149182,329288024,416035670,-5834429,-377281930,-1439170225,1079977181,1967391865,1655181500,-1821055225,-276104223,-1469396812,768307567,-2048882516,-793221262,-792757552,985839545,855378154,2020917008,1208253151,-1258902051,-238316289,950852819,-2068508202,-3196900,-1669994133,-449478771,1740776052,-1806290763,-437897867,303985769,-783857379,212527759,266821952,-2019765631,-182797214,-1791204359,-1261237399,-1525539474,-894606330,-580989743,-1697836892,500115249,-930531982,1219608149,-902531134,-1145156572,-151386349,350316869,2125403889,-584997627,1221995869,-1922319796,53800497,-527285984,-854090478,-523450794,-1423235059,2074593499,2114415399,419633496,-960258599,-1875314196,-1838958758,1336019747,1072913903,-563369755,467714796,-607815502,-1220087859,771670481,-1844379507,-979476780,-1637036951,-583231967,-340989611,707575451,-32737684,605945704,560742296,930705622,596716807,-1784391115,1753363781,-1436642483,1875321054,-2119114373,-1487872211,1519586882,-790472209,1173816527,-113524900,-721106559,148485150,339471196,-1175542093,549401494,1441939384,-1753405874,-1630325659,-2067238223,1977187917,1123584262,-905967319,-1558942808,465187713,-1930602166,-1214121603,-521327312,1638205362,1012096823,1973023121,894761116,-1329063896,-530868136,-1348765281,-996071574,457731220,997502432,-1336892812,-1834029832,1337635152,-2029572905,-1868555032,-679032657,-133145200,113390698,747378649,1637083303,1482899193,1564557148,-2141123931,1551694736,-1854192348,-42386392,1077992868,-866867203,-1450833571,2008810615,-1826656029,1583557879,-1844524131,-1624300523,-554733525,-783902555,-2019631738,-1982089319,-651288928,-1808831619,-1491581338,-1008394544,327299595,375340654,1290047572,-917542394,1606442714,365614901,-1669515379,1803955810,1248186516,1095708876,-272124448,1238854052,-947233178,1252554796,-286909997,1386603973,1209169238,612897627,215003622,2063353424,2112337633,285586411,1971927305,-607061130,-1842455864,1499202068,-966302269,1143080355,-1101051858,2053116456,-115363266,-1732872743,-685352555,1595592234,951996466,1173593809,700175053,-555112560,-2044002633,1677432747,-801971085,555638989,-1110270094,-2068220211,382667760,-575661797,-1198609496,656922605,-1620795728,1441526312,1327574730,-1691090183,-1609659815,-1288986712,-682061513,1656569654,579305213,-1441883195,2074869109,-1804932458,371643277,-1843507846,-189251783,1125888948,2027544346,19176756,-1754104930,-1902924261,-627815930,-1207667481,-282910730,-640417681,-695631760,1181229242,-1321985903,-1446699762,-1085778858,216266292,-1229368641,1231282897,1722134716,-775886421,1298116722,1899319058,181561007,461207276,1546250059,1892138351,-144568267,1514590527,1562890180,-431479023,20547871,1594178059,675049826,1601048595,1518960292,1660752659,-1223843874,-531791537,274607558,-1441466384,2020160057,-720190469,997232239,-1518751954,-2028460210,1770138005,-1999985960,616972659,1308725832,-80536319,-552067003,-1329213343,-394548348,-554155729,-1527211050,1390763612,1431513833,1177612900,440946139,-749646455,-890986277,-800407830,-561983301,1719349889,604386394,-730410584,428443652,1035143331,-827635108,-448630495,1513817514,1027335470,-370036496,819298335,1260963689,-1054885812,-2137563226,420098938,-2139012182,-556961387,-1293089162,-887728191,1803919456,29577300,-484831620,1482761704,2131859375,-255467708,339255984,1991547750,874317175,-589987910,454113366,1849723309,367360356,1228614968,260714577,1820907275,-185025560,1941962971,375714329,1446023101,185439367,436325275,-1276423990,1786898914,-1106408179,-1914969085,1047561674,-1618335310,209487963,-72504588,-973653169,-1963745121,1514496486,1013298973,2103666810,-451777773,-1074141576,-598771918,1442978456,-1586079928,871037791,-606118314,130018701,-716614112,822434370,-1187535584,-153541095,-1682679232,-1151954658,-1574972747,-1846221245,1049535578,-2051424380,1105102520,440972304,668331825,1966222926,-1161639108,1046197809,-236487443,-2100638191,-415731812,-1073102795,829016837,-4235075,-1206314707,978161255,-340016004,607693162,-335160265,1777375341,82125854,2023224777,1209903992,-1369439868,-159111553,174997143,-15448025,-1884309481,740531663,-2120487272,1946966483,-1498156676,-805371794,598030727,1570411812,-29313342,-1816951043,556738671,549004591,1703679271,946550192,-2002079497,-67328927,-494813284,189134358,2047759641,1150237294,-784027790,-1745269700,-744637737,-1839153862,497082172,-1396493223,-713567720,1953592080,990924645,-1426093410,479487120,-1542143505,434462100,-1432254269,440855080,-358301552,1814539522,-733414748,142817688,228059959,1352278245,-874400162,681652238,-406274480,-469467538,2133504430,760855710,109841363,-1822809508,352576055,-122200395,-2023958323,-733377657,1800226937,366878038,-932694904,-2033414242,2112829868,-1569210307,-1096025017,-103457443,117311684,-405757345,-1518719088,1476482092,-466110872,1477638673,-1198383514,-1470628125,1995240632,1625327858,1715342591,-1015039887,-1878930512,84334398,1381157284,473722321,-53929791,1998218135,1767240700,-2048995427,791980500,474481274,885445780,2124260484,-1269307581,1596918339,1418327628,1301178813,701051140,1282541792,167768836,736775333,281366260,-1542383170,976132809,2091781388,649925000,1383052117,758676961,1027982004,-291171833,-1804084175,-1896478557,-1991741721,879182965,1229997965,1571510401,181470715,1845427366,1561338054,1485931496,-1024078563,1683103389,-1688432199,735438616,1712134382,1150158735,-434990949,-907155598,456614217,-75923061,346590871,-678824564,-603098109,-2088322917,381807393,-464584289,-1429600674,-1239563016,-2122008092,-2053792865,-2097013108,-1866583488,2032051869,-555831982,-854083895,1390979311,-1267089484,-142071315,-426477382,-501085974,41747991,1123554794,-2082187466,-569206059,-1286483777,977509547,434103361,190326805,1940851235,1135450463,218694905,-69195289,1976254895,-1735039979,1279870753,2010537340,-1772807729,1249744589,456962764,355056900,-387443544,100328469,-774716776,-180583740,1006795193,-355026371,-1805520306,-527099786,261269437,414216001,1422024501,1130984808,1911922904,-1235181166,978422619,-946317289,-666741262,-2060314630,403751639,-1889074000,-1315515098,1236750043,-600859691,-1953375578,-1989379685,-98213245,1019437323,-176035652,-1470630110,1449660742,-1094813359,-1264963861,2146863243,-1460231793,1339188971,518437316,1332607825,1780132146,1112089313,-2105242910,-497239852,1158987692);
/*FRC*/Random.twister.import_mti(266); void (makeScript(14));
/*FRC*/count=334; tryItOut("\"use strict\"; let (y) { p0 + ''; }");
/*FRC*/Random.twister.import_mti(300); void (makeScript(14));
/*FRC*/count=335; tryItOut("\"use strict\"; v0 = Object.prototype.isPrototypeOf.call(p0, g0);");
/*FRC*/Random.twister.import_mti(315); void (makeScript(14));
/*FRC*/count=336; tryItOut("\"use strict\"; let y, b = /*MARR*/[new Boolean(true), new Number(1), this, this, (void 0), (void 0), this, (void 0), new Boolean(true), new Boolean(true), this, this, (void 0), this, (void 0), new Number(1), this, (void 0), this, this, this, new Number(1), this, new Number(1), new Boolean(true), this, (void 0), new Number(1), this, this, new Number(1), (void 0), this, new Number(1), this, this, new Boolean(true), new Boolean(true), new Number(1), new Boolean(true), (void 0), this, this, (void 0), (void 0), this, this, new Number(1), new Boolean(true), this, new Boolean(true), new Boolean(true), (void 0), this, this, new Boolean(true), new Boolean(true), new Boolean(true), (void 0), new Boolean(true), new Number(1), (void 0), (void 0), (void 0), new Number(1), this, new Boolean(true), new Boolean(true), new Boolean(true), (void 0), this, new Boolean(true), (void 0), new Number(1), this, this, new Number(1), new Boolean(true), new Number(1), this, new Number(1), new Boolean(true), (void 0), new Number(1), this, (void 0), (void 0), (void 0), (void 0), (void 0), new Number(1), this, (void 0), new Boolean(true), new Boolean(true), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), new Number(1), (void 0), new Boolean(true), new Boolean(true), new Number(1), (void 0), (void 0), new Number(1), this, new Boolean(true), new Number(1), this, new Number(1), new Boolean(true), new Boolean(true), new Number(1), new Boolean(true), this, (void 0), this, new Boolean(true), new Number(1), this, new Number(1), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), (void 0), new Boolean(true), this, this, new Number(1), (void 0), new Boolean(true), (void 0), (void 0), new Boolean(true), new Boolean(true), new Boolean(true), this, this, new Number(1), new Boolean(true), new Boolean(true), this, new Boolean(true), new Boolean(true), new Boolean(true), this, new Number(1), new Boolean(true), new Number(1), new Number(1), new Boolean(true), this, (void 0), this, new Number(1), new Number(1), new Number(1), this].some, jedbqg, x = new (void shapeOf( '' ))(), {x: {}} = x, x = x, yksimt;print(uneval(s1));");
/*FRC*/Random.twister.import_mta(1815014175,-1843190754,-1612875309,193127072,-1709014109,-1209858967,829389388,-1967806559,1795760183,657034253,543820576,-785372681,2074961096,-1844281495,-357510844,-937142668,-1400736209,-1484703156,698560987,-1260061901,777340294,1821704718,-243896807,2026456537,-458612349,-290538393,-1740063364,-843656984,1917608335,415294794,-350126759,269745017,1706239132,935466682,-905708997,1950255545,694675138,365957149,-197610988,-1445922905,-748974060,-1488875939,-419088944,700995862,-331918694,-1906044717,-1639773669,1416666000,-1599787534,1940659814,11592235,-150667491,1406707759,-1086400909,-1790916175,-1990746424,1147946476,1316195954,625592568,1859643732,-1139488483,1625064688,-906100684,1239688336,-136582698,-1783906882,1689999457,99157198,-1166774504,788739189,2037094365,1147692598,-23990994,-1957277809,343896136,1068638690,-1152728430,-1535833849,389411088,-2126561474,-416686029,-654664180,1832746340,984901686,1417086579,-2105143204,1390278951,359128190,869831983,2086035624,1170370963,-1924283134,724816554,-2104149084,-1253701502,1696629718,664381933,-127569585,1424430210,-995186154,-864012207,294759710,422809815,1229187908,-873464474,-1170012362,944199736,-990586185,-62153803,371118574,-1437580542,-880838763,-1611377239,25323926,605900637,-381580388,-550330685,873539879,1491187107,-1433347097,-785651129,-1095665888,-517565837,38009218,-1129583181,-2067676163,-1790267192,25708731,-1480730192,-1541804560,-779312648,2100467092,-198296380,-1750007921,903349449,1938575669,-1616827355,-1480503785,-664849657,576832225,1318318625,1676505885,-1716355399,835616405,-255389012,-1026972550,216366091,1072266234,-1560609768,-1429643414,-1245367221,2116005697,-1335138211,1130165637,-169669369,-204432043,396307716,-623186294,-998977252,-713835811,583361731,2059187108,-1780958632,-1422897424,-6791654,441800493,196043670,-466022498,1150925921,-83763509,-930592733,1708640905,1211707936,-52317936,-361964077,-1204802726,-717179319,-319589342,-156558883,1156900275,157991784,-160073955,-178293268,-688453955,-134279200,2020547590,-205274447,1105008521,597925905,-897748621,461194928,-676422515,1030779749,1661315309,-877696480,122584070,580647424,-1589901054,-1118880091,472105841,-482349804,-1214088545,383765695,-1893275186,-89910399,-1801175700,1762711229,-338935515,-277189004,-1431742808,-1619960171,-1833378499,98282113,-1939944055,-584800204,-1193926238,-1981542973,-670178524,964479141,-333559120,856605823,108713525,112502840,-126738209,2040346860,-42787645,941930168,1352741376,1198566957,1833362886,1678738869,-2038584390,202537950,-1128651787,-1514048407,-1324027981,-807602425,-1854158394,414689614,1698966385,1229354192,-1579723588,2146757158,-255515653,1830445413,638680707,-569310681,163959523,-133712979,947493866,559712781,370072007,-1611652100,268677853,1102654933,-1768869910,318083073,960144448,421322180,-2031645729,1448071008,-160492106,1957480227,585030413,-879659057,-1720543465,1826258187,-1530257425,1386430133,-1941834264,1258047819,1839590925,-628711852,-1041817552,302080138,586232946,-1911201839,870464117,1189886743,897019926,-2019266054,153176633,-2065095234,-210762090,-283582438,-2014285763,-1694748396,-1836634369,-890230873,275412068,-9565878,-473575065,588514664,1241507635,-1382072936,-1577934601,-970111987,826573118,1365384654,464372973,953654957,-791705696,755955317,-121188043,1237101842,324051068,1247063896,-1071044329,2087428179,-1682317927,-69324583,541774769,1962049556,10597580,2081780560,-2139508604,1598953882,-772872287,1038996249,-683068904,-357538607,1125044224,-1894405559,899331008,-765584997,405000320,1132437144,-338322049,-96983727,1949176322,1474173395,-15260386,2065790950,-2065986733,-461699439,-1140837274,1520158803,-1441733929,1024556928,-964503918,-50203991,1373609837,-375381066,-289433091,1478605779,-27144533,-1829620667,-1690846433,-2048181613,1646305303,740902495,-249335400,719927284,-1615328134,622190119,963670343,190133930,-336528372,-1646648026,1712649495,631244942,-1453949355,-410778585,-2041281472,-763249946,1582384478,-41648065,296464580,1814587332,1183091275,202943471,187973588,515425514,1640484088,-1194127189,-1672787931,21551676,-365312137,272110808,-613784303,1407704609,891207799,-566283650,-850892003,-260160102,-1661567939,-907515827,-1063172336,929472132,-931925289,1664554869,778739172,1158808832,158579796,-2066330430,1237182057,1910741388,-233742588,2025238295,-1910744601,1562034105,838928900,-877912940,743237260,760160639,1350310236,-2114921990,-851135356,-1012361949,-1488772775,2046646393,437252873,2048757257,1451264138,1708376629,882090195,674747027,-951916252,1898711105,-475062351,-1407396139,-882729620,-465510352,834798270,-960263883,1972703929,854493667,-601901451,1735592254,-549394345,108186502,1365944781,-2003720268,-196264423,255501258,-1640320582,-284447325,998163654,-1325449206,762969400,-945656937,769836416,-236552385,-952868259,1466223063,1405559209,-1775832264,-1215409390,319099770,1224645232,1936781559,896505382,1898670205,1963443116,1710445128,828602540,1197643924,541989241,431943422,-1118315661,-1723139878,-242094994,-2098155365,-1109473232,-286355183,236680961,-16081337,1089168894,1918768504,-626526813,711196482,-1640622983,-893425056,-721548148,770820263,-1151208350,1183713084,-1452287284,-799828165,2048015757,1400682175,-346436571,-1003735006,2130000407,186744692,-333639661,-1699838740,-1687387954,-1927712790,1155302234,-2000065107,1931877160,-781028657,777590420,-1914471619,-977946494,724420951,-1468413857,1494161395,1096894789,-1770162982,472211895,949116472,-1319400045,-1329497845,-1334636823,523471664,946599419,499503803,-1563418162,-141557996,1675982487,-1886202041,-1997226549,1452856132,-190373599,53804192,1330733119,1817272136,1035396146,-408559889,2125226847,2139165817,461489057,-226520101,-322793769,-1401890702,-1531466609,-432997901,59172374,-728887103,-238093501,-126803987,-554543269,-1782326629,1332554788,553021057,1373620299,1153179656,-1604222865,-1542077226,-1354136380,-1413658046,-1472195772,153422643,-276457898,2087059976,-1076533250,402666108,-807930181,-296169776,-1814096163,1350355360,-1493664503,-994391082,96161514,-2074937686,1306707465,500924727,141249467,-171274458,1011692869,-1652801901,1533666248,1544626018,-38721792,44804120,1759948886,-847561800,1233065592,1449256333,-944928400,1520003719,1897866317,242596298,2059872732,1506512553,-1106544025,219482657,662138514,-1792224520,291624051,-494554222,599545830,-1855013522,1523820837,-898164522,1871770025,-652414354,960882470,319030079,1642603939,2145779690,-981577645,177987597,-1475865930,-62908769,1614381334,1236087849,-877128354,1718898336,-535266760,1637375895,-1235769591,-1343149532,-846817078,1064330383,-1802576261,266220585,-1978349073,-1501797442,1982450157,1605622679,790338775,1305650952,-913892050,-956256715,-578201086,459786621,-46259025,137492773,-168292184,725072319,-553886500);
/*FRC*/Random.twister.import_mti(193); void (makeScript(14));
/*FRC*/count=337; tryItOut("\"use strict\"; \"use asm\"; mathy4 = (function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var imul = stdlib.Math.imul;\n  var Infinity = stdlib.Infinity;\n  var ff = foreign.ff;\n  function f(i0, i1)\n  {\n    i0 = i0|0;\n    i1 = i1|0;\n    var i2 = 0;\n    {\n      {\n        i2 = (((-0xa0712*(i1))>>>(((((0xfa29adc5)*-0xe787c)>>>((0xfbbe1d39)-(0xfa8cbbd9)-(0x5b083254))) >= (((/*FFI*/ff(((16383.0)))|0))>>>((0x4d237ad7) % (0x6ba5f35b))))-((abs((((0x2aec9f41)) & ((0xe9bcb740))))|0) <= (imul((i2), (i1))|0))-(i2))));\n      }\n    }\n    return +((Infinity));\n  }\n  return f; })(this, {ff: (void version(185))}, new ArrayBuffer(4096)); testMathyFunction(mathy4, [-0x100000000, -Number.MIN_VALUE, -1/0, 1/0, 0x07fffffff, 42, Number.MIN_VALUE, -0x080000001, Number.MAX_VALUE, -0x07fffffff, 0x100000000, -Number.MAX_VALUE, 0, 0x080000000, 0/0, 0x0ffffffff, 0x100000001, 0x100000001, 0x080000001, Math.PI, -0, -0x080000000, 1, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(413); void (makeScript(14));
/*FRC*/count=338; tryItOut("\"use strict\"; const b, jrcofg, {x: [{c: arguments}, [e], ], x} = new Function(NaN), x =  /* Comment */eval, x = x, a;/* no regression tests found */");
/*FRC*/Random.twister.import_mta(-83833589,-1370447071,-874698569,-922530121,-252167953,-1826905678,-1340177021,-1044184645,-622825595,-1849303958,2094272672,-1099028665,927116850,212152539,2115885107,-1252784703,88085932,-1475679737,-1209438827,2132635728,-251107293,-794849390,113446274,121730763,624784256,-1469792626,1461283530,653068589,2046124060,-1636399216,220134166,1437244272,-996023542,-1166309820,-1300406834,-1675471659,1739425480,891747008,1406827190,-2035915351,-237587657,-1015162142,2040385971,-239484198,-203915978,667896557,-1391710315,1194745646,705769114,259404530,352623683,-471730254,-831962730,-1596447504,1908693314,320686731,1379796117,2002236980,101223430,-1067430715,1344297729,1027731172,-643446469,-1566110671,-1153158479,1772465268,-1087747497,-204167523,-1064149532,1522001270,1658803941,1293345775,100950715,1616660326,-2115042168,-686159063,533477584,1718300719,-1140954115,-1408088070,-988637750,-1496503927,1732774294,-531659431,-367344629,877294702,1950798888,-1949989572,-768204729,558304506,-1647680945,-662665537,1167466120,-764778004,28728003,1538660070,-1956438292,-409931396,-404558455,-731552352,-525263152,-862032057,1707130087,-1282766231,1090839084,1689383460,170479639,1475085326,-75733474,169585329,-992149778,-885569360,-502196987,2089412709,1464185689,2030250233,1274321287,-471811766,2028469261,-223757988,269081519,-2050316626,2090277107,1626904809,-1513868674,891571229,-1035118813,-509509885,-1093765073,-994670450,-634460603,-601364591,-782882546,392864378,1358979846,1856583968,337264783,1625617351,-2024440437,-1632164018,-115228390,-781340789,1636700154,-1669968512,-835889415,1959216280,-1212895559,408450367,-1159644701,-1081333518,1506934913,-1724041587,930167974,1302460556,1933568168,464740130,-1953166772,-1501519016,-167107749,1278800916,1891409883,389536795,1576234179,-1979277269,-395366900,-1733587112,1769300999,-1487572595,1496938682,-1622826,-2096765491,-379084120,1997524720,-1168163909,-1682596643,-1456373380,124165724,-332888581,-2118784038,1568599837,473526582,2008723671,-721134317,-288140024,1834375792,1114432021,-631608067,431480249,-421158589,-2016822386,-582021328,514620163,-1848671345,919844399,575609760,1856504554,-706718510,-852177024,2131837905,-840966123,-1562375034,-1681235287,-869572167,-2110851137,-1437965170,-1944550378,448345924,-666100450,-1731054690,-373261542,1155137594,-734309962,355672052,-923912284,709024060,-2109117015,1126001989,-2006682747,-7849866,126844117,1203536327,406691169,1477411871,1962894675,1380527638,1998971619,-156449316,1102064322,-1728851518,1624398514,-901932182,-1225718528,340656279,2079756136,4310717,604415193,-646432631,814728199,366248480,333550682,474913413,31960352,339616995,-356149823,571139481,32070745,-1560860162,1409483050,-1935457689,-1889142693,-1790006537,717578878,2037241663,-288535297,765828824,-1450764093,-2098473552,26252788,-808325568,-1350171462,-2125722465,1361284736,340101516,-613577232,-526974572,-1128270612,231463553,26188978,-983752682,-2048178743,1583580419,-560254436,1195170549,-468934704,1448002839,-1273810515,-812671209,-1350946537,-111521863,-843351701,2101358899,1940966301,1789217216,632452248,-1381548299,1266062476,271280997,-1403979763,1970590934,-434975330,1246581853,-355586043,-732762318,-1444555621,975521337,982273853,34973161,1248745474,-641158842,-2090394318,1211860150,1314967405,1920062316,2064805465,1875075089,-1630258095,353264558,573568316,840529818,-2085641947,694312030,-798784511,874163720,1246522752,-1946591874,-1114559350,-1866936331,1513372444,-215736397,-1446601665,-1276313108,-1623965896,24858374,994353918,-1417602756,-966974779,2022120384,77970599,-1232509370,-685309743,-1946085146,1016355295,-2848942,-518233216,166469181,255406824,-2045023483,-1705754322,-394910727,93936782,-1922132212,1670750850,-1756080936,-1091767119,1171844800,-1466542352,641389580,-873138631,1842497146,-208991485,1483284517,-256857724,989350432,164563183,1678899071,-1151016070,-246483320,-1799097130,908406213,-1014616759,-1698091633,-1144335926,763591424,2103090684,265048424,547327307,-698155220,-818547976,1797741169,-24450350,-1712565654,-1049545588,1143251684,852858419,-814390798,-96119555,328760214,298715885,763409626,-947231895,-836360088,1545630103,-467674509,-206952319,1911762329,200714146,745035676,722456729,-1442409041,-1251977306,-1657540903,-890884980,-1676521102,1797145190,1518547558,1640543356,-957377708,1716912793,2002861700,-2138430989,-1554006343,-1100770665,-15207878,-2000044484,-1005156011,-2125625561,1004320095,-454718600,-1122791260,821182960,2061245523,-917492309,1764533840,1908096312,-1695105777,1811347669,-1536635108,1020378063,-1233959932,1590253626,1398995097,1349479352,910754741,1871257751,787936771,-9521153,2061011952,-782661607,761439837,-1894644614,865276806,-1375553708,1865853893,1562666657,-682539581,1985959312,-1266738823,1554358335,-2105037014,-1343579424,-1642113692,-1950787972,2027678808,-1314408079,948917134,-191151638,1548244316,238946426,1011011673,-121680709,1850256960,-204199177,1302725429,-1001034504,1493276308,-1153262200,-369236271,-958206955,827480166,1491827962,54425951,-667865553,2062139585,923255006,-292892840,-1285980708,1939089061,627150905,-1245911250,1091558210,2094411554,1196773545,1805015583,1829207410,1236531995,-270253575,-1680730819,1685049781,-825963417,-908378945,1114184242,1337164489,1341469975,-2021955062,-1365856990,-2105103306,-500153123,-943670422,860737325,-1993764987,-1560379292,1361479724,-342655066,-1842161728,1666531571,163804258,148836665,-1410548187,1730356833,1275224216,857120724,1242032651,901138363,250057549,1850410684,-1228699103,1216754505,-357930831,1658379130,291681866,-850886900,862381449,-1778091338,2070348487,252434498,888056454,1488112990,2087058425,-199933412,2122887322,1337677291,-1662157606,-1371267534,-1574773541,-1526222922,-1880040065,1211399082,-1574221680,262388838,-1052873773,-1694653657,-1963761864,1755686691,-957923780,1167680302,-1150619643,843642335,188501082,1499198697,1712344163,501788642,-567805857,-374266584,1294138035,1844899895,-1927864649,-1238618176,-1238830,567768250,1985423470,-341599921,-1010860564,1277799582,450526763,1182276562,-1264575213,685691658,467953826,-1582740259,-986595135,640829949,-1638223445,1653457676,-1475091276,-1534274898,-1457260555,837420197,-1412232496,120203710,627840705,-1657130999,-1315116196,152138761,553650409,-157850921,-666947087,1971717871,-2014636566,-485810483,812524380,-663268855,1431514806,-356857719,-101078977,1621266587,320774574,759620930,-1236839240,-412605863,-1123431872,-727302158,809414301,-1691871811,170377205,-617481309,-1945116191,-1902761383,607287457,-458408413,924747188,47819567,649199334,2019964838,1147203204,1997358728,-349161918,1422245003,281117347,-1071471169,-1222513748,297172136,-954044275,-2056005354,176227352,265051662,1351512682,-609944921,1233697464,1836158468,1090657599,1373784626,-1777312154,1320589842,577193230);
/*FRC*/Random.twister.import_mti(28); void (makeScript(14));
/*FRC*/count=339; tryItOut("\"use strict\"; v0 = a2.length;\nfor (var v of s0) { try { o2.i0.next(); } catch(e0) { } try { a2 = a2.slice(NaN, NaN); } catch(e1) { } Object.defineProperty(this, \"this.v0\", { configurable: true, enumerable: false,  get: function() {  return 0; } }); }\n");
/*FRC*/Random.twister.import_mti(186); void (makeScript(14));
/*FRC*/count=340; tryItOut("mathy2 = (function(x, y) { \"use strict\"; return (Math.fround(Math.fround((Math.fround(mathy1(( + ( ~ ( + ( + Math.cos(( + (-0 * 0x100000001))))))), ((((((( + Math.min(y, y)) >>> 0) << ((( ! (y | 0)) >>> 0) >>> 0)) >>> 0) | 0) >> ((((y >>> 0) % (Math.fround(mathy1(Math.fround(x), Math.fround(x))) | 0)) | 0) | 0)) | 0))) ** Math.fround(( + Math.atan2(( + Math.atan(x)), ( + ( + (Math.sign((( + Math.min(( + -Number.MIN_VALUE), ( + x))) >>> 0)) >>> 0))))))))) & Math.atan2(( + ( + (Math.log((((x >>> 0) || Math.min(y, x)) >>> 0)) | 0))), (Math.trunc(((((Math.cosh(x) | 0) < ( + ( + x))) | 0) | 0)) | 0))); }); testMathyFunction(mathy2, [-0, -0x080000001, 0, 0x07fffffff, -Number.MAX_VALUE, -0x0ffffffff, 0x080000000, -0x100000000, 0x100000001, 42, 1, 0/0, -0x07fffffff, -1/0, 1/0, Number.MIN_VALUE, 0x080000001, -Number.MIN_VALUE, Number.MAX_VALUE, -0x080000000, 0x100000001, 0x0ffffffff, Math.PI, 0x100000000]); ");
/*FRC*/Random.twister.import_mti(580); void (makeScript(14));
/*FRC*/count=341; tryItOut("p0.toString = f1;");
/*FRC*/Random.twister.import_mti(593); void (makeScript(14));
/*FRC*/count=342; tryItOut("\"use asm\"; ");
/*FRC*/Random.twister.import_mti(600); void (makeScript(14));
/*FRC*/count=343; tryItOut("\"use strict\"; mathy2 = (function(x, y) { return ( + Math.min(Math.atan2(Math.fround(( + mathy0(-0x100000000, (Math.min(Math.acosh((Math.min((0/0 >>> 0), x) ? -Number.MAX_VALUE : y)), mathy0((y >>> 0), ( ~ x))) >>> 0)))), ( + ((( - x) < (Math.fround(Math.min(Math.fround(y), -0x0ffffffff)) | 0)) | 0))), (Math.sinh(Math.fround((Math.fround(( + Math.max(( + x), ( + ((Math.min(x, Math.fround(x)) | 0) > (( ~ (0x100000001 | 0)) | 0)))))) !== Math.fround(( + mathy0(((y ? Math.fround(( ~ x)) : y) >>> 0), ( + mathy0((( + ( - y)) | 0), x)))))))) >>> 0))); }); testMathyFunction(mathy2, [Math.PI, Number.MIN_VALUE, -Number.MIN_VALUE, 0/0, 0x100000000, -Number.MAX_VALUE, 0x07fffffff, 0x100000001, Number.MAX_VALUE, 0x080000000, -0, 1/0, 42, -0x100000000, 0x0ffffffff, -0x07fffffff, 0x100000001, -1/0, -0x080000001, 1, 0, 0x080000001, -0x080000000, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mta(-1468603434,-1954080256,2097362551,1110118929,-135380402,1041236004,1897958974,812518984,-911251182,1169603855,1657939972,-424491075,-1347917502,-589676395,1257414548,730639494,-55117596,1477098266,343425277,98847698,1419672582,-183319867,-1000254592,1107050841,1146959103,1573238480,-436792098,302794253,-262802377,1012397691,-74660447,254957528,-768620712,1789771105,2031824353,484468897,1203182529,-21202792,-335226981,1436348477,1025199438,1732376364,-1758037107,-403477505,1096172501,-145405107,-767781146,763872451,-215983981,-809325662,1070527395,1534488722,-1462542653,380273377,1666334573,-38686304,-83998,1510330519,41552693,417692558,-666756249,-2071458780,-1867494851,-946548520,-1394345963,-59484875,-672849073,-1899765334,-570257561,-604816120,-1696444143,800482988,1898051825,2082581862,-1244600862,611337847,-952478278,-851149254,-1175625212,-111452200,-1375603282,-1117730644,1626623692,-1368602392,362199294,1976983299,-2103859052,1585778142,-769316277,1977468197,847792362,1367785577,-1608729741,2066554330,2096989023,-299700016,-503664770,-1985181976,1676789426,2022153809,1420507481,-1932801843,-858811021,1402269378,2019496729,-1448452241,621908298,1408578995,1791422374,1793608766,-1892561687,-1965498073,-164695385,2145523327,-1762672342,720799402,1251434082,-361720165,230323752,-1983999914,2122361006,324435642,-671331279,1566133460,1601694219,376046972,1274729349,1667769214,-307521224,-1137985449,1429212039,1728620769,-1970586898,-1300393308,-1113078872,-73386053,1872623360,-549753548,-198089822,1322784082,-92132544,698151700,1747675811,-470371263,-1539024365,1801700011,-1744408333,-376513511,-758052146,1137549151,1786458955,2054154985,1351078952,-767791845,-832122243,1239624120,1234841479,-1535788384,-759404775,-1987564488,-1988675984,374884963,1496981515,1376116475,-770738681,-1891647024,582085805,-938447117,-1764726370,-379566436,-547300476,2091765446,-1588905021,1239961272,-452711454,1252145959,-1910703413,-1236428998,797505184,2073738868,624885086,1350664347,1191676376,-1361281231,-311562397,1587498536,741013052,-891752219,1358593129,1138844378,1612306918,1988580161,2137563528,-981355998,124432360,-1311227948,1824380981,1035070100,870883636,-538563558,-253757142,464535072,-285126988,1476172136,1623047405,893037572,1749475339,996433735,-1613755441,917027990,987507320,-1967445435,-1823018882,1150750774,1594783366,2113265515,-1749316347,1879589429,-1975419681,1634863771,-593574697,-662766380,-495640759,2026298681,881467336,1977678076,1119834223,-1542517961,-68274343,1478360002,424906897,616690394,65750928,-402072129,-1150948101,2082194825,-2063994925,1748527380,-280883824,948409567,-601254395,-639288006,-2014914887,884685559,-1040800279,84136962,1877330759,-876122646,732466743,399423012,345960550,-505188417,-206856080,-1289364558,-1614316877,-1323294993,2090843265,-597413247,1492211077,193032648,37517857,1933175079,827764313,939301643,-1595702546,870943236,1432043108,532012357,-1128471273,1628375507,-927010063,-1145004432,-984415067,538133682,-1366889270,233777095,24577014,-630496096,-1532789512,1333524101,-1233496080,1442880397,-278361108,1881512007,1069456081,-1821962664,-1748650153,-1560776436,-1216255253,1822314700,1811642373,-959803508,831393703,335491212,177043179,1174465868,-20705015,-1241118286,1845880885,356268714,-1038517745,-1930949548,-2131639932,1775457645,1529270477,-211135533,-397630138,-1223864733,633317601,876962019,525711927,1335619578,1357932995,-2023422421,5086107,57802094,415750315,-1844250644,-1670562135,-102089851,884408902,1010836700,-209673809,-197516320,1938466645,531778386,-471994147,1341098618,2119235706,-1966139136,-1797885198,1203065008,-651923793,-118542709,1416211655,-255595781,667053225,1644326346,-938193056,-258361055,237553470,-1656362170,-326611923,679160066,-29639197,1588010030,894196629,141134739,-1281668124,583036156,1694570518,34328347,-1954205228,-520447771,2128237251,-1794317700,-162905540,-1758843462,-540864870,1592204534,-275187135,-345604568,-988972731,1752948660,1450974030,-553640908,692251694,370751143,383354493,618480534,-2092028409,-967439519,-352208531,-1078149110,228902584,-1692584187,-769512714,2092656934,-1063097470,932495388,623174927,1700892571,-1455518425,-1469380204,-1584469647,-997700393,84374699,92064888,1290297776,-1901369416,930531517,-1677304130,-89071389,267416990,-118213427,-1247305676,54785807,-456112954,-438276384,1777095744,-1882114260,-1701850369,247915577,1964969662,1877206134,-345105200,1239972808,2075604236,150511715,-480168146,326949179,-1711555509,1715654836,-1202120604,640367696,1120803815,-2071916574,2065726436,434372444,-808358629,-306837506,-2058969363,521412416,-489810965,-1693580876,1317332172,1849841865,1063656155,473512989,-1228355721,1090372290,-1909564976,-2103431285,-622398923,1078719887,484915116,-1041048490,1000340973,-582064331,-598123828,21740296,593723562,-64048372,-872667966,1246094016,-463120783,1718423206,1538726948,2099898966,-1789835159,-668698467,-883839347,1472876160,775920421,-1179761165,370701550,-1570489065,1106951330,146033831,-1686320160,1561918071,1595522116,1738024422,-1279489921,831838202,260091421,-1287656420,-956832366,-1184706405,-1181892312,-1910955396,1832204345,864053947,-768309739,1698561481,-11979658,-51253727,-1426839926,470171967,-1835061911,234138121,557142247,-1298289686,735373840,-1658362726,-1327380684,1751198845,-1030607512,-291135942,1613360747,1601167133,-1792393923,2062606820,-1107743038,458516340,568057172,-302914018,573034782,-1648251332,-589804721,-1676148376,760577992,-1818992962,911376552,1476530543,1508431235,-484019710,-954844595,1588707496,-909331350,-1331799460,884778890,2010922980,-1874830474,-1198578609,-1680339900,-878436881,1374804235,-1181820991,-1889856115,495554273,1571781106,-1910950914,-1404582190,1761007570,169858528,69836514,-2050448324,897550690,1418174664,749402865,-1233341565,-803615539,-1971317551,867206846,-443325743,836454094,-1427050340,-442795756,1577336370,830360283,1955924239,-51891992,-1221324689,227657832,-948229815,-2044938260,1683798043,124498155,1599725015,-1780114154,362705178,-1948793704,-1058931404,-860408788,708809215,-2026033839,487220291,-1138425841,322304654,1858782849,623856961,-456517471,1971586558,-1348786449,166329837,-445629367,1304286177,385569017,2065556726,1890933932,599504696,-684742523,-1760601567,-42032204,1347483724,557180425,-1920194641,1513938613,1052125199,-1974267970,-762345896,1895335612,521386670,-1633321619,-916423621,1170519722,86268850,-1243440376,-1352767812,-1452525531,-1025466033,52130577,-1647140576,-921274744,-929422450,-271790311,672137673,-1646704197,1936055333,-1394327687,832036203,-1188216761,-375092814,1227059719,868746520,-1493388910,-1673722097,1056012877,-505040013,317882637,-482933254,-2117546277,48323500,758904141,-130896836,-361809180,30281663,630186238,-767441414,83385005,-1615889980,-1533803853,393774820);
/*FRC*/Random.twister.import_mti(351); void (makeScript(14));
/*FRC*/count=344; tryItOut("mathy3 = (function(x, y) { \"use strict\"; return (( - ((((Math.log10(Math.pow(Math.ceil(y), y)) | 0) > (Math.fround(Math.max((Math.fround(mathy1(Math.fround(Math.expm1(y)), ( + (( + Math.atanh(x)) === ( + x))))) >>> 0), ( + ( + y)))) | 0)) | 0) | 0)) | 0); }); testMathyFunction(mathy3, [0x080000000, 0x0ffffffff, -0x080000000, -Number.MAX_VALUE, Number.MAX_VALUE, -Number.MIN_VALUE, Math.PI, Number.MIN_VALUE, 0x100000001, -0, -1/0, 0x07fffffff, 0x100000000, 0/0, 0x080000001, -0x080000001, -0x100000000, 0, 42, 0x100000001, -0x07fffffff, 1, 1/0, -0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(546); void (makeScript(14));
/*FRC*/count=345; tryItOut("mathy0 = (function(x, y) { return (Math.max((( + Math.min(Math.fround(( + ( ~ Math.min((y | 0), (y | 0))))), Math.fround(Math.tan(( - Math.atan2((x | 0), y)))))) | 0), ((Math.min(( + Math.asin(( + Math.max((( ~ (Math.PI >>> 0)) >>> 0), (x | 0))))), x) < Math.sinh(((Math.acos(( + 0x07fffffff)) | 0) | 0))) | 0)) | 0); }); testMathyFunction(mathy0, [-0x080000001, Number.MIN_VALUE, -0x100000000, 1/0, 0/0, -Number.MIN_VALUE, 0x080000000, -0x0ffffffff, 0x080000001, 1, Math.PI, -0x080000000, 0x100000001, 0x100000000, 0x07fffffff, -Number.MAX_VALUE, -1/0, Number.MAX_VALUE, -0x07fffffff, -0, 42, 0, 0x0ffffffff, 0x100000001]); ");
/*FRC*/Random.twister.import_mta(-1592538682,40453380,-772706921,-1272572405,-980954387,911647526,1831340442,1261719807,280883848,2021748682,-773396979,1596757186,335849403,1980077809,-1942099448,1478077638,-732150295,-1256215311,1077689870,-1362218527,-660493735,2077447836,908590440,1452289374,-1415297659,770676015,851476530,975981424,-1985499346,-896759098,2029990199,892264369,1519823128,-445061907,425123167,947065524,-440873351,-1354682723,-282984595,-545293583,138348155,1339943468,917004268,-119002563,-2118019629,-1791952769,70743676,-354582954,-2088500320,-1602041944,1980507245,-263653912,1192016326,1887819764,-175540643,674567537,-634010703,563867830,443205929,390955131,62831280,-639313562,-122248308,-1839090014,-1205131775,-1788738402,-186812246,-946003818,1652109465,1732670539,-1859332412,419077180,-2019747941,-1796124531,-1509577763,270352486,-1265190648,969624779,-2082169958,-1410263818,-196853028,1820091993,-2052503267,1195374198,-2099851335,-1278115936,1150708991,758989152,1393005945,1898252296,1935277443,1738765148,499081350,-132534675,-1573173931,168670811,-114332234,1789690925,-2070895965,1588382317,-1119189593,1655624794,-1257096146,960444475,-1601642336,-1055091173,-2036290898,1835099836,1822225308,2109088937,460519937,-1129445084,792006538,-1142310199,1640490207,1385664725,1014014180,-28172453,-1626913681,-1260107336,1482352214,192430342,-503860249,-1422210245,1452964684,854387427,-1644963987,1579359054,-855459564,-138859522,793002131,809112597,230255002,1920539429,1386485889,-1479067827,-1524784565,1235761007,-2097190792,211440494,-29456106,1216773274,-151530291,-95103219,-1741924219,1776531534,1526451900,1694059791,1066751545,707370646,-1067188816,791173887,-280011899,1809728759,1903158726,907174788,-757391260,1021425535,1861978083,-1014581655,-819007059,162570453,-1556110036,-557462179,1655745961,748314152,-930839976,-453832160,2103041699,-1967107701,871052418,-1621721657,535413674,1110919517,-538830220,1227449663,-869690948,-1430595356,1839048566,866818214,1019500349,2042567257,-1328502968,1710049488,-1111482036,1726872994,-1552453117,1875964806,-393163434,1976064601,-1485880627,-1974023220,-1918976083,-354848815,-636698971,-330485804,-2096475030,-790485486,-412535421,-1750912116,1707613913,-1436946719,412848273,95572432,722111337,335970461,1830688462,-540817601,1755077459,-1148017490,6824690,2002387570,-2085733528,1031125582,1153784464,320714886,-470955415,-1324090371,293804462,1562962000,1844539861,-843194491,925506489,515724617,-1520499270,482548315,-1669876832,1173119669,1852291301,1146098944,-1505300634,-999132891,-1688568538,-1450029256,-1406074140,-1949715010,211639104,-431497019,-1704464782,-1558651802,452397164,1455829387,-1689484958,1840228290,-140622096,-288986254,-1959950572,343760285,1882459534,1013482843,-9885090,-764308035,1954380022,-466907724,-72026920,1860223409,2109088601,-1919997142,820930389,-1031789353,1173135521,-1728759124,-1165627410,-171372786,-155849825,-980656033,1236083852,-1888893905,-1504518630,-1946184117,-1526176507,2053154654,-986097114,326369305,891444586,-2092989861,-1917356552,610114065,251510389,1546752574,-2104677651,-1036176469,-919639667,1558330886,673740698,-931093923,1177663741,-1049182438,-1347686144,1413721937,-1325076124,2045022477,-1667392296,1754493696,-459450832,-1005352766,1011183762,2133234177,308576617,1066998339,-763013465,-427996385,-33793521,876977,-1720265219,-138229447,1769931544,1066608243,-279550217,319497433,1626472843,866536327,694897770,-1648881171,746962903,-965948941,2016179198,-1536699896,-2107711935,1206182309,-432423933,49522013,1880139691,434278083,1702207876,745990674,962269008,-2107442790,1741248730,-8845993,1524994147,353527592,610513281,1973210130,-871881954,-1502251753,1287066188,1064885681,1575642475,1747020821,-1253355670,-1903463914,111805524,-1704603958,-1862168244,480893306,702037166,1100432292,1511552888,-747159572,859282537,1398334374,-610724274,2073448147,1420126832,-1238919158,-1137951453,1084606430,1598659182,-1552047003,130688049,-1456859908,-739583849,-1910263828,1713912181,-698474897,-1633781534,1817901815,1525210449,1851290385,7823970,1956918508,910022731,472493536,-260086190,1451508546,1416899077,-533542799,1960983281,1691720157,-1067043867,-50850934,1646782286,454353923,-944954933,-1250914967,-1053241259,-379928203,249893641,1636594093,-792272382,-2032112377,1801610471,1844848865,-1105149382,-1510959621,-1196919832,1092289522,-341813273,402741308,-1770516227,25811127,1940316768,-69704825,-1626483060,157915794,242287136,-1582254125,1208975822,1617328906,-266852822,-824096490,2059497872,-261952469,-675328342,-355448153,140011435,-1415660189,884395422,-79315886,829591672,-1786334971,1143117566,-829598544,-1214229388,1228974392,286821950,-220450808,674577797,2028302832,44399928,-212718477,-528660136,-1808573226,-776971031,1214592376,2136337031,-1211653705,427208468,-1022630164,751073819,2060583702,1994631911,-2033239287,438951962,1656069885,1894999618,1399162110,1579010926,-1037002968,-501402928,-826662150,-1831573738,430449030,249583810,-430106959,615336785,991197674,-909372203,1826533570,-2044817126,-1610805225,186597726,1415000253,2022639380,-2080892804,-1067241809,-548482818,167825695,-599781284,-2109895935,2002174834,1590991015,1622919471,735692710,-1757132223,1762825758,677558814,1110881238,-1416651475,1840878872,-486923987,990557369,1931841812,-704657232,-573161036,-473353629,851341244,1911127366,205172927,1716822351,-1949459603,-613353666,67573558,-1618728315,-1867895531,-622035260,-1410813413,-1929104858,-1959437678,1172226045,1021866549,-669597169,952028560,-1851703281,1064208244,-1498267705,-304756039,-421828194,-1855961949,113012163,331769960,-1063219226,-2088855035,-1936017096,1399934760,-1514933493,885729883,-1488868588,1263659895,1178914809,-476983345,-1842320469,1212029819,2049538289,275795480,1031620701,-2009427434,-868312197,1923192744,-2110027601,1752335172,730493838,816267335,-1806555196,-1212430960,108223639,306167041,1554273438,-1461921320,1056581045,317826979,83783963,1055168458,517142131,-1051687497,-1396568713,2089079977,-1269302423,2061658400,1395504718,1620984776,1275466888,1593873734,1316323770,-44073299,687114153,-570449733,1552456303,-1978768866,-33301907,1734713233,-591955992,-1032703516,-494627944,-161821808,-1745406662,658397129,-1291485075,1055959554,-1950870186,597620177,-836320075,1466396020,700399490,-745917277,1287232740,-954121236,-720681090,-558853743,315723263,752429358,-1179761315,712389450,-1122154212,1034666299,-1578137156,490432949,-24827998,508851290,1985695636,-1095946206,-659075329,-99269722,135785264,-1274672638,-1554463958,-1751943584,-1809946079,-1186498776,-571804790,1977710254,576063387,-1444076583,-103363843,1738302008,-1279022459,102120988,1426225900,-1302980841,714041086,507639417,-201318209,1320000044,-716990613,2077396603,-1201420627,-1040117123,-1346334726,-1340671634,1646367747,1969386428,-296954231,-1474193653);
/*FRC*/Random.twister.import_mti(141); void (makeScript(14));
/*FRC*/count=346; tryItOut("s1 += s2;");
/*FRC*/Random.twister.import_mti(153); void (makeScript(14));
/*FRC*/count=347; tryItOut("{ void 0; assertJitStackInvariants(); } Object.defineProperty(this, \"v1\", { configurable: (x % 3 == 2), enumerable: (x % 39 == 19),  get: function() {  return g1.eval(\"/* no regression tests found */\"); } });");
/*FRC*/Random.twister.import_mti(194); void (makeScript(14));
/*FRC*/count=348; tryItOut("o0 = {};");
/*FRC*/Random.twister.import_mti(204); void (makeScript(14));
/*FRC*/count=349; tryItOut("\"use strict\"; /* no regression tests found */");
/*FRC*/Random.twister.import_mti(213); void (makeScript(14));
/*FRC*/count=350; tryItOut("/* no regression tests found */");
/*FRC*/Random.twister.import_mti(222); void (makeScript(14));
/*FRC*/count=351; tryItOut("\"use strict\"; testMathyFunction(mathy4, [-Number.MIN_VALUE, -0x07fffffff, -0x0ffffffff, 0x080000001, Math.PI, -0x100000000, -0, 0x100000000, -1/0, -0x080000001, 0x07fffffff, 1, -Number.MAX_VALUE, Number.MAX_VALUE, 1/0, 0, -0x080000000, 42, 0x080000000, Number.MIN_VALUE, 0/0, 0x100000001, 0x100000001, 0x0ffffffff]); ");
/*FRC*/Random.twister.import_mti(254); void (makeScript(14));
/*FRC*/count=352; tryItOut("\"use strict\"; mathy1 = (function(x, y) { \"use strict\"; return ( + ( ~ ( + ( + (( ! (((Math.fround(x) ^ Number.MIN_VALUE) << (Math.expm1(((( ~ (x >>> 0)) >>> 0) >>> 0)) >>> 0)) >>> 0)) >>> 0))))); }); ");
/*FRC*/Random.twister.import_mti(354); void (makeScript(14));
/*FRC*/count=353; tryItOut("\"use strict\"; mathy2 = (function(x, y) { return ( + ( ~ (Math.min(x, 0) - ( + Math.atanh(((Math.expm1((Math.fround(( + y)) >>> 0)) >>> 0) | 0)))))); }); testMathyFunction(mathy2, /*MARR*/[x, x, x, x, x, x, x, x, new Boolean(false)]); ");
/*FRC*/Random.twister.import_mti(480); void (makeScript(14));
/*FRC*/count=354; tryItOut("\"use strict\"; \"use asm\"; t2 = new Uint8ClampedArray(b0, 1, x);");
/*FRC*/Random.twister.import_mti(501); void (makeScript(14));
/*FRC*/count=355; tryItOut("\"use strict\"; v2 + '';");
/*FRC*/Random.twister.import_mti(510); void (makeScript(14));
/*FRC*/count=356; tryItOut("\"use strict\"; mathy1 = (function(x, y) { return ((( + ( ! ( + Math.atan2(Math.sqrt(((y | 0) & (( + ((Math.cos(x) | 0) >> ( + x))) | 0))), Math.abs((( - (-Number.MAX_VALUE | 0)) | 0)))))) < (Math.sign(Math.fround(Math.atan2(Math.fround((((y >>> 0) && -0) != (( ~ (x >>> 0)) >>> 0))), mathy0((y | 0), Math.asin(( ~ ( + x))))))) >>> 0)) >>> 0); }); testMathyFunction(mathy1, [-0x0ffffffff, 0x07fffffff, 0x100000000, 0/0, Number.MAX_VALUE, 42, 0x080000000, 0x080000001, 0x100000001, 0x0ffffffff, -0x080000000, 0x100000001, -0x07fffffff, 1, -Number.MAX_VALUE, -0, 1/0, -Number.MIN_VALUE, Math.PI, -0x100000000, -1/0, Number.MIN_VALUE, 0, -0x080000001]); ");
/*FRC*/Random.twister.import_mta(3121520,1515213299,-618994714,1840466260,1520601380,1160963757,1196096295,-1756155960,891891063,-1081425415,-836305486,-620404020,-1033109331,-167324882,-1561485451,-907549765,870681228,-1214164563,1690296968,-50331048,-696838611,799355690,-804410627,-1113062811,1517931341,1564661479,-744787704,-1284275229,738651227,-194009478,1900277519,92170505,-749620391,-687430840,-278158039,1269407419,1520139079,1059591040,-1093519137,-1572677275,-1876339551,35815650,1719092013,-181665747,-1455239178,888672729,-1281260510,1542185418,854916393,-1828862805,1799486986,1033607053,-93160238,1104230689,61347997,650524177,1231411677,-1696756599,1962108499,628233737,400954713,-1248377581,636382099,1124315845,-716434856,1903295755,932815094,-1866780793,693342854,-923449907,-1825333536,-1866012147,254806213,1211625008,1062757185,1151321123,-1521033323,707496555,-1027817414,321959792,-950781459,-638933113,-938449386,-170245605,-1156407555,-1068944871,1706766756,1702146771,-448477776,1131248765,24106514,2134297861,-1455499434,-1371425990,1472458911,-404274715,-396761601,80005899,1727330556,1564576968,-624961482,-1752355791,1319269968,1436209069,-982611481,-1689872552,1309572814,-1477494335,-1732434433,839119384,-209531349,-1321079205,362555672,-279498893,-1551560483,-560406636,626992503,1511107536,151219188,-912359392,829885144,246596152,-2017182155,755626591,1676610145,96547010,657430236,1554523259,1806490599,-203958069,154085571,-891146314,-761943323,845231152,-493770691,-536079756,-847516881,-1792175112,-235475929,963385372,1987871564,-19460569,1291715201,-337331928,1711307652,696489541,-1785691758,-1743721040,-733721860,-1930169425,-1307031287,452519540,-1777992828,1805272237,2073522698,1701545146,-1736901082,-536808812,1167365446,-697610336,3096590,1293371641,2086941807,374553702,1898492037,-118147388,-1341409036,86035478,1781683082,-838684805,-1315055115,-51289672,-2031894925,-1538713492,-570230895,-399373205,37355782,1601301561,-899712784,-875362395,1660321311,-849144614,-1404684807,204578137,1605359615,824003715,1570654857,-1990905929,-565748536,726702085,1477446739,558024875,-231705747,-2108317671,-930371640,-1724750646,-1838919505,-492060370,-2649148,1219787929,464990671,1096487606,-1147248704,1365706465,-420837825,349768956,520384665,345003915,2052403311,-201868292,1035681573,1423271768,-320026064,149801910,399452730,1560180052,-1892886771,-1652417604,1430714963,395562648,2111262048,1834824441,641786645,1888360158,-1576317362,-529068199,1407129230,-1374368291,2021153651,-935750571,-1769815783,386906039,301711665,290617941,-759696105,1936163031,362905924,-2095773045,-1970729729,-1894284133,1148025652,-1353982012,-1087360934,137013748,-1061002220,556343554,775298121,-294842134,-1466318504,-273072174,1301837924,541554486,1867976765,-1371468956,1561023460,-1948955352,-223857681,-1338217350,-1120482371,682578902,-612614626,-1305914658,827136316,-1194770857,-991521936,-637228391,1023314861,-1023394900,-556401896,-1376009872,-2011409534,-1948359963,-464871158,-1456428393,-1015246792,1949255637,1507572092,-180907537,327376530,1648122235,-1178136533,-29942652,1219963154,1567744528,664104312,-1897723150,97077636,1077145049,1186865764,1030492961,-1493611876,-620569548,87573643,97979374,-223155226,2003905231,1852750866,50949771,369285107,-1082518711,-1576928416,-659620199,-1651391452,820315572,-926786008,-1241300554,-1779329898,1777842761,157779252,1633801740,1963054855,-1347995448,1469942320,-1427022192,-548772107,-1722614705,1365153145,-649590291,-2050224888,53131656,1982910795,-154987627,1914615387,-622643907,318750210,2052685652,1550905349,-1453624229,825826885,-1160245570,1595145273,1314382328,-1584860847,1745514305,1843213205,-18436903,-1263064033,1149193281,475654286,255430317,-1475176840,-523234569,-743819023,1843391953,340084589,502232483,-380296718,477835620,654925262,1196900574,77955980,1310949702,-519919756,226304996,1203497086,-1397590615,-1819985116,646702580,1112821083,142084130,653540942,309097641,-1491221118,661079882,654978064,-1095118762,-699804232,-1040163525,1358137200,1288025008,-776559778,-468310146,664223925,-1381027141,-212677615,1735847713,635578184,1365370030,-1315268027,792613545,367414632,176456109,-236370332,581361180,598738175,-1140830797,1003397061,-564823723,-455491344,1409762670,-869549510,-1651428823,1460048491,-1357129239,-825215436,912681598,-1366348158,491078361,-1326330458,349636306,2105885928,-405698911,1289129335,1304226368,465903984,-848823840,1107553427,116506360,-45078177,-1807079700,1799436754,584019767,-1876653495,910290396,1698019899,56876994,-1483245973,38496924,484447874,-1433846959,295585860,-1432687433,-1099641198,-910919019,-2046061134,-144976677,1910138013,-693821486,2099882574,-1160978084,-238641145,-1764482413,1589682839,-288035278,1889717559,-587762189,1897716728,1895852207,1968215086,596002786,897894973,-1246343274,-963553265,-1036507392,902849565,1832864114,1042353383,1389996247,1279621485,1464760957,399706019,-345932347,-1398595686,1420770031,70448730,-1289335292,-709646176,728529836,1633742806,318015932,-945536383,-1757915720,-1069242282,702939854,-2098657611,1940925303,-525275932,-1738169500,-2123638806,1730561285,1937885261,1990236312,-2005109430,1004208026,2093450517,-602895785,-74947875,1820533135,-1400370817,428595889,104114989,-1719223961,-1303935582,-665331785,-556315488,1440408147,1911579656,-477593411,758954590,-1687160508,606552894,-1453397777,-1744363262,-1439420880,308125177,-1281112966,1627859106,-828487023,-834351188,531451435,776741714,1988051424,678437149,-939284060,-1434398123,-1714228818,-1914827528,-894786332,797937162,-1830703316,1418909220,130361995,1448408879,1132729624,696994381,-848336066,-33474861,-1252417770,664967504,-1089301592,-1390977834,581070572,-1972987987,-898453323,187779463,-1850424574,-1150854590,1561724418,-1577175731,92582060,1155286038,-586717201,928534858,-1613199500,841635969,-749298784,-243877805,1532230984,-1144433628,-1847056331,981548446,1144909479,-2044676182,-952148321,1625881577,1252375404,-463445245,-183264224,-1951258875,1535667580,-357821223,888976454,1440298487,2068459736,251427794,-62132914,221212220,-1470168623,1263587575,1199680696,-2102390698,1132890209,-1612729301,-973773357,1062349193,1470263827,-978446954,681109137,-1079490570,-696896934,-1525143578,-1436641816,1985790745,-41238989,-1397318678,1096127420,1690820904,1847599155,-1200391855,828559700,454145907,-1033602545,-108434420,-1928618070,-514411082,1386449285,-538112985,431402399,1564888708,-1674550712,942792539,-765903952,-1011650171,-1841160160,-670869446,23062245,118229120,45164177,-1196057366,1231174000,-681604628,2071035651,-360133102,-1073614103,581948850,829685720,1815432615,1063743518,-1968751879,-1532037861,-1265723905,-2135382913,-615087963,-2006457169,984911543,1642107769,-1408271217,-1681130041,-979743074,-1088493387,-1783963593,1627319727,-75624156,-291963334);
/*FRC*/Random.twister.import_mti(149); void (makeScript(14));
/*FRC*/count=357; tryItOut("var dextmp = new ArrayBuffer(8); var dextmp_0 = new Uint8Array(dextmp); print(dextmp_0[0]); dextmp_0[0] = 10; var dextmp_1 = new Uint32Array(dextmp); print(dextmp_1[0]); var dextmp_2 = new Int16Array(dextmp); dextmp_2[0] = 10; e1.add(o1.m2);this;s2 + o1;");
/*FRC*/Random.twister.import_mti(237); void (makeScript(14));
/*FRC*/count=358; tryItOut("\"use strict\"; v1 = evalcx(\"a1.unshift(this.o1, p1, t2);\", g2);");
/*FRC*/Random.twister.import_mti(273); void (makeScript(14));
/*FRC*/count=359; tryItOut("testMathyFunction(mathy4, [1, 0x100000001, -Number.MIN_VALUE, -1/0, -0, -0x080000000, -0x100000000, -0x0ffffffff, 0, -Number.MAX_VALUE, 1/0, 0x100000001, Number.MIN_VALUE, 0x080000000, 0x07fffffff, 0x080000001, 0/0, -0x07fffffff, 42, Math.PI, -0x080000001, 0x0ffffffff, 0x100000000, Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mti(305); void (makeScript(14));
/*FRC*/count=360; tryItOut("Array.prototype.shift.call(a1);o2 = new Object;");
/*FRC*/Random.twister.import_mti(337); void (makeScript(14));
/*FRC*/count=361; tryItOut("mathy1 = (function(x, y) { return ((Math.pow((((Math.pow((x | 0), (y | 0)) | 0) >= ( + y)) >>> 0), (Math.cos(( ! ( - ( + ( ~ -Number.MAX_VALUE))))) >>> 0)) >>> 0) , ((Math.pow(0x100000000, Math.fround(Math.round(Math.fround(mathy0(x, x))))) == x) ? Math.atan(((0x100000001 ? Math.min(Math.atan2(( + (( + x) & ( + Math.PI))), y), ( + mathy0(( + Number.MAX_VALUE), ( + x)))) : Math.max(mathy0(y, x), y)) | 0)) : Math.cosh((( - ((((x | 0) >= (y | 0)) | 0) >>> 0)) >>> 0)))); }); testMathyFunction(mathy1, [-0x080000000, 42, -0x0ffffffff, -0x080000001, Number.MAX_VALUE, -Number.MAX_VALUE, 0, -0x100000000, Math.PI, 0x080000001, 0x0ffffffff, 0x100000001, 1/0, 0x100000001, 0x100000000, -0x07fffffff, 0x07fffffff, 0/0, -0, -1/0, Number.MIN_VALUE, -Number.MIN_VALUE, 0x080000000, 1]); ");
/*FRC*/Random.twister.import_mta(-1452942593,-1652769707,1645126264,1356071034,1547715880,-159694789,1175813540,-665254124,1269443011,621843018,1802702750,91134422,-280408197,-1556134217,-550228427,-908701937,-1264978475,392842111,1038343918,1436831138,1436152585,-1376881885,1834322620,-441836227,489895707,-1749453290,151325627,1224758080,-848558106,-1871502395,1293065097,-846609603,-783306504,528204364,1778933009,-360337429,-247404558,-154967673,350136734,-1610563209,806430942,-547125913,-2145847509,1629859270,1992488869,-549348834,-1345464347,-1247630762,-45540360,1266807778,-719531058,1903970052,-1364306382,-1894794446,1628100114,286868395,-1060549516,-414976596,949482975,1195905747,-1464899078,-1432393024,-1434591231,-318616659,1988631522,-611813331,-1196218926,-700395530,-826132146,-1456921708,1225680573,1610310487,1128116765,-182105806,-840447402,64989791,-137917840,1570366728,-1786195473,1093324532,-1719745901,-931120524,-93435037,-1028303732,1621790900,-1063641744,1944403457,-327864712,-1385894734,1900515073,1159419616,967037429,-867229479,-691139666,61208770,1965253410,1902050154,556261767,-1660747234,1280885945,475032662,-1458178940,-1402431198,-1779181698,1004276300,1333206650,1123845531,2144792693,-1059911518,756538162,184738582,1698798214,1010993226,-1671893355,1753826625,-1644964533,1854718192,755695543,-375379154,-1497713729,-1308557814,-1119340907,1889458776,99117369,541259405,-1712235325,2100171351,-1477471061,827826104,1727561468,2020020697,1371295968,1555311284,-325312297,-1392415019,-923986942,-716288376,-740712883,-1881106514,-901187083,-47134076,1153361339,-1541770079,1233191004,-906717862,-1930889373,-1959319481,181067415,-1781206428,610596696,-1200623846,-2135893305,-1219624971,-681071140,105477659,1508199140,189417874,1815490929,-679589218,1295568443,400299378,-328566241,1286091403,590149835,2147226371,-941987759,-2023423016,172687436,-374631055,73943475,1457542733,1708206096,-2074952084,1393683697,1196368642,927056794,1262156016,-1986451566,-1112235855,-1934332168,1217505886,2002310002,-294473945,-1378948013,1138912401,1313798551,279558318,-1904927790,-1643940520,1793964753,-1876985579,-44644371,1142031003,1551109311,-1631581739,327805197,-484982601,-1477930536,-66230154,-1814093640,572305354,-1518685430,-1193735457,2099411500,824047997,2080523905,1396795891,-2037514918,143139366,-1411357974,353223602,-1127129119,-522710848,-1083637534,-1362649387,1170758652,-962139791,-920698047,1781101621,-1830495681,879613028,1337102283,-2024152102,-2068887792,-1982997796,-1835951517,1620715531,1280395161,543737504,-1337494997,-2107937922,-843770513,1742392782,-163170320,954365856,1098574177,-1114462256,-1220593346,-605164732,-1920994591,-1264932523,-2136197608,-1916593163,-1795635233,1207884798,-1276092395,1653786071,30741413,-634196790,194623118,-175528282,-1282404390,-2137394268,1736483401,1290466772,758165198,-932375048,-1971237240,-1713476906,-51269641,1181707043,850317711,1877573663,-1825329590,46760980,-743875433,-2122261343,1601951058,-1986107937,-1005134102,-1111348117,82290464,315719562,-831283207,1455274339,-777730234,-401437750,-1663206265,-647308442,725970680,-267111056,89211547,1067561635,-754713912,-533565227,2054377757,-27700000,-1947174712,757191567,-1191099057,-2138888777,-1390638728,-647758374,-2115350495,888203854,-101357753,832906254,-620249701,-649143764,306007981,8029857,-2094061500,1538074757,-744053404,110642643,-546301020,-1395023089,-1647509495,-131018382,1508249663,-714684184,191124908,-706563528,-2058830428,970252416,1556289233,-991216856,134041700,2016841009,1851783331,1957114555,-475917520,-1051047581,941696107,470507053,708037315,-1040331189,-574336085,-1267076133,1525274593,-1294456958,-1307524549,-1569023739,-317018994,-642967866,58732146,-702493235,86906705,-69866225,676053878,1966626609,-1739265562,1913951100,-39398503,-1158285895,-586499113,-393794803,-1585164051,-1629251846,1925979038,586787226,281257271,-548418255,1593042536,683548320,2023031338,901614598,-1069185109,1434473713,1338914195,2091035228,-1097888748,-1688291417,-959752064,-863668634,-456884878,843081655,-1790375620,1658600547,-1933499122,998904803,53970399,53993185,1805057680,-528934440,-2027560512,215221519,967447271,1311195980,-1111566015,1261264341,1052628265,146154986,-2086995150,-348215433,328316323,-82132402,1706095882,-2039883608,1790832534,-185806592,-1921520919,1230976122,-536012606,1366832499,-18087376,-742238208,1318629534,800762745,-1164960744,-101605506,-1205021338,295679674,1188587592,-1356145822,1170073127,-1882410620,-281997778,1031651332,-1680722994,631368471,-755459734,359534457,-1153706644,-1882917837,348159666,734531487,-1636863404,1897589402,215819961,-802043333,-1040552292,-296000360,-1609430418,1162726250,501803751,-1198674095,1552448237,-1206074460,1496508931,-1354703942,-948627223,1265119640,-1307000905,838793084,1879461850,174646882,799377829,-1391297520,1662174465,-1515051223,1418166797,617891964,88501152,-8329224,-332316007,578862731,-1958225907,-48430550,364433620,672614701,-543402735,1640937419,1652773670,1438802075,1253118704,-437170179,-1293214571,-993046095,-587178927,-1109779156,1488987019,361359366,636392533,1475320922,-340419274,-1051909293,-198229344,1782031429,755715852,-1347908717,1136714075,-300081192,-973490302,-1227495855,1056861563,-456092010,2059735750,1717391965,445322989,-229945819,365508357,-669780534,-1492733016,2036633470,-1591322414,1413308278,284243468,1058614573,1039802752,513043170,1321866389,-2035070065,1369875074,1185560431,-115478130,2052148093,-622834755,-767971094,100101667,-179552503,-611509966,-173730924,609899071,-801897392,-1618617062,1309686922,-1479282059,203527437,1441323441,1240063826,1376828317,1538349969,1939095833,-1387803305,-886441927,-475166012,-749573857,-1298808660,-1880599631,-793024681,-1463086777,96767938,-315281390,-740434918,-2063763699,2092321964,-1987236648,-1041403886,2042825358,1680713292,1563716982,-795060194,1824800656,-1268363815,428031364,877653659,-930979078,-627510935,-2002637577,1046411816,985971541,-1504442047,764933635,581930450,-754054033,349583027,-1468624410,-1905908338,1829041104,1650425416,-1343261687,395760303,-964430942,-471751412,-219265851,-674306090,1316552486,-1848634265,-1558015698,366041185,1330281484,-126735292,276916694,-1208508793,-654121020,-452001567,1793881290,-210767669,546865295,-1467377299,1490232554,2059883537,-1092851976,-1053910733,-1400871314,-590038184,-1480022547,1215483293,1271899735,-423007312,1417324710,1041288703,1159124701,807203766,-478256579,-1709321341,1375833374,-1332232912,1582229717,-270023336,877952635,-1377473182,1581370282,1290685073,1633302563,345048729,667999638,1736874343,681056791,-1893273138,-717390127,2116921451,1568927702,554953995,-516598464,-1576181426,-680103818,-169730181,-872816694,1523456466,530405370,-827656405,1061696970,-867693463,157734448,-1102011990,-1776159153,1274031724,-1702693698,159047370,1824996833,-1985970899,511182240);
/*FRC*/Random.twister.import_mti(94); void (makeScript(14));
/*FRC*/count=362; tryItOut("\"use strict\"; v1 = Object.prototype.isPrototypeOf.call(h1, e0);");
/*FRC*/Random.twister.import_mti(109); void (makeScript(14));
/*FRC*/count=363; tryItOut("mathy1 = (function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var ff = foreign.ff;\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  function f(d0, i1)\n  {\n    d0 = +d0;\n    i1 = i1|0;\n    var d2 = -129.0;\n    var d3 = -33554433.0;\n    var d4 = 4611686018427388000.0;\n    d2 = (((-590295810358705700000.0)) % ((Float32ArrayView[0])));\n    {\n      d2 = (d3);\n    }\n    return ((((((((0x85e2930f)-(i1)) >> (0xf36fe*(0x2d8456fe))) / (abs((((i1)) >> (((0xe167f77d)))))|0))>>>((i1)-(0xa4842f34))) == (((((((0xae84071a))*-0x4d26c)>>>((0x65dc2e2b) % (0x6ea6c0ef))))-(i1))>>>((-0x8000000) % ((((d2))+(((0x79f882b6)+(0x68d1e99b)))) ^ ((0x50319319))))))))|0;\n  }\n  return f; })(this, {ff: /*wrap3*/(function(){ var gtotig = x; ((void shapeOf(null.throw(\"\\uDB51\"))))(); })}, new ArrayBuffer(4096)); testMathyFunction(mathy1, [[0], 0, '\\0', undefined, [], (new String('')), (new Boolean(false)), true, '/0/', (new Number(-0)), 0.1, ({valueOf:function(){return 0;}}), '0', (new Number(0)), ({toString:function(){return '0';}}), 1, objectEmulatingUndefined(), (function(){return 0;}), '', false, -0, null, ({valueOf:function(){return '0';}}), (new Boolean(true)), NaN, /0/]); ");
/*FRC*/Random.twister.import_mti(491); void (makeScript(14));
/*FRC*/count=364; tryItOut("if(false) /*bLoop*/for (let xfeqev = 0, x; xfeqev < 21; ++xfeqev, null) { if (xfeqev % 6 == 2) { print(null); } else { g2.t2 = new Int32Array(b0, 20, 2); }  }  else  if (x) function shapeyConstructor(ojfytt){if (ojfytt) Object.defineProperty(this, \"setMinutes\", ({enumerable: (eval(\"/* no regression tests found */\", /(?!\u0093|^(\\d)|\\b(.)\\2{2,16386})/gym))}));this[\"prototype\"] = Object.defineProperty(x, \"valueOf\", ({}));this[\"prototype\"] = c !== ojfytt;this[\"prototype\"] = (1/0);this[\"prototype\"] = ojfytt;Object.defineProperty(this, new String(\"17\"), ({}));return this; }/*tLoopC*/for (let z of [this.__defineGetter__(\"x\", (({/*TOODEEP*/})).bind) for (__parent__ of ({} = (void shapeOf( '' )))) for (x of (/*wrap2*/(function(){ \"use strict\"; var myqrwr = this; var fbpnoo = function(y) { return ({a1:1}) }; return fbpnoo;})())(\"\\u02CB\".throw(-20))) for each (c in x % d) for each (z in []) for (\u3056 in /(?=(?:\u0bfc+|\\b))(?=\\b[^]\\2{4}|.)/gim) for each (x in [])]) { try{let cyuafa = new shapeyConstructor(z); print('EETT'); print(cyuafa);}catch(e){print('TTEE ' + e); } }");
/*FRC*/Random.twister.import_mta(2024372732,-245373840,1701964684,-1340717507,-10419737,1671697036,1162049259,985335732,-159579642,2085241402,1916454369,1638390062,-627522107,956838545,1350556708,864501386,1680282804,-1146156614,1035958194,65121710,-1063085820,35162065,1433392341,-17789680,1301915865,-519091131,742795180,1469014645,-22841177,-1932013796,279638548,-683915052,-2138291323,-768334781,1796944278,-728417647,-245508108,1691464106,-1533042523,-2070111926,-604266554,811780192,704833509,2071446074,-405131412,-1753886527,1669483661,-2008070759,1723013539,2025069738,1430865758,-435209333,-1229513193,1238765997,364289513,-1511787439,-1657919247,-366133372,-1175123652,1749016615,996414373,-1845035263,-1341842774,380079292,2029363128,-1068220465,-1237856114,-1036967755,62316838,997939990,836377994,33972711,-379370373,1892276223,-224887097,-354438163,163530529,714614726,1463530920,-509849315,1260653967,1943703996,-21470341,652305322,-213878947,-1473611124,-939305492,-562078835,-1163257708,-125594264,-1706055658,-1861135616,858114829,-1998858018,130010133,757972759,-55536143,1787083198,1374020129,321008201,-1986962972,-273709168,2096155975,-636313863,-168897669,-746820716,-380058360,-1681432530,-1026439771,1552318460,-1467639107,-1123168644,-2116541193,118525084,962488908,822021292,-2118822019,1250886521,250588363,1856672824,-793724030,-635688860,-1393187043,427431957,2033783430,878197912,-1121920617,-1265464528,1538333859,-257658839,-44067519,-850969110,-77989569,1138120158,1875428123,1728456230,-1421520237,696920403,126602728,-696099615,-353919631,-1960997149,-1057790797,394247274,-1091031442,373029478,1669503758,-1447764629,265464027,1917150780,1259304083,-1534798605,-1227357318,1007473749,-347712382,-681870924,1850865726,-1811015235,-1654939052,2039114759,2012907496,824654769,-397331342,543837169,1709414670,716002390,723669267,-1158811861,2096595969,438291157,11589889,1750004096,-1466258019,-2107046624,-536523871,1626678418,1718558454,1312965117,-1460788988,-976194958,-285190767,-886415652,417032361,1260115186,1911021704,-424269865,-263274297,1820561586,1306279940,712346502,-93590744,-1196229265,-1922422912,1037726157,-1808963573,609678683,1203342501,-1195915007,-510319623,756528017,2096302041,122994255,1889547325,-2080546546,-735024229,-422983354,986260552,-975082634,-38632415,-571479129,1937621416,-424004173,-711253483,-2025894130,-1345303647,-739813239,914595096,1677461725,-954597784,-1712036236,-307710100,1070103324,136941326,972793716,758301007,1774603237,-248702492,-1419137829,1641275134,-1483052118,-1157591042,1332670954,2005923768,1550073645,1447476244,1401584385,105831957,-491631145,-280560184,1128805109,-936845462,1911071419,-397099274,-578720825,162345732,-2124189211,2021742253,1910985456,886627214,163957168,-518248138,1320380939,1185677909,2009176208,270707744,561885991,414356714,94144451,-671147076,-1858461901,773768187,469934256,1119336585,2080990493,-1303730126,-1866024348,-1814711728,630105089,254821116,-1910297733,267807360,963512294,373951293,1436962308,-1254312949,-193715745,115601733,-1023202598,-636740016,-1431547763,-1878357071,-1297338554,-650960582,2110580883,-2124397878,986637346,-102556764,1107838462,-334962515,525546789,1008702840,-85530290,1965997491,-699264866,-705190674,1301579988,1547803690,-249543791,-1096153723,-2120719373,1238927725,1733706334,973020761,-32380378,1810738299,-1914558894,1607299144,781934436,-953878528,1435057375,452806291,-104011980,1325630857,-1090376738,-1603659742,335955715,1221143370,-1626968673,2128638371,-1543996077,-787250053,-1812272273,-723434687,401567823,-144160380,287334505,-1377058862,-141525249,-998419852,-1150110242,1538221038,1614359221,758770438,-1055025999,-1915447655,-612140229,-1843999787,-780493622,-185824591,1653334125,-1151695458,-1439180594,1357299561,87763084,-752701735,-1525710558,-2116901408,1849918037,-1359347617,943670598,158009064,345657899,1193104596,345903722,-2068944489,1861363038,-889013275,-1689791822,1954795789,411911142,1786294556,-798867665,-53792308,1969864270,829953092,-32824739,-496348594,-1698525128,1719705177,1468335928,-364156912,1029849449,-841270289,1946165467,-159726005,-807382274,736530338,-1676001297,-1400844300,1655035057,-1567621464,-1104876856,55724165,992365856,-1980287700,-986059354,-839904827,-760824715,504424227,-115630771,-1087029036,1613077183,202248421,533864277,-1183866551,2043804341,2035659236,-1328173506,-1443377963,-601085936,1988243303,163609587,2071788790,-1736858247,-389810567,25909584,163827958,-1504978463,1809489196,-1788058356,887262246,1832089817,2113306518,-1906056476,-1796635385,529619445,-1368115357,1120021216,785619128,-872320689,786378732,1012658798,1580173656,325393531,1924591522,1111340748,604888458,-190825154,825490435,283469672,-2061964614,55090323,2132506473,-580947046,-2015417053,-791033285,1017987033,-178759681,1890108158,762155627,1308533286,1317082083,1430627549,-822579972,170887925,215976427,385717600,-330520995,960504496,938459932,-1671098248,-1431191747,-884279494,1042174130,1892123728,805841697,49210593,214446499,-275096155,1535476032,2034757379,-575621574,-1692951431,1572615610,70993109,318639113,378128465,-1025500524,-111718412,-809954523,-1341886450,306493034,-1769202235,2145682012,-661968458,-1433939780,853938478,-524442373,-1000891145,-1143894676,-74084017,-38001047,677758163,-1222188126,-602652673,-1235638725,-1698194402,721298686,549781595,-329889551,-1554476056,1697758553,327315509,18569926,1987264372,-289203936,-169790825,-1827513792,-1747199757,909121642,-1682309650,-711724177,-954437825,-1752920969,1836863706,-578686561,1903202988,1524748642,129658620,544675610,1935549464,-1529848896,903190248,1461064122,498878566,-1932260765,-946509696,251245801,-82863947,-1246523689,459612653,1876164662,1919971375,1220820043,-364376376,613198124,405382551,591855906,-907616566,-1570475004,-2048331083,1140105148,1344852902,691877813,-1352382664,-433579949,2076162634,1128105393,883143045,-536248488,-1882590222,586536330,1670357994,1591189266,993544576,-1149734793,-1259181582,-1169083869,399258102,-1852096163,1654359655,-820722473,1789769917,960749321,1557025608,1685322592,-1877430970,422937837,-887619333,689830669,1342290220,1181790859,-711604474,1475149811,344360355,-1090391515,155130487,1242362711,1624942521,1860640523,-43837766,-247883795,765223547,1968927535,978924312,-68487635,2015615312,-1880935172,1406619279,1955821003,1830495319,1940939900,-600659057,-772549191,-777075896,-1427567649,77855699,-1049253524,1100537397,-70306440,-1712539825,910757863,990799198,1587911298,-1003076674,346974693,-1662484445,-1135557071,-1301543715,-1941892477,1604671378,-1466199335,377059596,2017951695,795604063,-1619547984,-1024274417,-626916017,-369881003,-227546726,-2146833729,1173879117,1306767333,1412477648,655235155,-1972066426,2060294884,1404344410,-760108336,-251615734,-619563384,638062772,349591062,83954970);
/*FRC*/Random.twister.import_mti(171); void (makeScript(14));
/*FRC*/count=365; tryItOut("mathy3 = (function(x, y) { \"use strict\"; return Math.max((Math.min((( + (-0 | 0)) | 0), ( + (y != ( + mathy0(y, x))))) >>> 0), (( + Math.log1p(( + (mathy2(Math.fround(mathy1(( + Math.sin(-Number.MAX_VALUE)), ( ! x))), Math.trunc(Math.pow(0x080000001, x))) >>> 0)))) >>> 0)); }); testMathyFunction(mathy3, [-0, 0x080000001, -0x080000001, 1, Number.MIN_VALUE, 0x100000001, 0x080000000, 0x100000000, -0x07fffffff, 0, 1/0, 0x07fffffff, -Number.MAX_VALUE, -0x100000000, 42, Number.MAX_VALUE, -0x080000000, -0x0ffffffff, -Number.MIN_VALUE, 0/0, Math.PI, 0x0ffffffff, 0x100000001, -1/0]); ");
/*FRC*/Random.twister.import_mti(381); void (makeScript(14));
/*FRC*/count=366; tryItOut("mathy1 = (function(x, y) { \"use strict\"; \"use asm\"; return Math.max(((((((Math.fround(0x07fffffff) >>> 0) >> 0x100000001) & (y >>> 0)) >>> 0) ** ((Math.trunc((((x | 0) ? -0x0ffffffff : (x | 0)) | 0)) >> x) >>> 0)) >>> 0), ( + mathy0(( + (Math.fround(y) ? Math.max(42, mathy0(Math.atan(0x080000000), x)) : Math.round(-Number.MAX_VALUE))), ( + ( + mathy0(( + ( ! (y !== y))), Math.fround(( + (( + x) == ( + -Number.MIN_VALUE)))))))))); }); testMathyFunction(mathy1, [-1/0, 0x0ffffffff, 0/0, 0x100000001, 0x080000001, 0, 1/0, -0x080000001, 1, -0x100000000, 0x100000001, 0x07fffffff, -Number.MIN_VALUE, -0x07fffffff, Number.MAX_VALUE, -0x080000000, 42, Math.PI, Number.MIN_VALUE, -0, 0x080000000, -0x0ffffffff, 0x100000000, -Number.MAX_VALUE]); ");
/*FRC*/Random.twister.import_mta(-2005246970,-615565037,1563409361,-1875239093,2014474933,-1059719332,-2061228381,-738363526,2142140493,-1445592359,-1768409738,-543273199,1356909723,484270644,1961944988,1340470732,-1816893895,-902414626,509710114,-1910146079,-1698244137,-1653816819,-210159673,-786740385,-1781209965,135043726,-1582686818,-722476242,72765762,1817748608,-549578412,-394433250,-520632938,-258641295,-1341476604,129342611,-1355306161,211307950,-1835563362,1364258874,-1385614385,-56557101,282489718,2115220880,-1674359972,-1114885564,1406631663,-528566533,814057406,1012479695,1178831687,-82633372,-905151723,263646803,558429642,483742621,1258868592,742195406,-585143315,-2041291284,-1664876804,-1214721808,282478366,1161634015,1687296258,-1072925634,-1515449025,1172321350,256090498,241485460,1525390008,1424907542,785729541,272695218,-31203517,1264258698,1789432255,-216599710,54610157,-830691530,-649008091,1644371349,-392086343,1530731070,-1448535249,1281650213,1091698363,-2126433355,-904369009,-673167339,1651936638,-530623230,-398744418,2039465277,-357576179,-1261270510,1951991321,-947290437,2119872731,-248930715,-456812152,1890258575,-2110658615,2017862796,-1137850715,-1280307781,-630768544,-1793326377,-1279078815,-63246547,73872988,-564212648,1677676884,1878069566,-1129325162,-1408791159,-1420222247,-2084360484,-1149157249,-271764159,1677172955,880671716,1611018754,670673070,1979195002,-169300933,311261651,513290310,-2049564185,-7413784,1172611031,759337610,-1014014229,721691623,1886882991,-595408336,-453995581,-1398693428,1415677692,-1748712403,-1615072737,-841829629,-1414094483,-1867127611,1776822457,1380904557,-754630280,-438719182,-2107980951,142435172,823912581,1285566539,1452645288,1463331878,-1531348979,495273122,-1437834488,308511330,-2118222404,-1410994510,-1733383702,-13591870,-534745558,1659925931,1395005600,1493983056,-745359175,-201984132,721856400,-1871722968,2116782999,-308330072,802397595,342426549,-2126314076,514583808,-881663218,774775706,-1727869164,-1767161017,-361358446,-2035135996,1360961458,1441322003,-639383736,1025342259,-1481499168,-146742454,-1076638180,966135367,69494532,120442357,1009433921,183677845,-43334251,-2116414509,-604582179,770990749,-617807630,999928592,653404617,322219548,-1916820988,-1397370240,-604014982,1260251944,1521994356,-927332720,1753804220,-1152634661,1895280457,439431552,-1309651427,1323925424,-1257445930,379740521,-54131103,75687783,-963734340,203014482,206611924,-693801641,-302156368,1417930480,-1948023399,742447844,-910333016,-124537991,-931001146,11533358,-141727810,1138067817,2012174357,-1375242071,1664154149,-444487784,25662701,-516207726,657647284,1962189614,-48135242,1088076007,-1204948752,-681377861,1401894643,-81161045,-1227435367,-2136296432,-1718737195,-1007213732,793398917,797594982,871126726,-1447343218,1566149218,135207735,-140617794,-188640118,971559512,787485876,-23846359,140107167,-1598447934,-1240268970,1157304476,-612540490,-1700850971,-1427041615,1656235185,1462584886,1654961763,236912157,-1755376314,-801008587,55318219,-352530493,500736930,725976175,927827453,453086738,1457584624,1305568599,-79980789,1270410773,1901753055,-504437185,-414154989,869219957,1631189693,249138594,2018399352,-2029127932,-349864847,-816330936,589983788,560164759,-1342417021,-1665783643,-1926570960,-751715220,602660509,2077548720,1951660953,-2041120931,-169353141,1822945481,-651097980,-87912411,-1848691931,2094477103,1742432676,1461741876,1407548362,287634090,1380622571,-293799638,1097584133,-2079455888,1756093300,431675004,-1451622315,433570674,1714258666,1340941019,370277968,1756327730,334041541,-2030358350,756175968,-270117314,-783154935,-1431227610,171341628,92653555,1641353109,1673599828,-1803050680,-417741861,907250865,2119308187,988478809,1305752317,-1365632561,465618794,-784011699,-77065585,31737012,-310243285,1751275847,1689497974,-1262735004,1450619920,-5790450,-1982661177,1776362217,962579658,-1305659727,-1498560626,553923449,-156039579,-1707242321,236065865,-1506405097,-62088735,179077181,626307035,-626684879,1978863084,-435146593,-1634527899,1460434094,-703789679,-1320792353,1899008642,-2111208371,-676756296,-1619473332,1734053759,-1527092532,1204970748,137025858,2082008208,1466930,-1363674722,1895789745,2119091585,1539178583,1320053412,1521870011,-1078276544,-1947596757,-869687283,-806494171,1445845186,370522873,397180770,-2012933833,-1277633246,-2088151648,-845530377,-1987998061,-1124238369,-1952477341,639346925,1860931378,-1646057617,478551912,-1617210108,-1945864062,191879585,-92677984,-417793917,975997505,1959686076,562102127,836855154,1492589367,323857240,-1205484147,1799695031,350177954,-763559623,291515697,-491931380,216709627,-919867849,29994383,-412915945,457579944,-1892427943,1947806742,2105179409,1706185445,-2142180294,970871634,-1344879985,417901563,144952886,-1785771926,-1760616690,-257866082,111576935,836654871,551121860,-1679453363,-839885300,-1556667741,1357952140,-850228007,-472908404,-1730967119,-297337340,1934619325,-237065856,2040469046,1358810729,-1614588896,1497954739,773278153,-767287477,-2132859980,-1212971834,-1956659899,-1701673384,1900870985,-1249988029,1434758756,-2121653172,-1106345558,-533739273,-1639930738,-1044281138,-2065967739,-1701624254,-706126770,-1057149374,1788953086,-731303903,1919062992,-684839234,1315825765,-1872504620,329018086,10287262,921040712,1955273815,2072970955,2013139675,-1485158088,-250226890,1568837925,-734881703,-604966187,-1582920353,-1651466719,-2126508763,514091798,-1337857339,1426518568,-1702630479,595647837,-104164981,943077671,1801882575,-1668428673,1341508779,913401507,1430113934,1575677658,-1030454009,1506853877,733002155,-899289374,-376546528,-1397912677,49499901,-793909495,-591320835,1155301552,1067408472,-121780397,-2095384348,-1677082259,-1697099545,-823100365,406240804,-1030603523,119058936,719772338,-1347472868,-408110973,-571242088,-516826164,-830264552,282995923,-334434816,-1002349272,-461241927,1730467480,335643187,1079908463,1670213918,-1055443293,1559751365,12225940,852684685,-577044558,-493086546,-2012032253,-1905725178,-244322193,-95448367,-318361495,1032730721,-1262301950,622723779,980690071,1842786731,1731690111,574008234,-1078645143,1260383254,-1858087822,130831174,1636928022,-343625387,-1034102033,-1819337126,-475066969,-1876192622,-95110077,511864751,1489836999,482925880,1233116130,343127535,1665280776,1147086588,-180896214,1344440314,-1341468679,-554645519,-928082231,-621127915,1792144062,-94536113,-703999277,1677284202,871730933,1942552175,1046523597,388739730,168190618,-121721362,-1498641983,1902952529,1504954018,-1758280161,153435151,-560667370,-59380943,-921356085,1921158016,298157756,1759533863,1552658964,-1282681212,-438804041,86972509,-652597326,1430566375,-821685348,1414962409,-785269599,1268005223,668150217,-1772060051,-1565336253,-1263930616,-1570440351,86626456,478056946,355269103,-1942470860);
/*FRC*/Random.twister.import_mti(70); void (makeScript(14));
/*FRC*/count=367; tryItOut("this.v2 = g1.eval(\"((void version(185))) = this.a1[3];\");");
/*FRC*/Random.twister.import_mti(99); void (makeScript(14));
/*FRC*/count=368; tryItOut("/*oLoop*/for (let zcgmeq = 0, ropgzu; zcgmeq < 127 && (new RegExp(\"\\\\2\", \"i\")); ++zcgmeq) { Object.prototype.watch.call(o2.g1, \"acosh\", f2); } function \u3056(x) { yield (b ^= x) } v0 = a0.some((function() { try { e2 + ''; } catch(e0) { } try { h0.valueOf = (function() { try { this.g1.__proto__ = f1; } catch(e0) { } try { v1 = Object.prototype.isPrototypeOf.call(f0, this.h1); } catch(e1) { } try { s0.toSource = null; } catch(e2) { } for (var v of o1.t0) { try { o1 = v1.__proto__; } catch(e0) { } try { o1.valueOf = (function(j) { this.f0(j); }); } catch(e1) { } try { o1 + e1; } catch(e2) { } const v2 = new Number(NaN); } return b0; }); } catch(e1) { } try { g2.v0 = Array.prototype.every.apply(a1, [f0, e0, t0, this.o1.p1]); } catch(e2) { } for (var p in g0.a1) { try { a1[8] = new RegExp(\"(?=.)|[^]+|.+?\", \"gyi\"); } catch(e0) { } try { this.b0 = t2.buffer; } catch(e1) { } for (var p in t1) { try { v1 = (a0 instanceof m0); } catch(e0) { } g2.o1.s2 += s2; } } throw o1.g1.o2; }), g1, m0, h0, g1, this.t2, h1, t0);");
/*FRC*/Random.twister.import_mta(1199042932,1947613335,1552909709,1820329750,-1667792783,1342516461,1340412752,-2009857077,268474076,1472857555,1767686739,2105323024,83978427,-1073632402,-1058405787,-1426191998,299200723,1857042686,-1342478243,-1935882493,-990676351,1485958833,-1698676793,-952268748,-1770304386,28648446,-1998960485,1321308506,-16270217,777429285,-1822568040,1799225187,1852956350,740062356,-1482161273,-350144611,-971191571,815108125,-947996014,-1756069181,-268698112,-572231215,-1475951162,-21437648,1482726981,-1052944193,-1980852122,-1012445038,1255437748,421418975,1836661310,828113292,1025260154,-2005404844,2032461589,1456182533,-406836761,-837283041,332914847,-777868450,42242507,1719429702,1775386619,-1298780363,-1749696807,1082197765,-127755141,1995255176,-1303588599,2029085496,-1409479993,812422519,-401623250,945421296,-1536422005,679947653,-1558691853,222382311,-406618663,-1627289805,1012928052,-549798573,-1162828895,-1011755731,1868128025,-1440995996,-1724591717,-891194928,-2039248766,179585140,1204926554,-748184713,349865335,-237123332,-1906582192,953467142,459965149,2075489939,551318216,1824958418,1360846173,-854150893,-425657865,-1533112624,958015369,1426433815,-1193264517,1550064528,-1461711902,1950547341,2048043170,739591792,-177468008,1200041278,-457453648,113364561,-1469068210,1751489403,-333618046,945719227,-956312305,1960810929,744720399,-1035876242,551951910,1279774043,-1785444156,1427364895,1743901136,963167177,297400509,-1842756328,1663406896,1184878091,-206377856,172040946,-1730937858,2062479277,2130328777,311694584,459532519,-1409861903,-984366962,-1381843732,-744311049,-392849889,773536860,-660644609,1995202111,1545583407,1573171284,-1554506025,-1510693099,2050751670,-1265815424,-132120083,1958738256,-1273105444,1894577562,1982034018,307166410,388450666,-901373536,-1775885767,1738130366,570308849,2117511416,873650654,-474787263,608284667,-1522483570,760116149,51880855,-84590959,1373083951,2104781376,1272958197,1174322280,-970021741,377038529,117834750,-1648823821,-471966420,-1661260707,427215543,-612919239,-1587927376,892868016,1067370931,-736370351,-110688945,-1259839350,-273082502,-1713537832,-825357404,-17451733,927739007,-1959130696,748689881,-742235495,-1633119983,268102925,-1999762346,-1853206516,-1399075489,1608085178,899188212,480521721,-668656986,1392030207,-390006409,-2065723508,-1100048278,1338165004,492803063,-214094074,175669197,1758688057,1642056032,-1874276217,283695927,-1034466864,-937097191,-1714380149,1247739008,837962811,1769559639,590804759,876725888,1732851282,-1805487235,1047043236,-569499546,-1485447523,-1158361081,-909382539,1733795866,986034441,1191640967,999401824,962873282,-587400675,1481098880,-518366347,-903069068,1838723534,-859202293,289200436,963280671,1416472666,-789011833,-1886558435,359171641,-428438102,-741430242,-993486936,1412852576,-810960716,2084959545,-936149131,-247977340,-1208693530,-1339537354,-1537129821,489373638,322536255,1529133892,128932999,-160247094,6041128,1623141601,1406080230,806691450,1363157980,1876002732,70788197,-1783356105,-271103969,1021101701,376194690,932704544,-575562673,-1440787760,1181065303,1743245535,-109613111,290292923,-1424958390,1628482711,1442125255,-1324297033,2066722878,657122465,-1443388307,-11261284,1018841623,-1348286539,-311925537,1509182273,552790207,95652776,122503832,-1297815820,1088651017,-501612452,-883164773,2070446078,-309385351,945396251,-1990387853,-400432713,1185669884,-1567728591,689516849,-35713723,2144264031,145965772,864310752,-541396919,-1720765054,-1120523963,-1119019995,-2044010316,274890229,1340260618,-1340060939,1874542475,127268717,-85616116,385960364,-238676157,2080447511,-825232335,285347182,1837405754,-1566319802,-1631146817,-1206657499,-1976238238,1896989675,-127564641,1795060616,1260498404,432343991,-1931926813,-1393604904,-1751695503,734415219,1183203594,910004413,-1451584922,523619489,-1851391129,2020370799,1237072506,-403703209,1782456334,-667725346,813233909,-1221335624,-1734445840,2040616660,-311435555,1150094143,-246675297,-895464946,1752011278,-1318895497,2109082780,-1361708327,531402491,302588231,-1878139042,-1241035099,-1286889821,961558553,-1229271985,1337558322,-1062130519,-1579037772,1144490750,-1266286183,-277086942,-1781992489,305275331,-1002748562,1366574384,-1508065720,150613578,381392234,1765425888,-1721269389,1256772752,-332085925,1069868655,2126080517,2108539242,-461106082,-762585583,-555756543,1032008609,-1928270271,-1217327383,2091518828,-771252480,-2006078681,431262787,1090797503,1091022332,-555568772,1988092099,-580370616,-519000089,680716760,768124681,-1964116745,-574802691,2088589142,1480738062,-438914517,703286427,527871459,-811374163,-399392675,916934268,-179535935,2038129101,-754212923,-1855211906,-222127523,910155355,122311922,1609636007,1769450589,-1840776095,224001924,1453938404,-502833854,-816316405,-969000155,-1785121696,-1665660765,-481192220,-1635645772,237722687,-1454577426,-131036479,-1354158716,-1280264426,491027486,-286007927,-1427000063,152901883,364305740,-1841258244,1000369296,-1830421932,442591046,-1908268066,-1637764676,-55829250,1716764282,-2071810215,-2030473631,-1183688457,767862965,995408710,1717765911,904113849,392664263,-2114281710,290003049,550572783,-1505938644,1900170773,1278926816,-414089067,-1446384785,-1541771198,-346635564,-297311808,-1711236755,-997790745,1329893572,1826915904,-661993853,1791280839,-494596584,-813815939,1205973115,393264720,-371460493,-622693041,-1931197301,-569906486,-1189025983,-2123076715,171726325,-947498527,-119669749,-189932602,-1430115360,-1467756195,49968087,287645333,-1091779317,1022534085,425887309,1710452243,1610580981,-894088099,1121265582,-1917828519,-569118295,1935789035,-800133172,-1566756506,-746679057,1692409362,-2105755689,-394602465,676887285,-388050245,1372735859,-1586283571,-508172832,1669247043,281077489,278584214,1484393066,773503941,-1836913222,-1407554537,-1441801912,-611889031,1517892751,1645520752,-1682732293,-710700230,464117977,417302974,1146889931,-2000839966,149816326,-1276800263,-243822704,-400475691,1614278683,-92707674,1737861212,-196279230,-1603704351,2012210714,1977243914,-871217453,2128033944,-1193107034,1532303523,1830439362,1209914330,1955461989,1696300035,-515509531,-1374787148,349779536,1913791178,953568454,280670867,585874113,-1358740710,-812872513,968302559,-1567938492,-1289170304,-1191763109,1999066254,336724931,-1813951117,1998884700,279696452,-1910719928,-1260142143,328884482,525785425,2081775142,-1032540349,-959493107,409731925,-649225924,1800878436,1327026806,-196134446,-151053063,-1573689807,1356697728,1366290381,1011099913,-1036607453,1027822540,2000656921,1267032607,-905258141,833813319,465719555,1643928632,-646658069,1241861040,-1616333297,-1744104896,483464974,-1303643623,-518922392,1974152161,-1380521636,754817651,-1698504797,-555070700,862894948,1365069340,142359772,-502559326,-1403377081,2024109471,504773072);
/*FRC*/Random.twister.import_mti(64); void (makeScript(14));
/*FRC*/count=369; tryItOut("{ void 0; gcslice(2905016921); } i0.send(a2);");
/*FRC*/Random.twister.import_mti(85); void (makeScript(14));
/*FRC*/count=370; tryItOut("mathy0 = (function(x, y) { return (((Math.fround(Math.hypot(Math.fround((( - (y >>> 0)) | 0)), Math.fround(x))) >= (((x | 0) <= ((((Math.fround(Math.hypot(Math.fround(Math.fround(((y | 0) <= Math.fround(x)))), Math.fround(x))) >>> 0) !== (((Math.fround(y) * (x | 0)) | 0) >>> 0)) >>> 0) | 0)) | 0)) ? Math.tan((( ~ y) >>> 0)) : Math.imul(x, (((y >>> 0) / x) >> Math.min(Math.fround(x), Math.fround(x))))) >>> Math.cbrt(Math.fround((Math.fround(Math.imul(x, x)) <= Math.fround(( + Math.imul((-0x080000000 >>> 0), ( + Math.sinh(-Number.MIN_VALUE))))))))); }); testMathyFunction(mathy0, [Number.MAX_VALUE, 0x080000000, -0x0ffffffff, 0x100000001, -0x07fffffff, 42, 0, 0x100000001, -1/0, Number.MIN_VALUE, 0x07fffffff, 1, -0x080000001, -0x100000000, 0x100000000, 0x0ffffffff, 1/0, -Number.MIN_VALUE, -Number.MAX_VALUE, -0, 0/0, 0x080000001, Math.PI, -0x080000000]); ");
/*FRC*/Random.twister.import_mti(414); void (makeScript(14));
/*FRC*/count=371; tryItOut("\"use strict\"; h1.has = f0;");
/*FRC*/Random.twister.import_mti(427); void (makeScript(14));
/*FRC*/count=372; tryItOut("mathy4 = (function(x, y) { return ( + ( ~ ( + x))); }); ");
/*FRC*/Random.twister.import_mti(475); void (makeScript(14));
/*FRC*/count=373; tryItOut("mathy0 = (function(stdlib, foreign, heap){ \"use asm\";   var abs = stdlib.Math.abs;\n  var ff = foreign.ff;\n  function f(i0, d1)\n  {\n    i0 = i0|0;\n    d1 = +d1;\n    var d2 = -32769.0;\n    d1 = (+abs(((d1))));\n    {\n      d2 = (d1);\n    }\n    {\n      d2 = (33.0);\n    }\n    {\n      d2 = (d2);\n    }\n    return +((d2));\n  }\n  return f; })(this, {ff: DataView.prototype.getUint32}, new ArrayBuffer(4096)); testMathyFunction(mathy0, [undefined, '0', 0, (new Number(0)), (new Number(-0)), 1, 0.1, true, (function(){return 0;}), false, -0, '\\0', (new Boolean(true)), (new Boolean(false)), objectEmulatingUndefined(), ({valueOf:function(){return 0;}}), '/0/', /0/, NaN, ({valueOf:function(){return '0';}}), [], null, (new String('')), '', ({toString:function(){return '0';}}), [0]]); ");
/*FRC*/Random.twister.import_mti(615); void (makeScript(14));
/*FRC*/count=374; tryItOut("Array.prototype.unshift.apply(a1, [p2, p2, this.b2, s2, g2, i1]);");
/*FRC*/Random.twister.import_mta(1200077002,1707387912,-392177782,-1430240442,2082130152,-1870428351,-507987370,-1710762898,981473553,-1273864779,2142922935,-628119170,-18717493,-1895673554,-2011743351,821208913,533394855,-1556241416,1437280169,650918242,-1992486703,-869602766,-2042071503,1658251940,1605123100,1388772671,-1890514704,-1876156264,997171084,1893042433,1067307179,-1504487135,-456351721,-1125945529,-338526237,-1510486770,-1472867188,-1309105880,-537194950,559196644,368956789,-1688509720,-1184740675,1621216157,623776803,-1482237225,-11424003,1799448293,1019966430,-829679650,-1209586366,-1388402133,427787700,191438556,412929884,-1544176425,-340630500,1118036076,326187327,1252983406,694112869,597921020,505550585,780038989,-1625584345,565924283,-40896347,962363564,1371281705,-1214083334,-1487012493,31749422,1263233343,180627464,-603832716,-1470775863,2039818112,-609533914,-1699566426,-1184790641,526124313,1615499597,327587997,14909075,-1894872097,286536693,708061228,803029505,-1647253831,1227627242,1379824508,471586073,2131710981,1348292856,-1246652688,1314882814,674647837,-831925330,-1891388248,821212644,-1245725277,769564101,-1433224349,824735965,424167604,771456191,1825078815,89463652,1573194514,33289620,258483573,1598384351,1010570602,-118969467,-1732415399,-1719163778,858361035,1164933546,359210190,418016062,807004392,-338072886,-1554230304,-1207314676,-1754059641,-501942567,-1571612765,-1836330203,1678324955,-223675198,433325181,1627918862,-499294800,398708101,-677217085,-1603038744,1315970625,2113076930,1395867379,-156376100,390111580,-1224051843,1299758767,-402234854,-1457627877,-542112564,-1112991066,1369115961,1181803224,-960273921,-392998993,831227891,445142535,-301229054,1165089224,229644978,1876205796,-1268499426,1170636969,-1312432189,1355201558,1211717906,-1710853607,121707194,-320024412,-564222311,-1274608293,-1140314193,-1187363352,712381313,-552256618,-1167533099,191982733,1047523575,118303487,510426849,-1848144716,48808397,-1525450959,395379260,70616405,114008522,-941690187,1538224076,5291266,1127707226,1170920329,-86865376,1903292212,594837109,1108882192,-1366224255,666470152,679466916,306008984,877771289,-1481743635,-1618662221,-511283618,-367472290,482567802,958682599,1073394207,-2067778449,-1511625666,729725373,-1936132320,1307496811,687878091,-412252204,-574131767,-952344971,2066773128,636257085,-661698325,-1449155368,14147615,470974147,200148799,261527120,306519948,-1404601649,-576922298,-2027621406,766229637,-720277909,-1769606524,1571249034,1449146145,2074500843,-168555244,1394464987,1513216208,634020490,1743426187,1227606300,813184494,-986601557,-951616050,-498055382,947166463,-466298679,-1720239564,2061292701,-705561825,-356034061,1850889720,209756033,-434356705,926717869,-1139217931,-1945055265,1644018666,-424255745,-230134964,1366600252,1459705179,-659055896,457332292,-1672432299,-417789644,-1278845960,1859116160,-425702545,560779368,-227978344,-1148471432,784645136,-613059076,271936530,1229341166,1025803550,-1895380167,-927371989,-262814712,-1357262438,544146190,1887567583,-1509389974,45382948,-1128701916,1301505588,1506794531,1095318700,-418322601,-1025553475,1596419147,-1059080975,-1873692992,-1616720771,1407822674,361123752,-1404554414,-2111443477,-32959112,-546977236,1478364234,1387227148,-2003455570,1234349291,157452612,-984593138,1361883794,1217931182,655232052,-418999463,380544236,-629638965,-34821589,-23144295,1672908781,121705752,-594535502,-1915543983,-919429775,-1719056417,1357787162,-454313081,1353469912,-1197674376,-1745654219,-156965206,-1620702501,264712088,1332823563,1637260210,-1439629683,-1999802203,1717451027,192479261,-702527991,-1490615693,1702525448,1510618370,335869639,-1951470190,-990205351,1249008324,-1094370827,-1727633414,-1919446463,-1121081685,208507258,-1404195483,320395974,-945146967,-738066600,324716653,1775178315,-1209984301,1855684995,111713771,120222385,-2037577058,947166929,286663900,-558672851,-656355368,2056380626,-1368234040,1796433647,2015175538,1530766504,-270619951,413326277,654702580,1997861688,1771808530,963133134,-1683601139,2013938278,-1592216908,498799425,2097440040,-1808031254,-1004194784,-1591762074,1371760932,1635476009,2022937464,1832922129,852240217,-564341882,-1077608230,-1770414423,763142705,-1563721497,347843379,1130664871,-1365552279,-1829082148,-1986479380,1900836075,1928185523,442247794,-2014534307,406067630,794321985,1276084490,-860338814,-1578158328,-977461932,1614379863,-1194048716,-539581311,1891729871,-1373917892,615928747,700119412,636072459,1964732520,-372221394,394135222,-903466798,1722597508,-2035825259,1565185502,1849233815,91421515,-364605030,-1093914230,-1394321519,-649991448,-50477613,1009492876,70479463,1519758947,1417067845,-649222122,-34738707,-2023416298,320229554,-2033328308,481540559,188886697,39093433,-697423499,593740051,1026290488,838659768,-222808141,-1457028199,-421615742,-557121825,146016948,-285281664,1479671954,1268597767,-488291136,1944945501,1263835581,-265453529,-540409651,-1616534790,7826882,1595066891,915860808,-220914437,472711173,610784943,1457765815,-56396296,-1822437645,-171333302,182141742,-621993875,1214870654,-1148322948,1989124725,-1718979139,-1418663818,1553056439,-103169947,-1879326163,714993777,1287409290,-86977851,-300559916,-105140555,383650570,851354262,151236192,920052318,1634932347,1845119350,-148339208,-1391316391,430877269,1228813082,1702331304,1262813321,-720020976,756269314,-729267683,-346259601,46657769,-870058441,-208807487,-666711100,-179296550,-1646757669,1025285241,2003589294,-1309328229,-151049083,1635346775,-1760719139,390621170,-77326575,-442643758,539209595,2025879204,886965174,-1080084127,-386350313,-1054921101,1863661269,563717211,-1917803364,1098772354,1325490254,1399770362,780426826,-777051789,578132732,1612863824,-654676148,19915919,-378714053,-550936657,1104761203,-401896736,-1308524547,-496649201,776753747,-857278061,1783606587,157763184,-744663637,-788537491,922074603,-848539648,-570538532,-803976775,-1672446897,-1112251411,1368373418,-1429218202,-2056375676,-1522497286,-956617801,881243398,1534834487,355560763,-140055319,2049927616,-2409325,-525507864,-2094404706,-969656475,-242271268,-1112621206,-592848568,-1902759567,1937460129,-1565646954,139693676,99287038,-1431566554,-224172038,1771999829,39669476,-1640080663,292740650,1758028330,-87121035,655953077,352962093,251492297,2371477,1173641889,1907994192,-2018117461,-524682434,1624385702,-2130774517,2068633277,1203087985,230080448,2092027283,-705087944,-86645402,-283839437,528104312,-668671957,-1102931307,599108035,648801152,59756391,-1586425199,-1056327610,1441426582,1355590782,-1847489158,-462308850,75089905,-296781664,558212401,2091166942,1584504405,-816976018,1973730182,1000855199,1841167617,-2133691331,739358253,-148107557,-1168847662,-1918458750,1078571578,-1110940849,-16375710,-1998079563,1006093771);
/*FRC*/Random.twister.import_mti(33); void (makeScript(14));
/*FRC*/count=375; tryItOut("\"use strict\"; mathy5 = (function(x, y) { \"use strict\"; return mathy3(( ! (( - (Math.cbrt((\"\\uDDE2\".valueOf(\"number\"))) | 0)) | 0)), ((Math.imul(Math.fround(Math.fround(( + Number.MAX_VALUE))), x) << (( + (Math.sqrt((Math.max(y, (x < Math.fround(y))) | 0)) << x)) , Math.log10(-0))) | 0)); }); testMathyFunction(mathy5, [-0x080000001, 0x0ffffffff, 0x080000000, 0, Number.MAX_VALUE, 0x100000001, 0x100000001, -1/0, 0x080000001, 1/0, 0x07fffffff, 42, -0, -0x07fffffff, -0x100000000, -0x0ffffffff, Number.MIN_VALUE, 1, -0x080000000, -Number.MAX_VALUE, 0/0, -Number.MIN_VALUE, Math.PI, 0x100000000]); ");
/*FRC*/Random.twister.import_mti(275); void (makeScript(14));
/*FRC*/count=376; tryItOut("var orrjtp = new ArrayBuffer(4); var orrjtp_0 = new Float64Array(orrjtp); orrjtp_0[0] = -23; var orrjtp_1 = new Uint8Array(orrjtp); orrjtp_1[0] = .2; var orrjtp_2 = new Int32Array(orrjtp); orrjtp_2[0] = -17; var orrjtp_3 = new Int16Array(orrjtp); var orrjtp_4 = new Int8Array(orrjtp); print(orrjtp_4[0]); orrjtp_4[0] = 1; var orrjtp_5 = new Int16Array(orrjtp); print(orrjtp_5[0]); var orrjtp_6 = new Float64Array(orrjtp); orrjtp_6[0] = 513; var orrjtp_7 = new Int16Array(orrjtp); /*iii*/([1,,]);/*hhh*/function cgfrqi(){e2.delete(g0);}h1.has = intern((({ get sort()\"use asm\";   var cos = stdlib.Math.cos;\n  var abs = stdlib.Math.abs;\n  var NaN = stdlib.NaN;\n  var Float64ArrayView = new stdlib.Float64Array(heap);\n  var Uint8ArrayView = new stdlib.Uint8Array(heap);\n  var Float32ArrayView = new stdlib.Float32Array(heap);\n  var Uint16ArrayView = new stdlib.Uint16Array(heap);\n  function f(d0, d1)\n  {\n    d0 = +d0;\n    d1 = +d1;\n    (Float64ArrayView[((((((((0xe8af0681)) & ((0xaeed7b33)))))-(e in a)+(0xfa1b61c2)))+(((((0x37fda7de) > (0xffffffff))-(0x8a02df5a)) | ((0x96592bdf)+(0xffffffff))))) >> 3]) = ((d0));\n    {\n      {\n        d1 = (d1);\n      }\n    }\n    {\n      (Float64ArrayView[((((Uint8ArrayView[((0x5ca5f7a8)) >> 0])) & (((0x74c9f283))-(0xfed5bf80))) / ((((((0x933e17b7)) >> ((0xfee259b7))))) | ((0xc6ce57c)-(!(0xf807443c))))) >> 3]) = ((+(((0xef4e1aae))>>>((((1.0) + (+(-1.0/0.0))) > (((d0)) % ((((+cos(((1152921504606847000.0))))) - ((d0))))))))));\n    }\nprint(\"\\u56DA\");    {\n      return +((Float32ArrayView[((((((((0x60acfb22) ? (-0x8000000) : (0xfd176106))-((0xef7aa874) ? (0x623b7c33) : (0x37f65bf))))+(0x9e1c311a)) >> (-0x6a1c6*(0x20402581))))) >> 2]));\n    }\n    (Uint16ArrayView[(((~(((+(-1.0/0.0)) != (d1))-((0x312acfc8) ? (0xfa845e51) : (0xe7c6ff9b))-(0xebcf9b7f))))) >> 1]) = ((0xffffffff)+(0xd1cc9aad)-(0x1955e52));\n    (Float32ArrayView[(((~~(+(-1.0/0.0))) != (~~(d0)))-(0x596f2a0f)) >> 2]) = ((((d0)) % ((d0))));\n    (Uint16ArrayView[4096]) = ((0x72ed305b));\n    d1 = ((x >> a));\n    d0 = (+(-1.0/0.0));\n    return +((d1));\n    return +((d1));\n(d = Proxy.create(({/*TOODEEP*/})(-6),  '' ));    d1 = (+abs(((NaN))));\n    d0 = (d1);\n    return +((+(abs(((0xfffff*((d1) < (+(((0xf867b300)) >> ((-0x5b5e539)))))) | ((-0x8000000)+(1))))|0)));\n  }\n  return f;, apply: true })));let(y) { yield Object.defineProperty(orrjtp_1[9], \"0\", ({enumerable: (orrjtp_6 % 2 == 0)}));}throw b;a1 = r1.exec(s0);");
/*FRC*/Random.twister.import_mta(1123641334,-979066447,1268424036,1656536725,1963286273,693950839,1914888423,1002444464,-1033052119,1939874880,626055061,1322425048,-629490143,-1133755068,458551931,1956071758,2100731764,-925802053,-1617963670,-1337801370,2112579282,652199661,2137336134,-992839468,975293065,1103134140,-412354019,559832564,-2010259841,-1312021498,-695860794,-423189239,1281982446,1670368709,-1286539852,2063531940,-1058527679,1101805389,-1489200650,1601349665,1611088075,-325579571,-1874808205,1064244510,-885789979,228075334,746987159,-1769573803,-1624537462,-641371144,1394614279,-508392042,100464668,1986804360,912965263,-217204500,1568439854,1679944014,1128319308,-339050092,-1117756736,-1476397536,1229106207,1002495128,-169547071,-2052381418,1925030984,-1095619950,-1682407576,1579927976,492569576,648752705,1928698294,-674157636,125810249,1829409550,-533722752,-2131299630,-275553677,-776639474,-1619544541,550355951,1006439336,1007027316,1135293279,-1985824646,586214019,2025143373,-1316209048,-611159043,-131563147,1654459467,1977861598,-1100558193,-1039500529,-978726973,824885298,793274336,-1318885449,50123935,563427653,1152482793,-1149709244,1303550006,384507006,-656785871,753937304,-1754261475,2035702117,860929657,-137037684,1183216140,2031360051,-1424111496,1223585758,1150100339,-1643877906,874392565,1357584253,1079664658,-495781673,223347088,-976070886,996849318,-1330673676,1545436492,-568419513,982980307,-2078627536,1494454599,-1084848473,1230630420,-130840787,-642416546,1801433201,69689483,-2146796545,-43142000,-1427659040,-12941350,-800347410,901784261,-621934954,1709766896,-1716228173,1512291198,2129419853,-70690822,-2057315713,-11627134,1625945418,-1509197310,-692078611,-681046429,-2017214245,1119869530,912775214,-1766284235,630065569,231923499,-924182191,948722060,-297862698,-2108802173,-1135655172,-109632022,46567584,-1734794441,1731514467,607422581,-977569903,824887412,908788145,112402399,484706134,308034691,2071208756,-595695541,-899204801,730213559,-2087195419,1461343549,2097119124,1293282240,1158479474,-1315790992,1563738508,-776803636,-1613964861,2137630218,-1495257162,-1615632983,-430345901,-1856137115,1362687492,-1486921054,-196410028,886068478,113919803,-1707834811,-1467707893,953499245,1306120651,-1801459248,-1638094085,1756192331,-1830074195,-1687367810,-1885973466,-642900223,1524726018,-2121852445,1775562109,-1219435127,-280338995,942178701,177397374,1072599801,-1644806971,-881063670,1834649974,317086324,20627245,494174389,-793118843,-1931031453,694776864,-1245958757,222109755,472423043,-951955605,-317856702,-1614724636,1839668939,-1758026511,-1144797840,-1618900890,-1557279897,494905542,-1677721915,392816570,-1331246671,1085480817,-659337089,-106620841,-263857071,-1588092727,-1442343985,-1312627132,1483232540,-219489594,8172049,-30458497,-1543969097,716365265,690058094,-130588398,487546946,457319123,1432002956,-507358944,-1894308475,-376795188,-298998147,-549911959,-1371435142,-943686222,2017667219,-1835286174,-476424822,567595177,749615374,1757161725,203993948,-1706963423,1466423956,-1841168060,614497347,213443417,-1944195513,-906177927,-365307878,-1724387280,-266017616,1649332141,40601165,1733571001,1243505852,522519488,-1256658217,-211724690,-1012823829,-291859258,-2115331666,1898130135,-831244185,565265718,-542829704,-1282470893,-1206795892,843800961,1473255024,903749916,530519799,-505461472,-1548610459,417250018,1105510823,-897643798,741729597,1197637946,-1531615393,1504212036,-1408035138,1162998797,2134687178,-387147768,417306967,-1270764900,545528204,355399358,1760766751,-1557163061,1060222019,1142904097,-131190803,1775898954,-591002969,131817777,1334039080,-191856873,-178173346,301478820,-1692535643,-636968150,252860808,-1180948203,2048974719,152525076,543291954,-1845002645,-330246479,-136845369,1799629580,665541077,53812313,479687792,-1929273158,885930909,-2044458138,731017665,458671918,-1484943785,-1092105641,1292109871,1839613135,-429215896,33250555,972647193,-1615552489,-1822177154,-2093215116,-640852099,531433511,41434303,-529092114,-191500319,-1942831661,-525044301,907643704,-2041512541,510173793,-1764926426,-916871925,-1872752955,-1354213401,119403032,912016696,-1191343596,-995555843,-640653651,-1636142257,-181605158,-829254109,-278100196,133728846,-1428163518,-1000758078,1593351783,-1348174166,1314218101,-475981150,-1691524022,407557426,-908397032,1938430159,1474066770,-1382324690,589238809,-1480282687,-520074977,-2135725795,1303038661,-479420607,1450386158,-1312077094,719231374,-1671133394,-441584191,-580002864,1088119251,-794701247,-1496190906,-2061191225,1003410323,1022235276,374049088,172786989,-2075690261,1990149117,50304602,1348888018,-326269762,-1380946656,190193172,-1330573915,1157095497,-641286588,67151316,1625359051,1082846871,-558598384,-1996613671,1930301353,-644571327,2115007647,-1156743515,369101281,-1150616598,-351233847,1197099075,2081833453,-1101854048,-969723457,470772831,630900218,-914704241,1821496542,224051601,1757348258,-649462798,-1769849024,1600230347,636015176,257744036,-711606560,-1189268011,656479057,741992451,1987314697,1517374260,-541406147,2043838525,-258505493,-834520491,1077011463,1918221836,1870803099,-394233671,1329029516,-1228142627,1050900864,1621377478,2053465627,-153896237,1566225048,-729339301,946686665,-1350118669,1132500516,1943466581,898023429,1247542525,-1408891528,1749968352,354543404,-2027011081,2060594479,873291046,800827680,1923376862,-1056780422,-781197758,-1437614933,1066132777,100110861,-430964606,-1691112329,-524178244,-145495832,-397035421,-1770035940,1998103835,-1390448190,-2089833728,493364405,-1901521560,-1778124573,317066558,-1388468923,-918335972,-28651610,905617894,-1761013145,1395247045,-484587687,170820920,-1835591769,2133590541,142092023,-535559419,-1503806815,-215672361,1176723452,191010875,174362381,606770135,-1398856648,2072885882,923300278,149715