
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH stripline_calc "n" "" "Wcalc" "Wcalc Commands"
.B stripline_calc
- Symmetric stripline transmission line analysis

.SH SYNOPSIS
stripline_calc w h l tmet rho rough er tand f 

.SH INPUT PARAMETERS

.TP 10
w
: width of stripline line (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
l
: lentgh of stripline line (meters)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of the line (relative to copper)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
er
: substrate relative permitivitty
.TP 10
tand
: substrate loss tangent
.TP 10
f
: analysis frequency (Hz)

.SH OUTPUT VALUES

.TP 10
z0
: calculated characteristic impedance (Ohms)
.TP 10
elen
: calculated electrical length of the line (degrees)
.TP 10
loss
: calculated loss of the line (dB)
.TP 10
L
: calculated inductance per length (Henries/meter)
.TP 10
R
: calculated resistance per length (Ohms/meter)
.TP 10
C
: calculated capacitance per length (Farads/meter)
.TP 10
G
: calculated conductance per length (Siemens/meter)
.TP 10
lc
: conductor loss (dB/meter)
.TP 10
ld
: dielectric loss (dB/meter)
.TP 10
deltal
: calculated open circuit end correction (meters)
.TP 10
depth
: calculated skin depth (meters)
.SH DESCRIPTION

Function to analyze the electrical characteristics of a single 
stripline transmission line. The physical
dimensions of the stripline line are given as inputs and the
characteristic impedance, effective dielectric constant, loss and
open circuit end correction are calculated.


.NF



    XXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXXX
    ----------------------------------------------
   (  dielectric,er         \\/           /|\\     (
    )             -------   --            |       )
   (             | metal | Tmet           | H    (
    )             -------   --            |       )
   (             <---W--->  /\\           \\|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXXX



.FI

.SH EXAMPLE
.nf

*
* 50.00 Ohms
stripline_calc 1.478e-3 2.0e-3 1.0 0.0  1.72e-8 0.0 2.55 0.001 1e9
* 49.95 Ohms
stripline_calc 1.478e-3 2.0e-3 1.0 2e-6 1.72e-8 0.0 2.55 0.001 1e9
*
  
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
