
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH coax_syn "n" "" "Wcalc" "Wcalc Commands"
.B coax_syn
- Coaxial transmission line synthesis

.SH SYNOPSIS
coax_syn a b c t rho_a rho_b er tand len f flag 

.SH INPUT PARAMETERS

.TP 10
a
: radius of inner conductor (meters)
.TP 10
b
: inner radius of outer conductor (meters)
.TP 10
c
: offset of the inner conductor from the center (meters)
.TP 10
t
: thickness of shield (meters)
.TP 10
rho_a
: resistivity of inner conductor (ohms/meter)
.TP 10
rho_b
: resistivity of outer conductor (ohms/meter)
.TP 10
er
: relative permitivitty of dielectric
.TP 10
tand
: loss tangent of dielectric
.TP 10
len
: physical length of line (meters)
.TP 10
f
: operating frequency (Hertz)
.TP 10
flag
: indicates which parameters should be optimized
    
.RS
.TP 10
flag=0
: synthesize a
.TP 10
flag=1
: synthesize b
.TP 10
flag=2
: synthesize c
.TP 10
flag=3
: synthesize er
.RE


.SH OUTPUT VALUES

.TP 10
a_out
: synthesized radius of inner conductor (meters)
.TP 10
b_out
: synthesized inner radius of outer conductor (meters)
.TP 10
c_out
: synthesized offset of the inner conductor from the center (meters)
.TP 10
er_out
: synthesized relative permitivitty of dielectric
.TP 10
len
: synthesized physical length of line (meters)
.SH DESCRIPTION

Function to synthesize the physical parameters of a
coaxial transmission line to achieve a given set of
electrical characteristics.

.SH EXAMPLE
.nf

*
coax_syn 75 90 0.25 2 0 1 3.5e-8 3.5e-8 1.0 0.0 1.0e9 0
*
  
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
