
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH air_coil_syn "n" "" "Wcalc" "Wcalc Commands"
.B air_coil_syn
- Single layer air core solenoid inductor synthesis

.SH SYNOPSIS
air_coil_syn L len fill AWG rho dia freq flag 

.SH INPUT PARAMETERS

.TP 10
L
: Desired inductance (Henries)
.TP 10
len
: length of the coil (meters)
.TP 10
fill
: ratio of coil length to closewound length
.TP 10
AWG
: wire size (American Wire Gauge)
.TP 10
rho
: resistivity of wire (ohm-m)
.TP 10
dia
: inside diameter of coil (meters)
.TP 10
freq
: analysis frequency (Hertz)
.TP 10
flag
: indicates which parameters should be optimized
    
.RS
.TP 10
flag=0
: the minimum number of turns is calculated
	along with the corresponding required length/fill.  The diameter is
	held constant.
.TP 10
flag=1
: the number of turns is fixed at the value
        given and the required length/fill is calculated.  The
	diameter is held constant.
.RE


.SH OUTPUT VALUES

.TP 10
N_out
: calculated required number of turns
.TP 10
len_out
: calculated required length (meters)
.TP 10
fill_out
: calculated required fill
.SH DESCRIPTION

Function to synthesize the physical parameters of a single layer,
uniformly spaced, air core, solenoid inductor.  The physical
dimensions of the coil are synthesized from an inductance 
specification.

.SH EXAMPLE
.nf

*
* Air coil synthesis, flag == 0 (minimize # of turns)
*
air_coil_syn 100e-9 6 0.0127 1.2 22 1.72e-8 0.00635 100e6 0

*
* Air coil synthesis, flag == 1 (fixed # of turns)
*
air_coil_syn 100e-9 6 0.0127 1.2 22 1.72e-8 0.00635 100e6 1
*
       
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
