
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH air_coil_calc "n" "" "Wcalc" "Wcalc Commands"
.B air_coil_calc
- Single layer air core solenoid inductor analysis

.SH SYNOPSIS
air_coil_calc N len fill AWG rho dia freq flag 

.SH INPUT PARAMETERS

.TP 10
N
: Number of turns
.TP 10
len
: length of the coil (meters)
.TP 10
fill
: ratio of coil length to closewound length
.TP 10
AWG
: wire size (American Wire Gauge)
.TP 10
rho
: resistivity of wire (ohm-m)
.TP 10
dia
: inside diameter of coil (meters)
.TP 10
freq
: analysis frequency (Hertz)
.TP 10
flag
: used to calculate coil length.
 
.RS
.TP 10
flag=0
: the length given by len is used.
.TP 10
flag=1
: the length is calculated from the wire size,
 number of turns and fill input.
.RE


.SH OUTPUT VALUES

.TP 10
L
: calculated inductance (Henries)
.TP 10
Q
: calculated quality factor
.TP 10
SRF
: calculated self resonant frequency (Hertz)
.TP 10
len_out
: length used for the analysis (meters)
.TP 10
fill_out
: fill used for the analysis
.TP 10
lmax
: maximum (closewound) inductance
.SH DESCRIPTION

Function to analyze the electrical characteristics of a single layer,
uniformly spaced, air core, solenoid inductor.  The physical
dimensions of the coil are given as inputs and the inductance, quality
factor, and self resonant frequency are calculated.

.SH EXAMPLE
.nf

*
* Air coil calculation using length
*
air_coil_calc 6 0.0127 1.2 22 1.72e-8 0.00635 100e6 0
*
*
* Air coil calculation using fill
*
air_coil_calc 6 0.0127 1.2 22 1.72e-8 0.00635 100e6 1
*
       
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coplanar_calc(n), coplanar_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), coupled_stripline_calc(n), coupled_stripline_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
