
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH coupled_stripline_calc "" "" "Wcalc" "Wcalc Commands"
.B coupled_stripline_calc
- Coupled stripline transmission line analysis

.SH SYNOPSIS

[z0, k, z0e, z0o, kev, kev, loss, deltal] = 
coupled_stripline_calc(w, s, h, l, tmet, rho, rough, er, tand, f)


.SH INPUT PARAMETERS

.TP 10
w
: width of coupled stripline lines (meters)
.TP 10
s
: spacing between coupled stripline lines (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
l
: lentgh of coupled stripline line (meters)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of the metal (ohm-meters)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
er
: substrate relative permitivitty
.TP 10
tand
: substrate loss tangent
.TP 10
f
: analysis frequency (Hz)

.SH OUTPUT VALUES

.TP 10
z0
: calculated characteristic impedance (Ohms)
.TP 10
k
: calculated coupling coefficient
.TP 10
z0e
: calculated even mode characteristic impedance (Ohms)
.TP 10
z0o
: calculated odd mode characteristic impedance (Ohms)
.TP 10
kev
: calculated even mode effective relative permitivitty
.TP 10
kev
: calculated odd mode effective relative permitivitty
.TP 10
loss
: calculated loss of the line (dB)
.TP 10
deltal
: calculated open circuit end correction (meters)
.SH DESCRIPTION

Function to analyze the electrical characteristics of a 
coupled stripline transmission line. The physical
dimensions of the coupled stripline line are given as inputs and the
characteristic impedance, effective dielectric constant, loss and
open circuit end correction are calculated.

The model accounts for dispersion (frequency dependent propagation
velocity).


.NF



              |<--W-->|<-S->|<--W-->|
               _______       -------
              | metal |     | metal | <- rho,rough
    ----------------------------------------------
   (  dielectric                         /|\     (
    )   er,tand                       H   |       )
   (                                     \|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXX



.FI

.SH EXAMPLE
.nf

.TP
 // mils to meters conversion factor
sf=25.4e-6;
.TP
 // width 
w=20*sf;
.TP
 // spacing
s=8*sf;
.TP
 // height
h=15*sf;
.TP
 // length
l=1100*sf;
.TP
 // metal thickness
tmet=1.4*sf;
.TP
 // resitivity relative to copper
rho=1;
.TP
 // metal surface roughness
rough=0.05*sf;
.TP
 // relative dielectric constant
er=4.5;
.TP
 // loss tangent
tand=0.01;
.TP
 // frequency
f=2.4e9;
[z0,k,z0e,z0o,kev,kodd] = ...
  coupled_stripline_calc(w,s,h,l,tmet,rho,rough,er,tand,f);
disp(sprintf('z0=%g Ohms, k=%g',z0,k));
disp(sprintf('z0e=%g Ohms, z0o=%g Ohms',z0e,z0o));
disp(sprintf('kev=%g, kodd=%g',kev,kodd));
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(), air_coil_syn(), coax_calc(), coax_syn(), coplanar_calc(), coplanar_syn(), coupled_microstrip_calc(), coupled_microstrip_syn(), coupled_stripline_calc(), coupled_stripline_syn(), ic_microstrip_calc(), ic_microstrip_syn(), microstrip_calc(), microstrip_syn(), stripline_calc(), stripline_syn()
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
