;; Tests for i8x16 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i8x16.add_sat_s") (param v128 v128) (result v128) (i8x16.add_sat_s (local.get 0) (local.get 1)))
  (func (export "i8x16.add_sat_u") (param v128 v128) (result v128) (i8x16.add_sat_u (local.get 0) (local.get 1)))
  (func (export "i8x16.sub_sat_s") (param v128 v128) (result v128) (i8x16.sub_sat_s (local.get 0) (local.get 1)))
  (func (export "i8x16.sub_sat_u") (param v128 v128) (result v128) (i8x16.sub_sat_u (local.get 0) (local.get 1)))
)


;; i8x16.add_sat_s
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                         (v128.const i8x16 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                         (v128.const i8x16 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i8x16 0x01 0x01 0x81 0x7f 0x01 0x01 0x81 0x7f 0x01 0x01 0x81 0x7f 0x01 0x01 0x81 0x7f))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i8x16 0x01 0x01 0x81 0 0x01 0x01 0x81 0 0x01 0x01 0x81 0 0x01 0x01 0x81 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i8x16 0x01 0x01 0xc1 0x7f 0x01 0x01 0xc1 0x7f 0x01 0x01 0xc1 0x7f 0x01 0x01 0xc1 0x7f))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i8x16 0x01 0x01 0xc1 0 0x01 0x01 0xc1 0 0x01 0x01 0xc1 0 0x01 0x01 0xc1 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 0xff 0xfe 0xfd 0xfc 0xfb 0xfa 0xf9 0xf8 0xf7 0xf6 0xf5 0xf4 0xf3 0xf2 0xf1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.add_sat_s" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30))
                                         (v128.const i8x16 0 3 6 9 12 15 18 21 24 27 30 33 36 39 42 45))

;; i8x16.add_sat_u
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 129 129 129 129 129 129 129 129 129 129 129 129 129 129 129 129))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                         (v128.const i8x16 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i8x16 0x80 0x80 0x80 0xff 0x80 0x80 0x80 0xff 0x80 0x80 0x80 0xff 0x80 0x80 0x80 0xff))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i8x16 0x01 0x01 0x81 0x80 0x01 0x01 0x81 0x80 0x01 0x01 0x81 0x80 0x01 0x01 0x81 0x80))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i8x16 0x01 0x01 0x81 0xff 0x01 0x01 0x81 0xff 0x01 0x01 0x81 0xff 0x01 0x01 0x81 0xff))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i8x16 0x01 0x01 0xc1 0x80 0x01 0x01 0xc1 0x80 0x01 0x01 0xc1 0x80 0x01 0x01 0xc1 0x80))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i8x16 0x01 0x01 0xc1 0xff 0x01 0x01 0xc1 0xff 0x01 0x01 0xc1 0xff 0x01 0x01 0xc1 0xff))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 0xff 0xfe 0xfd 0xfc 0xfb 0xfa 0xf9 0xf8 0xf7 0xf6 0xf5 0xf4 0xf3 0xf2 0xf1))
                                         (v128.const i8x16 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.add_sat_u" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30))
                                         (v128.const i8x16 0 3 6 9 12 15 18 21 24 27 30 33 36 39 42 45))

;; i8x16.sub_sat_s
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 124 124 124 124 124 124 124 124 124 124 124 124 124 124 124 124))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125 -125))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i8x16 0x80 0x80 0x80 0 0x80 0x80 0x80 0 0x80 0x80 0x80 0 0x80 0x80 0x80 0))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i8x16 0x01 0x01 0x7f 0x82 0x01 0x01 0x7f 0x82 0x01 0x01 0x7f 0x82 0x01 0x01 0x7f 0x82))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i8x16 0x01 0x01 0x7f 0x02 0x01 0x01 0x7f 0x02 0x01 0x01 0x7f 0x02 0x01 0x01 0x7f 0x02))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i8x16 0x01 0x01 0x41 0x82 0x01 0x01 0x41 0x82 0x01 0x01 0x41 0x82 0x01 0x01 0x41 0x82))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i8x16 0x01 0x01 0x41 0x02 0x01 0x01 0x41 0x02 0x01 0x01 0x41 0x02 0x01 0x01 0x41 0x02))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 0xff 0xfe 0xfd 0xfc 0xfb 0xfa 0xf9 0xf8 0xf7 0xf6 0xf5 0xf4 0xf3 0xf2 0xf1))
                                         (v128.const i8x16 0 0x02 0x04 0x06 0x08 0x0a 0x0c 0x0e 0x10 0x12 0x14 0x16 0x18 0x1a 0x1c 0x1e))
(assert_return (invoke "i8x16.sub_sat_s" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30))
                                         (v128.const i8x16 0 -1 -2 -3 -4 -5 -6 -7 -8 -9 -10 -11 -12 -13 -14 -15))

;; i8x16.sub_sat_u
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                         (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63 -63)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65 -65)
                                         (v128.const i8x16 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64 -64))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 124 124 124 124 124 124 124 124 124 124 124 124 124 124 124 124))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126 -126)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127 -127))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40)
                                         (v128.const i8x16 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f -0x3f)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40 -0x40)
                                         (v128.const i8x16 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41 -0x41))
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126 126))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i8x16 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                         (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i8x16 0x80 0x80 0x80 0 0x80 0x80 0x80 0 0x80 0x80 0x80 0 0x80 0x80 0x80 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i8x16 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i8x16 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i8x16 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i8x16 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0 0x01 0x01 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 0xff 0xfe 0xfd 0xfc 0xfb 0xfa 0xf9 0xf8 0xf7 0xf6 0xf5 0xf4 0xf3 0xf2 0xf1))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.sub_sat_u" (v128.const i8x16 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
                                         (v128.const i8x16 0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30))
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))

;; Malformed cases: non-existent op names
(assert_malformed (module quote
    "(func (result v128) (i8x16.add_sat (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.sub_sat (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.mul_sat (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.div_sat (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.add_sat_s (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.add_sat_u (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.sub_sat_s (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.sub_sat_u (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (f32x4.add_sat_s (v128.const f32x4 0 0 0 0) (v128.const f32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (f32x4.add_sat_u (v128.const f32x4 0 0 0 0) (v128.const f32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (f32x4.sub_sat_s (v128.const f32x4 0 0 0 0) (v128.const f32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (f32x4.sub_sat_u (v128.const f32x4 0 0 0 0) (v128.const f32x4 0 0 0 0)))")
    "unknown operator")

;; type check
(assert_invalid (module (func (result v128) (i8x16.add_sat_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.add_sat_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.sub_sat_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.sub_sat_u (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i8x16.add_sat_s-1st-arg-empty (result v128)
      (i8x16.add_sat_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.add_sat_s-arg-empty (result v128)
      (i8x16.add_sat_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.add_sat_u-1st-arg-empty (result v128)
      (i8x16.add_sat_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.add_sat_u-arg-empty (result v128)
      (i8x16.add_sat_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.sub_sat_s-1st-arg-empty (result v128)
      (i8x16.sub_sat_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.sub_sat_s-arg-empty (result v128)
      (i8x16.sub_sat_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.sub_sat_u-1st-arg-empty (result v128)
      (i8x16.sub_sat_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.sub_sat_u-arg-empty (result v128)
      (i8x16.sub_sat_u)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "sat-add_s-sub_s") (param v128 v128 v128) (result v128)
    (i8x16.add_sat_s (i8x16.sub_sat_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_s-sub_u") (param v128 v128 v128) (result v128)
    (i8x16.add_sat_s (i8x16.sub_sat_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_u-sub_s") (param v128 v128 v128) (result v128)
    (i8x16.add_sat_u (i8x16.sub_sat_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_u-sub_u") (param v128 v128 v128) (result v128)
    (i8x16.add_sat_u (i8x16.sub_sat_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_s-neg") (param v128 v128) (result v128)
    (i8x16.add_sat_s (i8x16.neg (local.get 0)) (local.get 1)))
  (func (export "sat-add_u-neg") (param v128 v128) (result v128)
    (i8x16.add_sat_u (i8x16.neg (local.get 0)) (local.get 1)))
  (func (export "sat-sub_s-neg") (param v128 v128) (result v128)
    (i8x16.sub_sat_s (i8x16.neg (local.get 0)) (local.get 1)))
  (func (export "sat-sub_u-neg") (param v128 v128) (result v128)
    (i8x16.sub_sat_u (i8x16.neg (local.get 0)) (local.get 1)))
)

(assert_return (invoke "sat-add_s-sub_s" (v128.const i8x16 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "sat-add_s-sub_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                         (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "sat-add_u-sub_s" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                         (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                         (v128.const i8x16 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254 254))
(assert_return (invoke "sat-add_u-sub_u" (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255)
                                         (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                         (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                         (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "sat-add_s-neg" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                       (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                       (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "sat-add_u-neg" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                       (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                       (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
(assert_return (invoke "sat-sub_s-neg" (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128)
                                       (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127))
                                       (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
(assert_return (invoke "sat-sub_u-neg" (v128.const i8x16 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127)
                                       (v128.const i8x16 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128 -128))
                                       (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))