export function scheduleTask(task, module, memory) {
    postMessage([task, module, memory]);
}

export function isWorker() {
    return 'WorkerGlobalScope' in self && self instanceof WorkerGlobalScope;
}

// Second: Entry script for the actual web worker.
if (isWorker()) {
    //console.log("pool::worker(entry) started");
    Error.stackTraceLimit = 50;

    // Initialize wasm module, and memory. `state` is the shared state,
    // to be used with `worker_entry_point`.
    self.onmessage = async ev => {
        // This crate only works with bundling via webpack or not
        // using a bundler at all:
        // When bundling with webpack, this file is relative to the wasm
        // module file (or package.json) located in `../../..` generated by
        // wasm-pack.
        if (ev.data.length == 3) {
            let [module, memory, state] = ev.data;
            const {
                default: init,
                worker_entry_point,
            } = await import('../../..');
            await init(module, memory);

            worker_entry_point(state);
        } else {
            var is_returned = false;
            try {
                let [id, module, memory, ctx, wasm_module, wasm_memory, wasm_cache] = ev.data;
                const {
                    default: init,
                    wasm_entry_point,
                } = await import('../../..');
                await init(module, memory);

                wasm_entry_point(ctx, wasm_module, wasm_memory, wasm_cache);

                // Return the web worker to the thread pool
                postMessage([id]);
                is_returned = true;
            } finally {
                //Terminate the worker
                if (is_returned == false) {
                    close();
                }
            }
        }
    }
}
