# Summary

- [快速开始](index.md)
  - [WasmEdge 的安装与卸载](start/install.md)
  - [使用 Docker 进行 WasmEdge 应用程序开发](start/docker.md)
  - [WasmEdge 命令行](start/cli.md)
  - [通用 wasm 二进制格式](start/universal.md)

- [WasmEdge 介绍](intro.md)
  - [应用场景](intro/use.md)
    - [云原生的 runtime](intro/use/runtime.md)
    - [JavaScript 或 DSL runtime](intro/use/js.md)
    - [公有云中的 Serverless 函数即服务](intro/use/serverless.md)
    - [边缘计算](intro/use/edge.md)
    - [SaaS 里的嵌入式函数](intro/use/saas.md)
  - [WasmEdge 的优势与特点](intro/features.md)
  - [WebAssembly 的标准扩展](intro/standard.md)
  - [WasmEdge 特有的扩展](intro/proprietary.md)
  - [与外部框架的集成](intro/integrations.md)
  - [FAQ](intro/faq.md)

- [开发 WasmEdge 应用](dev.md)
  - [Rust](dev/rust.md)
    - [调用 Rust 函数](dev/rust/bindgen.md)
    - [使用操作系统服务](dev/rust/wasi.md)
    - [Tensorflow](dev/rust/tensorflow.md)
    - [简单的 HTTP 客户端和服务器](dev/rust/networking.md)
    - [非阻塞网络应用](dev/rust/networking-nonblocking.md)
    - [服务端渲染](dev/rust/ssr.md)
    - [命令行接口](dev/rust/command.md)
  - [JavaScript](dev/js.md)
    - [快速开始](dev/js/quickstart.md)
    - [网络](dev/js/networking.md)
    - [Fetch](dev/js/fetch.md)
    - [Tensorflow 推理](dev/js/tensorflow.md)
    - [示例：React SSR](dev/js/ssr.md)
    - [ES6 模块](dev/js/es6.md)
    - [NodeJS &amp; NPM 模块](dev/js/npm.md)
    - [用 Rust 实现 JS API](dev/js/rust.md)
  - [Python](dev/python.md)
  - [Go](dev/go.md)
  - [Swift](dev/swift.md)
  - [AssemblyScript](dev/as.md)
  - [Kotlin](dev/kotlin.md)
  - [Grain](dev/grain.md)

- [嵌入 WasmEdge 函数](embed.md)
  - [C SDK](embed/c.md)
    - [API 参考文档](embed/c/ref.md)
  - [Go SDK](embed/go.md)
    - [嵌入 WASM 应用程序](embed/go/app.md)
    - [嵌入 WASM 函数](embed/go/function.md)
    - [传递复杂参数](embed/go/memory.md)
    - [Tensorflow 调用](embed/go/tensorflow.md)
    - [编写 Host Function](embed/go/host_function.md)
    - [使用 wasm-bindgen](embed/go/bindgen.md)
    - [API 参考文档](embed/go/ref.md)
  - [Node.js SDK](embed/node.md)
  - [Rust SDK](embed/rust.md)
    - [使用 WasmEdge 底层 Rust API 运行 WebAssembly 函数](embed/rust/sys_run_host_func.md)
    - [并行计算斐波那契数](embed/rust/concurrent_fib.md)
  - [Python SDK](embed/python.md)

- [用 Kubernetes 管理 WasmEdge 应用](kubernetes.md)
  - [快速开始](kubernetes/quickstart.md)
  - [应用示例](kubernetes/demo.md)
    - [简单的 WASI 例子](kubernetes/demo/wasi.md)
    - [HTTP 微服务](kubernetes/demo/server.md)
  - [容器 runtimes](kubernetes/container.md)
    - [crun](kubernetes/container/crun.md)
    - [runc](kubernetes/container/runc.md)
    - [youki](kubernetes/container/youki.md)
  - [CRI runtimes](kubernetes/cri.md)
    - [CRI-O](kubernetes/cri/crio.md)
    - [containerd](kubernetes/cri/containerd.md)
  - [Kubernetes](kubernetes/kubernetes.md)
    - [Kubernetes + CRI-O](kubernetes/kubernetes/kubernetes-crio.md)
    - [Kubernetes + containerd](kubernetes/kubernetes/kubernetes-containerd.md)
    - [KinD](kubernetes/kubernetes/kind.md)
    - [KubeEdge](kubernetes/kubernetes/kubeedge.md)
    - [SuperEdge](kubernetes/kubernetes/superedge.md)
    - [OpenYurt](kubernetes/kubernetes/openyurt.md)
    - [Knative](kubernetes/kubernetes/knative.md)

- [应用框架与平台](frameworks.md)
  - [Service mesh 与分布式框架](frameworks/mesh.md)
    - [Dapr](frameworks/mesh/dapr.md)
    - [MOSN](frameworks/mesh/mosn.md)
    - [Apache EventMesh](frameworks/mesh/eventmesh.md)
  - [应用框架](frameworks/app.md)
    - [YoMo](frameworks/app/yomo.md)
    - [Reactr](frameworks/app/reactr.md)
  - [Serverless 平台](frameworks/serverless.md)
    - [Vercel](frameworks/serverless/vercel.md)
    - [Netlify](frameworks/serverless/netlify.md)
    - [AWS](frameworks/serverless/aws.md)
    - [Tencent](frameworks/serverless/tencent.md)
    - [Second State](frameworks/serverless/secondstate.md)

- [操作系统](os.md)
  - [Linux](os/linux.md)
  - [Windows](os/windows.md)
  - [Mac](os/mac.md)
  - [Android](os/android.md)
  - [seL4](os/sel4.md)
  - [Open Harmony](os/openharmony.md)
  - [Raspberry Pi](os/raspberrypi.md)

- [为 WasmEdge 贡献代码](extend.md)
  - [编译 WasmEdge](extend/build.md)
    - [用 Mac 编译](extend/build_on_mac.md)
    - [用 Windows 编译](extend/build_on_windows.md)
    - [为 Android 编译](extend/build_for_android.md)
  - [WasmEdge plug-in API](extend/plugin.md)
    - [Host 函数](extend/plugin/hostfunction.md)
    - [外部引用](extend/plugin/externref.md)
