# Summary

- [快速開始指引](index.md)
  - [安裝與解除安裝](start/install.md)
  - [使用 Docker image](start/docker.md)
  - [WasmEdge 命令列](start/cli.md)
  - [通用 Wasm binary 格式](start/universal.md)

- [什麼是 WasmEdge](intro.md)
  - [使用情境](intro/use.md)
    - [雲端原生 runtime](intro/use/runtime.md)
    - [JavaScript 或 DSL runtime](intro/use/js.md)
    - [公開雲端中的 Serverless 函式即服務](intro/use/serverless.md)
    - [邊緣運算](intro/use/edge.md)
    - [用於 SaaS 的互動函式](intro/use/saas.md)
  - [WasmEdge 的優勢與特色](intro/features.md)
  - [WebAssembly 標準擴充](intro/standard.md)
  - [WasmEdge 特有的擴充](intro/proprietary.md)
  - [與第三方框架結合](intro/integrations.md)
  - [FAQ](intro/faq.md)

- [開發 WasmEdge 應用程式](dev.md)
  - [Rust](dev/rust.md)
    - [使用系統服務](dev/rust/wasi.md)
    - [使用 Tensorflow](dev/rust/tensorflow.md)
    - [使用網路服務](dev/rust/networking.md)
    - [命令列接口](dev/rust/command.md)
    - [rustwasmc](dev/rust/bindgen.md)
  - [JavaScript](dev/js.md)
    - [快速開始](dev/js/quickstart.md)
    - [使用網路服務](dev/js/networking.md)
    - [Fetch](dev/js/fetch.md)
    - [使用 Tensorflow](dev/js/tensorflow.md)
    - [範例： React SSR](dev/js/ssr.md)
    - [ES6 模組](dev/js/es6.md)
    - [NodeJS &amp; NPM 模組](dev/js/npm.md)
    - [使用 Rust 實作 JS API](dev/js/rust.md)
  - [Python](dev/python.md)
  - [Go](dev/go.md)
  - [Swift](dev/swift.md)
  - [AssemblyScript](dev/as.md)
  - [Kotlin](dev/kotlin.md)
  - [Grain](dev/grain.md)

- [嵌入 WasmEdge 函式](embed.md)
  - [C SDK](embed/c.md)
    - [API 完整說明文件](embed/c/ref.md)
  - [Go SDK](embed/go.md)
    - [嵌入 WASM 應用程式](embed/go/app.md)
    - [嵌入 WASM 函式](embed/go/function.md)
    - [傳遞複雜參數](embed/go/memory.md)
    - [使用 Tensorflow](embed/go/tensorflow.md)
    - [使用 wasm-bindgen](embed/go/bindgen.md)
    - [API 完整說明文件](embed/go/ref.md)
  - [Node.js SDK](embed/node.md)
  - [Rust SDK](embed/rust.md)
  - [Python SDK](embed/python.md)

- [在 Kubernetes 使用 WasmEdge](kubernetes.md)
  - [快速開始](kubernetes/quickstart.md)
  - [Demo 範例](kubernetes/demo.md)
    - [基本 Wasm 範例](kubernetes/demo/wasi.md)
    - [HTTP 伺服器範例](kubernetes/demo/server.md)
  - [Runtimes 容器](kubernetes/container.md)
    - [crun](kubernetes/container/crun.md)
    - [runc](kubernetes/container/runc.md)
    - [youki](kubernetes/container/youki.md)
  - [CRI runtimes](kubernetes/cri.md)
    - [CRI-O](kubernetes/cri/crio.md)
    - [containerd](kubernetes/cri/containerd.md)
  - [Kubernetes](kubernetes/kubernetes.md)
    - [Kubernetes + CRI-O](kubernetes/kubernetes/kubernetes-crio.md)
    - [Kubernetes + containerd](kubernetes/kubernetes/kubernetes-containerd.md)
    - [KinD](kubernetes/kubernetes/kind.md)
    - [KubeEdge](kubernetes/kubernetes/kubeedge.md)
    - [SuperEdge](kubernetes/kubernetes/superedge.md)
    - [OpenYurt](kubernetes/kubernetes/openyurt.md)

- [應用程式框架與平台](frameworks.md)
  - [Service mesh 與分散式框架](frameworks/mesh.md)
    - [Dapr](frameworks/mesh/dapr.md)
    - [MOSN](frameworks/mesh/mosn.md)
    - [Apache EventMesh](frameworks/mesh/eventmesh.md)
  - [應用程式框架](frameworks/app.md)
    - [YoMo](frameworks/app/yomo.md)
    - [Reactr](frameworks/app/reactr.md)
  - [Serverless 平台](frameworks/serverless.md)
    - [Vercel](frameworks/serverless/vercel.md)
    - [Netlify](frameworks/serverless/netlify.md)
    - [AWS](frameworks/serverless/aws.md)
    - [Tencent](frameworks/serverless/tencent.md)
    - [Second State](frameworks/serverless/secondstate.md)

- [作業系統支援](os.md)
  - [Linux](os/linux.md)
  - [Windows](os/windows.md)
  - [Mac](os/mac.md)
  - [Android](os/android.md)
  - [seL4](os/sel4.md)
  - [Open Harmony](os/openharmony.md)
  - [Raspberry Pi](os/raspberrypi.md)

- [貢獻 WasmEdge](extend.md)
  - [從原始碼編譯 WasmEdge](extend/build.md)
    - [在 Mac 上編譯](extend/build_on_mac.md)
    - [在 Windows 上編譯](extend/build_on_windows.md)
    - [為 Android 編譯](extend/build_for_android.md)
  - [WasmEdge 外掛 API](extend/plugin.md)
    - [Host functions](extend/plugin/hostfunction.md)
    - [External references](extend/plugin/externref.md)
