# WasmEdge Features

WasmEdge is one of the fastest WebAssembly runtimes on the market (based on `LLVM AOT`).

* [A Lightweight Design for High-performance Serverless Computing](https://arxiv.org/abs/2010.07115), published on IEEE Software, Jan 2021. [https://arxiv.org/abs/2010.07115](https://arxiv.org/abs/2010.07115)
* [Performance Analysis for Arm vs. x86 CPUs in the Cloud](https://www.infoq.com/articles/arm-vs-x86-cloud-performance/), published on infoQ.com, Jan 2021. [https://www.infoq.com/articles/arm-vs-x86-cloud-performance/](https://www.infoq.com/articles/arm-vs-x86-cloud-performance/)
* [WasmEdge is the fastest WebAssembly Runtime in Suborbital Reactr test suite](https://blog.suborbital.dev/suborbital-wasmedge), Dec 2021

Besides, WasmEdge supports various [WebAssembly proposals](https://github.com/WebAssembly/proposals) and [WASI proposals](https://github.com/WebAssembly/proposals), as well as several non-standard extensions, which indicates that WasmEdge is an extensionable WebAssembly runtime. In this chapter, we'll introduce the key features of WasmEdge.

* Supported [WASM and WASI proposals](features/proposals.md)
* WasmEdge [proprietary extensions](features/proprietary_extend.md)
* Running WasmEdge on [various platforms](features/platforms.md)
* [Integrability of WasmEdge](features/integrations.md) on programming languages or frameworks
* [Compare with other containers](features/comparison.md)
