# Summary

- [Introduction](index.md)

- [Quick Start](quick_start.md)
  - [Installation And Uninstallation](quick_start/install.md)
  - [Using WasmEdge in Docker](quick_start/use_docker.md)
  - [Running WASM with WasmEdge CLI](quick_start/run_cli.md)
  - [Execution in AOT Mode](quick_start/run_in_aot_mode.md)

- [WasmEdge Features](features.md)
  - [Supported WASM And WASI Proposals](features/proposals.md)
  - [WasmEdge Proprietary extensions](features/proprietary_extend.md)
  - [Integrations](features/integrations.md)
  - [Supported Platforms](features/platforms.md)
  - [Comparison](features/comparison.md)

- [WasmEdge Use Cases](use_cases.md)
  - [Server-Side Rendering Modern Web UI](use_cases/server_side_render.md)
  - [Microservices](use_cases/microservice.md)
  - [Serverless Function-As-A-Service in Public Clouds](use_cases/serverless_faas.md)
  - [Serverless Software-As-A-Service Functions](use_cases/serverless_saas.md)
  - [Smart devices](use_cases/smart_device.md)
  - [JavaScript or Domain Specific Language Runtime](use_cases/js_or_dsl_runtime.md)
  - [WasmEdge in Kubernetes](use_cases/kubernetes.md)
    - [Quick start](use_cases/kubernetes/quickstart.md)
    - [Demo apps](use_cases/kubernetes/demo.md)
      - [Simple example](use_cases/kubernetes/demo/wasi.md)
      - [HTTP service](use_cases/kubernetes/demo/server.md)
    - [Container runtimes](use_cases/kubernetes/container.md)
      - [crun](use_cases/kubernetes/container/crun.md)
      - [runc](use_cases/kubernetes/container/runc.md)
      - [youki](use_cases/kubernetes/container/youki.md)
    - [CRI runtimes](use_cases/kubernetes/cri.md)
      - [CRI-O](use_cases/kubernetes/cri/crio.md)
      - [containerd](use_cases/kubernetes/cri/containerd.md)
    - [Kubernetes](use_cases/kubernetes/kubernetes.md)
      - [Kubernetes + CRI-O](use_cases/kubernetes/kubernetes/kubernetes-crio.md)
      - [Kubernetes + containerd](use_cases/kubernetes/kubernetes/kubernetes-containerd.md)
      - [KinD](use_cases/kubernetes/kubernetes/kind.md)
      - [KubeEdge](use_cases/kubernetes/kubernetes/kubeedge.md)
      - [SuperEdge](use_cases/kubernetes/kubernetes/superedge.md)
      - [OpenYurt](use_cases/kubernetes/kubernetes/openyurt.md)
      - [Knative](use_cases/kubernetes/kubernetes/knative.md)
    - [Docker](use_cases/kubernetes/docker.md)
      - [Slim container](use_cases/kubernetes/docker/lxc.md)
      - [containerd integration](use_cases/kubernetes/docker/containerd.md)
  - [App Frameworks &amp; Platforms](use_cases/frameworks.md)
    - [Service mesh &amp; runtimes](use_cases/frameworks/mesh.md)
      - [Dapr](use_cases/frameworks/mesh/dapr.md)
      - [MOSN](use_cases/frameworks/mesh/mosn.md)
      - [Nginx](use_cases/frameworks/mesh/wasm-nginx-module.md)
      - [Apache EventMesh](use_cases/frameworks/mesh/eventmesh.md)
    - [Application frameworks](use_cases/frameworks/app.md)
      - [YoMo](use_cases/frameworks/app/yomo.md)
      - [Reactr](use_cases/frameworks/app/reactr.md)
    - [Serverless platforms](use_cases/frameworks/serverless.md)
      - [Vercel](use_cases/frameworks/serverless/vercel.md)
      - [Netlify](use_cases/frameworks/serverless/netlify.md)
      - [AWS](use_cases/frameworks/serverless/aws.md)
      - [Tencent](use_cases/frameworks/serverless/tencent.md)
      - [Second State](use_cases/frameworks/serverless/secondstate.md)

- [Write a WebAssembly Application](write_wasm.md)
  - [C](write_wasm/c.md)
    - [Getting Started](write_wasm/c/quickstart.md)
    - [simd](write_wasm/c/simd.md)
  - [Rust](write_wasm/rust.md)
    - [Bindgen of Rust Functions](write_wasm/rust/bindgen.md)
    - [Access OS Services](write_wasm/rust/wasi.md)
    - [TensorFlow](write_wasm/rust/tensorflow.md)
    - [Neural Network for WASI](write_wasm/rust/wasinn.md)
    - [Crypto for WASI](write_wasm/rust/wasicrypto.md)
    - [Simple HTTP Client & Server](write_wasm/rust/networking.md)
    - [Simple HTTPS Client & Server](write_wasm/rust/networking-https.md)
    - [Non-Blocking Network Apps](write_wasm/rust/networking-nonblocking.md)
    - [Server-Side Rendering](write_wasm/rust/ssr.md)
    - [Command Interface](write_wasm/rust/command.md)
  - [JavaScript](write_wasm/js.md)
    - [Getting Started](write_wasm/js/quickstart.md)
    - [Node.js Compatibility](write_wasm/js/nodejs.md)
    - [Networking Apps](write_wasm/js/networking.md)
    - [React SSR](write_wasm/js/ssr.md)
    - [TensorFlow](write_wasm/js/tensorflow.md)
    - [ES6 Modules](write_wasm/js/es6.md)
    - [Node.js &amp; NPM Modules](write_wasm/js/npm.md)
    - [Built-in Modules](write_wasm/js/modules.md)
    - [Native JS API in Rust](write_wasm/js/rust.md)
  - [Go](write_wasm/go.md)
  - [Swift](write_wasm/swift.md)
  - [AssemblyScript](write_wasm/as.md)
  - [Kotlin](write_wasm/kotlin.md)
  - [Grain](write_wasm/grain.md)
  - [Python](write_wasm/python.md)

- [Use WasmEdge Library](sdk.md)
  - [C SDK](sdk/c.md)
    - [Use the WasmEdge C Library](sdk/c/library.md)
    - [Host Function Implementation](sdk/c/hostfunction.md)
    - [ExternRef Example](sdk/c/externref.md)
    - [Multiple Module Example](sdk/c/multimodule.md)
    - [0.12.0 API references](sdk/c/ref.md)
    - [0.11.2 API references](sdk/c/0.11.2/ref.md)
      - [Upgrade to 0.12.0](sdk/c/0.11.2/upgrade_to_0.12.0.md)
    - [0.10.1 API references](sdk/c/0.10.1/ref.md)
      - [Upgrade to 0.11.0](sdk/c/0.10.1/upgrade_to_0.11.0.md)
    - [0.9.1 API references](sdk/c/0.9.1/ref.md)
      - [Upgrade to 0.10.0](sdk/c/0.9.1/upgrade_to_0.10.0.md)
  - [Go SDK](sdk/go.md)
    - [Embed WASM apps](sdk/go/app.md)
    - [Embed WASM funcs](sdk/go/function.md)
    - [Pass complex data](sdk/go/memory.md)
    - [Tensorflow](sdk/go/tensorflow.md)
    - [Embed bindgen funcs](sdk/go/bindgen.md)
    - [v0.12.0 API references](sdk/go/ref.md)
    - [v0.11.2 API references](sdk/go/0.11.2/ref.md)
      - [Upgrade to 0.12.0](sdk/go/0.11.2/upgrade_to_0.12.0.md)
    - [v0.10.1 API references](sdk/go/0.10.1/ref.md)
      - [Upgrade to v0.11.0](sdk/go/0.10.1/upgrade_to_0.11.0.md)
    - [v0.9.1 API references](sdk/go/0.9.1/ref.md)
      - [Upgrade to v0.10.0](sdk/go/0.9.1/upgrade_to_0.10.0.md)
  - [Node.js SDK](sdk/node.md)
  - [Rust SDK](sdk/rust.md)
    - [Hello World!](sdk/rust/say_hello.md)
    - [Memory Manipulation](sdk/rust/memory_manipulation.md)
    - [Table and FuncRef](sdk/rust/table_and_funcref.md)
    - [Run a WebAssembly function with WasmEdge low-level APIs](sdk/rust/sys_run_host_func.md)
    - [Compute Fibonacci numbers concurrently](sdk/rust/concurrent_fib.md)
    - [Usage of WasmEdge module instances](sdk/rust/how_to_use_module_instance.md)
  - [Python SDK](sdk/python.md)

- [Use WasmEdge CLI](cli.md)
  - [`wasmedge` WASM Runner](cli/wasmedge.md)
  - [`wasmedgec` AOT Compiler](cli/wasmedgec.md)

- [Develop WasmEdge Plug-in](plugin.md)
  - [Develop Plug-in in C API](develop_plugin/c.md)
  - [Develop Plug-in in C++](develop_plugin/cpp.md)

- [Contribute to WasmEdge](contribute.md)
  - [Release Process](contribute/release_process.md)
  - [Contribute Steps](contribute/contribute.md)
  - [Build WasmEdge from source](contribute/build_from_src.md)
    - [Build on Linux](contribute/build_from_src/linux.md)
    - [Build on MacOS](contribute/build_from_src/macos.md)
    - [Build on Windows](contribute/build_from_src/windows.md)
    - [Build for Android](contribute/build_from_src/android.md)
      - [CLI tools](contribute/build_from_src/android/cli.md)
      - [NDK native app](contribute/build_from_src/android/ndk.md)
      - [APK app](contribute/build_from_src/android/apk.md)
    - [Build for seL4](contribute/build_from_src/sel4.md)
    - [Build for OpenHarmony](contribute/build_from_src/openharmony.md)
    - [Build for Raspberry Pi](contribute/build_from_src/raspberrypi.md)
    - [Build for OpenWrt](contribute/build_from_src/openwrt.md)
    - [Build with WASI-NN Plug-in](contribute/build_from_src/plugin_wasi_nn.md)
    - [Build with WASI-Crypto Plug-in](contribute/build_from_src/plugin_wasi_crypto.md)
    - [Build with WasmEdge-HttpsReq Plug-in](contribute/build_from_src/plugin_wasmedge_httpsreq.md)
    - [Build with WasmEdge-process Plug-in](contribute/build_from_src/plugin_wasmedge_process.md)
  - [WasmEdge Installer Guide](contribute/installer.md)
  - [WasmEdge Internal](contribute/internal.md)
  - [Wish List](contribute/wish_list.md)
