### 0.12.0 (2023-04-24)

Breaking changes:

* Updated the WasmEdge shared library.
  * Due to the breaking change of API, bump the `SOVERSION` to `0.0.2`.
* WasmEdge C API changes.
  * Removed the `WasmEdge_HostRegistration` members and the corresponding module creation APIs to standardize the plug-in module creation.
    * Please refer to the [documentation](https://wasmedge.org/book/en/sdk/c/0.11.2/upgrade_to_0.12.0.html) for how to upgrade.
    * Removed the `WasmEdge_HostRegistration_WasiNN` enum and the `WasmEdge_ModuleInstanceCreateWasiNN()` API.
    * Removed the `WasmEdge_HostRegistration_WasiCrypto_Common` enum and the `WasmEdge_ModuleInstanceCreateWasiCryptoCommon()` API.
    * Removed the `WasmEdge_HostRegistration_WasiCrypto_AsymmetricCommon` enum and the `WasmEdge_ModuleInstanceCreateWasiCryptoAsymmetricCommon()` API.
    * Removed the `WasmEdge_HostRegistration_WasiCrypto_Kx` enum and the `WasmEdge_ModuleInstanceCreateWasiCryptoKx()` API.
    * Removed the `WasmEdge_HostRegistration_WasiCrypto_Signatures` enum and the `WasmEdge_ModuleInstanceCreateWasiCryptoSignatures()` API.
    * Removed the `WasmEdge_HostRegistration_WasiCrypto_Symmetric` enum and the `WasmEdge_ModuleInstanceCreateWasiCryptoSymmetric()` API.
    * Removed the `WasmEdge_HostRegistration_WasmEdge_Process` enum and the `WasmEdge_ModuleInstanceCreateWasmEdgeProcess()` API.
* Changed the `WasmEdge_VMCleanup()` behavior.
  * After calling this API, the registered modules except the WASI and plug-ins will all be cleaned.
* Standaloned the `WasmEdge-Process` plug-in.
  * After this version, users should use the installer to install the `WasmEdge-Process` plug-in.

Features:

* Introduced the `Plugin` context and related APIs.
  * Added the `WasmEdge_PluginContext` struct.
  * Added the `WasmEdge_PluginLoadFromPath()` API for loading a plug-in from a specific path.
  * Added the `WasmEdge_PluginListPluginsLength()` and `WasmEdge_PluginListPlugins()` APIs for getting the loaded plug-in names.
  * Added the `WasmEdge_PluginFind()` API for retrieving a loaded plug-in by its name.
  * Added the `WasmEdge_PluginGetPluginName()` API for retrieving the plug-in name.
  * Added the `WasmEdge_PluginListModuleLength()` and `WasmEdge_PluginListModule()` APIs for listing the module names of a plug-in.
  * Added the `WasmEdge_PluginCreateModule()` API for creating the specific module instance in a plug-in by its name.
* Introduced the multiple WASI socket API implementation.
  * The `sock_accept()` is compatible with the WASI spec.
  * The V2 socket implementation is using a larger socket address data structures. With this, we can start to supporting `AF_UINX`
* Added the `VM` APIs.
  * Added the `WasmEdge_VMGetRegisteredModule()` API for retrieving a registered module by its name.
  * Added the `WasmEdge_VMListRegisteredModuleLength()` and `WasmEdge_VMListRegisteredModule()` APIs for listing the registered module names.
* Introduced the python version WasmEdge installer.
* Added the `wasm_bpf` plug-in.
* Enabled the read-only WASI filesystem.
  * Users can add the `--dir guest_path:host_path:readonly` option in WasmEdge CLI to assign the read-only configuration.
* Updated the ABI of the `wasi_ephemeral_sock`.
  * Added the output port of the `sock_recv_from`.
  * Updated the API of `sock_getlocaladdr`.
  * Unified the socket address size to 128-bit.
* Allowed the multiple VM instances.
* Supported using `libtool` to archive the WasmEdge static library.
* Supported LLVM 15.0.7.

Fixed issues:

* Fixed WASI issues.
  * Fixed the leaking information about the host STDIN, STDOUT, and STDERR after getting the `filestat`.
  * Fixed the lookup of symbolic link at `path_filestat_set_times`.
  * Fixed `open` for the wchar path issue on windows.
  * Fixed the rights of `path_open`.
* Fixed WASI-NN issues.
  * Fixed the definition of `wasi_nn::TensorType` to prevent from comparing with dirty data.
* Fixed WASI-Crypto issues.
  * Fixed the `keypair_generate` for rsa-pss.
  * Fixed the `keypair_import` read pem as pkcs8.
* Fixed WASI-Socket issues.
  * Fixed the buffer size of `sock_getpeeraddr`.
* Fixed the lost intrinsics table in AOT mode when using the WasmEdge C API.
* Fixed the registration failed of WasmEdge plug-in through the C API.
* Fixed the implementation in `threads` proposal.
  * Fixed the error in `atomic.nofify` and `atomic.wait` instructions.
  * Fixed the decoding of `atomic.fence` instruction.
  * Corrected the error message of waiting on unshared memory.
* Handle canonical and arithmetical `NaN` in `runMaxOp()` and `runMinOp()`.

Refactor:

* Refactored the implementation of number loading in the file manager.
  * Supported `s33` and `sn` loading and decoding.
* Refactored the `WasmEdge::ValType`.
  * Removed the `WasmEdge::ValType::None`.
  * Used the flag in `WasmEdge::BlockType` for supporting the type index.
  * Removed the `WasmEdge::Validator::VType` and used the `WasmEdge::ValType` instead.

Known issues:

* Universal WASM format failed on MacOS platforms.
  * In current status, the universal WASM format output of the AOT compiler with the `O1` or upper optimizations on MacOS platforms will cause bus error when execution.
  * We are trying to fix this issue. For working around, please use the `--optimize=0` to set the compiler optimization level to `O0` in `wasmedgec` CLI.
* WasmEdge CLI failed on Windows 10 issue.
  * Please refer to [here for the workaround](https://github.com/WasmEdge/WasmEdge/issues/1559) if the `msvcp140.dll is missing` occurs.
* Plug-in linking on MacOS platforms.
  * The plug-in on MacOS platforms will cause symbol not found when dynamic linking.
  * We are trying to fix this issue. For working around, please implement the host modules instead of plug-ins.

Documentations:

* Fixed various typos.
* Updated the C API documents.
* Added the [WasmEdge installer guide](https://wasmedge.org/book/en/contribute/installer.html).
* Updated the [Android NDK example](https://wasmedge.org/book/en/contribute/build_from_src/android/ndk.html).
* Added the [static library linking guide](https://wasmedge.org/book/en/sdk/c/library.html#link-with-wasmedge-static-library).
* Added the [WasmEdge plug-in implementation guide](https://wasmedge.org/book/en/develop_plugin/c.html).

Tests:

* Updated the WASM spec tests to the date 2022/12/15.
* Added the plug-in unit tests on Linux platforms.

Thank all the contributors that made this release possible!

Abhinandan Udupa, Achille, Afshan Ahmed Khan, Daniel Golding, DarumaDocker, Draco, Harry Chiang, Justin Echternach, Kenvi Zhu, LFsWang, Leonid Pospelov, Lîm Tsú-thuàn, MediosZ, O3Ol, Officeyutong, Puelloc, Rafael Fernández López, Shen-Ta Hsieh, Shreyas Atre, Sylveon, Tatsuyuki Kobayashi, Vishv Salvi, Xin Liu, Xiongsheng Wang, YiYing He, alabulei1, dm4, hydai, jeongkyu, little-willy, michael1017, shun murakami, xxchan, 云微

If you want to build from source, please use WasmEdge-0.12.0-src.tar.gz instead of the zip or tarball provided by GitHub directly.
