/***************************************************************************
                          wap11exception.cpp  -  description
                             -------------------
    begin                : Thu Mar 28 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include "sstream"
#include "wap11exception.h"

using namespace std;

std::string WAP11Exception::cause_table[]=
    {
      "Unknown",
      "AP isn't listening - is the IP address correct?",
      "Authorization error - is the password correct?"
    };

WAP11Exception::WAP11Exception(const std::string &f, const int &n,
                               const std::string &cn,
                               const std::string &err,
                               PossibleCause pc):
  classname(cn), file(f), line(n), error(err), possible_cause(pc)
{
  cerr << report() << endl;
}

std::string WAP11Exception::report()
{
  // Oh, C++! You're ugly, but we love you!
  std::stringstream sline; sline << line;
  return classname+" thrown at "+file+" ("+sline.str()+"): "+error;
}

std::string WAP11Exception::cause()
{
  return cause_table[possible_cause];
}
