/***************************************************************************
                          snmpdialogimp.h  -  description
                             -------------------
    begin                : Fri Dec 14 2001
    copyright            : (C) 2001 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SNMPDIALOGIMP_H
#define SNMPDIALOGIMP_H

#include <wap11.h>
#include <qvalidator.h>
#include "wap11config.h"
#include "ethernetstatsimp.h"
#include "wirelessstatsimp.h"
#include "changepassimp.h"
#include "passworddlgimp.h"
#include "trapsdialogimp.h"
#include "wap11exception.h"
#include "macauthimp.h"
#include "hexvalidator.h"


/**
  *@author Ori Pessach
  */

class SNMPDialogImp : public SNMPConfigForm  {
public: 
  SNMPDialogImp();
  ~SNMPDialogImp();

  enum KeyField {NONE_VALID=0, KEY1_VALID=1, KEY2_VALID=2, KEY3_VALID=4, KEY4_VALID=8, ALL_VALID=15};
public slots: // Public slots
  /** Invoked when the Cancel button is pressed */
  void slotCancelButton();
  /** Invoked when the Close button is clicked */
  void slotCloseButton();
  /** No descriptions */
  void slotApplyButton();
  /** Final initialization stage - prompt the user for password. */
  virtual void polish();
  /** Return the required length of WEP keys, in non-space hex digits. */
  int GetWEPKeyLength() const;
  /** Convert a string IP address in dot notation to a vector of 4 octets. Weird. */
  WAP11Config::bytevector_t IPtoV( const std::string &s);
  /** Convert an IP address in dot notation to an unsigned 32 bit int. */
  uint32_t BinIP(const std::string &ip);
  /** Convert a QString to an std::string. */
  std::string QStostr(const QString &s);
  /** Copy fields from the UI to our WAP11Config instance. */
  void UpdateW11C();
  /** Enables the dialog's Apply button after the data was changed. */
  void EnableApplyButton();
  /** Returns the i'th octet string variable from results. */
  char * GetVarO(struct snmp_pdu *results, int i);
  /** Enables the tabs, buttons, and entry fields. */
  void EnableUI();
  /** Updates the UI's fields with data from our WAP11Config instance. w11c must
be valid for this to work (after calling Get() successfully). */
  void UpdateUI();
  /** Disable most of the UI. For use when the app isn't connected to the AP. */
  void DisableUI();
  /** Prompt the user for the password and IP address, and try to connect to the AP.
If successful, download info from the AP, and set the UI. If not, disable most of 
the UI. */
  void Connect();
  /** Mark a WEP key field as containing an invalid key. */
  void SetKeyInvalid(SNMPDialogImp::KeyField);
  /** Mark a WEP key field as containing a valid key. This is called by KeyValidator. */
  void SetKeyValid(SNMPDialogImp::KeyField f);
  /** Invoked when the Reconnect button is clicked(). */
  void slotReconnectButton();
  /** No descriptions */
  void slotDataChanged();
  /** No descriptions */
  void slotDHCPToggled();
  /** No descriptions */
  void slotWEPChanged();
  /** No descriptions */
  void slotEnteredPassphrase();
  /** Issues a reset command */
  void slotResetButton();
  /** No descriptions */
  void slotEthernetStatsButton();
  /** No descriptions */
  void slotWirelessStatsButton();
  /** Invoked when the Password Setting button is clicked */
  void slotPasswordSettingButton();
  /** Called when a access point mode button is clicked */
  void slotAccessPointModeCheck();
  /** Invoked when the Restore Defaults button is pressed. */
  void slotRestoreDefaultsButton();
  /** Invoked when clicking the Authrized MAC pushbutton */
  void slotAuthorizedMAC();
  /** Triggered when the user clicks the Enable MAC Authorization checkbox. */
  void slotEnableMACAuthorization();
  /** Invoked when the Show Traps button is clicked. */
  void slotTrapButton();
  /** Invoked when the Help button is clicked. */
  void slotHelpButton();

private:
  /** A validator class for the LineEdit widgets used to enter WEP keys */
  class KeyValidator: public HEXValidator
  {
  public:
    KeyValidator(SNMPDialogImp &d, KeyField f, const char * name = 0 ):
      HEXValidator(name), dialog(d), field(f) {}
  protected:
    virtual int FieldLength() const {return dialog.GetWEPKeyLength(); }
    virtual void AcceptAction() const { dialog.SetKeyValid(field); }
    virtual void RejectAction() const { dialog.SetKeyInvalid(field); }
  private:
    // We'll need to query the dialog to determine whether we're dealing with 40 bit
    // or 128 bit WEP keys:
    SNMPDialogImp &dialog;
    KeyField field;
  };

  WAP11Config w11c;
  EthernetStatsImp *etherstats;
  WirelessStatsImp *wirelessstats;
  ChangePassImp *changepassword;
  TrapsDialogImp *trapsdialog;
  /** This is the basic rates array returned by WAP11Config: */
  WAP11Config::bytevector_t basic_rates;
  PasswordDlgImp pdi;
  PasswordDlgImp::strvec_t addr_vec;

  uint32_t WEPKeysValid;
  /** The MAC Authorization dialog object */
  MacAuthImp * macauth;
public: // Public attributes

private: // Private methods
  /** Converts a string containing hex octets into a byte vector. */
  WAP11Config::bytevector_t StrToVector(const std::string &s);
  /** Format a byte vector to a string of hexadecimal numbers. */
  std::string VectorToStr(const WAP11Config::bytevector_t &);
  void SetAccessPointModeFieldEnables();
  /** Opens the options file, ~/.wap11gui. If the file isn't found, ask the user whether
to create one. Once the file is open, read it and return. */
  void ReadOptFile();
  /** Displays information about an exception */
  void ReportException(WAP11Exception &e);
  /** Saves the current options to ~/.wap11gui */
  void SaveOptFile();
};

#endif
