/***************************************************************************
                          passworddlgimp.h  -  description
                             -------------------
    begin                : Sun Dec 16 2001
    copyright            : (C) 2001, 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PASSWORDDLGIMP_H
#define PASSWORDDLGIMP_H

#include <password.h>
#include <vector>
#include <string>

/**Logic for the password dialog
  *@author Ori Pessach
  */

class PasswordDlgImp : public PasswordDialog
{
public: 
  PasswordDlgImp();
  ~PasswordDlgImp();
  /** Returns a pointer to a newly allocated buffer, containing the password from the 
      dialog's password field. The caller must free the buffer when it's done with it. */
  const char * GetPassword();
  /** Returns a pointer to a newly allocated buffer containing the IP address of the 
      access point. The caller must free the buffer. */
  const char * GetIPAddress();

  typedef std::vector< std::string > strvec_t;
  void AddAddresses( const strvec_t &addresses );

public slots: // Public slots
  /** Called when the Cancel button on the dialog is pressed. */
  void slotCancelButton();
  /** No descriptions */
  void slotOKButton();
  /** No descriptions */
  virtual void polish();

private:
  char *password;
  char *ip_address;
};

#endif
