/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri Dec 14 20:35:54 MST 2001
    copyright            : (C) 2001, 2002, 2003 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <iostream>

#include "wap11gui.h"
#include "snmpdialogimp.h"
#include "wap11exception.h"

using namespace std;

int main(int argc, char *argv[])
{
  try
  {
    QApplication a(argc, argv);
    a.setFont(QFont("helvetica", 10), TRUE);
    QTranslator tor( 0 );

    // set the location where your .qm files are in load() below as the last parameter instead of "."
    // for development, use "/" to use the english original as
    // .qm files are stored in the base project directory.
    tor.load( QString("wap11gui.") + QTextCodec::locale(), "." );
    a.installTranslator( &tor );

    SNMPDialogImp *snmpd=new SNMPDialogImp();
    QPixmap icon(QString(DATADIR)+"/wap11.png");
    snmpd->setIcon(icon);
    a.setMainWidget(snmpd);

    snmpd->show();

    return a.exec();
  }
  catch(WAP11Exception &e)
  {
    // Note: This doesn't work if QT isn't compiled with exceptions, which seems to be
    // a common practice. Why?
    cerr << "Caught an unhandled exception in main(). Exception thrown from "<<e.file<<" line "<<e.line<<".\n";
  }
}


