/***************************************************************************
                          macvalidaotr.h  -  description
                             -------------------
    begin                : Mon Oct 7 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MACVALIDAOTR_H
#define MACVALIDAOTR_H

#include <qpushbutton.h>
#include <hexvalidator.h>

/**Extends a HEXValidator to validate ethernet MAC address fields.
  *@author Ori Pessach
  */

class MACValidator : public HEXValidator
{
public:
    MACValidator( QPushButton *b, const char * name = 0 ):
      HEXValidator(name), button(b) {}
  protected:
    virtual int FieldLength() const { return 12; }
    virtual void AcceptAction() const {if(button) button->setEnabled(true);}
    virtual void RejectAction() const {if(button) button->setEnabled(false);}
    
    QPushButton *button;
};

#endif
