/***************************************************************************
                          macauthimp.h  -  description
                             -------------------
    begin                : Fri Jul 19 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MACAUTHIMP_H
#define MACAUTHIMP_H

#include <macauth.h>
#include "wap11config.h"

/**Implements logic for the MacAuth dialog
  *@author Ori Pessach
  */

class MacAuthImp : public MacAuth  {
public: 
  MacAuthImp(WAP11Config &w);
  ~MacAuthImp();
  /** Finish up the dialog's initialization. */
  void polish();
private:
  WAP11Config &w11c;
  int highlighted_item;
public slots: // Public slots
  /** Invoked when clicking the Add button */
  void slotAddMAC();
  /** Invoked when a MAC address is selected from the list */
  void slotMACSelected(int);
  /** Invoked when the Cancel button is clicked */
  void slotCancel();
  /** Invoked when the OK button is clicked */
  void slotOK();
  /** Invoked when the Delete button is pressed */
  virtual void slotDelete();
};

#endif
