/***************************************************************************
                          ethernetstatsimp.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ETHERNETSTATSIMP_H
#define ETHERNETSTATSIMP_H

#include <ethernetstats.h>
#include "wap11config.h"

/**Logic for the ethernet statistics window.
  *@author Ori Pessach
  */

class EthernetStatsImp : public EthernetStatsForm  {
public: 
	EthernetStatsImp(WAP11Config &w11);
	~EthernetStatsImp();
  /** Reloads the ethernet statistics */
  void Reload();
  /** Extract a 32 bit small endian number from the bytevector_t, starting at index i. */
  uint32_t ExtractValue(const WAP11Config::bytevector_t &, int i);

private:
  WAP11Config &w11c;
public slots: // Public slots
  /** No descriptions */
  void slotRefreshButton();
  /** Called when the Close button is clicked */
  void slotCloseButton();
  /** No descriptions */
  virtual void polish();
protected: // Protected methods
  /** Updates the dialog periodically */
  virtual void timerEvent(QTimerEvent *);
};

#endif
