/***************************************************************************
                          ethernetstatsimp.cpp  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include "ethernetstatsimp.h"

EthernetStatsImp::EthernetStatsImp(WAP11Config &w11): w11c(w11)
{
}

EthernetStatsImp::~EthernetStatsImp()
{
}

/** Reloads the ethernet statistics */
void EthernetStatsImp::Reload()
{
  w11c.GetStats();
  WAP11Config::bytevector_t v[2];
  w11c.GetVariable("EthStatisticsGRP.EthRxStatistics.0", v[0]);
  w11c.GetVariable("EthStatisticsGRP.EthTxStatistics.0", v[1]);
  uint32_t tx[5], rx[5]; // transmit, receive

  QLineEdit *widget[5][2]={
    {RxBytes,   TxBytes},
    {RxPackets, TxPackets},
    {RxErrors,  TxErrors},
    {RxBcast,   TxBcast},
    {RxMcast,   TxMcast}};

  for(int i=0; i<5; ++i)
  {
    char tmp[16];
    rx[i]=ExtractValue(v[1], i*4);
    sprintf(tmp, "%d", rx[i]);
    widget[i][0]->setText(tmp);
    tx[i]=ExtractValue(v[0], i*4);
    sprintf(tmp, "%d", tx[i]);
    widget[i][1]->setText(tmp);
  }
}

/** Extract a 32 bit small endian number from the bytevector_t, starting at index i. */
uint32_t EthernetStatsImp::ExtractValue(const WAP11Config::bytevector_t &v, int i)
{
  uint32_t r=0;
  for(int j=i+3; j>=i; --j)
  {
    r<<=8;
    r+=(uint32_t)v[j];
  }
  return r;
}

/** Refresh the ethernet stats fields */
void EthernetStatsImp::slotRefreshButton()
{
  Reload();
}

/** Called when the Close button is clicked */
void EthernetStatsImp::slotCloseButton()
{
  killTimers();
  accept();
}
/** Updates the dialog periodically */
void EthernetStatsImp::timerEvent(QTimerEvent *)
{
  Reload();
}

/** Set a timer to update the display periodically */
void EthernetStatsImp::polish()
{
  startTimer(1000);
}
