/***************************************************************************
                          changepassimp.cpp  -  description
                             -------------------
    begin                : Sun Mar 31 2002
    copyright            : (C) 2002 by Ori Pessach
    email                : mail@oripessach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>									
#include <qmessagebox.h>
#include "changepassimp.h"

ChangePassImp::ChangePassImp(WAP11Config &w):
  ChangePass(0, 0, true), w11c(w)
{
}

ChangePassImp::~ChangePassImp()
{
}

/** Clear all entry fields. */
void ChangePassImp::Clear()
{
	EditCurPassword->setText("");
	EditNewPassword->setText("");
	EditConfirmNewPassword->setText("");
	EditCurPassword->setFocus();
}

/** Invoked when the OK button is pressed */
void ChangePassImp::slotOKButton()
{
	if(w11c.GetPassword() != std::string((const char*)EditCurPassword->text()))
	{
		QMessageBox::warning(this, "WAP11 Configuration Utility",
                         "The current password you entered is incorrect.",
                         "OK", "", 0, 0, 1);
		EditCurPassword->setText("");
    EditCurPassword->setFocus();
		return;
	}
	if(EditNewPassword->text() == "")
	{
		QMessageBox::warning(this, "WAP11 Configuration Utility",
                         "Your new password can't be empty.",
                         "OK", "", 0, 0, 1);
		EditConfirmNewPassword->setText("");
		EditNewPassword->setFocus();
		return;
	}
	if(EditNewPassword->text() != EditConfirmNewPassword->text())
	{
		QMessageBox::warning(this, "WAP11 Configuration Utility",
                         "New password entered doesn't match.",
                         "OK", "", 0, 0, 1);
		EditNewPassword->setText("");
		EditConfirmNewPassword->setText("");
		EditNewPassword->setFocus();
		return;
	}
	new_password=EditNewPassword->text();
 	done(Accepted);
}

/** Invoked when the cancel button is pressed */
void ChangePassImp::slotCancelButton()
{
	done(Rejected);
}

const QString &ChangePassImp::GetNewPassword()
{
	return new_password;
}

/** Invoked when user presses enter on the last entry field. */
void ChangePassImp::retunPressed()
{
}
