status: draft

# VT Input Mode Protocol

The goal of the `vt-input-mode` protocol is to make command line interactivity cross-platform.

- No TTY required.
- No OS-level signal tracking required.

## Audience

Anyone who wants to:
- Operate without TTY.
- Share applications on LAN (using inetd, netcat, etc).
- Track every key press and key release.
- Track position dependent keys such as WASD.
- Distinguish between Left and Right physical keys.
- Get consistent output regardless of terminal window resize.
- Track mouse outside the terminal window (getting negative coordinates).
- Track scrollback text selection.
- Track application closing and system shutdown.
- Be independent of operating system and third party libraries.

Existing approaches have the following drawbacks:
- There is no uniform way to receive keyboard events.
- Window size tracking requires platform-specific calls with no way to synchronize the output.
- Mouse tracking modes lack support for negative coordinates and have a limited set of buttons.
- Bracketed paste mode does not support the transfer of binary data and data containing sequences of bracketed paste mode itself.

## Conventions

- All numeric values used in this protocol are decimal and zero-based.
- Space characters are not used in sequence payloads and are only used for readability of the description.
- All unescaped symbols outside of this protocol should be treated as clipboard pasted data.

### Format

Signaling uses APC `ESC _ <payload> ESC \` with a specific payload syntax.

The payload consists of a list of attributes in the following format:
```
<attr>=<val>,...,<val>; ...; <attr>=<val>,...,<val>
```

Field             | Descriprtion
------------------|-------------
`<attr>`          | Attribute name.
`<val>,...,<val>` | Comma-separated value list.

## Initialization

```
Set:   ESC _ events=<Source0>,...,<SourceN> ESC \
Reset: ESC _ events ESC \
```

Source     | Events to track
-----------|----------------
`keyboard` | Keyboard.
`mouse`    | Mouse.
`focus`    | Focus.
`clipoard` | Clipboard.
`window`   | Window size and selection.
`system`   | System signals.

This sequence enables `vt-input-mode` and event tracking for the specified event `Source`s. The `vt-input-mode` is deactivated if none of the `Source`s is specified.

Note: By enabling `vt-input-mode`, all current terminal modes are automatically saved (to be restored on exit) and switched to something like "raw" mode, in which input is available character by character, echoing is disabled, and all special processing of terminal input and output characters is disabled (except for `LF` to `CR+LF` conversion).

## Events

- Keyboard
  ```
  ESC _ event=keyboard ; kbmods=<KeyMods> ; keyid=<KeyId> ; pressed=<KeyDown> ; scancode=<ScanCode> ; chord=<KeyId0>,...,<KeyIdN> ; print=<C0>,...,<Cn> ESC \
  ```
- Mouse
  ```
  ESC _ event=mouse ; kbmods=<KeyMods> ; coord=<X>,<Y> ; buttons=<ButtonState> ; wheel=<DeltaY>,<DeltaX> ESC \
  ```
- Focus
  ```
  ESC _ event=focus ; state=<FocusState> ESC \
  ```
- Clipboard
  ```
  ESC _ event=clipoard ; format=<ClipFormat> ; security=<SecLevel> ; data=<Data> ESC \
  ```
- Window
  ```
  ESC _ event=window ; size=<Width>,<Height> ; cursor=<X>,<Y> ; region=<Left>,<Top>,<Right>,<Bottom> ; selection=<StartX>,<StartY>,<EndX>,<EndY>,<Mode> ESC \
  ```
- System
  ```
  ESC _ event=system ; signal=<Signal> ESC \
  ```

### Keyboard

```
ESC _ event=keyboard ; kbmods=<KeyMods> ; keyid=<KeyId> ; pressed=<KeyDown> ; scancode=<ScanCode> ; chord=<KeyId0>,...,<KeyIdN> ; print=<C0>,...,<Cn> ESC \
```

> Q: Do we need to track scancode chord? `scanchord=<Code0>,...,<CodeN>`?

Attribute                     | Description
------------------------------|------------
`kbmods=<KeyMods>`            | Keyboard modifiers.
`keyid=<KeyId>`               | Physical key ID.
`pressed=<KeyDown>`           | Key state:<br>\<KeyDown\>=1 - Pressed.<br>\<KeyDown\>=0 - Released.
`scancode=<ScanCode>`         | Scan code.
`chord=<KeyId0>,...,<KeyIdN>` | Simultaneously pressed key id's in ascending order.
`print=<C0>,...,<Cn>`         | Codepoints of the generated string.

In response to the activation of `keyboard` tracking, the application receives a vt-sequence containing keyboard modifiers state:
```
ESC _ event=keyboard ; kbmods=<KeyMods> ESC \
```

The full sequence is fired after every key press and key release. The sequence can contain a string generated by a keystroke as a set of codepoints: `C0 + ... + Cn`. The string can be fragmented and delivered by multiple consecutive events.

The `chord=<KeyId0>,...,<KeyIdN>` attribute contains the set of simultaneously pressed key id's in ascending order and is used to track key combinations. It is possible to track both chord presses `+` (e.g. `Ctrl+F1`) and chord releases `-` (e.g. `Ctrl-F1` or `Ctrl-Alt`):
- Pressed chord: The `pressed` attribute has the value `1`.
- Release chord: The `pressed` attribute has the value `0`.

#### Keyboard modifiers

The state `kbmods=<KeyMods>` of keyboard modifiers is the binary OR of all currently pressed modifiers and enabled modes.

 Bit | Side   | Modifier Key                 | Value
 ----|--------|------------------------------|--------------
 0   | Left   | <kbd>⌃ Ctrl</kbd>            | `0x0001`
 1   | Right  | <kbd>⌃ Ctrl</kbd>            | `0x0002`
 2   | Left   | <kbd>⎇ Alt</kbd><br><kbd>⌥ Option</kbd>                       | `0x0004`
 3   | Right  | <kbd>⎇ Alt</kbd><br><kbd>⌥ Option</kbd><br><kbd>⇮ AltGr</kbd> | `0x0008`
 4   | Left   | <kbd>⇧ Shift</kbd>           | `0x0010`
 5   | Right  | <kbd>⇧ Shift</kbd>           | `0x0020`
 6   | Left   | <kbd>⊞ Win</kbd><br><kbd>⌘ Command</kbd><br><kbd>◆ Meta</kbd><br><kbd>❖ Super</kbd> | `0x0040`
 7   | Right  | <kbd>⊞ Win</kbd><br><kbd>⌘ Command</kbd><br><kbd>◆ Meta</kbd><br><kbd>❖ Super</kbd> | `0x0080`
 8   |        | <kbd>reserved</kbd>          | `0x0100`
 9   |        | <kbd>reserved</kbd>          | `0x0200`
 10  |        | <kbd>reserved</kbd>          | `0x0400`
 11  |        | <kbd>reserved</kbd>          | `0x0800`
 12  |        | <kbd>⇭ NumLock Mode</kbd>    | `0x1000`
 13  |        | <kbd>⇪ CapsLock Mode</kbd>   | `0x2000`
 14  |        | <kbd>⇳ ScrollLock Mode</kbd> | `0x4000`
 15  |        | <kbd>reserved Mode</kbd>     | `0x8000`

#### Scan codes

Scan codes are usually useful for applications that need to know which key is pressed, regardless of the current keyboard layout. For example, the WASD (Up, Left, Down, Right) keys for games, which ensure a consistent key formation across QWERTY, AZERTY or Dvorak keyboard layouts.

```
QWERTY: "W" = 11  "A" = 1E  "S" = 1F  "D" = 20
AZERTY: "Z" = 11  "Q" = 1E  "S" = 1F  "D" = 20
Dvorak: "," = 11  "A" = 1E  "O" = 1F  "E" = 20
```

Scan codes for the keys on a standard 104-key keyboard:

```
┌────┐  ┌────╥────╥────╥────┐  ┌────╥────╥────╥────┐  ┌────╥────╥────╥────┐  ┌────╥────╥────┐
| 01 │  | 3B ║ 3C ║ 3D ║ 3E |  | 3F ║ 40 ║ 41 ║ 42 |  | 43 ║ 44 ║ 57 ║ 58 |  |E037║ 46 ║E045|
└────┘  └────╨────╨────╨────┘  └────╨────╨────╨────┘  └────╨────╨────╨────┘  └────╨────╨────┘
┌────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────────┐  ┌────╥────╥────┐  ┌────╥────╥────╥────┐
| 29 ║ 02 ║ 03 ║ 04 ║ 05 ║ 06 ║ 07 ║ 08 ║ 09 ║ 0A ║ 0B ║ 0C ║ 0D ║     0E |  |E052║E047║E049|  | 45 ║E035║ 37 ║ 4A |
╞════╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══════╡  ╞════╬════╬════╡  ╞════╬════╬════╬════╡
| 0F   ║ 10 ║ 11 ║ 12 ║ 13 ║ 14 ║ 15 ║ 16 ║ 17 ║ 18 ║ 19 ║ 1A ║ 1B ║   2B |  |E053║E04F║E051|  | 47 ║ 48 ║ 49 ║    |
╞══════╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩══════╡  └────╨────╨────┘  ╞════╬════╬════╣ 4E |
| 3A    ║ 1E ║ 1F ║ 20 ║ 21 ║ 22 ║ 23 ║ 24 ║ 25 ║ 26 ║ 27 ║ 28 ║       1C |                    | 4B ║ 4C ║ 4D ║    |
╞═══════╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩══════════╡       ┌────┐       ╞════╬════╬════╬════╡
| 2A      ║ 2C ║ 2D ║ 2E ║ 2F ║ 30 ║ 31 ║ 32 ║ 33 ║ 34 ║ 35 ║          36 |       |E048|       | 4F ║ 50 ║ 51 ║    |
╞══════╦══╩═╦══╩═══╦╩════╩════╩════╩════╩════╩════╩╦═══╩╦═══╩╦═════╦══════╡  ┌────┼────┼────┐  ╞════╩════╬════╣E01C|
| 1D   ║ 5B ║ 38   ║               39              ║E038║ 5C ║  5D ║ E01D |  |E04B|E050|E04D|  |      52 ║ 53 ║    |
└──────╨────╨──────╨───────────────────────────────╨────╨────╨─────╨──────┘  └────┴────┴────┘  └─────────╨────╨────┘
```

#### Physical keys

The `<KeyId>` is incremented by 2 for each generic key, providing two `<KeyId>` placeholders for each physical key to distinguish between Left and Right (or Numpad) in the last bit. Ignore the last bit of `<KeyId>` for tracking generic keys.

Key ID | Name             | Physical Key                  | Scan Code        | Notes
-------|------------------|-------------------------------|------------------|------
0      | undef            |                               |                  |
2      | LeftCtrl         | <kbd>Left Ctrl</kbd>          | `   29` `0x1D`   |
3      | RightCtrl        | <kbd>Right Ctrl</kbd>         | `57373` `0xE01D` |
4      | LeftAlt          | <kbd>Left Alt</kbd>           | `   56` `0x38`   |
5      | RightAlt         | <kbd>Right Alt</kbd>          | `57400` `0xE038` |
6      | LeftShift        | <kbd>Left Shift</kbd>         | `   42` `0x2A`   |
7      | RightShift       | <kbd>Right Shift</kbd>        | `   54` `0x36`   |
8      | LeftWin          | <kbd>Left Win</kbd>           | `   91` `0x5B`   |
9      | RightWin         | <kbd>Right Win</kbd>          | `   92` `0x5C`   |
10     | Apps             | <kbd>Apps</kbd>               | `   93` `0x5D`   |
12     | NumLock          | <kbd>Num Lock</kbd>           | `   69` `0x45`   |
14     | CapsLock         | <kbd>Caps Lock</kbd>          | `   58` `0x3A`   |
16     | ScrollLock       | <kbd>Scroll Lock</kbd>        | `   69` `0x45`   |
18     | Esc              | <kbd>Esc</kbd>                | `    1` `0x01`   |
20     | Space            | <kbd>Space</kbd>              | `   57` `0x39`   |
22     | Backspace        | <kbd>Backspace</kbd>          | `   14` `0x0E`   |
24     | Tab              | <kbd>Tab</kbd>                | `   15` `0x0F`   |
26     | Break            | <kbd>Break</kbd>              | `57414` `0xE046` | Ctrl + Pause
28     | Pause            | <kbd>Pause</kbd>              | `57412` `0xE045` |
30     | Select           | <kbd>Select</kbd>             |                  |
32     | SysRq            | <kbd>SysRq</kbd>              | `   84` `0x54`   | Alt + PrintScreen
34     | PrintScreen      | <kbd>Print Screen</kbd>       | `57399` `0xE037` |
36     | Enter            | <kbd>Enter</kbd>              | `   28` `0x1C`   |
37     | NumpadEnter      | <kbd>Numpad Enter</kbd>       | `57372` `0xE01C` |
38     | PageUp           | <kbd>PageUp</kbd>             | `57417` `0xE049` |
39     | NumpadPageUp     | <kbd>Numpad PageUp</kbd>      | `   73` `0x49`   |
40     | PageDown         | <kbd>PageDown</kbd>           | `57425` `0xE051` |
41     | NumpadPageDown   | <kbd>Numpad PageDown</kbd>    | `   81` `0x51`   |
42     | End              | <kbd>End</kbd>                | `57423` `0xE04F` |
43     | NumpadEnd        | <kbd>Numpad End</kbd>         | `   79` `0x4F`   |
44     | Home             | <kbd>Home</kbd>               | `57415` `0xE047` |
45     | NumpadHome       | <kbd>Numpad Home</kbd>        | `   71` `0x47`   |
46     | LeftArrow        | <kbd>Left Arrow</kbd>         | `57419` `0xE04B` |
47     | NumpadLeftArrow  | <kbd>Numpad Left Arrow</kbd>  | `   75` `0x4B`   |
48     | UpArrow          | <kbd>Up Arrow</kbd>           | `57416` `0xE048` |
49     | NumpadUpArrow    | <kbd>Numpad Up Arrow</kbd>    | `   72` `0x48`   |
50     | RightArrow       | <kbd>Right Arrow</kbd>        | `57421` `0xE04D` |
51     | NumpadRightArrow | <kbd>Numpad Right Arrow</kbd> | `   77` `0x4D`   |
52     | DownArrow        | <kbd>Down Arrow</kbd>         | `57424` `0xE050` |
53     | NumpadDownArrow  | <kbd>Numpad Down Arrow</kbd>  | `   80` `0x50`   |
54     | Key0             | <kbd>0</kbd>                  | `   11` `0x0B`   |
55     | Numpad0          | <kbd>Numpad 0</kbd>           | `   82` `0x52`   |
56     | Key1             | <kbd>1</kbd>                  | `    2` `0x02`   |
57     | Numpad1          | <kbd>Numpad 1</kbd>           | `   79` `0x4F`   |
58     | Key2             | <kbd>2</kbd>                  | `    3` `0x03`   |
59     | Numpad2          | <kbd>Numpad 2</kbd>           | `   80` `0x50`   |
60     | Key3             | <kbd>3</kbd>                  | `    4` `0x04`   |
61     | Numpad3          | <kbd>Numpad 3</kbd>           | `   81` `0x51`   |
62     | Key4             | <kbd>4</kbd>                  | `    5` `0x05`   |
63     | Numpad4          | <kbd>Numpad 4</kbd>           | `   75` `0x4B`   |
64     | Key5             | <kbd>5</kbd>                  | `    6` `0x06`   |
65     | Numpad5          | <kbd>Numpad 5</kbd>           | `   76` `0x4C`   |
66     | Key6             | <kbd>6</kbd>                  | `    7` `0x07`   |
67     | Numpad6          | <kbd>Numpad 6</kbd>           | `   77` `0x4D`   |
68     | Key7             | <kbd>7</kbd>                  | `    8` `0x08`   |
69     | Numpad7          | <kbd>Numpad 7</kbd>           | `   71` `0x47`   |
70     | Key8             | <kbd>8</kbd>                  | `    9` `0x09`   |
71     | Numpad8          | <kbd>Numpad 8</kbd>           | `   72` `0x48`   |
72     | Key9             | <kbd>9</kbd>                  | `   10` `0x0A`   |
73     | Numpad9          | <kbd>Numpad 9</kbd>           | `   73` `0x49`   |
74     | Insert           | <kbd>Insert</kbd>             | `57426` `0xE052` |
75     | NumpadInsert     | <kbd>Numpad Insert</kbd>      | `   82` `0x52`   |
76     | Delete           | <kbd>Delete</kbd>             | `57427` `0xE053` |
77     | NumpadDelete     | <kbd>Numpad Delete</kbd>      | `   83` `0x55`   |
78     | Clear            | <kbd>Clear</kbd>              | `   76` `0x4C`   |
79     | NumpadClear      | <kbd>Numpad Clear</kbd>       | `   76` `0x4C`   | Numpad 5
80     | Multiply         | <kbd>*</kbd>                  |                  |
81     | NumpadMultiply   | <kbd>Numpad *</kbd>           | `   55` `0x37`   |
82     | Plus             | <kbd>+</kbd>                  |                  |
83     | NumpadPlus       | <kbd>Numpad +</kbd>           | `   78` `0x4E`   |
84     | Separator        | <kbd>Separator</kbd>          |                  |
85     | NumpadSeparator  | <kbd>Numpad Separator</kbd>   |                  |
86     | Minus            | <kbd>-</kbd>                  | `   12` `0x0C`   |
87     | NumpadMinus      | <kbd>Numpad -</kbd>           | `   74` `0x4A`   |
88     | Period           | <kbd>.</kbd>                  | `   52` `0x34`   |
89     | NumpadDecimal    | <kbd>Numpad .</kbd>           | `   83` `0x53`   |
90     | Slash            | <kbd>/</kbd>                  | `   53` `0x35`   |
91     | NumpadSlash      | <kbd>Numpad /</kbd>           | `57397` `0xE035` |
92     | BackSlash        | <kbd>\\</kbd>                 | `   43` `0x2B`   |
94     | OpenBracket      | <kbd>[</kbd>                  | `   26` `0x1A`   |
96     | ClosedBracket    | <kbd>]</kbd>                  | `   27` `0x1B`   |
98     | Equal            | <kbd>=</kbd>                  | `   13` `0x0D`   |
100    | BackQuote        | <kbd>\`</kbd>                 | `   41` `0x29`   |
102    | SingleQuote      | <kbd>'</kbd>                  | `   40` `0x28`   |
104    | Comma            | <kbd>,</kbd>                  | `   51` `0x33`   |
106    | Semicolon        | <kbd>;</kbd>                  | `   39` `0x27`   |
108    | F1               | <kbd>F1</kbd>                 | `   59` `0x3B`   |
110    | F2               | <kbd>F2</kbd>                 | `   61` `0x3C`   |
112    | F3               | <kbd>F3</kbd>                 | `   62` `0x3D`   |
114    | F4               | <kbd>F4</kbd>                 | `   63` `0x3E`   |
116    | F5               | <kbd>F5</kbd>                 | `   64` `0x3F`   |
118    | F6               | <kbd>F6</kbd>                 | `   65` `0x40`   |
120    | F7               | <kbd>F7</kbd>                 | `   66` `0x41`   |
122    | F8               | <kbd>F8</kbd>                 | `   67` `0x42`   |
124    | F9               | <kbd>F9</kbd>                 | `   68` `0x43`   |
126    | F10              | <kbd>F10</kbd>                | `   69` `0x44`   |
128    | F11              | <kbd>F11</kbd>                | `   87` `0x57`   |
130    | F12              | <kbd>F12</kbd>                | `   88` `0x5B`   |
132    | F13              | <kbd>F13</kbd>                |                  |
134    | F14              | <kbd>F14</kbd>                |                  |
136    | F15              | <kbd>F15</kbd>                |                  |
138    | F16              | <kbd>F16</kbd>                |                  |
140    | F17              | <kbd>F17</kbd>                |                  |
142    | F18              | <kbd>F18</kbd>                |                  |
144    | F19              | <kbd>F19</kbd>                |                  |
146    | F20              | <kbd>F20</kbd>                |                  |
148    | F21              | <kbd>F21</kbd>                |                  |
150    | F22              | <kbd>F22</kbd>                |                  |
152    | F23              | <kbd>F23</kbd>                |                  |
154    | F24              | <kbd>F24</kbd>                |                  |
156    | KeyA             | <kbd>A</kbd>                  |                  |
158    | KeyB             | <kbd>B</kbd>                  |                  |
160    | KeyC             | <kbd>C</kbd>                  |                  |
162    | KeyD             | <kbd>D</kbd>                  |                  |
164    | KeyE             | <kbd>E</kbd>                  |                  |
166    | KeyF             | <kbd>F</kbd>                  |                  |
168    | KeyG             | <kbd>G</kbd>                  |                  |
170    | KeyH             | <kbd>H</kbd>                  |                  |
172    | KeyI             | <kbd>I</kbd>                  |                  |
174    | KeyJ             | <kbd>J</kbd>                  |                  |
176    | KeyK             | <kbd>K</kbd>                  |                  |
178    | KeyL             | <kbd>L</kbd>                  |                  |
180    | KeyM             | <kbd>M</kbd>                  |                  |
182    | KeyN             | <kbd>N</kbd>                  |                  |
184    | KeyO             | <kbd>O</kbd>                  |                  |
186    | KeyP             | <kbd>P</kbd>                  |                  |
188    | KeyQ             | <kbd>Q</kbd>                  |                  |
190    | KeyR             | <kbd>R</kbd>                  |                  |
192    | KeyS             | <kbd>S</kbd>                  |                  |
194    | KeyT             | <kbd>T</kbd>                  |                  |
196    | KeyU             | <kbd>U</kbd>                  |                  |
198    | KeyV             | <kbd>V</kbd>                  |                  |
200    | KeyW             | <kbd>W</kbd>                  |                  |
202    | KeyX             | <kbd>X</kbd>                  |                  |
204    | KeyY             | <kbd>Y</kbd>                  |                  |
206    | KeyZ             | <kbd>Z</kbd>                  |                  |
208    | Sleep            | <kbd>Sleep</kbd>              |                  |
210    | Calculator       | <kbd>Calculator</kbd>         |                  |
212    | Mail             | <kbd>Mail</kbd>               |                  |
214    | MediaVolMute     | <kbd>Media Vol Mute</kbd>     |                  |
216    | MediaVolDown     | <kbd>Media Vol Down</kbd>     |                  |
218    | MediaVolUp       | <kbd>Media Vol Up</kbd>       |                  |
220    | MediaNext        | <kbd>Media Next</kbd>         |                  |
222    | MediaPrev        | <kbd>Media Prev</kbd>         |                  |
224    | MediaStop        | <kbd>Media Stop</kbd>         |                  |
226    | MediaPlayPause   | <kbd>Media Play/Pause</kbd>   |                  |
228    | MediaSelect      | <kbd>Media Select</kbd>       |                  |
230    | BrowserBack      | <kbd>Browser Back</kbd>       |                  |
232    | BrowserForward   | <kbd>Browser Forward</kbd>    |                  |
234    | BrowserRefresh   | <kbd>Browser Refresh</kbd>    |                  |
236    | BrowserStop      | <kbd>Browser Stop</kbd>       |                  |
238    | BrowserSearch    | <kbd>Browser Search</kbd>     |                  |
240    | BrowserFavorites | <kbd>Browser Favorites</kbd>  |                  |
242    | BrowserHome      | <kbd>Browser Home</kbd>       |                  |

### Mouse

```
ESC _ event=mouse ; kbmods=<KeyMods> ; coord=<X>,<Y> ; buttons=<ButtonState> ; wheel=<DeltaY>,<DeltaX> ESC \
```

Attribute                 | Description
--------------------------|------------
`kbmods=<KeyMods>`        | Keyboard modifiers (see Keyboard event).
`coord=<X>,<Y>`           | Mouse pointer coorinates.
`buttons=<ButtonState>`   | Mouse button state.
`wheel=<DeltaY>,<DeltaX>` | Vertical and horizontal wheel delta.

In response to the activation of `mouse` tracking, the application receives a vt-sequence containing current mouse state:
```
ESC _ event=mouse ; kbmods=<KeyMods> ; coord=<X>,<Y> ; buttons=<ButtonState> ESC \
```

The mouse tracking event fires on any mouse activity, as well as on keyboard modifier changes.

#### Mouse button state

Bit | Active button
----|--------------
0   | Left
1   | Right
2   | Middle
3   | 4th
4   | 5th

Note: Mouse tracking will continue outside the terminal window as long as the mouse button pressed inside the window is active. In this case, coordinates with negative values are possible.

### Focus

```
ESC _ event=focus ; state=<FocusState> ESC \
```

Attribute            | Description
---------------------|------------
`state=<FocusState>` | Terminal window focus state:<br>\<FocusState\>=1 - Focused.<br>\<FocusState\>=0 - Unfocused.

In response to the activation of `focus` tracking, the application receives a vt-sequence containing current focus state.

### Clipboard

```
ESC _ event=clipoard ; format=<ClipFormat> ; security=<SecLevel> ; data=<Data> ESC \
```

Attribute             | Description
----------------------|------------
`format=<ClipFormat>` | Clipboard data format.
`security=<SecLevel>` | Security level.
`data=<Data>`         | Base64 encoded data.

#### Clipboard data format

Format | Description
-------|------------
`text` | Plain text.
`rich` | Rich text format.
`html` | HTML format.
`ansi` | ANSI/VT format.

#### Security level

Bit    | Description
-------|------------
`0x01` | Exclude clipboard content from monitor processing.
`0x02` | Can include in clipboard history.
`0x04` | Can upload to cloud clipboard.

### Window

```
ESC _ event=window ; size=<Width>,<Height> ; cursor=<X>,<Y> ; region=<Left>,<Top>,<Right>,<Bottom> ; selection=<StartX>,<StartY>,<EndX>,<EndY>,<Mode> ESC \
```

Attribute                                          | Description
---------------------------------------------------|------------
`size=<Width>,<Height>`                            | Terminal window size in cells.
`cursor=<X>,<Y>`                                   | Current text cursor position.
`region=<Left>,<Top>,<Right>,<Bottom>`             | Scrolling region margins.
`selection=<StartX>,<StartY>,<EndX>,<EndY>,<Mode>` | Coordinates of the text selection start/end (half-open interval) and text selection mode:<br>\<Mode\>=0 - Line-based.<br>\<Mode\>=1 - Rect-based.

In response to the activation of `window` tracking, the application receives a vt-sequence containing current window state.

#### Mandatory synchronization

When the terminal window is resized, the changes are only applied after a handshake between the terminal and the application. Successive multiple resizing of the window initiates the same number of handshakes.

Handshake steps:
1. Terminal requests a new size, omitting all other parameters.
   - Application receives the request and prepares for resizing, e.g. by updating, cropping or deleting visible lines.
2. Application replies with the same message as the request.
3. Terminal applies the new size and sends the changes.
   - Application updates its UI.

```
Terminal:    ESC _ event=window ; size=<Width>,<Height> ESC \
Application: ESC _ event=window ; size=<Width>,<Height> ESC \
Terminal:    ESC _ event=window ; size=<Width>,<Height> ; cursor=<X>,<Y> ; region=<Left>,<Top>,<Right>,<Bottom> ; selection=<StartX>,<StartY>,<EndX>,<EndY>,<Mode> ESC \
```

Note that the terminal window resizing always reflows the scrollback, so the window size, cursor position, scrolling regions, and selection coordinates are subject to change during step 3. Upon receiving the resize request (step 1), a full-screen application can prepare a scrollback by cropping visible lines to avoid unwanted line wrapping or line extrusion, then send a resize confirmation (step 2). In case the aplication's output is anchored to the current cursor position or uses scrolling regions, the application should wait after step 2 for the updated values before continuing to output. 

Hypothetical case with Far Manager (FM):
- FM saves visible original scrollback.
- FM draws its UI on top of the visible original scrollback.
- Terminal sends a resize request.
- FM receives request.
- FM restores the original scrollback.
- FM replies on resize request.
- Terminal receives reply.
- Terminal resizes the window and reflows the scrollback.
- Terminal sends modified window parameters.
- FM receives modified window parameters.
- FM saves the modified scrollback.
- FM draws its UI on top of the scrollback.

#### Selection tracking

The window size tracking sequence is fired after every scrollback text selection changed. In the case of using the mouse for selection, a single left click is treated as a special case of selection when the start and end are the same (empty selection).

Note that selected text in the scrollback above the top index row will produce negative Y-coordinate values.

### System

```
ESC _ event=system ; signal=<Signal> ESC \
```

Signal | Description
-------|------------
`0`    | Terminal window closing.
`1`    | <kbd>Ctrl+Break</kbd> pressed.
`2`    | Log off.
`3`    | System shutdown.

The application must respond to the terminal within 5 seconds with the same message confirming that it will close itself without being forced. For reasons 0 or 1 responses, the application can continue to run if needed. In the absence of confirmation, and also in the case of reasons 2 or 3, the application will be forced to close after 5 seconds if it does not terminate itself.

## Usage Examples

### C++20

```c++
#include <iostream>

int main()
{
    std::cout << "test" << '\n';
}
```

### Python

```python
#!/bin/python

while True:
    print('test\n')
```

### PowerShell

```powershell
while ($True)
{
    "test\n";
}
```