status: draft

# Next Generation VT Input Mode Protocol

The goal of the `ngvt-input-mode` protocol is to make command line interactivity cross-platform.

- No TTY required.
- No OS-level signal tracking required.

## Audience

You want to:
- Operate without an allocated TTY.
- Share you application on LAN (using inetd, netcat, etc).
- Track every key press and key release.
- Track position dependent keys such as WASD.
- Simplify functional key parsing.
- Distinguish between Left and Right physical keys.
- Track the terminal window size.
- Get consistent output regardless of terminal window resize.
- Track mouse outside the terminal window (getting negative coordinates).
- Track scrollback text selection.
- Track application closing and system shutdown.
- Auto restore all terminal modes on exit.
- Be independent of operating system and third party libraries.

## Initialization

```
Set:   ESC _ n g v t ; 0 ; Id ; ... ; Id BEL
Reset: ESC _ n g v t ; 0 BEL
```

Id   | Events to track
-----|------------
1    | Keyboard
2    | Mouse
3    | Focus
4    | Clipboard
5    | Viewport
6    | System

This sequence enables `ngvt-input-mode` and event tracking for the specified event Ids. The mode is deactivated if none of the Ids is specified.

Note: By enabling `ngvt-input-mode`, all terminal modes are automatically saved (to be restored on exit) and switched to something like "raw" mode, in which input is available character by character, echoing is disabled, and all special processing of terminal input and output characters is disabled (except for `LF` to `CR+LF` conversion).

## Events

- Keyboard
  ```
  ESC _ n g v t ; 1 ; KeyId ; KeyState ; CtrlState ; ScanCode ; UniCode ; C0 ; … ; Cn BEL
  ```
- Mouse
  ```
  ESC _ n g v t ; 2 ; MouseX ; MouseY ; ButtonState ; VtWheelDt ; HzWheelDt ; CtrlState BEL
  ```
- Focus
  ```
  ESC _ n g v t ; 3 ; FocusState BEL
  ```
- Clipboard
  ```
  ESC _ n g v t ; 4 ; ClipFormat ; Data BEL
  ```
- Viewport
  ```
  ESC _ n g v t ; 5 ; WinSizeX ; WinSizeY ; CtrlState ; CaretX ; CaretY ; ScrollTop ; ScrollBottom ; ScrollLeft ; ScrollRight ; SelStartX ; SelStartY ; SelEndX ; SelEndY ; SelMode BEL
  ```
- System
  ```
  ESC _ n g v t ; 6 ; Signal BEL
  ```

### Keyboard

```
ESC _ n g v t ; 1 ; KeyId ; KeyState ; CtrlState ; ScanCode ; UniCode ; C0 ; … ; Cn BEL
```

Field            | Description
-----------------|--------------------------
`KeyId`          | Physical key ID.
`KeyState`       | Key state: 1 - Pressed, 0 - Released.
`CtrlState`      | Keyboard modifiers state.
`ScanCode`       | Scan code.
`UniCode`        | First codepoint of the generated string.
`C1`, …, `Cn`    | Continuing codepoints of the generated string.

This sequence fired after every key press and key release. Event data can contain a string generated by a keystroke as a set of codepoints: `UniCode + C1 + ... + Cn`. The string can be fragmented and delivered by multiple consecutive events.

Keystrokes can be
- Functional. Detected by non-zero `KeyId`.
- Printable. Detected by non-zero `UniCode`.
- Place-dependent. Detected by non-zero `ScanCode`.

Function keys always have `UniCode` set to zero, and a set of `C1`, ..., `Cn` containing the VT-string generated by the keystroke. For example:
- Keystroke <kbd>LeftArrow</kbd> generates `←[D` = `UniCode=0; C1=27; C2=91; C3=68`.
- Keystroke <kbd>Ctrl+LeftArrow</kbd> generates `←[1;5D` = `UniCode=0; C1=27; C2=91; C3=49; C4=53; C5=126`.
- Keystroke <kbd>F5</kbd> generates `←[15~` = `UniCode=0; C1=27; C2=91; C3=49; C4=53; C5=126`.
- Keystroke <kbd>Shift+F5</kbd> generates `←[15;2~` = `UniCode=0; C1=27; C2=91; C3=49; C4=53; C5=59; C6=50; C7=126`.

### Mouse

```
ESC _ n g v t ; 2 ; MouseX ; MouseY ; ButtonState ; VtWheelDt ; HzWheelDt ; CtrlState BEL
```

Field          | Description
---------------|--------------------------
`MouseX` / `Y` | Pointer coorinates.
`ButtonState`  | Button state.
`VtWheelDt`    | Vertical wheel delta.
`HzWheelDt`    | Horizontal wheel delta.
`CtrlState`    | Keyboard modifiers state.

The reason for not using the existing mouse tracking modes is the lack of support for negative coordinates and the limited set of buttons.

### Focus

```
ESC _ n g v t ; 3 ; FocusState BEL
```

Field        | Description
-------------|--------------------------
`FocusState` | Terminal window focus state.

The reason for not using the existing focus tracking mode is the convenient enabling/disabling of this mode - all tracking modes in one sequence.

### Clipboard

```
ESC _ n g v t ; 4 ; ClipFormat ; Data BEL
```

Field        | Description
-------------|--------------------------
`ClipFormat` | Clipboard data format.
`Data`       | Base64 encoded data.

The reason for not using bracketed paste mode is that there is no support for transferring binary data and data containing sequences of the bracketed paste mode itself.

### Viewport

```
ESC _ n g v t ; 5 ; WinSizeX ; WinSizeY ; CtrlState ; CaretX ; CaretY ; ScrollTop ; ScrollBottom ; ScrollLeft ; ScrollRight ; SelStartX ; SelStartY ; SelEndX ; SelEndY ; SelMode BEL
```

Field                                        | Description
---------------------------------------------|------------
`WinSizeX`<br>`WinSizeY`                     | Terminal viewport size.
`CaretX`<br>`CaretY`                         | Current text cursor position.
`ScrollTop`/`Bottom`<br>`ScrollLeft`/`Right` | Scrolling region margins.
`SelStartX`/`Y`<br>`SelEndX`/`Y`             | Coordinates of the text selection start/end (half-open interval).
`SelMode`                                    | Text selection mode: 0 - line-based, 1 - rect-based.
`CtrlState`                                  | Keyboard modifiers state.

This sequence is the first one received by the application right after `ngvt-input-mode` is activated (input redirection detection).

#### Viewport tracking

When the terminal window is resized, the viewport is finally changed only after a handshake between the terminal and the application. Successive multiple resizing of the window initiates the same number of handshakes.

Handshake steps:
1. The terminal requests a new size, omitting all other parameters.
2. Application must reply with the same message.
3. The terminal applies the new size and sends the changes.

```
Terminal:    ESC _ n g v t ; 5 ; WinSizeX ; WinSizeY _
Application: ESC _ n g v t ; 5 ; WinSizeX ; WinSizeY _
Terminal:    ESC _ n g v t ; 5 ; WinSizeX ; WinSizeY ; CtrlState ; CaretX ; CaretY ; ScrollTop ; ScrollBottom ; ScrollLeft ; ScrollRight ; SelStartX ; SelStartY ; SelEndX ; SelEndY ; SelMode BEL
```

Note that the terminal window resizing always reflows the scrollback, so the viewport size, cursor position, scrolling regions, and selection coordinates are subject to change during step 3. In case the aplication's output is anchored to the current cursor position or uses scrolling regions, the application should wait after step 2 for the updated values before continuing to output.

#### Selection Tracking

The viewport tracking sequence is fired after every scrollback text selection changed. In the case of using the mouse for selection, a single left click is treated as a special case of selection when the start and end are the same (empty selection).

Note that selected text in the scrollback above the viewport top level will produce negative Y-coordinate values.

### System

```
ESC _ n g v t ; 6 ; Signal BEL
```

Signal | Description
-------|------------
`0`    | Terminal window closing
`1`    | <kbd>Ctrl+Break</kbd> pressed
`2`    | Log off
`3`    | System shutdown

The application must respond to the terminal within 5 seconds with the same message confirming that it will close itself without being forced. For reasons 0 or 1 responses, the application can continue to run if needed. In the absence of confirmation, and also in the case of reasons 2 or 3, the application will be forced to close after 5 seconds if it does not terminate itself.

## Conventions

- All values used in this protocol are decimal and zero-based.
- All unescaped symbols outside of this protocol should be treated as clipboard pasted data.

### Scan Codes

`ScanCode`s are usually useful for applications that need to know which key is pressed, regardless of the current keyboard layout. For example, the WASD (Up, Left, Down, Right) keys for games, which ensure a consistent key formation across QWERTY, AZERTY or Dvorak keyboard layouts.

```
QWERTY: "W" = 11  "A" = 1E  "S" = 1F  "D" = 20
AZERTY: "Z" = 11  "Q" = 1E  "S" = 1F  "D" = 20
Dvorak: "," = 11  "A" = 1E  "O" = 1F  "E" = 20
```

Scan codes for the keys on a standard 104-key keyboard:

```
┌────┐  ┌────╥────╥────╥────┐  ┌────╥────╥────╥────┐  ┌────╥────╥────╥────┐  ┌────╥────╥────┐
| 01 │  | 3B ║ 3C ║ 3D ║ 3E |  | 3F ║ 40 ║ 41 ║ 42 |  | 43 ║ 44 ║ 57 ║ 58 |  |E037║ 46 ║E045|
└────┘  └────╨────╨────╨────┘  └────╨────╨────╨────┘  └────╨────╨────╨────┘  └────╨────╨────┘
┌────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────╥────────┐  ┌────╥────╥────┐  ┌────╥────╥────╥────┐
| 29 ║ 02 ║ 03 ║ 04 ║ 05 ║ 06 ║ 07 ║ 08 ║ 09 ║ 0A ║ 0B ║ 0C ║ 0D ║     0E |  |E052║E047║E049|  | 45 ║E035║ 37 ║ 4A |
╞════╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══════╡  ╞════╬════╬════╡  ╞════╬════╬════╬════╡
| 0F   ║ 10 ║ 11 ║ 12 ║ 13 ║ 14 ║ 15 ║ 16 ║ 17 ║ 18 ║ 19 ║ 1A ║ 1B ║   2B |  |E053║E04F║E051|  | 47 ║ 48 ║ 49 ║    |
╞══════╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩╦═══╩══════╡  └────╨────╨────┘  ╞════╬════╬════╣ 4E |
| 3A    ║ 1E ║ 1F ║ 20 ║ 21 ║ 22 ║ 23 ║ 24 ║ 25 ║ 26 ║ 27 ║ 28 ║       1C |                    | 4B ║ 4C ║ 4D ║    |
╞═══════╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩═╦══╩══════════╡       ┌────┐       ╞════╬════╬════╬════╡
| 2A      ║ 2C ║ 2D ║ 2E ║ 2F ║ 30 ║ 31 ║ 32 ║ 33 ║ 34 ║ 35 ║          36 |       |E048|       | 4F ║ 50 ║ 51 ║    |
╞══════╦══╩═╦══╩═══╦╩════╩════╩════╩════╩════╩════╩╦═══╩╦═══╩╦═════╦══════╡  ┌────┼────┼────┐  ╞════╩════╬════╣E01C|
| 1D   ║ 5B ║ 38   ║               39              ║E038║ 5C ║  5D ║ E01D |  |E04B|E050|E04D|  |      52 ║ 53 ║    |
└──────╨────╨──────╨───────────────────────────────╨────╨────╨─────╨──────┘  └────┴────┴────┘  └─────────╨────╨────┘
```

### Keyboard Modifiers

The state `CtrlState` of keyboard modifiers is the binary OR of all currently pressed modifiers and enabled modes.

Modifier                                | kvm CtrlState   | win32 CtrlState
----------------------------------------|-----------------|-----------------
<kbd>RightAlt</kbd> or <kbd>AltGr</kbd> | `   1` `0x0001` | `   1`  `0x0001`
<kbd>LeftAlt</kbd>                      | `   2` `0x0002` | `   2`  `0x0002`
<kbd>Alt</kbd>                          | `   3` `0x0003` | `   3`  `0x0002`
<kbd>RightCtrl</kbd>                    | `   4` `0x0004` | `   4`  `0x0004`
<kbd>LeftCtrl</kbd>                     | `   8` `0x0008` | `   8`  `0x0008`
<kbd>Ctrl</kbd>                         | `  12` `0x000C` | `  12`  `0x000C`
<kbd>RightShift</kbd>                   | `2048` `0x0800` | `  16`  `0x0010`
<kbd>LeftShift</kbd>                    | `  16` `0x0010` | `  16`  `0x0010`
<kbd>Shift</kbd>                        | `2064` `0x0810` | `  16`  `0x0010`
<kbd>NumLock Mode</kbd>                 | `  32` `0x0020` | `  32`  `0X0020`
<kbd>ScrollLock Mode</kbd>              | `  64` `0x0040` | `  64`  `0X0040`
<kbd>CapsLock Mode</kbd>                | ` 128` `0x0080` | ` 128`  `0x0080`
<kbd>Extended Key</kbd>                 | ` 256` `0x0100` | ` 256`  `0x0100`
<kbd>RightWin</kbd>                     | ` 512` `0x0200` |
<kbd>LeftWin</kbd>                      | `1024` `0x0400` |
<kbd>Win</kbd>                          | `1536` `0x0600` |
<kbd>Normal Mode</kbd>                  | `4096` `0x1000` |
<kbd>Application Mode</kbd>             | `8192` `0x2000` |

### Physical Keys

The strings generated by the keystroke is not mapped wth physical keys because it depends on modifiers state and the national keyboard layout.

The `KeyId` is incremented by 2 for each generic key, providing two `KeyId` placeholders for each physical key to distinguish between Left and Right (or Numpad) in the last bit. Ignore the last bit of `KeyId` for tracking generic keys.

Key ID | Name             | Physical Key                  | ScanCode         | Notes
-------|------------------|-------------------------------|------------------|-------------
0      | undef            |                               |                  |
2      | Esc              | <kbd>Esc</kbd>                | `    1` `0x01`   |
4      | Space            | <kbd>Space</kbd>              | `   57` `0x39`   |
6      | Backspace        | <kbd>Backspace</kbd>          | `   14` `0x0E`   |
8      | Tab              | <kbd>Tab</kbd>                | `   15` `0x0F`   |
10     | LeftShift        | <kbd>Left Shift</kbd>         | `   42` `0x2A`   |
11     | RightShift       | <kbd>Right Shift</kbd>        | `   54` `0x36`   |
12     | LeftCtrl         | <kbd>Left Ctrl</kbd>          | `   29` `0x1D`   |
13     | RightCtrl        | <kbd>Right Ctrl</kbd>         | `57373` `0xE01D` |
14     | LeftAlt          | <kbd>Left Alt</kbd>           | `   56` `0x38`   |
15     | RightAlt         | <kbd>Right Alt</kbd>          | `57400` `0xE038` |
16     | LeftWin          | <kbd>Left Win</kbd>           | `   91` `0x5B`   |
17     | RightWin         | <kbd>Right Win</kbd>          | `   92` `0x5C`   |
18     | CapsLock         | <kbd>Caps Lock</kbd>          | `   58` `0x3A`   |
20     | NumLock          | <kbd>Num Lock</kbd>           | `   69` `0x45`   |
22     | ScrollLock       | <kbd>Scroll Lock</kbd>        | `   69` `0x45`   |
24     | Apps             | <kbd>Apps</kbd>               | `   93` `0x5D`   |
26     | Break            | <kbd>Break</kbd>              | `57414` `0xE046` | Ctrl + Pause
28     | Pause            | <kbd>Pause</kbd>              | `57412` `0xE045` |
30     | Select           | <kbd>Select</kbd>             |                  |
32     | SysRq            | <kbd>SysRq</kbd>              | `   84` `0x54`   | Alt + PrintScreen
34     | PrintScreen      | <kbd>Print Screen</kbd>       | `57399` `0xE037` |
36     | Enter            | <kbd>Enter</kbd>              | `   28` `0x1C`   |
37     | NumpadEnter      | <kbd>Numpad Enter</kbd>       | `57372` `0xE01C` |
38     | PageUp           | <kbd>PageUp</kbd>             | `57417` `0xE049` |
39     | NumpadPageUp     | <kbd>Numpad PageUp</kbd>      | `   73` `0x49`   |
40     | PageDown         | <kbd>PageDown</kbd>           | `57425` `0xE051` |
41     | NumpadPageDown   | <kbd>Numpad PageDown</kbd>    | `   81` `0x51`   |
42     | End              | <kbd>End</kbd>                | `57423` `0xE04F` |
43     | NumpadEnd        | <kbd>Numpad End</kbd>         | `   79` `0x4F`   |
44     | Home             | <kbd>Home</kbd>               | `57415` `0xE047` |
45     | NumpadHome       | <kbd>Numpad Home</kbd>        | `   71` `0x47`   |
46     | LeftArrow        | <kbd>Left Arrow</kbd>         | `57419` `0xE04B` |
47     | NumpadLeftArrow  | <kbd>Numpad Left Arrow</kbd>  | `   75` `0x4B`   |
48     | UpArrow          | <kbd>Up Arrow</kbd>           | `57416` `0xE048` |
49     | NumpadUpArrow    | <kbd>Numpad Up Arrow</kbd>    | `   72` `0x48`   |
50     | RightArrow       | <kbd>Right Arrow</kbd>        | `57421` `0xE04D` |
51     | NumpadRightArrow | <kbd>Numpad Right Arrow</kbd> | `   77` `0x4D`   |
52     | DownArrow        | <kbd>Down Arrow</kbd>         | `57424` `0xE050` |
53     | NumpadDownArrow  | <kbd>Numpad Down Arrow</kbd>  | `   80` `0x50`   |
54     | Key0             | <kbd>0</kbd>                  | `   11` `0x0B`   |
55     | Numpad0          | <kbd>Numpad 0</kbd>           | `   82` `0x52`   |
56     | Key1             | <kbd>1</kbd>                  | `    2` `0x02`   |
57     | Numpad1          | <kbd>Numpad 1</kbd>           | `   79` `0x4F`   |
58     | Key2             | <kbd>2</kbd>                  | `    3` `0x03`   |
59     | Numpad2          | <kbd>Numpad 2</kbd>           | `   80` `0x50`   |
60     | Key3             | <kbd>3</kbd>                  | `    4` `0x04`   |
61     | Numpad3          | <kbd>Numpad 3</kbd>           | `   81` `0x51`   |
62     | Key4             | <kbd>4</kbd>                  | `    5` `0x05`   |
63     | Numpad4          | <kbd>Numpad 4</kbd>           | `   75` `0x4B`   |
64     | Key5             | <kbd>5</kbd>                  | `    6` `0x06`   |
65     | Numpad5          | <kbd>Numpad 5</kbd>           | `   76` `0x4C`   |
66     | Key6             | <kbd>6</kbd>                  | `    7` `0x07`   |
67     | Numpad6          | <kbd>Numpad 6</kbd>           | `   77` `0x4D`   |
68     | Key7             | <kbd>7</kbd>                  | `    8` `0x08`   |
69     | Numpad7          | <kbd>Numpad 7</kbd>           | `   71` `0x47`   |
70     | Key8             | <kbd>8</kbd>                  | `    9` `0x09`   |
71     | Numpad8          | <kbd>Numpad 8</kbd>           | `   72` `0x48`   |
72     | Key9             | <kbd>9</kbd>                  | `   10` `0x0A`   |
73     | Numpad9          | <kbd>Numpad 9</kbd>           | `   73` `0x49`   |
74     | Insert           | <kbd>Insert</kbd>             | `57426` `0xE052` |
75     | NumpadInsert     | <kbd>Numpad Insert</kbd>      | `   82` `0x52`   |
76     | Delete           | <kbd>Delete</kbd>             | `57427` `0xE053` |
77     | NumpadDelete     | <kbd>Numpad Delete</kbd>      | `   83` `0x55`   |
78     | Clear            | <kbd>Clear</kbd>              | `   76` `0x4C`   |
79     | NumpadClear      | <kbd>Numpad Clear</kbd>       | `   76` `0x4C`   | Numpad 5
80     | Multiply         | <kbd>*</kbd>                  |                  |
81     | NumpadMultiply   | <kbd>Numpad *</kbd>           | `   55` `0x37`   |
82     | Plus             | <kbd>+</kbd>                  |                  |
83     | NumpadPlus       | <kbd>Numpad +</kbd>           | `   78` `0x4E`   |
84     | Separator        | <kbd>Separator</kbd>          |                  |
85     | NumpadSeparator  | <kbd>Numpad Separator</kbd>   |                  |
86     | Minus            | <kbd>-</kbd>                  | `   12` `0x0C`   |
87     | NumpadMinus      | <kbd>Numpad -</kbd>           | `   74` `0x4A`   |
88     | Period           | <kbd>.</kbd>                  | `   52` `0x34`   |
89     | NumpadDecimal    | <kbd>Numpad .</kbd>           | `   83` `0x53`   |
90     | Slash            | <kbd>/</kbd>                  | `   53` `0x35`   |
91     | NumpadSlash      | <kbd>Numpad /</kbd>           | `57397` `0xE035` |
92     | BackSlash        | <kbd>\\</kbd>                 | `   43` `0x2B`   |
94     | OpenBracket      | <kbd>[</kbd>                  | `   26` `0x1A`   |
96     | ClosedBracket    | <kbd>]</kbd>                  | `   27` `0x1B`   |
98     | Equal            | <kbd>=</kbd>                  | `   13` `0x0D`   |
100    | BackQuote        | <kbd>\`</kbd>                 | `   41` `0x29`   |
102    | SingleQuote      | <kbd>'</kbd>                  | `   40` `0x28`   |
104    | Comma            | <kbd>,</kbd>                  | `   51` `0x33`   |
106    | Semicolon        | <kbd>;</kbd>                  | `   39` `0x27`   |
108    | F1               | <kbd>F1</kbd>                 | `   59` `0x3B`   |
110    | F2               | <kbd>F2</kbd>                 | `   61` `0x3C`   |
112    | F3               | <kbd>F3</kbd>                 | `   62` `0x3D`   |
114    | F4               | <kbd>F4</kbd>                 | `   63` `0x3E`   |
116    | F5               | <kbd>F5</kbd>                 | `   64` `0x3F`   |
118    | F6               | <kbd>F6</kbd>                 | `   65` `0x40`   |
120    | F7               | <kbd>F7</kbd>                 | `   66` `0x41`   |
122    | F8               | <kbd>F8</kbd>                 | `   67` `0x42`   |
124    | F9               | <kbd>F9</kbd>                 | `   68` `0x43`   |
126    | F10              | <kbd>F10</kbd>                | `   69` `0x44`   |
128    | F11              | <kbd>F11</kbd>                | `   87` `0x57`   |
130    | F12              | <kbd>F12</kbd>                | `   88` `0x5B`   |
132    | F13              | <kbd>F13</kbd>                |                  |
134    | F14              | <kbd>F14</kbd>                |                  |
136    | F15              | <kbd>F15</kbd>                |                  |
138    | F16              | <kbd>F16</kbd>                |                  |
140    | F17              | <kbd>F17</kbd>                |                  |
142    | F18              | <kbd>F18</kbd>                |                  |
144    | F19              | <kbd>F19</kbd>                |                  |
146    | F20              | <kbd>F20</kbd>                |                  |
148    | F21              | <kbd>F21</kbd>                |                  |
150    | F22              | <kbd>F22</kbd>                |                  |
152    | F23              | <kbd>F23</kbd>                |                  |
154    | F24              | <kbd>F24</kbd>                |                  |
156    | KeyA             | <kbd>A</kbd>                  |                  |
158    | KeyB             | <kbd>B</kbd>                  |                  |
160    | KeyC             | <kbd>C</kbd>                  |                  |
162    | KeyD             | <kbd>D</kbd>                  |                  |
164    | KeyE             | <kbd>E</kbd>                  |                  |
166    | KeyF             | <kbd>F</kbd>                  |                  |
168    | KeyG             | <kbd>G</kbd>                  |                  |
170    | KeyH             | <kbd>H</kbd>                  |                  |
172    | KeyI             | <kbd>I</kbd>                  |                  |
174    | KeyJ             | <kbd>J</kbd>                  |                  |
176    | KeyK             | <kbd>K</kbd>                  |                  |
178    | KeyL             | <kbd>L</kbd>                  |                  |
180    | KeyM             | <kbd>M</kbd>                  |                  |
182    | KeyN             | <kbd>N</kbd>                  |                  |
184    | KeyO             | <kbd>O</kbd>                  |                  |
186    | KeyP             | <kbd>P</kbd>                  |                  |
188    | KeyQ             | <kbd>Q</kbd>                  |                  |
190    | KeyR             | <kbd>R</kbd>                  |                  |
192    | KeyS             | <kbd>S</kbd>                  |                  |
194    | KeyT             | <kbd>T</kbd>                  |                  |
196    | KeyU             | <kbd>U</kbd>                  |                  |
198    | KeyV             | <kbd>V</kbd>                  |                  |
200    | KeyW             | <kbd>W</kbd>                  |                  |
202    | KeyX             | <kbd>X</kbd>                  |                  |
204    | KeyY             | <kbd>Y</kbd>                  |                  |
206    | KeyZ             | <kbd>Z</kbd>                  |                  |
208    | Sleep            | <kbd>Sleep</kbd>              |                  |
210    | WWW              | <kbd>WWW</kbd>                |                  |
212    | Calculator       | <kbd>Calculator</kbd>         |                  |
214    | Mail             | <kbd>Mail</kbd>               |                  |
216    | MediaVolMute     | <kbd>Media Vol Mute</kbd>     |                  |
218    | MediaVolDown     | <kbd>Media Vol Down</kbd>     |                  |
220    | MediaVolUp       | <kbd>Media Vol Up</kbd>       |                  |
222    | MediaNext        | <kbd>Media Next</kbd>         |                  |
224    | MediaPrev        | <kbd>Media Prev</kbd>         |                  |
226    | MediaStop        | <kbd>Media Stop</kbd>         |                  |
228    | MediaPlayPause   | <kbd>Media Play/Pause</kbd>   |                  |
230    | MediaSelect      | <kbd>Media Select</kbd>       |                  |
232    | BrowserBack      | <kbd>Browser Back</kbd>       |                  |
234    | BrowserForward   | <kbd>Browser Forward</kbd>    |                  |
236    | BrowserRefresh   | <kbd>Browser Refresh</kbd>    |                  |
238    | BrowserStop      | <kbd>Browser Stop</kbd>       |                  |
240    | BrowserSearch    | <kbd>Browser Search</kbd>     |                  |
242    | BrowserFavorites | <kbd>Browser Favorites</kbd>  |                  |
244    | BrowserHome      | <kbd>Browser Home</kbd>       |                  |

## Usage Examples

### C++20

```c++
#include <iostream>

int main()
{
    std::cout << "test" << '\n';
}
```

### Python

```python
#!/bin/python

while True:
    print('test\n')
```

### PowerShell

```powershell
while ($True)
{
   "test";
}
```