--
--  countries.sql
--
--  $Id$
--
--  Creates a countries database
--
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--
--  Copyright (C) 1998-2014 OpenLink Software
--
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--
--

--ECHO BOTH "Loading Countries Database\n";

USE Demo;


DB.DBA.exec_no_error('DROP TABLE demo.Flags');
DB.DBA.exec_no_error('DROP TABLE demo.Provinces');
DB.DBA.exec_no_error('DROP TABLE demo.Countries');

DB.DBA.exec_no_error('CREATE TABLE demo.Countries
        (Name VARCHAR NOT NULL,
--         Code VARCHAR not null unique,
         Code VARCHAR unique,
         SmallFlagDAVResourceName varchar,
         LargeFlagDAVResourceName varchar,
         SmallFlagDAVResourceURI varchar,
         LargeFlagDAVResourceURI varchar,
         Lat REAL,
         Lng REAL,
         PRIMARY KEY(Name))');

DB.DBA.exec_no_error('CREATE TABLE demo.Flags
        (CountryCode VARCHAR(128) references Countries (Code) on update cascade on delete cascade,
         LargeFlag LONG VARBINARY,
         SmallFlag LONG VARBINARY,
         PRIMARY KEY(CountryCode))');

DB.DBA.exec_no_error('CREATE TABLE demo.Provinces
        (CountryCode VARCHAR NOT NULL references Countries (Code) on update cascade on delete cascade,
         Province VARCHAR NOT NULL,
         PRIMARY KEY(CountryCode, Province))');

INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Afghanistan',33,65,'af','af-flag.gif','af-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Akrotiri',NULL,NULL,'ax','ax-flag.gif','ax-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Albania',41,20,'al','al-flag.gif','al-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Algeria',28,3,'ag','ag-flag.gif','ag-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('American Samoa',-14.33333301544189,-170,'aq','aq-flag.gif','aq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Andorra',42.5,1.5,'an','an-flag.gif','an-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Angola',-12.5,18.5,'ao','ao-flag.gif','ao-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Anguilla',18.25,-63.16666793823242,'av','av-flag.gif','av-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Antarctica',-90,0,'ay',null,null);
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Antigua and Barbuda',17.04999923706055,-61.79999923706055,'ac','ac-flag.gif','ac-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Arctic Ocean',90,0,'xq',null,null);
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Argentina',-34,-64,'ar','ar-flag.gif','ar-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Armenia',40,45,'am','am-flag.gif','am-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Aruba',12.5,-69.96666717529297,'aa','aa-flag.gif','aa-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ashmore and Cartier Islands',-12.23333358764648,123.0833358764648,'at','at-flag.gif','at-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Atlantic Ocean',0,-25,'zh',null,null);
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Australia',-27,133,'as','as-flag.gif','as-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Austria',47.33333206176758,13.33333301544189,'au','au-flag.gif','au-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Azerbaijan',40.5,47.5,'aj','aj-flag.gif','aj-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bahamas, The',24.25,-76,'bf','bf-flag.gif','bf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bahrain',26,50.54999923706055,'ba','ba-flag.gif','ba-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Baker Island',0.2166666686534882,-176.5166625976562,'fq','fq-flag.gif','fq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bangladesh',24,90,'bg','bg-flag.gif','bg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Barbados',13.16666698455811,-59.53333282470703,'bb','bb-flag.gif','bb-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bassas da India',-21.5,39.83333206176758,'bs','bs-flag.gif','bs-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Belarus',53,28,'bo','bo-flag.gif','bo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Belgium',50.83333206176758,4,'be','be-flag.gif','be-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Belize',NULL,NULL,'bh','bh-flag.gif','bh-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Benin',9.5,2.25,'bn','bn-flag.gif','bn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bermuda',32.33333206176758,-64.75,'bd','bd-flag.gif','bd-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bhutan',27.5,90.5,'bt','bt-flag.gif','bt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bolivia',-17,-65,'bl','bl-flag.gif','bl-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bosnia and Herzegovina',44,18,'bk','bk-flag.gif','bk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Botswana',-22,24,'bc','bc-flag.gif','bc-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bouvet Island',-54.43333435058594,3.400000095367432,'bv','bv-flag.gif','bv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Brazil',-10,-55,'br','br-flag.gif','br-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('British Indian Ocean Territory',-6,71.5,'io','io-flag.gif','io-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('British Virgin Islands',18.5,-64.5,'vi','vi-flag.gif','vi-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Brunei',4.5,114.6666641235352,'bx','bx-flag.gif','bx-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bulgaria',43,25,'bu','bu-flag.gif','bu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Burkina Faso',13,-2,'uv','uv-flag.gif','uv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Burma',22,98,'bm','bm-flag.gif','bm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Burundi',-3.5,30,'by','by-flag.gif','by-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cambodia',13,105,'cb','cb-flag.gif','cb-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cameroon',6,12,'cm','cm-flag.gif','cm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Canada',60,-95,'ca','ca-flag.gif','ca-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cape Verde',16,-24,'cv','cv-flag.gif','cv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cayman Islands',19.5,-80.5,'cj','cj-flag.gif','cj-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Central African Republic',7,21,'ct','ct-flag.gif','ct-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Chad',15,19,'cd','cd-flag.gif','cd-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Chile',-30,-71,'ci','ci-flag.gif','ci-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('China',35,105,'ch','ch-flag.gif','ch-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Christmas Island',-10.5,105.6666641235352,'kt','kt-flag.gif','kt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Clipperton Island',10.28333377838135,-109.216667175293,'ip','ip-flag.gif','ip-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cocos (Keeling) Islands',-12.5,96.83333587646484,'ck','ck-flag.gif','ck-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Colombia',4,-72,'co','co-flag.gif','co-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Comoros',-12.16666698455811,44.25,'cn','cn-flag.gif','cn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Congo, Democratic Republic of the',0,25,'cg','cg-flag.gif','cg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Congo, Republic of the',-1,15,'cf','cf-flag.gif','cf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cook Islands',-21.23333358764648,-159.7666625976562,'cw','cw-flag.gif','cw-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Coral Sea Islands',-18,152,'cr','cr-flag.gif','cr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Costa Rica',10,-84,'cs','cs-flag.gif','cs-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cote d\47Ivoire',NULL,NULL,'iv','iv-flag.gif','iv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Croatia',45.16666793823242,15.5,'hr','hr-flag.gif','hr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cuba',21.5,-80,'cu','cu-flag.gif','cu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cyprus',35,33,'cy','cy-flag.gif','cy-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Czech Republic',49.75,15.5,'ez','ez-flag.gif','ez-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Denmark',56,10,'da','da-flag.gif','da-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Dhekelia',NULL,NULL,'dx','dx-flag.gif','dx-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Djibouti',11.5,43,'dj','dj-flag.gif','dj-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Dominica',15.41666698455811,-61.33333206176758,'do','do-flag.gif','do-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Dominican Republic',19,-70.66666412353516,'dr','dr-flag.gif','dr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('East Timor',NULL,NULL,'tt','tt-flag.gif','tt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ecuador',-2,-77.5,'ec','ec-flag.gif','ec-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Egypt',27,30,'eg','eg-flag.gif','eg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('El Salvador',13.83333301544189,-88.91666412353516,'es','es-flag.gif','es-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Equatorial Guinea',2,10,'ek','ek-flag.gif','ek-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Eritrea',15,39,'er','er-flag.gif','er-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Estonia',59,26,'en','en-flag.gif','en-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ethiopia',8,38,'et','et-flag.gif','et-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Europa Island',-22.33333396911621,40.36666488647461,'eu','eu-flag.gif','eu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('European Union',NULL,NULL,'ee','ee-flag.gif','ee-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Falkland Islands (Islas Malvinas)',-51.75,-59,'fk','fk-flag.gif','fk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Faroe Islands',62,-7,'fo','fo-flag.gif','fo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Fiji',-18,175,'fj','fj-flag.gif','fj-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Finland',64,26,'fi','fi-flag.gif','fi-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('France',46,2,'fr','fr-flag.gif','fr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('French Guiana',4,-53,'fg','fg-flag.gif','fg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('French Polynesia',-15,-140,'fp','fp-flag.gif','fp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('French Southern and Antarctic Lands',-43,67,'fs','fs-flag.gif','fs-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gabon',-1,11.75,'gb','gb-flag.gif','gb-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gambia, The',13.46666622161865,-16.5666675567627,'ga','ga-flag.gif','ga-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gaza Strip',31.41666603088379,34.33333206176758,'gz','gz-flag.gif','gz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Georgia',42,43.5,'gg','gg-flag.gif','gg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Germany',51,9,'gm','gm-flag.gif','gm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ghana',8,-2,'gh','gh-flag.gif','gh-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gibraltar',36.18333435058594,-5.366666793823242,'gi','gi-flag.gif','gi-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Glorioso Islands',-11.5,47.33333206176758,'go','go-flag.gif','go-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Greece',39,22,'gr','gr-flag.gif','gr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Greenland',72,-40,'gl','gl-flag.gif','gl-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Grenada',12.11666679382324,-61.66666793823242,'gj','gj-flag.gif','gj-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guadeloupe',16.25,-61.58333206176758,'gp','gp-flag.gif','gp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guam',NULL,NULL,'gq','gq-flag.gif','gq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guatemala',15.5,-90.25,'gt','gt-flag.gif','gt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guernsey',49.46666717529297,-2.583333253860474,'gk','gk-flag.gif','gk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guinea',11,-10,'gv','gv-flag.gif','gv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guinea-Bissau',12,-15,'pu','pu-flag.gif','pu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guyana',5,-59,'gy','gy-flag.gif','gy-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Haiti',19,-72.41666412353516,'ha','ha-flag.gif','ha-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Heard Island and McDonald Islands',-53.09999847412109,72.51667022705078,'hm','hm-flag.gif','hm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Holy See (Vatican City)',41.90000152587891,12.44999980926514,'vt','vt-flag.gif','vt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Honduras',15,-86.5,'ho','ho-flag.gif','ho-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Hong Kong',22.25,114.1666641235352,'hk','hk-flag.gif','hk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Howland Island',0.800000011920929,-176.6333312988281,'hq','hq-flag.gif','hq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Hungary',47,20,'hu','hu-flag.gif','hu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Iceland',65,-18,'ic','ic-flag.gif','ic-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('India',20,77,'in','in-flag.gif','in-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Indian Ocean',-20,80,'xo','xo-flag.gif','xo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Indonesia',-5,120,'id','id-flag.gif','id-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Iran',32,53,'ir','ir-flag.gif','ir-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Iraq',33,44,'iz','iz-flag.gif','iz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ireland',53,-8,'ei','ei-flag.gif','ei-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Israel',31.5,34.75,'is','is-flag.gif','is-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Italy',42.83333206176758,12.83333301544189,'it','it-flag.gif','it-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jamaica',18.25,-77.5,'jm','jm-flag.gif','jm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jan Mayen',71,-8,'jn','jn-flag.gif','jn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Japan',36,138,'ja','ja-flag.gif','ja-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jarvis Island',-0.3666666746139526,-160.0500030517578,'dq','dq-flag.gif','dq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jersey',49.25,-2.166666746139526,'je','je-flag.gif','je-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Johnston Atoll',16.75,-169.5166625976562,'jq','jq-flag.gif','jq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jordan',31,36,'jo','jo-flag.gif','jo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Juan de Nova Island',-17.04999923706055,42.75,'ju','ju-flag.gif','ju-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kazakhstan',48,68,'kz','kz-flag.gif','kz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kenya',1,38,'ke','ke-flag.gif','ke-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kingman Reef',6.400000095367432,-162.3999938964844,'kq','kq-flag.gif','kq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kiribati',1.416666626930237,173,'kr','kr-flag.gif','kr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Korea, North',40,127,'kn','kn-flag.gif','kn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Korea, South',37,127.5,'ks','ks-flag.gif','ks-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kuwait',29.5,45.75,'ku','ku-flag.gif','ku-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kyrgyzstan',41,75,'kg','kg-flag.gif','kg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Laos',18,105,'la','la-flag.gif','la-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Latvia',57,25,'lg','lg-flag.gif','lg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Lebanon',33.83333206176758,35.83333206176758,'le','le-flag.gif','le-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Lesotho',-29.5,28.5,'lt','lt-flag.gif','lt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Liberia',6.5,-9.5,'li','li-flag.gif','li-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Libya',25,17,'ly','ly-flag.gif','ly-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Liechtenstein',47.16666793823242,9.533333778381348,'ls','ls-flag.gif','ls-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Lithuania',56,24,'lh','lh-flag.gif','lh-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Luxembourg',49.75,6.166666507720947,'lu','lu-flag.gif','lu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Macau',22.16666603088379,113.5500030517578,'mc','mc-flag.gif','mc-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Macedonia',NULL,NULL,'mk','mk-flag.gif','mk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Madagascar',-20,47,'ma','ma-flag.gif','ma-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Malawi',-13.5,34,'mi','mi-flag.gif','mi-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Malaysia',2.5,112.5,'my','my-flag.gif','my-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Maldives',3.25,73,'mv','mv-flag.gif','mv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mali',17,-4,'ml','ml-flag.gif','ml-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Malta',35.83333206176758,14.58333301544189,'mt','mt-flag.gif','mt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Man, Isle of',54.25,-4.5,'im','im-flag.gif','im-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Marshall Islands',9,168,'rm','rm-flag.gif','rm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Martinique',14.66666698455811,-61,'mb','mb-flag.gif','mb-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mauritania',20,-12,'mr','mr-flag.gif','mr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mauritius',-20.28333282470703,57.54999923706055,'mp','mp-flag.gif','mp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mayotte',-12.83333301544189,45.16666793823242,'mf','mf-flag.gif','mf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mexico',23,-102,'mx','mx-flag.gif','mx-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Micronesia, Federated States of',6.916666507720947,158.25,'fm','fm-flag.gif','fm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Midway Islands',28.21666717529297,-177.3666687011719,'mq','mq-flag.gif','mq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Moldova',47,29,'md','md-flag.gif','md-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Monaco',43.73333358764648,7.400000095367432,'mn','mn-flag.gif','mn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mongolia',46,105,'mg','mg-flag.gif','mg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Montserrat',16.75,-62.20000076293945,'mh','mh-flag.gif','mh-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Morocco',32,-5,'mo','mo-flag.gif','mo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mozambique',-18.25,35,'mz','mz-flag.gif','mz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Namibia',-22,17,'wa','wa-flag.gif','wa-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nauru',-0.5333333611488342,166.9166717529297,'nr','nr-flag.gif','nr-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Navassa Island',18.41666603088379,-75.03333282470703,'bq','bq-flag.gif','bq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nepal',28,84,'np','np-flag.gif','np-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Netherlands',52.5,5.75,'nl','nl-flag.gif','nl-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Netherlands Antilles',12.25,-68.75,'nt','nt-flag.gif','nt-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('New Caledonia',-21.5,165.5,'nc','nc-flag.gif','nc-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('New Zealand',-41,174,'nz','nz-flag.gif','nz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nicaragua',13,-85,'nu','nu-flag.gif','nu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Niger',16,8,'ng','ng-flag.gif','ng-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nigeria',10,8,'ni','ni-flag.gif','ni-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Niue',-19.03333282470703,-169.8666687011719,'ne','ne-flag.gif','ne-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Norfolk Island',-29.03333282470703,167.9499969482422,'nf','nf-flag.gif','nf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Northern Mariana Islands',15.19999980926514,145.75,'cq','cq-flag.gif','cq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Norway',62,10,'no','no-flag.gif','no-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Oman',21,57,'mu','mu-flag.gif','mu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Other',NULL,NULL,'ot',null,null);
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Pacific Ocean',0,-160,'zn','zn-flag.gif','zn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Pakistan',30,70,'pk','pk-flag.gif','pk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Palau',7.5,134.5,'ps','ps-flag.gif','ps-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Palmyra Atoll',5.866666793823242,-162.1000061035156,'lq','lq-flag.gif','lq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Panama',9,-80,'pm','pm-flag.gif','pm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Papua New Guinea',-6,147,'pp','pp-flag.gif','pp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Paracel Islands',16.5,112,'pf','pf-flag.gif','pf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Paraguay',-23,-58,'pa','pa-flag.gif','pa-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Peru',-10,-76,'pe','pe-flag.gif','pe-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Philippines',13,122,'rp','rp-flag.gif','rp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Pitcairn Islands',-25.0666675567627,-130.1000061035156,'pc','pc-flag.gif','pc-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Poland',52,20,'pl','pl-flag.gif','pl-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Portugal',39.5,-8,'po','po-flag.gif','po-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Puerto Rico',18.25,-66.5,'rq','rq-flag.gif','rq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Qatar',25.5,51.25,'qa','qa-flag.gif','qa-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Reunion',-21.10000038146973,55.59999847412109,'re','re-flag.gif','re-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Romania',46,25,'ro','ro-flag.gif','ro-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Russia',60,100,'rs','rs-flag.gif','rs-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Rwanda',-2,30,'rw','rw-flag.gif','rw-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Helena',-15.93333339691162,-5.699999809265137,'sh','sh-flag.gif','sh-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Kitts and Nevis',17.33333396911621,-62.75,'sc','sc-flag.gif','sc-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Lucia',13.88333320617676,-61.13333511352539,'st','st-flag.gif','st-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Pierre and Miquelon',46.83333206176758,-56.33333206176758,'sb','sb-flag.gif','sb-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Vincent and the Grenadines',13.25,-61.20000076293945,'vc','vc-flag.gif','vc-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Samoa',-13.58333301544189,-172.3333282470703,'ws','ws-flag.gif','ws-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('San Marino',43.76666641235352,12.41666698455811,'sm','sm-flag.gif','sm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sao Tome and Principe',1,7,'tp','tp-flag.gif','tp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saudi Arabia',25,45,'sa','sa-flag.gif','sa-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Senegal',14,-14,'sg','sg-flag.gif','sg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Serbia and Montenegro',NULL,NULL,'yi','yi-flag.gif','yi-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Seychelles',-4.583333492279053,55.66666793823242,'se','se-flag.gif','se-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sierra Leone',8.5,-11.5,'sl','sl-flag.gif','sl-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Singapore',1.366666674613953,103.8000030517578,'sn','sn-flag.gif','sn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Slovakia',48.66666793823242,19.5,'lo','lo-flag.gif','lo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Slovenia',46,15,'si','si-flag.gif','si-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Solomon Islands',-8,159,'bp','bp-flag.gif','bp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Somalia',10,49,'so','so-flag.gif','so-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('South Africa',-29,24,'sf','sf-flag.gif','sf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('South Georgia and the South Sandwich Islands',-54.5,-37,'sx','sx-flag.gif','sx-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Southern Ocean',-65,0,'oo','oo-flag.gif','oo-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Spain',40,-4,'sp','sp-flag.gif','sp-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Spratly Islands',8.633333206176758,111.9166641235352,'pg','pg-flag.gif','pg-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sri Lanka',7,81,'ce','ce-flag.gif','ce-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sudan',15,30,'su','su-flag.gif','su-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Suriname',4,-56,'ns','ns-flag.gif','ns-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Svalbard',78,20,'sv','sv-flag.gif','sv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Swaziland',-26.5,31.5,'wz','wz-flag.gif','wz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sweden',62,15,'sw','sw-flag.gif','sw-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Switzerland',47,8,'sz','sz-flag.gif','sz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Syria',35,38,'sy','sy-flag.gif','sy-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Taiwan',23.5,121,'tw','tw-flag.gif','tw-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tajikistan',39,71,'ti','ti-flag.gif','ti-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tanzania',-6,35,'tz','tz-flag.gif','tz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Thailand',15,100,'th','th-flag.gif','th-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Togo',8,1.166666626930237,'to','to-flag.gif','to-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tokelau',-9,-172,'tl','tl-flag.gif','tl-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tonga',-20,-175,'tn','tn-flag.gif','tn-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Trinidad and Tobago',11,-61,'td','td-flag.gif','td-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tromelin Island',-15.86666679382324,54.41666793823242,'te','te-flag.gif','te-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tunisia',34,9,'ts','ts-flag.gif','ts-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Turkey',39,35,'tu','tu-flag.gif','tu-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Turkmenistan',40,60,'tx','tx-flag.gif','tx-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Turks and Caicos Islands',21.75,-71.58333587646484,'tk','tk-flag.gif','tk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tuvalu',-8,178,'tv','tv-flag.gif','tv-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Uganda',1,32,'ug','ug-flag.gif','ug-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ukraine',49,32,'up','up-flag.gif','up-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('United Arab Emirates',24,54,'ae','ae-flag.gif','ae-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('United Kingdom',54,-2,'uk','uk-flag.gif','uk-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('United States',38,-97,'us','us-flag.gif','us-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Uruguay',-33,-56,'uy','uy-flag.gif','uy-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Uzbekistan',41,64,'uz','uz-flag.gif','uz-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Vanuatu',-16,167,'nh','nh-flag.gif','nh-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Venezuela',8,-66,'ve','ve-flag.gif','ve-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Vietnam',16,106,'vm','vm-flag.gif','vm-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Virgin Islands',18.33333396911621,-64.83333587646484,'vq','vq-flag.gif','vq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Wake Island',19.28333282470703,166.6000061035156,'wq','wq-flag.gif','wq-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Wallis and Futuna',-13.30000019073486,-176.1999969482422,'wf','wf-flag.gif','wf-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('West Bank',32,35.25,'we','we-flag.gif','we-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Western Sahara',24.5,-13,'wi','wi-flag.gif','wi-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Yemen',15,48,'ym','ym-flag.gif','ym-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Zambia',-15,30,'za','za-flag.gif','za-lgflag.gif');
INSERT soft Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Zimbabwe',-20,30,'zi','zi-flag.gif','zi-lgflag.gif');

select count(*) from Countries;
--ECHO BOTH $IF $EQU $LAST[1] 270 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Countries loaded\n";

create procedure fill_flags_and_country_code ()
{
  declare rc int;
  --declare pwd any;
  --pwd := (select pwd_magic_calc (U_NAME, U_PASSWORD, 1) from DB.DBA.SYS_USERS where U_NAME = 'dav');
  --DB.DBA.DAV_COL_CREATE ('/DAV/sample_data/', '110100100', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
  --DB.DBA.DAV_COL_CREATE ('/DAV/sample_data/images/', '110100100', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
  --DB.DBA.DAV_COL_CREATE ('/DAV/sample_data/images/flags/', '110100100', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
  for select SmallFlagDAVResourceName, LargeFlagDAVResourceName, Code from Demo..Countries do
    {
      if (SmallFlagDAVResourceName is not null and LargeFlagDAVResourceName is not null and isstring (file_stat ('flags/'||LargeFlagDAVResourceName)))
        {
          insert into Demo.demo.Flags (CountryCode, LargeFlag, SmallFlag)
              values (Code, DB.DBA.get_blob_from_dav ('/DAV/VAD/demo/sample_data/images/flags/'||LargeFlagDAVResourceName), DB.DBA.get_blob_from_dav ('/DAV/VAD/demo/sample_data/images/flags/'||SmallFlagDAVResourceName));
        }
    }
  update Demo..Countries set SmallFlagDAVResourceURI = '/DAV/sample_data/images/flags/'||SmallFlagDAVResourceName,
         LargeFlagDAVResourceURI = '/DAV/sample_data/images/flags/' || LargeFlagDAVResourceName
             where SmallFlagDAVResourceName is not null and LargeFlagDAVResourceName is not null;
  update Demo.demo.Suppliers set CountryCode = (select Code from Demo.demo.Countries where Name = Country);
  update Demo.demo.Customers set CountryCode = (select Code from Demo.demo.Countries where Name = Country);
  update Demo.demo.Employees set CountryCode = (select Code from Demo.demo.Countries where Name = Country);
  update Demo.demo.Orders set ShipCountryCode = (select Code from Demo.demo.Countries where Name = ShipCountry);
};

fill_flags_and_country_code ();

DB.DBA.exec_no_error('drop procedure fill_flags_and_country_code');

select count(*) from Flags;
--ECHO BOTH $IF $EQU $LAST[1] 260 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Flags loaded\n";

select count(*) from WS.WS.SYS_DAV_RES where RES_FULL_PATH like '/DAV/sample_data/images/flags/%';
--ECHO BOTH $IF $EQU $LAST[1] 520 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Flags images loaded into the WebDAV\n";

INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barbuda','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Redonda','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mary','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Philip','ac');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abu Zaby (Abu Dhabi)','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ajman','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Fujayrah','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Shariqah (Sharjah)','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dubayy (Dubai)','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ra s al Khaymah','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Umm al Qaywayn','ae');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Badakhshan','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Badghis','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baghlan','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Balkh','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bamian','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Farah','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Faryab','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ghazni','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ghowr','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Helmand','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Herat','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jowzjan','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kabol','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kandahar','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kapisa','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Konar','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kondoz','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laghman','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lowgar','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nangarhar','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nimruz','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oruzgan','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paktia','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paktika','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Parvan','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samangan','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sar-e Pol','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Takhar','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vardak','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zabol','af');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adrar','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ain Defla','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ain Temouchent','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alger','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Annaba','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batna','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bechar','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bejaia','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Biskra','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blida','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bordj Bou Arreridj','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bouira','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boumerdes','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chlef','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Constantine','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Djelfa','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Bayadh','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Oued','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Tarf','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ghardaia','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guelma','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Illizi','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jijel','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khenchela','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laghouat','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('M Sila','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mascara','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Medea','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mila','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mostaganem','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naama','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oran','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouargla','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oum el Bouaghi','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Relizane','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saida','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Setif','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sidi Bel Abbes','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Skikda','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Souk Ahras','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tamanghasset','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tebessa','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tiaret','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tindouf','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tipaza','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tissemsilt','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tizi Ouzou','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tlemcen','ag');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abseron Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agcabadi Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agdam Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agdas Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agstafa Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agsu Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ali Bayramli Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Astara Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baki Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Balakan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barda Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beylaqan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bilasuvar Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cabrayil Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Calilabad Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Daskasan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Davaci Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fuzuli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gadabay Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ganca Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Goranboy Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Goycay Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haciqabul Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Imisli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ismayilli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalbacar Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kurdamir Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lacin Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lankaran Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lankaran Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lerik Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masalli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mingacevir Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naftalan Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neftcala Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oguz Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qabala Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qax Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qazax Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qobustan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quba Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qubadli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qusar Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saatli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sabirabad Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saki Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saki Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salyan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samaxi Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samkir Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samux Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siyazan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sumqayit Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Susa Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Susa Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tartar Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tovuz Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ucar Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xacmaz Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xankandi Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xanlar Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xizi Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xocali Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xocavand Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yardimli Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yevlax Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yevlax Sahari','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zangilan Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zaqatala Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zardab Rayonu','aj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Berat','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bulqize','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Delvine','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Devoll (Bilisht)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Diber (Peshkopi)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Durres','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Elbasan','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fier','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gjirokaster','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gramsh','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Has (Krume)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kavaje','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kolonje (Erseke)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Korce','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kruje','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kucove','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kukes','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kurbin','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lezhe','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Librazhd','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lushnje','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malesi e Madhe (Koplik)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mallakaster (Ballsh)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mat (Burrel)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mirdite (Rreshen)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Peqin','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Permet','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pogradec','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puke','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sarande','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shkoder','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Skrapar (Corovode)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tepelene','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tirane (Tirana)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tirane* (Tirana)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tropoje (Bajram Curri)','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vlore','al');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aragatsotn','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ararat','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Armavir','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Geghark unik','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kotayk','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lorri','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shirak','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Syunik','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tavush','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vayots  Dzor','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yerevan','am');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Andorra la Vella','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canillo','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Encamp','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Escaldes-Engordany','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Massana','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ordino','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sant Julia de Loria','an');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bengo','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Benguela','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bie','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cabinda','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cuando Cubango','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cuanza Norte','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cuanza Sul','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cunene','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huambo','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huila','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luanda','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lunda Norte','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lunda Sul','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malanje','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moxico','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namibe','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uige','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zaire','ao');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','aq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manu a','aq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rose Island','aq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Swains Island','aq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','aq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antartica e Islas del Atlantico Sur','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buenos Aires','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buenos Aires Capital Federal','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Catamarca','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chaco','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chubut','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cordoba','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Corrientes','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Entre Rios','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Formosa','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jujuy','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Pampa','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Rioja','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mendoza','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Misiones','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neuquen','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Negro','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salta','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Juan','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Luis','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Cruz','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Fe','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago del Estero','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tierra del Fuego,','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tucuman ,','ar');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Australian Capital Territory','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New South Wales','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Territory','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Queensland','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Australia','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tasmania','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Victoria','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western Australia','as');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Burgenland','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaernten','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niederoesterreich','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oberoesterreich','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salzburg','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Steiermark','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tirol','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vorarlberg','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wien','au');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hadd','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Manamah','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mintaqah al Gharbiyah','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mintaqah al Wusta','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mintaqah ash Shamaliyah','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Muharraq','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Rifa  wa al Mintaqah al Janubiyah','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jidd Hafs','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Juzur Hawar','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madinat  Isa','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madinat Hamad','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sitrah','ba');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Christ Church','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint James','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Joseph','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Lucy','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Michael','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Philip','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas','bb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chobe','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Francistown','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaborone','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ghanzi','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kgalagadi','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kgatleng','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kweneng','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lobatse','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngamiland','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North-East','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Selebi-Pikwe','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South-East','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','bc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Devonshire','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamilton','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paget','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pembroke','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Georges','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sandys','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Smiths','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southampton','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Warwick','bd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antwerpen','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brabant Wallon','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Flemish- provincien','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hainaut','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Liege','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limburg','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luxembourg','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namur','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oost-Vlaanderen','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vlaams Brabant','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West-Vlaanderen','be');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Acklins and Crooked Islands','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bimini','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cat Island','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Exuma','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Freeport','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fresh Creek','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Governor s Harbour','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Green Turtle Cay','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Harbour Island','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('High Rock','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inagua','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kemps Bay','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Long Island','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marsh Harbour','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mayaguana','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Providence','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nicholls Town and Berry Islands','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ragged Island','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rock Sound','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Salvador and Rum Cay','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sandy Point','bf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barisal','bg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chittagong','bg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dhaka','bg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khulna','bg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rajshahi','bg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beni','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chuquisaca','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cochabamba','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Paz','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oruro','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pando','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Potosi','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Cruz','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarija','bl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ayeyarwady','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bago','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chin State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kachin State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kayah State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kayin State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Magway','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mandalay','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mon State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rakhine State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sagaing','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shan State','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tanintharyi','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yangon','bm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atakora','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantique','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borgou','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Collines','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Couffo','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Donga','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Littoral','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mono','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oueme','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zou','bn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brestskaya (Brest)','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Homyel skaya (Homyel )','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Horad Minsk','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hrodzyenskaya (Hrodna)','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mahilyowskaya (Mahilyow)','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Minskaya','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vitsyebskaya (Vitsyebsk)','bo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guadalcanal','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Honiara','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isabel','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Makira','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malaita','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Temotu','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','bp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Acre','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alagoas','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amapa','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bahia','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ceara','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Federal','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Espirito Santo','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Goias','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maranhao','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mato Grosso','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mato Grosso do Sul','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Minas Gerais','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Para','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paraiba','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Parana','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pernambuco','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Piaui','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Grande do Norte','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Grande do Sul','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio de Janeiro','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rondonia','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Roraima','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Catarina','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Paulo','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sergipe','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tocantins','br');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bumthang','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chhukha','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chirang','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Daga','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Geylegphug','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lhuntshi','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mongar','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paro','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pemagatsel','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Punakha','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samchi','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samdrup Jongkhar','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shemgang','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tashigang','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thimphu','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tongsa','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wangdi Phodrang','bt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blagoevgrad','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Burgas','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dobrich','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gabrovo','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khaskovo','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kurdzhali','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyustendil','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lovech','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Montana','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pazardzhik','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pernik','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pleven','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Plovdiv','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Razgrad','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ruse','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shumen','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Silistra','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sliven','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Smolyan','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sofiya','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sofiya-Grad','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stara Zagora','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Turgovishte','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Varna','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Veliko Turnovo','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vidin','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vratsa','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yambol','bu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Belait','bx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brunei and Muara','bx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Temburong','bx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tutong','bx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bubanza','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bujumbura','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bururi','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cankuzo','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cibitoke','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gitega','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karuzi','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kayanza','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirundo','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Makamba','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Muramvya','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Muyinga','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mwaro','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngozi','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rutana','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ruyigi','by');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alberta','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('British Columbia','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manitoba','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Brunswick','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Newfoundland','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northwest Territories','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nova Scotia','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nunavut','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ontario','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Prince Edward Island','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quebec','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saskatchewan','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yukon Territory','ca');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banteay Mean Cheay','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batdambang','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Cham','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Chhnang','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Spoe','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Thum','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kampot','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kandal','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaoh Kong','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Keb','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kracheh','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mondol Kiri','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Otdar Mean Cheay','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pailin','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phnum Penh','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pouthisat','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Preah Seihanu* (Sihanoukville)','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Preah Vihear','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Prey Veng','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rotanah Kiri','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siem Reab','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stoeng Treng','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Svay Rieng','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Takev','cb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batha','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Biltine','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borkou-Ennedi-Tibesti','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chari-Baguirmi','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guera','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kanem','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lac','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Logone Occidental','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Logone Oriental','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mayo-Kebbi','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moyen-Chari','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouaddai','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salamat','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tandjile','cd');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Central','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Eastern','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Western','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sabaragamuwa','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uva','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','ce');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bouenza','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brazzaville','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cuvette','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kouilou','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lekoumou','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Likouala','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niari','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Plateaux','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pool','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sangha','cf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bandundu','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bas-Congo','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Equateur','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kasai-Occidental','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kasai-Oriental','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Katanga','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kinshasa','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maniema','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Kivu','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orientale','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sud-Kivu','cg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anhui','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fujian','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gansu','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guangdong','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guangxi','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guizhou','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hainan','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hebei','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Heilongjiang','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Henan','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hubei','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hunan','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jiangsu','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jiangxi','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jilin','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Liaoning','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nei Mongol','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ningxia','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qinghai','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shaanxi','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shandong','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shanxi','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sichuan','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xinjiang','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xizang* (Tibet)','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yunnan','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zhejiang','ch');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aisen del General Carlos Ibanez del Campo','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antofagasta','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Araucania','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atacama','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bio-Bio','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coquimbo','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Libertador General Bernardo O Higgins','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Los Lagos','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Magallanes y de la Antartica Chilena','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maule','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Region Metropolitana (Santiago)','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarapaca','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Valparaiso','ci');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Creek','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Midland','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Town','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Spot Bay','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stake Bay','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West End','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','cj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adamaoua','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Centre','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Est','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Extreme-Nord','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Littoral','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Ouest','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouest','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sud','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sud-Ouest','cm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anjouan (Nzwani)','cn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fomboni','cn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grande Comore (Njazidja)','cn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moroni','cn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antioquia','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arauca','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantico','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolivar','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boyaca','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caldas','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caqueta','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Casanare','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cauca','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cesar','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Choco','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cordoba','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cundinamarca','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Capital de Santa Fe de Bogota','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guainia','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guaviare','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huila','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Guajira','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Magdalena','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Meta','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Narino','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Norte de Santander','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Putumayo','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quindio','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Risaralda','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Andres y Providencia','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santander','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sucre','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tolima','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Valle del Cauca','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vaupes','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vichada','co');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Islands','cq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rota','cq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saipan','cq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tinian','cq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alajuela','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cartago','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guanacaste','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Heredia','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limon','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puntarenas','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Jose','cs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bamingui-Bangoran','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basse-Kotto','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gribingui','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haut-Mbomou','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haute-Kotto','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haute-Sangha','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kemo-Gribingui','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lobaye','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mbomou','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nana-Mambere','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ombella-Mpoko','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouaka','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouham','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouham-Pende','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sangha','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vakaga','ct');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Camaguey','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ciego de Avila','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cienfuegos','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ciudad de La Habana','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Granma','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guantanamo','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Holguin','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isla de la Juventud','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Habana','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Las Tunas','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matanzas','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pinar del Rio','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sancti Spiritus','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago de Cuba','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Villa Clara','cu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boa Vista','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brava','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fogo','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maio','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mosteiros','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paul','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Porto Novo','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Praia','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ribeira Grande','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sal','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Catarina','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Cruz','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Domingos','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Filipe','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Nicolau','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Vicente','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarrafal','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarrafal)','cv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Famagusta','cy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyrenia','cy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Larnaca','cy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limassol','cy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nicosia','cy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paphos','cy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arhus','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bornholm','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fredericksberg','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Frederiksborg','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fyn','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kobenhavn','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kobenhavns','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nordjylland','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ribe','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ringkobing','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Roskilde','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sonderjylland','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Storstrom','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vejle','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vestsjalland','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viborg','da');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ali Sabih','dj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dikhil','dj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Djibouti','dj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Obock','dj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tadjoura','dj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Joseph','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Luke','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mark','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter','do');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Azua','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baoruco','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barahona','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dajabon','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Nacional','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Duarte','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Seibo','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Elias Pina','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Espaillat','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hato Mayor','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Independencia','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Altagracia','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Romana','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Vega','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maria Trinidad Sanchez','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monsenor Nouel','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monte Cristi','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monte Plata','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pedernales','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Peravia','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puerto Plata','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salcedo','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samana','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Cristobal','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Juan','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Pedro de Macoris','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sanchez Ramirez','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago Rodriguez','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Valverde','dr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Azuay','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolivar','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canar','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carchi','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chimborazo','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cotopaxi','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Oro','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Esmeraldas','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Galapagos','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guayas','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Imbabura','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Loja','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Los Rios','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manabi','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Morona-Santiago','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Napo','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orellana','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pastaza','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pichincha','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sucumbios','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tungurahua','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zamora-Chinchipe','ec');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ad Daqahliyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bahr al Ahmar','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Buhayrah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Fayyum','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Gharbiyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Iskandariyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Isma iliyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jizah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Minufiyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Minya','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qahirah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qalyubiyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Wadi al Jadid','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('As Suways','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Sharqiyah','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aswan','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Asyut','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bani Suwayf','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bur Sa id','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dumyat','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Janub Sina','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kafr ash Shaykh','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matruh','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qina','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Sina','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Suhaj','eg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carlow','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cavan','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Clare','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cork','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Donegal','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dublin','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Galway','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kerry','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kildare','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kilkenny','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laois','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leitrim','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limerick','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Longford','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Louth','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mayo','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Meath','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monaghan','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Offaly','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Roscommon','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sligo','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tipperary','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waterford','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Westmeath','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wexford','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wicklow','ei');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Annobon','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bioko Norte','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bioko Sur','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Centro Sur','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kie-Ntem','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Litoral','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wele-Nzas','ek');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akale Guzay','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anseba','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barka','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Debub','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Debubawi Keyih Bahri','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Denkel','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gash-Barka','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamasen','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maakel','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Red Sea','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sahil','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Semhar','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Senhit','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Seraye','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','er');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ahuachapan','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cabanas','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chalatenango','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cuscatlan','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Libertad','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Paz','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Union','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Morazan','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Miguel','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Salvador','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Vicente','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Ana','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sonsonate','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Usulutan','es');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Afar','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amara','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Binshangul Gumuz','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dire Dawa','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gambela Hizboch','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hareri Hizb','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nationalities','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oromiya','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sumale','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tigray','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('YeDebub Biheroch Bihereseboch na Hizboch (Southern Nations','et');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brnensky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Budejovicky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jihlavsky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karlovarsky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kralovehradecky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Liberecky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Olomoucky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ostravsky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pardubicky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Plzensky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Praha','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stredocesky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ustecky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zlinsky','ez');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aland','fi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Etela-Suomen Laani','fi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ita-Suomen Laani','fi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lansi-Suomen Laani','fi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lappi','fi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oulun Laani','fi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','fj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','fj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','fj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rotuma','fj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','fj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chuuk (Truk)','fm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kosrae','fm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pohnpei','fm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yap','fm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Archipel des Tuamotu','fp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Archipel des Tubuai','fp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iles du Vent','fp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alsace','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aquitaine','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Auvergne','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basse-Normandie','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bourgogne','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bretagne','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Centre','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Champagne-Ardenne','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Corse','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Franche-Comte','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guadeloupe','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haute-Normandie','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ile-de-France','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Languedoc-Roussillon','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limousin','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lorraine','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Martinique','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Midi-Pyrenees','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Pas-de-Calais','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pays de la Loire','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Picardie','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Poitou-Charentes','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Provence-Alpes-Cote d Azur','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Reunion) and the overseas territorial collectivities (Mayotte','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rhone-Alpes','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Pierre and Miquelon)','fr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iles Kerguelen','fs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banjul','ga');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central River','ga');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lower River','ga');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Bank','ga');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Upper River','ga');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','ga');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Estuaire','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haut-Ogooue','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moyen-Ogooue','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngounie','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nyanga','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ogooue-Ivindo','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ogooue-Lolo','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ogooue-Maritime','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Woleu-Ntem','gb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abashis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adigenis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akhalgoris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akhalk alak is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akhalts ikhis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akhmetis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ambrolauris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aspindzis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baghdat is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolnisis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borjomis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ch khorotsqus','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ch okhatauris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiat ura','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dedop listsqaros','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dmanisis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dushet is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gardabanis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gori','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Goris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gurjaanis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Javis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('K arelis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('K ut aisi','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaspis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kharagaulis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khashuris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khobis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khonis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lagodekhis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lanch khut is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lentekhis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marneulis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Martvilis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mestiis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mts khet is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ninotsmindis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Onis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ozurget is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('P ot i','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qazbegis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qvarlis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rust avi','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sach kheris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sagarejos','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samtrediis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Senakis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sighnaghis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T bilisi','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T elavis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T erjolis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T et ritsqaros','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T ianet is','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tqibuli','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ts ageris','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tsalenjikhis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tsalkis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tsqaltubo','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vanis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zestap onis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zugdidi','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zugdidis','gg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ashanti','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brong-Ahafo','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Greater Accra','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Upper East','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Upper West','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Volta','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','gh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carriacou and Petit Martinique','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mark','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','gj');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Castel','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Forest','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('St. Andrew','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('St. Martin','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('St. Pierre du Bois','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('St. Sampson','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('St. Saviour','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Torteval','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vale','gk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Avannaa (Nordgronland)','gl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kitaa (Vestgronland)','gl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tunu (Ostgronland)','gl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baden-Wuerttemberg','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayern','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Berlin','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brandenburg','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bremen','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamburg','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hessen','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mecklenburg-Vorpommern','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niedersachsen','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nordrhein-Westfalen','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rheinland-Pfalz','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saarland','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sachsen','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sachsen-Anhalt','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Schleswig-Holstein','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thueringen','gm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aitolia kai Akarnania','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akhaia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Argolis','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arkadhia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arta','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Attiki','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ayion Oros* (Mt. Athos)','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dhodhekanisos','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Drama','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Evritania','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Evros','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Evvoia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Florina','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fokis','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fthiotis','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grevena','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ilia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Imathia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ioannina','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Irakleion','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kardhitsa','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kastoria','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kavala','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kefallinia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kerkyra','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khalkidhiki','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khania','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khios','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kikladhes','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kilkis','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Korinthia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kozani','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lakonia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Larisa','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lasithi','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lesvos','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Levkas','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Magnisia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Messinia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pella','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pieria','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Preveza','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rethimni','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rodhopi','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samos','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Serrai','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thesprotia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thessaloniki','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trikala','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Voiotia','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xanthi','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zakinthos','gr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alta Verapaz','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baja Verapaz','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chimaltenango','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiquimula','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Progreso','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Escuintla','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guatemala','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huehuetenango','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Izabal','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jalapa','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jutiapa','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Peten','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quetzaltenango','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quiche','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Retalhuleu','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sacatepequez','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Marcos','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Rosa','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Solola','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Suchitepequez','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Totonicapan','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zacapa','gt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beyla','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boffa','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boke','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Conakry','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coyah','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dabola','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dalaba','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dinguiraye','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dubreka','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Faranah','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Forecariah','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fria','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaoual','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gueckedou','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kankan','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kerouane','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kindia','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kissidougou','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Koubia','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Koundara','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kouroussa','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Labe','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lelouma','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lola','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Macenta','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mali','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mamou','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mandiana','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nzerekore','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pita','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siguiri','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Telimele','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tougue','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yomou','gv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barima-Waini','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cuyuni-Mazaruni','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Demerara-Mahaica','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Berbice-Corentyne','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Essequibo Islands-West Demerara','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mahaica-Berbice','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pomeroon-Supenaam','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Potaro-Siparuni','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Upper Demerara-Berbice','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Upper Takutu-Upper Essequibo','gy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Artibonite','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Centre','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Anse','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Est','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Ouest','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouest','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sud','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sud-Est','ha');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantida','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Choluteca','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Colon','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Comayagua','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Copan','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cortes','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Paraiso','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Francisco Morazan','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gracias a Dios','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Intibuca','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Islas de la Bahia','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Paz','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lempira','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ocotepeque','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Olancho','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Barbara','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Valle','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yoro','ho');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bacs-Kiskun','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baranya','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bekes','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bekescsaba','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borsod-Abauj-Zemplen','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Csongrad','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Debrecen','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dunaujvaros','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eger','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fejer','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gyor','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gyor-Moson-Sopron','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hajdu-Bihar','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Heves','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hodmezovasarhely','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jasz-Nagykun-Szolnok','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaposvar','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kecskemet','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Komarom-Esztergom','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Miskolc','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nagykanizsa','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nograd','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nyiregyhaza','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pecs','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pest','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Somogy','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sopron','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Szabolcs-Szatmar-Bereg','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Szeged','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Szekesfehervar','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Szolnok','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Szombathely','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tatabanya','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tolna','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vas','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Veszprem','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zala','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zalaegerszeg','hu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akranes','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akureyri','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arnessysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Austur-Bardhastrandarsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Austur-Hunavatnssysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Austur-Skaftafellssysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borgarfjardharsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dalasysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eyjafjardharsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gullbringusysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hafnarfjordhur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Husavik','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isafjordhur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Keflavik','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kjosarsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kopavogur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Myrasysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neskaupstadhur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nordhur-Isafjardharsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nordhur-Mulasys-la','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nordhur-Thingeyjarsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Olafsfjordhur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rangarvallasysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Reykjavik','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saudharkrokur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Seydhisfjordhur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siglufjordhur','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Skagafjardharsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Snaefellsnes-og Hnappadalssysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Strandasysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sudhur-Mulasysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sudhur-Thingeyjarsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vesttmannaeyjar','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Bardhastrandarsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Hunavatnssysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Isafjardharsysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Skaftafellssysla','ic');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aceh','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bali','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banten','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bengkulu','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Timor is under UN administration pending its formal independence','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gorontalo','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Irian Jaya','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jambi','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jawa Barat','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jawa Tengah','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jawa Timur','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Barat','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Selatan','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Tengah','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Timur','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kepulauan Bangka Belitung','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lampung','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maluku','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maluku Utara','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nusa Tenggara Barat','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nusa Tenggara Timur','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Riau','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Selatan','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Tengah','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Tenggara','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Utara','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sumatera Barat','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sumatera Selatan','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sumatera Utara','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yogyakarta','id');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Andaman and Nicobar Islands','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Andhra Pradesh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arunachal Pradesh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Assam','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bihar','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chandigarh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chhattisgarh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dadra and Nagar Haveli','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Daman and Diu','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Delhi','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Goa','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gujarat','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haryana','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Himachal Pradesh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jammu and Kashmir','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jharkhand','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karnataka','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kerala','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lakshadweep','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madhya Pradesh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maharashtra','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manipur','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Meghalaya','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mizoram','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nagaland','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orissa','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pondicherry','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Punjab','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rajasthan','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sikkim','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tamil Nadu','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tripura','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uttar Pradesh','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uttaranchal','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Bengal','in');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ardabil','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Azarbayjan-e Gharbi','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Azarbayjan-e Sharqi','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bushehr','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chahar Mahall va Bakhtiari','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Esfahan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fars','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gilan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Golestan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamadan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hormozgan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ilam','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kerman','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kermanshah','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khorasan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khuzestan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kohgiluyeh va Buyer Ahmad','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kordestan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lorestan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Markazi','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mazandaran','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qazvin','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qom','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Semnan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sistan va Baluchestan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tehran','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yazd','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zanjan','ir');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','is');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haifa','is');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jerusalem','is');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','is');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','is');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tel Aviv','is');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abruzzi','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basilicata','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Calabria','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Campania','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Emilia-Romagna','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Friuli-Venezia Giulia','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lazio','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Liguria','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lombardia','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marche','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Molise','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Piemonte','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puglia','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sardegna','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sicilia','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toscana','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trentino-Alto Adige','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Umbria','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Valle d Aosta','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Veneto','it');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Anbar','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Basrah','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Muthanna','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qadisiyah','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('An Najaf','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arbil','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('As Sulaymaniyah','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('At Ta mim','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Babil','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baghdad','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dahuk','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dhi Qar','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Diyala','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karbala','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maysan','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ninawa','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salah ad Din','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wasit','iz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aichi','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akita','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aomori','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiba','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ehime','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fukui','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fukuoka','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fukushima','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gifu','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gumma','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hiroshima','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hokkaido','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hyogo','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ibaraki','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ishikawa','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iwate','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kagawa','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kagoshima','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kanagawa','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kochi','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kumamoto','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyoto','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mie','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Miyagi','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Miyazaki','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nagano','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nagasaki','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nara','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niigata','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oita','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Okayama','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Okinawa','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Osaka','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saga','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saitama','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shiga','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shimane','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shizuoka','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tochigi','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tokushima','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tokyo','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tottori','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toyama','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wakayama','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yamagata','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yamaguchi','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yamanashi','ja');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Clarendon','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hanover','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kingston','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manchester','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Portland','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Ann','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Catherine','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Elizabeth','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint James','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mary','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trelawny','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Westmoreland','jm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ajlun','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al  Aqabah','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Balqa','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Karak','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mafraq','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amman','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('At Tafilah','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Az Zarqa','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Irbid','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jarash','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ma an','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madaba','jo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coast','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nairobi Area','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Eastern','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nyanza','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rift Valley','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','ke');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batken Oblasty','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bishkek Shaary','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chuy Oblasty (Bishkek)','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jalal-Abad Oblasty','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naryn Oblasty','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Osh Oblasty','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Talas Oblasty','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ysyk-Kol Oblasty (Karakol)','kg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chagang-do (Chagang Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamgyong-bukto (North Hamgyong Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamgyong-namdo (South Hamgyong Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hwanghae-bukto (North Hwanghae Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hwanghae-namdo (South Hwanghae Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaesong-si* (Kaesong City)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kangwon-do (Kangwon Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namp o-si* (Namp o City)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('P yongan-bukto (North P yongan Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('P yongan-namdo (South P yongan Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('P yongyang-si* (P yongyang City)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yanggang-do (Yanggang Province)','kn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abemama','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aranuka','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arorae','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banaba','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beru','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Butaritari','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central Gilberts','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gilbert Islands','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kanton','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kiritimati','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kuria','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Line Islands','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maiana','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Makin','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marakei','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nikunau','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nonouti','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Gilberts','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Onotoa','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phoenix Islands','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern Gilberts','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tabiteuea','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tabuaeran','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tamana','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarawa','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Teraina)','kr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ch ungch ong-bukto','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ch ungch ong-namdo','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cheju-do','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cholla-bukto','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cholla-namdo','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inch on-gwangyoksi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kangwon-do','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kwangju-gwangyoksi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyonggi-do','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyongsang-bukto','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyongsang-namdo','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pusan-gwangyoksi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soul-t ukpyolsi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taegu-gwangyoksi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taejon-gwangyoksi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ulsan-gwangyoksi','ks');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al  Asimah','ku');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Ahmadi','ku');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Farwaniyah','ku');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jahra','ku');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hawalli','ku');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Almaty','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aqmola (Astana)','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aqtobe','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Astana','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atyrau','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batys Qazaqstan (Oral)','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayqongyr','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mangghystau (Aqtau','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ongtustik Qazaqstan (Shymkent)','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pavlodar','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qaraghandy','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qostanay','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qyzylorda','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shyghys Qazaqstan (Oskemen','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soltustik Qazaqstan (Petropavl)','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zhambyl (Taraz','kz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Attapu','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bokeo','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolikhamxai','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Champasak','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Houaphan','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khammouan','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Louangnamtha','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Louangphabang','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oudomxai','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phongsali','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salavan','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Savannakhet','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viangchan','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xaignabouli','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xekong','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Xiangkhoang','la');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beyrouth','le');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ech Chimal','le');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ej Jnoub','le');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Bekaa','le');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jabal Loubnane','le');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bomi','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bong','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Bassa','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Cape Mount','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Gedeh','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Kru','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lofa','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Margibi','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maryland','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Montserrado','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nimba','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('River Cess','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sinoe','li');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banskobystricky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bratislavsky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kosicky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nitriansky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Presovsky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trenciansky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trnavsky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zilinsky','lo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Balzers','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eschen','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gamprin','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mauren','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Planken','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ruggell','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Schaan','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Schellenberg','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Triesen','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Triesenberg','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vaduz','ls');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Berea','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Butha-Buthe','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leribe','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mafeteng','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maseru','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mohales Hoek','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mokhotlong','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qacha s Nek','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quthing','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thaba-Tseka','lt');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Diekirch','lu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grevenmacher','lu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luxembourg','lu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ajdabiya','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al  Aziziyah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Fatih','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jabal al Akhdar','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jufrah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Khums','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Kufrah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('An Nuqat al Khams','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Shati','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Awbari','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Az Zawiyah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banghazi','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Darnah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ghadamis','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gharyan','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Misratah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Murzuq','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sabha','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sawfajjin','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surt','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarabulus','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarhunah','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tubruq','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yafran','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zlitan','ly');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antananarivo','ma');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antsiranana','ma');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fianarantsoa','ma');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mahajanga','ma');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toamasina','ma');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toliara','ma');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Balti','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cahul','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chisinau','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dubasari','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Edinet','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lapusna','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orhei','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soroca','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tighina','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ungheni','md');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arhangay','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayan-Olgiy','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayanhongor','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bulgan','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Darhan','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dornod','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dornogovi','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dundgovi','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dzavhan','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Erdenet','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Govi-Altay','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hentiy','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hovd','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hovsgol','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Omnogovi','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ovorhangay','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Selenge','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Suhbaatar','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tov','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ulaanbaatar','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uvs','mg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Anthony','mh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Georges','mh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter s','mh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blantyre','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chikwawa','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiradzulu','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chitipa','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dedza','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dowa','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karonga','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kasungu','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Likoma','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lilongwe','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Machinga (Kasupe)','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mangochi','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mchinji','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mulanje','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mwanza','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mzimba','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nkhata Bay','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nkhotakota','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nsanje','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ntcheu','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ntchisi','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rumphi','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salima','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thyolo','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zomba','mi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gao','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kayes','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kidal','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Koulikoro','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mopti','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Segou','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sikasso','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tombouctou','ml');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fontvieille','mn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Condamine','mn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monaco-Ville','mn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monte-Carlo','mn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agadir','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hoceima','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Azilal','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ben Slimane','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beni Mellal','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boulemane','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Casablanca','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chaouen','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Jadida','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Kelaa des Srarhna','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Er Rachidia','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Essaouira','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fes','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Figuig','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guelmim','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ifrane','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kenitra','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khemisset','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khenifra','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khouribga','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laayoune','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Larache','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marrakech','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Meknes','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nador','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ouarzazate','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oujda','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rabat-Sale','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Safi','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Settat','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sidi Kacem','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tan-Tan','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tanger','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taounate','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taroudannt','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tata','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taza','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tetouan','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tiznit','mo');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agalega Islands','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Black River','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cargados Carajos Shoals','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Flacq','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Port','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moka','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pamplemousses','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Plaines Wilhems','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Port Louis','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Riviere du Rempart','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rodrigues','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Savanne','mp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adrar','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Assaba','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brakna','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dakhlet Nouadhibou','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gorgol','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guidimaka','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hodh Ech Chargui','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hodh El Gharbi','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inchiri','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nouakchott','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tagant','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tiris Zemmour','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trarza','mr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alifu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baa','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dhaalu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Faafu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaafu Alifu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaafu Dhaalu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gnaviyani','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haa Alifu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Haa Dhaalu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaafu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laamu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lhaviyani','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maale','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Meemu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Noonu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Raa','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Seenu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shaviyani','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thaa','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vaavu','mv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aguascalientes','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baja California','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baja California Sur','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Campeche','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiapas','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chihuahua','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coahuila de Zaragoza','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Colima','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Federal','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Durango','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guanajuato','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guerrero','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hidalgo','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jalisco','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mexico','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Michoacan de Ocampo','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Morelos','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nayarit','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nuevo Leon','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oaxaca','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puebla','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Queretaro de Arteaga','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quintana Roo','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Luis Potosi','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sinaloa','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sonora','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tabasco','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tamaulipas','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tlaxcala','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Veracruz-Llave','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yucatan','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zacatecas','mx');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Johor','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kedah','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kelantan','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Labuan','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Melaka','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Negeri Sembilan','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pahang','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Perak','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Perlis','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pulau Pinang','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sabah','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sarawak','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Selangor','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Terengganu','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wilayah Persekutuan','my');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cabo Delgado','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaza','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inhambane','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manica','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maputo','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nampula','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niassa','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sofala','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tete','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zambezia','mz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord','nc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agadez','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Diffa','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dosso','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maradi','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niamey','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tahoua','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tillaberi','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zinder','ng');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malampa','nh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Penama','nh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sanma','nh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shefa','nh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tafea','nh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Torba','nh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abia','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abuja Federal Capital Territory','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adamawa','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akwa Ibom','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anambra','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bauchi','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayelsa','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Benue','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borno','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cross River','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Delta','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ebonyi','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Edo','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ekiti','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Enugu','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gombe','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Imo','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jigawa','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaduna','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kano','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Katsina','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kebbi','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kogi','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kwara','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lagos','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nassarawa','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Niger','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ogun','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ondo','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Osun','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oyo','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Plateau','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rivers','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sokoto','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taraba','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yobe','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zamfara','ni');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Drenthe','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Flevoland','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Friesland','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gelderland','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Groningen','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limburg','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Noord-Brabant','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Noord-Holland','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Overijssel','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Utrecht','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zeeland','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zuid-Holland','nl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akershus','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aust-Agder','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buskerud','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Finnmark','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hedmark','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hordaland','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('More og Romsdal','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Trondelag','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nordland','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oppland','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oslo','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ostfold','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rogaland','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sogn og Fjordane','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sor-Trondelag','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Telemark','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Troms','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vest-Agder','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vestfold','no');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bagmati','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bheri','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dhawalagiri','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gandaki','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Janakpur','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karnali','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kosi','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lumbini','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mahakali','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mechi','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Narayani','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rapti','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sagarmatha','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Seti','np');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aiwo','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anabar','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anetan','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anibare','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baiti','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boe','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buada','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Denigomodu','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ewa','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ijuw','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Meneng','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nibok','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uaboe','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yaren','nr');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brokopondo','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Commewijne','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coronie','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marowijne','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nickerie','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Para','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paramaribo','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saramacca','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sipaliwini','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wanica','ns');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantico Norte','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantico Sur','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boaco','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carazo','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chinandega','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chontales','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Esteli','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Granada','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jinotega','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leon','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madriz','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Managua','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masaya','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matagalpa','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Segovia','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio San Juan','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rivas','nu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Akaroa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amuri','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ashburton','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Auckland','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banks Peninsula','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bay of Islands','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bay of Plenty','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bruce','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buller','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canterbury','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carterton','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central Hawke s Bay','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central Otago','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chatham Islands','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cheviot','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Christchurch','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Clifton','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Clutha','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cook','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dannevirke','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dunedin','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Egmont','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eketahuna','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ellesmere','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eltham','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eyre','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Far North','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Featherston','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Franklin','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gisborne','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Golden Bay','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gore','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Great Barrier Island','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grey','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamilton','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hastings','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hauraki','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hauraki Plains','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hawera','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hawke s Bay','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Heathcote','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hobson','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hokianga','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Horowhenua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hurunui','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hutt','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inangahua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inglewood','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Invercargill','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaikoura','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaipara','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kairanga','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kapiti Coast','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kawerau','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kiwitea','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lake','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mackenzie','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malvern','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manawatu','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mangonui','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maniototo','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manukau','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marlborough','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masterton','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matamata','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matamata Piako','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mount Herbert','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Napier','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nelson','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Plymouth','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Shore','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northland','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ohinemuri','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Opotiki','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oroua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Otago','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Otamatea','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Otorohanga','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oxford','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pahiatua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Palmerston North','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Papakura','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paparua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Patea','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Piako','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pohangina','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Porirua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Queenstown Lakes','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Raglan','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rangiora','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rangitikei','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rodney','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rotorua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ruapehu','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Runanga','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Kilda','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Selwyn','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Silverpeaks','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Taranaki','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Waikato','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Wairarapa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southland','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stewart Island','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stratford','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Strathallan','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taranaki','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tararua','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tasman','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taumarunui','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Taupo','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tauranga','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thames Coromandel','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thames-Coromandel','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Timaru','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tuapeka','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Upper Hutt','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vincent','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waiapu','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waiheke','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waihemo','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waikato','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waikohu','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waimairi','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waimakariri','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waimarino','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waimate','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waimate West','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waimea','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waipa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waipawa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waipukurau','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wairarapa South','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wairewa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wairoa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waitakere','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waitaki','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waitomo','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Waitotara','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wallace','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wanganui','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wanganui-Manawatu','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wellington','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western Bay of Plenty','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Westland','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Whakatane','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Whangarei','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Whangarei)','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Whangaroa','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Woodville','nz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alto Paraguay','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alto Parana','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amambay','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Asuncion (city)','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boqueron','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caaguazu','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caazapa','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canindeyu','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Concepcion','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cordillera','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guaira','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Itapua','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Misiones','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neembucu','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paraguari','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Presidente Hayes','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Pedro','pa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ancash','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Andres Avelino Caceres (from Huanuco','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Apurimac','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Apurimac)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arequipa','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arequipa (from Arequipa)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ayacucho','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cajamarca','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Callao','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chavin (from Ancash)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cusco','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grau (from Tumbes','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huancavelica','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huancavelica)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Huanuco','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ica','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inca (from Cusco','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Junin','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Junin)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Libertad','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Libertad (from La Libertad)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lambayeque','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lima','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Loreto','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Los Libertadores-Huari (from Ica','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madre de Dios','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mariategui (from Moquegua','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moquegua','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nor Oriental del Maranon (from Lambayeque','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pasco','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Piura','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Piura)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puno','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puno)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Martin','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Martin (from San Martin)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tacna','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tumbes','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ucayali','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ucayali (from Ucayali)','pe');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Balochistan','pk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Federally Administered Tribal Areas','pk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North-West Frontier Province','pk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Punjab','pk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sindh','pk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dolnoslaskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kujawsko-Pomorskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lodzkie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lubelskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lubuskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malopolskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mazowieckie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Opolskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Podkarpackie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Podlaskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pomorskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Slaskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Swietokrzyskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Warminsko-Mazurskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wielkopolskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zachodniopomorskie','pl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bocas del Toro','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiriqui','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cocle','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Colon','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Darien','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Herrera','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Los Santos','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Panama','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Blas','pm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Acores (Azores)','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aveiro','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beja','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Braga','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Braganca','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Castelo Branco','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coimbra','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Evora','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Faro','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guarda','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leiria','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lisboa','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madeira','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Portalegre','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Porto','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santarem','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Setubal','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viana do Castelo','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vila Real','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viseu','po');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bougainville','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chimbu','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East New Britain','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Sepik','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern Highlands','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Enga','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gulf','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madang','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manus','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Milne Bay','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Morobe','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('National Capital','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Ireland','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sandaun','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern Highlands','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West New Britain','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western Highlands','pp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aimeliik','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Airai','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Angaur','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hatobohei','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kayangel','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Koror','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Melekeok','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngaraard','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngarchelong','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngardmau','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngatpang','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngchesar','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngeremlengui','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ngiwal','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Palau Island','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Peleliu','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sonsoral','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tobi','ps');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bafata','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Biombo','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bissau','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolama','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cacheu','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gabu','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oio','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quinara','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tombali','pu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ad Dawhah','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Ghuwayriyah','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jumayliyah','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Khawr','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Wakrah','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Rayyan','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jarayan al Batinah','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madinat ash Shamal','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Umm Salal','qa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ailinginae','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ailinglaplap','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ailuk','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arno','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aur','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bikar','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bikini','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bokak','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ebon','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Enewetak','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Erikub','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jabat','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jaluit','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jemo','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kili','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kwajalein','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lae','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lib','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Likiep','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Majuro','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maloelap','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mejit','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mili','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namorik','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namu','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rongelap','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rongrik','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toke','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ujae','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ujelang','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Utirik','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wotho','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wotje','rm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alba','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arad','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arges','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bacau','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bihor','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bistrita-Nasaud','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Botosani','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Braila','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brasov','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bucuresti','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buzau','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Calarasi','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caras-Severin','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cluj','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Constanta','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Covasna','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dimbovita','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dolj','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Galati','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Giurgiu','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gorj','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Harghita','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hunedoara','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ialomita','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iasi','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maramures','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mehedinti','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mures','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neamt','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Olt','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Prahova','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salaj','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Satu Mare','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sibiu','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Suceava','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Teleorman','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Timis','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tulcea','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vaslui','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vilcea','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vrancea','ro');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abra','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agusan del Norte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agusan del Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aklan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Albay','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Angeles','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antique','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aurora','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bacolod','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bago','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baguio','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bais','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basilan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basilan City','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bataan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batanes','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batangas','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batangas City','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Benguet','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bohol','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bukidnon','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bulacan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Butuan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cabanatuan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cadiz','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cagayan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cagayan de Oro','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Calbayog','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caloocan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Camarines Norte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Camarines Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Camiguin','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canlaon','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Capiz','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Catanduanes','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cavite','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cavite City','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cebu','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cebu City','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cotabato','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dagupan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Danao','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dapitan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Davao City* Davao','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Davao Oriental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Davao del Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dipolog','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dumaguete','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern Samar','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('General Santos','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gingoog','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ifugao','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iligan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ilocos Norte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ilocos Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iloilo','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iloilo City','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iriga','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isabela','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalinga-Apayao','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Carlota','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Union','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laguna','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lanao del Norte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lanao del Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laoag','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lapu-Lapu','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Legaspi','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leyte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lipa','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lucena','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maguindanao','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mandaue','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manila','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marawi','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Marinduque','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masbate','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mindoro Occidental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mindoro Oriental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Misamis Occidental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Misamis Oriental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mountain','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naga','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Negros Occidental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Negros Oriental','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Cotabato','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Samar','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Ecija','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Vizcaya','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Olongapo','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ormoc','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oroquieta','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ozamis','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pagadian','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Palawan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Palayan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pampanga','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pangasinan','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pasay','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Puerto Princesa','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quezon','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quezon City','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quirino','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rizal','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Romblon','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Roxas','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samar','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Carlos* (in Negros Occidental)','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Carlos* (in Pangasinan)','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Jose','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Pablo','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Silay','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siquijor','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sorsogon','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Cotabato','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern Leyte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sultan Kudarat','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sulu','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surigao','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surigao del Norte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surigao del Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tacloban','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tagaytay','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tagbilaran','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tangub','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tarlac','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tawitawi','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toledo','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trece Martires','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zambales','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zamboanga','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zamboanga del Norte','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zamboanga del Sur','rp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adjuntas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aguada','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aguadilla','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aguas Buenas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aibonito','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anasco','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arecibo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arroyo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barceloneta','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barranquitas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayamon','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cabo Rojo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caguas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Camuy','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canovanas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carolina','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Catano','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cayey','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ceiba','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ciales','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cidra','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coamo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Comerio','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Corozal','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Culebra','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dorado','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fajardo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Florida','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guanica','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guayama','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guayanilla','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guaynabo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gurabo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hatillo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hormigueros','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Humacao','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isabela','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jayuya','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Juana Diaz','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Juncos','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lajas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lares','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Las Marias','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Las Piedras','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Loiza','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luquillo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manati','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maricao','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maunabo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mayaguez','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moca','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Morovis','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naguabo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naranjito','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orocovis','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Patillas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Penuelas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ponce','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quebradillas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rincon','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Grande','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sabana Grande','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salinas','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San German','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Juan','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Lorenzo','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Sebastian','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Isabel','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toa Alta','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toa Baja','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trujillo Alto','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Utuado','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vega Alta','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vega Baja','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vieques','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Villalba','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yabucoa','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yauco','rq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adygeya (Maykop)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Altay (Gorno-Altaysk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amurskaya (Blagoveshchensk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arkhangel skaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Astrakhanskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bashkortostan (Ufa)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Belgorodskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bryanskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buryatiya (Ulan-Ude)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chechnya (Groznyy)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chelyabinskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chitinskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chuvashiya (Cheboksary)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dagestan (Makhachkala)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ingushetiya (Nazran )','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Irkutskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ivanovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kabardino-Balkariya (Nal chik)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaliningradskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalmykiya (Elista)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaluzhskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kamchatskaya (Petropavlovsk-Kamchatskiy)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karachayevo-Cherkesiya (Cherkessk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kareliya (Petrozavodsk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kemerovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khakasiya (Abakan)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Komi (Syktyvkar)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kostromskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kurganskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kurskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leningradskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lipetskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Magadanskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mariy-El (Yoshkar-Ola)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mordoviya (Saransk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moskovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Murmanskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nizhegorodskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Novgorodskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Novosibirskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Omskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orenburgskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orlovskaya (Orel)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Penzenskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Permskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pskovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rostovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ryazanskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sakha (Yakutsk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sakhalinskaya (Yuzhno-Sakhalinsk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samarskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saratovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Severnaya Osetiya-Alaniya [North Ossetia] (Vladikavkaz)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Smolenskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sverdlovskaya (Yekaterinburg)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tambovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tatarstan (Kazan )','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tomskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tul skaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tverskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tyumenskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tyva (Kyzyl)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Udmurtiya (Izhevsk)','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ul yanovskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vladimirskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Volgogradskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vologodskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Voronezhskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yaroslavskaya','rs');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Butare','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Byumba','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cyangugu','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gikongoro','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gisenyi','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gitarama','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kibungo','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kibuye','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kigali Rurale','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kigali-ville','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ruhengeri','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Umutara','rw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bahah','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hudud ash Shamaliyah','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jawf','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Madinah','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qasim','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Riyad','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Sharqiyah (Eastern Province)','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Asir','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha il','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jizan','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Makkah','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Najran','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tabuk','sa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Miquelon','sb');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Christ Church Nichola Town','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Anne Sandy Point','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George Basseterre','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George Gingerland','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint James Windward','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John Capisterre','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John Figtree','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mary Cayon','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul Capisterre','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul Charlestown','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter Basseterre','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas Lowland','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas Middle Island','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trinity Palmetto Point','sc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Boileau','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Etoile','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Louis','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Royale','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anse aux Pins','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baie Lazare','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baie Sainte Anne','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beau Vallon','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bel Air','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bel Ombre','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cascade','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Glacis','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand  Anse (on Mahe)','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grand  Anse (on Praslin)','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Digue','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Riviere Anglaise','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mont Buxton','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mont Fleuri','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Plaisance','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pointe La Rue','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Port Glaud','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Louis','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Takamaka','se');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern Cape','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Free State','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gauteng','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('KwaZulu-Natal','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mpumalanga','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North-West','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Cape','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Province','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western Cape','sf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dakar','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Diourbel','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fatick','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kaolack','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kolda','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Louga','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint-Louis','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tambacounda','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thies','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ziguinchor','sg');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ascension','sh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Helena','sh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tristan da Cunha','sh');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','sl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','sl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','sl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','sl');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Acquaviva','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Borgo Maggiore','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiesanuova','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Domagnano','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Faetano','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fiorentino','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monte Giardino','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Marino','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Serravalle','sm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Awdal','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bakool','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banaadir','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bari','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bay','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Galguduud','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gedo','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hiiraan','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jubbada Dhexe','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jubbada Hoose','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mudug','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nugaal','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sanaag','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shabeellaha Dhexe','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shabeellaha Hoose','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sool','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Togdheer','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Woqooyi Galbeed','so');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Andalucia','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aragon','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Asturias','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Baleares (Balearic Islands)','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canarias (Canary Islands)','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cantabria','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Castilla y Leon','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Castilla-La Mancha','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cataluna','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Communidad Valencian','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Extremadura','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Galicia','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('La Rioja','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Madrid','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Murcia','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Navarra','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pais Vasco (Basque Country)','sp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anse-la-Raye','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Castries','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Choiseul','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dauphin','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dennery','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gros Islet','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Laborie','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Micoud','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Praslin','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soufriere','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vieux Fort','st');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('A ali an Nil','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bahr al Ahmar','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Buhayrat','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jazirah','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Khartum','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qadarif','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Wahdah','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('An Nil al Abyad','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('An Nil al Azraq','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Shamaliyah','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bahr al Jabal','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb Bahr al Ghazal','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb Darfur','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb Kurdufan','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb al Istiwa iyah','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Janub Darfur','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Janub Kurdufan','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Junqali','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kassala','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nahr an Nil','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Bahr al Ghazal','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Darfur','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Kurdufan','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sharq al Istiwa iyah','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sinnar','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Warab','su');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blekinge','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dalarnas','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gavleborgs','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gotlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hallands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jamtlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jonkopings','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalmar','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kronobergs','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Norrbottens','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orebro','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ostergotlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Skane','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sodermanlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stockholms','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uppsala','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Varmlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vasterbottens','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vasternorrlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vastmanlands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vastra Gotalands','sw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hasakah','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Ladhiqiyah','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qunaytirah','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Raqqah','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('As Suwayda','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dar a','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dayr az Zawr','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dimashq','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Halab','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hamah','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hims','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Idlib','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rif Dimashq','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tartus','sy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aargau','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ausser-Rhoden','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basel-Landschaft','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Basel-Stadt','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bern','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fribourg','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Geneve','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Glarus','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Graubunden','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inner-Rhoden','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jura','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luzern','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neuchatel','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nidwalden','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Obwalden','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sankt Gallen','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Schaffhausen','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Schwyz','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Solothurn','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thurgau','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ticino','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uri','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Valais','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vaud','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zug','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zurich','sz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arima','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caroni','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mayaro','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nariva','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Port-of-Spain','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Fernando','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Victoria','td');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amnat Charoen','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ang Thong','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buriram','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chachoengsao','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chai Nat','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chaiyaphum','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chanthaburi','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiang Mai','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chiang Rai','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chon Buri','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chumphon','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalasin','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kamphaeng Phet','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kanchanaburi','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khon Kaen','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Krabi','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Krung Thep Mahanakhon (Bangkok)','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lampang','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lamphun','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Loei','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lop Buri','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mae Hong Son','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maha Sarakham','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mukdahan','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Nayok','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Pathom','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Phanom','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Ratchasima','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Sawan','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Si Thammarat','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nan','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Narathiwat','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nong Bua Lamphu','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nong Khai','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nonthaburi','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pathum Thani','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pattani','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phangnga','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phatthalung','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phayao','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phetchabun','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phetchaburi','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phichit','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phitsanulok','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phra Nakhon Si Ayutthaya','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phrae','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phuket','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Prachin Buri','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Prachuap Khiri Khan','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ranong','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ratchaburi','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rayong','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Roi Et','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sa Kaeo','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sakon Nakhon','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samut Prakan','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samut Sakhon','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samut Songkhram','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sara Buri','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Satun','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sing Buri','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sisaket','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Songkhla','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sukhothai','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Suphan Buri','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surat Thani','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surin','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tak','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trang','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trat','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ubon Ratchathani','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Udon Thani','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uthai Thani','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Uttaradit','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yala','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yasothon','th');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viloyati Khatlon (Qurghonteppa - formerly Kurgan-Tyube)','ti');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viloyati Leninobod (Khujand - formerly Leninabad)','ti');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Viloyati Mukhtori Kuhistoni Badakhshon* (Khorugh - formerly Khorog)','ti');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha apai','tn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tongatapu','tn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vava u','tn');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('De La Kara','to');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Des Plateaux','to');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Des Savanes','to');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Du Centre','to');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maritime','to');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Principe','tp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Tome','tp');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ariana (Aryanah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Beja (Bajah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ben Arous (Bin  Arus)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bizerte (Banzart)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('El Kef (Al Kaf)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gabes (Qabis)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gafsa (Qafsah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jendouba (Jundubah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kairouan (Al Qayrawan)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kasserine (Al Qasrayn)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kebili (Qibili)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mahdia (Al Mahdiyah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Medenine (Madanin)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monastir (Al Munastir)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nabeul (Nabul)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sfax (Safaqis)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sidi Bou Zid (Sidi Bu Zayd)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siliana (Silyanah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sousse (Susah)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tataouine (Tatawin)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tozeur (Tawzar)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tunis','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zaghouan (Zaghwan)','ts');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adana','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adiyaman','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Afyon','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Agri','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aksaray','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amasya','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ankara','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antalya','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ardahan','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Artvin','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aydin','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Balikesir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bartin','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Batman','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bayburt','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bilecik','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bingol','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bitlis','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolu','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Burdur','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bursa','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canakkale','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cankiri','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Corum','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Denizli','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Diyarbakir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Edirne','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Elazig','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Erzincan','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Erzurum','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eskisehir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaziantep','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Giresun','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gumushane','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hakkari','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hatay','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Icel','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Igdir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isparta','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Istanbul','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Izmir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kahramanmaras','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karabuk','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karaman','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kars','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kastamonu','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kayseri','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kilis','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirikkale','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirklareli','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirsehir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kocaeli','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Konya','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kutahya','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Malatya','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manisa','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mardin','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mugla','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mus','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nevsehir','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nigde','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ordu','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Osmaniye','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rize','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sakarya','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samsun','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sanliurfa','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Siirt','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sinop','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sirnak','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sivas','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tekirdag','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tokat','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trabzon','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tunceli','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Usak','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Van','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yalova','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yozgat','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zonguldak','tu');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chang-hua','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chi-lung','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chia-i','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hsin-chu','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hua-lien','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('I-lan','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kao-hsiung','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Miao-li','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nan-t ou','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('P eng-hu','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('P ing-tung','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-chung','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-nan','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-pei','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-tung','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('T ao-yuan','tw');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arusha','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dar es Salaam','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dodoma','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iringa','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kagera','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kigoma','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kilimanjaro','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lindi','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mara','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mbeya','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Morogoro','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mtwara','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mwanza','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pemba North','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pemba South','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pwani','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rukwa','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ruvuma','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shinyanga','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Singida','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tabora','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tanga','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zanzibar Central/South','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zanzibar North','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zanzibar Urban/West','tz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adjumani','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Apac','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arua','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bugiri','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bundibugyo','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bushenyi','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Busia','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gulu','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hoima','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iganga','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jinja','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kabale','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kabarole','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kalangala','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kampala','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kamuli','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kapchorwa','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kasese','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Katakwi','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kibale','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kiboga','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kisoro','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kitgum','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kotido','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kumi','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lira','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luwero','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masaka','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masindi','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mbale','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mbarara','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moroto','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moyo','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mpigi','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mubende','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mukono','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nakasongola','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nebbi','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ntungamo','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pallisa','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rakai','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rukungiri','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sembabule','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soroti','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tororo','ug');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aberdeen City','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aberdeenshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Angus','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Antrim','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ards','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Argyll and Bute','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Armagh','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ballymena','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ballymoney','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banbridge','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barnsley','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bedfordshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Belfast','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blackburn with Darwen','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blackpool','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Blaenau Gwent','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolton','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bournemouth','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bracknell Forest','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bridgend','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Brighton and Hove','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Buckinghamshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bury','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caerphilly','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Calderdale','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cambridgeshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carmarthenshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carrickfergus','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Castlereagh','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ceredigion','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cheshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('City of Edinburgh','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Clackmannanshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Coleraine','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Conwy','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cookstown','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cornwall','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Craigavon','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cumbria','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Darlington','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Denbighshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Derbyshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Derry','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Devon','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Doncaster','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dorset','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Down','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dudley','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dumfries and Galloway','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dundee City','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dungannon','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Durham','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Ayrshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Dunbartonshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Lothian','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Renfrewshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('East Sussex','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eilean Siar (Western Isles)','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Essex','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Falkirk','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fermanagh','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fife','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Flintshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gateshead','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Glasgow City','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gloucestershire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Greater Manchester','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gwynedd','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Halton','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hampshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hartlepool','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Herefordshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hertfordshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Highland','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Inverclyde','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isle of Anglesey','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Isle of Wight','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kent','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirklees','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Knowsley','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lancashire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Larne','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leicestershire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Limavady','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lincolnshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lisburn','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luton','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Magherafelt','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Medway','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Merseyside','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Merthyr Tydfil','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Middlesbrough','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Midlothian','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Milton Keynes','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monmouthshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moray','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Moyle','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Neath Port Talbot','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Newport','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Newry and Mourne','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Newtownabbey','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Norfolk','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Ayrshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Down','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Lanarkshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Tyneside','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Yorkshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northamptonshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northumberland','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nottinghamshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oldham','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Omagh','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Orkney Islands','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oxfordshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pembrokeshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Perth and Kinross','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Poole','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Powys','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Reading','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Redcar and Cleveland','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Renfrewshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rhondda Cynon Taff','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rochdale','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rotherham','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sandwell','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sefton','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shetland Islands','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shropshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Slough','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Solihull','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Somerset','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Ayrshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Lanarkshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Tyneside','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Yorkshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southend-on-Sea','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('St. Helens','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Staffordshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stirling','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stockport','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Stockton-on-Tees','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Strabane','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Suffolk','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surrey','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Swindon','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tameside','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('The Scottish Borders','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('The Vale of Glamorgan','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thurrock','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Torbay','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Torfaen','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trafford','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tyne and Wear','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Walsall','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Warrington','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Warwickshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Dunbartonshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Lothian','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Midlands','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Sussex','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Yorkshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wigan','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wiltshire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wirral','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wolverhampton','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Worcestershire','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wrexham','uk');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Avtonomna Respublika Krym* (Simferopol )','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cherkas ka (Cherkasy)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chernihivs ka (Chernihiv)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Chernivets ka (Chernivtsi)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dnipropetrovs ka (Dnipropetrovs k)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Donets ka (Donets k)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ivano-Frankivs ka (Ivano-Frankivs k)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kharkivs ka (Kharkiv)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khersons ka (Kherson)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khmel nyts ka (Khmel nyts kyy)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kirovohrads ka (Kirovohrad)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kyyivs ka (Kiev)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('L vivs ka (L viv)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luhans ka (Luhans k)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mykolayivs ka (Mykolayiv)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Odes ka (Odesa)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Poltavs ka (Poltava)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rivnens ka (Rivne)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sums ka (Sumy)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ternopil s ka (Ternopil )','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vinnyts ka (Vinnytsya)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Volyns ka (Luts k)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zakarpats ka (Uzhhorod)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zaporiz ka (Zaporizhzhya)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zhytomyrs ka (Zhytomyr)','up');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alabama','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Alaska','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arizona','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Arkansas','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('California','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Colorado','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Connecticut','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Delaware','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('District of Columbia','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Florida','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Georgia','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hawaii','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Idaho','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Illinois','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Indiana','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Iowa','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kansas','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kentucky','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Louisiana','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maine','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maryland','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Massachusetts','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Michigan','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Minnesota','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mississippi','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Missouri','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Montana','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nebraska','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nevada','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Hampshire','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Jersey','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New Mexico','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('New York','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Carolina','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North Dakota','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ohio','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oklahoma','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oregon','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Pennsylvania','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rhode Island','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Carolina','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('South Dakota','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tennessee','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Texas','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Utah','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vermont','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Virginia','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Washington','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('West Virginia','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wisconsin','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wyoming','us');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bam','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Banwa','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bazega','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bougouriba','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boulgou','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Boulkiemde','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Comoe','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ganzourgou','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gnagna','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gourma','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Houe','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Houet','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ioba','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kadiogo','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kenedougou','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Komandjari','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Komoe','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kompienga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kossi','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Koupelogo','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kouritenga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kourweogo','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Leraba','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Loroum','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mouhoun','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nahouri','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namentenga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naouri','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Naumbiel','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nayala','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oubritenga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oudalan','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Passore','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Poni','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samentenga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sanguie','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sanmatenga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Seno','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sissili','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soum','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sourou','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tapoa','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tuy','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yagha','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yatenga','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ziro','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zondomo','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zoundweogo','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zoundweogo)','uv');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Artigas','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Canelones','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cerro Largo','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Colonia','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Durazno','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Flores','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Florida','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lavalleja','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Maldonado','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Montevideo','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Paysandu','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Negro','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rivera','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Rocha','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Salto','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San Jose','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soriano','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tacuarembo','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Treinta y Tres','uy');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Andijon Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bukhoro Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Farghona Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Jizzakh Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khorazm Wiloyati (Urganch)','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Namangan Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nawoiy Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qashqadaryo Wiloyati (Qarshi)','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Qoraqalpoghiston* (Nukus)','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Samarqand Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sirdaryo Wiloyati (Guliston)','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Surkhondaryo Wiloyati (Termiz)','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Toshkent Wiloyati','uz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Charlotte','vc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Grenadines','vc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','vc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','vc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','vc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','vc');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Anzoategui','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Apure','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aragua','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Barinas','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bolivar','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Carabobo','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cojedes','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Delta Amacuro','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Federal','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Falcon','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Guarico','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lara','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Merida','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Miranda','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Monagas','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Esparta','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Portuguesa','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sucre','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tachira','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Trujillo','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vargas','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yaracuy','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Zulia','ve');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('An Giang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ba Ria-Vung Tau','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Giang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Kan','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Lieu','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Ninh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ben Tre','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Dinh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Duong','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Phuoc','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Thuan','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ca Mau','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Can Tho','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Cao Bang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Da Nang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dac Lak','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dong Nai','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dong Thap','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gia Lai','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Giang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Nam','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Noi','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Tay','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Tinh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hai Duong','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hai Phong','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ho Chi Minh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hoa Binh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hung Yen','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khanh Hoa','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kien Giang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kon Tum','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lai Chau','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lam Dong','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lang Son','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lao Cai','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Long An','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nam Dinh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Nghe An','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ninh Binh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ninh Thuan','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phu Tho','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Phu Yen','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Binh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Nam','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Ngai','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Ninh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Tri','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Soc Trang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Son La','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tay Ninh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thai Binh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thai Nguyen','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thanh Hoa','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Thua Thien-Hue','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tien Giang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tra Vinh','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tuyen Quang','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vinh Long','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vinh Phuc','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Yen Bai','vm');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Croix','vq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','vq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas','vq');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Caprivi','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Erongo','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hardap','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Karas','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Khomas','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Kunene','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ohangwena','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Okavango','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Omaheke','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Omusati','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oshana','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Oshikoto','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Otjozondjupa','wa');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sigave','wf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Wallis','wf');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('A ana','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Aiga-i-le-Tai','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Atua','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Fa asaleleaga','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gaga emauga','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Gagaifomauga','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Palauli','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Satupa itea','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Tuamasaga','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Va a-o-Fonoti','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Vaisigano','ws');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hhohho','wz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lubombo','wz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manzini','wz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Shiselweni','wz');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Abyan','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Adan','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bayda','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hudaydah','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jawf','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mahrah','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mahwit','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ataq','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Dhamar','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hadhramawt','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Hajjah','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ibb','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lahij','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ma rib','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Sa dah','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('San a','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Ta izz','ym');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Central','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Copperbelt','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Luapula','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Lusaka','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('North-Western','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Western','za');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Bulawayo','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Harare','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Manicaland','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mashonaland Central','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mashonaland East','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Mashonaland West','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Masvingo','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matabeleland North','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Matabeleland South','zi');
INSERT soft Demo.demo.Provinces(Province,CountryCode) VALUES('Midlands','zi');

select count(*) from Provinces;
--ECHO BOTH $IF $EQU $LAST[1] 3754 "PASSED" "***FAILED";
--SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
--ECHO BOTH ": " $LAST[1] " Provinces loaded\n";

--ECHO BOTH "Loading Countries Database Complete\n";
