/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* import_clr.sql */

static const char *proc0 = 
"#line 37 \"[executable]/import_clr.sql\"\n"
"create procedure DB.DBA.CACHE_ASSEMBLY_TO_DISK (in _asm_name varchar, in server_exe varchar)\n"
"{\n"
"declare _code varchar;\n"
"\n"
"SELECT blob_to_string (VAC_DATA) into _code from DB.DBA.CLR_VAC where VAC_REAL_NAME = _asm_name;\n"
"\n"
"string_to_file (server_exe || _asm_name || \'.dll\', _code, -2);\n"
"}\n"
"--src import_clr.sql:35\n"
;

static const char *proc1 = 
"#line 47 \"[executable]/import_clr.sql\"\n"
"create procedure DB.DBA.CLR_CREATE_LIBRARY (in asm_name varchar, in internal_name varchar,\n"
"in auto_register integer, in perm_mode integer)\n"
"{\n"
"\n"
"declare full_name, short_name varchar;\n"
"\n"
"import_get_assem_names (asm_name, full_name, short_name);\n"
"\n"
"insert replacing DB.DBA.CLR_VAC (VAC_INTERNAL_NAME, VAC_REAL_NAME, VAC_FULL_NAME,\n"
"VAC_DATA, VAC_FULL_FILE_NAME, VAC_PERM_SET)\n"
"values (internal_name, short_name, full_name, file_to_string(asm_name), asm_name, perm_mode);\n"
"\n"
"commit work;\n"
"\n"
"\n"
"\n"
"\n"
"if (auto_register)\n"
"{\n"
"DB..import_clr (internal_name, NULL, unrestricted => perm_mode - 1);\n"
"}\n"
"}\n"
"--src import_clr.sql:45\n"
;

static const char *proc2 = 
"#line 71 \"[executable]/import_clr.sql\"\n"
"create procedure DB.DBA.CLR_CREATE_LIBRARY_UI (in asm_name varchar, in mtd_name varchar, in perm_mode integer)\n"
"{\n"
"\n"
"declare full_name, short_name varchar;\n"
"\n"
"import_get_assem_names (asm_name, full_name, short_name);\n"
"\n"
"insert replacing DB.DBA.CLR_VAC (VAC_INTERNAL_NAME, VAC_REAL_NAME, VAC_FULL_NAME,\n"
"VAC_DATA, VAC_FULL_FILE_NAME, VAC_PERM_SET)\n"
"values (short_name, short_name, full_name, file_to_string(asm_name), asm_name, perm_mode);\n"
"\n"
"commit work;\n"
"\n"
"DB..import_clr (short_name, mtd_name, unrestricted => perm_mode);\n"
"}\n"
"--src import_clr.sql:69\n"
;

static const char *proc3 = 
"#line 89 \"[executable]/import_clr.sql\"\n"
"create procedure DB.DBA.CLR_CREATE_ASSEMBLY (in asm_name varchar, in internal_name varchar,\n"
"in auto_register integer, in perm_mode integer)\n"
"{\n"
"DB.DBA.CLR_CREATE_LIBRARY (asm_name, internal_name, auto_register, perm_mode);\n"
"}\n"
"--src import_clr.sql:87\n"
;

static const char *proc4 = 
"#line 97 \"[executable]/import_clr.sql\"\n"
"create procedure DB.DBA.CLR_DROP_LIBRARY (in internal_name varchar)\n"
"{\n"
"if (exists (select 1 from DB.DBA.CLR_VAC where VAC_INTERNAL_NAME = internal_name))\n"
"{\n"
"unimport_clr (internal_name, NULL);\n"
"delete from DB.DBA.CLR_VAC where VAC_INTERNAL_NAME = internal_name;\n"
"commit work;\n"
"}\n"
"}\n"
"--src import_clr.sql:95\n"
;

static const char *udt0 = 
"create type Assembly language clr external name \'mscorlib/System.Reflection.Assembly\'\n"
"as (FullName varchar external name \'FullName\' external type \'String\')\n"
"UNRESTRICTED TEMPORARY\n"
"static method Load (name varchar external type \'String\')\n"
"returns Assembly external name \'Load\' external type \'System.Reflection.Assembly\',\n"
"static method LoadFrom (name varchar external type \'String\')\n"
"returns Assembly external name \'LoadFrom\' external type \'System.Reflection.Assembly\',\n"
"method GetTypes ()\n"
"returns any external name \'GetTypes\' external type \'System.Type []\'\n";

static const char *udt1 = 
"create type _Type language clr external name \'mscorlib/System.Type\'\n"
"as (BaseType varchar external name \'BaseType\' external type \'System.Type\')\n"
"UNRESTRICTED TEMPORARY\n"
"method ToString ()\n"
"returns varchar external name \'ToString\' external type \'String\',\n"
"method GetMethods ()\n"
"returns any external name \'GetMethods\' external type \'System.MethodInfo []\',\n"
"method GetMembers ()\n"
"returns any external name \'GetMembers\' external type \'System.Reflection.MemberInfo []\',\n"
"method GetFields ()\n"
"returns any external name \'GetFields\' external type \'System.Reflection.FieldInfo []\',\n"
"method GetConstructors ()\n"
"returns any external name \'GetConstructors\' external type \'System.Reflection.ConstructorInfo []\',\n"
"method IsSubclassOf (xx _Type external type \'System.Type\')\n"
"returns smallint external name \'IsSubclassOf\' external type \'Boolean\',\n"
"method Equals (xx _Type external type \'System.Type\')\n"
"returns smallint external name \'Equals\' external type \'Boolean\'\n";

static const char *udt2 = 
"create type AssemFildInfo language clr external name \'mscorlib/System.Reflection.FieldInfo\'\n"
"as (IsStatic integer external name \'IsStatic\' external type \'Boolean\',\n"
"FieldType varchar external name \'FieldType\' external type \'System.Type\',\n"
"Name varchar external name \'Name\' external type \'String\')\n"
"UNRESTRICTED TEMPORARY\n"
"method ToString ()\n"
"returns varchar external name \'ToString\' external type \'String\',\n"
"method GetType ()\n"
"returns _Type external name \'GetType\' external type \'System.Type\'\n";

static const char *udt3 = 
"create type AssemblyMethod language clr external name \'mscorlib/System.Reflection.MethodInfo\'\n"
"as (IsStatic integer external name \'IsStatic\' external type \'Boolean\',\n"
"IsVirtual integer external name \'IsVirtual\' external type \'Boolean\',\n"
"IsFinal integer external name \'IsFinal\' external type \'Boolean\',\n"
"ReturnType varchar external name \'ReturnType\' external type \'System.Type\',\n"
"DeclaringType varchar external name \'DeclaringType\' external type \'System.Type\')\n"
"UNRESTRICTED TEMPORARY\n"
"\n"
"method ToString ()\n"
"returns varchar external name \'ToString\' external type \'String\',\n"
"method GetParameters ()\n"
"returns any external name \'GetParameters\' external type \'System.Reflection.ParameterInfo []\',\n"
"method GetBaseDefinition ()\n"
"returns AssemblyMethod external name \'GetBaseDefinition\' external type\n"
"\'System.Reflection.MethodInfo\'\n";

static const char *udt4 = 
"create type ParameterInfo language clr external name \'mscorlib/System.Reflection.ParameterInfo\'\n"
"as (IsIn smallint external name \'IsIn\' external type \'Boolean\',\n"
"Name varchar external name \'Name\' external type \'String\',\n"
"ParameterType varchar external name \'ParameterType\' external type \'System.Type\')\n"
"UNRESTRICTED TEMPORARY\n"
"method GetType ()\n"
"returns _Type external name \'GetType\' external type \'System.Type\'\n"
"\n";

static const char *udt5 = 
"create type ConstructorInfo language clr external name \'mscorlib/System.Reflection.ConstructorInfo\'\n"
"as (IsStatic integer external name \'IsStatic\' external type \'Boolean\',\n"
"DeclaringType varchar external name \'DeclaringType\' external type \'System.Type\')\n"
"UNRESTRICTED TEMPORARY\n"
"method ToString ()\n"
"returns varchar external name \'ToString\' external type \'String\',\n"
"method GetType ()\n"
"returns _Type external name \'GetType\' external type \'System.Type\',\n"
"method GetParameters ()\n"
"returns any external name \'GetParameters\' external type \'System.Reflection.ParameterInfo []\'\n"
"\n";

static const char *proc5 = 
"#line 190 \"[executable]/import_clr.sql\"\n"
"create procedure clr_ref_import (in assm_names varchar, in classes varchar, in unrestricted integer := 0,\n"
"in _is_add_virtual integer := 0)\n"
"{\n"
"declare asm Assembly;\n"
"declare types any;\n"
"declare string, esc_string, _base_type_str, under_name, str_unrestricted varchar;\n"
"declare _type, _base_type _Type;\n"
"declare idx, len, inherited, fl integer;\n"
"declare ses any;\n"
"declare class_inx, asm_inx integer;\n"
"\n"
"ses := string_output ();\n"
"\n"
"if (isstring(classes))\n"
"{\n"
"classes := vector (classes);\n"
"}\n"
"\n"
"if (isstring(assm_names))\n"
"{\n"
"assm_names:= vector (assm_names);\n"
"}\n"
"\n"
"str_unrestricted := \'\';\n"
"if (unrestricted)\n"
"str_unrestricted := \' restiction=\"unrestricted\"\';\n"
"\n"
"asm_inx := 0;\n"
"ses_print (\'<classes>\', ses);\n"
"\n"
"while (asm_inx < length (assm_names))\n"
"{\n"
"declare assm_name varchar;\n"
"\n"
"assm_name := assm_names [asm_inx];\n"
"\n"
"assm_name := __get_dll_name (assm_name);\n"
"\n"
"if (strstr (assm_name, \'/\') is not NULL)\n"
"asm := Assembly::LoadFrom(assm_name);\n"
"else\n"
"asm := Assembly::Load(assm_name);\n"
"\n"
"\n"
"types := asm.GetTypes ();\n"
"\n"
"\n"
"if (not isarray(types))\n"
"types := vector (types);\n"
"\n"
"\n"
"len := length (types);\n"
"idx := 0;\n"
"\n"
"if (classes is NULL)\n"
"{\n"
"classes := vector ();\n"
"while (idx < len)\n"
"{\n"
"declare _ser any;\n"
"_type := types[idx];\n"
"\n"
"string := cast (_type.ToString () as varchar);\n"
"classes := vector_concat (classes, vector (string));\n"
"idx := idx + 1;\n"
"}\n"
"idx := 0;\n"
"}\n"
"\n"
"while (idx < len)\n"
"{\n"
"_type := types[idx];\n"
"string := cast (_type.ToString () as varchar);\n"
"\n"
"esc_string := replace (string, \'.\', \'_\');\n"
"\n"
"class_inx := 0;\n"
"fl := 0;\n"
"\n"
"while (class_inx < length (classes))\n"
"{\n"
"if (classes[class_inx] = string)\n"
"{\n"
"fl := 1;\n"
"class_inx := length (classes);\n"
"}\n"
"class_inx := class_inx + 1;\n"
"}\n"
"\n"
"if (fl = 0)\n"
"goto skip;\n"
"\n"
"under_name := \'\';\n"
"\n"
"{\n"
"declare exit handler for SQLSTATE \'*\'\n"
"{\n"
"_base_type_str := NULL;\n"
"goto next;\n"
"};\n"
"_base_type := _type.BaseType;\n"
"_base_type_str := cast (_base_type.ToString () as varchar);\n"
"}\n"
"\n"
"inherited := 1;\n"
"if (_base_type_str is not null)\n"
"{\n"
"class_inx := 0;\n"
"while (class_inx < length (classes))\n"
"{\n"
"if (classes[class_inx] = _base_type_str)\n"
"{\n"
"under_name := replace (cast (_base_type_str as varchar), \'.\', \'_\');\n"
"class_inx := length (classes);\n"
"inherited := 0;\n"
"}\n"
"else\n"
"class_inx := class_inx + 1;\n"
"}\n"
"}\n"
"next:\n"
"if (strstr (string, \'PrivateImplementationDetails\') is NULL)\n"
"{\n"
"\n"
"ses_print (sprintf (\'\\n<class type=\"%s/%s\" pl_lang=\"CLR\" pl_type=\"%s\" pl_under=\"%s\" %s>\',\n"
"assm_name, string, esc_string, under_name, str_unrestricted ), ses);\n"
"clr_describe_class_type (ses, _type, _is_add_virtual, _base_type_str, under_name, _base_type);\n"
"ses_print (\'\\n</class>\', ses);\n"
"}\n"
"skip:\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"asm_inx := asm_inx + 1;\n"
"}\n"
"ses_print (\'</classes>\', ses);\n"
"\n"
"ses := string_output_string (ses);\n"
"\n"
"\n"
"return ses;\n"
"}\n"
"--src import_clr.sql:188\n"
;

static const char *proc6 = 
"#line 334 \"[executable]/import_clr.sql\"\n"
"create procedure clr_describe_class_type (inout ses any, in class _Type, in _is_add_virtual integer,\n"
"in _base_type_str varchar, in under_name varchar, inout _base_type _Type)\n"
"{\n"
"declare _name, _type, _pltype, _signature, _soaptype, c_name, field_name, _type_s varchar;\n"
"declare _static, _is_final, _is_virtual, _is_primitive, _is_array integer;\n"
"declare idx, len integer;\n"
"declare methods any;\n"
"declare members any;\n"
"declare fields any;\n"
"declare constructors any;\n"
"declare to_string varchar;\n"
"declare method AssemblyMethod;\n"
"declare constructor ConstructorInfo;\n"
"declare member AssemMemberInfo;\n"
"declare field AssemFildInfo;\n"
"declare _type _Type;\n"
"\n"
"methods := class.GetMethods ();\n"
"members := class.GetMembers ();\n"
"fields := class.GetFields ();\n"
"constructors := class.GetConstructors ();\n"
"\n"
"if (not isarray(fields))\n"
"fields := vector (fields);\n"
"\n"
"if (not isarray(members))\n"
"members := vector (members);\n"
"\n"
"len := length (fields);\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"\n"
"declare _is_static, _is_primitive, _plescape smallint;\n"
"declare _type_esc_s varchar;\n"
"\n"
"field := fields [idx];\n"
"field_name := field.Name;\n"
"_type := field.FieldType;\n"
"_type_s := cast (_type.ToString() as varchar);\n"
"_type_s := replace (_type_s, \'&\', \'\');\n"
"_is_static := case field.IsStatic when 0 then 0 else 1 end;\n"
"_is_primitive := clr_type_is_primitive (_type_s);\n"
"_type_esc_s := clr_type_to_pl_type (_type_s, _is_primitive, _is_array, _plescape);\n"
"_type_esc_s := replace (_type_esc_s, \'.\', \'_\');\n"
"_type_esc_s := replace (_type_esc_s, \'+\', \'_\');\n"
"_plescape := 0;\n"
"_is_static := 0;\n"
"\n"
"ses_print (sprintf (\'\\n<field name=\"%s\" type=\"%s\" static=\"%d\" final=\"0\" is_primitive=\"%d\" is_array=\"0\" pltype=\"%s\" signature=\"%s\" soaptype=\"%s\" plescape=\"%d\"/>\',\n"
"field_name, _type_s, _is_static, _is_primitive, _type_esc_s,  _type_s,\n"
"cast (clr_type_to_schema_type (_type_s, _is_primitive, _is_array) as varchar),\n"
"_plescape), ses);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"skip_this_mem:\n"
"\n"
"if (not isarray(constructors))\n"
"constructors := vector (constructors);\n"
"\n"
"len := length (constructors);\n"
"idx := 0;\n"
"\n"
"ses_print (\'\\n<constructor>\', ses);\n"
"while (idx < len)\n"
"{\n"
"constructor := constructors[idx];\n"
"declare temp_type _Type;\n"
"temp_type := constructor.DeclaringType;\n"
"if (temp_type.Equals (class))\n"
"clr_describe_parameters (ses, constructor.GetParameters ());\n"
"idx := idx + 1;\n"
"}\n"
"ses_print (\'\\n</constructor>\', ses);\n"
"\n"
"if (not isarray(methods))\n"
"methods := vector (methods);\n"
"\n"
"len := length (methods);\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"method := methods[idx];\n"
"\n"
"to_string := cast (method.ToString () as varchar);\n"
"_name := \'\';\n"
"_type := \'\';\n"
"_pltype := \'\';\n"
"_soaptype := \'\';\n"
"\n"
"if (strstr (to_string, \'(\') is not NULL);\n"
"{\n"
"declare pos integer;\n"
"\n"
"to_string := \"LEFT\" (to_string, strstr (to_string, \'(\'));\n"
"pos := strstr (to_string, \' \');\n"
"\n"
"if (pos is not NULL)\n"
"{\n"
"_name := subseq (to_string, pos + 1);\n"
"_type := \"LEFT\"  (to_string, pos);\n"
"}\n"
"}\n"
"\n"
"_static := case method.IsStatic when 0 then 0 else 1 end;\n"
"_is_final := case method.IsFinal when 0 then 0 else 1 end;\n"
"_is_virtual := case method.IsVirtual when 0 then 0 else 1 end;\n"
"\n"
"declare overriding integer;\n"
"overriding := 0;\n"
"if (isstring (under_name))\n"
"{\n"
"declare exit handler for SQLSTATE \'*\' {goto skip_this;};\n"
"declare get_defs AssemblyMethod;\n"
"declare _c_name, _dec_name varchar;\n"
"declare _is_sub, _is_eq smallint;\n"
"declare temp_type, dec_type _Type;\n"
"\n"
"dec_type := method.DeclaringType;\n"
"\n"
"if (cast (dec_type.ToString() as varchar) <> cast (class.ToString() as varchar))\n"
"goto next_mtd;\n"
"\n"
"_c_name := cast (class.ToString () as varchar);\n"
"get_defs := method.GetBaseDefinition();\n"
"_dec_name := cast ((get_defs.DeclaringType as _Type).ToString() as varchar);\n"
"\n"
"temp_type := get_defs.DeclaringType;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (_is_sub or _is_eq)\n"
"overriding := 1;\n"
"if (_dec_name = cast (_base_type.ToString() as varchar))\n"
"overriding := 1;\n"
"}\n"
"skip_this:;\n"
"\n"
"ses_print (sprintf (\'\\n<method name=\"%s\" static=\"%d\" overriding=\"%d\">\',\n"
"_name,  _static, overriding), ses);\n"
"clr_describe_returns (ses, method.ReturnType);\n"
"clr_describe_parameters (ses, method.GetParameters ());\n"
"ses_print (sprintf (\'\\n</%s>\', \'method\'), ses);\n"
"next_mtd:\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src import_clr.sql:332\n"
;

static const char *proc7 = 
"#line 490 \"[executable]/import_clr.sql\"\n"
"create procedure clr_describe_parameters (inout ses any, in parameters any)\n"
"{\n"
"declare _name, _type_s, _type_esc_s, _pltype, _soaptype, _reftype varchar;\n"
"declare _is_primitive, _is_array, _plescape integer;\n"
"declare idx, len integer;\n"
"declare line_param ParameterInfo;\n"
"declare _type _Type;\n"
"declare to_string varchar;\n"
"declare string varchar;\n"
"\n"
"if (not isarray(parameters))\n"
"parameters := vector (parameters);\n"
"\n"
"len := length (parameters);\n"
"idx := 0;\n"
"\n"
"ses_print (\'\\n<parameters>\', ses);\n"
"\n"
"while (idx < len)\n"
"{\n"
"declare _isin smallint;\n"
"line_param := parameters[idx];\n"
"_type := \'\';\n"
"_pltype := \'\';\n"
"_soaptype := \'\';\n"
"_reftype := \'in\';\n"
"\n"
"_isin := case line_param.IsIn when 0 then 0 else 1 end;\n"
"_name := line_param.Name;\n"
"_type := line_param.ParameterType;\n"
"_type_s := cast (_type.ToString() as varchar);\n"
"_type_s := replace (_type_s, \'&\', \'\');\n"
"\n"
"_is_primitive := clr_type_is_primitive (_type_s);\n"
"_is_array := if_array (_type_s);\n"
"_type_esc_s := clr_type_to_pl_type (_type_s, _is_primitive, _is_array, _plescape);\n"
"_type_esc_s := replace (_type_esc_s, \'.\', \'_\');\n"
"_type_esc_s := replace (_type_esc_s, \'+\', \'_\');\n"
"\n"
"ses_print (sprintf (\n"
"\'\\n<param name=\"%s\" type=\"%s\" is_primitive=\"%d\" is_array=\"%d\" pltype=\"%s\" signature=\"%s\" soaptype=\"%s\" reftype=\"%s\" />\',\n"
"_name, _type_s, _is_primitive, _is_array,\n"
"_type_esc_s,\n"
"_type_s,\n"
"cast (clr_type_to_schema_type (_type_s, _is_primitive, _is_array) as varchar), _reftype), ses);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"ses_print (\'\\n</parameters>\', ses);\n"
"}\n"
"--src import_clr.sql:488\n"
;

static const char *proc8 = 
"#line 542 \"[executable]/import_clr.sql\"\n"
"create procedure clr_describe_returns (inout ses any, in _type _Type)\n"
"{\n"
"declare _type_s, _type_esc_s varchar;\n"
"declare _is_primitive, _is_array, _plescape integer;\n"
"\n"
"_type_s := cast (_type.ToString () as varchar);\n"
"_is_primitive := clr_type_is_primitive (_type_s);\n"
"_is_array := if_array (_type_s);\n"
"_type_esc_s := clr_type_to_pl_type (_type_s, _is_primitive, _is_array,  _plescape);\n"
"_type_esc_s := replace (_type_esc_s, \'.\', \'_\');\n"
"_type_esc_s := replace (_type_esc_s, \'+\', \'_\');\n"
"\n"
"ses_print (sprintf (\'\\n<returnType type=\"%s\" is_primitive=\"%d\" is_array=\"%d\" pltype=\"%s\" signature=\"%s\" soaptype=\"%s\" plescape=\"%d\"/>\',\n"
"_type_s, _is_primitive, _is_array,\n"
"_type_esc_s, _type_s,\n"
"cast (clr_type_to_schema_type (_type_s, _is_primitive, _is_array) as varchar), _plescape), ses);\n"
"}\n"
"--src import_clr.sql:540\n"
;

static const char *proc9 = 
"#line 561 \"[executable]/import_clr.sql\"\n"
"create procedure clr_type_is_primitive (in clr_type varchar)\n"
"{\n"
"clr_type := cast (clr_type as varchar);\n"
"\n"
"if (clr_type = \'System.String\') return 1;\n"
"if (clr_type = \'System.Double\') return 1;\n"
"if (clr_type = \'System.Single\') return 1;\n"
"if (clr_type = \'System.Int32\') return 1;\n"
"if (clr_type = \'System.Boolean\') return 1;\n"
"\n"
"\n"
"\n"
"if (clr_type = \'System.Data.SqlTypes.SqlDouble\') return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src import_clr.sql:559\n"
;

static const char *proc10 = 
"#line 579 \"[executable]/import_clr.sql\"\n"
"create procedure clr_type_to_pl_type (in clr_type varchar, in is_primitive int,\n"
"in is_array int, inout _plescape int)\n"
"returns varchar\n"
"{\n"
"clr_type := cast (clr_type as varchar);\n"
"_plescape := 0;\n"
"\n"
"if (is_array)\n"
"return \'any\';\n"
"\n"
"if (is_primitive)\n"
"{\n"
"if (clr_type = \'System.String\') return \'varchar\';\n"
"if (clr_type = \'System.Double\') return \'double precision\';\n"
"if (clr_type = \'System.Single\') return \'real\';\n"
"if (clr_type = \'System.Int32\') return \'integer\';\n"
"if (clr_type = \'System.Boolean\') return \'smallint\';\n"
"}\n"
"\n"
"_plescape := 1;\n"
"return clr_type;\n"
"}\n"
"--src import_clr.sql:577\n"
;

static const char *proc11 = 
"#line 603 \"[executable]/import_clr.sql\"\n"
"create procedure clr_type_to_schema_type (in clr_type varchar, in is_primitive int, in is_array int)\n"
"{\n"
"clr_type := cast (clr_type as varchar);\n"
"\n"
"if (is_array)\n"
"return \'\';\n"
"\n"
"if (clr_type = \'System.String\') return \'http://www.w3.org/2001/XMLSchema:string\';\n"
"if (clr_type = \'System.Double\') return \'http://www.w3.org/2001/XMLSchema:double\';\n"
"if (clr_type = \'System.Single\') return \'http://www.w3.org/2001/XMLSchema:long\';\n"
"if (clr_type = \'System.Int32\') return \'http://www.w3.org/2001/XMLSchema:long\';\n"
"if (clr_type = \'System.Boolean\') return \'http://www.w3.org/2001/XMLSchema:boolelan\';\n"
"\n"
"return clr_type;\n"
"}\n"
"--src import_clr.sql:601\n"
;

static const char *proc12 = 
"#line 620 \"[executable]/import_clr.sql\"\n"
"create procedure if_array (in clr_type varchar)\n"
"{\n"
"if (strstr (clr_type, \'[\')) return 1;\n"
"return 0;\n"
"}\n"
"--src import_clr.sql:618\n"
;

static const char *proc13 = 
"#line 627 \"[executable]/import_clr.sql\"\n"
"create procedure ses_print (in _in any, inout ses any)\n"
"{\n"
"http (_in, ses);\n"
"}\n"
"--src import_clr.sql:625\n"
;

static const char *proc14 = 
"#line 633 \"[executable]/import_clr.sql\"\n"
"create procedure import_clr (in files any, in classes any, in _is_write_output integer := 0,\n"
"in unrestricted integer := 0, in _is_return_sql integer := 0)\n"
"{\n"
"declare _xml, _xmlv any;\n"
"declare pl, all_pl varchar;\n"
"_xml := xml_tree_doc (clr_ref_import (files, classes, unrestricted));\n"
"\n"
"_xmlv := xpath_eval (\'/classes/class\', _xml, 0);\n"
"\n"
"\n"
"if (isarray (_xmlv))\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"all_pl := \'\';\n"
"\n"
"while (inx < length (_xmlv))\n"
"{\n"
"declare _xmlv_frag any;\n"
"_xmlv_frag := xml_cut (_xmlv[inx]);\n"
"pl := cast (xslt (\'http://local.virt/mono_type\', _xmlv_frag) as varchar);\n"
"\n"
"\n"
"if (_is_write_output)\n"
"{\n"
"string_to_file (sprintf (\'result%i.sql\', inx),  clr_make_human_read (pl), -2);\n"
"string_to_file (sprintf (\'result%i.xml\', inx), cast (_xmlv_frag as varchar), -2);\n"
"}\n"
"if (_is_return_sql)\n"
"all_pl := all_pl || pl;\n"
"else\n"
"exec (pl);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"\n"
"if (_is_return_sql)\n"
"return  clr_make_human_read (all_pl);\n"
"}\n"
"--src import_clr.sql:631\n"
;

static const char *proc15 = 
"#line 674 \"[executable]/import_clr.sql\"\n"
"create procedure clr_make_human_read (in _res varchar)\n"
"{\n"
"_res := replace (_res, \'    \', \' \');\n"
"_res := replace (_res, \'   \', \' \');\n"
"_res := replace (_res, \'  \', \' \');\n"
"_res := replace (_res, \'  \', \' \');\n"
"_res := replace (_res, \'  \', \' \');\n"
"\n"
"_res := replace (_res, \'\\t,\', \',\');\n"
"_res := replace (_res, \'\\t ,\', \',\');\n"
"_res := replace (_res, \'\\t(\', \'(\');\n"
"_res := replace (_res, \'\\t (\', \'(\');\n"
"_res := replace (_res, \'\\t)\', \'(\');\n"
"_res := replace (_res, \'\\t )\', \')\');\n"
"_res := replace (_res, \'\\t)\', \'(\');\n"
"_res := replace (_res, \'\\t )\', \')\');\n"
"_res := replace (_res, \'\\n,\\n\', \',\\n\');\n"
"_res := replace (_res, \'\\n, \\n\', \',\\n\');\n"
"_res := replace (_res, \'\\n,\\n\', \',\\n\');\n"
"_res := replace (_res, \'\\n, \\n\', \',\\n\');\n"
"_res := replace (_res, \'\\t \', \'\\t\');\n"
"_res := replace (_res, \'\\n \', \'\\n\');\n"
"_res := replace (_res, \'\\n,\\n\', \',\\n\');\n"
"_res := replace (_res, \'\\n)\\n\', \')\\n\');\n"
"_res := replace (_res, \'\\n)\\n\', \')\\n\');\n"
"_res := replace (_res, \'(\\n\', \'(\');\n"
"_res := replace (_res, \'\\t)\', \'(\');\n"
"\n"
"_res := replace (_res, \'\\n(\', \'(\');\n"
"_res := replace (_res, \'\\n)\', \')\');\n"
"_res := replace (_res, \'\\t (\', \'(\');\n"
"\n"
"_res := replace (_res, \'\\n\\t\\n\', \'\\n\');\n"
"_res := replace (_res, \'\\n\\t \\n\', \'\\n\');\n"
"_res := replace (_res, \'\\n\\n\', \'\\n\');\n"
"_res := replace (_res, \'\\n \\n\', \'\\n\');\n"
"\n"
"_res := replace (_res, \'(\\t)\', \'()\');\n"
"_res := replace (_res, \'(\\n\', \'(\');\n"
"\n"
"_res := replace (_res, \'METHOD\\n\\t\', \'METHOD \');\n"
"_res := replace (_res, \',STATIC\', \',\\n\\tSTATIC \');\n"
"_res := replace (_res, \'\\nexternal type\', \'\\n\\texternal type\');\n"
"_res := replace (_res, \'\\n\\texternal name\', \' external name\');\n"
"\n"
"_res := replace (_res, \'( \\n\', \'(\');\n"
"_res := replace (_res, \'(\\n\', \'(\');\n"
"_res := replace (_res, \'\\n)\', \')\');\n"
"_res := replace (_res, \'\\n,\', \',\');\n"
"_res := replace (_res, \',\\n\"\', \', \"\');\n"
"_res := replace (_res, \',\\n\" \', \', \"\');\n"
"_res := replace (_res, \',\\n\"\\t\', \', \"\');\n"
"\n"
"return _res;\n"
"}\n"
"--src import_clr.sql:672\n"
;

static const char *udt6 = 
"create type \"Virt_aspx_VirtHost\"\n"
"language CLR external name \'virt_http/Virt_aspx.VirtHost\'\n"
"UNRESTRICTED TEMPORARY\n"
"STATIC METHOD\n"
"\"Call_aspx2\" (\"page\" varchar external type \'System.String\' ,\n"
"\"physicalDir\" varchar external type \'System.String\',\n"
"\"virtualDir\" varchar external type \'System.String\',\n"
"\"Headers\" varchar external type \'System.String\',\n"
"\"client_ip\" varchar external type \'System.String\',\n"
"\"server_port\" varchar external type \'System.String\',\n"
"\"localhost_name\" varchar external type \'System.String\',\n"
"\"_req_line\" varchar external type \'System.String\',\n"
"\"parameters\" varchar external type \'System.String\',\n"
"\"http_root\" varchar external type \'System.String\',\n"
"\"runtime_name\" varchar external type \'System.String\')\n"
"returns any\n"
"external type \'System.String []\'  external name \'Call_aspx2\'\n"
"\n";

static const char *proc16 = 
"#line 753 \"[executable]/import_clr.sql\"\n"
"create procedure WS.WS.__http_handler_asmx (in full_name varchar, inout params any,\n"
"inout lines any, inout hdl_mode any)\n"
"{\n"
"return WS.WS.__http_handler_aspx (full_name, params, lines, hdl_mode);\n"
"}\n"
"--src import_clr.sql:751\n"
;

static const char *proc17 = 
"#line 760 \"[executable]/import_clr.sql\"\n"
"create procedure\n"
"aspx_get_host (in lines any)\n"
"{\n"
"declare ret varchar;\n"
"ret := http_request_header (lines, \'Host\', null, sys_connected_server_address ());\n"
"if (isstring (ret) and strchr (ret, \':\') is null)\n"
"{\n"
"declare hp varchar;\n"
"declare hpa any;\n"
"hp := sys_connected_server_address ();\n"
"hpa := split_and_decode (hp, 0, \'\\0\\0:\');\n"
"ret := ret || \':\' || hpa[1];\n"
"}\n"
"return ret;\n"
"}\n"
"--src import_clr.sql:758\n"
;

static const char *proc18 = 
"#line 778 \"[executable]/import_clr.sql\"\n"
"create procedure WS.WS.__http_handler_aspx (in full_name varchar, inout params any,\n"
"inout lines any, inout hdl_mode any)\n"
"{\n"
"declare _page varchar;\n"
"declare _physicalDir varchar;\n"
"declare _virtualDir varchar;\n"
"declare _headers varchar;\n"
"declare _client_ip varchar;\n"
"declare _server_port varchar;\n"
"declare _server_host varchar;\n"
"declare _req_line varchar;\n"
"declare _parameters varchar;\n"
"declare _http_root varchar;\n"
"declare _runtime_name varchar;\n"
"\n"
"declare ret any;\n"
"declare headers_out varchar;\n"
"declare _mounted varchar;\n"
"\n"
"declare __idx integer;\n"
"declare __pos integer;\n"
"declare __temp integer;\n"
"declare __server_address varchar;\n"
"declare __temp_dir varchar;\n"
"\n"
"__temp_dir := \'\';\n"
"_page := http_path();\n"
"_mounted := http_map_get (\'mounted\');\n"
"_physicalDir := concat (http_root(), _mounted);\n"
"_http_root := http_root ();\n"
"_runtime_name := clr_runtime_name ();\n"
"if (hdl_mode is not NULL)\n"
"{\n"
"declare aspx_dir, full_path varchar;\n"
"\n"
"\n"
"\n"
"\n"
"__temp_dir := aspx_get_temp_directory ();\n"
"full_path := concat (http_root (), \'/\', __temp_dir);\n"
"_http_root := full_path;\n"
"\n"
"\n"
"aspx_copy_dav_dir_to_file_system (hdl_mode, full_path, aspx_dir);\n"
"\n"
"_physicalDir := concat (full_path, substring (_mounted, 5, length (_mounted)));\n"
"}\n"
"__temp := _physicalDir[length (_physicalDir) - 1];\n"
"if (__temp = ascii (\'/\') or __temp = ascii (\'\\\\\'))\n"
"_physicalDir := subseq (_physicalDir, 0, length (_physicalDir) - 1);\n"
"\n"
"_physicalDir := replace (_physicalDir, \'//\', \'/\');\n"
"\n"
"_virtualDir := http_map_get (\'domain\');\n"
"\n"
"\n"
"\n"
"_client_ip := http_client_ip ();\n"
"__server_address := aspx_get_host (lines);\n"
"_server_host := subseq (__server_address, 0, strchr (__server_address, \':\'));\n"
"_server_port := subseq (__server_address, strchr (__server_address, \':\') + 1);\n"
"_req_line := lines[0];\n"
"\n"
"__idx := 2;\n"
"_headers := lines[1];\n"
"while (__idx < length (lines))\n"
"{\n"
"_headers := concat (_headers, \';;\', lines[__idx]);\n"
"__idx := __idx + 1;\n"
"}\n"
"_headers := replace (_headers, \' \', \'\');\n"
"_headers := concat (_headers, \';;\');\n"
"\n"
"_parameters := \'\';\n"
"if (__tag (params) = 185)\n"
"_parameters := string_output_string (params);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"ret := \"Virt_aspx_VirtHost\"::Call_aspx2 (\n"
"_page,\n"
"_physicalDir,\n"
"_virtualDir,\n"
"_headers,\n"
"_client_ip,\n"
"_server_port,\n"
"_server_host,\n"
"_req_line,\n"
"_parameters,\n"
"_http_root,\n"
"_runtime_name);\n"
"\n"
"headers_out := replace (cast (ret [1] as varchar), \';;\', \'\\r\\n\');\n"
"\n"
"http_header (headers_out);\n"
"http_request_status (concat (\'HTTP/1.1 \', cast (ret [2] as varchar)));\n"
"\n"
"return cast (ret [0] as varchar);\n"
"}\n"
"--src import_clr.sql:776\n"
;

static const char *proc19 = 
"#line 904 \"[executable]/import_clr.sql\"\n"
"create procedure\n"
"aspx_sys_mkdir (in path varchar)\n"
"{\n"
"declare temp any;\n"
"declare idx integer;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"path := subseq(path, length (http_root()));\n"
"temp := split_and_decode (path, 0, \'///\');\n"
"idx := 0;\n"
"path := http_root();\n"
"\n"
"while (idx < length (temp) - 1)\n"
"{\n"
"path := concat (path, temp[idx], \'/\');\n"
"sys_mkdir (path);\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src import_clr.sql:902\n"
;

static const char *proc20 = 
"#line 931 \"[executable]/import_clr.sql\"\n"
"create procedure\n"
"aspx_copy_dav_dir_to_file_system (in dav_path varchar, in abs_path varchar, out path varchar)\n"
"{\n"
"declare dir_name varchar;\n"
"declare dav_rel_path  varchar;\n"
"declare full_path varchar;\n"
"declare create_dir_name varchar;\n"
"declare pos integer;\n"
"\n"
"aspx_sys_mkdir (abs_path);\n"
"\n"
"pos := strstr (dav_path, \'/DAV/\');\n"
"path := subseq (dav_path, pos + length (\'/DAV/\'));\n"
"pos := strstr (path, \'/\');\n"
"dir_name := \"LEFT\" (path, pos);\n"
"dav_rel_path := concat (\'/DAV/\', dir_name);\n"
"\n"
"for (select subseq (RES_FULL_PATH, length (dav_rel_path) + 1) as local_dav_path,\n"
"RES_CONTENT, RES_NAME, RES_MOD_TIME from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH like concat (dav_rel_path, \'%\')) do\n"
"{\n"
"full_path := concat (abs_path, \'/\', dir_name, \'/\', local_dav_path);\n"
"create_dir_name := \"LEFT\" (full_path, length (full_path) - length (RES_NAME));\n"
"\n"
"aspx_sys_mkdir (create_dir_name);\n"
"\n"
"declare x, y any;\n"
"x := cast (registry_get (full_path) as varchar);\n"
"y := cast (file_stat (full_path) as varchar);\n"
"if (x <> y || cast (RES_MOD_TIME as varchar))\n"
"{\n"
"\n"
"string_to_file (full_path, blob_to_string (RES_CONTENT), -2);\n"
"registry_set (full_path, cast (file_stat (full_path) as varchar) || cast (RES_MOD_TIME as varchar));\n"
"}\n"
"}\n"
"}\n"
"--src import_clr.sql:929\n"
;

static const char *proc21 = 
"#line 971 \"[executable]/import_clr.sql\"\n"
"create procedure unimport_clr (in files any, in classes any, in _is_write_output integer := 0)\n"
"{\n"
"declare _xml, _xmlv any;\n"
"declare pl varchar;\n"
"_xml := xml_tree_doc (clr_ref_import (files, classes));\n"
"\n"
"_xmlv := xpath_eval (\'/classes/class/@pl_type\', _xml, 0);\n"
"\n"
"if (isarray (_xmlv))\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"declare udts any;\n"
"\n"
"foreach (any _xml in _xmlv) do\n"
"{\n"
"declare _children any;\n"
"_children := udt_get_info (cast (_xml as varchar), \'children\');\n"
"foreach (varchar _xml_child in _children) do\n"
"{\n"
"declare _found int;\n"
"_found := 0;\n"
"foreach (any _xml2 in _xmlv) do\n"
"{\n"
"if (cast (_xml2 as varchar) = _xml_child)\n"
"_found := 1;\n"
"}\n"
"if (not _found)\n"
"signal (\'42000\', sprintf (\n"
"\'unimport_clr is to drop an user defined type %s that is a supertype of %s. Please drop the subtype(s) first.\', _xml, _xml_child));\n"
"}\n"
"}\n"
"while (inx < length (_xmlv))\n"
"{\n"
"pl := sprintf (\'DROP TYPE \"%I\"\', cast (_xmlv[inx] as varchar));\n"
"if (_is_write_output)\n"
"{\n"
"string_to_file (sprintf (\'result%i.sql\', inx),  clr_make_human_read (pl), -2);\n"
"if (_is_write_output = 2)\n"
"return  clr_make_human_read (pl);\n"
"}\n"
"exec (pl);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"--src import_clr.sql:969\n"
;

static const char *proc22 = 
"#line 1020 \"[executable]/import_clr.sql\"\n"
"create procedure import_get_types_int (in sel_name varchar)\n"
"{\n"
"declare asm Assembly;\n"
"declare _type _Type;\n"
"declare types, ret any;\n"
"declare esc_string varchar;\n"
"declare idx integer;\n"
"\n"
"ret := vector ();\n"
"\n"
"if ((strstr (sel_name, \'.dll\') is not NULL) or\n"
"(strstr (sel_name, \'.exe\') is not NULL))\n"
"{\n"
"\n"
"if (strstr (sel_name, \'/\') is not NULL)\n"
"asm := Assembly::LoadFrom(sel_name);\n"
"else\n"
"{\n"
"sel_name := replace (sel_name, \'.dll\', \'\');\n"
"sel_name := replace (sel_name, \'.exe\', \'\');\n"
"asm := Assembly::Load(sel_name);\n"
"}\n"
"\n"
"types := asm.GetTypes ();\n"
"idx := 0;\n"
"\n"
"if (not isarray(types))\n"
"types := vector (types);\n"
"\n"
"while (idx < length (types))\n"
"{\n"
"_type := types[idx];\n"
"esc_string := _type.ToString ();\n"
"esc_string := cast (esc_string as varchar);\n"
"esc_string := replace (esc_string, \'.\', \'_\');\n"
"ret := vector_concat (ret, vector (esc_string));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return ret;\n"
"}\n"
"else if (strstr (sel_name, \'.class\') is not NULL)\n"
"{\n"
"declare pos integer;\n"
"sel_name := replace (sel_name, \'\\\\\', \'/\');\n"
"pos := strrchr (sel_name , \'/\');\n"
"sel_name := subseq (sel_name, pos + 1);\n"
"return vector (replace (sel_name, \'.class\', \'\'));\n"
"}\n"
"else if ((strstr (sel_name, \'.jar\') is not NULL) or\n"
"(strstr (sel_name, \'.zip\') is not NULL))\n"
"{\n"
"declare jar_list any;\n"
"\n"
"for ( select entry_name from jvm_ref_archive_handler (m) (sz integer, entry_name varchar) c where m = sel_name) do\n"
"{\n"
"if (strstr (entry_name, \'.class\') is not NULL)\n"
"ret := vector_concat (ret, vector (entry_name));\n"
"}\n"
"\n"
"return ret;\n"
"}\n"
"\n"
"return vector ();\n"
"}\n"
"--src import_clr.sql:1018\n"
;

static const char *proc23 = 
"#line 1100 \"[executable]/import_clr.sql\"\n"
"create procedure import_clr_grant_to_public (in files any, in classes any)\n"
"{\n"
"declare _xml, _xmlv any;\n"
"declare pl varchar;\n"
"_xml := xml_tree_doc (clr_ref_import (files, classes));\n"
"\n"
"_xmlv := xpath_eval (\'/classes/class/@pl_type\', _xml, 0);\n"
"\n"
"if (isarray (_xmlv))\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"\n"
"while (inx < length (_xmlv))\n"
"{\n"
"pl := sprintf (\'grant execute on \"%I\" to public\', cast (_xmlv[inx] as varchar));\n"
"exec (pl);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"--src import_clr.sql:1098\n"
;

static const char *proc24 = 
"#line 1123 \"[executable]/import_clr.sql\"\n"
"create procedure import_get_assem_names\n"
"(inout assem_name varchar, inout full_name varchar, inout short_name varchar)\n"
"{\n"
"declare asm Assembly;\n"
"declare load_name varchar;\n"
"\n"
"if (sys_stat(\'st_build_opsys_id\') <> \'Win32\')\n"
"assem_name := replace (assem_name, \'\\\\\', \'/\');\n"
"\n"
"if ((strstr (assem_name, \'\\\\\') is not NULL) or (strstr (assem_name, \'/\') is not NULL))\n"
"asm := Assembly::LoadFrom(assem_name);\n"
"else\n"
"{\n"
"\n"
"\n"
"load_name := replace (assem_name, \'.dll\', \'\');\n"
"load_name := replace (load_name, \'.exe\', \'\');\n"
"asm := Assembly::Load(load_name);\n"
"}\n"
"\n"
"full_name := cast (asm.FullName as varchar);\n"
"\n"
"if (strstr (full_name, \',\') is not NULL)\n"
"{\n"
"short_name := \"LEFT\" (full_name, strstr (full_name, \',\'));\n"
"}\n"
"}\n"
"--src import_clr.sql:1121\n"
;

#undef isp_schema
#define isp_schema(x) isp_schema_1(x)

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


static int
sch_udt_def_exists (client_connection_t *cli, const char *udt_name)
{
  sql_class_t *udt = sch_name_to_type (isp_schema (NULL), udt_name);
  if (udt &&  UDT_IS_INSTANTIABLE(udt))
    {
      return 1;
    }
  return 0;
}

#define DEFINE_UDT(name, udt) \
   if (!sch_udt_def_exists (bootstrap_cli, (name))) \
     ddl_ensure_table ("do this always", udt);


#define EXEC_AND_LOG_TIME(fname, sno) \
  ddl_exec_init_stmt ("do this always", sno, #fname, #sno); 

void
sqls_define_clr (client_connection_t *bootstrap_cli)
{
  /* import_clr.sql */

  DEFINE_PROC ("DB.DBA.CACHE_ASSEMBLY_TO_DISK", proc0);
  DEFINE_PROC ("DB.DBA.CLR_CREATE_LIBRARY", proc1);
  DEFINE_PROC ("DB.DBA.CLR_CREATE_LIBRARY_UI", proc2);
  DEFINE_PROC ("DB.DBA.CLR_CREATE_ASSEMBLY", proc3);
  DEFINE_PROC ("DB.DBA.CLR_DROP_LIBRARY", proc4);
  DEFINE_UDT (case_mode == CM_UPPER ? "ASSEMBLY" : "Assembly", udt0);
  DEFINE_UDT (case_mode == CM_UPPER ? "_TYPE" : "_Type", udt1);
  DEFINE_UDT (case_mode == CM_UPPER ? "ASSEMFILDINFO" : "AssemFildInfo", udt2);
  DEFINE_UDT (case_mode == CM_UPPER ? "ASSEMBLYMETHOD" : "AssemblyMethod", udt3);
  DEFINE_UDT (case_mode == CM_UPPER ? "PARAMETERINFO" : "ParameterInfo", udt4);
  DEFINE_UDT (case_mode == CM_UPPER ? "CONSTRUCTORINFO" : "ConstructorInfo", udt5);
  DEFINE_PROC ("clr_ref_import", proc5);
  DEFINE_PROC ("clr_describe_class_type", proc6);
  DEFINE_PROC ("clr_describe_parameters", proc7);
  DEFINE_PROC ("clr_describe_returns", proc8);
  DEFINE_PROC ("clr_type_is_primitive", proc9);
  DEFINE_PROC ("clr_type_to_pl_type", proc10);
  DEFINE_PROC ("clr_type_to_schema_type", proc11);
  DEFINE_PROC ("if_array", proc12);
  DEFINE_PROC ("ses_print", proc13);
  DEFINE_PROC ("import_clr", proc14);
  DEFINE_PROC ("clr_make_human_read", proc15);
  DEFINE_UDT ("Virt_aspx_VirtHost", udt6);
  DEFINE_PROC ("WS.WS.__http_handler_asmx", proc16);
  DEFINE_PROC ("aspx_get_host", proc17);
  DEFINE_PROC ("WS.WS.__http_handler_aspx", proc18);
  DEFINE_PROC ("aspx_sys_mkdir", proc19);
  DEFINE_PROC ("aspx_copy_dav_dir_to_file_system", proc20);
  DEFINE_PROC ("unimport_clr", proc21);
  DEFINE_PROC ("import_get_types_int", proc22);
  DEFINE_PROC ("import_clr_grant_to_public", proc23);
  DEFINE_PROC ("import_get_assem_names", proc24);
}


void
sqls_arfw_define_clr (void)
{
}
