/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.jdbc4.VirtuosoPoolStatistic;

public class VirtuosoPoolManager {
    private static WeakHashMap<Object, Object> connPools = new WeakHashMap(50);
    private static VirtuosoPoolManager poolMgr = null;
    private static Object lock = new Object();
    private static ThreadGroup thrGroup = null;
    private static Thread poolChecker = null;
    private static Thread propertyChecker = null;
    private static AtomicBoolean isRun = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtuosoPoolManager getInstance() {
        Object object = lock;
        synchronized (object) {
            if (poolMgr == null) {
                isRun.set(true);
                poolMgr = new VirtuosoPoolManager();
                thrGroup = new ThreadGroup("Virtuoso Pool Manager");
                thrGroup.setDaemon(true);
                poolChecker = new Thread(thrGroup, "Virtuoso Pool Checker"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            VirtuosoConnectionPoolDataSource pds;
                            Object[] poolTmp;
                            try {
                                1.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (!isRun.get()) {
                                return;
                            }
                            Object e = lock;
                            synchronized (e) {
                                poolTmp = connPools.keySet().toArray();
                            }
                            for (int i = 0; i < poolTmp.length; ++i) {
                                pds = (VirtuosoConnectionPoolDataSource)poolTmp[i];
                                if (pds != null) {
                                    pds.checkPool();
                                }
                                poolTmp[i] = null;
                            }
                            pds = null;
                        }
                    }
                };
                poolChecker.setDaemon(true);
                poolChecker.start();
                propertyChecker = new Thread(thrGroup, "Virtuoso Property Checker"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            VirtuosoConnectionPoolDataSource pds;
                            Object[] poolTmp;
                            try {
                                2.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (!isRun.get()) {
                                return;
                            }
                            Object e = lock;
                            synchronized (e) {
                                poolTmp = connPools.keySet().toArray();
                            }
                            for (int i = 0; i < poolTmp.length; ++i) {
                                pds = (VirtuosoConnectionPoolDataSource)poolTmp[i];
                                if (pds != null) {
                                    pds.checkPropQueue();
                                }
                                poolTmp[i] = null;
                            }
                            pds = null;
                        }
                    }
                };
                propertyChecker.setDaemon(true);
                propertyChecker.start();
            }
        }
        return poolMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPool(VirtuosoConnectionPoolDataSource pool) {
        if (!isRun.get()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            connPools.put(pool, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!isRun.get()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            isRun.set(false);
            for (VirtuosoConnectionPoolDataSource virtuosoConnectionPoolDataSource : connPools.keySet()) {
                if (virtuosoConnectionPoolDataSource == null) continue;
                try {
                    virtuosoConnectionPoolDataSource.close();
                }
                catch (Exception e) {}
            }
            connPools.clear();
        }
    }

    public VirtuosoPoolStatistic[] getAll_statistics() {
        VirtuosoConnectionPoolDataSource[] poolTmp = connPools.keySet().toArray(new VirtuosoConnectionPoolDataSource[0]);
        VirtuosoPoolStatistic[] retVal = new VirtuosoPoolStatistic[poolTmp.length];
        for (int i = 0; i < poolTmp.length; ++i) {
            retVal[i] = poolTmp[i].get_statistics();
            poolTmp[i] = null;
        }
        return retVal;
    }
}

