/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import virtuoso.jena.driver.VirtGraph;

public class VirtBulkUpdateHandler
extends SimpleBulkUpdateHandler {
    public VirtBulkUpdateHandler(VirtGraph parent) {
        super((GraphWithPerform)parent);
    }

    public void add(Triple[] triples) {
        this.addIterator(Arrays.asList(triples).iterator(), false);
        this.manager.notifyAddArray((Graph)this.graph, triples);
    }

    protected void add(List<Triple> triples, boolean notify) {
        this.addIterator(triples.iterator(), false);
        if (notify) {
            this.manager.notifyAddList((Graph)this.graph, triples);
        }
    }

    public void addIterator(Iterator<Triple> it, boolean notify) {
        VirtGraph _graph = (VirtGraph)this.graph;
        ArrayList<Triple> list = notify ? new ArrayList<Triple>() : null;
        _graph.add(null, it, list);
        if (notify) {
            this.manager.notifyAddIterator((Graph)this.graph, list);
        }
    }

    public void delete(Triple[] triples) {
        this.deleteIterator(Arrays.asList(triples).iterator(), false);
        this.manager.notifyDeleteArray((Graph)this.graph, triples);
    }

    protected void delete(List<Triple> triples, boolean notify) {
        this.deleteIterator(triples.iterator(), false);
        if (notify) {
            this.manager.notifyDeleteList((Graph)this.graph, triples);
        }
    }

    public void deleteIterator(Iterator<Triple> it, boolean notify) {
        VirtGraph _graph = (VirtGraph)this.graph;
        ArrayList<Triple> list = notify ? new ArrayList<Triple>() : null;
        boolean autoCommit = false;
        _graph.delete(it, list);
        if (notify) {
            this.manager.notifyDeleteIterator((Graph)this.graph, list);
        }
    }

    public void removeAll() {
        VirtGraph _graph = (VirtGraph)this.graph;
        _graph.clear(NodeFactory.createURI((String)_graph.getGraphName()));
        this.notifyRemoveAll();
    }

    public void remove(Node s, Node p, Node o) {
        VirtGraph _graph = (VirtGraph)this.graph;
        _graph.delete_match((TripleMatch)Triple.createMatch((Node)s, (Node)p, (Node)o));
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.remove((Node)s, (Node)p, (Node)o));
    }
}

