/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import virtuoso.javax.OPLMessage_x;

public abstract class BaseRowSet
implements RowSet,
Serializable {
    private static final long serialVersionUID = 5374661472998522423L;
    protected static final int ev_CursorMoved = 1;
    protected static final int ev_RowChanged = 2;
    protected static final int ev_RowSetChanged = 3;
    private String command;
    private String url;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rsType = 1004;
    private int rsConcurrency = 1008;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private boolean readOnly = true;
    private boolean escapeProcessing = true;
    private int txn_isolation = 2;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    protected Map<String, Class<?>> map = null;
    private LinkedList<RowSetListener> listeners = new LinkedList();
    private ArrayList<Parameter> params = new ArrayList();

    @Override
    public void close() throws SQLException {
        this.clearParameters();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRowSetListener(RowSetListener rowsetlistener) {
        LinkedList<RowSetListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(rowsetlistener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowSetListener(RowSetListener rowsetlistener) {
        LinkedList<RowSetListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(rowsetlistener);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSource;
    }

    @Override
    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public int getTransactionIsolation() {
        return this.txn_isolation;
    }

    @Override
    public int getType() throws SQLException {
        return this.rsType;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.map;
    }

    @Override
    public String getUrl() throws SQLException {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 3;
        param.length = length;
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 4;
        param.length = length;
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = inputStream;
        param.jType = 4;
        param.length = (int)length;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob(parameterIndex, inputStream)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob(parameterName, inputStream, length)");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob (parameterName, x)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob(parameterName, inputStream)");
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = reader;
        param.jType = 6;
        param.length = (int)length;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob(parameterIndex, reader)");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob(parameterName, reader, length)");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob (String parameterName, Clob x)");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob(parameterName, reader)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setSQLXML(parameterIndex, xmlObject)");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setSQLXML(parameterName, xmlObject)");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setRowId(parameterIndex, x)");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setRowId(parameterName, x)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNString(parameterName, value)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, (int)length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNCharacterStream(parameterName, value, length)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNCharacterStream(parameterName, value)");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterName, value)");
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterName, value)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterName, reader)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = reader;
        param.jType = 6;
        param.length = (int)length;
    }

    @Override
    public synchronized void setNClob(int parameterIndex, NClob value) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = value;
        param.jType = 0;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterIndex, reader)");
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 6;
        param.length = length;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setAsciiStream(parameterIndex, x)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setAsciiStream(parameterName, x)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBinaryStream(parameterIndex, x)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBinaryStream(parameterName, x)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setCharacterStream(parameterIndex, reader)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setCharacterStream(parameterName, reader)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNCharacterStream(parameterIndex, value)");
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 7;
        param.cal = cal;
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = Float.valueOf(x);
        param.jType = 0;
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 8;
        param.cal = cal;
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
        param.cal = cal;
    }

    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 5;
        param.length = length;
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = null;
        param.jType = 10;
        param.sqlType = sqlType;
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = null;
        param.jType = 11;
        param.sqlType = sqlType;
        param.typeName = typeName;
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
        param.sqlType = targetSqlType;
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
        param.sqlType = targetSqlType;
        param.scale = scale;
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNull(parameterName, sqlType)");
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNull (parameterName, sqlType, typeName)");
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBoolean(parameterName, x)");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setByte(parameterName, x)");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setShort(parameterName, x)");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setInt(parameterName, x)");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setLong(parameterName, x)");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setFloat(parameterName, x)");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setDouble(parameterName, x)");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBigDecimal(parameterName, x)");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setString(parameterName, x)");
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBytes(parameterName, x[])");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTimestamp(parameterName, x)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setAsciiStream(parameterName, x, length)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBinaryStream(parameterName, x, length)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setCharacterStream(parameterName, reader, length)");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setObject(parameterName, x, targetSqlType, scale)");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setObject(parameterName, x, targetSqlType)");
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setObject(parameterName, x)");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setDate(parameterName, x)");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setDate(parameterName, x, cal)");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTime(parameterName, x)");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTime(parameterName, x, cal)");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTimestamp(parameterName, x, cal)");
    }

    @Override
    public synchronized void setCommand(String s) throws SQLException {
        this.command = new String(s);
        this.params.clear();
    }

    @Override
    public void setConcurrency(int i) throws SQLException {
        this.rsConcurrency = i;
    }

    @Override
    public void setDataSourceName(String s) throws SQLException {
        this.dataSource = s != null ? new String(s) : null;
        this.url = null;
    }

    @Override
    public void setEscapeProcessing(boolean flag) throws SQLException {
        this.escapeProcessing = flag;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDir = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void setReadOnly(boolean value) throws SQLException {
        this.readOnly = value;
    }

    @Override
    public void setPassword(String s) throws SQLException {
        this.password = s != null ? new String(s) : null;
    }

    @Override
    public void setTransactionIsolation(int value) throws SQLException {
        this.txn_isolation = value;
    }

    @Override
    public void setType(int value) throws SQLException {
        this.rsType = value;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> value) throws SQLException {
        this.map = value;
    }

    @Override
    public void setUrl(String s) throws SQLException {
        this.url = s != null ? new String(s) : null;
        this.dataSource = null;
    }

    @Override
    public void setUsername(String s) throws SQLException {
        this.username = s != null ? new String(s) : null;
    }

    protected void notifyListener(int event) {
        if (!this.listeners.isEmpty()) {
            LinkedList l = (LinkedList)this.listeners.clone();
            RowSetEvent ev = new RowSetEvent(this);
            Iterator i = l.iterator();
            while (i.hasNext()) {
                switch (event) {
                    case 1: {
                        ((RowSetListener)i.next()).cursorMoved(ev);
                        break;
                    }
                    case 2: {
                        ((RowSetListener)i.next()).rowChanged(ev);
                        break;
                    }
                    case 3: {
                        ((RowSetListener)i.next()).rowSetChanged(ev);
                    }
                }
            }
            l.clear();
        }
    }

    protected Parameter getParam(int paramIndex) throws SQLException {
        if (paramIndex < 1) {
            throw OPLMessage_x.makeExceptionV(12, String.valueOf(paramIndex));
        }
        int sz = this.params.size();
        if (--paramIndex < sz) {
            return this.params.get(paramIndex);
        }
        while (sz < paramIndex) {
            this.params.add(new Parameter());
            ++sz;
        }
        Parameter param = new Parameter();
        this.params.add(param);
        return param;
    }

    protected class Parameter {
        protected Object value;
        protected int sqlType = 12;
        protected String typeName;
        protected int scale;
        protected int length;
        protected Calendar cal;
        protected int jType = 0;
        protected static final int jObject = 0;
        protected static final int jObject_1 = 1;
        protected static final int jObject_2 = 2;
        protected static final int jAsciiStream = 3;
        protected static final int jBinaryStream = 4;
        protected static final int jUnicodeStream = 5;
        protected static final int jCharacterStream = 6;
        protected static final int jDateWithCalendar = 7;
        protected static final int jTimeWithCalendar = 8;
        protected static final int jTimestampWithCalendar = 9;
        protected static final int jNull_1 = 10;
        protected static final int jNull_2 = 11;

        protected Parameter() {
        }
    }
}

