/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import virtuoso.jdbc4.DateObject;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoDate;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoPreparedStatement;
import virtuoso.jdbc4.VirtuosoTimestamp;
import virtuoso.sql.RdfBox;

public class VirtuosoRdfBox
implements RdfBox {
    static final String gYear = "http://www.w3.org/2001/XMLSchema#gYear";
    static final String gYearMonth = "http://www.w3.org/2001/XMLSchema#gYearMonth";
    public short rb_type;
    public short rb_lang;
    public boolean rb_is_complete;
    public boolean rb_is_outlined;
    public boolean rb_chksum_tail;
    public boolean rb_is_text_index;
    public boolean rb_id_only;
    public long rb_ro_id;
    public Object rb_box;
    public static final int RDF_BOX_DEFAULT_TYPE = 257;
    public static final int RDF_BOX_DEFAULT_LANG = 257;
    public static final int RDF_BOX_GEO_TYPE = 256;
    public static final int RBS_OUTLINED = 1;
    public static final int RBS_COMPLETE = 2;
    public static final int RBS_HAS_LANG = 4;
    public static final int RBS_HAS_TYPE = 8;
    public static final int RBS_CHKSUM = 16;
    public static final int RBS_64 = 32;
    public static final int RBS_SKIP_DTP = 64;
    public static final int RBS_EXT_TYPE = 128;
    private VirtuosoConnection connection = null;

    public VirtuosoRdfBox(VirtuosoConnection connection, Object box, boolean is_complete, boolean id_only, short type, short lang, long ro_id) {
        this.connection = connection;
        this.rb_box = box instanceof DateObject ? ((DateObject)box).getValue(true) : box;
        this.rb_type = type;
        this.rb_lang = lang;
        this.rb_is_complete = is_complete;
        this.rb_ro_id = ro_id;
        this.rb_is_outlined = false;
        this.rb_chksum_tail = false;
        this.rb_id_only = id_only;
    }

    public VirtuosoRdfBox(Connection connection, Object box, String type, String lang) {
        this.connection = (VirtuosoConnection)connection;
        this.rb_box = box instanceof DateObject ? ((DateObject)box).getValue(true) : box;
        long ro_id = this.rdfMakeObj(this.rb_box, type, lang);
        this.rb_type = this.getTypeKey(type);
        this.rb_lang = this.getLangKey(lang);
        this.rb_is_complete = false;
        this.rb_ro_id = ro_id;
        this.rb_is_outlined = false;
        this.rb_chksum_tail = false;
        this.rb_id_only = false;
    }

    private long rdfMakeObj(Object box, String type, String lang) {
        long ro_id = 0L;
        try {
            VirtuosoPreparedStatement ps = (VirtuosoPreparedStatement)this.connection.prepareStatement("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (?, ?, ?)");
            ps.setObject(1, box);
            ps.setString(2, type);
            ps.setString(3, lang);
            VirtuosoPreparedStatement ro = (VirtuosoPreparedStatement)this.connection.prepareStatement("select rdf_box_ro_id (?)");
            ro.setObject(1, box);
            try {
                long rc;
                ps.executeQuery();
                ResultSet rs = ro.executeQuery();
                while (rs.next()) {
                }
                ro_id = rc = rs.getLong(1);
                ps.close();
                this.connection.rdf_lang_hash.clear();
                this.connection.rdf_type_hash.clear();
                this.connection.rdf_lang_rev.clear();
                this.connection.rdf_type_rev.clear();
            }
            catch (SQLException e) {}
        }
        catch (VirtuosoException e) {
            // empty catch block
        }
        return ro_id;
    }

    @Override
    public short getLangKey(String lang) {
        if (lang == null) {
            return 257;
        }
        this.ensureLangHash();
        Integer k = this.connection.rdf_lang_rev.get(lang);
        return k != null ? (short)k.shortValue() : (short)257;
    }

    @Override
    public short getTypeKey(String type) {
        if (type == null) {
            return 257;
        }
        this.ensureTypeHash();
        Integer k = this.connection.rdf_type_rev.get(type);
        return k != null ? (short)k.shortValue() : (short)257;
    }

    private void fillHashFromSQL(Hashtable<Integer, String> ht, Hashtable<String, Integer> rev, String sql) {
        try {
            Statement stmt = this.connection.createStatement();
            try {
                stmt.execute(sql);
                stmt.setFetchSize(200);
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    Integer k = (Integer)rs.getObject(1);
                    String v = rs.getString(2);
                    ht.put(k, v);
                    rev.put(v, k);
                }
                stmt.close();
            }
            catch (SQLException e) {}
        }
        catch (VirtuosoException e) {
            // empty catch block
        }
    }

    private void ensureTypeHash() {
        if (!this.connection.rdf_type_loaded) {
            this.fillHashFromSQL(this.connection.rdf_type_hash, this.connection.rdf_type_rev, "select RDT_TWOBYTE, RDT_QNAME from DB.DBA.RDF_DATATYPE");
            this.connection.rdf_type_loaded = true;
        }
    }

    private void ensureLangHash() {
        if (!this.connection.rdf_lang_loaded) {
            this.fillHashFromSQL(this.connection.rdf_lang_hash, this.connection.rdf_lang_rev, "select RL_TWOBYTE, RL_ID from DB.DBA.RDF_LANGUAGE");
            this.connection.rdf_lang_loaded = true;
        }
    }

    private String _getType() {
        this.ensureTypeHash();
        return this.connection.rdf_type_hash.get(this.rb_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType() {
        if (this.rb_type == 257) {
            return null;
        }
        String r = this._getType();
        if (r == null) {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                this.connection.rdf_type_loaded = false;
                r = this._getType();
            }
        }
        return r;
    }

    private String _getLang() {
        this.ensureLangHash();
        return this.connection.rdf_lang_hash.get(this.rb_lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLang() {
        if (this.rb_lang == 257) {
            return null;
        }
        String r = this._getLang();
        if (r == null) {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                this.connection.rdf_lang_loaded = false;
                r = this._getLang();
            }
        }
        return r;
    }

    @Override
    public String toString() {
        String retVal = "NULL";
        if (this.rb_box != null) {
            String o_type = this.getType();
            retVal = o_type != null && o_type.equals(gYear) ? (this.rb_box instanceof VirtuosoDate ? ((VirtuosoDate)this.rb_box).toXSD_String().substring(0, 4) : (this.rb_box instanceof VirtuosoTimestamp ? ((VirtuosoTimestamp)this.rb_box).toXSD_String().substring(0, 4) : this.rb_box.toString())) : (o_type != null && o_type.equals(gYearMonth) ? (this.rb_box instanceof VirtuosoDate ? ((VirtuosoDate)this.rb_box).toXSD_String().substring(0, 7) : (this.rb_box instanceof VirtuosoTimestamp ? ((VirtuosoTimestamp)this.rb_box).toXSD_String().substring(0, 7) : this.rb_box.toString())) : this.rb_box.toString());
        }
        return retVal;
    }
}

