/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoOutputStream;

public class VirtuosoExplicitString {
    private int dtp;
    private byte[] bytes;
    private String str;
    private VirtuosoConnection con;

    protected VirtuosoExplicitString(byte[] bytes, int dtp) {
        this.dtp = dtp;
        this.bytes = bytes;
        this.str = null;
        if (dtp == 182 || dtp == 181 || dtp == 238 || dtp == 183 || dtp == 125 || dtp == 242) {
            this.dtp = bytes.length < 256 ? 181 : 182;
        }
    }

    protected VirtuosoExplicitString(String str, int dtp, VirtuosoConnection con) throws VirtuosoException {
        try {
            this.dtp = dtp;
            this.con = con;
            if (dtp == 225 || dtp == 226 || dtp == 132) {
                this.bytes = str.getBytes("UTF8");
                this.dtp = this.bytes.length < 256 ? 225 : 226;
                this.str = str;
            } else if (dtp == 182 || dtp == 181 || dtp == 238 || dtp == 183 || dtp == 125) {
                if (con != null && con.charset_utf8) {
                    this.bytes = str.getBytes("UTF8");
                } else if (con != null && con.charset != null) {
                    this.bytes = con.charsetBytes(str);
                } else {
                    this.cli_wide_to_narrow(str, con != null ? con.client_charset_hash : null);
                }
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            } else if (dtp == 242) {
                if (con != null && (con.charset != null || con.charset_utf8)) {
                    this.bytes = con.charset_utf8 ? str.getBytes("UTF8") : con.charsetBytes(str);
                    this.dtp = this.bytes.length < 256 ? 181 : 182;
                } else {
                    boolean wide = false;
                    for (int i = 0; i < str.length(); ++i) {
                        if (str.charAt(i) <= '\u007f') continue;
                        wide = true;
                        break;
                    }
                    if (wide) {
                        this.bytes = str.getBytes("UTF8");
                        this.dtp = this.bytes.length < 256 ? 225 : 226;
                        this.str = str;
                    } else {
                        this.cli_wide_to_narrow(str, con != null ? con.client_charset_hash : null);
                        this.dtp = this.bytes.length < 256 ? 181 : 182;
                    }
                }
            } else if (dtp == 131 || dtp == 222) {
                this.bytes = str.getBytes("8859_1");
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            } else if (!this.cli_wide_to_narrow(str, con != null ? con.client_charset_hash : null)) {
                this.bytes = str.getBytes("UTF8");
                this.dtp = this.bytes.length < 256 ? 225 : 226;
                this.str = str;
            } else {
                if (con != null && con.charset_utf8) {
                    this.bytes = str.getBytes("UTF8");
                } else if (con != null && con.charset != null) {
                    this.bytes = con.charsetBytes(str);
                }
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            }
        }
        catch (UnsupportedEncodingException e) {
            if (con != null && con.charset != null) {
                this.bytes = con.charsetBytes(str);
            } else {
                this.cli_wide_to_narrow(str, con != null ? con.client_charset_hash : null);
            }
            dtp = this.bytes.length < 256 ? 181 : 182;
        }
    }

    protected boolean cli_wide_to_narrow(String str, Hashtable charset_ht) {
        boolean ret = true;
        if (str == null) {
            this.bytes = new byte[0];
            return true;
        }
        this.bytes = new byte[str.length()];
        if (charset_ht == null) {
            for (int i = 0; i < str.length(); ++i) {
                this.bytes[i] = (byte)str.charAt(i);
            }
        } else {
            for (int i = 0; i < str.length(); ++i) {
                Character ch = Character.valueOf(str.charAt(i));
                Byte b = (Byte)(charset_ht != null ? charset_ht.get(ch) : Byte.valueOf((byte)ch.charValue()));
                if (b == null) {
                    this.bytes[i] = 63;
                    ret = false;
                    continue;
                }
                this.bytes[i] = (byte)b.intValue();
            }
        }
        return ret;
    }

    protected boolean cli_wide_to_escaped(String str, Hashtable ht) {
        int i;
        boolean ret = true;
        if (str == null) {
            this.bytes = new byte[0];
            this.dtp = 181;
            return true;
        }
        StringBuffer strbuf = new StringBuffer();
        for (i = 0; i < str.length(); ++i) {
            char curr = str.charAt(i);
            Byte b = null;
            if (ht != null) {
                Character ch = Character.valueOf(curr);
                b = (Byte)ht.get(ch);
                if (b == null) {
                    strbuf.append("\\x");
                    strbuf.append(String.format("%04x", ch.charValue()));
                    continue;
                }
                strbuf.append((char)b.intValue());
                continue;
            }
            if (curr > '\u00ff') {
                strbuf.append("\\x");
                strbuf.append(String.format("%04x", curr));
                continue;
            }
            strbuf.append(curr);
        }
        this.bytes = new byte[strbuf.length() + 1];
        for (i = 0; i < strbuf.length(); ++i) {
            this.bytes[i] = (byte)strbuf.charAt(i);
        }
        strbuf = null;
        this.dtp = this.bytes.length < 256 ? 181 : 182;
        return true;
    }

    protected int getDtp() {
        return this.dtp;
    }

    protected void write(VirtuosoOutputStream os) throws IOException {
        os.write(this.dtp);
        if (this.bytes.length < 256) {
            os.write(this.bytes.length);
        } else {
            os.writelongint(this.bytes.length);
        }
        os.write(this.bytes, 0, this.bytes.length);
    }

    public String toString() {
        if (this.str != null) {
            return this.str;
        }
        try {
            if (this.dtp == 225 || this.dtp == 226) {
                return new String(this.bytes, "UTF8");
            }
            if (this.con != null && this.con.charset != null) {
                return this.con.uncharsetBytes(new String(this.bytes, "8859_1"));
            }
            return new String(this.bytes, "8859_1");
        }
        catch (Exception e) {
            char[] chars = new char[this.bytes.length];
            for (int i = 0; i < this.bytes.length; ++i) {
                chars[i] = (char)(this.bytes[i] & 0xFF);
            }
            return new String(chars);
        }
    }

    public String toParamString() {
        return this.toString().trim();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VirtuosoExplicitString) {
            VirtuosoExplicitString sobj = (VirtuosoExplicitString)obj;
            if (sobj.dtp != this.dtp) {
                return false;
            }
            return sobj.bytes.equals(this.bytes);
        }
        return false;
    }
}

