/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoDate;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoResultSet;
import virtuoso.jdbc4.VirtuosoStatement;
import virtuoso.jdbc4.VirtuosoTime;
import virtuoso.jdbc4.VirtuosoTimestamp;
import virtuoso.jdbc4.VirtuosoTypes;

class VirtuosoRow {
    private Vector content;
    protected int maxCol;
    private VirtuosoResultSet resultSet;

    VirtuosoRow(VirtuosoResultSet resultSet, Vector args) throws VirtuosoException {
        this.resultSet = resultSet;
        this.content = args;
        this.maxCol = resultSet.metaData.getColumnCount();
    }

    protected void getContent(Object[] anArray) {
        for (int i = 0; i < anArray.length && i < this.maxCol; ++i) {
            anArray[i] = this.content.elementAt(i);
        }
    }

    protected InputStream getAsciiStream(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        this.resultSet.wasNull(obj == null);
        if (obj != null && obj instanceof VirtuosoBlob) {
            return ((VirtuosoBlob)obj).getAsciiStream();
        }
        try {
            if (obj != null && obj instanceof String) {
                return new ByteArrayInputStream(((String)obj).getBytes("8859_1"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new VirtuosoException(e, -10);
        }
        if (obj != null && obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        return null;
    }

    protected InputStream getBinaryStream(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        this.resultSet.wasNull(obj == null);
        if (obj != null && obj instanceof VirtuosoBlob) {
            return ((VirtuosoBlob)obj).getBinaryStream();
        }
        try {
            if (obj != null && obj instanceof String) {
                return new ByteArrayInputStream(((String)obj).getBytes("8859_1"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new VirtuosoException(e, -10);
        }
        if (obj != null && obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        return null;
    }

    protected Reader getCharacterStream(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        this.resultSet.wasNull(obj == null);
        if (obj != null && obj instanceof VirtuosoBlob) {
            return ((VirtuosoBlob)obj).getCharacterStream();
        }
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            VirtuosoStatement stmt = (VirtuosoStatement)this.resultSet.getStatement();
            if (stmt.connection.charset != null && obj instanceof String) {
                int dtp = this.resultSet.metaData.getColumnDtp(column);
                switch (dtp) {
                    case 181: 
                    case 182: 
                    case 238: {
                        try {
                            str = stmt.connection.uncharsetBytes((String)obj);
                            break;
                        }
                        catch (Exception e) {
                            str = (String)obj;
                        }
                    }
                }
            }
            return new StringReader(str);
        }
        if (obj != null && obj instanceof char[]) {
            return new CharArrayReader((char[])obj);
        }
        return null;
    }

    protected BigDecimal getBigDecimal(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof Number) {
                try {
                    return new BigDecimal(((Number)obj).doubleValue());
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain a number.", -10);
                }
            }
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not a number.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected boolean getBoolean(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                return ((Number)obj).intValue() != 0;
            }
            if (obj instanceof String) {
                return Integer.parseInt((String)obj) != 0;
            }
            if (obj instanceof byte[]) {
                return Integer.parseInt(new String((byte[])obj)) != 0;
            }
            return Boolean.parseBoolean(obj.toString());
        }
        this.resultSet.wasNull(true);
        return false;
    }

    protected byte getByte(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                try {
                    return ((Number)obj).byteValue();
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain a byte.", -10);
                }
            }
            try {
                return Byte.parseByte(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not a byte.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0;
    }

    protected byte[] getBytes(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof VirtuosoBlob) {
                VirtuosoBlob blob = (VirtuosoBlob)obj;
                if (blob.length() > Integer.MAX_VALUE) {
                    throw new VirtuosoException("Will not return more than 2147483647 for a BLOB column. Use getBinaryStream() instead", -12);
                }
                return blob.getBytes(1L, (int)blob.length());
            }
            if (obj instanceof byte[]) {
                return (byte[])obj;
            }
            if (obj instanceof String) {
                try {
                    return ((String)obj).getBytes("8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
            throw new VirtuosoException("getBytes() return undefined on a value of type " + obj.getClass(), -12);
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected double getDouble(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                try {
                    return ((Number)obj).doubleValue();
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain a double.", -10);
                }
            }
            try {
                return Double.parseDouble(obj.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not a double.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0.0;
    }

    protected Date getDate(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof VirtuosoDate) {
                return ((VirtuosoDate)obj).clone();
            }
            if (obj instanceof VirtuosoTimestamp) {
                VirtuosoTimestamp _t = (VirtuosoTimestamp)obj;
                return new VirtuosoDate(_t.getTime(), _t.getTimezone(), _t.withTimezone());
            }
            if (obj instanceof VirtuosoTime) {
                VirtuosoTime _t = (VirtuosoTime)obj;
                return new VirtuosoDate(_t.getTime(), _t.getTimezone(), _t.withTimezone());
            }
            if (obj instanceof Date) {
                return new Date(((Date)obj).getTime());
            }
            if (obj instanceof String) {
                return VirtuosoTypes.strToDate((String)obj);
            }
            if (obj instanceof java.util.Date) {
                return new Date(((java.util.Date)obj).getTime());
            }
            throw new VirtuosoException("Column does not contain a Date.", -10);
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected Time getTime(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof VirtuosoTime) {
                return ((VirtuosoTime)obj).clone();
            }
            if (obj instanceof VirtuosoTimestamp) {
                VirtuosoTimestamp _t = (VirtuosoTimestamp)obj;
                return new VirtuosoTime(_t.getTime(), _t.getTimezone(), _t.withTimezone());
            }
            if (obj instanceof VirtuosoDate) {
                VirtuosoDate _t = (VirtuosoDate)obj;
                return new VirtuosoTime(_t.getTime(), _t.getTimezone(), _t.withTimezone());
            }
            if (obj instanceof Time) {
                return new Time(((Time)obj).getTime());
            }
            if (obj instanceof java.util.Date) {
                return new Time(((java.util.Date)obj).getTime());
            }
            if (obj instanceof String) {
                return VirtuosoTypes.strToTime((String)obj);
            }
            throw new VirtuosoException("Column does not contain a Time.", -10);
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected Timestamp getTimestamp(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof VirtuosoTimestamp) {
                return ((VirtuosoTimestamp)obj).clone();
            }
            if (obj instanceof VirtuosoTime) {
                VirtuosoTime _t = (VirtuosoTime)obj;
                return new VirtuosoTimestamp(_t.getTime(), _t.getTimezone(), _t.withTimezone());
            }
            if (obj instanceof VirtuosoDate) {
                VirtuosoDate _t = (VirtuosoDate)obj;
                return new VirtuosoTimestamp(_t.getTime(), _t.getTimezone(), _t.withTimezone());
            }
            if (obj instanceof Timestamp) {
                Timestamp val = new Timestamp(((Timestamp)obj).getTime());
                val.setNanos(((Timestamp)obj).getNanos());
                return val;
            }
            if (obj instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)obj).getTime());
            }
            if (obj instanceof String) {
                return VirtuosoTypes.strToTimestamp((String)obj);
            }
            throw new VirtuosoException("Column does not contain a Timestamp.", -10);
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected float getFloat(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                try {
                    return ((Number)obj).floatValue();
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain a float.", -10);
                }
            }
            try {
                return Float.parseFloat(obj.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not a float.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0.0f;
    }

    protected int getInt(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                try {
                    return ((Number)obj).intValue();
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain an int.", -10);
                }
            }
            try {
                return Integer.parseInt(obj.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not an int.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0;
    }

    protected long getLong(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                try {
                    return ((Number)obj).longValue();
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain a long.", -10);
                }
            }
            try {
                return Long.parseLong(obj.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not a long.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0L;
    }

    protected short getShort(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (obj instanceof Number) {
                try {
                    return ((Number)obj).shortValue();
                }
                catch (ClassCastException e) {
                    throw new VirtuosoException("Column does not contain a short.", -10);
                }
            }
            try {
                return Short.parseShort(obj.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException(obj.toString() + " is not a short.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0;
    }

    protected String getString(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            int dtp = this.resultSet.metaData.getColumnDtp(column);
            this.resultSet.wasNull(false);
            VirtuosoStatement stmt = (VirtuosoStatement)this.resultSet.getStatement();
            if (stmt.connection.charset != null && obj instanceof String) {
                switch (dtp) {
                    case 181: 
                    case 182: 
                    case 238: {
                        try {
                            return stmt.connection.uncharsetBytes((String)obj);
                        }
                        catch (Exception e) {
                            return (String)obj;
                        }
                    }
                }
            }
            if (obj instanceof Timestamp) {
                Timestamp ts = (Timestamp)obj;
                switch (dtp) {
                    case 129: {
                        return new Date(ts.getTime()).toString();
                    }
                    case 210: {
                        return new Time(ts.getTime()).toString();
                    }
                }
            } else if (obj instanceof VirtuosoBlob) {
                try {
                    int l;
                    Reader r = ((VirtuosoBlob)obj).getCharacterStream();
                    char[] data = new char[1024];
                    StringWriter w = new StringWriter();
                    while ((l = r.read(data)) != -1) {
                        w.write(data, 0, l);
                    }
                    return w.toString();
                }
                catch (IOException e) {
                    throw new VirtuosoException(e, -17);
                }
            }
            return obj.toString();
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected VirtuosoBlob getBlob(int column) throws VirtuosoException {
        VirtuosoBlob obj;
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        VirtuosoBlob virtuosoBlob = obj = this.content.elementAt(column - 1) instanceof String ? new VirtuosoBlob(((String)this.content.elementAt(column - 1)).getBytes()) : (VirtuosoBlob)this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            return obj;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected VirtuosoBlob getClob(int column) throws VirtuosoException {
        VirtuosoBlob obj;
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        VirtuosoBlob virtuosoBlob = obj = this.content.elementAt(column - 1) instanceof String ? new VirtuosoBlob(((String)this.content.elementAt(column - 1)).getBytes()) : (VirtuosoBlob)this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            return obj;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected Object createDOMT(Object data) throws VirtuosoException {
        Object db = null;
        Method parse_mtd = null;
        try {
            Class<?> dbfact_cls = Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            Method newInstMtd = dbfact_cls.getDeclaredMethod("newInstance", new Class[0]);
            Method newDbMtd = dbfact_cls.getDeclaredMethod("newDocumentBuilder", new Class[0]);
            Object dbfact = newInstMtd.invoke(null, new Object[0]);
            db = newDbMtd.invoke(dbfact, new Object[0]);
            Class<?> db_cls = Class.forName("javax.xml.parsers.DocumentBuilder");
            Class<?> parse_args = Class.forName("java.io.InputStream");
            parse_mtd = db_cls.getDeclaredMethod("parse", parse_args);
        }
        catch (Throwable t) {
            db = null;
        }
        if (db == null || parse_mtd == null) {
            return data;
        }
        try {
            Object[] args;
            if (data instanceof String) {
                args = new Object[]{new ByteArrayInputStream(((String)data).getBytes("UTF-8"))};
                data = parse_mtd.invoke(db, args);
            } else if (data instanceof VirtuosoBlob) {
                args = new Object[]{((VirtuosoBlob)data).getBinaryStream()};
                data = parse_mtd.invoke(db, args);
            }
        }
        catch (Exception e) {
            throw new VirtuosoException(e, -10);
        }
        return data;
    }

    protected Object getObject(int column) throws VirtuosoException {
        if (column < 1 || column > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.maxCol, -4);
        }
        Object obj = this.content.elementAt(column - 1);
        if (obj != null) {
            this.resultSet.wasNull(false);
            if (this.resultSet.metaData.isXml(column)) {
                return this.createDOMT(obj);
            }
            if (obj instanceof VirtuosoTimestamp) {
                return ((VirtuosoTimestamp)obj).clone();
            }
            if (obj instanceof VirtuosoTime) {
                return ((VirtuosoTime)obj).clone();
            }
            if (obj instanceof VirtuosoDate) {
                return ((VirtuosoDate)obj).clone();
            }
            if (obj instanceof Date) {
                return new Date(((Date)obj).getTime());
            }
            if (obj instanceof Time) {
                return new Time(((Time)obj).getTime());
            }
            if (obj instanceof Timestamp) {
                Timestamp val = new Timestamp(((Timestamp)obj).getTime());
                val.setNanos(((Timestamp)obj).getNanos());
                return val;
            }
            return obj;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected int getRow() {
        return this.maxCol != this.content.size() ? ((Number)this.content.elementAt(this.maxCol)).intValue() : 0;
    }

    protected String getRef() {
        if (this.maxCol != this.content.size()) {
            Vector v1 = (Vector)this.content.elementAt(this.maxCol);
            Vector v2 = (Vector)v1.elementAt(1);
            Object ret = v2.elementAt(0);
            return ret.toString();
        }
        return "";
    }

    protected Vector getBookmark() {
        if (this.maxCol != this.content.size()) {
            return (Vector)this.content.elementAt(this.maxCol);
        }
        return this.content;
    }

    public String toString() {
        if (this.content == null) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("{ROW ");
        buf.append(this.content.toString());
        buf.append("}");
        return buf.toString();
    }
}

