/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"
#include "sqlbif.h"
/* snapshot_repl.sql */

static const char *tbl0 = 
"create table SYS_SNAPSHOT (\n"
"SN_NAME varchar(255) NOT NULL,\n"
"SN_QUERY varchar(1024) NOT NULL,\n"
"SN_LAST_TS datetime,\n"
"SN_IS_INCREMENTAL integer,\n"
"SN_SOURCE_TABLE varchar(255),\n"
"SN_LAST_UPD_BM varchar,\n"
"primary key (SN_NAME)\n"
")\n";

static const char *alter0 = 
"alter table SYS_SNAPSHOT add SN_LAST_UPD_BM varchar\n";

static const char *tbl1 = 
"create table SYS_SNAPSHOT_LOG (\n"
"SNL_SOURCE	varchar (320) NOT NULL,\n"
"SNL_RLOG	varchar (320) NOT NULL,\n"
"SNL_RPLOG	varchar (320) NOT NULL,\n"
"primary key (SNL_SOURCE)\n"
")\n"
"create unique index SNL_RLOG on DB.DBA.SYS_SNAPSHOT_LOG (SNL_RLOG)\n"
"create unique index SNL_RPLOG on DB.DBA.SYS_SNAPSHOT_LOG (SNL_RPLOG)\n";

static const char *proc0 = 
"#line 51 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_OFFSET_TIME (\n"
"in _last_ts datetime, in _reg_var varchar, in _default_offset integer)\n"
"returns datetime\n"
"{\n"
"if (_last_ts is null)\n"
"return null;\n"
"\n"
"declare v any;\n"
"v := registry_get (_reg_var);\n"
"declare n integer;\n"
"if (v = 0 or (n := atoi(v)) = 0)\n"
"n := _default_offset;\n"
"\n"
"declare _starttime datetime;\n"
"_starttime := dateadd (\'minute\', -n, _last_ts);\n"
"\n"
"return _starttime;\n"
"}\n"
"--src snapshot_repl.sql:49\n"
;

static const char *proc1 = 
"#line 71 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_ORIGIN (in _rowguid varchar)\n"
"{\n"
"declare _delim_pos integer;\n"
"\n"
"_delim_pos := strchr (_rowguid, \'@\');\n"
"if (_delim_pos is not null)\n"
"return substring (_rowguid, 1, _delim_pos);\n"
"return null;\n"
"}\n"
"--src snapshot_repl.sql:69\n"
;

static const char *proc2 = 
"#line 82 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_SET_ORIGIN (\n"
"in _rowguid varchar, in _origin varchar := null)\n"
"{\n"
"if (_origin is null)\n"
"_origin := repl_this_server();\n"
"\n"
"declare _delim_pos integer;\n"
"_delim_pos := strchr (_rowguid, \'@\');\n"
"if (_delim_pos is not null)\n"
"_rowguid := subseq (_rowguid, _delim_pos + 1);\n"
"return concat (_origin, \'@\', _rowguid);\n"
"}\n"
"--src snapshot_repl.sql:80\n"
;

static const char *tbl2 = 
"create table DB.DBA.SYS_SNAPSHOT_PUB (\n"
"SP_ITEM varchar,\n"
"SP_TYPE integer,\n"
"SP_LAST_TS datetime,\n"
"\n"
"primary key (SP_ITEM, SP_TYPE)\n"
")\n";

static const char *other0 = 
"grant select on DB.DBA.SYS_SNAPSHOT_PUB to PUBLIC\n";
static const char *tbl3 = 
"create table DB.DBA.SYS_SNAPSHOT_SUB (\n"
"SS_SERVER varchar,\n"
"SS_ITEM varchar,\n"
"SS_TYPE integer,\n"
"SS_LAST_PULL_TS datetime,\n"
"SS_LAST_PUSH_TS datetime,\n"
"\n"
"primary key (SS_SERVER, SS_ITEM, SS_TYPE)\n"
")\n";

static const char *other1 = 
"grant select on DB.DBA.SYS_SNAPSHOT_SUB to PUBLIC\n";
static const char *tbl4 = 
"create table DB.DBA.SYS_SNAPSHOT_CR (\n"
"CR_ID         integer,\n"
"CR_TABLE_NAME varchar,\n"
"CR_TYPE       char,\n"
"CR_PROC       varchar,\n"
"CR_ORDER      integer,\n"
"\n"
"primary key (CR_ID)\n"
")\n";

static const char *other2 = 
"grant select on DB.DBA.SYS_SNAPSHOT_CR to PUBLIC\n";
static const char *tbl5 = 
"create table DB.DBA.SYS_DAV_CR (\n"
"CR_ID         integer,\n"
"CR_COL_NAME   varchar,\n"
"CR_PROC       varchar,\n"
"CR_ORDER      integer,\n"
"\n"
"primary key (CR_ID)\n"
")\n";

static const char *other3 = 
"grant select on DB.DBA.SYS_DAV_CR to PUBLIC\n";
static const char *tbl6 = 
"create table DB.DBA.SYS_REPL_POSTPONED_RES (\n"
"POSTPONED_RES_ID integer identity primary key,\n"
"POSTPONED_RES_TS timestamp,\n"
"\n"
"LOCKED_COL_ID integer,\n"
"LOCKED_RES_ID integer,\n"
"\n"
"RES_COLPATH varchar,\n"
"RES_NAME varchar,\n"
"RES_CONTENT long varbinary,\n"
"RES_TYPE varchar,\n"
"RES_PERMS varchar,\n"
"RES_UNAME varchar,\n"
"RES_GNAME varchar,\n"
"RES_CR_TIME datetime,\n"
"RES_MOD_TIME datetime,\n"
"RES_ROWGUID varchar,\n"
"\n"
"RES_CR_COLNAME varchar,\n"
"\n"
"RES_EMAIL varchar,\n"
"RES_ORIGIN varchar,\n"
"RES_OLD_ROWGUID varchar)\n"
"create index SYS_REPL_POSTPONED_LOCKED_COL_ID on DB.DBA.SYS_REPL_POSTPONED_RES (LOCKED_COL_ID)\n"
"create index SYS_REPL_POSTPONED_LOCKED_RES_ID on DB.DBA.SYS_REPL_POSTPONED_RES (LOCKED_RES_ID)\n";

static const char *proc3 = 
"#line 207 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_REMOTE_TYPES_RAW (in _dsn varchar)\n"
"returns any\n"
"{\n"
"declare _remote_types, _remote_types_info any;\n"
"_remote_types := vector ();\n"
"_remote_types_info := sql_gettypeinfo (_dsn);\n"
"\n"
"declare _type_info any;\n"
"declare _sql_dtp integer;\n"
"declare _type_title varchar;\n"
"declare _idx, _len integer;\n"
"_idx := 0;\n"
"_len := length (_remote_types_info);\n"
"while (_idx < _len)\n"
"{\n"
"_type_info := _remote_types_info[_idx];\n"
"_sql_dtp := _type_info[1];\n"
"_type_title := _type_info[0];\n"
"REPL_ENSURE_MAPPING (_remote_types, _type_info[1], _type_info[0], _type_info);\n"
"_idx := _idx + 1;\n"
"}\n"
"return _remote_types;\n"
"}\n"
"--src snapshot_repl.sql:205\n"
;

static const char *proc4 = 
"#line 258 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_REMOTE_TYPES (\n"
"in _dsn varchar, in _dbms_name varchar := null)\n"
"returns any\n"
"{\n"
"declare _remote_types any;\n"
"_remote_types := REPL_REMOTE_TYPES_RAW (_dsn);\n"
"\n"
"\n"
"if (_dbms_name is null)\n"
"_dbms_name := get_keyword (17, vdd_dsn_info(_dsn), \'\');\n"
"if (strstr (_dbms_name, \'SQL Server\') is not null or\n"
"strstr (_dbms_name, \'S Q L   S e r v e r\') is not null)\n"
"{\n"
"REPL_ENSURE_MAPPING (_remote_types, 8, \'float\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 9, \'datetime\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 10, \'datetime\');\n"
"}\n"
"else if (strstr (upper (_dbms_name), \'ORACLE\') is not null)\n"
"{\n"
"REPL_ENSURE_MAPPING (_remote_types, -10, \'NCLOB\');\n"
"REPL_ENSURE_MAPPING (_remote_types, -9, \'NVARCHAR2\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 2, \'NUMERIC\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 4, \'INTEGER\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 5, \'SMALLINT\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 7, \'FLOAT\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 9, \'DATE\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 10, \'DATE\');\n"
"}\n"
"else if (strstr (_dbms_name, \'DB2\') is not null)\n"
"{\n"
"REPL_ENSURE_MAPPING (_remote_types, -10, \'DBCLOB\');\n"
"REPL_ENSURE_MAPPING (_remote_types, -9, \'VARCHAR () FOR MIXED DATA\');\n"
"\n"
"REPL_OVERRIDE_MAPPING (_remote_types, -4, \'BLOB\');\n"
"REPL_OVERRIDE_MAPPING (_remote_types, -1, \'CLOB\');\n"
"}\n"
"else if (strstr (_dbms_name, \'Informix\') is not null)\n"
"{\n"
"\n"
"REPL_ENSURE_MAPPING (_remote_types, -10, \'TEXT\');\n"
"REPL_ENSURE_MAPPING (_remote_types, -9, \'NVARCHAR\');\n"
"REPL_ENSURE_MAPPING (_remote_types, -3, \'BYTE\');\n"
"REPL_ENSURE_MAPPING (_remote_types, 2, \'DECIMAL\');\n"
"}\n"
"return _remote_types;\n"
"}\n"
"--src snapshot_repl.sql:256\n"
;

static const char *proc5 = 
"#line 306 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_ALL_COLS (in _tbl varchar)\n"
"{\n"
"declare _stmt varchar;\n"
"declare _stat, _msg varchar;\n"
"declare _src_comp any;\n"
"_stmt := sprintf (\'select * from %s where 1 = 0\', REPL_FQNAME (_tbl));\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec(_stmt, _stat, _msg, vector(), 1, _src_comp, null))\n"
"signal (\'37000\', concat (\'The table \'\'\', _tbl, \'\'\' does not exist\'), \'TR044\');\n"
"\n"
"declare _cols, _col any;\n"
"declare _ix, _len integer;\n"
"_cols := vector();\n"
"_ix := 0;\n"
"_len := length (_src_comp[0]);\n"
"while (_ix < _len)\n"
"{\n"
"_col := _src_comp[0][_ix];\n"
"_cols := vector_concat (_cols,\n"
"vector (vector (repl_undot_name (_col[0]), _col[1], _col[2], _col[3])));\n"
"_ix := _ix + 1;\n"
"}\n"
"\n"
"return _cols;\n"
"}\n"
"--src snapshot_repl.sql:304\n"
;

static const char *proc6 = 
"#line 334 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_TBL_COLS (in _tbl varchar)\n"
"{\n"
"declare _cols, _col any;\n"
"declare _col_name varchar;\n"
"declare _tbl_cols varchar;\n"
"declare _ix, _len integer;\n"
"_cols := REPL_ALL_COLS (_tbl);\n"
"_tbl_cols := \'\';\n"
"_ix := 0;\n"
"_len := length (_cols);\n"
"while (_ix < _len)\n"
"{\n"
"_col := aref (_cols, _ix);\n"
"_col_name := aref (_col, 0);\n"
"\n"
"_tbl_cols := concat (_tbl_cols, sprintf (\'\"%I\"\', _col_name));\n"
"if (_ix + 1 < _len)\n"
"_tbl_cols := concat (_tbl_cols, \', \');\n"
"_ix := _ix + 1;\n"
"}\n"
"return _tbl_cols;\n"
"}\n"
"--src snapshot_repl.sql:332\n"
;

static const char *proc7 = 
"#line 360 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_COMPLETE_COLNAME (in _colname varchar)\n"
"returns varchar\n"
"{\n"
"declare _len integer;\n"
"_len := length (_colname);\n"
"if (_len > 0 and subseq (_colname, _len - 1) <> \'/\')\n"
"_colname := concat (_colname, \'/\');\n"
"return _colname;\n"
"}\n"
"--src snapshot_repl.sql:358\n"
;

static const char *tbl7 = 
"create table WS.WS.RPLOG_SYS_DAV_RES (\n"
"SOURCE varchar,\n"
"TARGET varchar,\n"
"RLOG_ROWGUID varchar,\n"
"SNAPTIME datetime,\n"
"primary key (SOURCE, TARGET, RLOG_ROWGUID)\n"
")\n";

static const char *proc8 = 
"#line 397 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_DAV_STORE_RES_INT (\n"
"in _res_colname varchar, in _res_name varchar, inout _res_content any,\n"
"in _res_type varchar, in _res_perms varchar,\n"
"in _res_uname varchar, in _res_gname varchar,\n"
"in _res_cr_time datetime, in _res_mod_time datetime, in _rowguid varchar,\n"
"in _cr_colname varchar, in _res_email varchar,\n"
"in _origin varchar, in _old_rowguid varchar,\n"
"in _res_col integer, inout _backup_colid integer)\n"
"{\n"
"declare _rc integer;\n"
"\n"
"if (_res_col is null and (_res_col := DAV_SEARCH_ID (_res_colname, \'c\')) < 0)\n"
"{\n"
"\n"
"return _res_col;\n"
"}\n"
"declare _res_rowguid varchar;\n"
"_res_rowguid := _rowguid;\n"
"\n"
"\n"
"\n"
"\n"
"declare _locked_id integer;\n"
"declare _locked_type char;\n"
"_locked_id := DAV_SEARCH_ID (concat (_res_colname, _res_name), \'r\');\n"
"_locked_type := \'R\';\n"
"if (DAV_IS_LOCKED_INT (_locked_id, _locked_type) > 0)\n"
"{\n"
"\n"
"declare _locked_col_id integer;\n"
"declare _locked_res_id integer;\n"
"if (_locked_type = \'R\')\n"
"{\n"
"_locked_col_id := null;\n"
"_locked_res_id := _locked_id;\n"
"}\n"
"else\n"
"{\n"
"_locked_col_id := _locked_id;\n"
"_locked_res_id := null;\n"
"}\n"
"\n"
"delete from DB.DBA.SYS_REPL_POSTPONED_RES where RES_COLPATH = _res_content and RES_NAME = _res_name;\n"
"insert into DB.DBA.SYS_REPL_POSTPONED_RES (\n"
"LOCKED_COL_ID, LOCKED_RES_ID,\n"
"RES_COLPATH, RES_NAME, RES_CONTENT, RES_TYPE, RES_PERMS,\n"
"RES_UNAME, RES_GNAME, RES_CR_TIME, RES_MOD_TIME, RES_ROWGUID,\n"
"RES_CR_COLNAME, RES_EMAIL, RES_ORIGIN, RES_OLD_ROWGUID)\n"
"values (_locked_col_id, _locked_res_id, _res_colname, _res_name,\n"
"_res_content, _res_type, _res_perms, _res_uname, _res_gname,\n"
"_res_cr_time, _res_mod_time, _rowguid,\n"
"_cr_colname, _res_email, _origin, _old_rowguid);\n"
"return 0;\n"
"}\n"
"\n"
"if (_cr_colname is not null)\n"
"{\n"
"\n"
"declare _loc_content any;\n"
"declare _loc_perms, _loc_type, _loc_rowguid varchar;\n"
"declare _loc_cr_time, _loc_mod_time datetime;\n"
"declare _loc_uname, _loc_email, _loc_gname varchar;\n"
"declare _notify_email varchar;\n"
"\n"
"declare _do_backup, _do_notify integer;\n"
"declare _notify_text varchar;\n"
"_do_backup := null;\n"
"_do_notify := null;\n"
"_notify_email := null;\n"
"_notify_text := null;\n"
"\n"
"whenever not found goto store_resource;\n"
"select RES_CONTENT, RES_PERMS, RES_TYPE, RES_CR_TIME, RES_MOD_TIME,\n"
"ROWGUID, U_NAME, U_E_MAIL, G_NAME\n"
"into _loc_content, _loc_perms, _loc_type,\n"
"_loc_cr_time, _loc_mod_time, _loc_rowguid,\n"
"_loc_uname, _loc_email, _loc_gname\n"
"from WS.WS.SYS_DAV_RES\n"
"left join WS.WS.SYS_DAV_USER on (RES_OWNER = U_ID)\n"
"left join WS.WS.SYS_DAV_GROUP on (RES_GROUP = G_ID)\n"
"where RES_COL = _res_col and RES_NAME = _res_name;\n"
"\n"
"if (_loc_rowguid = _old_rowguid)\n"
"{\n"
"\n"
"goto store_resource;\n"
"}\n"
"\n"
"for select CR_PROC as _cr_proc from DB.DBA.SYS_DAV_CR\n"
"where CR_COL_NAME = _cr_colname order by CR_ORDER do\n"
"{\n"
"\n"
"_rc := call (_cr_proc) (\n"
"_res_col, _res_name, _res_email,\n"
"_res_content, _res_type, _res_cr_time, _res_mod_time,\n"
"_res_uname, _res_gname,\n"
"_do_backup, _do_notify, _notify_email, _notify_text);\n"
"if (_rc = 5 or _rc = 4)\n"
"{\n"
"\n"
"\n"
"if (_notify_email is null)\n"
"_notify_email := _res_email;\n"
"if (0 <> REPL_DAV_SAVE_BACKUP (\n"
"_do_backup, _do_notify, _notify_email, _notify_text,\n"
"_backup_colid, _res_colname,\n"
"_res_name, _res_content, _res_type, _res_perms,\n"
"_res_uname, _res_gname,\n"
"_res_cr_time, _res_mod_time, _res_rowguid))\n"
"return -20;\n"
"return 0;\n"
"}\n"
"else if (_rc = 3)\n"
"{\n"
"\n"
"goto publisher_wins;\n"
"}\n"
"else if (_rc = 2)\n"
"{\n"
"\n"
"_res_rowguid := REPL_SET_ORIGIN (_res_rowguid);\n"
"goto subscriber_wins;\n"
"}\n"
"else if (_rc = 1)\n"
"{\n"
"\n"
"goto subscriber_wins;\n"
"}\n"
"}\n"
"\n"
"\n"
"if (_do_backup is null)\n"
"_do_backup := 1;\n"
"if (_do_notify is null)\n"
"_do_notify := 1;\n"
"\n"
"publisher_wins:\n"
"if (_notify_email is null)\n"
"_notify_email := _res_email;\n"
"if (0 <> REPL_DAV_SAVE_BACKUP (\n"
"_do_backup, _do_notify, _notify_email, _notify_text,\n"
"_backup_colid, _res_colname,\n"
"_res_name, _res_content, _res_type, _res_perms,\n"
"_res_uname, _res_gname, _res_cr_time, _res_mod_time,\n"
"_res_rowguid))\n"
"return -20;\n"
"_res_content := _loc_content;\n"
"_res_type := _loc_type;\n"
"_res_perms := _loc_perms;\n"
"_res_uname := _loc_uname;\n"
"_res_gname := _loc_gname;\n"
"_res_cr_time := _loc_cr_time;\n"
"_res_mod_time := _loc_mod_time;\n"
"_res_rowguid := _loc_rowguid;\n"
"goto store_resource;\n"
"\n"
"subscriber_wins:\n"
"if (_notify_email is null)\n"
"_notify_email := _loc_email;\n"
"if (0 <> REPL_DAV_SAVE_BACKUP (\n"
"_do_backup, _do_notify, _loc_email, _notify_text,\n"
"_backup_colid, _res_colname,\n"
"_res_name, _loc_content, _loc_type, _loc_perms,\n"
"_loc_uname, _loc_gname, _loc_cr_time, _loc_mod_time,\n"
"_loc_rowguid))\n"
"return -20;\n"
"\n"
"store_resource:\n"
"_res_rowguid := concat (\'raw:\', _rowguid);\n"
"}\n"
"\n"
"\n"
"_rc := DAV_RES_UPLOAD_STRSES_INT (\n"
"concat (_res_colname, _res_name), _res_content, _res_type, _res_perms,\n"
"_res_uname, _res_gname, null, null, 0,\n"
"_res_cr_time, _res_mod_time, _res_rowguid);\n"
"if (_rc < 0)\n"
"{\n"
"\n"
"return _rc;\n"
"}\n"
"return 0;\n"
"}\n"
"--src snapshot_repl.sql:395\n"
;

static const char *proc9 = 
"#line 582 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_DAV_STORE_RES (\n"
"in _res_colname varchar, in _res_name varchar, in _res_content any,\n"
"in _res_type varchar, in _res_perms varchar,\n"
"in _res_uname varchar, in _res_gname varchar,\n"
"in _res_cr_time datetime, in _res_mod_time datetime, in _rowguid varchar,\n"
"in _origin varchar, in _old_rowguid varchar)\n"
"{\n"
"declare _backup_colid integer;\n"
"_backup_colid := null;\n"
"return REPL_DAV_STORE_RES_INT (\n"
"_res_colname, _res_name, _res_content, _res_type, _res_perms,\n"
"_res_uname, _res_gname, _res_cr_time, _res_mod_time, _rowguid,\n"
"null, null, null, null, null, _backup_colid);\n"
"}\n"
"--src snapshot_repl.sql:580\n"
;

static const char *trig0 = 
"#line 598 \"[executable]/snapshot_repl.sql\"\n"
"create trigger SYS_DAV_LOCK_PROCESS_POSTPONED\n"
"after delete on WS.WS.SYS_DAV_LOCK order 200 referencing old as _O\n"
"{\n"
"declare _colid integer;\n"
"declare _backup_colid integer;\n"
"_backup_colid := null;\n"
"\n"
"\n"
"declare _res_colpath, _res_name varchar;\n"
"declare _res_content varchar;\n"
"declare _res_type, _res_perms, _res_uname, _res_gname varchar;\n"
"declare _res_cr_time, _res_mod_time datetime;\n"
"declare _res_rowguid varchar;\n"
"declare _res_cr_colname, _res_email, _res_origin, _res_old_rowguid varchar;\n"
"\n"
"declare cr cursor for\n"
"select RES_COLPATH, RES_NAME,\n"
"cast (RES_CONTENT as varchar), RES_TYPE, RES_PERMS,\n"
"RES_UNAME, RES_GNAME, RES_CR_TIME, RES_MOD_TIME, RES_ROWGUID,\n"
"RES_CR_COLNAME, RES_EMAIL, RES_ORIGIN, RES_OLD_ROWGUID\n"
"from DB.DBA.SYS_REPL_POSTPONED_RES\n"
"where (_O.LOCK_PARENT_TYPE = \'C\' and LOCKED_COL_ID = _O.LOCK_PARENT_ID)\n"
"or (_O.LOCK_PARENT_TYPE = \'R\' and LOCKED_RES_ID = _O.LOCK_PARENT_ID);\n"
"\n"
"open cr (exclusive);\n"
"whenever not found goto nf;\n"
"while (1)\n"
"{\n"
"fetch cr into _res_colpath, _res_name,\n"
"_res_content, _res_type, _res_perms,\n"
"_res_uname, _res_gname, _res_cr_time, _res_mod_time, _res_rowguid,\n"
"_res_cr_colname, _res_email, _res_origin, _res_old_rowguid;\n"
"_colid := DAV_SEARCH_ID (_res_colpath, \'c\');\n"
"if (_colid < 0)\n"
"goto next;\n"
"\n"
"if (DB.DBA.REPL_DAV_STORE_RES_INT (_res_colpath, _res_name,\n"
"_res_content, _res_type, _res_perms, _res_uname, _res_gname,\n"
"_res_cr_time, _res_mod_time, _res_rowguid,\n"
"_res_cr_colname, _res_email, _res_origin, _res_old_rowguid,\n"
"_colid, _backup_colid) >= 0)\n"
"{\n"
"\n"
"delete from DB.DBA.SYS_REPL_POSTPONED_RES where current of cr;\n"
"}\n"
"next:\n"
" ;\n"
"}\n"
"nf:\n"
"close cr;\n"
"}\n"
"--src snapshot_repl.sql:596\n";

static const char *proc10 = 
"#line 653 \"[executable]/snapshot_repl.sql\"\n"
"create procedure REPL_DAV_SAVE_BACKUP (\n"
"in _do_backup integer, in _do_notify integer,\n"
"in _notify_email varchar, in _notify_text varchar,\n"
"inout _backup_colid integer, in _colname varchar,\n"
"in _res_name varchar, inout _res_content any,\n"
"in _res_type varchar, in _res_perms varchar,\n"
"in _res_uname varchar, in _res_gname varchar,\n"
"in _res_cr_time datetime, in _res_mod_time datetime,\n"
"in _res_rowguid varchar)\n"
"{\n"
"if (_do_backup is null)\n"
"_do_backup := 0;\n"
"if (_do_backup <> 0)\n"
"{\n"
"\n"
"declare _backup_colname varchar;\n"
"_backup_colname := concat (_colname, \'_SYS_REPL_BACKUP/\');\n"
"if (_backup_colid is null)\n"
"{\n"
"declare _uname, _gname varchar;\n"
"declare exit handler for not found goto nf;\n"
"select U_NAME, G_NAME\n"
"into _uname, _gname\n"
"from WS.WS.SYS_DAV_COL, WS.WS.SYS_DAV_USER, WS.WS.SYS_DAV_GROUP\n"
"where COL_ID = DB.DBA.DAV_SEARCH_ID (_colname, \'c\')\n"
"and COL_OWNER = U_ID and COL_GROUP = G_ID;\n"
"goto create_backup_col;\n"
"nf:\n"
"_uname := \'dav\';\n"
"_gname := \'administrators\';\n"
"create_backup_col:\n"
"_backup_colid := DAV_COL_CREATE_INT (\n"
"_backup_colname, \'110100000R\', _uname, _gname,\n"
"null, null, 0, 0, 0);\n"
"if (_backup_colid < 0)\n"
"{\n"
"\n"
"return _backup_colid;\n"
"}\n"
"}\n"
"\n"
"\n"
"declare _max_id integer;\n"
"select coalesce (max (RES_ID) + 1, 0) into _max_id from WS.WS.SYS_DAV_RES\n"
"where RES_COL = _backup_colid;\n"
"_res_name := concat (\n"
"_backup_colname, _res_name, \'.\', sprintf (\'%d\', _max_id));\n"
"\n"
"_res_rowguid := concat (\'nolog:\', _res_rowguid);\n"
"\n"
"declare _rc integer;\n"
"_rc := DAV_RES_UPLOAD_STRSES_INT (\n"
"_res_name, _res_content, _res_type, _res_perms,\n"
"_res_uname, _res_gname, null, null, 0,\n"
"_res_cr_time, _res_mod_time, _res_rowguid);\n"
"if (_rc < 0)\n"
"{\n"
"\n"
"return _rc;\n"
"}\n"
"}\n"
"\n"
"if (_do_notify is null)\n"
"_do_notify := 0;\n"
"if (_do_notify <> 0)\n"
"{\n"
"if (_notify_text is null)\n"
"{\n"
"if (_do_backup <> 0)\n"
"{\n"
"_notify_text := sprintf (\n"
"\'Backup copy of your file saved in\n"
"\'\'%s\'\'\n"
"(server \'\'%s\'\')\',\n"
"_res_name, repl_this_server());\n"
"}\n"
"else\n"
"{\n"
"_notify_text := sprintf (\n"
"\'Your file \'\'%s\'\'\n"
"conflicted with another one and was replaced according to conflict\n"
"resolution policy (server \'\'%s\'\')\',\n"
"concat (_colname, _res_name), repl_this_server());\n"
"}\n"
"}\n"
"\n"
"\n"
"declare _stat, _msg varchar;\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (\'smtp_send (null, ?, ?, ?)\', _stat, _msg,\n"
"vector (_notify_email, _notify_email, _notify_text)))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src snapshot_repl.sql:651\n"
;

/* repl.sql */

static const char *proc11 = 
"#line 28 \"[executable]/repl.sql\"\n"
"create procedure REPL_PUB_REMOVE (in __pub varchar, in _item varchar, in _type integer, in _not_all varchar)\n"
"{\n"
"declare _is_updatable integer;\n"
"_is_updatable := REPL_IS_UPDATABLE(repl_this_server(), __pub);\n"
"declare _stat, _msg, _pub varchar;\n"
"_pub := SYS_ALFANUM_NAME (__pub);\n"
"_stat := \'00000\'; _msg := \'\';\n"
"if (not exists (select 1 from DB.DBA.SYS_TP_ITEM where TI_SERVER = repl_this_server ()\n"
"and TI_ACCT = _pub and TI_ITEM = _item and TI_TYPE = _type))\n"
"signal (\'37000\', concat (\'Item \'\'\', _item, \'\'\' does not exist in publication \'\'\', _pub, \'\'\'\'), \'TR001\');\n"
"delete from DB.DBA.SYS_TP_ITEM where TI_SERVER = repl_this_server () and\n"
"TI_ACCT = _pub and TI_ITEM = _item and TI_TYPE = _type;\n"
"\n"
"\n"
"\n"
"if (_not_all is not null)\n"
"repl_text (_pub, \'REPL_UNSUBSCRIBE (?, ?, ?)\', repl_this_server (), _pub, _item);\n"
"\n"
"if (_type = 2)\n"
"{\n"
"exec (sprintf (\'drop trigger \"%I\".\"%I\".\"repl_%I_D\"\', name_part (_item, 0), name_part (_item, 1),\n"
"replace (_item, \'.\', \'_\')), _stat, _msg);\n"
"exec (sprintf (\'drop trigger \"%I\".\"%I\".\"repl_%I_I\"\', name_part (_item, 0), name_part (_item, 1),\n"
"replace (_item, \'.\', \'_\')), _stat, _msg);\n"
"exec (sprintf (\'drop trigger \"%I\".\"%I\".\"repl_%I_U\"\', name_part (_item, 0), name_part (_item, 1),\n"
"replace (_item, \'.\', \'_\')), _stat, _msg);\n"
"if (_is_updatable <> 0)\n"
"{\n"
"\n"
"exec (sprintf (\'drop procedure \"%I\".\"%I\".\"replcr_%I_I\"\',\n"
"name_part (_item, 0), name_part (_item, 1),\n"
"replace (_item, \'.\', \'_\')),\n"
"_stat, _msg);\n"
"exec (sprintf (\'drop procedure \"%I\".\"%I\".\"replcr_%I_U\"\',\n"
"name_part (_item, 0), name_part (_item, 1),\n"
"replace (_item, \'.\', \'_\')),\n"
"_stat, _msg);\n"
"exec (sprintf (\'drop procedure \"%I\".\"%I\".\"replcr_%I_D\"\',\n"
"name_part (_item, 0), name_part (_item, 1),\n"
"replace (_item, \'.\', \'_\')),\n"
"_stat, _msg);\n"
"for select CR_PROC as _cr_proc from DB.DBA.SYS_REPL_CR\n"
"where CR_TABLE_NAME = _item do\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"exec (sprintf (\'drop procedure %s\', REPL_FQNAME (_cr_proc)),\n"
"_stat, _msg);\n"
"}\n"
"exec (\'delete from DB.DBA.SYS_REPL_CR where CR_TABLE_NAME = ?\',\n"
"_stat, _msg, vector (_item));\n"
"}\n"
"}\n"
"else if (_type = 3)\n"
"{\n"
"declare txt, ptxt, mtxt varchar;\n"
"declare _off integer;\n"
"select P_TEXT, blob_to_string (P_MORE) into ptxt, mtxt from DB.DBA.SYS_PROCEDURES where P_NAME = _item;\n"
"txt := coalesce (ptxt, mtxt);\n"
"if (substring (txt, 1, 7) = \'__repl \')\n"
"{\n"
"_off := strstr (lower (txt), \'create \');\n"
"txt := substring (txt, _off + 1, length (txt) - _off);\n"
"if (mtxt is null)\n"
"update DB.DBA.SYS_PROCEDURES set P_TEXT = txt where P_NAME = _item;\n"
"else\n"
"update DB.DBA.SYS_PROCEDURES set P_MORE = txt where P_NAME = _item;\n"
"__proc_changed (_item);\n"
"\n"
"}\n"
"\n"
"}\n"
"return 0;\n"
"}\n"
"--src repl.sql:26\n"
;

static const char *proc12 = 
"#line 105 \"[executable]/repl.sql\"\n"
"create procedure REPL_SERVER (in name varchar, in addr varchar, in repl_addr varchar)\n"
"{\n"
"if (not isstring (sys_stat (\'st_repl_server_enable\')))\n"
"{\n"
"signal (\'42000\',\n"
"\'This server is not enabled for replication.\n"
"You must set the ServerEnable INI option to 1 before defining any replication roles.\',\n"
"\'TR074\');\n"
"}\n"
"if (name = repl_this_server ())\n"
"return;\n"
"insert replacing DB.DBA.SYS_SERVERS (SERVER, DB_ADDRESS, REPL_ADDRESS)\n"
"values (name, addr, coalesce (repl_addr, addr));\n"
"repl_changed ();\n"
"log_text (\'repl_changed ()\');\n"
"}\n"
"--src repl.sql:103\n"
;

static const char *proc13 = 
"#line 123 \"[executable]/repl.sql\"\n"
"create procedure REPL_SYNC_USER (\n"
"in _srv varchar, in _acct varchar, in _sync_user varchar)\n"
"{\n"
"if (_sync_user = \'\' or _sync_user = \'dba\')\n"
"_sync_user := null;\n"
"update DB.DBA.SYS_REPL_ACCOUNTS set SYNC_USER = _sync_user\n"
"where SERVER = _srv and ACCOUNT = _acct;\n"
"repl_changed();\n"
"}\n"
"--src repl.sql:121\n"
;

static const char *proc14 = 
"#line 134 \"[executable]/repl.sql\"\n"
"create procedure REPL_PUBLISH (in _acct varchar, in log_path varchar, in _is_updatable integer := 0, in _sync_user varchar := null)\n"
"{\n"
"declare _nth integer;\n"
"declare acct varchar;\n"
"if (not isstring (sys_stat (\'st_repl_server_enable\')))\n"
"{\n"
"signal (\'42000\',\n"
"\'This server is not enabled for replication.\n"
"You must set the ServerEnable INI option to 1 before defining any replication roles.\',\n"
"\'TR073\');\n"
"}\n"
"\n"
"acct := SYS_ALFANUM_NAME (_acct);\n"
"if (repl_this_server () = \'anonymous\')\n"
"signal (\'37000\', \'Replication not enabled on this server\', \'TR002\');\n"
"if (exists (select 1 from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = repl_this_server () and ACCOUNT = acct))\n"
"return;\n"
"if (_sync_user = \'\' or _sync_user = \'dba\')\n"
"_sync_user := null;\n"
"_nth := coalesce ((select max (NTH) from DB.DBA.SYS_REPL_ACCOUNTS), 0);\n"
"insert into DB.DBA.SYS_REPL_ACCOUNTS (SERVER, ACCOUNT, NTH, IS_UPDATEABLE, SYNC_USER)\n"
"values (repl_this_server (), acct, _nth + 1, _is_updatable, _sync_user);\n"
"repl_changed ();\n"
"log_text (\'repl_changed ()\');\n"
"sequence_set (concat (\'repl_\', repl_this_server(), \'_\', acct), 0, 0);\n"
"repl_new_log (repl_this_server(), acct, log_path);\n"
"}\n"
"--src repl.sql:132\n"
;

static const char *proc15 = 
"#line 163 \"[executable]/repl.sql\"\n"
"create procedure REPL_UNPUBLISH (in _pub varchar)\n"
"{\n"
"declare pub varchar;\n"
"pub := SYS_ALFANUM_NAME (_pub);\n"
"if (not exists (select 1 from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = repl_this_server () and ACCOUNT = pub))\n"
"signal (\'37000\', concat (\'The publication \'\'\', pub ,\'\'\' does not exist\'), \'TR003\');\n"
"{\n"
"declare exit handler for sqlstate \'*\' goto cont;\n"
"repl_text (pub, \'REPL_UNSUBSCRIBE (?, ?, null)\', repl_this_server (), pub);\n"
"}\n"
"cont:\n"
"for select TI_ITEM as ti, TI_TYPE as tp from DB.DBA.SYS_TP_ITEM\n"
"where TI_SERVER = repl_this_server () and TI_ACCT = pub do\n"
"{\n"
"REPL_PUB_REMOVE (pub, ti, tp, null);\n"
"}\n"
"for select TPG_GRANTEE as grnt from DB.DBA.SYS_TP_GRANT where TPG_ACCT = pub do\n"
"{\n"
"REPL_REVOKE (pub, grnt);\n"
"}\n"
"delete from DB.DBA.SYS_REPL_ACCOUNTS  where SERVER = repl_this_server () and ACCOUNT = pub;\n"
"repl_changed ();\n"
"}\n"
"--src repl.sql:161\n"
;

static const char *proc16 = 
"#line 190 \"[executable]/repl.sql\"\n"
"create procedure REPL_UNSUBSCRIBE (in serv varchar, in _pub varchar, in _item varchar := null)\n"
"{\n"
"declare _path any;\n"
"declare _id, _tp integer;\n"
"declare _stat, _msg, pub varchar;\n"
"declare _is_updatable integer;\n"
"_is_updatable := REPL_IS_UPDATABLE(serv, _pub);\n"
"pub := SYS_ALFANUM_NAME (_pub);\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"\n"
"for select FK_NAME, FK_TABLE from SYS_FOREIGN_KEYS, DB.DBA.SYS_TP_ITEM ipk, DB.DBA.SYS_TP_ITEM ifk\n"
"where KEY_SEQ = 0 and\n"
"FK_TABLE = ifk.TI_ITEM and PK_TABLE = ipk.TI_ITEM and\n"
"ipk.TI_TYPE = 2 and ipk.TI_SERVER = serv and ipk.TI_ACCT = _pub and\n"
"ifk.TI_TYPE = 2 and ifk.TI_SERVER = serv and ifk.TI_ACCT = _pub and\n"
"(ifk.TI_IS_COPY = 1 or ipk.TI_IS_COPY = 1) do\n"
"{\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (sprintf (\'alter table \"%I\".\"%I\".\"%I\" drop constraint \"%I\"\',\n"
"name_part (FK_TABLE, 0), name_part (FK_TABLE, 1), name_part (FK_TABLE, 2),\n"
"FK_NAME), _stat, _msg);\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_TP_ITEM where TI_SERVER = serv and TI_ACCT = pub))\n"
"{\n"
"for select TI_ITEM as it, TI_TYPE as tp, TI_IS_COPY as md from DB.DBA.SYS_TP_ITEM\n"
"where TI_SERVER = serv and TI_ACCT = pub do\n"
"{\n"
"if (_item is null or _item = it)\n"
"_tp := tp;\n"
"else\n"
"_tp := 0;\n"
"\n"
"if (_tp = 1)\n"
"{\n"
"if (md = 1)\n"
"{\n"
"if (isstring (it)\n"
"and length (it) > 0\n"
"and aref (it, length (it) - 1) <> ascii (\'/\'))\n"
"it := concat (it, \'/\');\n"
"whenever not found goto endc;\n"
"select COL_ID into _id from WS.WS.SYS_DAV_COL where WS.WS.COL_PATH (COL_ID) = it;\n"
"delete from WS.WS.SYS_DAV_RES where RES_FULL_PATH like concat (it, \'%\');\n"
"DEL_CHILD_COLLS (_id);\n"
"delete from WS.WS.SYS_DAV_COL where COL_ID = _id;\n"
"endc:\n"
" ;\n"
"}\n"
"}\n"
"else if (_tp = 2)\n"
"{\n"
"if (md = 1)\n"
"{\n"
"commit work;\n"
"repl_set_raw(1);\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (sprintf (\'drop table %s\', REPL_FQNAME (it)),\n"
"_stat, _msg);\n"
"}\n"
"if (_is_updatable <> 0)\n"
"{\n"
"commit work;\n"
"repl_set_raw(1);\n"
"\n"
"declare _srv varchar;\n"
"_srv := REPL_DSN (serv);\n"
"if (_srv is not null)\n"
"{\n"
"declare src_table varchar;\n"
"src_table := att_local_name (_srv, it);\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"exec (sprintf (\'drop table %s\',\n"
"REPL_FQNAME (src_table)),\n"
"_stat, _msg);\n"
"}\n"
"}\n"
"}\n"
"else if (_tp = 3)\n"
"{\n"
"\n"
"if (md = 1)\n"
"{\n"
"exec (sprintf (\'drop procedure \"%s\"\', it) , _stat, _msg);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (_item is null)\n"
"{\n"
"delete from DB.DBA.SYS_TP_ITEM where TI_SERVER = serv and TI_ACCT = pub;\n"
"delete from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = serv and ACCOUNT = pub;\n"
"if (_is_updatable <> 0)\n"
"{\n"
"delete from DB.DBA.SYS_REPL_ACCOUNTS\n"
"where SERVER = serv and ACCOUNT = concat (\'!\', pub);\n"
"}\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = concat (\'repl_\', serv, \'_\', pub);\n"
"}\n"
"else\n"
"delete from DB.DBA.SYS_TP_ITEM where TI_SERVER = serv and TI_ACCT = pub and TI_ITEM = _item;\n"
"repl_changed ();\n"
"log_text (\'repl_changed ()\');\n"
"}\n"
"--src repl.sql:188\n"
;

static const char *proc17 = 
"#line 302 \"[executable]/repl.sql\"\n"
"create procedure DEL_CHILD_COLLS (in _id integer)\n"
"{\n"
"for select COL_ID as col from WS.WS.SYS_DAV_COL where COL_PARENT = _id do\n"
"{\n"
"DEL_CHILD_COLLS (col);\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_PARENT = _id;\n"
"return;\n"
"}\n"
"--src repl.sql:300\n"
;

static const char *proc18 = 
"#line 314 \"[executable]/repl.sql\"\n"
"create procedure REPL_SUBSCRIBE (in srv varchar, in _acct varchar,\n"
"in usr varchar, in grp varchar, in _usr varchar, in pwd varchar,\n"
"in _sync_user varchar := null)\n"
"{\n"
"declare _srv, _items, _stat, _msg, _addr, acct varchar;\n"
"declare _rrc any;\n"
"acct := SYS_ALFANUM_NAME (_acct);\n"
"if (srv = repl_this_server ())\n"
"signal (\'37000\', \'publication and subscription servers have identical names.\', \'TR005\');\n"
"if (exists (select 1 from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = srv and ACCOUNT = acct))\n"
"signal (\'37000\', concat (\'The subscription \'\'\', acct, \'\'\' from \'\'\', srv, \'\'\' already exists\'), \'TR007\');\n"
"\n"
"_srv := REPL_DSN (srv);\n"
"if (_srv is null)\n"
"{\n"
"signal (\'37000\', \'Publishing server must be declared with REPL_SERVER before subscribing\', \'TR006\');\n"
"}\n"
"if (REPL_ENSURE_RDS (_srv, _usr, pwd) <> 0)\n"
"{\n"
"signal (\'22023\', \'User name and password should be supplied when subscribe to new publisher\', \'TR008\');\n"
"}\n"
"if (_sync_user = \'\' or _sync_user = \'dba\')\n"
"_sync_user := null;\n"
"\n"
"_items := REPL_ENSURE_TABLE_ATTACHED (_srv, \'DB.DBA.SYS_REPL_ACCOUNTS\');\n"
"declare _nth integer;\n"
"declare _stmt varchar;\n"
"_nth := coalesce ((select max (NTH) from DB.DBA.SYS_REPL_ACCOUNTS), 0);\n"
"_stmt := sprintf (\'insert into DB.DBA.SYS_REPL_ACCOUNTS (SERVER, ACCOUNT, NTH, IS_UPDATEABLE, SYNC_USER) select ?, ?, ?, IS_UPDATEABLE, ? from %s where SERVER = ? and ACCOUNT = ?\',\n"
"REPL_FQNAME (_items));\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (_stmt, _stat, _msg, vector(srv, acct, _nth + 1, _sync_user, srv, acct)))\n"
"signal (_stat, _msg);\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"exec (\'REPL_UNSUBSCRIBE (?, ?, null)\', _stat, _msg, vector (srv, _acct));\n"
"resignal;\n"
"};\n"
"\n"
"declare _is_updatable integer;\n"
"_is_updatable := REPL_IS_UPDATABLE(srv, acct);\n"
"\n"
"if (_is_updatable <> 0)\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"_nth := coalesce ((select max (NTH) from DB.DBA.SYS_REPL_ACCOUNTS), 0);\n"
"if (0 <> exec (_stmt, _stat, _msg, vector(srv, concat (\'!\', acct), _nth + 1, null, srv, _acct)))\n"
"signal (_stat, _msg);\n"
"}\n"
"\n"
"_items := REPL_ENSURE_VIEW_ATTACHED (\n"
"_srv, \'DB.DBA.TP_ITEM\', vector (\'TI_ACCT\', \'TI_TYPE\', \'TI_ITEM\'));\n"
"_stmt := sprintf (\'insert into DB.DBA.SYS_TP_ITEM (TI_SERVER, TI_ACCT, TI_TYPE, TI_ITEM, TI_OPTIONS, TI_IS_COPY) select TI_SERVER, TI_ACCT, TI_TYPE, TI_ITEM, TI_OPTIONS, TI_IS_COPY from %s where TI_SERVER = ? and TI_ACCT = ?\',\n"
"REPL_FQNAME (_items));\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (_stmt, _stat, _msg, vector (srv, acct)))\n"
"signal (_stat, _msg);\n"
"\n"
"for select TI_TYPE as t, TI_ITEM as i, TI_OPTIONS as opt from DB.DBA.SYS_TP_ITEM\n"
"where TI_SERVER = srv and TI_ACCT = acct\n"
"do\n"
"{\n"
"if (t = 1)\n"
"{\n"
"if (WS.WS.ISCOL (WS.WS.HREF_TO_ARRAY (i, \'\')))\n"
"{\n"
"txn_error (6);\n"
"signal (\'37000\', concat (\'The WebDAV collection \'\'\', i, \'\'\' already exists\'), \'TR009\');\n"
"}\n"
"\n"
"update DB.DBA.SYS_TP_ITEM set TI_DAV_USER = usr, TI_DAV_GROUP = grp where\n"
"TI_SERVER = srv and TI_ACCT = acct and TI_ITEM = i and TI_TYPE = 1;\n"
"}\n"
"else if (t = 2)\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = i))\n"
"{\n"
"txn_error (6);\n"
"signal (\'37000\', concat (\'The table \'\'\' , i, \'\'\' already exists\'), \'TR010\');\n"
"}\n"
"REPL_SUBSCR_TBL (srv, acct, i, _is_updatable);\n"
"}\n"
"else if (t = 3)\n"
"{\n"
"\n"
" ;\n"
"}\n"
"else\n"
"{\n"
"txn_error (6);\n"
"signal (\'22023\', concat (\'The item type \'\'\' , cast (t as varchar), \'\'\'  not applicable\'), \'TR011\');\n"
"}\n"
"\n"
"}\n"
"for select TI_ITEM as tbl, DB_ADDRESS as dsn from DB.DBA.SYS_TP_ITEM, DB.DBA.SYS_SERVERS\n"
"where TI_SERVER = srv and TI_ACCT = acct and TI_TYPE = 2 and SERVER = srv do\n"
"{\n"
"REPL_SUBSCR_TBL_FKS (srv, acct, dsn, tbl);\n"
"}\n"
"\n"
"repl_changed ();\n"
"log_text (\'repl_changed ()\');\n"
"\n"
"if (_is_updatable <> 0)\n"
"{\n"
"sequence_set (concat (\'replback_\', srv, \'_\', acct), 0, 0);\n"
"sequence_set (concat (\'replbackpub_\', srv, \'_\', acct), 0, 0);\n"
"repl_new_log (srv, concat (\'!\', acct), \'\');\n"
"}\n"
"}\n"
"--src repl.sql:312\n"
;

static const char *proc19 = 
"#line 434 \"[executable]/repl.sql\"\n"
"create procedure REPL_SCHED_INIT ()\n"
"{\n"
"insert replacing DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_INTERVAL, SE_SQL)\n"
"values (\'SYNC_REPL\', now (), 1, \'SYNC_REPL ()\');\n"
"}\n"
"--src repl.sql:432\n"
;

static const char *proc20 = 
"#line 441 \"[executable]/repl.sql\"\n"
"create procedure SYNC_REPL ()\n"
"{\n"
"for select SERVER as sr, ACCOUNT as acct from DB.DBA.SYS_REPL_ACCOUNTS\n"
"where SERVER <> repl_this_server ()\n"
"and repl_is_pushback (SERVER, ACCOUNT) = 0 do\n"
"{\n"
"declare err, msg, usr, pwd varchar;\n"
"err := \'00000\'; msg := \'\';\n"
"whenever not found goto nxt;\n"
"select d.DS_UID, pwd_magic_calc (d.DS_UID, d.DS_PWD, 1) into usr, pwd\n"
"from DB.DBA.SYS_DATA_SOURCE d, DB.DBA.SYS_SERVERS s\n"
"where s.SERVER = sr and d.DS_DSN = s.DB_ADDRESS;\n"
"exec (\'repl_sync (?, ?, ?, ?)\', err, msg, vector (sr, acct, usr, pwd), 0);\n"
"nxt:\n"
" ;\n"
"}\n"
"}\n"
"--src repl.sql:439\n"
;

static const char *proc21 = 
"#line 460 \"[executable]/repl.sql\"\n"
"create procedure SUB_SCHEDULE (in srv varchar, in _acct varchar, in intl integer)\n"
"{\n"
"declare acct varchar;\n"
"acct := SYS_ALFANUM_NAME (_acct);\n"
"if (srv = repl_this_server ())\n"
"signal (\'37000\', \'Can\'\'t schedule local publication\', \'TR012\');\n"
"if (exists (select 1 from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = srv and ACCOUNT = acct))\n"
"{\n"
"if (intl > 0)\n"
"{\n"
"declare usr, pwd varchar;\n"
"\n"
"select d.DS_UID, pwd_magic_calc (d.DS_UID, d.DS_PWD, 1) into usr, pwd from DB.DBA.SYS_DATA_SOURCE d, DB.DBA.SYS_SERVERS s\n"
"where d.DS_DSN = s.DB_ADDRESS and s.SERVER = srv;\n"
"if (usr is not null and pwd is not null)\n"
"insert replacing DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_INTERVAL, SE_SQL)\n"
"values (concat (\'repl_\', srv, \'_\', acct), now (), intl,\n"
"concat (\'repl_sync (\'\'\', srv,\'\'\', \'\'\', acct,\'\'\', \'\'\', usr, \'\'\', \'\'\', pwd, \'\'\')\'));\n"
"else\n"
"signal (\'22023\', \'You should specify a valid user name and password for replication synchronization\', \'TR014\');\n"
"}\n"
"else\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = concat (\'repl_\', srv, \'_\', acct);\n"
"}\n"
"else\n"
"{\n"
"signal (\'37000\', concat (\'Replication account \'\'\', acct, \'\'\' from \'\'\', srv,\'\'\' does not exist\', \'TR015\'));\n"
"}\n"
"}\n"
"--src repl.sql:458\n"
;

static const char *proc22 = 
"#line 491 \"[executable]/repl.sql\"\n"
"create procedure REPL_STAT ()\n"
"{\n"
"declare status varchar;\n"
"declare level, stat integer;\n"
"{\n"
"declare server, account varchar;\n"
"result_names (server, account, level, stat);\n"
"}\n"
"status := vector (\'OFF\', \'SYNCING\', \'IN SYNC\', \'REMOTE DISCONNECTED\', \'DISCONNECTED\', \'TO DISCONNECT\');\n"
"for select SERVER, ACCOUNT from DB.DBA.SYS_REPL_ACCOUNTS do\n"
"{\n"
"repl_status (SERVER, ACCOUNT, level, stat);\n"
"result (SERVER, ACCOUNT, level, aref (status, stat));\n"
"}\n"
"}\n"
"--src repl.sql:489\n"
;

static const char *proc23 = 
"#line 508 \"[executable]/repl.sql\"\n"
"create procedure\n"
"REPL_GET_DAV_UID_GID (in dav_u varchar, in dav_g varchar, out dav_ui integer, out dav_gi integer)\n"
"{\n"
"dav_ui := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = dav_u), NULL);\n"
"dav_gi := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = dav_g), NULL);\n"
"return;\n"
"}\n"
"--src repl.sql:506\n"
;

static const char *proc24 = 
"#line 517 \"[executable]/repl.sql\"\n"
"create procedure REPL_PUB_INIT_IMAGE (in __pub varchar, in _file varchar, in _bytes_per_file integer)\n"
"{\n"
"declare _name, _parent, _stat, _msg, _pub varchar;\n"
"declare _id, _p_id, _n, _len, _x, _bpf, _nfile, _ix integer;\n"
"declare dav_ui, dav_gi integer;\n"
"declare dav_perms varchar;\n"
"_pub := SYS_ALFANUM_NAME (__pub);\n"
"if (_bytes_per_file > 0)\n"
"_bpf := _bytes_per_file;\n"
"else\n"
"_bpf := 1000000;\n"
"_nfile := 0;\n"
"\n"
"declare state, message varchar;\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_TP_ITEM where TI_ACCT = _pub and TI_SERVER = repl_this_server ()))\n"
"{\n"
"signal (\'37000\',\n"
"sprintf (\'The publication \'\'%s\'\' is empty\', _pub), \'TR016\');\n"
"}\n"
"\n"
"__atomic (1);\n"
"state := \'00000\';\n"
"message := \'\';\n"
"if (0 <> exec (\'checkpoint\', state, message))\n"
"{\n"
"__atomic (0);\n"
"signal (state, message);\n"
"}\n"
"\n"
"backup_prepare (_file);\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"backup_flush();\n"
"backup_close ();\n"
"__atomic (0);\n"
"resignal;\n"
"};\n"
"\n"
"\n"
"for select TI_ITEM as _item, TI_DAV_USER as dav_u, TI_DAV_GROUP as dav_g from DB.DBA.SYS_TP_ITEM where TI_ACCT = _pub and TI_SERVER = repl_this_server ()\n"
"and TI_TYPE = 1 do\n"
"{\n"
"if (not WS.WS.ISCOL (WS.WS.HREF_TO_ARRAY (_item, \'\')))\n"
"{\n"
"signal (\'37000\', concat (\'The WebDAV collection \'\'\', _item, \'\'\' does not exist.\'), \'TR018\');\n"
"}\n"
"\n"
"REPL_GET_DAV_UID_GID (dav_u, dav_g, dav_ui, dav_gi);\n"
"\n"
"_parent := WS.WS.PARENT_PATH (WS.WS.HREF_TO_ARRAY (_item, \'\'));\n"
"_ix := 0;\n"
"if (_parent is not null)\n"
"_ix := length (_parent);\n"
"while (_ix > 1)\n"
"{\n"
"WS.WS.FINDCOL (_parent, _id);\n"
"dav_perms := coalesce ((select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = _id), NULL);\n"
"log_text (\'DB.DBA.DAV_MKCOL (?, ?, ?, ?)\', WS.WS.COL_PATH (_id), dav_perms, dav_ui, dav_gi);\n"
"_parent := WS.WS.PARENT_PATH (_parent);\n"
"_ix := _ix - 1;\n"
"}\n"
"\n"
"WS.WS.FINDCOL (WS.WS.HREF_TO_ARRAY (_item, \'\'), _id);\n"
"select count (*) into _n from WS.WS.SYS_DAV_COL where COL_ID = _id;\n"
"dav_perms := coalesce ((select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = _id), NULL);\n"
"log_text (\'DB.DBA.DAV_MKCOL (?, ?, ?, ?)\', WS.WS.COL_PATH (_id), dav_perms, dav_ui, dav_gi);\n"
"if (_n < 1)\n"
"{\n"
"signal (\'37000\', concat (\'The DAV collection \'\'\', _item, \'\'\' must added before checkpoint.\'), \'TR019\');\n"
"}\n"
"backup_flush ();\n"
"BACKUP_CHILDREN_COL (_id, dav_ui, dav_gi);\n"
"declare respath, colpath, resname varchar;\n"
"declare rr cursor for select RES_ID, RES_FULL_PATH, RES_NAME from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH like concat (_item,\'%\')  order by RES_ID;\n"
"whenever not found goto nfr;\n"
"open rr (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch rr into _n, respath, resname;\n"
"colpath := substring (respath, 1, length (respath) - length (resname));\n"
"select log_text (\'insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_OWNER, RES_GROUP, RES_COL,\n"
"RES_CONTENT, RES_TYPE, RES_CR_TIME, RES_MOD_TIME, RES_PERMS, RES_FULL_PATH) values\n"
"(WS.WS.GETID (\'\'R\'\'), ?, ?, ?, (select COL_ID from WS.WS.SYS_DAV_COL where WS.WS.COL_PATH (COL_ID) = ?),\n"
"?, ?, ?, ?, ?, ?)\',\n"
"RES_NAME, RES_OWNER, RES_GROUP, colpath,\n"
"blob_to_string (RES_CONTENT), RES_TYPE, RES_CR_TIME, RES_MOD_TIME, RES_PERMS, RES_FULL_PATH) into _x\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = _n;\n"
"backup_flush (_len);\n"
"if (_len > _bpf)\n"
"{\n"
"backup_close ();\n"
"_nfile := _nfile + 1;\n"
"commit work;\n"
"backup_prepare (concat (_file,\'.\',cast (_nfile as varchar)));\n"
"}\n"
"}\n"
"nfr:\n"
"close rr;\n"
"}\n"
"for select TI_ITEM as _item, TI_TYPE as tp from DB.DBA.SYS_TP_ITEM\n"
"where TI_ACCT = _pub and TI_SERVER = repl_this_server () and TI_TYPE <> 1 do\n"
"{\n"
"if (tp = 2)\n"
"{\n"
"declare qr, qr1 varchar;\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"declare _cols, _col any;\n"
"declare __ix, __len integer;\n"
"declare _all_cols, _qm, _col_name varchar;\n"
"_cols := REPL_ALL_COLS (_item);\n"
"__ix := 0;\n"
"__len := length (_cols);\n"
"_all_cols := \'\';\n"
"_qm := \'\';\n"
"while (__ix < __len)\n"
"{\n"
"_col := aref (_cols, __ix);\n"
"_col_name := aref (_col, 0);\n"
"\n"
"_all_cols := concat (_all_cols, sprintf (\'\"%I\"\', _col_name));\n"
"_qm := concat (_qm, \'?\');\n"
"if (__ix + 1 < __len)\n"
"{\n"
"_all_cols := concat (_all_cols, \', \');\n"
"_qm := concat (_qm, \', \');\n"
"}\n"
"__ix := __ix + 1;\n"
"}\n"
"qr  := concat (\'insert replacing \', REPL_FQNAME (_item), \' (\', _all_cols, \') values (\', _qm, \')\');\n"
"qr1 := concat (\'declare t cursor for select log_text (\'\'\', qr, \'\'\', \', _all_cols, \') from \', REPL_FQNAME (_item));\n"
"declare _stmt varchar;\n"
"_stmt := concat (\'create procedure REPL_TBL_BKP (in _f varchar, inout _fc integer, inout _cn integer)\n"
"{\n"
"declare n, c integer;\', qr1, \';\n"
"c := 0;\n"
"whenever not found goto nf;\n"
"open t (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch t into n;\n"
"backup_flush (c);\n"
"if (c > _cn)\n"
"{\n"
"\n"
"backup_close ();\n"
"commit work;\n"
"_fc := _fc + 1;\n"
"backup_prepare (concat (_f, \'\'.\'\', cast (_fc as varchar)));\n"
"}\n"
"}\n"
"nf:\n"
"close t;\n"
"}\');\n"
"\n"
"log_enable (0);\n"
"if (0 <> exec (_stmt, _stat, _msg))\n"
"signal (_stat, _msg);\n"
"\n"
"log_enable (1);\n"
"REPL_TBL_BKP (_file, _nfile, _bpf);\n"
"log_enable (0);\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (\'drop procedure REPL_TBL_BKP\', _stat, _msg);\n"
"log_enable (1);\n"
"backup_flush ();\n"
"}\n"
"else if (tp = 3)\n"
"{\n"
"declare _proc varchar;\n"
"declare _idx integer;\n"
"\n"
"select (coalesce (P_TEXT, blob_to_string (P_MORE))) into _proc\n"
"from SYS_PROCEDURES where P_NAME = _item;\n"
"if (substring (_proc, 1, 6) = \'__repl\')\n"
"{\n"
"_idx := strstr (lower (_proc), \' create procedure \');\n"
"if (_idx is not null)\n"
"{\n"
"_proc := substring (_proc, _idx + 2, length (_proc) - _idx - 1);\n"
"\n"
"}\n"
"}\n"
"log_text (_proc);\n"
"backup_flush ();\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare last_seq varchar;\n"
"declare seq_f, comma1, comma2, seq integer;\n"
"seq := 0;\n"
"last_seq := registry_get (concat (\'repl_\', repl_this_server (), \'_\', _pub));\n"
"if (isstring (last_seq))\n"
"{\n"
"seq_f := strstr (last_seq, \'sequence_set\');\n"
"if (seq_f is not null)\n"
"{\n"
"comma1 := strchr (last_seq, \',\') + 2;\n"
"comma2 := strrchr (last_seq, \',\') + 1;\n"
"if (comma1 is not null and comma2 is not null)\n"
"seq := cast (substring (last_seq, comma1, comma2 - comma1) as integer);\n"
"}\n"
"}\n"
"\n"
"log_text (\'sequence_set (?, ?, ?)\', concat (\'repl_\', repl_this_server (), \'_\', _pub), seq, 1);\n"
"backup_flush ();\n"
"backup_close ();\n"
"__atomic (0);\n"
"}\n"
"--src repl.sql:515\n"
;

static const char *proc25 = 
"#line 736 \"[executable]/repl.sql\"\n"
"create procedure BACKUP_CHILDREN_COL (in _c_id integer, in dav_u integer, in dav_g integer)\n"
"{\n"
"declare _id, _p_id, _n, _len, _x integer;\n"
"declare dav_perms varchar;\n"
"_id := _c_id;\n"
"\n"
"declare cc cursor for select COL_ID, COL_PERMS from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = _id order by COL_ID;\n"
"whenever not found goto nfc;\n"
"open cc (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch cc into _n, dav_perms;\n"
"\n"
"log_text (\'DB.DBA.DAV_MKCOL (?, ?, ?, ?)\', WS.WS.COL_PATH (_n), dav_perms, dav_u, dav_g);\n"
"backup_flush ();\n"
"BACKUP_CHILDREN_COL (_n, dav_u, dav_g);\n"
"}\n"
"nfc:\n"
"close cc;\n"
"backup_flush ();\n"
"return;\n"
"}\n"
"--src repl.sql:734\n"
;

static const char *proc26 = 
"#line 761 \"[executable]/repl.sql\"\n"
"create procedure\n"
"REPL_DAV_GET_USER_GROUP (in own varchar, in grp varchar,\n"
"in __own varchar, in __grp varchar,\n"
"out _own integer, out _grp integer)\n"
"{\n"
"if (own is null)\n"
"_own := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = __own), NULL);\n"
"else\n"
"_own := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = own), NULL);\n"
"\n"
"if (grp is null)\n"
"_grp := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = __grp), NULL);\n"
"else\n"
"_grp := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = grp), NULL);\n"
"\n"
"if (_grp is null and __grp <> \'\' and own is null)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"_grp := NULL;\n"
"goto usr_get;\n"
"};\n"
"_grp := DAV_ADD_GROUP_INT (__grp);\n"
"if (_grp < 0)\n"
"_grp := NULL;\n"
"}\n"
"\n"
"usr_get:\n"
"\n"
"if (_own is null and __own <> \'\' and grp is null)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"_own := NULL;\n"
"goto end_get;;\n"
"};\n"
"_own := DAV_ADD_USER_INT (__own, __own, __grp, \'110110110R\', 1, NULL, \'REPLICATION\', NULL);\n"
"if (_own < 0)\n"
"_own := NULL;\n"
"}\n"
"end_get:\n"
"return;\n"
"}\n"
"--src repl.sql:759\n"
;

static const char *proc27 = 
"#line 808 \"[executable]/repl.sql\"\n"
"create procedure DAV_COL_I (in _name varchar, in _path varchar, in _cr_time datetime,\n"
"in __own varchar, in __grp varchar, in _perms varchar)\n"
"{\n"
"declare _p_id, _p_path any;\n"
"declare _own, _grp integer;\n"
"\n"
"if (not isstring (_path) and __tag (_path) <> __tag of vector)\n"
"signal (\'22023\', \'Function DAV_COL_I needs string or array as path\', \'TR020\');\n"
"\n"
"if (isstring (_path))\n"
"_p_path := WS.WS.HREF_TO_ARRAY (_path, \'\');\n"
"else\n"
"_p_path := _path;\n"
"\n"
"_p_path := WS.WS.PARENT_PATH (_p_path);\n"
"if (length (_p_path) < 1)\n"
"signal (\'22023\', \'The first parameter is not valid path string\', \'TR021\');\n"
"WS.WS.FINDCOL (_p_path, _p_id);\n"
"if (not WS.WS.ISCOL (_p_path))\n"
"signal (\'37000\', \'Non-existing collection\', \'TR022\');\n"
"\n"
"declare own, grp varchar;\n"
"select TI_DAV_USER, TI_DAV_GROUP into own, grp from DB.DBA.SYS_TP_ITEM where\n"
"TI_TYPE = 1 and TI_ITEM = substring (_path, 1, length (TI_ITEM));\n"
"\n"
"REPL_DAV_GET_USER_GROUP (own, grp, __own, __grp, _own, _grp);\n"
"\n"
"insert into WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_OWNER, COL_GROUP,\n"
"COL_CR_TIME, COL_MOD_TIME, COL_PERMS)\n"
"values (WS.WS.GETID (\'C\'), _name, _p_id, _own, _grp, _cr_time, _cr_time, _perms);\n"
"return;\n"
"}\n"
"--src repl.sql:806\n"
;

static const char *proc28 = 
"#line 843 \"[executable]/repl.sql\"\n"
"create procedure DAV_COL_U (in _old_path varchar, in _new_path varchar, in _mod_time datetime,\n"
"in __own varchar, in __grp varchar, in _perms varchar)\n"
"{\n"
"declare _id, _p_id integer;\n"
"declare _path, _n_path any;\n"
"declare _name varchar;\n"
"declare _oown, _ogrp integer;\n"
"declare _operms varchar;\n"
"declare _own, _grp integer;\n"
"\n"
"\n"
"if (not isstring (_old_path) or not isstring (_new_path))\n"
"signal (\'22023\', \'Function DAV_COL_U needs strings as paths\', \'TR023\');\n"
"_n_path := WS.WS.HREF_TO_ARRAY (_new_path, \'\');\n"
"if (length (_n_path) < 1)\n"
"signal (\'22023\', \'The second parameter is not valid path string\', \'TR024\');\n"
"_path := WS.WS.HREF_TO_ARRAY (_old_path, \'\');\n"
"if (length (_path) < 1)\n"
"signal (\'22023\', \'The first parameter is not valid path string\', \'TR025\');\n"
"_name := aref (_n_path, length (_n_path) - 1);\n"
"WS.WS.FINDCOL (_path, _id);\n"
"if (not WS.WS.ISCOL (_path))\n"
"signal (\'37000\', \'Non-existing collection\', \'TR026\');\n"
"WS.WS.FINDCOL (WS.WS.PARENT_PATH (_n_path), _p_id);\n"
"if (not WS.WS.ISCOL (WS.WS.PARENT_PATH (_n_path)))\n"
"signal (\'37000\', \'Non-existing parent collection\', \'TR027\');\n"
"\n"
"declare own, grp varchar;\n"
"select TI_DAV_USER, TI_DAV_GROUP into own, grp from DB.DBA.SYS_TP_ITEM where\n"
"TI_TYPE = 1 and TI_ITEM = substring (_new_path, 1, length (TI_ITEM));\n"
"\n"
"REPL_DAV_GET_USER_GROUP (own, grp, __own, __grp, _own, _grp);\n"
"\n"
"select COL_OWNER, COL_GROUP, COL_PERMS into _oown, _ogrp, _operms from WS.WS.SYS_DAV_COL where COL_ID = _id;\n"
"update WS.WS.SYS_DAV_COL set COL_NAME = _name, COL_PARENT = _p_id, COL_OWNER = coalesce (_own, _oown),\n"
"COL_GROUP = coalesce (_grp, _ogrp), COL_MOD_TIME = _mod_time, COL_PERMS = coalesce (_perms, _operms)\n"
"where COL_ID = _id;\n"
"return;\n"
"}\n"
"--src repl.sql:841\n"
;

static const char *proc29 = 
"#line 886 \"[executable]/repl.sql\"\n"
"create procedure DAV_COL_D (in _ppath varchar, in _ch integer)\n"
"{\n"
"declare _id integer;\n"
"declare _path any;\n"
"\n"
"if (not isstring (_ppath))\n"
"signal (\'22023\', \'Function DAV_COL_D needs string as path\', \'TR028\');\n"
"_path := WS.WS.HREF_TO_ARRAY (_ppath, \'\');\n"
"if (length (_path) < 1)\n"
"signal (\'22023\', \'The first parameter is not valid path string\', \'TR029\');\n"
"WS.WS.FINDCOL (_path, _id);\n"
"if (not WS.WS.ISCOL (_path))\n"
"signal (\'37000\', \'Non-existing collection\', \'TR030\');\n"
"if (_ch = 1)\n"
"{\n"
"delete from WS.WS.SYS_DAV_RES where RES_FULL_PATH like concat (_ppath, \'%\');\n"
"DEL_CHILD_COLLS (_id);\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_ID = _id;\n"
"return;\n"
"}\n"
"--src repl.sql:884\n"
;

static const char *proc30 = 
"#line 911 \"[executable]/repl.sql\"\n"
"create procedure DAV_RES_I (in _ppath varchar, in _time datetime, in __own varchar, in __grp varchar,\n"
"in _perms varchar, in _type varchar, in _content any)\n"
"{\n"
"declare _c_id integer;\n"
"declare _name varchar;\n"
"declare _path, _ses any;\n"
"declare _ix, _len integer;\n"
"declare _own, _grp integer;\n"
"\n"
"if (isstring (_content))\n"
"_ses := _content;\n"
"else if (__tag (_content) = __tag of vector)\n"
"{\n"
"_len := length (_content);\n"
"_ses := string_output ();\n"
"_ix := 0;\n"
"while (_ix < _len)\n"
"{\n"
"http (aref (_content, _ix), _ses);\n"
"_ix := _ix + 1;\n"
"}\n"
"}\n"
"else\n"
"_ses := null;\n"
"\n"
"\n"
"if (not isstring (_ppath) and __tag (_ppath) <> __tag of vector)\n"
"signal (\'22023\', \'Function DAV_RES_I needs string or array as path\', \'TR031\');\n"
"if (isstring (_ppath))\n"
"_path := WS.WS.HREF_TO_ARRAY (_ppath, \'\');\n"
"else\n"
"_path := _ppath;\n"
"if (length (_path) < 1)\n"
"signal (\'22023\', \'The first parameter is not valid path string\', \'TR032\');\n"
"WS.WS.FINDCOL (WS.WS.PARENT_PATH (_path), _c_id);\n"
"if (not WS.WS.ISCOL (WS.WS.PARENT_PATH (_path)))\n"
"signal (\'37000\', \'Non-existing collection\', \'TR033\');\n"
"_name := aref (_path, length (_path) - 1);\n"
"\n"
"declare own, grp varchar;\n"
"select TI_DAV_USER, TI_DAV_GROUP into own, grp from DB.DBA.SYS_TP_ITEM where\n"
"TI_TYPE = 1 and TI_ITEM = substring (_ppath, 1, length (TI_ITEM));\n"
"\n"
"REPL_DAV_GET_USER_GROUP (own, grp, __own, __grp, _own, _grp);\n"
"\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_CR_TIME, RES_MOD_TIME,\n"
"RES_OWNER, RES_GROUP, RES_PERMS, RES_TYPE, RES_CONTENT, RES_FULL_PATH, RES_COL)\n"
"values (WS.WS.GETID (\'R\'), _name, _time, _time, _own, _grp, _perms, _type, _ses, _ppath, _c_id);\n"
"return;\n"
"}\n"
"--src repl.sql:909\n"
;

static const char *proc31 = 
"#line 965 \"[executable]/repl.sql\"\n"
"create procedure DAV_RES_D (in _ppath varchar)\n"
"{\n"
"declare _id integer;\n"
"declare _path any;\n"
"declare _name varchar;\n"
"\n"
"if (not isstring (_ppath))\n"
"signal (\'22023\', \'Function DAV_RES_D needs string as path\', \'TR034\');\n"
"_path := WS.WS.HREF_TO_ARRAY (_ppath, \'\');\n"
"if (length (_path) < 1)\n"
"signal (\'22023\', \'The first parameter is not valid path string\', \'TR035\');\n"
"WS.WS.FINDRES (_path, _id, _name);\n"
"if (not WS.WS.ISRES (_path))\n"
"signal (\'37000\', \'Non-existing resource\', \'TR036\');\n"
"delete from WS.WS.SYS_DAV_RES where RES_COL = _id and RES_NAME = _name;\n"
"return;\n"
"}\n"
"--src repl.sql:963\n"
;

static const char *proc32 = 
"#line 984 \"[executable]/repl.sql\"\n"
"create procedure REPL_PUB_ADD_CHECK_PROC (in _P_NAME varchar, in _pub varchar)\n"
"{\n"
"declare pars any;\n"
"declare _par_inx integer;\n"
"pars := procedure_cols (_P_NAME);\n"
"\n"
"_par_inx := 1;\n"
"if (not isarray (pars))\n"
"return;\n"
"\n"
"foreach (any par in pars) do\n"
"{\n"
"declare _par_inout_type integer;\n"
"declare _par_name varchar;\n"
"_par_inout_type := cast (par[4] as integer);\n"
"_par_name := cast (par[3] as varchar);\n"
"if (_par_inout_type in (2, 4))\n"
"signal (\'42000\',\n"
"sprintf (\n"
"\'Procedure %s cannot be published for transactional replication \' ||\n"
"\'(in publication %s) because it has out/inout parameter %s (parameter number %d). \',\n"
"_P_NAME,\n"
"_pub,\n"
"_par_name,\n"
"_par_inx),\n"
"\'SQ207\');\n"
"_par_inx := _par_inx + 1;\n"
"}\n"
"}\n"
"--src repl.sql:982\n"
;

static const char *proc33 = 
"#line 1017 \"[executable]/repl.sql\"\n"
"create procedure REPL_PUB_ADD (in __pub varchar, in _item varchar, in _type integer,\n"
"in _mode integer, in _opt integer)\n"
"{\n"
"declare _pub varchar;\n"
"_pub := SYS_ALFANUM_NAME (__pub);\n"
"\n"
"declare _is_updatable integer;\n"
"_is_updatable := REPL_IS_UPDATABLE (repl_this_server (), __pub);\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_TP_ITEM where TI_SERVER = repl_this_server () and TI_ACCT = _pub\n"
"and TI_ITEM = _item and TI_TYPE = _type))\n"
"signal (\'37000\', concat (\'Item \'\'\', _item, \'\'\' already exists in publication \'\'\' , _pub, \'\'\'\'), \'TR038\');\n"
"if (_type = 1)\n"
"{\n"
"\n"
"if (not WS.WS.ISCOL (WS.WS.HREF_TO_ARRAY( _item, \'\')) or _item not like \'/DAV%\')\n"
"signal (\'37000\', concat (\'The WebDAV collection \'\'\' , _item, \'\'\' does not exist\'), \'TR039\');\n"
"}\n"
"else if (_type = 2)\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = _item))\n"
"signal (\'37000\', concat (\'The table \'\'\' , _item, \'\'\' does not exist\'), \'TR040\');\n"
"REPL_PUB_TBL (__pub, _item, _is_updatable);\n"
"}\n"
"else if (_type = 3)\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_PROCEDURES where P_NAME = _item))\n"
"signal (\'37000\', concat (\'The procedure \'\'\' , _item, \'\'\' does not exist\'), \'TR041\');\n"
"if (exists (select 1 from DB.DBA.SYS_TP_ITEM where TI_ITEM = _item and\n"
"TI_SERVER = repl_this_server () and TI_TYPE =  3 and TI_OPTIONS = 1) and _opt = 1)\n"
"signal (\'37000\', concat (\'The procedures calls to \'\'\' , _item,\n"
"\'\'\' can not be replicated to more than one publication\'), \'TR042\');\n"
"if (_opt = 1 or _opt = 3)\n"
"{\n"
"REPL_PUB_ADD_CHECK_PROC (_item, _pub);\n"
"declare text, more varchar;\n"
"select P_TEXT, blob_to_string (P_MORE) into text, more from DB.DBA.SYS_PROCEDURES\n"
"where P_NAME = _item;\n"
"if (more is null)\n"
"text := concat (\'__repl \', _pub, \' \', text);\n"
"else\n"
"more := concat (\'__repl \', _pub, \' \', more);\n"
"\n"
"update DB.DBA.SYS_PROCEDURES set P_TEXT = text, P_MORE = more where P_NAME = _item;\n"
"__proc_changed (_item);\n"
"}\n"
"}\n"
"else\n"
"signal (\'22023\', concat (\'The item type \'\'\' , cast (_type as varchar), \'\'\'  not applicable\'), \'TR043\');\n"
"insert into DB.DBA.SYS_TP_ITEM (TI_SERVER, TI_ACCT, TI_TYPE, TI_ITEM, TI_OPTIONS, TI_IS_COPY)\n"
"values (repl_this_server (), _pub, _type, _item, _opt, _mode);\n"
"repl_text (_pub, \'\"DB.DBA.REPL_SUB_ITEM\" (?,?,?,?,?,?)\', repl_this_server (), _pub, _item, _type, _opt, _mode);\n"
"\n"
"return 0;\n"
"}\n"
"--src repl.sql:1015\n"
;

static const char *proc34 = 
"#line 1074 \"[executable]/repl.sql\"\n"
"create procedure REPL_PROC_MODE (in __acct varchar, in _item varchar, in _mode integer)\n"
"{\n"
"declare _mod integer;\n"
"declare _acct varchar;\n"
"_acct := SYS_ALFANUM_NAME (__acct);\n"
"_mod := coalesce ((select TI_OPTIONS from DB.DBA.SYS_TP_ITEM where TI_SERVER = repl_this_server () and\n"
"TI_ACCT = _acct and TI_ITEM = _item), 0);\n"
"if (_mod = _mode)\n"
"return 0;\n"
"if (_mode = 1 or _mode = 3)\n"
"{\n"
"declare text, more varchar;\n"
"select P_TEXT, blob_to_string (P_MORE) into text, more from DB.DBA.SYS_PROCEDURES\n"
"where P_NAME = _item;\n"
"if (more is null)\n"
"{\n"
"if (substring (text, 1, 6) <> \'__repl\')\n"
"text := concat (\'__repl \', _acct, \' \', text);\n"
"}\n"
"else\n"
"{\n"
"if (substring (more, 1, 6) <> \'__repl\')\n"
"more := concat (\'__repl \', _acct, \' \', more);\n"
"}\n"
"\n"
"update DB.DBA.SYS_PROCEDURES set P_TEXT = text, P_MORE = more where P_NAME = _item;\n"
"__proc_changed (_item);\n"
"return 1;\n"
"}\n"
"else if (_mode = 2)\n"
"{\n"
"declare txt, ptxt, mtxt varchar;\n"
"declare _off integer;\n"
"select P_TEXT, blob_to_string (P_MORE) into ptxt, mtxt from DB.DBA.SYS_PROCEDURES where P_NAME = _item;\n"
"txt := coalesce (ptxt, mtxt);\n"
"if (substring (txt, 1, 7) = \'__repl \')\n"
"{\n"
"_off := strstr (lower (txt), \'create \');\n"
"txt := substring (txt, _off + 1, length (txt) - _off);\n"
"if (mtxt is null)\n"
"update DB.DBA.SYS_PROCEDURES set P_TEXT = txt where P_NAME = _item;\n"
"else\n"
"update DB.DBA.SYS_PROCEDURES set P_MORE = txt where P_NAME = _item;\n"
"__proc_changed (_item);\n"
"}\n"
"return 2;\n"
"}\n"
"return 0;\n"
"}\n"
"--src repl.sql:1072\n"
;

static const char *proc35 = 
"#line 1126 \"[executable]/repl.sql\"\n"
"create procedure REPL_PUB_TBL (in _pub varchar, in tbl varchar, in _is_updatable integer)\n"
"{\n"
"declare state, message, stmt  varchar;\n"
"declare src_table varchar;\n"
"declare source_query varchar;\n"
"declare pub varchar;\n"
"declare _col any;\n"
"declare _col_name varchar;\n"
"declare _col_dtp integer;\n"
"pub := SYS_ALFANUM_NAME (_pub);\n"
"src_table := complete_table_name(tbl, 1);\n"
"\n"
"if (_is_updatable <> 0)\n"
"REPL_ENSURE_ROWGUID (src_table, 255, 0);\n"
"\n"
"declare _pk_cols any;\n"
"declare _ix, _len integer;\n"
"declare _cr_pkcond, _cr_oldpkcond, _opk, _pk_cond, _npk_cond varchar;\n"
"_pk_cols := REPL_PK_COLS (src_table);\n"
"_ix := 0;\n"
"_len := length (_pk_cols);\n"
"_cr_pkcond := \'\';\n"
"_cr_oldpkcond := \'\';\n"
"_pk_cond := \'\';\n"
"_opk := \'\';\n"
"_npk_cond := \'\';\n"
"\n"
"if (_len = 0)\n"
"{\n"
"if (_is_updatable <> 0)\n"
"{\n"
"signal (\'22023\',\n"
"sprintf (\'The table \'\'%s\'\' does not have primary key\', src_table),\n"
"\'TR127\');\n"
"}\n"
"_pk_cols := vector (vector (\'_IDN\', __tag of varchar, NULL, 10));\n"
"_len := length (_pk_cols);\n"
"}\n"
"while (_ix < _len)\n"
"{\n"
"_col := aref (_pk_cols, _ix);\n"
"_col_name := aref (_col, 0);\n"
"_col_dtp := aref (_col, 1);\n"
"if (_col_dtp = 128 and _is_updatable <> 0)\n"
"{\n"
"signal (\'22023\',\n"
"sprintf (\'The table \'\'%s\'\' can not be added to updatable publication because primary key column \'\'%s\'\' has \'\'timestamp\'\' datatype\',\n"
"src_table, _col_name),\n"
"\'TR145\');\n"
"}\n"
"\n"
"_cr_pkcond := concat (_cr_pkcond,\n"
"sprintf (\'\"%I\" = \"_%I\"\', _col_name, _col_name));\n"
"_cr_oldpkcond := concat (_cr_oldpkcond,\n"
"sprintf (\'\"%I\" = \"__old_%I\"\', _col_name, _col_name));\n"
"_pk_cond := concat (_pk_cond, sprintf (\'\"%I\" = ?\', _col_name));\n"
"_opk := concat (_opk, sprintf (\'_O.\"%I\"\', _col_name));\n"
"_npk_cond := concat (_npk_cond,\n"
"sprintf(\'\"%I\" = _N.\"%I\"\', _col_name, _col_name));\n"
"if (_ix + 1 < _len)\n"
"{\n"
"_cr_pkcond := concat (_cr_pkcond, \' AND \');\n"
"_cr_oldpkcond := concat (_cr_oldpkcond, \' AND \');\n"
"_pk_cond := concat (_pk_cond, \' and \');\n"
"_opk := concat (_opk, \', \');\n"
"_npk_cond := concat (_npk_cond, \' and \');\n"
"}\n"
"_ix := _ix + 1;\n"
"}\n"
"\n"
"declare _cols any;\n"
"declare _all_cols, _nall_cols, _qm, _set_cols varchar;\n"
"declare _cr_all_cols, _cr_p, _cr_allp, _cr_oldp, _cr_alloldp varchar;\n"
"\n"
"_cols := REPL_ALL_COLS (src_table);\n"
"_ix := 0;\n"
"_len := length (_cols);\n"
"_all_cols := \'\';\n"
"_nall_cols := \'\';\n"
"_qm := \'\';\n"
"_set_cols := \'\';\n"
"\n"
"_cr_all_cols := \'\';\n"
"_cr_p := \'\';\n"
"_cr_allp := \'\';\n"
"_cr_oldp := \'\';\n"
"_cr_alloldp := \'\';\n"
"\n"
"while (_ix < _len)\n"
"{\n"
"_col := aref (_cols, _ix);\n"
"_col_name := aref (_col, 0);\n"
"_col_dtp := aref (_col, 1);\n"
"\n"
"_all_cols:= concat (_all_cols, sprintf (\'\"%I\"\', _col_name));\n"
"if (_col_dtp in (125, 131, 132, 134,\n"
"__tag of long varchar handle, __tag of long nvarchar handle, 135))\n"
"_nall_cols:= concat (_nall_cols, sprintf (\'blob_to_string_output (_N.\"%I\")\', _col_name));\n"
"else\n"
"_nall_cols:= concat (_nall_cols, sprintf (\'_N.\"%I\"\', _col_name));\n"
"_qm := concat (_qm, \'?\');\n"
"_set_cols := concat (_set_cols, sprintf (\'\"%I\" = ?\', _col_name));\n"
"if (_col_dtp <> 128)\n"
"{\n"
"_cr_all_cols:= concat (_cr_all_cols, sprintf (\'\"%I\"\', _col_name));\n"
"_cr_p := concat (_cr_p,\n"
"sprintf (\'inout \"_%I\" \', _col_name), REPL_COLTYPE (_col));\n"
"_cr_oldp := concat (_cr_oldp,\n"
"sprintf (\'inout \"__old_%I\" \', _col_name), REPL_COLTYPE (_col));\n"
"_cr_allp := concat (_cr_allp, sprintf (\'\"_%I\"\', _col_name));\n"
"_cr_alloldp := concat (_cr_alloldp,\n"
"sprintf (\'\"__old_%I\"\', _col_name));\n"
"}\n"
"if (_ix + 1 < _len)\n"
"{\n"
"_all_cols := concat (_all_cols, \', \');\n"
"_nall_cols := concat (_nall_cols, \', \');\n"
"_set_cols := concat (_set_cols, \', \');\n"
"_qm := concat (_qm, \', \');\n"
"if (_col_dtp <> 128)\n"
"{\n"
"_cr_all_cols := concat (_cr_all_cols, \', \');\n"
"_cr_p := concat (_cr_p, \', \');\n"
"_cr_oldp := concat (_cr_oldp, \', \');\n"
"_cr_allp:= concat (_cr_allp, \', \');\n"
"_cr_alloldp:= concat (_cr_alloldp, \', \');\n"
"}\n"
"}\n"
"_ix := _ix + 1;\n"
"}\n"
"\n"
"\n"
"declare _trg varchar;\n"
"_trg := sprintf (\'create trigger \"repl_%I_I\" after insert on %s order 199 referencing new as _N\\n{\\n\',\n"
"replace (src_table, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"if (_is_updatable <> 0)\n"
"{\n"
"_trg := concat (_trg, sprintf (\'if (repl_is_raw() = 0) { _N.ROWGUID := uuid(); set triggers off; update %s set ROWGUID = _N.ROWGUID where %s; }\\n\', REPL_FQNAME (tbl), _npk_cond));\n"
"}\n"
"_trg := concat (_trg, sprintf (\'repl_text (\'\'%s\'\', \'\'insert replacing %s (%s) values (%s)\'\', %s);\\n\',\n"
"pub, REPL_FQNAME (tbl), _all_cols, _qm, _nall_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_U\" after update on %s\\n order 199 referencing old as _O, new as _N\\n{\\n\',\n"
"replace (src_table, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"if (_is_updatable <> 0)\n"
"{\n"
"_trg := concat (_trg, sprintf (\'if (repl_is_raw() = 0) { _N.ROWGUID := uuid(); set triggers off; update %s set ROWGUID = _N.ROWGUID where %s; }\\n\', REPL_FQNAME (tbl), _npk_cond));\n"
"}\n"
"_trg := concat (_trg, sprintf (\'repl_text (\'\'%s\'\', \'\'update %s set %s where %s\'\', %s, %s);\\n\',\n"
"pub, REPL_FQNAME (tbl), _set_cols, _pk_cond, _nall_cols, _opk));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_D\" after delete on %s order 199 referencing old as _O\\n{\\n\',\n"
"replace (src_table, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, sprintf (\'repl_text (\'\'%s\'\', \'\'delete from %s where %s\'\', %s);\\n\',\n"
"pub, REPL_FQNAME (tbl),  _pk_cond, _opk));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"if (_is_updatable <> 0)\n"
"{\n"
"declare _cmds any;\n"
"_cmds := vector (\n"
"\n"
"\'create procedure \"<TN0>\".\"<TN1>\".\"replcr_<TN>_I\" (<P>, inout __origin varchar)\n"
"{\n"
"if (not exists (select 1 from <FQTN> where <PKCOND>))\n"
"return 1;\n"
"\n"
"for select CR_PROC as __proc from DB.DBA.SYS_REPL_CR\n"
"where CR_TABLE_NAME = \'\'<TNAME>\'\' and CR_TYPE = \'\'I\'\'\n"
"order by CR_ORDER do\n"
"{\n"
"declare res integer;\n"
"res := call (__proc) (<ALLP>, __origin);\n"
"if (res = 3)\n"
"goto publisher_wins;\n"
"if (res <> 0)\n"
"return res;\n"
"}\n"
"\n"
"publisher_wins:\n"
"select <ALLCOLS> into <ALLP> from <FQTN> where <PKCOND>;\n"
"return 2;\n"
"}\',\n"
"\n"
"\'create procedure \"<TN0>\".\"<TN1>\".\"replcr_<TN>_U\" (<P>, <OLDP>, inout __origin varchar)\n"
"{\n"
"declare __guid varchar;\n"
"declare exit handler for not found goto delete_conflict;\n"
"select ROWGUID into __guid from <FQTN> where <PKCOND>;\n"
"declare exit handler for not found;\n"
"\n"
"if (__guid = __old_rowguid)\n"
"return 1;\n"
"\n"
"for select CR_PROC as __proc from DB.DBA.SYS_REPL_CR\n"
"where CR_TABLE_NAME = \'\'<TNAME>\'\' and CR_TYPE = \'\'U\'\'\n"
"order by CR_ORDER do\n"
"{\n"
"declare res integer;\n"
"res := call (__proc) (<ALLP>, <ALLOLDP>, __origin);\n"
"if (res = 3)\n"
"goto publisher_wins;\n"
"if (res <> 0)\n"
"return res;\n"
"}\n"
"\n"
"publisher_wins:\n"
"select <ALLCOLS> into <ALLP> from <FQTN> where <PKCOND>;\n"
"return 2;\n"
"\n"
"delete_conflict:\n"
"for select CR_PROC as __proc from DB.DBA.SYS_REPL_CR\n"
"where CR_TABLE_NAME = \'\'<TNAME>\'\' and CR_TYPE = \'\'D\'\'\n"
"order by CR_ORDER do\n"
"{\n"
"declare res integer;\n"
"res := call (__proc) (<ALLOLDP>, __origin);\n"
"if (res <> 0)\n"
"return res;\n"
"}\n"
"\n"
"return 5;\n"
"}\',\n"
"\n"
"\'create procedure \"<TN0>\".\"<TN1>\".\"replcr_<TN>_D\" (<OLDP>, inout __origin varchar)\n"
"{\n"
"declare __guid varchar;\n"
"declare exit handler for not found goto delete_conflict;\n"
"select ROWGUID into __guid from <FQTN> where <OLDPKCOND>;\n"
"declare exit handler for not found;\n"
"\n"
"if (__guid = __old_rowguid)\n"
"return 1;\n"
"\n"
"delete_conflict:\n"
"for select CR_PROC as __proc from DB.DBA.SYS_REPL_CR\n"
"where CR_TABLE_NAME = \'\'<TNAME>\'\' and CR_TYPE = \'\'D\'\'\n"
"order by CR_ORDER do\n"
"{\n"
"declare res integer;\n"
"res := call (__proc) (<ALLOLDP>, __origin);\n"
"if (res <> 0)\n"
"return res;\n"
"}\n"
"\n"
"return 5;\n"
"}\');\n"
"declare _stat, _msg varchar;\n"
"declare _tn0, _tn1, _tn varchar;\n"
"_tn0 := sprintf (\'%I\', name_part (src_table, 0));\n"
"_tn1 := sprintf (\'%I\', name_part (src_table, 1));\n"
"_tn := sprintf (\'%I\', replace (src_table, \'.\', \'_\'));\n"
"\n"
"_ix := 0;\n"
"_len := length (_cmds);\n"
"while (_ix < _len)\n"
"{\n"
"declare _cmd varchar;\n"
"_cmd := aref (_cmds, _ix);\n"
"_cmd := replace (_cmd, \'<TN0>\', _tn0);\n"
"_cmd := replace (_cmd, \'<TN1>\', _tn1);\n"
"_cmd := replace (_cmd, \'<TN>\', _tn);\n"
"_cmd := replace (_cmd, \'<TNAME>\', src_table);\n"
"_cmd := replace (_cmd, \'<FQTN>\', REPL_FQNAME (tbl));\n"
"_cmd := replace (_cmd, \'<PKCOND>\', _cr_pkcond);\n"
"_cmd := replace (_cmd, \'<OLDPKCOND>\', _cr_oldpkcond);\n"
"_cmd := replace (_cmd, \'<ALLCOLS>\', _cr_all_cols);\n"
"_cmd := replace (_cmd, \'<P>\', _cr_p);\n"
"_cmd := replace (_cmd, \'<ALLP>\', _cr_allp);\n"
"_cmd := replace (_cmd, \'<OLDP>\', _cr_oldp);\n"
"_cmd := replace (_cmd, \'<ALLOLDP>\', _cr_alloldp);\n"
"\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (_cmd, _stat, _msg))\n"
"signal (_stat, _msg);\n"
"\n"
"_ix := _ix + 1;\n"
"}\n"
"}\n"
"}\n"
"--src repl.sql:1124\n"
;

static const char *proc36 = 
"#line 1427 \"[executable]/repl.sql\"\n"
"create procedure REPL_SUBSCR_TBL_FKS (in server varchar, in acct varchar, in dsn varchar, in tbl varchar)\n"
"{\n"
"declare fk_tables any;\n"
"fk_tables := sql_foreign_keys (dsn,\n"
"name_part (tbl, 0, null), name_part (tbl, 1, null), name_part (tbl, 2, null),\n"
"\'%\', \'%\', \'%\');\n"
"declare _fk_table any;\n"
"declare pk_cols, fk_cols, _fk_name varchar;\n"
"_fk_name := null;\n"
"\n"
"foreach (any fk in fk_tables) do\n"
"{\n"
"if (_fk_name is null)\n"
"{\n"
"_fk_table := vector (fk[4], fk[5], fk[6]);\n"
"pk_cols := sprintf (\'\"%I\"\', fk[3]);\n"
"fk_cols := sprintf (\'\"%I\"\', fk[7]);\n"
"_fk_name := fk[11];\n"
"}\n"
"else if (_fk_name <> fk[11])\n"
"{\n"
"declare fk_tb varchar;\n"
"fk_tb := concat (_fk_table[0], \'.\', _fk_table[1], \'.\', _fk_table[2]);\n"
"if (exists (select 1 from DB.DBA.SYS_TP_ITEM where\n"
"TI_TYPE = 2 and TI_ITEM = fk_tb\n"
"and TI_SERVER = server and TI_ACCT = acct)\n"
"and not exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS where\n"
"PK_TABLE = tbl and FK_TABLE = fk_tb and FK_NAME = _fk_name))\n"
"{\n"
"declare stmt varchar;\n"
"stmt := sprintf (\n"
"\'ALTER TABLE \"%I\".\"%I\".\"%I\" add constraint \"%I\" foreign key (%s) references \"%I\".\"%I\".\"%I\" (%s)\',\n"
"_fk_table[0], _fk_table[1], _fk_table[2],\n"
"_fk_name,\n"
"fk_cols,\n"
"name_part (tbl, 0), name_part (tbl, 1), name_part (tbl, 2),\n"
"pk_cols);\n"
"exec (stmt);\n"
"}\n"
"\n"
"_fk_table := vector (fk[4], fk[5], fk[6]);\n"
"pk_cols := sprintf (\'\"%I\"\', fk[3]);\n"
"fk_cols := sprintf (\'\"%I\"\', fk[7]);\n"
"_fk_name := fk[11];\n"
"}\n"
"else\n"
"{\n"
"pk_cols := sprintf (\'%s, \"%I\"\', pk_cols, fk[3]);\n"
"fk_cols := sprintf (\'%s, \"%I\"\', fk_cols, fk[7]);\n"
"}\n"
"}\n"
"if (_fk_name is not null)\n"
"{\n"
"declare fk_tb varchar;\n"
"fk_tb := concat (_fk_table[0], \'.\', _fk_table[1], \'.\', _fk_table[2]);\n"
"if (exists (select 1 from DB.DBA.SYS_TP_ITEM where\n"
"TI_TYPE = 2 and TI_ITEM = fk_tb\n"
"and TI_SERVER = server and TI_ACCT = acct)\n"
"and not exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS where\n"
"PK_TABLE = tbl and FK_TABLE = fk_tb and FK_NAME = _fk_name))\n"
"{\n"
"declare stmt varchar;\n"
"stmt := sprintf (\n"
"\'ALTER TABLE \"%I\".\"%I\".\"%I\" add constraint \"%I\" foreign key (%s) references \"%I\".\"%I\".\"%I\" (%s)\',\n"
"_fk_table[0], _fk_table[1], _fk_table[2],\n"
"_fk_name,\n"
"fk_cols,\n"
"name_part (tbl, 0), name_part (tbl, 1), name_part (tbl, 2),\n"
"pk_cols);\n"
"exec (stmt);\n"
"}\n"
"}\n"
"}\n"
"--src repl.sql:1425\n"
;

static const char *proc37 = 
"#line 1503 \"[executable]/repl.sql\"\n"
"create procedure REPL_PRINT_COL_DEF (inout _col any) returns varchar\n"
"{\n"
"declare stmt varchar;\n"
"declare _col_name, _col_check varchar;\n"
"declare _col_dtp integer;\n"
"\n"
"stmt := \'\';\n"
"_col_name := repl_undot_name(aref(_col, 0));\n"
"_col_dtp := aref(_col, 1);\n"
"_col_check := aref(_col, 4);\n"
"\n"
"\n"
"if (_col_dtp = 128)\n"
"_col := vector(aref(_col, 0), 211, aref(_col, 2), aref(_col, 3));\n"
"\n"
"stmt := concat(stmt,\n"
"sprintf (\'\"%I\" \', _col_name), REPL_COLTYPE (_col));\n"
"if (_col_check is not null and isstring (_col_check))\n"
"{\n"
"\n"
"if (0 and (length(_col_check) >= 1 and aref (_col_check, 0) = 73))\n"
"stmt:= concat(stmt, \' IDENTITY \');\n"
"\n"
"if (length(_col_check) >= 2 and aref (_col_check, 1) = 85)\n"
"stmt:= concat(stmt, sprintf (\' IDENTIFIED BY \"%s\" \', trim (subseq (_col_check, 2))));\n"
"}\n"
"return stmt;\n"
"}\n"
"--src repl.sql:1501\n"
;

static const char *proc38 = 
"#line 1534 \"[executable]/repl.sql\"\n"
" create procedure __INT_REPL_ALTER_ADD_COL (in tb varchar, in col varchar,\n"
"in dv integer, in scale integer, in prec integer, in ck varchar, in _action varchar := \'ADD\')\n"
"{\n"
"for (select\n"
"TI_OPTIONS as _ti_options, TI_ACCT as _ti_acct\n"
"from DB.DBA.SYS_TP_ITEM\n"
"where\n"
"TI_SERVER = repl_this_server ()\n"
"and TI_ITEM = tb\n"
"and TI_TYPE= 2) do\n"
"{\n"
"declare _stmt varchar;\n"
"declare _col any;\n"
"\n"
"_col := vector (col, dv, scale, prec, ck);\n"
"_stmt := sprintf (\'ALTER TABLE \\\"%I\\\" %s %s\', tb, _action,\n"
"REPL_PRINT_COL_DEF (_col));\n"
"repl_text (_ti_acct, _stmt);\n"
"}\n"
"}\n"
"--src repl.sql:1532\n"
;

static const char *proc39 = 
"#line 1557 \"[executable]/repl.sql\"\n"
" create procedure __INT_REPL_ALTER_DROP_COL (in tb varchar, in col varchar,\n"
"in dv integer, in scale integer, in prec integer, in ck varchar, in _action varchar := \'DROP\')\n"
"{\n"
"for (select\n"
"TI_OPTIONS as _ti_options, TI_ACCT as _ti_acct\n"
"from DB.DBA.SYS_TP_ITEM\n"
"where\n"
"TI_SERVER = repl_this_server ()\n"
"and TI_ITEM = tb\n"
"and TI_TYPE= 2) do\n"
"{\n"
"declare _stmt varchar;\n"
"\n"
"_stmt := sprintf (\'ALTER TABLE \\\"%I\\\" %s \\\"%I\\\"\', tb, _action, col);\n"
"repl_text (_ti_acct, _stmt);\n"
"}\n"
"}\n"
"--src repl.sql:1555\n"
;

static const char *proc40 = 
"#line 1577 \"[executable]/repl.sql\"\n"
" create procedure __INT_REPL_ALTER_REDO_TRIGGERS (in tb varchar)\n"
"{\n"
"for (select\n"
"TI_OPTIONS as _ti_options, TI_ACCT as _ti_acct\n"
"from DB.DBA.SYS_TP_ITEM\n"
"where\n"
"TI_SERVER = repl_this_server ()\n"
"and TI_ITEM = tb\n"
"and TI_TYPE= 2) do\n"
"{\n"
"declare _stmt varchar;\n"
"declare _col any;\n"
"\n"
"declare _is_updatable integer;\n"
"_is_updatable := REPL_IS_UPDATABLE (repl_this_server (), _ti_acct);\n"
"\n"
"REPL_PUB_TBL (_ti_acct, tb, _is_updatable);\n"
"\n"
"\n"
"repl_text (_ti_acct, \'DB.DBA.__REPL_SUBSCR_TBL_TRIGGERS (?, ?, ?, ?)\',\n"
"repl_this_server (),\n"
"_ti_acct,\n"
"tb,\n"
"_is_updatable);\n"
"}\n"
"}\n"
"--src repl.sql:1575\n"
;

static const char *proc41 = 
"#line 1605 \"[executable]/repl.sql\"\n"
"create procedure __REPL_DDL_FK_MODIFY_PROPAGATE (in tb varchar, in op integer, in decl any, in orig_pkt varchar)\n"
"{\n"
"for (select\n"
"TI_OPTIONS as _ti_options, TI_ACCT as _ti_acct\n"
"from DB.DBA.SYS_TP_ITEM\n"
"where\n"
"TI_SERVER = repl_this_server ()\n"
"and TI_ITEM = tb\n"
"and TI_TYPE= 2) do\n"
"{\n"
"if (decl[0] = 1)\n"
"{\n"
"declare pkt varchar;\n"
"pkt := decl[2];\n"
"if (not isstring (pkt))\n"
"{\n"
"pkt := orig_pkt;\n"
"}\n"
"pkt := complete_table_name (pkt, 1);\n"
"\n"
"if (not exists\n"
"(select 1 from DB.DBA.SYS_TP_ITEM\n"
"where\n"
"TI_SERVER = repl_this_server ()\n"
"and TI_ITEM = pkt\n"
"and TI_TYPE = 2\n"
"and TI_ACCT = _ti_acct\n"
"))\n"
"goto _next;\n"
"}\n"
"\n"
"repl_text (_ti_acct, \'DB.DBA.ddl_alter_constr (?, ?, ?)\', tb, op, decl);\n"
"_next:;\n"
"}\n"
"}\n"
"--src repl.sql:1603\n"
;

static const char *proc42 = 
"#line 1642 \"[executable]/repl.sql\"\n"
"create procedure REPL_SUBSCR_TBL (in serv varchar, in _pub varchar, in tbl varchar, in _is_updatable integer)\n"
"{\n"
"declare state, message, stmt, stmtidx  varchar;\n"
"declare src_comp, rdata varchar;\n"
"declare n_cols, inx integer;\n"
"declare dest_col varchar;\n"
"declare _col any;\n"
"declare src_tbl varchar;\n"
"declare _col_name, _col_check varchar;\n"
"declare _col_dtp integer;\n"
"declare _cnt, _ncnt integer;\n"
"declare source_query varchar;\n"
"declare server varchar;\n"
"declare pub varchar;\n"
"declare idxarr any;\n"
"declare strtmp varchar;\n"
"\n"
"pub := SYS_ALFANUM_NAME (_pub);\n"
"\n"
"server := REPL_DSN (serv);\n"
"if (server is null)\n"
"signal (\'37000\', concat (\'The replication server \'\'\', server, \'\'\' does not exist\'), \'TR045\');\n"
"\n"
"tbl := complete_table_name(tbl, 1);\n"
"if (exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = tbl))\n"
"signal (\'37000\', concat (\'The target table \'\'\', tbl,\'\'\' already exists\'), \'TR046\');\n"
"src_tbl := REPL_ENSURE_TABLE_ATTACHED (server, tbl);\n"
"\n"
"declare _pk_cols any;\n"
"_pk_cols := REPL_PK_COLS (src_tbl);\n"
"\n"
"declare _num_pk_cols integer;\n"
"inx := 0;\n"
"_num_pk_cols := length (_pk_cols);\n"
"\n"
"declare pk_col_names, _pk_cond, _opk, _npk_cond varchar;\n"
"pk_col_names := \'\';\n"
"_pk_cond := \'\';\n"
"_opk := \'\';\n"
"_npk_cond := \'\';\n"
"while (inx < _num_pk_cols)\n"
"{\n"
"_col := aref (_pk_cols, inx);\n"
"_col_name := aref (_col, 0);\n"
"\n"
"pk_col_names := concat(pk_col_names, sprintf (\'\"%I\"\', _col_name));\n"
"_pk_cond := concat (_pk_cond, sprintf (\'\"%I\" = ?\', _col_name));\n"
"_opk := concat (_opk, sprintf (\'_O.\"%I\"\', _col_name));\n"
"_npk_cond := concat (_npk_cond, sprintf(\'\"%I\" = _N.\"%I\"\', _col_name, _col_name));\n"
"if (inx + 1 < _num_pk_cols)\n"
"{\n"
"pk_col_names := concat(pk_col_names, \', \');\n"
"_pk_cond := concat (_pk_cond, \' and \');\n"
"_opk := concat (_opk, \', \');\n"
"_npk_cond := concat (_npk_cond, \' and \');\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"declare _all_cols, _nall_cols, _oall_cols, _qm, _set_cols varchar;\n"
"declare _num_all_cols integer;\n"
"_all_cols := \'\';\n"
"_nall_cols := \'\';\n"
"_oall_cols := \'\';\n"
"_qm := \'\';\n"
"_set_cols := \'\';\n"
"_num_all_cols := 0;\n"
"\n"
"\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"if (0 = rexecute (server,\n"
"sprintf (\'select sc.\"COLUMN\", sc.\"COL_DTP\", sc.\"COL_SCALE\",\n"
"sc.\"COL_PREC\", sc.\"COL_CHECK\", serialize (sc.\"COL_OPTIONS\")\n"
"from DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS sc\n"
"where k.KEY_TABLE = \'\'%s\'\' and k.KEY_IS_MAIN = 1 and k.KEY_MIGRATE_TO is NULL\n"
"and kp.KP_KEY_ID = k.KEY_ID and sc.COL_ID = kp.KP_COL\n"
"and sc.\"COLUMN\" <> \'\'_IDN\'\' order by sc.COL_ID\', tbl),\n"
"state, message, vector(), 0, rdata, src_comp))\n"
"{\n"
"\n"
"inx := 0;\n"
"n_cols := length(src_comp);\n"
"stmt := concat(\'CREATE TABLE \', REPL_FQNAME (tbl), \'(\');\n"
"while (inx < n_cols)\n"
"{\n"
"_col := aref(src_comp, inx);\n"
"_col_name := repl_undot_name(aref(_col, 0));\n"
"_col_dtp := aref(_col, 1);\n"
"_col_check := aref(_col, 4);\n"
"declare _col_options any;\n"
"_col_options := deserialize(_col[5]);\n"
"\n"
"if (_col_dtp in (125, 132) and _col_options is not null and\n"
"atoi (get_keyword (\'xml_col\', coalesce(_col_options, vector()), \'0\')) > 0)\n"
"stmt := concat (stmt, sprintf (\'\\\"%I\\\" LONG XML\', _col_name));\n"
"else\n"
"stmt := concat (stmt, REPL_PRINT_COL_DEF (_col));\n"
"\n"
"if (inx + 1 < n_cols)\n"
"stmt:= concat(stmt, \', \');\n"
"\n"
"\n"
"if (_col_dtp <> 128)\n"
"{\n"
"_all_cols := concat (_all_cols, sprintf (\'\"%I\"\', _col_name));\n"
"_nall_cols := concat (_nall_cols, sprintf (\'_N.\"%I\"\', _col_name));\n"
"if (_col_name <> \'ROWGUID\')\n"
"{\n"
"_oall_cols := concat (\n"
"_oall_cols, sprintf (\'_O.\"%I\"\', _col_name));\n"
"}\n"
"else\n"
"{\n"
"_oall_cols := concat (\n"
"_oall_cols, sprintf (\'_rowguid\', _col_name));\n"
"}\n"
"_qm := concat (_qm, \'?\');\n"
"_set_cols := concat (_set_cols, sprintf (\'\"%I\" = ? \', _col_name));\n"
"if (inx + 1 < n_cols)\n"
"{\n"
"_all_cols := concat (_all_cols, \', \');\n"
"_nall_cols := concat (_nall_cols, \', \');\n"
"_oall_cols := concat (_oall_cols, \', \');\n"
"_qm := concat (_qm, \', \');\n"
"_set_cols := concat (_set_cols, \', \');\n"
"}\n"
"_num_all_cols := _num_all_cols + 1;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if (pk_col_names <> \'\')\n"
"stmt := concat(stmt, sprintf(\', PRIMARY KEY(%s))\', pk_col_names));\n"
"else\n"
"stmt := concat(stmt, \' )\');\n"
"}\n"
"else\n"
"signal (state, message);\n"
"\n"
"\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"stmtidx := null;\n"
"rdata := null;\n"
"src_comp := null;\n"
"if (0 = rexecute (server,\n"
"sprintf (\'select VI_INDEX, VI_COL, VI_ID_COL, VI_INDEX_TABLE,\n"
"VI_ID_IS_PK, VI_ID_CONSTR, VI_OFFBAND_COLS, VI_OPTIONS, VI_LANGUAGE\n"
"from DB.DBA.SYS_VT_INDEX where upper(VI_TABLE) = upper(\'\'%s\'\')\', tbl),\n"
"state, message, vector(), 0, rdata, src_comp))\n"
"{\n"
"declare isxml varchar;\n"
"isxml := \'\';\n"
"inx := 0;\n"
"n_cols := length(src_comp);\n"
"idxarr := make_array(n_cols, \'any\');\n"
"while (inx < n_cols)\n"
"{\n"
"declare ptext, pmore varchar;\n"
"declare state2, message2 varchar;\n"
"declare src_comp2, rdata2 varchar;\n"
"\n"
"if (0 = rexecute(server,\n"
"sprintf (\'select P_TEXT, blob_to_string(P_MORE) from DB.DBA.SYS_PROCEDURES\n"
"where upper(P_NAME) = upper(\'\'%s.%s.VT_INDEX_%s_%s_%s\'\')\',\n"
"name_part (tbl, 0), name_part (tbl, 1),\n"
"name_part (tbl, 0), name_part (tbl, 1), name_part (tbl, 2)),\n"
"state2, message2, vector(), 0, rdata2, src_comp2))\n"
"{\n"
"_col := aref(src_comp2, inx);\n"
"ptext := aref(_col, 0);\n"
"pmore := aref(_col, 1);\n"
"if (ptext is null)\n"
"ptext := pmore;\n"
"if (strstr (ptext, \'text/xml\') < 256)\n"
"isxml := \'XML \';\n"
"}\n"
"else\n"
"signal (state2, message2);\n"
"\n"
"_col := aref(src_comp, inx);\n"
"stmtidx := sprintf(\'CREATE TEXT %sINDEX ON %s(\"%s\") \', isxml, REPL_FQNAME (tbl), aref(_col, 1));\n"
"\n"
"strtmp := aref(_col, 2);\n"
"if (strtmp is not null and length (strtmp) > 0)\n"
"stmtidx := concat (stmtidx, sprintf (\' WITH KEY \"%s\"\', strtmp));\n"
"\n"
"strtmp := deserialize (aref(_col, 6));\n"
"\n"
"if (strtmp is not null and length (strtmp) > 0)\n"
"{\n"
"stmtidx := concat (stmtidx, sprintf (\' CLUSTERED WITH (\'));\n"
"_ncnt := length (strtmp);\n"
"_cnt := 0;\n"
"while (_cnt < _ncnt)\n"
"{\n"
"stmtidx := concat (stmtidx, cast (aref(strtmp, _cnt) as varchar));\n"
"if (_cnt < _ncnt - 1)\n"
"stmtidx := concat (stmtidx, \', \');\n"
"_cnt := _cnt + 1;\n"
"}\n"
"stmtidx := concat (stmtidx, \')\');\n"
"}\n"
"\n"
"strtmp := aref(_col, 8);\n"
"if (strtmp is not null and length (strtmp) > 0 and neq (strtmp, \'*ini*\'))\n"
"stmtidx := concat (stmtidx, sprintf (\' LANGUAGE \'\'%s\'\'\', strtmp));\n"
"\n"
"aset (idxarr, inx, stmtidx);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"else\n"
"signal (state, message);\n"
"\n"
"\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"if (0 <> exec (stmt, state, message))\n"
"signal (state, message);\n"
"\n"
"inx := 0;\n"
"n_cols := length(idxarr);\n"
"while (inx < n_cols)\n"
"{\n"
"stmtidx := aref(idxarr, inx);\n"
"state := \'00000\';\n"
"message := \'\';\n"
"\n"
"if (0 <> exec (stmtidx, state, message))\n"
"signal (state, message);\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"\n"
"if (_is_updatable <> 0)\n"
"{\n"
"declare _trg varchar;\n"
"declare backpub varchar;\n"
"backpub := concat (\'!\', pub);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_I\" after insert on %s order 199 referencing new as _N\\n{\\n\',\n"
"replace (tbl, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, \'if (repl_is_raw() <> 0) return;\\n\');\n"
"_trg := concat (_trg, \'_N.ROWGUID := uuid();\\n\');\n"
"_trg := concat (_trg, \'set triggers off;\\n\');\n"
"_trg := concat (_trg, sprintf (\'update %s set ROWGUID = _N.ROWGUID where %s;\\n\', REPL_FQNAME (tbl), _npk_cond));\n"
"_trg := concat (_trg, sprintf (\'repl_text_pushback (\'\'%s\'\', \'\'%s\'\', \'\'insert replacing %s (%s) values (%s)\'\', %s);\\n\',\n"
"serv, backpub, REPL_FQNAME (tbl), _all_cols, _qm,\n"
"_nall_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_U\" after update on %s\\n order 199 referencing old as _O, new as _N\\n{\\n\',\n"
"replace (tbl, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, \'if (repl_is_raw() <> 0) return;\\n\');\n"
"_trg := concat (_trg, \'declare _rowguid varchar;\\n\');\n"
"_trg := concat (_trg, \'_rowguid := _O.ROWGUID;\\n\');\n"
"_trg := concat (_trg, \'_N.ROWGUID := uuid();\\n\');\n"
"_trg := concat (_trg, \'set triggers off;\\n\');\n"
"_trg := concat (_trg, sprintf (\'update %s set ROWGUID = _N.ROWGUID where %s;\\n\', REPL_FQNAME (tbl), _npk_cond));\n"
"_trg := concat (_trg, sprintf (\'repl_text_pushback (\'\'%s\'\', \'\'%s\'\', \'\'update %s set %s where %s\'\', %s, %s, %s, %d);\\n\',\n"
"serv, backpub, REPL_FQNAME (tbl), _set_cols, _pk_cond,\n"
"_nall_cols, _opk,\n"
"_oall_cols, _num_all_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_D\" after delete on %s order 199 referencing old as _O\\n{\\n\',\n"
"replace (tbl, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, \'if (repl_is_raw() <> 0) return;\\n\');\n"
"_trg := concat (_trg, \'declare _rowguid varchar;\\n\');\n"
"_trg := concat (_trg, \'_rowguid := _O.ROWGUID;\\n\');\n"
"_trg := concat (_trg, sprintf (\'repl_text_pushback (\'\'%s\'\', \'\'%s\'\', \'\'delete from %s where %s\'\', %s, %s, %d);\\n\',\n"
"serv, backpub, REPL_FQNAME (tbl), _pk_cond,\n"
"_opk,\n"
"_oall_cols, _num_all_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"}\n"
"\n"
"commit work;\n"
"\n"
"\n"
"\n"
"if (_is_updatable = 0)\n"
"{\n"
"if (0 <> exec (sprintf (\'drop table %s\', REPL_FQNAME (src_tbl)), state, message))\n"
"signal (state, message);\n"
"}\n"
"return 0;\n"
"}\n"
"--src repl.sql:1640\n"
;

static const char *proc43 = 
"#line 1951 \"[executable]/repl.sql\"\n"
"create procedure __REPL_SUBSCR_TBL_TRIGGERS (\n"
"in serv varchar,\n"
"in _pub varchar,\n"
"in tbl varchar,\n"
"in _is_updatable integer)\n"
"{\n"
"\n"
"declare state, message varchar;\n"
"declare n_cols, inx integer;\n"
"declare _col any;\n"
"declare src_tbl varchar;\n"
"declare _col_name varchar;\n"
"declare _col_dtp integer;\n"
"declare server varchar;\n"
"declare pub varchar;\n"
"declare _pk_cols any;\n"
"declare _pk_cond, _opk, _npk_cond varchar;\n"
"declare _all_cols, _nall_cols, _oall_cols, _qm, _set_cols varchar;\n"
"declare _num_all_cols integer;\n"
"declare _num_pk_cols integer;\n"
"declare _all_cols_arr any;\n"
"declare _trg varchar;\n"
"declare backpub varchar;\n"
"\n"
"if (_is_updatable = 0)\n"
"return;\n"
"\n"
"pub := SYS_ALFANUM_NAME (_pub);\n"
"\n"
"server := REPL_DSN (serv);\n"
"\n"
"tbl := complete_table_name(tbl, 1);\n"
"src_tbl := REPL_ENSURE_TABLE_ATTACHED (server, tbl);\n"
"\n"
"_pk_cols := REPL_PK_COLS (src_tbl);\n"
"\n"
"inx := 0;\n"
"_num_pk_cols := length (_pk_cols);\n"
"\n"
"_pk_cond := \'\';\n"
"_opk := \'\';\n"
"_npk_cond := \'\';\n"
"while (inx < _num_pk_cols)\n"
"{\n"
"_col := aref (_pk_cols, inx);\n"
"_col_name := aref (_col, 0);\n"
"\n"
"_pk_cond := concat (_pk_cond, sprintf (\'\"%I\" = ?\', _col_name));\n"
"_opk := concat (_opk, sprintf (\'_O.\"%I\"\', _col_name));\n"
"_npk_cond := concat (_npk_cond, sprintf(\'\"%I\" = _N.\"%I\"\', _col_name, _col_name));\n"
"if (inx + 1 < _num_pk_cols)\n"
"{\n"
"_pk_cond := concat (_pk_cond, \' and \');\n"
"_opk := concat (_opk, \', \');\n"
"_npk_cond := concat (_npk_cond, \' and \');\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"_all_cols := \'\';\n"
"_nall_cols := \'\';\n"
"_oall_cols := \'\';\n"
"_qm := \'\';\n"
"_set_cols := \'\';\n"
"_num_all_cols := 0;\n"
"\n"
"_all_cols_arr := REPL_ALL_COLS (src_tbl);\n"
"inx := 0;\n"
"n_cols := length(_all_cols_arr);\n"
"while (inx < n_cols)\n"
"{\n"
"_col := aref(_all_cols_arr, inx);\n"
"_col_name := repl_undot_name(aref(_col, 0));\n"
"_col_dtp := aref (_col, 1);\n"
"\n"
"\n"
"if (_col_dtp <> 128)\n"
"{\n"
"_all_cols := concat (_all_cols, sprintf (\'\"%I\"\', _col_name));\n"
"_nall_cols := concat (_nall_cols, sprintf (\'_N.\"%I\"\', _col_name));\n"
"if (_col_name <> \'ROWGUID\')\n"
"{\n"
"_oall_cols := concat (\n"
"_oall_cols, sprintf (\'_O.\"%I\"\', _col_name));\n"
"}\n"
"else\n"
"{\n"
"_oall_cols := concat (\n"
"_oall_cols, sprintf (\'_rowguid\', _col_name));\n"
"}\n"
"_qm := concat (_qm, \'?\');\n"
"_set_cols := concat (_set_cols, sprintf (\'\"%I\" = ? \', _col_name));\n"
"if (inx + 1 < n_cols)\n"
"{\n"
"_all_cols := concat (_all_cols, \', \');\n"
"_nall_cols := concat (_nall_cols, \', \');\n"
"_oall_cols := concat (_oall_cols, \', \');\n"
"_qm := concat (_qm, \', \');\n"
"_set_cols := concat (_set_cols, \', \');\n"
"}\n"
"_num_all_cols := _num_all_cols + 1;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"backpub := concat (\'!\', pub);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_I\" after insert on %s order 199 referencing new as _N\\n{\\n\',\n"
"replace (tbl, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, \'if (repl_is_raw() <> 0) return;\\n\');\n"
"_trg := concat (_trg, \'_N.ROWGUID := uuid();\\n\');\n"
"_trg := concat (_trg, \'set triggers off;\\n\');\n"
"_trg := concat (_trg, sprintf (\'update %s set ROWGUID = _N.ROWGUID where %s;\\n\', REPL_FQNAME (tbl), _npk_cond));\n"
"_trg := concat (_trg, sprintf (\'repl_text_pushback (\'\'%s\'\', \'\'%s\'\', \'\'insert replacing %s (%s) values (%s)\'\', %s);\\n\',\n"
"serv, backpub, REPL_FQNAME (tbl), _all_cols, _qm,\n"
"_nall_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_U\" after update on %s\\n order 199 referencing old as _O, new as _N\\n{\\n\',\n"
"replace (tbl, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, \'if (repl_is_raw() <> 0) return;\\n\');\n"
"_trg := concat (_trg, \'declare _rowguid varchar;\\n\');\n"
"_trg := concat (_trg, \'_rowguid := _O.ROWGUID;\\n\');\n"
"_trg := concat (_trg, \'_N.ROWGUID := uuid();\\n\');\n"
"_trg := concat (_trg, \'set triggers off;\\n\');\n"
"_trg := concat (_trg, sprintf (\'update %s set ROWGUID = _N.ROWGUID where %s;\\n\', REPL_FQNAME (tbl), _npk_cond));\n"
"_trg := concat (_trg, sprintf (\'repl_text_pushback (\'\'%s\'\', \'\'%s\'\', \'\'update %s set %s where %s\'\', %s, %s, %s, %d);\\n\',\n"
"serv, backpub, REPL_FQNAME (tbl), _set_cols, _pk_cond,\n"
"_nall_cols, _opk,\n"
"_oall_cols, _num_all_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"\n"
"_trg := sprintf (\'create trigger \"repl_%I_D\" after delete on %s order 199 referencing old as _O\\n{\\n\',\n"
"replace (tbl, \'.\', \'_\'), REPL_FQNAME (tbl));\n"
"_trg := concat (_trg, \'if (repl_is_raw() <> 0) return;\\n\');\n"
"_trg := concat (_trg, \'declare _rowguid varchar;\\n\');\n"
"_trg := concat (_trg, \'_rowguid := _O.ROWGUID;\\n\');\n"
"_trg := concat (_trg, sprintf (\'repl_text_pushback (\'\'%s\'\', \'\'%s\'\', \'\'delete from %s where %s\'\', %s, %s, %d);\\n\',\n"
"serv, backpub, REPL_FQNAME (tbl), _pk_cond,\n"
"_opk,\n"
"_oall_cols, _num_all_cols));\n"
"_trg := concat (_trg, \'}\\n\');\n"
"\n"
"state := \'00000\';\n"
"message := \'\';\n"
"exec (_trg, state, message);\n"
"\n"
"commit work;\n"
"\n"
"return 0;\n"
"}\n"
"--src repl.sql:1949\n"
;

static const char *proc44 = 
"#line 2115 \"[executable]/repl.sql\"\n"
"create procedure REPL_GRANT (in _acct varchar, in grantee varchar)\n"
"{\n"
"declare acct varchar;\n"
"acct := SYS_ALFANUM_NAME (_acct);\n"
"if (not exists (select 1 from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = repl_this_server ()\n"
"and ACCOUNT = acct))\n"
"signal (\'37000\', concat (\'The publication \'\'\', acct, \'\'\' does not exist\'), \'TR047\');\n"
"if (not exists (select 1 from DB.DBA.SYS_USERS where U_NAME = grantee) and grantee is not null)\n"
"signal (\'22023\', concat (\'The grantee is invalid user name : \'\'\', grantee, \'\'\'\'), \'TR048\');\n"
"if (not exists (select 1 from DB.DBA.SYS_TP_GRANT where TPG_ACCT = acct and TPG_GRANTEE = grantee))\n"
"{\n"
"insert into DB.DBA.SYS_TP_GRANT (TPG_ACCT, TPG_GRANTEE) values (acct, grantee);\n"
"__repl_grant (acct, grantee);\n"
"}\n"
"}\n"
"--src repl.sql:2113\n"
;

static const char *proc45 = 
"#line 2133 \"[executable]/repl.sql\"\n"
"create procedure REPL_REVOKE (in _acct varchar, in grantee varchar)\n"
"{\n"
"declare acct varchar;\n"
"acct := SYS_ALFANUM_NAME (_acct);\n"
"if (not exists (select 1 from DB.DBA.SYS_REPL_ACCOUNTS where SERVER = repl_this_server ()\n"
"and ACCOUNT = acct))\n"
"signal (\'37000\', concat (\'The publication \'\'\', acct, \'\'\' does not exist\'), \'TR049\');\n"
"if (not exists (select 1 from DB.DBA.SYS_USERS where U_NAME = grantee) and grantee is not null)\n"
"signal (\'22023\', concat (\'The grantee is invalid user name : \'\'\', grantee, \'\'\'\'), \'TR050\');\n"
"if (exists (select 1 from DB.DBA.SYS_TP_GRANT where TPG_ACCT = acct and TPG_GRANTEE = grantee))\n"
"{\n"
"delete from DB.DBA.SYS_TP_GRANT where TPG_ACCT = acct and TPG_GRANTEE = grantee;\n"
"__repl_revoke (acct, grantee);\n"
"}\n"
"else if (grantee is null and exists (select 1 from DB.DBA.SYS_TP_GRANT where TPG_ACCT = acct and TPG_GRANTEE is null))\n"
"{\n"
"delete from DB.DBA.SYS_TP_GRANT where TPG_ACCT = acct and TPG_GRANTEE is null;\n"
"__repl_revoke (acct, grantee);\n"
"}\n"
"else\n"
"signal (\'37000\', concat (\'The grantee \'\'\', grantee, \'\'\' does not exist\'), \'TR051\');\n"
"}\n"
"--src repl.sql:2131\n"
;

static const char *proc46 = 
"#line 2157 \"[executable]/repl.sql\"\n"
"create procedure REPL_DAV_PROC (in coltbl varchar, in restbl varchar, in dav_u any, in dav_g any)\n"
"{\n"
"declare str, stat, msg varchar;\n"
"str :=\n"
"\'create procedure DAV_COL_PATH (in _id integer)\n"
"{\n"
"declare _path, _name varchar;\n"
"declare _p_id integer;\n"
"_path := \'\'/\'\';\n"
"whenever not found goto nf;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into _name, _p_id from <DAV_COL_TBL> where COL_ID = _id;\n"
"_id := _p_id;\n"
"_path := concat (\'\'/\'\', _name, _path);\n"
"}\n"
"nf:\n"
"return _path;\n"
"}\';\n"
"str := replace (str, \'<DAV_COL_TBL>\', coltbl);\n"
"stat := \'00000\'; msg :=\'\';\n"
"exec (str, stat, msg);\n"
"if (dav_u is not null)\n"
"dav_u := cast (dav_u as varchar);\n"
"else\n"
"dav_u := \'NULL\';\n"
"if (dav_g is not null)\n"
"dav_g := cast (dav_g as varchar);\n"
"else\n"
"dav_g := \'NULL\';\n"
"str := sprintf (\'create procedure REPL_DAV_FILL_ALL (in _coll varchar)\n"
"{\n"
"declare _id integer;\n"
"_id := 0;\n"
"for select DAV_COL_PATH (COL_ID) as col_path, COL_ID as _src_id, COL_PERMS as cprms from <DAV_COL_TBL>\n"
"where DAV_COL_PATH (COL_ID) like concat (_coll, \'\'%%\'\') do\n"
"{\n"
"_id := DAV_MKCOL (col_path, cprms, %s, %s);\n"
"for select RES_NAME as name, RES_TYPE as type, RES_CONTENT as cont, RES_PERMS as perms\n"
"from <DAV_RES_TBL> where RES_COL = _src_id do\n"
"{\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_CR_TIME, RES_MOD_TIME,\n"
"RES_OWNER, RES_GROUP, RES_PERMS, RES_TYPE, RES_CONTENT)\n"
"values (WS.WS.GETID (\'\'R\'\'), name, _id, now (), now (), %s, %s, perms, type, cont);\n"
"}\n"
"}\n"
"}\', dav_u, dav_g, dav_u, dav_g);\n"
"str := replace (str, \'<DAV_COL_TBL>\', coltbl);\n"
"str := replace (str, \'<DAV_RES_TBL>\', restbl);\n"
"stat := \'00000\'; msg :=\'\';\n"
"exec (str, stat, msg);\n"
"}\n"
"--src repl.sql:2155\n"
;

static const char *proc47 = 
"#line 2211 \"[executable]/repl.sql\"\n"
"create procedure DAV_MKCOL (in pathstr varchar, in perms varchar, in dav_u integer, in dav_g integer)\n"
"{\n"
"declare _path, _np any;\n"
"declare _ix, _len, _id integer;\n"
"declare _coll varchar;\n"
"if (not isstring (pathstr))\n"
"signal (\'22023\', \'The path string is mandatory for DB.DBA.MKCOL\', \'TR052\');\n"
"if (not isstring (perms))\n"
"perms := \'110110110N\';\n"
"_path := WS.WS.HREF_TO_ARRAY (pathstr, \'\');\n"
"_len := length (_path);\n"
"if (_len = 0)\n"
"return;\n"
"_ix := 0;\n"
"_id := 0;\n"
"while (_ix < _len)\n"
"{\n"
"if (_ix = 0)\n"
"_np := vector (aref (_path, _ix));\n"
"else\n"
"_np := vector_concat (_np, vector (aref (_path, _ix)));\n"
"if (not WS.WS.ISCOL (_np))\n"
"insert into WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_CR_TIME,\n"
"COL_MOD_TIME, COL_OWNER, COL_GROUP, COL_PERMS)\n"
"values (WS.WS.GETID (\'C\'), aref (_path, _ix), _id, now (), now (), dav_u, dav_g, perms);\n"
"WS.WS.FINDCOL (_np, _id);\n"
"_ix := _ix + 1;\n"
"}\n"
"return _id;\n"
"}\n"
"--src repl.sql:2209\n"
;

static const char *proc48 = 
"#line 2244 \"[executable]/repl.sql\"\n"
"create procedure REPL_DAV_FILL (in _srv varchar, in _coll varchar, in dav_u integer, in dav_g integer)\n"
"{\n"
"declare _addr, _stat, _msg varchar;\n"
"declare _id, _src_id integer;\n"
"_stat := \'00000\'; _msg := \'\';\n"
"_addr := REPL_DSN (_srv);\n"
"if (_addr is null)\n"
"signal (\'37000\', concat (\'Publication server \'\'\', _srv, \'\'\' does not exist\'), \'TR053\');\n"
"exec (sprintf (\'attach table WS.WS.SYS_DAV_COL as REPL_DAV_COL from \'\'%s\'\'\', _addr), _stat, _msg);\n"
"if (_stat = \'00000\')\n"
"{\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (sprintf (\'attach table WS.WS.SYS_DAV_RES as REPL_DAV_RES  from \'\'%s\'\'\', _addr), _stat, _msg);\n"
"}\n"
"else\n"
"return _msg;\n"
"if (_stat = \'00000\')\n"
"{\n"
"REPL_DAV_PROC (\'DB.DBA.REPL_DAV_COL\', \'DB.DBA.REPL_DAV_RES\', dav_u, dav_g);\n"
"if (isstring (_coll) and length (_coll) > 0 and aref (_coll, length (_coll) - 1) <> ascii (\'/\'))\n"
"_coll := concat (_coll, \'/\');\n"
"REPL_DAV_FILL_ALL (_coll);\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (\'drop procedure DAV_COL_PATH\', _stat, _msg);\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (\'drop procedure REPL_DAV_FILL_ALL\', _stat, _msg);\n"
"_stat := \'00000\'; _msg := \'\';\n"
"commit work;\n"
"exec (\'drop table REPL_DAV_COL\', _stat, _msg);\n"
"_stat := \'00000\'; _msg := \'\';\n"
"commit work;\n"
"exec (\'drop table REPL_DAV_RES\', _stat, _msg);\n"
"}\n"
"else\n"
"return _msg;\n"
"}\n"
"--src repl.sql:2242\n"
;

static const char *proc49 = 
"#line 2282 \"[executable]/repl.sql\"\n"
"create procedure REPL_INIT_COPY (in srv varchar, in _acct varchar, in ret_err integer := 0)\n"
"{\n"
"declare txt, sel, src_cols, src_table, _stat, _msg, server, acct varchar;\n"
"declare _rrc, _ret_err any;\n"
"declare dav_ui, dav_gi integer;\n"
"declare _is_updatable, idx integer;\n"
"declare reg_stat varchar;\n"
"\n"
"acct := SYS_ALFANUM_NAME (_acct);\n"
"_is_updatable := REPL_IS_UPDATABLE(srv, acct);\n"
"\n"
"_ret_err := vector ();\n"
"server := REPL_DSN (srv);\n"
"if (server is null)\n"
"signal (\'37000\', concat (\'The replication server \'\'\', server, \'\'\' does not exist\'), \'TR147\');\n"
"\n"
"\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> rexecute (server, \'__atomic (1)\', _stat, _msg))\n"
"signal (_stat, _msg);\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"rexecute (server, \'__atomic (0)\', _stat, _msg);\n"
"resignal;\n"
"};\n"
"\n"
"reg_stat := sprintf (\'repl_%s_%s_state\', srv, _acct);\n"
"registry_set (reg_stat, serialize (vector (\'0\', \'\')));\n"
"idx := 0;\n"
"\n"
"for select TI_TYPE as t, TI_ITEM as i, TI_OPTIONS as opt, TI_DAV_USER as dav_u, TI_DAV_GROUP as dav_g from DB.DBA.SYS_TP_ITEM\n"
"where TI_SERVER = srv and TI_ACCT = acct order by 1\n"
"do\n"
"{\n"
"registry_set (reg_stat, serialize ( vector(cast (idx as varchar), i)));\n"
"if (t = 1)\n"
"{\n"
"commit work;\n"
"repl_set_raw(1);\n"
"if (not WS.WS.ISCOL (WS.WS.HREF_TO_ARRAY (i, \'\')))\n"
"{\n"
"REPL_GET_DAV_UID_GID (dav_u, dav_g, dav_ui, dav_gi);\n"
"REPL_DAV_FILL (srv, i, dav_ui, dav_gi);\n"
"}\n"
"else\n"
"{\n"
"if (ret_err)\n"
"_ret_err := vector_concat (_ret_err,\n"
"vector (i, \'37000\', concat (\'TR055\', \'The WebDAV collection \'\'\', i, \'\'\' already exists\')));\n"
"else\n"
"signal (\'37000\', concat (\'The WebDAV collection \'\'\', i, \'\'\' already exists\'), \'TR055\');\n"
"}\n"
"}\n"
"else if (t = 2)\n"
"{\n"
"_stat := \'00000\'; _msg := \'\';\n"
"commit work;\n"
"repl_set_raw(1);\n"
"if (_is_updatable = 0)\n"
"{\n"
"exec (\'vd_int_attach_table (?,?,NULL,NULL,NULL,NULL,1)\', _stat, _msg, vector (server, i));\n"
"if (\'00000\' <> _stat)\n"
"{\n"
"if (ret_err)\n"
"{\n"
"_ret_err := vector_concat (_ret_err, vector (i, _stat, _msg));\n"
"rollback work;\n"
"goto next_item;\n"
"}\n"
"else\n"
"signal (_stat, _msg);\n"
"}\n"
"}\n"
"\n"
"src_table := att_local_name (server, i);\n"
"src_cols := REPL_TBL_COLS (i);\n"
"sel := sprintf (\'insert into %s (%s) select %s from %s\',\n"
"REPL_FQNAME (i), src_cols, src_cols, REPL_FQNAME (src_table));\n"
"_stat := \'00000\'; _msg := \'\';\n"
"set triggers off;\n"
"if (0 <> exec (sel, _stat, _msg))\n"
"{\n"
"set triggers on;\n"
"rollback work;\n"
"if (_is_updatable = 0)\n"
"{\n"
"declare _stat2, _msg2 varchar;\n"
"_stat2 := \'00000\'; _msg2 := \'\';\n"
"exec (sprintf (\'drop table %s\', REPL_FQNAME (src_table)),\n"
"_stat2, _msg2);\n"
"}\n"
"\n"
"if (ret_err)\n"
"{\n"
"_ret_err := vector_concat (_ret_err, vector (i, _stat, _msg));\n"
"goto next_item;\n"
"}\n"
"else\n"
"signal (_stat, _msg);\n"
"}\n"
"else\n"
"set triggers on;\n"
"\n"
"for (select VI_TABLE from  DB.DBA.SYS_VT_INDEX where upper(VI_TABLE) = upper(i)) do\n"
"{\n"
"exec (sprintf (\'\"%I\".\"%I\".\"VT_INDEX_%I\" ()\',\n"
"name_part (VI_TABLE, 0), name_part (VI_TABLE, 1),\n"
"DB.DBA.SYS_ALFANUM_NAME (replace (VI_TABLE, \'.\', \'_\'))));\n"
"}\n"
"\n"
"\n"
"if (_is_updatable = 0)\n"
"{\n"
"_stat := \'00000\'; _msg := \'\';\n"
"if (0 <> exec (sprintf (\'drop table %s\', REPL_FQNAME (src_table)),\n"
"_stat, _msg))\n"
"{\n"
"\n"
"rollback work;\n"
"if (ret_err)\n"
"_ret_err := vector_concat (_ret_err, vector (i, _stat, _msg));\n"
"else\n"
"signal (_stat, _msg);\n"
"}\n"
"}\n"
"}\n"
"else if (t = 3)\n"
"{\n"
"declare rem_proc, proc_body varchar;\n"
"declare _mdta any;\n"
"_stat := \'00000\'; _msg := \'\';\n"
"commit work;\n"
"repl_set_raw(1);\n"
"rexecute (server,\n"
"\'create view PROC_BODY as select P_NAME, coalesce (P_TEXT, blob_to_string (P_MORE)) as P_TEXT,\n"
"P_QUAL from DB.DBA.SYS_PROCEDURES\', _stat, _msg);\n"
"\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (\'DB.DBA.vd_int_attach_table (?, \'\'DB.DBA.PROC_BODY\'\', NULL, NULL, NULL, vector (\'\'P_NAME\'\'), 1)\',\n"
"_stat, _msg, vector (server));\n"
"\n"
"rem_proc := att_local_name (server, \'DB.DBA.PROC_BODY\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"\n"
"exec (sprintf (\'select P_TEXT from %s where P_NAME = \'\'%s\'\'\',\n"
"REPL_FQNAME (rem_proc), i),\n"
"_stat, _msg, vector (), 100, _mdta, _rrc);\n"
"\n"
"\n"
"if (isarray (_rrc) and length (_rrc)\n"
"and isarray (_rrc[0]) and length (_rrc[0]))\n"
"proc_body :=  aref( aref(_rrc, 0), 0);\n"
"else\n"
"proc_body := NULL;\n"
"if (_stat = \'00000\' and isstring (proc_body))\n"
"{\n"
"\n"
"txt := proc_body;\n"
"_stat := \'00000\'; _msg := \'\';\n"
"if (substring (txt, 1, 7) = \'__repl \')\n"
"{\n"
"declare _off integer;\n"
"_off := strstr (lower (txt), \'create \');\n"
"txt := substring (txt, _off + 1, length (txt) - _off);\n"
"exec (txt, _stat, _msg);\n"
"\n"
"}\n"
"else\n"
"{\n"
"exec (txt, _stat, _msg);\n"
"\n"
"}\n"
"\n"
"if (_stat <> \'00000\')\n"
"{\n"
"rollback work;\n"
"if (ret_err)\n"
"_ret_err := vector_concat (_ret_err, vector (i, _stat, _msg));\n"
"else\n"
"signal (_stat, _msg);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"rollback work;\n"
"if (ret_err)\n"
"_ret_err := vector_concat (_ret_err, vector (i, _stat, _msg));\n"
"else\n"
"signal (_stat, _msg);\n"
"}\n"
"}\n"
"next_item:;\n"
"idx := idx + 1;\n"
"registry_set (reg_stat, serialize ( vector(cast (idx as varchar), i)));\n"
"}\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"rexecute (server,\n"
"sprintf (\'select sequence_set (\'\'repl_%s_%s\'\', 0, 2)\', srv, acct),\n"
"_stat, _msg, null, null, null, _rrc);\n"
"\n"
"{\n"
"declare lvl integer;\n"
"if (isstring (aref( aref(_rrc, 0), 0)))\n"
"lvl := atoi (aref( aref(_rrc, 0), 0));\n"
"else if (isinteger (aref( aref(_rrc, 0), 0)))\n"
"lvl := aref( aref(_rrc, 0), 0);\n"
"else\n"
"lvl := 0;\n"
"if (lvl > 0)\n"
"lvl := lvl - 1;\n"
"sequence_set (concat (\'repl_\',srv,\'_\',acct), lvl, 0);\n"
"}\n"
"\n"
"\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"rexecute (server, \'__atomic (0)\', _stat, _msg);\n"
"\n"
"if (length (_ret_err))\n"
"registry_set (reg_stat, serialize (_ret_err));\n"
"else\n"
"registry_set (reg_stat, serialize (vector (cast (idx as varchar), \'*all*\')));\n"
"\n"
"if (not length (_ret_err))\n"
"_ret_err := NULL;\n"
"return _ret_err;\n"
"}\n"
"--src repl.sql:2280\n"
;

static const char *proc50 = 
"#line 2528 \"[executable]/repl.sql\"\n"
"create procedure REPL_SUB_ITEM (in srv varchar, in _acct varchar,\n"
"in i varchar, in t integer, in opt varchar, in cm integer)\n"
"{\n"
"declare txt, sel, src_cols, src_table, _stat, _msg, _server varchar;\n"
"declare _rrc any;\n"
"declare dav_ui, dav_gi integer;\n"
"declare dav_u, dav_g varchar;\n"
"_acct := SYS_ALFANUM_NAME (_acct);\n"
"declare upc cursor for select distinct TI_DAV_USER, TI_DAV_GROUP from DB.DBA.SYS_TP_ITEM\n"
"where TI_SERVER = srv and TI_ACCT = _acct and TI_TYPE = 1 and (TI_DAV_USER is not null or TI_DAV_GROUP is not null);\n"
"\n"
"declare _is_updatable integer;\n"
"_is_updatable := REPL_IS_UPDATABLE(srv, _acct);\n"
"\n"
"dav_u := null; dav_g := null;\n"
"\n"
"_server := REPL_DSN (srv);\n"
"if (_server is null)\n"
"signal (\'37000\', concat (\'The replication server \'\'\', _server, \'\'\' does not exist\'), \'TR146\');\n"
"\n"
"repl_set_raw(1);\n"
"\n"
"if (t = 1)\n"
"{\n"
"declare exit handler for not found;\n"
"open upc (prefetch 1);\n"
"{\n"
"fetch upc into dav_u, dav_g;\n"
"}\n"
"close upc;\n"
"}\n"
"\n"
"insert soft DB.DBA.SYS_TP_ITEM (TI_SERVER,TI_ACCT,TI_ITEM,TI_TYPE,TI_OPTIONS,TI_DAV_USER,TI_DAV_GROUP,TI_IS_COPY)\n"
"values (srv, _acct, i, t, opt, dav_u, dav_g, cm);\n"
"\n"
"if (t = 1)\n"
"{\n"
"if (not WS.WS.ISCOL (WS.WS.HREF_TO_ARRAY (i, \'\')))\n"
"{\n"
"REPL_GET_DAV_UID_GID (dav_u, dav_g, dav_ui, dav_gi);\n"
"REPL_DAV_FILL (srv, i, dav_ui, dav_gi);\n"
"}\n"
"else\n"
"{\n"
"rollback work;\n"
"signal (\'37000\', concat (\'The WebDAV collection \'\'\', i, \'\'\' already exists\'), \'TR056\');\n"
"}\n"
"}\n"
"else if (t = 2)\n"
"{\n"
"REPL_SUBSCR_TBL (srv, _acct, i, _is_updatable);\n"
"for select TI_ITEM as tbl, DB_ADDRESS as dsn from DB.DBA.SYS_TP_ITEM, DB.DBA.SYS_SERVERS\n"
"where TI_SERVER = srv and TI_ACCT = _acct and TI_TYPE = 2 and SERVER = srv do\n"
"{\n"
"REPL_SUBSCR_TBL_FKS (srv, _acct, dsn, tbl);\n"
"}\n"
"\n"
"if (_is_updatable = 0)\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (sprintf (\'attach table %s from \'\'%s\'\'\', REPL_FQNAME (i), _server), _stat, _msg))\n"
"signal (_stat, _msg);\n"
"}\n"
"\n"
"src_table := att_local_name (_server, i);\n"
"src_cols := REPL_TBL_COLS (i);\n"
"sel := sprintf (\'insert into %s (%s) select %s from %s\',\n"
"REPL_FQNAME (i), src_cols, src_cols,\n"
"REPL_FQNAME (src_table));\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"set triggers off;\n"
"if (0 <> exec (sel, _stat, _msg))\n"
"{\n"
"set triggers on;\n"
"if (_is_updatable = 0)\n"
"{\n"
"exec (sprintf (\'drop table %s\', REPL_FQNAME (src_table)));\n"
"\n"
"signal (_stat, _msg);\n"
"}\n"
"}\n"
"else\n"
"set triggers on;\n"
"for (select VI_TABLE from  DB.DBA.SYS_VT_INDEX where upper(VI_TABLE) = upper(i)) do\n"
"{\n"
"exec (sprintf (\'\"%I\".\"%I\".\"VT_INDEX_%I\" ()\',\n"
"name_part (VI_TABLE, 0), name_part (VI_TABLE, 1),\n"
"DB.DBA.SYS_ALFANUM_NAME (replace (VI_TABLE, \'.\', \'_\'))));\n"
"}\n"
"\n"
"\n"
"commit work;\n"
"repl_set_raw(1);\n"
"if (_is_updatable = 0)\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (sprintf (\'drop table %s\', REPL_FQNAME (src_table)),\n"
"_stat, _msg))\n"
"{\n"
"\n"
"signal (_stat, _msg);\n"
"}\n"
"}\n"
"}\n"
"else if (t = 3)\n"
"{\n"
"declare rem_proc, proc_body varchar;\n"
"declare _mdta any;\n"
"_stat := \'00000\'; _msg := \'\';\n"
"rexecute (_server,\n"
"\'create view PROC_BODY as select P_NAME, coalesce (P_TEXT, blob_to_string (P_MORE)) as P_TEXT,\n"
"P_QUAL from DB.DBA.SYS_PROCEDURES\', _stat, _msg);\n"
"\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"exec (\'DB.DBA.vd_int_attach_table (?, \'\'DB.DBA.PROC_BODY\'\', NULL, NULL, NULL, vector (\'\'P_NAME\'\'), 1)\',\n"
"_stat, _msg, vector (_server));\n"
"\n"
"rem_proc := att_local_name (_server, \'DB.DBA.PROC_BODY\');\n"
"\n"
"_stat := \'00000\'; _msg := \'\';\n"
"\n"
"exec (sprintf (\'select P_TEXT from %s where P_NAME = \'\'%s\'\'\',\n"
"REPL_FQNAME (rem_proc), i),\n"
"_stat, _msg, vector (), 100, _mdta, _rrc);\n"
"\n"
"\n"
"proc_body :=  aref( aref(_rrc, 0), 0);\n"
"if (_stat = \'00000\' and isstring (proc_body))\n"
"{\n"
"\n"
"txt := proc_body;\n"
"_stat := \'00000\'; _msg := \'\';\n"
"if (substring (txt, 1, 7) = \'__repl \')\n"
"{\n"
"declare _off integer;\n"
"_off := strstr (lower (txt), \'create \');\n"
"txt := substring (txt, _off + 1, length (txt) - _off);\n"
"exec (txt, _stat, _msg);\n"
"\n"
"}\n"
"else\n"
"{\n"
"exec (txt, _stat, _msg);\n"
"\n"
"}\n"
"\n"
"if (_stat <> \'00000\')\n"
"signal (_stat, _msg);\n"
"}\n"
"else\n"
"signal (_stat, _msg);\n"
"}\n"
"\n"
"return;\n"
"}\n"
"--src repl.sql:2526\n"
;

static const char *proc51 = 
"#line 2689 \"[executable]/repl.sql\"\n"
"create procedure REPL_SERVER_RENAME (in old_name varchar, in new_name varchar)\n"
"{\n"
"declare rc varchar;\n"
"if (new_name <> repl_this_server ())\n"
"signal (\'42000\',\'The new name must be the same as in the ServerName (from INI file)\', \'TR057\');\n"
"if (old_name = repl_this_server ())\n"
"signal (\'42000\',\'The current name of server cannot be altered.\', \'TR059\');\n"
"if (exists (select 1 from SYS_SERVERS where SERVER = new_name))\n"
"signal (\'42000\',\'The name of new server used from another publishing server.\', \'TR060\');\n"
"if (exists (select 1 from SYS_REPL_ACCOUNTS a, SYS_REPL_ACCOUNTS b where a.SERVER = old_name and b.SERVER = new_name and a.ACCOUNT = b.ACCOUNT))\n"
"signal (\'42000\',sprintf (\'The publication on \'\'%s\'\' exists with the same name on \'\'%s\'\'. The rename operation cannot be performed.\', new_name, old_name), \'TR061\');\n"
"\n"
"declare exit handler for sqlexception { rc := __SQL_MESSAGE; };\n"
"{\n"
"delete from SYS_REPL_ACCOUNTS where SERVER = old_name and ACCOUNT = old_name;\n"
"for select ACCOUNT from SYS_REPL_ACCOUNTS where SERVER = old_name do\n"
"{\n"
"sequence_set (concat (\'repl_\', new_name, \'_\', ACCOUNT),\n"
"sequence_set (concat (\'repl_\', old_name, \'_\', ACCOUNT), 0, 2), 0);\n"
"}\n"
"update SYS_REPL_ACCOUNTS set SERVER = new_name where SERVER = old_name;\n"
"update SYS_TP_ITEM set TI_SERVER = new_name where TI_SERVER = old_name;\n"
"repl_changed ();\n"
"log_text (\'repl_changed ()\');\n"
"return;\n"
"}\n"
"rollback work;\n"
"signal (\'42000\', rc, \'TR058\');\n"
"}\n"
"--src repl.sql:2687\n"
;

static const char *proc52 = 
"#line 2721 \"[executable]/repl.sql\"\n"
"create procedure REPL_SYNC_ALL ()\n"
"{\n"
"DB.DBA.SYNC_REPL();\n"
"}\n"
"--src repl.sql:2719\n"
;

static const char *proc53 = 
"#line 2727 \"[executable]/repl.sql\"\n"
"create procedure REPL_ADD_CR (\n"
"in _tbl varchar,\n"
"\n"
"in _name_suffix varchar,\n"
"in _type char,\n"
"in _order integer,\n"
"in _class varchar,\n"
"in _coln varchar := null)\n"
"{\n"
"\n"
"_tbl := complete_table_name (_tbl, 1);\n"
"if (not exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = _tbl))\n"
"signal (\'37000\', concat (\'The table \\\'\' , _tbl, \'\\\' does not exist\'), \'TR128\');\n"
"\n"
"\n"
"if (length (_name_suffix) = 0)\n"
"signal (\'22023\', concat (\'Empty resolver name suffix\'), \'TR073\');\n"
"_name_suffix := SYS_ALFANUM_NAME (_name_suffix);\n"
"\n"
"\n"
"if (_type <> \'I\' and _type <> \'U\' and _type <> \'D\')\n"
"signal (\'22023\', concat (\'Invalid resolver type \\\'\', _type, \'\\\'\'), \'TR074\');\n"
"\n"
"\n"
"declare _cr_proc varchar;\n"
"declare _cr_proc_name varchar;\n"
"_cr_proc := sprintf (\'\"%I\".\"%I\".\"replcr_%s_%I_%s\"\',\n"
"name_part (_tbl, 0), name_part (_tbl, 1),\n"
"_type, name_part (_tbl, 2), _name_suffix);\n"
"_cr_proc_name := sprintf (\'%s.%s.replcr_%s_%s_%s\',\n"
"name_part (_tbl, 0), name_part (_tbl, 1),\n"
"_type, name_part (_tbl, 2), _name_suffix);\n"
"\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_REPL_CR\n"
"where CR_TABLE_NAME = _tbl and CR_PROC = _cr_proc_name))\n"
"{\n"
"signal (\'37000\',\n"
"concat (\'Conflict resolver for \\\'\', _tbl, \'\\\' with name \',\n"
"_cr_proc_name, \' already exists\'),\n"
"\'TR075\');\n"
"}\n"
"\n"
"declare _p, _allp, _oldp, _allcols varchar;\n"
"declare _coltemp, _colp, _oldcolp, _coltype varchar;\n"
"declare _pkcond varchar;\n"
"_p := \'\';\n"
"_allp := \'\';\n"
"_oldp := \'\';\n"
"_allcols := \'\';\n"
"_coltemp := \'\';\n"
"_colp := \'\';\n"
"_oldcolp := \'\';\n"
"_coltype := \'\';\n"
"_pkcond := \'\';\n"
"\n"
"declare _col any;\n"
"declare _ix, _len integer;\n"
"declare _col_name varchar;\n"
"declare _col_dtp integer;\n"
"\n"
"if (_class <> \'pub_wins\' and _class <> \'sub_wins\' and _class <> \'custom\')\n"
"{\n"
"if (length (_coln) = 0)\n"
"signal (\'22023\', \'Empty column name\', \'TR076\');\n"
"\n"
"\n"
"declare _pk_cols any;\n"
"_pk_cols := REPL_PK_COLS (_tbl);\n"
"_ix := 0;\n"
"_len := length (_pk_cols);\n"
"while (_ix < _len)\n"
"{\n"
"_col := aref (_pk_cols, _ix);\n"
"_col_name := aref (_col, 0);\n"
"\n"
"_pkcond := concat (_pkcond,\n"
"sprintf (\'\"%I\" = \"_%I\"\', _col_name, _col_name));\n"
"if (_ix + 1 < _len)\n"
"_pkcond := concat (_pkcond, \' and \');\n"
"_ix := _ix + 1;\n"
"}\n"
"}\n"
"else\n"
"_coln := \'\';\n"
"\n"
"\n"
"declare _cols any;\n"
"_cols := REPL_ALL_COLS (_tbl);\n"
"_ix := 0;\n"
"_len := length (_cols);\n"
"while (_ix < _len)\n"
"{\n"
"_col := aref (_cols, _ix);\n"
"_col_name := aref (_col, 0);\n"
"_col_dtp := aref (_col, 1);\n"
"\n"
"if (_col_dtp <> 128)\n"
"{\n"
"declare _ct varchar;\n"
"_ct := REPL_COLTYPE (_col);\n"
"_p := concat (_p, sprintf (\'inout \"_%I\" \', _col_name), _ct);\n"
"_allp := concat (_allp, sprintf (\'\"_%I\"\', _col_name));\n"
"_oldp := concat (_oldp, sprintf (\'inout \"__old_%I\" \', _col_name), _ct);\n"
"_allcols:= concat (_allcols, sprintf (\'\"%I\"\', _col_name));\n"
"if (_col_name = _coln)\n"
"_coltype := _ct;\n"
"\n"
"if (_ix + 1 < _len)\n"
"{\n"
"_p := concat (_p, \',\\n  \');\n"
"_allp := concat (_allp, \', \');\n"
"_oldp := concat (_oldp, \', \\n  \');\n"
"_allcols := concat (_allcols, \', \');\n"
"}\n"
"}\n"
"_ix := _ix + 1;\n"
"}\n"
"\n"
"if (_class <> \'pub_wins\' and _class <> \'sub_wins\' and _class <> \'custom\')\n"
"{\n"
"if (_coltype = \'\')\n"
"{\n"
"signal (\'37000\',\n"
"concat (\'No column \\\'\', _coln, \'\\\' in target table \\\'\', _tbl, \'\\\'\'),\n"
"\'TR077\');\n"
"}\n"
"_coltemp := sprintf (\'\"__temp_%I\"\', _coln);\n"
"_colp := sprintf (\'\"_%I\"\', _coln);\n"
"_oldcolp := sprintf (\'\"__old_%I\"\', _coln);\n"
"_coln := sprintf (\'\"%I\"\', _coln);\n"
"}\n"
"\n"
"\n"
"declare _stmt varchar;\n"
"_stmt := \'create procedure <CR_PROC> (\';\n"
"if (_type = \'I\')\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"<P>,\');\n"
"}\n"
"else if (_type = \'U\')\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"<P>,\n"
"<OLDP>,\');\n"
"}\n"
"else\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"<OLDP>,\');\n"
"}\n"
"_stmt := concat (_stmt, \'\n"
"inout __origin varchar)\n"
"{\');\n"
"if (_class = \'min\')\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"declare <COLTEMP> <COLTYPE>;\n"
"select <COLNAME> into <COLTEMP> from <FQTN> where <PKCOND>;\n"
"if (<COLTEMP> < <COLP>)\n"
"return 3; -\\- publisher wins\n"
"return 1;   -\\- subscriber wins\');\n"
"}\n"
"else if (_class = \'max\')\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"declare <COLTEMP> <COLTYPE>;\n"
"select <COLNAME> into <COLTEMP> from <FQTN> where <PKCOND>;\n"
"if (<COLTEMP> > <COLP>)\n"
"return 3; -\\- publisher wins\n"
"return 1;   -\\- subscriber wins\');\n"
"}\n"
"else if (_class = \'ave\')\n"
"{\n"
"\n"
"_stmt := concat (_stmt, \'\n"
"declare <COLTEMP> <COLTYPE>;\n"
"select <COLNAME> into <COLTEMP> from <FQTN> where <PKCOND>;\n"
"<COLP> := (<COLTEMP> + <COLP>) / 2;\n"
"return 2;   -\\- \"subscriber\" wins, change origin\');\n"
"}\n"
"else if (_class = \'add\')\n"
"{\n"
"\n"
"_stmt := concat (_stmt, \'\n"
"declare <COLTEMP> <COLTYPE>;\n"
"select <COLNAME> into <COLTEMP> from <FQTN> where <PKCOND>;\n"
"<COLP> := <COLTEMP> + (<COLP> - <OLDCOLP>);\n"
"return 2;   -\\- \"subscriber\" wins, change origin\');\n"
"}\n"
"else if (_class = \'pub_wins\' or _class = \'custom\')\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"return 3;   -\\- publisher wins\');\n"
"}\n"
"else if (_class = \'sub_wins\')\n"
"{\n"
"_stmt := concat (_stmt, \'\n"
"return 1;   -\\- subscriber wins\');\n"
"}\n"
"else\n"
"signal (\'22023\', concat (\'Invalid resolver class \\\'\', _class, \'\\\'\'), \'TR078\');\n"
"_stmt := concat (_stmt, \'\n"
"}\');\n"
"\n"
"\n"
"_stmt := replace (_stmt, \'<CR_PROC>\', _cr_proc);\n"
"_stmt := replace (_stmt, \'<FQTN>\', REPL_FQNAME (_tbl));\n"
"_stmt := replace (_stmt, \'<P>\', _p);\n"
"_stmt := replace (_stmt, \'<ALLP>\', _allp);\n"
"_stmt := replace (_stmt, \'<OLDP>\', _oldp);\n"
"_stmt := replace (_stmt, \'<ALLCOLS>\', _allcols);\n"
"_stmt := replace (_stmt, \'<PKCOND>\', _pkcond);\n"
"_stmt := replace (_stmt, \'<COLTEMP>\', _coltemp);\n"
"_stmt := replace (_stmt, \'<COLP>\', _colp);\n"
"_stmt := replace (_stmt, \'<OLDCOLP>\', _oldcolp);\n"
"_stmt := replace (_stmt, \'<COLTYPE>\', _coltype);\n"
"_stmt := replace (_stmt, \'<COLNAME>\', _coln);\n"
"\n"
"\n"
"\n"
"declare _stat, _msg varchar;\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (_stmt, _stat, _msg))\n"
"signal (_stat, _msg);\n"
"\n"
"\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"_stmt := \'insert into DB.DBA.SYS_REPL_CR (CR_ID, CR_TABLE_NAME, CR_TYPE, CR_PROC, CR_ORDER) values (coalesce ((select max(CR_ID) + 1 from DB.DBA.SYS_REPL_CR), 0), ?, ?, ?, ?)\';\n"
"if (0 <> exec (_stmt, _stat, _msg, vector (_tbl, _type, _cr_proc_name, _order)))\n"
"signal (_stat, _msg);\n"
"\n"
"return 0;\n"
"}\n"
"--src repl.sql:2725\n"
;

static const char *proc54 = 
"#line 2966 \"[executable]/repl.sql\"\n"
"create procedure REPL_IS_UPDATABLE (in _server varchar, in _account varchar)\n"
"{\n"
"declare _is_updatable integer;\n"
"\n"
"if (_server = repl_this_server())\n"
"{\n"
"declare exit handler for not found\n"
"signal (\'37000\', concat (\'The publication \'\'\', _account, \'\'\' does not exist\'), \'TR079\');\n"
"select IS_UPDATEABLE into _is_updatable from DB.DBA.SYS_REPL_ACCOUNTS\n"
"where SERVER = _server and ACCOUNT = _account;\n"
"}\n"
"else\n"
"{\n"
"declare exit handler for not found\n"
"signal (\'37000\', concat (\'The subscription \'\'\', _account, \'\'\' from \'\'\', _server, \'\'\' does not exist\'), \'TR004\');\n"
"select IS_UPDATEABLE into _is_updatable from DB.DBA.SYS_REPL_ACCOUNTS\n"
"where SERVER = _server and ACCOUNT = _account;\n"
"}\n"
"\n"
"return _is_updatable;\n"
"}\n"
"--src repl.sql:2964\n"
;

static const char *proc55 = 
"#line 2989 \"[executable]/repl.sql\"\n"
"create procedure REPL_DSN (in _server varchar)\n"
"{\n"
"declare _dsn varchar;\n"
"_dsn := null;\n"
"whenever not found goto nf;\n"
"select DB_ADDRESS into _dsn from DB.DBA.SYS_SERVERS where SERVER = _server;\n"
"nf:\n"
"return _dsn;\n"
"}\n"
"--src repl.sql:2987\n"
;

static const char *proc56 = 
"#line 3000 \"[executable]/repl.sql\"\n"
"create procedure REPL_ENSURE_RDS (\n"
"in _dsn varchar, in _usr varchar, in _pwd varchar)\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_DATA_SOURCE where DS_DSN = _dsn))\n"
"{\n"
"if (_usr is not null and _pwd is not null)\n"
"DB..vd_remote_data_source (_dsn, \'\', _usr, _pwd);\n"
"else\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"declare tu, tp any;\n"
"declare exit handler for not found {\n"
"signal (\'42000\', \'The DSN for publisher is missing\');\n"
"};\n"
"select DS_UID, pwd_magic_calc (DS_UID, DS_PWD, 1) into tu, tp from DB.DBA.SYS_DATA_SOURCE where DS_DSN = _dsn;\n"
"if ((tu <> _usr or _pwd <> tp) and (_usr is not null and _pwd is not null))\n"
"DB..vd_remote_data_source (_dsn, \'\', _usr, _pwd);\n"
"}\n"
"return 0;\n"
"}\n"
"--src repl.sql:2998\n"
;

static const char *proc57 = 
"#line 3024 \"[executable]/repl.sql\"\n"
"create procedure REPL_ENSURE_TABLE_ATTACHED (\n"
"in _dsn varchar, in _tbl varchar, in _local_tbl varchar := null)\n"
"returns varchar\n"
"{\n"
"if (_local_tbl is null)\n"
"_local_tbl := att_local_name(_dsn, _tbl);\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = _local_tbl))\n"
"{\n"
"declare _stat, _msg varchar;\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (\'vd_attach_table (?, ?, ?, null, null)\', _stat, _msg,\n"
"vector (_dsn, _tbl, _local_tbl)))\n"
"signal (_stat, _msg);\n"
"}\n"
"return _local_tbl;\n"
"}\n"
"--src repl.sql:3022\n"
;

static const char *proc58 = 
"#line 3044 \"[executable]/repl.sql\"\n"
"create procedure REPL_ENSURE_VIEW_ATTACHED (\n"
"in _dsn varchar, in _tbl varchar, in _pklist any)\n"
"returns varchar\n"
"{\n"
"declare _local_tbl varchar;\n"
"_local_tbl := att_local_name(_dsn, _tbl);\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = _local_tbl))\n"
"{\n"
"declare _stat, _msg varchar;\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"if (0 <> exec (\'vd_attach_view (?, ?, ?, null, null, ?)\',\n"
"_stat, _msg, vector (_dsn, _tbl, _local_tbl, _pklist)))\n"
"signal (_stat, _msg);\n"
"}\n"
"return _local_tbl;\n"
"}\n"
"--src repl.sql:3042\n"
;

static const char *proc59 = 
"#line 3064 \"[executable]/repl.sql\"\n"
"create procedure DB.DBA.REPL_TRX_CHECK ()\n"
"{\n"
"declare ini, cur varchar;\n"
"ini := repl_this_server ();\n"
"cur := registry_get (\'__repl_this_server\');\n"
"if (isstring (cur) and isstring (ini) and cur <> ini and exists (select top 1 1 from DB.DBA.SYS_TP_ITEM))\n"
"{\n"
"log_message (\'The ServerName parameter has been altered while there are replication\');\n"
"log_message (\'settings relying on this name being constant.  To start the server, please\');\n"
"log_message (sprintf (\'set the ServerName in the ini to \"%s\" <former value> or remove it.\', cur));\n"
"log_message (\'In order to have a new name for this database, drop all transactional\');\n"
"log_message (\'replication related  publications and subscriptions and restart with the new\');\n"
"log_message (\'name in the ini.  This may be done without loss of data  but any\');\n"
"log_message (\'publications or subscriptions   must be redefined using the appropriate API\');\n"
"log_message (\'or Conductor interface.\');\n"
"raw_exit ();\n"
"}\n"
"else if (isstring (ini))\n"
"{\n"
"registry_set (\'__repl_this_server\', ini);\n"
"}\n"
"}\n"
"--src repl.sql:3062\n"
;


static const char *other4 = 
" DB.DBA.REPL_TRX_CHECK ()\n";
static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_repl (void)
{
  /* snapshot_repl.sql */

  ddl_ensure_table ("DB.DBA.SYS_SNAPSHOT", tbl0);
  ddl_ensure_column ("SYS_SNAPSHOT", "SN_LAST_UPD_BM", alter0, 0);
  ddl_ensure_table ("DB.DBA.SYS_SNAPSHOT_LOG", tbl1);
  DEFINE_PROC ("REPL_OFFSET_TIME", proc0);
  DEFINE_PROC ("REPL_ORIGIN", proc1);
  DEFINE_PROC ("REPL_SET_ORIGIN", proc2);
  ddl_ensure_table ("DB.DBA.SYS_SNAPSHOT_PUB", tbl2);
  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("DB.DBA.SYS_SNAPSHOT_SUB", tbl3);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("DB.DBA.SYS_SNAPSHOT_CR", tbl4);
  ddl_ensure_table ("do this always", other2);
  ddl_ensure_table ("DB.DBA.SYS_DAV_CR", tbl5);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("DB.DBA.SYS_REPL_POSTPONED_RES", tbl6);
  DEFINE_PROC ("REPL_REMOTE_TYPES_RAW", proc3);
  DEFINE_PROC ("REPL_REMOTE_TYPES", proc4);
  DEFINE_PROC ("REPL_ALL_COLS", proc5);
  DEFINE_PROC ("REPL_TBL_COLS", proc6);
  DEFINE_PROC ("REPL_COMPLETE_COLNAME", proc7);
  ddl_ensure_table ("WS.WS.RPLOG_SYS_DAV_RES", tbl7);
  DEFINE_PROC ("REPL_DAV_STORE_RES_INT", proc8);
  DEFINE_PROC ("REPL_DAV_STORE_RES", proc9);
  ddl_std_proc (trig0, 0x0);
  DEFINE_PROC ("REPL_DAV_SAVE_BACKUP", proc10);

  /* repl.sql */

  DEFINE_PROC ("REPL_PUB_REMOVE", proc11);
  DEFINE_PROC ("REPL_SERVER", proc12);
  DEFINE_PROC ("REPL_SYNC_USER", proc13);
  DEFINE_PROC ("REPL_PUBLISH", proc14);
  DEFINE_PROC ("REPL_UNPUBLISH", proc15);
  DEFINE_PROC ("REPL_UNSUBSCRIBE", proc16);
  DEFINE_PROC ("DEL_CHILD_COLLS", proc17);
  DEFINE_PROC ("REPL_SUBSCRIBE", proc18);
  DEFINE_PROC ("REPL_SCHED_INIT", proc19);
  DEFINE_PROC ("SYNC_REPL", proc20);
  DEFINE_PROC ("SUB_SCHEDULE", proc21);
  DEFINE_PROC ("REPL_STAT", proc22);
  DEFINE_PROC ("REPL_GET_DAV_UID_GID", proc23);
  DEFINE_PROC ("REPL_PUB_INIT_IMAGE", proc24);
  DEFINE_PROC ("BACKUP_CHILDREN_COL", proc25);
  DEFINE_PROC ("REPL_DAV_GET_USER_GROUP", proc26);
  DEFINE_PROC ("DAV_COL_I", proc27);
  DEFINE_PROC ("DAV_COL_U", proc28);
  DEFINE_PROC ("DAV_COL_D", proc29);
  DEFINE_PROC ("DAV_RES_I", proc30);
  DEFINE_PROC ("DAV_RES_D", proc31);
  DEFINE_PROC ("REPL_PUB_ADD_CHECK_PROC", proc32);
  DEFINE_PROC ("REPL_PUB_ADD", proc33);
  DEFINE_PROC ("REPL_PROC_MODE", proc34);
  DEFINE_PROC ("REPL_PUB_TBL", proc35);
  DEFINE_PROC ("REPL_SUBSCR_TBL_FKS", proc36);
  DEFINE_PROC ("REPL_PRINT_COL_DEF", proc37); 
  DEFINE_OVERWRITE_PROC ("__INT_REPL_ALTER_ADD_COL", proc38); 
  DEFINE_OVERWRITE_PROC ("__INT_REPL_ALTER_DROP_COL", proc39); 
  DEFINE_OVERWRITE_PROC ("__INT_REPL_ALTER_REDO_TRIGGERS", proc40);
  DEFINE_PROC ("__REPL_DDL_FK_MODIFY_PROPAGATE", proc41);
  DEFINE_PROC ("REPL_SUBSCR_TBL", proc42);
  DEFINE_PROC ("__REPL_SUBSCR_TBL_TRIGGERS", proc43);
  DEFINE_PROC ("REPL_GRANT", proc44);
  DEFINE_PROC ("REPL_REVOKE", proc45);
  DEFINE_PROC ("REPL_DAV_PROC", proc46);
  DEFINE_PROC ("DAV_MKCOL", proc47);
  DEFINE_PROC ("REPL_DAV_FILL", proc48);
  DEFINE_PROC ("REPL_INIT_COPY", proc49);
  DEFINE_PROC ("REPL_SUB_ITEM", proc50);
  DEFINE_PROC ("REPL_SERVER_RENAME", proc51);
  DEFINE_PROC ("REPL_SYNC_ALL", proc52);
  DEFINE_PROC ("REPL_ADD_CR", proc53);
  DEFINE_PROC ("REPL_IS_UPDATABLE", proc54);
  DEFINE_PROC ("REPL_DSN", proc55);
  DEFINE_PROC ("REPL_ENSURE_RDS", proc56);
  DEFINE_PROC ("REPL_ENSURE_TABLE_ATTACHED", proc57);
  DEFINE_PROC ("REPL_ENSURE_VIEW_ATTACHED", proc58);
  DEFINE_PROC ("DB.DBA.REPL_TRX_CHECK", proc59);
}


void
sqls_arfw_define_repl (void)
{
  /* ./repl.sql */

  ddl_ensure_table ("do this always", other4);
}
