/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import openlink.util.MD5;
import virtuoso.jdbc4.LRUCache;
import virtuoso.jdbc4.VirtX509KeyManager;
import virtuoso.jdbc4.VirtX509TrustManager;
import virtuoso.jdbc4.VirtuosoArray;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoCallableStatement;
import virtuoso.jdbc4.VirtuosoDatabaseMetaData;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoExplicitString;
import virtuoso.jdbc4.VirtuosoFNSException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoInputStream;
import virtuoso.jdbc4.VirtuosoOutputStream;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.jdbc4.VirtuosoPreparedStatement;
import virtuoso.jdbc4.VirtuosoStatement;
import virtuoso.jdbc4.VirtuosoXAConnection;

public class VirtuosoConnection
implements Connection {
    private Socket socket;
    private VirtuosoInputStream in;
    private VirtuosoOutputStream out;
    private Hashtable<Integer, VirtuosoFuture> futures;
    private int req_no;
    private int con_no;
    private static int global_con_no = 0;
    protected String qualifier;
    private String version;
    private int _case;
    protected openlink.util.Vector client_defaults;
    protected openlink.util.Vector client_charset;
    protected Hashtable<Character, Byte> client_charset_hash;
    protected SQLWarning warning = null;
    private String peer_name;
    private boolean auto_commit = true;
    private boolean global_transaction = false;
    private String url;
    private String user;
    private String password;
    private String pwdclear;
    private String cert_alias;
    private String keystore_path;
    private String keystore_pass;
    private String truststore_path;
    private String truststore_pass;
    private String ssl_provider;
    private boolean use_ssl;
    private String con_delegate;
    private int trxisolation = 4;
    private boolean readOnly = false;
    protected int timeout_def = 60000;
    protected int timeout = 0;
    protected int txn_timeout = 0;
    protected int fbs = 100;
    protected boolean utf8_execs = false;
    protected int timezoneless_datetimes = 0;
    protected VirtuosoPooledConnection pooled_connection = null;
    protected VirtuosoXAConnection xa_connection = null;
    protected String charset;
    protected boolean charset_utf8 = false;
    protected Hashtable<Integer, String> rdf_type_hash = null;
    protected Hashtable<Integer, String> rdf_lang_hash = null;
    protected Hashtable<String, Integer> rdf_type_rev = null;
    protected Hashtable<String, Integer> rdf_lang_rev = null;
    private LRUCache<String, VirtuosoPreparedStatement> pStatementCache;
    private boolean useCachePrepStatements = false;
    private Vector<VhostRec> hostList = new Vector();
    protected boolean rdf_type_loaded = false;
    protected boolean rdf_lang_loaded = false;
    private static final SQLPermission SET_NETWORK_TIMEOUT_PERM = new SQLPermission("setNetworkTimeout");
    private static final SQLPermission ABORT_PERM = new SQLPermission("abort");
    private boolean useRoundRobin;
    private boolean oAutoCommit;
    private int oTxnIsolation;
    private boolean oReadOnly;
    private int oNetworkTimeout;
    private int oHoldability;
    private String oCatalog;
    private volatile SQLWarning oSqlWarnings;
    private boolean oUseCachePrepStatements;
    private HashMap<VirtuosoStatement, Object> objsToClose = new HashMap();
    private volatile int requestStarted = 0;

    protected Vector<VhostRec> parse_vhost(String vhost, String _host, int _port) throws VirtuosoException {
        Vector<VhostRec> hostlist = new Vector<VhostRec>();
        String port = Integer.toString(_port);
        String attr = null;
        StringBuffer buff = new StringBuffer();
        block4: for (int i = 0; i < vhost.length(); ++i) {
            char c = vhost.charAt(i);
            switch (c) {
                case ',': {
                    String val = buff.toString().trim();
                    if (attr == null) {
                        attr = val;
                        val = port;
                    }
                    if (attr != null && attr.length() > 0) {
                        hostlist.add(new VhostRec(attr, val));
                    }
                    attr = null;
                    buff.setLength(0);
                    continue block4;
                }
                case ':': {
                    attr = buff.toString().trim();
                    buff.setLength(0);
                    continue block4;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        String val = buff.toString().trim();
        if (attr == null) {
            attr = val;
            val = port;
        }
        if (attr != null && attr.length() > 0) {
            hostlist.add(new VhostRec(attr, val));
        }
        if (hostlist.size() == 0) {
            hostlist.add(new VhostRec(_host, _port));
        }
        return hostlist;
    }

    private synchronized int getNextRoundRobinHostIndex() {
        int indexRange = this.hostList.size();
        return (int)(Math.random() * (double)indexRange);
    }

    VirtuosoConnection(String url, String host, int port, Properties prop) throws VirtuosoException {
        int sendbs = 32768;
        int recvbs = 32768;
        this.hostList = this.parse_vhost(prop.getProperty("_vhost", ""), host, port);
        this.req_no = 0;
        this.url = url;
        this.con_no = global_con_no++;
        if (prop.get("charset") != null) {
            this.charset = (String)prop.get("charset");
            if (this.charset.toUpperCase().indexOf("UTF-8") != -1) {
                this.charset = null;
                this.charset_utf8 = true;
            }
        }
        this.user = (String)prop.get("user");
        if (this.user == null || this.user.equals("")) {
            this.user = "";
        }
        this.password = (String)prop.get("password");
        if (this.password == null) {
            this.password = "";
        }
        this.timeout = this.getIntAttr(prop, "timeout", this.timeout) * 1000;
        this.pwdclear = (String)prop.get("pwdclear");
        if ((sendbs = this.getIntAttr(prop, "sendbs", sendbs)) <= 0) {
            sendbs = 32768;
        }
        if ((recvbs = this.getIntAttr(prop, "recvbs", recvbs)) <= 0) {
            recvbs = 32768;
        }
        this.fbs = this.getIntAttr(prop, "fbs", this.fbs);
        if (this.fbs <= 0) {
            this.fbs = 100;
        }
        this.truststore_path = (String)prop.get("truststorepath");
        this.truststore_pass = (String)prop.get("truststorepass");
        this.keystore_pass = (String)prop.get("keystorepass");
        this.keystore_path = (String)prop.get("keystorepath");
        this.ssl_provider = (String)prop.get("provider");
        this.cert_alias = (String)prop.get("cert");
        this.use_ssl = this.getBoolAttr(prop, "ssl", false);
        this.con_delegate = (String)prop.get("delegate");
        if (this.pwdclear == null) {
            this.pwdclear = "0";
        }
        this.futures = new Hashtable();
        this.rdf_type_hash = new Hashtable();
        this.rdf_lang_hash = new Hashtable();
        this.rdf_type_rev = new Hashtable();
        this.rdf_lang_rev = new Hashtable();
        this.useCachePrepStatements = this.getBoolAttr(prop, "usepstmtpool", false);
        int poolSize = this.getIntAttr(prop, "pstmtpoolsize", 25);
        this.createCaches(poolSize);
        this.useRoundRobin = this.getBoolAttr(prop, "roundrobin", false);
        if (this.hostList.size() <= 1) {
            this.useRoundRobin = false;
        }
        this.connect(host, port, (String)prop.get("database"), sendbs, recvbs, prop.get("log_enable") != null ? Integer.parseInt(prop.getProperty("log_enable")) : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnectionLost(int timeout_sec) {
        ResultSet rs = null;
        Statement st = null;
        try {
            st = this.createStatement();
            st.setQueryTimeout(timeout_sec);
            rs = st.executeQuery("select 1");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected int getIntAttr(Properties info, String key, int def) {
        int ret = def;
        String val = info.getProperty(key);
        try {
            if (val != null && val.length() > 0) {
                ret = Integer.parseInt(val);
            }
        }
        catch (NumberFormatException e) {
            ret = def;
        }
        return ret;
    }

    protected boolean getBoolAttr(Properties info, String key, boolean def) {
        boolean ret = def;
        String val = info.getProperty(key);
        if (val != null && val.length() > 0) {
            char c = val.charAt(0);
            return c == 'Y' || c == 'y' || c == '1';
        }
        return def;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connect(String host, int port, String db, int sendbs, int recvbs, int log_enable) throws VirtuosoException {
        int hostIndex = 0;
        int startIndex = 0;
        if (this.hostList.size() > 1 && this.useRoundRobin) {
            startIndex = hostIndex = this.getNextRoundRobinHostIndex();
        }
        while (true) {
            try {
                if (this.hostList.size() == 0) {
                    this.connect(host, port, sendbs, recvbs);
                    break;
                }
                VhostRec v = this.hostList.elementAt(hostIndex);
                this.connect(v.host, v.port, sendbs, recvbs);
            }
            catch (VirtuosoException e) {
                int erc = e.getErrorCode();
                if (erc != -3 && erc != -15) {
                    throw e;
                }
                ++hostIndex;
                if (this.useRoundRobin) {
                    if (this.hostList.size() == hostIndex) {
                        hostIndex = 0;
                    }
                    if (hostIndex != startIndex) continue;
                    throw e;
                }
                if (this.hostList.size() == hostIndex) throw e;
                continue;
            }
            break;
        }
        if (db != null) {
            try {
                new VirtuosoStatement(this).executeQuery("use " + db);
            }
            catch (VirtuosoException ve) {
                throw new VirtuosoException(ve, "Could not execute 'use " + db + "'", -8);
            }
        }
        if (log_enable < 0 || log_enable > 3) return;
        try {
            new VirtuosoStatement(this).executeQuery("log_enable (" + log_enable + ")");
            return;
        }
        catch (VirtuosoException ve) {
            throw new VirtuosoException(ve, "Could not execute 'log_enable(" + log_enable + ")'", -8);
        }
    }

    private long cdef_param(openlink.util.Vector cdefs, String name, long deflt) {
        int len = cdefs != null ? cdefs.size() : 0;
        for (int inx = 0; inx < len; inx += 2) {
            if (!name.equals((String)cdefs.elementAt(inx))) continue;
            return ((Number)cdefs.elementAt(inx + 1)).longValue();
        }
        return deflt;
    }

    private Object[] fill_login_info_array() {
        Object[] ret = new Object[]{new String("JDBC"), 0, new String(""), System.getProperty("os.name"), new String(""), 0, new String(this.con_delegate != null ? this.con_delegate : "")};
        return ret;
    }

    private Collection getCertificates(InputStream fis) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificates(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String host, int port, int sendbs, int recvbs) throws VirtuosoException {
        String fname = null;
        try {
            Object ssl_ctx;
            if (this.use_ssl || this.truststore_path != null || this.keystore_path != null) {
                String keys_pwd;
                if (this.ssl_provider != null && this.ssl_provider.length() != 0) {
                    Security.addProvider((Provider)Class.forName(this.ssl_provider).newInstance());
                }
                ssl_ctx = SSLContext.getInstance("TLS");
                VirtX509TrustManager tm = new VirtX509TrustManager();
                KeyManager[] km = null;
                TrustManager[] tma = null;
                KeyStore tks = null;
                if (this.truststore_path.length() > 0) {
                    InputStream fis = null;
                    keys_pwd = this.truststore_pass != null ? this.truststore_pass : "";
                    String alg = TrustManagerFactory.getDefaultAlgorithm();
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(alg);
                    tks = KeyStore.getInstance("JKS");
                    try {
                        fname = this.truststore_path;
                        fis = new FileInputStream(this.truststore_path);
                        if (this.truststore_path.endsWith(".pem") || this.truststore_path.endsWith(".crt") || this.truststore_path.endsWith(".p7b")) {
                            tks.load(null);
                            Collection certs = this.getCertificates(fis);
                            if (certs != null) {
                                int i = 0;
                                Iterator it = certs.iterator();
                                while (it.hasNext()) {
                                    tks.setCertificateEntry("cert" + i, (Certificate)it.next());
                                    ++i;
                                }
                            }
                        } else {
                            tks.load(fis, keys_pwd.toCharArray());
                        }
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    tmf.init(tks);
                    tma = tmf.getTrustManagers();
                } else {
                    tma = new TrustManager[]{tm};
                }
                if (this.keystore_path.length() > 0 && this.keystore_pass.length() > 0) {
                    String keys_file = this.keystore_path != null ? this.keystore_path : System.getProperty("user.home") + System.getProperty("file.separator");
                    keys_pwd = this.keystore_pass != null ? this.keystore_pass : "";
                    fname = keys_file;
                    km = new KeyManager[]{new VirtX509KeyManager(this.cert_alias, keys_file, keys_pwd, tks)};
                }
                ((SSLContext)ssl_ctx).init(km, tma, new SecureRandom());
                this.socket = ((SSLContext)ssl_ctx).getSocketFactory().createSocket(host, port);
                ((SSLSocket)this.socket).startHandshake();
            } else {
                this.socket = new Socket(host, port);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(recvbs);
            this.socket.setSendBufferSize(sendbs);
            this.in = new VirtuosoInputStream(this, this.socket, recvbs);
            this.out = new VirtuosoOutputStream(this, this.socket, sendbs);
            ssl_ctx = this;
            synchronized (ssl_ctx) {
                VirtuosoFuture future;
                block53: {
                    block52: {
                        Object[] caller_id_args = new Object[]{null};
                        future = this.getFuture("caller_identification", caller_id_args, this.timeout);
                        openlink.util.Vector result_future = (openlink.util.Vector)future.nextResult().firstElement();
                        this.peer_name = (String)result_future.elementAt(1);
                        if (result_future.size() > 2) {
                            openlink.util.Vector caller_id_opts = (openlink.util.Vector)result_future.elementAt(2);
                            int pwd_clear_code = (int)this.cdef_param(caller_id_opts, "SQL_ENCRYPTION_ON_PASSWORD", 3L);
                            switch (pwd_clear_code) {
                                case 1: {
                                    this.pwdclear = "cleartext";
                                    break;
                                }
                                case 2: {
                                    this.pwdclear = "encrypt";
                                    break;
                                }
                                case 0: {
                                    this.pwdclear = "digest";
                                }
                            }
                        }
                        this.removeFuture(future);
                        Object[] args = new Object[]{this.user, this.pwdclear != null && this.pwdclear.equals("cleartext") ? this.password : (this.pwdclear != null && this.pwdclear.equals("encrypt") ? MD5.pwd_magic_encrypt(this.user, this.password) : MD5.md5_digest(this.user, this.password, this.peer_name)), "05.12.3039", new openlink.util.Vector(this.fill_login_info_array())};
                        future = this.getFuture("SCON", args, this.timeout);
                        result_future = future.nextResult();
                        if (result_future.firstElement() instanceof Short) break block52;
                        result_future = (openlink.util.Vector)result_future.firstElement();
                        switch (((Number)result_future.firstElement()).shortValue()) {
                            case 9: {
                                this.qualifier = (String)result_future.elementAt(1);
                                this.version = (String)result_future.elementAt(2);
                                int con_db_gen = Integer.parseInt(this.version.substring(6));
                                if (con_db_gen < 2303) {
                                    throw new VirtuosoException("Old server version", -17);
                                }
                                this._case = ((Number)result_future.elementAt(3)).intValue();
                                this.client_defaults = result_future.size() > 3 ? (openlink.util.Vector)result_future.elementAt(4) : null;
                                Object obj = null;
                                if (result_future.size() > 4) {
                                    obj = result_future.elementAt(5);
                                }
                                if (obj instanceof openlink.util.Vector) {
                                    this.client_charset = (openlink.util.Vector)obj;
                                    String table = (String)this.client_charset.elementAt(1);
                                    this.client_charset_hash = new Hashtable(256);
                                    for (int i = 0; i < 255; ++i) {
                                        if (i < table.length()) {
                                            this.client_charset_hash.put(Character.valueOf(table.charAt(i)), (byte)(i + 1));
                                            continue;
                                        }
                                        this.client_charset_hash.put(Character.valueOf((char)(i + 1)), (byte)(i + 1));
                                    }
                                } else {
                                    this.client_charset = null;
                                }
                                if (this.timeout <= 0) {
                                    this.timeout = (int)this.cdef_param(this.client_defaults, "SQL_QUERY_TIMEOUT", this.timeout_def);
                                }
                                if (this.timeout > 0) {
                                    this.socket.setSoTimeout(this.timeout);
                                }
                                if (this.txn_timeout <= 0) {
                                    this.txn_timeout = (int)(this.cdef_param(this.client_defaults, "SQL_TXN_TIMEOUT", this.txn_timeout * 1000) / 1000L);
                                }
                                this.trxisolation = (int)this.cdef_param(this.client_defaults, "SQL_TXN_ISOLATION", this.trxisolation);
                                boolean bl = this.utf8_execs = this.cdef_param(this.client_defaults, "SQL_UTF8_EXECS", 0L) != 0L;
                                if (!this.utf8_execs && this.cdef_param(this.client_defaults, "SQL_NO_CHAR_C_ESCAPE", 0L) != 0L) {
                                    throw new VirtuosoException("Not using UTF-8 encoding of SQL statements, but processing character escapes also disabled", -17);
                                }
                                this.timezoneless_datetimes = (int)this.cdef_param(this.client_defaults, "SQL_TIMEZONELESS_DATETIMES", 0L);
                                break block53;
                            }
                            case 3: {
                                this.removeFuture(future);
                                throw new VirtuosoException((String)result_future.elementAt(1) + " " + (String)result_future.elementAt(2), -15);
                            }
                            default: {
                                this.removeFuture(future);
                                throw new VirtuosoException(result_future.toString(), -16);
                            }
                        }
                    }
                    this.removeFuture(future);
                    throw new VirtuosoException("Bad login.", -5);
                }
                this.removeFuture(future);
            }
        }
        catch (NoClassDefFoundError e) {
            throw new VirtuosoException("Class not found: " + e.getMessage(), -17);
        }
        catch (FileNotFoundException e) {
            throw new VirtuosoException("Connection failed: " + e.getMessage(), -3);
        }
        catch (IOException e) {
            throw new VirtuosoException("Connection failed: [" + (fname != null ? fname : "") + "] " + e.getMessage(), -3);
        }
        catch (ClassNotFoundException e) {
            throw new VirtuosoException("Class not found: " + e.getMessage(), -17);
        }
        catch (InstantiationException e) {
            throw new VirtuosoException("Class cannot be created: " + e.getMessage(), -17);
        }
        catch (IllegalAccessException e) {
            throw new VirtuosoException("Class cannot be accessed: " + e.getMessage(), -17);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VirtuosoException("Encryption failed: " + e.getMessage(), -17);
        }
        catch (KeyStoreException e) {
            throw new VirtuosoException("Encryption failed: " + e.getMessage(), -17);
        }
        catch (KeyManagementException e) {
            throw new VirtuosoException("Encryption failed: " + e.getMessage(), -17);
        }
        catch (CertificateException e) {
            throw new VirtuosoException("Encryption failed: " + e.getMessage(), -17);
        }
        catch (UnrecoverableKeyException e) {
            throw new VirtuosoException("Encryption failed: [" + (fname != null ? fname : "") + "]" + e.getMessage(), -17);
        }
    }

    protected void write_object(Object obj) throws IOException, VirtuosoException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.print("  >> (conn " + this.hashCode() + ") OUT ");
            VirtuosoFuture.rpc_log.println(obj != null ? obj.toString() : "<null>");
        }
        try {
            this.out.write_object(obj);
            this.out.flush();
        }
        catch (IOException ex) {
            if (this.pooled_connection != null) {
                VirtuosoException vex = new VirtuosoException("Connection failed: " + ex.getMessage(), -3);
                this.pooled_connection.sendErrorEvent(vex);
                throw vex;
            }
            throw ex;
        }
        catch (VirtuosoException ex) {
            int code;
            if (this.pooled_connection != null && ((code = ex.getErrorCode()) == -1 || code == -3)) {
                this.pooled_connection.sendErrorEvent(ex);
            }
            throw ex;
        }
    }

    protected void write_bytes(byte[] bytes) throws IOException, VirtuosoException {
        try {
            for (int k = 0; k < bytes.length; ++k) {
                this.out.write(bytes[k]);
            }
            this.out.flush();
        }
        catch (IOException ex) {
            if (this.pooled_connection != null) {
                VirtuosoException vex = new VirtuosoException("Connection failed: " + ex.getMessage(), -3);
                this.pooled_connection.sendErrorEvent(vex);
                throw vex;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtuosoFuture getFuture(String rpcname, Object[] args, int timeout) throws IOException, VirtuosoException {
        int this_req_no;
        VirtuosoFuture fut = null;
        if (this.futures == null) {
            throw new VirtuosoException("Activity on a closed connection", "IM001", -8);
        }
        Hashtable<Integer, VirtuosoFuture> hashtable = this.futures;
        synchronized (hashtable) {
            this_req_no = this.req_no++;
        }
        fut = new VirtuosoFuture(this, rpcname, args, this_req_no, timeout);
        this.futures.put(this_req_no, fut);
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFutures() {
        if (this.futures != null) {
            Hashtable<Integer, VirtuosoFuture> hashtable = this.futures;
            synchronized (hashtable) {
                this.futures.clear();
            }
        }
    }

    protected void removeFuture(VirtuosoFuture fut) {
        if (this.futures != null) {
            this.futures.remove(fut.hashCode());
        }
    }

    protected boolean read_request() throws IOException, VirtuosoException {
        Object _result;
        if (this.futures == null) {
            throw new VirtuosoException("Activity on a closed connection", "IM001", -8);
        }
        try {
            _result = this.in.read_object();
        }
        catch (IOException ex) {
            if (this.pooled_connection != null) {
                VirtuosoException vex = new VirtuosoException("Connection failed: " + ex.getMessage(), -3);
                this.pooled_connection.sendErrorEvent(vex);
                throw vex;
            }
            throw ex;
        }
        catch (VirtuosoException ex) {
            int code;
            if (this.pooled_connection != null && ((code = ex.getErrorCode()) == -1 || code == -3)) {
                this.pooled_connection.sendErrorEvent(ex);
            }
            throw ex;
        }
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.print("  << (conn " + this.hashCode() + ") IN ");
            VirtuosoFuture.rpc_log.println(_result != null ? _result.toString() : "<null>");
        }
        try {
            openlink.util.Vector result = (openlink.util.Vector)_result;
            Object tag = result.firstElement();
            if ((Short)tag != 2 && (Short)tag != 3) {
                return false;
            }
            VirtuosoFuture fut = this.futures.get(((Number)result.elementAt(1)).intValue());
            if (fut == null) {
                return false;
            }
            fut.putResult(result.elementAt(2));
            fut.complete((Short)tag == 2);
            return true;
        }
        catch (ClassCastException e) {
            if (VirtuosoFuture.rpc_log != null) {
                VirtuosoFuture.rpc_log.println("  **(conn " + this.hashCode() + ") **** runtime2 " + e.getClass().getName() + " in read_request");
                e.printStackTrace(VirtuosoFuture.rpc_log);
            }
            throw new Error(e.getClass().getName() + ":" + e.getMessage());
        }
    }

    protected String getURL() {
        return this.url;
    }

    protected String getUserName() {
        return this.user;
    }

    protected String getQualifierName() {
        return this.qualifier;
    }

    protected String getVersion() {
        return this.version;
    }

    protected int getVersionNum() {
        try {
            return Integer.valueOf(this.version.substring(6, 10));
        }
        catch (Exception e) {
            return 1619;
        }
    }

    protected int getCase() {
        return this._case;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    @Override
    public void clearWarnings() throws VirtuosoException {
        this.warning = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws VirtuosoException {
        if (this.isClosed()) {
            return;
        }
        try {
            VirtuosoConnection virtuosoConnection = this;
            synchronized (virtuosoConnection) {
                if (!this.in.isClosed()) {
                    this.in.close();
                    this.in = null;
                }
                if (!this.out.isClosed()) {
                    this.out.close();
                    this.out = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.pStatementCache.clear();
                this.password = null;
                this.url = null;
                this.user = null;
                this.futures = null;
                this.pooled_connection = null;
                this.xa_connection = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void commit() throws VirtuosoException {
        if (this.global_transaction) {
            throw new VirtuosoException("Cannot commit while in global transaction.", -4);
        }
        try {
            Object _err;
            Object[] args = new Object[]{0L, null};
            VirtuosoFuture fut = this.getFuture("TRXC", args, this.timeout);
            openlink.util.Vector trsres = fut.nextResult();
            Object object = _err = trsres == null ? null : trsres.firstElement();
            if (_err instanceof openlink.util.Vector) {
                openlink.util.Vector err = (openlink.util.Vector)_err;
                throw new VirtuosoException((String)err.elementAt(2), (String)err.elementAt(1), -8);
            }
            this.removeFuture(fut);
        }
        catch (IOException e) {
            throw new VirtuosoException("Connection failed: " + e.getMessage(), -3);
        }
    }

    @Override
    public Statement createStatement() throws VirtuosoException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public boolean getAutoCommit() throws VirtuosoException {
        return this.auto_commit;
    }

    @Override
    public DatabaseMetaData getMetaData() throws VirtuosoException {
        return new VirtuosoDatabaseMetaData(this);
    }

    @Override
    public SQLWarning getWarnings() throws VirtuosoException {
        return this.warning;
    }

    @Override
    public void setTransactionIsolation(int level) throws VirtuosoException {
        if (level != 1 && level != 2 && level != 4 && level != 8) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.trxisolation = level;
    }

    @Override
    public int getTransactionIsolation() throws VirtuosoException {
        return this.trxisolation;
    }

    @Override
    public boolean isClosed() {
        return this.socket == null || this.in == null || this.in.isClosed() || this.out == null || this.out.isClosed();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws VirtuosoException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws VirtuosoException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public synchronized void rollback() throws VirtuosoException {
        if (this.global_transaction) {
            throw new VirtuosoException("Cannot rollback while in global transaction.", -4);
        }
        try {
            Object _err;
            Object[] args = new Object[]{1L, null};
            VirtuosoFuture fut = this.getFuture("TRXC", args, this.timeout);
            openlink.util.Vector trsres = fut.nextResult();
            Object object = _err = trsres == null ? null : trsres.firstElement();
            if (_err instanceof openlink.util.Vector) {
                openlink.util.Vector err = (openlink.util.Vector)_err;
                throw new VirtuosoException((String)err.elementAt(2), (String)err.elementAt(1), -8);
            }
            if (fut != null) {
                this.removeFuture(fut);
            }
        }
        catch (IOException e) {
            throw new VirtuosoException("Connection failed: " + e.getMessage(), -3);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws VirtuosoException {
        if (autoCommit && this.global_transaction) {
            throw new VirtuosoException("Cannot set autocommit mode while in global transaction.", -4);
        }
        this.auto_commit = autoCommit;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws VirtuosoException {
        VirtuosoStatement stmt = new VirtuosoStatement(this, resultSetType, resultSetConcurrency);
        if (this.requestStarted != 0) {
            this.addStmtToClose(stmt);
        }
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws VirtuosoException {
        VirtuosoCallableStatement stmt = new VirtuosoCallableStatement(this, sql, resultSetType, resultSetConcurrency);
        if (this.requestStarted != 0) {
            this.addStmtToClose(stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws VirtuosoException {
        VirtuosoPreparedStatement ps = null;
        if (this.useCachePrepStatements) {
            LRUCache<String, VirtuosoPreparedStatement> lRUCache = this.pStatementCache;
            synchronized (lRUCache) {
                ps = (VirtuosoPreparedStatement)this.pStatementCache.remove(resultSetType + "#" + resultSetConcurrency + "#" + sql);
                if (ps != null) {
                    ps.setClosed(false);
                    ps.clearParameters();
                } else {
                    ps = new VirtuosoPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
                    ps.isCached = true;
                }
            }
        } else {
            ps = new VirtuosoPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
        }
        if (this.requestStarted != 0) {
            this.addStmtToClose(ps);
        }
        return ps;
    }

    public int hashCode() {
        return this.con_no;
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public boolean isReadOnly() throws VirtuosoException {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws VirtuosoException {
        this.readOnly = readOnly;
    }

    @Override
    public String nativeSQL(String sql) throws VirtuosoException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws VirtuosoException {
        VirtuosoStatement st = null;
        if (catalog != null) {
            try {
                st = new VirtuosoStatement(this);
                st.executeQuery("use " + catalog);
                this.qualifier = catalog;
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public String getCatalog() throws VirtuosoException {
        return this.qualifier;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws VirtuosoException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws VirtuosoException {
    }

    protected void setSocketTimeout(int timeout) throws VirtuosoException {
        try {
            if (timeout != -1) {
                this.socket.setSoTimeout(timeout);
            }
        }
        catch (SocketException e) {
            throw new VirtuosoException("Unable to set socket timeout : " + e.getMessage(), "S1000", -17);
        }
    }

    protected VirtuosoExplicitString escapeSQL(String sql) throws VirtuosoException {
        VirtuosoExplicitString sql1;
        if (this.charset != null) {
            byte[] bytes = this.charsetBytes(sql);
            VirtuosoExplicitString sql12 = new VirtuosoExplicitString(bytes, 182);
            return sql12;
        }
        if (this.charset_utf8) {
            VirtuosoExplicitString sql13 = new VirtuosoExplicitString(sql, 182, this);
            return sql13;
        }
        if (this.utf8_execs) {
            try {
                byte[] bytes = new String("\n--utf8_execs=yes\n" + sql).getBytes("UTF8");
                sql1 = new VirtuosoExplicitString(bytes, 182);
            }
            catch (UnsupportedEncodingException e) {
                sql1 = new VirtuosoExplicitString("\n--utf8_execs=yes\n" + sql, 182, this);
            }
        } else {
            sql1 = new VirtuosoExplicitString("", 182, null);
            sql1.cli_wide_to_escaped(sql, this.client_charset_hash);
        }
        return sql1;
    }

    protected VirtuosoExplicitString escapeSQLString(String sql) throws VirtuosoException {
        VirtuosoExplicitString sql1;
        if (this.charset != null) {
            byte[] bytes = this.charsetBytes(sql);
            VirtuosoExplicitString sql12 = new VirtuosoExplicitString(bytes, 182);
            return sql12;
        }
        if (this.utf8_execs) {
            try {
                byte[] bytes = sql.getBytes("UTF8");
                sql1 = new VirtuosoExplicitString(bytes, 182);
            }
            catch (UnsupportedEncodingException e) {
                sql1 = new VirtuosoExplicitString(sql, 182, this);
            }
        } else {
            sql1 = new VirtuosoExplicitString("", 182, null);
            sql1.cli_wide_to_escaped(sql, this.client_charset_hash);
        }
        return sql1;
    }

    protected byte[] charsetBytes1(String source, String from, String to) throws VirtuosoException {
        byte[] ans = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(source.length());
        try {
            OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, from);
            outputWriter.write(source, 0, source.length());
            outputWriter.flush();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            ans = bytes;
        }
        catch (Exception e) {
            throw new VirtuosoException("InternationalizationHelper: UnsupportedEncodingException: " + e, -10);
        }
        return ans;
    }

    protected byte[] charsetBytes(String source) throws VirtuosoException {
        if (source == null) {
            return null;
        }
        return this.charsetBytes1(source, this.charset, "8859_1");
    }

    protected String uncharsetBytes(String source) throws VirtuosoException {
        if (source == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(source.length());
        try {
            int read;
            OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "8859_1");
            outputWriter.write(source, 0, source.length());
            outputWriter.flush();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), this.charset));
            StringBuffer buf = new StringBuffer();
            char[] cbuf = new char[4096];
            while (0 < (read = bufferedReader.read(cbuf))) {
                buf.append(cbuf, 0, read);
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new VirtuosoException("InternationalizationHelper: UnsupportedEncodingException: " + e, -10);
        }
    }

    protected void checkHoldability(int holdability) throws SQLException {
        if (holdability == 1) {
            throw new VirtuosoException("Unable to hold cursors over commit", "IM001", -7);
        }
        if (holdability != 2) {
            throw new VirtuosoException("Invalid holdability value", "22023", -4);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkHoldability(resultSetHoldability);
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkHoldability(resultSetHoldability);
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkHoldability(resultSetHoldability);
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new VirtuosoException("The connection is already closed.", -1);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        return new VirtuosoBlob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new VirtuosoBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new VirtuosoBlob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new VirtuosoFNSException("createSQLXML()  not supported", -7);
    }

    @Override
    public boolean isValid(int _timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        boolean isLost = true;
        try {
            try {
                isLost = this.isConnectionLost(_timeout);
            }
            catch (Throwable t) {
                try {
                    this.abortInternal();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return !isLost;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> fail = new HashMap<String, ClientInfoStatus>();
        fail.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        throw new SQLClientInfoException("ClientInfo property not supported", fail);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        HashMap<String, ClientInfoStatus> fail = new HashMap<String, ClientInfoStatus>();
        Iterator<String> i = properties.stringPropertyNames().iterator();
        while (i.hasNext()) {
            fail.put(i.next(), ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        throw new SQLClientInfoException("ClientInfo property not supported", fail);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        if (typeName == null) {
            throw new VirtuosoException("typeName is null.", -17);
        }
        if (elements == null) {
            return null;
        }
        return new VirtuosoArray(this, typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new VirtuosoFNSException("createStruct(typeName, attributes)  not supported", -7);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Unable to unwrap to " + iface.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.isClosed()) {
            throw new VirtuosoException("The connection is closed.", -1);
        }
        return iface.isInstance(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed()) {
            throw new VirtuosoException("The connection is closed.", -1);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.isClosed()) {
            throw new VirtuosoException("The connection is closed.", -1);
        }
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(ABORT_PERM);
        }
        if (executor == null) {
            throw new VirtuosoException("Executor cannot be null", -4);
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    VirtuosoConnection.this.abortInternal();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, final int milliseconds) throws SQLException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_NETWORK_TIMEOUT_PERM);
        }
        if (executor == null) {
            throw new VirtuosoException("Executor cannot be null", -4);
        }
        if (this.isClosed()) {
            throw new VirtuosoException("The connection is closed.", -1);
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    VirtuosoConnection.this.setSocketTimeout(milliseconds);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.isClosed()) {
            throw new VirtuosoException("The connection is closed.", -1);
        }
        return this.timeout;
    }

    @Override
    public synchronized void beginRequest() throws SQLException {
        if (this.requestStarted == 0) {
            this.oAutoCommit = this.getAutoCommit();
            this.oTxnIsolation = this.getTransactionIsolation();
            this.oReadOnly = this.isReadOnly();
            this.oNetworkTimeout = this.getNetworkTimeout();
            this.oHoldability = this.getHoldability();
            this.oCatalog = this.getCatalog();
            this.oSqlWarnings = this.getWarnings();
            this.clearCache();
            this.oUseCachePrepStatements = this.useCachePrepStatements;
            this.requestStarted = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void endRequest() throws SQLException {
        if (this.requestStarted != 0) {
            Object object = this;
            synchronized (object) {
                if (!this.oAutoCommit) {
                    this.rollback();
                }
                if (this.getAutoCommit() != this.oAutoCommit) {
                    this.setAutoCommit(this.oAutoCommit);
                }
                if (this.getTransactionIsolation() != this.oTxnIsolation) {
                    this.setTransactionIsolation(this.oTxnIsolation);
                }
                if (this.isReadOnly() != this.oReadOnly) {
                    this.setReadOnly(this.oReadOnly);
                }
                if (this.getNetworkTimeout() != this.oNetworkTimeout) {
                    this.setNetworkTimeout(null, this.oNetworkTimeout);
                }
                if (this.getHoldability() != this.oHoldability) {
                    this.setHoldability(this.oHoldability);
                }
                if (!this.getCatalog().equals(this.oCatalog)) {
                    this.setCatalog(this.oCatalog);
                }
                this.warning = this.oSqlWarnings;
                this.useCachePrepStatements = this.oUseCachePrepStatements;
                this.clearCache();
                this.requestStarted = 0;
            }
            if (!this.objsToClose.isEmpty()) {
                object = this.objsToClose;
                synchronized (object) {
                    HashMap list = (HashMap)this.objsToClose.clone();
                    Iterator i = list.keySet().iterator();
                    while (i.hasNext()) {
                        try {
                            ((VirtuosoStatement)i.next()).close();
                        }
                        catch (Exception exception) {}
                    }
                    this.objsToClose.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStmtToClose(VirtuosoStatement obj) {
        if (this.requestStarted != 0) {
            HashMap<VirtuosoStatement, Object> hashMap = this.objsToClose;
            synchronized (hashMap) {
                this.objsToClose.put(obj, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStmtFromClose(VirtuosoStatement obj) {
        if (!this.objsToClose.isEmpty()) {
            HashMap<VirtuosoStatement, Object> hashMap = this.objsToClose;
            synchronized (hashMap) {
                this.objsToClose.remove(obj);
            }
        }
    }

    private void abortInternal() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createCaches(int cacheSize) {
        this.pStatementCache = new LRUCache<String, VirtuosoPreparedStatement>(cacheSize){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.maxSize <= 1) {
                    return false;
                }
                boolean remove = super.removeEldestEntry(eldest);
                if (remove) {
                    VirtuosoPreparedStatement ps = (VirtuosoPreparedStatement)eldest.getValue();
                    ps.isCached = false;
                    ps.setClosed(false);
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return remove;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        if (this.useCachePrepStatements) {
            LRUCache<String, VirtuosoPreparedStatement> lRUCache = this.pStatementCache;
            synchronized (lRUCache) {
                VirtuosoPreparedStatement ps2 = null;
                for (VirtuosoPreparedStatement ps2 : this.pStatementCache.values()) {
                    if (ps2 == null) continue;
                    ps2.isCached = false;
                    ps2.setClosed(false);
                    try {
                        ps2.close();
                    }
                    catch (Exception exception) {}
                }
                this.pStatementCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recacheStmt(VirtuosoPreparedStatement ps) throws SQLException {
        if (ps.isPoolable()) {
            LRUCache<String, VirtuosoPreparedStatement> lRUCache = this.pStatementCache;
            synchronized (lRUCache) {
                this.pStatementCache.put(ps.getResultSetType() + "#" + ps.getResultSetConcurrency() + "#" + ps.sql, ps);
            }
        }
    }

    boolean getGlobalTransaction() {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoConnection.getGlobalTransaction () (con=" + this.hashCode() + ") :" + this.global_transaction);
        }
        return this.global_transaction;
    }

    void setGlobalTransaction(boolean value) {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoConnection.getGlobalTransaction (" + value + ") (con=" + this.hashCode() + ") :" + this.global_transaction);
        }
        this.global_transaction = value;
    }

    protected void setWarning(SQLWarning warn) {
        warn.setNextWarning(this.warning);
        this.warning = warn;
    }

    protected VirtuosoException notify_error(Throwable e) {
        VirtuosoException vex;
        if (!(e instanceof VirtuosoException)) {
            vex = new VirtuosoException(e.getMessage(), -3);
            vex.initCause(e);
        } else {
            vex = (VirtuosoException)e;
        }
        if (this.pooled_connection != null && VirtuosoConnection.isCriticalError(vex)) {
            this.pooled_connection.sendErrorEvent(vex);
        }
        return vex;
    }

    public static boolean isCriticalError(SQLException ex) {
        if (ex == null) {
            return false;
        }
        String SQLstate = ex.getSQLState();
        if (SQLstate != null && SQLstate.startsWith("08") && SQLstate != "08C04" && SQLstate != "08C03" && SQLstate != "08001" && SQLstate != "08003" && SQLstate != "08006" && SQLstate != "08007") {
            return true;
        }
        int vendor = ex.getErrorCode();
        return vendor == -1 || vendor == -3 || vendor == -5 || vendor == -9 || vendor == -13 || vendor == -14 || vendor == -15 || vendor == -16;
    }

    protected class VhostRec {
        protected String host;
        protected int port;

        protected VhostRec(String _host, String _port) throws VirtuosoException {
            this.host = _host;
            try {
                this.port = Integer.parseInt(_port);
            }
            catch (NumberFormatException e) {
                throw new VirtuosoException("Wrong port number : " + e.getMessage(), -11);
            }
        }

        protected VhostRec(String _host, int _port) throws VirtuosoException {
            this.host = _host;
            this.port = _port;
        }
    }
}

