/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.shared.JenaException;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtIsolationLevel;

public class VirtTransactionHandler
extends TransactionHandlerBase
implements XAResource {
    private VirtGraph graph = null;
    private Boolean m_transactionsSupported = null;
    private ReadWrite readWrite;
    private TxnType txnType;

    protected ReadWrite getReadWrite() {
        return this.readWrite;
    }

    protected TxnType getTxnType() {
        return this.txnType;
    }

    public VirtTransactionHandler(VirtGraph _graph) {
        this.graph = _graph;
    }

    public VirtIsolationLevel getIsolationLevel() {
        try {
            Connection c = this.graph.getConnection();
            int i = c.getTransactionIsolation();
            switch (i) {
                case 1: {
                    return VirtIsolationLevel.READ_UNCOMMITTED;
                }
                case 2: {
                    return VirtIsolationLevel.READ_COMMITTED;
                }
                case 4: {
                    return VirtIsolationLevel.REPEATABLE_READ;
                }
                case 8: {
                    return VirtIsolationLevel.SERIALIZABLE;
                }
            }
            return VirtIsolationLevel.NONE;
        }
        catch (SQLException e) {
            throw new JenaException("getIsolationLevel failed: ", (Throwable)e);
        }
    }

    public void setIsolationLevel(VirtIsolationLevel level) {
        try {
            Connection c = this.graph.getConnection();
            if (level == VirtIsolationLevel.NONE) {
                c.setTransactionIsolation(0);
            } else if (level == VirtIsolationLevel.READ_UNCOMMITTED) {
                c.setTransactionIsolation(1);
            } else if (level == VirtIsolationLevel.READ_COMMITTED) {
                c.setTransactionIsolation(2);
            } else if (level == VirtIsolationLevel.REPEATABLE_READ) {
                c.setTransactionIsolation(4);
            } else if (level == VirtIsolationLevel.SERIALIZABLE) {
                c.setTransactionIsolation(8);
            }
        }
        catch (SQLException e) {
            throw new JenaException("setIsolationLevel failed: ", (Throwable)e);
        }
    }

    public boolean transactionsSupported() {
        if (this.m_transactionsSupported != null) {
            return this.m_transactionsSupported;
        }
        try {
            Connection c = this.graph.getConnection();
            if (c != null) {
                this.m_transactionsSupported = new Boolean(c.getMetaData().supportsMultipleTransactions());
                return this.m_transactionsSupported;
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        return false;
    }

    private XAResource checkXA() {
        if (!this.graph.isXA) {
            throw new JenaException("XA Transaction is supported only for XAConnections");
        }
        return this.graph.getXAResource();
    }

    private void checkNotXA(String cmd) {
        if (this.graph.isXA) {
            throw new JenaException("Method '" + cmd + "' doesn't work with XAConnection");
        }
    }

    public boolean transactionsXASupported() {
        return this.graph.isXA;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        XAResource xa = this.checkXA();
        xa.start(xid, i);
    }

    @Override
    public void commit(Xid xid, boolean flag) throws XAException {
        XAResource xa = this.checkXA();
        xa.commit(xid, flag);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        XAResource xa = this.checkXA();
        xa.end(xid, i);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XAResource xa = this.checkXA();
        xa.forget(xid);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xa = this.checkXA();
        return xa.prepare(xid);
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        XAResource xa = this.checkXA();
        return xa.recover(i);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XAResource xa = this.checkXA();
        xa.rollback(xid);
        if (this.graph.resetBNodesDictAfterCommit) {
            this.graph.dropBNodesDict();
        }
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        XAResource xa = this.checkXA();
        return xa.setTransactionTimeout(i);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xa = this.checkXA();
        return xa.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource tr) throws XAException {
        XAResource xa = this.checkXA();
        if (tr instanceof VirtTransactionHandler) {
            return xa.isSameRM(((VirtTransactionHandler)tr).checkXA());
        }
        return xa.isSameRM(tr);
    }

    public void begin() {
        this.checkNotXA("begin");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                if (c.getAutoCommit()) {
                    c.setAutoCommit(false);
                }
                this.readWrite = ReadWrite.READ;
                this.txnType = TxnType.WRITE;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction begin failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    public void begin(ReadWrite _readWrite) {
        this.checkNotXA("begin");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                if (c.getAutoCommit()) {
                    c.setAutoCommit(false);
                }
                this.readWrite = _readWrite;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction begin failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    public void begin(TxnType _txnType) {
        this.checkNotXA("begin");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                if (c.getAutoCommit()) {
                    c.setAutoCommit(false);
                }
                this.txnType = _txnType;
                switch (_txnType) {
                    case READ: {
                        this.readWrite = ReadWrite.READ;
                        break;
                    }
                    default: {
                        this.readWrite = ReadWrite.WRITE;
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw new JenaException("Transaction begin failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void abort() {
        this.checkNotXA("abort");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                c.rollback();
                c.setAutoCommit(true);
                if (!this.graph.resetBNodesDictAfterCommit) return;
                this.graph.dropBNodesDict();
                return;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction rollback failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("abort transaction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() {
        this.checkNotXA("commit");
        if (this.transactionsSupported()) {
            try {
                Connection c = this.graph.getConnection();
                c.commit();
                c.setAutoCommit(true);
                if (!this.graph.resetBNodesDictAfterCommit) return;
                this.graph.dropBNodesDict();
                return;
            }
            catch (SQLException e) {
                throw new JenaException("Transaction commit failed: ", (Throwable)e);
            }
        } else {
            this.notSupported("commit transaction");
        }
    }

    private void notSupported(String opName) {
        throw new UnsupportedOperationException(opName);
    }
}

