/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* dav.sql */

static const char *proc0 = 
"#line 24 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.\"OPTIONS\" (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare full_path varchar;\n"
"declare _path_id, _res_id any;\n"
"\n"
"full_path := DAV_CONCAT_PATH (\'/\', DAV_CONCAT_PATH (path, \'/\'));\n"
"_path_id := DAV_SEARCH_ID (full_path, \'C\');\n"
"_res_id := DAV_SEARCH_ID (DAV_CONCAT_PATH (\'/\', path), \'R\');\n"
"if (isarray (_path_id))\n"
"{\n"
"if (_path_id[0] = UNAME\'CalDAV\')\n"
"{\n"
"http_header (concat (\n"
"\'Content-Type: text/xml\\r\\n\',\n"
"\'Allow: OPTIONS, GET, HEAD, POST, PUT, DELETE, TRACE, COPY, MOVE\\r\\n\',\n"
"\'Allow: PROPFIND, PROPPATCH, LOCK, UNLOCK, REPORT, ACL\\r\\n\',\n"
"\'DAV: 1, 2, access-control, calendar-access\\r\\n\',\n"
"\'MS-Author-Via: DAV\\r\\n\'));\n"
"return;\n"
"}\n"
"if (_path_id[0] = UNAME\'CardDAV\')\n"
"{\n"
"http_header (concat (\n"
"\'Content-Type: text/xml\\r\\n\',\n"
"\'Allow: OPTIONS, GET, HEAD, POST, PUT, DELETE, TRACE, COPY, MOVE\\r\\n\',\n"
"\'Allow: PROPFIND, PROPPATCH, LOCK, UNLOCK, REPORT, ACL\\r\\n\',\n"
"\'DAV: 1, 2, 3, access-control, addressbook\\r\\n\',\n"
"\'MS-Author-Via: DAV\\r\\n\'));\n"
"return;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (exists (select 1 from WS.WS.SYS_DAV_COL where COL_ID = _path_id and COL_DET = \'CalDAV\'))\n"
"{\n"
"http_header (concat (\n"
"\'Content-Type: text/xml\\r\\n\',\n"
"\'Allow: OPTIONS, GET, HEAD, POST, TRACE\\r\\n\',\n"
"\'Allow: PROPFIND, PROPPATCH, LOCK, UNLOCK, REPORT\\r\\n\',\n"
"\'DAV: 1, 2, access-control, calendar-access\\r\\n\',\n"
"\'MS-Author-Via: DAV\\r\\n\')\n"
");\n"
"return;\n"
"}\n"
"if (exists (select 1 from WS.WS.SYS_DAV_COL where COL_ID = _path_id and COL_DET = \'CardDAV\'))\n"
"{\n"
"http_header (concat (\n"
"\'Content-Type: text/xml\\r\\n\',\n"
"\'Allow: OPTIONS, GET, HEAD, POST, TRACE\\r\\n\',\n"
"\'Allow: PROPFIND, PROPPATCH, LOCK, UNLOCK, REPORT\\r\\n\',\n"
"\'DAV: 1, 2, access-control, addressbook\\r\\n\',\n"
"\'MS-Author-Via: DAV\\r\\n\')\n"
");\n"
"return;\n"
"}\n"
"}\n"
"\n"
"declare _etag, _ldp_head varchar;\n"
"\n"
"_ldp_head := \'\';\n"
"if (not isvector (_path_id) and not isvector (_res_id))\n"
"{\n"
"declare _name varchar;\n"
"declare _id integer;\n"
"declare _mod_time datetime;\n"
"whenever not found goto not_found;\n"
"\n"
"if (_path_id <> -1)\n"
"{\n"
"select COL_NAME, COL_MOD_TIME into _name, _mod_time from WS.WS.SYS_DAV_COL where COL_ID = _path_id;\n"
"_id := _path_id;\n"
"if (LDP_ENABLED (_path_id))\n"
"_ldp_head := \'Link: <http://www.w3.org/ns/ldp#Resource>; rel=\"type\"\\r\\nLink: <http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"\\r\\n\';\n"
"}\n"
"else\n"
"{\n"
"select RES_COL, RES_NAME, RES_MOD_TIME into _id, _name, _mod_time from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"if (LDP_ENABLED (_id))\n"
"_ldp_head := \'Link: <http://www.w3.org/ns/ldp#Resource>; rel=\"type\"\\r\\n\';\n"
"}\n"
"_etag := sprintf (\'ETag: \"%s\"\\r\\n\', WS.WS.ETAG (_name, _id, _mod_time));\n"
"}\n"
"\n"
"not_found: ;\n"
"declare headers, acceptPatch, acceptPost, msAuthor any;\n"
"\n"
"http_methods_set (\'GET\',\'HEAD\',\'POST\',\'PUT\',\'DELETE\',\'OPTIONS\',\'PROPFIND\',\'PROPPATCH\',\'COPY\',\'MOVE\',\'LOCK\',\'UNLOCK\',\'TRACE\',\'PATCH\');\n"
"WS.WS.GET (path, params, lines);\n"
"http_rewrite ();\n"
"\n"
"headers := http_header_array_get ();\n"
"acceptPatch := WS.WS.FINDPARAM (headers, \'Accept-Patch\');\n"
"if (acceptPatch <> \'\')\n"
"acceptPatch := sprintf (\'Accept-Patch: %s\\r\\n\', acceptPatch);\n"
"\n"
"acceptPost := http_request_header (headers, \'Accept-Post\', null, \'*/*\');\n"
"if (acceptPost <> \'\')\n"
"acceptPost := sprintf (\'Accept-Post: %s\\r\\n\', acceptPost);\n"
"\n"
"msAuthor := sprintf (\'MS-Author-Via: %s\\r\\n\', http_request_header (headers, \'MS-Author-Via\', null, \'DAV\'));\n"
"\n"
"DB.DBA.DAV_SET_HTTP_STATUS (204);\n"
"http_header (\n"
"\'X-Powered-By: Virtuoso Universal Server \' || sys_stat (\'st_dbms_ver\') || \'\\r\\n\' ||\n"
"\'Vary: Origin, Access-Control-Request-Headers\\r\\n\' ||\n"
"_etag ||\n"
"\'DAV: 1,2,<http://www.openlinksw.com/virtuoso/webdav/1.0>\\r\\n\' ||\n"
"_ldp_head ||\n"
"\'Access-Control-Allow-Methods: GET,HEAD,POST,PUT,DELETE,OPTIONS,PROPFIND,PROPPATCH,COPY,MOVE,LOCK,UNLOCK,TRACE,PATCH\\r\\n\' ||\n"
"\'Access-Control-Allow-Headers: Authorization, Accept, Slug, Link, Origin, Content-Type\\r\\n\' ||\n"
"\'Access-Control-Expose-Headers: Authorization, User, Location, Link, Vary, Last-Modified, ETag, Accept-Patch, Accept-Post, Updates-Via, Allow, WAC-Allow, Content-Length, WWW-Authenticate\\r\\n\' ||\n"
"\'Access-Control-Allow-Credentials: true\\r\\n\' ||\n"
"\'Access-Control-Max-Age: 1728000\\r\\n\' ||\n"
"acceptPatch ||\n"
"acceptPost ||\n"
"msAuthor\n"
");\n"
"}\n"
"--src dav.sql:22\n"
;

static const char *proc1 = 
"#line 144 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPFIND (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare _depth integer;\n"
"declare st, _temp varchar;\n"
"declare _ms_date integer;\n"
"declare _lpath, _body, _ses, _props, _ppath, _perms varchar;\n"
"declare uname, upwd varchar;\n"
"declare id any;\n"
"declare _uid, _gid, rc integer;\n"
"\n"
"_lpath := http_path ();\n"
"_ppath := http_physical_path ();\n"
"if (_lpath = \'\')\n"
"_lpath := \'/\';\n"
"\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"{\n"
"st := \'C\';\n"
"}\n"
"else\n"
"{\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return;\n"
"}\n"
"st := \'R\';\n"
"}\n"
"_uid := null;\n"
"_gid := null;\n"
"if (st = \'C\')\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'1__\', 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (DAV_GET_PARENT (id, st, _ppath), \'C\', \'1__\', 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"}\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"\n"
"if (strstr (WS.WS.FINDPARAM (lines, \'User-Agent\'), \'Microsoft\') is not null)\n"
"_ms_date := 1;\n"
"else\n"
"_ms_date := 0;\n"
"\n"
"_temp := WS.WS.FINDPARAM (lines, \'Depth\');\n"
"if (_temp <> \'\' and _temp <> \'infinity\')\n"
"_depth := atoi (_temp);\n"
"else\n"
"_depth := 0;\n"
"\n"
"if (_depth > 2)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"return;\n"
"}\n"
"\n"
"if (st = \'C\' and aref (_lpath, length (_lpath) - 1) <> ascii (\'/\'))\n"
"_lpath := concat (_lpath, \'/\');\n"
"\n"
"_ses := WS.WS.GET_BODY (params);\n"
"if (length (_ses))\n"
"{\n"
"_body := string_output_string (_ses);\n"
"{\n"
"declare test_tree any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return;\n"
"};\n"
"if (length (_body) > 0)\n"
"test_tree := xml_tree (_body);\n"
"}\n"
"\n"
"\n"
"_props := WS.WS.PROPNAMES (_body);\n"
"if (isnull (_props))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_props := vector (\'allprop\');\n"
"}\n"
"\n"
"if (isarray (_props) and length (_props) = 1 and (_props[0] = \'propname\'))\n"
"{\n"
"WS.WS.CUSTOM_PROP (_lpath, id, st);\n"
"return;\n"
"}\n"
"\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"declare full_path varchar;\n"
"declare path_id any;\n"
"\n"
"full_path := \'/\' || DAV_CONCAT_PATH (path, \'/\');\n"
"path_id := DAV_SEARCH_ID (full_path, \'C\');\n"
"if (DB.DBA.DAV_DET_NAME (path_id) = \'CalDAV\')\n"
"http_header (\'DAV: 1, calendar-access, calendar-schedule, calendar-proxy\\r\\nContent-type: application/xml; charset=\"utf-8\"\\r\\n\');\n"
"\n"
"else if (DB.DBA.DAV_DET_NAME (path_id) = \'CardDAV\')\n"
"http_header (\'DAV: 1, addressbook\\r\\nContent-type: application/xml; charset=\"utf-8\"\\r\\n\');\n"
"\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:M=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\">\\n\');\n"
"if (-13 = WS.WS.PROPFIND_RESPONSE (_lpath, _ppath, _depth, st, _ms_date, _props, _uid))\n"
"{\n"
"_uid := null;\n"
"_gid := null;\n"
"\n"
"http_rewrite ();\n"
"WS.WS.GET_DAV_AUTH (lines, 0, 1, uname, upwd, _uid, _gid, _perms);\n"
"return;\n"
"}\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"--src dav.sql:142\n"
;

static const char *proc2 = 
"#line 279 \"[executable]/dav.sql\"\n"
"create function WS.WS.PROPFIND_RESPONSE (\n"
"in lpath varchar,\n"
"in ppath varchar,\n"
"in depth integer,\n"
"in st char (1),\n"
"in ms_date integer,\n"
"in propnames any,\n"
"in u_id integer) returns integer\n"
"{\n"
"\n"
"declare N, all_prop, add_not_found integer;\n"
"declare items any;\n"
"\n"
"if (not isstring (lpath) or not isstring (ppath))\n"
"return -28;\n"
"\n"
"all_prop := 0;\n"
"add_not_found := 1;\n"
"\n"
"if (st = \'C\' and aref (ppath, length (ppath) - 1) <> ascii (\'/\'))\n"
"ppath := concat (ppath, \'/\');\n"
"\n"
"if (not isarray (propnames))\n"
"{\n"
"if (ms_date)\n"
"{\n"
"propnames := vector (\':getlastmodified\', \':creationdate\', \':lastaccessed\', \':getcontentlength\', \':resourcetype\', \':supportedlock\');\n"
"add_not_found := 0;\n"
"}\n"
"else\n"
"{\n"
"propnames := vector (\':getlastmodified\', \':getcontentlength\', \':resourcetype\');\n"
"}\n"
"}\n"
"else if (propnames[0] = \'allprop\')\n"
"{\n"
"all_prop := 1;\n"
"items := vector (\':displayname\', \':getlastmodified\', \':creationdate\', \':getetag\', \':getcontenttype\', \':getcontentlength\', \':resource-id\', \':resourcetype\', \':lockdiscovery\', \':supportedlock\');\n"
"for (N := 1; N < length (propnames); N := N + 1)\n"
"{\n"
"if (not position (propnames[N], items))\n"
"items := vector_concat (items, vector (propnames[N]));\n"
"}\n"
"propnames := items;\n"
"}\n"
"\n"
"items := DAV_DIR_LIST_INT (ppath, -1, \'%\', null, null, u_id);\n"
"if (isinteger (items))\n"
"{\n"
"if ((items = -13) and (u_id <= 0))\n"
"return items;\n"
"\n"
"return -1;\n"
"}\n"
"else if (length (items) = 0)\n"
"{\n"
"return -1;\n"
"}\n"
"\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, items, 0, ms_date, propnames, all_prop, add_not_found, 0, u_id);\n"
"\n"
"\n"
"if ((depth = 1) and (st = \'C\'))\n"
"{\n"
"items := DAV_DIR_LIST_INT (ppath, 0, \'%\', null, null, u_id);\n"
"if (isinteger (items))\n"
"{\n"
"if ((items = -13) and (u_id <= 0))\n"
"return items;\n"
"\n"
"items := vector ();\n"
"}\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, items, 1, ms_date, propnames, all_prop, add_not_found, 0, u_id);\n"
"}\n"
"else if (((depth = -1) or (depth > 1)) and (st = \'C\'))\n"
"{\n"
"items := DAV_DIR_LIST_INT (ppath, 0, \'%\', null, null, u_id);\n"
"if (isinteger (items))\n"
"{\n"
"if ((items = -13) and (u_id <= 0))\n"
"return items;\n"
"\n"
"items := vector ();\n"
"}\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, items, case (depth) when -1 then -1 else depth-1 end, ms_date, propnames, all_prop, add_not_found, 1, u_id);\n"
"foreach (any item in items) do\n"
"{\n"
"if (\'C\' = item[1])\n"
"{\n"
"if (-13 = WS.WS.PROPFIND_RESPONSE (lpath || item[10] || \'/\', ppath || item[10] || \'/\', -1, \'C\', ms_date, propnames, u_id))\n"
"return -13;\n"
"}\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:277\n"
;

static const char *proc3 = 
"#line 377 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPFIND_RESPONSE_FORMAT (\n"
"in lpath varchar,\n"
"in dirlist any,\n"
"in append_name_to_href integer,\n"
"in ms_date integer,\n"
"in propnames any,\n"
"in all_prop integer,\n"
"in add_not_found integer,\n"
"in resources_only integer,\n"
"in _u_id integer)\n"
"{\n"
"\n"
"declare dir_len, dir_ctr, dt_flag, iso_dt_flag, res_len, parent_col, id, found_cprop, found_sprop, mix integer;\n"
"declare crt, modt datetime;\n"
"declare name, mime_type, prop, prop1, dt_ms, mis_prop varchar;\n"
"declare st char(1);\n"
"declare diritm, prop_val, href any;\n"
"declare perms, uid, gid any;\n"
"\n"
"if (ms_date)\n"
"{\n"
"dt_flag := 1;\n"
"iso_dt_flag := 1;\n"
"dt_ms := \' M:dt=\"dateTime.rfc1123\"\';\n"
"}\n"
"else\n"
"{\n"
"dt_flag := 1;\n"
"iso_dt_flag := 0;\n"
"dt_ms := \'\';\n"
"}\n"
"dir_ctr := 0;\n"
"dir_len := length (dirlist);\n"
"\n"
"next_response:\n"
"if (dir_ctr >= dir_len)\n"
"return;\n"
"\n"
"diritm := dirlist[dir_ctr];\n"
"st := diritm[1];\n"
"if ((\'R\' <> st) and resources_only)\n"
"{\n"
"dir_ctr := dir_ctr + 1;\n"
"goto next_response;\n"
"}\n"
"\n"
"res_len := diritm[2];\n"
"modt := diritm[3];\n"
"id := diritm[4];\n"
"crt := diritm[8];\n"
"mime_type := diritm[9];\n"
"name := diritm[10];\n"
"perms := diritm[5];\n"
"uid := diritm[7];\n"
"gid := diritm[6];\n"
"\n"
"found_sprop := 0;\n"
"mis_prop := \'\';\n"
"mix := 0;\n"
"\n"
"if (__tag (crt) <> 211)\n"
"crt := now ();\n"
"\n"
"if (__tag (modt) <> 211)\n"
"modt := now ();\n"
"\n"
"href := case append_name_to_href when 0 then lpath else DAV_CONCAT_PATH (lpath, name) end;\n"
"if (st = \'C\' and href not like \'%/\' and href not like \'%.ics\' and href not like \'%.vcf\')\n"
"href := href || \'/\';\n"
"\n"
"parent_col := DAV_SEARCH_ID (href, \'P\');\n"
"http (\'<D:response xmlns:D=\"DAV:\" xmlns:V=\"http://www.openlinksw.com/virtuoso/webdav/1.0/\">\\n\');\n"
"http (sprintf (\'<D:href>%V</D:href>\\n\', DB.DBA.DAV_HREF_URL (href)));\n"
"http (\'<D:propstat>\\n\');\n"
"http (\'<D:prop>\\n\');\n"
"\n"
"foreach (any prop in propnames) do\n"
"{\n"
"if (prop = \':acl\')\n"
"{\n"
"http (\'<D:acl />\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':displayname\')\n"
"{\n"
"http (sprintf (\'<D:displayname>%V</D:displayname>\\n\', name));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getlastmodified\')\n"
"{\n"
"http (sprintf (\'<D:getlastmodified%s>%V</D:getlastmodified>\\n\', dt_ms, soap_print_box (modt, \'\', dt_flag)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':creationdate\')\n"
"{\n"
"http (sprintf (\'<D:creationdate%s>%V</D:creationdate>\\n\', dt_ms, soap_print_box (crt, \'\', iso_dt_flag)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':lastaccessed\')\n"
"{\n"
"http (sprintf (\'<D:lastaccessed%s>%V</D:lastaccessed>\\n\', dt_ms, soap_print_box (modt, \'\', dt_flag)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getetag\' and st = \'R\')\n"
"{\n"
"http (sprintf (\'<D:getetag>\"%V\"</D:getetag>\\n\', WS.WS.ETAG (name, parent_col, modt)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getcontenttype\')\n"
"{\n"
"http (sprintf (\'<D:getcontenttype>%V</D:getcontenttype>\\n\', mime_type));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getcontentlength\')\n"
"{\n"
"http (sprintf (\'<D:getcontentlength>%d</D:getcontentlength>\\n\', case when (st = \'R\') then res_len else 0 end));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'urn:ietf:params:xml:ns:caldav:supported-calendar-component-set\')\n"
"{\n"
"http (\'<C:supported-calendar-component-set xmlns:C=\"urn:ietf:params:xml:ns:caldav\"><C:comp name=\"VEVENT\"/><C:comp name=\"VTODO\"/></C:supported-calendar-component-set>\\r\\n\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'urn:ietf:params:xml:ns:carddav:supported-address-data\')\n"
"{\n"
"http (\'<C:supported-address-data xmlns:C=\"urn:ietf:params:xml:ns:carddav\"><C:address-data-type content-type=\"text/vcard\" version=\"3.0\"/></C:supported-address-data>\\r\\n\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getetag\' and st = \'C\')\n"
"{\n"
"http (sprintf (\'<D:getetag>\"%V\"</D:getetag>\\n\', WS.WS.ETAG (name, parent_col, modt)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'http://calendarserver.org/ns/:getctag\')\n"
"{\n"
"http (concat(\'<CS:getctag xmlns:CS=\"http://calendarserver.org/ns/\">\', WS.WS.ETAG (name, parent_col, modt), \'</CS:getctag>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'urn:ietf:params:xml:ns:caldav:calendar-data\')\n"
"{\n"
"declare content, type_ any;\n"
"\n"
"DB.DBA.DAV_RES_CONTENT_INT (DAV_SEARCH_ID (lpath, \'R\'), content, type_, 0, 0);\n"
"http (concat(\'<C:calendar-data xmlns:C=\"urn:ietf:params:xml:ns:caldav\">\', content, \'</C:calendar-data>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'urn:ietf:params:xml:ns:carddav:address-data\')\n"
"{\n"
"declare content, type_ any;\n"
"DB.DBA.DAV_RES_CONTENT_INT (DAV_SEARCH_ID (lpath, \'R\'), content, type_, 0, 0);\n"
"http (concat(\'<C:address-data xmlns:C=\"urn:ietf:params:xml:ns:carddav\">\', content, \'</C:address-data>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'urn:ietf:params:xml:ns:caldav:calendar-home-set\')\n"
"{\n"
"http (sprintf (\'<C:calendar-home-set xmlns:C=\"urn:ietf:params:xml:ns:caldav\"><D:href>%V</D:href></C:calendar-home-set>\\n\', DB.DBA.DAV_HREF_URL (lpath)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \'urn:ietf:params:xml:ns:carddav:addressbook-home-set\')\n"
"{\n"
"http (sprintf (\'<C:addressbook-home-set xmlns:C=\"urn:ietf:params:xml:ns:carddav\"><D:href>%V</D:href></C:addressbook-home-set>\\n\', DB.DBA.DAV_HREF_URL (lpath)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':principal-URL\')\n"
"{\n"
"http (sprintf (\'<D:principal-URL><D:href>%V</D:href></D:principal-URL>\\n\', DB.DBA.DAV_HREF_URL (lpath)));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':current-user-privilege-set\')\n"
"{\n"
"if (mime_type = \'text/vcard\' or mime_type = \'text/calendar\')\n"
"{\n"
"http (\'<D:current-user-privilege-set><D:privilege><D:all/></D:privilege></D:current-user-privilege-set>\');\n"
"found_sprop := 1;\n"
"}\n"
"}\n"
"else if (prop = \':supported-report-set\')\n"
"{\n"
"if (mime_type = \'text/vcard\')\n"
"{\n"
"http (\n"
"\'<D:supported-report-set>\'||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <C:addressbook-query xmlns:C=\"urn:ietf:params:xml:ns:carddav\"/>\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <C:addressbook-multiget xmlns:C=\"urn:ietf:params:xml:ns:carddav\"/>\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <D:expand-property />\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <D:principal-property-search />\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <D:principal-search-property-set />\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'</D:supported-report-set>\\n\'\n"
");\n"
"found_sprop := 1;\n"
"}\n"
"else if (mime_type = \'text/calendar\')\n"
"{\n"
"http (\n"
"\'<D:supported-report-set>\'||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <C:calendar-multiget xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>\' ||\n"
"\'    </D:report>\' ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <C:calendar-query xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <D:principal-match/>\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'  <D:supported-report>\'  ||\n"
"\'    <D:report>\'          ||\n"
"\'      <C:free-busy-query xmlns:C=\"urn:ietf:params:xml:ns:caldav\"/>\' ||\n"
"\'    </D:report>\'         ||\n"
"\'  </D:supported-report>\' ||\n"
"\'</D:supported-report-set>\\n\'\n"
");\n"
"found_sprop := 1;\n"
"}\n"
"}\n"
"else if (prop = \':resource-id\')\n"
"{\n"
"http (sprintf (\'<D:resource-id>%V</D:resource-id>\\n\', WS.WS.DAV_LINK (lpath)));\n"
"}\n"
"else if (prop = \':resourcetype\')\n"
"{\n"
"if (st = \'C\')\n"
"{\n"
"if (mime_type = \'text/vcard\')\n"
"http (\'<D:resourcetype><D:collection/><C:addressbook xmlns:C=\"urn:ietf:params:xml:ns:carddav\" /></D:resourcetype>\\n\');\n"
"else if (mime_type = \'text/calendar\')\n"
"http (\'<D:resourcetype><D:collection/><C:calendar xmlns:C=\"urn:ietf:params:xml:ns:caldav\" /></D:resourcetype>\\n\');\n"
"else\n"
"http (\'<D:resourcetype><D:collection/></D:resourcetype>\\n\');\n"
"}\n"
"else\n"
"{\n"
"http (\'<D:resourcetype/>\\n\');\n"
"}\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':lockdiscovery\')\n"
"{\n"
"declare locks any;\n"
"\n"
"locks := DAV_LIST_LOCKS (id, st);\n"
"http (\'<D:lockdiscovery>\');\n"
"foreach (any lock in locks) do\n"
"{\n"
"http (\'<D:activelock>\\n\');\n"
"http (\'<D:locktype><D:write/></D:locktype>\\n\');\n"
"if (lock[1] = \'X\')\n"
"http (\'<D:lockscope><D:exclusive/></D:lockscope>\\n\');\n"
"else\n"
"http (\'<D:lockscope><D:shared/></D:lockscope>\\n\');\n"
"http (\'<D:depth>infinity</D:depth>\\n\');\n"
"http (sprintf (\'%s<D:timeout>Second-%d</D:timeout>\\n\', coalesce (lock[5], \'\'), lock[3]));\n"
"http (sprintf (\'<D:locktoken><D:href>opaquelocktoken:%s</D:href></D:locktoken>\\n\', lock[2]));\n"
"http (\'</D:activelock>\\n\');\n"
"}\n"
"http (\'</D:lockdiscovery>\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':supportedlock\')\n"
"{\n"
"http (\'<D:supportedlock>\\n<D:lockentry>\\n<D:lockscope><D:exclusive/></D:lockscope>\\n<D:locktype><D:write/></D:locktype>\\n</D:lockentry>\\n<D:lockentry>\\n<D:lockscope><D:shared/></D:lockscope>\\n<D:locktype><D:write/></D:locktype>\\n</D:lockentry>\\n</D:supportedlock>\\n\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':virtpermissions\')\n"
"{\n"
"perms := trim (perms, \'\\r\\n \');\n"
"http (concat(\'<V:virtpermissions>\', perms, \'</V:virtpermissions>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':virtowneruid\')\n"
"{\n"
"declare tmp varchar;\n"
"\n"
"tmp := (select U_NAME from DB.DBA.SYS_USERS where U_ID = uid);\n"
"if (tmp is not null)\n"
"{\n"
"http (sprintf (\'<V:virtowneruid>%U</V:virtowneruid>\\n\', tmp));\n"
"found_sprop := 1;\n"
"}\n"
"else\n"
"{\n"
"mis_prop := concat (mis_prop, \'<V:virtowneruid />\\n\');\n"
"}\n"
"}\n"
"else if (prop = \':virtownergid\')\n"
"{\n"
"declare tmp varchar;\n"
"tmp := (select U_NAME from DB.DBA.SYS_USERS where U_ID = gid);\n"
"if (tmp is not null)\n"
"{\n"
"http (sprintf (\'<V:virtownergid>%U</V:virtownergid>\\n\', tmp));\n"
"found_sprop := 1;\n"
"}\n"
"else\n"
"{\n"
"mis_prop := concat (mis_prop, \'<V:virtownergid />\\n\');\n"
"}\n"
"}\n"
"else if (all_prop = 0)\n"
"{\n"
"if (prop[0] = ascii (\':\'))\n"
"prop1 := subseq (prop, 1);\n"
"else\n"
"prop1 := prop;\n"
"\n"
"found_cprop := 0;\n"
"prop_val := DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, st, prop1, 0), null);\n"
"if (prop_val is not null)\n"
"{\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT_CUSTOM (prop, prop1, prop_val);\n"
"\n"
"found_cprop := 1;\n"
"found_sprop := 1;\n"
"}\n"
"if (add_not_found and not found_cprop)\n"
"{\n"
"declare names, namep varchar;\n"
"declare colon any;\n"
"\n"
"colon := strrchr (prop, \':\');\n"
"if (colon > 0)\n"
"{\n"
"namep := substring (prop, colon + 1, length (prop));\n"
"names := substring (prop, 1, colon);\n"
"mix := mix + 1;\n"
"mis_prop := concat (mis_prop, sprintf (\'<i%d%s xmlns:i%d=\"%s\" />\\n\', mix, namep, mix, names));\n"
"}\n"
"else\n"
"{\n"
"mis_prop := concat (mis_prop, sprintf (\'<D%s />\\n\', prop));\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (all_prop = 1)\n"
"{\n"
"declare props any;\n"
"\n"
"props := DAV_PROP_LIST_INT (id, st, \'%\', 0);\n"
"foreach (any prop in props) do\n"
"{\n"
"prop1 := prop[0];\n"
"if ((prop1 = \'LDP\') or (prop1 like \'virt:%\') or (prop1 like \'http://www.openlinksw.com/schemas/%\') or (prop1 like \'http://local.virt/DAV-RDF%\'))\n"
"goto _skip2;\n"
"\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT_CUSTOM (prop1, prop1, prop[1]);\n"
"_skip2:;\n"
"}\n"
"}\n"
"if (found_sprop)\n"
"{\n"
"http (\'</D:prop>\\n\');\n"
"http (\'<D:status>HTTP/1.1 200 OK</D:status>\\n\');\n"
"http (\'</D:propstat>\\n\');\n"
"}\n"
"if (mis_prop <> \'\')\n"
"{\n"
"if (found_sprop)\n"
"http (\'<D:propstat>\\n<D:prop>\\n\');\n"
"\n"
"http (mis_prop);\n"
"http (\'</D:prop>\\n<D:status>HTTP/1.1 404 Not Found</D:status>\\n</D:propstat>\\n\');\n"
"\n"
"}\n"
"http (\'</D:response>\\n\');\n"
"\n"
"dir_ctr := dir_ctr + 1;\n"
"goto next_response;\n"
"}\n"
"--src dav.sql:375\n"
;

static const char *proc4 = 
"#line 773 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPFIND_RESPONSE_FORMAT_CUSTOM (\n"
"in prop varchar,\n"
"in prop1 varchar,\n"
"in prop_value any)\n"
"{\n"
"declare tree, tree_error, item, pname, pns any;\n"
"\n"
"tree_error := 1;\n"
"{\n"
"declare exit handler for sqlstate \'*\' {goto _skip;};\n"
"tree := xml_tree_doc (xml_expand_refs (xml_tree (prop_value)));\n"
"tree_error := 0;\n"
"}\n"
"\n"
"_skip:;\n"
"if (not tree_error)\n"
"{\n"
"item := xpath_eval (\'/*\', tree, 1);\n"
"pname := cast (xpath_eval (\'local-name(.)\', item) as varchar);\n"
"pns := cast (xpath_eval (\'namespace-uri(.)\', item) as varchar);\n"
"if ((length (pns) <> 0) and (pns <> \'DAV\') and (pns <> \'http://www.openlinksw.com/virtuoso/webdav/1.0/\'))\n"
"pname := concat (pns, \':\', pname);\n"
"\n"
"if (pname = prop)\n"
"{\n"
"http (concat (prop_value, \'\\n\'));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<V:%s><![CDATA[%s]]></V:%s>\\n\', prop1, prop_value, prop1));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (concat (\'<V:\',prop1,\'/>\\n\'));\n"
"}\n"
"}\n"
"--src dav.sql:771\n"
;

static const char *proc5 = 
"#line 812 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPNAMES (\n"
"in _body varchar,\n"
"in _proppath varchar := \'//propfind\')\n"
"{\n"
"\n"
"declare tree, tmp, rc, items any;\n"
"declare pns, pname varchar;\n"
"\n"
"if (not isstring (_body) or _body = \'\')\n"
"return null;\n"
"\n"
"if (not isnull (regexp_match (\'xmlns:[a-zA-Z_](\\\\w)*=\"\"\', _body)))\n"
"return null;\n"
"\n"
"tree := xml_tree_doc (xml_expand_refs (xml_tree (_body)));\n"
"\n"
"\n"
"tmp := xpath_eval (_proppath || \'/propname\', tree, 1);\n"
"if (not isnull (tmp))\n"
"return vector (\'propname\');\n"
"\n"
"tmp := xpath_eval (_proppath || \'/allprop\', tree, 1);\n"
"if (not isnull (tmp))\n"
"{\n"
"rc := vector (\'allprop\');\n"
"items := xpath_eval (_proppath || \'/include/*\', tree, 0);\n"
"}\n"
"else\n"
"{\n"
"tmp := xpath_eval (_proppath || \'/prop\', tree, 1);\n"
"if (isnull (tmp))\n"
"return null;\n"
"\n"
"rc := vector ();\n"
"items := xpath_eval (_proppath || \'/prop/*\', tree, 0);\n"
"}\n"
"foreach (any item in items) do\n"
"{\n"
"pns := cast (xpath_eval (\'namespace-uri(.)\', item) as varchar);\n"
"pname := cast (xpath_eval (\'local-name(.)\', item) as varchar);\n"
"if (pns = \'DAV:\')\n"
"pname := concat (\':\', pname);\n"
"else if ((pns <> \'\') and (pns <> \'http://www.openlinksw.com/virtuoso/webdav/1.0/\'))\n"
"pname := concat (pns, \':\', pname);\n"
"\n"
"rc := vector_concat (rc, vector (pname));\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav.sql:810\n"
;

static const char *proc6 = 
"#line 863 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.CALENDAR_NAMES (\n"
"in _body varchar)\n"
"{\n"
"return WS.WS.PROPNAMES (_body, \'//calendar-multiget\');\n"
"}\n"
"--src dav.sql:861\n"
;

static const char *proc7 = 
"#line 870 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ADDRESSBOOK_NAMES (in _body varchar)\n"
"{\n"
"return WS.WS.PROPNAMES (_body, \'//addressbook-multiget\');\n"
"}\n"
"--src dav.sql:868\n"
;

static const char *proc8 = 
"#line 876 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.REPORT (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"declare _depth integer;\n"
"declare st, _temp varchar;\n"
"declare _ms_date integer;\n"
"declare _lpath, _body, _ses, _props, _ppath, _perms varchar;\n"
"declare uname, upwd varchar;\n"
"declare id any;\n"
"declare _u_id, _g_id, rc, is_calendar, is_addressbook integer;\n"
"\n"
"_ses := WS.WS.GET_BODY (params);\n"
"_body := string_output_string (_ses);\n"
"_lpath := http_path ();\n"
"_ppath := http_physical_path ();\n"
"is_calendar := 0;\n"
"is_addressbook := 0;\n"
"if (_lpath = \'\')\n"
"_lpath := \'/\';\n"
"\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"{\n"
"if (isarray(id) = 1)\n"
"{\n"
"if (id[0] = UNAME\'CalDAV\')\n"
"is_calendar := 1;\n"
"else if (id[0] = UNAME\'CardDAV\')\n"
"is_addressbook := 1;\n"
"}\n"
"st := \'C\';\n"
"}\n"
"else\n"
"{\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return;\n"
"}\n"
"st := \'R\';\n"
"}\n"
"_u_id := null;\n"
"_g_id := null;\n"
"if (st = \'C\')\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'1__\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (DAV_GET_PARENT (id, st, _ppath), \'C\', \'1__\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"}\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"\n"
"if (strstr (WS.WS.FINDPARAM (lines, \'User-Agent\'), \'Microsoft\') is not null)\n"
"_ms_date := 1;\n"
"else\n"
"_ms_date := 0;\n"
"\n"
"_temp := WS.WS.FINDPARAM (lines, \'Depth\');\n"
"if (_temp <> \'\' and _temp <> \'infinity\')\n"
"_depth := atoi (_temp);\n"
"else\n"
"_depth := -1;\n"
"\n"
"{\n"
"declare test_tree any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return;\n"
"};\n"
"if (length (_body) > 0)\n"
"test_tree := xml_tree (_body);\n"
"}\n"
"if (st = \'C\' and aref (_lpath, length (_lpath) - 1) <> ascii (\'/\'))\n"
"_lpath := concat (_lpath, \'/\');\n"
"\n"
"\n"
"if (is_calendar = 1)\n"
"_props := WS.WS.CALENDAR_NAMES (_body);\n"
"else if (is_addressbook = 1)\n"
"_props := WS.WS.ADDRESSBOOK_NAMES (_body);\n"
"else\n"
"_props := WS.WS.PROPNAMES (_body);\n"
"\n"
"if (isvector (_props) and length (_props) = 1 and (_props[0] = \'propname\'))\n"
"{\n"
"WS.WS.CUSTOM_PROP (_lpath, id, st);\n"
"return;\n"
"}\n"
"\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"if (is_calendar = 1)\n"
"{\n"
"declare urls any;\n"
"urls := xpath_eval (\'[xmlns:D=\"DAV:\" xmlns=\"urn:ietf:params:xml:ns:caldav:\"] //calendar-multiget/D:href/text()\', xml_tree_doc (xml_expand_refs (xml_tree (_body))), 0);\n"
"http_header (\'DAV: 1, calendar-access, calendar-schedule, calendar-proxy\\r\\nContent-type: application/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:M=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\">\\n\');\n"
"foreach (any prop in urls) do\n"
"{\n"
"if (-13 = WS.WS.REPORT_RESPONSE (cast(prop as varchar), _ppath, _depth, st, _ms_date, _props, _u_id))\n"
"{\n"
"_u_id := null;\n"
"_g_id := null;\n"
"\n"
"http_rewrite ();\n"
"WS.WS.GET_DAV_AUTH (lines, 0, 1, uname, upwd, _u_id, _g_id, _perms);\n"
"return;\n"
"}\n"
"}\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"else if (is_addressbook = 1)\n"
"{\n"
"declare urls any;\n"
"urls := xpath_eval (\'[xmlns:D=\"DAV:\" xmlns=\"urn:ietf:params:xml:ns:carddav:\"] //addressbook-multiget/D:href/text()\', xml_tree_doc (xml_expand_refs (xml_tree (_body))), 0);\n"
"http_header (\'DAV: 1, addressbook\\r\\nContent-type: application/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:M=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\">\\n\');\n"
"foreach (any prop in urls) do\n"
"{\n"
"if (-13 = WS.WS.REPORT_RESPONSE (cast(prop as varchar), _ppath, _depth, st, _ms_date, _props, _u_id))\n"
"{\n"
"_u_id := null;\n"
"_g_id := null;\n"
"\n"
"http_rewrite ();\n"
"WS.WS.GET_DAV_AUTH (lines, 0, 1, uname, upwd, _u_id, _g_id, _perms);\n"
"return;\n"
"}\n"
"}\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"else\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:M=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\">\\n\');\n"
"if (-13 = WS.WS.PROPFIND_RESPONSE (_lpath, _ppath, _depth, st, _ms_date, _props, _u_id))\n"
"{\n"
"_u_id := null;\n"
"_g_id := null;\n"
"\n"
"http_rewrite ();\n"
"WS.WS.GET_DAV_AUTH (lines, 0, 1, uname, upwd, _u_id, _g_id, _perms);\n"
"return;\n"
"}\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"}\n"
"--src dav.sql:874\n"
;

static const char *proc9 = 
"#line 1039 \"[executable]/dav.sql\"\n"
"create function WS.WS.REPORT_RESPONSE (\n"
"in lpath varchar,\n"
"in ppath varchar,\n"
"in depth integer,\n"
"in st char (1),\n"
"in ms_date integer,\n"
"in propnames any,\n"
"in u_id integer) returns integer\n"
"{\n"
"declare N, all_prop, add_not_found integer;\n"
"declare items any;\n"
"\n"
"if (not isstring (lpath) or not isstring (ppath))\n"
"return -28;\n"
"\n"
"if (st = \'C\' and aref (ppath, length (ppath) - 1) <> ascii (\'/\'))\n"
"ppath := concat (ppath, \'/\');\n"
"\n"
"all_prop := 0;\n"
"add_not_found := 1;\n"
"if (not isvector (propnames))\n"
"{\n"
"if (ms_date)\n"
"{\n"
"add_not_found := 0;\n"
"propnames := vector (\':getlastmodified\', \':creationdate\', \':lastaccessed\', \':getcontentlength\', \':resourcetype\', \':supportedlock\');\n"
"}\n"
"else\n"
"{\n"
"propnames := vector (\':getlastmodified\', \':getcontentlength\', \':resourcetype\');\n"
"}\n"
"}\n"
"else if (propnames[0] = \'allprop\')\n"
"{\n"
"all_prop := 1;\n"
"items := vector (\':displayname\', \':getlastmodified\', \':creationdate\', \':getetag\', \':getcontenttype\', \':getcontentlength\', \':resource-id\', \':resourcetype\', \':lockdiscovery\', \':supportedlock\');\n"
"for (N := 1; N < length (propnames); N := N + 1)\n"
"{\n"
"if (not position (propnames[N], items))\n"
"items := vector_concat (items, vector (propnames[N]));\n"
"}\n"
"propnames := items;\n"
"}\n"
"items := DAV_DIR_LIST_INT (ppath, -1, \'%\', null, null, u_id);\n"
"if (isinteger (items))\n"
"{\n"
"if ((items = -13) and (u_id <= 0))\n"
"return items;\n"
"}\n"
"if (isinteger (items) or (length (items) = 0))\n"
"{\n"
"return -1;\n"
"}\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, items, 0, ms_date, propnames, all_prop, add_not_found, 0, u_id);\n"
"return 0;\n"
"}\n"
"--src dav.sql:1037\n"
;

static const char *proc10 = 
"#line 1097 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.CUSTOM_PROP (\n"
"in lpath any,\n"
"in id any,\n"
"in st char (1))\n"
"{\n"
"\n"
"declare N integer;\n"
"declare props, prop_name, prop_value, prop_tree any;\n"
"declare proot, pname, pns any;\n"
"declare p cursor for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_TYPE = st and PROP_PARENT_ID = id;\n"
"\n"
"\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"http_header (\'Content-type: text/xml\\r\\n\');\n"
"http (\'<?xml version=\"1.0\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:V=\"http://www.openlinksw.com/virtuoso/webdav/1.0/\">\\n\');\n"
"http (\'<D:response>\\n\');\n"
"http (sprintf (\'<D:href>%V</D:href>\\n\', DB.DBA.DAV_HREF_URL (lpath)));\n"
"http (\'<D:propstat>\\n\');\n"
"http (\'<D:prop>\\n\');\n"
"\n"
"if (st = \'R\')\n"
"http (\'<D:getcontenttype />\\n<D:getcontentlength />\\n<D:getetag />\\n\');\n"
"\n"
"http (\'<D:acl />\\n<D:displayname />\\n<D:creationdate />\\n<D:getlastmodified />\\n<D:lockdiscovery />\\n<D:supportedlock />\\n<D:resource-id />\\n<D:resourcetype />\\n\');\n"
"N := 0;\n"
"props := DAV_PROP_LIST_INT (id, st, \'%\', 0);\n"
"foreach (any prop in props) do\n"
"{\n"
"prop_name := prop[0];\n"
"if ((prop_name = \'LDP\') or (prop_name like \'virt:%\') or (prop_name like \'http://www.openlinksw.com/schemas/%\') or (prop_name like \'http://local.virt/DAV-RDF%\'))\n"
"goto _skip;\n"
"\n"
"prop_value := prop[1];\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _skip;\n"
"};\n"
"prop_tree := xml_tree_doc (xml_expand_refs (xml_tree (prop_value)));\n"
"proot := xpath_eval (\'/*\', prop_tree, 1);\n"
"pname := cast (xpath_eval (\'local-name(.)\', proot) as varchar);\n"
"pns := cast (xpath_eval (\'namespace-uri(.)\', proot) as varchar);\n"
"if (pns = \'DAV\')\n"
"http (sprintf (\'<D:%s />\\n\', pname));\n"
"\n"
"else if (length (pns) <> 0)\n"
"http (sprintf (\'<i%d:%s xmlns:i%d=\"%s\"/>\\n\', N, pname, N, pns));\n"
"\n"
"N := N + 1;\n"
"}\n"
"_skip:;\n"
"}\n"
"\n"
"http (\'</D:prop>\\n\');\n"
"http (\'<D:status>HTTP/1.1 200 OK</D:status>\\n\');\n"
"http (\'</D:propstat>\\n\');\n"
"http (\'</D:response>\\n\');\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"--src dav.sql:1095\n"
;

static const char *proc11 = 
"#line 1160 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPPATCH (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare id any;\n"
"declare uid, gid integer;\n"
"declare auth_name, auth_pwd, st, perms varchar;\n"
"declare rc any;\n"
"\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"{\n"
"st := \'C\';\n"
"path := DB.DBA.DAV_CONCAT_PATH (vector_concat (vector(\'\'), path, vector(\'\')), null);\n"
"}\n"
"else\n"
"{\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return;\n"
"}\n"
"st := \'R\';\n"
"path := DB.DBA.DAV_CONCAT_PATH (vector_concat (vector(\'\'), path), null);\n"
"}\n"
"uid := null;\n"
"gid := null;\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, perms);\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"\n"
"return WS.WS.PROPPATCH_INT (path, params, lines, id, st, auth_name, auth_pwd, uid, gid, \'proppatch\');\n"
"}\n"
"--src dav.sql:1158\n"
;

static const char *proc12 = 
"#line 1202 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPPATCH_INT (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar,\n"
"in id any,\n"
"in st varchar,\n"
"in auth_uid varchar,\n"
"in auth_pwd varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in mode varchar := \'proppatch\')\n"
"{\n"
"\n"
"declare _body any;\n"
"declare rc, rc_all, xtree, xtd any;\n"
"declare po, pn, pns, pv, prop_name, props, rc_prop any;\n"
"\n"
"rc_all := id;\n"
"_body := aref_set_0 (params, 1);\n"
"if (isinteger (_body) or length (_body) = 0)\n"
"{\n"
"if (mode = \'proppatch\')\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return -1;\n"
"}\n"
"return rc_all;\n"
"}\n"
"_body := string_output_string (_body);\n"
"xtree := xml_tree (_body, 0);\n"
"if (not isarray (xtree))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return -1;\n"
"}\n"
"rc := WS.WS.ISLOCKED (path, WS.WS.FINDPARAM (lines, \'If\'));\n"
"if (isnull (rc))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (412);\n"
"return -1;\n"
"}\n"
"if (rc)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"return -1;\n"
"}\n"
"\n"
"if (mode = \'proppatch\')\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"\n"
"rc := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\\n\', rc);\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\">\\n\', rc);\n"
"http (\'<D:response>\\n\', rc);\n"
"\n"
"xtd := xml_tree_doc (xtree);\n"
"props := xpath_eval (\'/propertyupdate/*/prop/*\', xtd, 0);\n"
"foreach (any prop in props) do\n"
"{\n"
"po := cast (xpath_eval (\'local-name(../..)\', prop) as varchar);\n"
"pn := cast (xpath_eval (\'local-name(.)\', prop) as varchar);\n"
"pns := cast (xpath_eval (\'namespace-uri(.)\', prop) as varchar);\n"
"if (length (pns) > 0)\n"
"pn := concat (pns, \':\', pn);\n"
"\n"
"if (po = \'set\')\n"
"{\n"
"prop_name := cast (xpath_eval (\'local-name(.)\', prop) as varchar);;\n"
"pv := serialize_to_UTF8_xml (prop);\n"
"if ((pns = \'http://www.openlinksw.com/virtuoso/webdav/1.0/\') and (prop_name in (\'virtpermissions\', \'virtowneruid\', \'virtownergid\')))\n"
"{\n"
"declare tmp any;\n"
"\n"
"tmp := trim (cast (xpath_eval (\'text()\', prop) as varchar));\n"
"if (prop_name = \'virtowneruid\')\n"
"{\n"
"tmp := (select U_ID from DB.DBA.SYS_USERS where U_NAME = tmp);\n"
"}\n"
"else if (prop_name = \'virtownergid\')\n"
"{\n"
"tmp := (select U_ID from DB.DBA.SYS_USERS where U_NAME = tmp);\n"
"}\n"
"rc_prop := DAV_PROP_SET_INT (path, \':\' || prop_name, tmp, null, null, 0, 0, 1, case when isstring (auth_uid) then (select U_ID from DB.DBA.SYS_USERS where U_NAME = auth_uid) else auth_uid end);\n"
"}\n"
"else if ((pns = \'http://www.openlinksw.com/virtuoso/webdav/1.0/\') and (prop_name = \'virtdet\'))\n"
"{\n"
"rc_prop := DB.DBA.DAV_DET_PROPPATCH (id, path, prop, auth_uid, auth_pwd);\n"
"if (rc_prop = 1)\n"
"return;\n"
"}\n"
"else\n"
"{\n"
"rc_prop := DAV_PROP_SET_INT (path, pn, pv, null, null, 0, 0, 1, auth_uid);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"rc_prop := DAV_PROP_REMOVE_INT (path, pn, null, null, 0, 0);\n"
"}\n"
"WS.WS.PROPPATCH_STATUS_INT (rc, pn, rc_all, rc_prop);\n"
"}\n"
"\n"
"http (\'</D:response>\\n\', rc);\n"
"http (\'</D:multistatus>\\n\', rc);\n"
"http_header (\'Content-Type: text/xml\\r\\n\');\n"
"http (string_output_string (rc));\n"
"\n"
"return rc_all;\n"
"}\n"
"--src dav.sql:1200\n"
;

static const char *proc13 = 
"#line 1313 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PROPPATCH_STATUS_INT (\n"
"inout rc any,\n"
"inout pn any,\n"
"inout rc_all any,\n"
"inout rc_prop any)\n"
"{\n"
"declare acc any;\n"
"\n"
"http (\'<D:propstat>\\n\', rc);\n"
"\n"
"xte_nodebld_init (acc);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (pn)));\n"
"xte_nodebld_final (acc, xte_head (\'DAV::prop\'));\n"
"http_value (xml_tree_doc (acc), null, rc);\n"
"\n"
"http (sprintf (\'<D:status>%V</D:status>\\n\', DAV_SET_HTTP_REQUEST_STATUS_DESCRIPTION (rc_prop)), rc);\n"
"\n"
"http (\'</D:propstat>\\n\', rc);\n"
"\n"
"if (DAV_HIDE_ERROR (rc_prop) is null)\n"
"rc_all := rc_prop;\n"
"}\n"
"--src dav.sql:1311\n"
;

static const char *proc14 = 
"#line 1337 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.FINDPARAM (\n"
"inout lines varchar,\n"
"in pkey varchar)\n"
"{\n"
"pkey := rtrim (pkey,\': \');\n"
"return http_request_header (lines, pkey, null, \'\');\n"
"}\n"
"--src dav.sql:1335\n"
;

static const char *proc15 = 
"#line 1346 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.MKCOL (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar,\n"
"in method varchar := \'mkcol\')\n"
"{\n"
"\n"
"declare _tmp, _body, _col_id, _col_parent_id, rc any;\n"
"declare _perms varchar;\n"
"declare auth_name, auth_pwd varchar;\n"
"declare uid, gid integer;\n"
"\n"
"_tmp := vector_concat (vector (\'\'), path, vector (\'\'));\n"
"if (not DB.DBA.DAV_PATH_CHECK (_tmp))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"return;\n"
"}\n"
"\n"
"_col_parent_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (_tmp, \'P\'));\n"
"if (_col_parent_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"\n"
"_col_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (_tmp, \'C\'));\n"
"if (_col_id is not null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (405);\n"
"return;\n"
"}\n"
"\n"
"_body := aref_set_0 (params, 1);\n"
"if (isinteger (_body) or length (_body) = 0)\n"
"_body := http_body_read ();\n"
"\n"
"if (length (_body))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (415);\n"
"return;\n"
"}\n"
"\n"
"uid := null;\n"
"gid := null;\n"
"if (_col_parent_id is not null)\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"}\n"
"\n"
"path := \'/\' || DB.DBA.DAV_CONCAT_PATH (path, \'/\');\n"
"rc := DB.DBA.DAV_COL_CREATE_INT (path, _perms, null, null, null, null, 1, 0, 1, uid, gid);\n"
"\n"
"if ((DB.DBA.DAV_HIDE_ERROR (rc) is not null) and (method = \'mkcol\'))\n"
"rc := WS.WS.PROPPATCH_INT (path, params, lines, rc, \'C\', auth_name, auth_pwd, uid, gid, \'mkcol\');\n"
"\n"
"if (DB.DBA.DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"rollback work;\n"
"if (rc = -24)\n"
"{\n"
" ;\n"
"}\n"
"else if (rc = -25 or rc = -3)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"}\n"
"else if (rc = -8)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"}\n"
"else if ((rc = -12) or (rc = -13))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (405);\n"
"}\n"
"return rc;\n"
"}\n"
"\n"
"commit work;\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"return rc;\n"
"}\n"
"--src dav.sql:1344\n"
;

static const char *proc16 = 
"#line 1440 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.FINDCOL (in path any, out col integer)\n"
"{\n"
"declare inx integer;\n"
"declare depth integer;\n"
"declare parent_id integer;\n"
"declare det, cname varchar;\n"
"\n"
"inx := 0;\n"
"depth := length (path);\n"
"whenever not found goto not_found;\n"
"while (inx < depth)\n"
"{\n"
"cname := aref (path, inx);\n"
"select COL_ID, COL_DET into parent_id, det from WS.WS.SYS_DAV_COL where COL_NAME = cname and COL_PARENT = parent_id;\n"
"if (det is not NULL)\n"
"signal (\'37000\', sprintf (\'WS.WS.FINDCOL() is used to access special DAV collection of type \"%s\"\', det));\n"
"col := parent_id;\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"not_found:\n"
"return inx;\n"
"}\n"
"--src dav.sql:1438\n"
;

static const char *proc17 = 
"#line 1466 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.FINDRES (in path varchar,out _col integer, out _name varchar)\n"
"{\n"
"declare depth integer;\n"
"declare col integer;\n"
"declare name varchar;\n"
"declare rc integer;\n"
"declare res_inx integer;\n"
"declare id integer;\n"
"\n"
"rc := 0;\n"
"res_inx := length (path);\n"
"col := 0;\n"
"name := aref (path, res_inx - 1);\n"
"if (res_inx < 1) rc := 0;\n"
"depth := WS.WS.FINDCOL (path, col);\n"
"if (depth = res_inx)\n"
"return 0;\n"
"if (depth < res_inx - 1)\n"
"return -1;\n"
"\n"
"whenever not found goto not_found;\n"
"select RES_ID into id from WS.WS.SYS_DAV_RES where RES_NAME = name and RES_COL = col;\n"
"\n"
"if (id is null)\n"
"return 0;\n"
"\n"
"if (id > 0)\n"
"{\n"
"rc := 1;\n"
"_col := col;\n"
"_name := name;\n"
"}\n"
"not_found:\n"
"return rc;\n"
"}\n"
"--src dav.sql:1464\n"
;

static const char *proc18 = 
"#line 1504 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.DELCHILDREN (in id integer, in lines varchar)\n"
"{\n"
"declare col, res, r_id, n_locks, rc integer;\n"
"declare name, if_token varchar;\n"
"declare icol integer;\n"
"declare cname varchar;\n"
"declare c_cur cursor for select COL_ID, COL_NAME from WS.WS.SYS_DAV_COL where COL_PARENT = id;\n"
"declare r_cur cursor for select RES_ID, RES_NAME from WS.WS.SYS_DAV_RES where RES_COL = id;\n"
"\n"
"select count (COL_ID) into col from WS.WS.SYS_DAV_COL where COL_PARENT = id;\n"
"select count (RES_ID) into res from WS.WS.SYS_DAV_RES where RES_COL = id;\n"
"if_token := WS.WS.FINDPARAM (lines, \'If\');\n"
"if (isnull (if_token))\n"
"if_token := \'\';\n"
"\n"
"if (res > 0)\n"
"{\n"
"whenever not found goto del_res_end;\n"
"open r_cur;\n"
"while (1)\n"
"{\n"
"fetch r_cur into r_id, name;\n"
"select count (LOCK_TOKEN) into n_locks from WS.WS.SYS_DAV_LOCK where\n"
"LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = r_id and isnull (strstr (if_token, LOCK_TOKEN));\n"
"if (n_locks > 0)\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (concat (\n"
"\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\',\n"
"\'<d:multistatus xmlns:d=\"DAV:\">\',\n"
"\'<d:response>\',\n"
"\'<d:href>\',\n"
"DB.DBA.DAV_HREF_URL (name),\n"
"\'</d:href>\',\n"
"\'<d:status>HTTP/1.1 423 Locked</d:status>\',\n"
"\'</d:response>\',\n"
"\'</d:multistatus>\'\n"
"));\n"
"return 1;\n"
"}\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = r_id;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = r_id;\n"
"}\n"
"del_res_end:\n"
"close r_cur;\n"
"}\n"
"\n"
"if (col > 0)\n"
"{\n"
"whenever not found goto del_col_end;\n"
"open c_cur;\n"
"while (1)\n"
"{\n"
"fetch c_cur into icol, cname;\n"
"select count (LOCK_TOKEN) into n_locks from WS.WS.SYS_DAV_LOCK where\n"
"LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = icol and isnull (strstr (if_token, LOCK_TOKEN));\n"
"if (n_locks > 0)\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (concat (\n"
"\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\',\n"
"\'<d:multistatus xmlns:d=\"DAV:\">\',\n"
"\'<d:response>\',\n"
"\'<d:href>\',\n"
"DB.DBA.DAV_HREF_URL (cname),\n"
"\'</d:href>\',\n"
"\'<d:status>HTTP/1.1 423 Locked</d:status>\',\n"
"\'</d:response>\',\n"
"\'</d:multistatus>\'\n"
"));\n"
"return 1;\n"
"}\n"
"rc := WS.WS.DELCHILDREN (icol, lines);\n"
"if (rc > 0)\n"
"{\n"
"return 1;\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_PARENT = id and COL_NAME = cname;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = icol;\n"
"}\n"
"del_col_end:\n"
"close c_cur;\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:1502\n"
;

static const char *proc19 = 
"#line 1591 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.\"DELETE\" (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare depth, len integer;\n"
"declare src_id any;\n"
"declare uname, upwd, _perms varchar;\n"
"declare rc integer;\n"
"declare res integer;\n"
"declare u_id, g_id integer;\n"
"declare what, full_path varchar;\n"
"\n"
"uname := null;\n"
"upwd := null;\n"
"u_id := null;\n"
"g_id := null;\n"
"\n"
"set isolation = \'serializable\';\n"
"if ((length(path) > 1) and (\'\' = path[length(path)-1]))\n"
"{\n"
"what := \'C\';\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"}\n"
"else\n"
"{\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (src_id is not null)\n"
"{\n"
"what := \'C\';\n"
"path := vector_concat (path, vector (\'\'));\n"
"}\n"
"else\n"
"{\n"
"what := \'R\';\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"}\n"
"}\n"
"\n"
"if (src_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return;\n"
"}\n"
"rc := DAV_AUTHENTICATE_HTTP (src_id, what, \'11_\', 1, lines, uname, upwd, u_id, g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"\n"
"full_path := DAV_CONCAT_PATH (\'/\', path);\n"
"rc := DAV_DELETE_INT (full_path, 1, null, null, 0);\n"
"if (rc >= 0)\n"
"{\n"
"http_header (WS.WS.LDP_HDRS (0, 0, 0, 0, full_path));\n"
"DB.DBA.DAV_SET_HTTP_STATUS (204);\n"
"}\n"
"else if (rc = -8)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (500);\n"
"}\n"
"return;\n"
"}\n"
"--src dav.sql:1589\n"
;

static const char *proc20 = 
"#line 1664 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ISCOL (in path varchar)\n"
"{\n"
"declare depth, len, col integer;\n"
"depth := WS.WS.FINDCOL (path, col);\n"
"len := length (path);\n"
"if (depth = len)\n"
"return 1;\n"
"else\n"
"return 0;\n"
"}\n"
"--src dav.sql:1662\n"
;

static const char *proc21 = 
"#line 1677 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ISRES (in path varchar)\n"
"{\n"
"declare col, rc integer;\n"
"declare name varchar;\n"
"rc := WS.WS.FINDRES (path, col, name);\n"
"if (rc < 0)\n"
"rc := 0;\n"
"return (rc);\n"
"}\n"
"--src dav.sql:1675\n"
;

static const char *proc22 = 
"#line 1689 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ETAG (\n"
"in name varchar,\n"
"in id integer,\n"
"in modt any)\n"
"{\n"
"declare etag varchar;\n"
"\n"
"if (isvector (id))\n"
"etag := sprintf (\'%d-%s-%d\', rnd(1000), cast (now() as varchar), rnd (1000));\n"
"else\n"
"etag := sprintf (\'%d-%s-%s\', id, cast (modt as varchar), name);\n"
"\n"
"return md5 (etag);\n"
"}\n"
"--src dav.sql:1687\n"
;

static const char *proc23 = 
"#line 1705 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ETAG_BY_ID (in id any, in tp varchar)\n"
"{\n"
"declare id_, name_, mod_time any;\n"
"whenever not found goto ret;\n"
"if (isvector (id))\n"
"return WS.WS.ETAG (\'\', id, now ());\n"
"if (tp = \'R\')\n"
"select RES_COL, RES_NAME, RES_MOD_TIME into id_, name_, mod_time from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"else\n"
"select COL_ID, COL_NAME, COL_MOD_TIME into id_, name_, mod_time from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"return WS.WS.ETAG (name_, id_, mod_time);\n"
"ret:\n"
"return null;\n"
"}\n"
"--src dav.sql:1703\n"
;

static const char *proc24 = 
"#line 1722 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.HEAD (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"\n"
"WS.WS.GET (path, params, lines);\n"
"}\n"
"--src dav.sql:1720\n"
;

static const char *proc25 = 
"#line 1729 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.DAV_LINK (in p varchar)\n"
"{\n"
"declare def, h, s any;\n"
"def := registry_get (\'URIQADefaultHost\');\n"
"h := sprintf (\'%s://%s\', case when is_https_ctx () then \'https\' else \'http\' end, http_host (def));\n"
"s := string_output ();\n"
"http_dav_url (p, null, s);\n"
"s := string_output_string (s);\n"
"return h || p;\n"
"}\n"
"--src dav.sql:1727\n"
;

static const char *proc26 = 
"#line 1744 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PUT (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare rc, _col, _col_parent_id integer;\n"
"declare id integer;\n"
"declare content_type, content_type_attr varchar;\n"
"declare _cont_len integer;\n"
"declare full_path, _perms, auth_name, auth_pwd varchar;\n"
"declare uid, gid integer;\n"
"declare location varchar;\n"
"declare ses any;\n"
"\n"
"declare _atomPub integer;\n"
"declare _path, _destination, _oldName, _name, _what, _method, _category varchar;\n"
"declare _xtree, _content, _parts any;\n"
"declare client_etag, server_etag, slug, res_name_, rc_type varchar;\n"
"declare res_id_, id_ integer;\n"
"declare mod_time datetime;\n"
"declare o_perms, o_uid, o_gid any;\n"
"\n"
"whenever sqlstate \'*\' goto error_ret;\n"
"\n"
"\n"
"ses := WS.WS.GET_BODY (params);\n"
"\n"
"_atomPub := 0;\n"
"content_type := WS.WS.FINDPARAM (lines, \'Content-Type\');\n"
"content_type_attr := http_request_header (lines, \'Content-Type\', \'type\', \'\');\n"
"_method := http_request_get (\'REQUEST_METHOD\');\n"
"rc_type := \'R\';\n"
"if ((content_type = \'application/atom+xml\') and (content_type_attr = \'entry\'))\n"
"{\n"
"\n"
"\n"
"\n"
"_atomPub := 1;\n"
"_xtree := xml_tree_doc (ses);\n"
"ses := xpath_eval (\'[ xmlns=\"http://www.w3.org/2005/Atom\" ] string (/entry/content)\', _xtree, 1);\n"
"}\n"
"\n"
"if (content_type = \'multipart/related\')\n"
"{\n"
"\n"
"\n"
"\n"
"_atomPub := 1;\n"
"if (length (ses) = 0)\n"
"{\n"
"_xtree := xml_tree_doc (blob_to_string (get_keyword (\'mime_part1\', params, \'\')));\n"
"content_type := get_keyword (\'Content-Type\', get_keyword (\'attr-mime_part2\', params, vector ()), \'\');\n"
"ses := blob_to_string (get_keyword (\'mime_part2\', params, \'\'));\n"
"}\n"
"else\n"
"{\n"
"_content := \'Content-Type:\' || WS.WS.FINDPARAM (lines, \'Content-Type\') || \'\\r\\n\\r\\n\' || ses;\n"
"_parts := mime_tree (_content);\n"
"rc := -28;\n"
"if (not isarray (_parts))\n"
"goto error_ret;\n"
"\n"
"if (not isarray (_parts[0]))\n"
"goto error_ret;\n"
"\n"
"_parts := _parts[2];\n"
"if (length (_parts) <> 2)\n"
"goto error_ret;\n"
"\n"
"if (get_keyword (\'Content-Type\', _parts[0][0], \'\') <> \'application/atom+xml\')\n"
"goto error_ret;\n"
"\n"
"if (get_keyword (\'type\', _parts[0][0], \'\') <> \'entry\')\n"
"goto error_ret;\n"
"\n"
"_xtree := xml_tree_doc (subseq (blob_to_string (_content), _parts[0][1][0], _parts[0][1][1]));\n"
"content_type := get_keyword (\'Content-Type\', _parts[1][0], \'\');\n"
"ses := subseq (blob_to_string (_content), _parts[1][1][0], _parts[1][1][1]);\n"
"}\n"
"}\n"
"\n"
"if (_atomPub)\n"
"{\n"
"_name := serialize_to_UTF8_xml (xpath_eval (\'[ xmlns=\"http://www.w3.org/2005/Atom\" ] string (/entry/title)\', _xtree, 1));\n"
"_category := serialize_to_UTF8_xml (xpath_eval (\'[ xmlns=\"http://www.w3.org/2005/Atom\" ] string (/entry/category/@term)\', _xtree, 1));\n"
"\n"
"if (is_empty_or_null (_category))\n"
"_category := \'resource\';\n"
"\n"
"_what := case when (_category = \'collection\') then \'C\' else \'R\' end;\n"
"if (_method = \'POST\')\n"
"{\n"
"if (is_empty_or_null (_name))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"_oldName := _name;\n"
"path := vector_concat (path, vector (_name));\n"
"}\n"
"else if (_method = \'PUT\')\n"
"{\n"
"_oldName := path[length (path)-1];\n"
"}\n"
"if (_method = \'PUT\')\n"
"{\n"
"_path := vector_concat (vector(\'\'), path);\n"
"if (_what = \'C\')\n"
"_path := vector_concat (_path, vector(\'\'));\n"
"\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (_path, _what)) is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"}\n"
"if (_category = \'collection\')\n"
"{\n"
"if (_method = \'POST\')\n"
"{\n"
"rc := WS.WS.MKCOL (path, params, lines, \'atomPub\');\n"
"}\n"
"else if ((_method = \'PUT\') and not is_empty_or_null (_name) and (_name <> _oldName))\n"
"{\n"
"\n"
"full_path := DB.DBA.DAV_CONCAT_PATH (_path, null);\n"
"_destination := concat (left (full_path, strrchr (rtrim (full_path, \'/\'), \'/\')), \'/\', _name, either (equ (right (full_path, 1), \'/\'), \'/\', \'\'));\n"
"rc := DB.DBA.DAV_MOVE_INT (full_path, _destination, 0, null, null, 0);\n"
"}\n"
"if (DAV_HIDE_ERROR (rc) is not null)\n"
"WS.WS.DAV_ATOM_ENTRY (rc, \'C\');\n"
"\n"
"return;\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"path := WS.WS.FIXPATH (path);\n"
"\n"
"full_path := DAV_CONCAT_PATH (\'/\', path);\n"
"slug := WS.WS.FINDPARAM (lines, \'Slug\');\n"
"if (slug <> \'\')\n"
"{\n"
"full_path := rtrim (full_path, \'/\') || \'/\' || slug;\n"
"path := vector_concat (path, vector (slug));\n"
"}\n"
"\n"
"uid := null;\n"
"gid := null;\n"
"res_id_ := DAV_HIDE_ERROR (DAV_SEARCH_ID (full_path, \'R\'));\n"
"_col := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (full_path, \'/\'), \'C\'));\n"
"_col_parent_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'P\'));\n"
"if (_col_parent_id is not null)\n"
"{\n"
"\n"
"if (_col is not null)\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (_col, \'C\', \'1__\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"}\n"
"else if (res_id_ is not null)\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (res_id_, \'R\', \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"if (rc >= 0)\n"
"rc := DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'1__\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"}\n"
"\n"
"if (rc < 0)\n"
"goto error_ret;\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"\n"
"rc := WS.WS.ISLOCKED (vector_concat (vector (\'\'), path), WS.WS.FINDPARAM (lines, \'If\'));\n"
"if (isnull (rc))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (412);\n"
"return;\n"
"}\n"
"if (rc)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"return;\n"
"}\n"
"\n"
"if (content_type = \'\')\n"
"{\n"
"content_type := http_mime_type (full_path);\n"
"}\n"
"_cont_len := atoi (WS.WS.FINDPARAM (lines, \'Content-Length\'));\n"
"if ((full_path like \'%.vsp\' or full_path like \'%.vspx\') and _cont_len > 0)\n"
"{\n"
"content_type := \'text/html\';\n"
"}\n"
"client_etag := trim (WS.WS.FINDPARAM (lines, \'If-Match\'), \'\" \\r\\n\');\n"
"o_perms := _perms;\n"
"o_uid := uid;\n"
"o_gid := gid;\n"
"if ((res_id_ is not null or _col is not null) and length (client_etag))\n"
"{\n"
"server_etag := client_etag;\n"
"if (res_id_ is not null)\n"
"{\n"
"if (isinteger(res_id_))\n"
"{\n"
"select RES_COL, RES_NAME, RES_MOD_TIME, RES_OWNER, RES_GROUP, RES_PERMS into id_, res_name_, mod_time, o_uid, o_gid, o_perms from WS.WS.SYS_DAV_RES where RES_ID = res_id_;\n"
"server_etag := WS.WS.ETAG (res_name_, id_, mod_time);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (isinteger(_col))\n"
"{\n"
"select COL_ID, COL_NAME, COL_MOD_TIME into id_, res_name_, mod_time from WS.WS.SYS_DAV_COL where COL_ID = _col;\n"
"server_etag := WS.WS.ETAG (res_name_, id_, mod_time);\n"
"}\n"
"}\n"
"if (client_etag <> server_etag)\n"
"{\n"
"http_status_set (412);\n"
"return;\n"
"}\n"
"}\n"
"if ((res_id_ is not null) and isinteger (res_id_) and (length (client_etag) = 0))\n"
"{\n"
"select RES_OWNER, RES_GROUP, RES_PERMS into o_uid, o_gid, o_perms from WS.WS.SYS_DAV_RES where RES_ID = res_id_;\n"
"}\n"
"if (registry_get (\'LDP_strict_put\') = \'1\' and _method = \'PUT\'\n"
"and (res_id_ is not null or _col is not null) and content_type = \'text/turtle\' and length (client_etag) = 0)\n"
"{\n"
"http_status_set (428);\n"
"return;\n"
"}\n"
"\n"
"\n"
"if ((content_type <> \'text/turtle\') and (res_id_ is not null))\n"
"WS.WS.TTL_QUERY_POST_CLEAR (full_path);\n"
"\n"
"if (content_type = \'application/sparql-query\')\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (200);\n"
"if (_method = \'PUT\')\n"
"{\n"
"WS.WS.SPARQL_QUERY_POST (full_path, ses, uid, 1);\n"
"}\n"
"else\n"
"{\n"
"if (_col is not null)\n"
"full_path := DAV_CONCAT_PATH (full_path, \'/\');\n"
"\n"
"WS.WS.SPARQL_QUERY_GET (ses, full_path, path, lines);\n"
"return;\n"
"}\n"
"}\n"
"else if ((content_type = \'text/turtle\') and not DB.DBA.DAV_MAC_METAFILE (full_path))\n"
"{\n"
"declare gr, newg, newpath, link, arr, is_container any;\n"
"\n"
"newpath := DAV_CONCAT_PATH (full_path, \'/\');\n"
"is_container := 0;\n"
"link := http_request_header (lines, \'Link\', null, null);\n"
"arr := split_and_decode (link, 0, \'\\0\\0;=\');\n"
"if ((length (arr) = 4 and arr[0] = \'<http://www.w3.org/ns/ldp#BasicContainer>\') or _col is not null)\n"
"{\n"
"is_container := 1;\n"
"if (length (ses) = 0)\n"
"http (\'<> a <http://www.w3.org/ns/ldp#BasicContainer>. \', ses);\n"
"\n"
"full_path := newpath;\n"
"}\n"
"rc := WS.WS.TTL_QUERY_POST (full_path, ses, case when _col is not null or is_container then 0 else 1 end);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"goto error_ret;\n"
"\n"
"gr := iri_to_id (WS.WS.DAV_IRI (full_path));\n"
"if (is_container or (sparql define input:inference \"ldp\" ask where { graph ?:gr { ?:gr a <http://www.w3.org/ns/ldp#Container> }}))\n"
"{\n"
"newg := iri_to_id (WS.WS.DAV_IRI (newpath));\n"
"if (gr <> newg)\n"
"{\n"
"sparql move graph ?:gr to ?:newg;\n"
"}\n"
"rc_type := \'C\';\n"
"if (_col is null)\n"
"{\n"
"rc := DAV_COL_CREATE_INT (newpath, _perms, null, null, null, null, 1, 0, 1, uid, gid);\n"
"}\n"
"else\n"
"{\n"
"rc := _col;\n"
"}\n"
"\n"
"if (not DB.DBA.LDP_ENABLED (rc))\n"
"{\n"
"declare propName, propValue varchar;\n"
"\n"
"propName := \'LDP\';\n"
"propValue := \'ldp:BasicContainer\';\n"
"DB.DBA.DAV_PROP_SET_RAW (rc, \'C\', propName, propValue, 1, http_dav_uid ());\n"
"}\n"
"\n"
"http_header (sprintf (\'Location: %s\\r\\n\', WS.WS.DAV_LINK (newpath)));\n"
"http_header (http_header_get () || WS.WS.LDP_HDRS (1, 1, 0, 0, newpath));\n"
"\n"
"goto rcck;\n"
"}\n"
"http_header (sprintf (\'Location: %s\\r\\n\', WS.WS.DAV_LINK (full_path)));\n"
"http_header (http_header_get () || WS.WS.LDP_HDRS (0, 1, 0, 0, full_path));\n"
"}\n"
"else\n"
"{\n"
"http_header (sprintf (\'Location: %s\\r\\nLink: <http://www.w3.org/ns/ldp#Resource>; rel=\"type\"\\r\\n\', WS.WS.DAV_LINK (full_path)));\n"
"}\n"
"\n"
"rc := DAV_RES_UPLOAD_STRSES_INT (full_path, ses, content_type, o_perms, auth_name, null, auth_name, auth_pwd, 0, now(), now(), null, o_uid, o_gid, 0, 1);\n"
"\n"
"if (_atomPub and (_method = \'PUT\') and not is_empty_or_null (_name) and (_name <> _oldName))\n"
"{\n"
"\n"
"_destination := concat (left (full_path, strrchr (rtrim (full_path, \'/\'), \'/\')), \'/\', _name, either (equ (right (full_path, 1), \'/\'), \'/\', \'\'));\n"
"rc := DB.DBA.DAV_MOVE_INT (full_path, _destination, 0, null, null, 0);\n"
"}\n"
"\n"
"rcck:\n"
"if (DAV_HIDE_ERROR (rc) is not null)\n"
"{\n"
"commit work;\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"\n"
"declare _etag varchar;\n"
"\n"
"_etag := WS.WS.ETAG_BY_ID (rc, rc_type);\n"
"if (_etag is not null)\n"
"http_header (http_header_get () || sprintf (\'ETag: \"%s\"\\r\\n\', _etag));\n"
"\n"
"if (_atomPub)\n"
"{\n"
"WS.WS.DAV_ATOM_ENTRY (rc, \'R\');\n"
"}\n"
"else\n"
"{\n"
"http_header (http_header_get () || sprintf(\'Content-Type: %s\\r\\n\', content_type));\n"
"if (content_type = \'application/sparql-query\')\n"
"{\n"
"http_header (http_header_get () || http_header (\'MS-Author-Via: SPARQL\\r\\n\'));\n"
"}\n"
"else\n"
"{\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>201 Created</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Created</H1>\',\n"
"\'Resource \', sprintf (\'%V\', full_path),\' has been created.</BODY></HTML>\')\n"
");\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"\n"
"error_ret:\n"
"\n"
"if (__SQL_STATE = \'40001\')\n"
"{\n"
"rollback work;\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"http_body_read ();\n"
"DAV_SET_HTTP_REQUEST_STATUS (rc);\n"
"if (rc = -44)\n"
"http_value (connection_get (\'__sql_message\'), \'p\');\n"
"if ((rc < 0) and bit_and (sys_stat (\'public_debug\'), 2))\n"
"http_value (callstack_dump (), \'pre\');\n"
"}\n"
"--src dav.sql:1742\n"
;

static const char *proc27 = 
"#line 2133 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PATCH (\n"
"in path any,\n"
"inout params any,\n"
"in lines any)\n"
"{\n"
"\n"
"declare rc, _res_id, _col, _col_parent_id integer;\n"
"declare content_type varchar;\n"
"declare full_path, _perms, auth_name, auth_pwd varchar;\n"
"declare uid, gid integer;\n"
"declare location, etag varchar;\n"
"declare ses any;\n"
"whenever sqlstate \'*\' goto error_ret;\n"
"\n"
"\n"
"\n"
"ses := WS.WS.GET_BODY (params);\n"
"\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"path := WS.WS.FIXPATH (path);\n"
"full_path := DAV_CONCAT_PATH (\'/\', path);\n"
"_res_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (full_path, \'R\'));\n"
"_col := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (full_path, \'/\'), \'C\'));\n"
"_col_parent_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'P\'));\n"
"if (_col_parent_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"\n"
"uid := null;\n"
"gid := null;\n"
"if (_col is not null)\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (_col, \'C\', \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"}\n"
"else if (_res_id is not null)\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (_res_id, \'R\', \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"if (rc >= 0)\n"
"rc := DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'1__\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'11_\', 1, lines, auth_name, auth_pwd, uid, gid, _perms);\n"
"}\n"
"\n"
"if (rc < 0)\n"
"goto error_ret;\n"
"\n"
"rc := WS.WS.ISLOCKED (vector_concat (vector (\'\'), path), WS.WS.FINDPARAM (lines, \'If\'));\n"
"if (isnull (rc))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (412);\n"
"return;\n"
"}\n"
"if (rc)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"return;\n"
"}\n"
"content_type := WS.WS.FINDPARAM (lines, \'Content-Type\');\n"
"if (content_type = \'\')\n"
"content_type := http_mime_type (full_path);\n"
"\n"
"rc := 0;\n"
"if ((full_path like \'%.vsp\' or full_path like \'%.vspx\') and atoi (WS.WS.FINDPARAM (lines, \'Content-Length\')) > 0)\n"
"{\n"
"content_type := \'text/html\';\n"
"}\n"
"else if (content_type = \'application/sparql-update\')\n"
"{\n"
"declare giid, meta, data any;\n"
"\n"
"if (not WS.WS.SPARQL_QUERY_UPDATE (ses, full_path, path, lines))\n"
"return;\n"
"\n"
"giid := iri_to_id (WS.WS.DAV_IRI (full_path));\n"
"set_user_id (\'dba\');\n"
"exec (\'sparql define output:format \"NICE_TTL\" construct { ?s ?p ?o } where { graph ?? { ?s ?p ?o }}\', null, null, vector (giid), 0, meta, data);\n"
"if (not (isvector (data) and length (data) = 1 and isvector (data[0]) and length (data[0]) = 1 and __tag (data[0][0]) = 185))\n"
"goto _skip;\n"
"\n"
"ses := data[0][0];\n"
"content_type := \'text/turtle\';\n"
"}\n"
"if ((_res_id is not null) and isinteger (_res_id))\n"
"{\n"
"select RES_OWNER, RES_GROUP, RES_PERMS into uid, gid, _perms from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"}\n"
"rc := DB.DBA.DAV_RES_UPLOAD_STRSES_INT (full_path, ses, content_type, _perms, auth_name, null, auth_name, auth_pwd, 0, now(), now(), null, uid, gid, 0, 0);\n"
"\n"
"_skip:;\n"
"if (DB.DBA.DAV_HIDE_ERROR (rc) is not null)\n"
"{\n"
"commit work;\n"
"DB.DBA.DAV_SET_HTTP_STATUS (204);\n"
"http_header (sprintf (\'Content-Location: %s%s\\r\\n\', WS.WS.DAV_HOST (), full_path));\n"
"etag := WS.WS.ETAG_BY_ID (rc, \'R\');\n"
"if (etag is not null)\n"
"http_header (http_header_get () || sprintf (\'ETag: \"%s\"\\r\\n\', etag));\n"
"\n"
"http_rewrite ();\n"
"\n"
"return;\n"
"}\n"
"\n"
"error_ret:;\n"
"if (__SQL_STATE = \'40001\')\n"
"{\n"
"rollback work;\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"http_body_read ();\n"
"DAV_SET_HTTP_REQUEST_STATUS (rc);\n"
"if ((rc < 0) and bit_and (sys_stat (\'public_debug\'), 2))\n"
"http_value (callstack_dump (), \'pre\');\n"
"\n"
"return;\n"
"}\n"
"--src dav.sql:2131\n"
;

static const char *proc28 = 
"#line 2258 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.HEX_TO_DEC (in c char)\n"
"{\n"
"if (c >= \'0\' and c <= \'9\')\n"
"return (ascii(c) - ascii(\'0\'));\n"
"if (c >= \'a\' and c <= \'f\')\n"
"return (10 + ascii(c) - ascii(\'a\'));\n"
"if (c >= \'A\' and c <= \'F\')\n"
"return (10 + ascii(c) - ascii(\'A\'));\n"
"return 0;\n"
"}\n"
"--src dav.sql:2256\n"
;

static const char *proc29 = 
"#line 2270 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.STR_TO_URI (in str varchar)\n"
"{\n"
"declare tmp varchar;\n"
"declare inx, inx1, len integer;\n"
"declare escapes varchar;\n"
"declare c char;\n"
"escapes := \';?:@&=+ \"#%<>\';\n"
"len := length (str);\n"
"if (len = 0)\n"
"return \'\';\n"
"inx := 0;\n"
"inx1 := 0;\n"
"tmp := repeat (\' \', len * 3);\n"
"\n"
"while (inx < len)\n"
"{\n"
"c := chr (aref (str, inx));\n"
"if (not isnull (strchr (escapes, c)))\n"
"{\n"
"aset (tmp, inx1, ascii(\'%\'));\n"
"aset (tmp, inx1 + 1, WS.WS.HEX_DIGIT (ascii(c) / 16));\n"
"aset (tmp, inx1 + 2, WS.WS.HEX_DIGIT (mod (ascii(c), 16)));\n"
"inx1 := inx1 + 2;\n"
"}\n"
"else\n"
"aset (tmp, inx1, ascii(c));\n"
"inx1 := inx1 + 1;\n"
"inx := inx + 1;\n"
"}\n"
"return trim(tmp);\n"
"}\n"
"--src dav.sql:2268\n"
;

static const char *proc30 = 
"#line 2303 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PATHREF (in path varchar, in elem integer, in host varchar, out name_len integer)\n"
"{\n"
"declare inx, len, pos, inx1 integer;\n"
"declare name varchar;\n"
"declare c, cd1, cd2 char;\n"
"declare nelem integer;\n"
"declare temp varchar;\n"
"declare nslash integer;\n"
"declare lastslash integer;\n"
"declare new_path varchar;\n"
"\n"
"name_len := 0;\n"
"nslash := 0;\n"
"nelem := elem;\n"
"if (host <> \'\')\n"
"nelem := nelem + 2;\n"
"temp := path;\n"
"name := \'\';\n"
"len := length (path);\n"
"inx := 0;\n"
"inx1 := 0;\n"
"lastslash := 0;\n"
"new_path := repeat (\' \', len);\n"
"while (inx < len)\n"
"{\n"
"c := chr (aref (path, inx));\n"
"aset (new_path, inx1, ascii(c));\n"
"if (c = \'%\')\n"
"{\n"
"cd1 := chr(aref (path, inx + 1));\n"
"cd2 := chr(aref (path, inx + 2));\n"
"aset (new_path, inx1, (WS.WS.HEX_TO_DEC (cd1) * 16) + WS.WS.HEX_TO_DEC (cd2));\n"
"inx := inx + 2;\n"
"}\n"
"if (c = \'/\')\n"
"{\n"
"nslash := nslash + 1;\n"
"lastslash := inx;\n"
"}\n"
"inx := inx + 1;\n"
"inx1 := inx1 + 1;\n"
"}\n"
"\n"
"temp := trim(new_path);\n"
"\n"
"\n"
"if (nelem <= nslash)\n"
"nslash := nelem;\n"
"else\n"
"return name;\n"
"\n"
"while (nslash > 0)\n"
"{\n"
"pos :=  strchr (temp , \'/\');\n"
"temp := substring (temp, pos+2, len);\n"
"nslash := nslash - 1;\n"
"}\n"
"pos := strchr (temp, \'/\');\n"
"\n"
"if (isnull(pos))\n"
"pos := length (temp);\n"
"\n"
"if ( pos > 0 )\n"
"{\n"
"name := substring (temp, 1, pos);\n"
"name_len := length (name);\n"
"}\n"
"return name;\n"
"}\n"
"--src dav.sql:2301\n"
;

static const char *proc31 = 
"#line 2374 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.IS_ACTIVE_CONTENT (in f varchar)\n"
"{\n"
"declare dot integer;\n"
"declare ext varchar;\n"
"\n"
"dot := strrchr (f, \'.\');\n"
"if (dot is null)\n"
"return 0;\n"
"ext := lower (substring (f, dot + 2, length (f)));\n"
"if (ext in (\'vsp\', \'vspx\')\n"
"or __proc_exists (concat (\'__http_handler_\' , ext), 2)\n"
"or __proc_exists (concat (\'WS.WS.__http_handler_\' , ext), 1))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src dav.sql:2372\n"
;

static const char *proc32 = 
"#line 2391 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET_DAV_DEFAULT_PAGE (inout path any)\n"
"{\n"
"\n"
"declare _list, path1 any;\n"
"declare _all varchar;\n"
"declare idx, len, line integer;\n"
"\n"
"_all := http_map_get (\'default_page\');\n"
"if (not isstring (_all))\n"
"goto brws_check;\n"
"\n"
"_list :=  split_and_decode (_all, 0, \'\\0\\0;\');\n"
"idx := 0;\n"
"len := length (_list);\n"
"while (idx < len)\n"
"{\n"
"line := trim (_list[idx]);\n"
"path1 := vector_concat (path, vector (line));\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (vector (\'/\'), path1), \'R\')) is not null)\n"
"{\n"
"path := path1;\n"
"\n"
"return line;\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"brws_check:\n"
"if (0 = http_map_get (\'browseable\'))\n"
"{\n"
"declare dp any;\n"
"\n"
"dp := case when (not isstring (_all)) then \'\' else sprintf (\'Default page (%s) of folder \', _all) end;\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404, null, null, sprintf (\'%V%V not found.\', dp, http_path ()));\n"
"return null;\n"
"}\n"
"\n"
"return \'\';\n"
"}\n"
"--src dav.sql:2389\n"
;

static const char *proc33 = 
"#line 2432 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET_DAV_CHUNKED_QUOTA () returns integer\n"
"{\n"
"declare dav_chunked_quota integer;\n"
"\n"
"dav_chunked_quota := atoi (\n"
"coalesce (\n"
"virtuoso_ini_item_value (\'HTTPServer\', \'DAVChunkedQuota\'),\n"
"\'1000000\'));\n"
"if (dav_chunked_quota < 1)\n"
"dav_chunked_quota := 1000000;\n"
"return dav_chunked_quota;\n"
"}\n"
"--src dav.sql:2430\n"
;

static const char *proc34 = 
"#line 2447 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET (\n"
"in path any,\n"
"inout params any,\n"
"in lines any)\n"
"{\n"
"\n"
"declare path_len integer;\n"
"declare content long varchar;\n"
"declare content_type varchar;\n"
"declare rc, err integer;\n"
"declare _col integer;\n"
"declare _name, uname, upwd varchar;\n"
"declare _cont_len integer;\n"
"declare full_path varchar;\n"
"declare parent_path varchar;\n"
"declare cont_type, perms varchar;\n"
"declare server_etag, client_etag, rdf_graph varchar;\n"
"declare uid, gid, maxres integer;\n"
"declare p_comm, stat, msg, xpr, sxtag, rxtag, resource_content, str varchar;\n"
"declare resource_owner, exec_safety_level integer;\n"
"declare _res_id, _col_id, is_admin_owned_res, is_pattern integer;\n"
"declare def_page varchar;\n"
"declare asmx_path, auth_opts, webid_check, webid_check_rc, modt any;\n"
"\n"
"\n"
"if (WS.WS.DAV_CHECK_ASMX (path, asmx_path))\n"
"path := asmx_path;\n"
"\n"
"def_page := \'\';\n"
"is_pattern := 0;\n"
"full_path := http_physical_path ();\n"
"if (full_path = \'\')\n"
"full_path := \'/\';\n"
"\n"
"full_path := WS.WS.DAV_REMOVE_ASMX (full_path);\n"
"\n"
"again:\n"
"_col_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (DAV_CONCAT_PATH (\'/\', full_path), \'/\'), \'C\'));\n"
"_res_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (\'/\', full_path), \'R\'));\n"
"if (strchr (full_path, \'*\') is not null and _res_id is null and _col_id is null)\n"
"{\n"
"_col_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (DAV_CONCAT_PATH (\'/\', full_path), \'/\'), \'P\'));\n"
"is_pattern := 1;\n"
"}\n"
"exec_safety_level := 0;\n"
"\n"
"if (_res_id is null and _col_id is null)\n"
"{\n"
"declare meta_path varchar;\n"
"declare meta_id any;\n"
"declare content_, type any;\n"
"\n"
"meta_path := DAV_CONCAT_PATH (\'/\', full_path);\n"
"if (meta_path like \'%,meta\')\n"
"{\n"
"meta_path := subseq (meta_path, 0, length (meta_path) - length (\',meta\'));\n"
"meta_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (meta_path, \'R\'));\n"
"if (meta_id is null)\n"
"goto _404;\n"
"\n"
"rc := DAV_AUTHENTICATE_HTTP (meta_id, \'R\', \'1__\', 1, lines, uname, upwd, uid, gid, perms);\n"
"if ((rc < 0) and (rc <> -1))\n"
"goto _403;\n"
"\n"
"rc := DAV_RES_CONTENT_META (meta_path, content_, type, 0, 0);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"goto _500;\n"
"\n"
"DB.DBA.DAV_SET_HTTP_STATUS (200);\n"
"http (content_);\n"
"}\n"
"else\n"
"{\n"
"declare procname varchar;\n"
"\n"
"procname := sprintf (\'%s.%s.%s\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"\n"
"if ( __proc_exists (procname) and\n"
"(cast (registry_get (full_path) as varchar) = \'no_vsp_recompile\') and\n"
"(http_map_get (\'noinherit\') = 1))\n"
"{\n"
"commit work;\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"call (procname)(path, params, lines);\n"
"__pop_user_id ();\n"
"return;\n"
"}\n"
"\n"
"_404:\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"}\n"
"return;\n"
"}\n"
"if (_col_id is not null and not is_pattern)\n"
"{\n"
"if (http_path () not like \'%/\')\n"
"{\n"
"declare url_pars varchar;\n"
"\n"
"url_pars := http_request_get (\'QUERY_STRING\');\n"
"if (length (url_pars))\n"
"url_pars := \'?\' || url_pars;\n"
"\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: %s/%s\\r\\n\', http_path (), url_pars));\n"
"return (0);\n"
"}\n"
"\n"
"def_page := WS.WS.GET_DAV_DEFAULT_PAGE (path);\n"
"if (def_page is null)\n"
"return;\n"
"\n"
"if (def_page <> \'\')\n"
"{\n"
"declare new_path varchar;\n"
"new_path := DAV_CONCAT_PATH (http_path (), def_page);\n"
"full_path := DAV_CONCAT_PATH (full_path, def_page);\n"
"http_internal_redirect (new_path);\n"
"goto again;\n"
"}\n"
"}\n"
"\n"
"if (not http_map_get (\'executable\'))\n"
"{\n"
"declare tgt_type, tgt_perms varchar;\n"
"declare tgt_id integer;\n"
"\n"
"\n"
"uname := null;\n"
"upwd := null;\n"
"uid := null;\n"
"tgt_perms := \'1__\';\n"
"if (_col_id is not null)\n"
"{\n"
"tgt_type := \'C\';\n"
"tgt_id := _col_id;\n"
"if (get_keyword (\'a\', params) in (\'new\', \'create\', \'upload\', \'link\', \'update\', \'imap\'))\n"
"tgt_perms := \'_1_\';\n"
"}\n"
"else\n"
"{\n"
"tgt_type := \'R\';\n"
"tgt_id := _res_id;\n"
"if (get_keyword (\'a\', params) in (\'update\', \'edit\'))\n"
"tgt_perms := \'_1_\';\n"
"}\n"
"rc := DAV_AUTHENTICATE_HTTP (tgt_id, tgt_type, tgt_perms, 1, lines, uname, upwd, uid, gid, perms);\n"
"if ((rc < 0) and (rc <> -1))\n"
"{\n"
"if (-24 <> rc)\n"
"{\n"
"_403:\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403, null, null, \'You are not permitted to view the content of this location: \' || sprintf (\'%V\', http_path ()), 1);\n"
"}\n"
"return;\n"
"}\n"
"if (_col_id is null and (rc >= 0))\n"
"{\n"
"if (uid = http_nobody_uid () and gid = http_nogroup_gid ())\n"
"uid := null;\n"
"\n"
"rc := DAV_AUTHENTICATE_HTTP (tgt_id, tgt_type, \'1_1\', 0, lines, uname, upwd, uid, gid, perms);\n"
"if (rc >= 0)\n"
"exec_safety_level := 1;\n"
"}\n"
"}\n"
"http_rewrite (0);\n"
"\n"
"\n"
"auth_opts := http_map_get (\'auth_opts\');\n"
"\n"
"if (isvector (auth_opts) and mod (length (auth_opts), 2) = 0)\n"
"{\n"
"webid_check := atoi (get_keyword (\'webid_check\', auth_opts, \'0\'));\n"
"}\n"
"else\n"
"{\n"
"webid_check := 0;\n"
"}\n"
"webid_check_rc := 1;\n"
"if (is_https_ctx () and webid_check and http_map_get (\'executable\'))\n"
"{\n"
"declare gid_, perms_, _check_id, _check_type any;\n"
"\n"
"uid := null;\n"
"if (isinteger (_res_id))\n"
"{\n"
"_check_id := _res_id;\n"
"_check_type := \'R\';\n"
"}\n"
"else\n"
"{\n"
"_check_id := _col_id;\n"
"_check_type := \'C\';\n"
"}\n"
"webid_check_rc := DAV_AUTHENTICATE_HTTP (_check_id, _check_type, \'1__\', 1, lines, uname, upwd, uid, gid_, perms_);\n"
"if ((webid_check_rc < 0) and (webid_check_rc <> -1))\n"
"return 0;\n"
"}\n"
"http_rewrite (0);\n"
"if (_col_id is not null and http_path () not like \'%/\' and not is_pattern)\n"
"{\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: %s/\\r\\n\', http_path ()));\n"
"return (0);\n"
"}\n"
"declare location varchar;\n"
"if (WS.WS.IS_REDIRECT_REF (path, lines, location) and (get_keyword (\'a\', params, \'\') not in (\'update\', \'edit\')))\n"
"{\n"
"declare host1 varchar;\n"
"\n"
"http_request_status (\'HTTP/1.1 302 Found\');\n"
"host1 := http_request_header (lines, \'Host\', NULL, NULL);\n"
"if (host1 is not null and location not like \'%://%\')\n"
"{\n"
"host1 := concat (\'http://\', host1);\n"
"}\n"
"else\n"
"{\n"
"host1 := \'\';\n"
"}\n"
"\n"
"http_header (sprintf (\'Location: %s%s\\r\\n\', host1, location));\n"
"return (0);\n"
"}\n"
"DB.DBA.DAV_SET_HTTP_STATUS (200);\n"
"client_etag := WS.WS.FINDPARAM (lines, \'If-None-Match\');\n"
"if ((_col_id is not null) or (_res_id is not null))\n"
"{\n"
"if ((WS.WS.FINDPARAM (lines, \'Content-Type\') = \'application/atom+xml\') and (http_request_header (lines, \'Content-Type\', \'type\', \'\') = \'entry\'))\n"
"{\n"
"if (_res_id is not null)\n"
"WS.WS.DAV_ATOM_ENTRY (_res_id, \'R\');\n"
"\n"
"if (_col_id is not null)\n"
"WS.WS.DAV_ATOM_ENTRY (_col_id, \'C\');\n"
"\n"
"return;\n"
"\n"
"}\n"
"if ((_col_id is not null) and (http_request_header (lines, \'Content-Type\', null, \'\') = \'application/atom+xml\') and (http_request_header (lines, \'Content-Type\', \'type\', \'\') = \'feed\'))\n"
"{\n"
"WS.WS.DAV_ATOM_ENTRY_LIST (_col_id, \'C\');\n"
"return;\n"
"}\n"
"}\n"
"if ((_col_id is not null) or ((_res_id is not null) and (get_keyword (\'a\', params) in (\'update\', \'edit\'))))\n"
"{\n"
"declare dir_ret any;\n"
"\n"
"\n"
"if (WS.WS.GET_EXT_DAV_LDP (path, lines, params, client_etag, full_path, _res_id, _col_id))\n"
"return;\n"
"\n"
"if (0 = http_map_get (\'browseable\'))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403, null, null, \'You are not permitted to view the directory index in this location: \' || sprintf (\'%V\', http_path ()), 1);\n"
"return;\n"
"}\n"
"dir_ret := WS.WS.DAV_DIR_LIST (path, params, lines, full_path, http_path(), _col_id, uname, upwd, uid);\n"
"if (DAV_HIDE_ERROR (dir_ret))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (\n"
"500,\n"
"\'HTTP/1.1 500 Internal Server Error or Misconfiguration\',\n"
"\'500 Internal Server Error or Misconfiguration\',\n"
"sprintf (\'Failed to return the directory index in this location: %V<br />%s\',  http_path (), DAV_PERROR (dir_ret)),\n"
"1\n"
");\n"
"}\n"
"\n"
"http_header (http_header_get () || WS.WS.LDP_HDRS (1, LDP_ENABLED (_col_id), 0, 0, full_path));\n"
"\n"
"server_etag := WS.WS.ETAG_BY_ID (_col_id, \'C\');\n"
"if (server_etag is not null)\n"
"http_header (http_header_get () || sprintf (\'ETag: \"%s\"\\r\\n\', server_etag));\n"
"\n"
"return;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"is_admin_owned_res := 0;\n"
"rc := 0;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"modt := null;\n"
"if (isinteger (_res_id))\n"
"{\n"
"for select RES_OWNER, RES_COL, RES_NAME, RES_TYPE, RES_MOD_TIME\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = _res_id do\n"
"{\n"
"_col := RES_COL;\n"
"_name := RES_NAME;\n"
"resource_owner := RES_OWNER;\n"
"cont_type := RES_TYPE;\n"
"modt := RES_MOD_TIME;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare _entry any;\n"
"\n"
"_entry := DAV_DIR_SINGLE_INT (_res_id, \'R\', path, null, null, http_dav_uid ());\n"
"_col := _res_id[1];\n"
"_name := _entry[10];\n"
"resource_owner := _entry[7];\n"
"cont_type := _entry[9];\n"
"modt := _entry[3];\n"
"}\n"
"if (resource_owner = http_dav_uid ())\n"
"is_admin_owned_res := 1;\n"
"\n"
"if (WS.WS.GET_EXT_DAV_LDP (path, lines, params, client_etag, full_path, _res_id, _col_id))\n"
"return;\n"
"\n"
"\n"
"if ((http_map_get (\'executable\') and webid_check_rc >= 0) or (exec_safety_level and is_admin_owned_res))\n"
"exec_safety_level := 2;\n"
"\n"
"\n"
"\n"
"\n"
"if (http_map_get (\'executable\'))\n"
"connection_set (\'DAVUserID\', resource_owner);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if ((exec_safety_level > 1) and full_path like \'%.vsp\')\n"
"{\n"
"declare incstat any;\n"
"declare pname varchar;\n"
"\n"
"pname := sprintf (\'%s.%s.%s\', http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"if (__proc_exists (pname) and not WS.WS.DAV_VSP_INCLUDES_CHANGED (full_path, http_map_get (\'vsp_proc_owner\')))\n"
"{\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"commit work;\n"
"declare exit handler for sqlstate \'*\', not found\n"
"{\n"
"__pop_user_id ();\n"
"if (__SQL_STATE <> 100)\n"
"{\n"
"stat := __SQL_STATE;\n"
"msg := __SQL_MESSAGE;\n"
"}\n"
"else\n"
"{\n"
"stat := \'01W01\';\n"
"msg := \'No WHENEVER statement provided for SQLCODE 100\';\n"
"}\n"
"goto exec_err;\n"
"};\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"call (pname) (path, params, lines);\n"
"__pop_user_id ();\n"
"\n"
"return;\n"
"}\n"
"select blob_to_string (RES_CONTENT), RES_FULL_PATH\n"
"into resource_content, full_path\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_NAME = _name and RES_COL = _col;\n"
"p_comm := sprintf (\n"
"\'create procedure \"%s\".\"%s\".\"%s\" (in path varchar, in params varchar, in lines varchar) { ?>\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"str := string_output ();\n"
"http (p_comm, str);\n"
"incstat := vector ();\n"
"WS.WS.EXPAND_INCLUDES (full_path, str, 0, 1, resource_content, incstat);\n"
"http (\'<?vsp }\', str);\n"
"str := string_output_string (str);\n"
"\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"exec (str, stat, msg);\n"
"commit work;\n"
"if (stat = \'00000\')\n"
"{\n"
"p_comm := sprintf (\'call \"%s\".\"%s\".\"%s\" (?, ?, ?)\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"exec (p_comm, stat, msg, vector (path, params, lines));\n"
"}\n"
"__pop_user_id ();\n"
"\n"
"if (stat <> \'00000\')\n"
"{\n"
"exec_err:\n"
"http_status_set (500);\n"
"signal (stat, msg);\n"
"}\n"
"else\n"
"{\n"
"registry_set (concat (\'__depend_\', http_map_get (\'vsp_proc_owner\'), \'_\', full_path), serialize(incstat));\n"
"}\n"
"return;\n"
"}\n"
"else if ((exec_safety_level > 1) and full_path like \'%.vspx\')\n"
"{\n"
"\n"
"DB.DBA.vspx_dispatch (full_path, path, params, lines);\n"
"}\n"
"else\n"
"{\n"
"declare _accept, _server_etag, _xslt_sheet, _document_q, _xml_t varchar;\n"
"declare _sse, _sse_cont_type, _sse_mime_encrypt, _sse_email, _sse_certificate any;\n"
"declare fext, hdl_mode varchar;\n"
"declare dot integer;\n"
"declare xml_mime_type varchar;\n"
"whenever not found goto err_end;\n"
"\n"
"\n"
"set isolation=\'repeatable\';\n"
"_sse_mime_encrypt := 0;\n"
"\n"
"\n"
"content := string_output (http_strses_memory_size ());\n"
"rc := DAV_RES_CONTENT_INT (_res_id, content, cont_type, 1, 0);\n"
"\n"
"\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"_500:;\n"
"DB.DBA.DAV_SET_HTTP_STATUS (\n"
"500,\n"
"null,\n"
"null,\n"
"sprintf (\'Server is unable to compose the text of the resource in this location: %V\', http_path ()),\n"
"1\n"
");\n"
"return;\n"
"}\n"
"\n"
"_accept := HTTP_RDF_GET_ACCEPT_BY_Q (http_request_header_full (lines, \'Accept\', \'*/*\'));\n"
"if (DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (_res_id)) and (_accept = \'text/html\') and WS.WS.TTL_REDIRECT (_col, full_path, cont_type))\n"
"return;\n"
"\n"
"_sse_cont_type := cont_type;\n"
"cont_type := case when not _sse_mime_encrypt then cont_type else \'message/rfc822\' end;\n"
"\n"
"\n"
"_name := path [length(path)-1];\n"
"\n"
"if (not _sse_mime_encrypt)\n"
"{\n"
"dot := strrchr (_name, \'.\');\n"
"if (dot is not null)\n"
"{\n"
"declare is_exist integer;\n"
"\n"
"is_exist := 0;\n"
"fext := ws_get_ftext (_name, dot);\n"
"\n"
"if (__proc_exists (fext, 2))\n"
"{\n"
"is_exist := 1;\n"
"}\n"
"else\n"
"{\n"
"fext := concat (\'WS.WS.\', fext);\n"
"if (__proc_exists (fext, 1))\n"
"is_exist := 1;\n"
"}\n"
"\n"
"if (is_exist and (exec_safety_level > 0) and ((cont_type <> \'application/sparql-query\')))\n"
"{\n"
"\n"
"declare stream_params any;\n"
"fext := cast (fext as varchar);\n"
"hdl_mode := concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', full_path);\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"stream_params := __http_stream_params ();\n"
"commit work;\n"
"http (call (fext) (string_output_string (content), stream_params, lines, hdl_mode));\n"
"if (isarray (hdl_mode) and length (hdl_mode) > 1)\n"
"{\n"
"if (hdl_mode[0] <> \'\' and isstring (hdl_mode[0]))\n"
"http_request_status (hdl_mode[0]);\n"
"\n"
"if (hdl_mode[1] <> \'\' and isstring (hdl_mode[1]))\n"
"http_header (hdl_mode[1]);\n"
"}\n"
"return;\n"
"}\n"
"}\n"
"}\n"
"_xml_t := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-template\', 0), \'\');\n"
"\n"
"if (cont_type = \'text/xml\' and\n"
"(http_map_get (\'xml_templates\') or _xml_t = \'execute\') and\n"
"(exec_safety_level > 1))\n"
"{\n"
"declare new_params, _enc any;\n"
"declare _base_url varchar;\n"
"\n"
"_base_url := concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', full_path);\n"
"xml_mime_type := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql-mime-type\', 0), \'text/xml\');\n"
"new_params := vector_concat (params, vector (\'template\', string_output_string (content), \'__base_url\', _base_url, \'contenttype\', xml_mime_type));\n"
"_enc := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql-encoding\', 0));\n"
"DB.DBA.__XML_TEMPLATE (path, new_params, lines, _enc);\n"
"return;\n"
"}\n"
"\n"
"server_etag := WS.WS.ETAG (_name, _col, modt);\n"
"if (not _sse_mime_encrypt)\n"
"{\n"
"_document_q := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql\', 0), \'\');\n"
"_xslt_sheet := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-stylesheet\', 0), \'\');\n"
"\n"
"if (_document_q <> \'\' or _xslt_sheet <> \'\')\n"
"cont_type := \'sql/xml\';\n"
"\n"
"if (cont_type <> \'\' and cont_type <> \'sql/xml\')\n"
"{\n"
"if (cont_type <> \'xml/view\' and cont_type <> \'xml/persistent-view\')\n"
"{\n"
"declare hdr_str, hdr_path, hdr_uri any;\n"
"\n"
"hdr_str := http_header_get ();\n"
"hdr_str := hdr_str || \'ETag: \"\' || server_etag || \'\"\\r\\n\';\n"
"if (strcasestr (hdr_str, \'Content-Type:\') is null)\n"
"hdr_str := hdr_str || \'Content-Type: \' || cont_type || \'\\r\\n\';\n"
"\n"
"if (modt is not null and strcasestr (hdr_str, \'Last-Modified:\') is null)\n"
"hdr_str := hdr_str || sprintf (\'Last-Modified: %s\\r\\n\', soap_print_box (modt, \'\', 1));\n"
"\n"
"hdr_path := DAV_CONCAT_PATH (\'/\', full_path);\n"
"hdr_uri := sprintf (\'%s://%s%s\', case when is_https_ctx () then \'https\' else \'http\' end, http_request_header (lines, \'Host\', NULL, NULL), hdr_path);\n"
"if (hdr_path not like \'%,meta\')\n"
"hdr_str := hdr_str || sprintf (\'Link: <%s,meta>; rel=\"meta\"; title=\"Metadata File\"\\r\\n\', hdr_uri);\n"
"\n"
"if (hdr_path not like \'%,acl\')\n"
"hdr_str := hdr_str || sprintf (\'Link: <%s,acl>; rel=\"acl\"; title=\"Access Control File\"\\r\\n\', hdr_uri);\n"
"\n"
"rdf_graph := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = _col and PROP_TYPE = \'C\' and PROP_NAME = \'virt:rdfSink-graph\');\n"
"if (rdf_graph is not null)\n"
"hdr_str := hdr_str || sprintf (\'Link: <%s>; rel=\"alternate\"\\r\\n\', rfc1808_expand_uri (DB.DBA.HTTP_REQUESTED_URL (), DAV_RDF_RES_NAME (rdf_graph)));\n"
"\n"
"http_header (hdr_str);\n"
"}\n"
"else\n"
"{\n"
"http_header (\'Content-Type: text/xml\\r\\nETag: \"\' || server_etag || \'\"\\r\\n\');\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"_server_etag := server_etag;\n"
"server_etag := concat (\'\"\', server_etag, \'\"\');\n"
"\n"
"if (client_etag <> server_etag)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (200);\n"
"xpr := get_keyword (\'XPATH\', params, \'/*\');\n"
"if (cont_type = \'xml/view\')\n"
"{\n"
"declare ondemand_data varchar;\n"
"declare view_name varchar;\n"
"declare meta_mode integer;\n"
"declare meta_data varchar;\n"
"declare delim1, delim2 integer;\n"
"declare zero integer;\n"
"\n"
"ondemand_data := string_output_string (content);\n"
"delim1 := locate(\'{view_name}\\n\',ondemand_data);\n"
"delim2 := locate(\'{meta_mode}\\n\',ondemand_data);\n"
"if(delim1 >= delim2 or delim2 = 0)\n"
"{\n"
"view_name := ondemand_data;\n"
"meta_mode := 0;\n"
"meta_data := \'\';\n"
"}\n"
"else\n"
"{\n"
"view_name := substring(ondemand_data, 1, delim1-1);\n"
"delim1 := delim1 + length(\'{view_name}\\n\');\n"
"meta_mode := cast(substring(ondemand_data, delim1, delim2-delim1) as integer);\n"
"delim2 := delim2 + length(\'{meta_mode}\\n\');\n"
"meta_data := substring(ondemand_data, delim2, length(ondemand_data)+1-delim2);\n"
"}\n"
"if (xpr = \'\')\n"
"{\n"
"http (\'Error: XPATH param is empty\');\n"
"return;\n"
"}\n"
"sxtag := get_keyword (\'set_tag\', params, view_name);\n"
"maxres := atoi (get_keyword (\'maxresults\', params, \'100\'));\n"
"rxtag := get_keyword (\'result_tag\', params, \'\');\n"
"if (rxtag <> \'\')\n"
"rxtag := concat (\'__tag  \"\', rxtag, \'\"\');\n"
"\n"
"p_comm := concat (\'XPATH [__http __view \"\', view_name, \'\" \', rxtag, \'] \', xpr);\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"zero := 0;\n"
"WS.WS.XML_VIEW_HEADER (view_name, sxtag, full_path, meta_mode, meta_data, zero);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"err := exec (p_comm, stat, msg, vector (), maxres);\n"
"http (concat (\'</\', sxtag, \'>\\n\'));\n"
"if (stat = \'00000\')\n"
"return;\n"
"\n"
"http_header (concat (\'Content-Type: text/html\\r\\n\'));\n"
"http (concat (\'SQL Error: \', stat, \' \', msg));\n"
"return;\n"
"}\n"
"else if ((cont_type = \'text/xml\' or cont_type = \'xml/persistent-view\' or (cont_type = \'sql/xml\' and length (content) > 0))  and xpr <> \'/*\')\n"
"{\n"
"declare c_xml cursor for select t from WS.WS.SYS_DAV_RES where xpath_contains (RES_CONTENT, xpr, t)\n"
"and RES_NAME = _name and RES_COL = _col;\n"
"declare ht any;\n"
"\n"
"sxtag := get_keyword (\'set_tag\', params, \'document\');\n"
"rxtag := get_keyword (\'result_tag\', params, \'\');\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\"?>\\n\', current_charset()));\n"
"http (concat (\'<\', sxtag, \'>\\n\'));\n"
"whenever not found goto end_xml;\n"
"open c_xml;\n"
"while (1)\n"
"{\n"
"fetch c_xml into ht;\n"
"if (rxtag <> \'\')\n"
"http (concat (\'<\', rxtag, \'>\\n\'));\n"
"\n"
"http_value (ht);\n"
"if (rxtag <> \'\')\n"
"http (concat (\'</\', rxtag, \'>\\n\'));\n"
"}\n"
"end_xml:\n"
"close c_xml;\n"
"http (concat (\'</\', sxtag, \'>\\n\'));\n"
"}\n"
"else if (cont_type = \'application/sparql-query\')\n"
"{\n"
"declare execPermission integer;\n"
"\n"
"execPermission := DAV_AUTHENTICATE_HTTP (_res_id, \'R\', \'__1\', 1, lines, uname, upwd, uid, gid, perms);\n"
"if (not WS.WS.SPARQL_QUERY_GET (content, full_path, path, lines, execPermission))\n"
"return;\n"
"}\n"
"else if (not isnull (content))\n"
"{\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xper\', 0)) is not null)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()));\n"
"http_value (xper_cut (xml_persistent (content)));\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"declare _http_ranges_header any;\n"
"_http_ranges_header := http_sys_parse_ranges_header (length (content));\n"
"\n"
"\n"
"if (isinteger (_http_ranges_header))\n"
"return;\n"
"\n"
"if (_http_ranges_header is not null)\n"
"{\n"
"\n"
"declare _http_if_range varchar;\n"
"\n"
"_http_if_range := WS.WS.FINDPARAM (lines, \'If-Range\');\n"
"if (length (_http_if_range) > 0 and _http_if_range <> server_etag)\n"
"_http_ranges_header := NULL;\n"
"\n"
"if (length (_http_ranges_header) > 2)\n"
"{\n"
"_http_ranges_header := NULL;\n"
"}\n"
"}\n"
"if (_http_ranges_header is not null)\n"
"{\n"
"http_header (concat (coalesce (http_header_get (), \'\'), sprintf (\n"
"\'Content-Length: %ld\\r\\nContent-Range: bytes %ld-%ld/%ld\\r\\n\',\n"
"_http_ranges_header[1] - _http_ranges_header[0] + 1,\n"
"_http_ranges_header[0],\n"
"_http_ranges_header[1],\n"
"length (content))));\n"
"http_request_status (\'HTTP/1.1 206 Partial content\');\n"
"\n"
"declare _left, _to_get, _start integer;\n"
"declare _chunk, _ses any;\n"
"_left := _http_ranges_header[1] - _http_ranges_header[0] + 1;\n"
"_start := _http_ranges_header[0];\n"
"_ses := http_flush (2);\n"
"\n"
"declare exit handler for sqlstate \'*\' { rollback work; return; };\n"
"\n"
"while (_left > 0)\n"
"{\n"
"_to_get := _left;\n"
"if (_to_get > 65536)\n"
"_to_get := 65536;\n"
"\n"
"_chunk := subseq (content, _start, _start + _to_get);\n"
"if (__tag (_chunk) = 185)\n"
"_chunk := string_output_string (_chunk);\n"
"\n"
"ses_write (_chunk, _ses);\n"
"_left := _left - _to_get;\n"
"_start := _start + _to_get;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (cont_type <> \'text/turtle\' or _accept = \'application/ld+json\')\n"
"{\n"
"if (WS.WS.GET_EXT_DAV_LDP (path, lines, params, client_etag, full_path, _res_id, _col_id))\n"
"return;\n"
"}\n"
"\n"
"http_header (http_header_get () || WS.WS.LDP_HDRS (0, LDP_ENABLED (_col), 0, 0, full_path));\n"
"if (length (content) > WS.WS.GET_DAV_CHUNKED_QUOTA ())\n"
"{\n"
"commit work;\n"
"http_flush (1);\n"
"}\n"
"\n"
"http (content);\n"
"}\n"
"}\n"
"if (cont_type = \'sql/xml\')\n"
"{\n"
"declare  _root, _doc_ses, _comments varchar;\n"
"if (length (content) = 0)\n"
"{\n"
"declare _dtd, _sch, _enc varchar;\n"
"_root := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-root\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_dtd := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-dtd\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_sch := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-schema\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_comments := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-description\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_enc := (select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-encoding\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id);\n"
"_doc_ses := null;\n"
"http_rewrite ();\n"
"WS.WS.XMLSQL_TO_STRSES (_document_q, _root, _sch, _dtd, _comments, _doc_ses, _enc);\n"
"}\n"
"xml_mime_type := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql-mime-type\', 0), \'text/xml\');\n"
"if (_xslt_sheet <> \'\')\n"
"{\n"
"http_xslt (_xslt_sheet);\n"
"}\n"
"else if (length (content) = 0)\n"
"{\n"
"http_header (http_header_get () || sprintf (\'Cache-Control: no-cache, must-revalidate\\r\\nPragma: no-cache\\r\\nExpires: %s\\r\\nContent-Type: %s\\r\\n\', soap_print_box (now (), \'\', 1), xml_mime_type));\n"
"}\n"
"else\n"
"{\n"
"http_header (http_header_get () || sprintf (\'Content-Type: %s\\r\\nETag: \"%s\"\\r\\n\', xml_mime_type, _server_etag));\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (WS.WS.GET_EXT_DAV_LDP (path, lines, params, client_etag, full_path, _res_id, _col_id))\n"
"return;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 304 Not Modified\');\n"
"}\n"
"}\n"
"err_end:\n"
"return;\n"
"}\n"
"--src dav.sql:2445\n"
;

static const char *proc35 = 
"#line 3258 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.LDP_HDRS (\n"
"in is_col integer := 0,\n"
"in add_rel integer := 0,\n"
"in page integer := 0,\n"
"in last integer := 0,\n"
"in path any := null)\n"
"{\n"
"declare link, header, msAuthor, acceptPatch, acceptPost, netID any;\n"
"\n"
"msAuthor := sprintf (\'MS-Author-Via: %s\\r\\n\', case when add_rel then \'DAV, SPARQL\' else \'DAV\' end);\n"
"acceptPatch := case when add_rel then \'Accept-Patch: application/sparql-update\\r\\n\' else \'\' end;\n"
"acceptPost := sprintf (\'Accept-Post: %s\\r\\n\', case when add_rel then \'text/turtle,text/n3,text/nt,text/html,application/ld+json\' else \'*/*\' end);\n"
"header := \'Allow: GET,HEAD,POST,PUT,DELETE,OPTIONS,PROPFIND,PROPPATCH,COPY,MOVE,MKCOL,LOCK,UNLOCK,TRACE,PATCH\\r\\n\' ||\n"
"\'Vary: Accept,Origin,If-Modified-Since,If-None-Match\\r\\n\' ||\n"
"msAuthor ||\n"
"acceptPatch ||\n"
"acceptPost;\n"
"netID := connection_get (\'NetId\');\n"
"if (netID is not null)\n"
"header := header || sprintf (\'User: <%s>\\r\\n\', netID);\n"
"\n"
"if (add_rel)\n"
"{\n"
"header := header || \'Link: <http://www.w3.org/ns/ldp#Resource>; rel=\"type\"\\r\\n\';\n"
"if (is_col)\n"
"header := header || \'Link: <http://www.w3.org/ns/ldp#BasicContainer>; rel=\"type\"\\r\\n\';\n"
"}\n"
"\n"
"if (page > 0)\n"
"header := header || \'Link: <?p=1>; rel=\"first\"\\r\\n\';\n"
"\n"
"if (last > 0)\n"
"header := header || sprintf (\'Link: <?p=%d>; rel=\"last\"\\r\\n\', last);\n"
"\n"
"if (path is not null)\n"
"{\n"
"declare hdr_str varchar;\n"
"\n"
"hdr_str := http_header_get ();\n"
"link := WS.WS.DAV_LINK (rtrim (path, \'/\'));\n"
"if ((strcasestr (hdr_str, \'rel=\"meta\"\') is null) and (link not like \'%,meta\'))\n"
"header := header || sprintf (\'Link: <%s,meta>; rel=\"meta\"; title=\"Metadata File\"\\r\\n\', link);\n"
"\n"
"if ((strcasestr (hdr_str, \'rel=\"acl\"\') is null) and (link not like \'%,acl\'))\n"
"header := header || sprintf (\'Link: <%s,acl>; rel=\"acl\"; title=\"Access Control File\"\\r\\n\', link);\n"
"}\n"
"\n"
"return header;\n"
"}\n"
"--src dav.sql:3256\n"
;

static const char *proc36 = 
"#line 3309 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.dynamic_host_name (in o any)\n"
"{\n"
"declare ret any;\n"
"if (isiri_id (o))\n"
"{\n"
"ret := id_to_iri (o);\n"
"ret := replace (ret, WS.WS.DAV_IRI (\'\'), \'local:\');\n"
"return iri_to_id (ret);\n"
"}\n"
"else if (__box_flags (o) = 1)\n"
"{\n"
"ret := replace (o, WS.WS.DAV_IRI (\'\'), \'local:\');\n"
"__box_flags_set (ret, 1);\n"
"return ret;\n"
"}\n"
"return o;\n"
"}\n"
"--src dav.sql:3307\n"
;

static const char *other0 = 
"DB.DBA.EXEC_STMT (\'grant execute on DB.DBA.dynamic_host_name to SPARQL_SELECT\', 0)\n";
static const char *proc37 = 
"#line 3332 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET_EXT_DAV_LDP (\n"
"inout path any,\n"
"inout lines any,\n"
"inout params any,\n"
"in client_etag varchar,\n"
"in full_path varchar,\n"
"in _res_id int,\n"
"in _col_id int)\n"
"{\n"
"\n"
"declare accept, accept_mime, accept_full, accept_profile, name_ varchar;\n"
"declare mod_time datetime;\n"
"declare gr, as_part varchar;\n"
"declare id_ integer;\n"
"declare pref_mime varchar;\n"
"\n"
"\n"
"if (strstr (WS.WS.FINDPARAM (lines, \'User-Agent\'), \'WebDAVFS\') is not null)\n"
"return 0;\n"
"\n"
"\n"
"if (DB.DBA.DAV_MAC_METAFILE (path))\n"
"return 0;\n"
"\n"
"if (isarray (_res_id) and not DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (_res_id)))\n"
"return 0;\n"
"\n"
"\n"
"pref_mime := (select RES_TYPE from WS.WS.SYS_DAV_RES where RES_ID = DB.DBA.DAV_DET_DAV_ID (_res_id));\n"
"\n"
"accept_full := http_request_header_full (lines, \'Accept\', \'*/*\');\n"
"accept_mime := HTTP_RDF_GET_ACCEPT_BY_Q (accept_full, pref_mime);\n"
"if ((pref_mime = \'application/ld+json\') and (accept_mime not in (\'*/*\', \'application/ld+json\')))\n"
"return 0;\n"
"\n"
"accept := accept_mime;\n"
"if (accept = \'*/*\' and isinteger (_res_id))\n"
"{\n"
"if (pref_mime = \'text/turtle\')\n"
"{\n"
"accept := \'text/turtle\';\n"
"}\n"
"else if (pref_mime = \'application/ld+json\')\n"
"{\n"
"accept := \'application/ld+json\';\n"
"}\n"
"}\n"
"\n"
"if (accept not in (\'text/turtle\', \'application/ld+json\'))\n"
"return 0;\n"
"\n"
"declare fmt, etag, qr any;\n"
"declare page, cnt, last, n_per_page, is_col int;\n"
"\n"
"n_per_page := 10000;\n"
"page := atoi (get_keyword (\'p\', params, \'1\'));\n"
"fmt := accept;\n"
"is_col := 0;\n"
"if (fmt = \'text/turtle\')\n"
"fmt := \'application/x-nice-turtle\';\n"
"\n"
"gr := WS.WS.DAV_IRI (full_path);\n"
"if (strchr (gr, \'*\') is not null)\n"
"{\n"
"declare grs any;\n"
"declare dir, pwd, auid, cid, ppath, mask any;\n"
"\n"
"grs := string_output ();\n"
"pwd := null;\n"
"auid := http_dav_uid ();\n"
"cid := DAV_SEARCH_ID (full_path, \'P\');\n"
"ppath := DAV_SEARCH_PATH (cid, \'C\');\n"
"if (length (full_path) > length (ppath))\n"
"mask := subseq (full_path, length (ppath));\n"
"\n"
"dir := DAV_DIR_LIST_INT (DAV_SEARCH_PATH (cid, \'C\'), 0, mask, \'dba\', pwd, auid);\n"
"foreach (any x in dir) do\n"
"{\n"
"http (sprintf (\'<%s>,\', WS.WS.DAV_IRI (x[0])), grs);\n"
"}\n"
"grs := string_output_string (grs);\n"
"grs := rtrim (grs, \',\');\n"
"qr := sprintf (\'define input:storage \"\" construct { `sql:dynamic_host_name(?s)` ?p `sql:dynamic_host_name(?o)` } where { graph ?g { ?s ?p ?o } filter (?g in (%s)) }\', grs);\n"
"\n"
"goto execqr;\n"
"}\n"
"\n"
"if (isvector (_res_id) or isvector (_col_id))\n"
"{\n"
"id_ := coalesce (_res_id, _col_id);\n"
"if (_col_id is null)\n"
"_col_id := DAV_SEARCH_ID (DAV_SEARCH_PATH (_res_id, \'R\'), \'P\');\n"
"\n"
"name_ := \'\';\n"
"mod_time := now ();\n"
"}\n"
"else if (_res_id is not null)\n"
"{\n"
"select RES_COL, RES_NAME, RES_MOD_TIME into id_, name_, mod_time from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"_col_id := id_;\n"
"}\n"
"else if (_col_id is not null)\n"
"{\n"
"select COL_ID, COL_NAME, COL_MOD_TIME into id_, name_, mod_time from WS.WS.SYS_DAV_COL where COL_ID = _col_id;\n"
"is_col := 1;\n"
"}\n"
"else\n"
"{\n"
"signal (\'LDP00\', \'Invalid request\');\n"
"}\n"
"\n"
"if (not DB.DBA.LDP_ENABLED (_col_id))\n"
"return 0;\n"
"\n"
"if (not (exists (sparql define input:storage \"\" select (1) where { graph `iri(?:gr)` { ?s ?p ?o }})))\n"
"{\n"
"if (isinteger (DB.DBA.DAV_DET_DAV_ID (_res_id)) and (pref_mime not in (\'text/turtle\')))\n"
"{\n"
"declare i integer;\n"
"declare tmp, V any;\n"
"\n"
"V := split_and_decode (accept_full, 0, \'\\0\\0,;\');\n"
"for (i := 0; i < length (V); i := i + 2)\n"
"{\n"
"tmp := replace (trim (V[i]), \'*\', \'%\');\n"
"if (pref_mime like tmp)\n"
"return 0;\n"
"}\n"
"}\n"
"DB.DBA.DAV_SET_HTTP_STATUS (406, \'406 Not Acceptable\', \'406 Not Acceptable\', sprintf (\'<p>An appropriate representation of the requested resource %s could not be found on this server.</p>\', full_path));\n"
"return 1;\n"
"}\n"
"etag := WS.WS.ETAG (name_, id_, mod_time);\n"
"cnt := (sparql define input:storage \"\" select count(1) where { graph `iri(?:gr)` { ?s ?p ?o }});\n"
"last := (cnt / n_per_page) + 1;\n"
"http_header (sprintf(\'Content-Type: %s\\r\\n%s\', accept, WS.WS.LDP_HDRS (is_col, 1, page, last, full_path)));\n"
"if (isstring (etag))\n"
"http_header (http_header_get () || sprintf(\'ETag: \"%s\"\\r\\n\', etag));\n"
"\n"
"accept_profile := case when (accept = \'application/ld+json\') then DB.DBA.LDP_ACCEPT_PARAM (accept_full, accept_mime, \'profile\') else null end;\n"
"as_part := \'\';\n"
"if (accept_profile = \'\"https://www.w3.org/ns/activitystreams\"\')\n"
"as_part := \'<http://www.w3.org/ns/activitystreams#items> owl:equivalentProperty <http://www.w3.org/ns/ldp#contains> . <http://www.w3.org/ns/activitystreams#Collection> owl:equivalentClass <http://www.w3.org/ns/ldp#Container> .\';\n"
"\n"
"qr := sprintf (\'define sql:select-option \"order\" define input:storage \"\" construct { %s `sql:dynamic_host_name(?s)` ?p `sql:dynamic_host_name(?o)` . `sql:dynamic_host_name(?o)` a ?t } where { ?s ?p ?o option (table_option \"index G\") . optional { graph ?g { ?o a ?t option (table_option \"index primary key\") } }  } order by ?s ?p ?o limit %d offset %d\', as_part, n_per_page, n_per_page * (page - 1));\n"
"\n"
"execqr:\n"
"DB.DBA.DAV_SET_HTTP_STATUS (200);\n"
"connection_set (\'SPARQLUserId\', \'SPARQL_ADMIN\');\n"
"WS.WS.\"/!sparql/\" (\n"
"path,\n"
"vector_concat (vector (\'default-graph-uri\', gr, \'format\', fmt, \'query\', qr), params), lines);\n"
"http_methods_set (\'OPTIONS\', \'GET\', \'HEAD\', \'POST\', \'PUT\', \'DELETE\', \'TRACE\', \'PROPFIND\', \'PROPPATCH\', \'COPY\', \'MOVE\', \'LOCK\', \'UNLOCK\', \'PATCH\');\n"
"return 1;\n"
"}\n"
"--src dav.sql:3330\n"
;

static const char *proc38 = 
"#line 3490 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.POST (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare _content_type, _content_type_attr, slug varchar;\n"
"\n"
"_content_type := WS.WS.FINDPARAM (lines, \'Content-Type\');\n"
"_content_type_attr := http_request_header (lines, \'Content-Type\', \'type\', \'\');\n"
"slug := WS.WS.FINDPARAM (lines, \'Slug\');\n"
"if (_content_type in (\'application/vnd.syncml+wbxml\', \'application/vnd.syncml+xml\'))\n"
"{\n"
"if (not __proc_exists (\'DB.DBA.SYNCML\'))\n"
"signal (\'37000\', \'The SyncML server is not available\');\n"
"\n"
"DB.DBA.SYNCML (path, params, lines);\n"
"}\n"
"else if ((_content_type = \'application/atom+xml\') and (_content_type_attr = \'entry\'))\n"
"{\n"
"WS.WS.PUT (path, params, lines);\n"
"}\n"
"else if (_content_type = \'multipart/related\')\n"
"{\n"
"WS.WS.PUT (path, params, lines);\n"
"}\n"
"else if (_content_type = \'application/sparql-query\')\n"
"{\n"
"WS.WS.PUT (path, params, lines);\n"
"}\n"
"else if ((_content_type in (\'text/turtle\', \'application/ld+json\')) or (length (slug) > 0))\n"
"{\n"
"declare cid integer;\n"
"\n"
"cid := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (http_physical_path (), \'/\'),\'C\'));\n"
"if (cid is not null)\n"
"{\n"
"declare p varchar;\n"
"if (length (slug))\n"
"{\n"
"p := slug;\n"
"}\n"
"else\n"
"{\n"
"declare meta, cont, ppath, nth any;\n"
"\n"
"ppath := rtrim (http_physical_path (), \'/\');\n"
"meta := iri_to_id (WS.WS.DAV_IRI (ppath || \',meta\'));\n"
"cont := iri_to_id (WS.WS.DAV_IRI (ppath || \'/\'));\n"
"p := (sparql select ?pref where { graph ?:meta { ?:cont <http://ns.rww.io/ldpx#ldprPrefix> ?pref . }});\n"
"if (p is null)\n"
"{\n"
"cont := iri_to_id (WS.WS.DAV_IRI (ppath));\n"
"p := (sparql select ?pref where { graph ?:meta { ?:cont <http://ns.rww.io/ldpx#ldprPrefix> ?pref . }});\n"
"}\n"
"if (p is not null)\n"
"{\n"
"declare dir, pwd, auid, sinv any;\n"
"pwd := null;\n"
"auid := http_dav_uid ();\n"
"dir := DAV_DIR_LIST_INT (DAV_SEARCH_PATH (cid, \'C\'), 0, p||\'%\', \'dba\', pwd, auid);\n"
"nth := 0;\n"
"foreach (any r in dir) do\n"
"{\n"
"if (r[10] not like \'%,meta\' and r[10] not like \'%,acl\')\n"
"{\n"
"sinv := sprintf_inverse (r[10], p||\'%d\', 0);\n"
"if (length (sinv) > 0 and sinv[0] > nth)\n"
"nth := sinv[0];\n"
"}\n"
"}\n"
"p := sprintf (\'%s%d\', p, nth + 1);\n"
"}\n"
"else\n"
"{\n"
"p := xenc_rand_bytes (8,1);\n"
"}\n"
"}\n"
"path := vector_concat (path, vector (p));\n"
"}\n"
"WS.WS.PUT (path, params, lines);\n"
"}\n"
"else\n"
"{\n"
"WS.WS.GET (path, params, lines);\n"
"}\n"
"}\n"
"--src dav.sql:3488\n"
;

static const char *proc39 = 
"#line 3579 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.SPARQL_QUERY_POST (\n"
"in path varchar,\n"
"inout ses varchar,\n"
"in uname varchar,\n"
"in dav_call integer := 0)\n"
"{\n"
"declare def_gr, full_qr, qr any;\n"
"declare stat, msg, meta, data any;\n"
"\n"
"qr := ses;\n"
"if (__tag (ses) = 222)\n"
"{\n"
"\n"
"qr := cast (ses as varchar);\n"
"}\n"
"else if (not isstring (ses))\n"
"{\n"
"qr := string_output_string (ses);\n"
"}\n"
"qr := trim (qr);\n"
"def_gr := WS.WS.DAV_IRI (path);\n"
"if (lower (qr) not like \'construct %\' and lower (qr) not like \'describe %\')\n"
"full_qr := sprintf (\'SPARQL define input:default-graph-uri <%s> \', def_gr);\n"
"else\n"
"full_qr := \'SPARQL \';\n"
"\n"
"full_qr := full_qr || qr;\n"
"stat := \'00000\';\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME = uname and U_SQL_ENABLE = 1))\n"
"set_user_id (uname);\n"
"\n"
"exec (full_qr, stat, msg, vector (), 0, meta, data);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"\n"
"if (length (data) > 0 and length (data[0]) and __tag (data[0][0]) = 214)\n"
"{\n"
"declare dict, triples any;\n"
"\n"
"dict := data[0][0];\n"
"ses := string_output ();\n"
"triples := dict_list_keys (dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"ses := string_output_string (ses);\n"
"DB.DBA.TTLP (ses, HTTP_REQUESTED_URL (), def_gr);\n"
"}\n"
"ses := sprintf (\'CONSTRUCT { ?s ?p ?o } FROM <%s> WHERE { ?s ?p ?o }\', def_gr);\n"
"}\n"
"--src dav.sql:3577\n"
;

static const char *proc40 = 
"#line 3629 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.TTL_QUERY_PREFIXES (\n"
"inout triples any,\n"
"inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, first_dflt_g_idx integer;\n"
"declare first_g_idx integer;\n"
"\n"
"tcount := length (triples);\n"
"if (0 = tcount)\n"
"{\n"
"return;\n"
"}\n"
"\n"
"env := DB.DBA.RDF_TRIPLES_TO_TTL_ENV (tcount, 0, 0, ses);\n"
"{\n"
"whenever sqlstate \'*\' goto end_pred_sort;\n"
"\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"end_pred_sort: ;\n"
"}\n"
"{\n"
"whenever sqlstate \'*\' goto end_subj_sort;\n"
"\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"end_subj_sort: ;\n"
"}\n"
"\n"
"rowvector_graph_sort (triples, 3, 1);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; (tctr < tcount) and aref_or_default (triples, tctr, 3, null) is null; tctr := tctr + 1)\n"
"{\n"
"http_ttl_prefixes (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"first_g_idx := tctr;\n"
"for (tctr := first_g_idx; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_ttl_prefixes (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"}\n"
"--src dav.sql:3627\n"
;

static const char *proc41 = 
"#line 3671 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.TTL_QUERY_POST (\n"
"in path varchar,\n"
"inout ses varchar,\n"
"in is_resource integer := 0)\n"
"{\n"
"\n"
"declare step integer;\n"
"declare ldp_resource varchar;\n"
"declare ns, def_gr, giid, dict, triples, prefixes, flags any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"_error:;\n"
"connection_set (\'__sql_state\', __SQL_STATE);\n"
"connection_set (\'__sql_message\', __SQL_MESSAGE);\n"
"return -44;\n"
"};\n"
"declare exit handler for sqlstate \'37000\'\n"
"{\n"
"step := step + 1;\n"
"if (step > 1)\n"
"goto _error;\n"
"\n"
"else if (connection_get (\'__WebDAV_ttl_prefixes__\') = \'yes\')\n"
"goto _again;\n"
"\n"
"else if (connection_get (\'__WebDAV_ttl_prefixes__\') = \'no\')\n"
"goto _error;\n"
"\n"
"else if (not WS.WS.TTL_PREFIXES_ENABLED ())\n"
"goto _error;\n"
"\n"
"goto _again;\n"
"};\n"
"\n"
"set_user_id (\'dba\');\n"
"flags := 255;\n"
"def_gr := WS.WS.DAV_IRI (path);\n"
"giid := iri_to_id (def_gr);\n"
"log_enable (3);\n"
"if (is_resource)\n"
"{\n"
"WS.WS.TTL_QUERY_POST_CLEAR (path);\n"
"ldp_resource := sprintf (\'<%s> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/ns/ldp#Resource>, <http://www.w3.org/2000/01/rdf-schema#Resource> .\', def_gr);\n"
"DB.DBA.TTLP (ldp_resource, \'\', def_gr);\n"
"}\n"
"else\n"
"{\n"
"sparql delete from graph ?:giid { ?s ?p ?o } where { graph ?:giid { ?s ?p ?o .\n"
"filter (?p not in (<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>, <http://www.w3.org/ns/ldp#contains>)) . } };\n"
"}\n"
"\n"
"\n"
"if (__tag (ses) = 222)\n"
"ses := cast (ses as varchar);\n"
"\n"
"step := 0;\n"
"ns := ses;\n"
"\n"
"goto _load;\n"
"\n"
"_again:;\n"
"ns := string_output ();\n"
"for (select NS_PREFIX, NS_URL from DB.DBA.SYS_XML_PERSISTENT_NS_DECL) do\n"
"{\n"
"http (sprintf (\'@prefix %s: <%s> . \\t\', NS_PREFIX, NS_URL), ns);\n"
"}\n"
"http (ses, ns);\n"
"if (is_resource)\n"
"http (ldp_resource, ns);\n"
"\n"
"_load:;\n"
"dict := dict_new ();\n"
"DB.DBA.RDF_TTL_LOAD_DICT (ns, def_gr, def_gr, dict, flags);\n"
"if (step = 0)\n"
"goto _exit;\n"
"\n"
"_next:;\n"
"triples := dict_list_keys (dict, 1);\n"
"ns := string_output ();\n"
"WS.WS.TTL_QUERY_PREFIXES (triples, ns);\n"
"prefixes := string_output_string(ns);\n"
"prefixes := replace (prefixes, \'\\n\', \' \');\n"
"ns := string_output ();\n"
"http (prefixes, ns);\n"
"http (\'\\n### Source document ###\\n\', ns);\n"
"http (ses, ns);\n"
"\n"
"_exit:;\n"
"DB.DBA.TTLP (ns, def_gr, def_gr, flags);\n"
"if (def_gr like \'%,meta\')\n"
"{\n"
"declare subj, nsubj, org_path any;\n"
"org_path := replace (path, \',meta\', \'\');\n"
"subj := iri_to_id (WS.WS.DAV_LINK (org_path));\n"
"nsubj := iri_to_id (WS.WS.DAV_IRI (org_path));\n"
"if (nsubj <> subj)\n"
"{\n"
"sparql insert into graph ?:giid { ?:nsubj ?p ?o } where { graph ?:giid { ?:subj ?p ?o }};\n"
"sparql delete from graph ?:giid { ?:subj ?p ?o } where { graph ?:giid { ?:subj ?p ?o }};\n"
"}\n"
"org_path := org_path || \'/\';\n"
"subj := iri_to_id (WS.WS.DAV_LINK (org_path));\n"
"nsubj := iri_to_id (WS.WS.DAV_IRI (org_path));\n"
"if (nsubj <> subj)\n"
"{\n"
"sparql insert into graph ?:giid { ?:nsubj ?p ?o } where { graph ?:giid { ?:subj ?p ?o }};\n"
"sparql delete from graph ?:giid { ?:subj ?p ?o } where { graph ?:giid { ?:subj ?p ?o }};\n"
"}\n"
"}\n"
"ses := ns;\n"
"log_enable (3);\n"
"\n"
"return 0;\n"
"}\n"
"--src dav.sql:3669\n"
;

static const char *proc42 = 
"#line 3787 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.TTL_QUERY_POST_CLEAR (\n"
"in path varchar)\n"
"{\n"
"\n"
"declare dav_graph varchar;\n"
"\n"
"set_user_id (\'dba\');\n"
"dav_graph := WS.WS.DAV_IRI (path);\n"
"sparql clear graph ?:dav_graph;\n"
"}\n"
"--src dav.sql:3785\n"
;

static const char *proc43 = 
"#line 3799 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.TTL_REDIRECT_ENABLED ()\n"
"{\n"
"return case when registry_get (\'__WebDAV_ttl__\') = \'yes\' then 1 else 0 end;\n"
"}\n"
"--src dav.sql:3797\n"
;

static const char *proc44 = 
"#line 3805 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.TTL_REDIRECT_PARAMS (\n"
"in _col_id any,\n"
"out _ttlApp varchar,\n"
"out _ttlAppOption varchar)\n"
"{\n"
"declare _tmp, _col_parent any;\n"
"whenever not found goto _exit;\n"
"\n"
"_col_id := DB.DBA.DAV_DET_DAV_ID (_col_id);\n"
"_ttlApp := null;\n"
"_ttlAppOption := null;\n"
"while (1)\n"
"{\n"
"_tmp := DB.DBA.DAV_PROP_GET_INT (_col_id, \'C\', \'virt:turtleRedirect\', 0);\n"
"if (DAV_HIDE_ERROR (_tmp) is not null)\n"
"{\n"
"if (_tmp <> \'yes\')\n"
"return 0;\n"
"\n"
"_tmp := DB.DBA.DAV_PROP_GET_INT (_col_id, \'C\', \'virt:turtleRedirectApp\', 0);\n"
"if (DAV_HIDE_ERROR (_tmp) is not null)\n"
"_ttlApp := _tmp;\n"
"\n"
"_tmp := DB.DBA.DAV_PROP_GET_INT (_col_id, \'C\', \'virt:turtleRedirectParams\', 0);\n"
"if (DAV_HIDE_ERROR (_tmp) is not null)\n"
"_ttlAppOption := _tmp;\n"
"\n"
"goto _exit;\n"
"}\n"
"select COL_PARENT into _col_parent from WS.WS.SYS_DAV_COL where COL_ID = _col_id;\n"
"_col_id := _col_parent;\n"
"}\n"
"\n"
"_exit:\n"
"if (isnull (_ttlApp))\n"
"{\n"
"_ttlApp := registry_get (\'__WebDAV_ttl_app__\');\n"
"if (isInteger (_ttlApp))\n"
"_ttlApp :=  case when (isnull (DB.DBA.VAD_CHECK_VERSION (\'fct\'))) then \'sponger\' else \'fct\' end;\n"
"}\n"
"\n"
"if (isnull (_ttlAppOption))\n"
"{\n"
"_ttlAppOption := registry_get (\'__WebDAV_ttl_app_option__\');\n"
"if (isInteger (_ttlAppOption))\n"
"{\n"
"_ttlAppOption := \'\';\n"
"if (_ttlApp = \'fct\')\n"
"{\n"
"declare ttl_sponge varchar;\n"
"\n"
"ttl_sponge := registry_get (\'__WebDAV_sponge_ttl__\');\n"
"if (isinteger (ttl_sponge))\n"
"{\n"
"ttl_sponge := \'no\';\n"
"}\n"
"else if (ttl_sponge = \'yes\')\n"
"{\n"
"ttl_sponge := \'add\';\n"
"}\n"
"if ((ttl_sponge = \'yes\') or (ttl_sponge = \'add\'))\n"
"{\n"
"_ttlAppOption := \'&sponger:get=add\';\n"
"}\n"
"else if (ttl_sponge = \'soft\')\n"
"{\n"
"_ttlAppOption := \'&sponger:get=soft\';\n"
"}\n"
"else if (ttl_sponge = \'replace\')\n"
"{\n"
"_ttlAppOption := \'&sponger:get=replace\';\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src dav.sql:3803\n"
;

static const char *proc45 = 
"#line 3885 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.TTL_REDIRECT (\n"
"in col_id any,\n"
"in path varchar,\n"
"in cont_type varchar)\n"
"{\n"
"\n"
"declare mimeTypes, location, ttl_app, ttl_app_option any;\n"
"\n"
"if (not WS.WS.TTL_REDIRECT_ENABLED ())\n"
"return 0;\n"
"\n"
"mimeTypes := registry_get (\'__WebDAV_ttl_mimes__\');\n"
"if (isInteger (mimeTypes))\n"
"{\n"
"mimeTypes := vector (\'text/turtle\');\n"
"}\n"
"else\n"
"{\n"
"mimeTypes := deserialize (mimeTypes);\n"
"}\n"
"if (not position (cont_type, mimeTypes))\n"
"return 0;\n"
"\n"
"if (not DB.DBA.TTL_REDIRECT_PARAMS (col_id, ttl_app, ttl_app_option))\n"
"return 0;\n"
"\n"
"location := null;\n"
"if ((ttl_app = \'fct\') and not isnull (DB.DBA.VAD_CHECK_VERSION (\'fct\')))\n"
"{\n"
"location := \'Location: %s/describe/?url=%U%s\\r\\n\';\n"
"}\n"
"else if ((ttl_app = \'osde\') and not isnull (DB.DBA.VAD_CHECK_VERSION (\'rdf-editor\')))\n"
"{\n"
"location := \'Location: %s/rdf-editor/index.html#/editor?uri=%U&ioType=dav%s\\r\\n\';\n"
"}\n"
"else if (ttl_app = \'sponger\')\n"
"{\n"
"location := \'Location: %s/about/html/%s\\r\\n\';\n"
"}\n"
"\n"
"if (not isnull (location))\n"
"{\n"
"http_rewrite ();\n"
"http_status_set (303);\n"
"http_header (http_header_get () || sprintf (location, WS.WS.DAV_HOST (), WS.WS.DAV_HOST () || replace (path, \' \', \'%20\'), ttl_app_option));\n"
"\n"
"return 1;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src dav.sql:3883\n"
;

static const char *proc46 = 
"#line 3938 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.SPARQL_QUERY_GET (in content any, in full_path varchar, in path any, inout lines any, inout execPermission integer := 1)\n"
"{\n"
"declare pars, def_gr any;\n"
"\n"
"def_gr := WS.WS.DAV_IRI (full_path);\n"
"if (execPermission > 0)\n"
"{\n"
"connection_set (\'SPARQLUserId\', \'SPARQL\');\n"
"pars := vector (\'query\', string_output_string (content), \'default-graph-uri\', def_gr);\n"
"WS.WS.\"/!sparql/\" (path, pars, lines);\n"
"\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"declare host varchar;\n"
"\n"
"host := WS.WS.FINDPARAM (lines, \'Host\');\n"
"http_rewrite ();\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: http://%s/sparql?qtxt=%U&default-graph-uri=%U\\r\\n\', host, string_output_string (content), def_gr));\n"
"http_flush ();\n"
"\n"
"return 0;\n"
"}\n"
"}\n"
"--src dav.sql:3936\n"
;

static const char *proc47 = 
"#line 3966 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.SPARQL_QUERY_UPDATE (in content any, in full_path varchar, in path any, inout lines any)\n"
"{\n"
"declare params, data any;\n"
"\n"
"connection_set (\'SPARQLUserId\', \'SPARQL_ADMIN\');\n"
"params := vector (\'query\', string_output_string (content), \'default-graph-uri\', WS.WS.DAV_IRI (full_path));\n"
"WS.WS.\"/!sparql/\" (path, params, lines);\n"
"data := http_get_string_output ();\n"
"if (data not like \'<sparql%\')\n"
"return 0;\n"
"\n"
"return 1;\n"
"}\n"
"--src dav.sql:3964\n"
;

static const char *proc48 = 
"#line 3981 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.TTL_PREFIXES_ENABLED ()\n"
"{\n"
"return case when registry_get (\'__WebDAV_ttl_prefixes__\') = \'yes\' then 1 else 0 end;\n"
"}\n"
"--src dav.sql:3979\n"
;

static const char *proc49 = 
"#line 3987 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.\"LOCK\" (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare id, p_id, rc any;\n"
"declare timeout, owner integer;\n"
"declare st, uname, upwd, _perms varchar;\n"
"declare owner_name varchar;\n"
"declare ltype, scope char;\n"
"declare _uid, _gid integer;\n"
"declare tmp, depth varchar;\n"
"declare hdr, location varchar;\n"
"declare ses any;\n"
"\n"
"declare if_token, locktype varchar;\n"
"\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"path := WS.WS.FIXPATH (path);\n"
"\n"
"p_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'P\'));\n"
"if (p_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"{\n"
"path := vector_concat (path, vector(\'\'));\n"
"st := \'C\';\n"
"}\n"
"else\n"
"{\n"
"st := \'R\';\n"
"id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"}\n"
"_uid := null;\n"
"_gid := null;\n"
"if (id is null)\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (p_id, \'C\', \'11_\', 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (id, st, \'11_\', 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"}\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"\n"
"set isolation = \'serializable\';\n"
"if (st = \'R\')\n"
"depth := \'0\';\n"
"else\n"
"depth := \'infinity\';\n"
"\n"
"locktype := null;\n"
"if_token := WS.WS.FINDPARAM (lines, \'If\');\n"
"if (if_token <> \'\')\n"
"{\n"
"tmp := WS.WS.IF_HEADER_PARSE (path, if_token);\n"
"if (not isnull (tmp) and length (tmp))\n"
"if_token := tmp[0][1][0][1];\n"
"}\n"
"ses := WS.WS.GET_BODY (params);\n"
"if (length (ses))\n"
"{\n"
"declare xtree any;\n"
"\n"
"tmp := string_output_string (ses);\n"
"xtree := xml_tree_doc (xml_tree (tmp, 0));\n"
"owner_name := serialize_to_UTF8_xml (xpath_eval (\'//lockinfo/owner\', xtree, 1));\n"
"scope := cast (xpath_eval (\'local-name(//lockinfo/lockscope/*)\', xtree, 1) as varchar);\n"
"scope := case when (scope = \'exclusive\') then \'X\' else \'S\' end;\n"
"}\n"
"else\n"
"{\n"
"\n"
"owner_name := \'\';\n"
"scope := \'R\';\n"
"}\n"
"\n"
"tmp := split_and_decode (WS.WS.FINDPARAM (lines, \'Timeout\'), 0, \'\\0\\0-\');\n"
"if (length(tmp) > 1 and lower(tmp[0]) = \'second\')\n"
"timeout := atoi (tmp[1]);\n"
"else\n"
"timeout := 0;\n"
"\n"
"path := DB.DBA.DAV_CONCAT_PATH (\'/\', path);\n"
"rc := DB.DBA.DAV_LOCK_INT (path, id, st, locktype, scope, null, owner_name, if_token, depth, timeout, null, null, _uid);\n"
"if (DB.DBA.DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"if (rc = -8)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (\'HTTP/1.1 424 Failed Dependency: \' || DAV_PERROR (rc));\n"
"}\n"
"return;\n"
"}\n"
"DB.DBA.DAV_SET_HTTP_STATUS (201);\n"
"http_header (concat (\n"
"\'Lock-Token: <opaquelocktoken:\', rc ,\'>\\r\\n\',\n"
"\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\',\n"
"\'Keep-Alive: timeout=15, max=100\\r\\n\')\n"
");\n"
"http (concat (\n"
"\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\',\n"
"\'<D:prop xmlns:D=\"DAV:\">\',\n"
"\'<D:lockdiscovery>\',\n"
"\'<D:activelock>\',\n"
"\'<D:locktype><D:write/></D:locktype>\',\n"
"\'<D:lockscope>\'));  if (scope = \'X\') http (\'<D:exclusive/>\'); else http (\'<D:shared/>\');\n"
"http (sprintf (\'</D:lockscope><D:depth>%s</D:depth>\', depth));\n"
"http (owner_name);\n"
"http (concat (\n"
"\'<D:timeout>Second-\',cast (timeout as varchar),\'</D:timeout>\',\n"
"\'<D:locktoken>\',\n"
"\'<D:href>\', \'opaquelocktoken:\', rc, \'</D:href>\',\n"
"\'</D:locktoken>\',\n"
"\'</D:activelock>\',\n"
"\'</D:lockdiscovery>\',\n"
"\'</D:prop>\'));\n"
"}\n"
"--src dav.sql:3985\n"
;

static const char *proc50 = 
"#line 4119 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.\"UNLOCK\" (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"\n"
"declare uname, upwd, _perms, token, name, location varchar;\n"
"declare st char;\n"
"declare rc, id integer;\n"
"declare _uid, _gid integer;\n"
"\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"{\n"
"st := \'C\';\n"
"}\n"
"else\n"
"{\n"
"st := \'R\';\n"
"id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return;\n"
"}\n"
"}\n"
"_uid := null;\n"
"_gid := null;\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (id, st, \'11_\', 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"token := WS.WS.FINDPARAM (lines, \'Lock-Token\');\n"
"if (isnull (token))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return;\n"
"}\n"
"rc := DB.DBA.DAV_UNLOCK_INT (id, st, token, null, null, _uid);\n"
"if (DB.DBA.DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"if (rc = -27)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (\'HTTP/1.1 424 Failed Dependency: \' || DB.DBA.DAV_PERROR (rc));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (204);\n"
"}\n"
"return;\n"
"}\n"
"--src dav.sql:4117\n"
;

static const char *proc51 = 
"#line 4181 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.OPLOCKTOKEN ()\n"
"{\n"
"return lower (uuid());\n"
"}\n"
"--src dav.sql:4179\n"
;

static const char *proc52 = 
"#line 4187 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PARENT_PATH (\n"
"in path any)\n"
"{\n"
"declare len integer;\n"
"\n"
"if (__tag (path) <> 193)\n"
"return null;\n"
"\n"
"len := length (path) - 1;\n"
"if (len < 1)\n"
"return null;\n"
"\n"
"return subseq (path, 0, len);\n"
"}\n"
"--src dav.sql:4185\n"
;

static const char *proc53 = 
"#line 4203 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.HREF_TO_ARRAY (\n"
"in path varchar,\n"
"in host varchar)\n"
"{\n"
"declare arr, res any;\n"
"declare inx, len integer;\n"
"\n"
"arr := split_and_decode (path, 0, \'%\\0/\');\n"
"if (isstring (host) and length (host) > 1)\n"
"inx := 3;\n"
"else\n"
"inx := 0;\n"
"\n"
"res := vector ();\n"
"len := length (arr);\n"
"while (inx < len)\n"
"{\n"
"if (length (arr[inx]) > 0)\n"
"res := vector_concat (res, vector (arr[inx]));\n"
"\n"
"inx := inx + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src dav.sql:4201\n"
;

static const char *proc54 = 
"#line 4229 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.HREF_TO_PATH_ARRAY (\n"
"in path varchar)\n"
"{\n"
"declare arr, res any;\n"
"declare inx, len integer;\n"
"\n"
"arr := split_and_decode (path, 0, \'%\\0/\');\n"
"if (length (arr) < 1)\n"
"return arr;\n"
"if (arr[0] = \'\')\n"
"inx := 1;\n"
"else if ((length (arr) > 2) and (arr[0][length (arr[0])-1] = 58) and (arr[1] = \'\') and (arr[2] <> \'\'))\n"
"inx := 3;\n"
"else\n"
"inx := 1;\n"
"res := vector (\'\');\n"
"len := length (arr);\n"
"while (inx < len)\n"
"{\n"
"if ((inx = len-1) or (length (arr[inx]) > 0))\n"
"res := vector_concat (res, vector (arr[inx]));\n"
"inx := inx + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src dav.sql:4227\n"
;

static const char *proc55 = 
"#line 4256 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.MOVE (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"WS.WS.COPY_OR_MOVE (path, params, lines, 0);\n"
"}\n"
"--src dav.sql:4254\n"
;

static const char *proc56 = 
"#line 4265 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.COPY (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar)\n"
"{\n"
"WS.WS.COPY_OR_MOVE (path, params, lines, 1);\n"
"}\n"
"--src dav.sql:4263\n"
;

static const char *proc57 = 
"#line 4274 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.COPY_OR_MOVE (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar,\n"
"in is_copy integer)\n"
"{\n"
"declare st, _dst_url, if_header varchar;\n"
"declare _host varchar;\n"
"declare _overwrite char;\n"
"declare _len integer;\n"
"declare id integer;\n"
"declare uname, upwd, _perms varchar;\n"
"declare _uid, _gid integer;\n"
"declare rc, check_locks integer;\n"
"declare target_path, overwrite_path, location varchar;\n"
"declare src_id, dst_id, dst_host, dst_parent_id, overwrite_id any;\n"
"\n"
"set isolation = \'serializable\';\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"if (not DB.DBA.DAV_PATH_CHECK (path))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"return;\n"
"}\n"
"src_id := DB.DBA.DAV_HIDE_ERROR (DAV_SEARCH_SOME_ID (vector_concat (vector(\'\'), path), st));\n"
"if (src_id is null)\n"
"{\n"
"src_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_SOME_ID (vector_concat (vector(\'\'), path, vector(\'\')), st));\n"
"if (src_id is not null)\n"
"{\n"
"path := vector_concat (path, vector(\'\'));\n"
"}\n"
"}\n"
"if (src_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return;\n"
"}\n"
"\n"
"uname := null;\n"
"upwd := null;\n"
"_uid := null;\n"
"_gid := null;\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (src_id, st, case (is_copy) when 1 then \'1__\' else \'11_\' end, 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"if (not is_copy)\n"
"{\n"
"rc := WS.WS.ISLOCKED (vector_concat (vector (\'\'), path), WS.WS.FINDPARAM (lines, \'If\'));\n"
"if (isnull (rc))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (412);\n"
"return;\n"
"}\n"
"if (rc)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"return;\n"
"}\n"
"}\n"
"\n"
"_dst_url := WS.WS.FIXPATH (WS.WS.FINDPARAM (lines, \'Destination\'));\n"
"_host := WS.WS.FINDPARAM (lines, \'Host\');\n"
"dst_host := rfc1808_parse_uri (_dst_url)[1];\n"
"dst_host := split_and_decode (dst_host, 0, \'%\');\n"
"\n"
"\n"
"if (_host <> \'\'\n"
"and dst_host <> \'\'\n"
"and _dst_url <> \'\'\n"
"and (lower (substring (_dst_url, 1, 7)) = \'http://\' or lower (substring (_dst_url, 1, 8)) = \'https://\')\n"
"and lower (dst_host) <> lower (_host))\n"
"{\n"
"if (is_copy)\n"
"{\n"
"\n"
"log_message (sprintf (\'Copy a WebDAV resource from %s to %s\', _host, _dst_url));\n"
"WS.WS.COPY_TO_OTHER (path, params, lines, _dst_url);\n"
"}\n"
"else\n"
"{\n"
"\n"
"log_message (sprintf (\'Moving a WebDAV resource from %s to %s\', _host, _dst_url));\n"
"if (1 = WS.WS.COPY_TO_OTHER (path, params, lines, _dst_url))\n"
"{\n"
"rc := DAV_DELETE_INT (DAV_CONCAT_PATH (\'/\', path), 0, uname, upwd, 0);\n"
"if (rc <> 1)\n"
"{\n"
"rollback work;\n"
"return rc;\n"
"}\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"\n"
"_overwrite := WS.WS.FINDPARAM (lines, \'Overwrite\');\n"
"target_path := WS.WS.HREF_TO_PATH_ARRAY (_dst_url);\n"
"if_header := WS.WS.FINDPARAM (lines, \'If\');\n"
"rc := WS.WS.ISLOCKED (target_path, if_header);\n"
"if (isnull (rc))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (412);\n"
"return;\n"
"}\n"
"if (rc)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (423);\n"
"return;\n"
"}\n"
"check_locks := 1;\n"
"if (if_header <> \'\')\n"
"check_locks := 0;\n"
"\n"
"\n"
"if (\'C\' = st)\n"
"{\n"
"if (target_path[length (target_path) - 1] = \'\')\n"
"{\n"
"dst_parent_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (target_path, \'P\'));\n"
"}\n"
"else\n"
"{\n"
"if (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (target_path, \'R\')) is not null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"target_path := vector_concat (target_path, vector (\'\'));\n"
"dst_parent_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (target_path, \'P\'));\n"
"}\n"
"overwrite_path := target_path;\n"
"}\n"
"else\n"
"{\n"
"overwrite_path := target_path;\n"
"if (target_path[length (target_path) - 1] = \'\')\n"
"{\n"
"overwrite_path[length (overwrite_path) - 1] := path[length (path) - 1];\n"
"}\n"
"dst_parent_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (target_path, \'P\'));\n"
"}\n"
"if (not DB.DBA.DAV_PATH_CHECK (overwrite_path) or DB.DBA.DAV_PATH_COMPARE (DB.DBA.DAV_CONCAT_PATH (\'/\', path), overwrite_path))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"return;\n"
"}\n"
"if (dst_parent_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"return;\n"
"}\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (dst_parent_id, \'C\', \'11_\', 1, lines, uname, upwd, _uid, _gid, _perms);\n"
"\n"
"if (rc < 0)\n"
"{\n"
"DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (rc);\n"
"return;\n"
"}\n"
"\n"
"overwrite_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (overwrite_path, st));\n"
"if (is_copy)\n"
"{\n"
"rc := DB.DBA.DAV_COPY_INT (DB.DBA.DAV_CONCAT_PATH (\'/\', path), DB.DBA.DAV_CONCAT_PATH (\'/\', target_path), case (_overwrite) when \'T\' then 1 else 0 end, _perms, uname, null, uname, upwd, 0, check_locks=>check_locks);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.DAV_MOVE_INT (DB.DBA.DAV_CONCAT_PATH (\'/\', path), DB.DBA.DAV_CONCAT_PATH (\'/\', target_path), case (_overwrite) when \'T\' then 1 else 0 end, uname, upwd, 0, check_locks=>check_locks);\n"
"}\n"
"if (DB.DBA.DAV_HIDE_ERROR (rc) is not null)\n"
"{\n"
"if (overwrite_id is null)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (201);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (204);\n"
"}\n"
"}\n"
"else if (rc = 0)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (\'HTTP/1.1 207 Multi-Status\');\n"
"}\n"
"else if (rc = -2)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (409);\n"
"}\n"
"else if (rc = -3)\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (412);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_REQUEST_STATUS (rc);\n"
"if ((rc < 0) and bit_and (sys_stat (\'public_debug\'), 2))\n"
"http_value (callstack_dump (), \'pre\');\n"
"}\n"
"return;\n"
"}\n"
"--src dav.sql:4272\n"
;

static const char *proc58 = 
"#line 4480 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.IF_HEADER_PARSE (\n"
"in path varchar,\n"
"in if_header varchar)\n"
"{\n"
"declare N, in_not, in_list integer;\n"
"declare vLockSchema varchar;\n"
"declare items, item, tags, V any;\n"
"\n"
"vLockSchema := \'opaquelocktoken:\';\n"
"items := vector ();\n"
"\n"
"\n"
"item := vector (path, vector ());\n"
"tags := split_and_decode (trim (if_header), 0, \'\\0\\0 \');\n"
"if (length (tags) = 0)\n"
"return items;\n"
"\n"
"in_list := 0;\n"
"foreach (any tag in tags) do\n"
"{\n"
"if ((in_list = 0) and (tag[0] = ascii (\'<\')))\n"
"{\n"
"\n"
"if (tag[length(tag)-1] <> ascii (\'>\'))\n"
"return null;\n"
"\n"
"if (length (item[1]))\n"
"items := vector_concat (items, vector (item));\n"
"\n"
"tag := rtrim (ltrim (tag, \'<\'), \'>\');\n"
"item := vector (tag, vector ());\n"
"tag := \'\';\n"
"}\n"
"\n"
"if (length (tag) and (tag[0] = ascii (\'(\')))\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"V := vector (0, null, 0, 0, null);\n"
"in_not := 0;\n"
"in_list := 1;\n"
"tag := subseq (tag, 1);\n"
"}\n"
"\n"
"if (length (tag) and (in_list = 1) and (tag = \'Not\'))\n"
"{\n"
"in_not := 1;\n"
"tag := \'\';\n"
"}\n"
"\n"
"if (length (tag) and (in_list = 1) and (tag[0] = ascii (\'<\')))\n"
"{\n"
"N := strrchr (tag, \'>\');\n"
"\n"
"if (isnull (N))\n"
"return null;\n"
"\n"
"V[0] := in_not;\n"
"V[1] := subseq (tag, 1, N);\n"
"if (left (V[1], length (vLockSchema)) = vLockSchema)\n"
"V[1] := subseq (V[1], length (vLockSchema));\n"
"\n"
"in_not := 0;\n"
"tag := subseq (tag, N);\n"
"}\n"
"\n"
"if (length (tag) and (in_list = 1) and (tag[0] = ascii (\'[\')))\n"
"{\n"
"N := strrchr (tag, \']\');\n"
"\n"
"if (isnull (N))\n"
"return null;\n"
"\n"
"V[2] := in_not;\n"
"V[4] := subseq (tag, 1, N);\n"
"if (left (v[4], 2) = \'W/\')\n"
"{\n"
"V[3] := 1;\n"
"V[4] := subseq (V[4], 2);\n"
"}\n"
"V[4] := trim (V[4], \'\"\');\n"
"in_not := 0;\n"
"tag := subseq (tag, N);\n"
"}\n"
"\n"
"if (length (tag) and (tag[length(tag)-1] = ascii (\')\')))\n"
"{\n"
"item[1] := vector_concat (item[1], vector (V));\n"
"in_not := 0;\n"
"in_list := 0;\n"
"}\n"
"}\n"
"\n"
"if (length (item[1]))\n"
"items := vector_concat (items, vector (item));\n"
"\n"
"return items;\n"
"}\n"
"--src dav.sql:4478\n"
;

static const char *proc59 = 
"#line 4584 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ISLOCKED (\n"
"in path any,\n"
"in if_header varchar)\n"
"{\n"
"declare rc integer;\n"
"declare if_path, if_etag varchar;\n"
"declare if_st char;\n"
"declare if_id, if_items any;\n"
"\n"
"if (if_header = \'\')\n"
"goto _no_if;\n"
"\n"
"if_items := WS.WS.IF_HEADER_PARSE (path, if_header);\n"
"if (not length (if_items))\n"
"goto _no_if;\n"
"\n"
"foreach (any if_item in if_items) do\n"
"{\n"
"if_path := DB.DBA.DAV_CONCAT_PATH (if_item[0], null);\n"
"if_st := case when (if_path[length(if_path)-1] = ascii(\'/\')) then \'C\' else \'R\' end;\n"
"if_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (if_path, if_st));\n"
"if (isnull (if_id))\n"
"return 0;\n"
"\n"
"if_etag := null;\n"
"foreach (any if_condition in if_item[1]) do\n"
"{\n"
"rc := 0;\n"
"if (not isnull (if_condition[4]) and isnull (if_etag))\n"
"if_etag := WS.WS.ETAG_BY_ID (if_id, if_st);\n"
"\n"
"\n"
"\n"
"if (not isnull (if_condition[1]))\n"
"{\n"
"if (left (if_condition[1], 4) = \'DAV:\')\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"else if (length (if_condition[1]) <> 36)\n"
"{\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"\n"
"rc := DB.DBA.DAV_IS_LOCKED_INT (if_id, if_st, if_condition[1], 1);\n"
"rc := case when (rc <= 0) then 0 else 1 end;\n"
"}\n"
"\n"
"\n"
"if (if_condition[0])\n"
"rc := mod (rc + 1, 2);\n"
"\n"
"\n"
"if (not rc)\n"
"goto _continue;\n"
"}\n"
"\n"
"\n"
"\n"
"if (not isnull (if_condition[4]))\n"
"{\n"
"rc := equ (if_etag, if_condition[4]);\n"
"if (if_condition[2])\n"
"rc := mod (rc + 1, 2);\n"
"\n"
"\n"
"if (not rc)\n"
"goto _continue;\n"
"}\n"
"\n"
"\n"
"return 0;\n"
"\n"
"_continue:;\n"
"}\n"
"}\n"
"return 1;\n"
"\n"
"_no_if:;\n"
"if_path := DB.DBA.DAV_CONCAT_PATH (path, null);\n"
"if_st := case when (if_path[length(if_path)-1] = ascii(\'/\')) then \'C\' else \'R\' end;\n"
"if_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (if_path, if_st));\n"
"if (isnull (if_id))\n"
"{\n"
"if_st := \'C\';\n"
"if_id := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (if_path, \'P\'));\n"
"}\n"
"if (isnull (if_id))\n"
"return 0;\n"
"\n"
"rc := DB.DBA.DAV_IS_LOCKED_INT (if_id, if_st);\n"
"rc := case when (rc <= 0) then 0 else 1 end;\n"
"\n"
"return rc;\n"
"}\n"
"--src dav.sql:4582\n"
;

static const char *proc60 = 
"#line 4684 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET_BODY (\n"
"in params any)\n"
"{\n"
"declare rc any;\n"
"\n"
"rc := aref_set_0 (params, 1);\n"
"if (isinteger (rc) or length (rc) = 0)\n"
"rc := http_body_read ();\n"
"\n"
"return rc;\n"
"}\n"
"--src dav.sql:4682\n"
;

static const char *proc61 = 
"#line 4697 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.CHECK_AUTH (in lines any)\n"
"{\n"
"declare _u_group integer;\n"
"declare _perms varchar;\n"
"\n"
"return WS.WS.GET_AUTH (lines, _u_group, _perms);\n"
"}\n"
"--src dav.sql:4695\n"
;

static const char *proc62 = 
"#line 4706 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET_IF_AUTH (in lines any, out _u_group integer, out _perms varchar)\n"
"{\n"
"declare _u_id integer;\n"
"if (\'\' <> WS.WS.FINDPARAM (lines, \'Authorization\') and db.dba.vsp_auth_vec (lines) <> 0)\n"
"{\n"
"_u_id := WS.WS.GET_AUTH (lines, _u_group, _perms);\n"
"}\n"
"else\n"
"{\n"
"_u_id := http_nobody_uid ();\n"
"_u_group := http_nogroup_gid ();\n"
"_perms := \'110110110-\' || \'-\';\n"
"connection_set (\'DAVUserID\', _u_id);\n"
"connection_set (\'DAVBillingUserID\', _u_id);\n"
"connection_set (\'DAVGroupID\', _u_group);\n"
"}\n"
"return _u_id;\n"
"}\n"
"--src dav.sql:4704\n"
;

static const char *proc63 = 
"#line 4726 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.GET_DAV_AUTH (in lines any, in allow_anon integer, in can_write_http integer,\n"
"out _u_name varchar, out _u_password varchar, out _uid integer, out _gid integer, out _perms varchar) returns integer\n"
"{\n"
"declare auth any;\n"
"declare _user varchar;\n"
"declare our_auth_vec varchar;\n"
"declare _method, rc integer;\n"
"\n"
"_u_name := null;\n"
"_u_password := null;\n"
"_uid := null;\n"
"_gid := null;\n"
"_perms := null;\n"
"\n"
"auth := db.dba.vsp_auth_vec (lines);\n"
"\n"
"if (0 = auth)\n"
"{\n"
"goto request_auth;\n"
"}\n"
"\n"
"_user := get_keyword (\'username\', auth);\n"
"\n"
"if (_user = \'\' or isnull (_user))\n"
"{\n"
"_user := null;\n"
"goto request_auth;\n"
"}\n"
"\n"
"allow_anon := 0;\n"
"whenever not found goto request_auth;\n"
"\n"
"set isolation=\'committed\';\n"
"select U_NAME, U_PWD, U_GROUP, U_ID, U_METHODS, U_DEF_PERMS\n"
"into _u_name, _u_password, _gid, _uid, _method, _perms from WS.WS.SYS_DAV_USER\n"
"where U_NAME = _user and U_ACCOUNT_DISABLED = 0 and U_PWD is not null with (prefetch 1);\n"
"\n"
"\n"
"\n"
"rc := -1;\n"
"\n"
"if (sys_stat (\'dbev_enable\') and __proc_exists (\'DB.DBA.DBEV_DAV_LOGIN\'))\n"
"{\n"
"rc := DB.DBA.DBEV_DAV_LOGIN (_user, _u_password, auth);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.LDAP_LOGIN (_user, _u_password, auth);\n"
"}\n"
"\n"
"if (rc = 0)\n"
"goto request_auth;\n"
"if (rc = 1)\n"
"goto authenticated;\n"
"\n"
"\n"
"if (_u_password is null)\n"
"goto request_auth;\n"
"\n"
"if (not db.dba.vsp_auth_verify_pass (auth, _u_name,\n"
"coalesce(get_keyword (\'realm\', auth), \'\'),\n"
"coalesce(get_keyword (\'uri\', auth), \'\'),\n"
"coalesce(get_keyword (\'nonce\', auth), \'\'),\n"
"coalesce(get_keyword (\'nc\', auth),\'\'),\n"
"coalesce(get_keyword (\'cnonce\', auth), \'\'),\n"
"coalesce(get_keyword (\'qop\', auth), \'\'),\n"
"_u_password))\n"
"goto request_auth;\n"
"\n"
"authenticated:\n"
"{\n"
"\n"
"update WS.WS.SYS_DAV_USER set U_LOGIN_TIME = now () where U_NAME = _user\n"
"and U_LOGIN_TIME < dateadd (\'minute\', -2, now ());\n"
"connection_set (\'DAVUserID\', _uid);\n"
"connection_set (\'DAVBillingUserID\', _uid);\n"
"connection_set (\'DAVGroupID\', _gid);\n"
"\n"
"commit work;\n"
"set isolation=\'repeatable\';\n"
"return _uid;\n"
"}\n"
"\n"
"request_auth:\n"
"_u_name := null;\n"
"_u_password := null;\n"
"_uid := null;\n"
"_gid := null;\n"
"_perms := null;\n"
"if (allow_anon)\n"
"{\n"
"_uid := http_nobody_uid ();\n"
"_gid := http_nogroup_gid ();\n"
"connection_set (\'DAVUserID\', _uid);\n"
"connection_set (\'DAVBillingUserID\', _uid);\n"
"connection_set (\'DAVGroupID\', _gid);\n"
"_perms := \'110110110RR\';\n"
"return 0;\n"
"}\n"
"if (not can_write_http)\n"
"return -12;\n"
"\n"
"db.dba.vsp_auth_get (\'DAV\', \'/DAV\', md5 (datestring(now())), md5 (\'opaakki\'), \'false\', lines, 1);\n"
"return -24;\n"
"}\n"
"--src dav.sql:4724\n"
;

static const char *proc64 = 
"#line 4833 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.PERM_COMP (in perm varchar, in mask varchar)\n"
"{\n"
"declare inx, _1 integer;\n"
"\n"
"if (length (perm) <> 3 or length (mask) <> 3)\n"
"return 0;\n"
"\n"
"_1 := ascii (\'1\');\n"
"for (inx := 0; inx < 3; inx := inx + 1)\n"
"{\n"
"if (mask[inx] = _1 and perm[inx] <> _1)\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav.sql:4831\n"
;

static const char *proc65 = 
"#line 4851 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.CHECKPERM (\n"
"in path varchar,\n"
"in uid integer,\n"
"in action varchar)\n"
"{\n"
"declare gid, _user, _group integer;\n"
"declare _perms varchar;\n"
"declare id integer;\n"
"declare rc integer;\n"
"\n"
"rc := 0;\n"
"_perms := \'000000000\';\n"
"if (uid > 0 and uid is not null)\n"
"{\n"
"gid := connection_get (\'DAVGroupID\');\n"
"}\n"
"\n"
"\n"
"if (uid = http_dav_uid () and action not like \'__1\')\n"
"{\n"
"connection_set (\'DAVQuota\', -1);\n"
"return 1;\n"
"}\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (path, \'C\');\n"
"if ( DB.DBA.DAV_HIDE_ERROR (id) is not null)\n"
"{\n"
"select COL_OWNER, COL_GROUP, COL_PERMS into _user, _group, _perms from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"}\n"
"else\n"
"{\n"
"id := DB.DBA.DAV_SEARCH_ID (path, \'R\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is not null)\n"
"{\n"
"select RES_OWNER, RES_GROUP, RES_PERMS into _user, _group, _perms from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"}\n"
"else if (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (WS.WS.PARENT_PATH (path), \'C\')) is not null)\n"
"{\n"
"if (is_http_ctx())\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"\n"
"return 0;\n"
"}\n"
"}\n"
"\n"
"if (_perms is null)\n"
"return 0;\n"
"\n"
"_perms := cast (_perms as varchar);\n"
"if (uid = _user)\n"
"{\n"
"rc := WS.WS.PERM_COMP (substring (_perms, 1, 3), action);\n"
"}\n"
"if (_group = gid and rc = 0)\n"
"{\n"
"rc := WS.WS.PERM_COMP (substring (_perms, 4, 3), action);\n"
"}\n"
"if (rc = 0)\n"
"{\n"
"rc := WS.WS.PERM_COMP (substring (_perms, 7, 3), action);\n"
"}\n"
"\n"
"if (rc = 0)\n"
"{\n"
"rc := WS.WS.PERM_COMP (substring (_perms, 4, 3), action);\n"
"if (rc > 0 and not exists (select 1 from WS.WS.SYS_DAV_USER_GROUP where UG_UID = uid and UG_GID = _group))\n"
"rc := 0;\n"
"}\n"
"if (rc = 0 and is_http_ctx ())\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"}\n"
"\n"
"return rc;\n"
"}\n"
"--src dav.sql:4849\n"
;

static const char *proc66 = 
"#line 4928 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ISPUBLIC (\n"
"in path varchar,\n"
"in ask varchar)\n"
"{\n"
"declare perms varchar;\n"
"declare id integer;\n"
"\n"
"id := DB.DBA.SEARCH_ID (path, \'C\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is not null)\n"
"{\n"
"perms := (select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = id);\n"
"}\n"
"else\n"
"{\n"
"id := DB.DBA.SEARCH_ID (path, \'R\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"return 0;\n"
"\n"
"perms := (select RES_PERMS from WS.WS.SYS_DAV_RES where RES_ID = id);\n"
"}\n"
"if (perms is null)\n"
"return 0;\n"
"\n"
"return WS.WS.PERM_COMP (substring (cast (perms as varchar), 7, 3), ask);\n"
"}\n"
"--src dav.sql:4926\n"
;

static const char *proc67 = 
"#line 4955 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.DAV_VSP_DEF_REMOVE (\n"
"in path varchar)\n"
"{\n"
"declare stat, msg varchar;\n"
"\n"
"if (path not like \'%.vsp\')\n"
"return;\n"
"\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"for (select P_NAME from DB.DBA.SYS_PROCEDURES where P_NAME like concat (\'%.%.\', path)) do\n"
"exec (sprintf (\'drop procedure \"%s\"\', P_NAME), stat, msg);\n"
"}\n"
"--src dav.sql:4953\n"
;

static const char *proc68 = 
"#line 4970 \"[executable]/dav.sql\"\n"
"create function DAV_PERMS_SET_CHAR (in perms varchar, in ch any, in pos integer) returns varchar\n"
"{\n"
"declare l integer;\n"
"l := length (perms);\n"
"if (l < 11)\n"
"perms := perms || subseq (\'000000000--\', l);\n"
"if (isinteger (ch))\n"
"perms [pos] := ch;\n"
"else\n"
"perms[pos] := ch[0];\n"
"return perms;\n"
"}\n"
"--src dav.sql:4968\n"
;

static const char *proc69 = 
"#line 4984 \"[executable]/dav.sql\"\n"
"create procedure DAV_PERMS_FIX (inout perms varchar, in full_perms varchar)\n"
"{\n"
"declare l integer;\n"
"l := length (perms);\n"
"if (l < 11)\n"
"perms := perms || subseq (full_perms, l);\n"
"if (ascii(\'-\') = perms [9])\n"
"perms[9] := full_perms[9];\n"
"if (ascii(\'-\') = perms [10])\n"
"perms[10] := full_perms[10];\n"
"}\n"
"--src dav.sql:4982\n"
;

static const char *proc70 = 
"#line 4997 \"[executable]/dav.sql\"\n"
"create procedure DAV_PERMS_INHERIT (inout perms varchar, in parent_perms varchar, in force_parent integer := 0)\n"
"{\n"
"declare l integer;\n"
"l := length (perms);\n"
"if (l < 11)\n"
"perms := perms || subseq (parent_perms, l);\n"
"if ((ascii(\'-\') = perms [9]) or (force_parent and (ascii(\'T\') <> parent_perms [9])))\n"
"perms[9] := parent_perms[9];\n"
"if ((ascii(\'-\') = perms [10]) or (force_parent and (ascii(\'M\') <> parent_perms [10])))\n"
"perms[10] := parent_perms[10];\n"
"}\n"
"--src dav.sql:4995\n"
;

static const char *trig0 = 
"#line 5011 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_RES_FULL_PATH_I after insert on WS.WS.SYS_DAV_RES order 0 referencing new as N\n"
"{\n"
"\n"
"declare full_path, name, _pflags, _rflags, _inh varchar;\n"
"declare parent_col, col, res integer;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"col := N.RES_COL;\n"
"res := N.RES_ID;\n"
"_rflags := N.RES_PERMS;\n"
"full_path := concat (\'/\', N.RES_NAME);\n"
"select COL_PERMS, COL_INHERIT into _pflags, _inh from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"if (_inh = \'R\' or _inh = \'M\')\n"
"_rflags := _pflags;\n"
"\n"
"DAV_PERMS_FIX (_pflags, \'000000000TM\');\n"
"DAV_PERMS_INHERIT (_rflags, _pflags);\n"
"whenever not found goto not_found;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into name, parent_col from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"col := parent_col;\n"
"full_path := concat (\'/\', name, full_path);\n"
"}\n"
"\n"
"not_found:\n"
"DAV_SPACE_QUOTA_RES_INSERT (full_path, DAV_RES_LENGTH (N.RES_CONTENT, N.RES_SIZE));\n"
"set triggers off;\n"
"if (_rflags <> N.RES_PERMS)\n"
"{\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = full_path, RES_PERMS = _rflags where RES_ID = res;\n"
"N.RES_PERMS := _rflags;\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = full_path where RES_ID = res;\n"
"}\n"
"N.RES_FULL_PATH := full_path;\n"
"\n"
"\n"
"\n"
"declare pub varchar;\n"
"declare uname, gname varchar;\n"
"\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (full_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.RES_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.RES_GROUP;\n"
"nfg:;\n"
"repl_text (pub, \'\"DB.DBA.DAV_RES_I\" (?, ?, ?, ?, ?, ?, ?)\', full_path, N.RES_CR_TIME,\n"
"uname, gname, N.RES_PERMS, N.RES_TYPE, WS.WS.BODY_ARR (N.RES_CONTENT, null));\n"
"}\n"
"\n"
"\n"
"if (N.RES_TYPE = \'text/xsl\')\n"
"xslt_stale (concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', N.RES_FULL_PATH));\n"
"\n"
"\n"
"update WS.WS.SYS_DAV_COL set COL_MOD_TIME = now () where COL_ID = N.RES_COL;\n"
"}\n"
"--src dav.sql:5009\n";

static const char *trig1 = 
"#line 5085 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_RES_FULL_PATH_BU before update on WS.WS.SYS_DAV_RES referencing old as O, new as N\n"
"{\n"
"\n"
"declare _pflags, _rflags, _inh varchar;\n"
"declare col integer;\n"
"\n"
"_rflags := N.RES_PERMS;\n"
"if ((O.RES_COL <> N.RES_COL) or (O.RES_PERMS <> N.RES_PERMS))\n"
"{\n"
"col := N.RES_COL;\n"
"select COL_PERMS, COL_INHERIT into _pflags, _inh from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"if (_inh = \'M\' or _inh = \'R\')\n"
"_rflags := _pflags;\n"
"\n"
"DAV_PERMS_FIX (_pflags, \'000000000TM\');\n"
"DAV_PERMS_INHERIT (_rflags, _pflags, neq (O.RES_COL, N.RES_COL));\n"
"}\n"
"if (_rflags <> N.RES_PERMS)\n"
"{\n"
"set triggers off;\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = _rflags where RES_ID = N.RES_ID;\n"
"N.RES_PERMS := _rflags;\n"
"}\n"
"\n"
"}\n"
"--src dav.sql:5083\n";

static const char *trig2 = 
"#line 5113 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_RES_FULL_PATH_U after update on WS.WS.SYS_DAV_RES referencing old as O, new as N\n"
"{\n"
"\n"
"declare full_path, name varchar;\n"
"declare parent_col, col, res integer;\n"
"declare str, cont varchar;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"col := N.RES_COL;\n"
"res := N.RES_ID;\n"
"full_path := concat (\'/\', N.RES_NAME);\n"
"whenever not found goto not_found;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into name, parent_col from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"col := parent_col;\n"
"full_path := concat (\'/\', name, full_path);\n"
"}\n"
"\n"
"not_found:\n"
"set triggers off;\n"
"DAV_SPACE_QUOTA_RES_UPDATE (O.RES_FULL_PATH, DAV_RES_LENGTH (O.RES_CONTENT, O.RES_SIZE), full_path, length (N.RES_CONTENT));\n"
"\n"
"\n"
"if (O.RES_FULL_PATH <> full_path)\n"
"{\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\' where VU_RES_ID = O.RES_ID;\n"
"}\n"
"\n"
"WS.WS.DAV_VSP_DEF_REMOVE (O.RES_FULL_PATH);\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = full_path where RES_ID = res;\n"
"N.RES_FULL_PATH := full_path;\n"
"\n"
"\n"
"\n"
"\n"
"declare pub, pub1 varchar;\n"
"declare uname, gname varchar;\n"
"uname := \'\';\n"
"gname := \'\';\n"
"pub := WS.WS.ISPUBL (O.RES_FULL_PATH);\n"
"pub1 := WS.WS.ISPUBL (full_path);\n"
"if (isstring (pub))\n"
"{\n"
"repl_text (pub, \'\"DB.DBA.DAV_RES_D\" (?)\', O.RES_FULL_PATH);\n"
"}\n"
"\n"
"if (isstring (pub1))\n"
"{\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.RES_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.RES_GROUP;\n"
"nfg:;\n"
"repl_text (pub1, \'\"DB.DBA.DAV_RES_I\" (?, ?, ?, ?, ?, ?, ?)\', full_path, N.RES_MOD_TIME,\n"
"uname, gname, N.RES_PERMS, N.RES_TYPE, WS.WS.BODY_ARR (N.RES_CONTENT, null));\n"
"}\n"
"\n"
"\n"
"if (N.RES_TYPE = \'text/xsl\')\n"
"xslt_stale (concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', N.RES_FULL_PATH));\n"
"\n"
"\n"
"if (\n"
"(O.RES_COL <> N.RES_COL) or\n"
"(O.RES_NAME <> N.RES_NAME) or\n"
"(DAV_RES_LENGTH (O.RES_CONTENT, O.RES_SIZE) <> DAV_RES_LENGTH (N.RES_CONTENT, N.RES_SIZE)) or\n"
"(O.RES_CONTENT <> N.RES_CONTENT)\n"
")\n"
"{\n"
"set triggers off;\n"
"if (O.RES_COL <> N.RES_COL)\n"
"update WS.WS.SYS_DAV_COL set COL_MOD_TIME = now () where COL_ID = O.RES_COL;\n"
"\n"
"update WS.WS.SYS_DAV_COL set COL_MOD_TIME = now () where COL_ID = N.RES_COL;\n"
"}\n"
"}\n"
"--src dav.sql:5111\n";

static const char *trig3 = 
"#line 5201 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_RES_FULL_PATH_D after delete on WS.WS.SYS_DAV_RES\n"
"{\n"
"\n"
"\n"
"set triggers off;\n"
"DAV_SPACE_QUOTA_RES_DELETE (RES_FULL_PATH, DAV_RES_LENGTH (RES_CONTENT, RES_SIZE));\n"
"\n"
"WS.WS.DAV_VSP_DEF_REMOVE (RES_FULL_PATH);\n"
"if (RES_TYPE = \'xml/persistent-view\')\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = RES_FULL_PATH;\n"
"\n"
"\n"
"declare pub varchar;\n"
"pub := WS.WS.ISPUBL (RES_FULL_PATH);\n"
"if (isstring (pub))\n"
"{\n"
"repl_text (pub, \'\"DB.DBA.DAV_RES_D\" (?)\', RES_FULL_PATH);\n"
"}\n"
"\n"
"\n"
"\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\' where VU_RES_ID = RES_ID;\n"
"if (RES_TYPE = \'text/xsl\')\n"
"xslt_stale (concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', RES_FULL_PATH));\n"
"\n"
"\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_TYPE = \'R\' and PROP_PARENT_ID = RES_ID;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = RES_ID;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = RES_ID;\n"
"\n"
"\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_MOD_TIME = now () where COL_ID = RES_COL;\n"
"}\n"
"--src dav.sql:5199\n";

static const char *trig4 = 
"#line 5237 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_COL_U after update on WS.WS.SYS_DAV_COL referencing old as O, new as N\n"
"{\n"
"declare full_path, name, _pflags, _cflags varchar;\n"
"declare old_col_path, new_col_path varchar;\n"
"declare res, col integer;\n"
"\n"
"col := N.COL_PARENT;\n"
"res := N.COL_ID;\n"
"full_path := concat (\'/\', N.COL_NAME,\'/\');\n"
"_cflags := N.COL_PERMS;\n"
"_pflags := coalesce ((select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = col), \'000000000TM\');\n"
"if ((O.COL_PARENT <> N.COL_PARENT) or (O.COL_PERMS <> N.COL_PERMS))\n"
"{\n"
"DAV_PERMS_FIX (_pflags, \'000000000TM\');\n"
"DAV_PERMS_INHERIT (_cflags, _pflags);\n"
"}\n"
"whenever not found goto not_found;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into name, col from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"full_path := concat (\'/\', name, full_path);\n"
"}\n"
"not_found:\n"
"set triggers off;\n"
"if (_cflags <> N.COL_PERMS)\n"
"{\n"
"\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = _cflags where COL_ID = res;\n"
"N.COL_PERMS := _cflags;\n"
"}\n"
"old_col_path := concat (WS.WS.COL_PATH (O.COL_PARENT), O.COL_NAME, \'/\');\n"
"new_col_path := WS.WS.COL_PATH (N.COL_ID);\n"
"if (old_col_path <> new_col_path)\n"
"{\n"
"\n"
"for\n"
"select SUBCOL_ID, SUBCOL_FULL_PATH as old_subcol_path, SUBCOL_DET\n"
"from DAV_PLAIN_SUBMOUNTS\n"
"where root_id = O.COL_ID and root_path = old_col_path and recursive=1 and subcol_auth_uid = http_dav_uid()\n"
"and not (SUBCOL_DET like \'%Filter\')\n"
"do\n"
"{\n"
"declare new_subcol_path varchar;\n"
"new_subcol_path := new_col_path || subseq (old_subcol_path, length (old_col_path));\n"
"for\n"
"select CF_ID from WS.WS.SYS_DAV_CATFILTER\n"
"where (\n"
"(\"LEFT\" (old_subcol_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH) and\n"
"(\"LEFT\" (new_subcol_path, length (CF_SEARCH_PATH)) <> CF_SEARCH_PATH) )\n"
"do\n"
"{\n"
"delete from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_CF_ID = CF_ID and CFD_DET_SUBCOL_ID = SUBCOL_ID;\n"
"}\n"
"for\n"
"select CF_ID from WS.WS.SYS_DAV_CATFILTER\n"
"where (\n"
"(\"LEFT\" (old_subcol_path, length (CF_SEARCH_PATH)) <> CF_SEARCH_PATH) and\n"
"(\"LEFT\" (new_subcol_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH) )\n"
"do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET) values (CF_ID, SUBCOL_ID, SUBCOL_DET);\n"
"}\n"
"}\n"
"}\n"
"if (\n"
"(N.COL_DET is not null or O.COL_DET is not null) and\n"
"not (N.COL_DET is not null and O.COL_DET is not null and (N.COL_DET = O.COL_DET) and (N.COL_ID = O.COL_ID) and (N.COL_PARENT = O.COL_PARENT)))\n"
"{\n"
"\n"
"delete from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_DET_SUBCOL_ID = O.COL_ID;\n"
"if (N.COL_DET is not null and not (N.COL_DET like \'%Filter\'))\n"
"{\n"
"for select CF_ID from WS.WS.SYS_DAV_CATFILTER where \"LEFT\" (new_col_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (CF_ID, N.COL_ID, N.COL_DET);\n"
"}\n"
"}\n"
"}\n"
"\n"
"declare repl varchar;\n"
"repl := null;\n"
"declare pub, pub1 varchar;\n"
"declare uname, gname varchar;\n"
"\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (old_col_path);\n"
"pub1 := WS.WS.ISPUBL (new_col_path);\n"
"if (isstring (pub1))\n"
"{\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.COL_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.COL_GROUP;\n"
"nfg:;\n"
"}\n"
"if ((not isstring (pub) and isstring (pub1)) or (isstring (pub) and isstring (pub1) and pub <> pub1))\n"
"{\n"
"\n"
"repl_text (pub1, \'\"DB.DBA.DAV_COL_I\" (?, ?, ?, ?, ?, ?)\',\n"
"N.COL_NAME, new_col_path, N.COL_CR_TIME, uname, gname,\n"
"N.COL_PERMS );\n"
"repl := pub1;\n"
"}\n"
"if (isstring (pub) and isstring (pub1) and pub = pub1)\n"
"{\n"
"\n"
"repl_text (pub1, \'\"DB.DBA.DAV_COL_U\" (?, ?, ?, ?, ?, ?)\',\n"
"old_col_path, new_col_path, N.COL_CR_TIME, uname, gname,\n"
"N.COL_PERMS );\n"
"}\n"
"if ((not isstring (pub1) and isstring (pub)) or (isstring (pub) and isstring (pub1) and pub <> pub1))\n"
"{\n"
"\n"
"repl_text (pub, \'\"DB.DBA.DAV_COL_D\" (?, 1)\', old_col_path);\n"
"}\n"
"\n"
"WS.WS.UPDCHILD (res, full_path, _pflags, repl);\n"
"set triggers on;\n"
"if (ascii(\'R\') = _pflags[9])\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, \'T\', 9)\n"
"where (RES_FULL_PATH between full_path and DAV_COL_PATH_BOUNDARY (full_path))\n"
"and RES_PERMS[9] = ascii (\'N\');\n"
"else\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, _pflags[9], 9)\n"
"where RES_COL = res and (case (lt (length (RES_PERMS), 10)) when 1 then 0 else RES_PERMS[9] end) <> _pflags[9];\n"
"if (ascii(\'R\') = _pflags[10])\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, \'M\', 10)\n"
"where (RES_FULL_PATH between full_path and DAV_COL_PATH_BOUNDARY (full_path))\n"
"and RES_PERMS[10] = ascii (\'N\');\n"
"else\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, _pflags[10], 10)\n"
"where RES_COL = res and (case (lt (length (RES_PERMS), 11)) when 1 then 0 else RES_PERMS[10] end) <> _pflags[10];\n"
"\n"
"}\n"
"--src dav.sql:5235\n";

static const char *proc71 = 
"#line 5375 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.UPDCHILD (in col integer, in root_path varchar, in _pflags varchar, in repl varchar)\n"
"{\n"
"declare name, new_path, str varchar;\n"
"declare id integer;\n"
"declare c_cur cursor for select COL_ID, COL_NAME, COL_MOD_TIME, COL_PERMS, COL_OWNER, COL_GROUP\n"
"from WS.WS.SYS_DAV_COL where COL_PARENT = col;\n"
"\n"
"for select RES_ID, RES_NAME, RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = col do\n"
"{\n"
"\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\' where VU_RES_ID = RES_ID;\n"
"\n"
"if (RES_NAME like \'%.vsp\')\n"
"WS.WS.DAV_VSP_DEF_REMOVE (RES_FULL_PATH);\n"
"}\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = concat (root_path, RES_NAME) where RES_COL = col and ((RES_FULL_PATH <> concat (root_path, RES_NAME)) or RES_FULL_PATH is null);\n"
"if (ascii (\'R\') = _pflags[9])\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = DAV_PERMS_SET_CHAR (COL_PERMS, \'R\', 9)\n"
"where COL_PARENT = col and ascii (\'R\') <> COL_PERMS[9];\n"
"if (ascii (\'R\') = _pflags[10])\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = DAV_PERMS_SET_CHAR (COL_PERMS, \'R\', 10)\n"
"where COL_PARENT = col and ascii (\'R\') <> COL_PERMS[10];\n"
"\n"
"\n"
"declare _grp, _uid integer;\n"
"declare cperms varchar;\n"
"declare ctime datetime;\n"
"declare uname, gname varchar;\n"
"declare rn, rt, rc, rp varchar;\n"
"declare ro, rg integer;\n"
"declare rmt datetime;\n"
"declare chr cursor for select RES_NAME, RES_TYPE, RES_CONTENT, RES_PERMS,\n"
"RES_OWNER, RES_GROUP, RES_MOD_TIME from WS.WS.SYS_DAV_RES\n"
"where RES_COL = col;\n"
"if (repl is not null)\n"
"{\n"
"whenever not found goto er;\n"
"open chr;\n"
"while (1)\n"
"{\n"
"fetch chr into rn, rt, rc, rp, ro, rg, rmt;\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = ro;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = rg;\n"
"nfg:;\n"
"repl_text (repl, \'\"DB.DBA.DAV_RES_I\" (?, ?, ?, ?, ?, ?, ?)\', concat (root_path, rn),\n"
"rmt, uname, gname, rp, rt, WS.WS.BODY_ARR (rc, null));\n"
"}\n"
"er:\n"
"close chr;\n"
"\n"
"}\n"
"\n"
"whenever not found goto not_col;\n"
"open c_cur;\n"
"while (1)\n"
"{\n"
"fetch c_cur into id, name, ctime, cperms, _uid, _grp;\n"
"new_path := concat (root_path, name, \'/\');\n"
"\n"
"if (repl is not null)\n"
"{\n"
"whenever not found goto nfu1;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = _uid;\n"
"nfu1:;\n"
"whenever not found goto nfg1;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = _grp;\n"
"nfg1:;\n"
"repl_text (repl, \'\"DB.DBA.DAV_COL_I\" (?, ?, ?, ?, ?, ?)\',\n"
"name, new_path, ctime, uname, gname,\n"
"cperms );\n"
"}\n"
"\n"
"WS.WS.UPDCHILD (id, new_path, _pflags, repl);\n"
"}\n"
"not_col:\n"
"close c_cur;\n"
"}\n"
"--src dav.sql:5373\n"
;

static const char *trig5 = 
"#line 5458 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_COL_I after insert on WS.WS.SYS_DAV_COL referencing new as N\n"
"{\n"
"declare _pflags, _cflags, col_path, _inh varchar;\n"
"declare _col, _p_col integer;\n"
"\n"
"_col := N.COL_ID;\n"
"_p_col := N.COL_PARENT;\n"
"col_path := WS.WS.COL_PATH (_p_col) || N.COL_NAME || \'/\';\n"
"set triggers off;\n"
"_cflags := N.COL_PERMS;\n"
"_pflags := \'000000000NN\';\n"
"_inh := \'N\';\n"
"for select COL_PERMS, COL_INHERIT from WS.WS.SYS_DAV_COL where COL_ID = _p_col do\n"
"{\n"
"_pflags := COL_PERMS;\n"
"_inh := COL_INHERIT;\n"
"}\n"
"if (_inh = \'R\')\n"
"_cflags := _pflags;\n"
"DAV_PERMS_FIX (_cflags, _pflags);\n"
"if (_cflags <> N.COL_PERMS)\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = _cflags where COL_ID = _col;\n"
"if (N.COL_DET is not null and not (N.COL_DET like \'%Filter\'))\n"
"{\n"
"for select CF_ID from WS.WS.SYS_DAV_CATFILTER where \"LEFT\" (col_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (CF_ID, _col, N.COL_DET);\n"
"}\n"
"}\n"
"\n"
"declare pub varchar;\n"
"declare uname, gname varchar;\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (col_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.COL_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.COL_GROUP;\n"
"nfg:;\n"
"repl_text (pub, \'\"DB.DBA.DAV_COL_I\" (?, ?, ?, ?, ?, ?)\',\n"
"N.COL_NAME, col_path, N.COL_CR_TIME, uname, gname, N.COL_PERMS );\n"
"}\n"
"\n"
"\n"
"}\n"
"--src dav.sql:5456\n";

static const char *proc72 = 
"#line 5510 \"[executable]/dav.sql\"\n"
"create procedure\n"
"WS.WS.DAV_VSP_INCLUDES_CHANGED (in full_path varchar, in own varchar)\n"
"{\n"
"declare incst, dep any;\n"
"dep := null;\n"
"incst := registry_get (concat (\'__depend_\', own, \'_\', full_path));\n"
"if (isstring (incst))\n"
"dep := deserialize (incst);\n"
"if (isarray (dep))\n"
"{\n"
"declare i, l integer;\n"
"declare mt datetime;\n"
"l := length (dep); i := 0;\n"
"if (mod (l, 2))\n"
"return 1;\n"
"while (i < l)\n"
"{\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH = dep [i] and RES_MOD_TIME = stringdate(dep [i+1])))\n"
"return 1;\n"
"i := i + 2;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:5508\n"
;

static const char *proc73 = 
"#line 5538 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.EXPAND_INCLUDES (\n"
"in path varchar,\n"
"inout stream varchar,\n"
"in level integer,\n"
"in ct integer,\n"
"in content varchar,\n"
"inout st any := null)\n"
"{\n"
"declare curr_file, new_file_name, name, _perms varchar;\n"
"declare include_inx, end_tag_inx, _u_id, _grp integer;\n"
"declare apath any;\n"
"declare rc, col integer;\n"
"declare modt datetime;\n"
"\n"
"end_tag_inx := 0;\n"
"if (ct = 0)\n"
"{\n"
"apath := WS.WS.HREF_TO_ARRAY (path, \'\');\n"
"rc := WS.WS.FINDRES (apath, col, name);\n"
"}\n"
"else\n"
"{\n"
"rc := 1;\n"
"}\n"
"\n"
"if (rc < 0 and 0 <> file_stat (http_root () || path))\n"
"{\n"
"content := file_to_string (http_root () || path);\n"
"ct := 1;\n"
"rc := 1;\n"
"}\n"
"\n"
"if (isarray (rc))\n"
"signal (\'37000\', sprintf (\'The included resource \"%s\" is a special \"%s\" resource, not a plain DAV one\', path, rc[0]), \'DA010\');\n"
"\n"
"if (rc < 0)\n"
"signal (\'37000\', sprintf (\'The included resource \"%s\" does not exist\', path), \'DA009\');\n"
"\n"
"else\n"
"{\n"
"if (ct = 0)\n"
"{\n"
"declare exit handler for not found\n"
"{\n"
"signal (\'22023\', sprintf (\'The included resource \"%s\" does not exist\', path), \'DA009\');\n"
"};\n"
"select blob_to_string (RES_CONTENT), RES_OWNER, RES_GROUP, RES_PERMS, RES_MOD_TIME\n"
"into curr_file, _u_id, _grp, _perms, modt from WS.WS.SYS_DAV_RES\n"
"where RES_NAME = name and RES_COL = col;\n"
"if (not http_map_get (\'executable\'))\n"
"{\n"
"if (_u_id <> http_dav_uid () or _perms like \'____1%\' or _perms like \'_______1%\')\n"
"signal (\'37000\', \'Includes can be owned only by admin & cannot be writable for others\', \'DA001\');\n"
"}\n"
"if (st is not null and isarray (st))\n"
"st := vector_concat (st, vector (path, DB.DBA.date_iso8601 (modt)));\n"
"}\n"
"else\n"
"curr_file := content;\n"
"}\n"
"\n"
"include_inx := strcasestr (curr_file, \'<?include\');\n"
"while (include_inx is not null)\n"
"{\n"
"if (level > 20)\n"
"signal ( \'37000\', sprintf (\'Max nesting level (20) reached when processing %s\', path), \'DA002\');\n"
"end_tag_inx := strstr (subseq (curr_file, include_inx, length (curr_file)), \'?>\');\n"
"if (end_tag_inx is null)\n"
"signal ( \'37000\', sprintf (\'Unterminated include tag at offset %d in %s\', include_inx, path), \'DA003\');\n"
"end_tag_inx := end_tag_inx + include_inx;\n"
"if (end_tag_inx - include_inx - 9 <= 0)\n"
"signal ( \'37000\',\n"
"sprintf (\'An include tag at offset %d with no name or VSP end tag before an include tag in %s \',\n"
"include_inx, path), \'DA004\');\n"
"if (include_inx > 0)\n"
"http (subseq (curr_file, 0, include_inx), stream);\n"
"new_file_name := trim (subseq (curr_file, include_inx + 9, end_tag_inx));\n"
"if (aref (new_file_name, 0) <> ascii( \'/\'))\n"
"{\n"
"\n"
"new_file_name :=  WS.WS.EXPAND_URL (path, new_file_name);\n"
"}\n"
"WS.WS.EXPAND_INCLUDES (new_file_name, stream, level + 1, 0, \'\', st);\n"
"if (end_tag_inx + 2 <= length (curr_file))\n"
"curr_file := subseq (curr_file, end_tag_inx + 2, length (curr_file));\n"
"include_inx := strcasestr (curr_file, \'<?include\');\n"
"}\n"
"if (length (curr_file) > 0)\n"
"http (curr_file, stream);\n"
"}\n"
"--src dav.sql:5536\n"
;

static const char *trig6 = 
"#line 5630 \"[executable]/dav.sql\"\n"
"create trigger SYS_DAV_COL_D before delete on WS.WS.SYS_DAV_COL order 100\n"
"{\n"
"declare pub, col_path varchar;\n"
"col_path := WS.WS.COL_PATH (COL_ID);\n"
"\n"
"delete from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_DET_SUBCOL_ID = COL_ID;\n"
"\n"
"pub := WS.WS.ISPUBL (col_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"repl_text (pub, \'\"DB.DBA.DAV_COL_D\" (?, 0)\', col_path);\n"
"}\n"
"\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_TYPE = \'C\' and PROP_PARENT_ID = COL_ID;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = COL_ID;\n"
"\n"
"}\n"
"--src dav.sql:5628\n";

static const char *proc74 = 
"#line 5652 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.XML_VIEW_HEADER\n"
"(\n"
"in view_name varchar,\n"
"in top_tag varchar,\n"
"in path varchar,\n"
"in meta_mode integer,\n"
"in meta_data varchar,\n"
"inout http_body any\n"
")\n"
"{\n"
"if (meta_mode = 0)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 1)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<!DOCTYPE \', top_tag, \' [\\n\'), http_body);\n"
"http (xml_view_dtd (view_name, top_tag), http_body);\n"
"http (concat (meta_data, \'] >\\n\'), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 2)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<!DOCTYPE \', top_tag, \' SYSTEM \"\', path, \'.dtd\">\'), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 3)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\"  ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<!DOCTYPE \', top_tag, \' \', meta_data, \'>\'), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 4)\n"
"{\n"
"signal (\'22023\', \'Unsupported type of metadata\', \'DA005\');\n"
"http (sprintf (\'<?xml version=\"1.0\"  encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag,\' xmlns=\"\', path, \'.xsd\" \',meta_data, \'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 5)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag,\' xmlns=\"\', path, \'.xsd\" \', meta_data, \'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 6)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag ,\' \' , meta_data, \'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"signal (\'22023\', \'Unsupported type of metadata\', \'DA006\');\n"
"}\n"
"--src dav.sql:5650\n"
;

static const char *proc75 = 
"#line 5715 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.XML_VIEW_EXTERNAL_META\n"
"(\n"
"in view_name varchar,\n"
"in top_tag varchar,\n"
"in meta_mode integer,\n"
"in meta_data varchar,\n"
"inout http_body any,\n"
"inout meta_path_suffix varchar,\n"
"inout mime_type varchar\n"
")\n"
"{\n"
"if (meta_mode = 2)\n"
"{\n"
"http (xml_view_dtd (view_name, top_tag), http_body);\n"
"http (meta_data, http_body);\n"
"meta_path_suffix := \'.dtd\';\n"
"mime_type := \'xml/dtd\';\n"
"return;\n"
"}\n"
"if (meta_mode = 5)\n"
"{\n"
"http (xml_view_schema (view_name, top_tag), http_body);\n"
"meta_path_suffix := \'.xsd\';\n"
"mime_type := \'xml/schema\';\n"
"return;\n"
"}\n"
"meta_path_suffix := \'\';\n"
"mime_type := \'\';\n"
"}\n"
"--src dav.sql:5713\n"
;

static const char *proc76 = 
"#line 5746 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.XML_VIEW_UPDATE (in _view varchar, in _res_id integer, in path varchar, in meta_mode integer, in meta_data varchar)\n"
"{\n"
"declare _body any;\n"
"declare _pf varchar;\n"
"declare _procprefix varchar;\n"
"_procprefix := concat (name_part (_view, 0), \'.\', name_part (_view, 1), \'.\');\n"
"_body := string_output ();\n"
"WS.WS.XML_VIEW_HEADER(_view, name_part (_view, 2), path, meta_mode, meta_data, _body);\n"
"_pf := concat (_procprefix, \'http_view_\', name_part (_view, 2));\n"
"call (_pf) (_body);\n"
"http (concat (\'</\', name_part (_view, 2), \'>\'), _body);\n"
"_body := string_output_string (_body);\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = _body, RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"--src dav.sql:5744\n"
;

static const char *proc77 = 
"#line 5762 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.FIXPATH (\n"
"in path any)\n"
"{\n"
"return path;\n"
"}\n"
"--src dav.sql:5760\n"
;

static const char *proc78 = 
"#line 5770 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.ISPUBL (in __path varchar)\n"
"{\n"
"declare _srv, _path varchar;\n"
"declare _ix, _len integer;\n"
"\n"
"if (isvector (__path))\n"
"{\n"
"_ix := 0;\n"
"_len := length (__path);\n"
"_path := \'/\';\n"
"while (_ix < _len)\n"
"{\n"
"_path := concat ( _path, aref (__path, _ix), \'/\');\n"
"_ix := _ix + 1;\n"
"}\n"
"}\n"
"else if (isstring (__path))\n"
"{\n"
"_path := __path;\n"
"}\n"
"else\n"
"{\n"
"signal (\'22023\', \'Function ISPUBL needs string or array as argument.\', \'DA007\');\n"
"return NULL;\n"
"}\n"
"\n"
"_srv := repl_this_server ();\n"
"for (select TI_ITEM, TI_ACCT from DB.DBA.SYS_TP_ITEM where TI_SERVER = _srv and TI_TYPE = 1) do\n"
"{\n"
"if (TI_ITEM is not null and length (TI_ITEM) > 0)\n"
"{\n"
"if (aref (TI_ITEM, length (TI_ITEM) - 1) <> ascii (\'/\'))\n"
"{\n"
"if (_path between (TI_ITEM || \'/\') and DAV_COL_PATH_BOUNDARY (TI_ITEM || \'/\'))\n"
"return TI_ACCT;\n"
"}\n"
"else if (_path between TI_ITEM and DAV_COL_PATH_BOUNDARY (TI_ITEM))\n"
"{\n"
"return TI_ACCT;\n"
"}\n"
"}\n"
"}\n"
"return null;\n"
"}\n"
"--src dav.sql:5768\n"
;

static const char *proc79 = 
"#line 5816 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.BODY_ARR (inout __ses any, in __pcs integer)\n"
"{\n"
"declare _res, _ses any;\n"
"declare _str varchar;\n"
"declare _len, _from, _pcs integer;\n"
"\n"
"if (__pcs is null)\n"
"_pcs := 1000000;\n"
"else\n"
"_pcs := __pcs;\n"
"\n"
"_res := null;\n"
"_from := 1;\n"
"\n"
"if (__tag (__ses) = 126 or __tag (__ses) = 133)\n"
"{\n"
"_ses := string_output ();\n"
"http (__ses, _ses);\n"
"_len := length (_ses);\n"
"while (_from < _len)\n"
"{\n"
"_str := substring (_ses, _from, _pcs);\n"
"if (_res is null)\n"
"_res := vector (_str);\n"
"else\n"
"_res := vector_concat (_res, vector (_str));\n"
"_from := _from + _pcs;\n"
"}\n"
"}\n"
"else if (isstring (__ses) or __tag (__ses) = 185)\n"
"{\n"
"_len := length (__ses);\n"
"while (_from < _len)\n"
"{\n"
"_str := substring (__ses, _from, _pcs);\n"
"if (_res is null)\n"
"_res := vector (_str);\n"
"else\n"
"_res := vector_concat (_res, vector (_str));\n"
"_from := _from + _pcs;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_ses := \'\';\n"
"}\n"
"\n"
"return _res;\n"
"}\n"
"--src dav.sql:5814\n"
;

static const char *proc80 = 
"#line 5871 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.XML_AUTO_SCHED (in _path varchar)\n"
"{\n"
"declare _stmt, ses, _root, _sch, _dtd, _dtd_body, _comments varchar;\n"
"declare _res_id integer;\n"
"_res_id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _path), 0);\n"
"if (_res_id < 1)\n"
"return;\n"
"_stmt := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_root := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql-root\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'document\');\n"
"_sch := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql-schema\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_dtd := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql-dtd\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_comments := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-description\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"if (_stmt = \'\')\n"
"return;\n"
"ses := string_output (http_strses_memory_size ());\n"
"WS.WS.XMLSQL_TO_STRSES (_stmt, _root, _sch, _dtd, _comments, ses);\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = ses, RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"--src dav.sql:5869\n"
;

static const char *proc81 = 
"#line 5903 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.DAV_LOGIN (\n"
"in path any,\n"
"in lines any,\n"
"in __access varchar,\n"
"inout __u_id integer,\n"
"inout __grp integer,\n"
"inout __perms varchar)\n"
"{\n"
"declare auth any;\n"
"declare _access, _perms varchar;\n"
"declare _u_id, _grp integer;\n"
"\n"
"_u_id := http_nobody_uid ();\n"
"_grp := http_nogroup_gid ();\n"
"_perms := \'110110110\';\n"
"\n"
"if (upper (__access) = \'R\')\n"
"_access := \'100\';\n"
"else if ( upper (__access) = \'RW\')\n"
"_access := \'110\';\n"
"else\n"
"_access := \'100\';\n"
"\n"
"auth := DB.DBA.vsp_auth_vec (lines);\n"
"if (not WS.WS.ISPUBLIC (path, _access) or auth <> 0)\n"
"{\n"
"_u_id := WS.WS.CHECK_AUTH (lines);\n"
"if (_u_id = http_nobody_uid ())\n"
"return _u_id;\n"
"\n"
"if (not WS.WS.CHECKPERM (path, _u_id, _access))\n"
"return 0;\n"
"}\n"
"\n"
"if (_u_id <> 0)\n"
"select U_DEF_PERMS, U_GROUP into _perms, _grp from WS.WS.SYS_DAV_USER where U_ID = _u_id;\n"
"\n"
"if (__u_id is not null)\n"
"__u_id := _u_id;\n"
"\n"
"if (__grp is not null)\n"
"__grp := _grp;\n"
"\n"
"if (__u_id is not null)\n"
"__perms := _perms;\n"
"\n"
"return (1);\n"
"}\n"
"--src dav.sql:5901\n"
;

static const char *proc82 = 
"#line 5953 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.HTTP_RESP (\n"
"in hdr any,\n"
"out descr varchar)\n"
"{\n"
"declare line, code varchar;\n"
"\n"
"descr := \'Bad Gateway\';\n"
"if (hdr is null or __tag (hdr) <> 193)\n"
"return (502);\n"
"\n"
"if (length (hdr) < 1)\n"
"return (502);\n"
"\n"
"line := aref (hdr, 0);\n"
"if (length (line) < 12)\n"
"return (502);\n"
"\n"
"code := substring (line, strstr (line, \'HTTP/1.\') + 9, length (line));\n"
"while ((length (code) > 0) and (aref (code, 0) < ascii (\'0\') or aref (code, 0) > ascii (\'9\')))\n"
"code := substring (code, 2, length (code) - 1);\n"
"\n"
"if (length (code) < 3)\n"
"return (502);\n"
"\n"
"if (length (code) > 3)\n"
"{\n"
"descr := substring (code, 4, length (code) - 3);\n"
"descr := replace (descr, chr(10), \'\');\n"
"descr := replace (descr, chr(13), \'\');\n"
"}\n"
"code := substring (code, 1, 3);\n"
"return atoi (code);\n"
"}\n"
"--src dav.sql:5951\n"
;

static const char *proc83 = 
"#line 5989 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.COPY_TO_OTHER (\n"
"in path varchar,\n"
"inout params varchar,\n"
"in lines varchar,\n"
"in __dst_name varchar)\n"
"{\n"
"declare _s_path, _ovr, _depth varchar;\n"
"declare _resp any;\n"
"declare _content, _thdr, _thost, _auth, _resp_cli, _dst_name varchar;\n"
"declare _len, _sl, _code  integer;\n"
"declare _u_id, _grp, _perms any;\n"
"\n"
"_dst_name := WS.WS.FINDPARAM (lines, \'Destination\');\n"
"WS.WS.DAV_LOGIN (path, lines, \'R\', _u_id, _grp, _perms);\n"
"\n"
"_s_path := http_path ();\n"
"_ovr := WS.WS.FINDPARAM (lines, \'Overwrite\');\n"
"if (_ovr = \'\')\n"
"_ovr := \'T\';\n"
"\n"
"_depth := WS.WS.FINDPARAM (lines, \'Depth\');\n"
"if (_depth = \'\')\n"
"_depth := \'infinity\';\n"
"\n"
"_auth := WS.WS.FINDPARAM (lines, \'Authorization\');\n"
"\n"
"_thost := substring (_dst_name, 8, length (_dst_name) - 8);\n"
"_sl := strchr (_thost, \'/\');\n"
"if (_sl)\n"
"_thost := substring (_thost, 1, _sl);\n"
"\n"
"if (_auth <> \'\')\n"
"_thdr := concat (\'Host: \', _thost, \'\\r\\n\', \'Overwrite: \', _ovr, \'\\r\\n\', \'Authorization: \', _auth, \'\\r\\n\', \'Depth: \', _depth);\n"
"else\n"
"_thdr := concat (\'Host: \', _thost, \'\\r\\n\', \'Overwrite: \', _ovr, \'\\r\\n\', \'Depth: \', _depth);\n"
"\n"
"if (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (path, \'R\')) is not null)\n"
"{\n"
"\n"
"select blob_to_string (RES_CONTENT), DAV_RES_LENGTH (RES_CONTENT, RES_SIZE)\n"
"into _content, _len\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH = _s_path;\n"
"commit work;\n"
"\n"
"http_get (_dst_name, _resp, \'PUT\', _thdr, _content);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"\n"
"if (_code > 199 and _code < 299)\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"if (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (path, \'C\')) is not null)\n"
"{\n"
"\n"
"commit work;\n"
"http_get (_dst_name, _resp, \'HEAD\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code <> 200)\n"
"{\n"
"commit work;\n"
"http_get (_dst_name, _resp, \'MKCOL\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code < 200 or _code > 299)\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"return 0;\n"
"}\n"
"}\n"
"\n"
"for (select SUBCOL_FULL_PATH\n"
"from DAV_PLAIN_SUBCOLS\n"
"where root_id = NULL and root_path = concat (_s_path, \'/\') and recursive = 1 and subcol_auth_uid = null and subcol_auth_pwd = null\n"
"order by SUBCOL_ID) do\n"
"{\n"
"commit work;\n"
"http_get (concat (\'http://\', _thost, SUBCOL_FULL_PATH), _resp, \'HEAD\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code <> 200)\n"
"{\n"
"http_get (concat (\'http://\', _thost, SUBCOL_FULL_PATH), _resp, \'MKCOL\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code < 200 or _code > 299)\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"return 0;\n"
"}\n"
"}\n"
"\n"
"}\n"
"for (select RES_FULL_PATH as res_path, blob_to_string (RES_CONTENT) as content\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH like concat (_s_path, \'/%\')\n"
"order by RES_ID) do\n"
"{\n"
"commit work;\n"
"http_get (concat (\'http://\', _thost, res_path), _resp, \'PUT\', _thdr, content);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code < 200 or _code > 299)\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"return 0;\n"
"}\n"
"\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (404);\n"
"return 0;\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src dav.sql:5987\n"
;

static const char *proc84 = 
"#line 6108 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.CHECK_READ_ACCESS (\n"
"in _u_id integer,\n"
"in doc_id integer)\n"
"{\n"
"declare _perms varchar;\n"
"declare _user, _group, _1 integer;\n"
"\n"
"if (_u_id = http_dav_uid ())\n"
"return 1;\n"
"\n"
"whenever not found goto exit_p;\n"
"select RES_OWNER, RES_GROUP, RES_PERMS\n"
"into _user, _group, _perms\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = doc_id;\n"
"\n"
"if (isnull (_perms))\n"
"goto exit_p;\n"
"\n"
"_perms := cast (_perms as varchar);\n"
"_1 := ascii(\'1\');\n"
"if ((_u_id = _user) and (_perms[0] = _1))\n"
"return 1;\n"
"\n"
"if ((_perms[3] = _1) and (_group = coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = _u_id), 0)))\n"
"return 1;\n"
"\n"
"if (_perms[6] = _1)\n"
"return 1;\n"
"\n"
"exit_p:;\n"
"return 0;\n"
"}\n"
"--src dav.sql:6106\n"
;

static const char *proc85 = 
"#line 6143 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.IS_REDIRECT_REF (inout path any, in lines any, inout location varchar)\n"
"{\n"
"declare fpath, fpath1, _ref, lpath, ppath varchar;\n"
"declare rc integer;\n"
"\n"
"rc := 0;\n"
"set isolation=\'committed\';\n"
"location := http_path ();\n"
"declare cr cursor for select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_RES, WS.WS.SYS_DAV_PROP where\n"
"RES_FULL_PATH = fpath1\n"
"and PROP_PARENT_ID = RES_ID and\n"
"PROP_NAME = \'redirectref\' and PROP_TYPE = \'R\' option (order);\n"
"fpath := http_physical_path ();\n"
"fpath1 := rtrim (fpath, \'/\');\n"
"whenever not found goto nfp;\n"
"open cr (prefetch 1);\n"
"fetch cr into _ref;\n"
"if (not isstring (_ref))\n"
"goto nfp;\n"
"lpath := http_path ();\n"
"location := WS.WS.EXPAND_URL (lpath, _ref);\n"
"ppath := WS.WS.EXPAND_URL (fpath, _ref);\n"
"path := WS.WS.HREF_TO_ARRAY (ppath, \'\');\n"
"rc := 1;\n"
"nfp:\n"
"close cr;\n"
"set isolation=\'repeatable\';\n"
"return rc;\n"
"}\n"
"--src dav.sql:6141\n"
;

static const char *proc86 = 
"#line 6174 \"[executable]/dav.sql\"\n"
"create function WS.WS.DAV_DIR_LIST (\n"
"in path any,\n"
"inout params any,\n"
"in lines any,\n"
"in full_path varchar,\n"
"in logical_root_path varchar,\n"
"in col integer,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in auth_uid integer) returns integer\n"
"{\n"
"\n"
"declare _dir, _dir_item, _dir_entry, _xml, _modify, fsize, _html, _b_opt, _xml_sheet any;\n"
"declare _name, xslt_file, xslt_folder, vspx_path varchar;\n"
"declare _res_len, flen, mult, N integer;\n"
"declare _dir_len, _dir_ctr integer;\n"
"declare _user_name, _group_name varchar;\n"
"declare _user_id, _group_id integer;\n"
"declare action, feedAction any;\n"
"\n"
"if ((length (params) = 4) and (__tag (params[1]) = 185) and (params[2] = \'attr-Content\'))\n"
"params := __http_stream_params ();\n"
"\n"
"action := get_keyword (\'a\', params, \'\');\n"
"feedAction := case when (action  in (\'rss\', \'atom\', \'rdf\', \'opml\', \'atomPub\')) then 1 else 0 end;\n"
"if (not feedAction and (registry_get (\'__WebDAV_vspx__\') = \'yes\'))\n"
"{\n"
"vspx_path := \'/DAV/VAD/conductor/folder.vspx\';\n"
"params := vector_concat (params, vector (\'dir\', full_path));\n"
"\n"
"action := get_keyword (\'a\', params, \'\');\n"
"if (action in (\'new\', \'upload\', \'create\', \'link\', \'update\', \'edit\', \'imap\'))\n"
"params := vector_concat (params, vector (\'a\', action));\n"
"\n"
"if (not isnull (auth_uname))\n"
"connection_set (\'vspx_user\', auth_uname);\n"
"\n"
"DB.DBA.vspx_dispatch (vspx_path, path, params, lines);\n"
"return;\n"
"}\n"
"_dir := DAV_DIR_LIST_INT (full_path, 0, \'%\', auth_uname, auth_pwd, auth_uid);\n"
"if (isinteger (_dir))\n"
"return _dir;\n"
"\n"
"_dir_len := length (_dir);\n"
"if (action = \'opml\')\n"
"{\n"
"_dir_entry := DAV_DIR_SINGLE_INT (col, \'C\', full_path, null, null, http_dav_uid ());\n"
"http_header (\'Content-type: text/xml; charset=\"UTF-8\"\\r\\n\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\');\n"
"http (\'<opml version=\"2.0\">\');\n"
"http (\'<head>\');\n"
"http (sprintf (\'<title>WebDAV Directory %s\"</title>\', cast (full_path as varchar)));\n"
"http (sprintf (\'<dateCreated>%s</dateCreated>\', soap_print_box (_dir_entry[8], \'\', 1)));\n"
"http (sprintf (\'<dateModified>%s</dateModified>\', soap_print_box (_dir_entry[3], \'\', 1)));\n"
"http (sprintf (\'<ownerName>%s</ownerName>\', coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = _dir_entry[7]), \'nobody\')));\n"
"http (\'</head>\');\n"
"http (\'<body>\');\n"
"for (_dir_ctr := 0; _dir_ctr < _dir_len; _dir_ctr := _dir_ctr + 1)\n"
"{\n"
"_dir_item := _dir [_dir_ctr];\n"
"if (_dir_item[1] = \'C\')\n"
"{\n"
"http (sprintf (\'<outline text=\"WebDAV Directory %V\" htmlUrl=\"%V\" type=\"rss\" xmlUrl=\"%V?a=rss\" />\', _dir_item[0], WS.WS.DAV_HOST () || _dir_item[0], WS.WS.DAV_HOST () || _dir_item[0]));\n"
"}\n"
"}\n"
"http (\'</body>\');\n"
"http (\'</opml>\');\n"
"}\n"
"else if (action = \'atomPub\')\n"
"{\n"
"_dir_entry := DAV_DIR_SINGLE_INT (col, \'C\', full_path, null, null, http_dav_uid ());\n"
"http_header (\'Content-type: text/xml; charset=\"UTF-8\"\\r\\n\');\n"
"http (         \'<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\');\n"
"http (         \'<service xmlns=\"http://www.w3.org/2007/app\" xmlns:atom=\"http://www.w3.org/2005/Atom\">\');\n"
"http (         \'  <workspace>\');\n"
"http (         \'    <atom:title>WebDAV AtomPub</atom:title>\');\n"
"http (sprintf (\'    <collection href=\"%V\" >\', WS.WS.DAV_HOST () || _dir_entry[0]));\n"
"http (sprintf (\'      <atom:title>%V Entries</atom:title>\', _dir_entry[0]));\n"
"http (         \'      <categories>\');\n"
"http (         \'        <atom:category term=\"collection\" />\');\n"
"http (         \'        <atom:category term=\"resource\" />\');\n"
"http (         \'      </categories>\');\n"
"http (         \'    </collection>\');\n"
"http (         \'  </workspace>\');\n"
"http (         \'</service>\');\n"
"}\n"
"else\n"
"{\n"
"_xml := string_output ();\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\', _xml);\n"
"http (sprintf (\'<PATH dir_host=\"%V\" dir_name=\"%V\" physical_dir_name=\"%V\">\', WS.WS.DAV_HOST (), cast (logical_root_path as varchar), cast (full_path as varchar)), _xml);\n"
"http (\'<DIRS>\', _xml);\n"
"\n"
"http (\'<SUBDIR modify=\"\" name=\"..\" />\\n\', _xml);\n"
"_user_id := -1;\n"
"_group_id := -1;\n"
"_user_name := \'\';\n"
"_group_name := \'\';\n"
"for (_dir_ctr := 0; _dir_ctr < _dir_len; _dir_ctr := _dir_ctr + 1)\n"
"{\n"
"_dir_item := _dir [_dir_ctr];\n"
"if (_dir_item[1] = \'C\')\n"
"{\n"
"_name := rtrim (_dir_item[0], \'/\');\n"
"_name := subseq (_name, strrchr (_name, \'/\') + 1);\n"
"if (_user_id <> coalesce (_dir_item[7], -1))\n"
"{\n"
"_user_id := coalesce (_dir_item[7], -1);\n"
"_user_name := coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = _user_id), \'\');\n"
"}\n"
"if (_group_id <> coalesce (_dir_item[6], -1))\n"
"{\n"
"_group_id := coalesce (_dir_item[6], -1);\n"
"_group_name := coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = _group_id), \'\');\n"
"}\n"
"http (sprintf (\'<SUBDIR modify=\"%s\" owner=\"%s\" group=\"%s\" permissions=\"%s\" name=\"\', soap_print_box (_dir_item[3], \'\', 0), _user_name, _group_name, DB.DBA.DAV_PERM_D2U (_dir_item[5]), _dir_item[9]), _xml );\n"
"http_value (_name, null, _xml );\n"
"http (\'\"\', _xml );\n"
"if (feedAction)\n"
"http (sprintf (\' pubDate=\"%s\"\', soap_print_box (_dir_item[8], \'\', 1)), _xml);\n"
"\n"
"http (\' />\\n\', _xml );\n"
"}\n"
"}\n"
"http (\'</DIRS><FILES>\', _xml);\n"
"\n"
"fsize := vector (\'B\', \'K\', \'M\', \'G\', \'T\');\n"
"xslt_file := null;\n"
"_user_id := -1;\n"
"_group_id := -1;\n"
"_user_name := \'\';\n"
"_group_name := \'\';\n"
"for (_dir_ctr := 0; _dir_ctr < _dir_len; _dir_ctr := _dir_ctr + 1)\n"
"{\n"
"_dir_item := _dir [_dir_ctr];\n"
"if (_dir_item[1] = \'R\')\n"
"{\n"
"_name := _dir_item[0];\n"
"_name := subseq (_name, strrchr (_name, \'/\') + 1);\n"
"if (lower (_name) = \'.folder.xsl\')\n"
"xslt_file := cast (full_path as varchar) || _name;\n"
"\n"
"_res_len := _dir_item[2];\n"
"flen := _res_len;\n"
"mult := 0;\n"
"while ((flen / 1024) > 1)\n"
"{\n"
"mult := mult + 1;\n"
"flen := flen / 1024;\n"
"}\n"
"if (_user_id <> coalesce (_dir_item[7], -1))\n"
"{\n"
"_user_id := coalesce (_dir_item[7], -1);\n"
"_user_name := coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = _user_id), \'\');\n"
"}\n"
"if (_group_id <> coalesce (_dir_item[6], -1))\n"
"{\n"
"_group_id := coalesce (_dir_item[6], -1);\n"
"_group_name := coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = _group_id), \'\');\n"
"}\n"
"http (sprintf (\'<FILE modify=\"%s\" owner=\"%s\" group=\"%s\" permissions=\"%s\" mimeType=\"%s\" rs=\"%i\" lenght=\"%d\" hs=\"%d %s\" name=\"\', soap_print_box (_dir_item[3], \'\', 0), _user_name, _group_name, DB.DBA.DAV_PERM_D2U (_dir_item[5]), _dir_item[9], _res_len, _dir_item[2], flen, aref (fsize, mult)), _xml);\n"
"http_value (_name, null, _xml );\n"
"http (\'\"\', _xml );\n"
"if (feedAction)\n"
"http (sprintf (\' pubDate=\"%s\"\', soap_print_box (_dir_item[8], \'\', 1)), _xml);\n"
"\n"
"http (\' />\\n\', _xml );\n"
"}\n"
"}\n"
"http (\'</FILES></PATH>\', _xml);\n"
"_xml := xtree_doc (_xml);\n"
"\n"
"if (feedAction)\n"
"{\n"
"_xml_sheet := (select blob_to_string (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH = \'/DAV/.xml2rss.xsl\');\n"
"if (not isnull (_xml_sheet))\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"UTF-8\"\\r\\n\');\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xml_tree_doc (_xml_sheet));\n"
"_html := xslt (\'http://local.virt/custom_dir_output\', _xml);\n"
"if (action = \'atom\')\n"
"{\n"
"_xml_sheet := (select blob_to_string (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH = \'/DAV/.rss2atom.xsl\');\n"
"if (not isnull (_xml_sheet))\n"
"{\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xml_tree_doc (_xml_sheet));\n"
"_html := xslt (\'http://local.virt/custom_dir_output\', _html);\n"
"}\n"
"}\n"
"else if (action = \'rdf\')\n"
"{\n"
"_xml_sheet := (select blob_to_string (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH = \'/DAV/.rss2rdf.xsl\');\n"
"if (not isnull (_xml_sheet))\n"
"{\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xml_tree_doc (_xml_sheet));\n"
"_html := xslt (\'http://local.virt/custom_dir_output\', _html);\n"
"}\n"
"}\n"
"http_value (_html);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (isnull (xslt_file))\n"
"{\n"
"xslt_folder := full_path;\n"
"while (xslt_folder <> \'\')\n"
"{\n"
"xslt_folder := rtrim (xslt_folder, \'/\');\n"
"N := strrchr (xslt_folder, \'/\');\n"
"if (not isnull (N))\n"
"{\n"
"xslt_folder := subseq (xslt_folder, 0, N+1);\n"
"if (exists (select 1 from WS.WS.SYS_DAV_RES where RES_FULL_PATH = xslt_folder || \'.folder.xsl\'))\n"
"{\n"
"xslt_file := xslt_folder || \'.folder.xsl\';\n"
"goto _exit;\n"
"}\n"
"}\n"
"}\n"
"_exit:;\n"
"}\n"
"http_header (\'Content-type: text/html; charset=\"UTF-8\"\\r\\n\');\n"
"if (not isnull (xslt_file))\n"
"{\n"
"_xml_sheet := (select blob_to_string (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH = xslt_file);\n"
"if (not isnull (_xml_sheet))\n"
"{\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xtree_doc (_xml_sheet));\n"
"_html := xslt (\'http://local.virt/custom_dir_output\', _xml);\n"
"http_value (_html);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_b_opt := null;\n"
"if (exists (select 1 from DB.DBA.HTTP_PATH where HP_LPATH = http_map_get (\'domain\') and HP_PPATH = http_map_get (\'mounted\')))\n"
"{\n"
"select deserialize(HP_OPTIONS) into _b_opt\n"
"from DB.DBA.HTTP_PATH\n"
"where HP_LPATH = http_map_get (\'domain\') and HP_PPATH = http_map_get (\'mounted\');\n"
"\n"
"if (_b_opt is not NULL)\n"
"_b_opt := get_keyword (\'browse_sheet\', _b_opt, \'\');\n"
"}\n"
"if (_b_opt <> \'\')\n"
"{\n"
"select blob_to_string (RES_CONTENT) into _xml_sheet from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _b_opt;\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xml_tree_doc (_xml_sheet));\n"
"_html := cast (xslt (\'http://local.virt/custom_dir_output\', _xml) as varchar);\n"
"}\n"
"else\n"
"{\n"
"_html := cast (xslt (\'http://local.virt/dir_output\', _xml) as varchar);\n"
"}\n"
"http (_html);\n"
"}\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:6172\n"
;

static const char *proc87 = 
"#line 6438 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.DAV_ATOM_ENTRY (\n"
"in id any,\n"
"in what char (1),\n"
"in isFullXml integer := 1)\n"
"{\n"
"\n"
"declare entry any;\n"
"\n"
"entry := DAV_DIR_SINGLE_INT (id, what, \'fake\', null, null, http_dav_uid (), 0);\n"
"if (isFullXml)\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"UTF-8\"\\r\\n\');\n"
"http (       \'<?xml version=\"1.0\" ?>\');\n"
"}\n"
"http (         \'<entry xmlns=\"http://www.w3.org/2005/Atom\">\');\n"
"http (sprintf (\'  <title>%V</title>\', entry[10]));\n"
"http (sprintf (\'  <link rel=\"edit\" href=\"%V\" />\', WS.WS.DAV_HOST () || entry[0]));\n"
"http (sprintf (\'  <id>%V</id>\', entry[0]));\n"
"http (sprintf (\'  <category term=\"%V\" />\', case when what = \'R\' then \'resource\' else \'collection\' end));\n"
"http (sprintf (\'  <author><name>%V</name></author>\', (select U_NAME from DB.DBA.SYS_USERS where U_ID = entry[7])));\n"
"http (sprintf (\'  <updated>%V</updated>\', soap_print_box (entry[3], \'\', 0)));\n"
"http (sprintf (\'  <published>%V</published>\', soap_print_box (entry[8], \'\', 0)));\n"
"http (         \'</entry>\');\n"
"}\n"
"--src dav.sql:6436\n"
;

static const char *proc88 = 
"#line 6464 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.DAV_ATOM_ENTRY_LIST (\n"
"in id any,\n"
"in what char (1))\n"
"{\n"
"\n"
"declare N integer;\n"
"declare path varchar;\n"
"declare entry, dir any;\n"
"\n"
"http_header (\'Content-type: text/xml; charset=\"UTF-8\"\\r\\n\');\n"
"entry := DAV_DIR_SINGLE_INT (id, what, \'fake\', null, null, http_dav_uid (), 0);\n"
"http (         \'<?xml version=\"1.0\" ?>\');\n"
"http (         \'<feed xmlns=\"http://www.w3.org/2005/Atom\">\');\n"
"http (sprintf (\'  <title>%V</title>\', entry[10]));\n"
"http (sprintf (\'  <link rel=\"edit\" href=\"%V\" />\', WS.WS.DAV_HOST () || entry[0]));\n"
"http (sprintf (\'  <id>%V</id>\', entry[0]));\n"
"http (sprintf (\'  <category term=\"%V\" />\', case when what = \'R\' then \'resource\' else \'collection\' end));\n"
"http (sprintf (\'  <author><name>%V</name></author>\', (select U_NAME from DB.DBA.SYS_USERS where U_ID = entry[7])));\n"
"http (sprintf (\'  <updated>%V</updated>\', soap_print_box (entry[3], \'\', 0)));\n"
"http (sprintf (\'  <published>%V</published>\', soap_print_box (entry[8], \'\', 0)));\n"
"\n"
"dir := DB.DBA.DAV_DIR_LIST_INT (DB.DBA.DAV_SEARCH_PATH (id, what), 0, \'%\', null, null, http_dav_uid ());\n"
"for (N := 0; N < length (dir); N := N + 1)\n"
"{\n"
"WS.WS.DAV_ATOM_ENTRY (dir [N][4], dir [N][1], 0);\n"
"}\n"
"\n"
"http (         \'</feed>\');\n"
"}\n"
"--src dav.sql:6462\n"
;

static const char *proc89 = 
"#line 6515 \"[executable]/dav.sql\"\n"
"create function\n"
"WS.WS.DAV_CHECK_ASMX (in path any, out patched_path any) returns integer\n"
"{\n"
"declare temp varchar;\n"
"temp := http_path (path);\n"
"\n"
"if ((strstr (temp, \'.asmx\') is not null) and __proc_exists (\'WS.WS.__http_handler_aspx\', 1))\n"
"{\n"
"declare ret any;\n"
"declare idx integer;\n"
"idx := 0;\n"
"ret := vector ();\n"
"while (idx < length (path))\n"
"{\n"
"ret := vector_concat (ret, vector (path[idx]));\n"
"if (strstr (path[idx], \'.asmx\') is not null)\n"
"{\n"
"patched_path := ret;\n"
"return 1;\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"patched_path := path;\n"
"return 0;\n"
"}\n"
"--src dav.sql:6513\n"
;

static const char *proc90 = 
"#line 6544 \"[executable]/dav.sql\"\n"
"create procedure\n"
"WS.WS.DAV_REMOVE_ASMX (in path any)\n"
"{\n"
"if ((strstr (path, \'.asmx\') is not null) and __proc_exists (\'WS.WS.__http_handler_aspx\', 1))\n"
"{\n"
"declare ret any;\n"
"ret := \"LEFT\" (path, strstr (path, \'.asmx\') + 5);\n"
"return ret;\n"
"}\n"
"else\n"
"return path;\n"
"}\n"
"--src dav.sql:6542\n"
;

static const char *proc91 = 
"#line 6559 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.XMLSQL_TO_STRSES (\n"
"in _q varchar,\n"
"in _root varchar,\n"
"in _sch varchar,\n"
"in _dtd varchar,\n"
"in _comments varchar,\n"
"inout ses any,\n"
"in enc varchar := null )\n"
"{\n"
"\n"
"if (length (_sch))\n"
"_dtd := \'\';\n"
"\n"
"\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', coalesce (enc, current_charset())), ses);\n"
"\n"
"if (_comments <> \'\')\n"
"http (replace (sprintf (\'<!\\-\\- %s \\-\\->\\n\', _comments), \'\\-\', \'-\'), ses);\n"
"\n"
"\n"
"if (_dtd <> \'\' and _root <> \'\')\n"
"{\n"
"if (_dtd = \'on\')\n"
"http (concat (\'<!DOCTYPE \' , _root, \' [\', xml_auto_dtd (_q, _root), \']>\\n\'), ses);\n"
"else\n"
"http (concat (\'<!DOCTYPE \' , _root, \' SYSTEM \'\'\', _dtd, \'\'\'>\\n\'), ses);\n"
"}\n"
"\n"
"\n"
"if (_root <> \'\' and _sch = \'\')\n"
"http (concat (\'<\', _root, \'>\\n\'), ses);\n"
"else if (_root <> \'\' and _sch <> \'\')\n"
"http (concat (\'<\', _root,\n"
"\' xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"\',\n"
"_sch, \'\">\\n\'), ses);\n"
"\n"
"\n"
"xml_auto (_q, vector (), ses);\n"
"\n"
"\n"
"if (_root <> \'\')\n"
"http (concat(\'</\', _root, \'>\\n\'), ses);\n"
"\n"
"return;\n"
"}\n"
"--src dav.sql:6557\n"
;

static const char *proc92 = 
"#line 6606 \"[executable]/dav.sql\"\n"
"create procedure WS.WS.\"TRACE\" (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"http_header (\'Content-Type: message/http\\r\\n\');\n"
"http_flush (1);\n"
"foreach (varchar l in lines) do\n"
"{\n"
"http (l);\n"
"}\n"
"}\n"
"--src dav.sql:6604\n"
;

static const char *proc93 = 
"#line 6617 \"[executable]/dav.sql\"\n"
"create procedure DAV_SET_HTTP_REQUEST_STATUS (\n"
"in rc integer)\n"
"{\n"
"declare st any;\n"
"st := DAV_SET_HTTP_REQUEST_STATUS_DESCRIPTION (rc);\n"
"if (length (st))\n"
"http_request_status (st);\n"
"}\n"
"--src dav.sql:6615\n"
;

static const char *proc94 = 
"#line 6627 \"[executable]/dav.sql\"\n"
"create procedure DAV_SET_HTTP_REQUEST_STATUS_DESCRIPTION (\n"
"in rc integer)\n"
"{\n"
"if (DAV_HIDE_ERROR (rc) is not null)\n"
"return \'HTTP/1.1 200 OK\';\n"
"\n"
"if (rc = -1)\n"
"return \'HTTP/1.1 409 Invalid path\';\n"
"\n"
"if (rc = -2)\n"
"return \'HTTP/1.1 409 Conflict: the destination (path) is not valid\';\n"
"\n"
"if (rc = -3)\n"
"return \'HTTP/1.1 412 Precondition Failed: overwrite flag is not set and destination exists\';\n"
"\n"
"if (rc = -8)\n"
"return \'HTTP/1.1 423 Locked\';\n"
"\n"
"if (rc = -12)\n"
"return \'HTTP/1.1 403 Forbidden: authentication has failed\';\n"
"\n"
"if (rc = -13)\n"
"return \'HTTP/1.1 403 Forbidden: insufficient user permissions\';\n"
"\n"
"if (rc = -25)\n"
"return \'HTTP/1.1 409 Conflict: can not create collection if a resource with same name exists\';\n"
"\n"
"if (rc = -26)\n"
"return \'HTTP/1.1 409 Conflict: can not create resource if a collection with same name exists\';\n"
"\n"
"if (rc = -24)\n"
"return \'\';\n"
"\n"
"if (rc = -28)\n"
"return \'HTTP/1.1 599 Internal server error\';\n"
"\n"
"if (rc = -29)\n"
"return \'HTTP/1.1 599 Internal server error\';\n"
"\n"
"if (rc = -41)\n"
"return \'HTTP/1.1 507 Insufficient storage\';\n"
"\n"
"if (rc = -44)\n"
"return \'HTTP/1.1 500 Internal server error\';\n"
"\n"
"return \'HTTP/1.1 405 Method Not Allowed\';\n"
"}\n"
"--src dav.sql:6625\n"
;

static const char *proc95 = 
"#line 6676 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.DAV_SET_AUTHENTICATE_HTTP_STATUS (\n"
"in rc integer)\n"
"{\n"
"if (rc in (-12, -13))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (403);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (401);\n"
"}\n"
"return;\n"
"}\n"
"--src dav.sql:6674\n"
;

static const char *proc96 = 
"#line 6691 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.HTTP_DEFAULT_ERROR_PAGE (in status varchar, in title varchar, in head varchar, in state varchar, in msg varchar)\n"
"{\n"
"if (status is not null)\n"
"http_request_status (status);\n"
"http (sprintf (\n"
"\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\\n\' ||\n"
"\'<html>\\n\' ||\n"
"\'  <head>\\n\' ||\n"
"\'    <title>%V</title>\\n\' ||\n"
"\'  </head>\\n\' ||\n"
"\'  <body>\\n\',\n"
"coalesce (title, status, head, \'Error \' || state) ) );\n"
"if (head is not null or status is not null)\n"
"{\n"
"http (sprintf (\'    <h1>%V</h1>\\n\',\n"
"coalesce (head, status) ) );\n"
"}\n"
"http (sprintf (\'    <h3>%V</h3>\\n<xmp>\', \'Error \' || state));\n"
"http (msg);\n"
"http (\'</xmp></body></html>\');\n"
"}\n"
"--src dav.sql:6689\n"
;

static const char *proc97 = 
"#line 6714 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.DAV_SET_HTTP_STATUS (\n"
"in status any,\n"
"in title any := null,\n"
"in message_head varchar := null,\n"
"in message varchar := null,\n"
"in rewrite integer := 0)\n"
"{\n"
"if (rewrite)\n"
"http_rewrite ();\n"
"\n"
"if (isinteger (status))\n"
"{\n"
"if (status = 200)\n"
"{\n"
"http_request_status (\'HTTP/1.1 200 OK\');\n"
"}\n"
"if (status = 201)\n"
"{\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"}\n"
"else if (status = 204)\n"
"{\n"
"http_request_status (\'HTTP/1.1 204 No Content\');\n"
"}\n"
"else if (status = 400)\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad Request\');\n"
"}\n"
"else if (status = 401)\n"
"{\n"
"http_request_status (\'HTTP/1.1 401 Unauthorized\');\n"
"if (isnull (title))\n"
"title := \'401 Unauthorized\';\n"
"\n"
"if (isnull (message_head))\n"
"message_head := \'Unauthorized\';\n"
"\n"
"if (isnull (message))\n"
"message := \'Access to page is forbidden\';\n"
"}\n"
"else if (status = 403)\n"
"{\n"
"http_request_status (\'HTTP/1.1 403 Forbidden\');\n"
"if (isnull (title))\n"
"title := \'403 Forbidden\';\n"
"\n"
"if (isnull (message_head))\n"
"message_head := \'Forbidden\';\n"
"\n"
"if (isnull (message))\n"
"message := \'Resource is forbidden.\';\n"
"}\n"
"else if (status = 404)\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"if (isnull (title))\n"
"title := \'404 Not Found\';\n"
"\n"
"if (isnull (message_head))\n"
"message_head := sprintf (\'Not found\', http_path ());\n"
"\n"
"if (isnull (message))\n"
"message := sprintf (\'Resource %V not found.\', http_path ());\n"
"}\n"
"else if (status = 405)\n"
"{\n"
"http_request_status (\'HTTP/1.1 405 Method Not Allowed\');\n"
"}\n"
"else if (status = 406)\n"
"{\n"
"http_request_status (\'HTTP/1.1 406 Not Acceptable\');\n"
"}\n"
"else if (status = 409)\n"
"{\n"
"http_request_status (\'HTTP/1.1 409 Conflict\');\n"
"}\n"
"else if (status = 412)\n"
"{\n"
"http_request_status (\'HTTP/1.1 412 Precondition Failed\');\n"
"}\n"
"else if (status = 415)\n"
"{\n"
"http_request_status (\'HTTP/1.1 415 Unsupported Media Type\');\n"
"}\n"
"else if (status = 423)\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"}\n"
"else if (status = 500)\n"
"{\n"
"http_request_status (\'HTTP/1.1 500 Internal Server Error\');\n"
"}\n"
"else if (status = 501)\n"
"{\n"
"http_request_status (\'HTTP/1.1 501 Not Implemented\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http_request_status (status);\n"
"}\n"
"\n"
"if (not isnull (title) and not isnull (message_head) and not isnull (message))\n"
"{\n"
"http (sprintf (\n"
"\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\\n\' ||\n"
"\'<html>\\n\' ||\n"
"\'  <head>\\n\' ||\n"
"\'    <title>%s</title>\\n\' ||\n"
"\'  </head>\\n\' ||\n"
"\'  <body>\\n\' ||\n"
"\'    <h1>%s</h1>\\n\' ||\n"
"\'    %s\\n\' ||\n"
"\'  </body>\\n\' ||\n"
"\'</html>\',\n"
"coalesce (title, \'\'),\n"
"coalesce (message_head, \'\'),\n"
"coalesce (message, \'\')\n"
"));\n"
"}\n"
"}\n"
"--src dav.sql:6712\n"
;

static const char *proc98 = 
"#line 6837 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_ENABLED (\n"
"in _col_id any)\n"
"{\n"
"\n"
"\n"
"if (not DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (_col_id)))\n"
"return 0;\n"
"\n"
"_col_id := DB.DBA.DAV_DET_DETCOL_ID (_col_id);\n"
"while (_col_id > 0)\n"
"{\n"
"if (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT (_col_id, \'C\', \'LDP\', 0)) is not null)\n"
"return 1;\n"
"\n"
"_col_id := coalesce ((select COL_PARENT from WS.WS.SYS_DAV_COL where COL_ID = _col_id), -1);\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src dav.sql:6835\n"
;

static const char *proc99 = 
"#line 6858 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_CREATE_COL (\n"
"in path any,\n"
"in id_parent any := null)\n"
"{\n"
"\n"
"declare graph any;\n"
"\n"
"\n"
"if (DB.DBA.DAV_MAC_METAFILE (path))\n"
"return;\n"
"\n"
"if (isnull (id_parent))\n"
"id_parent := DB.DBA.DAV_SEARCH_ID (concat (\'/\', trim (path, \'/\'), \'/\'), \'P\');\n"
"\n"
"if (not DB.DBA.LDP_ENABLED (id_parent))\n"
"return;\n"
"\n"
"graph := WS.WS.DAV_IRI (path);\n"
"set_user_id (\'dba\');\n"
"TTLP (sprintf (\'<%s> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/ns/ldp#BasicContainer>, <http://www.w3.org/ns/ldp#Container> .\', graph), graph, graph);\n"
"DB.DBA.LDP_CREATE (path, id_parent);\n"
"}\n"
"--src dav.sql:6856\n"
;

static const char *proc100 = 
"#line 6882 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_CREATE_RES (\n"
"in path any,\n"
"in id_parent any := null)\n"
"{\n"
"\n"
"declare graph any;\n"
"\n"
"\n"
"if (DB.DBA.DAV_MAC_METAFILE (path))\n"
"return;\n"
"\n"
"if (isnull (id_parent))\n"
"id_parent := DB.DBA.DAV_SEARCH_ID (concat (\'/\', trim (path, \'/\'), \'/\'), \'P\');\n"
"\n"
"if (not DB.DBA.LDP_ENABLED (id_parent))\n"
"return;\n"
"\n"
"graph := WS.WS.DAV_IRI (path);\n"
"set_user_id (\'dba\');\n"
"TTLP (sprintf (\'<%s> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/ns/ldp#Resource>, <http://www.w3.org/2000/01/rdf-schema#Resource> .\', graph), graph, graph);\n"
"DB.DBA.LDP_CREATE (path, id_parent);\n"
"}\n"
"--src dav.sql:6880\n"
;

static const char *proc101 = 
"#line 6906 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_CREATE (\n"
"in path any,\n"
"in id_parent any := null)\n"
"{\n"
"\n"
"declare path_parent, graph, graph_parent varchar;\n"
"\n"
"\n"
"if (DB.DBA.DAV_MAC_METAFILE (path))\n"
"return;\n"
"\n"
"if (isnull (id_parent))\n"
"id_parent := DB.DBA.DAV_SEARCH_ID (concat (\'/\', trim (path, \'/\'), \'/\'), \'P\');\n"
"\n"
"if (not isnull (DB.DBA.DAV_HIDE_ERROR (id_parent)) and DB.DBA.LDP_ENABLED (id_parent))\n"
"{\n"
"path_parent := DB.DBA.DAV_SEARCH_PATH (id_parent, \'C\');\n"
"graph_parent := WS.WS.DAV_IRI (path_parent);\n"
"graph := WS.WS.DAV_IRI (path);\n"
"set_user_id (\'dba\');\n"
"TTLP (sprintf (\'<%s> <http://www.w3.org/ns/ldp#contains> <%s> .\', graph_parent, graph), graph_parent, graph_parent);\n"
"}\n"
"}\n"
"--src dav.sql:6904\n"
;

static const char *proc102 = 
"#line 6931 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_DELETE (\n"
"in path any,\n"
"in allData integer := 0)\n"
"{\n"
"\n"
"declare graph varchar;\n"
"declare graphIdn any;\n"
"\n"
"\n"
"if (DB.DBA.DAV_MAC_METAFILE (path))\n"
"return;\n"
"\n"
"graph := WS.WS.DAV_IRI (path);\n"
"graphIdn := __i2idn (graph);\n"
"if (allData)\n"
"{\n"
"SPARQL clear graph ?:graph;\n"
"}\n"
"else\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = graphIdn and S = graphIdn and P = __i2idn (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\') and O = __i2idn (\'http://www.w3.org/ns/ldp#Resource\');\n"
"delete from DB.DBA.RDF_QUAD where G = graphIdn and S = graphIdn and P = __i2idn (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\') and O = __i2idn (\'http://www.w3.org/2000/01/rdf-schema#Resource\');\n"
"}\n"
"delete from DB.DBA.RDF_QUAD where P = __i2idn (\'http://www.w3.org/ns/ldp#contains\') and O = graphIdn;\n"
"}\n"
"--src dav.sql:6929\n"
;

static const char *proc103 = 
"#line 6958 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_RENAME (\n"
"in what varchar,\n"
"in oldPath any,\n"
"in newPath any,\n"
"in oldLDP integer,\n"
"in newLDP integer)\n"
"{\n"
"\n"
"declare oldGraph, newGraph, mimeType varchar;\n"
"\n"
"if (oldPath = newPath)\n"
"return;\n"
"\n"
"if ((oldLDP = 0) and (newLDP = 0))\n"
"return;\n"
"\n"
"oldGraph := WS.WS.DAV_IRI (oldPath);\n"
"newGraph := WS.WS.DAV_IRI (newPath);\n"
"if ((what = \'R\') and newLDP)\n"
"mimeType := (select RES_TYPE from WS.WS.SYS_DAV_RES where RES_FULL_PATH = newPath);\n"
"\n"
"if ((oldLDP = 0) and (newLDP = 1))\n"
"{\n"
"if (what = \'C\')\n"
"{\n"
"DB.DBA.LDP_CREATE_COL (newPath);\n"
"DB.DBA.LDP_REFRESH (newPath);\n"
"}\n"
"else if (what = \'R\')\n"
"{\n"
"DB.DBA.LDP_RENAME_GRAPH (oldGraph, newGraph);\n"
"if (mimeType in (\'text/turtle\', \'application/ld+json\'))\n"
"DB.DBA.LDP_CREATE_RES (newPath);\n"
"}\n"
"}\n"
"else if ((oldLDP = 1) and (newLDP = 0))\n"
"{\n"
"if (what = \'C\')\n"
"{\n"
"DB.DBA.LDP_DELETE (oldPath, 1);\n"
"DB.DBA.LDP_DELETE_GRAPHS (oldPath, newPath);\n"
"}\n"
"else if (what = \'R\')\n"
"{\n"
"DB.DBA.LDP_DELETE (oldPath);\n"
"DB.DBA.LDP_RENAME_GRAPH (oldGraph, newGraph);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (what = \'C\')\n"
"{\n"
"DB.DBA.LDP_DELETE (oldPath, 1);\n"
"DB.DBA.LDP_DELETE_GRAPHS (oldPath, newPath);\n"
"DB.DBA.LDP_CREATE_COL (newPath);\n"
"DB.DBA.LDP_REFRESH (newPath);\n"
"}\n"
"else if (what = \'R\')\n"
"{\n"
"DB.DBA.LDP_DELETE (oldPath);\n"
"DB.DBA.LDP_RENAME_GRAPH (oldGraph, newGraph);\n"
"if (mimeType in (\'text/turtle\', \'application/ld+json\'))\n"
"DB.DBA.LDP_CREATE_RES (newPath);\n"
"}\n"
"}\n"
"}\n"
"--src dav.sql:6956\n"
;

static const char *proc104 = 
"#line 7026 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_RENAME_GRAPH (\n"
"in oldGraph any,\n"
"in newGraph any)\n"
"{\n"
"\n"
"\n"
"SPARQL clear graph ?:newGraph;\n"
"update DB.DBA.RDF_QUAD\n"
"set G = __i2idn (newGraph)\n"
"where G = __i2idn (oldGraph);\n"
"}\n"
"--src dav.sql:7024\n"
;

static const char *proc105 = 
"#line 7039 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_DELETE_GRAPHS (\n"
"in oldPath any,\n"
"in newPath any,\n"
"in id integer := null)\n"
"{\n"
"\n"
"declare path varchar;\n"
"\n"
"if (isnull (id))\n"
"{\n"
"id := DB.DBA.DAV_SEARCH_ID (newPath, \'C\');\n"
"if (isnull (DB.DBA.DAV_HIDE_ERROR (id)))\n"
"return;\n"
"}\n"
"for (select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = id) do\n"
"{\n"
"path := oldPath || subseq (RES_FULL_PATH, length (newPath));\n"
"DB.DBA.LDP_DELETE (path);\n"
"}\n"
"for (select COL_ID from WS.WS.SYS_DAV_COL where COL_PARENT = id) do\n"
"{\n"
"path := oldPath || subseq (DB.DBA.DAV_SEARCH_PATH (COL_ID), length (newPath));\n"
"DB.DBA.LDP_DELETE (path, 1);\n"
"DB.DBA.LDP_DELETE_GRAPHS (oldPath, newPath, COL_ID);\n"
"}\n"
"}\n"
"--src dav.sql:7037\n"
;

static const char *proc106 = 
"#line 7067 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_REFRESH (\n"
"in path varchar,\n"
"in enabled integer := 0)\n"
"{\n"
"\n"
"declare id integer;\n"
"declare uri, ruri any;\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (path, \'C\');\n"
"if (isnull (DB.DBA.DAV_HIDE_ERROR (id)))\n"
"return;\n"
"\n"
"if (not enabled)\n"
"enabled := DB.DBA.LDP_ENABLED (id);\n"
"\n"
"for (select COL_NAME as _COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = id) do\n"
"{\n"
"uri := WS.WS.DAV_IRI (path);\n"
"if (enabled)\n"
"{\n"
"TTLP (\'@prefix ldp: <http://www.w3.org/ns/ldp#> .  <> a ldp:BasicContainer, ldp:Container .\', uri, uri);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.LDP_DELETE (path, 1);\n"
"}\n"
"for (select RES_CONTENT, RES_TYPE, RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = id) do\n"
"{\n"
"ruri := WS.WS.DAV_IRI (RES_FULL_PATH);\n"
"if (enabled and (RES_TYPE in (\'text/turtle\', \'application/ld+json\')))\n"
"{\n"
"TTLP (sprintf (\'<%s> <http://www.w3.org/ns/ldp#contains> <%s> .\', uri, ruri), uri, uri);\n"
"TTLP (sprintf (\'<%s> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/ns/ldp#Resource>, <http://www.w3.org/2000/01/rdf-schema#Resource> .\', ruri), ruri, ruri);\n"
"{\n"
"declare continue handler for sqlstate \'*\';\n"
"TTLP (cast (RES_CONTENT as varchar), ruri, ruri, 255);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.LDP_DELETE (RES_FULL_PATH);\n"
"}\n"
"}\n"
"for (select COL_NAME from WS.WS.SYS_DAV_COL where COL_PARENT = id and COL_DET is null) do\n"
"{\n"
"ruri := WS.WS.DAV_IRI (path || COL_NAME || \'/\');\n"
"TTLP (sprintf (\'<%s> <http://www.w3.org/ns/ldp#contains> <%s> .\', uri, ruri), uri, uri);\n"
"}\n"
"}\n"
"\n"
"for (select COL_NAME from WS.WS.SYS_DAV_COL where COL_PARENT = id and COL_DET is null) do\n"
"{\n"
"DB.DBA.LDP_REFRESH (path || COL_NAME || \'/\', enabled);\n"
"}\n"
"}\n"
"--src dav.sql:7065\n"
;

static const char *proc107 = 
"#line 7124 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.LDP_ACCEPT_PARAM (\n"
"in accept_full varchar,\n"
"in accept_mime varchar,\n"
"in param varchar)\n"
"{\n"
"declare retValue any;\n"
"declare arr, arr2, arr3 any;\n"
"declare i, l, j, k integer;\n"
"\n"
"retValue := null;\n"
"arr := split_and_decode (accept_full, 0, \'\\0\\0,\');\n"
"l := length (arr);\n"
"for (i := 0; i < l; i := i + 1)\n"
"{\n"
"arr2 := split_and_decode (trim (arr[i]), 0, \'\\0\\0;\');\n"
"k := length (arr2);\n"
"if ((k > 0) or (accept_mime = trim (arr2[0])))\n"
"{\n"
"for (j := 1; j < k; j := j + 1)\n"
"{\n"
"arr3 := split_and_decode (trim (arr2[j]), 0, \'\\0\\0=\');\n"
"if ((length (arr3) = 2) and (param = trim (arr3[0])))\n"
"{\n"
"retValue := trim (arr3[1]);\n"
"goto _break;\n"
"}\n"
"}\n"
"goto _break;\n"
"}\n"
"}\n"
"_break:;\n"
"return retValue;\n"
"}\n"
"--src dav.sql:7122\n"
;

static const char *proc108 = 
"#line 7159 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.DAV_HREF_URL (\n"
"in href varchar)\n"
"{\n"
"href := replace (href, \' \', \'%20\');\n"
"\n"
"return charset_recode (href, \'UTF-8\', \'_WIDE_\');\n"
"\n"
"}\n"
"--src dav.sql:7157\n"
;

static const char *proc109 = 
"#line 7170 \"[executable]/dav.sql\"\n"
"create procedure DB.DBA.DAV_MAC_METAFILE (\n"
"in path varchar)\n"
"{\n"
"return case when (DB.DBA.DAV_DET_PATH_NAME (path) like \'._%\') then 1 else 0 end;\n"
"}\n"
"--src dav.sql:7168\n"
;

/* dav_api.sql */

static const char *proc110 = 
"#line 49 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_VERSION ()\n"
"{\n"
"return \'1.0\';\n"
"}\n"
"--src dav_api.sql:47\n"
;

static const char *proc111 = 
"#line 55 \"[executable]/dav_api.sql\"\n"
"create function DAV_PERROR (in x any)\n"
"{\n"
"declare errlist any;\n"
"if (not isinteger (x))\n"
"return NULL;\n"
"if (x >= 0)\n"
"return NULL;\n"
"if (x = -44)\n"
"return sprintf (\'(%d) %s\', x, connection_get (\'__sql_message\'));\n"
"if (x < -44)\n"
"return sprintf (\'(%d) Unspecified error\', x);\n"
"errlist := vector (\n"
"\'(-01) The path (target of operation) is not valid\',\n"
"\'(-02) The destination (path) is not valid\',\n"
"\'(-03) Overwrite flag is not set and destination exists\',\n"
"\'(-04) The target is resource, but source is collection (in copy move operations)\',\n"
"\'(-05) Permissions are not valid\',\n"
"\'(-06) uid is not valid\',\n"
"\'(-07) gid is not valid\',\n"
"\'(-08) Target is locked\',\n"
"\'(-09) Destination is locked\',\n"
"\'(-10) Property name is reserved (protected or private)\',\n"
"\'(-11) Property does not exist\',\n"
"\'(-12) Authentication failed\',\n"
"\'(-13) Operation is forbidden (the authenticated user does not have permissions for the action)\',\n"
"\'(-14) The target type is not valid\',\n"
"\'(-15) The umask is not valid\',\n"
"\'(-16) The property already exists\',\n"
"\'(-17) Invalid property value\',\n"
"\'(-18) no such user\',\n"
"\'(-19) no home directory\',\n"
"\'(-20) The operation is not supported by a DET\',\n"
"\'(-21) DET can not restore the full DAV path by id\',\n"
"\'(-22) Corrupted id\',\n"
"\'(-23) The id does not correspond to any resource that exists now\',\n"
"\'(-24) Authentication failed and requested\',\n"
"\'(-25) Can not create collection if a resource with same name exists\',\n"
"\'(-26) Can not create resource if a collection with same name exists\',\n"
"\'(-27) Target is not locked\',\n"
"\'(-28) Unqualified error\',\n"
"\'(-29) Transaction deadlock at the end of resource upload, after reading from session\',\n"
"\'(-30) The target is nested into source\',\n"
"\'(-31) Built-in system account can not be changed\',\n"
"\'(-32) Property that can control execution of SQL statements can be changed only by SQL-enabled user\',\n"
"\'(-33) The DET resource or collection ID is rejected, the operation supports only plain DAV\',\n"
"\'(-34) The path (target of operation) is not valid: no parent collection exists\',\n"
"\'(-35) Failed dependency on lock operation\',\n"
"\'(-36) Appropriate property virt:Versioning-* has not been set\',\n"
"\'(-37) Operation is not supported for resource of this type\',\n"
"\'(-38) Semantics is violated\',\n"
"\'(-39) Recursive operation on CatFilter is impossible\',\n"
"\'(-40) The path (target of operation) does not match naming convention that is used by DET\',\n"
"\'(-41) The size of DAV collection subtree is out of quota\',\n"
"\'(-42) The resource is unavailable because resource owner is disabled\',\n"
"\'(-43) Access to a home DAV collection of a disabled account is blocked\'\n"
");\n"
"return errlist [-(x+1)];\n"
"}\n"
"--src dav_api.sql:53\n"
;

static const char *proc112 = 
"#line 116 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_ADD_USER_INT (\n"
"in uid varchar,\n"
"in pwd varchar,\n"
"in gid any,\n"
"in perms varchar,\n"
"in disable integer,\n"
"in home varchar,\n"
"in full_name varchar,\n"
"in email varchar)\n"
"{\n"
"declare id, gd, rc integer;\n"
"\n"
"id := (select U_ID from WS.WS.SYS_DAV_USER where U_NAME = uid);\n"
"if (isnull (id))\n"
"{\n"
"USER_CREATE (uid, pwd, vector (\'SQL_ENABLE\', 0, \'DAV_ENABLE\', 1, \'PRIMARY_GROUP\', gid,\n"
"\'HOME\', home, \'E-MAIL\', email, \'FULL_NAME\', full_name, \'PERMISSIONS\', perms, \'DISABLED\', disable));\n"
"}\n"
"else\n"
"{\n"
"if (id < 100)\n"
"return -31;\n"
"\n"
"if (isstring (gid))\n"
"gd := (select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid);\n"
"else if (isinteger (gid) and exists (select 1 from WS.WS.SYS_DAV_GROUP where G_ID = gid))\n"
"gd := gid;\n"
"else\n"
"gd := NULL;\n"
"\n"
"if (gid = http_nogroup_gid ())\n"
"return -31;\n"
"\n"
"if (id is not null)\n"
"{\n"
"update WS.WS.SYS_DAV_USER\n"
"set U_GROUP = gd,\n"
"U_DEF_PERMS = perms,\n"
"U_FULL_NAME = full_name,\n"
"U_PWD = pwd_magic_calc (uid, pwd),\n"
"U_E_MAIL = email,\n"
"U_ACCOUNT_DISABLED = disable,\n"
"U_HOME = home\n"
"where U_NAME = uid;\n"
"}\n"
"}\n"
"return id;\n"
"}\n"
"--src dav_api.sql:114\n"
;

static const char *proc113 = 
"#line 167 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_ADD_USER (\n"
"in uid varchar,\n"
"in pwd varchar,\n"
"in gid varchar,\n"
"in perms varchar,\n"
"in disable integer,\n"
"in home varchar,\n"
"in full_name varchar,\n"
"in email varchar,\n"
"in auth_uname varchar := NULL,\n"
"in auth_pwd varchar := NULL)\n"
"{\n"
"declare rc, make_dir integer;\n"
"\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"\n"
"make_dir := 0;\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_USER where U_NAME = uid))\n"
"make_dir := 1;\n"
"\n"
"rc := DAV_ADD_USER_INT (uid, pwd, gid, perms, disable, home, full_name, email);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"if (make_dir)\n"
"{\n"
"if (isstring (home))\n"
"{\n"
"if (0 > (rc := DAV_COL_CREATE (home, perms, uid, gid, auth_uname, auth_pwd)))\n"
"{\n"
"rollback work;\n"
"return rc;\n"
"}\n"
"}\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:165\n"
;

static const char *proc114 = 
"#line 208 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_DELETE_USER (\n"
"in uid varchar,\n"
"in auth_uname varchar := NULL,\n"
"in auth_pwd varchar := NULL)\n"
"{\n"
"declare known_u_id integer;\n"
"\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"\n"
"known_u_id := (select U_ID from WS.WS.SYS_DAV_USER where U_NAME = uid);\n"
"if (known_u_id < 100)\n"
"return -31;\n"
"\n"
"delete from WS.WS.SYS_DAV_TAG where DT_U_ID = known_u_id;\n"
"delete from WS.WS.SYS_DAV_USER where U_NAME = uid;\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:206\n"
;

static const char *proc115 = 
"#line 229 \"[executable]/dav_api.sql\"\n"
" create function DAV_REGEXP_PATTERN_FOR_PERM () returns varchar {\n"
"return \'^[01][01][01][01][01][01][01][01][01]([NTR-]([NMR-])?)?\\044\';\n"
"}\n"
"--src dav_api.sql:227\n"
;

static const char *proc116 = 
"#line 234 \"[executable]/dav_api.sql\"\n"
"create function DAV_REGEXP_PATTERN_FOR_UNIX_PERM () returns varchar {\n"
"return \'^[r\\\\-][w\\\\-][x\\\\-][r\\\\-][w\\\\-][x\\\\-][r\\\\-][w\\\\-][x\\\\-]([NTR-]([NMR-])?)?\\044\';\n"
"}\n"
"--src dav_api.sql:232\n"
;

static const char *proc117 = 
"#line 240 \"[executable]/dav_api.sql\"\n"
" create function\n"
"DAV_PERM_D2U (in perms varchar)\n"
"{\n"
"declare res any;\n"
"declare i int;\n"
"res := perms;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_PERM (), res) is null)\n"
"signal (\'22023\', \'Not valid permissions string\');\n"
"res := \'rwxrwxrwx\' || upper (subseq (perms, 9));\n"
"while (i < 9)\n"
"{\n"
"if (perms[i] = ascii(\'0\'))\n"
"aset (res, i, ascii (\'-\'));\n"
"i := i + 1;\n"
"}\n"
"return lower(res);\n"
"}\n"
"--src dav_api.sql:238\n"
;

static const char *proc118 = 
"#line 260 \"[executable]/dav_api.sql\"\n"
" create procedure\n"
"DAV_PERM_U2D (in perms varchar)\n"
"{\n"
"declare res any;\n"
"declare i int;\n"
"res := perms;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_PERM (), res) is not null)\n"
"return perms;\n"
"res := perms;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_UNIX_PERM (), res) is null)\n"
"signal (\'22023\', \'Not valid permissions string\');\n"
"res := \'000000000\' || upper (subseq (perms, 9));\n"
"while (i < 9)\n"
"{\n"
"if (perms[i] <> ascii(\'-\'))\n"
"aset (res, i, ascii (\'1\'));\n"
"i := i + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src dav_api.sql:258\n"
;

static const char *proc119 = 
"#line 282 \"[executable]/dav_api.sql\"\n"
"create function DAV_CHECK_AUTH (\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in adm integer := 0) returns integer\n"
"{\n"
"declare pwd varchar;\n"
"declare uid integer;\n"
"whenever not found goto nf;\n"
"\n"
"if (adm)\n"
"{\n"
"select U_PWD, U_ID into pwd, uid from WS.WS.SYS_DAV_USER where U_ID = http_dav_uid () and U_NAME = auth_uname;\n"
"}\n"
"else\n"
"{\n"
"select U_PWD, U_ID into pwd, uid from WS.WS.SYS_DAV_USER where U_NAME = auth_uname;\n"
"}\n"
"\n"
"\n"
"if (isstring (pwd))\n"
"{\n"
"if ((pwd[0] = 0 and pwd_magic_calc (auth_uname, auth_pwd) = pwd) or (pwd[0] <> 0 and pwd = auth_pwd))\n"
"return uid;\n"
"}\n"
"\n"
"nf:\n"
"\n"
"if (auth_uname is null)\n"
"{\n"
"\n"
"return 1;\n"
"}\n"
"if (auth_uname = \'nobody\')\n"
"{\n"
"return http_nobody_uid();\n"
"}\n"
"if (ftp_anonymous_check (auth_uname))\n"
"{\n"
"return 1;\n"
"}\n"
"return -12;\n"
"}\n"
"--src dav_api.sql:280\n"
;

static const char *proc120 = 
"#line 327 \"[executable]/dav_api.sql\"\n"
" create function\n"
"DAV_HOME_DIR (in uid varchar) returns any\n"
"{\n"
"declare res any;\n"
"whenever not found goto er;\n"
"select U_HOME into res from WS.WS.SYS_DAV_USER where U_NAME = uid;\n"
"return coalesce (res, -19);\n"
"er:\n"
"return -18;\n"
"}\n"
"--src dav_api.sql:325\n"
;

static const char *proc121 = 
"#line 339 \"[executable]/dav_api.sql\"\n"
"create function DAV_HOME_DIR_CREATE (\n"
"in uid varchar) returns any\n"
"{\n"
"declare rc, rc2 integer;\n"
"declare path varchar;\n"
"declare exit handler for sqlstate \'*\' { return -1; };\n"
"\n"
"for (select U_ID as _uid, U_GROUP as _gid, U_DEF_PERMS as _permissions, U_HOME from SYS_USERS where U_NAME = uid) do\n"
"{\n"
"if (uid = \'nobody\')\n"
"{\n"
"_uid := http_dav_uid ();\n"
"_gid := http_admin_gid ();\n"
"_permissions := \'110100100R\';\n"
"}\n"
"path := \'/DAV/home/\';\n"
"rc := DAV_MAKE_DIR (path, http_dav_uid (), http_admin_gid (), \'110100100R\');\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"\n"
"path := path || uid || \'/\';\n"
"rc := DAV_MAKE_DIR (path, _uid, _gid, _permissions);\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"\n"
"path := path || \'rdf_sink/\';\n"
"rc2 := DAV_MAKE_DIR (path, _uid, _gid, _permissions);\n"
"if (isnull (DAV_HIDE_ERROR (rc2)))\n"
"{\n"
"rc := rc2;\n"
"goto _end;\n"
"}\n"
"rc2 := DB.DBA.DAV_DET_RDF_PARAMS_SET_INT (\'rdfSink\', rc2, vector (\'graph\', \'urn:dav:\' || replace (subseq (rtrim (path, \'/\'), 5), \'/\', \':\'), \'sponger\', \'on\'));\n"
"if (isnull (DAV_HIDE_ERROR (rc2)))\n"
"{\n"
"rc := rc2;\n"
"goto _end;\n"
"}\n"
"}\n"
"_end:;\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:337\n"
;

static const char *proc122 = 
"#line 383 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_ADD_GROUP_INT (\n"
"in gid varchar)\n"
"{\n"
"declare gd integer;\n"
"\n"
"gd := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid), 0);\n"
"if (not gd)\n"
"gd := USER_ROLE_CREATE (gid, 1);\n"
"\n"
"return gd;\n"
"}\n"
"--src dav_api.sql:381\n"
;

static const char *proc123 = 
"#line 397 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_ADD_GROUP (\n"
"in gid varchar,\n"
"in auth_uname varchar := NULL,\n"
"in auth_pwd varchar := NULL)\n"
"{\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"\n"
"return DAV_ADD_GROUP_INT (gid);\n"
"}\n"
"--src dav_api.sql:395\n"
;

static const char *proc124 = 
"#line 410 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_DELETE_GROUP (\n"
"in gid varchar,\n"
"in auth_uname varchar := NULL,\n"
"in auth_pwd varchar := NULL)\n"
"{\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"\n"
"if ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid) < 100)\n"
"return -31;\n"
"\n"
"delete from WS.WS.SYS_DAV_GROUP where G_NAME = gid;\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:408\n"
;

static const char *proc125 = 
"#line 428 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_DIR_LIST (\n"
"in path varchar := \'/DAV/\',\n"
"in recursive integer,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar) returns any\n"
"{\n"
"\n"
"declare auth_uid integer;\n"
"\n"
"auth_uid := DB.DBA.DAV_CHECK_AUTH (auth_uname, auth_pwd, 0);\n"
"if (auth_uid < 0)\n"
"return -12;\n"
"\n"
"return DB.DBA.DAV_DIR_LIST_INT (path, recursive, \'%\', auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"--src dav_api.sql:426\n"
;

static const char *proc126 = 
"#line 446 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_DIR_FILTER (\n"
"in path varchar := \'/DAV/\',\n"
"in recursive integer := 0,\n"
"inout filter any,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar) returns any\n"
"{\n"
"\n"
"declare auth_uid integer;\n"
"declare compilation any;\n"
"\n"
"auth_uid := DAV_CHECK_AUTH (auth_uname, auth_pwd, 0);\n"
"if (auth_uid < 0)\n"
"return -12;\n"
"\n"
"compilation := vector (\'\', filter, \'DAV\', DB.DBA.DAV_FC_PRINT_WHERE (filter, auth_uid));\n"
"return DB.DBA.DAV_DIR_FILTER_INT (path, recursive, compilation, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"--src dav_api.sql:444\n"
;

static const char *proc127 = 
"#line 467 \"[executable]/dav_api.sql\"\n"
"create function DAV_GET_PARENT (\n"
"in id any,\n"
"in st char(1),\n"
"in path varchar) returns any\n"
"{\n"
"st := upper (st);\n"
"if (isinteger (id))\n"
"{\n"
"if (\'R\' = st)\n"
"return coalesce ((select RES_COL from WS.WS.SYS_DAV_RES where RES_ID = id), -1);\n"
"\n"
"if (\'C\' = st)\n"
"return coalesce ((select COL_PARENT from WS.WS.SYS_DAV_COL where COL_ID = id), -1);\n"
"\n"
"return -14;\n"
"}\n"
"return call (cast (id[0] as varchar) || \'_DAV_GET_PARENT\') (id, st, path);\n"
"}\n"
"--src dav_api.sql:465\n"
;

static const char *proc128 = 
"#line 488 \"[executable]/dav_api.sql\"\n"
"create function DAV_DIR_SINGLE_INT (\n"
"in did any,\n"
"in st char (0),\n"
"in path varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in auth_uid integer := null,\n"
"in extern integer := 1) returns any\n"
"{\n"
"\n"
"declare rc integer;\n"
"\n"
"if (extern)\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE (did, st, \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"{\n"
"declare auth_parent any;\n"
"\n"
"auth_parent := DB.DBA.DAV_GET_PARENT (did, st, path);\n"
"rc := DB.DBA.DAV_AUTHENTICATE (auth_parent, \'C\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (auth_uid is null)\n"
"auth_uid := rc;\n"
"}\n"
"\n"
"if (isarray (did))\n"
"{\n"
"if (\'R\' = st)\n"
"return call (cast (did[0] as varchar) || \'_DAV_DIR_SINGLE\') (did, st, path, auth_uid);\n"
"\n"
"return call (cast (did[0] as varchar) || \'_DAV_DIR_LIST\') (did, vector (\'\'), path, \'%\', -1, auth_uid);\n"
"}\n"
"if (\'R\' = st)\n"
"\n"
"return (select vector (RES_FULL_PATH, \'R\', DAV_RES_LENGTH (RES_CONTENT, RES_SIZE), RES_MOD_TIME, RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME, coalesce (RES_ADD_TIME, RES_CR_TIME), RES_CREATOR)\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = did );\n"
"\n"
"\n"
"return (select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME, COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME, coalesce (COL_ADD_TIME, COL_CR_TIME), COL_CREATOR)\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = did );\n"
"}\n"
"--src dav_api.sql:486\n"
;

static const char *proc129 = 
"#line 537 \"[executable]/dav_api.sql\"\n"
"create function DAV_DIR_LIST_INT (\n"
"in path varchar := \'/DAV/\',\n"
"in rec_depth integer := 0, in name_mask varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"inout auth_uid integer := null) returns any\n"
"{\n"
"\n"
"declare rc, t, id, l integer;\n"
"declare path_string, st, det varchar;\n"
"declare did, detcol_id, detcol_path, det_subpath, res any;\n"
"\n"
"path_string := path;\n"
"did := DB.DBA.DAV_SEARCH_SOME_ID_OR_DET (path, st, det, detcol_id, detcol_path, det_subpath);\n"
"if (DAV_HIDE_ERROR (did) is null)\n"
"return did;\n"
"\n"
"rc := DB.DBA.DAV_AUTHENTICATE (did, st, \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"{\n"
"if (rec_depth = -1)\n"
"{\n"
"declare auth_parent any;\n"
"\n"
"auth_parent := DAV_GET_PARENT (did, st, path);\n"
"rc := DAV_AUTHENTICATE (auth_parent, \'C\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"\n"
"if (auth_uid is null)\n"
"auth_uid := rc;\n"
"\n"
"if (isarray (did))\n"
"{\n"
"if ((\'R\' = st) or (rec_depth = -1))\n"
"return vector (call (cast (did[0] as varchar) || \'_DAV_DIR_SINGLE\') (did, st, path, auth_uid));\n"
"\n"
"return call (cast (det as varchar) || \'_DAV_DIR_LIST\') (detcol_id, det_subpath, detcol_path, name_mask, rec_depth, auth_uid);\n"
"}\n"
"\n"
"vectorbld_init (res);\n"
"if (\'R\' = st)\n"
"{\n"
"\n"
"for (select vector (RES_FULL_PATH, \'R\', DAV_RES_LENGTH (RES_CONTENT, RES_SIZE), RES_MOD_TIME, RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME, coalesce (RES_ADD_TIME, RES_CR_TIME), RES_CREATOR) as i\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_NAME like name_mask and RES_FULL_PATH = DB.DBA.DAV_CONCAT_PATH (path, null)) do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else if (rec_depth = -1)\n"
"{\n"
"\n"
"for (select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME, COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME, coalesce (COL_ADD_TIME, COL_CR_TIME), COL_CREATOR) as i\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = did) do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else if (rec_depth > 0)\n"
"{\n"
"for (select SUBCOL_FULL_PATH, SUBCOL_ID, SUBCOL_NAME, SUBCOL_PARENT, SUBCOL_DET\n"
"from DB.DBA.DAV_PLAIN_SUBCOLS\n"
"where (root_id = did) and (root_path = path_string) and recursive = rec_depth and subcol_auth_uid = auth_uid and subcol_auth_pwd = auth_pwd) do\n"
"{\n"
"for (select COL_MOD_TIME, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = SUBCOL_PARENT and COL_NAME = SUBCOL_NAME) do\n"
"{\n"
"vectorbld_acc (res, vector (SUBCOL_FULL_PATH, \'C\', 0, COL_MOD_TIME, SUBCOL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', SUBCOL_NAME) );\n"
"if (SUBCOL_DET is not NULL)\n"
"vectorbld_concat_acc (res, call (SUBCOL_DET || \'_DAV_DIR_LIST\') (SUBCOL_ID, vector (\'\'), SUBCOL_FULL_PATH, name_mask, rec_depth, auth_uid));\n"
"\n"
"\n"
"for (select vector (RES_FULL_PATH, \'R\', DAV_RES_LENGTH (RES_CONTENT, RES_SIZE), RES_MOD_TIME, RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME, coalesce (RES_ADD_TIME, RES_CR_TIME), RES_CREATOR) as i\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_NAME like name_mask and RES_COL = SUBCOL_ID) do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else if (det is null)\n"
"{\n"
"\n"
"for (select vector (RES_FULL_PATH, \'R\', DAV_RES_LENGTH (RES_CONTENT, RES_SIZE), RES_MOD_TIME, RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME, coalesce (RES_ADD_TIME, RES_CR_TIME), RES_CREATOR) as i\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_NAME like name_mask and RES_COL = did) do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"\n"
"for (select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME, COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME, coalesce (COL_ADD_TIME, COL_CR_TIME), COL_CREATOR) as i\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = did) do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"vectorbld_concat_acc (res, call (cast (det as varchar) || \'_DAV_DIR_LIST\') (did, vector (\'\'), path, name_mask, rec_depth, auth_uid));\n"
"}\n"
"\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src dav_api.sql:535\n"
;

static const char *proc130 = 
"#line 652 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_DIR_FILTER_INT (in path varchar := \'/DAV/\', in rec_depth integer := 0, in compilation any, in auth_uname varchar := null, in auth_pwd varchar := null, in auth_uid integer := null) returns any\n"
"{\n"
"declare rc, t, id, uid, gid, l integer;\n"
"declare path_string, st, det, qry_text varchar;\n"
"declare did, detcol_id, detcol_path, det_subpath, res any;\n"
"\n"
"declare execstate, execmessage, execmeta, execrows any;\n"
"declare davcond varchar;\n"
"davcond := get_keyword (\'DAV\', compilation);\n"
"if (davcond is null)\n"
"{\n"
"davcond := DAV_FC_PRINT_WHERE (get_keyword (\'\', compilation), auth_uid);\n"
"compilation := vector_concat (compilation, vector (\'DAV\', davcond));\n"
"}\n"
"execstate := \'00000\';\n"
"vectorbld_init (res);\n"
"path_string := path;\n"
"did := DAV_SEARCH_SOME_ID_OR_DET (path, st, det, detcol_id, detcol_path, det_subpath);\n"
"if (isarray (did))\n"
"{\n"
"if (auth_uid is null)\n"
"uid := call (cast (did[0] as varchar) || \'_DAV_AUTHENTICATE\') (did, st, \'1__\', auth_uname, auth_pwd, uid);\n"
"else\n"
"uid := auth_uid;\n"
"if (uid < 0)\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"if (\'R\' = st)\n"
"res := vector (call (cast (did[0] as varchar) || \'_DAV_DIR_SINGLE\') (did, st, path, uid));\n"
"else\n"
"res := call (cast (det as varchar) || \'_DAV_DIR_FILTER\') (detcol_id, det_subpath, detcol_path, compilation, rec_depth, uid);\n"
"return res;\n"
"}\n"
"if (did < 0)\n"
"{\n"
"return did;\n"
"}\n"
"if ((\'R\' = st) or (det is null) or DB.DBA.DAV_DET_IS_WEBDAV_BASED (det))\n"
"{\n"
"if (auth_uid is null)\n"
"uid := DAV_AUTHENTICATE (did, st, \'1__\', auth_uname, auth_pwd, uid);\n"
"else\n"
"uid := auth_uid;\n"
"if (uid < 0)\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = uid), 0);\n"
"}\n"
"\n"
"if (\'R\' = st)\n"
"{\n"
"qry_text := \'\n"
"select _top.RES_FULL_PATH, \'\'R\'\', DAV_RES_LENGTH (_top.RES_CONTENT, _top.RES_SIZE), _top.RES_MOD_TIME,\n"
"_top.RES_ID, _top.RES_PERMS, _top.RES_GROUP, _top.RES_OWNER, _top.RES_CR_TIME, _top.RES_TYPE, _top.RES_NAME\n"
"from WS.WS.SYS_DAV_RES as _top \' || davcond || \' and\n"
"(_top.RES_FULL_PATH = DAV_CONCAT_PATH (?, null)) and\n"
"case (\n"
"DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER) )\n"
"when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\'))\n"
"else 1 end\';\n"
"\n"
"exec (qry_text, execstate, execmessage,\n"
"vector (path, uid, gid, uid),\n"
"100000000, execmeta, execrows );\n"
"\n"
"if (\'00000\' <> execstate)\n"
"signal (execstate, execmessage || \' in \' || qry_text);\n"
"vectorbld_concat_acc (res, execrows);\n"
"}\n"
"else if (rec_depth = -1)\n"
"{\n"
"for select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME,\n"
"COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME) as i\n"
"from WS.WS.SYS_DAV_COL\n"
"where\n"
"\n"
"COL_ID = did do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else if (rec_depth > 0)\n"
"{\n"
"qry_text := \'\n"
"select _top.RES_FULL_PATH, \'\'R\'\', DAV_RES_LENGTH (_top.RES_CONTENT, _top.RES_SIZE), _top.RES_MOD_TIME,\n"
"_top.RES_ID, _top.RES_PERMS, _top.RES_GROUP, _top.RES_OWNER, _top.RES_CR_TIME, _top.RES_TYPE, _top.RES_NAME\n"
"from WS.WS.SYS_DAV_RES as _top \' || davcond || \' and (_top.RES_FULL_PATH between ? and ?) and\n"
"case (\n"
"DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER) )\n"
"when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\'))\n"
"else 1 end\';\n"
"\n"
"exec (qry_text,\n"
"execstate, execmessage,\n"
"vector (path_string, DAV_COL_PATH_BOUNDARY (path_string), uid, gid, uid), 100000000, execmeta, execrows );\n"
"\n"
"if (\'00000\' <> execstate)\n"
"signal (execstate, execmessage || \' in \' || qry_text);\n"
"vectorbld_concat_acc (res, execrows);\n"
"\n"
"for select SUBCOL_FULL_PATH, SUBCOL_ID, SUBCOL_DET\n"
"from DB.DBA.DAV_PLAIN_SUBCOLS\n"
"where SUBCOL_DET is not null and (not (SUBCOL_DET like \'%Filter\')) and not DB.DBA.DAV_DET_IS_WEBDAV_BASED (SUBCOL_DET) and recursive = rec_depth and (root_id = did) and (root_path = path_string) and subcol_auth_uid = null and subcol_auth_pwd = null\n"
"do\n"
"{\n"
"vectorbld_concat_acc (res, call (SUBCOL_DET || \'_DAV_DIR_FILTER\') (SUBCOL_ID, vector (\'\'), SUBCOL_FULL_PATH, compilation, rec_depth, auth_uid));\n"
"}\n"
"}\n"
"else if (det is null)\n"
"{\n"
"qry_text := \'\n"
"select _top.RES_FULL_PATH, \'\'R\'\', DAV_RES_LENGTH (_top.RES_CONTENT, _top.RES_SIZE), _top.RES_MOD_TIME,\n"
"_top.RES_ID, _top.RES_PERMS, _top.RES_GROUP, _top.RES_OWNER, _top.RES_CR_TIME, _top.RES_TYPE, _top.RES_NAME\n"
"from WS.WS.SYS_DAV_RES as _top \' || davcond || \' and (RES_COL = ?) and\n"
"case (\n"
"DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER) )\n"
"when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\'))\n"
"else 1 end\';\n"
"\n"
"exec (qry_text, execstate, execmessage,\n"
"vector (did, uid, gid, uid),\n"
"100000000, execmeta, execrows );\n"
"\n"
"if (\'00000\' <> execstate)\n"
"signal (execstate, execmessage || \' in \' || qry_text);\n"
"vectorbld_concat_acc (res, execrows);\n"
"}\n"
"else\n"
"{\n"
"if (auth_uid is null)\n"
"uid := call (cast (did[0] as varchar) || \'_DAV_AUTHENTICATE\') (did, st, \'1__\', auth_uname, auth_pwd, uid);\n"
"else\n"
"uid := auth_uid;\n"
"if (uid < 0)\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"vectorbld_concat_acc (res, call (cast (det as varchar) || \'_DAV_DIR_FILTER\') (did, vector (\'\'), path, compilation, rec_depth, uid));\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src dav_api.sql:650\n"
;

static const char *proc131 = 
"#line 804 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_SEARCH_PATH (\n"
"in id any,\n"
"in what char (1)) returns any\n"
"{\n"
"declare res varchar;\n"
"\n"
"what := upper (what);\n"
"if (isvector (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_SEARCH_PATH\') (id, what);\n"
"\n"
"if (id <= 0)\n"
"{\n"
"if (id = 0)\n"
"return \'/\';\n"
"\n"
"return -22;\n"
"}\n"
"\n"
"if (what = \'C\')\n"
"{\n"
"res := WS.WS.COL_PATH (id);\n"
"if (res = \'/\')\n"
"return -23;\n"
"\n"
"return res;\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"return coalesce ((select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = id), -23);\n"
"}\n"
"\n"
"return -14;\n"
"}\n"
"--src dav_api.sql:802\n"
;

static const char *proc132 = 
"#line 846 \"[executable]/dav_api.sql\"\n"
" create function\n"
"DAV_SEARCH_ID (in path any, in what char (1)) returns any\n"
"{\n"
"declare id integer;\n"
"declare par any;\n"
"id := -1;\n"
"what := upper (what);\n"
"\n"
"if (isstring (path))\n"
"{\n"
"\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"\n"
"}\n"
"else\n"
"{\n"
"\n"
"par := path;\n"
"}\n"
"if (length (par) = 0)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (aref (par, 0) <> \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (what = \'P\')\n"
"{\n"
"if (par [length (par) - 1] = \'\')\n"
"{\n"
"if (2 = length (par))\n"
"return -1;\n"
"if (3 = length (par))\n"
"return 0;\n"
"par := vector_concat (subseq (par, 0, length (par) - 2), vector (\'\'));\n"
"}\n"
"else\n"
"{\n"
"if (2 = length (par))\n"
"return 0;\n"
"par := vector_concat (subseq (par, 0, length (par) - 1), vector (\'\'));\n"
"}\n"
"path := null;\n"
"what := \'C\';\n"
"}\n"
"\n"
"\n"
"if (what = \'R\')\n"
"{\n"
"if (aref (par, length (par) - 1) = \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path), -1);\n"
"if ((id <> -1) and (connection_get (\'dav_store\') is null))\n"
"{\n"
"declare det, detcol_id, detcol_path any;\n"
"\n"
"detcol_id := cast (DAV_PROP_GET_INT (id, what, \'virt:DETCOL_ID\', 0) as integer);\n"
"if (DAV_HIDE_ERROR (detcol_id) is not null)\n"
"{\n"
"detcol_path := DB.DBA.DAV_SEARCH_PATH (detcol_id, \'C\');\n"
"if (path like detcol_path || \'%\')\n"
"{\n"
"det := cast (coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), \'\') as varchar);\n"
"if ((det <> \'\') and __proc_exists (\'DB.DBA.\' || det || \'_DAV_MAKE_ID\'))\n"
"return call (cast (det as varchar) || \'_DAV_MAKE_ID\') (detcol_id, id, \'R\');\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else if (what = \'C\')\n"
"{\n"
"if (aref (par, length (par) - 1) <> \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"\n"
"id := -1;\n"
"}\n"
"else\n"
"{\n"
"\n"
"return -14;\n"
"}\n"
"if (id = -1)\n"
"{\n"
"declare det_ret, detcol_id, detcol_path_parts, unreached_path_parts any;\n"
"return DAV_SEARCH_ID_OR_DET (par, what, det_ret, detcol_id, detcol_path_parts, unreached_path_parts);\n"
"}\n"
"return id;\n"
"}\n"
"--src dav_api.sql:844\n"
;

static const char *proc133 = 
"#line 950 \"[executable]/dav_api.sql\"\n"
" create function\n"
"DAV_SEARCH_SOME_ID (in path any, out what char (1)) returns any\n"
"{\n"
"declare id integer;\n"
"declare par any;\n"
"id := -1;\n"
"\n"
"if (isstring (path))\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"par := path;\n"
"if (aref (par, 0) <> \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (aref (par, length (par) - 1) <> \'\')\n"
"{\n"
"what := \'R\';\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path), -1);\n"
"}\n"
"else\n"
"{\n"
"what := \'C\';\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := DAV_SEARCH_ID (path, \'C\');\n"
"}\n"
"\n"
"if (id = -1)\n"
"{\n"
"declare det_ret, detcol_id, detcol_path_parts, unreached_path_parts any;\n"
"return DAV_SEARCH_ID_OR_DET (par, what, det_ret, detcol_id, detcol_path_parts, unreached_path_parts);\n"
"}\n"
"return id;\n"
"}\n"
"--src dav_api.sql:948\n"
;

static const char *proc134 = 
"#line 991 \"[executable]/dav_api.sql\"\n"
" create function DAV_HIDE_ERROR (\n"
"in res any,\n"
"in dflt any := null) returns any\n"
"{\n"
"if (not (isinteger (res)))\n"
"return res;\n"
"\n"
"if (res >= 0)\n"
"return res;\n"
"\n"
"return dflt;\n"
"}\n"
"--src dav_api.sql:989\n"
;

static const char *proc135 = 
"#line 1007 \"[executable]/dav_api.sql\"\n"
" create function DAV_HIDE_ERROR_OR_DET (\n"
"in res any,\n"
"in dflt_err any := null,\n"
"in dflt_det any := -33) returns any\n"
"{\n"
"if (not (isinteger (res)))\n"
"return dflt_det;\n"
"\n"
"if (res >= 0)\n"
"return res;\n"
"\n"
"return dflt_err;\n"
"}\n"
"--src dav_api.sql:1005\n"
;

static const char *proc136 = 
"#line 1023 \"[executable]/dav_api.sql\"\n"
" create function DB.DBA.DAV_PATH_CHECK (\n"
"in parts any)\n"
"{\n"
"if (isstring (parts))\n"
"parts := split_and_decode (parts, 0, \'\\0\\0/\');\n"
"\n"
"foreach (any part in parts) do\n"
"{\n"
"if ((part = \'.\') or (part = \'..\'))\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:1021\n"
;

static const char *proc137 = 
"#line 1039 \"[executable]/dav_api.sql\"\n"
" create function DB.DBA.DAV_PATH_COMPARE (\n"
"in parts_1 any,\n"
"in parts_2 any)\n"
"{\n"
"declare N integer;\n"
"\n"
"if (isstring (parts_1))\n"
"parts_1 := split_and_decode (parts_1, 0, \'\\0\\0/\');\n"
"\n"
"if (isstring (parts_2))\n"
"parts_2 := split_and_decode (parts_2, 0, \'\\0\\0/\');\n"
"\n"
"if (length (parts_1) <> length (parts_2))\n"
"return 0;\n"
"\n"
"for (N := 0; N < length (parts_1); N := N + 1)\n"
"{\n"
"if (parts_1[N] <> parts_2[N])\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:1037\n"
;

static const char *proc138 = 
"#line 1064 \"[executable]/dav_api.sql\"\n"
" create function DAV_CONCAT_PATH (\n"
"in parts1 any,\n"
"in parts2 any)\n"
"{\n"
"declare strg1, strg2 varchar;\n"
"declare len, ctr integer;\n"
"if (parts1 is null)\n"
"strg1 := \'\';\n"
"else if (isstring (parts1))\n"
"strg1 := parts1;\n"
"else\n"
"{\n"
"len := length (parts1);\n"
"if (len = 0)\n"
"strg1 := \'\';\n"
"else\n"
"{\n"
"strg1 := parts1 [0];\n"
"ctr := 1;\n"
"while (ctr < len)\n"
"{\n"
"strg1 := strg1 || \'/\' || parts1 [ctr];\n"
"ctr := ctr + 1;\n"
"}\n"
"}\n"
"}\n"
"if (parts2 is null)\n"
"strg2 := \'\';\n"
"else if (isstring (parts2))\n"
"strg2 := parts2;\n"
"else\n"
"{\n"
"len := length (parts2);\n"
"if (len = 0)\n"
"strg2 := \'\';\n"
"else\n"
"{\n"
"strg2 := parts2 [0];\n"
"ctr := 1;\n"
"while (ctr < len)\n"
"{\n"
"strg2 := strg2 || \'/\' || parts2 [ctr];\n"
"ctr := ctr + 1;\n"
"}\n"
"}\n"
"}\n"
"if (strg1 = \'\')\n"
"return strg2;\n"
"if (strg2 = \'\')\n"
"return strg1;\n"
"if (strg1 [length(strg1) - 1] = 47)\n"
"if (strg2 [0] = 47)\n"
"return strg1 || subseq (strg2, 1);\n"
"else\n"
"return strg1 || strg2;\n"
"else\n"
"if (strg2 [0] = 47)\n"
"return strg1 || strg2;\n"
"else\n"
"return strg1 || \'/\' || strg2;\n"
"}\n"
"--src dav_api.sql:1062\n"
;

static const char *proc139 = 
"#line 1128 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_SEARCH_SOME_ID_OR_DET (inout path any, out what char (1), out det_ret varchar, out detcol_id integer, out detcol_path_parts any, out unreached_path_parts any) returns integer\n"
"{\n"
"if (isstring (path))\n"
"path := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"path := path;\n"
"if (length (path) < 2)\n"
"goto bad_path_arg;\n"
"if (aref (path, 0) <> \'\')\n"
"goto bad_path_arg;\n"
"if (path [length (path) - 1] = \'\')\n"
"what := \'C\';\n"
"else\n"
"what := \'R\';\n"
"return DAV_SEARCH_ID_OR_DET (path, what, det_ret, detcol_id, detcol_path_parts, unreached_path_parts);\n"
"\n"
"bad_path_arg:\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return -1;\n"
"}\n"
"--src dav_api.sql:1126\n"
;

static const char *proc140 = 
"#line 1153 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_SEARCH_ID_OR_DET (in path any, in what char (1), out det_ret varchar, out detcol_id integer, out detcol_path_parts any, out unreached_path_parts any) returns integer\n"
"{\n"
"declare id integer;\n"
"declare par, left_par, right_par any;\n"
"declare cname, det varchar;\n"
"declare inx, depth, cur_id, parent_id integer;\n"
"id := -1;\n"
"what := upper (what);\n"
"\n"
"if (isstring (path))\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"par := path;\n"
"if (length (par) < 2)\n"
"goto bad_path_arg;\n"
"if (aref (par, 0) <> \'\')\n"
"goto bad_path_arg;\n"
"if (what = \'P\')\n"
"{\n"
"if (par [length (par) - 1] = \'\')\n"
"{\n"
"if (2 = length (par))\n"
"goto bad_path_arg;\n"
"if (3 = length (par))\n"
"{\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return 0;\n"
"}\n"
"par := vector_concat (subseq (par, 0, length (par) - 2), vector (\'\'));\n"
"}\n"
"else\n"
"{\n"
"if (2 = length (par))\n"
"{\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return 0;\n"
"}\n"
"par := vector_concat (subseq (par, 0, length (par) - 1), vector (\'\'));\n"
"}\n"
"path := null;\n"
"what := \'C\';\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"if (aref (par, length (par) - 1) = \'\')\n"
"goto bad_path_arg;\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path), -1);\n"
"if ((id <> -1) and (connection_get (\'dav_store\') is null))\n"
"{\n"
"detcol_id := cast (DAV_PROP_GET_INT (id, what, \'virt:DETCOL_ID\', 0) as integer);\n"
"if (DAV_HIDE_ERROR (detcol_id) is not null)\n"
"{\n"
"det_ret := cast (coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), \'\') as varchar);\n"
"if ((det_ret <> \'\') and __proc_exists (\'DB.DBA.\' || det_ret || \'_DAV_MAKE_ID\'))\n"
"{\n"
"declare detcol_par any;\n"
"\n"
"detcol_par := split_and_decode (DAV_SEARCH_PATH (detcol_id, \'C\'), 0, \'\\0\\0/\');\n"
"inx := length (detcol_par)-2;\n"
"detcol_path_parts := subseq (par, 0, inx + 1);\n"
"par := subseq (par, inx + 1);\n"
"unreached_path_parts := par;\n"
"return call (cast (det_ret as varchar) || \'_DAV_MAKE_ID\') (detcol_id, id, \'R\');\n"
"}\n"
"}\n"
"}\n"
"if (id > 0)\n"
"goto found_plain_id;\n"
"\n"
"}\n"
"else if (what = \'C\')\n"
"{\n"
"if (aref (par, length (par) - 1) <> \'\')\n"
"goto bad_path_arg;\n"
"goto descending_col_search;\n"
"}\n"
"else\n"
"return -14;\n"
"\n"
"descending_col_search:\n"
"\n"
"inx := 1;\n"
"cur_id := 0;\n"
"parent_id := 0;\n"
"depth := length (par) - 1;\n"
"\n"
"whenever not found goto not_found;\n"
"while (inx < depth)\n"
"{\n"
"cname := aref (par, inx);\n"
"\n"
"select COL_ID, COL_DET into cur_id, det from WS.WS.SYS_DAV_COL where COL_NAME = cname and COL_PARENT = parent_id;\n"
"if ((det is not NULL) and (connection_get (\'dav_store\') is null))\n"
"{\n"
"det_ret := det;\n"
"detcol_id := cur_id;\n"
"detcol_path_parts := subseq (par, 0, inx + 1);\n"
"par := subseq (par, inx + 1);\n"
"unreached_path_parts := par;\n"
"if ((what = \'C\') and (inx = depth - 1))\n"
"return cur_id;\n"
"\n"
"return call (cast (det as varchar) || \'_DAV_SEARCH_ID\') (cur_id, par, what);\n"
"}\n"
"parent_id := cur_id;\n"
"inx := inx + 1;\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"return -1;\n"
"}\n"
"id := cur_id;\n"
"goto found_plain_id;\n"
"\n"
"found_plain_id:\n"
"det_ret := NULL;\n"
"detcol_id := NULL;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return id;\n"
"\n"
"not_found:\n"
"det_ret := NULL;\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return -1;\n"
"\n"
"bad_path_arg:\n"
"\n"
"det_ret := NULL;\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return -1;\n"
"}\n"
"--src dav_api.sql:1151\n"
;

static const char *proc141 = 
"#line 1299 \"[executable]/dav_api.sql\"\n"
"create procedure\n"
"DAV_OWNER_ID (in uid any, in gid any, out _uid integer, out _gid integer)\n"
"{\n"
"\n"
"if (uid is null)\n"
"_uid := http_nobody_uid();\n"
"else if (isinteger (uid))\n"
"_uid := uid;\n"
"else\n"
"_uid := coalesce (\n"
"(select U_ID from WS.WS.SYS_DAV_USER where U_NAME = uid),\n"
"case (uid) when \'anonymous\' then http_nobody_uid () else -12 end);\n"
"\n"
"if (gid is null)\n"
"_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = _uid), http_nogroup_gid ());\n"
"else if (isinteger (gid))\n"
"_gid := gid;\n"
"else\n"
"_gid := coalesce (\n"
"(select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid),\n"
"(select U_GROUP from WS.WS.SYS_DAV_USER where U_NAME = gid),\n"
"-12 );\n"
"\n"
"\n"
"\n"
"}\n"
"--src dav_api.sql:1297\n"
;

static const char *proc142 = 
"#line 1328 \"[executable]/dav_api.sql\"\n"
"create function DAV_IS_LOCKED_COMPARE (\n"
"in check_token varchar,\n"
"in token varchar,\n"
"in compare_mode integer := 0)\n"
"{\n"
"return case when (compare_mode) then equ (check_token, token) else neq (check_token, token) end;\n"
"}\n"
"--src dav_api.sql:1326\n"
;

static const char *proc143 = 
"#line 1337 \"[executable]/dav_api.sql\"\n"
"create function DAV_IS_LOCKED_INT (\n"
"inout id any,\n"
"inout st char,\n"
"in check_token varchar := \'\',\n"
"in strict_mode integer := 0)\n"
"{\n"
"\n"
"declare first integer;\n"
"declare rc varchar;\n"
"\n"
"st := upper (st);\n"
"if (st <> \'C\' and st <> \'R\')\n"
"return -14;\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_LOCK where datediff (\'second\', LOCK_TIME, now()) > LOCK_TIMEOUT))\n"
"{\n"
"delete from WS.WS.SYS_DAV_LOCK where datediff (\'second\', LOCK_TIME, now()) > LOCK_TIMEOUT;\n"
"}\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_IS_LOCKED\') (id, st, check_token);\n"
"\n"
"if (id <= 0)\n"
"return 0;\n"
"\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_LOCK))\n"
"return 0;\n"
"\n"
"first := 1;\n"
"while (not isnull (id))\n"
"{\n"
"\n"
"rc := (select LOCK_SCOPE from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = st and LOCK_PARENT_ID = id and DB.DBA.DAV_IS_LOCKED_COMPARE (check_token, LOCK_TOKEN, strict_mode));\n"
"if (not isnull (rc))\n"
"return case when (rc = \'X\') then 2 else 1 end;\n"
"\n"
"\n"
"if (first and not exists (select 1 from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and DB.DBA.DAV_IS_LOCKED_COMPARE (check_token, LOCK_TOKEN, strict_mode)))\n"
"return 0;\n"
"\n"
"if (st = \'R\')\n"
"id := (select RES_COL from WS.WS.SYS_DAV_RES where RES_ID = id);\n"
"else\n"
"id := (select COL_PARENT from WS.WS.SYS_DAV_COL where COL_ID = id);\n"
"\n"
"first := 0;\n"
"st := \'C\';\n"
"}\n"
"}\n"
"--src dav_api.sql:1335\n"
;

static const char *proc144 = 
"#line 1390 \"[executable]/dav_api.sql\"\n"
" create function DAV_IS_LOCKED (\n"
"in id any,\n"
"in st char,\n"
"in check_token any := 1) returns integer\n"
"{\n"
"declare rc integer;\n"
"\n"
"if (isstring (check_token))\n"
"rc := DB.DBA.DAV_IS_LOCKED_INT (id, st, check_token);\n"
"else\n"
"rc := DB.DBA.DAV_IS_LOCKED_INT (id, st);\n"
"\n"
"if (rc > 0)\n"
"return -8;\n"
"\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:1388\n"
;

static const char *proc145 = 
"#line 1410 \"[executable]/dav_api.sql\"\n"
" create function DAV_LIST_LOCKS (\n"
"in id any,\n"
"in st char) returns any\n"
"{\n"
"return DB.DBA.DAV_LIST_LOCKS_INT (id, st);\n"
"}\n"
"--src dav_api.sql:1408\n"
;

static const char *proc146 = 
"#line 1418 \"[executable]/dav_api.sql\"\n"
"create function DAV_LIST_LOCKS_INT (\n"
"in id any,\n"
"in type char) returns any\n"
"{\n"
"\n"
"declare res any;\n"
"\n"
"type := upper (type);\n"
"if (type <> \'C\' and type <> \'R\')\n"
"return -14;\n"
"\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_LIST_LOCKS\') (id, type, 0);\n"
"\n"
"if (id <= 0)\n"
"return -1;\n"
"\n"
"res := vector ();\n"
"for (select LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO\n"
"from WS.WS.SYS_DAV_LOCK\n"
"where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = type) do\n"
"{\n"
"res := vector_concat (res, vector (vector (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)));\n"
"}\n"
"return res;\n"
"}\n"
"--src dav_api.sql:1416\n"
;

static const char *proc147 = 
"#line 1446 \"[executable]/dav_api.sql\"\n"
"create function DAV_LOCK (\n"
"in path any,\n"
"in locktype varchar,\n"
"in scope varchar,\n"
"in token varchar,\n"
"in owner_name varchar,\n"
"in check_token varchar,\n"
"in depth varchar,\n"
"in timeout_sec integer,\n"
"in auth_uid varchar,\n"
"in auth_pwd varchar) returns any\n"
"{\n"
"\n"
"declare id any;\n"
"declare st char (1);\n"
"\n"
"id := null;\n"
"st := null;\n"
"return DB.DBA.DAV_LOCK_INT (path, id, st, locktype, scope, token, owner_name, check_token, depth, timeout_sec, auth_uid, auth_pwd, NULL);\n"
"}\n"
"--src dav_api.sql:1444\n"
;

static const char *proc148 = 
"#line 1468 \"[executable]/dav_api.sql\"\n"
"create function DAV_LOCK_INT (\n"
"in path any,\n"
"inout id any,\n"
"inout st char(1),\n"
"inout locktype varchar,\n"
"inout scope varchar,\n"
"in token varchar,\n"
"inout owner_name varchar,\n"
"inout check_token varchar,\n"
"in depth varchar,\n"
"in timeout_sec integer,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare p_id, x_id any;\n"
"declare rc, id_is_bad, compare_mode integer;\n"
"declare u_token, old_scope, p_st, x_st varchar;\n"
"\n"
"p_id := DB.DBA.DAV_SEARCH_ID (path, \'P\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (p_id) is null)\n"
"return case p_id when -1 then -34 else p_id end;\n"
"\n"
"p_st := \'C\';\n"
"if (id is null)\n"
"id := DB.DBA.DAV_SEARCH_SOME_ID (path, st);\n"
"\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"if (id <> -1)\n"
"return -1;\n"
"\n"
"if (\"RIGHT\" (path, 1) = \'/\')\n"
"return -1;\n"
"\n"
"id_is_bad := 1;\n"
"st := \'R\';\n"
"x_id := p_id;\n"
"x_st := p_st;\n"
"}\n"
"else\n"
"{\n"
"id_is_bad := 0;\n"
"x_id := id;\n"
"x_st := st;\n"
"}\n"
"rc := DB.DBA.DAV_AUTHENTICATE (x_id, x_st, \'11_\', auth_uname, auth_pwd, auth_uid);\n"
"if (DB.DBA.DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"if (auth_uid is null)\n"
"auth_uid := rc;\n"
"\n"
"if (check_token is null)\n"
"check_token := \'\';\n"
"\n"
"if (token is null)\n"
"token := \'\';\n"
"\n"
"if (owner_name is null)\n"
"owner_name := \'\';\n"
"\n"
"if (depth is null)\n"
"{\n"
"if (st = \'R\')\n"
"depth := \'0\';\n"
"else\n"
"depth := \'infinity\';\n"
"}\n"
"\n"
"if (timeout_sec is null or timeout_sec = 0)\n"
"timeout_sec := 604800;\n"
"\n"
"compare_mode := case when check_token = \'\' then 0 else 1 end;\n"
"\n"
"set isolation = \'serializable\';\n"
"rc := DB.DBA.DAV_IS_LOCKED_INT (x_id, x_st, check_token, compare_mode);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"if (compare_mode = 0)\n"
"{\n"
"if (rc = 2)\n"
"return -8;\n"
"\n"
"if ((rc = 1) and (scope = \'X\'))\n"
"return -8;\n"
"}\n"
"\n"
"\n"
"u_token := check_token;\n"
"if (u_token = \'\')\n"
"u_token := token;\n"
"\n"
"old_scope := case rc when 2 then \'X\' when 1 then \'S\' else \'\' end;\n"
"if ((scope = \'R\') and (old_scope = \'\'))\n"
"return -1;\n"
"\n"
"if ((scope <> \'R\') and (old_scope = \'\') and (st =\'C\'))\n"
"{\n"
"if (exists (select 1 from WS.WS.SYS_DAV_COL, WS.WS.SYS_DAV_LOCK where WS.WS.COL_PATH (COL_ID) between path and DB.DBA.DAV_COL_PATH_BOUNDARY (path) and LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = COL_ID))\n"
"return -1;\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_RES, WS.WS.SYS_DAV_LOCK where RES_FULL_PATH between path and DB.DBA.DAV_COL_PATH_BOUNDARY (path) and LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = RES_ID))\n"
"return -1;\n"
"}\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"token := u_token;\n"
"return call (cast (id[0] as varchar) || \'_DAV_LOCK\') (path, id, st, locktype, scope, token, owner_name, check_token, depth, timeout_sec, auth_uid);\n"
"}\n"
"\n"
"if (id_is_bad)\n"
"{\n"
"\n"
"declare parent_det, new_res_name varchar;\n"
"\n"
"parent_det := DB.DBA.DAV_PROP_GET_INT (p_id, \'C\', \':virtdet\', 0);\n"
"if (parent_det is not null)\n"
"{\n"
"token := u_token;\n"
"return call (parent_det || \'_DAV_LOCK\') (path, id, st, locktype, scope, token, owner_name, check_token, depth, timeout_sec, auth_uid);\n"
"}\n"
"\n"
"new_res_name := subseq (path, strrchr (path, \'/\') + 1);\n"
"if (exists (select top 1 1 from WS.WS.SYS_DAV_COL where COL_PARENT = p_id and COL_NAME = new_res_name))\n"
"return -26;\n"
"\n"
"id := WS.WS.GETID (\'R\');\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_CR_TIME, RES_MOD_TIME, RES_OWNER, RES_PERMS, RES_GROUP, RES_FULL_PATH)\n"
"values (id, new_res_name, p_id, now (), now (), auth_uid, \'110000000NN\', http_nogroup_gid (), path);\n"
"\n"
"old_scope := coalesce ((select LOCK_SCOPE from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = st and LOCK_PARENT_ID = id), \'\');\n"
"}\n"
"else if (scope <> \'R\')\n"
"{\n"
"old_scope := coalesce ((select LOCK_SCOPE from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = st and LOCK_PARENT_ID = id), \'\');\n"
"x_id := id;\n"
"x_st := st;\n"
"}\n"
"\n"
"\n"
"if ((scope = \'R\' or old_scope = \'S\' or old_scope = \'X\') and (u_token <> \'\'))\n"
"{\n"
"\n"
"declare c cursor for select LOCK_OWNER_INFO from WS.WS.SYS_DAV_LOCK where LOCK_TOKEN = u_token and LOCK_PARENT_TYPE = x_st and LOCK_PARENT_ID = x_id for update;\n"
"declare old_owner_name varchar;\n"
"whenever not found goto nothing_to_refresh;\n"
"\n"
"open c;\n"
"fetch c into old_owner_name;\n"
"if (owner_name = \'\')\n"
"owner_name := old_owner_name;\n"
"\n"
"scope := old_scope;\n"
"update WS.WS.SYS_DAV_LOCK set LOCK_TIME = now (), LOCK_TIMEOUT = timeout_sec, LOCK_OWNER_INFO = owner_name where current of c;\n"
"close c;\n"
"return u_token;\n"
"\n"
"nothing_to_refresh:\n"
"close c;\n"
"return -35;\n"
"}\n"
"\n"
"if ((old_scope = \'\') or (old_scope = \'S\' and scope = \'S\'))\n"
"{\n"
"if (token = \'\')\n"
"{\n"
"token := WS.WS.OPLOCKTOKEN();\n"
"}\n"
"else\n"
"{\n"
"if (exists (select top 1 1 from WS.WS.SYS_DAV_LOCK where LOCK_TOKEN = token and (LOCK_PARENT_TYPE <> st or LOCK_PARENT_ID <> id)))\n"
"return -35;\n"
"}\n"
"\n"
"insert into WS.WS.SYS_DAV_LOCK (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_PARENT_TYPE, LOCK_PARENT_ID, LOCK_TIME, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)\n"
"values (locktype, scope, token, st, id, now(), timeout_sec, auth_uid, owner_name);\n"
"\n"
"return token;\n"
"}\n"
"if (old_scope = \'X\' or (old_scope = \'S\' and scope = \'X\'))\n"
"return -8;\n"
"\n"
"return -35;\n"
"}\n"
"--src dav_api.sql:1466\n"
;

static const char *proc149 = 
"#line 1659 \"[executable]/dav_api.sql\"\n"
"create function DAV_UNLOCK (\n"
"in path varchar, in token varchar,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar) returns any\n"
"{\n"
"declare id any;\n"
"declare st char (1);\n"
"\n"
"id := DB.DBA.DAV_SEARCH_SOME_ID (path, st);\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"return -1;\n"
"\n"
"return DB.DBA.DAV_UNLOCK_INT (id, st, token, auth_uname, auth_pwd, null);\n"
"}\n"
"--src dav_api.sql:1657\n"
;

static const char *proc150 = 
"#line 1676 \"[executable]/dav_api.sql\"\n"
"create function DAV_UNLOCK_INT (\n"
"in id any,\n"
"in st char(1),\n"
"in token varchar,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare rc, _left, _right integer;\n"
"declare cur_token varchar;\n"
"declare l_cur cursor for select LOCK_TOKEN\n"
"from WS.WS.SYS_DAV_LOCK\n"
"where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = st and LOCK_TOKEN = token;\n"
"\n"
"auth_uid := DB.DBA.DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd, auth_uid);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"\n"
"_left := strstr (token, \'opaquelocktoken:\');\n"
"if (_left is not null)\n"
"{\n"
"_left := _left + 15;\n"
"_right := strrchr (token, \'>\');\n"
"if (_left < _right)\n"
"token := trim (substring (token, _left + 2, _right - _left - 1));\n"
"}\n"
"\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_UNLOCK\')(id, st, token, auth_uid);\n"
"\n"
"whenever not found goto not_locked_t;\n"
"open l_cur (exclusive, prefetch 1);\n"
"fetch l_cur into cur_token;\n"
"delete from WS.WS.SYS_DAV_LOCK where current of l_cur;\n"
"close l_cur;\n"
"return token;\n"
"\n"
"not_locked_t:\n"
"close l_cur;\n"
"return -27;\n"
"}\n"
"--src dav_api.sql:1674\n"
;

static const char *proc151 = 
"#line 1721 \"[executable]/dav_api.sql\"\n"
" create function DAV_REQ_CHARS_TO_BITMASK (\n"
"in req varchar) returns integer\n"
"{\n"
"return 4 * equ (req[0], 49) + 2 * equ (req[1], 49) + equ (req[2], 49);\n"
"}\n"
"--src dav_api.sql:1719\n"
;

static const char *proc152 = 
"#line 1736 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_USER (\n"
"inout a_uname varchar,\n"
"inout a_pwd varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout x_uid integer)\n"
"{\n"
"\n"
"if (isnull (a_uid))\n"
"a_uid := DB.DBA.DAV_CHECK_AUTH (a_uname, a_pwd, 0);\n"
"\n"
"x_uid := a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"else if (a_uid >= 0)\n"
"{\n"
"if (a_uid = http_dav_uid ())\n"
"{\n"
"a_gid := http_admin_gid ();\n"
"}\n"
"else if (a_uid = http_nobody_uid ())\n"
"{\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"else\n"
"{\n"
"a_gid := (select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = a_uid);\n"
"}\n"
"}\n"
"}\n"
"--src dav_api.sql:1734\n"
;

static const char *proc153 = 
"#line 1774 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_PARAMS (\n"
"in id any,\n"
"in what char(1),\n"
"in r_perms varchar,\n"
"inout i_uid integer,\n"
"inout i_gid integer,\n"
"inout i_perms varchar,\n"
"inout i_acl varbinary,\n"
"inout i_allow_anonymous integer) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"whenever not found goto _exit;\n"
"\n"
"rc := -1;\n"
"if      (what = \'R\')\n"
"{\n"
"select RES_OWNER, RES_GROUP, RES_PERMS, RES_ACL into i_uid, i_gid, i_perms, i_acl from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"rc := 1;\n"
"set isolation=\'committed\';\n"
"if (i_uid <> http_nobody_uid() and exists (select top 1 1 from SYS_USERS where U_ID = i_uid and U_ACCOUNT_DISABLED = 1))\n"
"{\n"
"rc := -1;\n"
"}\n"
"set isolation=\'serializable\';\n"
"}\n"
"else if (what = \'C\')\n"
"{\n"
"select COL_OWNER, COL_GROUP, COL_PERMS, COL_ACL into i_uid, i_gid, i_perms, i_acl from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"rc := 1;\n"
"}\n"
"else\n"
"{\n"
"rc := -14;\n"
"}\n"
"\n"
"if (rc > 0)\n"
"{\n"
"i_allow_anonymous := WS.WS.PERM_COMP (substring (cast (i_perms as varchar), 7, 3), r_perms);\n"
"}\n"
"\n"
"_exit:\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:1772\n"
;

static const char *proc154 = 
"#line 1821 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_CHECK_BASIC (\n"
"inout r_perms varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout i_uid integer,\n"
"inout i_gid integer,\n"
"inout i_perms varchar,\n"
"inout i_acl varbinary,\n"
"inout i_allow_anonymous integer) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"\n"
"rc := 0;\n"
"if ((a_uid >= 0) or i_allow_anonymous)\n"
"{\n"
"\n"
"if      (DB.DBA.DAV_CHECK_PERM (i_perms, r_perms, a_uid, a_gid, i_gid, i_uid))\n"
"{\n"
"rc := 1;\n"
"}\n"
"\n"
"else if (WS.WS.ACL_IS_GRANTED (i_acl, a_uid, DB.DBA.DAV_REQ_CHARS_TO_BITMASK (r_perms)))\n"
"{\n"
"rc := 1;\n"
"}\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:1819\n"
;

static const char *proc155 = 
"#line 1853 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_CHECK_EXTENTED (\n"
"in id any,\n"
"in what char(1),\n"
"inout r_perms varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout a_perms varchar,\n"
"inout a_serviceID varchar) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare a_uname, a_isRealUser, a_cert any;\n"
"\n"
"a_serviceID := null;\n"
"if (DB.DBA.DAV_AUTHENTICATE_SSL (id, what, null, r_perms, a_uid, a_gid, a_perms, a_serviceID, a_cert))\n"
"{\n"
"return 1;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"a_uid := -1;\n"
"a_gid := -1;\n"
"\n"
"\n"
"\n"
"if (a_uid = -1 and exists (select 1 from DB.DBA.SYS_KEYS where KEY_NAME=\'DB.DBA.WA_USER_OL_ACCOUNTS\'))\n"
"{\n"
"if (not DB.DBA.DAV_GET_UID_BY_SERVICE_ID (a_serviceID, a_uid, a_gid, a_uname, a_perms))\n"
"{\n"
"a_uid := -1;\n"
"}\n"
"}\n"
"\n"
"if (a_uid = -1)\n"
"DB.DBA.DAV_GET_UID_BY_WEBID (a_uid, a_gid, a_cert);\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:1851\n"
;

static const char *proc156 = 
"#line 1896 \"[executable]/dav_api.sql\"\n"
" create function DAV_AUTHENTICATE (\n"
"in id any,\n"
"in what char(1),\n"
"in req varchar,\n"
"in a_uname varchar,\n"
"in a_pwd varchar,\n"
"in a_uid integer := null) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare x_uid, a_gid, a_perms any;\n"
"declare a_uid_save, a_gid_save any;\n"
"declare i_uid, i_gid, i_perms, i_acl, i_serviceID, i_allow_anonymous any;\n"
"\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"i_serviceID := null;\n"
"connection_set (\'__davCreator__\', i_serviceID);\n"
"\n"
"what := upper (what);\n"
"\n"
"DB.DBA.DAV_AUTHENTICATE_USER (a_uname, a_pwd, a_uid, a_gid, x_uid);\n"
"if (a_uid = http_dav_uid())\n"
"{\n"
"return a_uid;\n"
"}\n"
"\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_AUTHENTICATE\') (id, what, req, a_uname, a_pwd, a_uid);\n"
"if (rc = -20)\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE (id[1], \'C\', req, a_uname, a_pwd, a_uid);\n"
"}\n"
"return rc;\n"
"}\n"
"\n"
"\n"
"rc := DB.DBA.DAV_AUTHENTICATE_PARAMS (id, what, req, i_uid, i_gid, i_perms, i_acl, i_allow_anonymous);\n"
"if (rc < 0)\n"
"{\n"
"return rc;\n"
"}\n"
"\n"
"\n"
"a_uid_save := a_uid;\n"
"a_gid_save := a_gid;\n"
"\n"
"\n"
"if (DB.DBA.DAV_AUTHENTICATE_CHECK_BASIC (req, a_uid, a_gid, i_uid, i_gid, i_perms, i_acl, i_allow_anonymous))\n"
"{\n"
"return x_uid;\n"
"}\n"
"\n"
"\n"
"if (DB.DBA.DAV_AUTHENTICATE_CHECK_EXTENTED (id, what, req, a_uid, a_gid, a_perms, i_serviceID))\n"
"{\n"
"connection_set (\'__davCreator__\', i_serviceID);\n"
"return a_uid;\n"
"}\n"
"\n"
"\n"
"if ((a_uid_save <> a_uid) or (a_gid_save <> a_gid))\n"
"{\n"
"\n"
"if (DB.DBA.DAV_AUTHENTICATE_CHECK_BASIC (req, a_uid, a_gid, i_uid, i_gid, i_perms, i_acl, i_allow_anonymous))\n"
"{\n"
"return a_uid;\n"
"}\n"
"}\n"
"\n"
"return -13;\n"
"}\n"
"--src dav_api.sql:1894\n"
;

static const char *proc157 = 
"#line 1975 \"[executable]/dav_api.sql\"\n"
" create function DAV_AUTHENTICATE_HTTP (\n"
"in id any,\n"
"in what char(1),\n"
"in req varchar,\n"
"in can_write_http integer,\n"
"inout a_lines any,\n"
"inout a_uname varchar,\n"
"inout a_pwd varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout a_perms varchar) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare a_save, a_uid_save, a_gid_save any;\n"
"declare i_uid, i_gid, i_perms, i_acl, i_serviceID, i_allow_anonymous any;\n"
"\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"i_serviceID := null;\n"
"connection_set (\'__davCreator__\', i_serviceID);\n"
"\n"
"what := upper (what);\n"
"\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_AUTHENTICATE_HTTP\') (id, what, req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, a_perms);\n"
"if (rc = -20)\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE_HTTP (id[1], \'C\', req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, a_perms);\n"
"}\n"
"return rc;\n"
"}\n"
"\n"
"if (id is null)\n"
"{\n"
"i_perms := \'000000000?\';\n"
"i_allow_anonymous := 0;\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.DAV_AUTHENTICATE_PARAMS (id, what, req, i_uid, i_gid, i_perms, i_acl, i_allow_anonymous);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"\n"
"if ((a_uid is null) and (not i_allow_anonymous or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\'))))\n"
"{\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, i_allow_anonymous, can_write_http, a_uname, a_pwd, a_uid, a_gid, a_perms);\n"
"if (rc < 0)\n"
"{\n"
"a_save := 0;\n"
"goto _check_extented;\n"
"}\n"
"}\n"
"\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"else if (a_uid = http_dav_uid())\n"
"{\n"
"a_gid := http_admin_gid ();\n"
"a_perms := i_perms;\n"
"\n"
"return a_uid;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (isnull (id))\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"else\n"
"{\n"
"a_uid := i_uid;\n"
"a_gid := i_gid;\n"
"}\n"
"a_perms := \'110110110--\';\n"
"}\n"
"\n"
"\n"
"a_save := 1;\n"
"a_uid_save := a_uid;\n"
"a_gid_save := a_gid;\n"
"\n"
"\n"
"if (DB.DBA.DAV_AUTHENTICATE_CHECK_BASIC (req, a_uid, a_gid, i_uid, i_gid, i_perms, i_acl, i_allow_anonymous))\n"
"{\n"
"a_perms := i_perms;\n"
"return a_uid;\n"
"}\n"
"\n"
"_check_extented:;\n"
"\n"
"if (DB.DBA.DAV_AUTHENTICATE_CHECK_EXTENTED (id, what, req, a_uid, a_gid, a_perms, i_serviceID))\n"
"{\n"
"connection_set (\'__davCreator__\', i_serviceID);\n"
"return a_uid;\n"
"}\n"
"\n"
"\n"
"if (not a_save or (a_uid_save <> a_uid) or (a_gid_save <> a_gid))\n"
"{\n"
"\n"
"if (DB.DBA.DAV_AUTHENTICATE_CHECK_BASIC (req, a_uid, a_gid, i_uid, i_gid, i_perms, i_acl, i_allow_anonymous))\n"
"{\n"
"a_perms := i_perms;\n"
"return a_uid;\n"
"}\n"
"\n"
"if (not a_save and i_serviceID is null)\n"
"return rc;\n"
"}\n"
"\n"
"\n"
"if (i_serviceID is not null)\n"
"{\n"
"connection_set (\'deniedServiceId\', i_serviceID);\n"
"}\n"
"\n"
"return -13;\n"
"}\n"
"--src dav_api.sql:1973\n"
;

static const char *proc158 = 
"#line 2113 \"[executable]/dav_api.sql\"\n"
"create function DAV_GET_UID_BY_SERVICE_ID (\n"
"in serviceId any,\n"
"out a_uid int,\n"
"out a_gid int,\n"
"out a_uname varchar,\n"
"out a_perms int)\n"
"{\n"
"declare rows any;\n"
"\n"
"rows := DB.DBA.DAV_EXEC_SQL (\'select WUO_U_ID, U_GROUP, U_NAME, U_DEF_PERMS from DB.DBA.WA_USER_OL_ACCOUNTS, DB.DBA.SYS_USERS where WUO_U_ID=U_ID and WUO_URL=?\', vector (serviceId));\n"
"if (length (rows) = 0)\n"
"{\n"
"a_uid := null;\n"
"a_gid := null;\n"
"a_uname := null;\n"
"a_perms := null;\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"a_uid := rows[0][0];\n"
"a_gid := rows[0][1];\n"
"a_uname := rows[0][2];\n"
"a_perms := rows[0][3];\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:2111\n"
;

static const char *proc159 = 
"#line 2142 \"[executable]/dav_api.sql\"\n"
"create function DAV_GET_UID_BY_WEBID (\n"
"out a_uid int,\n"
"out a_gid int,\n"
"in a_cert any := null)\n"
"{\n"
"declare rows any;\n"
"\n"
"if (isnull (a_cert) or (a_cert = 0))\n"
"a_cert := client_attr (\'client_certificate\');\n"
"\n"
"if (isnull (a_cert) or (a_cert = 0))\n"
"return 0;\n"
"\n"
"rows := DB.DBA.DAV_EXEC_SQL (\'select U_ID, U_GROUP from DB.DBA.SYS_USERS, DB.DBA.WA_USER_CERTS where UC_FINGERPRINT = ? and UC_U_ID = U_ID\', vector (get_certificate_info (6, a_cert)));\n"
"if (length (rows) = 0)\n"
"{\n"
"a_uid := null;\n"
"a_gid := null;\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"a_uid := rows[0][0];\n"
"a_gid := rows[0][1];\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:2140\n"
;

static const char *proc160 = 
"#line 2171 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_SSL_ITEM (\n"
"inout id any,\n"
"inout what char(1),\n"
"inout path varchar) returns integer\n"
"{\n"
"declare pos integer;\n"
"\n"
"if (isnull (path))\n"
"path := DB.DBA.DAV_SEARCH_PATH (id, what);\n"
"\n"
"if (isstring (path) and path like \'%,acl\')\n"
"{\n"
"path := regexp_replace (path, \',acl\\x24\', \'\');\n"
"pos := strrchr (path, \'/\');\n"
"if (not isnull (pos))\n"
"what := \'C\';\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (path, what);\n"
"}\n"
"}\n"
"--src dav_api.sql:2169\n"
;

static const char *proc161 = 
"#line 2193 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_SSL_CONDITION () returns integer\n"
"{\n"
"if (is_https_ctx () and (__proc_exists (\'SIOC.DBA.get_graph\') is not null) and client_attr (\'client_certificate\') <> 0)\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:2191\n"
;

static const char *proc162 = 
"#line 2203 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_SSL_SQL_PREPARE (\n"
"inout _sql varchar,\n"
"inout _sqlParams any,\n"
"in _params any)\n"
"{\n"
"declare _name, _value, _pattern, _char varchar;\n"
"declare V any;\n"
"\n"
"_char := case when (_sql like \'sparql%\') then \'??\' else \'?\' end;\n"
"_pattern := \'\\\\^\\\\{([a-zA-Z0-9])+\\\\}\\\\^\';\n"
"while (1)\n"
"{\n"
"V := regexp_parse (_pattern, _sql, 0);\n"
"if (isnull (V))\n"
"goto _exit;\n"
"\n"
"_name := subseq (_sql, V[0]+2, V[1]-2);\n"
"_value := get_keyword (_name, _params);\n"
"_sqlParams := vector_concat (_sqlParams, vector (_value));\n"
"_sql := subseq (_sql, 0, V[0]) || _char || subseq (_sql, V[1]);\n"
"}\n"
"_exit:;\n"
"return;\n"
"}\n"
"--src dav_api.sql:2201\n"
;

static const char *proc163 = 
"#line 2229 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_SSL_WEBID (\n"
"inout webid varchar,\n"
"inout webidGraph varchar,\n"
"inout cert any := null)\n"
"{\n"
"webid := connection_get (\'__webid\');\n"
"webidGraph := connection_get (\'__webidGraph\');\n"
"if (isnull (webid))\n"
"{\n"
"declare fing, vtype any;\n"
"\n"
"if (cert is null or cert = 0)\n"
"cert := client_attr (\'client_certificate\');\n"
"\n"
"if (cert is null or cert = 0)\n"
"{\n"
"https_renegotiate (3);\n"
"cert := client_attr (\'client_certificate\');\n"
"}\n"
"\n"
"if (cert is null or cert = 0)\n"
"return null;\n"
"\n"
"fing := get_certificate_info (6, cert);\n"
"webidGraph := \'http:\' || replace (fing, \':\', \'\');\n"
"if (not DB.DBA.WEBID_AUTH_GEN_2 (cert, 0, null, 1, 1, webid, webidGraph, 0, vtype))\n"
"webid := null;\n"
"}\n"
"connection_set (\'__webid\', coalesce (webid, \'\'));\n"
"connection_set (\'__webidGraph\', webidGraph);\n"
"\n"
"webid := case when webid = \'\' then null else webid end;\n"
"return webid;\n"
"}\n"
"--src dav_api.sql:2227\n"
;

static const char *proc164 = 
"#line 2265 \"[executable]/dav_api.sql\"\n"
"create function DAV_CHECK_ACLS_INTERNAL (\n"
"in webid varchar,\n"
"in webidGraph varchar,\n"
"in graph varchar,\n"
"in grpGraph varchar,\n"
"inout IRIs any,\n"
"inout reqMode any,\n"
"inout realMode any,\n"
"inout cert any := null)\n"
"{\n"
"\n"
"declare M, I integer;\n"
"declare tmp any;\n"
"\n"
"if (not isnull (webid))\n"
"{\n"
"for (\n"
"sparql\n"
"define input:storage \"\"\n"
"prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n"
"prefix foaf: <http://xmlns.com/foaf/0.1/>\n"
"prefix acl: <http://www.w3.org/ns/auth/acl#>\n"
"select ?p1 ?p2 ?p3 ?mode\n"
"where {\n"
"{\n"
"graph `iri(?:graph)`\n"
"{\n"
"?rule rdf:type acl:Authorization ;\n"
"acl:accessTo `iri(?:graph)` ;\n"
"acl:mode ?mode ;\n"
"acl:agent `iri(?:webid)` ;\n"
"acl:agent ?p1 .\n"
"}\n"
"}\n"
"union\n"
"{\n"
"graph `iri(?:graph)`\n"
"{\n"
"?rule rdf:type acl:Authorization ;\n"
"acl:accessTo `iri(?:graph)` ;\n"
"acl:mode ?mode ;\n"
"acl:agentClass foaf:Agent ;\n"
"acl:agentClass ?p2 .\n"
"}\n"
"}\n"
"union\n"
"{\n"
"graph `iri(?:graph)`\n"
"{\n"
"?rule rdf:type acl:Authorization ;\n"
"acl:accessTo `iri(?:graph)` ;\n"
"acl:mode ?mode ;\n"
"acl:agentClass ?p3 .\n"
"}\n"
"graph ?g\n"
"{\n"
"?p3 rdf:type foaf:Group ;\n"
"foaf:member `iri(?:webid)` .\n"
"}\n"
"}\n"
"}\n"
"order by ?p3 ?p2 ?p1 ?mode) do\n"
"{\n"
"if      (not isnull (\"p1\"))\n"
"I := 0;\n"
"else if (not isnull (\"p2\"))\n"
"I := 1;\n"
"else if (not isnull (\"p3\"))\n"
"I := 2;\n"
"else\n"
"goto _skip;\n"
"\n"
"if (tmp <> coalesce (\"p1\", \"p2\", \"p3\"))\n"
"{\n"
"tmp := coalesce (\"p1\", \"p2\", \"p3\");\n"
"for (M := 0; M < length (IRIs[I]); M := M + 1)\n"
"{\n"
"if (tmp = IRIs[I][M])\n"
"goto _skip;\n"
"}\n"
"}\n"
"\n"
"if (\"mode\" like \'%#Read\')\n"
"realMode[0] := 1;\n"
"else if (\"mode\" like \'%#Write\')\n"
"realMode[1] := 1;\n"
"else if (\"mode\" like \'%#Execute\')\n"
"realMode[2] := 1;\n"
"\n"
"if ((reqMode[0] <= realMode[0]) and (reqMode[1] <= realMode[1]) and (reqMode[2] <= realMode[2]))\n"
"goto _exit;\n"
"\n"
"IRIs[I] := vector_concat (IRIs[I], vector (tmp));\n"
"\n"
"_skip:;\n"
"}\n"
"}\n"
"\n"
"\n"
"_exit:;\n"
"}\n"
"--src dav_api.sql:2263\n"
;

static const char *proc165 = 
"#line 2371 \"[executable]/dav_api.sql\"\n"
"create function DAV_CHECK_ACLS (\n"
"in id any,\n"
"in webid varchar,\n"
"in webidGraph varchar,\n"
"in what char(1),\n"
"in path varchar,\n"
"in req varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout a_perms varchar,\n"
"inout a_cert any := null) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare det varchar;\n"
"declare graph, grpGraph, reqMode, realMode, IRIs any;\n"
"\n"
"rc := 0;\n"
"req := replace (req, \'_\', \'0\');\n"
"reqMode := vector (req[0]-48, req[1]-48, req[2]-48);\n"
"realMode := vector (0, 0, 0);\n"
"IRIs := vector (vector(), vector(), vector());\n"
"\n"
"set_user_id (\'dba\');\n"
"while (path <> \'/\')\n"
"{\n"
"id := DB.DBA.DAV_SEARCH_ID (path, what);\n"
"det := DB.DBA.DAV_DET_NAME (id);\n"
"if (\n"
"(DB.DBA.DAV_DET_IS_WEBDAV_BASED (det) and exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID =  DB.DBA.DAV_DET_DAV_ID (id) and PROP_TYPE = what and PROP_NAME = \'virt:aci_meta_n3\')) or\n"
"(det in (\'IMAP\', \'DynaRes\'))\n"
")\n"
"{\n"
"graph := WS.WS.WAC_GRAPH (path);\n"
"grpGraph := SIOC.DBA.get_graph () || \'/private/%\';\n"
"DB.DBA.DAV_CHECK_ACLS_INTERNAL (webid, webidGraph, graph, grpGraph, IRIs, reqMode, realMode, a_cert);\n"
"if ((reqMode[0] <= realMode[0]) and (reqMode[1] <= realMode[1]) and (reqMode[2] <= realMode[2]))\n"
"{\n"
"if (not DB.DBA.DAV_GET_UID_BY_WEBID (a_uid, a_gid, a_cert))\n"
"{\n"
"a_uid := DB.DBA.DAV_GET_OWNER (id, what);\n"
"if (DAV_HIDE_ERROR (a_uid) is null)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"else\n"
"{\n"
"a_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = a_uid), http_nogroup_gid ());\n"
"}\n"
"}\n"
"rc := 1;\n"
"goto _exit;\n"
"}\n"
"}\n"
"path := DB.DBA.DAV_DET_PATH_PARENT (path, 1);\n"
"what := \'C\';\n"
"}\n"
"\n"
"_exit:;\n"
"a_perms := sprintf (\'%d%d%d\', realMode[0], realMode[1], realMode[2]);\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:2369\n"
;

static const char *proc166 = 
"#line 2436 \"[executable]/dav_api.sql\"\n"
"create function DAV_AUTHENTICATE_SSL (\n"
"in id any,\n"
"in what char(1),\n"
"in path varchar,\n"
"in req varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout a_perms varchar,\n"
"inout a_webid varchar,\n"
"inout a_cert any := null) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare webidGraph any;\n"
"declare hdr, hstr any;\n"
"\n"
"rc := 0;\n"
"if (not DB.DBA.DAV_AUTHENTICATE_SSL_CONDITION ())\n"
"return rc;\n"
"\n"
"DB.DBA.DAV_AUTHENTICATE_SSL_ITEM (id, what, path);\n"
"\n"
"webidGraph := null;\n"
"DB.DBA.DAV_AUTHENTICATE_SSL_WEBID (a_webid, webidGraph, a_cert);\n"
"\n"
"a_perms := \'___\';\n"
"rc := DB.DBA.DAV_CHECK_ACLS (id, a_webid, webidGraph, what, path, req, a_uid, a_gid, a_perms, a_cert);\n"
"if (rc)\n"
"{\n"
"DB.DBA.DAV_PERMS_FIX (a_perms, \'000000000TM\');\n"
"hdr := http_header_array_get ();\n"
"hstr := \'\';\n"
"foreach (any h in hdr) do\n"
"{\n"
"if (h not like \'WWW-Authenticate:%\')\n"
"hstr := hstr || h;\n"
"}\n"
"http_header (hstr);\n"
"}\n"
"\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:2434\n"
;

static const char *proc167 = 
"#line 2482 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_COL_CREATE (\n"
"in path varchar,\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uid varchar := NULL,\n"
"in auth_pwd varchar := NULL)\n"
"{\n"
"return DAV_COL_CREATE_INT (path, permissions, uid, gid, auth_uid, auth_pwd, 1, 1, 1, null, null);\n"
"}\n"
"--src dav_api.sql:2480\n"
;

static const char *proc168 = 
"#line 2494 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_COL_CREATE_INT (\n"
"in path varchar,\n"
"in permissions varchar,\n"
"in uid any,\n"
"in gid any,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in return_error_if_already_exists integer,\n"
"in extern integer,\n"
"in check_locks any,\n"
"in ouid integer := null,\n"
"in ogid integer := null )\n"
"{\n"
"\n"
"declare pid, puid, pgid, rc integer;\n"
"declare name, det varchar;\n"
"declare par, creator any;\n"
"\n"
"rc := 0;\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"\n"
"if (aref (par, 0) <> \'\' or aref (par, length (par) - 1) <> \'\')\n"
"return -1;\n"
"\n"
"if (DAV_HIDE_ERROR ((pid := DAV_SEARCH_ID (path, \'P\'))) is null)\n"
"return pid;\n"
"\n"
"if (extern and 0 > (rc := DAV_AUTHENTICATE (pid, \'C\', \'11_\', auth_uname, auth_pwd)))\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (subseq (par, 0, length (par) - 1), \'R\')) is not null)\n"
"{\n"
"\n"
"return -25;\n"
"}\n"
"if ((0 = return_error_if_already_exists) and (rc := DAV_HIDE_ERROR (DAV_SEARCH_ID (path, \'C\'))) is not null)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"if (check_locks and 0 <> (rc := DAV_IS_LOCKED (pid , \'C\', check_locks)))\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"\n"
"if (isarray (pid))\n"
"det := DB.DBA.DAV_DET_NAME (pid);\n"
"else if ((pid > 0) and (connection_get (\'dav_store\') is null))\n"
"det := (select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = pid);\n"
"else\n"
"det := null;\n"
"if (det is not null)\n"
"{\n"
"declare auth_uid integer;\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (pid, \'C\', \'11_\', auth_uname, auth_pwd);\n"
"if (0 > auth_uid)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := http_nobody_uid ();\n"
"}\n"
"DAV_SEARCH_ID_OR_DET (par, \'C\', det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (det as varchar) || \'_DAV_COL_CREATE\') (detcol_id, unreached_path, permissions, ouid, ogid, auth_uid);\n"
"}\n"
"name := aref (par, length (par) - 2);\n"
"rc := WS.WS.GETID (\'C\');\n"
"if (ouid is null)\n"
"DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rc := -3;\n"
"};\n"
"\n"
"creator := connection_get (\'__davCreator__\');\n"
"if (not isnull (creator))\n"
"creator := iri_to_id (creator);\n"
"\n"
"insert soft WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_CREATOR, COL_OWNER, COL_GROUP, COL_PERMS, COL_CR_TIME, COL_MOD_TIME)\n"
"values (rc, name, pid, creator, ouid, ogid, permissions, now(), now ());\n"
"\n"
"if (not row_count())\n"
"rc := -3;\n"
"\n"
"if (rc > 0)\n"
"DB.DBA.LDP_CREATE_COL (path, pid);\n"
"}\n"
"\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:2492\n"
;

static const char *proc169 = 
"#line 2596 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.IS_REDIRECT_REF (inout path any)\n"
"{\n"
"for (select blob_to_string (PROP_VALUE) redirectRef\n"
"from WS.WS.SYS_DAV_RES,\n"
"WS.WS.SYS_DAV_PROP\n"
"where RES_FULL_PATH = path\n"
"and PROP_PARENT_ID = RES_ID\n"
"and PROP_NAME = \'redirectref\'\n"
"and PROP_TYPE = \'R\') do\n"
"{\n"
"path := redirectRef;\n"
"return 1;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:2594\n"
;

static const char *proc170 = 
"#line 2614 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.is_rdf_type(in type varchar) returns integer\n"
"{\n"
"if (\n"
"strstr (type, \'text/n3\') is not null or\n"
"strstr (type, \'text/turtle\') is not null or\n"
"strstr (type, \'text/rdf+n3\') is not null or\n"
"strstr (type, \'text/rdf+ttl\') is not null or\n"
"strstr (type, \'text/rdf+turtle\') is not null or\n"
"strstr (type, \'application/rdf+xml\') is not null or\n"
"strstr (type, \'application/rdf+n3\') is not null or\n"
"strstr (type, \'application/rdf+turtle\') is not null or\n"
"strstr (type, \'application/turtle\') is not null or\n"
"strstr (type, \'application/x-turtle\') is not null\n"
")\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:2612\n"
;

static const char *proc171 = 
"#line 2635 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RES_UPLOAD (\n"
"in path varchar,\n"
"in content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uid varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in check_locks any := 1)\n"
"{\n"
"if (not (isstring (check_locks)))\n"
"check_locks := 1;\n"
"\n"
"return DAV_RES_UPLOAD_STRSES_INT (path, content, type, permissions, uid, gid, auth_uid, auth_pwd, 1, null, null, null, null, null, check_locks);\n"
"}\n"
"--src dav_api.sql:2633\n"
;

static const char *proc172 = 
"#line 2654 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RES_UPLOAD_STRSES (\n"
"in path varchar,\n"
"inout content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uid varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in check_locks any := 1\n"
")\n"
"{\n"
"if (not (isstring (check_locks)))\n"
"check_locks := 1;\n"
"\n"
"return DAV_RES_UPLOAD_STRSES_INT (path, content, type, permissions, uid, gid, auth_uid, auth_pwd, 1, null, null, null, null, null, check_locks);\n"
"}\n"
"--src dav_api.sql:2652\n"
;

static const char *proc173 = 
"#line 2673 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RES_UPLOAD_STRSES_INT (\n"
"in path varchar,\n"
"inout content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid any := \'dav\',\n"
"in gid any := \'administrators\',\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in cr_time datetime := null,\n"
"in mod_time datetime := null,\n"
"in _rowguid varchar := null,\n"
"in ouid integer := null,\n"
"in ogid integer := null,\n"
"in check_locks any := 1,\n"
"in dav_call integer := 0\n"
")\n"
"{\n"
"declare id, rc, old_log_mode, new_log_mode any;\n"
"\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (path, \'R\');\n"
"if (not isnull (DB.DBA.DAV_HIDE_ERROR (id)) and (\'text/turtle\' = (select RES_TYPE from WS.WS.SYS_DAV_RES where RES_ID = DB.DBA.DAV_DET_DAV_ID (id))))\n"
"WS.WS.TTL_QUERY_POST_CLEAR (path);\n"
"\n"
"if (0 = dav_call)\n"
"{\n"
"if (type = \'application/sparql-query\')\n"
"{\n"
"WS.WS.SPARQL_QUERY_POST (path, content, uid, dav_call);\n"
"}\n"
"else if ((type = \'text/turtle\') and not DB.DBA.DAV_MAC_METAFILE (path))\n"
"{\n"
"rc := WS.WS.TTL_QUERY_POST (path, content, DB.DBA.LDP_ENABLED (DB.DBA.DAV_SEARCH_ID (DB.DBA.DAV_DET_PATH_PARENT (path, 1), \'C\')));\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"return rc;\n"
"}\n"
"}\n"
"\n"
"old_log_mode := log_enable (null);\n"
"\n"
"new_log_mode := bit_and (old_log_mode, 1);\n"
"old_log_mode := log_enable (bit_or (new_log_mode, 4), 1);\n"
"rc := DAV_RES_UPLOAD_STRSES_INT_INNER (path, content, type, permissions, uid, gid, auth_uname, auth_pwd, extern, cr_time, mod_time, _rowguid, ouid, ogid, check_locks);\n"
"log_enable (bit_or (old_log_mode, 4), 1);\n"
"\n"
"if ((DAV_HIDE_ERROR (rc) is not null) and (type in (\'text/turtle\', \'application/ld+json\')))\n"
"\n"
"DB.DBA.LDP_CREATE (path);\n"
"\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:2671\n"
;

static const char *proc174 = 
"#line 2728 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RES_UPLOAD_STRSES_INT_INNER (\n"
"in path varchar,\n"
"inout content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid any := \'dav\',\n"
"in gid any := \'administrators\',\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in cr_time datetime := null,\n"
"in mod_time datetime := null,\n"
"in _rowguid varchar := null,\n"
"in ouid integer := null,\n"
"in ogid integer := null,\n"
"in check_locks any := 1\n"
")\n"
"{\n"
"\n"
"declare auth_uid, pid, puid, pgid, rc, id integer;\n"
"declare pperms, name varchar;\n"
"declare par, creator any;\n"
"declare op char;\n"
"declare det varchar;\n"
"declare detcol_id, _is_xper_res, fake integer;\n"
"declare detcol_path, unreached_path any;\n"
"declare res_cr cursor for select RES_ID+1 from WS.WS.SYS_DAV_RES where RES_ID = id for update;\n"
"declare auto_version varchar;\n"
"declare locked int;\n"
"declare _cr_time datetime;\n"
"declare __rowguid varchar;\n"
"declare _owner, _creator any;\n"
"\n"
"if (IS_REDIRECT_REF (path))\n"
"{\n"
" ;\n"
"}\n"
"\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"if (aref (par, 0) <> \'\' or aref (par, length (par) - 1) = \'\')\n"
"return -1;\n"
"\n"
"locked := 0;\n"
"op := \'i\';\n"
"rc := 0;\n"
"if (ouid is null)\n"
"{\n"
"DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"}\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"\n"
"if (isarray (id))\n"
"{\n"
"if (extern)\n"
"{\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'11_\', auth_uname, auth_pwd);\n"
"if ((auth_uid < 0) and (auth_uid <> -1))\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := ouid;\n"
"}\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (id , \'R\', check_locks);\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"DAV_SEARCH_ID_OR_DET (par, \'R\', det, detcol_id, detcol_path, unreached_path);\n"
"rc := call (cast (det as varchar) || \'_DAV_RES_UPLOAD\') (detcol_id, unreached_path, content, type, permissions, ouid, ogid, auth_uid);\n"
"\n"
"return rc;\n"
"}\n"
"\n"
"if (0 > id)\n"
"{\n"
"pid := DAV_SEARCH_ID (path, \'P\');\n"
"if (isarray (pid))\n"
"{\n"
"det := pid[0];\n"
"}\n"
"else if (pid > 0)\n"
"{\n"
"det := (select COL_DET from WS.WS.SYS_DAV_COL where COL_ID=pid and connection_get (\'dav_store\') is null);\n"
"}\n"
"else\n"
"{\n"
"\n"
"return pid;\n"
"}\n"
"\n"
"if (extern)\n"
"{\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (pid, \'C\', \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := ouid;\n"
"}\n"
"\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (pid , \'C\', check_locks);\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"\n"
"set isolation=\'committed\';\n"
"if ( auth_uid <> http_nobody_uid() and\n"
"(http_dav_uid () <> coalesce (connection_get (\'DAVBillingUserID\'), -12)) and\n"
"exists (select top 1 1 from SYS_USERS where U_ID = auth_uid and U_ACCOUNT_DISABLED = 1 ))\n"
"return -42;\n"
"\n"
"set isolation=\'serializable\';\n"
"if (det is not null)\n"
"{\n"
"DAV_SEARCH_ID_OR_DET (par, \'R\', det, detcol_id, detcol_path, unreached_path);\n"
"rc := call (cast (det as varchar) || \'_DAV_RES_UPLOAD\') (detcol_id, unreached_path, content, type, permissions, ouid, ogid, auth_uid);\n"
"\n"
"return rc;\n"
"}\n"
"name := aref (par, length (par) - 1);\n"
"rc := WS.WS.GETID (\'R\');\n"
"op := \'i\';\n"
"if (cr_time is null)\n"
"cr_time := now();\n"
"}\n"
"else\n"
"{\n"
"open res_cr (exclusive, prefetch 1);\n"
"fetch res_cr into fake;\n"
"if (extern)\n"
"{\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"\n"
"pid := DAV_SEARCH_ID (path, \'P\');\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (pid, \'C\', \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := ouid;\n"
"}\n"
"auto_version := DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT(DAV_SEARCH_ID (path, \'R\'), \'R\', \'DAV:auto-version\', 0));\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (id , \'R\', check_locks);\n"
"locked := case when (rc < 0) then 1 else 0 end;\n"
"if (auto_version is not null)\n"
"{\n"
"declare vanilla_rc int;\n"
"\n"
"vanilla_rc := DAV_IS_LOCKED (id , \'R\', 1);\n"
"if (vanilla_rc < 0)\n"
"{\n"
"locked := 1;\n"
"if ((vanilla_rc = -8) and ((auto_version = \'DAV:checkout-unlocked-checkin\') or (auto_version = \'DAV:locked-checkout\')))\n"
"rc := 0;\n"
"}\n"
"}\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"rc := id;\n"
"op := \'u\';\n"
"\n"
"select RES_OWNER, RES_CREATOR, RES_CR_TIME, ROWGUID into _owner, _creator, _cr_time, __rowguid from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"if ((_owner <> ouid) and (isnull (_creator)))\n"
"_creator := iri_to_id (DB.DBA.DAV_DET_USER_IRI (_owner));\n"
"\n"
"if (cr_time is null)\n"
"cr_time := _cr_time;\n"
"\n"
"if (_rowguid is null)\n"
"_rowguid := __rowguid;\n"
"}\n"
"\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (par, vector (\'\')), \'C\')) is not null)\n"
"{\n"
"\n"
"return -26;\n"
"}\n"
"\n"
"if (mod_time is null)\n"
"mod_time := now();\n"
"\n"
"if (type = \'\')\n"
"type := http_mime_type (path);\n"
"\n"
"\n"
"if (type = \'text/xml\' and exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = pid and PROP_TYPE = \'C\' and PROP_NAME = \'xper\'))\n"
"{\n"
"insert soft WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_TYPE, PROP_PARENT_ID, PROP_VALUE)\n"
"values (WS.WS.GETID (\'P\'), \'xper\', \'R\', id, \'\');\n"
"_is_xper_res := 1;\n"
"}\n"
"else if (rc <> 0)\n"
"{\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xper\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = id;\n"
"_is_xper_res := 0;\n"
"}\n"
"\n"
"whenever sqlstate \'*\' goto unhappy_upload;\n"
"\n"
"if (op = \'i\')\n"
"{\n"
"creator := connection_get (\'__davCreator__\');\n"
"if (not isnull (creator))\n"
"creator := iri_to_id (creator);\n"
"\n"
"\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_CREATOR, RES_OWNER, RES_GROUP, RES_PERMS, RES_CR_TIME, RES_MOD_TIME, RES_TYPE, RES_CONTENT, ROWGUID, RES_FULL_PATH)\n"
"values (rc, name, pid, creator, ouid, ogid, permissions, cr_time, mod_time, type, content, _rowguid, path);\n"
"\n"
"if (_is_xper_res)\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = xml_persistent (RES_CONTENT) where RES_ID = id;\n"
"}\n"
"else\n"
"{\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"{\n"
"if (auto_version = \'DAV:checkout-checkin\')\n"
"{\n"
" ;\n"
"}\n"
"else if ((locked and (auto_version = \'DAV:checkout-unlocked-checkin\')) or (auto_version = \'DAV:checkout\') or (locked and (auto_version = \'DAV:locked-checkout\')))\n"
"{\n"
"return \"Versioning_CHECKOUT_INT\" (id, content, type, permissions, ouid, ogid);\n"
"}\n"
"else if (locked or (auto_version is null) or ((auto_version <> \'DAV:checkout-unlocked-checkin\') and (auto_version <> \'DAV:checkout-checkin\')))\n"
"{\n"
"return -38;\n"
"}\n"
"}\n"
"\n"
"if (sys_stat (\'cl_run_local_only\') = 1)\n"
"{\n"
"if (length (content) > 10485760)\n"
"log_enable (0, 1);\n"
"\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_CREATOR = _creator,\n"
"RES_OWNER = ouid,\n"
"RES_GROUP = ogid,\n"
"RES_PERMS = permissions,\n"
"RES_CR_TIME = cr_time,\n"
"RES_MOD_TIME = mod_time,\n"
"RES_TYPE = type,\n"
"RES_CONTENT = content,\n"
"ROWGUID = _rowguid,\n"
"RES_SIZE = null\n"
"where current of res_cr;\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_CREATOR = _creator,\n"
"RES_OWNER = ouid,\n"
"RES_GROUP = ogid,\n"
"RES_PERMS = permissions,\n"
"RES_CR_TIME = cr_time,\n"
"RES_MOD_TIME = mod_time,\n"
"RES_TYPE = type,\n"
"RES_CONTENT = content,\n"
"ROWGUID = _rowguid,\n"
"RES_SIZE = null\n"
"where RES_ID = id;\n"
"}\n"
"if (_is_xper_res)\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = xml_persistent (RES_CONTENT) where current of res_cr;\n"
"}\n"
"return rc;\n"
"\n"
"unhappy_upload:\n"
"if (__SQL_STATE = \'HT507\')\n"
"return -41;\n"
"\n"
"if (__SQL_STATE = \'HT508\')\n"
"return -42;\n"
"\n"
"if (__SQL_STATE = \'HT509\')\n"
"return -43;\n"
"\n"
"return -29;\n"
"}\n"
"--src dav_api.sql:2726\n"
;

static const char *proc175 = 
"#line 3025 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_RES_NAME (in rdf_graph varchar)\n"
"{\n"
"return replace ( replace ( replace ( replace ( replace ( replace ( replace (rdf_graph, \'/\', \'_\'), \'\\\\\', \'_\'), \':\', \'_\'), \'+\', \'_\'), \'\\\"\', \'_\'), \'[\', \'_\'), \']\', \'_\') || \'.RDF\';\n"
"}\n"
"--src dav_api.sql:3023\n"
;

static const char *proc176 = 
"#line 3031 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_REDIRECT (\n"
"in c_id integer,\n"
"in rdf_graph any,\n"
"in rdf_params any,\n"
"in ouid integer,\n"
"in ogid integer)\n"
"{\n"
"declare rdf_contentType, rdf_graph_resource_id, rdf_graph_resource_name, rdf_graph_resource_path any;\n"
"\n"
"rdf_graph_resource_name := DB.DBA.DAV_RDF_RES_NAME (rdf_graph);\n"
"rdf_graph_resource_name := replace (rdf_graph_resource_name, \' \', \'_\');\n"
"rdf_graph_resource_path := WS.WS.COL_PATH (c_id) || rdf_graph_resource_name;\n"
"if (isnull (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_SEARCH_ID (rdf_graph_resource_path, \'R\'))))\n"
"{\n"
"\n"
"rdf_contentType := get_keyword (\'contentType\', rdf_params, \'text/turtle\');\n"
"rdf_graph_resource_id := WS.WS.GETID (\'R\');\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_OWNER, RES_GROUP, RES_PERMS, RES_CR_TIME, RES_MOD_TIME, RES_TYPE, RES_CONTENT)\n"
"values (rdf_graph_resource_id, rdf_graph_resource_name, c_id, ouid, ogid, \'111101101NN\', now (), now (), rdf_contentType, \'\');\n"
"\n"
"DB.DBA.DAV_PROP_SET_INT (rdf_graph_resource_path, \'redirectref\', sprintf (\'%s/sparql?default-graph-uri=%U&query=%U&format=%U\', WS.WS.DAV_HOST (), rdf_graph,\n"
"\'CONSTRUCT { ?s ?p ?o} WHERE {?s ?p ?o}\', rdf_contentType), null, null, 0, 0, 1);\n"
"\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', c_id, \'LDI: Create SPARQL request file \' || rdf_graph_resource_path);\n"
"}\n"
"}\n"
"--src dav_api.sql:3029\n"
;

static const char *proc177 = 
"#line 3059 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_UPLOAD (\n"
"in path varchar,\n"
"inout res_content any,\n"
"in res_type varchar,\n"
"in rdf_graph varchar,\n"
"in rdf_base varchar,\n"
"in rdf_sponger varchar,\n"
"in rdf_cartridges varchar,\n"
"in rdf_metaCartridges varchar,\n"
"in rdf_private integer := 1)\n"
"{\n"
"\n"
"declare rdf_iri, rdf_graph2, rdf_base2 varchar;\n"
"declare content any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return 0;\n"
"};\n"
"\n"
"if (length (res_content) = 0)\n"
"return 0;\n"
"\n"
"\n"
"\n"
"if (path like \'%.zip\')\n"
"{\n"
"declare lst, tmp_file any;\n"
"\n"
"tmp_file := tmp_file_name ();\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"file_delete (tmp_file, 1);\n"
"return 0;\n"
"};\n"
"rdf_graph2 := WS.WS.WAC_GRAPH (path, \'LDITEMP\');\n"
"string_to_file (tmp_file, res_content, -2);\n"
"lst := unzip_list (tmp_file);\n"
"foreach (any x in lst) do\n"
"{\n"
"declare fname, item_graph, ss any;\n"
"ss := string_output ();\n"
"fname := x[0];\n"
"content := unzip_file (tmp_file, fname);\n"
"http_dav_url (fname, null, ss);\n"
"fname := string_output_string (ss);\n"
"item_graph := WS.WS.DAV_IRI (path || \'/\' || fname);\n"
"RDF_SINK_UPLOAD (concat (path, \'/\', fname), content, DAV_GUESS_MIME_TYPE_BY_NAME (fname), rdf_graph, rdf_base, rdf_sponger, rdf_cartridges, rdf_metaCartridges, 0);\n"
"SPARQL insert in graph ?:rdf_graph2 { ?s ?p ?o } where { graph `iri(?:item_graph)` { ?s ?p ?o } };\n"
"SPARQL clear graph ?:item_graph;\n"
"}\n"
"file_delete (tmp_file, 1);\n"
"goto _private;\n"
"}\n"
"\n"
"content := blob_to_string (res_content);\n"
"if (path like \'%.gz\' and length (res_content) > 2)\n"
"{\n"
"declare magic, html_start varchar;\n"
"magic := subseq (res_content, 0, 2);\n"
"html_start := null;\n"
"if (magic[0] = 0hex1f and magic[1] = 0hex8b)\n"
"{\n"
"content := gzip_uncompress (cast (res_content as varchar));\n"
"path := regexp_replace (path, \'\\.gz\\x24\', \'\');\n"
"res_type := DAV_GUESS_MIME_TYPE (path, content, html_start);\n"
"}\n"
"}\n"
"\n"
"\n"
"rdf_iri := WS.WS.DAV_IRI (path);\n"
"rdf_graph2 := WS.WS.WAC_GRAPH (path, \'LDITEMP\');\n"
"if (is_empty_or_null (rdf_base))\n"
"{\n"
"rdf_base2 := WS.WS.DAV_HOST () || path;\n"
"}\n"
"else\n"
"{\n"
"declare name varchar;\n"
"\n"
"name := trim (path, \'/\');\n"
"if (not isnull (strrchr (name, \'/\')))\n"
"name := right (name, length (name)-strrchr (name, \'/\')-1);\n"
"\n"
"rdf_base2 := rtrim (rdf_base, \'/\') || \'/\' || name;\n"
"}\n"
"\n"
"if (\n"
"strstr (res_type, \'application/rdf+xml\') is not null or\n"
"strstr (res_type, \'application/foaf+xml\') is not null\n"
")\n"
"{\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _grddl;\n"
"};\n"
"\n"
"if (rdf_sponger = \'on\')\n"
"{\n"
"declare xt any;\n"
"\n"
"xt := xtree_doc (content);\n"
"if (xpath_eval (\'[ xmlns:dv=\"http://www.w3.org/2003/g/data-view#\" ] /*[1]/@dv:transformation\', xt) is not null)\n"
"goto _grddl;\n"
"}\n"
"DB.DBA.RDF_LOAD_RDFXML (content, rdf_base2, rdf_graph2);\n"
"}\n"
"goto _exit;\n"
"}\n"
"\n"
"if (DB.DBA.is_rdf_type (res_type))\n"
"{\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _grddl;\n"
"};\n"
"\n"
"DB.DBA.TTLP (content, rdf_base2, rdf_graph2);\n"
"}\n"
"goto _exit;\n"
"}\n"
"\n"
"_grddl:;\n"
"if (rdf_sponger = \'on\')\n"
"{\n"
"declare rc, rcMeta integer;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _exit;\n"
"};\n"
"\n"
"\n"
"rc := RDF_SINK_UPLOAD_CARTRIDGES (content, res_type, \'select RM_ID, RM_PATTERN, RM_TYPE, RM_HOOK, RM_KEY, RM_OPTIONS from DB.DBA.SYS_RDF_MAPPERS where RM_ENABLED = 1 order by RM_ID\', rdf_iri, rdf_graph2, rdf_cartridges);\n"
"\n"
"rcMeta := RDF_SINK_UPLOAD_CARTRIDGES (content, res_type, \'select MC_ID, MC_PATTERN, MC_TYPE, MC_HOOK, MC_KEY, MC_OPTIONS from DB.DBA.RDF_META_CARTRIDGES where MC_ENABLED = 1 order by MC_SEQ, MC_ID\', rdf_iri, rdf_graph2, rdf_metaCartridges);\n"
"if (rc or rcMeta)\n"
"goto _exit;\n"
"}\n"
"return 0;\n"
"\n"
"_exit:\n"
"SPARQL insert in graph ?:rdf_graph { ?s ?p ?o } where { graph `iri(?:rdf_graph2)` { ?s ?p ?o } };\n"
"\n"
"_private:\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"SPARQL clear graph ?:rdf_graph2;\n"
"return 1;\n"
"};\n"
"\n"
"DB.DBA.DAV_DET_PRIVATE_GRAPH_ADD (rdf_graph2);\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:3057\n"
;

static const char *proc178 = 
"#line 3219 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_UPLOAD_CARTRIDGES (\n"
"inout content any,\n"
"inout type varchar,\n"
"in S varchar,\n"
"in rdf_iri varchar,\n"
"in rdf_graph varchar,\n"
"in rdf_cartridges varchar)\n"
"{\n"
"\n"
"declare cnt, hasSelection integer;\n"
"declare cname, pname varchar;\n"
"declare cartridges, aq, ps any;\n"
"declare xrc, val_match any;\n"
"declare st, msg, meta, rows, opts any;\n"
"\n"
"if (DB.DBA.is_empty_or_null (rdf_cartridges))\n"
"return 1;\n"
"\n"
"st := \'00000\';\n"
"exec (S, st, msg, vector (), vector (\'use_cache\', 1), meta, rows);\n"
"if (\'00000\' <> st)\n"
"return 0;\n"
"\n"
"cartridges := split_and_decode (rdf_cartridges, 0, \'\\0\\0,\');\n"
"ps := null;\n"
"aq := null;\n"
"foreach (any row in rows) do\n"
"{\n"
"cname := cast (row[0] as varchar);\n"
"if (position (cname, cartridges))\n"
"goto _try;\n"
"\n"
"goto _try_next;\n"
"\n"
"_try:\n"
"val_match := case when (row[2] = \'MIME\') then type else rdf_graph end;\n"
"if (isstring (val_match) and regexp_match (row[1], val_match) is not null)\n"
"{\n"
"pname := row[3];\n"
"if (__proc_exists (pname) is null)\n"
"goto _try_next;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _try_next;\n"
"};\n"
"opts := vector_concat (vector (), row[5]);\n"
"xrc := call (pname) (rdf_graph, rdf_iri, null, content, aq, ps, row[4], opts);\n"
"\n"
"\n"
"if (not hasSelection and (__tag (xrc) = 193 or xrc < 0 or xrc > 0))\n"
"return 1;\n"
"}\n"
"_try_next:;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:3217\n"
;

static const char *proc179 = 
"#line 3278 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_GRAPH_SEARCH (\n"
"in _path varchar,\n"
"inout _col_id integer)\n"
"{\n"
"\n"
"declare _col_parent, _depth integer;\n"
"declare _inherit, _graph varchar;\n"
"declare _params any;\n"
"\n"
"declare exit handler for not found\n"
"{\n"
"return null;\n"
"};\n"
"\n"
"_depth := 0;\n"
"\n"
"_again:;\n"
"_params := DB.DBA.DAV_DET_RDF_PARAMS_GET (\'rdfSink\', _col_id);\n"
"_graph := get_keyword (\'graph\', _params);\n"
"if (length (_graph) and (_depth = 0))\n"
"{\n"
"return _graph;\n"
"}\n"
"select COL_PARENT, COL_INHERIT into _col_parent, _inherit from WS.WS.SYS_DAV_COL where COL_ID = _col_id;\n"
"if (length (_graph) and ((_inherit = \'R\') or (_depth = 1 and _inherit = \'M\') or (_depth = 0)))\n"
"{\n"
"return _graph;\n"
"}\n"
"_col_id := _col_parent;\n"
"_depth := _depth + 1;\n"
"\n"
"goto _again;\n"
"\n"
"return null;\n"
"}\n"
"--src dav_api.sql:3276\n"
;

static const char *proc180 = 
"#line 3315 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_INSERT (\n"
"in _queue_id integer := null,\n"
"in _path varchar,\n"
"in _res_id integer,\n"
"in _col_id integer,\n"
"in _res_type varchar,\n"
"in _res_owner integer,\n"
"in _res_group integer,\n"
"in _res_length integer)\n"
"{\n"
"\n"
"declare rdf_graph varchar;\n"
"declare rdf_params, rdf_sponger, rdf_base, rdf_cartridges, rdf_metaCartridges, _res_content any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _bad_content;\n"
"};\n"
"\n"
"if (_res_length = 0)\n"
"goto _bad_content;\n"
"\n"
"rdf_graph := DB.DBA.RDF_SINK_GRAPH_SEARCH (_path, _col_id);\n"
"if (length (rdf_graph) = 0)\n"
"goto _bad_content;\n"
"\n"
"if (isnull (_queue_id))\n"
"{\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _col_id, \'Data Import Queued for Insert: \' || _path);\n"
"DB.DBA.DAV_QUEUE_ADD (\'RDF_SINK_INSERT\', _res_id, \'DB.DBA.RDF_SINK_INSERT\', vector (_path, _res_id, _col_id, _res_type, _res_owner, _res_group, _res_length));\n"
"DB.DBA.DAV_QUEUE_INIT (1);\n"
"\n"
"return;\n"
"}\n"
"\n"
"_res_content := (select RES_CONTENT from WS.WS.SYS_DAV_RES where RES_ID = _res_id);\n"
"\n"
"\n"
"rdf_params := DB.DBA.DAV_DET_RDF_PARAMS_GET (\'rdfSink\', _col_id);\n"
"rdf_base := get_keyword (\'base\', rdf_params, \'\');\n"
"rdf_sponger := get_keyword (\'sponger\', rdf_params, \'on\');\n"
"rdf_cartridges := get_keyword (\'cartridges\', rdf_params, \'\');\n"
"rdf_metaCartridges := get_keyword (\'metaCartridges\', rdf_params, \'\');\n"
"\n"
"\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _col_id, \'Data Import Start: \' || _path);\n"
"if (DB.DBA.RDF_SINK_UPLOAD (_path, _res_content, _res_type, rdf_graph, rdf_base, rdf_sponger, rdf_cartridges, rdf_metaCartridges))\n"
"{\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _col_id, \'Data Import End: \' || _path);\n"
"DB.DBA.RDF_SINK_REDIRECT (_col_id, rdf_graph, rdf_params, _res_owner, _res_group);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _col_id, \'Data Import Error: \' || _path);\n"
"}\n"
"\n"
"_bad_content:;\n"
"if (not isnull (_queue_id) and (_queue_id > 0))\n"
"DB.DBA.DAV_QUEUE_UPDATE_FINAL (_queue_id);\n"
"}\n"
"--src dav_api.sql:3313\n"
;

static const char *proc181 = 
"#line 3376 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_DELETE (\n"
"in _queue_id integer := null,\n"
"in _path varchar,\n"
"in _res_id integer,\n"
"in _col_id integer,\n"
"in _res_length integer)\n"
"{\n"
"\n"
"declare rdf_graph, rdf_graph2 varchar;\n"
"declare g_iid, g2_iid any;\n"
"\n"
"if (_res_length = 0)\n"
"goto _bad_content;\n"
"\n"
"rdf_graph := DB.DBA.RDF_SINK_GRAPH_SEARCH (_path, _col_id);\n"
"if (length (rdf_graph) = 0)\n"
"goto _bad_content;\n"
"\n"
"if (isnull (_queue_id))\n"
"{\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _col_id, \'Data Import Queued for Delete: \' || _path);\n"
"DB.DBA.DAV_QUEUE_ADD (\'RDF_SINK_DELETE\', _res_id, \'DB.DBA.RDF_SINK_DELETE\', vector (_path, _res_id, _col_id, _res_length));\n"
"DB.DBA.DAV_QUEUE_INIT (1);\n"
"\n"
"return;\n"
"}\n"
"\n"
"if (_path like \'%.gz\')\n"
"{\n"
"_path := regexp_replace (_path, \'\\.gz\\x24\', \'\');\n"
"}\n"
"rdf_graph2 := WS.WS.WAC_GRAPH (_path, \'LDITEMP\');\n"
"g_iid := __i2idn (rdf_graph);\n"
"g2_iid := __i2idn (rdf_graph2);\n"
"for (select a.S as _s, a.P as _p, a.O as _o from DB.DBA.RDF_QUAD a where a.G = g2_iid) do\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = g_iid and S = _s and P = _p and O = _o;\n"
"}\n"
"delete from DB.DBA.RDF_QUAD where G = g2_iid;\n"
"DB.DBA.DAV_DET_PRIVATE_GRAPH_REMOVE (rdf_graph2);\n"
"\n"
"_bad_content:;\n"
"if (not isnull (_queue_id) and (_queue_id > 0))\n"
"{\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _col_id, \'Data Import Delete: \' || _path);\n"
"DB.DBA.DAV_QUEUE_UPDATE_FINAL (_queue_id);\n"
"}\n"
"}\n"
"--src dav_api.sql:3374\n"
;

static const char *proc182 = 
"#line 3426 \"[executable]/dav_api.sql\"\n"
"create procedure RDF_SINK_UPDATE (\n"
"in _queue_id integer := null,\n"
"in _o_path varchar,\n"
"in _o_res_id integer,\n"
"in _o_col_id integer,\n"
"in _o_res_length integer,\n"
"in _n_path varchar,\n"
"in _n_res_id integer,\n"
"in _n_col_id integer,\n"
"in _n_res_type varchar,\n"
"in _n_res_owner integer,\n"
"in _n_res_group integer,\n"
"in _n_res_length integer)\n"
"{\n"
"\n"
"\n"
"if ((_o_res_length = 0) and (_n_res_length = 0))\n"
"return;\n"
"\n"
"if ((length (RDF_SINK_GRAPH_SEARCH (_o_path, _o_col_id)) = 0) and (length (RDF_SINK_GRAPH_SEARCH (_n_path, _n_col_id)) = 0))\n"
"return;\n"
"\n"
"if (isnull (_queue_id))\n"
"{\n"
"DB.DBA.DAV_DET_ACTIVITY (\'rdfSink\', _n_col_id, \'Data Import Queued for Update: \' || _n_path);\n"
"DB.DBA.DAV_QUEUE_ADD (\'RDF_SINK_UPDATE\', _n_res_id, \'DB.DBA.RDF_SINK_UPDATE\', vector (_o_path, _o_res_id, _o_col_id, _o_res_length, _n_path, _n_res_id, _n_col_id, _n_res_type, _n_res_owner, _n_res_group, _n_res_length));\n"
"DB.DBA.DAV_QUEUE_INIT (1);\n"
"\n"
"return;\n"
"}\n"
"\n"
"RDF_SINK_DELETE (-_queue_id, _o_path, _o_res_id, _o_col_id, _o_res_length);\n"
"RDF_SINK_INSERT (-_queue_id, _n_path, _n_res_id, _n_col_id, _n_res_type, _n_res_owner, _n_res_group, _n_res_length);\n"
"\n"
"DB.DBA.DAV_QUEUE_UPDATE_FINAL (_queue_id);\n"
"}\n"
"--src dav_api.sql:3424\n"
;

static const char *proc183 = 
"#line 3465 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_DELETE (\n"
"in path varchar,\n"
"in silent integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar\n"
")\n"
"{\n"
"return DAV_DELETE_INT (path, silent, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:3463\n"
;

static const char *proc184 = 
"#line 3476 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_DELETE_INT (\n"
"in path varchar,\n"
"in silent integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in extern integer := 1,\n"
"in check_locks any := 1\n"
")\n"
"{\n"
"declare id, id_meta, rc integer;\n"
"declare what char;\n"
"declare auth_uid integer;\n"
"declare par, path_meta any;\n"
"whenever sqlstate \'HT508\' goto disabled_owner;\n"
"whenever sqlstate \'HT509\' goto disabled_home;\n"
"\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"if (aref (par, 0) <> \'\')\n"
"return -1;\n"
"\n"
"what := case when (aref (par, length (par) - 1) = \'\') then \'C\' else \'R\' end;\n"
"id := DAV_SEARCH_ID (par, what);\n"
"if (isinteger (id) and (0 > id))\n"
"return (case when silent then 1 else id end);\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, what, \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return (case when silent then 1 else auth_uid end);\n"
"}\n"
"else\n"
"auth_uid := http_nobody_uid ();\n"
"\n"
"\n"
"if (check_locks and (0 <> (rc := DAV_IS_LOCKED (id, what, check_locks))))\n"
"return rc;\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare det varchar;\n"
"declare detcol_id, detcol_path, unreached_path any;\n"
"DAV_SEARCH_ID_OR_DET (par, what, det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (det as varchar) || \'_DAV_DELETE\') (detcol_id, unreached_path, what, silent, auth_uid);\n"
"}\n"
"\n"
"path_meta := rtrim (path, \'/\') || \',meta\';\n"
"id_meta := DAV_SEARCH_ID (path_meta, \'R\');\n"
"if (what = \'R\')\n"
"{\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"DB.DBA.LDP_DELETE (path, 1);\n"
"\n"
"\n"
"if (not isnull (DB.DBA.DAV_HIDE_ERROR (id_meta)))\n"
"{\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = id_meta;\n"
"DB.DBA.LDP_DELETE (path_meta, 1);\n"
"}\n"
"}\n"
"else if (what = \'C\')\n"
"{\n"
"declare rrc integer;\n"
"declare items any;\n"
"declare det, proc, graph varchar;\n"
"\n"
"det := cast (coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = id), \'\') as varchar);\n"
"if ((det = \'\') or DB.DBA.DAV_DET_IS_SPECIAL (det))\n"
"{\n"
"if (det = \'IMAP\')\n"
"{\n"
"items := call (det || \'_DAV_DIR_LIST\') (id, vector (), path, 0, \'%\', http_dav_uid ());\n"
"connection_set (\'dav_store\', 1);\n"
"foreach (any item in items) do\n"
"{\n"
"rrc := call (det || \'_DAV_DELETE\') (id, split_and_decode (item[10] || case when (item[1] = \'C\') then \'/\' else \'\' end, 0, \'\\0\\0/\'), item[1], silent, auth_uid);\n"
"if (rrc <> 1)\n"
"{\n"
"connection_set (\'dav_store\', null);\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"if (__proc_exists (\'DB.DBA.IMAP__ownerErase\') is not null)\n"
"{\n"
"DB.DBA.IMAP__ownerErase (id);\n"
"}\n"
"connection_set (\'dav_store\', null);\n"
"}\n"
"else\n"
"{\n"
"if (det <> \'\')\n"
"connection_set (\'dav_store\', 1);\n"
"\n"
"for select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = id do\n"
"{\n"
"rrc := DAV_DELETE_INT (RES_FULL_PATH, silent, auth_uname, auth_pwd, extern, check_locks);\n"
"if ((rrc <> 1) and (RES_FULL_PATH not like \'%,acl\'))\n"
"{\n"
"connection_set (\'dav_store\', null);\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"for select COL_ID, COL_NAME from WS.WS.SYS_DAV_COL where COL_PARENT = id do\n"
"{\n"
"rrc := DAV_DELETE_INT (WS.WS.COL_PATH(COL_ID), silent, auth_uname, auth_pwd, extern, check_locks);\n"
"if ((rrc <> 1) and (COL_NAME not like \'%,acl\'))\n"
"{\n"
"connection_set (\'dav_store\', null);\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"if (det <> \'\')\n"
"connection_set (\'dav_store\', null);\n"
"}\n"
"\n"
"graph := DB.DBA.DAV_PROP_GET_INT (id, \'C\', sprintf (\'virt:%s-graph\', det), 0);\n"
"if (not isnull (DB.DBA.DAV_HIDE_ERROR (graph)) and (graph <> \'\'))\n"
"{\n"
"declare exit handler for sqlstate \'*\' {;};\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\', graph);\n"
"}\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"DB.DBA.LDP_DELETE (path, 1);\n"
"\n"
"\n"
"if (not isnull (DB.DBA.DAV_HIDE_ERROR (id_meta)))\n"
"{\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = id_meta;\n"
"DB.DBA.LDP_DELETE (path_meta, 1);\n"
"}\n"
"}\n"
"else if (not silent)\n"
"{\n"
"return -1;\n"
"}\n"
"\n"
"return 1;\n"
"\n"
"disabled_owner:\n"
"return -42;\n"
"\n"
"disabled_home:\n"
"return -43;\n"
"}\n"
"--src dav_api.sql:3474\n"
;

static const char *proc185 = 
"#line 3627 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_TAG_LIST (\n"
"in id any,\n"
"in st char (1),\n"
"in uid_list any) returns any\n"
"{\n"
"\n"
"if (\'R\' <> st)\n"
"return vector ();\n"
"\n"
"if (isarray (id) and not DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (id)))\n"
"{\n"
"whenever sqlstate \'42001\' goto _unsupported;\n"
"return call (cast (id[0] as varchar) || \'_DAV_TAG_LIST\')(id, st, uid_list);\n"
"\n"
"_unsupported:\n"
"return -20;\n"
"}\n"
"\n"
"if (uid_list is null)\n"
"return (select VECTOR_AGG (vector (DT_U_ID, DT_TAGS)) from Ws.WS.SYS_DAV_TAG where DT_RES_ID = DB.DBA.DAV_DET_DAV_ID (id));\n"
"\n"
"return (select VECTOR_AGG (vector (DT_U_ID, DT_TAGS)) from Ws.WS.SYS_DAV_TAG where DT_RES_ID = DB.DBA.DAV_DET_DAV_ID (id) and position (DT_U_ID, uid_list));\n"
"}\n"
"--src dav_api.sql:3625\n"
;

static const char *proc186 = 
"#line 3652 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_TAG_SET (\n"
"in id any,\n"
"in st char (1),\n"
"in uid integer,\n"
"in tags varchar) returns integer\n"
"{\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_USER where U_ID = uid))\n"
"return -18;\n"
"\n"
"if (\'R\' <> st)\n"
"return -14;\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = DB.DBA.DAV_DET_DAV_ID (id) and DT_U_ID = uid))\n"
"{\n"
"update WS.WS.SYS_DAV_TAG set DT_TAGS = tags where DT_RES_ID = DB.DBA.DAV_DET_DAV_ID (id) and DT_U_ID = uid;\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_TAG (DT_RES_ID, DT_U_ID, DT_FT_ID, DT_TAGS)\n"
"values (DB.DBA.DAV_DET_DAV_ID (id), uid, WS.WS.GETID (\'T\'), tags);\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:3650\n"
;

static const char *proc187 = 
"#line 3680 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_COPY (\n"
"in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar)\n"
"{\n"
"return DAV_COPY_INT (path, destination, overwrite, permissions, uid, gid, auth_uname, auth_pwd, 1);\n"
"}\n"
"--src dav_api.sql:3678\n"
;

static const char *proc188 = 
"#line 3695 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_COPY_INT (\n"
"in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in ouid integer := null,\n"
"in ogid integer := null )\n"
"{\n"
"declare id, d_id, dp_id, rc integer;\n"
"declare auth_uid integer;\n"
"declare st, dp_det char;\n"
"declare sar, dar, prop_list, tag_list any;\n"
"whenever sqlstate \'HT507\' goto insufficient_storage;\n"
"whenever sqlstate \'HT508\' goto disabled_owner;\n"
"whenever sqlstate \'HT509\' goto disabled_home;\n"
"\n"
"if (IS_REDIRECT_REF(path))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"\n"
"sar := split_and_decode (path, 0, \'\\0\\0/\');\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"\n"
"if (aref (sar, 0) <> \'\')\n"
"return -1;\n"
"\n"
"if (aref (sar, length (sar) - 1) = \'\')\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"\n"
"if (aref (dar, 0) <> \'\')\n"
"return -2;\n"
"\n"
"if (aref (dar, length (dar) - 1) = \'\')\n"
"{\n"
"if (st = \'R\')\n"
"{\n"
"destination := concat (destination, sar[length (sar)-1]);\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"}\n"
"}\n"
"else if (st = \'C\')\n"
"{\n"
"return -4;\n"
"}\n"
"id := DAV_SEARCH_ID (sar, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"d_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (dar, st));\n"
"if (d_id is null)\n"
"{\n"
"if (DAV_HIDE_ERROR (dp_id) is null)\n"
"return -2;\n"
"}\n"
"else\n"
"{\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"}\n"
"if (d_id is not null and not overwrite)\n"
"return -3;\n"
"\n"
"if (d_id is not null and (id = d_id))\n"
"return -2;\n"
"\n"
"\n"
"if (ouid is null)\n"
"DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"\n"
"\n"
"if (extern)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (id, st, \'1__\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"if (d_id is not null)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (d_id, st, \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (dp_id, \'C\', \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := ouid;\n"
"}\n"
"\n"
"if ((\'C\' = st) and DAV_HIDE_ERROR (DAV_SEARCH_ID (subseq (dar, 0, length (dar) - 1), \'R\')) is not null)\n"
"{\n"
"\n"
"return -25;\n"
"}\n"
"if ((\'R\' = st) and DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (dar, vector (\'\')), \'C\')) is not null)\n"
"{\n"
"\n"
"return -26;\n"
"}\n"
"if ((\'C\' = st) and destination between path and DAV_COL_PATH_BOUNDARY (path))\n"
"return -30;\n"
"\n"
"if (check_locks)\n"
"{\n"
"declare auto_version varchar;\n"
"\n"
"auto_version := case when (st = \'R\') then DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT(d_id, \'R\', \'DAV:auto-version\', 0)) else null end;\n"
"if (auto_version <> \'DAV:locked-checkout\')\n"
"{\n"
"if (0 <> (rc := DAV_IS_LOCKED (id , st, check_locks)))\n"
"return rc;\n"
"if (d_id is null)\n"
"rc := DAV_IS_LOCKED (dp_id , \'C\', check_locks);\n"
"else\n"
"rc := DAV_IS_LOCKED (d_id , st, check_locks);\n"
"if (0 <> rc)\n"
"return (case when rc = -8 then -9 else rc end);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_IS_LOCKED (d_id , st, check_locks);\n"
"if (rc = -8)\n"
"{\n"
"rc := DAV_CHECKOUT_INT (d_id, null, null, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"else if (0 <> rc)\n"
"return rc;\n"
"}\n"
"}\n"
"\n"
"if (isarray (dp_id))\n"
"{\n"
"dp_det := dp_id[0];\n"
"}\n"
"else\n"
"{\n"
"dp_det := (select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = dp_id);\n"
"}\n"
"if (dp_det is not null)\n"
"{\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"\n"
"DAV_SEARCH_ID_OR_DET (dar, st, dp_det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (dp_det as varchar) || \'_DAV_RES_UPLOAD_COPY\') (detcol_id, unreached_path, id, st, overwrite, permissions, ouid, ogid, auth_uid, auth_uname, auth_pwd, extern, check_locks);\n"
"}\n"
"\n"
"if (st = \'R\')\n"
"{\n"
"declare newid integer;\n"
"\n"
"if (d_id is not null)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_CONTENT = rcnt,\n"
"RES_TYPE = rt,\n"
"RES_OWNER = ouid,\n"
"RES_GROUP = ogid,\n"
"RES_PERMS = permissions,\n"
"RES_MOD_TIME = now ()\n"
"where RES_ID = d_id;\n"
"\n"
"DB.DBA.DAV_DET_PROPS_REMOVE (id[0], d_id, \'R\');\n"
"}\n"
"else\n"
"for select RES_TYPE as rt, RES_CONTENT as rcnt, RES_SIZE as rsize from WS.WS.SYS_DAV_RES where RES_ID = id do\n"
"{\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_CONTENT = rcnt,\n"
"RES_TYPE = rt,\n"
"RES_OWNER = ouid,\n"
"RES_GROUP = ogid,\n"
"RES_PERMS = permissions,\n"
"RES_MOD_TIME = now (),\n"
"RES_SIZE = rsize\n"
"where RES_ID = d_id;\n"
"}\n"
"newid := d_id;\n"
"}\n"
"else\n"
"{\n"
"declare rname varchar;\n"
"\n"
"rname := aref (dar, length (dar)-1);\n"
"if (rname = \'\')\n"
"return -2;\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"newid := DB.DBA.DAV_RES_UPLOAD_STRSES_INT (destination, rcnt, rt, permissions, ouid, ogid, extern=>0, check_locks=>check_locks);\n"
"}\n"
"else\n"
"{\n"
"for (select RES_TYPE as rt, RES_CONTENT as rcnt, RES_NAME as mname from WS.WS.SYS_DAV_RES where RES_ID = id) do\n"
"{\n"
"newid := DB.DBA.DAV_RES_UPLOAD_STRSES_INT (destination, rcnt, rt, permissions, ouid, ogid, extern=>0, check_locks=>check_locks);\n"
"}\n"
"}\n"
"}\n"
"DB.DBA.DAV_COPY_PROPS (0, id, \'R\', destination, auth_uname, auth_pwd, extern, auth_uid);\n"
"DB.DBA.DAV_COPY_TAGS (id, \'R\', newid);\n"
"}\n"
"else if (st = \'C\')\n"
"{\n"
"declare newid integer;\n"
"\n"
"if (dar[length (dar)-1] <> \'\')\n"
"return -2;\n"
"\n"
"if (dar[length (dar)-2] = \'\')\n"
"return -2;\n"
"\n"
"if (isarray (id) and (id[0] like \'%CatFilter\'))\n"
"return -39;\n"
"\n"
"if (d_id is not null)\n"
"{\n"
"declare rrc integer;\n"
"\n"
"rrc := DAV_DELETE_INT (destination, 0, auth_uname, auth_pwd, 0);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"newid := DAV_COL_CREATE_INT (destination, permissions, uid, gid, auth_uname, auth_pwd, 0, 0, 0, ouid, ogid);\n"
"if (DAV_HIDE_ERROR (newid) is null)\n"
"{\n"
"rollback work;\n"
"return newid;\n"
"}\n"
"DB.DBA.DAV_COPY_PROPS (0, id, \'C\', destination, auth_uname, auth_pwd, extern, auth_uid);\n"
"DB.DBA.DAV_COPY_SUBTREE (id , newid, sar, destination, 1, ouid, ogid, auth_uname, auth_pwd, extern, check_locks, auth_uid);\n"
"}\n"
"return 1;\n"
"\n"
"insufficient_storage:\n"
"return -41;\n"
"disabled_owner:\n"
"return -42;\n"
"disabled_home:\n"
"return -43;\n"
"}\n"
"--src dav_api.sql:3693\n"
;

static const char *proc189 = 
"#line 3971 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_COPY_SUBTREE (\n"
"in src any,\n"
"in dst any,\n"
"in sar any,\n"
"in dar any,\n"
"in overwrite integer,\n"
"in ouid integer := null,\n"
"in ogid integer := null,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in auth_uid integer ) returns any\n"
"{\n"
"\n"
"declare dirlist, ret, rc any;\n"
"\n"
"vectorbld_init (ret);\n"
"dirlist := DAV_DIR_LIST_INT (DAV_CONCAT_PATH (\'/\', sar), 0, \'%\', NULL, NULL, auth_uid);\n"
"foreach (any res in dirlist) do\n"
"{\n"
"if (\'R\' = res[1])\n"
"{\n"
"declare target_path varchar;\n"
"\n"
"target_path := DAV_CONCAT_PATH (dar, res[10]);\n"
"if (extern)\n"
"{\n"
"rc := DAV_AUTHENTICATE (res[4], \'R\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"goto _r_error;\n"
"}\n"
"rc := DAV_COPY_INT (res[0], target_path, overwrite, res[5], res[7], res[6], auth_uname, auth_pwd, extern, check_locks, ouid, ogid );\n"
"_r_error:;\n"
"vectorbld_acc (ret, vector (res[0], target_path, rc));\n"
"}\n"
"}\n"
"foreach (any res in dirlist) do\n"
"{\n"
"if (\'C\' = res[1])\n"
"{\n"
"declare target_path varchar;\n"
"declare new_tgt_id integer;\n"
"\n"
"target_path := DAV_CONCAT_PATH (dar, res[10]) || \'/\';\n"
"if (isarray (res[4]) and (res[4][0] like \'%CatFilter\'))\n"
"{\n"
"vectorbld_acc (ret, vector (res[0], target_path, -39));\n"
"}\n"
"else\n"
"{\n"
"if (extern)\n"
"{\n"
"rc := DAV_AUTHENTICATE (res[4], \'C\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"goto _c_error;\n"
"}\n"
"new_tgt_id := DAV_COL_CREATE_INT (target_path, res[5], res[7], res[6], auth_uname, auth_pwd, 0, extern, check_locks, ouid, ogid);\n"
"vectorbld_acc (ret, vector (res[0], target_path, new_tgt_id));\n"
"if (DAV_HIDE_ERROR (new_tgt_id) is not null)\n"
"{\n"
"DB.DBA.DAV_COPY_PROPS (0, res[4], res[1], new_tgt_id, auth_uname, auth_pwd, extern, auth_uid);\n"
"}\n"
"rc := DAV_COPY_SUBTREE (res[4], new_tgt_id, res[0], target_path, overwrite, ouid, ogid, auth_uname, auth_pwd, extern, check_locks, auth_uid);\n"
"vectorbld_concat_acc (ret, rc);\n"
"}\n"
"_c_error:;\n"
"}\n"
"}\n"
"vectorbld_final (ret);\n"
"return ret;\n"
"}\n"
"--src dav_api.sql:3969\n"
;

static const char *proc190 = 
"#line 4047 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_MOVE (\n"
"in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar)\n"
"{\n"
"return DAV_MOVE_INT (path, destination, overwrite, auth_uname, auth_pwd, 1);\n"
"}\n"
"--src dav_api.sql:4045\n"
;

static const char *proc191 = 
"#line 4059 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_MOVE_INT (\n"
"in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1 )\n"
"{\n"
"\n"
"declare id, d_id, dp_id, rc integer;\n"
"declare auth_uid integer;\n"
"declare st, dp_det char;\n"
"declare sar, dar, prop_list any;\n"
"whenever sqlstate \'HT507\' goto insufficient_storage;\n"
"whenever sqlstate \'HT508\' goto disabled_owner;\n"
"whenever sqlstate \'HT509\' goto disabled_home;\n"
"\n"
"sar := split_and_decode (path, 0, \'\\0\\0/\');\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"\n"
"if (aref (sar, 0) <> \'\')\n"
"return -1;\n"
"\n"
"if (aref (sar, length (sar) - 1) = \'\')\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"\n"
"if (aref (dar, 0) <> \'\')\n"
"return -2;\n"
"\n"
"if (aref (dar, length (dar) - 1) = \'\')\n"
"{\n"
"if (st = \'R\')\n"
"{\n"
"destination := concat (destination, sar[length (sar)-1]);\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (st = \'C\')\n"
"return -4;\n"
"}\n"
"\n"
"id := DAV_SEARCH_ID (sar, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"d_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (dar, st));\n"
"if (d_id is null)\n"
"{\n"
"if (DAV_HIDE_ERROR (dp_id) is null)\n"
"return -2;\n"
"}\n"
"else\n"
"{\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"}\n"
"if (d_id is not null and not overwrite)\n"
"return -3;\n"
"\n"
"if (d_id is not null and id = d_id)\n"
"return -2;\n"
"\n"
"\n"
"if (extern)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"if (d_id is not null)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (d_id, st, \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (dp_id, \'C\', \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := http_nobody_uid ();\n"
"}\n"
"\n"
"if ((\'C\' = st) and DAV_HIDE_ERROR (DAV_SEARCH_ID (subseq (dar, 0, length (dar) - 1), \'R\')) is not null)\n"
"{\n"
"\n"
"return -25;\n"
"}\n"
"if ((\'R\' = st) and (0 = overwrite) and DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (dar, vector (\'\')), \'C\')) is not null)\n"
"{\n"
"\n"
"return -26;\n"
"}\n"
"if ((\'C\' = st) and destination between path and DAV_COL_PATH_BOUNDARY (path))\n"
"return -30;\n"
"\n"
"if (check_locks)\n"
"{\n"
"if (0 <> (rc := DAV_IS_LOCKED (id , st, check_locks)))\n"
"return rc;\n"
"\n"
"if (d_id is null)\n"
"rc := DAV_IS_LOCKED (dp_id , \'C\', check_locks);\n"
"else\n"
"rc := DAV_IS_LOCKED (d_id , st, check_locks);\n"
"\n"
"if (0 <> rc)\n"
"return (case when rc = -8 then -9 else rc end);\n"
"}\n"
"\n"
"if (isarray (dp_id))\n"
"{\n"
"dp_det := dp_id[0];\n"
"}\n"
"else\n"
"{\n"
"dp_det := (select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = dp_id);\n"
"}\n"
"if (dp_det is not null)\n"
"{\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"\n"
"DAV_SEARCH_ID_OR_DET (dar, st, dp_det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (dp_det as varchar) || \'_DAV_RES_UPLOAD_MOVE\') (detcol_id, unreached_path, id, st, overwrite, auth_uid, auth_uname, auth_pwd, extern, check_locks);\n"
"}\n"
"\n"
"if (st = \'R\')\n"
"{\n"
"\n"
"if (d_id is not null)\n"
"{\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"declare dirsingle any;\n"
"\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'R\', path, auth_uid);\n"
"if (isinteger (dirsingle))\n"
"{\n"
"signal (\'.....\', sprintf (\'DAV_DIR_SINGLE failed during DAV_MOVE\'));\n"
"return -100;\n"
"}\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_CONTENT = rcnt,\n"
"RES_TYPE = rt,\n"
"RES_OWNER = dirsingle[7],\n"
"RES_GROUP = dirsingle[6],\n"
"RES_PERMS = dirsingle[5],\n"
"RES_MOD_TIME = now ()\n"
"where RES_ID = d_id;\n"
"\n"
"rc := DAV_DELETE_INT (path, 1, null, null, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"else\n"
"{\n"
"declare pid, rldp, nldp integer;\n"
"declare rname, rpath, rldp, npath varchar;\n"
"\n"
"select RES_NAME\n"
"into rname\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = d_id;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = d_id;\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = d_id;\n"
"\n"
"rpath := DB.DBA.DAV_SEARCH_PATH (id, \'R\');\n"
"pid := DB.DBA.DAV_SEARCH_ID (rpath, \'P\');\n"
"rldp := DB.DBA.LDP_ENABLED (pid);\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_COL = dp_id,\n"
"RES_NAME = rname,\n"
"RES_MOD_TIME = now ()\n"
"where RES_ID = id;\n"
"npath := DB.DBA.DAV_SEARCH_PATH (id, \'R\');\n"
"nldp := DB.DBA.LDP_ENABLED (dp_id);\n"
"DB.DBA.LDP_RENAME (\'R\', rpath, npath, rldp, nldp);\n"
"if (DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (id)))\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = DB.DBA.DAV_DET_DAV_ID (id);\n"
"\n"
"update WS.WS.SYS_DAV_LOCK set LOCK_PARENT_ID = id where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = d_id;\n"
"\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare rname varchar;\n"
"\n"
"rname := aref (dar, length (dar)-1);\n"
"if (rname = \'\')\n"
"return -3;\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"declare newid integer;\n"
"declare dirsingle any;\n"
"\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'R\', path, auth_uid);\n"
"if (isinteger (dirsingle))\n"
"{\n"
"signal (\'.....\', sprintf (\'DAV_DIR_SINGLE failed during DAV_MOVE\'));\n"
"return -100;\n"
"}\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"newid := DB.DBA.DAV_RES_UPLOAD_STRSES_INT (destination, rcnt, rt, dirsingle[5], dirsingle[7], dirsingle[6], extern=>0, check_locks=>check_locks);\n"
"rc := DAV_DELETE_INT (path, 1, null, null, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"if (DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (id)))\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = DB.DBA.DAV_DET_DAV_ID (id);\n"
"}\n"
"else\n"
"{\n"
"declare pid, rldp, nldp integer;\n"
"declare rpath, npath varchar;\n"
"\n"
"rpath := DB.DBA.DAV_SEARCH_PATH (id, \'R\');\n"
"pid := DB.DBA.DAV_SEARCH_ID (rpath, \'P\');\n"
"rldp := DB.DBA.LDP_ENABLED (pid);\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_COL = dp_id,\n"
"RES_NAME = rname,\n"
"RES_MOD_TIME = now ()\n"
"where RES_ID = id;\n"
"npath := DB.DBA.DAV_SEARCH_PATH (id, \'R\');\n"
"nldp := DB.DBA.LDP_ENABLED (dp_id);\n"
"DB.DBA.LDP_RENAME (\'R\', rpath, npath, rldp, nldp);\n"
"if (DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (id)))\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = DB.DBA.DAV_DET_DAV_ID (id);\n"
"}\n"
"\n"
"\n"
"}\n"
"DB.DBA.DAV_COPY_PROPS (1, id, st, destination, auth_uname, auth_pwd, extern, auth_uid);\n"
"}\n"
"else if (st = \'C\')\n"
"{\n"
"declare rname varchar;\n"
"\n"
"rname := aref (dar, length (dar)-1);\n"
"if (rname <> \'\')\n"
"return -3;\n"
"\n"
"rname := aref (dar, length (dar)-2);\n"
"if (rname = \'\')\n"
"return -3;\n"
"\n"
"if (not DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (id)))\n"
"return -20;\n"
"\n"
"if (d_id is not null)\n"
"{\n"
"declare rrc integer;\n"
"rrc := DAV_DELETE_INT (destination, 0, auth_uname, auth_pwd, extern=>0, check_locks=>check_locks);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare dirsingle any;\n"
"\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'C\', path, auth_uid);\n"
"if (isinteger (dirsingle))\n"
"{\n"
"signal (\'.....\', sprintf (\'DAV_DIR_SINGLE failed during DAV_MOVE\'));\n"
"return -100;\n"
"}\n"
"d_id := DAV_COL_CREATE_INT (destination, dirsingle[5], dirsingle[7], dirsingle[6], auth_uname, auth_pwd, 0, 0, 0);\n"
"if (DAV_HIDE_ERROR (d_id) is null)\n"
"{\n"
"rollback work;\n"
"return d_id;\n"
"}\n"
"DB.DBA.DAV_COPY_PROPS (0, id, \'C\', destination, auth_uname, auth_pwd, extern, auth_uid);\n"
"DB.DBA.DAV_COPY_SUBTREE (id , d_id, sar, destination, 1, dirsingle[7], dirsingle[6], auth_uname, auth_pwd, extern, check_locks, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare rldp, nldp integer;\n"
"declare rpath, npath varchar;\n"
"\n"
"rpath := DB.DBA.DAV_SEARCH_PATH (id, \'C\');\n"
"rldp := DB.DBA.LDP_ENABLED (id);\n"
"update WS.WS.SYS_DAV_COL\n"
"set COL_NAME = rname,\n"
"COL_PARENT = dp_id,\n"
"COL_MOD_TIME = now ()\n"
"where COL_ID = id;\n"
"npath := DB.DBA.DAV_SEARCH_PATH (id, \'C\');\n"
"nldp := DB.DBA.LDP_ENABLED (id);\n"
"DB.DBA.LDP_RENAME (\'C\', rpath, npath, rldp, nldp);\n"
"}\n"
"\n"
"rc := DAV_DELETE_INT (path, 1, null, null, extern=>0, check_locks=>check_locks);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = DB.DBA.DAV_DET_DAV_ID (id);\n"
"update WS.WS.SYS_DAV_LOCK set LOCK_PARENT_ID = id where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = d_id;\n"
"}\n"
"return 1;\n"
"\n"
"insufficient_storage:\n"
"return -41;\n"
"\n"
"disabled_owner:\n"
"return -42;\n"
"\n"
"disabled_home:\n"
"return -43;\n"
"}\n"
"--src dav_api.sql:4057\n"
;

static const char *proc192 = 
"#line 4394 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_COPY_PROPS (\n"
"in mode integer,\n"
"in src any,\n"
"in what char(1),\n"
"in dst any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in auth_uid integer := null)\n"
"{\n"
"\n"
"declare det varchar;\n"
"declare dst_id, props any;\n"
"\n"
"if (isstring (dst))\n"
"{\n"
"dst_id := DB.DBA.DAV_SEARCH_ID (dst, what);\n"
"}\n"
"else if (isarray (dst))\n"
"{\n"
"dst_id := dst;\n"
"dst := DB.DBA.DAV_SEARCH_PATH (dst_id, what);\n"
"}\n"
"det := case when (isarray (src)) then src[0] else \'\' end;\n"
"props := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_PROP_LIST_INT (src, what, \'%\', extern, auth_uname, auth_pwd), vector ());\n"
"foreach (any prop in props) do\n"
"{\n"
"if (mode and (prop[0] in (\'DAV:checked-in\', \'DAV:checked-out\', \'DAV:version-history\')))\n"
"goto _skip;\n"
"\n"
"if ((det <> \'\') and ((prop[0] like (\'virt:\' || det || \'%\')) or (prop[0] = \'virt:DETCOL_ID\')))\n"
"goto _skip;\n"
"\n"
"if (isarray (dst_id))\n"
"{\n"
"call (cast (dst_id[0] as varchar) || \'_DAV_PROP_SET\') (dst_id, what, prop[0], prop[1], 0, auth_uid);;\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_PROP_SET_RAW (dst_id, what, prop[0], prop[1], 0, auth_uid);\n"
"}\n"
"_skip:;\n"
"}\n"
"}\n"
"--src dav_api.sql:4392\n"
;

static const char *proc193 = 
"#line 4440 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_COPY_TAGS (\n"
"in src any,\n"
"in what char(1),\n"
"in dst any)\n"
"{\n"
"\n"
"declare tags any;\n"
"\n"
"if (not DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (src)))\n"
"return;\n"
"\n"
"if (isstring (dst))\n"
"dst := DB.DBA.DAV_SEARCH_ID (dst, what);\n"
"\n"
"if (not DB.DBA.DAV_DET_IS_WEBDAV_BASED (DB.DBA.DAV_DET_NAME (dst)))\n"
"return;\n"
"\n"
"tags := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_TAG_LIST (src, what, null), vector ());\n"
"foreach (any tag in tags) do\n"
"{\n"
"DB.DBA.DAV_TAG_SET (dst, what, tag[0], tag[1]);\n"
"}\n"
"}\n"
"--src dav_api.sql:4438\n"
;

static const char *proc194 = 
"#line 4465 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_GET_OWNER (in id any, in st char(1)) returns integer\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"declare diritm any;\n"
"\n"
"diritm := DAV_DIR_SINGLE_INT (id, st, \'\', null, null, http_dav_uid ());\n"
"if (DAV_HIDE_ERROR (diritm) is null)\n"
"return diritm;\n"
"\n"
"return diritm [7];\n"
"}\n"
"if (\'C\' = st)\n"
"return coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = id), -1);\n"
"\n"
"if (\'R\' = st)\n"
"return coalesce ((select RES_OWNER from WS.WS.SYS_DAV_RES where RES_ID = id), -1);\n"
"\n"
"return -14;\n"
"}\n"
"--src dav_api.sql:4463\n"
;

static const char *proc195 = 
"#line 4489 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_PREPARE_PROP_WRITE (\n"
"in path varchar,\n"
"out id any,\n"
"out st varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"inout auth_uid integer,\n"
"in extern integer,\n"
"out auto_version varchar,\n"
"inout check_locks any,\n"
"out locked integer) returns integer\n"
"{\n"
"declare rc integer;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"id := DAV_SEARCH_ID (path, st);\n"
"\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"return id;\n"
"}\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid >= 0)\n"
"goto auth_uid_ok;\n"
"if ((auth_uid = -13) and (propname = \':virtprivatetags\'))\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid >= 0)\n"
"goto auth_uid_ok;\n"
"}\n"
"if ((auth_uid = -13) and (propname in (\':virtpermissions\', \':virtowneruid\', \':virtownergid\', \':virtacl\')))\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'___\', auth_uname, auth_pwd);\n"
"if (auth_uid >= 0)\n"
"goto auth_uid_ok;\n"
"}\n"
"return auth_uid;\n"
"}\n"
"else if (auth_uid is null)\n"
"auth_uid := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = auth_uname), http_nobody_uid());\n"
"\n"
"auth_uid_ok:\n"
"auto_version := DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT(DAV_SEARCH_ID (path, \'R\'), \'R\', \'DAV:auto-version\', 0));\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (id , st, check_locks);\n"
"if (rc < 0)\n"
"locked := 1;\n"
"else\n"
"locked := 0;\n"
"if (rc = -8 and (auto_version = \'DAV:checkout-unlocked-checkin\'))\n"
"rc := 0;\n"
"else if (rc = -8 and (auto_version = \'DAV:locked-checkout\'))\n"
"rc := 0;\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"if (\n"
"((propname like \'xml-stylesheet%\') or (propname like \'xml-sql%\')) and\n"
"((auth_uid <> 0) and (auth_uid <> http_dav_uid())) )\n"
"{\n"
"set isolation=\'committed\';\n"
"if (not exists (\n"
"select top 1 1 from DB.DBA.SYS_USERS\n"
"where U_ID = auth_uid and U_DAV_ENABLE and U_SQL_ENABLE\n"
"and not U_ACCOUNT_DISABLED ) )\n"
"return -32;\n"
"if (DAV_GET_OWNER (id, st) <> auth_uid)\n"
"return -32;\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:4487\n"
;

static const char *proc196 = 
"#line 4571 \"[executable]/dav_api.sql\"\n"
" create procedure\n"
"DAV_PROP_SET (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in propvalue any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in overwrite integer := 0 )\n"
"{\n"
"return DAV_PROP_SET_INT (path, propname, propvalue, auth_uname, auth_pwd, 1, 1, overwrite);\n"
"}\n"
"--src dav_api.sql:4569\n"
;

static const char *proc197 = 
"#line 4584 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_PROP_SET_INT (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in propvalue any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in overwrite integer := 0,\n"
"in auth_uid integer := null ) returns integer\n"
"{\n"
"declare id, rc, pid integer;\n"
"declare st, det varchar;\n"
"declare locked integer;\n"
"declare auto_version varchar;\n"
"\n"
"rc := DAV_PREPARE_PROP_WRITE (path, id, st, propname, auth_uname, auth_pwd, auth_uid, extern, auto_version, check_locks, locked);\n"
"\n"
"if (rc < 0)\n"
"return rc;\n"
"if (isarray (id))\n"
"{\n"
"pid := call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, st, propname, propvalue, overwrite, auth_uid);\n"
"return pid;\n"
"}\n"
"return DAV_PROP_SET_RAW (id, st, propname, propvalue, overwrite, auth_uid, locked, auto_version);\n"
"}\n"
"--src dav_api.sql:4582\n"
;

static const char *proc198 = 
"#line 4614 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_PROP_SET_RAW (\n"
"inout id integer,\n"
"in st char(0),\n"
"inout propname varchar,\n"
"inout propvalue any,\n"
"in overwrite integer,\n"
"in auth_uid integer,\n"
"in locked int:=0,\n"
"in auto_version varchar:=NULL\n"
") returns integer\n"
"{\n"
"declare rc, old_log_mode, new_log_mode any;\n"
"old_log_mode := log_enable (null);\n"
"\n"
"new_log_mode := bit_and (old_log_mode, 1);\n"
"old_log_mode := log_enable (bit_or (new_log_mode, 4), 1);\n"
"rc := DAV_PROP_SET_RAW_INNER (id, st, propname, propvalue, overwrite, auth_uid, locked, auto_version);\n"
"log_enable (bit_or (old_log_mode, 4), 1);\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:4612\n"
;

static const char *proc199 = 
"#line 4637 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_PROP_SET_RAW_INNER (\n"
"inout id integer,\n"
"in st char(0),\n"
"inout propname varchar,\n"
"inout propvalue any,\n"
"in overwrite integer,\n"
"in auth_uid integer,\n"
"in locked int:=0,\n"
"in auto_version varchar:=NULL\n"
") returns integer\n"
"{\n"
"declare pid integer;\n"
"declare can_patch_access integer;\n"
"declare _owner, _creator any;\n"
"\n"
"if (58 = propname[0])\n"
"{\n"
"if (\':getlastmodified\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_MOD_TIME = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_MOD_TIME = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':creationdate\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_CR_TIME = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_CR_TIME = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':addeddate\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_ADD_TIME = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_ADD_TIME = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':getcontenttype\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_TYPE = propvalue where RES_ID = id;\n"
"else\n"
"return -10;\n"
"return 0;\n"
"}\n"
"\n"
"if (auth_uid = http_dav_uid ())\n"
"can_patch_access := 2;\n"
"else if (\'R\' = st)\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = id and RES_OWNER = auth_uid), 0);\n"
"else\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_COL where COL_ID = id and COL_OWNER = auth_uid), 0);\n"
"\n"
"if (\':virtowneruid\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"\n"
"if (not exists (select top 1 1 from WS.WS.SYS_DAV_USER where U_ID = propvalue))\n"
"propvalue := http_dav_uid ();\n"
"\n"
"if (\'R\' = st)\n"
"{\n"
"select RES_OWNER, RES_CREATOR into _owner, _creator from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"if (_owner <> propvalue)\n"
"{\n"
"if (isnull (_creator))\n"
"_creator := iri_to_id (DB.DBA.DAV_DET_USER_IRI (_owner));\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_OWNER = propvalue, RES_CREATOR = _creator where RES_ID = id;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"select COL_OWNER, COL_CREATOR into _owner, _creator from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"if (_owner <> propvalue)\n"
"{\n"
"if (isnull (_creator))\n"
"_creator := iri_to_id (DB.DBA.DAV_DET_USER_IRI (_owner));\n"
"\n"
"update WS.WS.SYS_DAV_COL set COL_OWNER = propvalue, COL_CREATOR = _creator where COL_ID = id;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"if (\':virtownergid\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (not exists (select top 1 1 from WS.WS.SYS_DAV_GROUP where G_ID = propvalue) and not exists (select top 1 1 from WS.WS.SYS_DAV_USER where U_ID = propvalue))\n"
"propvalue := http_admin_gid ();\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_GROUP = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_GROUP = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtpermissions\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if ((propvalue like \'__1%\' or propvalue like \'_____1%\' or propvalue like \'________1%\') and auth_uid <> http_dav_uid ())\n"
"return -10;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_PERM (), propvalue) is null)\n"
"return -17;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtacl\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_ACL = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_ACL = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdet\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdetmount\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdetmountable\' = propname)\n"
"{\n"
"return -10;\n"
"}\n"
"if (\':virtprivatetags\' = propname)\n"
"{\n"
"if (\'R\' <> st)\n"
"return -14;\n"
"if (auth_uid = http_nobody_uid())\n"
"return -16;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid))\n"
"{\n"
"if (not overwrite)\n"
"return -16;\n"
"update WS.WS.SYS_DAV_TAG set DT_TAGS = propvalue where DT_RES_ID = id and DT_U_ID = auth_uid;\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_TAG (DT_RES_ID, DT_U_ID, DT_FT_ID, DT_TAGS)\n"
"values (id, auth_uid, WS.WS.GETID (\'T\'), propvalue);\n"
"}\n"
"return 0;\n"
"}\n"
"if (\':virtpublictags\' = propname)\n"
"{\n"
"if (\'R\' <> st)\n"
"return -14;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid()))\n"
"{\n"
"if (not overwrite)\n"
"return -16;\n"
"update WS.WS.SYS_DAV_TAG set DT_TAGS = propvalue where DT_RES_ID = id and DT_U_ID = http_nobody_uid();\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_TAG (DT_RES_ID, DT_U_ID, DT_FT_ID, DT_TAGS)\n"
"values (id, http_nobody_uid(), WS.WS.GETID (\'T\'), propvalue);\n"
"}\n"
"return 0;\n"
"}\n"
"return -16;\n"
"}\n"
"\n"
"if ((not overwrite) and exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = st))\n"
"return -16;\n"
"\n"
"if (not isstring (propname) or (propname in (\'creationdate\', \'getcontentlength\', \'getcontenttype\', \'getetag\', \'getlastmodified\', \'lockdiscovery\', \'resourcetype\', \'activelock\', \'supportedlock\')))\n"
"return -10;\n"
"\n"
"if (__tag (propvalue) = 193)\n"
"propvalue := serialize (propvalue);\n"
"else if (not isstring (propvalue))\n"
"return -17;\n"
"\n"
"pid := WS.WS.GETID (\'P\');\n"
"\n"
"if ((propname not like \'DAV:%\')\n"
"and (propname not like \'virt:%\')\n"
"and (propname[0] <> 58))\n"
"{\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"{\n"
"\n"
"return -38;\n"
"}\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, \'R\', \'DAV:checked-out\', 0)) is not null)\n"
"{\n"
"if ((locked and (auto_version = \'DAV:checkout-unlocked-checkin\')) or\n"
"(auto_version = \'DAV:checkout\') or\n"
"(locked and (auto_version = \'DAV:locked-checkout\')))\n"
"{\n"
"declare _res int;\n"
"_res := DAV_CHECKOUT_INT (id, null, null, 0);\n"
"if (_res < 0)\n"
"return _res;\n"
"}\n"
"}\n"
"}\n"
"\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = propvalue where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = st;\n"
"if (row_count() = 0)\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (pid, propname, propvalue, id, st);\n"
"}\n"
"return pid;\n"
"}\n"
"--src dav_api.sql:4635\n"
;

static const char *proc200 = 
"#line 4873 \"[executable]/dav_api.sql\"\n"
" create procedure\n"
"DAV_PROP_REMOVE (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"return DAV_PROP_REMOVE_INT (path, propname, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:4871\n"
;

static const char *proc201 = 
"#line 4884 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_PROP_REMOVE_INT (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in ignore_if_missing integer := 0,\n"
"in auth_uid integer := null ) returns integer\n"
"{\n"
"declare id, rc, pid integer;\n"
"declare st, det varchar;\n"
"declare locked int;\n"
"declare auto_version varchar;\n"
"\n"
"rc := DAV_PREPARE_PROP_WRITE (path, id, st, propname, auth_uname, auth_pwd, auth_uid, extern, auto_version, check_locks, locked);\n"
"\n"
"if (rc < 0)\n"
"return rc;\n"
"if (isarray (id))\n"
"{\n"
"pid := call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, st, propname, ignore_if_missing, auth_uid);\n"
"return pid;\n"
"}\n"
"return DAV_PROP_REMOVE_RAW (id, st, propname, ignore_if_missing, auth_uid, locked, auto_version);\n"
"}\n"
"--src dav_api.sql:4882\n"
;

static const char *proc202 = 
"#line 4914 \"[executable]/dav_api.sql\"\n"
"create function\n"
"DAV_PROP_REMOVE_RAW (\n"
"inout id integer,\n"
"in st char(0),\n"
"inout propname varchar,\n"
"in ignore_if_missing integer,\n"
"in auth_uid integer,\n"
"in locked int:=0,\n"
"in auto_version varchar:=NULL\n"
") returns integer\n"
"{\n"
"declare pid integer;\n"
"declare can_patch_access integer;\n"
"if (58 = propname[0])\n"
"{\n"
"if (propname in (\':getlastmodified\', \':creationdate\', \':addeddate\', \':getcontenttype\', \':virtowneruid\', \':virtownergid\', \':virtpermissions\', \':virtdetmountable\', \':virtpubliclink\'))\n"
"return -10;\n"
"if (auth_uid = http_dav_uid())\n"
"can_patch_access := 2;\n"
"\n"
"\n"
"else\n"
"if (\'R\' = st)\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = id and RES_OWNER = auth_uid), 0);\n"
"else\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_COL where COL_ID = id and COL_OWNER = auth_uid), 0);\n"
"if (\':virtacl\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_ACL = NULL where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_ACL = NULL where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdet\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = NULL where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdetmount\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = NULL where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtprivatetags\' = propname)\n"
"{\n"
"if ((\'R\' <> st) or (auth_uid = http_nobody_uid()) or (not exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid)))\n"
"goto nosuchprop;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid;\n"
"return 0;\n"
"}\n"
"if (\':virtpublictags\' = propname)\n"
"{\n"
"if ((\'R\' <> st) or (not exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid())))\n"
"goto nosuchprop;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid();\n"
"return 0;\n"
"}\n"
"return -16;\n"
"}\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id\n"
"and PROP_TYPE = st))\n"
"{\n"
"goto nosuchprop;\n"
"}\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = st;\n"
"return 0;\n"
"nosuchprop:\n"
"if (ignore_if_missing)\n"
"return 0;\n"
"else\n"
"return -11;\n"
"}\n"
"--src dav_api.sql:4912\n"
;

static const char *proc203 = 
"#line 5004 \"[executable]/dav_api.sql\"\n"
" create procedure\n"
"DAV_PROP_GET (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null) returns any\n"
"{\n"
"declare st varchar;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"return DAV_PROP_GET_INT (DAV_SEARCH_ID (path, st), st, propname, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:5002\n"
;

static const char *proc204 = 
"#line 5021 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_PROP_GET_INT (\n"
"in id any,\n"
"in what char(0),\n"
"in propname varchar,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in auth_uid integer := null ) returns any\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare ret any;\n"
"\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -1;\n"
"\n"
"if (propname is null)\n"
"return -11;\n"
"\n"
"if (not (isstring (propname)))\n"
"propname := cast (propname as varchar);\n"
"\n"
"if (\'\' = propname)\n"
"return -11;\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, what, \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"\n"
"if (propname[0] = 58)\n"
"{\n"
"declare idx integer;\n"
"\n"
"idx := get_keyword (propname,\n"
"vector (\n"
"\':getlastmodified\', 3,\n"
"\':creationdate\', 8,\n"
"\':lastaccessed\', 3,\n"
"\':addeddate\', 10,\n"
"\':getetag\', -1,\n"
"\':getcontenttype\', 9,\n"
"\':getcontentlength\', 2,\n"
"\':resourcetype\', -1,\n"
"\':virtowneruid\', 7,\n"
"\':virtownergid\', 6,\n"
"\':virtpermissions\', 5,\n"
"\':virtacl\', -1,\n"
"\':virtdet\', -1,\n"
"\':virtdetmount\', -1,\n"
"\':virtdetmountable\', -1,\n"
"\':virtpublictags\', -1,\n"
"\':virtprivatetags\', -1,\n"
"\':virttags\', -1,\n"
"\':virtpubliclink\', -1 ) );\n"
"if (idx is null)\n"
"return -11;\n"
"\n"
"if (idx >= 0)\n"
"{\n"
"declare dirsingle any;\n"
"\n"
"dirsingle := DAV_DIR_SINGLE_INT (id, what, \'fake\', auth_uname, auth_pwd, auth_uid, extern);\n"
"if (isarray (dirsingle) and length (dirsingle))\n"
"{\n"
"if ((propname = \':addeddate\') and (length (dirsingle) <= 11))\n"
"idx := 8;\n"
"\n"
"return dirsingle[idx];\n"
"}\n"
"return -1;\n"
"}\n"
"\n"
"if (\':getetag\' = propname)\n"
"{\n"
"if (\'R\' = what)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"declare dirsingle any;\n"
"declare path varchar;\n"
"\n"
"path := DAV_SEARCH_PATH (id, \'R\');\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'R\', path, auth_uid);\n"
"return sprintf (\'%s-%s-%d-%s\', cast (id[1] as varchar), replace (cast (dirsingle[3] as varchar), \' \', \'T\'), dirsingle[2], md5 (path));\n"
"}\n"
"else\n"
"{\n"
"declare name varchar;\n"
"declare col_id integer;\n"
"declare modt any;\n"
"\n"
"select RES_NAME, RES_COL, RES_MOD_TIME into name, col_id, modt from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"return WS.WS.ETAG (name, col_id, modt);\n"
"}\n"
"}\n"
"else\n"
"return null;\n"
"}\n"
"if (\':resourcetype\' = propname)\n"
"{\n"
"if (what = \'C\')\n"
"return xtree_doc (\'<D:collection/>\');\n"
"else\n"
"return null;\n"
"}\n"
"if (\':virtacl\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"if (isinteger (ret) and (ret = -20))\n"
"return (select COL_ACL from WS.WS.SYS_DAV_COL where COL_ID = id[1]);\n"
"\n"
"return ret;\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return (select RES_ACL from WS.WS.SYS_DAV_RES where RES_ID = id);\n"
"else\n"
"return (select COL_ACL from WS.WS.SYS_DAV_COL where COL_ID = id);\n"
"}\n"
"}\n"
"if (\':virtdet\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return coalesce (DAV_HIDE_ERROR (ret), id[0]);\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return null;\n"
"\n"
"return (select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = id);\n"
"}\n"
"}\n"
"if (\':virtdetmount\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return DAV_HIDE_ERROR (ret);\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return null;\n"
"\n"
"return (select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = id);\n"
"}\n"
"}\n"
"if (\':virtdetmountable\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return DAV_HIDE_ERROR (ret);\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return null;\n"
"else\n"
"return \'T\';\n"
"}\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return ret;\n"
"}\n"
"if (\':virtprivatetags\' = propname)\n"
"{\n"
"if ((\'R\' <> what) or (auth_uid = http_nobody_uid()))\n"
"return null;\n"
"\n"
"return (select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid);\n"
"}\n"
"if (\':virtpublictags\' = propname)\n"
"{\n"
"if (\'R\' <> what)\n"
"return null;\n"
"return (select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid());\n"
"}\n"
"if (\':virttags\' = propname)\n"
"{\n"
"if (\'R\' <> what)\n"
"return null;\n"
"\n"
"if (auth_uid = http_nobody_uid())\n"
"return (select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid());\n"
"\n"
"declare pub, priv varchar;\n"
"\n"
"pub := coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid()), \'\');\n"
"priv := coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid), \'\');\n"
"if (pub = \'\')\n"
"return priv;\n"
"\n"
"if (priv = \'\')\n"
"return pub;\n"
"\n"
"return pub || \', \' || priv;\n"
"\n"
"}\n"
"if (\':virtpubliclink\' = propname)\n"
"{\n"
"return WS.WS.DAV_HOST () || DAV_SEARCH_PATH (id, what);\n"
"}\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return ret;\n"
"}\n"
"if (id < 0)\n"
"{\n"
"return id;\n"
"}\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src dav_api.sql:5019\n"
;

static const char *proc205 = 
"#line 5256 \"[executable]/dav_api.sql\"\n"
" create procedure\n"
"DAV_PROP_LIST (\n"
"in path varchar,\n"
"in propmask varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"declare st varchar;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"return DAV_PROP_LIST_INT (DAV_SEARCH_ID (path, st), st, propmask, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:5254\n"
;

static const char *proc206 = 
"#line 5272 \"[executable]/dav_api.sql\"\n"
"create procedure\n"
"DAV_PROP_LIST_INT (\n"
"in id any,\n"
"in what char(0),\n"
"in propmask varchar,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"declare auth_uid, rc integer;\n"
"declare ret any;\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, what, \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_LIST\') (id, what, propmask, auth_uid);\n"
"return ret;\n"
"}\n"
"if (id < 0)\n"
"{\n"
"return id;\n"
"}\n"
"ret := vector ();\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do {\n"
"ret := vector_concat (ret, vector (vector (PROP_NAME, blob_to_string (PROP_VALUE))));\n"
"}\n"
"return ret;\n"
"}\n"
"--src dav_api.sql:5270\n"
;

static const char *proc207 = 
"#line 5311 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_MAKE_DIR (\n"
"in path any,\n"
"in own integer,\n"
"in grp integer,\n"
"in perms varchar)\n"
"{\n"
"declare pat any;\n"
"declare col, len, inx, t_col integer;\n"
"\n"
"pat := split_and_decode (path, 0, \'\\0\\0/\');\n"
"if (length (pat) < 3)\n"
"return null;\n"
"\n"
"if (pat[1] <> \'DAV\' or pat[0] <> \'\')\n"
"signal (\'22023\', \'Not valid path string\');\n"
"\n"
"len := length (pat) - 1;\n"
"inx := 2;\n"
"t_col := 1;\n"
"whenever not found goto nf;\n"
"while (inx < len)\n"
"{\n"
"select COL_ID into col from WS.WS.SYS_DAV_COL where COL_PARENT = t_col and COL_NAME = pat[inx];\n"
"t_col := col;\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"nf:\n"
"while (inx < len)\n"
"{\n"
"col := WS.WS.GETID (\'C\');\n"
"insert into WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_CR_TIME, COL_MOD_TIME, COL_OWNER, COL_GROUP, COL_PERMS)\n"
"values (col, pat[inx], t_col, now (), now (), own, grp, perms);\n"
"\n"
"DB.DBA.LDP_CREATE_COL (WS.WS.COL_PATH (col), t_col);\n"
"inx := inx + 1;\n"
"t_col := col;\n"
"}\n"
"return col;\n"
"}\n"
"--src dav_api.sql:5309\n"
;

static const char *proc208 = 
"#line 5353 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_CHECK_PERM (\n"
"in perm varchar,\n"
"in req varchar,\n"
"in oid integer,\n"
"in ogid integer,\n"
"in pgid integer,\n"
"in puid integer)\n"
"{\n"
"\n"
"declare up, gp, pp varchar;\n"
"\n"
"pp := substring (perm, 7, 3);\n"
"if (pp like req)\n"
"return 1;\n"
"\n"
"up := substring (perm, 1, 3);\n"
"if (up like req and ((oid = puid) or (oid = 2)))\n"
"return 1;\n"
"\n"
"gp := substring (perm, 4, 3);\n"
"if (gp like req and ((ogid = pgid) or (exists (select top 1 1 from WS.WS.SYS_DAV_USER_GROUP where UG_UID = oid and UG_GID = pgid))))\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:5351\n"
;

static const char *proc209 = 
"#line 5382 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_CHECK_USER (in uname varchar, in pwd any := null)\n"
"{\n"
"declare rc int;\n"
"declare pwd1 any;\n"
"rc := 0;\n"
"if (pwd is null)\n"
"{\n"
"rc := coalesce ((select 1 from WS.WS.SYS_DAV_USER where U_NAME = uname), 0);\n"
"}\n"
"else\n"
"{\n"
"whenever not found goto nf;\n"
"select U_PWD into pwd1 from WS.WS.SYS_DAV_USER where U_NAME = uname with (prefetch 1);\n"
"if ((pwd1[0] = 0 and pwd_magic_calc (uname, pwd) = pwd1) or (pwd1[0] <> 0 and pwd1 = pwd))\n"
"rc := 1;\n"
"nf:;\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:5380\n"
;

static const char *proc210 = 
"#line 5405 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RES_CONTENT (\n"
"in path varchar,\n"
"inout content any,\n"
"out type varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"declare id any;\n"
"\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"if ((DAV_HIDE_ERROR (id) is null) and (path like \'%,meta\'))\n"
"{\n"
"return DAV_RES_CONTENT_META (path, content, type, 0, 1, auth_uname, auth_pwd);\n"
"}\n"
"return DAV_RES_CONTENT_INT (id, content, type, 0, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:5403\n"
;

static const char *proc211 = 
"#line 5425 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RES_CONTENT_STRSES (\n"
"in path varchar,\n"
"inout content any,\n"
"out type varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"declare id any;\n"
"\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"if ((DAV_HIDE_ERROR (id) is null) and (path like \'%,meta\'))\n"
"{\n"
"return DAV_RES_CONTENT_META (path, content, type, 1, 1, auth_uname, auth_pwd);\n"
"}\n"
"return DAV_RES_CONTENT_INT (id, content, type, 1, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:5423\n"
;

static const char *proc212 = 
"#line 5443 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RES_CONTENT_INT (\n"
"in id any,\n"
"inout content any,\n"
"out type varchar,\n"
"in content_mode integer,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null )\n"
"{\n"
"declare rc, auth_uid integer;\n"
"declare _value, _password any;\n"
"declare cont any;\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := null;\n"
"}\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"if (isarray (id))\n"
"{\n"
"return call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, content, type, content_mode);\n"
"}\n"
"\n"
"rc := id;\n"
"select RES_CONTENT, RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"{\n"
"content := cont;\n"
"}\n"
"else if (content_mode = 1)\n"
"{\n"
"if (cont is not null)\n"
"http (cont, content);\n"
"}\n"
"else if (content_mode = 3)\n"
"{\n"
"http (cont);\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:5441\n"
;

static const char *proc213 = 
"#line 5493 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RES_CONTENT_META (\n"
"in path varchar,\n"
"inout content any,\n"
"out type varchar,\n"
"in content_mode integer,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null )\n"
"{\n"
"\n"
"declare rc, auth_uid integer;\n"
"declare id, cont any;\n"
"\n"
"if (path like \'%,meta\')\n"
"path := subseq (path, 0, length (path) - length (\',meta\'));\n"
"\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"{\n"
"auth_uid := null;\n"
"}\n"
"\n"
"rc := id;\n"
"cont := DAV_RES_CONTENT_META_N3 (path);\n"
"if (DAV_HIDE_ERROR (cont) is null)\n"
"return cont;\n"
"\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"{\n"
"content := cont;\n"
"}\n"
"else if (content_mode = 1)\n"
"{\n"
"if (cont is not null)\n"
"http (cont, content);\n"
"}\n"
"else if (content_mode = 3)\n"
"{\n"
"http (cont);\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:5491\n"
;

static const char *proc214 = 
"#line 5546 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RES_CONTENT_META_N3 (\n"
"in path varchar)\n"
"{\n"
"declare item any;\n"
"declare iri, creator_iri varchar;\n"
"declare stream, dict, triples any;\n"
"\n"
"if (__proc_exists (\'SIOC.DBA.get_graph\') is null)\n"
"return -1;\n"
"\n"
"dict := dict_new();\n"
"item := DAV_DIR_LIST_INT (path, -1, \'%\', null, null, http_dav_uid ());\n"
"if (DAV_HIDE_ERROR (item) is null)\n"
"return -1;\n"
"\n"
"item := item[0];\n"
"iri := iri_to_id (WS.WS.DAV_HOST () || path);\n"
"\n"
"\n"
"creator_iri := SIOC..user_iri (item[7]);\n"
"dict_put (dict, vector (iri, iri_to_id (SIOC..sioc_iri (\'has_creator\')), iri_to_id (creator_iri)), 0);\n"
"dict_put (dict, vector (iri_to_id (creator_iri), iri_to_id (SIOC..sioc_iri (\'creator_of\')), iri), 0);\n"
"dict_put (dict, vector (iri, SIOC..foaf_iri (\'maker\'), SIOC..person_iri (creator_iri)), 0);\n"
"dict_put (dict, vector (iri_to_id (SIOC..person_iri (creator_iri)), SIOC..foaf_iri (\'made\'), iri), 0);\n"
"\n"
"\n"
"dict_put (dict, vector (iri, iri_to_id (SIOC..dc_iri (\'title\')), item[10]), 0);\n"
"dict_put (dict, vector (iri, iri_to_id (SIOC..rdfs_iri (\'label\')), item[10]), 0);\n"
"\n"
"\n"
"dict_put (dict, vector (iri, iri_to_id (SIOC..dcterms_iri (\'created\')), item[8]), 0);\n"
"\n"
"\n"
"dict_put (dict, vector (iri, iri_to_id (SIOC..dcterms_iri (\'modified\')), item[3]), 0);\n"
"\n"
"\n"
"dict_put (dict, vector (iri, iri_to_id (SIOC..dc_iri (\'format\')), item[9]), 0);\n"
"\n"
"stream := string_output ();\n"
"triples := dict_list_keys (dict, 0);\n"
"if (length (triples))\n"
"DB.DBA.RDF_TRIPLES_TO_NICE_TTL (triples, stream);\n"
"\n"
"return string_output_string (stream);\n"
"}\n"
"--src dav_api.sql:5544\n"
;

static const char *proc215 = 
"#line 5593 \"[executable]/dav_api.sql\"\n"
"create function DB.DBA.DAV_EXEC_SQL (\n"
"in query varchar,\n"
"in params any := null,\n"
"in useCache integer := 0)\n"
"{\n"
"declare st, msg, opts, metas, rset any;\n"
"\n"
"if (useCache)\n"
"{\n"
"opts := vector (\'use_cache\', 1, \'max_rows\', 0);\n"
"}\n"
"else\n"
"{\n"
"opts := vector ();\n"
"}\n"
"\n"
"\n"
"st := \'00000\';\n"
"exec (query, st, msg, coalesce (params, vector ()), opts, metas, rset);\n"
"\n"
"if (st = \'00000\')\n"
"return rset;\n"
"\n"
"return vector ();\n"
"}\n"
"--src dav_api.sql:5591\n"
;

static const char *proc216 = 
"#line 5620 \"[executable]/dav_api.sql\"\n"
"create function DAV_RES_LENGTH (\n"
"in _content any,\n"
"in _size integer)\n"
"{\n"
"return case when (not isnull (_size)) then _size else length (_content) end;\n"
"}\n"
"--src dav_api.sql:5618\n"
;

static const char *proc217 = 
"#line 5628 \"[executable]/dav_api.sql\"\n"
"create function DAV_COL_IS_ANCESTOR_OF (in a_id integer, in d_id integer) returns integer\n"
"{\n"
"declare p_id integer;\n"
"if (a_id = 0)\n"
"return 1;\n"
"again:\n"
"\n"
"select COL_PARENT into p_id from WS.WS.SYS_DAV_COL where COL_ID = d_id and COL_PARENT < COL_ID;\n"
"if (p_id = a_id)\n"
"return 1;\n"
"if (p_id = 0)\n"
"return 0;\n"
"d_id := p_id;\n"
"goto again;\n"
"}\n"
"--src dav_api.sql:5626\n"
;

static const char *proc218 = 
"#line 5645 \"[executable]/dav_api.sql\"\n"
"create function DAV_COL_PATH_BOUNDARY (\n"
"in path varchar) returns varchar\n"
"{\n"
"declare len integer;\n"
"\n"
"len := length (path);\n"
"if ((len = 0) or (path[len-1] <> 47))\n"
"signal (\'.....\', sprintf (\'Bad path in DAV_COL_PATH_BOUNDARY: %s\', path));\n"
"\n"
"return path || \'\\377\\377\\377\\377\';\n"
"}\n"
"--src dav_api.sql:5643\n"
;

static const char *trig7 = 
"#line 5660 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_LDI_AI after insert on WS.WS.SYS_DAV_RES order 110 referencing new as N\n"
"{\n"
"\n"
"\n"
"\n"
"declare _n_size integer;\n"
"declare _oldAcls, _newAcls any;\n"
"declare _acis any;\n"
"declare _rdfParams any;\n"
"\n"
"_n_size := DB.DBA.DAV_RES_LENGTH (N.RES_CONTENT, N.RES_SIZE);\n"
"if (_n_size <> 0)\n"
"DB.DBA.RDF_SINK_INSERT (null, N.RES_FULL_PATH, N.RES_ID, N.RES_COL, N.RES_TYPE, N.RES_OWNER, N.RES_GROUP, _n_size);\n"
"\n"
"\n"
"_oldAcls := vector ();\n"
"_newAcls := vector (N.RES_ACL);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (N.RES_COL, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (N.RES_FULL_PATH), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_RES_GRAPH_UPDATE (\n"
"N.RES_ID,\n"
"\'I\',\n"
"null,\n"
"N.RES_TYPE,\n"
"null,\n"
"N.RES_OWNER,\n"
"null,\n"
"N.RES_GROUP,\n"
"null,\n"
"N.RES_PERMS,\n"
"null,\n"
"_newAcls,\n"
"null,\n"
"_rdfParams\n"
");\n"
"}\n"
"--src dav_api.sql:5658\n";

static const char *trig8 = 
"#line 5700 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_LDI_AU after update (RES_FULL_PATH, RES_ID, RES_COL, RES_TYPE, RES_OWNER, RES_GROUP, RES_PERMS, RES_ACL) on WS.WS.SYS_DAV_RES order 110 referencing new as N, old as O\n"
"{\n"
"\n"
"\n"
"\n"
"declare _o_size, _n_size integer;\n"
"declare _oldAcls, _newAcls any;\n"
"declare _acis any;\n"
"declare _rdfParams any;\n"
"\n"
"_o_size := DB.DBA.DAV_RES_LENGTH (O.RES_CONTENT, O.RES_SIZE);\n"
"_n_size := DB.DBA.DAV_RES_LENGTH (N.RES_CONTENT, N.RES_SIZE);\n"
"if (\n"
"(_o_size <> _n_size) or\n"
"(O.RES_FULL_PATH <> N.RES_FULL_PATH) or\n"
"(md5 (coalesce (case when isblob (O.RES_CONTENT) then blob_to_string_output (O.RES_CONTENT) else O.RES_CONTENT end, \'\')) <> md5 (coalesce (case when isblob (N.RES_CONTENT) then blob_to_string_output (N.RES_CONTENT) else N.RES_CONTENT end, \'\')))\n"
")\n"
"DB.DBA.RDF_SINK_UPDATE (null, O.RES_FULL_PATH, O.RES_ID, O.RES_COL, _o_size, N.RES_FULL_PATH, N.RES_ID, N.RES_COL, N.RES_TYPE, N.RES_OWNER, N.RES_GROUP, _n_size);\n"
"\n"
"\n"
"_oldAcls := vector (O.RES_ACL);\n"
"_newAcls := vector (N.RES_ACL);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (O.RES_COL, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (O.RES_FULL_PATH), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_RES_GRAPH_UPDATE (\n"
"N.RES_ID,\n"
"\'U\',\n"
"O.RES_TYPE,\n"
"N.RES_TYPE,\n"
"O.RES_OWNER,\n"
"N.RES_OWNER,\n"
"O.RES_GROUP,\n"
"N.RES_GROUP,\n"
"O.RES_PERMS,\n"
"N.RES_PERMS,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams\n"
");\n"
"}\n"
"--src dav_api.sql:5698\n";

static const char *trig9 = 
"#line 5745 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_LDI_AD after delete on WS.WS.SYS_DAV_RES order 110 referencing old as O\n"
"{\n"
"\n"
"\n"
"\n"
"declare _o_size integer;\n"
"declare _oldAcls, _newAcls any;\n"
"declare _acis any;\n"
"declare _rdfParams any;\n"
"\n"
"_o_size := DB.DBA.DAV_RES_LENGTH (O.RES_CONTENT, O.RES_SIZE);\n"
"if (_o_size <> 0)\n"
"DB.DBA.RDF_SINK_DELETE (null, O.RES_FULL_PATH, O.RES_ID, O.RES_COL, _o_size);\n"
"\n"
"\n"
"_oldAcls := vector (O.RES_ACL);\n"
"_newAcls := vector ();\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (O.RES_COL, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (O.RES_FULL_PATH), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_RES_GRAPH_UPDATE (\n"
"O.RES_ID,\n"
"\'D\',\n"
"O.RES_TYPE,\n"
"null,\n"
"O.RES_OWNER,\n"
"null,\n"
"O.RES_GROUP,\n"
"null,\n"
"O.RES_PERMS,\n"
"null,\n"
"_oldAcls,\n"
"null,\n"
"_rdfParams,\n"
"null\n"
");\n"
"}\n"
"--src dav_api.sql:5743\n";

static const char *trig10 = 
"#line 5787 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_COL_WAC_U after update (COL_NAME, COL_PARENT) on WS.WS.SYS_DAV_COL order 100 referencing new as N, old as O\n"
"{\n"
"declare aciContent, oldPath, newPath, update_acl any;\n"
"\n"
"if (connection_get (\'dav_acl_sync\') = 1)\n"
"return;\n"
"\n"
"aciContent := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = N.COL_ID and PROP_TYPE = \'C\' and PROP_NAME = \'virt:aci_meta_n3\');\n"
"if (aciContent is null)\n"
"return;\n"
"\n"
"oldPath := WS.WS.COL_PATH (O.COL_PARENT) || O.COL_NAME || \'/\';\n"
"newPath := WS.WS.COL_PATH (N.COL_PARENT) || N.COL_NAME || \'/\';\n"
"update_acl := 1;\n"
"\n"
"WS.WS.WAC_DELETE (oldPath, update_acl);\n"
"WS.WS.WAC_INSERT (newPath, aciContent, N.COL_OWNER, N.COL_GROUP, update_acl);\n"
"}\n"
"--src dav_api.sql:5785\n";

static const char *trig11 = 
"#line 5807 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_COL_WAC_D after delete on WS.WS.SYS_DAV_COL order 100 referencing old as O\n"
"{\n"
"declare update_acl integer;\n"
"declare path varchar;\n"
"\n"
"if (connection_get (\'dav_acl_sync\') = 1)\n"
"return;\n"
"\n"
"path := WS.WS.COL_PATH (O.COL_ID);\n"
"update_acl := 1;\n"
"\n"
"WS.WS.WAC_DELETE (path, update_acl);\n"
"}\n"
"--src dav_api.sql:5805\n";

static const char *trig12 = 
"#line 5822 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_WAC_I after insert on WS.WS.SYS_DAV_RES order 100 referencing new as N\n"
"{\n"
"declare aciContent, oldPath, newPath, update_acl any;\n"
"\n"
"if (connection_get (\'dav_acl_sync\') = 1)\n"
"return;\n"
"\n"
"if (ends_with (N.RES_NAME, \',acl\'))\n"
"{\n"
"declare id integer;\n"
"declare what varchar;\n"
"\n"
"newPath := WS.WS.COL_PATH (N.RES_COL) || regexp_replace (N.RES_NAME, \',acl\\x24\', \'\');\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (newPath, \'R\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"what := \'C\';\n"
"newPath := newPath || \'/\';\n"
"id := DB.DBA.DAV_SEARCH_ID (newPath, \'C\');\n"
"}\n"
"else\n"
"{\n"
"what := \'R\';\n"
"}\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"return;\n"
"\n"
"aciContent := N.RES_CONTENT;\n"
"\n"
"set triggers off;\n"
"insert into WS.WS.SYS_DAV_PROP (PROP_ID, PROP_PARENT_ID, PROP_NAME, PROP_TYPE, PROP_VALUE)\n"
"values (WS.WS.GETID (\'P\'), id, \'virt:aci_meta_n3\', what, N.RES_CONTENT);\n"
"set triggers on;\n"
"\n"
"update_acl := 0;\n"
"WS.WS.WAC_INSERT (newPath, aciContent, N.RES_OWNER, N.RES_GROUP, update_acl);\n"
"}\n"
"}\n"
"--src dav_api.sql:5820\n";

static const char *trig13 = 
"#line 5863 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_WAC_U after update on WS.WS.SYS_DAV_RES order 100 referencing new as N, old as O\n"
"{\n"
"declare aciContent, oldPath, newPath, update_acl any;\n"
"\n"
"if (connection_get (\'dav_acl_sync\') = 1)\n"
"return;\n"
"\n"
"if (ends_with (N.RES_NAME, \',acl\'))\n"
"{\n"
"declare id integer;\n"
"declare what varchar;\n"
"\n"
"if ((O.RES_NAME = N.RES_NAME) and (O.RES_COL = N.RES_COL) and (cast (O.RES_CONTENT as varchar) = cast (N.RES_CONTENT as varchar)))\n"
"return;\n"
"\n"
"oldPath := WS.WS.COL_PATH (O.RES_COL) || regexp_replace (O.RES_NAME, \',acl\\x24\', \'\');\n"
"newPath := WS.WS.COL_PATH (N.RES_COL) || regexp_replace (N.RES_NAME, \',acl\\x24\', \'\');\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (newPath, \'R\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"what := \'C\';\n"
"newPath := newPath || \'/\';\n"
"oldPath := oldPath || \'/\';\n"
"id := DB.DBA.DAV_SEARCH_ID (newPath, \'C\');\n"
"}\n"
"else\n"
"{\n"
"what := \'R\';\n"
"}\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"return;\n"
"\n"
"aciContent := N.RES_CONTENT;\n"
"\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = aciContent where PROP_TYPE = what and PROP_NAME = \'virt:aci_meta_n3\' and PROP_PARENT_ID = id;\n"
"set triggers on;\n"
"\n"
"update_acl := 0;\n"
"}\n"
"else\n"
"{\n"
"if ((O.RES_NAME = N.RES_NAME) and (O.RES_COL = N.RES_COL))\n"
"return;\n"
"\n"
"aciContent := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = N.RES_ID and PROP_TYPE = \'R\' and PROP_NAME = \'virt:aci_meta_n3\');\n"
"if (aciContent is null)\n"
"return;\n"
"\n"
"oldPath := WS.WS.COL_PATH (O.RES_COL) || O.RES_NAME;\n"
"newPath := WS.WS.COL_PATH (N.RES_COL) || N.RES_NAME;\n"
"update_acl := 1;\n"
"}\n"
"WS.WS.WAC_DELETE (oldPath, update_acl);\n"
"WS.WS.WAC_INSERT (newPath, aciContent, N.RES_OWNER, N.RES_GROUP, update_acl);\n"
"}\n"
"--src dav_api.sql:5861\n";

static const char *trig14 = 
"#line 5922 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_WAC_D after delete on WS.WS.SYS_DAV_RES order 100 referencing old as O\n"
"{\n"
"declare update_acl int;\n"
"declare oldPath varchar;\n"
"\n"
"if (connection_get (\'dav_acl_sync\') = 1)\n"
"return;\n"
"\n"
"if (ends_with (O.RES_NAME, \',acl\'))\n"
"{\n"
"declare id integer;\n"
"\n"
"oldPath := regexp_replace (O.RES_FULL_PATH, \',acl\\x24\', \'\');\n"
"\n"
"id := DB.DBA.DAV_SEARCH_ID (oldPath, \'R\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"oldPath := oldPath || \'/\';\n"
"id := DB.DBA.DAV_SEARCH_ID (oldPath, \'C\');\n"
"}\n"
"if (DB.DBA.DAV_HIDE_ERROR (id) is null)\n"
"return;\n"
"\n"
"update_acl := 0;\n"
"}\n"
"else\n"
"{\n"
"oldPath := O.RES_FULL_PATH;\n"
"update_acl := 1;\n"
"}\n"
"WS.WS.WAC_DELETE (oldPath, update_acl);\n"
"}\n"
"--src dav_api.sql:5920\n";

static const char *trig15 = 
"#line 5956 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_PROP_WAC_I after insert on WS.WS.SYS_DAV_PROP order 100 referencing new as N\n"
"{\n"
"if (N.PROP_NAME = \'virt:aci_meta_n3\')\n"
"WS.WS.WAC_INSERT_PROP (N.PROP_PARENT_ID, N.PROP_TYPE, N.PROP_VALUE);\n"
"}\n"
"--src dav_api.sql:5954\n";

static const char *trig16 = 
"#line 5963 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_PROP_WAC_U after update (PROP_NAME, PROP_VALUE) on WS.WS.SYS_DAV_PROP order 100 referencing new as N, old as O\n"
"{\n"
"if (N.PROP_NAME = \'virt:aci_meta_n3\')\n"
"{\n"
"declare _path any;\n"
"\n"
"_path := DB.DBA.DAV_SEARCH_PATH (O.PROP_PARENT_ID, O.PROP_TYPE);\n"
"if (DAV_HIDE_ERROR (_path) is not null)\n"
"WS.WS.WAC_DELETE (_path, 1);\n"
"\n"
"WS.WS.WAC_INSERT_PROP (N.PROP_PARENT_ID, N.PROP_TYPE, N.PROP_VALUE);\n"
"}\n"
"}\n"
"--src dav_api.sql:5961\n";

static const char *trig17 = 
"#line 5978 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_PROP_WAC_D after delete on WS.WS.SYS_DAV_PROP order 100 referencing old as O\n"
"{\n"
"if (O.PROP_NAME = \'virt:aci_meta_n3\')\n"
"{\n"
"declare _path any;\n"
"\n"
"_path := DB.DBA.DAV_SEARCH_PATH (O.PROP_PARENT_ID, O.PROP_TYPE);\n"
"if (DAV_HIDE_ERROR (_path) is not null)\n"
"WS.WS.WAC_DELETE (_path, 1);\n"
"}\n"
"}\n"
"--src dav_api.sql:5976\n";

static const char *proc219 = 
"#line 5991 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.WAC_INSERT_PROP (\n"
"in id any,\n"
"in what char(1),\n"
"in prop_value any)\n"
"{\n"
"declare _path, _owner, _group any;\n"
"declare exit handler for not found { return; };\n"
"\n"
"if (what = \'R\')\n"
"{\n"
"select RES_FULL_PATH, RES_OWNER, RES_GROUP\n"
"into _path, _owner, _group\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = id;\n"
"}\n"
"else\n"
"{\n"
"select DAV_SEARCH_PATH (COL_ID, what), COL_OWNER, COL_GROUP\n"
"into _path, _owner, _group\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = id;\n"
"}\n"
"WS.WS.WAC_INSERT (_path, prop_value, _owner, _group, 1);\n"
"}\n"
"--src dav_api.sql:5989\n"
;

static const char *proc220 = 
"#line 6017 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.WAC_INSERT (\n"
"in path varchar,\n"
"in aciContent any,\n"
"in uid integer,\n"
"in gid integer,\n"
"in update_acl integer)\n"
"{\n"
"\n"
"declare what, graph, permissions varchar;\n"
"declare giid, subj any;\n"
"\n"
"graph := WS.WS.WAC_GRAPH (path);\n"
"aciContent := cast (blob_to_string (aciContent) as varchar);\n"
"what := case when (path[length (path)-1] <> ascii(\'/\')) then \'R\' else \'C\' end;\n"
"permissions := DB.DBA.DAV_PROP_GET_INT (DB.DBA.DAV_SEARCH_ID (path, what), what, \':virtpermissions\', 0, null, null, http_dav_uid ());\n"
"if (update_acl)\n"
"{\n"
"connection_set (\'dav_acl_sync\', 1);\n"
"DAV_RES_UPLOAD_STRSES_INT (rtrim (path, \'/\') || \',acl\', aciContent, \'text/turtle\', permissions, uid, gid, null, null, 0);\n"
"connection_set (\'dav_acl_sync\', null);\n"
"}\n"
"\n"
"if (DB.DBA.DAV_HIDE_ERROR (permissions) is null)\n"
"return;\n"
"\n"
"giid := iri_to_id (graph);\n"
"subj := iri_to_id (WS.WS.DAV_LINK (path));\n"
"DB.DBA.TTLP (aciContent, graph, graph);\n"
"sparql insert into graph ?:giid { ?s ?p ?:giid } where { graph ?:giid { ?s ?p ?:subj  }};\n"
"if (exists (sparql prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix acl: <http://www.w3.org/ns/auth/acl#> ask where { graph ?:giid { [] acl:accessTo ?:giid ; acl:mode acl:Read  ; acl:agentClass foaf:Agent . }}))\n"
"{\n"
"set triggers off;\n"
"permissions [6] := 49;\n"
"DAV_PROP_SET_INT (path, \':virtpermissions\', permissions, null, null, 0, 0, 1, http_dav_uid ());\n"
"set triggers on;\n"
"}\n"
"}\n"
"--src dav_api.sql:6015\n"
;

static const char *proc221 = 
"#line 6056 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.WAC_DELETE (\n"
"in path varchar,\n"
"in update_acl integer)\n"
"{\n"
"\n"
"declare graph, st, msg varchar;\n"
"\n"
"graph := WS.WS.WAC_GRAPH (path);\n"
"if (update_acl)\n"
"{\n"
"connection_set (\'dav_acl_sync\', 1);\n"
"DB.DBA.DAV_DELETE_INT (rtrim (path, \'/\') || \',acl\', 1, null, null, 0, 0);\n"
"connection_set (\'dav_acl_sync\', null);\n"
"}\n"
"set_user_id (\'dba\');\n"
"for (select a.G as GG, a.S as SS\n"
"from DB.DBA.RDF_QUAD a\n"
"where	a.G = __i2idn (graph)\n"
"and	a.P = __i2idn (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\')\n"
"and	a.O = __i2idn (\'http://www.w3.org/ns/auth/acl#Authorization\')) do\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = GG and (S = SS or O = SS);\n"
"}\n"
"for (select a.G as GG, a.S as SS\n"
"from DB.DBA.RDF_QUAD a\n"
"where	a.G = __i2idn (graph)\n"
"and a.P = __i2idn (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\')\n"
"and a.O = __i2idn (\'http://www.openlinksw.com/schemas/acl/filter#Filter\')) do\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = GG and (S = SS or O = SS);\n"
"}\n"
"for (select a.G as GG, a.S as SS\n"
"from DB.DBA.RDF_QUAD a\n"
"where	a.G = __i2idn (graph)\n"
"and a.P = __i2idn (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\')\n"
"and a.O = __i2idn (\'http://www.openlinksw.com/schemas/acl/filter#Criteria\')) do\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = GG and (S = SS or O = SS);\n"
"}\n"
"}\n"
"--src dav_api.sql:6054\n"
;

static const char *proc222 = 
"#line 6098 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.WAC_GRAPH (\n"
"in path varchar,\n"
"in suffix varchar := \'\')\n"
"{\n"
"return rtrim (WS.WS.DAV_IRI (path), \'/\') || \'/\' || suffix;\n"
"}\n"
"--src dav_api.sql:6096\n"
;

static const char *proc223 = 
"#line 6107 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.DAV_HOST ()\n"
"{\n"
"declare host any;\n"
"\n"
"host := virtuoso_ini_item_value (\'URIQA\', \'DefaultHost\');\n"
"if (host is null)\n"
"{\n"
"host := sys_stat (\'st_host_name\');\n"
"if (server_http_port () <> \'80\')\n"
"host := host ||\':\'|| server_http_port ();\n"
"}\n"
"return sprintf (\'http://%s\', host);\n"
"}\n"
"--src dav_api.sql:6105\n"
;

static const char *proc224 = 
"#line 6122 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.DAV_IRI (\n"
"in path varchar)\n"
"{\n"
"declare S any;\n"
"\n"
"S := string_output ();\n"
"http_dav_url (path, null, S);\n"
"S := string_output_string (S);\n"
"\n"
"return WS.WS.DAV_HOST () || S;\n"
"}\n"
"--src dav_api.sql:6120\n"
;

static const char *trig18 = 
"#line 6136 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_COL_ACL_I after insert on WS.WS.SYS_DAV_COL order 9 referencing new as NC\n"
"{\n"
"declare N, colID, parentID integer;\n"
"declare aAcl, aParentAcl any;\n"
"\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (NC.COL_ACL, \'01\', 0);\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_ACL_INVERSE (AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values (either(equ(acl[1],0), \'R\', \'G\'), NC.COL_ID, \'C\', acl[0]);\n"
"}\n"
"\n"
"aParentAcl := (select WS.WS.ACL_PARSE (COL_ACL, \'123\', 0) from WS.WS.SYS_DAV_COL c where c.COL_ID = NC.COL_PARENT);\n"
"if (isnull(aParentAcl))\n"
"return;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (NC.COL_ACL, \'012\', 0);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL\n"
"set COL_ACL = WS.WS.ACL_COMPOSE (vector_concat (aAcl, WS.WS.ACL_MAKE_INHERITED(aParentAcl)))\n"
"where COL_ID = NC.COL_ID;\n"
"\n"
"}\n"
"--src dav_api.sql:6134\n";

static const char *proc225 = 
"#line 6162 \"[executable]/dav_api.sql\"\n"
"create function WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG (inout aAcl any, in grantee integer, in flag char(1)) returns integer\n"
"{\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"if ((grantee = acl[0]) and (flag = either(equ(acl[1],0), \'R\', \'G\')))\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:6160\n"
;

static const char *trig19 = 
"#line 6173 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_COL_ACL_U after update (COL_ACL) on WS.WS.SYS_DAV_COL order 9 referencing new as N, old as O\n"
"{\n"
"declare aAcl, aLog any;\n"
"\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (O.COL_ACL, \'01\', 0);\n"
"delete\n"
"from WS.WS.SYS_DAV_ACL_INVERSE\n"
"where AI_PARENT_ID = O.COL_ID\n"
"and AI_PARENT_TYPE = \'C\'\n"
"and not WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG (aAcl, AI_GRANTEE_ID, AI_FLAG);\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (N.COL_ACL, \'01\', 0);\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_ACL_INVERSE (AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values (either (equ (acl[1], 0), \'R\', \'G\'), N.COL_ID, \'C\', acl[0]);\n"
"}\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"log_enable (aLog, 1);\n"
"resignal;\n"
"};\n"
"\n"
"set triggers off;\n"
"\n"
"aLog := log_enable (0, 1);\n"
"WS.WS.ACL_UPDATE (N.COL_ID, WS.WS.ACL_PARSE (N.COL_ACL, \'123\', 0));\n"
"log_enable (aLog, 1);\n"
"log_text (\'WS.WS.ACL_UPDATE (?, ?)\', N.COL_ID, WS.WS.ACL_PARSE (N.COL_ACL, \'123\', 0));\n"
"}\n"
"--src dav_api.sql:6171\n";

static const char *trig20 = 
"#line 6207 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_COL_ACL_D after delete on WS.WS.SYS_DAV_COL order 9 referencing old as O\n"
"{\n"
"\n"
"delete\n"
"from WS.WS.SYS_DAV_ACL_INVERSE\n"
"where AI_PARENT_TYPE = \'C\'\n"
"and AI_PARENT_ID = O.COL_ID;\n"
"\n"
"}\n"
"--src dav_api.sql:6205\n";

static const char *trig21 = 
"#line 6220 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_ACL_I after insert on WS.WS.SYS_DAV_RES order 9 referencing new as N\n"
"{\n"
"declare aAcl any;\n"
"declare aParentAcl varbinary;\n"
"\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (N.RES_ACL, \'0\', 0);\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_ACL_INVERSE (AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values (either(equ(acl[1],0), \'R\', \'G\'), N.RES_ID, \'R\', acl[0]);\n"
"}\n"
"\n"
"aParentAcl := (select WS.WS.ACL_PARSE (COL_ACL, \'123\', 0) from WS.WS.SYS_DAV_COL where COL_ID = N.RES_COL);\n"
"if (not isnull(aParentAcl))\n"
"{\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_ACL = WS.WS.ACL_COMPOSE (vector_concat(aAcl, WS.WS.ACL_MAKE_INHERITED(aParentAcl)))\n"
"where RES_ID = N.RES_ID;\n"
"}\n"
"\n"
"}\n"
"--src dav_api.sql:6218\n";

static const char *trig22 = 
"#line 6245 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_ACL_U after update (RES_ACL) on WS.WS.SYS_DAV_RES order 9 referencing new as N, old as O\n"
"{\n"
"declare aAcl any;\n"
"\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (O.RES_ACL, \'0\', 0);\n"
"delete\n"
"from WS.WS.SYS_DAV_ACL_INVERSE\n"
"where AI_PARENT_ID = O.RES_ID\n"
"and AI_PARENT_TYPE = \'R\'\n"
"and not WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG (aAcl, AI_GRANTEE_ID, AI_FLAG);\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (N.RES_ACL, \'0\', 0);\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_ACL_INVERSE (AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values (either (equ (acl[1],0), \'R\', \'G\'), N.RES_ID, \'R\', acl[0]);\n"
"}\n"
"\n"
"}\n"
"--src dav_api.sql:6243\n";

static const char *trig23 = 
"#line 6267 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_ACL_D after delete on WS.WS.SYS_DAV_RES order 9 referencing old as O\n"
"{\n"
"\n"
"delete\n"
"from WS.WS.SYS_DAV_ACL_INVERSE\n"
"where AI_PARENT_TYPE = \'R\'\n"
"and AI_PARENT_ID = O.RES_ID;\n"
"\n"
"}\n"
"--src dav_api.sql:6265\n";

static const char *proc226 = 
"#line 6278 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_UPDATE (in id integer, in parentAcl any)\n"
"{\n"
"declare nAcl any;\n"
"\n"
"\n"
"WS.WS.ACL_MAKE_INHERITED (parentAcl);\n"
"for select RES_ID as resID, RES_ACL as aAcl from WS.WS.SYS_DAV_RES where RES_COL = id do\n"
"{\n"
"nAcl := WS.WS.ACL_COMPOSE (vector_concat (WS.WS.ACL_PARSE (aAcl, \'0\', 0), parentAcl));\n"
"if (not ((nAcl = aAcl) or (isnull (nAcl) and isnull (aAcl))))\n"
"{\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_ACL = nAcl\n"
"where RES_ID = resID;\n"
"}\n"
"}\n"
"for select COL_ID as colID, COL_ACL as aAcl from WS.WS.SYS_DAV_COL where COL_PARENT = id do\n"
"{\n"
"nAcl := WS.WS.ACL_COMPOSE (vector_concat (WS.WS.ACL_PARSE (aAcl, \'012\', 0), parentAcl));\n"
"if (not ((nAcl = aAcl) or (isnull (nAcl) and isnull (aAcl))))\n"
"{\n"
"update WS.WS.SYS_DAV_COL\n"
"set COL_ACL = nAcl\n"
"where COL_ID = colID;\n"
"WS.WS.ACL_UPDATE(colID, WS.WS.ACL_PARSE (nAcl, \'123\', 0));\n"
"}\n"
"}\n"
"}\n"
"--src dav_api.sql:6276\n"
;

static const char *proc227 = 
"#line 6308 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_MAKE_INHERITED (\n"
"inout aAcl any)\n"
"{\n"
"declare N integer;\n"
"\n"
"for (N := 0; N < length (aAcl); N := N + 1)\n"
"aAcl[N][2] := 3;\n"
"\n"
"return aAcl;\n"
"}\n"
"--src dav_api.sql:6306\n"
;

static const char *proc228 = 
"#line 6321 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_DBG (\n"
"in vb varbinary) returns varchar\n"
"{\n"
"declare N integer;\n"
"declare aResult varchar;\n"
"\n"
"aResult := \'\';\n"
"vb := cast(vb as varchar);\n"
"for (N := 0; N < length (vb); N := N + 1)\n"
"{\n"
"aResult := aResult || cast (vb[N] as varchar) || \', \';\n"
"}\n"
"return aResult;\n"
"}\n"
"--src dav_api.sql:6319\n"
;

static const char *proc229 = 
"#line 6339 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_SERIALIZE_INT (\n"
"in I integer) returns varbinary\n"
"{\n"
"declare N integer;\n"
"declare retValue varchar;\n"
"\n"
"retValue := repeat (\'\\0\', 4);\n"
"\n"
"N := bit_shift (I,-24);\n"
"if (N)\n"
"retValue[0] := N;\n"
"\n"
"N := bit_shift (bit_shift (I, 8),-24);\n"
"if (N)\n"
"retValue[1] := N;\n"
"\n"
"N := bit_shift(bit_shift (I,16),-24);\n"
"if (N)\n"
"retValue[2] := N;\n"
"\n"
"N := bit_shift(bit_shift (I, 24),-24);\n"
"if (N)\n"
"retValue[3] := N;\n"
"\n"
"return cast (retValue as varbinary);\n"
"}\n"
"--src dav_api.sql:6337\n"
;

static const char *proc230 = 
"#line 6369 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_DESERIALIZE_INT (\n"
"in _value any) returns integer\n"
"{\n"
"if (__tag (_value) <> 189)\n"
"_value := cast (_value as varchar);\n"
"\n"
"_value := right (repeat (\'\\0\', 4) || _value, 4);\n"
"return bit_or (bit_or (bit_or (bit_shift (_value[0], 24), bit_shift (_value[1], 16)), bit_shift (_value[2], 8)), _value[3]);\n"
"}\n"
"--src dav_api.sql:6367\n"
;

static const char *proc231 = 
"#line 6382 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_GET_ACLLENGTH(in acl varbinary) returns integer\n"
"{\n"
"return WS.WS.ACL_DESERIALIZE_INT (cast (substring( cast (acl as varchar), 1, 4) as varbinary));\n"
"}\n"
"--src dav_api.sql:6380\n"
;

static const char *proc232 = 
"#line 6390 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_GET_ACESIZE(in acl varbinary) returns integer\n"
"{\n"
"return WS.WS.ACL_DESERIALIZE_INT (cast (substring (cast (acl as varchar), 5, 4) as varbinary));\n"
"}\n"
"--src dav_api.sql:6388\n"
;

static const char *proc233 = 
"#line 6401 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_CREATE() returns varbinary\n"
"{\n"
"return cast(concat(cast (WS.WS.ACL_SERIALIZE_INT (8) as varchar),\n"
"cast (WS.WS.ACL_SERIALIZE_INT (0) as varchar)) as varbinary);\n"
"}\n"
"--src dav_api.sql:6399\n"
;

static const char *proc234 = 
"#line 6413 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_IS_VALID (in acl varbinary) returns integer\n"
"{\n"
"declare iAclLength, iAceSize integer;\n"
"\n"
"\n"
"if (__tag (acl) <> 222)\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"iAclLength := WS.WS.ACL_GET_ACLLENGTH(acl);\n"
"if (iAclLength <> length(acl))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"iAceSize := WS.WS.ACL_GET_ACESIZE(acl);\n"
"if ((iAceSize*8 + 8) <> length(acl))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:6411\n"
;

static const char *proc235 = 
"#line 6448 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_ADD_ENTRY(inout acl varbinary, in uid integer, in bitmask integer, in is_grant integer, in inheritance integer := 0) returns varbinary\n"
"{\n"
"declare N, bFound integer;\n"
"declare aAcl any;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (acl);\n"
"\n"
"bFound := 0;\n"
"for (N := 0; N < length (aAcl); N := N + 1)\n"
"{\n"
"if ((aAcl[N][0] = uid) and (aAcl[N][2] = inheritance))\n"
"{\n"
"if (aAcl[N][1] = is_grant)\n"
"{\n"
"aset (aAcl, N, vector (aAcl[N][0], aAcl[N][1], aAcl[N][2], bitmask));\n"
"bFound := 1;\n"
"}\n"
"else\n"
"{\n"
"aset (aAcl, N, vector (aAcl[N][0], aAcl[N][1], aAcl[N][2], bit_and(aAcl[N][3], bit_not(bitmask))));\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (not bFound)\n"
"aAcl := vector_concat(aAcl, vector(vector(uid, is_grant, inheritance, bitmask)));\n"
"\n"
"acl := WS.WS.ACL_COMPOSE(aAcl);\n"
"\n"
"return acl;\n"
"}\n"
"--src dav_api.sql:6446\n"
;

static const char *proc236 = 
"#line 6488 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_REMOVE_ENTRY(inout acl varbinary, in uid integer, in bitmask integer, in inheritance integer := 0) returns varbinary\n"
"{\n"
"declare N integer;\n"
"declare aAcl any;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (acl);\n"
"for (N := 0; N < length(aAcl); N := N + 1)\n"
"{\n"
"if ((aAcl[N][0] = uid) and (aAcl[N][2] = inheritance))\n"
"{\n"
"if (aAcl[N][1])\n"
"{\n"
"aset(aAcl, N, vector(aAcl[N][0], aAcl[N][1], aAcl[N][2], bit_and(aAcl[N][3], bit_not(bitmask))));\n"
"}\n"
"else\n"
"{\n"
"aset(aAcl, N, vector(aAcl[N][0], aAcl[N][1], aAcl[N][2], bit_and(aAcl[N][3], bitmask)));\n"
"}\n"
"}\n"
"}\n"
"acl := WS.WS.ACL_COMPOSE(aAcl);\n"
"\n"
"return acl;\n"
"}\n"
"--src dav_api.sql:6486\n"
;

static const char *proc237 = 
"#line 6519 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_IS_GRANTED (\n"
"in acl varbinary,\n"
"in uid integer,\n"
"in bitmask integer) returns integer\n"
"{\n"
"\n"
"declare aAcl any;\n"
"declare ids any;\n"
"declare or_acc integer;\n"
"declare anded integer;\n"
"\n"
"if (isnull (acl))\n"
"return 0;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE (acl);\n"
"if (length (aAcl) = 0)\n"
"return 0;\n"
"\n"
"ids := (select vector_concat (vector (uid), VECTOR_AGG (GI_SUB)) from DB.DBA.SYS_ROLE_GRANTS where GI_SUPER = uid);\n"
"or_acc := 0;\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"if (position (acl[0], ids))\n"
"{\n"
"anded := bit_and (acl[3], bitmask);\n"
"if (anded)\n"
"{\n"
"\n"
"if (not acl[1])\n"
"return 0;\n"
"\n"
"or_acc := bit_or (or_acc, anded);\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (or_acc = bitmask)\n"
"return or_acc;\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:6517\n"
;

static const char *proc238 = 
"#line 6567 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_PARSE (\n"
"in acl varbinary,\n"
"in inheritance varchar := \'0123\',\n"
"in error integer := 1) returns any\n"
"{\n"
"declare sAcl varchar;\n"
"declare N, I, T, aclSize integer;\n"
"declare aAcl any;\n"
"\n"
"if (acl is null)\n"
"return vector ();\n"
"\n"
"if (isblob (acl))\n"
"acl := cast (blob_to_string (acl) as varbinary);\n"
"\n"
"else if (isstring (acl))\n"
"acl := cast (acl as varbinary);\n"
"\n"
"if (not WS.WS.ACL_IS_VALID (acl))\n"
"{\n"
"if (error)\n"
"signal(\'ACL01\', \'Bad ACL object\');\n"
"\n"
"return vector ();\n"
"}\n"
"\n"
"aclSize := WS.WS.ACL_GET_ACESIZE (acl);\n"
"sAcl := cast (acl as varchar);\n"
"\n"
"vectorbld_init (aAcl);\n"
"for (N := 1; N <= aclSize; N := N + 1)\n"
"{\n"
"T := WS.WS.ACL_DESERIALIZE_INT (cast (substring (sAcl, 8*N+5, 4) as varbinary));\n"
"I := abs (bit_and (bit_shift (T, -29), 3));\n"
"if (not isnull (strchr (inheritance, cast (I as varchar))))\n"
"vectorbld_acc (aAcl, vector (WS.WS.ACL_DESERIALIZE_INT (cast (substring (sAcl, 8*N+1, 4) as varbinary)),\n"
"abs(bit_shift (T, -31)),\n"
"I,\n"
"abs (bit_and (T, 536870911))));\n"
"}\n"
"vectorbld_final (aAcl);\n"
"return aAcl;\n"
"}\n"
"--src dav_api.sql:6565\n"
;

static const char *proc239 = 
"#line 6617 \"[executable]/dav_api.sql\"\n"
"create procedure WS.WS.ACL_COMPOSE (\n"
"in aAcl vector) returns varbinary\n"
"{\n"
"declare sAcl varchar;\n"
"declare bAcl varbinary;\n"
"declare N, I, J integer;\n"
"\n"
"sAcl := \'\';\n"
"for (I := 1; I < 4; I := I + 1)\n"
"{\n"
"for (J := 0; J < 2; J := J + 1)\n"
"{\n"
"foreach (any acl in aAcl) do\n"
"{\n"
"if ((acl[1]=J) and ((acl[2]=I) or ((acl[2]=0) and (I=1))) and acl[3])\n"
"sAcl := concat(sAcl,\n"
"cast(WS.WS.ACL_SERIALIZE_INT(acl[0]) as varchar),\n"
"cast(WS.WS.ACL_SERIALIZE_INT(bit_shift(acl[1],31)+bit_shift(acl[2],29)+acl[3]) as varchar));\n"
"}\n"
"}\n"
"}\n"
"\n"
"bAcl := cast(concat(cast(WS.WS.ACL_SERIALIZE_INT(length(sAcl)+8) as varchar),\n"
"cast(WS.WS.ACL_SERIALIZE_INT(length(sAcl)/8) as varchar),\n"
"sAcl) as varbinary);\n"
"\n"
"return bAcl;\n"
"}\n"
"--src dav_api.sql:6615\n"
;

static const char *proc240 = 
"#line 6651 \"[executable]/dav_api.sql\"\n"
"create function DAV_CAST_STRING_TO_INTEGER (in val varchar) returns integer\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as integer);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:6649\n"
;

static const char *proc241 = 
"#line 6661 \"[executable]/dav_api.sql\"\n"
"create function DAV_CAST_STRING_TO_DATETIME (in val varchar) returns datetime\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as datetime);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:6659\n"
;

static const char *proc242 = 
"#line 6671 \"[executable]/dav_api.sql\"\n"
"create function DAV_CAST_TEXT_TO_VARCHAR (in val varchar) returns varchar\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as varchar);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:6669\n"
;

static const char *proc243 = 
"#line 6681 \"[executable]/dav_api.sql\"\n"
"create function DAV_CAST_TEXT_TO_INTEGER (in val varchar) returns integer\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as integer);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:6679\n"
;

static const char *proc244 = 
"#line 6691 \"[executable]/dav_api.sql\"\n"
"create function DAV_CAST_TEXT_TO_DATETIME (in val varchar) returns datetime\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as datetime);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:6689\n"
;

static const char *proc245 = 
"#line 6701 \"[executable]/dav_api.sql\"\n"
"create function DAV_FC_CONST_AS_SQL (inout val any)\n"
"{\n"
"if (193 = __tag (val))\n"
"{\n"
"declare res varchar;\n"
"res := \'\';\n"
"foreach (any item in val) do\n"
"res := concat (res, \', \', DAV_FC_CONST_AS_SQL(item));\n"
"return subseq (res, 2);\n"
"}\n"
"if (182 = __tag (val))\n"
"return replace (WS.WS.STR_SQL_APOS (val), \'^{\', \'\\\\136{\');\n"
"if (189 = __tag (val))\n"
"return sprintf (\'%d\', val);\n"
"if (211 = __tag (val))\n"
"return sprintf (\'cast (\'\'%s\'\' as datetime)\', cast (val as varchar));\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_CONST_AS_SQL has got bad value\');\n"
"}\n"
"--src dav_api.sql:6699\n"
;

static const char *proc246 = 
"#line 6727 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_FC_PRED_METAS (inout pred_metas any)\n"
"{\n"
"pred_metas := vector (\n"
"\'RES_ID\',                   vector (\'SYS_DAV_RES\'   , 0, \'integer\'  , \'RES_ID\'      ),\n"
"\'RES_ID_SERIALIZED\',        vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'serialize (RES_ID)\'  ),\n"
"\'RES_NAME\',                 vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_NAME\'    ),\n"
"\'RES_FULL_PATH\',            vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_FULL_PATH\'       ),\n"
"\'RES_TYPE\',                 vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_TYPE\'    ),\n"
"\'RES_OWNER_ID\',             vector (\'SYS_DAV_RES\'   , 0, \'integer\'  , \'RES_OWNER\'   ),\n"
"\'RES_OWNER_NAME\',           vector (\'SYS_DAV_USER\'  , 0, \'varchar\'  , \'U_NAME\'      ),\n"
"\'RES_GROUP_ID\',             vector (\'SYS_DAV_RES\'   , 0, \'integer\'  , \'RES_GROUP\'   ),\n"
"\'RES_GROUP_NAME\',           vector (\'SYS_DAV_GROUP\' , 0, \'varchar\'  , \'G_NAME\'      ),\n"
"\'RES_COL_FULL_PATH\',        vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'subseq (RES_FULL_PATH, 0, 1 + strrchr (RES_FULL_PATH, \'\'/\'\'))\'       ),\n"
"\'RES_COL_NAME\',             vector (\'SYS_DAV_COL\'   , 0, \'varchar\'  , \'COL_NAME\'    ),\n"
"\n"
"\'RES_CR_TIME\',              vector (\'SYS_DAV_RES\'   , 0, \'datetime\' , \'RES_CR_TIME\' ),\n"
"\'RES_MOD_TIME\',             vector (\'SYS_DAV_RES\'   , 0, \'datetime\' , \'RES_MOD_TIME\'),\n"
"\'RES_PERMS\',                vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_PERMS\'   ),\n"
"\'RES_CONTENT\',              vector (\'SYS_DAV_RES\'   , 0, \'text\'     , \'RES_CONTENT\' ),\n"
"\'PROP_NAME\',                vector (\'SYS_DAV_PROP\'  , 0, \'varchar\'  , \'PROP_NAME\'   ),\n"
"\'PROP_VALUE\',               vector (\'SYS_DAV_PROP\'  , 1, \'text\'     , \'PROP_VALUE\'  ),\n"
"\'RES_TAGS\',                 vector (\'all-tags\'      , 0, \'varchar\'  , \'DT_TAGS\'     ),\n"
"\'RES_PUBLIC_TAGS\',          vector (\'public-tags\'   , 0, \'text-tag\' , \'DT_TAGS\'     ),\n"
"\'RES_PRIVATE_TAGS\',         vector (\'private-tags\'  , 0, \'text-tag\' , \'DT_TAGS\'     ),\n"
"\'RDF_PROP\',                 vector (\'SYS_DAV_PROP\'  , 1, \'varchar\'  , NULL  ),\n"
"\'RDF_VALUE\',                vector (\'SYS_DAV_PROP\'  , 2, \'XML\'      , NULL  ),\n"
"\'RDF_OBJ_VALUE\',            vector (\'SYS_DAV_PROP\'  , 3, \'XML\'      , NULL  )\n"
");\n"
"}\n"
"--src dav_api.sql:6725\n"
;

static const char *proc247 = 
"#line 6765 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_FC_CMP_METAS (inout cmp_metas any)\n"
"{\n"
"cmp_metas := vector (\n"
"\'<\',                        vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ < ^{pattern}^)\'     , \'[sql-lt (^{value}^, ^{pattern}^)]\'),\n"
"\'>\',                        vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ > ^{pattern}^)\'     , \'[sql-gt (^{value}^, ^{pattern}^)]\'),\n"
"\'<=\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ <= ^{pattern}^)\'    , \'[sql-le (^{value}^, ^{pattern}^)]\'),\n"
"\'>=\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ >= ^{pattern}^)\'    , \'[sql-ge (^{value}^, ^{pattern}^)]\'),\n"
"\'=\',                        vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ = ^{pattern}^)\'     , \'[sql-equ (^{value}^, ^{pattern}^)]\'),\n"
"\'<>\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ <> ^{pattern}^)\'    , \'[sql-neq (^{value}^, ^{pattern}^)]\'),\n"
"\'!=\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ <> ^{pattern}^)\'    , \'[sql-neq (^{value}^, ^{pattern}^)]\'),\n"
"\'between\',                  vector (\'vector\', \'sortable\'    , NULL, \'(^{value}^ between ^{pattern0}^ and ^{pattern1}^)\'     , \'[sql-ge(^{value}^, ^{pattern0}^)][sql-le (^{value}^, ^{pattern0}^)]\' ),\n"
"\'in\',                       vector (\'vector\', \'sortable\'    , NULL, \'(^{value}^ in (^{pattern}^))\'  , NULL  ),\n"
"\'member_of\',                vector (\'vector\', \'sortable\'    , NULL, \'(^{value}^ in (^{pattern}^))\'  , NULL  ),\n"
"\'like\',                     vector (\'scalar\', \'varchar\'     , NULL, \'(^{value}^ like ^{pattern}^)\'  , \'[^{value}^ like ^{pattern}^]\'),\n"
"\'regexp_match\',             vector (\'scalar\', \'varchar\'     , NULL, \'(regexp_match (^{pattern}^, ^{value}^) is not null)\'   , NULL  ),\n"
"\'is_substring_of\',          vector (\'scalar\', \'varchar\'     , NULL, \'(strstr (^{pattern}^, ^{value}^) is not null)\' ,\'[contains (^{pattern}^, ^{value}^)]\'),\n"
"\'contains_substring\',       vector (\'scalar\', \'varchar\'     , NULL, \'(strstr (^{value}^, ^{pattern}^) is not null)\' ,\'[contains (^{value}^, ^{pattern}^)]\'),\n"
"\'not_contains_substring\',   vector (\'scalar\', \'varchar\'     , NULL, \'(strstr (^{value}^, ^{pattern}^) is null)\'     ,\'[not (contains (^{value}^, ^{pattern}^)]\'     ),\n"
"\'starts_with\',              vector (\'scalar\', \'varchar\'     , NULL, \'(^{value}^ between ^{pattern}^ and (^{pattern}^ || \'\'\\\\377\\\\377\\\\377\\\\377\'\'))\' , \'[starts-with (^{value}^, ^{pattern}^)]\'),\n"
"\'not_starts_with\',          vector (\'scalar\', \'varchar\'     , NULL, \'(not (^{value}^ between ^{pattern}^ and (^{pattern}^ || \'\'\\\\377\\\\377\\\\377\\\\377\'\')))\'   , \'[not (starts-with (^{value}^, ^{pattern}^))]\'        ),\n"
"\'ends_with\',                vector (\'scalar\', \'varchar\'     , NULL, \'(case (sign (length (^{value}^) - length (^{pattern}^))) when -1 then 0 else equ (subseq (^{value}^, length (^{value}^) - length (^{pattern}^)), ^{pattern}^) end)\'    , \'[ends-with (^{value}^, ^{pattern}^)]\'),\n"
"\'not_ends_with\',            vector (\'scalar\', \'varchar\'     , NULL, \'(case (sign (length (^{value}^) - length (^{pattern}^))) when -1 then 1 else neq (subseq (^{value}^, length (^{value}^) - length (^{pattern}^)), ^{pattern}^) end)\'    , \'[not (ends-with (^{value}^, ^{pattern}^))]\'),\n"
"\'is_null\',                  vector (\'no\'    , \'any\'         , NULL, \'(^{value}^ is null)\'           , null  ),\n"
"\'is_not_null\',              vector (\'no\'    , \'any\'         , NULL, \'(^{value}^ is not null)\'       , null  ),\n"
"\'contains_tags\',            vector (\'scalar\', \'varchar\'     , NULL, NULL, NULL ),\n"
"\'may_contain_tags\',         vector (\'scalar\', \'varchar\'     , NULL, NULL, NULL ),\n"
"\'contains_text\',            vector (\'scalar\', \'text\'        , NULL, NULL, \'[text-contains (^{value}^, ^{pattern}^)]\' ),\n"
"\'may_contain_text\',         vector (\'scalar\', \'text\'        , NULL, NULL, \'[text-contains (^{value}^, ^{pattern}^)]\' ),\n"
"\n"
"\'xcontains\',                vector (\'scalar\', \'XML\'         , NULL, NULL, \'[^{pattern}^]\' )\n"
");\n"
"}\n"
"--src dav_api.sql:6763\n"
;

static const char *proc248 = 
"#line 6799 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_FC_TABLE_METAS (inout table_metas any)\n"
"{\n"
"table_metas := vector (\n"
"\'SYS_DAV_RES\'       , vector (      \'\'      ,\n"
"\'\'      ,\n"
"\'RES_CONTENT\'   , \'RES_CONTENT\' , \'[__quiet] /\' ),\n"
"\'SYS_DAV_COL\'       , vector (      \'\\n  inner join WS.WS.SYS_DAV_COL as ^{alias}^ on ((^{alias}^.COL_ID = _top.RES_COL)^{andpredicates}^)\' ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_COL as ^{alias}^ where (^{alias}^.COL_ID = _top.RES_COL)^{andpredicates}^)\'    ,\n"
"NULL            , NULL          , NULL  ),\n"
"\'SYS_DAV_USER\'      , vector (      \'\\n  left outer join WS.WS.SYS_DAV_USER as ^{alias}^ on ((^{alias}^.U_ID = _top.RES_OWNER)^{andpredicates}^)\'   ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_USER as ^{alias}^ where (^{alias}^.U_ID = _top.RES_OWNER)^{andpredicates}^)\'   ,\n"
"NULL            , NULL          , NULL  ),\n"
"\'SYS_DAV_GROUP\'     , vector (      \'\\n  left outer join WS.WS.SYS_DAV_GROUP as ^{alias}^ on ((^{alias}^.G_ID = _top.RES_GROUP)^{andpredicates}^)\'  ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_GROUP as ^{alias}^ where (^{alias}^.G_ID = _top.RES_GROUP)^{andpredicates}^)\'  ,\n"
"NULL            , NULL          , NULL  ),\n"
"\'SYS_DAV_PROP\'      , vector (      \'\\n  inner join WS.WS.SYS_DAV_PROP as ^{alias}^ on ((^{alias}^.PROP_PARENT_ID = _top.RES_ID) and (^{alias}^.PROP_TYPE = \'\'R\'\')^{andpredicates}^)\'       ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_PROP as ^{alias}^ where (^{alias}^.PROP_PARENT_ID = _top.RES_ID) and (^{alias}^.PROP_TYPE = \'\'R\'\')^{andpredicates}^)\'  ,\n"
"\'PROP_VALUE\'    , \'PROP_VALUE\'  , \'[__quiet __davprop xmlns:virt=\"virt\"] .\'     ),\n"
"\'public-tags\'       , vector (      \'\\n  inner join WS.WS.SYS_DAV_TAG as ^{alias}^ on ((^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid())^{andpredicates}^)\'   ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_TAG as ^{alias}^ where (^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid())^{andpredicates}^)\'      ,\n"
"\'DT_TAGS\'       , \'DT_TAGS\'     , NULL  ),\n"
"\'private-tags\'      , vector (      \'\\n  inner join WS.WS.SYS_DAV_TAG as ^{alias}^ on ((^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'     ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_TAG as ^{alias}^ where (^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'        ,\n"
"\'DT_TAGS\'       , \'DT_TAGS\'     , NULL  ),\n"
"\'all-tags\'          , vector (      \'\\n  inner join WS.WS.SYS_DAV_TAG as ^{alias}^ on ((^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid() or ^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'    ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_TAG as ^{alias}^ where (^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid() or ^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'       ,\n"
"\'DT_TAGS\'       , \'DT_TAGS\'     , NULL  )\n"
");\n"
"}\n"
"--src dav_api.sql:6797\n"
;

static const char *proc249 = 
"#line 6831 \"[executable]/dav_api.sql\"\n"
"create function DAV_FC_PRINT_COMPARISON (inout pred any, inout pred_metas any, inout cmp_metas any, in varname varchar, in nonsql integer) returns varchar\n"
"{\n"
"declare pred_meta any;\n"
"declare cmp_meta, pattern_sample, cuts any;\n"
"declare var_expn, cmp_type, pattern_type, cond_format varchar;\n"
"declare res varchar;\n"
"pred_meta := get_keyword (pred[0], pred_metas);\n"
"cmp_meta := get_keyword (pred[1], cmp_metas);\n"
"cond_format := cmp_meta [3 + nonsql];\n"
"if (cond_format is null)\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_PRINT_COMPARISON on non-comparison predicate\');\n"
"cmp_type := cmp_meta[1];\n"
"pattern_sample := pred[2];\n"
"if (\'scalar\' = cmp_meta[0])\n"
"{\n"
"if (not (__tag (pattern_sample) in (182, 189, 211)))\n"
"goto bad_pattern_datatype;\n"
"}\n"
"else if (\'vector\' = cmp_meta[0])\n"
"{\n"
"if (193 <> __tag (pattern_sample))\n"
"goto bad_pattern_datatype;\n"
"if (0 = length (pattern_sample))\n"
"goto empty_array_pattern;\n"
"pattern_sample := pattern_sample[0];\n"
"if (not (__tag (pattern_sample) in (182, 189, 211)))\n"
"goto bad_pattern_datatype;\n"
"foreach (any itm in pred[2]) do\n"
"{\n"
"if (__tag (itm) <> __tag(pred[2][0]))\n"
"goto mixed_array_pattern;\n"
"}\n"
"}\n"
"else if (\'no\' = cmp_meta[0])\n"
"{\n"
"pattern_sample := \'\';\n"
"}\n"
"else signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_CMP_META forms bad sort of match pattern\');\n"
"if (isstring (pattern_sample))\n"
"pattern_type := \'varchar\';\n"
"else if (isinteger (pattern_sample))\n"
"pattern_type := \'integer\';\n"
"else if (211 = __tag (pattern_sample))\n"
"pattern_type := \'datetime\';\n"
"else\n"
"goto bad_pattern_datatype;\n"
"if (\'sortable\' = cmp_type)\n"
"{\n"
"\n"
"\n"
"cmp_type := pattern_type;\n"
"}\n"
"else if (\'any\' = cmp_type)\n"
"{\n"
"pattern_type := pred_meta[2];\n"
"}\n"
"else if (\n"
"(1 = nonsql) and\n"
"(\'varchar\' = pattern_type) and\n"
"((\'text\' = cmp_type) or (\'XML\' = cmp_type)) )\n"
"{\n"
"pattern_type := pred_meta[2];\n"
"}\n"
"else if (pattern_type <> cmp_type)\n"
"goto bad_pattern_datatype;\n"
"if (pred_meta[2] = pattern_type)\n"
"{\n"
"var_expn := varname;\n"
"}\n"
"else if (1 = nonsql)\n"
"{\n"
"if ((\'text\' = cmp_meta) or (\'XML\' = cmp_meta))\n"
"var_expn := varname;\n"
"else if (\'varchar\' = pattern_type)\n"
"var_expn := sprintf (\'string (%s)\', varname);\n"
"else if (\'integer\' = pattern_type)\n"
"var_expn := sprintf (\'number (%s)\', varname);\n"
"else if (\'datetime\' = pattern_type)\n"
"var_expn := sprintf (\'dateTime (%s, 1)\', varname);\n"
"else\n"
"goto type_mismatch;\n"
"}\n"
"else\n"
"{\n"
"if (\'varchar\' = pred_meta[2])\n"
"var_expn := sprintf (\'DB.DBA.DAV_CAST_STRING_TO_%s (%s)\', upper (cmp_type), varname);\n"
"else if (\'text\' = pred_meta[2])\n"
"var_expn := sprintf (\'DB.DBA.DAV_CAST_TEXT_TO_%s (%s)\', upper (cmp_type), varname);\n"
"else\n"
"goto type_mismatch;\n"
"}\n"
"if ((\'like\' = pred[1]) and (\'%\' = pred[2]))\n"
"return null;\n"
"if ((\'starts_with\' = pred[1]) and (\'\' = pred[2]))\n"
"return null;\n"
"if ((\'ends_with\' = pred[1]) and (\'\' = pred[2]))\n"
"return null;\n"
"res := \'\';\n"
"cuts := split_and_decode (cond_format, 0, \'\\0\\0^\');\n"
"foreach (varchar cut in cuts) do\n"
"{\n"
"if (cut = \'\' or (cut[0] <> \'{\'[0]))\n"
"res := res || cut;\n"
"else if (cut = \'{value}\')\n"
"res := res || var_expn;\n"
"else if (cut = \'{pattern}\')\n"
"res := res || DAV_FC_CONST_AS_SQL (pred[2]);\n"
"else if (cut = \'{pattern0}\')\n"
"{\n"
"res := res || DAV_FC_CONST_AS_SQL (pred[2][0]);\n"
"}\n"
"else if (cut = \'{pattern1}\')\n"
"{\n"
"if (length (pred[2]) < 2)\n"
"goto tooshort_array_pattern;\n"
"res := res || DAV_FC_CONST_AS_SQL (pred[2][1]);\n"
"}\n"
"else signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_CMP_META forms bad formatting pattern\');\n"
"}\n"
"return res;\n"
"\n"
"bad_pattern_datatype:\n"
"signal (\'.....\', sprintf (\'Bad data type (%d) of pattern value in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', __tag (pattern_sample), pred[0], pred[1]));\n"
"empty_array_pattern:\n"
"signal (\'.....\', sprintf (\'The pattern is an empty vector in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', pred[0], pred[1]));\n"
"tooshort_array_pattern:\n"
"signal (\'.....\', sprintf (\'The pattern vector is too short in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', pred[0], pred[1]));\n"
"mixed_array_pattern:\n"
"signal (\'.....\', sprintf (\'All items of the pattern vector must have same datatype in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', pred[0], pred[1]));\n"
"type_mismatch:\n"
"signal (\'.....\', sprintf (\'Can not compile comparison \'\'%s %s %s\'\' due to type mismatch in predicate \'\'%s\'\' in filter of DAV_DIR_FILTER, \', pred_meta[2], pred[1], pattern_type, pred[0]));\n"
"}\n"
"--src dav_api.sql:6829\n"
;

static const char *proc250 = 
"#line 6966 \"[executable]/dav_api.sql\"\n"
"create function DAV_FC_PRINT_WHERE (inout filter any, in param_uid integer) returns varchar\n"
"{\n"
"declare pred_metas, cmp_metas, table_metas any;\n"
"declare used_tables any;\n"
"\n"
"DAV_FC_PRED_METAS (pred_metas);\n"
"DAV_FC_CMP_METAS (cmp_metas);\n"
"DAV_FC_TABLE_METAS (table_metas);\n"
"used_tables := vector (\'SYS_DAV_RES\', vector (\'SYS_DAV_RES\', \'_top\', null, vector (), vector (), vector ()));\n"
"return DAV_FC_PRINT_WHERE_INT (filter, pred_metas, cmp_metas, table_metas, used_tables, param_uid);\n"
"}\n"
"--src dav_api.sql:6964\n"
;

static const char *proc251 = 
"#line 6979 \"[executable]/dav_api.sql\"\n"
"create function DAV_FC_PRINT_WHERE_INT (in filter any, inout pred_metas any, inout cmp_metas any, inout table_metas any, inout used_tables any, in param_uid integer) returns varchar\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare pred_count, pred_idx, need_and, need_top_and integer;\n"
"declare table_count, table_idx, fixed_used_tables, first_ft_table_idx integer;\n"
"declare table_of_pred, ses any;\n"
"declare res_strg varchar;\n"
"pred_count := length (filter);\n"
"fixed_used_tables := length (used_tables);\n"
"if ((0 = pred_count) and (2 = fixed_used_tables))\n"
"return \'\\nwhere\\n(1=1)\\n\';\n"
"\n"
"table_of_pred := make_array (pred_count, \'any\');\n"
"pred_idx := 0;\n"
"while (pred_idx < pred_count)\n"
"{\n"
"declare pred, pred_meta, cmp_meta any;\n"
"declare pred_table_key, optext, cmp_text, ftc_text, xc_text varchar;\n"
"declare join_with_prop_name, used_table_pos integer;\n"
"pred := filter[pred_idx];\n"
"pred_meta := get_keyword (pred[0], pred_metas);\n"
"if (pred_meta is null)\n"
"{\n"
"signal (\'.....\', sprintf (\'Invalid predicate type \'\'%s\'\' in filter of DAV_DIR_FILTER\', cast (pred[0] as varchar)));\n"
"}\n"
"if (length (pred) <> 3 + pred_meta[1])\n"
"signal (\'.....\', sprintf (\'Predicate with type \'\'%s\'\' should be a vector of length %d in filter of DAV_DIR_FILTER\', pred[0], (3 + pred_meta[1])));\n"
"cmp_meta := get_keyword (pred[1], cmp_metas);\n"
"if (cmp_meta is null)\n"
"signal (\'.....\', sprintf (\'Invalid operation name \'\'%s\'\' in filter of DAV_DIR_FILTER\', pred[1]));\n"
"join_with_prop_name := 0;\n"
"if ((\'PROP_VALUE\' = pred[0]) or (\'RDF_PROP\' = pred[0]) or (\'RDF_VALUE\' = pred[0]) or (\'RDF_OBJ_VALUE\' = pred[0]))\n"
"{\n"
"if (get_keyword (pred_meta[0], used_tables) is null)\n"
"join_with_prop_name := 1;\n"
"else\n"
"{\n"
"filter := vector_concat (filter, vector (vector (\'PROP_NAME\', \'=\', pred[3])));\n"
"table_of_pred := vector_concat (table_of_pred, vector (null));\n"
"pred_count := pred_count + 1;\n"
"}\n"
"}\n"
"if (join_with_prop_name)\n"
"{\n"
"if (not isstring (pred[3]))\n"
"signal (\'.....\', sprintf (\'The DAV property name in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"pred_table_key := concat (pred_meta[0], \', PROP_NAME=\', pred[3]);\n"
"}\n"
"else\n"
"pred_table_key := pred_meta[0];\n"
"used_table_pos := position (pred_table_key, used_tables, 1, 2);\n"
"if (0 = used_table_pos)\n"
"{\n"
"declare cmp_checks any;\n"
"declare new_alias varchar;\n"
"used_table_pos := length (used_tables) + 1;\n"
"new_alias := sprintf (\'_sub%d\', pred_idx);\n"
"if (join_with_prop_name)\n"
"cmp_checks := sprintf (\'(%s.PROP_NAME = %s)\', new_alias, WS.WS.STR_SQL_APOS (pred[3]));\n"
"else\n"
"cmp_checks := null;\n"
"used_tables := vector_concat (used_tables, vector (pred_table_key, vector (pred_meta[0], new_alias, cmp_checks, vector (), vector (), vector ())));\n"
"}\n"
"table_of_pred [pred_idx] := used_table_pos;\n"
"cmp_text := null;\n"
"ftc_text := null;\n"
"xc_text := null;\n"
"if (pred_meta[3] = \'\')\n"
"{\n"
"if ((\'may_contain_text\' = pred[1]) or (\'may_contain_tags\' = pred[1]))\n"
"{\n"
" ;\n"
"}\n"
"else if (\'is_null\' = pred[1])\n"
"{\n"
" ;\n"
"}\n"
"else\n"
"return \'1=2\';\n"
"}\n"
"else\n"
"if (pred_meta[3] is not null and cmp_meta[3] is not null)\n"
"{\n"
"declare varname varchar;\n"
"if (strchr (pred_meta[3], \'(\') is not null)\n"
"varname := pred_meta[3];\n"
"else\n"
"{\n"
"varname := concat (used_tables[used_table_pos][1], \'.\', pred_meta[3]);\n"
"}\n"
"cmp_text := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, varname, 0);\n"
"}\n"
"else if (\'RDF_PROP\' = pred[0])\n"
"{\n"
"optext := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, \'name(.)\', 1);\n"
"if (optext is null)\n"
"xc_text := \'[virt:rdf/virt:top-res[virt:prop]]\';\n"
"else\n"
"xc_text := \'[virt:rdf/virt:top-res/virt:prop/*[1]\' || optext || \']\';\n"
"}\n"
"else if (\'RDF_VALUE\' = pred[0])\n"
"{\n"
"optext := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, \'.\', 1);\n"
"if (optext is null)\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]][virt:value]]\', pred[4]);\n"
"else\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:value%s]\', pred[4], optext);\n"
"}\n"
"else if (\'RDF_OBJ_VALUE\' = pred[0])\n"
"{\n"
"optext := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, \'.\', 1);\n"
"if (optext is null)\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:res/virt:prop[*[1][self::(!%s!)]][virt:value]]\', pred[4], pred[5]);\n"
"else\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:res/virt:prop[*[1][self::(!%s!)]]/virt:value%s]\', pred[4], pred[5], optext);\n"
"}\n"
"else if ((\'contains_text\' = pred[1]) or (\'may_contain_text\' = pred[1]))\n"
"{\n"
"if (not (isstring (pred[2])))\n"
"signal (\'.....\', sprintf (\'Free text pattern in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"ftc_text := \'(\' || pred[2] || \')\';\n"
"}\n"
"else if ((\'contains_tags\' = pred[1]) or (\'may_contain_tags\' = pred[1]))\n"
"{\n"
"if (not (isstring (pred[2])))\n"
"signal (\'.....\', sprintf (\'String of tags in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"ftc_text := \'(\"\' || replace (WS.WS.DAV_TAG_NORMALIZE (pred[2]), \' \', \'\" and \"\') || \'\")\';\n"
"if (\'RES_TAGS\' = pred[0])\n"
"ftc_text := \'((\"UID^{uid}^\" or \"UID^{nobodyuid}^\") and \' || ftc_text || \')\';\n"
"else if (\'RES_PUBLIC_TAGS\' = pred[0])\n"
"ftc_text := \'(\"UID^{nobodyuid}^\" and \' || ftc_text || \')\';\n"
"else if (\'RES_PRIVATE_TAGS\' = pred[0])\n"
"ftc_text := \'(\"UID^{uid}^\" and \' || ftc_text || \')\';\n"
"}\n"
"else if (\'xcontains\' = pred[1])\n"
"{\n"
"if (not (isstring (pred[2])))\n"
"signal (\'.....\', sprintf (\'Free text pattern in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"\n"
"\n"
"xc_text := \'[\' || pred[2] || \']\';\n"
"}\n"
"else\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: no condition text generated for a predicate\');\n"
"if (cmp_text is not null and (0 = position (cmp_text, used_tables[used_table_pos][3])))\n"
"used_tables[used_table_pos][3] := vector_concat (used_tables[used_table_pos][3], vector (cmp_text));\n"
"if (ftc_text is not null and (0 = position (ftc_text, used_tables[used_table_pos][4])))\n"
"used_tables[used_table_pos][4] := vector_concat (used_tables[used_table_pos][4], vector (ftc_text));\n"
"if (xc_text is not null and (0 = position (xc_text, used_tables[used_table_pos][5])))\n"
"used_tables[used_table_pos][5] := vector_concat (used_tables[used_table_pos][5], vector (xc_text));\n"
"pred_idx := pred_idx + 1;\n"
"}\n"
"if ((2 = length (used_tables)) and\n"
"(0 = length (used_tables[1][3])) and\n"
"(0 = length (used_tables[1][4])) and\n"
"(0 = length (used_tables[1][5])) )\n"
"return \'\\nwhere\\n(1=1)\\n\';\n"
"\n"
"ses := string_output();\n"
"table_count := length (used_tables);\n"
"first_ft_table_idx := null;\n"
"for (table_idx := 1; (table_idx < table_count) and first_ft_table_idx is null ; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl any;\n"
"tbl := used_tables [table_idx];\n"
"if ((length (tbl[4]) > 0) or (length (tbl[5]) > 0))\n"
"first_ft_table_idx := table_idx;\n"
"}\n"
"for (table_idx := 1; table_idx < table_count; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl, new_tbl any;\n"
"declare has_ft, has_xc integer;\n"
"tbl := used_tables [table_idx];\n"
"has_ft := length (tbl[4]);\n"
"has_xc := length (tbl[5]);\n"
"if ((has_ft and has_xc) or\n"
"((table_idx > first_ft_table_idx) and\n"
"(table_idx < fixed_used_tables) and\n"
"(has_ft or has_xc) ) )\n"
"{\n"
"declare cmp_checks any;\n"
"declare new_alias varchar;\n"
"new_alias := sprintf (\'%s_%d\', tbl[1], table_idx);\n"
"if (tbl[2] like \'(%.PROP_NAME = %)\')\n"
"cmp_checks := sprintf (\'(%s.PROP_NAME = %s.PROP_NAME)\', new_alias, tbl[1]);\n"
"else\n"
"cmp_checks := null;\n"
"new_tbl := vector (tbl[0], new_alias, cmp_checks, vector (), vector (), vector ());\n"
"if ((table_idx > first_ft_table_idx) and\n"
"(table_idx < fixed_used_tables) and\n"
"(has_ft or has_xc) )\n"
"{\n"
"new_tbl[4] := tbl[4];\n"
"new_tbl[5] := tbl[5];\n"
"tbl[4] := null;\n"
"tbl[5] := null;\n"
"}\n"
"else if (has_xc)\n"
"{\n"
"new_tbl[5] := tbl[5];\n"
"tbl[5] := null;\n"
"}\n"
"else if (has_ft)\n"
"{\n"
"new_tbl[4] := tbl[4];\n"
"tbl[4] := null;\n"
"}\n"
"else\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: cannot handle a combination of free-text and xcontain predicates\');\n"
"used_tables := vector_concat (used_tables,\n"
"vector (used_tables [table_idx-1], new_tbl) );\n"
"table_count := table_count + 2;\n"
"}\n"
"}\n"
"if (first_ft_table_idx is null)\n"
"first_ft_table_idx := table_count;\n"
"\n"
"for (table_idx := fixed_used_tables + 1; table_idx < table_count ; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl, tbl_meta any;\n"
"\n"
"tbl := used_tables [table_idx];\n"
"tbl_meta := get_keyword (tbl[0], table_metas);\n"
"if (tbl_meta is null)\n"
"signal (\'.....\', sprintf (\'Internal error in DAV_DIR_FILTER: bad table %s\', tbl[0]));\n"
"if ((table_idx <= first_ft_table_idx) or ((length (tbl[4]) = 0) and (length (tbl[5]) = 0)))\n"
"{\n"
"declare andpredicates, join_code varchar;\n"
"if (length (tbl[2]) > 0)\n"
"andpredicates := \' AND \' || tbl[2];\n"
"else\n"
"andpredicates := \'\';\n"
"join_code := replace (replace (tbl_meta[0], \'^{alias}^\', tbl[1]), \'^{andpredicates}^\', andpredicates);\n"
"http (join_code, ses);\n"
"}\n"
"}\n"
"http (\'\\nwhere\\n\', ses);\n"
"need_top_and := 0;\n"
"for (table_idx := 1; table_idx < table_count ; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl, tbl_meta, subses any;\n"
"declare subses_strg varchar;\n"
"\n"
"tbl := used_tables [table_idx];\n"
"tbl_meta := get_keyword (tbl[0], table_metas);\n"
"subses := string_output ();\n"
"need_and := 0;\n"
"if (length (tbl[4]) > 0)\n"
"{\n"
"declare ft_field, varname, ft_pattern varchar;\n"
"declare need_ft_and integer;\n"
"ft_field := tbl_meta[2];\n"
"if (ft_field is null)\n"
"signal (\'.....\', sprintf (\'Internal error in DAV_DIR_FILTER: bad table %s for free text search\', tbl[0]));\n"
"varname := concat (tbl[1], \'.\', ft_field);\n"
"need_ft_and := 0;\n"
"ft_pattern := \'\';\n"
"foreach (varchar ft_term in tbl[4]) do\n"
"{\n"
"if (need_ft_and)\n"
"ft_pattern := ft_pattern || \' and \';\n"
"else\n"
"need_ft_and := 1;\n"
"ft_pattern := ft_pattern || ft_term;\n"
"}\n"
"if (need_and)\n"
"http (\' and\\n  \', subses);\n"
"else\n"
"need_and := 1;\n"
"http (sprintf (\'contains (%s, \', varname), subses);\n"
"http (WS.WS.STR_SQL_APOS (ft_pattern), subses);\n"
"http (\')\', subses);\n"
"}\n"
"if (length (tbl[5]) > 0)\n"
"{\n"
"declare ft_field, varname, ft_pattern varchar;\n"
"ft_field := tbl_meta[3];\n"
"if (ft_field is null)\n"
"signal (\'.....\', sprintf (\'Internal error in DAV_DIR_FILTER: bad table %s for xcontains search\', tbl[0]));\n"
"varname := concat (tbl[1], \'.\', ft_field);\n"
"ft_pattern := tbl_meta[4];\n"
"if (length (tbl[5]) = 1)\n"
"{\n"
"ft_pattern := ft_pattern || tbl[5][0];\n"
"}\n"
"else\n"
"{\n"
"foreach (varchar ft_term in tbl[5]) do\n"
"{\n"
"ft_pattern := ft_pattern || ft_term;\n"
"}\n"
"}\n"
"if (need_and)\n"
"http (\' and\\n  \', subses);\n"
"else\n"
"need_and := 1;\n"
"http (sprintf (\'xcontains (%s, \', varname), subses);\n"
"http (WS.WS.STR_SQL_APOS (ft_pattern), subses);\n"
"http (\')\', subses);\n"
"}\n"
"foreach (varchar cond in tbl[3]) do\n"
"{\n"
"if (need_and)\n"
"http (\' and\\n  \', subses);\n"
"else\n"
"need_and := 1;\n"
"http (cond, subses);\n"
"}\n"
"subses_strg := string_output_string (subses);\n"
"if (subses_strg <> \'\')\n"
"{\n"
"if (need_top_and)\n"
"http (\' and\\n  \', ses);\n"
"else\n"
"need_top_and := 1;\n"
"if ((table_idx <= first_ft_table_idx) or ((length (tbl[4]) = 0) and (length (tbl[5]) = 0)))\n"
"http (subses_strg, ses);\n"
"else\n"
"{\n"
"declare exists_code varchar;\n"
"exists_code := replace (replace (tbl_meta[1], \'^{alias}^\', tbl[1]), \'^{andpredicates}^\', \' and\\n  \' || subses_strg);\n"
"http (exists_code, ses);\n"
"}\n"
"}\n"
"}\n"
"if (not need_top_and)\n"
"http (\'(1=1) \', ses);\n"
"res_strg := string_output_string (ses);\n"
"res_strg := replace (res_strg, \'^{uid}^\', cast (param_uid as varchar));\n"
"res_strg := replace (res_strg, \'^{nobodyuid}^\', cast (http_nobody_uid() as varchar));\n"
"return res_strg;\n"
"}\n"
"--src dav_api.sql:6977\n"
;

static const char *proc252 = 
"#line 7322 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_REGISTER_RDF_SCHEMA (\n"
"in schema_uri varchar,\n"
"in location varchar,\n"
"in local_addon varchar,\n"
"in mode varchar)\n"
"{\n"
"if (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri))\n"
"{\n"
"mode := lower (mode);\n"
"if (\'into\' = mode)\n"
"{\n"
"signal (\'23000\', sprintf (\'Uniqueness violation: RDF schema \'\'%s\'\' is already registered\', schema_uri));\n"
"}\n"
"else if (\'replacing\' = mode)\n"
"{\n"
"insert replacing WS.WS.SYS_RDF_SCHEMAS (RS_URI, RS_LOCATION, RS_LOCAL_ADDONS, RS_DEPRECATED)\n"
"values (schema_uri, location, local_addon, 0);\n"
"}\n"
"else if (\'soft\' = mode)\n"
"{\n"
"update WS.WS.SYS_RDF_SCHEMAS set RS_LOCAL_ADDONS = local_addon, RS_DEPRECATED = 0 where RS_URI = schema_uri and RS_LOCAL_ADDONS is null;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"insert replacing WS.WS.SYS_RDF_SCHEMAS (RS_URI, RS_LOCATION, RS_LOCAL_ADDONS, RS_DEPRECATED)\n"
"values (schema_uri, location, local_addon, 0);\n"
"}\n"
"\n"
"DAV_GET_RDF_SCHEMA_N3 (schema_uri);\n"
"}\n"
"--src dav_api.sql:7320\n"
;

static const char *proc253 = 
"#line 7357 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RDF_SCHEMA_N3_LIST_PROPERTIES (\n"
"inout schema_n3 any,\n"
"in classname varchar)\n"
"{\n"
"if (classname is null)\n"
"{\n"
"return xpath_eval (\'\n"
"let (\"excl\",\n"
"distinct (\n"
"for (\"dom\",\n"
"/N3\n"
"[@N3P=\"http://www.openlinksw.com/schemas/virtrdf#domain\"],\n"
"string (\\044dom/@N3S) ) ),\n"
"/N3\n"
"[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"]\n"
"[@N3O=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#Property\"]\n"
"[not (@N3S = \\044excl)]\n"
"/@N3S )\',\n"
"schema_n3, 1 );\n"
"}\n"
"return xpath_eval (\'\n"
"let (\"incl\",\n"
"distinct (\n"
"for (\"dom\",\n"
"/N3\n"
"[@N3P=\"http://www.openlinksw.com/schemas/virtrdf#domain\"]\n"
"[@N3O=\\044classname],\n"
"string (\\044dom/@N3S) ) ),\n"
"/N3\n"
"[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"]\n"
"[@N3O=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#Property\"]\n"
"[@N3S=\\044incl]\n"
"/@N3S )\',\n"
"schema_n3, 1, vector (\'classname\', classname) );\n"
"}\n"
"--src dav_api.sql:7355\n"
;

static const char *proc254 = 
"#line 7395 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_CROP_URI_TO_CATNAME (\n"
"in uri varchar)\n"
"{\n"
"declare res varchar;\n"
"declare slash integer;\n"
"\n"
"uri := replace (uri, \'#\', \'/\');\n"
"\n"
"again:\n"
"if (uri like \'%/\')\n"
"{\n"
"uri := subseq (uri, 0, length (uri) - 1);\n"
"goto again;\n"
"}\n"
"\n"
"if (uri like \'http://%\')\n"
"{\n"
"uri := subseq (uri, 7);\n"
"goto again;\n"
"}\n"
"\n"
"slash := strrchr (uri, \'/\');\n"
"if (slash is not null)\n"
"return subseq (uri, slash + 1);\n"
"\n"
"return uri;\n"
"}\n"
"--src dav_api.sql:7393\n"
;

static const char *proc255 = 
"#line 7426 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_GET_RDF_SCHEMA_N3 (\n"
"in schema_uri varchar)\n"
"{\n"
"for (select RS_LOCATION, RS_LOCAL_ADDONS, RS_PRECOMPILED from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri) do\n"
"{\n"
"declare std_schema, local_addon, mix any;\n"
"declare schema_catname varchar;\n"
"declare prop_list, prop_catnames, prop_catnames_hash any;\n"
"\n"
"if (RS_PRECOMPILED is not null)\n"
"return RS_PRECOMPILED;\n"
"\n"
"if (RS_LOCATION is null)\n"
"{\n"
"std_schema := NULL;\n"
"}\n"
"else\n"
"{\n"
"std_schema := xtree_doc (XML_URI_GET_AND_CACHE (RS_LOCATION), 0, RS_LOCATION);\n"
"std_schema := xslt (\'http://local.virt/rdfxml2n3xml\', std_schema);\n"
"}\n"
"if (RS_LOCAL_ADDONS is null)\n"
"{\n"
"local_addon := NULL;\n"
"}\n"
"else\n"
"{\n"
"local_addon := xtree_doc (XML_URI_GET (\'\', RS_LOCAL_ADDONS), 0, RS_LOCAL_ADDONS);\n"
"local_addon := xslt (\'http://local.virt/rdfxml2n3xml\', local_addon);\n"
"}\n"
"mix := DAV_RDF_MERGE (std_schema, local_addon, null, -1);\n"
"\n"
"\n"
"\n"
"schema_catname := xpath_eval (\'/N3[@N3S=\\044schema-uri][@N3P=\"http://www.openlinksw.com/schemas/virtrdf#catName\"]\', mix, 1, vector (UNAME\'schema-uri\', schema_uri));\n"
"if (schema_catname is not null)\n"
"{\n"
"schema_catname := replace (replace (cast (schema_catname as varchar), \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"if (not exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"goto schema_catname_complete;\n"
"}\n"
"schema_catname := xpath_eval (\'/N3[@N3S=\\044schema-uri][@N3P=\"http://www.w3.org/2000/01/rdf-schema#label\"]\', mix, 1, vector (UNAME\'schema-uri\', schema_uri));\n"
"if (schema_catname is not null)\n"
"{\n"
"schema_catname := replace (replace (cast (schema_catname as varchar), \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"if (not exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"goto schema_catname_complete;\n"
"}\n"
"schema_catname := DAV_CROP_URI_TO_CATNAME (schema_uri);\n"
"schema_catname := replace (schema_catname, \'/\', \'-\' || \'-\');\n"
"if (not exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"goto schema_catname_complete;\n"
"\n"
"schema_catname := replace (replace (schema_uri, \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"while (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"{\n"
"schema_catname := sprintf (\'%s--%d\', (replace (schema_uri, \'#\', \'/\') , \'/\', \'-\' || \'-\'), 10000 + rnd (90000));\n"
"}\n"
"\n"
"schema_catname_complete:\n"
"\n"
"vectorbld_init (prop_catnames);\n"
"prop_catnames_hash := dict_new ();\n"
"prop_list := DAV_RDF_SCHEMA_N3_LIST_PROPERTIES (mix, NULL);\n"
"foreach (varchar propname in prop_list) do\n"
"{\n"
"declare catname varchar;\n"
"declare catid integer;\n"
"\n"
"catname := xpath_eval (\'/N3[@N3S=\\044propname][@N3P=\"http://www.openlinksw.com/schemas/virtrdf#catName\"]\', mix, 1, vector (UNAME\'propname\', propname));\n"
"propname := cast (propname as varchar);\n"
"if (catname is not null)\n"
"{\n"
"catname := replace (replace (cast (catname as varchar), \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"if (0 = dict_get (prop_catnames_hash, catname, 0))\n"
"goto prop_catname_complete;\n"
"}\n"
"catname := DAV_CROP_URI_TO_CATNAME (propname);\n"
"catname := replace (catname, \'/\', \'-\' || \'-\');\n"
"if (0 = dict_get (prop_catnames_hash, catname, 0))\n"
"goto prop_catname_complete;\n"
"\n"
"catname := replace (replace (propname, \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"while (dict_get (prop_catnames_hash, catname, 0))\n"
"catname := sprintf (\'%s--%d\', replace (replace (propname, \'#\', \'/\') , \'/\', \'-\' || \'-\'), 10000 + rnd (90000));\n"
"\n"
"prop_catname_complete:\n"
"catid := (select RPN_CATID from WS.WS.SYS_RDF_PROP_NAME where RPN_URI = propname);\n"
"if (catid is null)\n"
"{\n"
"catid := WS.WS.GETID (\'RPN\');\n"
"insert into WS.WS.SYS_RDF_PROP_NAME (RPN_URI, RPN_CATID) values (propname, catid);\n"
"}\n"
"vectorbld_acc (prop_catnames, propname, catname, catid, 0, 0, 0);\n"
"dict_put (prop_catnames_hash, catname, catid);\n"
"}\n"
"vectorbld_final (prop_catnames);\n"
"update WS.WS.SYS_RDF_SCHEMAS\n"
"set RS_PRECOMPILED = mix,\n"
"RS_COMPILATION_DATE = now (),\n"
"RS_CATNAME = schema_catname,\n"
"RS_PROP_CATNAMES = serialize (prop_catnames)\n"
"where RS_URI = schema_uri;\n"
"\n"
"return mix;\n"
"}\n"
"\n"
"return xtree_doc (\'<stub/>\');\n"
"}\n"
"--src dav_api.sql:7424\n"
;

static const char *proc256 = 
"#line 7538 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_DEPRECATE_RDF_SCHEMA (\n"
"in schema_uri varchar)\n"
"{\n"
"update WS.WS.SYS_RDF_SCHEMAS set RS_DEPRECATED = 1 where RS_URI = schema_uri;\n"
"if (exists (select top 1 1 from WS.WS.SYS_MIME_RDFS where MR_RDF_URI = schema_uri))\n"
"{\n"
"update WS.WS.SYS_MIME_RDFS set MR_DEPRECATED = 1 where MR_RDF_URI = schema_uri;\n"
"return;\n"
"}\n"
"\n"
"delete from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri and RS_LOCAL_ADDONS is null;\n"
"}\n"
"--src dav_api.sql:7536\n"
;

static const char *proc257 = 
"#line 7552 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_REGISTER_MIME_TYPE (\n"
"in m_ident varchar,\n"
"in descr varchar,\n"
"in dflt_ext varchar,\n"
"in badmagic varchar,\n"
"in mode varchar)\n"
"{\n"
"\n"
"\n"
"mode := lower (mode);\n"
"if (exists (select top 1 1 from WS.WS.SYS_MIME_TYPES where MT_IDENT = m_ident))\n"
"{\n"
"if (\'into\' = mode)\n"
"signal (\'23000\', sprintf (\'Uniqueness violation: MIME type \'\'%s\'\' is already registered\', m_ident));\n"
"\n"
"if (\'soft\' = mode)\n"
"return;\n"
"\n"
"if (\'replacing\' = mode)\n"
"insert replacing WS.WS.SYS_MIME_TYPES (MT_IDENT, MT_DESCRIPTION, MT_DEFAULT_EXT, MT_BADMAGIC_IDENT)\n"
"values (m_ident, descr, dflt_ext, badmagic);\n"
"}\n"
"else\n"
"{\n"
"insert replacing WS.WS.SYS_MIME_TYPES (MT_IDENT, MT_DESCRIPTION, MT_DEFAULT_EXT, MT_BADMAGIC_IDENT)\n"
"values (m_ident, descr, dflt_ext, badmagic);\n"
"}\n"
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (m_ident, dflt_ext);\n"
"}\n"
"--src dav_api.sql:7550\n"
;

static const char *proc258 = 
"#line 7583 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_REGISTER_MIME_RDF (\n"
"in m_ident varchar,\n"
"in schema_uri varchar)\n"
"{\n"
"insert replacing WS.WS.SYS_MIME_RDFS (MR_MIME_IDENT, MR_RDF_URI, MR_DEPRECATED)\n"
"values (m_ident, schema_uri, 0);\n"
"}\n"
"--src dav_api.sql:7581\n"
;

static const char *proc259 = 
"#line 7592 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_DEPRECATE_MIME_RDF (\n"
"in m_ident varchar,\n"
"in schema_uri varchar)\n"
"{\n"
"update WS.WS.SYS_MIME_RDFS set MR_DEPRECATED = 1 where MR_MIME_IDENT = m_ident and MR_RDF_URI = schema_uri;\n"
"}\n"
"--src dav_api.sql:7590\n"
;

static const char *proc260 = 
"#line 7601 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RDF_PROP_SET (\n"
"in path varchar,\n"
"in single_schema varchar,\n"
"in rdf any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null) returns integer\n"
"{\n"
"return DAV_RDF_PROP_SET_INT (path, single_schema, rdf, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:7599\n"
;

static const char *proc261 = 
"#line 7613 \"[executable]/dav_api.sql\"\n"
" create procedure DAV_RDF_PROP_GET (\n"
"in path varchar,\n"
"in single_schema varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null) returns any\n"
"{\n"
"declare st varchar;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"return DAV_RDF_PROP_GET_INT (DAV_SEARCH_ID (path, st), st, single_schema, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:7611\n"
;

static const char *proc262 = 
"#line 7629 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_PREPROCESS_RDFXML_SUB (\n"
"inout n3_subj_dict any,\n"
"in main_res nvarchar,\n"
"in mode integer,\n"
"inout firsttime_subj_list any) returns any\n"
"{\n"
"\n"
"declare top_props, top_acc, top_head, top_tag any;\n"
"declare firsttime_use integer;\n"
"declare isdupe varchar;\n"
"\n"
"top_props := dict_get (n3_subj_dict, main_res, 0);\n"
"xte_nodebld_init (top_acc);\n"
"firsttime_use := position (main_res, firsttime_subj_list);\n"
"if (firsttime_use > 0)\n"
"{\n"
"firsttime_subj_list [firsttime_use-1] := \'\';\n"
"isdupe := null;\n"
"}\n"
"else\n"
"isdupe := \'Y\';\n"
"if (mode = 2)\n"
"top_tag := UNAME\'virt:top-res\';\n"
"else\n"
"top_tag := UNAME\'virt:res\';\n"
"if (main_res like N\'nodeID://%\')\n"
"{\n"
"top_head := xte_head (top_tag, UNAME\'N3S\', main_res, UNAME\'N3DUPE\', isdupe);\n"
"}\n"
"else\n"
"{\n"
"top_head := xte_head (top_tag, UNAME\'N3DUPE\', isdupe);\n"
"xte_nodebld_acc (top_acc, xte_node (xte_head (main_res)));\n"
"}\n"
"if (not (isinteger (top_props)))\n"
"{\n"
"if (isinteger (top_props[0]))\n"
"{\n"
"vectorbld_final (top_props);\n"
"dict_put (n3_subj_dict, main_res, top_props);\n"
"}\n"
"foreach (any n3 in top_props) do\n"
"{\n"
"declare obj_res nvarchar;\n"
"declare obj_subtree any;\n"
"obj_res := xpath_eval (\'@N3O\', n3);\n"
"if (obj_res is null)\n"
"{\n"
"obj_subtree := xte_node (\n"
"xte_head ( UNAME\'virt:value\',\n"
"UNAME\'N3DT\', xpath_eval (\'@N3DT\', n3),\n"
"UNAME\'xml:lang\', xpath_eval (\'@xml:lang\', n3)),\n"
"xpath_eval (\'node()\', n3) );\n"
"}\n"
"else if (not (obj_res like N\'nodeID://%\'))\n"
"obj_subtree := xte_node (xte_head (UNAME\'virt:res\'), xte_node (xte_head (obj_res)));\n"
"else if (mode > 0)\n"
"obj_subtree := DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, obj_res, 0, firsttime_subj_list);\n"
"else\n"
"obj_subtree := xte_node (xte_head (UNAME\'virt:res\', UNAME\'N3S\', obj_res));\n"
"xte_nodebld_acc (top_acc,\n"
"xte_node (\n"
"xte_head (UNAME\'virt:prop\', UNAME\'N3ID\', xpath_eval(\'@N3ID\', n3)),\n"
"xte_node (xte_head (xpath_eval (\'@N3P\', n3))),\n"
"obj_subtree ) );\n"
"}\n"
"}\n"
"xte_nodebld_final (top_acc, top_head);\n"
"return top_acc;\n"
"}\n"
"--src dav_api.sql:7627\n"
;

static const char *proc263 = 
"#line 7702 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_PREPROCESS_RDFXML (\n"
"in rdfxml any,\n"
"in main_res nvarchar,\n"
"in already_n3 integer := 0)\n"
"{\n"
"declare n3xml, n3_list, n3_subj_dict, rdf_acc, subj_list, firsttime_subj_list any;\n"
"declare tmp varchar;\n"
"if (already_n3)\n"
"n3xml := rdfxml;\n"
"else\n"
"n3xml := xslt (\'http://local.virt/rdfxml2n3xml\', rdfxml);\n"
"n3_subj_dict := dict_new ();\n"
"n3_list := xpath_eval (\'/N3\', n3xml, 0);\n"
"foreach (any n3 in n3_list) do\n"
"{\n"
"declare pred_acc any;\n"
"declare subj varchar;\n"
"subj := xpath_eval (\'@N3S\', n3);\n"
"pred_acc := dict_get (n3_subj_dict, subj, 0);\n"
"if (isinteger (pred_acc))\n"
"vectorbld_init (pred_acc);\n"
"vectorbld_acc (pred_acc, n3);\n"
"dict_put (n3_subj_dict, subj, pred_acc);\n"
"}\n"
"subj_list := dict_list_keys (n3_subj_dict, 0);\n"
"firsttime_subj_list := subj_list;\n"
"xte_nodebld_init (rdf_acc);\n"
"xte_nodebld_acc (rdf_acc, DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, main_res, 2, firsttime_subj_list));\n"
"\n"
"foreach (nvarchar subj in subj_list) do\n"
"{\n"
"if ((subj <> main_res) and not (subj like N\'nodeID://%\'))\n"
"{\n"
"xte_nodebld_acc (rdf_acc, DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, subj, 1, firsttime_subj_list));\n"
"}\n"
"}\n"
"\n"
"foreach (nvarchar subj in subj_list) do\n"
"{\n"
"declare subj_props any;\n"
"subj_props := dict_get (n3_subj_dict, subj, 0);\n"
"if (isinteger (subj_props[0]))\n"
"xte_nodebld_acc (rdf_acc, DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, subj, 0, firsttime_subj_list));\n"
"}\n"
"xte_nodebld_final (rdf_acc, xte_head (UNAME\'virt:rdf\'));\n"
"return rdf_acc;\n"
"}\n"
"--src dav_api.sql:7700\n"
;

static const char *proc264 = 
"#line 7752 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_PROP_SET_INT (\n"
"in path varchar,\n"
"in single_schema varchar,\n"
"in rdf any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in overwrite integer := 0,\n"
"in auth_uid integer := null) returns integer\n"
"{\n"
"declare n3xml, davtree any;\n"
"declare top_subj nvarchar;\n"
"\n"
"if (single_schema is null)\n"
"return -20;\n"
"\n"
"n3xml := xslt (\'http://local.virt/rdfxml2n3xml\', rdf);\n"
"top_subj := null;\n"
"if (xpath_eval (\'/N3[@N3S=\\044path]\', n3xml, 1, vector (UNAME\'path\', path)) is null)\n"
"top_subj := coalesce (xpath_eval (\'/N3[1]/@N3S\', n3xml), cast (path as nvarchar));\n"
"else\n"
"top_subj := cast (path as nvarchar);\n"
"\n"
"davtree := DAV_RDF_PREPROCESS_RDFXML (n3xml, top_subj, 1);\n"
"return DAV_PROP_SET_INT (path, single_schema, davtree, auth_uname, auth_pwd, extern, check_locks, overwrite, auth_uid);\n"
"}\n"
"--src dav_api.sql:7750\n"
;

static const char *proc265 = 
"#line 7782 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_PROP_GET_INT (\n"
"in id any,\n"
"in what char(1),\n"
"in single_schema varchar,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in auth_uid integer := null ) returns any\n"
"{\n"
"declare davtree any;\n"
"\n"
"davtree := DAV_PROP_GET_INT (id, what, single_schema, extern, auth_uname, auth_pwd, auth_uid);\n"
"if (isinteger (davtree))\n"
"return davtree;\n"
"\n"
"if (isentity (davtree))\n"
"return davtree;\n"
"\n"
"davtree := xml_tree_doc (deserialize (davtree));\n"
"return davtree;\n"
"}\n"
"--src dav_api.sql:7780\n"
;

static const char *proc266 = 
"#line 7806 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_MERGE (\n"
"in old_n3 any,\n"
"in patch_n3 any,\n"
"in sch_n3 any,\n"
"in wipe_old_lists integer\n"
") returns any\n"
"{\n"
"declare n3_tmp_list, new_dict, card_dict, merge_acc any;\n"
"if (old_n3 is null)\n"
"return patch_n3;\n"
"if (patch_n3 is null)\n"
"return old_n3;\n"
"card_dict := dict_new ();\n"
"if (sch_n3 is not null)\n"
"{\n"
"n3_tmp_list := xpath_eval (\'/N3[@N3P=\"http://local.virt/rdf#cardinality\"]\', sch_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"dict_put (card_dict, xpath_eval (\'@N3S\', n3), cast (n3 as varchar));\n"
"}\n"
"new_dict := dict_new ();\n"
"n3_tmp_list := xpath_eval (\'/N3\', patch_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare dkey, dacc any;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string(@xml:lang))\', n3);\n"
"dacc := dict_get (new_dict, dkey);\n"
"if (dacc is null)\n"
"vectorbld_init (dacc);\n"
"vectorbld_acc (dacc, n3);\n"
"dict_put (new_dict, dkey, dacc);\n"
"}\n"
"xte_nodebld_init (merge_acc);\n"
"n3_tmp_list := xpath_eval (\'/N3\', old_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare pred, card nvarchar;\n"
"declare dkey, new_set any;\n"
"declare stale, is_single integer;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string(@xml:lang))\', n3);\n"
"pred := xpath_eval (\'string (@N3P)\', n3);\n"
"card := dict_get (card_dict, pred);\n"
"new_set := dict_get (new_dict, dkey);\n"
"stale := 0;\n"
"if (N\'single\' = card)\n"
"is_single := 1;\n"
"else if (N\'list\' = card)\n"
"is_single := 0;\n"
"else\n"
"is_single := xpath_eval (\'not (exists (@N3O))\', n3);\n"
"if (is_single)\n"
"{\n"
"if (new_set is not null)\n"
"stale := 10;\n"
"}\n"
"else\n"
"{\n"
"if (wipe_old_lists > 0)\n"
"stale := 11;\n"
"else if (new_set is not null)\n"
"{\n"
"if (wipe_old_lists = 0)\n"
"stale := 12;\n"
"else\n"
"{\n"
"declare ctr integer;\n"
"for (ctr := new_set[0]; (ctr > 0) and not stale; ctr := ctr - 1)\n"
"{\n"
"if (xpath_eval (\'deep-equal (., \\044old)\', new_set[ctr], 1, vector (\'old\', n3)))\n"
"stale := 13;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (not stale)\n"
"xte_nodebld_acc (merge_acc, n3);\n"
"}\n"
"n3_tmp_list := xpath_eval (\'/N3\', patch_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"xte_nodebld_acc (merge_acc, n3);\n"
"}\n"
"xte_nodebld_final (merge_acc, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (merge_acc);\n"
"}\n"
"--src dav_api.sql:7804\n"
;

static const char *proc267 = 
"#line 7894 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_RDF_SUBTRACT (\n"
"in old_n3 any,\n"
"in sub_n3 any) returns any\n"
"{\n"
"declare n3_tmp_list, sub_dict, res_acc any;\n"
"sub_dict := dict_new ();\n"
"n3_tmp_list := xpath_eval (\'/N3\', sub_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare dkey, dacc any;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string (@N3O), string(@xml:lang))\', n3);\n"
"dacc := dict_get (sub_dict, dkey);\n"
"if (dacc is null)\n"
"vectorbld_init (dacc);\n"
"vectorbld_acc (dacc, xpath_eval(\'node()[1]\', n3));\n"
"dict_put (sub_dict, dkey, dacc);\n"
"}\n"
"xte_nodebld_init (res_acc);\n"
"n3_tmp_list := xpath_eval (\'/N3\', old_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare pred, card nvarchar;\n"
"declare dkey, sub_set any;\n"
"declare stale integer;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string (@N3O), string(@xml:lang))\', n3);\n"
"sub_set := dict_get (sub_dict, dkey);\n"
"stale := 0;\n"
"if (sub_set is not null)\n"
"{\n"
"declare obj_val any;\n"
"declare ctr integer;\n"
"obj_val := xpath_eval(\'node()[1]\', n3);\n"
"for (ctr := sub_set[0]; (ctr > 0) and not stale; ctr := ctr - 1)\n"
"{\n"
"if (xpath_eval (\'deep-equal (., \\044old)\', sub_set[ctr], 1, vector (\'old\', obj_val)))\n"
"stale := 13;\n"
"}\n"
"}\n"
"\n"
"if (not stale)\n"
"xte_nodebld_acc (res_acc, n3);\n"
"}\n"
"xte_nodebld_final (res_acc, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res_acc);\n"
"}\n"
"--src dav_api.sql:7892\n"
;

static const char *trig24 = 
"#line 7942 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_CONTENT_EXTRACT_RDF_I after insert on WS.WS.SYS_DAV_RES order 20 referencing new as N\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto no_op;\n"
"\n"
"if (length (N.RES_PERMS) < 11)\n"
"goto no_op;\n"
"\n"
"if (not (N.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (N.RES_ID, N.RES_NAME, N.RES_TYPE, N.RES_CONTENT);\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:7940\n";

static const char *trig25 = 
"#line 7960 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_CONTENT_EXTRACT_RDF_U1 after update (RES_ID, RES_NAME, RES_TYPE, RES_PERMS) on WS.WS.SYS_DAV_RES order 20 referencing new as N, old as O\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto no_op;\n"
"\n"
"if (length (N.RES_PERMS) < 11)\n"
"goto no_op;\n"
"\n"
"if (not (N.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"\n"
"if ((O.RES_ID <> N.RES_ID) or (O.RES_TYPE <> N.RES_TYPE))\n"
"goto ignore_old_res_perms;\n"
"\n"
"if ((O.RES_NAME <> N.RES_NAME) and (DAV_GUESS_MIME_TYPE_BY_NAME (O.RES_NAME) <> DAV_GUESS_MIME_TYPE_BY_NAME (N.RES_NAME)))\n"
"goto ignore_old_res_perms;\n"
"\n"
"if ((length (O.RES_PERMS) >= 11) and (O.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"\n"
"ignore_old_res_perms:\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (N.RES_ID, N.RES_NAME, N.RES_TYPE, N.RES_CONTENT);\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:7958\n";

static const char *trig26 = 
"#line 7988 \"[executable]/dav_api.sql\"\n"
"create trigger SYS_DAV_RES_CONTENT_EXTRACT_RDF_U2 after update (RES_ID, RES_NAME, RES_TYPE, RES_CONTENT) on WS.WS.SYS_DAV_RES order 21 referencing new as N, old as O\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto no_op;\n"
"\n"
"if (length (N.RES_PERMS) < 11)\n"
"goto no_op;\n"
"\n"
"if (not (N.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"\n"
"if ((O.RES_ID <> N.RES_ID) or (O.RES_TYPE <> N.RES_TYPE))\n"
"goto no_op;\n"
"\n"
"if ((O.RES_NAME <> N.RES_NAME) and (DAV_GUESS_MIME_TYPE_BY_NAME (O.RES_NAME) <> DAV_GUESS_MIME_TYPE_BY_NAME (N.RES_NAME)))\n"
"goto no_op;\n"
"\n"
"if (not ((length (O.RES_PERMS) >= 11) and (O.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\')))))\n"
"goto no_op;\n"
"\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (N.RES_ID, N.RES_NAME, N.RES_TYPE, N.RES_CONTENT);\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:7986\n";

static const char *proc268 = 
"#line 8015 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_EXTRACT_AND_SAVE_RDF (\n"
"in resid integer)\n"
"{\n"
"\n"
"declare resname, restype varchar;\n"
"declare rescontent any;\n"
"\n"
"select RES_NAME, RES_TYPE, RES_CONTENT\n"
"into resname, restype, rescontent\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = resid;\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (resid, resname, restype, rescontent);\n"
"}\n"
"--src dav_api.sql:8013\n"
;

static const char *proc269 = 
"#line 8030 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_GET_RES_TYPE_URI_BY_MIME_TYPE (\n"
"in mime_type varchar) returns varchar\n"
"{\n"
"if (mime_type = \'application/bpel+xml\')\n"
"return \'http://www.openlinksw.com/schemas/WSDL#\';\n"
"\n"
"if (mime_type = \'application/doap+rdf\')\n"
"return \'http://www.openlinksw.com/schemas/doap#\';\n"
"\n"
"if (mime_type = \'application/foaf+xml\')\n"
"return \'http://xmlns.com/foaf/0.1/\';\n"
"\n"
"if (mime_type = \'application/google-base+xml\')\n"
"return \'http://www.openlinksw.com/schemas/google-base#\';\n"
"\n"
"if (mime_type = \'application/license\')\n"
"return \'http://www.openlinksw.com/schemas/opllic#\';\n"
"\n"
"if (mime_type = \'application/mods+xml\')\n"
"return \'http://www.openlinksw.com/schemas/MODS#\';\n"
"\n"
"if (mime_type = \'application/msexcel\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"\n"
"if (mime_type = \'application/mspowerpoint\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"\n"
"if (mime_type = \'application/msproject\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"\n"
"if (mime_type = \'application/msword\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"\n"
"if (mime_type = \'application/msword+xml\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"\n"
"if (mime_type = \'application/opml+xml\')\n"
"return \'http://www.openlinksw.com/schemas/OPML#\';\n"
"\n"
"if (mime_type = \'application/pdf\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"\n"
"if (mime_type = \'application/rdf+xml\')\n"
"return \'http://www.openlinksw.com/schemas/RDF#\';\n"
"\n"
"if (mime_type = \'application/rss+xml\')\n"
"return \'http://purl.org/rss/1.0/\';\n"
"\n"
"if (mime_type = \'application/wsdl+xml\')\n"
"return \'http://www.openlinksw.com/schemas/WSDL#\';\n"
"\n"
"if (mime_type = \'application/x-openlink-image\')\n"
"return \'http://www.openlinksw.com/schemas/Image#\';\n"
"\n"
"if (mime_type = \'application/x-openlink-photo\')\n"
"return \'http://www.openlinksw.com/schemas/Photo#\';\n"
"\n"
"if (mime_type = \'application/x-openlinksw-vad\')\n"
"return \'http://www.openlinksw.com/schemas/VAD#\';\n"
"\n"
"if (mime_type = \'application/x-openlinksw-vsp\')\n"
"return \'http://www.openlinksw.com/schemas/VSPX#\';\n"
"\n"
"if (mime_type = \'application/x-openlinksw-vspx+xml\')\n"
"return \'http://www.openlinksw.com/schemas/VSPX#\';\n"
"\n"
"if (mime_type = \'application/xbel+xml\')\n"
"return \'http://www.python.org/topics/xml/xbel/\';\n"
"\n"
"if (mime_type = \'application/xbrl+xml\')\n"
"return \'http://www.openlinksw.com/schemas/xbrl#\';\n"
"\n"
"if (mime_type = \'application/xddl+xml\')\n"
"return \'http://www.openlinksw.com/schemas/XDDL#\';\n"
"\n"
"if (mime_type = \'application/zip\')\n"
"return \'http://www.openlinksw.com/schemas/Archive#\';\n"
"\n"
"if (mime_type = \'text/directory\')\n"
"return \'http://www.w3.org/2001/vcard-rdf/3.0#\';\n"
"\n"
"if (mime_type = \'text/eml\')\n"
"return \'http://www.openlinksw.com/schemas/Email#\';\n"
"\n"
"if (mime_type = \'text/html\')\n"
"return \'http://www.openlinksw.com/schemas/XHTML#\';\n"
"\n"
"if (mime_type = \'text/wiki\')\n"
"return \'http://www.openlinksw.com/schemas/Wiki#\';\n"
"\n"
"return null;\n"
"}\n"
"--src dav_api.sql:8028\n"
;

static const char *proc270 = 
"#line 8125 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_EXTRACT_AND_SAVE_RDF_INT (\n"
"inout resid integer,\n"
"inout resname varchar,\n"
"in restype varchar,\n"
"inout _rescontent any)\n"
"{\n"
"declare rescontent any;\n"
"\n"
"rescontent := subseq (_rescontent, 0, 10000000-1);\n"
"if ((length (_rescontent) < 262144) or (registry_get (\'DAV_EXTRACT_RDF_ASYNC\') <> \'1\'))\n"
"return DAV_EXTRACT_AND_SAVE_RDF_INT2 (resid, resname, restype, rescontent);\n"
"\n"
"declare aq any;\n"
"\n"
"aq := async_queue (1, 4);\n"
"if (not isstring (rescontent))\n"
"rescontent := cast (rescontent as varchar);\n"
"\n"
"aq_request (aq, \'DB.DBA.DAV_EXTRACT_AND_SAVE_RDF_INT2\', vector (resid, resname, restype, rescontent));\n"
"}\n"
"--src dav_api.sql:8123\n"
;

static const char *proc271 = 
"#line 8148 \"[executable]/dav_api.sql\"\n"
"create procedure DAV_EXTRACT_AND_SAVE_RDF_INT2 (\n"
"in resid integer,\n"
"in resname varchar,\n"
"in restype varchar,\n"
"in rescontent any)\n"
"{\n"
"\n"
"declare resttype, res_type_uri, full_name varchar;\n"
"declare old_prop_id integer;\n"
"declare html_start, full_xml, type_tree any;\n"
"declare old_n3, addon_n3, spotlight_addon_n3 any;\n"
"\n"
"html_start := null;\n"
"full_xml := null;\n"
"spotlight_addon_n3 := null;\n"
"addon_n3 := null;\n"
"restype := DAV_GUESS_MIME_TYPE (resname, rescontent, html_start);\n"
"if (restype is not null)\n"
"{\n"
"declare p_name varchar;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"goto addon_n3_set;\n"
"};\n"
"\n"
"select RES_FULL_PATH into full_name from WS.WS.SYS_DAV_RES where RES_ID = resid;\n"
"if (full_name is null)\n"
"full_name := resname;\n"
"\n"
"p_name := \'DB.DBA.DAV_EXTRACT_RDF_\' || restype;\n"
"if (__proc_exists (p_name) is not null)\n"
"{\n"
"addon_n3 := call (p_name) (full_name, rescontent, html_start);\n"
"res_type_uri := DAV_GET_RES_TYPE_URI_BY_MIME_TYPE (restype);\n"
"if (res_type_uri is not null)\n"
"{\n"
"type_tree := xtree_doc (\'<N3 N3S=\"http://local.virt/this\" N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\" N3O=\"\' || res_type_uri || \'\"/>\' );\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, type_tree, null, 0);\n"
"}\n"
"}\n"
"\n"
"addon_n3_set:;\n"
"}\n"
"\n"
"\n"
"if (__proc_exists (\'SPOTLIGHT_METADATA\', 2) is not null)\n"
"spotlight_addon_n3 := DAV_EXTRACT_SPOTLIGHT (resname, rescontent);\n"
"\n"
"\n"
"if (addon_n3 is null and spotlight_addon_n3 is null)\n"
"goto no_op;\n"
"\n"
"if (spotlight_addon_n3 is not null)\n"
"{\n"
"if (addon_n3 is not null)\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, spotlight_addon_n3, null, 0);\n"
"else\n"
"addon_n3 := spotlight_addon_n3;\n"
"}\n"
"\n"
"whenever not found goto no_old;\n"
"select xml_tree_doc (deserialize (blob_to_string (PROP_VALUE))), PROP_ID\n"
"into old_n3, old_prop_id\n"
"from WS.WS.SYS_DAV_PROP\n"
"where PROP_NAME = \'http://local.virt/DAV-RDF\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = resid;\n"
"\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_n3);\n"
"old_n3 := DAV_RDF_MERGE (old_n3, addon_n3, null, 0);\n"
"\n"
"\n"
"update WS.WS.SYS_DAV_PROP\n"
"set PROP_VALUE = serialize (DAV_RDF_PREPROCESS_RDFXML (old_n3, N\'http://local.virt/this\', 1))\n"
"where PROP_ID = old_prop_id;\n"
"goto no_op;\n"
"\n"
"no_old:\n"
"\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_TYPE, PROP_PARENT_ID, PROP_VALUE)\n"
"values (WS.WS.GETID (\'P\'), \'http://local.virt/DAV-RDF\', \'R\', resid, serialize (DAV_RDF_PREPROCESS_RDFXML (addon_n3, N\'http://local.virt/this\', 1)) );\n"
"\n"
"no_op:;\n"
"\n"
"}\n"
"--src dav_api.sql:8146\n"
;

static const char *proc272 = 
"#line 8236 \"[executable]/dav_api.sql\"\n"
"create function DAV_HOME_DIR_UPDATE ()\n"
"{\n"
"if (isstring (registry_get (\'DAV_HOME_DIR_UPDATE\')))\n"
"return;\n"
"\n"
"for (select U_NAME from SYS_USERS where U_DAV_ENABLE = 1 and U_IS_ROLE = 0 and U_NAME <> \'nobody\' and U_NAME <> \'__rdf_repl\') do\n"
"DAV_HOME_DIR_CREATE (U_NAME);\n"
"\n"
"registry_set (\'DAV_HOME_DIR_UPDATE\', \'done\');\n"
"}\n"
"--src dav_api.sql:8234\n"
;


static const char *other1 = 
" DAV_HOME_DIR_UPDATE ()\n";
static const char *proc273 = 
"#line 8252 \"[executable]/dav_api.sql\"\n"
"create function DAV_NOBODY_DIR_UPDATE ()\n"
"{\n"
"declare changed integer;\n"
"\n"
"if (isstring (registry_get (\'DAV_NOBODY_DIR_UPDATE\')))\n"
"return;\n"
"\n"
"for (select COL_ID as cid, COL_OWNER as uid, COL_GROUP as gid from WS.WS.SYS_DAV_COL where WS.WS.COL_PATH (COL_ID) like \'/DAV/home/nobody/%\') do\n"
"{\n"
"changed := 0;\n"
"if (uid = http_nobody_uid())\n"
"{\n"
"changed := 1;\n"
"uid := http_dav_uid();\n"
"}\n"
"if (gid = http_nogroup_gid())\n"
"{\n"
"changed := 1;\n"
"gid := http_admin_gid();\n"
"}\n"
"if (changed)\n"
"{\n"
"update WS.WS.SYS_DAV_COL\n"
"set COL_OWNER = uid,\n"
"COL_GROUP = gid\n"
"where COL_ID = cid;\n"
"}\n"
"}\n"
"\n"
"for (select RES_ID as rid, RES_OWNER as uid, RES_GROUP as gid from WS.WS.SYS_DAV_RES where RES_FULL_PATH like \'/DAV/home/nobody/%\') do\n"
"{\n"
"changed := 0;\n"
"if (uid = http_nobody_uid())\n"
"{\n"
"changed := 1;\n"
"uid := http_dav_uid();\n"
"}\n"
"if (gid = http_nogroup_gid())\n"
"{\n"
"changed := 1;\n"
"gid := http_admin_gid();\n"
"}\n"
"if (changed)\n"
"{\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_OWNER = uid,\n"
"RES_GROUP = gid\n"
"where RES_ID = rid;\n"
"}\n"
"}\n"
"\n"
"registry_set (\'DAV_NOBODY_DIR_UPDATE\', \'done\');\n"
"}\n"
"--src dav_api.sql:8250\n"
;


static const char *other2 = 
" DAV_NOBODY_DIR_UPDATE ()\n";
static const char *tbl0 = 
"create table WS.WS.SYS_DAV_QUEUE (\n"
"DQ_ID integer identity,\n"
"DQ_CLASS varchar not null,\n"
"DQ_CLASS_ID any not null,\n"
"DQ_PROCEDURE varchar not null,\n"
"DQ_PARAMS any not null,\n"
"DQ_PRIORITY integer default 0,\n"
"DQ_STATE integer default 0,\n"
"DQ_TS datetime not null,\n"
"\n"
"PRIMARY KEY (DQ_ID)\n"
")\n"
"create index SYS_DAV_QUEUE_STATE ON WS.WS.SYS_DAV_QUEUE (DQ_STATE)\n";

static const char *tbl1 = 
"create table WS.WS.SYS_DAV_QUEUE_LCK (DQL_ID int primary key)\n";

static const char *other3 = 
"insert soft WS.WS.SYS_DAV_QUEUE_LCK values (0)\n";
static const char *proc274 = 
"#line 8337 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_ADD (\n"
"in _class varchar,\n"
"in _class_id any,\n"
"in _procedure varchar,\n"
"in _params any,\n"
"in _priority integer := 0,\n"
"in _insertMode integer := 0)\n"
"{\n"
"\n"
"declare _id, _count integer;\n"
"\n"
"_count := 0;\n"
"_id := (select TOP 1 DQ_ID from WS.WS.SYS_DAV_QUEUE where DQ_CLASS = _class and DQ_CLASS_ID = _class_id for update);\n"
"if (isnull (_id) or _insertMode)\n"
"{\n"
"insert into WS.WS.SYS_DAV_QUEUE (DQ_CLASS, DQ_CLASS_ID, DQ_PROCEDURE, DQ_PARAMS, DQ_PRIORITY, DQ_TS)\n"
"values (_class, _class_id, _procedure, _params, _priority, now ());\n"
"\n"
"_count := 1;\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_QUEUE\n"
"set DQ_PRIORITY = _priority,\n"
"DQ_TS = now ()\n"
"where DQ_ID = _id\n"
"and DQ_PRIORITY < _priority;\n"
"}\n"
"commit work;\n"
"\n"
"return _count;\n"
"}\n"
"--src dav_api.sql:8335\n"
;

static const char *proc275 = 
"#line 8371 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_UPDATE_STATE (\n"
"in _queue_id integer,\n"
"in _state integer := 1,\n"
"in _commit integer := 1)\n"
"{\n"
"update WS.WS.SYS_DAV_QUEUE\n"
"set DQ_STATE = _state,\n"
"DQ_TS = now ()\n"
"where DQ_ID = _queue_id\n"
"and ((DQ_STATE <> _state) or (DQ_TS < dateadd (\'minute\', -1, now())));\n"
"\n"
"if (_commit)\n"
"commit work;\n"
"}\n"
"--src dav_api.sql:8369\n"
;

static const char *proc276 = 
"#line 8387 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_UPDATE_TS (\n"
"in _queue_id integer,\n"
"in _commit integer := 1)\n"
"{\n"
"DB.DBA.DAV_QUEUE_UPDATE_STATE (_queue_id, 1, _commit);\n"
"}\n"
"--src dav_api.sql:8385\n"
;

static const char *proc277 = 
"#line 8395 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_UPDATE_FINAL (\n"
"in _queue_id integer)\n"
"{\n"
"delete from WS.WS.SYS_DAV_QUEUE where DQ_ID = _queue_id;\n"
"commit work;\n"
"}\n"
"--src dav_api.sql:8393\n"
;

static const char *proc278 = 
"#line 8403 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_CLEAR ()\n"
"{\n"
"delete from WS.WS.SYS_DAV_QUEUE where DQ_STATE = 2;\n"
"commit work;\n"
"}\n"
"--src dav_api.sql:8401\n"
;

static const char *proc279 = 
"#line 8410 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_GET (\n"
"in _count integer)\n"
"{\n"
"declare dummy, items any;\n"
"\n"
"if (_count <= 0)\n"
"return vector ();\n"
"\n"
"vectorbld_init (items);\n"
"\n"
"set isolation = \'serializable\';\n"
"\n"
"select DQL_ID into dummy from WS.WS.SYS_DAV_QUEUE_LCK where DQL_ID = 0;\n"
"for (select TOP (_count) DQ_ID, DQ_PROCEDURE, DQ_PARAMS\n"
"from WS.WS.SYS_DAV_QUEUE\n"
"where DQ_STATE = 0\n"
"order by DQ_PRIORITY desc, DQ_TS) do\n"
"{\n"
"DB.DBA.DAV_QUEUE_UPDATE_STATE (DQ_ID, 1, 0);\n"
"vectorbld_acc (items, vector (DQ_ID, DQ_PROCEDURE, DQ_PARAMS));\n"
"}\n"
"commit work;\n"
"set isolation = \'committed\';\n"
"\n"
"vectorbld_final (items);\n"
"return items;\n"
"}\n"
"--src dav_api.sql:8408\n"
;

static const char *proc280 = 
"#line 8439 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_ACTIVE ()\n"
"{\n"
"declare retValue integer;\n"
"declare dt datetime;\n"
"declare dummy any;\n"
"\n"
"retValue := 0;\n"
"if (is_atomic ())\n"
"{\n"
"retValue := 1;\n"
"}\n"
"else\n"
"{\n"
"set isolation = \'serializable\';\n"
"\n"
"dt := dateadd (\'minute\', -5, now());\n"
"select DQL_ID into dummy from WS.WS.SYS_DAV_QUEUE_LCK where DQL_ID = 0;\n"
"update WS.WS.SYS_DAV_QUEUE\n"
"set DQ_STATE = 0,\n"
"DQ_TS    = now ()\n"
"where DQ_STATE = 1\n"
"and DQ_TS    < dt;\n"
"\n"
"retValue := coalesce ((select top 1 1 from WS.WS.SYS_DAV_QUEUE where DQ_STATE = 1), 0);\n"
"commit work;\n"
"\n"
"set isolation = \'committed\';\n"
"}\n"
"return retValue;\n"
"}\n"
"--src dav_api.sql:8437\n"
;

static const char *proc281 = 
"#line 8471 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_INIT (\n"
"in _delay integer := 0)\n"
"{\n"
"\n"
"declare aq any;\n"
"\n"
"if (not DB.DBA.DAV_QUEUE_ACTIVE ())\n"
"{\n"
"set_user_id (\'dba\');\n"
"aq := async_queue (1, 4);\n"
"aq_request (aq, \'DB.DBA.DAV_QUEUE_RUN\', vector (0, _delay));\n"
"}\n"
"}\n"
"--src dav_api.sql:8469\n"
;

static const char *proc282 = 
"#line 8486 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_QUEUE_RUN (\n"
"in _notInit integer := 1,\n"
"in _delay integer := 0)\n"
"{\n"
"\n"
"declare N, L, waited, threads integer;\n"
"declare retValue, error any;\n"
"declare aq, item, items, threadsArray any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"log_message (sprintf (\'%s exit handler:\\n %s\', current_proc_name (), __SQL_MESSAGE));\n"
"resignal;\n"
"};\n"
"\n"
"if (_delay)\n"
"delay (_delay);\n"
"\n"
"set isolation = \'committed\';\n"
"if (_notInit and DB.DBA.DAV_QUEUE_ACTIVE ())\n"
"return;\n"
"\n"
"aq := null;\n"
"threads := atoi (coalesce (virtuoso_ini_item_value (\'Parameters\', \'AsyncQueueMaxThreads\'), \'10\')) / 2;\n"
"if (threads <= 0)\n"
"threads := 1;\n"
"\n"
"_new_batch:;\n"
"items := DB.DBA.DAV_QUEUE_GET (threads);\n"
"L := length (items);\n"
"if (not L)\n"
"goto _exit;\n"
"\n"
"\n"
"if (isnull (aq))\n"
"{\n"
"if (L + 1 < threads)\n"
"{\n"
"threads := length (items) + 1;\n"
"}\n"
"aq := async_queue (threads, 4);\n"
"}\n"
"\n"
"threadsArray := make_array (threads, \'any\');\n"
"for (N := 0; N < threads; N := N + 1)\n"
"{\n"
"if (N < L)\n"
"{\n"
"threadsArray[N] := aq_request (aq, items[N][1], vector_concat (vector (items[N][0]), items[N][2]));\n"
"}\n"
"else\n"
"{\n"
"threadsArray[N] := -1;\n"
"}\n"
"}\n"
"\n"
"_again:;\n"
"commit work;\n"
"\n"
"waited := 0;\n"
"for (N := 0; N < threads; N := N + 1)\n"
"{\n"
"if (threadsArray[N] >= 0)\n"
"{\n"
"error := 0;\n"
"retValue := aq_wait (aq, threadsArray[N], 0, error);\n"
"if (retValue = 100 or error = 100)\n"
"threadsArray[N] := -1;\n"
"}\n"
"if (threadsArray[N] < 0)\n"
"{\n"
"item := DB.DBA.DAV_QUEUE_GET (1);\n"
"if (length (item) = 1)\n"
"threadsArray[N] := aq_request (aq, item[0][1], vector_concat (vector (item[0][0]), item[0][2]));\n"
"}\n"
"if (threadsArray[N] >= 0)\n"
"{\n"
"waited := 1;\n"
"}\n"
"}\n"
"if (waited)\n"
"{\n"
"delay (1);\n"
"goto _again;\n"
"}\n"
"\n"
"goto _new_batch;\n"
"\n"
"_exit:;\n"
"DB.DBA.DAV_QUEUE_CLEAR ();\n"
"}\n"
"--src dav_api.sql:8484\n"
;

static const char *proc283 = 
"#line 8583 \"[executable]/dav_api.sql\"\n"
"create function DB.DBA.DAV_EXPIRE_SCHEDULER (\n"
"in queue_id integer)\n"
"{\n"
"\n"
"declare _now, _today datetime;\n"
"\n"
"_now := curdatetime ();\n"
"_today := cast (stringdate (sprintf (\'%d.%d.%d\', year (_now), month (_now), dayofmonth (_now))) as date);\n"
"for (select PROP_TYPE, PROP_PARENT_ID from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:expireDate\' and cast (PROP_VALUE as date) <= _today) do\n"
"{\n"
"DB.DBA.DAV_DELETE_INT (DB.DBA.DAV_SEARCH_PATH (PROP_PARENT_ID, PROP_TYPE), 1, null, null, 0);\n"
"DB.DBA.DAV_QUEUE_UPDATE_TS (queue_id);\n"
"}\n"
"\n"
"DB.DBA.DAV_QUEUE_UPDATE_FINAL (queue_id);\n"
"}\n"
"--src dav_api.sql:8581\n"
;

static const char *proc284 = 
"#line 8601 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_SCHEDULER ()\n"
"{\n"
"\n"
"declare DETs any;\n"
"\n"
"set_user_id (\'dba\');\n"
"\n"
"\n"
"DB.DBA.DAV_QUEUE_ADD (\'EXPIRED\', 0, \'DB.DBA.DAV_EXPIRE_SCHEDULER\', vector ());\n"
"\n"
"DETs := DB.DBA.DAV_DET_SPECIAL ();\n"
"foreach (any det in DETs) do\n"
"{\n"
"if (__proc_exists (\'DB.DBA.\' || det || \'_DAV_SCHEDULER\'))\n"
"DB.DBA.DAV_QUEUE_ADD (det, 0, \'DB.DBA.\' || det || \'_DAV_SCHEDULER\', vector (null));\n"
"}\n"
"DB.DBA.DAV_QUEUE_RUN ();\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:8599\n"
;

static const char *other4 = 
"insert replacing DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values(\'WebDAV Scheduler\', now(), \'DB.DBA.DAV_SCHEDULER ()\', 5)\n";
static const char *proc285 = 
"#line 8631 \"[executable]/dav_api.sql\"\n"
"create procedure DB.DBA.DAV_RDF_SINK_UPDATE (\n"
"in queue_id integer := null)\n"
"{\n"
"\n"
"declare path, old_graph, new_graph varchar;\n"
"declare old_mode int;\n"
"\n"
"if (registry_get (\'__dav_rdf_sink_update\') = \'1\')\n"
"return;\n"
"\n"
"if (isnull (queue_id))\n"
"{\n"
"DB.DBA.DAV_QUEUE_ADD (\'RDF_SINK\', 0, \'DB.DBA.DAV_RDF_SINK_UPDATE\', vector ());\n"
"DB.DBA.DAV_QUEUE_INIT ();\n"
"return;\n"
"}\n"
"\n"
"old_mode := log_enable (3, 1);\n"
"for (select PROP_PARENT_ID from WS.WS.SYS_DAV_PROP where PROP_TYPE = \'C\' and PROP_NAME = \'virt:rdfSink-rdf\') do\n"
"{\n"
"path := DB.DBA.DAV_SEARCH_PATH (PROP_PARENT_ID, \'C\');\n"
"for (select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_FULL_PATH like (path || \'%\')) do\n"
"{\n"
"old_graph := \'http://local.virt\' || RES_FULL_PATH;\n"
"new_graph := WS.WS.DAV_IRI (RES_FULL_PATH);\n"
"SPARQL insert in graph ?:new_graph { ?s ?p ?o } where { graph `iri(?:old_graph)` { ?s ?p ?o } };\n"
"SPARQL clear graph ?:old_graph;\n"
"}\n"
"}\n"
"\n"
"log_enable (old_mode, 1);\n"
"registry_set (\'__dav_rdf_sink_update\', \'1\');\n"
"DB.DBA.DAV_QUEUE_UPDATE_FINAL (queue_id);\n"
"}\n"
"--src dav_api.sql:8629\n"
;


static const char *other5 = 
" DB.DBA.DAV_RDF_SINK_UPDATE ()\n";
/* dav_meta.sql */

static const char *proc286 = 
"#line 21 \"[executable]/dav_meta.sql\"\n"
"create function DAV_GUESS_MIME_TYPE_BY_NAME (in orig_res_name varchar) returns varchar\n"
"{\n"
"\n"
"declare dot_pos integer;\n"
"declare orig_res_ext, orig_res_ext_upper varchar;\n"
"\n"
"dot_pos := strrchr (orig_res_name, \'.\');\n"
"if (dot_pos is null or (0 = dot_pos))\n"
"return null;\n"
"\n"
"orig_res_ext := subseq (orig_res_name, dot_pos+1);\n"
"orig_res_ext_upper := upper (orig_res_ext);\n"
"if (position (orig_res_ext_upper, vector (\'HTM\', \'HTML\', \'XHTML\')))\n"
"return \'text/html\';\n"
"if (position (orig_res_ext_upper, vector (\'XSL\', \'XSLT\', \'XSD\')))\n"
"return \'application/xml\';\n"
"if (orig_res_ext_upper = \'VAD\')\n"
"return \'application/x-openlinksw-vad\';\n"
"if (orig_res_ext_upper = \'VSP\')\n"
"return \'application/x-openlinksw-vsp\';\n"
"if (orig_res_ext_upper = \'TTL\')\n"
"return \'text/turtle\';\n"
"if (orig_res_ext_upper = \'N3\')\n"
"return \'text/rdf+n3\';\n"
"if (position (orig_res_ext_upper, vector (\'XML\', \'RDF\', \'RDFS\', \'RSS\', \'RSS2\', \'XBEL\', \'FOAF\', \'OPML\', \'WSDL\', \'BPEL\', \'VSPX\', \'VSCX\', \'XDDL\', \'OCS\')))\n"
"return \'text/xml\';\n"
"if (orig_res_ext_upper = \'EML\')\n"
"return \'text/eml\';\n"
"if (orig_res_ext_upper = \'ODT\')\n"
"return \'application/vnd.oasis.opendocument.text\';\n"
"if (orig_res_ext_upper = \'ODB\')\n"
"return \'application/vnd.oasis.opendocument.database\';\n"
"if (orig_res_ext_upper = \'ODG\')\n"
"return \'application/vnd.oasis.opendocument.graphics\';\n"
"if (orig_res_ext_upper = \'ODP\')\n"
"return \'application/vnd.oasis.opendocument.presentation\';\n"
"if (orig_res_ext_upper = \'ODS\')\n"
"return \'application/vnd.oasis.opendocument.spreadsheet\';\n"
"if (orig_res_ext_upper = \'ODC\')\n"
"return \'application/vnd.oasis.opendocument.chart\';\n"
"if (orig_res_ext_upper = \'ODF\')\n"
"return \'application/vnd.oasis.opendocument.formula\';\n"
"if (orig_res_ext_upper = \'ODI\')\n"
"return \'application/vnd.oasis.opendocument.image\';\n"
"if (position (orig_res_ext_upper, vector (\'VCARD\', \'VCF\', \'ICAL\', \'ICS\')))\n"
"return \'text/directory\';\n"
"if (orig_res_ext_upper = \'DTD\')\n"
"return \'application/xml-dtd\';\n"
"if (orig_res_ext_upper = \'LIC\')\n"
"return \'application/x-openlink-license\';\n"
"if (orig_res_ext_upper = \'XBRL\')\n"
"return \'application/xbrl+xml\';\n"
"if (orig_res_ext_upper = \'TXT\' and coalesce (connection_get (\'oWiki Topic\'), \'\') = orig_res_name)\n"
"return \'text/wiki\';\n"
"if (position (orig_res_ext_upper, vector (\'BMP\', \'DIB\', \'RLE\', \'CR2\', \'CRW\', \'EMF\', \'EPS\', \'IFF\', \'LBM\', \'JP2\', \'JPX\', \'JPK\', \'J2K\', \'JPC\', \'J2C\', \'JPE\', \'JIF\', \'JFIF\', \'JPG\', \'JPEG\', \'GIF\', \'PNG\')))\n"
"return \'application/x-openlink-image\';\n"
"if (orig_res_ext_upper = \'TAR\')\n"
"return \'application/tar\';\n"
"if (orig_res_ext_upper = \'TAZ\')\n"
"return \'application/taz\';\n"
"if (orig_res_ext_upper = \'GZ\')\n"
"return \'application/gz\';\n"
"if (orig_res_ext_upper = \'MSI\')\n"
"return \'application/msi\';\n"
"if (orig_res_ext_upper = \'DMG\')\n"
"return \'application/dmg\';\n"
"if (orig_res_ext_upper = \'ARJ\')\n"
"return \'application/arj\';\n"
"if (orig_res_ext_upper = \'BZ\')\n"
"return \'application/bz\';\n"
"if (orig_res_ext_upper = \'BZ2\')\n"
"return \'application/bz2\';\n"
"if (orig_res_ext_upper = \'TGZ\')\n"
"return \'application/tgz\';\n"
"if (orig_res_ext_upper = \'RAR\')\n"
"return \'application/rar\';\n"
"if (orig_res_ext_upper = \'ZIP\')\n"
"return \'application/zip\';\n"
"if (orig_res_ext_upper = \'CAB\')\n"
"return \'application/cab\';\n"
"if (orig_res_ext_upper = \'LZH\')\n"
"return \'application/lzh\';\n"
"if (orig_res_ext_upper = \'ACE\')\n"
"return \'application/ace\';\n"
"if (orig_res_ext_upper = \'ISO\')\n"
"return \'application/iso\';\n"
"\n"
"return (select T_TYPE from WS.WS.SYS_DAV_RES_TYPES where T_EXT = lower (orig_res_ext));\n"
"}\n"
"--src dav_meta.sql:19\n"
;

static const char *proc287 = 
"#line 112 \"[executable]/dav_meta.sql\"\n"
"create function DAV_GUESS_MIME_TYPE (in orig_res_name varchar, inout content any, inout html_start any) returns varchar\n"
"{\n"
"declare content_len integer;\n"
"declare dflt_ret varchar;\n"
"\n"
"whenever sqlstate \'*\' goto no_op;\n"
"content_len := length (content);\n"
"if (__tag (content) in (125, 126, 132, 133))\n"
"{\n"
"declare beginning varchar;\n"
"if (content_len < 10000000)\n"
"beginning := blob_to_string (content);\n"
"else\n"
"beginning := null;\n"
"return DAV_GUESS_MIME_TYPE (orig_res_name, beginning, html_start);\n"
"}\n"
"dflt_ret := DAV_GUESS_MIME_TYPE_BY_NAME (orig_res_name);\n"
"if (\'text/xml\' = dflt_ret)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"return dflt_ret;\n"
"};\n"
"if (content is null)\n"
"return \'text/xml\';\n"
"if (html_start = 0)\n"
"html_start := null;\n"
"if (html_start is null)\n"
"{\n"
"if (230 = __tag (content))\n"
"html_start := content;\n"
"else\n"
"{\n"
"declare frag_len, min_frag_len, max_frag_len integer;\n"
"max_frag_len := length (content);\n"
"if (max_frag_len > 30000)\n"
"{\n"
"max_frag_len := 30000;\n"
"min_frag_len := 20000;\n"
"}\n"
"else\n"
"min_frag_len := max_frag_len;\n"
"for (frag_len := max_frag_len; (frag_len >= min_frag_len) and (html_start is null); frag_len := frag_len - 1000)\n"
"{\n"
"html_start := xtree_doc (subseq (content, 0, frag_len), 18, \'http://localdav.virt/\' || orig_res_name, \'LATIN-1\', \'x-any\',\n"
"\'Validation=DISABLE Include=DISABLE BuildStandalone=DISABLE SchemaDecl=DISABLE\' );\n"
"}\n"
"}\n"
"}\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:bm=\"http://www.w3.org/2002/01/bookmark#\"] exists (/rdf:rdf/bm:bookmark)\', html_start))\n"
"return \'application/annotea+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://usefulinc.com/ns/doap#\"] exists (/project)\', html_start) or\n"
"xpath_eval (\'[xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns=\"http://usefulinc.com/ns/doap#\"] exists (/rdf:rdf/project)\', html_start))\n"
"return \'application/doap+rdf\';\n"
"if (xpath_eval (\'[xmlns:atom=\"http://purl.org/atom/ns#\"] exists (/atom:feed[@version])\', html_start) or\n"
"xpath_eval (\'[xmlns:atom=\"http://www.w3.org/2005/Atom\"]exists (/atom:feed)\', html_start))\n"
"return \'application/atom+xml\';\n"
"if (xpath_eval (\'[xmlns:w=\"http://schemas.microsoft.com/office/word/2003/wordml\"] exists (/w:worddocument)\', html_start))\n"
"return \'application/msword+xml\';\n"
"if (xpath_eval (\'[xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"] exists (/Workbook)\', html_start))\n"
"return \'application/msexcel+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://schemas.microsoft.com/project\"] exists (/Project)\', html_start))\n"
"return \'application/msproject+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://schemas.microsoft.com/visio/2003/core\"] exists (/VisioDocument)\', html_start))\n"
"return \'application/msvisio+xml\';\n"
"if (xpath_eval (\'[xmlns:n0=\"rdf\" xmlns:n2=\"foaf\"] exists (//n2:person)\', html_start) or xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:foaf=\"http://xmlns.com/foaf/0.1/\"]exists (/rdf:rdf/foaf:*)\', html_start))\n"
"return \'application/foaf+xml\';\n"
"if (xpath_eval (\'exists (/xbel)\', html_start))\n"
"return \'application/xbel+xml\';\n"
"if (xpath_eval (\'exists (/database)\', html_start))\n"
"return \'application/xddl+xml\';\n"
"\n"
"if (xpath_eval (\'exists (/modscollection|/mods)\', html_start))\n"
"return \'application/mods+xml\';\n"
"if (xpath_eval (\'exists (/opml[@version])\', html_start))\n"
"return \'application/opml+xml\';\n"
"if (xpath_eval (\'[xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:ocs = \"http://InternetAlchemy.org/ocs/directory#\" xmlns:dc = \"http://purl.org/metadata/dublin_core#\"] exists (/rdf:rdf/rdf:description/dc:title)\', html_start))\n"
"return \'application/ocs+xml\';\n"
"if (xpath_eval (\'[xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc  = \"http://purl.org/metadata/dublin_core#\" xmlns = \"http://purl.org/ocs/directory/0.5/#\"] exists (/rdf:rdf/directory)\', html_start))\n"
"return \'application/ocs+xml\';\n"
"\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rss=\"http://purl.org/rss/1.0/\"]exists (/rdf:rdf/rss:channel)\', html_start))\n"
"return \'application/rss+xml\';\n"
"if (xpath_eval (\'exists (/rss[@version])\', html_start))\n"
"return \'application/rss+xml\';\n"
"if (xpath_eval (\'[xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"]exists (/wsdl:definitions)\', html_start))\n"
"return \'application/wsdl+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://www.w3.org/2005/Atom\" xmlns:gm=\"http://base.google.com/ns-metadata/1.0\"] exists (/entry)\', html_start))\n"
"return \'application/google-base+xml\';\n"
"if (xpath_eval (\'[xmlns:bpel=\"http://schemas.xmlsoap.org/ws/2003/03/business-process/\"]exists (/bpel:process)\', html_start))\n"
"return \'application/bpel+xml\';\n"
"if (xpath_eval (\'[xmlns:v=\"http://www.openlinksw.com/vspx/\"]exists (/v:*|//v:page)\', html_start))\n"
"return \'application/x-openlinksw-vspx+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://www.xbrl.org/2003/instance\"] exists (/xbrl)\', html_start))\n"
"return \'application/xbrl+xml\';\n"
"\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"] exists(/rdf:rdf)\', html_start))\n"
"return \'application/rdf+xml\';\n"
"\n"
"return dflt_ret;\n"
"}\n"
"else if (dflt_ret = \'application/x-openlink-license\')\n"
"{\n"
"declare mydata, exp_date varchar;\n"
"\n"
"mydata := \"asn1_to_xml\" (content, length(blob_to_string (content)));\n"
"exp_date := cast(xpath_eval(\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"ExpireDate\"]/PRINTABLESTRING[position() > 1]/text()\', xtree_doc(mydata)) as varchar);\n"
"if (exp_date is not null and exp_date <> \'\')\n"
"return \'application/x-openlink-license\';\n"
"}\n"
"else if (dflt_ret = \'application/x-openlink-image\')\n"
"{\n"
"declare image_format varchar;\n"
"\n"
"image_format := \"IM GetImageBlobFormat\" (content, length(blob_to_string (content)));\n"
"if (image_format is not null)\n"
"{\n"
"image_format := \"IM GetImageBlobAttribute\" (content, length(blob_to_string (content)), \'EXIF:Model\');\n"
"if (image_format is not null and image_format <> \'\' and image_format <> \'unknown\' and image_format <> \'.\')\n"
"return \'application/x-openlink-photo\';\n"
"\n"
"return \'application/x-openlink-image\';\n"
"}\n"
"}\n"
"no_op:\n"
"return dflt_ret;\n"
"}\n"
"--src dav_meta.sql:110\n"
;

static const char *proc288 = 
"#line 242 \"[executable]/dav_meta.sql\"\n"
"create procedure file_space_fmt (in d integer) returns varchar\n"
"{\n"
"if (d is null or d = 0)\n"
"return \'N/A\';\n"
"\n"
"if (d < 1024)\n"
"return sprintf(\'%d B\', d);\n"
"\n"
"if (d < 1048576)\n"
"return sprintf(\'%d KB\', d / 1024);\n"
"\n"
"return sprintf(\'%d MB\', d / 1024 / 1024);\n"
"}\n"
"--src dav_meta.sql:240\n"
;

static const char *proc289 = 
"#line 257 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlink-license\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"\n"
"declare res, content, mydata any;\n"
"declare tmp varchar;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"\n"
"content := blob_to_string (content1);\n"
"mydata := xtree_doc (\"asn1_to_xml\" (content, length (content)));\n"
"\n"
"xte_nodebld_init (res);\n"
"\n"
"tmp := cast (xpath_eval (\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"RegisteredTo\"]/PRINTABLESTRING[position() > 1]/text()\', mydata) as varchar);\n"
"xte_nodebld_acc (res, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#RegisteredTo\'), tmp));\n"
"\n"
"tmp := cast (xpath_eval (\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"NumberOfConnections\"]/PRINTABLESTRING[position() > 1]/text()\', mydata) as varchar);\n"
"xte_nodebld_acc (res, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#NumberOfConnections\'), tmp));\n"
"\n"
"tmp := cast (xpath_eval (\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"NumberOfUsers\"]/PRINTABLESTRING[position() > 1]/text()\', mydata) as varchar);\n"
"xte_nodebld_acc (res, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#NumberOfUsers\'), tmp));\n"
"\n"
"tmp := cast (xpath_eval (\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"SerialNumber\"]/PRINTABLESTRING[position() > 1]/text()\', mydata) as varchar);\n"
"xte_nodebld_acc(res, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#SerialNumber\'), tmp));\n"
"\n"
"tmp := cast (xpath_eval (\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"ExpireDate\"]/PRINTABLESTRING[position() > 1]/text()\', mydata) as varchar);\n"
"xte_nodebld_acc (res, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#ExpireDate\'), tmp));\n"
"\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:255\n"
;

static const char *proc290 = 
"#line 292 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_opendocument\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras, res any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"\n"
"declare meta, tmp varchar;\n"
"declare xt, xd any;\n"
"if (__proc_exists (\'UNZIP_UnzipFileFromArchive\', 2) is null)\n"
"goto errexit;\n"
"tmp := tmp_file_name (\'rdfm\', \'odt\');\n"
"string_to_file (tmp, content1, -2);\n"
"meta := UNZIP_UnzipFileFromArchive (tmp, \'meta.xml\');\n"
"file_delete (tmp, 1);\n"
"meta := replace(meta, \'\\n\', \'\');\n"
"xt := xtree_doc (meta, 0);\n"
"metas := vector (\n"
"\'http://purl.org/dc/elements/1.1/date\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:date\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/language\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:language\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/creator\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:creator\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/description\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:description\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/subject\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:subject\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/title\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:title\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:creation-date\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:creation-date\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:editing-cycles\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:editing-cycles\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:editing-duration\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:editing-duration\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:generator\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:generator\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:initial-creator\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:initial-creator\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:keyword\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:keyword\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:print-date\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:print-date\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:printed-by\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:printed-by\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (xt, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:290\n"
;

static const char *proc291 = 
"#line 330 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.text\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:328\n"
;

static const char *proc292 = 
"#line 336 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.database\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:334\n"
;

static const char *proc293 = 
"#line 342 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.graphics\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:340\n"
;

static const char *proc294 = 
"#line 348 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.presentation\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:346\n"
;

static const char *proc295 = 
"#line 353 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.spreadsheet\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:351\n"
;

static const char *proc296 = 
"#line 358 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.chart\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:356\n"
;

static const char *proc297 = 
"#line 363 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.formula\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:361\n"
;

static const char *proc298 = 
"#line 368 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.image\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:366\n"
;

static const char *proc299 = 
"#line 374 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlink-image\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/x-openlink-picture\" (\'http://www.openlinksw.com/schemas/Image#\', orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:372\n"
;

static const char *proc300 = 
"#line 380 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlink-photo\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/x-openlink-picture\" (\'http://www.openlinksw.com/schemas/Photo#\', orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:378\n"
;

static const char *proc301 = 
"#line 386 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlink-picture\" (in rdf_schema varchar, in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"\n"
"declare res, content any;\n"
"declare image_size, xsize, ysize, depth integer;\n"
"declare image_format, comments, xres, yres varchar;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"\n"
"content := blob_to_string (content1);\n"
"\n"
"image_size := length (content);\n"
"image_format := \"IM GetImageBlobFormat\"(content, image_size);\n"
"xsize := \"IM GetImageBlobWidth\"(content, image_size);\n"
"ysize := \"IM GetImageBlobHeight\"(content, image_size);\n"
"xres := \"IM GetImageBlobAttribute\"(content, image_size, \'EXIF:XResolution\');\n"
"yres := \"IM GetImageBlobAttribute\"(content, image_size, \'EXIF:YResolution\');\n"
"depth := \"IM GetImageBlobDepth\"(content, image_size);\n"
"comments := \"IM GetImageBlobAttribute\"(content, image_size, \'Comment\');\n"
"\n"
"xte_nodebld_init(res);\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', rdf_schema || \'type\'), image_format));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', rdf_schema || \'size\'), file_space_fmt (image_size)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', rdf_schema || \'dimensions\'), sprintf (\'%dx%d\', xsize, ysize)));\n"
"if (xres is not null and yres is not null)\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', rdf_schema || \'resolutions\'), sprintf (\'%s:%s\', xres, yres)));\n"
"\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', rdf_schema || \'depth\'), sprintf (\'%d\', depth)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', rdf_schema || \'comments\'), comments));\n"
"xte_nodebld_final(res, xte_head (UNAME\' root\'));\n"
"\n"
"return xml_tree_doc (res);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:384\n"
;

static const char *proc302 = 
"#line 423 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/audio\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare content any;\n"
"\n"
"content := blob_to_string (content1);\n"
"return xml_tree_doc (audio_to_xml (content, length (content), 1));\n"
"}\n"
"--src dav_meta.sql:421\n"
;

static const char *proc303 = 
"#line 432 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_audio/mpeg\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:430\n"
;

static const char *proc304 = 
"#line 438 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_audio/x-flac\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:436\n"
;

static const char *proc305 = 
"#line 444 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_audio/x-mp3\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:442\n"
;

static const char *proc306 = 
"#line 450 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_audio/x-m4a\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:448\n"
;

static const char *proc307 = 
"#line 456 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_audio/x-m4p\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:454\n"
;

static const char *proc308 = 
"#line 462 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/ogg\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:460\n"
;

static const char *proc309 = 
"#line 468 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msoffice+xml\" (in type_descr varchar, in orig_res_name varchar, inout content any, inout html_start any, inout docprops any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"if (docprops is null)\n"
"{\n"
"doc := xtree_doc (content, 0);\n"
"docprops := xpath_eval (\'/*/*:DocumentProperties\', doc);\n"
"}\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#Title\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Title\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Author\'       , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Author|o:Creator\'                           , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#LastAuthor\'   , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:LastAuthor\'                                 , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Company\'      , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Company\'                                    , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Words\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Words\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Pages\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Pages\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Lines\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Lines\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Last-Saved\'   , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:LastSaved|o:TimeSaved\'                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Last-Printed\' , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:LastPrinted|o:TimePrinted\'                  , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Created\'      , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Created|o:TimeCreated|o:CreationDate\'       , NULL );\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  type_descr );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (docprops, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:466\n"
;

static const char *proc310 = 
"#line 498 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msexcel\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Excel spreadsheet\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:496\n"
;

static const char *proc311 = 
"#line 509 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msaccess\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Access database\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:507\n"
;

static const char *proc312 = 
"#line 520 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msproject\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Project document\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:518\n"
;

static const char *proc313 = 
"#line 532 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/mspowerpoint\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS PowerPoint presentation\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:530\n"
;

static const char *proc314 = 
"#line 544 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msword\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Word document\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:542\n"
;

static const char *proc315 = 
"#line 556 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/pdf\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'PDF (Acrobat)\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:554\n"
;

static const char *proc316 = 
"#line 568 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/xbrl+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/xbrl#identifier\', \'declare namespace xmlns=\"http://www.xbrl.org/2003/instance\"; /xmlns:xbrl/xmlns:context/xmlns:entity/xmlns:identifier/text()\', \'\',\n"
"\'http://www.openlinksw.com/schemas/xbrl#startDate\', \'declare namespace xmlns=\"http://www.xbrl.org/2003/instance\"; /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:startDate union /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:instant\', \'\',\n"
"\'http://www.openlinksw.com/schemas/xbrl#endDate\', \'declare namespace xmlns=\"http://www.xbrl.org/2003/instance\"; /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:endDate union /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:instant\', \'\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:566\n"
;

static const char *proc317 = 
"#line 585 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/doap+rdf\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/doap#title\', \'declare namespace xmlns=\"http://usefulinc.com/ns/doap#\"; //xmlns:Project/xmlns:name\', \'\',\n"
"\'http://www.openlinksw.com/schemas/doap#description\', \'declare namespace xmlns=\"http://usefulinc.com/ns/doap#\"; //xmlns:Project/xmlns:shortdesc\', \'\',\n"
"\'http://www.openlinksw.com/schemas/doap#creationDate\', \'declare namespace xmlns=\"http://usefulinc.com/ns/doap#\"; //xmlns:Project/xmlns:created\', \'\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:583\n"
;

static const char *proc318 = 
"#line 603 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/xddl+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/XDDL#catalog\', \'/database/catalog\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#schema\', \'/database/schema\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#table\', \'/database/tables/table/@name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#view\', \'/database/views/view/@name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#procedure\', \'/database/procedures/procedure/@name\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/xddl+xml\'\n"
");\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:601\n"
;

static const char *proc319 = 
"#line 625 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/archive\" (in type_descr varchar, in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Archive#type\', type_descr);\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:623\n"
;

static const char *proc320 = 
"#line 639 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/tar\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'TAR archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:637\n"
;

static const char *proc321 = 
"#line 645 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/taz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'TAZ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:643\n"
;

static const char *proc322 = 
"#line 651 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/gz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'Gzip archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:649\n"
;

static const char *proc323 = 
"#line 657 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msi\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'Microsoft installer\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:655\n"
;

static const char *proc324 = 
"#line 663 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/dmg\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'DMG install package\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:661\n"
;

static const char *proc325 = 
"#line 669 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/arj\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ARJ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:667\n"
;

static const char *proc326 = 
"#line 675 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/bz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'BZ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:673\n"
;

static const char *proc327 = 
"#line 681 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/bz2\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'BZ2 archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:679\n"
;

static const char *proc328 = 
"#line 687 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/tgz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'TGZ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:685\n"
;

static const char *proc329 = 
"#line 693 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/rar\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'RAR archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:691\n"
;

static const char *proc330 = 
"#line 699 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/zip\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ZIP archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:697\n"
;

static const char *proc331 = 
"#line 705 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/cab\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'CAB archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:703\n"
;

static const char *proc332 = 
"#line 711 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/lzh\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'LZH archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:709\n"
;

static const char *proc333 = 
"#line 717 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/ace\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ACE archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:715\n"
;

static const char *proc334 = 
"#line 723 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/iso\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ISO image archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:721\n"
;

static const char *proc335 = 
"#line 729 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msword+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Word Document\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:727\n"
;

static const char *proc336 = 
"#line 737 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msexcel+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Excel Spreadsheet\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:735\n"
;

static const char *proc337 = 
"#line 745 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msproject+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Project\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:743\n"
;

static const char *proc338 = 
"#line 753 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/msvisio+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Visio\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:751\n"
;

static const char *proc339 = 
"#line 762 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/rss+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, res any;\n"
"xte_nodebld_init (res);\n"
"\n"
"whenever sqlstate \'*\' goto final;\n"
"doc := xtree_doc (content, 0);\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rss=\"http://purl.org/rss/1.0/\"]exists (/rdf:RDF/rss:channel)\', doc))\n"
"{\n"
"declare tmp_n3, channel_props any;\n"
"declare about varchar;\n"
"tmp_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', doc);\n"
"about := xpath_eval (\'/N3[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"][@N3O=\"http://purl.org/rss/1.0/channel\"]/@N3S\', tmp_n3);\n"
"if (about is null)\n"
"{\n"
"goto final;\n"
"}\n"
"channel_props := xpath_eval (\'/N3[@N3S=\\044about][not (exists (@N3O))]\', tmp_n3, 0, vector (UNAME\'about\', about));\n"
"foreach (any prop in channel_props) do\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop)),\n"
"xpath_eval (\'string (.)\', prop) ) );\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare version decimal;\n"
"declare metas, extras any;\n"
"version := xpath_eval (\'number (/rss/@version)\', doc);\n"
"if (version < 0.9)\n"
"goto final;\n"
"metas := vector (\n"
"\'http://purl.org/rss/1.0/title\', \'/rss/channel/title\', NULL,\n"
"\'http://purl.org/rss/1.0/link\', \'/rss/channel/link\', NULL,\n"
"\'http://purl.org/rss/1.0/description\', \'/rss/channel/description\', NULL,\n"
"\'http://purl.org/rss/1.0/language\', \'/rss/channel/language\', NULL,\n"
"\'http://purl.org/rss/1.0/copyright\', \'/rss/channel/copyright\', NULL,\n"
"\'http://purl.org/rss/1.0/docs\', \'/rss/channel/docs\', NULL,\n"
"\'http://purl.org/rss/1.0/lastBuildDate\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:unix-datetime-parser (/rss/channel/lastBuildDate | /rss/channel/pubDate, 0, 2)\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:760\n"
;

static const char *proc340 = 
"#line 814 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/atom+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"declare version decimal;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"version := xpath_eval (\'[xmlns:atom=\"http://purl.org/atom/ns#\"] number (/atom:feed/@version)\', doc);\n"
"if (version < 0.1)\n"
"goto atom2005;\n"
"metas := vector (\n"
"\'http://purl.org/rss/1.0/title\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:title\', NULL,\n"
"\'http://purl.org/rss/1.0/link\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:link/@href\', NULL,\n"
"\'http://purl.org/rss/1.0/description\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:tagline\', NULL,\n"
"\'http://purl.org/rss/1.0/language\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/@xml:lang\', NULL,\n"
"\'http://purl.org/rss/1.0/copyright\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:copyright\', NULL,\n"
"\'http://purl.org/rss/1.0/docs\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:info\', NULL,\n"
"\'http://purl.org/rss/1.0/lastBuildDate\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:unix-datetime-parser (/atom:feed/atom:modified, 0, 2)\', NULL\n"
");\n"
"atom2005:\n"
"if (xpath_eval (\'[xmlns:atom=\"http://www.w3.org/2005/Atom\"] exists (/atom:feed)\', doc))\n"
"{\n"
"metas := vector (\n"
"\'http://purl.org/rss/1.0/title\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:title\', NULL,\n"
"\'http://purl.org/rss/1.0/link\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:link/@href\', NULL,\n"
"\'http://purl.org/rss/1.0/description\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:subtitle\', NULL,\n"
"\'http://purl.org/rss/1.0/language\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/@xml:lang\', NULL,\n"
"\'http://purl.org/rss/1.0/copyright\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:rights\', NULL,\n"
"\'http://purl.org/rss/1.0/docs\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:summary\', NULL,\n"
"\'http://purl.org/rss/1.0/lastBuildDate\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:unix-datetime-parser (/atom:feed/atom:updated, 0, 2)\', NULL\n"
");\n"
"}\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:812\n"
;

static const char *proc341 = 
"#line 853 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/eml\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, res, content any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"content := blob_to_string (content1);\n"
"\n"
"xte_nodebld_init(res);\n"
"declare vec any;\n"
"declare from_, subject_, date_ varchar;\n"
"vec := vector();\n"
"vec := split_and_decode(content, 1, \'=_\\n:\');\n"
"declare i, l int;\n"
"i := 0;\n"
"l := length (vec);\n"
"while (i < l)\n"
"{\n"
"if (vec[i] = \'FROM\')\n"
"from_ := trim(vec[i+1], \'\\r\\n \');\n"
"if (vec[i] = \'SUBJECT\')\n"
"subject_ := trim(vec[i+1], \'\\r\\n \');\n"
"if (vec[i] = \'DATE\')\n"
"date_ := trim(vec[i+1], \'\\r\\n \');\n"
"i := i + 2;\n"
"}\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Email#from\'), from_));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Email#subject\'), subject_));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Email#date\'), date_));\n"
"xte_nodebld_final(res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:851\n"
;

static const char *proc342 = 
"#line 890 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/xbel+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'\"application/xbel+xml\"\', NULL,\n"
"\'http://www.openlinksw.com/virtdav#dynArchiver\', \'\"XBEL\"\', NULL,\n"
"\'http://www.python.org/topics/xml/xbel/title\', \'/xbel/title\', NULL,\n"
"\n"
"\'http://www.python.org/topics/xml/xbel/description\', \'/xbel/description\', NULL,\n"
"\n"
"\n"
"\n"
"\'http://www.python.org/topics/xml/xbel/lastBuildDate\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044v in /xbel/@added return virtbpel:unix-datetime-parser (\\044v, 0, 2)\', NULL,\n"
"\'http://www.python.org/topics/xml/xbel/folderTitle\', \'/xbel//folder/title\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:888\n"
;

static const char *proc343 = 
"#line 915 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/rdf+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'\"RDF+XML\"\', \'RDF+XML\'\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/rdf+xml\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:913\n"
;

static const char *proc344 = 
"#line 932 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/rdf+ttl\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'TURTLE\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:930\n"
;

static const char *proc345 = 
"#line 944 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/turtle\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'TURTLE\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:942\n"
;

static const char *proc346 = 
"#line 956 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/rdf+n3\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'N3\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:954\n"
;

static const char *proc347 = 
"#line 968 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/foaf+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, res any;\n"
"declare tmp_n3, obj1_props any;\n"
"declare about varchar;\n"
"xte_nodebld_init (res);\n"
"\n"
"whenever sqlstate \'*\' goto final;\n"
"doc := xtree_doc (content, 0);\n"
"tmp_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', doc);\n"
"about := xpath_eval (\'/N3[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"]/@N3S\', tmp_n3);\n"
"if (about is null or\n"
"xpath_eval (\n"
"\'/N3[@N3S=\\044about][@N3P=\"http://xmlns.com/foaf/0.1/name\"]\', tmp_n3, 1,\n"
"vector (UNAME\'about\', about) ) is null )\n"
"about := xpath_eval (\'/N3[@N3P=\"http://xmlns.com/foaf/0.1/name\"]/@N3S\', tmp_n3);\n"
"if (about is null)\n"
"{\n"
"goto final;\n"
"}\n"
"obj1_props := xpath_eval (\'/N3[@N3S=\\044about][starts-with (@N3P, \"http://xmlns.com/foaf/0.1/\")]\', tmp_n3, 0, vector (UNAME\'about\', about));\n"
"foreach (any prop in obj1_props) do\n"
"{\n"
"declare obj any;\n"
"obj := cast (xpath_eval (\'@N3O\', prop) as varchar);\n"
"if (obj is null)\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop)),\n"
"xpath_eval (\'string (.)\', prop) ) );\n"
"}\n"
"else if ((obj like \'node%\') or (obj like \'#%\'))\n"
"{\n"
"declare obj_names any;\n"
"obj_names := xpath_eval (\'/N3[@N3S = \\044obj][@N3P=\"http://xmlns.com/foaf/0.1/name\"]\', tmp_n3, 0, vector (UNAME\'obj\', obj));\n"
"foreach (any oname in obj_names) do\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop) || N\'-name\'),\n"
"xpath_eval (\'string (.)\', oname) ) );\n"
"}\n"
"}\n"
"else if ((obj like \'http://%\') or (obj like \'https://%\') or (obj like \'tel:%\') or (obj like \'mailto:%\') or (obj like \'urn:%\') or (obj like \'/%\'))\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop) || N\'-uri\'),\n"
"obj ) );\n"
"}\n"
"else\n"
"{\n"
" ;\n"
"}\n"
"}\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:966\n"
;

static const char *proc348 = 
"#line 1031 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/mods+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"if (xpath_eval (\'exists (/modsCollection)\', doc))\n"
"doc := xpath_eval (\'/modsCollection\', doc);\n"
"if (xpath_eval (\'count (mods)\', doc) <> 1)\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/MODS#topic\', \'mods/subject/topic\', NULL );\n"
"}\n"
"else\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/MODS#topic\', \'mods/subject/topic\', NULL,\n"
"\'http://www.openlinksw.com/schemas/MODS#title\', \'mods/titleInfo/title\', NULL,\n"
"\'http://www.openlinksw.com/schemas/MODS#subtitle\', \'mods/titleInfo/subTitle\', NULL,\n"
"\'http://www.openlinksw.com/schemas/MODS#url\', \'mods/location/url\', NULL );\n"
"}\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/mods+xml\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1029\n"
;

static const char *proc349 = 
"#line 1062 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/opml+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras, result, vals, outlines any;\n"
"declare graph_uri, new_uri, title, dateCreated, dateModified, ownerName, ownerEmail, owner_iri varchar;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/OPML#title\', \'/opml/head/title\', \'Untitled OPML\',\n"
"\'http://www.openlinksw.com/schemas/OPML#dateCreated\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044d in /opml/head/dateCreated return virtbpel:unix-datetime-parser (\\044d)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#dateModified\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044d in /opml/head/dateModified return virtbpel:unix-datetime-parser (\\044d)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerName\', \'/opml/head/ownerName\', \'Unknown OPML owner\',\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerEmail\', \'/opml/head/ownerEmail\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/opml+xml\' );\n"
"result := \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"title := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#title\"]\', result, 1) as varchar);\n"
"dateCreated := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#dateCreated\"]\', result, 1) as varchar);\n"
"dateModified := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#dateModified\"]\', result, 1) as varchar);\n"
"ownerName := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#ownerName\"]\', result, 1) as varchar);\n"
"ownerEmail := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#ownerEmail\"]\', result, 1) as varchar);\n"
"graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (graph_uri, orig_res_name);\n"
"if (left(orig_res_name, 4) = \'/DAV\')\n"
"orig_res_name := right(orig_res_name, length(orig_res_name) - 4);\n"
"DB.DBA.RDF_QUAD_URI (graph_uri, new_uri, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\', \'http://rdfs.org/sioc/ns#SubscriptionList\');\n"
"if (ownerName is not null)\n"
"{\n"
"declare s_out any;\n"
"s_out := string_output();\n"
"declare s varchar;\n"
"http_url(ownerName, null, s_out);\n"
"s := string_output_string(s_out);\n"
"owner_iri := concat(new_uri, \'#\', s);\n"
"}\n"
"if (ownerEmail is not null)\n"
"DB.DBA.RDF_QUAD_URI (graph_uri, new_uri, \'http://rdfs.org/sioc/ns#email\', \'mailto:\'|| ownerEmail);\n"
"if (title is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://purl.org/dc/elements/1.1/title\', title);\n"
"if (ownerName is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://rdfs.org/sioc/ns#has_owner\', ownerName);\n"
"if (dateModified is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', dateModified);\n"
"if (dateCreated is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://purl.org/dc/terms/created\', dateCreated);\n"
"return result;\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1060\n"
;

static const char *proc350 = 
"#line 1114 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/ocs+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/OPML#title\', \'//*:directory/*:title|//*:description/*:title\', \'Untitled OCS\',\n"
"\'http://www.openlinksw.com/schemas/OPML#dateCreated\', \'//*:directory/*:date|//*:description/*:date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#dateModified\', \'//*:directory/*:date|//*:description/*:date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerName\', \'//*:directory/*:publisher|//*:description/*:creator\', \'Unknown OPML owner\',\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerEmail\', \'//*:directory/*:creator|//*:description/*:creator\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/ocs+xml\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1112\n"
;

static const char *proc351 = 
"#line 1135 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/html\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare metas, extras any;\n"
"\n"
"if (html_start is null)\n"
"html_start := xtree_doc (content, 18, \'http://localdav.virt/\' || orig_res_name, \'LATIN-1\', \'x-any\',\n"
"\'Validation=DISABLE Include=DISABLE BuildStandalone=DISABLE SchemaDecl=DISABLE\' );\n"
"if (html_start is null)\n"
"goto errexit;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/XHTML#title\', \'/*/head/title|/*/*:head/*:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/XHTML#description\', \'(/*/head/meta[@name=\"description\" or @name=\"Description\"]/@content) | (/*/*:head/*:meta[@name=\"description\" or @name=\"Description\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#copyright\', \'(/*/head/meta[@name=\"copyright\" or @name=\"Copyright\"]/@content) | (/*/*:head/*:meta[@name=\"copyright\" or @name=\"Copyright\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#keyword\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:split-list ((/*/head/meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content) | (/*/*:head/*:meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content))\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#calendar\', \'(/*/div[@class=\"vevent\"]/div/abbr) | (/*/*:div[@class=\"vevent\"]/*:div/*:abbr) | (/*/div[@class=\"vjournal\"]/div/abbr) | (/*/*:div[@class=\"vjournal\"]/*:div/*:abbr) | (/*/div[@class=\"vtodo\"]/div/abbr) | (/*/*:div[@class=\"vtodo\"]/*:div/*:abbr) | (/*/div[@class=\"vfreebusy\"]/div/abbr) | (/*/*:div[@class=\"vfreebusy\"]/*:div/*:abbr)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#contacts\', \'(/div[@class=\"vcard\"]/span/a/span[@class=\"given-name\"] | /div[@class=\"vcard\"]/span/a/span[@class=\"family-name\"] | /div[@class=\"vcard\"]/a/span/span[@class=\"given-name\"] | /div[@class=\"vcard\"]/a/span/span[@class=\"family-name\"] | /div[@class=\"vcard\"]/a/span[@class=\"given-name\"] | /div[@class=\"vcard\"]/a/span[@class=\"family-name\"] | /div[@class=\"vcard\"]/a[@class=\"url fn\"])\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (html_start, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1133\n"
;

static const char *proc352 = 
"#line 1162 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlinksw-vsp\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare metas, extras any;\n"
"\n"
"if (html_start is null)\n"
"html_start := xtree_doc (content, 18, \'http://localdav.virt/\' || orig_res_name, \'LATIN-1\', \'x-any\',\n"
"\'Validation=DISABLE Include=DISABLE BuildStandalone=DISABLE SchemaDecl=DISABLE\' );\n"
"if (html_start is null)\n"
"goto errexit;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#title\', \'/*/head/title|/*/*:head/*:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/VSPX#description\', \'(/*/head/meta[@name=\"description\" or @name=\"Description\"]/@content) | (/*/*:head/*:meta[@name=\"description\" or @name=\"Description\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#copyright\', \'(/*/head/meta[@name=\"copyright\" or @name=\"Copyright\"]/@content) | (/*/*:head/*:meta[@name=\"copyright\" or @name=\"Copyright\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#keyword\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:split-list ((/*/head/meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content) | (/*/*:head/*:meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content))\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#type\', \'VSP\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (html_start, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1160\n"
;

static const char *proc353 = 
"#line 1188 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlinksw-vspx+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#pageId\', \'declare namespace v=\"http://www.openlinksw.com/vspx/\"; //v:page/@name\', \'Unidentified\',\n"
"\'http://www.openlinksw.com/schemas/VSPX#title\', \'/*/head/title|/*/*:head/*:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/VSPX#description\', \'(/*/head/meta[@name=\"description\"]/@content) | (/*/*:head/*:meta[@name=\"description\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#copyright\', \'(/*/head/meta[@name=\"copyright\"]/@content) | (/*/*:head/*:meta[@name=\"copyright\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#keyword\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:split-list ((/*/head/meta[@name=\"keyword\"]/@content) | (/*/*:head/*:meta[@name=\"keyword\"]/@content))\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#type\', \'VSPX\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1186\n"
;

static const char *proc354 = 
"#line 1210 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/bpel+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#processName\', \'declare namespace bpel=\"http://schemas.xmlsoap.org/ws/2003/03/business-process/\"; /bpel:process/@name\', \'Unidentified\',\n"
"\'http://www.openlinksw.com/schemas/WSDL#targetNamespace\', \'declare namespace bpel=\"http://schemas.xmlsoap.org/ws/2003/03/business-process/\"; /bpel:process/@targetNamespace\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#type\', \'BPEL\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1208\n"
;

static const char *proc355 = 
"#line 1229 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/annotea+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/Annotea#Bookmark\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; /*/*:Bookmark/@dc:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/Annotea#Topic\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; /*/*:Topic/@dc:title\', \'Untitled\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1227\n"
;

static const char *proc356 = 
"#line 1246 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/google-kinds+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/google-kinds#title\', \'/entry/title\', \'Untitled OPML\',\n"
"\'http://www.openlinksw.com/schemas/google-kinds#published\', \'/entry/published\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-kinds#updated\', \'/entry/updated\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-kinds#author\', \'/entry/author/name\', \'Unknown author\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1244\n"
;

static const char *proc357 = 
"#line 1265 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/wsdl+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#processName\', \'declare namespace wsdl=\"http://schemas.xmlsoap.org/wsdl/\"; /wsdl:definitions/@name\', \'Unidentified\',\n"
"\'http://www.openlinksw.com/schemas/WSDL#targetNamespace\', \'declare namespace wsdl=\"http://schemas.xmlsoap.org/wsdl/\"; /wsdl:definitions/@targetNamespace\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#type\', \'WSDL\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1263\n"
;

static const char *proc358 = 
"#line 1284 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/google-base+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/google-base#actor\', \'/*:entry/*:actor\', \'\',\n"
"\'http://www.openlinksw.com/schemas/google-base#adult\', \'null\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#age\', \'/*:entry/*:age\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#age_range\', \'/*:entry/*:age_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#agent\', \'/*:entry/*:agent\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#album\', \'/*:entry/*:album\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#apparel_type\', \'/*:entry/*:apparel_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#area\', \'/*:entry/*:area\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#artist\', \'/*:entry/*:artist\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#aspect_ratio\', \'/*:entry/*:aspect_ratio\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#author\', \'/*:entry/*:author/*:name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#bathrooms\', \'/*:entry/*:bathrooms\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#battery_life\', \'/*:entry/*:battery_life\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#bedrooms\', \'/*:entry/*:bedrooms\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#binding\', \'/*:entry/*:binding\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#brand\', \'/*:entry/*:brand\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#broker\', \'/*:entry/*:broker\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#calories\', \'/*:entry/*:calories\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#capacity\', \'/*:entry/*:capacity\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#category\', \'/*:entry/*:category\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#cholesterol\', \'/*:entry/*:cholesterol\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#color\', \'/*:entry/*:color\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#color_output\', \'/*:entry/*:color_output\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#condition\', \'/*:entry/*:condition\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#cooking_time\', \'/*:entry/*:cooking_time\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#countries\', \'/*:entry/*:countries\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#course\', \'/*:entry/*:course\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#cuisine\', \'/*:entry/*:cuisine\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#delivery\', \'/*:entry/*:delivery\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#delivery_notes\', \'/*:entry/*:delivery_notes\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#delivery_radius\', \'/*:entry/*:delivery_radius\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#department\', \'/*:entry/*:department\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#devices\', \'/*:entry/*:devices\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#director\', \'/*:entry/*:director\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#display_type\', \'/*:entry/*:display_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#edition\', \'/*:entry/*:edition\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#education\', \'/*:entry/*:education\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#employer\', \'/*:entry/*:employer\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#ethnicity\', \'/*:entry/*:ethnicity\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_date_range\', \'/*:entry/*:event_date_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_parking\', \'/*:entry/*:event_parking\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_performer\', \'/*:entry/*:event_performer\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_type\', \'/*:entry/*:event_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#expiration_date\', \'/*:entry/*:expiration_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#expiration_date\', \'/*:entry/*:expiration_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#feature\', \'/*:entry/*:feature\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#fiber\', \'/*:entry/*:fiber\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#file_type\', \'/*:entry/*:file_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#film_type\', \'/*:entry/*:film_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#focus_type\', \'/*:entry/*:focus_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#format\', \'/*:entry/*:format\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#from_location\', \'/*:entry/*:from_location\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#functions\', \'/*:entry/*:functions\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#gender\', \'/*:entry/*:gender\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#genre\', \'/*:entry/*:genre\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#heel_height\', \'/*:entry/*:heel_height\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#height\', \'/*:entry/*:height\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#hoa_dues\', \'/*:entry/*:hoa_dues\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#immigration_status\', \'/*:entry/*:immigration_status\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#installation\', \'/*:entry/*:installation\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#interested_in\', \'/*:entry/*:interested_in\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#isbn\', \'/*:entry/*:isbn\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#job_function\', \'/*:entry/*:job_function\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#job_industry\', \'/*:entry/*:job_industry\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#job_type\', \'/*:entry/*:job_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#languages\', \'/*:entry/*:languages\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#length\', \'/*:entry/*:length\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#listing_status\', \'/*:entry/*:listing_status\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#listing_type\', \'/*:entry/*:listing_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#load_type\', \'/*:entry/*:load_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#location\', \'/*:entry/*:location\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#lot_size\', \'/*:entry/*:lot_size\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#made_in\', \'/*:entry/*:made_in\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#main_ingredient\', \'/*:entry/*:main_ingredient\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#make\', \'/*:entry/*:make\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#marital_status\', \'/*:entry/*:marital_status\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#material\', \'/*:entry/*:material\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#meal_type\', \'/*:entry/*:meal_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#megapixels\', \'/*:entry/*:megapixels\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#memory_card_slot\', \'/*:entry/*:memory_card_slot\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mileage\', \'/*:entry/*:mileage\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mls_listing_id\', \'/*:entry/*:mls_listing_id\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mls_name\', \'/*:entry/*:mls_name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mobile_url\', \'/*:entry/*:mobile_url\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#model\', \'/*:entry/*:model\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#model_number\', \'/*:entry/*:model_number\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#name_of_item_reviewed\', \'/*:entry/*:name_of_item_reviewed\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#news_source\', \'/*:entry/*:news_source\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#occasion\', \'/*:entry/*:occasion\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#occupation\', \'/*:entry/*:occupation\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#open_house_date_range\', \'/*:entry/*:open_house_date_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#operating_system\', \'/*:entry/*:operating_system\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#optical_drive\', \'/*:entry/*:optical_drive\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#pages\', \'/*:entry/*:pages\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#payment\', \'/*:entry/*:payment\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#payment_notes\', \'/*:entry/*:payment_notes\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#pickup\', \'/*:entry/*:pickup\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#platform\', \'/*:entry/*:platform\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#preparation_method\', \'/*:entry/*:preparation_method\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#preparation_time\', \'/*:entry/*:preparation_time\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#price\', \'/*:entry/*:price\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#price_type\', \'/*:entry/*:price_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#price_units\', \'/*:entry/*:price_units\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#processor_speed\', \'/*:entry/*:processor_speed\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#product_type\', \'/*:entry/*:product_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#property_taxes\', \'/*:entry/*:property_taxes\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#property_type\', \'/*:entry/*:property_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#protein\', \'/*:entry/*:protein\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#provider_class\', \'/*:entry/*:provider_class\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#provider_rank\', \'/*:entry/*:provider_rank\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publication_name\', \'/*:entry/*:title\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publication_volume\', \'/*:entry/*:publication_volume\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publish_date\', \'/*:entry/*:publish_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publish_date\', \'/*:entry/*:publish_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publish_year\', \'/*:entry/*:publish_year\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publisher\', \'/*:entry/*:publisher\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publisher_url\', \'/*:entry/*:publisher_url\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#quantity\', \'/*:entry/*:quantity\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#rating\', \'/*:entry/*:rating\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#recommended_usage\', \'/*:entry/*:recommended_usage\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#resolution\', \'/*:entry/*:resolution\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#review_type\', \'/*:entry/*:review_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#reviewer_type\', \'/*:entry/*:reviewer_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#salary\', \'/*:entry/*:salary\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#salary_type\', \'/*:entry/*:salary_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#saturated_fat\', \'/*:entry/*:saturated_fat\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#school\', \'/*:entry/*:school\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#school_district\', \'/*:entry/*:school_district\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#screen_size\', \'/*:entry/*:screen_size\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#season_or_occasion\', \'/*:entry/*:season_or_occasion\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#service_type\', \'/*:entry/*:service_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#servings\', \'/*:entry/*:servings\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#sexual_orientation\', \'/*:entry/*:sexual_orientation\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#shipping\', \'/*:entry/*:shipping\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#shoe_width\', \'/*:entry/*:shoe_width\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#size\', \'/*:entry/*:size\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#sodium\', \'/*:entry/*:sodium\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#style\', \'/*:entry/*:style\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tax_percent\', \'/*:entry/*:tax_percent\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tax_region\', \'/*:entry/*:tax_region\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tech_spec_link\', \'/*:entry/*:tech_spec_link\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#to_location\', \'/*:entry/*:to_location\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tone_type\', \'/*:entry/*:tone_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#total_carbs\', \'/*:entry/*:total_carbs\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#total_fat\', \'/*:entry/*:total_fat\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#travel_date_range\', \'/*:entry/*:travel_date_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#upc\', \'/*:entry/*:upc\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#url_of_item_reviewed\', \'/*:entry/*:url_of_item_reviewed\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#vehicle_type\', \'/*:entry/*:vehicle_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#vin\', \'/*:entry/*:vin\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#web_url\', \'/*:entry/*:web_url\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#weight\', \'/*:entry/*:weight\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#width\', \'/*:entry/*:width\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#wireless_interface\', \'/*:entry/*:wireless_interface\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#year\', \'/*:entry/*:year\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#zoning\', \'/*:entry/*:zoning\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#zoom\', \'/*:entry/*:zoom\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1282\n"
;

static const char *proc359 = 
"#line 1456 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_application/x-openlinksw-vad\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras, tree, cont any;\n"
"declare s1, s2, s3, s4, len1 integer;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"if (aref(subseq(content, 0, 1), 0) <> 182)\n"
"goto errexit;\n"
"if (subseq(content, 5, 8) <> \'VAD\')\n"
"goto errexit;\n"
"if (subseq(content, 87, 94) <> \'STICKER\')\n"
"goto errexit;\n"
"s4 := aref(subseq(content, 95, 96), 0);\n"
"s3 := aref(subseq(content, 96, 97), 0);\n"
"s2 := aref(subseq(content, 97, 98), 0);\n"
"s1 := aref(subseq(content, 98, 99), 0);\n"
"len1 := s1 + 256 * ( s2 + 256 * ( s3 + 256 * ( s4 )));\n"
"cont := subseq(content, 99, 99 + len1);\n"
"tree := xml_tree (cont);\n"
"doc := xml_tree_doc (tree);\n"
"declare items any;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/VAD#packageName\', \'/sticker/caption/name/@package\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageTitle\', \'/sticker/caption/name/prop[@name=\"Title\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageDeveloper\', \'/sticker/caption/name/prop[@name=\"Developer\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageCopyright\', \'/sticker/caption/name/prop[@name=\"Copyright\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageDownload\', \'/sticker/caption/name/prop[@name=\"Download\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#versionNumber\', \'/sticker/caption/version/@package\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#versionBuild\', \'/sticker/caption/version/prop[@name=\"Build\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#releaseDate\', \'/sticker/caption/version/prop[@name=\"Release Date\"]/@value[1]\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/x-openlinksw-vad\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1454\n"
;

static const char *proc360 = 
"#line 1496 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/wiki\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"if (1)\n"
"{\n"
"declare _author varchar;\n"
"declare _cluster varchar;\n"
"declare _title varchar;\n"
"declare _cats, _categories any;\n"
"declare _date datetime;\n"
"\n"
"declare _res, _ent any;\n"
"_author := coalesce (connection_get (\'HTTP_CLI_UID\'), \'Unknown\');\n"
"_cluster := connection_get (\'oWiki Cluster\', \'Main\');\n"
"\n"
"_ent := xtree_doc ( \"WikiV lexer\" (blob_to_string(content) || \'\\r\\n\', \'Main\', \'DoesntMatter\', \'wiki\', null), 2);\n"
"\n"
"\n"
"declare titles any;\n"
"titles := xpath_eval (\'string(//h1/*)\', _ent, 0);\n"
"_title := NULL;\n"
"foreach (varchar t in titles) do\n"
"{\n"
"if (length (t) > length (_title))\n"
"_title := cast (t as varchar);\n"
"}\n"
"if (_title is null)\n"
"{\n"
"declare pos integer;\n"
"pos := strrchr(orig_res_name, \'/\');\n"
"if (pos > 0)\n"
"pos := pos + 1;\n"
"else\n"
"pos := 0;\n"
"_title := subseq (orig_res_name, pos, length (orig_res_name) - 4);\n"
"}\n"
"else\n"
"_title := cast (_title as varchar);\n"
"_date := now();\n"
"_cats := xpath_eval (\'//a[@style=\"wikiword\" and text() like \"Category%\"]/text()\', _ent, 0);\n"
"\n"
"vectorbld_init (_categories);\n"
"_res := XMLELEMENT (\'Wiki\',\n"
"XMLELEMENT(\'Cluster\', _cluster),\n"
"XMLELEMENT(\'Title\', _title),\n"
"XMLELEMENT(\'Author\', _author),\n"
"XMLELEMENT(\'Date\', cast (_date as varchar)));\n"
"\n"
"_ent := xpath_eval (\'/Wiki\', _res);\n"
"foreach (any _c in _cats) do\n"
"{\n"
"XMLAppendChildren (_ent, XMLELEMENT (\'Category\', cast (_c as varchar)));\n"
"}\n"
"declare metas, extras any;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/Wiki#Cluster\', \'/Wiki/Cluster\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Title\', \'/Wiki/Title\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Author\', \'/Wiki/Author\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Date\', \'/Wiki/Date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Category\', \'/Wiki/Category\', NULL);\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'text/wiki\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (_res, metas, extras);\n"
"}\n"
"}\n"
"--src dav_meta.sql:1494\n"
;

static const char *proc361 = 
"#line 1564 \"[executable]/dav_meta.sql\"\n"
"create function IMC_TO_XML (in _src varchar)\n"
"{\n"
"declare stack any;\n"
"declare lines any;\n"
"declare curr_IMC any;\n"
"declare line_idx, lines_count integer;\n"
"declare IMC_type varchar;\n"
"declare line, head, head_name, data, name, params varchar;\n"
"declare colon_pos, param_count, param_idx integer;\n"
"declare delims, head_parts, data_parts, line_acc any;\n"
"if (length (_src) > 2)\n"
"{\n"
"if ((_src[0] = 254) and (_src[1] = 255))\n"
"_src := charset_recode (subseq (_src, 2), \'UTF-16BE\', \'UTF-8\');\n"
"else if ((_src[0] = 255) and (_src[1] = 254))\n"
"_src := charset_recode (subseq (_src, 2), \'UTF-16LE\', \'UTF-8\');\n"
"}\n"
"IMC_type := \' root\';\n"
"stack := vector ();\n"
"xte_nodebld_init (curr_IMC);\n"
"_src := replace (_src, \'\\015\\012\', \'\\012\');\n"
"_src := replace (_src, \'\\012\\015\', \'\\012\');\n"
"_src := replace (_src, \'\\015\', \'\\012\');\n"
"_src := replace (_src, \'\\012 \', \'\');\n"
"lines := split_and_decode (_src, 0, \'\\0\\0\\n\');\n"
"lines_count := length (lines);\n"
"line_idx := 0;\n"
"while (line_idx < lines_count)\n"
"{\n"
"line := lines [line_idx];\n"
"while ((line_idx+1 < lines_count) and (chr (lines [line_idx+1][0]) = \' \' or chr (lines [line_idx+1][0]) = \'\\t\'))\n"
"{\n"
"line := line || subseq (lines [line_idx+1], 1);\n"
"line_idx := line_idx + 1;\n"
"}\n"
"if (line = \'\')\n"
"goto next_line;\n"
"if (regexp_match (\'^([A-Za-z0-9-]+[.])?((BEGIN)|(begin)):([A-Z]+)\\044\', line) is not null)\n"
"{\n"
"stack := vector_concat (vector (IMC_type, curr_IMC), stack);\n"
"IMC_type := upper (subseq (line, strchr (line, \':\') + 1));\n"
"xte_nodebld_init (curr_IMC);\n"
"xte_nodebld_acc (curr_IMC, \'\\n\');\n"
"goto next_line;\n"
"}\n"
"if (regexp_match (\'^([A-Za-z0-9-]+[.])?((END)|(end)):([A-Z]+)\\044\', line) is not null)\n"
"{\n"
"declare sub_IMC any;\n"
"declare close_type varchar;\n"
"if (2 > length (stack))\n"
"signal (\'22007\', sprintf (\'IMC text contains redundant \"END\" at line %d\', line_idx + 1));\n"
"close_type := upper (subseq (line, strchr (line, \':\') + 1));\n"
"if (close_type <> IMC_type)\n"
"signal (\'22007\', sprintf (\'IMC text contains \"END:%s\" instead of expected \"END:%s\" at line %d\', close_type, IMC_type, line_idx + 1));\n"
"xte_nodebld_final (curr_IMC, xte_head (\'IMC-\' || IMC_type));\n"
"sub_IMC := curr_IMC;\n"
"IMC_type := stack[0];\n"
"curr_IMC := stack[1];\n"
"stack := subseq (stack, 2);\n"
"xte_nodebld_acc (curr_IMC, sub_IMC);\n"
"xte_nodebld_acc (curr_IMC, \'\\n\');\n"
"goto next_line;\n"
"}\n"
"xte_nodebld_init (line_acc);\n"
"delims := regexp_parse (\n"
"\n"
"\'^([A-Za-z0-9-]+[.])?([A-Za-z0-9-]+)(([;][A-Za-z0-9-]+(=(([^\\001-\\037\\200-\\377\";:,]*)|(\"[^\\001-\\037\\200-\\377\"]*\"))(,(([^\\001-\\037\\200-\\377\";:,]*)|(\"[^\\001-\\037\\200-\\377\"]*\")))*)?)*)([:])([\\011\\040-\\377]*)\\044\',\n"
"\n"
"line, 0 );\n"
"if (delims is null)\n"
"{\n"
"head := \'X-ERROR\';\n"
"data := line;\n"
"}\n"
"else\n"
"{\n"
"colon_pos := delims[7];\n"
"head := subseq (line, 0, colon_pos);\n"
"data := subseq (line, colon_pos + 1);\n"
"}\n"
"head_parts := split_and_decode (head, 0, \'\\0\\0;\');\n"
"head_name := head_parts [0];\n"
"param_idx := 1;\n"
"param_count := length (head_parts);\n"
"while (param_idx < param_count)\n"
"{\n"
"declare param_strg, param_name, param_data varchar;\n"
"declare eq_pos integer;\n"
"param_strg := head_parts [param_idx];\n"
"eq_pos := strchr (param_strg, \'=\');\n"
"if (eq_pos is null)\n"
"xte_nodebld_acc (line_acc,\n"
"xte_node (xte_head (UNAME\'TYPE\'), param_strg) );\n"
"else\n"
"{\n"
"param_name := subseq (param_strg, 0, eq_pos);\n"
"param_data := split_and_decode (subseq (param_strg, eq_pos + 1), 0, \'\\0\\0,\');\n"
"foreach (varchar pd in param_data) do\n"
"{\n"
"if (pd like \'\"%\"\')\n"
"pd := subseq (pd, 1, length (pd) - 1);\n"
"xte_nodebld_acc (line_acc,\n"
"xte_node (xte_head (param_name), pd) );\n"
"}\n"
"}\n"
"param_idx := param_idx + 1;\n"
"}\n"
"if ((length (data) > 0) and\n"
"( position (\'ENCODING=QUOTED-PRINTABLE\', head_parts) or\n"
"position (\'ENCODING=\"QUOTED-PRINTABLE\"\', head_parts) ) )\n"
"{\n"
"while ((data [length (data) - 1] = 61) and\n"
"((line_idx + 1) < lines_count) )\n"
"{\n"
"line_idx := line_idx + 1;\n"
"data := subseq (data, 0, length (data) - 1) || lines [line_idx];\n"
"}\n"
"}\n"
"\n"
"data := replace (data, \'\\\\,\', \'\\1\');\n"
"data := replace (data, \'\\\\;\', \'\\2\');\n"
"data := replace (data, \'\\\\n\', \'\\015\\012\');\n"
"data := replace (data, \'\\\\N\', \'\\015\\012\');\n"
"data := replace (data, \'\\\\\\\\\', \'\\\\\');\n"
"\n"
"if (strchr (data, \';\') is not null)\n"
"{\n"
"data_parts := split_and_decode (data, 0, \'\\0\\0;\');\n"
"\n"
"foreach (varchar datum in data_parts) do\n"
"{\n"
"declare recoded varchar;\n"
"datum := replace (datum, \'\\1\', \',\');\n"
"datum := replace (datum, \'\\2\', \';\');\n"
"recoded := charset_recode (datum, \'UTF-8\', \'_WIDE_\');\n"
"if (not (isstring (recoded)))\n"
"recoded := charset_recode (datum, NULL, \'_WIDE_\');\n"
"xte_nodebld_acc (line_acc, xte_node (xte_head (UNAME\'fld\'), recoded));\n"
"}\n"
"}\n"
"else if (strchr (data, \',\') is not null)\n"
"{\n"
"data_parts := split_and_decode (data, 0, \'\\0\\0,\');\n"
"\n"
"foreach (varchar datum in data_parts) do\n"
"{\n"
"declare recoded varchar;\n"
"datum := replace (datum, \'\\1\', \',\');\n"
"datum := replace (datum, \'\\2\', \';\');\n"
"recoded := charset_recode (datum, \'UTF-8\', \'_WIDE_\');\n"
"if (not (isstring (recoded)))\n"
"recoded := charset_recode (datum, NULL, \'_WIDE_\');\n"
"xte_nodebld_acc (line_acc, xte_node (xte_head (UNAME\'val\'), recoded));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare recoded varchar;\n"
"data := replace (data, \'\\1\', \',\');\n"
"data := replace (data, \'\\2\', \';\');\n"
"recoded := charset_recode (data, \'UTF-8\', \'_WIDE_\');\n"
"if (not (isstring (recoded)))\n"
"recoded := charset_recode (data, NULL, \'_WIDE_\');\n"
"xte_nodebld_acc (line_acc, xte_node (xte_head (UNAME\'val\'), recoded));\n"
"}\n"
"xte_nodebld_final (line_acc, xte_head (head_name));\n"
"xte_nodebld_acc (curr_IMC, line_acc, \'\\n\');\n"
"next_line:\n"
"line_idx := line_idx + 1;\n"
" ;\n"
"}\n"
"\n"
"if (0 <> length (stack))\n"
"signal (\'22007\', sprintf (\'IMC text has no closing \"END:%s\" before the end of text\', stack[0]));\n"
"xte_nodebld_final (curr_IMC, xte_head (UNAME\' root\'));\n"
"return curr_IMC;\n"
"}\n"
"--src dav_meta.sql:1562\n"
;

static const char *proc362 = 
"#line 1744 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_text/directory\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, diritems, res, metas, extras any;\n"
"xte_nodebld_init (res);\n"
"\n"
"whenever sqlstate \'*\' goto final;\n"
"if (not isstring (content))\n"
"doc := IMC_TO_XML (cast (content as varchar));\n"
"else\n"
"doc := IMC_TO_XML (content);\n"
"doc := xml_tree_doc (doc);\n"
"\n"
"diritems := xpath_eval (\'/*\', doc, 0);\n"
"foreach (any diritm in diritems) do\n"
"{\n"
"declare itemname varchar;\n"
"declare ctr, len integer;\n"
"itemname := xpath_eval (\'name(.)\', diritm);\n"
"if (itemname = \'IMC-VCARD\')\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'\"text/directory\"\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#FN\', \'FN/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#NICKNAME\', \'NICKNAME/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#BDAY\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044v in BDAY/val return virtbpel:unix-datetime-parser (\\044v)\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#MAILER\', \'MAILER/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#GEO\', \'GEO/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#TITLE\', \'TITLE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#ROLE\', \'ROLE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#CATEGORIES\', \'CATEGORIES/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#N\', \'if (N/val) then concat (N/val, \";;;;\") else concat (N/fld[1], \";\", N/fld[2], \";\", N/fld[3], \";\", N/fld[4], \";\", N/fld[5])\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#SOURCE\', \'SOURCE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#NOTE\', \'NOTE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#PRODID\', \'PRODID/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#REV\', \'REV/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#SORT-STRING\', \'SORT-STRING/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#CLASS\', \'CLASS/val\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#TEL\', \'for \\044v in TEL/val return concat (\\044v, for \\044t in \\044v/../TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#EMAIL\', \'for \\044v in EMAIL/val return concat (\\044v, for \\044t in \\044v/../TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#ADR\', \'for \\044v in ADR return concat (if (\\044v/val) then concat (\\044v/val, \";;;;;;\") else concat (\\044v/fld[1], \";\", \\044v/fld[2], \";\", \\044v/fld[3], \";\", \\044v/fld[4], \";\", \\044v/fld[5], \";\", \\044v/fld[6], \";\", \\044v/fld[7]), for \\044t in \\044v/TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#LABEL\', \'for \\044v in LABEL/val return concat (\\044v, for \\044t in \\044v/../TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#UID\', \'CLASS/val\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Family\', \'N/fld[1]|N/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Given\', \'N/fld[2]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Other\', \'N/fld[3]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Prefix\', \'N/fld[4]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Suffix\', \'N/fld[5]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Pobox\', \'ADR/fld[1]|ADR/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Extadd\', \'ADR/fld[2]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Street\', \'ADR/fld[3]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Locality\', \'ADR/fld[4]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Region\', \'ADR/fld[5]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Pcode\', \'ADR/fld[6]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Country\', \'ADR/fld[7]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgname\', \'ORG/fld[1]|ORG/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgunit\', \'ORG/fld[position() > 1]\', null\n"
");\n"
"}\n"
"else if (itemname = \'IMC-VCALENDAR\')\n"
"{\n"
"\n"
"if ((length (diritems) = 1) and (xpath_eval(\'count (IMC-VEVENT)\', diritm) > 0))\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/ICS#SUMMARY\', \'IMC-VEVENT/SUMMARY/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#LOCATION\', \'IMC-VEVENT/LOCATION/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#CATEGORIES\', \'IMC-VEVENT/CATEGORIES/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ATTENDEE\', \'IMC-VEVENT/ATTENDEE/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ORGANIZER\', \'IMC-VEVENT/ORGANIZER/val\', null );\n"
"}\n"
"else if ((length (diritems) = 1) and (xpath_eval(\'count (IMC-VTODO)\', diritm) > 0))\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/ICS#SUMMARY\', \'IMC-VTODO/SUMMARY/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#LOCATION\', \'IMC-VTODO/LOCATION/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#CATEGORIES\', \'IMC-VTODO/CATEGORIES/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ATTENDEE\', \'IMC-VTODO/ATTENDEE/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ORGANIZER\', \'IMC-VTODO/ORGANIZER/val\', null);\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/ICS#SUMMARY\', \'IMC-VEVENT/SUMMARY/val\', null );\n"
"\n"
"}\n"
"}\n"
"else\n"
"metas := vector ();\n"
"\n"
"extras := vector ();\n"
"\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (diritm, metas, extras);\n"
"\n"
"len := length (metas);\n"
"\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"{\n"
"declare vals varchar;\n"
"vals := xquery_eval (metas [ctr + 1], diritm, 0);\n"
"\n"
"\n"
"if (vals is not null)\n"
"{\n"
"foreach (any val in vals) do\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', metas [ctr]),\n"
"cast (val as varchar) ) );\n"
"}\n"
"}\n"
"}\n"
"\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:1742\n"
;

static const char *proc363 = 
"#line 1870 \"[executable]/dav_meta.sql\"\n"
"create function \"DAV_EXTRACT_RDF_BY_METAS\" (inout doc any, inout metas any, inout extras any)\n"
"{\n"
"\n"
"declare res any;\n"
"declare ctr, len integer;\n"
"\n"
"xte_nodebld_init (res);\n"
"whenever sqlstate \'*\' goto final;\n"
"len := length (metas);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 3)\n"
"{\n"
"declare vals varchar;\n"
"vals := xquery_eval (metas [ctr + 1], doc, 0);\n"
"\n"
"if (length (vals) = 0)\n"
"{\n"
"vals := metas [ctr + 2];\n"
"if (vals is not null)\n"
"vals := vector (vals);\n"
"}\n"
"foreach (any val in vals) do\n"
"{\n"
"\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', metas [ctr]),\n"
"replace(cast (val as varchar), \'?\', \'_\') ) );\n"
"}\n"
"}\n"
"len := length (extras);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"{\n"
"declare val any;\n"
"val := extras [ctr + 1];\n"
"if (val is not null)\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', extras [ctr]),\n"
"cast (val as varchar) ) );\n"
"}\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:1868\n"
;

static const char *proc364 = 
"#line 1922 \"[executable]/dav_meta.sql\"\n"
"create function DB.DBA.UNIX_DATETIME_PARSER (in strg varchar, in trap_error integer := 0, in output_mode integer := 0)\n"
"{\n"
"declare m integer;\n"
"declare res varchar;\n"
"declare parts any;\n"
"declare Yr, Mo, MN, Da, hms, tz varchar;\n"
"\n"
"if (strg is null)\n"
"return null;\n"
"strg := cast (strg as varchar);\n"
"\n"
"parts := regexp_parse(\'^([A-Z][a-z][a-z]), ([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9]) ([0-2][0-9]:[0-6][0-9]:[0-6][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Da := subseq (strg, parts[4], parts[5]);\n"
"MN := subseq (strg, parts[6], parts[7]);\n"
"Yr := subseq (strg, parts[8], parts[9]);\n"
"hms := subseq (strg, parts[10], parts[11]);\n"
"tz := subseq (strg, parts[12], parts[13]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9]) ([0-2][0-9]:[0-6][0-9]:[0-6][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Da := subseq (strg, parts[2], parts[3]);\n"
"MN := subseq (strg, parts[4], parts[5]);\n"
"Yr := subseq (strg, parts[6], parts[7]);\n"
"hms := subseq (strg, parts[8], parts[9]);\n"
"tz := subseq (strg, parts[10], parts[11]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])-([ 0-1][0-9])-([ 0-3][0-9])( |T)([0-2][0-9]:[0-6][0-9]:[0-6][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"hms := subseq (strg, parts[10], parts[11]);\n"
"tz := subseq (strg, parts[12], parts[13]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])([0-1][0-9])([0-3][0-9])(T)([0-2][0-9][0-6][0-9][0-6][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"hms := subseq (strg, parts[10], parts[11]);\n"
"hms := subseq (hms, 0, 2) || \':\' ||\n"
"subseq (hms, 2, 4) || \':\' ||\n"
"subseq (hms, 4, 6) ;\n"
"tz := subseq (strg, parts[12], parts[13]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"res := DB.DBA.UNIX_DATE_PARSER (strg, 1, 0);\n"
"if (res is not null)\n"
"{\n"
"res := cast (res as datetime);\n"
"goto final_cast;\n"
"}\n"
"if (trap_error)\n"
"return NULL;\n"
"signal (\'22005\', sprintf (\'UNIX_DATETIME_PARSER has failed to parse \"%.200s\"\', strg));\n"
"\n"
"parts_ready:\n"
"if (Mo is null)\n"
"Mo := get_keyword (upper (MN), vector (\'JAN\', \'01\', \'FEB\', \'02\', \'MAR\', \'03\', \'APR\', \'04\', \'MAY\', \'05\', \'JUN\', \'06\', \'JUL\', \'07\', \'AUG\', \'08\', \'SEP\', \'09\', \'OCT\', \'10\', \'NOV\', \'11\', \'DEC\', \'12\'));\n"
"res := sprintf (\'%s-%s-%s %s\', Yr, Mo, Da, hms);\n"
"\n"
"if (trap_error)\n"
"{\n"
"whenever sqlstate \'*\' goto recov;\n"
"res := cast (res as datetime);\n"
"}\n"
"else\n"
"res := cast (res as datetime);\n"
"\n"
"final_cast:\n"
"if (output_mode = 0)\n"
"return res;\n"
"if (output_mode = 1)\n"
"return cast (res as varchar);\n"
"if (output_mode = 2)\n"
"return replace (cast (res as varchar), \' \', \'T\');\n"
"\n"
"recov:\n"
"if (output_mode = 0)\n"
"return null;\n"
"return \'?\' || strg;\n"
"}\n"
"--src dav_meta.sql:1920\n"
;

static const char *other6 = 
"grant execute on DB.DBA.UNIX_DATETIME_PARSER to public\n";
static const char *other7 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/bpel:unix-datetime-parser\', fix_identifier_case (\'DB.DBA.UNIX_DATETIME_PARSER\'), 0)\n";
static const char *proc365 = 
"#line 2031 \"[executable]/dav_meta.sql\"\n"
"create function DB.DBA.UNIX_DATE_PARSER (in strg varchar, in trap_error integer := 0, in output_mode integer := 0)\n"
"{\n"
"declare m integer;\n"
"declare res varchar;\n"
"declare parts any;\n"
"declare Yr, Mo, MN, Da, tz varchar;\n"
"\n"
"if (strg is null)\n"
"return null;\n"
"strg := cast (strg as varchar);\n"
"\n"
"parts := regexp_parse(\'^([A-Z][a-z][a-z]), ([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Da := subseq (strg, parts[4], parts[5]);\n"
"MN := subseq (strg, parts[6], parts[7]);\n"
"Yr := subseq (strg, parts[8], parts[9]);\n"
"tz := subseq (strg, parts[10], parts[11]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Da := subseq (strg, parts[2], parts[3]);\n"
"MN := subseq (strg, parts[4], parts[5]);\n"
"Yr := subseq (strg, parts[6], parts[7]);\n"
"tz := subseq (strg, parts[8], parts[9]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])-([ 0-1][0-9])-([ 0-3][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"tz := subseq (strg, parts[8], parts[9]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])([0-1][0-9])([0-3][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"tz := subseq (strg, parts[8], parts[9]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"if (trap_error)\n"
"return NULL;\n"
"signal (\'22005\', sprintf (\'UNIX_DATE_PARSER has failed to parse \"%.200s\"\', strg));\n"
"\n"
"parts_ready:\n"
"if (Mo is null)\n"
"Mo := get_keyword (upper (MN), vector (\'JAN\', \'01\', \'FEB\', \'02\', \'MAR\', \'03\', \'APR\', \'04\', \'MAY\', \'05\', \'JUN\', \'06\', \'JUL\', \'07\', \'AUG\', \'08\', \'SEP\', \'09\', \'OCT\', \'10\', \'NOV\', \'11\', \'DEC\', \'12\'));\n"
"res := sprintf (\'%s-%s-%s\', Yr, Mo, Da);\n"
"\n"
"if (trap_error)\n"
"{\n"
"whenever sqlstate \'*\' goto recov;\n"
"res := cast (res as date);\n"
"}\n"
"else\n"
"res := cast (res as date);\n"
"if (output_mode = 0)\n"
"return res;\n"
"if (output_mode = 1)\n"
"return cast (res as varchar);\n"
"if (output_mode = 2)\n"
"return cast (res as varchar);\n"
"\n"
"recov:\n"
"if (output_mode = 0)\n"
"return null;\n"
"return \'?\' || strg;\n"
"}\n"
"--src dav_meta.sql:2029\n"
;

static const char *other8 = 
"grant execute on DB.DBA.UNIX_DATE_PARSER to public\n";
static const char *other9 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/bpel:unix-date-parser\', fix_identifier_case (\'DB.DBA.UNIX_DATE_PARSER\'), 0)\n";
static const char *proc366 = 
"#line 2131 \"[executable]/dav_meta.sql\"\n"
"create function DB.DBA.BPEL_SPLIT_LIST (in strg varchar)\n"
"{\n"
"declare parts, res any;\n"
"\n"
"if (strg is null)\n"
"return null;\n"
"strg := cast (strg as varchar);\n"
"if (strchr (strg, \';\'))\n"
"parts := split_and_decode (strg, 0, \'\\0\\0;\');\n"
"else if (strchr (strg, \',\'))\n"
"parts := split_and_decode (strg, 0, \'\\0\\0,\');\n"
"else\n"
"parts := split_and_decode (strg, 0, \'\\0\\0 ,\');\n"
"if (length (parts) = 0)\n"
"return null;\n"
"xq_sequencebld_init (res);\n"
"foreach (varchar part in parts) do\n"
"{\n"
"xq_sequencebld_acc (res, charset_recode (trim (part), NULL, \'UTF-8\'));\n"
"}\n"
"xq_sequencebld_final (res);\n"
"return res;\n"
"}\n"
"--src dav_meta.sql:2129\n"
;

static const char *other10 = 
"grant execute on DB.DBA.BPEL_SPLIT_LIST to public\n";
static const char *other11 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/bpel:split-list\', fix_identifier_case (\'DB.DBA.BPEL_SPLIT_LIST\'), 0)\n";
static const char *proc367 = 
"#line 2163 \"[executable]/dav_meta.sql\"\n"
"create function DAV_EXTRACT_SPOTLIGHT (in resname varchar, inout rescontent any) returns any\n"
"{\n"
"declare temp_name varchar;\n"
"declare sp_metadata, virt_metas, ret, _reg any;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{ log_message (\'SpotLight import fail: \' || __SQL_MESSAGE); return NULL; };\n"
"\n"
"if (not spotlight_status ())\n"
"return NULL;\n"
"\n"
"_reg := cast (registry_get (\'VAD_is_run\') as varchar);\n"
"if (_reg <> \'0\')\n"
"return NULL;\n"
"\n"
"sys_mkdir (\'sptmp\');\n"
"temp_name := \'sptmp/\' || resname;\n"
"\n"
"string_to_file (temp_name, blob_to_string (rescontent), -2);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"run_executable (\'/usr/bin/mdimport\', 1, \' -f \', server_root () || temp_name);\n"
"sp_metadata := SPOTLIGHT_METADATA (temp_name);\n"
"sys_unlink (temp_name);\n"
"\n"
"virt_metas := DAV_CONVERT_SPOTLIGHT_TO_VIRTUOSO (sp_metadata);\n"
"\n"
"return virt_metas;\n"
"}\n"
"--src dav_meta.sql:2161\n"
;

static const char *proc368 = 
"#line 2202 \"[executable]/dav_meta.sql\"\n"
"create function DAV_CONVERT_SPOTLIGHT_TO_VIRTUOSO (in sp_data any) returns any\n"
"{\n"
"declare loop_names, len, v_meta, ret, ctr, res, added integer;\n"
"\n"
"loop_names := 0;\n"
"added := 0;\n"
"len := length (sp_data);\n"
"v_meta := vector ();\n"
"xte_nodebld_init (res);\n"
"\n"
"while (len > loop_names)\n"
"{\n"
"declare line, name, vals any;\n"
"line := sp_data [loop_names];\n"
"name := line [0];\n"
"vals := line [1];\n"
"if (name in (\'kMDItemLastUsedDate\', \'kMDItemUsedDates\', \'kMDItemFSFinderFlags\',\n"
"\'kMDItemFSOwnerUserID\', \'kMDItemFSOwnerGroupID\', \'kMDItemFSTypeCode\',\n"
"\'kMDItemID\', \'kMDItemFSSize\', \'kMDItemFSCreationDate\', \'kMDItemContentCreationDate\',\n"
"\'kMDItemFSContentChangeDate\', \'kMDItemFSCreatorCode\', \'kMDItemFSLabel\',\n"
"\'kMDItemFSInvisible\', \'kMDItemFSNodeCount\', \'kMDItemAttributeChangeDate\',\n"
"\'kMDItemDisplayName\', \'kMDItemContentModificationDate\', \'kMDItemFSName\', \'kMDItemContentTypeTree\'))\n"
"goto end_loop;\n"
"\n"
"if (__tag (vals) = 193)\n"
"foreach (any val in line [1]) do\n"
"DAV_SPOTLIGHT_ADD (res, name, val);\n"
"else\n"
"DAV_SPOTLIGHT_ADD (res, name, line [1]);\n"
"\n"
"added := added + 1;\n"
"\n"
"end_loop:\n"
"loop_names := loop_names + 1;\n"
"}\n"
"\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"if (added)\n"
"return xml_tree_doc (res);\n"
"\n"
"return null;\n"
"}\n"
"--src dav_meta.sql:2200\n"
;

static const char *proc369 = 
"#line 2247 \"[executable]/dav_meta.sql\"\n"
"create procedure DAV_SPOTLIGHT_ADD (inout res any, in name varchar, inout val any)\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\',\n"
"\'http://www.apple.com/metadata#\' || name),\n"
"cast (val as nvarchar) ) );\n"
"}\n"
"--src dav_meta.sql:2245\n"
;

static const char *proc370 = 
"#line 2258 \"[executable]/dav_meta.sql\"\n"
" create procedure DB.DBA.XML_UNIX_DATE_TO_ISO (in unixdt integer)\n"
"{\n"
"declare ts any;\n"
"if (not isinteger (unixdt))\n"
"return \'\';\n"
"ts := dateadd (\'second\', unixdt, stringdate (\'1970-1-1\'));\n"
"ts := dt_set_tz (ts, 0);\n"
"return soap_print_box (ts, \'\', 0);\n"
"}\n"
"--src dav_meta.sql:2256\n"
;

static const char *other12 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME)\n"
"VALUES (\'http://www.openlinksw.com/xsltext/:unixTime2ISO\', \'DB.DBA.XML_UNIX_DATE_TO_ISO\')\n";
static const char *other13 = 
"xpf_extension (\'http://www.openlinksw.com/xsltext/:unixTime2ISO\', \'DB.DBA.XML_UNIX_DATE_TO_ISO\', 0)\n";
static const char *proc371 = 
"#line 2276 \"[executable]/dav_meta.sql\"\n"
"create procedure DAV_EXTRACT_META_AS_RDF_XML (\n"
"in resname varchar,\n"
"in rescontent any := null)\n"
"{\n"
"\n"
"declare res_type_uri, restype varchar;\n"
"declare html_start, type_tree any;\n"
"declare addon_n3, spotlight_addon_n3, ret any;\n"
"\n"
"if (rescontent is null)\n"
"rescontent := XML_URI_GET (resname, \'\');\n"
"html_start := null;\n"
"spotlight_addon_n3 := null;\n"
"addon_n3 := null;\n"
"restype := DAV_GUESS_MIME_TYPE (resname, rescontent, html_start);\n"
"if (restype is not null)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto addon_n3_set;\n"
"};\n"
"addon_n3 := call (\'DB.DBA.DAV_EXTRACT_RDF_\' || restype)(resname, rescontent, html_start);\n"
"res_type_uri := DAV_GET_RES_TYPE_URI_BY_MIME_TYPE(restype);\n"
"if (res_type_uri is not null)\n"
"{\n"
"type_tree := xtree_doc (\'<N3 N3S=\"http://local.virt/this\" N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\" N3O=\"\' || res_type_uri || \'\"/>\' );\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, type_tree, null, 0);\n"
"}\n"
"addon_n3_set: ;\n"
"}\n"
"if (__proc_exists (\'SPOTLIGHT_METADATA\', 2) is not null)\n"
"spotlight_addon_n3 := DAV_EXTRACT_SPOTLIGHT (resname, rescontent);\n"
"\n"
"if (addon_n3 is null and spotlight_addon_n3 is null)\n"
"goto no_op;\n"
"\n"
"no_old:\n"
"if (spotlight_addon_n3 is not null)\n"
"{\n"
"if (addon_n3 is not null)\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, spotlight_addon_n3, null, 0);\n"
"else\n"
"addon_n3 := spotlight_addon_n3;\n"
"}\n"
"ret := xslt (\'http://local.virt/davxml2rdfxml\', addon_n3, vector (\'this-real-uri\', resname));\n"
"if (xpath_eval (\'count(/RDF/*)\', ret) = 0)\n"
"goto no_op;\n"
"ret := serialize_to_UTF8_xml (ret);\n"
"\n"
"ret := replace (ret, \'http://local.virt/this\', resname);\n"
"return ret;\n"
"no_op:\n"
"return NULL;\n"
"}\n"
"--src dav_meta.sql:2274\n"
;

/* dav_acct.sql */

static const char *proc372 = 
"#line 23 \"[executable]/dav_acct.sql\"\n"
"create function DAV_SPACE_QUOTA_PARENT (in res_path varchar, out _u_id integer, out _above_hy datetime, out _dav_use numeric, out _total_use numeric, out _quota numeric) returns varchar\n"
"{\n"
"declare head, tail, _home_path varchar;\n"
"declare slash_pos integer;\n"
"declare cr cursor for select DSQ_HOME_PATH, DSQ_U_ID, DSQ_ABOVE_HI_YELLOW, DSQ_DAV_USE, DSQ_TOTAL_USE, DSQ_QUOTA from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH >= head and DSQ_HOME_PATH <= res_path;\n"
"\n"
"_home_path := \'\';\n"
"head := \'/\';\n"
"tail := subseq (res_path, 1);\n"
"while (1)\n"
"{\n"
"open cr;\n"
"whenever not found goto nf;\n"
"fetch cr into _home_path, _u_id, _above_hy, _dav_use, _total_use, _quota;\n"
"close cr;\n"
"if (_home_path = \"LEFT\" (res_path, length (_home_path)))\n"
"goto done;\n"
"\n"
"nf:\n"
"close cr;\n"
"slash_pos := strchr (tail, \'/\');\n"
"if (slash_pos is null)\n"
"{\n"
"_home_path := null;\n"
"goto done;\n"
"}\n"
"head := head || \"LEFT\" (tail, slash_pos + 1);\n"
"tail := subseq (tail, slash_pos + 1);\n"
"if (head < _home_path)\n"
"goto nf;\n"
"}\n"
"\n"
"done:\n"
"\n"
"return _home_path;\n"
"}\n"
"--src dav_acct.sql:21\n"
;

static const char *proc373 = 
"#line 61 \"[executable]/dav_acct.sql\"\n"
"create function DAV_ADD_SPACE_QUOTA (in _home_path varchar, in _u_id integer, in _quota numeric) returns integer\n"
"{\n"
"declare home_id any;\n"
"declare old_u_id integer;\n"
"declare reloc_path varchar;\n"
"declare reloc_dav_use, reloc_quota, old_dav_use, dav_use, old_app_use, old_max_dav_use, old_max_app_use numeric;\n"
"declare reloc_above_hy, old_above_hy datetime;\n"
"if (not exists (select top 1 1 from WS.WS.SYS_DAV_USER where U_ID = _u_id))\n"
"return -6;\n"
"home_id := DAV_SEARCH_ID (_home_path, \'C\');\n"
"if (DAV_HIDE_ERROR (home_id) is null)\n"
"return home_id;\n"
"if (not (isinteger (home_id)))\n"
"return -33;\n"
"if (_home_path <> \'/\')\n"
"{\n"
"declare parent_path varchar;\n"
"declare parent_u_id integer;\n"
"declare parent_above_hy datetime;\n"
"declare parent_dav_use, parent_total_use, parent_quota numeric;\n"
"parent_path := DAV_SPACE_QUOTA_PARENT (_home_path, parent_u_id, parent_above_hy, parent_dav_use, parent_total_use, parent_quota);\n"
"if ((parent_path is not null) and (parent_path <> _home_path))\n"
"return -38;\n"
"}\n"
"reloc_path := null;\n"
"old_app_use := 0;\n"
"old_max_app_use := 0;\n"
"if (_u_id is null)\n"
"goto no_old_home;\n"
"whenever not found goto no_old_home;\n"
"select DSQ_HOME_PATH	, DSQ_DAV_USE	, DSQ_APP_USE	, DSQ_MAX_APP_USE	, DSQ_QUOTA	, DSQ_ABOVE_HI_YELLOW\n"
"into reloc_path	, reloc_dav_use	, old_app_use	, old_max_app_use	, reloc_quota	, reloc_above_hy\n"
"from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_U_ID = _u_id;\n"
"\n"
"no_old_home:\n"
"whenever not found goto do_insert;\n"
"select DSQ_U_ID, DSQ_ABOVE_HI_YELLOW, DSQ_DAV_USE, DSQ_MAX_DAV_USE into old_u_id, old_above_hy, old_dav_use, old_max_dav_use from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = _home_path;\n"
"if (old_u_id is not null)\n"
"{\n"
"if (old_u_id <> _u_id)\n"
"return -38;\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set DSQ_QUOTA = _quota where DSQ_HOME_PATH = _home_path and DSQ_QUOTA <> _quota;\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_U_ID = _u_id, DSQ_QUOTA = _quota,\n"
"DSQ_APP_USE = old_app_use,\n"
"DSQ_MAX_APP_USE = old_max_app_use,\n"
"DSQ_MAX_TOTAL_USE = __max (DSQ_MAX_DAV_USE, DSQ_DAV_USE + DSQ_APP_USE),\n"
"DSQ_ABOVE_HI_YELLOW = null, DSQ_LAST_WARNING = null\n"
"where DSQ_HOME_PATH = _home_path;\n"
"old_above_hy := null;\n"
"}\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (_home_path, _u_id, old_above_hy, old_dav_use + old_app_use, _quota);\n"
"goto update_reloc_path;\n"
"\n"
"do_insert:\n"
"dav_use := coalesce (\n"
"(select SUM (cast (length (RES_CONTENT) as numeric))\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH between _home_path and DAV_COL_PATH_BOUNDARY (_home_path) ),\n"
"0 );\n"
"insert into WS.WS.SYS_DAV_SPACE_QUOTA\n"
"(DSQ_U_ID		, DSQ_HOME_PATH		,\n"
"DSQ_DAV_USE	, DSQ_APP_USE		, DSQ_TOTAL_USE			,\n"
"DSQ_MAX_DAV_USE	, DSQ_MAX_APP_USE	, DSQ_MAX_TOTAL_USE		,\n"
"DSQ_QUOTA		, DSQ_ABOVE_HI_YELLOW	, DSQ_LAST_WARNING	)\n"
"values\n"
"(_u_id		, _home_path		,\n"
"dav_use		, old_app_use		, dav_use + old_app_use		,\n"
"dav_use		, old_max_app_use	, dav_use + old_max_app_use	,\n"
"_quota		, NULL			, NULL			);\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (_home_path, _u_id, null, dav_use + old_app_use, _quota);\n"
"\n"
"update_reloc_path:\n"
"if ((reloc_path is not null) and (reloc_path <> _home_path))\n"
"{\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_U_ID = null, DSQ_APP_USE = 0, DSQ_TOTAL_USE = DSQ_DAV_USE,\n"
"DSQ_MAX_APP_USE = 0, DSQ_MAX_TOTAL_USE = DSQ_MAX_DAV_USE,\n"
"DSQ_LAST_WARNING = null\n"
"where DSQ_HOME_PATH = reloc_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (reloc_path, null, reloc_above_hy, reloc_dav_use, reloc_quota);\n"
"}\n"
"return home_id;\n"
"}\n"
"--src dav_acct.sql:59\n"
;

static const char *proc374 = 
"#line 150 \"[executable]/dav_acct.sql\"\n"
"create function DAV_DEL_SPACE_QUOTA (in _home_path varchar) returns integer\n"
"{\n"
"declare old_u_id integer;\n"
"declare old_quota numeric;\n"
"declare old_above_hy datetime;\n"
"whenever not found goto nf;\n"
"select DSQ_U_ID, DSQ_QUOTA, DSQ_ABOVE_HI_YELLOW into old_u_id, old_quota, old_above_hy\n"
"from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = _home_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (_home_path, old_u_id, old_above_hy, 0, old_quota);\n"
"delete from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = _home_path;\n"
"return 0;\n"
"\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src dav_acct.sql:148\n"
;

static const char *proc375 = 
"#line 167 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_SPACE_QUOTA_YELLOW_TRACK (in _home_path varchar, in _u_id integer, in old_above_hy datetime, in total_use numeric, in _quota numeric)\n"
"{\n"
"\n"
"set isolation=\'serializable\';\n"
"if (old_above_hy is not null)\n"
"{\n"
"if (total_use < (_quota * 0.75))\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
" ;\n"
"};\n"
"DAV_SPACE_QUOTA_LO_YELLOW_DOWN (_home_path, _u_id, total_use, _quota);\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set DSQ_ABOVE_HI_YELLOW = null where DSQ_HOME_PATH = _home_path;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (total_use > (_quota * 0.90))\n"
"{\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set DSQ_ABOVE_HI_YELLOW = now() where DSQ_HOME_PATH = _home_path;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
" ;\n"
"};\n"
"DAV_SPACE_QUOTA_HI_YELLOW_UP (_home_path, _u_id, total_use, _quota);\n"
"}\n"
"}\n"
"}\n"
"--src dav_acct.sql:165\n"
;

static const char *proc376 = 
"#line 200 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_SPACE_QUOTA_SIGNAL (in res_path varchar, in home_path varchar, in _u_id integer, in _total_use numeric, in _quota numeric)\n"
"{\n"
"declare u_descr, msg varchar;\n"
"declare owner_u_id, home_col_id integer;\n"
"if (http_dav_uid () = coalesce (connection_get (\'DAVBillingUserID\'), -12))\n"
"return;\n"
"if (_u_id is not null)\n"
"u_descr := coalesce ((select \'quota of user \"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = _u_id), sprintf (\'quota of user #%d\', _u_id));\n"
"else\n"
"{\n"
"home_col_id := DAV_SEARCH_ID (home_path, \'C\');\n"
"if (DAV_HIDE_ERROR (home_col_id) is null)\n"
"signal (\'HT500\', sprintf (\'DAV integrity violation: ancestor collection %s not found for resource %s\', home_path, res_path));\n"
"if (not isinteger (home_col_id))\n"
"signal (\'HT500\', sprintf (\'DAV integrity violation: collection %s is a DET subcollection, can not use DAV quotas for %s\', home_path, res_path));\n"
"owner_u_id := coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = home_col_id), http_nobody_uid());\n"
"u_descr := coalesce ((select \'owner \"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = owner_u_id), sprintf (\'owner #%d\', owner_u_id));\n"
"}\n"
"rollback work;\n"
"msg := sprintf (\'DAV quota exceeded for collection %s (%s): only %s bytes allowed but %s required.\',\n"
"home_path, u_descr, cast (_quota as varchar), cast (_total_use as varchar) );\n"
"\n"
"signal (\'HT507\', msg);\n"
"}\n"
"--src dav_acct.sql:198\n"
;

static const char *proc377 = 
"#line 226 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_OWNER_DISABLED_SIGNAL (in res_path varchar, in _u_id integer)\n"
"{\n"
"declare u_descr, msg varchar;\n"
"declare owner_u_id, home_col_id integer;\n"
"if (_u_id = http_nobody_uid())\n"
"return;\n"
"if (http_dav_uid () = coalesce (connection_get (\'DAVBillingUserID\'), -12))\n"
"return;\n"
"u_descr := coalesce ((select \'\"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = _u_id), sprintf (\'#%d\', _u_id));\n"
"rollback work;\n"
"msg := sprintf (\'The resource %s is unavailable because resource owner %s is disabled.\',\n"
"res_path, u_descr );\n"
"\n"
"signal (\'HT508\', msg);\n"
"}\n"
"--src dav_acct.sql:224\n"
;

static const char *proc378 = 
"#line 243 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_HOME_DISABLED_SIGNAL (in res_path varchar, in home_path varchar, in _u_id integer)\n"
"{\n"
"declare u_descr, msg varchar;\n"
"declare owner_u_id, home_col_id integer;\n"
"if (http_dav_uid () = coalesce (connection_get (\'DAVBillingUserID\'), -12))\n"
"return;\n"
"u_descr := coalesce ((select \'user \"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = _u_id), sprintf (\'user #%d\', _u_id));\n"
"rollback work;\n"
"msg := sprintf (\'Access to a home DAV collection %s of a disabled account (%s) is blocked.\',\n"
"home_path, u_descr );\n"
"\n"
"signal (\'HT509\', msg);\n"
"}\n"
"--src dav_acct.sql:241\n"
;

static const char *proc379 = 
"#line 258 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_SPACE_QUOTA_RES_INSERT (in newr_path varchar, in newr_len integer)\n"
"{\n"
"declare parent_path varchar;\n"
"declare parent_u_id integer;\n"
"declare parent_above_hy datetime;\n"
"declare parent_dav_use, parent_total_use, parent_quota numeric;\n"
"\n"
"parent_path := DAV_SPACE_QUOTA_PARENT (newr_path, parent_u_id, parent_above_hy, parent_dav_use, parent_total_use, parent_quota);\n"
"if (parent_path is null)\n"
"goto done;\n"
"set isolation=\'committed\';\n"
"if (parent_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = parent_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (newr_path, parent_path, parent_u_id);\n"
"set isolation=\'serializable\';\n"
"parent_dav_use := parent_dav_use + newr_len;\n"
"parent_total_use := parent_total_use + newr_len;\n"
"if (parent_total_use > parent_quota)\n"
"DAV_SPACE_QUOTA_SIGNAL (newr_path, parent_path, parent_u_id, parent_total_use, parent_quota);\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = parent_dav_use,\n"
"DSQ_TOTAL_USE = parent_total_use,\n"
"DSQ_MAX_DAV_USE = __max (DSQ_MAX_DAV_USE, parent_dav_use),\n"
"DSQ_MAX_TOTAL_USE = __max (DSQ_MAX_TOTAL_USE, parent_total_use)\n"
"where DSQ_HOME_PATH = parent_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (parent_path, parent_u_id, parent_above_hy, parent_total_use, parent_quota);\n"
"\n"
"done:\n"
"\n"
" ;\n"
"}\n"
"--src dav_acct.sql:256\n"
;

static const char *proc380 = 
"#line 293 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_SPACE_QUOTA_RES_DELETE (in oldr_path varchar, in oldr_len integer)\n"
"{\n"
"declare parent_path varchar;\n"
"declare parent_u_id integer;\n"
"declare parent_above_hy datetime;\n"
"declare parent_dav_use, parent_total_use, parent_quota numeric;\n"
"\n"
"parent_path := DAV_SPACE_QUOTA_PARENT (oldr_path, parent_u_id, parent_above_hy, parent_dav_use, parent_total_use, parent_quota);\n"
"if (parent_path is null)\n"
"goto done;\n"
"set isolation=\'committed\';\n"
"if (parent_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = parent_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (oldr_path, parent_path, parent_u_id);\n"
"set isolation=\'serializable\';\n"
"parent_dav_use := parent_dav_use - oldr_len;\n"
"parent_total_use := parent_total_use - oldr_len;\n"
"if ((parent_dav_use < 0) or (parent_total_use < 0))\n"
"{\n"
"\n"
"parent_dav_use := coalesce (\n"
"(select SUM (cast (length (RES_CONTENT) as numeric))\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH between parent_path and DAV_COL_PATH_BOUNDARY (parent_path) ),\n"
"0 );\n"
"parent_total_use := parent_dav_use + (select __max (DSQ_APP_USE, 0) from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = parent_path);\n"
"}\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = parent_dav_use,\n"
"DSQ_TOTAL_USE = parent_total_use\n"
"where DSQ_HOME_PATH = parent_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (parent_path, parent_u_id, parent_above_hy, parent_total_use, parent_quota);\n"
"\n"
"done:\n"
"\n"
" ;\n"
"}\n"
"--src dav_acct.sql:291\n"
;

static const char *proc381 = 
"#line 334 \"[executable]/dav_acct.sql\"\n"
"create procedure DAV_SPACE_QUOTA_RES_UPDATE (in oldr_path varchar, in oldr_len integer, in newr_path varchar, in newr_len integer)\n"
"{\n"
"declare src_path, tgt_path varchar;\n"
"declare src_u_id, tgt_u_id integer;\n"
"declare src_above_hy, tgt_above_hy datetime;\n"
"declare src_dav_use, src_total_use, src_quota, tgt_dav_use, tgt_total_use, tgt_quota numeric;\n"
"\n"
"src_path := DAV_SPACE_QUOTA_PARENT (oldr_path, src_u_id, src_above_hy, src_dav_use, src_total_use, src_quota);\n"
"set isolation = \'committed\';\n"
"if (src_path is not null and src_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = src_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (oldr_path, src_path, src_u_id);\n"
"set isolation=\'serializable\';\n"
"if ((oldr_path = newr_path) or (src_path = \"LEFT\" (newr_path, length (src_path))))\n"
"{\n"
"\n"
"if (src_path is null)\n"
"goto done;\n"
"if (oldr_len = newr_len)\n"
"goto done;\n"
"\n"
"tgt_path := src_path;\n"
"tgt_above_hy := src_above_hy;\n"
"tgt_dav_use := src_dav_use;\n"
"tgt_total_use := src_total_use;\n"
"tgt_quota := src_quota;\n"
"if (oldr_len < newr_len)\n"
"{\n"
"newr_len := newr_len - oldr_len;\n"
"src_path := null;\n"
"}\n"
"else\n"
"{\n"
"oldr_len := oldr_len - newr_len;\n"
"tgt_path := null;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"\n"
"tgt_path := DAV_SPACE_QUOTA_PARENT (newr_path, tgt_u_id, tgt_above_hy, tgt_dav_use, tgt_total_use, tgt_quota);\n"
"if (src_path is null and tgt_path is null)\n"
"goto done;\n"
"set isolation=\'committed\';\n"
"if (tgt_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = tgt_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (newr_path, tgt_path, tgt_u_id);\n"
"set isolation=\'serializable\';\n"
"}\n"
"if (tgt_path is not null)\n"
"{\n"
"tgt_dav_use := tgt_dav_use + newr_len;\n"
"tgt_total_use := tgt_total_use + newr_len;\n"
"if (tgt_total_use > tgt_quota)\n"
"DAV_SPACE_QUOTA_SIGNAL (newr_path, tgt_path, tgt_u_id, tgt_total_use, tgt_quota);\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = tgt_dav_use,\n"
"DSQ_TOTAL_USE = tgt_total_use,\n"
"DSQ_MAX_DAV_USE = __max (DSQ_MAX_DAV_USE, tgt_dav_use),\n"
"DSQ_MAX_TOTAL_USE = __max (DSQ_MAX_TOTAL_USE, tgt_total_use)\n"
"where DSQ_HOME_PATH = tgt_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (tgt_path, tgt_u_id, tgt_above_hy, tgt_total_use, tgt_quota);\n"
"}\n"
"if (src_path is not null)\n"
"{\n"
"src_dav_use := src_dav_use - oldr_len;\n"
"src_total_use := src_total_use - oldr_len;\n"
"if ((src_dav_use < 0) or (src_total_use < 0))\n"
"{\n"
"\n"
"src_dav_use :=  coalesce (\n"
"(select SUM (cast (length (RES_CONTENT) as numeric))\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH between src_path and DAV_COL_PATH_BOUNDARY (src_path) ),\n"
"0 );\n"
"src_total_use := src_dav_use + (select __max (DSQ_APP_USE, 0) from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = src_path);\n"
"}\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = src_dav_use,\n"
"DSQ_TOTAL_USE = src_total_use\n"
"where DSQ_HOME_PATH = src_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (src_path, src_u_id, src_above_hy, src_total_use, src_quota);\n"
"}\n"
"\n"
"done:\n"
"\n"
" ;\n"
"}\n"
"--src dav_acct.sql:332\n"
;

/* dav_rdf_quad.sql */

static const char *proc382 = 
"#line 23 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.RDF_DELETE_ENTIRE_GRAPH (in new_dav_graph varchar, in param integer)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = DB.DBA.RDF_MAKE_IID_OF_QNAME (new_dav_graph);\n"
"}\n"
"--src dav_rdf_quad.sql:21\n"
;

static const char *proc383 = 
"#line 29 \"[executable]/dav_rdf_quad.sql\"\n"
"create function DB.DBA.DAV_FULL_PATH_TO_IRI (in dav_iri varchar, in _str varchar) returns varchar\n"
"{\n"
"declare _ses any;\n"
"_ses := string_output();\n"
"http (dav_iri, _ses);\n"
"http_escape (subseq (_str, 4), 7, _ses, 0, 1);\n"
"return string_output_string(_ses);\n"
"}\n"
"--src dav_rdf_quad.sql:27\n"
;

static const char *proc384 = 
"#line 39 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_AUTO_REPLICATE_TO_RDF_QUAD ()\n"
"{\n"
"declare uriqa_default_host, old_dav_graph, new_dav_graph varchar;\n"
"uriqa_default_host := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"if (isstring (registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\')))\n"
"return;\n"
"if (uriqa_default_host is null or uriqa_default_host = \'\')\n"
"return;\n"
"DB.DBA.DAV_REPLICATE_ALL_TO_RDF_QUAD (1);\n"
"}\n"
"--src dav_rdf_quad.sql:37\n"
;

static const char *proc385 = 
"#line 51 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_REPLICATE_ALL_TO_RDF_QUAD (in enable integer)\n"
"{\n"
"declare uriqa_default_host, old_dav_graph, new_dav_graph varchar;\n"
"declare trx_size integer;\n"
"uriqa_default_host := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"if (uriqa_default_host is null or uriqa_default_host = \'\')\n"
"signal (\'OBLOM\', \'No uriqa_default_host!\');\n"
"if (virtuoso_ini_item_value (\'URIQA\', \'DynamicLocal\') = \'1\')\n"
"new_dav_graph := \'local:/DAV/\';\n"
"else\n"
"new_dav_graph := sprintf (\'http://%s/DAV/\', uriqa_default_host);\n"
"exec (\'checkpoint\');\n"
"__atomic (1);\n"
"DB.DBA.RDF_DELETE_ENTIRE_GRAPH (new_dav_graph, 1);\n"
"old_dav_graph := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (isstring (old_dav_graph) and old_dav_graph <> new_dav_graph and old_dav_graph <> \'\')\n"
"DB.DBA.RDF_DELETE_ENTIRE_GRAPH (old_dav_graph, 1);\n"
"if (not enable)\n"
"{\n"
"registry_set (\'DB.DBA.DAV_RDF_GRAPH_URI\', \'\');\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"return;\n"
"}\n"
"declare state, msg any;\n"
"declare status varchar;\n"
"state := \'00000\';\n"
"result_names (status);\n"
"state := \'00000\';\n"
"exec (\'create index SYS_DAV_RES_IID on WS.WS.SYS_DAV_RES (RES_IID)\', state, msg, vector ());\n"
"if (state <> \'00000\')\n"
"result (\'warning: index in WS.WS.SYS_DAV_RES\');\n"
"state := \'00000\';\n"
"exec (\'create index SYS_DAV_COL_IID on WS.WS.SYS_DAV_COL (COL_IID)\', state, msg, vector ());\n"
"if (state <> \'00000\')\n"
"result (\'warning: index in WS.WS.SYS_DAV_COL\');\n"
"registry_set (\'DB.DBA.DAV_RDF_GRAPH_URI\', new_dav_graph);\n"
"trx_size := 0;\n"
"for (select RES_ID, RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_PERMS[6] = 49) do\n"
"{\n"
"trx_size := trx_size + DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (RES_ID, RES_FULL_PATH);\n"
"if (trx_size > 10000)\n"
"{\n"
"commit work;\n"
"trx_size := 0;\n"
"}\n"
"}\n"
"commit work;\n"
"trx_size := 0;\n"
"for (select COL_ID from WS.WS.SYS_DAV_COL where COL_PERMS[6] = 49) do\n"
"{\n"
"trx_size := trx_size + DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (COL_ID);\n"
"if (trx_size > 10000)\n"
"{\n"
"commit work;\n"
"trx_size := 0;\n"
"}\n"
"}\n"
"commit work;\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"return;\n"
"}\n"
"--src dav_rdf_quad.sql:49\n"
;

static const char *proc386 = 
"#line 116 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.RDF_CBD_DELETE (inout triple_list any, in graph_id any, in local_dav_uri any)\n"
"{\n"
"declare not_deleteable, candidates any;\n"
"declare cand_ctr, cand_first_unconfirmed, cand_count integer;\n"
"\n"
"set isolation = \'committed\';\n"
"not_deleteable := dict_new ();\n"
"again:\n"
"candidates := dict_new ();\n"
"foreach (any triple in triple_list) do\n"
"{\n"
"declare obj any;\n"
"obj := triple[2];\n"
"delete from DB.DBA.RDF_QUAD where G = graph_id and S = triple[0] and P = triple[1] and equ (O, obj);\n"
"if (isiri_id (obj) and not dict_get (not_deleteable, obj, 0))\n"
"dict_put (candidates, obj, 1);\n"
"}\n"
"candidates := dict_list_keys (candidates, 1);\n"
"gvector_sort (candidates, 1, 0, 1);\n"
"cand_count := length (candidates);\n"
"cand_first_unconfirmed := 0;\n"
"for (cand_ctr := 0; cand_ctr < cand_count; cand_ctr := cand_ctr + 1)\n"
"{\n"
"declare obj any;\n"
"obj := candidates [cand_ctr];\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_QUAD where G = graph_id and S = obj))\n"
"goto non_del;\n"
"if (obj < #i1000000000)\n"
"{\n"
"declare qname varchar;\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD where P = obj))\n"
"goto non_del;\n"
"if (exists (select top 1 1 from DB.DBA.RDF_DATATYPE where RDT_IID = obj))\n"
"goto non_del;\n"
"qname := id_to_iri (obj);\n"
"\n"
"if (qname is null)\n"
"goto non_del;\n"
"if (qname >= local_dav_uri and qname < concat (local_dav_uri, \'\\377\\377\\377\\377\'))\n"
"goto non_del;\n"
"}\n"
"\n"
"\n"
"candidates [cand_first_unconfirmed] := obj;\n"
"cand_first_unconfirmed := cand_first_unconfirmed + 1;\n"
"goto next_cand;\n"
"\n"
"non_del:\n"
"dict_put (not_deleteable, obj, 1);\n"
"\n"
"next_cand: ;\n"
"}\n"
"\n"
"if (0 = cand_first_unconfirmed)\n"
"return;\n"
"\n"
"vectorbld_init (triple_list);\n"
"for (cand_ctr := 0; cand_ctr < cand_first_unconfirmed; cand_ctr := cand_ctr + 1)\n"
"{\n"
"declare obj any;\n"
"obj := candidates [cand_ctr];\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_QUAD\n"
"where G = graph_id and O = obj option (quietcast) ) )\n"
"{\n"
"for (select P,O from DB.DBA.RDF_QUAD where G = graph_id and S = obj) do\n"
"vectorbld_acc (triple_list, vector (obj,P,O));\n"
"}\n"
"}\n"
"vectorbld_final (triple_list);\n"
"if (0 <> length (triple_list))\n"
"goto again;\n"
"}\n"
"--src dav_rdf_quad.sql:114\n"
;

static const char *proc387 = 
"#line 190 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_RDF_URI_RESOLVE (in dav_rdf_graph_uri varchar, in iri any, in fullpath varchar, in res_type varchar) returns varchar\n"
"{\n"
"declare abs_uri varchar;\n"
"if (iri = \'http://local.virt/this\')\n"
"abs_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"\n"
"\n"
"else if (left (iri, 22) = \'http://local.virt/DAV/\')\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"abs_uri := dav_rdf_graph_uri || subseq (iri, 22);\n"
"}\n"
"else\n"
"{\n"
"declare base_uri varchar;\n"
"base_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"abs_uri := DB.DBA.XML_URI_RESOLVE_LIKE_GET (base_uri, iri);\n"
"}\n"
"return abs_uri;\n"
"}\n"
"--src dav_rdf_quad.sql:188\n"
;

static const char *proc388 = 
"#line 216 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_RDF_REPLICATE_INT (in res_id integer, in restype varchar, in fullpath varchar)\n"
"{\n"
"declare n3v, n3_list, dav_rdf_graph_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"declare ro_id_dict any;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"whenever not found goto no_op;\n"
"select xml_tree_doc (deserialize (blob_to_string (PROP_VALUE)))\n"
"into n3v\n"
"from WS.WS.SYS_DAV_PROP\n"
"where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = res_id;\n"
"n3v := xslt (\'http://local.virt/davxml2n3xml\', n3v);\n"
"n3_list := xpath_eval (\'/N3\', n3v, 0);\n"
"ro_id_dict := dict_new (1 + length (n3_list));\n"
"foreach (any n3 in n3_list) do\n"
"{\n"
"declare s, p, o, dt, lang, v varchar;\n"
"s := xpath_eval (\'@N3S\', n3);\n"
"p := xpath_eval (\'@N3P\', n3);\n"
"o := xpath_eval (\'@N3O\', n3);\n"
"s := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, s, fullpath, restype);\n"
"if (o is not null)\n"
"o := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, o, fullpath, restype);\n"
"dt := xpath_eval (\'@N3DT\', n3);\n"
"lang := xpath_eval (\'@xml:lang\', n3);\n"
"v := coalesce (xquery_eval (\'if (exists(*)) then * else string ()\', n3), \'\');\n"
"if (isarray(v))\n"
"v := v[0];\n"
"\n"
"if (o is not null)\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, s, p, o);\n"
"else\n"
"DB.DBA.RDF_QUAD_URI_L_TYPED (dav_rdf_graph_uri, s, p, v, dt, lang, ro_id_dict);\n"
"\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (dav_rdf_graph_uri), ro_id_dict);\n"
"no_op:;\n"
"}\n"
"--src dav_rdf_quad.sql:214\n"
;

static const char *proc389 = 
"#line 259 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_RDF_CBD_DELETE_PROP (in n3v any, in fullpath varchar, in restype varchar, in dav_rdf_graph_iid IRI_ID, in dav_rdf_graph_uri varchar)\n"
"{\n"
"declare n3_list, triple_list any;\n"
"\n"
"n3v := xslt (\'http://local.virt/davxml2n3xml\', n3v);\n"
"n3_list := xpath_eval (\'/N3\', n3v, 0);\n"
"vectorbld_init (triple_list);\n"
"foreach (any n3 in n3_list) do\n"
"{\n"
"declare lang, v, app_env varchar;\n"
"declare s, p, o, dt any;\n"
"s := xpath_eval (\'@N3S\', n3);\n"
"p := xpath_eval (\'@N3P\', n3);\n"
"o := xpath_eval (\'@N3O\', n3);\n"
"s := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, s, fullpath, restype);\n"
"if (o is not null)\n"
"o := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, o, fullpath, restype);\n"
"dt := xpath_eval (\'@N3DT\', n3);\n"
"lang := xpath_eval (\'@xml:lang\', n3);\n"
"v := coalesce (xquery_eval (\'if (exists(*)) then * else string ()\', n3), \'\');\n"
"if (isarray(v))\n"
"v := v[0];\n"
"\n"
"s := DB.DBA.RDF_MAKE_IID_OF_QNAME (s);\n"
"p := DB.DBA.RDF_MAKE_IID_OF_QNAME (p);\n"
"if (o is not null)\n"
"o := DB.DBA.RDF_MAKE_IID_OF_QNAME (o);\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"dt := DB.DBA.RDF_MAKE_IID_OF_QNAME (dt);\n"
"o := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (v, dt, lang);\n"
"}\n"
"vectorbld_acc (triple_list, vector (s, p, o));\n"
"}\n"
"vectorbld_final (triple_list);\n"
"DB.DBA.RDF_CBD_DELETE (triple_list, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"--src dav_rdf_quad.sql:257\n"
;

static const char *proc390 = 
"#line 299 \"[executable]/dav_rdf_quad.sql\"\n"
"create function DB.DBA.DAV_MAKE_USER_IRI (in userid integer)\n"
"{\n"
"declare email varchar;\n"
"email := (select U_E_MAIL from DB.DBA.SYS_USERS where U_ID = userid);\n"
"if (email is null or email=\'\')\n"
"{\n"
"declare uriqa_default_host varchar;\n"
"uriqa_default_host := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"if (not isstring (uriqa_default_host))\n"
"signal (\'22023\', \'Function DB.DBA.DAV_MAKE_USER_IRI() has failed to get \"DefaultHost\" parameter of [URIQA] section of Virtuoso configuration file\');\n"
"email := sprintf (\'mailto:UserId%d@%s\', userid, uriqa_default_host);\n"
"}\n"
"else\n"
"{\n"
"if (left (email, 7) <> \'mailto:\')\n"
"email := concat (\'mailto:\', email);\n"
"}\n"
"return email;\n"
"}\n"
"--src dav_rdf_quad.sql:297\n"
;

static const char *proc391 = 
"#line 320 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (in res_id2 integer, in fullpath varchar)\n"
"{\n"
"declare dav_rdf_graph_uri, new_uri, tags, email varchar;\n"
"declare new_iid any;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"DB.DBA.DAV_RDF_REPLICATE_INT (res_id2, \'R\', fullpath);\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"declare cr_time, mod_time datetime;\n"
"declare len, owner integer;\n"
"select RES_CR_TIME, RES_MOD_TIME, length (RES_CONTENT), RES_OWNER into cr_time, mod_time, len, owner from WS.WS.SYS_DAV_RES where RES_ID = res_id2;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (owner);\n"
"tags := coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = res_id2 and DT_U_ID = http_nobody_uid()));\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', cr_time);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', mod_time);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/extent\', len);\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"if (tags is not null)\n"
"{\n"
"declare tag_list any;\n"
"tag_list := split_and_decode (tags, 0, \'\\0\\0,\');\n"
"foreach (varchar tag in tag_list) do\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#tag\', tag);\n"
"}\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=new_iid where RES_ID = res_id2;\n"
"set triggers on;\n"
"}\n"
"--src dav_rdf_quad.sql:318\n"
;

static const char *proc392 = 
"#line 352 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (in col_id2 integer)\n"
"{\n"
"declare dav_rdf_graph_uri, fullpath, new_uri varchar;\n"
"declare new_iid any;\n"
"fullpath := DAV_SEARCH_PATH (col_id2, \'C\');\n"
"if (DAV_HIDE_ERROR (fullpath) is null)\n"
"return;\n"
"DB.DBA.DAV_RDF_REPLICATE_INT (col_id2, \'C\', fullpath);\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"declare cr_time, mod_time datetime;\n"
"declare owner integer;\n"
"declare email varchar;\n"
"select COL_CR_TIME, COL_MOD_TIME, COL_OWNER into cr_time, mod_time, owner from WS.WS.SYS_DAV_COL where COL_ID = col_id2;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (owner);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', cr_time);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', mod_time);\n"
"\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_IID=new_iid where COL_ID = col_id2;\n"
"set triggers on;\n"
"}\n"
"--src dav_rdf_quad.sql:350\n"
;

static const char *trig27 = 
"#line 380 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_PROP_AFTER_INSERT_PROP after insert on WS.WS.SYS_DAV_PROP referencing new as N\n"
"{\n"
"declare perms varchar;\n"
"if (N.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"whenever not found goto no_op;\n"
"if (N.PROP_TYPE = \'R\')\n"
"{\n"
"declare fullpath varchar;\n"
"select RES_FULL_PATH, RES_PERMS into fullpath, perms from WS.WS.SYS_DAV_RES where RES_ID = N.PROP_PARENT_ID;\n"
"if (perms[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (N.PROP_PARENT_ID, fullpath);\n"
"}\n"
"else if (N.PROP_TYPE = \'C\')\n"
"{\n"
"select COL_PERMS into perms from WS.WS.SYS_DAV_COL where COL_ID = N.PROP_PARENT_ID;\n"
"if (perms[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (N.PROP_PARENT_ID);\n"
"}\n"
"}\n"
"no_op: ;\n"
"}\n"
"--src dav_rdf_quad.sql:378\n";

static const char *trig28 = 
"#line 404 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_PROP_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_PROP referencing old as O\n"
"{\n"
"declare fullpath, perms varchar;\n"
"declare colid integer;\n"
"if (O.PROP_TYPE = \'C\')\n"
"select COL_ID, COL_PERMS into colid, perms from WS.WS.SYS_DAV_COL where COL_ID = O.PROP_PARENT_ID;\n"
"else if (O.PROP_TYPE = \'R\')\n"
"select RES_PERMS, RES_FULL_PATH into perms, fullpath from WS.WS.SYS_DAV_RES where RES_ID = O.PROP_PARENT_ID;\n"
"if (O.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"declare n3_tmp_list, res_vec, dav_rdf_graph_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"n3_tmp_list := xml_tree_doc (deserialize (blob_to_string (O.PROP_VALUE)));\n"
"DB.DBA.DAV_RDF_CBD_DELETE_PROP (n3_tmp_list, fullpath, O.PROP_TYPE, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:402\n";

static const char *trig29 = 
"#line 426 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_PROP_RDF_QUAD_AFTER_UPDATE after update on WS.WS.SYS_DAV_PROP referencing new as N, old as O\n"
"{\n"
"declare fullpath, perms varchar;\n"
"declare colid integer;\n"
"if ((O.PROP_NAME <> \'http://local.virt/DAV-RDF\') and (N.PROP_NAME <> \'http://local.virt/DAV-RDF\'))\n"
"return;\n"
"if ((O.PROP_NAME = N.PROP_NAME) and (blob_to_string (O.PROP_VALUE) = blob_to_string (N.PROP_VALUE)))\n"
"return;\n"
"if (N.PROP_TYPE = \'C\')\n"
"select COL_ID, COL_PERMS into colid, perms from WS.WS.SYS_DAV_COL where COL_ID = O.PROP_PARENT_ID;\n"
"if (N.PROP_TYPE = \'R\')\n"
"select RES_PERMS, RES_FULL_PATH into perms, fullpath from WS.WS.SYS_DAV_RES where RES_ID = O.PROP_PARENT_ID;\n"
"if (perms[6] = 49)\n"
"{\n"
"if (N.PROP_TYPE = \'C\')\n"
"fullpath := DAV_SEARCH_PATH (colid, \'C\');\n"
"if (O.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"declare n3_list, res_vec, dav_rdf_graph_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"n3_list := xml_tree_doc (deserialize (blob_to_string (O.PROP_VALUE)));\n"
"DB.DBA.DAV_RDF_CBD_DELETE_PROP (n3_list, fullpath, O.PROP_TYPE, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"if (N.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"if (N.PROP_TYPE = \'R\')\n"
"{\n"
"if (fullpath is not null)\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (N.PROP_PARENT_ID, fullpath);\n"
"}\n"
"if (N.PROP_TYPE = \'C\')\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (N.PROP_PARENT_ID);\n"
"}\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:424\n";

static const char *trig30 = 
"#line 468 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_TAG_RDF_QUAD_AFTER_INSERT after insert on WS.WS.SYS_DAV_TAG referencing new as NT\n"
"{\n"
"declare tag_list any;\n"
"declare fullpath, dav_rdf_graph_uri, new_uri varchar;\n"
"if (NT.DT_U_ID <> http_nobody_uid())\n"
"return;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"whenever not found goto nf;\n"
"select RES_FULL_PATH into fullpath from WS.WS.SYS_DAV_RES where RES_ID = NT.DT_RES_ID and RES_PERMS[6] = 49;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"tag_list := split_and_decode (NT.DT_TAGS, 0, \'\\0\\0,\');\n"
"foreach (varchar tag in tag_list) do\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#tag\', tag);\n"
"nf: ;\n"
"}\n"
"--src dav_rdf_quad.sql:466\n";

static const char *trig31 = 
"#line 488 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_TAG_RDF_QUAD_AFTER_UPDATE after update on WS.WS.SYS_DAV_TAG referencing new as NT\n"
"{\n"
"declare tag_list, dav_rdf_graph_iid, new_iid, p_iid any;\n"
"declare fullpath, dav_rdf_graph_uri, new_uri varchar;\n"
"if (NT.DT_U_ID <> http_nobody_uid())\n"
"return;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"whenever not found goto nf;\n"
"select RES_FULL_PATH into fullpath from WS.WS.SYS_DAV_RES where RES_ID = NT.DT_RES_ID and RES_PERMS[6] = 49;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#tag\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"tag_list := split_and_decode (NT.DT_TAGS, 0, \'\\0\\0,\');\n"
"foreach (varchar tag in tag_list) do\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#tag\', tag);\n"
"nf: ;\n"
"}\n"
"--src dav_rdf_quad.sql:486\n";

static const char *trig32 = 
"#line 512 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_TAG_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_TAG referencing old as OT\n"
"{\n"
"declare tag_list, dav_rdf_graph_iid, old_iid, p_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"if (OT.DT_U_ID <> http_nobody_uid())\n"
"return;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"whenever not found goto nf;\n"
"select RES_IID into old_iid from WS.WS.SYS_DAV_RES where RES_ID = OT.DT_RES_ID and RES_IID is not null;\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#tag\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = old_iid;\n"
"nf: ;\n"
"}\n"
"--src dav_rdf_quad.sql:510\n";

static const char *trig33 = 
"#line 531 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_RES_RDF_QUAD_AFTER_INSERT after insert on WS.WS.SYS_DAV_RES order 30 referencing new as N\n"
"{\n"
"if (N.RES_PERMS[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (N.RES_ID, N.RES_FULL_PATH);\n"
"}\n"
"--src dav_rdf_quad.sql:529\n";

static const char *trig34 = 
"#line 538 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_RES_RDF_QUAD_AFTER_UPDATE after update (RES_COL, RES_NAME, RES_FULL_PATH, RES_PERMS, RES_OWNER, RES_CONTENT, RES_CR_TIME, RES_MOD_TIME) on WS.WS.SYS_DAV_RES order 30 referencing new as NC, old as OC\n"
"{\n"
"declare new_iid, dav_rdf_graph_iid, p_iid any;\n"
"declare new_uri, dav_rdf_graph_uri varchar;\n"
"\n"
"\n"
"if (OC.RES_PERMS[6] = 49 or NC.RES_PERMS[6] = 49)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"}\n"
"else\n"
"return;\n"
"if (NC.RES_PERMS[6] = 49)\n"
"{\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, NC.RES_FULL_PATH);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"}\n"
"else\n"
"new_uri := new_iid := null;\n"
"if (OC.RES_IID is null)\n"
"{\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (NC.RES_ID, NC.RES_FULL_PATH);\n"
"return;\n"
"}\n"
"if (new_iid is null)\n"
"{\n"
"declare spo any;\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.RES_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=null where RES_ID=NC.RES_ID;\n"
"set triggers on;\n"
"return;\n"
"}\n"
"if (OC.RES_IID <> new_iid)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and ((isiri_id (O) and O=new_iid) or S=new_iid);\n"
"update DB.DBA.RDF_QUAD set S=new_iid where G=dav_rdf_graph_iid and S=OC.RES_IID;\n"
"update DB.DBA.RDF_QUAD set O=new_iid where G=dav_rdf_graph_iid and isiri_id (O) and O=OC.RES_IID;\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=new_iid where RES_ID=NC.RES_ID;\n"
"set triggers on;\n"
"}\n"
"if (OC.RES_OWNER <> NC.RES_OWNER)\n"
"{\n"
"declare email varchar;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (NC.RES_OWNER);\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#ownerUser\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"}\n"
"if (length (OC.RES_CONTENT) <> length (NC.RES_CONTENT))\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/extent\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/extent\', length (NC.RES_CONTENT));\n"
"}\n"
"if (OC.RES_CR_TIME <> NC.RES_CR_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/created\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', NC.RES_CR_TIME);\n"
"}\n"
"if (OC.RES_MOD_TIME <> NC.RES_MOD_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/modified\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', NC.RES_MOD_TIME);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:536\n";

static const char *trig35 = 
"#line 614 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_RES_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_RES order 30 referencing old as OC\n"
"{\n"
"declare spo, dav_rdf_graph_uri, dav_rdf_graph_iid any;\n"
"if (OC.RES_IID is not null)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.RES_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:612\n";

static const char *trig36 = 
"#line 630 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_COL_RDF_QUAD_AFTER_CREATE after insert on WS.WS.SYS_DAV_COL order 30 referencing new as NC\n"
"{\n"
"if (NC.COL_PERMS[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (NC.COL_ID);\n"
"}\n"
"--src dav_rdf_quad.sql:628\n";

static const char *proc393 = 
"#line 638 \"[executable]/dav_rdf_quad.sql\"\n"
"create procedure DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (\n"
"in dav_rdf_graph_uri varchar, in dav_rdf_graph_iid IRI_ID,\n"
"in colid integer, in colispublic integer,\n"
"in coluri varchar, in coliid IRI_ID, in old_coliid IRI_ID )\n"
"{\n"
"if (colispublic)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and ((isiri_id (O) and O=coliid) or S=coliid);\n"
"update DB.DBA.RDF_QUAD set S=coliid where G=dav_rdf_graph_iid and S=old_coliid;\n"
"update DB.DBA.RDF_QUAD set O=coliid where G=dav_rdf_graph_iid and isiri_id (O) and O=old_coliid;\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_IID=coliid where COL_ID=colid;\n"
"set triggers on;\n"
"}\n"
"for (select sub.COL_ID as subid, sub.COL_NAME as subname, sub.COL_PERMS as subperms, sub.COL_IID as old_subiid\n"
"from WS.WS.SYS_DAV_COL as sub where sub.COL_PARENT = colid ) do\n"
"{\n"
"declare subispublic integer;\n"
"declare suburi_ses, subiid any;\n"
"suburi_ses := string_output ();\n"
"http (coluri, suburi_ses);\n"
"http_escape (subname, 7, suburi_ses, 0, 1);\n"
"http (\'/\', suburi_ses);\n"
"suburi_ses := string_output_string (suburi_ses);\n"
"if (subperms[6] = 49)\n"
"{\n"
"subispublic := 1;\n"
"subiid := DB.DBA.RDF_MAKE_IID_OF_QNAME (suburi_ses);\n"
"}\n"
"else\n"
"{\n"
"subispublic := 0;\n"
"subiid := NULL;\n"
"}\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (\n"
"dav_rdf_graph_uri, dav_rdf_graph_iid,\n"
"subid, subispublic,\n"
"suburi_ses, subiid, old_subiid );\n"
"}\n"
"for (select res.RES_ID as resid, res.RES_IID as old_resiid, res.RES_FULL_PATH as resfullpath\n"
"from WS.WS.SYS_DAV_RES as res where res.RES_COL = colid and res.RES_IID is not null) do\n"
"{\n"
"declare new_uri varchar;\n"
"declare new_iid IRI_ID;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, resfullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"if (old_resiid <> new_iid)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and ((isiri_id (O) and O=new_iid) or S=new_iid);\n"
"update DB.DBA.RDF_QUAD set S=new_iid where G=dav_rdf_graph_iid and S=old_resiid;\n"
"update DB.DBA.RDF_QUAD set O=new_iid where G=dav_rdf_graph_iid and isiri_id (O) and O=old_resiid;\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=new_iid where RES_ID=resid;\n"
"set triggers on;\n"
"}\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:636\n"
;

static const char *trig37 = 
"#line 698 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_COL_RDF_QUAD_AFTER_UPDATE after update (COL_NAME, COL_PARENT, COL_PERMS, COL_OWNER, COL_CR_TIME, COL_MOD_TIME) on WS.WS.SYS_DAV_COL order 30 referencing new as NC, old as OC\n"
"{\n"
"declare new_iid, dav_rdf_graph_iid, p_iid any;\n"
"declare new_uri, dav_rdf_graph_uri varchar;\n"
"declare path_change integer;\n"
"if ((OC.COL_NAME <> NC.COL_NAME) or (OC.COL_PARENT <> NC.COL_PARENT))\n"
"path_change := 1;\n"
"else\n"
"path_change := 0;\n"
"if (OC.COL_PERMS[6] = 49 or NC.COL_PERMS[6] = 49 or path_change)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"}\n"
"else\n"
"return;\n"
"if (NC.COL_PERMS[6] = 49 or path_change)\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_SEARCH_PATH (NC.COL_ID, \'C\');\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, new_full_path);\n"
"if (NC.COL_PERMS[6] = 49)\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"else\n"
"new_iid := null;\n"
"}\n"
"else\n"
"new_uri := new_iid := null;\n"
"if (OC.COL_IID is null)\n"
"{\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (NC.COL_ID);\n"
"if (path_change)\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (dav_rdf_graph_uri, dav_rdf_graph_iid, NC.COL_ID, 0, new_uri, new_iid, null);\n"
"return;\n"
"}\n"
"if (new_iid is null)\n"
"{\n"
"declare spo any;\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.COL_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_IID=null where COL_ID=OC.COL_ID;\n"
"set triggers on;\n"
"if (path_change)\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (dav_rdf_graph_uri, dav_rdf_graph_iid, NC.COL_ID, 0, new_uri, new_iid, null);\n"
"return;\n"
"}\n"
"if (path_change)\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (dav_rdf_graph_uri, dav_rdf_graph_iid, NC.COL_ID, 1, new_uri, new_iid, OC.COL_IID);\n"
"if (OC.COL_OWNER <> NC.COL_OWNER)\n"
"{\n"
"declare email varchar;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (NC.COL_OWNER);\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#ownerUser\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"}\n"
"if (OC.COL_CR_TIME <> NC.COL_CR_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/created\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', NC.COL_CR_TIME);\n"
"}\n"
"if (OC.COL_MOD_TIME <> NC.COL_MOD_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/modified\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', NC.COL_MOD_TIME);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:696\n";

static const char *trig38 = 
"#line 773 \"[executable]/dav_rdf_quad.sql\"\n"
"create trigger SYS_DAV_COL_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_COL order 30 referencing old as OC\n"
"{\n"
"declare spo, dav_rdf_graph_uri, dav_rdf_graph_iid any;\n"
"if (OC.COL_PERMS[6] = 49)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.COL_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:771\n";

/* vfs.sql */

static const char *proc394 = 
"#line 31 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.COPY_PAGE (\n"
"in _host varchar,\n"
"in _urls any,\n"
"in _root varchar,\n"
"in _upd integer,\n"
"in _dbg integer)\n"
"{\n"
"\n"
"declare exit handler for sqlstate \'*\', not found\n"
"{\n"
"rollback work;\n"
"__SQL_STATE := cast (__SQL_STATE as varchar);\n"
"if (__SQL_STATE <> \'40001\')\n"
"{\n"
"update WS.WS.VFS_QUEUE\n"
"set VQ_STAT = \'error\',\n"
"VQ_ERROR = __SQL_MESSAGE\n"
"where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL in (_urls);\n"
"commit work;\n"
"WS.WS.ERR_MAIL_SEND (_host, _urls, _root, __SQL_STATE, __SQL_MESSAGE);\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.VFS_QUEUE\n"
"set VQ_STAT = \'waiting\'\n"
"where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL in (_urls);\n"
"commit work;\n"
"}\n"
"if (__SQL_STATE <> \'40001\' and __SQL_STATE <> \'2E000\' and __SQL_STATE not like \'0800_\' and __SQL_STATE <> \'HTCLI\')\n"
"resignal;\n"
"\n"
"return null;\n"
"};\n"
"\n"
"return WS.WS.COPY_PAGE_1 (_host, _urls, _root, _upd, _dbg);\n"
"}\n"
"--src vfs.sql:29\n"
;

static const char *proc395 = 
"#line 69 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_HTTP_RESP_CODE (\n"
"inout _resp any)\n"
"{\n"
"\n"
"declare _tmp varchar;\n"
"\n"
"_tmp := WS.WS.FIND_KEYWORD (_resp, \'HTTP/1.\');\n"
"_tmp := subseq (_tmp, strchr (_tmp, \' \') + 1, length (_tmp));\n"
"_tmp := subseq (_tmp, 0, strchr (_tmp, \' \'));\n"
"return _tmp;\n"
"}\n"
"--src vfs.sql:67\n"
;

static const char *proc396 = 
"#line 82 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_GUESS_CONTENT_TYPE (\n"
"in ret_content_type varchar,\n"
"inout ret_body any)\n"
"{\n"
"declare ret_begin, ret_html any;\n"
"\n"
"ret_begin := subseq (ret_body, 0, 4096);\n"
"if (isstring_session (ret_begin))\n"
"ret_begin := string_output_string (ret_begin);\n"
"\n"
"ret_html := xtree_doc (ret_begin, 2);\n"
"if (xpath_eval (\'/sitemapindex|/urlset\', ret_html) is not null)\n"
"return \'text/xml\';\n"
"\n"
"return ret_content_type;\n"
"}\n"
"--src vfs.sql:80\n"
;

static const char *proc397 = 
"#line 100 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.COPY_PAGE_1 (\n"
"in _host varchar,\n"
"in _urls any,\n"
"in _root varchar,\n"
"in _upd integer,\n"
"in _dbg integer)\n"
"{\n"
"\n"
"declare _header, _etag, _http_resp_code, _start_url varchar;\n"
"declare _del, _desc, _t_urls, _opts, _c_type varchar;\n"
"declare _dav_method, _d_imgs, _opage varchar;\n"
"declare _dav_enabled, _other, ua, cust_headers varchar;\n"
"declare dt, redir_flag, store_flag, try_to_get_rdf integer;\n"
"declare _since datetime;\n"
"declare _udata, ext_hook, store_hook, _header_arr, _resps, xp_exp any;\n"
"declare n_urls, conv_html, is_sitemap, accept_rdf, time_out integer;\n"
"\n"
"conv_html := 1;\n"
"time_out := null;\n"
"n_urls := position (0, _urls) - 1;\n"
"if (n_urls < 0)\n"
"n_urls := length (_urls);\n"
"\n"
"whenever not found goto nf_opt;\n"
"select VS_NEWER, VS_OPTIONS, coalesce (VS_METHOD, \'\'), VS_URL, VS_SRC, coalesce (VS_OPAGE, \'\'),\n"
"coalesce (VS_REDIRECT, 1), coalesce (VS_STORE, 1), coalesce (VS_DLOAD_META, 0),\n"
"deserialize (VS_UDATA), VS_EXTRACT_FN, VS_STORE_FN, coalesce (VS_DEL, \'\'), coalesce (VS_OTHER, \'\'),\n"
"VS_CONVERT_HTML, VS_IS_SITEMAP, VS_XPATH, VS_ACCEPT_RDF, VS_TIMEOUT, VS_HEADERS\n"
"into _since, _opts, _dav_method, _start_url, _d_imgs, _opage,\n"
"redir_flag, store_flag, try_to_get_rdf,\n"
"_udata, ext_hook, store_hook, _del, _other,\n"
"conv_html, is_sitemap, xp_exp, accept_rdf, time_out, cust_headers\n"
"from WS.WS.VFS_SITE\n"
"where VS_HOST = _host and VS_ROOT = _root;\n"
"\n"
"nf_opt:\n"
"if (length (cust_headers) > 2)\n"
"cust_headers := rtrim (cust_headers, \' \\r\\n\') || \'\\r\\n\';\n"
"else\n"
"cust_headers := null;\n"
"\n"
"_header := coalesce (cust_headers, \'\');\n"
"if (isstring (_opts) and strchr (_opts, \':\') is not null)\n"
"_header := sprintf (\'Authorization: Basic %s\\r\\n\', encode_base64(_opts));\n"
"\n"
"if (accept_rdf and strstr (_header, \'Accept:\') is null)\n"
"_header := _header || \'Accept: application/rdf+xml, text/n3, text/rdf+n3, */*;q=0.1\\r\\n\';\n"
"\n"
"ua := registry_get (\'vfs_ua\');\n"
"if (isstring (ua) and length (ua) and strstr (_header, \'User-Agent:\') is null)\n"
"{\n"
"ua := trim (ua, \' \\r\\n\');\n"
"_header := _header || \'User-Agent: \' || ua || \'\\r\\n\';\n"
"}\n"
"\n"
"if (_upd = 1)\n"
"{\n"
"_header_arr := make_array (n_urls, \'any\');\n"
"for (declare i integer, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"declare _url, _hdr varchar;\n"
"declare _dt datetime;\n"
"\n"
"_url := _urls[i];\n"
"\n"
"\n"
"_etag := null;\n"
"_dt := _since;\n"
"for select VU_ETAG, VU_CPTIME from WS.WS.VFS_URL where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root do\n"
"{\n"
"_etag := VU_ETAG;\n"
"_dt := VU_CPTIME;\n"
"}\n"
"if (_etag is not null and isstring (_etag) and length (_etag))\n"
"_hdr := concat (_header,\'If-None-Match: \', _etag, \'\\r\\n\');\n"
"else\n"
"_hdr := _header;\n"
"\n"
"\n"
"if (_upd = 1 and _dt is not null)\n"
"_hdr := concat (_hdr, \'If-Modified-Since: \', soap_print_box (_dt, \'\', 1), \'\\r\\n\');\n"
"_header_arr[i] := _hdr;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_header_arr := _header;\n"
"}\n"
"\n"
"commit work;\n"
"\n"
"if (_dav_method = \'checked\' and _upd = 0 and _opage <> \'checked\')\n"
"{\n"
"declare dav_urls, _dav_opts, _url any;\n"
"declare lev integer;\n"
"\n"
"if (length (_urls) <> 1)\n"
"signal (\'22023\', \'When using WebDAV methods batch size cannot be greater than 1\', \'CRAWL\');\n"
"\n"
"_url := _urls[0];\n"
"dt := msec_time ();\n"
"http_get (WS.WS.MAKE_URL (_host, _url), _dav_opts, \'OPTIONS\');\n"
"prof_sample (\'web robot GET\', msec_time () - dt, 1);\n"
"_dav_enabled := http_request_header (_dav_opts, \'DAV\', null, null);\n"
"if (0 = length (_dav_enabled))\n"
"{\n"
"update WS.WS.VFS_SITE set VS_METHOD = null where VS_HOST = _host and VS_ROOT = _root;\n"
"_dav_method := null;\n"
"goto html_mode;\n"
"}\n"
"dav_urls := WS.WS.DAV_PROP (WS.WS.MAKE_URL (_host, _url), _d_imgs, _header);\n"
"lev := coalesce ((select VQ_LEVEL from WS.WS.VFS_QUEUE where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = _url), 0);\n"
"WS.WS.GET_URLS (_host, _url, _root, dav_urls, lev + 1, null);\n"
"}\n"
"\n"
"html_mode:\n"
"_t_urls := make_array (n_urls, \'any\');\n"
"for (declare i integer, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"_t_urls[i] := WS.WS.MAKE_URL (_host, _urls[i]);\n"
"}\n"
"\n"
"dt := msec_time ();\n"
"{\n"
"declare retr integer;\n"
"\n"
"retr := 4;\n"
"declare exit handler for sqlstate \'2E000\' {\n"
"if (retr <= 0)\n"
"resignal;\n"
"else\n"
"goto get_again;\n"
"};\n"
"declare exit handler for sqlstate \'0800*\'\n"
"{\n"
"if (retr <= 0)\n"
"resignal;\n"
"else\n"
"goto get_again;\n"
"};\n"
"declare exit handler for sqlstate \'HTCLI\'\n"
"{\n"
"if (retr <= 0)\n"
"resignal;\n"
"else\n"
"goto get_again;\n"
"};\n"
"\n"
"get_again:\n"
"retr := retr - 1;\n"
"if (n_urls = 1)\n"
"{\n"
"declare _resp, _content any;\n"
"\n"
"_content := http_get (_t_urls[0], _resp, \'GET\', case when _upd = 1 then _header_arr[0] else _header_arr end, null, null, redir_flag, time_out);\n"
"\n"
"if (isarray(_resp) and length (_resp) and not isstring (_resp [0]))\n"
"{\n"
"if (retr <= 0)\n"
"signal (\'2E000\', \'Bad header received\');\n"
"else\n"
"goto get_again;\n"
"}\n"
"_resps := vector (vector (_content, _resp));\n"
"}\n"
"else\n"
"_resps := http_pipeline (_t_urls, \'GET\', _header_arr);\n"
"}\n"
"prof_sample (\'web robot GET\', msec_time () - dt, 1);\n"
"if (length (_resps) <> n_urls)\n"
"signal (\'2E000\', \'Different length of requests and responces\');\n"
"\n"
"for (declare i integer, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"declare _url varchar;\n"
"declare _resp, _content any;\n"
"declare lev integer;\n"
"\n"
"_url := _urls[i];\n"
"_resp := _resps[i][1];\n"
"_content := _resps[i][0];\n"
"lev := coalesce ((select VQ_LEVEL from WS.WS.VFS_QUEUE where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = _url), 0);\n"
"commit work;\n"
"if (isarray(_resp) and length (_resp) and not isstring (_resp [0]))\n"
"{\n"
"signal (\'2E000\', \'Bad header received\');\n"
"}\n"
"\n"
"_http_resp_code := WS.WS.VFS_HTTP_RESP_CODE (_resp);\n"
"if (redir_flag and _http_resp_code in (\'301\', \'302\', \'303\'))\n"
"{\n"
"declare new_loc, new_url, new_host varchar;\n"
"declare ht any;\n"
"new_loc :=  http_request_header (_resp, \'Location\', null, null);\n"
"new_loc := WS.WS.EXPAND_URL (_t_urls[i], new_loc);\n"
"ht := WS.WS.PARSE_URI (new_loc);\n"
"new_host := ht[1];\n"
"ht[0] := \'\';\n"
"ht[1] := \'\';\n"
"new_url := VFS_URI_COMPOSE (ht);\n"
"if (_host <> new_host)\n"
"new_url := new_loc;\n"
"\n"
"insert soft WS.WS.VFS_QUEUE (VQ_HOST, VQ_ROOT, VQ_URL, VQ_STAT, VQ_TS, VQ_LEVEL)\n"
"values (_host, _root, new_url, \'waiting\', now (), lev + 1);\n"
"\n"
"goto end_crawl;\n"
"}\n"
"\n"
"if (_http_resp_code = \'200\' and (isstring (_content) or __tag (_content) = 185))\n"
"{\n"
"_c_type := http_request_header (_resp, \'Content-Type\', null, \'\');\n"
"_c_type := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (_url, _c_type, _content);\n"
"_c_type := WS.WS.VFS_GUESS_CONTENT_TYPE (_c_type, _content);\n"
"_etag := http_request_header (_resp, \'ETag\', null, \'\');\n"
"\n"
"if (ext_hook is not null and __proc_exists (ext_hook))\n"
"{\n"
"call (ext_hook) (_host, _url, _root, _content, _c_type, lev + 1);\n"
"}\n"
"else if ((_url like \'%.htm%\' or _url like \'%/\' or _c_type like \'text/html%\' or _c_type like \'application/%xml\' or _c_type = \'text/xml\' or _url like \'%.xml\' or _url like \'%.xml.gz\')\n"
"and _dav_method <> \'checked\' and _opage <> \'checked\')\n"
"{\n"
"WS.WS.GET_URLS (_host, _url, _root, _content, lev + 1, _c_type);\n"
"}\n"
"if (store_hook is not null and __proc_exists (store_hook))\n"
"{\n"
"call (store_hook) (_host, _url, _root, _content, _etag, _c_type, store_flag, vector_concat (_udata, vector (\'start_url\', _start_url)), lev + 1);\n"
"}\n"
"else\n"
"{\n"
"WS.WS.LOCAL_STORE (_host, _url, _root, _content, _etag, _c_type, store_flag, conv_html);\n"
"if (try_to_get_rdf)\n"
"WS.WS.VFS_EXTRACT_RDF (_host, _root, _start_url, _udata, _url, _content, _c_type, _header, _resp, lev + 1);\n"
"}\n"
"}\n"
"else if (_http_resp_code = \'401\')\n"
"{\n"
"signal (\'22023\', \'This site requires authentication credentials which are not supplied or incorrect.\');\n"
"}\n"
"else if (_http_resp_code = \'404\' and _upd = 1 and _del = \'checked\')\n"
"{\n"
"\n"
"WS.WS.DELETE_LOCAL_COPY (_host, _url, _root);\n"
"}\n"
"end_crawl:\n"
"if (_http_resp_code like \'2__\' or _http_resp_code like \'3__\' or _http_resp_code like \'4__\' or _http_resp_code like \'5__\')\n"
"update WS.WS.VFS_QUEUE\n"
"set VQ_STAT = \'retrieved\'\n"
"where VQ_HOST = _host and VQ_URL = _url and VQ_ROOT = _root and VQ_STAT = \'pending\';\n"
"}\n"
"commit work;\n"
"return;\n"
"}\n"
"--src vfs.sql:98\n"
;

static const char *proc398 = 
"#line 356 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.DELETE_LOCAL_COPY (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar)\n"
"{\n"
"delete from WS.WS.VFS_URL where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"delete from WS.WS.SYS_DAV_RES where RES_FULL_PATH = concat (\'/DAV/\', _root, _url);\n"
"}\n"
"--src vfs.sql:354\n"
;

static const char *proc399 = 
"#line 366 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_RUN (\n"
"in url varchar,\n"
"in threads int := null,\n"
"in batch_size int := 1,\n"
"in fn varchar := null,\n"
"in dta any := null)\n"
"{\n"
"declare h, host, s_url, root_collection  any;\n"
"\n"
"h := rfc1808_parse_uri (url);\n"
"host := h[1];\n"
"s_url := h[2];\n"
"root_collection := (select top 1 VS_ROOT from WS.WS.VFS_SITE where VS_HOST = host and VS_URL = s_url);\n"
"WS.WS.SERV_QUEUE_TOP (host, root_collection, 0, 0, fn, dta, threads, batch_size);\n"
"}\n"
"--src vfs.sql:364\n"
;

static const char *proc400 = 
"#line 383 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_STATUS_GET (\n"
"in _tgt varchar,\n"
"in _root varchar)\n"
"{\n"
"declare rc any;\n"
"\n"
"rc := registry_get (sprintf (\'__VFS_%s_%s\', _tgt, _root));\n"
"return case when (not isstring (rc)) then \'not started\' else rc end;\n"
"}\n"
"--src vfs.sql:381\n"
;

static const char *proc401 = 
"#line 394 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_STATUS_SET (\n"
"in _tgt varchar,\n"
"in _root varchar,\n"
"in _stat varchar)\n"
"{\n"
"return registry_set (sprintf (\'__VFS_%s_%s\', _tgt, _root), _stat);\n"
"}\n"
"--src vfs.sql:392\n"
;

static const char *proc402 = 
"#line 404 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SERV_QUEUE_TOP (\n"
"in _tgt varchar,\n"
"in _root varchar,\n"
"in _upd integer,\n"
"in _dbg integer,\n"
"in _fn varchar,\n"
"in _clnt_data any,\n"
"in threads int := null,\n"
"in batch_size int := 1)\n"
"{\n"
"\n"
"declare _msg, _stat, oq varchar;\n"
"\n"
"set_user_id (\'dba\');\n"
"\n"
"do_again:\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"WS.WS.VFS_STATUS_SET (_tgt, _root, \'running\');\n"
"commit work;\n"
"\n"
"exec (\'WS.WS.SERV_QUEUE (?, ?, ?, ?, ?, ?, ?, ?)\', _stat, _msg, vector (_tgt, _root, _upd, _dbg, _fn, _clnt_data, threads, batch_size));\n"
"if (_stat = \'40001\')\n"
"{\n"
"rollback work;\n"
"goto do_again;\n"
"}\n"
"\n"
"if (_stat <> \'00000\')\n"
"{\n"
"WS.WS.VFS_STATUS_SET (_tgt, _root, \'error\');\n"
"signal (_stat, _msg);\n"
"}\n"
"commit work;\n"
"\n"
"if (WS.WS.VFS_STATUS_GET (_tgt, _root) = \'running\' and not exists (select 1 from WS.WS.VFS_QUEUE where VQ_STAT = \'waiting\' and VQ_HOST = _tgt and VQ_ROOT = _root))\n"
"WS.WS.VFS_STATUS_SET (_tgt, _root, \'done\');\n"
"}\n"
"--src vfs.sql:402\n"
;

static const char *proc403 = 
"#line 453 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SERV_QUEUE (\n"
"in _tgt varchar,\n"
"in _root varchar,\n"
"in _upd integer,\n"
"in _dbg integer,\n"
"in _fn varchar,\n"
"in _clnt_data any,\n"
"in nthreads int := null,\n"
"in batch_size int := 1)\n"
"{\n"
"\n"
"declare _total, active_thread integer;\n"
"declare _rc integer;\n"
"declare _tgt_url varchar;\n"
"declare url_fn varchar;\n"
"declare _last_shut integer;\n"
"declare _next_url varchar;\n"
"declare _dav_method varchar;\n"
"declare aq_list, aq, url_batch any;\n"
"declare err any;\n"
"declare pid, thr_conf, care_bot integer;\n"
"declare delay_sec float;\n"
"\n"
"_total := 0;\n"
"registry_set (\'WEB_COPY\', \'X __sequence_set (\'\'WEB_COPY_SSHUT\'\', datediff (\'\'second\'\', stringdate (\'\'1980-01-01\'\'), now ()), 0)\');\n"
"\n"
"\n"
"\n"
"\n"
"WS.WS.VFS_RECOVER_QUEUE_STAT (_tgt, _root);\n"
"commit work;\n"
"\n"
"whenever not found goto n_site;\n"
"select VS_URL, VS_METHOD, VS_THREADS, VS_BOT, VS_DELAY\n"
"into _tgt_url, _dav_method, thr_conf, care_bot, delay_sec\n"
"from WS.WS.VFS_SITE\n"
"where VS_HOST = _tgt and VS_ROOT = _root with (exclusive);\n"
"if (care_bot)\n"
"VFS_ROBOTS_GET (_tgt, _root, delay_sec);\n"
"\n"
"if (thr_conf is not null and thr_conf > 0)\n"
"nthreads := thr_conf;\n"
"\n"
"if (nthreads is null or nthreads < 0)\n"
"nthreads := 1;\n"
"\n"
"commit work;\n"
"\n"
"if (_upd = 1)\n"
"{\n"
"if (not exists (select 1 from WS.WS.VFS_QUEUE where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_URL <> _tgt_url))\n"
"{\n"
"for select VU_URL from WS.WS.VFS_URL where VU_HOST = _tgt and VU_ROOT = _root and VU_URL <> _tgt_url do\n"
"{\n"
"insert into WS.WS.VFS_QUEUE (VQ_HOST, VQ_ROOT, VQ_URL, VQ_STAT, VQ_TS)\n"
"values (_tgt, _root, VU_URL, \'waiting\', now ());\n"
"}\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_URL = _tgt_url;\n"
"}\n"
"else if (not exists (select 1 from WS.WS.VFS_QUEUE where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_STAT = \'waiting\'))\n"
"{\n"
"\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_VIA_SITEMAP = 0;\n"
"}\n"
"commit work;\n"
"}\n"
"if (_dav_method = \'checked\')\n"
"batch_size := 1;\n"
"\n"
"\n"
"if (WS.WS.ISEMPTY (_fn))\n"
"url_fn := \'WS.WS.URL_BY_DATE\';\n"
"else\n"
"url_fn := _fn;\n"
"\n"
"aq_list := make_array (nthreads, \'any\');\n"
"for (declare i integer, i := 0; i < nthreads; i := i + 1)\n"
"aq_list [i] := \'n\';\n"
"\n"
"url_batch := make_array (batch_size, \'any\');\n"
"aq := async_queue (nthreads);\n"
"active_thread := 0;\n"
"\n"
"while (1)\n"
"{\n"
"declare found_one, ndone integer;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"__SQL_STATE := cast (__SQL_STATE as varchar);\n"
"WS.WS.ERR_MAIL_SEND (_tgt, vector (), _root, __SQL_STATE, __SQL_MESSAGE);\n"
"rollback work;\n"
"if (__SQL_STATE = \'40001\')\n"
"{\n"
"resignal;\n"
"}\n"
"goto fn_end;\n"
"};\n"
"found_one := 0;\n"
"ndone := 0;\n"
"if (WS.WS.VFS_STATUS_GET (_tgt, _root) = \'stopped\')\n"
"goto fn_end;\n"
"\n"
"commit work;\n"
"if (delay_sec > 0)\n"
"delay (delay_sec);\n"
"\n"
"for (declare i integer, i := 0; i < batch_size; i := i + 1)\n"
"{\n"
"_rc := call (url_fn) (_tgt, _root, _next_url, _clnt_data);\n"
"if (_rc > 0 and isstring (_next_url))\n"
"{\n"
"found_one := 1;\n"
"url_batch [i] := _next_url;\n"
"ndone := ndone + 1;\n"
"}\n"
"else\n"
"{\n"
"url_batch [i] := 0;\n"
"}\n"
"}\n"
"commit work;\n"
"if (0 = found_one)\n"
"goto fn_end;\n"
"\n"
"active_thread := position (\'n\', aq_list) - 1;\n"
"if (active_thread < 0)\n"
"{\n"
"pid := null;\n"
"for (declare i integer, i := 0; i < nthreads; i := i + 1)\n"
"{\n"
"if (pid is null or pid > aq_list[i])\n"
"{\n"
"pid := aq_list[i];\n"
"active_thread := i;\n"
"}\n"
"}\n"
"commit work;\n"
"aq_wait (aq, pid, 1, err);\n"
"}\n"
"if (active_thread < 0)\n"
"signal (\'42000\', \'Cannot get free thread\', \'CRAWL\');\n"
"\n"
"aq_list [active_thread] := aq_request (aq, \'WS.WS.COPY_PAGE\', vector (_tgt, url_batch, _root, _upd, _dbg));\n"
"if (ndone < batch_size or not exists (select 1 from WS.WS.VFS_QUEUE where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_STAT = \'waiting\'))\n"
"{\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"aq_list [active_thread] := \'n\';\n"
"}\n"
"_total := _total + ndone;\n"
"}\n"
"fn_end:;\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"\n"
"\n"
"if (_dbg = 3)\n"
"http (concat (\'<strong>Total links visited: \', cast (_total as varchar), \'</strong>\\n\'));\n"
"\n"
"n_site:;\n"
"return _total;\n"
"}\n"
"--src vfs.sql:451\n"
;

static const char *proc404 = 
"#line 617 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.ERR_MAIL_SEND (\n"
"in _tgt varchar,\n"
"in _urls varchar,\n"
"in _root varchar,\n"
"in _stat varchar,\n"
"in _msg varchar)\n"
"{\n"
"declare n_urls integer;\n"
"declare msg varchar;\n"
"\n"
"n_urls := position (0, _urls) - 1;\n"
"if (n_urls < 0)\n"
"n_urls := length (_urls);\n"
"\n"
"msg :=  sprintf (\n"
"\'Subject: Error importing http://%s\\r\\n\\r\\n\'||\n"
"\'(This is automatically generated message from Web Crawler)\\r\\n\'||\n"
"\'Code: %s Message: %s\\r\\n.\\r\\n\' ||\n"
"\'The following URL can\'\'t be imported:\\r\\n\', _tgt, _stat, _msg);\n"
"for (declare i integer, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"msg := msg || sprintf (\'http://%s%s -> %s\\r\\n\', _tgt, _urls[i], _root);\n"
"}\n"
"DB.DBA.NEW_MAIL (\'dav\', msg);\n"
"}\n"
"--src vfs.sql:615\n"
;

static const char *proc405 = 
"#line 644 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.LOCAL_STORE (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"inout _content varchar,\n"
"in _s_etag varchar,\n"
"in _c_type varchar,\n"
"in store_flag int := 1,\n"
"in conv_html int := 1)\n"
"{\n"
"declare _name, _perms, _etag, _idx, _type, _e_etag, _sl, _opage, _path_str varchar;\n"
"declare _own, _col_id, _grp, _res_id integer;\n"
"declare _path any;\n"
"\n"
"if (not store_flag)\n"
"{\n"
"insert soft WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"if (row_count () = 0)\n"
"{\n"
"update WS.WS.VFS_URL\n"
"set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag\n"
"where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"}\n"
"return 0;\n"
"}\n"
"\n"
"whenever not found goto err_end;\n"
"select VS_OWN, VS_INX, VS_OPAGE\n"
"into _own, _idx, _opage\n"
"from WS.WS.VFS_SITE\n"
"where VS_HOST = _host and VS_ROOT = _root;\n"
"if (isstring (_root) and length (_root) > 0 and aref(_root, 0) = ascii (\'/\'))\n"
"_sl := \'\';\n"
"else\n"
"_sl := \'/\';\n"
"_path_str := _url;\n"
"if (_path_str like \'%/\')\n"
"_path_str := _path_str || \'index.html\';\n"
"if (_path_str like \'http://%\')\n"
"_path_str := subseq (_path_str, 5);\n"
"_path_str := _sl || _root || _path_str;\n"
"_path := WS.WS.HREF_TO_ARRAY (_path_str, \'\');\n"
"_path := WS.WS.FIXPATH (_path);\n"
"if (_own is not null and _own > 0)\n"
"{\n"
"whenever not found goto default_s;\n"
"select U_GROUP, U_DEF_PERMS into _grp, _perms from WS.WS.SYS_DAV_USER where U_ID = _own;\n"
"}\n"
"else\n"
"{\n"
"default_s:\n"
"_own := 0;\n"
"_perms := \'110110110\';\n"
"_grp := 0;\n"
"}\n"
"\n"
"if (_opage = \'checked\')\n"
"_path := WS.WS.HREF_TO_ARRAY (_root, \'\');\n"
"\n"
"_col_id := WS.WS.MKPATH (WS.WS.PARENT_PATH (_path), _own, _grp, _perms);\n"
"if (_col_id is not null and _col_id > 1)\n"
"{\n"
"_name := aref (_path, length (_path) - 1);\n"
"if (_c_type is null or _c_type = \'\')\n"
"_type := http_mime_type (_name);\n"
"else\n"
"_type := _c_type;\n"
"whenever not found goto not_res;\n"
"select RES_ID into _res_id from WS.WS.SYS_DAV_RES where RES_NAME = _name and RES_COL = _col_id;\n"
"not_res:\n"
"if (_res_id is null or _res_id = 0)\n"
"{\n"
"_res_id := GETID (\'R\');\n"
"if (__tag (_content) = 185)\n"
"{\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_CONTENT, RES_TYPE, RES_PERMS, RES_OWNER, RES_GROUP, RES_CR_TIME, RES_MOD_TIME, RES_COL)\n"
"values (_res_id, _name, _content, _type, _perms, _own, _grp, now (), now (), _col_id);\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_CONTENT, RES_TYPE, RES_PERMS, RES_OWNER, RES_GROUP, RES_CR_TIME, RES_MOD_TIME, RES_COL)\n"
"values (_res_id, _name, WS.WS.REPLACE_HREF (_host, _url, _root, _content, _type, conv_html), _type, _perms, _own, _grp, now (), now (), _col_id);\n"
"}\n"
"insert replacing WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT, VU_RES_ID)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root, _res_id);\n"
"}\n"
"else if (_res_id > 0)\n"
"{\n"
"whenever not found goto no_chksum;\n"
"select VU_CHKSUM, VU_ETAG\n"
"into _etag, _e_etag\n"
"from WS.WS.VFS_URL\n"
"where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"no_chksum:\n"
"if (_etag <> md5 (_content) or _s_etag <> _e_etag)\n"
"{\n"
"if (__tag (_content) = 185)\n"
"{\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = _content, RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_CONTENT = WS.WS.REPLACE_HREF (_host, _url, _root, _content, _type, conv_html),\n"
"RES_MOD_TIME = now ()\n"
"where RES_ID = _res_id;\n"
"}\n"
"\n"
"if (_etag is not null and isstring (_etag))\n"
"{\n"
"update WS.WS.VFS_URL\n"
"set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag\n"
"where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"}\n"
"else\n"
"{\n"
"insert replacing WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT, VU_RES_ID)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root, _res_id);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"err_end:\n"
"return 0;\n"
"}\n"
"--src vfs.sql:642\n"
;

static const char *proc406 = 
"#line 772 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.LDP_STORE (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"inout _content varchar,\n"
"in _s_etag varchar,\n"
"in _c_type varchar,\n"
"in store_flag integer,\n"
"in _udata any,\n"
"in _level int\n"
")\n"
"{\n"
"declare ldpc_credentials any;\n"
"declare start_url, start_url_processed varchar;\n"
"declare i integer;\n"
"declare ldpnr_create_method varchar;\n"
"declare src_folder_tree_handling varchar;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"ldpc_credentials := get_keyword (\'auth-ldp\', _udata);\n"
"ldpnr_create_method := get_keyword (\'ldpr-creation-method\', _udata);\n"
"src_folder_tree_handling := get_keyword (\'folder-tree\', _udata);\n"
"start_url := get_keyword (\'start_url\', _udata);\n"
"\n"
"\n"
"\n"
"if (ends_with (start_url, \'/\')) start_url_processed := subseq (start_url, 0, length (start_url) - 1);\n"
"if (strcontains (start_url_processed, \'/\'))\n"
"{\n"
"i := strrchr (start_url_processed, \'/\');\n"
"\n"
"start_url_processed := subseq (start_url_processed, 0, i + 1);\n"
"\n"
"_url := subseq (_url, length (start_url_processed));\n"
"}\n"
"\n"
"declare rc, isDir integer;\n"
"isDir := ends_with (_url, \'/\');\n"
"\n"
"if (src_folder_tree_handling = \'recreate\')\n"
"{\n"
"if (isDir)\n"
"{\n"
"rc := WS.WS.LDP_STORE__LDPC_CREATE (_root, _url, ldpc_credentials);\n"
"\n"
"\n"
"if (rc < 0)\n"
"{\n"
"signal (\'CRAWL\', \'LDP_STORE: LDPC creation failed\', \'CWLXX\');\n"
"}\n"
"else\n"
"{\n"
"\n"
"insert soft WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"if (row_count () = 0)\n"
"update WS.WS.VFS_URL set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag where\n"
"VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"rc := WS.WS.LDP_STORE__LDPNR_CREATE (_content, _c_type, _root, _url, ldpc_credentials, ldpnr_create_method);\n"
"\n"
"\n"
"if (rc < 0)\n"
"{\n"
"signal (\'CRAWL\', \'LDP_STORE: LDPNR creation failed\', \'CWLXX\');\n"
"}\n"
"else\n"
"{\n"
"\n"
"insert soft WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"if (row_count () = 0)\n"
"update WS.WS.VFS_URL set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag where\n"
"VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (src_folder_tree_handling = \'collapse\')\n"
"{\n"
"if (isDir = 0)\n"
"{\n"
"\n"
"\n"
"\n"
"declare i_last_sep integer;\n"
"i_last_sep := strrchr (_url, \'/\');\n"
"_url := subseq (_url, i_last_sep + 1);\n"
"\n"
"rc := WS.WS.LDP_STORE__LDPNR_CREATE (_content, _c_type, _root, _url, ldpc_credentials, ldpnr_create_method);\n"
"\n"
"\n"
"if (rc < 0)\n"
"{\n"
"signal (\'CRAWL\', \'LDP_STORE: LDPNR creation failed\', \'CWLXX\');\n"
"}\n"
"else\n"
"{\n"
"\n"
"insert soft WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"if (row_count () = 0)\n"
"update WS.WS.VFS_URL set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag where\n"
"VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src vfs.sql:770\n"
;

static const char *proc407 = 
"#line 894 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.LDP_STORE__LDPC_CREATE (\n"
"in ldpc_root varchar,\n"
"in ldpc_url varchar,\n"
"in ldp_credentials varchar\n"
")\n"
"{\n"
"declare request_hdr, response_hdr any;\n"
"declare request_content, request_content_mime_type, response, response_code, target_url varchar;\n"
"declare ldpc_fullpath, ldpc_parent, ldpc_basename varchar;\n"
"declare i_last_sep, rc, isLDPC integer;\n"
"\n"
"\n"
"isLDPC := WS.WS.LDP_STORE__IS_LDPC (ldpc_root || ldpc_url);\n"
"if (isLDPC = 0)\n"
"return 0;\n"
"\n"
"\n"
"ldpc_fullpath := ldpc_url;\n"
"ldpc_fullpath := subseq (ldpc_fullpath, 0, length (ldpc_fullpath) - 1);\n"
"\n"
"if (strcontains (ldpc_fullpath, \'/\'))\n"
"{\n"
"i_last_sep := strrchr (ldpc_fullpath, \'/\');\n"
"ldpc_parent := subseq (ldpc_fullpath, 0, i_last_sep + 1);\n"
"ldpc_basename := subseq (ldpc_fullpath, i_last_sep + 1);\n"
"}\n"
"else\n"
"{\n"
"ldpc_parent := \'\';\n"
"ldpc_basename := ldpc_fullpath;\n"
"}\n"
"\n"
"\n"
"\n"
"if (ldpc_parent <> \'\')\n"
"{\n"
"rc := WS.WS.LDP_STORE__LDPC_CREATE (ldpc_root, ldpc_parent, ldp_credentials);\n"
"if (rc < 0)\n"
"{\n"
"signal (\'CRAWL\', \'LDP_STORE: LDPC parent does not exist / creation failed\', \'CWLXX\');\n"
"return -1;\n"
"}\n"
"}\n"
"\n"
"\n"
"request_content := \'\';\n"
"request_content_mime_type := \'text/turtle\';\n"
"request_hdr := \'Link: <http://www.w3.org/ns/ldp#BasicContainer>; rel=\\\'type\\\'\';\n"
"if (length (ldp_credentials) > 0)\n"
"request_hdr := request_hdr || \'\\r\\nAuthorization: Basic  \' || encode_base64 (ldp_credentials);\n"
"request_hdr := request_hdr || \'\\r\\nSlug: \' || ldpc_basename;\n"
"request_hdr := request_hdr || \'\\r\\nContent-Type: \' || request_content_mime_type;\n"
"\n"
"response := http_get (ldpc_root || ldpc_parent, response_hdr, \'POST\', request_hdr, request_content);\n"
"\n"
"response_code := WS.WS.VFS_HTTP_RESP_CODE (response_hdr);\n"
"if (response_code = \'201\' or response_code = \'204\' or response_code = \'200\')\n"
"return 0;\n"
"\n"
"return -1;\n"
"}\n"
"--src vfs.sql:892\n"
;

static const char *proc408 = 
"#line 959 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.LDP_STORE__IS_LDPC (\n"
"in ldpc_url varchar)\n"
"{\n"
"declare response, response_code varchar;\n"
"declare request_hdr, response_hdr any;\n"
"declare request_content varchar;\n"
"\n"
"request_hdr := \'Content-Type: text/turtle\';\n"
"\n"
"request_content := \'\';\n"
"response := http_get (ldpc_url, response_hdr, \'GET\', request_hdr, request_content);\n"
"response_code := WS.WS.VFS_HTTP_RESP_CODE (response_hdr);\n"
"if (response_code = \'200\')\n"
"return 0;\n"
"\n"
"return -1;\n"
"}\n"
"--src vfs.sql:957\n"
;

static const char *proc409 = 
"#line 978 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.LDP_STORE__LDPNR_CREATE (\n"
"in request_content varchar,\n"
"in request_content_mime_type varchar,\n"
"in ldpnr_root varchar,\n"
"in ldpnr_url varchar,\n"
"in ldp_credentials varchar,\n"
"in ldpnr_create_method varchar)\n"
"{\n"
"declare request_hdr, response_hdr any;\n"
"declare response, response_code varchar;\n"
"declare rc, isLDPC, hasParent, i_last_sep integer;\n"
"declare ldpnr_parent, ldpnr_basename varchar;\n"
"\n"
"hasParent := 0;\n"
"request_hdr := \'Content-Type: \' || request_content_mime_type;\n"
"if (length (ldp_credentials) > 0)\n"
"request_hdr := request_hdr || \'\\r\\nAuthorization: Basic  \' || encode_base64 (ldp_credentials);\n"
"\n"
"\n"
"if (strcontains (ldpnr_url, \'/\'))\n"
"{\n"
"hasParent := 1;\n"
"i_last_sep := strrchr (ldpnr_url, \'/\');\n"
"ldpnr_parent := subseq (ldpnr_url, 0, i_last_sep + 1);\n"
"ldpnr_basename := subseq (ldpnr_url, i_last_sep + 1);\n"
"\n"
"rc := WS.WS.LDP_STORE__LDPC_CREATE (ldpnr_root, ldpnr_parent, ldp_credentials);\n"
"if (rc < 0)\n"
"{\n"
"signal (\'CRAWL\', \'LDP_STORE: LDPC parent does not exist / creation failed\', \'CWLXX\');\n"
"return -1;\n"
"}\n"
"}\n"
"\n"
"if (ldpnr_create_method = \'put\')\n"
"{\n"
"response := http_get (ldpnr_root || ldpnr_url, response_hdr, \'PUT\', request_hdr, request_content);\n"
"}\n"
"else\n"
"{\n"
"if (hasParent)\n"
"{\n"
"declare target varchar;\n"
"target := ldpnr_root || ldpnr_parent;\n"
"\n"
"if (ends_with (target, \'/\'))\n"
"target := subseq (target, 0, length(target) - 1);\n"
"request_hdr := request_hdr || \'\\r\\nAccept: */*\\r\\nSlug:\' || ldpnr_basename;\n"
"response := http_get (target, response_hdr, \'POST\', request_hdr, request_content);\n"
"}\n"
"else\n"
"{\n"
"declare target varchar;\n"
"target := ldpnr_root;\n"
"if (ends_with (target, \'/\'))\n"
"target := subseq (target, 0, length (target) - 1);\n"
"request_hdr := request_hdr || \'\\r\\nAccept: */*\\r\\nSlug:\' || ldpnr_url;\n"
"response := http_get (target, response_hdr, \'POST\', request_hdr, request_content);\n"
"}\n"
"}\n"
"\n"
"response_code := WS.WS.VFS_HTTP_RESP_CODE (response_hdr);\n"
"if (response_code = \'201\' or response_code = \'204\' or response_code = \'200\')\n"
"return 0;\n"
"\n"
"return -1;\n"
"}\n"
"--src vfs.sql:976\n"
;

static const char *proc410 = 
"#line 1047 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.GET_URLS (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"inout _content varchar,\n"
"in lev integer,\n"
"in ctype varchar)\n"
"{\n"
"declare _stag, _etag, _len, _inx, _htag, _sltag, _count, _t_tag1, _t_tag2, _urls_arr_len, depth integer;\n"
"declare _tmp, _tmp_host, _tmp_url, _t_len, _d_imgs, _other, _start_url varchar;\n"
"declare _flw, _nflw, _method, _delete, xp_exp, base, robots, care_of_bot varchar;\n"
"declare _newer datetime;\n"
"declare _own integer;\n"
"declare frames, _urls_arr, origin_iri, urls, udata, use_tidy any;\n"
"\n"
"if (WS.WS.SITEMAP_PROCESS (_host, _url, _root, _content, ctype, lev))\n"
"return;\n"
"\n"
"whenever not found goto no_site_rec;\n"
"select VS_SRC, VS_OTHER, VS_OWN, VS_METHOD, VS_FOLLOW, VS_NFOLLOW, VS_DEL, VS_NEWER, VS_XPATH, VS_DEPTH, VS_URL, VS_ROBOTS, VS_BOT, deserialize (VS_UDATA)\n"
"into _d_imgs, _other, _own, _method, _flw, _nflw, _delete, _newer, xp_exp, depth, _start_url, robots, care_of_bot, udata\n"
"from WS.WS.VFS_SITE\n"
"where VS_HOST = _host and VS_ROOT = _root;\n"
"\n"
"if (depth is not null and depth >= 0 and lev > depth)\n"
"return;\n"
"\n"
"frames := vector ();\n"
"use_tidy := \'Y\';\n"
"if (isvector (udata) and isstring (get_keyword (\'use-tidy\', udata)))\n"
"use_tidy := get_keyword (\'use-tidy\', udata, \'Y\');\n"
"if (__tag (_content) = 193)\n"
"_urls_arr := _content;\n"
"else\n"
"_urls_arr := WS.WS.FIND_URI (_content, _d_imgs, _host, _url, xp_exp, frames, ctype, use_tidy);\n"
"\n"
"if (__tag (_urls_arr) <> 193)\n"
"return;\n"
"\n"
"_urls_arr_len := length (_urls_arr);\n"
"if (care_of_bot)\n"
"_nflw := cast (robots as varchar) || _nflw;\n"
"\n"
"if ((isstring (_flw) and length (_flw) > 0) or (isstring (_nflw) and length (_nflw) > 0))\n"
"frames := vector ();\n"
"\n"
"_inx := 0;\n"
"base := WS.WS.MAKE_URL (_host, _url);\n"
"origin_iri := iri_to_id (base, 1);\n"
"urls := make_array (_urls_arr_len, \'any\');\n"
"while (_inx < _urls_arr_len)\n"
"{\n"
"declare hi, sch any;\n"
"\n"
"_tmp := _urls_arr[_inx];\n"
"if (length (_tmp) = 0)\n"
"goto next_url;\n"
"\n"
"_tmp := rfc1808_expand_uri (base, _tmp);\n"
"hi := rfc1808_parse_uri (_tmp);\n"
"sch := lower (hi[0]);\n"
"if (sch = \'\')\n"
"sch := \'http\';\n"
"\n"
"hi[5] := \'\';\n"
"_tmp := WS.WS.VFS_URI_COMPOSE (hi);\n"
"\n"
"if ((sch = \'http\') or (sch = \'https\'))\n"
"{\n"
"_tmp_host := hi[1];\n"
"hi[0] := \'\';\n"
"hi[1] := \'\';\n"
"_tmp_url := WS.WS.VFS_URI_COMPOSE (hi);\n"
"if (_tmp_host <> _host)\n"
"_tmp_url := _tmp;\n"
"\n"
"urls [_inx] := _tmp_url;\n"
"\n"
"if ((get_keyword (_tmp_url, frames) is not null or WS.WS.FOLLOW (_host, _root, _tmp_url, _flw, _nflw, _start_url, _d_imgs)))\n"
"{\n"
"insert soft WS.WS.VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_STAT, VQ_ROOT, VQ_LEVEL, VQ_ORIGIN)\n"
"values (_host, now (), _tmp_url, \'waiting\', _root, lev, origin_iri);\n"
"}\n"
"}\n"
"next_url:\n"
"_inx := _inx + 1;\n"
"}\n"
"delete from WS.WS.VFS_QUEUE where VQ_HOST = _host and VQ_ROOT = _root and VQ_ORIGIN = origin_iri and not position (VQ_URL, urls);\n"
"no_site_rec:\n"
"return;\n"
"}\n"
"--src vfs.sql:1045\n"
;

static const char *proc411 = 
"#line 1140 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SITEMAP_PROCESS (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"inout _content varchar,\n"
"in _c_type varchar,\n"
"in lev int)\n"
"{\n"
"declare xt, xp any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"return 0;\n"
"};\n"
"\n"
"xt := null;\n"
"if (_url like \'%.xml.gz\')\n"
"{\n"
"if (length (_content) > 2)\n"
"{\n"
"declare magic varchar;\n"
"magic := subseq (_content, 0, 2);\n"
"if (magic[0] = 0hex1f and magic[1] = 0hex8b)\n"
"_content := gzip_uncompress (_content);\n"
"}\n"
"}\n"
"if (_url like \'%.xml\' or _url like \'%.xml.gz\' or _c_type = \'text/xml\' or _c_type = \'application/xml\')\n"
"{\n"
"xt := xtree_doc (_content);\n"
"if (xpath_eval (\'/urlset/dataset\', xt) is not null)\n"
"{\n"
"declare ts any;\n"
"xp := xpath_eval (\'/urlset/dataset/dataDumpLocation/text()\', xt, 0);\n"
"ts := xpath_eval (\'/urlset/dataset/lastmod/text()\', xt);\n"
"if (ts is not null)\n"
"{\n"
"declare ar any;\n"
"declare i integer;\n"
"\n"
"i := 0;\n"
"ts := cast (cast (ts as varchar) as datetime);\n"
"ar := make_array (length (xp), \'any\');\n"
"foreach (any x in xp) do\n"
"{\n"
"ar[i] := vector (cast (x as varchar), ts);\n"
"i := i + 1;\n"
"}\n"
"xp := ar;\n"
"}\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 0);\n"
"return 1;\n"
"}\n"
"else if (xpath_eval (\'/sitemapindex/sitemap/loc\', xt) is not null)\n"
"{\n"
"\n"
"xp := WS.WS.SITEMAP_GET_LOC (xt, \'/sitemapindex/sitemap\', \'./loc/text()\', \'./lastmod/text()\');\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 0);\n"
"return 1;\n"
"}\n"
"else if (xpath_eval (\'/urlset/url/loc\', xt) is not null)\n"
"{\n"
"\n"
"xp := WS.WS.SITEMAP_GET_LOC (xt, \'/urlset/url\', \'./loc/text()\', \'./lastmod/text()\');\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 1);\n"
"return 1;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src vfs.sql:1138\n"
;

static const char *proc412 = 
"#line 1211 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.MAKE_URL (\n"
"in _host varchar,\n"
"in _url varchar)\n"
"{\n"
"declare hf_host, hf_url any;\n"
"\n"
"hf_host := WS.WS.PARSE_URI (_host);\n"
"hf_url := WS.WS.PARSE_URI (_url);\n"
"if (hf_url[0] = \'\')\n"
"hf_url[0] := case when (hf_host[0] = \'\') then \'http\' else hf_host[0] end;\n"
"\n"
"if (hf_url[1] = \'\')\n"
"hf_url[1] := case when (hf_host[0] = \'\') then _host else hf_host[1] end;;\n"
"\n"
"return WS.WS.VFS_URI_COMPOSE (hf_url);\n"
"}\n"
"--src vfs.sql:1209\n"
;

static const char *proc413 = 
"#line 1230 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SPLIT_URL (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _parent_url varchar,\n"
"out _o_host varchar,\n"
"out _o_url varchar)\n"
"{\n"
"declare _htag, _sltag, _t_len integer;\n"
"declare _schema integer;\n"
"declare _part varchar;\n"
"\n"
"_htag := strcasestr (_parent_url, \'http://\');\n"
"_schema := strcasestr (_parent_url, \'http:\');\n"
"_t_len := length (_parent_url);\n"
"if (_htag is not null)\n"
"{\n"
"_sltag := strstr (subseq (_parent_url, _htag + 8, _t_len), \'/\');\n"
"if (_sltag is not null)\n"
"{\n"
"_o_host := substring (_parent_url, _htag + 8, _sltag + 1);\n"
"if (_htag + 8 + _sltag + 2 < _t_len )\n"
"{\n"
"_o_url := substring (_parent_url, _htag + 8 + _sltag + 1 , _t_len - _sltag + 1);\n"
"}\n"
"else\n"
"{\n"
"_o_url := \'/\';\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_o_host := subseq (_parent_url, _htag + 7, _t_len);\n"
"_o_url := \'/\';\n"
"}\n"
"}\n"
"else if (_schema is not null and _htag is null)\n"
"{\n"
"\n"
"_o_host := _host;\n"
"if (_schema + 5 < _t_len)\n"
"{\n"
"_part := subseq (_parent_url, _schema + 5, _t_len);\n"
"if (aref (_part, 0) = \'/\')\n"
"_o_url := _part;\n"
"else\n"
"_o_url := WS.WS.EXPAND_URL (_url, _part);\n"
"}\n"
"else\n"
"{\n"
"_o_url := _url;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_o_host := _host;\n"
"if (aref (_parent_url, 0) = ascii (\'/\'))\n"
"_o_url := _parent_url;\n"
"else\n"
"_o_url := WS.WS.EXPAND_URL (_url, _parent_url);\n"
"}\n"
"}\n"
"--src vfs.sql:1228\n"
;

static const char *proc414 = 
"#line 1294 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.EXPAND_URL_OLD (\n"
"in _url varchar,\n"
"in _c_url varchar)\n"
"{\n"
"declare _tmp varchar;\n"
"declare _dsl, _sl, _c_len integer;\n"
"declare host_pos integer;\n"
"\n"
"_tmp := _url;\n"
"\n"
"if (_url is null or not isstring (_url))\n"
"return _c_url;\n"
"\n"
"if (_c_url is null or not isstring (_c_url))\n"
"return _url;\n"
"\n"
"_c_len := length (_c_url);\n"
"if (_c_url = \'.\')\n"
"return _url;\n"
"if (_c_url is not null)\n"
"{\n"
"if (strstr (_c_url, \'://\') is not null or\n"
"(length (_c_url) > 1 and (aref (_c_url, 0) = ascii (\'/\') or aref (_c_url, 0) = ascii (\'\\\\\'))))\n"
"return _c_url;\n"
"}\n"
"\n"
"host_pos := strstr (_tmp, \'://\');\n"
"if (aref (_tmp, length (_tmp) - 1) <> ascii (\'/\'))\n"
"{\n"
"declare last_slash_pos integer;\n"
"\n"
"last_slash_pos := strrchr (_tmp, \'/\');\n"
"if (last_slash_pos is not null and (last_slash_pos - host_pos > 2 or host_pos is null))\n"
"{\n"
"_tmp := substring (_tmp, 1, last_slash_pos + 1);\n"
"}\n"
"else\n"
"{\n"
"if (host_pos is null)\n"
"_tmp := \'/\';\n"
"else\n"
"_tmp := concat (_tmp, \'/\');\n"
"}\n"
"}\n"
"\n"
"_tmp := concat (_tmp, _c_url);\n"
"_tmp := replace (_tmp, \'/./\', \'/\');\n"
"_dsl := 0;\n"
"while (_dsl is not null)\n"
"{\n"
"_dsl := strstr (_tmp, \'/../\');\n"
"if (_dsl is null)\n"
"goto end_loop;\n"
"if (_dsl = 0)\n"
"{\n"
"_tmp := subseq (_tmp, 3, length (_tmp));\n"
"goto end_loop;\n"
"}\n"
"_sl := strrchr (subseq (_tmp, 0, _dsl - 1), \'/\');\n"
"_tmp := concat (subseq (_tmp, 0, _sl + 1), subseq (_tmp, _dsl + 4, length (_tmp)));\n"
"}\n"
"end_loop:\n"
"return _tmp;\n"
"}\n"
"--src vfs.sql:1292\n"
;

static const char *proc415 = 
"#line 1360 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.MKPATH (\n"
"in _path any,\n"
"in _own integer,\n"
"in _grp integer,\n"
"in _perms varchar)\n"
"{\n"
"declare _col, _len, _inx, _t_col integer;\n"
"declare _name varchar;\n"
"\n"
"if (__tag (_path) <> 193)\n"
"return NULL;\n"
"\n"
"if (length (_path) < 1)\n"
"return NULL;\n"
"\n"
"_len := length (_path);\n"
"_inx := 0;\n"
"_t_col := 1;\n"
"whenever not found goto not_found;\n"
"while (_inx < _len)\n"
"{\n"
"select COL_ID\n"
"into _col\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = _t_col and COL_NAME = aref (_path, _inx);\n"
"_t_col := _col;\n"
"_inx := _inx + 1;\n"
"}\n"
"not_found:\n"
"while (_inx < _len)\n"
"{\n"
"_col := getid (\'C\');\n"
"_name := aref (_path, _inx);\n"
"insert into WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_CR_TIME, COL_MOD_TIME, COL_OWNER, COL_GROUP, COL_PERMS)\n"
"values (_col, _name, _t_col, now (), now (), _own, _grp, _perms);\n"
"\n"
"_inx := _inx + 1;\n"
"_t_col := _col;\n"
"}\n"
"return _col;\n"
"}\n"
"--src vfs.sql:1358\n"
;

static const char *proc416 = 
"#line 1403 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.FOLLOW (\n"
"in _host varchar,\n"
"in _root varchar,\n"
"in _t_url varchar,\n"
"in _flw_s varchar,\n"
"in _nflw_s varchar,\n"
"in _url varchar,\n"
"in _img varchar)\n"
"{\n"
"declare _flw, _nflw any;\n"
"declare _inx, _rc, _len integer;\n"
"declare _cond varchar;\n"
"\n"
"\n"
"if (_t_url = _url)\n"
"return 1;\n"
"\n"
"if (_img is not null and substring (http_mime_type (_t_url), 1, 6) = \'image/\' and _t_url not like \'http://%\')\n"
"return 1;\n"
"\n"
"if (0 = length (_nflw_s) and 0 = length (_img) and substring (http_mime_type (_t_url), 1, 6) = \'image/\')\n"
"return 0;\n"
"\n"
"if (length (_flw_s) = 0)\n"
"_flw_s := \'/%\';\n"
"\n"
"if (length (_nflw_s) = 0)\n"
"_nflw_s := (\'\');\n"
"\n"
"_rc := 0;\n"
"_flw := split_and_decode (_flw_s, 0, \';=;\');\n"
"if (_flw is null)\n"
"goto next_step;\n"
"_len := length (_flw);\n"
"if (_len > 0)\n"
"{\n"
"_inx := 0;\n"
"while (_inx < _len)\n"
"{\n"
"_cond := aref (_flw, _inx);\n"
"if (_t_url like _cond)\n"
"{\n"
"_rc := 1;\n"
"goto next_step;\n"
"}\n"
"_inx := _inx + 1;\n"
"}\n"
"return 0;\n"
"}\n"
"next_step:\n"
"_nflw := split_and_decode (_nflw_s, 0, \';=;\');\n"
"if (_nflw is null)\n"
"goto end_step;\n"
"_len := length (_nflw);\n"
"if (_len > 0)\n"
"{\n"
"_inx := 0;\n"
"while (_inx < _len)\n"
"{\n"
"_cond := aref (_nflw, _inx);\n"
"if (_t_url like _cond)\n"
"{\n"
"_rc := 0;\n"
"goto end_step;\n"
"}\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"end_step:\n"
"return _rc;\n"
"}\n"
"--src vfs.sql:1401\n"
;

static const char *proc417 = 
"#line 1476 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.REPLACE_HREF (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"in _content varchar,\n"
"in _c_type varchar,\n"
"in conv_html int := 1)\n"
"{\n"
"declare _str, _tree, _tree_doc any;\n"
"declare _tmp, _nhost, _nurl, _dav, _url_p varchar;\n"
"declare _lp, _rp, _len, _tp, _break, _inx integer;\n"
"\n"
"if (_c_type not like \'text/html%\' or not isstring (_content) or conv_html = 0)\n"
"return _content;\n"
"\n"
"_str := string_output ();\n"
"if (strrchr (_url, \'/\') = 0)\n"
"_url_p := \'/\';\n"
"else if (strrchr (_url, \'/\') is not null and strrchr (_url, \'/\') > 0)\n"
"_url_p := subseq (_url, 0, strrchr (_url, \'/\') + 1);\n"
"else\n"
"_url_p := _url;\n"
"{\n"
"declare exit handler for sqlstate \'*\' { return _content; };\n"
"_tree := xml_tree (_content, 66, WS.WS.MAKE_URL (_host, _url_p), current_charset());\n"
"}\n"
"_break := 1;\n"
"_inx := 1;\n"
"if (__tag (_tree) <> 193)\n"
"return _content;\n"
"_tree_doc := xml_tree_doc (_tree);\n"
"http_value (_tree_doc, null, _str);\n"
"_tmp := string_output_string (_str);\n"
"return _tmp;\n"
"}\n"
"--src vfs.sql:1474\n"
;

static const char *proc418 = 
"#line 1513 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.FIND_URI (\n"
"in _content varchar,\n"
"in _d_imgs varchar,\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in xp_exp varchar,\n"
"out frames any,\n"
"in ctype varchar,\n"
"in use_tidy varchar := \'Y\')\n"
"{\n"
"declare _len, _inx integer;\n"
"declare xe, arr, arr1, ha, sa, ia, fr, ifr, sty, js any;\n"
"declare elm, _tmp_host, _tmp_url, base varchar;\n"
"declare _xml_tree any;\n"
"\n"
"frames := vector ();\n"
"\n"
"if (not isstring (_content) and __tag (_content) <> 185)\n"
"return vector ();\n"
"\n"
"if (use_tidy = \'Y\' and tidy_external () and ctype like \'text/html\')\n"
"_content := tidy_html (_content, \'output-xhtml:yes\\r\\ntidy-mark:no\');\n"
"if (ctype like \'application/%xml\' or ctype = \'text/xml\')\n"
"_xml_tree := xml_tree (_content, 0);\n"
"else\n"
"_xml_tree := xml_tree (_content, 2);\n"
"if (__tag (_xml_tree) <> 193)\n"
"return WS.WS.GET_HREF_IN_ARRAY (_content, _d_imgs);\n"
"\n"
"xe := xml_tree_doc (_xml_tree);\n"
"\n"
"if (length (xp_exp))\n"
"{\n"
"arr := xpath_eval (xp_exp, xe, 0);\n"
"_inx := 0; _len := length (arr);\n"
"vectorbld_init (arr1);\n"
"while (_inx < _len)\n"
"{\n"
"elm := cast (arr[_inx] as varchar);\n"
"if (isstring (elm) and strstr (http_mime_type (elm), \'image/\') is null or _d_imgs is not null)\n"
"vectorbld_acc (arr1, elm);\n"
"_inx := _inx + 1;\n"
"}\n"
"vectorbld_final (arr1);\n"
"}\n"
"else\n"
"{\n"
"arr1 := vector ();\n"
"ha := xpath_eval (\'//@href\', xe, 0);\n"
"sa := xpath_eval (\'//@src\', xe, 0);\n"
"ia := xpath_eval (\'//@background\', xe, 0);\n"
"\n"
"fr := xpath_eval (\'//frame/@src\', xe, 0);\n"
"ifr := xpath_eval (\'//iframe/@src\', xe, 0);\n"
"sty := xpath_eval (\'/html/head/link[@rel=\"stylesheet\"]/@href\', xe, 0);\n"
"js := xpath_eval (\'//script/@src\', xe, 0);\n"
"\n"
"arr := vector_concat (ha, sa, ia);\n"
"\n"
"_inx := 0; _len := length (arr);\n"
"\n"
"while (_inx < _len)\n"
"{\n"
"elm := cast (arr[_inx] as varchar);\n"
"if (isstring (elm) and strstr (http_mime_type (elm), \'image/\') is null or _d_imgs is not null)\n"
"arr1 := vector_concat (arr1, vector (elm));\n"
"_inx := _inx + 1;\n"
"}\n"
"\n"
"\n"
"if (length (arr1) < 1)\n"
"{\n"
"elm := xpath_eval (\'//meta[translate(@http-equiv,\'\'REFRESH\'\',\'\'refresh\'\')=\'\'refresh\'\']/@content\', xe, 1);\n"
"if (elm is not null)\n"
"{\n"
"elm := cast (elm as varchar);\n"
"elm := regexp_match (\'[UuRrLl=]+[^ \\t\\$\\\"]*\', elm);\n"
"if (elm is not null and length (elm) > 5)\n"
"arr1 := vector (substring (elm, 5, length (elm)));\n"
"}\n"
"}\n"
"\n"
"fr := vector_concat (fr, ifr, sty, js);\n"
"_inx := 0;\n"
"_len := length (fr);\n"
"if (_len > 0)\n"
"base :=  WS.WS.MAKE_URL (_host, _url);\n"
"\n"
"while (_inx < _len)\n"
"{\n"
"declare hi any;\n"
"elm := cast (fr[_inx] as varchar);\n"
"elm := rfc1808_expand_uri (base, elm);\n"
"hi := rfc1808_parse_uri (elm);\n"
"_tmp_host := hi[1];\n"
"hi[0] := \'\'; hi[1] := \'\';\n"
"_tmp_url := WS.WS.VFS_URI_COMPOSE (hi);\n"
"if (_host = _tmp_host)\n"
"frames := vector_concat (frames, vector (_tmp_url, \'\'));\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"return arr1;\n"
"}\n"
"--src vfs.sql:1511\n"
;

static const char *proc419 = 
"#line 1620 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.LFS_EXP (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"in _i_dst varchar)\n"
"{\n"
"declare _path, _name, _content, _dest, _tmp, _dst, _err varchar;\n"
"declare _os_path any;\n"
"declare _o_len, _n, _rc, _win integer;\n"
"declare c cursor for select RES_FULL_PATH, RES_NAME, blob_to_string (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH like concat (_root, \'%\');\n"
"\n"
"if (dav_root () = \'/\')\n"
"_root := concat (\'/\', _root, \'/\');\n"
"else\n"
"_root := concat (\'/\', dav_root (), \'/\', _root, \'/\');\n"
"\n"
"if (aref (_i_dst, length (_i_dst) - 1) = ascii (\'/\'))\n"
"_dst := subseq (_i_dst, 0, length (_i_dst) - 1);\n"
"else\n"
"_dst := _i_dst;\n"
"\n"
"_win := 0;\n"
"if (length (_dst) > 1)\n"
"{\n"
"if (aref (_dst, 1) = ascii (\':\') and aref (_dst, 0) <> ascii (\'/\'))\n"
"_win := 1;\n"
"}\n"
"if (_win = 1 and length (_dst) > 2)\n"
"{\n"
"if (aref (_dst, 2) = ascii (\'\\\\\'))\n"
"_dst := replace (_dst, \'\\\\\', \'/\');\n"
"if (aref (_dst, length (_dst) - 1) = ascii (\'/\'))\n"
"_dst := substring (_dst, 1, length (_dst) - 1);\n"
"}\n"
"\n"
"whenever not found goto end_exp;\n"
"open c;\n"
"while (1)\n"
"{\n"
"fetch c into _path, _name, _content;\n"
"_dest := concat (_dst, subseq (_path, strstr (_path, dav_root ()) + length (dav_root ()),length (_path)));\n"
"_os_path := WS.WS.HREF_TO_ARRAY (_dest, \'\');\n"
"_o_len := length (_os_path);\n"
"_n := 0;\n"
"if (_win = 0)\n"
"{\n"
"_tmp := \'/\';\n"
"}\n"
"else\n"
"{\n"
"_n := 1;\n"
"_tmp := concat (substring (_dst, 1, 2), \'/\');\n"
"}\n"
"while (_n < _o_len - 1)\n"
"{\n"
"if (_win = 0)\n"
"_tmp := concat (_tmp, aref (_os_path, _n), \'/\');\n"
"else\n"
"_tmp := concat (_tmp, aref (_os_path, _n));\n"
"_rc := file_stat ( _tmp);\n"
"if (_rc = 0)\n"
"{\n"
"_rc := sys_mkdir (_tmp, _err);\n"
"if (_rc <> 0)\n"
"return _err;\n"
"}\n"
"_n := _n + 1;\n"
"if (_win = 1)\n"
"_tmp := concat (_tmp, \'/\');\n"
"}\n"
"string_to_file ( _dest, _content, 0);\n"
"}\n"
"\n"
"end_exp:\n"
"close c;\n"
"return;\n"
"}\n"
"--src vfs.sql:1618\n"
;

static const char *proc420 = 
"#line 1700 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.FIND_KEYWORD (\n"
"inout params varchar,\n"
"in _pkey varchar)\n"
"{\n"
"declare inx integer;\n"
"declare pkey_len integer;\n"
"declare result, pkey varchar;\n"
"declare line varchar;\n"
"declare cr, lf char;\n"
"if (isnull (_pkey))\n"
"return \'\';\n"
"pkey_len := length (_pkey);\n"
"inx := length (params) - 1;\n"
"result := \'\';\n"
"pkey := ucase (_pkey);\n"
"while (inx >= 0)\n"
"{\n"
"line := aref (params, inx);\n"
"if ( pkey = ucase (substring (line, 1, pkey_len)))\n"
"{\n"
"result := substring (line, pkey_len + 1, length (line));\n"
"if ( 2 < length (result))\n"
"{\n"
"cr := chr (aref (result, length (result) - 1));\n"
"lf := chr (aref (result, length (result) - 2));\n"
"}\n"
"if ( lf = \'\\r\' or lf = \'\\n\')\n"
"result := substring (result, 1, length(result) - 2);\n"
"else if ( cr = \'\\r\' or cr = \'\\n\')\n"
"result := substring (result, 1, length(result) - 1);\n"
"result := trim (result);\n"
"goto end_find;\n"
"}\n"
"inx := inx - 1;\n"
"}\n"
"end_find:\n"
"return result;\n"
"}\n"
"--src vfs.sql:1698\n"
;

static const char *proc421 = 
"#line 1741 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.GET_HREF_IN_ARRAY (\n"
"in _content varchar,\n"
"in _d_imgs varchar)\n"
"{\n"
"declare _stag, _etag, _len, _inx, _htag, _sltag, _count, _t_tag1, _t_tag2, _uri_len integer;\n"
"declare _tmp, _tmp_host, _tmp_url, _t_len varchar;\n"
"declare _uri, _res any;\n"
"declare _href_c integer;\n"
"\n"
"if (not isstring (_content))\n"
"return vector ();\n"
"_len := length (_content);\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := _stag + strcasestr (subseq (_content, _stag, _len), \'SRC=\');\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'HREF=\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto next_round;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'\"\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'\"\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 0 and aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null and length (_tmp) > 0)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"next_round:\n"
"if (_href_c < 1)\n"
"return vector ();\n"
"_res := make_array (_href_c, \'any\');\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := _stag + strcasestr (subseq (_content, _stag, _len), \'SRC=\');\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'HREF=\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto end_find;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'\"\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'\"\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 0 and aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null and length (_tmp) > 0)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"{\n"
"aset (_res, _href_c, _tmp);\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"end_find:\n"
"return _res;\n"
"}\n"
"--src vfs.sql:1739\n"
;

static const char *proc422 = 
"#line 1837 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.DAV_EXP (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"in _i_dst varchar)\n"
"{\n"
"declare _path, _name, _content, _dest, _tmp, _etag, _dst varchar;\n"
"declare _os_path any;\n"
"declare _o_len, _n, _rc integer;\n"
"declare _d_host varchar;\n"
"declare _visited, _t_root varchar;\n"
"declare tgt_is_vis integer;\n"
"declare bm, err any;\n"
"declare c static cursor for select RES_FULL_PATH, RES_NAME, blob_to_string (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH like concat (_root, \'%\');\n"
"\n"
"set isolation = \'committed\';\n"
"_visited := \';\';\n"
"tgt_is_vis := 0;\n"
"_t_root := _root;\n"
"if (dav_root () = \'/\')\n"
"_root := concat (\'/\', _root, \'/\');\n"
"else\n"
"_root := concat (\'/\', dav_root (), \'/\', _root, \'/\');\n"
"\n"
"if (aref (_i_dst, length (_i_dst) - 1) = ascii (\'/\'))\n"
"_dst := subseq (_i_dst, 0, length (_i_dst) - 1);\n"
"else\n"
"_dst := _i_dst;\n"
"\n"
"if (strstr (_dst,\'http://\') = 0)\n"
"_d_host := subseq (_dst, 0, strchr (subseq (_dst, strstr (_dst,\'http://\') + 7, length (_dst)),\'/\') + 7);\n"
"else if (strstr (_dst, \'https://\') = 0)\n"
"_d_host := subseq (_dst, 0, strchr (subseq (_dst, strstr (_dst,\'https://\') + 8, length (_dst)),\'/\') + 8);\n"
"else\n"
"return \'The destination must begin with http:// protocol identifier\';\n"
"\n"
"whenever not found goto end_exp;\n"
"open c (prefetch 1);\n"
"fetch c first into _path, _name, _content;\n"
"while (1)\n"
"{\n"
"bm := bookmark (c);\n"
"err := 0;\n"
"close c;\n"
"commit work;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"err := 1;\n"
"goto next;\n"
"};\n"
"\n"
"if (not tgt_is_vis)\n"
"{\n"
"declare tpa, tpath varchar;\n"
"declare ti, tl integer;\n"
"\n"
"tpa := WS.WS.HREF_TO_ARRAY (_dst, _d_host);\n"
"_rc := 0;\n"
"tl := length (tpa);\n"
"ti := tl - 1;\n"
"while (ti >= 0)\n"
"{\n"
"tpath := concat (_d_host, \'/\'); _n := 0;\n"
"while (_n <= ti)\n"
"{\n"
"tpath := concat (tpath, WS.WS.STR_TO_URI (aref (tpa, _n)), \'/\');\n"
"_n := _n + 1;\n"
"}\n"
"if (not tgt_is_vis)\n"
"_rc := WS.WS.DAV_HEAD (tpath);\n"
"if (_rc = 0)\n"
"{\n"
"_visited := concat (_visited, \';\', tpath);\n"
"tgt_is_vis := 1;\n"
"}\n"
"ti := ti - 1;\n"
"}\n"
"tgt_is_vis := 1;\n"
"}\n"
"\n"
"_dest := concat (_dst, subseq (_path, strstr (_path, dav_root ()) + length (dav_root ()), length (_path)));\n"
"_os_path := WS.WS.HREF_TO_ARRAY (_dest, _d_host);\n"
"_o_len := length (_os_path);\n"
"_n := 0;\n"
"_tmp := concat (_d_host, \'/\');\n"
"while (_n < _o_len - 1)\n"
"{\n"
"_tmp := concat (_tmp, WS.WS.STR_TO_URI (aref (_os_path, _n)), \'/\');\n"
"if (strstr (_visited, _tmp) is null)\n"
"{\n"
"_rc := WS.WS.DAV_HEAD (_tmp);\n"
"if (_rc <> 0)\n"
"_rc := WS.WS.DAV_MKCOL (_tmp);\n"
"if (_rc <> 0)\n"
"return _rc;\n"
"_visited := concat (_visited, \';\', _tmp);\n"
"}\n"
"_n := _n + 1;\n"
"}\n"
"_dest := concat (_dst,\n"
"WS.WS.STR_TO_URI (\n"
"subseq (_path, strstr (_path, dav_root ()) + length (dav_root ()), length (_path))));\n"
"WS.WS.DAV_PUT (_dest, _content);\n"
"next:\n"
"open c (prefetch 1);\n"
"fetch c bookmark bm into _path, _name, _content;\n"
"fetch c next into _path, _name, _content;\n"
"}\n"
"\n"
"end_exp:\n"
"close c;\n"
"return 0;\n"
"}\n"
"--src vfs.sql:1835\n"
;

static const char *proc423 = 
"#line 1954 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.DAV_HEAD (\n"
"inout _url varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp varchar;\n"
"\n"
"commit work;\n"
"http_get (_url, _res, \'HEAD\');\n"
"_resp := WS.WS.VFS_HTTP_RESP_CODE (_res);\n"
"if (_resp = \'200\')\n"
"return 0;\n"
"\n"
"return -1;\n"
"}\n"
"--src vfs.sql:1952\n"
;

static const char *proc424 = 
"#line 1970 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.DAV_MKCOL (\n"
"inout _url varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp varchar;\n"
"\n"
"commit work;\n"
"http_get (_url, _res, \'MKCOL\');\n"
"_resp := WS.WS.VFS_HTTP_RESP_CODE (_res);\n"
"if (_resp = \'201\')\n"
"return 0;\n"
"\n"
"return -1;\n"
"}\n"
"--src vfs.sql:1968\n"
;

static const char *proc425 = 
"#line 1986 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.DAV_PUT (\n"
"inout _url varchar,\n"
"in _content varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp varchar;\n"
"\n"
"commit work;\n"
"http_get (_url, _res, \'PUT\', concat (\'Content-Type: \', http_mime_type (_url)), _content);\n"
"_resp := WS.WS.VFS_HTTP_RESP_CODE (_res);\n"
"if (_resp = \'201\' or _resp = \'204\' or _resp = \'200\')\n"
"return 0;\n"
"\n"
"return -1;\n"
"}\n"
"--src vfs.sql:1984\n"
;

static const char *proc426 = 
"#line 2003 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.DAV_PROP (\n"
"inout _url varchar,\n"
"in _d_imgs varchar,\n"
"in _auth varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp, _body varchar;\n"
"\n"
"_body := http_get (_url, _res, \'PROPFIND\', \'Content-Type: text/xml\\r\\nDepth: 1\\r\\n\' || case when (isstring (_auth) and _auth <> \'\') then _auth else \'\' end, \'<D:propfind xmlns:D=\"DAV:\"><D:prop><D:resourcetype/><D:getcontenttype/></D:prop></D:propfind>\');\n"
"\n"
"\n"
"_resp := WS.WS.VFS_HTTP_RESP_CODE (_res);\n"
"if (_resp = \'200\')\n"
"return WS.WS.GET_HREF_FROM_XML (_body, _d_imgs);\n"
"\n"
"return null;\n"
"}\n"
"--src vfs.sql:2001\n"
;

static const char *proc427 = 
"#line 2023 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.GET_HREF_FROM_XML (\n"
"in _content varchar,\n"
"in _d_imgs varchar)\n"
"{\n"
"declare _stag, _etag, _len, _inx, _htag, _sltag, _count, _t_tag1, _t_tag2, _uri_len integer;\n"
"declare _tmp, _tmp_host, _tmp_url, _t_len varchar;\n"
"declare _uri, _res any;\n"
"declare _href_c integer;\n"
"\n"
"_len := length (_content);\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := NULL;\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'href>\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto next_round;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'>\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'<\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null)\n"
"{\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"next_round:\n"
"if (_href_c < 1)\n"
"return vector ();\n"
"_res := make_array (_href_c, \'any\');\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := NULL;\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'href>\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto end_find;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'>\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'<\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null)\n"
"{\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"{\n"
"aset (_res, _href_c, _tmp);\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"end_find:\n"
"return _res;\n"
"}\n"
"--src vfs.sql:2021\n"
;

static const char *proc428 = 
"#line 2129 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.ISEMPTY (\n"
"in x any)\n"
"{\n"
"if (\'\' = x or x is null or x = 0)\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src vfs.sql:2127\n"
;

static const char *proc429 = 
"#line 2148 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.URL_BY_DATE (\n"
"in host varchar,\n"
"in coll varchar,\n"
"out url varchar,\n"
"in _clnt_data any)\n"
"{\n"
"declare next_url varchar;\n"
"whenever not found goto done;\n"
"\n"
"declare cr cursor for select top 1 VQ_URL from WS.WS.VFS_QUEUE where VQ_HOST = host and VQ_ROOT = coll and VQ_STAT = \'waiting\' order by VQ_HOST, VQ_ROOT, VQ_TS for update;\n"
"url := null;\n"
"open cr;\n"
"fetch cr into next_url;\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'pending\' where VQ_HOST = host and VQ_ROOT = coll and VQ_URL = next_url;\n"
"url := next_url;\n"
"close cr;\n"
"return 1;\n"
"done:\n"
"close cr;\n"
"return 0;\n"
"}\n"
"--src vfs.sql:2146\n"
;

static const char *proc430 = 
"#line 2171 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_RECOVER_QUEUE_STAT (\n"
"in host varchar,\n"
"in coll varchar)\n"
"{\n"
"declare next_url varchar;\n"
"declare last_ts datetime;\n"
"declare secs_last integer;\n"
"\n"
"secs_last := coalesce (sequence_set (\'WEB_COPY_SSHUT\', 0, 2), 0);\n"
"last_ts := dateadd (\'second\', secs_last, stringdate (\'1980-01-01\'));\n"
"\n"
"whenever not found goto done;\n"
"declare cr cursor for select VQ_URL from WS.WS.VFS_QUEUE where VQ_HOST = host and VQ_ROOT = coll and VQ_STAT = \'pending\' and VQ_TS < last_ts for update;\n"
"open cr;\n"
"while (1)\n"
"{\n"
"fetch cr into next_url;\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = host and VQ_ROOT = coll and VQ_URL = next_url;\n"
"}\n"
"done:\n"
"close cr;\n"
"}\n"
"--src vfs.sql:2169\n"
;

static const char *proc431 = 
"#line 2199 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_MAKE_ENTRY (\n"
"in url varchar,\n"
"in follow varchar := \'/*\',\n"
"in disallow varchar := \'%.zip;%.tar;%.pdf;%.tgz;%.arj;\',\n"
"in get_rdf int := 0)\n"
"{\n"
"declare hi any;\n"
"\n"
"hi := rfc1808_parse_uri (url);\n"
"insert replacing WS.WS.VFS_SITE (VS_DESCR, VS_HOST, VS_URL, VS_OWN, VS_ROOT, VS_NEWER, VS_DEL, VS_FOLLOW, VS_NFOLLOW, VS_SRC, VS_DLOAD_META)\n"
"values (hi[1], hi[1], hi[2], 2, hi[1], cast (\'1990-01-01\' as datetime),  \'checked\', follow, disallow, \'checked\', get_rdf);\n"
"\n"
"insert replacing WS.WS.VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_ROOT, VQ_STAT)\n"
"values (hi[1], now(), hi[2], hi[1], \'waiting\');\n"
"\n"
"if (get_rdf)\n"
"{\n"
"insert replacing WS.WS.VFS_SITE_RDF_MAP (VM_HOST, VM_ROOT, VM_RDF_MAP, VM_SEQ)\n"
"select hi[1], hi[1], RM_PID, RM_ID from DB.DBA.SYS_RDF_MAPPERS;\n"
"}\n"
"}\n"
"--src vfs.sql:2197\n"
;

static const char *proc432 = 
"#line 2222 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_GO (\n"
"in url varchar)\n"
"{\n"
"declare hi any;\n"
"\n"
"hi := rfc1808_parse_uri (url);\n"
"WS.WS.SERV_QUEUE_TOP (hi[1], hi[1], 0, 0, NULL, NULL);\n"
"}\n"
"--src vfs.sql:2220\n"
;

static const char *proc433 = 
"#line 2232 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_URI_COMPOSE (\n"
"in res any)\n"
"{\n"
"declare _full_path, _elm varchar;\n"
"declare idx integer;\n"
"\n"
"if (length (res) < 6)\n"
"signal (\'.....\', \'WS.WS.VFS_URI_COMPOSE needs a vector of strings with 6 elements\');\n"
"\n"
"idx := 0;\n"
"_elm := \'\';\n"
"_full_path := \'\';\n"
"while (idx < 6)\n"
"{\n"
"_elm := res[idx];\n"
"if (isstring (_elm) and _elm <> \'\')\n"
"{\n"
"if (idx = 0)\n"
"_full_path := concat (_elm, \':\');\n"
"else if (idx = 1)\n"
"_full_path := concat (_full_path, \'//\', _elm);\n"
"else if (idx = 2)\n"
"_full_path := concat (_full_path, _elm);\n"
"else if (idx = 3)\n"
"_full_path := concat (_full_path, \';\', _elm);\n"
"else if (idx = 4)\n"
"_full_path := concat (_full_path, \'?\', _elm);\n"
"else if (idx = 5)\n"
"_full_path := concat (_full_path, \'#\', _elm);\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return _full_path;\n"
"}\n"
"--src vfs.sql:2230\n"
;

static const char *proc434 = 
"#line 2270 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_EXTRACT_RDF (\n"
"in _host varchar,\n"
"in _root varchar,\n"
"in _start_path varchar,\n"
"in opts any,\n"
"in url varchar,\n"
"inout content any,\n"
"in ctype varchar,\n"
"inout outhdr any,\n"
"inout inhdr any,\n"
"in lev any)\n"
"{\n"
"\n"
"declare mime_type, _graph, _base, out_arr, tmp varchar;\n"
"declare html_start, xd any;\n"
"declare rc, deadl integer;\n"
"\n"
"html_start := null;\n"
"\n"
"_graph := get_keyword (\'rdf-graph\', opts);\n"
"if (length (_graph) = 0)\n"
"_graph := WS.WS.MAKE_URL (_host, url);\n"
"_base := WS.WS.MAKE_URL (_host, url);\n"
"\n"
"commit work;\n"
"deadl := 6;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"__SQL_STATE := cast (__SQL_STATE as varchar);\n"
"if (__SQL_STATE = \'40001\')\n"
"{\n"
"deadl := deadl - 1;\n"
"if (deadl > 0)\n"
"goto again;\n"
"}\n"
"resignal;\n"
"};\n"
"\n"
"if (url like \'*.gz\')\n"
"{\n"
"if (length (content) > 2)\n"
"{\n"
"declare magic varchar;\n"
"magic := subseq (content, 0, 2);\n"
"if (magic[0] = 0hex1f and magic[1] = 0hex8b)\n"
"{\n"
"content := gzip_uncompress (content);\n"
"}\n"
"}\n"
"}\n"
"\n"
"mime_type := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (url, ctype, content);\n"
"\n"
"again:\n"
"\n"
"{\n"
"if (strstr (mime_type, \'application/rdf+xml\') is not null)\n"
"{\n"
"DB.DBA.RDF_LOAD_RDFXML (content, _base, _graph);\n"
"}\n"
"else if (\n"
"strstr (mime_type, \'text/rdf+n3\') is not null or\n"
"strstr (mime_type, \'text/rdf+ttl\') is not null or\n"
"strstr (mime_type, \'application/rdf+n3\') is not null or\n"
"strstr (mime_type, \'application/rdf+turtle\') is not null or\n"
"strstr (mime_type, \'application/turtle\') is not null or\n"
"strstr (mime_type, \'text/turtle\') is not null or\n"
"strstr (mime_type, \'application/x-turtle\') is not null\n"
")\n"
"{\n"
"DB.DBA.TTLP (content, _base, _graph);\n"
"}\n"
"}\n"
"\n"
"\n"
"WS.WS.VFS_EXTRACT_RDF_CARTRIDGES (\n"
"content,\n"
"mime_type,\n"
"\'select RM_PATTERN, RM_TYPE, RM_HOOK, RM_KEY, RM_OPTIONS \' ||\n"
"\'  from DB.DBA.SYS_RDF_MAPPERS,                          \' ||\n"
"\'       WS.WS.VFS_SITE_RDF_MAP                           \' ||\n"
"\' where VM_RDF_MAP = RM_PID                              \' ||\n"
"\'   and VM_HOST = ?                                      \' ||\n"
"\'   and VM_ROOT = ?                                      \' ||\n"
"\'   and VM_RDF_MAP_TYPE = 0                              \' ||\n"
"\'   and RM_ENABLED = 1                                   \' ||\n"
"\' order by VM_SEQ\',\n"
"vector (_host, _root),\n"
"_host,\n"
"url,\n"
"_graph,\n"
"_base,\n"
"outhdr,\n"
"inhdr\n"
");\n"
"\n"
"if (isvector (opts) and isvector (get_keyword (\'follow-property\', opts)))\n"
"{\n"
"declare objs, arr, ids any;\n"
"\n"
"arr := get_keyword (\'follow-property\', opts);\n"
"for (declare i integer, i := 0; i < length (arr); i := i + 1)\n"
"{\n"
"if (not isiri_id (arr[i]))\n"
"arr[i] := iri_to_id (arr[i], 0);\n"
"}\n"
"objs := (select DB.DBA.VECTOR_AGG (id_to_iri (O)) from DB.DBA.RDF_QUAD where G = iri_to_id (_graph, 0) and P in (arr) and isiri_id (O));\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _start_path, objs, lev, 0, 0);\n"
"}\n"
"\n"
"\n"
"WS.WS.VFS_EXTRACT_RDF_CARTRIDGES (\n"
"content,\n"
"mime_type,\n"
"\'select MC_PATTERN, MC_TYPE, MC_HOOK, MC_KEY, MC_OPTIONS \' ||\n"
"\'  from DB.DBA.RDF_META_CARTRIDGES,                      \' ||\n"
"\'       WS.WS.VFS_SITE_RDF_MAP                           \' ||\n"
"\' where VM_RDF_MAP = MC_ID                               \' ||\n"
"\'   and VM_HOST = ?                                      \' ||\n"
"\'   and VM_ROOT = ?                                      \' ||\n"
"\'   and VM_RDF_MAP_TYPE = 1                              \' ||\n"
"\'   and MC_ENABLED = 1                                   \' ||\n"
"\' order by VM_SEQ\',\n"
"vector (_host, _root),\n"
"_host,\n"
"url,\n"
"_graph,\n"
"_base,\n"
"outhdr,\n"
"inhdr\n"
");\n"
"}\n"
"--src vfs.sql:2268\n"
;

static const char *proc435 = 
"#line 2406 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_EXTRACT_RDF_CARTRIDGES (\n"
"inout content any,\n"
"inout mime_type varchar,\n"
"in _sql varchar,\n"
"in _sql_options any,\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _graph varchar,\n"
"in _base varchar,\n"
"in _out_header any,\n"
"in _in_header any)\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare st, msg, meta, rows any;\n"
"declare tmp, hf, out_arr any;\n"
"\n"
"st := \'00000\';\n"
"exec (_sql, st, msg, _sql_options, vector (\'use_cache\', 1), meta, rows);\n"
"if (\'00000\' <> st)\n"
"return 0;\n"
"\n"
"hf := rfc1808_parse_uri (_url);\n"
"hf[0] := \'\';\n"
"hf[1] := \'\';\n"
"hf[5] := \'\';\n"
"hf := WS.WS.VFS_URI_COMPOSE (hf);\n"
"foreach (any row in rows) do\n"
"{\n"
"declare val_match, pcols, new_opts, aq any;\n"
"\n"
"if (row[1] = \'MIME\')\n"
"{\n"
"val_match := mime_type;\n"
"}\n"
"else if ((row[1] = \'URL\') or (row[1] = \'HTTP\'))\n"
"{\n"
"val_match := _base;\n"
"}\n"
"else\n"
"{\n"
"val_match := null;\n"
"}\n"
"\n"
"aq := null;\n"
"if (isstring (val_match) and regexp_match (row[0], val_match) is not null)\n"
"{\n"
"if (__proc_exists (row[2]) is null)\n"
"goto try_next_mapper;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"goto try_next_mapper;\n"
"};\n"
"\n"
"new_opts := vector_concat (row[4], vector (\'disable-clean\', \'Y\'));\n"
"if (row[1] <> \'HTTP\')\n"
"{\n"
"rc := call (row[2]) (_graph, _base, null, content, aq, aq, row[3], new_opts);\n"
"}\n"
"else\n"
"{\n"
"tmp := \'GET \' || hf || \' HTTP/1.1\\r\\nHost: \' || _host || \'\\r\\n\' || _out_header;\n"
"tmp := replace (replace (tmp, \'\\r\', \'\\n\'), \'\\n\\n\', \'\\n\');\n"
"out_arr := split_and_decode (tmp, 0, \'\\0\\0\\n\');\n"
"rc := call (row[2]) (_graph, _url, null, content, aq, aq, vector (out_arr, _in_header), new_opts);\n"
"}\n"
"\n"
"if (rc < 0 or rc > 0)\n"
"return;\n"
"}\n"
"try_next_mapper:;\n"
"}\n"
"return 1;\n"
"}\n"
"--src vfs.sql:2404\n"
;

static const char *proc436 = 
"#line 2486 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SITEMAP_ENSURE_NEW_SITE (\n"
"in _host varchar,\n"
"in _root varchar,\n"
"in _new_host varchar,\n"
"in _new_url varchar)\n"
"{\n"
"if (not exists (select 1 from WS.WS.VFS_SITE where VS_HOST = _new_host and VS_ROOT = _root))\n"
"{\n"
"insert into WS.WS.VFS_SITE (VS_HOST, VS_ROOT, VS_URL, VS_SRC, VS_OWN, VS_DEL, VS_NEWER, VS_FOLLOW, VS_NFOLLOW, VS_METHOD, VS_OTHER, VS_DESCR, VS_EXTRACT_FN, VS_STORE_FN, VS_DEPTH, VS_STORE, VS_DLOAD_META, VS_UDATA)\n"
"select _new_host, _root, _new_url, VS_SRC, VS_OWN, VS_DEL, VS_NEWER, VS_FOLLOW, VS_NFOLLOW, VS_METHOD, VS_OTHER, VS_DESCR ||\':\'|| _new_host, VS_EXTRACT_FN, VS_STORE_FN, VS_DEPTH, VS_STORE, VS_DLOAD_META, VS_UDATA\n"
"from WS.WS.VFS_SITE\n"
"where VS_HOST = _host and VS_ROOT = _root;\n"
"}\n"
"}\n"
"--src vfs.sql:2484\n"
;

static const char *proc437 = 
"#line 2502 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SITEMAP_URLS_REGISTER (\n"
"in _host varchar,\n"
"in _root varchar,\n"
"in src_url varchar,\n"
"inout xp any,\n"
"in lev int := 0,\n"
"in sm int := 0,\n"
"in delta int := 1)\n"
"{\n"
"declare _flw_s, _nflw_s, _url, _img, origin_iri varchar;\n"
"declare urls, inx, len, dict any;\n"
"\n"
"dict := dict_new (1000);\n"
"whenever not found goto no_ini;\n"
"select VS_FOLLOW, VS_NFOLLOW, VS_URL, VS_SRC\n"
"into _flw_s, _nflw_s, _url, _img\n"
"from WS.WS.VFS_SITE\n"
"where VS_HOST = _host and VS_ROOT = _root;\n"
"\n"
"origin_iri := iri_to_id (WS.WS.MAKE_URL (_host, src_url), 1);\n"
"len := length (xp);\n"
"urls := make_array (len, \'any\');\n"
"inx := 0;\n"
"foreach (any u in xp) do\n"
"{\n"
"declare hf, host, sch, url, abs_url varchar;\n"
"declare ts datetime;\n"
"\n"
"ts := null;\n"
"if (isvector (u))\n"
"{\n"
"ts := u[1];\n"
"if (ts is null) ts := now ();\n"
"u :=  cast (u[0] as varchar);\n"
"}\n"
"else\n"
"{\n"
"u := cast (u as varchar);\n"
"}\n"
"abs_url := u;\n"
"hf := WS.WS.PARSE_URI (u);\n"
"host := hf[1];\n"
"sch := hf [0];\n"
"hf [0] := \'\';\n"
"hf [1] := \'\';\n"
"hf [5] := \'\';\n"
"url := WS.WS.VFS_URI_COMPOSE (hf);\n"
"if ((host <> _host) or ((sch <> \'http\') and (sch <> \'https\')))\n"
"{\n"
"url := abs_url;\n"
"hf := WS.WS.PARSE_URI (url);\n"
"hf [5] := \'\';\n"
"url := WS.WS.VFS_URI_COMPOSE (hf);\n"
"}\n"
"urls [inx] := url;\n"
"inx := inx + 1;\n"
"if (WS.WS.FOLLOW (_host, _root, url, _flw_s, _nflw_s, _url, _img))\n"
"{\n"
"insert soft WS.WS.VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_STAT, VQ_ROOT, VQ_LEVEL, VQ_VIA_SITEMAP, VQ_ORIGIN)\n"
"values (_host, now (), url, \'waiting\', _root, lev, sm, origin_iri);\n"
"if (row_count () = 0)\n"
"{\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = url and VQ_TS < ts;\n"
"}\n"
"commit work;\n"
"dict_put (dict, url, 1);\n"
"}\n"
"}\n"
"if (delta)\n"
"delete from WS.WS.VFS_QUEUE where VQ_HOST = _host and VQ_ROOT = _root and VQ_ORIGIN = origin_iri and not dict_get (dict, VQ_URL, 0);\n"
"if (length (xp))\n"
"update WS.WS.VFS_SITE set VS_IS_SITEMAP = 1 where VS_HOST = _host and VS_ROOT = _root and VS_IS_SITEMAP = 0;\n"
"commit work;\n"
"no_ini:\n"
"return;\n"
"}\n"
"--src vfs.sql:2500\n"
;

static const char *proc438 = 
"#line 2580 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SITEMAP_GET_LOC (\n"
"inout xt any,\n"
"in qr varchar,\n"
"in loc varchar,\n"
"in ts varchar)\n"
"{\n"
"declare xp, res any;\n"
"declare i integer;\n"
"\n"
"xp := xpath_eval (qr, xt, 0);\n"
"res := make_array (length (xp), \'any\');\n"
"i := 0;\n"
"foreach (any x in xp) do\n"
"{\n"
"declare l, t any;\n"
"l := cast (xpath_eval (loc, x) as varchar);\n"
"t := xpath_eval (ts, x);\n"
"if (t is not null)\n"
"t := cast (cast (t as varchar) as datetime);\n"
"res[i] := vector (l, t);\n"
"i := i + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src vfs.sql:2578\n"
;

static const char *proc439 = 
"#line 2606 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SITEMAP_XML_PARSE (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"inout _content varchar,\n"
"in _c_type varchar := null,\n"
"in lev int := 0)\n"
"{\n"
"declare xt, xp any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"return;\n"
"};\n"
"\n"
"xt := null;\n"
"if (_url like \'%.xml.gz\')\n"
"{\n"
"if (length (_content) > 2)\n"
"{\n"
"declare magic varchar;\n"
"magic := subseq (_content, 0, 2);\n"
"if (magic[0] = 0hex1f and magic[1] = 0hex8b)\n"
"_content := gzip_uncompress (_content);\n"
"}\n"
"}\n"
"if (_url like \'%.xml\' or _url like \'%.xml.gz\' or _c_type = \'text/xml\' or _c_type = \'application/xml\' or _c_type = \'application/sparql-results+xml\')\n"
"{\n"
"xt := xtree_doc (_content);\n"
"if (xpath_eval (\'/urlset/dataset/dataDumpLocation\', xt) is not null)\n"
"{\n"
"declare ts any;\n"
"xp := xpath_eval (\'/urlset/dataset/dataDumpLocation/text()\', xt, 0);\n"
"ts := xpath_eval (\'/urlset/dataset/lastmod/text()\', xt);\n"
"if (ts is not null)\n"
"{\n"
"declare ar any;\n"
"declare i integer;\n"
"\n"
"i := 0;\n"
"ts := cast (cast (ts as varchar) as datetime);\n"
"ar := make_array (length (xp), \'any\');\n"
"foreach (any x in xp) do\n"
"{\n"
"ar[i] := vector (cast (x as varchar), ts);\n"
"i := i + 1;\n"
"}\n"
"xp := ar;\n"
"}\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 0);\n"
"}\n"
"else if (xpath_eval (\'/sitemapindex/sitemap/loc\', xt) is not null)\n"
"{\n"
"\n"
"xp := WS.WS.SITEMAP_GET_LOC (xt, \'/sitemapindex/sitemap\', \'./loc/text()\', \'./lastmod/text()\');\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 0);\n"
"}\n"
"else if (_c_type = \'application/sparql-results+xml\')\n"
"{\n"
"xp := xpath_eval (\'/sparql/results/result/binding/uri/text()\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 0);\n"
"}\n"
"else if (xpath_eval (\'/urlset/url/loc\', xt) is not null)\n"
"{\n"
"\n"
"xp := WS.WS.SITEMAP_GET_LOC (xt, \'/urlset/url\', \'./loc/text()\', \'./lastmod/text()\');\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 1);\n"
"}\n"
"else if (xpath_eval (\'/urlset/dataset/sampleURI\', xt) is not null)\n"
"{\n"
"xp := xpath_eval (\'/urlset/dataset/sampleURI/text()\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 1);\n"
"}\n"
"}\n"
"}\n"
"--src vfs.sql:2604\n"
;

static const char *proc440 = 
"#line 2683 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.SITEMAP_RDF_STORE (\n"
"in _host varchar,\n"
"in _url varchar,\n"
"in _root varchar,\n"
"inout _content varchar,\n"
"in _s_etag varchar,\n"
"in _c_type varchar,\n"
"in store_flag int := 1,\n"
"in udata any := null,\n"
"in lev int := 0)\n"
"{\n"
"declare graph, use_tidy, url_ck, base varchar;\n"
"\n"
"graph := null;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"update WS.WS.VFS_QUEUE\n"
"set VQ_STAT = \'error\', VQ_ERROR = __SQL_MESSAGE\n"
"where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = _url;\n"
"commit work;\n"
"return;\n"
"};\n"
"\n"
"if (isvector (udata) and isstring (get_keyword (\'rdf-graph\', udata)))\n"
"graph := get_keyword (\'rdf-graph\', udata, \'\');\n"
"use_tidy := \'N\';\n"
"if (isvector (udata) and isstring (get_keyword (\'use-tidy\', udata)))\n"
"use_tidy := get_keyword (\'use-tidy\', udata, \'N\');\n"
"base := WS.WS.MAKE_URL (_host, _url);\n"
"if (not length (graph))\n"
"graph := base;\n"
"url_ck := _url;\n"
"if (_url like \'%.gz\')\n"
"{\n"
"if (length (_content) > 2)\n"
"{\n"
"declare magic varchar;\n"
"magic := subseq (_content, 0, 2);\n"
"if (magic[0] = 0hex1f and magic[1] = 0hex8b)\n"
"_content := gzip_uncompress (_content);\n"
"}\n"
"url_ck := regexp_replace (_url, \'\\.gz\\x24\', \'\');\n"
"}\n"
"if (url_ck like \'%.rdf\' or _c_type = \'application/rdf+xml\')\n"
"{\n"
"DB.DBA.RDF_LOAD_RDFXML (_content, base, graph, 0, 3);\n"
"}\n"
"else if (url_ck like \'%.n3\' or url_ck like \'%.ttl\' or url_ck like \'%.nt\' or _c_type = \'text/n3\' or _c_type = \'text/rdf+n3\')\n"
"{\n"
"DB.DBA.TTLP (_content, base, graph, 255, 3);\n"
"}\n"
"else if (_c_type = \'text/html\')\n"
"{\n"
"if (tidy_external () and use_tidy = \'Y\')\n"
"_content := tidy_html (_content, \'output-xhtml:yes\\r\\ntidy-mark:no\');\n"
"DB.DBA.RDF_LOAD_RDFA (_content, base, graph, 2);\n"
"}\n"
"if (isvector (udata) and isvector (get_keyword (\'follow-property\', udata)))\n"
"{\n"
"declare objs, arr, ids any;\n"
"\n"
"arr := get_keyword (\'follow-property\', udata);\n"
"for (declare i integer, i := 0; i < length (arr); i := i + 1)\n"
"{\n"
"if (not isiri_id (arr[i]))\n"
"arr[i] := iri_to_id (arr[i], 0);\n"
"}\n"
"objs := (select DB.DBA.VECTOR_AGG (id_to_iri (O)) from DB.DBA.RDF_QUAD where G = iri_to_id (graph, 0) and P in (arr) and isiri_id (O));\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, objs, lev, 0, 0);\n"
"}\n"
"if (_c_type = \'text/html\' and isvector (udata) and 1 = get_keyword (\'follow-meta\', udata, 0))\n"
"{\n"
"declare xt, xp any;\n"
"xt := xtree_doc (_content, 2);\n"
"xp := xpath_eval (\'/html/head/link[@rel=\"meta\"]/@href\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, _url, xp, lev, 0, 0);\n"
"}\n"
"insert soft WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"\n"
"if (row_count () = 0)\n"
"update WS.WS.VFS_URL\n"
"set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag\n"
"where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"\n"
"commit work;\n"
"}\n"
"--src vfs.sql:2681\n"
;

static const char *proc441 = 
"#line 2773 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_ROBOTS_PARSE (\n"
"in txt varchar,\n"
"in ua varchar,\n"
"out delay_sec float)\n"
"{\n"
"declare s any;\n"
"declare v1 any;\n"
"declare match, exact_match, fill integer;\n"
"\n"
"s := string_output ();\n"
"http (txt, s);\n"
"v1 := \'\';\n"
"delay_sec := 0;\n"
"while (1)\n"
"{\n"
"declare l, arr any;\n"
"next:\n"
"l := ses_read_line (s, 0, 0, 1);\n"
"if (l = 0)\n"
"goto ex;\n"
"l := trim (l, \'\\r\\n \');\n"
"arr := split_and_decode (l, 0, \'\\0\\0:\');\n"
"if (arr is null)\n"
"goto next;\n"
"if (lower (arr[0]) = \'user-agent\')\n"
"{\n"
"declare u any;\n"
"u := trim (arr[1]);\n"
"fill := 0;\n"
"if (match = 0 and exact_match = 0 and u = \'*\')\n"
"{\n"
"match := 1;\n"
"fill := 1;\n"
"}\n"
"if (exact_match = 0 and u <> \'*\' and ua like u)\n"
"{\n"
"exact_match := 1;\n"
"v1 := \'\';\n"
"fill := 1;\n"
"delay_sec := 0;\n"
"}\n"
"}\n"
"else if (fill and lower (arr[0]) = \'disallow\')\n"
"{\n"
"v1 := v1 || trim (arr[1]) || \'%;\';\n"
"}\n"
"else if (fill and lower (arr[0]) = \'crawl-delay\')\n"
"{\n"
"delay_sec := atof (trim (arr[1]));\n"
"}\n"
"}\n"
"ex:\n"
"v1 := trim (v1);\n"
"if (length (v1) = 0)\n"
"v1 := null;\n"
"\n"
"return v1;\n"
"}\n"
"--src vfs.sql:2771\n"
;

static const char *proc442 = 
"#line 2833 \"[executable]/vfs.sql\"\n"
"create procedure WS.WS.VFS_ROBOTS_GET (\n"
"in _host varchar,\n"
"in _root varchar,\n"
"inout site_delay_sec float)\n"
"{\n"
"declare url, ret, head, me, robots, delay_sec any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto en;\n"
"};\n"
"\n"
"url := WS.WS.MAKE_URL (_host, \'/robots.txt\');\n"
"robots := null;\n"
"ret := http_client_ext (url=>url, headers=>head, n_redirects=>5);\n"
"if (not isvector (head) or length (head) = 0 or head[0] not like \'HTTP/1._ 200 %\')\n"
"goto en;\n"
"\n"
"me := coalesce (cfg_item_value (virtuoso_ini_path (), \'HTTPServer\', \'ClientIdString\'), \'Mozilla/4.0 (compatible; OpenLink Virtuoso)\');\n"
"robots := VFS_ROBOTS_PARSE (ret, me, delay_sec);\n"
"if (delay_sec > site_delay_sec)\n"
"site_delay_sec := delay_sec;\n"
"\n"
"en:\n"
"update WS.WS.VFS_SITE set VS_ROBOTS = robots, VS_DELAY = delay_sec where VS_HOST = _host and VS_ROOT = _root;\n"
"return robots;\n"
"}\n"
"--src vfs.sql:2831\n"
;

/* davxml2rdfxml.xsl */

static const char *xsl7[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2018 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\"\n"
"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"  xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n"
"  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n"
"  xmlns:virt=\"virt\"\n"
"  xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"\n"
"<xsl:param name=\"this-stub-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"this-real-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <rdf:RDF>\n"
"    <xsl:for-each select=\"virt:rdf\">\n"
"      <xsl:apply-templates select=\"virt:res|virt:top-res\"/>\n"
"    </xsl:for-each>\n"
"    <xsl:for-each select=\"N3\"><xsl:text>\n"
"</xsl:text><rdf:Description>\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"starts-with (@N3S, 'nodeID://')\"><xsl:attribute name=\"rdf:nodeID\"><xsl:value-of select=\"substring (@N3S, 10)\"/></xsl:attribute></xsl:when>\n"
"          <xsl:otherwise><xsl:attribute name=\"rdf:about\"><xsl:value-of select=\"@N3S\"/></xsl:attribute></xsl:otherwise>\n"
"        </xsl:choose>\n"
"        <xsl:element-rdfqname name=\"{@N3P}\">\n"
"          <xsl:if test=\"exists(@N3ID)\"><xsl:attribute name=\"rdf:ID\"><xsl:value-of select=\"@N3ID\"/></xsl:attribute></xsl:if>\n"
"          <xsl:choose>\n"
"            <xsl:when test=\"starts-with (@N3O, 'nodeID://')\"><rdf:Description rdf:nodeID=\"{substring (@N3O, 10)}\"/></xsl:when>\n"
"            <xsl:when test=\"exists (@N3O)\"><rdf:Description rdf:about=\"{@N3O}\"/></xsl:when>\n"
"            <xsl:otherwise>\n"
"              <xsl:copy-of select=\"@xml:lang\"/>\n"
"              <xsl:if test=\"*\"><xsl:attribute name=\"rdf:parseType\">Literal</xsl:attribute></xsl:if>\n"
"              <xsl:if test=\"@N3DT\"><xsl:attribute name=\"rdf:datatype\"><xsl:value-of select=\"@N3DT\"/></xsl:attribute></xsl:if>\n"
"              <xsl:copy-of select=\"node()\"/>\n"
"            </xsl:otherwise>\n"
"          </xsl:choose>\n"
"        </xsl:element-rdfqname>\n"
"      </rdf:Description>\n"
"    </xsl:for-each>\n"
"  </rdf:RDF>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res|virt:top-res\" priority=\"8\">\n"
"  <xsl:variable name=\"raw-subj\" select=\"name(*[1])\"/>\n"
"<xsl:text>\n"
"</xsl:text><rdf:Description rdf:about=\"{(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)}\">\n"
"    <xsl:for-each select=\"virt:prop\">\n"
"      <xsl:call-template name=\"make-pred\"/>\n"
"    </xsl:for-each>\n"
"  </rdf:Description>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3S]|virt:top-res[@N3S]\" priority=\"9\">\n"
"  <xsl:variable name=\"subj\" select=\"string(@N3S)\"/>\n"
"  <xsl:text>\n"
"</xsl:text><rdf:Description rdf:nodeID=\"{$subj}\">\n"
"    <xsl:for-each select=\"virt:prop\">\n"
"      <xsl:call-template name=\"make-pred\"/>\n"
"    </xsl:for-each>\n"
"  </rdf:Description>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3DUPE]|virt:top-res[@N3DUPE]\" priority=\"10\"/>\n"
"<xsl:template match=\"virt:res[empty (virt:prop)]|virt:top-res[empty (virt:prop)]\" priority=\"10\"/>\n"
"\n"
"<xsl:template name=\"make-pred\">\n"
"<xsl:text>\n"
"</xsl:text><xsl:element-rdfqname name=\"{name(*[1])}\">\n"
"    <xsl:if test=\"exists(@N3ID)\"><xsl:attribute name=\"rdf:ID\"><xsl:value-of select=\"@N3ID\"/></xsl:attribute></xsl:if>\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"virt:res[@N3S]\"><rdf:Description rdf:nodeID=\"{virt:res/@N3S}\"/></xsl:when>\n"
"      <xsl:when test=\"virt:res\">\n"
"        <xsl:variable name=\"raw-subj\" select=\"name(virt:res/*[1])\"/>\n"
"        <rdf:Description rdf:about=\"{(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)}\"/></xsl:when>\n"
"      <xsl:when test=\"virt:value\">\n"
"        <xsl:copy-of select=\"virt:value/@xml:lang\"/>\n"
"        <xsl:if test=\"virt:value/*\"><xsl:attribute name=\"rdf:parseType\">Literal</xsl:attribute></xsl:if>\n"
"        <xsl:if test=\"virt:value/@N3DT\"><xsl:attribute name=\"rdf:datatype\"><xsl:value-of select=\"virt:value/@N3DT\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"virt:value/node()\"/></xsl:when>\n"
"      <xsl:otherwise><xsl:message terminate=\"yes\">Corrupted DAV RDF XML (virt:pred has no value and no object node)</xsl:message></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:element-rdfqname>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* davxml2n3xml.xsl */

static const char *xsl8[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2018 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" xmlns:virt=\"virt\" xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"\n"
"<xsl:param name=\"this-stub-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"this-real-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:for-each select=\"virt:rdf\">\n"
"    <xsl:apply-templates select=\"virt:res|virt:top-res\"/>\n"
"  </xsl:for-each>\n"
"  <xsl:copy-of select=\"N3\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res|virt:top-res\" priority=\"8\">\n"
"  <xsl:variable name=\"raw-subj\" select=\"name(*[1])\"/>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:call-template name=\"make-pred\"><xsl:with-param name=\"subj\" select=\"(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)\"/></xsl:call-template>\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3S]|virt:top-res[@N3S]\" priority=\"9\">\n"
"  <xsl:variable name=\"subj\" select=\"string(@N3S)\"/>\n"
"  <xsl:text>\n"
"</xsl:text>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:call-template name=\"make-pred\"><xsl:with-param name=\"subj\" select=\"$subj\"/></xsl:call-template>\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3DUPE]|virt:top-res[@N3DUPE]\" priority=\"10\"/>\n"
"\n"
"<xsl:template name=\"make-pred\">\n"
"  <xsl:param name=\"subj\" />\n"
"    <xsl:text>\n"
"</xsl:text>\n"
"  <N3 N3S=\"{$subj}\" N3P=\"{name(*[1])}\">\n"
"    <xsl:if test=\"exists(@N3ID)\">\n"
"      <xsl:attribute name=\"rdf:ID\"><xsl:value-of select=\"@N3ID\"/></xsl:attribute>\n"
"    </xsl:if>\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"virt:res[@N3S]\">\n"
"        <xsl:attribute name=\"N3O\"><xsl:value-of select=\"virt:res/@N3S\"/></xsl:attribute>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"virt:res\">\n"
"        <xsl:variable name=\"raw-subj\" select=\"name(virt:res/*[1])\"/>\n"
"        <xsl:attribute name=\"N3O\"><xsl:value-of select=\"(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)\"/></xsl:attribute>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"virt:value\">\n"
"        <xsl:copy-of select=\"virt:value/@xml:lang\"/>\n"
"        <xsl:copy-of select=\"virt:value/@N3DT\"/>\n"
"        <xsl:copy-of select=\"virt:value/node()\"/>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:message terminate=\"yes\">Corrupted DAV RDF XML (virt:pred has no value and no object node)</xsl:message>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </N3>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* rdfxml2n3xml.xsl */

static const char *xsl9[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2018 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\"\n"
"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"  xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:variable name=\"n3list\">\n"
"  <xsl:apply-templates select=\"*\" mode=\"top\"/>\n"
"  </xsl:variable>\n"
"  <xsl:for-each select=\"$n3list/*\"><xsl:text>\n"
"</xsl:text><xsl:copy-of select=\".\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"rdf:RDF\" mode=\"top\">\n"
"  <xsl:apply-templates mode=\"descrlist\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"top\">\n"
"  <xsl:message terminate=\"yes\">RDF file can not contain top-level elements other than rdf:RDF</xsl:message>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"descrlist\">\n"
"  <xsl:param name=\"subj-name\">\n"
"    <xsl:call-template name=\"expand-subj-name\"/>\n"
"  </xsl:param>\n"
"  <xsl:variable name=\"lang\" select=\"ancestor-or-self::*[@xml:lang][1]/@xml:lang[. != '']\" />\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"self::rdf:Description\"/>\n"
"    <xsl:otherwise>\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{resolve-uri ($rdf-uri, 'type')}\" N3O=\"{resolve-uri (namespace-uri(.), local-name(.))}\"><xsl:copy-of select=\"$lang\"/></N3>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <xsl:for-each select=\"@*\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"self::xml:*|self::rdf:about|self::rdf:nodeID|self::rdf:ID\"/>\n"
"      <xsl:when test=\"self::rdf:type\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"        <!--TODO: carefully check composing of N3O here.\n"
"          The spec contains no explicit example of rdf:type in Property Attributes on an empty Property Element -->\n"
"        <N3 N3S=\"{$subj-name}\" N3P=\"{resolve-uri ($rdf-uri, 'type')}\" N3O=\"{resolve-uri (string ($base), .)}\"><xsl:copy-of select=\"$lang\"/></N3>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"self::rdf:parseType|self::rdf:resource|self::rdf:datatype\">\n"
"        <xsl:message terminate=\"yes\">Attribute '<xsl:value-of select=\"name(.)\"/>' can appear only in predicate element but not in description element</xsl:message>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <N3 N3S=\"{$subj-name}\" N3P=\"{resolve-uri (namespace-uri(.), local-name(.))}\"><xsl:copy-of select=\"$lang\"/><xsl:value-of select=\".\"/></N3>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:for-each>\n"
"  <xsl:apply-templates mode=\"proplist\">\n"
"    <xsl:with-param name=\"subj-name\" select=\"$subj-name\"/>\n"
"  </xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"proplist\">\n"
"  <xsl:variable name=\"lang\" select=\"ancestor-or-self::*[@xml:lang][1]/@xml:lang[. != '']\" />\n"
"  <xsl:variable name=\"base\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"      <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"p-name\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"self::rdf:li\"><xsl:value-of select=\"resolve-uri ($rdf-uri, concat('_', 1 + count (preceding-sibling::rdf:li)))\"/></xsl:when>\n"
"      <xsl:otherwise><xsl:value-of select=\"resolve-uri (namespace-uri(.), local-name(.))\"/></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"p-id\">\n"
"    <xsl:if test=\"@rdf:ID\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"      <xsl:value-of select=\"resolve-uri(string ($base), concat('#', @rdf:ID))\"/>\n"
"    </xsl:if>\n"
"  </xsl:variable>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@rdf:parseType='Literal'\">\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\">\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"node()\"/></N3>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:parseType='Resource'\">\n"
"      <xsl:variable name=\"obj-name\"><xsl:call-template name=\"expand-subj-name\"/></xsl:variable>\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{$obj-name}\">\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"      </N3>\n"
"      <xsl:apply-templates mode=\"proplist\">\n"
"        <xsl:with-param name=\"subj-name\" select=\"$obj-name\"/>\n"
"      </xsl:apply-templates>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:parseType='Collection'\">\n"
"            <!--TODO: Implement this [beep] -->\n"
"      <xsl:message terminate=\"yes\">RDF/XML syntax rdf:parseType='Collection' is not yet supported by Virtuoso.</xsl:message>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"exists (@rdf:parseType)\">\n"
"      <xsl:message terminate=\"yes\">Invalid value '<xsl:value-of select=\"@rdf:parseType\"/>' of attribute rdf:parseType of predicate '<xsl:value-of select=\"name(.)\"/>' with subject '<xsl:value-of select=\"$subj-name\"/>'</xsl:message>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:resource\">\n"
"      <xsl:if test=\"exists(node())\">\n"
"        <xsl:message terminate=\"yes\">Predicate '<xsl:value-of select=\"name(.)\"/>' with subject '<xsl:value-of select=\"$subj-name\"/>' has both children and rdf:resource</xsl:message>\n"
"      </xsl:if>\n"
"      <xsl:if test=\"@rdf:datatype\">\n"
"        <xsl:message terminate=\"yes\">Predicate '<xsl:value-of select=\"name(.)\"/>' with subject '<xsl:value-of select=\"$subj-name\"/>' has both rdf:resource and rdf:datatype</xsl:message>\n"
"      </xsl:if>\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{resolve-uri (string ($base), @rdf:resource)}\">\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"      </N3>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:datatype\">\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3DT=\"{resolve-uri (string ($base), @rdf:datatype)}\">\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"        <xsl:copy-of select=\"node()\"/>\n"
"      </N3>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"exists(*)\">\n"
"      <xsl:for-each select=\"*\">\n"
"        <xsl:variable name=\"obj-name\"><xsl:call-template name=\"expand-subj-name\"/></xsl:variable>\n"
"        <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{$obj-name}\">\n"
"          <xsl:copy-of select=\"$lang\"/>\n"
"        </N3>\n"
"        <xsl:apply-templates select=\".\" mode=\"descrlist\"><xsl:with-param name=\"subj-name\" select=\"$obj-name\"/></xsl:apply-templates>\n"
"      </xsl:for-each>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      <xsl:variable name=\"obj-attrs\" select=\"@*[not self::xml:*][not self::rdf:ID][not self::rdf:type]\"/>\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"empty ($obj-attrs)\">\n"
"          <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\">\n"
"           <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"          <xsl:copy-of select=\"$lang\"/>\n"
"          <xsl:copy-of select=\"node()\"/>\n"
"          </N3>\n"
"          <xsl:for-each select=\"@rdf:type\">\n"
"            <!--TODO: carefully check composing of N3O here. -->\n"
"            <N3 N3S=\"{$obj-name}\" N3P=\"{resolve-uri ($rdf-uri, 'type')}\" N3O=\"{resolve-uri (string ($base), .)}\"><xsl:copy-of select=\"$lang\"/></N3>\n"
"          </xsl:for-each>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:variable name=\"obj-name\"><xsl:call-template name=\"expand-subj-name\"/></xsl:variable>\n"
"          <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{$obj-name}\">\n"
"            <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"            <xsl:copy-of select=\"$lang\"/>\n"
"          </N3>\n"
"          <xsl:if test=\"exists(node())\">\n"
"            <xsl:message terminate=\"yes\">Predicate '<xsl:value-of select=\"name(.)\"/>' has both children and property attributes</xsl:message>\n"
"          </xsl:if>\n"
"          <xsl:for-each select=\"@*[not self::xml:*][not self::rdf:about][not self::rdf:nodeID][not self::rdf:ID][not self::rdf:type]\">\n"
"            <N3 N3S=\"{$obj-name}\" N3P=\"{resolve-uri (namespace-uri(.), local-name(.))}\"><xsl:copy-of select=\"$lang\"/><xsl:value-of select=\".\"/></N3>\n"
"          </xsl:for-each>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template name=\"expand-subj-name\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"1 != count(@rdf:nodeID|@rdf:ID|@rdf:about)\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"@rdf:nodeID|@rdf:ID|@rdf:about\">\n"
"          <xsl:message terminate=\"yes\">Element <xsl:value-of select=\"name()\"/> should have no more than one subject name attribute: rdf:about, rdf:nodeID, rdf:ID attributes</xsl:message>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:call-template name=\"compose-nodeID\"/>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:about\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"     <xsl:value-of select=\"resolve-uri(string ($base), @rdf:about)\"/>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:nodeID\">\n"
"      <xsl:value-of select=\"concat('nodeID://U', @rdf:nodeID)\"/>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:ID\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"     <xsl:value-of select=\"resolve-uri(string ($base), concat('#', @rdf:ID))\"/>\n"
"    </xsl:when>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"compose-nodeID\">\n"
"  <xsl:variable name=\"srcline\" select=\"xpath-debug-srcline(.)\"/>\n"
"  <xsl:variable name=\"loc-strg\">\n"
"    <xsl:for-each select=\"ancestor-or-self::*[xpath-debug-srcline(.) = $srcline]/preceding-sibling::*[xpath-debug-srcline(.) = $srcline]\">\n"
"      <xsl:value-of select=\"serialize (.)\"/>\n"
"    </xsl:for-each>\n"
"  </xsl:variable>\n"
"  <xsl:value-of select=\"concat ('nodeID://R', $srcline, 'N', string-length ($loc-strg))\"/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* n3xml2uriqahtml.xsl */

static const char *xsl10[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id$\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2018 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" xmlns:virt=\"virt\" xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"<xsl:output method=\"html\" />\n"
"\n"
"<xsl:param name=\"main-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"<html><head><title>Metadata about <xsl:value-of select=\"$main-uri\"/></title></head>\n"
"<body>\n"
"<h3>Data about <xsl:value-of select=\"$main-uri\"/> subject</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3S=$main-uri]\"><xsl:with-param name=\"hide-s\" select=\"1\"/></xsl:apply-templates>\n"
"<h3>Data about subjects that refer to <xsl:value-of select=\"$main-uri\"/> as to objects</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3O=$main-uri][@N3S!=$main-uri]\"><xsl:with-param name=\"hide-o\" select=\"1\"/></xsl:apply-templates>\n"
"<h3>Data about relations with <xsl:value-of select=\"$main-uri\"/> predicate</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3P=$main-uri][@N3S!=$main-uri][@N3O!=$main-uri]\"><xsl:with-param name=\"hide-p\" select=\"1\"/></xsl:apply-templates>\n"
"<h3>Other data</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3S!=$main-uri][@N3O!=$main-uri][@N3P!=$main-uri]\"></xsl:apply-templates>\n"
"</body>\n"
"</html>\n"
"</xsl:template>\n"
"\n"
"<xsl:template mode=\"N3\" match=\"node()\">\n"
"  <xsl:param name=\"hide-s\"/>\n"
"  <xsl:param name=\"hide-p\"/>\n"
"  <xsl:param name=\"hide-o\"/>\n"
"[\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$hide-s\">(S)</xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"uri\"><xsl:with-param name=\"uri\" select=\"@N3S\"/></xsl:call-template></xsl:otherwise>\n"
"  </xsl:choose>\n"
",\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$hide-p\">(P)</xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"uri\"><xsl:with-param name=\"uri\" select=\"@N3P\"/></xsl:call-template></xsl:otherwise>\n"
"  </xsl:choose>\n"
",\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"not exists (@N3O)\"><xsl:call-template name=\"value\"/></xsl:when>\n"
"    <xsl:when test=\"$hide-o\">(O)</xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"uri\"><xsl:with-param name=\"uri\" select=\"@N3O\"/></xsl:call-template></xsl:otherwise>\n"
"  </xsl:choose>\n"
"]\n"
"  <br/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"uri\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"starts-with ($uri, concat ($main-uri, '#'))\"><a href=\"{$uri}\"><xsl:value-of select=\"substring ($uri, string-length ($main-uri) + 1)\"/></a></xsl:when>\n"
"    <xsl:when test=\"starts-with ($uri, 'http:')\"><a href=\"{$uri}\"><xsl:value-of select=\"$uri\"/></a></xsl:when>\n"
"    <xsl:otherwise><xsl:value-of select=\"$uri\"/></xsl:otherwise>\n"
"  </xsl:choose>\n"
"  (<a href=\"/uriqa/?uri={urlify($uri)}&amp;format=text/html\">meta</a>)\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"value\">\n"
"<xsl:value-of select=\".\"/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* uriqa.sql */

static const char *tbl2 = 
"create table WS.WS.URIQA_HANDLER\n"
"(\n"
"UH_ID integer not null primary key,\n"
"UH_ORDER integer not null,\n"
"UH_NAME varchar not null unique,\n"
"UH_MATCH_COND varchar not null,\n"
"UH_MATCH_ENV any,\n"
"UH_HANDLER varchar not null,\n"
"UH_HANDLER_ENV any\n"
")\n"
"create index URIQA_HANDLER_ORDER_NAME on WS.WS.URIQA_HANDLER (UH_ORDER, UH_NAME)\n";

static const char *proc443 = 
"#line 44 \"[executable]/uriqa.sql\"\n"
"create function WS.WS.URIQA_CFG_ITEM_VALUE (in param_name varchar, in is_list integer, in dflt_value varchar)\n"
"{\n"
"declare ini_path varchar;\n"
"declare string_val varchar;\n"
"declare list_val any;\n"
"ini_path := virtuoso_ini_path ();\n"
"string_val := virtuoso_ini_item_value (\'URIQA\', param_name);\n"
"if (string_val is not null)\n"
"{\n"
"if (is_list)\n"
"{\n"
"declare ctr, len integer;\n"
"list_val := split_and_decode (string_val, 0, \'\\0\\0,\');\n"
"len := length (list_val);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"list_val[ctr] := trim (list_val[ctr]);\n"
"}\n"
"string_val := serialize (list_val);\n"
"}\n"
"if (string_val <> cast (registry_get (\'URIQA\' || param_name) as varchar))\n"
"registry_set (\'URIQA\' || param_name, string_val);\n"
"if (is_list)\n"
"return list_val;\n"
"return string_val;\n"
"}\n"
"string_val := registry_get (\'URIQA\' || param_name);\n"
"if (not isstring (string_val))\n"
"{\n"
"if (dflt_value is null)\n"
"return null;\n"
"registry_set (\'URIQA\' || param_name, dflt_value);\n"
"return dflt_value;\n"
"}\n"
"if (is_list)\n"
"return deserialize (string_val);\n"
"return string_val;\n"
"}\n"
"--src uriqa.sql:42\n"
;

static const char *proc444 = 
"#line 84 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.URIQA_LOAD_FROM_INI ()\n"
"{\n"
"declare default_host, local_host_names, local_host_masks, our_fingerprint varchar;\n"
"declare ctr integer;\n"
"default_host		:= WS.WS.URIQA_CFG_ITEM_VALUE (\'DefaultHost\'	, 0	, \'localuriqaserver\'	);\n"
"local_host_names	:= WS.WS.URIQA_CFG_ITEM_VALUE (\'LocalHostNames\'	, 1	, null			);\n"
"local_host_masks	:= WS.WS.URIQA_CFG_ITEM_VALUE (\'LocalHostMasks\'	, 1	, null			);\n"
"our_fingerprint		:= WS.WS.URIQA_CFG_ITEM_VALUE (\'Fingerprint\'	, 0	, uuid()		);\n"
"if (local_host_names is null or length (local_host_names) = 0)\n"
"delete from WS.WS.URIQA_HANDLER where UH_ID=1;\n"
"else\n"
"{\n"
"insert soft WS.WS.URIQA_HANDLER\n"
"( UH_ID	, UH_ORDER	, UH_NAME			, UH_MATCH_COND	, UH_MATCH_ENV		, UH_HANDLER	, UH_HANDLER_ENV	)\n"
"values\n"
"( 1	, 100		, \'virt:LocalHostNames\'		, \'server in\'	, vector ()		, \'LOCALDAV\'	, null			);\n"
"update WS.WS.URIQA_HANDLER set\n"
"UH_NAME = \'virt:LocalHostNames\',\n"
"UH_MATCH_COND = \'server in\',\n"
"UH_MATCH_ENV = local_host_names\n"
"where UH_ID = 1 and (\n"
"(UH_NAME <> \'virt:LocalHostNames\') or\n"
"(UH_MATCH_COND <> \'server in\') or\n"
"serialize (UH_MATCH_ENV) <> serialize (local_host_names) );\n"
"}\n"
"if (local_host_masks is null or length (local_host_masks) = 0)\n"
"delete from WS.WS.URIQA_HANDLER where UH_ID=2;\n"
"else\n"
"{\n"
"insert soft WS.WS.URIQA_HANDLER\n"
"( UH_ID	, UH_ORDER	, UH_NAME			, UH_MATCH_COND	, UH_MATCH_ENV		, UH_HANDLER	, UH_HANDLER_ENV	)\n"
"values\n"
"( 2	, 100		, \'virt:LocalHostMasks\'		, \'server like in\'	, vector ()	, \'LOCALDAV\'	, null			);\n"
"update WS.WS.URIQA_HANDLER set\n"
"UH_NAME = \'virt:LocalHostMasks\',\n"
"UH_MATCH_COND = \'server like in\',\n"
"UH_MATCH_ENV = local_host_masks\n"
"where UH_ID = 2 and (\n"
"(UH_NAME <> \'virt:LocalHostMasks\') or\n"
"(UH_MATCH_COND <> \'server like in\') or\n"
"serialize (UH_MATCH_ENV) <> serialize (local_host_masks) );\n"
"}\n"
"insert soft WS.WS.URIQA_HANDLER\n"
"( UH_ID	, UH_ORDER	, UH_NAME		, UH_MATCH_COND	, UH_MATCH_ENV			, UH_HANDLER	, UH_HANDLER_ENV	)\n"
"values\n"
"( 100	, 999		, \'redir\'		, \'schema =\'	, \'http\'			, \'NATIVE_HTTP\'	, null			);\n"
"}\n"
"--src uriqa.sql:82\n"
;

static const char *other14 = 
"WS.WS.URIQA_LOAD_FROM_INI ()\n";
static const char *proc445 = 
"#line 136 \"[executable]/uriqa.sql\"\n"
"create function WS.WS.URIQA_FULL_URI (inout path varchar, inout params varchar, inout lines varchar, in parse_params integer, in trim_prefix integer) returns varchar\n"
"{\n"
"declare explicit_uri, host, head_uri, res varchar;\n"
"declare pairs any;\n"
"\n"
"explicit_uri := http_request_header (lines, \'URIQA-uri\');\n"
"if (isstring (explicit_uri))\n"
"return explicit_uri;\n"
"if (parse_params)\n"
"{\n"
"res := get_keyword (\'uri\', params);\n"
"if (res is not null)\n"
"goto complete;\n"
"}\n"
"\n"
"pairs := regexp_parse (\'^([A-Za-z]+)([ \\\\t]+)([^ \\\\t\\\\r\\\\n]+)(([ \\\\t]+)HTTP([^ \\\\t\\\\r\\\\n]+))?[ \\\\t\\\\r\\\\n]*\\044\', lines[0], 0);\n"
"if (pairs is null)\n"
"{\n"
"\n"
"res := NULL;\n"
"goto complete;\n"
"}\n"
"head_uri := split_and_decode (subseq (lines[0], pairs[6], pairs[7]), 0, \'%+\');\n"
"if (trim_prefix and upper (head_uri) like \'/URIQA/%\')\n"
"head_uri := subseq (head_uri, 6);\n"
"\n"
"host := http_request_header (lines, \'Host\');\n"
"if (isstring (host))\n"
"res := WS.WS.EXPAND_URL (concat (\'http://\', host, \'/\'), head_uri);\n"
"else\n"
"res := head_uri;\n"
"\n"
"complete:\n"
"\n"
"return res;\n"
"}\n"
"--src uriqa.sql:134\n"
;

static const char *proc446 = 
"#line 174 \"[executable]/uriqa.sql\"\n"
"create function WS.WS.URIQA_APPLY_TRIGGERS (in op varchar, inout uri varchar, inout body any, inout params varchar, inout lines varchar) returns any\n"
"{\n"
"declare split, err_ret any;\n"
"split := rfc1808_parse_uri (uri);\n"
"\n"
"declare is_final integer;\n"
"is_final := 0;\n"
"for (select UH_MATCH_COND, UH_MATCH_ENV, UH_HANDLER, UH_HANDLER_ENV from WS.WS.URIQA_HANDLER) do\n"
"{\n"
"if (UH_MATCH_COND = \'schema =\')\n"
"{\n"
"if (split[0] = UH_MATCH_ENV)\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server =\')\n"
"{\n"
"if (split[1] = UH_MATCH_ENV)\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server like\')\n"
"{\n"
"if (split[1] like UH_MATCH_ENV)\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server in\')\n"
"{\n"
"if (position (split[1], UH_MATCH_ENV))\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server like in\')\n"
"{\n"
"foreach (varchar srv_mask in UH_MATCH_ENV) do\n"
"{\n"
"if (split[1] like srv_mask)\n"
"goto match;\n"
"}\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'default\')\n"
"{\n"
"goto match;\n"
"}\n"
"return vector (\'URIQA\', 0, \'500\', sprintf (\'Configuration error: unknown UH_MATCH_COND \"%s\" in WS.WS.URIQA_HANDLER\', UH_MATCH_COND));\n"
"match:\n"
"err_ret := call (\'WS.WS.URIQA_HANDLER_\' || UH_HANDLER)(op, uri, split, body, params, lines, UH_HANDLER_ENV, is_final);\n"
"if (is_final)\n"
"return err_ret;\n"
"no_match:\n"
" ;\n"
"}\n"
"return vector (\'URIQA\', 0, \'404\', sprintf (\'URIQA server has no way to access resource \"%s\"\', uri));\n"
"}\n"
"--src uriqa.sql:172\n"
;

static const char *proc447 = 
"#line 232 \"[executable]/uriqa.sql\"\n"
"create function WS.WS.URIQA_N3_DIR_LIST (inout split any, in a_uid integer)\n"
"{\n"
"declare diritems any;\n"
"declare acc any;\n"
"declare ctr, len integer;\n"
"declare s_path, s_uri varchar;\n"
"s_path := split[2];\n"
"diritems := DAV_DIR_LIST_INT (s_path, 0, \'%\', null, null, a_uid);\n"
"if (DAV_HIDE_ERROR (diritems) is null)\n"
"return null;\n"
"xte_nodebld_init (acc);\n"
"len := length (diritems);\n"
"s_uri := concat (split[0], \'://\', split[1], s_path);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"declare o_uri varchar;\n"
"if (\'R\' = diritems[ctr][1])\n"
"o_uri := concat (s_uri, diritems[ctr][10]);\n"
"else\n"
"o_uri := concat (s_uri, diritems[ctr][10], \'/\');\n"
"xte_nodebld_acc (acc, xte_node (xte_head (\'N3\', \'N3S\', s_uri, \'N3P\', UNAME\'http://www.openlinksw.com/schemas/virtdav#contains\', \'N3O\', o_uri)));\n"
"}\n"
"if (length (s_path) > 1)\n"
"{\n"
"declare p_path, p_uri varchar;\n"
"declare rslash integer;\n"
"p_path := \"LEFT\" (s_path, length (s_path) - 1);\n"
"rslash := strrchr (p_path, \'/\');\n"
"p_path := \"LEFT\" (s_path, rslash+1);\n"
"p_uri := concat (split[0], \'://\', split[1], p_path);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (\'N3\', \'N3S\', p_uri, \'N3P\', UNAME\'http://www.openlinksw.com/schemas/virtdav#contains\', \'N3O\', s_uri)));\n"
"}\n"
"xte_nodebld_final (acc, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (acc);\n"
"}\n"
"--src uriqa.sql:230\n"
;

static const char *proc448 = 
"#line 269 \"[executable]/uriqa.sql\"\n"
"create function DB.DBA.\"DAV_EXTRACT_DYN_RDF_application/xbel+xml\" (in id any, inout split any, inout old_prop any, in a_uid integer) returns any\n"
"{\n"
"declare ses, tree, label, roots any;\n"
"declare cont_type, res_uri, root_uri, sub_uri varchar;\n"
"declare rc integer;\n"
"declare acc any;\n"
"\n"
"ses := string_output ();\n"
"rc := DAV_RES_CONTENT_INT (id, ses, cont_type, 1, 0);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return null;\n"
"tree := xtree_doc (ses, 0);\n"
"\n"
"res_uri := sprintf (\'%s://%s%s\', split[0], split[1], split[2]);\n"
"xte_nodebld_init (acc);\n"
"if (length (split[5]) > 0)\n"
"{\n"
"label := split_and_decode (split[5], 0, \'%+\');\n"
"root_uri := sprintf (\'%s#%U\', res_uri, label);\n"
"roots := xpath_eval (\'/xbel//*[self::folder|self::bookmark][substring (concat (@id, \"-\", title), 1, 40) = \\044label]\', tree, 0, vector (\'label\', label));\n"
"if (roots is not null)\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.openlinksw.com/virtdav#storedIn\', UNAME\'N3O\', res_uri)));\n"
"}\n"
"else\n"
"{\n"
"label := \'\';\n"
"root_uri := res_uri;\n"
"roots := xpath_eval (\'/xbel\', tree, 0);\n"
"}\n"
"foreach (any root in roots) do\n"
"{\n"
"declare rdftype, title, root_id, descr, href, parent varchar;\n"
"declare children any;\n"
"rdftype := \'http://www.python.org/topics/xml/xbel/\' || xpath_eval (\'local-name(.)\', root);\n"
"\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\', UNAME\'N3O\', rdftype)));\n"
"if (rdftype <> \'http://www.python.org/topics/xml/xbel/xbel\')\n"
"{\n"
"title := xpath_eval (\'string (title)\', root);\n"
"if (title <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/title\'), title));\n"
"descr := xpath_eval (\'string (description)\', root);\n"
"if (descr <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/description\'), descr));\n"
"root_id := xpath_eval (\'@id\', root);\n"
"if (root_id <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/id\'), root_id));\n"
"href := xpath_eval (\'@href\', root);\n"
"if (href <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/id\', UNAME\'N3O\', href)));\n"
"parent := xpath_eval (\'substring (concat (../@id, \"-\", ../title), 1, 40)\', root);\n"
"if (parent <> \'\')\n"
"{\n"
"parent := sprintf (\'%s#%U\', res_uri, parent);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.openlinksw.com/virtdav#parentFragment\', UNAME\'N3O\', parent)));\n"
"}\n"
"}\n"
"children := xpath_eval (\'folder|bookmark\', root, 0);\n"
"foreach (any child in children) do\n"
"{\n"
"declare c_uri varchar;\n"
"declare c_rdftype, c_title, c_id, c_href nvarchar;\n"
"c_uri := xpath_eval (\'substring (concat (@id, \"-\", title), 1, 40)\', child);\n"
"if (c_uri <> \'-\')\n"
"{\n"
"c_uri := sprintf (\'%s#%U\', res_uri, c_uri);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.openlinksw.com/virtdav#parentFragment\', UNAME\'N3O\', root_uri)));\n"
"c_rdftype := \'http://www.python.org/topics/xml/xbel/\' || xpath_eval (\'local-name(.)\', child);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\', UNAME\'N3O\', c_rdftype)));\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', c_rdftype, UNAME\'N3O\', c_uri)));\n"
"c_title := xpath_eval (\'string(title)\', child);\n"
"if (c_title <> N\'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/title\'), c_title));\n"
"c_id := xpath_eval (\'@id\', child);\n"
"if (c_id <> N\'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/id\'), c_id));\n"
"c_href := xpath_eval (\'@href\', child);\n"
"if (c_href <> N\'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/href\', UNAME\'N3O\', c_href)));\n"
"}\n"
"}\n"
"}\n"
"xte_nodebld_final (acc, xte_head (UNAME\' root\'));\n"
"acc := xml_tree_doc (acc);\n"
"\n"
"return acc;\n"
"\n"
"}\n"
"--src uriqa.sql:267\n"
;

static const char *proc449 = 
"#line 359 \"[executable]/uriqa.sql\"\n"
"create function WS.WS.URIQA_HANDLER_LOCALDAV (inout op varchar, inout uri varchar, inout split any, inout body any, inout params varchar, inout lines varchar, inout app_env any, inout is_final integer) returns any\n"
"{\n"
"declare id, old_prop, old_descr, rc any;\n"
"declare uid, a_uid, a_gid integer;\n"
"declare st, a_uname, a_pwd, a_perms, res_path varchar;\n"
"\n"
"old_descr := null;\n"
"res_path := split[2];\n"
"is_final := 1;\n"
"if (res_path = \'\')\n"
"{\n"
"return vector (\'URIQA\', -1, \'404\', \'Invalid URI; Ill formed or missing path to the resource\');\n"
"}\n"
"if ((split[3] <> \'\') or (split[4] <> \'\'))\n"
"{\n"
"return vector (\'URIQA\', -1, \'404\', \'Invalid URI; Virtuoso DAV does not support URIs that contain parameters\');\n"
"}\n"
"if ((split[5] <> \'\') and (\'MGET\' <> op))\n"
"return vector (\'URIQA\', -1, \'500\', \'Virtuoso DAV does not support MPUT and MDELETE on subject URIs that have fragment\');\n"
"if (\"RIGHT\"(res_path, 1) = \'/\')\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"id := DAV_SEARCH_ID (res_path, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"if ((id = -1) and (st = \'R\') and (split[5] = \'\'))\n"
"{\n"
"declare id_try2 any;\n"
"id_try2 := DAV_SEARCH_ID (res_path || \'/\', \'C\');\n"
"if (DAV_HIDE_ERROR (id_try2) is not null)\n"
"{\n"
"id := id_try2;\n"
"st := \'C\';\n"
"res_path := res_path || \'/\';\n"
"split[2] := res_path;\n"
"uri := uri || \'/\';\n"
"goto id_found;\n"
"}\n"
"}\n"
"if ((id = -1) and (\'MGET\' = op))\n"
"{\n"
"declare dct any;\n"
"dct := ((sparql define output:valmode \"LONG\" describe `iri(?:uri)`));\n"
"if (dict_size (dct) > 0)\n"
"{\n"
"old_descr := dct;\n"
"dct := 0;\n"
"goto do_op;\n"
"}\n"
"}\n"
"return vector (\'URIQA\', id, NULL, DAV_PERROR (id) || sprintf (\'; path \"%s\"\', res_path));\n"
"}\n"
"id_found:\n"
"a_uid := null;\n"
"a_gid := null;\n"
"uid := DAV_AUTHENTICATE_HTTP (id, st, case (op) when \'MGET\' then \'1__\' else \'11_\' end, 1, lines, a_uname, a_pwd, a_uid, a_gid, a_perms);\n"
"if (DAV_HIDE_ERROR (uid) is null)\n"
"return vector (\'URIQA\', id, NULL, NULL);\n"
"old_prop := DAV_PROP_GET_INT (id, st, \'http://local.virt/DAV-RDF\', 0);\n"
"if (DAV_HIDE_ERROR (old_prop) is null)\n"
"{\n"
"if (-11 <> old_prop)\n"
"return vector (\'URIQA\', old_prop, NULL, NULL);\n"
"else\n"
"old_prop := xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"else\n"
"{\n"
"declare dyn_n3 any;\n"
"declare container_type varchar;\n"
"old_prop := xml_tree_doc (deserialize (blob_to_string (old_prop)));\n"
"container_type := xpath_eval (\'[xmlns:v=\"virt\"] /v:rdf/v:top-res[name(*[1])=\"http://local.virt/this\"]/v:prop[name(*[1])=\"http://www.openlinksw.com/virtdav#dynRdfExtractor\"]/v:value\', old_prop);\n"
"if (container_type is not null)\n"
"{\n"
"container_type := cast (container_type as varchar);\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"goto dyn_n3_set;\n"
"};\n"
"dyn_n3 := call (\'DB.DBA.DAV_EXTRACT_DYN_RDF_\' || container_type)(id, split, old_prop, a_uid);\n"
"XMLAppendChildren (old_prop, dyn_n3);\n"
"dyn_n3_set: ;\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
" ;\n"
"}\n"
"}\n"
"do_op:\n"
"if (\'MGET\' = op)\n"
"{\n"
"declare fmt varchar;\n"
"if (old_descr is null)\n"
"{\n"
"declare dct any;\n"
"dct := ((sparql define output:valmode \"LONG\" describe `iri(?:uri)`));\n"
"if (dict_size (dct) > 0)\n"
"{\n"
"old_descr := dct;\n"
"dct := 0;\n"
"}\n"
"}\n"
"if (old_descr is not null)\n"
"{\n"
"declare dct_triples, descr_n3 any;\n"
"declare dct_ctr, dct_len integer;\n"
"dct_triples := dict_list_keys (old_descr, 1);\n"
"dct_len := length (dct_triples);\n"
"xte_nodebld_init (descr_n3);\n"
"for (dct_ctr := 0; dct_ctr < dct_len; dct_ctr := dct_ctr + 1)\n"
"{\n"
"declare tr, s, p any;\n"
"tr := dct_triples[dct_ctr];\n"
"s := id_to_iri (tr[0]);\n"
"p := id_to_iri (tr[1]);\n"
"if (isiri_id (tr[2]))\n"
"xte_nodebld_acc (descr_n3, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', s, UNAME\'N3P\', p, UNAME\'N3O\', id_to_iri (tr[2]))));\n"
"else\n"
"xte_nodebld_acc (descr_n3, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', s, UNAME\'N3P\', p), DB.DBA.RDF_STRSQLVAL_OF_LONG (tr[2])));\n"
"}\n"
"xte_nodebld_final (descr_n3, xte_head (UNAME\' root\'));\n"
"if (isentity (old_prop))\n"
"{\n"
"descr_n3 := xml_tree_doc (descr_n3);\n"
"XMLAppendChildren (old_prop, descr_n3);\n"
"}\n"
"else\n"
"old_prop := xml_tree_doc (descr_n3);\n"
"}\n"
"fmt := get_keyword (\'format\', params, \'application/rdf+xml\');\n"
"if (\'C\' = st)\n"
"XMLAppendChildren (old_prop, WS.WS.URIQA_N3_DIR_LIST (split, a_uid));\n"
"if ((fmt = \'application/rdf+xml\') or (fmt = \'text/xml\'))\n"
"{\n"
"http_value (xslt (\'http://local.virt/davxml2rdfxml\', old_prop, vector (\'this-real-uri\', uri)));\n"
"http_header (http_header_get () || \'Content-Type: \' || fmt || \'\\r\\n\');\n"
"}\n"
"else if (fmt = \'text/html\')\n"
"{\n"
"declare n3, html any;\n"
"n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop, vector (\'this-real-uri\', uri));\n"
"html := xslt (\'http://local.virt/n3xml2uriqahtml\', n3, vector (\'main-uri\', uri));\n"
"http_value (html);\n"
"}\n"
"else\n"
"return vector (\'URIQA\', -1, \'500\', \'Invalid GET: Virtuoso DAV support only \"application/rdf+xml\", \"text/xml\" and \"text/html\" values for \"format\"\');\n"
"is_final := 1;\n"
"return vector (\'00000\', 0, \'200\', \'OK\');\n"
"}\n"
"if (\'MPUT\' = op)\n"
"{\n"
"declare old_n3, addon_n3 any;\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop);\n"
"\n"
"addon_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', xtree_doc (body, 0));\n"
"if (addon_n3 is null)\n"
"return vector (\'URIQA\', 0, \'500\', \'Invalid MPUT: The request body contain no RDF triplets\');\n"
"if (xquery_eval (\'exists (/N3[@N3P=\"http://www.openlinksw.com/schemas/virtdav#contains\"])\', addon_n3))\n"
"return vector (\'URIQA\', 0, \'500\', \'Invalid MPUT: The request body contain triplets with read-only system predicate http://www.openlinksw.com/schemas/virtdav#contains\');\n"
"old_n3 := DAV_RDF_MERGE (old_n3, addon_n3, null, 0);\n"
"rc := DAV_PROP_SET_INT (res_path, \'http://local.virt/DAV-RDF\',\n"
"serialize (DAV_RDF_PREPROCESS_RDFXML (old_n3, N\'http://local.virt/this\', 1)),\n"
"null, null, 0, 1, 1 );\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return vector (\'URIQA\', \'400\', DAV_PERROR (rc));\n"
"is_final := 1;\n"
"return vector (\'00000\', 0, \'200\', \'OK\');\n"
"}\n"
"if (\'MDELETE\' = op)\n"
"{\n"
"declare old_n3, sub_n3 any;\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop);\n"
"\n"
"if (not xpath_eval (\'exists(/N3)\', old_n3))\n"
"goto mdelete_ok;\n"
"if (length (body) > 0)\n"
"{\n"
"sub_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', xtree_doc (body, 0));\n"
"if (sub_n3 is null)\n"
"{\n"
"return vector (\'URIQA\', 0, \'500\', \'Invalid MDELETE: The request body is not empty but contain no RDF triplets\');\n"
"}\n"
"else\n"
"old_n3 := DAV_RDF_SUBTRACT (old_n3, sub_n3);\n"
"rc := DAV_PROP_SET_INT (res_path, \'http://local.virt/DAV-RDF\',\n"
"serialize (DAV_RDF_PREPROCESS_RDFXML (old_n3, N\'http://local.virt/this\', 1)),\n"
"null, null, 0, 1, 1 );\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return vector (\'URIQA\', \'400\', DAV_PERROR (rc));\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_PROP_REMOVE_INT (res_path, \'http://local.virt/DAV-RDF\',\n"
"null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return vector (\'URIQA\', \'400\', DAV_PERROR (rc));\n"
"}\n"
"mdelete_ok:\n"
"is_final := 1;\n"
"return vector (\'00000\', 0, \'200\', \'OK\');\n"
"}\n"
"is_final := 1;\n"
"return vector (\'URIQA\', 0, \'500\', sprintf (\'Virtuoso DAV does not support URIQA operation \"%s\"\', op));\n"
"}\n"
"--src uriqa.sql:357\n"
;

static const char *proc450 = 
"#line 569 \"[executable]/uriqa.sql\"\n"
"create function WS.WS.URIQA_HANDLER_NATIVE_HTTP (inout op varchar, inout uri varchar, inout split any, inout body any, inout params varchar, inout lines varchar, inout app_env any, inout is_final integer) returns any\n"
"{\n"
"declare req_uri, req_header, resp_page, resp_header any;\n"
"declare param_ctr, param_count, line_ctr, line_count, our_fingerprint_ctr integer;\n"
"declare our_fingerprint varchar;\n"
"\n"
"our_fingerprint := \'Fingerprint\' || registry_get (\'URIQAFingerprint\');\n"
"req_uri := string_output ();\n"
"http (sprintf (\'%s://%s/uriqa/?uri=%U&method=%U&\', split[0], split[1], uri, op), req_uri);\n"
"param_count := length (params);\n"
"our_fingerprint_ctr := 0;\n"
"for (param_ctr := 1; param_ctr < param_count; param_ctr := param_ctr + 2)\n"
"{\n"
"declare pname, pvalue varchar;\n"
"pname := params[param_ctr-1];\n"
"pvalue := params[param_ctr];\n"
"if (pname = our_fingerprint)\n"
"our_fingerprint_ctr := our_fingerprint_ctr + 1;\n"
"if ((pname <> \'uri\') and (pname <> \'method\') and (pname <> \'Content\'))\n"
"{\n"
"if (isstring (pvalue))\n"
"http (sprintf (\'&%U=%U\', pname, pvalue), req_uri);\n"
"else\n"
"http (sprintf (\'&%U\', pname), req_uri);\n"
"}\n"
"}\n"
"if (our_fingerprint_ctr > 1)\n"
"{\n"
"is_final := 1;\n"
"return vector (\'URIQA\', 0, \'500\', \'Virtuoso tries to recursively access itself via HTTP to get metadata via URIQA (wrong config?)\');\n"
"}\n"
"http (sprintf (\'&%U=%U\', our_fingerprint, registry_get (\'URIQADefaultHost\')), req_uri);\n"
"req_uri := string_output_string (req_uri);\n"
"req_header := string_output ();\n"
"line_count := length (lines);\n"
"for (line_ctr := 1; line_ctr < line_count; line_ctr := line_ctr + 1)\n"
"{\n"
"declare line varchar;\n"
"line := trim (lines [line_ctr], concat (chr (13), chr(10)));\n"
"if (line_ctr > 1)\n"
"http (concat (chr (13), chr(10)), req_header);\n"
"http (line, req_header);\n"
"}\n"
"req_header := string_output_string (req_header);\n"
"\n"
"if (body is null)\n"
"resp_page := http_get (req_uri, resp_header, \'POST\', req_header, \'\');\n"
"else\n"
"resp_page := http_get (req_uri, resp_header, \'POST\', req_header, string_output_string (body));\n"
"\n"
"\n"
"http (resp_page);\n"
"is_final := 1;\n"
"if (length (resp_header) > 0)\n"
"{\n"
"declare resp_line varchar;\n"
"declare pairs any;\n"
"resp_line := resp_header[0];\n"
"pairs := regexp_parse (\'^HTTP[^ \\\\t\\\\r\\\\n]+[ \\\\t]+([0-9]+)[ \\\\t]+([^ \\\\t\\\\r\\\\n]+[^\\\\r\\\\n]*)[ \\\\t\\\\r\\\\n]*\\044\', resp_line, 0);\n"
"if (pairs is null)\n"
"return vector (\'URIQA\', 0, \'500\', \'The remote URIQA server returned an invalid header\');\n"
"return vector (\'00000\', 0, subseq (resp_line, pairs[2], pairs[3]), subseq (resp_line, pairs[4], pairs[5]));\n"
"}\n"
"return vector (\'URIQA\', 0, \'500\', \'The remote URIQA server returned an empty header\');\n"
"\n"
"}\n"
"--src uriqa.sql:567\n"
;

static const char *proc451 = 
"#line 637 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.URIQA_STATUS (in err_ret any, in signal_errors integer)\n"
"{\n"
"\n"
"if (err_ret[2] is null)\n"
"err_ret[2] := \'500\';\n"
"if (err_ret[3] is null)\n"
"err_ret[3] := coalesce (DAV_PERROR (err_ret[1]), \'OK\');\n"
"if (signal_errors)\n"
"{\n"
"if (err_ret[0] <> \'00000\')\n"
"signal (err_ret[0], sprintf (\'%d %s\', err_ret[2], err_ret[3]));\n"
"return;\n"
"}\n"
"if (err_ret[0] <> \'00000\')\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %s Error %s %s\', err_ret[2], err_ret[0], split_and_decode (err_ret[3], 0, \'\\0\\0\\n\')[0]));\n"
"http (concat (\'<pre>HTTP/1.1 \', err_ret[2], \' Error \', err_ret[0], \' \', err_ret[3], \'</pre>\'));\n"
"}\n"
"else if (err_ret[2] like \'HTTP/%\')\n"
"http_request_status (err_ret[2]);\n"
"else\n"
"http_request_status (sprintf (\'HTTP/1.1 %s %s\', err_ret[2], split_and_decode (err_ret[3], 0, \'\\0\\0\\n\')[0]));\n"
"}\n"
"--src uriqa.sql:635\n"
;

static const char *proc452 = 
"#line 665 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.\"MPUT\" (inout path varchar, inout params varchar, inout lines varchar)\n"
"{\n"
"declare b, err_ret any;\n"
"declare s_uri varchar;\n"
"\n"
"b := http_body_read ();\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"WS.WS.URIQA_STATUS (vector (__SQL_STATE, 0, \'500\', __SQL_MESSAGE), 0);\n"
"};\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 0, 0);\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (\'MPUT\', s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:663\n"
;

static const char *proc453 = 
"#line 681 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.\"MGET\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare b any;\n"
"declare s_uri, err_ret varchar;\n"
"\n"
"b := http_body_read ();\n"
"\n"
"\n"
"\n"
"\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 0, 0);\n"
"\n"
"b := null;\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (\'MGET\', s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:679\n"
;

static const char *proc454 = 
"#line 699 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.\"MDELETE\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare b any;\n"
"declare s_uri, err_ret varchar;\n"
"\n"
"b := http_body_read ();\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"WS.WS.URIQA_STATUS (vector (__SQL_STATE, 0, \'500\', __SQL_MESSAGE), 0);\n"
"};\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 0, 0);\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (\'MDELETE\', s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:697\n"
;

static const char *proc455 = 
"#line 715 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.\"/!URIQA/\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"return ;\n"
"};\n"
"declare b, err_ret any;\n"
"declare s_uri, upper_line varchar;\n"
"if (length (params) < 1)\n"
"params := __http_stream_params ();\n"
"\n"
"b := http_body_read ();\n"
"if (length (lines) > 1)\n"
"upper_line := upper(lines[0]);\n"
"else\n"
"upper_line := \'\';\n"
"if (\n"
"(upper_line like \'GET /URIQA/ HTTP/%\') or\n"
"(upper_line like \'GET /URIQA HTTP/%\') or\n"
"(trim (upper_line, \' \\r\\n\') like \'GET /URIQA/\') or\n"
"(trim (upper_line, \' \\r\\n\') like \'GET /URIQA\') )\n"
"{\n"
"http (\'<html><head><title>URIQA quick test</title></head><body>\n"
"<form method=\"GET\" action=\"/uriqa/\">\n"
"Enter URI of a resource to get metadata: <input name=\"uri\" type=\"text\"><br/>\n"
"<input name=\"format\" type=\"radio\" selected=1 value=\"application/rdf+xml\"/> RDF/XML\n"
"<input name=\"format\" type=\"radio\" selected=1 value=\"text/xml\"/> XML for HTML browsers\n"
"<input name=\"format\" type=\"radio\" value=\"text/html\"/> HTML<br/>\n"
"<input name=\"Go\" type=\"submit\" value=\"Go\">\n"
"</form>\n"
"</body></html>\' );\n"
"return;\n"
"}\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"WS.WS.URIQA_STATUS (vector (__SQL_STATE, 0, \'500\', __SQL_MESSAGE), 0);\n"
"};\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 1, 1);\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (get_keyword (\'method\', params, \'MGET\'), s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:713\n"
;

static const char *proc456 = 
"#line 758 \"[executable]/uriqa.sql\"\n"
"create procedure WS.WS.URIQA_VHOST_RESET()\n"
"{\n"
"registry_set (\'/!URIQA/\', \'no_vsp_recompile\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/URIQA/\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/uriqa/\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/uriqa\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/URIQA\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/URIQA/\', ppath=>\'/!URIQA/\', is_dav=>1, vsp_user=>\'dba\', opts=>vector(\'noinherit\', 1));\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/uriqa/\', ppath=>\'/!URIQA/\', is_dav=>1, vsp_user=>\'dba\', opts=>vector(\'noinherit\', 1));\n"
"}\n"
"--src uriqa.sql:756\n"
;

/* dav_det.sql */

static const char *proc457 = 
"#line 24 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_SPECIAL ()\n"
"{\n"
"return vector (\'IMAP\', \'S3\', \'RACKSPACE\', \'GDrive\', \'Dropbox\', \'SkyDrive\', \'Box\', \'WebDAV\', \'FTP\', \'LDP\');\n"
"}\n"
"--src dav_det.sql:22\n"
;

static const char *proc458 = 
"#line 30 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_IS_SPECIAL (\n"
"in det varchar)\n"
"{\n"
"return case when position (det, DB.DBA.DAV_DET_SPECIAL ()) then 1 else 0 end;\n"
"}\n"
"--src dav_det.sql:28\n"
;

static const char *proc459 = 
"#line 37 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_WEBDAV_BASED ()\n"
"{\n"
"return vector (\'S3\', \'RACKSPACE\', \'GDrive\', \'Dropbox\', \'SkyDrive\', \'Box\', \'WebDAV\', \'FTP\', \'LDP\');\n"
"}\n"
"--src dav_det.sql:35\n"
;

static const char *proc460 = 
"#line 43 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_IS_WEBDAV_BASED (\n"
"in det varchar)\n"
"{\n"
"return case when (DB.DBA.is_empty_or_null (det) or position (det, DB.DBA.DAV_DET_WEBDAV_BASED ())) then 1 else 0 end;\n"
"}\n"
"--src dav_det.sql:41\n"
;

static const char *proc461 = 
"#line 50 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_NAME (\n"
"in id any)\n"
"{\n"
"if (isnull (id) or isinteger (id))\n"
"return null;\n"
"\n"
"return cast (id[0] as varchar);\n"
"}\n"
"--src dav_det.sql:48\n"
;

static const char *proc462 = 
"#line 60 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_DETCOL_ID (\n"
"in id any)\n"
"{\n"
"if (isnull (id) or isinteger (id))\n"
"return id;\n"
"\n"
"return cast (id[1] as integer);\n"
"}\n"
"--src dav_det.sql:58\n"
;

static const char *proc463 = 
"#line 70 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_DAV_ID (\n"
"in id any)\n"
"{\n"
"if (isnull (id) or isinteger (id))\n"
"return id;\n"
"\n"
"return id[2];\n"
"}\n"
"--src dav_det.sql:68\n"
;

static const char *proc464 = 
"#line 80 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_NAME_FIX (\n"
"in name varchar)\n"
"{\n"
"declare N integer;\n"
"declare S varchar;\n"
"\n"
"S := vector (\'/\', \'\\\\\', \':\', \'?\', \'#\', \'&\', \'\\n\');\n"
"for (N := 0; N < length (S); N := N + 1)\n"
"{\n"
"name := replace (name, S[N], \'_\');\n"
"}\n"
"\n"
"return name;\n"
"}\n"
"--src dav_det.sql:78\n"
;

static const char *proc465 = 
"#line 96 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PATH (\n"
"in detcol_id any,\n"
"in subPath_parts any)\n"
"{\n"
"return DB.DBA.DAV_CONCAT_PATH (DB.DBA.DAV_SEARCH_PATH (detcol_id, \'C\'), subPath_parts);\n"
"}\n"
"--src dav_det.sql:94\n"
;

static const char *proc466 = 
"#line 104 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PATH_NAME (\n"
"in path varchar)\n"
"{\n"
"declare pos, l integer;\n"
"\n"
"if (isvector (path))\n"
"{\n"
"l := length (path);\n"
"if ((l > 1) and path[l-1] = \'\')\n"
"return path[l-2];\n"
"\n"
"if (l > 0)\n"
"return path[l-1];\n"
"\n"
"return null;\n"
"}\n"
"path := rtrim (path, \'/\');\n"
"pos := strrchr (path, \'/\');\n"
"if (isnull (pos))\n"
"return path;\n"
"\n"
"return subseq (path, pos+1);\n"
"}\n"
"--src dav_det.sql:102\n"
;

static const char *proc467 = 
"#line 129 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PATH_PARENT (\n"
"in path varchar,\n"
"in mode integer := 0) returns varchar\n"
"{\n"
"declare pos integer;\n"
"\n"
"path := trim (path, \'/\');\n"
"pos := strrchr (path, \'/\');\n"
"if (isnull (pos))\n"
"return case when mode then \'/\' else \'\' end;\n"
"\n"
"path := left (path, pos);\n"
"return case when mode then \'/\' || path || \'/\' else path end;\n"
"}\n"
"--src dav_det.sql:127\n"
;

static const char *proc468 = 
"#line 145 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PARENT (\n"
"in id any,\n"
"in what char(1))\n"
"{\n"
"if (what = \'R\')\n"
"return coalesce ((select RES_COL from WS.WS.SYS_DAV_RES where RES_ID = DB.DBA.DAV_DET_DAV_ID (id)), -1);\n"
"\n"
"if (what = \'C\')\n"
"return coalesce ((select COL_PARENT from WS.WS.SYS_DAV_COL where COL_ID = DB.DBA.DAV_DET_DAV_ID (id)), -1);\n"
"\n"
"return -1;\n"
"}\n"
"--src dav_det.sql:143\n"
;

static const char *proc469 = 
"#line 159 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PROPPATCH (\n"
"in id any,\n"
"in path varchar,\n"
"in pa any,\n"
"in auth_uid varchar,\n"
"in auth_pwd varchar)\n"
"{\n"
"declare retValue any;\n"
"declare j, m integer;\n"
"declare det varchar;\n"
"declare det_props, det_params any;\n"
"declare dpa, dpn, dpv any;\n"
"\n"
"det := trim (cast (xpath_eval (\'[xmlns:V=\"http://www.openlinksw.com/virtuoso/webdav/1.0/\"] ./V:name/text()\', pa) as varchar));\n"
"\n"
"\n"
"\n"
"if      (det = \'DynamicResource\' or det = \'DR\')\n"
"{\n"
"det := \'DynRes\';\n"
"}\n"
"else if (det = \'LinkedDataImport\' or det = \'LDI\')\n"
"{\n"
"det := \'rdfSink\';\n"
"}\n"
"if ((det <> \'rdfSink\') and (__proc_exists (\'DB.DBA.\' || det || \'_DAV_AUTHENTICATE_HTTP\') is null))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return 1;\n"
"}\n"
"det_params := vector ();\n"
"det_props := xpath_eval (\'[xmlns:V=\"http://www.openlinksw.com/virtuoso/webdav/1.0/\"] ./V:params/*\', pa, 0);\n"
"m := length (det_props);\n"
"for (j := 0; j < m; j := j + 1)\n"
"{\n"
"dpa := det_props[j];\n"
"dpn := cast (xpath_eval (\'local-name(.)\', dpa) as varchar);\n"
"dpv := trim (cast (xpath_eval (\'text()\', dpa) as varchar));\n"
"det_params := vector_concat (det_params, vector (dpn, dpv));\n"
"}\n"
"\n"
"if (det in (\'Box\', \'Dropbox\', \'SkyDrive\', \'GDrive\'))\n"
"{\n"
"declare expire_in integer;\n"
"declare expire_time datetime;\n"
"declare service_id, service_name, service_sid varchar;\n"
"declare qry, st, msg, meta, rows any;\n"
"\n"
"\n"
"service_id := get_keyword (\'det_serviceId\', det_params);\n"
"if      (det = \'SkyDrive\')\n"
"service_name := \'windowslive\';\n"
"else if (det = \'GDrive\')\n"
"service_name := \'google\';\n"
"else if (det = \'Box\')\n"
"service_name := \'boxnet\';\n"
"else\n"
"service_name := lcase (det);\n"
"\n"
"qry := \'select TOP 1 CS_SID                         \\n\' ||\n"
"\'  from OAUTH.DBA.CLI_SESSIONS,              \\n\' ||\n"
"\'       DB.DBA.WA_USER_OL_ACCOUNTS           \\n\' ||\n"
"\' where CS_SID = WUO_OAUTH_SID               \\n\' ||\n"
"\'   and CS_SERVICE = ?                       \\n\' ||\n"
"\'   and ((? is null) or (CS_SERVICE_ID = ?)) \\n\' ||\n"
"\'   and position (\\\'dav\\\', CS_SCOPE) > 0     \\n\' ||\n"
"\'   and WUO_U_ID = ?                         \\n\' ||\n"
"\'   and WUO_TYPE = \\\'P\\\'\';\n"
"st := \'00000\';\n"
"exec (qry, st, msg, vector (service_name, service_id, service_id, auth_uid), 0, meta, rows);\n"
"if ((\'00000\' <> st) or (length (rows) = 0))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return 1;\n"
"}\n"
"service_sid := rows[0][0];\n"
"st := \'00000\';\n"
"qry := \'select * from OAUTH.DBA.CLI_SESSIONS where CS_SID = ?\';\n"
"exec (qry, st, msg, vector (service_sid), 0, meta, rows);\n"
"if ((\'00000\' <> st) or (length (rows) = 0))\n"
"{\n"
"DB.DBA.DAV_SET_HTTP_STATUS (400);\n"
"return 1;\n"
"}\n"
"det_params := vector_concat (det_params, vector (\'Authentication\', \'Yes\'));\n"
"\n"
"if (det in (\'Box\', \'SkyDrive\', \'GDrive\'))\n"
"{\n"
"expire_time := rows[0][0];\n"
"if (isnull (expire_time) or (expire_time < now ()))\n"
"expire_time := now ();\n"
"\n"
"expire_in := datediff (\'second\', now (), expire_time);\n"
"det_params := vector_concat (det_params, vector (\'access_token\', rows[0][1]));\n"
"det_params := vector_concat (det_params, vector (\'refresh_token\', rows[0][2]));\n"
"det_params := vector_concat (det_params, vector (\'expire_in\', expire_in));\n"
"det_params := vector_concat (det_params, vector (\'access_timestamp\', datestring (now ())));\n"
"}\n"
"\n"
"else if (det in (\'Dropbox\'))\n"
"{\n"
"det_params := vector_concat (det_params, vector (\'sid\', service_sid));\n"
"det_params := vector_concat (det_params, vector (\'access_token\', rows[0][1]));\n"
"}\n"
"}\n"
"\n"
"\n"
"retValue := null;\n"
"if (__proc_exists (\'DB.DBA.\' || det || \'_VERIFY\') is not null)\n"
"{\n"
"\n"
"retValue := call (\'DB.DBA.\' || det || \'_VERIFY\') (path, det_params);\n"
"}\n"
"else if (__proc_exists (\'WEBDAV.DBA.\' || det || \'_VERIFY\') is not null)\n"
"{\n"
"retValue := call (\'WEBDAV.DBA.\' || det || \'_VERIFY\') (path, det_params);\n"
"}\n"
"if (not isnull (retValue))\n"
"{\n"
"return -17;\n"
"}\n"
"\n"
"\n"
"if (det <> \'rdfSink\')\n"
"retValue := DB.DBA.DAV_PROP_SET_INT (path, \':virtdet\', det, null, null, 0, 0, 0, http_dav_uid ());\n"
"\n"
"if (DB.DBA.DAV_HIDE_ERROR (retValue) is not null)\n"
"{\n"
"if (__proc_exists (\'DB.DBA.\' || det || \'_CONFIGURE\') is not null)\n"
"{\n"
"\n"
"retValue := call (\'DB.DBA.\' || det || \'_CONFIGURE\') (id, det_params);\n"
"}\n"
"else if (__proc_exists (\'WEBDAV.DBA.\' || det || \'_CONFIGURE\') is not null)\n"
"{\n"
"retValue := call (\'WEBDAV.DBA.\' || det || \'_CONFIGURE\') (id, det_params);\n"
"}\n"
"if (DB.DBA.DAV_HIDE_ERROR (retValue) is null)\n"
"{\n"
"return -17;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_det.sql:157\n"
;

static const char *proc470 = 
"#line 306 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RES_UPLOAD_CM (\n"
"in mode varchar,\n"
"in det varchar,\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in source_id any,\n"
"in what char(1),\n"
"in overwrite_flags integer,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in extern integer,\n"
"in check_locks integer,\n"
"inout source_entry any,\n"
"inout source_path varchar,\n"
"inout target_path varchar)\n"
"{\n"
"\n"
"declare source_pid, source_content, source_type any;\n"
"declare target_pid, target_id any;\n"
"declare retValue, tmp any;\n"
"\n"
"retValue := -20;\n"
"source_entry := DB.DBA.DAV_DIR_SINGLE_INT (source_id, what, \'\', null, null, http_dav_uid ());\n"
"if (DB.DBA.DAV_HIDE_ERROR (source_entry) is null)\n"
"{\n"
"retValue := source_entry;\n"
"goto _exit;\n"
"}\n"
"\n"
"if (mode = \'move\')\n"
"{\n"
"permissions := source_entry[5];\n"
"uid := source_entry[7];\n"
"gid := source_entry[6];\n"
"}\n"
"\n"
"\n"
"source_path := source_entry[0];\n"
"source_pid := DB.DBA.DAV_SEARCH_ID (source_path, \'P\');\n"
"\n"
"\n"
"target_path := DB.DBA.DAV_DET_PATH (detcol_id, path_parts);\n"
"target_pid := DB.DBA.DAV_SEARCH_ID (target_path, \'P\');\n"
"if (DB.DBA.DAV_DET_DAV_ID (source_pid) <> DB.DBA.DAV_DET_DAV_ID (target_pid))\n"
"{\n"
"if (what = \'R\')\n"
"{\n"
"source_content := string_output ();\n"
"retValue := DB.DBA.DAV_RES_CONTENT_INT (source_id, source_content, source_type, 0, extern, auth_uname, auth_pwd);\n"
"if (DB.DBA.DAV_HIDE_ERROR (retValue) is null)\n"
"goto _exit;\n"
"\n"
"retValue := call (cast (det as varchar) || \'_DAV_RES_UPLOAD\') (detcol_id, path_parts, source_content, source_type, permissions, uid, gid, auth_uid);\n"
"if (DB.DBA.DAV_HIDE_ERROR (retValue) is null)\n"
"goto _exit;\n"
"\n"
"target_id := retValue;\n"
"DB.DBA.DAV_COPY_PROPS (0, source_id, \'R\', target_id, auth_uname, auth_pwd, extern, auth_uid);\n"
"DB.DBA.DAV_COPY_TAGS (source_id, \'R\', target_id);\n"
"if (mode = \'move\')\n"
"{\n"
"tmp := DB.DBA.DAV_DELETE_INT (source_path, 1, auth_uname, auth_pwd, extern, check_locks);\n"
"if (DB.DBA.DAV_HIDE_ERROR (tmp) is null)\n"
"{\n"
"retValue := tmp;\n"
"goto _exit;\n"
"}\n"
"}\n"
"}\n"
"else if ((what = \'C\') and (cast (det as varchar) <> coalesce (DB.DBA.DAV_DET_NAME (source_id), \'\')))\n"
"{\n"
"target_id := call (cast (det as varchar) || \'_DAV_COL_CREATE\') (detcol_id, path_parts, permissions, uid, gid, auth_uid, extern);\n"
"if (DB.DBA.DAV_HIDE_ERROR (target_id) is null)\n"
"{\n"
"rollback work;\n"
"retValue := target_id;\n"
"goto _exit;\n"
"}\n"
"DB.DBA.DAV_COPY_SUBTREE (source_id , target_id, source_path, target_path, 1, source_entry[7], source_entry[6], auth_uname, auth_pwd, extern, check_locks, auth_uid);\n"
"if (mode = \'move\')\n"
"{\n"
"tmp := DB.DBA.DAV_DELETE_INT (source_path, 1, auth_uname, auth_pwd, extern, check_locks);\n"
"if (DB.DBA.DAV_HIDE_ERROR (tmp) is null)\n"
"{\n"
"rollback work;\n"
"retValue := tmp;\n"
"goto _exit;\n"
"}\n"
"}\n"
"retValue := target_id;\n"
"}\n"
"}\n"
"_exit:;\n"
"return retValue;\n"
"}\n"
"--src dav_det.sql:304\n"
;

static const char *proc471 = 
"#line 407 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_DAV_LIST (\n"
"in det varchar,\n"
"inout detcol_id integer,\n"
"inout colId integer)\n"
"{\n"
"\n"
"declare retValue any;\n"
"\n"
"vectorbld_init (retValue);\n"
"for (select vector (RES_FULL_PATH,\n"
"\'R\',\n"
"DB.DBA.DAV_RES_LENGTH (RES_CONTENT, RES_SIZE),\n"
"RES_MOD_TIME,\n"
"vector (det, detcol_id, RES_ID, \'R\'),\n"
"RES_PERMS,\n"
"RES_GROUP,\n"
"RES_OWNER,\n"
"RES_CR_TIME,\n"
"RES_TYPE,\n"
"RES_NAME,\n"
"coalesce (RES_ADD_TIME, RES_CR_TIME),\n"
"RES_CREATOR) as I\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_COL = DB.DBA.DAV_DET_DAV_ID (colId)) do\n"
"{\n"
"vectorbld_acc (retValue, i);\n"
"}\n"
"\n"
"for (select vector (WS.WS.COL_PATH (COL_ID),\n"
"\'C\',\n"
"0,\n"
"COL_MOD_TIME,\n"
"vector (det, detcol_id, COL_ID, \'C\'),\n"
"COL_PERMS,\n"
"COL_GROUP,\n"
"COL_OWNER,\n"
"COL_CR_TIME,\n"
"\'dav/unix-directory\',\n"
"COL_NAME,\n"
"coalesce (COL_ADD_TIME, COL_CR_TIME),\n"
"COL_CREATOR) as I\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = DB.DBA.DAV_DET_DAV_ID (colId)) do\n"
"{\n"
"vectorbld_acc (retValue, i);\n"
"}\n"
"\n"
"vectorbld_final (retValue);\n"
"return retValue;\n"
"}\n"
"--src dav_det.sql:405\n"
;

static const char *proc472 = 
"#line 462 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PROPS_REMOVE (\n"
"in _det varchar,\n"
"in _id any,\n"
"in _what varchar)\n"
"{\n"
"declare props any;\n"
"\n"
"if (isarray (_id))\n"
"return;\n"
"\n"
"props := DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_PROP_LIST_INT (_id, _what, \'%\', 1), vector ());\n"
"foreach (any prop in props) do\n"
"{\n"
"if ((prop[0] like (\'virt:\' || _det || \'%\')) or (prop[0] = \'virt:DETCOL_ID\'))\n"
"{\n"
"DB.DBA.DAV_PROP_REMOVE_RAW (_id, _what, prop[0], 1, http_dav_uid());\n"
"}\n"
"}\n"
"}\n"
"--src dav_det.sql:460\n"
;

static const char *proc473 = 
"#line 487 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_ACTIVITY (\n"
"in det varchar,\n"
"in id integer,\n"
"in text varchar)\n"
"{\n"
"\n"
"declare pos integer;\n"
"declare parent_id integer;\n"
"declare parentPath varchar;\n"
"declare activity_id integer;\n"
"declare activity, activityName, activityPath, activityContent, activityType varchar;\n"
"declare davEntry any;\n"
"declare _errorCount integer;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"if (__SQL_STATE = \'40001\')\n"
"{\n"
"rollback work;\n"
"if (_errorCount > 5)\n"
"resignal;\n"
"\n"
"delay (1);\n"
"_errorCount := _errorCount + 1;\n"
"goto _start;\n"
"}\n"
"return;\n"
"};\n"
"\n"
"_errorCount := 0;\n"
"\n"
"_start:;\n"
"activity := DB.DBA.DAV_PROP_GET_INT (id, \'C\', sprintf (\'virt:%s-activity\', det), 0);\n"
"if (isnull (DB.DBA.DAV_HIDE_ERROR (activity)))\n"
"return;\n"
"\n"
"if (activity <> \'on\')\n"
"return;\n"
"\n"
"davEntry := DB.DBA.DAV_DIR_SINGLE_INT (id, \'C\', \'\', null, null, http_dav_uid ());\n"
"if (DB.DBA.DAV_HIDE_ERROR (davEntry) is null)\n"
"return;\n"
"\n"
"parent_id := DB.DBA.DAV_SEARCH_ID (davEntry[0], \'P\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (parent_id) is null)\n"
"return;\n"
"\n"
"parentPath := DB.DBA.DAV_SEARCH_PATH (parent_id, \'C\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (parentPath) is null)\n"
"return;\n"
"\n"
"activityContent := \'\';\n"
"activityName := davEntry[10] || \'_activity.log\';\n"
"activityPath := parentPath || activityName;\n"
"activity_id := DB.DBA.DAV_SEARCH_ID (activityPath, \'R\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (activity_id) is not null)\n"
"{\n"
"DB.DBA.DAV_RES_CONTENT_INT (activity_id, activityContent, activityType, 0, 0);\n"
"if (activityType <> \'text/plain\')\n"
"return;\n"
"\n"
"activityContent := cast (activityContent as varchar);\n"
"\n"
"if (length (activityContent) > 1024)\n"
"{\n"
"activityContent := right (activityContent, 1024);\n"
"pos := strstr (activityContent, \'\\r\\n20\');\n"
"if (not isnull (pos))\n"
"activityContent := subseq (activityContent, pos+2);\n"
"}\n"
"}\n"
"activityContent := activityContent || sprintf (\'%s %s\\r\\n\', subseq (datestring (now ()), 0, 19), text);\n"
"activityType := \'text/plain\';\n"
"DB.DBA.DAV_RES_UPLOAD_STRSES_INT (activityPath, activityContent, activityType, \'110100000RR\', DB.DBA.DAV_DET_USER (davEntry[6]), DB.DBA.DAV_DET_USER (davEntry[7]), extern=>0, check_locks=>0);\n"
"\n"
"\n"
"set triggers off;\n"
"DB.DBA.DAV_PROP_SET_INT (activityPath, \':virtpermissions\', \'110100000RR\', null, null, 0, 0, 1, http_dav_uid());\n"
"set triggers on;\n"
"\n"
"commit work;\n"
"}\n"
"--src dav_det.sql:485\n"
;

static const char *proc474 = 
"#line 573 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_HTTP_ERROR (\n"
"in _header any,\n"
"in _silent integer := 0)\n"
"{\n"
"if ((_header[0] like \'HTTP/1._ 4__ %\') or (_header[0] like \'HTTP/1._ 5__ %\'))\n"
"{\n"
"if (not _silent)\n"
"signal (\'22023\', trim (_header[0], \'\\r\\n\'));\n"
"\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:571\n"
;

static const char *proc475 = 
"#line 588 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_HTTP_CODE (\n"
"in _header any)\n"
"{\n"
"return subseq (_header[0], 9, 12);\n"
"}\n"
"--src dav_det.sql:586\n"
;

static const char *proc476 = 
"#line 595 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_HTTP_MESSAGE (\n"
"in _header any)\n"
"{\n"
"return subseq (_header[0], 13);\n"
"}\n"
"--src dav_det.sql:593\n"
;

static const char *proc477 = 
"#line 605 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_USER (\n"
"in user_id integer,\n"
"in default_id integer := null)\n"
"{\n"
"return coalesce ((select U_NAME from DB.DBA.SYS_USERS where U_ID = coalesce (user_id, default_id)), \'\');\n"
"}\n"
"--src dav_det.sql:603\n"
;

static const char *proc478 = 
"#line 613 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_USER_IRI (\n"
"in user_id integer) returns varchar\n"
"{\n"
"return sprintf (\'%s/dataspace/person/%s#this\',  WS.WS.DAV_HOST (), DB.DBA.DAV_DET_USER (user_id));\n"
"}\n"
"--src dav_det.sql:611\n"
;

static const char *proc479 = 
"#line 620 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PASSWORD (\n"
"in user_id integer)\n"
"{\n"
"return coalesce ((select pwd_magic_calc(U_NAME, U_PASSWORD, 1) from DB.DBA.SYS_USERS where U_ID = user_id), \'\');\n"
"}\n"
"--src dav_det.sql:618\n"
;

static const char *proc480 = 
"#line 627 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_OWNER (\n"
"in detcol_id any,\n"
"in subPath_parts any,\n"
"in uid any,\n"
"in gid any,\n"
"inout ouid integer,\n"
"inout ogid integer)\n"
"{\n"
"declare id any;\n"
"declare path varchar;\n"
"\n"
"DB.DBA.DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"if ((ouid = -12) or (ouid = 5))\n"
"{\n"
"path := DB.DBA.DAV_DET_PATH (detcol_id, subPath_parts);\n"
"id := DB.DBA.DAV_SEARCH_ID (path, \'P\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (id))\n"
"{\n"
"select COL_OWNER, COL_GROUP\n"
"into ouid, ogid\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = id;\n"
"}\n"
"}\n"
"}\n"
"--src dav_det.sql:625\n"
;

static const char *proc481 = 
"#line 657 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PARAM_SET (\n"
"in _det varchar,\n"
"in _password varchar,\n"
"in _id any,\n"
"in _what varchar,\n"
"in _propName varchar,\n"
"in _propValue any,\n"
"in _serialized integer := 1,\n"
"in _prefixed integer := 1,\n"
"in _encrypt integer := 0)\n"
"{\n"
"\n"
"declare retValue, save any;\n"
"\n"
"save := connection_get (\'dav_store\');\n"
"connection_set (\'dav_store\', 1);\n"
"\n"
"if (DB.DBA.is_empty_or_null (_propValue))\n"
"{\n"
"DB.DBA.DAV_DET_PARAM_REMOVE (_det, _id, _what, _propName, _prefixed);\n"
"}\n"
"else\n"
"{\n"
"if (_serialized)\n"
"_propValue := serialize (_propValue);\n"
"\n"
"if (_encrypt)\n"
"_propValue := pwd_magic_calc (_password, _propValue);\n"
"\n"
"if (_prefixed)\n"
"_propName := sprintf (\'virt:%s-%s\', _det, _propName);\n"
"\n"
"_id := DB.DBA.DAV_DET_DAV_ID (_id);\n"
"retValue := DB.DBA.DAV_PROP_SET_RAW (_id, _what, _propName, _propValue, 1, http_dav_uid ());\n"
"}\n"
"commit work;\n"
"\n"
"connection_set (\'dav_store\', save);\n"
"return retValue;\n"
"}\n"
"--src dav_det.sql:655\n"
;

static const char *proc482 = 
"#line 699 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PARAM_GET (\n"
"in _det varchar,\n"
"in _password varchar,\n"
"in _id any,\n"
"in _what varchar,\n"
"in _propName varchar,\n"
"in _serialized integer := 1,\n"
"in _prefixed integer := 1,\n"
"in _decrypt integer := 0)\n"
"{\n"
"\n"
"declare propValue any;\n"
"\n"
"if (_prefixed)\n"
"_propName := sprintf (\'virt:%s-%s\', _det, _propName);\n"
"\n"
"propValue := DB.DBA.DAV_PROP_GET_INT (DB.DBA.DAV_DET_DAV_ID (_id), _what, _propName, 0, DB.DBA.DAV_DET_USER (http_dav_uid ()), DB.DBA.DAV_DET_PASSWORD (http_dav_uid ()), http_dav_uid ());\n"
"if (isinteger (propValue))\n"
"{\n"
"propValue := null;\n"
"}\n"
"else\n"
"{\n"
"if (_serialized and not isnull (propValue))\n"
"propValue := deserialize (propValue);\n"
"\n"
"if (_decrypt and not isnull (propValue))\n"
"propValue := pwd_magic_calc (_password, propValue, 1);\n"
"}\n"
"\n"
"return propValue;\n"
"}\n"
"--src dav_det.sql:697\n"
;

static const char *proc483 = 
"#line 733 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PARAM_REMOVE (\n"
"in _det varchar,\n"
"in _id any,\n"
"in _what varchar,\n"
"in _propName varchar,\n"
"in _prefixed integer := 1)\n"
"{\n"
"\n"
"if (_prefixed)\n"
"_propName := sprintf (\'virt:%s-%s\', _det, _propName);\n"
"\n"
"DB.DBA.DAV_PROP_REMOVE_RAW (DB.DBA.DAV_DET_DAV_ID (_id), _what, _propName, 1, http_dav_uid());\n"
"commit work;\n"
"}\n"
"--src dav_det.sql:731\n"
;

static const char *proc484 = 
"#line 752 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_DEFAULT_KEYS ()\n"
"{\n"
"return vector (\'sponger\', \'cartridges\', \'metaCartridges\', \'graph\', \'graphSecurity\', \'graphSecurityACL\', \'graphSecurityACI\');\n"
"}\n"
"--src dav_det.sql:750\n"
;

static const char *proc485 = 
"#line 758 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_PARAMS_SET (\n"
"in _det varchar,\n"
"in _id any,\n"
"in _params any,\n"
"in _keys any := null)\n"
"{\n"
"\n"
"declare N integer;\n"
"declare _data any;\n"
"\n"
"if (isnull (_keys))\n"
"{\n"
"_keys := DB.DBA.DAV_DET_RDF_DEFAULT_KEYS ();\n"
"}\n"
"\n"
"_data := vector ();\n"
"for (N := 0; N < length (_keys); N := N + 1)\n"
"{\n"
"_data := vector_concat (_data, vector (_keys[N], get_keyword (_keys[N], _params)));\n"
"}\n"
"return DB.DBA.DAV_DET_RDF_PARAMS_SET_INT (_det, _id, _data);\n"
"}\n"
"--src dav_det.sql:756\n"
;

static const char *proc486 = 
"#line 782 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_PARAMS_SET_INT (\n"
"in _det varchar,\n"
"in _id any,\n"
"in _data any)\n"
"{\n"
"\n"
"\n"
"return DB.DBA.DAV_PROP_SET_INT (DB.DBA.DAV_SEARCH_PATH (_id, \'C\'), sprintf (\'virt:%s-rdf\', _det), serialize (_data), null, null, 0, 0, 1, http_dav_uid ());\n"
"}\n"
"--src dav_det.sql:780\n"
;

static const char *proc487 = 
"#line 793 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_PARAMS_GET (\n"
"in _det varchar,\n"
"in _id any)\n"
"{\n"
"\n"
"declare retValue any;\n"
"\n"
"retValue := DB.DBA.DAV_PROP_GET_INT (_id, \'C\', sprintf (\'virt:%s-rdf\', _det), 0);\n"
"if (DB.DBA.DAV_HIDE_ERROR (retValue) is null)\n"
"{\n"
"return vector (\'sponger\', \'off\', \'graphSecurity\', \'off\');\n"
"}\n"
"return deserialize (retValue);\n"
"}\n"
"--src dav_det.sql:791\n"
;

static const char *proc488 = 
"#line 812 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_STRINGDATE (\n"
"in dt varchar)\n"
"{\n"
"declare rs any;\n"
"declare exit handler for sqlstate \'*\' { return now ();};\n"
"\n"
"rs := dt;\n"
"if (isstring (rs))\n"
"rs := stringdate (rs);\n"
"\n"
"return dateadd (\'minute\', timezone (curdatetime_tz()), rs);\n"
"}\n"
"--src dav_det.sql:810\n"
;

static const char *proc489 = 
"#line 829 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_XML2STRING (\n"
"in _xml any)\n"
"{\n"
"declare stream any;\n"
"\n"
"stream := string_output ();\n"
"http_value (_xml, null, stream);\n"
"return string_output_string (stream);\n"
"}\n"
"--src dav_det.sql:827\n"
;

static const char *proc490 = 
"#line 840 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_ENTRY_XPATH (\n"
"in _xml any,\n"
"in _xpath varchar,\n"
"in _cast integer := 0)\n"
"{\n"
"declare retValue any;\n"
"\n"
"if (_cast)\n"
"{\n"
"retValue := serialize_to_UTF8_xml (xpath_eval (sprintf (\'string (//entry%s)\', _xpath), _xml, 1));\n"
"}\n"
"else\n"
"{\n"
"retValue := xpath_eval (\'//entry\' || _xpath, _xml, 1);\n"
"}\n"
"return retValue;\n"
"}\n"
"--src dav_det.sql:838\n"
;

static const char *proc491 = 
"#line 859 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_ENTRY_XUPDATE (\n"
"inout _xml any,\n"
"in _tag varchar,\n"
"in _value any)\n"
"{\n"
"declare _entity any;\n"
"\n"
"_xml := XMLUpdate (_xml, \'//entry/\' || _tag, null);\n"
"if (isnull (_value))\n"
"return;\n"
"\n"
"_entity := xpath_eval (\'//entry\', _xml);\n"
"XMLAppendChildren (_entity, xtree_doc (sprintf (\'<%s>%V</%s>\', _tag, cast (_value as varchar), _tag)));\n"
"}\n"
"--src dav_det.sql:857\n"
;

static const char *proc492 = 
"#line 878 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF (\n"
"in det varchar,\n"
"in detcol_id integer,\n"
"in id any,\n"
"in what varchar)\n"
"{\n"
"declare rdf_params any;\n"
"declare aq any;\n"
"\n"
"rdf_params := DB.DBA.DAV_DET_RDF_PARAMS_GET (det, detcol_id);\n"
"if (DB.DBA.is_empty_or_null (get_keyword (\'graph\', rdf_params)))\n"
"return;\n"
"\n"
"set_user_id (\'dba\');\n"
"aq := async_queue (1, 4);\n"
"aq_request (aq, \'DB.DBA.DAV_DET_RDF_AQ\', vector (det, detcol_id, id, what, rdf_params));\n"
"}\n"
"--src dav_det.sql:876\n"
;

static const char *proc493 = 
"#line 897 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_AQ (\n"
"in det varchar,\n"
"in detcol_id integer,\n"
"in id any,\n"
"in what varchar,\n"
"in rdf_params any)\n"
"{\n"
"set_user_id (\'dba\');\n"
"DB.DBA.DAV_DET_RDF_DELETE (det, detcol_id, id, what, rdf_params);\n"
"DB.DBA.DAV_DET_RDF_INSERT (det, detcol_id, id, what, rdf_params);\n"
"}\n"
"--src dav_det.sql:895\n"
;

static const char *proc494 = 
"#line 910 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_INSERT (\n"
"in det varchar,\n"
"in detcol_id integer,\n"
"in id any,\n"
"in what varchar,\n"
"in rdf_params any := null)\n"
"{\n"
"\n"
"declare permissions varchar;\n"
"declare rdf_graph, rdf_sponger, rdf_cartridges, rdf_metaCartridges any;\n"
"declare path, content, type any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return;\n"
"};\n"
"\n"
"if (what <> \'R\')\n"
"return;\n"
"\n"
"if (isnull (rdf_params))\n"
"rdf_params := DB.DBA.DAV_DET_RDF_PARAMS_GET (det, detcol_id);\n"
"\n"
"rdf_graph := get_keyword (\'graph\', rdf_params, \'\');\n"
"if (rdf_graph = \'\')\n"
"return;\n"
"\n"
"if (not DB.DBA.DAV_DET_IS_WEBDAV_BASED (det) and (__proc_exists (\'DB.DBA.\' || det || \'__RDF_INSERT\') is not null))\n"
"{\n"
"return call (\'DB.DBA.\' || det || \'__rdf_insert\') (detcol_id, id, \'R\', rdf_params);\n"
"}\n"
"\n"
"permissions := DB.DBA.DAV_DET_PARAM_GET (det, null, detcol_id, \'C\', \':virtpermissions\', 0, 0);\n"
"if (permissions[6] = ascii(\'0\'))\n"
"{\n"
"\n"
"if (not DB.DBA.DAV_DET_PRIVATE_GRAPH_CHECK (rdf_graph))\n"
"return;\n"
"}\n"
"\n"
"id := DB.DBA.DAV_DET_DAV_ID (id);\n"
"path := DB.DBA.DAV_SEARCH_PATH (id, what);\n"
"\n"
"content := (select RES_CONTENT from WS.WS.SYS_DAV_RES where RES_ID = id);\n"
"type := (select RES_TYPE from WS.WS.SYS_DAV_RES where RES_ID = id);\n"
"rdf_sponger := get_keyword (\'sponger\', rdf_params, \'off\');\n"
"rdf_cartridges := get_keyword (\'cartridges\', rdf_params);\n"
"rdf_metaCartridges := get_keyword (\'metaCartridges\', rdf_params);\n"
"\n"
"DB.DBA.RDF_SINK_UPLOAD (path, content, type, rdf_graph, null, rdf_sponger, rdf_cartridges, rdf_metaCartridges);\n"
"}\n"
"--src dav_det.sql:908\n"
;

static const char *proc495 = 
"#line 962 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_DELETE (\n"
"in det varchar,\n"
"in detcol_id integer,\n"
"in id any,\n"
"in what varchar,\n"
"in rdf_params any := null)\n"
"{\n"
"\n"
"declare path varchar;\n"
"declare rdf_graph any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return;\n"
"};\n"
"\n"
"if (what <> \'R\')\n"
"return;\n"
"\n"
"if (isnull (rdf_params))\n"
"rdf_params := DB.DBA.DAV_DET_RDF_PARAMS_GET (det, detcol_id);\n"
"\n"
"rdf_graph := get_keyword (\'graph\', rdf_params, \'\');\n"
"if (rdf_graph = \'\')\n"
"return;\n"
"\n"
"if (not DB.DBA.DAV_DET_IS_WEBDAV_BASED (det) and (__proc_exists (\'DB.DBA.\' || det || \'__RDF_DELETE\') is not null))\n"
"{\n"
"return call (\'DB.DBA.\' || det || \'__rdf_delete\') (detcol_id, id, \'R\', rdf_params);\n"
"}\n"
"\n"
"path := DB.DBA.DAV_SEARCH_PATH (id, what);\n"
"DB.DBA.RDF_SINK_DELETE (-1, path, id, detcol_id, 1);\n"
"}\n"
"--src dav_det.sql:960\n"
;

static const char *proc496 = 
"#line 1000 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_REFRESH (\n"
"in det varchar,\n"
"in path varchar)\n"
"{\n"
"\n"
"declare colId any;\n"
"\n"
"colId := DB.DBA.DAV_SEARCH_ID (path, \'C\');\n"
"if (DB.DBA.DAV_HIDE_ERROR (colId) is not null)\n"
"DB.DBA.DAV_DET_PARAM_REMOVE (det, colId, \'C\', \'syncTime\');\n"
"}\n"
"--src dav_det.sql:998\n"
;

static const char *proc497 = 
"#line 1013 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_SYNC (\n"
"in det varchar,\n"
"in id any)\n"
"{\n"
"\n"
"declare N integer;\n"
"declare detcol_id, parts, subPath_parts, detcol_parts any;\n"
"\n"
"detcol_id := DB.DBA.DAV_DET_DETCOL_ID (id);\n"
"parts := split_and_decode (DB.DBA.DAV_SEARCH_PATH (id, \'C\'), 0, \'\\0\\0/\');\n"
"detcol_parts := split_and_decode (DB.DBA.DAV_SEARCH_PATH (detcol_id, \'C\'), 0, \'\\0\\0/\');\n"
"N := length (detcol_parts) - 2;\n"
"detcol_parts := vector_concat (subseq (parts, 0, N + 1), vector (\'\'));\n"
"subPath_parts := subseq (parts, N + 1);\n"
"\n"
"call (\'DB.DBA.\' || det || \'__load\') (detcol_id, subPath_parts, detcol_parts, 1);\n"
"}\n"
"--src dav_det.sql:1011\n"
;

static const char *proc498 = 
"#line 1032 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_CONTENT_ROLLBACK (\n"
"in oldId any,\n"
"in oldContent any,\n"
"in path varchar)\n"
"{\n"
"if (DB.DBA.DAV_HIDE_ERROR (oldId) is not null)\n"
"{\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = oldContent where RES_ID = DB.DBA.DAV_DET_DAV_ID (oldID);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.DAV_DELETE_INT (path, 1, null, null, 0, 0);\n"
"}\n"
"}\n"
"--src dav_det.sql:1030\n"
;

static const char *proc499 = 
"#line 1048 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_CONTENT_MD5 (\n"
"in id any)\n"
"{\n"
"return md5 (blob_to_string_output ((select RES_CONTENT from WS.WS.SYS_DAV_RES where RES_ID = DB.DBA.DAV_DET_DAV_ID (id))));\n"
"}\n"
"--src dav_det.sql:1046\n"
;

static const char *proc500 = 
"#line 1062 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_GRAPH ()\n"
"{\n"
"return \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\';\n"
"}\n"
"--src dav_det.sql:1060\n"
;

static const char *proc501 = 
"#line 1071 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_GRAPH_ID ()\n"
"{\n"
"return iri_to_id (DB.DBA.DAV_DET_PRIVATE_GRAPH ());\n"
"}\n"
"--src dav_det.sql:1069\n"
;

static const char *proc502 = 
"#line 1080 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_INIT ()\n"
"{\n"
"declare exit handler for sqlstate \'*\' {return 0;};\n"
"\n"
"if (registry_get (\'__DAV_DET_PRIVATE_INIT\') = \'1\')\n"
"return;\n"
"\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_CREATE (DB.DBA.DAV_DET_PRIVATE_GRAPH (), 1);\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'nobody\', 1, 1);\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023, 1);\n"
"\n"
"registry_set (\'__DAV_DET_PRIVATE_INIT\', \'1\');\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1078\n"
;

static const char *proc503 = 
"#line 1108 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_GRAPH_ADD (\n"
"in graph_iri varchar)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {return 0;};\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (DB.DBA.DAV_DET_PRIVATE_GRAPH (), graph_iri);\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1106\n"
;

static const char *proc504 = 
"#line 1126 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_GRAPH_REMOVE (\n"
"in graph_iri varchar)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {return 0;};\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (DB.DBA.DAV_DET_PRIVATE_GRAPH (), graph_iri);\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1124\n"
;

static const char *proc505 = 
"#line 1149 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_GRAPH_CHECK (\n"
"in graph_iri varchar)\n"
"{\n"
"declare private_graph varchar;\n"
"declare private_graph_id any;\n"
"\n"
"private_graph := DB.DBA.DAV_DET_PRIVATE_GRAPH ();\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = private_graph))\n"
"return 0;\n"
"\n"
"private_graph_id := DB.DBA.DAV_DET_PRIVATE_GRAPH_ID ();\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = private_graph_id and RGGM_MEMBER_IID = iri_to_id (graph_iri)))\n"
"return 0;\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1147\n"
;

static const char *proc506 = 
"#line 1184 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_USER_ADD (\n"
"in graph_iri varchar,\n"
"in uid any,\n"
"in rights integer := 1023)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {return 0;};\n"
"\n"
"if (isinteger (uid))\n"
"uid := DB.DBA.DAV_DET_USER (uid);\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (DB.DBA.DAV_DET_PRIVATE_GRAPH (), graph_iri);\n"
"DB.DBA.RDF_GRAPH_USER_PERMS_SET (graph_iri, uid, rights);\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1182\n"
;

static const char *proc507 = 
"#line 1209 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_USER_REMOVE (\n"
"in graph_iri varchar,\n"
"in uid any)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {return 0;};\n"
"\n"
"if (isinteger (uid))\n"
"uid := DB.DBA.DAV_DET_USER (uid);\n"
"\n"
"DB.DBA.RDF_GRAPH_USER_PERMS_DEL (graph_iri, uid);\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1207\n"
;

static const char *proc508 = 
"#line 1227 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_ACL_COMPARE (\n"
"in acls_1 any,\n"
"in acls_2 any)\n"
"{\n"
"declare N integer;\n"
"\n"
"if (length (acls_1) <> length (acls_2))\n"
"return 0;\n"
"\n"
"for (N := 0; N < length (acls_1); N := N + 1)\n"
"{\n"
"if (acls_1[N] <> acls_2[N])\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav_det.sql:1225\n"
;

static const char *proc509 = 
"#line 1248 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_ACL_ADD (\n"
"in graph varchar,\n"
"in acls any)\n"
"{\n"
"\n"
"declare N, L integer;\n"
"declare V, allow, denny any;\n"
"\n"
"allow := vector ();\n"
"denny := vector ();\n"
"L := length (acls);\n"
"for (N := L-1; N >= 0; N := N - 1)\n"
"{\n"
"V := WS.WS.ACL_PARSE (acls[N], case when (N = L-1) then \'01\' else \'12\' end, 0);\n"
"foreach (any acl in V) do\n"
"{\n"
"if (not position (acl[0], allow) and not position (acl[0], denny))\n"
"{\n"
"if (acl[1] = 1)\n"
"{\n"
"allow := vector_concat (allow, vector (acl[0]));\n"
"}\n"
"else\n"
"{\n"
"denny := vector_concat (denny, vector (acl[0]));\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"for (N := 0; N < length (allow); N := N + 1)\n"
"{\n"
"DB.DBA.DAV_DET_PRIVATE_USER_ADD (graph, allow[N]);\n"
"}\n"
"\n"
"for (N := 0; N < length (denny); N := N + 1)\n"
"{\n"
"DB.DBA.DAV_DET_PRIVATE_USER_REMOVE (graph, denny[N]);\n"
"}\n"
"}\n"
"--src dav_det.sql:1246\n"
;

static const char *proc510 = 
"#line 1293 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_ACL_REMOVE (\n"
"in graph varchar,\n"
"in acls any)\n"
"{\n"
"\n"
"declare N, L integer;\n"
"declare V, denny any;\n"
"\n"
"denny := vector ();\n"
"L := length (acls);\n"
"for (N := L-1; N >= 0; N := N - 1)\n"
"{\n"
"V := WS.WS.ACL_PARSE (acls[N], case when (N = L-1) then \'01\' else \'12\' end, 0);\n"
"foreach (any acl in V) do\n"
"{\n"
"if ((acl[1] = 1) and not position (acl[0], denny))\n"
"denny := vector_concat (denny, vector (acl[0]));\n"
"}\n"
"}\n"
"\n"
"for (N := 0; N < length (denny); N := N + 1)\n"
"{\n"
"DB.DBA.DAV_DET_PRIVATE_USER_REMOVE (graph, denny[N]);\n"
"}\n"
"}\n"
"--src dav_det.sql:1291\n"
;

static const char *proc511 = 
"#line 1320 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (\n"
"in id integer,\n"
"in what varchar,\n"
"inout oldAcls any,\n"
"inout newAcls any)\n"
"{\n"
"\n"
"declare _id integer;\n"
"declare _acl any;\n"
"declare exit handler for not found { return; };\n"
"\n"
"\n"
"while (1)\n"
"{\n"
"select COL_ACL, COL_PARENT into _id, _acl from WS.WS.SYS_DAV_COL where COL_ID = _id;\n"
"if (length (_acl) > 8)\n"
"{\n"
"oldAcls := vector_concat (vector (_acl), oldAcls);\n"
"newAcls := vector_concat (vector (_acl), newAcls);\n"
"}\n"
"}\n"
"}\n"
"--src dav_det.sql:1318\n"
;

static const char *proc512 = 
"#line 1348 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_GRAPH_UPDATE (\n"
"in id integer,\n"
"in oldOwner integer,\n"
"in newOwner integer,\n"
"in oldGroup integer,\n"
"in newGroup integer,\n"
"in oldPermissions varchar,\n"
"in newPermissions varchar,\n"
"in oldAcls any,\n"
"in newAcls any,\n"
"in oldRDFParams any,\n"
"in newRDFParams any,\n"
"in forceUpdate integer := 0,\n"
"in forceChild integer := 0)\n"
"{\n"
"\n"
"declare N integer;\n"
"declare det, path, graph varchar;\n"
"declare oldGraph, newGraph varchar;\n"
"declare aq, aci, acis, rdfParams any;\n"
"\n"
"oldGraph := get_keyword (\'graph\', oldRDFParams, \'\');\n"
"newGraph := get_keyword (\'graph\', newRDFParams, \'\');\n"
"\n"
"\n"
"if (\n"
"(oldGraph                      = newGraph)                      and\n"
"(coalesce (oldOwner, -1)       = coalesce (newOwner, -1))       and\n"
"(coalesce (oldGroup, -1)       = coalesce (newGroup, -1))       and\n"
"(coalesce (oldPermissions, \'\') = coalesce (newPermissions, \'\')) and\n"
"(DB.DBA.DAV_DET_PRIVATE_ACL_COMPARE (oldAcls, newAcls))         and\n"
"(forceUpdate = 0)\n"
")\n"
"{\n"
"return;\n"
"}\n"
"\n"
"\n"
"if (oldGraph <> \'\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_REMOVE (id, \'C\', oldGraph, oldOwner, oldGroup, oldAcls);\n"
"}\n"
"\n"
"\n"
"if (newGraph <> \'\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_SET (id, \'C\', newGraph, newOwner, newGroup, newPermissions, newAcls, newRDFParams);\n"
"}\n"
"\n"
"if (DB.DBA.DAV_DET_COL_RDF_PARAMS (id, det, rdfParams))\n"
"{\n"
"if (get_keyword (\'graphSecurity\', rdfParams, \'off\') = \'off\')\n"
"{\n"
"graph := get_keyword (\'graph\', rdfParams);\n"
"newRDFParams := vector (\'graph\', graph, \'graphSecurityACI\', get_keyword (\'graphSecurityACI\', newRDFParams));\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_REMOVE (id, \'C\', graph, oldOwner, oldGroup, oldAcls);\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_SET (id, \'C\', graph, newOwner, newGroup, newPermissions, newAcls, newRDFParams);\n"
"}\n"
"}\n"
"\n"
"if (forceChild)\n"
"{\n"
"for (N := 0; N < length (oldAcls); N := N + 1)\n"
"oldAcls[N] := cast (oldAcls[N] as varchar);\n"
"\n"
"for (N := 0; N < length (newAcls); N := N + 1)\n"
"newAcls[N] := cast (newAcls[N] as varchar);\n"
"\n"
"aq := async_queue (1, 4);\n"
"aq_request (aq, \'DB.DBA.DAV_DET_GRAPH_UPDATE_CHILD\', vector (id, \'C\', oldAcls, newAcls, oldRDFParams, newRDFParams, forceUpdate));\n"
"}\n"
"}\n"
"--src dav_det.sql:1346\n"
;

static const char *proc513 = 
"#line 1425 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_GRAPH_UPDATE (\n"
"in id integer,\n"
"in oldRDFParams any,\n"
"in newRDFParams any)\n"
"{\n"
"\n"
"declare path, detType varchar;\n"
"declare oldGraph, newGraph, oldGraphSecurity, newGraphSecurity, oldSponger, newSponger, oldCartridges, newCartridges, oldMetaCartridges, newMetaCartridges varchar;\n"
"declare oldAcls, newAcls any;\n"
"declare aq any;\n"
"\n"
"oldGraphSecurity := get_keyword (\'graphSecurity\', oldRDFParams, \'off\');\n"
"newGraphSecurity := get_keyword (\'graphSecurity\', newRDFParams, \'off\');\n"
"\n"
"oldGraph := get_keyword (\'graph\', oldRDFParams, \'\');\n"
"newGraph := get_keyword (\'graph\', newRDFParams, \'\');\n"
"\n"
"oldSponger := get_keyword (\'sponger\', oldRDFParams, \'off\');\n"
"newSponger := get_keyword (\'sponger\', newRDFParams, \'off\');\n"
"\n"
"oldCartridges := get_keyword (\'cartridges\', oldRDFParams, \'\');\n"
"newCartridges := get_keyword (\'cartridges\', newRDFParams, \'\');\n"
"\n"
"oldMetaCartridges := get_keyword (\'metaCartridges\', oldRDFParams, \'\');\n"
"newMetaCartridges := get_keyword (\'metaCartridges\', newRDFParams, \'\');\n"
"\n"
"oldAcls := vector ();\n"
"if (oldGraphSecurity <> \'off\')\n"
"{\n"
"oldAcls := vector (get_keyword (\'graphSecurityACL\', oldRDFParams));\n"
"}\n"
"\n"
"newAcls := vector ();\n"
"if (newGraphSecurity <> \'off\')\n"
"{\n"
"newAcls := vector (get_keyword (\'graphSecurityACL\', newRDFParams));\n"
"}\n"
"\n"
"\n"
"if (\n"
"(oldGraphSecurity  <> newGraphSecurity)                     or\n"
"(oldGraph          <> newGraph)                             or\n"
"(oldSponger        <> newSponger)                           or\n"
"(oldCartridges     <> newCartridges)                        or\n"
"(oldMetaCartridges <> newMetaCartridges)                    or\n"
"(not DB.DBA.DAV_DET_PRIVATE_ACL_COMPARE (oldAcls, newAcls))\n"
")\n"
"{\n"
"\n"
"if (oldGraph <> \'\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_REMOVE (id, \'C\', oldGraph, null, null, oldAcls);\n"
"}\n"
"\n"
"\n"
"if (newGraph <> \'\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_SET (id, \'C\', newGraph, null, null, \'000000000\', newAcls, newRDFParams);\n"
"}\n"
"}\n"
"\n"
"if (\n"
"(oldGraph          <> newGraph)          or\n"
"(oldSponger        <> newSponger)        or\n"
"(oldCartridges     <> newCartridges)     or\n"
"(oldMetaCartridges <> newMetaCartridges)\n"
")\n"
"{\n"
"oldRDFParams := vector (\n"
"\'graph\', oldGraph,\n"
"\'sponger\', oldSponger,\n"
"\'cartridges\', oldCartridges,\n"
"\'metaCartridges\', oldMetaCartridges\n"
");\n"
"newRDFParams := vector (\n"
"\'graph\', newGraph,\n"
"\'sponger\', newSponger,\n"
"\'cartridges\', newCartridges,\n"
"\'metaCartridges\', newMetaCartridges\n"
");\n"
"\n"
"path := DB.DBA.DAV_SEARCH_PATH (id, \'C\');\n"
"detType := DB.DBA.DAV_DET_COL_DET (id);\n"
"aq := async_queue (1, 4);\n"
"aq_request (aq, \'DB.DBA.DAV_DET_RDF_GRAPH_UPDATE_AQ\', vector (path, cast (detType as varchar), oldRDFParams, newRDFParams));\n"
"}\n"
"}\n"
"--src dav_det.sql:1423\n"
;

static const char *proc514 = 
"#line 1517 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RDF_GRAPH_UPDATE_AQ (\n"
"in path varchar,\n"
"in det varchar,\n"
"in oldRDFParams any,\n"
"in newRDFParams any)\n"
"{\n"
"\n"
"declare N, detcol_id integer;\n"
"declare oldGraph, newGraph varchar;\n"
"declare V, filter any;\n"
"\n"
"oldGraph := get_keyword (\'graph\', oldRDFParams, \'\');\n"
"newGraph := get_keyword (\'graph\', newRDFParams, \'\');\n"
"if ((oldGraph = \'\') and (newGraph = \'\'))\n"
"return;\n"
"\n"
"detcol_id := DB.DBA.DAV_SEARCH_ID (path, \'C\');\n"
"filter := vector (vector (\'RES_FULL_PATH\', \'like\', path || \'%\'));\n"
"V := DB.DBA.DAV_DIR_FILTER (path, 1, filter, \'dav\', DB.DBA.DAV_DET_PASSWORD (http_dav_uid ()));\n"
"if (oldGraph <> \'\')\n"
"{\n"
"for (N := 0; N < length (V); N := N + 1)\n"
"{\n"
"DB.DBA.DAV_DET_RDF_DELETE (det, detcol_id, V[N][4], \'R\', oldRDFParams);\n"
"}\n"
"}\n"
"\n"
"if (newGraph <> \'\')\n"
"{\n"
"for (N := 0; N < length (V); N := N + 1)\n"
"{\n"
"DB.DBA.DAV_DET_RDF_INSERT (det, detcol_id, V[N][4], \'R\', newRDFParams);\n"
"}\n"
"}\n"
"}\n"
"--src dav_det.sql:1515\n"
;

static const char *proc515 = 
"#line 1557 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_LDP_GRAPH_UPDATE (\n"
"in id integer)\n"
"{\n"
"\n"
"\n"
"for (select COL_ACL    as _acl,\n"
"COL_OWNER  as _owner,\n"
"COL_GROUP  as _group,\n"
"COL_PERMS  as _perms,\n"
"COL_PARENT as _parent_id\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = id) do\n"
"{\n"
"declare _oldAcls, _newAcls, _rdfParams any;\n"
"\n"
"\n"
"_oldAcls := vector (_acl);\n"
"_newAcls := vector (_acl);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (_parent_id, \'C\', _oldAcls, _newAcls);\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (DB.DBA.DAV_SEARCH_PATH (id, \'C\')));\n"
"\n"
"\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE (\n"
"id,\n"
"_owner,\n"
"_owner,\n"
"_group,\n"
"_group,\n"
"_perms,\n"
"_perms,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams,\n"
"1,\n"
"1\n"
");\n"
"}\n"
"}\n"
"--src dav_det.sql:1555\n"
;

static const char *proc516 = 
"#line 1602 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_RES_GRAPH_UPDATE (\n"
"in id integer,\n"
"in mode varchar,\n"
"in oldMimeType varchar,\n"
"in newMimeType varchar,\n"
"in oldOwner integer,\n"
"in newOwner integer,\n"
"in oldGroup integer,\n"
"in newGroup integer,\n"
"in oldPermissions varchar,\n"
"in newPermissions varchar,\n"
"in oldAcls any,\n"
"in newAcls any,\n"
"in oldRDFParams any,\n"
"in newRDFParams any,\n"
"in forceUpdate integer := 0)\n"
"{\n"
"\n"
"declare oldGraph, newGraph varchar;\n"
"declare aci, acis any;\n"
"\n"
"oldMimeType := coalesce (oldMimeType, \'\');\n"
"newMimeType := coalesce (newMimeType, \'\');\n"
"if ((mode = \'I\') and (newMimeType <> \'text/turtle\'))\n"
"return;\n"
"\n"
"if ((mode = \'D\') and (oldMimeType <> \'text/turtle\'))\n"
"return;\n"
"\n"
"if ((mode = \'U\') and (oldMimeType <> \'text/turtle\') and (newMimeType <> \'text/turtle\'))\n"
"return;\n"
"\n"
"oldGraph := get_keyword (\'graph\', oldRDFParams, \'\');\n"
"newGraph := get_keyword (\'graph\', newRDFParams, \'\');\n"
"\n"
"\n"
"if (\n"
"(oldGraph                      = newGraph)                      and\n"
"(coalesce (oldOwner, -1)       = coalesce (newOwner, -1))       and\n"
"(coalesce (oldGroup, -1)       = coalesce (newGroup, -1))       and\n"
"(coalesce (oldPermissions, \'\') = coalesce (newPermissions, \'\')) and\n"
"(DB.DBA.DAV_DET_PRIVATE_ACL_COMPARE (oldAcls, newAcls))         and\n"
"(forceUpdate = 0)\n"
")\n"
"{\n"
"return;\n"
"}\n"
"\n"
"\n"
"if (oldGraph <> \'\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_REMOVE (id, \'R\', oldGraph, oldOwner, oldGroup, oldAcls);\n"
"}\n"
"\n"
"\n"
"if (newGraph <> \'\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_SET (id, \'R\', newGraph, newOwner, newGroup, newPermissions, newAcls, newRDFParams);\n"
"}\n"
"\n"
"}\n"
"--src dav_det.sql:1600\n"
;

static const char *proc517 = 
"#line 1665 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_GRAPH_PERMISSIONS_SET (\n"
"in id any,\n"
"in what varchar,\n"
"in newGraph varchar,\n"
"in newOwner integer,\n"
"in newGroup integer,\n"
"in newPermissions varchar,\n"
"in newAcls any,\n"
"in newRDFParams any)\n"
"{\n"
"\n"
"\n"
"\n"
"if (newPermissions[6] = ascii (\'1\'))\n"
"return;\n"
"\n"
"\n"
"\n"
"DB.DBA.DAV_DET_PRIVATE_GRAPH_ADD (newGraph);\n"
"\n"
"if (not isnull (newOwner))\n"
"DB.DBA.DAV_DET_PRIVATE_USER_ADD (newGraph, newOwner);\n"
"\n"
"\n"
"if ((not isnull (newGroup)) and (newOwner <> newGroup) and (newPermissions[3] = ascii (\'1\')))\n"
"DB.DBA.DAV_DET_PRIVATE_USER_ADD (newGraph, newGroup);\n"
"\n"
"\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_ADD (newGraph, newAcls);\n"
"\n"
"}\n"
"--src dav_det.sql:1663\n"
;

static const char *proc518 = 
"#line 1701 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_GRAPH_PERMISSIONS_REMOVE (\n"
"in id integer,\n"
"in what varchar,\n"
"in oldGraph varchar,\n"
"in oldOwner integer,\n"
"in oldGroup integer,\n"
"in oldAcls any)\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"if (not isnull (oldOwner))\n"
"DB.DBA.DAV_DET_PRIVATE_USER_REMOVE (oldGraph, oldOwner);\n"
"\n"
"\n"
"if ((not isnull (oldGroup)) and (oldOwner <> oldGroup))\n"
"DB.DBA.DAV_DET_PRIVATE_USER_REMOVE (oldGraph, oldGroup);\n"
"\n"
"\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_REMOVE (oldGraph, oldAcls);\n"
"\n"
"\n"
"\n"
"DB.DBA.DAV_DET_PRIVATE_GRAPH_REMOVE (oldGraph);\n"
"}\n"
"--src dav_det.sql:1699\n"
;

static const char *proc519 = 
"#line 1729 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_GRAPH_UPDATE_CURRENT (\n"
"in id integer,\n"
"in what varchar,\n"
"in mode varchar)\n"
"{\n"
"\n"
"declare _oldAcls, _newAcls any;\n"
"declare _acis any;\n"
"declare _rdfParams any;\n"
"\n"
"if (what = \'R\')\n"
"{\n"
"for (select RES_ID        as _id,\n"
"RES_TYPE      as _type,\n"
"RES_ACL       as _acl,\n"
"RES_OWNER     as _owner,\n"
"RES_GROUP     as _group,\n"
"RES_PERMS     as _perms,\n"
"RES_FULL_PATH as _path,\n"
"RES_COL       as _parent_id\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = id and RES_TYPE = \'text/turtle\') do\n"
"{\n"
"\n"
"_oldAcls := vector (_acl);\n"
"_newAcls := vector (_acl);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (_parent_id, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (_path), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_RES_GRAPH_UPDATE (\n"
"_id,\n"
"\'\',\n"
"_type,\n"
"_type,\n"
"_owner,\n"
"_owner,\n"
"_group,\n"
"_group,\n"
"_perms,\n"
"_perms,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams,\n"
"1\n"
");\n"
"}\n"
"}\n"
"\n"
"if (what = \'C\')\n"
"{\n"
"for (select COL_ID     as _id,\n"
"COL_ACL    as _acl,\n"
"COL_OWNER  as _owner,\n"
"COL_GROUP  as _group,\n"
"COL_PERMS  as _perms,\n"
"COL_PARENT as _parent_id\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = id) do\n"
"{\n"
"declare _path varchar;\n"
"\n"
"_path := DB.DBA.DAV_SEARCH_PATH (_id, \'C\');\n"
"\n"
"\n"
"_oldAcls := vector (_acl);\n"
"_newAcls := vector (_acl);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (_parent_id, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (_path), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE (\n"
"_id,\n"
"_owner,\n"
"_owner,\n"
"_group,\n"
"_group,\n"
"_perms,\n"
"_perms,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams,\n"
"1,\n"
"1\n"
");\n"
"}\n"
"}\n"
"}\n"
"--src dav_det.sql:1727\n"
;

static const char *proc520 = 
"#line 1821 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_GRAPH_UPDATE_CHILD (\n"
"in id integer,\n"
"in what varchar,\n"
"in oldAcls any,\n"
"in newAcls any,\n"
"in oldRDFParams any,\n"
"in newRDFParams any,\n"
"in forceUpdate integer := 0)\n"
"{\n"
"\n"
"declare _oldAcls, _newAcls any;\n"
"declare _aci, _acis, _rdfParams any;\n"
"\n"
"for (select RES_ID    as _id,\n"
"RES_TYPE  as _type,\n"
"RES_ACL   as _acl,\n"
"RES_OWNER as _owner,\n"
"RES_GROUP as _group,\n"
"RES_PERMS as _perms,\n"
"RES_FULL_PATH as _path\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_COL = id and RES_TYPE = \'text/turtle\') do\n"
"{\n"
"\n"
"if (length (_acl) > 8)\n"
"{\n"
"_oldAcls := vector_concat (oldAcls, vector (_acl));\n"
"_newAcls := vector_concat (newAcls, vector (_acl));\n"
"}\n"
"else\n"
"{\n"
"_oldAcls := oldAcls;\n"
"_newAcls := newAcls;\n"
"}\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (_path), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_RES_GRAPH_UPDATE (\n"
"_id,\n"
"\'\',\n"
"_type,\n"
"_type,\n"
"_owner,\n"
"_owner,\n"
"_group,\n"
"_group,\n"
"_perms,\n"
"_perms,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams,\n"
"forceUpdate\n"
");\n"
"}\n"
"\n"
"for (select COL_ID    as _id,\n"
"COL_ACL   as _acl,\n"
"COL_OWNER as _owner,\n"
"COL_GROUP as _group,\n"
"COL_PERMS as _perms\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = id) do\n"
"{\n"
"declare _path varchar;\n"
"\n"
"_path := DB.DBA.DAV_SEARCH_PATH (_id, \'C\');\n"
"\n"
"\n"
"if (length (_acl) > 8)\n"
"{\n"
"_oldAcls := vector_concat (oldAcls, vector (_acl));\n"
"_newAcls := vector_concat (newAcls, vector (_acl));\n"
"}\n"
"else\n"
"{\n"
"_oldAcls := oldAcls;\n"
"_newAcls := newAcls;\n"
"}\n"
"\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (_path), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE (\n"
"_id,\n"
"_owner,\n"
"_owner,\n"
"_group,\n"
"_group,\n"
"_perms,\n"
"_perms,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams,\n"
"forceUpdate,\n"
"0\n"
");\n"
"\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE_CHILD (\n"
"_id,\n"
"\'C\',\n"
"_oldAcls,\n"
"_newAcls,\n"
"_rdfParams,\n"
"_rdfParams,\n"
"forceUpdate\n"
");\n"
"}\n"
"}\n"
"--src dav_det.sql:1819\n"
;

static const char *proc521 = 
"#line 1933 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_COL_DET (\n"
"in _id integer,\n"
"in _mode integer := 1)\n"
"{\n"
"declare _det varchar;\n"
"\n"
"_det := \'\';\n"
"if (_mode)\n"
"{\n"
"_det := coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = _id), \'\');\n"
"}\n"
"if (_det = \'\')\n"
"{\n"
"if (DB.DBA.DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT (_id, \'C\', \'virt:rdfSink-rdf\', 0)) is not null)\n"
"_det := \'rdfSink\';\n"
"}\n"
"\n"
"return _det;\n"
"}\n"
"--src dav_det.sql:1931\n"
;

static const char *proc522 = 
"#line 1954 \"[executable]/dav_det.sql\"\n"
"create function DB.DBA.DAV_DET_COL_RDF_PARAMS (\n"
"in _id integer,\n"
"out _det varchar,\n"
"out _rdfParams any)\n"
"{\n"
"declare _prop_name, _prop_value, V any;\n"
"declare exit handler for not found { return; };\n"
"\n"
"_det := DB.DBA.DAV_DET_COL_DET (_id);\n"
"if (_det = \'\')\n"
"return 0;\n"
"\n"
"_rdfParams := DB.DBA.DAV_DET_RDF_PARAMS_GET (_det, _id);\n"
"\n"
"return length ( _rdfParams);\n"
"}\n"
"--src dav_det.sql:1952\n"
;

static const char *trig39 = 
"#line 1978 \"[executable]/dav_det.sql\"\n"
"create trigger SYS_DAV_COL_PRIVATE_GRAPH_I after insert on WS.WS.SYS_DAV_COL order 111 referencing new as N\n"
"{\n"
"\n"
"declare _newPath varchar;\n"
"declare _oldAcls, _newAcls any;\n"
"declare _acis, _rdfParams any;\n"
"\n"
"\n"
"_newPath := DB.DBA.DAV_SEARCH_PATH (N.COL_ID, \'C\');\n"
"\n"
"\n"
"_oldAcls := vector ();\n"
"_newAcls := vector (N.COL_ACL);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (N.COL_PARENT, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_rdfParams := vector (\'graph\', WS.WS.DAV_IRI (_newPath), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_SET (\n"
"N.COL_ID,\n"
"\'C\',\n"
"WS.WS.DAV_IRI (_newPath),\n"
"N.COL_OWNER,\n"
"N.COL_GROUP,\n"
"N.COL_PERMS,\n"
"_newAcls,\n"
"_rdfParams\n"
");\n"
"}\n"
"--src dav_det.sql:1976\n";

static const char *trig40 = 
"#line 2008 \"[executable]/dav_det.sql\"\n"
"create trigger SYS_DAV_COL_PRIVATE_GRAPH_U after update (COL_NAME, COL_OWNER, COL_GROUP, COL_PERMS, COL_ACL) on WS.WS.SYS_DAV_COL order 111 referencing old as O, new as N\n"
"{\n"
"\n"
"declare _oldPath, _newPath varchar;\n"
"declare _oldAcls, _newAcls any;\n"
"declare _acis, _oldRDFParams, _newRDFParams any;\n"
"\n"
"\n"
"_oldPath := DB.DBA.DAV_SEARCH_PATH (N.COL_PARENT, \'C\') || O.COL_NAME || \'/\';\n"
"_newPath := DB.DBA.DAV_SEARCH_PATH (N.COL_ID, \'C\');\n"
"\n"
"\n"
"_oldAcls := vector (O.COL_ACL);\n"
"_newAcls := vector (N.COL_ACL);\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (N.COL_PARENT, \'C\', _oldAcls, _newAcls);\n"
"\n"
"\n"
"_oldRDFParams := vector (\'graph\', WS.WS.DAV_IRI (_oldPath), \'graphSecurityACI\', _acis);\n"
"_newRDFParams := vector (\'graph\', WS.WS.DAV_IRI (_newPath), \'graphSecurityACI\', _acis);\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE (\n"
"N.COL_ID,\n"
"O.COL_OWNER,\n"
"N.COL_OWNER,\n"
"O.COL_GROUP,\n"
"N.COL_GROUP,\n"
"O.COL_PERMS,\n"
"N.COL_PERMS,\n"
"_oldAcls,\n"
"_newAcls,\n"
"_oldRDFParams,\n"
"_newRDFParams,\n"
"0,\n"
"1\n"
");\n"
"}\n"
"--src dav_det.sql:2006\n";

static const char *trig41 = 
"#line 2045 \"[executable]/dav_det.sql\"\n"
"create trigger SYS_DAV_COL_PRIVATE_GRAPH_D after delete on WS.WS.SYS_DAV_COL order 111 referencing old as O\n"
"{\n"
"\n"
"declare _acl, _oldAcls, _newAcls any;\n"
"\n"
"\n"
"_oldAcls := vector (O.COL_ACL);\n"
"_newAcls := vector ();\n"
"DB.DBA.DAV_DET_PRIVATE_ACL_CHAIN (O.COL_PARENT, \'C\', _oldAcls, _newAcls);\n"
"\n"
"DB.DBA.DAV_DET_GRAPH_PERMISSIONS_REMOVE (\n"
"O.COL_ID,\n"
"\'C\',\n"
"WS.WS.DAV_IRI (DB.DBA.DAV_SEARCH_PATH (O.COL_ID, \'C\')),\n"
"O.COL_OWNER,\n"
"O.COL_GROUP,\n"
"_oldAcls\n"
");\n"
"}\n"
"--src dav_det.sql:2043\n";

static const char *trig42 = 
"#line 2067 \"[executable]/dav_det.sql\"\n"
"create trigger SYS_DAV_PROP_PRIVATE_GRAPH_I after insert on WS.WS.SYS_DAV_PROP order 111 referencing new as N\n"
"{\n"
"\n"
"if (N.PROP_NAME = \'virt:aci_meta_n3\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE_CURRENT (N.PROP_PARENT_ID, N.PROP_TYPE, \'I\');\n"
"}\n"
"else if ((N.PROP_TYPE = \'C\') and (N.PROP_NAME = \'LDP\'))\n"
"{\n"
"DB.DBA.DAV_DET_LDP_GRAPH_UPDATE (N.PROP_PARENT_ID);\n"
"}\n"
"else if ((N.PROP_TYPE = \'C\') and (N.PROP_NAME like \'virt:%-rdf\'))\n"
"{\n"
"\n"
"declare _newRDFParams any;\n"
"\n"
"_newRDFParams := deserialize (N.PROP_VALUE);\n"
"DB.DBA.DAV_DET_RDF_GRAPH_UPDATE (N.PROP_PARENT_ID, null, _newRDFParams);\n"
"}\n"
"}\n"
"--src dav_det.sql:2065\n";

static const char *trig43 = 
"#line 2089 \"[executable]/dav_det.sql\"\n"
"create trigger SYS_DAV_PROP_PRIVATE_GRAPH_U after update (PROP_VALUE) on WS.WS.SYS_DAV_PROP order 111 referencing old as O, new as N\n"
"{\n"
"\n"
"if (N.PROP_NAME = \'virt:aci_meta_n3\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE_CURRENT (N.PROP_PARENT_ID, N.PROP_TYPE, \'U\');\n"
"}\n"
"else if ((N.PROP_TYPE = \'C\') and (N.PROP_NAME = \'LDP\'))\n"
"{\n"
"DB.DBA.DAV_DET_LDP_GRAPH_UPDATE (N.PROP_PARENT_ID);\n"
"}\n"
"else if ((N.PROP_TYPE = \'C\') and (N.PROP_NAME like \'virt:%-rdf\'))\n"
"{\n"
"\n"
"declare _oldRDFParams, _newRDFParams any;\n"
"\n"
"_oldRDFParams := deserialize (O.PROP_VALUE);\n"
"_newRDFParams := deserialize (N.PROP_VALUE);\n"
"DB.DBA.DAV_DET_RDF_GRAPH_UPDATE (N.PROP_PARENT_ID, _oldRDFParams, _newRDFParams);\n"
"}\n"
"}\n"
"--src dav_det.sql:2087\n";

static const char *trig44 = 
"#line 2112 \"[executable]/dav_det.sql\"\n"
"create trigger SYS_DAV_PROP_PRIVATE_GRAPH_D before delete on WS.WS.SYS_DAV_PROP order 111 referencing old as O\n"
"{\n"
"\n"
"if (O.PROP_NAME = \'virt:aci_meta_n3\')\n"
"{\n"
"DB.DBA.DAV_DET_GRAPH_UPDATE_CURRENT (O.PROP_PARENT_ID, O.PROP_TYPE, \'D\');\n"
"}\n"
"else if ((O.PROP_TYPE = \'C\') and (O.PROP_NAME = \'LDP\'))\n"
"{\n"
"DB.DBA.DAV_DET_LDP_GRAPH_UPDATE (O.PROP_PARENT_ID);\n"
"}\n"
"else if ((O.PROP_TYPE = \'C\') and (O.PROP_NAME like \'virt:%-rdf\'))\n"
"{\n"
"\n"
"declare _oldRDFParams any;\n"
"\n"
"_oldRDFParams := deserialize (O.PROP_VALUE);\n"
"DB.DBA.DAV_DET_RDF_GRAPH_UPDATE (O.PROP_PARENT_ID, _oldRDFParams, null);\n"
"}\n"
"}\n"
"--src dav_det.sql:2110\n";

static const char *proc523 = 
"#line 2134 \"[executable]/dav_det.sql\"\n"
"create procedure DB.DBA.DAV_DET_RDF_UPDATE ()\n"
"{\n"
"declare N integer;\n"
"declare tmp, keys, rdf_params any;\n"
"\n"
"if (isstring (registry_get (\'DAV_DET_RDF_UPDATE\')))\n"
"return;\n"
"\n"
"keys := vector (\'sponger\', \'off\', \'cartridges\', \'\', \'metaCartridges\', \'\', \'graph\', \'\', \'base\', \'\');\n"
"for (select COL_ID, COL_DET from WS.WS.SYS_DAV_COL where coalesce (COL_DET, \'\') <> \'\') do\n"
"{\n"
"if (DB.DBA.DAV_DET_IS_SPECIAL (COL_DET))\n"
"{\n"
"rdf_params := vector ();\n"
"for (N := 0; N < length (keys); N := N + 2)\n"
"{\n"
"tmp := DB.DBA.DAV_PROP_GET_INT (COL_ID, \'C\', sprintf (\'virt:%s-%s\', COL_DET, keys[N]), 0);\n"
"if (DB.DBA.DAV_HIDE_ERROR (tmp) is not null)\n"
"{\n"
"if (tmp <> keys[N+1])\n"
"{\n"
"rdf_params := vector_concat (rdf_params, vector (keys[N], tmp));\n"
"}\n"
"DB.DBA.DAV_DET_PARAM_REMOVE (COL_DET, COL_ID, \'C\', keys[N]);\n"
"}\n"
"}\n"
"if (length (rdf_params))\n"
"{\n"
"set triggers off;\n"
"DB.DBA.DAV_DET_RDF_PARAMS_SET_INT (COL_DET, COL_ID, rdf_params);\n"
"set triggers on;\n"
"}\n"
"}\n"
"}\n"
"\n"
"registry_set (\'DAV_DET_RDF_UPDATE\', \'done\');\n"
"}\n"
"--src dav_det.sql:2132\n"
;


static const char *other15 = 
" DB.DBA.DAV_DET_RDF_UPDATE ()\n";
/* DET_CatFilter.sql */

static const char *proc524 = 
"#line 30 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_GET_CONDITION\" (\n"
"in detcol_id integer,\n"
"out cfc_id integer,\n"
"out rfc_spath varchar,\n"
"out rfc_list_cond any,\n"
"out rfc_del_action any)\n"
"{\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"if (isarray (detcol_id))\n"
"return -20;\n"
"\n"
"select cast (\"ResFilter_NORM\" (PROP_VALUE) as integer) into cfc_id from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:CatFilter-ID\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"\n"
"select \"ResFilter_NORM\" (PROP_VALUE) into rfc_spath from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-SearchPath\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_list_cond from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-ListCond\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_del_action from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-DelAction\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"\n"
"return 0;\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src DET_CatFilter.sql:28\n"
;

static const char *proc525 = 
"#line 58 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_AUTHENTICATE\" (\n"
"in id any,\n"
"in what char(1),\n"
"in req varchar,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath, tmp_perms varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare rc, spath_id, n integer;\n"
"\n"
"rfc_spath := null;\n"
"if (DAV_HIDE_ERROR (\"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action)) is null)\n"
"return -1;\n"
"\n"
"if (not (\'110\' like req))\n"
"return -13;\n"
"\n"
"spath_id := DAV_SEARCH_ID (rfc_spath, \'C\');\n"
"if (not isinteger (spath_id))\n"
"return -13;\n"
"\n"
"if (DAV_HIDE_ERROR (spath_id) is null)\n"
"return spath_id;\n"
"\n"
"rc := DAV_AUTHENTICATE (spath_id, \'C\', req, auth_uname, auth_pwd, auth_uid);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"if (\'C\' = what)\n"
"{\n"
"n := length (id[4]);\n"
"if ((n = 0) or (mod (n, 4) = 2))\n"
"tmp_perms := \'100\';\n"
"\n"
"else if (length (rfc_del_action) < length (rfc_list_cond))\n"
"tmp_perms := \'100\';\n"
"\n"
"else\n"
"tmp_perms := \'110\';\n"
"\n"
"if (not (tmp_perms like req))\n"
"return -13;\n"
"\n"
"return auth_uid;\n"
"}\n"
"else if (\'R\' = what)\n"
"{\n"
"return DAV_AUTHENTICATE (id [2], \'R\', req, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"\n"
"return -14;\n"
"}\n"
"--src DET_CatFilter.sql:56\n"
;

static const char *proc526 = 
"#line 117 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_ENCODE_CATVALUE\" (\n"
"in val varchar) returns varchar\n"
"{\n"
"declare ses any;\n"
"declare ctr, len integer;\n"
"declare lastspace integer;\n"
"\n"
"if (val is null)\n"
"return \'! property is not set !\';\n"
"\n"
"if (__tag (val) = 230)\n"
"val := cast (val as varchar);\n"
"\n"
"len := length (val);\n"
"if (len = 0)\n"
"return \'! empty property value !\';\n"
"\n"
"if (len > 70)\n"
"{\n"
"val := subseq (val, 0, 65);\n"
"lastspace := strrchr (val, \' \');\n"
"if (lastspace is not null)\n"
"val := subseq (val, 0, lastspace) || \' . . .\';\n"
"else\n"
"val := val || \'...\';\n"
"}\n"
"\n"
"ses := string_output ();\n"
"len := length (val);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"declare ch integer;\n"
"\n"
"ch := val [ctr];\n"
"if ((ch < 32) or (ch = 47) or (ch = 92) or (ch = 37) or (ch = 58) or ((ch = 40) and (ctr = 0)))\n"
"http (sprintf (\'^%02x\', ch), ses);\n"
"else\n"
"http (chr (ch), ses);\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src DET_CatFilter.sql:115\n"
;

static const char *proc527 = 
"#line 161 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DECODE_CATVALUE\" (\n"
"in catval varchar,\n"
"out crop integer)\n"
"{\n"
"declare catvallen integer;\n"
"\n"
"if (\'! empty property value !\' = catval)\n"
"{\n"
"crop := 0;\n"
"return \'\';\n"
"}\n"
"\n"
"if (\'! property is not set !\' = catval)\n"
"{\n"
"crop := 4;\n"
"return null;\n"
"}\n"
"\n"
"catvallen := length (catval);\n"
"if ((catvallen >= 6) and (subseq (catval, catvallen - 6) = \' . . .\'))\n"
"{\n"
"crop := 1;\n"
"catvallen := catvallen - 6;\n"
"catval := subseq (catval, 0, catvallen);\n"
"}\n"
"else if ((catvallen >= 3) and (subseq (catval, catvallen - 3) = \'...\'))\n"
"{\n"
"crop := 2;\n"
"catvallen := catvallen - 3;\n"
"catval := subseq (catval, 0, catvallen);\n"
"}\n"
"else\n"
"{\n"
"crop := 0;\n"
"}\n"
"\n"
"return split_and_decode (catval, 0, \'^\');\n"
"}\n"
"--src DET_CatFilter.sql:159\n"
;

static const char *proc528 = 
"#line 202 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_PATH_PARTS_TO_FILTER\" (\n"
"inout path_parts any,\n"
"out schema_uri varchar,\n"
"out filter_data any) returns integer\n"
"{\n"
"declare prop_catnames varchar;\n"
"declare pathctr, filtctr, pathlen integer;\n"
"declare filt any;\n"
"\n"
"pathlen := length (path_parts) - 1;\n"
"if (0 >= pathlen)\n"
"{\n"
"schema_uri := null;\n"
"filter_data := null;\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"\n"
"retry_after_recomp:\n"
"whenever not found goto no_schema;\n"
"select RS_URI, deserialize (blob_to_string (RS_PROP_CATNAMES)) into schema_uri, prop_catnames from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = path_parts[0] and RS_PROP_CATNAMES is not null;\n"
"filt := make_array (2 * (pathlen - 1), \'any\');\n"
"filtctr := 0;\n"
"for (pathctr := 1; pathctr < pathlen; pathctr := pathctr + 2)\n"
"{\n"
"declare pos integer;\n"
"\n"
"pos := position (path_parts [pathctr], prop_catnames, 2, 6);\n"
"if (0 = pos)\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"filt [filtctr] := prop_catnames [pos - 2];\n"
"filt [filtctr + 1] := prop_catnames [pos];\n"
"if (pathctr < (pathlen - 1))\n"
"{\n"
"declare crop_mode integer;\n"
"\n"
"filt [filtctr + 2] := \"CatFilter_DECODE_CATVALUE\" (path_parts [pathctr + 1], crop_mode);\n"
"filt [filtctr + 3] := crop_mode;\n"
"}\n"
"filtctr := filtctr + 4;\n"
"}\n"
"filter_data := filt;\n"
"return 0;\n"
"\n"
"no_schema:\n"
"\n"
"if (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = path_parts[0] and RS_PROP_CATNAMES is null))\n"
"{\n"
"DAV_GET_RDF_SCHEMA_N3 ((select RS_URI from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = path_parts[0]));\n"
"goto retry_after_recomp;\n"
"}\n"
"\n"
"return -1;\n"
"}\n"
"--src DET_CatFilter.sql:200\n"
;

static const char *proc529 = 
"#line 263 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_ACC_FILTER_DATA\" (\n"
"inout filter any,\n"
"inout filter_data any)\n"
"{\n"
"declare ctr, len integer;\n"
"declare crop_mode integer;\n"
"declare pred any;\n"
"\n"
"len := length (filter_data);\n"
"len := len - mod (len, 4);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 4)\n"
"{\n"
"crop_mode := filter_data [ctr + 3];\n"
"if (crop_mode = 0)\n"
"{\n"
"pred := vector (\'RDF_VALUE\', \'=\', filter_data [ctr + 2], \'http://local.virt/DAV-RDF\', filter_data [ctr]);\n"
"}\n"
"else if (crop_mode = 4)\n"
"{\n"
"pred := vector (\'RDF_VALUE\', \'is_null\', \'http://local.virt/DAV-RDF\', filter_data [ctr]);\n"
"}\n"
"else\n"
"{\n"
"pred := vector (\'RDF_VALUE\', \'starts_with\', filter_data [ctr + 2], \'http://local.virt/DAV-RDF\', filter_data [ctr]);\n"
"}\n"
"vectorbld_acc (filter, pred);\n"
"}\n"
"}\n"
"--src DET_CatFilter.sql:261\n"
;

static const char *proc530 = 
"#line 294 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_SEARCH_ID_IMPL\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in what char(1),\n"
"inout cfc_id integer,\n"
"inout rfc_spath varchar,\n"
"inout rfc_list_cond any,\n"
"inout rfc_del_action any,\n"
"inout filter_data any) returns any\n"
"{\n"
"\n"
"declare schema_uri, res_name, colpath, orig_fnameext varchar;\n"
"declare filter, orig_id any;\n"
"declare path_len, len integer;\n"
"declare execstate, execmessage varchar;\n"
"declare execmeta, execrows any;\n"
"declare qry_text varchar;\n"
"\n"
"path_len := length (path_parts);\n"
"if (0 = path_len)\n"
"return -1;\n"
"\n"
"if (not isstring (rfc_spath))\n"
"{\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"return -1;\n"
"}\n"
"\n"
"res_name := path_parts [path_len - 1];\n"
"if (\'\' = res_name)\n"
"{\n"
"if (\'R\' = what)\n"
"return -1;\n"
"}\n"
"else\n"
"{\n"
"if (\'C\' = what)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (1 = path_len)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (2 = path_len)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (1 = mod (path_len, 2))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"}\n"
"if (0 > \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (\'C\' = what)\n"
"{\n"
"return DB.DBA.CatFilter__id (detcol_id, null, schema_uri, filter_data);\n"
"}\n"
"\n"
"\"ResFilter_FNSPLIT\" (res_name, colpath, orig_fnameext, orig_id);\n"
"\n"
"\n"
"\n"
"if (isarray (orig_id))\n"
"return orig_id;\n"
"\n"
"len := length (filter_data);\n"
"vectorbld_init (filter);\n"
"\"CatFilter_ACC_FILTER_DATA\" (filter, filter_data);\n"
"vectorbld_concat_acc (filter, get_keyword (\'\', rfc_list_cond));\n"
"if (orig_id is not null)\n"
"{\n"
"if (isinteger (orig_id))\n"
"vectorbld_acc (filter, vector (\'RES_ID\', \'=\', orig_id));\n"
"else\n"
"vectorbld_acc (filter, vector (\'RES_ID_SERIALIZED\', \'=\', serialize (orig_id)));\n"
"}\n"
"vectorbld_final (filter);\n"
"\n"
"qry_text := \'\n"
"select top 2 RES_ID\n"
"from WS.WS.SYS_DAV_RES as _top \' || DAV_FC_PRINT_WHERE (filter, coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), -1)) || \' and (_top.RES_NAME = ?) and (_top.RES_FULL_PATH between ? and ?)\';\n"
"\n"
"exec (qry_text, execstate, execmessage, vector (orig_fnameext, rfc_spath, DAV_COL_PATH_BOUNDARY (rfc_spath)), 100000000, execmeta, execrows );\n"
"if (length (execrows) <> 1)\n"
"return -1;\n"
"\n"
"return DB.DBA.CatFilter__id (detcol_id, execrows[0][0], schema_uri, filter_data);\n"
"}\n"
"--src DET_CatFilter.sql:292\n"
;

static const char *proc531 = 
"#line 394 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_AUTHENTICATE_HTTP\" (\n"
"in id any,\n"
"in what char(1),\n"
"in req varchar,\n"
"in can_write_http integer,\n"
"inout a_lines any,\n"
"inout a_uname varchar,\n"
"inout a_pwd varchar,\n"
"inout a_uid integer,\n"
"inout a_gid integer,\n"
"inout _perms varchar) returns integer\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath, tmp_perms varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare rc, spath_id, n integer;\n"
"\n"
"rfc_spath := null;\n"
"rc := DAV_HIDE_ERROR (\"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action));\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"\n"
"if (not (\'110\' like req))\n"
"return -13;\n"
"\n"
"spath_id := DAV_SEARCH_ID (rfc_spath, \'C\');\n"
"\n"
"if (not isinteger (spath_id))\n"
"return -13;\n"
"\n"
"if (DAV_HIDE_ERROR (spath_id) is null)\n"
"return spath_id;\n"
"\n"
"rc := DAV_AUTHENTICATE_HTTP (spath_id, \'C\', req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, _perms);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"if (\'C\' = what)\n"
"{\n"
"n := length (id[4]);\n"
"if ((n = 0) or (mod (n, 4) = 2))\n"
"{\n"
"tmp_perms := \'100\';\n"
"}\n"
"else if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"tmp_perms := \'100\';\n"
"}\n"
"else\n"
"{\n"
"tmp_perms := \'110\';\n"
"}\n"
"\n"
"if (not (tmp_perms like req))\n"
"return -13;\n"
"\n"
"return a_uid;\n"
"}\n"
"\n"
"if (\'R\' = what)\n"
"{\n"
"return DAV_AUTHENTICATE_HTTP (id[2], \'R\', req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, _perms);\n"
"}\n"
"\n"
"return -14;\n"
"}\n"
"--src DET_CatFilter.sql:392\n"
;

static const char *proc532 = 
"#line 467 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_GET_PARENT\" (\n"
"in id any,\n"
"in st char(1),\n"
"in path varchar) returns any\n"
"{\n"
"\n"
"\n"
"if (st = \'R\')\n"
"{\n"
"id [2] := null;\n"
"return id;\n"
"}\n"
"\n"
"if (st = \'C\')\n"
"{\n"
"declare vlen integer;\n"
"\n"
"vlen := length (id[4]);\n"
"if (vlen = 0)\n"
"return id [1];\n"
"\n"
"id [4] := subseq (id [4], 0, vlen - 1);\n"
"return id;\n"
"}\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:465\n"
;

static const char *proc533 = 
"#line 497 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_COL_CREATE\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:495\n"
;

static const char *proc534 = 
"#line 511 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_COL_MOUNT\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in full_mount_path varchar,\n"
"in mount_det varchar,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:509\n"
;

static const char *proc535 = 
"#line 527 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_COL_MOUNT_HERE\" (\n"
"in parent_id any,\n"
"in full_mount_path varchar,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:525\n"
;

static const char *proc536 = 
"#line 541 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_DELETE\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in what char(1),\n"
"in silent integer,\n"
"in auth_uid integer) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare cfc_id integer;\n"
"declare rfc_spath, propname varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare orig_id, filter_data, whole_rdf, vals, new_rdf any;\n"
"\n"
"rfc_spath := null;\n"
"orig_id := \"CatFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action, filter_data);\n"
"if (DAV_HIDE_ERROR (orig_id) is null)\n"
"return orig_id;\n"
"\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"return -13;\n"
"\n"
"if (\'R\' <> what)\n"
"return -20;\n"
"\n"
"whole_rdf := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = orig_id [2]);\n"
"if (whole_rdf is null)\n"
"return -1;\n"
"\n"
"if (not isstring (whole_rdf))\n"
"whole_rdf := blob_to_string (whole_rdf);\n"
"\n"
"whole_rdf := xml_tree_doc (deserialize (whole_rdf));\n"
"propname := filter_data [length (filter_data) - 4];\n"
"\n"
"vals := xpath_eval (\n"
"\'[xmlns:virt=\"virt\"] /virt:rdf/virt:top-res/virt:prop[*[1][name(.) = \\044propname]][virt:value]\',\n"
"whole_rdf, 0, vector (\'propname\', filter_data [length (filter_data) - 4]) );\n"
"\n"
"foreach (any val in vals) do\n"
"{\n"
"declare cval, decenc_val varchar;\n"
"declare crop integer;\n"
"\n"
"cval := cast (xpath_eval (\'[xmlns:virt=\"virt\"] string (virt:value)\', val, 1) as varchar);\n"
"decenc_val := \"CatFilter_DECODE_CATVALUE\" (\"CatFilter_ENCODE_CATVALUE\" (cval), crop);\n"
"\n"
"if (decenc_val = filter_data [length (filter_data) - 2])\n"
"{\n"
"\n"
"XMLReplace (whole_rdf, val, null);\n"
"}\n"
"}\n"
"new_rdf := xte_node (xte_head (UNAME\' root\'), whole_rdf);\n"
"update WS.WS.SYS_DAV_PROP set prop_value = serialize (new_rdf) where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = orig_id [2];\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:539\n"
;

static const char *proc537 = 
"#line 601 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_FILTER_TO_CONDITION\" (\n"
"inout schema_uri varchar,\n"
"inout filter_data any,\n"
"inout cond any) returns integer\n"
"{\n"
"declare ctr, len integer;\n"
"\n"
"if (schema_uri is null)\n"
"return -13;\n"
"\n"
"len := length (filter_data);\n"
"if ((len = 0) or (0 <> mod (len, 4)))\n"
"return -13;\n"
"\n"
"vectorbld_init (cond);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 4)\n"
"{\n"
"declare sample varchar;\n"
"declare crop integer;\n"
"\n"
"crop := filter_data [ctr + 3];\n"
"\n"
"if (2 = crop)\n"
"return -13;\n"
"\n"
"if (1 = crop)\n"
"return -13;\n"
"\n"
"sample := filter_data [ctr + 2];\n"
"vectorbld_acc (cond, vector (\'RDF_VALUE\', \'=\', sample, \'http://local.virt/DAV-RDF\', filter_data [ctr]));\n"
"}\n"
"vectorbld_final (cond);\n"
"\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:599\n"
;

static const char *proc538 = 
"#line 638 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_RES_UPLOAD\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"inout content any,\n"
"in type varchar,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare cfc_id integer;\n"
"declare rfc_spath, propname, schema_uri, _colpath, fnameext, orig_fnameext, orig_fullpath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare orig_id, filter_data, fit_cond any;\n"
"\n"
"rfc_spath := null;\n"
"rc := \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"return -13;\n"
"\n"
"schema_uri := null;\n"
"rc := \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"rc := \"CatFilter_FILTER_TO_CONDITION\" (schema_uri, filter_data, fit_cond);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"fit_cond := vector (\'\', vector_concat (fit_cond, get_keyword (\'\', rfc_list_cond)));\n"
"\n"
"fnameext := path_parts [length (path_parts) - 1];\n"
"\"ResFilter_FNSPLIT\" (fnameext, _colpath, orig_fnameext, orig_id);\n"
"orig_fullpath := null;\n"
"if (orig_id is not null)\n"
"orig_fullpath := DAV_HIDE_ERROR (DAV_SEARCH_PATH (orig_id, \'R\'));\n"
"\n"
"if (orig_fullpath is null)\n"
"orig_fullpath := DAV_CONCAT_PATH (rfc_spath, orig_fnameext);\n"
"\n"
"orig_id := DAV_RES_UPLOAD_STRSES_INT (\n"
"orig_fullpath,\n"
"content, \'\',\n"
"permissions, \'\', \'\',\n"
"null, null, 0,\n"
"null, null, null,\n"
"uid, gid, 1 );\n"
"\n"
"if (DAV_HIDE_ERROR (orig_id) is null)\n"
"return orig_id;\n"
"\n"
"if (not (isinteger (orig_id)))\n"
"return -13;\n"
"\n"
"\"ResFilter_FIT_INTO_CONDITION\" (orig_id, \'R\', fit_cond, auth_uid);\n"
"return DB.DBA.CatFilter__id (detcol_id, orig_id, schema_uri, filter_data);\n"
"}\n"
"--src DET_CatFilter.sql:636\n"
;

static const char *proc539 = 
"#line 702 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_PROP_REMOVE\" (\n"
"in id any,\n"
"in st char(1),\n"
"in propname varchar,\n"
"in silent integer,\n"
"in auth_uid integer) returns integer\n"
"{\n"
"\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, st, propname, silent, auth_uid);\n"
"\n"
"return DAV_PROP_REMOVE_RAW (id, st, propname, silent, auth_uid);\n"
"}\n"
"--src DET_CatFilter.sql:700\n"
;

static const char *proc540 = 
"#line 723 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_PROP_SET\" (\n"
"in id any,\n"
"in st char(1),\n"
"in propname varchar,\n"
"in propvalue any,\n"
"in overwrite integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, st, propname, propvalue, overwrite, auth_uid);\n"
"\n"
"return DAV_PROP_SET_RAW (id, st, propname, propvalue, overwrite, auth_uid);\n"
"}\n"
"--src DET_CatFilter.sql:721\n"
;

static const char *proc541 = 
"#line 745 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_PROP_GET\" (\n"
"in id any,\n"
"in what char(1),\n"
"in propname varchar,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"declare ret varchar;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"\n"
"if (propname[0] = 58)\n"
"return DAV_PROP_GET_INT (id, what, propname, 0, null, null, auth_uid);\n"
"\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src DET_CatFilter.sql:743\n"
;

static const char *proc542 = 
"#line 771 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_PROP_LIST\" (\n"
"in id any,\n"
"in what char(1),\n"
"in propmask varchar,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"declare ret any;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_LIST\') (id, what, propmask, auth_uid);\n"
"\n"
"vectorbld_init (ret);\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do\n"
"{\n"
"vectorbld_acc (ret, vector (PROP_NAME, blob_to_string (PROP_VALUE)));\n"
"}\n"
"vectorbld_final (ret);\n"
"return ret;\n"
"}\n"
"--src DET_CatFilter.sql:769\n"
;

static const char *proc543 = 
"#line 795 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_DIR_SINGLE\" (\n"
"in id any,\n"
"in what char(1),\n"
"in path any,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"\n"
"if (isnull (path))\n"
"path := DAV_SEARCH_PATH (id, what);\n"
"\n"
"if (\'C\' = what)\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare dirsingle, rfc_list_cond, rfc_del_action any;\n"
"declare loc_name, subcol_perms varchar;\n"
"declare set_readonly integer;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"return -1;\n"
"}\n"
"\n"
"dirsingle := DAV_DIR_SINGLE_INT (id[1], \'C\', \'fake\', null, null, null, 0);\n"
"\n"
"\n"
"subcol_perms := dirsingle[5];\n"
"subcol_perms[2] := 48;\n"
"subcol_perms[5] := 48;\n"
"subcol_perms[8] := 48;\n"
"set_readonly := 0;\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"set_readonly := 1;\n"
"}\n"
"else\n"
"{\n"
"declare filt_len integer;\n"
"\n"
"filt_len := length (id[4]);\n"
"if ((0 = filt_len) or (mod (filt_len, 4) = 2))\n"
"set_readonly := 1;\n"
"}\n"
"if (set_readonly)\n"
"{\n"
"\n"
"subcol_perms[1] := 48;\n"
"subcol_perms[4] := 48;\n"
"subcol_perms[7] := 48;\n"
"}\n"
"loc_name := path [length (path) - 2];\n"
"return vector (DAV_CONCAT_PATH (path, null), \'C\', 0, now (), id, subcol_perms, dirsingle[6], dirsingle[7], now (), \'dav/unix-directory\', loc_name );\n"
"}\n"
"if (isarray (id[2]))\n"
"{\n"
"declare diritem any;\n"
"declare merged varchar;\n"
"\n"
"diritem := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id[2], what, path, auth_uid);\n"
"merged := \"ResFilter_FNMERGE\" (diritem[10], id[2]);\n"
"diritem[0] := DAV_CONCAT_PATH (path, merged);\n"
"diritem[10] := merged;\n"
"\n"
"return diritem;\n"
"}\n"
"for (select RES_FULL_PATH, RES_ID, length (RES_CONTENT) as clen, RES_MOD_TIME, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME as r1_RES_NAME\n"
"from WS.WS.SYS_DAV_RES r1\n"
"where RES_ID = id[2]) do\n"
"{\n"
"declare merged varchar;\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', r1_RES_NAME, 0))\n"
"{\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"}\n"
"else\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action varchar;\n"
"declare tmp_comp, namesakes any;\n"
"declare namesakes_no integer;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"return -1;\n"
"}\n"
"tmp_comp := vector (\'\', vector_concat (vector (vector (\'RES_NAME\', \'=\', r1_RES_NAME)), get_keyword (\'\', rfc_list_cond) ) );\n"
"namesakes := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_comp, null, null, auth_uid);\n"
"namesakes_no := length (namesakes);\n"
"if (0 = namesakes_no)\n"
"return -1;\n"
"\n"
"if (1 < namesakes_no)\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"else\n"
"merged := r1_RES_NAME;\n"
"}\n"
"path [length (path) - 1] := merged;\n"
"\n"
"return vector (DAV_CONCAT_PATH (\'/\', path), \'R\', clen, RES_MOD_TIME, id, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, merged);\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_CatFilter.sql:793\n"
;

static const char *proc544 = 
"#line 903 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_LIST_SCHEMAS\" () returns any\n"
"{\n"
"return (select VECTOR_AGG (vector (RS_URI, RS_CATNAME)) from WS.WS.SYS_RDF_SCHEMAS);\n"
"}\n"
"--src DET_CatFilter.sql:901\n"
;

static const char *proc545 = 
"#line 909 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_LIST_SCHEMA_PROPS\" (\n"
"in rfc_spath varchar,\n"
"inout rfc_list_cond any,\n"
"inout schema_uri varchar,\n"
"inout filter_data any,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare prop_catnames, res any;\n"
"declare len, ctr integer;\n"
"\n"
"vectorbld_init (res);\n"
"\n"
"retry_after_recomp:\n"
"whenever not found goto schema_nf;\n"
"select deserialize (cast (RS_PROP_CATNAMES as varchar)) into prop_catnames from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri and RS_PROP_CATNAMES is not null;\n"
"len := length (prop_catnames);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 6)\n"
"{\n"
"if (0 = position (prop_catnames [ctr], filter_data, 1, 4))\n"
"vectorbld_acc (res, vector (prop_catnames [ctr], prop_catnames [ctr + 1]));\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"\n"
"schema_nf:\n"
"if (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri and RS_PROP_CATNAMES is null))\n"
"{\n"
"DAV_GET_RDF_SCHEMA_N3 (schema_uri);\n"
"goto retry_after_recomp;\n"
"}\n"
"\n"
"return vector();\n"
"}\n"
"--src DET_CatFilter.sql:907\n"
;

static const char *proc546 = 
"#line 946 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_GET_RDF_INVERSE_HITS_DISTVALS\" (\n"
"in cfc_id integer,\n"
"inout filter_data any,\n"
"inout distval_dict any,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_last_id, res_id_max integer;\n"
"declare plast_id integer;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val, v_last, v_max varchar;\n"
"declare auth_gid integer;\n"
"declare acl_bits, hit_ids any;\n"
"declare c_last1 cursor for select DRI_CATVALUE\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = plast_id\n"
"and (v_max is null or DRI_CATVALUE > v_max)\n"
"and exists (select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = DRI_RES_ID and case (DAV_CHECK_PERM (RES_PERMS, \'1__\', auth_uid, auth_gid, RES_GROUP, RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (RES_ACL, auth_uid, acl_bits) else 1 end);\n"
"declare c_last2 cursor for select DRI_RES_ID, DRI_CATVALUE\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = plast_id\n"
"and (v_max is null or DRI_CATVALUE > v_max)\n"
"and exists (select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = DRI_RES_ID and case (DAV_CHECK_PERM (RES_PERMS, \'1__\', auth_uid, auth_gid, RES_GROUP, RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (RES_ACL, auth_uid, acl_bits) else 1 end);\n"
"declare c0 cursor for select DRI_RES_ID\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = p0_id\n"
"and DRI_CATVALUE = p0_val\n"
"and DRI_RES_ID >= res_id_max;\n"
"declare c1 cursor for select DRI_RES_ID\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = p1_id\n"
"and DRI_CATVALUE = p1_val\n"
"and DRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select DRI_RES_ID\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = p2_id\n"
"and DRI_CATVALUE = p2_val\n"
"and DRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select DRI_RES_ID\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = p3_id\n"
"and DRI_CATVALUE = p3_val\n"
"and DRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select DRI_RES_ID\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id\n"
"and DRI_PROP_CATID = p4_id\n"
"and DRI_CATVALUE = p4_val\n"
"and DRI_RES_ID >= res_id_max;\n"
"\n"
"filter_length := length (filter_data);\n"
"plast_id := filter_data [filter_length - 1];\n"
"res_id_max := 0;\n"
"v_max := null;\n"
"auth_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = auth_uid), 0);\n"
"acl_bits := DAV_REQ_CHARS_TO_BITMASK (\'1__\');\n"
"\n"
"if (filter_length = 2)\n"
"{\n"
"whenever not found goto nf_c_last1;\n"
"\n"
"open c_last1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last1 into v_last;\n"
"\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"nf_c_last1:\n"
"close c_last1;\n"
"return;\n"
"}\n"
"\n"
"res0_id := 0;\n"
"res1_id := 0;\n"
"res2_id := 0;\n"
"res3_id := 0;\n"
"res4_id := 0;\n"
"hit_ids := dict_new ();\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 6)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 10)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"else\n"
"res_id_max := res_id_max + 1;\n"
"\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 14)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"\n"
"\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 18)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 22)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"\n"
"close c4;\n"
"get_distincts_3:\n"
"\n"
"close c3;\n"
"get_distincts_2:\n"
"\n"
"close c2;\n"
"get_distincts_1:\n"
"\n"
"close c1;\n"
"get_distincts_0:\n"
"\n"
"close c0;\n"
"\n"
"\n"
"whenever not found goto nf_c_last2;\n"
"open c_last2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last2 into res_last_id, v_last;\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"\n"
"if (dict_get (hit_ids, res_last_id, 0))\n"
"{\n"
"\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"}\n"
"nf_c_last2:\n"
"close c_last2;\n"
"}\n"
"--src DET_CatFilter.sql:944\n"
;

static const char *proc547 = 
"#line 1197 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_GET_RDF_INVERSE_HITS_RES_IDS\" (\n"
"in cfc_id integer,\n"
"inout filter_data any,\n"
"in auth_uid integer) returns any\n"
"{\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_id_max integer;\n"
"declare acc any;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val varchar;\n"
"declare acl_bits any;\n"
"declare auth_gid integer;\n"
"declare c0 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p0_id and DRI_CATVALUE = p0_val and DRI_RES_ID >= res_id_max and\n"
"exists (select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = DRI_RES_ID and case (DAV_CHECK_PERM (RES_PERMS, \'1__\', auth_uid, auth_gid, RES_GROUP, RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (RES_ACL, auth_uid, acl_bits) else 1 end);\n"
"declare c1 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p1_id and DRI_CATVALUE = p1_val and DRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p2_id and DRI_CATVALUE = p2_val and DRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p3_id and DRI_CATVALUE = p3_val and DRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p4_id and DRI_CATVALUE = p4_val and DRI_RES_ID >= res_id_max;\n"
"\n"
"filter_length := length (filter_data);\n"
"vectorbld_init (acc);\n"
"\n"
"res0_id := -1;\n"
"res1_id := -1;\n"
"res2_id := -1;\n"
"res3_id := -1;\n"
"res4_id := -1;\n"
"res_id_max := 0;\n"
"\n"
"auth_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = auth_uid), 0);\n"
"acl_bits := DAV_REQ_CHARS_TO_BITMASK (\'1__\');\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 4)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 8)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 12)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 16)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 20)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"close c4;\n"
"get_distincts_3:\n"
"close c3;\n"
"get_distincts_2:\n"
"close c2;\n"
"get_distincts_1:\n"
"close c1;\n"
"get_distincts_0:\n"
"close c0;\n"
"\n"
"finalize:\n"
"vectorbld_final (acc);\n"
"\n"
"return acc;\n"
"}\n"
"--src DET_CatFilter.sql:1195\n"
;

static const char *proc548 = 
"#line 1368 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_LIST_PROP_DISTVALS_AUX\" (\n"
"inout dict any,\n"
"inout rfp varchar,\n"
"inout vals any)\n"
"{\n"
"\n"
"\n"
"foreach (any val in vals) do\n"
"{\n"
"dict_put (dict, \"CatFilter_ENCODE_CATVALUE\" (cast (val as varchar)), 1);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_CatFilter.sql:1366\n"
;

static const char *proc549 = 
"#line 1383 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_LIST_PROP_DISTVALS\" (\n"
"in detcol_id integer,\n"
"in cfc_id integer,\n"
"in rfc_spath varchar,\n"
"inout rfc_list_cond any,\n"
"inout schema_uri varchar,\n"
"inout filter_data any,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare filter any;\n"
"\n"
"declare execstate, execmessage varchar;\n"
"declare execmeta, execrows any;\n"
"declare qry_ft, qry_where, qry_text varchar;\n"
"\n"
"declare pred_metas, cmp_metas, table_metas any;\n"
"declare used_tables any;\n"
"declare dict any;\n"
"declare auth_gid integer;\n"
"\n"
"dict := dict_new ();\n"
"\n"
"if ((length (get_keyword (\'\', rfc_list_cond)) = 0) and (length (filter_data) > 0) and (length (filter_data) <= 22))\n"
"{\n"
"\n"
"\"CatFilter_GET_RDF_INVERSE_HITS_DISTVALS\" (cfc_id, filter_data, dict, auth_uid);\n"
"\n"
"goto plain_resources_passed;\n"
"}\n"
"\n"
"vectorbld_init (filter);\n"
"\"CatFilter_ACC_FILTER_DATA\" (filter, filter_data);\n"
"vectorbld_concat_acc (filter, get_keyword (\'\', rfc_list_cond));\n"
"vectorbld_final (filter);\n"
"\n"
"\n"
"DAV_FC_PRED_METAS (pred_metas);\n"
"DAV_FC_CMP_METAS (cmp_metas);\n"
"DAV_FC_TABLE_METAS (table_metas);\n"
"qry_ft := sprintf (\'virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:value\', filter_data [length (filter_data)-2]);\n"
"used_tables := vector (\n"
"\'SYS_DAV_RES\', vector (\'SYS_DAV_RES\', \'_top\', null, vector(), vector(), vector()),\n"
"\'SYS_DAV_PROP, PROP_NAME=http://local.virt/DAV-RDF\', vector (\'SYS_DAV_PROP\', \'_rdf\', \'(_rdf.PROP_NAME = \'\'http://local.virt/DAV-RDF\'\')\', vector(), vector(), vector(\'[\' || qry_ft || \']\'))\n"
");\n"
"qry_where := DAV_FC_PRINT_WHERE_INT (filter, pred_metas, cmp_metas, table_metas, used_tables,\n"
"coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), -1));\n"
"\n"
"auth_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = auth_uid), 0);\n"
"\n"
"\n"
"qry_text := \'\n"
"select count ( \"CatFilter_LIST_PROP_DISTVALS_AUX\" (?, _top.RES_FULL_PATH,\n"
"xpath_eval (\'\'[xmlns:virt=\"virt\"] /\' || qry_ft ||\'\'\',\n"
"xml_tree_doc (deserialize (cast (_rdf.PROP_VALUE as varchar))),\n"
"0 ) ) )\n"
"from WS.WS.SYS_DAV_RES as _top\n"
"\' || qry_where || \' and\n"
"(_top.RES_FULL_PATH between \' || WS.WS.STR_SQL_APOS (rfc_spath) || \' and \' || WS.WS.STR_SQL_APOS (DAV_COL_PATH_BOUNDARY (rfc_spath)) || \') and\n"
"case (DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\')) else 1 end\n"
"\';\n"
"\n"
"exec (qry_text,\n"
"execstate, execmessage, vector (dict, auth_uid, auth_gid, auth_uid), 1, execmeta, execrows );\n"
"\n"
"\n"
"plain_resources_passed:\n"
"for (select CFD_DET_SUBCOL_ID, CFD_DET from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_CF_ID = cfc_id) do\n"
"{\n"
"if (exists (select top 1 1 from SYS_PROCEDURES where P_NAME = fix_identifier_case(\'DB.DBA.\') || CFD_DET || \'_CF_LIST_PROP_DISTVALS\'))\n"
"{\n"
"call (CFD_DET || \'_CF_LIST_PROP_DISTVALS\') (CFD_DET_SUBCOL_ID, cfc_id, rfc_spath, rfc_list_cond, schema_uri, filter_data, dict, auth_uid);\n"
"}\n"
"}\n"
"return dict_list_keys (dict, 1);\n"
"}\n"
"--src DET_CatFilter.sql:1381\n"
;

static const char *proc550 = 
"#line 1461 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_DIR_LIST\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in detcol_path varchar,\n"
"in name_mask varchar,\n"
"in recursive integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare dirsingle, rfc_list_cond, rfc_del_action any;\n"
"declare davpath, schema_uri, subcol_perms varchar;\n"
"declare depth integer;\n"
"declare res, resources, itm, reps, filter_data any;\n"
"declare itm_ctr, itm_count, set_readonly integer;\n"
"declare filter any;\n"
"\n"
"if ((recursive = -1) and isarray (detcol_id))\n"
"return DB.DBA.CatFilter_DAV_DIR_SINGLE (detcol_id, \'C\', null, auth_uid);\n"
"\n"
"vectorbld_init (res);\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"goto final_res;\n"
"}\n"
"\n"
"depth := length (path_parts);\n"
"filter_data := null;\n"
"\n"
"set_readonly := 0;\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"set_readonly := 1;\n"
"}\n"
"else if (-1 = recursive)\n"
"{\n"
"if ((2 = depth) or (mod (depth, 4) = 2))\n"
"set_readonly := 1;\n"
"}\n"
"else\n"
"{\n"
"if ((1 = depth) or (mod (depth, 4) = 0))\n"
"set_readonly := 1;\n"
"}\n"
"\n"
"dirsingle := DAV_DIR_SINGLE_INT (detcol_id, \'C\', \'fake\', null, null, null, 0);\n"
"\n"
"\n"
"subcol_perms := dirsingle[5];\n"
"subcol_perms[2] := 48;\n"
"subcol_perms[5] := 48;\n"
"subcol_perms[8] := 48;\n"
"if (set_readonly)\n"
"{\n"
"\n"
"subcol_perms[1] := 48;\n"
"subcol_perms[4] := 48;\n"
"subcol_perms[7] := 48;\n"
"}\n"
"\n"
"\n"
"if (1 = depth)\n"
"{\n"
"declare schemas any;\n"
"\n"
"if (\'\' <> path_parts[0])\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"schemas := \"CatFilter_LIST_SCHEMAS\" ();\n"
"foreach (any sch in schemas) do\n"
"{\n"
"declare subcol_fullpath varchar;\n"
"\n"
"subcol_fullpath := DAV_CONCAT_PATH (detcol_path, sch[1] || \'/\');\n"
"vectorbld_acc (res, vector (subcol_fullpath, \'C\', 0, now (), DB.DBA.CatFilter__id (detcol_id, null, sch[0], null), subcol_perms, dirsingle[6], dirsingle[7], now (), \'dav/unix-directory\', sch[1]));\n"
"if (recursive > 0)\n"
"{\n"
"vectorbld_concat_acc (res, \"CatFilter_DAV_DIR_LIST\" (detcol_id, vector_concat (subseq (path_parts, 0, length (path_parts) - 1), vector (sch[1], \'\')), detcol_path,  name_mask, recursive, auth_uid));\n"
"}\n"
"}\n"
"goto final_res;\n"
"}\n"
"\n"
"if (\"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data) < 0)\n"
"{\n"
"goto final_res;\n"
"}\n"
"\n"
"\n"
"\n"
"if (mod (length (filter_data), 4) = 2)\n"
"{\n"
"\n"
"declare distvals any;\n"
"\n"
"distvals := \"CatFilter_LIST_PROP_DISTVALS\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, schema_uri, filter_data, auth_uid);\n"
"if (-1 = recursive)\n"
"{\n"
"\n"
"\n"
"return vector (vector (DAV_CONCAT_PATH (detcol_path, path_parts), \'C\', 0, now (), DB.DBA.CatFilter__id (detcol_id, null, schema_uri, filter_data), subcol_perms, dirsingle[6], dirsingle[7], now (), \'dav/unix-directory\', path_parts [depth - 2]));\n"
"}\n"
"foreach (varchar val in distvals) do\n"
"{\n"
"declare subcol_fullpath varchar;\n"
"subcol_fullpath := DAV_CONCAT_PATH ( DAV_CONCAT_PATH (detcol_path, path_parts), val || \'/\');\n"
"vectorbld_acc (res, vector (subcol_fullpath, \'C\', 0, now (), DB.DBA.CatFilter__id (detcol_id, null, schema_uri, vector_concat (filter_data, vector (val))), subcol_perms, dirsingle[6], dirsingle[7], now (), \'dav/unix-directory\', val));\n"
"if (recursive > 0)\n"
"{\n"
"vectorbld_concat_acc (res, \"CatFilter_DAV_DIR_LIST\" (detcol_id, vector_concat (subseq (path_parts, 0, length (path_parts) - 1), vector (val, \'\')), detcol_path, name_mask, recursive, auth_uid));\n"
"}\n"
"}\n"
"goto final_res;\n"
"}\n"
"else if (length (filter_data) <= 16)\n"
"{\n"
"declare sch_props any;\n"
"\n"
"\n"
"sch_props := \"CatFilter_LIST_SCHEMA_PROPS\" (rfc_spath, rfc_list_cond, schema_uri, filter_data, auth_uid);\n"
"if (-1 = recursive)\n"
"{\n"
"\n"
"\n"
"return vector (vector (DAV_CONCAT_PATH (detcol_path, path_parts), \'C\', 0, now (), DB.DBA.CatFilter__id (detcol_id, null, schema_uri, filter_data), subcol_perms, dirsingle[6], dirsingle[7], now (), \'dav/unix-directory\', path_parts [depth - 2] ) );\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if (length (filter_data) >= 4)\n"
"{\n"
"recursive := 0;\n"
"}\n"
"foreach (any prop in sch_props) do\n"
"{\n"
"declare subcol_fullpath varchar;\n"
"subcol_fullpath := DAV_CONCAT_PATH (DAV_CONCAT_PATH (detcol_path, path_parts), prop[1] || \'/\');\n"
"vectorbld_acc (res, vector (subcol_fullpath, \'C\', 0, now (), DB.DBA.CatFilter__id (detcol_id, null, prop[0], null), subcol_perms, dirsingle[6], dirsingle[7], now (), \'dav/unix-directory\', prop[1]) );\n"
"if (recursive > 0)\n"
"{\n"
"vectorbld_concat_acc (res, \"CatFilter_DAV_DIR_LIST\" (detcol_id, vector_concat (subseq (path_parts, 0, length (path_parts) - 1), vector (prop[1], \'\')), detcol_path, name_mask, recursive, auth_uid ) );\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (0 = length (filter_data))\n"
"{\n"
"\n"
"goto final_res;\n"
"}\n"
"\n"
"if ((length (get_keyword (\'\', rfc_list_cond)) = 0) and (length (filter_data) > 0) and (length (filter_data) <= 20))\n"
"{\n"
"\n"
"declare res_ids, res_dir_single any;\n"
"\n"
"res_ids := \"CatFilter_GET_RDF_INVERSE_HITS_RES_IDS\" (cfc_id, filter_data, auth_uid);\n"
"\n"
"itm_count := length (res_ids);\n"
"vectorbld_init (resources);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare r_id integer;\n"
"r_id := res_ids [itm_ctr];\n"
"res_dir_single := (\n"
"select\n"
"\n"
"vector (DAV_CONCAT_PATH (detcol_path, RES_NAME), \'R\', length (RES_CONTENT), RES_MOD_TIME,\n"
"\n"
"r_id, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME )\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = r_id );\n"
"if (res_dir_single is not null)\n"
"vectorbld_acc (resources, res_dir_single);\n"
"}\n"
"for select CFD_DET_SUBCOL_ID, CFD_DET from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_CF_ID = cfc_id do\n"
"{\n"
"declare det_res_ids any;\n"
"if (exists (select top 1 1 from SYS_PROCEDURES where P_NAME = fix_identifier_case(\'DB.DBA.\') || CFD_DET || \'_CF_GET_RDF_HITS\'))\n"
"{\n"
"det_res_ids := call (CFD_DET || \'_CF_GET_RDF_HITS\') (CFD_DET_SUBCOL_ID, cfc_id, rfc_spath, rfc_list_cond, schema_uri, filter_data, detcol_path, 1, auth_uid);\n"
"vectorbld_concat_acc (resources, det_res_ids);\n"
"}\n"
"}\n"
"vectorbld_final (resources);\n"
"}\n"
"else\n"
"{\n"
"vectorbld_init (filter);\n"
"\"CatFilter_ACC_FILTER_DATA\" (filter, filter_data);\n"
"vectorbld_concat_acc (filter, get_keyword (\'\', rfc_list_cond));\n"
"\n"
"if (\'%\' <> name_mask)\n"
"{\n"
"\n"
"vectorbld_acc (filter, vector (\'RES_NAME\', \'like\', name_mask));\n"
"}\n"
"vectorbld_final (filter);\n"
"filter := vector (\'\', filter);\n"
"resources := DAV_DIR_FILTER_INT (rfc_spath, 1, filter, null, null, auth_uid);\n"
"}\n"
"reps := dict_new ();\n"
"itm_count := length (resources);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id any;\n"
"itm := resources [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"if (isarray (orig_id) or regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', rname, 0))\n"
"resources [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"\n"
"dict_put (reps, rname, dict_get (reps, rname, 0) + 1);\n"
"}\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := resources [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"resources[itm_ctr][4] := DB.DBA.CatFilter__id (detcol_id, orig_id);\n"
"if (dict_get (reps, rname, 0) > 1)\n"
"resources [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"\n"
"resources[itm_ctr][0] := DAV_CONCAT_PATH (DAV_CONCAT_PATH (detcol_path, path_parts), rname);\n"
"}\n"
"vectorbld_concat_acc (res, resources);\n"
"\n"
"final_res:\n"
"vectorbld_final (res);\n"
"\n"
"\n"
"return res;\n"
"}\n"
"--src DET_CatFilter.sql:1459\n"
;

static const char *proc551 = 
"#line 1704 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_DIR_FILTER\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in detcol_path varchar,\n"
"inout compilation any,\n"
"in recursive integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare davpath varchar;\n"
"declare res, itm, reps any;\n"
"declare itm_ctr, itm_count integer;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"return vector();\n"
"}\n"
"\n"
"if (0 = length (get_keyword (\'\', compilation)))\n"
"{\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, rfc_list_cond, null, null, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare tmp_cond any;\n"
"\n"
"tmp_cond := vector (\'\', vector_concat (get_keyword (\'\', compilation), get_keyword (\'\', rfc_list_cond)));\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_cond, null, null, auth_uid);\n"
"}\n"
"reps := dict_new ();\n"
"itm_count := length (res);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"if (isarray (orig_id) or regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', rname, 0))\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"\n"
"dict_put (reps, rname, dict_get (reps, rname, 0) + 1);\n"
"}\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"res[itm_ctr][4] := DB.DBA.CatFilter__id (detcol_id, orig_id);\n"
"if (dict_get (reps, rname, 0) > 1)\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"\n"
"res[itm_ctr][0] := DAV_CONCAT_PATH (DAV_CONCAT_PATH (detcol_path, path_parts), rname);\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_CatFilter.sql:1702\n"
;

static const char *proc552 = 
"#line 1770 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_SEARCH_ID\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in what char(1)) returns any\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare filter_data any;\n"
"\n"
"rfc_spath := null;\n"
"return \"CatFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action, filter_data);\n"
"}\n"
"--src DET_CatFilter.sql:1768\n"
;

static const char *proc553 = 
"#line 1787 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_SEARCH_PATH\" (\n"
"in id any,\n"
"in what char(1)) returns any\n"
"{\n"
"\n"
"\n"
"if (\'R\' = what)\n"
"return (select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = id[2]);\n"
"\n"
"if (\'C\' = what)\n"
"{\n"
"declare res varchar;\n"
"\n"
"res := DAV_SEARCH_PATH (id[1], \'C\');\n"
"if (id[3] is not null)\n"
"{\n"
"\n"
" ;\n"
"}\n"
"if (id[4] is not null)\n"
"{\n"
"\n"
" ;\n"
"}\n"
"return res;\n"
"}\n"
"\n"
"return -14;\n"
"}\n"
"--src DET_CatFilter.sql:1785\n"
;

static const char *proc554 = 
"#line 1819 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_RES_UPLOAD_COPY\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in source_id any,\n"
"in what char(1),\n"
"in overwrite integer,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1) returns any\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath, schema_uri varchar;\n"
"declare rfc_list_cond, rfc_del_action, filter_data, fit_cond any;\n"
"declare rc integer;\n"
"\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"\n"
"if (\'\' = path_parts [length (path_parts) - 1])\n"
"return -2;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"return -2;\n"
"\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"return -13;\n"
"\n"
"rc := \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"rc := \"CatFilter_FILTER_TO_CONDITION\" (schema_uri, filter_data, fit_cond);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"fit_cond := vector (\'\', vector_concat (fit_cond, get_keyword (\'\', rfc_list_cond)));\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES where RES_ID = source_id and RES_NAME = path_parts [length (path_parts) - 1] and (RES_FULL_PATH between rfc_spath and DAV_COL_PATH_BOUNDARY (rfc_spath)) ) )\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"\n"
"new_full_path := DAV_CONCAT_PATH (rfc_spath, path_parts [length (path_parts) - 1]);\n"
"rc := DAV_COPY_INT (\n"
"DAV_SEARCH_PATH (source_id, what),\n"
"new_full_path,\n"
"overwrite,\n"
"permissions,\n"
"coalesce ((select U_NAME from WS.WS.SYS_DAV_USER where U_ID = uid), \'\'),\n"
"coalesce ((select G_NAME from WS.WS.SYS_DAV_GROUP where G_ID = gid), \'\'),\n"
"auth_uname,\n"
"auth_pwd,\n"
"extern);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"\n"
"if (not (isinteger (source_id)))\n"
"return -13;\n"
"\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_CatFilter.sql:1817\n"
;

static const char *proc555 = 
"#line 1898 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_RES_UPLOAD_MOVE\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in source_id any,\n"
"in what char(1),\n"
"in overwrite integer,\n"
"in auth_uid integer,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1) returns any\n"
"{\n"
"\n"
"declare cfc_id integer;\n"
"declare rfc_spath, schema_uri varchar;\n"
"declare rfc_list_cond, rfc_del_action, filter_data, fit_cond any;\n"
"declare rc integer;\n"
"\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"\n"
"if (\'\' = path_parts [length (path_parts) - 1])\n"
"return -2;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"return -2;\n"
"\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"return -13;\n"
"\n"
"rc := \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"rc := \"CatFilter_FILTER_TO_CONDITION\" (schema_uri, filter_data, fit_cond);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"fit_cond := vector (\'\', vector_concat (fit_cond, get_keyword (\'\', rfc_list_cond)));\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES where RES_ID = source_id and RES_NAME = path_parts [length (path_parts) - 1] and (RES_FULL_PATH between rfc_spath and DAV_COL_PATH_BOUNDARY (rfc_spath))))\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"\n"
"new_full_path := DAV_CONCAT_PATH (rfc_spath, path_parts [length (path_parts) - 1]);\n"
"rc := DAV_MOVE_INT (\n"
"DAV_SEARCH_PATH (source_id, what),\n"
"new_full_path,\n"
"overwrite,\n"
"auth_uname,\n"
"auth_pwd,\n"
"extern,\n"
"check_locks);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"\n"
"if (not (isinteger (source_id)))\n"
"return -13;\n"
"\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_CatFilter.sql:1896\n"
;

static const char *proc556 = 
"#line 1972 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_RES_CONTENT\" (\n"
"in id any,\n"
"inout content any,\n"
"out type varchar,\n"
"in content_mode integer) returns integer\n"
"{\n"
"\n"
"\n"
"declare cont any;\n"
"\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"select RES_CONTENT, RES_TYPE into content, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"\n"
"else if (content_mode = 1)\n"
"select http (RES_CONTENT, content), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"\n"
"else if (content_mode = 3)\n"
"select http (RES_CONTENT), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"\n"
"return id[2];\n"
"}\n"
"--src DET_CatFilter.sql:1970\n"
;

static const char *proc557 = 
"#line 1996 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_SYMLINK\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in source_id any,\n"
"in what char(1),\n"
"in overwrite integer,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:1994\n"
;

static const char *proc558 = 
"#line 2012 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_LOCK\" (\n"
"in path any,\n"
"inout id any,\n"
"in what char(1),\n"
"inout locktype varchar,\n"
"inout scope varchar,\n"
"in token varchar,\n"
"inout owner_name varchar,\n"
"inout owned_tokens varchar,\n"
"in depth varchar,\n"
"in timeout_sec integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"\n"
"if (\'R\' <> what)\n"
"return -20;\n"
"\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -20;\n"
"\n"
"if (isarray (id))\n"
"return DAV_LOCK_INT (path, id[2], what, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, null, null, auth_uid);\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:2010\n"
;

static const char *proc559 = 
"#line 2041 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_UNLOCK\" (\n"
"in id any,\n"
"in type char(1),\n"
"in token varchar,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"if (isarray (id))\n"
"id := id [2];\n"
"\n"
"return DAV_UNLOCK_INT (id, type, token, null, null, auth_uid);\n"
"}\n"
"--src DET_CatFilter.sql:2039\n"
;

static const char *proc560 = 
"#line 2056 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_IS_LOCKED\" (\n"
"inout id any,\n"
"inout what char(1),\n"
"in owned_tokens varchar) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_what char(1);\n"
"\n"
"orig_id := id;\n"
"id := orig_id[2];\n"
"rc := DAV_IS_LOCKED_INT (id, what, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"\n"
"id := orig_id[1];\n"
"orig_what := what;\n"
"what := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (id, what, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"\n"
"id := orig_id;\n"
"what := orig_what;\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:2054\n"
;

static const char *proc561 = 
"#line 2086 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_DAV_LIST_LOCKS\" (\n"
"in id any,\n"
"in what char(1),\n"
"in recursive integer) returns any\n"
"{\n"
"\n"
"declare res any;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_LIST_LOCKS\') (id, what, recursive);\n"
"\n"
"res := vector();\n"
"for (select LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO\n"
"from WS.WS.SYS_DAV_LOCK\n"
"where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = what) do\n"
"{\n"
"res := vector_concat (res, vector (vector (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)));\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_CatFilter.sql:2084\n"
;

static const char *proc562 = 
"#line 2109 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_CONFIGURE\" (\n"
"in id any,\n"
"in params any,\n"
"in path varchar,\n"
"in filter any,\n"
"in auth_uname varchar := null,\n"
"in auth_upwd varchar := null,\n"
"in auth_uid integer := null) returns integer\n"
"{\n"
"declare cfid, rc, ctr integer;\n"
"declare colPath varchar;\n"
"declare compilation, del_act any;\n"
"\n"
"if (not isnull (\"CatFilter_VERIFY\" (DB.DBA.DAV_SEARCH_PATH (id, \'C\'), vector (\'params\', params, \'path\', path, \'filter\', filter))))\n"
"return -38;\n"
"\n"
"colPath := DAV_SEARCH_PATH (id, \'C\');\n"
"if (DAV_HIDE_ERROR (colPath) is null)\n"
"return colPath;\n"
"\n"
"rc := DAV_SEARCH_ID (path, \'C\');\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"compilation := vector (\'\', filter);\n"
"rc := DAV_DIR_FILTER_INT (path, 1, compilation, auth_uname, auth_upwd, auth_uid);\n"
"if (isinteger (rc))\n"
"return rc;\n"
"\n"
"rc := DAV_PROP_SET_INT (colPath, \'virt:Filter-Params\', params, null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"rc := DAV_PROP_SET_INT (colPath, \'virt:ResFilter-SearchPath\', path, null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"rc := DAV_PROP_SET_INT (colPath, \'virt:ResFilter-ListCond\', \"ResFilter_ENCODE_FILTER\" (compilation), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"del_act := \"ResFilter_MAKE_DEL_ACTION_FROM_CONDITION\" (compilation);\n"
"rc := DAV_PROP_SET_INT (colPath, \'virt:ResFilter-DelAction\', \"ResFilter_ENCODE_FILTER\" (del_act), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"cfid := (select CF_ID from WS.WS.SYS_DAV_CATFILTER where CF_SEARCH_PATH = path);\n"
"if (cfid is null)\n"
"{\n"
"declare path_z varchar;\n"
"\n"
"cfid := WS.WS.GETID (\'CF\');\n"
"insert into WS.WS.SYS_DAV_CATFILTER (CF_ID, CF_SEARCH_PATH)\n"
"values (cfid, path);\n"
"\n"
"path_z := path || \'\\255\\255\\255\\255\';\n"
"for (select p.PROP_VALUE, p.PROP_PARENT_ID\n"
"from WS.WS.SYS_DAV_RES r join WS.WS.SYS_DAV_PROP p on (r.RES_ID = p.PROP_PARENT_ID)\n"
"where (r.RES_FULL_PATH between path and path_z) and (p.PROP_NAME = \'http://local.virt/DAV-RDF\') and (p.PROP_TYPE = \'R\')) do\n"
"{\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (PROP_VALUE, PROP_PARENT_ID, 0, cfid);\n"
"ctr := ctr + 1;\n"
"if (mod (ctr, 1000) = 0)\n"
"commit work;\n"
"}\n"
"commit work;\n"
"for (select COL_ID, COL_DET, WS.WS.COL_PATH (COL_ID) as _c_path from WS.WS.SYS_DAV_COL where COL_DET is not null and not (COL_DET like \'%Filter\')) do\n"
"{\n"
"if (\"LEFT\" (_c_path, length (path)) = path)\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (cfid, COL_ID, COL_DET);\n"
"}\n"
"}\n"
"}\n"
"rc := DAV_PROP_SET_INT (colPath, \'virt:CatFilter-ID\', cast (cfid as varchar), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"\n"
"DB.DBA.CatFilter__paramSet (id, \'C\', \':virtdet\', DB.DBA.CatFilter__detName (), 0, 0, 0);\n"
"}\n"
"--src DET_CatFilter.sql:2107\n"
;

static const char *proc563 = 
"#line 2193 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_VERIFY\" (\n"
"in path integer,\n"
"in params any)\n"
"{\n"
"declare tmp any;\n"
"\n"
"tmp := get_keyword (\'path\', params);\n"
"if (tmp between path and (path || \'\\255\\255\\255\\255\'))\n"
"return sprintf (\'Search path (%s) can not contains in folder full path (%s)!\', tmp, path);\n"
"\n"
"return null;\n"
"}\n"
"--src DET_CatFilter.sql:2191\n"
;

static const char *proc564 = 
"#line 2207 \"[executable]/DET_CatFilter.sql\"\n"
"create function DB.DBA.CatFilter__id (\n"
"in detcol_id integer,\n"
"in orig_id integer,\n"
"in schema_uri varchar := null,\n"
"in filter_data any := null)\n"
"{\n"
"if (isnull (schema_uri))\n"
"return vector (DB.DBA.CatFilter__detName (), detcol_id, orig_id);\n"
"\n"
"return vector (DB.DBA.CatFilter__detName (), detcol_id, orig_id, schema_uri, case when length (filter_data) then filter_data else null end);\n"
"}\n"
"--src DET_CatFilter.sql:2205\n"
;

static const char *proc565 = 
"#line 2220 \"[executable]/DET_CatFilter.sql\"\n"
"create function DB.DBA.CatFilter__detName ()\n"
"{\n"
"return UNAME\'CatFilter\';\n"
"}\n"
"--src DET_CatFilter.sql:2218\n"
;

static const char *proc566 = 
"#line 2226 \"[executable]/DET_CatFilter.sql\"\n"
"create function DB.DBA.CatFilter__paramSet (\n"
"in _id any,\n"
"in _what varchar,\n"
"in _propName varchar,\n"
"in _propValue any,\n"
"in _serialized integer := 1,\n"
"in _prefixed integer := 1,\n"
"in _encrypt integer := 0)\n"
"{\n"
"\n"
"declare retValue any;\n"
"\n"
"if (_serialized)\n"
"_propValue := serialize (_propValue);\n"
"\n"
"if (_encrypt)\n"
"_propValue := pwd_magic_calc (DB.DBA.CatFilter__detName (), _propValue);\n"
"\n"
"if (_prefixed)\n"
"_propName := \'virt:CatFilter-\' || _propName;\n"
"\n"
"retValue := DB.DBA.DAV_PROP_SET_RAW (_id, _what, _propName, _propValue, 1, http_dav_uid ());\n"
"\n"
"return retValue;\n"
"}\n"
"--src DET_CatFilter.sql:2224\n"
;

static const char *proc567 = 
"#line 2253 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_FEED_DAV_RDF_INVERSE\" (\n"
"inout propval any,\n"
"inout propparent integer,\n"
"in is_del integer := 0,\n"
"in cfid integer := null)\n"
"{\n"
"\n"
"declare resfullpath, path_head, pv varchar;\n"
"declare doc any;\n"
"declare triplets any;\n"
"\n"
"if (126 = __tag (propval))\n"
"{\n"
"pv := blob_to_string (propval);\n"
"}\n"
"else\n"
"{\n"
"if ((not isstring (propval)) or (propval = \'\'))\n"
"return;\n"
"\n"
"pv := propval;\n"
"}\n"
"\n"
"if (193 <> pv[0])\n"
"return;\n"
"\n"
"doc := null;\n"
"if (cfid is not null)\n"
"{\n"
"path_head := \'/\';\n"
"goto cfid_found;\n"
"}\n"
"else\n"
"{\n"
"resfullpath := (select r.RES_FULL_PATH from WS.WS.SYS_DAV_RES r where r.RES_ID = propparent);\n"
"if (resfullpath is null)\n"
"return;\n"
"\n"
"path_head := subseq (resfullpath, 0, strrchr (resfullpath, \'/\'));\n"
"}\n"
"\n"
"next_cfid:\n"
"while (1)\n"
"{\n"
"if (length (path_head) <= 1)\n"
"return;\n"
"\n"
"cfid := (select CF_ID from WS.WS.SYS_DAV_CATFILTER where CF_SEARCH_PATH = (path_head || \'/\'));\n"
"path_head := subseq (path_head, 0, strrchr (path_head, \'/\'));\n"
"if (cfid is not null)\n"
"goto cfid_found;\n"
"}\n"
"\n"
"cfid_found:\n"
"if (doc is null)\n"
"{\n"
"doc := deserialize (pv);\n"
"if (0 = length (doc))\n"
"return;\n"
"\n"
"doc := xml_tree_doc (doc);\n"
"}\n"
"\n"
"triplets := xpath_eval (\'[xmlns:virt=\"virt\"] /virt:rdf/virt:top-res/virt:prop[virt:value]\', doc, 0);\n"
"foreach (any prop in triplets) do\n"
"{\n"
"declare propname varchar;\n"
"declare prop_catid integer;\n"
"\n"
"propname := cast (xpath_eval (\'name(*[1])\', prop) as varchar);\n"
"prop_catid := (select RPN_CATID from WS.WS.SYS_RDF_PROP_NAME where RPN_URI = propname);\n"
"if (prop_catid is null)\n"
"{\n"
"prop_catid := WS.WS.GETID (\'RPN\');\n"
"\n"
"insert into WS.WS.SYS_RDF_PROP_NAME (RPN_URI, RPN_CATID)\n"
"values (propname, prop_catid);\n"
"}\n"
"if (is_del)\n"
"{\n"
"delete\n"
"from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where (DRI_CATF_ID = cfid)\n"
"and (DRI_PROP_CATID = prop_catid)\n"
"and (DRI_CATVALUE = \"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar)))\n"
"and (DRI_RES_ID = propparent);\n"
"}\n"
"else\n"
"{\n"
"insert soft WS.WS.SYS_DAV_RDF_INVERSE (DRI_CATF_ID, DRI_PROP_CATID, DRI_CATVALUE, DRI_RES_ID)\n"
"values (cfid, prop_catid, \"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar)), propparent);\n"
"}\n"
"}\n"
"goto next_cfid;\n"
"}\n"
"--src DET_CatFilter.sql:2251\n"
;

static const char *proc568 = 
"#line 2351 \"[executable]/DET_CatFilter.sql\"\n"
"create function \"CatFilter_INIT_SYS_DAV_RDF_INVERSE\" (\n"
"in run_if_once integer)\n"
"{\n"
"declare ctr integer;\n"
"\n"
"set isolation = \'committed\';\n"
"if (run_if_once)\n"
"{\n"
"if (0 <> sequence_next(\'CatFilter_INIT_SYS_DAV_RDF_INVERSE\'))\n"
"return;\n"
"}\n"
"else\n"
"{\n"
"\n"
"update WS.WS.SYS_RDF_SCHEMAS set RS_PRECOMPILED = null, RS_PROP_CATNAMES = null;\n"
"commit work;\n"
"delete from WS.WS.SYS_DAV_RDF_INVERSE;\n"
"}\n"
"commit work;\n"
"for (select PROP_VALUE, PROP_PARENT_ID from WS.WS.SYS_DAV_PROP where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\') do\n"
"{\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (PROP_VALUE, PROP_PARENT_ID);\n"
"ctr := ctr + 1;\n"
"if (mod (ctr, 1000) = 0)\n"
"commit work;\n"
"}\n"
"}\n"
"--src DET_CatFilter.sql:2349\n"
;

static const char *trig45 = 
"#line 2381 \"[executable]/DET_CatFilter.sql\"\n"
"create trigger SYS_DAV_PROP_VALUE_RDF_I after insert on WS.WS.SYS_DAV_PROP order 10 referencing new as NP\n"
"{\n"
"if ((NP.PROP_NAME = \'http://local.virt/DAV-RDF\') and (NP.PROP_TYPE = \'R\'))\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (NP.PROP_VALUE, NP.PROP_PARENT_ID);\n"
"}\n"
"--src DET_CatFilter.sql:2379\n";

static const char *trig46 = 
"#line 2389 \"[executable]/DET_CatFilter.sql\"\n"
"create trigger SYS_DAV_PROP_VALUE_RDF_D before delete on WS.WS.SYS_DAV_PROP order 10 referencing old as OP\n"
"{\n"
"if ((OP.PROP_NAME = \'http://local.virt/DAV-RDF\') and (OP.PROP_TYPE = \'R\'))\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (OP.PROP_VALUE, OP.PROP_PARENT_ID, 1);\n"
"}\n"
"--src DET_CatFilter.sql:2387\n";

static const char *trig47 = 
"#line 2397 \"[executable]/DET_CatFilter.sql\"\n"
"create trigger SYS_DAV_PROP_VALUE_RDF_U after update on WS.WS.SYS_DAV_PROP order 10 referencing old as OP, new as NP\n"
"{\n"
"if ((OP.PROP_NAME = \'http://local.virt/DAV-RDF\') and (OP.PROP_TYPE = \'R\'))\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (OP.PROP_VALUE, OP.PROP_PARENT_ID, 1);\n"
"\n"
"if ((NP.PROP_NAME = \'http://local.virt/DAV-RDF\') and (NP.PROP_TYPE = \'R\'))\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (NP.PROP_VALUE, NP.PROP_PARENT_ID);\n"
"}\n"
"--src DET_CatFilter.sql:2395\n";

/* DET_HostFs.sql */

static const char *tbl3 = 
"create table WS.WS.HOSTFS_COL\n"
"(\n"
"COL_ID		integer not null primary key,\n"
"COL_FULL_PATH		varchar not null,\n"
"COL_PARENT_ID		integer,\n"
"COL_CR_TIME		datetime,\n"
"COL_MOD_TIME		datetime,\n"
"COL_SCAN_TIME		datetime,\n"
"COL_NEXT_SCAN_TIME	datetime,\n"
"COL_NAME		varchar not null\n"
")\n"
"create index HOSTFS_COL_PARENT_ID on WS.WS.HOSTFS_COL (COL_PARENT_ID)\n"
"create index HOSTFS_COL_FULL_PATH on WS.WS.HOSTFS_COL (COL_FULL_PATH)\n"
"create index HOSTFS_COL_NEXT_SCAN_TIME on WS.WS.HOSTFS_COL (COL_NEXT_SCAN_TIME)\n";

static const char *alter0 = 
"alter table WS.WS.HOSTFS_COL add COL_NAME varchar not null\n";

static const char *tbl4 = 
"create table WS.WS.HOSTFS_RES\n"
"(\n"
"RES_ID 		integer not null primary key,\n"
"RES_NAME 		varchar (256),\n"
"RES_COL 		integer,\n"
"RES_TYPE 		varchar,\n"
"RES_FT_MODE		char (1),\n"
"RES_LENGTH		integer,\n"
"RES_CR_TIME		datetime,\n"
"RES_MOD_TIME		datetime,\n"
"RES_SCAN_TIME		datetime,\n"
"RES_NEXT_SCAN_TIME	datetime,\n"
"RES_PERMS 		char (11)\n"
")\n"
"create index HOSTFS_RES_COL on WS.WS.HOSTFS_RES (RES_COL, RES_NAME)\n"
"create index HOSTFS_RES_NEXT_SCAN_TIME on WS.WS.HOSTFS_RES (RES_NEXT_SCAN_TIME)\n";

static const char *tbl5 = 
"create table WS.WS.HOSTFS_RES_CACHE\n"
"(\n"
"RESC_ID		integer not null primary key,\n"
"RESC_MOD_SCAN_TIME	datetime,\n"
"RESC_DATA		long varchar,\n"
"RESC_TOPCOL_ID	integer not null\n"
")\n"
"create index HOSTFS_RES_CACHE_TOPCOL_ID on WS.WS.HOSTFS_RES_CACHE (RESC_TOPCOL_ID)\n";

static const char *alter1 = 
"alter table WS.WS.HOSTFS_RES_CACHE add RESC_TOPCOL_ID integer not null\n";

static const char *tbl6 = 
"create table WS.WS.HOSTFS_RES_META\n"
"(\n"
"RESM_ID		integer not null primary key,\n"
"RESM_DATA		long XML,\n"
"RESM_TOPCOL_ID	integer not null\n"
")\n"
"create index HOSTFS_RES_META_TOPCOL_ID on WS.WS.HOSTFS_RES_META (RESM_TOPCOL_ID)\n";

static const char *alter2 = 
"alter table WS.WS.HOSTFS_RES_META add RESM_TOPCOL_ID integer not null\n";

static const char *tbl7 = 
"create table WS.WS.HOSTFS_RDF_INVERSE\n"
"(\n"
"HRI_TOPCOL_ID integer not null,\n"
"HRI_PROP_CATID integer not null,\n"
"HRI_CATVALUE varchar not null,\n"
"HRI_RES_ID integer not null,\n"
"primary key (HRI_TOPCOL_ID, HRI_PROP_CATID, HRI_CATVALUE, HRI_RES_ID)\n"
")\n";

static const char *proc569 = 
"#line 98 \"[executable]/DET_HostFs.sql\"\n"
"create procedure WS.WS.HOSTFS_FEED_RDF_INVERSE (inout propval any, in r_id integer, in is_del integer, in topcol_id integer)\n"
"{\n"
"declare resfullpath, path_head, pv varchar;\n"
"declare triplets any;\n"
"triplets := xpath_eval (\'[xmlns:virt=\"virt\"] /virt:rdf/virt:top-res/virt:prop[virt:value]\', propval, 0);\n"
"foreach (any prop in triplets) do\n"
"{\n"
"declare propname varchar;\n"
"declare prop_catid integer;\n"
"propname := cast (xpath_eval (\'name(*[1])\', prop) as varchar);\n"
"prop_catid := coalesce ((select RPN_CATID from WS.WS.SYS_RDF_PROP_NAME where RPN_URI = propname));\n"
"if (prop_catid is null)\n"
"{\n"
"prop_catid := WS.WS.GETID (\'RPN\');\n"
"\n"
"insert into WS.WS.SYS_RDF_PROP_NAME (RPN_URI, RPN_CATID) values (propname, prop_catid);\n"
"}\n"
"if (is_del)\n"
"delete from WS.WS.HOSTFS_RDF_INVERSE\n"
"where\n"
"(HRI_TOPCOL_ID = topcol_id) and (HRI_PROP_CATID = prop_catid) and\n"
"(HRI_CATVALUE = \"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar))) and\n"
"(HRI_RES_ID = r_id);\n"
"else\n"
"insert soft WS.WS.HOSTFS_RDF_INVERSE (HRI_TOPCOL_ID, HRI_PROP_CATID, HRI_CATVALUE, HRI_RES_ID)\n"
"values (\n"
"topcol_id,\n"
"prop_catid,\n"
"\"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar)),\n"
"r_id );\n"
"}\n"
"}\n"
"--src DET_HostFs.sql:96\n"
;

static const char *trig48 = 
"#line 133 \"[executable]/DET_HostFs.sql\"\n"
"create trigger HOSTFS_RES_META_I after insert on WS.WS.HOSTFS_RES_META referencing new as NP\n"
"{\n"
"if (NP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (NP.RESM_DATA, NP.RESM_ID, 0, NP.RESM_TOPCOL_ID);\n"
"}\n"
"--src DET_HostFs.sql:131\n";

static const char *trig49 = 
"#line 141 \"[executable]/DET_HostFs.sql\"\n"
"create trigger HOSTFS_RES_META_D before delete on WS.WS.HOSTFS_RES_META referencing old as OP\n"
"{\n"
"if (OP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (OP.RESM_DATA, OP.RESM_ID, 1, OP.RESM_TOPCOL_ID);\n"
"}\n"
"--src DET_HostFs.sql:139\n";

static const char *trig50 = 
"#line 149 \"[executable]/DET_HostFs.sql\"\n"
"create trigger HOSTFS_RES_META_U after update on WS.WS.HOSTFS_RES_META referencing old as OP, new as NP\n"
"{\n"
"if (OP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (OP.RESM_DATA, OP.RESM_ID, 1, OP.RESM_TOPCOL_ID);\n"
"if (NP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (NP.RESM_DATA, NP.RESM_ID, 0, NP.RESM_TOPCOL_ID);\n"
"}\n"
"--src DET_HostFs.sql:147\n";

static const char *other16 = 
"DB.DBA.vt_create_text_index (fix_identifier_case (\'WS.WS.HOSTFS_RES_META\'), fix_identifier_case (\'RESM_DATA\'), fix_identifier_case (\'RESM_ID\'), 2, 0, NULL, 0, \'*ini*\', \'*ini*\')\n";
static const char *other17 = 
"DB.DBA.vt_batch_update (fix_identifier_case (\'WS.WS.HOSTFS_RES_META\'), \'ON\', 1)\n";
static const char *proc570 = 
"#line 171 \"[executable]/DET_HostFs.sql\"\n"
"create function WS.WS.HOSTFS_RES_TOPCOL_ID (in r_id integer) returns integer\n"
"{\n"
"declare res, parent integer;\n"
"whenever not found goto nf;\n"
"res := parent := (select RES_COL from WS.WS.HOSTFS_RES where RES_ID = r_id);\n"
"while (parent is not null)\n"
"{\n"
"res := parent;\n"
"parent := (select COL_PARENT_ID from WS.WS.HOSTFS_COL where COL_ID = res);\n"
"}\n"
"return res;\n"
"nf:\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:169\n"
;

static const char *proc571 = 
"#line 187 \"[executable]/DET_HostFs.sql\"\n"
"create procedure WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (in resid integer, in resname varchar, in restype varchar, inout rescontent any, in topcol_id integer)\n"
"{\n"
"declare resttype varchar;\n"
"declare old_prop_id integer;\n"
"declare html_start, full_xml any;\n"
"declare old_n3, addon_n3 any;\n"
"\n"
"html_start := null;\n"
"full_xml := null;\n"
"\n"
"restype := DAV_GUESS_MIME_TYPE (resname, rescontent, html_start);\n"
"\n"
"if (restype is null)\n"
"return;\n"
"addon_n3 := call (\'DAV_EXTRACT_RDF_\' || restype)(resname, rescontent, html_start);\n"
"\n"
"if (addon_n3 is null)\n"
"return;\n"
"insert replacing WS.WS.HOSTFS_RES_META (RESM_ID, RESM_DATA, RESM_TOPCOL_ID)\n"
"values\n"
"(resid, xml_tree_doc (DAV_RDF_PREPROCESS_RDFXML (addon_n3, N\'http://local.virt/this\', 1)), topcol_id);\n"
"return;\n"
"\n"
"no_op:\n"
" ;\n"
"}\n"
"--src DET_HostFs.sql:185\n"
;

static const char *proc572 = 
"#line 215 \"[executable]/DET_HostFs.sql\"\n"
"create procedure WS.WS.HOSTFS_TEST_RDF (in d_id integer)\n"
"{\n"
"\n"
"for select RES_COL, RES_NAME, RES_TYPE, RES_FT_MODE from WS.WS.HOSTFS_RES where RES_ID = d_id do\n"
"{\n"
"\n"
"if (\'N\' = RES_FT_MODE)\n"
"{\n"
"return 1;\n"
"}\n"
"else if ((\'T\' = RES_FT_MODE) or (\'X\' = RES_FT_MODE))\n"
"{\n"
"for select RESC_DATA, RESC_TOPCOL_ID from WS.WS.HOSTFS_RES_CACHE where RESC_ID = d_id do\n"
"{\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, RESC_DATA, RESC_TOPCOL_ID);\n"
"}\n"
"return 1;\n"
"}\n"
"else if ((\'t\' = RES_FT_MODE) or (\'x\' = RES_FT_MODE))\n"
"{\n"
"for select COL_FULL_PATH from WS.WS.HOSTFS_COL where COL_ID = RES_COL do\n"
"{\n"
"declare ses any;\n"
"\n"
"ses := file_to_string_output (COL_FULL_PATH || RES_NAME);\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, ses, WS.WS.HOSTFS_RES_TOPCOL_ID (d_id));\n"
"}\n"
"return 1;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:213\n"
;

static const char *proc573 = 
"#line 249 \"[executable]/DET_HostFs.sql\"\n"
"create function\n"
"WS.WS.HOSTFS_RES_CACHE_RESC_DATA_INDEX_HOOK (inout vtb any, inout d_id integer) returns integer\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto done;\n"
"for select RES_COL, RES_NAME, RES_TYPE, RES_FT_MODE from WS.WS.HOSTFS_RES where RES_ID = d_id do\n"
"{\n"
"\n"
"if (\'N\' = RES_FT_MODE)\n"
"{\n"
"vt_batch_feed (vtb, RES_NAME, 0, 0);\n"
"return 1;\n"
"}\n"
"else if ((\'T\' = RES_FT_MODE) or (\'X\' = RES_FT_MODE))\n"
"{\n"
"for select RESC_DATA, RESC_TOPCOL_ID from WS.WS.HOSTFS_RES_CACHE where RESC_ID = d_id do\n"
"{\n"
"vt_batch_feed (vtb, RESC_DATA, 0, case (RES_FT_MODE) when \'X\' then 2 else 0 end);\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, RESC_DATA, RESC_TOPCOL_ID);\n"
"}\n"
"return 1;\n"
"}\n"
"else if ((\'t\' = RES_FT_MODE) or (\'x\' = RES_FT_MODE))\n"
"{\n"
"for select COL_FULL_PATH from WS.WS.HOSTFS_COL where COL_ID = RES_COL do\n"
"{\n"
"declare ses any;\n"
"\n"
"ses := file_to_string_output (COL_FULL_PATH || RES_NAME);\n"
"vt_batch_feed (vtb, ses, 0, case (RES_FT_MODE) when \'x\' then 2 else 0 end);\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, ses, WS.WS.HOSTFS_RES_TOPCOL_ID (d_id));\n"
"}\n"
"return 1;\n"
"}\n"
"}\n"
"done:\n"
"\n"
"return 1;\n"
"}\n"
"--src DET_HostFs.sql:247\n"
;

static const char *proc574 = 
"#line 290 \"[executable]/DET_HostFs.sql\"\n"
"create function\n"
"WS.WS.HOSTFS_RES_CACHE_RESC_DATA_UNINDEX_HOOK (inout vtb any, inout d_id integer) returns integer\n"
"{\n"
"whenever sqlstate \'*\' goto done;\n"
"for select RES_COL, RES_NAME, RES_TYPE, RES_FT_MODE from WS.WS.HOSTFS_RES where RES_ID = d_id do\n"
"{\n"
"if (\'N\' = RES_FT_MODE)\n"
"{\n"
"vt_batch_feed (vtb, RES_NAME, 1, 0);\n"
"return 1;\n"
"}\n"
"else if ((\'T\' = RES_FT_MODE) or (\'X\' = RES_FT_MODE))\n"
"{\n"
"for select RESC_DATA from WS.WS.HOSTFS_RES_CACHE where RESC_ID = d_id do\n"
"vt_batch_feed (vtb, RESC_DATA, 1, case (RES_FT_MODE) when \'X\' then 2 else 0 end);\n"
"return 1;\n"
"}\n"
"}\n"
"done:\n"
"return 1;\n"
"}\n"
"--src DET_HostFs.sql:288\n"
;

static const char *other18 = 
"DB.DBA.vt_create_text_index (fix_identifier_case (\'WS.WS.HOSTFS_RES_CACHE\'), fix_identifier_case (\'RESC_DATA\'), fix_identifier_case (\'RESC_ID\'), 2, 0, NULL, 1, \'*ini*\', \'*ini*\')\n";
static const char *other19 = 
"DB.DBA.vt_batch_update (fix_identifier_case (\'WS.WS.HOSTFS_RES_CACHE\'), \'ON\', 5)\n";
static const char *proc575 = 
"#line 325 \"[executable]/DET_HostFs.sql\"\n"
"create function\n"
"WS.WS.HOSTFS_FIND_COL (in full_path varchar) returns integer\n"
"{\n"
"declare slash_pos, parent, len, res integer;\n"
"declare parent_path, cname, tmp varchar;\n"
"declare cr_time datetime;\n"
"len := length (full_path);\n"
"if ((len > 0) and full_path[len-1] = 47)\n"
"full_path := subseq (full_path, 0, len-1);\n"
"whenever not found goto not_found;\n"
"select COL_ID into res from WS.WS.HOSTFS_COL where COL_FULL_PATH = full_path || \'/\';\n"
"return res;\n"
"not_found:\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"if (slash_pos is null)\n"
"{\n"
"parent := null;\n"
"cname := full_path;\n"
"}\n"
"else\n"
"{\n"
"parent := WS.WS.HOSTFS_FIND_COL (subseq (full_path, 0, slash_pos));\n"
"cname := subseq (full_path, slash_pos + 1);\n"
"}\n"
"tmp := file_stat (full_path);\n"
"if (isstring (tmp))\n"
"cr_time := cast (tmp as datetime);\n"
"else\n"
"cr_time := null;\n"
"res := sequence_next (\'WS.WS.HOSTFS_COL_ID\') + 1;\n"
"insert into WS.WS.HOSTFS_COL\n"
"(COL_ID	, COL_FULL_PATH		, COL_PARENT_ID	, COL_CR_TIME	, COL_MOD_TIME	, COL_SCAN_TIME	, COL_NEXT_SCAN_TIME	, COL_NAME	)\n"
"values\n"
"(res	, full_path || \'/\'	, parent	, cr_time	, cr_time	, NULL		, now ()		, cname		);\n"
"return res;\n"
"}\n"
"--src DET_HostFs.sql:323\n"
;

static const char *proc576 = 
"#line 363 \"[executable]/DET_HostFs.sql\"\n"
"create procedure\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (in full_path varchar)\n"
"{\n"
"declare len integer;\n"
"len := length (full_path);\n"
"if ((len > 0) and full_path[len-1] = 47)\n"
"full_path := subseq (full_path, 0, len-1);\n"
"for select COL_ID from WS.WS.HOSTFS_COL where COL_FULL_PATH between full_path || \'/\' and full_path || \'0\' do\n"
"{\n"
"for select RES_ID from WS.WS.HOSTFS_RES where RES_COL = COL_ID do\n"
"{\n"
"delete from WS.WS.HOSTFS_RES_META where RESM_ID = RES_ID;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = RES_ID;\n"
"}\n"
"delete from WS.WS.HOSTFS_RES where RES_COL = COL_ID;\n"
"}\n"
"delete from WS.WS.HOSTFS_COL where COL_FULL_PATH between full_path || \'/\' and full_path || \'0\';\n"
"}\n"
"--src DET_HostFs.sql:361\n"
;

static const char *proc577 = 
"#line 383 \"[executable]/DET_HostFs.sql\"\n"
"create procedure\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (in full_path varchar, in c_id integer, in flen integer, in cr_time datetime, in mod_time datetime, in mimetype varchar, in ft_mode varchar)\n"
"{\n"
"declare len, slash_pos integer;\n"
"declare r_id integer;\n"
"len := length (full_path);\n"
"if ((len = 0) or (full_path[len-1] = 47))\n"
"return;\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"if (c_id is null)\n"
"{\n"
"if (slash_pos is null)\n"
"c_id := WS.WS.HOSTFS_FIND_COL (\'\');\n"
"else\n"
"c_id := WS.WS.HOSTFS_FIND_COL (subseq (full_path, 0, slash_pos));\n"
"}\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_NAME = subseq (full_path, slash_pos + 1) and RES_COL = c_id));\n"
"if (r_id is null)\n"
"{\n"
"r_id := sequence_next (\'WS.WS.HOSTFS_RES_ID\') + 1;\n"
"insert into WS.WS.HOSTFS_RES\n"
"(RES_ID	, RES_NAME, RES_COL, RES_TYPE, RES_FT_MODE, RES_LENGTH, RES_CR_TIME, RES_MOD_TIME, RES_SCAN_TIME, RES_NEXT_SCAN_TIME, RES_PERMS)\n"
"values\n"
"(r_id	, subseq (full_path, slash_pos + 1), c_id, mimetype, ft_mode, flen, cr_time, mod_time, now(), null, null);\n"
"\n"
"insert replacing WS.WS.HOSTFS_RES_CACHE\n"
"(RESC_ID	, RESC_MOD_SCAN_TIME	, RESC_DATA	, RESC_TOPCOL_ID			)\n"
"values\n"
"(r_id		, now()			, null		, WS.WS.HOSTFS_RES_TOPCOL_ID (r_id)	);\n"
"}\n"
"else\n"
"{\n"
"if (exists (select top 1 1 from WS.WS.HOSTFS_RES\n"
"where RES_ID = r_id and\n"
"((RES_LENGTH <> flen) or (RES_MOD_TIME <> mod_time) or (RES_TYPE <> mimetype) or (RES_FT_MODE <> ft_mode)) ) )\n"
"{\n"
"update WS.WS.HOSTFS_RES set RES_LENGTH = flen, RES_MOD_TIME = mod_time, RES_TYPE = mimetype, RES_FT_MODE = ft_mode, RES_SCAN_TIME = now() where RES_ID = r_id;\n"
"\n"
"update WS.WS.HOSTFS_RES_CACHE set RESC_MOD_SCAN_TIME = now();\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.HOSTFS_RES set RES_SCAN_TIME = now() where (RES_ID = r_id) and RES_SCAN_TIME <> now ();\n"
"}\n"
"}\n"
"}\n"
"--src DET_HostFs.sql:381\n"
;

static const char *proc578 = 
"#line 431 \"[executable]/DET_HostFs.sql\"\n"
"create procedure\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (in full_path varchar)\n"
"{\n"
"declare len, slash_pos integer;\n"
"declare c_id, r_id integer;\n"
"len := length (full_path);\n"
"if ((len = 0) or full_path[len-1] = 47)\n"
"return;\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"c_id := coalesce ((select COL_ID from WS.WS.HOSTFS_COL where COL_FULL_PATH = subseq (full_path, 0, slash_pos + 1)));\n"
"if (c_id is null)\n"
"return;\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_NAME = subseq (full_path, slash_pos + 1) and RES_COL = c_id));\n"
"if (r_id is null)\n"
"return;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES where RES_ID = r_id;\n"
"update WS.WS.HOSTFS_COL set COL_MOD_TIME = now() where COL_ID = c_id and COL_MOD_TIME < now();\n"
"}\n"
"--src DET_HostFs.sql:429\n"
;

static const char *proc579 = 
"#line 452 \"[executable]/DET_HostFs.sql\"\n"
"create function\n"
"WS.WS.HOSTFS_TOUCH_RES (in ospath varchar) returns integer\n"
"{\n"
"declare mimetype, ft_mode varchar;\n"
"declare cr_time, mod_time datetime;\n"
"declare flen, rc integer;\n"
"\n"
"rc := WS.WS.HOSTFS_PATH_STAT (ospath, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"WS.WS.HOSTFS_READ_TYPEINFO (ospath, mimetype, ft_mode);\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (ospath, null, flen, cr_time, mod_time, mimetype, ft_mode);\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:450\n"
;

static const char *proc580 = 
"#line 471 \"[executable]/DET_HostFs.sql\"\n"
"create procedure\n"
"WS.WS.HOSTFS_GLOBAL_RESET ()\n"
"{\n"
"set isolation = \'serializable\';\n"
"delete from WS.WS.HOSTFS_RES_META;\n"
"delete from WS.WS.HOSTFS_RES_CACHE;\n"
"delete from WS.WS.HOSTFS_RES;\n"
"delete from WS.WS.HOSTFS_COL;\n"
"sequence_set (\'WS.WS.HOSTFS_COL_ID\', 0, 0);\n"
"sequence_set (\'WS.WS.HOSTFS_RES_ID\', 0, 0);\n"
"}\n"
"--src DET_HostFs.sql:469\n"
;

static const char *proc581 = 
"#line 484 \"[executable]/DET_HostFs.sql\"\n"
"create function\n"
"WS.WS.HOSTFS_PATH_STAT (in full_path varchar, out flen integer, out cr_time datetime, out mod_time datetime) returns integer\n"
"{\n"
"declare tmp varchar;\n"
"tmp := file_stat (full_path);\n"
"if (not isstring (tmp))\n"
"return -1;\n"
"cr_time := mod_time := cast (tmp as datetime);\n"
"flen := cast (file_stat (full_path, 1) as integer);\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:482\n"
;

static const char *proc582 = 
"#line 497 \"[executable]/DET_HostFs.sql\"\n"
"create procedure\n"
"WS.WS.HOSTFS_READ_TYPEINFO (in full_path varchar, out mimetype varchar, out ft_mode varchar)\n"
"{\n"
"declare mt varchar;\n"
"mt := http_mime_type (full_path);\n"
"mimetype := mt;\n"
"if (\'text/html\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (\'text/xml\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (\'text/xhtml\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (\'%+xml\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (mt like \'text/%\')\n"
"ft_mode := \'t\';\n"
"else\n"
"ft_mode := \'N\';\n"
"}\n"
"--src DET_HostFs.sql:495\n"
;

static const char *proc583 = 
"#line 519 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"\n"
"declare puid, pgid integer;\n"
"declare pperms varchar;\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), http_admin_gid() );\n"
"pperms := \'110100100RR\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"if (DAV_CHECK_PERM (pperms, req, auth_uid, null, pgid, puid))\n"
"return auth_uid;\n"
"return -13;\n"
"}\n"
"--src DET_HostFs.sql:517\n"
;

static const char *proc584 = 
"#line 540 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), http_admin_gid() );\n"
"pperms := \'110100100RR\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"}\n"
"if (DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return a_uid;\n"
"return -13;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_HostFs.sql:538\n"
;

static const char *proc585 = 
"#line 585 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:583\n"
;

static const char *proc586 = 
"#line 592 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"\n"
"system (sprintf (\'mkdir \'\'%s\'\'\', ospath));\n"
"WS.WS.HOSTFS_FIND_COL (ospath);\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"--src DET_HostFs.sql:590\n"
;

static const char *proc587 = 
"#line 604 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:602\n"
;

static const char *proc588 = 
"#line 611 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:609\n"
;

static const char *proc589 = 
"#line 618 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"declare ospath varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"\n"
"system (sprintf (\'rm -rf \'\'%s\'\'\', ospath));\n"
"return 1;\n"
"}\n"
"--src DET_HostFs.sql:616\n"
;

static const char *tbl8 = 
"create table \"HostFs_DAV_RES_UPLOAD\" (ID varchar primary key, DT datetime, CNT long varchar)\n";

static const char *proc590 = 
"#line 632 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath varchar;\n"
"declare rc integer;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"if (__tag (content) = 126)\n"
"{\n"
"declare p varchar;\n"
"p := \'[\' || serialize (now()) || \'][\' || serialize (detcol_id) || \'][\' || serialize (path_parts) || \']\';\n"
"insert into \"HostFs_DAV_RES_UPLOAD\" values (p, now(), content);\n"
"\n"
"string_to_file (ospath, coalesce ((select CNT from \"HostFs_DAV_RES_UPLOAD\" where ID=p), 1), -2);\n"
"}\n"
"else\n"
"string_to_file (ospath, content, -2);\n"
"rc := WS.WS.HOSTFS_TOUCH_RES (ospath);\n"
"if (rc < 0)\n"
"return -28;\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"--src DET_HostFs.sql:630\n"
;

static const char *proc591 = 
"#line 655 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_PROP_REMOVE\" (in id any, in what char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:653\n"
;

static const char *proc592 = 
"#line 662 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_PROP_SET\" (in id any, in what char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (propname[0] = 58)\n"
"{\n"
"return -16;\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:660\n"
;

static const char *proc593 = 
"#line 673 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"declare ospath varchar;\n"
"ospath := id[2];\n"
"\n"
"if (not isstring (file_stat (ospath)))\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"return -11;\n"
"}\n"
"--src DET_HostFs.sql:671\n"
;

static const char *proc594 = 
"#line 688 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"declare ospath varchar;\n"
"ospath := id[2];\n"
"\n"
"if (not isstring (file_stat (ospath)))\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"return vector ();\n"
"}\n"
"--src DET_HostFs.sql:686\n"
;

static const char *proc595 = 
"#line 703 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_ID_TO_OSPATH\" (in col any)\n"
"{\n"
"declare res varchar;\n"
"declare ctr, len integer;\n"
"if (isinteger (col))\n"
"return coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = col), \' no such \');\n"
"return col[2];\n"
"}\n"
"--src DET_HostFs.sql:701\n"
;

static const char *proc596 = 
"#line 713 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"declare fullname, name, tmp, mimetype, ft_mode varchar;\n"
"declare cr_time, mod_time datetime;\n"
"declare puid, pgid, flen, rc integer;\n"
"\n"
"fullname := id[2];\n"
"rc := WS.WS.HOSTFS_PATH_STAT (fullname, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"if (\'R\' = what)\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (fullname);\n"
"else\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (fullname);\n"
"return -1;\n"
"}\n"
"name := subseq (fullname, strrchr (fullname, \'/\') + 1);\n"
"if (path is null)\n"
"path := \"HostFs_DAV_SEARCH_PATH\" (id, what);\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), puid+1);\n"
"if (\'R\' = what)\n"
"{\n"
"WS.WS.HOSTFS_READ_TYPEINFO (fullname, mimetype, ft_mode);\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (fullname, null, flen, cr_time, mod_time, mimetype, ft_mode);\n"
"return vector (path, \'R\',	flen, mod_time, id, \'110000000RR\', pgid, puid, cr_time, mimetype, name);\n"
"}\n"
"if (\'C\' = what)\n"
"{\n"
"return vector (DAV_CONCAT_PATH (path, \'/\'), \'C\', flen, mod_time, id, \'110000000RR\', pgid, puid, cr_time, \'dav/unix-directory\', name);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:711\n"
;

static const char *proc597 = 
"#line 751 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath, name, fullname, top_davpath varchar;\n"
"declare stale_files, files, stale_dirs, dirs, res any;\n"
"declare ctr, len integer;\n"
"declare tmp, mimetype, ft_mode varchar;\n"
"declare cr_time, mod_time datetime;\n"
"declare puid, pgid, flen, rc, parent_c_id, r_id integer;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"top_davpath := DAV_CONCAT_PATH (detcol_path, path_parts);\n"
"whenever sqlstate \'39000\' goto no_dir;\n"
"dirs := sys_dirlist (ospath, 0);\n"
"parent_c_id := WS.WS.HOSTFS_FIND_COL (ospath);\n"
"if (parent_c_id is null)\n"
"select VECTOR_AGG (COL_FULL_PATH) into stale_dirs from WS.WS.HOSTFS_COL where COL_PARENT_ID is null and 0 = position (COL_NAME, dirs);\n"
"else\n"
"select VECTOR_AGG (COL_FULL_PATH) into stale_dirs from WS.WS.HOSTFS_COL where COL_PARENT_ID = parent_c_id and 0 = position (COL_NAME, dirs);\n"
"foreach (varchar stale_fullname in stale_dirs) do\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (stale_fullname);\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = detcol_id and COL_DET=\'HostFs\'), \'\')\n"
"), puid+1);\n"
"vectorbld_init (res);\n"
"len := length (dirs);\n"
"ctr := 0;\n"
"while (ctr < len)\n"
"{\n"
"name := dirs [ctr];\n"
"if ((name <> \'.\') and (name <> \'..\'))\n"
"{\n"
"fullname := DAV_CONCAT_PATH (ospath, name);\n"
"\n"
"rc := WS.WS.HOSTFS_PATH_STAT (fullname, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (fullname);\n"
"}\n"
"else\n"
"{\n"
"vectorbld_acc (res, vector (\n"
"DAV_CONCAT_PATH (top_davpath, name) || \'/\', \'C\',\n"
"flen,\n"
"mod_time,\n"
"vector (UNAME\'HostFs\', detcol_id, fullname),\n"
"\'110100000RR\', pgid, puid,\n"
"cr_time,\n"
"\'dav/unix-directory\',\n"
"name ) );\n"
"if (recursive > 0)\n"
"vectorbld_concat_acc (res,\n"
"\"HostFs_DAV_DIR_LIST\" (detcol_id,\n"
"vector_concat (subseq (path_parts, 0, length (path_parts)-1), vector (name, \'\')),\n"
"detcol_path, name_mask, recursive, auth_uid) );\n"
"}\n"
"}\n"
"ctr := ctr + 1;\n"
"}\n"
"files := sys_dirlist (ospath, 1);\n"
"if (parent_c_id is null)\n"
"select VECTOR_AGG (RES_NAME) into stale_files from WS.WS.HOSTFS_RES where RES_COL is null and 0 = position (RES_NAME, files);\n"
"else\n"
"select VECTOR_AGG (RES_NAME) into stale_files from WS.WS.HOSTFS_RES where RES_COL = parent_c_id and 0 = position (RES_NAME, files);\n"
"foreach (varchar stale_name in stale_files) do\n"
"{\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_COL = parent_c_id and RES_NAME = stale_name));\n"
"delete from WS.WS.HOSTFS_RES_META where RESM_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES where RES_ID = r_id;\n"
"}\n"
"len := length (files);\n"
"ctr := 0;\n"
"while (ctr < len)\n"
"{\n"
"name := files [ctr];\n"
"fullname := DAV_CONCAT_PATH (ospath, name);\n"
"rc := WS.WS.HOSTFS_PATH_STAT (fullname, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"delete from WS.WS.HOSTFS_RES_META where RESM_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES where RES_ID = r_id;\n"
"}\n"
"else\n"
"{\n"
"WS.WS.HOSTFS_READ_TYPEINFO (fullname, mimetype, ft_mode);\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (fullname, parent_c_id, flen, cr_time, mod_time, mimetype, ft_mode);\n"
"if (name like name_mask)\n"
"{\n"
"\n"
"vectorbld_acc (res, vector (\n"
"DAV_CONCAT_PATH (top_davpath, name), \'R\',\n"
"flen,\n"
"mod_time,\n"
"vector (UNAME\'HostFs\', detcol_id, fullname),\n"
"\'110100000RR\', pgid, puid,\n"
"cr_time,\n"
"mimetype,\n"
"name ) );\n"
"}\n"
"}\n"
"ctr := ctr + 1;\n"
"}\n"
"update WS.WS.HOSTFS_COL set COL_MOD_TIME = now() where COL_ID = parent_c_id and COL_MOD_TIME < now();\n"
"vectorbld_final (res);\n"
"\n"
"return res;\n"
"\n"
"no_dir:\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"return vector();\n"
"}\n"
"--src DET_HostFs.sql:749\n"
;

static const char *proc598 = 
"#line 868 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, in compilation varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_HostFs.sql:866\n"
;

static const char *proc599 = 
"#line 876 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"declare ospath, stat varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"stat := file_stat (ospath, 2);\n"
"if (not isstring (stat))\n"
"{\n"
"\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"if (0 = bit_and (32768, cast (stat as integer)))\n"
"{\n"
"\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (0 = bit_and (16384, cast (stat as integer)))\n"
"{\n"
"\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"}\n"
"\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"--src DET_HostFs.sql:874\n"
;

static const char *proc600 = 
"#line 912 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"declare ospath varchar;\n"
"declare slash_pos, detcol_fullpath integer;\n"
"\n"
"ospath := id[2];\n"
"slash_pos := strchr (ospath, \'/\');\n"
"detcol_fullpath := coalesce ((select WS.WS.COL_PATH (COL_ID) from WS.WS.SYS_DAV_COL where COL_ID = id[1] and COL_DET=\'HostFs\'));\n"
"if (detcol_fullpath is null)\n"
"return -23;\n"
"if (not isstring (file_stat (ospath)))\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -23;\n"
"}\n"
"return detcol_fullpath || subseq (ospath, slash_pos + 1);\n"
"}\n"
"--src DET_HostFs.sql:910\n"
;

static const char *proc601 = 
"#line 932 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_RES_UPLOAD_COPY\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in source_id any,\n"
"in what char(1),\n"
"in overwrite integer,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1) returns any\n"
"{\n"
"declare ospath varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"if (what = \'R\')\n"
"{\n"
"declare cnt any;\n"
"declare mime_type varchar;\n"
"declare rc integer;\n"
"rc := DAV_RES_CONTENT_INT (source_id, cnt, mime_type, 0, 0);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"string_to_file (ospath, case (__tag (cnt)) when 126 then blob_to_string (cnt) else cnt end, -2);\n"
"rc := WS.WS.HOSTFS_TOUCH_RES (ospath);\n"
"if (rc < 0)\n"
"return -28;\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:930\n"
;

static const char *proc602 = 
"#line 971 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_RES_UPLOAD_MOVE\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in source_id any,\n"
"in what char(1),\n"
"in overwrite integer,\n"
"in auth_uid integer,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1) returns any\n"
"{\n"
"declare ospath, src_path varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"if (what = \'R\')\n"
"{\n"
"declare cnt any;\n"
"declare mime_type varchar;\n"
"declare rc integer;\n"
"rc := DAV_RES_CONTENT_INT (source_id, cnt, mime_type, 0, 0);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"string_to_file (ospath, case (__tag (cnt)) when 126 then blob_to_string (cnt) else cnt end, -2);\n"
"rc := WS.WS.HOSTFS_TOUCH_RES (ospath);\n"
"if (rc < 0)\n"
"return -28;\n"
"src_path := DAV_SEARCH_PATH (source_id, \'R\');\n"
"if (src_path is not null)\n"
"DAV_DELETE_INT (src_path, 1, null, null, 0);\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:969\n"
;

static const char *proc603 = 
"#line 1010 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto no_res;\n"
"declare ft_mode varchar;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"content := file_to_string (id[2]);\n"
"else if (content_mode = 1)\n"
"file_append_to_string_output (id[2], content);\n"
"else if (content_mode = 3)\n"
"http_file (id[2]);\n"
"WS.WS.HOSTFS_READ_TYPEINFO (id[2], type, ft_mode);\n"
"return 0;\n"
"\n"
"no_res:\n"
"\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (id[2]);\n"
"return -1;\n"
"}\n"
"--src DET_HostFs.sql:1008\n"
;

static const char *proc604 = 
"#line 1031 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:1029\n"
;

static const char *proc605 = 
"#line 1038 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_LOCK\" (in path any, in id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:1036\n"
;

static const char *proc606 = 
"#line 1045 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"return -27;\n"
"}\n"
"--src DET_HostFs.sql:1043\n"
;

static const char *proc607 = 
"#line 1052 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_type char(1);\n"
"\n"
"orig_id := id;\n"
"id := orig_id[1];\n"
"orig_type := type;\n"
"type := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id;\n"
"type := orig_type;\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:1050\n"
;

static const char *proc608 = 
"#line 1071 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_HostFs.sql:1069\n"
;

static const char *proc609 = 
"#line 1078 \"[executable]/DET_HostFs.sql\"\n"
"create procedure \"HostFs_CF_LIST_PROP_DISTVALS\" (in detcol_id integer, in cfc_id integer, in rfc_spath varchar, inout rfc_list_cond any, in schema_uri varchar, inout filter_data any, inout distval_dict any, in auth_uid integer)\n"
"{\n"
"declare topcol_name varchar;\n"
"declare topcol_id integer;\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_last_id, res_id_max integer;\n"
"declare plast_id integer;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val, v_last, v_max varchar;\n"
"\n"
"\n"
"declare hit_ids any;\n"
"declare c_last1 cursor for select             HRI_CATVALUE from WS.WS.HOSTFS_RDF_INVERSE\n"
"where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = plast_id and (v_max is null or HRI_CATVALUE > v_max)\n"
"\n"
"\n"
" ;\n"
"declare c_last2 cursor for select HRI_RES_ID, HRI_CATVALUE from WS.WS.HOSTFS_RDF_INVERSE\n"
"where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = plast_id and (v_max is null or HRI_CATVALUE > v_max)\n"
"\n"
"\n"
" ;\n"
"declare c0 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p0_id and HRI_CATVALUE = p0_val and HRI_RES_ID >= res_id_max;\n"
"declare c1 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p1_id and HRI_CATVALUE = p1_val and HRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p2_id and HRI_CATVALUE = p2_val and HRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p3_id and HRI_CATVALUE = p3_val and HRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p4_id and HRI_CATVALUE = p4_val and HRI_RES_ID >= res_id_max;\n"
"\n"
"topcol_name := coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = detcol_id and COL_DET = \'HostFs\'));\n"
"if (topcol_name is null)\n"
"{\n"
"\n"
"return;\n"
"}\n"
"topcol_id := coalesce ((select COL_ID from WS.WS.HOSTFS_COL where COL_PARENT_ID is null and COL_NAME = topcol_name), WS.WS.HOSTFS_FIND_COL (topcol_name));\n"
"filter_length := length (filter_data);\n"
"plast_id := filter_data [filter_length - 1];\n"
"res_id_max := 0;\n"
"v_max := null;\n"
"\n"
"\n"
"\n"
"if (filter_length = 2)\n"
"{\n"
"whenever not found goto nf_c_last1;\n"
"\n"
"open c_last1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last1 into v_last;\n"
"\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"nf_c_last1:\n"
"close c_last1;\n"
"return;\n"
"}\n"
"\n"
"res0_id := 0;\n"
"res1_id := 0;\n"
"res2_id := 0;\n"
"res3_id := 0;\n"
"res4_id := 0;\n"
"hit_ids := dict_new ();\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 6)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 10)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"else\n"
"res_id_max := res_id_max + 1;\n"
"\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 14)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"\n"
"\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 18)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 22)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"\n"
"close c4;\n"
"get_distincts_3:\n"
"\n"
"close c3;\n"
"get_distincts_2:\n"
"\n"
"close c2;\n"
"get_distincts_1:\n"
"\n"
"close c1;\n"
"get_distincts_0:\n"
"\n"
"close c0;\n"
"\n"
"\n"
"whenever not found goto nf_c_last2;\n"
"open c_last2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last2 into res_last_id, v_last;\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"\n"
"if (dict_get (hit_ids, res_last_id, 0))\n"
"{\n"
"\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"}\n"
"nf_c_last2:\n"
"close c_last2;\n"
"}\n"
"--src DET_HostFs.sql:1076\n"
;

static const char *proc610 = 
"#line 1307 \"[executable]/DET_HostFs.sql\"\n"
"create function \"HostFs_CF_GET_RDF_HITS\" (in detcol_id integer, in cfc_id integer, in rfc_spath varchar, inout rfc_list_cond any, in schema_uri varchar, inout filter_data any, in detcol_path varchar, in make_diritems integer, in auth_uid integer) returns any\n"
"{\n"
"declare topcol_name varchar;\n"
"declare topcol_id, acc_ctr, acc_len integer;\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_id_max integer;\n"
"declare acc any;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val varchar;\n"
"\n"
"\n"
"declare c0 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p0_id and HRI_CATVALUE = p0_val and HRI_RES_ID >= res_id_max\n"
"\n"
"\n"
" ;\n"
"declare c1 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p1_id and HRI_CATVALUE = p1_val and HRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p2_id and HRI_CATVALUE = p2_val and HRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p3_id and HRI_CATVALUE = p3_val and HRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p4_id and HRI_CATVALUE = p4_val and HRI_RES_ID >= res_id_max;\n"
"\n"
"topcol_name := coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = detcol_id and COL_DET = \'HostFs\'));\n"
"if (topcol_name is null)\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"topcol_id := coalesce ((select COL_ID from WS.WS.HOSTFS_COL where COL_PARENT_ID is null and COL_NAME = topcol_name), WS.WS.HOSTFS_FIND_COL (topcol_name));\n"
"filter_length := length (filter_data);\n"
"vectorbld_init (acc);\n"
"\n"
"res0_id := -1;\n"
"res1_id := -1;\n"
"res2_id := -1;\n"
"res3_id := -1;\n"
"res4_id := -1;\n"
"res_id_max := 0;\n"
"\n"
"\n"
"\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 4)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 8)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 12)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 16)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 20)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"close c4;\n"
"get_distincts_3:\n"
"close c3;\n"
"get_distincts_2:\n"
"close c2;\n"
"get_distincts_1:\n"
"close c1;\n"
"get_distincts_0:\n"
"close c0;\n"
"\n"
"finalize:\n"
"vectorbld_final (acc);\n"
"acc_len := length (acc);\n"
"acc_ctr := 0;\n"
"while (acc_ctr < acc_len)\n"
"{\n"
"declare r_id integer;\n"
"declare fullname varchar;\n"
"declare full_id, diritm any;\n"
"r_id := acc [acc_ctr];\n"
"fullname := coalesce ((select top 1 COL_FULL_PATH || RES_NAME from WS.WS.HOSTFS_RES join WS.WS.HOSTFS_COL on (RES_COL = COL_ID) where RES_ID = r_id), \'\\377\\377\\377dead\');\n"
"full_id := vector (UNAME\'HostFs\', detcol_id, fullname);\n"
"if (make_diritems = 1)\n"
"{\n"
"diritm := \"HostFs_DAV_DIR_SINGLE\" (full_id, \'R\', \'(fake path)\', auth_uid);\n"
"if (DAV_HIDE_ERROR (diritm) is not null)\n"
"{\n"
"diritm [0] := DAV_CONCAT_PATH (detcol_path, diritm[10]);\n"
"acc [acc_ctr] := diritm;\n"
"acc_ctr := acc_ctr + 1;\n"
"}\n"
"else\n"
"{\n"
"if (acc_len > 1)\n"
"{\n"
"acc [acc_ctr] := acc [acc_len - 1];\n"
"acc_len := acc_len - 1;\n"
"\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"acc [acc_ctr] := full_id;\n"
"acc_ctr := acc_ctr + 1;\n"
"}\n"
"}\n"
"if (acc_len < length (acc))\n"
"{\n"
"acc := subseq (acc, 0, acc_len);\n"
"}\n"
"\n"
"return acc;\n"
"}\n"
"--src DET_HostFs.sql:1305\n"
;

static const char *proc611 = 
"#line 1525 \"[executable]/DET_HostFs.sql\"\n"
"create procedure \"HostFs_RF_ID2SUFFIX\" (in id any, in what char(1))\n"
"{\n"
"if (what=\'C\')\n"
"{\n"
"return sprintf (\'HostDir-%d-%d\',\n"
"id[1], WS.WS.HOSTFS_FIND_COL (id[2]));\n"
"}\n"
"if (what=\'R\')\n"
"{\n"
"declare full_path varchar;\n"
"declare len, slash_pos integer;\n"
"declare r_id, c_id integer;\n"
"full_path := id[2];\n"
"len := length (full_path);\n"
"if ((len = 0) or (full_path[len-1] = 47))\n"
"r_id := 0;\n"
"else\n"
"{\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"if (c_id is null)\n"
"{\n"
"if (slash_pos is null)\n"
"c_id := WS.WS.HOSTFS_FIND_COL (\'\');\n"
"else\n"
"c_id := WS.WS.HOSTFS_FIND_COL (subseq (full_path, 0, slash_pos));\n"
"}\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_NAME = subseq (full_path, slash_pos + 1) and RES_COL = c_id), 0);\n"
"}\n"
"return sprintf (\'HostFile-%d-%d\', id[1], r_id);\n"
"}\n"
"signal (\'OBLOM\', \'Invalid arguments for HostFs_RF_ID2SUFFIX\');\n"
"}\n"
"--src DET_HostFs.sql:1523\n"
;

static const char *proc612 = 
"#line 1559 \"[executable]/DET_HostFs.sql\"\n"
"create procedure \"HostFile_RF_SUFFIX2ID\" (in suffix varchar, in what char(1))\n"
"{\n"
"declare pairs any;\n"
"declare r_id varchar;\n"
"declare detcol_id integer;\n"
"if (\'R\' <> what)\n"
"return null;\n"
"pairs := regexp_parse (\'^([1-9][0-9]*)-([1-9][0-9]*)\\044\', suffix, 0);\n"
"if (pairs is null)\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"detcol_id := cast (subseq (suffix, pairs[2], pairs[3]) as integer);\n"
"whenever not found goto oblom;\n"
"select vector (UNAME\'HostFs\', detcol_id, COL_FULL_PATH || RES_NAME) into r_id\n"
"from WS.WS.HOSTFS_RES join WS.WS.HOSTFS_COL on (RES_COL = COL_ID)\n"
"where RES_ID = cast (subseq (suffix, pairs[4], pairs[5]) as integer);\n"
"return r_id;\n"
"oblom:\n"
"return null;\n"
"}\n"
"--src DET_HostFs.sql:1557\n"
;

static const char *proc613 = 
"#line 1583 \"[executable]/DET_HostFs.sql\"\n"
"create procedure \"HostDir_RF_SUFFIX2ID\" (in suffix varchar, in what char(1))\n"
"{\n"
"declare pairs any;\n"
"declare c_id varchar;\n"
"declare detcol_id integer;\n"
"if (\'C\' <> what)\n"
"return null;\n"
"pairs := regexp_parse (\'^([1-9][0-9]*)-([1-9][0-9]*)\\044\', suffix, 0);\n"
"if (pairs is null)\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"detcol_id := cast (subseq (suffix, pairs[2], pairs[3]) as integer);\n"
"whenever not found goto oblom;\n"
"select vector (UNAME\'HostFs\', detcol_id, COL_FULL_PATH) into c_id\n"
"from WS.WS.HOSTFS_RES join WS.WS.HOSTFS_COL on (RES_COL = COL_ID);\n"
"return c_id;\n"
"oblom:\n"
"return NULL;\n"
"}\n"
"--src DET_HostFs.sql:1581\n"
;

/* DET_ResFilter.sql */

static const char *proc614 = 
"#line 24 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare spath_id integer;\n"
"\n"
"rfc_spath := null;\n"
"if (DAV_HIDE_ERROR (\"ResFilter_GET_CONDITION\" (id[1], rfc_spath, rfc_list_cond, rfc_del_action)) is null)\n"
"return -1;\n"
"if (not (\'110\' like req))\n"
"return -13;\n"
"if (\'C\' = what)\n"
"{\n"
"spath_id := DAV_SEARCH_ID (rfc_spath, \'C\');\n"
"return DAV_AUTHENTICATE (spath_id, \'C\', req, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"if (\'R\' = what)\n"
"{\n"
"return DAV_AUTHENTICATE (id [2], \'R\', req, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"return -14;\n"
"}\n"
"--src DET_ResFilter.sql:22\n"
;

static const char *proc615 = 
"#line 49 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_NORM\" (in value any) returns varchar\n"
"{\n"
"value := blob_to_string (value);\n"
"if ((\'\' = value) or (193 <> value[0]))\n"
"return value;\n"
"value := deserialize (value)[1];\n"
"if (isstring (value))\n"
"return value;\n"
"return cast (xml_tree_doc(value) as varchar);\n"
"}\n"
"--src DET_ResFilter.sql:47\n"
;

static const char *proc616 = 
"#line 62 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_ENCODE_FILTER\" (in filt any) returns varchar\n"
"{\n"
"if (193 <> __tag (filt))\n"
"signal (\'.....\', \'Invalid filter passed to ResFilter_ENCODE_FILTER\');\n"
"filt := serialize (filt);\n"
"filt[0] := 2;\n"
"return filt;\n"
"}\n"
"--src DET_ResFilter.sql:60\n"
;

static const char *proc617 = 
"#line 73 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DECODE_FILTER\" (in value any) returns any\n"
"{\n"
"value := blob_to_string (value);\n"
"if ((\'\' = value) or (value[0] <> 2))\n"
"signal (\'.....\', \'Invalid filter serialization passed to ResFilter_DECODE_FILTER\');\n"
"value [0] := 193;\n"
"return deserialize (value);\n"
"}\n"
"--src DET_ResFilter.sql:71\n"
;

static const char *proc618 = 
"#line 84 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_GET_CONDITION\" (in detcol_id integer, out rfc_spath varchar, out rfc_list_cond any, out rfc_del_action any)\n"
"{\n"
"\n"
"whenever not found goto nf;\n"
"if (isarray (detcol_id))\n"
"return -20;\n"
"select \"ResFilter_NORM\" (PROP_VALUE) into rfc_spath from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-SearchPath\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_list_cond from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-ListCond\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_del_action from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-DelAction\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"return 0;\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src DET_ResFilter.sql:82\n"
;

static const char *proc619 = 
"#line 100 \"[executable]/DET_ResFilter.sql\"\n"
"create procedure \"ResFilter_FIT_INTO_CONDITION\" (in id any, in what char (1), inout rfc_list_cond any, in auth_uid integer)\n"
"{\n"
"\n"
"declare has_rdf_preds integer;\n"
"declare raw_filter any;\n"
"has_rdf_preds := 0;\n"
"raw_filter := get_keyword (\'\', rfc_list_cond);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare propid integer;\n"
"declare old_value, pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'PROP_VALUE\' = pred_name) and (\'=\' = pred_cmp))\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_SET\')(id, what, pred[3], pred[2], 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"whenever not found goto ins_prop;\n"
"select p.PROP_ID, \"ResFilter_NORM\" (p.PROP_VALUE) into propid, old_value from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pred[3] and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"if (old_value <> pred[2])\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = pred[2] where PROP_ID = propid;\n"
"goto next_pred;\n"
"ins_prop:\n"
"propid := WS.WS.GETID (\'P\');\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (propid, pred[3], pred[2], id, what);\n"
"goto next_pred;\n"
"}\n"
"if ((\'PROP_VALUE\' = pred_name) and (\'<>\' = pred_cmp))\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\')(id, what, pred[3], 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"whenever not found goto next_pred;\n"
"select p.PROP_ID into propid from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pred[3] and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id and \"ResFilter_NORM\" (p.PROP_VALUE) = pred[2];\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_ID = propid;\n"
"goto next_pred;\n"
"}\n"
"if ((\'PROP_NAME\' = pred_name) and (\'not_exists\' = pred_cmp))\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\')(id, what, pred[3], 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"whenever not found goto next_pred;\n"
"select p.PROP_ID into propid from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pred[2] and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_ID = propid;\n"
"goto next_pred;\n"
"}\n"
"else if ((\'RDF_VALUE\' = pred_name) and ((\'=\' = pred_cmp) or (\'<>\' = pred_cmp)) and (5 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"has_rdf_preds := 1;\n"
"goto next_pred;\n"
"}\n"
"else if ((\'RDF_PRED\' = pred_name) and (\'not_exists\' = pred_cmp) and (4 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"has_rdf_preds := 1;\n"
"goto next_pred;\n"
"}\n"
"else\n"
"{\n"
"\n"
"signal (\'.....\', \'Unsupported predicate in ResFilter_FIT_INTO_CONDITION\');\n"
"}\n"
"next_pred: ;\n"
"}\n"
"if (has_rdf_preds)\n"
"{\n"
"declare propid integer;\n"
"declare old_prop, old_n3, acc_n3, new_n3, new_davxml any;\n"
"declare top_path nvarchar;\n"
"top_path := cast (DAV_SEARCH_PATH (id, what) as nvarchar);\n"
"xte_nodebld_init (acc_n3);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'RDF_VALUE\' = pred_name) and (\'=\' = pred_cmp))\n"
"{\n"
"xte_nodebld_acc (acc_n3,\n"
"xte_node (\n"
"xte_head (\'N3\', \'N3S\', top_path, \'N3P\', pred [4]),\n"
"pred [2] ) );\n"
"}\n"
"}\n"
"xte_nodebld_final (acc_n3, xte_head (\' root\'));\n"
"acc_n3 := xml_tree_doc (acc_n3);\n"
"old_n3 := null;\n"
"propid := null;\n"
"if (isarray (id))\n"
"{\n"
"old_prop := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\')(id, what, \'http://local.virt/DAV-RDF\', auth_uid);\n"
"if (DAV_HIDE_ERROR (old_prop) is null)\n"
"{\n"
"goto do_merge;\n"
"}\n"
"if (isentity (old_prop))\n"
"{\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop);\n"
"goto do_merge;\n"
"}\n"
"goto old_prop_found;\n"
"}\n"
"whenever not found goto do_merge;\n"
"select p.PROP_ID, blob_to_string (p.PROP_VALUE) into propid, old_prop\n"
"from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r\n"
"where p.PROP_NAME = \'http://local.virt/DAV-RDF\' and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"goto do_merge;\n"
"old_prop_found:\n"
"old_prop := deserialize (cast (old_prop as varchar));\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', xml_tree_doc (old_prop));\n"
"do_merge:\n"
"new_n3 := DAV_RDF_MERGE (old_n3, acc_n3, null, -1);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'RDF_PRED\' = pred_name) and (\'<>\' = pred_cmp))\n"
"{\n"
"new_n3 := XMLUpdate (new_n3, \'/N3[N3P=\' || WS.WS.STR_SQL_APOS (pred[4]) || \'][string (.) =\' || WS.WS.STR_SQL_APOS (pred[2]) || \']\', null);\n"
"}\n"
"else\n"
"if ((\'RDF_PRED\' = pred_name) and (\'not_exists\' = pred_cmp))\n"
"{\n"
"new_n3 := XMLUpdate (new_n3, \'/N3[N3P=\' || WS.WS.STR_SQL_APOS (pred[2]) || \']\', null);\n"
"}\n"
"}\n"
"new_davxml := DAV_RDF_PREPROCESS_RDFXML (new_n3, top_path, 1);\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_SET\')(id, what, \'http://local.virt/DAV-RDF\', new_davxml, 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"else if (propid is null)\n"
"{\n"
"propid := WS.WS.GETID (\'P\');\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (propid, \'http://local.virt/DAV-RDF\', serialize (new_davxml), id, what);\n"
"}\n"
"else\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = serialize (new_davxml) where PROP_ID = propid;\n"
"}\n"
"}\n"
"--src DET_ResFilter.sql:98\n"
;

static const char *proc620 = 
"#line 253 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_MAKE_DEL_ACTION_FROM_CONDITION\" (inout rfc_list_cond any) returns any\n"
"{\n"
"\n"
"declare raw_filter, res any;\n"
"res := vector ();\n"
"raw_filter := get_keyword (\'\', rfc_list_cond);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare propid integer;\n"
"declare old_value, pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'PROP_VALUE\' = pred_name) and (\'=\' = pred_cmp))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'PROP_VALUE\', \'<>\', pred[2], pred [3])));\n"
"}\n"
"else if ((\'PROP_VALUE\' = pred_name) and (\'<>\' = pred_cmp))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'PROP_VALUE\', \'=\', pred[2], pred [3])));\n"
"}\n"
"else if ((\'RDF_VALUE\' = pred_name) and (\'=\' = pred_cmp) and (5 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'RDF_VALUE\', \'<>\', pred [2], \'http://local.virt/DAV-RDF\', pred [4])));\n"
"}\n"
"else if ((\'RDF_VALUE\' = pred_name) and (\'<>\' = pred_cmp) and (5 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'RDF_VALUE\', \'=\', pred [2], \'http://local.virt/DAV-RDF\', pred [4])));\n"
"}\n"
"else return vector ();\n"
"}\n"
"return vector (\'\', res);\n"
"}\n"
"--src DET_ResFilter.sql:251\n"
;

static const char *proc621 = 
"#line 287 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_LEAVE_CONDITION\" (in id integer, in what char (1), in rfc_del_action any, in auth_uid integer) returns integer\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (id, what, rfc_del_action, auth_uid);\n"
"return 0;\n"
"}\n"
"--src DET_ResFilter.sql:285\n"
;

static const char *proc622 = 
"#line 294 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_FNMERGE\" (\n"
"in path any,\n"
"in id any) returns varchar\n"
"{\n"
"\n"
"declare pairs any;\n"
"declare res varchar;\n"
"\n"
"pairs := regexp_parse (\'^(.*[/])?([^/][^./]*)([^/]*)\\044\', path, 0);\n"
"if (pairs is null)\n"
"signal (\'.....\', sprintf (\'Internal error: failed \"ResFilter_FNMERGE\" (%s, %d)\', path, id));\n"
"\n"
"if (isinteger (id))\n"
"return sprintf (\'%s -RfId%d%s\', subseq (path, 0, pairs[5]), id, subseq (path, pairs[6]));\n"
"\n"
"res := sprintf (\'%s -Rf%s%s\', subseq (path, 0, pairs[5]), call (cast (id[0] as varchar) || \'_RF_ID2SUFFIX\')(id, \'R\'), subseq (path, pairs[6]));\n"
"\n"
"return res;\n"
"}\n"
"--src DET_ResFilter.sql:292\n"
;

static const char *proc623 = 
"#line 315 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_FNSPLIT\" (\n"
"in path any,\n"
"out colpath varchar,\n"
"out orig_fnameext varchar,\n"
"out id any)\n"
"{\n"
"\n"
"declare pairs any;\n"
"declare fname, fext varchar;\n"
"\n"
"pairs := regexp_parse (\'^(.*[/])?([^/][^./]*)([^/]*)\\044\', path, 0);\n"
"if (pairs is null)\n"
"signal (\'.....\', sprintf (\'Internal error: failed \"ResFilter_FNSPLIT\" (%s)\', path));\n"
"\n"
"colpath := subseq (path, 0, pairs[4]);\n"
"fname := subseq (path, pairs[4], pairs[5]);\n"
"fext := subseq (path, pairs[6], pairs[7]);\n"
"pairs := regexp_parse (\'^(.*) -RfId([1-9][0-9]*)\\044\', fname, 0);\n"
"if (pairs is not null)\n"
"{\n"
"orig_fnameext := subseq (fname, pairs[2], pairs[3]) || fext;\n"
"id := cast (subseq (fname, pairs[4], pairs[5]) as integer);\n"
"\n"
"return;\n"
"}\n"
"pairs := regexp_parse (\'^(.*) -Rf([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*)\\044\', fname, 0);\n"
"if (pairs is not null)\n"
"{\n"
"whenever sqlstate \'*\' goto oblom;\n"
"orig_fnameext := subseq (fname, pairs[2], pairs[3]) || fext;\n"
"id := call (subseq (fname, pairs[4], pairs[5]) || \'_RF_SUFFIX2ID\')(subseq (fname, pairs[6], pairs[7]), \'R\');\n"
"\n"
"return;\n"
"}\n"
"\n"
"oblom:\n"
"orig_fnameext := fname || fext;\n"
"id := null;\n"
"}\n"
"--src DET_ResFilter.sql:313\n"
;

static const char *proc624 = 
"#line 356 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_SEARCH_ID_IMPL\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in what char(1),\n"
"inout rfc_spath varchar,\n"
"inout rfc_list_cond any,\n"
"inout rfc_del_action any) returns any\n"
"{\n"
"\n"
"declare colpath, orig_fnameext varchar;\n"
"declare orig_id any;\n"
"declare hitlist any;\n"
"declare ext_cond any;\n"
"\n"
"if (\'R\' <> what)\n"
"return -1;\n"
"\n"
"if (not (isstring (rfc_spath)) and (0 > \"ResFilter_GET_CONDITION\" (detcol_id, rfc_spath, rfc_list_cond, rfc_del_action)))\n"
"return -1;\n"
"\n"
"if (1 <> length(path_parts) or (\'\' = path_parts[0]))\n"
"return -1;\n"
"\n"
"\"ResFilter_FNSPLIT\" (path_parts[0], colpath, orig_fnameext, orig_id);\n"
"if (orig_id is null)\n"
"{\n"
"ext_cond := vector (vector (\'RES_NAME\', \'=\', orig_fnameext));\n"
"}\n"
"else\n"
"{\n"
"if (not isarray (orig_id))\n"
"{\n"
"ext_cond := vector (vector (\'RES_NAME\', \'=\', orig_fnameext), vector (\'RES_ID\', \'=\', orig_id));\n"
"}\n"
"else\n"
"{\n"
"ext_cond := vector (vector (\'RES_NAME\', \'=\', orig_fnameext), vector (\'RES_ID_SERIALIZED\', \'=\', serialize (orig_id)));\n"
"}\n"
"}\n"
"ext_cond := vector (\'\', vector_concat (ext_cond, get_keyword (\'\', rfc_list_cond)));\n"
"hitlist := DAV_DIR_FILTER_INT (rfc_spath, 1, ext_cond, null, null, http_dav_uid ());\n"
"if (length (hitlist) <> 1)\n"
"return -1;\n"
"\n"
"return hitlist[0][4];\n"
"}\n"
"--src DET_ResFilter.sql:354\n"
;

static const char *proc625 = 
"#line 405 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid, ruid, rgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'ResFilter_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'ResFilter\'), \'\')\n"
"), puid+1);\n"
"pperms := \'110100100NN\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := 0;\n"
"a_gid := 0;\n"
"}\n"
"}\n"
"if (not DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return -13;\n"
"\n"
"if (isarray (id[2]))\n"
"return -1;\n"
"select RES_OWNER, RES_GROUP into ruid, rgid from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"if (not DAV_CHECK_PERM (pperms, req, a_uid, a_gid, rgid, ruid))\n"
"return -13;\n"
"\n"
"return a_uid;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_ResFilter.sql:403\n"
;

static const char *proc626 = 
"#line 457 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_GET_PARENT\" (\n"
"in id any,\n"
"in what char(1),\n"
"in path varchar) returns any\n"
"{\n"
"\n"
"if (what = \'R\')\n"
"return id [1];\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:455\n"
;

static const char *proc627 = 
"#line 470 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_COL_CREATE\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:468\n"
;

static const char *proc628 = 
"#line 483 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:481\n"
;

static const char *proc629 = 
"#line 490 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:488\n"
;

static const char *proc630 = 
"#line 497 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"declare rc, orig_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"\n"
"rfc_spath := null;\n"
"orig_id := \"ResFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, rfc_spath, rfc_list_cond, rfc_del_action);\n"
"if (orig_id < 0)\n"
"return orig_id;\n"
"if (0 = length (rfc_del_action))\n"
"return -20;\n"
"return \"ResFilter_LEAVE_CONDITION\" (orig_id, what, rfc_del_action, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:495\n"
;

static const char *proc631 = 
"#line 513 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_RES_UPLOAD\" (\n"
"in detcol_id any,\n"
"in path_parts any,\n"
"inout content any,\n"
"in type varchar,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:511\n"
;

static const char *proc632 = 
"#line 528 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_PROP_REMOVE\" (\n"
"in id any,\n"
"in what char(0),\n"
"in propname varchar,\n"
"in silent integer,\n"
"in auth_uid integer) returns integer\n"
"{\n"
"\n"
"\n"
"if (what <> \'R\')\n"
"return -1;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, what, propname, silent, auth_uid);\n"
"\n"
"return DAV_PROP_REMOVE_RAW (id, what, propname, silent, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:526\n"
;

static const char *proc633 = 
"#line 548 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_PROP_SET\" (\n"
"in id any,\n"
"in what char(0),\n"
"in propname varchar,\n"
"in propvalue any,\n"
"in overwrite integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"\n"
"if (what <> \'R\')\n"
"return -1;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, what, propname, propvalue, overwrite, auth_uid);\n"
"\n"
"return DAV_PROP_SET_RAW (id, what, propname, propvalue, overwrite, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:546\n"
;

static const char *proc634 = 
"#line 569 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_PROP_GET\" (\n"
"in id any,\n"
"in what char(0),\n"
"in propname varchar,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"declare ret varchar;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"\n"
"if (propname[0] = 58)\n"
"return DAV_PROP_GET_INT (id, what, propname, 0, null, null, auth_uid);\n"
"\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src DET_ResFilter.sql:567\n"
;

static const char *proc635 = 
"#line 594 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_PROP_LIST\" (\n"
"in id any,\n"
"in what char(0),\n"
"in propmask varchar,\n"
"in auth_uid integer)\n"
"{\n"
"\n"
"declare ret any;\n"
"\n"
"id := id[2];\n"
"vectorbld_init (ret);\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do\n"
"{\n"
"vectorbld_acc (ret, vector (PROP_NAME, blob_to_string (PROP_VALUE)));\n"
"}\n"
"vectorbld_final (ret);\n"
"return ret;\n"
"}\n"
"--src DET_ResFilter.sql:592\n"
;

static const char *proc636 = 
"#line 614 \"[executable]/DET_ResFilter.sql\"\n"
"create function \"ResFilter_DAV_DIR_SINGLE\" (\n"
"in id any,\n"
"in what char(0),\n"
"in path any,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"\n"
"if (\'R\' <> what)\n"
"return -1;\n"
"\n"
"if (isarray (id[2]))\n"
"{\n"
"declare res any;\n"
"\n"
"res := call (cast (id[2][0] as varchar) || \'_DAV_DIR_SINGLE\') (id[2], what, path, auth_uid);\n"
"if (res = -1)\n"
"return res;\n"
"\n"
"res[0] := DAV_CONCAT_PATH (DAV_SEARCH_PATH (id[1], \'C\'), res[10]);\n"
"res[4] := id;\n"
"\n"
"return res;\n"
"}\n"
"for (select RES_FULL_PATH, RES_ID, length (RES_CONTENT) as clen, RES_MOD_TIME, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME as r1_RES_NAME\n"
"from WS.WS.SYS_DAV_RES r1\n"
"where RES_ID = id[2]) do\n"
"{\n"
"declare merged varchar;\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', r1_RES_NAME, 0))\n"
"{\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"}\n"
"else\n"
"{\n"
"declar