/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoFuture;

public class Driver
implements java.sql.Driver {
    protected static final int major = 3;
    protected static final int minor = 100;
    private String host = "localhost";
    private String port = "1111";
    private String user;
    private String password;
    private String database;
    private String charset;
    private String pwdclear;
    private Integer timeout;
    private Integer log_enable;
    private Integer fbs;
    private Integer sendbs;
    private Integer recvbs;
    private final String VirtPrefix = "jdbc:virtuoso://";

    public Driver() throws SQLException {
        try {
            String log_file = System.getProperty("JDBC3_LOG");
            if (log_file != null) {
                System.err.println("RPC logfile=" + log_file);
                try {
                    VirtuosoFuture.rpc_log = new PrintWriter(new FileOutputStream(log_file), true);
                }
                catch (Exception e) {
                    VirtuosoFuture.rpc_log = new PrintWriter(System.out, true);
                }
            }
        }
        catch (Exception e) {
            VirtuosoFuture.rpc_log = null;
        }
    }

    public Connection connect(String url, Properties info) throws VirtuosoException {
        try {
            if (this.acceptsURL(url)) {
                Properties props = this.urlToInfo(url, info);
                return new VirtuosoConnection(url, this.host, Integer.parseInt(this.port), props);
            }
        }
        catch (NumberFormatException e) {
            throw new VirtuosoException("Wrong port number : " + e.getMessage(), -11);
        }
        return null;
    }

    public boolean acceptsURL(String url) throws VirtuosoException {
        return url.startsWith("jdbc:virtuoso://");
    }

    protected Properties urlToInfo(String url, Properties _info) {
        this.host = "localhost";
        this.port = "1111";
        this.fbs = new Integer(100);
        this.sendbs = new Integer(32768);
        this.recvbs = new Integer(32768);
        Properties props = new Properties();
        Enumeration<?> en = _info.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String property = _info.getProperty(key);
            props.setProperty(key.toLowerCase(), property);
        }
        char inQuote = '\u0000';
        String attr = null;
        StringBuffer buff = new StringBuffer();
        String part = url.substring("jdbc:virtuoso://".length());
        boolean isFirst = true;
        block6: for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inQuote == c) {
                        inQuote = '\u0000';
                        continue block6;
                    }
                    if (inQuote != '\u0000') continue block6;
                    inQuote = c;
                    continue block6;
                }
                case '/': {
                    if (inQuote == '\u0000') {
                        String val = buff.toString().trim();
                        if (attr == null) {
                            attr = val;
                            val = "";
                        }
                        if (attr != null && attr.length() > 0) {
                            if (isFirst) {
                                isFirst = false;
                                props.setProperty("_vhost", attr);
                            } else {
                                props.setProperty(attr.toLowerCase(), val);
                            }
                        }
                        attr = null;
                        buff.setLength(0);
                        continue block6;
                    }
                    buff.append(c);
                    continue block6;
                }
                case '=': {
                    if (inQuote == '\u0000') {
                        attr = buff.toString().trim();
                        buff.setLength(0);
                        continue block6;
                    }
                    buff.append(c);
                    continue block6;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        String val = buff.toString().trim();
        if (attr == null) {
            attr = val;
            val = "";
        }
        if (attr != null && attr.length() > 0) {
            if (isFirst) {
                props.put("_vhost", attr);
            } else {
                props.put(attr.toLowerCase(), val);
            }
        }
        char fsep = System.getProperty("file.separator").charAt(0);
        val = props.getProperty("kpath");
        if (val != null && fsep != '\\') {
            val = val.replace('\\', fsep);
            props.put("kpath", val);
        }
        if ((val = props.getProperty("ts")) != null && fsep != '\\') {
            val = val.replace('\\', fsep);
            props.put("ts", val);
        }
        if ((val = props.getProperty("ssl")) != null) {
            props.setProperty("ssl", "1");
        }
        if ((val = props.getProperty("pwdtype")) != null) {
            props.setProperty("pwdclear", val);
        }
        if ((val = props.getProperty("uid")) != null) {
            props.setProperty("user", val);
        }
        if ((val = props.getProperty("pwd")) != null) {
            props.setProperty("password", val);
        }
        if ((val = props.getProperty("ts")) != null) {
            props.setProperty("truststorepath", val);
        }
        if ((val = props.getProperty("tspass")) != null) {
            props.setProperty("truststorepass", val);
        }
        if ((val = props.getProperty("kpath")) != null) {
            props.setProperty("keystorepath", val);
        }
        if ((val = props.getProperty("pass")) != null) {
            props.setProperty("keystorepass", val);
        }
        if ((val = props.getProperty("kpass")) != null) {
            props.setProperty("keystorepass", val);
        }
        return props;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws VirtuosoException {
        Vector<DriverPropertyInfo> pinfo = new Vector<DriverPropertyInfo>();
        if (this.acceptsURL(url)) {
            DriverPropertyInfo pr;
            if (info.get("user") == null) {
                pr = new DriverPropertyInfo("user", null);
                pr.required = true;
                pinfo.add(pr);
            }
            if (info.get("password") == null) {
                pr = new DriverPropertyInfo("password", null);
                pr.required = true;
                pinfo.add(pr);
            }
            if (info.get("database") == null) {
                pr = new DriverPropertyInfo("database", null);
                pr.required = false;
                pinfo.add(pr);
            }
            Object[] drv_info = new DriverPropertyInfo[pinfo.size()];
            pinfo.copyInto(drv_info);
            return drv_info;
        }
        DriverPropertyInfo pr = new DriverPropertyInfo("url", url);
        pr.required = true;
        pinfo.add(pr);
        if (info.get("user") == null) {
            pr = new DriverPropertyInfo("user", null);
            pr.required = true;
            pinfo.add(pr);
        }
        if (info.get("password") == null) {
            pr = new DriverPropertyInfo("password", null);
            pr.required = true;
            pinfo.add(pr);
        }
        if (info.get("database") == null) {
            pr = new DriverPropertyInfo("database", null);
            pr.required = false;
            pinfo.add(pr);
        }
        if (info.get("fbs") == null) {
            pr = new DriverPropertyInfo("fbs", null);
            pr.required = false;
            pinfo.add(pr);
        }
        if (info.get("sendbs") == null) {
            pr = new DriverPropertyInfo("sendbs", null);
            pr.required = false;
            pinfo.add(pr);
        }
        if (info.get("recvbs") == null) {
            pr = new DriverPropertyInfo("recvbs", null);
            pr.required = false;
            pinfo.add(pr);
        }
        if (info.get("roundrobin") == null) {
            pr = new DriverPropertyInfo("roundrobin", null);
            pr.required = false;
            pinfo.add(pr);
        }
        Object[] drv_info = new DriverPropertyInfo[pinfo.size()];
        pinfo.copyInto(drv_info);
        return drv_info;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 100;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void main(String[] args) {
        System.out.println("OpenLink Virtuoso(TM) Driver for JDBC(TM) Version 3.x [Build 3.100]");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

