/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import openlink.util.Vector;
import virtuoso.jdbc3.VirtuosoArray;
import virtuoso.jdbc3.VirtuosoBlob;
import virtuoso.jdbc3.VirtuosoCallableStatement;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoExplicitString;
import virtuoso.jdbc3.VirtuosoNullParameter;
import virtuoso.jdbc3.VirtuosoParameterMetaData;
import virtuoso.jdbc3.VirtuosoResultSet;
import virtuoso.jdbc3.VirtuosoStatement;
import virtuoso.jdbc3.VirtuosoTypes;

public class VirtuosoPreparedStatement
extends VirtuosoStatement
implements PreparedStatement {
    protected String sql;
    private static final int _EXECUTE_FAILED = -3;

    VirtuosoPreparedStatement(VirtuosoConnection connection, String sql) throws VirtuosoException {
        this(connection, sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtuosoPreparedStatement(VirtuosoConnection connection, String sql, int type, int concurrency) throws VirtuosoException {
        super(connection, type, concurrency);
        this.sparql_executed = sql.trim().regionMatches(true, 0, "sparql", 0, 6);
        VirtuosoConnection virtuosoConnection = connection;
        synchronized (virtuosoConnection) {
            try {
                this.sql = sql;
                this.parse_sql();
                Object[] args = new Object[]{this.statid == null ? (this.statid = new String("s" + connection.hashCode() + req_no++)) : this.statid, connection.escapeSQL(sql), new Long(0L), this.getStmtOpts()};
                this.future = connection.getFuture("PREP", args, this.rpc_timeout);
                this.vresultSet = new VirtuosoResultSet(this, this.metaData, true);
                this.result_opened = true;
                this.clearParameters();
            }
            catch (IOException e) {
                throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
            }
        }
    }

    private void parse_sql() {
        String sql = this.sql;
        int count = 0;
        do {
            int index;
            if ((index = sql.indexOf("?")) >= 0) {
                ++count;
                if ((sql = sql.substring(index + 1, sql.length())) != null) continue;
                sql = "";
                continue;
            }
            sql = "";
        } while (sql.length() != 0);
        this.parameters = new Vector(count);
        this.objparams = new Vector(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery() throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            Object[] args = new Object[6];
            Vector vect = new Vector(1);
            if (this.future != null) {
                this.connection.removeFuture(this.future);
                this.future = null;
            }
            args[0] = this.statid;
            args[2] = this.cursorName == null ? args[0] : this.cursorName;
            args[1] = null;
            args[3] = vect;
            args[4] = null;
            try {
                vect.addElement(this.objparams);
                args[5] = this.getStmtOpts();
                this.future = this.connection.getFuture("EXEC", args, this.rpc_timeout);
                this.vresultSet.isLastResult = false;
                this.vresultSet.getMoreResults(false);
                this.vresultSet.stmt_n_rows_to_get = this.prefetch;
                this.result_opened = true;
            }
            catch (IOException e) {
                throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
            }
        }
    }

    protected void setVector(int parameterIndex, Vector x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 2003);
        } else {
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void clearParameters() throws VirtuosoException {
        this.objparams.removeAllElements();
    }

    public boolean execute() throws VirtuosoException {
        this.exec_type = -1;
        this.sendQuery();
        return this.vresultSet.kindop() != 0;
    }

    public int executeUpdate() throws VirtuosoException {
        this.exec_type = 0;
        this.sendQuery();
        return this.vresultSet.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatchUpdate() throws BatchUpdateException {
        int size = this.batch.size();
        int[] res = new int[size];
        int inx = 0;
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            Object[] args = new Object[6];
            args[0] = this.statid;
            args[2] = this.cursorName == null ? args[0] : this.cursorName;
            args[1] = null;
            args[3] = this.batch;
            args[4] = null;
            try {
                if (this.future != null) {
                    this.connection.removeFuture(this.future);
                    this.future = null;
                }
                args[5] = this.getStmtOpts();
                this.future = this.connection.getFuture("EXEC", args, this.rpc_timeout);
                this.vresultSet.isLastResult = false;
                for (inx = 0; inx < size; ++inx) {
                    this.vresultSet.setUpdateCount(0);
                    this.vresultSet.getMoreResults(false);
                    res[inx] = -2;
                }
            }
            catch (IOException e) {
                this.throwBatchUpdateException(res, "Problem during serialization : " + e.getMessage(), inx);
            }
            catch (VirtuosoException e) {
                this.throwBatchUpdateException(res, e, inx);
            }
        }
        return res;
    }

    public ResultSet executeQuery() throws VirtuosoException {
        this.exec_type = 1;
        this.sendQuery();
        return this.vresultSet;
    }

    public ResultSetMetaData getMetaData() throws VirtuosoException {
        if (this.vresultSet != null) {
            return this.vresultSet.getMetaData();
        }
        throw new VirtuosoException("Prepared statement closed", -13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws VirtuosoException {
        if (this.close_flag) {
            return;
        }
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            try {
                this.close_flag = true;
                if (this.statid == null) {
                    return;
                }
                this.cancel();
                Object[] args = new Object[]{this.statid, new Long(1L)};
                this.future = this.connection.getFuture("FRST", args, this.rpc_timeout);
                this.future.nextResult();
                this.connection.removeFuture(this.future);
                this.future = null;
                this.result_opened = false;
            }
            catch (IOException e) {
                throw new VirtuosoException("Problem during closing : " + e.getMessage(), -3);
            }
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object _obj = this.objparams.elementAt(parameterIndex - 1);
        if (this.parameters != null && this.parameters.elementAt(parameterIndex - 1) instanceof Vector) {
            Vector pd = (Vector)this.parameters.elementAt(parameterIndex - 1);
            int dtp = ((Number)pd.elementAt(0)).intValue();
            if (dtp != 125 && dtp != 131 && dtp != 132) {
                throw new VirtuosoException("Passing streams to non-blob columns not supported", "IM001", -7);
            }
            if (dtp == 131) {
                throw new VirtuosoException("Passing ASCII stream to LONG VARBINARY columns not supported", "IM001", -7);
            }
        }
        if (_obj instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            try {
                ((VirtuosoBlob)_obj).setReader(new InputStreamReader(x, "ASCII"), length);
            }
            catch (UnsupportedEncodingException e) {
                ((VirtuosoBlob)_obj).setReader(new InputStreamReader(x), length);
            }
        } else if (x == null) {
            this.setNull(parameterIndex, 2005);
        } else {
            InputStreamReader rd;
            try {
                rd = new InputStreamReader(x, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                rd = new InputStreamReader(x);
            }
            VirtuosoBlob bl = new VirtuosoBlob(rd, (long)length, (long)(parameterIndex - 1));
            bl.setInputStream(x, length);
            this.objparams.setElementAt(bl, parameterIndex - 1);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 2);
        } else {
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object _obj = this.objparams.elementAt(parameterIndex - 1);
        if (this.parameters != null && this.parameters.elementAt(parameterIndex - 1) instanceof Vector) {
            Vector pd = (Vector)this.parameters.elementAt(parameterIndex - 1);
            int dtp = ((Number)pd.elementAt(0)).intValue();
            if (dtp != 125 && dtp != 131 && dtp != 132) {
                throw new VirtuosoException("Passing streams to non-blob columns not supported", "IM001", -7);
            }
            if (dtp == 132) {
                throw new VirtuosoException("Passing binary stream to LONG NVARCHAR columns not supported", "IM001", -7);
            }
        }
        if (_obj instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            try {
                ((VirtuosoBlob)_obj).setReader(new InputStreamReader(x, "8859_1"), length);
            }
            catch (UnsupportedEncodingException e) {
                ((VirtuosoBlob)_obj).setReader(new InputStreamReader(x), length);
            }
        } else if (x == null) {
            this.setNull(parameterIndex, 2004);
        } else {
            InputStreamReader rd;
            try {
                rd = new InputStreamReader(x, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                rd = new InputStreamReader(x);
            }
            VirtuosoBlob bl = new VirtuosoBlob(rd, (long)length, (long)(parameterIndex - 1));
            bl.setInputStream(x, length);
            this.objparams.setElementAt(bl, parameterIndex - 1);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object _obj = this.objparams.elementAt(parameterIndex - 1);
        if (this.parameters != null && this.parameters.elementAt(parameterIndex - 1) instanceof Vector) {
            Vector pd = (Vector)this.parameters.elementAt(parameterIndex - 1);
            int dtp = ((Number)pd.elementAt(0)).intValue();
            if (dtp != 125 && dtp != 131 && dtp != 132) {
                throw new VirtuosoException("Passing streams to non-blob columns not supported", "IM001", -7);
            }
            if (dtp == 131) {
                throw new VirtuosoException("Passing unicode stream to LONG VARBINARY columns not supported", "IM001", -7);
            }
        }
        if (_obj instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            try {
                ((VirtuosoBlob)_obj).setReader(new InputStreamReader(x, "UTF8"), length);
            }
            catch (UnsupportedEncodingException e) {
                ((VirtuosoBlob)_obj).setReader(new InputStreamReader(x), length);
            }
        } else if (x == null) {
            this.setNull(parameterIndex, 2005);
        } else {
            InputStreamReader rd;
            try {
                rd = new InputStreamReader(x, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                rd = new InputStreamReader(x);
            }
            VirtuosoBlob bl = new VirtuosoBlob(rd, (long)length, (long)(parameterIndex - 1));
            bl.setInputStream(x, length);
            this.objparams.setElementAt(bl, parameterIndex - 1);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Boolean(x), parameterIndex - 1);
    }

    public void setByte(int parameterIndex, byte x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Byte(x), parameterIndex - 1);
    }

    public void setBytes(int parameterIndex, byte[] x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, -3);
        } else {
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void setDate(int parameterIndex, Date x) throws VirtuosoException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDouble(int parameterIndex, double x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Double(x), parameterIndex - 1);
    }

    public void setFloat(int parameterIndex, float x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Float(x), parameterIndex - 1);
    }

    public void setInt(int parameterIndex, int x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Integer(x), parameterIndex - 1);
    }

    public void setLong(int parameterIndex, long x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Long(x), parameterIndex - 1);
    }

    public void setNull(int parameterIndex, int sqlType) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new VirtuosoNullParameter(sqlType, true), parameterIndex - 1);
    }

    public void setObject(int parameterIndex, Object x) throws VirtuosoException {
        this.setObject(parameterIndex, x, 1111);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws VirtuosoException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws VirtuosoException {
        if (x == null) {
            this.setNull(parameterIndex, 1111);
            return;
        }
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x instanceof VirtuosoExplicitString) {
            this.objparams.setElementAt(x, parameterIndex - 1);
            return;
        }
        Object _obj = this.objparams.elementAt(parameterIndex - 1);
        if (_obj instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setObject(x);
            return;
        }
        if ((x = VirtuosoTypes.mapJavaTypeToSqlType(x, targetSqlType, scale)) instanceof Serializable) {
            if (x instanceof String && this.parameters != null && this.parameters.elementAt(parameterIndex - 1) instanceof Vector) {
                Vector pd = (Vector)this.parameters.elementAt(parameterIndex - 1);
                int dtp = ((Number)pd.elementAt(0)).intValue();
                VirtuosoExplicitString ret = new VirtuosoExplicitString((String)x, dtp, this.connection);
                this.objparams.setElementAt(ret, parameterIndex - 1);
            } else {
                this.objparams.setElementAt(x, parameterIndex - 1);
            }
        } else {
            throw new VirtuosoException("Object " + x.getClass().getName() + " not serializable", "22023", -11);
        }
    }

    public void setShort(int parameterIndex, short x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Short(x), parameterIndex - 1);
    }

    public void setString(int parameterIndex, String x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else if (this.parameters != null && this.parameters.elementAt(parameterIndex - 1) instanceof Vector) {
            Vector pd = (Vector)this.parameters.elementAt(parameterIndex - 1);
            int dtp = ((Number)pd.elementAt(0)).intValue();
            VirtuosoExplicitString ret = new VirtuosoExplicitString(x, dtp, this.connection);
            this.objparams.setElementAt(ret, parameterIndex - 1);
        } else {
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    protected void setString(int parameterIndex, VirtuosoExplicitString x) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void setTime(int parameterIndex, Time x) throws VirtuosoException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws VirtuosoException {
        this.setTimestamp(parameterIndex, x, null);
    }

    public void addBatch() throws VirtuosoException {
        if (this.parameters == null) {
            return;
        }
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        this.batch.add(this.objparams.clone());
    }

    private void throwBatchUpdateException(int[] result, SQLException ex, int inx) throws BatchUpdateException {
        int[] _result = new int[inx + 1];
        System.arraycopy(result, 0, _result, 0, inx);
        _result[inx] = -3;
        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), _result);
    }

    private void throwBatchUpdateException(int[] result, String mess, int inx) throws BatchUpdateException {
        int[] _result = new int[inx + 1];
        System.arraycopy(result, 0, _result, 0, inx);
        _result[inx] = -3;
        throw new BatchUpdateException(mess, "HY000", 0, _result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws BatchUpdateException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] result = new int[this.batch.size()];
        boolean error = false;
        if (this instanceof VirtuosoCallableStatement && ((VirtuosoCallableStatement)this).hasOut()) {
            this.throwBatchUpdateException(result, "Batch can't execute calls with out params", 0);
        }
        try {
            if (this.vresultSet.kindop() == 1) {
                this.throwBatchUpdateException(result, "Batch executes only update statements", 0);
            }
            result = this.executeBatchUpdate();
        }
        catch (VirtuosoException ex) {
            this.throwBatchUpdateException(result, ex, 0);
        }
        finally {
            this.batch.clear();
        }
        return result;
    }

    public void setArray(int i, Array x) throws VirtuosoException {
        if (i < 1 || i > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + i + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(i, 2003);
        } else if (x instanceof VirtuosoArray) {
            this.objparams.setElementAt(((VirtuosoArray)x).data, i - 1);
        } else {
            this.objparams.setElementAt(x, i - 1);
        }
    }

    public void setBlob(int i, Blob x) throws VirtuosoException {
        if (i < 1 || i > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + i + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            this.objparams.setElementAt(x, i - 1);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws VirtuosoException {
        Object _obj;
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (this.parameters != null && this.parameters.elementAt(parameterIndex - 1) instanceof Vector) {
            Vector pd = (Vector)this.parameters.elementAt(parameterIndex - 1);
            int dtp = ((Number)pd.elementAt(0)).intValue();
            if (dtp != 125 && dtp != 131 && dtp != 132) {
                try {
                    int read;
                    StringBuffer buf = new StringBuffer();
                    char[] chars = new char[4096];
                    int total_read = 0;
                    do {
                        int to_read;
                        if ((read = x.read(chars, 0, to_read = length - total_read > chars.length ? chars.length : length - total_read)) <= 0) continue;
                        buf.append(chars, 0, read);
                        total_read += read;
                    } while (read > 0 && total_read < length);
                    String ret = buf.toString();
                    if (this.connection.charset != null) {
                        this.objparams.setElementAt(new VirtuosoExplicitString(this.connection.charsetBytes(ret), 182), parameterIndex - 1);
                    } else {
                        this.objparams.setElementAt(ret, parameterIndex - 1);
                    }
                    return;
                }
                catch (IOException e) {
                    throw new VirtuosoException("Error reading from a character stream " + e.getMessage(), -3);
                }
            }
            if (dtp == 131) {
                throw new VirtuosoException("Passing character stream to LONG VARBINARY columns not supported", "IM001", -7);
            }
        }
        if ((_obj = this.objparams.elementAt(parameterIndex - 1)) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setReader(x, length);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 2004);
        } else {
            this.objparams.setElementAt(new VirtuosoBlob(x, (long)length, (long)(parameterIndex - 1)), parameterIndex - 1);
        }
    }

    public void setClob(int i, Clob x) throws VirtuosoException {
        if (i < 1 || i > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + i + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(i, 2005);
        } else {
            this.objparams.setElementAt(x, i - 1);
        }
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws VirtuosoException {
        this.setNull(paramIndex, sqlType);
    }

    public void setRef(int i, Ref x) throws VirtuosoException {
        if (i < 1 || i > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + i + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(i, 2006);
        } else {
            this.objparams.setElementAt(x, i - 1);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            if (cal != null) {
                x = new Date(VirtuosoTypes.timeFromCal(x, cal));
            }
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            if (cal != null) {
                x = new Time(VirtuosoTypes.timeFromCal(x, cal));
            }
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            if (cal != null) {
                int nanos = x.getNanos();
                x = new Timestamp(VirtuosoTypes.timeFromCal(x, cal));
                x.setNanos(nanos);
            }
            this.objparams.setElementAt(x, parameterIndex - 1);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.paramsMetaData == null ? new VirtuosoParameterMetaData(null, this.connection) : this.paramsMetaData;
    }

    protected synchronized void setClosed(boolean flag) {
        this.close_flag = flag;
    }
}

