/*
 * Decompiled with CFR 0.152.
 */
package openlink.util;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import openlink.util.OPLMessage_u;

public class OPLHeapClob
implements Clob,
Serializable {
    static final long serialVersionUID = 6296947263965593908L;
    private char[] blobData = null;
    private long blobLength = 0L;
    private static final int buf_size = 32768;
    private Object lck = this;

    public OPLHeapClob() {
        this.blobData = new char[1];
    }

    public OPLHeapClob(String b) {
        this.blobData = b.toCharArray();
        this.blobLength = this.blobData.length;
    }

    public OPLHeapClob(char[] b) {
        this.blobData = new char[b.length];
        System.arraycopy(b, 0, this.blobData, 0, b.length);
        this.blobLength = b.length;
    }

    public OPLHeapClob(Reader is) throws SQLException {
        try {
            CharArrayWriter out = new CharArrayWriter(32768);
            BufferedReader in = new BufferedReader(is, 32768);
            char[] tmp = new char[32768];
            int sz = in.read(tmp, 0, 32768);
            while (sz != -1) {
                out.write(tmp, 0, sz);
                sz = in.read(tmp, 0, 32768);
            }
            this.blobData = out.toCharArray();
            this.blobLength = this.blobData.length;
        }
        catch (IOException e) {
            throw OPLMessage_u.makeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            return this.blobLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long pos, int len) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (--pos >= this.blobLength) {
                throw OPLMessage_u.makeException(2);
            }
            if ((long)len > this.blobLength - pos) {
                len = (int)(this.blobLength - pos);
            }
            return new String(this.blobData, (int)pos, len);
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.ensureOpen();
        return new BlobInputReader(this.lck);
    }

    public InputStream getAsciiStream() throws SQLException {
        this.ensureOpen();
        return new BlobInputStream(this.getCharacterStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String searchstr, long start) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (start < 1L) {
                throw OPLMessage_u.makeException(2);
            }
            if (--start > this.blobLength) {
                return -1L;
            }
            int i = (int)start;
            while ((long)i < this.blobLength && (long)searchstr.length() <= this.blobLength - (long)i) {
                if (this.blobData[i] == searchstr.charAt(0)) {
                    boolean match = true;
                    for (int j = 1; j < searchstr.length(); ++j) {
                        if (this.blobData[i + j] == searchstr.charAt(j)) continue;
                        match = false;
                        break;
                    }
                    if (match) {
                        return i + 1;
                    }
                }
                ++i;
            }
        }
        return -1L;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        this.ensureOpen();
        if (start < 1L) {
            throw OPLMessage_u.makeException(2);
        }
        return this.position(searchstr.getSubString(0L, (int)searchstr.length()), start);
    }

    public int setString(long pos, String str) throws SQLException {
        this.ensureOpen();
        return this.setString(pos, str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            BlobOutputWriter os = new BlobOutputWriter(this.lck, pos);
            try {
                ((Writer)os).write(str, offset, len);
            }
            catch (IOException e) {
                OPLMessage_u.makeException(e);
            }
        }
        return len;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.ensureOpen();
        return new BlobOutputStream(new BlobOutputWriter(this.lck, pos));
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.ensureOpen();
        return new BlobOutputWriter(this.lck, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long len) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            int newLen = (int)len;
            if (newLen < 0 || newLen > this.blobData.length) {
                throw OPLMessage_u.makeException(3);
            }
            if (newLen < this.blobData.length) {
                char[] newbuf = new char[newLen];
                System.arraycopy(this.blobData, 0, newbuf, 0, newLen);
                this.blobData = newbuf;
            }
            this.blobLength = len;
        }
    }

    private void ensureOpen() throws SQLException {
        if (this.blobData == null) {
            throw OPLMessage_u.makeException(4);
        }
    }

    static /* synthetic */ char[] access$002(OPLHeapClob x0, char[] x1) {
        x0.blobData = x1;
        return x1;
    }

    protected class BlobOutputStream
    extends OutputStream {
        private Writer out;
        private boolean isClosed = false;

        protected BlobOutputStream(Writer out) {
            this.out = out;
        }

        public synchronized void write(int b) throws IOException {
            this.ensureOpen();
            byte[] tmp = new byte[]{(byte)b};
            this.out.write(new String(tmp));
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            if (len == 0) {
                return;
            }
            this.out.write(new String(b, off, len));
        }

        public void close() throws IOException {
            this.isClosed = true;
            this.out.close();
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }

    protected class BlobOutputWriter
    extends Writer {
        protected int count;
        private boolean isClosed;

        protected BlobOutputWriter(Object lck, long pos) {
            super(lck);
            this.isClosed = false;
            this.count = (int)pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int c) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                int newcount = this.count + 1;
                if (newcount > OPLHeapClob.this.blobData.length) {
                    char[] newbuf = new char[Math.max(OPLHeapClob.this.blobData.length + 32768, newcount)];
                    System.arraycopy(OPLHeapClob.this.blobData, 0, newbuf, 0, this.count);
                    OPLHeapClob.access$002(OPLHeapClob.this, newbuf);
                }
                ((OPLHeapClob)OPLHeapClob.this).blobData[this.count] = (char)c;
                this.count = newcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(char[] c, int off, int len) throws IOException {
            this.ensureOpen();
            if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                int newcount = this.count + len;
                if (newcount > OPLHeapClob.this.blobData.length) {
                    char[] newbuf = new char[Math.max(OPLHeapClob.this.blobData.length + 32768, newcount)];
                    System.arraycopy(OPLHeapClob.this.blobData, 0, newbuf, 0, this.count);
                    OPLHeapClob.access$002(OPLHeapClob.this, newbuf);
                }
                System.arraycopy(c, off, OPLHeapClob.this.blobData, this.count, len);
                this.count = newcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String str, int off, int len) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                int newcount = this.count + len;
                if (newcount > OPLHeapClob.this.blobData.length) {
                    char[] newbuf = new char[Math.max(OPLHeapClob.this.blobData.length + 32768, newcount)];
                    System.arraycopy(OPLHeapClob.this.blobData, 0, newbuf, 0, this.count);
                    OPLHeapClob.access$002(OPLHeapClob.this, newbuf);
                }
                str.getChars(off, off + len, OPLHeapClob.this.blobData, this.count);
                this.count = newcount;
            }
        }

        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }

    protected class BlobInputStream
    extends InputStream {
        private static final int defBufSize = 32;
        private byte[] buf = new byte[32];
        private char[] cbuf = new char[8];
        private int pos = 0;
        private int count = 0;
        private Reader in;

        BlobInputStream(Reader in) {
            this.in = in;
        }

        private void ensureOpen() throws IOException {
            if (this.in == null || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int cnt = this.in.read(this.cbuf);
            if (cnt == -1) {
                return;
            }
            byte[] tmp = new String(this.cbuf).getBytes();
            System.arraycopy(tmp, 0, this.buf, 0, tmp.length);
            this.count = tmp.length;
        }

        public synchronized int read() throws IOException {
            this.ensureOpen();
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        private int read1(byte[] b, int off, int len) throws IOException {
            int avail = this.count - this.pos;
            if (avail <= 0) {
                this.fill();
                avail = this.count - this.pos;
                if (avail <= 0) {
                    return -1;
                }
            }
            int cnt = avail < len ? avail : len;
            System.arraycopy(this.buf, this.pos, b, off, cnt);
            this.pos += cnt;
            return cnt;
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int n1;
            this.ensureOpen();
            if ((off | len | off + len | b.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = this.read1(b, off, len);
            if (n <= 0) {
                return n;
            }
            while (n < len && (n1 = this.read1(b, off + n, len - n)) > 0) {
                n += n1;
            }
            return n;
        }

        public synchronized int available() throws IOException {
            this.ensureOpen();
            return this.count - this.pos;
        }

        public synchronized void close() throws IOException {
            this.buf = null;
            this.cbuf = null;
            this.in.close();
            this.in = null;
        }
    }

    protected class BlobInputReader
    extends Reader {
        private boolean isClosed;
        private int pos;
        private long length;

        protected BlobInputReader(Object lck) {
            super(lck);
            this.isClosed = false;
            this.pos = 0;
            this.length = 0L;
            this.length = OPLHeapClob.this.blobData.length;
        }

        protected BlobInputReader(Object lck, long pos, long length) {
            super(lck);
            this.isClosed = false;
            this.pos = 0;
            this.length = 0L;
            this.pos = (int)pos;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return (long)this.pos < this.length ? OPLHeapClob.this.blobData[this.pos++] : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] b, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if ((long)this.pos >= this.length) {
                    return -1;
                }
                if ((long)(this.pos + len) > this.length) {
                    len = (int)(this.length - (long)this.pos);
                }
                if (len <= 0) {
                    return 0;
                }
                System.arraycopy(OPLHeapClob.this.blobData, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized long skip(long n) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if ((long)this.pos + n > this.length) {
                    n = this.length - (long)this.pos;
                }
                if (n < 0L) {
                    return 0L;
                }
                this.pos = (int)((long)this.pos + n);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return true;
            }
        }

        public void close() {
            this.isClosed = true;
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }
}

