/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.net.Socket;
import java.util.GregorianCalendar;
import openlink.util.Vector;
import openlink.util.VectorOfDouble;
import openlink.util.VectorOfFloat;
import openlink.util.VectorOfLong;
import virtuoso.jdbc4.DateObject;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoExtendedString;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoPoint;
import virtuoso.jdbc4.VirtuosoRdfBox;

class VirtuosoInputStream
extends BufferedInputStream {
    private VirtuosoConnection connection;
    private byte[] tmp = new byte[16];
    private static final int DefaultBufferSize = 2048;

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            throw new IOException("Connection to the server lost");
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c = super.read(b, off, len);
        if (c == -1) {
            throw new IOException("Connection to the server lost");
        }
        return c;
    }

    VirtuosoInputStream(VirtuosoConnection connection, InputStream input) throws IOException {
        this(connection, input, 2048);
    }

    VirtuosoInputStream(VirtuosoConnection connection, InputStream input, int size) throws IOException {
        super(input, size);
        this.connection = connection;
    }

    VirtuosoInputStream(VirtuosoConnection connection, Socket input) throws IOException {
        this(connection, input.getInputStream());
    }

    VirtuosoInputStream(VirtuosoConnection connection, Socket input, int size) throws IOException {
        this(connection, input.getInputStream(), size);
    }

    protected boolean isClosed() {
        return this.in == null;
    }

    protected Object read_object() throws IOException, EOFException, VirtuosoException {
        int tag = this.read();
        try {
            switch (tag) {
                case 180: {
                    return new Short(0);
                }
                case 204: {
                    return null;
                }
                case 193: 
                case 196: {
                    int n = this.readint();
                    Object[] array = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = this.read_object();
                    }
                    Vector res = new Vector(array);
                    return res;
                }
                case 209: {
                    int n = this.readint();
                    Object[] array = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = new Long(this.readlongint());
                    }
                    VectorOfLong res = new VectorOfLong(array);
                    return res;
                }
                case 194: {
                    int n = this.readint();
                    Object[] array = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = new Long(this.readlongint());
                    }
                    VectorOfLong res = new VectorOfLong(array);
                    return res;
                }
                case 195: {
                    int n = this.readint();
                    Object[] array = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = new Double(this.readdouble());
                    }
                    VectorOfDouble res = new VectorOfDouble(array);
                    return res;
                }
                case 202: {
                    int n = this.readint();
                    Object[] array = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = new Float(this.readfloat());
                    }
                    VectorOfFloat res = new VectorOfFloat(array);
                    return res;
                }
                case 226: {
                    int n = this.readlongint();
                    byte[] array = new byte[n];
                    for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                    }
                    return this.convByte2UTF(array);
                }
                case 225: {
                    int n = this.readshortint();
                    byte[] array = new byte[n];
                    for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                    }
                    return this.convByte2UTF(array);
                }
                case 182: 
                case 183: 
                case 187: {
                    int n = this.readlongint();
                    byte[] array = new byte[n];
                    for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                    }
                    if (this.connection.charset_utf8) {
                        return this.convByte2UTF(array);
                    }
                    return this.convByte2Ascii(array);
                }
                case 207: {
                    int flags = this.readlongint();
                    Object str = this.read_object();
                    VirtuosoExtendedString res = new VirtuosoExtendedString((String)str, flags);
                    return res;
                }
                case 223: {
                    int n = this.readlongint();
                    byte[] array = new byte[n];
                    for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                    }
                    return array;
                }
                case 181: 
                case 184: 
                case 186: {
                    int n = this.readshortint();
                    byte[] array = new byte[n];
                    for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                    }
                    if (this.connection.charset_utf8) {
                        return this.convByte2UTF(array);
                    }
                    return this.convByte2Ascii(array);
                }
                case 222: {
                    int n = this.readshortint();
                    byte[] array = new byte[n];
                    for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                    }
                    return array;
                }
                case 190: {
                    Float res = new Float(this.readfloat());
                    return res;
                }
                case 191: {
                    Double res = new Double(this.readdouble());
                    return res;
                }
                case 188: {
                    int ret = this.readshortint();
                    if (ret > 127) {
                        ret -= 256;
                    }
                    Short res = new Short((short)ret);
                    return res;
                }
                case 189: {
                    Integer res = new Integer(this.readlongint());
                    return res;
                }
                case 128: 
                case 129: 
                case 208: 
                case 210: 
                case 211: {
                    Object res = this.readDate(tag);
                    return res;
                }
                case 126: 
                case 133: {
                    VirtuosoBlob res = new VirtuosoBlob(this.connection, this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.read_object(), tag);
                    return res;
                }
                case 219: {
                    BigDecimal res = this.readNumeric();
                    return res;
                }
                case 254: {
                    Object res = this.readObject();
                    return res;
                }
                case 185: {
                    int flags = this.read();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    while (true) {
                        int n;
                        int part_tag;
                        if ((part_tag = this.read()) != 182 && part_tag != 181) {
                            throw new VirtuosoException("Invalid data (tag=" + part_tag + ") in deserializing a string session", "42000", -9);
                        }
                        int n2 = n = part_tag == 182 ? this.readlongint() : this.read();
                        if (n <= 0) break;
                        byte[] array = new byte[n];
                        for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                        }
                        os.write(array, 0, n);
                    }
                    String res = os.toString((flags & 1) != 0 ? "UTF-8" : "8859_1");
                    return res;
                }
                case 243: {
                    Integer res = new Integer(this.readlongint());
                    return res;
                }
                case 244: 
                case 247: {
                    Long res = new Long(this.readlong());
                    return res;
                }
                case 246: {
                    VirtuosoRdfBox res = this.readRdfBox();
                    return res;
                }
            }
            throw new VirtuosoException("Tag " + tag + " not defined.", -9);
        }
        catch (ClassCastException e) {
            if (VirtuosoFuture.rpc_log != null) {
                VirtuosoFuture.rpc_log.println("  **(conn " + this.connection.hashCode() + ") **** runtime " + e.getClass().getName() + " encountered while reading tag " + tag);
                e.printStackTrace(VirtuosoFuture.rpc_log);
            }
            throw new VirtuosoException(e.getClass().getName() + ":" + e.getMessage(), -3);
        }
    }

    private final String convByte2UTF(byte[] data) throws IOException {
        int c;
        int count;
        int utflen = data.length;
        char[] c_arr = new char[utflen];
        int bad_char = 63;
        int ch_count = 0;
        for (count = 0; count < utflen && (c = data[count] & 0xFF) <= 127; ++count) {
            c_arr[ch_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = data[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    c_arr[ch_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        c_arr[ch_count++] = (char)c;
                        continue block6;
                    }
                    byte c2 = data[count - 1];
                    if ((c2 & 0xC0) != 128) {
                        c_arr[ch_count++] = bad_char;
                        continue block6;
                    }
                    c_arr[ch_count++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        c_arr[ch_count++] = (char)c;
                        continue block6;
                    }
                    byte c2 = data[count - 2];
                    byte c3 = data[count - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        c_arr[ch_count++] = bad_char;
                        continue block6;
                    }
                    c_arr[ch_count++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                    continue block6;
                }
            }
            ++count;
            c_arr[ch_count++] = bad_char;
        }
        return new String(c_arr, 0, ch_count);
    }

    private final String convByte2Ascii(byte[] data) throws IOException {
        int len = data.length;
        char[] c_arr = new char[len];
        for (int i = 0; i < len; ++i) {
            c_arr[i] = (char)(data[i] & 0xFF);
        }
        return new String(c_arr, 0, len);
    }

    private int readint() throws IOException {
        return this.read() == 188 ? this.readshortint() : this.readlongint();
    }

    private int readshortint() throws IOException {
        return this.read();
    }

    private short readshort() throws IOException {
        for (int i = this.read(this.tmp, 0, 2); i != 2; i += this.read(this.tmp, i, 2 - i)) {
        }
        int retVal = (this.tmp[0] & 0xFF) << 8;
        return (short)(retVal | this.tmp[1] & 0xFF);
    }

    private int readlongint() throws IOException {
        for (int i = this.read(this.tmp, 0, 4); i != 4; i += this.read(this.tmp, i, 4 - i)) {
        }
        int retVal = (this.tmp[0] & 0xFF) << 24;
        retVal |= (this.tmp[1] & 0xFF) << 16;
        return (retVal |= (this.tmp[2] & 0xFF) << 8) | this.tmp[3] & 0xFF;
    }

    private long readlong() throws IOException {
        for (int i = this.read(this.tmp, 0, 8); i != 8; i += this.read(this.tmp, i, 8 - i)) {
        }
        long retVal = ((long)this.tmp[0] & 0xFFL) << 56;
        retVal |= ((long)this.tmp[1] & 0xFFL) << 48;
        retVal |= ((long)this.tmp[2] & 0xFFL) << 40;
        retVal |= ((long)this.tmp[3] & 0xFFL) << 32;
        retVal |= ((long)this.tmp[4] & 0xFFL) << 24;
        retVal |= ((long)this.tmp[5] & 0xFFL) << 16;
        return (retVal |= ((long)this.tmp[6] & 0xFFL) << 8) | (long)this.tmp[7] & 0xFFL;
    }

    private float readfloat() throws IOException {
        return Float.intBitsToFloat(this.readlongint());
    }

    private double readdouble() throws IOException {
        return Double.longBitsToDouble(this.readlong());
    }

    private BigDecimal readNumeric() throws IOException, VirtuosoException {
        int n = this.readshortint();
        int i = 0;
        byte[] array = new byte[n + 2];
        byte[] dp = new byte[n << 1];
        if (array != null && dp != null) {
            array[0] = -37;
            array[1] = (byte)n;
            for (int inx = this.read(array, 2, n); inx != n; inx += this.read(array, inx + 2, n - inx)) {
            }
        } else {
            return null;
        }
        dp[0] = 48;
        int len = array[3] << 1;
        int scale = array[1] - array[3] - 2 << 1;
        boolean isneg = (array[2] & 1) == 1;
        boolean isinvalid = (array[2] & 0x18) == 24;
        switch (array[2] & 0x18) {
            case 8: {
                return new BigDecimal(Double.NaN);
            }
            case 16: {
                if (isneg) {
                    return new BigDecimal(Double.NEGATIVE_INFINITY);
                }
                return new BigDecimal(Double.POSITIVE_INFINITY);
            }
        }
        int rp = 4;
        int ep = 2 + array[1];
        if ((array[2] & 4) == 4) {
            dp[i++] = (byte)((array[rp++] & 0xF) + 48);
            --len;
        }
        if ((array[2] & 2) == 2) {
            --scale;
        }
        while (rp < ep) {
            if (i == len) {
                dp[i++] = 46;
            }
            dp[i++] = (byte)((array[rp] >> 4 & 0xF) + 48);
            if (i == len) {
                dp[i++] = 46;
            }
            dp[i++] = (byte)((array[rp++] & 0xF) + 48);
        }
        BigDecimal bd = new BigDecimal((isneg ? "-" : "") + new String(dp, 0, rp != 4 ? i - ((array[2] & 2) == 2 ? 1 : 0) : 1));
        return bd;
    }

    private VirtuosoRdfBox readRdfBox() throws IOException, VirtuosoException {
        int flags = this.read();
        Object box = null;
        short type = 257;
        int lang = 257;
        boolean is_complete = false;
        long ro_id = 0L;
        boolean id_only = false;
        if (0 != (flags & 0x80)) {
            int ID_ONLY = 12;
            if ((flags & ID_ONLY) == ID_ONLY) {
                id_only = true;
            } else if ((flags & 4) != 0) {
                lang = this.readshort();
            } else {
                type = this.readshort();
            }
            ro_id = 0 != (flags & 0x20) ? this.readlong() : (long)this.readlongint();
            if (0 != (flags & 2)) {
                is_complete = true;
                box = this.read_object();
                if (type == 256 && box instanceof String && ((String)box).length() > 5 && ((String)box).substring(0, 5).equalsIgnoreCase("point")) {
                    String data = ((String)box).substring(6);
                    try {
                        box = new VirtuosoPoint(data.substring(0, data.length() - 1));
                    }
                    catch (Exception e) {
                        throw new VirtuosoException(e, -3);
                    }
                }
            }
        } else {
            if (0 != (flags & 0x10)) {
                throw new VirtuosoException("Invalid rdf box received", "42000", -17);
            }
            if (0 != (flags & 0x40)) {
                int n = this.readshortint();
                byte[] array = new byte[n];
                for (int i = this.read(array, 0, n); i != n; i += this.read(array, i, n - i)) {
                }
                box = this.connection.charset_utf8 ? this.convByte2UTF(array) : this.convByte2Ascii(array);
            } else {
                box = this.read_object();
            }
            if (0 != (flags & 1)) {
                ro_id = 0 != (flags & 0x20) ? this.readlong() : (long)this.readlongint();
            }
            if (0 != (flags & 2)) {
                is_complete = true;
            }
            type = 0 != (flags & 8) ? (short)this.readshort() : (short)257;
            lang = 0 != (flags & 4) ? (int)this.readshort() : 257;
        }
        VirtuosoRdfBox rb = new VirtuosoRdfBox(this.connection, box, is_complete, id_only, type, (short)lang, ro_id);
        return rb;
    }

    private Object readObject() throws IOException, VirtuosoException {
        int obj_id = this.readlongint();
        Object obj = this.read_object();
        if (obj instanceof String) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(((String)obj).getBytes("8859_1"));
                ObjectInputStream ois = new ObjectInputStream(bis);
                obj = ois.readObject();
            }
            catch (Exception e) {
                obj = null;
            }
        }
        return obj;
    }

    private Object readDate(int tag) throws IOException {
        int tz_interm;
        GregorianCalendar cal_dat = new GregorianCalendar();
        int d0 = this.read();
        int day = d0 << 16 | this.read() << 8 | this.read();
        int hour = this.read();
        int temp = this.read();
        int minute = temp >> 2;
        int n = (temp & 3) << 4;
        temp = this.read();
        int second = n | temp >> 4;
        int fraction = (temp & 0xF) << 16 | this.read() << 8 | this.read();
        int[] tz_bytes = new int[2];
        day |= (d0 & 0x80) != 0 ? -16777216 : 0;
        int tzless = hour >> 7;
        hour &= 0x1F;
        tz_bytes[0] = this.read();
        tz_bytes[1] = this.read();
        int tz = (tz_bytes[0] & 7) << 8 | tz_bytes[1];
        int type = tz_bytes[0] >> 5;
        if ((tz_bytes[0] & 4) != 0) {
            tz_interm = tz_bytes[0] & 7;
            tz_interm |= 0xF8;
        } else {
            tz_interm = tz_bytes[0] & 3;
        }
        tz = tz_interm << 8 | tz_bytes[1];
        if (tz > Short.MAX_VALUE) {
            tz -= 65536;
        }
        return new DateObject(day, hour, minute, second, fraction, tz, type);
    }
}

