/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import openlink.util.OPLHeapClob;
import openlink.util.OPLHeapNClob;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoNullParameter;
import virtuoso.jdbc4.VirtuosoPreparedStatement;
import virtuoso.jdbc4.VirtuosoTypes;

public class VirtuosoCallableStatement
extends VirtuosoPreparedStatement
implements CallableStatement {
    private boolean _wasNull = false;
    private boolean _hasOut = false;
    protected int[] param_type = new int[this.parameters.capacity()];
    protected int[] param_scale = new int[this.parameters.capacity()];

    VirtuosoCallableStatement(VirtuosoConnection connection, String sql) throws VirtuosoException {
        this(connection, sql, 1003, 1007);
    }

    VirtuosoCallableStatement(VirtuosoConnection connection, String sql, int type, int concurrency) throws VirtuosoException {
        super(connection, sql, type, concurrency);
        for (int i = 0; i < this.param_type.length; ++i) {
            this.param_type[i] = 1111;
            this.param_scale[i] = 0;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws VirtuosoException {
        this.registerOutParameter(parameterIndex, sqlType, 0);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws VirtuosoException {
        this._hasOut = true;
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.param_type[parameterIndex - 1] = sqlType;
        this.param_scale[parameterIndex - 1] = scale;
        switch (sqlType) {
            case 2002: 
            case 2003: {
                return;
            }
            case -5: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Long(Long.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                return;
            }
            case -7: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Boolean(false), parameterIndex - 1);
                }
                return;
            }
            case 2004: 
            case 2005: {
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new String(), parameterIndex - 1);
                }
                return;
            }
            case 91: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Date(0L), parameterIndex - 1);
                }
                return;
            }
            case 92: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Time(0L), parameterIndex - 1);
                }
                return;
            }
            case 93: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Timestamp(0L), parameterIndex - 1);
                }
                return;
            }
            case 2: 
            case 3: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new BigDecimal(0.0).setScale(scale), parameterIndex - 1);
                }
                return;
            }
            case 6: 
            case 8: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Double(Double.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case 1111: 
            case 2000: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Object(), parameterIndex - 1);
                }
                return;
            }
            case 0: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new VirtuosoNullParameter(sqlType, true), parameterIndex - 1);
                }
                return;
            }
            case 7: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Float(Float.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case 5: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Short(Short.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case -6: 
            case 4: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Integer(Integer.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
        }
    }

    @Override
    public boolean wasNull() throws VirtuosoException {
        return this._wasNull;
    }

    public boolean hasOut() {
        return this._hasOut;
    }

    @Override
    public String getString(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        boolean bl = this._wasNull = obj == null;
        if (this._wasNull) {
            return false;
        }
        Number nret = (Number)obj;
        return nret.intValue() != 0;
    }

    @Override
    public byte getByte(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)obj).byteValue();
    }

    @Override
    public short getShort(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)obj).shortValue();
    }

    @Override
    public int getInt(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)obj).intValue();
    }

    @Override
    public long getLong(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0L;
        }
        return ((Number)obj).longValue();
    }

    @Override
    public float getFloat(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0.0f;
        }
        return ((Number)obj).floatValue();
    }

    @Override
    public double getDouble(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0.0;
        }
        return ((Number)obj).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws VirtuosoException {
        BigDecimal ret = this.getBigDecimal(parameterIndex);
        if (ret != null) {
            ret = ret.setScale(scale);
        }
        return ret;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (byte[])obj;
    }

    @Override
    public Date getDate(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 91, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (Date)obj;
    }

    @Override
    public Time getTime(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 92, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (Time)obj;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 93, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (Timestamp)obj;
    }

    @Override
    public Object getObject(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        return obj;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 3, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (BigDecimal)obj;
    }

    public Object getObject(int parameterIndex, Map map) throws VirtuosoException {
        return this.getObject(parameterIndex);
    }

    @Override
    public Ref getRef(int parameterIndex) throws VirtuosoException {
        throw new VirtuosoException("REF not supported", -7);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this._wasNull = this.objparams.elementAt(parameterIndex - 1) == null;
        if (this._wasNull) {
            return null;
        }
        return (Blob)this.objparams.elementAt(parameterIndex - 1);
    }

    @Override
    public Clob getClob(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this._wasNull = this.objparams.elementAt(parameterIndex - 1) == null;
        if (this._wasNull) {
            return null;
        }
        return (Clob)this.objparams.elementAt(parameterIndex - 1);
    }

    @Override
    public Array getArray(int parameterIndex) throws VirtuosoException {
        throw new VirtuosoException("ARRAY not supported", -7);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws VirtuosoException {
        Date date = this.getDate(parameterIndex);
        if (cal != null && date != null) {
            date = new Date(VirtuosoTypes.timeToCal(date, cal));
        }
        return date;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws VirtuosoException {
        Time _time = this.getTime(parameterIndex);
        if (cal != null && _time != null) {
            _time = new Time(VirtuosoTypes.timeToCal(_time, cal));
        }
        return _time;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp val;
        Timestamp _ts = val = this.getTimestamp(parameterIndex);
        if (cal != null && _ts != null) {
            _ts = new Timestamp(VirtuosoTypes.timeToCal(_ts, cal));
        }
        if (_ts != null) {
            _ts.setNanos(val.getNanos());
        }
        return _ts;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws VirtuosoException {
        throw new VirtuosoException("UDTs not supported", -7);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    private int findParam(String paramName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw new VirtuosoException("Method 'getRowId(parameterIndex)' not yet implemented", -7);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new VirtuosoException("Method 'getRowId(parameterName)' not yet implemented", -7);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new VirtuosoException("Method 'setRowId(parameterName, x)' not yet implemented", -7);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setNString(this.findParam(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(this.findParam(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setNClob(this.findParam(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.findParam(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.findParam(parameterName), inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setNClob(this.findParam(parameterName), reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return new OPLHeapNClob(this.getString(parameterIndex));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.findParam(parameterName));
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new VirtuosoException("Method 'setSQLXML(parameterName, xmlObject)' not yet implemented", -7);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new VirtuosoException("Method 'getSQLXML(int parameterIndex)' not yet implemented", -7);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new VirtuosoException("Method 'getSQLXML(String parameterName)' not yet implemented", -7);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findParam(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return new OPLHeapNClob(this.getNString(parameterIndex)).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findParam(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return new OPLHeapClob(this.getString(parameterIndex)).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findParam(parameterName));
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParam(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.findParam(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.findParam(parameterName), x, (int)length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.findParam(parameterName), x, (int)length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.findParam(parameterName), reader, (int)length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new VirtuosoException("Method 'setAsciiStream(parameterName, x)' not yet implemented", -7);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new VirtuosoException("Method 'setBinaryStream(parameterName, x)' not yet implemented", -7);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new VirtuosoException("Method 'setCharacterStream(parameterName, reader)' not yet implemented", -7);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new VirtuosoException("Method 'setNCharacterStream(parameterName, value)' not yet implemented", -7);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new VirtuosoException("Method 'setClob(parameterName, reader)' not yet implemented", -7);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new VirtuosoException("Method 'setBlob(parameterName, inputStream)' not yet implemented", -7);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new VirtuosoException("Method 'setNClob(parameterName, reader)' not yet implemented", -7);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new VirtuosoException("Type parameter can not be null", "S1009", -4);
        }
        if (type.equals(String.class)) {
            return (T)this.getString(parameterIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(parameterIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(parameterIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(parameterIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(parameterIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(parameterIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(parameterIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(parameterIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(parameterIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(parameterIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(parameterIndex);
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob(parameterIndex);
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob(parameterIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(parameterIndex);
        }
        if (type.equals(Ref.class)) {
            return (T)this.getRef(parameterIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(parameterIndex);
        }
        try {
            return (T)this.getObject(parameterIndex);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Conversion not supported for type " + type.getName(), "S1009", -4);
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findParam(parameterName), type);
    }
}

