/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import openlink.util.Vector;
import virtuoso.jdbc3.DateObject;
import virtuoso.jdbc3.VirtuosoBlob;
import virtuoso.jdbc3.VirtuosoCallableStatement;
import virtuoso.jdbc3.VirtuosoColumn;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoExplicitString;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoParameterMetaData;
import virtuoso.jdbc3.VirtuosoPreparedStatement;
import virtuoso.jdbc3.VirtuosoResultSetMetaData;
import virtuoso.jdbc3.VirtuosoRow;
import virtuoso.jdbc3.VirtuosoStatement;
import virtuoso.jdbc3.VirtuosoTypes;

public class VirtuosoResultSet
implements ResultSet {
    private static final String er1 = "I/O error on output stream.";
    protected Vector rows = new Vector(20);
    private Object[] row;
    private int concurrency;
    private int fetchDirection;
    private int prefetch;
    private int type;
    private VirtuosoStatement statement;
    private boolean is_prepared;
    protected VirtuosoResultSetMetaData metaData;
    private int maxRows;
    protected int totalRows;
    private boolean is_complete;
    private int updateCount;
    private String cursorName;
    protected int currentRow;
    protected int stmt_current_of;
    protected int stmt_n_rows_to_get;
    protected boolean stmt_co_last_in_batch;
    private int oldRow;
    private boolean wasNull = false;
    private boolean rowIsDeleted = false;
    private boolean rowIsUpdated = false;
    private boolean rowIsInserted = false;
    private boolean more_result;
    protected boolean isLastResult = false;
    protected boolean isLastRow = false;
    private int kindop;
    private VirtuosoPreparedStatement pstmt;
    private int rowNum = 0;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;

    VirtuosoResultSet(VirtuosoStatement statement, VirtuosoResultSetMetaData metaData, boolean isPrepare) throws VirtuosoException {
        this.statement = statement;
        this.metaData = metaData;
        this.fetchDirection = statement.getFetchDirection();
        this.concurrency = statement.getResultSetConcurrency();
        this.type = statement.getResultSetType();
        this.prefetch = statement.getFetchSize();
        this.maxRows = statement.getMaxRows();
        this.cursorName = statement.cursorName == null ? statement.statid : statement.cursorName;
        this.stmt_current_of = -1;
        this.stmt_n_rows_to_get = this.prefetch;
        this.stmt_co_last_in_batch = false;
        this.is_prepared = isPrepare;
        this.process_result(isPrepare);
    }

    VirtuosoResultSet(VirtuosoConnection vc) throws VirtuosoException {
        this.statement = new VirtuosoStatement(vc);
        this.metaData = new VirtuosoResultSetMetaData(null, vc);
        this.type = 1003;
        this.is_complete = true;
    }

    protected VirtuosoResultSet(VirtuosoConnection vc, String[] col_names, int[] col_dtps) throws VirtuosoException {
        this.statement = new VirtuosoStatement(vc);
        this.metaData = new VirtuosoResultSetMetaData(vc, col_names, col_dtps);
        this.type = 1003;
        this.is_complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreResults(boolean isPrepare) throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            this.is_complete = false;
            this.rowIsInserted = false;
            this.rowIsUpdated = false;
            this.rowIsDeleted = false;
            this.currentRow = 0;
            if (this.rows == null) {
                this.rows = new Vector(20);
            } else {
                this.rows.removeAllElements();
            }
            this.process_result(isPrepare);
            this.more_result = true;
        }
    }

    protected int getUpdateCount() {
        return this.updateCount;
    }

    protected void setUpdateCount(int n) {
        this.updateCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch_rpc() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] args = new Object[]{this.statement.statid, new Long(this.statement.future.hashCode())};
                this.statement.connection.removeFuture(this.statement.connection.getFuture("FTCH", args, this.statement.rpc_timeout));
            }
        }
        catch (IOException e) {
            throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extended_fetch(int op, long firstline, long nbline) throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] args = new Object[]{this.statement.statid, new Long(op), new Long(firstline), new Long(nbline), new Long(this.statement.connection.getAutoCommit() ? 1L : 0L), null};
                this.statement.future = this.statement.connection.getFuture("EXTF", args, this.statement.rpc_timeout);
                this.getMoreResults(false);
                if (this.statement.connection.getAutoCommit()) {
                    this.process_result(false);
                }
            }
        }
        catch (IOException e) {
            throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_pos(int op, Vector args, long num) throws VirtuosoException {
        if (this.pstmt == null) {
            this.pstmt = (VirtuosoPreparedStatement)this.statement.connection.prepareStatement("__set_pos(?,?,?,?)");
        }
        this.pstmt.setString(1, this.statement.statid);
        this.pstmt.setLong(2, op);
        this.pstmt.setLong(3, num);
        this.pstmt.setVector(4, args);
        this.pstmt.execute();
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            switch (op) {
                case 3: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsDeleted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 2: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsUpdated = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 4: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsInserted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 1: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (this.pstmt.vresultSet.more_result());
                    this.totalRows = this.pstmt.vresultSet.totalRows;
                }
            }
            this.pstmt.vresultSet.rows = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process_result(boolean isPrepare) throws VirtuosoException {
        this.more_result = false;
        int i = 0;
        block19: while (!this.is_complete) {
            if (this.rows.size() == this.statement.getMaxRows() && this.rows.size() > 0) {
                this.is_complete = true;
                continue;
            }
            if (this.statement == null || this.statement.future == null) {
                throw new VirtuosoException("Statement closed. Operation not applicable", -17);
            }
            VirtuosoStatement virtuosoStatement = this.statement;
            synchronized (virtuosoStatement) {
                this.statement.wait_result = true;
            }
            Vector curr = this.statement.future.nextResult();
            virtuosoStatement = this.statement;
            synchronized (virtuosoStatement) {
                this.statement.wait_result = false;
            }
            Vector vector = curr = curr == null ? null : curr.firstElement();
            if (curr instanceof Vector) {
                Vector result = curr;
                switch (((Short)result.firstElement()).intValue()) {
                    case 9: {
                        this.statement.connection.qualifier = (String)result.elementAt(1);
                        break;
                    }
                    case 13: {
                        if (this.statement.type != 1003) {
                            this.is_complete = true;
                        } else {
                            this.stmt_co_last_in_batch = true;
                        }
                    }
                    case 1: {
                        this.isLastRow = false;
                        result.removeElementAt(0);
                        this.fixReturnedData(result);
                        if (this.currentRow == 0) {
                            this.rows.insertElementAt(new VirtuosoRow(this, result), i++);
                        } else {
                            this.rows.setElementAt(new VirtuosoRow(this, result), this.currentRow - 1);
                        }
                        if (this.statement.type == 1003) {
                            return;
                        }
                        if (i < (this.prefetch == 0 ? 100 : this.prefetch)) continue block19;
                        return;
                    }
                    case 4: {
                        Vector v = (Vector)result.elementAt(1);
                        Number kop = (Number)v.elementAt(1);
                        if (kop == null) {
                            this.kindop = 0;
                            if (this.statement != null && this.statement.getExecType() == 1) {
                                throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                            }
                            if (!(this.statement instanceof VirtuosoPreparedStatement)) {
                                this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(null, this.statement.connection);
                                break;
                            }
                        } else {
                            this.kindop = kop.intValue();
                            if (this.statement != null) {
                                if (this.statement.getExecType() == 0 && this.kindop == 1) {
                                    throw new VirtuosoException("executeUpdate can execute only update/insert/delete queries", -4);
                                }
                                if (this.statement.getExecType() == 1 && this.kindop == 0) {
                                    throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                                }
                            }
                        }
                        if (this.metaData != null) {
                            this.metaData.close();
                        }
                        this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(v, this.statement.connection);
                        if (!(this.statement instanceof PreparedStatement) || !isPrepare) continue block19;
                        Object obj = v.elementAt(3);
                        this.statement.objparams = null;
                        this.statement.paramsMetaData = null;
                        if (obj != null && obj instanceof Vector) {
                            this.fixReturnedData((Vector)obj);
                            this.statement.objparams = (Vector)obj;
                            this.statement.parameters = (Vector)this.statement.objparams.clone();
                            if (this.statement instanceof CallableStatement) {
                                VirtuosoCallableStatement _statement = (VirtuosoCallableStatement)this.statement;
                                _statement.param_type = new int[this.statement.parameters.capacity()];
                                _statement.param_scale = new int[this.statement.parameters.capacity()];
                                for (int _i = 0; _i < _statement.param_type.length; ++_i) {
                                    _statement.param_type[_i] = 1111;
                                    _statement.param_scale[_i] = 0;
                                }
                            }
                            this.is_complete = true;
                            this.statement.paramsMetaData = new VirtuosoParameterMetaData((Vector)obj, this.statement.connection);
                            break;
                        }
                        this.statement.parameters = null;
                        break;
                    }
                    case 7: {
                        if (this.type != 1003) {
                            this.totalRows = ((Number)result.elementAt(1)).intValue();
                            this.updateCount = 0;
                            this.is_complete = true;
                        } else {
                            this.updateCount = ((Number)result.elementAt(1)).intValue();
                            this.is_complete = true;
                        }
                        this.isLastRow = true;
                        if (this.kindop == 2) continue block19;
                        this.isLastResult = true;
                        break;
                    }
                    case 12: {
                        result.removeElementAt(0);
                        this.rows.removeElementAt(this.currentRow - 1);
                        --this.totalRows;
                        break;
                    }
                    case 11: {
                        result.removeElementAt(0);
                        result.removeElementAt(result.size() - 1);
                        this.fixReturnedData(result);
                        this.rows.setElementAt(new VirtuosoRow(this, result), this.currentRow - 1);
                        break;
                    }
                    case 3: {
                        if (VirtuosoFuture.rpc_log != null) {
                            VirtuosoFuture.rpc_log.println("---> QA_ERROR err=[" + (String)result.elementAt(2) + "] stat=[" + (String)result.elementAt(1) + "]");
                        }
                        this.isLastResult = true;
                        this.isLastRow = true;
                        throw new VirtuosoException((String)result.elementAt(2), (String)result.elementAt(1), -8);
                    }
                    case 14: {
                        this.statement.connection.setWarning(new SQLWarning((String)result.elementAt(2), (String)result.elementAt(1), -8));
                        break;
                    }
                    case 6: {
                        if (this.statement.objparams == null) {
                            this.statement.objparams = new Vector(result.size() - 2);
                        }
                        for (int j = 0; j < this.statement.objparams.size() && j + 2 < result.size(); ++j) {
                            Object val = result.elementAt(j + 2);
                            if (val instanceof DateObject) {
                                this.statement.objparams.setElementAt(((DateObject)val).getValue(this.statement.sparql_executed), j);
                                continue;
                            }
                            this.statement.objparams.setElementAt(val, j);
                        }
                        this.is_complete = true;
                        this.isLastResult = true;
                        this.isLastRow = true;
                        break;
                    }
                    case 5: {
                        this.sendBlobData(result);
                        break;
                    }
                    default: {
                        throw new VirtuosoException(((Object)curr).toString(), -16);
                    }
                }
                continue;
            }
            this.isLastRow = true;
            if (this.kindop != 2) {
                this.isLastResult = true;
            }
            if (curr == null) {
                this.more_result = true;
                this.is_complete = true;
                continue;
            }
            if ((Short)((Object)curr) != 0 && (Short)((Object)curr) != 100) continue;
            this.is_complete = true;
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    void fixReturnedData(Vector data) {
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            Object val = data.elementAt(i);
            if (!(val instanceof DateObject)) continue;
            data.setElementAt(((DateObject)val).getValue(this.statement.sparql_executed), i);
        }
    }

    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    public void clearWarnings() throws VirtuosoException {
    }

    public int getType() throws VirtuosoException {
        return this.type;
    }

    public int getConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    public void setFetchDirection(int direction) throws VirtuosoException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws VirtuosoException {
        if (rows < 0 || rows > this.statement.getMaxRows()) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = rows == 0 ? 100 : rows;
    }

    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    public Statement getStatement() throws VirtuosoException {
        return this.statement;
    }

    public ResultSetMetaData getMetaData() throws VirtuosoException {
        return this.metaData;
    }

    protected int kindop() throws VirtuosoException {
        return this.kindop;
    }

    protected boolean more_result() throws VirtuosoException {
        return this.more_result;
    }

    public int findColumn(String name) throws VirtuosoException {
        if (name == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        Integer i = (Integer)this.metaData.hcolumns.get(new VirtuosoColumn(name, 182, this.statement.connection));
        if (i == null) {
            throw new VirtuosoException("findColumn() can't found column with name '" + name + "' in resultSet", "S0022", -17);
        }
        return i + 1;
    }

    public boolean wasNull() throws VirtuosoException {
        return this.wasNull;
    }

    public String getString(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getString(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getByte(columnIndex);
    }

    public short getShort(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getShort(columnIndex);
    }

    public int getInt(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getLong(columnIndex);
    }

    public float getFloat(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDouble(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws VirtuosoException {
        return this.getBigDecimal(columnIndex).setScale(scale, 7);
    }

    public byte[] getBytes(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBytes(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBigDecimal(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getAsciiStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws VirtuosoException {
        return this.getAsciiStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBinaryStream(columnIndex);
    }

    public Reader getCharacterStream(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getCharacterStream(columnIndex);
    }

    public String getString(String columnName) throws VirtuosoException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws VirtuosoException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws VirtuosoException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws VirtuosoException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws VirtuosoException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws VirtuosoException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws VirtuosoException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws VirtuosoException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) throws VirtuosoException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(String columnName) throws VirtuosoException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws VirtuosoException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws VirtuosoException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws VirtuosoException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getObject(columnIndex);
    }

    public Object getObject(String columnName) throws VirtuosoException {
        return this.getObject(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex) throws VirtuosoException {
        return this.getDate(columnIndex, null);
    }

    public Time getTime(int columnIndex) throws VirtuosoException {
        return this.getTime(columnIndex, null);
    }

    public Timestamp getTimestamp(int columnIndex) throws VirtuosoException {
        return this.getTimestamp(columnIndex, null);
    }

    public Date getDate(int columnIndex, Calendar cal) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Date date = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDate(columnIndex);
        if (cal != null && date != null) {
            date = new Date(VirtuosoTypes.timeToCal(date, cal));
        }
        return date;
    }

    public Time getTime(int columnIndex, Calendar cal) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Time _time = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTime(columnIndex);
        if (cal != null && _time != null) {
            _time = new Time(VirtuosoTypes.timeToCal(_time, cal));
        }
        return _time;
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws VirtuosoException {
        Timestamp val;
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Timestamp _ts = val = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTimestamp(columnIndex);
        if (cal != null && _ts != null) {
            _ts = new Timestamp(VirtuosoTypes.timeToCal(_ts, cal));
        }
        if (_ts != null) {
            _ts.setNanos(val.getNanos());
        }
        return _ts;
    }

    public Date getDate(String columnName) throws VirtuosoException {
        return this.getDate(this.findColumn(columnName), null);
    }

    public Time getTime(String columnName) throws VirtuosoException {
        return this.getTime(this.findColumn(columnName), null);
    }

    public Timestamp getTimestamp(String columnName) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(columnName), null);
    }

    public void updateNull(String columnName) throws VirtuosoException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws VirtuosoException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws VirtuosoException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws VirtuosoException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws VirtuosoException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws VirtuosoException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws VirtuosoException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws VirtuosoException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws VirtuosoException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws VirtuosoException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws VirtuosoException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws VirtuosoException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws VirtuosoException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws VirtuosoException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws VirtuosoException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws VirtuosoException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws VirtuosoException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws VirtuosoException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws VirtuosoException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public Object getObject(String columnName, Map map) throws VirtuosoException {
        return this.getObject(this.findColumn(columnName), map);
    }

    public Ref getRef(String columnName) throws VirtuosoException {
        return this.getRef(this.findColumn(columnName));
    }

    public Blob getBlob(String columnName) throws VirtuosoException {
        return this.getBlob(this.findColumn(columnName));
    }

    public Clob getClob(String columnName) throws VirtuosoException {
        return this.getClob(this.findColumn(columnName));
    }

    public Array getArray(String columnName) throws VirtuosoException {
        return this.getArray(this.findColumn(columnName));
    }

    public Date getDate(String columnName, Calendar cal) throws VirtuosoException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(String columnName, Calendar cal) throws VirtuosoException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    protected void wasNull(boolean flag) {
        this.wasNull = flag;
    }

    public void close() throws VirtuosoException {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
        if (this.rows != null) {
            this.rows.removeAllElements();
        }
        if (this.statement != null && !this.is_prepared) {
            this.statement.close_rs(false);
            this.statement = null;
        }
        this.row = null;
        this.cursorName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws VirtuosoException {
        try {
            int nextRow = this.currentRow + 1;
            if (this.statement == null) {
                throw new VirtuosoException("Activity on a closed statement 1", "IM001", -8);
            }
            if (this.statement.isClosed()) {
                throw new VirtuosoException("Activity on a closed statement 2", "IM001", -8);
            }
            if (this.type == 1003) {
                if (this.rowNum >= this.maxRows && this.maxRows > 0) {
                    return false;
                }
                while (true) {
                    VirtuosoConnection virtuosoConnection = this.statement.connection;
                    synchronized (virtuosoConnection) {
                        if (this.is_complete) {
                            return false;
                        }
                        Object elt = this.rows.firstElement();
                        if (this.currentRow == 0 && elt != null) {
                            ++this.stmt_current_of;
                            ++this.currentRow;
                            ++this.rowNum;
                            return true;
                        }
                        if ((this.stmt_co_last_in_batch || this.stmt_current_of == this.stmt_n_rows_to_get - 1) && this.metaData != null && this.kindop == 1) {
                            this.rows.removeElementAt(1);
                            this.fetch_rpc();
                            this.stmt_current_of = -1;
                            this.stmt_co_last_in_batch = false;
                        }
                        this.process_result(false);
                    }
                    this.currentRow = 0;
                }
            }
            if (nextRow > 0 && nextRow <= this.rows.size()) {
                this.currentRow = nextRow;
                return true;
            }
            if (this.type == 1003) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            if (this.type == 1004 && this.getRow() == this.totalRows) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            this.extended_fetch(1, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 1;
                return false;
            }
            this.currentRow = 1;
            return true;
        }
        catch (Throwable e) {
            this.statement.notify_error(e);
            return false;
        }
    }

    public int getRow() throws VirtuosoException {
        if (this.currentRow > 0 && this.currentRow <= this.rows.size()) {
            int r = this.type == 1004 ? ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getRow() : (this.type == 1005 ? ((Number)((Vector)((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBookmark().elementAt(1)).elementAt(0)).intValue() : (this.type == 1003 ? this.rowNum : 0));
            if (r == 0) {
                return this.currentRow;
            }
            return r;
        }
        return this.currentRow;
    }

    public boolean previous() throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't access to the previous row, the type is forward only.", -12);
        }
        if (this.currentRow == 0) {
            return false;
        }
        int previousRow = this.currentRow - 1;
        if (previousRow > 0 && previousRow <= this.rows.size()) {
            this.currentRow = previousRow;
            return true;
        }
        if (this.type == 1004 && this.getRow() == 1) {
            this.currentRow = 0;
            return false;
        }
        if (this.type == 1004) {
            int book = this.getRow();
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                if (this.rows.elementAt(i) == null || ((VirtuosoRow)this.rows.elementAt(i)).getRow() != book) continue;
                this.currentRow = i;
                return true;
            }
        }
        if (this.type == 1005) {
            VirtuosoRow row = (VirtuosoRow)this.rows.elementAt(this.currentRow - 1);
            Vector book = null;
            if (row != null) {
                book = row.getBookmark();
            }
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            if (book != null) {
                for (int i = this.rows.size() - 1; i >= 0; --i) {
                    if (this.rows.elementAt(i) == null || !((VirtuosoRow)this.rows.elementAt(i)).getBookmark().equals(book)) continue;
                    this.currentRow = i;
                    return true;
                }
            }
        }
        this.currentRow = this.rows.size();
        return true;
    }

    public void beforeFirst() throws VirtuosoException {
        this.absolute(1);
        this.previous();
    }

    public void afterLast() throws VirtuosoException {
        this.absolute(-1);
        this.next();
    }

    public boolean first() throws VirtuosoException {
        return this.absolute(1);
    }

    public boolean isBeforeFirst() throws VirtuosoException {
        return this.getRow() == 0;
    }

    public boolean isAfterLast() throws VirtuosoException {
        return this.getRow() == this.rows.size() + 1;
    }

    public boolean isFirst() throws VirtuosoException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws VirtuosoException {
        return this.getRow() == this.totalRows;
    }

    public boolean last() throws VirtuosoException {
        return this.absolute(-1);
    }

    public boolean absolute(int row) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(5, row, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = row > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    public boolean relative(int row) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(6, row, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = row > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    public String getCursorName() throws VirtuosoException {
        return this.cursorName;
    }

    public Blob getBlob(int i) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBlob(i);
    }

    public Clob getClob(int i) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getClob(i);
    }

    public boolean rowUpdated() throws VirtuosoException {
        return this.rowIsUpdated;
    }

    public boolean rowInserted() throws VirtuosoException {
        return this.rowIsInserted;
    }

    public boolean rowDeleted() throws VirtuosoException {
        return this.rowIsDeleted;
    }

    public void updateNull(int columnIndex) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = null;
    }

    public void updateBoolean(int columnIndex, boolean x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Boolean(x);
    }

    public void updateByte(int columnIndex, byte x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Byte(x);
    }

    public void updateShort(int columnIndex, short x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Short(x);
    }

    public void updateInt(int columnIndex, int x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Integer(x);
    }

    public void updateLong(int columnIndex, long x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Long(x);
    }

    public void updateFloat(int columnIndex, float x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Float(x);
    }

    public void updateDouble(int columnIndex, double x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Double(x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    public void updateString(int columnIndex, String x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    public void updateBytes(int columnIndex, byte[] x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        try {
            this.row[columnIndex - 1] = new String(x, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (x == null) {
                this.row[columnIndex - 1] = new String(x);
            }
            char[] chars = new char[x.length];
            for (int i = 0; i < x.length; ++i) {
                chars[i] = (char)x[i];
            }
            this.row[columnIndex - 1] = new String(chars);
        }
    }

    public void updateDate(int columnIndex, Date x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    public void updateTime(int columnIndex, Time x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null || length < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, (long)length, (long)(columnIndex - 1));
        this.pstmt.objparams.setElementAt(this.row[columnIndex - 1], columnIndex - 1);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null || length < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, (long)length, (long)(columnIndex - 1));
        this.pstmt.objparams.setElementAt(this.row[columnIndex - 1], columnIndex - 1);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null || length < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setReader(x, length);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, (long)length, (long)(columnIndex - 1));
        this.pstmt.objparams.setElementAt(this.row[columnIndex - 1], columnIndex - 1);
    }

    public void updateObject(int columnIndex, Object x) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setObject(x);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, columnIndex - 1);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws VirtuosoException {
        this.updateObject(columnIndex, x);
    }

    public void cancelRowUpdates() throws VirtuosoException {
        if (this.row != null) {
            this.row = null;
        }
    }

    public void insertRow() throws VirtuosoException {
        Object[] obj = new Object[]{new Vector(this.row)};
        this.set_pos(4, new Vector(obj), 0L);
        this.row = null;
    }

    public void updateRow() throws VirtuosoException {
        if (this.currentRow < 0 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        if (this.currentRow != 0) {
            this.set_pos(2, new Vector(this.row), this.currentRow);
            this.row = null;
        } else if (this.oldRow != 0) {
            this.insertRow();
        }
    }

    public void deleteRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(3, null, this.currentRow);
    }

    public void refreshRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(1, null, this.currentRow);
    }

    public void moveToInsertRow() throws VirtuosoException {
        if (this.oldRow == 0) {
            this.oldRow = this.getRow();
            this.currentRow = 0;
        }
    }

    public void moveToCurrentRow() throws VirtuosoException {
        if (this.oldRow != 0) {
            this.absolute(this.oldRow);
            this.oldRow = 0;
        }
    }

    public Object getObject(int i, Map map) throws VirtuosoException {
        return null;
    }

    public Ref getRef(int i) throws VirtuosoException {
        return null;
    }

    public Array getArray(int i) throws VirtuosoException {
        return null;
    }

    protected void sendBlobData(Vector result) throws VirtuosoException {
        try {
            int off;
            int index = ((Number)result.elementAt(1)).intValue();
            VirtuosoBlob blob = (VirtuosoBlob)this.statement.objparams.elementAt(index);
            Reader rd = blob.getCharacterStream();
            long pos = 0L;
            int dtp = 182;
            if (this.statement.parameters != null && this.statement.parameters.elementAt(index) instanceof Vector) {
                Vector pd = (Vector)this.statement.parameters.elementAt(index);
                dtp = ((Number)pd.elementAt(0)).intValue();
                dtp = dtp == 131 ? 222 : (dtp == 132 ? 225 : 182);
            }
            char[] _obj = new char[8192];
            do {
                int read;
                off = 0;
                while (off < 8192 && (long)off < blob.length() - pos && (read = rd.read(_obj, off, (int)(blob.length() - pos < (long)(8192 - off) ? blob.length() - pos : (long)(8192 - off)))) != -1) {
                    off += read;
                    pos += (long)read;
                }
                if (off <= 0) continue;
                Object toSend = dtp == 222 ? new String(_obj, 0, off) : new VirtuosoExplicitString(new String(_obj, 0, off), dtp, this.statement.connection);
                this.statement.connection.write_object(toSend);
            } while (off > 0);
            byte[] end = new byte[]{0};
            this.statement.connection.write_bytes(end);
        }
        catch (IOException e) {
            throw new VirtuosoException(er1, -3);
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof VirtuosoResultSet;
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    public URL getURL(String columnName) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new VirtuosoException("SQL REF not supported", -7);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new VirtuosoException("SQL REF not supported", -7);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateBinaryStream(columnIndex, x.getBinaryStream(), (int)x.length());
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBinaryStream(columnName, x.getBinaryStream(), (int)x.length());
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateCharacterStream(columnIndex, x.getCharacterStream(), (int)x.length());
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateCharacterStream(columnName, x.getCharacterStream(), (int)x.length());
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new VirtuosoException("Arrays not supported", -7);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new VirtuosoException("Arrays not supported", -7);
    }
}

