/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import virtuoso.javax.BaseRowSet;
import virtuoso.javax.OPLMessage_x;

public class OPLJdbcRowSet
extends BaseRowSet {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private boolean doDisconnect = false;

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    private Connection connect() throws SQLException {
        String connName = this.getDataSourceName();
        if (connName != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource ds = (DataSource)initialcontext.lookup(connName);
                return ds.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException e) {
                throw OPLMessage_x.makeException(e);
            }
        }
        connName = this.getUrl();
        if (connName != null) {
            return DriverManager.getConnection(connName, this.getUsername(), this.getPassword());
        }
        return null;
    }

    private void setParams(PreparedStatement pstmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        block14: for (int i = 0; i < params.length; ++i) {
            BaseRowSet.Parameter par = (BaseRowSet.Parameter)params[i];
            switch (par.jType) {
                case 0: {
                    pstmt.setObject(i + 1, par.value);
                    continue block14;
                }
                case 1: {
                    pstmt.setObject(i + 1, par.value, par.sqlType);
                    continue block14;
                }
                case 2: {
                    pstmt.setObject(i + 1, par.value, par.sqlType, par.scale);
                    continue block14;
                }
                case 3: {
                    pstmt.setAsciiStream(i + 1, (InputStream)par.value, par.length);
                    continue block14;
                }
                case 4: {
                    pstmt.setBinaryStream(i + 1, (InputStream)par.value, par.length);
                    continue block14;
                }
                case 5: {
                    pstmt.setUnicodeStream(i + 1, (InputStream)par.value, par.length);
                    continue block14;
                }
                case 6: {
                    pstmt.setCharacterStream(i + 1, (Reader)par.value, par.length);
                    continue block14;
                }
                case 7: {
                    pstmt.setDate(i + 1, (Date)par.value, par.cal);
                    continue block14;
                }
                case 8: {
                    pstmt.setTime(i + 1, (Time)par.value, par.cal);
                    continue block14;
                }
                case 9: {
                    pstmt.setTimestamp(i + 1, (Timestamp)par.value, par.cal);
                    continue block14;
                }
                case 10: {
                    pstmt.setNull(i + 1, par.sqlType);
                    continue block14;
                }
                case 11: {
                    pstmt.setNull(i + 1, par.sqlType, par.typeName);
                    continue block14;
                }
                default: {
                    throw OPLMessage_x.makeException(10);
                }
            }
        }
    }

    public synchronized void execute() throws SQLException {
        if (this.conn == null) {
            this.conn = this.connect();
            this.doDisconnect = true;
        }
        if (this.conn == null || this.getCommand() == null) {
            throw OPLMessage_x.makeException(11);
        }
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (Exception e) {
            // empty catch block
        }
        PreparedStatement pstmt = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        this.setParams(pstmt, this.getParams());
        try {
            pstmt.setMaxRows(this.getMaxRows());
            pstmt.setMaxFieldSize(this.getMaxFieldSize());
            pstmt.setEscapeProcessing(this.getEscapeProcessing());
            pstmt.setQueryTimeout(this.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = pstmt.executeQuery();
        this.notifyListener(3);
    }

    public void execute(Connection _conn) throws SQLException {
        this.conn = _conn;
        this.execute();
    }

    public synchronized void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && this.doDisconnect) {
            this.conn.close();
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.check_close();
        this.rs.cancelRowUpdates();
        this.notifyListener(2);
    }

    public synchronized boolean next() throws SQLException {
        this.check_close();
        boolean ret = this.rs.next();
        this.notifyListener(1);
        return ret;
    }

    public synchronized boolean previous() throws SQLException {
        this.check_close();
        boolean ret = this.rs.previous();
        this.notifyListener(1);
        return ret;
    }

    public synchronized boolean first() throws SQLException {
        this.check_close();
        boolean ret = this.rs.first();
        this.notifyListener(1);
        return ret;
    }

    public synchronized boolean last() throws SQLException {
        this.check_close();
        boolean ret = this.rs.last();
        this.notifyListener(1);
        return ret;
    }

    public synchronized boolean absolute(int row) throws SQLException {
        this.check_close();
        boolean ret = this.rs.absolute(row);
        this.notifyListener(1);
        return ret;
    }

    public synchronized boolean relative(int rows) throws SQLException {
        this.check_close();
        boolean ret = this.rs.relative(rows);
        this.notifyListener(1);
        return ret;
    }

    public synchronized void beforeFirst() throws SQLException {
        this.check_close();
        this.rs.beforeFirst();
        this.notifyListener(1);
    }

    public synchronized void afterLast() throws SQLException {
        this.check_close();
        this.rs.afterLast();
        this.notifyListener(1);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.check_close();
        return this.rs.isBeforeFirst();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        this.check_close();
        return this.rs.isAfterLast();
    }

    public synchronized boolean isFirst() throws SQLException {
        this.check_close();
        return this.rs.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        this.check_close();
        return this.rs.isLast();
    }

    public synchronized int getRow() throws SQLException {
        this.check_close();
        return this.rs.getRow();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        this.check_close();
        return this.rs.rowUpdated();
    }

    public synchronized boolean rowInserted() throws SQLException {
        this.check_close();
        return this.rs.rowInserted();
    }

    public synchronized boolean rowDeleted() throws SQLException {
        this.check_close();
        return this.rs.rowDeleted();
    }

    public synchronized void refreshRow() throws SQLException {
        this.check_close();
        this.rs.refreshRow();
    }

    public synchronized void insertRow() throws SQLException {
        this.check_close();
        this.rs.insertRow();
        this.notifyListener(2);
    }

    public synchronized void updateRow() throws SQLException {
        this.check_close();
        this.rs.updateRow();
        this.notifyListener(2);
    }

    public synchronized void deleteRow() throws SQLException {
        this.check_close();
        this.rs.deleteRow();
        this.notifyListener(2);
    }

    public synchronized void moveToInsertRow() throws SQLException {
        this.check_close();
        this.rs.moveToInsertRow();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.check_close();
        this.rs.moveToCurrentRow();
    }

    public synchronized boolean wasNull() throws SQLException {
        this.check_close();
        return this.rs.wasNull();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.check_close();
        return this.rs.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.check_close();
        this.rs.clearWarnings();
    }

    public synchronized String getCursorName() throws SQLException {
        this.check_close();
        return this.rs.getCursorName();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        return this.rs.getMetaData();
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        this.check_close();
        return this.rs.findColumn(columnName);
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getString(columnIndex);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(columnIndex);
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getByte(columnIndex);
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getShort(columnIndex);
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getInt(columnIndex);
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getLong(columnIndex);
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getFloat(columnIndex);
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getDouble(columnIndex);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnIndex);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnIndex, scale);
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBytes(columnIndex);
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnIndex);
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnIndex);
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnIndex);
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(columnIndex);
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(columnIndex);
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(columnIndex);
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getObject(columnIndex);
    }

    public synchronized String getString(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getString(columnName);
    }

    public synchronized boolean getBoolean(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(columnName);
    }

    public synchronized byte getByte(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getByte(columnName);
    }

    public synchronized short getShort(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getShort(columnName);
    }

    public synchronized int getInt(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getInt(columnName);
    }

    public synchronized long getLong(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getLong(columnName);
    }

    public synchronized float getFloat(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getFloat(columnName);
    }

    public synchronized double getDouble(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getDouble(columnName);
    }

    public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnName, scale);
    }

    public synchronized byte[] getBytes(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBytes(columnName);
    }

    public synchronized Date getDate(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnName);
    }

    public synchronized Time getTime(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnName);
    }

    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnName);
    }

    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(columnName);
    }

    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(columnName);
    }

    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(columnName);
    }

    public synchronized Object getObject(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getObject(columnName);
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(columnIndex);
    }

    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(columnName);
    }

    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnName);
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.check_close();
        this.rs.updateNull(columnIndex);
    }

    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(columnIndex, x);
    }

    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.check_close();
        this.rs.updateByte(columnIndex, x);
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.check_close();
        this.rs.updateShort(columnIndex, x);
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.check_close();
        this.rs.updateInt(columnIndex, x);
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.check_close();
        this.rs.updateLong(columnIndex, x);
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.check_close();
        this.rs.updateFloat(columnIndex, x);
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.check_close();
        this.rs.updateDouble(columnIndex, x);
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(columnIndex, x);
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.check_close();
        this.rs.updateString(columnIndex, x);
    }

    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.check_close();
        this.rs.updateBytes(columnIndex, x);
    }

    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.check_close();
        this.rs.updateDate(columnIndex, x);
    }

    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.check_close();
        this.rs.updateTime(columnIndex, x);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(columnIndex, x);
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnIndex, x, length);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnIndex, x, length);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnIndex, x, length);
    }

    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnIndex, x, scale);
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnIndex, x);
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.check_close();
        this.rs.updateNull(columnName);
    }

    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(columnName, x);
    }

    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.check_close();
        this.rs.updateByte(columnName, x);
    }

    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.check_close();
        this.rs.updateShort(columnName, x);
    }

    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.check_close();
        this.rs.updateInt(columnName, x);
    }

    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.check_close();
        this.rs.updateLong(columnName, x);
    }

    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.check_close();
        this.rs.updateFloat(columnName, x);
    }

    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.check_close();
        this.rs.updateDouble(columnName, x);
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(columnName, x);
    }

    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.check_close();
        this.rs.updateString(columnName, x);
    }

    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.check_close();
        this.rs.updateBytes(columnName, x);
    }

    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.check_close();
        this.rs.updateDate(columnName, x);
    }

    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.check_close();
        this.rs.updateTime(columnName, x);
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(columnName, x);
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnName, x, length);
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnName, x, length);
    }

    public synchronized void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnName, x, length);
    }

    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnName, x, scale);
    }

    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnName, x);
    }

    public synchronized Statement getStatement() throws SQLException {
        this.check_close();
        return this.rs.getStatement();
    }

    public synchronized Object getObject(int colIndex, Map map) throws SQLException {
        this.check_close();
        return this.rs.getObject(colIndex, map);
    }

    public synchronized Ref getRef(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getRef(colIndex);
    }

    public synchronized Blob getBlob(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getBlob(colIndex);
    }

    public synchronized Clob getClob(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getClob(colIndex);
    }

    public synchronized Array getArray(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getArray(colIndex);
    }

    public synchronized Object getObject(String colName, Map map) throws SQLException {
        this.check_close();
        return this.rs.getObject(colName, map);
    }

    public synchronized Ref getRef(String colName) throws SQLException {
        this.check_close();
        return this.rs.getRef(colName);
    }

    public synchronized Blob getBlob(String colName) throws SQLException {
        this.check_close();
        return this.rs.getBlob(colName);
    }

    public synchronized Clob getClob(String colName) throws SQLException {
        this.check_close();
        return this.rs.getClob(colName);
    }

    public synchronized Array getArray(String colName) throws SQLException {
        this.check_close();
        return this.rs.getArray(colName);
    }

    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnIndex, cal);
    }

    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnName, cal);
    }

    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnIndex, cal);
    }

    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnName, cal);
    }

    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnIndex, cal);
    }

    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnName, cal);
    }

    public synchronized URL getURL(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getURL(columnIndex);
    }

    public synchronized URL getURL(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getURL(columnName);
    }

    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        this.check_close();
        this.rs.updateRef(columnIndex, x);
    }

    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        this.check_close();
        this.rs.updateRef(columnName, x);
    }

    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnIndex, x);
    }

    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnName, x);
    }

    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnIndex, x);
    }

    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnName, x);
    }

    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        this.check_close();
        this.rs.updateArray(columnIndex, x);
    }

    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        this.check_close();
        this.rs.updateArray(columnName, x);
    }

    private void check_close() throws SQLException {
        if (this.rs == null) {
            throw OPLMessage_x.makeException(7);
        }
    }
}

