/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import openlink.util.Vector;
import virtuoso.jdbc4.DateObject;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoCallableStatement;
import virtuoso.jdbc4.VirtuosoColumn;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoExplicitString;
import virtuoso.jdbc4.VirtuosoFNSException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoParameterMetaData;
import virtuoso.jdbc4.VirtuosoPreparedStatement;
import virtuoso.jdbc4.VirtuosoResultSetMetaData;
import virtuoso.jdbc4.VirtuosoRow;
import virtuoso.jdbc4.VirtuosoStatement;
import virtuoso.jdbc4.VirtuosoTypes;

public class VirtuosoResultSet
implements ResultSet {
    private static final String er1 = "I/O error on output stream.";
    protected Vector rows = new Vector(20);
    private Object[] row;
    private int concurrency;
    private int fetchDirection;
    private int prefetch;
    private int type;
    private VirtuosoStatement statement;
    private boolean is_prepared;
    protected VirtuosoResultSetMetaData metaData;
    private int maxRows;
    protected int totalRows;
    private boolean is_complete;
    private int updateCount;
    private String cursorName;
    protected int currentRow;
    protected int stmt_current_of;
    protected int stmt_n_rows_to_get;
    protected boolean stmt_co_last_in_batch;
    private int oldRow;
    private boolean wasNull = false;
    private boolean rowIsDeleted = false;
    private boolean rowIsUpdated = false;
    private boolean rowIsInserted = false;
    private boolean more_result;
    protected boolean isLastResult = false;
    protected boolean isLastRow = false;
    private int kindop;
    private VirtuosoPreparedStatement pstmt;
    private int rowNum = 0;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;

    VirtuosoResultSet(VirtuosoStatement statement, VirtuosoResultSetMetaData metaData, boolean isPrepare) throws VirtuosoException {
        this.statement = statement;
        this.metaData = metaData;
        this.fetchDirection = statement.getFetchDirection();
        this.concurrency = statement.getResultSetConcurrency();
        this.type = statement.getResultSetType();
        this.prefetch = statement.getFetchSize();
        this.maxRows = statement.getMaxRows();
        this.cursorName = statement.cursorName == null ? statement.statid : statement.cursorName;
        this.stmt_current_of = -1;
        this.stmt_n_rows_to_get = this.prefetch;
        this.stmt_co_last_in_batch = false;
        this.is_prepared = isPrepare;
        this.process_result(isPrepare);
    }

    VirtuosoResultSet(VirtuosoConnection vc) throws VirtuosoException {
        this.statement = new VirtuosoStatement(vc);
        this.metaData = new VirtuosoResultSetMetaData(null, vc);
        this.type = 1003;
        this.is_complete = true;
    }

    protected VirtuosoResultSet(VirtuosoConnection vc, String[] col_names, int[] col_dtps) throws VirtuosoException {
        this.statement = new VirtuosoStatement(vc);
        this.metaData = new VirtuosoResultSetMetaData(vc, col_names, col_dtps);
        this.type = 1003;
        this.is_complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreResults(boolean isPrepare) throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            this.is_complete = false;
            this.rowIsInserted = false;
            this.rowIsUpdated = false;
            this.rowIsDeleted = false;
            this.currentRow = 0;
            if (this.rows == null) {
                this.rows = new Vector(20);
            } else {
                this.rows.removeAllElements();
            }
            this.process_result(isPrepare);
            this.more_result = true;
        }
    }

    protected int getUpdateCount() {
        return this.updateCount;
    }

    protected void setUpdateCount(int n) {
        this.updateCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch_rpc() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] args = new Object[]{this.statement.statid, new Long(this.statement.future.hashCode())};
                this.statement.connection.removeFuture(this.statement.connection.getFuture("FTCH", args, this.statement.rpc_timeout));
            }
        }
        catch (IOException e) {
            throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extended_fetch(int op, long firstline, long nbline) throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.statement.connection;
            synchronized (virtuosoConnection) {
                Object[] args = new Object[]{this.statement.statid, new Long(op), new Long(firstline), new Long(nbline), new Long(this.statement.connection.getAutoCommit() ? 1L : 0L), null};
                this.statement.future = this.statement.connection.getFuture("EXTF", args, this.statement.rpc_timeout);
                this.getMoreResults(false);
                if (this.statement.connection.getAutoCommit()) {
                    this.process_result(false);
                }
            }
        }
        catch (IOException e) {
            throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_pos(int op, Vector args, long num) throws VirtuosoException {
        if (this.pstmt == null) {
            this.pstmt = (VirtuosoPreparedStatement)this.statement.connection.prepareStatement("__set_pos(?,?,?,?)");
        }
        this.pstmt.setString(1, this.statement.statid);
        this.pstmt.setLong(2, op);
        this.pstmt.setLong(3, num);
        this.pstmt.setVector(4, args);
        this.pstmt.execute();
        VirtuosoConnection virtuosoConnection = this.statement.connection;
        synchronized (virtuosoConnection) {
            switch (op) {
                case 3: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsDeleted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 2: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsUpdated = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 4: {
                    do {
                        this.pstmt.vresultSet.getMoreResults(false);
                    } while (!this.pstmt.vresultSet.isLastRow && this.isLastResult);
                    this.rowIsInserted = this.pstmt.vresultSet.getUpdateCount() > 0;
                    break;
                }
                case 1: {
                    this.pstmt.vresultSet.metaData = this.metaData;
                    this.pstmt.vresultSet.rows = this.rows;
                    this.pstmt.vresultSet.totalRows = this.totalRows;
                    this.pstmt.vresultSet.currentRow = this.currentRow;
                    do {
                        this.pstmt.vresultSet.more_result = false;
                        this.pstmt.vresultSet.is_complete = false;
                        this.pstmt.vresultSet.process_result(false);
                    } while (this.pstmt.vresultSet.more_result());
                    this.totalRows = this.pstmt.vresultSet.totalRows;
                }
            }
            this.pstmt.vresultSet.rows = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process_result(boolean isPrepare) throws VirtuosoException {
        this.more_result = false;
        int i = 0;
        block19: while (!this.is_complete) {
            if (this.rows.size() == this.statement.getMaxRows() && this.rows.size() > 0) {
                this.is_complete = true;
                continue;
            }
            if (this.statement == null || this.statement.future == null) {
                throw new VirtuosoException("Statement closed. Operation not applicable", -17);
            }
            VirtuosoStatement virtuosoStatement = this.statement;
            synchronized (virtuosoStatement) {
                this.statement.wait_result = true;
            }
            Vector curr = this.statement.future.nextResult();
            virtuosoStatement = this.statement;
            synchronized (virtuosoStatement) {
                this.statement.wait_result = false;
            }
            Vector vector = curr = curr == null ? null : curr.firstElement();
            if (curr instanceof Vector) {
                Vector result = curr;
                switch (((Short)result.firstElement()).intValue()) {
                    case 9: {
                        this.statement.connection.qualifier = (String)result.elementAt(1);
                        break;
                    }
                    case 13: {
                        if (this.statement.type != 1003) {
                            this.is_complete = true;
                        } else {
                            this.stmt_co_last_in_batch = true;
                        }
                    }
                    case 1: {
                        this.isLastRow = false;
                        result.removeElementAt(0);
                        this.fixReturnedData(result);
                        if (this.currentRow == 0) {
                            this.rows.insertElementAt(new VirtuosoRow(this, result), i++);
                        } else {
                            this.rows.setElementAt(new VirtuosoRow(this, result), this.currentRow - 1);
                        }
                        if (this.statement.type == 1003) {
                            return;
                        }
                        if (i < (this.prefetch == 0 ? 100 : this.prefetch)) continue block19;
                        return;
                    }
                    case 4: {
                        Vector v = (Vector)result.elementAt(1);
                        Number kop = (Number)v.elementAt(1);
                        if (kop == null) {
                            this.kindop = 0;
                            if (this.statement != null && this.statement.getExecType() == 1) {
                                throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                            }
                            if (!(this.statement instanceof VirtuosoPreparedStatement)) {
                                this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(null, this.statement.connection);
                                break;
                            }
                        } else {
                            this.kindop = kop.intValue();
                            if (this.statement != null) {
                                if (this.statement.getExecType() == 0 && this.kindop == 1) {
                                    throw new VirtuosoException("executeUpdate can execute only update/insert/delete queries", -4);
                                }
                                if (this.statement.getExecType() == 1 && this.kindop == 0) {
                                    throw new VirtuosoException("executeUpdate can't execute update/insert/delete queries", -4);
                                }
                            }
                        }
                        if (this.metaData != null) {
                            this.metaData.close();
                        }
                        this.statement.metaData = this.metaData = new VirtuosoResultSetMetaData(v, this.statement.connection);
                        if (!(this.statement instanceof PreparedStatement) || !isPrepare) continue block19;
                        Object obj = v.elementAt(3);
                        this.statement.objparams = null;
                        this.statement.paramsMetaData = null;
                        if (obj != null && obj instanceof Vector) {
                            this.fixReturnedData((Vector)obj);
                            this.statement.objparams = (Vector)obj;
                            this.statement.parameters = (Vector)this.statement.objparams.clone();
                            if (this.statement instanceof CallableStatement) {
                                VirtuosoCallableStatement _statement = (VirtuosoCallableStatement)this.statement;
                                _statement.param_type = new int[this.statement.parameters.capacity()];
                                _statement.param_scale = new int[this.statement.parameters.capacity()];
                                for (int _i = 0; _i < _statement.param_type.length; ++_i) {
                                    _statement.param_type[_i] = 1111;
                                    _statement.param_scale[_i] = 0;
                                }
                            }
                            this.is_complete = true;
                            this.statement.paramsMetaData = new VirtuosoParameterMetaData((Vector)obj, this.statement.connection);
                            break;
                        }
                        this.statement.parameters = null;
                        break;
                    }
                    case 7: {
                        if (this.type != 1003) {
                            this.totalRows = ((Number)result.elementAt(1)).intValue();
                            this.updateCount = 0;
                            this.is_complete = true;
                        } else {
                            this.updateCount = ((Number)result.elementAt(1)).intValue();
                            this.is_complete = true;
                        }
                        this.isLastRow = true;
                        if (this.kindop == 2) continue block19;
                        this.isLastResult = true;
                        break;
                    }
                    case 12: {
                        result.removeElementAt(0);
                        this.rows.removeElementAt(this.currentRow - 1);
                        --this.totalRows;
                        break;
                    }
                    case 11: {
                        result.removeElementAt(0);
                        result.removeElementAt(result.size() - 1);
                        this.fixReturnedData(result);
                        this.rows.setElementAt(new VirtuosoRow(this, result), this.currentRow - 1);
                        break;
                    }
                    case 3: {
                        if (VirtuosoFuture.rpc_log != null) {
                            VirtuosoFuture.rpc_log.println("---> QA_ERROR err=[" + (String)result.elementAt(2) + "] stat=[" + (String)result.elementAt(1) + "]");
                        }
                        this.isLastResult = true;
                        this.isLastRow = true;
                        throw new VirtuosoException((String)result.elementAt(2), (String)result.elementAt(1), -8);
                    }
                    case 14: {
                        this.statement.connection.setWarning(new SQLWarning((String)result.elementAt(2), (String)result.elementAt(1), -8));
                        break;
                    }
                    case 6: {
                        if (this.statement.objparams == null) {
                            this.statement.objparams = new Vector(result.size() - 2);
                        }
                        for (int j = 0; j < this.statement.objparams.size() && j + 2 < result.size(); ++j) {
                            Object val = result.elementAt(j + 2);
                            if (val instanceof DateObject) {
                                this.statement.objparams.setElementAt(((DateObject)val).getValue(this.statement.sparql_executed), j);
                                continue;
                            }
                            this.statement.objparams.setElementAt(val, j);
                        }
                        this.is_complete = true;
                        this.isLastResult = true;
                        this.isLastRow = true;
                        break;
                    }
                    case 5: {
                        this.sendBlobData(result);
                        break;
                    }
                    default: {
                        throw new VirtuosoException(((Object)curr).toString(), -16);
                    }
                }
                continue;
            }
            this.isLastRow = true;
            if (this.kindop != 2) {
                this.isLastResult = true;
            }
            if (curr == null) {
                this.more_result = true;
                this.is_complete = true;
                continue;
            }
            if ((Short)((Object)curr) != 0 && (Short)((Object)curr) != 100) continue;
            this.is_complete = true;
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    void fixReturnedData(Vector data) {
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            Object val = data.elementAt(i);
            if (!(val instanceof DateObject)) continue;
            data.setElementAt(((DateObject)val).getValue(this.statement.sparql_executed), i);
        }
    }

    @Override
    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    @Override
    public void clearWarnings() throws VirtuosoException {
    }

    @Override
    public int getType() throws VirtuosoException {
        return this.type;
    }

    @Override
    public int getConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    @Override
    public void setFetchDirection(int direction) throws VirtuosoException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws VirtuosoException {
        if (rows < 0 || rows > this.statement.getMaxRows()) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = rows == 0 ? 100 : rows;
    }

    @Override
    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    @Override
    public Statement getStatement() throws VirtuosoException {
        return this.statement;
    }

    @Override
    public ResultSetMetaData getMetaData() throws VirtuosoException {
        return this.metaData;
    }

    protected int kindop() throws VirtuosoException {
        return this.kindop;
    }

    protected boolean more_result() throws VirtuosoException {
        return this.more_result;
    }

    @Override
    public int findColumn(String name) throws VirtuosoException {
        if (name == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        Integer i = this.metaData.hcolumns.get(new VirtuosoColumn(name, 182, this.statement.connection));
        if (i == null) {
            throw new VirtuosoException("findColumn() can't found column with name '" + name + "' in resultSet", "S0022", -17);
        }
        return i + 1;
    }

    @Override
    public boolean wasNull() throws VirtuosoException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws VirtuosoException {
        return this.getBigDecimal(columnIndex).setScale(scale, 7);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBytes(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBigDecimal(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws VirtuosoException {
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBinaryStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getCharacterStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws VirtuosoException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws VirtuosoException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws VirtuosoException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws VirtuosoException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws VirtuosoException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws VirtuosoException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws VirtuosoException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws VirtuosoException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws VirtuosoException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws VirtuosoException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws VirtuosoException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws VirtuosoException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws VirtuosoException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws VirtuosoException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int columnIndex) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws VirtuosoException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex) throws VirtuosoException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws VirtuosoException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws VirtuosoException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Date date = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getDate(columnIndex);
        if (cal != null && date != null) {
            date = new Date(VirtuosoTypes.timeToCal(date, cal));
        }
        return date;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Time _time = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTime(columnIndex);
        if (cal != null && _time != null) {
            _time = new Time(VirtuosoTypes.timeToCal(_time, cal));
        }
        return _time;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws VirtuosoException {
        Timestamp val;
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        Timestamp _ts = val = ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getTimestamp(columnIndex);
        if (cal != null && _ts != null) {
            _ts = new Timestamp(VirtuosoTypes.timeToCal(_ts, cal));
        }
        if (_ts != null) {
            _ts.setNanos(val.getNanos());
        }
        return _ts;
    }

    @Override
    public Date getDate(String columnName) throws VirtuosoException {
        return this.getDate(this.findColumn(columnName), null);
    }

    @Override
    public Time getTime(String columnName) throws VirtuosoException {
        return this.getTime(this.findColumn(columnName), null);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(columnName), null);
    }

    @Override
    public void updateNull(String columnName) throws VirtuosoException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws VirtuosoException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws VirtuosoException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws VirtuosoException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws VirtuosoException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws VirtuosoException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws VirtuosoException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws VirtuosoException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws VirtuosoException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws VirtuosoException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws VirtuosoException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws VirtuosoException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws VirtuosoException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws VirtuosoException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws VirtuosoException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws VirtuosoException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws VirtuosoException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws VirtuosoException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws VirtuosoException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public Object getObject(String columnName, Map map) throws VirtuosoException {
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public Ref getRef(String columnName) throws VirtuosoException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(String columnName) throws VirtuosoException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(String columnName) throws VirtuosoException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Array getArray(String columnName) throws VirtuosoException {
        return this.getArray(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws VirtuosoException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws VirtuosoException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws VirtuosoException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    protected void wasNull(boolean flag) {
        this.wasNull = flag;
    }

    @Override
    public void close() throws VirtuosoException {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
        if (this.rows != null) {
            this.rows.removeAllElements();
        }
        if (this.statement != null && this.isLastResult && this.statement.closeOnCompletion) {
            this.statement.close();
            this.statement = null;
        }
        if (this.statement != null && !this.is_prepared) {
            this.statement.close_rs(false);
            this.statement = null;
        }
        this.row = null;
        this.cursorName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws VirtuosoException {
        try {
            int nextRow = this.currentRow + 1;
            if (this.statement == null) {
                throw new VirtuosoException("Activity on a closed statement 1", "IM001", -8);
            }
            if (this.statement.isClosed()) {
                throw new VirtuosoException("Activity on a closed statement 2", "IM001", -8);
            }
            if (this.type == 1003) {
                if (this.rowNum >= this.maxRows && this.maxRows > 0) {
                    return false;
                }
                while (true) {
                    VirtuosoConnection virtuosoConnection = this.statement.connection;
                    synchronized (virtuosoConnection) {
                        if (this.is_complete) {
                            return false;
                        }
                        Object elt = this.rows.firstElement();
                        if (this.currentRow == 0 && elt != null) {
                            ++this.stmt_current_of;
                            ++this.currentRow;
                            ++this.rowNum;
                            return true;
                        }
                        if ((this.stmt_co_last_in_batch || this.stmt_current_of == this.stmt_n_rows_to_get - 1) && this.metaData != null && this.kindop == 1) {
                            this.rows.removeElementAt(1);
                            this.fetch_rpc();
                            this.stmt_current_of = -1;
                            this.stmt_co_last_in_batch = false;
                        }
                        this.process_result(false);
                    }
                    this.currentRow = 0;
                }
            }
            if (nextRow > 0 && nextRow <= this.rows.size()) {
                this.currentRow = nextRow;
                return true;
            }
            if (this.type == 1003) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            if (this.type == 1004 && this.getRow() == this.totalRows) {
                this.currentRow = this.rows.size() + 1;
                return false;
            }
            this.extended_fetch(1, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 1;
                return false;
            }
            this.currentRow = 1;
            return true;
        }
        catch (Throwable e) {
            this.statement.notify_error(e);
            return false;
        }
    }

    @Override
    public int getRow() throws VirtuosoException {
        if (this.currentRow > 0 && this.currentRow <= this.rows.size()) {
            int r = this.type == 1004 ? ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getRow() : (this.type == 1005 ? ((Number)((Vector)((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBookmark().elementAt(1)).elementAt(0)).intValue() : (this.type == 1003 ? this.rowNum : 0));
            if (r == 0) {
                return this.currentRow;
            }
            return r;
        }
        return this.currentRow;
    }

    @Override
    public boolean previous() throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't access to the previous row, the type is forward only.", -12);
        }
        if (this.currentRow == 0) {
            return false;
        }
        int previousRow = this.currentRow - 1;
        if (previousRow > 0 && previousRow <= this.rows.size()) {
            this.currentRow = previousRow;
            return true;
        }
        if (this.type == 1004 && this.getRow() == 1) {
            this.currentRow = 0;
            return false;
        }
        if (this.type == 1004) {
            int book = this.getRow();
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                if (this.rows.elementAt(i) == null || ((VirtuosoRow)this.rows.elementAt(i)).getRow() != book) continue;
                this.currentRow = i;
                return true;
            }
        }
        if (this.type == 1005) {
            VirtuosoRow row = (VirtuosoRow)this.rows.elementAt(this.currentRow - 1);
            Vector book = null;
            if (row != null) {
                book = row.getBookmark();
            }
            this.extended_fetch(4, 0L, this.prefetch == 0 ? 100L : (long)this.prefetch);
            if (this.rows.size() == 0) {
                this.currentRow = 0;
                return false;
            }
            if (book != null) {
                for (int i = this.rows.size() - 1; i >= 0; --i) {
                    if (this.rows.elementAt(i) == null || !((VirtuosoRow)this.rows.elementAt(i)).getBookmark().equals(book)) continue;
                    this.currentRow = i;
                    return true;
                }
            }
        }
        this.currentRow = this.rows.size();
        return true;
    }

    @Override
    public void beforeFirst() throws VirtuosoException {
        this.absolute(1);
        this.previous();
    }

    @Override
    public void afterLast() throws VirtuosoException {
        this.absolute(-1);
        this.next();
    }

    @Override
    public boolean first() throws VirtuosoException {
        return this.absolute(1);
    }

    @Override
    public boolean isBeforeFirst() throws VirtuosoException {
        return this.getRow() == 0;
    }

    @Override
    public boolean isAfterLast() throws VirtuosoException {
        return this.getRow() == this.rows.size() + 1;
    }

    @Override
    public boolean isFirst() throws VirtuosoException {
        return this.getRow() == 1;
    }

    @Override
    public boolean isLast() throws VirtuosoException {
        return this.getRow() == this.totalRows;
    }

    @Override
    public boolean last() throws VirtuosoException {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int row) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(5, row, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = row > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    @Override
    public boolean relative(int row) throws VirtuosoException {
        if (this.type == 1003) {
            throw new VirtuosoException("Can't go before the first row, the type is forward only.", -12);
        }
        this.extended_fetch(6, row, this.prefetch == 0 ? 100L : (long)this.prefetch);
        if (this.rows.size() == 0) {
            this.currentRow = row > 0 ? 0 : 1;
            return false;
        }
        this.currentRow = 1;
        return true;
    }

    @Override
    public String getCursorName() throws VirtuosoException {
        return this.cursorName;
    }

    @Override
    public Blob getBlob(int i) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getBlob(i);
    }

    @Override
    public Clob getClob(int i) throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getClob(i);
    }

    @Override
    public boolean rowUpdated() throws VirtuosoException {
        return this.rowIsUpdated;
    }

    @Override
    public boolean rowInserted() throws VirtuosoException {
        return this.rowIsInserted;
    }

    @Override
    public boolean rowDeleted() throws VirtuosoException {
        return this.rowIsDeleted;
    }

    @Override
    public void updateNull(int columnIndex) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = null;
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Boolean(x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Byte(x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Short(x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Integer(x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Long(x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Float(x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = new Double(x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    @Override
    public void updateString(int columnIndex, String x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        try {
            this.row[columnIndex - 1] = new String(x, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            if (x == null) {
                this.row[columnIndex - 1] = new String(x);
            }
            char[] chars = new char[x.length];
            for (int i = 0; i < x.length; ++i) {
                chars[i] = (char)x[i];
            }
            this.row[columnIndex - 1] = new String(chars);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws VirtuosoException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null || length < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, (long)length, (long)(columnIndex - 1));
        this.pstmt.objparams.setElementAt(this.row[columnIndex - 1], columnIndex - 1);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null || length < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setInputStream(x, length);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, (long)length, (long)(columnIndex - 1));
        this.pstmt.objparams.setElementAt(this.row[columnIndex - 1], columnIndex - 1);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null || length < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setReader(x, length);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, (long)length, (long)(columnIndex - 1));
        this.pstmt.objparams.setElementAt(this.row[columnIndex - 1], columnIndex - 1);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws VirtuosoException {
        Object _obj;
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (x == null) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        if ((_obj = this.row[columnIndex - 1]) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)_obj).setObject(x);
            return;
        }
        this.row[columnIndex - 1] = new VirtuosoBlob(x, columnIndex - 1);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws VirtuosoException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void cancelRowUpdates() throws VirtuosoException {
        if (this.row != null) {
            this.row = null;
        }
    }

    @Override
    public void insertRow() throws VirtuosoException {
        Object[] obj = new Object[]{new Vector(this.row)};
        this.set_pos(4, new Vector(obj), 0L);
        this.row = null;
    }

    @Override
    public void updateRow() throws VirtuosoException {
        if (this.currentRow < 0 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        if (this.currentRow != 0) {
            this.set_pos(2, new Vector(this.row), this.currentRow);
            this.row = null;
        } else if (this.oldRow != 0) {
            this.insertRow();
        }
    }

    @Override
    public void deleteRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(3, null, this.currentRow);
    }

    @Override
    public void refreshRow() throws VirtuosoException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        this.set_pos(1, null, this.currentRow);
    }

    @Override
    public void moveToInsertRow() throws VirtuosoException {
        if (this.oldRow == 0) {
            this.oldRow = this.getRow();
            this.currentRow = 0;
        }
    }

    @Override
    public void moveToCurrentRow() throws VirtuosoException {
        if (this.oldRow != 0) {
            this.absolute(this.oldRow);
            this.oldRow = 0;
        }
    }

    public Object getObject(int i, Map map) throws VirtuosoException {
        return null;
    }

    @Override
    public Ref getRef(int i) throws VirtuosoException {
        return null;
    }

    @Override
    public Array getArray(int i) throws VirtuosoException {
        return null;
    }

    protected void sendBlobData(Vector result) throws VirtuosoException {
        try {
            int off;
            int index = ((Number)result.elementAt(1)).intValue();
            VirtuosoBlob blob = (VirtuosoBlob)this.statement.objparams.elementAt(index);
            Reader rd = blob.getCharacterStream();
            long pos = 0L;
            int dtp = 182;
            if (this.statement.parameters != null && this.statement.parameters.elementAt(index) instanceof Vector) {
                Vector pd = (Vector)this.statement.parameters.elementAt(index);
                dtp = ((Number)pd.elementAt(0)).intValue();
                dtp = dtp == 131 ? 222 : (dtp == 132 ? 225 : 182);
            }
            char[] _obj = new char[8192];
            do {
                int read;
                off = 0;
                while (off < 8192 && (long)off < blob.length() - pos && (read = rd.read(_obj, off, (int)(blob.length() - pos < (long)(8192 - off) ? blob.length() - pos : (long)(8192 - off)))) != -1) {
                    off += read;
                    pos += (long)read;
                }
                if (off <= 0) continue;
                Object toSend = dtp == 222 ? new String(_obj, 0, off) : new VirtuosoExplicitString(new String(_obj, 0, off), dtp, this.statement.connection);
                this.statement.connection.write_object(toSend);
            } while (off > 0);
            byte[] end = new byte[]{0};
            this.statement.connection.write_bytes(end);
        }
        catch (IOException e) {
            throw new VirtuosoException(er1, -3);
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof VirtuosoResultSet;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new VirtuosoException("SQL REF not supported", -7);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new VirtuosoException("SQL REF not supported", -7);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateBinaryStream(columnIndex, x.getBinaryStream(), (int)x.length());
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBinaryStream(columnName, x.getBinaryStream(), (int)x.length());
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateCharacterStream(columnIndex, x.getCharacterStream(), (int)x.length());
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateCharacterStream(columnName, x.getCharacterStream(), (int)x.length());
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new VirtuosoException("Arrays not supported", -7);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new VirtuosoException("Arrays not supported", -7);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new VirtuosoFNSException("getRowId(columnIndex)  not supported", -7);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new VirtuosoFNSException("getRowId(columnLabel)  not supported", -7);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new VirtuosoFNSException("updateRowId(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new VirtuosoFNSException("updateRowId(columnLabel, x)  not supported", -7);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new VirtuosoFNSException("getHoldability()  not supported", -7);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement == null || this.statement.future == null;
    }

    @Override
    public synchronized void updateNString(int columnIndex, String x) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.metaData.getColumnCount()) {
            throw new VirtuosoException("Index " + columnIndex + " is not 1<n<" + this.metaData.getColumnCount(), -4);
        }
        if (this.row == null) {
            this.row = new Object[this.metaData.getColumnCount()];
            if (this.currentRow >= 1 && this.currentRow <= this.rows.size()) {
                ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getContent(this.row);
            }
        }
        this.row[columnIndex - 1] = x;
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnLabel), nString);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateCharacterStream(columnIndex, nClob.getCharacterStream(), (int)nClob.length());
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public synchronized NClob getNClob(int columnIndex) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new VirtuosoFNSException("getSQLXML(columnIndex)  not supported", -7);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new VirtuosoFNSException("getSQLXML(String columnLabel)  not supported", -7);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new VirtuosoFNSException("updateSQLXML(columnIndex, xmlObject)  not supported", -7);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new VirtuosoFNSException("updateSQLXML(columnLabel, xmlObject)  not supported", -7);
    }

    @Override
    public synchronized String getNString(int columnIndex) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public synchronized Reader getNCharacterStream(int columnIndex) throws SQLException {
        if (this.currentRow < 1 || this.currentRow > this.rows.size()) {
            throw new VirtuosoException("Bad current row selected : " + this.currentRow + " not in 1<n<" + this.rows.size(), -4);
        }
        return ((VirtuosoRow)this.rows.elementAt(this.currentRow - 1)).getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, (int)length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (int)length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (int)length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new VirtuosoFNSException("updateNCharacterStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNCharacterStream(columnLabel, reader)  not supported", -7);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new VirtuosoFNSException("updateAsciiStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new VirtuosoFNSException("updateBinaryStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new VirtuosoFNSException("updateCharacterStream(columnIndex, x)  not supported", -7);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new VirtuosoFNSException("updateAsciiStream(columnLabel, x)  not supported", -7);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new VirtuosoFNSException("updateBinaryStream(columnLabel, x)  not supported", -7);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateCharacterStream(columnLabel, reader)  not supported", -7);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateBlob(columnIndex, inputStream)  not supported", -7);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("updateBlob(columnLabel, inputStream)  not supported", -7);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateClob(columnIndex,  reader)  not supported", -7);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateClob(columnLabel,  reader)  not supported", -7);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNClob(columnIndex,  reader)  not supported", -7);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("updateNClob(columnLabel,  reader)  not supported", -7);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Unable to unwrap to " + iface.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new VirtuosoException("Type parameter can not be null", "S1009", -4);
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob(columnIndex);
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob(columnIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(columnIndex);
        }
        if (type.equals(Ref.class)) {
            return (T)this.getRef(columnIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(columnIndex);
        }
        try {
            return (T)this.getObject(columnIndex);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Conversion not supported for type " + type.getName(), "S1009", -4);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }
}

