/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.List;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtuosoQueryExecution;

public class VirtuosoQueryExecutionFactory {
    private VirtuosoQueryExecutionFactory() {
    }

    public static VirtuosoQueryExecution create(Query query, VirtGraph graph) {
        VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query, graph);
        return ret;
    }

    public static VirtuosoQueryExecution create(String query, VirtGraph graph) {
        VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query, graph);
        return ret;
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query.toString(), (VirtGraph)dataset);
            return ret;
        }
        return VirtuosoQueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(queryStr, (VirtGraph)dataset);
            return ret;
        }
        return VirtuosoQueryExecutionFactory.make(VirtuosoQueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(Query query, Model model) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        VirtuosoQueryExecutionFactory.checkArg(model);
        if (model.getGraph() instanceof VirtGraph) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query.toString(), (VirtGraph)model.getGraph());
            return ret;
        }
        return VirtuosoQueryExecutionFactory.make(query, (Dataset)new DatasetImpl(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        VirtuosoQueryExecutionFactory.checkArg(queryStr);
        VirtuosoQueryExecutionFactory.checkArg(model);
        if (model.getGraph() instanceof VirtGraph) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(queryStr, (VirtGraph)model.getGraph());
            return ret;
        }
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(Query query, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryExecution qe = VirtuosoQueryExecutionFactory.make(query);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(queryStr);
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryExecution qe = VirtuosoQueryExecutionFactory.make(query, dataset);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(queryStr);
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    public static QueryExecution sparqlService(String service, Query query) {
        VirtuosoQueryExecutionFactory.checkNotNull(service, "URL for service is null");
        VirtuosoQueryExecutionFactory.checkArg(query);
        return VirtuosoQueryExecutionFactory.makeServiceRequest(service, query);
    }

    public static QueryExecution sparqlService(String service, Query query, String defaultGraph) {
        VirtuosoQueryExecutionFactory.checkNotNull(service, "URL for service is null");
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryEngineHTTP qe = VirtuosoQueryExecutionFactory.makeServiceRequest(service, query);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryExecution sparqlService(String service, Query query, List defaultGraphURIs, List namedGraphURIs) {
        VirtuosoQueryExecutionFactory.checkNotNull(service, "URL for service is null");
        VirtuosoQueryExecutionFactory.checkArg(query);
        QueryEngineHTTP qe = VirtuosoQueryExecutionFactory.makeServiceRequest(service, query);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create((String)queryStr);
    }

    private static QueryExecution make(Query query) {
        return VirtuosoQueryExecutionFactory.make(query, null);
    }

    private static QueryExecution make(Query query, Dataset dataset) {
        return VirtuosoQueryExecutionFactory.make(query, dataset, null);
    }

    private static QueryExecution make(Query query, Dataset dataset, Context context) {
        return null;
    }

    private static QueryEngineHTTP makeServiceRequest(String service, Query query) {
        return new QueryEngineHTTP(service, query);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        VirtuosoQueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        VirtuosoQueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query) {
        VirtuosoQueryExecutionFactory.checkNotNull(query, "Query is null");
    }
}

