/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.jdbc4.VirtuosoXAResource;

public class VirtuosoXAConnection
implements XAConnection {
    private VirtuosoPooledConnection pconn;
    private VirtuosoXAResource resource;

    protected VirtuosoXAConnection(VirtuosoPooledConnection connection, String server, int port) throws SQLException {
        this.pconn = connection;
        this.pconn.getVirtuosoConnection().xa_connection = this;
        this.resource = new VirtuosoXAResource(this.pconn, server, port);
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("new VirtuosoXAConnection (connection=" + connection.hashCode() + ") :" + this.hashCode() + ")");
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.getVirtuosoXAResource();
    }

    VirtuosoXAResource getVirtuosoXAResource() throws VirtuosoException {
        if (this.pconn.isClosed()) {
            throw new VirtuosoException("Connection is closed.", -1);
        }
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAConnection.getVirtuosoXAResource () ret " + this.resource.hashCode() + " :" + this.hashCode());
        }
        return this.resource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.pconn.isClosed()) {
            throw new VirtuosoException("Connection is closed.", -1);
        }
        ConnectionWrapper conn = (ConnectionWrapper)this.pconn.getConnection();
        conn.setXAResource(this.resource);
        return conn;
    }

    @Override
    public void close() throws SQLException {
        this.pconn.close();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.pconn.addConnectionEventListener(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.pconn.removeConnectionEventListener(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }
}

