/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import virtuoso.jdbc4.VirtuosoDate;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoTime;
import virtuoso.jdbc4.VirtuosoTimestamp;

class VirtuosoTypes {
    public static final String version = "05.12.3039";
    public static final int DV_NULL = 180;
    public static final int DV_SHORT_STRING_SERIAL = 181;
    public static final int DV_BIN = 222;
    public static final int DV_STRICT_STRING = 238;
    public static final int DV_STRING = 182;
    public static final int DV_LONG_BIN = 223;
    public static final int DV_WIDE = 225;
    public static final int DV_LONG_WIDE = 226;
    public static final int DV_C_STRING = 183;
    public static final int DV_C_SHORT = 184;
    public static final int DV_STRING_SESSION = 185;
    public static final int DV_SHORT_CONT_STRING = 186;
    public static final int DV_LONG_CONT_STRING = 187;
    public static final int DV_SHORT_INT = 188;
    public static final int DV_LONG_INT = 189;
    public static final int DV_INT64 = 247;
    public static final int DV_SINGLE_FLOAT = 190;
    public static final int DV_DOUBLE_FLOAT = 191;
    public static final int DV_CHARACTER = 192;
    public static final int DV_NUMERIC = 219;
    public static final int DV_ARRAY_OF_POINTER = 193;
    public static final int DV_ARRAY_OF_LONG_PACKED = 194;
    public static final int DV_ARRAY_OF_FLOAT = 202;
    public static final int DV_ARRAY_OF_DOUBLE = 195;
    public static final int DV_ARRAY_OF_LONG = 209;
    public static final int DV_LIST_OF_POINTER = 196;
    public static final int DV_OBJECT_AND_CLASS = 197;
    public static final int DV_OBJECT_REFERENCE = 198;
    public static final int DV_DELETED = 199;
    public static final int DV_OBJECT = 254;
    public static final int UDT_JAVA_CLIENT_OBJECT_ID = -1;
    public static final int DV_MEMBER_POINTER = 200;
    public static final int DV_C_INT = 201;
    public static final int DV_CUSTOM = 203;
    public static final int DV_DB_NULL = 204;
    public static final int DV_G_REF_CLASS = 205;
    public static final int DV_G_REF = 206;
    public static final int DV_BOX_FLAGS = 207;
    public static final int DV_BLOB = 125;
    public static final int DV_BLOB_HANDLE = 126;
    public static final int DV_BLOB_WIDE_HANDLE = 133;
    public static final int DV_BLOB_BIN = 131;
    public static final int DV_BLOB_WIDE = 132;
    public static final int DV_SYMBOL = 127;
    public static final int DV_TIMESTAMP = 128;
    public static final int DV_DATE = 129;
    public static final int DV_TIMESTAMP_OBJ = 208;
    public static final int DV_TIME = 210;
    public static final int DV_DATETIME = 211;
    public static final int DV_ANY = 242;
    public static final int DV_IRI_ID = 243;
    public static final int DV_IRI_ID_8 = 244;
    public static final int DV_RDF = 246;
    public static final int DV_GEO = 238;
    public static final int DA_FUTURE_REQUEST = 1;
    public static final int DA_FUTURE_ANSWER = 2;
    public static final int DA_FUTURE_PARTIAL_ANSWER = 3;
    public static final int DA_DIRECT_IO_FUTURE_REQUEST = 4;
    public static final int DA_CALLER_IDENTIFICATION = 5;
    public static final int QA_ROW = 1;
    public static final int QA_ERROR = 3;
    public static final int QA_COMPILED = 4;
    public static final int QA_NEED_DATA = 5;
    public static final int QA_PROC_RETURN = 6;
    public static final int QA_ROWS_AFFECTED = 7;
    public static final int QA_BLOB_POS = 8;
    public static final int QA_LOGIN = 9;
    public static final int QA_ROW_ADDED = 10;
    public static final int QA_ROW_UPDATED = 11;
    public static final int QA_ROW_DELETED = 12;
    public static final int QA_ROW_LAST_IN_BATCH = 13;
    public static final int QA_WARNING = 14;
    public static final int QT_UNKNOWN = -1;
    public static final int QT_UPDATE = 0;
    public static final int QT_SELECT = 1;
    public static final int QT_PROC_CALL = 2;
    public static final int SQL_CURSOR_FORWARD_ONLY = 0;
    public static final int SQL_CURSOR_KEYSET_DRIVEN = 1;
    public static final int SQL_CURSOR_DYNAMIC = 2;
    public static final int SQL_CURSOR_STATIC = 3;
    public static final int SQL_FETCH_NEXT = 1;
    public static final int SQL_FETCH_FIRST = 2;
    public static final int SQL_FETCH_LAST = 3;
    public static final int SQL_FETCH_PRIOR = 4;
    public static final int SQL_FETCH_ABSOLUTE = 5;
    public static final int SQL_FETCH_RELATIVE = 6;
    public static final int SQL_FETCH_BOOKMARK = 8;
    public static final int SQL_POSITION = 0;
    public static final int SQL_REFRESH = 1;
    public static final int SQL_UPDATE = 2;
    public static final int SQL_DELETE = 3;
    public static final int SQL_ADD = 4;
    public static final int SQL_TXN_READ_UNCOMMITTED = 1;
    public static final int SQL_TXN_READ_COMMITTED = 2;
    public static final int SQL_TXN_REPEATABLE_READ = 4;
    public static final int SQL_TXN_SERIALIZABLE = 8;
    public static final int SQL_TXN_VERSIONING = 16;
    public static final int STAT_DROP = 1;
    public static final int STAT_CLOSE = 0;
    public static final int QC_STATUS = 0;
    public static final int SQL_COMMIT = 0;
    public static final int SQL_ROLLBACK = 1;
    public static final int PAGELEN = 8192;
    public static final int PAGESIZ = 8172;
    public static final int DEFAULTPREFETCH = 100;
    public static final int BYTEARRAY = -1;
    public static final int DT_TYPE_DATE = 2;
    public static final int DT_TYPE_TIME = 3;
    public static final int DT_TYPE_DATETIME = 1;
    public static final int SQL_PARAM_TYPE_UNKNOWN = 0;
    public static final int SQL_PARAM_INPUT = 1;
    public static final int SQL_PARAM_INPUT_OUTPUT = 2;
    public static final int SQL_PARAM_RESULT_COL = 3;
    public static final int SQL_PARAM_OUTPUT = 4;
    public static final int SQL_PARAM_RETURN_VALUE = 5;
    public static final int SQL_CONCUR_READ_ONLY = 1;
    public static final int SQL_CONCUR_LOCK = 2;
    public static final int SQL_CONCUR_ROWVER = 3;
    public static final int SQL_CONCUR_VALUES = 4;
    public static final int NUMERIC_MAX_SCALE = 15;
    public static final int NUMERIC_MAX_PRECISION = 40;
    public static final int CDF_KEY = 1;
    public static final int CDF_AUTOINCREMENT = 2;
    public static final int CDF_XMLTYPE = 4;

    VirtuosoTypes() {
    }

    protected static Object mapJavaTypeToSqlType(Object x, int targetSqlType) throws VirtuosoException {
        return VirtuosoTypes.mapJavaTypeToSqlType(x, targetSqlType, 0, false);
    }

    protected static Object mapJavaTypeToSqlType(Object x, int targetSqlType, int scale) throws VirtuosoException {
        return VirtuosoTypes.mapJavaTypeToSqlType(x, targetSqlType, scale, true);
    }

    protected static Object mapJavaTypeToSqlType(Object x, int targetSqlType, int scale, boolean useScale) throws VirtuosoException {
        if (x == null) {
            return x;
        }
        if (x instanceof Boolean) {
            x = new Integer((Boolean)x != false ? 1 : 0);
        }
        switch (targetSqlType) {
            case 1: 
            case 12: {
                if (x instanceof String) {
                    return x;
                }
                return x.toString();
            }
            case -1: {
                if (x instanceof Clob || x instanceof Blob || x instanceof String) {
                    return x;
                }
                return x.toString();
            }
            case 91: {
                if (x instanceof VirtuosoDate) {
                    return ((VirtuosoDate)x).clone();
                }
                if (x instanceof VirtuosoTimestamp) {
                    VirtuosoTimestamp _t = (VirtuosoTimestamp)x;
                    return new VirtuosoDate(_t.getTime(), _t.getTimezone(), _t.withTimezone());
                }
                if (x instanceof VirtuosoTime) {
                    VirtuosoTime _t = (VirtuosoTime)x;
                    return new VirtuosoDate(_t.getTime(), _t.getTimezone(), _t.withTimezone());
                }
                if (x instanceof java.sql.Date) {
                    return new java.sql.Date(((java.sql.Date)x).getTime());
                }
                if (x instanceof String) {
                    return VirtuosoTypes.strToDate((String)x);
                }
                if (!(x instanceof Date)) break;
                return new java.sql.Date(((Date)x).getTime());
            }
            case 92: {
                if (x instanceof VirtuosoTime) {
                    return ((VirtuosoTime)x).clone();
                }
                if (x instanceof VirtuosoTimestamp) {
                    VirtuosoTimestamp _t = (VirtuosoTimestamp)x;
                    return new VirtuosoTime(_t.getTime(), _t.getTimezone(), _t.withTimezone());
                }
                if (x instanceof VirtuosoDate) {
                    VirtuosoDate _t = (VirtuosoDate)x;
                    return new VirtuosoTime(_t.getTime(), _t.getTimezone(), _t.withTimezone());
                }
                if (x instanceof Time) {
                    return new Time(((Time)x).getTime());
                }
                if (x instanceof Date) {
                    return new Time(((Date)x).getTime());
                }
                if (!(x instanceof String)) break;
                return VirtuosoTypes.strToTime((String)x);
            }
            case 93: {
                if (x instanceof VirtuosoTimestamp) {
                    return ((VirtuosoTimestamp)x).clone();
                }
                if (x instanceof VirtuosoTime) {
                    VirtuosoTime _t = (VirtuosoTime)x;
                    return new VirtuosoTimestamp(_t.getTime(), _t.getTimezone(), _t.withTimezone());
                }
                if (x instanceof VirtuosoDate) {
                    VirtuosoDate _t = (VirtuosoDate)x;
                    return new VirtuosoTimestamp(_t.getTime(), _t.getTimezone(), _t.withTimezone());
                }
                if (x instanceof Timestamp) {
                    Timestamp val = new Timestamp(((Timestamp)x).getTime());
                    val.setNanos(((Timestamp)x).getNanos());
                    return val;
                }
                if (x instanceof Date) {
                    return new Timestamp(((Date)x).getTime());
                }
                if (!(x instanceof String)) break;
                return VirtuosoTypes.strToTimestamp((String)x);
            }
            case 2: 
            case 3: {
                BigDecimal bd = null;
                if (x instanceof BigDecimal) {
                    bd = (BigDecimal)x;
                } else if (x instanceof String) {
                    bd = new BigDecimal((String)x);
                } else if (x instanceof Number) {
                    bd = new BigDecimal(x.toString());
                }
                if (bd == null || !useScale) break;
                return bd.setScale(scale);
            }
            case -5: {
                if (x instanceof BigDecimal || x instanceof String) {
                    return new Long(x.toString());
                }
                if (!(x instanceof Number)) break;
                return new Long(((Number)x).longValue());
            }
            case 6: 
            case 8: {
                if (x instanceof Double) {
                    return x;
                }
                if (x instanceof Number) {
                    return new Double(((Number)x).doubleValue());
                }
                if (!(x instanceof String)) break;
                return new Double((String)x);
            }
            case 4: {
                if (x instanceof Integer) {
                    return x;
                }
                if (x instanceof Number) {
                    return new Integer(((Number)x).intValue());
                }
                if (!(x instanceof String)) break;
                return new Integer((String)x);
            }
            case 7: {
                if (x instanceof Float) {
                    return x;
                }
                if (x instanceof Number) {
                    return new Float(((Number)x).floatValue());
                }
                if (!(x instanceof String)) break;
                return new Float((String)x);
            }
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                if (x instanceof Short) {
                    return x;
                }
                if (x instanceof String) {
                    return new Short((String)x);
                }
                if (!(x instanceof Number)) break;
                return new Short(((Number)x).shortValue());
            }
            case -8: 
            case 70: 
            case 2001: 
            case 2003: 
            case 2006: {
                throw new VirtuosoException("Type not supported", -7);
            }
            case -3: {
                if (!(x instanceof byte[])) break;
                return x;
            }
            case -4: {
                if (!(x instanceof Blob) && !(x instanceof byte[])) break;
                return x;
            }
            default: {
                return x;
            }
        }
        throw new VirtuosoException("Invalid value specified", -4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long timeToCal(Date value, Calendar target) {
        Date tmp = target.getTime();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(value);
            target.set(11, cal.get(11));
            target.set(12, cal.get(12));
            target.set(13, cal.get(13));
            target.set(14, cal.get(14));
            target.set(1, cal.get(1));
            target.set(2, cal.get(2));
            target.set(5, cal.get(5));
            long l = target.getTime().getTime();
            return l;
        }
        finally {
            target.setTime(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long timeFromCal(Date value, Calendar target) {
        Date tmp = target.getTime();
        try {
            Calendar cal = Calendar.getInstance();
            target.setTime(value);
            cal.set(11, target.get(11));
            cal.set(12, target.get(12));
            cal.set(13, target.get(13));
            cal.set(14, target.get(14));
            cal.set(1, target.get(1));
            cal.set(2, target.get(2));
            cal.set(5, target.get(5));
            long l = cal.getTime().getTime();
            return l;
        }
        finally {
            target.setTime(tmp);
        }
    }

    protected static java.sql.Date strToDate(String s) {
        java.sql.Date dt = null;
        if (s == null) {
            return null;
        }
        try {
            dt = java.sql.Date.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dt == null) {
            try {
                DateFormat df = DateFormat.getDateInstance();
                Date juD = df.parse(s);
                dt = new java.sql.Date(juD.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dt;
    }

    protected static Timestamp strToTimestamp(String s) {
        Timestamp ts = null;
        if (s == null) {
            return null;
        }
        try {
            ts = Timestamp.valueOf(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ts;
    }

    protected static Time strToTime(String s) {
        Time tm = null;
        if (s == null) {
            return null;
        }
        try {
            tm = Time.valueOf(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tm;
    }
}

